
# This file was automatically generated by inc::MyMakeMaker v(dev).
use strict;
use warnings;

use 5.008;

use ExtUtils::MakeMaker;

use lib qw( inc );
use Config::AutoConf;
use Getopt::Long;

my @libs;
my @includes;
GetOptions(
    'lib:s@'     => \@libs,
    'include:s@' => \@includes,
);

@libs = map { '-L' . $_ } @libs;

@includes = map { '-I' . $_ } @includes;

my $ac = Config::AutoConf->new(
    extra_link_flags    => \@libs,
    extra_include_flags => \@includes,
);

unless ( $ac->check_header('magic.h')
    && $ac->check_lib( 'magic', 'magic_open' ) ) {
    warn <<'EOF';

  This module requires the libmagic.so library and magic.h header. See
  INSTALL.md for more details on installing these.

EOF
    exit 0;
}




my %WriteMakefileArgs = (
  "ABSTRACT" => "Determine MIME types of data or files using libmagic",
  "AUTHOR" => "Andreas Fitzner, Michael Hendricks <michael\@ndrix.org>, Dave Rolsky <autarch\@urth.org>",
  "C" => [
    "lib/File/LibMagic.c"
  ],
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker" => 0
  },
  "DISTNAME" => "File-LibMagic",
  "EXE_FILES" => [],
  "INC" => "-I. -Ic",
  "LDFROM" => "LibMagic\$(OBJ_EXT)",
  "LIBS" => [
    "-lmagic"
  ],
  "LICENSE" => "perl",
  "MIN_PERL_VERSION" => "5.008",
  "NAME" => "File::LibMagic",
  "OBJECT" => [
    "lib/File/LibMagic\$(OBJ_EXT)"
  ],
  "PREREQ_PM" => {
    "Carp" => 0,
    "Exporter" => 0,
    "XSLoader" => 0,
    "base" => 0,
    "strict" => 0,
    "warnings" => 0
  },
  "TEST_REQUIRES" => {
    "ExtUtils::MakeMaker" => 0,
    "File::Spec" => 0,
    "IO::Handle" => 0,
    "IPC::Open3" => 0,
    "Test::More" => "0.88",
    "lib" => 0
  },
  "VERSION_FROM" => "lib/File/LibMagic.pm",
  "XS" => {
    "lib/File/LibMagic.xs" => "lib/File/LibMagic.c"
  },
  "test" => {
    "TESTS" => "t/*.t"
  }
);


my %FallbackPrereqs = (
  "Carp" => 0,
  "Exporter" => 0,
  "ExtUtils::MakeMaker" => 0,
  "File::Spec" => 0,
  "IO::Handle" => 0,
  "IPC::Open3" => 0,
  "Test::More" => "0.88",
  "XSLoader" => 0,
  "base" => 0,
  "lib" => 0,
  "strict" => 0,
  "warnings" => 0
);


unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

unshift @{ $WriteMakefileArgs{LIBS} }, @libs;
$WriteMakefileArgs{INC} = join q{ }, @includes, $WriteMakefileArgs{INC};

WriteMakefile(%WriteMakefileArgs);



