package Plack::App::ServiceStatus::DBIC;
use 5.018;
use strict;
use warnings;

our $VERSION = '0.900';

# ABSTRACT: Check DBIC connection

sub check {
    my ( $class, $args ) = @_;
    $args = [$args] unless ref($args) eq 'ARRAY';

    my $dbic  = $args->[0];
    my $query = $args->[1] || 'select 1';
    my $sth   = $dbic->storage->dbh->prepare($query);
    $sth->execute;
    my $ok = $sth->fetchrow_array;
    return 'ok' if $ok == 1;
    return 'nok', "got: $ok";
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Plack::App::ServiceStatus::DBIC - Check DBIC connection

=head1 VERSION

version 0.900

=head1 AUTHOR

Thomas Klausner <domm@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by Thomas Klausner.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
