package Locales::DB::Language::te;

use strict;
use warnings;

# Auto generated from CLDR

$Locales::DB::Language::te::VERSION = '0.09';

$Locales::DB::Language::te::cldr_version = '2.0';

%Locales::DB::Language::te::misc_info = (
    'characters'   => { 'more_information' => "\?" },
    'cldr_formats' => {
        '_decimal_format_decimal' => "\.",
        '_decimal_format_group'   => "\,",
        '_percent_format_percent' => "\%",
        'decimal'                 => "\#\,\#\#\,\#\#0\.\#\#\#",
        'ellipsis'                => {
            'final'   => "\{0\}…",
            'initial' => "…\{0\}",
            'medial'  => "\{0\}…\{1\}"
        },
        'language' => "భాష\:\ \{0\}",
        'list'     => {
            2        => "\{0\}\ మరియు\ \{1\}",
            'end'    => "\{0\}\ మరియు\ \{1\}",
            'middle' => "\{0\}\,\ \{1\}",
            'start'  => "\{0\}\,\ \{1\}"
        },
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#\,\#\#0\%",
        'territory' => "ప్రాంతం\:\ \{0\}"
    },
    'delimiters' => {
        'alternate_quotation_end'   => '’',
        'alternate_quotation_start' => '‘',
        'quotation_end'             => '”',
        'quotation_start'           => '“'
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'plural_forms' => {
        'category_list' => [
            'one',
            'other'
        ],
        'category_rules'          => { 'one' => "n\ is\ 1" },
        'category_rules_compiled' => {
            'one' => sub {
                if ( ( ( $_[0] == 1 ) ) ) { return 'one'; }
                return;
              }
        }
    },
    'posix' => {
        'nostr'  => "వద్దు\:వ",
        'yesstr' => "అవును\:అ"
    },
);

%Locales::DB::Language::te::code_to_name = (
    'aa'    => 'అఫార్',
    'ab'    => 'అబ్ఖాజియన్',
    'ace'   => 'ఆఖినీస్',
    'ach'   => 'అకోలి',
    'ada'   => 'అడాంగ్మే',
    'ady'   => 'అడిగాబ్జే',
    'ae'    => 'అవేస్టాన్',
    'af'    => 'ఆఫ్రికాన్స్',
    'afa'   => "ఆఫ్రో\-ఆశియా\ భాష",
    'afh'   => 'అఫ్రిహిలి',
    'agq'   => 'Aghem',
    'ain'   => 'ఐను',
    'ak'    => 'అకాన్',
    'akk'   => 'అక్కాడియాన్',
    'ale'   => 'అలియుట్',
    'alg'   => "ఆల్గొంక్వియన్\ భాష",
    'alt'   => "దక్షిణ\ ఆల్టై",
    'am'    => 'అమ్హారిక్',
    'an'    => 'అరగోనిస్',
    'ang'   => "ప్రాచీన\ ఆగ్లం",
    'anp'   => 'ఆంగిక',
    'apa'   => "అప్పాచి\ భాష",
    'ar'    => 'అరబిక్',
    'arc'   => 'అరామేక్',
    'arn'   => 'అరౌకేనియన్',
    'arp'   => 'అరాపాహో',
    'art'   => "కృత్రిమ\ భాష",
    'arw'   => 'అరావాక్',
    'as'    => 'అస్సామీస్',
    'asa'   => 'Asu',
    'ast'   => 'అస్టురియాన్',
    'ath'   => "ఆతాపాస్కన్\ భాష",
    'aus'   => "ఆస్ట్రేలియన్\ భాష",
    'av'    => 'అవారిక్',
    'awa'   => 'అవధి',
    'ay'    => 'ఐమారా',
    'az'    => 'అజెరి',
    'ba'    => 'బష్కిర్',
    'bad'   => 'బాండా',
    'bai'   => "బమిలేకే\ భాష",
    'bal'   => 'బాలుచి',
    'ban'   => 'బాలినీస్',
    'bas'   => 'బసా',
    'bat'   => "బాల్టిక్\ భాష",
    'be'    => 'బెలరుశియన్',
    'bej'   => 'బేజా',
    'bem'   => 'బెంబా',
    'ber'   => 'బెర్బెర్',
    'bez'   => 'Bena',
    'bg'    => 'బల్గేరియన్',
    'bh'    => 'బిహారి',
    'bho'   => "భోజ్\ పూరి",
    'bi'    => 'బిస్లామా',
    'bik'   => 'బికోల్',
    'bin'   => 'బిని',
    'bla'   => "సిక్\ సికా",
    'bm'    => 'బంబారా',
    'bn'    => 'బెంగాలి',
    'bnt'   => 'బంటు',
    'bo'    => 'టిబెటన్',
    'br'    => 'బ్రెటన్',
    'bra'   => 'బ్రాజ్',
    'brx'   => 'Bodo',
    'bs'    => 'బాస్నియన్',
    'btk'   => 'బటక్',
    'bua'   => 'బురియట్',
    'bug'   => 'బ్యుగినిస్',
    'byn'   => 'బ్లిన్',
    'ca'    => 'కెటలాన్',
    'cad'   => 'కేడ్డో',
    'cai'   => "మధ్య\ అమెరికెన్\ ఇండియన్\ భాష",
    'car'   => 'కేరిబ్',
    'cau'   => "కోకేషియన్\ భాష",
    'cay'   => 'Cayuga',
    'cch'   => 'అట్సామ్',
    'ce'    => 'చెచెన్',
    'ceb'   => 'సేబుఆనో',
    'cel'   => "సెల్టిక్\ భాష",
    'cgg'   => 'Chiga',
    'ch'    => 'చమర్రో',
    'chb'   => 'చిబ్చా',
    'chg'   => 'చాగటై',
    'chk'   => 'చూకిస్',
    'chm'   => 'మారి',
    'chn'   => "చినూక్\ జార్గన్",
    'cho'   => 'చొచ్కతావ్',
    'chp'   => 'చిపెవ్యాన్',
    'chr'   => 'చిరోకి',
    'chy'   => 'చేయేన్',
    'cmc'   => "చామిక్\ భాష",
    'co'    => 'కార్సికన్',
    'cop'   => 'కోప్టిక్',
    'cpe'   => "ఆంగ్లం\ ఆధారిత\ క్రియోల్\ లేదా\ పిగ్డిన్",
    'cpf'   => "ప్రెంచ్\ \-ఆధారిత\ క్రియోల్\ లేదా\ పిగ్డిన్",
    'cpp'   => "పోర్చుగీస్\ \-ఆధారిత\ క్రియోల్\ లేదా\ పిగ్డిన్",
    'cr'    => 'క్రి',
    'crh'   => "క్రిమియన్\ టర్కిష్",
    'crp'   => "క్రియోల్\ లేదా\ పిగ్డిన్",
    'cs'    => 'చెక్',
    'csb'   => 'కషుబియన్',
    'cu'    => "చర్చ\ స్లావిక్",
    'cus'   => "కుషిటిక్\ భాష",
    'cv'    => 'చువాష్',
    'cy'    => 'వెల్ష్',
    'da'    => 'డేనిష్',
    'dak'   => 'డకోటా',
    'dar'   => 'డార్గ్వా',
    'dav'   => 'Taita',
    'day'   => 'దయక్',
    'de'    => 'ఙర్మన్',
    'de_at' => "ఆస్ట్రేలియన్\ జర్మన్",
    'de_ch' => "స్విస్\ హై\ జర్మన్",
    'del'   => 'డెలావేర్',
    'den'   => 'స్లేవ్',
    'dgr'   => 'డోగ్రిబ్',
    'din'   => 'డింకా',
    'dje'   => 'Zarma',
    'doi'   => 'డోగ్రి',
    'dra'   => "ద్రవిడియన్\ భాష",
    'dsb'   => "లోవర్\ సోర్బియన్",
    'dua'   => 'దుఆలా',
    'dum'   => "మధ్యమ\ డచ్",
    'dv'    => 'దివేహి',
    'dyo'   => "Jola\-Fonyi",
    'dyu'   => 'డ్యులా',
    'dz'    => 'జొన్ఖా',
    'ebu'   => 'Embu',
    'ee'    => 'ఇవే',
    'efi'   => 'ఎఫిక్',
    'egy'   => "ప్రాచీన\ ఇజిప్షియన్",
    'eka'   => 'ఏకాజక్',
    'el'    => 'గ్రీక్',
    'elx'   => 'ఎలామైట్',
    'en'    => 'ఆంగ్లం',
    'en_au' => "ఆస్ట్రేలియన్\ ఇంగ్లీష్",
    'en_ca' => "కెనడియన్\ ఇంగ్లీష్",
    'en_gb' => "బ్రిటిష్\ ఇంగ్లీష్",
    'en_us' => "యు\.ఎస్\ ఇంగ్లీష్",
    'enm'   => "మధ్యమ\ ఆంగ్లం",
    'eo'    => 'ఎస్పరెన్టొ',
    'es'    => 'స్పానిష్',
    'es_es' => "ఐబీరియెన్\ స్పానిష్",
    'et'    => 'ఈస్టొనియన్',
    'eu'    => 'బాస్క్',
    'ewo'   => 'ఎవోండొ',
    'fa'    => 'పర్షియన్',
    'fan'   => 'ఫాంగ్',
    'fat'   => 'ఫాంటి',
    'ff'    => 'ఫ్యుల',
    'fi'    => 'ఫిన్నిష్',
    'fil'   => 'ఫిలిపినో',
    'fiu'   => "ఫిన్నో\-\ యుగ్రియన్\ భాష",
    'fj'    => 'ఫిజియన్',
    'fo'    => 'ఫారొఈస్',
    'fon'   => 'ఫాన్',
    'fr'    => 'ఫ్రెంచ్',
    'fr_ca' => "కెనేడియెన్\ ఫ్రెంచ్",
    'fr_ch' => "స్విస్\ ఫ్రెంచ్",
    'frm'   => "మధ్యమ\ ప్రెంచ్",
    'fro'   => "ప్రాచీన\ ప్రెంచ్",
    'frr'   => "ఉత్తర\ ఫ్రిసియన్",
    'frs'   => "తూర్పు\ ఫ్రిసియన్",
    'fur'   => 'ఫ్రియులియన్',
    'fy'    => "పశ్చిమ\ ఫ్రిసియన్",
    'ga'    => 'ఐరిష్',
    'gaa'   => 'గా',
    'gay'   => 'గాయో',
    'gba'   => 'గ్బాయా',
    'gd'    => "స్కాటిష్\ గేలిక్",
    'gem'   => "జర్మేనిక్\ భాష",
    'gez'   => 'జీజ్',
    'gil'   => 'గిల్బర్టీస్',
    'gl'    => 'గెలిషియన్',
    'gmh'   => "మధ్యమ\ హై\ జర్మన్",
    'gn'    => 'గురాని',
    'goh'   => "ప్రాచీన\ హై\ జర్మన్",
    'gon'   => 'గోండి',
    'gor'   => 'గోరోంటలా',
    'got'   => 'గోథిక్',
    'grb'   => 'గ్రేబో',
    'grc'   => "ప్రాచీన\ గ్రీక్",
    'gsw'   => "స్విస్\ జర్మన్",
    'gu'    => 'గుజరాతి',
    'guz'   => 'Gusii',
    'gv'    => 'మంకస్',
    'gwi'   => 'గ్విచిన్',
    'ha'    => 'హౌసా',
    'hai'   => 'హైడా',
    'haw'   => 'హవాయియన్',
    'he'    => 'హీబ్రు',
    'hi'    => 'హిందీ',
    'hil'   => "హిలి\ గేయినోన్",
    'him'   => 'హిమాచలి',
    'hit'   => 'హిట్టిటే',
    'hmn'   => 'మోంగ్',
    'ho'    => "హిరి\ మోటు",
    'hr'    => 'క్రొయెషియన్',
    'hsb'   => "అప్పర్\ సోర్బియన్",
    'ht'    => 'హైయేతియన్',
    'hu'    => 'హన్గేరియన్',
    'hup'   => 'హుపా',
    'hy'    => 'ఆర్మేనియన్',
    'hz'    => 'హిరేరో',
    'ia'    => 'ఇంటర్లింగువా',
    'iba'   => 'ఐబాన్',
    'id'    => 'ఇండోనిషియ',
    'ie'    => "ఇంటర్\ లింగ్",
    'ig'    => 'ఇగ్బో',
    'ii'    => "శిషువన్\ ఈ",
    'ijo'   => 'ఐజో',
    'ik'    => 'ఇనూపైఏక్',
    'ilo'   => 'ఐయోకో',
    'inc'   => "భారతీయ\ భాష",
    'ine'   => "ఇండో\-ఐరోపియన్\ భాష",
    'inh'   => 'ఇంగుష్',
    'io'    => 'ఈడౌ',
    'ira'   => "ఇరానియన్\ భాష",
    'iro'   => "ఇరోక్వియన్\ భాష",
    'is'    => 'ఐస్లాండిక్',
    'it'    => 'ఇటాలియన్',
    'iu'    => 'ఇనుక్టిటుట్',
    'ja'    => 'జాపనీస్',
    'jbo'   => 'లోజ్బాన్',
    'jmc'   => 'Machame',
    'jpr'   => "జ్యుడియో\-పర్షియన్",
    'jrb'   => "జ్యుడియో\-అరబిక్",
    'jv'    => 'జావనీస్',
    'ka'    => 'జార్జియన్',
    'kaa'   => "కారా\-కల్పాక్",
    'kab'   => 'కాబిల్',
    'kac'   => 'కాచిన్',
    'kaj'   => 'జ్యూ',
    'kam'   => 'కంబా',
    'kar'   => 'కరెన్',
    'kaw'   => 'కావి',
    'kbd'   => 'కబార్డియన్',
    'kcg'   => 'ట్యాప్',
    'kde'   => 'Makonde',
    'kea'   => 'Kabuverdianu',
    'kfo'   => 'కోరో',
    'kg'    => 'కాంగో',
    'kha'   => 'ఖాసి',
    'khi'   => "ఖోఇసన్\ భాష",
    'kho'   => 'ఖటోనీస్',
    'khq'   => "Koyra\ Chiini",
    'ki'    => 'కికుయు',
    'kj'    => 'క్వాన్యామ',
    'kk'    => 'కాజాక్',
    'kl'    => 'కలాల్లిసూట్',
    'kln'   => 'Kalenjin',
    'km'    => 'ఖమ్ర్',
    'kmb'   => 'కిమ్బుండు',
    'kn'    => 'కన్నడ',
    'ko'    => 'కొరియన్',
    'kok'   => 'కొంకణి',
    'kos'   => 'కోస్రేయన్',
    'kpe'   => 'పెల్లే',
    'kr'    => 'కానురి',
    'krc'   => "కరచే\-బల్కార్",
    'krl'   => 'కరేలియన్',
    'kro'   => 'కృ',
    'kru'   => 'కూరుఖ్',
    'ks'    => 'కాశ్మీరి',
    'ksb'   => 'Shambala',
    'ksf'   => 'Bafia',
    'ksh'   => 'Colognian',
    'ku'    => 'కర్డిష్',
    'kum'   => 'కుమ్యిక్',
    'kut'   => 'కుటేనై',
    'kv'    => 'కోమి',
    'kw'    => 'కోర్నిష్',
    'ky'    => 'కిర్గిజ్',
    'la'    => 'లాటిన్',
    'lad'   => 'లాడినో',
    'lag'   => 'Langi',
    'lah'   => 'లాహండా',
    'lam'   => 'లాంబా',
    'lb'    => 'లుక్సంబర్గిష్',
    'lez'   => 'లేజ్ఘియన్',
    'lg'    => 'గాండా',
    'li'    => 'లిమ్బర్గిష్',
    'ln'    => 'లింగాల',
    'lo'    => 'లాఓ',
    'lol'   => 'మొంగో',
    'loz'   => 'లోజి',
    'lt'    => 'లిథుయేనియన్',
    'lu'    => "లూబ\-కటాంగ",
    'lua'   => "లూబా\-\ లులుయా",
    'lui'   => 'లుఇసేనో',
    'lun'   => 'లుండా',
    'luo'   => 'లువో',
    'lus'   => 'లుషై',
    'luy'   => 'Luyia',
    'lv'    => 'లాట్వియన్',
    'mad'   => 'మాదురీస్',
    'mag'   => 'మగాహి',
    'mai'   => 'మైథిలి',
    'mak'   => 'మకాసార్',
    'man'   => 'మండింగో',
    'map'   => 'ఆస్ట్రోనిశియన్',
    'mas'   => 'మాసాయి',
    'mdf'   => 'మొక్షా',
    'mdr'   => 'మండార్',
    'men'   => 'మెండే',
    'mer'   => 'Meru',
    'mfe'   => 'Morisyen',
    'mg'    => 'మాలాగసి',
    'mga'   => "మధ్యమ\ ఐరిష్",
    'mgh'   => "Makhuwa\-Meetto",
    'mh'    => 'మార్షలీస్',
    'mi'    => 'మయోరి',
    'mic'   => 'మికమాక్',
    'min'   => 'మినాంగ్కాబో',
    'mis'   => "మిశ్రమ\ భాష",
    'mk'    => 'మసడోనియన్',
    'mkh'   => "మోన్\-ఖ్మేర్\ భాష",
    'ml'    => 'మలయాళం',
    'mn'    => 'మంగోలియన్',
    'mnc'   => 'మంచు',
    'mni'   => 'మణిపూరి',
    'mno'   => "మనోబో\ భాష",
    'mo'    => 'మొల్డావియన్',
    'moh'   => 'మోహుక్',
    'mos'   => 'మోస్సి',
    'mr'    => 'మరాటి',
    'ms'    => 'మలేయ్',
    'mt'    => 'మాల్టీస్',
    'mua'   => 'Mundang',
    'mul'   => "బహుళ\ భాషలు",
    'mun'   => "ముండ\ భాష",
    'mus'   => 'క్రీక్',
    'mwl'   => 'మిరాండిస్',
    'mwr'   => 'మార్వాడి',
    'my'    => 'బర్మీస్',
    'myn'   => "మాయన్\ భాష",
    'myv'   => 'ఎర్జియా',
    'na'    => 'నౌరు',
    'nah'   => 'నాహుఅటిల్',
    'nai'   => "ఉత్తర\ అమెరికా\ ఇండియన్\ భాష",
    'nap'   => 'నియాపోలిటన్',
    'naq'   => 'Nama',
    'nb'    => "నార్వీజియన్\ బొక్మాల్",
    'nd'    => "ఉత్తర\ దెబెలె",
    'nds'   => "లో\ జర్మన్",
    'ne'    => 'నేపాలి',
    'new'   => 'నెవారి',
    'ng'    => 'దోంగా',
    'nia'   => 'నియాస్',
    'nic'   => "నైజర్\-\ కోర్దోఫియన్\ భాష",
    'niu'   => 'నియూఇయాన్',
    'nl'    => 'డచ్',
    'nl_be' => 'ఫ్లెమిష్',
    'nmg'   => 'Kwasio',
    'nn'    => "నార్విజియాన్\ న్యోర్స్క్",
    'no'    => 'నార్విజియాన్',
    'nog'   => 'నోగై',
    'non'   => "ప్రాచిన\ నోర్స్",
    'nqo'   => 'న్కో',
    'nr'    => "దక్షిణ\ దెబెలె",
    'nso'   => "ఉత్తర\ సోతో",
    'nub'   => "నూబియన్\ భాష",
    'nus'   => 'Nuer',
    'nv'    => 'నవాహో',
    'nwc'   => "సాంప్రదాయ\ న్యుఆరి",
    'ny'    => 'న్యాన్జా',
    'nym'   => 'న్యంవేజి',
    'nyn'   => 'న్యాన్కోలె',
    'nyo'   => 'నిఓరో',
    'nzi'   => 'జీమా',
    'oc'    => 'ఆక్సిటాన్',
    'oj'    => 'చేవా',
    'om'    => 'ఒరోమో',
    'or'    => 'ఒరియా',
    'os'    => 'ఒసేటిక్',
    'osa'   => 'ఒసాజ్',
    'ota'   => "ఒట్టోమన్\ టర్కిష్",
    'oto'   => "ఒటోమియన్\ భాష",
    'pa'    => 'పంజాబీ',
    'paa'   => "పాపుఅన్\ భాష",
    'pag'   => "పంగా\ సినాన్",
    'pal'   => 'పహ్లావి',
    'pam'   => 'పంపగ్న',
    'pap'   => 'పపియమేంటో',
    'pau'   => 'పాలుఆన్',
    'peo'   => "ప్రాచీన\ పర్షియన్",
    'phi'   => "ఫిలిప్పీన్\ భాష",
    'phn'   => 'ఫోనికన్',
    'pi'    => 'పాలీ',
    'pl'    => 'పోలిష్',
    'pon'   => 'పోహ్న్పెయన్',
    'pra'   => "ప్రాక్రిత్\ భాష",
    'pro'   => "ప్రాచీన\ ప్రోవెంసాల్",
    'ps'    => 'పుష్టో',
    'pt'    => 'పోర్చుగీస్',
    'pt_br' => "బ్రెజీలియన్\ పోర్చుగీస్",
    'pt_pt' => "ఐబీరియన్\ పోర్చుగీస్",
    'qu'    => 'కెషుయా',
    'raj'   => 'రాజస్తాని',
    'rap'   => 'రాపన్యుయి',
    'rar'   => 'రారోటొంగాన్',
    'rm'    => "ర్హెతో\-రోమాన్స్",
    'rn'    => 'రండి',
    'ro'    => 'రోమానియన్',
    'roa'   => "రోమాన్స్\ భాష",
    'rof'   => 'Rombo',
    'rom'   => 'రోమానీ',
    'ru'    => 'రష్యన్',
    'rup'   => 'ఆరోమేనియన్',
    'rw'    => 'కిన్యర్వాండా',
    'rwk'   => 'Rwa',
    'sa'    => 'సంసృతం',
    'sad'   => 'సండావి',
    'sah'   => 'యాకుట్',
    'sai'   => "దక్షిణ\ అమెరికా\ ఇండియన్\ భాష",
    'sal'   => "సాలిషాన్\ భాష",
    'sam'   => "సమారిటన్\ అరమేక్",
    'saq'   => 'Samburu',
    'sas'   => 'ససక్',
    'sat'   => 'సంటాలి',
    'sbp'   => 'Sangu',
    'sc'    => 'సార్డీనియన్',
    'scn'   => 'సిసిలియన్',
    'sco'   => 'స్కాట్స్',
    'sd'    => 'సింధీ',
    'se'    => "ఉత్తర\ సామి",
    'see'   => 'Seneca',
    'seh'   => 'Sena',
    'sel'   => 'సేల్కప్',
    'sem'   => "సెమిటిక్\ భాష",
    'ses'   => "Koyraboro\ Senni",
    'sg'    => 'సాంగో',
    'sga'   => "ప్రాచీన\ ఐరిష్",
    'sgn'   => "సంజ్ఞ\ భాష",
    'sh'    => "సేర్బో\-క్రొయేషియన్",
    'shi'   => 'Tachelhit',
    'shn'   => 'షాన్',
    'si'    => 'సింహాల',
    'sid'   => 'సిడామో',
    'sio'   => "షిఒయన్\ భాష",
    'sit'   => "సైనో\-\ టిబిటన్\ భాష",
    'sk'    => 'స్లోవాక్',
    'sl'    => 'స్లోవేనియాన్',
    'sla'   => "స్లావిక్\ భాష",
    'sm'    => 'సమోవన్',
    'sma'   => "దక్షిణ\ సామి",
    'smi'   => "సామి\ భాష",
    'smj'   => "లులే\ సామి",
    'smn'   => "ఇనారి\ సామి",
    'sms'   => "స్కోల్ట్\ సామి",
    'sn'    => 'షోన',
    'snk'   => 'సోనింకి',
    'so'    => 'సోమాలి',
    'sog'   => 'సోగ్డియన్',
    'son'   => 'సొంఘై',
    'sq'    => 'అల్బేనియన్',
    'sr'    => 'సెర్బియన్',
    'srn'   => "స్రానన్\ టోనగో",
    'srr'   => 'సెరేర్',
    'ss'    => 'స్వాతి',
    'ssa'   => "నీలో\ సహారా\ భాష",
    'ssy'   => 'Saho',
    'st'    => "దక్షిణ\ సోతో",
    'su'    => 'సుడానీస్',
    'suk'   => 'సుకుమా',
    'sus'   => 'సుసు',
    'sux'   => 'సుమేరియాన్',
    'sv'    => 'స్వీడిష్',
    'sw'    => 'స్వాహిలి',
    'swb'   => 'కొమొరియన్',
    'swc'   => "Congo\ Swahili",
    'syc'   => "సాంప్రదాయ\ సిరియాక్",
    'syr'   => 'సిరియాక్',
    'ta'    => 'తమిళము',
    'tai'   => "టై\ భాష",
    'te'    => 'తెలుగు',
    'tem'   => 'టింనే',
    'teo'   => 'Teso',
    'ter'   => 'టెరెనో',
    'tet'   => 'టేటం',
    'tg'    => 'తాజిక్',
    'th'    => 'థాయ్',
    'ti'    => 'తిగ్రిన్యా',
    'tig'   => 'టీగ్రె',
    'tiv'   => 'టివ్',
    'tk'    => 'తుర్కమెన్',
    'tkl'   => 'టోకెలావ్',
    'tl'    => 'తగలోగ్',
    'tlh'   => 'క్లింగన్',
    'tli'   => 'లింగిట్',
    'tmh'   => 'టామషేక్',
    'tn'    => 'సెటస్వానా',
    'to'    => 'టోంగా',
    'tog'   => "న్యాసా\ టోన్గా",
    'tpi'   => "టోక్\ పిసిన్",
    'tr'    => 'టర్కిష్',
    'trv'   => 'Taroko',
    'ts'    => 'సోంగా',
    'tsi'   => 'శింషీయన్',
    'tt'    => 'టాటర్',
    'tum'   => 'టంబుక',
    'tup'   => "టుపి\ భాష",
    'tut'   => "ఆల్టియాక్\ భాష",
    'tvl'   => 'టువాలు',
    'tw'    => 'ట్వి',
    'twq'   => 'Tasawaq',
    'ty'    => 'తహితియన్',
    'tyv'   => 'టువినియన్',
    'tzm'   => "Central\ Morocco\ Tamazight",
    'udm'   => 'ఉడ్ముర్ట్',
    'ug'    => 'యుజుర్',
    'uga'   => 'ఉగారిటిక్',
    'uk'    => 'యుక్రేనియాన్',
    'umb'   => 'ఉమ్బుండు',
    'und'   => "తెలియని\ లేదా\ చెల్లని\ భాష",
    'ur'    => 'ఉర్దూ',
    'uz'    => 'ఉజ్బెక్',
    'vai'   => 'వాయి',
    've'    => 'వెండా',
    'vi'    => 'వియత్నామీస్',
    'vo'    => 'వోలాపుక్',
    'vot'   => 'వోటిక్',
    'vun'   => 'Vunjo',
    'wa'    => 'వాలూన్',
    'wae'   => 'Walser',
    'wak'   => "వాక్షన్\ భాష",
    'wal'   => 'వాలామో',
    'war'   => 'వారే',
    'was'   => 'వాషో',
    'wen'   => "సోర్బియన్\ భాష",
    'wo'    => 'వొలాఫ్',
    'xal'   => 'కల్మిక్',
    'xh'    => 'షోసా',
    'xog'   => 'Soga',
    'yao'   => 'యాఒ',
    'yap'   => 'యాపిస్',
    'yav'   => 'Yangben',
    'yi'    => 'యిడ్డిష్',
    'yo'    => 'యోరుబా',
    'ypk'   => "యుపిక్\ భాష",
    'yue'   => 'కాంటనీస్',
    'za'    => 'జువాన్',
    'zap'   => 'జపోటెక్',
    'zbl'   => 'బ్లిసింబల్స్',
    'zen'   => 'జెనాగా',
    'zh'    => 'చైనీస్',
    'znd'   => 'జండే',
    'zu'    => 'జూలూ',
    'zun'   => 'జుని',
    'zxx'   => "ఈ\ లిపి\ లేదు",
    'zza'   => 'జాజా',
);

%Locales::DB::Language::te::name_to_code = (
    'aghem'                                                                                                        => 'agq',
    'asu'                                                                                                          => 'asa',
    'bafia'                                                                                                        => 'ksf',
    'bena'                                                                                                         => 'bez',
    'bodo'                                                                                                         => 'brx',
    'cayuga'                                                                                                       => 'cay',
    'centralmoroccotamazight'                                                                                      => 'tzm',
    'chiga'                                                                                                        => 'cgg',
    'colognian'                                                                                                    => 'ksh',
    'congoswahili'                                                                                                 => 'swc',
    'embu'                                                                                                         => 'ebu',
    'gusii'                                                                                                        => 'guz',
    'jolafonyi'                                                                                                    => 'dyo',
    'kabuverdianu'                                                                                                 => 'kea',
    'kalenjin'                                                                                                     => 'kln',
    'koyraborosenni'                                                                                               => 'ses',
    'koyrachiini'                                                                                                  => 'khq',
    'kwasio'                                                                                                       => 'nmg',
    'langi'                                                                                                        => 'lag',
    'luyia'                                                                                                        => 'luy',
    'machame'                                                                                                      => 'jmc',
    'makhuwameetto'                                                                                                => 'mgh',
    'makonde'                                                                                                      => 'kde',
    'meru'                                                                                                         => 'mer',
    'morisyen'                                                                                                     => 'mfe',
    'mundang'                                                                                                      => 'mua',
    'nama'                                                                                                         => 'naq',
    'nuer'                                                                                                         => 'nus',
    'rombo'                                                                                                        => 'rof',
    'rwa'                                                                                                          => 'rwk',
    'saho'                                                                                                         => 'ssy',
    'samburu'                                                                                                      => 'saq',
    'sangu'                                                                                                        => 'sbp',
    'sena'                                                                                                         => 'seh',
    'seneca'                                                                                                       => 'see',
    'shambala'                                                                                                     => 'ksb',
    'soga'                                                                                                         => 'xog',
    'tachelhit'                                                                                                    => 'shi',
    'taita'                                                                                                        => 'dav',
    'taroko'                                                                                                       => 'trv',
    'tasawaq'                                                                                                      => 'twq',
    'teso'                                                                                                         => 'teo',
    'vunjo'                                                                                                        => 'vun',
    'walser'                                                                                                       => 'wae',
    'yangben'                                                                                                      => 'yav',
    'zarma'                                                                                                        => 'dje',
    'అకాన్'                                                                                              => 'ak',
    'అకోలి'                                                                                              => 'ach',
    'అక్కాడియాన్'                                                                            => 'akk',
    'అజెరి'                                                                                              => 'az',
    'అట్సామ్'                                                                                        => 'cch',
    'అడాంగ్మే'                                                                                     => 'ada',
    'అడిగాబ్జే'                                                                                  => 'ady',
    'అప్పర్సోర్బియన్'                                                                => 'hsb',
    'అప్పాచిభాష'                                                                               => 'apa',
    'అఫార్'                                                                                              => 'aa',
    'అఫ్రిహిలి'                                                                                  => 'afh',
    'అబ్ఖాజియన్'                                                                               => 'ab',
    'అమ్హారిక్'                                                                                  => 'am',
    'అరగోనిస్'                                                                                     => 'an',
    'అరబిక్'                                                                                           => 'ar',
    'అరాపాహో'                                                                                        => 'arp',
    'అరామేక్'                                                                                        => 'arc',
    'అరావాక్'                                                                                        => 'arw',
    'అరౌకేనియన్'                                                                               => 'arn',
    'అలియుట్'                                                                                        => 'ale',
    'అల్బేనియన్'                                                                               => 'sq',
    'అవధి'                                                                                                 => 'awa',
    'అవారిక్'                                                                                        => 'av',
    'అవేస్టాన్'                                                                                  => 'ae',
    'అస్టురియాన్'                                                                            => 'ast',
    'అస్సామీస్'                                                                                  => 'as',
    'ఆంగిక'                                                                                              => 'anp',
    'ఆంగ్లం'                                                                                           => 'en',
    'ఆంగ్లంఆధారితక్రియోల్లేదాపిగ్డిన్'             => 'cpe',
    'ఆక్సిటాన్'                                                                                  => 'oc',
    'ఆఖినీస్'                                                                                        => 'ace',
    'ఆతాపాస్కన్భాష'                                                                      => 'ath',
    'ఆఫ్రికాన్స్'                                                                            => 'af',
    'ఆఫ్రోఆశియాభాష'                                                                      => 'afa',
    'ఆరోమేనియన్'                                                                               => 'rup',
    'ఆర్మేనియన్'                                                                               => 'hy',
    'ఆల్గొంక్వియన్భాష'                                                             => 'alg',
    'ఆల్టియాక్భాష'                                                                         => 'tut',
    'ఆస్ట్రేలియన్ఇంగ్లీష్'                                                 => 'en_au',
    'ఆస్ట్రేలియన్జర్మన్'                                                       => 'de_at',
    'ఆస్ట్రేలియన్భాష'                                                                => 'aus',
    'ఆస్ట్రోనిశియన్'                                                                   => 'map',
    'ఇంగుష్'                                                                                           => 'inh',
    'ఇంటర్లింగువా'                                                                         => 'ia',
    'ఇంటర్లింగ్'                                                                               => 'ie',
    'ఇండోఐరోపియన్భాష'                                                                => 'ine',
    'ఇండోనిషియ'                                                                                  => 'id',
    'ఇగ్బో'                                                                                              => 'ig',
    'ఇటాలియన్'                                                                                     => 'it',
    'ఇనారిసామి'                                                                                  => 'smn',
    'ఇనుక్టిటుట్'                                                                            => 'iu',
    'ఇనూపైఏక్'                                                                                     => 'ik',
    'ఇరానియన్భాష'                                                                            => 'ira',
    'ఇరోక్వియన్భాష'                                                                      => 'iro',
    'ఇవే'                                                                                                    => 'ee',
    'ఈడౌ'                                                                                                    => 'io',
    'ఈలిపిలేదు'                                                                                  => 'zxx',
    'ఈస్టొనియన్'                                                                               => 'et',
    'ఉగారిటిక్'                                                                                  => 'uga',
    'ఉజ్బెక్'                                                                                        => 'uz',
    'ఉడ్ముర్ట్'                                                                                  => 'udm',
    'ఉత్తరఅమెరికాఇండియన్భాష'                                           => 'nai',
    'ఉత్తరదెబెలె'                                                                            => 'nd',
    'ఉత్తరఫ్రిసియన్'                                                                   => 'frr',
    'ఉత్తరసామి'                                                                                  => 'se',
    'ఉత్తరసోతో'                                                                                  => 'nso',
    'ఉమ్బుండు'                                                                                     => 'umb',
    'ఉర్దూ'                                                                                              => 'ur',
    'ఎఫిక్'                                                                                              => 'efi',
    'ఎర్జియా'                                                                                        => 'myv',
    'ఎలామైట్'                                                                                        => 'elx',
    'ఎవోండొ'                                                                                           => 'ewo',
    'ఎస్పరెన్టొ'                                                                               => 'eo',
    'ఏకాజక్'                                                                                           => 'eka',
    'ఐజో'                                                                                                    => 'ijo',
    'ఐను'                                                                                                    => 'ain',
    'ఐబాన్'                                                                                              => 'iba',
    'ఐబీరియన్పోర్చుగీస్'                                                       => 'pt_pt',
    'ఐబీరియెన్స్పానిష్'                                                          => 'es_es',
    'ఐమారా'                                                                                              => 'ay',
    'ఐయోకో'                                                                                              => 'ilo',
    'ఐరిష్'                                                                                              => 'ga',
    'ఐస్లాండిక్'                                                                               => 'is',
    'ఒటోమియన్భాష'                                                                            => 'oto',
    'ఒట్టోమన్టర్కిష్'                                                                => 'ota',
    'ఒరియా'                                                                                              => 'or',
    'ఒరోమో'                                                                                              => 'om',
    'ఒసాజ్'                                                                                              => 'osa',
    'ఒసేటిక్'                                                                                        => 'os',
    'కంబా'                                                                                                 => 'kam',
    'కన్నడ'                                                                                              => 'kn',
    'కబార్డియన్'                                                                               => 'kbd',
    'కరచేబల్కార్'                                                                            => 'krc',
    'కరెన్'                                                                                              => 'kar',
    'కరేలియన్'                                                                                     => 'krl',
    'కర్డిష్'                                                                                        => 'ku',
    'కలాల్లిసూట్'                                                                            => 'kl',
    'కల్మిక్'                                                                                        => 'xal',
    'కషుబియన్'                                                                                     => 'csb',
    'కాంగో'                                                                                              => 'kg',
    'కాంటనీస్'                                                                                     => 'yue',
    'కాచిన్'                                                                                           => 'kac',
    'కాజాక్'                                                                                           => 'kk',
    'కానురి'                                                                                           => 'kr',
    'కాబిల్'                                                                                           => 'kab',
    'కారాకల్పాక్'                                                                            => 'kaa',
    'కార్సికన్'                                                                                  => 'co',
    'కావి'                                                                                                 => 'kaw',
    'కాశ్మీరి'                                                                                     => 'ks',
    'కికుయు'                                                                                           => 'ki',
    'కిన్యర్వాండా'                                                                         => 'rw',
    'కిమ్బుండు'                                                                                  => 'kmb',
    'కిర్గిజ్'                                                                                     => 'ky',
    'కుటేనై'                                                                                           => 'kut',
    'కుమ్యిక్'                                                                                     => 'kum',
    'కుషిటిక్భాష'                                                                            => 'cus',
    'కూరుఖ్'                                                                                           => 'kru',
    'కృ'                                                                                                       => 'kro',
    'కృత్రిమభాష'                                                                               => 'art',
    'కెటలాన్'                                                                                        => 'ca',
    'కెనడియన్ఇంగ్లీష్'                                                             => 'en_ca',
    'కెనేడియెన్ఫ్రెంచ్'                                                          => 'fr_ca',
    'కెషుయా'                                                                                           => 'qu',
    'కేడ్డో'                                                                                           => 'cad',
    'కేరిబ్'                                                                                           => 'car',
    'కొంకణి'                                                                                           => 'kok',
    'కొమొరియన్'                                                                                  => 'swb',
    'కొరియన్'                                                                                        => 'ko',
    'కోకేషియన్భాష'                                                                         => 'cau',
    'కోప్టిక్'                                                                                     => 'cop',
    'కోమి'                                                                                                 => 'kv',
    'కోరో'                                                                                                 => 'kfo',
    'కోర్నిష్'                                                                                     => 'kw',
    'కోస్రేయన్'                                                                                  => 'kos',
    'క్రి'                                                                                                 => 'cr',
    'క్రిమియన్టర్కిష్'                                                             => 'crh',
    'క్రియోల్లేదాపిగ్డిన్'                                                 => 'crp',
    'క్రీక్'                                                                                           => 'mus',
    'క్రొయెషియన్'                                                                            => 'hr',
    'క్లింగన్'                                                                                     => 'tlh',
    'క్వాన్యామ'                                                                                  => 'kj',
    'ఖటోనీస్'                                                                                        => 'kho',
    'ఖమ్ర్'                                                                                              => 'km',
    'ఖాసి'                                                                                                 => 'kha',
    'ఖోఇసన్భాష'                                                                                  => 'khi',
    'గా'                                                                                                       => 'gaa',
    'గాండా'                                                                                              => 'lg',
    'గాయో'                                                                                                 => 'gay',
    'గిల్బర్టీస్'                                                                            => 'gil',
    'గుజరాతి'                                                                                        => 'gu',
    'గురాని'                                                                                           => 'gn',
    'గెలిషియన్'                                                                                  => 'gl',
    'గోండి'                                                                                              => 'gon',
    'గోథిక్'                                                                                           => 'got',
    'గోరోంటలా'                                                                                     => 'gor',
    'గ్బాయా'                                                                                           => 'gba',
    'గ్రీక్'                                                                                           => 'el',
    'గ్రేబో'                                                                                           => 'grb',
    'గ్విచిన్'                                                                                     => 'gwi',
    'ఙర్మన్'                                                                                           => 'de',
    'చమర్రో'                                                                                           => 'ch',
    'చర్చస్లావిక్'                                                                         => 'cu',
    'చాగటై'                                                                                              => 'chg',
    'చామిక్భాష'                                                                                  => 'cmc',
    'చినూక్జార్గన్'                                                                      => 'chn',
    'చిపెవ్యాన్'                                                                               => 'chp',
    'చిబ్చా'                                                                                           => 'chb',
    'చిరోకి'                                                                                           => 'chr',
    'చువాష్'                                                                                           => 'cv',
    'చూకిస్'                                                                                           => 'chk',
    'చెక్'                                                                                                 => 'cs',
    'చెచెన్'                                                                                           => 'ce',
    'చేయేన్'                                                                                           => 'chy',
    'చేవా'                                                                                                 => 'oj',
    'చైనీస్'                                                                                           => 'zh',
    'చొచ్కతావ్'                                                                                  => 'cho',
    'జండే'                                                                                                 => 'znd',
    'జపోటెక్'                                                                                        => 'zap',
    'జర్మేనిక్భాష'                                                                         => 'gem',
    'జాజా'                                                                                                 => 'zza',
    'జాపనీస్'                                                                                        => 'ja',
    'జార్జియన్'                                                                                  => 'ka',
    'జావనీస్'                                                                                        => 'jv',
    'జీజ్'                                                                                                 => 'gez',
    'జీమా'                                                                                                 => 'nzi',
    'జుని'                                                                                                 => 'zun',
    'జువాన్'                                                                                           => 'za',
    'జూలూ'                                                                                                 => 'zu',
    'జెనాగా'                                                                                           => 'zen',
    'జొన్ఖా'                                                                                           => 'dz',
    'జ్యుడియోఅరబిక్'                                                                   => 'jrb',
    'జ్యుడియోపర్షియన్'                                                             => 'jpr',
    'జ్యూ'                                                                                                 => 'kaj',
    'టంబుక'                                                                                              => 'tum',
    'టర్కిష్'                                                                                        => 'tr',
    'టాటర్'                                                                                              => 'tt',
    'టామషేక్'                                                                                        => 'tmh',
    'టింనే'                                                                                              => 'tem',
    'టిబెటన్'                                                                                        => 'bo',
    'టివ్'                                                                                                 => 'tiv',
    'టీగ్రె'                                                                                           => 'tig',
    'టుపిభాష'                                                                                        => 'tup',
    'టువాలు'                                                                                           => 'tvl',
    'టువినియన్'                                                                                  => 'tyv',
    'టెరెనో'                                                                                           => 'ter',
    'టేటం'                                                                                                 => 'tet',
    'టైభాష'                                                                                              => 'tai',
    'టోంగా'                                                                                              => 'to',
    'టోకెలావ్'                                                                                     => 'tkl',
    'టోక్పిసిన్'                                                                               => 'tpi',
    'ట్యాప్'                                                                                           => 'kcg',
    'ట్వి'                                                                                                 => 'tw',
    'డకోటా'                                                                                              => 'dak',
    'డచ్'                                                                                                    => 'nl',
    'డార్గ్వా'                                                                                     => 'dar',
    'డింకా'                                                                                              => 'din',
    'డెలావేర్'                                                                                     => 'del',
    'డేనిష్'                                                                                           => 'da',
    'డోగ్రి'                                                                                           => 'doi',
    'డోగ్రిబ్'                                                                                     => 'dgr',
    'డ్యులా'                                                                                           => 'dyu',
    'తగలోగ్'                                                                                           => 'tl',
    'తమిళము'                                                                                           => 'ta',
    'తహితియన్'                                                                                     => 'ty',
    'తాజిక్'                                                                                           => 'tg',
    'తిగ్రిన్యా'                                                                               => 'ti',
    'తుర్కమెన్'                                                                                  => 'tk',
    'తూర్పుఫ్రిసియన్'                                                                => 'frs',
    'తెలియనిలేదాచెల్లనిభాష'                                              => 'und',
    'తెలుగు'                                                                                           => 'te',
    'థాయ్'                                                                                                 => 'th',
    'దక్షిణఅమెరికాఇండియన్భాష'                                        => 'sai',
    'దక్షిణఆల్టై'                                                                            => 'alt',
    'దక్షిణదెబెలె'                                                                         => 'nr',
    'దక్షిణసామి'                                                                               => 'sma',
    'దక్షిణసోతో'                                                                               => 'st',
    'దయక్'                                                                                                 => 'day',
    'దివేహి'                                                                                           => 'dv',
    'దుఆలా'                                                                                              => 'dua',
    'దోంగా'                                                                                              => 'ng',
    'ద్రవిడియన్భాష'                                                                      => 'dra',
    'నవాహో'                                                                                              => 'nv',
    'నార్విజియాన్'                                                                         => 'no',
    'నార్విజియాన్న్యోర్స్క్'                                           => 'nn',
    'నార్వీజియన్బొక్మాల్'                                                    => 'nb',
    'నాహుఅటిల్'                                                                                  => 'nah',
    'నిఓరో'                                                                                              => 'nyo',
    'నియాపోలిటన్'                                                                            => 'nap',
    'నియాస్'                                                                                           => 'nia',
    'నియూఇయాన్'                                                                                  => 'niu',
    'నీలోసహారాభాష'                                                                         => 'ssa',
    'నూబియన్భాష'                                                                               => 'nub',
    'నెవారి'                                                                                           => 'new',
    'నేపాలి'                                                                                           => 'ne',
    'నైజర్కోర్దోఫియన్భాష'                                                    => 'nic',
    'నోగై'                                                                                                 => 'nog',
    'నౌరు'                                                                                                 => 'na',
    'న్కో'                                                                                                 => 'nqo',
    'న్యంవేజి'                                                                                     => 'nym',
    'న్యాన్కోలె'                                                                               => 'nyn',
    'న్యాన్జా'                                                                                     => 'ny',
    'న్యాసాటోన్గా'                                                                         => 'tog',
    'పంగాసినాన్'                                                                               => 'pag',
    'పంజాబీ'                                                                                           => 'pa',
    'పంపగ్న'                                                                                           => 'pam',
    'పపియమేంటో'                                                                                  => 'pap',
    'పర్షియన్'                                                                                     => 'fa',
    'పశ్చిమఫ్రిసియన్'                                                                => 'fy',
    'పహ్లావి'                                                                                        => 'pal',
    'పాపుఅన్భాష'                                                                               => 'paa',
    'పాలీ'                                                                                                 => 'pi',
    'పాలుఆన్'                                                                                        => 'pau',
    'పుష్టో'                                                                                           => 'ps',
    'పెల్లే'                                                                                           => 'kpe',
    'పోర్చుగీస్'                                                                               => 'pt',
    'పోర్చుగీస్ఆధారితక్రియోల్లేదాపిగ్డిన్' => 'cpp',
    'పోలిష్'                                                                                           => 'pl',
    'పోహ్న్పెయన్'                                                                            => 'pon',
    'ప్రాక్రిత్భాష'                                                                      => 'pra',
    'ప్రాచిననోర్స్'                                                                      => 'non',
    'ప్రాచీనఆగ్లం'                                                                         => 'ang',
    'ప్రాచీనఇజిప్షియన్'                                                          => 'egy',
    'ప్రాచీనఐరిష్'                                                                         => 'sga',
    'ప్రాచీనగ్రీక్'                                                                      => 'grc',
    'ప్రాచీనపర్షియన్'                                                                => 'peo',
    'ప్రాచీనప్రెంచ్'                                                                   => 'fro',
    'ప్రాచీనప్రోవెంసాల్'                                                       => 'pro',
    'ప్రాచీనహైజర్మన్'                                                                => 'goh',
    'ప్రెంచ్ఆధారితక్రియోల్లేదాపిగ్డిన్'          => 'cpf',
    'ఫాంగ్'                                                                                              => 'fan',
    'ఫాంటి'                                                                                              => 'fat',
    'ఫాన్'                                                                                                 => 'fon',
    'ఫారొఈస్'                                                                                        => 'fo',
    'ఫిజియన్'                                                                                        => 'fj',
    'ఫిన్నిష్'                                                                                     => 'fi',
    'ఫిన్నోయుగ్రియన్భాష'                                                       => 'fiu',
    'ఫిలిపినో'                                                                                     => 'fil',
    'ఫిలిప్పీన్భాష'                                                                      => 'phi',
    'ఫోనికన్'                                                                                        => 'phn',
    'ఫ్యుల'                                                                                              => 'ff',
    'ఫ్రియులియన్'                                                                            => 'fur',
    'ఫ్రెంచ్'                                                                                        => 'fr',
    'ఫ్లెమిష్'                                                                                     => 'nl_be',
    'బంటు'                                                                                                 => 'bnt',
    'బంబారా'                                                                                           => 'bm',
    'బటక్'                                                                                                 => 'btk',
    'బమిలేకేభాష'                                                                               => 'bai',
    'బర్మీస్'                                                                                        => 'my',
    'బల్గేరియన్'                                                                               => 'bg',
    'బష్కిర్'                                                                                        => 'ba',
    'బసా'                                                                                                    => 'bas',
    'బహుళభాషలు'                                                                                  => 'mul',
    'బాండా'                                                                                              => 'bad',
    'బాలినీస్'                                                                                     => 'ban',
    'బాలుచి'                                                                                           => 'bal',
    'బాల్టిక్భాష'                                                                            => 'bat',
    'బాస్క్'                                                                                           => 'eu',
    'బాస్నియన్'                                                                                  => 'bs',
    'బికోల్'                                                                                           => 'bik',
    'బిని'                                                                                                 => 'bin',
    'బిస్లామా'                                                                                     => 'bi',
    'బిహారి'                                                                                           => 'bh',
    'బురియట్'                                                                                        => 'bua',
    'బెంగాలి'                                                                                        => 'bn',
    'బెంబా'                                                                                              => 'bem',
    'బెర్బెర్'                                                                                     => 'ber',
    'బెలరుశియన్'                                                                               => 'be',
    'బేజా'                                                                                                 => 'bej',
    'బ్యుగినిస్'                                                                               => 'bug',
    'బ్రాజ్'                                                                                           => 'bra',
    'బ్రిటిష్ఇంగ్లీష్'                                                             => 'en_gb',
    'బ్రెజీలియన్పోర్చుగీస్'                                              => 'pt_br',
    'బ్రెటన్'                                                                                        => 'br',
    'బ్లిన్'                                                                                           => 'byn',
    'బ్లిసింబల్స్'                                                                         => 'zbl',
    'భారతీయభాష'                                                                                  => 'inc',
    'భోజ్పూరి'                                                                                     => 'bho',
    'మంకస్'                                                                                              => 'gv',
    'మంగోలియన్'                                                                                  => 'mn',
    'మంచు'                                                                                                 => 'mnc',
    'మండార్'                                                                                           => 'mdr',
    'మండింగో'                                                                                        => 'man',
    'మకాసార్'                                                                                        => 'mak',
    'మగాహి'                                                                                              => 'mag',
    'మణిపూరి'                                                                                        => 'mni',
    'మధ్యఅమెరికెన్ఇండియన్భాష'                                        => 'cai',
    'మధ్యమఆంగ్లం'                                                                            => 'enm',
    'మధ్యమఐరిష్'                                                                               => 'mga',
    'మధ్యమడచ్'                                                                                     => 'dum',
    'మధ్యమప్రెంచ్'                                                                         => 'frm',
    'మధ్యమహైజర్మన్'                                                                      => 'gmh',
    'మనోబోభాష'                                                                                     => 'mno',
    'మయోరి'                                                                                              => 'mi',
    'మరాటి'                                                                                              => 'mr',
    'మలయాళం'                                                                                           => 'ml',
    'మలేయ్'                                                                                              => 'ms',
    'మసడోనియన్'                                                                                  => 'mk',
    'మాదురీస్'                                                                                     => 'mad',
    'మాయన్భాష'                                                                                     => 'myn',
    'మారి'                                                                                                 => 'chm',
    'మార్వాడి'                                                                                     => 'mwr',
    'మార్షలీస్'                                                                                  => 'mh',
    'మాలాగసి'                                                                                        => 'mg',
    'మాల్టీస్'                                                                                     => 'mt',
    'మాసాయి'                                                                                           => 'mas',
    'మికమాక్'                                                                                        => 'mic',
    'మినాంగ్కాబో'                                                                            => 'min',
    'మిరాండిస్'                                                                                  => 'mwl',
    'మిశ్రమభాష'                                                                                  => 'mis',
    'ముండభాష'                                                                                        => 'mun',
    'మెండే'                                                                                              => 'men',
    'మైథిలి'                                                                                           => 'mai',
    'మొంగో'                                                                                              => 'lol',
    'మొక్షా'                                                                                           => 'mdf',
    'మొల్డావియన్'                                                                            => 'mo',
    'మోంగ్'                                                                                              => 'hmn',
    'మోన్ఖ్మేర్భాష'                                                                      => 'mkh',
    'మోస్సి'                                                                                           => 'mos',
    'మోహుక్'                                                                                           => 'moh',
    'యాఒ'                                                                                                    => 'yao',
    'యాకుట్'                                                                                           => 'sah',
    'యాపిస్'                                                                                           => 'yap',
    'యిడ్డిష్'                                                                                     => 'yi',
    "యు\.ఎస్ఇంగ్లీష్"                                                                    => 'en_us',
    'యుక్రేనియాన్'                                                                         => 'uk',
    'యుజుర్'                                                                                           => 'ug',
    'యుపిక్భాష'                                                                                  => 'ypk',
    'యోరుబా'                                                                                           => 'yo',
    'రండి'                                                                                                 => 'rn',
    'రష్యన్'                                                                                           => 'ru',
    'రాజస్తాని'                                                                                  => 'raj',
    'రాపన్యుయి'                                                                                  => 'rap',
    'రారోటొంగాన్'                                                                            => 'rar',
    'రోమానియన్'                                                                                  => 'ro',
    'రోమానీ'                                                                                           => 'rom',
    'రోమాన్స్భాష'                                                                            => 'roa',
    'ర్హెతోరోమాన్స్'                                                                   => 'rm',
    'లాంబా'                                                                                              => 'lam',
    'లాఓ'                                                                                                    => 'lo',
    'లాటిన్'                                                                                           => 'la',
    'లాట్వియన్'                                                                                  => 'lv',
    'లాడినో'                                                                                           => 'lad',
    'లాహండా'                                                                                           => 'lah',
    'లింగాల'                                                                                           => 'ln',
    'లింగిట్'                                                                                        => 'tli',
    'లిథుయేనియన్'                                                                            => 'lt',
    'లిమ్బర్గిష్'                                                                            => 'li',
    'లుండా'                                                                                              => 'lun',
    'లుఇసేనో'                                                                                        => 'lui',
    'లుక్సంబర్గిష్'                                                                      => 'lb',
    'లులేసామి'                                                                                     => 'smj',
    'లువో'                                                                                                 => 'luo',
    'లుషై'                                                                                                 => 'lus',
    'లూబకటాంగ'                                                                                     => 'lu',
    'లూబాలులుయా'                                                                               => 'lua',
    'లేజ్ఘియన్'                                                                                  => 'lez',
    'లోజర్మన్'                                                                                     => 'nds',
    'లోజి'                                                                                                 => 'loz',
    'లోజ్బాన్'                                                                                     => 'jbo',
    'లోవర్సోర్బియన్'                                                                   => 'dsb',
    'వాక్షన్భాష'                                                                               => 'wak',
    'వాయి'                                                                                                 => 'vai',
    'వారే'                                                                                                 => 'war',
    'వాలామో'                                                                                           => 'wal',
    'వాలూన్'                                                                                           => 'wa',
    'వాషో'                                                                                                 => 'was',
    'వియత్నామీస్'                                                                            => 'vi',
    'వెండా'                                                                                              => 've',
    'వెల్ష్'                                                                                           => 'cy',
    'వొలాఫ్'                                                                                           => 'wo',
    'వోటిక్'                                                                                           => 'vot',
    'వోలాపుక్'                                                                                     => 'vo',
    'శింషీయన్'                                                                                     => 'tsi',
    'శిషువన్ఈ'                                                                                     => 'ii',
    'షాన్'                                                                                                 => 'shn',
    'షిఒయన్భాష'                                                                                  => 'sio',
    'షోన'                                                                                                    => 'sn',
    'షోసా'                                                                                                 => 'xh',
    'సంజ్ఞభాష'                                                                                     => 'sgn',
    'సంటాలి'                                                                                           => 'sat',
    'సండావి'                                                                                           => 'sad',
    'సంసృతం'                                                                                           => 'sa',
    'సమారిటన్అరమేక్'                                                                   => 'sam',
    'సమోవన్'                                                                                           => 'sm',
    'ససక్'                                                                                                 => 'sas',
    'సాంగో'                                                                                              => 'sg',
    'సాంప్రదాయన్యుఆరి'                                                             => 'nwc',
    'సాంప్రదాయసిరియాక్'                                                          => 'syc',
    'సామిభాష'                                                                                        => 'smi',
    'సార్డీనియన్'                                                                            => 'sc',
    'సాలిషాన్భాష'                                                                            => 'sal',
    'సింధీ'                                                                                              => 'sd',
    'సింహాల'                                                                                           => 'si',
    'సిక్సికా'                                                                                     => 'bla',
    'సిడామో'                                                                                           => 'sid',
    'సిరియాక్'                                                                                     => 'syr',
    'సిసిలియన్'                                                                                  => 'scn',
    'సుకుమా'                                                                                           => 'suk',
    'సుడానీస్'                                                                                     => 'su',
    'సుమేరియాన్'                                                                               => 'sux',
    'సుసు'                                                                                                 => 'sus',
    'సెటస్వానా'                                                                                  => 'tn',
    'సెమిటిక్భాష'                                                                            => 'sem',
    'సెరేర్'                                                                                           => 'srr',
    'సెర్బియన్'                                                                                  => 'sr',
    'సెల్టిక్భాష'                                                                            => 'cel',
    'సేబుఆనో'                                                                                        => 'ceb',
    'సేర్బోక్రొయేషియన్'                                                          => 'sh',
    'సేల్కప్'                                                                                        => 'sel',
    'సైనోటిబిటన్భాష'                                                                   => 'sit',
    'సొంఘై'                                                                                              => 'son',
    'సోంగా'                                                                                              => 'ts',
    'సోగ్డియన్'                                                                                  => 'sog',
    'సోనింకి'                                                                                        => 'snk',
    'సోమాలి'                                                                                           => 'so',
    'సోర్బియన్భాష'                                                                         => 'wen',
    'స్కాటిష్గేలిక్'                                                                   => 'gd',
    'స్కాట్స్'                                                                                     => 'sco',
    'స్కోల్ట్సామి'                                                                         => 'sms',
    'స్పానిష్'                                                                                     => 'es',
    'స్రానన్టోనగో'                                                                         => 'srn',
    'స్లావిక్భాష'                                                                            => 'sla',
    'స్లేవ్'                                                                                           => 'den',
    'స్లోవాక్'                                                                                     => 'sk',
    'స్లోవేనియాన్'                                                                         => 'sl',
    'స్వాతి'                                                                                           => 'ss',
    'స్వాహిలి'                                                                                     => 'sw',
    'స్విస్జర్మన్'                                                                         => 'gsw',
    'స్విస్ఫ్రెంచ్'                                                                      => 'fr_ch',
    'స్విస్హైజర్మన్'                                                                   => 'de_ch',
    'స్వీడిష్'                                                                                     => 'sv',
    'హన్గేరియన్'                                                                               => 'hu',
    'హవాయియన్'                                                                                     => 'haw',
    'హిందీ'                                                                                              => 'hi',
    'హిట్టిటే'                                                                                     => 'hit',
    'హిమాచలి'                                                                                        => 'him',
    'హిరిమోటు'                                                                                     => 'ho',
    'హిరేరో'                                                                                           => 'hz',
    'హిలిగేయినోన్'                                                                         => 'hil',
    'హీబ్రు'                                                                                           => 'he',
    'హుపా'                                                                                                 => 'hup',
    'హైడా'                                                                                                 => 'hai',
    'హైయేతియన్'                                                                                  => 'ht',
    'హౌసా'                                                                                                 => 'ha',
);

1;
