package Locales::DB::Language::lv;

use strict;
use warnings;

# Auto generated from CLDR

$Locales::DB::Language::lv::VERSION = '0.09';

$Locales::DB::Language::lv::cldr_version = '2.0';

%Locales::DB::Language::lv::misc_info = (
    'characters'   => { 'more_information' => "\?" },
    'cldr_formats' => {
        '_decimal_format_decimal' => "\,",
        '_decimal_format_group'   => ' ',
        '_percent_format_percent' => "\%",
        'decimal'                 => "\#\,\#\#0\.\#\#\#",
        'ellipsis'                => {
            'final'   => "\{0\}…",
            'initial' => "…\{0\}",
            'medial'  => "\{0\}…\{1\}"
        },
        'language' => "Valoda\:\ \{0\}",
        'list'     => {
            2        => "\{0\}\ un\ \{1\}",
            'end'    => "\{0\}\ un\ \{1\}",
            'middle' => "\{0\}\,\ \{1\}",
            'start'  => "\{0\}\,\ \{1\}"
        },
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0\%",
        'territory' => "Reģions\:\ \{0\}"
    },
    'delimiters' => {
        'alternate_quotation_end'   => '’',
        'alternate_quotation_start' => '‘',
        'quotation_end'             => '”',
        'quotation_start'           => '“'
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'plural_forms' => {
        'category_list' => [
            'one',
            'zero',
            'other'
        ],
        'category_rules' => {
            'one'  => "n\ mod\ 10\ is\ 1\ and\ n\ mod\ 100\ is\ not\ 11",
            'zero' => "n\ is\ 0"
        },
        'category_rules_compiled' => {
            'one' => sub {
                if ( ( ( ( ( $_[0] % 10 ) + ( $_[0] - int( $_[0] ) ) ) == 1 ) && ( ( ( $_[0] % 100 ) + ( $_[0] - int( $_[0] ) ) ) != 11 ) ) ) { return 'one'; }
                return;
            },
            'zero' => sub {
                if ( ( ( $_[0] == 0 ) ) ) { return 'zero'; }
                return;
              }
        }
    },
    'posix' => {
        'nostr'  => "nē\:ne\:n",
        'yesstr' => "jā\:ja\:j"
    },
);

%Locales::DB::Language::lv::code_to_name = (
    'aa'    => 'afāru',
    'ab'    => 'abhāzu',
    'ace'   => 'ačinu',
    'ach'   => 'ačolu',
    'ada'   => 'adangmu',
    'ady'   => 'adigu',
    'ae'    => 'avesta',
    'af'    => 'afrikandu',
    'afa'   => "afroaziātu\ valodas",
    'afh'   => 'afrihili',
    'agq'   => 'Aghem',
    'ain'   => 'ainu',
    'ak'    => 'akanu',
    'akk'   => 'akadiešu',
    'ale'   => 'aleutu',
    'alg'   => "algonkinu\ valodas",
    'alt'   => 'dienvidaltajiešu',
    'am'    => 'amharu',
    'an'    => 'aragoniešu',
    'ang'   => 'senangļu',
    'anp'   => 'angika',
    'apa'   => "apaču\ valodas",
    'ar'    => 'arābu',
    'arc'   => 'aramiešu',
    'arn'   => 'araukāņu',
    'arp'   => 'arapahu',
    'art'   => "mākslīgās\ valodas",
    'arw'   => 'aravaku',
    'as'    => 'asamiešu',
    'asa'   => 'Asu',
    'ast'   => 'astūriešu',
    'ath'   => "atapasku\ valodas",
    'aus'   => "austrāliešu\ valodas",
    'av'    => 'avāru',
    'awa'   => 'avadhu',
    'ay'    => 'aimaru',
    'az'    => 'azerbaidžāņu',
    'ba'    => 'baškīru',
    'bad'   => 'bandu',
    'bai'   => "bamileku\ valodas",
    'bal'   => 'beludžu',
    'ban'   => 'baliešu',
    'bas'   => 'basu',
    'bat'   => "baltu\ valodas",
    'be'    => 'baltkrievu',
    'bej'   => 'bedžu',
    'bem'   => 'bembu',
    'ber'   => 'berberu',
    'bez'   => 'Bena',
    'bg'    => 'bulgāru',
    'bh'    => 'biharu',
    'bho'   => 'bhodžpūru',
    'bi'    => 'bišlamā',
    'bik'   => 'bikolu',
    'bin'   => 'binu',
    'bla'   => 'siksiku',
    'bm'    => 'bambaru',
    'bn'    => 'bengāļu',
    'bnt'   => 'bantu',
    'bo'    => 'tibetiešu',
    'br'    => 'bretoņu',
    'bra'   => 'bradžiešu',
    'brx'   => 'Bodo',
    'bs'    => 'bosniešu',
    'btk'   => 'bataku',
    'bua'   => 'burjatu',
    'bug'   => 'bugu',
    'byn'   => 'bilinu',
    'ca'    => 'katalāņu',
    'cad'   => 'kadu',
    'cai'   => "Centrālamerikas\ indiāņu\ valodas",
    'car'   => 'karību',
    'cau'   => "kaukāziešu\ valodas",
    'cay'   => 'Cayuga',
    'cch'   => 'Atsam',
    'ce'    => 'čečenu',
    'ceb'   => 'sebuāņu',
    'cel'   => "ķeltu\ valoda",
    'cgg'   => 'Chiga',
    'ch'    => 'čamorru',
    'chb'   => 'čibču',
    'chg'   => 'džagatajs',
    'chk'   => 'čūku',
    'chm'   => 'mariešu',
    'chn'   => "činuku\ žargons",
    'cho'   => 'čoktavu',
    'chp'   => 'čipevaianu',
    'chr'   => 'irokēzu',
    'chy'   => 'šejenu',
    'cmc'   => "čamiešu\ valodas",
    'co'    => 'korsikāņu',
    'cop'   => 'koptu',
    'cpe'   => "angliskās\ kreoliskās\ valodas\ un\ pidžinvalodas",
    'cpf'   => "franciskās\ kreoliskās\ valodas\ un\ pidžinvalodas",
    'cpp'   => "portugāliskās\ kreoliskās\ valodas\ un\ pidžinvalodas",
    'cr'    => 'krī',
    'crh'   => "Krimas\ tatāru",
    'crp'   => "kreoliskās\ valodas\ un\ pidžinvalodas",
    'cs'    => 'čehu',
    'csb'   => 'kašubu',
    'cu'    => 'baznīcslāvu',
    'cus'   => "kušītu\ valodas",
    'cv'    => 'čuvašu',
    'cy'    => 'velsiešu',
    'da'    => 'dāņu',
    'dak'   => 'dakotu',
    'dar'   => 'dargu',
    'dav'   => 'Taita',
    'day'   => 'dajaku',
    'de'    => 'vācu',
    'de_at' => "Austrijas\ vācu",
    'de_ch' => "Šveices\ augšvācu",
    'del'   => 'delavēru',
    'den'   => 'sleivu',
    'dgr'   => 'dogribu',
    'din'   => 'dinku',
    'dje'   => 'Zarma',
    'doi'   => 'dogru',
    'dra'   => "dravīdu\ valodas",
    'dsb'   => 'lejassorbu',
    'dua'   => 'dualu',
    'dum'   => 'vidusholandiešu',
    'dv'    => 'maldīviešu',
    'dyo'   => "Jola\-Fonyi",
    'dyu'   => 'diūlu',
    'dz'    => 'dzongke',
    'ebu'   => 'Embu',
    'ee'    => 'evu',
    'efi'   => 'efiku',
    'egy'   => 'ēģiptiešu',
    'eka'   => 'ekadžuku',
    'el'    => 'grieķu',
    'elx'   => 'elamiešu',
    'en'    => 'angļu',
    'en_au' => "Austrālijas\ angļu",
    'en_ca' => "Kanādas\ angļu",
    'en_gb' => "Lielbritānijas\ angļu",
    'en_us' => "ASV\ angļu",
    'enm'   => 'vidusangļu',
    'eo'    => 'esperanto',
    'es'    => 'spāņu',
    'es_es' => "ibēriešu\ spāņu",
    'et'    => 'igauņu',
    'eu'    => 'basku',
    'ewo'   => 'evondu',
    'fa'    => 'persiešu',
    'fan'   => 'fangu',
    'fat'   => 'fantu',
    'ff'    => 'fulu',
    'fi'    => 'somu',
    'fil'   => 'filipīniešu',
    'fiu'   => "somugru\ valodas",
    'fj'    => 'fidžiešu',
    'fo'    => 'fēru',
    'fon'   => 'fonu',
    'fr'    => 'franču',
    'fr_ca' => "Kanādas\ franču",
    'fr_ch' => "Šveices\ franču",
    'frm'   => 'vidusfranču',
    'fro'   => 'senfranču',
    'frr'   => 'ziemeļfrīzu',
    'frs'   => 'austrumfrīzu',
    'fur'   => 'friūlu',
    'fy'    => 'rietumfrīzu',
    'ga'    => 'īru',
    'gaa'   => 'ga',
    'gay'   => 'gajo',
    'gba'   => 'gbaju',
    'gd'    => 'gēlu',
    'gem'   => "ģermāņu\ valodas",
    'gez'   => 'gēzu',
    'gil'   => 'kiribatiešu',
    'gl'    => 'galisiešu',
    'gmh'   => 'vidusaugšvācu',
    'gn'    => 'gvaranu',
    'goh'   => 'senaugšvācu',
    'gon'   => "gondu\ valodas",
    'gor'   => 'gorontalu',
    'got'   => 'gotu',
    'grb'   => 'grebo',
    'grc'   => 'sengrieķu',
    'gsw'   => "Šveices\ vācu",
    'gu'    => 'gudžaratu',
    'guz'   => 'Gusii',
    'gv'    => 'meniešu',
    'gwi'   => 'kučinu',
    'ha'    => 'hausu',
    'hai'   => 'haidu',
    'haw'   => 'havajiešu',
    'he'    => 'ivrits',
    'hi'    => 'hindi',
    'hil'   => 'hiligainonu',
    'him'   => 'himačali',
    'hit'   => 'hetu',
    'hmn'   => 'hmongu',
    'ho'    => 'hirimotu',
    'hr'    => 'horvātu',
    'hsb'   => 'augšsorbu',
    'ht'    => 'haitiešu',
    'hu'    => 'ungāru',
    'hup'   => 'hupu',
    'hy'    => 'armēņu',
    'hz'    => 'hereru',
    'ia'    => 'interlingva',
    'iba'   => 'ibanu',
    'id'    => 'indonēziešu',
    'ie'    => 'interlingve',
    'ig'    => 'igbo',
    'ii'    => "Sičuaņas\ ji",
    'ijo'   => 'idžbu',
    'ik'    => 'inupiaku',
    'ilo'   => 'iloku',
    'inc'   => "indoāriešu\ valodas",
    'ine'   => "indoeiropiešu\ valodas",
    'inh'   => 'ingušu',
    'io'    => 'ido',
    'ira'   => "irāņu\ valodas",
    'iro'   => "irokēzu\ valodas",
    'is'    => 'īslandiešu',
    'it'    => 'itāļu',
    'iu'    => 'inuītu',
    'ja'    => 'japāņu',
    'jbo'   => 'ložbans',
    'jmc'   => 'Machame',
    'jpr'   => 'jūdpersiešu',
    'jrb'   => 'jūdarābu',
    'jv'    => 'javiešu',
    'ka'    => 'gruzīnu',
    'kaa'   => 'karakalpaku',
    'kab'   => 'kabilu',
    'kac'   => 'kačinu',
    'kaj'   => 'Jju',
    'kam'   => 'kambu',
    'kar'   => 'karenu',
    'kaw'   => 'kāvi',
    'kbd'   => 'kabardiešu',
    'kcg'   => 'Tyap',
    'kde'   => 'Makonde',
    'kea'   => 'Kabuverdianu',
    'kfo'   => 'koru',
    'kg'    => 'kongu',
    'kha'   => 'khasu',
    'khi'   => "hosjanu\ valodas",
    'kho'   => 'hotaniešu',
    'khq'   => "Koyra\ Chiini",
    'ki'    => 'kikuju',
    'kj'    => 'kvaņamu',
    'kk'    => 'kazahu',
    'kl'    => 'grenlandiešu',
    'kln'   => 'Kalenjin',
    'km'    => 'khmeru',
    'kmb'   => 'kimbundu',
    'kn'    => 'kannadu',
    'ko'    => 'korejiešu',
    'kok'   => 'konkanu',
    'kos'   => 'kosrājiešu',
    'kpe'   => 'kpellu',
    'kr'    => 'kanuru',
    'krc'   => "karačaju\ un\ balkāru",
    'krl'   => 'karēļu',
    'kro'   => 'krū',
    'kru'   => 'kuruhu',
    'ks'    => 'kašmiriešu',
    'ksb'   => 'Shambala',
    'ksf'   => 'Bafia',
    'ksh'   => 'Colognian',
    'ku'    => 'kurdu',
    'kum'   => 'kumiku',
    'kut'   => 'kutenaju',
    'kv'    => 'komiešu',
    'kw'    => 'korniešu',
    'ky'    => 'kirgīzu',
    'la'    => 'latīņu',
    'lad'   => 'ladino',
    'lag'   => 'Langi',
    'lah'   => 'landu',
    'lam'   => 'lambu',
    'lb'    => 'luksemburgiešu',
    'lez'   => 'lezgīnu',
    'lg'    => 'gandu',
    'li'    => 'limburgiešu',
    'ln'    => 'lingala',
    'lo'    => 'laosiešu',
    'lol'   => 'mongu',
    'loz'   => 'lozu',
    'lt'    => 'lietuviešu',
    'lu'    => 'lubakatanga',
    'lua'   => 'lubalulva',
    'lui'   => 'luisenu',
    'lun'   => 'lundu',
    'luo'   => 'luo',
    'lus'   => 'lušeju',
    'luy'   => 'Luyia',
    'lv'    => 'latviešu',
    'mad'   => 'maduriešu',
    'mag'   => 'magahiešu',
    'mai'   => 'maithili',
    'mak'   => 'makasaru',
    'man'   => 'mandingu',
    'map'   => "austronēziešu\ valoda",
    'mas'   => 'masaju',
    'mdf'   => 'mokšu',
    'mdr'   => 'mandaru',
    'men'   => 'mendu',
    'mer'   => 'Meru',
    'mfe'   => 'Morisyen',
    'mg'    => 'malagasu',
    'mga'   => 'vidusīru',
    'mgh'   => "Makhuwa\-Meetto",
    'mh'    => 'māršaliešu',
    'mi'    => 'maoru',
    'mic'   => 'mikmaku',
    'min'   => 'minangkabavu',
    'mis'   => "dažādas\ valodas",
    'mk'    => 'maķedoniešu',
    'mkh'   => "monkhmeru\ valodas",
    'ml'    => 'malajalu',
    'mn'    => 'mongoļu',
    'mnc'   => 'mandžūru',
    'mni'   => 'manipūru',
    'mno'   => "manobu\ valodas",
    'mo'    => 'moldāvu',
    'moh'   => 'mohauku',
    'mos'   => 'mosu',
    'mr'    => 'maratu',
    'ms'    => 'malajiešu',
    'mt'    => 'maltiešu',
    'mua'   => 'Mundang',
    'mul'   => "vairākas\ valodas",
    'mun'   => "mundu\ valodas",
    'mus'   => 'krīku',
    'mwl'   => 'mirandiešu',
    'mwr'   => 'marvaru',
    'my'    => 'birmiešu',
    'myn'   => "maiju\ valodas",
    'myv'   => 'erzju',
    'na'    => 'nauruiešu',
    'nah'   => 'navatlu',
    'nai'   => "Ziemeļamerikas\ indiāņu\ valodas",
    'nap'   => 'neapoliešu',
    'naq'   => 'Nama',
    'nb'    => "norvēģu\ bukmols",
    'nd'    => 'ziemeļndebelu',
    'nds'   => 'lejasvācu',
    'ne'    => 'nepāliešu',
    'new'   => 'nevaru',
    'ng'    => 'ndongu',
    'nia'   => 'njasu',
    'nic'   => "nigēriešu\-kordofāņu\ valodas",
    'niu'   => 'niuāņu',
    'nl'    => 'holandiešu',
    'nl_be' => 'flāmu',
    'nmg'   => 'Kwasio',
    'nn'    => 'jaunnorvēģu',
    'no'    => 'norvēģu',
    'nog'   => 'nogaju',
    'non'   => 'sennorvēģu',
    'nqo'   => 'nko',
    'nr'    => 'dienvidndebelu',
    'nso'   => 'ziemeļsotu',
    'nub'   => "nūbiešu\ valodas",
    'nus'   => 'Nuer',
    'nv'    => 'navahu',
    'nwc'   => "klasiskā\ nevaru",
    'ny'    => 'čičeva',
    'nym'   => 'ņamvezu',
    'nyn'   => 'ņankolu',
    'nyo'   => 'ņoru',
    'nzi'   => 'nzemu',
    'oc'    => 'oksitāņu',
    'oj'    => 'odžibvu',
    'om'    => 'oromu',
    'or'    => 'oriju',
    'os'    => 'osetīnu',
    'osa'   => 'važāžu',
    'ota'   => "turku\ osmaņu",
    'oto'   => "otomu\ valodas",
    'pa'    => 'pandžabu',
    'paa'   => "papuasu\ valodas",
    'pag'   => 'pangasinanu',
    'pal'   => 'pehlevi',
    'pam'   => 'pampanganu',
    'pap'   => 'papjamento',
    'pau'   => 'palaviešu',
    'peo'   => 'senpersu',
    'phi'   => "filipīniešu\ valodas",
    'phn'   => 'feniķiešu',
    'pi'    => 'pāli',
    'pl'    => 'poļu',
    'pon'   => 'ponapiešu',
    'pra'   => "prākrita\ valodas",
    'pro'   => 'senprovansiešu',
    'ps'    => 'puštu',
    'pt'    => 'portugāļu',
    'pt_br' => "Brazīlijas\ portugāļu",
    'pt_pt' => "ibēriešu\ portugāļu",
    'qu'    => 'kečvu',
    'raj'   => 'radžastāņu',
    'rap'   => 'rapanuju',
    'rar'   => 'rarotongiešu',
    'rm'    => 'retoromāņu',
    'rn'    => 'rundu',
    'ro'    => 'rumāņu',
    'roa'   => "romāņu\ valoda",
    'rof'   => 'Rombo',
    'rom'   => 'čigānu',
    'ru'    => 'krievu',
    'rup'   => 'aromūnu',
    'rw'    => 'kiņaruanda',
    'rwk'   => 'Rwa',
    'sa'    => 'sanskrits',
    'sad'   => 'sandavu',
    'sah'   => 'jakutu',
    'sai'   => "Dienvidamerikas\ indiāņu",
    'sal'   => "sališu\ valodas",
    'sam'   => "samārijas\ aramiešu",
    'saq'   => 'Samburu',
    'sas'   => 'sasaku',
    'sat'   => 'santalu',
    'sbp'   => 'Sangu',
    'sc'    => 'sardīniešu',
    'scn'   => 'sicīliešu',
    'sco'   => 'skotu',
    'sd'    => 'sindhu',
    'se'    => 'ziemeļsāmu',
    'see'   => 'Seneca',
    'seh'   => 'Sena',
    'sel'   => 'selkupu',
    'sem'   => "semītu\ valodas",
    'ses'   => "Koyraboro\ Senni",
    'sg'    => 'sangu',
    'sga'   => 'senīru',
    'sgn'   => "zīmju\ valodas",
    'sh'    => "serbu\-horvātu",
    'shi'   => 'Tachelhit',
    'shn'   => 'šanu',
    'si'    => 'singāļu',
    'sid'   => 'sidamu',
    'sio'   => "siū\ valodas",
    'sit'   => "sinotibetiešu\ valodas",
    'sk'    => 'slovāku',
    'sl'    => 'slovēņu',
    'sla'   => 'slāvu',
    'sm'    => 'samoāņu',
    'sma'   => 'dienvidsāmu',
    'smi'   => "sāmu\ valodas",
    'smj'   => "luleo\ sāmu",
    'smn'   => "inari\ sāmu",
    'sms'   => 'skoltsāmu',
    'sn'    => 'šonu',
    'snk'   => 'soninku',
    'so'    => 'somāļu',
    'sog'   => 'sogdiešu',
    'son'   => 'songaju',
    'sq'    => 'albāņu',
    'sr'    => 'serbu',
    'srn'   => 'sranantogo',
    'srr'   => 'serēru',
    'ss'    => 'svatu',
    'ssa'   => "nīlas\-sahāras\ valodas",
    'ssy'   => 'Saho',
    'st'    => 'dienvidsotu',
    'su'    => 'sundaniešu',
    'suk'   => 'sukumu',
    'sus'   => 'susu',
    'sux'   => 'šumeru',
    'sv'    => 'zviedru',
    'sw'    => 'svahili',
    'swb'   => 'komoru',
    'swc'   => "Congo\ Swahili",
    'syc'   => "klasiskā\ sīriešu",
    'syr'   => 'sīriešu',
    'ta'    => 'tamilu',
    'tai'   => "taju\ valodas",
    'te'    => 'telugu',
    'tem'   => 'temnu',
    'teo'   => 'Teso',
    'ter'   => 'tereno',
    'tet'   => 'tetumu',
    'tg'    => 'tadžiku',
    'th'    => 'taju',
    'ti'    => 'tigrinja',
    'tig'   => 'tigru',
    'tiv'   => 'tivu',
    'tk'    => 'turkmēņu',
    'tkl'   => 'tokelaviešu',
    'tl'    => 'tagalu',
    'tlh'   => 'klingoņu',
    'tli'   => 'tlinkitu',
    'tmh'   => 'tuaregu',
    'tn'    => 'cvanu',
    'to'    => 'tongu',
    'tog'   => "njasas\ tongu",
    'tpi'   => 'tokpisins',
    'tr'    => 'turku',
    'trv'   => 'Taroko',
    'ts'    => 'congu',
    'tsi'   => 'cimšiāņu',
    'tt'    => 'tatāru',
    'tum'   => 'tumbuku',
    'tup'   => "tupu\ valodas",
    'tut'   => "altajiešu\ valodas",
    'tvl'   => 'tuvaliešu',
    'tw'    => 'tvī',
    'twq'   => 'Tasawaq',
    'ty'    => 'taitiešu',
    'tyv'   => 'tuviešu',
    'tzm'   => "Central\ Morocco\ Tamazight",
    'udm'   => 'udmurtu',
    'ug'    => 'uiguru',
    'uga'   => 'ugaritiešu',
    'uk'    => 'ukraiņu',
    'umb'   => 'umbundu',
    'und'   => "nezināma\ vai\ nederīga\ valoda",
    'ur'    => 'urdu',
    'uz'    => 'uzbeku',
    'vai'   => 'vaju',
    've'    => 'vendu',
    'vi'    => 'vjetnamiešu',
    'vo'    => 'volapiks',
    'vot'   => 'votu',
    'vun'   => 'Vunjo',
    'wa'    => 'valoņu',
    'wae'   => 'Walser',
    'wak'   => "vakašu\ valodas",
    'wal'   => 'valamu',
    'war'   => 'varaju',
    'was'   => 'vašo',
    'wen'   => 'sorbu',
    'wo'    => 'volofu',
    'xal'   => 'kalmiku',
    'xh'    => 'khosu',
    'xog'   => 'Soga',
    'yao'   => 'jao',
    'yap'   => 'japiešu',
    'yav'   => 'Yangben',
    'yi'    => 'jidišs',
    'yo'    => 'jorubu',
    'ypk'   => "jopiku\ valodas",
    'yue'   => 'kantoniešu',
    'za'    => 'džuanu',
    'zap'   => 'sapoteku',
    'zbl'   => 'Blissymbols',
    'zen'   => 'zenagu',
    'zh'    => 'ķīniešu',
    'znd'   => 'zandē',
    'zu'    => 'zulu',
    'zun'   => 'zunju',
    'zxx'   => "bez\ lingvistiska\ satura",
    'zza'   => 'Zaza',
);

%Locales::DB::Language::lv::name_to_code = (
    'abhāzu'                                           => 'ab',
    'adangmu'                                           => 'ada',
    'adigu'                                             => 'ady',
    'afrihili'                                          => 'afh',
    'afrikandu'                                         => 'af',
    'afroaziātuvalodas'                                => 'afa',
    'afāru'                                            => 'aa',
    'aghem'                                             => 'agq',
    'aimaru'                                            => 'ay',
    'ainu'                                              => 'ain',
    'akadiešu'                                         => 'akk',
    'akanu'                                             => 'ak',
    'albāņu'                                          => 'sq',
    'aleutu'                                            => 'ale',
    'algonkinuvalodas'                                  => 'alg',
    'altajiešuvalodas'                                 => 'tut',
    'amharu'                                            => 'am',
    'angika'                                            => 'anp',
    'angliskāskreoliskāsvalodasunpidžinvalodas'      => 'cpe',
    'angļu'                                            => 'en',
    'apačuvalodas'                                     => 'apa',
    'aragoniešu'                                       => 'an',
    'aramiešu'                                         => 'arc',
    'arapahu'                                           => 'arp',
    'araukāņu'                                        => 'arn',
    'aravaku'                                           => 'arw',
    'armēņu'                                          => 'hy',
    'aromūnu'                                          => 'rup',
    'arābu'                                            => 'ar',
    'asamiešu'                                         => 'as',
    'astūriešu'                                       => 'ast',
    'asu'                                               => 'asa',
    'asvangļu'                                         => 'en_us',
    'atapaskuvalodas'                                   => 'ath',
    'atsam'                                             => 'cch',
    'augšsorbu'                                        => 'hsb',
    'austrijasvācu'                                    => 'de_at',
    'austronēziešuvaloda'                             => 'map',
    'austrumfrīzu'                                     => 'frs',
    'austrāliešuvalodas'                              => 'aus',
    'austrālijasangļu'                                => 'en_au',
    'avadhu'                                            => 'awa',
    'avesta'                                            => 'ae',
    'avāru'                                            => 'av',
    'azerbaidžāņu'                                   => 'az',
    'ačinu'                                            => 'ace',
    'ačolu'                                            => 'ach',
    'bafia'                                             => 'ksf',
    'baliešu'                                          => 'ban',
    'baltkrievu'                                        => 'be',
    'baltuvalodas'                                      => 'bat',
    'bambaru'                                           => 'bm',
    'bamilekuvalodas'                                   => 'bai',
    'bandu'                                             => 'bad',
    'bantu'                                             => 'bnt',
    'basku'                                             => 'eu',
    'basu'                                              => 'bas',
    'bataku'                                            => 'btk',
    'baznīcslāvu'                                     => 'cu',
    'baškīru'                                         => 'ba',
    'bedžu'                                            => 'bej',
    'beludžu'                                          => 'bal',
    'bembu'                                             => 'bem',
    'bena'                                              => 'bez',
    'bengāļu'                                         => 'bn',
    'berberu'                                           => 'ber',
    'bezlingvistiskasatura'                             => 'zxx',
    'bhodžpūru'                                       => 'bho',
    'biharu'                                            => 'bh',
    'bikolu'                                            => 'bik',
    'bilinu'                                            => 'byn',
    'binu'                                              => 'bin',
    'birmiešu'                                         => 'my',
    'bišlamā'                                         => 'bi',
    'blissymbols'                                       => 'zbl',
    'bodo'                                              => 'brx',
    'bosniešu'                                         => 'bs',
    'bradžiešu'                                       => 'bra',
    'brazīlijasportugāļu'                            => 'pt_br',
    'bretoņu'                                          => 'br',
    'bugu'                                              => 'bug',
    'bulgāru'                                          => 'bg',
    'burjatu'                                           => 'bua',
    'cayuga'                                            => 'cay',
    'centralmoroccotamazight'                           => 'tzm',
    'centrālamerikasindiāņuvalodas'                  => 'cai',
    'chiga'                                             => 'cgg',
    'cimšiāņu'                                       => 'tsi',
    'colognian'                                         => 'ksh',
    'congoswahili'                                      => 'swc',
    'congu'                                             => 'ts',
    'cvanu'                                             => 'tn',
    'dajaku'                                            => 'day',
    'dakotu'                                            => 'dak',
    'dargu'                                             => 'dar',
    'dažādasvalodas'                                  => 'mis',
    'delavēru'                                         => 'del',
    'dienvidaltajiešu'                                 => 'alt',
    'dienvidamerikasindiāņu'                          => 'sai',
    'dienvidndebelu'                                    => 'nr',
    'dienvidsotu'                                       => 'st',
    'dienvidsāmu'                                      => 'sma',
    'dinku'                                             => 'din',
    'diūlu'                                            => 'dyu',
    'dogribu'                                           => 'dgr',
    'dogru'                                             => 'doi',
    'dravīduvalodas'                                   => 'dra',
    'dualu'                                             => 'dua',
    'dzongke'                                           => 'dz',
    'dāņu'                                            => 'da',
    'džagatajs'                                        => 'chg',
    'džuanu'                                           => 'za',
    'efiku'                                             => 'efi',
    'ekadžuku'                                         => 'eka',
    'elamiešu'                                         => 'elx',
    'embu'                                              => 'ebu',
    'erzju'                                             => 'myv',
    'esperanto'                                         => 'eo',
    'evondu'                                            => 'ewo',
    'evu'                                               => 'ee',
    'fangu'                                             => 'fan',
    'fantu'                                             => 'fat',
    'feniķiešu'                                       => 'phn',
    'fidžiešu'                                        => 'fj',
    'filipīniešu'                                     => 'fil',
    'filipīniešuvalodas'                              => 'phi',
    'flāmu'                                            => 'nl_be',
    'fonu'                                              => 'fon',
    'franciskāskreoliskāsvalodasunpidžinvalodas'     => 'cpf',
    'franču'                                           => 'fr',
    'friūlu'                                           => 'fur',
    'fulu'                                              => 'ff',
    'fēru'                                             => 'fo',
    'ga'                                                => 'gaa',
    'gajo'                                              => 'gay',
    'galisiešu'                                        => 'gl',
    'gandu'                                             => 'lg',
    'gbaju'                                             => 'gba',
    'gonduvalodas'                                      => 'gon',
    'gorontalu'                                         => 'gor',
    'gotu'                                              => 'got',
    'grebo'                                             => 'grb',
    'grenlandiešu'                                     => 'kl',
    'grieķu'                                           => 'el',
    'gruzīnu'                                          => 'ka',
    'gudžaratu'                                        => 'gu',
    'gusii'                                             => 'guz',
    'gvaranu'                                           => 'gn',
    'gēlu'                                             => 'gd',
    'gēzu'                                             => 'gez',
    'haidu'                                             => 'hai',
    'haitiešu'                                         => 'ht',
    'hausu'                                             => 'ha',
    'havajiešu'                                        => 'haw',
    'hereru'                                            => 'hz',
    'hetu'                                              => 'hit',
    'hiligainonu'                                       => 'hil',
    'himačali'                                         => 'him',
    'hindi'                                             => 'hi',
    'hirimotu'                                          => 'ho',
    'hmongu'                                            => 'hmn',
    'holandiešu'                                       => 'nl',
    'horvātu'                                          => 'hr',
    'hosjanuvalodas'                                    => 'khi',
    'hotaniešu'                                        => 'kho',
    'hupu'                                              => 'hup',
    'ibanu'                                             => 'iba',
    'ibēriešuportugāļu'                             => 'pt_pt',
    'ibēriešuspāņu'                                 => 'es_es',
    'ido'                                               => 'io',
    'idžbu'                                            => 'ijo',
    'igauņu'                                           => 'et',
    'igbo'                                              => 'ig',
    'iloku'                                             => 'ilo',
    'inarisāmu'                                        => 'smn',
    'indoeiropiešuvalodas'                             => 'ine',
    'indonēziešu'                                     => 'id',
    'indoāriešuvalodas'                               => 'inc',
    'ingušu'                                           => 'inh',
    'interlingva'                                       => 'ia',
    'interlingve'                                       => 'ie',
    'inupiaku'                                          => 'ik',
    'inuītu'                                           => 'iu',
    'irokēzu'                                          => 'chr',
    'irokēzuvalodas'                                   => 'iro',
    'irāņuvalodas'                                    => 'ira',
    'itāļu'                                           => 'it',
    'ivrits'                                            => 'he',
    'jakutu'                                            => 'sah',
    'jao'                                               => 'yao',
    'japiešu'                                          => 'yap',
    'japāņu'                                          => 'ja',
    'jaunnorvēģu'                                     => 'nn',
    'javiešu'                                          => 'jv',
    'jidišs'                                           => 'yi',
    'jju'                                               => 'kaj',
    'jolafonyi'                                         => 'dyo',
    'jopikuvalodas'                                     => 'ypk',
    'jorubu'                                            => 'yo',
    'jūdarābu'                                        => 'jrb',
    'jūdpersiešu'                                     => 'jpr',
    'kabardiešu'                                       => 'kbd',
    'kabilu'                                            => 'kab',
    'kabuverdianu'                                      => 'kea',
    'kadu'                                              => 'cad',
    'kalenjin'                                          => 'kln',
    'kalmiku'                                           => 'xal',
    'kambu'                                             => 'kam',
    'kannadu'                                           => 'kn',
    'kantoniešu'                                       => 'yue',
    'kanuru'                                            => 'kr',
    'kanādasangļu'                                    => 'en_ca',
    'kanādasfranču'                                   => 'fr_ca',
    'karakalpaku'                                       => 'kaa',
    'karačajuunbalkāru'                               => 'krc',
    'karenu'                                            => 'kar',
    'karēļu'                                          => 'krl',
    'karību'                                           => 'car',
    'katalāņu'                                        => 'ca',
    'kaukāziešuvalodas'                               => 'cau',
    'kazahu'                                            => 'kk',
    'kačinu'                                           => 'kac',
    'kašmiriešu'                                      => 'ks',
    'kašubu'                                           => 'csb',
    'kečvu'                                            => 'qu',
    'khasu'                                             => 'kha',
    'khmeru'                                            => 'km',
    'khosu'                                             => 'xh',
    'kikuju'                                            => 'ki',
    'kimbundu'                                          => 'kmb',
    'kirgīzu'                                          => 'ky',
    'kiribatiešu'                                      => 'gil',
    'kiņaruanda'                                       => 'rw',
    'klasiskānevaru'                                   => 'nwc',
    'klasiskāsīriešu'                                => 'syc',
    'klingoņu'                                         => 'tlh',
    'komiešu'                                          => 'kv',
    'komoru'                                            => 'swb',
    'kongu'                                             => 'kg',
    'konkanu'                                           => 'kok',
    'koptu'                                             => 'cop',
    'korejiešu'                                        => 'ko',
    'korniešu'                                         => 'kw',
    'korsikāņu'                                       => 'co',
    'koru'                                              => 'kfo',
    'kosrājiešu'                                      => 'kos',
    'koyraborosenni'                                    => 'ses',
    'koyrachiini'                                       => 'khq',
    'kpellu'                                            => 'kpe',
    'kreoliskāsvalodasunpidžinvalodas'                => 'crp',
    'krievu'                                            => 'ru',
    'krimastatāru'                                     => 'crh',
    'krī'                                              => 'cr',
    'krīku'                                            => 'mus',
    'krū'                                              => 'kro',
    'kumiku'                                            => 'kum',
    'kurdu'                                             => 'ku',
    'kuruhu'                                            => 'kru',
    'kutenaju'                                          => 'kut',
    'kučinu'                                           => 'gwi',
    'kušītuvalodas'                                   => 'cus',
    'kvaņamu'                                          => 'kj',
    'kwasio'                                            => 'nmg',
    'kāvi'                                             => 'kaw',
    'ladino'                                            => 'lad',
    'lambu'                                             => 'lam',
    'landu'                                             => 'lah',
    'langi'                                             => 'lag',
    'laosiešu'                                         => 'lo',
    'latviešu'                                         => 'lv',
    'latīņu'                                          => 'la',
    'lejassorbu'                                        => 'dsb',
    'lejasvācu'                                        => 'nds',
    'lezgīnu'                                          => 'lez',
    'lielbritānijasangļu'                             => 'en_gb',
    'lietuviešu'                                       => 'lt',
    'limburgiešu'                                      => 'li',
    'lingala'                                           => 'ln',
    'lozu'                                              => 'loz',
    'ložbans'                                          => 'jbo',
    'lubakatanga'                                       => 'lu',
    'lubalulva'                                         => 'lua',
    'luisenu'                                           => 'lui',
    'luksemburgiešu'                                   => 'lb',
    'luleosāmu'                                        => 'smj',
    'lundu'                                             => 'lun',
    'luo'                                               => 'luo',
    'luyia'                                             => 'luy',
    'lušeju'                                           => 'lus',
    'machame'                                           => 'jmc',
    'maduriešu'                                        => 'mad',
    'magahiešu'                                        => 'mag',
    'maijuvalodas'                                      => 'myn',
    'maithili'                                          => 'mai',
    'makasaru'                                          => 'mak',
    'makhuwameetto'                                     => 'mgh',
    'makonde'                                           => 'kde',
    'malagasu'                                          => 'mg',
    'malajalu'                                          => 'ml',
    'malajiešu'                                        => 'ms',
    'maldīviešu'                                      => 'dv',
    'maltiešu'                                         => 'mt',
    'mandaru'                                           => 'mdr',
    'mandingu'                                          => 'man',
    'mandžūru'                                        => 'mnc',
    'manipūru'                                         => 'mni',
    'manobuvalodas'                                     => 'mno',
    'maoru'                                             => 'mi',
    'maratu'                                            => 'mr',
    'mariešu'                                          => 'chm',
    'marvaru'                                           => 'mwr',
    'masaju'                                            => 'mas',
    'maķedoniešu'                                     => 'mk',
    'mendu'                                             => 'men',
    'meniešu'                                          => 'gv',
    'meru'                                              => 'mer',
    'mikmaku'                                           => 'mic',
    'minangkabavu'                                      => 'min',
    'mirandiešu'                                       => 'mwl',
    'mohauku'                                           => 'moh',
    'mokšu'                                            => 'mdf',
    'moldāvu'                                          => 'mo',
    'mongoļu'                                          => 'mn',
    'mongu'                                             => 'lol',
    'monkhmeruvalodas'                                  => 'mkh',
    'morisyen'                                          => 'mfe',
    'mosu'                                              => 'mos',
    'mundang'                                           => 'mua',
    'munduvalodas'                                      => 'mun',
    'mākslīgāsvalodas'                               => 'art',
    'māršaliešu'                                     => 'mh',
    'nama'                                              => 'naq',
    'nauruiešu'                                        => 'na',
    'navahu'                                            => 'nv',
    'navatlu'                                           => 'nah',
    'ndongu'                                            => 'ng',
    'neapoliešu'                                       => 'nap',
    'nepāliešu'                                       => 'ne',
    'nevaru'                                            => 'new',
    'nezināmavainederīgavaloda'                       => 'und',
    'nigēriešukordofāņuvalodas'                     => 'nic',
    'niuāņu'                                          => 'niu',
    'njasastongu'                                       => 'tog',
    'njasu'                                             => 'nia',
    'nko'                                               => 'nqo',
    'nogaju'                                            => 'nog',
    'norvēģu'                                         => 'no',
    'norvēģubukmols'                                  => 'nb',
    'nuer'                                              => 'nus',
    'nzemu'                                             => 'nzi',
    'nīlassahārasvalodas'                             => 'ssa',
    'nūbiešuvalodas'                                  => 'nub',
    'odžibvu'                                          => 'oj',
    'oksitāņu'                                        => 'oc',
    'oriju'                                             => 'or',
    'oromu'                                             => 'om',
    'osetīnu'                                          => 'os',
    'otomuvalodas'                                      => 'oto',
    'palaviešu'                                        => 'pau',
    'pampanganu'                                        => 'pam',
    'pandžabu'                                         => 'pa',
    'pangasinanu'                                       => 'pag',
    'papjamento'                                        => 'pap',
    'papuasuvalodas'                                    => 'paa',
    'pehlevi'                                           => 'pal',
    'persiešu'                                         => 'fa',
    'ponapiešu'                                        => 'pon',
    'portugāliskāskreoliskāsvalodasunpidžinvalodas' => 'cpp',
    'portugāļu'                                       => 'pt',
    'poļu'                                             => 'pl',
    'prākritavalodas'                                  => 'pra',
    'puštu'                                            => 'ps',
    'pāli'                                             => 'pi',
    'radžastāņu'                                     => 'raj',
    'rapanuju'                                          => 'rap',
    'rarotongiešu'                                     => 'rar',
    'retoromāņu'                                      => 'rm',
    'rietumfrīzu'                                      => 'fy',
    'rombo'                                             => 'rof',
    'romāņuvaloda'                                    => 'roa',
    'rumāņu'                                          => 'ro',
    'rundu'                                             => 'rn',
    'rwa'                                               => 'rwk',
    'saho'                                              => 'ssy',
    'sališuvalodas'                                    => 'sal',
    'samburu'                                           => 'saq',
    'samoāņu'                                         => 'sm',
    'samārijasaramiešu'                               => 'sam',
    'sandavu'                                           => 'sad',
    'sangu'                                             => 'sbp',
    'sanskrits'                                         => 'sa',
    'santalu'                                           => 'sat',
    'sapoteku'                                          => 'zap',
    'sardīniešu'                                      => 'sc',
    'sasaku'                                            => 'sas',
    'sebuāņu'                                         => 'ceb',
    'selkupu'                                           => 'sel',
    'semītuvalodas'                                    => 'sem',
    'sena'                                              => 'seh',
    'senangļu'                                         => 'ang',
    'senaugšvācu'                                     => 'goh',
    'seneca'                                            => 'see',
    'senfranču'                                        => 'fro',
    'sengrieķu'                                        => 'grc',
    'sennorvēģu'                                      => 'non',
    'senpersu'                                          => 'peo',
    'senprovansiešu'                                   => 'pro',
    'senīru'                                           => 'sga',
    'serbu'                                             => 'sr',
    'serbuhorvātu'                                     => 'sh',
    'serēru'                                           => 'srr',
    'shambala'                                          => 'ksb',
    'sicīliešu'                                       => 'scn',
    'sidamu'                                            => 'sid',
    'siksiku'                                           => 'bla',
    'sindhu'                                            => 'sd',
    'singāļu'                                         => 'si',
    'sinotibetiešuvalodas'                             => 'sit',
    'sičuaņasji'                                      => 'ii',
    'siūvalodas'                                       => 'sio',
    'skoltsāmu'                                        => 'sms',
    'skotu'                                             => 'sco',
    'sleivu'                                            => 'den',
    'slovāku'                                          => 'sk',
    'slovēņu'                                         => 'sl',
    'slāvu'                                            => 'sla',
    'soga'                                              => 'xog',
    'sogdiešu'                                         => 'sog',
    'somu'                                              => 'fi',
    'somugruvalodas'                                    => 'fiu',
    'somāļu'                                          => 'so',
    'songaju'                                           => 'son',
    'soninku'                                           => 'snk',
    'sorbu'                                             => 'wen',
    'spāņu'                                           => 'es',
    'sranantogo'                                        => 'srn',
    'sukumu'                                            => 'suk',
    'sundaniešu'                                       => 'su',
    'susu'                                              => 'sus',
    'svahili'                                           => 'sw',
    'svatu'                                             => 'ss',
    'sāmuvalodas'                                      => 'smi',
    'sīriešu'                                         => 'syr',
    'tachelhit'                                         => 'shi',
    'tadžiku'                                          => 'tg',
    'tagalu'                                            => 'tl',
    'taita'                                             => 'dav',
    'taitiešu'                                         => 'ty',
    'taju'                                              => 'th',
    'tajuvalodas'                                       => 'tai',
    'tamilu'                                            => 'ta',
    'taroko'                                            => 'trv',
    'tasawaq'                                           => 'twq',
    'tatāru'                                           => 'tt',
    'telugu'                                            => 'te',
    'temnu'                                             => 'tem',
    'tereno'                                            => 'ter',
    'teso'                                              => 'teo',
    'tetumu'                                            => 'tet',
    'tibetiešu'                                        => 'bo',
    'tigrinja'                                          => 'ti',
    'tigru'                                             => 'tig',
    'tivu'                                              => 'tiv',
    'tlinkitu'                                          => 'tli',
    'tokelaviešu'                                      => 'tkl',
    'tokpisins'                                         => 'tpi',
    'tongu'                                             => 'to',
    'tuaregu'                                           => 'tmh',
    'tumbuku'                                           => 'tum',
    'tupuvalodas'                                       => 'tup',
    'turkmēņu'                                        => 'tk',
    'turku'                                             => 'tr',
    'turkuosmaņu'                                      => 'ota',
    'tuvaliešu'                                        => 'tvl',
    'tuviešu'                                          => 'tyv',
    'tvī'                                              => 'tw',
    'tyap'                                              => 'kcg',
    'udmurtu'                                           => 'udm',
    'ugaritiešu'                                       => 'uga',
    'uiguru'                                            => 'ug',
    'ukraiņu'                                          => 'uk',
    'umbundu'                                           => 'umb',
    'ungāru'                                           => 'hu',
    'urdu'                                              => 'ur',
    'uzbeku'                                            => 'uz',
    'vairākasvalodas'                                  => 'mul',
    'vaju'                                              => 'vai',
    'vakašuvalodas'                                    => 'wak',
    'valamu'                                            => 'wal',
    'valoņu'                                           => 'wa',
    'varaju'                                            => 'war',
    'vašo'                                             => 'was',
    'važāžu'                                         => 'osa',
    'velsiešu'                                         => 'cy',
    'vendu'                                             => 've',
    'vidusangļu'                                       => 'enm',
    'vidusaugšvācu'                                   => 'gmh',
    'vidusfranču'                                      => 'frm',
    'vidusholandiešu'                                  => 'dum',
    'vidusīru'                                         => 'mga',
    'vjetnamiešu'                                      => 'vi',
    'volapiks'                                          => 'vo',
    'volofu'                                            => 'wo',
    'votu'                                              => 'vot',
    'vunjo'                                             => 'vun',
    'vācu'                                             => 'de',
    'walser'                                            => 'wae',
    'yangben'                                           => 'yav',
    'zandē'                                            => 'znd',
    'zarma'                                             => 'dje',
    'zaza'                                              => 'zza',
    'zenagu'                                            => 'zen',
    'ziemeļamerikasindiāņuvalodas'                   => 'nai',
    'ziemeļfrīzu'                                     => 'frr',
    'ziemeļndebelu'                                    => 'nd',
    'ziemeļsotu'                                       => 'nso',
    'ziemeļsāmu'                                      => 'se',
    'zulu'                                              => 'zu',
    'zunju'                                             => 'zun',
    'zviedru'                                           => 'sv',
    'zīmjuvalodas'                                     => 'sgn',
    'čamiešuvalodas'                                  => 'cmc',
    'čamorru'                                          => 'ch',
    'čehu'                                             => 'cs',
    'čečenu'                                          => 'ce',
    'čibču'                                           => 'chb',
    'čigānu'                                          => 'rom',
    'činukužargons'                                   => 'chn',
    'čipevaianu'                                       => 'chp',
    'čičeva'                                          => 'ny',
    'čoktavu'                                          => 'cho',
    'čuvašu'                                          => 'cv',
    'čūku'                                            => 'chk',
    'ēģiptiešu'                                      => 'egy',
    'ģermāņuvalodas'                                 => 'gem',
    'īru'                                              => 'ga',
    'īslandiešu'                                      => 'is',
    'ķeltuvaloda'                                      => 'cel',
    'ķīniešu'                                        => 'zh',
    'ņamvezu'                                          => 'nym',
    'ņankolu'                                          => 'nyn',
    'ņoru'                                             => 'nyo',
    'Šveicesaugšvācu'                                => 'de_ch',
    'Šveicesfranču'                                   => 'fr_ch',
    'Šveicesvācu'                                     => 'gsw',
    'šanu'                                             => 'shn',
    'šejenu'                                           => 'chy',
    'šonu'                                             => 'sn',
    'šumeru'                                           => 'sux',
);

1;
