package Locales::DB::Language::ko;

use strict;
use warnings;

# Auto generated from CLDR

$Locales::DB::Language::ko::VERSION = '0.09';

$Locales::DB::Language::ko::cldr_version = '2.0';

%Locales::DB::Language::ko::misc_info = (
    'characters'   => { 'more_information' => "\?" },
    'cldr_formats' => {
        '_decimal_format_decimal' => "\.",
        '_decimal_format_group'   => "\,",
        '_percent_format_percent' => "\%",
        'decimal'                 => "\#\,\#\#0\.\#\#\#",
        'ellipsis'                => {
            'final'   => "\{0\}…",
            'initial' => "…\{0\}",
            'medial'  => "\{0\}\.\.\.\{1\}"
        },
        'language' => "언어\:\ \{0\}",
        'list'     => {
            2        => "\{0\}\ 및\ \{1\}",
            'end'    => "\{0\}\ 및\ \{1\}",
            'middle' => "\{0\}\,\ \{1\}",
            'start'  => "\{0\}\,\ \{1\}"
        },
        'locale'    => "\{0\}\(\{1\}\)",
        'percent'   => "\#\,\#\#0\%",
        'territory' => "지역\:\ \{0\}"
    },
    'delimiters' => {
        'alternate_quotation_end'   => '”',
        'alternate_quotation_start' => '“',
        'quotation_end'             => '’',
        'quotation_start'           => '‘'
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'plural_forms' => {
        'category_list'  => ['other'],
        'category_rules' => {}
    },
    'posix' => {
        'nostr'  => '아니오',
        'yesstr' => '예'
    },
);

%Locales::DB::Language::ko::code_to_name = (
    'aa'    => '아파르어',
    'ab'    => '압카즈어',
    'ace'   => '아체어',
    'ach'   => '아콜리어',
    'ada'   => '아당메어',
    'ady'   => '아닥헤어',
    'ae'    => '아베스타어',
    'af'    => "남아공\ 공용어",
    'afa'   => "아시아\-아프리카어\ \(기타\)",
    'afh'   => '아프리히리어',
    'agq'   => 'Aghem',
    'ain'   => '아이누어',
    'ak'    => '아칸어',
    'akk'   => '아카드어',
    'ale'   => '알류트어',
    'alg'   => '알공킨어족',
    'alt'   => "남부\ 알타이어",
    'am'    => '암하라어',
    'an'    => '아라곤어',
    'ang'   => "고대\ 영어",
    'anp'   => '앙가어',
    'apa'   => '아파치어',
    'ar'    => '아랍어',
    'arc'   => '아람어',
    'arn'   => '아라우칸어',
    'arp'   => '아라파호어',
    'art'   => "기계어\ \(기타\)",
    'arw'   => '아라와크어',
    'as'    => '아샘어',
    'asa'   => 'Asu',
    'ast'   => '아스투리아어',
    'ath'   => '아타파스카어군',
    'aus'   => '오스트레일리아어족',
    'av'    => '아바릭어',
    'awa'   => '아와히어',
    'ay'    => '아이마라어',
    'az'    => '아제리어',
    'ba'    => '바슈키르어',
    'bad'   => '반다어',
    'bai'   => '바밀레케어족',
    'bal'   => '발루치어',
    'ban'   => '발리어',
    'bas'   => '바사어',
    'bat'   => "발트어\ \(기타\)",
    'be'    => '벨로루시어',
    'bej'   => '베자어',
    'bem'   => '벰바어',
    'ber'   => '베르베르어',
    'bez'   => 'Bena',
    'bg'    => '불가리아어',
    'bh'    => '비하르어',
    'bho'   => '호즈푸리어',
    'bi'    => '비슬라마어',
    'bik'   => '비콜어',
    'bin'   => '비니어',
    'bla'   => '식시카어',
    'bm'    => '밤바라어',
    'bn'    => '벵골어',
    'bnt'   => '반투어',
    'bo'    => '티베트어',
    'br'    => '브르타뉴어',
    'bra'   => '브라지어',
    'brx'   => 'Bodo',
    'bs'    => '보스니아어',
    'btk'   => '바타크어',
    'bua'   => '부리아타',
    'bug'   => '부기어',
    'byn'   => '브린어',
    'ca'    => '카탈로니아어',
    'cad'   => '카도어',
    'cai'   => "중앙\ 아메리카\ 인디안어\ \(기타\)",
    'car'   => '카리브어',
    'cau'   => "카프카스어\ \(기타\)",
    'cay'   => 'Cayuga',
    'cch'   => '아삼어',
    'ce'    => '체첸어',
    'ceb'   => '세부아노어',
    'cel'   => "켈트어\ \(기타\)",
    'cgg'   => 'Chiga',
    'ch'    => '차모로어',
    'chb'   => '치브차어',
    'chg'   => '차가타이어',
    'chk'   => '추크어',
    'chm'   => '마리어',
    'chn'   => "치누크어와\ 영어\ 프랑스어의\ 혼성어",
    'cho'   => '촉토어',
    'chp'   => '치페우얀',
    'chr'   => '체로키어',
    'chy'   => '샤이엔어',
    'cmc'   => '참어군',
    'co'    => '코르시카어',
    'cop'   => '콥트어',
    'cpe'   => "크리올어\ 및\ 피진어\ \(영어를\ 기반으로\ 한\ 기타\)",
    'cpf'   => "크리올어\ 및\ 피진어\ \(프랑스어를\ 기반으로\ 한\ 기타\)",
    'cpp'   => "크리올어\ 및\ 피진어\ \(포르투갈어를\ 기반으로\ 한\ 기타\)",
    'cr'    => '크리어',
    'crh'   => "크리민\ 터키어\;\ 크리민\ 타타르어",
    'crp'   => "크리올어\ 및\ 피진어\ \(기타\)",
    'cs'    => '체코어',
    'csb'   => '카슈비아어',
    'cu'    => "교회\ 슬라브어",
    'cus'   => '쿠시어족',
    'cv'    => '추바시어',
    'cy'    => '웨일스어',
    'da'    => '덴마크어',
    'dak'   => '다코타어',
    'dar'   => '다르그와어',
    'dav'   => 'Taita',
    'day'   => '다야크어',
    'de'    => '독일어',
    'de_at' => "독일어\ \(오스트리아\)",
    'de_ch' => "고지\ 독일어\ \(스위스\)",
    'del'   => '델라웨어어',
    'den'   => '슬라브어',
    'dgr'   => '도그리브어',
    'din'   => '딩카어',
    'dje'   => 'Zarma',
    'doi'   => '도그리어',
    'dra'   => "드라비다어\ \(기타\)",
    'dsb'   => "저지\ 소르비아어",
    'dua'   => '드와라어',
    'dum'   => "중세\ 네덜란드어",
    'dv'    => '디베히어',
    'dyo'   => "Jola\-Fonyi",
    'dyu'   => '드율라어',
    'dz'    => '종카어',
    'ebu'   => 'Embu',
    'ee'    => '에웨어',
    'efi'   => '이픽어',
    'egy'   => "이집트어\ \(고대\)",
    'eka'   => '이카죽어',
    'el'    => '그리스어',
    'elx'   => '엘람어',
    'en'    => '영어',
    'en_au' => "영어\(호주\)",
    'en_ca' => "영어\ \(캐나다\)",
    'en_gb' => "영어\ \(영국식\)",
    'en_us' => "영어\ \(미국식\)",
    'enm'   => "영어\,\ 중세\ \(1100\-1500\)",
    'eo'    => '에스페란토어',
    'es'    => '스페인어',
    'es_es' => "스페인어\ \(이베리아\)",
    'et'    => '에스토니아어',
    'eu'    => '바스크어',
    'ewo'   => '이원도어',
    'fa'    => '페르시아어',
    'fan'   => '팡그어',
    'fat'   => '판티어',
    'ff'    => '풀라어',
    'fi'    => '핀란드어',
    'fil'   => '필리핀어',
    'fiu'   => "피노우그리아어\ \(기타\)",
    'fj'    => '피지어',
    'fo'    => '페로어',
    'fon'   => '폰어',
    'fr'    => '프랑스어',
    'fr_ca' => "프랑스어\ \(캐나다\)",
    'fr_ch' => "프랑스어\ \(스위스\)",
    'frm'   => "중세\ 프랑스어",
    'fro'   => "고대\ 프랑스어",
    'frr'   => "북부\ 프리슬란드어",
    'frs'   => "동부\ 프리슬란드어",
    'fur'   => '프리우리안어',
    'fy'    => '프리지아어',
    'ga'    => '아일랜드어',
    'gaa'   => '가어',
    'gay'   => '가요어',
    'gba'   => '그바야어',
    'gd'    => "스코틀랜드\ 게일어",
    'gem'   => "독일어\ \(기타\)",
    'gez'   => '게이즈어',
    'gil'   => '키리바시어',
    'gl'    => '갈리시아어',
    'gmh'   => "중세\ 고지\ 독일어",
    'gn'    => '과라니어',
    'goh'   => "고대\ 고지\ 독일어",
    'gon'   => '곤디어',
    'gor'   => '고론탈로어',
    'got'   => '고트어',
    'grb'   => '게르보어',
    'grc'   => "그리스어\,\ 고대\ \(1453년\ 까지\)",
    'gsw'   => "독일어\(스위스\)",
    'gu'    => '구자라트어',
    'guz'   => 'Gusii',
    'gv'    => '맹크스어',
    'gwi'   => '그위친어',
    'ha'    => '하우사어',
    'hai'   => '하이다어',
    'haw'   => '하와이어',
    'he'    => '히브리어',
    'hi'    => '힌디어',
    'hil'   => '헤리가뇬어',
    'him'   => '히마차리어',
    'hit'   => '하타이트어',
    'hmn'   => '히몸어',
    'ho'    => "히리\ 모투어",
    'hr'    => '크로아티아어',
    'hsb'   => "고지\ 소르비아어",
    'ht'    => '아이티어',
    'hu'    => '헝가리어',
    'hup'   => '후파어',
    'hy'    => '아르메니아어',
    'hz'    => '헤레로어',
    'ia'    => "인테르링구아\ \(국제보조어협회\)",
    'iba'   => '이반어',
    'id'    => '인도네시아어',
    'ie'    => '인테르링구에',
    'ig'    => '이그보어',
    'ii'    => "쓰촨\ 이어",
    'ijo'   => '이조어',
    'ik'    => '이누피아크어',
    'ilo'   => '이로코어',
    'inc'   => "인도어\ \(기타\)",
    'ine'   => "인도유럽어\ \(기타\)",
    'inh'   => '인귀시어',
    'io'    => '이도어',
    'ira'   => '이란어',
    'iro'   => '이러쿼이어',
    'is'    => '아이슬란드어',
    'it'    => '이탈리아어',
    'iu'    => '이눅티투트어',
    'ja'    => '일본어',
    'jbo'   => '로반어',
    'jmc'   => 'Machame',
    'jpr'   => "유대\-페르시아어",
    'jrb'   => "유대\-아라비아어",
    'jv'    => '자바어',
    'ka'    => '그루지야어',
    'kaa'   => '카라칼파크어',
    'kab'   => '커바일어',
    'kac'   => '카친어',
    'kaj'   => 'Jju',
    'kam'   => '캄바어',
    'kar'   => '카렌어',
    'kaw'   => '카위어',
    'kbd'   => '카바르디어',
    'kcg'   => 'Tyap',
    'kde'   => 'Makonde',
    'kea'   => 'Kabuverdianu',
    'kfo'   => '코로어',
    'kg'    => '콩고어',
    'kha'   => '카시어',
    'khi'   => "코이산어\ \(기타\)",
    'kho'   => '호탄어',
    'khq'   => "Koyra\ Chiini",
    'ki'    => '키쿠유어',
    'kj'    => '쿠안야마어',
    'kk'    => '카자흐어',
    'kl'    => '그린란드어',
    'kln'   => 'Kalenjin',
    'km'    => '캄보디아어',
    'kmb'   => '킴분두어',
    'kn'    => '카나다어',
    'ko'    => '한국어',
    'kok'   => '코카니어',
    'kos'   => '코스라이엔어',
    'kpe'   => '크펠레어',
    'kr'    => '칸누리어',
    'krc'   => "카라챠이\-발카르어",
    'krl'   => '카렐리야어',
    'kro'   => '크루어',
    'kru'   => '쿠르크어',
    'ks'    => '카슈미르어',
    'ksb'   => 'Shambala',
    'ksf'   => 'Bafia',
    'ksh'   => 'Colognian',
    'ku'    => '쿠르드어',
    'kum'   => '쿠믹어',
    'kut'   => '쿠테네어',
    'kv'    => '코미어',
    'kw'    => '콘월어',
    'ky'    => '키르기스어',
    'la'    => '라틴어',
    'lad'   => '라디노어',
    'lag'   => 'Langi',
    'lah'   => '라한다어',
    'lam'   => '람바어',
    'lb'    => '룩셈부르크어',
    'lez'   => '레즈기안어',
    'lg'    => '간다어',
    'li'    => '림버거어',
    'ln'    => '링갈라어',
    'lo'    => '라오어',
    'lol'   => '몽구어',
    'loz'   => '로지어',
    'lt'    => '리투아니아어',
    'lu'    => "루바\-카탄가어",
    'lua'   => "루바\-룰루아어",
    'lui'   => '루이세노어',
    'lun'   => '룬다어',
    'luo'   => '루오어',
    'lus'   => '루샤이어',
    'luy'   => 'Luyia',
    'lv'    => '라트비아어',
    'mad'   => '마두라어',
    'mag'   => '마가히',
    'mai'   => '마이틸리',
    'mak'   => '마카사어',
    'man'   => '만딩고어',
    'map'   => '남도어',
    'mas'   => '마사이어',
    'mdf'   => '모크샤어',
    'mdr'   => '만다르어',
    'men'   => '멘데어',
    'mer'   => 'Meru',
    'mfe'   => 'Morisyen',
    'mg'    => '마다가스카르어',
    'mga'   => "아일랜드어\,\ 중세\ \(900\-1200\)",
    'mgh'   => "Makhuwa\-Meetto",
    'mh'    => '마셜제도어',
    'mi'    => '마오리어',
    'mic'   => '미크맥어',
    'min'   => '미낭카바우',
    'mis'   => "기타\ 언어",
    'mk'    => '마케도니아어',
    'mkh'   => "몬크메르어\ \(기타\)",
    'ml'    => '말라얄람어',
    'mn'    => '몽고어',
    'mnc'   => '만주어',
    'mni'   => '마니푸리어',
    'mno'   => '마노보어',
    'mo'    => '몰도바어',
    'moh'   => '모호크어',
    'mos'   => '모시어',
    'mr'    => '마라티어',
    'ms'    => '말레이어',
    'mt'    => '몰타어',
    'mua'   => 'Mundang',
    'mul'   => "다중\ 언어",
    'mun'   => '문다어',
    'mus'   => '크리크어',
    'mwl'   => '미란데어',
    'mwr'   => '마르와리어',
    'my'    => '버마어',
    'myn'   => '마야어',
    'myv'   => '엘즈야어',
    'na'    => '나우루어',
    'nah'   => '나우아틀어',
    'nai'   => "북아메리카\ 인디언어\ \(기타\)",
    'nap'   => '나폴리어',
    'naq'   => 'Nama',
    'nb'    => "노르웨이어\(보크말\)",
    'nd'    => "북부\ 은데벨레어",
    'nds'   => "저지\ 독일어",
    'ne'    => '네팔어',
    'new'   => '네와르어',
    'ng'    => '느동가어',
    'nia'   => '니아스어',
    'nic'   => "니제르\ \-\ 코르도파니아어\ \(기타\)",
    'niu'   => '니웨언어',
    'nl'    => '네덜란드어',
    'nl_be' => '플라망어',
    'nmg'   => 'Kwasio',
    'nn'    => "노르웨이어\(니노르스크\)",
    'no'    => '노르웨이어',
    'nog'   => '노가이어',
    'non'   => "노르웨이\,\ 고대",
    'nqo'   => '응코어',
    'nr'    => "남부\ 은데벨레어",
    'nso'   => "소토어\ \(북부\)",
    'nub'   => '누비안어',
    'nus'   => 'Nuer',
    'nv'    => '나바호어',
    'nwc'   => "네와르어\ \(고전\)",
    'ny'    => "니안자어\;\ 치츄어\;\ 츄어",
    'nym'   => '니암웨지어',
    'nyn'   => '니안콜어',
    'nyo'   => '뉴로어',
    'nzi'   => '느지마어',
    'oc'    => '오크어',
    'oj'    => '오지브웨이어',
    'om'    => "오로모어\ \(아판\)",
    'or'    => '오리야어',
    'os'    => '오세트어',
    'osa'   => '오세이지어',
    'ota'   => "터키어\,\ 오스만\ \(1500\-1928\)",
    'oto'   => '오토미안어',
    'pa'    => '펀잡어',
    'paa'   => "파푸아어\ \(기타\)",
    'pag'   => '판가시난어',
    'pal'   => '팔레비어',
    'pam'   => '팜팡가어',
    'pap'   => '파피아먼토어',
    'pau'   => '파라우안어',
    'peo'   => "고대\ 페르시아어",
    'phi'   => "필리핀어\ \(기타\)",
    'phn'   => '페니키아어',
    'pi'    => '팔리어',
    'pl'    => '폴란드어',
    'pon'   => '폼페이어',
    'pra'   => '프라크리트어',
    'pro'   => "고대\ 프로방스어",
    'ps'    => '파슈토어',
    'pt'    => '포르투갈어',
    'pt_br' => "포르투갈어\ \(브라질\)",
    'pt_pt' => "포르투갈어\ \(이베리아\)",
    'qu'    => '케추아어',
    'raj'   => '라자스탄어',
    'rap'   => '라파뉴이',
    'rar'   => '라로통가어',
    'rm'    => '레토로만어',
    'rn'    => '룬디어',
    'ro'    => '루마니아어',
    'roa'   => "로망스어\ \(기타\)",
    'rof'   => 'Rombo',
    'rom'   => '집시어',
    'ru'    => '러시아어',
    'rup'   => '아로마니아어',
    'rw'    => '르완다어',
    'rwk'   => 'Rwa',
    'sa'    => '산스크리트어',
    'sad'   => '산다웨어',
    'sah'   => '야큐트어',
    'sai'   => "남아메리카\ 인디언어\ \(기타\)",
    'sal'   => '샐리시어어',
    'sam'   => "사마리아\ 아랍어",
    'saq'   => 'Samburu',
    'sas'   => '사사크어',
    'sat'   => '산탈리어',
    'sbp'   => 'Sangu',
    'sc'    => '사르디니아어',
    'scn'   => '시칠리아어',
    'sco'   => '스코틀랜드어',
    'sd'    => '신디어',
    'se'    => "북부\ 사미어",
    'see'   => 'Seneca',
    'seh'   => 'Sena',
    'sel'   => '셀쿠프어',
    'sem'   => "셈어\ \(기타\)",
    'ses'   => "Koyraboro\ Senni",
    'sg'    => '산고어',
    'sga'   => "아일랜드\,\ 고대\ \(900년\ 까지\)",
    'sgn'   => '수화',
    'sh'    => "세르비아\-크로아티아어",
    'shi'   => 'Tachelhit',
    'shn'   => '샨어',
    'si'    => '스리랑카어',
    'sid'   => '시다모어',
    'sio'   => '수족어',
    'sit'   => "중국\ 티베트\ 어족",
    'sk'    => '슬로바키아어',
    'sl'    => '슬로베니아어',
    'sla'   => "슬라브어\ \(기타\)",
    'sm'    => '사모아어',
    'sma'   => "남부\ 사미어",
    'smi'   => "사미어\ \(기타\)",
    'smj'   => "룰레\ 사미어",
    'smn'   => "이나리\ 사미어",
    'sms'   => "스콜트\ 사미어",
    'sn'    => '쇼나어',
    'snk'   => '소닌케어',
    'so'    => '소말리아어',
    'sog'   => '소그디엔어',
    'son'   => '송가이족어',
    'sq'    => '알바니아어',
    'sr'    => '세르비아어',
    'srn'   => "스라난\ 통가어",
    'srr'   => '세레르어',
    'ss'    => '시스와티어',
    'ssa'   => "니로\-사하람어\ \(기타\)",
    'ssy'   => 'Saho',
    'st'    => "소토어\ \(남부\)",
    'su'    => '순다어',
    'suk'   => '수쿠마족어',
    'sus'   => '수수어',
    'sux'   => '수메르어',
    'sv'    => '스웨덴어',
    'sw'    => '스와힐리어',
    'swb'   => '코모로어',
    'swc'   => "Congo\ Swahili",
    'syc'   => "시리아어\ \(고전\)",
    'syr'   => '시리아어',
    'ta'    => '타밀어',
    'tai'   => "태국어\ \(기타\)",
    'te'    => '텔루구어',
    'tem'   => '팀니어',
    'teo'   => 'Teso',
    'ter'   => '테레노어',
    'tet'   => '테툼어',
    'tg'    => '타지키스탄어',
    'th'    => '태국어',
    'ti'    => '티그리냐어',
    'tig'   => '티그레어',
    'tiv'   => '티비어',
    'tk'    => '투르크멘어',
    'tkl'   => '토켈라우제도어',
    'tl'    => '타갈로그어',
    'tlh'   => '클링온어',
    'tli'   => '틀링깃족어',
    'tmh'   => '타마섹어',
    'tn'    => '세츠와나어',
    'to'    => '통가어',
    'tog'   => "통가어\ \(니아살랜드\)",
    'tpi'   => "토크\ 피신어",
    'tr'    => '터키어',
    'trv'   => 'Taroko',
    'ts'    => '총가어',
    'tsi'   => '트심시안어',
    'tt'    => '타타르어',
    'tum'   => '툼부카어',
    'tup'   => '투피어',
    'tut'   => "알타이제어\ \(기타\)",
    'tvl'   => '투발루어',
    'tw'    => '트위어',
    'twq'   => 'Tasawaq',
    'ty'    => '타히티어',
    'tyv'   => '투비니안어',
    'tzm'   => "Central\ Morocco\ Tamazight",
    'udm'   => '우드말트어',
    'ug'    => '위구르어',
    'uga'   => '유가리틱어',
    'uk'    => '우크라이나어',
    'umb'   => '윤번두어',
    'und'   => "알\ 수\ 없는\ 언어",
    'ur'    => '우르두어',
    'uz'    => '우즈베크어',
    'vai'   => '바이어',
    've'    => '벤다어',
    'vi'    => '베트남어',
    'vo'    => '볼라퓌크어',
    'vot'   => '보틱어',
    'vun'   => 'Vunjo',
    'wa'    => '왈론어',
    'wae'   => 'Walser',
    'wak'   => '와카샨어',
    'wal'   => '와라모어',
    'war'   => '와라이어',
    'was'   => '와쇼어',
    'wen'   => '소르브어',
    'wo'    => '올로프어',
    'xal'   => '칼미크어',
    'xh'    => '코사어',
    'xog'   => 'Soga',
    'yao'   => '야오족어',
    'yap'   => '얍페세어',
    'yav'   => 'Yangben',
    'yi'    => '이디시어',
    'yo'    => '요루바어',
    'ypk'   => '야픽어',
    'yue'   => '광둥어',
    'za'    => '주앙어',
    'zap'   => '사포테크어',
    'zbl'   => "블리스\ 심볼",
    'zen'   => '제나가어',
    'zh'    => '중국어',
    'znd'   => '아잔데족어',
    'zu'    => '줄루어',
    'zun'   => '주니어',
    'zxx'   => "언어\ 관련\ 내용\ 없음",
    'zza'   => '자자어',
);

%Locales::DB::Language::ko::name_to_code = (
    'aghem'                                                           => 'agq',
    'asu'                                                             => 'asa',
    'bafia'                                                           => 'ksf',
    'bena'                                                            => 'bez',
    'bodo'                                                            => 'brx',
    'cayuga'                                                          => 'cay',
    'centralmoroccotamazight'                                         => 'tzm',
    'chiga'                                                           => 'cgg',
    'colognian'                                                       => 'ksh',
    'congoswahili'                                                    => 'swc',
    'embu'                                                            => 'ebu',
    'gusii'                                                           => 'guz',
    'jju'                                                             => 'kaj',
    'jolafonyi'                                                       => 'dyo',
    'kabuverdianu'                                                    => 'kea',
    'kalenjin'                                                        => 'kln',
    'koyraborosenni'                                                  => 'ses',
    'koyrachiini'                                                     => 'khq',
    'kwasio'                                                          => 'nmg',
    'langi'                                                           => 'lag',
    'luyia'                                                           => 'luy',
    'machame'                                                         => 'jmc',
    'makhuwameetto'                                                   => 'mgh',
    'makonde'                                                         => 'kde',
    'meru'                                                            => 'mer',
    'morisyen'                                                        => 'mfe',
    'mundang'                                                         => 'mua',
    'nama'                                                            => 'naq',
    'nuer'                                                            => 'nus',
    'rombo'                                                           => 'rof',
    'rwa'                                                             => 'rwk',
    'saho'                                                            => 'ssy',
    'samburu'                                                         => 'saq',
    'sangu'                                                           => 'sbp',
    'sena'                                                            => 'seh',
    'seneca'                                                          => 'see',
    'shambala'                                                        => 'ksb',
    'soga'                                                            => 'xog',
    'tachelhit'                                                       => 'shi',
    'taita'                                                           => 'dav',
    'taroko'                                                          => 'trv',
    'tasawaq'                                                         => 'twq',
    'teso'                                                            => 'teo',
    'tyap'                                                            => 'kcg',
    'vunjo'                                                           => 'vun',
    'walser'                                                          => 'wae',
    'yangben'                                                         => 'yav',
    'zarma'                                                           => 'dje',
    '가어'                                                          => 'gaa',
    '가요어'                                                       => 'gay',
    '간다어'                                                       => 'lg',
    '갈리시아어'                                                 => 'gl',
    '게르보어'                                                    => 'grb',
    '게이즈어'                                                    => 'gez',
    '고대고지독일어'                                           => 'goh',
    '고대영어'                                                    => 'ang',
    '고대페르시아어'                                           => 'peo',
    '고대프랑스어'                                              => 'fro',
    '고대프로방스어'                                           => 'pro',
    '고론탈로어'                                                 => 'gor',
    '고지독일어스위스'                                        => 'de_ch',
    '고지소르비아어'                                           => 'hsb',
    '고트어'                                                       => 'got',
    '곤디어'                                                       => 'gon',
    '과라니어'                                                    => 'gn',
    '광둥어'                                                       => 'yue',
    '교회슬라브어'                                              => 'cu',
    '구자라트어'                                                 => 'gu',
    '그루지야어'                                                 => 'ka',
    '그리스어'                                                    => 'el',
    "그리스어\,고대1453년까지"                               => 'grc',
    '그린란드어'                                                 => 'kl',
    '그바야어'                                                    => 'gba',
    '그위친어'                                                    => 'gwi',
    '기계어기타'                                                 => 'art',
    '기타언어'                                                    => 'mis',
    '나바호어'                                                    => 'nv',
    '나우루어'                                                    => 'na',
    '나우아틀어'                                                 => 'nah',
    '나폴리어'                                                    => 'nap',
    '남도어'                                                       => 'map',
    '남부사미어'                                                 => 'sma',
    '남부알타이어'                                              => 'alt',
    '남부은데벨레어'                                           => 'nr',
    '남아공공용어'                                              => 'af',
    '남아메리카인디언어기타'                               => 'sai',
    '네덜란드어'                                                 => 'nl',
    '네와르어'                                                    => 'new',
    '네와르어고전'                                              => 'nwc',
    '네팔어'                                                       => 'ne',
    '노가이어'                                                    => 'nog',
    "노르웨이\,고대"                                            => 'non',
    '노르웨이어'                                                 => 'no',
    '노르웨이어니노르스크'                                  => 'nn',
    '노르웨이어보크말'                                        => 'nb',
    '누비안어'                                                    => 'nub',
    '뉴로어'                                                       => 'nyo',
    '느동가어'                                                    => 'ng',
    '느지마어'                                                    => 'nzi',
    '니로사하람어기타'                                        => 'ssa',
    '니아스어'                                                    => 'nia',
    "니안자어\;치츄어\;츄어"                                 => 'ny',
    '니안콜어'                                                    => 'nyn',
    '니암웨지어'                                                 => 'nym',
    '니웨언어'                                                    => 'niu',
    '니제르코르도파니아어기타'                            => 'nic',
    '다르그와어'                                                 => 'dar',
    '다야크어'                                                    => 'day',
    '다중언어'                                                    => 'mul',
    '다코타어'                                                    => 'dak',
    '덴마크어'                                                    => 'da',
    '델라웨어어'                                                 => 'del',
    '도그리브어'                                                 => 'dgr',
    '도그리어'                                                    => 'doi',
    '독일어'                                                       => 'de',
    '독일어기타'                                                 => 'gem',
    '독일어스위스'                                              => 'gsw',
    '독일어오스트리아'                                        => 'de_at',
    '동부프리슬란드어'                                        => 'frs',
    '드라비다어기타'                                           => 'dra',
    '드와라어'                                                    => 'dua',
    '드율라어'                                                    => 'dyu',
    '디베히어'                                                    => 'dv',
    '딩카어'                                                       => 'din',
    '라디노어'                                                    => 'lad',
    '라로통가어'                                                 => 'rar',
    '라오어'                                                       => 'lo',
    '라자스탄어'                                                 => 'raj',
    '라트비아어'                                                 => 'lv',
    '라틴어'                                                       => 'la',
    '라파뉴이'                                                    => 'rap',
    '라한다어'                                                    => 'lah',
    '람바어'                                                       => 'lam',
    '러시아어'                                                    => 'ru',
    '레즈기안어'                                                 => 'lez',
    '레토로만어'                                                 => 'rm',
    '로망스어기타'                                              => 'roa',
    '로반어'                                                       => 'jbo',
    '로지어'                                                       => 'loz',
    '루마니아어'                                                 => 'ro',
    '루바룰루아어'                                              => 'lua',
    '루바카탄가어'                                              => 'lu',
    '루샤이어'                                                    => 'lus',
    '루오어'                                                       => 'luo',
    '루이세노어'                                                 => 'lui',
    '룩셈부르크어'                                              => 'lb',
    '룬다어'                                                       => 'lun',
    '룬디어'                                                       => 'rn',
    '룰레사미어'                                                 => 'smj',
    '르완다어'                                                    => 'rw',
    '리투아니아어'                                              => 'lt',
    '림버거어'                                                    => 'li',
    '링갈라어'                                                    => 'ln',
    '마가히'                                                       => 'mag',
    '마노보어'                                                    => 'mno',
    '마니푸리어'                                                 => 'mni',
    '마다가스카르어'                                           => 'mg',
    '마두라어'                                                    => 'mad',
    '마라티어'                                                    => 'mr',
    '마르와리어'                                                 => 'mwr',
    '마리어'                                                       => 'chm',
    '마사이어'                                                    => 'mas',
    '마셜제도어'                                                 => 'mh',
    '마야어'                                                       => 'myn',
    '마오리어'                                                    => 'mi',
    '마이틸리'                                                    => 'mai',
    '마카사어'                                                    => 'mak',
    '마케도니아어'                                              => 'mk',
    '만다르어'                                                    => 'mdr',
    '만딩고어'                                                    => 'man',
    '만주어'                                                       => 'mnc',
    '말라얄람어'                                                 => 'ml',
    '말레이어'                                                    => 'ms',
    '맹크스어'                                                    => 'gv',
    '멘데어'                                                       => 'men',
    '모시어'                                                       => 'mos',
    '모크샤어'                                                    => 'mdf',
    '모호크어'                                                    => 'moh',
    '몬크메르어기타'                                           => 'mkh',
    '몰도바어'                                                    => 'mo',
    '몰타어'                                                       => 'mt',
    '몽고어'                                                       => 'mn',
    '몽구어'                                                       => 'lol',
    '문다어'                                                       => 'mun',
    '미낭카바우'                                                 => 'min',
    '미란데어'                                                    => 'mwl',
    '미크맥어'                                                    => 'mic',
    '바밀레케어족'                                              => 'bai',
    '바사어'                                                       => 'bas',
    '바슈키르어'                                                 => 'ba',
    '바스크어'                                                    => 'eu',
    '바이어'                                                       => 'vai',
    '바타크어'                                                    => 'btk',
    '반다어'                                                       => 'bad',
    '반투어'                                                       => 'bnt',
    '발루치어'                                                    => 'bal',
    '발리어'                                                       => 'ban',
    '발트어기타'                                                 => 'bat',
    '밤바라어'                                                    => 'bm',
    '버마어'                                                       => 'my',
    '베르베르어'                                                 => 'ber',
    '베자어'                                                       => 'bej',
    '베트남어'                                                    => 'vi',
    '벤다어'                                                       => 've',
    '벨로루시어'                                                 => 'be',
    '벰바어'                                                       => 'bem',
    '벵골어'                                                       => 'bn',
    '보스니아어'                                                 => 'bs',
    '보틱어'                                                       => 'vot',
    '볼라퓌크어'                                                 => 'vo',
    '부기어'                                                       => 'bug',
    '부리아타'                                                    => 'bua',
    '북부사미어'                                                 => 'se',
    '북부은데벨레어'                                           => 'nd',
    '북부프리슬란드어'                                        => 'frr',
    '북아메리카인디언어기타'                               => 'nai',
    '불가리아어'                                                 => 'bg',
    '브라지어'                                                    => 'bra',
    '브르타뉴어'                                                 => 'br',
    '브린어'                                                       => 'byn',
    '블리스심볼'                                                 => 'zbl',
    '비니어'                                                       => 'bin',
    '비슬라마어'                                                 => 'bi',
    '비콜어'                                                       => 'bik',
    '비하르어'                                                    => 'bh',
    '사르디니아어'                                              => 'sc',
    '사마리아아랍어'                                           => 'sam',
    '사모아어'                                                    => 'sm',
    '사미어기타'                                                 => 'smi',
    '사사크어'                                                    => 'sas',
    '사포테크어'                                                 => 'zap',
    '산고어'                                                       => 'sg',
    '산다웨어'                                                    => 'sad',
    '산스크리트어'                                              => 'sa',
    '산탈리어'                                                    => 'sat',
    '샐리시어어'                                                 => 'sal',
    '샤이엔어'                                                    => 'chy',
    '샨어'                                                          => 'shn',
    '세레르어'                                                    => 'srr',
    '세르비아어'                                                 => 'sr',
    '세르비아크로아티아어'                                  => 'sh',
    '세부아노어'                                                 => 'ceb',
    '세츠와나어'                                                 => 'tn',
    '셀쿠프어'                                                    => 'sel',
    '셈어기타'                                                    => 'sem',
    '소그디엔어'                                                 => 'sog',
    '소닌케어'                                                    => 'snk',
    '소르브어'                                                    => 'wen',
    '소말리아어'                                                 => 'so',
    '소토어남부'                                                 => 'st',
    '소토어북부'                                                 => 'nso',
    '송가이족어'                                                 => 'son',
    '쇼나어'                                                       => 'sn',
    '수메르어'                                                    => 'sux',
    '수수어'                                                       => 'sus',
    '수족어'                                                       => 'sio',
    '수쿠마족어'                                                 => 'suk',
    '수화'                                                          => 'sgn',
    '순다어'                                                       => 'su',
    '스라난통가어'                                              => 'srn',
    '스리랑카어'                                                 => 'si',
    '스와힐리어'                                                 => 'sw',
    '스웨덴어'                                                    => 'sv',
    '스코틀랜드게일어'                                        => 'gd',
    '스코틀랜드어'                                              => 'sco',
    '스콜트사미어'                                              => 'sms',
    '스페인어'                                                    => 'es',
    '스페인어이베리아'                                        => 'es_es',
    '슬라브어'                                                    => 'den',
    '슬라브어기타'                                              => 'sla',
    '슬로바키아어'                                              => 'sk',
    '슬로베니아어'                                              => 'sl',
    '시다모어'                                                    => 'sid',
    '시리아어'                                                    => 'syr',
    '시리아어고전'                                              => 'syc',
    '시스와티어'                                                 => 'ss',
    '시칠리아어'                                                 => 'scn',
    '식시카어'                                                    => 'bla',
    '신디어'                                                       => 'sd',
    '쓰촨이어'                                                    => 'ii',
    '아닥헤어'                                                    => 'ady',
    '아당메어'                                                    => 'ada',
    '아라곤어'                                                    => 'an',
    '아라와크어'                                                 => 'arw',
    '아라우칸어'                                                 => 'arn',
    '아라파호어'                                                 => 'arp',
    '아람어'                                                       => 'arc',
    '아랍어'                                                       => 'ar',
    '아로마니아어'                                              => 'rup',
    '아르메니아어'                                              => 'hy',
    '아바릭어'                                                    => 'av',
    '아베스타어'                                                 => 'ae',
    '아삼어'                                                       => 'cch',
    '아샘어'                                                       => 'as',
    '아스투리아어'                                              => 'ast',
    '아시아아프리카어기타'                                  => 'afa',
    '아와히어'                                                    => 'awa',
    '아이누어'                                                    => 'ain',
    '아이마라어'                                                 => 'ay',
    '아이슬란드어'                                              => 'is',
    '아이티어'                                                    => 'ht',
    "아일랜드\,고대900년까지"                                => 'sga',
    '아일랜드어'                                                 => 'ga',
    "아일랜드어\,중세9001200"                                  => 'mga',
    '아잔데족어'                                                 => 'znd',
    '아제리어'                                                    => 'az',
    '아체어'                                                       => 'ace',
    '아카드어'                                                    => 'akk',
    '아칸어'                                                       => 'ak',
    '아콜리어'                                                    => 'ach',
    '아타파스카어군'                                           => 'ath',
    '아파르어'                                                    => 'aa',
    '아파치어'                                                    => 'apa',
    '아프리히리어'                                              => 'afh',
    '알공킨어족'                                                 => 'alg',
    '알류트어'                                                    => 'ale',
    '알바니아어'                                                 => 'sq',
    '알수없는언어'                                              => 'und',
    '알타이제어기타'                                           => 'tut',
    '암하라어'                                                    => 'am',
    '압카즈어'                                                    => 'ab',
    '앙가어'                                                       => 'anp',
    '야오족어'                                                    => 'yao',
    '야큐트어'                                                    => 'sah',
    '야픽어'                                                       => 'ypk',
    '얍페세어'                                                    => 'yap',
    '언어관련내용없음'                                        => 'zxx',
    '에스토니아어'                                              => 'et',
    '에스페란토어'                                              => 'eo',
    '에웨어'                                                       => 'ee',
    '엘람어'                                                       => 'elx',
    '엘즈야어'                                                    => 'myv',
    '영어'                                                          => 'en',
    "영어\,중세11001500"                                          => 'enm',
    '영어미국식'                                                 => 'en_us',
    '영어영국식'                                                 => 'en_gb',
    '영어캐나다'                                                 => 'en_ca',
    '영어호주'                                                    => 'en_au',
    '오로모어아판'                                              => 'om',
    '오리야어'                                                    => 'or',
    '오세이지어'                                                 => 'osa',
    '오세트어'                                                    => 'os',
    '오스트레일리아어족'                                     => 'aus',
    '오지브웨이어'                                              => 'oj',
    '오크어'                                                       => 'oc',
    '오토미안어'                                                 => 'oto',
    '올로프어'                                                    => 'wo',
    '와라모어'                                                    => 'wal',
    '와라이어'                                                    => 'war',
    '와쇼어'                                                       => 'was',
    '와카샨어'                                                    => 'wak',
    '왈론어'                                                       => 'wa',
    '요루바어'                                                    => 'yo',
    '우드말트어'                                                 => 'udm',
    '우르두어'                                                    => 'ur',
    '우즈베크어'                                                 => 'uz',
    '우크라이나어'                                              => 'uk',
    '웨일스어'                                                    => 'cy',
    '위구르어'                                                    => 'ug',
    '유가리틱어'                                                 => 'uga',
    '유대아라비아어'                                           => 'jrb',
    '유대페르시아어'                                           => 'jpr',
    '윤번두어'                                                    => 'umb',
    '응코어'                                                       => 'nqo',
    '이그보어'                                                    => 'ig',
    '이나리사미어'                                              => 'smn',
    '이누피아크어'                                              => 'ik',
    '이눅티투트어'                                              => 'iu',
    '이도어'                                                       => 'io',
    '이디시어'                                                    => 'yi',
    '이란어'                                                       => 'ira',
    '이러쿼이어'                                                 => 'iro',
    '이로코어'                                                    => 'ilo',
    '이반어'                                                       => 'iba',
    '이원도어'                                                    => 'ewo',
    '이조어'                                                       => 'ijo',
    '이집트어고대'                                              => 'egy',
    '이카죽어'                                                    => 'eka',
    '이탈리아어'                                                 => 'it',
    '이픽어'                                                       => 'efi',
    '인귀시어'                                                    => 'inh',
    '인도네시아어'                                              => 'id',
    '인도어기타'                                                 => 'inc',
    '인도유럽어기타'                                           => 'ine',
    '인테르링구아국제보조어협회'                         => 'ia',
    '인테르링구에'                                              => 'ie',
    '일본어'                                                       => 'ja',
    '자바어'                                                       => 'jv',
    '자자어'                                                       => 'zza',
    '저지독일어'                                                 => 'nds',
    '저지소르비아어'                                           => 'dsb',
    '제나가어'                                                    => 'zen',
    '종카어'                                                       => 'dz',
    '주니어'                                                       => 'zun',
    '주앙어'                                                       => 'za',
    '줄루어'                                                       => 'zu',
    '중국어'                                                       => 'zh',
    '중국티베트어족'                                           => 'sit',
    '중세고지독일어'                                           => 'gmh',
    '중세네덜란드어'                                           => 'dum',
    '중세프랑스어'                                              => 'frm',
    '중앙아메리카인디안어기타'                            => 'cai',
    '집시어'                                                       => 'rom',
    '차가타이어'                                                 => 'chg',
    '차모로어'                                                    => 'ch',
    '참어군'                                                       => 'cmc',
    '체로키어'                                                    => 'chr',
    '체첸어'                                                       => 'ce',
    '체코어'                                                       => 'cs',
    '촉토어'                                                       => 'cho',
    '총가어'                                                       => 'ts',
    '추바시어'                                                    => 'cv',
    '추크어'                                                       => 'chk',
    '치누크어와영어프랑스어의혼성어'                   => 'chn',
    '치브차어'                                                    => 'chb',
    '치페우얀'                                                    => 'chp',
    '카나다어'                                                    => 'kn',
    '카도어'                                                       => 'cad',
    '카라챠이발카르어'                                        => 'krc',
    '카라칼파크어'                                              => 'kaa',
    '카렌어'                                                       => 'kar',
    '카렐리야어'                                                 => 'krl',
    '카리브어'                                                    => 'car',
    '카바르디어'                                                 => 'kbd',
    '카슈미르어'                                                 => 'ks',
    '카슈비아어'                                                 => 'csb',
    '카시어'                                                       => 'kha',
    '카위어'                                                       => 'kaw',
    '카자흐어'                                                    => 'kk',
    '카친어'                                                       => 'kac',
    '카탈로니아어'                                              => 'ca',
    '카프카스어기타'                                           => 'cau',
    '칸누리어'                                                    => 'kr',
    '칼미크어'                                                    => 'xal',
    '캄바어'                                                       => 'kam',
    '캄보디아어'                                                 => 'km',
    '커바일어'                                                    => 'kab',
    '케추아어'                                                    => 'qu',
    '켈트어기타'                                                 => 'cel',
    '코로어'                                                       => 'kfo',
    '코르시카어'                                                 => 'co',
    '코모로어'                                                    => 'swb',
    '코미어'                                                       => 'kv',
    '코사어'                                                       => 'xh',
    '코스라이엔어'                                              => 'kos',
    '코이산어기타'                                              => 'khi',
    '코카니어'                                                    => 'kok',
    '콘월어'                                                       => 'kw',
    '콥트어'                                                       => 'cop',
    '콩고어'                                                       => 'kg',
    '쿠르드어'                                                    => 'ku',
    '쿠르크어'                                                    => 'kru',
    '쿠믹어'                                                       => 'kum',
    '쿠시어족'                                                    => 'cus',
    '쿠안야마어'                                                 => 'kj',
    '쿠테네어'                                                    => 'kut',
    '크로아티아어'                                              => 'hr',
    '크루어'                                                       => 'kro',
    "크리민터키어\;크리민타타르어"                       => 'crh',
    '크리어'                                                       => 'cr',
    '크리올어및피진어기타'                                  => 'crp',
    '크리올어및피진어영어를기반으로한기타'          => 'cpe',
    '크리올어및피진어포르투갈어를기반으로한기타' => 'cpp',
    '크리올어및피진어프랑스어를기반으로한기타'    => 'cpf',
    '크리크어'                                                    => 'mus',
    '크펠레어'                                                    => 'kpe',
    '클링온어'                                                    => 'tlh',
    '키르기스어'                                                 => 'ky',
    '키리바시어'                                                 => 'gil',
    '키쿠유어'                                                    => 'ki',
    '킴분두어'                                                    => 'kmb',
    '타갈로그어'                                                 => 'tl',
    '타마섹어'                                                    => 'tmh',
    '타밀어'                                                       => 'ta',
    '타지키스탄어'                                              => 'tg',
    '타타르어'                                                    => 'tt',
    '타히티어'                                                    => 'ty',
    '태국어'                                                       => 'th',
    '태국어기타'                                                 => 'tai',
    '터키어'                                                       => 'tr',
    "터키어\,오스만15001928"                                    => 'ota',
    '테레노어'                                                    => 'ter',
    '테툼어'                                                       => 'tet',
    '텔루구어'                                                    => 'te',
    '토켈라우제도어'                                           => 'tkl',
    '토크피신어'                                                 => 'tpi',
    '통가어'                                                       => 'to',
    '통가어니아살랜드'                                        => 'tog',
    '투르크멘어'                                                 => 'tk',
    '투발루어'                                                    => 'tvl',
    '투비니안어'                                                 => 'tyv',
    '투피어'                                                       => 'tup',
    '툼부카어'                                                    => 'tum',
    '트심시안어'                                                 => 'tsi',
    '트위어'                                                       => 'tw',
    '틀링깃족어'                                                 => 'tli',
    '티그레어'                                                    => 'tig',
    '티그리냐어'                                                 => 'ti',
    '티베트어'                                                    => 'bo',
    '티비어'                                                       => 'tiv',
    '팀니어'                                                       => 'tem',
    '파라우안어'                                                 => 'pau',
    '파슈토어'                                                    => 'ps',
    '파푸아어기타'                                              => 'paa',
    '파피아먼토어'                                              => 'pap',
    '판가시난어'                                                 => 'pag',
    '판티어'                                                       => 'fat',
    '팔레비어'                                                    => 'pal',
    '팔리어'                                                       => 'pi',
    '팜팡가어'                                                    => 'pam',
    '팡그어'                                                       => 'fan',
    '펀잡어'                                                       => 'pa',
    '페니키아어'                                                 => 'phn',
    '페로어'                                                       => 'fo',
    '페르시아어'                                                 => 'fa',
    '포르투갈어'                                                 => 'pt',
    '포르투갈어브라질'                                        => 'pt_br',
    '포르투갈어이베리아'                                     => 'pt_pt',
    '폰어'                                                          => 'fon',
    '폴란드어'                                                    => 'pl',
    '폼페이어'                                                    => 'pon',
    '풀라어'                                                       => 'ff',
    '프라크리트어'                                              => 'pra',
    '프랑스어'                                                    => 'fr',
    '프랑스어스위스'                                           => 'fr_ch',
    '프랑스어캐나다'                                           => 'fr_ca',
    '프리우리안어'                                              => 'fur',
    '프리지아어'                                                 => 'fy',
    '플라망어'                                                    => 'nl_be',
    '피노우그리아어기타'                                     => 'fiu',
    '피지어'                                                       => 'fj',
    '핀란드어'                                                    => 'fi',
    '필리핀어'                                                    => 'fil',
    '필리핀어기타'                                              => 'phi',
    '하와이어'                                                    => 'haw',
    '하우사어'                                                    => 'ha',
    '하이다어'                                                    => 'hai',
    '하타이트어'                                                 => 'hit',
    '한국어'                                                       => 'ko',
    '헝가리어'                                                    => 'hu',
    '헤레로어'                                                    => 'hz',
    '헤리가뇬어'                                                 => 'hil',
    '호즈푸리어'                                                 => 'bho',
    '호탄어'                                                       => 'kho',
    '후파어'                                                       => 'hup',
    '히리모투어'                                                 => 'ho',
    '히마차리어'                                                 => 'him',
    '히몸어'                                                       => 'hmn',
    '히브리어'                                                    => 'he',
    '힌디어'                                                       => 'hi',
);

1;
