package Locales::DB::Language::hu;

use strict;
use warnings;

# Auto generated from CLDR

$Locales::DB::Language::hu::VERSION = '0.09';

$Locales::DB::Language::hu::cldr_version = '2.0';

%Locales::DB::Language::hu::misc_info = (
    'characters'   => { 'more_information' => "\?" },
    'cldr_formats' => {
        '_decimal_format_decimal' => "\,",
        '_decimal_format_group'   => ' ',
        '_percent_format_percent' => "\%",
        'decimal'                 => "\#\,\#\#0\.\#\#\#",
        'ellipsis'                => {
            'final'   => "\{0\}…",
            'initial' => "…\{0\}",
            'medial'  => "\{0\}…\{1\}"
        },
        'language' => "Nyelv\:\ \{0\}",
        'list'     => {
            2        => "\{0\}\ és\ \{1\}",
            'end'    => "\{0\}\ és\ \{1\}",
            'middle' => "\{0\}\,\ \{1\}",
            'start'  => "\{0\}\,\ \{1\}"
        },
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0\%",
        'territory' => "Régió\:\ \{0\}"
    },
    'delimiters' => {
        'alternate_quotation_end'   => '”',
        'alternate_quotation_start' => '„',
        'quotation_end'             => '”',
        'quotation_start'           => '„'
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'plural_forms' => {
        'category_list'  => ['other'],
        'category_rules' => {}
    },
    'posix' => {
        'nostr'  => "nem\:n",
        'yesstr' => "igen\:i"
    },
);

%Locales::DB::Language::hu::code_to_name = (
    'aa'    => 'afar',
    'ab'    => 'abház',
    'ace'   => 'achinéz',
    'ach'   => 'akoli',
    'ada'   => 'adangme',
    'ady'   => 'adyghe',
    'ae'    => 'avesztán',
    'af'    => 'afrikaans',
    'afa'   => "afroázsiai\ nyelv",
    'afh'   => 'afrihili',
    'agq'   => 'agq',
    'ain'   => 'ainu',
    'ak'    => 'akan',
    'akk'   => 'akkád',
    'ale'   => 'aleut',
    'alg'   => "algonkin\ nyelv",
    'alt'   => "dél\-altaji",
    'am'    => 'amhara',
    'an'    => 'aragonéz',
    'ang'   => 'óangol',
    'anp'   => 'angika',
    'apa'   => "apacs\ nyelvek",
    'ar'    => 'arab',
    'arc'   => 'arámi',
    'arn'   => 'araucani',
    'arp'   => 'arapaho',
    'art'   => "mesterséges\ nyelv",
    'arw'   => 'aravak',
    'as'    => 'asszámi',
    'asa'   => 'asu',
    'ast'   => 'asztúr',
    'ath'   => "atapaszkan\ nyelvek",
    'aus'   => "ausztrál\ nyelvek",
    'av'    => 'avar',
    'awa'   => 'awádi',
    'ay'    => 'ajmara',
    'az'    => 'azeri',
    'ba'    => 'baskír',
    'bad'   => 'banda',
    'bai'   => "bamileke\ nyelvek",
    'bal'   => 'balucsi',
    'ban'   => 'balinéz',
    'bas'   => 'basza',
    'bat'   => "balti\ nyelv",
    'be'    => 'belorusz',
    'bej'   => 'bedzsa',
    'bem'   => 'bemba',
    'ber'   => 'berber',
    'bez'   => 'bena',
    'bg'    => 'bolgár',
    'bh'    => 'bihari',
    'bho'   => 'bodzspuri',
    'bi'    => 'bislama',
    'bik'   => 'bikol',
    'bin'   => 'bini',
    'bla'   => 'siksika',
    'bm'    => 'bambara',
    'bn'    => 'bengáli',
    'bnt'   => 'bantu',
    'bo'    => 'tibeti',
    'br'    => 'breton',
    'bra'   => 'braj',
    'brx'   => 'bodo',
    'bs'    => 'bosnyák',
    'btk'   => 'batak',
    'bua'   => 'burját',
    'bug'   => 'buginéz',
    'byn'   => 'blin',
    'ca'    => 'katalán',
    'cad'   => 'caddo',
    'cai'   => "egyéb\ közép\-amerikai\ indián",
    'car'   => 'karib',
    'cau'   => "egyéb\ kaukázusi",
    'cay'   => 'Cayuga',
    'cch'   => 'atszam',
    'ce'    => 'csecsen',
    'ceb'   => 'cebui',
    'cel'   => "egyéb\ kelta",
    'cgg'   => 'Chiga',
    'ch'    => 'csamoró',
    'chb'   => 'csibcsa',
    'chg'   => 'csagatáj',
    'chk'   => 'csukéz',
    'chm'   => 'mari',
    'chn'   => "csinuk\ zsargon",
    'cho'   => 'csoktó',
    'chp'   => 'csipevé',
    'chr'   => 'cseroki',
    'chy'   => 'csejen',
    'cmc'   => "csam\ nyelv",
    'co'    => 'korzikai',
    'cop'   => 'kopt',
    'cpe'   => "egyéb\ angol\ alapú\ kreol\ és\ pidgin",
    'cpf'   => "egyéb\ francia\ alapú\ kreol\ és\ pidgin",
    'cpp'   => "portugál\ alapú\ kreol\ vagy\ pidgin",
    'cr'    => 'krí',
    'crh'   => "krími\ tatár",
    'crp'   => "kreol\ és\ pidzsin",
    'cs'    => 'cseh',
    'csb'   => 'kasub',
    'cu'    => "egyházi\ szláv",
    'cus'   => "kusita\ nyelv",
    'cv'    => 'csuvas',
    'cy'    => 'walesi',
    'da'    => 'dán',
    'dak'   => 'dakota',
    'dar'   => 'dargva',
    'dav'   => 'Taita',
    'day'   => 'dajak',
    'de'    => 'német',
    'de_at' => "osztrák\ német",
    'de_ch' => "svájci\ felnémet",
    'del'   => 'delavár',
    'den'   => 'szlevi',
    'dgr'   => 'dogrib',
    'din'   => 'dinka',
    'dje'   => 'dje',
    'doi'   => 'dogri',
    'dra'   => "egyéb\ dravida",
    'dsb'   => "alsó\ szorb",
    'dua'   => 'duala',
    'dum'   => "közép\ holland",
    'dv'    => 'divehi',
    'dyo'   => 'dyo',
    'dyu'   => 'diula',
    'dz'    => 'butáni',
    'ebu'   => 'embu',
    'ee'    => 'eve',
    'efi'   => 'efik',
    'egy'   => 'óegyiptomi',
    'eka'   => 'ekadzsuk',
    'el'    => 'görög',
    'elx'   => 'elamit',
    'en'    => 'angol',
    'en_au' => "ausztrál\ angol",
    'en_ca' => "kanadai\ angol",
    'en_gb' => "brit\ angol",
    'en_us' => "amerikai\ angol",
    'enm'   => "közép\ angol",
    'eo'    => 'eszperantó',
    'es'    => 'spanyol',
    'es_es' => "ibériai\ spanyol",
    'et'    => 'észt',
    'eu'    => 'baszk',
    'ewo'   => 'evondo',
    'fa'    => 'perzsa',
    'fan'   => 'fang',
    'fat'   => 'fanti',
    'ff'    => 'fulani',
    'fi'    => 'finn',
    'fil'   => 'filippínó',
    'fiu'   => "finnugor\ nyelv",
    'fj'    => 'fidzsi',
    'fo'    => 'feröeri',
    'fon'   => 'fon',
    'fr'    => 'francia',
    'fr_ca' => "kanadai\ francia",
    'fr_ch' => "svájci\ francia",
    'frm'   => "közép\ francia",
    'fro'   => 'ófrancia',
    'frr'   => "északi\ fríz",
    'frs'   => "keleti\ fríz",
    'fur'   => 'friuli',
    'fy'    => 'fríz',
    'ga'    => 'ír',
    'gaa'   => 'ga',
    'gay'   => 'gajo',
    'gba'   => 'gbaja',
    'gd'    => "skót\ gael",
    'gem'   => "germán\ nyelv",
    'gez'   => 'geez',
    'gil'   => 'ikiribati',
    'gl'    => 'galíciai',
    'gmh'   => "közép\ felső\ német",
    'gn'    => 'guarani',
    'goh'   => "ófelső\ német",
    'gon'   => 'gondi',
    'gor'   => 'gorontalo',
    'got'   => 'gót',
    'grb'   => 'grebó',
    'grc'   => 'ógörög',
    'gsw'   => "svájci\ német",
    'gu'    => 'gudzsarati',
    'guz'   => 'Gusii',
    'gv'    => "Man\-szigeti",
    'gwi'   => 'gvicsin',
    'ha'    => 'hausza',
    'hai'   => 'haida',
    'haw'   => 'hawaii',
    'he'    => 'héber',
    'hi'    => 'hindi',
    'hil'   => 'hiligajnon',
    'him'   => 'himaháli',
    'hit'   => 'hittite',
    'hmn'   => 'hmong',
    'ho'    => "hiri\ motu",
    'hr'    => 'horvát',
    'hsb'   => "felső\ szorb",
    'ht'    => 'haiti',
    'hu'    => 'magyar',
    'hup'   => 'hupa',
    'hy'    => 'örmény',
    'hz'    => 'herero',
    'ia'    => 'interlingva',
    'iba'   => 'iban',
    'id'    => 'indonéz',
    'ie'    => 'interlingue',
    'ig'    => 'igbó',
    'ii'    => "szecsuán\ ji",
    'ijo'   => 'idzsó',
    'ik'    => 'inupiak',
    'ilo'   => 'ilokó',
    'inc'   => "egyéb\ indiai",
    'ine'   => "indoeurópai\ nyelv",
    'inh'   => 'ingus',
    'io'    => 'idó',
    'ira'   => 'iráni',
    'iro'   => "irokéz\ nyelvek",
    'is'    => 'izlandi',
    'it'    => 'olasz',
    'iu'    => 'inuktitut',
    'ja'    => 'japán',
    'jbo'   => 'lojban',
    'jmc'   => 'Machame',
    'jpr'   => "zsidó\-perzsa",
    'jrb'   => "zsidó\-arab",
    'jv'    => 'jávai',
    'ka'    => 'grúz',
    'kaa'   => "kara\-kalpak",
    'kab'   => 'kabije',
    'kac'   => 'kacsin',
    'kaj'   => 'jju',
    'kam'   => 'kamba',
    'kar'   => 'karen',
    'kaw'   => 'kawi',
    'kbd'   => 'kabardi',
    'kcg'   => 'tyap',
    'kde'   => 'Makonde',
    'kea'   => 'kabuverdianu',
    'kfo'   => 'koro',
    'kg'    => 'kongo',
    'kha'   => 'kaszi',
    'khi'   => "egyéb\ koiszan",
    'kho'   => 'kotanéz',
    'khq'   => "Koyra\ Chiini",
    'ki'    => 'kikuju',
    'kj'    => 'kuanyama',
    'kk'    => 'kazah',
    'kl'    => 'grönlandi',
    'kln'   => 'Kalenjin',
    'km'    => 'kambodzsai',
    'kmb'   => 'kimbundu',
    'kn'    => 'kannada',
    'ko'    => 'koreai',
    'kok'   => 'konkani',
    'kos'   => 'kosrei',
    'kpe'   => 'kpelle',
    'kr'    => 'kanuri',
    'krc'   => "karacsáj\-balkár",
    'krl'   => 'karelai',
    'kro'   => 'kru',
    'kru'   => 'kuruh',
    'ks'    => 'kásmíri',
    'ksb'   => 'Shambala',
    'ksf'   => 'ksf',
    'ksh'   => 'Colognian',
    'ku'    => 'kurd',
    'kum'   => 'kumük',
    'kut'   => 'kutenai',
    'kv'    => 'komi',
    'kw'    => 'korni',
    'ky'    => 'kirgiz',
    'la'    => 'latin',
    'lad'   => 'ladino',
    'lag'   => 'Langi',
    'lah'   => 'lahnda',
    'lam'   => 'lamba',
    'lb'    => 'luxemburgi',
    'lez'   => 'lezg',
    'lg'    => 'ganda',
    'li'    => 'limburgi',
    'ln'    => 'lingala',
    'lo'    => 'laoszi',
    'lol'   => 'mongó',
    'loz'   => 'lozi',
    'lt'    => 'litván',
    'lu'    => "luba\-katanga",
    'lua'   => "luba\-lulua",
    'lui'   => 'luiseno',
    'lun'   => 'lunda',
    'luo'   => 'luo',
    'lus'   => 'lushai',
    'luy'   => 'lujia',
    'lv'    => 'lett',
    'mad'   => 'madurai',
    'mag'   => 'magahi',
    'mai'   => 'maithili',
    'mak'   => 'makaszar',
    'man'   => 'mandingó',
    'map'   => 'ausztronéz',
    'mas'   => 'masai',
    'mdf'   => 'moksán',
    'mdr'   => 'mandar',
    'men'   => 'mende',
    'mer'   => 'Meru',
    'mfe'   => 'Morisyen',
    'mg'    => 'málgas',
    'mga'   => "közép\ ír",
    'mgh'   => 'mgh',
    'mh'    => 'marshalli',
    'mi'    => 'maori',
    'mic'   => 'mikmak',
    'min'   => 'minangkabau',
    'mis'   => "egyéb\ nyelvek",
    'mk'    => 'macedón',
    'mkh'   => "egyéb\ mon\-khmer",
    'ml'    => 'malajálam',
    'mn'    => 'mongol',
    'mnc'   => 'mandzsu',
    'mni'   => 'manipuri',
    'mno'   => "manobó\ nyelvek",
    'mo'    => 'moldvai',
    'moh'   => 'mohawk',
    'mos'   => 'moszi',
    'mr'    => 'marathi',
    'ms'    => 'maláj',
    'mt'    => 'máltai',
    'mua'   => 'mua',
    'mul'   => "többszörös\ nyelvek",
    'mun'   => "munda\ nyelvek",
    'mus'   => 'krík',
    'mwl'   => 'mirandéz',
    'mwr'   => 'marvari',
    'my'    => 'burmai',
    'myn'   => "maja\ nyelvek",
    'myv'   => 'erzjány',
    'na'    => 'naurui',
    'nah'   => 'nahuati',
    'nai'   => "észak\-amerikai\ indián\ nyelv",
    'nap'   => 'nápolyi',
    'naq'   => 'Nama',
    'nb'    => "norvég\ bokmal",
    'nd'    => "északi\ ndebele",
    'nds'   => 'alsónémet',
    'ne'    => 'nepáli',
    'new'   => 'nevari',
    'ng'    => 'ndonga',
    'nia'   => 'nias',
    'nic'   => "niger\-kordofan\ nyelv",
    'niu'   => 'niui',
    'nl'    => 'holland',
    'nl_be' => 'flamand',
    'nmg'   => 'nmg',
    'nn'    => "norvég\ nynorsk",
    'no'    => 'norvég',
    'nog'   => 'nogaj',
    'non'   => 'óskandináv',
    'nqo'   => "n\'kó",
    'nr'    => "déli\ ndebele",
    'nso'   => "északi\ szotó",
    'nub'   => "núbiai\ nyelv",
    'nus'   => 'nus',
    'nv'    => 'navahó',
    'nwc'   => "klasszikus\ newari",
    'ny'    => 'nyanja',
    'nym'   => 'nyamvézi',
    'nyn'   => 'nyankole',
    'nyo'   => 'nyoró',
    'nzi'   => 'nzima',
    'oc'    => 'okszitán',
    'oj'    => 'ojibva',
    'om'    => 'oromói',
    'or'    => 'orija',
    'os'    => 'oszét',
    'osa'   => 'osage',
    'ota'   => "ottomán\ török",
    'oto'   => "otomi\ nyelv",
    'pa'    => 'pandzsábi',
    'paa'   => "pápuai\ nyelv",
    'pag'   => 'pangaszinan',
    'pal'   => 'pahlavi',
    'pam'   => 'pampangan',
    'pap'   => 'papiamentó',
    'pau'   => 'palaui',
    'peo'   => 'óperzsa',
    'phi'   => "Fülöp\-szigeteki\ nyelv",
    'phn'   => 'főniciai',
    'pi'    => 'pali',
    'pl'    => 'lengyel',
    'pon'   => 'pohnpei',
    'pra'   => "prakrit\ nyelvek",
    'pro'   => 'óprovánszi',
    'ps'    => 'Pastu',
    'pt'    => 'portugál',
    'pt_br' => "brazíliai\ portugál",
    'pt_pt' => "ibériai\ portugál",
    'qu'    => 'kecsua',
    'raj'   => 'radzsasztáni',
    'rap'   => 'rapanui',
    'rar'   => 'rarotongai',
    'rm'    => "réto\-román",
    'rn'    => 'kirundi',
    'ro'    => 'román',
    'roa'   => "román\ nyelv",
    'rof'   => 'rombo',
    'rom'   => 'roma',
    'ru'    => 'orosz',
    'rup'   => 'aromán',
    'rw'    => 'kiruanda',
    'rwk'   => 'rwo',
    'sa'    => 'szanszkrit',
    'sad'   => 'szandave',
    'sah'   => 'jakut',
    'sai'   => "dél\-amerikai\ indián\ nyelv",
    'sal'   => "szelis\ nyelv",
    'sam'   => "szamaritánus\ arámi",
    'saq'   => 'Samburu',
    'sas'   => 'sasak',
    'sat'   => 'szantáli',
    'sbp'   => 'sbp',
    'sc'    => 'szardíniai',
    'scn'   => 'szicíliai',
    'sco'   => 'skót',
    'sd'    => 'szindhi',
    'se'    => "északi\ számi",
    'see'   => 'Seneca',
    'seh'   => 'Sena',
    'sel'   => 'szölkup',
    'sem'   => "egyéb\ szemita",
    'ses'   => "Koyraboro\ Senni",
    'sg'    => 'szangó',
    'sga'   => 'óír',
    'sgn'   => 'jelnyelv',
    'sh'    => 'szerbhorvát',
    'shi'   => 'Tachelhit',
    'shn'   => 'san',
    'si'    => 'szingaléz',
    'sid'   => 'szidamó',
    'sio'   => "sziú\ nyelvek",
    'sit'   => "sinotibeti\ nyelv",
    'sk'    => 'szlovák',
    'sl'    => 'szlovén',
    'sla'   => "szláv\ nyelv",
    'sm'    => 'szamoai',
    'sma'   => "déli\ számi",
    'smi'   => "lapp\ nyelv",
    'smj'   => "lule\ számi",
    'smn'   => "inar\ sami",
    'sms'   => "koltta\ lapp",
    'sn'    => 'sona',
    'snk'   => 'szoninke',
    'so'    => 'szomáliai',
    'sog'   => 'sogdien',
    'son'   => 'szongai',
    'sq'    => 'albán',
    'sr'    => 'szerb',
    'srn'   => "szranai\ tongó",
    'srr'   => 'szerer',
    'ss'    => 'sziszuati',
    'ssa'   => "nílusi\-szaharai\ nyelv",
    'ssy'   => 'Saho',
    'st'    => 'szeszotó',
    'su'    => 'szundanéz',
    'suk'   => 'szukuma',
    'sus'   => 'szuszu',
    'sux'   => 'sumér',
    'sv'    => 'svéd',
    'sw'    => 'szuahéli',
    'swb'   => 'comorei',
    'swc'   => "Congo\ Swahili",
    'syc'   => "klasszikus\ szír",
    'syr'   => 'szíriai',
    'ta'    => 'tamil',
    'tai'   => "thai\ nyelv",
    'te'    => 'telugu',
    'tem'   => 'temne',
    'teo'   => 'Teso',
    'ter'   => 'terenó',
    'tet'   => 'tetum',
    'tg'    => 'tadzsik',
    'th'    => 'thai',
    'ti'    => 'tigrinja',
    'tig'   => 'tigré',
    'tiv'   => 'tiv',
    'tk'    => 'türkmén',
    'tkl'   => 'tokelaui',
    'tl'    => 'tagalog',
    'tlh'   => 'klingon',
    'tli'   => 'tlingit',
    'tmh'   => 'tamasek',
    'tn'    => 'szecsuáni',
    'to'    => 'tonga',
    'tog'   => "nyasa\ tonga",
    'tpi'   => "tok\ pisin",
    'tr'    => 'török',
    'trv'   => 'Taroko',
    'ts'    => 'conga',
    'tsi'   => 'csimsiáni',
    'tt'    => 'tatár',
    'tum'   => 'tumbuka',
    'tup'   => "tupi\ nyelv",
    'tut'   => "altáji\ nyelv",
    'tvl'   => 'tuvalu',
    'tw'    => 'twi',
    'twq'   => 'twq',
    'ty'    => 'tahiti',
    'tyv'   => 'tuvai',
    'tzm'   => "Central\ Morocco\ Tamazight",
    'udm'   => 'udmurt',
    'ug'    => 'Ujgur',
    'uga'   => 'ugariti',
    'uk'    => 'ukrán',
    'umb'   => 'umbundu',
    'und'   => "ismeretlen\ vagy\ érvénytelen\ nyelv",
    'ur'    => 'urdu',
    'uz'    => 'üzbég',
    'vai'   => 'vai',
    've'    => 'venda',
    'vi'    => 'vietnami',
    'vo'    => 'volapük',
    'vot'   => 'votják',
    'vun'   => 'Vunjo',
    'wa'    => 'vallon',
    'wae'   => 'walser',
    'wak'   => "vakas\ nyelv",
    'wal'   => 'valamo',
    'war'   => 'varaó',
    'was'   => 'vasó',
    'wen'   => "szorb\ nyelvek",
    'wo'    => 'volof',
    'xal'   => 'kalmük',
    'xh'    => 'hosza',
    'xog'   => 'Soga',
    'yao'   => 'jaó',
    'yap'   => 'japi',
    'yav'   => 'yav',
    'yi'    => 'jiddis',
    'yo'    => 'joruba',
    'ypk'   => "jupik\ nyelv",
    'yue'   => 'kantoni',
    'za'    => 'zsuang',
    'zap'   => 'zapoték',
    'zbl'   => "Bliss\ jelképrendszer",
    'zen'   => 'zenaga',
    'zh'    => 'kínai',
    'znd'   => 'zande',
    'zu'    => 'zulu',
    'zun'   => 'zuni',
    'zxx'   => "nincs\ nyelvészeti\ tartalom",
    'zza'   => 'zaza',
);

%Locales::DB::Language::hu::name_to_code = (
    'abház'                            => 'ab',
    'achinéz'                          => 'ace',
    'adangme'                           => 'ada',
    'adyghe'                            => 'ady',
    'afar'                              => 'aa',
    'afrihili'                          => 'afh',
    'afrikaans'                         => 'af',
    'afroázsiainyelv'                  => 'afa',
    'agq'                               => 'agq',
    'ainu'                              => 'ain',
    'ajmara'                            => 'ay',
    'akan'                              => 'ak',
    'akkád'                            => 'akk',
    'akoli'                             => 'ach',
    'albán'                            => 'sq',
    'aleut'                             => 'ale',
    'algonkinnyelv'                     => 'alg',
    'alsónémet'                       => 'nds',
    'alsószorb'                        => 'dsb',
    'altájinyelv'                      => 'tut',
    'amerikaiangol'                     => 'en_us',
    'amhara'                            => 'am',
    'angika'                            => 'anp',
    'angol'                             => 'en',
    'apacsnyelvek'                      => 'apa',
    'arab'                              => 'ar',
    'aragonéz'                         => 'an',
    'arapaho'                           => 'arp',
    'araucani'                          => 'arn',
    'aravak'                            => 'arw',
    'aromán'                           => 'rup',
    'arámi'                            => 'arc',
    'asszámi'                          => 'as',
    'asu'                               => 'asa',
    'asztúr'                           => 'ast',
    'atapaszkannyelvek'                 => 'ath',
    'atszam'                            => 'cch',
    'ausztronéz'                       => 'map',
    'ausztrálangol'                    => 'en_au',
    'ausztrálnyelvek'                  => 'aus',
    'avar'                              => 'av',
    'avesztán'                         => 'ae',
    'awádi'                            => 'awa',
    'azeri'                             => 'az',
    'balinéz'                          => 'ban',
    'baltinyelv'                        => 'bat',
    'balucsi'                           => 'bal',
    'bambara'                           => 'bm',
    'bamilekenyelvek'                   => 'bai',
    'banda'                             => 'bad',
    'bantu'                             => 'bnt',
    'baskír'                           => 'ba',
    'basza'                             => 'bas',
    'baszk'                             => 'eu',
    'batak'                             => 'btk',
    'bedzsa'                            => 'bej',
    'belorusz'                          => 'be',
    'bemba'                             => 'bem',
    'bena'                              => 'bez',
    'bengáli'                          => 'bn',
    'berber'                            => 'ber',
    'bihari'                            => 'bh',
    'bikol'                             => 'bik',
    'bini'                              => 'bin',
    'bislama'                           => 'bi',
    'blin'                              => 'byn',
    'blissjelképrendszer'              => 'zbl',
    'bodo'                              => 'brx',
    'bodzspuri'                         => 'bho',
    'bolgár'                           => 'bg',
    'bosnyák'                          => 'bs',
    'braj'                              => 'bra',
    'brazíliaiportugál'               => 'pt_br',
    'breton'                            => 'br',
    'britangol'                         => 'en_gb',
    'buginéz'                          => 'bug',
    'burját'                           => 'bua',
    'burmai'                            => 'my',
    'butáni'                           => 'dz',
    'caddo'                             => 'cad',
    'cayuga'                            => 'cay',
    'cebui'                             => 'ceb',
    'centralmoroccotamazight'           => 'tzm',
    'chiga'                             => 'cgg',
    'colognian'                         => 'ksh',
    'comorei'                           => 'swb',
    'conga'                             => 'ts',
    'congoswahili'                      => 'swc',
    'csagatáj'                         => 'chg',
    'csamnyelv'                         => 'cmc',
    'csamoró'                          => 'ch',
    'csecsen'                           => 'ce',
    'cseh'                              => 'cs',
    'csejen'                            => 'chy',
    'cseroki'                           => 'chr',
    'csibcsa'                           => 'chb',
    'csimsiáni'                        => 'tsi',
    'csinukzsargon'                     => 'chn',
    'csipevé'                          => 'chp',
    'csoktó'                           => 'cho',
    'csukéz'                           => 'chk',
    'csuvas'                            => 'cv',
    'dajak'                             => 'day',
    'dakota'                            => 'dak',
    'dargva'                            => 'dar',
    'delavár'                          => 'del',
    'dinka'                             => 'din',
    'diula'                             => 'dyu',
    'divehi'                            => 'dv',
    'dje'                               => 'dje',
    'dogri'                             => 'doi',
    'dogrib'                            => 'dgr',
    'duala'                             => 'dua',
    'dyo'                               => 'dyo',
    'dán'                              => 'da',
    'délaltaji'                        => 'alt',
    'délamerikaiindiánnyelv'          => 'sai',
    'délindebele'                      => 'nr',
    'déliszámi'                       => 'sma',
    'efik'                              => 'efi',
    'egyháziszláv'                    => 'cu',
    'egyébangolalapúkreoléspidgin'   => 'cpe',
    'egyébdravida'                     => 'dra',
    'egyébfranciaalapúkreoléspidgin' => 'cpf',
    'egyébindiai'                      => 'inc',
    'egyébkaukázusi'                  => 'cau',
    'egyébkelta'                       => 'cel',
    'egyébkoiszan'                     => 'khi',
    'egyébközépamerikaiindián'      => 'cai',
    'egyébmonkhmer'                    => 'mkh',
    'egyébnyelvek'                     => 'mis',
    'egyébszemita'                     => 'sem',
    'ekadzsuk'                          => 'eka',
    'elamit'                            => 'elx',
    'embu'                              => 'ebu',
    'erzjány'                          => 'myv',
    'eszperantó'                       => 'eo',
    'eve'                               => 'ee',
    'evondo'                            => 'ewo',
    'fang'                              => 'fan',
    'fanti'                             => 'fat',
    'felsőszorb'                       => 'hsb',
    'feröeri'                          => 'fo',
    'fidzsi'                            => 'fj',
    'filippínó'                       => 'fil',
    'finn'                              => 'fi',
    'finnugornyelv'                     => 'fiu',
    'flamand'                           => 'nl_be',
    'fon'                               => 'fon',
    'francia'                           => 'fr',
    'friuli'                            => 'fur',
    'fríz'                             => 'fy',
    'fulani'                            => 'ff',
    'fülöpszigetekinyelv'             => 'phi',
    'főniciai'                         => 'phn',
    'ga'                                => 'gaa',
    'gajo'                              => 'gay',
    'galíciai'                         => 'gl',
    'ganda'                             => 'lg',
    'gbaja'                             => 'gba',
    'geez'                              => 'gez',
    'germánnyelv'                      => 'gem',
    'gondi'                             => 'gon',
    'gorontalo'                         => 'gor',
    'grebó'                            => 'grb',
    'grönlandi'                        => 'kl',
    'grúz'                             => 'ka',
    'guarani'                           => 'gn',
    'gudzsarati'                        => 'gu',
    'gusii'                             => 'guz',
    'gvicsin'                           => 'gwi',
    'gót'                              => 'got',
    'görög'                           => 'el',
    'haida'                             => 'hai',
    'haiti'                             => 'ht',
    'hausza'                            => 'ha',
    'hawaii'                            => 'haw',
    'herero'                            => 'hz',
    'hiligajnon'                        => 'hil',
    'himaháli'                         => 'him',
    'hindi'                             => 'hi',
    'hirimotu'                          => 'ho',
    'hittite'                           => 'hit',
    'hmong'                             => 'hmn',
    'holland'                           => 'nl',
    'horvát'                           => 'hr',
    'hosza'                             => 'xh',
    'hupa'                              => 'hup',
    'héber'                            => 'he',
    'iban'                              => 'iba',
    'ibériaiportugál'                 => 'pt_pt',
    'ibériaispanyol'                   => 'es_es',
    'idzsó'                            => 'ijo',
    'idó'                              => 'io',
    'igbó'                             => 'ig',
    'ikiribati'                         => 'gil',
    'ilokó'                            => 'ilo',
    'inarsami'                          => 'smn',
    'indoeurópainyelv'                 => 'ine',
    'indonéz'                          => 'id',
    'ingus'                             => 'inh',
    'interlingue'                       => 'ie',
    'interlingva'                       => 'ia',
    'inuktitut'                         => 'iu',
    'inupiak'                           => 'ik',
    'irokéznyelvek'                    => 'iro',
    'iráni'                            => 'ira',
    'ismeretlenvagyérvénytelennyelv'  => 'und',
    'izlandi'                           => 'is',
    'jakut'                             => 'sah',
    'japi'                              => 'yap',
    'japán'                            => 'ja',
    'jaó'                              => 'yao',
    'jelnyelv'                          => 'sgn',
    'jiddis'                            => 'yi',
    'jju'                               => 'kaj',
    'joruba'                            => 'yo',
    'jupiknyelv'                        => 'ypk',
    'jávai'                            => 'jv',
    'kabardi'                           => 'kbd',
    'kabije'                            => 'kab',
    'kabuverdianu'                      => 'kea',
    'kacsin'                            => 'kac',
    'kalenjin'                          => 'kln',
    'kalmük'                           => 'xal',
    'kamba'                             => 'kam',
    'kambodzsai'                        => 'km',
    'kanadaiangol'                      => 'en_ca',
    'kanadaifrancia'                    => 'fr_ca',
    'kannada'                           => 'kn',
    'kantoni'                           => 'yue',
    'kanuri'                            => 'kr',
    'karacsájbalkár'                  => 'krc',
    'karakalpak'                        => 'kaa',
    'karelai'                           => 'krl',
    'karen'                             => 'kar',
    'karib'                             => 'car',
    'kasub'                             => 'csb',
    'kaszi'                             => 'kha',
    'katalán'                          => 'ca',
    'kawi'                              => 'kaw',
    'kazah'                             => 'kk',
    'kecsua'                            => 'qu',
    'keletifríz'                       => 'frs',
    'kikuju'                            => 'ki',
    'kimbundu'                          => 'kmb',
    'kirgiz'                            => 'ky',
    'kiruanda'                          => 'rw',
    'kirundi'                           => 'rn',
    'klasszikusnewari'                  => 'nwc',
    'klasszikusszír'                   => 'syc',
    'klingon'                           => 'tlh',
    'kolttalapp'                        => 'sms',
    'komi'                              => 'kv',
    'kongo'                             => 'kg',
    'konkani'                           => 'kok',
    'kopt'                              => 'cop',
    'koreai'                            => 'ko',
    'korni'                             => 'kw',
    'koro'                              => 'kfo',
    'korzikai'                          => 'co',
    'kosrei'                            => 'kos',
    'kotanéz'                          => 'kho',
    'koyraborosenni'                    => 'ses',
    'koyrachiini'                       => 'khq',
    'kpelle'                            => 'kpe',
    'kreoléspidzsin'                   => 'crp',
    'kru'                               => 'kro',
    'krí'                              => 'cr',
    'krík'                             => 'mus',
    'krímitatár'                      => 'crh',
    'ksf'                               => 'ksf',
    'kuanyama'                          => 'kj',
    'kumük'                            => 'kum',
    'kurd'                              => 'ku',
    'kuruh'                             => 'kru',
    'kusitanyelv'                       => 'cus',
    'kutenai'                           => 'kut',
    'kásmíri'                         => 'ks',
    'kínai'                            => 'zh',
    'középangol'                      => 'enm',
    'középfelsőnémet'               => 'gmh',
    'középfrancia'                    => 'frm',
    'középholland'                    => 'dum',
    'középír'                        => 'mga',
    'ladino'                            => 'lad',
    'lahnda'                            => 'lah',
    'lamba'                             => 'lam',
    'langi'                             => 'lag',
    'laoszi'                            => 'lo',
    'lappnyelv'                         => 'smi',
    'latin'                             => 'la',
    'lengyel'                           => 'pl',
    'lett'                              => 'lv',
    'lezg'                              => 'lez',
    'limburgi'                          => 'li',
    'lingala'                           => 'ln',
    'litván'                           => 'lt',
    'lojban'                            => 'jbo',
    'lozi'                              => 'loz',
    'lubakatanga'                       => 'lu',
    'lubalulua'                         => 'lua',
    'luiseno'                           => 'lui',
    'lujia'                             => 'luy',
    'luleszámi'                        => 'smj',
    'lunda'                             => 'lun',
    'luo'                               => 'luo',
    'lushai'                            => 'lus',
    'luxemburgi'                        => 'lb',
    'macedón'                          => 'mk',
    'machame'                           => 'jmc',
    'madurai'                           => 'mad',
    'magahi'                            => 'mag',
    'magyar'                            => 'hu',
    'maithili'                          => 'mai',
    'majanyelvek'                       => 'myn',
    'makaszar'                          => 'mak',
    'makonde'                           => 'kde',
    'malajálam'                        => 'ml',
    'maláj'                            => 'ms',
    'mandar'                            => 'mdr',
    'mandingó'                         => 'man',
    'mandzsu'                           => 'mnc',
    'manipuri'                          => 'mni',
    'manobónyelvek'                    => 'mno',
    'manszigeti'                        => 'gv',
    'maori'                             => 'mi',
    'marathi'                           => 'mr',
    'mari'                              => 'chm',
    'marshalli'                         => 'mh',
    'marvari'                           => 'mwr',
    'masai'                             => 'mas',
    'mende'                             => 'men',
    'meru'                              => 'mer',
    'mesterségesnyelv'                 => 'art',
    'mgh'                               => 'mgh',
    'mikmak'                            => 'mic',
    'minangkabau'                       => 'min',
    'mirandéz'                         => 'mwl',
    'mohawk'                            => 'moh',
    'moksán'                           => 'mdf',
    'moldvai'                           => 'mo',
    'mongol'                            => 'mn',
    'mongó'                            => 'lol',
    'morisyen'                          => 'mfe',
    'moszi'                             => 'mos',
    'mua'                               => 'mua',
    'mundanyelvek'                      => 'mun',
    'málgas'                           => 'mg',
    'máltai'                           => 'mt',
    'nahuati'                           => 'nah',
    'nama'                              => 'naq',
    'naurui'                            => 'na',
    'navahó'                           => 'nv',
    'ndonga'                            => 'ng',
    'nepáli'                           => 'ne',
    'nevari'                            => 'new',
    'nias'                              => 'nia',
    'nigerkordofannyelv'                => 'nic',
    'nincsnyelvészetitartalom'         => 'zxx',
    'niui'                              => 'niu',
    'nkó'                              => 'nqo',
    'nmg'                               => 'nmg',
    'nogaj'                             => 'nog',
    'norvég'                           => 'no',
    'norvégbokmal'                     => 'nb',
    'norvégnynorsk'                    => 'nn',
    'nus'                               => 'nus',
    'nyamvézi'                         => 'nym',
    'nyanja'                            => 'ny',
    'nyankole'                          => 'nyn',
    'nyasatonga'                        => 'tog',
    'nyoró'                            => 'nyo',
    'nzima'                             => 'nzi',
    'nápolyi'                          => 'nap',
    'német'                            => 'de',
    'nílusiszaharainyelv'              => 'ssa',
    'núbiainyelv'                      => 'nub',
    'ojibva'                            => 'oj',
    'okszitán'                         => 'oc',
    'olasz'                             => 'it',
    'orija'                             => 'or',
    'oromói'                           => 'om',
    'orosz'                             => 'ru',
    'osage'                             => 'osa',
    'osztráknémet'                    => 'de_at',
    'oszét'                            => 'os',
    'otominyelv'                        => 'oto',
    'ottomántörök'                   => 'ota',
    'pahlavi'                           => 'pal',
    'palaui'                            => 'pau',
    'pali'                              => 'pi',
    'pampangan'                         => 'pam',
    'pandzsábi'                        => 'pa',
    'pangaszinan'                       => 'pag',
    'papiamentó'                       => 'pap',
    'pastu'                             => 'ps',
    'perzsa'                            => 'fa',
    'pohnpei'                           => 'pon',
    'portugál'                         => 'pt',
    'portugálalapúkreolvagypidgin'    => 'cpp',
    'prakritnyelvek'                    => 'pra',
    'pápuainyelv'                      => 'paa',
    'radzsasztáni'                     => 'raj',
    'rapanui'                           => 'rap',
    'rarotongai'                        => 'rar',
    'roma'                              => 'rom',
    'rombo'                             => 'rof',
    'román'                            => 'ro',
    'románnyelv'                       => 'roa',
    'rwo'                               => 'rwk',
    'rétoromán'                       => 'rm',
    'saho'                              => 'ssy',
    'samburu'                           => 'saq',
    'san'                               => 'shn',
    'sasak'                             => 'sas',
    'sbp'                               => 'sbp',
    'sena'                              => 'seh',
    'seneca'                            => 'see',
    'shambala'                          => 'ksb',
    'siksika'                           => 'bla',
    'sinotibetinyelv'                   => 'sit',
    'skót'                             => 'sco',
    'skótgael'                         => 'gd',
    'soga'                              => 'xog',
    'sogdien'                           => 'sog',
    'sona'                              => 'sn',
    'spanyol'                           => 'es',
    'sumér'                            => 'sux',
    'svájcifelnémet'                  => 'de_ch',
    'svájcifrancia'                    => 'fr_ch',
    'svájcinémet'                     => 'gsw',
    'svéd'                             => 'sv',
    'szamaritánusarámi'               => 'sam',
    'szamoai'                           => 'sm',
    'szandave'                          => 'sad',
    'szangó'                           => 'sg',
    'szanszkrit'                        => 'sa',
    'szantáli'                         => 'sat',
    'szardíniai'                       => 'sc',
    'szecsuáni'                        => 'tn',
    'szecsuánji'                       => 'ii',
    'szelisnyelv'                       => 'sal',
    'szerb'                             => 'sr',
    'szerbhorvát'                      => 'sh',
    'szerer'                            => 'srr',
    'szeszotó'                         => 'st',
    'szicíliai'                        => 'scn',
    'szidamó'                          => 'sid',
    'szindhi'                           => 'sd',
    'szingaléz'                        => 'si',
    'sziszuati'                         => 'ss',
    'sziúnyelvek'                      => 'sio',
    'szlevi'                            => 'den',
    'szlovák'                          => 'sk',
    'szlovén'                          => 'sl',
    'szlávnyelv'                       => 'sla',
    'szomáliai'                        => 'so',
    'szongai'                           => 'son',
    'szoninke'                          => 'snk',
    'szorbnyelvek'                      => 'wen',
    'szranaitongó'                     => 'srn',
    'szuahéli'                         => 'sw',
    'szukuma'                           => 'suk',
    'szundanéz'                        => 'su',
    'szuszu'                            => 'sus',
    'szíriai'                          => 'syr',
    'szölkup'                          => 'sel',
    'tachelhit'                         => 'shi',
    'tadzsik'                           => 'tg',
    'tagalog'                           => 'tl',
    'tahiti'                            => 'ty',
    'taita'                             => 'dav',
    'tamasek'                           => 'tmh',
    'tamil'                             => 'ta',
    'taroko'                            => 'trv',
    'tatár'                            => 'tt',
    'telugu'                            => 'te',
    'temne'                             => 'tem',
    'terenó'                           => 'ter',
    'teso'                              => 'teo',
    'tetum'                             => 'tet',
    'thai'                              => 'th',
    'thainyelv'                         => 'tai',
    'tibeti'                            => 'bo',
    'tigrinja'                          => 'ti',
    'tigré'                            => 'tig',
    'tiv'                               => 'tiv',
    'tlingit'                           => 'tli',
    'tokelaui'                          => 'tkl',
    'tokpisin'                          => 'tpi',
    'tonga'                             => 'to',
    'tumbuka'                           => 'tum',
    'tupinyelv'                         => 'tup',
    'tuvai'                             => 'tyv',
    'tuvalu'                            => 'tvl',
    'twi'                               => 'tw',
    'twq'                               => 'twq',
    'tyap'                              => 'kcg',
    'többszörösnyelvek'              => 'mul',
    'török'                           => 'tr',
    'türkmén'                         => 'tk',
    'udmurt'                            => 'udm',
    'ugariti'                           => 'uga',
    'ujgur'                             => 'ug',
    'ukrán'                            => 'uk',
    'umbundu'                           => 'umb',
    'urdu'                              => 'ur',
    'vai'                               => 'vai',
    'vakasnyelv'                        => 'wak',
    'valamo'                            => 'wal',
    'vallon'                            => 'wa',
    'varaó'                            => 'war',
    'vasó'                             => 'was',
    'venda'                             => 've',
    'vietnami'                          => 'vi',
    'volapük'                          => 'vo',
    'volof'                             => 'wo',
    'votják'                           => 'vot',
    'vunjo'                             => 'vun',
    'walesi'                            => 'cy',
    'walser'                            => 'wae',
    'yav'                               => 'yav',
    'zande'                             => 'znd',
    'zapoték'                          => 'zap',
    'zaza'                              => 'zza',
    'zenaga'                            => 'zen',
    'zsidóarab'                        => 'jrb',
    'zsidóperzsa'                      => 'jpr',
    'zsuang'                            => 'za',
    'zulu'                              => 'zu',
    'zuni'                              => 'zun',
    'északamerikaiindiánnyelv'        => 'nai',
    'északifríz'                      => 'frr',
    'északindebele'                    => 'nd',
    'északiszotó'                     => 'nso',
    'északiszámi'                     => 'se',
    'észt'                             => 'et',
    'ír'                               => 'ga',
    'óangol'                           => 'ang',
    'óegyiptomi'                       => 'egy',
    'ófelsőnémet'                    => 'goh',
    'ófrancia'                         => 'fro',
    'ógörög'                         => 'grc',
    'óperzsa'                          => 'peo',
    'óprovánszi'                      => 'pro',
    'óskandináv'                      => 'non',
    'óír'                             => 'sga',
    'örmény'                          => 'hy',
    'üzbég'                           => 'uz',
);

1;
