package Locales::DB::Language::sk;

# Auto generated from CLDR

$Locales::DB::Language::sk::VERSION = '0.08';

$Locales::DB::Language::sk::cldr_version = '2.0';

%Locales::DB::Language::sk::misc_info = (
    'characters'   => { 'more_information' => "\?" },
    'cldr_formats' => {
        '_decimal_format_decimal' => "\,",
        '_decimal_format_group'   => ' ',
        '_percent_format_percent' => "\%",
        'decimal'                 => "\#\,\#\#0\.\#\#\#",
        'ellipsis'                => {
            'final'   => "\{0\}…",
            'initial' => "…\{0\}",
            'medial'  => "\{0\}…\{1\}"
        },
        'language' => "Jazyk\:\ \{0\}",
        'list'     => {
            2        => "\{0\}\ a\ \{1\}",
            'end'    => "\{0\}\ a\ \{1\}",
            'middle' => "\{0\}\,\ \{1\}",
            'start'  => "\{0\}\,\ \{1\}"
        },
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0 \%",
        'territory' => "Región\:\ \{0\}"
    },
    'delimiters' => {
        'alternate_quotation_end'   => '“',
        'alternate_quotation_start' => '„',
        'quotation_end'             => '‘',
        'quotation_start'           => '‚'
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'plural_forms' => {
        'category_list' => [
            'one',
            'few',
            'other'
        ],
        'category_rules' => {
            'few' => "n\ in\ 2\.\.4",
            'one' => "n\ is\ 1"
        },
        'category_rules_compiled' => {
            'few' => "sub\ \{\ return\ \'few\'\ if\ \(\ \(\(\ int\(\$_\[0\]\)\ \=\=\ \$_\[0\]\ \&\&\ \$_\[0\]\ \>\=\ 2\ \&\&\ \$_\[0\]\ \<\=\ 4\ \)\)\)\;\ return\;\}\;",
            'one' => "sub\ \{\ return\ \'one\'\ if\ \(\ \(\(\ \$_\[0\]\ \=\=\ 1\)\)\)\;\ return\;\}\;"
        }
    },
    'posix' => {
        'nostr'  => "nie\:n",
        'yesstr' => "áno\:a"
    },
);

%Locales::DB::Language::sk::code_to_name = (
    'aa'    => 'afarčina',
    'ab'    => 'abcházština',
    'ace'   => 'Achinese',
    'ach'   => 'ačoli',
    'ada'   => 'adangme',
    'ady'   => 'adygčina',
    'ae'    => 'avestčina',
    'af'    => 'afrikánčina',
    'afa'   => "afroázijské\ jazyky",
    'afh'   => 'afrihili',
    'agq'   => 'Aghem',
    'ain'   => 'ainčina',
    'ak'    => 'akančina',
    'akk'   => 'akkadčina',
    'ale'   => 'aleutčina',
    'alg'   => "algonkinské\ jazyky",
    'alt'   => "Southern\ Altai",
    'am'    => 'amharčina',
    'an'    => 'aragónčina',
    'ang'   => "Old\ English",
    'anp'   => 'angika',
    'apa'   => "apačské\ jazyky",
    'ar'    => 'arabčina',
    'arc'   => 'Aramaic',
    'arn'   => 'araukánčina',
    'arp'   => 'arapaho',
    'art'   => "umelý\ jazyk",
    'arw'   => 'arawačtina',
    'as'    => 'ásámčina',
    'asa'   => 'Asu',
    'ast'   => 'astúrčina',
    'ath'   => "athabaské\ jazyky",
    'aus'   => "austrálske\ jazyky",
    'av'    => 'avarčina',
    'awa'   => 'avadhčina',
    'ay'    => 'aymarčina',
    'az'    => 'azerbajdžančina',
    'ba'    => 'baskirčina',
    'bad'   => 'Banda',
    'bai'   => 'bamileke',
    'bal'   => 'balúčtina',
    'ban'   => 'balijčina',
    'bas'   => 'basa',
    'bat'   => "baltské\ jazyky",
    'be'    => 'bieloruština',
    'bej'   => 'bedža',
    'bem'   => 'bemba',
    'ber'   => "berberské\ jazyky",
    'bez'   => 'Bena',
    'bg'    => 'bulharčina',
    'bh'    => "bihárske\ jazyky",
    'bho'   => 'bhódžpurčina',
    'bi'    => 'bislama',
    'bik'   => 'bikol',
    'bin'   => 'bini',
    'bla'   => 'Siksika',
    'bm'    => 'bambarčina',
    'bn'    => 'bengálčina',
    'bnt'   => "bantuské\ jazyky",
    'bo'    => 'tibetčina',
    'br'    => 'bretónčina',
    'bra'   => 'bradžčina',
    'brx'   => 'Bodo',
    'bs'    => 'bosniačtina',
    'btk'   => "batacké\ jazyky",
    'bua'   => 'buriatčina',
    'bug'   => 'bugiština',
    'byn'   => 'blin',
    'ca'    => 'katalánčina',
    'cad'   => 'Caddo',
    'cai'   => "jazyk\ stredoamerických\ indiánov",
    'car'   => 'karibský',
    'cau'   => "kaukazské\ jazyky",
    'cay'   => 'Cayuga',
    'cch'   => 'Atsam',
    'ce'    => 'čečenčina',
    'ceb'   => 'cebuánčina',
    'cel'   => "keltské\ jazyky",
    'cgg'   => 'Chiga',
    'ch'    => 'čamorčina',
    'chb'   => 'čibča',
    'chg'   => 'čagatajčina',
    'chk'   => 'Chuukese',
    'chm'   => 'Mari',
    'chn'   => "činucký\ žargón",
    'cho'   => 'čoktavčina',
    'chp'   => 'čipevajčina',
    'chr'   => 'čerokí',
    'chy'   => 'čejenčina',
    'cmc'   => "čamaské\ jazyky",
    'co'    => 'korzičtina',
    'cop'   => 'Coptic',
    'cpe'   => "English\-based\ Creole\ or\ Pidgin",
    'cpf'   => "French\-based\ Creole\ or\ Pidgin",
    'cpp'   => "Portuguese\-based\ Creole\ or\ Pidgin",
    'cr'    => 'krí',
    'crh'   => "Crimean\ Turkish",
    'crp'   => "Creole\ or\ Pidgin",
    'cs'    => 'čeština',
    'csb'   => 'Kashubian',
    'cu'    => "cirkevná\ slovančina",
    'cus'   => "Cushitic\ Language",
    'cv'    => 'čuvaština',
    'cy'    => 'waleština',
    'da'    => 'dánčina',
    'dak'   => 'dakotčina',
    'dar'   => 'darginčina',
    'dav'   => 'Taita',
    'day'   => 'Dayak',
    'de'    => 'nemčina',
    'de_at' => "rakúska\ nemčina",
    'de_ch' => "švajčiarska\ spisovná\ nemčina",
    'del'   => 'delawarčina',
    'den'   => 'slovančina',
    'dgr'   => 'dogribčina',
    'din'   => 'dinka',
    'dje'   => 'Zarma',
    'doi'   => 'dógrí',
    'dra'   => "drávidské\ jazyky",
    'dsb'   => "Lower\ Sorbian",
    'dua'   => 'duala',
    'dum'   => "Middle\ Dutch",
    'dv'    => 'divehi',
    'dyo'   => "Jola\-Fonyi",
    'dyu'   => 'ďula',
    'dz'    => 'dzongkä',
    'ebu'   => 'Embu',
    'ee'    => 'eweština',
    'efi'   => 'efik',
    'egy'   => 'staroegyptský',
    'eka'   => 'ekadžuk',
    'el'    => 'gréčtina',
    'elx'   => 'elamčina',
    'en'    => 'angličtina',
    'en_au' => "austrálska\ angličtina",
    'en_ca' => "kanadská\ angličtina",
    'en_gb' => "britská\ angličtina",
    'en_us' => "americká\ angličtina",
    'enm'   => "Middle\ English",
    'eo'    => 'esperanto',
    'es'    => 'španielčina',
    'es_es' => "iberská\ španielčina",
    'et'    => 'estónčina',
    'eu'    => 'baskičtina',
    'ewo'   => 'ewondo',
    'fa'    => 'perzština',
    'fan'   => 'fangčina',
    'fat'   => 'fanti',
    'ff'    => 'fulbčina',
    'fi'    => 'fínčina',
    'fil'   => 'filipínčina',
    'fiu'   => "ugrofínske\ jazyky",
    'fj'    => 'fidžijčina',
    'fo'    => 'faerčina',
    'fon'   => 'fončina',
    'fr'    => 'francúzština',
    'fr_ca' => "kanadská\ francúzština",
    'fr_ch' => "švajčiarska\ francúzština",
    'frm'   => "Middle\ French",
    'fro'   => "Old\ French",
    'frr'   => "Northern\ Frisian",
    'frs'   => "východná\ frízština",
    'fur'   => 'friulčina',
    'fy'    => "západná\ frízština",
    'ga'    => 'írčina',
    'gaa'   => 'ga',
    'gay'   => 'gayo',
    'gba'   => 'gbaja',
    'gd'    => 'škótčina',
    'gem'   => "germánske\ jazyky",
    'gez'   => 'Geez',
    'gil'   => 'Gilbertese',
    'gl'    => 'galícijčina',
    'gmh'   => "Middle\ High\ German",
    'gn'    => 'guaraní',
    'goh'   => "Old\ High\ German",
    'gon'   => 'Gondi',
    'gor'   => 'Gorontalo',
    'got'   => 'gótčina',
    'grb'   => 'Grebo',
    'grc'   => 'starogréčtina',
    'gsw'   => "švajčiarska\ nemčina",
    'gu'    => 'gudžarátčina',
    'guz'   => 'Gusii',
    'gv'    => 'mančina',
    'gwi'   => "Gwich\Ê\¼in",
    'ha'    => 'hauština',
    'hai'   => 'Haida',
    'haw'   => 'havajčina',
    'he'    => 'hebrejčina',
    'hi'    => 'hindčina',
    'hil'   => 'Hiligaynon',
    'him'   => 'Himachali',
    'hit'   => 'Hittite',
    'hmn'   => 'Hmong',
    'ho'    => "hiri\ motu",
    'hr'    => 'chorvátčina',
    'hsb'   => "Upper\ Sorbian",
    'ht'    => 'haitský',
    'hu'    => 'maďarčina',
    'hup'   => 'Hupa',
    'hy'    => 'arménčina',
    'hz'    => 'herero',
    'ia'    => 'interlingua',
    'iba'   => 'Iban',
    'id'    => 'indonézština',
    'ie'    => 'interlingue',
    'ig'    => 'igboština',
    'ii'    => "Sichuan\ Yi",
    'ijo'   => 'Ijo',
    'ik'    => 'Inupiaq',
    'ilo'   => 'Iloko',
    'inc'   => "Indic\ Language",
    'ine'   => "indoeurópske\ jazyky",
    'inh'   => 'Ingush',
    'io'    => 'Ido',
    'ira'   => "iránske\ jazyky",
    'iro'   => "Iroquoian\ Language",
    'is'    => 'islandčina',
    'it'    => 'taliančina',
    'iu'    => 'Inuktitut',
    'ja'    => 'japončina',
    'jbo'   => 'Lojban',
    'jmc'   => 'Machame',
    'jpr'   => "Judeo\-Persian",
    'jrb'   => "Judeo\-Arabic",
    'jv'    => 'jávčina',
    'ka'    => 'gruzínčina',
    'kaa'   => "Kara\-Kalpak",
    'kab'   => 'Kabyle',
    'kac'   => 'Kachin',
    'kaj'   => 'Jju',
    'kam'   => 'Kamba',
    'kar'   => 'Karen',
    'kaw'   => 'Kawi',
    'kbd'   => 'Kabardian',
    'kcg'   => 'Tyap',
    'kde'   => 'Makonde',
    'kea'   => 'Kabuverdianu',
    'kfo'   => 'Koro',
    'kg'    => 'konžština',
    'kha'   => 'Khasi',
    'khi'   => "Khoisan\ Language",
    'kho'   => 'Khotanese',
    'khq'   => "Koyra\ Chiini",
    'ki'    => 'Kikuyu',
    'kj'    => 'kuaňama',
    'kk'    => 'kazaština',
    'kl'    => "grónska\ eskimáčtina",
    'kln'   => 'Kalenjin',
    'km'    => "kambodžská\ khmérčina",
    'kmb'   => 'Kimbundu',
    'kn'    => 'kannadčina',
    'ko'    => 'kórejčina',
    'kok'   => 'Konkani',
    'kos'   => 'Kosraean',
    'kpe'   => 'Kpelle',
    'kr'    => 'kanurijčina',
    'krc'   => "Karachay\-Balkar",
    'krl'   => 'Karelian',
    'kro'   => 'Kru',
    'kru'   => 'Kurukh',
    'ks'    => 'kašmírčina',
    'ksb'   => 'Shambala',
    'ksf'   => 'Bafia',
    'ksh'   => 'Colognian',
    'ku'    => 'kurdčina',
    'kum'   => 'Kumyk',
    'kut'   => 'Kutenai',
    'kv'    => 'komijčina',
    'kw'    => 'kornčina',
    'ky'    => 'kirgizština',
    'la'    => 'latinčina',
    'lad'   => 'Ladino',
    'lag'   => 'Langi',
    'lah'   => 'Lahnda',
    'lam'   => 'Lamba',
    'lb'    => 'luxemburčina',
    'lez'   => 'Lezghian',
    'lg'    => 'gandčina',
    'li'    => 'Limburgish',
    'ln'    => 'lingalčina',
    'lo'    => 'laoština',
    'lol'   => 'mongo',
    'loz'   => 'Lozi',
    'lt'    => 'litovčina',
    'lu'    => "luba\-katanga",
    'lua'   => "Luba\-Lulua",
    'lui'   => 'Luiseno',
    'lun'   => 'Lunda',
    'luo'   => 'Luo',
    'lus'   => 'Lushai',
    'luy'   => 'Luyia',
    'lv'    => 'lotyština',
    'mad'   => 'Madurese',
    'mag'   => 'Magahi',
    'mai'   => 'Maithili',
    'mak'   => 'Makasar',
    'man'   => 'Mandingo',
    'map'   => "austronézske\ jazyky",
    'mas'   => 'Masai',
    'mdf'   => 'Moksha',
    'mdr'   => 'Mandar',
    'men'   => 'Mende',
    'mer'   => 'Meru',
    'mfe'   => 'Morisyen',
    'mg'    => 'malgaština',
    'mga'   => "Middle\ Irish",
    'mgh'   => "Makhuwa\-Meetto",
    'mh'    => "kajin\-majol",
    'mi'    => 'maorijčina',
    'mic'   => 'Micmac',
    'min'   => 'Minangkabau',
    'mis'   => "Miscellaneous\ Language",
    'mk'    => 'macedónčina',
    'mkh'   => "Mon\-Khmer\ Language",
    'ml'    => 'malajálamčina',
    'mn'    => 'mongolčina',
    'mnc'   => 'Manchu',
    'mni'   => 'Manipuri',
    'mno'   => "Manobo\ Language",
    'mo'    => 'moldavčina',
    'moh'   => 'Mohawk',
    'mos'   => 'Mossi',
    'mr'    => 'maráthčina',
    'ms'    => 'malajčina',
    'mt'    => 'maltčina',
    'mua'   => 'Mundang',
    'mul'   => "Multiple\ Languages",
    'mun'   => "Munda\ Language",
    'mus'   => 'Creek',
    'mwl'   => 'Mirandese',
    'mwr'   => 'Marwari',
    'my'    => 'barmčina',
    'myn'   => "mayské\ jazyky",
    'myv'   => 'erzjančina',
    'na'    => 'nauru',
    'nah'   => 'Nahuatl',
    'nai'   => "jazyk\ severoamerických\ indiánov",
    'nap'   => 'Neapolitan',
    'naq'   => 'Nama',
    'nb'    => 'bokmål',
    'nd'    => "severné\ ndbele",
    'nds'   => "Low\ German",
    'ne'    => 'nepálčina',
    'new'   => 'Newari',
    'ng'    => 'ndonga',
    'nia'   => 'Nias',
    'nic'   => "Niger\-Kordofanian\ Language",
    'niu'   => 'Niuean',
    'nl'    => 'holandčina',
    'nl_be' => 'flámčina',
    'nmg'   => 'Kwasio',
    'nn'    => "nórsky\ nynorsk",
    'no'    => 'nórčina',
    'nog'   => 'Nogai',
    'non'   => "Old\ Norse",
    'nqo'   => "N\â\\Ko",
    'nr'    => "South\ Ndebele",
    'nso'   => "severná\ sothčina",
    'nub'   => "Nubian\ Language",
    'nus'   => 'Nuer',
    'nv'    => 'navajo',
    'nwc'   => "Classical\ Newari",
    'ny'    => 'čewa',
    'nym'   => 'Nyamwezi',
    'nyn'   => 'Nyankole',
    'nyo'   => 'Nyoro',
    'nzi'   => 'Nzima',
    'oc'    => 'okcitánčina',
    'oj'    => 'odžibva',
    'om'    => 'oromčina',
    'or'    => 'uríjčina',
    'os'    => 'osetčina',
    'osa'   => 'Osage',
    'ota'   => "Ottoman\ Turkish",
    'oto'   => "Otomian\ Language",
    'pa'    => 'pandžábčina',
    'paa'   => 'papuánsky',
    'pag'   => 'Pangasinan',
    'pal'   => 'Pahlavi',
    'pam'   => 'Pampanga',
    'pap'   => 'Papiamento',
    'pau'   => 'Palauan',
    'peo'   => "Old\ Persian",
    'phi'   => "Philippine\ Language",
    'phn'   => 'Phoenician',
    'pi'    => 'pálí',
    'pl'    => 'poľština',
    'pon'   => 'Pohnpeian',
    'pra'   => "Prakrit\ Language",
    'pro'   => "Old\ Proven\Ã\§al",
    'ps'    => 'paštčina',
    'pt'    => 'portugalčina',
    'pt_br' => "brazílska\ portugalčina",
    'pt_pt' => "iberská\ portugalčina",
    'qu'    => 'kečuánčina',
    'raj'   => 'Rajasthani',
    'rap'   => 'Rapanui',
    'rar'   => 'Rarotongan',
    'rm'    => 'rétorománčina',
    'rn'    => 'rundčina',
    'ro'    => 'rumunčina',
    'roa'   => "Romance\ Language",
    'rof'   => 'Rombo',
    'rom'   => 'Romany',
    'ru'    => 'ruština',
    'rup'   => 'Aromanian',
    'rw'    => 'rwandčina',
    'rwk'   => 'Rwa',
    'sa'    => 'sanskrit',
    'sad'   => 'Sandawe',
    'sah'   => 'Sakha',
    'sai'   => "jazyk\ juhoamerických\ indiánov",
    'sal'   => "Salishan\ Language",
    'sam'   => "Samaritan\ Aramaic",
    'saq'   => 'Samburu',
    'sas'   => 'Sasak',
    'sat'   => 'Santali',
    'sbp'   => 'Sangu',
    'sc'    => 'sardínčina',
    'scn'   => 'sicílčina',
    'sco'   => 'Scots',
    'sd'    => 'sindhčina',
    'se'    => "severná\ saamčina",
    'see'   => 'Seneca',
    'seh'   => 'Sena',
    'sel'   => 'Selkup',
    'sem'   => "Semitic\ Language",
    'ses'   => "Koyraboro\ Senni",
    'sg'    => 'sango',
    'sga'   => "Old\ Irish",
    'sgn'   => "znaková\ reč",
    'sh'    => 'srbochorvátčina',
    'shi'   => 'Tachelhit',
    'shn'   => 'Shan',
    'si'    => 'sinhalčina',
    'sid'   => 'Sidamo',
    'sio'   => "Siouan\ Language",
    'sit'   => "Sino\-Tibetan\ Language",
    'sk'    => 'slovenčina',
    'sl'    => 'slovinčina',
    'sla'   => "slovenský\ jazyk",
    'sm'    => 'samojčina',
    'sma'   => "Southern\ Sami",
    'smi'   => "Sami\ Language",
    'smj'   => "Lule\ Sami",
    'smn'   => "Inari\ Sami",
    'sms'   => "Skolt\ Sami",
    'sn'    => 'šončina',
    'snk'   => 'Soninke',
    'so'    => 'somálčina',
    'sog'   => 'Sogdien',
    'son'   => 'Songhai',
    'sq'    => 'albánčina',
    'sr'    => 'srbčina',
    'srn'   => "Sranan\ Tongo",
    'srr'   => 'Serer',
    'ss'    => 'svazijčina',
    'ssa'   => "Nilo\-Saharan\ Language",
    'ssy'   => 'Saho',
    'st'    => "južná\ sothčina",
    'su'    => 'sundčina',
    'suk'   => 'Sukuma',
    'sus'   => 'Susu',
    'sux'   => 'sumerčina',
    'sv'    => 'švédčina',
    'sw'    => 'swahilčina',
    'swb'   => 'komorčina',
    'swc'   => "Congo\ Swahili",
    'syc'   => "Classical\ Syriac",
    'syr'   => 'sýrčina',
    'ta'    => 'tamilčina',
    'tai'   => "Tai\ Language",
    'te'    => 'telugčina',
    'tem'   => 'Timne',
    'teo'   => 'Teso',
    'ter'   => 'Tereno',
    'tet'   => 'tetum',
    'tg'    => 'tadžičtina',
    'th'    => 'thajčina',
    'ti'    => 'tigrejčina',
    'tig'   => 'Tigre',
    'tiv'   => 'Tiv',
    'tk'    => 'turkménčina',
    'tkl'   => 'Tokelau',
    'tl'    => 'tagalčina',
    'tlh'   => 'klingónčina',
    'tli'   => 'Tlingit',
    'tmh'   => 'Tamashek',
    'tn'    => 'tswančina',
    'to'    => 'tonžtina',
    'tog'   => "Nyasa\ Tonga",
    'tpi'   => "tok\ pisin",
    'tr'    => 'turečtina',
    'trv'   => 'Taroko',
    'ts'    => 'tsonga',
    'tsi'   => 'Tsimshian',
    'tt'    => 'tatárčina',
    'tum'   => 'Tumbuka',
    'tup'   => "Tupi\ Language",
    'tut'   => "altajské\ jazyky",
    'tvl'   => 'Tuvalu',
    'tw'    => 'twi',
    'twq'   => 'Tasawaq',
    'ty'    => 'tahitčina',
    'tyv'   => 'Tuvinian',
    'tzm'   => "Central\ Morocco\ Tamazight",
    'udm'   => 'Udmurt',
    'ug'    => 'ujgurčina',
    'uga'   => 'Ugaritic',
    'uk'    => 'ukrajinčina',
    'umb'   => 'Umbundu',
    'und'   => "neznámy\ alebo\ neplatný\ jazyk",
    'ur'    => 'urdčina',
    'uz'    => 'uzbečtina',
    'vai'   => 'Vai',
    've'    => 'vendčina',
    'vi'    => 'vietnamčina',
    'vo'    => 'volapük',
    'vot'   => 'Votic',
    'vun'   => 'Vunjo',
    'wa'    => 'valónčina',
    'wae'   => 'Walser',
    'wak'   => "Wakashan\ Language",
    'wal'   => 'Walamo',
    'war'   => 'Waray',
    'was'   => 'Washo',
    'wen'   => "Sorbian\ Language",
    'wo'    => 'wolof',
    'xal'   => 'Kalmyk',
    'xh'    => 'xhosa',
    'xog'   => 'Soga',
    'yao'   => 'Yao',
    'yap'   => 'Yapese',
    'yav'   => 'Yangben',
    'yi'    => 'jidiš',
    'yo'    => 'jorubčina',
    'ypk'   => "Yupik\ Language",
    'yue'   => 'kantončina',
    'za'    => 'čuangčina',
    'zap'   => 'Zapotec',
    'zbl'   => 'Blissymbols',
    'zen'   => 'Zenaga',
    'zh'    => 'čínština',
    'znd'   => 'Zande',
    'zu'    => 'zuluština',
    'zun'   => 'Zuni',
    'zxx'   => "bez\ jazykového\ obsahu",
    'zza'   => 'Zaza',
);

%Locales::DB::Language::sk::name_to_code = (
    'abcházština'                   => 'ab',
    'achinese'                        => 'ace',
    'adangme'                         => 'ada',
    'adygčina'                       => 'ady',
    'afarčina'                       => 'aa',
    'afrihili'                        => 'afh',
    'afrikánčina'                   => 'af',
    'afroázijskéjazyky'             => 'afa',
    'aghem'                           => 'agq',
    'ainčina'                        => 'ain',
    'akančina'                       => 'ak',
    'akkadčina'                      => 'akk',
    'albánčina'                     => 'sq',
    'aleutčina'                      => 'ale',
    'algonkinskéjazyky'              => 'alg',
    'altajskéjazyky'                 => 'tut',
    'americkáangličtina'            => 'en_us',
    'amharčina'                      => 'am',
    'angika'                          => 'anp',
    'angličtina'                     => 'en',
    'apačskéjazyky'                 => 'apa',
    'arabčina'                       => 'ar',
    'aragónčina'                    => 'an',
    'aramaic'                         => 'arc',
    'arapaho'                         => 'arp',
    'araukánčina'                   => 'arn',
    'arawačtina'                     => 'arw',
    'arménčina'                     => 'hy',
    'aromanian'                       => 'rup',
    'astúrčina'                     => 'ast',
    'asu'                             => 'asa',
    'athabaskéjazyky'                => 'ath',
    'atsam'                           => 'cch',
    'austronézskejazyky'             => 'map',
    'austrálskaangličtina'          => 'en_au',
    'austrálskejazyky'               => 'aus',
    'avadhčina'                      => 'awa',
    'avarčina'                       => 'av',
    'avestčina'                      => 'ae',
    'aymarčina'                      => 'ay',
    'azerbajdžančina'               => 'az',
    'ačoli'                          => 'ach',
    'bafia'                           => 'ksf',
    'balijčina'                      => 'ban',
    'baltskéjazyky'                  => 'bat',
    'balúčtina'                     => 'bal',
    'bambarčina'                     => 'bm',
    'bamileke'                        => 'bai',
    'banda'                           => 'bad',
    'bantuskéjazyky'                 => 'bnt',
    'barmčina'                       => 'my',
    'basa'                            => 'bas',
    'baskirčina'                     => 'ba',
    'baskičtina'                     => 'eu',
    'batackéjazyky'                  => 'btk',
    'bedža'                          => 'bej',
    'bemba'                           => 'bem',
    'bena'                            => 'bez',
    'bengálčina'                    => 'bn',
    'berberskéjazyky'                => 'ber',
    'bezjazykovéhoobsahu'            => 'zxx',
    'bhódžpurčina'                 => 'bho',
    'bieloruština'                   => 'be',
    'bihárskejazyky'                 => 'bh',
    'bikol'                           => 'bik',
    'bini'                            => 'bin',
    'bislama'                         => 'bi',
    'blin'                            => 'byn',
    'blissymbols'                     => 'zbl',
    'bodo'                            => 'brx',
    'bokmål'                         => 'nb',
    'bosniačtina'                    => 'bs',
    'bradžčina'                     => 'bra',
    'brazílskaportugalčina'         => 'pt_br',
    'bretónčina'                    => 'br',
    'britskáangličtina'             => 'en_gb',
    'bugiština'                      => 'bug',
    'bulharčina'                     => 'bg',
    'buriatčina'                     => 'bua',
    'caddo'                           => 'cad',
    'cayuga'                          => 'cay',
    'cebuánčina'                    => 'ceb',
    'centralmoroccotamazight'         => 'tzm',
    'chiga'                           => 'cgg',
    'chorvátčina'                   => 'hr',
    'chuukese'                        => 'chk',
    'cirkevnáslovančina'            => 'cu',
    'classicalnewari'                 => 'nwc',
    'classicalsyriac'                 => 'syc',
    'colognian'                       => 'ksh',
    'congoswahili'                    => 'swc',
    'coptic'                          => 'cop',
    'creek'                           => 'mus',
    'creoleorpidgin'                  => 'crp',
    'crimeanturkish'                  => 'crh',
    'cushiticlanguage'                => 'cus',
    'dakotčina'                      => 'dak',
    'darginčina'                     => 'dar',
    'dayak'                           => 'day',
    'delawarčina'                    => 'del',
    'dinka'                           => 'din',
    'divehi'                          => 'dv',
    'dogribčina'                     => 'dgr',
    'drávidskéjazyky'               => 'dra',
    'duala'                           => 'dua',
    'dzongkä'                        => 'dz',
    'dánčina'                       => 'da',
    'dógrí'                         => 'doi',
    'efik'                            => 'efi',
    'ekadžuk'                        => 'eka',
    'elamčina'                       => 'elx',
    'embu'                            => 'ebu',
    'englishbasedcreoleorpidgin'      => 'cpe',
    'erzjančina'                     => 'myv',
    'esperanto'                       => 'eo',
    'estónčina'                     => 'et',
    'eweština'                       => 'ee',
    'ewondo'                          => 'ewo',
    'faerčina'                       => 'fo',
    'fangčina'                       => 'fan',
    'fanti'                           => 'fat',
    'fidžijčina'                    => 'fj',
    'filipínčina'                   => 'fil',
    'flámčina'                      => 'nl_be',
    'fončina'                        => 'fon',
    'francúzština'                  => 'fr',
    'frenchbasedcreoleorpidgin'       => 'cpf',
    'friulčina'                      => 'fur',
    'fulbčina'                       => 'ff',
    'fínčina'                       => 'fi',
    'ga'                              => 'gaa',
    'galícijčina'                   => 'gl',
    'gandčina'                       => 'lg',
    'gayo'                            => 'gay',
    'gbaja'                           => 'gba',
    'geez'                            => 'gez',
    'germánskejazyky'                => 'gem',
    'gilbertese'                      => 'gil',
    'gondi'                           => 'gon',
    'gorontalo'                       => 'gor',
    'grebo'                           => 'grb',
    'gruzínčina'                    => 'ka',
    'gréčtina'                      => 'el',
    'grónskaeskimáčtina'           => 'kl',
    'guaraní'                        => 'gn',
    'gudžarátčina'                 => 'gu',
    'gusii'                           => 'guz',
    "gwich\Ê\¼in"                   => 'gwi',
    'gótčina'                       => 'got',
    'haida'                           => 'hai',
    'haitský'                        => 'ht',
    'hauština'                       => 'ha',
    'havajčina'                      => 'haw',
    'hebrejčina'                     => 'he',
    'herero'                          => 'hz',
    'hiligaynon'                      => 'hil',
    'himachali'                       => 'him',
    'hindčina'                       => 'hi',
    'hirimotu'                        => 'ho',
    'hittite'                         => 'hit',
    'hmong'                           => 'hmn',
    'holandčina'                     => 'nl',
    'hupa'                            => 'hup',
    'iban'                            => 'iba',
    'iberskáportugalčina'           => 'pt_pt',
    'iberskášpanielčina'           => 'es_es',
    'ido'                             => 'io',
    'igboština'                      => 'ig',
    'ijo'                             => 'ijo',
    'iloko'                           => 'ilo',
    'inarisami'                       => 'smn',
    'indiclanguage'                   => 'inc',
    'indoeurópskejazyky'             => 'ine',
    'indonézština'                  => 'id',
    'ingush'                          => 'inh',
    'interlingua'                     => 'ia',
    'interlingue'                     => 'ie',
    'inuktitut'                       => 'iu',
    'inupiaq'                         => 'ik',
    'iroquoianlanguage'               => 'iro',
    'iránskejazyky'                  => 'ira',
    'islandčina'                     => 'is',
    'japončina'                      => 'ja',
    'jazykjuhoamerickýchindiánov'   => 'sai',
    'jazykseveroamerickýchindiánov' => 'nai',
    'jazykstredoamerickýchindiánov' => 'cai',
    'jidiš'                          => 'yi',
    'jju'                             => 'kaj',
    'jolafonyi'                       => 'dyo',
    'jorubčina'                      => 'yo',
    'judeoarabic'                     => 'jrb',
    'judeopersian'                    => 'jpr',
    'južnásothčina'                => 'st',
    'jávčina'                       => 'jv',
    'kabardian'                       => 'kbd',
    'kabuverdianu'                    => 'kea',
    'kabyle'                          => 'kab',
    'kachin'                          => 'kac',
    'kajinmajol'                      => 'mh',
    'kalenjin'                        => 'kln',
    'kalmyk'                          => 'xal',
    'kamba'                           => 'kam',
    'kambodžskákhmérčina'         => 'km',
    'kanadskáangličtina'            => 'en_ca',
    'kanadskáfrancúzština'         => 'fr_ca',
    'kannadčina'                     => 'kn',
    'kantončina'                     => 'yue',
    'kanurijčina'                    => 'kr',
    'karachaybalkar'                  => 'krc',
    'karakalpak'                      => 'kaa',
    'karelian'                        => 'krl',
    'karen'                           => 'kar',
    'karibský'                       => 'car',
    'kashubian'                       => 'csb',
    'katalánčina'                   => 'ca',
    'kaukazskéjazyky'                => 'cau',
    'kawi'                            => 'kaw',
    'kazaština'                      => 'kk',
    'kašmírčina'                   => 'ks',
    'keltskéjazyky'                  => 'cel',
    'kečuánčina'                   => 'qu',
    'khasi'                           => 'kha',
    'khoisanlanguage'                 => 'khi',
    'khotanese'                       => 'kho',
    'kikuyu'                          => 'ki',
    'kimbundu'                        => 'kmb',
    'kirgizština'                    => 'ky',
    'klingónčina'                   => 'tlh',
    'komijčina'                      => 'kv',
    'komorčina'                      => 'swb',
    'konkani'                         => 'kok',
    'konžština'                     => 'kg',
    'kornčina'                       => 'kw',
    'koro'                            => 'kfo',
    'korzičtina'                     => 'co',
    'kosraean'                        => 'kos',
    'koyraborosenni'                  => 'ses',
    'koyrachiini'                     => 'khq',
    'kpelle'                          => 'kpe',
    'kru'                             => 'kro',
    'krí'                            => 'cr',
    'kuaňama'                        => 'kj',
    'kumyk'                           => 'kum',
    'kurdčina'                       => 'ku',
    'kurukh'                          => 'kru',
    'kutenai'                         => 'kut',
    'kwasio'                          => 'nmg',
    'kórejčina'                     => 'ko',
    'ladino'                          => 'lad',
    'lahnda'                          => 'lah',
    'lamba'                           => 'lam',
    'langi'                           => 'lag',
    'laoština'                       => 'lo',
    'latinčina'                      => 'la',
    'lezghian'                        => 'lez',
    'limburgish'                      => 'li',
    'lingalčina'                     => 'ln',
    'litovčina'                      => 'lt',
    'lojban'                          => 'jbo',
    'lotyština'                      => 'lv',
    'lowersorbian'                    => 'dsb',
    'lowgerman'                       => 'nds',
    'lozi'                            => 'loz',
    'lubakatanga'                     => 'lu',
    'lubalulua'                       => 'lua',
    'luiseno'                         => 'lui',
    'lulesami'                        => 'smj',
    'lunda'                           => 'lun',
    'luo'                             => 'luo',
    'lushai'                          => 'lus',
    'luxemburčina'                   => 'lb',
    'luyia'                           => 'luy',
    'macedónčina'                   => 'mk',
    'machame'                         => 'jmc',
    'madurese'                        => 'mad',
    'magahi'                          => 'mag',
    'maithili'                        => 'mai',
    'makasar'                         => 'mak',
    'makhuwameetto'                   => 'mgh',
    'makonde'                         => 'kde',
    'malajálamčina'                 => 'ml',
    'malajčina'                      => 'ms',
    'malgaština'                     => 'mg',
    'maltčina'                       => 'mt',
    'manchu'                          => 'mnc',
    'mandar'                          => 'mdr',
    'mandingo'                        => 'man',
    'manipuri'                        => 'mni',
    'manobolanguage'                  => 'mno',
    'mančina'                        => 'gv',
    'maorijčina'                     => 'mi',
    'mari'                            => 'chm',
    'marwari'                         => 'mwr',
    'maráthčina'                    => 'mr',
    'masai'                           => 'mas',
    'mayskéjazyky'                   => 'myn',
    'maďarčina'                     => 'hu',
    'mende'                           => 'men',
    'meru'                            => 'mer',
    'micmac'                          => 'mic',
    'middledutch'                     => 'dum',
    'middleenglish'                   => 'enm',
    'middlefrench'                    => 'frm',
    'middlehighgerman'                => 'gmh',
    'middleirish'                     => 'mga',
    'minangkabau'                     => 'min',
    'mirandese'                       => 'mwl',
    'miscellaneouslanguage'           => 'mis',
    'mohawk'                          => 'moh',
    'moksha'                          => 'mdf',
    'moldavčina'                     => 'mo',
    'mongo'                           => 'lol',
    'mongolčina'                     => 'mn',
    'monkhmerlanguage'                => 'mkh',
    'morisyen'                        => 'mfe',
    'mossi'                           => 'mos',
    'multiplelanguages'               => 'mul',
    'mundalanguage'                   => 'mun',
    'mundang'                         => 'mua',
    'nahuatl'                         => 'nah',
    'nama'                            => 'naq',
    'nauru'                           => 'na',
    'navajo'                          => 'nv',
    'ndonga'                          => 'ng',
    'neapolitan'                      => 'nap',
    'nemčina'                        => 'de',
    'nepálčina'                     => 'ne',
    'newari'                          => 'new',
    'neznámyaleboneplatnýjazyk'     => 'und',
    'nias'                            => 'nia',
    'nigerkordofanianlanguage'        => 'nic',
    'nilosaharanlanguage'             => 'ssa',
    'niuean'                          => 'niu',
    'nogai'                           => 'nog',
    'northernfrisian'                 => 'frr',
    'nubianlanguage'                  => 'nub',
    'nuer'                            => 'nus',
    'nyamwezi'                        => 'nym',
    'nyankole'                        => 'nyn',
    'nyasatonga'                      => 'tog',
    'nyoro'                           => 'nyo',
    'nzima'                           => 'nzi',
    "n\â\\ko"                    => 'nqo',
    'nórskynynorsk'                  => 'nn',
    'nórčina'                       => 'no',
    'odžibva'                        => 'oj',
    'okcitánčina'                   => 'oc',
    'oldenglish'                      => 'ang',
    'oldfrench'                       => 'fro',
    'oldhighgerman'                   => 'goh',
    'oldirish'                        => 'sga',
    'oldnorse'                        => 'non',
    'oldpersian'                      => 'peo',
    "oldproven\Ã\§al"               => 'pro',
    'oromčina'                       => 'om',
    'osage'                           => 'osa',
    'osetčina'                       => 'os',
    'otomianlanguage'                 => 'oto',
    'ottomanturkish'                  => 'ota',
    'pahlavi'                         => 'pal',
    'palauan'                         => 'pau',
    'pampanga'                        => 'pam',
    'pandžábčina'                  => 'pa',
    'pangasinan'                      => 'pag',
    'papiamento'                      => 'pap',
    'papuánsky'                      => 'paa',
    'paštčina'                      => 'ps',
    'perzština'                      => 'fa',
    'philippinelanguage'              => 'phi',
    'phoenician'                      => 'phn',
    'pohnpeian'                       => 'pon',
    'portugalčina'                   => 'pt',
    'portuguesebasedcreoleorpidgin'   => 'cpp',
    'poľština'                      => 'pl',
    'prakritlanguage'                 => 'pra',
    'pálí'                          => 'pi',
    'rajasthani'                      => 'raj',
    'rakúskanemčina'                => 'de_at',
    'rapanui'                         => 'rap',
    'rarotongan'                      => 'rar',
    'romancelanguage'                 => 'roa',
    'romany'                          => 'rom',
    'rombo'                           => 'rof',
    'rumunčina'                      => 'ro',
    'rundčina'                       => 'rn',
    'ruština'                        => 'ru',
    'rwa'                             => 'rwk',
    'rwandčina'                      => 'rw',
    'rétorománčina'                => 'rm',
    'saho'                            => 'ssy',
    'sakha'                           => 'sah',
    'salishanlanguage'                => 'sal',
    'samaritanaramaic'                => 'sam',
    'samburu'                         => 'saq',
    'samilanguage'                    => 'smi',
    'samojčina'                      => 'sm',
    'sandawe'                         => 'sad',
    'sango'                           => 'sg',
    'sangu'                           => 'sbp',
    'sanskrit'                        => 'sa',
    'santali'                         => 'sat',
    'sardínčina'                    => 'sc',
    'sasak'                           => 'sas',
    'scots'                           => 'sco',
    'selkup'                          => 'sel',
    'semiticlanguage'                 => 'sem',
    'sena'                            => 'seh',
    'seneca'                          => 'see',
    'serer'                           => 'srr',
    'severnásaamčina'               => 'se',
    'severnásothčina'               => 'nso',
    'severnéndbele'                  => 'nd',
    'shambala'                        => 'ksb',
    'shan'                            => 'shn',
    'sichuanyi'                       => 'ii',
    'sicílčina'                     => 'scn',
    'sidamo'                          => 'sid',
    'siksika'                         => 'bla',
    'sindhčina'                      => 'sd',
    'sinhalčina'                     => 'si',
    'sinotibetanlanguage'             => 'sit',
    'siouanlanguage'                  => 'sio',
    'skoltsami'                       => 'sms',
    'slovančina'                     => 'den',
    'slovenskýjazyk'                 => 'sla',
    'slovenčina'                     => 'sk',
    'slovinčina'                     => 'sl',
    'soga'                            => 'xog',
    'sogdien'                         => 'sog',
    'somálčina'                     => 'so',
    'songhai'                         => 'son',
    'soninke'                         => 'snk',
    'sorbianlanguage'                 => 'wen',
    'southernaltai'                   => 'alt',
    'southernsami'                    => 'sma',
    'southndebele'                    => 'nr',
    'sranantongo'                     => 'srn',
    'srbochorvátčina'               => 'sh',
    'srbčina'                        => 'sr',
    'staroegyptský'                  => 'egy',
    'starogréčtina'                 => 'grc',
    'sukuma'                          => 'suk',
    'sumerčina'                      => 'sux',
    'sundčina'                       => 'su',
    'susu'                            => 'sus',
    'svazijčina'                     => 'ss',
    'swahilčina'                     => 'sw',
    'sýrčina'                       => 'syr',
    'tachelhit'                       => 'shi',
    'tadžičtina'                    => 'tg',
    'tagalčina'                      => 'tl',
    'tahitčina'                      => 'ty',
    'tailanguage'                     => 'tai',
    'taita'                           => 'dav',
    'taliančina'                     => 'it',
    'tamashek'                        => 'tmh',
    'tamilčina'                      => 'ta',
    'taroko'                          => 'trv',
    'tasawaq'                         => 'twq',
    'tatárčina'                     => 'tt',
    'telugčina'                      => 'te',
    'tereno'                          => 'ter',
    'teso'                            => 'teo',
    'tetum'                           => 'tet',
    'thajčina'                       => 'th',
    'tibetčina'                      => 'bo',
    'tigre'                           => 'tig',
    'tigrejčina'                     => 'ti',
    'timne'                           => 'tem',
    'tiv'                             => 'tiv',
    'tlingit'                         => 'tli',
    'tokelau'                         => 'tkl',
    'tokpisin'                        => 'tpi',
    'tonžtina'                       => 'to',
    'tsimshian'                       => 'tsi',
    'tsonga'                          => 'ts',
    'tswančina'                      => 'tn',
    'tumbuka'                         => 'tum',
    'tupilanguage'                    => 'tup',
    'turečtina'                      => 'tr',
    'turkménčina'                   => 'tk',
    'tuvalu'                          => 'tvl',
    'tuvinian'                        => 'tyv',
    'twi'                             => 'tw',
    'tyap'                            => 'kcg',
    'udmurt'                          => 'udm',
    'ugaritic'                        => 'uga',
    'ugrofínskejazyky'               => 'fiu',
    'ujgurčina'                      => 'ug',
    'ukrajinčina'                    => 'uk',
    'umbundu'                         => 'umb',
    'umelýjazyk'                     => 'art',
    'uppersorbian'                    => 'hsb',
    'urdčina'                        => 'ur',
    'uríjčina'                      => 'or',
    'uzbečtina'                      => 'uz',
    'vai'                             => 'vai',
    'valónčina'                     => 'wa',
    'vendčina'                       => 've',
    'vietnamčina'                    => 'vi',
    'volapük'                        => 'vo',
    'votic'                           => 'vot',
    'vunjo'                           => 'vun',
    'východnáfrízština'           => 'frs',
    'wakashanlanguage'                => 'wak',
    'walamo'                          => 'wal',
    'waleština'                      => 'cy',
    'walser'                          => 'wae',
    'waray'                           => 'war',
    'washo'                           => 'was',
    'wolof'                           => 'wo',
    'xhosa'                           => 'xh',
    'yangben'                         => 'yav',
    'yao'                             => 'yao',
    'yapese'                          => 'yap',
    'yupiklanguage'                   => 'ypk',
    'zande'                           => 'znd',
    'zapotec'                         => 'zap',
    'zarma'                           => 'dje',
    'zaza'                            => 'zza',
    'zenaga'                          => 'zen',
    'znakováreč'                    => 'sgn',
    'zuluština'                      => 'zu',
    'zuni'                            => 'zun',
    'západnáfrízština'            => 'fy',
    'ásámčina'                     => 'as',
    'írčina'                        => 'ga',
    'čagatajčina'                   => 'chg',
    'čamaskéjazyky'                 => 'cmc',
    'čamorčina'                     => 'ch',
    'čejenčina'                     => 'chy',
    'čerokí'                        => 'chr',
    'čewa'                           => 'ny',
    'čečenčina'                    => 'ce',
    'čeština'                       => 'cs',
    'čibča'                         => 'chb',
    'činuckýžargón'               => 'chn',
    'čipevajčina'                   => 'chp',
    'čoktavčina'                    => 'cho',
    'čuangčina'                     => 'za',
    'čuvaština'                     => 'cv',
    'čínština'                     => 'zh',
    'ďula'                           => 'dyu',
    'škótčina'                     => 'gd',
    'šončina'                       => 'sn',
    'španielčina'                   => 'es',
    'švajčiarskafrancúzština'     => 'fr_ch',
    'švajčiarskanemčina'           => 'gsw',
    'švajčiarskaspisovnánemčina'  => 'de_ch',
    'švédčina'                     => 'sv',
);

1;
