package Locales::DB::Language::se;

# Auto generated from CLDR

$Locales::DB::Language::se::VERSION = '0.07';

$Locales::DB::Language::se::cldr_version = '2.0';

%Locales::DB::Language::se::misc_info = (
    'characters'   => { 'more_information' => "\?" },
    'cldr_formats' => {
        '_decimal_format_decimal' => "\,",
        '_decimal_format_group'   => ' ',
        '_percent_format_percent' => "\%",
        'decimal'                 => "\#\,\#\#0\.\#\#\#",
        'ellipsis'                => {
            'final'   => "\{0\}…",
            'initial' => "…\{0\}",
            'medial'  => "\{0\}…\{1\}"
        },
        'language' => "giella\:\ \{0\}",
        'list'     => {
            2        => "\{0\}\ ja\ \{1\}",
            'end'    => "\{0\}\ ja\ \{1\}",
            'middle' => "\{0\}\,\ \{1\}",
            'start'  => "\{0\}\,\ \{1\}"
        },
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0 \%",
        'territory' => "Region\:\ \{0\}"
    },
    'delimiters' => {
        'alternate_quotation_end'   => '’',
        'alternate_quotation_start' => '’',
        'quotation_end'             => '”',
        'quotation_start'           => '”'
    },
    'fallback'    => [ "nb\ nn\ sv\ en" ],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'plural_forms' => {
        'category_list' => [
            'one',
            'two',
            'other'
        ],
        'category_rules' => {
            'one' => "n\ is\ 1",
            'two' => "n\ is\ 2"
        },
        'category_rules_compiled' => {
            'one' => "sub\ \{\ return\ \'one\'\ if\ \(\ \(\(\ \$_\[0\]\ \=\=\ 1\)\)\)\;\ return\;\}\;",
            'two' => "sub\ \{\ return\ \'two\'\ if\ \(\ \(\(\ \$_\[0\]\ \=\=\ 2\)\)\)\;\ return\;\}\;"
        }
    },
    'posix' => {
        'nostr' => {
            'content' => 'ii',
            'draft'   => 'unconfirmed'
        },
        'yesstr' => {
            'content' => 'jo',
            'draft'   => 'unconfirmed'
        }
    },
);

%Locales::DB::Language::se::code_to_name = (
    'aa'    => 'Afar',
    'ab'    => 'Abkhazian',
    'ace'   => 'acehgiella',
    'ach'   => 'Acoli',
    'ada'   => 'Adangme',
    'ady'   => 'Adyghe',
    'ae'    => 'Avestan',
    'af'    => 'afrikánsagiella',
    'afa'   => "Afro\-Asiatic\ Language",
    'afh'   => 'Afrihili',
    'agq'   => 'Aghem',
    'ain'   => 'Ainu',
    'ak'    => 'Akan',
    'akk'   => 'Akkadian',
    'ale'   => 'Aleut',
    'alg'   => "Algonquian\ Language",
    'alt'   => "Southern\ Altai",
    'am'    => 'Amharic',
    'an'    => 'aragoniagiella',
    'ang'   => "boares\ eaŋgalasgiella",
    'anp'   => 'Angika',
    'apa'   => "apacheš\ giella",
    'ar'    => 'arábagiella',
    'arc'   => 'Aramaic',
    'arn'   => 'Araucanian',
    'arp'   => 'Arapaho',
    'art'   => "Artificial\ Language",
    'arw'   => 'Arawak',
    'as'    => 'Assamese',
    'asa'   => 'Asu',
    'ast'   => 'asturiagiella',
    'ath'   => "Athapascan\ Language",
    'aus'   => "Australian\ Language",
    'av'    => 'Avaric',
    'awa'   => 'Awadhi',
    'ay'    => 'Aymara',
    'az'    => 'Azeri',
    'ba'    => 'Bashkir',
    'bad'   => 'Banda',
    'bai'   => "Bamileke\ Language",
    'bal'   => 'Baluchi',
    'ban'   => 'Balinese',
    'bas'   => 'Basaa',
    'bat'   => "Baltic\ Language",
    'be'    => "vilges\-ruoššagiella",
    'bej'   => 'Beja',
    'bem'   => 'Bemba',
    'ber'   => 'Berber',
    'bez'   => 'Bena',
    'bg'    => 'bulgáriagiella',
    'bh'    => 'Bihari',
    'bho'   => 'Bhojpuri',
    'bi'    => 'Bislama',
    'bik'   => 'Bikol',
    'bin'   => 'Bini',
    'bla'   => 'Siksika',
    'bm'    => 'Bambara',
    'bn'    => 'bengalgiella',
    'bnt'   => 'Bantu',
    'bo'    => 'tibetagiella',
    'br'    => 'bretonagiella',
    'bra'   => 'Braj',
    'brx'   => 'Bodo',
    'bs'    => 'bosniagiella',
    'btk'   => 'Batak',
    'bua'   => 'Buriat',
    'bug'   => 'Buginese',
    'byn'   => 'Blin',
    'ca'    => 'katalánagiella',
    'cad'   => 'Caddo',
    'cai'   => "Central\ American\ Indian\ Language",
    'car'   => 'Carib',
    'cau'   => "Caucasian\ Language",
    'cay'   => 'Cayuga',
    'cch'   => 'Atsam',
    'ce'    => 'Chechen',
    'ceb'   => 'Cebuano',
    'cel'   => "kelttalaš\ gielat",
    'cgg'   => 'Chiga',
    'ch'    => 'Chamorro',
    'chb'   => 'Chibcha',
    'chg'   => 'Chagatai',
    'chk'   => 'Chuukese',
    'chm'   => 'marigiella',
    'chn'   => "Chinook\ Jargon",
    'cho'   => 'Choctaw',
    'chp'   => 'Chipewyan',
    'chr'   => 'Cherokee',
    'chy'   => 'Cheyenne',
    'cmc'   => "Chamic\ Language",
    'co'    => 'corsicagiella',
    'cop'   => 'Coptic',
    'cpe'   => "English\-based\ Creole\ or\ Pidgin",
    'cpf'   => "French\-based\ Creole\ or\ Pidgin",
    'cpp'   => "Portuguese\-based\ Creole\ or\ Pidgin",
    'cr'    => 'Cree',
    'crh'   => "Crimean\ Turkish",
    'crp'   => "Creole\ or\ Pidgin",
    'cs'    => 'čeahkagiella',
    'csb'   => 'Kashubian',
    'cu'    => "Church\ Slavic",
    'cus'   => "Cushitic\ Language",
    'cv'    => 'Chuvash',
    'cy'    => 'kymragiella',
    'da'    => 'dánskkagiella',
    'dak'   => 'Dakota',
    'dar'   => 'Dargwa',
    'dav'   => 'Taita',
    'day'   => 'Dayak',
    'de'    => 'duiskkagiella',
    'de_at' => "Austrian\ German",
    'de_ch' => "Swiss\ High\ German",
    'del'   => 'Delaware',
    'den'   => 'Slave',
    'dgr'   => 'Dogrib',
    'din'   => 'Dinka',
    'dje'   => 'Zarma',
    'doi'   => 'Dogri',
    'dra'   => "Dravidian\ Language",
    'dsb'   => "Lower\ Sorbian",
    'dua'   => 'Duala',
    'dum'   => "Middle\ Dutch",
    'dv'    => 'divehigiella',
    'dyo'   => "Jola\-Fonyi",
    'dyu'   => 'Dyula',
    'dz'    => 'dzongkhagiella',
    'ebu'   => 'Embu',
    'ee'    => 'Ewe',
    'efi'   => 'Efik',
    'egy'   => "Ancient\ Egyptian",
    'eka'   => 'Ekajuk',
    'el'    => 'greikkagiella',
    'elx'   => 'Elamite',
    'en'    => 'eaŋgalsgiella',
    'en_au' => "Australian\ English",
    'en_ca' => "Canadian\ English",
    'en_gb' => "British\ English",
    'en_us' => "U\.S\.\ English",
    'enm'   => "Middle\ English",
    'eo'    => 'Esperanto',
    'es'    => 'spánskkagiella',
    'es_es' => "Iberian\ Spanish",
    'et'    => 'esttegiella',
    'eu'    => 'Basque',
    'ewo'   => 'Ewondo',
    'fa'    => 'persijagiella',
    'fan'   => 'Fang',
    'fat'   => 'Fanti',
    'ff'    => 'Fulah',
    'fi'    => 'suomagiella',
    'fil'   => 'filippiinnagiella',
    'fiu'   => "fenno\-ugrálaš\ giella",
    'fj'    => 'fidjigiella',
    'fo'    => 'fearagiella',
    'fon'   => 'Fon',
    'fr'    => 'fránskkagiella',
    'fr_ca' => "Canadian\ French",
    'fr_ch' => "Swiss\ French",
    'frm'   => "Middle\ French",
    'fro'   => "Old\ French",
    'frr'   => "Northern\ Frisian",
    'frs'   => "Eastern\ Frisian",
    'fur'   => 'Friulian',
    'fy'    => 'oarjifriisagiella',
    'ga'    => 'iirragiella',
    'gaa'   => 'Ga',
    'gay'   => 'Gayo',
    'gba'   => 'Gbaya',
    'gd'    => "Scottish\ Gaelic",
    'gem'   => "germánalaš\ gielat",
    'gez'   => 'Geez',
    'gil'   => 'Gilbertese',
    'gl'    => 'Galician',
    'gmh'   => "Middle\ High\ German",
    'gn'    => 'Guarani',
    'goh'   => "Old\ High\ German",
    'gon'   => 'Gondi',
    'gor'   => 'Gorontalo',
    'got'   => 'Gothic',
    'grb'   => 'Grebo',
    'grc'   => "Ancient\ Greek",
    'gsw'   => "Swiss\ German",
    'gu'    => 'gujaratagiella',
    'guz'   => 'Gusii',
    'gv'    => 'manksgiella',
    'gwi'   => "Gwich\Ê\¼in",
    'ha'    => 'haussagiella',
    'hai'   => 'Haida',
    'haw'   => 'hawaiigiella',
    'he'    => 'Hebrew',
    'hi'    => 'hindigiella',
    'hil'   => 'Hiligaynon',
    'him'   => 'Himachali',
    'hit'   => 'Hittite',
    'hmn'   => 'Hmong',
    'ho'    => "Hiri\ Motu",
    'hr'    => 'kroátiagiella',
    'hsb'   => "Upper\ Sorbian",
    'ht'    => 'haitigiella',
    'hu'    => 'ungárgiella',
    'hup'   => 'Hupa',
    'hy'    => 'armeenagiella',
    'hz'    => 'Herero',
    'ia'    => 'Interlingua',
    'iba'   => 'Iban',
    'id'    => 'indonesiagiella',
    'ie'    => 'Interlingue',
    'ig'    => 'Igbo',
    'ii'    => "Sichuan\ Yi",
    'ijo'   => 'Ijo',
    'ik'    => 'Inupiaq',
    'ilo'   => 'Iloko',
    'inc'   => "Indic\ Language",
    'ine'   => "Indo\-European\ Language",
    'inh'   => 'Ingush',
    'io'    => 'Ido',
    'ira'   => "Iranian\ Language",
    'iro'   => "Iroquoian\ Language",
    'is'    => 'islánddagiella',
    'it'    => 'itáliagiella',
    'iu'    => 'Inuktitut',
    'ja'    => 'japánagiella',
    'jbo'   => 'Lojban',
    'jmc'   => 'Machame',
    'jpr'   => "Judeo\-Persian",
    'jrb'   => "Judeo\-Arabic",
    'jv'    => 'javagiella',
    'ka'    => 'georgiagiella',
    'kaa'   => "Kara\-Kalpak",
    'kab'   => 'Kabyle',
    'kac'   => 'Kachin',
    'kaj'   => 'Jju',
    'kam'   => 'Kamba',
    'kar'   => 'Karen',
    'kaw'   => 'Kawi',
    'kbd'   => 'Kabardian',
    'kcg'   => 'Tyap',
    'kde'   => 'Makonde',
    'kea'   => 'Kabuverdianu',
    'kfo'   => 'Koro',
    'kg'    => 'Kongo',
    'kha'   => 'Khasi',
    'khi'   => "Khoisan\ Language",
    'kho'   => 'Khotanese',
    'khq'   => "Koyra\ Chiini",
    'ki'    => 'Kikuyu',
    'kj'    => 'Kuanyama',
    'kk'    => 'kazakgiella',
    'kl'    => 'Kalaallisut',
    'kln'   => 'Kalenjin',
    'km'    => 'kambodiagiella',
    'kmb'   => 'Kimbundu',
    'kn'    => 'Kannada',
    'ko'    => 'koreagiella',
    'kok'   => 'Konkani',
    'kos'   => 'Kosraean',
    'kpe'   => 'Kpelle',
    'kr'    => 'Kanuri',
    'krc'   => "Karachay\-Balkar",
    'krl'   => 'gárjilgiella',
    'kro'   => 'Kru',
    'kru'   => 'Kurukh',
    'ks'    => 'Kashmiri',
    'ksb'   => 'Shambala',
    'ksf'   => 'Bafia',
    'ksh'   => 'Colognian',
    'ku'    => 'kurdigiella',
    'kum'   => 'Kumyk',
    'kut'   => 'Kutenai',
    'kv'    => 'komigiella',
    'kw'    => 'kornagiella',
    'ky'    => 'Kirghiz',
    'la'    => 'láhtengiella',
    'lad'   => 'Ladino',
    'lag'   => 'Langi',
    'lah'   => 'Lahnda',
    'lam'   => 'Lamba',
    'lb'    => 'luxemburggagiella',
    'lez'   => 'Lezghian',
    'lg'    => 'Ganda',
    'li'    => 'Limburgish',
    'ln'    => 'Lingala',
    'lo'    => 'laogiella',
    'lol'   => 'Mongo',
    'loz'   => 'Lozi',
    'lt'    => 'liettuvagiella',
    'lu'    => "Luba\-Katanga",
    'lua'   => "Luba\-Lulua",
    'lui'   => 'Luiseno',
    'lun'   => 'Lunda',
    'luo'   => 'Luo',
    'lus'   => 'Lushai',
    'luy'   => 'Luyia',
    'lv'    => 'látviagiella',
    'mad'   => 'Madurese',
    'mag'   => 'Magahi',
    'mai'   => 'Maithili',
    'mak'   => 'Makasar',
    'man'   => 'Mandingo',
    'map'   => "Austronesian\ Language",
    'mas'   => 'Masai',
    'mdf'   => 'mokšagiella',
    'mdr'   => 'Mandar',
    'men'   => 'Mende',
    'mer'   => 'Meru',
    'mfe'   => 'Morisyen',
    'mg'    => 'Malagasy',
    'mga'   => "Middle\ Irish",
    'mgh'   => "Makhuwa\-Meetto",
    'mh'    => 'Marshallese',
    'mi'    => 'maorigiella',
    'mic'   => 'Micmac',
    'min'   => 'Minangkabau',
    'mis'   => "Miscellaneous\ Language",
    'mk'    => 'makedoniagiella',
    'mkh'   => "Mon\-Khmer\ Language",
    'ml'    => 'Malayalam',
    'mn'    => 'mongoliagiella',
    'mnc'   => 'Manchu',
    'mni'   => 'Manipuri',
    'mno'   => "Manobo\ Language",
    'mo'    => 'Moldavian',
    'moh'   => 'Mohawk',
    'mos'   => 'Mossi',
    'mr'    => 'Marathi',
    'ms'    => 'Malay',
    'mt'    => 'maltagiella',
    'mua'   => 'Mundang',
    'mul'   => "Multiple\ Languages",
    'mun'   => "Munda\ Language",
    'mus'   => 'Creek',
    'mwl'   => 'Mirandese',
    'mwr'   => 'Marwari',
    'my'    => 'burmagiella',
    'myn'   => "Mayan\ Language",
    'myv'   => 'ersagiella',
    'na'    => 'Nauru',
    'nah'   => 'Nahuatl',
    'nai'   => "North\ American\ Indian\ Language",
    'nap'   => 'Neapolitan',
    'naq'   => 'Nama',
    'nb'    => 'girjedárogiella',
    'nd'    => "North\ Ndebele",
    'nds'   => "Low\ German",
    'ne'    => 'nepaligiella',
    'new'   => 'Newari',
    'ng'    => 'Ndonga',
    'nia'   => 'Nias',
    'nic'   => "Niger\-Kordofanian\ Language",
    'niu'   => 'Niuean',
    'nl'    => 'hollánddagiella',
    'nl_be' => 'Flemish',
    'nmg'   => 'Kwasio',
    'nn'    => 'ođđadárogiella',
    'no'    => 'dárogiella',
    'nog'   => 'Nogai',
    'non'   => "Old\ Norse",
    'nqo'   => "N\â\\Ko",
    'nr'    => "South\ Ndebele",
    'nso'   => "Northern\ Sotho",
    'nub'   => "Nubian\ Language",
    'nus'   => 'Nuer',
    'nv'    => 'Navajo',
    'nwc'   => "Classical\ Newari",
    'ny'    => 'Nyanja',
    'nym'   => 'Nyamwezi',
    'nyn'   => 'Nyankole',
    'nyo'   => 'Nyoro',
    'nzi'   => 'Nzima',
    'oc'    => 'oksitánagiella',
    'oj'    => 'Ojibwa',
    'om'    => 'Oromo',
    'or'    => 'Oriya',
    'os'    => 'Ossetic',
    'osa'   => 'Osage',
    'ota'   => "Ottoman\ Turkish",
    'oto'   => "Otomian\ Language",
    'pa'    => 'panjabigiella',
    'paa'   => "Papuan\ Language",
    'pag'   => 'Pangasinan',
    'pal'   => 'Pahlavi',
    'pam'   => 'Pampanga',
    'pap'   => 'Papiamento',
    'pau'   => 'Palauan',
    'peo'   => "Old\ Persian",
    'phi'   => "Philippine\ Language",
    'phn'   => 'Phoenician',
    'pi'    => 'Pali',
    'pl'    => 'polskkagiella',
    'pon'   => 'Pohnpeian',
    'pra'   => "Prakrit\ Language",
    'pro'   => "Old\ Proven\Ã\§al",
    'ps'    => 'Pushto',
    'pt'    => 'portugálagiella',
    'pt_br' => "Brazilian\ Portuguese",
    'pt_pt' => "Iberian\ Portuguese",
    'qu'    => 'Quechua',
    'raj'   => 'Rajasthani',
    'rap'   => 'Rapanui',
    'rar'   => 'Rarotongan',
    'rm'    => 'romanšgiella',
    'rn'    => 'Rundi',
    'ro'    => 'romániagiella',
    'roa'   => "románalaš\ gielat",
    'rof'   => 'Rombo',
    'rom'   => 'Romany',
    'ru'    => 'ruoššagiella',
    'rup'   => 'Aromanian',
    'rw'    => 'Kinyarwanda',
    'rwk'   => 'Rwa',
    'sa'    => 'Sanskrit',
    'sad'   => 'Sandawe',
    'sah'   => 'Sakha',
    'sai'   => "South\ American\ Indian\ Language",
    'sal'   => "Salishan\ Language",
    'sam'   => "Samaritan\ Aramaic",
    'saq'   => 'Samburu',
    'sas'   => 'Sasak',
    'sat'   => 'Santali',
    'sbp'   => 'Sangu',
    'sc'    => 'sardigiella',
    'scn'   => 'sisiliagiella',
    'sco'   => 'Scots',
    'sd'    => 'Sindhi',
    'se'    => 'davvisámegiella',
    'see'   => 'Seneca',
    'seh'   => 'Sena',
    'sel'   => 'selkupagiella',
    'sem'   => "Semitic\ Language",
    'ses'   => "Koyraboro\ Senni",
    'sg'    => 'Sango',
    'sga'   => "Old\ Irish",
    'sgn'   => "Sign\ Language",
    'sh'    => 'serbokroatiagiella',
    'shi'   => 'Tachelhit',
    'shn'   => 'Shan',
    'si'    => 'Sinhala',
    'sid'   => 'Sidamo',
    'sio'   => "Siouan\ Language",
    'sit'   => "Sino\-Tibetan\ Language",
    'sk'    => 'slovákiagiella',
    'sl'    => 'slovenagiella',
    'sla'   => "Slavic\ Language",
    'sm'    => 'samoagiella',
    'sma'   => 'lullisámegiella',
    'smi'   => 'sámegielat',
    'smj'   => 'julevsámegiella',
    'smn'   => 'anárašgiella',
    'sms'   => 'nuortalašgiella',
    'sn'    => 'Shona',
    'snk'   => 'Soninke',
    'so'    => 'Somali',
    'sog'   => 'Sogdien',
    'son'   => 'Songhai',
    'sq'    => 'albánagiella',
    'sr'    => 'serbiagiella',
    'srn'   => "Sranan\ Tongo",
    'srr'   => 'Serer',
    'ss'    => 'Swati',
    'ssa'   => "Nilo\-Saharan\ Language",
    'ssy'   => 'Saho',
    'st'    => "Southern\ Sotho",
    'su'    => 'Sundanese',
    'suk'   => 'Sukuma',
    'sus'   => 'Susu',
    'sux'   => 'Sumerian',
    'sv'    => 'ruoŧagiella',
    'sw'    => 'Swahili',
    'swb'   => 'shimaorigiella',
    'swc'   => "Congo\ Swahili",
    'syc'   => "Classical\ Syriac",
    'syr'   => 'Syriac',
    'ta'    => 'Tamil',
    'tai'   => "Tai\ Language",
    'te'    => 'Telugu',
    'tem'   => 'Timne',
    'teo'   => 'Teso',
    'ter'   => 'Tereno',
    'tet'   => 'Tetum',
    'tg'    => 'Tajik',
    'th'    => 'ŧaigiella',
    'ti'    => 'Tigrinya',
    'tig'   => 'Tigre',
    'tiv'   => 'Tiv',
    'tk'    => 'Turkmen',
    'tkl'   => 'Tokelau',
    'tl'    => 'Tagalog',
    'tlh'   => 'Klingon',
    'tli'   => 'Tlingit',
    'tmh'   => 'Tamashek',
    'tn'    => 'Tswana',
    'to'    => 'Tonga',
    'tog'   => "Nyasa\ Tonga",
    'tpi'   => "Tok\ Pisin",
    'tr'    => 'durkagiella',
    'trv'   => 'Taroko',
    'ts'    => 'Tsonga',
    'tsi'   => 'Tsimshian',
    'tt'    => 'Tatar',
    'tum'   => 'Tumbuka',
    'tup'   => "Tupi\ Language",
    'tut'   => "Altaic\ Language",
    'tvl'   => 'Tuvalu',
    'tw'    => 'Twi',
    'twq'   => 'Tasawaq',
    'ty'    => 'tahitigiella',
    'tyv'   => 'Tuvinian',
    'tzm'   => "Central\ Morocco\ Tamazight",
    'udm'   => 'udmurtagiella',
    'ug'    => 'Uyghur',
    'uga'   => 'Ugaritic',
    'uk'    => 'ukrainagiella',
    'umb'   => 'Umbundu',
    'und'   => "Unknown\ Language",
    'ur'    => 'urdugiella',
    'uz'    => 'Uzbek',
    'vai'   => 'Vai',
    've'    => 'Venda',
    'vi'    => 'vietnamgiella',
    'vo'    => "Volap\Ã\¼k",
    'vot'   => 'Votic',
    'vun'   => 'Vunjo',
    'wa'    => 'vallonagiella',
    'wae'   => 'Walser',
    'wak'   => "Wakashan\ Language",
    'wal'   => 'Walamo',
    'war'   => 'Waray',
    'was'   => 'Washo',
    'wen'   => "sorbi\ gielat",
    'wo'    => 'Wolof',
    'xal'   => 'Kalmyk',
    'xh'    => 'Xhosa',
    'xog'   => 'Soga',
    'yao'   => 'Yao',
    'yap'   => 'Yapese',
    'yav'   => 'Yangben',
    'yi'    => 'Yiddish',
    'yo'    => 'Yoruba',
    'ypk'   => "Yupik\ Language",
    'yue'   => 'kantongiella',
    'za'    => 'Zhuang',
    'zap'   => 'Zapotec',
    'zbl'   => 'Blissymbols',
    'zen'   => 'Zenaga',
    'zh'    => 'kiinnágiella',
    'znd'   => 'Zande',
    'zu'    => 'Zulu',
    'zun'   => 'Zuni',
    'zxx'   => "No\ linguistic\ content",
    'zza'   => 'Zaza',
);

%Locales::DB::Language::se::name_to_code = (
    'abkhazian'                     => 'ab',
    'acehgiella'                    => 'ace',
    'acoli'                         => 'ach',
    'adangme'                       => 'ada',
    'adyghe'                        => 'ady',
    'afar'                          => 'aa',
    'afrihili'                      => 'afh',
    'afrikánsagiella'              => 'af',
    'afroasiaticlanguage'           => 'afa',
    'aghem'                         => 'agq',
    'ainu'                          => 'ain',
    'akan'                          => 'ak',
    'akkadian'                      => 'akk',
    'albánagiella'                 => 'sq',
    'aleut'                         => 'ale',
    'algonquianlanguage'            => 'alg',
    'altaiclanguage'                => 'tut',
    'amharic'                       => 'am',
    'ancientegyptian'               => 'egy',
    'ancientgreek'                  => 'grc',
    'angika'                        => 'anp',
    'anárašgiella'                => 'smn',
    'apachešgiella'                => 'apa',
    'aragoniagiella'                => 'an',
    'aramaic'                       => 'arc',
    'arapaho'                       => 'arp',
    'araucanian'                    => 'arn',
    'arawak'                        => 'arw',
    'armeenagiella'                 => 'hy',
    'aromanian'                     => 'rup',
    'artificiallanguage'            => 'art',
    'arábagiella'                  => 'ar',
    'assamese'                      => 'as',
    'asturiagiella'                 => 'ast',
    'asu'                           => 'asa',
    'athapascanlanguage'            => 'ath',
    'atsam'                         => 'cch',
    'australianenglish'             => 'en_au',
    'australianlanguage'            => 'aus',
    'austriangerman'                => 'de_at',
    'austronesianlanguage'          => 'map',
    'avaric'                        => 'av',
    'avestan'                       => 'ae',
    'awadhi'                        => 'awa',
    'aymara'                        => 'ay',
    'azeri'                         => 'az',
    'bafia'                         => 'ksf',
    'balinese'                      => 'ban',
    'balticlanguage'                => 'bat',
    'baluchi'                       => 'bal',
    'bambara'                       => 'bm',
    'bamilekelanguage'              => 'bai',
    'banda'                         => 'bad',
    'bantu'                         => 'bnt',
    'basaa'                         => 'bas',
    'bashkir'                       => 'ba',
    'basque'                        => 'eu',
    'batak'                         => 'btk',
    'beja'                          => 'bej',
    'bemba'                         => 'bem',
    'bena'                          => 'bez',
    'bengalgiella'                  => 'bn',
    'berber'                        => 'ber',
    'bhojpuri'                      => 'bho',
    'bihari'                        => 'bh',
    'bikol'                         => 'bik',
    'bini'                          => 'bin',
    'bislama'                       => 'bi',
    'blin'                          => 'byn',
    'blissymbols'                   => 'zbl',
    'boareseaŋgalasgiella'         => 'ang',
    'bodo'                          => 'brx',
    'bosniagiella'                  => 'bs',
    'braj'                          => 'bra',
    'brazilianportuguese'           => 'pt_br',
    'bretonagiella'                 => 'br',
    'britishenglish'                => 'en_gb',
    'buginese'                      => 'bug',
    'bulgáriagiella'               => 'bg',
    'buriat'                        => 'bua',
    'burmagiella'                   => 'my',
    'caddo'                         => 'cad',
    'canadianenglish'               => 'en_ca',
    'canadianfrench'                => 'fr_ca',
    'carib'                         => 'car',
    'caucasianlanguage'             => 'cau',
    'cayuga'                        => 'cay',
    'cebuano'                       => 'ceb',
    'centralamericanindianlanguage' => 'cai',
    'centralmoroccotamazight'       => 'tzm',
    'chagatai'                      => 'chg',
    'chamiclanguage'                => 'cmc',
    'chamorro'                      => 'ch',
    'chechen'                       => 'ce',
    'cherokee'                      => 'chr',
    'cheyenne'                      => 'chy',
    'chibcha'                       => 'chb',
    'chiga'                         => 'cgg',
    'chinookjargon'                 => 'chn',
    'chipewyan'                     => 'chp',
    'choctaw'                       => 'cho',
    'churchslavic'                  => 'cu',
    'chuukese'                      => 'chk',
    'chuvash'                       => 'cv',
    'classicalnewari'               => 'nwc',
    'classicalsyriac'               => 'syc',
    'colognian'                     => 'ksh',
    'congoswahili'                  => 'swc',
    'coptic'                        => 'cop',
    'corsicagiella'                 => 'co',
    'cree'                          => 'cr',
    'creek'                         => 'mus',
    'creoleorpidgin'                => 'crp',
    'crimeanturkish'                => 'crh',
    'cushiticlanguage'              => 'cus',
    'dakota'                        => 'dak',
    'dargwa'                        => 'dar',
    'davvisámegiella'              => 'se',
    'dayak'                         => 'day',
    'delaware'                      => 'del',
    'dinka'                         => 'din',
    'divehigiella'                  => 'dv',
    'dogri'                         => 'doi',
    'dogrib'                        => 'dgr',
    'dravidianlanguage'             => 'dra',
    'duala'                         => 'dua',
    'duiskkagiella'                 => 'de',
    'durkagiella'                   => 'tr',
    'dyula'                         => 'dyu',
    'dzongkhagiella'                => 'dz',
    'dánskkagiella'                => 'da',
    'dárogiella'                   => 'no',
    'easternfrisian'                => 'frs',
    'eaŋgalsgiella'                => 'en',
    'efik'                          => 'efi',
    'ekajuk'                        => 'eka',
    'elamite'                       => 'elx',
    'embu'                          => 'ebu',
    'englishbasedcreoleorpidgin'    => 'cpe',
    'ersagiella'                    => 'myv',
    'esperanto'                     => 'eo',
    'esttegiella'                   => 'et',
    'ewe'                           => 'ee',
    'ewondo'                        => 'ewo',
    'fang'                          => 'fan',
    'fanti'                         => 'fat',
    'fearagiella'                   => 'fo',
    'fennougrálašgiella'          => 'fiu',
    'fidjigiella'                   => 'fj',
    'filippiinnagiella'             => 'fil',
    'flemish'                       => 'nl_be',
    'fon'                           => 'fon',
    'frenchbasedcreoleorpidgin'     => 'cpf',
    'friulian'                      => 'fur',
    'fránskkagiella'               => 'fr',
    'fulah'                         => 'ff',
    'ga'                            => 'gaa',
    'galician'                      => 'gl',
    'ganda'                         => 'lg',
    'gayo'                          => 'gay',
    'gbaya'                         => 'gba',
    'geez'                          => 'gez',
    'georgiagiella'                 => 'ka',
    'germánalašgielat'            => 'gem',
    'gilbertese'                    => 'gil',
    'girjedárogiella'              => 'nb',
    'gondi'                         => 'gon',
    'gorontalo'                     => 'gor',
    'gothic'                        => 'got',
    'grebo'                         => 'grb',
    'greikkagiella'                 => 'el',
    'guarani'                       => 'gn',
    'gujaratagiella'                => 'gu',
    'gusii'                         => 'guz',
    "gwich\Ê\¼in"                 => 'gwi',
    'gárjilgiella'                 => 'krl',
    'haida'                         => 'hai',
    'haitigiella'                   => 'ht',
    'haussagiella'                  => 'ha',
    'hawaiigiella'                  => 'haw',
    'hebrew'                        => 'he',
    'herero'                        => 'hz',
    'hiligaynon'                    => 'hil',
    'himachali'                     => 'him',
    'hindigiella'                   => 'hi',
    'hirimotu'                      => 'ho',
    'hittite'                       => 'hit',
    'hmong'                         => 'hmn',
    'hollánddagiella'              => 'nl',
    'hupa'                          => 'hup',
    'iban'                          => 'iba',
    'iberianportuguese'             => 'pt_pt',
    'iberianspanish'                => 'es_es',
    'ido'                           => 'io',
    'igbo'                          => 'ig',
    'iirragiella'                   => 'ga',
    'ijo'                           => 'ijo',
    'iloko'                         => 'ilo',
    'indiclanguage'                 => 'inc',
    'indoeuropeanlanguage'          => 'ine',
    'indonesiagiella'               => 'id',
    'ingush'                        => 'inh',
    'interlingua'                   => 'ia',
    'interlingue'                   => 'ie',
    'inuktitut'                     => 'iu',
    'inupiaq'                       => 'ik',
    'iranianlanguage'               => 'ira',
    'iroquoianlanguage'             => 'iro',
    'islánddagiella'               => 'is',
    'itáliagiella'                 => 'it',
    'japánagiella'                 => 'ja',
    'javagiella'                    => 'jv',
    'jju'                           => 'kaj',
    'jolafonyi'                     => 'dyo',
    'judeoarabic'                   => 'jrb',
    'judeopersian'                  => 'jpr',
    'julevsámegiella'              => 'smj',
    'kabardian'                     => 'kbd',
    'kabuverdianu'                  => 'kea',
    'kabyle'                        => 'kab',
    'kachin'                        => 'kac',
    'kalaallisut'                   => 'kl',
    'kalenjin'                      => 'kln',
    'kalmyk'                        => 'xal',
    'kamba'                         => 'kam',
    'kambodiagiella'                => 'km',
    'kannada'                       => 'kn',
    'kantongiella'                  => 'yue',
    'kanuri'                        => 'kr',
    'karachaybalkar'                => 'krc',
    'karakalpak'                    => 'kaa',
    'karen'                         => 'kar',
    'kashmiri'                      => 'ks',
    'kashubian'                     => 'csb',
    'katalánagiella'               => 'ca',
    'kawi'                          => 'kaw',
    'kazakgiella'                   => 'kk',
    'kelttalašgielat'              => 'cel',
    'khasi'                         => 'kha',
    'khoisanlanguage'               => 'khi',
    'khotanese'                     => 'kho',
    'kiinnágiella'                 => 'zh',
    'kikuyu'                        => 'ki',
    'kimbundu'                      => 'kmb',
    'kinyarwanda'                   => 'rw',
    'kirghiz'                       => 'ky',
    'klingon'                       => 'tlh',
    'komigiella'                    => 'kv',
    'kongo'                         => 'kg',
    'konkani'                       => 'kok',
    'koreagiella'                   => 'ko',
    'kornagiella'                   => 'kw',
    'koro'                          => 'kfo',
    'kosraean'                      => 'kos',
    'koyraborosenni'                => 'ses',
    'koyrachiini'                   => 'khq',
    'kpelle'                        => 'kpe',
    'kroátiagiella'                => 'hr',
    'kru'                           => 'kro',
    'kuanyama'                      => 'kj',
    'kumyk'                         => 'kum',
    'kurdigiella'                   => 'ku',
    'kurukh'                        => 'kru',
    'kutenai'                       => 'kut',
    'kwasio'                        => 'nmg',
    'kymragiella'                   => 'cy',
    'ladino'                        => 'lad',
    'lahnda'                        => 'lah',
    'lamba'                         => 'lam',
    'langi'                         => 'lag',
    'laogiella'                     => 'lo',
    'lezghian'                      => 'lez',
    'liettuvagiella'                => 'lt',
    'limburgish'                    => 'li',
    'lingala'                       => 'ln',
    'lojban'                        => 'jbo',
    'lowersorbian'                  => 'dsb',
    'lowgerman'                     => 'nds',
    'lozi'                          => 'loz',
    'lubakatanga'                   => 'lu',
    'lubalulua'                     => 'lua',
    'luiseno'                       => 'lui',
    'lullisámegiella'              => 'sma',
    'lunda'                         => 'lun',
    'luo'                           => 'luo',
    'lushai'                        => 'lus',
    'luxemburggagiella'             => 'lb',
    'luyia'                         => 'luy',
    'láhtengiella'                 => 'la',
    'látviagiella'                 => 'lv',
    'machame'                       => 'jmc',
    'madurese'                      => 'mad',
    'magahi'                        => 'mag',
    'maithili'                      => 'mai',
    'makasar'                       => 'mak',
    'makedoniagiella'               => 'mk',
    'makhuwameetto'                 => 'mgh',
    'makonde'                       => 'kde',
    'malagasy'                      => 'mg',
    'malay'                         => 'ms',
    'malayalam'                     => 'ml',
    'maltagiella'                   => 'mt',
    'manchu'                        => 'mnc',
    'mandar'                        => 'mdr',
    'mandingo'                      => 'man',
    'manipuri'                      => 'mni',
    'manksgiella'                   => 'gv',
    'manobolanguage'                => 'mno',
    'maorigiella'                   => 'mi',
    'marathi'                       => 'mr',
    'marigiella'                    => 'chm',
    'marshallese'                   => 'mh',
    'marwari'                       => 'mwr',
    'masai'                         => 'mas',
    'mayanlanguage'                 => 'myn',
    'mende'                         => 'men',
    'meru'                          => 'mer',
    'micmac'                        => 'mic',
    'middledutch'                   => 'dum',
    'middleenglish'                 => 'enm',
    'middlefrench'                  => 'frm',
    'middlehighgerman'              => 'gmh',
    'middleirish'                   => 'mga',
    'minangkabau'                   => 'min',
    'mirandese'                     => 'mwl',
    'miscellaneouslanguage'         => 'mis',
    'mohawk'                        => 'moh',
    'mokšagiella'                  => 'mdf',
    'moldavian'                     => 'mo',
    'mongo'                         => 'lol',
    'mongoliagiella'                => 'mn',
    'monkhmerlanguage'              => 'mkh',
    'morisyen'                      => 'mfe',
    'mossi'                         => 'mos',
    'multiplelanguages'             => 'mul',
    'mundalanguage'                 => 'mun',
    'mundang'                       => 'mua',
    'nahuatl'                       => 'nah',
    'nama'                          => 'naq',
    'nauru'                         => 'na',
    'navajo'                        => 'nv',
    'ndonga'                        => 'ng',
    'neapolitan'                    => 'nap',
    'nepaligiella'                  => 'ne',
    'newari'                        => 'new',
    'nias'                          => 'nia',
    'nigerkordofanianlanguage'      => 'nic',
    'nilosaharanlanguage'           => 'ssa',
    'niuean'                        => 'niu',
    'nogai'                         => 'nog',
    'nolinguisticcontent'           => 'zxx',
    'northamericanindianlanguage'   => 'nai',
    'northernfrisian'               => 'frr',
    'northernsotho'                 => 'nso',
    'northndebele'                  => 'nd',
    'nubianlanguage'                => 'nub',
    'nuer'                          => 'nus',
    'nuortalašgiella'              => 'sms',
    'nyamwezi'                      => 'nym',
    'nyanja'                        => 'ny',
    'nyankole'                      => 'nyn',
    'nyasatonga'                    => 'tog',
    'nyoro'                         => 'nyo',
    'nzima'                         => 'nzi',
    "n\â\\ko"                  => 'nqo',
    'oarjifriisagiella'             => 'fy',
    'ojibwa'                        => 'oj',
    'oksitánagiella'               => 'oc',
    'oldfrench'                     => 'fro',
    'oldhighgerman'                 => 'goh',
    'oldirish'                      => 'sga',
    'oldnorse'                      => 'non',
    'oldpersian'                    => 'peo',
    "oldproven\Ã\§al"             => 'pro',
    'oriya'                         => 'or',
    'oromo'                         => 'om',
    'osage'                         => 'osa',
    'ossetic'                       => 'os',
    'otomianlanguage'               => 'oto',
    'ottomanturkish'                => 'ota',
    'ođđadárogiella'             => 'nn',
    'pahlavi'                       => 'pal',
    'palauan'                       => 'pau',
    'pali'                          => 'pi',
    'pampanga'                      => 'pam',
    'pangasinan'                    => 'pag',
    'panjabigiella'                 => 'pa',
    'papiamento'                    => 'pap',
    'papuanlanguage'                => 'paa',
    'persijagiella'                 => 'fa',
    'philippinelanguage'            => 'phi',
    'phoenician'                    => 'phn',
    'pohnpeian'                     => 'pon',
    'polskkagiella'                 => 'pl',
    'portuguesebasedcreoleorpidgin' => 'cpp',
    'portugálagiella'              => 'pt',
    'prakritlanguage'               => 'pra',
    'pushto'                        => 'ps',
    'quechua'                       => 'qu',
    'rajasthani'                    => 'raj',
    'rapanui'                       => 'rap',
    'rarotongan'                    => 'rar',
    'romany'                        => 'rom',
    'romanšgiella'                 => 'rm',
    'rombo'                         => 'rof',
    'románalašgielat'             => 'roa',
    'romániagiella'                => 'ro',
    'rundi'                         => 'rn',
    'ruoššagiella'                => 'ru',
    'ruoŧagiella'                  => 'sv',
    'rwa'                           => 'rwk',
    'saho'                          => 'ssy',
    'sakha'                         => 'sah',
    'salishanlanguage'              => 'sal',
    'samaritanaramaic'              => 'sam',
    'samburu'                       => 'saq',
    'samoagiella'                   => 'sm',
    'sandawe'                       => 'sad',
    'sango'                         => 'sg',
    'sangu'                         => 'sbp',
    'sanskrit'                      => 'sa',
    'santali'                       => 'sat',
    'sardigiella'                   => 'sc',
    'sasak'                         => 'sas',
    'scots'                         => 'sco',
    'scottishgaelic'                => 'gd',
    'selkupagiella'                 => 'sel',
    'semiticlanguage'               => 'sem',
    'sena'                          => 'seh',
    'seneca'                        => 'see',
    'serbiagiella'                  => 'sr',
    'serbokroatiagiella'            => 'sh',
    'serer'                         => 'srr',
    'shambala'                      => 'ksb',
    'shan'                          => 'shn',
    'shimaorigiella'                => 'swb',
    'shona'                         => 'sn',
    'sichuanyi'                     => 'ii',
    'sidamo'                        => 'sid',
    'signlanguage'                  => 'sgn',
    'siksika'                       => 'bla',
    'sindhi'                        => 'sd',
    'sinhala'                       => 'si',
    'sinotibetanlanguage'           => 'sit',
    'siouanlanguage'                => 'sio',
    'sisiliagiella'                 => 'scn',
    'slave'                         => 'den',
    'slaviclanguage'                => 'sla',
    'slovenagiella'                 => 'sl',
    'slovákiagiella'               => 'sk',
    'soga'                          => 'xog',
    'sogdien'                       => 'sog',
    'somali'                        => 'so',
    'songhai'                       => 'son',
    'soninke'                       => 'snk',
    'sorbigielat'                   => 'wen',
    'southamericanindianlanguage'   => 'sai',
    'southernaltai'                 => 'alt',
    'southernsotho'                 => 'st',
    'southndebele'                  => 'nr',
    'spánskkagiella'               => 'es',
    'sranantongo'                   => 'srn',
    'sukuma'                        => 'suk',
    'sumerian'                      => 'sux',
    'sundanese'                     => 'su',
    'suomagiella'                   => 'fi',
    'susu'                          => 'sus',
    'swahili'                       => 'sw',
    'swati'                         => 'ss',
    'swissfrench'                   => 'fr_ch',
    'swissgerman'                   => 'gsw',
    'swisshighgerman'               => 'de_ch',
    'syriac'                        => 'syr',
    'sámegielat'                   => 'smi',
    'tachelhit'                     => 'shi',
    'tagalog'                       => 'tl',
    'tahitigiella'                  => 'ty',
    'tailanguage'                   => 'tai',
    'taita'                         => 'dav',
    'tajik'                         => 'tg',
    'tamashek'                      => 'tmh',
    'tamil'                         => 'ta',
    'taroko'                        => 'trv',
    'tasawaq'                       => 'twq',
    'tatar'                         => 'tt',
    'telugu'                        => 'te',
    'tereno'                        => 'ter',
    'teso'                          => 'teo',
    'tetum'                         => 'tet',
    'tibetagiella'                  => 'bo',
    'tigre'                         => 'tig',
    'tigrinya'                      => 'ti',
    'timne'                         => 'tem',
    'tiv'                           => 'tiv',
    'tlingit'                       => 'tli',
    'tokelau'                       => 'tkl',
    'tokpisin'                      => 'tpi',
    'tonga'                         => 'to',
    'tsimshian'                     => 'tsi',
    'tsonga'                        => 'ts',
    'tswana'                        => 'tn',
    'tumbuka'                       => 'tum',
    'tupilanguage'                  => 'tup',
    'turkmen'                       => 'tk',
    'tuvalu'                        => 'tvl',
    'tuvinian'                      => 'tyv',
    'twi'                           => 'tw',
    'tyap'                          => 'kcg',
    "u\.s\.english"                 => 'en_us',
    'udmurtagiella'                 => 'udm',
    'ugaritic'                      => 'uga',
    'ukrainagiella'                 => 'uk',
    'umbundu'                       => 'umb',
    'ungárgiella'                  => 'hu',
    'unknownlanguage'               => 'und',
    'uppersorbian'                  => 'hsb',
    'urdugiella'                    => 'ur',
    'uyghur'                        => 'ug',
    'uzbek'                         => 'uz',
    'vai'                           => 'vai',
    'vallonagiella'                 => 'wa',
    'venda'                         => 've',
    'vietnamgiella'                 => 'vi',
    'vilgesruoššagiella'          => 'be',
    "volap\Ã\¼k"                  => 'vo',
    'votic'                         => 'vot',
    'vunjo'                         => 'vun',
    'wakashanlanguage'              => 'wak',
    'walamo'                        => 'wal',
    'walser'                        => 'wae',
    'waray'                         => 'war',
    'washo'                         => 'was',
    'wolof'                         => 'wo',
    'xhosa'                         => 'xh',
    'yangben'                       => 'yav',
    'yao'                           => 'yao',
    'yapese'                        => 'yap',
    'yiddish'                       => 'yi',
    'yoruba'                        => 'yo',
    'yupiklanguage'                 => 'ypk',
    'zande'                         => 'znd',
    'zapotec'                       => 'zap',
    'zarma'                         => 'dje',
    'zaza'                          => 'zza',
    'zenaga'                        => 'zen',
    'zhuang'                        => 'za',
    'zulu'                          => 'zu',
    'zuni'                          => 'zun',
    'čeahkagiella'                 => 'cs',
    'ŧaigiella'                    => 'th',
);

1;
