package Locales::DB::Language::gl;

# Auto generated from CLDR

$Locales::DB::Language::gl::VERSION = '0.06';

$Locales::DB::Language::gl::cldr_version = '1.7.2';

%Locales::DB::Language::gl::misc_info = (
    'cldr_formats' => {
        '_decimal_format_decimal' => "\,",
        '_decimal_format_group'   => "\.",
        '_percent_format_percent' => "\%",
        'decimal'                 => "\#\,\#\#0\.\#\#\#",
        'language'                => "Idioma\:\ \{0\}",
        'locale'                  => {
            'content' => "\{0\}\ \(\{1\}\)",
            'draft'   => 'contributed'
        },
        'percent'   => "\#\,\#\#0\%",
        'territory' => "Rexión\:\ \{0\}"
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'posix' => {
        'nostr' => {
            'content' => "non\:n",
            'draft'   => 'contributed'
        },
        'yesstr' => {
            'content' => "si\:s",
            'draft'   => 'contributed'
        }
    },
);

%Locales::DB::Language::gl::code_to_name = (
    'aa'    => 'Afar',
    'ab'    => 'Abkhazian',
    'ace'   => 'Achinese',
    'ach'   => 'Acoli',
    'ada'   => 'Adangme',
    'ady'   => 'Adyghe',
    'ae'    => 'Avestan',
    'af'    => 'Afrikaans',
    'afa'   => "Lingua\ afro\-asiática",
    'afh'   => 'Afrihili',
    'ain'   => 'Ainu',
    'ak'    => 'Akan',
    'akk'   => 'Akkadian',
    'ale'   => 'Aleut',
    'alg'   => "Lingua\ algonquina",
    'alt'   => "Southern\ Altai",
    'am'    => 'Amárico',
    'an'    => 'Aragonés',
    'ang'   => "Old\ English",
    'anp'   => 'Angika',
    'apa'   => "Lingua\ apache",
    'ar'    => 'Árabe',
    'arc'   => 'Arameo',
    'arn'   => 'Araucanian',
    'arp'   => 'Arapaho',
    'art'   => "Lingua\ artificial",
    'arw'   => 'Arawak',
    'as'    => 'Assamés',
    'ast'   => 'Asturiano',
    'ath'   => "Athapascan\ Language",
    'aus'   => "Lingua\ australiana",
    'av'    => 'Avaric',
    'awa'   => 'Awadhi',
    'ay'    => 'Aymara',
    'az'    => 'Azerbaiano',
    'ba'    => 'Bashkir',
    'bad'   => 'Banda',
    'bai'   => "Bamileke\ Language",
    'bal'   => 'Baluchi',
    'ban'   => 'Balinese',
    'bas'   => 'Basa',
    'bat'   => "Lingua\ báltica",
    'be'    => 'Bielorruso',
    'bej'   => 'Beja',
    'bem'   => 'Bemba',
    'ber'   => 'Berber',
    'bg'    => 'Búlgaro',
    'bh'    => 'Bihariano',
    'bho'   => 'Bhojpuri',
    'bi'    => 'Bislama',
    'bik'   => 'Bikol',
    'bin'   => 'Bini',
    'bla'   => 'Siksika',
    'bm'    => 'Bambara',
    'bn'    => 'Bengalí',
    'bnt'   => 'Bantu',
    'bo'    => 'Tibetan',
    'br'    => 'Bretón',
    'bra'   => 'Braj',
    'bs'    => 'Bosnio',
    'btk'   => 'Batak',
    'bua'   => 'Buriat',
    'bug'   => 'Buginese',
    'byn'   => 'Blin',
    'ca'    => 'Catalán',
    'cad'   => 'Caddo',
    'cai'   => "Lingua\ india\ centroamericana",
    'car'   => 'Carib',
    'cau'   => "Lingua\ caucásica",
    'cch'   => 'Atsam',
    'ce'    => 'Chechen',
    'ceb'   => 'Cebuano',
    'cel'   => "Lingua\ céltica",
    'ch'    => 'Chamorro',
    'chb'   => 'Chibcha',
    'chg'   => 'Chagatai',
    'chk'   => 'Chuukese',
    'chm'   => 'Mari',
    'chn'   => "Chinook\ Jargon",
    'cho'   => 'Choctaw',
    'chp'   => 'Chipewyan',
    'chr'   => 'Cherokee',
    'chy'   => 'Cheyenne',
    'cmc'   => "Chamic\ Language",
    'co'    => 'Corsican',
    'cop'   => 'Coptic',
    'cpe'   => "English\-based\ Creole\ or\ Pidgin",
    'cpf'   => "French\-based\ Creole\ or\ Pidgin",
    'cpp'   => "Portuguese\-based\ Creole\ or\ Pidgin",
    'cr'    => 'Cree',
    'crh'   => "Crimean\ Turkish",
    'crp'   => "Creole\ or\ Pidgin",
    'cs'    => 'Checo',
    'csb'   => 'Kashubian',
    'cu'    => "Eslavo\ eclesiástico",
    'cus'   => "Cushitic\ Language",
    'cv'    => 'Chuvash',
    'cy'    => 'Galés',
    'da'    => 'Dinamarqués',
    'dak'   => 'Dakota',
    'dar'   => 'Dargwa',
    'day'   => 'Dayak',
    'de'    => 'Alemán',
    'de_at' => "Alemán\ de\ Austria",
    'de_ch' => "Alemán\ suízo",
    'del'   => 'Delaware',
    'den'   => 'Slave',
    'dgr'   => 'Dogrib',
    'din'   => 'Dinka',
    'doi'   => 'Dogri',
    'dra'   => "Dravidian\ Language",
    'dsb'   => "Lower\ Sorbian",
    'dua'   => 'Duala',
    'dum'   => "Middle\ Dutch",
    'dv'    => 'Divehi',
    'dyu'   => 'Dyula',
    'dz'    => 'Dzongkha',
    'ee'    => 'Ewe',
    'efi'   => 'Efik',
    'egy'   => "Exipcio\ antigo",
    'eka'   => 'Ekajuk',
    'el'    => 'Grego',
    'elx'   => 'Elamite',
    'en'    => 'Inglés',
    'en_au' => "Inglés\ australiano",
    'en_ca' => "Inglés\ canadiano",
    'en_gb' => "Inglés\ británico",
    'en_us' => "Inglés\ americano",
    'enm'   => "Middle\ English",
    'eo'    => 'Esperanto',
    'es'    => 'Español',
    'es_es' => 'Castelán',
    'et'    => 'Estoniano',
    'eu'    => 'Éuscaro',
    'ewo'   => 'Ewondo',
    'fa'    => 'Persa',
    'fan'   => 'Fang',
    'fat'   => 'Fanti',
    'ff'    => 'Fulah',
    'fi'    => 'Finés',
    'fil'   => 'Filipino',
    'fiu'   => "Lingua\ finno\-úgrica",
    'fj'    => 'Fijian',
    'fo'    => 'Faroés',
    'fon'   => 'Fon',
    'fr'    => 'Francés',
    'fr_ca' => "Francés\ canadiano",
    'fr_ch' => "Francés\ suízo",
    'frm'   => "Middle\ French",
    'fro'   => "Old\ French",
    'frr'   => "Northern\ Frisian",
    'frs'   => "Eastern\ Frisian",
    'fur'   => 'Friulian',
    'fy'    => 'Frisón',
    'ga'    => 'Irlandés',
    'gaa'   => 'Ga',
    'gay'   => 'Gayo',
    'gba'   => 'Gbaya',
    'gd'    => "Gaélico\ escocés",
    'gem'   => "Lingua\ xermánica",
    'gez'   => 'Geez',
    'gil'   => 'Gilbertese',
    'gl'    => 'galego',
    'gmh'   => "Middle\ High\ German",
    'gn'    => 'Guaraní',
    'goh'   => "Old\ High\ German",
    'gon'   => 'Gondi',
    'gor'   => 'Gorontalo',
    'got'   => 'Gothic',
    'grb'   => 'Grebo',
    'grc'   => "Grego\ antigo",
    'gsw'   => "Swiss\ German",
    'gu'    => 'Guxaratiano',
    'gv'    => 'Manx',
    'gwi'   => "Gwich\Ê\¼in",
    'ha'    => 'Hausa',
    'hai'   => 'Haida',
    'haw'   => 'Hawaiian',
    'he'    => 'Hebreo',
    'hi'    => 'Hindi',
    'hil'   => 'Hiligaynon',
    'him'   => 'Himachali',
    'hit'   => 'Hittite',
    'hmn'   => 'Hmong',
    'ho'    => "Hiri\ Motu",
    'hr'    => 'Croata',
    'hsb'   => "Upper\ Sorbian",
    'ht'    => 'Haitian',
    'hu'    => 'Húngaro',
    'hup'   => 'Hupa',
    'hy'    => 'Armenio',
    'hz'    => 'Herero',
    'ia'    => 'Interlingua',
    'iba'   => 'Iban',
    'id'    => 'Indonesio',
    'ie'    => 'Interlingue',
    'ig'    => 'Igbo',
    'ii'    => "Sichuan\ Yi",
    'ijo'   => 'Ijo',
    'ik'    => 'Inupiaq',
    'ilo'   => 'Iloko',
    'inc'   => "Lingua\ índica",
    'ine'   => "Lingua\ indoeuropea",
    'inh'   => 'Ingush',
    'io'    => 'Ido',
    'ira'   => "Iranian\ Language",
    'iro'   => "Iroquoian\ Language",
    'is'    => 'Islandés',
    'it'    => 'Italiano',
    'iu'    => 'Inuktitut',
    'ja'    => 'Xaponés',
    'jbo'   => 'Lojban',
    'jpr'   => "Judeo\-Persian",
    'jrb'   => "Judeo\-Arabic",
    'jv'    => 'Xavanés',
    'ka'    => 'Xeorxiano',
    'kaa'   => "Kara\-Kalpak",
    'kab'   => 'Kabyle',
    'kac'   => 'Kachin',
    'kaj'   => 'Jju',
    'kam'   => 'Kamba',
    'kar'   => 'Karen',
    'kaw'   => 'Kawi',
    'kbd'   => 'Kabardian',
    'kcg'   => 'Tyap',
    'kfo'   => 'Koro',
    'kg'    => 'Kongo',
    'kha'   => 'Khasi',
    'khi'   => "Khoisan\ Language",
    'kho'   => 'Khotanese',
    'ki'    => 'Kikuyu',
    'kj'    => 'Kuanyama',
    'kk'    => 'Kazakh',
    'kl'    => 'Kalaallisut',
    'km'    => 'Cambodiano',
    'kmb'   => 'Kimbundu',
    'kn'    => 'Kannada',
    'ko'    => 'Coreano',
    'kok'   => 'Konkani',
    'kos'   => 'Kosraean',
    'kpe'   => 'Kpelle',
    'kr'    => 'Kanuri',
    'krc'   => "Karachay\-Balkar",
    'krl'   => 'Karelian',
    'kro'   => 'Kru',
    'kru'   => 'Kurukh',
    'ks'    => 'Kashmiri',
    'ku'    => 'Kurdo',
    'kum'   => 'Kumyk',
    'kut'   => 'Kutenai',
    'kv'    => 'Komi',
    'kw'    => 'Cornish',
    'ky'    => 'Kyrgiz',
    'la'    => 'Latín',
    'lad'   => 'Ladino',
    'lah'   => 'Lahnda',
    'lam'   => 'Lamba',
    'lb'    => 'Luxembourgish',
    'lez'   => 'Lezghian',
    'lg'    => 'Ganda',
    'li'    => 'Limburgish',
    'ln'    => 'Lingala',
    'lo'    => 'Laotiano',
    'lol'   => 'Mongo',
    'loz'   => 'Lozi',
    'lt'    => 'Lituano',
    'lu'    => "Luba\-Katanga",
    'lua'   => "Luba\-Lulua",
    'lui'   => 'Luiseno',
    'lun'   => 'Lunda',
    'luo'   => 'Luo',
    'lus'   => 'Lushai',
    'lv'    => 'Letón',
    'mad'   => 'Madurese',
    'mag'   => 'Magahi',
    'mai'   => 'Maithili',
    'mak'   => 'Makasar',
    'man'   => 'Mandingo',
    'map'   => "Austronesian\ Language",
    'mas'   => 'Masai',
    'mdf'   => 'Moksha',
    'mdr'   => 'Mandar',
    'men'   => 'Mende',
    'mfe'   => 'Morisyen',
    'mg'    => 'Malagasy',
    'mga'   => "Middle\ Irish",
    'mh'    => 'Marshallese',
    'mi'    => 'Maori',
    'mic'   => 'Micmac',
    'min'   => 'Minangkabau',
    'mis'   => "Lingua\ miscelánea",
    'mk'    => 'Macedonio',
    'mkh'   => "Mon\-Khmer\ Language",
    'ml'    => 'Malaialam',
    'mn'    => 'Mongol',
    'mnc'   => 'Manchu',
    'mni'   => 'Manipuri',
    'mno'   => "Manobo\ Language",
    'mo'    => 'Moldavian',
    'moh'   => 'Mohawk',
    'mos'   => 'Mossi',
    'mr'    => 'Marathi',
    'ms'    => 'Malaio',
    'mt'    => 'Maltés',
    'mul'   => "Varias\ linguas",
    'mun'   => "Munda\ Language",
    'mus'   => 'Creek',
    'mwl'   => 'Mirandese',
    'mwr'   => 'Marwari',
    'my'    => 'Burmese',
    'myn'   => "Mayan\ Language",
    'myv'   => 'Erzya',
    'na'    => 'Nauru',
    'nah'   => 'Nahuatl',
    'nai'   => "Lingua\ india\ norteamericana",
    'nap'   => 'Neapolitan',
    'nb'    => "Noruegués\ Bokmal",
    'nd'    => "North\ Ndebele",
    'nds'   => "Low\ German",
    'ne'    => 'Nepalí',
    'new'   => 'Newari',
    'ng'    => 'Ndonga',
    'nia'   => 'Nias',
    'nic'   => "Niger\-Kordofanian\ Language",
    'niu'   => 'Niuean',
    'nl'    => 'Holandés',
    'nl_be' => 'Flamenco',
    'nn'    => "Noruegués\ nynorsk",
    'no'    => 'Noruegués',
    'nog'   => 'Nogai',
    'non'   => "Old\ Norse",
    'nqo'   => "N\â\\Ko",
    'nr'    => "South\ Ndebele",
    'nso'   => "Northern\ Sotho",
    'nub'   => "Lingua\ nubia",
    'nv'    => 'Navajo',
    'nwc'   => "Classical\ Newari",
    'ny'    => 'Nyanja',
    'nym'   => 'Nyamwezi',
    'nyn'   => 'Nyankole',
    'nyo'   => 'Nyoro',
    'nzi'   => 'Nzima',
    'oc'    => 'Occitano',
    'oj'    => 'Ojibwa',
    'om'    => 'Oromo',
    'or'    => 'Orissa',
    'os'    => 'Ossetic',
    'osa'   => 'Osage',
    'ota'   => "Ottoman\ Turkish",
    'oto'   => "Otomian\ Language",
    'pa'    => 'Punjabi',
    'paa'   => "Papuan\ Language",
    'pag'   => 'Pangasinan',
    'pal'   => 'Pahlavi',
    'pam'   => 'Pampanga',
    'pap'   => 'Papiamento',
    'pau'   => 'Palauan',
    'peo'   => "Old\ Persian",
    'phi'   => "Lingua\ filipina",
    'phn'   => 'Phoenician',
    'pi'    => 'Pali',
    'pl'    => 'Polaco',
    'pon'   => 'Pohnpeian',
    'pra'   => "Prakrit\ Language",
    'pro'   => "Old\ Proven\Ã\§al",
    'ps'    => 'Pashto',
    'pt'    => 'Portugués',
    'pt_br' => "Portugués\ brasileiro",
    'pt_pt' => "Portugués\ ibérico",
    'qu'    => 'Quechua',
    'raj'   => 'Rajasthani',
    'rap'   => 'Rapanui',
    'rar'   => 'Rarotongan',
    'rm'    => "Rhaeto\-Romance",
    'rn'    => 'Rundi',
    'ro'    => 'Romanés',
    'roa'   => "Lingua\ románica",
    'rom'   => 'Romany',
    'ru'    => 'Ruso',
    'rup'   => 'Aromanian',
    'rw'    => 'Kinyarwanda',
    'sa'    => 'Sánscrito',
    'sad'   => 'Sandawe',
    'sah'   => 'Yakut',
    'sai'   => "Lingua\ india\ sudamericana",
    'sal'   => "Salishan\ Language",
    'sam'   => "Samaritan\ Aramaic",
    'sas'   => 'Sasak',
    'sat'   => 'Santali',
    'sc'    => 'Sardinian',
    'scn'   => 'Sicilian',
    'sco'   => 'Scots',
    'sd'    => 'Sindhi',
    'se'    => "Northern\ Sami",
    'sel'   => 'Selkup',
    'sem'   => "Lingua\ semita",
    'sg'    => 'Sango',
    'sga'   => "Old\ Irish",
    'sgn'   => "Lingua\ de\ signos",
    'sh'    => 'Serbocroata',
    'shn'   => 'Shan',
    'si'    => 'Sinhalés',
    'sid'   => 'Sidamo',
    'sio'   => "Siouan\ Language",
    'sit'   => "Sino\-Tibetan\ Language",
    'sk'    => 'Eslovaco',
    'sl'    => 'Esloveno',
    'sla'   => "Lingua\ eslávica",
    'sm'    => 'Samoan',
    'sma'   => "Southern\ Sami",
    'smi'   => "Sami\ Language",
    'smj'   => "Lule\ Sami",
    'smn'   => "Inari\ Sami",
    'sms'   => "Skolt\ Sami",
    'sn'    => 'Shona',
    'snk'   => 'Soninke',
    'so'    => 'Somalí',
    'sog'   => 'Sogdien',
    'son'   => 'Songhai',
    'sq'    => 'Albanés',
    'sr'    => 'Serbio',
    'srn'   => "Sranan\ Tongo",
    'srr'   => 'Serer',
    'ss'    => 'Swati',
    'ssa'   => "Lingua\ do\ Nilo\-Sáhara",
    'st'    => 'Sesotho',
    'su'    => 'Sondanés',
    'suk'   => 'Sukuma',
    'sus'   => 'Susu',
    'sux'   => 'Sumerian',
    'sv'    => 'Sueco',
    'sw'    => 'Suaxili',
    'syc'   => "Classical\ Syriac",
    'syr'   => 'Syriac',
    'ta'    => 'Tamil',
    'tai'   => "Tai\ Language",
    'te'    => 'Telugu',
    'tem'   => 'Timne',
    'ter'   => 'Tereno',
    'tet'   => 'Tetum',
    'tg'    => 'Tajik',
    'th'    => 'Tailandés',
    'ti'    => 'Tigriña',
    'tig'   => 'Tigre',
    'tiv'   => 'Tiv',
    'tk'    => 'Turkmen',
    'tkl'   => 'Tokelau',
    'tl'    => 'Tagalo',
    'tlh'   => 'Clingon',
    'tli'   => 'Tlingit',
    'tmh'   => 'Tamashek',
    'tn'    => 'Tswana',
    'to'    => 'Tonga',
    'tog'   => "Nyasa\ Tonga",
    'tpi'   => "Tok\ Pisin",
    'tr'    => 'Turco',
    'trv'   => 'Taroko',
    'ts'    => 'Tsonga',
    'tsi'   => 'Tsimshian',
    'tt'    => 'Tatar',
    'tum'   => 'Tumbuka',
    'tup'   => "Tupi\ Language",
    'tut'   => "Lingua\ altaica",
    'tvl'   => 'Tuvalu',
    'tw'    => 'Twi',
    'ty'    => 'Tahitian',
    'tyv'   => 'Tuvinian',
    'udm'   => 'Udmurt',
    'ug'    => 'Uighur',
    'uga'   => 'Ugaritic',
    'uk'    => 'Ucraíno',
    'umb'   => 'Umbundu',
    'und'   => "Lingua\ descoñecida\ ou\ non\ válida",
    'ur'    => 'Urdú',
    'uz'    => 'Uzbeco',
    'vai'   => 'Vai',
    've'    => 'Venda',
    'vi'    => 'Vietnamita',
    'vo'    => "Volap\Ã\¼k",
    'vot'   => 'Votic',
    'wa'    => 'Walloon',
    'wak'   => "Wakashan\ Language",
    'wal'   => 'Walamo',
    'war'   => 'Waray',
    'was'   => 'Washo',
    'wen'   => "Sorbian\ Language",
    'wo'    => 'Wolof',
    'xal'   => 'Kalmyk',
    'xh'    => 'Xhosa',
    'yao'   => 'Yao',
    'yap'   => 'Yapese',
    'yi'    => 'Yiddish',
    'yo'    => 'Yoruba',
    'ypk'   => "Yupik\ Language",
    'za'    => 'Zhuang',
    'zap'   => 'Zapotec',
    'zbl'   => 'Blissymbols',
    'zen'   => 'Zenaga',
    'zh'    => 'Chinés',
    'znd'   => 'Zande',
    'zu'    => 'Zulú',
    'zun'   => 'Zuni',
    'zxx'   => "Sen\ contido\ lingüístico",
    'zza'   => 'Zaza',
);

%Locales::DB::Language::gl::name_to_code = (
    'abkhazian'                      => 'ab',
    'achinese'                       => 'ace',
    'acoli'                          => 'ach',
    'adangme'                        => 'ada',
    'adyghe'                         => 'ady',
    'afar'                           => 'aa',
    'afrihili'                       => 'afh',
    'afrikaans'                      => 'af',
    'ainu'                           => 'ain',
    'akan'                           => 'ak',
    'akkadian'                       => 'akk',
    'albanés'                       => 'sq',
    'alemán'                        => 'de',
    'alemándeaustria'               => 'de_at',
    'alemánsuízo'                  => 'de_ch',
    'aleut'                          => 'ale',
    'amárico'                       => 'am',
    'angika'                         => 'anp',
    'aragonés'                      => 'an',
    'arameo'                         => 'arc',
    'arapaho'                        => 'arp',
    'araucanian'                     => 'arn',
    'arawak'                         => 'arw',
    'armenio'                        => 'hy',
    'aromanian'                      => 'rup',
    'assamés'                       => 'as',
    'asturiano'                      => 'ast',
    'athapascanlanguage'             => 'ath',
    'atsam'                          => 'cch',
    'austronesianlanguage'           => 'map',
    'avaric'                         => 'av',
    'avestan'                        => 'ae',
    'awadhi'                         => 'awa',
    'aymara'                         => 'ay',
    'azerbaiano'                     => 'az',
    'balinese'                       => 'ban',
    'baluchi'                        => 'bal',
    'bambara'                        => 'bm',
    'bamilekelanguage'               => 'bai',
    'banda'                          => 'bad',
    'bantu'                          => 'bnt',
    'basa'                           => 'bas',
    'bashkir'                        => 'ba',
    'batak'                          => 'btk',
    'beja'                           => 'bej',
    'bemba'                          => 'bem',
    'bengalí'                       => 'bn',
    'berber'                         => 'ber',
    'bhojpuri'                       => 'bho',
    'bielorruso'                     => 'be',
    'bihariano'                      => 'bh',
    'bikol'                          => 'bik',
    'bini'                           => 'bin',
    'bislama'                        => 'bi',
    'blin'                           => 'byn',
    'blissymbols'                    => 'zbl',
    'bosnio'                         => 'bs',
    'braj'                           => 'bra',
    'bretón'                        => 'br',
    'buginese'                       => 'bug',
    'buriat'                         => 'bua',
    'burmese'                        => 'my',
    'búlgaro'                       => 'bg',
    'caddo'                          => 'cad',
    'cambodiano'                     => 'km',
    'carib'                          => 'car',
    'castelán'                      => 'es_es',
    'catalán'                       => 'ca',
    'cebuano'                        => 'ceb',
    'chagatai'                       => 'chg',
    'chamiclanguage'                 => 'cmc',
    'chamorro'                       => 'ch',
    'chechen'                        => 'ce',
    'checo'                          => 'cs',
    'cherokee'                       => 'chr',
    'cheyenne'                       => 'chy',
    'chibcha'                        => 'chb',
    'chinookjargon'                  => 'chn',
    'chinés'                        => 'zh',
    'chipewyan'                      => 'chp',
    'choctaw'                        => 'cho',
    'chuukese'                       => 'chk',
    'chuvash'                        => 'cv',
    'classicalnewari'                => 'nwc',
    'classicalsyriac'                => 'syc',
    'clingon'                        => 'tlh',
    'coptic'                         => 'cop',
    'coreano'                        => 'ko',
    'cornish'                        => 'kw',
    'corsican'                       => 'co',
    'cree'                           => 'cr',
    'creek'                          => 'mus',
    'creoleorpidgin'                 => 'crp',
    'crimeanturkish'                 => 'crh',
    'croata'                         => 'hr',
    'cushiticlanguage'               => 'cus',
    'dakota'                         => 'dak',
    'dargwa'                         => 'dar',
    'dayak'                          => 'day',
    'delaware'                       => 'del',
    'dinamarqués'                   => 'da',
    'dinka'                          => 'din',
    'divehi'                         => 'dv',
    'dogri'                          => 'doi',
    'dogrib'                         => 'dgr',
    'dravidianlanguage'              => 'dra',
    'duala'                          => 'dua',
    'dyula'                          => 'dyu',
    'dzongkha'                       => 'dz',
    'easternfrisian'                 => 'frs',
    'efik'                           => 'efi',
    'ekajuk'                         => 'eka',
    'elamite'                        => 'elx',
    'englishbasedcreoleorpidgin'     => 'cpe',
    'erzya'                          => 'myv',
    'eslavoeclesiástico'            => 'cu',
    'eslovaco'                       => 'sk',
    'esloveno'                       => 'sl',
    'español'                       => 'es',
    'esperanto'                      => 'eo',
    'estoniano'                      => 'et',
    'ewe'                            => 'ee',
    'ewondo'                         => 'ewo',
    'exipcioantigo'                  => 'egy',
    'fang'                           => 'fan',
    'fanti'                          => 'fat',
    'faroés'                        => 'fo',
    'fijian'                         => 'fj',
    'filipino'                       => 'fil',
    'finés'                         => 'fi',
    'flamenco'                       => 'nl_be',
    'fon'                            => 'fon',
    'francés'                       => 'fr',
    'francéscanadiano'              => 'fr_ca',
    'francéssuízo'                 => 'fr_ch',
    'frenchbasedcreoleorpidgin'      => 'cpf',
    'frisón'                        => 'fy',
    'friulian'                       => 'fur',
    'fulah'                          => 'ff',
    'ga'                             => 'gaa',
    'galego'                         => 'gl',
    'galés'                         => 'cy',
    'ganda'                          => 'lg',
    'gayo'                           => 'gay',
    'gaélicoescocés'               => 'gd',
    'gbaya'                          => 'gba',
    'geez'                           => 'gez',
    'gilbertese'                     => 'gil',
    'gondi'                          => 'gon',
    'gorontalo'                      => 'gor',
    'gothic'                         => 'got',
    'grebo'                          => 'grb',
    'grego'                          => 'el',
    'gregoantigo'                    => 'grc',
    'guaraní'                       => 'gn',
    'guxaratiano'                    => 'gu',
    "gwich\Ê\¼in"                  => 'gwi',
    'haida'                          => 'hai',
    'haitian'                        => 'ht',
    'hausa'                          => 'ha',
    'hawaiian'                       => 'haw',
    'hebreo'                         => 'he',
    'herero'                         => 'hz',
    'hiligaynon'                     => 'hil',
    'himachali'                      => 'him',
    'hindi'                          => 'hi',
    'hirimotu'                       => 'ho',
    'hittite'                        => 'hit',
    'hmong'                          => 'hmn',
    'holandés'                      => 'nl',
    'hupa'                           => 'hup',
    'húngaro'                       => 'hu',
    'iban'                           => 'iba',
    'ido'                            => 'io',
    'igbo'                           => 'ig',
    'ijo'                            => 'ijo',
    'iloko'                          => 'ilo',
    'inarisami'                      => 'smn',
    'indonesio'                      => 'id',
    'inglés'                        => 'en',
    'inglésamericano'               => 'en_us',
    'inglésaustraliano'             => 'en_au',
    'inglésbritánico'              => 'en_gb',
    'ingléscanadiano'               => 'en_ca',
    'ingush'                         => 'inh',
    'interlingua'                    => 'ia',
    'interlingue'                    => 'ie',
    'inuktitut'                      => 'iu',
    'inupiaq'                        => 'ik',
    'iranianlanguage'                => 'ira',
    'irlandés'                      => 'ga',
    'iroquoianlanguage'              => 'iro',
    'islandés'                      => 'is',
    'italiano'                       => 'it',
    'jju'                            => 'kaj',
    'judeoarabic'                    => 'jrb',
    'judeopersian'                   => 'jpr',
    'kabardian'                      => 'kbd',
    'kabyle'                         => 'kab',
    'kachin'                         => 'kac',
    'kalaallisut'                    => 'kl',
    'kalmyk'                         => 'xal',
    'kamba'                          => 'kam',
    'kannada'                        => 'kn',
    'kanuri'                         => 'kr',
    'karachaybalkar'                 => 'krc',
    'karakalpak'                     => 'kaa',
    'karelian'                       => 'krl',
    'karen'                          => 'kar',
    'kashmiri'                       => 'ks',
    'kashubian'                      => 'csb',
    'kawi'                           => 'kaw',
    'kazakh'                         => 'kk',
    'khasi'                          => 'kha',
    'khoisanlanguage'                => 'khi',
    'khotanese'                      => 'kho',
    'kikuyu'                         => 'ki',
    'kimbundu'                       => 'kmb',
    'kinyarwanda'                    => 'rw',
    'komi'                           => 'kv',
    'kongo'                          => 'kg',
    'konkani'                        => 'kok',
    'koro'                           => 'kfo',
    'kosraean'                       => 'kos',
    'kpelle'                         => 'kpe',
    'kru'                            => 'kro',
    'kuanyama'                       => 'kj',
    'kumyk'                          => 'kum',
    'kurdo'                          => 'ku',
    'kurukh'                         => 'kru',
    'kutenai'                        => 'kut',
    'kyrgiz'                         => 'ky',
    'ladino'                         => 'lad',
    'lahnda'                         => 'lah',
    'lamba'                          => 'lam',
    'laotiano'                       => 'lo',
    'latín'                         => 'la',
    'letón'                         => 'lv',
    'lezghian'                       => 'lez',
    'limburgish'                     => 'li',
    'lingala'                        => 'ln',
    'linguaafroasiática'            => 'afa',
    'linguaalgonquina'               => 'alg',
    'linguaaltaica'                  => 'tut',
    'linguaapache'                   => 'apa',
    'linguaartificial'               => 'art',
    'linguaaustraliana'              => 'aus',
    'linguabáltica'                 => 'bat',
    'linguacaucásica'               => 'cau',
    'linguacéltica'                 => 'cel',
    'linguadescoñecidaounonválida' => 'und',
    'linguadesignos'                 => 'sgn',
    'linguadonilosáhara'            => 'ssa',
    'linguaeslávica'                => 'sla',
    'linguafilipina'                 => 'phi',
    'linguafinnoúgrica'             => 'fiu',
    'linguaindiacentroamericana'     => 'cai',
    'linguaindianorteamericana'      => 'nai',
    'linguaindiasudamericana'        => 'sai',
    'linguaindoeuropea'              => 'ine',
    'linguamiscelánea'              => 'mis',
    'linguanubia'                    => 'nub',
    'linguarománica'                => 'roa',
    'linguasemita'                   => 'sem',
    'linguaxermánica'               => 'gem',
    'linguaíndica'                  => 'inc',
    'lituano'                        => 'lt',
    'lojban'                         => 'jbo',
    'lowersorbian'                   => 'dsb',
    'lowgerman'                      => 'nds',
    'lozi'                           => 'loz',
    'lubakatanga'                    => 'lu',
    'lubalulua'                      => 'lua',
    'luiseno'                        => 'lui',
    'lulesami'                       => 'smj',
    'lunda'                          => 'lun',
    'luo'                            => 'luo',
    'lushai'                         => 'lus',
    'luxembourgish'                  => 'lb',
    'macedonio'                      => 'mk',
    'madurese'                       => 'mad',
    'magahi'                         => 'mag',
    'maithili'                       => 'mai',
    'makasar'                        => 'mak',
    'malagasy'                       => 'mg',
    'malaialam'                      => 'ml',
    'malaio'                         => 'ms',
    'maltés'                        => 'mt',
    'manchu'                         => 'mnc',
    'mandar'                         => 'mdr',
    'mandingo'                       => 'man',
    'manipuri'                       => 'mni',
    'manobolanguage'                 => 'mno',
    'manx'                           => 'gv',
    'maori'                          => 'mi',
    'marathi'                        => 'mr',
    'mari'                           => 'chm',
    'marshallese'                    => 'mh',
    'marwari'                        => 'mwr',
    'masai'                          => 'mas',
    'mayanlanguage'                  => 'myn',
    'mende'                          => 'men',
    'micmac'                         => 'mic',
    'middledutch'                    => 'dum',
    'middleenglish'                  => 'enm',
    'middlefrench'                   => 'frm',
    'middlehighgerman'               => 'gmh',
    'middleirish'                    => 'mga',
    'minangkabau'                    => 'min',
    'mirandese'                      => 'mwl',
    'mohawk'                         => 'moh',
    'moksha'                         => 'mdf',
    'moldavian'                      => 'mo',
    'mongo'                          => 'lol',
    'mongol'                         => 'mn',
    'monkhmerlanguage'               => 'mkh',
    'morisyen'                       => 'mfe',
    'mossi'                          => 'mos',
    'mundalanguage'                  => 'mun',
    'nahuatl'                        => 'nah',
    'nauru'                          => 'na',
    'navajo'                         => 'nv',
    'ndonga'                         => 'ng',
    'neapolitan'                     => 'nap',
    'nepalí'                        => 'ne',
    'newari'                         => 'new',
    'nias'                           => 'nia',
    'nigerkordofanianlanguage'       => 'nic',
    'niuean'                         => 'niu',
    'nogai'                          => 'nog',
    'northernfrisian'                => 'frr',
    'northernsami'                   => 'se',
    'northernsotho'                  => 'nso',
    'northndebele'                   => 'nd',
    'noruegués'                     => 'no',
    'norueguésbokmal'               => 'nb',
    'norueguésnynorsk'              => 'nn',
    'nyamwezi'                       => 'nym',
    'nyanja'                         => 'ny',
    'nyankole'                       => 'nyn',
    'nyasatonga'                     => 'tog',
    'nyoro'                          => 'nyo',
    'nzima'                          => 'nzi',
    "n\â\\ko"                   => 'nqo',
    'occitano'                       => 'oc',
    'ojibwa'                         => 'oj',
    'oldenglish'                     => 'ang',
    'oldfrench'                      => 'fro',
    'oldhighgerman'                  => 'goh',
    'oldirish'                       => 'sga',
    'oldnorse'                       => 'non',
    'oldpersian'                     => 'peo',
    "oldproven\Ã\§al"              => 'pro',
    'orissa'                         => 'or',
    'oromo'                          => 'om',
    'osage'                          => 'osa',
    'ossetic'                        => 'os',
    'otomianlanguage'                => 'oto',
    'ottomanturkish'                 => 'ota',
    'pahlavi'                        => 'pal',
    'palauan'                        => 'pau',
    'pali'                           => 'pi',
    'pampanga'                       => 'pam',
    'pangasinan'                     => 'pag',
    'papiamento'                     => 'pap',
    'papuanlanguage'                 => 'paa',
    'pashto'                         => 'ps',
    'persa'                          => 'fa',
    'phoenician'                     => 'phn',
    'pohnpeian'                      => 'pon',
    'polaco'                         => 'pl',
    'portuguesebasedcreoleorpidgin'  => 'cpp',
    'portugués'                     => 'pt',
    'portuguésbrasileiro'           => 'pt_br',
    'portuguésibérico'             => 'pt_pt',
    'prakritlanguage'                => 'pra',
    'punjabi'                        => 'pa',
    'quechua'                        => 'qu',
    'rajasthani'                     => 'raj',
    'rapanui'                        => 'rap',
    'rarotongan'                     => 'rar',
    'rhaetoromance'                  => 'rm',
    'romany'                         => 'rom',
    'romanés'                       => 'ro',
    'rundi'                          => 'rn',
    'ruso'                           => 'ru',
    'salishanlanguage'               => 'sal',
    'samaritanaramaic'               => 'sam',
    'samilanguage'                   => 'smi',
    'samoan'                         => 'sm',
    'sandawe'                        => 'sad',
    'sango'                          => 'sg',
    'santali'                        => 'sat',
    'sardinian'                      => 'sc',
    'sasak'                          => 'sas',
    'scots'                          => 'sco',
    'selkup'                         => 'sel',
    'sencontidolingüístico'        => 'zxx',
    'serbio'                         => 'sr',
    'serbocroata'                    => 'sh',
    'serer'                          => 'srr',
    'sesotho'                        => 'st',
    'shan'                           => 'shn',
    'shona'                          => 'sn',
    'sichuanyi'                      => 'ii',
    'sicilian'                       => 'scn',
    'sidamo'                         => 'sid',
    'siksika'                        => 'bla',
    'sindhi'                         => 'sd',
    'sinhalés'                      => 'si',
    'sinotibetanlanguage'            => 'sit',
    'siouanlanguage'                 => 'sio',
    'skoltsami'                      => 'sms',
    'slave'                          => 'den',
    'sogdien'                        => 'sog',
    'somalí'                        => 'so',
    'sondanés'                      => 'su',
    'songhai'                        => 'son',
    'soninke'                        => 'snk',
    'sorbianlanguage'                => 'wen',
    'southernaltai'                  => 'alt',
    'southernsami'                   => 'sma',
    'southndebele'                   => 'nr',
    'sranantongo'                    => 'srn',
    'suaxili'                        => 'sw',
    'sueco'                          => 'sv',
    'sukuma'                         => 'suk',
    'sumerian'                       => 'sux',
    'susu'                           => 'sus',
    'swati'                          => 'ss',
    'swissgerman'                    => 'gsw',
    'syriac'                         => 'syr',
    'sánscrito'                     => 'sa',
    'tagalo'                         => 'tl',
    'tahitian'                       => 'ty',
    'tailandés'                     => 'th',
    'tailanguage'                    => 'tai',
    'tajik'                          => 'tg',
    'tamashek'                       => 'tmh',
    'tamil'                          => 'ta',
    'taroko'                         => 'trv',
    'tatar'                          => 'tt',
    'telugu'                         => 'te',
    'tereno'                         => 'ter',
    'tetum'                          => 'tet',
    'tibetan'                        => 'bo',
    'tigre'                          => 'tig',
    'tigriña'                       => 'ti',
    'timne'                          => 'tem',
    'tiv'                            => 'tiv',
    'tlingit'                        => 'tli',
    'tokelau'                        => 'tkl',
    'tokpisin'                       => 'tpi',
    'tonga'                          => 'to',
    'tsimshian'                      => 'tsi',
    'tsonga'                         => 'ts',
    'tswana'                         => 'tn',
    'tumbuka'                        => 'tum',
    'tupilanguage'                   => 'tup',
    'turco'                          => 'tr',
    'turkmen'                        => 'tk',
    'tuvalu'                         => 'tvl',
    'tuvinian'                       => 'tyv',
    'twi'                            => 'tw',
    'tyap'                           => 'kcg',
    'ucraíno'                       => 'uk',
    'udmurt'                         => 'udm',
    'ugaritic'                       => 'uga',
    'uighur'                         => 'ug',
    'umbundu'                        => 'umb',
    'uppersorbian'                   => 'hsb',
    'urdú'                          => 'ur',
    'uzbeco'                         => 'uz',
    'vai'                            => 'vai',
    'variaslinguas'                  => 'mul',
    'venda'                          => 've',
    'vietnamita'                     => 'vi',
    "volap\Ã\¼k"                   => 'vo',
    'votic'                          => 'vot',
    'wakashanlanguage'               => 'wak',
    'walamo'                         => 'wal',
    'walloon'                        => 'wa',
    'waray'                          => 'war',
    'washo'                          => 'was',
    'wolof'                          => 'wo',
    'xaponés'                       => 'ja',
    'xavanés'                       => 'jv',
    'xeorxiano'                      => 'ka',
    'xhosa'                          => 'xh',
    'yakut'                          => 'sah',
    'yao'                            => 'yao',
    'yapese'                         => 'yap',
    'yiddish'                        => 'yi',
    'yoruba'                         => 'yo',
    'yupiklanguage'                  => 'ypk',
    'zande'                          => 'znd',
    'zapotec'                        => 'zap',
    'zaza'                           => 'zza',
    'zenaga'                         => 'zen',
    'zhuang'                         => 'za',
    'zulú'                          => 'zu',
    'zuni'                           => 'zun',
    'Árabe'                         => 'ar',
    'Éuscaro'                       => 'eu',
);

1;
