package Locales::DB::Language::is;

# Auto generated from CLDR

$Locales::DB::Language::is::VERSION = '0.02';

$Locales::DB::Language::is::cldr_version = '1.7.1';

%Locales::DB::Language::is::misc_info = (
    'cldr_formats' => {
        'decimal' => {
            'content' => "\#\,\#\#0\.\#\#\#",
            'draft'   => 'contributed'
        },
        'language' => "tungumál\:\ \{0\}",
        'locale'   => {
            'content' => "\{0\}\ \(\{1\}\)",
            'draft'   => 'contributed'
        },
        'percent' => [
            {
                'content' => "\#\,\#\#0\%",
                'draft'   => 'contributed'
            },
            {
                'alt'     => "proposed\-x1001",
                'content' => "\#\,\#\#0 \%",
                'draft'   => 'unconfirmed'
            }
        ],
        'territory' => "svæði\:\ \{0\}"
    },
    'fallback'    => [ "nn\ sv\ nb\ da\ en" ],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'posix' => {
        'nostr' => {
            'content' => "nei\:n",
            'draft'   => 'contributed'
        },
        'yesstr' => {
            'content' => "já\:j",
            'draft'   => 'contributed'
        }
    },
);

%Locales::DB::Language::is::code_to_name = (
    'aa'    => 'afár',
    'ab'    => 'abkasíska',
    'ace'   => 'akkíska',
    'ach'   => 'akólí',
    'ada'   => 'adangme',
    'ady'   => 'adýge',
    'ae'    => 'avestíska',
    'af'    => 'afríkanska',
    'afa'   => "afróasísk\ mál",
    'afh'   => 'afríhílí',
    'ain'   => "aínu\ \(Japan\)",
    'ak'    => 'akan',
    'akk'   => 'akkadíska',
    'ale'   => 'aleutíska',
    'alg'   => "algonkvínsk\ mál",
    'alt'   => 'suðuraltaíska',
    'am'    => 'amharíska',
    'an'    => 'aragonska',
    'ang'   => 'fornenska',
    'anp'   => 'angíka',
    'apa'   => 'apatsjamál',
    'ar'    => 'arabíska',
    'arc'   => "officiell\ arameíska",
    'arn'   => 'arákaníska',
    'arp'   => 'arapahó',
    'art'   => 'alþjóðamál',
    'arw'   => 'aravakska',
    'as'    => 'assameíska',
    'ast'   => 'astúríska',
    'ath'   => "atapaskísk\ mál",
    'aus'   => "áströlsk\ mál",
    'av'    => 'avaríska',
    'awa'   => 'avadí',
    'ay'    => 'aímara',
    'az'    => 'aserska',
    'ba'    => 'baskír',
    'bad'   => 'bandasmál',
    'bai'   => "bamilékísk\ mál",
    'bal'   => 'balúkí',
    'ban'   => 'balíska',
    'bas'   => "basa\ \(Kamerun\)",
    'bat'   => "baltnesk\ mál",
    'be'    => 'hvítrússneska',
    'bej'   => 'beja',
    'bem'   => "bemba\ \(Zambia\)",
    'ber'   => 'berbamál',
    'bg'    => 'búlgarska',
    'bh'    => "bíharísk\ mál",
    'bho'   => 'bojpúrí',
    'bi'    => 'bíslama',
    'bik'   => 'bícolano',
    'bin'   => 'bíní',
    'bla'   => 'siksika',
    'bm'    => 'bambara',
    'bn'    => 'bengalska',
    'bnt'   => 'bantúmál',
    'bo'    => 'tíbeska',
    'br'    => 'bretónska',
    'bra'   => 'braí',
    'bs'    => 'bosníska',
    'btk'   => 'batakmál',
    'bua'   => 'búríat',
    'bug'   => 'búgíska',
    'byn'   => 'blín',
    'ca'    => 'katalónska',
    'cad'   => 'kaddó',
    'cai'   => "Mið\-Ameríku\ indíánamál",
    'car'   => 'galibíska',
    'cau'   => 'kákasusmál',
    'cch'   => 'atsam',
    'ce'    => 'tsjetsjenska',
    'ceb'   => 'kebúanó',
    'cel'   => "keltnesk\ mál",
    'ch'    => 'kamorró',
    'chb'   => 'síbsja',
    'chg'   => 'sjagataí',
    'chk'   => 'sjúkíska',
    'chm'   => "maríska\ \(Rusland\)",
    'chn'   => "sínúk\ pidginenska",
    'cho'   => 'sjoktá',
    'chp'   => 'sípevíska',
    'chr'   => 'sjerókí',
    'chy'   => 'sjeyen',
    'cmc'   => "kamísk\ mál",
    'co'    => 'korsíska',
    'cop'   => 'koptíska',
    'cpe'   => "kreól\-\ eða\ pidginmál\ á\ enskum\ grunni",
    'cpf'   => "kreól\-\ eða\ pidginmál\ á\ frönskum\ grunni",
    'cpp'   => "kreól\-\ eða\ pidginmál\ á\ portúgölskum\ grunni",
    'cr'    => 'krí',
    'crh'   => 'krímtyrkneska',
    'crp'   => "kreól\-\ eða\ pidginmál",
    'cs'    => 'tékkneska',
    'csb'   => 'kasúbíska',
    'cu'    => 'kirkjuslavneska',
    'cus'   => "kúsitísk\ mál",
    'cv'    => 'sjúvas',
    'cy'    => 'velska',
    'da'    => 'danska',
    'dak'   => 'dakóta',
    'dar'   => 'dargva',
    'day'   => 'bidayuhmál',
    'de'    => 'þýska',
    'de_at' => "austurrísk\ þýska",
    'de_ch' => "svissnesk\ háþýska",
    'del'   => 'delaver',
    'den'   => 'slavéj',
    'dgr'   => 'dogríb',
    'din'   => 'dinka',
    'doi'   => "dogri\-kangri",
    'dra'   => "dravidísk\ mál",
    'dsb'   => 'lágsorbneska',
    'dua'   => 'dúala',
    'dum'   => 'miðhollenska',
    'dv'    => 'dívehí',
    'dyu'   => 'djúla',
    'dz'    => 'dsongka',
    'ee'    => 'eve',
    'efi'   => 'efík',
    'egy'   => 'fornegypska',
    'eka'   => 'ekajúk',
    'el'    => 'gríska',
    'elx'   => 'elamít',
    'en'    => 'enska',
    'en_au' => "áströlsk\ enska",
    'en_ca' => "kanadísk\ enska",
    'en_gb' => "bresk\ enska",
    'en_us' => "bandarísk\ enska",
    'enm'   => 'miðenska',
    'eo'    => 'esperantó',
    'es'    => 'spænska',
    'es_es' => "íberísk\ spænska",
    'et'    => 'eistneska',
    'eu'    => 'baskneska',
    'ewo'   => 'evondó',
    'fa'    => 'persneska',
    'fan'   => 'fang',
    'fat'   => 'fantí',
    'ff'    => 'fulfulde',
    'fi'    => 'finnska',
    'fil'   => 'filipínska',
    'fiu'   => "finnskúgrísk\ mál",
    'fj'    => 'fídjeyska',
    'fo'    => 'færeyska',
    'fon'   => 'fón',
    'fr'    => 'franska',
    'fr_ca' => "kanadísk\ franska",
    'fr_ch' => "svissnesk\ franska",
    'frm'   => 'miðfranska',
    'fro'   => 'fornfranska',
    'frr'   => 'norðurfrísneska',
    'frs'   => 'austurfrísneska',
    'fur'   => 'fríúlska',
    'fy'    => 'frísneska',
    'ga'    => 'írska',
    'gaa'   => 'ga',
    'gay'   => 'gajó',
    'gba'   => 'gbaja',
    'gd'    => "skosk\ gelíska",
    'gem'   => "germönsk\ mál",
    'gez'   => 'gís',
    'gil'   => 'gilberska',
    'gl'    => 'gallegska',
    'gmh'   => 'miðháþýska',
    'gn'    => 'gvaraní',
    'goh'   => 'fornháþýska',
    'gon'   => 'gondí',
    'gor'   => 'gorontaló',
    'got'   => 'gotneska',
    'grb'   => 'gerbó',
    'grc'   => 'forngríska',
    'gsw'   => "svissnesk\ þýska",
    'gu'    => 'gújaratí',
    'gv'    => 'manx',
    'gwi'   => 'gvísín',
    'ha'    => 'hása',
    'hai'   => 'haída',
    'haw'   => 'havaíska',
    'he'    => 'hebreska',
    'hi'    => 'hindí',
    'hil'   => 'híligaínon',
    'him'   => "hímasjalísk\ mál",
    'hit'   => 'hettitíska',
    'hmn'   => 'hmong',
    'ho'    => 'hírímótú',
    'hr'    => 'króatíska',
    'hsb'   => 'hásorbneska',
    'ht'    => 'haítíska',
    'hu'    => 'ungverska',
    'hup'   => 'húpa',
    'hy'    => 'armenska',
    'hz'    => 'hereró',
    'ia'    => 'interlingva',
    'iba'   => 'íban',
    'id'    => 'indónesíska',
    'ie'    => 'interlingve',
    'ig'    => 'ígbó',
    'ii'    => 'sísúanjí',
    'ijo'   => 'íjómál',
    'ik'    => 'ínúpíak',
    'ilo'   => 'ílokó',
    'inc'   => "indversk\ mál",
    'ine'   => "indóevrópsk\ mál",
    'inh'   => 'ingús',
    'io'    => 'ídó',
    'ira'   => 'íranska',
    'iro'   => "írókesk\ mál",
    'is'    => 'íslenska',
    'it'    => 'ítalska',
    'iu'    => 'inúktitút',
    'ja'    => 'japanska',
    'jbo'   => 'lojban',
    'jpr'   => 'gyðingapersneska',
    'jrb'   => 'gyðingaarabíska',
    'jv'    => 'javanska',
    'ka'    => 'georgíska',
    'kaa'   => 'karakalpak',
    'kab'   => 'kabíle',
    'kac'   => 'kasín',
    'kaj'   => 'jju',
    'kam'   => "kamba\ \(Kenya\)",
    'kar'   => "karénsk\ mál",
    'kaw'   => 'kaví',
    'kbd'   => 'kabardíska',
    'kcg'   => 'tyap',
    'kfo'   => 'koro',
    'kg'    => 'kongó',
    'kha'   => 'kasí',
    'khi'   => 'koímál',
    'kho'   => 'kotaska',
    'ki'    => 'kíkújú',
    'kj'    => 'kúanjama',
    'kk'    => 'kasakska',
    'kl'    => 'grænlenska',
    'km'    => 'kambodíska',
    'kmb'   => 'kimbúndú',
    'kn'    => 'kannada',
    'ko'    => 'kóreska',
    'kok'   => 'konkaní',
    'kos'   => 'kosraska',
    'kpe'   => 'kpèllé',
    'kr'    => 'kanúrí',
    'krc'   => 'karasaíbalkar',
    'krl'   => 'karélska',
    'kro'   => 'krúmál',
    'kru'   => 'kúrúk',
    'ks'    => 'kasmírska',
    'ku'    => 'kúrdneska',
    'kum'   => 'kúmík',
    'kut'   => 'kútenaí',
    'kv'    => 'komíska',
    'kw'    => 'korníska',
    'ky'    => 'kirgiska',
    'la'    => 'latína',
    'lad'   => 'ladínska',
    'lah'   => 'landa',
    'lam'   => 'lamba',
    'lb'    => 'lúxemborgíska',
    'lez'   => 'lesgíska',
    'lg'    => 'ganda',
    'li'    => 'limbúrgíska',
    'ln'    => 'lingala',
    'lo'    => 'laó',
    'lol'   => 'mongó',
    'loz'   => 'losí',
    'lt'    => 'litháíska',
    'lu'    => 'lúbakatanga',
    'lua'   => 'lúbalúlúa',
    'lui'   => 'lúisenó',
    'lun'   => 'lúnda',
    'luo'   => 'lúó',
    'lus'   => 'lúsaí',
    'lv'    => 'lettneska',
    'mad'   => 'madúrska',
    'mag'   => 'magahí',
    'mai'   => 'maítílí',
    'mak'   => 'makasar',
    'man'   => 'mandingó',
    'map'   => 'ástrónesíska',
    'mas'   => 'masaí',
    'mdf'   => 'moksa',
    'mdr'   => 'mandar',
    'men'   => "mende\ \(Sierra\ Leone\)",
    'mfe'   => 'Morisyen',
    'mg'    => 'malagasíska',
    'mga'   => 'miðírska',
    'mh'    => 'marshallska',
    'mi'    => 'maórí',
    'mic'   => 'miʼkmak',
    'min'   => 'mínangkabá',
    'mis'   => "\(önnur\ mál\)",
    'mk'    => 'makedónska',
    'mkh'   => 'monkmermál',
    'ml'    => 'malajalam',
    'mn'    => 'mongólska',
    'mnc'   => 'mansjú',
    'mni'   => 'manípúrí',
    'mno'   => 'manóbómál',
    'mo'    => 'moldóvska',
    'moh'   => 'móhíska',
    'mos'   => 'mossí',
    'mr'    => 'maratí',
    'ms'    => 'malaíska',
    'mt'    => 'maltneska',
    'mul'   => "\(margvísleg\ mál\)",
    'mun'   => 'múndamál',
    'mus'   => 'krík',
    'mwl'   => 'mirandesíska',
    'mwr'   => 'marvarí',
    'my'    => 'búrmíska',
    'myn'   => 'majamál',
    'myv'   => 'ersja',
    'na'    => 'nárúska',
    'nah'   => "aztekísk\ mál",
    'nai'   => "Norður\-Ameríku\ indíánamál",
    'nap'   => 'napólíska',
    'nb'    => "norskt\ bókmál",
    'nd'    => 'norðurndebele',
    'nds'   => 'lágþýska',
    'ne'    => 'nepalska',
    'new'   => 'nevaríska',
    'ng'    => 'ndonga',
    'nia'   => 'nías',
    'nic'   => 'nígerkordófanmál',
    'niu'   => 'níveska',
    'nl'    => 'hollenska',
    'nl_be' => 'flæmska',
    'nn'    => 'nýnorska',
    'no'    => 'norska',
    'nog'   => 'nógaí',
    'non'   => 'norræna',
    'nqo'   => "n\-ká",
    'nr'    => 'suðurndebele',
    'nso'   => 'norðursótó',
    'nub'   => "núbísk\ mál",
    'nv'    => 'navahó',
    'nwc'   => "klassísk\ nevaríska",
    'ny'    => 'njanja',
    'nym'   => 'njamvesí',
    'nyn'   => 'njankóle',
    'nyo'   => 'njóró',
    'nzi'   => 'nsíma',
    'oc'    => 'oksítaníska',
    'oj'    => 'ojibva',
    'om'    => 'órómó',
    'or'    => 'óría',
    'os'    => 'ossetíska',
    'osa'   => 'ósage',
    'ota'   => 'osmánska',
    'oto'   => 'ótommál',
    'pa'    => 'púnjabí',
    'paa'   => "papúsk\ mál",
    'pag'   => 'pangasinán',
    'pal'   => 'palaví',
    'pam'   => 'pampanga',
    'pap'   => 'papíamentó',
    'pau'   => 'paláska',
    'peo'   => 'fornpersneska',
    'phi'   => "filippseysk\ mál",
    'phn'   => 'fönikíska',
    'pi'    => 'palí',
    'pl'    => 'pólska',
    'pon'   => 'ponpeiska',
    'pra'   => 'prakrítmál',
    'pro'   => 'fornpróvensalska',
    'ps'    => 'pastú',
    'pt'    => 'portúgalska',
    'pt_br' => "brasílísk\ portúgalska",
    'pt_pt' => "íberísk\ portúgalska",
    'qu'    => 'kvesjúa',
    'raj'   => 'rajastaní',
    'rap'   => 'rapanúí',
    'rar'   => 'rarótongska',
    'rm'    => 'retórómanska',
    'rn'    => 'rúndí',
    'ro'    => 'rúmenska',
    'roa'   => "rómönsk\ mál",
    'rom'   => 'romaní',
    'ru'    => 'rússneska',
    'rup'   => 'arúmenska',
    'rw'    => 'kínjarvanda',
    'sa'    => 'sanskrít',
    'sad'   => 'sandave',
    'sah'   => 'jakút',
    'sai'   => "Suður\-Ameríku\ indíánamál",
    'sal'   => 'salísmál',
    'sam'   => "samversk\ arameíska",
    'sas'   => 'sasak',
    'sat'   => 'santalí',
    'sc'    => 'sardínska',
    'scn'   => 'sikileyska',
    'sco'   => 'skoska',
    'sd'    => 'sindí',
    'se'    => 'norðursamíska',
    'sel'   => 'selkúp',
    'sem'   => "semísk\ mál",
    'sg'    => 'sangó',
    'sga'   => 'fornírska',
    'sgn'   => 'táknmál',
    'sh'    => 'serbókróatíska',
    'shn'   => 'sjan',
    'si'    => 'singalesíska',
    'sid'   => 'sídamó',
    'sio'   => 'síúmál',
    'sit'   => "sínótíbesk\ mál",
    'sk'    => 'slóvakíska',
    'sl'    => 'slóvenska',
    'sla'   => "slavnesk\ mál",
    'sm'    => 'samóska',
    'sma'   => 'suðursamíska',
    'smi'   => "samísk\ mál",
    'smj'   => 'lúlesamíska',
    'smn'   => 'enaresamíska',
    'sms'   => 'skoltesamíska',
    'sn'    => 'shóna',
    'snk'   => 'sóninke',
    'so'    => 'sómalska',
    'sog'   => 'sogdíen',
    'son'   => 'songhaímál',
    'sq'    => 'albanska',
    'sr'    => 'serbneska',
    'srn'   => "sranan\ tongo",
    'srr'   => 'serer',
    'ss'    => 'svatí',
    'ssa'   => 'nílósaharamál',
    'st'    => 'suðursótó',
    'su'    => 'súndanska',
    'suk'   => 'súkúma',
    'sus'   => 'súsú',
    'sux'   => 'súmerska',
    'sv'    => 'sænska',
    'sw'    => 'svahílí',
    'syc'   => "klassisk\ sýrlenska",
    'syr'   => 'sýrlenska',
    'ta'    => 'tamílska',
    'tai'   => 'taímál',
    'te'    => 'telúgú',
    'tem'   => 'tímne',
    'ter'   => 'terenó',
    'tet'   => 'tetúm',
    'tg'    => 'tadsjikska',
    'th'    => 'taílenska',
    'ti'    => 'tígrinja',
    'tig'   => 'tígre',
    'tiv'   => 'tív',
    'tk'    => 'túrkmenska',
    'tkl'   => 'tókeláska',
    'tl'    => 'tagalog',
    'tlh'   => 'klingónska',
    'tli'   => 'tlingit',
    'tmh'   => 'tamasjek',
    'tn'    => 'tsúana',
    'to'    => "tongverska\ \(Tongaeyjar\)",
    'tog'   => "tongverska\ \(Niassa\ i\ Moçambique\)",
    'tpi'   => 'tokpisin',
    'tr'    => 'tyrkneska',
    'trv'   => 'Taroko',
    'ts'    => 'tsonga',
    'tsi'   => 'tsimsíska',
    'tt'    => 'tatarska',
    'tum'   => 'túmbúka',
    'tup'   => 'túpímál',
    'tut'   => "altaísk\ mál",
    'tvl'   => 'túvalúska',
    'tw'    => 'tví',
    'ty'    => 'tahítíska',
    'tyv'   => 'túvínska',
    'udm'   => 'údmúrt',
    'ug'    => 'úígúr',
    'uga'   => 'úgarítíska',
    'uk'    => 'úkraínska',
    'umb'   => 'úmbúndú',
    'und'   => "\(óþekkt\ mál\)",
    'ur'    => 'úrdú',
    'uz'    => 'úsbekska',
    'vai'   => 'vaí',
    've'    => 'venda',
    'vi'    => 'víetnamska',
    'vo'    => 'volapyk',
    'vot'   => 'votíska',
    'wa'    => 'vallónska',
    'wak'   => 'vakasmál',
    'wal'   => 'valamó',
    'war'   => 'varaí',
    'was'   => 'vasjó',
    'wen'   => "sorbnesk\ mál",
    'wo'    => 'volof',
    'xal'   => 'kalmúkska',
    'xh'    => 'sósa',
    'yao'   => 'jaó',
    'yap'   => 'japíska',
    'yi'    => 'jiddíska',
    'yo'    => 'jórúba',
    'ypk'   => "júpísk\ mál",
    'za'    => 'súang',
    'zap'   => 'sapótek',
    'zbl'   => 'blisstákn',
    'zen'   => 'senaga',
    'zh'    => 'kínverska',
    'znd'   => 'sande',
    'zu'    => 'súlú',
    'zun'   => 'súní',
    'zxx'   => "\(ekkert\ tungutengt\ efni\)",
    'zza'   => 'zázáíska',
);

%Locales::DB::Language::is::name_to_code = (
    'abkasíska'                                 => 'ab',
    'adangme'                                    => 'ada',
    'adýge'                                     => 'ady',
    'afríhílí'                                => 'afh',
    'afríkanska'                                => 'af',
    'afróasískmál'                            => 'afa',
    'afár'                                      => 'aa',
    'akan'                                       => 'ak',
    'akkadíska'                                 => 'akk',
    'akkíska'                                   => 'ace',
    'akólí'                                    => 'ach',
    'albanska'                                   => 'sq',
    'aleutíska'                                 => 'ale',
    'algonkvínskmál'                           => 'alg',
    'altaískmál'                               => 'tut',
    'alþjóðamál'                             => 'art',
    'amharíska'                                 => 'am',
    'angíka'                                    => 'anp',
    'apatsjamál'                                => 'apa',
    'arabíska'                                  => 'ar',
    'aragonska'                                  => 'an',
    'arapahó'                                   => 'arp',
    'aravakska'                                  => 'arw',
    'armenska'                                   => 'hy',
    'arákaníska'                               => 'arn',
    'arúmenska'                                 => 'rup',
    'aserska'                                    => 'az',
    'assameíska'                                => 'as',
    'astúríska'                                => 'ast',
    'atapaskískmál'                            => 'ath',
    'atsam'                                      => 'cch',
    'austurfrísneska'                           => 'frs',
    'austurrískþýska'                         => 'de_at',
    'avadí'                                     => 'awa',
    'avaríska'                                  => 'av',
    'avestíska'                                 => 'ae',
    'aztekískmál'                              => 'nah',
    'aímara'                                    => 'ay',
    'aínujapan'                                 => 'ain',
    'baltneskmál'                               => 'bat',
    'balíska'                                   => 'ban',
    'balúkí'                                   => 'bal',
    'bambara'                                    => 'bm',
    'bamilékískmál'                           => 'bai',
    'bandarískenska'                            => 'en_us',
    'bandasmál'                                 => 'bad',
    'bantúmál'                                 => 'bnt',
    'basakamerun'                                => 'bas',
    'baskneska'                                  => 'eu',
    'baskír'                                    => 'ba',
    'batakmál'                                  => 'btk',
    'beja'                                       => 'bej',
    'bembazambia'                                => 'bem',
    'bengalska'                                  => 'bn',
    'berbamál'                                  => 'ber',
    'bidayuhmál'                                => 'day',
    'blisstákn'                                 => 'zbl',
    'blín'                                      => 'byn',
    'bojpúrí'                                  => 'bho',
    'bosníska'                                  => 'bs',
    'brasílískportúgalska'                    => 'pt_br',
    'braí'                                      => 'bra',
    'breskenska'                                 => 'en_gb',
    'bretónska'                                 => 'br',
    'bícolano'                                  => 'bik',
    'bíharískmál'                             => 'bh',
    'bíní'                                     => 'bin',
    'bíslama'                                   => 'bi',
    'búgíska'                                  => 'bug',
    'búlgarska'                                 => 'bg',
    'búrmíska'                                 => 'my',
    'búríat'                                   => 'bua',
    'dakóta'                                    => 'dak',
    'danska'                                     => 'da',
    'dargva'                                     => 'dar',
    'delaver'                                    => 'del',
    'dinka'                                      => 'din',
    'djúla'                                     => 'dyu',
    'dogrikangri'                                => 'doi',
    'dogríb'                                    => 'dgr',
    'dravidískmál'                             => 'dra',
    'dsongka'                                    => 'dz',
    'dívehí'                                   => 'dv',
    'dúala'                                     => 'dua',
    'efík'                                      => 'efi',
    'eistneska'                                  => 'et',
    'ekajúk'                                    => 'eka',
    'ekkerttungutengtefni'                       => 'zxx',
    'elamít'                                    => 'elx',
    'enaresamíska'                              => 'smn',
    'enska'                                      => 'en',
    'ersja'                                      => 'myv',
    'esperantó'                                 => 'eo',
    'eve'                                        => 'ee',
    'evondó'                                    => 'ewo',
    'fang'                                       => 'fan',
    'fantí'                                     => 'fat',
    'filippseyskmál'                            => 'phi',
    'filipínska'                                => 'fil',
    'finnska'                                    => 'fi',
    'finnskúgrískmál'                         => 'fiu',
    'flæmska'                                   => 'nl_be',
    'fornegypska'                                => 'egy',
    'fornenska'                                  => 'ang',
    'fornfranska'                                => 'fro',
    'forngríska'                                => 'grc',
    'fornháþýska'                             => 'goh',
    'fornpersneska'                              => 'peo',
    'fornpróvensalska'                          => 'pro',
    'fornírska'                                 => 'sga',
    'franska'                                    => 'fr',
    'frísneska'                                 => 'fy',
    'fríúlska'                                 => 'fur',
    'fulfulde'                                   => 'ff',
    'færeyska'                                  => 'fo',
    'fídjeyska'                                 => 'fj',
    'fón'                                       => 'fon',
    'fönikíska'                                => 'phn',
    'ga'                                         => 'gaa',
    'gajó'                                      => 'gay',
    'galibíska'                                 => 'car',
    'gallegska'                                  => 'gl',
    'ganda'                                      => 'lg',
    'gbaja'                                      => 'gba',
    'georgíska'                                 => 'ka',
    'gerbó'                                     => 'grb',
    'germönskmál'                              => 'gem',
    'gilberska'                                  => 'gil',
    'gondí'                                     => 'gon',
    'gorontaló'                                 => 'gor',
    'gotneska'                                   => 'got',
    'grænlenska'                                => 'kl',
    'gríska'                                    => 'el',
    'gvaraní'                                   => 'gn',
    'gvísín'                                   => 'gwi',
    'gyðingaarabíska'                          => 'jrb',
    'gyðingapersneska'                          => 'jpr',
    'gís'                                       => 'gez',
    'gújaratí'                                 => 'gu',
    'havaíska'                                  => 'haw',
    'haída'                                     => 'hai',
    'haítíska'                                 => 'ht',
    'hebreska'                                   => 'he',
    'hereró'                                    => 'hz',
    'hettitíska'                                => 'hit',
    'hindí'                                     => 'hi',
    'hmong'                                      => 'hmn',
    'hollenska'                                  => 'nl',
    'hvítrússneska'                            => 'be',
    'hása'                                      => 'ha',
    'hásorbneska'                               => 'hsb',
    'híligaínon'                               => 'hil',
    'hímasjalískmál'                          => 'him',
    'hírímótú'                               => 'ho',
    'húpa'                                      => 'hup',
    'indverskmál'                               => 'inc',
    'indóevrópskmál'                          => 'ine',
    'indónesíska'                              => 'id',
    'ingús'                                     => 'inh',
    'interlingva'                                => 'ia',
    'interlingve'                                => 'ie',
    'inúktitút'                                => 'iu',
    'jakút'                                     => 'sah',
    'japanska'                                   => 'ja',
    'japíska'                                   => 'yap',
    'javanska'                                   => 'jv',
    'jaó'                                       => 'yao',
    'jiddíska'                                  => 'yi',
    'jju'                                        => 'kaj',
    'jórúba'                                   => 'yo',
    'júpískmál'                               => 'ypk',
    'kabardíska'                                => 'kbd',
    'kabíle'                                    => 'kab',
    'kaddó'                                     => 'cad',
    'kalmúkska'                                 => 'xal',
    'kambakenya'                                 => 'kam',
    'kambodíska'                                => 'km',
    'kamorró'                                   => 'ch',
    'kamískmál'                                => 'cmc',
    'kanadískenska'                             => 'en_ca',
    'kanadískfranska'                           => 'fr_ca',
    'kannada'                                    => 'kn',
    'kanúrí'                                   => 'kr',
    'karakalpak'                                 => 'kaa',
    'karasaíbalkar'                             => 'krc',
    'karélska'                                  => 'krl',
    'karénskmál'                               => 'kar',
    'kasakska'                                   => 'kk',
    'kasmírska'                                 => 'ks',
    'kasí'                                      => 'kha',
    'kasín'                                     => 'kac',
    'kasúbíska'                                => 'csb',
    'katalónska'                                => 'ca',
    'kaví'                                      => 'kaw',
    'kebúanó'                                  => 'ceb',
    'keltneskmál'                               => 'cel',
    'kimbúndú'                                 => 'kmb',
    'kirgiska'                                   => 'ky',
    'kirkjuslavneska'                            => 'cu',
    'klassisksýrlenska'                         => 'syc',
    'klassísknevaríska'                        => 'nwc',
    'klingónska'                                => 'tlh',
    'komíska'                                   => 'kv',
    'kongó'                                     => 'kg',
    'konkaní'                                   => 'kok',
    'koptíska'                                  => 'cop',
    'korníska'                                  => 'kw',
    'koro'                                       => 'kfo',
    'korsíska'                                  => 'co',
    'kosraska'                                   => 'kos',
    'kotaska'                                    => 'kho',
    'koímál'                                   => 'khi',
    'kpèllé'                                   => 'kpe',
    'kreóleðapidginmál'                       => 'crp',
    'kreóleðapidginmáláenskumgrunni'         => 'cpe',
    'kreóleðapidginmáláfrönskumgrunni'      => 'cpf',
    'kreóleðapidginmáláportúgölskumgrunni' => 'cpp',
    'krí'                                       => 'cr',
    'krík'                                      => 'mus',
    'krímtyrkneska'                             => 'crh',
    'króatíska'                                => 'hr',
    'krúmál'                                   => 'kro',
    'kvesjúa'                                   => 'qu',
    'kákasusmál'                               => 'cau',
    'kíkújú'                                  => 'ki',
    'kínjarvanda'                               => 'rw',
    'kínverska'                                 => 'zh',
    'kóreska'                                   => 'ko',
    'kúanjama'                                  => 'kj',
    'kúmík'                                    => 'kum',
    'kúrdneska'                                 => 'ku',
    'kúrúk'                                    => 'kru',
    'kúsitískmál'                             => 'cus',
    'kútenaí'                                  => 'kut',
    'ladínska'                                  => 'lad',
    'lamba'                                      => 'lam',
    'landa'                                      => 'lah',
    'latína'                                    => 'la',
    'laó'                                       => 'lo',
    'lesgíska'                                  => 'lez',
    'lettneska'                                  => 'lv',
    'limbúrgíska'                              => 'li',
    'lingala'                                    => 'ln',
    'litháíska'                                => 'lt',
    'lojban'                                     => 'jbo',
    'losí'                                      => 'loz',
    'lágsorbneska'                              => 'dsb',
    'lágþýska'                                => 'nds',
    'lúbakatanga'                               => 'lu',
    'lúbalúlúa'                               => 'lua',
    'lúisenó'                                  => 'lui',
    'lúlesamíska'                              => 'smj',
    'lúnda'                                     => 'lun',
    'lúsaí'                                    => 'lus',
    'lúxemborgíska'                            => 'lb',
    'lúó'                                      => 'luo',
    'madúrska'                                  => 'mad',
    'magahí'                                    => 'mag',
    'majamál'                                   => 'myn',
    'makasar'                                    => 'mak',
    'makedónska'                                => 'mk',
    'malagasíska'                               => 'mg',
    'malajalam'                                  => 'ml',
    'malaíska'                                  => 'ms',
    'maltneska'                                  => 'mt',
    'mandar'                                     => 'mdr',
    'mandingó'                                  => 'man',
    'mansjú'                                    => 'mnc',
    'manx'                                       => 'gv',
    'manípúrí'                                => 'mni',
    'manóbómál'                               => 'mno',
    'maratí'                                    => 'mr',
    'margvíslegmál'                            => 'mul',
    'marshallska'                                => 'mh',
    'marvarí'                                   => 'mwr',
    'marískarusland'                            => 'chm',
    'masaí'                                     => 'mas',
    'maítílí'                                 => 'mai',
    'maórí'                                    => 'mi',
    'mendesierraleone'                           => 'men',
    'mirandesíska'                              => 'mwl',
    'miðameríkuindíánamál'                  => 'cai',
    'miðenska'                                  => 'enm',
    'miðfranska'                                => 'frm',
    'miðhollenska'                              => 'dum',
    'miðháþýska'                             => 'gmh',
    'miðírska'                                 => 'mga',
    'miʼkmak'                                   => 'mic',
    'moksa'                                      => 'mdf',
    'moldóvska'                                 => 'mo',
    'mongó'                                     => 'lol',
    'mongólska'                                 => 'mn',
    'monkmermál'                                => 'mkh',
    'morisyen'                                   => 'mfe',
    'mossí'                                     => 'mos',
    'mínangkabá'                               => 'min',
    'móhíska'                                  => 'moh',
    'múndamál'                                 => 'mun',
    'napólíska'                                => 'nap',
    'navahó'                                    => 'nv',
    'ndonga'                                     => 'ng',
    'nepalska'                                   => 'ne',
    'nevaríska'                                 => 'new',
    'njamvesí'                                  => 'nym',
    'njanja'                                     => 'ny',
    'njankóle'                                  => 'nyn',
    'njóró'                                    => 'nyo',
    'nká'                                       => 'nqo',
    'norræna'                                   => 'non',
    'norska'                                     => 'no',
    'norsktbókmál'                             => 'nb',
    'norðurameríkuindíánamál'               => 'nai',
    'norðurfrísneska'                          => 'frr',
    'norðurndebele'                             => 'nd',
    'norðursamíska'                            => 'se',
    'norðursótó'                              => 'nso',
    'nsíma'                                     => 'nzi',
    'nárúska'                                  => 'na',
    'nías'                                      => 'nia',
    'nígerkordófanmál'                        => 'nic',
    'nílósaharamál'                           => 'ssa',
    'níveska'                                   => 'niu',
    'nógaí'                                    => 'nog',
    'núbískmál'                               => 'nub',
    'nýnorska'                                  => 'nn',
    'officiellarameíska'                        => 'arc',
    'ojibva'                                     => 'oj',
    'oksítaníska'                              => 'oc',
    'osmánska'                                  => 'ota',
    'ossetíska'                                 => 'os',
    'palaví'                                    => 'pal',
    'paláska'                                   => 'pau',
    'palí'                                      => 'pi',
    'pampanga'                                   => 'pam',
    'pangasinán'                                => 'pag',
    'papíamentó'                               => 'pap',
    'papúskmál'                                => 'paa',
    'pastú'                                     => 'ps',
    'persneska'                                  => 'fa',
    'ponpeiska'                                  => 'pon',
    'portúgalska'                               => 'pt',
    'prakrítmál'                               => 'pra',
    'pólska'                                    => 'pl',
    'púnjabí'                                  => 'pa',
    'rajastaní'                                 => 'raj',
    'rapanúí'                                  => 'rap',
    'rarótongska'                               => 'rar',
    'retórómanska'                             => 'rm',
    'romaní'                                    => 'rom',
    'rómönskmál'                              => 'roa',
    'rúmenska'                                  => 'ro',
    'rúndí'                                    => 'rn',
    'rússneska'                                 => 'ru',
    'salísmál'                                 => 'sal',
    'samverskarameíska'                         => 'sam',
    'samískmál'                                => 'smi',
    'samóska'                                   => 'sm',
    'sandave'                                    => 'sad',
    'sande'                                      => 'znd',
    'sangó'                                     => 'sg',
    'sanskrít'                                  => 'sa',
    'santalí'                                   => 'sat',
    'sapótek'                                   => 'zap',
    'sardínska'                                 => 'sc',
    'sasak'                                      => 'sas',
    'selkúp'                                    => 'sel',
    'semískmál'                                => 'sem',
    'senaga'                                     => 'zen',
    'serbneska'                                  => 'sr',
    'serbókróatíska'                          => 'sh',
    'serer'                                      => 'srr',
    'shóna'                                     => 'sn',
    'sikileyska'                                 => 'scn',
    'siksika'                                    => 'bla',
    'sindí'                                     => 'sd',
    'singalesíska'                              => 'si',
    'sjagataí'                                  => 'chg',
    'sjan'                                       => 'shn',
    'sjerókí'                                  => 'chr',
    'sjeyen'                                     => 'chy',
    'sjoktá'                                    => 'cho',
    'sjúkíska'                                 => 'chk',
    'sjúvas'                                    => 'cv',
    'skoltesamíska'                             => 'sms',
    'skoska'                                     => 'sco',
    'skoskgelíska'                              => 'gd',
    'slavneskmál'                               => 'sla',
    'slavéj'                                    => 'den',
    'slóvakíska'                               => 'sk',
    'slóvenska'                                 => 'sl',
    'sogdíen'                                   => 'sog',
    'songhaímál'                               => 'son',
    'sorbneskmál'                               => 'wen',
    'spænska'                                   => 'es',
    'sranantongo'                                => 'srn',
    'suðuraltaíska'                            => 'alt',
    'suðurameríkuindíánamál'                => 'sai',
    'suðurndebele'                              => 'nr',
    'suðursamíska'                             => 'sma',
    'suðursótó'                               => 'st',
    'svahílí'                                  => 'sw',
    'svatí'                                     => 'ss',
    'svissneskfranska'                           => 'fr_ch',
    'svissneskháþýska'                        => 'de_ch',
    'svissneskþýska'                           => 'gsw',
    'sænska'                                    => 'sv',
    'síbsja'                                    => 'chb',
    'sídamó'                                   => 'sid',
    'sínótíbeskmál'                          => 'sit',
    'sínúkpidginenska'                         => 'chn',
    'sípevíska'                                => 'chp',
    'sísúanjí'                                => 'ii',
    'síúmál'                                  => 'sio',
    'sómalska'                                  => 'so',
    'sóninke'                                   => 'snk',
    'sósa'                                      => 'xh',
    'súang'                                     => 'za',
    'súkúma'                                   => 'suk',
    'súlú'                                     => 'zu',
    'súmerska'                                  => 'sux',
    'súndanska'                                 => 'su',
    'súní'                                     => 'zun',
    'súsú'                                     => 'sus',
    'sýrlenska'                                 => 'syr',
    'tadsjikska'                                 => 'tg',
    'tagalog'                                    => 'tl',
    'tahítíska'                                => 'ty',
    'tamasjek'                                   => 'tmh',
    'tamílska'                                  => 'ta',
    'taroko'                                     => 'trv',
    'tatarska'                                   => 'tt',
    'taílenska'                                 => 'th',
    'taímál'                                   => 'tai',
    'telúgú'                                   => 'te',
    'terenó'                                    => 'ter',
    'tetúm'                                     => 'tet',
    'tlingit'                                    => 'tli',
    'tokpisin'                                   => 'tpi',
    'tongverskaniassaimoçambique'               => 'tog',
    'tongverskatongaeyjar'                       => 'to',
    'tsimsíska'                                 => 'tsi',
    'tsjetsjenska'                               => 'ce',
    'tsonga'                                     => 'ts',
    'tsúana'                                    => 'tn',
    'tví'                                       => 'tw',
    'tyap'                                       => 'kcg',
    'tyrkneska'                                  => 'tr',
    'táknmál'                                  => 'sgn',
    'tékkneska'                                 => 'cs',
    'tíbeska'                                   => 'bo',
    'tígre'                                     => 'tig',
    'tígrinja'                                  => 'ti',
    'tímne'                                     => 'tem',
    'tív'                                       => 'tiv',
    'tókeláska'                                => 'tkl',
    'túmbúka'                                  => 'tum',
    'túpímál'                                 => 'tup',
    'túrkmenska'                                => 'tk',
    'túvalúska'                                => 'tvl',
    'túvínska'                                 => 'tyv',
    'ungverska'                                  => 'hu',
    'vakasmál'                                  => 'wak',
    'valamó'                                    => 'wal',
    'vallónska'                                 => 'wa',
    'varaí'                                     => 'war',
    'vasjó'                                     => 'was',
    'vaí'                                       => 'vai',
    'velska'                                     => 'cy',
    'venda'                                      => 've',
    'volapyk'                                    => 'vo',
    'volof'                                      => 'wo',
    'votíska'                                   => 'vot',
    'víetnamska'                                => 'vi',
    'zázáíska'                                => 'zza',
    'ástrónesíska'                            => 'map',
    'áströlskenska'                            => 'en_au',
    'áströlskmál'                             => 'aus',
    'íban'                                      => 'iba',
    'íberískportúgalska'                      => 'pt_pt',
    'íberískspænska'                          => 'es_es',
    'ídó'                                      => 'io',
    'ígbó'                                     => 'ig',
    'íjómál'                                  => 'ijo',
    'ílokó'                                    => 'ilo',
    'ínúpíak'                                 => 'ik',
    'íranska'                                   => 'ira',
    'írska'                                     => 'ga',
    'írókeskmál'                              => 'iro',
    'íslenska'                                  => 'is',
    'ítalska'                                   => 'it',
    'óría'                                     => 'or',
    'órómó'                                   => 'om',
    'ósage'                                     => 'osa',
    'ótommál'                                  => 'oto',
    'óþekktmál'                               => 'und',
    'önnurmál'                                 => 'mis',
    'údmúrt'                                   => 'udm',
    'úgarítíska'                              => 'uga',
    'úkraínska'                                => 'uk',
    'úmbúndú'                                 => 'umb',
    'úrdú'                                     => 'ur',
    'úsbekska'                                  => 'uz',
    'úígúr'                                   => 'ug',
    'þýska'                                    => 'de',
);

1;
