package Locales::DB::Language::so;

# Auto generated from CLDR

$Locales::DB::Language::so::VERSION = '0.01';

$Locales::DB::Language::so::cldr_version = '1.7.1';

%Locales::DB::Language::so::misc_info = (
    'cldr_formats' => {
        'decimal'   => "\#\,\#\#0\.\#\#\#",
        'language'  => "Language\:\ \{0\}",
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0\%",
        'territory' => "Region\:\ \{0\}"
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'posix' => {
        'nostr'  => "maya\:m",
        'yesstr' => "haa\:h"
    },
);

%Locales::DB::Language::so::code_to_name = (
    'aa'    => 'Afar',
    'ab'    => 'Abkhazian',
    'ace'   => 'Achinese',
    'ach'   => 'Acoli',
    'ada'   => 'Adangme',
    'ady'   => 'Adyghe',
    'ae'    => 'Avestan',
    'af'    => 'Afrikaanays',
    'afa'   => "Afro\-Asiatic\ Language",
    'afh'   => 'Afrihili',
    'ain'   => 'Ainu',
    'ak'    => 'Akan',
    'akk'   => 'Akkadian',
    'ale'   => 'Aleut',
    'alg'   => "Algonquian\ Language",
    'alt'   => "Southern\ Altai",
    'am'    => 'Amhari',
    'an'    => 'Aragonese',
    'ang'   => "Old\ English",
    'anp'   => 'Angika',
    'apa'   => "Apache\ Language",
    'ar'    => 'Carabi',
    'arc'   => 'Aramaic',
    'arn'   => 'Araucanian',
    'arp'   => 'Arapaho',
    'art'   => "Artificial\ Language",
    'arw'   => 'Arawak',
    'as'    => 'Asaamiis',
    'ast'   => 'Asturian',
    'ath'   => "Athapascan\ Language",
    'aus'   => "Australian\ Language",
    'av'    => 'Avaric',
    'awa'   => 'Awadhi',
    'ay'    => 'Aymara',
    'az'    => 'Azerbaijan',
    'ba'    => 'Bashkir',
    'bad'   => 'Banda',
    'bai'   => "Bamileke\ Language",
    'bal'   => 'Baluchi',
    'ban'   => 'Balinese',
    'bas'   => 'Basa',
    'bat'   => "Baltic\ Language",
    'be'    => 'Beleruusiyaan',
    'bej'   => 'Beja',
    'bem'   => 'Bemba',
    'ber'   => 'Berber',
    'bg'    => 'Bulgeeriyaan',
    'bh'    => 'Bixaari',
    'bho'   => 'Bhojpuri',
    'bi'    => 'Bislama',
    'bik'   => 'Bikol',
    'bin'   => 'Bini',
    'bla'   => 'Siksika',
    'bm'    => 'Bambara',
    'bn'    => 'Bangaali',
    'bnt'   => 'Bantu',
    'bo'    => 'Tibetan',
    'br'    => 'Bereton',
    'bra'   => 'Braj',
    'bs'    => 'Boosniya',
    'btk'   => 'Batak',
    'bua'   => 'Buriat',
    'bug'   => 'Buginese',
    'byn'   => 'Blin',
    'ca'    => 'Katalaan',
    'cad'   => 'Caddo',
    'cai'   => "Central\ American\ Indian\ Language",
    'car'   => 'Carib',
    'cau'   => "Caucasian\ Language",
    'cch'   => 'Atsam',
    'ce'    => 'Chechen',
    'ceb'   => 'Cebuano',
    'cel'   => "Celtic\ Language",
    'ch'    => 'Chamorro',
    'chb'   => 'Chibcha',
    'chg'   => 'Chagatai',
    'chk'   => 'Chuukese',
    'chm'   => 'Mari',
    'chn'   => "Chinook\ Jargon",
    'cho'   => 'Choctaw',
    'chp'   => 'Chipewyan',
    'chr'   => 'Cherokee',
    'chy'   => 'Cheyenne',
    'cmc'   => "Chamic\ Language",
    'co'    => 'Corsican',
    'cop'   => 'Coptic',
    'cpe'   => "English\-based\ Creole\ or\ Pidgin",
    'cpf'   => "French\-based\ Creole\ or\ Pidgin",
    'cpp'   => "Portuguese\-based\ Creole\ or\ Pidgin",
    'cr'    => 'Cree',
    'crh'   => "Crimean\ Turkish",
    'crp'   => "Creole\ or\ Pidgin",
    'cs'    => 'Jeeg',
    'csb'   => 'Kashubian',
    'cu'    => "Church\ Slavic",
    'cus'   => "Cushitic\ Language",
    'cv'    => 'Chuvash',
    'cy'    => 'Welsh',
    'da'    => 'Danmarkays',
    'dak'   => 'Dakota',
    'dar'   => 'Dargwa',
    'day'   => 'Dayak',
    'de'    => 'Jarmal',
    'de_at' => "Austrian\ German",
    'de_ch' => "Jarmal\ \(Iswiiserlaand\)",
    'del'   => 'Delaware',
    'den'   => 'Slave',
    'dgr'   => 'Dogrib',
    'din'   => 'Dinka',
    'doi'   => 'Dogri',
    'dra'   => "Dravidian\ Language",
    'dsb'   => "Lower\ Sorbian",
    'dua'   => 'Duala',
    'dum'   => "Middle\ Dutch",
    'dv'    => 'Divehi',
    'dyu'   => 'Dyula',
    'dz'    => 'Dzongkha',
    'ee'    => 'Ewe',
    'efi'   => 'Efik',
    'egy'   => "Ancient\ Egyptian",
    'eka'   => 'Ekajuk',
    'el'    => 'Giriik',
    'elx'   => 'Elamite',
    'en'    => 'Ingiriisi',
    'en_au' => "Australian\ English",
    'en_ca' => "Canadian\ English",
    'en_gb' => "Ingiriisi\ \(Boqortooyada\ Midowday\)",
    'en_us' => "Ingiriisi\ \(Maraykan\)",
    'enm'   => "Middle\ English",
    'eo'    => 'Isberento',
    'es'    => 'Isbaanish',
    'es_es' => "Isbaanish\ \(Isbayn\)",
    'et'    => 'Istooniyaan',
    'eu'    => 'Basquu',
    'ewo'   => 'Ewondo',
    'fa'    => 'Faarisi',
    'fan'   => 'Fang',
    'fat'   => 'Fanti',
    'ff'    => 'Fulah',
    'fi'    => 'Fiinlaandees',
    'fil'   => 'Tagalog',
    'fiu'   => "Finno\-Ugrian\ Language",
    'fj'    => 'Fijian',
    'fo'    => 'Farowsi',
    'fon'   => 'Fon',
    'fr'    => 'Faransiis',
    'fr_ca' => "Canadian\ French",
    'fr_ch' => "Faransiis\ \(Iswiiserlaand\)",
    'frm'   => "Middle\ French",
    'fro'   => "Old\ French",
    'frr'   => "Northern\ Frisian",
    'frs'   => "Eastern\ Frisian",
    'fur'   => 'Friulian',
    'fy'    => "Firiisiyan\ Galbeed",
    'ga'    => 'Ayrish',
    'gaa'   => 'Ga',
    'gay'   => 'Gayo',
    'gba'   => 'Gbaya',
    'gd'    => "Iskot\ Giilik",
    'gem'   => "Germanic\ Language",
    'gez'   => 'Geez',
    'gil'   => 'Gilbertese',
    'gl'    => 'Galiisiyaan',
    'gmh'   => "Middle\ High\ German",
    'gn'    => 'Guraani',
    'goh'   => "Old\ High\ German",
    'gon'   => 'Gondi',
    'gor'   => 'Gorontalo',
    'got'   => 'Gothic',
    'grb'   => 'Grebo',
    'grc'   => "Ancient\ Greek",
    'gsw'   => "Swiss\ German",
    'gu'    => 'Gujaraati',
    'gv'    => 'Manx',
    'gwi'   => "Gwich\Ê\¼in",
    'ha'    => 'Hausa',
    'hai'   => 'Haida',
    'haw'   => 'Hawaiian',
    'he'    => 'Cibri',
    'hi'    => 'Hindi',
    'hil'   => 'Hiligaynon',
    'him'   => 'Himachali',
    'hit'   => 'Hittite',
    'hmn'   => 'Hmong',
    'ho'    => "Hiri\ Motu",
    'hr'    => "Koro\'eeshiyaan",
    'hsb'   => "Upper\ Sorbian",
    'ht'    => 'Haitian',
    'hu'    => 'Hangariyaan',
    'hup'   => 'Hupa',
    'hy'    => 'Armeeniyaan',
    'hz'    => 'Herero',
    'ia'    => 'Interlinguwa',
    'iba'   => 'Iban',
    'id'    => 'Indunuusiyaan',
    'ie'    => 'Interlingue',
    'ig'    => 'Igbo',
    'ii'    => "Sichuan\ Yi",
    'ijo'   => 'Ijo',
    'ik'    => 'Inupiaq',
    'ilo'   => 'Iloko',
    'inc'   => "Indic\ Language",
    'ine'   => "Indo\-European\ Language",
    'inh'   => 'Ingush',
    'io'    => 'Ido',
    'ira'   => "Iranian\ Language",
    'iro'   => "Iroquoian\ Language",
    'is'    => 'Ayslandays',
    'it'    => 'Talyaani',
    'iu'    => 'Inuktitut',
    'ja'    => 'Jabbaaniis',
    'jbo'   => 'Lojban',
    'jpr'   => "Judeo\-Persian",
    'jrb'   => "Judeo\-Arabic",
    'jv'    => 'Jafaaniis',
    'ka'    => 'Joorijiyaan',
    'kaa'   => "Kara\-Kalpak",
    'kab'   => 'Kabyle',
    'kac'   => 'Kachin',
    'kaj'   => 'Jju',
    'kam'   => 'Kamba',
    'kar'   => 'Karen',
    'kaw'   => 'Kawi',
    'kbd'   => 'Kabardian',
    'kcg'   => 'Tyap',
    'kfo'   => 'Koro',
    'kg'    => 'Kongo',
    'kha'   => 'Khasi',
    'khi'   => "Khoisan\ Language",
    'kho'   => 'Khotanese',
    'ki'    => 'Kikuyu',
    'kj'    => 'Kuanyama',
    'kk'    => 'Kazakh',
    'kl'    => 'Kalaallisut',
    'km'    => 'Kamboodhian',
    'kmb'   => 'Kimbundu',
    'kn'    => 'Kannadays',
    'ko'    => 'Kuuriyaan',
    'kok'   => 'Konkani',
    'kos'   => 'Kosraean',
    'kpe'   => 'Kpelle',
    'kr'    => 'Kanuri',
    'krc'   => "Karachay\-Balkar",
    'krl'   => 'Karelian',
    'kro'   => 'Kru',
    'kru'   => 'Kurukh',
    'ks'    => 'Kashmiri',
    'ku'    => 'Kurdishka',
    'kum'   => 'Kumyk',
    'kut'   => 'Kutenai',
    'kv'    => 'Komi',
    'kw'    => 'Cornish',
    'ky'    => 'Kirgiis',
    'la'    => 'Laatiin',
    'lad'   => 'Ladino',
    'lah'   => 'Lahnda',
    'lam'   => 'Lamba',
    'lb'    => 'Luxembourgish',
    'lez'   => 'Lezghian',
    'lg'    => 'Ganda',
    'li'    => 'Limburgish',
    'ln'    => 'Lingala',
    'lo'    => 'Laothian',
    'lol'   => 'Mongo',
    'loz'   => 'Lozi',
    'lt'    => 'Lituwaanays',
    'lu'    => "Luba\-Katanga",
    'lua'   => "Luba\-Lulua",
    'lui'   => 'Luiseno',
    'lun'   => 'Lunda',
    'luo'   => 'Luo',
    'lus'   => 'Lushai',
    'lv'    => 'Laatfiyaan',
    'mad'   => 'Madurese',
    'mag'   => 'Magahi',
    'mai'   => 'Maithili',
    'mak'   => 'Makasar',
    'man'   => 'Mandingo',
    'map'   => "Austronesian\ Language",
    'mas'   => 'Masai',
    'mdf'   => 'Moksha',
    'mdr'   => 'Mandar',
    'men'   => 'Mende',
    'mfe'   => 'Morisyen',
    'mg'    => 'Malagasy',
    'mga'   => "Middle\ Irish",
    'mh'    => 'Marshallese',
    'mi'    => 'Maori',
    'mic'   => 'Micmac',
    'min'   => 'Minangkabau',
    'mis'   => "Miscellaneous\ Language",
    'mk'    => 'Masadooniyaan',
    'mkh'   => "Mon\-Khmer\ Language",
    'ml'    => 'Malayalam',
    'mn'    => 'Mangooli',
    'mnc'   => 'Manchu',
    'mni'   => 'Manipuri',
    'mno'   => "Manobo\ Language",
    'mo'    => 'Moldavian',
    'moh'   => 'Mohawk',
    'mos'   => 'Mossi',
    'mr'    => 'Maarati',
    'ms'    => 'Malaay',
    'mt'    => 'Maltiis',
    'mul'   => "Multiple\ Languages",
    'mun'   => "Munda\ Language",
    'mus'   => 'Creek',
    'mwl'   => 'Mirandese',
    'mwr'   => 'Marwari',
    'my'    => 'Burmese',
    'myn'   => "Mayan\ Language",
    'myv'   => 'Erzya',
    'na'    => 'Nauru',
    'nah'   => 'Nahuatl',
    'nai'   => "North\ American\ Indian\ Language",
    'nap'   => 'Neapolitan',
    'nb'    => "Norwegian\ Bokm\Ã\¥l",
    'nd'    => "North\ Ndebele",
    'nds'   => "Low\ German",
    'ne'    => 'Nebaali',
    'new'   => 'Newari',
    'ng'    => 'Ndonga',
    'nia'   => 'Nias',
    'nic'   => "Niger\-Kordofanian\ Language",
    'niu'   => 'Niuean',
    'nl'    => 'Holandays',
    'nl_be' => 'Flemish',
    'nn'    => "Nowrwejiyan\ \(naynoroski\)",
    'no'    => "Af\ Noorwiijiyaan",
    'nog'   => 'Nogai',
    'non'   => "Old\ Norse",
    'nqo'   => "N\â\\Ko",
    'nr'    => "South\ Ndebele",
    'nso'   => "Northern\ Sotho",
    'nub'   => "Nubian\ Language",
    'nv'    => 'Navajo',
    'nwc'   => "Classical\ Newari",
    'ny'    => 'Nyanja',
    'nym'   => 'Nyamwezi',
    'nyn'   => 'Nyankole',
    'nyo'   => 'Nyoro',
    'nzi'   => 'Nzima',
    'oc'    => 'Okitaan',
    'oj'    => 'Ojibwa',
    'om'    => 'Oromo',
    'or'    => 'Oriya',
    'os'    => 'Ossetic',
    'osa'   => 'Osage',
    'ota'   => "Ottoman\ Turkish",
    'oto'   => "Otomian\ Language",
    'pa'    => 'Bunjaabi',
    'paa'   => "Papuan\ Language",
    'pag'   => 'Pangasinan',
    'pal'   => 'Pahlavi',
    'pam'   => 'Pampanga',
    'pap'   => 'Papiamento',
    'pau'   => 'Palauan',
    'peo'   => "Old\ Persian",
    'phi'   => "Philippine\ Language",
    'phn'   => 'Phoenician',
    'pi'    => 'Pali',
    'pl'    => 'Boolish',
    'pon'   => 'Pohnpeian',
    'pra'   => "Prakrit\ Language",
    'pro'   => "Old\ Proven\Ã\§al",
    'ps'    => 'Bashtuu',
    'pt'    => 'Boortaqiis',
    'pt_br' => "Boortaqiiska\ Baraasiil",
    'pt_pt' => "Boortaqiis\ \(Boortuqaal\)",
    'qu'    => 'Quechua',
    'raj'   => 'Rajasthani',
    'rap'   => 'Rapanui',
    'rar'   => 'Rarotongan',
    'rm'    => "Rhaeto\-Romance",
    'rn'    => 'Rundi',
    'ro'    => 'Romanka',
    'roa'   => "Romance\ Language",
    'rom'   => 'Romany',
    'ru'    => 'Ruush',
    'rup'   => 'Aromanian',
    'rw'    => 'Kinyarwanda',
    'sa'    => 'Sanskrit',
    'sad'   => 'Sandawe',
    'sah'   => 'Yakut',
    'sai'   => "South\ American\ Indian\ Language",
    'sal'   => "Salishan\ Language",
    'sam'   => "Samaritan\ Aramaic",
    'sas'   => 'Sasak',
    'sat'   => 'Santali',
    'sc'    => 'Sardinian',
    'scn'   => 'Sicilian',
    'sco'   => 'Scots',
    'sd'    => 'SINDHI',
    'se'    => "Northern\ Sami",
    'sel'   => 'Selkup',
    'sem'   => "Semitic\ Language",
    'sg'    => 'Sango',
    'sga'   => "Old\ Irish",
    'sgn'   => "Sign\ Language",
    'sh'    => 'Serbiyaan',
    'shn'   => 'Shan',
    'si'    => 'Sinhaleys',
    'sid'   => 'Sidamo',
    'sio'   => "Siouan\ Language",
    'sit'   => "Sino\-Tibetan\ Language",
    'sk'    => 'Isloofaak',
    'sl'    => 'Islofeeniyaan',
    'sla'   => "Slavic\ Language",
    'sm'    => 'Samoan',
    'sma'   => "Southern\ Sami",
    'smi'   => "Sami\ Language",
    'smj'   => "Lule\ Sami",
    'smn'   => "Inari\ Sami",
    'sms'   => "Skolt\ Sami",
    'sn'    => 'Shona',
    'snk'   => 'Soninke',
    'so'    => 'Soomaali',
    'sog'   => 'Sogdien',
    'son'   => 'Songhai',
    'sq'    => 'Albaaniyaan',
    'sr'    => 'Seerbiyaan',
    'srn'   => "Sranan\ Tongo",
    'srr'   => 'Serer',
    'ss'    => 'Swati',
    'ssa'   => "Nilo\-Saharan\ Language",
    'st'    => 'Sesooto',
    'su'    => 'Suudaaniis',
    'suk'   => 'Sukuma',
    'sus'   => 'Susu',
    'sux'   => 'Sumerian',
    'sv'    => 'Swiidhis',
    'sw'    => 'Sawaaxili',
    'syc'   => "Classical\ Syriac",
    'syr'   => 'Syriac',
    'ta'    => 'Tamiil',
    'tai'   => "Tai\ Language",
    'te'    => 'Teluugu',
    'tem'   => 'Timne',
    'ter'   => 'Tereno',
    'tet'   => 'Tetum',
    'tg'    => 'Tajik',
    'th'    => 'Taaylandays',
    'ti'    => 'Tigrinya',
    'tig'   => 'Tigre',
    'tiv'   => 'Tiv',
    'tk'    => 'Turkumaanish',
    'tkl'   => 'Tokelau',
    'tl'    => 'Tagalog',
    'tlh'   => 'Kiligoon',
    'tli'   => 'Tlingit',
    'tmh'   => 'Tamashek',
    'tn'    => 'Tswana',
    'to'    => 'Tonga',
    'tog'   => "Nyasa\ Tonga",
    'tpi'   => "Tok\ Pisin",
    'tr'    => 'Turkish',
    'trv'   => 'Taroko',
    'ts'    => 'Tsonga',
    'tsi'   => 'Tsimshian',
    'tt'    => 'Tatar',
    'tum'   => 'Tumbuka',
    'tup'   => "Tupi\ Language",
    'tut'   => "Altaic\ Language",
    'tvl'   => 'Tuvalu',
    'tw'    => 'Tiwiyan',
    'ty'    => 'Tahitian',
    'tyv'   => 'Tuvinian',
    'udm'   => 'Udmurt',
    'ug'    => 'UIGHUR',
    'uga'   => 'Ugaritic',
    'uk'    => 'Yukreeniyaan',
    'umb'   => 'Umbundu',
    'und'   => "Af\ aan\ la\ aqoon\ ama\ aan\ sax\ ahayn",
    'ur'    => 'Urduu',
    'uz'    => 'Usbakis',
    'vai'   => 'Vai',
    've'    => 'Venda',
    'vi'    => 'Fiitnaamays',
    'vo'    => "Volap\Ã\¼k",
    'vot'   => 'Votic',
    'wa'    => 'Walloon',
    'wak'   => "Wakashan\ Language",
    'wal'   => 'Walamo',
    'war'   => 'Waray',
    'was'   => 'Washo',
    'wen'   => "Sorbian\ Language",
    'wo'    => 'Wolof',
    'xal'   => 'Kalmyk',
    'xh'    => 'Hoosta',
    'yao'   => 'Yao',
    'yap'   => 'Yapese',
    'yi'    => 'Yadhish',
    'yo'    => 'Yoruba',
    'ypk'   => "Yupik\ Language",
    'za'    => 'Zhuang',
    'zap'   => 'Zapotec',
    'zbl'   => 'Blissymbols',
    'zen'   => 'Zenaga',
    'zh'    => 'Jayniis',
    'znd'   => 'Zande',
    'zu'    => 'Zuulu',
    'zun'   => 'Zuni',
    'zxx'   => "No\ linguistic\ content",
    'zza'   => 'Zaza',
);

%Locales::DB::Language::so::name_to_code = (
    'abkhazian'                     => 'ab',
    'achinese'                      => 'ace',
    'acoli'                         => 'ach',
    'adangme'                       => 'ada',
    'adyghe'                        => 'ady',
    'afaanlaaqoonamaaansaxahayn'    => 'und',
    'afar'                          => 'aa',
    'afnoorwiijiyaan'               => 'no',
    'afrihili'                      => 'afh',
    'afrikaanays'                   => 'af',
    'afroasiaticlanguage'           => 'afa',
    'ainu'                          => 'ain',
    'akan'                          => 'ak',
    'akkadian'                      => 'akk',
    'albaaniyaan'                   => 'sq',
    'aleut'                         => 'ale',
    'algonquianlanguage'            => 'alg',
    'altaiclanguage'                => 'tut',
    'amhari'                        => 'am',
    'ancientegyptian'               => 'egy',
    'ancientgreek'                  => 'grc',
    'angika'                        => 'anp',
    'apachelanguage'                => 'apa',
    'aragonese'                     => 'an',
    'aramaic'                       => 'arc',
    'arapaho'                       => 'arp',
    'araucanian'                    => 'arn',
    'arawak'                        => 'arw',
    'armeeniyaan'                   => 'hy',
    'aromanian'                     => 'rup',
    'artificiallanguage'            => 'art',
    'asaamiis'                      => 'as',
    'asturian'                      => 'ast',
    'athapascanlanguage'            => 'ath',
    'atsam'                         => 'cch',
    'australianenglish'             => 'en_au',
    'australianlanguage'            => 'aus',
    'austriangerman'                => 'de_at',
    'austronesianlanguage'          => 'map',
    'avaric'                        => 'av',
    'avestan'                       => 'ae',
    'awadhi'                        => 'awa',
    'aymara'                        => 'ay',
    'ayrish'                        => 'ga',
    'ayslandays'                    => 'is',
    'azerbaijan'                    => 'az',
    'balinese'                      => 'ban',
    'balticlanguage'                => 'bat',
    'baluchi'                       => 'bal',
    'bambara'                       => 'bm',
    'bamilekelanguage'              => 'bai',
    'banda'                         => 'bad',
    'bangaali'                      => 'bn',
    'bantu'                         => 'bnt',
    'basa'                          => 'bas',
    'bashkir'                       => 'ba',
    'bashtuu'                       => 'ps',
    'basquu'                        => 'eu',
    'batak'                         => 'btk',
    'beja'                          => 'bej',
    'beleruusiyaan'                 => 'be',
    'bemba'                         => 'bem',
    'berber'                        => 'ber',
    'bereton'                       => 'br',
    'bhojpuri'                      => 'bho',
    'bikol'                         => 'bik',
    'bini'                          => 'bin',
    'bislama'                       => 'bi',
    'bixaari'                       => 'bh',
    'blin'                          => 'byn',
    'blissymbols'                   => 'zbl',
    'boolish'                       => 'pl',
    'boortaqiis'                    => 'pt',
    'boortaqiisboortuqaal'          => 'pt_pt',
    'boortaqiiskabaraasiil'         => 'pt_br',
    'boosniya'                      => 'bs',
    'braj'                          => 'bra',
    'buginese'                      => 'bug',
    'bulgeeriyaan'                  => 'bg',
    'bunjaabi'                      => 'pa',
    'buriat'                        => 'bua',
    'burmese'                       => 'my',
    'caddo'                         => 'cad',
    'canadianenglish'               => 'en_ca',
    'canadianfrench'                => 'fr_ca',
    'carabi'                        => 'ar',
    'carib'                         => 'car',
    'caucasianlanguage'             => 'cau',
    'cebuano'                       => 'ceb',
    'celticlanguage'                => 'cel',
    'centralamericanindianlanguage' => 'cai',
    'chagatai'                      => 'chg',
    'chamiclanguage'                => 'cmc',
    'chamorro'                      => 'ch',
    'chechen'                       => 'ce',
    'cherokee'                      => 'chr',
    'cheyenne'                      => 'chy',
    'chibcha'                       => 'chb',
    'chinookjargon'                 => 'chn',
    'chipewyan'                     => 'chp',
    'choctaw'                       => 'cho',
    'churchslavic'                  => 'cu',
    'chuukese'                      => 'chk',
    'chuvash'                       => 'cv',
    'cibri'                         => 'he',
    'classicalnewari'               => 'nwc',
    'classicalsyriac'               => 'syc',
    'coptic'                        => 'cop',
    'cornish'                       => 'kw',
    'corsican'                      => 'co',
    'cree'                          => 'cr',
    'creek'                         => 'mus',
    'creoleorpidgin'                => 'crp',
    'crimeanturkish'                => 'crh',
    'cushiticlanguage'              => 'cus',
    'dakota'                        => 'dak',
    'danmarkays'                    => 'da',
    'dargwa'                        => 'dar',
    'dayak'                         => 'day',
    'delaware'                      => 'del',
    'dinka'                         => 'din',
    'divehi'                        => 'dv',
    'dogri'                         => 'doi',
    'dogrib'                        => 'dgr',
    'dravidianlanguage'             => 'dra',
    'duala'                         => 'dua',
    'dyula'                         => 'dyu',
    'dzongkha'                      => 'dz',
    'easternfrisian'                => 'frs',
    'efik'                          => 'efi',
    'ekajuk'                        => 'eka',
    'elamite'                       => 'elx',
    'englishbasedcreoleorpidgin'    => 'cpe',
    'erzya'                         => 'myv',
    'ewe'                           => 'ee',
    'ewondo'                        => 'ewo',
    'faarisi'                       => 'fa',
    'fang'                          => 'fan',
    'fanti'                         => 'fat',
    'faransiis'                     => 'fr',
    'faransiisiswiiserlaand'        => 'fr_ch',
    'farowsi'                       => 'fo',
    'fiinlaandees'                  => 'fi',
    'fiitnaamays'                   => 'vi',
    'fijian'                        => 'fj',
    'finnougrianlanguage'           => 'fiu',
    'firiisiyangalbeed'             => 'fy',
    'flemish'                       => 'nl_be',
    'fon'                           => 'fon',
    'frenchbasedcreoleorpidgin'     => 'cpf',
    'friulian'                      => 'fur',
    'fulah'                         => 'ff',
    'ga'                            => 'gaa',
    'galiisiyaan'                   => 'gl',
    'ganda'                         => 'lg',
    'gayo'                          => 'gay',
    'gbaya'                         => 'gba',
    'geez'                          => 'gez',
    'germaniclanguage'              => 'gem',
    'gilbertese'                    => 'gil',
    'giriik'                        => 'el',
    'gondi'                         => 'gon',
    'gorontalo'                     => 'gor',
    'gothic'                        => 'got',
    'grebo'                         => 'grb',
    'gujaraati'                     => 'gu',
    'guraani'                       => 'gn',
    "gwich\Ê\¼in"                 => 'gwi',
    'haida'                         => 'hai',
    'haitian'                       => 'ht',
    'hangariyaan'                   => 'hu',
    'hausa'                         => 'ha',
    'hawaiian'                      => 'haw',
    'herero'                        => 'hz',
    'hiligaynon'                    => 'hil',
    'himachali'                     => 'him',
    'hindi'                         => 'hi',
    'hirimotu'                      => 'ho',
    'hittite'                       => 'hit',
    'hmong'                         => 'hmn',
    'holandays'                     => 'nl',
    'hoosta'                        => 'xh',
    'hupa'                          => 'hup',
    'iban'                          => 'iba',
    'ido'                           => 'io',
    'igbo'                          => 'ig',
    'ijo'                           => 'ijo',
    'iloko'                         => 'ilo',
    'inarisami'                     => 'smn',
    'indiclanguage'                 => 'inc',
    'indoeuropeanlanguage'          => 'ine',
    'indunuusiyaan'                 => 'id',
    'ingiriisi'                     => 'en',
    'ingiriisiboqortooyadamidowday' => 'en_gb',
    'ingiriisimaraykan'             => 'en_us',
    'ingush'                        => 'inh',
    'interlingue'                   => 'ie',
    'interlinguwa'                  => 'ia',
    'inuktitut'                     => 'iu',
    'inupiaq'                       => 'ik',
    'iranianlanguage'               => 'ira',
    'iroquoianlanguage'             => 'iro',
    'isbaanish'                     => 'es',
    'isbaanishisbayn'               => 'es_es',
    'isberento'                     => 'eo',
    'iskotgiilik'                   => 'gd',
    'islofeeniyaan'                 => 'sl',
    'isloofaak'                     => 'sk',
    'istooniyaan'                   => 'et',
    'jabbaaniis'                    => 'ja',
    'jafaaniis'                     => 'jv',
    'jarmal'                        => 'de',
    'jarmaliswiiserlaand'           => 'de_ch',
    'jayniis'                       => 'zh',
    'jeeg'                          => 'cs',
    'jju'                           => 'kaj',
    'joorijiyaan'                   => 'ka',
    'judeoarabic'                   => 'jrb',
    'judeopersian'                  => 'jpr',
    'kabardian'                     => 'kbd',
    'kabyle'                        => 'kab',
    'kachin'                        => 'kac',
    'kalaallisut'                   => 'kl',
    'kalmyk'                        => 'xal',
    'kamba'                         => 'kam',
    'kamboodhian'                   => 'km',
    'kannadays'                     => 'kn',
    'kanuri'                        => 'kr',
    'karachaybalkar'                => 'krc',
    'karakalpak'                    => 'kaa',
    'karelian'                      => 'krl',
    'karen'                         => 'kar',
    'kashmiri'                      => 'ks',
    'kashubian'                     => 'csb',
    'katalaan'                      => 'ca',
    'kawi'                          => 'kaw',
    'kazakh'                        => 'kk',
    'khasi'                         => 'kha',
    'khoisanlanguage'               => 'khi',
    'khotanese'                     => 'kho',
    'kikuyu'                        => 'ki',
    'kiligoon'                      => 'tlh',
    'kimbundu'                      => 'kmb',
    'kinyarwanda'                   => 'rw',
    'kirgiis'                       => 'ky',
    'komi'                          => 'kv',
    'kongo'                         => 'kg',
    'konkani'                       => 'kok',
    'koro'                          => 'kfo',
    'koroeeshiyaan'                 => 'hr',
    'kosraean'                      => 'kos',
    'kpelle'                        => 'kpe',
    'kru'                           => 'kro',
    'kuanyama'                      => 'kj',
    'kumyk'                         => 'kum',
    'kurdishka'                     => 'ku',
    'kurukh'                        => 'kru',
    'kutenai'                       => 'kut',
    'kuuriyaan'                     => 'ko',
    'laatfiyaan'                    => 'lv',
    'laatiin'                       => 'la',
    'ladino'                        => 'lad',
    'lahnda'                        => 'lah',
    'lamba'                         => 'lam',
    'laothian'                      => 'lo',
    'lezghian'                      => 'lez',
    'limburgish'                    => 'li',
    'lingala'                       => 'ln',
    'lituwaanays'                   => 'lt',
    'lojban'                        => 'jbo',
    'lowersorbian'                  => 'dsb',
    'lowgerman'                     => 'nds',
    'lozi'                          => 'loz',
    'lubakatanga'                   => 'lu',
    'lubalulua'                     => 'lua',
    'luiseno'                       => 'lui',
    'lulesami'                      => 'smj',
    'lunda'                         => 'lun',
    'luo'                           => 'luo',
    'lushai'                        => 'lus',
    'luxembourgish'                 => 'lb',
    'maarati'                       => 'mr',
    'madurese'                      => 'mad',
    'magahi'                        => 'mag',
    'maithili'                      => 'mai',
    'makasar'                       => 'mak',
    'malaay'                        => 'ms',
    'malagasy'                      => 'mg',
    'malayalam'                     => 'ml',
    'maltiis'                       => 'mt',
    'manchu'                        => 'mnc',
    'mandar'                        => 'mdr',
    'mandingo'                      => 'man',
    'mangooli'                      => 'mn',
    'manipuri'                      => 'mni',
    'manobolanguage'                => 'mno',
    'manx'                          => 'gv',
    'maori'                         => 'mi',
    'mari'                          => 'chm',
    'marshallese'                   => 'mh',
    'marwari'                       => 'mwr',
    'masadooniyaan'                 => 'mk',
    'masai'                         => 'mas',
    'mayanlanguage'                 => 'myn',
    'mende'                         => 'men',
    'micmac'                        => 'mic',
    'middledutch'                   => 'dum',
    'middleenglish'                 => 'enm',
    'middlefrench'                  => 'frm',
    'middlehighgerman'              => 'gmh',
    'middleirish'                   => 'mga',
    'minangkabau'                   => 'min',
    'mirandese'                     => 'mwl',
    'miscellaneouslanguage'         => 'mis',
    'mohawk'                        => 'moh',
    'moksha'                        => 'mdf',
    'moldavian'                     => 'mo',
    'mongo'                         => 'lol',
    'monkhmerlanguage'              => 'mkh',
    'morisyen'                      => 'mfe',
    'mossi'                         => 'mos',
    'multiplelanguages'             => 'mul',
    'mundalanguage'                 => 'mun',
    'nahuatl'                       => 'nah',
    'nauru'                         => 'na',
    'navajo'                        => 'nv',
    'ndonga'                        => 'ng',
    'neapolitan'                    => 'nap',
    'nebaali'                       => 'ne',
    'newari'                        => 'new',
    'nias'                          => 'nia',
    'nigerkordofanianlanguage'      => 'nic',
    'nilosaharanlanguage'           => 'ssa',
    'niuean'                        => 'niu',
    'nogai'                         => 'nog',
    'nolinguisticcontent'           => 'zxx',
    'northamericanindianlanguage'   => 'nai',
    'northernfrisian'               => 'frr',
    'northernsami'                  => 'se',
    'northernsotho'                 => 'nso',
    'northndebele'                  => 'nd',
    "norwegianbokm\Ã\¥l"          => 'nb',
    'nowrwejiyannaynoroski'         => 'nn',
    'nubianlanguage'                => 'nub',
    'nyamwezi'                      => 'nym',
    'nyanja'                        => 'ny',
    'nyankole'                      => 'nyn',
    'nyasatonga'                    => 'tog',
    'nyoro'                         => 'nyo',
    'nzima'                         => 'nzi',
    "n\â\\ko"                  => 'nqo',
    'ojibwa'                        => 'oj',
    'okitaan'                       => 'oc',
    'oldenglish'                    => 'ang',
    'oldfrench'                     => 'fro',
    'oldhighgerman'                 => 'goh',
    'oldirish'                      => 'sga',
    'oldnorse'                      => 'non',
    'oldpersian'                    => 'peo',
    "oldproven\Ã\§al"             => 'pro',
    'oriya'                         => 'or',
    'oromo'                         => 'om',
    'osage'                         => 'osa',
    'ossetic'                       => 'os',
    'otomianlanguage'               => 'oto',
    'ottomanturkish'                => 'ota',
    'pahlavi'                       => 'pal',
    'palauan'                       => 'pau',
    'pali'                          => 'pi',
    'pampanga'                      => 'pam',
    'pangasinan'                    => 'pag',
    'papiamento'                    => 'pap',
    'papuanlanguage'                => 'paa',
    'philippinelanguage'            => 'phi',
    'phoenician'                    => 'phn',
    'pohnpeian'                     => 'pon',
    'portuguesebasedcreoleorpidgin' => 'cpp',
    'prakritlanguage'               => 'pra',
    'quechua'                       => 'qu',
    'rajasthani'                    => 'raj',
    'rapanui'                       => 'rap',
    'rarotongan'                    => 'rar',
    'rhaetoromance'                 => 'rm',
    'romancelanguage'               => 'roa',
    'romanka'                       => 'ro',
    'romany'                        => 'rom',
    'rundi'                         => 'rn',
    'ruush'                         => 'ru',
    'salishanlanguage'              => 'sal',
    'samaritanaramaic'              => 'sam',
    'samilanguage'                  => 'smi',
    'samoan'                        => 'sm',
    'sandawe'                       => 'sad',
    'sango'                         => 'sg',
    'sanskrit'                      => 'sa',
    'santali'                       => 'sat',
    'sardinian'                     => 'sc',
    'sasak'                         => 'sas',
    'sawaaxili'                     => 'sw',
    'scots'                         => 'sco',
    'seerbiyaan'                    => 'sr',
    'selkup'                        => 'sel',
    'semiticlanguage'               => 'sem',
    'serbiyaan'                     => 'sh',
    'serer'                         => 'srr',
    'sesooto'                       => 'st',
    'shan'                          => 'shn',
    'shona'                         => 'sn',
    'sichuanyi'                     => 'ii',
    'sicilian'                      => 'scn',
    'sidamo'                        => 'sid',
    'signlanguage'                  => 'sgn',
    'siksika'                       => 'bla',
    'sindhi'                        => 'sd',
    'sinhaleys'                     => 'si',
    'sinotibetanlanguage'           => 'sit',
    'siouanlanguage'                => 'sio',
    'skoltsami'                     => 'sms',
    'slave'                         => 'den',
    'slaviclanguage'                => 'sla',
    'sogdien'                       => 'sog',
    'songhai'                       => 'son',
    'soninke'                       => 'snk',
    'soomaali'                      => 'so',
    'sorbianlanguage'               => 'wen',
    'southamericanindianlanguage'   => 'sai',
    'southernaltai'                 => 'alt',
    'southernsami'                  => 'sma',
    'southndebele'                  => 'nr',
    'sranantongo'                   => 'srn',
    'sukuma'                        => 'suk',
    'sumerian'                      => 'sux',
    'susu'                          => 'sus',
    'suudaaniis'                    => 'su',
    'swati'                         => 'ss',
    'swiidhis'                      => 'sv',
    'swissgerman'                   => 'gsw',
    'syriac'                        => 'syr',
    'taaylandays'                   => 'th',
    'tagalog'                       => 'tl',
    'tahitian'                      => 'ty',
    'tailanguage'                   => 'tai',
    'tajik'                         => 'tg',
    'talyaani'                      => 'it',
    'tamashek'                      => 'tmh',
    'tamiil'                        => 'ta',
    'taroko'                        => 'trv',
    'tatar'                         => 'tt',
    'teluugu'                       => 'te',
    'tereno'                        => 'ter',
    'tetum'                         => 'tet',
    'tibetan'                       => 'bo',
    'tigre'                         => 'tig',
    'tigrinya'                      => 'ti',
    'timne'                         => 'tem',
    'tiv'                           => 'tiv',
    'tiwiyan'                       => 'tw',
    'tlingit'                       => 'tli',
    'tokelau'                       => 'tkl',
    'tokpisin'                      => 'tpi',
    'tonga'                         => 'to',
    'tsimshian'                     => 'tsi',
    'tsonga'                        => 'ts',
    'tswana'                        => 'tn',
    'tumbuka'                       => 'tum',
    'tupilanguage'                  => 'tup',
    'turkish'                       => 'tr',
    'turkumaanish'                  => 'tk',
    'tuvalu'                        => 'tvl',
    'tuvinian'                      => 'tyv',
    'tyap'                          => 'kcg',
    'udmurt'                        => 'udm',
    'ugaritic'                      => 'uga',
    'uighur'                        => 'ug',
    'umbundu'                       => 'umb',
    'uppersorbian'                  => 'hsb',
    'urduu'                         => 'ur',
    'usbakis'                       => 'uz',
    'vai'                           => 'vai',
    'venda'                         => 've',
    "volap\Ã\¼k"                  => 'vo',
    'votic'                         => 'vot',
    'wakashanlanguage'              => 'wak',
    'walamo'                        => 'wal',
    'walloon'                       => 'wa',
    'waray'                         => 'war',
    'washo'                         => 'was',
    'welsh'                         => 'cy',
    'wolof'                         => 'wo',
    'yadhish'                       => 'yi',
    'yakut'                         => 'sah',
    'yao'                           => 'yao',
    'yapese'                        => 'yap',
    'yoruba'                        => 'yo',
    'yukreeniyaan'                  => 'uk',
    'yupiklanguage'                 => 'ypk',
    'zande'                         => 'znd',
    'zapotec'                       => 'zap',
    'zaza'                          => 'zza',
    'zenaga'                        => 'zen',
    'zhuang'                        => 'za',
    'zuni'                          => 'zun',
    'zuulu'                         => 'zu',
);

1;
