package Locales::DB::Language::fur;

# Auto generated from CLDR

$Locales::DB::Language::fur::VERSION = '0.01';

$Locales::DB::Language::fur::cldr_version = '1.7.1';

%Locales::DB::Language::fur::misc_info = (
    'cldr_formats' => {
        'decimal' => {
            'content' => "\#\,\#\#0\.\#\#\#",
            'draft'   => 'unconfirmed'
        },
        'language' => "Lenghe\:\ \{0\}",
        'locale'   => {
            'content' => "\{0\}\ \(\{1\}\)",
            'draft'   => 'unconfirmed'
        },
        'percent' => {
            'content' => "\#\,\#\#0\%",
            'draft'   => 'unconfirmed'
        },
        'territory' => "Regjon\:\ \{0\}"
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'posix' => {
        'nostr' => {
            'content' => "no\:n",
            'draft'   => 'unconfirmed'
        },
        'yesstr' => {
            'content' => "sì\:si\:s",
            'draft'   => 'unconfirmed'
        }
    },
);

%Locales::DB::Language::fur::code_to_name = (
    'aa'    => 'afar',
    'ab'    => 'Abkhazian',
    'ace'   => 'Achinese',
    'ach'   => 'Acoli',
    'ada'   => 'Adangme',
    'ady'   => 'Adyghe',
    'ae'    => 'avestan',
    'af'    => 'afrikaans',
    'afa'   => "Afro\-Asiatic\ Language",
    'afh'   => 'Afrihili',
    'ain'   => 'Ainu',
    'ak'    => 'Akan',
    'akk'   => 'Akkadian',
    'ale'   => 'Aleut',
    'alg'   => "Algonquian\ Language",
    'alt'   => "Southern\ Altai",
    'am'    => 'amaric',
    'an'    => 'aragonês',
    'ang'   => "vieri\ inglês",
    'anp'   => 'Angika',
    'apa'   => "lenghe\ Apache",
    'ar'    => 'arap',
    'arc'   => 'aramaic',
    'arn'   => 'Araucanian',
    'arp'   => 'Arapaho',
    'art'   => "Artificial\ Language",
    'arw'   => 'Arawak',
    'as'    => 'assamês',
    'ast'   => 'asturian',
    'ath'   => "Athapascan\ Language",
    'aus'   => "lenghis\ australianis",
    'av'    => 'avar',
    'awa'   => 'Awadhi',
    'ay'    => 'aymarà',
    'az'    => 'azerbaijani',
    'ba'    => 'Bashkir',
    'bad'   => 'Banda',
    'bai'   => "Bamileke\ Language",
    'bal'   => 'Baluchi',
    'ban'   => 'Balinese',
    'bas'   => 'Basa',
    'bat'   => "Baltic\ Language",
    'be'    => 'bielorùs',
    'bej'   => 'Beja',
    'bem'   => 'Bemba',
    'ber'   => 'Berber',
    'bg'    => 'bulgar',
    'bh'    => 'Bihari',
    'bho'   => 'Bhojpuri',
    'bi'    => 'Bislama',
    'bik'   => 'Bikol',
    'bin'   => 'Bini',
    'bla'   => 'Siksika',
    'bm'    => 'Bambara',
    'bn'    => 'bengalês',
    'bnt'   => 'Bantu',
    'bo'    => 'tibetan',
    'br'    => 'breton',
    'bra'   => 'Braj',
    'bs'    => 'bosniac',
    'btk'   => 'Batak',
    'bua'   => 'Buriat',
    'bug'   => 'Buginese',
    'byn'   => 'Blin',
    'ca'    => 'catalan',
    'cad'   => 'Caddo',
    'cai'   => "Central\ American\ Indian\ Language",
    'car'   => 'Carib',
    'cau'   => "Caucasian\ Language",
    'cch'   => 'Atsam',
    'ce'    => 'cecen',
    'ceb'   => 'Cebuano',
    'cel'   => "lenghe\ celtiche",
    'ch'    => 'chamorro',
    'chb'   => 'Chibcha',
    'chg'   => 'Chagatai',
    'chk'   => 'Chuukese',
    'chm'   => 'Mari',
    'chn'   => "Chinook\ Jargon",
    'cho'   => 'Choctaw',
    'chp'   => 'Chipewyan',
    'chr'   => 'Cherokee',
    'chy'   => 'Cheyenne',
    'cmc'   => "Chamic\ Language",
    'co'    => 'cors',
    'cop'   => 'coptic',
    'cpe'   => "English\-based\ Creole\ or\ Pidgin",
    'cpf'   => "French\-based\ Creole\ or\ Pidgin",
    'cpp'   => "Portuguese\-based\ Creole\ or\ Pidgin",
    'cr'    => 'cree',
    'crh'   => "Crimean\ Turkish",
    'crp'   => "Creole\ or\ Pidgin",
    'cs'    => 'cec',
    'csb'   => 'Kashubian',
    'cu'    => "sclâf\ de\ glesie",
    'cus'   => "Cushitic\ Language",
    'cv'    => 'Chuvash',
    'cy'    => 'galês',
    'da'    => 'danês',
    'dak'   => 'Dakota',
    'dar'   => 'Dargwa',
    'day'   => 'Dayak',
    'de'    => 'todesc',
    'de_at' => "Austrian\ German",
    'de_ch' => "Swiss\ High\ German",
    'del'   => 'Delaware',
    'den'   => 'sclâf',
    'dgr'   => 'Dogrib',
    'din'   => 'Dinka',
    'doi'   => 'Dogri',
    'dra'   => "Dravidian\ Language",
    'dsb'   => "Lower\ Sorbian",
    'dua'   => 'Duala',
    'dum'   => "Middle\ Dutch",
    'dv'    => 'Divehi',
    'dyu'   => 'Dyula',
    'dz'    => 'Dzongkha',
    'ee'    => 'Ewe',
    'efi'   => 'Efik',
    'egy'   => "vieri\ egjizian",
    'eka'   => 'Ekajuk',
    'el'    => 'grêc',
    'elx'   => 'Elamite',
    'en'    => 'inglês',
    'en_au' => "Australian\ English",
    'en_ca' => "Canadian\ English",
    'en_gb' => "British\ English",
    'en_us' => "U\.S\.\ English",
    'enm'   => "Middle\ English",
    'eo'    => 'esperanto',
    'es'    => 'spagnûl',
    'es_es' => "Iberian\ Spanish",
    'et'    => 'eston',
    'eu'    => 'basc',
    'ewo'   => 'Ewondo',
    'fa'    => 'persian',
    'fan'   => 'Fang',
    'fat'   => 'Fanti',
    'ff'    => 'fulah',
    'fi'    => 'finlandês',
    'fil'   => 'Filipino',
    'fiu'   => "Finno\-Ugrian\ Language",
    'fj'    => 'fizian',
    'fo'    => 'faroês',
    'fon'   => 'Fon',
    'fr'    => 'francês',
    'fr_ca' => "Canadian\ French",
    'fr_ch' => "Swiss\ French",
    'frm'   => "Middle\ French",
    'fro'   => "vieri\ francês",
    'frr'   => "Northern\ Frisian",
    'frs'   => "Eastern\ Frisian",
    'fur'   => 'furlan',
    'fy'    => 'frisian',
    'ga'    => "gaelic\ irlandês",
    'gaa'   => 'Ga',
    'gay'   => 'Gayo',
    'gba'   => 'Gbaya',
    'gd'    => "gaelic\ scozês",
    'gem'   => "lenghe\ gjermaniche",
    'gez'   => 'Geez',
    'gil'   => 'Gilbertese',
    'gl'    => 'galizian',
    'gmh'   => "Middle\ High\ German",
    'gn'    => 'Guarani',
    'goh'   => "Old\ High\ German",
    'gon'   => 'Gondi',
    'gor'   => 'Gorontalo',
    'got'   => 'gotic',
    'grb'   => 'Grebo',
    'grc'   => "vieri\ grêc",
    'gsw'   => "Swiss\ German",
    'gu'    => 'Gujarati',
    'gv'    => 'manx',
    'gwi'   => "Gwich\Ê\¼in",
    'ha'    => 'Hausa',
    'hai'   => 'Haida',
    'haw'   => 'Hawaiian',
    'he'    => 'ebraic',
    'hi'    => 'hindi',
    'hil'   => 'Hiligaynon',
    'him'   => 'Himachali',
    'hit'   => 'Hittite',
    'hmn'   => 'Hmong',
    'ho'    => "Hiri\ Motu",
    'hr'    => 'cravuat',
    'hsb'   => "Upper\ Sorbian",
    'ht'    => 'haitian',
    'hu'    => 'ongjarês',
    'hup'   => 'Hupa',
    'hy'    => 'armen',
    'hz'    => 'Herero',
    'ia'    => 'Interlingua',
    'iba'   => 'Iban',
    'id'    => 'indonesian',
    'ie'    => 'Interlingue',
    'ig'    => 'Igbo',
    'ii'    => "Sichuan\ Yi",
    'ijo'   => 'Ijo',
    'ik'    => 'inupiaq',
    'ilo'   => 'Iloko',
    'inc'   => "Indic\ Language",
    'ine'   => "lenghe\ indo\-europeane",
    'inh'   => 'Ingush',
    'io'    => 'ido',
    'ira'   => "Iranian\ Language",
    'iro'   => "Iroquoian\ Language",
    'is'    => 'islandês',
    'it'    => 'talian',
    'iu'    => 'inuktitut',
    'ja'    => 'gjaponês',
    'jbo'   => 'Lojban',
    'jpr'   => "Judeo\-Persian",
    'jrb'   => "Judeo\-Arabic",
    'jv'    => 'Javanese',
    'ka'    => 'gjeorgjian',
    'kaa'   => "Kara\-Kalpak",
    'kab'   => 'Kabyle',
    'kac'   => 'Kachin',
    'kaj'   => 'Jju',
    'kam'   => 'Kamba',
    'kar'   => 'Karen',
    'kaw'   => 'Kawi',
    'kbd'   => 'Kabardian',
    'kcg'   => 'Tyap',
    'kfo'   => 'Koro',
    'kg'    => 'Kongo',
    'kha'   => 'Khasi',
    'khi'   => "Khoisan\ Language",
    'kho'   => 'Khotanese',
    'ki'    => 'Kikuyu',
    'kj'    => 'Kuanyama',
    'kk'    => 'kazac',
    'kl'    => 'kalaallisut',
    'km'    => 'khmer',
    'kmb'   => 'Kimbundu',
    'kn'    => 'kannada',
    'ko'    => 'corean',
    'kok'   => 'Konkani',
    'kos'   => 'Kosraean',
    'kpe'   => 'Kpelle',
    'kr'    => 'Kanuri',
    'krc'   => "Karachay\-Balkar",
    'krl'   => 'Karelian',
    'kro'   => 'Kru',
    'kru'   => 'Kurukh',
    'ks'    => 'Kashmiri',
    'ku'    => 'curd',
    'kum'   => 'Kumyk',
    'kut'   => 'Kutenai',
    'kv'    => 'Komi',
    'kw'    => 'cornualiês',
    'ky'    => 'Kirghiz',
    'la'    => 'latin',
    'lad'   => 'ladin',
    'lah'   => 'Lahnda',
    'lam'   => 'Lamba',
    'lb'    => 'lussemburghês',
    'lez'   => 'Lezghian',
    'lg'    => 'Ganda',
    'li'    => 'limburghês',
    'ln'    => 'lingala',
    'lo'    => 'Lao',
    'lol'   => 'Mongo',
    'loz'   => 'Lozi',
    'lt'    => 'lituan',
    'lu'    => "Luba\-Katanga",
    'lua'   => "Luba\-Lulua",
    'lui'   => 'Luiseno',
    'lun'   => 'Lunda',
    'luo'   => 'Luo',
    'lus'   => 'Lushai',
    'lv'    => 'leton',
    'mad'   => 'Madurese',
    'mag'   => 'Magahi',
    'mai'   => 'Maithili',
    'mak'   => 'Makasar',
    'man'   => 'Mandingo',
    'map'   => 'austronesian',
    'mas'   => 'Masai',
    'mdf'   => 'Moksha',
    'mdr'   => 'Mandar',
    'men'   => 'Mende',
    'mfe'   => 'Morisyen',
    'mg'    => 'Malagasy',
    'mga'   => "Middle\ Irish",
    'mh'    => 'Marshallese',
    'mi'    => 'maori',
    'mic'   => 'Micmac',
    'min'   => 'Minangkabau',
    'mis'   => "lenghis\ variis",
    'mk'    => 'macedon',
    'mkh'   => "Mon\-Khmer\ Language",
    'ml'    => 'malayalam',
    'mn'    => 'mongul',
    'mnc'   => 'Manchu',
    'mni'   => 'Manipuri',
    'mno'   => "Manobo\ Language",
    'mo'    => 'moldâf',
    'moh'   => 'Mohawk',
    'mos'   => 'Mossi',
    'mr'    => 'marathi',
    'ms'    => 'malês',
    'mt'    => 'maltês',
    'mul'   => "lenghis\ multiplis",
    'mun'   => "Munda\ Language",
    'mus'   => 'Creek',
    'mwl'   => 'mirandês',
    'mwr'   => 'Marwari',
    'my'    => 'Burmese',
    'myn'   => "lenghis\ Maya",
    'myv'   => 'Erzya',
    'na'    => 'Nauru',
    'nah'   => 'Nahuatl',
    'nai'   => "North\ American\ Indian\ Language",
    'nap'   => 'napoletan',
    'nb'    => "norvegjês\ bokmål",
    'nd'    => "North\ Ndebele",
    'nds'   => "bas\ todesc",
    'ne'    => 'nepalês',
    'new'   => 'Newari',
    'ng'    => 'Ndonga',
    'nia'   => 'Nias',
    'nic'   => "Niger\-Kordofanian\ Language",
    'niu'   => 'Niuean',
    'nl'    => 'olandês',
    'nl_be' => 'Flemish',
    'nn'    => "norvegjês\ nynorsk",
    'no'    => 'norvegjês',
    'nog'   => 'Nogai',
    'non'   => "vieri\ norvegjês",
    'nqo'   => "N\â\\Ko",
    'nr'    => "South\ Ndebele",
    'nso'   => "Northern\ Sotho",
    'nub'   => "Nubian\ Language",
    'nv'    => 'navajo',
    'nwc'   => "Classical\ Newari",
    'ny'    => 'Nyanja',
    'nym'   => 'Nyamwezi',
    'nyn'   => 'Nyankole',
    'nyo'   => 'Nyoro',
    'nzi'   => 'Nzima',
    'oc'    => 'ocitan',
    'oj'    => 'Ojibwa',
    'om'    => 'Oromo',
    'or'    => 'Oriya',
    'os'    => 'osetic',
    'osa'   => 'Osage',
    'ota'   => "turc\ otoman",
    'oto'   => "Otomian\ Language",
    'pa'    => 'punjabi',
    'paa'   => "Papuan\ Language",
    'pag'   => 'Pangasinan',
    'pal'   => 'Pahlavi',
    'pam'   => 'Pampanga',
    'pap'   => 'papiamento',
    'pau'   => 'Palauan',
    'peo'   => "vieri\ persian",
    'phi'   => "Philippine\ Language",
    'phn'   => 'Phoenician',
    'pi'    => 'Pali',
    'pl'    => 'polac',
    'pon'   => 'Pohnpeian',
    'pra'   => "Prakrit\ Language",
    'pro'   => "vieri\ provenzâl",
    'ps'    => 'pashto',
    'pt'    => 'portughês',
    'pt_br' => "portughês\ brasilian",
    'pt_pt' => "Iberian\ Portuguese",
    'qu'    => 'quechua',
    'raj'   => 'Rajasthani',
    'rap'   => 'Rapanui',
    'rar'   => 'Rarotongan',
    'rm'    => 'rumanç',
    'rn'    => 'Rundi',
    'ro'    => 'romen',
    'roa'   => "lenghe\ romanze",
    'rom'   => 'Romany',
    'ru'    => 'rus',
    'rup'   => 'Aromanian',
    'rw'    => 'Kinyarwanda',
    'sa'    => 'sanscrit',
    'sad'   => 'Sandawe',
    'sah'   => 'Yakut',
    'sai'   => "South\ American\ Indian\ Language",
    'sal'   => "Salishan\ Language",
    'sam'   => "Samaritan\ Aramaic",
    'sas'   => 'Sasak',
    'sat'   => 'Santali',
    'sc'    => 'sardegnûl',
    'scn'   => 'sicilian',
    'sco'   => 'scozês',
    'sd'    => 'sindhi',
    'se'    => "sami\ setentrionâl",
    'sel'   => 'Selkup',
    'sem'   => "Semitic\ Language",
    'sg'    => 'Sango',
    'sga'   => "vieri\ irlandês",
    'sgn'   => "Sign\ Language",
    'sh'    => "Serbo\-Croatian",
    'shn'   => 'Shan',
    'si'    => 'sinalês',
    'sid'   => 'Sidamo',
    'sio'   => "Siouan\ Language",
    'sit'   => "Sino\-Tibetan\ Language",
    'sk'    => 'slovac',
    'sl'    => 'sloven',
    'sla'   => "lenghe\ sclave",
    'sm'    => 'samoan',
    'sma'   => "Southern\ Sami",
    'smi'   => "Sami\ Language",
    'smj'   => "Lule\ Sami",
    'smn'   => "Inari\ Sami",
    'sms'   => "Skolt\ Sami",
    'sn'    => 'Shona',
    'snk'   => 'Soninke',
    'so'    => 'somal',
    'sog'   => 'Sogdien',
    'son'   => 'Songhai',
    'sq'    => 'albanês',
    'sr'    => 'serp',
    'srn'   => "Sranan\ Tongo",
    'srr'   => 'Serer',
    'ss'    => 'Swati',
    'ssa'   => "Nilo\-Saharan\ Language",
    'st'    => "Southern\ Sotho",
    'su'    => 'Sundanese',
    'suk'   => 'Sukuma',
    'sus'   => 'Susu',
    'sux'   => 'sumeric',
    'sv'    => 'svedês',
    'sw'    => 'swahili',
    'syc'   => "Classical\ Syriac",
    'syr'   => 'Syriac',
    'ta'    => 'tamil',
    'tai'   => "Tai\ Language",
    'te'    => 'telegu',
    'tem'   => 'Timne',
    'ter'   => 'Tereno',
    'tet'   => 'tetum',
    'tg'    => 'tagic',
    'th'    => 'thai',
    'ti'    => 'Tigrinya',
    'tig'   => 'Tigre',
    'tiv'   => 'Tiv',
    'tk'    => 'Turkmen',
    'tkl'   => 'Tokelau',
    'tl'    => 'tagalog',
    'tlh'   => 'Klingon',
    'tli'   => 'Tlingit',
    'tmh'   => 'Tamashek',
    'tn'    => 'Tswana',
    'to'    => 'Tonga',
    'tog'   => "Nyasa\ Tonga",
    'tpi'   => "Tok\ Pisin",
    'tr'    => 'turc',
    'trv'   => 'Taroko',
    'ts'    => 'Tsonga',
    'tsi'   => 'Tsimshian',
    'tt'    => 'tartar',
    'tum'   => 'Tumbuka',
    'tup'   => "Tupi\ Language",
    'tut'   => "Altaic\ Language",
    'tvl'   => 'Tuvalu',
    'tw'    => 'Twi',
    'ty'    => 'tahitian',
    'tyv'   => 'Tuvinian',
    'udm'   => 'Udmurt',
    'ug'    => 'Uyghur',
    'uga'   => 'Ugaritic',
    'uk'    => 'ucrain',
    'umb'   => 'Umbundu',
    'und'   => 'indeterminade',
    'ur'    => 'urdu',
    'uz'    => 'uzbec',
    'vai'   => 'Vai',
    've'    => 'Venda',
    'vi'    => 'vietnamite',
    'vo'    => "Volap\Ã\¼k",
    'vot'   => 'Votic',
    'wa'    => 'valon',
    'wak'   => "Wakashan\ Language",
    'wal'   => 'Walamo',
    'war'   => 'Waray',
    'was'   => 'Washo',
    'wen'   => "Sorbian\ Language",
    'wo'    => 'Wolof',
    'xal'   => 'Kalmyk',
    'xh'    => 'Xhosa',
    'yao'   => 'Yao',
    'yap'   => 'Yapese',
    'yi'    => 'yiddish',
    'yo'    => 'Yoruba',
    'ypk'   => "Yupik\ Language",
    'za'    => 'Zhuang',
    'zap'   => 'Zapotec',
    'zbl'   => 'Blissymbols',
    'zen'   => 'Zenaga',
    'zh'    => 'cinês',
    'znd'   => 'Zande',
    'zu'    => 'zulu',
    'zun'   => 'Zuni',
    'zxx'   => "No\ linguistic\ content",
    'zza'   => 'Zaza',
);

%Locales::DB::Language::fur::name_to_code = (
    'abkhazian'                     => 'ab',
    'achinese'                      => 'ace',
    'acoli'                         => 'ach',
    'adangme'                       => 'ada',
    'adyghe'                        => 'ady',
    'afar'                          => 'aa',
    'afrihili'                      => 'afh',
    'afrikaans'                     => 'af',
    'afroasiaticlanguage'           => 'afa',
    'ainu'                          => 'ain',
    'akan'                          => 'ak',
    'akkadian'                      => 'akk',
    'albanês'                      => 'sq',
    'aleut'                         => 'ale',
    'algonquianlanguage'            => 'alg',
    'altaiclanguage'                => 'tut',
    'amaric'                        => 'am',
    'angika'                        => 'anp',
    'aragonês'                     => 'an',
    'aramaic'                       => 'arc',
    'arap'                          => 'ar',
    'arapaho'                       => 'arp',
    'araucanian'                    => 'arn',
    'arawak'                        => 'arw',
    'armen'                         => 'hy',
    'aromanian'                     => 'rup',
    'artificiallanguage'            => 'art',
    'assamês'                      => 'as',
    'asturian'                      => 'ast',
    'athapascanlanguage'            => 'ath',
    'atsam'                         => 'cch',
    'australianenglish'             => 'en_au',
    'austriangerman'                => 'de_at',
    'austronesian'                  => 'map',
    'avar'                          => 'av',
    'avestan'                       => 'ae',
    'awadhi'                        => 'awa',
    'aymarà'                       => 'ay',
    'azerbaijani'                   => 'az',
    'balinese'                      => 'ban',
    'balticlanguage'                => 'bat',
    'baluchi'                       => 'bal',
    'bambara'                       => 'bm',
    'bamilekelanguage'              => 'bai',
    'banda'                         => 'bad',
    'bantu'                         => 'bnt',
    'basa'                          => 'bas',
    'basc'                          => 'eu',
    'bashkir'                       => 'ba',
    'bastodesc'                     => 'nds',
    'batak'                         => 'btk',
    'beja'                          => 'bej',
    'bemba'                         => 'bem',
    'bengalês'                     => 'bn',
    'berber'                        => 'ber',
    'bhojpuri'                      => 'bho',
    'bielorùs'                     => 'be',
    'bihari'                        => 'bh',
    'bikol'                         => 'bik',
    'bini'                          => 'bin',
    'bislama'                       => 'bi',
    'blin'                          => 'byn',
    'blissymbols'                   => 'zbl',
    'bosniac'                       => 'bs',
    'braj'                          => 'bra',
    'breton'                        => 'br',
    'britishenglish'                => 'en_gb',
    'buginese'                      => 'bug',
    'bulgar'                        => 'bg',
    'buriat'                        => 'bua',
    'burmese'                       => 'my',
    'caddo'                         => 'cad',
    'canadianenglish'               => 'en_ca',
    'canadianfrench'                => 'fr_ca',
    'carib'                         => 'car',
    'catalan'                       => 'ca',
    'caucasianlanguage'             => 'cau',
    'cebuano'                       => 'ceb',
    'cec'                           => 'cs',
    'cecen'                         => 'ce',
    'centralamericanindianlanguage' => 'cai',
    'chagatai'                      => 'chg',
    'chamiclanguage'                => 'cmc',
    'chamorro'                      => 'ch',
    'cherokee'                      => 'chr',
    'cheyenne'                      => 'chy',
    'chibcha'                       => 'chb',
    'chinookjargon'                 => 'chn',
    'chipewyan'                     => 'chp',
    'choctaw'                       => 'cho',
    'chuukese'                      => 'chk',
    'chuvash'                       => 'cv',
    'cinês'                        => 'zh',
    'classicalnewari'               => 'nwc',
    'classicalsyriac'               => 'syc',
    'coptic'                        => 'cop',
    'corean'                        => 'ko',
    'cornualiês'                   => 'kw',
    'cors'                          => 'co',
    'cravuat'                       => 'hr',
    'cree'                          => 'cr',
    'creek'                         => 'mus',
    'creoleorpidgin'                => 'crp',
    'crimeanturkish'                => 'crh',
    'curd'                          => 'ku',
    'cushiticlanguage'              => 'cus',
    'dakota'                        => 'dak',
    'danês'                        => 'da',
    'dargwa'                        => 'dar',
    'dayak'                         => 'day',
    'delaware'                      => 'del',
    'dinka'                         => 'din',
    'divehi'                        => 'dv',
    'dogri'                         => 'doi',
    'dogrib'                        => 'dgr',
    'dravidianlanguage'             => 'dra',
    'duala'                         => 'dua',
    'dyula'                         => 'dyu',
    'dzongkha'                      => 'dz',
    'easternfrisian'                => 'frs',
    'ebraic'                        => 'he',
    'efik'                          => 'efi',
    'ekajuk'                        => 'eka',
    'elamite'                       => 'elx',
    'englishbasedcreoleorpidgin'    => 'cpe',
    'erzya'                         => 'myv',
    'esperanto'                     => 'eo',
    'eston'                         => 'et',
    'ewe'                           => 'ee',
    'ewondo'                        => 'ewo',
    'fang'                          => 'fan',
    'fanti'                         => 'fat',
    'faroês'                       => 'fo',
    'filipino'                      => 'fil',
    'finlandês'                    => 'fi',
    'finnougrianlanguage'           => 'fiu',
    'fizian'                        => 'fj',
    'flemish'                       => 'nl_be',
    'fon'                           => 'fon',
    'francês'                      => 'fr',
    'frenchbasedcreoleorpidgin'     => 'cpf',
    'frisian'                       => 'fy',
    'fulah'                         => 'ff',
    'furlan'                        => 'fur',
    'ga'                            => 'gaa',
    'gaelicirlandês'               => 'ga',
    'gaelicscozês'                 => 'gd',
    'galizian'                      => 'gl',
    'galês'                        => 'cy',
    'ganda'                         => 'lg',
    'gayo'                          => 'gay',
    'gbaya'                         => 'gba',
    'geez'                          => 'gez',
    'gilbertese'                    => 'gil',
    'gjaponês'                     => 'ja',
    'gjeorgjian'                    => 'ka',
    'gondi'                         => 'gon',
    'gorontalo'                     => 'gor',
    'gotic'                         => 'got',
    'grebo'                         => 'grb',
    'grêc'                         => 'el',
    'guarani'                       => 'gn',
    'gujarati'                      => 'gu',
    "gwich\Ê\¼in"                 => 'gwi',
    'haida'                         => 'hai',
    'haitian'                       => 'ht',
    'hausa'                         => 'ha',
    'hawaiian'                      => 'haw',
    'herero'                        => 'hz',
    'hiligaynon'                    => 'hil',
    'himachali'                     => 'him',
    'hindi'                         => 'hi',
    'hirimotu'                      => 'ho',
    'hittite'                       => 'hit',
    'hmong'                         => 'hmn',
    'hupa'                          => 'hup',
    'iban'                          => 'iba',
    'iberianportuguese'             => 'pt_pt',
    'iberianspanish'                => 'es_es',
    'ido'                           => 'io',
    'igbo'                          => 'ig',
    'ijo'                           => 'ijo',
    'iloko'                         => 'ilo',
    'inarisami'                     => 'smn',
    'indeterminade'                 => 'und',
    'indiclanguage'                 => 'inc',
    'indonesian'                    => 'id',
    'inglês'                       => 'en',
    'ingush'                        => 'inh',
    'interlingua'                   => 'ia',
    'interlingue'                   => 'ie',
    'inuktitut'                     => 'iu',
    'inupiaq'                       => 'ik',
    'iranianlanguage'               => 'ira',
    'iroquoianlanguage'             => 'iro',
    'islandês'                     => 'is',
    'javanese'                      => 'jv',
    'jju'                           => 'kaj',
    'judeoarabic'                   => 'jrb',
    'judeopersian'                  => 'jpr',
    'kabardian'                     => 'kbd',
    'kabyle'                        => 'kab',
    'kachin'                        => 'kac',
    'kalaallisut'                   => 'kl',
    'kalmyk'                        => 'xal',
    'kamba'                         => 'kam',
    'kannada'                       => 'kn',
    'kanuri'                        => 'kr',
    'karachaybalkar'                => 'krc',
    'karakalpak'                    => 'kaa',
    'karelian'                      => 'krl',
    'karen'                         => 'kar',
    'kashmiri'                      => 'ks',
    'kashubian'                     => 'csb',
    'kawi'                          => 'kaw',
    'kazac'                         => 'kk',
    'khasi'                         => 'kha',
    'khmer'                         => 'km',
    'khoisanlanguage'               => 'khi',
    'khotanese'                     => 'kho',
    'kikuyu'                        => 'ki',
    'kimbundu'                      => 'kmb',
    'kinyarwanda'                   => 'rw',
    'kirghiz'                       => 'ky',
    'klingon'                       => 'tlh',
    'komi'                          => 'kv',
    'kongo'                         => 'kg',
    'konkani'                       => 'kok',
    'koro'                          => 'kfo',
    'kosraean'                      => 'kos',
    'kpelle'                        => 'kpe',
    'kru'                           => 'kro',
    'kuanyama'                      => 'kj',
    'kumyk'                         => 'kum',
    'kurukh'                        => 'kru',
    'kutenai'                       => 'kut',
    'ladin'                         => 'lad',
    'lahnda'                        => 'lah',
    'lamba'                         => 'lam',
    'lao'                           => 'lo',
    'latin'                         => 'la',
    'lengheapache'                  => 'apa',
    'lengheceltiche'                => 'cel',
    'lenghegjermaniche'             => 'gem',
    'lengheindoeuropeane'           => 'ine',
    'lengheromanze'                 => 'roa',
    'lenghesclave'                  => 'sla',
    'lenghisaustralianis'           => 'aus',
    'lenghismaya'                   => 'myn',
    'lenghismultiplis'              => 'mul',
    'lenghisvariis'                 => 'mis',
    'leton'                         => 'lv',
    'lezghian'                      => 'lez',
    'limburghês'                   => 'li',
    'lingala'                       => 'ln',
    'lituan'                        => 'lt',
    'lojban'                        => 'jbo',
    'lowersorbian'                  => 'dsb',
    'lozi'                          => 'loz',
    'lubakatanga'                   => 'lu',
    'lubalulua'                     => 'lua',
    'luiseno'                       => 'lui',
    'lulesami'                      => 'smj',
    'lunda'                         => 'lun',
    'luo'                           => 'luo',
    'lushai'                        => 'lus',
    'lussemburghês'                => 'lb',
    'macedon'                       => 'mk',
    'madurese'                      => 'mad',
    'magahi'                        => 'mag',
    'maithili'                      => 'mai',
    'makasar'                       => 'mak',
    'malagasy'                      => 'mg',
    'malayalam'                     => 'ml',
    'maltês'                       => 'mt',
    'malês'                        => 'ms',
    'manchu'                        => 'mnc',
    'mandar'                        => 'mdr',
    'mandingo'                      => 'man',
    'manipuri'                      => 'mni',
    'manobolanguage'                => 'mno',
    'manx'                          => 'gv',
    'maori'                         => 'mi',
    'marathi'                       => 'mr',
    'mari'                          => 'chm',
    'marshallese'                   => 'mh',
    'marwari'                       => 'mwr',
    'masai'                         => 'mas',
    'mende'                         => 'men',
    'micmac'                        => 'mic',
    'middledutch'                   => 'dum',
    'middleenglish'                 => 'enm',
    'middlefrench'                  => 'frm',
    'middlehighgerman'              => 'gmh',
    'middleirish'                   => 'mga',
    'minangkabau'                   => 'min',
    'mirandês'                     => 'mwl',
    'mohawk'                        => 'moh',
    'moksha'                        => 'mdf',
    'moldâf'                       => 'mo',
    'mongo'                         => 'lol',
    'mongul'                        => 'mn',
    'monkhmerlanguage'              => 'mkh',
    'morisyen'                      => 'mfe',
    'mossi'                         => 'mos',
    'mundalanguage'                 => 'mun',
    'nahuatl'                       => 'nah',
    'napoletan'                     => 'nap',
    'nauru'                         => 'na',
    'navajo'                        => 'nv',
    'ndonga'                        => 'ng',
    'nepalês'                      => 'ne',
    'newari'                        => 'new',
    'nias'                          => 'nia',
    'nigerkordofanianlanguage'      => 'nic',
    'nilosaharanlanguage'           => 'ssa',
    'niuean'                        => 'niu',
    'nogai'                         => 'nog',
    'nolinguisticcontent'           => 'zxx',
    'northamericanindianlanguage'   => 'nai',
    'northernfrisian'               => 'frr',
    'northernsotho'                 => 'nso',
    'northndebele'                  => 'nd',
    'norvegjês'                    => 'no',
    'norvegjêsbokmål'             => 'nb',
    'norvegjêsnynorsk'             => 'nn',
    'nubianlanguage'                => 'nub',
    'nyamwezi'                      => 'nym',
    'nyanja'                        => 'ny',
    'nyankole'                      => 'nyn',
    'nyasatonga'                    => 'tog',
    'nyoro'                         => 'nyo',
    'nzima'                         => 'nzi',
    "n\â\\ko"                  => 'nqo',
    'ocitan'                        => 'oc',
    'ojibwa'                        => 'oj',
    'olandês'                      => 'nl',
    'oldhighgerman'                 => 'goh',
    'ongjarês'                     => 'hu',
    'oriya'                         => 'or',
    'oromo'                         => 'om',
    'osage'                         => 'osa',
    'osetic'                        => 'os',
    'otomianlanguage'               => 'oto',
    'pahlavi'                       => 'pal',
    'palauan'                       => 'pau',
    'pali'                          => 'pi',
    'pampanga'                      => 'pam',
    'pangasinan'                    => 'pag',
    'papiamento'                    => 'pap',
    'papuanlanguage'                => 'paa',
    'pashto'                        => 'ps',
    'persian'                       => 'fa',
    'philippinelanguage'            => 'phi',
    'phoenician'                    => 'phn',
    'pohnpeian'                     => 'pon',
    'polac'                         => 'pl',
    'portughês'                    => 'pt',
    'portughêsbrasilian'           => 'pt_br',
    'portuguesebasedcreoleorpidgin' => 'cpp',
    'prakritlanguage'               => 'pra',
    'punjabi'                       => 'pa',
    'quechua'                       => 'qu',
    'rajasthani'                    => 'raj',
    'rapanui'                       => 'rap',
    'rarotongan'                    => 'rar',
    'romany'                        => 'rom',
    'romen'                         => 'ro',
    'rumanç'                       => 'rm',
    'rundi'                         => 'rn',
    'rus'                           => 'ru',
    'salishanlanguage'              => 'sal',
    'samaritanaramaic'              => 'sam',
    'samilanguage'                  => 'smi',
    'samisetentrionâl'             => 'se',
    'samoan'                        => 'sm',
    'sandawe'                       => 'sad',
    'sango'                         => 'sg',
    'sanscrit'                      => 'sa',
    'santali'                       => 'sat',
    'sardegnûl'                    => 'sc',
    'sasak'                         => 'sas',
    'sclâf'                        => 'den',
    'sclâfdeglesie'                => 'cu',
    'scozês'                       => 'sco',
    'selkup'                        => 'sel',
    'semiticlanguage'               => 'sem',
    'serbocroatian'                 => 'sh',
    'serer'                         => 'srr',
    'serp'                          => 'sr',
    'shan'                          => 'shn',
    'shona'                         => 'sn',
    'sichuanyi'                     => 'ii',
    'sicilian'                      => 'scn',
    'sidamo'                        => 'sid',
    'signlanguage'                  => 'sgn',
    'siksika'                       => 'bla',
    'sinalês'                      => 'si',
    'sindhi'                        => 'sd',
    'sinotibetanlanguage'           => 'sit',
    'siouanlanguage'                => 'sio',
    'skoltsami'                     => 'sms',
    'slovac'                        => 'sk',
    'sloven'                        => 'sl',
    'sogdien'                       => 'sog',
    'somal'                         => 'so',
    'songhai'                       => 'son',
    'soninke'                       => 'snk',
    'sorbianlanguage'               => 'wen',
    'southamericanindianlanguage'   => 'sai',
    'southernaltai'                 => 'alt',
    'southernsami'                  => 'sma',
    'southernsotho'                 => 'st',
    'southndebele'                  => 'nr',
    'spagnûl'                      => 'es',
    'sranantongo'                   => 'srn',
    'sukuma'                        => 'suk',
    'sumeric'                       => 'sux',
    'sundanese'                     => 'su',
    'susu'                          => 'sus',
    'svedês'                       => 'sv',
    'swahili'                       => 'sw',
    'swati'                         => 'ss',
    'swissfrench'                   => 'fr_ch',
    'swissgerman'                   => 'gsw',
    'swisshighgerman'               => 'de_ch',
    'syriac'                        => 'syr',
    'tagalog'                       => 'tl',
    'tagic'                         => 'tg',
    'tahitian'                      => 'ty',
    'tailanguage'                   => 'tai',
    'talian'                        => 'it',
    'tamashek'                      => 'tmh',
    'tamil'                         => 'ta',
    'taroko'                        => 'trv',
    'tartar'                        => 'tt',
    'telegu'                        => 'te',
    'tereno'                        => 'ter',
    'tetum'                         => 'tet',
    'thai'                          => 'th',
    'tibetan'                       => 'bo',
    'tigre'                         => 'tig',
    'tigrinya'                      => 'ti',
    'timne'                         => 'tem',
    'tiv'                           => 'tiv',
    'tlingit'                       => 'tli',
    'todesc'                        => 'de',
    'tokelau'                       => 'tkl',
    'tokpisin'                      => 'tpi',
    'tonga'                         => 'to',
    'tsimshian'                     => 'tsi',
    'tsonga'                        => 'ts',
    'tswana'                        => 'tn',
    'tumbuka'                       => 'tum',
    'tupilanguage'                  => 'tup',
    'turc'                          => 'tr',
    'turcotoman'                    => 'ota',
    'turkmen'                       => 'tk',
    'tuvalu'                        => 'tvl',
    'tuvinian'                      => 'tyv',
    'twi'                           => 'tw',
    'tyap'                          => 'kcg',
    "u\.s\.english"                 => 'en_us',
    'ucrain'                        => 'uk',
    'udmurt'                        => 'udm',
    'ugaritic'                      => 'uga',
    'umbundu'                       => 'umb',
    'uppersorbian'                  => 'hsb',
    'urdu'                          => 'ur',
    'uyghur'                        => 'ug',
    'uzbec'                         => 'uz',
    'vai'                           => 'vai',
    'valon'                         => 'wa',
    'venda'                         => 've',
    'vieriegjizian'                 => 'egy',
    'vierifrancês'                 => 'fro',
    'vierigrêc'                    => 'grc',
    'vieriinglês'                  => 'ang',
    'vieriirlandês'                => 'sga',
    'vierinorvegjês'               => 'non',
    'vieripersian'                  => 'peo',
    'vieriprovenzâl'               => 'pro',
    'vietnamite'                    => 'vi',
    "volap\Ã\¼k"                  => 'vo',
    'votic'                         => 'vot',
    'wakashanlanguage'              => 'wak',
    'walamo'                        => 'wal',
    'waray'                         => 'war',
    'washo'                         => 'was',
    'wolof'                         => 'wo',
    'xhosa'                         => 'xh',
    'yakut'                         => 'sah',
    'yao'                           => 'yao',
    'yapese'                        => 'yap',
    'yiddish'                       => 'yi',
    'yoruba'                        => 'yo',
    'yupiklanguage'                 => 'ypk',
    'zande'                         => 'znd',
    'zapotec'                       => 'zap',
    'zaza'                          => 'zza',
    'zenaga'                        => 'zen',
    'zhuang'                        => 'za',
    'zulu'                          => 'zu',
    'zuni'                          => 'zun',
);

1;
