package Locales::DB::Language::pt;

# Auto generated from CLDR

$Locales::DB::Language::pt::VERSION = '0.01';

$Locales::DB::Language::pt::cldr_version = '1.7.1';

%Locales::DB::Language::pt::misc_info = (
    'cldr_formats' => {
        'decimal'   => "\#\,\#\#0\.\#\#\#",
        'language'  => "Idioma\:\ \{0\}",
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0\%",
        'territory' => "Região\:\ \{0\}"
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'posix' => {
        'nostr'  => "não\:n",
        'yesstr' => "sim\:s"
    },
);

%Locales::DB::Language::pt::code_to_name = (
    'aa'    => 'afar',
    'ab'    => 'abcázio',
    'ace'   => 'achém',
    'ach'   => 'acoli',
    'ada'   => 'adangme',
    'ady'   => 'adigue',
    'ae'    => 'avéstico',
    'af'    => 'africâner',
    'afa'   => "idioma\ afro\-asiático",
    'afh'   => 'afrihili',
    'ain'   => 'ainu',
    'ak'    => 'akan',
    'akk'   => 'acadiano',
    'ale'   => 'aleúte',
    'alg'   => "idioma\ algonquiano",
    'alt'   => "altai\ do\ sul",
    'am'    => 'amárico',
    'an'    => 'aragonês',
    'ang'   => "inglês\ arcaico",
    'anp'   => 'angika',
    'apa'   => "idioma\ apache",
    'ar'    => 'árabe',
    'arc'   => 'aramaico',
    'arn'   => 'araucano',
    'arp'   => 'arapaho',
    'art'   => "idioma\ artificial",
    'arw'   => 'arauaqui',
    'as'    => 'assamês',
    'ast'   => 'asturiano',
    'ath'   => "idioma\ atabascano",
    'aus'   => "idioma\ australiano",
    'av'    => 'avaric',
    'awa'   => 'awadhi',
    'ay'    => 'aimara',
    'az'    => 'azerbaijano',
    'ba'    => 'bashkir',
    'bad'   => 'banda',
    'bai'   => "idioma\ bamileke",
    'bal'   => 'balúchi',
    'ban'   => 'balinês',
    'bas'   => 'basa',
    'bat'   => "idioma\ báltico",
    'be'    => "bielo\-russo",
    'bej'   => 'beja',
    'bem'   => 'bemba',
    'ber'   => 'berbere',
    'bg'    => 'búlgaro',
    'bh'    => 'biari',
    'bho'   => 'bhojpuri',
    'bi'    => 'bislamá',
    'bik'   => 'bikol',
    'bin'   => 'bini',
    'bla'   => 'siksika',
    'bm'    => 'bambara',
    'bn'    => 'bengali',
    'bnt'   => 'banto',
    'bo'    => 'tibetano',
    'br'    => 'bretão',
    'bra'   => 'braj',
    'bs'    => 'bósnio',
    'btk'   => 'bataque',
    'bua'   => 'buriat',
    'bug'   => 'buguinês',
    'byn'   => 'blin',
    'ca'    => 'catalão',
    'cad'   => 'caddo',
    'cai'   => "idioma\ indígena\ centro\-americano",
    'car'   => 'caribe',
    'cau'   => "idioma\ caucásico",
    'cch'   => 'atsam',
    'ce'    => 'checheno',
    'ceb'   => 'cebuano',
    'cel'   => "idioma\ celta",
    'ch'    => 'chamorro',
    'chb'   => 'chibcha',
    'chg'   => 'chagatai',
    'chk'   => 'chuukese',
    'chm'   => 'mari',
    'chn'   => "chinook\ jargon",
    'cho'   => 'choctaw',
    'chp'   => 'chipewyan',
    'chr'   => 'cherokee',
    'chy'   => 'cheiene',
    'cmc'   => "idioma\ chamic",
    'co'    => 'córsico',
    'cop'   => 'copta',
    'cpe'   => "crioulo\ ou\ pidgin\ baseado\ no\ inglês",
    'cpf'   => "crioulo\ ou\ pidgin\ baseado\ no\ francês",
    'cpp'   => "crioulo\ ou\ pidgin\ baseado\ no\ português",
    'cr'    => 'cree',
    'crh'   => "turco\ da\ Crimeia",
    'crp'   => "crioulo\ ou\ pidgin",
    'cs'    => 'tcheco',
    'csb'   => 'kashubian',
    'cu'    => "eslavo\ eclesiástico",
    'cus'   => "idioma\ cuchítico",
    'cv'    => 'chuvash',
    'cy'    => 'galês',
    'da'    => 'dinamarquês',
    'dak'   => 'dacota',
    'dar'   => 'dargwa',
    'day'   => 'dayak',
    'de'    => 'alemão',
    'de_at' => "alemão\ austríaco",
    'de_ch' => "alto\ alemão\ suíço",
    'del'   => 'delaware',
    'den'   => 'slave',
    'dgr'   => 'dogrib',
    'din'   => 'dinka',
    'doi'   => 'dogri',
    'dra'   => "idioma\ dravidiano",
    'dsb'   => "sérvio\ baixo",
    'dua'   => 'duala',
    'dum'   => "holandês\ médio",
    'dv'    => 'divehi',
    'dyu'   => 'diúla',
    'dz'    => 'dzonga',
    'ee'    => 'eve',
    'efi'   => 'efique',
    'egy'   => "egípcio\ arcaico",
    'eka'   => 'ekajuk',
    'el'    => 'grego',
    'elx'   => 'elamite',
    'en'    => 'inglês',
    'en_au' => "inglês\ australiano",
    'en_ca' => "inglês\ canadense",
    'en_gb' => "inglês\ britânico",
    'en_us' => "inglês\ americano",
    'enm'   => "inglês\ médio",
    'eo'    => 'esperanto',
    'es'    => 'espanhol',
    'es_es' => "espanhol\ ibérico",
    'et'    => 'estoniano',
    'eu'    => 'basco',
    'ewo'   => 'ewondo',
    'fa'    => 'persa',
    'fan'   => 'fangue',
    'fat'   => 'fanti',
    'ff'    => 'fula',
    'fi'    => 'finlandês',
    'fil'   => 'filipino',
    'fiu'   => "idioma\ fino\-úgrico",
    'fj'    => 'fijiano',
    'fo'    => 'feroês',
    'fon'   => 'fom',
    'fr'    => 'francês',
    'fr_ca' => "francês\ canadense",
    'fr_ch' => "francês\ suíço",
    'frm'   => "francês\ médio",
    'fro'   => "francês\ arcaico",
    'frr'   => "frísio\ setentrional",
    'frs'   => "frisão\ oriental",
    'fur'   => 'friulano',
    'fy'    => "frísio\ ocidental",
    'ga'    => 'irlandês',
    'gaa'   => 'ga',
    'gay'   => 'gayo',
    'gba'   => 'gbaia',
    'gd'    => "gaélico\ escocês",
    'gem'   => "idioma\ germânico",
    'gez'   => 'geez',
    'gil'   => 'gilbertês',
    'gl'    => 'galego',
    'gmh'   => "alemão\ médio\-alto",
    'gn'    => 'guarani',
    'goh'   => "alemão\ arcaico\ alto",
    'gon'   => 'gondi',
    'gor'   => 'gorontalo',
    'got'   => 'gótico',
    'grb'   => 'grebo',
    'grc'   => "grego\ arcaico",
    'gsw'   => "alemão\ suíço",
    'gu'    => 'guzerate',
    'gv'    => 'manx',
    'gwi'   => 'gwichʼin',
    'ha'    => 'hauçá',
    'hai'   => 'haida',
    'haw'   => 'havaiano',
    'he'    => 'hebraico',
    'hi'    => 'híndi',
    'hil'   => 'hiligaynon',
    'him'   => 'himachali',
    'hit'   => 'hitita',
    'hmn'   => 'hmong',
    'ho'    => "hiri\ motu",
    'hr'    => 'croata',
    'hsb'   => "sorábio\ superior",
    'ht'    => 'haitiano',
    'hu'    => 'húngaro',
    'hup'   => 'hupa',
    'hy'    => 'armênio',
    'hz'    => 'herero',
    'ia'    => 'interlíngua',
    'iba'   => 'iban',
    'id'    => 'indonésio',
    'ie'    => 'interlingue',
    'ig'    => 'ibo',
    'ii'    => "sichuan\ yi",
    'ijo'   => 'ijo',
    'ik'    => 'inupiaque',
    'ilo'   => 'ilocano',
    'inc'   => "idioma\ índico",
    'ine'   => "idioma\ indo\-europeu",
    'inh'   => 'inguche',
    'io'    => 'ido',
    'ira'   => 'iraniano',
    'iro'   => "idioma\ iroquês",
    'is'    => 'islandês',
    'it'    => 'italiano',
    'iu'    => 'inuktitut',
    'ja'    => 'japonês',
    'jbo'   => 'lojban',
    'jpr'   => "judaico\-persa",
    'jrb'   => "judaico\-arábico",
    'jv'    => 'javanês',
    'ka'    => 'georgiano',
    'kaa'   => "kara\-kalpak",
    'kab'   => 'kabyle',
    'kac'   => 'kachin',
    'kaj'   => 'jju',
    'kam'   => 'kamba',
    'kar'   => 'karen',
    'kaw'   => 'kawi',
    'kbd'   => 'kabardiano',
    'kcg'   => 'tyap',
    'kfo'   => 'koro',
    'kg'    => 'congolês',
    'kha'   => 'khasi',
    'khi'   => "idioma\ coisã",
    'kho'   => 'khotanês',
    'ki'    => 'quicuio',
    'kj'    => 'kuanyama',
    'kk'    => 'cazaque',
    'kl'    => 'groenlandês',
    'km'    => 'cmer',
    'kmb'   => 'quimbundo',
    'kn'    => 'canarês',
    'ko'    => 'coreano',
    'kok'   => 'concani',
    'kos'   => 'kosraean',
    'kpe'   => 'kpelle',
    'kr'    => 'canúri',
    'krc'   => "karachay\-balkar",
    'krl'   => "idioma\ carélio",
    'kro'   => 'kru',
    'kru'   => 'kurukh',
    'ks'    => 'caxemira',
    'ku'    => 'curdo',
    'kum'   => 'kumyk',
    'kut'   => 'kutenai',
    'kv'    => 'komi',
    'kw'    => 'córnico',
    'ky'    => 'quirguiz',
    'la'    => 'latim',
    'lad'   => 'ladino',
    'lah'   => 'lahnda',
    'lam'   => 'lamba',
    'lb'    => 'luxemburguês',
    'lez'   => 'lezghian',
    'lg'    => 'luganda',
    'li'    => 'limburguês',
    'ln'    => 'lingala',
    'lo'    => 'laosiano',
    'lol'   => 'mongo',
    'loz'   => 'lozi',
    'lt'    => 'lituano',
    'lu'    => "luba\-catanga",
    'lua'   => "luba\-lulua",
    'lui'   => 'luiseno',
    'lun'   => 'lunda',
    'luo'   => 'luo',
    'lus'   => 'lushai',
    'lv'    => 'letão',
    'mad'   => 'madurês',
    'mag'   => 'magahi',
    'mai'   => 'maithili',
    'mak'   => 'makasar',
    'man'   => 'mandinga',
    'map'   => 'austronésio',
    'mas'   => 'massai',
    'mdf'   => 'mocsa',
    'mdr'   => 'mandar',
    'men'   => 'mende',
    'mfe'   => 'Morisyen',
    'mg'    => 'malgaxe',
    'mga'   => "irlandês\ médio",
    'mh'    => 'marshalês',
    'mi'    => 'maori',
    'mic'   => 'miquemaque',
    'min'   => 'minangkabau',
    'mis'   => "idiomas\ diversos",
    'mk'    => 'macedônio',
    'mkh'   => "idioma\ mon\-khmer",
    'ml'    => 'malaiala',
    'mn'    => 'mongol',
    'mnc'   => 'manchu',
    'mni'   => 'manipuri',
    'mno'   => "idioma\ manobo",
    'mo'    => 'moldávio',
    'moh'   => 'mohawk',
    'mos'   => 'mossi',
    'mr'    => 'marata',
    'ms'    => 'malaio',
    'mt'    => 'maltês',
    'mul'   => "idiomas\ múltiplos",
    'mun'   => "idiomas\ munda",
    'mus'   => 'creek',
    'mwl'   => 'mirandês',
    'mwr'   => 'marwari',
    'my'    => 'birmanês',
    'myn'   => 'maia',
    'myv'   => 'erzya',
    'na'    => 'nauruano',
    'nah'   => 'náuatle',
    'nai'   => "idioma\ indígena\ norte\-americano",
    'nap'   => 'napolitano',
    'nb'    => "bokmål\ norueguês",
    'nd'    => "ndebele\ do\ norte",
    'nds'   => "baixo\-alemão",
    'ne'    => 'nepali',
    'new'   => 'newari',
    'ng'    => 'dongo',
    'nia'   => 'nias',
    'nic'   => "idioma\ cordofano\-nigeriano",
    'niu'   => 'niueano',
    'nl'    => 'holandês',
    'nl_be' => 'flamengo',
    'nn'    => "nynorsk\ norueguês",
    'no'    => 'norueguês',
    'nog'   => 'nogai',
    'non'   => "nórdico\ arcaico",
    'nqo'   => "n\'ko",
    'nr'    => "ndebele\ do\ sul",
    'nso'   => "soto\ setentrional",
    'nub'   => "idioma\ núbio",
    'nv'    => 'navajo',
    'nwc'   => "newari\ clássico",
    'ny'    => 'nianja',
    'nym'   => 'nyamwezi',
    'nyn'   => 'nyankole',
    'nyo'   => 'nyoro',
    'nzi'   => 'nzima',
    'oc'    => 'occitânico',
    'oj'    => 'ojibwa',
    'om'    => 'oromo',
    'or'    => 'oriya',
    'os'    => 'ossetic',
    'osa'   => 'osage',
    'ota'   => "turco\ otomano",
    'oto'   => "idioma\ otomano",
    'pa'    => 'panjabi',
    'paa'   => "idioma\ papuano",
    'pag'   => 'pangasinã',
    'pal'   => 'pálavi',
    'pam'   => 'pampanga',
    'pap'   => 'papiamento',
    'pau'   => 'palauano',
    'peo'   => "persa\ arcaico",
    'phi'   => "idioma\ filipino",
    'phn'   => 'fenício',
    'pi'    => 'páli',
    'pl'    => 'polonês',
    'pon'   => 'pohnpeian',
    'pra'   => "idioma\ prácrito",
    'pro'   => "provençal\ arcaico",
    'ps'    => 'pashto',
    'pt'    => 'português',
    'pt_br' => "português\ do\ Brasil",
    'pt_pt' => "português\ ibérico",
    'qu'    => 'quíchua',
    'raj'   => 'rajastani',
    'rap'   => 'rapanui',
    'rar'   => 'rarotongano',
    'rm'    => "reto\-romano",
    'rn'    => 'rundi',
    'ro'    => 'romeno',
    'roa'   => "idioma\ românico",
    'rom'   => 'romani',
    'ru'    => 'russo',
    'rup'   => 'aromeno',
    'rw'    => 'kinyarwanda',
    'sa'    => 'sânscrito',
    'sad'   => 'sandawe',
    'sah'   => 'iacuto',
    'sai'   => "idioma\ indígena\ sul\-americano",
    'sal'   => "idioma\ salisano",
    'sam'   => "aramaico\ samaritano",
    'sas'   => 'sasak',
    'sat'   => 'santali',
    'sc'    => 'sardo',
    'scn'   => 'siciliano',
    'sco'   => 'escocês',
    'sd'    => 'sindi',
    'se'    => "sami\ do\ norte",
    'sel'   => 'selkup',
    'sem'   => "idioma\ semítico",
    'sg'    => 'sango',
    'sga'   => "irlandês\ arcaico",
    'sgn'   => "linguagem\ de\ sinais",
    'sh'    => "servo\-croata",
    'shn'   => 'shan',
    'si'    => 'cingalês',
    'sid'   => 'sidamo',
    'sio'   => "idioma\ sioux",
    'sit'   => "idioma\ sino\-tibetano",
    'sk'    => 'eslovaco',
    'sl'    => 'esloveno',
    'sla'   => "idioma\ eslavo",
    'sm'    => 'samoano',
    'sma'   => "sami\ do\ sul",
    'smi'   => "idioma\ sami",
    'smj'   => "lule\ sami",
    'smn'   => "inari\ sami",
    'sms'   => "skolt\ sami",
    'sn'    => 'shona',
    'snk'   => 'soninquê',
    'so'    => 'somali',
    'sog'   => 'sogdiano',
    'son'   => 'songai',
    'sq'    => 'albanês',
    'sr'    => 'sérvio',
    'srn'   => "idioma\ surinamês",
    'srr'   => 'serere',
    'ss'    => 'swati',
    'ssa'   => "idioma\ nilo\-saariano",
    'st'    => "soto\ do\ sul",
    'su'    => 'sundanês',
    'suk'   => 'sukuma',
    'sus'   => 'sosso',
    'sux'   => 'sumério',
    'sv'    => 'sueco',
    'sw'    => 'suaili',
    'syc'   => "siríaco\ clássico",
    'syr'   => 'siríaco',
    'ta'    => 'tâmil',
    'tai'   => "idioma\ tailandês",
    'te'    => 'telugu',
    'tem'   => 'timne',
    'ter'   => 'tereno',
    'tet'   => 'tétum',
    'tg'    => 'tadjique',
    'th'    => 'tailandês',
    'ti'    => 'tigrínia',
    'tig'   => 'tigré',
    'tiv'   => 'tiv',
    'tk'    => 'turcomano',
    'tkl'   => 'toquelauano',
    'tl'    => 'tagalo',
    'tlh'   => 'klingon',
    'tli'   => 'tlinguite',
    'tmh'   => 'tamaxeque',
    'tn'    => 'tswana',
    'to'    => 'tonganês',
    'tog'   => "tonganês\ de\ Nyasa",
    'tpi'   => "tok\ pisin",
    'tr'    => 'turco',
    'trv'   => 'Taroko',
    'ts'    => 'tsonga',
    'tsi'   => 'tsimshian',
    'tt'    => 'tatar',
    'tum'   => 'tumbuka',
    'tup'   => "idioma\ tupi",
    'tut'   => "idioma\ altaico",
    'tvl'   => 'tuvaluano',
    'tw'    => 'twi',
    'ty'    => 'taitiano',
    'tyv'   => 'tuvinian',
    'udm'   => 'udmurt',
    'ug'    => 'uighur',
    'uga'   => 'ugarítico',
    'uk'    => 'ucraniano',
    'umb'   => 'umbundu',
    'und'   => "idioma\ inválido\ ou\ desconhecido",
    'ur'    => 'urdu',
    'uz'    => 'usbeque',
    'vai'   => 'vai',
    've'    => 'venda',
    'vi'    => 'vietnamita',
    'vo'    => 'volapuque',
    'vot'   => 'votic',
    'wa'    => 'valão',
    'wak'   => "idioma\ wakashan",
    'wal'   => 'walamo',
    'war'   => 'waray',
    'was'   => 'washo',
    'wen'   => "idioma\ sorábio",
    'wo'    => 'uólofe',
    'xal'   => 'kalmyk',
    'xh'    => 'xosa',
    'yao'   => 'yao',
    'yap'   => 'yapese',
    'yi'    => 'iídiche',
    'yo'    => 'ioruba',
    'ypk'   => "idioma\ iúpique",
    'za'    => 'zhuang',
    'zap'   => 'zapoteca',
    'zbl'   => "símbolos\ blis",
    'zen'   => 'zenaga',
    'zh'    => 'chinês',
    'znd'   => 'zande',
    'zu'    => 'zulu',
    'zun'   => 'zunhi',
    'zxx'   => "sem\ conteúdo\ linguístico",
    'zza'   => 'zaza',
);

%Locales::DB::Language::pt::name_to_code = (
    'abczio'                                     => 'ab',
    'acadiano'                                   => 'akk',
    'achm'                                       => 'ace',
    'acoli'                                      => 'ach',
    'adangme'                                    => 'ada',
    'adigue'                                     => 'ady',
    'afar'                                       => 'aa',
    'africner'                                   => 'af',
    'afrihili'                                   => 'afh',
    'aimara'                                     => 'ay',
    'ainu'                                       => 'ain',
    'akan'                                       => 'ak',
    'albans'                                     => 'sq',
    'alemo'                                      => 'de',
    "alemo\ arcaico\ alto"                       => 'goh',
    "alemo\ austraco"                            => 'de_at',
    "alemo\ mdioalto"                            => 'gmh',
    "alemo\ suo"                                 => 'gsw',
    'alete'                                      => 'ale',
    "altai\ do\ sul"                             => 'alt',
    "alto\ alemo\ suo"                           => 'de_ch',
    'amrico'                                     => 'am',
    'angika'                                     => 'anp',
    'aragons'                                    => 'an',
    'aramaico'                                   => 'arc',
    "aramaico\ samaritano"                       => 'sam',
    'arapaho'                                    => 'arp',
    'arauaqui'                                   => 'arw',
    'araucano'                                   => 'arn',
    'armnio'                                     => 'hy',
    'aromeno'                                    => 'rup',
    'assams'                                     => 'as',
    'asturiano'                                  => 'ast',
    'atsam'                                      => 'cch',
    'austronsio'                                 => 'map',
    'avaric'                                     => 'av',
    'avstico'                                    => 'ae',
    'awadhi'                                     => 'awa',
    'azerbaijano'                                => 'az',
    'baixoalemo'                                 => 'nds',
    'balchi'                                     => 'bal',
    'balins'                                     => 'ban',
    'bambara'                                    => 'bm',
    'banda'                                      => 'bad',
    'banto'                                      => 'bnt',
    'basa'                                       => 'bas',
    'basco'                                      => 'eu',
    'bashkir'                                    => 'ba',
    'bataque'                                    => 'btk',
    'beja'                                       => 'bej',
    'bemba'                                      => 'bem',
    'bengali'                                    => 'bn',
    'berbere'                                    => 'ber',
    'bhojpuri'                                   => 'bho',
    'biari'                                      => 'bh',
    'bielorusso'                                 => 'be',
    'bikol'                                      => 'bik',
    'bini'                                       => 'bin',
    'birmans'                                    => 'my',
    'bislam'                                     => 'bi',
    'blgaro'                                     => 'bg',
    'blin'                                       => 'byn',
    "bokml\ noruegus"                            => 'nb',
    'braj'                                       => 'bra',
    'breto'                                      => 'br',
    'bsnio'                                      => 'bs',
    'buguins'                                    => 'bug',
    'buriat'                                     => 'bua',
    'caddo'                                      => 'cad',
    'canars'                                     => 'kn',
    'canri'                                      => 'kr',
    'caribe'                                     => 'car',
    'catalo'                                     => 'ca',
    'caxemira'                                   => 'ks',
    'cazaque'                                    => 'kk',
    'cebuano'                                    => 'ceb',
    'chagatai'                                   => 'chg',
    'chamorro'                                   => 'ch',
    'checheno'                                   => 'ce',
    'cheiene'                                    => 'chy',
    'cherokee'                                   => 'chr',
    'chibcha'                                    => 'chb',
    "chinook\ jargon"                            => 'chn',
    'chins'                                      => 'zh',
    'chipewyan'                                  => 'chp',
    'choctaw'                                    => 'cho',
    'chuukese'                                   => 'chk',
    'chuvash'                                    => 'cv',
    'cingals'                                    => 'si',
    'cmer'                                       => 'km',
    'concani'                                    => 'kok',
    'congols'                                    => 'kg',
    'copta'                                      => 'cop',
    'coreano'                                    => 'ko',
    'cree'                                       => 'cr',
    'creek'                                      => 'mus',
    "crioulo\ ou\ pidgin"                        => 'crp',
    "crioulo\ ou\ pidgin\ baseado\ no\ francs"   => 'cpf',
    "crioulo\ ou\ pidgin\ baseado\ no\ ingls"    => 'cpe',
    "crioulo\ ou\ pidgin\ baseado\ no\ portugus" => 'cpp',
    'crnico'                                     => 'kw',
    'croata'                                     => 'hr',
    'crsico'                                     => 'co',
    'curdo'                                      => 'ku',
    'dacota'                                     => 'dak',
    'dargwa'                                     => 'dar',
    'dayak'                                      => 'day',
    'delaware'                                   => 'del',
    'dila'                                       => 'dyu',
    'dinamarqus'                                 => 'da',
    'dinka'                                      => 'din',
    'divehi'                                     => 'dv',
    'dogri'                                      => 'doi',
    'dogrib'                                     => 'dgr',
    'dongo'                                      => 'ng',
    'duala'                                      => 'dua',
    'dzonga'                                     => 'dz',
    'efique'                                     => 'efi',
    "egpcio\ arcaico"                            => 'egy',
    'ekajuk'                                     => 'eka',
    'elamite'                                    => 'elx',
    'erzya'                                      => 'myv',
    'escocs'                                     => 'sco',
    "eslavo\ eclesistico"                        => 'cu',
    'eslovaco'                                   => 'sk',
    'esloveno'                                   => 'sl',
    'espanhol'                                   => 'es',
    "espanhol\ ibrico"                           => 'es_es',
    'esperanto'                                  => 'eo',
    'estoniano'                                  => 'et',
    'eve'                                        => 'ee',
    'ewondo'                                     => 'ewo',
    'fangue'                                     => 'fan',
    'fanti'                                      => 'fat',
    'fencio'                                     => 'phn',
    'feros'                                      => 'fo',
    'fijiano'                                    => 'fj',
    'filipino'                                   => 'fil',
    'finlands'                                   => 'fi',
    'flamengo'                                   => 'nl_be',
    'fom'                                        => 'fon',
    'francs'                                     => 'fr',
    "francs\ arcaico"                            => 'fro',
    "francs\ canadense"                          => 'fr_ca',
    "francs\ mdio"                               => 'frm',
    "francs\ suo"                                => 'fr_ch',
    "friso\ oriental"                            => 'frs',
    'friulano'                                   => 'fur',
    "frsio\ ocidental"                           => 'fy',
    "frsio\ setentrional"                        => 'frr',
    'fula'                                       => 'ff',
    'ga'                                         => 'gaa',
    'galego'                                     => 'gl',
    "galico\ escocs"                             => 'gd',
    'gals'                                       => 'cy',
    'gayo'                                       => 'gay',
    'gbaia'                                      => 'gba',
    'geez'                                       => 'gez',
    'georgiano'                                  => 'ka',
    'gilberts'                                   => 'gil',
    'gondi'                                      => 'gon',
    'gorontalo'                                  => 'gor',
    'grebo'                                      => 'grb',
    'grego'                                      => 'el',
    "grego\ arcaico"                             => 'grc',
    'groenlands'                                 => 'kl',
    'gtico'                                      => 'got',
    'guarani'                                    => 'gn',
    'guzerate'                                   => 'gu',
    'gwichin'                                    => 'gwi',
    'haida'                                      => 'hai',
    'haitiano'                                   => 'ht',
    'hau'                                        => 'ha',
    'havaiano'                                   => 'haw',
    'hebraico'                                   => 'he',
    'herero'                                     => 'hz',
    'hiligaynon'                                 => 'hil',
    'himachali'                                  => 'him',
    "hiri\ motu"                                 => 'ho',
    'hitita'                                     => 'hit',
    'hmong'                                      => 'hmn',
    'hndi'                                       => 'hi',
    'hngaro'                                     => 'hu',
    'holands'                                    => 'nl',
    "holands\ mdio"                              => 'dum',
    'hupa'                                       => 'hup',
    'iacuto'                                     => 'sah',
    'iban'                                       => 'iba',
    'ibo'                                        => 'ig',
    'idiche'                                     => 'yi',
    "idioma\ afroasitico"                        => 'afa',
    "idioma\ algonquiano"                        => 'alg',
    "idioma\ altaico"                            => 'tut',
    "idioma\ apache"                             => 'apa',
    "idioma\ artificial"                         => 'art',
    "idioma\ atabascano"                         => 'ath',
    "idioma\ australiano"                        => 'aus',
    "idioma\ bamileke"                           => 'bai',
    "idioma\ bltico"                             => 'bat',
    "idioma\ carlio"                             => 'krl',
    "idioma\ caucsico"                           => 'cau',
    "idioma\ celta"                              => 'cel',
    "idioma\ chamic"                             => 'cmc',
    "idioma\ cois"                               => 'khi',
    "idioma\ cordofanonigeriano"                 => 'nic',
    "idioma\ cuchtico"                           => 'cus',
    "idioma\ dravidiano"                         => 'dra',
    "idioma\ eslavo"                             => 'sla',
    "idioma\ filipino"                           => 'phi',
    "idioma\ finogrico"                          => 'fiu',
    "idioma\ germnico"                           => 'gem',
    "idioma\ indgena\ centroamericano"           => 'cai',
    "idioma\ indgena\ norteamericano"            => 'nai',
    "idioma\ indgena\ sulamericano"              => 'sai',
    "idioma\ indoeuropeu"                        => 'ine',
    "idioma\ invlido\ ou\ desconhecido"          => 'und',
    "idioma\ ipique"                             => 'ypk',
    "idioma\ iroqus"                             => 'iro',
    "idioma\ manobo"                             => 'mno',
    "idioma\ monkhmer"                           => 'mkh',
    "idioma\ nbio"                               => 'nub',
    "idioma\ ndico"                              => 'inc',
    "idioma\ nilosaariano"                       => 'ssa',
    "idioma\ otomano"                            => 'oto',
    "idioma\ papuano"                            => 'paa',
    "idioma\ prcrito"                            => 'pra',
    "idioma\ romnico"                            => 'roa',
    "idioma\ salisano"                           => 'sal',
    "idioma\ sami"                               => 'smi',
    "idioma\ semtico"                            => 'sem',
    "idioma\ sinotibetano"                       => 'sit',
    "idioma\ sioux"                              => 'sio',
    "idioma\ sorbio"                             => 'wen',
    "idioma\ surinams"                           => 'srn',
    "idioma\ tailands"                           => 'tai',
    "idioma\ tupi"                               => 'tup',
    "idioma\ wakashan"                           => 'wak',
    "idiomas\ diversos"                          => 'mis',
    "idiomas\ mltiplos"                          => 'mul',
    "idiomas\ munda"                             => 'mun',
    'ido'                                        => 'io',
    'ijo'                                        => 'ijo',
    'ilocano'                                    => 'ilo',
    "inari\ sami"                                => 'smn',
    'indonsio'                                   => 'id',
    'ingls'                                      => 'en',
    "ingls\ americano"                           => 'en_us',
    "ingls\ arcaico"                             => 'ang',
    "ingls\ australiano"                         => 'en_au',
    "ingls\ britnico"                            => 'en_gb',
    "ingls\ canadense"                           => 'en_ca',
    "ingls\ mdio"                                => 'enm',
    'inguche'                                    => 'inh',
    'interlingue'                                => 'ie',
    'interlngua'                                 => 'ia',
    'inuktitut'                                  => 'iu',
    'inupiaque'                                  => 'ik',
    'ioruba'                                     => 'yo',
    'iraniano'                                   => 'ira',
    'irlands'                                    => 'ga',
    "irlands\ arcaico"                           => 'sga',
    "irlands\ mdio"                              => 'mga',
    'islands'                                    => 'is',
    'italiano'                                   => 'it',
    'japons'                                     => 'ja',
    'javans'                                     => 'jv',
    'jju'                                        => 'kaj',
    'judaicoarbico'                              => 'jrb',
    'judaicopersa'                               => 'jpr',
    'kabardiano'                                 => 'kbd',
    'kabyle'                                     => 'kab',
    'kachin'                                     => 'kac',
    'kalmyk'                                     => 'xal',
    'kamba'                                      => 'kam',
    'karachaybalkar'                             => 'krc',
    'karakalpak'                                 => 'kaa',
    'karen'                                      => 'kar',
    'kashubian'                                  => 'csb',
    'kawi'                                       => 'kaw',
    'khasi'                                      => 'kha',
    'khotans'                                    => 'kho',
    'kinyarwanda'                                => 'rw',
    'klingon'                                    => 'tlh',
    'komi'                                       => 'kv',
    'koro'                                       => 'kfo',
    'kosraean'                                   => 'kos',
    'kpelle'                                     => 'kpe',
    'kru'                                        => 'kro',
    'kuanyama'                                   => 'kj',
    'kumyk'                                      => 'kum',
    'kurukh'                                     => 'kru',
    'kutenai'                                    => 'kut',
    'ladino'                                     => 'lad',
    'lahnda'                                     => 'lah',
    'lamba'                                      => 'lam',
    'laosiano'                                   => 'lo',
    'latim'                                      => 'la',
    'leto'                                       => 'lv',
    'lezghian'                                   => 'lez',
    'limburgus'                                  => 'li',
    'lingala'                                    => 'ln',
    "linguagem\ de\ sinais"                      => 'sgn',
    'lituano'                                    => 'lt',
    'lojban'                                     => 'jbo',
    'lozi'                                       => 'loz',
    'lubacatanga'                                => 'lu',
    'lubalulua'                                  => 'lua',
    'luganda'                                    => 'lg',
    'luiseno'                                    => 'lui',
    "lule\ sami"                                 => 'smj',
    'lunda'                                      => 'lun',
    'luo'                                        => 'luo',
    'lushai'                                     => 'lus',
    'luxemburgus'                                => 'lb',
    'macednio'                                   => 'mk',
    'madurs'                                     => 'mad',
    'magahi'                                     => 'mag',
    'maia'                                       => 'myn',
    'maithili'                                   => 'mai',
    'makasar'                                    => 'mak',
    'malaiala'                                   => 'ml',
    'malaio'                                     => 'ms',
    'malgaxe'                                    => 'mg',
    'malts'                                      => 'mt',
    'manchu'                                     => 'mnc',
    'mandar'                                     => 'mdr',
    'mandinga'                                   => 'man',
    'manipuri'                                   => 'mni',
    'manx'                                       => 'gv',
    'maori'                                      => 'mi',
    'marata'                                     => 'mr',
    'mari'                                       => 'chm',
    'marshals'                                   => 'mh',
    'marwari'                                    => 'mwr',
    'massai'                                     => 'mas',
    'mende'                                      => 'men',
    'minangkabau'                                => 'min',
    'miquemaque'                                 => 'mic',
    'mirands'                                    => 'mwl',
    'mocsa'                                      => 'mdf',
    'mohawk'                                     => 'moh',
    'moldvio'                                    => 'mo',
    'mongo'                                      => 'lol',
    'mongol'                                     => 'mn',
    'morisyen'                                   => 'mfe',
    'mossi'                                      => 'mos',
    'napolitano'                                 => 'nap',
    'nauruano'                                   => 'na',
    'navajo'                                     => 'nv',
    "ndebele\ do\ norte"                         => 'nd',
    "ndebele\ do\ sul"                           => 'nr',
    'nepali'                                     => 'ne',
    'newari'                                     => 'new',
    "newari\ clssico"                            => 'nwc',
    'nianja'                                     => 'ny',
    'nias'                                       => 'nia',
    'niueano'                                    => 'niu',
    'nko'                                        => 'nqo',
    'nogai'                                      => 'nog',
    'noruegus'                                   => 'no',
    "nrdico\ arcaico"                            => 'non',
    'nuatle'                                     => 'nah',
    'nyamwezi'                                   => 'nym',
    'nyankole'                                   => 'nyn',
    "nynorsk\ noruegus"                          => 'nn',
    'nyoro'                                      => 'nyo',
    'nzima'                                      => 'nzi',
    'occitnico'                                  => 'oc',
    'ojibwa'                                     => 'oj',
    'oriya'                                      => 'or',
    'oromo'                                      => 'om',
    'osage'                                      => 'osa',
    'ossetic'                                    => 'os',
    'palauano'                                   => 'pau',
    'pampanga'                                   => 'pam',
    'pangasin'                                   => 'pag',
    'panjabi'                                    => 'pa',
    'papiamento'                                 => 'pap',
    'pashto'                                     => 'ps',
    'persa'                                      => 'fa',
    "persa\ arcaico"                             => 'peo',
    'plavi'                                      => 'pal',
    'pli'                                        => 'pi',
    'pohnpeian'                                  => 'pon',
    'polons'                                     => 'pl',
    'portugus'                                   => 'pt',
    "portugus\ do\ brasil"                       => 'pt_br',
    "portugus\ ibrico"                           => 'pt_pt',
    "provenal\ arcaico"                          => 'pro',
    'quchua'                                     => 'qu',
    'quicuio'                                    => 'ki',
    'quimbundo'                                  => 'kmb',
    'quirguiz'                                   => 'ky',
    'rabe'                                       => 'ar',
    'rajastani'                                  => 'raj',
    'rapanui'                                    => 'rap',
    'rarotongano'                                => 'rar',
    'retoromano'                                 => 'rm',
    'romani'                                     => 'rom',
    'romeno'                                     => 'ro',
    'rundi'                                      => 'rn',
    'russo'                                      => 'ru',
    "sami\ do\ norte"                            => 'se',
    "sami\ do\ sul"                              => 'sma',
    'samoano'                                    => 'sm',
    'sandawe'                                    => 'sad',
    'sango'                                      => 'sg',
    'santali'                                    => 'sat',
    'sardo'                                      => 'sc',
    'sasak'                                      => 'sas',
    'selkup'                                     => 'sel',
    "sem\ contedo\ lingustico"                   => 'zxx',
    'serere'                                     => 'srr',
    'servocroata'                                => 'sh',
    'shan'                                       => 'shn',
    'shona'                                      => 'sn',
    "sichuan\ yi"                                => 'ii',
    'siciliano'                                  => 'scn',
    'sidamo'                                     => 'sid',
    'siksika'                                    => 'bla',
    'sindi'                                      => 'sd',
    'siraco'                                     => 'syr',
    "siraco\ clssico"                            => 'syc',
    "skolt\ sami"                                => 'sms',
    'slave'                                      => 'den',
    "smbolos\ blis"                              => 'zbl',
    'snscrito'                                   => 'sa',
    'sogdiano'                                   => 'sog',
    'somali'                                     => 'so',
    'songai'                                     => 'son',
    'soninqu'                                    => 'snk',
    "sorbio\ superior"                           => 'hsb',
    'sosso'                                      => 'sus',
    "soto\ do\ sul"                              => 'st',
    "soto\ setentrional"                         => 'nso',
    'srvio'                                      => 'sr',
    "srvio\ baixo"                               => 'dsb',
    'suaili'                                     => 'sw',
    'sueco'                                      => 'sv',
    'sukuma'                                     => 'suk',
    'sumrio'                                     => 'sux',
    'sundans'                                    => 'su',
    'swati'                                      => 'ss',
    'tadjique'                                   => 'tg',
    'tagalo'                                     => 'tl',
    'tailands'                                   => 'th',
    'taitiano'                                   => 'ty',
    'tamaxeque'                                  => 'tmh',
    'taroko'                                     => 'trv',
    'tatar'                                      => 'tt',
    'tcheco'                                     => 'cs',
    'telugu'                                     => 'te',
    'tereno'                                     => 'ter',
    'tibetano'                                   => 'bo',
    'tigr'                                       => 'tig',
    'tigrnia'                                    => 'ti',
    'timne'                                      => 'tem',
    'tiv'                                        => 'tiv',
    'tlinguite'                                  => 'tli',
    'tmil'                                       => 'ta',
    "tok\ pisin"                                 => 'tpi',
    'tongans'                                    => 'to',
    "tongans\ de\ nyasa"                         => 'tog',
    'toquelauano'                                => 'tkl',
    'tsimshian'                                  => 'tsi',
    'tsonga'                                     => 'ts',
    'tswana'                                     => 'tn',
    'ttum'                                       => 'tet',
    'tumbuka'                                    => 'tum',
    'turco'                                      => 'tr',
    "turco\ da\ crimeia"                         => 'crh',
    "turco\ otomano"                             => 'ota',
    'turcomano'                                  => 'tk',
    'tuvaluano'                                  => 'tvl',
    'tuvinian'                                   => 'tyv',
    'twi'                                        => 'tw',
    'tyap'                                       => 'kcg',
    'ucraniano'                                  => 'uk',
    'udmurt'                                     => 'udm',
    'ugartico'                                   => 'uga',
    'uighur'                                     => 'ug',
    'ulofe'                                      => 'wo',
    'umbundu'                                    => 'umb',
    'urdu'                                       => 'ur',
    'usbeque'                                    => 'uz',
    'vai'                                        => 'vai',
    'valo'                                       => 'wa',
    'venda'                                      => 've',
    'vietnamita'                                 => 'vi',
    'volapuque'                                  => 'vo',
    'votic'                                      => 'vot',
    'walamo'                                     => 'wal',
    'waray'                                      => 'war',
    'washo'                                      => 'was',
    'xosa'                                       => 'xh',
    'yao'                                        => 'yao',
    'yapese'                                     => 'yap',
    'zande'                                      => 'znd',
    'zapoteca'                                   => 'zap',
    'zaza'                                       => 'zza',
    'zenaga'                                     => 'zen',
    'zhuang'                                     => 'za',
    'zulu'                                       => 'zu',
    'zunhi'                                      => 'zun',
);

1;
