package Locales::DB::Language::ms;

# Auto generated from CLDR

$Locales::DB::Language::ms::VERSION = '0.01';

$Locales::DB::Language::ms::cldr_version = '1.7.1';

%Locales::DB::Language::ms::misc_info = (
    'cldr_formats' => {
        'decimal'   => "\#\,\#\#0\.\#\#\#",
        'language'  => "Language\:\ \{0\}",
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0\%",
        'territory' => "Region\:\ \{0\}"
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'posix' => {
        'nostr' => {
            'content' => "tidak\:t",
            'draft'   => 'unconfirmed'
        },
        'yesstr' => {
            'content' => "ya\:y",
            'draft'   => 'unconfirmed'
        }
    },
);

%Locales::DB::Language::ms::code_to_name = (
    'aa'    => 'Afar',
    'ab'    => 'Abkhazian',
    'ace'   => 'Achinese',
    'ach'   => 'Acoli',
    'ada'   => 'Adangme',
    'ady'   => 'Adyghe',
    'ae'    => 'Avestan',
    'af'    => 'Afrikaans',
    'afa'   => "Afro\-Asiatic\ Language",
    'afh'   => 'Afrihili',
    'ain'   => 'Ainu',
    'ak'    => 'Akan',
    'akk'   => 'Akkadian',
    'ale'   => 'Aleut',
    'alg'   => "Algonquian\ Language",
    'alt'   => "Southern\ Altai",
    'am'    => 'Amharic',
    'an'    => 'Aragonese',
    'ang'   => "Old\ English",
    'anp'   => 'Angika',
    'apa'   => "Apache\ Language",
    'ar'    => 'Arab',
    'arc'   => 'Aramaic',
    'arn'   => 'Araucanian',
    'arp'   => 'Arapaho',
    'art'   => "Artificial\ Language",
    'arw'   => 'Arawak',
    'as'    => 'Assam',
    'ast'   => 'Asturian',
    'ath'   => "Athapascan\ Language",
    'aus'   => "Australian\ Language",
    'av'    => 'Avaric',
    'awa'   => 'Awadhi',
    'ay'    => 'Aymara',
    'az'    => 'Azerbaijan',
    'ba'    => 'Bashkir',
    'bad'   => 'Banda',
    'bai'   => "Bamileke\ Language",
    'bal'   => 'Baluchi',
    'ban'   => 'Balinese',
    'bas'   => 'Basa',
    'bat'   => "Baltic\ Language",
    'be'    => 'Belarus',
    'bej'   => 'Beja',
    'bem'   => 'Bemba',
    'ber'   => 'Berber',
    'bg'    => 'Bulgaria',
    'bh'    => 'Bihari',
    'bho'   => 'Bhojpuri',
    'bi'    => 'Bislama',
    'bik'   => 'Bikol',
    'bin'   => 'Bini',
    'bla'   => 'Siksika',
    'bm'    => 'Bambara',
    'bn'    => 'Benggala',
    'bnt'   => 'Bantu',
    'bo'    => 'Tibetan',
    'br'    => 'Brittany',
    'bra'   => 'Braj',
    'bs'    => 'Bosnia',
    'btk'   => 'Batak',
    'bua'   => 'Buriat',
    'bug'   => 'Buginese',
    'byn'   => 'Blin',
    'ca'    => 'Catalonia',
    'cad'   => 'Caddo',
    'cai'   => "Central\ American\ Indian\ Language",
    'car'   => 'Carib',
    'cau'   => "Caucasian\ Language",
    'cch'   => 'Atsam',
    'ce'    => 'Chechen',
    'ceb'   => 'Cebuano',
    'cel'   => "Celtic\ Language",
    'ch'    => 'Chamorro',
    'chb'   => 'Chibcha',
    'chg'   => 'Chagatai',
    'chk'   => 'Chuukese',
    'chm'   => 'Mari',
    'chn'   => "Chinook\ Jargon",
    'cho'   => 'Choctaw',
    'chp'   => 'Chipewyan',
    'chr'   => 'Cherokee',
    'chy'   => 'Cheyenne',
    'cmc'   => "Chamic\ Language",
    'co'    => 'Corsican',
    'cop'   => 'Coptic',
    'cpe'   => "English\-based\ Creole\ or\ Pidgin",
    'cpf'   => "French\-based\ Creole\ or\ Pidgin",
    'cpp'   => "Portuguese\-based\ Creole\ or\ Pidgin",
    'cr'    => 'Cree',
    'crh'   => "Crimean\ Turkish",
    'crp'   => "Creole\ or\ Pidgin",
    'cs'    => 'Czech',
    'csb'   => 'Kashubian',
    'cu'    => "Church\ Slavic",
    'cus'   => "Cushitic\ Language",
    'cv'    => 'Chuvash',
    'cy'    => 'Wales',
    'da'    => 'Denmark',
    'dak'   => 'Dakota',
    'dar'   => 'Dargwa',
    'day'   => 'Dayak',
    'de'    => 'Jerman',
    'de_at' => "Austrian\ German",
    'de_ch' => "Swiss\ High\ German",
    'del'   => 'Delaware',
    'den'   => 'Slave',
    'dgr'   => 'Dogrib',
    'din'   => 'Dinka',
    'doi'   => 'Dogri',
    'dra'   => "Dravidian\ Language",
    'dsb'   => "Lower\ Sorbian",
    'dua'   => 'Duala',
    'dum'   => "Middle\ Dutch",
    'dv'    => 'Divehi',
    'dyu'   => 'Dyula',
    'dz'    => 'Dzongkha',
    'ee'    => 'Ewe',
    'efi'   => 'Efik',
    'egy'   => "Ancient\ Egyptian",
    'eka'   => 'Ekajuk',
    'el'    => 'Greek',
    'elx'   => 'Elamite',
    'en'    => 'Inggeris',
    'en_au' => "Australian\ English",
    'en_ca' => "Canadian\ English",
    'en_gb' => "British\ English",
    'en_us' => "U\.S\.\ English",
    'enm'   => "Middle\ English",
    'eo'    => 'Esperanto',
    'es'    => 'Sepanyol',
    'es_es' => "Iberian\ Spanish",
    'et'    => 'Estonia',
    'eu'    => 'Basque',
    'ewo'   => 'Ewondo',
    'fa'    => 'Parsi',
    'fan'   => 'Fang',
    'fat'   => 'Fanti',
    'ff'    => 'Fulah',
    'fi'    => 'Finland',
    'fil'   => 'Tagalog',
    'fiu'   => "Finno\-Ugrian\ Language",
    'fj'    => 'Fijian',
    'fo'    => 'Faroese',
    'fon'   => 'Fon',
    'fr'    => 'Perancis',
    'fr_ca' => "Canadian\ French",
    'fr_ch' => "Swiss\ French",
    'frm'   => "Middle\ French",
    'fro'   => "Old\ French",
    'frr'   => "Northern\ Frisian",
    'frs'   => "Eastern\ Frisian",
    'fur'   => 'Friulian',
    'fy'    => 'Frisian',
    'ga'    => 'Ireland',
    'gaa'   => 'Ga',
    'gay'   => 'Gayo',
    'gba'   => 'Gbaya',
    'gd'    => "Scots\ Gaelic",
    'gem'   => "Germanic\ Language",
    'gez'   => 'Geez',
    'gil'   => 'Gilbertese',
    'gl'    => 'Galicia',
    'gmh'   => "Middle\ High\ German",
    'gn'    => 'Guarani',
    'goh'   => "Old\ High\ German",
    'gon'   => 'Gondi',
    'gor'   => 'Gorontalo',
    'got'   => 'Gothic',
    'grb'   => 'Grebo',
    'grc'   => "Ancient\ Greek",
    'gsw'   => "Swiss\ German",
    'gu'    => 'Gujerat',
    'gv'    => 'Manx',
    'gwi'   => "Gwich\Ê\¼in",
    'ha'    => 'Hausa',
    'hai'   => 'Haida',
    'haw'   => 'Hawaiian',
    'he'    => 'Ibrani',
    'hi'    => 'Hindi',
    'hil'   => 'Hiligaynon',
    'him'   => 'Himachali',
    'hit'   => 'Hittite',
    'hmn'   => 'Hmong',
    'ho'    => "Hiri\ Motu",
    'hr'    => 'Croat',
    'hsb'   => "Upper\ Sorbian",
    'ht'    => 'Haitian',
    'hu'    => 'Hungary',
    'hup'   => 'Hupa',
    'hy'    => 'Armenia',
    'hz'    => 'Herero',
    'ia'    => 'Interlingua',
    'iba'   => 'Iban',
    'id'    => 'Indonesia',
    'ie'    => 'Interlingue',
    'ig'    => 'Igbo',
    'ii'    => "Sichuan\ Yi",
    'ijo'   => 'Ijo',
    'ik'    => 'Inupiaq',
    'ilo'   => 'Iloko',
    'inc'   => "Indic\ Language",
    'ine'   => "Indo\-European\ Language",
    'inh'   => 'Ingush',
    'io'    => 'Ido',
    'ira'   => "Iranian\ Language",
    'iro'   => "Iroquoian\ Language",
    'is'    => 'Iceland',
    'it'    => 'Itali',
    'iu'    => 'Inuktitut',
    'ja'    => 'Jepun',
    'jbo'   => 'Lojban',
    'jpr'   => "Judeo\-Persian",
    'jrb'   => "Judeo\-Arabic",
    'jv'    => 'Jawa',
    'ka'    => 'Georgia',
    'kaa'   => "Kara\-Kalpak",
    'kab'   => 'Kabyle',
    'kac'   => 'Kachin',
    'kaj'   => 'Jju',
    'kam'   => 'Kamba',
    'kar'   => 'Karen',
    'kaw'   => 'Kawi',
    'kbd'   => 'Kabardian',
    'kcg'   => 'Tyap',
    'kfo'   => 'Koro',
    'kg'    => 'Kongo',
    'kha'   => 'Khasi',
    'khi'   => "Khoisan\ Language",
    'kho'   => 'Khotanese',
    'ki'    => 'Kikuyu',
    'kj'    => 'Kuanyama',
    'kk'    => 'Kazakh',
    'kl'    => 'Kalaallisut',
    'km'    => 'Khmer',
    'kmb'   => 'Kimbundu',
    'kn'    => 'Kannada',
    'ko'    => 'Korea',
    'kok'   => 'Konkani',
    'kos'   => 'Kosraean',
    'kpe'   => 'Kpelle',
    'kr'    => 'Kanuri',
    'krc'   => "Karachay\-Balkar",
    'krl'   => 'Karelian',
    'kro'   => 'Kru',
    'kru'   => 'Kurukh',
    'ks'    => 'Kashmiri',
    'ku'    => 'Kurdish',
    'kum'   => 'Kumyk',
    'kut'   => 'Kutenai',
    'kv'    => 'Komi',
    'kw'    => 'Cornish',
    'ky'    => 'Kyrgyz',
    'la'    => 'Latin',
    'lad'   => 'Ladino',
    'lah'   => 'Lahnda',
    'lam'   => 'Lamba',
    'lb'    => 'Luxembourgish',
    'lez'   => 'Lezghian',
    'lg'    => 'Ganda',
    'li'    => 'Limburgish',
    'ln'    => 'Lingala',
    'lo'    => 'Laos',
    'lol'   => 'Mongo',
    'loz'   => 'Lozi',
    'lt'    => 'Lithuania',
    'lu'    => "Luba\-Katanga",
    'lua'   => "Luba\-Lulua",
    'lui'   => 'Luiseno',
    'lun'   => 'Lunda',
    'luo'   => 'Luo',
    'lus'   => 'Lushai',
    'lv'    => 'Latvia',
    'mad'   => 'Madurese',
    'mag'   => 'Magahi',
    'mai'   => 'Maithili',
    'mak'   => 'Makasar',
    'man'   => 'Mandingo',
    'map'   => "Austronesian\ Language",
    'mas'   => 'Masai',
    'mdf'   => 'Moksha',
    'mdr'   => 'Mandar',
    'men'   => 'Mende',
    'mfe'   => 'Morisyen',
    'mg'    => 'Malagasy',
    'mga'   => "Middle\ Irish",
    'mh'    => 'Marshallese',
    'mi'    => 'Maori',
    'mic'   => 'Micmac',
    'min'   => 'Minangkabau',
    'mis'   => "Miscellaneous\ Language",
    'mk'    => 'Macedonia',
    'mkh'   => "Mon\-Khmer\ Language",
    'ml'    => 'Malayalam',
    'mn'    => 'Mongolia',
    'mnc'   => 'Manchu',
    'mni'   => 'Manipuri',
    'mno'   => "Manobo\ Language",
    'mo'    => 'Moldavian',
    'moh'   => 'Mohawk',
    'mos'   => 'Mossi',
    'mr'    => 'Marathi',
    'ms'    => "Bahasa\ Melayu",
    'mt'    => 'Malta',
    'mul'   => "Multiple\ Languages",
    'mun'   => "Munda\ Language",
    'mus'   => 'Creek',
    'mwl'   => 'Mirandese',
    'mwr'   => 'Marwari',
    'my'    => 'Burmese',
    'myn'   => "Mayan\ Language",
    'myv'   => 'Erzya',
    'na'    => 'Nauru',
    'nah'   => 'Nahuatl',
    'nai'   => "North\ American\ Indian\ Language",
    'nap'   => 'Neapolitan',
    'nb'    => "Norwegian\ Bokm\Ã\¥l",
    'nd'    => "North\ Ndebele",
    'nds'   => "Low\ German",
    'ne'    => 'Nepal',
    'new'   => 'Newari',
    'ng'    => 'Ndonga',
    'nia'   => 'Nias',
    'nic'   => "Niger\-Kordofanian\ Language",
    'niu'   => 'Niuean',
    'nl'    => 'Belanda',
    'nl_be' => 'Flemish',
    'nn'    => "Nynorsk\ Norway",
    'no'    => 'Norway',
    'nog'   => 'Nogai',
    'non'   => "Old\ Norse",
    'nqo'   => "N\â\\Ko",
    'nr'    => "South\ Ndebele",
    'nso'   => "Northern\ Sotho",
    'nub'   => "Nubian\ Language",
    'nv'    => 'Navajo',
    'nwc'   => "Classical\ Newari",
    'ny'    => 'Nyanja',
    'nym'   => 'Nyamwezi',
    'nyn'   => 'Nyankole',
    'nyo'   => 'Nyoro',
    'nzi'   => 'Nzima',
    'oc'    => 'Occitan',
    'oj'    => 'Ojibwa',
    'om'    => 'Oromo',
    'or'    => 'Oriya',
    'os'    => 'Ossetic',
    'osa'   => 'Osage',
    'ota'   => "Ottoman\ Turkish",
    'oto'   => "Otomian\ Language",
    'pa'    => 'Punjabi',
    'paa'   => "Papuan\ Language",
    'pag'   => 'Pangasinan',
    'pal'   => 'Pahlavi',
    'pam'   => 'Pampanga',
    'pap'   => 'Papiamento',
    'pau'   => 'Palauan',
    'peo'   => "Old\ Persian",
    'phi'   => "Philippine\ Language",
    'phn'   => 'Phoenician',
    'pi'    => 'Pali',
    'pl'    => 'Poland',
    'pon'   => 'Pohnpeian',
    'pra'   => "Prakrit\ Language",
    'pro'   => "Old\ Proven\Ã\§al",
    'ps'    => 'Pashto',
    'pt'    => 'Portugis',
    'pt_br' => "Brazilian\ Portuguese",
    'pt_pt' => "Portugis\ Iberia",
    'qu'    => 'Quechua',
    'raj'   => 'Rajasthani',
    'rap'   => 'Rapanui',
    'rar'   => 'Rarotongan',
    'rm'    => "Rhaeto\-Romance",
    'rn'    => 'Rundi',
    'ro'    => 'Romania',
    'roa'   => "Romance\ Language",
    'rom'   => 'Romany',
    'ru'    => 'Rusia',
    'rup'   => 'Aromanian',
    'rw'    => 'Kinyarwanda',
    'sa'    => 'Sanskrit',
    'sad'   => 'Sandawe',
    'sah'   => 'Yakut',
    'sai'   => "South\ American\ Indian\ Language",
    'sal'   => "Salishan\ Language",
    'sam'   => "Samaritan\ Aramaic",
    'sas'   => 'Sasak',
    'sat'   => 'Santali',
    'sc'    => 'Sardinian',
    'scn'   => 'Sicilian',
    'sco'   => 'Scots',
    'sd'    => 'Sindhi',
    'se'    => "Northern\ Sami",
    'sel'   => 'Selkup',
    'sem'   => "Semitic\ Language",
    'sg'    => 'Sango',
    'sga'   => "Old\ Irish",
    'sgn'   => "Sign\ Language",
    'sh'    => 'SerboCroatia',
    'shn'   => 'Shan',
    'si'    => 'Sinhala',
    'sid'   => 'Sidamo',
    'sio'   => "Siouan\ Language",
    'sit'   => "Sino\-Tibetan\ Language",
    'sk'    => 'Slovak',
    'sl'    => 'Slovenia',
    'sla'   => "Slavic\ Language",
    'sm'    => 'Samoan',
    'sma'   => "Southern\ Sami",
    'smi'   => "Sami\ Language",
    'smj'   => "Lule\ Sami",
    'smn'   => "Inari\ Sami",
    'sms'   => "Skolt\ Sami",
    'sn'    => 'Shona',
    'snk'   => 'Soninke',
    'so'    => 'Somali',
    'sog'   => 'Sogdien',
    'son'   => 'Songhai',
    'sq'    => 'Albania',
    'sr'    => 'Serbia',
    'srn'   => "Sranan\ Tongo",
    'srr'   => 'Serer',
    'ss'    => 'Swati',
    'ssa'   => "Nilo\-Saharan\ Language",
    'st'    => 'Sesoto',
    'su'    => 'Sunda',
    'suk'   => 'Sukuma',
    'sus'   => 'Susu',
    'sux'   => 'Sumerian',
    'sv'    => 'Sweden',
    'sw'    => 'Swahili',
    'syc'   => "Classical\ Syriac",
    'syr'   => 'Syriac',
    'ta'    => 'Tamil',
    'tai'   => "Tai\ Language",
    'te'    => 'Telugu',
    'tem'   => 'Timne',
    'ter'   => 'Tereno',
    'tet'   => 'Tetum',
    'tg'    => 'Tajik',
    'th'    => 'Thai',
    'ti'    => 'Tigrinya',
    'tig'   => 'Tigre',
    'tiv'   => 'Tiv',
    'tk'    => 'Turkmen',
    'tkl'   => 'Tokelau',
    'tl'    => 'Tagalog',
    'tlh'   => 'Klingon',
    'tli'   => 'Tlingit',
    'tmh'   => 'Tamashek',
    'tn'    => 'Tswana',
    'to'    => 'Tonga',
    'tog'   => "Nyasa\ Tonga",
    'tpi'   => "Tok\ Pisin",
    'tr'    => 'Turki',
    'trv'   => 'Taroko',
    'ts'    => 'Tsonga',
    'tsi'   => 'Tsimshian',
    'tt'    => 'Tatar',
    'tum'   => 'Tumbuka',
    'tup'   => "Tupi\ Language",
    'tut'   => "Altaic\ Language",
    'tvl'   => 'Tuvalu',
    'tw'    => 'Twi',
    'ty'    => 'Tahitian',
    'tyv'   => 'Tuvinian',
    'udm'   => 'Udmurt',
    'ug'    => 'Uighur',
    'uga'   => 'Ugaritic',
    'uk'    => 'Ukraine',
    'umb'   => 'Umbundu',
    'und'   => "Unknown\ or\ Invalid\ Language",
    'ur'    => 'Urdu',
    'uz'    => 'Uzbek',
    'vai'   => 'Vai',
    've'    => 'Venda',
    'vi'    => 'Vietnam',
    'vo'    => "Volap\Ã\¼k",
    'vot'   => 'Votic',
    'wa'    => 'Walloon',
    'wak'   => "Wakashan\ Language",
    'wal'   => 'Walamo',
    'war'   => 'Waray',
    'was'   => 'Washo',
    'wen'   => "Sorbian\ Language",
    'wo'    => 'Wolof',
    'xal'   => 'Kalmyk',
    'xh'    => 'Xhosa',
    'yao'   => 'Yao',
    'yap'   => 'Yapese',
    'yi'    => 'Yahudi',
    'yo'    => 'Yoruba',
    'ypk'   => "Yupik\ Language",
    'za'    => 'Zhuang',
    'zap'   => 'Zapotec',
    'zbl'   => 'Blissymbols',
    'zen'   => 'Zenaga',
    'zh'    => 'Chinese',
    'znd'   => 'Zande',
    'zu'    => 'Zulu',
    'zun'   => 'Zuni',
    'zxx'   => "No\ linguistic\ content",
    'zza'   => 'Zaza',
);

%Locales::DB::Language::ms::name_to_code = (
    'abkhazian'                           => 'ab',
    'achinese'                            => 'ace',
    'acoli'                               => 'ach',
    'adangme'                             => 'ada',
    'adyghe'                              => 'ady',
    'afar'                                => 'aa',
    'afrihili'                            => 'afh',
    'afrikaans'                           => 'af',
    "afroasiatic\ language"               => 'afa',
    'ainu'                                => 'ain',
    'akan'                                => 'ak',
    'akkadian'                            => 'akk',
    'albania'                             => 'sq',
    'aleut'                               => 'ale',
    "algonquian\ language"                => 'alg',
    "altaic\ language"                    => 'tut',
    'amharic'                             => 'am',
    "ancient\ egyptian"                   => 'egy',
    "ancient\ greek"                      => 'grc',
    'angika'                              => 'anp',
    "apache\ language"                    => 'apa',
    'arab'                                => 'ar',
    'aragonese'                           => 'an',
    'aramaic'                             => 'arc',
    'arapaho'                             => 'arp',
    'araucanian'                          => 'arn',
    'arawak'                              => 'arw',
    'armenia'                             => 'hy',
    'aromanian'                           => 'rup',
    "artificial\ language"                => 'art',
    'assam'                               => 'as',
    'asturian'                            => 'ast',
    "athapascan\ language"                => 'ath',
    'atsam'                               => 'cch',
    "australian\ english"                 => 'en_au',
    "australian\ language"                => 'aus',
    "austrian\ german"                    => 'de_at',
    "austronesian\ language"              => 'map',
    'avaric'                              => 'av',
    'avestan'                             => 'ae',
    'awadhi'                              => 'awa',
    'aymara'                              => 'ay',
    'azerbaijan'                          => 'az',
    "bahasa\ melayu"                      => 'ms',
    'balinese'                            => 'ban',
    "baltic\ language"                    => 'bat',
    'baluchi'                             => 'bal',
    'bambara'                             => 'bm',
    "bamileke\ language"                  => 'bai',
    'banda'                               => 'bad',
    'bantu'                               => 'bnt',
    'basa'                                => 'bas',
    'bashkir'                             => 'ba',
    'basque'                              => 'eu',
    'batak'                               => 'btk',
    'beja'                                => 'bej',
    'belanda'                             => 'nl',
    'belarus'                             => 'be',
    'bemba'                               => 'bem',
    'benggala'                            => 'bn',
    'berber'                              => 'ber',
    'bhojpuri'                            => 'bho',
    'bihari'                              => 'bh',
    'bikol'                               => 'bik',
    'bini'                                => 'bin',
    'bislama'                             => 'bi',
    'blin'                                => 'byn',
    'blissymbols'                         => 'zbl',
    'bosnia'                              => 'bs',
    'braj'                                => 'bra',
    "brazilian\ portuguese"               => 'pt_br',
    "british\ english"                    => 'en_gb',
    'brittany'                            => 'br',
    'buginese'                            => 'bug',
    'bulgaria'                            => 'bg',
    'buriat'                              => 'bua',
    'burmese'                             => 'my',
    'caddo'                               => 'cad',
    "canadian\ english"                   => 'en_ca',
    "canadian\ french"                    => 'fr_ca',
    'carib'                               => 'car',
    'catalonia'                           => 'ca',
    "caucasian\ language"                 => 'cau',
    'cebuano'                             => 'ceb',
    "celtic\ language"                    => 'cel',
    "central\ american\ indian\ language" => 'cai',
    'chagatai'                            => 'chg',
    "chamic\ language"                    => 'cmc',
    'chamorro'                            => 'ch',
    'chechen'                             => 'ce',
    'cherokee'                            => 'chr',
    'cheyenne'                            => 'chy',
    'chibcha'                             => 'chb',
    'chinese'                             => 'zh',
    "chinook\ jargon"                     => 'chn',
    'chipewyan'                           => 'chp',
    'choctaw'                             => 'cho',
    "church\ slavic"                      => 'cu',
    'chuukese'                            => 'chk',
    'chuvash'                             => 'cv',
    "classical\ newari"                   => 'nwc',
    "classical\ syriac"                   => 'syc',
    'coptic'                              => 'cop',
    'cornish'                             => 'kw',
    'corsican'                            => 'co',
    'cree'                                => 'cr',
    'creek'                               => 'mus',
    "creole\ or\ pidgin"                  => 'crp',
    "crimean\ turkish"                    => 'crh',
    'croat'                               => 'hr',
    "cushitic\ language"                  => 'cus',
    'czech'                               => 'cs',
    'dakota'                              => 'dak',
    'dargwa'                              => 'dar',
    'dayak'                               => 'day',
    'delaware'                            => 'del',
    'denmark'                             => 'da',
    'dinka'                               => 'din',
    'divehi'                              => 'dv',
    'dogri'                               => 'doi',
    'dogrib'                              => 'dgr',
    "dravidian\ language"                 => 'dra',
    'duala'                               => 'dua',
    'dyula'                               => 'dyu',
    'dzongkha'                            => 'dz',
    "eastern\ frisian"                    => 'frs',
    'efik'                                => 'efi',
    'ekajuk'                              => 'eka',
    'elamite'                             => 'elx',
    "englishbased\ creole\ or\ pidgin"    => 'cpe',
    'erzya'                               => 'myv',
    'esperanto'                           => 'eo',
    'estonia'                             => 'et',
    'ewe'                                 => 'ee',
    'ewondo'                              => 'ewo',
    'fang'                                => 'fan',
    'fanti'                               => 'fat',
    'faroese'                             => 'fo',
    'fijian'                              => 'fj',
    'finland'                             => 'fi',
    "finnougrian\ language"               => 'fiu',
    'flemish'                             => 'nl_be',
    'fon'                                 => 'fon',
    "frenchbased\ creole\ or\ pidgin"     => 'cpf',
    'frisian'                             => 'fy',
    'friulian'                            => 'fur',
    'fulah'                               => 'ff',
    'ga'                                  => 'gaa',
    'galicia'                             => 'gl',
    'ganda'                               => 'lg',
    'gayo'                                => 'gay',
    'gbaya'                               => 'gba',
    'geez'                                => 'gez',
    'georgia'                             => 'ka',
    "germanic\ language"                  => 'gem',
    'gilbertese'                          => 'gil',
    'gondi'                               => 'gon',
    'gorontalo'                           => 'gor',
    'gothic'                              => 'got',
    'grebo'                               => 'grb',
    'greek'                               => 'el',
    'guarani'                             => 'gn',
    'gujerat'                             => 'gu',
    'gwichin'                             => 'gwi',
    'haida'                               => 'hai',
    'haitian'                             => 'ht',
    'hausa'                               => 'ha',
    'hawaiian'                            => 'haw',
    'herero'                              => 'hz',
    'hiligaynon'                          => 'hil',
    'himachali'                           => 'him',
    'hindi'                               => 'hi',
    "hiri\ motu"                          => 'ho',
    'hittite'                             => 'hit',
    'hmong'                               => 'hmn',
    'hungary'                             => 'hu',
    'hupa'                                => 'hup',
    'iban'                                => 'iba',
    "iberian\ spanish"                    => 'es_es',
    'ibrani'                              => 'he',
    'iceland'                             => 'is',
    'ido'                                 => 'io',
    'igbo'                                => 'ig',
    'ijo'                                 => 'ijo',
    'iloko'                               => 'ilo',
    "inari\ sami"                         => 'smn',
    "indic\ language"                     => 'inc',
    "indoeuropean\ language"              => 'ine',
    'indonesia'                           => 'id',
    'inggeris'                            => 'en',
    'ingush'                              => 'inh',
    'interlingua'                         => 'ia',
    'interlingue'                         => 'ie',
    'inuktitut'                           => 'iu',
    'inupiaq'                             => 'ik',
    "iranian\ language"                   => 'ira',
    'ireland'                             => 'ga',
    "iroquoian\ language"                 => 'iro',
    'itali'                               => 'it',
    'jawa'                                => 'jv',
    'jepun'                               => 'ja',
    'jerman'                              => 'de',
    'jju'                                 => 'kaj',
    'judeoarabic'                         => 'jrb',
    'judeopersian'                        => 'jpr',
    'kabardian'                           => 'kbd',
    'kabyle'                              => 'kab',
    'kachin'                              => 'kac',
    'kalaallisut'                         => 'kl',
    'kalmyk'                              => 'xal',
    'kamba'                               => 'kam',
    'kannada'                             => 'kn',
    'kanuri'                              => 'kr',
    'karachaybalkar'                      => 'krc',
    'karakalpak'                          => 'kaa',
    'karelian'                            => 'krl',
    'karen'                               => 'kar',
    'kashmiri'                            => 'ks',
    'kashubian'                           => 'csb',
    'kawi'                                => 'kaw',
    'kazakh'                              => 'kk',
    'khasi'                               => 'kha',
    'khmer'                               => 'km',
    "khoisan\ language"                   => 'khi',
    'khotanese'                           => 'kho',
    'kikuyu'                              => 'ki',
    'kimbundu'                            => 'kmb',
    'kinyarwanda'                         => 'rw',
    'klingon'                             => 'tlh',
    'komi'                                => 'kv',
    'kongo'                               => 'kg',
    'konkani'                             => 'kok',
    'korea'                               => 'ko',
    'koro'                                => 'kfo',
    'kosraean'                            => 'kos',
    'kpelle'                              => 'kpe',
    'kru'                                 => 'kro',
    'kuanyama'                            => 'kj',
    'kumyk'                               => 'kum',
    'kurdish'                             => 'ku',
    'kurukh'                              => 'kru',
    'kutenai'                             => 'kut',
    'kyrgyz'                              => 'ky',
    'ladino'                              => 'lad',
    'lahnda'                              => 'lah',
    'lamba'                               => 'lam',
    'laos'                                => 'lo',
    'latin'                               => 'la',
    'latvia'                              => 'lv',
    'lezghian'                            => 'lez',
    'limburgish'                          => 'li',
    'lingala'                             => 'ln',
    'lithuania'                           => 'lt',
    'lojban'                              => 'jbo',
    "low\ german"                         => 'nds',
    "lower\ sorbian"                      => 'dsb',
    'lozi'                                => 'loz',
    'lubakatanga'                         => 'lu',
    'lubalulua'                           => 'lua',
    'luiseno'                             => 'lui',
    "lule\ sami"                          => 'smj',
    'lunda'                               => 'lun',
    'luo'                                 => 'luo',
    'lushai'                              => 'lus',
    'luxembourgish'                       => 'lb',
    'macedonia'                           => 'mk',
    'madurese'                            => 'mad',
    'magahi'                              => 'mag',
    'maithili'                            => 'mai',
    'makasar'                             => 'mak',
    'malagasy'                            => 'mg',
    'malayalam'                           => 'ml',
    'malta'                               => 'mt',
    'manchu'                              => 'mnc',
    'mandar'                              => 'mdr',
    'mandingo'                            => 'man',
    'manipuri'                            => 'mni',
    "manobo\ language"                    => 'mno',
    'manx'                                => 'gv',
    'maori'                               => 'mi',
    'marathi'                             => 'mr',
    'mari'                                => 'chm',
    'marshallese'                         => 'mh',
    'marwari'                             => 'mwr',
    'masai'                               => 'mas',
    "mayan\ language"                     => 'myn',
    'mende'                               => 'men',
    'micmac'                              => 'mic',
    "middle\ dutch"                       => 'dum',
    "middle\ english"                     => 'enm',
    "middle\ french"                      => 'frm',
    "middle\ high\ german"                => 'gmh',
    "middle\ irish"                       => 'mga',
    'minangkabau'                         => 'min',
    'mirandese'                           => 'mwl',
    "miscellaneous\ language"             => 'mis',
    'mohawk'                              => 'moh',
    'moksha'                              => 'mdf',
    'moldavian'                           => 'mo',
    'mongo'                               => 'lol',
    'mongolia'                            => 'mn',
    "monkhmer\ language"                  => 'mkh',
    'morisyen'                            => 'mfe',
    'mossi'                               => 'mos',
    "multiple\ languages"                 => 'mul',
    "munda\ language"                     => 'mun',
    'nahuatl'                             => 'nah',
    'nauru'                               => 'na',
    'navajo'                              => 'nv',
    'ndonga'                              => 'ng',
    'neapolitan'                          => 'nap',
    'nepal'                               => 'ne',
    'newari'                              => 'new',
    'nias'                                => 'nia',
    "nigerkordofanian\ language"          => 'nic',
    "nilosaharan\ language"               => 'ssa',
    'niuean'                              => 'niu',
    'nko'                                 => 'nqo',
    "no\ linguistic\ content"             => 'zxx',
    'nogai'                               => 'nog',
    "north\ american\ indian\ language"   => 'nai',
    "north\ ndebele"                      => 'nd',
    "northern\ frisian"                   => 'frr',
    "northern\ sami"                      => 'se',
    "northern\ sotho"                     => 'nso',
    'norway'                              => 'no',
    "norwegian\ bokml"                    => 'nb',
    "nubian\ language"                    => 'nub',
    'nyamwezi'                            => 'nym',
    'nyanja'                              => 'ny',
    'nyankole'                            => 'nyn',
    "nyasa\ tonga"                        => 'tog',
    "nynorsk\ norway"                     => 'nn',
    'nyoro'                               => 'nyo',
    'nzima'                               => 'nzi',
    'occitan'                             => 'oc',
    'ojibwa'                              => 'oj',
    "old\ english"                        => 'ang',
    "old\ french"                         => 'fro',
    "old\ high\ german"                   => 'goh',
    "old\ irish"                          => 'sga',
    "old\ norse"                          => 'non',
    "old\ persian"                        => 'peo',
    "old\ provenal"                       => 'pro',
    'oriya'                               => 'or',
    'oromo'                               => 'om',
    'osage'                               => 'osa',
    'ossetic'                             => 'os',
    "otomian\ language"                   => 'oto',
    "ottoman\ turkish"                    => 'ota',
    'pahlavi'                             => 'pal',
    'palauan'                             => 'pau',
    'pali'                                => 'pi',
    'pampanga'                            => 'pam',
    'pangasinan'                          => 'pag',
    'papiamento'                          => 'pap',
    "papuan\ language"                    => 'paa',
    'parsi'                               => 'fa',
    'pashto'                              => 'ps',
    'perancis'                            => 'fr',
    "philippine\ language"                => 'phi',
    'phoenician'                          => 'phn',
    'pohnpeian'                           => 'pon',
    'poland'                              => 'pl',
    'portugis'                            => 'pt',
    "portugis\ iberia"                    => 'pt_pt',
    "portuguesebased\ creole\ or\ pidgin" => 'cpp',
    "prakrit\ language"                   => 'pra',
    'punjabi'                             => 'pa',
    'quechua'                             => 'qu',
    'rajasthani'                          => 'raj',
    'rapanui'                             => 'rap',
    'rarotongan'                          => 'rar',
    'rhaetoromance'                       => 'rm',
    "romance\ language"                   => 'roa',
    'romania'                             => 'ro',
    'romany'                              => 'rom',
    'rundi'                               => 'rn',
    'rusia'                               => 'ru',
    "salishan\ language"                  => 'sal',
    "samaritan\ aramaic"                  => 'sam',
    "sami\ language"                      => 'smi',
    'samoan'                              => 'sm',
    'sandawe'                             => 'sad',
    'sango'                               => 'sg',
    'sanskrit'                            => 'sa',
    'santali'                             => 'sat',
    'sardinian'                           => 'sc',
    'sasak'                               => 'sas',
    'scots'                               => 'sco',
    "scots\ gaelic"                       => 'gd',
    'selkup'                              => 'sel',
    "semitic\ language"                   => 'sem',
    'sepanyol'                            => 'es',
    'serbia'                              => 'sr',
    'serbocroatia'                        => 'sh',
    'serer'                               => 'srr',
    'sesoto'                              => 'st',
    'shan'                                => 'shn',
    'shona'                               => 'sn',
    "sichuan\ yi"                         => 'ii',
    'sicilian'                            => 'scn',
    'sidamo'                              => 'sid',
    "sign\ language"                      => 'sgn',
    'siksika'                             => 'bla',
    'sindhi'                              => 'sd',
    'sinhala'                             => 'si',
    "sinotibetan\ language"               => 'sit',
    "siouan\ language"                    => 'sio',
    "skolt\ sami"                         => 'sms',
    'slave'                               => 'den',
    "slavic\ language"                    => 'sla',
    'slovak'                              => 'sk',
    'slovenia'                            => 'sl',
    'sogdien'                             => 'sog',
    'somali'                              => 'so',
    'songhai'                             => 'son',
    'soninke'                             => 'snk',
    "sorbian\ language"                   => 'wen',
    "south\ american\ indian\ language"   => 'sai',
    "south\ ndebele"                      => 'nr',
    "southern\ altai"                     => 'alt',
    "southern\ sami"                      => 'sma',
    "sranan\ tongo"                       => 'srn',
    'sukuma'                              => 'suk',
    'sumerian'                            => 'sux',
    'sunda'                               => 'su',
    'susu'                                => 'sus',
    'swahili'                             => 'sw',
    'swati'                               => 'ss',
    'sweden'                              => 'sv',
    "swiss\ french"                       => 'fr_ch',
    "swiss\ german"                       => 'gsw',
    "swiss\ high\ german"                 => 'de_ch',
    'syriac'                              => 'syr',
    'tagalog'                             => 'tl',
    'tahitian'                            => 'ty',
    "tai\ language"                       => 'tai',
    'tajik'                               => 'tg',
    'tamashek'                            => 'tmh',
    'tamil'                               => 'ta',
    'taroko'                              => 'trv',
    'tatar'                               => 'tt',
    'telugu'                              => 'te',
    'tereno'                              => 'ter',
    'tetum'                               => 'tet',
    'thai'                                => 'th',
    'tibetan'                             => 'bo',
    'tigre'                               => 'tig',
    'tigrinya'                            => 'ti',
    'timne'                               => 'tem',
    'tiv'                                 => 'tiv',
    'tlingit'                             => 'tli',
    "tok\ pisin"                          => 'tpi',
    'tokelau'                             => 'tkl',
    'tonga'                               => 'to',
    'tsimshian'                           => 'tsi',
    'tsonga'                              => 'ts',
    'tswana'                              => 'tn',
    'tumbuka'                             => 'tum',
    "tupi\ language"                      => 'tup',
    'turki'                               => 'tr',
    'turkmen'                             => 'tk',
    'tuvalu'                              => 'tvl',
    'tuvinian'                            => 'tyv',
    'twi'                                 => 'tw',
    'tyap'                                => 'kcg',
    'udmurt'                              => 'udm',
    'ugaritic'                            => 'uga',
    'uighur'                              => 'ug',
    'ukraine'                             => 'uk',
    'umbundu'                             => 'umb',
    "unknown\ or\ invalid\ language"      => 'und',
    "upper\ sorbian"                      => 'hsb',
    'urdu'                                => 'ur',
    "us\ english"                         => 'en_us',
    'uzbek'                               => 'uz',
    'vai'                                 => 'vai',
    'venda'                               => 've',
    'vietnam'                             => 'vi',
    'volapk'                              => 'vo',
    'votic'                               => 'vot',
    "wakashan\ language"                  => 'wak',
    'walamo'                              => 'wal',
    'wales'                               => 'cy',
    'walloon'                             => 'wa',
    'waray'                               => 'war',
    'washo'                               => 'was',
    'wolof'                               => 'wo',
    'xhosa'                               => 'xh',
    'yahudi'                              => 'yi',
    'yakut'                               => 'sah',
    'yao'                                 => 'yao',
    'yapese'                              => 'yap',
    'yoruba'                              => 'yo',
    "yupik\ language"                     => 'ypk',
    'zande'                               => 'znd',
    'zapotec'                             => 'zap',
    'zaza'                                => 'zza',
    'zenaga'                              => 'zen',
    'zhuang'                              => 'za',
    'zulu'                                => 'zu',
    'zuni'                                => 'zun',
);

1;
