# ABSTRACT: An event emitted by a Net::Object::Peer node
package Net::Object::Peer::Event;

use 5.10.0;
use strict;
use warnings;

our $VERSION = '0.01'; # TRIAL

use Types::Standard 'ConsumerOf';
use namespace::clean;

use Moo;
extends 'Beam::Event';

has emitter => (
    is       => 'ro',
    isa      => ConsumerOf ['Net::Object::Peer'],
    required => 1,
);



1;

#
# This file is part of Net-Object-Peer
#
# This software is Copyright (c) 2016 by Smithsonian Astrophysical Observatory.
#
# This is free software, licensed under:
#
#   The GNU General Public License, Version 3, June 2007
#

=pod

=head1 NAME

Net::Object::Peer::Event - An event emitted by a Net::Object::Peer node

=head1 VERSION

version 0.01

=head1 DESCRIPTION

B<Net::Object::Peer::Event> is a sub-class of L<Beam::Event>,
which adds the requirement that the emitter be a consumer of L<Net::Object::Peer>.

Event classes used with L<Net::Object::Peer> must be derived from
this class.

=head1 AUTHOR

Diab Jerius <djerius@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2016 by Smithsonian Astrophysical Observatory.

This is free software, licensed under:

  The GNU General Public License, Version 3, June 2007

=cut

__END__

#pod =head1 DESCRIPTION
#pod
#pod B<Net::Object::Peer::Event> is a sub-class of L<Beam::Event>,
#pod which adds the requirement that the emitter be a consumer of L<Net::Object::Peer>.
#pod
#pod Event classes used with L<Net::Object::Peer> must be derived from
#pod this class.
