#! perl

use Test2::V0;
use Test::Lib;
use My::Test::Utils 'export_from';

package My::Exporter {
    use CXC::Exporter::Util 'install_CONSTANTS', 'install_EXPORTS';
    use Exporter 'import';

    install_CONSTANTS( {
            DETECTORS => [
                ACIS => 'acis',
                HRC  => 'hrc',
                # add a bunch to increase the probability that the
                # enumerating function will return the wrong order
                # if this is treated as a hash
                do {
                    my $detname = "DET000";
                    map { ( ++$detname ) x 2 } 0 .. 10;
                }
            ],
        },
        [
            [ 'Tag', 'EnumFunc' ] => {
                ALL  => 'all',
                NONE => 'none',
                ANY  => 'any',
            },
        ] );

    install_EXPORTS;
}

++$INC{'My/Exporter.pm'};

use constant class => 'My::Exporter';

# DETECTOR must return the detectors in the order specified
is(
    [ export_from( class, 'DETECTORS' )->DETECTORS ],
    array {
        item 'acis';
        item 'hrc';
        do {
            my $detname = "DET000";
            item ++$detname for 0 .. 10;
        }
    } );

is( export_from( class, ':detectors' )->ACIS, 'acis' );
is( export_from( class, ':detectors' )->HRC,  'hrc' );

is(
    [ export_from( class, 'EnumFunc' )->EnumFunc ],
    bag {
        item 'all';
        item 'none';
        item 'any';
        end;
    } );
is( export_from( class, ':Tag' )->ALL,  'all' );
is( export_from( class, ':Tag' )->NONE, 'none' );
is( export_from( class, ':Tag' )->ANY,  'any' );

done_testing;
