/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.19
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */

/***********************************************************************
 * common.swg
 *
 *     This file contains generic SWIG runtime support for pointer
 *     type checking as well as a few commonly used macros to control
 *     external linkage.
 *
 * Author : David Beazley (beazley@cs.uchicago.edu)
 *
 * Copyright (c) 1999-2000, The University of Chicago
 * 
 * This file may be freely redistributed without license or fee provided
 * this copyright message remains intact.
 ************************************************************************/

#include <string.h>

#if defined(_WIN32) || defined(__WIN32__)
#       if defined(_MSC_VER)
#               if defined(STATIC_LINKED)
#                       define SWIGEXPORT(a) a
#                       define SWIGIMPORT(a) extern a
#               else
#                       define SWIGEXPORT(a) __declspec(dllexport) a
#                       define SWIGIMPORT(a) extern a
#               endif
#       else
#               if defined(__BORLANDC__)
#                       define SWIGEXPORT(a) a _export
#                       define SWIGIMPORT(a) a _export
#               else
#                       define SWIGEXPORT(a) a
#                       define SWIGIMPORT(a) a
#               endif
#       endif
#else
#       define SWIGEXPORT(a) a
#       define SWIGIMPORT(a) a
#endif

#ifdef SWIG_GLOBAL
#define SWIGRUNTIME(a) SWIGEXPORT(a)
#else
#define SWIGRUNTIME(a) static a
#endif

#ifdef __cplusplus
extern "C" {
#endif

typedef void *(*swig_converter_func)(void *);
typedef struct swig_type_info *(*swig_dycast_func)(void **);

typedef struct swig_type_info {
  const char             *name;                 
  swig_converter_func     converter;
  const char             *str;
  void                   *clientdata;	
  swig_dycast_func        dcast;
  struct swig_type_info  *next;
  struct swig_type_info  *prev;
} swig_type_info;

#ifdef SWIG_NOINCLUDE

SWIGIMPORT(swig_type_info *) SWIG_TypeRegister(swig_type_info *);
SWIGIMPORT(swig_type_info *) SWIG_TypeCheck(char *c, swig_type_info *);
SWIGIMPORT(void *)           SWIG_TypeCast(swig_type_info *, void *);
SWIGIMPORT(swig_type_info *) SWIG_TypeDynamicCast(swig_type_info *, void **);
SWIGIMPORT(const char *)     SWIG_TypeName(const swig_type_info *);
SWIGIMPORT(swig_type_info *) SWIG_TypeQuery(const char *);
SWIGIMPORT(void)             SWIG_TypeClientData(swig_type_info *, void *);

#else

static swig_type_info *swig_type_list = 0;

/* Register a type mapping with the type-checking */
SWIGRUNTIME(swig_type_info *)
SWIG_TypeRegister(swig_type_info *ti)
{
  swig_type_info *tc, *head, *ret, *next;
  /* Check to see if this type has already been registered */
  tc = swig_type_list;
  while (tc) {
    if (strcmp(tc->name, ti->name) == 0) {
      /* Already exists in the table.  Just add additional types to the list */
      if (tc->clientdata) ti->clientdata = tc->clientdata;	
      head = tc;
      next = tc->next;
      goto l1;
    }
    tc = tc->prev;
  }
  head = ti;
  next = 0;

  /* Place in list */
  ti->prev = swig_type_list;
  swig_type_list = ti;

  /* Build linked lists */
 l1:
  ret = head;
  tc = ti + 1;
  /* Patch up the rest of the links */
  while (tc->name) {
    head->next = tc;
    tc->prev = head;
    head = tc;
    tc++;
  }
  if (next) next->prev = head;  /**/
  head->next = next;
  return ret;
}

/* Check the typename */
SWIGRUNTIME(swig_type_info *) 
SWIG_TypeCheck(char *c, swig_type_info *ty)
{
  swig_type_info *s;
  if (!ty) return 0;        /* Void pointer */
  s = ty->next;             /* First element always just a name */
  do {
    if (strcmp(s->name,c) == 0) {
      if (s == ty->next) return s;
      /* Move s to the top of the linked list */
      s->prev->next = s->next;
      if (s->next) {
	s->next->prev = s->prev;
      }
      /* Insert s as second element in the list */
      s->next = ty->next;
      if (ty->next) ty->next->prev = s;
      ty->next = s;
      s->prev = ty;  /**/
      return s;
    }
    s = s->next;
  } while (s && (s != ty->next));
  return 0;
}

/* Cast a pointer up an inheritance hierarchy */
SWIGRUNTIME(void *) 
SWIG_TypeCast(swig_type_info *ty, void *ptr) 
{
  if ((!ty) || (!ty->converter)) return ptr;
  return (*ty->converter)(ptr);
}

/* Dynamic pointer casting. Down an inheritance hierarchy */
SWIGRUNTIME(swig_type_info *) 
SWIG_TypeDynamicCast(swig_type_info *ty, void **ptr) 
{
  swig_type_info *lastty = ty;
  if (!ty || !ty->dcast) return ty;
  while (ty && (ty->dcast)) {
     ty = (*ty->dcast)(ptr);
     if (ty) lastty = ty;
  }
  return lastty;
}

/* Return the name associated with this type */
SWIGRUNTIME(const char *)
SWIG_TypeName(const swig_type_info *ty) {
  return ty->name;
}

/* Search for a swig_type_info structure */
SWIGRUNTIME(swig_type_info *)
SWIG_TypeQuery(const char *name) {
  swig_type_info *ty = swig_type_list;
  while (ty) {
    if (ty->str && (strcmp(name,ty->str) == 0)) return ty;
    if (ty->name && (strcmp(name,ty->name) == 0)) return ty;
    ty = ty->prev;
  }
  return 0;
}

/* Set the clientdata field for a type */
SWIGRUNTIME(void)
SWIG_TypeClientData(swig_type_info *ti, void *clientdata) {
  swig_type_info *tc, *equiv;
  if (ti->clientdata == clientdata) return;
  ti->clientdata = clientdata;
  equiv = ti->next;
  while (equiv) {
    if (!equiv->converter) {
      tc = swig_type_list;
      while (tc) {
	if ((strcmp(tc->name, equiv->name) == 0))
	  SWIG_TypeClientData(tc,clientdata);
	tc = tc->prev;
      }
    }
    equiv = equiv->next;
  }
}
#endif

#ifdef __cplusplus
}

#endif

/* -----------------------------------------------------------------------------
 * perl5.swg
 *
 * Perl5 runtime library
 * $Header: /cvs/projects/SWIG/Lib/perl5/perlrun.swg,v 1.3 2002/11/30 22:10:08 beazley Exp $
 * ----------------------------------------------------------------------------- */

#define SWIGPERL
#define SWIGPERL5
#ifdef __cplusplus
/* Needed on some windows machines---since MS plays funny
   games with the header files under C++ */
#include <math.h>
#include <stdlib.h>
extern "C" {
#endif
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

/* Get rid of free and malloc defined by perl */
#undef free
#undef malloc

#ifndef pTHX_
#define pTHX_
#endif

#include <string.h>
#ifdef __cplusplus
}
#endif

/* Macro to call an XS function */

#ifdef PERL_OBJECT 
#define SWIG_CALLXS(_name) _name(cv,pPerl) 
#else 
#ifndef MULTIPLICITY 
#define SWIG_CALLXS(_name) _name(cv) 
#else 
#define SWIG_CALLXS(_name) _name(PERL_GET_THX, cv) 
#endif 
#endif 

/* Macros for low-level exception handling */
#define SWIG_fail      goto fail
#define SWIG_croak(x)  { if ((_swigerr = (const char *) x)) goto fail; }
#define SWIG_MAX_ERRMSG 256

/* Note: SwigMagicFuncHack is a typedef used to get the C++
   compiler to just shut up already */

#ifdef PERL_OBJECT
#define MAGIC_PPERL  CPerlObj *pPerl = (CPerlObj *) this;
typedef int (CPerlObj::*SwigMagicFunc)(SV *, MAGIC *);

#ifdef __cplusplus
extern "C" {
#endif
typedef int (CPerlObj::*SwigMagicFuncHack)(SV *, MAGIC *);
#ifdef __cplusplus
}
#endif

#define SWIG_MAGIC(a,b) (SV *a, MAGIC *b)
#define SWIGCLASS_STATIC
#else
#define MAGIC_PPERL
#define SWIGCLASS_STATIC static
#ifndef MULTIPLICITY
#define SWIG_MAGIC(a,b) (SV *a, MAGIC *b)
typedef int (*SwigMagicFunc)(SV *, MAGIC *);

#ifdef __cplusplus
extern "C" {
#endif
typedef int (*SwigMagicFuncHack)(SV *, MAGIC *);
#ifdef __cplusplus
}
#endif


#else
#define SWIG_MAGIC(a,b) (struct interpreter *interp, SV *a, MAGIC *b)
typedef int (*SwigMagicFunc)(struct interpreter *, SV *, MAGIC *);
#ifdef __cplusplus
extern "C" {
#endif
typedef int (*SwigMagicFuncHack)(struct interpreter *, SV *, MAGIC *);
#ifdef __cplusplus
}
#endif

#endif
#endif

#if defined(WIN32) && defined(PERL_OBJECT) && !defined(PerlIO_exportFILE)
#define PerlIO_exportFILE(fh,fl) (FILE*)(fh)
#endif

/* Modifications for newer Perl 5.005 releases */

#if !defined(PERL_REVISION) || ((PERL_REVISION >= 5) && ((PERL_VERSION < 5) || ((PERL_VERSION == 5) && (PERL_SUBVERSION < 50))))
#ifndef PL_sv_yes
#define PL_sv_yes sv_yes
#endif
#ifndef PL_sv_undef
#define PL_sv_undef sv_undef
#endif
#ifndef PL_na
#define PL_na na
#endif
#endif

#include <stdlib.h>

#ifdef __cplusplus
extern "C" {
#endif

#ifdef SWIG_NOINCLUDE

#ifndef PERL_OBJECT
extern int SWIG_ConvertPtr(SV *, void **, swig_type_info *, int flags);
extern void SWIG_MakePtr(SV *, void *, swig_type_info *, int flags);
#else
extern int _SWIG_ConvertPtr(CPerlObj *, SV *, void **, swig_type_info *,int flags);
extern void _SWIG_MakePtr(CPerlObj *, SV *, void *, swig_type_info *, int flags);
#define SWIG_ConvertPtr(a,b,c,d) _SWIG_ConvertPtr(pPerl,a,b,c,d)
#define SWIG_MakePtr(a,b,c,d) _SWIG_MakePtr(pPerl,a,b,c,d)
#endif

#else

/* Function for getting a pointer value */

#ifndef PERL_OBJECT
SWIGRUNTIME(int) 
SWIG_ConvertPtr(SV *sv, void **ptr, swig_type_info *_t, int flags)
#else
#define SWIG_ConvertPtr(a,b,c,d) _SWIG_ConvertPtr(pPerl,a,b,c,d)
SWIGRUNTIME(int)
_SWIG_ConvertPtr(CPerlObj *pPerl, SV *sv, void **ptr, swig_type_info *_t, int flags)
#endif
{
  char *_c;
  swig_type_info *tc;
  IV   tmp;

  /* If magical, apply more magic */
  if (SvGMAGICAL(sv))
    mg_get(sv);

  /* Check to see if this is an object */
  if (sv_isobject(sv)) {
    SV *tsv = (SV*) SvRV(sv);
    if ((SvTYPE(tsv) == SVt_PVHV)) {
      MAGIC *mg;
      if (SvMAGICAL(tsv)) {
	mg = mg_find(tsv,'P');
	if (mg) {
	  SV *rsv = mg->mg_obj;
	  if (sv_isobject(rsv)) {
	    tmp = SvIV((SV*)SvRV(rsv));
	  }
	}
      } else {
	return -1;
      }
    } else {
      tmp = SvIV((SV*)SvRV(sv));
    }
    if (!_t) {
      *(ptr) = (void *) tmp;
      return 0;
    }
  } else if (! SvOK(sv)) {            /* Check for undef */
    *(ptr) = (void *) 0;
    return 0;
  } else if (SvTYPE(sv) == SVt_RV) {  /* Check for NULL pointer */
    *(ptr) = (void *) 0;
    if (!SvROK(sv)) 
      return 0;
    else
      return -1;
  } else {                            /* Don't know what it is */
      *(ptr) = (void *) 0;
      return -1;
  }
  if (_t) {
    /* Now see if the types match */      
    _c = HvNAME(SvSTASH(SvRV(sv)));
    tc = SWIG_TypeCheck(_c,_t);
    if (!tc) {
      *ptr = (void *) tmp;
      return -1;
    }
    *ptr = SWIG_TypeCast(tc,(void *)tmp);
    return 0;
  }
  *ptr = (void *) tmp;
  return 0;
}
#ifndef PERL_OBJECT
SWIGRUNTIME(void) 
SWIG_MakePtr(SV *sv, void *ptr, swig_type_info *t,int flags)
#else
#define SWIG_MakePtr(a,b,c,d) _SWIG_MakePtr(pPerl,a,b,c,d)
SWIGRUNTIME(void)
_SWIG_MakePtr(CPerlObj *pPerl, SV *sv, void *ptr, swig_type_info *t, int flags)
#endif
{
  sv_setref_pv(sv, (char *) t->name, ptr);
}

#endif

typedef XS(SwigPerlWrapper);
typedef SwigPerlWrapper *SwigPerlWrapperPtr;

/* Structure for command table */
typedef struct {
  const char         *name;
  SwigPerlWrapperPtr  wrapper;
} swig_command_info;

/* Information for constant table */

#define SWIG_INT     1
#define SWIG_FLOAT   2
#define SWIG_STRING  3
#define SWIG_POINTER 4
#define SWIG_BINARY  5

/* Constant information structure */
typedef struct swig_constant_info {
    int              type;
    const char      *name;
    long             lvalue;
    double           dvalue;
    void            *pvalue;
    swig_type_info **ptype;
} swig_constant_info;

#ifdef __cplusplus
}
#endif

/* Structure for variable table */
typedef struct {
  const char   *name;
  SwigMagicFunc   set;
  SwigMagicFunc   get;
  swig_type_info  **type;
} swig_variable_info;

/* Magic variable code */
#ifndef PERL_OBJECT
#define swig_create_magic(s,a,b,c) _swig_create_magic(s,a,b,c)
  #ifndef MULTIPLICITY 
       static void _swig_create_magic(SV *sv, char *name, int (*set)(SV *, MAGIC *), int \
(*get)(SV *,MAGIC *)) { 
  #else 
       static void _swig_create_magic(SV *sv, char *name, int (*set)(struct interpreter*,\
 SV *, MAGIC *), int (*get)(struct interpreter*, SV *,MAGIC *)) { 
  #endif 
#else
#define swig_create_magic(s,a,b,c) _swig_create_magic(pPerl,s,a,b,c)
static void _swig_create_magic(CPerlObj *pPerl, SV *sv, const char *name, int (CPerlObj::*set)(SV *, MAGIC *), int (CPerlObj::*get)(SV *, MAGIC *)) {
#endif
  MAGIC *mg;
  sv_magic(sv,sv,'U',(char *) name,strlen(name));
  mg = mg_find(sv,'U');
  mg->mg_virtual = (MGVTBL *) malloc(sizeof(MGVTBL));
  mg->mg_virtual->svt_get = (SwigMagicFuncHack) get;
  mg->mg_virtual->svt_set = (SwigMagicFuncHack) set;
  mg->mg_virtual->svt_len = 0;
  mg->mg_virtual->svt_clear = 0;
  mg->mg_virtual->svt_free = 0;
}






#ifdef do_open
  #undef do_open
#endif
#ifdef do_close
  #undef do_close
#endif
#ifdef scalar
  #undef scalar
#endif
#ifdef list
  #undef list
#endif
#ifdef apply
  #undef apply
#endif
#ifdef convert
  #undef convert
#endif
#ifdef Error
  #undef Error
#endif
#ifdef form
  #undef form
#endif
#ifdef vform
  #undef vform
#endif
#ifdef LABEL
  #undef LABEL
#endif
#ifdef METHOD
  #undef METHOD
#endif
#ifdef Move
  #undef Move
#endif
#ifdef yylex
  #undef yylex
#endif
#ifdef yyparse
  #undef yyparse
#endif
#ifdef yyerror
  #undef yyerror
#endif
#ifdef invert
  #undef invert
#endif
#ifdef ref
  #undef ref
#endif


/* -------- TYPES TABLE (BEGIN) -------- */

#define  SWIGTYPE_p_librdf_node swig_types[0] 
#define  SWIGTYPE_p_librdf_parser swig_types[1] 
#define  SWIGTYPE_p_librdf_world swig_types[2] 
#define  SWIGTYPE_p_librdf_hash swig_types[3] 
#define  SWIGTYPE_p_librdf_statement swig_types[4] 
#define  SWIGTYPE_p_librdf_iterator swig_types[5] 
#define  SWIGTYPE_p_librdf_storage swig_types[6] 
#define  SWIGTYPE_p_librdf_uri swig_types[7] 
#define  SWIGTYPE_p_librdf_model swig_types[8] 
#define  SWIGTYPE_p_librdf_stream swig_types[9] 
#define  SWIGTYPE_p_librdf_serializer swig_types[10] 
static swig_type_info *swig_types[12];

/* -------- TYPES TABLE (END) -------- */

#define SWIG_init    boot_RDF__Redland__CORE

#define SWIG_name   "RDF::Redland::CORE::boot_RDF__Redland__CORE"
#define SWIG_prefix "RDF::Redland::CORE::"

#ifdef __cplusplus
extern "C"
#endif
#ifndef PERL_OBJECT
#ifndef MULTIPLICITY
SWIGEXPORT(void) SWIG_init (CV* cv);
#else
SWIGEXPORT(void) SWIG_init (pTHXo_ CV* cv);
#endif
#else
SWIGEXPORT(void) SWIG_init (CV *cv, CPerlObj *);
#endif



#ifdef SWIGPERL
/* for perl, these are passed in by MakeMaker derived makefile */
#undef PACKAGE
#undef VERSION
#endif

/* SWIG BUG - no SWIGTCL is defined - duh */
#ifdef TCL_MAJOR_VERSION
  /* want symbols starting librdf_ not _librdf_ */
#undef SWIG_prefix
#define SWIG_prefix
#endif

#ifdef SWIGRUBY
/* Ruby pollutes the #define space with these names */
#undef PACKAGE_NAME
#undef PACKAGE_STRING
#undef PACKAGE_TARNAME
#undef PACKAGE_VERSION
#undef PACKAGE_BUGREPORT
#endif

#include <rdf_config.h>
#include <redland.h>

/* Internal prototypes */
/* FOR TESTING ERRORS ONLY - NOT PART OF API */
void librdf_internal_test_error(librdf_world *world);
void librdf_internal_test_warning(librdf_world *world);

#ifdef SWIGPYTHON
void librdf_python_world_init(librdf_world *world);
#endif
#ifdef SWIGPERL
void librdf_perl_world_init(librdf_world *world);
void librdf_perl_world_finish(void);
#endif


/* 
 * Thanks to the patch in this Debian bug for the solution
 * to the crash inside vsnprintf on some architectures.
 *
 * "reuse of args inside the while(1) loop is in violation of the
 * specs and only happens to work by accident on other systems."
 *
 * http://bugs.debian.org/cgi-bin/bugreport.cgi?bug=104325 
 */

#ifndef va_copy
#ifdef __va_copy
#define va_copy(dest,src) __va_copy(dest,src)
#else
#define va_copy(dest,src) (dest) = (src)
#endif
#endif



#ifdef SWIGPYTHON
/* swig doesn't declare all prototypes */
static PyObject *_wrap_redland_copyright_string_get(void);
static PyObject *_wrap_redland_version_string_get(void);

static PyObject *_wrap_redland_version_major_get(void);
static PyObject *_wrap_redland_version_minor_get(void);
static PyObject *_wrap_redland_version_release_get(void);


static PyObject *librdf_python_callback = NULL;

static PyObject * librdf_python_set_callback(PyObject *dummy, PyObject *args);

/*
 * set the Python function object callback
 */
static PyObject *
librdf_python_set_callback(dummy, args)
  PyObject *dummy, *args;
{
  PyObject *result = NULL;
  PyObject *temp;
  
  if (PyArg_ParseTuple(args, "O:set_callback", &temp)) {
    if (!PyCallable_Check(temp)) {
      PyErr_SetString(PyExc_TypeError, "parameter must be callable");
      return NULL;
    }
    Py_XINCREF(temp);         /* Add a reference to new callback */
    Py_XDECREF(librdf_python_callback);  /* Dispose of previous callback */
    librdf_python_callback = temp;       /* Remember new callback */
    /* Boilerplate to return "None" */
    Py_INCREF(Py_None);
    result = Py_None;
  }
  return result;
}


/* Declare a table of methods that python can call */
static PyMethodDef librdf_python_methods [] = {
    {"set_callback",  librdf_python_set_callback, METH_VARARGS,
     "Set python message callback."},
    {NULL, NULL, 0, NULL}        /* Sentinel */
};


/*
 * calls a python function defined as:
 *   RDF.message($$)
 * where first argument is an integer, second is a (scalar) string
 */
static void
librdf_call_python_message(int type, const char *message, va_list arguments)
{
  char empty_buffer[1];
#ifdef PYTHON_EXCEPTIONS_WORKING
  PyObject *arglist;
  PyObject *result;
#endif
  char *buffer;
  int len;
  va_list args_copy;

  if(!librdf_python_callback) {
    fprintf(stderr, "librdf_call_python_message: No message callback registered\n");
    return;
  }

  /* ask vsnprintf size of buffer required */
  va_copy(args_copy, arguments);
  len=vsnprintf(empty_buffer, 1, message, args_copy)+1;
  va_end(args_copy);
  buffer=(char*)malloc(len);
  if(!buffer)
    fprintf(stderr, "librdf_call_python_message: Out of memory\n");
  else {
    va_copy(args_copy, arguments);
    vsnprintf(buffer, len, message, args_copy);
    va_end(args_copy);

    if(type == 0) {
#ifdef PYTHON_EXCEPTIONS_WORKING
      PyObject *error = PyErr_NewException("Redland.error", NULL, NULL);
      /* error */
      PyErr_SetString(error, buffer);
#else
      PyErr_Warn(NULL, buffer);
#endif
    } else {
      /* warning */
       PyErr_Warn(NULL, buffer);
    }

#ifdef PYTHON_EXCEPTIONS_WORKING
    /* call the callback */
    arglist = Py_BuildValue("(is)", type, buffer);
    if(!arglist) {
      fprintf(stderr, "librdf_call_python_message: Out of memory\n");
      free(buffer);
      return;
    }
    result = PyEval_CallObject(librdf_python_callback, arglist);
    Py_DECREF(arglist);
    if (result == NULL) {
      free(buffer);
      return;
    }
    
    /* no result */
    Py_DECREF(result);
#endif
    free(buffer);
  }
}

static void
librdf_python_error_handler(void *user_data, 
                            const char *message, va_list arguments)
{
  librdf_call_python_message(0, message, arguments);
}


static void
librdf_python_warning_handler(void *user_data,
                              const char *message, va_list arguments)
{
  librdf_call_python_message(1, message, arguments);
}

void
librdf_python_world_init(librdf_world *world)
{
  (void) Py_InitModule("Redland_python", librdf_python_methods);
  librdf_world_set_error(world, NULL, librdf_python_error_handler);
  librdf_world_set_warning(world,  NULL, librdf_python_warning_handler);
}
 

#endif

#ifdef SWIGPERL
/*
 * calls a perl subroutine defined as:
 *   RDF::Redland::World::message($$)
 * where first argument is an integer, second is a (scalar) string
 */
static void
librdf_call_perl_message(int type, const char *message, va_list arguments)
{
  char empty_buffer[1];
  dSP;
  char *buffer;
  int len;
  va_list args_copy;
  
  ENTER;
  SAVETMPS;

  /* ask vsnprintf size of buffer required */
  va_copy(args_copy, arguments);
  len=vsnprintf(empty_buffer, 1, message, args_copy)+1;
  va_end(args_copy);
  buffer=(char*)malloc(len);
  if(!buffer)
    fprintf(stderr, "librdf_call_perl_message: Out of memory\n");
  else {
    va_copy(args_copy, arguments);
    vsnprintf(buffer, len, message, args_copy);
    va_end(args_copy);

    PUSHMARK(SP) ;
    XPUSHs(sv_2mortal(newSViv(type)));
    XPUSHs(sv_2mortal(newSVpv(buffer, 0)));
    PUTBACK;
  
    call_pv("RDF::Redland::World::message", G_DISCARD);

    free(buffer);
  }
  
  FREETMPS;
  LEAVE;
}

static void
librdf_perl_error_handler(void *user_data, 
                          const char *message, va_list arguments)
{
  librdf_call_perl_message(0, message, arguments);
}


static void
librdf_perl_warning_handler(void *user_data,
                            const char *message, va_list arguments)
{
  librdf_call_perl_message(1, message, arguments);
}

static librdf_world* librdf_perl_world=NULL;

void
librdf_perl_world_init(librdf_world *world)
{
  librdf_world_set_error(world, NULL, librdf_perl_error_handler);
  librdf_world_set_warning(world,  NULL, librdf_perl_warning_handler);

  librdf_perl_world=world;
}

void
librdf_perl_world_finish(void)
{
  librdf_free_world(librdf_perl_world);
}
#endif


/* FOR TESTING ERRORS ONLY - NOT PART OF API */
void
librdf_internal_test_error(librdf_world *world) 
{
  librdf_error(world, "test error message number %d.", 1);
}

void
librdf_internal_test_warning(librdf_world *world) 
{
  librdf_warning(world, "test warning message number %d.", 2);
}


extern char const *redland_copyright_string;
extern char const *redland_version_string;
extern int redland_version_major;
extern int redland_version_minor;
extern int redland_version_release;
#ifdef PERL_OBJECT
#define MAGIC_CLASS _wrap_RDF::Redland::CORE_var::
class _wrap_RDF::Redland::CORE_var : public CPerlObj {
public:
#else
#define MAGIC_CLASS
#endif
SWIGCLASS_STATIC int swig_magic_readonly(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    sv = sv; mg = mg;
    croak("Value is read-only.");
    return 0;
}
SWIGCLASS_STATIC int _wrap_val_redland_copyright_string(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    if (redland_copyright_string) {
        sv_setpv((SV*)sv, (char *) redland_copyright_string);
    }else {
        sv_setsv((SV*)sv, &PL_sv_undef);
    }
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_redland_version_string(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    if (redland_version_string) {
        sv_setpv((SV*)sv, (char *) redland_version_string);
    }else {
        sv_setsv((SV*)sv, &PL_sv_undef);
    }
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_redland_version_major(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setiv(sv, (IV) redland_version_major);
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_redland_version_minor(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setiv(sv, (IV) redland_version_minor);
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_redland_version_release(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setiv(sv, (IV) redland_version_release);
    return 1;
}




#ifdef PERL_OBJECT
};
#endif

#ifdef __cplusplus
extern "C" {
#endif
XS(_wrap_librdf_new_world) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_world *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 0) || (items > 0)) {
            SWIG_croak("Usage: librdf_new_world();");
        }
        result = (librdf_world *)librdf_new_world();
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_librdf_world,0);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_free_world) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_world *arg1 = (librdf_world *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: librdf_free_world(world);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_world,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_free_world. Expected _p_librdf_world");
            }
        }
        librdf_free_world(arg1);
        
        
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_world_open) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_world *arg1 = (librdf_world *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: librdf_world_open(world);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_world,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_world_open. Expected _p_librdf_world");
            }
        }
        librdf_world_open(arg1);
        
        
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_init_world) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        char *arg1 ;
        librdf_hash *arg2 = (librdf_hash *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: librdf_init_world(digest_factory_name,uris_hash);");
        }
        if (!SvOK((SV*) ST(0))) arg1 = 0;
        else arg1 = (char *) SvPV(ST(0), PL_na);
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_librdf_hash,0) < 0) {
                SWIG_croak("Type error in argument 2 of librdf_init_world. Expected _p_librdf_hash");
            }
        }
        librdf_init_world(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_destroy_world) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        int argvi = 0;
        dXSARGS;
        
        if ((items < 0) || (items > 0)) {
            SWIG_croak("Usage: librdf_destroy_world();");
        }
        librdf_destroy_world();
        
        
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_free_iterator) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_iterator *arg1 = (librdf_iterator *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: librdf_free_iterator(librdf_iterator *);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_iterator,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_free_iterator. Expected _p_librdf_iterator");
            }
        }
        librdf_free_iterator(arg1);
        
        
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_iterator_have_elements) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_iterator *arg1 = (librdf_iterator *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: librdf_iterator_have_elements(iterator);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_iterator,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_iterator_have_elements. Expected _p_librdf_iterator");
            }
        }
        result = (int)librdf_iterator_have_elements(arg1);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_iterator_end) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_iterator *arg1 = (librdf_iterator *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: librdf_iterator_end(iterator);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_iterator,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_iterator_end. Expected _p_librdf_iterator");
            }
        }
        result = (int)librdf_iterator_end(arg1);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_iterator_get_object) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_iterator *arg1 = (librdf_iterator *) 0 ;
        librdf_node *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: librdf_iterator_get_object(iterator);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_iterator,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_iterator_get_object. Expected _p_librdf_iterator");
            }
        }
        result = (librdf_node *)librdf_iterator_get_object(arg1);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_librdf_node,0);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_iterator_get_context) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_iterator *arg1 = (librdf_iterator *) 0 ;
        librdf_node *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: librdf_iterator_get_context(iterator);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_iterator,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_iterator_get_context. Expected _p_librdf_iterator");
            }
        }
        result = (librdf_node *)librdf_iterator_get_context(arg1);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_librdf_node,0);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_iterator_next) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_iterator *arg1 = (librdf_iterator *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: librdf_iterator_next(iterator);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_iterator,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_iterator_next. Expected _p_librdf_iterator");
            }
        }
        result = (int)librdf_iterator_next(arg1);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_new_uri) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_world *arg1 = (librdf_world *) 0 ;
        char *arg2 ;
        librdf_uri *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: librdf_new_uri(world,string);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_world,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_new_uri. Expected _p_librdf_world");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        result = (librdf_uri *)librdf_new_uri(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_librdf_uri,0);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_new_uri_from_uri) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_uri *arg1 = (librdf_uri *) 0 ;
        librdf_uri *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: librdf_new_uri_from_uri(uri);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_uri,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_new_uri_from_uri. Expected _p_librdf_uri");
            }
        }
        result = (librdf_uri *)librdf_new_uri_from_uri(arg1);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_librdf_uri,0);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_new_uri_from_filename) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_world *arg1 = (librdf_world *) 0 ;
        char *arg2 ;
        librdf_uri *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: librdf_new_uri_from_filename(world,filename);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_world,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_new_uri_from_filename. Expected _p_librdf_world");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        result = (librdf_uri *)librdf_new_uri_from_filename(arg1,(char const *)arg2);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_librdf_uri,0);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_free_uri) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_uri *arg1 = (librdf_uri *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: librdf_free_uri(uri);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_uri,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_free_uri. Expected _p_librdf_uri");
            }
        }
        librdf_free_uri(arg1);
        
        
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_uri_to_string) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_uri *arg1 = (librdf_uri *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: librdf_uri_to_string(uri);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_uri,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_uri_to_string. Expected _p_librdf_uri");
            }
        }
        result = (char *)librdf_uri_to_string(arg1);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        }else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        free(result);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_uri_equals) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_uri *arg1 = (librdf_uri *) 0 ;
        librdf_uri *arg2 = (librdf_uri *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: librdf_uri_equals(first_uri,second_uri);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_uri,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_uri_equals. Expected _p_librdf_uri");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_librdf_uri,0) < 0) {
                SWIG_croak("Type error in argument 2 of librdf_uri_equals. Expected _p_librdf_uri");
            }
        }
        result = (int)librdf_uri_equals(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_new_node) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_world *arg1 = (librdf_world *) 0 ;
        librdf_node *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: librdf_new_node(world);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_world,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_new_node. Expected _p_librdf_world");
            }
        }
        result = (librdf_node *)librdf_new_node(arg1);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_librdf_node,0);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_new_node_from_uri_string) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_world *arg1 = (librdf_world *) 0 ;
        char *arg2 ;
        librdf_node *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: librdf_new_node_from_uri_string(world,string);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_world,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_new_node_from_uri_string. Expected _p_librdf_world");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        result = (librdf_node *)librdf_new_node_from_uri_string(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_librdf_node,0);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_new_node_from_uri) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_world *arg1 = (librdf_world *) 0 ;
        librdf_uri *arg2 = (librdf_uri *) 0 ;
        librdf_node *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: librdf_new_node_from_uri(world,uri);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_world,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_new_node_from_uri. Expected _p_librdf_world");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_librdf_uri,0) < 0) {
                SWIG_croak("Type error in argument 2 of librdf_new_node_from_uri. Expected _p_librdf_uri");
            }
        }
        result = (librdf_node *)librdf_new_node_from_uri(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_librdf_node,0);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_new_node_from_literal) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_world *arg1 = (librdf_world *) 0 ;
        char *arg2 ;
        char *arg3 ;
        int arg4 ;
        librdf_node *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 4) || (items > 4)) {
            SWIG_croak("Usage: librdf_new_node_from_literal(world,string,xml_language,is_wf_xml);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_world,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_new_node_from_literal. Expected _p_librdf_world");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        if (!SvOK((SV*) ST(2))) arg3 = 0;
        else arg3 = (char *) SvPV(ST(2), PL_na);
        arg4 = (int) SvIV(ST(3));
        result = (librdf_node *)librdf_new_node_from_literal(arg1,arg2,arg3,arg4);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_librdf_node,0);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_new_node_from_typed_literal) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_world *arg1 = (librdf_world *) 0 ;
        char *arg2 ;
        char *arg3 ;
        librdf_uri *arg4 = (librdf_uri *) 0 ;
        librdf_node *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 4) || (items > 4)) {
            SWIG_croak("Usage: librdf_new_node_from_typed_literal(world,string,xml_language,datatype_uri);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_world,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_new_node_from_typed_literal. Expected _p_librdf_world");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        if (!SvOK((SV*) ST(2))) arg3 = 0;
        else arg3 = (char *) SvPV(ST(2), PL_na);
        {
            if (SWIG_ConvertPtr(ST(3), (void **) &arg4, SWIGTYPE_p_librdf_uri,0) < 0) {
                SWIG_croak("Type error in argument 4 of librdf_new_node_from_typed_literal. Expected _p_librdf_uri");
            }
        }
        result = (librdf_node *)librdf_new_node_from_typed_literal(arg1,(char const *)arg2,(char const *)arg3,arg4);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_librdf_node,0);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_new_node_from_node) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_node *arg1 = (librdf_node *) 0 ;
        librdf_node *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: librdf_new_node_from_node(node);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_node,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_new_node_from_node. Expected _p_librdf_node");
            }
        }
        result = (librdf_node *)librdf_new_node_from_node(arg1);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_librdf_node,0);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_new_node_from_blank_identifier) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_world *arg1 = (librdf_world *) 0 ;
        char *arg2 ;
        librdf_node *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: librdf_new_node_from_blank_identifier(world,identifier);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_world,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_new_node_from_blank_identifier. Expected _p_librdf_world");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        result = (librdf_node *)librdf_new_node_from_blank_identifier(arg1,(char const *)arg2);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_librdf_node,0);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_free_node) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_node *arg1 = (librdf_node *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: librdf_free_node(r);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_node,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_free_node. Expected _p_librdf_node");
            }
        }
        librdf_free_node(arg1);
        
        
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_node_get_uri) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_node *arg1 = (librdf_node *) 0 ;
        librdf_uri *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: librdf_node_get_uri(node);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_node,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_node_get_uri. Expected _p_librdf_node");
            }
        }
        result = (librdf_uri *)librdf_node_get_uri(arg1);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_librdf_uri,0);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_node_get_type) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_node *arg1 = (librdf_node *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: librdf_node_get_type(node);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_node,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_node_get_type. Expected _p_librdf_node");
            }
        }
        result = (int)librdf_node_get_type(arg1);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_node_get_literal_value) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_node *arg1 = (librdf_node *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: librdf_node_get_literal_value(node);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_node,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_node_get_literal_value. Expected _p_librdf_node");
            }
        }
        result = (char *)librdf_node_get_literal_value(arg1);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        }else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_node_get_literal_value_as_latin1) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_node *arg1 = (librdf_node *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: librdf_node_get_literal_value_as_latin1(node);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_node,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_node_get_literal_value_as_latin1. Expected _p_librdf_node");
            }
        }
        result = (char *)librdf_node_get_literal_value_as_latin1(arg1);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        }else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_node_get_literal_value_language) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_node *arg1 = (librdf_node *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: librdf_node_get_literal_value_language(node);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_node,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_node_get_literal_value_language. Expected _p_librdf_node");
            }
        }
        result = (char *)librdf_node_get_literal_value_language(arg1);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        }else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_node_get_literal_value_datatype_uri) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_node *arg1 = (librdf_node *) 0 ;
        librdf_uri *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: librdf_node_get_literal_value_datatype_uri(node);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_node,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_node_get_literal_value_datatype_uri. Expected _p_librdf_node");
            }
        }
        result = (librdf_uri *)librdf_node_get_literal_value_datatype_uri(arg1);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_librdf_uri,0);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_node_get_literal_value_is_wf_xml) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_node *arg1 = (librdf_node *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: librdf_node_get_literal_value_is_wf_xml(node);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_node,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_node_get_literal_value_is_wf_xml. Expected _p_librdf_node");
            }
        }
        result = (int)librdf_node_get_literal_value_is_wf_xml(arg1);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_node_to_string) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_node *arg1 = (librdf_node *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: librdf_node_to_string(node);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_node,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_node_to_string. Expected _p_librdf_node");
            }
        }
        result = (char *)librdf_node_to_string(arg1);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        }else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        free(result);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_node_get_blank_identifier) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_node *arg1 = (librdf_node *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: librdf_node_get_blank_identifier(node);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_node,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_node_get_blank_identifier. Expected _p_librdf_node");
            }
        }
        result = (char *)librdf_node_get_blank_identifier(arg1);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        }else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_node_is_resource) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_node *arg1 = (librdf_node *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: librdf_node_is_resource(node);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_node,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_node_is_resource. Expected _p_librdf_node");
            }
        }
        result = (int)librdf_node_is_resource(arg1);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_node_is_literal) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_node *arg1 = (librdf_node *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: librdf_node_is_literal(node);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_node,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_node_is_literal. Expected _p_librdf_node");
            }
        }
        result = (int)librdf_node_is_literal(arg1);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_node_is_blank) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_node *arg1 = (librdf_node *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: librdf_node_is_blank(node);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_node,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_node_is_blank. Expected _p_librdf_node");
            }
        }
        result = (int)librdf_node_is_blank(arg1);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_node_equals) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_node *arg1 = (librdf_node *) 0 ;
        librdf_node *arg2 = (librdf_node *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: librdf_node_equals(first_node,second_node);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_node,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_node_equals. Expected _p_librdf_node");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_librdf_node,0) < 0) {
                SWIG_croak("Type error in argument 2 of librdf_node_equals. Expected _p_librdf_node");
            }
        }
        result = (int)librdf_node_equals(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_new_statement) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_world *arg1 = (librdf_world *) 0 ;
        librdf_statement *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: librdf_new_statement(world);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_world,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_new_statement. Expected _p_librdf_world");
            }
        }
        result = (librdf_statement *)librdf_new_statement(arg1);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_librdf_statement,0);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_new_statement_from_statement) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_statement *arg1 = (librdf_statement *) 0 ;
        librdf_statement *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: librdf_new_statement_from_statement(statement);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_statement,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_new_statement_from_statement. Expected _p_librdf_statement");
            }
        }
        result = (librdf_statement *)librdf_new_statement_from_statement(arg1);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_librdf_statement,0);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_new_statement_from_nodes) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_world *arg1 = (librdf_world *) 0 ;
        librdf_node *arg2 = (librdf_node *) 0 ;
        librdf_node *arg3 = (librdf_node *) 0 ;
        librdf_node *arg4 = (librdf_node *) 0 ;
        librdf_statement *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 4) || (items > 4)) {
            SWIG_croak("Usage: librdf_new_statement_from_nodes(world,subject,predicate,object);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_world,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_new_statement_from_nodes. Expected _p_librdf_world");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_librdf_node,0) < 0) {
                SWIG_croak("Type error in argument 2 of librdf_new_statement_from_nodes. Expected _p_librdf_node");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(2), (void **) &arg3, SWIGTYPE_p_librdf_node,0) < 0) {
                SWIG_croak("Type error in argument 3 of librdf_new_statement_from_nodes. Expected _p_librdf_node");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(3), (void **) &arg4, SWIGTYPE_p_librdf_node,0) < 0) {
                SWIG_croak("Type error in argument 4 of librdf_new_statement_from_nodes. Expected _p_librdf_node");
            }
        }
        result = (librdf_statement *)librdf_new_statement_from_nodes(arg1,arg2,arg3,arg4);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_librdf_statement,0);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_free_statement) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_statement *arg1 = (librdf_statement *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: librdf_free_statement(statement);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_statement,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_free_statement. Expected _p_librdf_statement");
            }
        }
        librdf_free_statement(arg1);
        
        
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_statement_get_subject) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_statement *arg1 = (librdf_statement *) 0 ;
        librdf_node *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: librdf_statement_get_subject(statement);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_statement,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_statement_get_subject. Expected _p_librdf_statement");
            }
        }
        result = (librdf_node *)librdf_statement_get_subject(arg1);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_librdf_node,0);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_statement_set_subject) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_statement *arg1 = (librdf_statement *) 0 ;
        librdf_node *arg2 = (librdf_node *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: librdf_statement_set_subject(statement,subject);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_statement,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_statement_set_subject. Expected _p_librdf_statement");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_librdf_node,0) < 0) {
                SWIG_croak("Type error in argument 2 of librdf_statement_set_subject. Expected _p_librdf_node");
            }
        }
        librdf_statement_set_subject(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_statement_get_predicate) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_statement *arg1 = (librdf_statement *) 0 ;
        librdf_node *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: librdf_statement_get_predicate(statement);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_statement,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_statement_get_predicate. Expected _p_librdf_statement");
            }
        }
        result = (librdf_node *)librdf_statement_get_predicate(arg1);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_librdf_node,0);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_statement_set_predicate) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_statement *arg1 = (librdf_statement *) 0 ;
        librdf_node *arg2 = (librdf_node *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: librdf_statement_set_predicate(statement,predicate);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_statement,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_statement_set_predicate. Expected _p_librdf_statement");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_librdf_node,0) < 0) {
                SWIG_croak("Type error in argument 2 of librdf_statement_set_predicate. Expected _p_librdf_node");
            }
        }
        librdf_statement_set_predicate(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_statement_get_object) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_statement *arg1 = (librdf_statement *) 0 ;
        librdf_node *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: librdf_statement_get_object(statement);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_statement,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_statement_get_object. Expected _p_librdf_statement");
            }
        }
        result = (librdf_node *)librdf_statement_get_object(arg1);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_librdf_node,0);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_statement_set_object) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_statement *arg1 = (librdf_statement *) 0 ;
        librdf_node *arg2 = (librdf_node *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: librdf_statement_set_object(statement,object);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_statement,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_statement_set_object. Expected _p_librdf_statement");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_librdf_node,0) < 0) {
                SWIG_croak("Type error in argument 2 of librdf_statement_set_object. Expected _p_librdf_node");
            }
        }
        librdf_statement_set_object(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_statement_to_string) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_statement *arg1 = (librdf_statement *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: librdf_statement_to_string(statement);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_statement,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_statement_to_string. Expected _p_librdf_statement");
            }
        }
        result = (char *)librdf_statement_to_string(arg1);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        }else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        free(result);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_new_model) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_world *arg1 = (librdf_world *) 0 ;
        librdf_storage *arg2 = (librdf_storage *) 0 ;
        char *arg3 ;
        librdf_model *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 3) || (items > 3)) {
            SWIG_croak("Usage: librdf_new_model(world,storage,options_string);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_world,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_new_model. Expected _p_librdf_world");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_librdf_storage,0) < 0) {
                SWIG_croak("Type error in argument 2 of librdf_new_model. Expected _p_librdf_storage");
            }
        }
        if (!SvOK((SV*) ST(2))) arg3 = 0;
        else arg3 = (char *) SvPV(ST(2), PL_na);
        result = (librdf_model *)librdf_new_model(arg1,arg2,arg3);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_librdf_model,0);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_new_model_with_options) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_world *arg1 = (librdf_world *) 0 ;
        librdf_storage *arg2 = (librdf_storage *) 0 ;
        librdf_hash *arg3 = (librdf_hash *) 0 ;
        librdf_model *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 3) || (items > 3)) {
            SWIG_croak("Usage: librdf_new_model_with_options(world,storage,options);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_world,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_new_model_with_options. Expected _p_librdf_world");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_librdf_storage,0) < 0) {
                SWIG_croak("Type error in argument 2 of librdf_new_model_with_options. Expected _p_librdf_storage");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(2), (void **) &arg3, SWIGTYPE_p_librdf_hash,0) < 0) {
                SWIG_croak("Type error in argument 3 of librdf_new_model_with_options. Expected _p_librdf_hash");
            }
        }
        result = (librdf_model *)librdf_new_model_with_options(arg1,arg2,arg3);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_librdf_model,0);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_new_model_from_model) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_model *arg1 = (librdf_model *) 0 ;
        librdf_model *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: librdf_new_model_from_model(model);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_model,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_new_model_from_model. Expected _p_librdf_model");
            }
        }
        result = (librdf_model *)librdf_new_model_from_model(arg1);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_librdf_model,0);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_free_model) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_model *arg1 = (librdf_model *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: librdf_free_model(model);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_model,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_free_model. Expected _p_librdf_model");
            }
        }
        librdf_free_model(arg1);
        
        
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_model_size) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_model *arg1 = (librdf_model *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: librdf_model_size(model);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_model,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_model_size. Expected _p_librdf_model");
            }
        }
        result = (int)librdf_model_size(arg1);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_model_add) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_model *arg1 = (librdf_model *) 0 ;
        librdf_node *arg2 = (librdf_node *) 0 ;
        librdf_node *arg3 = (librdf_node *) 0 ;
        librdf_node *arg4 = (librdf_node *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 4) || (items > 4)) {
            SWIG_croak("Usage: librdf_model_add(model,subject,predicate,object);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_model,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_model_add. Expected _p_librdf_model");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_librdf_node,0) < 0) {
                SWIG_croak("Type error in argument 2 of librdf_model_add. Expected _p_librdf_node");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(2), (void **) &arg3, SWIGTYPE_p_librdf_node,0) < 0) {
                SWIG_croak("Type error in argument 3 of librdf_model_add. Expected _p_librdf_node");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(3), (void **) &arg4, SWIGTYPE_p_librdf_node,0) < 0) {
                SWIG_croak("Type error in argument 4 of librdf_model_add. Expected _p_librdf_node");
            }
        }
        result = (int)librdf_model_add(arg1,arg2,arg3,arg4);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_model_add_typed_literal_statement) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_model *arg1 = (librdf_model *) 0 ;
        librdf_node *arg2 = (librdf_node *) 0 ;
        librdf_node *arg3 = (librdf_node *) 0 ;
        char *arg4 ;
        char *arg5 ;
        librdf_uri *arg6 = (librdf_uri *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 6) || (items > 6)) {
            SWIG_croak("Usage: librdf_model_add_typed_literal_statement(model,subject,predicate,string,xml_language,datatype_uri);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_model,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_model_add_typed_literal_statement. Expected _p_librdf_model");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_librdf_node,0) < 0) {
                SWIG_croak("Type error in argument 2 of librdf_model_add_typed_literal_statement. Expected _p_librdf_node");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(2), (void **) &arg3, SWIGTYPE_p_librdf_node,0) < 0) {
                SWIG_croak("Type error in argument 3 of librdf_model_add_typed_literal_statement. Expected _p_librdf_node");
            }
        }
        if (!SvOK((SV*) ST(3))) arg4 = 0;
        else arg4 = (char *) SvPV(ST(3), PL_na);
        if (!SvOK((SV*) ST(4))) arg5 = 0;
        else arg5 = (char *) SvPV(ST(4), PL_na);
        {
            if (SWIG_ConvertPtr(ST(5), (void **) &arg6, SWIGTYPE_p_librdf_uri,0) < 0) {
                SWIG_croak("Type error in argument 6 of librdf_model_add_typed_literal_statement. Expected _p_librdf_uri");
            }
        }
        result = (int)librdf_model_add_typed_literal_statement(arg1,arg2,arg3,arg4,arg5,arg6);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_model_add_statement) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_model *arg1 = (librdf_model *) 0 ;
        librdf_statement *arg2 = (librdf_statement *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: librdf_model_add_statement(model,statement);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_model,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_model_add_statement. Expected _p_librdf_model");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_librdf_statement,0) < 0) {
                SWIG_croak("Type error in argument 2 of librdf_model_add_statement. Expected _p_librdf_statement");
            }
        }
        result = (int)librdf_model_add_statement(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_model_add_statements) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_model *arg1 = (librdf_model *) 0 ;
        librdf_stream *arg2 = (librdf_stream *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: librdf_model_add_statements(model,statement_stream);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_model,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_model_add_statements. Expected _p_librdf_model");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_librdf_stream,0) < 0) {
                SWIG_croak("Type error in argument 2 of librdf_model_add_statements. Expected _p_librdf_stream");
            }
        }
        result = (int)librdf_model_add_statements(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_model_remove_statement) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_model *arg1 = (librdf_model *) 0 ;
        librdf_statement *arg2 = (librdf_statement *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: librdf_model_remove_statement(model,statement);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_model,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_model_remove_statement. Expected _p_librdf_model");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_librdf_statement,0) < 0) {
                SWIG_croak("Type error in argument 2 of librdf_model_remove_statement. Expected _p_librdf_statement");
            }
        }
        result = (int)librdf_model_remove_statement(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_model_contains_statement) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_model *arg1 = (librdf_model *) 0 ;
        librdf_statement *arg2 = (librdf_statement *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: librdf_model_contains_statement(model,statement);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_model,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_model_contains_statement. Expected _p_librdf_model");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_librdf_statement,0) < 0) {
                SWIG_croak("Type error in argument 2 of librdf_model_contains_statement. Expected _p_librdf_statement");
            }
        }
        result = (int)librdf_model_contains_statement(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_model_as_stream) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_model *arg1 = (librdf_model *) 0 ;
        librdf_stream *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: librdf_model_as_stream(model);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_model,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_model_as_stream. Expected _p_librdf_model");
            }
        }
        result = (librdf_stream *)librdf_model_as_stream(arg1);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_librdf_stream,0);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_model_serialise) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_model *arg1 = (librdf_model *) 0 ;
        librdf_stream *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: librdf_model_serialise(model);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_model,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_model_serialise. Expected _p_librdf_model");
            }
        }
        result = (librdf_stream *)librdf_model_serialise(arg1);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_librdf_stream,0);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_model_find_statements) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_model *arg1 = (librdf_model *) 0 ;
        librdf_statement *arg2 = (librdf_statement *) 0 ;
        librdf_stream *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: librdf_model_find_statements(model,statement);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_model,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_model_find_statements. Expected _p_librdf_model");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_librdf_statement,0) < 0) {
                SWIG_croak("Type error in argument 2 of librdf_model_find_statements. Expected _p_librdf_statement");
            }
        }
        result = (librdf_stream *)librdf_model_find_statements(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_librdf_stream,0);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_model_get_sources) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_model *arg1 = (librdf_model *) 0 ;
        librdf_node *arg2 = (librdf_node *) 0 ;
        librdf_node *arg3 = (librdf_node *) 0 ;
        librdf_iterator *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 3) || (items > 3)) {
            SWIG_croak("Usage: librdf_model_get_sources(model,arc,target);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_model,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_model_get_sources. Expected _p_librdf_model");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_librdf_node,0) < 0) {
                SWIG_croak("Type error in argument 2 of librdf_model_get_sources. Expected _p_librdf_node");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(2), (void **) &arg3, SWIGTYPE_p_librdf_node,0) < 0) {
                SWIG_croak("Type error in argument 3 of librdf_model_get_sources. Expected _p_librdf_node");
            }
        }
        result = (librdf_iterator *)librdf_model_get_sources(arg1,arg2,arg3);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_librdf_iterator,0);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_model_get_arcs) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_model *arg1 = (librdf_model *) 0 ;
        librdf_node *arg2 = (librdf_node *) 0 ;
        librdf_node *arg3 = (librdf_node *) 0 ;
        librdf_iterator *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 3) || (items > 3)) {
            SWIG_croak("Usage: librdf_model_get_arcs(model,source,target);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_model,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_model_get_arcs. Expected _p_librdf_model");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_librdf_node,0) < 0) {
                SWIG_croak("Type error in argument 2 of librdf_model_get_arcs. Expected _p_librdf_node");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(2), (void **) &arg3, SWIGTYPE_p_librdf_node,0) < 0) {
                SWIG_croak("Type error in argument 3 of librdf_model_get_arcs. Expected _p_librdf_node");
            }
        }
        result = (librdf_iterator *)librdf_model_get_arcs(arg1,arg2,arg3);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_librdf_iterator,0);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_model_get_targets) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_model *arg1 = (librdf_model *) 0 ;
        librdf_node *arg2 = (librdf_node *) 0 ;
        librdf_node *arg3 = (librdf_node *) 0 ;
        librdf_iterator *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 3) || (items > 3)) {
            SWIG_croak("Usage: librdf_model_get_targets(model,source,arc);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_model,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_model_get_targets. Expected _p_librdf_model");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_librdf_node,0) < 0) {
                SWIG_croak("Type error in argument 2 of librdf_model_get_targets. Expected _p_librdf_node");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(2), (void **) &arg3, SWIGTYPE_p_librdf_node,0) < 0) {
                SWIG_croak("Type error in argument 3 of librdf_model_get_targets. Expected _p_librdf_node");
            }
        }
        result = (librdf_iterator *)librdf_model_get_targets(arg1,arg2,arg3);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_librdf_iterator,0);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_model_get_source) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_model *arg1 = (librdf_model *) 0 ;
        librdf_node *arg2 = (librdf_node *) 0 ;
        librdf_node *arg3 = (librdf_node *) 0 ;
        librdf_node *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 3) || (items > 3)) {
            SWIG_croak("Usage: librdf_model_get_source(model,arc,target);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_model,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_model_get_source. Expected _p_librdf_model");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_librdf_node,0) < 0) {
                SWIG_croak("Type error in argument 2 of librdf_model_get_source. Expected _p_librdf_node");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(2), (void **) &arg3, SWIGTYPE_p_librdf_node,0) < 0) {
                SWIG_croak("Type error in argument 3 of librdf_model_get_source. Expected _p_librdf_node");
            }
        }
        result = (librdf_node *)librdf_model_get_source(arg1,arg2,arg3);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_librdf_node,0);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_model_get_arc) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_model *arg1 = (librdf_model *) 0 ;
        librdf_node *arg2 = (librdf_node *) 0 ;
        librdf_node *arg3 = (librdf_node *) 0 ;
        librdf_node *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 3) || (items > 3)) {
            SWIG_croak("Usage: librdf_model_get_arc(model,source,target);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_model,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_model_get_arc. Expected _p_librdf_model");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_librdf_node,0) < 0) {
                SWIG_croak("Type error in argument 2 of librdf_model_get_arc. Expected _p_librdf_node");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(2), (void **) &arg3, SWIGTYPE_p_librdf_node,0) < 0) {
                SWIG_croak("Type error in argument 3 of librdf_model_get_arc. Expected _p_librdf_node");
            }
        }
        result = (librdf_node *)librdf_model_get_arc(arg1,arg2,arg3);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_librdf_node,0);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_model_get_target) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_model *arg1 = (librdf_model *) 0 ;
        librdf_node *arg2 = (librdf_node *) 0 ;
        librdf_node *arg3 = (librdf_node *) 0 ;
        librdf_node *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 3) || (items > 3)) {
            SWIG_croak("Usage: librdf_model_get_target(model,source,arc);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_model,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_model_get_target. Expected _p_librdf_model");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_librdf_node,0) < 0) {
                SWIG_croak("Type error in argument 2 of librdf_model_get_target. Expected _p_librdf_node");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(2), (void **) &arg3, SWIGTYPE_p_librdf_node,0) < 0) {
                SWIG_croak("Type error in argument 3 of librdf_model_get_target. Expected _p_librdf_node");
            }
        }
        result = (librdf_node *)librdf_model_get_target(arg1,arg2,arg3);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_librdf_node,0);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_model_context_add_statement) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_model *arg1 = (librdf_model *) 0 ;
        librdf_node *arg2 = (librdf_node *) 0 ;
        librdf_statement *arg3 = (librdf_statement *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 3) || (items > 3)) {
            SWIG_croak("Usage: librdf_model_context_add_statement(model,context,statement);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_model,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_model_context_add_statement. Expected _p_librdf_model");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_librdf_node,0) < 0) {
                SWIG_croak("Type error in argument 2 of librdf_model_context_add_statement. Expected _p_librdf_node");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(2), (void **) &arg3, SWIGTYPE_p_librdf_statement,0) < 0) {
                SWIG_croak("Type error in argument 3 of librdf_model_context_add_statement. Expected _p_librdf_statement");
            }
        }
        result = (int)librdf_model_context_add_statement(arg1,arg2,arg3);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_model_context_add_statements) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_model *arg1 = (librdf_model *) 0 ;
        librdf_node *arg2 = (librdf_node *) 0 ;
        librdf_stream *arg3 = (librdf_stream *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 3) || (items > 3)) {
            SWIG_croak("Usage: librdf_model_context_add_statements(model,context,stream);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_model,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_model_context_add_statements. Expected _p_librdf_model");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_librdf_node,0) < 0) {
                SWIG_croak("Type error in argument 2 of librdf_model_context_add_statements. Expected _p_librdf_node");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(2), (void **) &arg3, SWIGTYPE_p_librdf_stream,0) < 0) {
                SWIG_croak("Type error in argument 3 of librdf_model_context_add_statements. Expected _p_librdf_stream");
            }
        }
        result = (int)librdf_model_context_add_statements(arg1,arg2,arg3);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_model_context_remove_statement) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_model *arg1 = (librdf_model *) 0 ;
        librdf_node *arg2 = (librdf_node *) 0 ;
        librdf_statement *arg3 = (librdf_statement *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 3) || (items > 3)) {
            SWIG_croak("Usage: librdf_model_context_remove_statement(model,context,statement);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_model,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_model_context_remove_statement. Expected _p_librdf_model");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_librdf_node,0) < 0) {
                SWIG_croak("Type error in argument 2 of librdf_model_context_remove_statement. Expected _p_librdf_node");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(2), (void **) &arg3, SWIGTYPE_p_librdf_statement,0) < 0) {
                SWIG_croak("Type error in argument 3 of librdf_model_context_remove_statement. Expected _p_librdf_statement");
            }
        }
        result = (int)librdf_model_context_remove_statement(arg1,arg2,arg3);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_model_context_remove_statements) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_model *arg1 = (librdf_model *) 0 ;
        librdf_node *arg2 = (librdf_node *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: librdf_model_context_remove_statements(model,context);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_model,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_model_context_remove_statements. Expected _p_librdf_model");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_librdf_node,0) < 0) {
                SWIG_croak("Type error in argument 2 of librdf_model_context_remove_statements. Expected _p_librdf_node");
            }
        }
        result = (int)librdf_model_context_remove_statements(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_model_context_as_stream) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_model *arg1 = (librdf_model *) 0 ;
        librdf_node *arg2 = (librdf_node *) 0 ;
        librdf_stream *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: librdf_model_context_as_stream(model,context);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_model,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_model_context_as_stream. Expected _p_librdf_model");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_librdf_node,0) < 0) {
                SWIG_croak("Type error in argument 2 of librdf_model_context_as_stream. Expected _p_librdf_node");
            }
        }
        result = (librdf_stream *)librdf_model_context_as_stream(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_librdf_stream,0);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_model_context_serialize) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_model *arg1 = (librdf_model *) 0 ;
        librdf_node *arg2 = (librdf_node *) 0 ;
        librdf_stream *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: librdf_model_context_serialize(model,context);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_model,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_model_context_serialize. Expected _p_librdf_model");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_librdf_node,0) < 0) {
                SWIG_croak("Type error in argument 2 of librdf_model_context_serialize. Expected _p_librdf_node");
            }
        }
        result = (librdf_stream *)librdf_model_context_serialize(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_librdf_stream,0);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_model_sync) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_model *arg1 = (librdf_model *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: librdf_model_sync(model);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_model,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_model_sync. Expected _p_librdf_model");
            }
        }
        librdf_model_sync(arg1);
        
        
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_new_storage) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_world *arg1 = (librdf_world *) 0 ;
        char *arg2 ;
        char *arg3 ;
        char *arg4 ;
        librdf_storage *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 4) || (items > 4)) {
            SWIG_croak("Usage: librdf_new_storage(world,storage_name,name,options_string);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_world,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_new_storage. Expected _p_librdf_world");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        if (!SvOK((SV*) ST(2))) arg3 = 0;
        else arg3 = (char *) SvPV(ST(2), PL_na);
        if (!SvOK((SV*) ST(3))) arg4 = 0;
        else arg4 = (char *) SvPV(ST(3), PL_na);
        result = (librdf_storage *)librdf_new_storage(arg1,arg2,arg3,arg4);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_librdf_storage,0);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_new_storage_from_storage) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_storage *arg1 = (librdf_storage *) 0 ;
        librdf_storage *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: librdf_new_storage_from_storage(old_storage);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_storage,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_new_storage_from_storage. Expected _p_librdf_storage");
            }
        }
        result = (librdf_storage *)librdf_new_storage_from_storage(arg1);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_librdf_storage,0);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_free_storage) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_storage *arg1 = (librdf_storage *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: librdf_free_storage(storage);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_storage,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_free_storage. Expected _p_librdf_storage");
            }
        }
        librdf_free_storage(arg1);
        
        
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_new_parser) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_world *arg1 = (librdf_world *) 0 ;
        char *arg2 ;
        char *arg3 ;
        librdf_uri *arg4 = (librdf_uri *) 0 ;
        librdf_parser *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 4) || (items > 4)) {
            SWIG_croak("Usage: librdf_new_parser(world,name,mime_type,type_uri);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_world,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_new_parser. Expected _p_librdf_world");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        if (!SvOK((SV*) ST(2))) arg3 = 0;
        else arg3 = (char *) SvPV(ST(2), PL_na);
        {
            if (SWIG_ConvertPtr(ST(3), (void **) &arg4, SWIGTYPE_p_librdf_uri,0) < 0) {
                SWIG_croak("Type error in argument 4 of librdf_new_parser. Expected _p_librdf_uri");
            }
        }
        result = (librdf_parser *)librdf_new_parser(arg1,(char const *)arg2,(char const *)arg3,arg4);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_librdf_parser,0);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_free_parser) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_parser *arg1 = (librdf_parser *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: librdf_free_parser(parser);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_parser,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_free_parser. Expected _p_librdf_parser");
            }
        }
        librdf_free_parser(arg1);
        
        
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_parser_parse_as_stream) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_parser *arg1 = (librdf_parser *) 0 ;
        librdf_uri *arg2 = (librdf_uri *) 0 ;
        librdf_uri *arg3 = (librdf_uri *) 0 ;
        librdf_stream *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 3) || (items > 3)) {
            SWIG_croak("Usage: librdf_parser_parse_as_stream(parser,uri,base_uri);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_parser,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_parser_parse_as_stream. Expected _p_librdf_parser");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_librdf_uri,0) < 0) {
                SWIG_croak("Type error in argument 2 of librdf_parser_parse_as_stream. Expected _p_librdf_uri");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(2), (void **) &arg3, SWIGTYPE_p_librdf_uri,0) < 0) {
                SWIG_croak("Type error in argument 3 of librdf_parser_parse_as_stream. Expected _p_librdf_uri");
            }
        }
        result = (librdf_stream *)librdf_parser_parse_as_stream(arg1,arg2,arg3);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_librdf_stream,0);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_parser_parse_into_model) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_parser *arg1 = (librdf_parser *) 0 ;
        librdf_uri *arg2 = (librdf_uri *) 0 ;
        librdf_uri *arg3 = (librdf_uri *) 0 ;
        librdf_model *arg4 = (librdf_model *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 4) || (items > 4)) {
            SWIG_croak("Usage: librdf_parser_parse_into_model(parser,uri,base_uri,model);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_parser,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_parser_parse_into_model. Expected _p_librdf_parser");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_librdf_uri,0) < 0) {
                SWIG_croak("Type error in argument 2 of librdf_parser_parse_into_model. Expected _p_librdf_uri");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(2), (void **) &arg3, SWIGTYPE_p_librdf_uri,0) < 0) {
                SWIG_croak("Type error in argument 3 of librdf_parser_parse_into_model. Expected _p_librdf_uri");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(3), (void **) &arg4, SWIGTYPE_p_librdf_model,0) < 0) {
                SWIG_croak("Type error in argument 4 of librdf_parser_parse_into_model. Expected _p_librdf_model");
            }
        }
        result = (int)librdf_parser_parse_into_model(arg1,arg2,arg3,arg4);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_parser_parse_string_as_stream) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_parser *arg1 = (librdf_parser *) 0 ;
        char *arg2 ;
        librdf_uri *arg3 = (librdf_uri *) 0 ;
        librdf_stream *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 3) || (items > 3)) {
            SWIG_croak("Usage: librdf_parser_parse_string_as_stream(parser,string,base_uri);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_parser,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_parser_parse_string_as_stream. Expected _p_librdf_parser");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        {
            if (SWIG_ConvertPtr(ST(2), (void **) &arg3, SWIGTYPE_p_librdf_uri,0) < 0) {
                SWIG_croak("Type error in argument 3 of librdf_parser_parse_string_as_stream. Expected _p_librdf_uri");
            }
        }
        result = (librdf_stream *)librdf_parser_parse_string_as_stream(arg1,(char const *)arg2,arg3);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_librdf_stream,0);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_parser_parse_string_into_model) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_parser *arg1 = (librdf_parser *) 0 ;
        char *arg2 ;
        librdf_uri *arg3 = (librdf_uri *) 0 ;
        librdf_model *arg4 = (librdf_model *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 4) || (items > 4)) {
            SWIG_croak("Usage: librdf_parser_parse_string_into_model(parser,string,base_uri,model);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_parser,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_parser_parse_string_into_model. Expected _p_librdf_parser");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        {
            if (SWIG_ConvertPtr(ST(2), (void **) &arg3, SWIGTYPE_p_librdf_uri,0) < 0) {
                SWIG_croak("Type error in argument 3 of librdf_parser_parse_string_into_model. Expected _p_librdf_uri");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(3), (void **) &arg4, SWIGTYPE_p_librdf_model,0) < 0) {
                SWIG_croak("Type error in argument 4 of librdf_parser_parse_string_into_model. Expected _p_librdf_model");
            }
        }
        result = (int)librdf_parser_parse_string_into_model(arg1,(char const *)arg2,arg3,arg4);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_parser_get_feature) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_parser *arg1 = (librdf_parser *) 0 ;
        librdf_uri *arg2 = (librdf_uri *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: librdf_parser_get_feature(parser,feature);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_parser,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_parser_get_feature. Expected _p_librdf_parser");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_librdf_uri,0) < 0) {
                SWIG_croak("Type error in argument 2 of librdf_parser_get_feature. Expected _p_librdf_uri");
            }
        }
        result = (char *)librdf_parser_get_feature(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        }else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_parser_set_feature) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_parser *arg1 = (librdf_parser *) 0 ;
        librdf_uri *arg2 = (librdf_uri *) 0 ;
        char *arg3 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 3) || (items > 3)) {
            SWIG_croak("Usage: librdf_parser_set_feature(parser,feature,value);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_parser,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_parser_set_feature. Expected _p_librdf_parser");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_librdf_uri,0) < 0) {
                SWIG_croak("Type error in argument 2 of librdf_parser_set_feature. Expected _p_librdf_uri");
            }
        }
        if (!SvOK((SV*) ST(2))) arg3 = 0;
        else arg3 = (char *) SvPV(ST(2), PL_na);
        result = (int)librdf_parser_set_feature(arg1,arg2,(char const *)arg3);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_new_serializer) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_world *arg1 = (librdf_world *) 0 ;
        char *arg2 ;
        char *arg3 ;
        librdf_uri *arg4 = (librdf_uri *) 0 ;
        librdf_serializer *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 4) || (items > 4)) {
            SWIG_croak("Usage: librdf_new_serializer(world,name,mime_type,type_uri);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_world,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_new_serializer. Expected _p_librdf_world");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        if (!SvOK((SV*) ST(2))) arg3 = 0;
        else arg3 = (char *) SvPV(ST(2), PL_na);
        {
            if (SWIG_ConvertPtr(ST(3), (void **) &arg4, SWIGTYPE_p_librdf_uri,0) < 0) {
                SWIG_croak("Type error in argument 4 of librdf_new_serializer. Expected _p_librdf_uri");
            }
        }
        result = (librdf_serializer *)librdf_new_serializer(arg1,(char const *)arg2,(char const *)arg3,arg4);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_librdf_serializer,0);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_free_serializer) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_serializer *arg1 = (librdf_serializer *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: librdf_free_serializer(serializer);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_serializer,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_free_serializer. Expected _p_librdf_serializer");
            }
        }
        librdf_free_serializer(arg1);
        
        
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_serializer_serialize_model_to_file) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_serializer *arg1 = (librdf_serializer *) 0 ;
        char *arg2 ;
        librdf_uri *arg3 = (librdf_uri *) 0 ;
        librdf_model *arg4 = (librdf_model *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 4) || (items > 4)) {
            SWIG_croak("Usage: librdf_serializer_serialize_model_to_file(serializer,name,base_uri,model);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_serializer,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_serializer_serialize_model_to_file. Expected _p_librdf_serializer");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        {
            if (SWIG_ConvertPtr(ST(2), (void **) &arg3, SWIGTYPE_p_librdf_uri,0) < 0) {
                SWIG_croak("Type error in argument 3 of librdf_serializer_serialize_model_to_file. Expected _p_librdf_uri");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(3), (void **) &arg4, SWIGTYPE_p_librdf_model,0) < 0) {
                SWIG_croak("Type error in argument 4 of librdf_serializer_serialize_model_to_file. Expected _p_librdf_model");
            }
        }
        result = (int)librdf_serializer_serialize_model_to_file(arg1,(char const *)arg2,arg3,arg4);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_serializer_get_feature) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_serializer *arg1 = (librdf_serializer *) 0 ;
        librdf_uri *arg2 = (librdf_uri *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: librdf_serializer_get_feature(serializer,feature);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_serializer,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_serializer_get_feature. Expected _p_librdf_serializer");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_librdf_uri,0) < 0) {
                SWIG_croak("Type error in argument 2 of librdf_serializer_get_feature. Expected _p_librdf_uri");
            }
        }
        result = (char *)librdf_serializer_get_feature(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        }else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_serializer_set_feature) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_serializer *arg1 = (librdf_serializer *) 0 ;
        librdf_uri *arg2 = (librdf_uri *) 0 ;
        char *arg3 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 3) || (items > 3)) {
            SWIG_croak("Usage: librdf_serializer_set_feature(serializer,feature,value);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_serializer,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_serializer_set_feature. Expected _p_librdf_serializer");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_librdf_uri,0) < 0) {
                SWIG_croak("Type error in argument 2 of librdf_serializer_set_feature. Expected _p_librdf_uri");
            }
        }
        if (!SvOK((SV*) ST(2))) arg3 = 0;
        else arg3 = (char *) SvPV(ST(2), PL_na);
        result = (int)librdf_serializer_set_feature(arg1,arg2,(char const *)arg3);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_free_stream) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_stream *arg1 = (librdf_stream *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: librdf_free_stream(stream);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_stream,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_free_stream. Expected _p_librdf_stream");
            }
        }
        librdf_free_stream(arg1);
        
        
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_stream_end) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_stream *arg1 = (librdf_stream *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: librdf_stream_end(stream);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_stream,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_stream_end. Expected _p_librdf_stream");
            }
        }
        result = (int)librdf_stream_end(arg1);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_stream_next) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_stream *arg1 = (librdf_stream *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: librdf_stream_next(stream);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_stream,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_stream_next. Expected _p_librdf_stream");
            }
        }
        result = (int)librdf_stream_next(arg1);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_stream_get_object) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_stream *arg1 = (librdf_stream *) 0 ;
        librdf_statement *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: librdf_stream_get_object(stream);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_stream,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_stream_get_object. Expected _p_librdf_stream");
            }
        }
        result = (librdf_statement *)librdf_stream_get_object(arg1);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_librdf_statement,0);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_stream_get_context) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_stream *arg1 = (librdf_stream *) 0 ;
        librdf_node *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: librdf_stream_get_context(stream);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_stream,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_stream_get_context. Expected _p_librdf_stream");
            }
        }
        result = (librdf_node *)librdf_stream_get_context(arg1);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_librdf_node,0);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_perl_world_init) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_world *arg1 = (librdf_world *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: librdf_perl_world_init(world);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_world,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_perl_world_init. Expected _p_librdf_world");
            }
        }
        librdf_perl_world_init(arg1);
        
        
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_perl_world_finish) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        int argvi = 0;
        dXSARGS;
        
        if ((items < 0) || (items > 0)) {
            SWIG_croak("Usage: librdf_perl_world_finish();");
        }
        librdf_perl_world_finish();
        
        
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_internal_test_error) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_world *arg1 = (librdf_world *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: librdf_internal_test_error(world);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_world,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_internal_test_error. Expected _p_librdf_world");
            }
        }
        librdf_internal_test_error(arg1);
        
        
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_librdf_internal_test_warning) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        librdf_world *arg1 = (librdf_world *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: librdf_internal_test_warning(world);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_librdf_world,0) < 0) {
                SWIG_croak("Type error in argument 1 of librdf_internal_test_warning. Expected _p_librdf_world");
            }
        }
        librdf_internal_test_warning(arg1);
        
        
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}



/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (BEGIN) -------- */

static swig_type_info _swigt__p_librdf_node[] = {{"_p_librdf_node", 0, "librdf_node *", 0},{"_p_librdf_node"},{0}};
static swig_type_info _swigt__p_librdf_parser[] = {{"_p_librdf_parser", 0, "librdf_parser *", 0},{"_p_librdf_parser"},{0}};
static swig_type_info _swigt__p_librdf_world[] = {{"_p_librdf_world", 0, "librdf_world *", 0},{"_p_librdf_world"},{0}};
static swig_type_info _swigt__p_librdf_hash[] = {{"_p_librdf_hash", 0, "librdf_hash *", 0},{"_p_librdf_hash"},{0}};
static swig_type_info _swigt__p_librdf_statement[] = {{"_p_librdf_statement", 0, "librdf_statement *", 0},{"_p_librdf_statement"},{0}};
static swig_type_info _swigt__p_librdf_iterator[] = {{"_p_librdf_iterator", 0, "librdf_iterator *", 0},{"_p_librdf_iterator"},{0}};
static swig_type_info _swigt__p_librdf_storage[] = {{"_p_librdf_storage", 0, "librdf_storage *", 0},{"_p_librdf_storage"},{0}};
static swig_type_info _swigt__p_librdf_uri[] = {{"_p_librdf_uri", 0, "librdf_uri *", 0},{"_p_librdf_uri"},{0}};
static swig_type_info _swigt__p_librdf_model[] = {{"_p_librdf_model", 0, "librdf_model *", 0},{"_p_librdf_model"},{0}};
static swig_type_info _swigt__p_librdf_stream[] = {{"_p_librdf_stream", 0, "librdf_stream *", 0},{"_p_librdf_stream"},{0}};
static swig_type_info _swigt__p_librdf_serializer[] = {{"_p_librdf_serializer", 0, "librdf_serializer *", 0},{"_p_librdf_serializer"},{0}};

static swig_type_info *swig_types_initial[] = {
_swigt__p_librdf_node, 
_swigt__p_librdf_parser, 
_swigt__p_librdf_world, 
_swigt__p_librdf_hash, 
_swigt__p_librdf_statement, 
_swigt__p_librdf_iterator, 
_swigt__p_librdf_storage, 
_swigt__p_librdf_uri, 
_swigt__p_librdf_model, 
_swigt__p_librdf_stream, 
_swigt__p_librdf_serializer, 
0
};


/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (END) -------- */

static swig_constant_info swig_constants[] = {
{0}
};
#ifdef __cplusplus
}
#endif
static swig_variable_info swig_variables[] = {
    { "RDF::Redland::CORE::redland_copyright_string", MAGIC_CLASS swig_magic_readonly, MAGIC_CLASS _wrap_val_redland_copyright_string,0 },
    { "RDF::Redland::CORE::redland_version_string", MAGIC_CLASS swig_magic_readonly, MAGIC_CLASS _wrap_val_redland_version_string,0 },
    { "RDF::Redland::CORE::redland_version_major", MAGIC_CLASS swig_magic_readonly, MAGIC_CLASS _wrap_val_redland_version_major,0 },
    { "RDF::Redland::CORE::redland_version_minor", MAGIC_CLASS swig_magic_readonly, MAGIC_CLASS _wrap_val_redland_version_minor,0 },
    { "RDF::Redland::CORE::redland_version_release", MAGIC_CLASS swig_magic_readonly, MAGIC_CLASS _wrap_val_redland_version_release,0 },
{0}
};
static swig_command_info swig_commands[] = {
{"RDF::Redland::CORE::librdf_new_world", _wrap_librdf_new_world},
{"RDF::Redland::CORE::librdf_free_world", _wrap_librdf_free_world},
{"RDF::Redland::CORE::librdf_world_open", _wrap_librdf_world_open},
{"RDF::Redland::CORE::librdf_init_world", _wrap_librdf_init_world},
{"RDF::Redland::CORE::librdf_destroy_world", _wrap_librdf_destroy_world},
{"RDF::Redland::CORE::librdf_free_iterator", _wrap_librdf_free_iterator},
{"RDF::Redland::CORE::librdf_iterator_have_elements", _wrap_librdf_iterator_have_elements},
{"RDF::Redland::CORE::librdf_iterator_end", _wrap_librdf_iterator_end},
{"RDF::Redland::CORE::librdf_iterator_get_object", _wrap_librdf_iterator_get_object},
{"RDF::Redland::CORE::librdf_iterator_get_context", _wrap_librdf_iterator_get_context},
{"RDF::Redland::CORE::librdf_iterator_next", _wrap_librdf_iterator_next},
{"RDF::Redland::CORE::librdf_new_uri", _wrap_librdf_new_uri},
{"RDF::Redland::CORE::librdf_new_uri_from_uri", _wrap_librdf_new_uri_from_uri},
{"RDF::Redland::CORE::librdf_new_uri_from_filename", _wrap_librdf_new_uri_from_filename},
{"RDF::Redland::CORE::librdf_free_uri", _wrap_librdf_free_uri},
{"RDF::Redland::CORE::librdf_uri_to_string", _wrap_librdf_uri_to_string},
{"RDF::Redland::CORE::librdf_uri_equals", _wrap_librdf_uri_equals},
{"RDF::Redland::CORE::librdf_new_node", _wrap_librdf_new_node},
{"RDF::Redland::CORE::librdf_new_node_from_uri_string", _wrap_librdf_new_node_from_uri_string},
{"RDF::Redland::CORE::librdf_new_node_from_uri", _wrap_librdf_new_node_from_uri},
{"RDF::Redland::CORE::librdf_new_node_from_literal", _wrap_librdf_new_node_from_literal},
{"RDF::Redland::CORE::librdf_new_node_from_typed_literal", _wrap_librdf_new_node_from_typed_literal},
{"RDF::Redland::CORE::librdf_new_node_from_node", _wrap_librdf_new_node_from_node},
{"RDF::Redland::CORE::librdf_new_node_from_blank_identifier", _wrap_librdf_new_node_from_blank_identifier},
{"RDF::Redland::CORE::librdf_free_node", _wrap_librdf_free_node},
{"RDF::Redland::CORE::librdf_node_get_uri", _wrap_librdf_node_get_uri},
{"RDF::Redland::CORE::librdf_node_get_type", _wrap_librdf_node_get_type},
{"RDF::Redland::CORE::librdf_node_get_literal_value", _wrap_librdf_node_get_literal_value},
{"RDF::Redland::CORE::librdf_node_get_literal_value_as_latin1", _wrap_librdf_node_get_literal_value_as_latin1},
{"RDF::Redland::CORE::librdf_node_get_literal_value_language", _wrap_librdf_node_get_literal_value_language},
{"RDF::Redland::CORE::librdf_node_get_literal_value_datatype_uri", _wrap_librdf_node_get_literal_value_datatype_uri},
{"RDF::Redland::CORE::librdf_node_get_literal_value_is_wf_xml", _wrap_librdf_node_get_literal_value_is_wf_xml},
{"RDF::Redland::CORE::librdf_node_to_string", _wrap_librdf_node_to_string},
{"RDF::Redland::CORE::librdf_node_get_blank_identifier", _wrap_librdf_node_get_blank_identifier},
{"RDF::Redland::CORE::librdf_node_is_resource", _wrap_librdf_node_is_resource},
{"RDF::Redland::CORE::librdf_node_is_literal", _wrap_librdf_node_is_literal},
{"RDF::Redland::CORE::librdf_node_is_blank", _wrap_librdf_node_is_blank},
{"RDF::Redland::CORE::librdf_node_equals", _wrap_librdf_node_equals},
{"RDF::Redland::CORE::librdf_new_statement", _wrap_librdf_new_statement},
{"RDF::Redland::CORE::librdf_new_statement_from_statement", _wrap_librdf_new_statement_from_statement},
{"RDF::Redland::CORE::librdf_new_statement_from_nodes", _wrap_librdf_new_statement_from_nodes},
{"RDF::Redland::CORE::librdf_free_statement", _wrap_librdf_free_statement},
{"RDF::Redland::CORE::librdf_statement_get_subject", _wrap_librdf_statement_get_subject},
{"RDF::Redland::CORE::librdf_statement_set_subject", _wrap_librdf_statement_set_subject},
{"RDF::Redland::CORE::librdf_statement_get_predicate", _wrap_librdf_statement_get_predicate},
{"RDF::Redland::CORE::librdf_statement_set_predicate", _wrap_librdf_statement_set_predicate},
{"RDF::Redland::CORE::librdf_statement_get_object", _wrap_librdf_statement_get_object},
{"RDF::Redland::CORE::librdf_statement_set_object", _wrap_librdf_statement_set_object},
{"RDF::Redland::CORE::librdf_statement_to_string", _wrap_librdf_statement_to_string},
{"RDF::Redland::CORE::librdf_new_model", _wrap_librdf_new_model},
{"RDF::Redland::CORE::librdf_new_model_with_options", _wrap_librdf_new_model_with_options},
{"RDF::Redland::CORE::librdf_new_model_from_model", _wrap_librdf_new_model_from_model},
{"RDF::Redland::CORE::librdf_free_model", _wrap_librdf_free_model},
{"RDF::Redland::CORE::librdf_model_size", _wrap_librdf_model_size},
{"RDF::Redland::CORE::librdf_model_add", _wrap_librdf_model_add},
{"RDF::Redland::CORE::librdf_model_add_typed_literal_statement", _wrap_librdf_model_add_typed_literal_statement},
{"RDF::Redland::CORE::librdf_model_add_statement", _wrap_librdf_model_add_statement},
{"RDF::Redland::CORE::librdf_model_add_statements", _wrap_librdf_model_add_statements},
{"RDF::Redland::CORE::librdf_model_remove_statement", _wrap_librdf_model_remove_statement},
{"RDF::Redland::CORE::librdf_model_contains_statement", _wrap_librdf_model_contains_statement},
{"RDF::Redland::CORE::librdf_model_as_stream", _wrap_librdf_model_as_stream},
{"RDF::Redland::CORE::librdf_model_serialise", _wrap_librdf_model_serialise},
{"RDF::Redland::CORE::librdf_model_find_statements", _wrap_librdf_model_find_statements},
{"RDF::Redland::CORE::librdf_model_get_sources", _wrap_librdf_model_get_sources},
{"RDF::Redland::CORE::librdf_model_get_arcs", _wrap_librdf_model_get_arcs},
{"RDF::Redland::CORE::librdf_model_get_targets", _wrap_librdf_model_get_targets},
{"RDF::Redland::CORE::librdf_model_get_source", _wrap_librdf_model_get_source},
{"RDF::Redland::CORE::librdf_model_get_arc", _wrap_librdf_model_get_arc},
{"RDF::Redland::CORE::librdf_model_get_target", _wrap_librdf_model_get_target},
{"RDF::Redland::CORE::librdf_model_context_add_statement", _wrap_librdf_model_context_add_statement},
{"RDF::Redland::CORE::librdf_model_context_add_statements", _wrap_librdf_model_context_add_statements},
{"RDF::Redland::CORE::librdf_model_context_remove_statement", _wrap_librdf_model_context_remove_statement},
{"RDF::Redland::CORE::librdf_model_context_remove_statements", _wrap_librdf_model_context_remove_statements},
{"RDF::Redland::CORE::librdf_model_context_as_stream", _wrap_librdf_model_context_as_stream},
{"RDF::Redland::CORE::librdf_model_context_serialize", _wrap_librdf_model_context_serialize},
{"RDF::Redland::CORE::librdf_model_sync", _wrap_librdf_model_sync},
{"RDF::Redland::CORE::librdf_new_storage", _wrap_librdf_new_storage},
{"RDF::Redland::CORE::librdf_new_storage_from_storage", _wrap_librdf_new_storage_from_storage},
{"RDF::Redland::CORE::librdf_free_storage", _wrap_librdf_free_storage},
{"RDF::Redland::CORE::librdf_new_parser", _wrap_librdf_new_parser},
{"RDF::Redland::CORE::librdf_free_parser", _wrap_librdf_free_parser},
{"RDF::Redland::CORE::librdf_parser_parse_as_stream", _wrap_librdf_parser_parse_as_stream},
{"RDF::Redland::CORE::librdf_parser_parse_into_model", _wrap_librdf_parser_parse_into_model},
{"RDF::Redland::CORE::librdf_parser_parse_string_as_stream", _wrap_librdf_parser_parse_string_as_stream},
{"RDF::Redland::CORE::librdf_parser_parse_string_into_model", _wrap_librdf_parser_parse_string_into_model},
{"RDF::Redland::CORE::librdf_parser_get_feature", _wrap_librdf_parser_get_feature},
{"RDF::Redland::CORE::librdf_parser_set_feature", _wrap_librdf_parser_set_feature},
{"RDF::Redland::CORE::librdf_new_serializer", _wrap_librdf_new_serializer},
{"RDF::Redland::CORE::librdf_free_serializer", _wrap_librdf_free_serializer},
{"RDF::Redland::CORE::librdf_serializer_serialize_model_to_file", _wrap_librdf_serializer_serialize_model_to_file},
{"RDF::Redland::CORE::librdf_serializer_get_feature", _wrap_librdf_serializer_get_feature},
{"RDF::Redland::CORE::librdf_serializer_set_feature", _wrap_librdf_serializer_set_feature},
{"RDF::Redland::CORE::librdf_free_stream", _wrap_librdf_free_stream},
{"RDF::Redland::CORE::librdf_stream_end", _wrap_librdf_stream_end},
{"RDF::Redland::CORE::librdf_stream_next", _wrap_librdf_stream_next},
{"RDF::Redland::CORE::librdf_stream_get_object", _wrap_librdf_stream_get_object},
{"RDF::Redland::CORE::librdf_stream_get_context", _wrap_librdf_stream_get_context},
{"RDF::Redland::CORE::librdf_perl_world_init", _wrap_librdf_perl_world_init},
{"RDF::Redland::CORE::librdf_perl_world_finish", _wrap_librdf_perl_world_finish},
{"RDF::Redland::CORE::librdf_internal_test_error", _wrap_librdf_internal_test_error},
{"RDF::Redland::CORE::librdf_internal_test_warning", _wrap_librdf_internal_test_warning},
{0,0}
};

#ifdef __cplusplus
extern "C"
#endif

XS(SWIG_init) {
    dXSARGS;
    int i;
    static int _init = 0;
    if (!_init) {
        for (i = 0; swig_types_initial[i]; i++) {
            swig_types[i] = SWIG_TypeRegister(swig_types_initial[i]);
        }
        _init = 1;
    }
    
    /* Install commands */
    for (i = 0; swig_commands[i].name; i++) {
        newXS((char*) swig_commands[i].name,swig_commands[i].wrapper, (char*)__FILE__);
    }
    
    /* Install variables */
    for (i = 0; swig_variables[i].name; i++) {
        SV *sv;
        sv = perl_get_sv((char*) swig_variables[i].name, TRUE | 0x2);
        if (swig_variables[i].type) {
            SWIG_MakePtr(sv,(void *)1, *swig_variables[i].type,0);
        }else {
            sv_setiv(sv,(IV) 0);
        }
        swig_create_magic(sv, (char *) swig_variables[i].name, swig_variables[i].set, swig_variables[i].get); 
    }
    
    /* Install constant */
    for (i = 0; swig_constants[i].type; i++) {
        SV *sv;
        sv = perl_get_sv((char*)swig_constants[i].name, TRUE | 0x2);
        switch(swig_constants[i].type) {
            case SWIG_INT:
            sv_setiv(sv, (IV) swig_constants[i].lvalue);
            break;
            case SWIG_FLOAT:
            sv_setnv(sv, (double) swig_constants[i].dvalue);
            break;
            case SWIG_STRING:
            sv_setpv(sv, (char *) swig_constants[i].pvalue);
            break;
            case SWIG_POINTER:
            SWIG_MakePtr(sv, swig_constants[i].pvalue, *(swig_constants[i].ptype),0);
            break;
            case SWIG_BINARY:
            /*      obj = SWIG_NewPackedObj(swig_constants[i].pvalue, swig_constants[i].lvalue, *(swig_constants[i].ptype)); */
            break;
            default:
            break;
        }
        SvREADONLY_on(sv);
    }
    
    
    #ifdef TCL_MAJOR_VERSION
    Tcl_PkgProvide(interp, PACKAGE, (char*)redland_version_string);
    #endif
    
    ST(0) = &PL_sv_yes;
    XSRETURN(1);
}

