#!perl
use 5.006;
use strict;
use warnings FATAL => 'all';
use Test::More;

BEGIN {
    use_ok('WebService::HIBP') || print "Bail out!\n";
}

my $hibp = WebService::HIBP->new();
SKIP: {
    my @classes;
	ACCOUNT: {
			eval {
				@classes = $hibp->data_classes();
			} or do {
				if ($@ =~ /429/) {
					sleep 2 + int rand 4;
					redo ACCOUNT;
				}
			};
	}
    ok(
        scalar @classes > 0,
        'Found data classes ' . join q[, ],
        map { "'$_'" } @classes
    );
	my @breaches;
	ACCOUNT: {
			eval {
				@breaches = $hibp->account( 'test@example.com' );
			} or do {
				if ($@ =~ /429/) {
					sleep 2 + int rand 4;
					redo ACCOUNT;
				}
			};
	}
    my $count = 0;
    foreach my $breach ( @breaches ) {
        ok( $breach->name(),  "Name of breach is '" . $breach->name() . "'" );
        ok( $breach->title(), "Title of breach is '" . $breach->title() . "'" );
        ok( 1,
                "Domain of breach is '"
              . ( $breach->domain() || 'not defined' )
              . "'" );
        my $description = Encode::encode( 'UTF-8', $breach->description(), 1 );
        ok( $description, "Description of breach is '" . $description . "'" );
        foreach my $data_class ( $breach->data_classes() ) {
            ok( $data_class, "Found data_class '$data_class'" );
        }
        ok(
            $breach->breach_date() =~ /^\d{4}\-\d{2}\-\d{2}$/smx,
            "Date of breach is '"
              . $breach->breach_date()
              . "' and is correctly formatted"
        );
        ok(
            $breach->added_date() =~
              /^\d{4}\-\d{2}\-\d{2}T\d{2}:\d{2}:\d{2}Z$/smx,
            "Added Date is '"
              . $breach->modified_date()
              . "' and is correctly formatted"
        );
        ok(
            $breach->modified_date() =~
              /^\d{4}\-\d{2}\-\d{2}T\d{2}:\d{2}:\d{2}Z$/smx,
            "Modified Date is '"
              . $breach->modified_date()
              . "' and is correctly formatted"
        );
        ok( $breach->logo_type(),
            "Logo Type of breach is '" . $breach->logo_type() . "'" );
        ok( defined $breach->is_active(),
            "Breach is " . ( $breach->is_active() ? 'active' : 'NOT active' ) );
        ok(
            defined $breach->is_retired(),
            "Breach is " . ( $breach->is_retired() ? 'retired' : 'NOT retired' )
        );
        ok(
            defined $breach->is_sensitive(),
            "Breach is "
              . ( $breach->is_sensitive() ? 'sensitive' : 'NOT sensitive' )
        );
        ok(
            defined $breach->is_spam_list(),
            "Breach is "
              . ( $breach->is_spam_list() ? 'a spam list' : 'NOT a spam list' )
        );
        ok(
            defined $breach->is_verified(),
            "Breach is "
              . ( $breach->is_verified() ? 'verified' : 'NOT verified' )
        );
        ok(
            defined $breach->is_fabricated(),
            "Breach is "
              . ( $breach->is_fabricated() ? 'fabricated' : 'NOT fabricated' )
        );
        ok(
            $breach->pwn_count() =~ /^\d+$/smx,
            "Pwn Count is '"
              . $breach->pwn_count()
              . "' and is correctly formatted"
        );
        $count += 1;
    }
    my $previous_count = $count;
    $count = 0;
	@breaches = ();
	ACCOUNT: {
			eval {
				@breaches = $hibp->account( 'test@example.com', truncate => 1 );
			} or do {
				if ($@ =~ /429/) {
					sleep 2 + int rand 4;
					redo ACCOUNT;
				}
			};
	}
    foreach my $breach ( @breaches ) {
        if ( defined $breach->title() ) {
        }
        elsif ( defined $breach->domain() ) {
        }
        elsif ( defined $breach->description() ) {
        }
        elsif ( scalar $breach->data_classes() ) {
        }
        elsif ( defined $breach->breach_date() ) {
        }
        elsif ( defined $breach->added_date() ) {
        }
        elsif ( defined $breach->modified_date() ) {
        }
        elsif ( defined $breach->logo_type() ) {
        }
        elsif ( defined $breach->is_active() ) {
        }
        elsif ( defined $breach->is_retired() ) {
        }
        elsif ( defined $breach->is_sensitive() ) {
        }
        elsif ( defined $breach->is_spam_list() ) {
        }
        elsif ( defined $breach->is_verified() ) {
        }
        elsif ( defined $breach->is_fabricated() ) {
        }
        elsif ( $breach->name() ) {
            $count += 1;
        }

    }
    ok(
        $count == $previous_count,
"When truncate is applied, all the breaches were returned with only the name defined:$count:$previous_count"
    );
    $count = 0;
	@breaches = ();
	ACCOUNT: {
			eval {
				@breaches = $hibp->account( 'test@example.com', unverified => 1 );
			} or do {
				if ($@ =~ /429/) {
					sleep 2 + int rand 4;
					redo ACCOUNT;
				}
			};
	}
    foreach my $breach ( @breaches )
    {
        if ( $breach->name() ) {
            $count += 1;
        }
    }
    $count = 0;
	@breaches = ();
	ACCOUNT: {
			eval {
				@breaches = $hibp->account( 'test@example.com', domain => 'adobe.com' );
			} or do {
				if ($@ =~ /429/) {
					sleep 2 + int rand 4;
					redo ACCOUNT;
				}
			};
	}
    foreach my $breach ( @breaches ) {
        if ( $breach->name() ) {
            $count += 1;
        }
    }
    ok( $count < $previous_count && $count > 0,
        "When domain adobe.com is applied, less breaches were reported" );
    my $breach;
	ACCOUNT: {
			eval {
				$breach = $hibp->breach( 'Adobe' );
			} or do {
				if ($@ =~ /429/) {
					sleep 2 + int rand 4;
					redo ACCOUNT;
				}
			};
	}
    ok( $breach->name() eq 'Adobe',
        "Request for a specific breach is returned" );
	@breaches = ();
	ACCOUNT: {
			eval {
				@breaches = $hibp->breaches();
			} or do {
				if ($@ =~ /429/) {
					sleep 2 + int rand 4;
					redo ACCOUNT;
				}
			};
	}
    $count = 0;
    foreach my $breach ( sort { $a->added_date() cmp $b->added_date() }
        @breaches )
    {
        if ( $breach->description() ) {
            $count += 1;
        }
    }
    ok( $count, "Found $count breaches with descriptions" );
    $previous_count = $count;
    $count          = 0;
	@breaches = ();
	ACCOUNT: {
			eval {
				@breaches = $hibp->breaches( domain => 'adobe.com' );
			} or do {
				if ($@ =~ /429/) {
					sleep 2 + int rand 4;
					redo ACCOUNT;
				}
			};
	}
    foreach my $breach ( sort { $a->added_date() cmp $b->added_date() }
        @breaches )
    {
        $count += 1;
    }
    ok( $count > 0 && $count < $previous_count,
        "Found $count breaches for adobe.com (filtering appears to work)" );
	my @pastes;
	PASTE: {
			eval {
				@pastes = $hibp->pastes( 'test@example.com' );
			} or do {
				if ($@ =~ /429/) {
					sleep 2 + int rand 4;
					redo PASTE;
				}
			};
	}
    foreach my $paste ( @pastes ) {
        ok( $paste->source(), "Source of paste is '" . $paste->source() . "'" );
        ok( $paste->id(),     "Id of paste is '" . $paste->id() . "'" );
        ok( $paste->title() || 1,
            "Title of paste is '" . ( $paste->title() || '' ) . "'" );
        ok( $paste->date() || 1,
            "Date of paste is '" . ( $paste->date() || '' ) . "'" );
        ok( $paste->email_count(),
            "Email Count of paste is '" . $paste->email_count() . "'" );
    }
    my $bad_password = 'password1';
    $count = 0;
	PASSWORD: {
			eval {
				$count = $hibp->password($bad_password);
			} or do {
				if ($@ =~ /429/) {
					sleep 2 + int rand 4;
					redo PASSWORD;
				}
			};
	}
    ok( $count, "Bad password '$bad_password' returns a count of $count" );
    my $good_password = 'swYBygTEymkmYiwrgYj4yWwemeiQkTRQBuhWVh3JfxzRpxSTKj';
    $count = 50;
	PASSWORD: {
			eval {
				$count = $hibp->password($good_password);
			} or do {
				if ($@ =~ /429/) {
					sleep 2 + int rand 4;
					redo PASSWORD;
				}
			};
	}
    ok( $count == 0,
        "Good password '$good_password' returns a count of $count" );
}
done_testing();

