#!perl -T

use Test::More tests => 63;
use Archive::Har();
use JSON();

my $har = Archive::Har->new();

my $pingdom_string = '{"log":{"version":"1.2","creator":{"name":"Pingdom Tools","version":"","comment":"Test the load time of a web page at http://tools.pingdom.com/fpt"},"pages":[{"startedDateTime":"2012-03-23T01:22:05.820Z","id":"https://duckduckgo.com/?q=http+archive+specification","title":"","pageTimings":{"onContentLoad":333,"onLoad":372}}],"entries":[{"request":{"method":"GET","url":"https://duckduckgo.com/?q=http+archive+specification","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Accept-Encoding","value":"gzip,deflate,sdch"},{"name":"Accept-Language","value":"en-US,en;q=0.8"},{"name":"Connection","value":"keep-alive"},{"name":"Pragma","value":"no-cache"},{"name":"Accept-Charset","value":"ISO-8859-1,utf-8;q=0.7,*;q=0.3"},{"name":"Host","value":"duckduckgo.com"},{"name":"User-Agent","value":"Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/535.7 (KHTML, like Gecko) Chrome/16.0.912.63 Safari/535.7"},{"name":"Accept","value":"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8"},{"name":"Cache-Control","value":"no-cache"}],"queryString":[],"headersSize":441,"bodySize":-1},"response":{"status":200,"statusText":"OK","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Date","value":"Fri, 23 Mar 2012 01:22:06 GMT"},{"name":"Content-Encoding","value":"gzip"},{"name":"Transfer-Encoding","value":"chunked"},{"name":"Connection","value":"keep-alive"},{"name":"Server","value":"nginx"},{"name":"Content-Type","value":"text/html; charset=UTF-8"},{"name":"Cache-Control","value":"max-age=1"},{"name":"Expires","value":"Fri, 23 Mar 2012 01:22:07 GMT"}],"headersSize":253,"redirectURL":"","bodySize":3247,"content":{"size":6854,"mimeType":"text/html"}},"timings":{"blocked":0,"dns":-1,"connect":125,"send":0,"wait":28,"receive":1,"ssl":19},"cache":{},"pageref":"https://duckduckgo.com/?q=http+archive+specification","startedDateTime":"2012-03-23T01:22:05.820Z","time":173},{"request":{"method":"GET","url":"https://duckduckgo.com/s422.css","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Accept-Encoding","value":"gzip,deflate,sdch"},{"name":"Accept-Language","value":"en-US,en;q=0.8"},{"name":"Connection","value":"keep-alive"},{"name":"Pragma","value":"no-cache"},{"name":"Accept-Charset","value":"ISO-8859-1,utf-8;q=0.7,*;q=0.3"},{"name":"Host","value":"duckduckgo.com"},{"name":"User-Agent","value":"Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/535.7 (KHTML, like Gecko) Chrome/16.0.912.63 Safari/535.7"},{"name":"Accept","value":"text/css,*/*;q=0.1"},{"name":"Referer","value":"https://duckduckgo.com/?q=http+archive+specification"},{"name":"Cache-Control","value":"no-cache"}],"queryString":[],"headersSize":438,"bodySize":-1},"response":{"status":200,"statusText":"OK","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Date","value":"Fri, 23 Mar 2012 01:22:06 GMT"},{"name":"Content-Encoding","value":"gzip"},{"name":"Transfer-Encoding","value":"chunked"},{"name":"Connection","value":"keep-alive"},{"name":"Last-Modified","value":"Tue, 13 Mar 2012 02:10:41 GMT"},{"name":"Server","value":"nginx"},{"name":"Vary","value":"Accept-Encoding"},{"name":"Content-Type","value":"text/css"},{"name":"Cache-Control","value":"max-age=31536000"},{"name":"Expires","value":"Sat, 23 Mar 2013 01:22:06 GMT"}],"headersSize":313,"redirectURL":"","bodySize":6341,"content":{"size":25703,"mimeType":"text/css"}},"timings":{"blocked":0,"dns":-1,"connect":0,"send":1,"wait":12,"receive":-1,"ssl":-1},"cache":{},"pageref":"https://duckduckgo.com/?q=http+archive+specification","startedDateTime":"2012-03-23T01:22:05.982Z","time":13},{"request":{"method":"GET","url":"https://duckduckgo.com/d724.js","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Accept-Encoding","value":"gzip,deflate,sdch"},{"name":"Accept-Language","value":"en-US,en;q=0.8"},{"name":"Connection","value":"keep-alive"},{"name":"Pragma","value":"no-cache"},{"name":"Accept-Charset","value":"ISO-8859-1,utf-8;q=0.7,*;q=0.3"},{"name":"Host","value":"duckduckgo.com"},{"name":"User-Agent","value":"Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/535.7 (KHTML, like Gecko) Chrome/16.0.912.63 Safari/535.7"},{"name":"Accept","value":"*/*"},{"name":"Referer","value":"https://duckduckgo.com/?q=http+archive+specification"},{"name":"Cache-Control","value":"no-cache"}],"queryString":[],"headersSize":422,"bodySize":-1},"response":{"status":200,"statusText":"OK","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Date","value":"Fri, 23 Mar 2012 01:22:06 GMT"},{"name":"Content-Encoding","value":"gzip"},{"name":"Transfer-Encoding","value":"chunked"},{"name":"Connection","value":"keep-alive"},{"name":"Last-Modified","value":"Mon, 19 Mar 2012 14:55:16 GMT"},{"name":"Server","value":"nginx"},{"name":"Vary","value":"Accept-Encoding"},{"name":"Content-Type","value":"application/x-javascript; charset=UTF-8"},{"name":"Cache-Control","value":"max-age=31536000"},{"name":"Expires","value":"Sat, 23 Mar 2013 01:22:06 GMT"}],"headersSize":344,"redirectURL":"","bodySize":56948,"content":{"size":176455,"mimeType":"application/x-javascript"}},"timings":{"blocked":0,"dns":-1,"connect":13,"send":0,"wait":26,"receive":22,"ssl":-1},"cache":{},"pageref":"https://duckduckgo.com/?q=http+archive+specification","startedDateTime":"2012-03-23T01:22:05.982Z","time":61},{"request":{"method":"GET","url":"https://duckduckgo.com/f2/us.png","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Accept-Encoding","value":"gzip,deflate,sdch"},{"name":"Accept-Language","value":"en-US,en;q=0.8"},{"name":"Connection","value":"keep-alive"},{"name":"Pragma","value":"no-cache"},{"name":"Accept-Charset","value":"ISO-8859-1,utf-8;q=0.7,*;q=0.3"},{"name":"Host","value":"duckduckgo.com"},{"name":"User-Agent","value":"Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/535.7 (KHTML, like Gecko) Chrome/16.0.912.63 Safari/535.7"},{"name":"Accept","value":"*/*"},{"name":"Referer","value":"https://duckduckgo.com/?q=http+archive+specification"},{"name":"Cache-Control","value":"no-cache"}],"queryString":[],"headersSize":424,"bodySize":-1},"response":{"status":200,"statusText":"OK","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Date","value":"Fri, 23 Mar 2012 01:22:06 GMT"},{"name":"Connection","value":"keep-alive"},{"name":"Content-Length","value":"609"},{"name":"Last-Modified","value":"Fri, 20 Jan 2012 19:50:32 GMT"},{"name":"Server","value":"nginx"},{"name":"Content-Type","value":"image/png"},{"name":"Cache-Control","value":"max-age=31536000\npublic"},{"name":"Accept-Ranges","value":"bytes"},{"name":"Expires","value":"Sat, 23 Mar 2013 01:22:06 GMT"}],"headersSize":305,"redirectURL":"","bodySize":1151,"content":{"size":609,"mimeType":"image/png"}},"timings":{"blocked":0,"dns":-1,"connect":0,"send":0,"wait":16,"receive":-1,"ssl":-1},"cache":{},"pageref":"https://duckduckgo.com/?q=http+archive+specification","startedDateTime":"2012-03-23T01:22:06.010Z","time":16},{"request":{"method":"GET","url":"https://duckduckgo.com/post.html","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Accept-Encoding","value":"gzip,deflate,sdch"},{"name":"Accept-Language","value":"en-US,en;q=0.8"},{"name":"Connection","value":"keep-alive"},{"name":"Pragma","value":"no-cache"},{"name":"Accept-Charset","value":"ISO-8859-1,utf-8;q=0.7,*;q=0.3"},{"name":"Host","value":"duckduckgo.com"},{"name":"User-Agent","value":"Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/535.7 (KHTML, like Gecko) Chrome/16.0.912.63 Safari/535.7"},{"name":"Accept","value":"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8"},{"name":"Referer","value":"https://duckduckgo.com/?q=http+archive+specification"},{"name":"Cache-Control","value":"no-cache"}],"queryString":[],"headersSize":484,"bodySize":-1},"response":{"status":200,"statusText":"OK","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Date","value":"Fri, 23 Mar 2012 01:22:06 GMT"},{"name":"Content-Encoding","value":"gzip"},{"name":"Transfer-Encoding","value":"chunked"},{"name":"Connection","value":"keep-alive"},{"name":"Last-Modified","value":"Fri, 20 Jan 2012 19:39:14 GMT"},{"name":"Server","value":"nginx"},{"name":"Content-Type","value":"text/html; charset=UTF-8"},{"name":"Cache-Control","value":"max-age=86400"},{"name":"Expires","value":"Sat, 24 Mar 2012 01:22:06 GMT"}],"headersSize":303,"redirectURL":"","bodySize":533,"content":{"size":350,"mimeType":"text/html"}},"timings":{"blocked":0,"dns":-1,"connect":0,"send":0,"wait":10,"receive":-1,"ssl":-1},"cache":{},"pageref":"https://duckduckgo.com/?q=http+archive+specification","startedDateTime":"2012-03-23T01:22:06.092Z","time":10},{"request":{"method":"GET","url":"https://duckduckgo.com/assets/header_bg.v101.png","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Accept-Encoding","value":"gzip,deflate,sdch"},{"name":"Accept-Language","value":"en-US,en;q=0.8"},{"name":"Connection","value":"keep-alive"},{"name":"Pragma","value":"no-cache"},{"name":"Accept-Charset","value":"ISO-8859-1,utf-8;q=0.7,*;q=0.3"},{"name":"Host","value":"duckduckgo.com"},{"name":"User-Agent","value":"Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/535.7 (KHTML, like Gecko) Chrome/16.0.912.63 Safari/535.7"},{"name":"Accept","value":"*/*"},{"name":"Referer","value":"https://duckduckgo.com/?q=http+archive+specification"},{"name":"Cache-Control","value":"no-cache"}],"queryString":[],"headersSize":440,"bodySize":-1},"response":{"status":200,"statusText":"OK","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Date","value":"Fri, 23 Mar 2012 01:22:06 GMT"},{"name":"Connection","value":"keep-alive"},{"name":"Content-Length","value":"923"},{"name":"Last-Modified","value":"Wed, 01 Feb 2012 15:42:38 GMT"},{"name":"Server","value":"nginx"},{"name":"Content-Type","value":"image/png"},{"name":"Cache-Control","value":"max-age=31536000\npublic"},{"name":"Accept-Ranges","value":"bytes"},{"name":"Expires","value":"Sat, 23 Mar 2013 01:22:06 GMT"}],"headersSize":305,"redirectURL":"","bodySize":1045,"content":{"size":923,"mimeType":"image/png"}},"timings":{"blocked":0,"dns":-1,"connect":0,"send":0,"wait":11,"receive":-1,"ssl":-1},"cache":{},"pageref":"https://duckduckgo.com/?q=http+archive+specification","startedDateTime":"2012-03-23T01:22:06.153Z","time":11},{"request":{"method":"GET","url":"https://duckduckgo.com/assets/logo_header.v101.png","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Accept-Encoding","value":"gzip,deflate,sdch"},{"name":"Accept-Language","value":"en-US,en;q=0.8"},{"name":"Connection","value":"keep-alive"},{"name":"Pragma","value":"no-cache"},{"name":"Accept-Charset","value":"ISO-8859-1,utf-8;q=0.7,*;q=0.3"},{"name":"Host","value":"duckduckgo.com"},{"name":"User-Agent","value":"Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/535.7 (KHTML, like Gecko) Chrome/16.0.912.63 Safari/535.7"},{"name":"Accept","value":"*/*"},{"name":"Referer","value":"https://duckduckgo.com/?q=http+archive+specification"},{"name":"Cache-Control","value":"no-cache"}],"queryString":[],"headersSize":442,"bodySize":-1},"response":{"status":200,"statusText":"OK","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Date","value":"Fri, 23 Mar 2012 01:22:06 GMT"},{"name":"Connection","value":"keep-alive"},{"name":"Content-Length","value":"1978"},{"name":"Last-Modified","value":"Wed, 01 Feb 2012 15:42:43 GMT"},{"name":"Server","value":"nginx"},{"name":"Content-Type","value":"image/png"},{"name":"Cache-Control","value":"max-age=31536000\npublic"},{"name":"Accept-Ranges","value":"bytes"},{"name":"Expires","value":"Sat, 23 Mar 2013 01:22:06 GMT"}],"headersSize":306,"redirectURL":"","bodySize":2085,"content":{"size":1978,"mimeType":"image/png"}},"timings":{"blocked":0,"dns":-1,"connect":0,"send":0,"wait":12,"receive":-1,"ssl":-1},"cache":{},"pageref":"https://duckduckgo.com/?q=http+archive+specification","startedDateTime":"2012-03-23T01:22:06.154Z","time":12},{"request":{"method":"GET","url":"https://duckduckgo.com/assets/search_dropdown.v102.png","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Accept-Encoding","value":"gzip,deflate,sdch"},{"name":"Accept-Language","value":"en-US,en;q=0.8"},{"name":"Connection","value":"keep-alive"},{"name":"Pragma","value":"no-cache"},{"name":"Accept-Charset","value":"ISO-8859-1,utf-8;q=0.7,*;q=0.3"},{"name":"Host","value":"duckduckgo.com"},{"name":"User-Agent","value":"Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/535.7 (KHTML, like Gecko) Chrome/16.0.912.63 Safari/535.7"},{"name":"Accept","value":"*/*"},{"name":"Referer","value":"https://duckduckgo.com/?q=http+archive+specification"},{"name":"Cache-Control","value":"no-cache"}],"queryString":[],"headersSize":446,"bodySize":-1},"response":{"status":200,"statusText":"OK","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Date","value":"Fri, 23 Mar 2012 01:22:06 GMT"},{"name":"Connection","value":"keep-alive"},{"name":"Content-Length","value":"3221"},{"name":"Last-Modified","value":"Wed, 01 Feb 2012 15:42:38 GMT"},{"name":"Server","value":"nginx"},{"name":"Content-Type","value":"image/png"},{"name":"Cache-Control","value":"max-age=31536000\npublic"},{"name":"Accept-Ranges","value":"bytes"},{"name":"Expires","value":"Sat, 23 Mar 2013 01:22:06 GMT"}],"headersSize":306,"redirectURL":"","bodySize":2677,"content":{"size":3221,"mimeType":"image/png"}},"timings":{"blocked":0,"dns":-1,"connect":13,"send":0,"wait":11,"receive":-1,"ssl":-1},"cache":{},"pageref":"https://duckduckgo.com/?q=http+archive+specification","startedDateTime":"2012-03-23T01:22:06.154Z","time":24},{"request":{"method":"GET","url":"https://duckduckgo.com/assets/icon_xon.v101.png","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Accept-Encoding","value":"gzip,deflate,sdch"},{"name":"Accept-Language","value":"en-US,en;q=0.8"},{"name":"Connection","value":"keep-alive"},{"name":"Pragma","value":"no-cache"},{"name":"Accept-Charset","value":"ISO-8859-1,utf-8;q=0.7,*;q=0.3"},{"name":"Host","value":"duckduckgo.com"},{"name":"User-Agent","value":"Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/535.7 (KHTML, like Gecko) Chrome/16.0.912.63 Safari/535.7"},{"name":"Accept","value":"*/*"},{"name":"Referer","value":"https://duckduckgo.com/?q=http+archive+specification"},{"name":"Cache-Control","value":"no-cache"}],"queryString":[],"headersSize":439,"bodySize":-1},"response":{"status":200,"statusText":"OK","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Date","value":"Fri, 23 Mar 2012 01:22:06 GMT"},{"name":"Connection","value":"keep-alive"},{"name":"Content-Length","value":"542"},{"name":"Last-Modified","value":"Fri, 20 Jan 2012 19:50:32 GMT"},{"name":"Server","value":"nginx"},{"name":"Content-Type","value":"image/png"},{"name":"Cache-Control","value":"max-age=31536000\npublic"},{"name":"Accept-Ranges","value":"bytes"},{"name":"Expires","value":"Sat, 23 Mar 2013 01:22:06 GMT"}],"headersSize":305,"redirectURL":"","bodySize":533,"content":{"size":542,"mimeType":"image/png"}},"timings":{"blocked":0,"dns":-1,"connect":13,"send":0,"wait":12,"receive":-1,"ssl":-1},"cache":{},"pageref":"https://duckduckgo.com/?q=http+archive+specification","startedDateTime":"2012-03-23T01:22:06.154Z","time":25},{"request":{"method":"GET","url":"https://duckduckgo.com/assets/header_button_bg.v101.png","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Accept-Encoding","value":"gzip,deflate,sdch"},{"name":"Accept-Language","value":"en-US,en;q=0.8"},{"name":"Connection","value":"keep-alive"},{"name":"Pragma","value":"no-cache"},{"name":"Accept-Charset","value":"ISO-8859-1,utf-8;q=0.7,*;q=0.3"},{"name":"Host","value":"duckduckgo.com"},{"name":"User-Agent","value":"Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/535.7 (KHTML, like Gecko) Chrome/16.0.912.63 Safari/535.7"},{"name":"Accept","value":"*/*"},{"name":"Referer","value":"https://duckduckgo.com/?q=http+archive+specification"},{"name":"Cache-Control","value":"no-cache"}],"queryString":[],"headersSize":447,"bodySize":-1},"response":{"status":200,"statusText":"OK","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Date","value":"Fri, 23 Mar 2012 01:22:06 GMT"},{"name":"Connection","value":"keep-alive"},{"name":"Content-Length","value":"373"},{"name":"Last-Modified","value":"Fri, 13 Jan 2012 18:36:15 GMT"},{"name":"Server","value":"nginx"},{"name":"Content-Type","value":"image/png"},{"name":"Cache-Control","value":"max-age=31536000\npublic"},{"name":"Accept-Ranges","value":"bytes"},{"name":"Expires","value":"Sat, 23 Mar 2013 01:22:06 GMT"}],"headersSize":305,"redirectURL":"","bodySize":661,"content":{"size":373,"mimeType":"image/png"}},"timings":{"blocked":0,"dns":-1,"connect":22,"send":0,"wait":11,"receive":-1,"ssl":11},"cache":{},"pageref":"https://duckduckgo.com/?q=http+archive+specification","startedDateTime":"2012-03-23T01:22:06.155Z","time":44},{"request":{"method":"GET","url":"https://duckduckgo.com/assets/header_button_triangle.v101.png","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Accept-Encoding","value":"gzip,deflate,sdch"},{"name":"Accept-Language","value":"en-US,en;q=0.8"},{"name":"Connection","value":"keep-alive"},{"name":"Pragma","value":"no-cache"},{"name":"Accept-Charset","value":"ISO-8859-1,utf-8;q=0.7,*;q=0.3"},{"name":"Host","value":"duckduckgo.com"},{"name":"User-Agent","value":"Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/535.7 (KHTML, like Gecko) Chrome/16.0.912.63 Safari/535.7"},{"name":"Accept","value":"*/*"},{"name":"Referer","value":"https://duckduckgo.com/?q=http+archive+specification"},{"name":"Cache-Control","value":"no-cache"}],"queryString":[],"headersSize":453,"bodySize":-1},"response":{"status":200,"statusText":"OK","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Date","value":"Fri, 23 Mar 2012 01:22:06 GMT"},{"name":"Connection","value":"keep-alive"},{"name":"Content-Length","value":"300"},{"name":"Last-Modified","value":"Wed, 01 Feb 2012 15:42:38 GMT"},{"name":"Server","value":"nginx"},{"name":"Content-Type","value":"image/png"},{"name":"Cache-Control","value":"max-age=31536000\npublic"},{"name":"Accept-Ranges","value":"bytes"},{"name":"Expires","value":"Sat, 23 Mar 2013 01:22:06 GMT"}],"headersSize":305,"redirectURL":"","bodySize":549,"content":{"size":300,"mimeType":"image/png"}},"timings":{"blocked":0,"dns":-1,"connect":23,"send":0,"wait":11,"receive":-1,"ssl":12},"cache":{},"pageref":"https://duckduckgo.com/?q=http+archive+specification","startedDateTime":"2012-03-23T01:22:06.155Z","time":46},{"request":{"method":"GET","url":"https://duckduckgo.com/assets/icon_feedback.v101.png","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Accept-Encoding","value":"gzip,deflate,sdch"},{"name":"Accept-Language","value":"en-US,en;q=0.8"},{"name":"Connection","value":"keep-alive"},{"name":"Pragma","value":"no-cache"},{"name":"Accept-Charset","value":"ISO-8859-1,utf-8;q=0.7,*;q=0.3"},{"name":"Host","value":"duckduckgo.com"},{"name":"User-Agent","value":"Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/535.7 (KHTML, like Gecko) Chrome/16.0.912.63 Safari/535.7"},{"name":"Accept","value":"*/*"},{"name":"Referer","value":"https://duckduckgo.com/?q=http+archive+specification"},{"name":"Cache-Control","value":"no-cache"}],"queryString":[],"headersSize":444,"bodySize":-1},"response":{"status":200,"statusText":"OK","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Date","value":"Fri, 23 Mar 2012 01:22:06 GMT"},{"name":"Connection","value":"keep-alive"},{"name":"Content-Length","value":"3393"},{"name":"Last-Modified","value":"Wed, 01 Feb 2012 15:42:38 GMT"},{"name":"Server","value":"nginx"},{"name":"Content-Type","value":"image/png"},{"name":"Cache-Control","value":"max-age=31536000\npublic"},{"name":"Accept-Ranges","value":"bytes"},{"name":"Expires","value":"Sat, 23 Mar 2013 01:22:06 GMT"}],"headersSize":306,"redirectURL":"","bodySize":3701,"content":{"size":3393,"mimeType":"image/png"}},"timings":{"blocked":0,"dns":-1,"connect":23,"send":0,"wait":11,"receive":-1,"ssl":13},"cache":{},"pageref":"https://duckduckgo.com/?q=http+archive+specification","startedDateTime":"2012-03-23T01:22:06.156Z","time":47},{"request":{"method":"GET","url":"https://duckduckgo.com/a.js?q=http%20archive%20specification&p=1","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Accept-Encoding","value":"gzip,deflate,sdch"},{"name":"Accept-Language","value":"en-US,en;q=0.8"},{"name":"Connection","value":"keep-alive"},{"name":"Pragma","value":"no-cache"},{"name":"Accept-Charset","value":"ISO-8859-1,utf-8;q=0.7,*;q=0.3"},{"name":"Host","value":"duckduckgo.com"},{"name":"User-Agent","value":"Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/535.7 (KHTML, like Gecko) Chrome/16.0.912.63 Safari/535.7"},{"name":"Accept","value":"*/*"},{"name":"Referer","value":"https://duckduckgo.com/?q=http+archive+specification"},{"name":"Cache-Control","value":"no-cache"}],"queryString":[],"headersSize":456,"bodySize":-1},"response":{"status":200,"statusText":"OK","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Date","value":"Fri, 23 Mar 2012 01:22:06 GMT"},{"name":"Content-Encoding","value":"gzip"},{"name":"Transfer-Encoding","value":"chunked"},{"name":"Connection","value":"keep-alive"},{"name":"Server","value":"nginx"},{"name":"Content-Type","value":"application/x-javascript; charset=UTF-8"},{"name":"Cache-Control","value":"no-cache"},{"name":"Expires","value":"Fri, 23 Mar 2012 01:22:05 GMT"}],"headersSize":267,"redirectURL":"","bodySize":0,"content":{"size":0,"mimeType":"application/x-javascript"}},"timings":{"blocked":0,"dns":-1,"connect":0,"send":0,"wait":152,"receive":-1,"ssl":-1},"cache":{},"pageref":"https://duckduckgo.com/?q=http+archive+specification","startedDateTime":"2012-03-23T01:22:06.192Z","time":152},{"request":{"method":"GET","url":"https://duckduckgo.com/d.js?q=http%20archive%20specification&l=us-en&p=1&s=0","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Accept-Encoding","value":"gzip,deflate,sdch"},{"name":"Accept-Language","value":"en-US,en;q=0.8"},{"name":"Connection","value":"keep-alive"},{"name":"Pragma","value":"no-cache"},{"name":"Accept-Charset","value":"ISO-8859-1,utf-8;q=0.7,*;q=0.3"},{"name":"Host","value":"duckduckgo.com"},{"name":"User-Agent","value":"Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/535.7 (KHTML, like Gecko) Chrome/16.0.912.63 Safari/535.7"},{"name":"Accept","value":"*/*"},{"name":"Referer","value":"https://duckduckgo.com/?q=http+archive+specification"},{"name":"Cache-Control","value":"no-cache"}],"queryString":[],"headersSize":468,"bodySize":-1},"response":{"status":200,"statusText":"OK","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Date","value":"Fri, 23 Mar 2012 01:22:07 GMT"},{"name":"Content-Encoding","value":"gzip"},{"name":"Transfer-Encoding","value":"chunked"},{"name":"Connection","value":"keep-alive"},{"name":"Server","value":"nginx"},{"name":"Content-Type","value":"application/x-javascript; charset=UTF-8"},{"name":"Cache-Control","value":"no-cache"},{"name":"Expires","value":"Fri, 23 Mar 2012 01:22:06 GMT"}],"headersSize":267,"redirectURL":"","bodySize":5621,"content":{"size":16034,"mimeType":"application/x-javascript"}},"timings":{"blocked":0,"dns":-1,"connect":0,"send":0,"wait":991,"receive":1,"ssl":-1},"cache":{},"pageref":"https://duckduckgo.com/?q=http+archive+specification","startedDateTime":"2012-03-23T01:22:06.193Z","time":992},{"request":{"method":"GET","url":"https://duckduckgo.com/s.js?q=http%20archive%20specification","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Accept-Encoding","value":"gzip,deflate,sdch"},{"name":"Accept-Language","value":"en-US,en;q=0.8"},{"name":"Connection","value":"keep-alive"},{"name":"Pragma","value":"no-cache"},{"name":"Accept-Charset","value":"ISO-8859-1,utf-8;q=0.7,*;q=0.3"},{"name":"Host","value":"duckduckgo.com"},{"name":"User-Agent","value":"Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/535.7 (KHTML, like Gecko) Chrome/16.0.912.63 Safari/535.7"},{"name":"Accept","value":"*/*"},{"name":"Referer","value":"https://duckduckgo.com/?q=http+archive+specification"},{"name":"Cache-Control","value":"no-cache"}],"queryString":[],"headersSize":452,"bodySize":-1},"response":{"status":200,"statusText":"OK","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Date","value":"Fri, 23 Mar 2012 01:22:06 GMT"},{"name":"Content-Encoding","value":"gzip"},{"name":"Transfer-Encoding","value":"chunked"},{"name":"Connection","value":"keep-alive"},{"name":"Server","value":"nginx"},{"name":"Content-Type","value":"application/x-javascript; charset=UTF-8"},{"name":"Cache-Control","value":"no-cache"},{"name":"Expires","value":"Fri, 23 Mar 2012 01:22:05 GMT"}],"headersSize":267,"redirectURL":"","bodySize":165,"content":{"size":1,"mimeType":"application/x-javascript"}},"timings":{"blocked":0,"dns":-1,"connect":0,"send":0,"wait":180,"receive":-1,"ssl":-1},"cache":{},"pageref":"https://duckduckgo.com/?q=http+archive+specification","startedDateTime":"2012-03-23T01:22:06.193Z","time":180},{"request":{"method":"GET","url":"https://i.duckduckgo.com/i/1.ico","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Accept-Encoding","value":"gzip,deflate,sdch"},{"name":"Accept-Language","value":"en-US,en;q=0.8"},{"name":"Connection","value":"keep-alive"},{"name":"Pragma","value":"no-cache"},{"name":"Accept-Charset","value":"ISO-8859-1,utf-8;q=0.7,*;q=0.3"},{"name":"Host","value":"i.duckduckgo.com"},{"name":"User-Agent","value":"Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/535.7 (KHTML, like Gecko) Chrome/16.0.912.63 Safari/535.7"},{"name":"Accept","value":"*/*"},{"name":"Referer","value":"https://duckduckgo.com/?q=http+archive+specification"},{"name":"Cache-Control","value":"no-cache"}],"queryString":[],"headersSize":424,"bodySize":-1},"response":{"status":200,"statusText":"OK","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Date","value":"Fri, 23 Mar 2012 01:22:07 GMT"},{"name":"X-Cache","value":"Hit from DS"},{"name":"Connection","value":"keep-alive"},{"name":"Content-Length","value":"43"},{"name":"Server","value":"nginx"},{"name":"Content-Type","value":"image/x-icon"},{"name":"Access-Control-Allow-Origin","value":"*"},{"name":"Cache-Control","value":"max-age=2592000"},{"name":"Expires","value":"Sun, 22 Apr 2012 01:22:07 GMT"}],"headersSize":269,"redirectURL":"","bodySize":527,"content":{"size":43,"mimeType":"image/x-icon"}},"timings":{"blocked":0,"dns":-1,"connect":93,"send":0,"wait":19,"receive":-1,"ssl":17},"cache":{},"pageref":"https://duckduckgo.com/?q=http+archive+specification","startedDateTime":"2012-03-23T01:22:07.192Z","time":129},{"request":{"method":"GET","url":"https://duckduckgo.com/assets/icon_triangle.v101.png","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Accept-Encoding","value":"gzip,deflate,sdch"},{"name":"Accept-Language","value":"en-US,en;q=0.8"},{"name":"Connection","value":"keep-alive"},{"name":"Pragma","value":"no-cache"},{"name":"Accept-Charset","value":"ISO-8859-1,utf-8;q=0.7,*;q=0.3"},{"name":"Host","value":"duckduckgo.com"},{"name":"User-Agent","value":"Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/535.7 (KHTML, like Gecko) Chrome/16.0.912.63 Safari/535.7"},{"name":"Accept","value":"*/*"},{"name":"Referer","value":"https://duckduckgo.com/?q=http+archive+specification"},{"name":"Cache-Control","value":"no-cache"}],"queryString":[],"headersSize":444,"bodySize":-1},"response":{"status":200,"statusText":"OK","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Date","value":"Fri, 23 Mar 2012 01:22:07 GMT"},{"name":"Connection","value":"keep-alive"},{"name":"Content-Length","value":"271"},{"name":"Last-Modified","value":"Fri, 13 Jan 2012 18:36:15 GMT"},{"name":"Server","value":"nginx"},{"name":"Content-Type","value":"image/png"},{"name":"Cache-Control","value":"max-age=31536000\npublic"},{"name":"Accept-Ranges","value":"bytes"},{"name":"Expires","value":"Sat, 23 Mar 2013 01:22:07 GMT"}],"headersSize":305,"redirectURL":"","bodySize":293,"content":{"size":271,"mimeType":"image/png"}},"timings":{"blocked":0,"dns":-1,"connect":0,"send":0,"wait":10,"receive":-1,"ssl":-1},"cache":{},"pageref":"https://duckduckgo.com/?q=http+archive+specification","startedDateTime":"2012-03-23T01:22:07.195Z","time":10},{"request":{"method":"GET","url":"https://i.duckduckgo.com/i/www.groups.google.com.ico","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Accept-Encoding","value":"gzip,deflate,sdch"},{"name":"Accept-Language","value":"en-US,en;q=0.8"},{"name":"Connection","value":"keep-alive"},{"name":"Pragma","value":"no-cache"},{"name":"Accept-Charset","value":"ISO-8859-1,utf-8;q=0.7,*;q=0.3"},{"name":"Host","value":"i.duckduckgo.com"},{"name":"User-Agent","value":"Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/535.7 (KHTML, like Gecko) Chrome/16.0.912.63 Safari/535.7"},{"name":"Accept","value":"*/*"},{"name":"Referer","value":"https://duckduckgo.com/?q=http+archive+specification"},{"name":"Cache-Control","value":"no-cache"}],"queryString":[],"headersSize":444,"bodySize":-1},"response":{"status":200,"statusText":"OK","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Date","value":"Fri, 23 Mar 2012 01:22:07 GMT"},{"name":"Age","value":"21795"},{"name":"X-Cache","value":"Hit from MC"},{"name":"Connection","value":"keep-alive"},{"name":"Content-Length","value":"1150"},{"name":"Server","value":"nginx"},{"name":"Content-Type","value":"image/x-icon"},{"name":"Access-Control-Allow-Origin","value":"*"},{"name":"Cache-Control","value":"max-age=2592000"},{"name":"Expires","value":"Sun, 22 Apr 2012 01:22:07 GMT"}],"headersSize":283,"redirectURL":"","bodySize":1391,"content":{"size":1150,"mimeType":"image/x-icon"}},"timings":{"blocked":0,"dns":-1,"connect":34,"send":0,"wait":41,"receive":-1,"ssl":16},"cache":{},"pageref":"https://duckduckgo.com/?q=http+archive+specification","startedDateTime":"2012-03-23T01:22:07.260Z","time":91},{"request":{"method":"GET","url":"https://i.duckduckgo.com/i/www.w3.org.ico","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Accept-Encoding","value":"gzip,deflate,sdch"},{"name":"Accept-Language","value":"en-US,en;q=0.8"},{"name":"Connection","value":"keep-alive"},{"name":"Pragma","value":"no-cache"},{"name":"Accept-Charset","value":"ISO-8859-1,utf-8;q=0.7,*;q=0.3"},{"name":"Host","value":"i.duckduckgo.com"},{"name":"User-Agent","value":"Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/535.7 (KHTML, like Gecko) Chrome/16.0.912.63 Safari/535.7"},{"name":"Accept","value":"*/*"},{"name":"Referer","value":"https://duckduckgo.com/?q=http+archive+specification"},{"name":"Cache-Control","value":"no-cache"}],"queryString":[],"headersSize":433,"bodySize":-1},"response":{"status":200,"statusText":"OK","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Date","value":"Fri, 23 Mar 2012 01:22:07 GMT"},{"name":"Age","value":"969"},{"name":"X-Cache","value":"Hit from MC"},{"name":"Connection","value":"keep-alive"},{"name":"Content-Length","value":"894"},{"name":"Server","value":"nginx"},{"name":"Content-Type","value":"image/x-icon"},{"name":"Access-Control-Allow-Origin","value":"*"},{"name":"Cache-Control","value":"max-age=2592000"},{"name":"Expires","value":"Sun, 22 Apr 2012 01:22:07 GMT"}],"headersSize":280,"redirectURL":"","bodySize":1295,"content":{"size":894,"mimeType":"image/x-icon"}},"timings":{"blocked":0,"dns":-1,"connect":34,"send":0,"wait":23,"receive":-1,"ssl":16},"cache":{},"pageref":"https://duckduckgo.com/?q=http+archive+specification","startedDateTime":"2012-03-23T01:22:07.261Z","time":73},{"request":{"method":"GET","url":"https://i.duckduckgo.com/i/www.softwareishard.com.ico","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Accept-Encoding","value":"gzip,deflate,sdch"},{"name":"Accept-Language","value":"en-US,en;q=0.8"},{"name":"Connection","value":"keep-alive"},{"name":"Pragma","value":"no-cache"},{"name":"Accept-Charset","value":"ISO-8859-1,utf-8;q=0.7,*;q=0.3"},{"name":"Host","value":"i.duckduckgo.com"},{"name":"User-Agent","value":"Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/535.7 (KHTML, like Gecko) Chrome/16.0.912.63 Safari/535.7"},{"name":"Accept","value":"*/*"},{"name":"Referer","value":"https://duckduckgo.com/?q=http+archive+specification"},{"name":"Cache-Control","value":"no-cache"}],"queryString":[],"headersSize":445,"bodySize":-1},"response":{"status":200,"statusText":"OK","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Date","value":"Fri, 23 Mar 2012 01:22:07 GMT"},{"name":"X-Cache","value":"Hit from DS"},{"name":"Connection","value":"keep-alive"},{"name":"Content-Length","value":"5430"},{"name":"Server","value":"nginx"},{"name":"Content-Type","value":"image/x-icon"},{"name":"Access-Control-Allow-Origin","value":"*"},{"name":"Cache-Control","value":"max-age=2592000"},{"name":"Expires","value":"Sun, 22 Apr 2012 01:22:07 GMT"}],"headersSize":271,"redirectURL":"","bodySize":3407,"content":{"size":5430,"mimeType":"image/x-icon"}},"timings":{"blocked":0,"dns":-1,"connect":34,"send":0,"wait":343,"receive":-1,"ssl":16},"cache":{},"pageref":"https://duckduckgo.com/?q=http+archive+specification","startedDateTime":"2012-03-23T01:22:07.261Z","time":393},{"request":{"method":"GET","url":"https://i.duckduckgo.com/i/www.stevesouders.com.ico","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Accept-Encoding","value":"gzip,deflate,sdch"},{"name":"Accept-Language","value":"en-US,en;q=0.8"},{"name":"Connection","value":"keep-alive"},{"name":"Pragma","value":"no-cache"},{"name":"Accept-Charset","value":"ISO-8859-1,utf-8;q=0.7,*;q=0.3"},{"name":"Host","value":"i.duckduckgo.com"},{"name":"User-Agent","value":"Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/535.7 (KHTML, like Gecko) Chrome/16.0.912.63 Safari/535.7"},{"name":"Accept","value":"*/*"},{"name":"Referer","value":"https://duckduckgo.com/?q=http+archive+specification"},{"name":"Cache-Control","value":"no-cache"}],"queryString":[],"headersSize":443,"bodySize":-1},"response":{"status":200,"statusText":"OK","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Date","value":"Fri, 23 Mar 2012 01:22:07 GMT"},{"name":"X-Cache","value":"Hit from MC"},{"name":"Connection","value":"keep-alive"},{"name":"Content-Length","value":"1406"},{"name":"Server","value":"nginx"},{"name":"Content-Type","value":"image/x-icon"},{"name":"Access-Control-Allow-Origin","value":"*"},{"name":"Cache-Control","value":"max-age=2592000"},{"name":"Expires","value":"Sun, 22 Apr 2012 01:22:07 GMT"}],"headersSize":271,"redirectURL":"","bodySize":799,"content":{"size":1406,"mimeType":"image/x-icon"}},"timings":{"blocked":0,"dns":-1,"connect":35,"send":0,"wait":153,"receive":-1,"ssl":18},"cache":{},"pageref":"https://duckduckgo.com/?q=http+archive+specification","startedDateTime":"2012-03-23T01:22:07.261Z","time":206},{"request":{"method":"GET","url":"https://i.duckduckgo.com/i/stackoverflow.com.ico","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Accept-Encoding","value":"gzip,deflate,sdch"},{"name":"Accept-Language","value":"en-US,en;q=0.8"},{"name":"Connection","value":"keep-alive"},{"name":"Pragma","value":"no-cache"},{"name":"Accept-Charset","value":"ISO-8859-1,utf-8;q=0.7,*;q=0.3"},{"name":"Host","value":"i.duckduckgo.com"},{"name":"User-Agent","value":"Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/535.7 (KHTML, like Gecko) Chrome/16.0.912.63 Safari/535.7"},{"name":"Accept","value":"*/*"},{"name":"Referer","value":"https://duckduckgo.com/?q=http+archive+specification"},{"name":"Cache-Control","value":"no-cache"}],"queryString":[],"headersSize":440,"bodySize":-1},"response":{"status":200,"statusText":"OK","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Date","value":"Fri, 23 Mar 2012 01:22:07 GMT"},{"name":"X-Cache","value":"Hit from MC"},{"name":"Connection","value":"keep-alive"},{"name":"Content-Length","value":"1150"},{"name":"Server","value":"nginx"},{"name":"Content-Type","value":"image/x-icon"},{"name":"Access-Control-Allow-Origin","value":"*"},{"name":"Cache-Control","value":"max-age=2592000"},{"name":"Expires","value":"Sun, 22 Apr 2012 01:22:07 GMT"}],"headersSize":271,"redirectURL":"","bodySize":927,"content":{"size":1150,"mimeType":"image/x-icon"}},"timings":{"blocked":0,"dns":-1,"connect":35,"send":0,"wait":38,"receive":-1,"ssl":18},"cache":{},"pageref":"https://duckduckgo.com/?q=http+archive+specification","startedDateTime":"2012-03-23T01:22:07.262Z","time":91},{"request":{"method":"GET","url":"https://i.duckduckgo.com/i/blogs.msdn.com.ico","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Accept-Encoding","value":"gzip,deflate,sdch"},{"name":"Accept-Language","value":"en-US,en;q=0.8"},{"name":"Connection","value":"keep-alive"},{"name":"Pragma","value":"no-cache"},{"name":"Accept-Charset","value":"ISO-8859-1,utf-8;q=0.7,*;q=0.3"},{"name":"Host","value":"i.duckduckgo.com"},{"name":"User-Agent","value":"Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/535.7 (KHTML, like Gecko) Chrome/16.0.912.63 Safari/535.7"},{"name":"Accept","value":"*/*"},{"name":"Referer","value":"https://duckduckgo.com/?q=http+archive+specification"},{"name":"Cache-Control","value":"no-cache"}],"queryString":[],"headersSize":437,"bodySize":-1},"response":{"status":200,"statusText":"OK","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Date","value":"Fri, 23 Mar 2012 01:22:07 GMT"},{"name":"X-Cache","value":"Hit from MC"},{"name":"Connection","value":"keep-alive"},{"name":"Content-Length","value":"1150"},{"name":"Server","value":"nginx"},{"name":"Content-Type","value":"image/x-icon"},{"name":"Access-Control-Allow-Origin","value":"*"},{"name":"Cache-Control","value":"max-age=2592000"},{"name":"Expires","value":"Sun, 22 Apr 2012 01:22:07 GMT"}],"headersSize":271,"redirectURL":"","bodySize":645,"content":{"size":1150,"mimeType":"image/x-icon"}},"timings":{"blocked":0,"dns":-1,"connect":42,"send":0,"wait":38,"receive":-1,"ssl":-1},"cache":{},"pageref":"https://duckduckgo.com/?q=http+archive+specification","startedDateTime":"2012-03-23T01:22:07.262Z","time":80},{"request":{"method":"GET","url":"https://i.duckduckgo.com/i/www.fotoware.com.ico","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Accept-Encoding","value":"gzip,deflate,sdch"},{"name":"Accept-Language","value":"en-US,en;q=0.8"},{"name":"Connection","value":"keep-alive"},{"name":"Pragma","value":"no-cache"},{"name":"Accept-Charset","value":"ISO-8859-1,utf-8;q=0.7,*;q=0.3"},{"name":"Host","value":"i.duckduckgo.com"},{"name":"User-Agent","value":"Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/535.7 (KHTML, like Gecko) Chrome/16.0.912.63 Safari/535.7"},{"name":"Accept","value":"*/*"},{"name":"Referer","value":"https://duckduckgo.com/?q=http+archive+specification"},{"name":"Cache-Control","value":"no-cache"}],"queryString":[],"headersSize":439,"bodySize":-1},"response":{"status":200,"statusText":"OK","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Date","value":"Fri, 23 Mar 2012 01:22:07 GMT"},{"name":"X-Cache","value":"Hit from MC"},{"name":"Connection","value":"keep-alive"},{"name":"Content-Length","value":"15086"},{"name":"Server","value":"nginx"},{"name":"Content-Type","value":"image/x-icon"},{"name":"Access-Control-Allow-Origin","value":"*"},{"name":"Cache-Control","value":"max-age=2592000"},{"name":"Expires","value":"Sun, 22 Apr 2012 01:22:07 GMT"}],"headersSize":272,"redirectURL":"","bodySize":9381,"content":{"size":15086,"mimeType":"image/x-icon"}},"timings":{"blocked":0,"dns":-1,"connect":57,"send":1,"wait":312,"receive":-1,"ssl":-1},"cache":{},"pageref":"https://duckduckgo.com/?q=http+archive+specification","startedDateTime":"2012-03-23T01:22:07.263Z","time":370},{"request":{"method":"GET","url":"https://i.duckduckgo.com/i/www.adobe.com.ico","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Accept-Encoding","value":"gzip,deflate,sdch"},{"name":"Accept-Language","value":"en-US,en;q=0.8"},{"name":"Connection","value":"keep-alive"},{"name":"Pragma","value":"no-cache"},{"name":"Accept-Charset","value":"ISO-8859-1,utf-8;q=0.7,*;q=0.3"},{"name":"Host","value":"i.duckduckgo.com"},{"name":"User-Agent","value":"Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/535.7 (KHTML, like Gecko) Chrome/16.0.912.63 Safari/535.7"},{"name":"Accept","value":"*/*"},{"name":"Referer","value":"https://duckduckgo.com/?q=http+archive+specification"},{"name":"Cache-Control","value":"no-cache"}],"queryString":[],"headersSize":436,"bodySize":-1},"response":{"status":200,"statusText":"OK","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Date","value":"Fri, 23 Mar 2012 01:22:07 GMT"},{"name":"X-Cache","value":"Hit from MC"},{"name":"Connection","value":"keep-alive"},{"name":"Content-Length","value":"1150"},{"name":"Server","value":"nginx"},{"name":"Content-Type","value":"image/x-icon"},{"name":"Access-Control-Allow-Origin","value":"*"},{"name":"Cache-Control","value":"max-age=2592000"},{"name":"Expires","value":"Sun, 22 Apr 2012 01:22:07 GMT"}],"headersSize":271,"redirectURL":"","bodySize":357,"content":{"size":1150,"mimeType":"image/x-icon"}},"timings":{"blocked":0,"dns":-1,"connect":72,"send":0,"wait":10,"receive":-1,"ssl":-1},"cache":{},"pageref":"https://duckduckgo.com/?q=http+archive+specification","startedDateTime":"2012-03-23T01:22:07.263Z","time":82},{"request":{"method":"GET","url":"https://i.duckduckgo.com/i/ftp.ics.uci.edu.ico","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Accept-Encoding","value":"gzip,deflate,sdch"},{"name":"Accept-Language","value":"en-US,en;q=0.8"},{"name":"Connection","value":"keep-alive"},{"name":"Pragma","value":"no-cache"},{"name":"Accept-Charset","value":"ISO-8859-1,utf-8;q=0.7,*;q=0.3"},{"name":"Host","value":"i.duckduckgo.com"},{"name":"User-Agent","value":"Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/535.7 (KHTML, like Gecko) Chrome/16.0.912.63 Safari/535.7"},{"name":"Accept","value":"*/*"},{"name":"Referer","value":"https://duckduckgo.com/?q=http+archive+specification"},{"name":"Cache-Control","value":"no-cache"}],"queryString":[],"headersSize":438,"bodySize":-1},"response":{"status":200,"statusText":"OK","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Date","value":"Fri, 23 Mar 2012 01:22:07 GMT"},{"name":"X-Cache","value":"Hit from DS"},{"name":"Connection","value":"keep-alive"},{"name":"Content-Length","value":"43"},{"name":"Server","value":"nginx"},{"name":"Content-Type","value":"image/x-icon"},{"name":"Access-Control-Allow-Origin","value":"*"},{"name":"Cache-Control","value":"max-age=2592000"},{"name":"Expires","value":"Sun, 22 Apr 2012 01:22:07 GMT"}],"headersSize":269,"redirectURL":"","bodySize":85,"content":{"size":43,"mimeType":"image/x-icon"}},"timings":{"blocked":0,"dns":-1,"connect":73,"send":0,"wait":287,"receive":-1,"ssl":-1},"cache":{},"pageref":"https://duckduckgo.com/?q=http+archive+specification","startedDateTime":"2012-03-23T01:22:07.263Z","time":360},{"request":{"method":"GET","url":"https://i.duckduckgo.com/i/en.wikipedia.org.ico","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Accept-Encoding","value":"gzip,deflate,sdch"},{"name":"Accept-Language","value":"en-US,en;q=0.8"},{"name":"Connection","value":"keep-alive"},{"name":"Pragma","value":"no-cache"},{"name":"Accept-Charset","value":"ISO-8859-1,utf-8;q=0.7,*;q=0.3"},{"name":"Host","value":"i.duckduckgo.com"},{"name":"User-Agent","value":"Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/535.7 (KHTML, like Gecko) Chrome/16.0.912.63 Safari/535.7"},{"name":"Accept","value":"*/*"},{"name":"Referer","value":"https://duckduckgo.com/?q=http+archive+specification"},{"name":"Cache-Control","value":"no-cache"}],"queryString":[],"headersSize":439,"bodySize":-1},"response":{"status":200,"statusText":"OK","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Date","value":"Fri, 23 Mar 2012 01:22:07 GMT"},{"name":"X-Cache","value":"Hit from MC"},{"name":"Connection","value":"keep-alive"},{"name":"Content-Length","value":"318"},{"name":"Server","value":"nginx"},{"name":"Content-Type","value":"image/x-icon"},{"name":"Access-Control-Allow-Origin","value":"*"},{"name":"Cache-Control","value":"max-age=2592000"},{"name":"Expires","value":"Sun, 22 Apr 2012 01:22:07 GMT"}],"headersSize":270,"redirectURL":"","bodySize":229,"content":{"size":318,"mimeType":"image/x-icon"}},"timings":{"blocked":0,"dns":-1,"connect":79,"send":0,"wait":11,"receive":-1,"ssl":-1},"cache":{},"pageref":"https://duckduckgo.com/?q=http+archive+specification","startedDateTime":"2012-03-23T01:22:07.264Z","time":90},{"request":{"method":"GET","url":"https://i.duckduckgo.com/i/www.tiffinmotorhomes.com.ico","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Accept-Encoding","value":"gzip,deflate,sdch"},{"name":"Accept-Language","value":"en-US,en;q=0.8"},{"name":"Connection","value":"keep-alive"},{"name":"Pragma","value":"no-cache"},{"name":"Accept-Charset","value":"ISO-8859-1,utf-8;q=0.7,*;q=0.3"},{"name":"Host","value":"i.duckduckgo.com"},{"name":"User-Agent","value":"Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/535.7 (KHTML, like Gecko) Chrome/16.0.912.63 Safari/535.7"},{"name":"Accept","value":"*/*"},{"name":"Referer","value":"https://duckduckgo.com/?q=http+archive+specification"},{"name":"Cache-Control","value":"no-cache"}],"queryString":[],"headersSize":447,"bodySize":-1},"response":{"status":200,"statusText":"OK","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Date","value":"Fri, 23 Mar 2012 01:22:07 GMT"},{"name":"X-Cache","value":"Hit from MC"},{"name":"Connection","value":"keep-alive"},{"name":"Content-Length","value":"1406"},{"name":"Server","value":"nginx"},{"name":"Content-Type","value":"image/x-icon"},{"name":"Access-Control-Allow-Origin","value":"*"},{"name":"Cache-Control","value":"max-age=2592000"},{"name":"Expires","value":"Sun, 22 Apr 2012 01:22:07 GMT"}],"headersSize":271,"redirectURL":"","bodySize":453,"content":{"size":1406,"mimeType":"image/x-icon"}},"timings":{"blocked":0,"dns":-1,"connect":82,"send":0,"wait":107,"receive":-1,"ssl":-1},"cache":{},"pageref":"https://duckduckgo.com/?q=http+archive+specification","startedDateTime":"2012-03-23T01:22:07.264Z","time":189},{"request":{"method":"GET","url":"https://i.duckduckgo.com/i/www.datasheetarchive.com.ico","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Accept-Encoding","value":"gzip,deflate,sdch"},{"name":"Accept-Language","value":"en-US,en;q=0.8"},{"name":"Connection","value":"keep-alive"},{"name":"Pragma","value":"no-cache"},{"name":"Accept-Charset","value":"ISO-8859-1,utf-8;q=0.7,*;q=0.3"},{"name":"Host","value":"i.duckduckgo.com"},{"name":"User-Agent","value":"Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/535.7 (KHTML, like Gecko) Chrome/16.0.912.63 Safari/535.7"},{"name":"Accept","value":"*/*"},{"name":"Referer","value":"https://duckduckgo.com/?q=http+archive+specification"},{"name":"Cache-Control","value":"no-cache"}],"queryString":[],"headersSize":447,"bodySize":-1},"response":{"status":200,"statusText":"OK","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Date","value":"Fri, 23 Mar 2012 01:22:07 GMT"},{"name":"Age","value":"39576"},{"name":"X-Cache","value":"Hit from MC"},{"name":"Connection","value":"keep-alive"},{"name":"Content-Length","value":"894"},{"name":"Server","value":"nginx"},{"name":"Content-Type","value":"image/x-icon"},{"name":"Access-Control-Allow-Origin","value":"*"},{"name":"Cache-Control","value":"max-age=2592000"},{"name":"Expires","value":"Sun, 22 Apr 2012 01:22:07 GMT"}],"headersSize":282,"redirectURL":"","bodySize":853,"content":{"size":894,"mimeType":"image/x-icon"}},"timings":{"blocked":0,"dns":-1,"connect":90,"send":0,"wait":10,"receive":-1,"ssl":-1},"cache":{},"pageref":"https://duckduckgo.com/?q=http+archive+specification","startedDateTime":"2012-03-23T01:22:07.264Z","time":100},{"request":{"method":"GET","url":"https://i.duckduckgo.com/i/www.archives.gov.ico","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Accept-Encoding","value":"gzip,deflate,sdch"},{"name":"Accept-Language","value":"en-US,en;q=0.8"},{"name":"Connection","value":"keep-alive"},{"name":"Pragma","value":"no-cache"},{"name":"Accept-Charset","value":"ISO-8859-1,utf-8;q=0.7,*;q=0.3"},{"name":"Host","value":"i.duckduckgo.com"},{"name":"User-Agent","value":"Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/535.7 (KHTML, like Gecko) Chrome/16.0.912.63 Safari/535.7"},{"name":"Accept","value":"*/*"},{"name":"Referer","value":"https://duckduckgo.com/?q=http+archive+specification"},{"name":"Cache-Control","value":"no-cache"}],"queryString":[],"headersSize":439,"bodySize":-1},"response":{"status":200,"statusText":"OK","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Date","value":"Fri, 23 Mar 2012 01:22:07 GMT"},{"name":"Age","value":"100116"},{"name":"X-Cache","value":"Hit from MC"},{"name":"Connection","value":"keep-alive"},{"name":"Content-Length","value":"1150"},{"name":"Server","value":"nginx"},{"name":"Content-Type","value":"image/x-icon"},{"name":"Access-Control-Allow-Origin","value":"*"},{"name":"Cache-Control","value":"max-age=2592000"},{"name":"Expires","value":"Sun, 22 Apr 2012 01:22:07 GMT"}],"headersSize":284,"redirectURL":"","bodySize":341,"content":{"size":1150,"mimeType":"image/x-icon"}},"timings":{"blocked":0,"dns":-1,"connect":100,"send":0,"wait":30,"receive":-1,"ssl":-1},"cache":{},"pageref":"https://duckduckgo.com/?q=http+archive+specification","startedDateTime":"2012-03-23T01:22:07.264Z","time":130},{"request":{"method":"GET","url":"https://i.duckduckgo.com/i/imaging.nikon.com.ico","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Accept-Encoding","value":"gzip,deflate,sdch"},{"name":"Accept-Language","value":"en-US,en;q=0.8"},{"name":"Connection","value":"keep-alive"},{"name":"Pragma","value":"no-cache"},{"name":"Accept-Charset","value":"ISO-8859-1,utf-8;q=0.7,*;q=0.3"},{"name":"Host","value":"i.duckduckgo.com"},{"name":"User-Agent","value":"Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/535.7 (KHTML, like Gecko) Chrome/16.0.912.63 Safari/535.7"},{"name":"Accept","value":"*/*"},{"name":"Referer","value":"https://duckduckgo.com/?q=http+archive+specification"},{"name":"Cache-Control","value":"no-cache"}],"queryString":[],"headersSize":440,"bodySize":-1},"response":{"status":200,"statusText":"OK","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Date","value":"Fri, 23 Mar 2012 01:22:07 GMT"},{"name":"Age","value":"1225"},{"name":"X-Cache","value":"Hit from MC"},{"name":"Connection","value":"keep-alive"},{"name":"Content-Length","value":"3638"},{"name":"Server","value":"nginx"},{"name":"Content-Type","value":"image/x-icon"},{"name":"Access-Control-Allow-Origin","value":"*"},{"name":"Cache-Control","value":"max-age=2592000"},{"name":"Expires","value":"Sun, 22 Apr 2012 01:22:07 GMT"}],"headersSize":282,"redirectURL":"","bodySize":2357,"content":{"size":3638,"mimeType":"image/x-icon"}},"timings":{"blocked":0,"dns":-1,"connect":130,"send":0,"wait":30,"receive":-1,"ssl":-1},"cache":{},"pageref":"https://duckduckgo.com/?q=http+archive+specification","startedDateTime":"2012-03-23T01:22:07.265Z","time":160},{"request":{"method":"GET","url":"https://i.duckduckgo.com/i/neworleanspubliclibrary.org.ico","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Accept-Encoding","value":"gzip,deflate,sdch"},{"name":"Accept-Language","value":"en-US,en;q=0.8"},{"name":"Connection","value":"keep-alive"},{"name":"Pragma","value":"no-cache"},{"name":"Accept-Charset","value":"ISO-8859-1,utf-8;q=0.7,*;q=0.3"},{"name":"Host","value":"i.duckduckgo.com"},{"name":"User-Agent","value":"Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/535.7 (KHTML, like Gecko) Chrome/16.0.912.63 Safari/535.7"},{"name":"Accept","value":"*/*"},{"name":"Referer","value":"https://duckduckgo.com/?q=http+archive+specification"},{"name":"Cache-Control","value":"no-cache"}],"queryString":[],"headersSize":450,"bodySize":-1},"response":{"status":200,"statusText":"OK","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Date","value":"Fri, 23 Mar 2012 01:22:07 GMT"},{"name":"X-Cache","value":"Hit from DS"},{"name":"Connection","value":"keep-alive"},{"name":"Content-Length","value":"43"},{"name":"Server","value":"nginx"},{"name":"Content-Type","value":"image/x-icon"},{"name":"Access-Control-Allow-Origin","value":"*"},{"name":"Cache-Control","value":"max-age=2592000"},{"name":"Expires","value":"Sun, 22 Apr 2012 01:22:07 GMT"}],"headersSize":269,"redirectURL":"","bodySize":53,"content":{"size":43,"mimeType":"image/x-icon"}},"timings":{"blocked":0,"dns":-1,"connect":160,"send":0,"wait":249,"receive":-1,"ssl":-1},"cache":{},"pageref":"https://duckduckgo.com/?q=http+archive+specification","startedDateTime":"2012-03-23T01:22:07.265Z","time":409},{"request":{"method":"GET","url":"https://i.duckduckgo.com/i/www.archive.org.ico","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Accept-Encoding","value":"gzip,deflate,sdch"},{"name":"Accept-Language","value":"en-US,en;q=0.8"},{"name":"Connection","value":"keep-alive"},{"name":"Pragma","value":"no-cache"},{"name":"Accept-Charset","value":"ISO-8859-1,utf-8;q=0.7,*;q=0.3"},{"name":"Host","value":"i.duckduckgo.com"},{"name":"User-Agent","value":"Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/535.7 (KHTML, like Gecko) Chrome/16.0.912.63 Safari/535.7"},{"name":"Accept","value":"*/*"},{"name":"Referer","value":"https://duckduckgo.com/?q=http+archive+specification"},{"name":"Cache-Control","value":"no-cache"}],"queryString":[],"headersSize":438,"bodySize":-1},"response":{"status":200,"statusText":"OK","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Date","value":"Fri, 23 Mar 2012 01:22:07 GMT"},{"name":"X-Cache","value":"Hit from MC"},{"name":"Connection","value":"keep-alive"},{"name":"Content-Length","value":"4286"},{"name":"Server","value":"nginx"},{"name":"Content-Type","value":"image/x-icon"},{"name":"Access-Control-Allow-Origin","value":"*"},{"name":"Cache-Control","value":"max-age=2592000"},{"name":"Expires","value":"Sun, 22 Apr 2012 01:22:07 GMT"}],"headersSize":271,"redirectURL":"","bodySize":1189,"content":{"size":4286,"mimeType":"image/x-icon"}},"timings":{"blocked":0,"dns":-1,"connect":186,"send":0,"wait":11,"receive":-1,"ssl":-1},"cache":{},"pageref":"https://duckduckgo.com/?q=http+archive+specification","startedDateTime":"2012-03-23T01:22:07.265Z","time":197},{"request":{"method":"GET","url":"https://i.duckduckgo.com/i/scap.nist.gov.ico","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Accept-Encoding","value":"gzip,deflate,sdch"},{"name":"Accept-Language","value":"en-US,en;q=0.8"},{"name":"Connection","value":"keep-alive"},{"name":"Pragma","value":"no-cache"},{"name":"Accept-Charset","value":"ISO-8859-1,utf-8;q=0.7,*;q=0.3"},{"name":"Host","value":"i.duckduckgo.com"},{"name":"User-Agent","value":"Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/535.7 (KHTML, like Gecko) Chrome/16.0.912.63 Safari/535.7"},{"name":"Accept","value":"*/*"},{"name":"Referer","value":"https://duckduckgo.com/?q=http+archive+specification"},{"name":"Cache-Control","value":"no-cache"}],"queryString":[],"headersSize":436,"bodySize":-1},"response":{"status":200,"statusText":"OK","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Date","value":"Fri, 23 Mar 2012 01:22:07 GMT"},{"name":"X-Cache","value":"Hit from DS"},{"name":"Connection","value":"keep-alive"},{"name":"Content-Length","value":"43"},{"name":"Server","value":"nginx"},{"name":"Content-Type","value":"image/x-icon"},{"name":"Access-Control-Allow-Origin","value":"*"},{"name":"Cache-Control","value":"max-age=2592000"},{"name":"Expires","value":"Sun, 22 Apr 2012 01:22:07 GMT"}],"headersSize":269,"redirectURL":"","bodySize":85,"content":{"size":43,"mimeType":"image/x-icon"}},"timings":{"blocked":0,"dns":-1,"connect":188,"send":0,"wait":190,"receive":-1,"ssl":-1},"cache":{},"pageref":"https://duckduckgo.com/?q=http+archive+specification","startedDateTime":"2012-03-23T01:22:07.265Z","time":378},{"request":{"method":"GET","url":"https://i.duckduckgo.com/i/www.openarchives.org.ico","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Accept-Encoding","value":"gzip,deflate,sdch"},{"name":"Accept-Language","value":"en-US,en;q=0.8"},{"name":"Connection","value":"keep-alive"},{"name":"Pragma","value":"no-cache"},{"name":"Accept-Charset","value":"ISO-8859-1,utf-8;q=0.7,*;q=0.3"},{"name":"Host","value":"i.duckduckgo.com"},{"name":"User-Agent","value":"Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/535.7 (KHTML, like Gecko) Chrome/16.0.912.63 Safari/535.7"},{"name":"Accept","value":"*/*"},{"name":"Referer","value":"https://duckduckgo.com/?q=http+archive+specification"},{"name":"Cache-Control","value":"no-cache"}],"queryString":[],"headersSize":443,"bodySize":-1},"response":{"status":200,"statusText":"OK","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Date","value":"Fri, 23 Mar 2012 01:22:07 GMT"},{"name":"X-Cache","value":"Hit from DS"},{"name":"Connection","value":"keep-alive"},{"name":"Content-Length","value":"43"},{"name":"Server","value":"nginx"},{"name":"Content-Type","value":"image/x-icon"},{"name":"Access-Control-Allow-Origin","value":"*"},{"name":"Cache-Control","value":"max-age=2592000"},{"name":"Expires","value":"Sun, 22 Apr 2012 01:22:07 GMT"}],"headersSize":269,"redirectURL":"","bodySize":85,"content":{"size":43,"mimeType":"image/x-icon"}},"timings":{"blocked":0,"dns":-1,"connect":197,"send":0,"wait":421,"receive":-1,"ssl":-1},"cache":{},"pageref":"https://duckduckgo.com/?q=http+archive+specification","startedDateTime":"2012-03-23T01:22:07.265Z","time":618},{"request":{"method":"GET","url":"https://i.duckduckgo.com/i/www.rfc-archive.org.ico","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Accept-Encoding","value":"gzip,deflate,sdch"},{"name":"Accept-Language","value":"en-US,en;q=0.8"},{"name":"Connection","value":"keep-alive"},{"name":"Pragma","value":"no-cache"},{"name":"Accept-Charset","value":"ISO-8859-1,utf-8;q=0.7,*;q=0.3"},{"name":"Host","value":"i.duckduckgo.com"},{"name":"User-Agent","value":"Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/535.7 (KHTML, like Gecko) Chrome/16.0.912.63 Safari/535.7"},{"name":"Accept","value":"*/*"},{"name":"Referer","value":"https://duckduckgo.com/?q=http+archive+specification"},{"name":"Cache-Control","value":"no-cache"}],"queryString":[],"headersSize":442,"bodySize":-1},"response":{"status":200,"statusText":"OK","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Date","value":"Fri, 23 Mar 2012 01:22:07 GMT"},{"name":"Age","value":"1936"},{"name":"X-Cache","value":"Hit from DS"},{"name":"Connection","value":"keep-alive"},{"name":"Content-Length","value":"43"},{"name":"Server","value":"nginx"},{"name":"Content-Type","value":"image/x-icon"},{"name":"Access-Control-Allow-Origin","value":"*"},{"name":"Cache-Control","value":"max-age=2592000"},{"name":"Expires","value":"Sun, 22 Apr 2012 01:22:07 GMT"}],"headersSize":280,"redirectURL":"","bodySize":53,"content":{"size":43,"mimeType":"image/x-icon"}},"timings":{"blocked":0,"dns":-1,"connect":358,"send":0,"wait":26,"receive":-1,"ssl":-1},"cache":{},"pageref":"https://duckduckgo.com/?q=http+archive+specification","startedDateTime":"2012-03-23T01:22:07.266Z","time":384},{"request":{"method":"GET","url":"https://i.duckduckgo.com/i/blogs.oracle.com.ico","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Accept-Encoding","value":"gzip,deflate,sdch"},{"name":"Accept-Language","value":"en-US,en;q=0.8"},{"name":"Connection","value":"keep-alive"},{"name":"Pragma","value":"no-cache"},{"name":"Accept-Charset","value":"ISO-8859-1,utf-8;q=0.7,*;q=0.3"},{"name":"Host","value":"i.duckduckgo.com"},{"name":"User-Agent","value":"Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/535.7 (KHTML, like Gecko) Chrome/16.0.912.63 Safari/535.7"},{"name":"Accept","value":"*/*"},{"name":"Referer","value":"https://duckduckgo.com/?q=http+archive+specification"},{"name":"Cache-Control","value":"no-cache"}],"queryString":[],"headersSize":439,"bodySize":-1},"response":{"status":200,"statusText":"OK","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Date","value":"Fri, 23 Mar 2012 01:22:07 GMT"},{"name":"Age","value":"22820"},{"name":"X-Cache","value":"Hit from DS"},{"name":"Connection","value":"keep-alive"},{"name":"Content-Length","value":"43"},{"name":"Server","value":"nginx"},{"name":"Content-Type","value":"image/x-icon"},{"name":"Access-Control-Allow-Origin","value":"*"},{"name":"Cache-Control","value":"max-age=2592000"},{"name":"Expires","value":"Sun, 22 Apr 2012 01:22:07 GMT"}],"headersSize":281,"redirectURL":"","bodySize":101,"content":{"size":43,"mimeType":"image/x-icon"}},"timings":{"blocked":0,"dns":-1,"connect":368,"send":0,"wait":11,"receive":-1,"ssl":-1},"cache":{},"pageref":"https://duckduckgo.com/?q=http+archive+specification","startedDateTime":"2012-03-23T01:22:07.266Z","time":379},{"request":{"method":"GET","url":"https://i.duckduckgo.com/i/www.faqs.org.ico","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Accept-Encoding","value":"gzip,deflate,sdch"},{"name":"Accept-Language","value":"en-US,en;q=0.8"},{"name":"Connection","value":"keep-alive"},{"name":"Pragma","value":"no-cache"},{"name":"Accept-Charset","value":"ISO-8859-1,utf-8;q=0.7,*;q=0.3"},{"name":"Host","value":"i.duckduckgo.com"},{"name":"User-Agent","value":"Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/535.7 (KHTML, like Gecko) Chrome/16.0.912.63 Safari/535.7"},{"name":"Accept","value":"*/*"},{"name":"Referer","value":"https://duckduckgo.com/?q=http+archive+specification"},{"name":"Cache-Control","value":"no-cache"}],"queryString":[],"headersSize":435,"bodySize":-1},"response":{"status":200,"statusText":"OK","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Date","value":"Fri, 23 Mar 2012 01:22:07 GMT"},{"name":"Age","value":"11680"},{"name":"X-Cache","value":"Hit from MC"},{"name":"Connection","value":"keep-alive"},{"name":"Content-Length","value":"3638"},{"name":"Server","value":"nginx"},{"name":"Content-Type","value":"image/x-icon"},{"name":"Access-Control-Allow-Origin","value":"*"},{"name":"Cache-Control","value":"max-age=2592000"},{"name":"Expires","value":"Sun, 22 Apr 2012 01:22:07 GMT"}],"headersSize":283,"redirectURL":"","bodySize":2085,"content":{"size":3638,"mimeType":"image/x-icon"}},"timings":{"blocked":0,"dns":-1,"connect":375,"send":0,"wait":11,"receive":-1,"ssl":-1},"cache":{},"pageref":"https://duckduckgo.com/?q=http+archive+specification","startedDateTime":"2012-03-23T01:22:07.266Z","time":386},{"request":{"method":"GET","url":"https://i.duckduckgo.com/i/support.jvc.com.ico","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Accept-Encoding","value":"gzip,deflate,sdch"},{"name":"Accept-Language","value":"en-US,en;q=0.8"},{"name":"Connection","value":"keep-alive"},{"name":"Pragma","value":"no-cache"},{"name":"Accept-Charset","value":"ISO-8859-1,utf-8;q=0.7,*;q=0.3"},{"name":"Host","value":"i.duckduckgo.com"},{"name":"User-Agent","value":"Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/535.7 (KHTML, like Gecko) Chrome/16.0.912.63 Safari/535.7"},{"name":"Accept","value":"*/*"},{"name":"Referer","value":"https://duckduckgo.com/?q=http+archive+specification"},{"name":"Cache-Control","value":"no-cache"}],"queryString":[],"headersSize":438,"bodySize":-1},"response":{"status":200,"statusText":"OK","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Date","value":"Fri, 23 Mar 2012 01:22:07 GMT"},{"name":"X-Cache","value":"Hit from MC"},{"name":"Connection","value":"keep-alive"},{"name":"Content-Length","value":"13934"},{"name":"Server","value":"nginx"},{"name":"Content-Type","value":"image/x-icon"},{"name":"Access-Control-Allow-Origin","value":"*"},{"name":"Cache-Control","value":"max-age=2592000"},{"name":"Expires","value":"Sun, 22 Apr 2012 01:22:07 GMT"}],"headersSize":272,"redirectURL":"","bodySize":1749,"content":{"size":13934,"mimeType":"image/x-icon"}},"timings":{"blocked":0,"dns":-1,"connect":377,"send":1,"wait":152,"receive":-1,"ssl":-1},"cache":{},"pageref":"https://duckduckgo.com/?q=http+archive+specification","startedDateTime":"2012-03-23T01:22:07.266Z","time":530},{"request":{"method":"GET","url":"https://i.duckduckgo.com/i/landsat.usgs.gov.ico","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Accept-Encoding","value":"gzip,deflate,sdch"},{"name":"Accept-Language","value":"en-US,en;q=0.8"},{"name":"Connection","value":"keep-alive"},{"name":"Pragma","value":"no-cache"},{"name":"Accept-Charset","value":"ISO-8859-1,utf-8;q=0.7,*;q=0.3"},{"name":"Host","value":"i.duckduckgo.com"},{"name":"User-Agent","value":"Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/535.7 (KHTML, like Gecko) Chrome/16.0.912.63 Safari/535.7"},{"name":"Accept","value":"*/*"},{"name":"Referer","value":"https://duckduckgo.com/?q=http+archive+specification"},{"name":"Cache-Control","value":"no-cache"}],"queryString":[],"headersSize":439,"bodySize":-1},"response":{"status":200,"statusText":"OK","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Date","value":"Fri, 23 Mar 2012 01:22:08 GMT"},{"name":"X-Cache","value":"Hit from DS"},{"name":"Connection","value":"keep-alive"},{"name":"Content-Length","value":"43"},{"name":"Server","value":"nginx"},{"name":"Content-Type","value":"image/x-icon"},{"name":"Access-Control-Allow-Origin","value":"*"},{"name":"Cache-Control","value":"max-age=2592000"},{"name":"Expires","value":"Sun, 22 Apr 2012 01:22:08 GMT"}],"headersSize":269,"redirectURL":"","bodySize":53,"content":{"size":43,"mimeType":"image/x-icon"}},"timings":{"blocked":0,"dns":-1,"connect":378,"send":0,"wait":533,"receive":-1,"ssl":-1},"cache":{},"pageref":"https://duckduckgo.com/?q=http+archive+specification","startedDateTime":"2012-03-23T01:22:07.267Z","time":911},{"request":{"method":"GET","url":"https://i.duckduckgo.com/i/download.intel.com.ico","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Accept-Encoding","value":"gzip,deflate,sdch"},{"name":"Accept-Language","value":"en-US,en;q=0.8"},{"name":"Connection","value":"keep-alive"},{"name":"Pragma","value":"no-cache"},{"name":"Accept-Charset","value":"ISO-8859-1,utf-8;q=0.7,*;q=0.3"},{"name":"Host","value":"i.duckduckgo.com"},{"name":"User-Agent","value":"Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/535.7 (KHTML, like Gecko) Chrome/16.0.912.63 Safari/535.7"},{"name":"Accept","value":"*/*"},{"name":"Referer","value":"https://duckduckgo.com/?q=http+archive+specification"},{"name":"Cache-Control","value":"no-cache"}],"queryString":[],"headersSize":441,"bodySize":-1},"response":{"status":200,"statusText":"OK","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Date","value":"Fri, 23 Mar 2012 01:22:07 GMT"},{"name":"Age","value":"222"},{"name":"X-Cache","value":"Hit from DS"},{"name":"Connection","value":"keep-alive"},{"name":"Content-Length","value":"43"},{"name":"Server","value":"nginx"},{"name":"Content-Type","value":"image/x-icon"},{"name":"Access-Control-Allow-Origin","value":"*"},{"name":"Cache-Control","value":"max-age=2592000"},{"name":"Expires","value":"Sun, 22 Apr 2012 01:22:07 GMT"}],"headersSize":279,"redirectURL":"","bodySize":53,"content":{"size":43,"mimeType":"image/x-icon"}},"timings":{"blocked":0,"dns":-1,"connect":383,"send":0,"wait":31,"receive":-1,"ssl":-1},"cache":{},"pageref":"https://duckduckgo.com/?q=http+archive+specification","startedDateTime":"2012-03-23T01:22:07.267Z","time":414},{"request":{"method":"GET","url":"https://i.duckduckgo.com/i/xml.coverpages.org.ico","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Accept-Encoding","value":"gzip,deflate,sdch"},{"name":"Accept-Language","value":"en-US,en;q=0.8"},{"name":"Connection","value":"keep-alive"},{"name":"Pragma","value":"no-cache"},{"name":"Accept-Charset","value":"ISO-8859-1,utf-8;q=0.7,*;q=0.3"},{"name":"Host","value":"i.duckduckgo.com"},{"name":"User-Agent","value":"Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/535.7 (KHTML, like Gecko) Chrome/16.0.912.63 Safari/535.7"},{"name":"Accept","value":"*/*"},{"name":"Referer","value":"https://duckduckgo.com/?q=http+archive+specification"},{"name":"Cache-Control","value":"no-cache"}],"queryString":[],"headersSize":441,"bodySize":-1},"response":{"status":200,"statusText":"OK","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Date","value":"Fri, 23 Mar 2012 01:22:08 GMT"},{"name":"X-Cache","value":"Hit from DS"},{"name":"Connection","value":"keep-alive"},{"name":"Content-Length","value":"43"},{"name":"Server","value":"nginx"},{"name":"Content-Type","value":"image/x-icon"},{"name":"Access-Control-Allow-Origin","value":"*"},{"name":"Cache-Control","value":"max-age=2592000"},{"name":"Expires","value":"Sun, 22 Apr 2012 01:22:08 GMT"}],"headersSize":269,"redirectURL":"","bodySize":85,"content":{"size":43,"mimeType":"image/x-icon"}},"timings":{"blocked":0,"dns":-1,"connect":386,"send":0,"wait":462,"receive":-1,"ssl":-1},"cache":{},"pageref":"https://duckduckgo.com/?q=http+archive+specification","startedDateTime":"2012-03-23T01:22:07.267Z","time":848},{"request":{"method":"GET","url":"https://i.duckduckgo.com/i/java.net.ico","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Accept-Encoding","value":"gzip,deflate,sdch"},{"name":"Accept-Language","value":"en-US,en;q=0.8"},{"name":"Connection","value":"keep-alive"},{"name":"Pragma","value":"no-cache"},{"name":"Accept-Charset","value":"ISO-8859-1,utf-8;q=0.7,*;q=0.3"},{"name":"Host","value":"i.duckduckgo.com"},{"name":"User-Agent","value":"Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/535.7 (KHTML, like Gecko) Chrome/16.0.912.63 Safari/535.7"},{"name":"Accept","value":"*/*"},{"name":"Referer","value":"https://duckduckgo.com/?q=http+archive+specification"},{"name":"Cache-Control","value":"no-cache"}],"queryString":[],"headersSize":431,"bodySize":-1},"response":{"status":200,"statusText":"OK","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Date","value":"Fri, 23 Mar 2012 01:22:07 GMT"},{"name":"Age","value":"6230"},{"name":"X-Cache","value":"Hit from MC"},{"name":"Connection","value":"keep-alive"},{"name":"Content-Length","value":"1150"},{"name":"Server","value":"nginx"},{"name":"Content-Type","value":"image/x-icon"},{"name":"Access-Control-Allow-Origin","value":"*"},{"name":"Cache-Control","value":"max-age=2592000"},{"name":"Expires","value":"Sun, 22 Apr 2012 01:22:07 GMT"}],"headersSize":282,"redirectURL":"","bodySize":181,"content":{"size":1150,"mimeType":"image/x-icon"}},"timings":{"blocked":0,"dns":-1,"connect":407,"send":0,"wait":29,"receive":-1,"ssl":-1},"cache":{},"pageref":"https://duckduckgo.com/?q=http+archive+specification","startedDateTime":"2012-03-23T01:22:07.267Z","time":436},{"request":{"method":"GET","url":"https://builder.duckduckgo.com/b.js?q=http%20archive%20specification","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Accept-Encoding","value":"gzip,deflate,sdch"},{"name":"Accept-Language","value":"en-US,en;q=0.8"},{"name":"Connection","value":"keep-alive"},{"name":"Pragma","value":"no-cache"},{"name":"Accept-Charset","value":"ISO-8859-1,utf-8;q=0.7,*;q=0.3"},{"name":"Host","value":"builder.duckduckgo.com"},{"name":"User-Agent","value":"Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/535.7 (KHTML, like Gecko) Chrome/16.0.912.63 Safari/535.7"},{"name":"Accept","value":"*/*"},{"name":"Referer","value":"https://duckduckgo.com/?q=http+archive+specification"},{"name":"Cache-Control","value":"no-cache"}],"queryString":[],"headersSize":460,"bodySize":-1},"response":{"status":200,"statusText":"OK","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Date","value":"Fri, 23 Mar 2012 01:22:07 GMT"},{"name":"Content-Encoding","value":"gzip"},{"name":"Transfer-Encoding","value":"chunked"},{"name":"Connection","value":"keep-alive"},{"name":"Server","value":"nginx"},{"name":"Content-Type","value":"application/x-javascript; charset=UTF-8"},{"name":"Cache-Control","value":"no-cache"},{"name":"Expires","value":"Fri, 23 Mar 2012 01:22:06 GMT"}],"headersSize":267,"redirectURL":"","bodySize":724,"content":{"size":343,"mimeType":"application/x-javascript"}},"timings":{"blocked":0,"dns":-1,"connect":176,"send":0,"wait":88,"receive":-1,"ssl":89},"cache":{},"pageref":"https://duckduckgo.com/?q=http+archive+specification","startedDateTime":"2012-03-23T01:22:07.251Z","time":353},{"request":{"method":"GET","url":"https://duckduckgo.com/assets/side_button_off.v101.png","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Accept-Encoding","value":"gzip,deflate,sdch"},{"name":"Accept-Language","value":"en-US,en;q=0.8"},{"name":"Connection","value":"keep-alive"},{"name":"Pragma","value":"no-cache"},{"name":"Accept-Charset","value":"ISO-8859-1,utf-8;q=0.7,*;q=0.3"},{"name":"Host","value":"duckduckgo.com"},{"name":"User-Agent","value":"Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/535.7 (KHTML, like Gecko) Chrome/16.0.912.63 Safari/535.7"},{"name":"Accept","value":"*/*"},{"name":"Referer","value":"https://duckduckgo.com/?q=http+archive+specification"},{"name":"Cache-Control","value":"no-cache"}],"queryString":[],"headersSize":446,"bodySize":-1},"response":{"status":200,"statusText":"OK","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Date","value":"Fri, 23 Mar 2012 01:22:07 GMT"},{"name":"Connection","value":"keep-alive"},{"name":"Content-Length","value":"149"},{"name":"Last-Modified","value":"Fri, 13 Jan 2012 18:36:15 GMT"},{"name":"Server","value":"nginx"},{"name":"Content-Type","value":"image/png"},{"name":"Cache-Control","value":"max-age=31536000\npublic"},{"name":"Accept-Ranges","value":"bytes"},{"name":"Expires","value":"Sat, 23 Mar 2013 01:22:07 GMT"}],"headersSize":305,"redirectURL":"","bodySize":117,"content":{"size":149,"mimeType":"image/png"}},"timings":{"blocked":0,"dns":-1,"connect":0,"send":0,"wait":10,"receive":-1,"ssl":-1},"cache":{},"pageref":"https://duckduckgo.com/?q=http+archive+specification","startedDateTime":"2012-03-23T01:22:07.522Z","time":10},{"request":{"method":"GET","url":"https://duckduckgo.com/assets/icon_plus.v102.png","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Accept-Encoding","value":"gzip,deflate,sdch"},{"name":"Accept-Language","value":"en-US,en;q=0.8"},{"name":"Connection","value":"keep-alive"},{"name":"Pragma","value":"no-cache"},{"name":"Accept-Charset","value":"ISO-8859-1,utf-8;q=0.7,*;q=0.3"},{"name":"Host","value":"duckduckgo.com"},{"name":"User-Agent","value":"Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/535.7 (KHTML, like Gecko) Chrome/16.0.912.63 Safari/535.7"},{"name":"Accept","value":"*/*"},{"name":"Referer","value":"https://duckduckgo.com/?q=http+archive+specification"},{"name":"Cache-Control","value":"no-cache"}],"queryString":[],"headersSize":440,"bodySize":-1},"response":{"status":200,"statusText":"OK","httpVersion":"HTTP/1.1","cookies":[],"headers":[{"name":"Date","value":"Fri, 23 Mar 2012 01:22:07 GMT"},{"name":"Connection","value":"keep-alive"},{"name":"Content-Length","value":"212"},{"name":"Last-Modified","value":"Wed, 01 Feb 2012 15:42:43 GMT"},{"name":"Server","value":"nginx"},{"name":"Content-Type","value":"image/png"},{"name":"Cache-Control","value":"max-age=31536000\npublic"},{"name":"Accept-Ranges","value":"bytes"},{"name":"Expires","value":"Sat, 23 Mar 2013 01:22:07 GMT"}],"headersSize":305,"redirectURL":"","bodySize":181,"content":{"size":212,"mimeType":"image/png"}},"timings":{"blocked":0,"dns":-1,"connect":0,"send":0,"wait":11,"receive":-1,"ssl":-1},"cache":{},"pageref":"https://duckduckgo.com/?q=http+archive+specification","startedDateTime":"2012-03-23T01:22:07.523Z","time":11}]}}';

ok($har->string($pingdom_string), "Successfully read pingdom har archive for https://duckduckgo.com/?q=http+archive+specification");
ok($har->version() eq '1.2', "INPUT: Pingdom produces a version 1.2 http archive");
ok($har->creator()->name() eq 'Pingdom Tools', "INPUT: Pingdom's creator name is 'Pingdom Tools'");
ok($har->creator()->version() eq '', "INPUT: Pingdom's creator version is the empty string");
ok($har->creator()->comment() eq 'Test the load time of a web page at http://tools.pingdom.com/fpt', "INPUT: Pingdom's creator comment is advertising for Pingdom");
ok(scalar $har->pages() == 1, "INPUT: Pingdom's archive contains 1 page");
my ($firstPage) = $har->pages();
ok($firstPage->startedDateTime() eq '2012-03-23T01:22:05.820Z', "INPUT: Pingdom's archive page has a startedDateTime of '2012-03-23T01:22:05.820Z'");
ok($firstPage->id() eq 'https://duckduckgo.com/?q=http+archive+specification', "INPUT: Pingdom's archive page has an id of 'https://duckduckgo.com/?q=http+archive+specification'");
ok($firstPage->title() eq '', "INPUT: Pingdom's archive page has an empty string as the title");
ok($firstPage->pageTimings()->onContentLoad(-1) == 333, "INPUT: Pingdom's archive page has an onContentLoad of 333");
ok(not(defined $firstPage->pageTimings()->onContentLoad(undef)), "INPUT: Pingdom's archive page has an onContentLoad that is not defined (after being set to -1)");
ok(not(defined $firstPage->pageTimings()->onContentLoad(333)), "INPUT: Pingdom's archive page has an onContentLoad that is not defined (after being set to undef");
ok($firstPage->pageTimings()->onLoad(-1) == 372, "INPUT: Pingdom's archive page has an onLoad of 372");
ok(not(defined $firstPage->pageTimings()->onLoad(undef)), "INPUT: Pingdom's archive page has an onLoad that is not defined (after being set to -1)");
ok(not(defined $firstPage->pageTimings()->onLoad(372)), "INPUT: Pingdom's archive page has an onLoad that is not defined (after being set to undef)");
ok(scalar $har->entries() == 46, "INPUT: Pingdom's archive contains 46 entries");
my ($firstEntry) = $har->entries();
ok($firstEntry->pageref() eq 'https://duckduckgo.com/?q=http+archive+specification', "INPUT: Pingdom's archive first entry has a pageref of 'https://duckduckgo.com/?q=http+archive+specification'");
ok($firstEntry->startedDateTime() eq '2012-03-23T01:22:05.820Z', "INPUT: Pingdom's archive first entry has a startedDateTime of '2012-03-23T01:22:05.820Z'");
ok($firstEntry->time() == 173, "INPUT: Pingdom's archive first entry has a time of 173");
ok($firstEntry->request()->method() eq 'GET', "INPUT: Pingdom's archive first entry request has a method of 'GET'");
ok($firstEntry->request()->url() eq 'https://duckduckgo.com/?q=http+archive+specification', "INPUT: Pingdom's archive first entry request has a url of 'https://duckduckgo.com/?q=http+archive+specification'");
ok($firstEntry->request()->httpVersion() eq 'HTTP/1.1', "INPUT: Pingdom's archive first entry request has a version of 'HTTP/1.1'");
ok(scalar $firstEntry->request()->cookies() == 0, "INPUT: Pingdom's archive first entry request has an empty cookie list");
ok(scalar $firstEntry->request()->headers() == 9, "INPUT: Pingdom's archive first entry request has 9 headers");
ok(scalar $firstEntry->timings()->blocked() == 0, "INPUT: Pingdom's archive first entry timings has a blocked value of 0");
ok(not(defined $firstEntry->timings()->dns()), "INPUT: Pingdom's archive first entry timings does not have a defined value for dns");
ok(scalar $firstEntry->timings()->connect() == 125, "INPUT: Pingdom's archive first entry timings has a connect value of 125");
ok(scalar $firstEntry->timings()->send() == 0, "INPUT: Pingdom's archive first entry timings has a send value of 0");
ok(scalar $firstEntry->timings()->wait() == 28, "INPUT: Pingdom's archive first entry timings has a wait value of 28");
ok(scalar $firstEntry->timings()->receive() == 1, "INPUT: Pingdom's archive first entry timings has a receive value of 1");
ok(scalar $firstEntry->timings()->ssl() == 19, "INPUT: Pingdom's archive first entry timings has a ssl value of 19");
$firstEntry->timings()->ssl(20);
ok($firstEntry->time() == 174, "INPUT: Pingdom's archive first entry has a time of 174 (after \$entry->timings()->ssl() was set to 20");
$firstEntry->timings()->ssl(19);
ok($firstEntry->time() == 173, "INPUT: Pingdom's archive first entry has a time of 173 (after \$entry->timings()->ssl() was reset to 19");
my $pingdom_ref = JSON::decode_json("$har");
ok($pingdom_ref->{log}->{version} eq '1.2', "OUTPUT: Pingdom produces a version 1.2 http archive");
ok($pingdom_ref->{log}->{creator}->{name} eq 'Pingdom Tools', "OUTPUT: Pingdom's creator name is 'Pingdom Tools'");
ok($pingdom_ref->{log}->{creator}->{version} eq '', "OUTPUT: Pingdom's creator version is the empty string");
ok($pingdom_ref->{log}->{creator}->{comment} eq 'Test the load time of a web page at http://tools.pingdom.com/fpt', "OUTPUT: Pingdom's creator comment is advertising for Pingdom");
ok(scalar @{$pingdom_ref->{log}->{pages}} == 1, "OUTPUT: Pingdom's archive contains 1 page");
ok($pingdom_ref->{log}->{pages}->[0]->{startedDateTime} eq '2012-03-23T01:22:05.820Z', "OUTPUT: Pingdom's archive page has a startedDateTime of '2012-03-23T01:22:05.820Z'");
ok($pingdom_ref->{log}->{pages}->[0]->{id} eq 'https://duckduckgo.com/?q=http+archive+specification', "OUTPUT: Pingdom's archive page has an id of 'https://duckduckgo.com/?q=http+archive+specification'");
ok($pingdom_ref->{log}->{pages}->[0]->{title} eq '', "OUTPUT: Pingdom's archive page has an empty string as the title");
ok($pingdom_ref->{log}->{pages}->[0]->{pageTimings}->{onContentLoad} == 333, "OUTPUT: Pingdom's archive page has an onContentLoad of 333");
$firstPage->pageTimings()->onContentLoad(undef);
$pingdom_ref = JSON::decode_json("$har");
ok($pingdom_ref->{log}->{pages}->[0]->{pageTimings}->{onContentLoad} == -1, "OUTPUT: Pingdom's archive page has an onContentLoad of -1 after being set to undef");
$firstPage->pageTimings()->onContentLoad('-1');
$pingdom_ref = JSON::decode_json("$har");
ok($pingdom_ref->{log}->{pages}->[0]->{pageTimings}->{onContentLoad} == -1, "OUTPUT: Pingdom's archive page has an onContentLoad of -1 after being set to '-1'");
ok($pingdom_ref->{log}->{pages}->[0]->{pageTimings}->{onLoad} == 372, "OUTPUT: Pingdom's archive page has an onLoad of 372");
$firstPage->pageTimings()->onLoad(undef);
$pingdom_ref = JSON::decode_json("$har");
ok($pingdom_ref->{log}->{pages}->[0]->{pageTimings}->{onLoad} == -1, "OUTPUT: Pingdom's archive page has an onLoad of -1 after being set to undef");
$firstPage->pageTimings()->onLoad("-1");
$pingdom_ref = JSON::decode_json("$har");
ok($pingdom_ref->{log}->{pages}->[0]->{pageTimings}->{onLoad} == -1, "OUTPUT: Pingdom's archive page has an onLoad of -1 after being set to '-1'");
ok(scalar @{$pingdom_ref->{log}->{entries}} == 46, "OUTPUT: Pingdom's archive contains 46 entries");
ok($pingdom_ref->{log}->{entries}->[0]->{pageref} eq 'https://duckduckgo.com/?q=http+archive+specification', "OUTPUT: Pingdom's archive first entry has a pageref of 'https://duckduckgo.com/?q=http+archive+specification'");
ok($pingdom_ref->{log}->{entries}->[0]->{startedDateTime} eq '2012-03-23T01:22:05.820Z', "OUTPUT: Pingdom's archive first entry has a startedDateTime of '2012-03-23T01:22:05.820Z'");
ok($pingdom_ref->{log}->{entries}->[0]->{time} == 173, "OUTPUT: Pingdom's archive first entry has a time of 173");
ok($pingdom_ref->{log}->{entries}->[0]->{request}->{method} eq 'GET', "OUTPUT: Pingdom's archive first entry request has a method of 'GET'");
ok($pingdom_ref->{log}->{entries}->[0]->{request}->{url} eq 'https://duckduckgo.com/?q=http+archive+specification', "OUTPUT: Pingdom's archive first entry request has a url of 'https://duckduckgo.com/?q=http+archive+specification'");
ok($pingdom_ref->{log}->{entries}->[0]->{request}->{httpVersion} eq 'HTTP/1.1', "OUTPUT: Pingdom's archive first entry request has a httpVersion of 'HTTP/1.1'");
ok(scalar @{$pingdom_ref->{log}->{entries}->[0]->{request}->{cookies}} == 0, "OUTPUT: Pingdom's archive first entry request has an empty cookie list");
ok(scalar @{$pingdom_ref->{log}->{entries}->[0]->{request}->{headers}} == 9, "OUTPUT: Pingdom's archive first entry request has 9 headers");
ok($pingdom_ref->{log}->{entries}->[0]->{timings}->{blocked} == 0, "OUTPUT: Pingdom's archive first entry timings has a blocked value of 0");
ok($pingdom_ref->{log}->{entries}->[0]->{timings}->{dns} == -1, "OUTPUT: Pingdom's archive first entry timings has a dns value of -1");
ok($pingdom_ref->{log}->{entries}->[0]->{timings}->{connect} == 125, "OUTPUT: Pingdom's archive first entry timings has a connect value of 125");
ok($pingdom_ref->{log}->{entries}->[0]->{timings}->{send} == 0, "OUTPUT: Pingdom's archive first entry timings has a send value of 0");
ok($pingdom_ref->{log}->{entries}->[0]->{timings}->{wait} == 28, "OUTPUT: Pingdom's archive first entry timings has a wait value of 28");
ok($pingdom_ref->{log}->{entries}->[0]->{timings}->{receive} == 1, "OUTPUT: Pingdom's archive first entry timings has a receive value of 1");
ok($pingdom_ref->{log}->{entries}->[0]->{timings}->{ssl} == 19, "OUTPUT: Pingdom's archive first entry timings has a ssl value of 19");

