use Dios { accessors => 'lval' };
use Test::More;

plan tests => 7;

my $NAME = 'Damian';

class Base1 {
    method basic { return 'basic' }
}

class Base2 {
    method more_basic { return 'more basic' }
}

class Demo is Base1 is Base2 {
    has Str $.myname is req is rw;

    method foo ($this: Str $newname, Int|Undef :$other) {
        ::is $myname, $NAME => 'Name correct';

        $myname = 'Other';
        ::is $this->myname, 'Other' => 'Assignment to name correct';

        return 1;
    }
}

my $obj = Demo->new({ myname => $NAME });

::is $obj->basic, 'basic' => 'Inherited Base1 correctly';
::is $obj->more_basic, 'more basic' => 'Inherited Base2 correctly';

::is $obj->foo('me'), 1      => 'Called foo() correctly';
::is $obj->myname, 'Other' => 'Retained updated name correctly';

$obj->myname = 'etc';
::is $obj->myname, 'etc'        => 'Retained updated name correctly';

done_testing;
