# automatically generated file, don't edit



# Copyright 2023 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::DE;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20230903131447;

my $formatters = [
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            3[02]|
            40|
            [68]9
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3,13})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            2(?:
              0[1-389]|
              12[0-8]
            )|
            3(?:
              [35-9][15]|
              4[015]
            )|
            906|
            2(?:
              [13][14]|
              2[18]
            )|
            (?:
              2[4-9]|
              4[2-9]|
              [579][1-9]|
              [68][1-8]
            )1
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3,12})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            [24-6]|
            3(?:
              3(?:
                0[1-467]|
                2[127-9]|
                3[124578]|
                7[1257-9]|
                8[1256]|
                9[145]
              )|
              4(?:
                2[135]|
                4[13578]|
                9[1346]
              )|
              5(?:
                0[14]|
                2[1-3589]|
                6[1-4]|
                7[13468]|
                8[13568]
              )|
              6(?:
                2[1-489]|
                3[124-6]|
                6[13]|
                7[12579]|
                8[1-356]|
                9[135]
              )|
              7(?:
                2[1-7]|
                4[145]|
                6[1-5]|
                7[1-4]
              )|
              8(?:
                21|
                3[1468]|
                6|
                7[1467]|
                8[136]
              )|
              9(?:
                0[12479]|
                2[1358]|
                4[134679]|
                6[1-9]|
                7[136]|
                8[147]|
                9[1468]
              )
            )|
            70[2-8]|
            8(?:
              0[2-9]|
              [1-8]
            )|
            90[7-9]|
            [79][1-9]|
            3[68]4[1347]|
            3(?:
              47|
              60
            )[1356]|
            3(?:
              3[46]|
              46|
              5[49]
            )[1246]|
            3[4579]3[1357]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{2,11})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '138',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '3',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{2,10})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '181',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{5,11})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            1(?:
              3|
              80
            )|
            9
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d)(\\d{4,10})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '1[67]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{7,8})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '8',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{7,12})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '18500',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{6})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '7',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '18[68]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{7})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '15[0568]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{6})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '15[1279]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{7})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '18',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{8})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            1(?:
              6[023]|
              7
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{7,8})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '15[279]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{7})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '15',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{8})'
                }
              ];

my $validators = {
                'fixed_line' => '
          32\\d{9,11}|
          49[1-6]\\d{10}|
          322\\d{6}|
          49[0-7]\\d{3,9}|
          (?:
            [34]0|
            [68]9
          )\\d{3,13}|
          (?:
            2(?:
              0[1-689]|
              [1-3569]\\d|
              4[0-8]|
              7[1-7]|
              8[0-7]
            )|
            3(?:
              [3569]\\d|
              4[0-79]|
              7[1-7]|
              8[1-8]
            )|
            4(?:
              1[02-9]|
              [2-48]\\d|
              5[0-6]|
              6[0-8]|
              7[0-79]
            )|
            5(?:
              0[2-8]|
              [124-6]\\d|
              [38][0-8]|
              [79][0-7]
            )|
            6(?:
              0[02-9]|
              [1-358]\\d|
              [47][0-8]|
              6[1-9]
            )|
            7(?:
              0[2-8]|
              1[1-9]|
              [27][0-7]|
              3\\d|
              [4-6][0-8]|
              8[0-5]|
              9[013-7]
            )|
            8(?:
              0[2-9]|
              1[0-79]|
              2\\d|
              3[0-46-9]|
              4[0-6]|
              5[013-9]|
              6[1-8]|
              7[0-8]|
              8[0-24-6]
            )|
            9(?:
              0[6-9]|
              [1-4]\\d|
              [589][0-7]|
              6[0-8]|
              7[0-467]
            )
          )\\d{3,12}
        ',
                'geographic' => '
          32\\d{9,11}|
          49[1-6]\\d{10}|
          322\\d{6}|
          49[0-7]\\d{3,9}|
          (?:
            [34]0|
            [68]9
          )\\d{3,13}|
          (?:
            2(?:
              0[1-689]|
              [1-3569]\\d|
              4[0-8]|
              7[1-7]|
              8[0-7]
            )|
            3(?:
              [3569]\\d|
              4[0-79]|
              7[1-7]|
              8[1-8]
            )|
            4(?:
              1[02-9]|
              [2-48]\\d|
              5[0-6]|
              6[0-8]|
              7[0-79]
            )|
            5(?:
              0[2-8]|
              [124-6]\\d|
              [38][0-8]|
              [79][0-7]
            )|
            6(?:
              0[02-9]|
              [1-358]\\d|
              [47][0-8]|
              6[1-9]
            )|
            7(?:
              0[2-8]|
              1[1-9]|
              [27][0-7]|
              3\\d|
              [4-6][0-8]|
              8[0-5]|
              9[013-7]
            )|
            8(?:
              0[2-9]|
              1[0-79]|
              2\\d|
              3[0-46-9]|
              4[0-6]|
              5[013-9]|
              6[1-8]|
              7[0-8]|
              8[0-24-6]
            )|
            9(?:
              0[6-9]|
              [1-4]\\d|
              [589][0-7]|
              6[0-8]|
              7[0-467]
            )
          )\\d{3,12}
        ',
                'mobile' => '
          15[0-25-9]\\d{8}|
          1(?:
            6[023]|
            7\\d
          )\\d{7,8}
        ',
                'pager' => '
          16(?:
            4\\d{1,10}|
            [89]\\d{1,11}
          )
        ',
                'personal_number' => '700\\d{8}',
                'specialrate' => '(
          180\\d{5,11}|
          13(?:
            7[1-6]\\d\\d|
            8
          )\\d{4}
        )|(
          (?:
            137[7-9]|
            900(?:
              [135]|
              9\\d
            )
          )\\d{6}
        )|(
          18(?:
            1\\d{5,11}|
            [2-9]\\d{8}
          )
        )',
                'toll_free' => '800\\d{7,12}',
                'voip' => ''
              };
my %areanames = ();
$areanames{de} = {"495827", "Unterlüß",
"494483", "Ovelgönne\-Großenmeer",
"493647", "Pößneck",
"4934493", "Gößnitz\ Thüringen",
"499636", "Plößberg",
"499567", "Seßlach\-Gemünda",
"4934901", "Roßlau\ Elbe",
"4935248", "Schönfeld\ bei\ Großenhain",
"497351", "Biberach\ an\ der\ Riß",
"498367", "Roßhaupten\ Forggensee",
"4935952", "Großröhrsdorf\ OL",
"4939976", "Groß\ Bützin",
"4936484", "Knau\ bei\ Pößneck",
"496252", "Heppenheim\ Bergstraße",
"4936949", "Obermaßfeld\-Grimmenthal",
"49221", "Köln",
"4934445", "Stößen",
"4935726", "Groß\ Särchen",
"4935753", "Großräschen",
"498536", "Kößlarn",
"498633", "Tüßling",
"496663", "Steinau\ an\ der\ Straße",
"492339", "Sprockhövel\-Haßlinghausen",
"49911", "Nürnberg",
"496321", "Neustadt\ an\ der\ Weinstraße",
"498170", "Straßlach\-Dingharting",
"4939934", "Groß\ Plasten",
"494497", "Barßel\-Harkebrügge",
"498807", "Dießen\ am\ Ammersee",
"495064", "Groß\ Düngen",
"4935938", "Großpostwitz\ OL",
"499656", "Moosbach\ bei\ Vohenstrauß",
"492203", "Köln\-Porz",
"497162", "Süßen",
"4938234", "Born\ Darß",
"4936072", "Weißenborn\-Lüderode",
"499242", "Gößweinstein",
"496364", "Nußbach\ Pfalz",
"495384", "Seesen\-Groß\ Rhüden",
"4939883", "Groß\ Dölln",
"494684", "Langeneß\ Hallig",
"497355", "Hochdorf\ Riß",
"4935841", "Großschönau\ Sachsen",
"4936705", "Oberweißbach\ Thüringer\ Wald",
"494509", "Groß\ Grönau",
"4989", "München",
"495053", "Faßberg\-Müden",
"4935240", "Tauscha\ bei\ Großenhain",
"499141", "Weißenburg\ in\ Bayern",};
$areanames{en} = {"494763", "Gnarrenburg",
"499427", "Leiblfing",
"492534", "Münster\-Roxel",
"495073", "Neustadt\-Esperke",
"497082", "Neuenbürg\ Württemberg",
"494444", "Goldenstedt",
"497963", "Adelmannsfelden",
"494497", "Barssel\-Harkebrügge",
"495908", "Wietmarschen\-Lohne",
"495068", "Elze\ Leine",
"496626", "Wildeck\-Obersuhl",
"495165", "Rethem\ Aller",
"492843", "Rheinberg",
"492337", "Hagen\-Dahl",
"494778", "Wingst",
"496108", "Mühlheim\ am\ Main",
"497231", "Pforzheim",
"499831", "Gunzenhausen",
"497046", "Zaberfeld",
"495607", "Fuldatal",
"497402", "Fluorn\-Winzeln",
"492945", "Lippstadt\-Benninghausen",
"498841", "Murnau\ am\ Staffelsee",
"492384", "Welver",
"493772", "Schneeberg\ Erzgebirge",
"496485", "Nentershausen\ Westerwald",
"4937294", "Grünhainichen",
"492587", "Ennigerloh\-Westkirchen",
"499265", "Pressig",
"496655", "Neuhof\ Kreis\ Fulda",
"4933087", "Bredereiche",
"4938736", "Goldberg",
"4937295", "Lugau\ Erzgebirge",
"497653", "Lenzkirch",
"493671", "Saalfeld\ Saale",
"497483", "Horb\-Mühringen",
"495472", "Bad\ Essen",
"494365", "Heringsdorf\ Holstein",
"492779", "Greifenstein\-Beilstein",
"493337", "Biesenthal\ Brandenburg",
"493843", "Güstrow",
"497331", "Geislingen\ an\ der\ Steige",
"4933230", "Börnicke\ Kreis\ Havelland",
"4934492", "Lucka",
"4937609", "Wolkenburg\ Mulde",
"498657", "Ramsau\ bei\ Berchtesgaden",
"499365", "Rimpar",
"4938423", "Bad\ Kleinen",
"496639", "Ottrau",
"495864", "Jameln",
"49335", "Frankfurt\ \(Oder\)",
"494265", "Fintel",
"4936084", "Heuthen",
"499497", "Seubersdorf\ in\ der\ Oberpfalz",
"499444", "Siegenburg",
"497581", "Saulgau",
"4936085", "Reinholterode",
"492671", "Cochem",
"499763", "Sulzdorf\ an\ der\ Lederhecke",
"498434", "Rennertshofen",
"496074", "Rödermark",
"496731", "Alzey",
"4937365", "Sayda",
"495921", "Nordhorn",
"496696", "Gilserberg",
"4936252", "Tambach\-Dietharz",
"499778", "Fladungen",
"492237", "Kerpen\ Rheinland\-Türnich",
"497164", "Boll\ Kreis\ Göppingen",
"492772", "Herborn\ Hessen",
"4937364", "Reitzenhain\ Erzgebirge",
"4938303", "Sellin\ Ostseebad",
"4934422", "Osterfeld",
"497556", "Uhldingen\-Mühlhofen",
"4933052", "Leegebruch",
"4934325", "Mochau\-Lüttewitz",
"499943", "Lam\ Oberpfalz",
"495465", "Neuenkirchen\ bei\ Bramsche",
"499737", "Wartmannsroth",
"496206", "Lampertheim",
"494372", "Westfehmarn",
"4939329", "Möringen",
"4934324", "Ostrau\ Sachsen",
"499272", "Fichtelberg",
"496408", "Buseck",
"495883", "Lemgow",
"4939977", "Jördenstorf",
"4937462", "Rothenkirchen\ Vogtland",
"495802", "Wrestedt",
"499127", "Rosstal\ Mittelfranken",
"493765", "Reichenbach\ Vogtland",
"4934906", "Raguhn",
"4969", "Frankfurt\ am\ Main",
"49831", "Kempten\ Allgäu",
"494144", "Himmelpforten",
"492263", "Engelskirchen",
"4939409", "Eilsleben",
"498261", "Mindelheim",
"496185", "Hammersbach\ Hessen",
"4934466", "Janisroda",
"497525", "Aulendorf",
"496523", "Holsthum",
"495594", "Bovenden\-Reyershausen",
"495172", "Ilsede",
"497183", "Rudersberg\ Württemberg",
"4939208", "Loitsche",
"495344", "Lengede",
"4939399", "Kleinau",
"492931", "Arnsberg",
"499279", "Mistelgau",
"49209", "Gelsenkirchen",
"493378", "Ludwigsfelde",
"496243", "Monsheim",
"499906", "Mariaposching",
"497245", "Durmersheim",
"499845", "Oberdachstetten",
"4939201", "Wolmirstedt",
"4939038", "Henningen",
"498361", "Nesselwang",
"496500", "Waldrach",
"497250", "Kraichtal",
"4934691", "Könnern",
"4939483", "Ballenstedt",
"498370", "Wiggensbach",
"495524", "Bad\ Lauterberg\ im\ Harz",
"495776", "Preussisch\ Ströhen",
"496593", "Hillesheim\ Eifel",
"4939821", "Carpin",
"495244", "Rietberg",
"495327", "Bad\ Grund\ Harz",
"496837", "Wallerfangen",
"4939031", "Dähre",
"496343", "Bad\ Bergzabern",
"49202", "Wuppertal",
"494845", "Ostenfeld\ Husum",
"4937202", "Claussnitz\ bei\ Chemnitz",
"497706", "Oberbaldingen",
"497345", "Langenau\ Württemberg",
"4939828", "Wustrow\ Kreis\ Mecklenburg\-Strelitz",
"493476", "Hettstedt\ Sachsen\-Anhalt",
"4936200", "Elxleben\ bei\ Arnstadt",
"492378", "Fröndenberg\-Langschede",
"497937", "Dörzbach",
"497743", "Ühlingen\-Birkendorf",
"493931", "Stendal",
"4936943", "Bettenhausen\ Thüringen",
"496306", "Trippstadt",
"494272", "Siedenburg",
"494737", "Stadland\-Schwei",
"494943", "Grossefehn",
"499372", "Klingenberg\ am\ Main",
"496745", "Gondershausen",
"4935772", "Rietschen",
"497464", "Talheim\ Kreis\ Tuttlingen",
"498724", "Massing",
"499144", "Pleinfeld",
"496421", "Marburg",
"4933742", "Oehna\ Brandenburg",
"4933984", "Blumenthal\ bei\ Pritzwalk",
"499197", "Egloffstein",
"498134", "Odelzhausen",
"49821", "Augsburg",
"492363", "Datteln",
"494127", "Westerhorn",
"4934206", "Rötha",
"498683", "Tittmoning",
"494148", "Drochtersen\-Assel",
"4938781", "Mellen",
"4936695", "Söllmnitz",
"498453", "Reichertshofen\ Oberbayern",
"492305", "Castrop\-Rauxel",
"4939400", "Wefensleben",
"4936694", "Schkölen\ Thüringen",
"4938788", "Gross\ Warnow",
"4939487", "Friedrichsbrunn",
"496404", "Lich\ Hessen",
"492274", "Elsdorf\ Rheinland",
"4939390", "Iden",
"497366", "Abtsgmünd",
"4939320", "Schinne",
"4935246", "Ziegenhain\ Sachsen",
"496766", "Kisselbach",
"498052", "Aschau\ im\ Chiemgau",
"497571", "Sigmaringen",
"4936624", "Teichwolframsdorf",
"495635", "Vöhl",
"496084", "Schmitten\ Taunus",
"492451", "Geilenkirchen",
"4936947", "Jüchsen",
"494623", "Böklund",
"492681", "Altenkirchen\ Westerwald",
"4936625", "Langenwetzendorf",
"495446", "Rehden",
"4936968", "Rossdorf\ Rhön",
"496162", "Reinheim\ Odenwald",
"4935476", "Wittmannsdorf\-Bückchen",
"495248", "Langenberg\ Kreis\ Gütersloh",
"4939856", "Beenz\ bei\ Prenzlau",
"4939973", "Altkalen",
"495528", "Gieboldehausen",
"4933976", "Wutike",
"497634", "Sulzburg",
"495659", "Ringgau",
"4936961", "Bad\ Liebenstein",
"495962", "Herzlake",
"498551", "Freyung",
"497072", "Gomaringen",
"495083", "Hohne\ bei\ Celle",
"4934656", "Wallhausen\ Sachsen\-Anhalt",
"492553", "Ochtrup",
"4933475", "Letschin",
"498035", "Raubling",
"496475", "Weilmünster\-Wolfenhausen",
"498138", "Schwabhausen\ bei\ Dachau",
"4938334", "Grammendorf",
"493681", "Suhl",
"497473", "Mössingen",
"495482", "Tecklenburg",
"4933474", "Neutrebbin",
"492205", "Rösrath",
"495652", "Bad\ Sooden\-Allendorf",
"497457", "Rottenburg\-Ergenzingen",
"499148", "Ettenstatt",
"496888", "Lebach\-Steinbach",
"498728", "Geratskirchen",
"495403", "Bad\ Iburg",
"4935974", "Hinterhermsdorf",
"4936209", "Klettbach",
"4933632", "Hangelsberg",
"4935975", "Hohnstein",
"492374", "Iserlohn\-Letmathe",
"497266", "Kirchardt",
"495751", "Rinteln",
"4935342", "Mühlberg\ Elbe",
"496104", "Heusenstamm",
"494526", "Ascheberg\ Holstein",
"494774", "Hechthausen",
"4938427", "Blowatz",
"498392", "Markt\ Rettenbach",
"497974", "Bühlerzell",
"494289", "Kirchtimke",
"4939728", "Medow\ bei\ Anklam",
"498222", "Burgau\ Schwaben",
"495064", "Gross\ Düngen",
"498153", "Wessling",
"498542", "Ortenburg",
"495904", "Lengerich\ Emsl",
"4935439", "Zinnitz",
"499346", "Grünsfeld",
"498177", "Münsing\ Starnberger\ See",
"492538", "Drensteinfurt\-Rinkerode",
"492695", "Insul",
"499532", "Maroldsweisach",
"494246", "Twistringen\-Heiligenloh",
"4939721", "Liepen\ bei\ Anklam",
"498380", "Achberg",
"498336", "Erkheim",
"4938307", "Poseritz",
"495641", "Warburg",
"494555", "Seedorf\ bei\ Bad\ Segeberg",
"4939452", "Ilsenburg",
"494320", "Heidmühlen",
"499303", "Eibelstadt",
"498549", "Vilshofen\-Pleinting",
"494203", "Weyhe\ bei\ Bremen",
"499220", "Kasendorf\-Azendorf",
"492151", "Krefeld",
"498807", "Diessen\ am\ Ammersee",
"494282", "Sittensen",
"492388", "Hamm\-Uentrop",
"495742", "Preussisch\ Oldendorf",
"498586", "Hauzenberg",
"496874", "Wadern\-Nunkirchen",
"493966", "Cölpin",
"4935872", "Neusalza\-Spremberg",
"499382", "Gerolzhofen",
"492043", "Gladbeck",
"4936076", "Niederorschel",
"499203", "Neudrossenfeld",
"497803", "Gengenbach",
"496805", "Kleinblittersdorf",
"494303", "Schlesen",
"494539", "Westerau",
"499555", "Schlüsselfeld\-Aschbach",
"4938841", "Neuhaus\ Elbe",
"492449", "Blankenheim\ Ahr",
"493695", "Bad\ Salzungen",
"494382", "Wangels",
"498664", "Chieming",
"495146", "Wietze",
"495857", "Bleckede\-Brackede",
"492656", "Virneburg",
"4938848", "Vellahn",
"499282", "Naila",
"495873", "Eimke",
"496462", "Gladenbach",
"492486", "Nettersheim",
"4933438", "Altlandsberg",
"495975", "Rheine\-Mesum",
"4937600", "Neumark\ Sachsen",
"4938378", "Heringsdorf\ Seebad",
"499289", "Schwarzenbach\ am\ Wald",
"495103", "Wennigsen\ Deister",
"499774", "Oberelsbach",
"498292", "Dinkelscherben",
"499526", "Riedbach",
"4939086", "Jävenitz",
"4933239", "Gross\ Behnitz",
"495190", "Soltau\-Emmingen",
"4936602", "Ronneburg\ Thüringen",
"496063", "Bad\ König",
"4933083", "Schulzendorf\ Kreis\ Oberhavel",
"498322", "Oberstdorf",
"4935931", "Königswartha",
"496078", "Gross\-Umstadt",
"496175", "Friedrichsdorf\ Taunus",
"499246", "Pegnitz\-Trockau",
"494532", "Bargteheide",
"494705", "Wremen",
"4938371", "Karlshagen",
"499448", "Hausen\ Niederbayern",
"497905", "Langenburg",
"494346", "Gettorf",
"497157", "Waldenbuch",
"4935938", "Grosspostwitz\ OL",
"497173", "Heubach",
"498041", "Bad\ Tölz",
"495182", "Gronau\ Leine",
"492625", "Ochtendung",
"498236", "Fischach",
"496042", "Büdingen\ Hessen",
"494864", "Oldenswort",
"496406", "Lollar",
"495265", "Dörentrup",
"499472", "Hohenfels\ Oberpfalz",
"497629", "Tegernau\ Baden",
"497364", "Oberkochen",
"497558", "Illmensee",
"493561", "Guben",
"499607", "Luhe\-Wildenau",
"4934742", "Sylda",
"496321", "Neustadt\ an\ der\ Weinstrasse",
"497567", "Leutkirch\-Friesenhofen",
"496291", "Adelsheim",
"492744", "Herdorf",
"495831", "Wittingen",
"49251", "Münster",
"4933206", "Fichtenwalde",
"492463", "Titz",
"4939203", "Barleben",
"497721", "Villingen\ im\ Schwarzwald",
"498461", "Beilngries",
"493727", "Mittweida",
"499165", "Sugenheim",
"496086", "Grävenwiesbach",
"4936332", "Ellrich",
"4936967", "Geisa",
"494921", "Emden\ Stadt",
"492983", "Winterberg\-Siedlinghausen",
"495427", "Melle\-Buer",
"497622", "Schopfheim",
"4935205", "Ottendorf\-Okrilla",
"496443", "Ehringshausen\ Dill",
"497131", "Heilbronn\ Neckar",
"492902", "Warstein",
"496049", "Kefenrod",
"497445", "Pfalzgrafenweiler",
"499908", "Schöfweg",
"4935266", "Heyda\ bei\ Riesa",
"4935204", "Wilsdruff",
"496764", "Rheinböllen",
"499073", "Gundelfingen\ an\ der\ Donau",
"493744", "Auerbach\ Vogtland",
"499921", "Regen",
"497636", "Münstertal\ Schwarzwald",
"4935825", "Kodersdorf",
"492561", "Ahaus",
"4936941", "Wasungen",
"4935326", "Schönborn\ Kreis\ Elbe\-Elster",
"494165", "Hollenstedt\ Nordheide",
"49351", "Dresden",
"4933394", "Blumberg\ Kreis\ Barnim",
"495444", "Wagenfeld",
"4936948", "Römhild",
"497708", "Geisingen\-Leipferdingen",
"4933395", "Zerpenschleuse",
"495763", "Uchte",
"493909", "Klötze\ Altmark",
"494479", "Molbergen\-Peheim",
"493902", "Diesdorf\ Altm",
"492137", "Neuss\-Norf",
"494472", "Lastrup",
"495365", "Wolfsburg\-Neindorf",
"496308", "Olsbrücken",
"4939481", "Hedersleben\ bei\ Aschersleben",
"496541", "Traben\-Trarbach",
"497264", "Bad\ Rappenau",
"4939823", "Rechlin",
"496221", "Heidelberg",
"496391", "Dahn",
"4935894", "Hähnichen",
"4939033", "Wallstawe",
"4933965", "Herzsprung\ bei\ Wittstock",
"4938787", "Glöwen",
"498563", "Bad\ Birnbach\ Rottal",
"4933964", "Fretzdorf",
"4935895", "Klitten",
"4939488", "Güntersberge",
"494607", "Janneby",
"49841", "Ingolstadt\ Donau",
"495906", "Lünne",
"499397", "Wertheim\-Dertingen",
"499344", "Gerchsheim",
"493821", "Ribnitz\-Damgarten",
"499227", "Neuenmarkt",
"494244", "Harpstedt",
"4938377", "Zinnowitz",
"492163", "Schwalmtal\ Niederrhein",
"494327", "Grossenaspe",
"4933437", "Reichenberg\ bei\ Strausberg",
"498334", "Bad\ Grönenbach",
"494297", "Ottersberg\-Posthausen",
"495845", "Bergen\ Dumme",
"4935362", "Schönewalde\ bei\ Herzberg",
"498537", "Bad\ Füssing\-Aigen",
"496106", "Rodgau",
"4935937", "Prischwitz",
"494776", "Osten\-Altendorf",
"494524", "Scharbeutz\-Pönitz",
"497976", "Sulzbach\-Laufen",
"496559", "Leidenborn",
"499547", "Zapfendorf",
"496628", "Oberaula",
"499172", "Georgensgmünd",
"495066", "Sarstedt",
"496552", "Olzheim",
"497431", "Albstadt\-Ebingen",
"493437", "Grimma",
"497202", "Karlsbad",
"499802", "Ansbach\-Katterbach",
"499179", "Freystadt",
"495127", "Harsum",
"496876", "Weiskirchen\ Saar",
"493964", "Bredenfelde\ bei\ Strasburg",
"498584", "Breitenberg\ Niederbayern",
"497145", "Markgröningen",
"495943", "Emlichheim",
"499465", "Neukirchen\-Balbini",
"4938847", "Boizenburg\ Elbe",
"496285", "Walldürn\-Altheim",
"498161", "Freising",
"498387", "Weiler\-Simmerberg",
"495272", "Brakel\ Westfalen",
"49345", "Halle\ Saale",
"498170", "Strasslach\-Dingharting",
"498666", "Teisendorf",
"495197", "Soltau\-Frielingen",
"497302", "Pfaffenhofen\ an\ der\ Roth",
"495144", "Wathlingen",
"494802", "Wrohm",
"492654", "Polch",
"4938308", "Göhren\ Rügen",
"494179", "Winsen\-Tönnhausen",
"496709", "Fürfeld\ Kreis\ Bad\ Kreuznach",
"4938752", "Zierzow\ bei\ Ludwigslust",
"496051", "Gelnhausen",
"492484", "Mechernich\-Eiserfey",
"496385", "Reichenbach\-Steegen",
"492821", "Kleve\ Niederrhein",
"494883", "Süderstapel",
"497150", "Korntal\-Münchingen",
"4938301", "Putbus",
"494465", "Friedeburg\ Ostfriesland",
"495372", "Meinersen",
"497383", "Münsingen\-Buttenhausen",
"4938428", "Hohenkirchen\ bei\ Wismar",
"497844", "Rheinau",
"4939727", "Spantekow",
"499244", "Betzenstein",
"495379", "Sassenburg\-Grussendorf",
"494344", "Schönberg\ Holstein",
"49811", "Hallbergmoos",
"4938229", "Bad\ Sülze",
"498234", "Bobingen",
"498823", "Mittenwald",
"496783", "Baumholder",
"495850", "Neetze",
"494172", "Salzhausen",
"496535", "Osann\-Monzel",
"4937384", "Wechselburg",
"494547", "Gudow\ Lauenburg",
"499524", "Zeil\ am\ Main",
"499776", "Mellrichstadt",
"497533", "Allensbach",
"496698", "Schrecksbach",
"497309", "Weissenhorn",
"492964", "Brilon\-Alme",
"496624", "Heringen\ Werra",
"495693", "Volkmarsen",
"494962", "Papenburg\-Aschendorf",
"493529", "Heidenau\ Sachsen",
"494489", "Apen",
"494528", "Schönwalde\ am\ Bungsberg",
"499635", "Bärnau",
"492592", "Selm",
"498422", "Dollnstein",
"492174", "Burscheid\ Rheinland",
"497762", "Wehr\ Baden",
"498338", "Böhen",
"4935725", "Wittichenau",
"494248", "Bassum\-Neubruchhausen",
"492536", "Münster\-Albachten",
"4935724", "Lohsa",
"494446", "Bakum\ Kreis\ Vechta",
"499348", "Werbach\-Gamburg",
"496851", "St\ Wendel",
"497661", "Kirchzarten",
"494751", "Otterndorf",
"494403", "Bad\ Zwischenahn",
"4935795", "Königsbrück",
"497951", "Crailsheim",
"493973", "Pasewalk",
"499420", "Feldkirchen\ Niederbayern",
"494482", "Hatten",
"497044", "Mönsheim",
"492804", "Xanten\-Marienbaum",
"492599", "Ascheberg\-Herbern",
"493968", "Schönbeck",
"4939723", "Krien",
"498023", "Bayrischzell",
"492330", "Herdecke",
"496362", "Alsenz",
"493522", "Grossenhain\ Sachsen",
"4938220", "Wustrow\ Ostseebad",
"493342", "Neuenhagen\ bei\ Berlin",
"49761", "Freiburg\ im\ Breisgau",
"499403", "Donaustauf",
"492667", "Stein\-Neukirch",
"4935933", "Neschwitz",
"492529", "Oelde\-Stromberg",
"4933433", "Buckow\ Märkische\ Schweiz",
"4938373", "Katzow",
"495045", "Springe\-Bennigsen",
"499652", "Waidhaus",
"493592", "Kirschau",
"495148", "Steinhorst\ Niedersachsen",
"498093", "Glonn\ Kreis\ Ebersberg",
"496262", "Aglasterhausen",
"499482", "Wörth\ an\ der\ Donau",
"4933088", "Falkenthal",
"499659", "Leuchtenberg",
"494635", "Sörup",
"496647", "Herbstein\-Stockhausen",
"4939004", "Köckte\ bei\ Gardelegen",
"495623", "Edertal",
"496694", "Neukirchen\ Knüll",
"496269", "Gundelsheim\ Württemberg",
"499528", "Donnersdorf",
"492522", "Oelde",
"499083", "Möttingen",
"497166", "Adelberg",
"4939005", "Kusey",
"493386", "Premnitz",
"4938456", "Langhagen\ bei\ Güstrow",
"4937344", "Crottendorf\ Sachsen",
"4939934", "Gross\ Plasten",
"4938843", "Bennin",
"499962", "Schwarzach\ Niederbayern",
"498238", "Gessertshausen",
"494501", "Kastorf\ Holstein",
"492242", "Hennef\ Sieg",
"494348", "Schönkirchen",
"499446", "Altmannstein",
"498650", "Marktschellenberg",
"492973", "Eslohe\ Sauerland",
"492957", "Wünnenberg\-Haaren",
"494857", "Barlt",
"4933656", "Bahro",
"494873", "Aukrug",
"498253", "Pöttmes",
"499742", "Kalbach\ Rhön",
"496375", "Wallhalben",
"497373", "Zwiefalten",
"495382", "Bad\ Gandersheim",
"497357", "Attenweiler",
"494146", "Stade\-Bützfleth",
"498505", "Hutthurm",
"498732", "Frontenhausen",
"4934782", "Mansfeld\ Südharz",
"495303", "Wendeburg",
"493869", "Dümmer",
"497554", "Heiligenberg\ Baden",
"499641", "Grafenwöhr",
"4934632", "Mücheln\ Geiseltal",
"496204", "Viernheim",
"492474", "Nideggen\-Schmidt",
"498122", "Erding",
"4938852", "Wittenburg",
"494189", "Undeloh",
"498631", "Mühldorf\ am\ Inn",
"495346", "Liebenburg",
"492633", "Brohl\-Lützing",
"4938783", "Dallmin",
"494182", "Tostedt",
"4939832", "Wesenberg",
"499904", "Lalling",
"4939037", "Pretzier",
"495532", "Stadtoldendorf",
"495705", "Petershagen\-Windheim",
"4934976", "Gröbzig",
"4939827", "Schwarz\ bei\ Neustrelitz",
"4934446", "Grosskorbetha",
"497775", "Mühlingen",
"492251", "Euskirchen",
"499120", "Leinburg",
"496773", "Kamp\-Bornhofen",
"494975", "Westerholt\ Ostfriesland",
"496757", "Becherbach\ bei\ Kirn",
"499749", "Oberbach\ Unterfranken",
"494103", "Wedel",
"495246", "Verl",
"495031", "Wunstorf",
"4939207", "Colbitz",
"497704", "Geisingen\ Baden",
"499182", "Velburg",
"495448", "Barver",
"497930", "Boxberg\ Baden",
"499103", "Cadolzburg",
"494749", "Schiffdorf\-Geestenseth",
"494120", "Ellerhoop",
"499975", "Waldmünchen\-Geigant",
"496842", "Blieskastel",
"492351", "Lüdenscheid",
"495774", "Wagenfeld\-Ströhen",
"499190", "Heroldsbach",
"497949", "Pfedelbach\-Untersteinbach",
"499146", "Markt\ Berolzheim",
"498377", "Unterthingau",
"4933762", "Zeuthen",
"4939978", "Gross\ Roge",
"497942", "Neuenstein\ Württemberg",
"496275", "Rothenberg\ Odenwald",
"495282", "Schieder\-Schwalenberg",
"497273", "Hagenbach\ Pfalz",
"496507", "Neumagen\-Dhron",
"492405", "Würselen",
"498136", "Markt\ Indersdorf",
"499873", "Abenberg\-Wassermungenau",
"494742", "Dorum",
"4934244", "Mockrehna",
"499857", "Schopfloch\ Mittelfranken",
"497257", "Bruchsal\-Untergrombach",
"496849", "Kirkel",
"4939971", "Gnoien",
"499189", "Berg\ bei\ Neumarkt\ in\ der\ Oberpfalz",
"497268", "Bad\ Rappenau\-Obergimpern",
"495203", "Werther\ Westfalen",
"499868", "Schillingsfürst",
"496304", "Wolfstein\ Pfalz",
"4936963", "Dorndorf\ Rhön",
"495555", "Moringen\-Fredelsloh",
"495320", "Torfhaus",
"494641", "Süderbrarup",
"498192", "Schondorf\ am\ Ammersee",
"492862", "Südlohn",
"497466", "Beuron",
"498726", "Schönau\ Niederbayern",
"498574", "Wittibreut",
"498056", "Eggstätt",
"4939082", "Mieste",
"4936606", "Kraftsdorf",
"494351", "Eckernförde",
"496670", "Ludwigsau\ Hessen",
"499251", "Münchberg",
"497851", "Kehl",
"492064", "Dinslaken",
"4939887", "Gerswalde",
"496661", "Schlüchtern",
"499633", "Mitterteich",
"497624", "Grenzach\-Wyhlen",
"493868", "Rastow",
"492904", "Bestwig",
"4938723", "Kladrum",
"494188", "Welle\ Nordheide",
"495695", "Twistetal",
"496762", "Kastellaun",
"494862", "Garding",
"496044", "Schotten\ Hessen",
"4934600", "Ostrau\ Saalkreis",
"4938793", "Dergenthin",
"492641", "Bad\ Neuenahr\-Ahrweiler",
"498025", "Miesbach",
"495151", "Hameln",
"4936072", "Weissenborn\-Lüderode",
"499474", "Schmidmühlen",
"4938234", "Born\ Darss",
"497362", "Bopfingen",
"4934722", "Preusslitz",
"494405", "Edewecht",
"492742", "Wissen",
"499748", "Motten",
"498095", "Aying",
"493904", "Haldensleben",
"4933679", "Wendisch\ Rietz",
"496027", "Stockstadt\ am\ Main",
"494474", "Garrel",
"495043", "Lauenau",
"4939456", "Altenbrak",
"497262", "Eppingen",
"4933846", "Dippmannsdorf",
"49661", "Fulda",
"4935876", "Weissenberg\ Sachsen",
"4935953", "Burkau",
"494748", "Stubben\ bei\ Bremerhaven",
"499405", "Bad\ Abbach",
"497948", "Öhringen\-Ohrnberg",
"492873", "Isselburg\-Werth",
"492857", "Rees\-Mehr",
"495656", "Waldkappel",
"492103", "Hilden",
"494251", "Hoya",
"492975", "Schmallenberg\-Oberkirchen",
"4936921", "Wutha\-Farnroda",
"496848", "Homburg\-Einöd",
"499351", "Gemünden\ am\ Main",
"495966", "Meppen\-Apeldorn",
"498860", "Bernbeuren",
"4935844", "Oybin\ Kurort",
"4939954", "Stavenhagen\ Reuterstadt",
"4933874", "Stechow\ Brandenburg",
"495442", "Barnstorf\ Kreis\ Diepholz",
"4936928", "Neuenhof\ Thüringen",
"493641", "Jena",
"499085", "Alerheim",
"4937433", "Gutenfürst",
"497269", "Sulzfeld\ Baden",
"4935607", "Jänschwalde",
"499869", "Wettringen\ Mittelfranken",
"499188", "Postbauer\-Heng",
"492182", "Grevenbroich\-Kapellen",
"4939955", "Jürgenstorf",
"495625", "Naumburg\ Hessen",
"496166", "Fischbachtal",
"4933875", "Rhinow",
"494633", "Satrup",
"494230", "Verden\-Walle",
"494286", "Gyhum",
"496554", "Waxweiler",
"493528", "Radeberg",
"495746", "Rödinghausen",
"497204", "Malsch\-Völkersbach",
"498340", "Baisweil",
"499804", "Aurach",
"493962", "Penzlin\ bei\ Waren",
"4934652", "Allstedt",
"498582", "Röhrnbach",
"494488", "Westerstede",
"499386", "Prosselsheim",
"494529", "Süsel\-Bujendorf",
"495305", "Sickte",
"494249", "Bassum\-Nordwohlde",
"4938827", "Kalkhorst",
"498503", "Neuhaus\ am\ Inn",
"497375", "Obermarchtal",
"494667", "Dagebüll",
"494875", "Stafstedt",
"496373", "Schönenberg\-Kübelberg",
"499349", "Werbach\-Wenkheim",
"495274", "Nieheim",
"4933636", "Steinhöfel\ Kreis\ Oder\-Spree",
"496357", "Standenbühl",
"498546", "Windorf\-Otterskirchen",
"494105", "Seevetal",
"4935472", "Schlepzig",
"494957", "Detern",
"499342", "Wertheim",
"496775", "Strüth\ Taunus",
"494973", "Wittmund\-Burhafe",
"499536", "Kirchlauter",
"494242", "Syke",
"497773", "Bodman\-Ludwigshafen",
"498332", "Ottobeuren",
"492501", "Münster\-Hiltrup",
"495703", "Hille",
"493969", "Siedenbollentin",
"492598", "Senden\-Ottmarsbocholt",
"4939057", "Rätzlingen\ Sachsen\-Anhalt",
"494522", "Plön",
"4939852", "Schönermark\ bei\ Prenzlau",
"495681", "Homberg\ Efze",
"4933972", "Breddin",
"498226", "Bibertal",
"492635", "Rheinbrohl",
"494968", "Neulehe",
"499174", "Hilpoltstein",
"495451", "Ibbenbüren",
"4935242", "Nossen",
"497842", "Kappelrodeck",
"499242", "Gössweinstein",
"4939747", "Züsedom",
"494536", "Steinhorst\ Lauenburg",
"498753", "Elsendorf\ Niederbayern",
"492446", "Heimbach\ Eifel",
"494342", "Preetz\ Kreis\ Plön",
"499973", "Furth\ im\ Wald",
"492248", "Hennef\-Uckerath",
"498232", "Schwabmünchen",
"495130", "Wedemark",
"495186", "Salzhemmendorf\-Wallensen",
"499105", "Grosshabersdorf",
"499091", "Monheim\ Schwaben",
"494174", "Stelle\ Kreis\ Harburg",
"496704", "Langenlonsheim",
"492528", "Ennigerloh\-Enniger",
"499522", "Eltmann",
"498296", "Villenbach",
"498326", "Fischen\ im\ Allgäu",
"495149", "Wienhausen",
"492962", "Olsberg",
"494330", "Emkendorf",
"499529", "Oberaurach",
"496268", "Hüffenhardt",
"4938207", "Stäbelow",
"497304", "Blaustein\ Württemberg",
"498081", "Dorfen\ Stadt",
"495142", "Eschede",
"495553", "Kalefeld",
"499658", "Georgenberg",
"494804", "Nordhastedt",
"492652", "Mendig",
"493635", "Kölleda",
"496466", "Dautphetal\-Friedensdorf",
"499286", "Oberkotzau",
"4933831", "Weseram",
"492482", "Hellenthal",
"495205", "Bielefeld\-Sennestadt",
"494349", "Dänischenhagen",
"498239", "Langenneufnach",
"499875", "Wolframs\-Eschenbach",
"492403", "Eschweiler\ Rheinland",
"497275", "Kandel",
"493501", "Pirna",
"492751", "Bad\ Berleburg",
"4933838", "Päwesin",
"495374", "Isenbüttel",
"496257", "Seeheim\-Jugenheim",
"495278", "Höxter\-Ovenhausen",
"496567", "Oberkail",
"492465", "Inden",
"493327", "Werder\ Havel",
"497321", "Heidenheim\ an\ der\ Brenz",
"495476", "Ostercappeln\-Venne",
"494821", "Itzehoe",
"494484", "Hude\-Wüsting",
"497042", "Vaihingen\ an\ der\ Enz",
"492802", "Alpen",
"4934202", "Delitzsch",
"496629", "Schenklengsfeld",
"4939743", "Zerrenthin",
"4933746", "Werbig\ bei\ Jüterbog",
"495263", "Barntrup",
"496364", "Nussbach\ Pfalz",
"496558", "Büdesheim\ Eifel",
"499178", "Abenberg\ Mittelfranken",
"496622", "Bebra",
"494964", "Rhede\ Ems",
"499075", "Glött",
"497443", "Dornstetten",
"496131", "Mainz",
"4936701", "Lichte",
"496445", "Schöffengrund",
"492547", "Rosendahl\-Osterwick",
"492594", "Dülmen",
"498424", "Nassenfels",
"497764", "Herrischried",
"492985", "Winterberg\-Niedersfeld",
"496721", "Bingen\ am\ Rhein",
"495931", "Meppen",
"492227", "Bornheim\-Merten",
"499163", "Dachsbach",
"4938203", "Bad\ Doberan",
"4935020", "Struppen",
"4937206", "Frankenberg\ Sachsen",
"4935055", "Höckendorf\ bei\ Dippoldiswalde",
"4937325", "Niederbobritzsch",
"495765", "Raddestorf",
"496692", "Neustadt\ Hessen",
"492524", "Ennigerloh",
"492776", "Bad\ Endbach\-Hartenrod",
"496708", "Bad\ Münster\ am\ Stein\-Ebernburg",
"4938481", "Witzin",
"4937324", "Reinsberg\ Sachsen",
"4935054", "Lauenstein\ Sachsen",
"4938823", "Selmsdorf",
"494178", "Radbruch",
"4934462", "Laucha\ Unstrut",
"499964", "Stallwang",
"496636", "Romrod",
"492297", "Wildbergerhütte",
"492244", "Königswinter\-Oberpleis",
"492327", "Bochum\-Wattenscheid",
"494163", "Horneburg\ Niederelbe",
"493883", "Hagenow",
"4938488", "Demen",
"495378", "Sassenburg\-Platendorf",
"493344", "Bad\ Freienwalde",
"497221", "Baden\-Baden",
"497391", "Ehingen\ Donau",
"498565", "Dietersburg\-Baumgarten",
"4939053", "Süplingen",
"4933056", "Mühlenbeck\ Kreis\ Oberhavel",
"499654", "Pleystein",
"493594", "Bischofswerda",
"497308", "Nersingen",
"495363", "Wolfsburg\-Vorsfelde",
"496264", "Neudenau",
"497541", "Friedrichshafen",
"499484", "Brennberg",
"4939605", "Gross\ Nemerow",
"494184", "Hanstedt\ Nordheide",
"4934609", "Salzmünde",
"4939604", "Wildberg\ bei\ Altentreptow",
"497628", "Efringen\-Kirchen",
"495534", "Eschershausen\ an\ der\ Lenne",
"496209", "Mörlenbach",
"495843", "Wustrow\ Wendland",
"495337", "Kissenbrück",
"496827", "Eppelborn",
"4939999", "Tutow",
"492991", "Marsberg\-Bredelar",
"4933457", "Altreetz",
"4934426", "Kayna",
"492165", "Jüchen",
"49203", "Duisburg",
"494561", "Neustadt\ in\ Holstein",
"495176", "Edemissen",
"4936256", "Wechmar",
"495806", "Barum\ bei\ Bad\ Bevensen",
"492607", "Kobern\-Gondorf",
"493921", "Burg\ bei\ Magdeburg",
"499744", "Zeitlofs\-Detter",
"4934925", "Bad\ Schmiedeberg",
"495384", "Seesen\-Gross\ Rhüden",
"4935603", "Burg\ Spreewald",
"49951", "Bamberg",
"4937437", "Bad\ Elster",
"496283", "Hardheim\ Odenwald",
"495945", "Wilsum",
"499463", "Wald\ Oberpfalz",
"4939929", "Jabel\ bei\ Waren",
"4934496", "Nöbdenitz",
"498734", "Reisbach\ Niederbayern",
"4934924", "Zahna",
"497552", "Pfullendorf",
"498071", "Wasserburg\ am\ Inn",
"497143", "Besigheim",
"496431", "Limburg\ an\ der\ Lahn",
"496202", "Schwetzingen",
"4933731", "Trebbin",
"492472", "Monschau",
"498124", "Forstern\ Oberbayern",
"499276", "Bischofsgrün",
"4934364", "Wermsdorf",
"496145", "Flörsheim\ am\ Main",
"496048", "Büdingen\-Eckartshausen",
"494137", "Barendorf",
"4937422", "Markneukirchen",
"4936454", "Magdala",
"494463", "Wangerland",
"496150", "Weiterstadt",
"493991", "Waren\ Müritz",
"4939428", "Pabstorf",
"497385", "Gomadingen",
"49451", "Lübeck",
"499727", "Schonungen\-Marktsteinach",
"497944", "Kupferzell",
"4938727", "Mestlin",
"495284", "Schwalenberg",
"494744", "Loxstedt",
"4934224", "Belgern\ Sachsen",
"496383", "Glan\-Münchweiler",
"494885", "Bergenhusen",
"4939883", "Gross\ Dölln",
"4938732", "Gallin\ bei\ Lübz",
"496302", "Winnweiler",
"498856", "Penzberg",
"4939421", "Osterwieck",
"494276", "Borstel\ bei\ Sulingen",
"494478", "Cappeln\ Oldenburg",
"499376", "Collenberg",
"498194", "Vilgertshofen",
"492864", "Reken",
"497709", "Wutach",
"498572", "Tann\ Niederbayern",
"497051", "Calw",
"497702", "Blumberg\ Baden",
"499184", "Deining\ Oberpfalz",
"496533", "Morbach\ Hunsrück",
"494902", "Jemgum\-Ditzum",
"4939752", "Blumenhagen\ bei\ Strasburg",
"495671", "Hofgeismar",
"492921", "Soest",
"496897", "Sulzbach\ Saar",
"496785", "Herrstein",
"498825", "Krün",
"495237", "Augustdorf",
"4934294", "Rackwitz",
"496844", "Blieskastel\-Altheim",
"499561", "Coburg",
"4935386", "Prettin",
"4936873", "Themar",
"4934295", "Krensitz",
"495772", "Espelkamp",
"4939861", "Gramzow\ bei\ Prenzlau",
"4938797", "Karstädt\ Kreis\ Prignitz",
"4938320", "Tribsees",
"494486", "Edewecht\-Friedrichsfehn",
"497404", "Epfendorf",
"4933766", "Teupitz",
"492382", "Ahlen\ Westfalen",
"4933704", "Baruth\ Mark",
"494288", "Horstedt\ Kreis\ Rotenburg",
"493774", "Schwarzenberg",
"492303", "Unna",
"499151", "Hersbruck",
"498685", "Kirchanschöring",
"495474", "Stemwede\-Dielingen",
"493448", "Meuselwitz\ Thüringen",
"494625", "Jübek",
"496571", "Wittlich",
"495633", "Diemelsee",
"49760", "Oberried\ Breisgau",
"492532", "Ostbevern",
"497084", "Schömberg\ bei\ Neuenbürg",
"494442", "Lohne\ Oldenburg",
"498548", "Vilshofen\-Sandbach",
"494966", "Neubörger",
"492389", "Werne",
"492596", "Nordkirchen",
"495251", "Paderborn",
"498426", "Walting\ Kreis\ Eichstätt",
"495085", "Burgdorf\-Ehlershausen",
"493303", "Birkenwerder",
"496634", "Gemünden\ Felda",
"492246", "Lohmar\ Rheinland",
"499442", "Riedenburg",
"492448", "Hellenthal\-Rescheid",
"499625", "Kastl\ bei\ Amberg",
"4933833", "Wollin\ bei\ Brandenburg",
"498432", "Burgheim",
"498328", "Balderschwang",
"497162", "Süssen",
"492774", "Dietzhölztal",
"492526", "Sendenhorst",
"493382", "Lehnin",
"495351", "Helmstedt",
"499966", "Wiesenfelden",
"499288", "Bad\ Steben",
"496468", "Dautphetal\-Mornshausen",
"499656", "Moosbach\ bei\ Vohenstrauss",
"4933652", "Neuzelle",
"493596", "Neustadt\ in\ Sachsen",
"495405", "Hasbergen\ Kreis\ Osnabrück",
"4933093", "Fürstenberg\ Havel",
"496266", "Hassmersheim",
"494151", "Schwarzenbek",
"4938856", "Pritzier\ bei\ Hagenow",
"493346", "Seelow",
"497475", "Burladingen",
"492203", "Cologne\-Porz",
"4938354", "Wusterhusen",
"498033", "Oberaudorf",
"496473", "Leun",
"495862", "Hitzacker\ Elbe",
"496457", "Burgwald\ Eder",
"492555", "Schöppingen",
"4934636", "Schafstädt",
"4938355", "Züssow",
"495021", "Nienburg\ Weser",
"4938791", "Bad\ Wilsnack",
"4938452", "Lalendorf",
"494149", "Fredenbeck",
"492693", "Antweiler",
"495592", "Gleichen\-Bremke",
"495174", "Lahstedt",
"499451", "Schierling",
"499681", "Windischeschenbach",
"4939062", "Bebertal",
"4936840", "Trusetal",
"498067", "Tuntenhausen",
"4936734", "Leutenberg",
"494186", "Buchholz\-Trelde",
"4936735", "Probstzella",
"493866", "Cambs",
"495536", "Holzminden\-Neuhaus",
"4934345", "Bad\ Lausick",
"4939349", "Parey\ Elbe",
"4939427", "Ströbeck",
"499274", "Hollfeld",
"4934344", "Kohren\-Sahlis",
"4938728", "Domsühl",
"495804", "Rätzlingen\ Kreis\ Uelzen",
"4936370", "Grossenehrich",
"494205", "Ottersberg",
"499746", "Zeitlofs",
"493623", "Friedrichroda",
"499305", "Estenfeld",
"4938721", "Ziegendorf",
"494553", "Geschendorf",
"494142", "Steinkirchen\ Kreis\ Stade",
"495875", "Emmendorf",
"4937438", "Bad\ Brambach",
"4936923", "Treffurt",
"494274", "Varrel\ bei\ Sulingen",
"499374", "Eschau",
"492866", "Dorsten\-Rhade",
"498196", "Pürgen",
"498722", "Gangkofen",
"497462", "Immendingen",
"499142", "Treuchtlingen",
"499553", "Ebrach\ Oberfranken",
"493693", "Meiningen",
"495658", "Wehretal",
"495529", "Rhumspringe",
"496803", "Mandelbachtal\-Ommersheim",
"4937431", "Mehltheuer\ Vogtland",
"494305", "Westensee",
"497946", "Bretzfeld",
"495286", "Ottenstein\ Niedersachsen",
"497805", "Appenweier",
"494746", "Hagen\ bei\ Bremerhaven",
"499205", "Vorbach",
"498621", "Trostberg",
"492045", "Bottrop\-Kirchhellen",
"498139", "Röhrmoos",
"492623", "Ransbach\-Baumbach",
"494681", "Wyk\ auf\ Föhr",
"497175", "Leinzell",
"497903", "Mainhardt",
"494451", "Varel\ Jadebusen",
"494703", "Loxstedt\-Donnern",
"499149", "Weissenburg\-Suffersheim",
"4933451", "Heckelberg",
"496157", "Pfungstadt",
"495522", "Osterode\ am\ Harz",
"499720", "Üchtelhausen",
"496173", "Kronberg\ im\ Taunus",
"495242", "Rheda\-Wiedenbrück",
"4935951", "Neukirch\ Lausitz",
"499186", "Lauterhofen\ Oberpfalz",
"497063", "Bad\ Wimpfen",
"495957", "Lindern\ Oldenburg",
"4937757", "Rittersgrün",
"495105", "Barsinghausen",
"4933458", "Falkenberg\ Mark",
"495973", "Neuenkirchen\ Kreis\ Steinfurt",
"499931", "Plattling",
"496003", "Rosbach\ von\ der\ Höhe",
"497626", "Kandern",
"4935601", "Peitz",
"492845", "Neukirchen\-Vluyn",
"493372", "Jüterbog",
"496409", "Biebertal",
"495163", "Fallingbostel\-Dorfmark",
"497965", "Ellwangen\-Röhlingen",
"498054", "Breitbrunn\ am\ Chiemsee",
"497191", "Backnang",
"4936644", "Hirschberg\ Saale",
"496082", "Niederreifenberg",
"4933733", "Stülpe",
"492066", "Duisburg\-Homberg",
"4936927", "Unterellen",
"494765", "Ebersdorf\ bei\ Bremervörde",
"4935608", "Gross\ Ossnig",
"4936379", "Holzengel",
"4936645", "Mühltroff",
"497485", "Empfingen",
"496865", "Mettlach\-Orscholz",
"494363", "Lensahn",
"4938756", "Grabow",
"4936849", "Kleinschmalkalden",
"497655", "Feldberg\-Altglashütten",
"496653", "Burghaun",
"496677", "Neuenstein\ Hessen",
"499263", "Ludwigsstadt",
"496483", "Selters\ Taunus",
"495808", "Gerdau",
"496231", "Hochdorf\-Assenheim",
"496046", "Ortenberg\ Hessen",
"499278", "Weidenberg",
"492943", "Erwitte",
"4934384", "Grossbothen",
"496402", "Hungen",
"493379", "Mahlow",
"492737", "Netphen\-Deuz",
"4939389", "Schollene",
"492272", "Bedburg\ Erft",
"4934385", "Mutzschen",
"494263", "Scheessel",
"4933925", "Wustrau\-Altfriesack",
"498867", "Rottenbuch\ Oberbayern",
"495484", "Lienen\-Kattenvenne",
"4936878", "Oberland",
"495654", "Herleshausen",
"4933924", "Rägelin",
"499363", "Arnstein\ Unterfranken",
"496331", "Pirmasens",
"4933365", "Lüdersdorf\ Kreis\ Barnim",
"499378", "Eichenbühl\-Riedern",
"495821", "Bad\ Bevensen",
"4933364", "Gross\ Ziethen\ Kreis\ Barnim",
"4936871", "Bad\ Colberg\-Heldburg",
"498858", "Kochel\-Walchensee",
"492372", "Hemer",
"4939863", "Seehausen\ bei\ Prenzlau",
"497731", "Singen\ Hohentwiel",
"492379", "Menden\-Asbeck",
"493737", "Rochlitz",
"493943", "Wernigerode",
"4939888", "Lychen",
"496020", "Heigenbrücken",
"496164", "Reichelsheim\ Odenwald",
"4933609", "Brieskow\-Finkenheerd",
"494931", "Norden",
"495437", "Menslage",
"499765", "Trappstadt",
"4939881", "Ringenwalde\ bei\ Templin",
"497632", "Badenweiler",
"496581", "Saarburg",
"492850", "Rees\-Haldern",
"497121", "Reutlingen",
"4939423", "Wegeleben",
"495964", "Lähden",
"49375", "Zwickau",
"492265", "Reichshof\-Eckenhagen",
"4936703", "Gräfenthal",
"4938208", "Kavelstorf",
"494950", "Holtland",
"493763", "Glauchau",
"495909", "Wettrup",
"495276", "Marienmünster",
"496556", "Pronsfeld",
"494284", "Selsingen",
"4933837", "Brielow",
"495744", "Hüllhorst",
"492831", "Geldern",
"495069", "Nordstemmen",
"499945", "Arnbruck",
"496872", "Losheim\ am\ See",
"496109", "Frankfurt\-Bergen\-Enkheim",
"499384", "Schwanfeld",
"4938201", "Gelbensande",
"49551", "Göttingen",
"494779", "Freiburg\ Elbe",
"4935322", "Doberlug\-Kirchhain",
"496102", "Neu\-Isenburg",
"494772", "Oberndorf\ Oste",
"499843", "Burgbernheim",
"497243", "Ettlingen",
"499337", "Gaukönigshofen",
"498394", "Lautrach",
"496245", "Biblis",
"497972", "Gschwend\ bei\ Gaildorf",
"494237", "Bendingbostel",
"4939748", "Viereck",
"498224", "Offingen\ Donau",
"498347", "Friesenried",
"495062", "Holle\ bei\ Hildesheim",
"499176", "Allersberg",
"498544", "Eging\ am\ See",
"495902", "Freren",
"492427", "Nideggen",
"496525", "Irrel",
"494671", "Bredstedt",
"496183", "Erlensee",
"499534", "Burgpreppach",
"4939741", "Jatznick",
"49871", "Landshut",
"4936336", "Klettenberg",
"494176", "Marschacht",
"495561", "Einbeck",
"493831", "Stralsund",
"4939779", "Eggesin",
"496706", "Wallhausen\ Nahe",
"4938461", "Bützow",
"497837", "Oberharmersbach",
"492778", "Siegbach",
"497343", "Buch\ bei\ Illertissen",
"4934774", "Röblingen\ am\ See",
"499772", "Bischofsheim\ an\ der\ Rhön",
"496345", "Albersweiler",
"498294", "Horgau",
"4939051", "Calvörde",
"494337", "Jevenstedt",
"498669", "Traunreut",
"494843", "Viöl",
"498324", "Hindelang",
"4934775", "Wippra",
"498247", "Bad\ Wörishofen",
"496595", "Dockweiler",
"494534", "Steinburg\ Kreis\ Storman",
"492444", "Schleiden\-Gemünd",
"4936025", "Körner",
"499671", "Oberviechtach",
"492763", "Drolshagen\-Bleche",
"495184", "Freden\ Leine",
"4939058", "Uthmöden",
"4936024", "Diedorf\ bei\ Mühlhausen",
"496638", "Schwalmtal\-Renzendorf",
"498761", "Moosburg\ an\ der\ Isar",
"492365", "Marl",
"495137", "Seelze",
"4938483", "Brüel",
"4938821", "Lüdersdorf",
"495376", "Wesendorf\ Kreis\ Gifhorn",
"499779", "Nordheim\ von\ der\ Rhön",
"494384", "Selent",
"498662", "Siegsdorf\ Kreis\ Traunstein",
"494945", "Grossefehn\-Timmel",
"4933202", "Töplitz",
"497306", "Vöhringen\ Iller",
"496743", "Bacharach",
"497745", "Jestetten",
"4938828", "Schönberg",
"494806", "Sarzbüttel",
"4934746", "Giersleben",
"499284", "Schwarzenbach\ an\ der\ Saale",
"496464", "Angelburg",
"4934348", "Frohburg",
"492836", "Wachtendonk",
"497432", "Albstadt\-Tailfingen",
"496551", "Prüm",
"4938724", "Siggelkow",
"4938725", "Gross\ Godems",
"49214", "Leverkusen",
"4934341", "Geithain",
"494828", "Lägerdorf",
"495271", "Höxter",
"497328", "Königsbronn",
"492504", "Telgte",
"496728", "Ober\-Hilbersheim",
"4936731", "Unterloquitz",
"497440", "Bad\ Rippoldsau",
"497033", "Weil\ Der\ Stadt",
"4934297", "Liebertwolkwitz",
"492307", "Kamen",
"4938233", "Prerow\ Ostseebad",
"495454", "Hörstel\-Riesenbeck",
"499171", "Roth\ Mittelfranken",
"4936738", "Königsee",
"496138", "Mommenheim",
"495684", "Frielendorf",
"496035", "Reichelsheim\ Wetterau",
"4938794", "Cumlosen",
"4935955", "Pulsnitz",
"4939607", "Kotelow",
"499676", "Winklarn",
"4935954", "Grossharthau",
"498404", "Oberdolling",
"496059", "Jossgrund",
"493836", "Wolgast",
"497455", "Dornhan",
"496701", "Sprendlingen\ Rheinhessen",
"494171", "Winsen\ Luhe",
"497685", "Gutach\-Bleibach",
"4939346", "Tucheim",
"499094", "Tagmersheim",
"4933454", "Wölsickendorf\/Wollenberg",
"492207", "Kürten\-Dürscheid",
"492575", "Greven\-Reckenfeld",
"496477", "Greifenstein\-Nenderoth",
"496683", "Ehrenberg\ Rhön",
"496453", "Gemünden\ Wohra",
"4937435", "Reuth\ bei\ Plauen",
"493307", "Zehdenick",
"498084", "Taufkirchen\ Vils",
"4937434", "Bobenneukirchen",
"496052", "Bad\ Orb",
"4939953", "Schwinkendorf",
"4934927", "Globig\-Bleddin",
"4933873", "Grosswudicke",
"4935843", "Hirschfelde\ bei\ Zittau",
"4938750", "Malliss",
"492822", "Emmerich",
"497426", "Gosheim",
"498766", "Gammelsdorf",
"4935456", "Terpt",
"495371", "Gifhorn",
"497228", "Forbach",
"499828", "Rügland",
"492754", "Bad\ Laasphe\-Feudingen",
"493504", "Dippoldiswalde",
"494354", "Fleckeby",
"4934639", "Wallendorf\ Luppe",
"498462", "Berching",
"497722", "Triberg\ im\ Schwarzwald",
"496664", "Sinntal\-Sterbfritz",
"495839", "Wittingen\-Ohrdorf",
"494922", "Borkum",
"4935057", "Hermsdorf\ Erzgebirge",
"4937327", "Rechenberg\-Bienenmühle",
"4938859", "Alt\ Zachun",
"497854", "Kehl\-Goldscheuer",
"496329", "Weidenthal\ Pfalz",
"499254", "Gefrees",
"497132", "Neckarsulm",
"498805", "Hohenpeissenberg",
"4936330", "Grossberndten",
"497621", "Lörrach",
"499936", "Wallerfing",
"495840", "Schnackenburg",
"494557", "Blunk",
"492644", "Linz\ am\ Rhein",
"492697", "Blankenheim\-Ahrhütte",
"496236", "Neuhofen\ Pfalz",
"4933708", "Rangsdorf",
"496041", "Glauburg",
"497139", "Neuenstadt\ am\ Kocher",
"496438", "Hünfelden",
"499471", "Burglengenfeld",
"495154", "Aerzen",
"495832", "Hankensbüttel",
"498063", "Feldkirchen\-Westerham",
"4933701", "Grossbeeren",
"494929", "Ihlow\ Kreis\ Aurich",
"496292", "Seckach",
"4936482", "Triptis",
"496322", "Bad\ Dürkheim",
"493562", "Forst\ Lausitz",
"498469", "Freystadt\-Burggriesbach",
"497729", "Tennenbronn",
"493928", "Schönebeck\ Elbe",
"495826", "Suderburg",
"492627", "Braubach",
"494471", "Cloppenburg",
"497907", "Schwäbisch\ Hall\-Sulzdorf",
"496336", "Dellfeld",
"493901", "Salzwedel",
"494707", "Langen\-Neuenwalde",
"4938351", "Mesekenhagen",
"496542", "Bullay",
"49201", "Essen",
"496392", "Hauenstein\ Pfalz",
"496222", "Wiesloch",
"498104", "Sauerlach",
"495953", "Börger",
"493998", "Demmin",
"499929", "Ruhmannsfelden",
"495977", "Spelle",
"492562", "Gronau\ Westfalen",
"497126", "Burladingen\-Melchingen",
"494254", "Eystrup",
"496586", "Beuren\ Hochwald",
"495855", "Nahrendorf",
"499922", "Zwiesel",
"492928", "Soest\-Ostönnen",
"495663", "Spangenberg",
"496229", "Neckarsteinach",
"499568", "Neustadt\ bei\ Coburg",
"499354", "Rieneck",
"499573", "Staffelstein\ Oberfranken",
"493644", "Apolda",
"4933769", "Töpchin",
"497736", "Tengen",
"494936", "Grossheide",
"4939242", "Prödel",
"494181", "Buchholz\ in\ der\ Nordheide",
"498639", "Neumarkt\-Sankt\ Veit",
"497675", "Bernau\ Baden",
"494367", "Grossenbrode",
"49281", "Wesel",
"4939744", "Rothenklempenow",
"496657", "Hofbieber",
"495531", "Holzminden",
"496673", "Haunetal",
"4939745", "Hetzdorf\ bei\ Strasburg",
"493861", "Plate",
"499267", "Nordhalben",
"492585", "Warendorf\-Hoetmar",
"492994", "Marsberg\-Westheim",
"498640", "Reit\ Im\ Winkl",
"492947", "Anröchte",
"492733", "Hilchenbach",
"495026", "Steimbke",
"496668", "Birstein\-Lichenroth",
"495605", "Kaufungen\ Hessen",
"494358", "Loose\ bei\ Eckernförde",
"494564", "Schashagen",
"492252", "Zülpich",
"499741", "Bad\ Brückenau",
"4938204", "Broderstorf",
"496007", "Rosbach\-Rodheim",
"4938850", "Gammelin",
"4938205", "Tessin\ bei\ Rostock",
"498731", "Dingolfing",
"492335", "Wetter\ Ruhr",
"495167", "Walsrode\-Westenholz",
"495381", "Seesen",
"494495", "Friesoythe\-Thüle",
"495158", "Hemeringen",
"499642", "Kemnath\ Stadt",
"495055", "Fassberg",
"498074", "Schnaitsee",
"496434", "Bad\ Camberg",
"4939776", "Hintersee",
"498121", "Markt\ Schwaben",
"497941", "Öhringen",
"493733", "Annaberg\-Buchholz",
"493947", "Thale",
"493994", "Malchin",
"492359", "Kierspe",
"492235", "Erftstadt",
"494741", "Nordholz\ bei\ Bremerhaven",
"495281", "Bad\ Pyrmont",
"495433", "Badbergen",
"4935692", "Kerkwitz",
"4938824", "Mallentin",
"49381", "Rostock",
"4938326", "Grimmen",
"494425", "Wangerland\-Hooksiel",
"4937323", "Lichtenberg\ Erzgebirge",
"4935053", "Glashütte\ Sachsen",
"493585", "Löbau",
"497054", "Wildberg\ Württemberg",
"4938825", "Klütz",
"492861", "Borken\ Westfalen",
"498191", "Landsberg\ am\ Lech",
"499495", "Breitenbrunn\ Oberpfalz",
"494642", "Kappeln\ Schlei",
"4933760", "Münchehofe\ Kreis\ Dahme\-Spreewald",
"4936021", "Schlotheim",
"494267", "Lauenbrück",
"495032", "Neustadt\ am\ Rübenberge",
"492193", "Dabringhausen",
"495674", "Grebenstein",
"499367", "Unterpleichfeld",
"499181", "Neumarkt\ in\ der\ Oberpfalz",
"499564", "Bad\ Rodach",
"494456", "Varel\-Altjührden",
"496841", "Homburg\ Saar",
"499358", "Gössenheim",
"4939054", "Flechtingen",
"494630", "Barderup",
"492924", "Möhnesee",
"4936028", "Kammerforst\ Thüringen",
"4938464", "Bernitt",
"4934771", "Querfurt",
"494258", "Schwarme",
"4939055", "Hörsingen",
"493335", "Finowfurt",
"492352", "Altena\ Westfalen",
"494752", "Neuhaus\ Oste",
"497669", "St\ Märgen",
"497324", "Herbrechtingen",
"499847", "Ergersheim",
"497247", "Linkenheim\-Hochstetten",
"499333", "Sommerhausen",
"4934381", "Colditz",
"494824", "Krempe",
"499156", "Neuhaus\ an\ der\ Pegnitz",
"494233", "Blender",
"497952", "Gerabronn",
"498343", "Aitrang",
"495225", "Spenge",
"495545", "Hedemünden",
"4933606", "Müllrose",
"494481", "Hatten\-Sandkrug",
"492423", "Langerwehe",
"49991", "Deggendorf",
"4939603", "Burg\ Stargard",
"498593", "Untergriesbach",
"493521", "Meissen",
"496187", "Schöneck",
"496361", "Rockenhausen",
"497527", "Wolfegg",
"496134", "Mainz\-Kastel",
"494961", "Papenburg",
"4934363", "Cavertitz",
"495458", "Hopsten",
"49621", "Mannheim",
"494195", "Hartenholm",
"493493", "Bitterfeld",
"497761", "Bad\ Säckingen",
"498421", "Eichstätt\ Bayern",
"492591", "Lüdinghausen",
"4939957", "Gielow",
"498745", "Bodenkirchen",
"4933877", "Nitzahn",
"495934", "Haren\-Rütenbrock",
"4934923", "Cobbelsdorf",
"497959", "Frankenhardt",
"4935604", "Krieschow",
"496724", "Stromberg\ Hunsrück",
"492508", "Drensteinfurt",
"499502", "Frensdorf",
"499735", "Massbach",
"495467", "Voltlage",
"497662", "Vogtsburg\ im\ Kaiserstuhl",
"496852", "Nohfelden",
"498306", "Ronsberg",
"4935605", "Komptendorf",
"4936648", "Dittersdorf\ bei\ Schleiz",
"4989", "Munich",
"493423", "Eilenburg",
"494125", "Seestermühe",
"4939885", "Jakobshagen",
"4938292", "Kröpelin",
"49631", "Kaiserslautern",
"499961", "Mitterfels",
"4939386", "Seehausen\ Altmark",
"499195", "Adelsdorf\ Mittelfranken",
"495356", "Helmstedt\-Barmke",
"4939884", "Hassleben\ bei\ Prenzlau",
"492521", "Beckum",
"495723", "Bad\ Nenndorf",
"4935752", "Ruhland",
"492241", "Siegburg",
"494735", "Butjadingen\-Stollhamm",
"494502", "Lübeck\-Travemünde",
"4934223", "Dommitzsch",
"496747", "Emmelshausen",
"497935", "Schrozberg",
"4936846", "Suhl\-Dietzhausen",
"4938759", "Tewswoos",
"498206", "Egling\ an\ der\ Paar",
"4936453", "Mellingen",
"4936376", "Straussfurt",
"497394", "Schelklingen",
"492758", "Bad\ Berleburg\-Girkhausen",
"497224", "Gernsbach",
"4933928", "Wildberg\ Brandenburg",
"4933361", "Joachimsthal",
"4936874", "Schönbrunn\ bei\ Hildburghaus",
"499824", "Dietenhofen",
"493341", "Strausberg",
"497833", "Hornberg\ Schwarzwaldbahn",
"499233", "Arzberg\ Oberfranken",
"494156", "Talkau",
"497347", "Dietenheim",
"496835", "Beckingen",
"495295", "Lichtenau\ Westfalen",
"494333", "Erfde",
"494847", "Oster\-Ohrstedt",
"494509", "Gross\ Grönau",
"4936875", "Straufhain\-Streufdorf",
"498243", "Fuchstal",
"4934293", "Naunhof\ bei\ Grimma",
"495325", "Goslar\-Hahnenklee",
"4933368", "Hohensaaten",
"4933921", "Zechlinerhütte",
"49771", "Donaueschingen",
"499481", "Pfatter",
"496261", "Mosbach\ Baden",
"497544", "Markdorf",
"49491", "Leer\ Ostfriesland",
"493591", "Bautzen",
"4938222", "Semlow",
"499651", "Vohenstrauss",
"498262", "Mittelneufnach",
"496093", "Laufach",
"495024", "Rohrsen\ Kreis\ Nienburg\ Weser",
"499454", "Aufhausen\ Oberpfalz",
"495171", "Peine",
"4933703", "Sperenberg",
"492932", "Neheim\-Hüsten",
"499938", "Moos\ Niederbayern",
"4936027", "Lengenfeld\ Unterm\ Stein",
"494371", "Burg\ auf\ Fehmarn",
"496650", "Hosenfeld",
"499260", "Wilhelmsthal\ Oberfranken",
"496436", "Dornburg\ Hessen",
"498076", "Pfaffing",
"496238", "Dirmstein",
"499271", "Thurnau\-Alladorf",
"493877", "Wittenberge",
"499637", "Falkenberg\ Oberpfalz",
"4936462", "Ossmannstedt",
"498269", "Unteregg\ bei\ Mindelheim",
"498851", "Kochel\ am\ See",
"494271", "Sulingen",
"49465", "Sylt",
"492955", "Büren\-Wewelsburg",
"499360", "Thüngen",
"496338", "Hornbach\ Pfalz",
"497056", "Gechingen",
"494260", "Visselhövede\-Wittorf",
"499371", "Miltenberg",
"495828", "Himbergen",
"497643", "Herbolzheim\ Breisgau",
"4933834", "Pritzerbe",
"493996", "Teterow",
"496422", "Kirchhain",
"4933336", "Passow\ Kreis\ Uckermark",
"498624", "Obing",
"4933835", "Golzow\ bei\ Brandenburg",
"494637", "Sterup",
"498369", "Rückholz",
"496645", "Ulrichstein",
"49234", "Bochum",
"494454", "Jade",
"499566", "Meeder",
"4936202", "Neudietendorf",
"496023", "Alzenau\ in\ Unterfranken",
"498362", "Füssen",
"494684", "Langeness\ Hallig",
"4935026", "Dürrröhrsdorf\-Dittersbach",
"4938353", "Gützkow\ bei\ Greifswald",
"4937200", "Wittgensdorf\ bei\ Chemnitz",
"497025", "Neuffen",
"496588", "Pluwig",
"496429", "Schweinsberg\ Hessen",
"497128", "Sonnenbühl",
"4933094", "Löwenberg",
"494938", "Hagermarsch",
"497738", "Steisslingen",
"495676", "Liebenau\ Hessen",
"492853", "Schermbeck",
"496755", "Odernheim\ am\ Glan",
"494953", "Bunde",
"499832", "Wassertrüdingen",
"497232", "Königsbach\-Stein",
"494977", "Blomberg\ Ostfriesland",
"493771", "Aue\ Sachsen",
"492838", "Sonsbeck",
"497777", "Sauldorf",
"4933927", "Linum",
"4934956", "Zörbig",
"497753", "Albbruck",
"4936733", "Kaulsdorf",
"495707", "Petershagen\ Weser",
"497326", "Neresheim",
"4938231", "Barth",
"4933367", "Friedrichswalde\ Brandenburg",
"494826", "Hohenlockstedt",
"495471", "Bohmte",
"493672", "Rudolstadt",
"499154", "Pommelsbrunn",
"4933932", "Fehrbellin",
"495936", "Twist",
"493679", "Neuhaus\ am\ Rennweg",
"496574", "Hasborn",
"496726", "Lorch\ Rheingau",
"4938872", "Rehna",
"496192", "Hofheim\ am\ Taunus",
"497081", "Bad\ Wildbad",
"497240", "Pfinztal",
"498304", "Wildpoldsried",
"497355", "Hochdorf\ Riss",
"497520", "Bodnegg",
"496136", "Nieder\-Olm",
"498507", "Neuburg\ am\ Inn",
"4933849", "Wiesenburg\ Mark",
"494663", "Süderlügum",
"4939459", "Hasselfelde",
"4934343", "Regis\-Breitingen",
"495254", "Paderborn\-Schloss\ Neuhaus",
"494855", "Eddelak",
"4933676", "Friedland\ bei\ Beeskow",
"496353", "Freinsheim",
"497582", "Bad\ Buchau",
"495573", "Uslar\-Volpriehausen",
"496122", "Hofheim\-Wallau",
"496631", "Alsfeld",
"492672", "Treis\-Karden",
"498204", "Mickhausen",
"4939951", "Faulenrost",
"497340", "Neenstetten",
"4935841", "Grossschönau\ Sachsen",
"497255", "Graben\-Neudorf",
"494839", "Wöhrden\ Dithmarschen",
"499855", "Dentlein\ am\ Forst",
"4936925", "Marksuhl",
"495922", "Bad\ Bentheim",
"492407", "Herzogenrath\-Kohlscheid",
"496732", "Wörrstadt",
"496505", "Kordel",
"4936647", "Saalburg\ Thüringen",
"499663", "Neukirchen\ bei\ Sulzbach\-Rosenberg",
"497503", "Wilhelmsdorf\ Württemberg",
"495354", "Jerxheim",
"4936924", "Mihla",
"4933878", "Nennhausen",
"498375", "Weitnau",
"493838", "Bergen\ auf\ Rügen",
"492771", "Dillenburg",
"496253", "Fürth\ Odenwald",
"498773", "Neufahrn\ in\ Niederbayern",
"4936426", "Ottendorf\ bei\ Stadtroda",
"497332", "Lauterstein",
"497546", "Oberteuringen",
"494832", "Meldorf",
"499977", "Arnschwang",
"499953", "Pilsting",
"499826", "Weidenbach\ Mittelfranken",
"497226", "Bühl\-Sand",
"494154", "Trittau",
"497428", "Rosenfeld",
"496129", "Schlangenbad",
"4933232", "Brieselang",
"497447", "Baiersbronn\-Schwarzenberg",
"4933734", "Felgentreu",
"499158", "Offenhausen\ Mittelfranken",
"493441", "Zeitz",
"4934361", "Dahlen\ Sachsen",
"495642", "Warburg\-Scherfede",
"4934928", "Seegrehna",
"4935389", "Holzdorf\ Elster",
"494433", "Dötlingen",
"492152", "Kempen",
"492543", "Billerbeck\ Westfalen",
"4936643", "Thimmendorf",
"495425", "Borgholzhausen",
"4939296", "Welsleben",
"4934921", "Kemberg",
"492393", "Sundern\-Allendorf",
"495741", "Lübbecke",
"492834", "Straelen",
"494281", "Zeven",
"492223", "Königswinter",
"499167", "Oberscheinfeld",
"499381", "Volkach",
"493725", "Zschopau",
"496563", "Kyllburg",
"4939608", "Staven",
"49641", "Giessen",
"495258", "Salzkotten",
"4934383", "Trebsen\ Mulde",
"495456", "Westerkappeln\-Velpe",
"498221", "Günzburg",
"499605", "Weiherhammer",
"497565", "Aichstetten\ Kreis\ Ravensburg",
"495686", "Schwarzenborn\ Knüll",
"494674", "Ockholm",
"4937755", "Schönheide\ Erzgebirge",
"492159", "Meerbusch\-Osterath",
"498541", "Vilshofen\ Niederbayern",
"4939601", "Friedland",
"4939226", "Hohenziatz",
"492506", "Münster\-Wolbeck",
"496578", "Salmtal",
"4937754", "Zwönitz",
"499531", "Ebern",
"494605", "Medelby",
"493834", "Greifswald",
"495564", "Dassel",
"495358", "Bahrdorf\-Mackendorf",
"4933363", "Altenhof\ Kreis\ Barnim",
"4939366", "Kehnert",
"492725", "Lennestadt\-Oedingen",
"498321", "Sonthofen",
"4934291", "Borsdorf",
"498291", "Zusmarshausen",
"4933923", "Flecken\ Zechlin",
"492441", "Kall",
"4936737", "Drognitz",
"4939926", "Grabowhöfe",
"494531", "Bad\ Oldesloe",
"498208", "Eurasburg\ bei\ Augsburg",
"495367", "Rühen",
"4934298", "Taucha\ bei\ Leipzig",
"495181", "Alfeld\ Leine",
"498042", "Lenggries",
"499674", "Schönsee",
"4937602", "Kirchberg\ Sachsen",
"498406", "Böhmfeld",
"4936259", "Tabarz\ Thüringer\ Wald",
"4939425", "Dingelstedt\ am\ Huy",
"499433", "Nabburg",
"498764", "Mauern\ Kreis\ Freising",
"497424", "Spaichingen",
"494158", "Roseburg",
"495495", "Vörden\ Kreis\ Vechta",
"4936458", "Bad\ Berka",
"4934347", "Oelzschau\ bei\ Borna",
"4939996", "Törpin",
"4939424", "Schwanebeck\ Sachsen\-Anhalt",
"498443", "Hohenwart\ Paar",
"498086", "Buchbach\ Oberbayern",
"492293", "Nümbrecht",
"494381", "Lütjenburg",
"492323", "Herne",
"4934221", "Schildau\ Gneisenaustadt",
"4934606", "Teicha\ Sachsen\-Anhalt",
"494167", "Apensen",
"496461", "Biedenkopf",
"499281", "Hof\ Saale",
"4936451", "Buttelstedt",
"492603", "Bad\ Ems",
"494723", "Cuxhaven\-Altenwalde",
"498385", "Hergatz",
"495502", "Dransfeld",
"496287", "Limbach\ Baden",
"499467", "Michelsneukirchen",
"4936705", "Oberweissbach\ Thüringer\ Wald",
"494356", "Gross\ Wittensee",
"497147", "Sachsenheim\ Württemberg",
"497194", "Spiegelberg",
"495583", "Braunlage\-Hohegeiss",
"498051", "Prien\ am\ Chiemsee",
"497572", "Mengen\ Württemberg",
"498709", "Eching\ Niederbayern",
"4936704", "Steinheid",
"496666", "Freiensteinau",
"495028", "Pennigsehl",
"492682", "Hamm\ Sieg",
"492452", "Heinsberg\ Rheinland",
"4936766", "Schalkau",
"499256", "Stammbach",
"4939322", "Tangermünde",
"493435", "Oschatz",
"494133", "Wittorf\ Kreis\ Lüneburg",
"49591", "Lingen\ \(Ems\)",
"492689", "Dierdorf",
"499545", "Buttenheim",
"4939392", "Rönnebeck\ Sachsen\-Anhalt",
"492053", "Velbert\-Neviges",
"497579", "Schwenningen\ Baden",
"498702", "Wörth\ an\ der\ Isar",
"498535", "Haarbach",
"492646", "Königsfeld\ Eifel",
"494295", "Emtinghausen",
"49611", "Wiesbaden",
"495333", "Dettum",
"495509", "Rosdorf\ Kreis\ Göttingen",
"498783", "Rohr\ in\ Niederbayern",
"4939402", "Völpke",
"494550", "Bühnsdorf",
"496234", "Mutterstadt",
"497825", "Kippenheim",
"499225", "Stadtsteinach",
"499395", "Triefenstein",
"495156", "Coppenbrügge",
"4937209", "Einsiedel\ bei\ Chemnitz",
"4936023", "Horsmar",
"498628", "Kienberg\ Oberbayern",
"498106", "Vaterstetten",
"492435", "Erkelenz\-Lövenich",
"495651", "Eschwege",
"494545", "Seedorf\ Lauenburg",
"495481", "Lengerich\ Westfalen",
"493682", "Zella\-Mehlis",
"496893", "Saarbrücken\-Ensheim",
"495824", "Bad\ Bodenteich",
"495233", "Steinheim\ Westfalen",
"493603", "Bad\ Langensalza",
"496334", "Thaleischweiler\-Fröschen",
"495752", "Auetal\-Hattendorf",
"4934773", "Schwittersdorf",
"499325", "Kleinlangheim",
"499295", "Töpen",
"494467", "Wittmund\-Funnix",
"4935058", "Pretzschendorf",
"4937328", "Grossschirma",
"499723", "Röthlein",
"497734", "Gailingen",
"492620", "Neuhäusel\ Westerwald",
"498285", "Burtenbach",
"494934", "Marienhafe",
"494793", "Hambergen",
"496387", "Sankt\ Julian",
"496161", "Brensbach",
"4939262", "Güsten\ Anh",
"497124", "Trochtelfingen\ Hohenz",
"496584", "Wellen\ Mosel",
"499133", "Baiersdorf\ Mittelfranken",
"494256", "Hilgermissen",
"4938484", "Ventschow",
"4937321", "Frankenstein\ Sachsen",
"498552", "Grafenau\ Niederbayern",
"497071", "Tübingen",
"498143", "Inning\ am\ Ammersee",
"495961", "Haselünne",
"4936652", "Wurzbach",
"495195", "Neuenkirchen\ bei\ Soltau",
"499356", "Burgsinn",
"4938485", "Dabel",
"494458", "Wiefelstede\-Spohle",
"499646", "Freihung",
"493723", "Hohenstein\-Ernstthal",
"4936372", "Kleinneuhausen",
"492225", "Meckenheim\ Rheinland",
"498636", "Ampfing",
"498450", "Ingolstadt\-Zuchering",
"492395", "Finnentrop\-Rönkhausen",
"498708", "Weihmichl\-Unterneuhausen",
"495423", "Versmold",
"494435", "Grossenkneten",
"4938226", "Dierhagen\ Ostseebad",
"492545", "Rosendahl\-Darfeld",
"496447", "Langgöns\-Niederkleen",
"494141", "Stade",
"499077", "Bachhagel",
"4939382", "Kamern",
"492688", "Kroppach",
"495022", "Wietzen",
"497578", "Wald\ Hohenz",
"499682", "Erbendorf",
"499452", "Langquaid",
"4938296", "Rerik\ Ostseebad",
"492256", "Mechernich\-Satzvey",
"4937293", "Eppendorf\ Sachsen",
"499603", "Floss",
"495508", "Gleichen\-Rittmarshausen",
"497563", "Kisslegg",
"4936842", "Oberhof\ Thüringen",
"495341", "Salzgitter",
"49741", "Rottweil",
"492934", "Sundern\-Altenhellefeld",
"4935756", "Hosena",
"496565", "Dudeldorf",
"4938450", "Tarnow\ bei\ Bützow",
"494452", "Zetel\-Neuenburg",
"4938425", "Kirchdorf\ Poel",
"492133", "Dormagen",
"498629", "Palling",
"498558", "Hohenau\ Niederbayern",
"498364", "Seeg",
"494682", "Amrum",
"4938424", "Bobitz",
"4937381", "Penig",
"495521", "Herzberg\ am\ Harz",
"492723", "Kirchhundem",
"495241", "Gütersloh",
"495036", "Neustadt\-Schneeren",
"493395", "Pritzwalk",
"493987", "Templin",
"494603", "Havetoft",
"4938304", "Garz\ Rügen",
"4937363", "Zöblitz",
"498721", "Eggenfelden",
"497461", "Tuttlingen",
"496881", "Lebach",
"4938305", "Gingst",
"492325", "Wanne\-Eickel",
"492295", "Ruppichteroth",
"494646", "Mohrkirch",
"498445", "Gerolsbach",
"495493", "Neuenkirchen\ Kreis\ Vechta",
"496424", "Ebsdorfergrund",
"499141", "Weissenburg\ in\ Bayern",
"495767", "Warmsen",
"499435", "Schwarzenfeld",
"498622", "Tacherting\-Peterskirchen",
"4933602", "Alt\ Zeschdorf",
"4936083", "Uder",
"498131", "Dachau",
"4935201", "Langebrück",
"49581", "Uelzen",
"496147", "Trebur",
"493433", "Borna\ Stadt",
"494135", "Kirchgellersen",
"4938392", "Sassnitz",
"496572", "Manderscheid\ Eifel",
"495123", "Schellerten",
"497666", "Denzlingen",
"495585", "Herzberg\-Sieber",
"494441", "Vechta",
"498302", "Görisried",
"496856", "St\ Wendel\-Niederkirchen",
"495947", "Laar\ Vechte",
"495733", "Vlotho",
"494725", "Helgoland",
"4935208", "Radeburg",
"498383", "Grünenbach\ Allgäu",
"495252", "Bad\ Lippspringe",
"492605", "Löf",
"49711", "Stuttgart",
"495259", "Bad\ Driburg\-Neuenheerse",
"499393", "Rothenfels\ Unterfranken",
"499834", "Theilenhofen",
"497234", "Tiefenbronn",
"499223", "Rugendorf",
"497823", "Seelbach\ Schutter",
"498785", "Rottenburg\-Oberroning",
"496825", "Illingen\ Saar",
"4933477", "Trebnitz\ bei\ Müncheberg",
"492381", "Hamm\ Westfalen",
"494323", "Bornhöved",
"495335", "Schladen",
"494293", "Ottersberg\-Fischerhude",
"494756", "Odisheim",
"498533", "Rotthalmünster",
"492158", "Grefrath\ bei\ Krefeld",
"4935329", "Dollenchen",
"4935696", "Briesnig",
"495648", "Brakel\-Gehrden",
"499543", "Hirschaid",
"499152", "Hartenstein\ Mittelfranken",
"4938322", "Richtenberg",
"499293", "Berg\ Oberfranken",
"497334", "Deggingen",
"499323", "Iphofen",
"4935891", "Rothenburg\ OL",
"494834", "Büsum",
"493605", "Leinefelde",
"494223", "Ganderkesee\-Bookholzberg",
"494393", "Boostedt",
"496787", "Niederbrombach",
"495235", "Blomberg\ Lippe",
"4939772", "Rothemühl",
"4939484", "Harzgerode",
"492433", "Hückelhoven",
"4933968", "Meyenburg\ Kreis\ Prignitz",
"494543", "Nusse",
"494152", "Geesthacht",
"493531", "Finsterwalde",
"4939485", "Gernrode\ Harz",
"495861", "Dannenberg\ Elbe",
"497584", "Altshausen",
"499441", "Kelheim",
"496124", "Bad\ Schwalbach",
"4933209", "Caputh",
"495193", "Schneverdingen",
"494506", "Stockelsdorf\-Krumbeck",
"4935828", "Reichenbach\ OL",
"4934263", "Hohburg",
"498145", "Mammendorf",
"498431", "Neuburg\ an\ der\ Donau",
"496071", "Dieburg",
"492674", "Bad\ Bertrich",
"498202", "Althegnenberg",
"499135", "Hessdorf\ Mittelfranken",
"49906", "Donauwörth",
"494159", "Basthorst",
"4933983", "Gross\ Pankow\ Kreis\ Prignitz",
"494795", "Garlstedt",
"4936945", "Henneberg",
"495924", "Bad\ Bentheim\-Gildehaus",
"496734", "Flonheim",
"498283", "Neuburg\ an\ der\ Kammel",
"4933398", "Werneuchen",
"499725", "Poppenhausen\ Unterfranken",
"4936782", "Schmiedefeld\ am\ Rennsteig",
"495352", "Schöningen",
"4936944", "Rentwertshausen",
"493381", "Brandenburg\ an\ der\ Havel",
"497387", "Hohenstein\ Württemberg",
"497161", "Göppingen",
"494771", "Hemmoor",
"496101", "Bad\ Vilbel",
"494407", "Wardenburg",
"49861", "Traunstein",
"492839", "Straelen\-Herongen",
"497971", "Gaildorf",
"494672", "Langenhorn",
"4936693", "Crossen\ an\ der\ Elster",
"495901", "Fürstenau\ bei\ Bramsche",
"4939246", "Lindau\ Anh",
"498027", "Dietramszell",
"496198", "Eppstein",
"496095", "Bessenbach",
"498166", "Allershausen\ Oberbayern",
"495644", "Willebadessen\-Peckelsheim",
"492154", "Willich",
"4936623", "Berga\ Elster",
"492832", "Kevelaer",
"497436", "Messstetten\-Oberdigisheim",
"496871", "Wadern",
"493663", "Schleiz",
"496643", "Herbstein",
"492826", "Kranenburg\ Niederrhein",
"4939975", "Thürkow",
"498762", "Wartenberg\ Oberbayern",
"497422", "Schramberg",
"499087", "Marktoffingen",
"4933200", "Bergholz\-Rehbrücke",
"4934327", "Waldheim\ Sachsen",
"497645", "Freiamt",
"4934979", "Wulfen\ Sachsen\-Anhalt",
"498661", "Grabenstätt\ Chiemsee",
"494838", "Tellingstedt",
"4934241", "Jesewitz",
"496056", "Bad\ Soden\-Salmünster",
"492977", "Schmallenberg\-Bödefeld",
"498670", "Reischach\ Kreis\ Altötting",
"492953", "Wünnenberg",
"492855", "Voerde\ Niederrhein",
"4936742", "Uhlstädt",
"495562", "Dassel\-Markoldendorf",
"499407", "Wenzenbach",
"492663", "Westerburg\ Westerwald",
"4935973", "Stolpen",
"499771", "Bad\ Neustadt\ an\ der\ Saale",
"497023", "Weilheim\ an\ der\ Teck",
"492678", "Büchel\ bei\ Cochem",
"4933473", "Zechin",
"4938333", "Horst\ bei\ Grimmen",
"499672", "Neunburg\ vorm\ Wald",
"496128", "Taunusstein",
"497429", "Egesheim",
"495836", "Wittingen\-Radenbeck",
"492637", "Weissenthurm",
"496296", "Ahorn\ Baden",
"496326", "Deidesheim",
"498704", "Altdorf\-Pfettrach",
"497755", "Weilheim\ Kreis\ Waldshut",
"496401", "Grünberg\ Hessen",
"4938459", "Laage",
"496232", "Speyer",
"492271", "Bergheim\ Erft",
"496753", "Meisenheim",
"494955", "Westoverledingen",
"4935452", "Golssen",
"494107", "Siek\ Kreis\ Stormarn",
"4936087", "Wüstheuterode",
"497136", "Bad\ Friedrichshall",
"498273", "Nordendorf",
"494853", "Sankt\ Michaelisdonn",
"496355", "Albisheim\ Pfrimm",
"498257", "Inchenhofen",
"494877", "Hennstedt\ bei\ Itzehoe",
"499932", "Osterhofen",
"492938", "Ense",
"494665", "Emmelsbüll\-Horsbüll",
"493371", "Luckenwalde",
"495504", "Friedland\ Kreis\ Göttingen",
"497353", "Schwendi",
"496239", "Bobenheim\-Roxheim",
"495307", "Braunschweig\-Wenden",
"4935728", "Uhyst\ Spree",
"497192", "Murrhardt",
"4934672", "Rossleben",
"497574", "Gammertingen",
"497726", "Bad\ Dürrheim",
"498466", "Denkendorf\ Oberbayern",
"4937367", "Lengefeld\ Erzgebirge",
"492684", "Puderbach\ Westerwald",
"494926", "Krummhörn\-Greetsiel",
"498268", "Tussenhausen",
"492454", "Gangelt",
"4939342", "Gladau",
"496081", "Usingen",
"498373", "Altusried",
"496255", "Lindenfels",
"4937348", "Oberwiesenthal\ Kurort",
"499665", "Königstein\ Oberpfalz",
"497732", "Radolfzell\ am\ Bodensee",
"497505", "Fronreute",
"497277", "Wörth\-Büchelberg",
"496503", "Hermeskeil",
"495829", "Wriedel",
"4939008", "Kunrau",
"494932", "Norderney",
"49365", "Gera",
"499853", "Wilburgstetten",
"497253", "Bad\ Schönborn",
"496339", "Grosssteinhausen",
"497122", "St\ Johann\ Württemberg",
"4939931", "Röbel\ Müritz",
"492566", "Legden",
"496582", "Freudenburg",
"495207", "Schloss\ Holte\-Stukenbrock",
"497631", "Müllheim\ Baden",
"499926", "Frauenau",
"4937341", "Ehrenfriedersdorf",
"498554", "Schönberg\ Niederbayern",
"498368", "Halblech",
"4939001", "Apenburg",
"496340", "Wörth\-Schaidt",
"496396", "Hinterweidenthal",
"4936043", "Kirchheilingen",
"496226", "Meckesheim",
"497129", "Lichtenstein\ Württemberg",
"496589", "Kell\ am\ See",
"496428", "Stadtallendorf",
"495822", "Ebstorf",
"499107", "Trautskirchen",
"4937297", "Thum\ Sachsen",
"494939", "Baltrum",
"499955", "Mamming",
"492360", "Haltern\-Lippramsdorf",
"4933084", "Gutengermendorf",
"496332", "Zweibrücken",
"495754", "Extertal\-Bremke",
"492371", "Iserlohn",
"4933085", "Seilershof",
"497739", "Hilzingen",
"496858", "Ottweiler\-Fürth",
"499341", "Tauberbischofsheim",
"4939204", "Niederndodeleben",
"495603", "Gudensberg",
"497668", "Ihringen",
"4933970", "Neustadt\ Dosse",
"4939266", "Förderstedt",
"492502", "Nottuln",
"492735", "Neunkirchen\ Siegerl",
"4939205", "Langenweddingen",
"498331", "Memmingen",
"494241", "Bassum",
"496675", "Breitenbach\ am\ Herzberg",
"494521", "Eutin",
"492583", "Sassenberg",
"495452", "Mettingen\ Westfalen",
"497657", "Eisenbach\ Hochschwarzwald",
"496867", "Perl",
"497673", "Schönau\ im\ Schwarzwald",
"495682", "Borken\ Hessen",
"495459", "Hörstel",
"494767", "Bremervörde\-Bevern",
"4935203", "Tharandt",
"4934328", "Hartha\ bei\ Döbeln",
"499423", "Geiselhöring",
"49291", "Meschede",
"497434", "Winterlingen",
"497967", "Jagstzell",
"494493", "Friesoythe\-Gehlenberg",
"498581", "Waldkirchen\ Niederbayern",
"495053", "Fassberg\-Müden",
"493961", "Altentreptow",
"492509", "Nottuln\-Appelhülsen",
"498020", "Weyarn",
"497958", "Rot\ Am\ See\-Brettheim",
"4934321", "Leisnig",
"495646", "Willebadessen",
"492333", "Ennepetal",
"492156", "Willich\-Anrath",
"494758", "Nordleda",
"499493", "Beratzhausen",
"498082", "Schwindegg",
"495141", "Celle",
"493583", "Zittau",
"4934261", "Kühren\ bei\ Wurzen",
"494423", "Fedderwarden",
"496054", "Birstein",
"4935033", "Rosenthal\ Sächsische\ Schweiz",
"4933393", "Gross\ Schönebeck\ Kreis\ Barnim",
"495435", "Berge\ bei\ Quakenbrück",
"492651", "Mayen",
"499099", "Kaisheim",
"4939396", "Neukirchen\ Altmark",
"4933981", "Putlitz",
"4935823", "Ostritz",
"492824", "Kalkar",
"492233", "Hürth\ Rheinland",
"492752", "Bad\ Laasphe",
"4939406", "Harbke",
"493735", "Marienberg\ Sachsen",
"4939035", "Kuhfelde",
"493847", "Sternberg",
"4933963", "Wulfersdorf\ bei\ Wittstock",
"499241", "Pegnitz",
"497841", "Achern",
"499080", "Harburg\ Schwaben",
"492759", "Bad\ Berleburg\-Aue",
"4934909", "Aken\ Elbe",
"4935893", "Mücka",
"4939034", "Fleetmark",
"498046", "Bad\ Heilbrunn",
"494508", "Krummesse",
"498231", "Königsbrunn\ bei\ Augsburg",
"498402", "Münchsmünster",
"49391", "Magdeburg",
"4939824", "Hohenzieritz",
"4936762", "Steinach\ Thüringen",
"499092", "Wemding",
"498677", "Burghausen\ Salzach",
"492961", "Brilon",
"492195", "Radevormwald",
"4939825", "Wokuhl",
"4935240", "Tauscha\ bei\ Grossenhain",
"499521", "Hassfurt",
"4939992", "Görmin",
"492642", "Remagen",
"498638", "Waldkraiburg",
"494861", "Tönning",
"496527", "Oberweis",
"492425", "Nideggen\-Embken",
"497361", "Aalen",
"499648", "Neustadt\ am\ Kulm",
"4937291", "Augustusburg",
"498250", "Hilgertshausen\-Tandern",
"495543", "Staufenberg\ Niedersachsen",
"495152", "Hessisch\ Oldendorf",
"496669", "Neuhof\-Hauswurz",
"495834", "Wittingen\-Knesebeck",
"492741", "Betzdorf",
"495223", "Bünde",
"498345", "Stöttwang",
"496294", "Krautheim\ Jagst",
"496247", "Worms\-Pfeddersheim",
"496324", "Hassloch",
"493564", "Schwarze\ Pumpe",
"494235", "Langwedel\-Etelsen",
"495300", "Salzgitter\-Üfingen",
"499335", "Aub\ Kreis\ Würzburg",
"4937298", "Oelsnitz\ Erzgebirge",
"498706", "Vilsheim",
"4934602", "Landsberg\ Sachsen\-Anhalt",
"494352", "Damp",
"4939007", "Tangeln",
"499947", "Neukirchen\ bei\ Hl\ Blut",
"499733", "Münnerstadt",
"497724", "St\ Georgen\ im\ Schwarzwald",
"498464", "Dietfurt\ an\ der\ Altmühl",
"497576", "Krauchenwies",
"494924", "Moormerland\-Oldersum",
"492630", "Mülheim\-Kärlich",
"492686", "Weyerbusch",
"4937347", "Bärenstein\ Kreis\ Annaberg",
"498743", "Geisenhausen",
"492456", "Selfkant",
"497852", "Willstätt",
"4939362", "Grieben\ bei\ Tangerhütte",
"499252", "Helmbrechts",
"497134", "Weinsberg",
"499123", "Lauf\ an\ der\ Pegnitz",
"49981", "Ansbach",
"49721", "Karlsruhe",
"4937606", "Lengenfeld\ Vogtland",
"495159", "Coppenbrügge\-Bisperode",
"494193", "Henstedt\-Ulzburg",
"4939922", "Dambeck\ bei\ Röbel",
"496761", "Simmern\ Hunsrück",
"4939080", "Kalbe\ Milde",
"495506", "Adelebsen",
"492267", "Wipperfürth",
"492564", "Vreden",
"492358", "Meinerzhagen\-Valbert",
"494252", "Bruchhausen\-Vilsen",
"497933", "Creglingen",
"497747", "Berau",
"4937361", "Neuhausen\ Erzgebirge",
"499924", "Bodenmais",
"493741", "Plauen",
"494733", "Butjadingen\-Burhave",
"494947", "Aurich\-Ogenbargen",
"498556", "Haidmühle",
"495725", "Lindhorst\ bei\ Stadthagen",
"499352", "Lohr\ am\ Main",
"4937368", "Deutschneudorf",
"49731", "Ulm\ Donau",
"495441", "Diepholz",
"499193", "Höchstadt\ an\ der\ Aisch",
"49481", "Heide\ Holstein",
"4935727", "Burghammer",
"495135", "Burgwedel\-Fuhrberg",
"4936081", "Arenshausen",
"492367", "Henrichenburg",
"492181", "Grevenbroich",
"493425", "Wurzen",
"4939222", "Möser",
"494123", "Barmstedt",
"4935797", "Schwepnitz",
"49671", "Bad\ Kreuznach",
"4939292", "Biederitz",
"4937383", "Lunzenau",
"499861", "Rothenburg\ ob\ der\ Tauber",
"496544", "Rhaunen",
"497261", "Sinsheim",
"496597", "Jünkerath",
"495323", "Clausthal\-Zellerfeld",
"496394", "Bundenthal",
"498245", "Türkheim\ Wertach",
"496833", "Rehlingen\-Siersburg",
"496347", "Hochstadt\ Pfalz",
"496224", "Sandhausen\ Baden",
"499359", "Karlstadt\-Wiesenfeld",
"495293", "Paderborn\-Dahl",
"494335", "Hohn\ bei\ Rendsburg",
"498102", "Höhenkirchen\-Siegertsbrunn",
"499235", "Thierstein",
"497835", "Zell\ am\ Harmersbach",
"493686", "Eisfeld",
"4935723", "Bernsdorf\ OL",
"496328", "Elmstein",
"4936422", "Reinstädt\ Thüringen",
"496298", "Möckmühl",
"495838", "Gross\ Oesingen",
"496201", "Weinheim\ Bergstr",
"499644", "Pressath",
"493573", "Senftenberg",
"498072", "Haag\ in\ Oberbayern",
"496432", "Diez",
"497551", "Überlingen\ Bodensee",
"4939089", "Bismark\ Altmark",
"49228", "Bonn",
"498634", "Garching\ an\ der\ Alz",
"494627", "Dörpstedt",
"492471", "Roetgen\ Eifel",
"499901", "Hengersberg\ Bayern",
"498687", "Taching\-Tengling",
"496033", "Butzbach",
"4939724", "Klein\ Bünzow",
"498457", "Vohburg\ an\ der\ Donau",
"496439", "Holzappel",
"497138", "Schwaigern",
"492992", "Marsberg",
"494928", "Ihlow\-Riepe",
"498266", "Kirchheim\ in\ Schwaben",
"499070", "Tapfheim",
"497728", "Niedereschach",
"498468", "Altmannstein\-Pondorf",
"496440", "Kölschhausen",
"494562", "Grömitz",
"4935793", "Elstra",
"492254", "Weilerswist",
"496455", "Frankenau\ Hessen",
"492557", "Wettringen\ Kreis\ Steinfurt",
"4936041", "Bad\ Tennstedt",
"4933435", "Rehfelde",
"4938375", "Koserow",
"492573", "Nordwalde",
"495034", "Neustadt\-Hagen",
"495672", "Bad\ Karlshafen",
"497683", "Simonswald",
"493471", "Bernburg\ Saale",
"4938374", "Lassan\ bei\ Wolgast",
"4933434", "Herzfelde\ bei\ Strausberg",
"497477", "Jungingen\ bei\ Hechingen",
"497453", "Altensteig\ Württemberg",
"4938876", "Roggendorf",
"499562", "Sonnefeld",
"495407", "Wallenhorst",
"4935934", "Grossdubrau",
"498366", "Oy\-Mittelberg",
"4933672", "Pfaffendorfb\ Beeskow",
"492922", "Werl",
"499928", "Kirchdorf\ im\ Wald",
"4935935", "Kleinwelka",
"495771", "Rahden\ Westfalen",
"492568", "Heek",
"492354", "Meinerzhagen",
"496426", "Fronhausen",
"499569", "Sesslach",
"496228", "Schönau\ Odenwald",
"4935436", "Laasow\ bei\ Calau",
"496398", "Vorderweidenthal",
"499627", "Freudenberg\ Oberpfalz",
"496301", "Otterbach\ Pfalz",
"4938844", "Gülze",
"4939933", "Vollrathsruhe",
"4937343", "Jöhstadt",
"4938845", "Kaarssen",
"498571", "Simbach\ am\ Inn",
"497052", "Bad\ Liebenzell",
"4939003", "Jübar",
"494644", "Karby",
"4935022", "Bad\ Schandau",
"496132", "Ingelheim\ am\ Rhein",
"499307", "Altertheim",
"496621", "Bad\ Hersfeld",
"492171", "Leverkusen\-Opladen",
"4936206", "Grossfahner",
"4936621", "Elsterberg\ bei\ Plauen",
"494207", "Oyten",
"4935827", "Nieder\-Seifersdorf",
"498803", "Peissenberg",
"494829", "Wewelsfleth",
"4933397", "Wandlitz",
"495932", "Haren\ Ems",
"496722", "Rüdesheim\ am\ Rhein",
"496196", "Bad\ Soden\ am\ Taunus",
"499504", "Stadelhofen",
"497664", "Freiburg\-Tiengen",
"497329", "Steinheim\ am\ Albuch",
"496854", "Oberthal\ Saar",
"4936628", "Zeulenroda",
"4934659", "Blankenheim\ bei\ Sangerhausen",
"494754", "Bülkau",
"497322", "Giengen\ an\ der\ Brenz",
"494822", "Kellinghusen",
"495939", "Sustrum",
"497954", "Kirchberg\ an\ der\ Jagst",
"4933979", "Wusterhausen\ Dosse",
"498065", "Tuntenhausen\-Schönau",
"4939859", "Fürstenwerder",
"498168", "Attenkirchen",
"4938785", "Berge\ bei\ Perleberg",
"498157", "Feldafing",
"4936691", "Eisenberg\ Thüringen",
"492801", "Xanten",
"497236", "Keltern",
"497041", "Mühlacker",
"499836", "Gunzenhausen\-Cronheim",
"4938784", "Kleinow\ Kreis\ Prignitz",
"496139", "Budenheim",
"498846", "Uffing\ am\ Staffelsee",
"4933967", "Freyenstein",
"4933332", "Gartz\ Oder",
"497392", "Laupheim",
"4933478", "Gross\ Neuendorf",
"497222", "Rastatt",
"499822", "Bechhofen\ an\ der\ Heide",
"495955", "Esterwegen",
"492828", "Emmerich\-Elten",
"494892", "Schenefeld\ Mittelholstein",
"4935971", "Sebnitz",
"497336", "Lonsee",
"496058", "Gründau",
"496155", "Griesheim\ Hessen",
"4938331", "Rakow\ Vorpom",
"4935249", "Basslitz",
"494836", "Hennstedt\ Dithmarschen",
"497153", "Plochingen",
"497542", "Tettnang",
"495926", "Engden",
"496691", "Schwalmstadt",
"4936965", "Stadtlengsfeld",
"496736", "Bechenheim",
"499207", "Königsfeld\ Oberfranken",
"497807", "Neuried\ Ortenaukreis",
"499575", "Weismain",
"4936964", "Dermbach\ Rhön",
"494307", "Raisdorf",
"495665", "Guxhagen",
"497586", "Herbertingen",
"496126", "Idstein",
"494504", "Ratekau",
"4934243", "Bad\ Düben",
"495853", "Neu\ Darchau",
"4935207", "Moritzburg",
"497229", "Iffezheim",
"492676", "Ulmen",
"499829", "Flachslanden",
"495168", "Walsrode\-Stellichte",
"4936744", "Remda",
"495065", "Sibbesse",
"496242", "Osthofen",
"4936020", "Ebeleben",
"497975", "Untergröningen",
"494775", "Grossenwörden",
"4933633", "Spreenhagen",
"496008", "Echzell",
"496105", "Mörfelden\-Walldorf",
"492647", "Kesseling",
"495846", "Gartow\ Niedersachsen",
"492694", "Wershofen",
"499704", "Euerdorf",
"492269", "Kierspe\-Rönsahl",
"493362", "Erkner",
"496522", "Mettendorf",
"495173", "Uetze",
"497182", "Welzheim",
"495157", "Emmerthal\-Börry",
"495905", "Beesten",
"495803", "Rosche",
"499268", "Teuschnitz",
"496658", "Poppenhausen\ Wasserkuppe",
"493624", "Ohrdruf",
"4937467", "Klingenthal\ Sachsen",
"4939972", "Walkendorf",
"496286", "Walldürn\-Rippberg",
"499466", "Stamsried",
"4933768", "Prieros",
"494554", "Wahlstedt",
"492262", "Wiehl",
"497146", "Remseck\ am\ Neckar",
"494357", "Sehestedt\ Eider",
"496875", "Nonnweiler\-Primstal",
"499942", "Viechtach",
"496667", "Steinau\-Ulmbach",
"495882", "Gorleben",
"499273", "Bad\ Berneck\ im\ Fichtelgebirge",
"492948", "Lippstadt\-Rebbeke",
"496249", "Guntersblum",
"499257", "Zell\ Oberfranken",
"499554", "Untersteinbach\ Unterfranken",
"494466", "Wittmund\-Ardorf",
"4938851", "Zarrentin",
"496599", "Weidenbach\ bei\ Gerolstein",
"496804", "Mandelbachtal",
"493647", "Pössneck",
"497641", "Emmendingen",
"495820", "Suhlendorf",
"496386", "Altenkirchen\ Pfalz",
"494268", "Bötersen",
"492362", "Dorsten",
"494257", "Schweringen",
"497742", "Klettgau",
"4934781", "Greifenhagen",
"4938858", "Lassahn",
"4933747", "Marzahna",
"494273", "Kirchdorf\ bei\ Sulingen",
"494942", "Südbrookmerland",
"499373", "Amorbach",
"4934638", "Zöschen",
"496349", "Billigheim\-Ingenheim",
"499357", "Gräfendorf\ Bayern",
"498665", "Inzell",
"496342", "Schweigen\-Rechtenbach",
"499775", "Schönau\ an\ der\ Brend",
"496580", "Zemmer",
"496536", "Kleinich",
"492851", "Rees",
"4937207", "Hainichen\ Sachsen",
"492624", "Höhr\-Grenzhausen",
"497904", "Ilshofen",
"496021", "Aschaffenburg",
"492369", "Dorsten\-Wulfen",
"494704", "Drangstedt",
"496592", "Daun",
"4939831", "Feldberg",
"496174", "Königstein\ im\ Taunus",
"492304", "Schwerte",
"4938726", "Spornitz",
"494769", "Bremervörde\-Iselersheim",
"495457", "Hopsten\-Schale",
"497652", "Hinterzarten",
"495473", "Ostercappeln",
"497482", "Horb\-Dettingen",
"49961", "Weiden\ in\ der\ Oberpfalz",
"4936603", "Weida",
"4933082", "Menz\ Kreis\ Oberhavel",
"494951", "Weener",
"492275", "Kerpen\-Buir",
"497403", "Dunningen",
"495468", "Bramsche\-Engter",
"4933920", "Walsleben\ bei\ Neuruppin",
"497751", "Waldshut",
"492507", "Havixbeck",
"496405", "Laubach\ Hessen",
"495266", "Lemgo\-Kirchheide",
"493773", "Johanngeorgenstadt",
"493375", "Königs\ Wusterhausen",
"494661", "Niebüll",
"497446", "Lossburg",
"492842", "Kamp\-Lintfort",
"497248", "Marxzell",
"496351", "Eisenberg\ Pfalz",
"499848", "Simmershofen",
"494762", "Kutenholz",
"4938796", "Viesecke",
"495634", "Waldeck\-Sachsenhausen",
"496869", "Merzig\-Silwingen",
"497528", "Neukirch\ bei\ Tettnang",
"496085", "Waldsolms",
"496188", "Kahl\ am\ Main",
"4935387", "Seyda",
"499166", "Münchsteinach",
"497083", "Bad\ Herrenalb",
"495072", "Neustadt\-Mandelsloh",
"497962", "Fichtenau",
"4935873", "Herrnhut",
"494848", "Rantrum",
"49212", "Solingen",
"497348", "Beimerstetten",
"492773", "Haiger",
"496251", "Bensheim",
"4936640", "Remptendorf",
"499661", "Sulzbach\-Rosenberg",
"4939345", "Parchen",
"496633", "Homberg\ Ohm",
"493304", "Velten",
"4936257", "Luisenthal\ Thüringen",
"495571", "Uslar",
"494166", "Ahlerstedt",
"493886", "Gadebusch",
"4939344", "Güsen",
"4933456", "Wriezen",
"4939453", "Derenburg",
"499762", "Saal\ an\ der\ Saale",
"4933843", "Niemegk",
"498679", "Burgkirchen\ an\ der\ Alz",
"497635", "Schliengen",
"4934497", "Langenleuba\-Niederhain",
"4936739", "Rottenbach",
"4937436", "Weischlitz",
"492204", "Bensberg",
"499097", "Marxheim",
"498034", "Brannenburg",
"496474", "Villmar\-Aumenau",
"4935455", "Walddrehna",
"498771", "Ergoldsbach",
"492375", "Balve",
"499951", "Landau\ an\ der\ Isar",
"4935454", "Uckro",
"495366", "Jembke",
"4935343", "Hirschfeld\ bei\ Elsterwerda",
"497420", "Deisslingen",
"49461", "Flensburg",
"498407", "Grossmehring",
"494283", "Tarmstedt",
"4938758", "Dömitz",
"495743", "Espelkamp\-Gestringen",
"495937", "Geeste\-Gross\ Hesepe",
"4933847", "Görzke",
"4934423", "Heuckewalde",
"492391", "Plettenberg",
"496727", "Gensingen",
"4939457", "Benneckenstein\ Harz",
"4938302", "Sagard",
"495464", "Alfhausen",
"499383", "Wiesentheid",
"4936253", "Georgenthal\ Thüringer\ Wald",
"493443", "Weissenfels\ Sachsen\-Anhalt",
"4933605", "Boossen",
"498506", "Bad\ Höhenstadt",
"4938751", "Picher",
"499302", "Rottendorf\ Unterfranken",
"492308", "Unna\-Hemmerde",
"493764", "Meerane",
"494202", "Achim\ bei\ Bremen",
"4933604", "Lebus",
"492541", "Coesfeld",
"4935877", "Cunewalde",
"494431", "Wildeshausen",
"495250", "Delbrück\ Westfalen",
"498543", "Aidenbach",
"498152", "Herrsching\ am\ Ammersee",
"494209", "Schwanewede",
"494976", "Spiekeroog",
"4933369", "Oderberg",
"499533", "Untermerzbach",
"496184", "Langenselbold",
"497524", "Bad\ Waldsee",
"4938422", "Neukloster",
"495706", "Porta\ Westfalica",
"497327", "Dischingen",
"496561", "Bitburg",
"497244", "Weingarten\ Baden",
"499844", "Obernzenn",
"493321", "Nauen\ Brandenburg",
"494827", "Wacken",
"498393", "Holzgünz",
"4935606", "Briesen\ bei\ Cottbus",
"4934493", "Gössnitz\ Thüringen",
"498223", "Ichenhausen",
"495345", "Baddeckenstedt",
"4933929", "Gühlen\-Glienicke",
"495525", "Walkenried",
"4939886", "Milmersdorf",
"494533", "Reinfeld\ Holstein",
"498756", "Nandlstadt",
"492443", "Mechernich",
"4939384", "Arendsee\ Altmark",
"4936730", "Sitzendorf",
"493541", "Calau",
"4935361", "Schlieben",
"499976", "Rötz",
"497172", "Lorch\ Württemberg",
"4936607", "Niederpöllnitz",
"495183", "Lamspringe",
"492764", "Welschen\ Ennest",
"499209", "Emtmannsberg",
"493391", "Neuruppin",
"499827", "Lichtenau\ Mittelfranken",
"4936844", "Rohr\ Thüringen",
"497227", "Lichtenau\ Baden",
"497344", "Blaubeuren",
"495102", "Laatzen",
"498293", "Welden\ bei\ Augsburg",
"496062", "Erbach\ Odenwald",
"494844", "Pellworm",
"498323", "Immenstadt\ im\ Allgäu",
"4936845", "Gehlberg",
"495245", "Herzebrock\-Clarholz",
"494383", "Grebin",
"497465", "Emmingen\-Liptingen",
"498725", "Wurmannsquick",
"4935383", "Elster\ Elbe",
"495556", "Lindau\ Harz",
"492291", "Waldbröl",
"4936649", "Gefell\ bei\ Schleiz",
"496744", "Oberwesel",
"4936375", "Kindelbrück",
"49651", "Trier",
"495872", "Stoetze",
"499283", "Rehau",
"4936374", "Weissensee",
"495109", "Ronnenberg",
"499431", "Schwandorf",
"498135", "Sulzemoos",
"492406", "Herzogenrath",
"498038", "Vogtareuth",
"496478", "Greifenstein\-Ulm",
"497802", "Oberkirch\ Baden",
"499202", "Waischenfeld",
"492208", "Niederkassel",
"496276", "Hesseneck",
"494302", "Kirchbarkau",
"498441", "Pfaffenhofen\ an\ der\ Ilm",
"499145", "Solnhofen",
"498053", "Bad\ Endorf",
"492535", "Sendenhorst\-Albersloh",
"494445", "Visbek\ Kreis\ Vechta",
"494131", "Lüneburg",
"4933743", "Blönsdorf",
"4939746", "Krackow",
"499708", "Bad\ Bocklet",
"494622", "Taarstedt",
"493876", "Perleberg",
"498459", "Manching",
"499636", "Plössberg",
"496004", "Lich\-Eberstadt",
"4936785", "Gräfinau\-Angstedt",
"4935773", "Schleife",
"492601", "Nauort",
"4936784", "Stützerbach",
"495164", "Hodenhagen",
"494721", "Cuxhaven",
"492385", "Hamm\-Rhynern",
"496821", "Neunkirchen\ Saar",
"498781", "Rottenburg\ an\ der\ Laaber",
"495331", "Wolfenbüttel",
"492944", "Rietberg\-Mastholte",
"4937203", "Gersdorf\ bei\ Chemnitz",
"4936029", "Menteroda",
"4938206", "Graal\-Müritz\ Seeheilbad",
"498682", "Laufen\ Salzach",
"494364", "Dahme\ Kreis\ Ostholstein",
"4939482", "Gatersleben",
"494558", "Todesfelde",
"4939774", "Mönkebude",
"498452", "Geisenfeld",
"4934779", "Abberode",
"493628", "Arnstadt",
"496654", "Gersfeld\ Rhön",
"492051", "Velbert",
"4939775", "Ahlbeck\ bei\ Torgelow",
"496484", "Beselich",
"499264", "Küps",
"495402", "Bissendorf\ Kreis\ Osnabrück",
"499567", "Sesslach\-Gemünda",
"493601", "Mühlhausen\ Thüringen",
"495231", "Detmold",
"492927", "Neuengeseke",
"4934741", "Frose",
"492552", "Steinfurt\-Borghorst",
"4933637", "Beerfelde",
"493535", "Herzberg\ Elster",
"494264", "Sottrum\ Kreis\ Rotenburg",
"4938325", "Rolofshagen",
"495865", "Gusborn",
"495677", "Calden\-Westuffeln",
"497472", "Rottenburg\ am\ Neckar",
"495483", "Lienen",
"4938324", "Velgast",
"495653", "Sontra",
"4938826", "Dassow",
"499364", "Zellingen",
"499622", "Hirschau\ Oberpfalz",
"498435", "Ehekirchen",
"499131", "Erlangen",
"494708", "Ringstedt",
"4936338", "Bleicherode",
"499445", "Neustadt\ an\ der\ Donau",
"495963", "Bawinkel",
"497073", "Ammerbuch",
"498141", "Fürstenfeldbruck",
"495082", "Langlingen",
"492628", "Rhens",
"495978", "Hörstel\-Dreierwalde",
"499721", "Schweinfurt",
"493944", "Blankenburg\ Harz",
"4936331", "Ilfeld",
"497165", "Göppingen\-Hohenstaufen",
"4937463", "Bergen\ Vogtland",
"4938466", "Jürgenshagen",
"493385", "Rathenow",
"495409", "Hilter\ am\ Teutoburger\ Wald",
"4933053", "Zehlendorf\ Kreis\ Oberhavel",
"494791", "Osterholz\-Scharmbeck",
"4939056", "Klüden",
"496163", "Höchst\ im\ Odenwald",
"494636", "Langballig",
"495942", "Uelsen",
"4939959", "Dargun",
"498504", "Tittling",
"4934954", "Roitzsch\ bei\ Bitterfeld",
"495257", "Hövelhof",
"4934955", "Gossa",
"496374", "Weilerbach",
"495273", "Beverungen",
"496553", "Schönecken",
"496142", "Rüsselsheim",
"499803", "Colmberg",
"497203", "Walzbachtal",
"4938842", "Lüttenmark",
"495466", "Merzen",
"4936450", "Kranichfeld",
"496205", "Hockenheim",
"497555", "Deggenhausertal",
"495704", "Petershagen\-Friedewalde",
"4936608", "Seelingstädt\ bei\ Gera",
"499846", "Ipsheim",
"497031", "Böblingen",
"497246", "Malsch\ Kreis\ Karlsruhe",
"499157", "Alfeld\ Mittelfranken",
"497448", "Seewald",
"499905", "Bernried\ Niederbayern",
"4933432", "Müncheberg",
"4938372", "Usedom",
"499173", "Thalmässing",
"4933674", "Trebatsch",
"4936601", "Hermsdorf\ Thüringen",
"4935932", "Guttau",
"494974", "Neuharlingersiel",
"496186", "Grosskrotzenburg",
"4933675", "Tauche",
"496130", "Schwabenheim\ an\ der\ Selz",
"492162", "Viersen",
"497774", "Eigeltingen",
"493475", "Lutherstadt\ Eisleben",
"494173", "Wulfsen",
"4939722", "Sarnow\ bei\ Anklam",
"496703", "Wöllstein\ Rheinhessen",
"497346", "Illerkirchberg",
"497705", "Wolterdingen\ Schwarzw",
"496451", "Frankenberg\ Eder",
"497532", "Meersburg",
"494846", "Hattstedt",
"496681", "Hilders",
"495775", "Diepenau",
"4939600", "Zwiedorf",
"4936926", "Creuzburg",
"497389", "Heroldstatt",
"498754", "Volkenschwand",
"494168", "Neu\ Wulmstorf\-Elstorf",
"499974", "Traitsching",
"4935341", "Bad\ Liebenwerda",
"496782", "Birkenfeld\ Nahe",
"498822", "Oberammergau",
"494882", "Lunden",
"492404", "Alsdorf\ Rheinland",
"4936425", "Isserstedt",
"496789", "Heimbach\ Nahe",
"495357", "Grasleben",
"4933848", "Raben",
"496274", "Waldbrunn\ Odenwald",
"4938757", "Neustadt\-Glewe",
"4936424", "Kahla\ Thüringen",
"497382", "Römerstein",
"495373", "Hillerse\ Kreis\ Gifhorn",
"4939458", "Heudeber",
"495554", "Moringen",
"4934920", "Kropstädt",
"497303", "Illertissen",
"495368", "Parsau",
"496746", "Pfalzfeld",
"494803", "Pahlen",
"496305", "Hochspeyer",
"4939451", "Wasserleben",
"498207", "Affing",
"499820", "Lehrberg",
"4933841", "Belzig",
"497220", "Forbach\-Hundsbach",
"499634", "Wiesau",
"492175", "Leichlingen\ Rheinland",
"497623", "Rheinfelden\ Baden",
"492903", "Meschede\-Freienohl",
"496442", "Braunfels",
"496625", "Niederaula",
"4936962", "Vacha",
"495166", "Walsrode\-Kirchboitzen",
"499072", "Lauingen\ Donau",
"4936337", "Schiedungen",
"4937320", "Mulda\ Sachsen",
"4933763", "Bestensee",
"492982", "Medebach",
"495848", "Trebel",
"493874", "Ludwigslust",
"499468", "Zell\ Oberpfalz",
"494366", "Grömitz\-Cismar",
"49561", "Kassel",
"498061", "Bad\ Aibling",
"496656", "Ebersburg",
"492462", "Linnich",
"4933631", "Bad\ Saarow\-Pieskow",
"499266", "Mitwitz",
"496486", "Katzenelnbogen",
"496430", "Hahnstätten",
"496043", "Nidda",
"495027", "Linsburg",
"4933638", "Rüdersdorf\ bei\ Berlin",
"499473", "Kallmünz",
"497148", "Grossbottwar",
"497045", "Oberderdingen",
"496449", "Ehringshausen\-Katzenfurt",
"4940", "Hamburg",
"494266", "Brockel",
"492874", "Isselburg",
"498562", "Triftern",
"495951", "Werlte",
"499366", "Geroldshausen\ Unterfranken",
"494468", "Friedeburg\-Reepsholt",
"4933335", "Pinnow\ Kreis\ Uckermark",
"495769", "Steyerberg\-Voigtei",
"495044", "Springe\-Eldagsen",
"494473", "Emstek",
"4933334", "Greiffenberg",
"496151", "Darmstadt",
"4933836", "Butzow\ bei\ Brandenburg",
"4938782", "Reetz\ bei\ Perleberg",
"4939833", "Mirow\ Kreis\ Neustrelitz",
"4938853", "Drönnewitz\ bei\ Hagenow",
"499571", "Lichtenfels\ Bayern",
"493946", "Quedlinburg",
"4935024", "Stadt\ Wehlen",
"496695", "Jesberg",
"499560", "Grub\ am\ Forst",
"494634", "Husby",
"4935025", "Liebstadt",
"4934633", "Braunsbedra",
"492104", "Mettmann",
"4934783", "Gerbstedt",
"495661", "Melsungen",
"493462", "Bad\ Dürrenberg",
"498335", "Fellheim",
"495844", "Clenze",
"494245", "Neuenkirchen\ bei\ Bassum",
"492696", "Nohn\ Eifel",
"496237", "Maxdorf",
"499345", "Külsheim\ Baden",
"496772", "Nastätten",
"498259", "Schiltberg",
"494102", "Ahrensburg",
"4939032", "Mahlsdorf\ bei\ Salzwedel",
"492632", "Andernach",
"4936764", "Neuhaus\-Schierschnitz",
"496660", "Steinau\-Marjoss",
"4939822", "Kratzeburg",
"494183", "Jesteburg",
"4937208", "Auerswalde",
"494525", "Ahrensbök",
"495309", "Lehre\-Wendhausen",
"493863", "Crivitz",
"495533", "Bodenwerder",
"4934692", "Alsleben\ Saale",
"499638", "Neualbenreuth",
"497144", "Marbach\ am\ Neckar",
"495302", "Vechelde",
"493965", "Burow\ bei\ Altentreptow",
"498585", "Grainet",
"492639", "Anhausen\ Kreis\ Neuwied",
"498123", "Moosinning",
"4933741", "Niedergörsdorf",
"49881", "Weilheim\ in\ Oberbayern",
"4934637", "Frankleben",
"494872", "Hanerau\-Hademarschen",
"498252", "Schrobenhausen",
"494109", "Tangstedt\ Bz\ Hamburg",
"499937", "Oberpöring",
"4935771", "Bad\ Muskau",
"495383", "Lutter\ am\ Barenberge",
"4937329", "Grosshartmannsdorf",
"494556", "Ahrensbök\-Gnissau",
"499464", "Walderbach",
"4933748", "Treuenbrietzen",
"496284", "Mudau",
"498733", "Mengkofen",
"4937468", "Treuen\ Vogtland",
"497127", "Neckartenzlingen",
"492485", "Schleiden\-Dreiborn",
"496587", "Zerf",
"495202", "Oerlinghausen",
"4933767", "Friedersdorf\ bei\ Berlin",
"492655", "Weibern",
"495431", "Quakenbrück",
"493632", "Sondershausen",
"495145", "Beedenbostel",
"492863", "Velen",
"498193", "Geltendorf",
"494464", "Wittmund\-Carolinensiel",
"499556", "Geiselwind",
"4936333", "Heringen\ Helme",
"493731", "Freiberg\ Sachsen",
"496806", "Heusweiler",
"497943", "Schöntal\ Jagst",
"499872", "Heilsbronn",
"4933051", "Nassenheide",
"495283", "Lügde\-Rischenau",
"497272", "Rülzheim",
"494743", "Langen\ bei\ Bremerhaven",
"496384", "Konken",
"495827", "Unterlüss",
"492626", "Selters\ Westferwald",
"499102", "Wilhermsdorf",
"4939202", "Gross\ Ammensleben",
"497906", "Braunsbach",
"496337", "Grossbundenbach",
"496843", "Gersheim",
"499245", "Obertrubach",
"494706", "Schiffdorf",
"4934743", "Ermsleben",
"498861", "Schongau",
"492191", "Remscheid",
"494638", "Tarp",
"499525", "Königsberg\ in\ Bayern",
"499350", "Eussenheim\-Hundsbach",
"496534", "Mülheim\ Mosel",
"499183", "Burgthann",
"4938486", "Gustävel",
"497066", "Bad\ Rappenau\-Bonfeld",
"495209", "Gütersloh\-Friedrichsdorf",
"495976", "Salzbergen",
"498591", "Obernzell",
"4939294", "Gross\ Rosenburg",
"497365", "Essingen\ Württemberg",
"492421", "Düren",
"494483", "Ovelgönne\-Grossenmeer",
"4934299", "Gaschwitz",
"4934498", "Rositz",
"4939295", "Zuchau",
"498022", "Tegernsee",
"495264", "Kalletal",
"494865", "Osterhever",
"493523", "Coswig\ bei\ Dresden",
"496363", "Niederkirchen",
"499331", "Ochsenfurt",
"492306", "Lünen",
"498341", "Kaufbeuren",
"494402", "Rastede",
"492745", "Brachbach\ Sieg",
"494231", "Verden\ Aller",
"4934491", "Schmölln\ Thüringen",
"494409", "Westerstede\-Ocholt",
"492837", "Weeze",
"495636", "Lichtenfels\-Goddelsheim",
"4933870", "Zollchow\ bei\ Rathenow",
"499164", "Langenfeld\ Mittelfranken",
"4936459", "Blankenhain\ Thüringen",
"496765", "Gemünden\ Hunsrück",
"495692", "Wolfhagen",
"4939225", "Altengrabow",
"498029", "Kreuth\ bei\ Tegernsee",
"493491", "Lutherstadt\ Wittenberg",
"494963", "Dörpen",
"4937756", "Breitenbrunn\ Erzgebirge",
"497444", "Alpirsbach",
"4938753", "Wöbbelin",
"4939224", "Büden",
"4936258", "Friemar",
"492593", "Ascheberg\ Westfalen",
"497763", "Murg",
"498423", "Titting",
"4939365", "Bellingen\ bei\ Stendal",
"493306", "Gransee",
"499978", "Schönthal\ Oberpfalz",
"492243", "Eitorf",
"494164", "Harsefeld",
"495721", "Stadthagen",
"4939364", "Dolle",
"492972", "Schmallenberg",
"499409", "Pielenhofen",
"493745", "Falkenstein\ Vogtland",
"499090", "Rain\ Lech",
"4935388", "Klöden",
"495131", "Garbsen",
"4939925", "Wredenhagen",
"493421", "Torgau",
"495622", "Fritzlar",
"497427", "Schömberg\ bei\ Balingen",
"499082", "Oettingen\ in\ Bayern",
"492523", "Wadersloh",
"4939924", "Stuer",
"499963", "Konzell",
"495445", "Drebber",
"4934929", "Straach",
"497265", "Angelbachtal",
"499089", "Bissingen\-Unterringingen",
"499865", "Adelshofen\ Mittelfranken",
"4939994", "Metschow",
"4939426", "Hessen",
"492750", "Diedenshausen",
"499653", "Eslarn",
"4935363", "Fermerswalde",
"495364", "Velpke",
"498092", "Grafing\ bei\ München",
"4939995", "Nossendorf",
"499677", "Oberviechtach\-Pullenried",
"49385", "Schwerin",
"496263", "Neckargerach",
"497831", "Hausach",
"4934605", "Gröbers",
"499231", "Marktredwitz",
"499402", "Regenstauf",
"492206", "Overath",
"4934604", "Niemberg",
"498241", "Buchloe",
"498036", "Stephanskirchen\ Simssee",
"496476", "Mengerskirchen",
"492408", "Aachen\-Kornelimünster",
"494331", "Rendsburg",
"497660", "St\ Peter\ Schwarzwald",
"495535", "Polle",
"495702", "Petershagen\-Lahde",
"4935477", "Rietzneuendorf\-Friedrichshof",
"494523", "Malente",
"492581", "Warendorf",
"493865", "Holthusen",
"497671", "Todtnau",
"4934903", "Coswig\ Anhalt",
"494185", "Marxen\ Auetal",
"493677", "Ilmenau\ Thüringen",
"4933969", "Stepenitz",
"495601", "Schauenburg",
"4939052", "Erxleben\ bei\ Haldensleben",
"497237", "Neulingen\ Enzkreis",
"499343", "Lauda\-Königshofen",
"499837", "Haundorf",
"494972", "Langeoog",
"494243", "Twistringen",
"498509", "Ruderting",
"492164", "Jüchen\-Otzenrath",
"498847", "Obersöchering",
"4933977", "Gumtow",
"498333", "Babenhausen\ Schwaben",
"4938462", "Baumgarten",
"4935268", "Stauchitz",
"4939857", "Drense",
"492331", "Hagen\ Westfalen",
"495944", "Hoogstede",
"498502", "Fürstenzell",
"498735", "Gangkofen\-Kollbach",
"499306", "Kist",
"494408", "Hude\ Oldenburg",
"496372", "Bruchmühlbach\-Miesau",
"499745", "Wildflecken",
"494206", "Stuhr\-Heiligenrode",
"4933201", "Gross\ Glienicke",
"496144", "Bischofsheim\ bei\ Rüsselsheim",
"499421", "Straubing",
"4934463", "Bad\ Kösen",
"4938822", "Diedrichshagen\ bei\ Grevesmühlen",
"4935694", "Gosda\ bei\ Klinge",
"498028", "Fischbachau",
"497950", "Schnelldorf",
"495051", "Bergen\ Kreis\ Celle",
"498583", "Neureichenau",
"493963", "Woldegk",
"4933208", "Fahrland",
"494491", "Friesoythe",
"4935829", "Gersdorf\ bei\ Görlitz",
"4935695", "Simmersdorf",
"494884", "Schwabstedt",
"495285", "Bad\ Pyrmont\-Kleinenberg",
"496737", "Köngernheim",
"492402", "Stolberg\ Rheinland",
"4938202", "Volkenshagen",
"499206", "Mistelgau\-Obernsees",
"494745", "Bad\ Bederkesa",
"497806", "Bad\ Peterstal\-Griesbach",
"499408", "Altenthann",
"497945", "Wüstenrot",
"496272", "Hirschhorn\ Neckar",
"4935209", "Mohorn",
"497384", "Schelklingen\-Hütten",
"498195", "Weil\ Kreis\ Landsberg\ am\ Lech",
"497587", "Hosskirch",
"492865", "Raesfeld",
"493581", "Görlitz",
"496127", "Niedernhausen\ Taunus",
"495552", "Katlenburg",
"495143", "Winsen\ Aller",
"499491", "Hemau",
"492653", "Kaisersesch",
"492677", "Lutzerath",
"494421", "Wilhelmshaven",
"4939742", "Brüssow\ bei\ Pasewalk",
"499185", "Mühlhausen\ Oberpfalz",
"498651", "Bad\ Reichenhall",
"499088", "Mönchsdeggingen",
"4935247", "Zehren\ Sachsen",
"499523", "Hofheim\ in\ Unterfranken",
"497534", "Reichenau\ Baden",
"496066", "Michelstadt\-Vielbrunn",
"4934203", "Zwenkau",
"492963", "Brilon\-Messinghausen",
"499243", "Pottenstein",
"4936946", "Erbenhausen\ Thüringen",
"497337", "Nellingen\ Alb",
"497843", "Renchen",
"493331", "Angermünde",
"498752", "Au\ in\ der\ Hallertau",
"494837", "Neuenkirchen\ Dithmarschen",
"494343", "Laboe",
"499972", "Waldmünchen",
"497176", "Spraitbach",
"492409", "Stolberg\-Gressenich",
"498233", "Kissing",
"496784", "Weierbach",
"498824", "Oberau\ Loisach",
"498630", "Oberneukirchen",
"498686", "Petting",
"495221", "Herford",
"492743", "Daaden",
"492937", "Arnsberg\-Oeventrop",
"498456", "Lenting",
"498258", "Sielenbach",
"492464", "Aldenhoven\ bei\ Jülich",
"4936077", "Grossbodungen",
"498649", "Schleching",
"494863", "Sankt\ Peter\-Ording",
"493525", "Riesa",
"4938225", "Trinwillershagen",
"498267", "Dirlewang",
"4939753", "Strasburg",
"499639", "Mähring",
"495541", "Hann\.\ Münden",
"4938224", "Gresenhorst",
"497363", "Lauchheim",
"495308", "Lehre",
"494485", "Elsfleth\-Huntorf",
"499632", "Waldsassen",
"492595", "Olfen",
"497765", "Rickenbach\ Hotzenwald",
"4938294", "Neubukow",
"4939087", "Jerchel\ Altmark",
"496444", "Bischoffen",
"498642", "Übersee",
"4939882", "Gollin",
"4938733", "Karbow\-Vietlübbe",
"4938295", "Satow\ bei\ Bad\ Doberan",
"494191", "Kaltenkirchen\ Holstein",
"496763", "Kirchberg\ Hunsrück",
"499074", "Höchstädt\ an\ der\ Donau",
"494965", "Surwold",
"492638", "Waldbreitbach",
"494108", "Rosengarten\ Kreis\ Harburg",
"4935754", "Klettwitz",
"4939000", "Beetzendorf",
"498741", "Vilsbiburg",
"492984", "Hallenberg",
"494626", "Treia",
"4935755", "Ortrand",
"499191", "Forchheim\ Oberfranken",
"499965", "Sankt\ Englmar",
"495443", "Lemförde",
"492525", "Beckum\-Neubeckum",
"496427", "Cölbe\-Schönstadt",
"4937423", "Adorf\ Vogtland",
"4938426", "Neuburg\-Steinhausen",
"495764", "Steyerberg",
"492183", "Rommerskirchen",
"494121", "Elmshorn",
"49395", "Neubrandenburg",
"494632", "Steinbergkirche",
"493937", "Osterburg\ Altmark",
"499626", "Hohenburg",
"497931", "Bad\ Mergentheim",
"492102", "Ratingen",
"4935602", "Drebkau",
"492245", "Much",
"493464", "Sangerhausen",
"495086", "Celle\-Scheuen",
"494731", "Nordenham",
"492556", "Metelen",
"496831", "Saarlouis",
"495321", "Goslar",
"492872", "Rhede\ Westfalen",
"498564", "Johanniskirchen",
"493984", "Prenzlau",
"497476", "Bisingen",
"4938306", "Samtens",
"495406", "Belm",
"496265", "Billigheim\ Baden",
"498367", "Rosshaupten\ Forggensee",
"494639", "Schafflund",
"499655", "Tännesberg",
"495042", "Bad\ Münder\ am\ Deister",
"497263", "Waibstadt",
"495208", "Leopoldshöhe",
"497553", "Salem\ Baden",
"497142", "Bietigheim\-Bissingen",
"495304", "Meine",
"499946", "Hohenwarth\ bei\ Kötzing",
"493571", "Hoyerswerda",
"497577", "Veringenstadt",
"496203", "Ladenburg",
"492473", "Simmerath",
"499805", "Burgoberbach",
"492687", "Horhausen\ Westerwald",
"496555", "Bleialf",
"4937432", "Pausa\ Vogtland",
"495275", "Höxter\-Ottbergen",
"4939009", "Badel",
"498254", "Altomünster",
"494874", "Todenbüttel",
"497374", "Uttenweiler",
"4937349", "Scheibenberg",
"495849", "Waddeweitz",
"499462", "Falkenstein\ Oberpfalz",
"496282", "Walldürn",
"495507", "Ebergötzen",
"492266", "Lindlar",
"495842", "Schnega",
"499469", "Roding\-Neubäu",
"496526", "Bollendorf",
"493366", "Beeskow",
"496774", "Kaub",
"4935952", "Grossröhrsdorf\ OL",
"497130", "Löwenstein\ Württemberg",
"494104", "Aumühle\ bei\ Hamburg",
"492634", "Rengsdorf",
"499078", "Mertingen",
"494920", "Wirdum",
"4933452", "Neulewin",
"499175", "Spalt",
"496031", "Friedberg\ Hessen",
"496246", "Eich\ Rheinhessen",
"499903", "Schöllnach",
"497720", "Schwenningen\ am\ Neckar",
"498460", "Berching\-Holnstein",
"498707", "Adlkofen",
"499104", "Emskirchen",
"4930", "Berlin",
"494469", "Wangerooge",
"495773", "Stemwede\-Wehdem",
"496596", "Üdersdorf",
"4938458", "Zehna",
"492571", "Greven\ Westfalen",
"4939061", "Weferlingen",
"496346", "Annweiler\ am\ Trifels",
"495768", "Petershagen\-Heimsen",
"497703", "Bonndorf\ im\ Schwarzwald",
"4938792", "Lenzen\ \(Elbe\)",
"497451", "Horb\ am\ Neckar",
"496532", "Zeltingen\-Rachtig",
"4938451", "Hoppenrade\ bei\ Güstrow",
"494903", "Wymeer",
"499920", "Bischofsmais",
"497681", "Waldkirch\ Breisgau",
"494175", "Egestorf\ Nordheide",
"493473", "Aschersleben\ Sachsen\-Anhalt",
"4938722", "Raduhn",
"495204", "Steinhagen\ Westfalen",
"494805", "Schafstedt",
"497746", "Wutöschingen",
"496303", "Enkenbach\-Alsenborn",
"493634", "Sömmerda",
"497305", "Erbach\ Donau",
"494946", "Grossefehn\-Bagband",
"498557", "Mauth",
"496220", "Wilhelmsfeld",
"498573", "Ering",
"494462", "Wittmund",
"495375", "Müden\ Aller",
"4938737", "Ganzlin",
"499874", "Neuendettelsau",
"4933086", "Grieben\ Kreis\ Oberhavel",
"497274", "Germersheim",
"4939083", "Messdorf",
"496382", "Lauterecken",
"492366", "Herten\ Westfalen",
"494766", "Basdahl",
"4934441", "Hohenmölsen",
"492065", "Duisburg\-Rheinhausen",
"499162", "Scheinfeld",
"497966", "Unterschneidheim",
"495694", "Diemelstadt",
"4939245", "Loburg",
"496623", "Rotenburg\ an\ der\ Fulda",
"497442", "Baiersbronn",
"495647", "Lichtenau\-Kleinenberg",
"4934978", "Radegast\ Kreis\ Köthen",
"4935820", "Zodel",
"498801", "Seeshaupt",
"4939244", "Steutz",
"492157", "Nettetal\-Kaldenkirchen",
"492905", "Bestwig\-Ramsbeck",
"497625", "Zell\ im\ Wiesental",
"492173", "Langenfeld\ Rheinland",
"497043", "Maulbronn",
"498171", "Wolfratshausen",
"492803", "Wesel\-Büderich",
"498024", "Holzkirchen",
"495262", "Extertal",
"496045", "Gedern",
"497449", "Baiersbronn\-Obertal",
"4934207", "Zwochau",
"494404", "Elsfleth",
"4935243", "Weinböhla",
"497656", "Schluchsee",
"496866", "Perl\-Nennig",
"497486", "Horb\-Altheim",
"495948", "Itterbeck",
"4933973", "Zernitz\ bei\ Neustadt\ Dosse",
"4939853", "Holzendorf\ bei\ Prenzlau",
"4939976", "Gross\ Bützin",
"494475", "Molbergen",
"495362", "Wolfsburg\-Fallersleben",
"498094", "Steinhöring",
"497151", "Waiblingen",
"497388", "Pfronstetten",
"496050", "Biebergemünd",
"4936484", "Knau\ bei\ Pössneck",
"499404", "Nittendorf",
"4934907", "Jeber\-Bergfrieden",
"4935473", "Neu\ Lübbenau",
"494169", "Sauensiek",
"496788", "Sien",
"4935200", "Arnsdorf\ bei\ Dresden",
"494162", "Jork",
"4934467", "Eckartsberga",
"492974", "Schmallenberg\-Fredeburg",
"499766", "Grosswenkheim",
"495851", "Dahlenburg",
"4934653", "Rottleberode",
"496693", "Neuental",
"495624", "Bad\ Emstal",
"499084", "Bissingen\ Schwaben",
"494876", "Reher\ Holstein",
"493622", "Waltershausen\ Thüringen",
"495421", "Dissen\ am\ Teutoburger\ Wald",
"498458", "Gaimersheim",
"497376", "Langenenslingen",
"4937369", "Wolkenstein",
"4938731", "Lübz",
"494143", "Drochtersen",
"494552", "Leezen",
"493445", "Naumburg\ Saale",
"4939422", "Badersleben",
"492264", "Marienheide",
"499385", "Kolitzheim",
"495306", "Cremlingen",
"499944", "Miltach",
"493721", "Meinersdorf",
"498467", "Kinding",
"497727", "Vöhrenbach",
"494927", "Krummhörn\-Loquard",
"494285", "Rhade\ bei\ Zeven",
"4938738", "Karow\ bei\ Lübz",
"495745", "Stemwede\-Levern",
"495837", "Sprakensehl",
"498225", "Jettingen\-Scheppach",
"492636", "Burgbrohl",
"492680", "Mündersbach",
"496297", "Ravenstein\ Baden",
"498395", "Tannheim\ Württemberg",
"497561", "Leutkirch\ im\ Allgäu",
"4938457", "Krakow\ am\ See",
"496244", "Westhofen\ Rheinhessenen",
"4939862", "Schmölln\ bei\ Prenzlau",
"496327", "Neustadt\-Lachen",
"497570", "Sigmaringen\-Gutenstein",
"4937605", "Hartenstein\ Sachsen",
"492692", "Kelberg",
"494559", "Wensin",
"499535", "Pfarrweisach",
"4939751", "Penkun",
"496776", "Dachsenhausen",
"493364", "Eisenhüttenstadt",
"495593", "Bovenden\-Lenglern",
"4937604", "Mosel",
"496524", "Rodershausen",
"497184", "Kaisersbach",
"498545", "Hofkirchen\ Bayern",
"493629", "Stadtilm",
"494106", "Quickborn\ Kreis\ Pinneberg",
"498325", "Oberstaufen\-Thalkirchdorf",
"498550", "Philippsreut",
"496397", "Leimen\ Pfalz",
"492721", "Lennestadt",
"496344", "Schwegenheim",
"498295", "Altenmünster\ Schwaben",
"496227", "Walldorf\ Baden",
"497062", "Beilstein\ Württemberg",
"495185", "Duingen",
"492622", "Bendorf\ am\ Rhein",
"499106", "Markt\ Erlbach",
"492131", "Neuss",
"494535", "Nahe",
"494702", "Sandstedt",
"492445", "Schleiden\ Eifel",
"496809", "Grossrosseln",
"496594", "Birresborn",
"4937752", "Eibenstock",
"495523", "Bad\ Sachsa",
"496172", "Bad\ Homburg\ von\ der\ Höhe",
"499628", "Ursensollen",
"499552", "Burghaslach",
"499143", "Pappenheim\ Mittelfranken",
"495491", "Damme\ Dümmer",
"4933732", "Hennickendorf\ bei\ Luckenwalde",
"497478", "Hirrlingen",
"496802", "Völklingen\-Lauterbach",
"4937421", "Oelsnitz\ Vogtland",
"497276", "Herxheim\ bei\ Landau\ Pfalz",
"498133", "Haimhausen\ Oberbayern",
"499876", "Rohr\ Mittelfranken",
"492558", "Horstmar",
"492364", "Haltern\ Westfalen",
"499285", "Kirchenlamitz",
"496465", "Breidenbach\ bei\ Biedenkopf",
"492567", "Ahaus\-Alstätte",
"495206", "Bielefeld\-Jöllenbeck",
"497744", "Stühlingen",
"499927", "Kirchberg\ Wald",
"493636", "Greussen",
"494944", "Wiesmoor",
"49751", "Ravensburg",
"494385", "Hohenfelde\ bei\ Kiel",
"498723", "Arnstorf",
"497463", "Mühlheim\ an\ der\ Donau",
"4939265", "Löderburg",
"498167", "Zolling",
"495696", "Bad\ Arolsen\-Landau",
"498381", "Lindenberg\ im\ Allgäu",
"4933989", "Sadenbeck",
"492844", "Rheinberg\-Orsoy",
"495731", "Bad\ Oeynhausen",
"4939264", "Kroppenstedt",
"4939206", "Eichenbarleben",
"4933203", "Kleinmachnow",
"495121", "Hildesheim",
"494764", "Gnarrenburg\-Klenkendorf",
"4938482", "Warin",
"4934461", "Nebra\ Unstrut",
"495632", "Willingen\ Upland",
"493431", "Döbeln",
"492533", "Münster\-Nienberge",
"495074", "Rodewald",
"494443", "Dinklage",
"497964", "Stödtlen",
"498055", "Halfing",
"498158", "Tutzing",
"492309", "Waltrop",
"494208", "Grasberg",
"498531", "Pocking",
"492302", "Witten",
"494406", "Berne",
"4934901", "Rosslau\ Elbe",
"497654", "Löffingen",
"4935263", "Gröditz\ bei\ Riesa",
"497484", "Simmersfeld",
"493976", "Torgelow\ bei\ Ueckermünde",
"496864", "Mettlach",
"499221", "Kulmbach",
"492150", "Meerbusch\-Lank",
"4933470", "Lietzen",
"497821", "Lahr\ Schwarzwald",
"499391", "Marktheidenfeld",
"498026", "Hausham",
"494321", "Neumünster",
"492383", "Bönen",
"494541", "Ratzeburg",
"495655", "Wanfried",
"4939394", "Hohenberg\-Krusemark",
"492431", "Erkelenz",
"494308", "Schwedeneck",
"499406", "Mintraching",
"492202", "Bergisch\ Gladbach",
"495485", "Ladbergen",
"497808", "Hohberg\ bei\ Offenburg",
"498032", "Rohrdorf\ Kreis\ Rosenheim",
"496472", "Weilmünster",
"4939395", "Wanzer",
"495863", "Zernien",
"499208", "Bindlach",
"4933657", "Steinsdorf\ Brandenburg",
"493533", "Elsterwerda",
"493844", "Schwaan",
"499321", "Kitzingen",
"4939404", "Ausleben",
"4939405", "Hötensleben",
"4934208", "Löbnitz\ bei\ Delitzsch",
"4935323", "Sonnewalde",
"494221", "Delmenhorst",
"498281", "Thannhausen\ Schwaben",
"492827", "Goch\-Hassum",
"496068", "Beerfelden",
"495626", "Bad\ Zwesten",
"4939036", "Binde",
"496165", "Breuberg",
"499086", "Fremdingen",
"497163", "Ebersbach\ an\ der\ Fils",
"495108", "Gehrden\ Han",
"496479", "Waldbrunn\ Westerwald",
"498039", "Rott\ am\ Inn",
"493302", "Hennigsdorf",
"4939325", "Vinzelberg",
"495191", "Soltau",
"499443", "Abensberg",
"495965", "Klein\ Berssen",
"4939324", "Kläden\ bei\ Stendal",
"496057", "Flörsbachtal",
"4939826", "Blankensee\ bei\ Neustrelitz",
"499764", "Höchheim",
"496073", "Babenhausen\ Hessen",
"498433", "Königsmoos",
"4934977", "Quellendorf",
"4936702", "Lauscha",
"495903", "Emsbüren",
"4936204", "Stotternheim",
"495175", "Lehrte\-Arpke",
"4935327", "Priessen",
"496182", "Seligenstadt",
"492166", "Mönchengladbach\-Rheydt",
"497522", "Wangen\ im\ Allgäu",
"4936205", "Gräfenroda",
"4935248", "Schönfeld\ bei\ Grossenhain",
"494768", "Hipstedt",
"494757", "Wanna",
"4933653", "Ziltendorf",
"496103", "Langen\ Hessen",
"494773", "Lamstedt",
"497242", "Rheinstetten",
"499842", "Uffenheim",
"497973", "Obersontheim",
"4935241", "Lommatzsch",
"4933479", "Küstrin\-Kietz",
"496190", "Hattersheim\ am\ Main",
"497957", "Kressberg",
"495063", "Bad\ Salzdetfurth",
"49261", "Koblenz\ am\ Rhein",
"496146", "Hochheim\ am\ Main",
"4934973", "Osternienburg",
"4934443", "Teuchern",
"499275", "Speichersdorf",
"496873", "Nonnweiler",
"495462", "Ankum",
"493661", "Greiz",
"497667", "Breisach\ am\ Rhein",
"496857", "Namborn",
"497249", "Stutensee",
"495946", "Georgsdorf",
"496868", "Mettlach\-Tünsdorf",
"497529", "Waldburg\ Württemberg",
"4933832", "Rogäsen",
"493762", "Crimmitschau",
"494204", "Thedinghausen",
"495805", "Oetzen",
"494849", "Hooge",
"498663", "Ruhpolding",
"499375", "Freudenberg\ Baden",
"4934658", "Hayn\ Harz",
"496742", "Boppard",
"492951", "Büren",
"494275", "Ehrenburg",
"495874", "Soltendieck",
"494830", "Süderhastedt",
"4934651", "Rossla",
"4933207", "Gross\ Kreutz",
"4936465", "Oberndorf\ bei\ Apolda",
"496641", "Lauterbach\ Hessen",
"497804", "Oppenau",
"499204", "Plankenfels",
"498678", "Marktl",
"4936464", "Wormstedt",
"497386", "Hayingen",
"4933971", "Kyritz\ Brandenburg",
"4939851", "Göritz\ bei\ Prenzlau",
"4936966", "Kaltennordheim",
"497021", "Kirchheim\ unter\ Teck",
"497174", "Mögglingen",
"4935478", "Goyatz",
"492762", "Wenden\ Südsauerland",
"496786", "Kempfeld",
"4933978", "Segeletz",
"4939858", "Bietikow",
"4935267", "Diesbar\-Seusslitz",
"49361", "Erfurt",
"4935471", "Birkenhainchen",
"496120", "Aarbergen",
"499773", "Unsleben",
"494842", "Nordstrand",
"492661", "Bad\ Marienberg\ Westerwald",
"496403", "Linden\ Hessen",
"492942", "Geseke",
"499948", "Eschlkam",
"492273", "Kerpen\-Horrem",
"496751", "Bad\ Sobernheim",
"492257", "Reckerscheid",
"4933235", "Friesack",
"498684", "Fridolfing",
"495475", "Bohmte\-Hunteburg",
"492268", "Kürten",
"494362", "Heiligenhafen",
"498454", "Karlshuld",
"496652", "Hünfeld",
"4933234", "Wustermark",
"496482", "Runkel",
"499262", "Wallenfels",
"4937360", "Olbernhau",
"496659", "Eichenzell",
"499647", "Kirchenthumbach",
"497085", "Enzklösterle",
"499269", "Tettau\ Kreis\ Kronach",
"496083", "Weilrod",
"4939726", "Ducherow",
"498637", "Lohkirchen",
"494624", "Kropp",
"496002", "Ober\-Mörlen",
"496446", "Hohenahr",
"498271", "Meitingen",
"494851", "Marne",
"497351", "Biberach\ an\ der\ Riss",
"4936922", "Gerstungen",
"499076", "Wittislingen",
"495162", "Fallingbostel",
"4938874", "Lützow",
"499624", "Ensdorf\ Oberpfalz",
"497633", "Staufen\ im\ Breisgau",
"4933436", "Prötzel",
"4938376", "Zirchow",
"499369", "Uettingen",
"4938875", "Schlagsdorf\ bei\ Gadebusch",
"494269", "Ahausen\-Kirchwalsede",
"493466", "Artern\ Unstrut",
"495084", "Hambühren",
"496635", "Kirtorf",
"4939088", "Letzlingen",
"492775", "Driedorf",
"495766", "Rehburg\-Loccum",
"499851", "Dinkelsbühl",
"496348", "Offenbach\ an\ der\ Queich",
"4939081", "Kakerbeck\ Sachsen\-Anhalt",
"497251", "Bruchsal",
"4935936", "Sohland\ Spree",
"496501", "Konz",
"495404", "Westerkappeln",
"4935434", "Altdöbern",
"494948", "Wiesmoor\-Marcardsmoor",
"493949", "Oschersleben\ Bode",
"497748", "Grafenhausen\ Hochschwarzwald",
"4934721", "Nienburg\ Saale",
"492373", "Menden\ Sauerland",
"4935435", "Gollmitz\ bei\ Calau",
"496420", "Lahntal",
"492357", "Herscheid\ Westfalen",
"492554", "Laer\ Kreis\ Steinfurt",
"492368", "Oer\-Erkenschwick",
"494262", "Visselhövede",
"4936071", "Teistungen",
"495037", "Bad\ Rehburg",
"4938453", "Mistorf",
"497474", "Haigerloch",
"495347", "Burgdorf\ bei\ Salzgitter",
"495833", "Brome",
"498062", "Bruckmühl\ Mangfall",
"496293", "Schefflenz",
"49341", "Leipzig",
"495224", "Enger\ Westfalen",
"4939829", "Blankenförde",
"494825", "Burg\ Dithmarschen",
"493563", "Spremberg",
"496323", "Edenkoben",
"497325", "Sontheim\ an\ der\ Brenz",
"492461", "Jülich",
"49571", "Minden\ Westfalen",
"4934904", "Oranienbaum",
"4939039", "Bonese",
"4934905", "Wörlitz",
"493578", "Kamenz",
"496756", "Winterbach\ Soonwald",
"495544", "Reinhardshagen",
"497133", "Lauffen\ am\ Neckar",
"4939268", "Egeln",
"496441", "Wetzlar",
"498276", "Baar\ Schwaben",
"494856", "Kronprinzenkoog",
"4934465", "Bad\ Bibra",
"4936651", "Lobenstein",
"4934464", "Freyburg\ Unstrut",
"499071", "Dillingen\ an\ der\ Donau",
"4935693", "Lauschütz",
"494194", "Sievershütten",
"4937322", "Brand\-Erbisdorf",
"4935052", "Kipsdorf\ Kurort",
"497356", "Schemmerhofen",
"496135", "Bodenheim\ Rhein",
"49851", "Passau",
"499734", "Burkardroth",
"497723", "Furtwangen\ im\ Schwarzwald",
"498463", "Greding",
"496725", "Gau\-Algesheim",
"492981", "Winterberg\ Westfalen",
"494923", "Krummhörn\-Pewsum",
"498744", "Gerzen",
"495935", "Twist\-Schöninghsdorf",
"499147", "Nennslingen",
"498376", "Sulzberg\ Allgäu",
"497458", "Ebhausen",
"496159", "Messel",
"4939321", "Arneburg",
"499572", "Burgkunstadt",
"499194", "Ebermannstadt",
"496506", "Welschbillig",
"498137", "Petershausen",
"499856", "Dürrwangen",
"497256", "Philippsburg",
"494124", "Glückstadt",
"495761", "Stolzenau",
"4939328", "Rochau",
"492563", "Stadtlohn",
"49241", "Aachen",
"497934", "Weikersheim",
"499923", "Teisnach",
"4939247", "Güterglück",
"494734", "Stadland\-Seefeld",
"493461", "Merseburg\ Saale",
"495662", "Felsberg\ Hessen",
"498727", "Falkenberg\ Niederbayern",
"497467", "Neuhausen\ ob\ Eck",
"496887", "Schmelz\ Saar",
"495247", "Harsewinkel",
"496393", "Fischbach\ bei\ Dahn",
"4938780", "Lanz\ Brandenburg",
"495324", "Vienenburg",
"496834", "Bous",
"495294", "Hövelhof\-Espeln",
"496223", "Neckargemünd",
"497225", "Gaggenau",
"4939398", "Gross\ Garz",
"499825", "Herrieden",
"495952", "Sögel",
"493981", "Neustrelitz",
"498561", "Pfarrkirchen\ Niederbayern",
"4939401", "Neuwegersleben",
"497395", "Ehingen\-Dächingen",
"4934204", "Schkeuditz",
"4939209", "Wanzleben",
"497545", "Immenstaad\ am\ Bodensee",
"4939408", "Hadmersleben",
"4934205", "Markranstädt",
"496543", "Büchenbeuren",
"496152", "Gross\-Gerau",
"4933986", "Falkenhagen\ Kreis\ Prignitz",
"4939391", "Lückstedt",
"495527", "Duderstadt",
"498808", "Pähl",
"497032", "Herrenberg",
"492584", "Warendorf\-Milte",
"4937601", "Mülsen\ Skt\ Jacob",
"4938223", "Saal\ Vorpom",
"4935930", "Seitschen",
"4939754", "Löcknitz\ Vorpom",
"497674", "Todtmoos",
"4938370", "Kröslin",
"4937608", "Waldenburg\ Sachsen",
"4934292", "Brandis\ bei\ Wurzen",
"495604", "Grossalmerode",
"496620", "Philippsthal\ Werra",
"492161", "Mönchengladbach",
"492387", "Drensteinfurt\-Walstedde",
"495941", "Neuenhaus\ Dinkel",
"492334", "Hagen\-Hohenlimburg",
"4936452", "Berlstedt",
"4935753", "Grossräschen",
"493925", "Stassfurt",
"4934222", "Arzberg\ bei\ Torgau",
"499424", "Strasskirchen",
"497433", "Balingen",
"498075", "Amerang",
"496435", "Wallmerod",
"494447", "Vechta\-Langförden",
"498178", "Icking",
"494494", "Bösel\ Oldenburg",
"4937296", "Stollberg\ Erzgebirge",
"4938293", "Kühlungsborn\ Ostseebad",
"495054", "Bergen\-Sülze",
"4938735", "Plau\ am\ See",
"49211", "Düsseldorf",
"496646", "Grebenau",
"492823", "Goch",
"494881", "Friedrichstadt",
"492234", "Frechen",
"497381", "Münsingen",
"4934922", "Mühlanger",
"497055", "Neuweiler\ Kreis\ Calw",
"497158", "Neuhausen\ auf\ den\ Fildern",
"499447", "Essing",
"496053", "Wächtersbach",
"4934362", "Mügeln\ bei\ Oschatz",
"498654", "Freilassing",
"495675", "Trendelburg",
"492666", "Freilingen\ Westerwald",
"496682", "Tann\ Rhön",
"4939602", "Kleeth",
"497531", "Konstanz",
"496452", "Battenberg\ Eder",
"493537", "Jessen\ Elster",
"497026", "Lenningen",
"493334", "Eberswalde",
"49355", "Cottbus",
"4937366", "Rübenau",
"495858", "Hitzacker\-Wietzetze",
"498821", "Garmisch\-Partenkirchen",
"496781", "Idar\-Oberstein",
"492925", "Warstein\-Allagen",
"499565", "Untersiemau",
"499255", "Marktleugast",
"494239", "Dörverden\-Westen",
"496665", "Sinntal\-Altengronau",
"495126", "Algermissen",
"498349", "Stötten\ am\ Auerberg",
"499503", "Oberhaid\ Oberfranken",
"497663", "Eichstetten",
"4935842", "Oderwitz",
"495608", "Söhrewald",
"496853", "Marpingen",
"499339", "Ippesheim",
"494355", "Rieseby",
"494240", "Syke\-Heiligenfelde",
"4933872", "Hohennauen",
"4939952", "Grammentin",
"498330", "Legau",
"498386", "Oberstaufen",
"495691", "Bad\ Arolsen",
"492429", "Hürtgenwald",
"492588", "Harsewinkel\-Greffen",
"499340", "Königheim\-Brehmen",
"495907", "Geeste",
"494498", "Saterland\-Ramsloh",
"499396", "Urspringen\ bei\ Lohr",
"4935939", "Hochkirch",
"495155", "Emmerthal",
"492422", "Kreuzau",
"4933231", "Pausin",
"498592", "Wegscheid\ Niederbayern",
"497826", "Schuttertal",
"499428", "Kirchroth",
"494326", "Wankendorf",
"498021", "Waakirchen",
"494296", "Schwanewede\-Aschwarden",
"492645", "Vettelschoss",
"4933238", "Senzke",
"494753", "Balje",
"498536", "Kösslarn",
"496107", "Kelsterbach",
"494777", "Cadenberge",
"499332", "Marktbreit",
"492338", "Breckerfeld",
"497977", "Oberrot\ bei\ Gaildorf",
"493971", "Anklam",
"4938379", "Benz\ Usedom",
"499546", "Burgebrach",
"494232", "Langwedel\ Kreis\ Verden",
"4933439", "Fredersdorf\-Vogelsdorf",
"497953", "Blaufelden",
"494401", "Brake\ Unterweser",
"495067", "Bockenem",
"498342", "Marktoberdorf",
"4933931", "Rheinsberg\ Mark",
"499326", "Markt\ Einersheim",
"4936075", "Dingelstädt\ Eichsfeld",
"497154", "Kornwestheim",
"493588", "Niesky",
"498091", "Kirchseeon",
"4938232", "Zingst\ Ostseebad",
"495139", "Burgwedel",
"499498", "Laaber",
"4936074", "Worbis",
"499401", "Neutraubling",
"492436", "Wegberg\-Rödgen",
"498105", "Gilching",
"499232", "Wunsiedel",
"494546", "Mustin\ Lauenburg",
"497832", "Haslach\ im\ Kinzigtal",
"492238", "Pulheim",
"499777", "Ostheim\ von\ der\ Rhön",
"4938227", "Lüdershagen\ bei\ Barth",
"494332", "Hamdorf\ bei\ Rendsburg",
"495722", "Bückeburg",
"498667", "Seeon\-Seebruck",
"4938297", "Moitin",
"499355", "Frammersbach",
"495196", "Wietzendorf",
"494339", "Christiansholm",
"494503", "Timmendorfer\ Strand",
"4939084", "Lindstedt",
"498249", "Ettringen\ Wertach",
"495854", "Bleckede\-Barskamp",
"492971", "Schmallenberg\-Dorlar",
"494255", "Martfeld",
"497839", "Schapbach",
"4939085", "Zichtau",
"493338", "Bernau\ Brandenburg",
"495621", "Bad\ Wildungen",
"494340", "Achterwehr",
"495132", "Lehrte",
"498230", "Gablingen",
"4938871", "Mühlen\ Eichsen",
"499081", "Nördlingen",
"493574", "Lauchhammer",
"499643", "Auerbach\ in\ der\ Oberpfalz",
"493726", "Flöha",
"495301", "Lehre\-Essenrode",
"4939243", "Nedlitz\ bei\ Zerbst",
"496087", "Waldems",
"492129", "Haan\ Rheinland",
"498633", "Tüssling",
"495426", "Glandorf",
"494871", "Hohenwestedt",
"498251", "Aichach",
"4936969", "Merkers",
"492739", "Wilnsdorf",
"493377", "Zossen\ Brandenburg",
"495228", "Vlotho\-Exter",
"497371", "Riedlingen\ Württemberg",
"492505", "Altenberge\ Westfalen",
"496407", "Rabenau\ Hessen",
"492732", "Kreuztal",
"4935244", "Krögis",
"4939820", "Triepkendorf",
"494101", "Pinneberg",
"499738", "Rottershausen",
"4936208", "Ermstedt",
"496771", "St\ Goarshausen",
"4935245", "Burkhardswalde\-Munzig",
"492253", "Bad\ Münstereifel",
"499606", "Pfreimd",
"497566", "Argenbühl",
"495685", "Knüllwald",
"496034", "Wöllstadt",
"4939030", "Brunau",
"495455", "Tecklenburg\-Brochterbeck",
"492631", "Neuwied",
"4936201", "Walschleben",
"4936626", "Auma",
"499128", "Feucht",
"496672", "Eiterfeld",
"498405", "Stammham\ bei\ Ingolstadt",
"499101", "Langenzenn",
"4935474", "Schönwalde\ bei\ Lübben",
"4938789", "Wolfshagen\ bei\ Perleberg",
"492377", "Wickede\ Ruhr",
"497938", "Mulfingen\ Jagst",
"4935475", "Straupitz",
"492353", "Halver",
"4936483", "Ziegenrück",
"494128", "Kollmar",
"492574", "Saerbeck",
"4933975", "Dannenwalde\ Kreis\ Prignitz",
"492192", "Hückeswagen",
"4939855", "Parmen\-Weggun",
"498862", "Steingaden\ Oberbayern",
"495033", "Wunstorf\-Grossenheidorn",
"499198", "Heiligenstadt\ in\ Oberfranken",
"497684", "Glottertal",
"4939200", "Gommern",
"495439", "Bersenbrück",
"4933974", "Dessow",
"494606", "Wanderup",
"4939854", "Kleptow",
"497454", "Sulz\ am\ Neckar",
"493631", "Nordhausen\ Thüringen",
"4936461", "Bad\ Sulza",
"495432", "Löningen",
"495201", "Halle\ Westfalen",
"4933476", "Neuhardenberg",
"498085", "Sankt\ Wolfgang",
"498869", "Kinsau",
"4934654", "Stolberg\ Harz",
"494643", "Gelting\ Angeln",
"492755", "Bad\ Berleburg\-Schwarzenau",
"497260", "Sinsheim\-Hilsbach",
"4935697", "Bagenz",
"496838", "Saarwellingen",
"495328", "Altenau\ Harz",
"497271", "Wörth\ am\ Rhein",
"499871", "Windsbach",
"492841", "Moers",
"495734", "Bergkirchen\ Westfalen",
"494662", "Leck",
"498384", "Röthenbach\ Allgäu",
"499935", "Stephansposching",
"494959", "Dollart",
"4935751", "Welzow",
"496352", "Kirchheimbolanden",
"498806", "Utting\ am\ Ammersee",
"4938309", "Trent",
"495060", "Bodenburg",
"494761", "Bremervörde",
"493967", "Oertzenhof\ bei\ Strasburg",
"497195", "Winnenden",
"497961", "Ellwangen\ Jagst",
"495071", "Schwarmstedt",
"494770", "Wischhafen",
"498534", "Tettenweis",
"494527", "Bosau",
"49971", "Bad\ Kissingen",
"4937603", "Wildenfels",
"4938221", "Marlow",
"499544", "Baunach",
"4933922", "Karwesee",
"496861", "Merzig",
"4933080", "Marienthal\ Kreis\ Oberhavel",
"497651", "Titisee\-Neustadt",
"494952", "Rhauderfehn",
"499394", "Esselbach",
"4938228", "Dettmannsdorf\-Kölzow",
"499347", "Wittighausen",
"497233", "Niefern\-Öschelbronn",
"499833", "Heidenheim\ Mittelfranken",
"498176", "Egling\ bei\ Wolfratshausen",
"496359", "Grünstadt",
"497824", "Schwanau",
"4938429", "Glasin",
"494247", "Affinghausen",
"494324", "Brokstedt",
"496235", "Schifferstadt",
"498337", "Altenstadt\ Iller",
"494294", "Riede\ Kreis\ Verden",
"4933362", "Liepe\ Kreis\ Barnim",
"498671", "Altötting",
"49791", "Schwäbisch\ Hall",
"492434", "Wegberg",
"494544", "Berkenthin",
"499527", "Knetzgau",
"49471", "Bremerhaven",
"496648", "Bad\ Salzschlirf",
"492958", "Büren\-Harth",
"498772", "Mallersdorf\-Pfaffenberg",
"499294", "Regnitzlosau",
"4934382", "Nerchau",
"497333", "Laichingen",
"499324", "Dettelbach",
"493841", "Wismar",
"494833", "Wesselburen",
"494347", "Flintbek",
"497156", "Ditzingen",
"4933237", "Paulinenaue",
"494224", "Gross\ Ippener",
"496335", "Trulben",
"498237", "Aindling",
"495825", "Wieren",
"494394", "Bokhorst",
"499952", "Eichendorf",
"495923", "Schüttorf",
"496733", "Gau\-Odernheim",
"498284", "Ziemetshausen",
"494935", "Juist",
"499662", "Vilseck",
"497502", "Wolpertswende",
"497735", "Öhningen",
"496252", "Heppenheim\ Bergstrasse",
"495572", "Bodenfelde",
"497583", "Bad\ Schussenried",
"4936642", "Harra",
"495194", "Bispingen",
"496123", "Eltville\ am\ Rhein",
"495147", "Uetze\-Hänigsen",
"49681", "Saarbrücken",
"492657", "Uersfeld",
"499761", "Bad\ Königshofen\ im\ Grabfeld",
"497125", "Bad\ Urach",
"492673", "Ellenz\-Poltersdorf",
"496585", "Ralingen",
"495424", "Bad\ Rothenfelde",
"4936653", "Lehesten\ Thüringer\ Wald",
"492261", "Gummersbach",
"4936949", "Obermassfeld\-Grimmenthal",
"4935691", "Bärenklau\ NL",
"496400", "Mücke",
"499941", "Kötzting",
"496758", "Waldböckelheim",
"493724", "Burgstädt",
"4933204", "Beelitz\ Mark",
"493576", "Weisswasser",
"4939263", "Unseburg",
"492835", "Issum",
"4933205", "Michendorf",
"4935698", "Hornow",
"4934772", "Helbra",
"499604", "Wernberg\-Köblitz",
"497358", "Eberhardzell\-Füramoos",
"496036", "Wölfersheim",
"496241", "Worms",
"497564", "Bad\ Wurzach",
"4939489", "Strassberg\ Harz",
"492747", "Molzhain",
"492933", "Sundern\ Sauerland",
"494858", "Sankt\ Margarethen\ Holstein",
"4935206", "Kreischa\ bei\ Dresden",
"498263", "Breitenbrunn\ Schwaben",
"4935264", "Strehla",
"49231", "Dortmund",
"496092", "Heimbuchenthal",
"4936022", "Grossengottern",
"497181", "Schorndorf\ Württemberg",
"497367", "Aalen\-Ebnat",
"493361", "Fürstenwalde\ Spree",
"4935265", "Glaubitz",
"497258", "Oberderdingen\-Flehingen",
"4935826", "Königshain\ bei\ Görlitz",
"496341", "Landau\ in\ der\ Pfalz",
"4936207", "Plaue\ Thüringen",
"492724", "Finnentrop\-Serkenrode",
"4935324", "Crinitz",
"496508", "Hetzerath\ Mosel",
"495565", "Einbeck\-Wenzen",
"494604", "Grossenwiehe",
"4939403", "Gröningen\ Sachsen\-Anhalt",
"492852", "Hamminkeln",
"498378", "Buchenberg\ bei\ Kempten",
"497456", "Haiterbach",
"4935325", "Rückersdorf\ bei\ Finsterwalde",
"499675", "Altendorf\ am\ Nabburg",
"496022", "Obernburg\ am\ Main",
"498363", "Pfronten",
"49221", "Cologne",
"496591", "Gerolstein",
"4939393", "Werben\ Elbe",
"499867", "Geslau",
"497267", "Gemmingen",
"4933396", "Klosterfelde",
"497642", "Endingen\ Kaiserstuhl",
"49331", "Potsdam",
"495447", "Lembruch",
"4939323", "Schönhausen\ Elbe",
"496423", "Wetter\ Hessen",
"495494", "Holdorf\ Niedersachsen",
"492361", "Recklinghausen",
"496029", "Mömbris",
"498765", "Bruckberg\ Niederbayern",
"497425", "Trossingen",
"493933", "Genthin",
"4933966", "Dranse",
"497741", "Tiengen\ Hochrhein",
"492859", "Wesel\-Bislich",
"494941", "Aurich",
"4939397", "Geestgottberg",
"495332", "Schöppenstedt",
"498782", "Pfeffenhausen",
"4933655", "Grunow\ Kreis\ Oder\-Spree",
"494140", "Estorf\ Kreis\ Stade",
"4933654", "Fünfeichen",
"496754", "Martinstein",
"495546", "Scheden",
"4938352", "Kemnitz\ bei\ Greifswald",
"4939407", "Seehausen\ Börde",
"495226", "Bruchmühlen\ Westfalen",
"499907", "Zenting",
"494139", "Hohnstorf\ Elbe",
"499155", "Simmelsdorf",
"498681", "Waging\ am\ See",
"4936203", "Vieselbach",
"492052", "Velbert\-Langenberg",
"495428", "Melle\-Neuenkirchen",
"498703", "Essenbach",
"4936940", "Oepfershausen",
"497557", "Herdwangen\-Schönach",
"4939241", "Leitzkau",
"499736", "Oberthulba",
"497573", "Stetten\ am\ kalten\ Markt",
"496207", "Wald\-Michelbach",
"495582", "Sankt\ Andreasberg",
"496575", "Landscheid",
"492683", "Asbach\ Westerwald",
"494621", "Schleswig",
"492453", "Heinsberg\-Randerath",
"494132", "Amelinghausen",
"4934445", "Stössen",
"498274", "Buttenwiesen",
"494854", "Friedrichskoog",
"492602", "Montabaur",
"4939248", "Dobritz",
"499126", "Eckental",
"4934975", "Görzig\ Kreis\ Köthen",
"495255", "Altenbeken",
"494722", "Cuxhaven\-Altenbruch",
"4939327", "Klietz",
"4934444", "Lützen",
"495339", "Gielde",
"497354", "Erolzheim",
"497568", "Bad\ Wurzach\-Hauerz",
"495503", "Nörten\-Hardenberg",
"499608", "Kohlberg\ Oberpfalz",
"4936463", "Gebstedt",
"498205", "Dasing",
"499132", "Herzogenaurach",
"497936", "Schrozberg\-Bartenstein",
"499621", "Amberg\ Oberpfalz",
"496307", "Schopp",
"494736", "Butjadingen\-Tossens",
"4939267", "Schneidlingen",
"498142", "Olching",
"498553", "Spiegelau",
"498374", "Dietmannsried",
"494608", "Handewitt",
"499722", "Werneck",
"495520", "Braunlage",
"499196", "Wiesenttal",
"495355", "Frellstedt",
"496504", "Thalfang",
"497254", "Waghäusel",
"499854", "Wittelshofen",
"494792", "Worpswede",
"494126", "Horst\ Holstein",
"495232", "Lage\ Lippe",
"495401", "Georgsmarienhütte",
"495753", "Auetal\-Bernsen",
"4933702", "Wünsdorf",
"495777", "Diepenau\-Essern",
"499729", "Grettstadt",
"4936481", "Neustadt\ an\ der\ Orla",
"495326", "Langelsheim",
"496836", "Überherrn",
"492551", "Steinfurt\-Burgsteinfurt",
"497707", "Bräunlingen",
"494155", "Büchen",
"493683", "Schmalkalden",
"497471", "Hechingen",
"495606", "Zierenberg",
"4933233", "Ketzin",
"498151", "Starnberg",
"4933089", "Himmelpfort",
"495128", "Hohenhameln",
"495025", "Estorf\ Weser",
"493322", "Falkensee",
"496562", "Speicher",
"492586", "Beelen",
"4935726", "Gross\ Särchen",
"498388", "Hergensweiler",
"497676", "Feldberg\ Schwarzwald",
"494298", "Lilienthal",
"492392", "Werdohl",
"494328", "Rickling",
"499426", "Oberschneiding",
"492222", "Bornheim\ Rheinland",
"493329", "Stahnsdorf",
"499228", "Thurnau",
"496569", "Bickendorf",
"499398", "Birkenfeld\ bei\ Würzburg",
"4935796", "Panschwitz\-Kuckau",
"494496", "Friesoythe\-Markhausen",
"495056", "Winsen\-Meissendorf",
"496627", "Nentershausen\ Hessen",
"499548", "Mühlhausen\ Mittelfranken",
"495643", "Borgentreich",
"492336", "Schwelm",
"494432", "Dötlingen\-Brettorf",
"492542", "Gescher",
"4938300", "Insel\ Hiddensee",
"492153", "Nettetal\-Lobberich",
"498538", "Pocking\-Hartkirchen",
"492292", "Windeck\ Sieg",
"493586", "Neugersdorf\ Sachsen",
"494426", "Wangerland\-Horumersiel",
"4934342", "Neukieritzsch",
"492954", "Rüthen\-Oestereiden",
"499201", "Gesees",
"496644", "Grebenhain",
"496697", "Willingshausen",
"492041", "Bottrop",
"492236", "Wesseling\ Rheinland",
"498442", "Wolnzach",
"4938873", "Carlow",
"497024", "Wendlingen\ am\ Neckar",
"4933933", "Lindow\ Mark",
"4937346", "Geyer",
"4938454", "Kritzkow",
"498043", "Jachenau",
"497171", "Schwäbisch\ Gmünd",
"4939006", "Miesterhorst",
"495198", "Schneverdingen\-Wintermoor",
"499439", "Neunburg\-Kemnath",
"493542", "Lübbenau\ Spreewald",
"494455", "Jade\-Schweiburg",
"4938455", "Plaaz",
"495101", "Pattensen",
"498656", "Anger",
"4936732", "Könitz",
"4937607", "Ebersbrunn\ Sachsen",
"4935433", "Vetschau",
"492664", "Rennerod",
"496061", "Michelstadt",
"492301", "Holzwickede",
"498532", "Griesbach\ im\ Rottal",
"498705", "Altfraunhofen",
"492548", "Dülmen\-Rorup",
"499336", "Bütthard",
"494236", "Kirchlinteln",
"499542", "Schesslitz",
"499153", "Schnaittach",
"4933472", "Golzow\ bei\ Seelow",
"4938332", "Gross\ Bisdorf",
"498346", "Pforzen",
"495129", "Söhlde",
"499177", "Heideck",
"4933634", "Berkenbrück\ Kreis\ Oder\-Spree",
"499392", "Faulbach\ Unterfranken",
"494954", "Moormerland",
"492426", "Nörvenich",
"497822", "Ettenheim",
"499222", "Presseck",
"4933635", "Arensdorf\ Kreis\ Oder\-Spree",
"492228", "Remagen\-Rolandseck",
"494322", "Bordesholm",
"4938327", "Elmenhorst\ Vorpom",
"498389", "Weissensberg",
"497754", "Görwihl",
"4936743", "Teichel",
"494292", "Ritterhude",
"495732", "Löhne",
"495505", "Hardegsen",
"494329", "Langwedel\ Holstein",
"4933839", "Wusterwitz",
"494664", "Neukirchen\ bei\ Niebüll",
"498382", "Lindau\ Bodensee",
"493496", "Köthen\ Anhalt",
"495253", "Bad\ Driburg",
"493328", "Teltow",
"495277", "Höxter\-Fürstenau",
"499229", "Mainleus",
"496568", "Wolsfeld",
"496557", "Hallschlag",
"492455", "Waldfeucht",
"499549", "Lisberg",
"495631", "Korbach",
"496573", "Gillenfeld",
"492685", "Flammersfeld",
"497575", "Messkirch",
"498303", "Waltenhofen",
"498282", "Krumbach\ Schwaben",
"495136", "Burgdorf\ Kreis\ Hannover",
"499664", "Hahnbach",
"495353", "Königslutter\ am\ Elm",
"497504", "Horgenzell",
"492440", "Nettersheim\-Tondorf",
"4935028", "Krippen",
"496254", "Lautertal\ Odenwald",
"495377", "Ehra\-Lessien",
"495726", "Wiedensahl",
"495574", "Oberweser",
"4936622", "Triebes",
"495192", "Munster",
"497307", "Senden\ Iller",
"498555", "Perlesreut",
"498320", "Missen\-Wilhams",
"493301", "Oranienburg",
"4935021", "Königstein\ Sächsische\ Schweiz",
"498203", "Grossaitingen",
"493685", "Hildburghausen",
"494177", "Drage\ Elbe",
"4933331", "Casekow",
"492432", "Wassenberg",
"496707", "Windesheim",
"497836", "Schiltach",
"499236", "Nagel",
"499280", "Selbitz\ Oberfranken",
"494153", "Lauenburg\ Elbe",
"494542", "Mölln\ Lauenburg",
"4936692", "Bürgel",
"495199", "Schneverdingen\-Heber",
"494336", "Owschlag",
"499438", "Fensterbach",
"498246", "Waal",
"498031", "Rosenheim\ Oberbayern",
"496471", "Weilburg",
"4933338", "Stolpe\/Oder",
"498774", "Bayerbach\ bei\ Ergoldsbach",
"499292", "Konradsreuth",
"4939777", "Borkenfriede",
"495755", "Kalletal\-Varenholz",
"494222", "Ganderkesee",
"499954", "Simbach\ Niederbayern",
"494392", "Nortorf\ bei\ Neumünster",
"499602", "Neustadt\ an\ der\ Waldnaab",
"497562", "Isny\ im\ Allgäu",
"4936605", "Bad\ Köstritz",
"4939387", "Havelberg",
"496676", "Hohenroda\ Hessen",
"4936604", "Münchenbernsdorf",
"4933671", "Lieberose",
"492608", "Welschneudorf",
"496047", "Altenstadt\ Hessen",
"494138", "Betzendorf\ Kreis\ Lüneburg",
"499701", "Sandberg\ Unterfranken",
"492691", "Adenau",
"4936847", "Steinbach\-Hallenberg",
"492736", "Burbach\ Siegerl",
"495023", "Liebenau\ Kreis\ Nieburg\ Weser",
"496094", "Weibersbrunn",
"4933678", "Storkow\ Mark",
"495429", "Melle\-Wellingholzhausen",
"4936042", "Tonna",
"499683", "Friedenfels",
"499453", "Thalmassing",
"495422", "Melle",
"493621", "Gotha\ Thüringen",
"497627", "Steinen\ Kreis\ Lörrach",
"492058", "Wülfrath",
"494551", "Bad\ Segeberg",
"495645", "Borgentreich\-Borgholz",
"4936929", "Ruhla",
"4936377", "Rastenberg",
"493722", "Limbach\-Oberfrohna",
"497569", "Isny\-Eisenbach",
"497644", "Kenzingen",
"4933844", "Brück\ Brandenburg",
"4939343", "Jerichow",
"493691", "Eisenach\ Thüringen",
"4936428", "Stadtroda",
"495492", "Steinfeld\ Oldenburg",
"4939454", "Elbingerode\ Harz",
"499551", "Burgwindheim",
"498623", "Kirchweidach",
"4933845", "Borkheide",
"4934673", "Heldrungen",
"4939455", "Schierke",
"495436", "Nortrup",
"4936421", "Camburg",
"494609", "Eggebek",
"4935875", "Obercunnersdorf\ bei\ Löbau",
"495650", "Cornberg",
"4933607", "Briesen\ Mark",
"495238", "Nieheim\-Himmighausen",
"4935874", "Bernstadt\ an\ der\ Eigen",
"496898", "Völklingen",
"4935453", "Drahnsdorf",
"492722", "Attendorn",
"492196", "Wermelskirchen",
"495971", "Rheine",
"499728", "Wülfershausen\ Unterfranken",
"494602", "Freienwill",
"494453", "Zetel",
"493907", "Gardelegen",
"492132", "Meerbusch\-Büderich",
"496024", "Schöllkrippen",
"494477", "Lastrup\-Hemmelte",
"494683", "Oldsum",
"492621", "Lahnstein",
"498045", "Lenggries\-Fall",
"496171", "Oberursel\ Taunus",
"4933876", "Buschow",
"4939956", "Neukalen",
"4936920", "Grossenlupnitz",
"497193", "Sulzbach\ an\ der\ Murr",
"4939606", "Glienke",
"4939221", "Möckern\ bei\ Magdeburg",
"4933603", "Falkenhagen\ bei\ Seelow",
"49931", "Würzburg",
"4936082", "Ershausen",
"495584", "Hattorf\ am\ Harz",
"49421", "Bremen",
"496195", "Kelkheim\ Taunus",
"494134", "Embsen\ Kreis\ Lüneburg",
"4934425", "Droyssig",
"498272", "Wertingen",
"494852", "Brunsbüttel",
"492604", "Nassau\ Lahn",
"4936254", "Friedrichswerth",
"499747", "Geroda\ Bayern",
"499933", "Wallersdorf",
"495161", "Walsrode",
"494724", "Cuxhaven\-Lüdingworth",
"4939347", "Kade",
"4934424", "Reuden\ bei\ Zeitz",
"4936255", "Goldbach\ bei\ Gotha",
"497352", "Ochsenhausen",
"49208", "Oberhausen\ Rheinland",
"4937362", "Seiffen\ Erzgebirge",
"4934926", "Pretzsch\ Elbe",
"498845", "Bad\ Kohlgrub",
"4934494", "Ehrenhain",
"495334", "Hornburg\ Kreis\ Wolfenbüttel",
"492941", "Lippstadt",
"496824", "Ottweiler",
"498784", "Hohenthann",
"496233", "Frankenthal\ Pfalz",
"494859", "Windbergen",
"499835", "Ehingen\ Mittelfranken",
"4934495", "Dobitschen",
"4939298", "Barby\ Elbe",
"497235", "Unterreichenbach\ Kreis\ Calw",
"496752", "Kirn\ Nahe",
"498066", "Bad\ Feilnbach",
"499270", "Creussen",
"494187", "Holm\-Seppensen",
"494361", "Oldenburg\ in\ Holstein",
"493675", "Sonneberg\ Thüringen",
"499261", "Kronach",
"493867", "Lübstorf",
"492054", "Essen\-Kettwig",
"4939291", "Calbe\ Saale",
"496651", "Rasdorf",
"495823", "Bienenbüttel",
"496509", "Büdlich",
"496894", "St\ Ingbert",
"495234", "Horn\-Bad\ Meinberg",
"497259", "Östringen\-Odenheim",
"4934601", "Teutschenthal",
"494835", "Albersdorf\ Holstein",
"496333", "Waldfischbach\-Burgalben",
"49511", "Hannover",
"498379", "Waltenhofen\-Oberdorf",
"4936843", "Benshausen",
"497335", "Wiesensteig",
"4939998", "Loitz\ bei\ Demmin",
"494261", "Rotenburg\ Wümme",
"4937292", "Oederan",
"4939991", "Daberkow",
"499187", "Altdorf\ bei\ Nürnberg",
"4939383", "Sandau\ Elbe",
"495956", "Rastdorf",
"492675", "Ediger\-Eller",
"497123", "Metzingen\ Württemberg",
"4939921", "Ankershagen",
"499134", "Neunkirchen\ am\ Brand",
"496583", "Palzem",
"49340", "Dessau\ Anh",
"49921", "Bayreuth",
"49781", "Offenburg",
"49431", "Kiel",
"498144", "Grafrath",
"497585", "Ostrach",
"492867", "Heiden\ Kreis\ Borken",
"496028", "Sulzbach\ am\ Main",
"498372", "Obergünzburg",
"4935385", "Annaburg",
"492858", "Hünxe",
"4936373", "Buttstädt",
"499576", "Lichtenfels\-Isling",
"4939928", "Möllenhagen",
"4939361", "Lüderitz",
"493941", "Halberstadt",
"499724", "Stadtlauringen",
"497733", "Engen\ Hegau",
"497947", "Forchtenberg",
"4935384", "Steinsdorf\ bei\ Jessen",
"496502", "Schweich",
"496735", "Eppelsheim",
"494933", "Dornum\ Ostfriesland",
"494747", "Beverstedt",
"4934296", "Groitzsch\ bei\ Pegau",
"497252", "Bretten",
"494794", "Worpswede\-Ostersode",
"499852", "Feuchtwangen",
"495925", "Wietmarschen",
"4936783", "Gehren\ Thüringen",
"492394", "Neuenrade\-Affeln",
"4935775", "Pechern",
"492833", "Kerken",
"492224", "Bad\ Honnef",
"4933830", "Ziesar",
"4935774", "Boxberg\ Sachsen",
"494958", "Jemgum",
"495461", "Bramsche\ Hase",
"494967", "Rhauderfehn\-Burlage",
"49271", "Siegen",
"4933982", "Hoppenrade\ Kreis\ Prignitz",
"4933744", "Hohenseefeld",
"494434", "Colnrade",
"4933745", "Petkus",
"492597", "Senden\ Westfalen",
"493761", "Werdau\ Sachsen",
"4934262", "Falkenhain\ bei\ Wurzen",
"498427", "Wellheim",
"494673", "Joldelund",
"494487", "Grossenkneten\-Huntlosen",
"4939773", "Altwarp",
"498265", "Pfaffenhausen\ Schwaben",
"4936761", "Heubisch",
"496181", "Hanau",
"499841", "Bad\ Windsheim",
"496358", "Kriegsfeld",
"496564", "Neuerburg\ Eifel",
"4937204", "Lichtenstein\ Sachsen",
"492935", "Sundern\-Hachen",
"494668", "Klanxbüll",
"497022", "Nürtingen",
"49371", "Chemnitz\ Sachsen",
"492770", "Eschenburg",
"4935056", "Altenberg\ Sachsen",
"4937326", "Frauenstein\ Sachsen",
"4938323", "Prohn",
"499657", "Waldthurn",
"498365", "Wertach",
"492761", "Olpe\ Biggesee",
"499673", "Tiefenbach\ Oberpfalz",
"493544", "Luckau\ Brandenburg",
"496267", "Fahrenbach\ Baden",
"496258", "Gernsheim",
"49541", "Osnabrück",
"495563", "Kreiensen",
"493394", "Wittstock\ Dosse",
"492662", "Hachenburg",
"496630", "Schwalmtal\-Storndorf",
"496456", "Haina\ Kloster",
"494841", "Husum\ Nordsee",
"4937465", "Tannenbergsthal\ Vogtland",
"496741", "St\ Goar",
"492294", "Morsbach\ Sieg",
"492247", "Neunkirchen\-Seelscheid",
"4933054", "Liebenwalde",
"492324", "Hattingen\ Ruhr",
"4937464", "Schöneck\ Vogtland",
"493935", "Tangerhütte",
"4933055", "Kremmen",
"4934322", "Rosswein",
"492952", "Rüthen",
"496642", "Schlitz",
"499434", "Bodenwöhr",
"497423", "Oberndorf\ am\ Neckar",
"492527", "Lippetal\-Lippborg",
"496425", "Rauschenberg\ Hessen",
"498444", "Schweitenkirchen",
"4938393", "Binz\ Ostseebad",
"492606", "Winningen\ Mosel",
"495807", "Altenmedingen",
"496678", "Wildeck\-Hönebach",
"499122", "Schwabach",
"4939002", "Oebisfelde",
"499631", "Tirschenreuth",
"494192", "Bad\ Bramstedt",
"4939932", "Malchow\ bei\ Waren",
"4937342", "Cranzahl",
"498641", "Grassau\ Kreis\ Traunstein",
"496855", "Freisen",
"493860", "Raben\ Steinfeld",
"494353", "Ascheffel",
"499732", "Hammelburg",
"499505", "Litzendorf",
"497665", "March\ Breisgau",
"495586", "Wieda",
"493871", "Parchim",
"496663", "Steinau\ an\ der\ Strasse",
"4937439", "Jocketa",
"492738", "Netphen",
"499277", "Warmensteinach",
"498742", "Velden\ Vils",
"4936736", "Arnsgereuth",
"4939927", "Nossentiner\ Hütte",
"499253", "Weissenstadt",
"494180", "Königsmoor",
"494136", "Scharnebeck",
"4934953", "Gräfenhainichen",
"497853", "Kehl\-Bodersweier",
"497955", "Wallhausen\ Württemberg",
"498064", "Au\ bei\ Bad\ Aibling",
"495222", "Bad\ Salzuflen",
"4934346", "Narsdorf",
"4939997", "Jarmen",
"492056", "Heiligenhaus",
"494755", "Ihlienworth",
"4933673", "Weichensdorf",
"492643", "Altenahr",
"495336", "Semmenstedt",
"496826", "Bexbach",
"4934607", "Wettin",
"495177", "Edemissen\-Abbensen",
"499129", "Wendelstein",
"495542", "Witzenhausen",
"495153", "Salzhemmendorf",
"4936870", "Masserberg",
"4939297", "Eickendorf\ Kreis\ Schönebeck",
"495322", "Bad\ Harzburg",
"4935792", "Ossling",
"496832", "Beckingen\-Reimsbach",
"4935451", "Dahme\ Brandenburg",
"495292", "Lichtenau\-Atteln",
"495954", "Lorup",
"497939", "Schrozberg\-Spielbach",
"492871", "Bocholt",
"494740", "Loxstedt\-Dedesdorf",
"495041", "Springe\ Deister",
"495236", "Blomberg\-Grossenmarpe",
"494129", "Haseldorf",
"493606", "Heiligenstadt\ Heilbad",
"496154", "Ober\-Ramstadt",
"497940", "Künzelsau",
"499199", "Kunreuth",
"495438", "Bakum\-Lüsche",
"499726", "Euerbach",
"493643", "Weimar\ Thüringen",
"499574", "Marktzeuln",
"4939341", "Redekin",
"499192", "Gräfenberg",
"498868", "Schwabsoien",
"494631", "Glücksburg\ Ostsee",
"494796", "Teufelsmoor",
"4935600", "Döbern\ NL",
"494122", "Uetersen",
"4934671", "Bad\ Frankenhausen\ Kyffhäuser",
"4939348", "Klitsche",
"4936423", "Orlamünde",
"494253", "Asendorf\ Kreis\ Diepholz",
"499180", "Pyrbaum",
"497932", "Niederstetten\ Württemberg",
"498857", "Benediktbeuern",
"494277", "Schwaförden",
"4938729", "Marnitz",
"494505", "Stockelsdorf\-Curau",
"494732", "Stadland\-Rodenkirchen",
"498146", "Moorenweis",
"499377", "Freudenberg\-Boxtal",
"495329", "Schulenberg\ im\ Oberharz",
"4935722", "Lauta\ bei\ Hoyerswerda",
"495664", "Morschen",
"499353", "Karlstadt",
"498348", "Bidingen",
"4933764", "Mittenwalde\ Mark",
"498501", "Thyrnau",
"494238", "Neddenaverbergen",
"492332", "Gevelsberg",
"499338", "Röttingen\ Unterfranken",
"494480", "Ovelgönne\-Strückhausen",
"492546", "Coesfeld\-Lette",
"4934242", "Hohenpriessnitz",
"496371", "Landstuhl",
"495609", "Ahnatal",
"4933765", "Märkisch\ Buchholz",
"499422", "Bogen\ Niederbayern",
"498635", "Pleiskirchen",
"492226", "Rheinbach",
"492428", "Niederzier",
"494492", "Saterland",
"495052", "Hermannsburg",
"499645", "Eschenbach\ in\ der\ Oberpfalz",
"496566", "Körperich",
"497034", "Ehningen",
"492582", "Everswinkel",
"494499", "Barssel",
"495453", "Recke",
"499429", "Rain\ Niederbayern",
"4939050", "Bartensleben",
"497672", "St\ Blasien",
"495683", "Wabern\ Hessen",
"494971", "Esens",
"492255", "Euskirchen\-Flamersheim",
"495602", "Hessisch\ Lichtenau",
"492590", "Dülmen\-Buldern",
"497771", "Stockach",
"492339", "Sprockhövel\-Hasslinghausen",
"4936741", "Bad\ Blankenburg",
"498652", "Berchtesgaden",
"4933333", "Tantow",
"499093", "Polsingen",
"495138", "Sehnde",
"499499", "Painten",
"495035", "Gross\ Munzel",
"496684", "Hofbieber\-Schwarzbach",
"496454", "Lichtenfels\-Sachsenberg",
"498751", "Mainburg",
"493332", "Schwedt\/Oder",
"492520", "Wadersloh\-Diestedde",
"492355", "Schalksmühle",
"493546", "Lübben\ Spreewald",
"499971", "Cham",
"4939740", "Nechlin",
"498403", "Pförring",
"498248", "Lamerdingen",
"4934785", "Sandersleben",
"492401", "Baesweiler",
"499480", "Sünching",
"499436", "Nittenau",
"494338", "Alt\ Duvenstedt",
"492232", "Brühl\ Rheinland",
"499238", "Röslau",
"492777", "Breitscheid\ Hessen",
"497838", "Nordrach",
"496271", "Eberbach\ Baden",
"492753", "Erndtebrück",
"498446", "Pörnbach",
"496637", "Feldatal",
"499492", "Parsberg",
"495551", "Northeim",
"498083", "Isen",
"492296", "Reichshof\-Brüchermühle",
"4938855", "Lübtheen",
"4938356", "Behrenhoff",
"494422", "Sande\ Kreis\ Friesl",
"4935023", "Bad\ Gottleuba",
"4934635", "Bad\ Lauchstädt",
"4938854", "Redefin",
"498547", "Osterhofen\-Gergweis",
"494956", "Uplengen",
"492424", "Vettweiss",
"4939059", "Wegenstedt",
"498809", "Wessobrunn",
"4939771", "Ueckermünde",
"495261", "Lemgo",
"4935892", "Horka\ OL",
"497323", "Gerstetten",
"499334", "Giebelstadt",
"4933337", "Altkünkendorf",
"494823", "Wilster",
"496550", "Irrhausen",
"496325", "Lambrecht\ Pfalz",
"4933962", "Heiligengrabe",
"494234", "Dörverden",
"495835", "Wahrenholz",
"4939778", "Ferdinandshof\ bei\ Torgelow",
"496295", "Rosenberg\ Baden",
"498344", "Westendorf\ bei\ Kaufbeuren",
"494287", "Heeslingen\-Boitzen",
"4936781", "Grossbreitenbach",
"495933", "Lathen",
"496723", "Oestrich\-Winkel",
"499170", "Schwanstetten",
"494925", "Hinte",
"4935027", "Weesenstein",
"498465", "Kipfenberg",
"497725", "Königsfeld\ im\ Schwarzwald",
"4935822", "Hagenwerder",
"499161", "Neustadt\ an\ der\ Aisch",
"493447", "Altenburg\ Thüringen",
"4935032", "Langenhennersdorf",
"497441", "Freudenstadt",
"496133", "Oppenheim",
"49531", "Braunschweig",
"494666", "Ladelund",
"493494", "Wolfen",
"498179", "Eurasburg\ an\ der\ Loisach",
"497135", "Brackenheim",
"496356", "Carlsberg\ Pfalz",
"498802", "Huglfing",
"494161", "Buxtehude",
"495724", "Obernkirchen",
"4936335", "Grosswechsungen",
"4934776", "Rothenschirmbach",
"495852", "Bleckede",
"499925", "Bayerisch\ Eisenstein",
"492565", "Gronau\-Epe",
"496467", "Hatzfeld\ Eder",
"499287", "Selb",
"493881", "Grevesmühlen",
"4936334", "Wolkramshausen",
"497159", "Renningen",
"4938209", "Sanitz\ bei\ Rostock",
"4936026", "Struth\ bei\ Mühlhausen",
"49521", "Bielefeld",
"496458", "Rosenthal\ Hessen",
"499666", "Illschwang",
"497506", "Wangen\-Leupolz",
"4935202", "Klingenberg\ Sachsen",
"4938391", "Altenkirchen\ Rügen",
"496256", "Lampertheim\-Hüttenfeld",
"494537", "Sülfeld\ Holstein",
"492447", "Dahlem\ bei\ Kall",
"496545", "Blankenrath",
"4938321", "Martensdorf\ bei\ Stralsund",
"497543", "Kressbronn\ am\ Bodensee",
"497152", "Leonberg\ Württemberg",
"495361", "Wolfsburg",
"495187", "Delligsen",
"499956", "Eichendorf\-Aufhausen",
"497393", "Munderkingen",
"495859", "Thomasburg",
"49911", "Nuremberg",
"4938328", "Miltzow",
"499823", "Leutershausen",
"4939749", "Grambow\ bei\ Pasewalk",
"497223", "Bühl\ Baden",
"499234", "Neusorg",
"497834", "Wolfach",
"494334", "Bredenbek\ bei\ Rendsburg",
"494893", "Hohenaspe",
"498327", "Rettenberg",
"497300", "Roggenburg",
"4934745", "Winningen\ Sachsen\-Anhalt",
"496395", "Münchweiler\ an\ der\ Rodalb",
"492993", "Marsberg\-Canstein",
"492734", "Freudenberg\ Westfalen",
"495841", "Lüchow\ Wendland",
"496096", "Wiesen\ Unterfranken",
"49441", "Oldenburg",
"497620", "Schopfheim\-Gersbach",
"494563", "Scharbeutz\-Haffkrug",
"4937382", "Geringswalde",
"496032", "Bad\ Nauheim",
"4936646", "Tanna\ bei\ Schleiz",
"4939293", "Dreileben",
"496674", "Friedewald\ Hessen",
"498057", "Aschau\-Sachrang",
"4938755", "Eldena",
"498073", "Gars\ am\ Inn",
"497141", "Ludwigsburg\ Württemberg",
"4939223", "Theessen",
"496433", "Hadamar",
"4933601", "Podelzig",
"497435", "Albstadt\-Laufen",
"496039", "Karben",
"4938754", "Leussow\ bei\ Ludwigslust",
"4936427", "Dornburg\ Saale",
"493923", "Zerbst",
"4933608", "Jacobsdorf\ Mark",
"4937430", "Eichigt",
"496281", "Buchen\ Odenwald",
"4934386", "Dürrweitzschen\ bei\ Grimma",
"499461", "Roding",
"4939889", "Boitzenburg",
"498165", "Neufahrn\ bei\ Freising",
"4939923", "Priborn",
"495434", "Essen\ Oldenburg",
"4933926", "Herzberg\ Mark",
"496158", "Riedstadt",
"4935609", "Drachhausen",
"496055", "Freigericht",
"4936378", "Ostramondra",
"497459", "Nagold\-Hochdorf",
"497053", "Bad\ Teinach\-Zavelstein",
"497646", "Weisweil\ Breisgau",
"4936371", "Schlossvippach",
"4939363", "Angern",
"494461", "Jever",
"4933366", "Chorin",
"492825", "Uedem",
"496381", "Kusel",
"496167", "Modautal",
"4938720", "Grebbin",
"499563", "Rödental",
"496026", "Grossostheim",
"49941", "Regensburg",
"4934603", "Nauendorf\ Sachsen\-Anhalt",
"492923", "Lippetal\-Herzfeld",
"4936841", "Schleusingen",
"4939388", "Goldbeck\ Altm",
"4933677", "Glienicke\ bei\ Beeskow",
"492572", "Emsdetten",
"4935364", "Lebusa",
"4939993", "Hohenmocker",
"495673", "Immenhausen\ Hessen",
"497682", "Elzach",
"492856", "Hamminkeln\-Brünen",
"495657", "Meissner",
"4936848", "Wernshausen",
"4935365", "Falkenberg\ Elster",
"496531", "Bernkastel\-Kues",
"497452", "Nagold",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+49|\D)//g;
      my $self = bless({ country_code => '49', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ country_code => '49', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;