# automatically generated file, don't edit



# Copyright 2011 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::NZ;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20220305001843;

my $formatters = [
                {
                  'format' => '$1 $2',
                  'leading_digits' => '8[1-579]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3,8})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            50(?:
              [0367]|
              88
            )|
            [89]0
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{2,3})'
                },
                {
                  'format' => '$1-$2 $3',
                  'leading_digits' => '
            24|
            [346]|
            7[2-57-9]|
            9[2-9]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d)(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            2(?:
              10|
              74
            )|
            [59]|
            80
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{3,4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            1|
            2[028]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3,4})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            2(?:
              [169]|
              7[0-35-9]
            )|
            7|
            86
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{3,5})'
                }
              ];

my $validators = {
                'fixed_line' => '
          24099\\d{3}|
          (?:
            3[2-79]|
            [49][2-9]|
            6[235-9]|
            7[2-57-9]
          )\\d{6}
        ',
                'geographic' => '
          24099\\d{3}|
          (?:
            3[2-79]|
            [49][2-9]|
            6[235-9]|
            7[2-57-9]
          )\\d{6}
        ',
                'mobile' => '
          2[0-27-9]\\d{7,8}|
          21\\d{6}
        ',
                'pager' => '[28]6\\d{6,7}',
                'personal_number' => '70\\d{7}',
                'specialrate' => '(
          (?:
            11\\d{5}|
            50(?:
              0[08]|
              30|
              66|
              77|
              88
            )
          )\\d{3}|
          90\\d{6,8}
        )|(
          8(?:
            1[6-9]|
            22|
            3\\d|
            4[045]|
            5[459]|
            7[0-3579]|
            90
          )\\d{2,7}
        )',
                'toll_free' => '
          508\\d{6,7}|
          80\\d{6,8}
        ',
                'voip' => ''
              };
my %areanames = ();
$areanames{en} = {"6434277", "Ranfurly",
"649211", "Auckland",
"643338", "Christchurch",
"6435683", "Te\ Anau",
"6498016", "Hibiscus\ Coast",
"6432225", "Greymouth",
"647325", "Opotiki",
"6437446", "Franz\ Josef",
"649291", "Auckland",
"649299", "Auckland",
"643756", "Hokitika",
"647905", "Taupo",
"6439047", "Alexandra",
"647968", "Hamilton",
"6439767", "Alexandra",
"6435880", "Dunedin",
"646837", "Wairoa",
"6473843", "Taupo",
"6465611", "Napier",
"6439334", "Fox\ Glacier",
"6499552", "Dargaville",
"6479010", "Thames",
"6439340", "Mt\ Cook",
"644494", "Wellington",
"6462811", "New\ Plymouth",
"6432801", "Lumsden",
"6479090", "Taupo",
"6437454", "Ashburton",
"643463", "Palmerston",
"6435510", "Darfield",
"6436625", "Rangiora",
"6432727", "Fox\ Glacier",
"644571", "Wellington",
"6474653", "Putaruru\/Tokoroa",
"6437477", "Roxburgh",
"649930", "Auckland",
"6495532", "Warkworth",
"6436589", "Otautau",
"6472822", "Rotorua",
"646374", "Dannevirke",
"6466990", "Mokau",
"646306", "Featherston",
"6475622", "Tauranga",
"6434246", "Waitangi\ \(Chatham\ Is\.\)",
"6439886", "Haast",
"6498826", "Warkworth",
"6475826", "Hamilton",
"6432748", "Cromwell",
"6439052", "Mt\ Cook",
"6432641", "Franz\ Josef",
"6472626", "Rotorua",
"6462619", "Featherston",
"6432609", "Mt\ Cook",
"6469298", "Masterton",
"6439719", "Waimate",
"6472144", "Matamata",
"6469574", "Taihape",
"6468824", "Wanganui",
"6478090", "Thames",
"6469286", "Dannevirke",
"643217", "Invercargill",
"6468808", "Palmerston\ North",
"6469313", "Marton",
"647347", "Rotorua",
"6472130", "Tauranga",
"6433984", "Roxburgh",
"6439004", "Gore",
"6469014", "Dannevirke",
"6435990", "Hokitika",
"647868", "Thames",
"6465625", "Gisborne",
"6462103", "Levin",
"6439028", "Edendale",
"6436500", "Christchurch",
"6499878", "Warkworth",
"6492838", "Pukekohe",
"6478132", "Paeroa",
"649903", "Auckland",
"6499016", "Kaikohe",
"6463926", "Taihape",
"6473999", "Taupo",
"6436611", "Rangiora",
"6432993", "Balclutha",
"6439289", "Akaroa",
"6439742", "Christchurch",
"6479847", "Te\ Awamutu",
"6493937", "Warkworth",
"6435888", "Timaru",
"643409", "Queenstown",
"6493943", "Helensville",
"6439735", "Lumsden",
"649840", "Auckland",
"6468889", "Levin",
"6498853", "Whangarei",
"6492807", "Helensville",
"6436565", "Twizel",
"6479294", "Hamilton",
"6436654", "Tokanui",
"6472221", "Tauranga",
"6462606", "Waiouru",
"643967", "Christchurch",
"6432616", "Ashburton",
"6469716", "Opunake",
"6439706", "Nelson",
"6496008", "Hibiscus\ Coast",
"646656", "Levin",
"6434225", "Edendale",
"6499041", "Helensville",
"6435518", "Milton",
"644619", "Wellington",
"6432442", "Christchurch",
"6499009", "Auckland",
"6466998", "New\ Plymouth",
"6436646", "Roxburgh",
"6499421", "Hibiscus\ Coast",
"6495563", "Whangarei",
"6473935", "Rotorua",
"6493209", "Great\ Barrier\ Island",
"6472805", "Morrinsville",
"649869", "Auckland",
"643762", "Greymouth",
"6462416", "Waipukurau",
"6475605", "Huntly",
"643457", "Dunedin",
"6479018", "Putaruru\/Tokoroa",
"6472123", "Morrinsville",
"644550", "Wellington",
"6477779", "Putaruru\/Tokoroa",
"6472429", "Whakatane",
"6434264", "Kurow",
"646847", "Napier\/Hastings",
"643482", "Dunedin",
"649638", "Auckland",
"6468800", "Napier\/Hastings",
"6439327", "Ashburton",
"649969", "Auckland",
"647218", "Tauranga",
"6434993", "Alexandra",
"647220", "Tauranga",
"6467555", "New\ Plymouth",
"6432740", "Lawrence",
"6442129", "Paraparaumu",
"643755", "Hokitika",
"6432734", "Waimate",
"649407", "Kaikohe",
"647906", "Taupo",
"6478086", "Hamilton",
"6439757", "Waitangi\ \(Chatham\ Is\.\)",
"6494314", "Warkworth",
"6479852", "Whangamata",
"6469290", "Napier\/Hastings",
"647974", "Hamilton",
"6499870", "Whangarei",
"6492830", "Auckland",
"6432812", "Haast",
"6462802", "Palmerston\ North",
"6468999", "Napier",
"6434291", "Westport",
"649451", "Auckland",
"649940", "Auckland",
"6435692", "Takaka",
"6465602", "Palmerston\ North",
"649459", "Whangarei",
"644590", "Wellington",
"6437464", "Timaru",
"6435998", "Rangiora",
"6436524", "Hokitika",
"6462127", "Dannevirke",
"646368", "Levin",
"644528", "Wellington",
"6439020", "Gore",
"643417", "Milton",
"6436508", "Rangiora",
"646838", "Wairoa",
"6472616", "Taumarunui",
"6439729", "Fox\ Glacier",
"6462629", "Levin",
"6435562", "Invercargill",
"6432653", "Wanaka",
"649883", "Auckland",
"644666", "Wellington",
"6499454", "Whangarei",
"6498816", "Great\ Barrier\ Island",
"6468247", "Mokau",
"6443331", "Wellington",
"64930", "Auckland",
"6439294", "Dunedin",
"6445954", "Wellington",
"6499477", "Pukekohe",
"6432221", "Nelson",
"643684", "Timaru",
"643434", "Oamaru",
"6435673", "Lawrence",
"643337", "Christchurch",
"6468814", "Dannevirke",
"6479109", "Opotiki",
"6435650", "Greymouth",
"6434287", "Queenstown",
"6466009", "Waiouru",
"64992", "Auckland",
"644922", "Wellington",
"649816", "Auckland",
"649956", "Auckland",
"6465615", "Wanganui",
"6462159", "Mokau",
"6439876", "Roxburgh",
"6469008", "Palmerston\ North",
"6439018", "Ranfurly",
"643524", "Takaka",
"6439098", "Akaroa",
"6437779", "Invercargill",
"6432429", "Timaru",
"6466520", "Palmerston\ North",
"6433942", "Akaroa",
"6436579", "Wanaka",
"6462815", "Wairoa",
"6437487", "Winton",
"6432805", "Winton",
"64331", "Rangiora\/Amberley\/Culverden\/Darfield\/Cheviot\/Kaikoura",
"6499063", "Hibiscus\ Coast",
"6496999", "Auckland",
"6436621", "Culverden",
"6434239", "Christchurch",
"6473929", "Thames",
"6463996", "Palmerston\ North",
"6463916", "Mokau",
"644900", "Wellington",
"647348", "Rotorua",
"6439852", "Cheviot",
"6435668", "Kurow",
"643218", "Invercargill",
"6469276", "Wanganui",
"6432645", "Greymouth",
"649212", "Auckland",
"6468252", "Dannevirke",
"6439526", "Twizel",
"649292", "Auckland",
"6477880", "Hamilton",
"6444889", "Paraparaumu",
"6432632", "Lumsden",
"6479020", "Te\ Awamutu",
"649585", "Auckland",
"647885", "Putaruru\/Tokoroa",
"649916", "Auckland",
"6478141", "Taupo",
"6472457", "Rotorua",
"64335", "Christchurch",
"6465621", "New\ Plymouth",
"649983", "Whangarei",
"6469247", "Wanganui",
"6475612", "Te\ Kuiti",
"643660", "Christchurch",
"647867", "Thames",
"6433957", "Palmerston",
"6496519", "Maungaturoto",
"6436615", "Ashburton",
"64957", "Auckland",
"644572", "Wellington",
"6432717", "Kaikoura",
"6472812", "Tauranga",
"649962", "Auckland",
"6469307", "Stratford",
"6439317", "Gore",
"6473338", "Rotorua",
"646278", "Hawera",
"643968", "Christchurch",
"6439862", "Nelson",
"6498880", "Helensville",
"643481", "Dunedin",
"643489", "Dunedin",
"6469851", "Napier",
"6436687", "Nelson",
"6474442", "Morrinsville",
"6436561", "Oamaru",
"649349", "Auckland",
"6472225", "Rotorua",
"6468262", "Napier",
"6439731", "Gore",
"6492007", "Warkworth",
"6435952", "Christchurch",
"6435547", "Blenheim",
"6442199", "Paraparaumu",
"6466552", "New\ Plymouth",
"6435533", "Murchison",
"6439279", "Christchurch",
"6436639", "Oamaru",
"649452", "Auckland",
"647886", "Putaruru\/Tokoroa",
"647893", "Taumarunui",
"6434221", "Invercargill",
"6494702", "Whangarei",
"649915", "Auckland",
"6478996", "Huntly",
"6499045", "Hibiscus\ Coast",
"6499425", "Auckland",
"647463", "Whakatane",
"6473931", "Whangamata",
"6469000", "New\ Plymouth",
"6439010", "Queenstown",
"6492227", "Whangarei",
"6466528", "Dannevirke",
"6472801", "Huntly",
"6439090", "Rangiora",
"643234", "Riverton",
"6436594", "Waimate",
"6475601", "Hamilton",
"6478076", "Te\ Awamutu",
"6435552", "Queenstown",
"6432663", "Christchurch",
"649408", "Kaitaia",
"6462222", "Ohakune",
"6499464", "Whangarei",
"6499299", "Whangarei",
"6439459", "Tokanui",
"6477888", "Taupo",
"646954", "Palmerston\ North\ W100",
"647217", "Taupo",
"643444", "Ranfurly",
"644437", "Wellington",
"643740", "Christchurch",
"6432626", "Kurow",
"6472609", "Whangamata",
"6439532", "Timaru",
"6479719", "Te\ Kuiti",
"6467551", "New\ Plymouth",
"647986", "Hamilton",
"6435660", "Haast",
"6496014", "Dargaville",
"649815", "Auckland",
"6497774", "Warkworth",
"6435504", "Christchurch",
"6462169", "Featherston",
"643420", "Christchurch",
"643418", "Balclutha",
"644527", "Wellington",
"646367", "Levin",
"6435528", "Ranfurly",
"6436994", "Murchison",
"6433919", "Haast",
"6433999", "Otautau",
"6495588", "Hibiscus\ Coast",
"6434295", "Fox\ Glacier",
"6463941", "Masterton",
"6467776", "Levin",
"647853", "Hamilton",
"6462426", "Levin",
"6472193", "Whakatane",
"643769", "Greymouth",
"6479004", "Te\ Awamutu",
"646385", "Ohakune",
"6439730", "Invercargill",
"6462163", "New\ Plymouth",
"6436560", "Palmerston",
"643448", "Alexandra",
"6432228", "Wanaka",
"649476", "Auckland",
"6463903", "Ruatoria",
"6433913", "Murchison",
"6433993", "Te\ Anau",
"6432753", "Winton",
"6439744", "Queenstown",
"649404", "Kawakawa",
"6498881", "Hibiscus\ Coast",
"6472119", "Thames",
"6462126", "Pahiatua",
"646844", "Napier\/Hastings",
"6472199", "Opotiki",
"644555", "Wellington",
"6469850", "Napier",
"6479292", "Hamilton",
"6436652", "Winton",
"6439268", "Dunedin",
"643571", "Nelson",
"6472800", "Thames",
"6439091", "Rangiora",
"6469001", "New\ Plymouth",
"6439011", "Queenstown",
"644463", "Wellington",
"6432669", "Rangiora",
"6439326", "Rangiora",
"6475600", "Hamilton",
"643980", "Christchurch",
"6432444", "Nelson",
"6439453", "Te\ Anau",
"644886", "Wellington",
"644893", "Wellington",
"6434220", "Invercargill",
"6473944", "Tauranga",
"6439756", "Akaroa",
"644209", "Wellington",
"6472603", "Hamilton",
"6479713", "Morrinsville",
"6436628", "Ashburton",
"649845", "Auckland",
"6473930", "Waihi",
"6436633", "Geraldine",
"6467550", "New\ Plymouth",
"643921", "Blenheim",
"644913", "Wellington",
"6432745", "Roxburgh",
"6436647", "Te\ Anau",
"643964", "Christchurch",
"646274", "Hawera",
"6435661", "Fairlie",
"6469295", "Wanganui",
"6434262", "Alexandra",
"647843", "Hamilton",
"6494312", "Warkworth",
"6479854", "Rotorua",
"6462417", "Wanganui",
"644297", "Paraparaumu",
"647334", "Rotorua",
"6432732", "Fairlie",
"6442609", "Paraparaumu",
"6468805", "Wanganui",
"649399", "Auckland",
"6465604", "Ohakune",
"6435694", "Franz\ Josef",
"6493936", "Maungaturoto",
"649391", "Auckland",
"6432814", "Mt\ Cook",
"6462804", "Palmerston\ North",
"6439025", "Otautau",
"649827", "Auckland",
"643454", "Dunedin",
"6479846", "Taumarunui",
"646751", "New\ Plymouth",
"643750", "Haast",
"6492835", "Kaikohe",
"6499875", "Dargaville",
"647877", "Te\ Kuiti",
"646759", "New\ Plymouth",
"649232", "Pukekohe",
"64423", "Wellington",
"6462607", "Taihape",
"6432617", "Cheviot",
"646322", "Marton",
"6439707", "Takaka",
"6436522", "Greymouth",
"6463940", "Levin",
"646858", "Waipukurau",
"6474648", "Huntly",
"6435539", "Otautau",
"6437462", "Geraldine",
"6439273", "Blenheim",
"643214", "Invercargill",
"6473331", "Rotorua",
"64497", "Wellington",
"647833", "Hamilton",
"6435885", "Invercargill",
"643978", "Christchurch",
"6439738", "Winton",
"647922", "Whakatane",
"6436568", "Roxburgh",
"6463927", "Dannevirke",
"6496513", "Whangarei",
"6432220", "Dunedin",
"6443330", "Wellington",
"6499017", "Kaikohe",
"6434228", "Tokanui",
"6435515", "Oamaru",
"6436620", "Kaikoura",
"6472627", "Rotorua",
"6439332", "Hokitika",
"6499554", "Kaitaia",
"6466995", "Opunake",
"643248", "Lumsden",
"6475827", "Hamilton",
"6472808", "Putaruru\/Tokoroa",
"6466521", "Palmerston\ North",
"6475624", "Rotorua",
"6496883", "Auckland",
"6439345", "Christchurch",
"6475608", "Otorohanga",
"6469287", "Ohakune",
"649423", "Warkworth",
"6437452", "Akaroa",
"6462153", "New\ Plymouth",
"6478095", "Taupo",
"6437773", "Dunedin",
"6432423", "Dunedin",
"6477881", "Hamilton",
"649475", "Auckland",
"646834", "Napier\/Hastings",
"64334", "Christchurch",
"6465950", "Palmerston\ North",
"6499069", "Pukekohe",
"646343", "Wanganui",
"6496993", "Whangarei",
"6479249", "Huntly",
"6467558", "New\ Plymouth",
"6434247", "Kaikoura",
"6434233", "Rangiora",
"64948", "Auckland",
"643688", "Timaru",
"6432726", "Franz\ Josef",
"6437476", "Ranfurly",
"6473923", "Otorohanga",
"643438", "Kurow",
"6472142", "Te\ Awamutu",
"6469572", "Palmerston\ North",
"6468822", "Masterton",
"6437447", "Greymouth",
"6498017", "Hibiscus\ Coast",
"6439723", "Blenheim",
"6462623", "Stratford",
"6432659", "Takaka",
"6434276", "Palmerston",
"6439002", "Rangiora",
"6469012", "Waiouru",
"646377", "Masterton",
"643528", "Motueka",
"6433982", "Kurow",
"6439766", "Balclutha",
"6478140", "Rotorua",
"646650", "Napier",
"6479021", "Te\ Awamutu",
"643651", "Nelson",
"6435995", "Darfield",
"6439046", "Kurow",
"6435679", "Alexandra",
"6465620", "New\ Plymouth",
"643590", "Christchurch",
"649846", "Auckland",
"647546", "Tauranga",
"6466003", "Ruatoria",
"6478134", "Taumarunui",
"644497", "Wellington",
"6436505", "Culverden",
"6472220", "Tauranga",
"6439864", "Takaka",
"643922", "Nelson",
"6468993", "Taihape",
"649634", "Auckland",
"6466554", "Hawera",
"6435954", "Christchurch",
"643447", "Alexandra",
"6478597", "Hamilton",
"6468264", "Palmerston\ North",
"6467777", "Napier",
"643666", "Christchurch",
"6474444", "Hamilton",
"643302", "Ashburton\/Akaroa\/Chatham\ Islands",
"6469005", "Wanganui",
"6439015", "Wanaka",
"6465618", "Masterton",
"643226", "Otautau",
"6443709", "Paraparaumu",
"6462818", "New\ Plymouth",
"6432808", "Westport",
"6494704", "Whangarei",
"649392", "Auckland",
"644806", "Wellington",
"6478077", "Waihi",
"644524", "Wellington",
"6434999", "Dunedin",
"646364", "Levin",
"6442429", "Paraparaumu",
"6499040", "Helensville",
"644281", "Wellington",
"6436592", "Nelson",
"6499420", "Pukekohe",
"646329", "Palmerston\ North",
"646752", "New\ Plymouth",
"649239", "Pukekohe",
"646321", "Marton",
"6432627", "Alexandra",
"6496507", "Helensville",
"6432741", "Milton",
"6499003", "Warkworth",
"6499462", "Whangarei",
"643425", "Dunedin",
"6478997", "Morrinsville",
"6462224", "Masterton",
"649950", "Auckland",
"644298", "Paraparaumu",
"6435665", "Waimate",
"6435554", "Cromwell",
"6469291", "Gisborne",
"6495569", "Maungaturoto",
"6432648", "Geraldine",
"6496012", "Kawakawa",
"644906", "Paraparaumu",
"6492226", "Helensville",
"6439534", "Mt\ Cook",
"6472129", "Whangamata",
"646765", "Stratford",
"646213", "Wanganui",
"6477773", "Taupo",
"6468801", "Wanganui",
"6439283", "Rangiora",
"647590", "Hamilton",
"649890", "Auckland",
"6436686", "Invercargill",
"646857", "Waipukurau",
"643736", "Greymouth",
"6436992", "Greymouth",
"647878", "Te\ Kuiti",
"6497772", "Kaitaia",
"6469306", "Hawera",
"6435502", "Christchurch",
"6439316", "Edendale",
"6468883", "Palmerston\ North",
"6435546", "Greymouth",
"6498859", "Kaitaia",
"649810", "Auckland",
"6479002", "Matamata",
"649828", "Auckland",
"6499871", "Whangarei",
"6492831", "Maungaturoto",
"6492006", "Helensville",
"644202", "Wellington",
"6434290", "Greymouth",
"6436618", "Blenheim",
"6445952", "Wellington",
"6439292", "Timaru",
"6469202", "Levin",
"6499452", "Warkworth",
"6435881", "Dunedin",
"6462109", "Waiouru",
"649439", "Dargaville",
"6469616", "Featherston",
"643977", "Christchurch",
"6432716", "Darfield",
"644905", "Paraparaumu",
"6473993", "Te\ Awamutu",
"6468812", "Waiouru",
"6433956", "Dunedin",
"649431", "Maungaturoto",
"6432999", "Invercargill",
"646766", "New\ Plymouth",
"6469246", "Palmerston\ North",
"6469277", "Gisborne",
"6469022", "Hawera",
"647829", "Hamilton",
"6499048", "Pukekohe",
"6435511", "Kaikoura",
"6433944", "Ashburton",
"6499428", "Warkworth",
"6462613", "Waipukurau",
"6439713", "Mt\ Cook",
"647864", "Thames",
"6466991", "Wanganui",
"6465610", "Napier",
"643943", "Christchurch",
"647980", "Hamilton",
"6439527", "Kurow",
"6466525", "Marton",
"6469319", "Masterton",
"6462810", "Gisborne",
"6432800", "Te\ Anau",
"6479091", "Taupo",
"6439341", "Fairlie",
"6478091", "Matamata",
"643437", "Oamaru",
"6437486", "Tokanui",
"643687", "Timaru",
"6439854", "Waitangi\ \(Chatham\ Is\.\)",
"647880", "Matamata",
"649580", "Auckland",
"647309", "Whakatane",
"6472131", "Rotorua",
"6477885", "Tauranga",
"643334", "Christchurch",
"6463917", "Wanganui",
"6432634", "Invercargill",
"6474659", "Whangamata",
"6436583", "Te\ Anau",
"6463997", "Palmerston\ North",
"6468254", "Ohakune",
"647921", "Rotorua",
"6432640", "Hokitika",
"644498", "Wellington",
"6499476", "Auckland",
"6432889", "Blenheim",
"643225", "Otautau",
"6498817", "Hibiscus\ Coast",
"6468246", "Hawera",
"649249", "Auckland",
"6435689", "Otautau",
"646863", "Gisborne",
"6469892", "Gisborne",
"6434298", "Hokitika",
"6436610", "Kaikoura",
"643692", "Geraldine",
"644805", "Wellington",
"6472814", "Putaruru\/Tokoroa",
"6479025", "Huntly",
"643527", "Motueka",
"6435991", "Franz\ Josef",
"646378", "Masterton",
"6434286", "Christchurch",
"643612", "Timaru",
"6475614", "Thames",
"6436501", "Akaroa",
"647357", "Rotorua",
"6436549", "Mt\ Cook",
"646373", "Masterton",
"6435514", "Palmerston",
"64337", "Christchurch",
"643421", "Christchurch",
"6434236", "Amberley",
"6437450", "Westport",
"643464", "Dunedin",
"6473926", "Taumarunui",
"6463999", "Palmerston\ North",
"6432723", "Takaka",
"6474657", "Thames",
"6437473", "Milton",
"6433941", "Blenheim",
"6466994", "Ohakune",
"6499555", "Kawakawa",
"6439330", "Westport",
"644493", "Wellington",
"646769", "New\ Plymouth",
"6462156", "Hawera",
"6437776", "Cromwell",
"6432426", "Blenheim",
"6475625", "Rotorua",
"646761", "Opunake",
"6473847", "Taupo",
"6436576", "Cromwell",
"646868", "Gisborne",
"6436622", "Cheviot",
"6498900", "Pukekohe",
"6496996", "Warkworth",
"6479014", "Matamata",
"6439344", "Timaru",
"646347", "Wanganui",
"6436547", "Geraldine",
"6439763", "Palmerston",
"6432222", "Christchurch",
"6443332", "Wellington",
"6435884", "Dunedin",
"6435561", "Dunedin",
"6466006", "Opunake",
"6462144", "Ruatoria",
"6449740", "Paraparaumu",
"647826", "Huntly",
"6499718", "Whangarei",
"643749", "Christchurch",
"6479709", "Matamata",
"6479298", "Taupo",
"6436658", "Fox\ Glacier",
"6435687", "Lumsden",
"6439726", "Timaru",
"6462626", "Mokau",
"643741", "Christchurch",
"643539", "Nelson",
"6434273", "Lawrence",
"647542", "Tauranga",
"6432887", "Nelson",
"647306", "Whakatane",
"6499819", "Helensville",
"6465622", "Stratford",
"643948", "Invercargill",
"6432997", "Edendale",
"647374", "Taupo",
"6496516", "Kaikohe",
"6478142", "Whakatane",
"6435994", "Ashburton",
"6436528", "Westport",
"6472811", "Tauranga",
"6469010", "Taihape",
"6437468", "Wanaka",
"6439000", "Christchurch",
"6462107", "Dannevirke",
"647926", "Tauranga",
"649427", "Hibiscus\ Coast",
"6475483", "Tauranga",
"6433980", "Milton",
"6436504", "Cheviot",
"6475611", "Taumarunui",
"6478135", "Te\ Kuiti",
"6498691", "Maungaturoto",
"646968", "New\ Plymouth\ W100",
"6478094", "Tauranga",
"647837", "Hamilton",
"6434268", "Roxburgh",
"6469570", "Palmerston\ North",
"6472140", "Putaruru\/Tokoroa",
"6469317", "Pahiatua",
"6468820", "Palmerston\ North",
"6439529", "Palmerston",
"644587", "Wellington",
"6439851", "Culverden",
"6439055", "Fairlie",
"646325", "Palmerston\ North",
"6432631", "Gore",
"6499100", "Pukekohe",
"649235", "Pukekohe",
"6468251", "Wanganui",
"6469279", "Levin",
"6432738", "Oamaru",
"647305", "Whakatane",
"6439338", "Queenstown",
"6472127", "Paeroa",
"6473932", "Rotorua",
"6434222", "Gore",
"6494701", "Whangarei",
"6432445", "Greymouth",
"64635", "Palmerston\ North",
"6475602", "Hamilton",
"6436636", "Waimate",
"6495567", "Kaitaia",
"6437458", "Kaikoura",
"647925", "Tauranga",
"643669", "Christchurch",
"6478999", "Hamilton",
"6473945", "Tauranga",
"6472802", "Paeroa",
"647873", "Otorohanga",
"6496509", "Pukekohe",
"644801", "Wellington",
"6469852", "Napier",
"6436650", "Otautau",
"6479290", "Hamilton",
"646974", "Napier",
"6439745", "Greymouth",
"6498857", "Dargaville",
"6439861", "Nelson",
"643221", "Invercargill",
"644917", "Wellington",
"6439276", "Nelson",
"644213", "Wellington",
"646326", "Palmerston\ North",
"6462138", "Palmerston\ North",
"649236", "Pukekohe",
"6466551", "New\ Plymouth",
"6434353", "Twizel",
"6493933", "Kaikohe",
"6439732", "Otautau",
"6468261", "Masterton",
"6435951", "Christchurch",
"644293", "Paraparaumu",
"6436562", "Balclutha",
"6474441", "Waihi",
"6479843", "Morrinsville",
"647847", "Hamilton",
"644897", "Wellington",
"6467779", "Masterton",
"6463942", "Masterton",
"6436520", "Greymouth",
"6435695", "Fox\ Glacier",
"6478599", "Hamilton",
"6433988", "Wanaka",
"6465605", "Marton",
"6462123", "Palmerston\ North",
"6439008", "Timaru",
"6437460", "Waitangi\ \(Chatham\ Is\.\)",
"644467", "Wellington",
"6466579", "Featherston",
"6462805", "Napier\/Hastings",
"6432815", "Fairlie",
"64447", "Wellington",
"6439024", "Lumsden",
"6462166", "Opunake",
"6492834", "Kawakawa",
"6499874", "Kawakawa",
"644817", "Wellington",
"6463906", "Napier",
"643393", "Christchurch",
"6433916", "Hokitika",
"644901", "Wellington",
"644909", "Wellington",
"6433996", "Edendale",
"6432756", "Gore",
"6432744", "Ranfurly",
"64483", "Wellington",
"6432629", "Roxburgh",
"6439753", "Amberley",
"6472606", "Huntly",
"6479716", "Waihi",
"6469294", "Palmerston\ North",
"6435551", "Franz\ Josef",
"643731", "Greymouth",
"6462221", "Gisborne",
"6432730", "Blenheim",
"6434997", "Lawrence",
"647825", "Hamilton",
"6478079", "Hamilton",
"6469578", "Marton",
"6472148", "Waihi",
"6439323", "Cheviot",
"6479855", "Taupo",
"6434260", "Oamaru",
"6439531", "Timaru",
"6499296", "Kaitaia",
"6467552", "New\ Plymouth",
"6439456", "Riverton",
"6468804", "Napier",
"64687", "Napier\/Hastings",
"6432802", "Gore",
"6462812", "Napier\/Hastings",
"6442820", "Wellington",
"6436586", "Edendale",
"646867", "Gisborne",
"644650", "Wellington",
"6465612", "Waipukurau",
"649949", "Auckland",
"6499551", "Whangarei",
"6434249", "Kaikoura",
"643925", "Christchurch",
"649941", "Auckland",
"6479247", "Hamilton",
"6433945", "Cheviot",
"6499733", "Warkworth",
"6499067", "Pukekohe",
"6466524", "Ohakune",
"6475621", "Tauranga",
"6439079", "Murchison",
"6437483", "Otautau",
"6499747", "Dargaville",
"6466508", "Napier\/Wairoa",
"643305", "Ashburton\/Akaroa\/Chatham\ Islands",
"6436518", "Murchison",
"6495531", "Helensville",
"6472821", "Hamilton",
"643523", "Murchison",
"6493990", "Great\ Barrier\ Island",
"6469020", "Stratford",
"6436598", "Wanaka",
"6434283", "Cromwell",
"643696", "Geraldine",
"6435677", "Ranfurly",
"643683", "Timaru",
"643433", "Oamaru",
"6468810", "Ohakune",
"649884", "Auckland",
"6499473", "Helensville",
"6468243", "Napier",
"6432657", "Motueka",
"644834", "Paraparaumu",
"6498019", "Pukekohe",
"6439290", "Christchurch",
"6445950", "Wellington",
"6469200", "Gisborne",
"6437449", "Hokitika",
"6499450", "Warkworth",
"646348", "Wanganui",
"6468693", "Gisborne",
"647386", "Taupo",
"6499019", "Maungaturoto",
"6469613", "Levin",
"644934", "Wellington",
"6432713", "Ashburton",
"6433953", "Geraldine",
"6497778", "Pukekohe",
"6492428", "Hibiscus\ Coast",
"6435508", "Cheviot",
"6473996", "Otorohanga",
"649984", "Auckland",
"649428", "Hibiscus\ Coast",
"6469243", "New\ Plymouth",
"6436998", "Blenheim",
"6469890", "Gisborne",
"6436612", "Akaroa",
"6472815", "Whakatane",
"644551", "Paraparaumu",
"646762", "Stratford",
"6475615", "Waihi",
"643947", "Invercargill",
"6479008", "Rotorua",
"6478131", "Otorohanga",
"6469289", "Taihape",
"6432642", "Fox\ Glacier",
"6499728", "Dargaville",
"6477884", "Tauranga",
"6499468", "Kawakawa",
"6439855", "Rangiora",
"649849", "Auckland",
"647549", "Tauranga",
"6475829", "Hamilton",
"647541", "Tauranga",
"6432635", "Riverton",
"6496018", "Auckland",
"6472629", "Taupo",
"6479753", "Taupo",
"644205", "Wellington",
"647838", "Hamilton",
"6468255", "Pahiatua",
"6462616", "Ruatoria",
"646967", "New\ Plymouth",
"6432606", "Dunedin",
"643742", "Dunedin",
"6439716", "Geraldine",
"649479", "Auckland",
"6499422", "Helensville",
"6493206", "Pukekohe",
"6469004", "Napier\/Hastings",
"6462419", "Masterton",
"6492223", "Auckland",
"6477776", "Whangamata",
"6494705", "Whangarei",
"6436590", "Nelson",
"6499042", "Hibiscus\ Coast",
"6432441", "Christchurch",
"647464", "Hamilton",
"644902", "Paraparaumu",
"6499006", "Whangarei",
"6436649", "Gore",
"647894", "Taumarunui",
"6468886", "Wanganui",
"6435537", "Winton",
"647848", "Hamilton",
"643732", "Greymouth",
"646986", "Gisborne",
"6435543", "Tokanui",
"644889", "Wellington",
"6462609", "Pahiatua",
"6432619", "Christchurch",
"6439709", "Motueka",
"6439298", "Motueka",
"6439061", "Greymouth",
"6499458", "Kawakawa",
"6439741", "Christchurch",
"643576", "Nelson",
"6439865", "Murchison",
"6466555", "Hawera",
"6436683", "Rangiora",
"644918", "Wellington",
"6439286", "Cromwell",
"644920", "Wellington",
"6474445", "Hamilton",
"6472222", "Hamilton",
"643655", "Dunedin",
"6468818", "Opunake",
"6469303", "Waipukurau",
"6439313", "Te\ Anau",
"6435955", "Christchurch",
"6465601", "Palmerston\ North",
"6434292", "Hokitika",
"6468303", "Napier",
"6435691", "Murchison",
"644818", "Wellington",
"647854", "Hamilton",
"649554", "Hibiscus\ Coast",
"6462801", "Palmerston\ North",
"6432811", "Fox\ Glacier",
"6472197", "Tauranga",
"6479000", "Hamilton",
"643926", "Christchurch",
"6478129", "Matamata",
"644570", "Wellington",
"6497770", "Whangarei",
"6492420", "Auckland",
"6435500", "Christchurch",
"6449123", "Wellington",
"643306", "Ashburton\/Akaroa\/Chatham\ Islands",
"6468996", "Napier",
"6436990", "Cheviot",
"649210", "Auckland",
"644802", "Wellington",
"6496010", "Kaitaia",
"6435664", "Timaru",
"6435555", "Timaru",
"6462225", "Levin",
"6479851", "Waihi",
"646953", "Palmerston\ North\ W100",
"643443", "Wanaka",
"6449083", "Wellington",
"646756", "New\ Plymouth",
"6439535", "Fairlie",
"6499460", "Whangarei",
"643615", "Timaru",
"647858", "Hamilton",
"649558", "Auckland",
"6434996", "Roxburgh",
"643486", "Dunedin",
"643552", "Dunedin",
"6434224", "Te\ Anau",
"6473934", "Rotorua",
"6472607", "Paeroa",
"6479717", "Otorohanga",
"647322", "Whakatane",
"6499558", "Great\ Barrier\ Island",
"6478083", "Hamilton",
"6439457", "Winton",
"643413", "Balclutha",
"6472804", "Whangamata",
"6499297", "Hibiscus\ Coast",
"6475628", "Tauranga",
"644894", "Wellington",
"6436591", "Nelson",
"6466549", "Ruatoria",
"6432440", "Christchurch",
"6495538", "Auckland",
"6472828", "Tauranga",
"644464", "Wellington",
"6475604", "Hamilton",
"6475958", "Taupo",
"6468309", "Napier",
"649589", "Auckland",
"647889", "Morrinsville",
"646843", "Napier\/Hastings",
"6469854", "Waipukurau",
"649581", "Auckland",
"647881", "Matamata",
"6436564", "Milton",
"6436655", "Westport",
"6479295", "Whakatane",
"6433997", "Gore",
"6432757", "Lumsden",
"6463907", "Waipukurau",
"6433917", "Franz\ Josef",
"6439734", "Edendale",
"649403", "Kawakawa",
"6439740", "Christchurch",
"6439060", "Greymouth",
"6462167", "Mokau",
"647920", "Rotorua",
"6439277", "Invercargill",
"6497771", "Kaikohe",
"6435501", "Christchurch",
"6474638", "Opotiki",
"6435549", "Hokitika",
"6498856", "Maungaturoto",
"6442197", "Paraparaumu",
"6462603", "Palmerston\ North",
"6432613", "Waitangi\ \(Chatham\ Is\.\)",
"6469713", "Stratford",
"6439703", "Takaka",
"6492009", "Pukekohe",
"6436991", "Culverden",
"6463944", "Featherston",
"647989", "Taupo",
"6436689", "Christchurch",
"6435690", "Motueka",
"6436525", "Franz\ Josef",
"6465600", "Palmerston\ North",
"6437465", "Waimate",
"643453", "Dunedin",
"647981", "Hamilton",
"6479001", "Hamilton",
"6478138", "Waihi",
"6492832", "Dargaville",
"6499872", "Whangarei",
"6469309", "Mokau",
"6479049", "Te\ Kuiti",
"6439319", "Otautau",
"6462800", "Palmerston\ North",
"6432810", "Franz\ Josef",
"6479850", "Tokoroa",
"6434265", "Milton",
"6469292", "Ruatoria",
"6472126", "Otorohanga",
"6499461", "Whangarei",
"6462413", "Gisborne",
"6492229", "Hibiscus\ Coast",
"6432742", "Twizel",
"6462119", "Wairoa",
"6468802", "New\ Plymouth",
"643963", "Christchurch",
"6467554", "New\ Plymouth",
"646273", "Hawera",
"6494315", "Warkworth",
"6436643", "Balclutha",
"647958", "Hamilton",
"644914", "Wellington",
"6432735", "Mt\ Cook",
"6436637", "Twizel",
"6496011", "Kaikohe",
"6495566", "Kaikohe",
"6439335", "Haast",
"6444887", "Paraparaumu",
"649424", "Hibiscus\ Coast",
"649988", "Whangarei",
"6466992", "Hawera",
"6469283", "Opunake",
"6475620", "Tauranga",
"643982", "Christchurch",
"6493991", "Pukekohe",
"6432448", "Dunedin",
"644938", "Wellington",
"6469316", "Dannevirke",
"6435512", "Rangiora",
"6495530", "Great\ Barrier\ Island",
"6472820", "Hamilton",
"6439342", "Geraldine",
"649811", "Auckland",
"647377", "Taupo",
"6436624", "Darfield",
"6498823", "Kaitaia",
"6475823", "Hamilton",
"6473948", "Opotiki",
"6437455", "Cheviot",
"6442821", "Wellington",
"6472623", "Tauranga",
"6499013", "Kawakawa",
"6432719", "Waitangi\ \(Chatham\ Is\.\)",
"6496517", "Kaitaia",
"6433959", "Balclutha",
"6435882", "Dunedin",
"6463923", "Ohakune",
"6432996", "Riverton",
"6469201", "Ruatoria",
"649959", "Hibiscus\ Coast",
"6499451", "Warkworth",
"6439748", "Dunedin",
"6439068", "Fox\ Glacier",
"6469249", "Masterton",
"6432224", "Invercargill",
"649951", "Auckland",
"6445951", "Wellington",
"6439291", "Dunedin",
"647343", "Rotorua",
"647834", "Hamilton",
"6475950", "Hamilton",
"6472459", "Rotorua",
"643213", "Invercargill",
"6462106", "Pahiatua",
"6468811", "Marton",
"6435698", "Hokitika",
"6478144", "Tauranga",
"6439005", "Invercargill",
"643485", "Lawrence",
"6434289", "Wanaka",
"6466007", "Stratford",
"6465608", "Dannevirke",
"6433985", "Alexandra",
"6479107", "Whakatane",
"6469891", "Gisborne",
"6478130", "Morrinsville",
"6462808", "Napier\/Hastings",
"644393", "Paraparaumu",
"6432818", "Christchurch",
"6436546", "Fairlie",
"6465624", "Featherston",
"644280", "Wellington",
"6449008", "Paraparaumu",
"6499479", "Pukekohe",
"647551", "Tauranga",
"6467525", "Mokau",
"6436502", "Amberley",
"6468249", "Opunake",
"649230", "Pukekohe",
"6435686", "Gore",
"64347", "Dunedin",
"6439727", "Dunedin",
"6462627", "Wanganui",
"6437443", "Nelson",
"6435992", "Fox\ Glacier",
"643467", "Dunedin",
"643752", "Franz\ Josef",
"6473927", "Te\ Kuiti",
"6472132", "Taupo",
"6474656", "Te\ Awamutu",
"6434237", "Culverden",
"6434243", "Akaroa",
"6439883", "Hokitika",
"649919", "Auckland",
"6478092", "Huntly",
"646833", "Napier\/Hastings",
"6496997", "Hibiscus\ Coast",
"6439073", "Motueka",
"6479858", "Whakatane",
"6469575", "Waiouru",
"6472145", "Huntly",
"6468825", "Gisborne",
"6436577", "Cromwell",
"646344", "Wanganui",
"6437777", "Christchurch",
"6432427", "Greymouth",
"649888", "Auckland",
"643957", "Timaru",
"6439050", "Geraldine",
"6462157", "Stratford",
"6432623", "Lawrence",
"6439759", "Cromwell",
"6499044", "Hibiscus\ Coast",
"6442127", "Paraparaumu",
"6439012", "Queenstown",
"6469002", "Hawera",
"646363", "Levin",
"6433948", "Kaikoura",
"64336", "Christchurch",
"6439092", "Rangiora",
"6499424", "Auckland",
"646651", "Napier",
"6478073", "Tokoroa\/Putaruru",
"6494700", "Whangarei",
"6436595", "Mt\ Cook",
"647982", "Hamilton",
"646590", "Palmerston\ North",
"647857", "Hamilton",
"649557", "Auckland",
"6466013", "Featherston",
"6466550", "New\ Plymouth",
"6472116", "Thames",
"647213", "Hamilton",
"6467773", "Wanganui",
"6462423", "Gisborne",
"6478593", "Hamilton",
"6462129", "Waiouru",
"6472196", "Taupo",
"6474440", "Paeroa",
"6468260", "Featherston",
"6435950", "Christchurch",
"6479748", "Taumarunui",
"649633", "Auckland",
"6468997", "Napier",
"6472224", "Taupo",
"6436651", "Riverton",
"6479291", "Hamilton",
"6498882", "Whangarei",
"6439860", "Nelson",
"643690", "Waimate",
"6497775", "Helensville",
"6435505", "Akaroa",
"649966", "Auckland",
"6434294", "Franz\ Josef",
"6492809", "Maungaturoto",
"649215", "Auckland",
"6435536", "Invercargill",
"6468887", "Gisborne",
"6436995", "Westport",
"6437461", "Fairlie",
"6472818", "Rotorua",
"6434359", "Twizel",
"6493939", "Auckland",
"6436521", "Greymouth",
"6479005", "Tauranga",
"649295", "Auckland",
"6479849", "Thames",
"6439287", "Oamaru",
"6475618", "Opotiki",
"6477777", "Hamilton",
"6472427", "Rotorua",
"6435662", "Geraldine",
"6434261", "Balclutha",
"649582", "Auckland",
"647882", "Putaruru\/Tokoroa",
"6499725", "Hibiscus\ Coast",
"647957", "Hamilton",
"646214", "Gisborne",
"6439530", "Timaru",
"6439858", "Kaikoura",
"64953", "Auckland",
"6499465", "Dargaville",
"6493207", "Hibiscus\ Coast",
"649600", "Auckland",
"6478993", "Waihi",
"6432638", "Tokanui",
"6432731", "Timaru",
"6499007", "Kaikohe",
"6496015", "Maungaturoto",
"6435550", "Fox\ Glacier",
"6468258", "Waiouru",
"6462220", "New\ Plymouth",
"649390", "Auckland",
"649908", "Auckland",
"6439331", "Greymouth",
"6465614", "Wanganui",
"649965", "Auckland",
"6439523", "Balclutha",
"6498901", "Pukekohe",
"643944", "Christchurch",
"649216", "Auckland",
"6432804", "Riverton",
"6462814", "Hawera",
"6469025", "Mokau",
"647378", "Taupo",
"6462617", "Masterton",
"6432607", "Dunedin",
"6437451", "Blenheim",
"6439717", "Fairlie",
"646750", "Mokau",
"647863", "Waihi",
"643751", "Fox\ Glacier",
"6469273", "New\ Plymouth",
"649296", "Auckland",
"647552", "Tauranga",
"6433940", "Westport",
"6466522", "Palmerston\ North",
"649912", "Auckland",
"643920", "Rangiora",
"646964", "Wanganui",
"6473332", "Rotorua",
"6439295", "Nelson",
"6473997", "Te\ Kuiti",
"6445955", "Wellington",
"6439868", "Blenheim",
"6499455", "Dargaville",
"643206", "Edendale",
"6466558", "Opunake",
"643300", "Ashburton\/Akaroa\/Chatham\ Islands",
"6449741", "Paraparaumu",
"6474448", "Taumarunui",
"644576", "Wellington",
"643788", "Westport",
"6435560", "Mt\ Cook",
"6468815", "Pahiatua",
"6468268", "New\ Plymouth",
"6439001", "Christchurch",
"643468", "Dunedin",
"6433981", "Twizel",
"6439769", "Roxburgh",
"6439049", "Palmerston",
"6435676", "Kurow",
"6472810", "Tauranga",
"643989", "Nelson",
"6498690", "Kawakawa",
"6475610", "Putaruru\/Tokoroa",
"649892", "Auckland",
"643981", "Christchurch",
"6472613", "Putaruru\/Tokoroa",
"646864", "Ruatoria",
"6432656", "Nelson",
"649812", "Auckland",
"6479022", "Morrinsville",
"6434279", "Twizel",
"6436614", "Timaru",
"6479246", "Thames",
"6477882", "Hamilton",
"6432630", "Christchurch",
"6499101", "Pukekohe",
"649887", "Auckland",
"649952", "Auckland",
"6436587", "Gore",
"6463993", "Pahiatua",
"6432729", "Westport",
"6437479", "Edendale",
"6432644", "Westport",
"6468250", "Stratford",
"6439083", "Cheviot",
"6462228", "Wanganui",
"6463913", "Hawera",
"6435558", "Waimate",
"6469571", "Palmerston\ North",
"6472141", "Te\ Kuiti",
"6468821", "Featherston",
"6439873", "Wanaka",
"6499746", "Kawakawa",
"646382", "Taihape",
"6499066", "Helensville",
"6439850", "Ashburton",
"6463924", "Marton",
"649233", "Pukekohe",
"6462168", "Featherston",
"646323", "Palmerston\ North",
"6432651", "Queenstown",
"64332", "Christchurch",
"6499014", "Dargaville",
"6433918", "Fox\ Glacier",
"644296", "Paraparaumu",
"6463908", "Wairoa",
"6435685", "Tokanui",
"6439762", "Oamaru",
"6432223", "Akaroa",
"6496510", "Whangarei",
"6435529", "Roxburgh",
"6439042", "Oamaru",
"6443333", "Paraparaumu",
"6432758", "Otautau",
"6495589", "Pukekohe",
"6433998", "Lumsden",
"6479029", "Waihi",
"6435671", "Oamaru",
"6434272", "Alexandra",
"644390", "Wellington",
"6433986", "Queenstown",
"646654", "Gisborne",
"646903", "Palmerston\ North",
"6439006", "Nelson",
"6469016", "Ohakune",
"6472827", "Tauranga",
"6437472", "Lawrence",
"6432722", "Murchison",
"6469284", "Stratford",
"6468826", "Levin",
"6472146", "Otorohanga",
"6469576", "Dannevirke",
"643250", "Christchurch",
"6496880", "Auckland",
"643738", "Greymouth",
"6499298", "Pukekohe",
"6475627", "Taupo",
"6499061", "Hibiscus\ Coast",
"6479500", "Whakatane",
"6477889", "Whakatane",
"6439458", "Edendale",
"647876", "Te\ Kuiti",
"6499557", "Warkworth",
"6474655", "Te\ Kuiti",
"6498824", "Kawakawa",
"6475824", "Hamilton",
"6479241", "Whakatane",
"6436623", "Amberley",
"649826", "Auckland",
"6479718", "Taumarunui",
"6472608", "Waihi",
"6472624", "Whakatane",
"6436638", "Kurow",
"649200", "Auckland",
"6434230", "Christchurch",
"6437456", "Culverden",
"6473920", "Huntly",
"6434244", "Amberley",
"6439884", "Franz\ Josef",
"644462", "Wellington",
"6462150", "New\ Plymouth",
"6439057", "Waimate",
"6439336", "Cromwell",
"649477", "Auckland",
"6466529", "Pahiatua",
"6432420", "Christchurch",
"6437770", "Nelson",
"6469315", "Taihape",
"644892", "Paraparaumu",
"6496990", "Kaitaia",
"6473339", "Taupo",
"646211", "Napier",
"644495", "Wellington",
"6478143", "Opotiki",
"6478137", "Thames",
"6434404", "Alexandra",
"6465623", "Opunake",
"6479100", "Rotorua",
"6466000", "Napier",
"6462105", "Taihape",
"646375", "Pahiatua",
"644887", "Wellington",
"6462620", "New\ Plymouth",
"6439720", "Blenheim",
"6474637", "Opotiki",
"6437444", "Takaka",
"6442198", "Paraparaumu",
"6432995", "Winton",
"6439278", "Invercargill",
"6475482", "Tauranga",
"6436526", "Fox\ Glacier",
"6437466", "Cromwell",
"643949", "Dunedin",
"6469853", "Wairoa",
"643941", "Christchurch",
"643450", "Queenstown",
"6462160", "Masterton",
"6439067", "Franz\ Josef",
"6439733", "Te\ Anau",
"6479842", "Matamata",
"6436563", "Lawrence",
"6498855", "Kawakawa",
"6439747", "Wanaka",
"6449030", "Paraparaumu",
"6496518", "Kawakawa",
"6433910", "Nelson",
"6435531", "Nelson",
"6463900", "Gisborne",
"6432750", "Invercargill",
"647823", "Hamilton",
"6493932", "Dargaville",
"6434223", "Otautau",
"644496", "Wellington",
"6479710", "Putaruru\/Tokoroa",
"6472600", "Hamilton",
"649847", "Auckland",
"647547", "Tauranga",
"6473947", "Whakatane",
"6478084", "Hamilton",
"646969", "New\ Plymouth",
"6435669", "Wanaka",
"643960", "Christchurch",
"6495565", "Dargaville",
"6432736", "Dunedin",
"6473933", "Rotorua",
"646376", "Pahiatua",
"6472803", "Waihi",
"6432447", "Timaru",
"6434266", "Palmerston",
"646304", "Featherston",
"647245", "Hamilton",
"6475603", "Hamilton",
"646342", "Wanganui",
"6472125", "Huntly",
"6444888", "Paraparaumu",
"6439450", "Invercargill",
"6439019", "Roxburgh",
"6469009", "Palmerston\ North",
"6462158", "Opunake",
"6432661", "Christchurch",
"6432428", "Queenstown",
"64962", "Auckland",
"6437778", "Greymouth",
"6439099", "Kaikoura",
"6479857", "Opotiki",
"6436578", "Wanaka",
"6439752", "Cheviot",
"643984", "Blenheim",
"6496998", "Helensville",
"6462414", "Napier",
"649422", "Warkworth",
"6434995", "Te\ Anau",
"6436630", "Takaka",
"6467553", "New\ Plymouth",
"646861", "Gisborne",
"6434238", "Waitangi\ \(Chatham\ Is\.\)",
"646768", "New\ Plymouth",
"6473928", "Te\ Awamutu",
"6439322", "Culverden",
"6436644", "Alexandra",
"6436656", "Hokitika",
"6479296", "Tauranga",
"6462628", "Wanganui",
"6439728", "Franz\ Josef",
"647923", "Whakatane",
"6463943", "Masterton",
"6469714", "Hawera",
"6439270", "Greymouth",
"6439704", "Murchison",
"6462604", "Ohakune",
"6462122", "Palmerston\ North",
"649400", "Kaikohe",
"6432614", "Akaroa",
"6472191", "Whakatane",
"6432817", "Christchurch",
"6462807", "Napier\/Hastings",
"649825", "Auckland",
"6466008", "Ohakune",
"647832", "Hamilton",
"6479108", "Whakatane",
"6465607", "Taihape",
"64926", "Auckland",
"6435697", "Westport",
"643538", "Nelson",
"6499716", "Helensville",
"647362", "Rotorua",
"644819", "Wellington",
"6473990", "Te\ Awamutu",
"6432655", "Nelson",
"6468998", "Napier",
"644203", "Wellington",
"644907", "Wellington",
"6434282", "Queenstown",
"6435681", "Invercargill",
"6479747", "Te\ Kuiti",
"647949", "Hamilton",
"644891", "Wellington",
"6435675", "Twizel",
"6468692", "Gisborne",
"6435999", "Christchurch",
"644461", "Wellington",
"6499472", "Great\ Barrier\ Island",
"6468242", "Ruatoria",
"6436509", "Waitangi\ \(Chatham\ Is\.\)",
"6465613", "Wairoa",
"6473841", "Taupo",
"647315", "Opotiki",
"647884", "Morrinsville",
"6432803", "Otautau",
"6462813", "Wanganui",
"6439524", "Oamaru",
"6499065", "Helensville",
"6474651", "Otorohanga",
"6433947", "Darfield",
"6479245", "Matamata",
"649640", "Auckland",
"643236", "Winton",
"647960", "Hamilton",
"6442128", "Paraparaumu",
"6439710", "Timaru",
"6469274", "New\ Plymouth",
"6462610", "Napier",
"6437482", "Lumsden",
"646856", "Waipukurau",
"643667", "Christchurch",
"6435519", "Twizel",
"6468257", "Taihape",
"649280", "Auckland",
"643446", "Roxburgh",
"6436580", "Invercargill",
"6499008", "Pukekohe",
"6463914", "Stratford",
"649478", "Auckland",
"6432637", "Winton",
"6466999", "New\ Plymouth",
"6439084", "Amberley",
"6432643", "Haast",
"646753", "New\ Plymouth",
"6463994", "Dannevirke",
"6439857", "Akaroa",
"6479752", "Rotorua",
"6493208", "Helensville",
"6439874", "Cromwell",
"6479019", "Whangamata",
"643685", "Fairlie",
"6472428", "Taupo",
"6469311", "Palmerston\ North",
"6478450", "Hamilton",
"6477778", "Te\ Awamutu",
"6475617", "Whakatane",
"6439288", "Ashburton",
"6469242", "Levin",
"6472817", "Taupo",
"643303", "Ashburton\/Akaroa\/Chatham\ Islands",
"6432712", "Amberley",
"6462149", "Ruatoria",
"647849", "Hamilton",
"644888", "Wellington",
"6433952", "Fairlie",
"6468816", "Hawera",
"643525", "Takaka",
"6462101", "Levin",
"6435889", "Timaru",
"6468888", "Masterton",
"6472614", "Otorohanga",
"6439296", "Invercargill",
"6445956", "Wellington",
"6436613", "Wanaka",
"6499456", "Kaikohe",
"6498814", "Pukekohe",
"6496009", "Pukekohe",
"643923", "Nelson",
"6432991", "Milton",
"649429", "Great\ Barrier\ Island",
"6478594", "Hamilton",
"6462424", "Wanganui",
"6467774", "Dannevirke",
"643445", "Cromwell",
"64937", "Auckland",
"6474447", "Te\ Kuiti",
"649421", "Hibiscus\ Coast",
"6439029", "Tokanui",
"6435542", "Riverton",
"6479006", "Taupo",
"6466557", "Stratford",
"644240", "Wellington",
"6498851", "Pukekohe",
"6472223", "Hamilton",
"6499879", "Warkworth",
"6492839", "Whangarei",
"6469302", "Napier",
"6435506", "Amberley",
"6492426", "Whangarei",
"6439312", "Riverton",
"649814", "Auckland",
"6497776", "Hibiscus\ Coast",
"6473998", "Taumarunui",
"6436682", "Dunedin",
"643436", "Kurow",
"6479422", "Tauranga",
"6468990", "Ruatoria",
"643693", "Geraldine",
"643686", "Timaru",
"6436996", "Takaka",
"6435535", "Invercargill",
"646862", "Gisborne",
"6492222", "Auckland",
"6499043", "Hibiscus\ Coast",
"6432624", "Milton",
"6432749", "Wanaka",
"6495561", "Whangarei",
"6499423", "Great\ Barrier\ Island",
"6496016", "Warkworth",
"649954", "Auckland",
"6439718", "Mt\ Cook",
"643526", "Motueka",
"6469299", "Napier\/Hastings",
"6432608", "Dunedin",
"6462618", "Masterton",
"647839", "Hamilton",
"6478074", "Taumarunui",
"6499726", "Kawakawa",
"6468809", "Masterton",
"6499466", "Kaikohe",
"644589", "Wellington",
"6472121", "Te\ Kuiti",
"6469045", "Waipukurau",
"649948", "Auckland",
"643942", "Christchurch",
"6424", "Scott\ Base",
"643653", "Blenheim",
"6472420", "Hamilton",
"6436596", "Queenstown",
"6477770", "Tauranga",
"6462227", "Napier",
"6449082", "Wellington",
"6478994", "Tauranga",
"6435557", "Geraldine",
"6434991", "Cromwell",
"6436588", "Lumsden",
"6499000", "Auckland",
"6447771", "Paraparaumu",
"6468880", "Napier\/Hastings",
"649630", "Auckland",
"6468302", "Napier",
"649914", "Auckland",
"643246", "Tokanui",
"6434293", "Haast",
"6449122", "Wellington",
"6439280", "Nelson",
"6472115", "Taumarunui",
"646341", "Wanganui",
"643235", "Invercargill",
"646349", "Wanganui",
"6472195", "Rotorua",
"647210", "Hamilton",
"646855", "Waipukurau",
"643390", "Christchurch",
"6462165", "Stratford",
"647346", "Rotorua",
"6432888", "Nelson",
"6498850", "Great\ Barrier\ Island",
"643965", "Christchurch",
"649902", "Warkworth",
"643216", "Invercargill",
"6433915", "Greymouth",
"6435688", "Queenstown",
"6463905", "Napier",
"647372", "Taupo",
"6432755", "Edendale",
"6436657", "Franz\ Josef",
"6479297", "Tauranga",
"6433995", "Tokanui",
"6468991", "Gisborne",
"6434299", "Haast",
"6435696", "Haast",
"6493934", "Kaitaia",
"6499717", "Whangarei",
"6465606", "Waiouru",
"6479844", "Otorohanga",
"6436548", "Waimate",
"6432816", "Waimate",
"6462806", "Napier\/Hastings",
"643455", "Dunedin",
"6479856", "Tauranga",
"649918", "Auckland",
"6478082", "Tauranga",
"6499295", "Kaikohe",
"6472120", "Putaruru\/Tokoroa",
"6439455", "Otautau",
"644250", "Wellington",
"64354", "Nelson",
"649889", "Auckland",
"647589", "Hamilton",
"649881", "Auckland",
"6479715", "Paeroa",
"6472605", "Thames",
"6474658", "Waihi",
"6495560", "Whangarei",
"647970", "Hamilton",
"643782", "Westport",
"644939", "Wellington",
"6434990", "Queenstown",
"6499001", "Auckland",
"6436635", "Fairlie",
"6432737", "Palmerston",
"6442420", "Wellington",
"646836", "Napier\/Hastings",
"6462412", "Gisborne",
"6447770", "Paraparaumu",
"6473946", "Taupo",
"6439754", "Darfield",
"6499049", "Great\ Barrier\ Island",
"649405", "Kaikohe",
"647870", "Te\ Awamutu",
"644931", "Wellington",
"6432743", "Kurow",
"6469293", "New\ Plymouth",
"6436642", "Milton",
"6439324", "Darfield",
"6432446", "Blenheim",
"6434267", "Ranfurly",
"6469318", "Levin",
"6468803", "Gisborne",
"6477771", "Whakatane",
"649820", "Auckland",
"649818", "Auckland",
"646845", "Napier\/Hastings",
"643415", "Balclutha",
"6469712", "New\ Plymouth",
"646307", "Featherston",
"6439702", "Nelson",
"6462602", "Palmerston\ North",
"6462124", "Marton",
"6432612", "Rangiora",
"649958", "Helensville",
"644290", "Paraparaumu",
"6439281", "Christchurch",
"6439023", "Te\ Anau",
"6462108", "Ohakune",
"6437467", "Queenstown",
"6436527", "Haast",
"647544", "Tauranga",
"6499873", "Kaitaia",
"6492833", "Warkworth",
"644210", "Wellington",
"6468881", "Napier\/Hastings",
"6432998", "Tokanui",
"6439746", "Dunedin",
"6439066", "Hokitika",
"6439275", "Nelson",
"646388", "Taihape",
"6439044", "Milton",
"646835", "Napier\/Hastings",
"6439764", "Lawrence",
"649406", "Kaitaia",
"6443990", "Paraparaumu",
"6478136", "Te\ Awamutu",
"6499012", "Kawakawa",
"64936", "Auckland",
"6462137", "Palmerston\ North",
"6463922", "Palmerston\ North",
"6435883", "Dunedin",
"6473991", "Whakatane",
"649650", "Auckland",
"6498858", "Kaikohe",
"6435680", "Dunedin",
"647988", "Rotorua",
"6496515", "Dargaville",
"6436619", "Cheviot",
"6434274", "Kurow",
"6435513", "Waitangi\ \(Chatham\ Is\.\)",
"6474650", "Morrinsville",
"6439711", "Geraldine",
"6437457", "Darfield",
"6462611", "Napier",
"6466993", "Waiouru",
"6437474", "Oamaru",
"6432649", "Waimate",
"6469282", "Mokau",
"6432724", "Greymouth",
"6495568", "Kawakawa",
"6472622", "Tauranga",
"647959", "Hamilton",
"6439343", "Waimate",
"6472128", "Waihi",
"6498822", "Kaikohe",
"6439337", "Wanaka",
"6462155", "Hawera",
"647345", "Rotorua",
"6465619", "Masterton",
"646657", "Masterton",
"6478093", "Rotorua",
"6434242", "Darfield",
"6439882", "Westport",
"643966", "Christchurch",
"6475626", "Taupo",
"6432425", "Invercargill",
"6437775", "Wanaka",
"6443708", "Paraparaumu",
"6468827", "New\ Plymouth",
"6469310", "Wanganui",
"6478451", "Hamilton",
"6472147", "Paeroa",
"6469577", "Ohakune",
"643215", "Invercargill",
"6432809", "Hokitika",
"6462819", "Levin",
"6472826", "Matamata",
"647851", "Hamilton",
"649551", "Auckland",
"6496995", "Maungaturoto",
"6472133", "Taupo",
"6434998", "Dunedin",
"6436581", "Invercargill",
"6434235", "Akaroa",
"6473925", "Putaruru\/Tokoroa",
"646370", "Masterton",
"6499556", "Maungaturoto",
"647888", "Matamata",
"649588", "Auckland",
"646946", "Masterton",
"6462625", "Hawera",
"643456", "Dunedin",
"6439725", "Christchurch",
"6434402", "Alexandra",
"6432990", "Lumsden",
"646601", "Napier",
"6437442", "Murchison",
"6435993", "Mt\ Cook",
"6433987", "Cromwell",
"6466005", "Mokau",
"6462100", "Levin",
"6439007", "Dunedin",
"6469017", "Marton",
"6436503", "Ashburton",
"6435544", "Winton",
"6462161", "Masterton",
"6432658", "Murchison",
"647557", "Tauranga",
"649982", "Whangarei",
"6432751", "Riverton",
"6433991", "Invercargill",
"6462422", "Napier\/Hastings",
"643469", "Dunedin",
"6468995", "Napier",
"6467772", "Hawera",
"6446509", "Paraparaumu",
"6449031", "Paraparaumu",
"6478592", "Hamilton",
"6433911", "Nelson",
"6463901", "Gisborne",
"6435530", "Nelson",
"646764", "Stratford",
"6435678", "Roxburgh",
"6436684", "Dunedin",
"6498883", "Whangarei",
"644975", "Paraparaumu",
"6469304", "Wairoa",
"6439314", "Winton",
"6469003", "Napier\/Hastings",
"6436597", "Cromwell",
"647866", "Thames",
"6436517", "Motueka",
"6462114", "Waipukurau",
"6432622", "Balclutha",
"6499748", "Whangarei",
"6439451", "Invercargill",
"6492224", "Auckland",
"6499068", "Pukekohe",
"6439536", "Waimate",
"643951", "Dunedin",
"6479711", "Whangamata",
"6472601", "Hamilton",
"6467559", "New\ Plymouth",
"649801", "Auckland",
"6466012", "Pahiatua",
"6442125", "Paraparaumu",
"649213", "Auckland",
"649917", "Auckland",
"6478072", "Paeroa",
"644245", "Wellington",
"6462226", "Napier",
"6435556", "Fairlie",
"6434229", "Winton",
"649817", "Auckland",
"643336", "Christchurch",
"6496017", "Great\ Barrier\ Island",
"6436631", "Motueka",
"6499005", "Auckland",
"649635", "Auckland",
"649909", "Auckland",
"6435663", "Twizel",
"6469040", "Wairoa",
"6499467", "Kaitaia",
"647215", "Rotorua",
"6472809", "Otorohanga",
"6432660", "Christchurch",
"6475609", "Paeroa",
"643230", "Invercargill",
"6499727", "Whangarei",
"6494706", "Whangarei",
"6449084", "Wellington",
"6477775", "Huntly",
"6478992", "Paeroa",
"646387", "Waiouru",
"6439285", "Invercargill",
"6479007", "Whakatane",
"6466556", "Stratford",
"6472190", "Whakatane",
"6474446", "Otorohanga",
"6435956", "Christchurch",
"6436997", "Motueka",
"643789", "Westport",
"6439739", "Invercargill",
"6468885", "New\ Plymouth",
"64983", "Auckland",
"6436569", "Alexandra",
"6435507", "Ashburton",
"6492427", "Warkworth",
"6497777", "Auckland",
"6439271", "Westport",
"644525", "Wellington",
"646365", "Palmerston\ North",
"649957", "Pukekohe",
"6449124", "Wellington",
"646308", "Featherston",
"6468817", "Stratford",
"6434284", "Wanaka",
"649552", "Pukekohe",
"643335", "Christchurch",
"647852", "Hamilton",
"647987", "Tauranga",
"6472816", "Morrinsville",
"6435670", "Palmerston",
"649636", "Auckland",
"644436", "Wellington",
"6475616", "Whangamata",
"6468244", "Waipukurau",
"6499457", "Kaitaia",
"647216", "Rotorua",
"6439297", "Takaka",
"6473995", "Putaruru\/Tokoroa",
"6499474", "Helensville",
"6432650", "Christchurch",
"647390", "Hamilton",
"6435538", "Lumsden",
"6474649", "Matamata",
"6496511", "Whangarei",
"6479240", "Taupo",
"6439522", "Dunedin",
"644804", "Wellington",
"6432636", "Te\ Anau",
"643224", "Invercargill",
"6469869", "Ruatoria",
"6439715", "Timaru",
"6462615", "Gisborne",
"6468256", "Palmerston\ North",
"6469272", "Featherston",
"6496881", "Auckland",
"6437484", "Riverton",
"6466523", "Palmerston\ North",
"6479501", "Opotiki",
"644526", "Wellington",
"646366", "Levin",
"6442608", "Paraparaumu",
"6439856", "Darfield",
"647812", "Hamilton",
"6463992", "Levin",
"6437771", "Blenheim",
"6439269", "Dunedin",
"643520", "Blenheim",
"6462151", "New\ Plymouth",
"6432668", "Blenheim",
"6439082", "Culverden",
"6463912", "New\ Plymouth",
"6496991", "Kaikohe",
"647350", "Rotorua",
"6477883", "Hamilton",
"6434231", "Christchurch",
"6436629", "Christchurch",
"647892", "Taumarunui",
"6436585", "Tokanui",
"6439872", "Alexandra",
"6479754", "Tauranga",
"647462", "Taupo",
"6433946", "Culverden",
"6473921", "Matamata",
"644904", "Paraparaumu",
"6462621", "New\ Plymouth",
"6439721", "Blenheim",
"6479746", "Opotiki",
"6433954", "Lawrence",
"6432714", "Cheviot",
"647865", "Whangamata",
"6469614", "Levin",
"6432229", "Dunedin",
"6472118", "Taumarunui",
"64927", "Auckland",
"643680", "Fairlie",
"643430", "Mt\ Cook",
"649963", "Auckland",
"6472198", "Opotiki",
"6472612", "Te\ Awamutu",
"6479101", "Rotorua",
"6466001", "Napier",
"647887", "Morrinsville",
"649905", "Auckland",
"646272", "Hawera",
"643962", "Christchurch",
"6475820", "Hamilton",
"6498820", "Whangarei",
"649968", "Auckland",
"644439", "Wellington",
"649631", "Auckland",
"6472620", "Tauranga",
"6437475", "Palmerston",
"6432725", "Hokitika",
"6436627", "Waitangi\ \(Chatham\ Is\.\)",
"6473842", "Taupo",
"6499553", "Kaikohe",
"649639", "Auckland",
"6496884", "Auckland",
"6437481", "Invercargill",
"6475623", "Tauranga",
"6469280", "Waipukurau",
"647332", "Rotorua",
"6474652", "Paeroa",
"647211", "Hamilton",
"6439267", "Dunedin",
"6472823", "Whakatane",
"6495533", "Whangarei",
"6434281", "Queenstown",
"6435682", "Riverton",
"6439765", "Milton",
"643767", "Greymouth",
"643452", "Wanaka",
"6439045", "Twizel",
"6435996", "Akaroa",
"649458", "Dargaville",
"646976", "Napier",
"6436506", "Darfield",
"646653", "Wanganui",
"6478128", "Huntly",
"6499010", "Kaitaia",
"646369", "Levin",
"6468241", "Gisborne",
"644529", "Wellington",
"6432227", "Queenstown",
"6499471", "Hibiscus\ Coast",
"6463920", "Palmerston\ North",
"6468691", "Gisborne",
"646324", "Palmerston\ North",
"6434275", "Milton",
"6496514", "Whangarei",
"6433951", "Timaru",
"6462624", "Opunake",
"649402", "Kawakawa",
"6462102", "Levin",
"643465", "Palmerston",
"6439724", "Blenheim",
"649347", "Auckland",
"6432711", "Akaroa",
"6469611", "Wanganui",
"6469241", "Napier",
"6439299", "Murchison",
"6439708", "Murchison",
"6432618", "Culverden",
"6462608", "Dannevirke",
"6437440", "Nelson",
"6499459", "Maungaturoto",
"6434400", "Alexandra",
"6432992", "Gore",
"6465627", "Levin",
"644260", "Wellington",
"643487", "Dunedin",
"646842", "Napier\/Hastings",
"6478133", "Putaruru\/Tokoroa",
"6466004", "Waipukurau",
"6435886", "Invercargill",
"6468819", "Mokau",
"6432424", "Nelson",
"643955", "Dunedin",
"6437774", "Queenstown",
"6439070", "Motueka",
"649420", "Helensville",
"6462154", "New\ Plymouth",
"643412", "Balclutha",
"6496994", "Dargaville",
"6462418", "Palmerston\ North",
"647903", "Hamilton",
"6439346", "Christchurch",
"6469029", "Opunake",
"6435516", "Balclutha",
"6469312", "Ohakune",
"6434234", "Darfield",
"6466996", "Stratford",
"6436648", "Lumsden",
"6473924", "Paeroa",
"6439880", "Greymouth",
"6434240", "Ashburton",
"6479751", "Tauranga",
"647323", "Whakatane",
"643466", "Dunedin",
"6495562", "Whangarei",
"6469288", "Waiouru",
"6475607", "Morrinsville",
"6439454", "Lumsden",
"6468806", "New\ Plymouth",
"6432443", "Christchurch",
"6499630", "Pukekohe",
"6472807", "Te\ Awamutu",
"6492221", "Auckland",
"6499469", "Maungaturoto",
"6475828", "Hamilton",
"6479714", "Huntly",
"6472604", "Hamilton",
"6472122", "Te\ Awamutu",
"6432746", "Alexandra",
"644928", "Wellington",
"6472628", "Taupo",
"6496019", "Auckland",
"644910", "Wellington",
"6479229", "Opotiki",
"6469296", "Levin",
"6478080", "Hamilton",
"6434227", "Riverton",
"649281", "Auckland",
"6499876", "Kaikohe",
"6492836", "Kaitaia",
"643956", "Timaru",
"6499018", "Maungaturoto",
"6435541", "Te\ Anau",
"6463928", "Pahiatua",
"647824", "Hamilton",
"6462164", "New\ Plymouth",
"6435509", "Culverden",
"6493942", "Great\ Barrier\ Island",
"6492429", "Pukekohe",
"6497779", "Great\ Barrier\ Island",
"6439743", "Christchurch",
"6433994", "Winton",
"6432754", "Tokanui",
"643753", "Hokitika",
"6436567", "Ranfurly",
"647869", "Thames",
"6463904", "Napier",
"6433914", "Takaka",
"6436999", "Nelson",
"6439063", "Westport",
"6439737", "Tokanui",
"6479421", "Tauranga",
"6436681", "Dunedin",
"6493935", "Kawakawa",
"6439311", "Invercargill",
"6469301", "Ruatoria",
"644392", "Wellington",
"6439026", "Riverton",
"6479845", "Paeroa",
"6498852", "Warkworth",
"6479009", "Hamilton",
"6435693", "Nelson",
"6468301", "Napier",
"6465603", "Palmerston\ North",
"6462125", "Taihape",
"649220", "Auckland",
"649218", "Auckland",
"643331", "Christchurch",
"647304", "Whakatane",
"643212", "Invercargill",
"647376", "Taupo",
"643339", "Christchurch",
"6432813", "Geraldine",
"6462803", "Palmerston\ North",
"647961", "Hamilton",
"6439700", "Nelson",
"6439274", "Queenstown",
"6469710", "New\ Plymouth",
"6498018", "Whangarei",
"6432610", "Darfield",
"6462600", "Palmerston\ North",
"6449121", "Wellington",
"6437448", "Haast",
"649298", "Auckland",
"644810", "Wellington",
"6439755", "Rangiora",
"6436634", "Mt\ Cook",
"6436640", "Palmerston",
"646975", "Napier",
"64935", "Auckland",
"6467557", "New\ Plymouth",
"6434248", "Cheviot",
"643983", "Christchurch",
"6439325", "Kaikoura",
"644890", "Wellington",
"6479853", "Putaruru",
"6434992", "Ranfurly",
"6436519", "Takaka",
"6462410", "New\ Plymouth",
"6466509", "Napier\/Waipukurau",
"64357", "Blenheim",
"6436599", "Blenheim",
"6449081", "Paraparaumu",
"644460", "Wellington",
"649985", "Auckland",
"6432628", "Ranfurly",
"6499062", "Hibiscus\ Coast",
"6469468", "Featherston",
"6439714", "Waimate",
"6469270", "Marton",
"6462614", "Wairoa",
"649401", "Kaikohe",
"649409", "Kaitaia",
"6433943", "Amberley",
"6437471", "Kurow",
"6432721", "Motueka",
"649583", "Auckland",
"647883", "Putaruru\/Tokoroa",
"647896", "Taumarunui",
"6478078", "Whangamata",
"6437485", "Te\ Anau",
"6432807", "Tokanui",
"6462817", "Napier",
"6472149", "Whangamata",
"6469579", "Pahiatua",
"6479242", "Rotorua",
"6439520", "Dunedin",
"649967", "Auckland",
"647466", "Tauranga",
"64997", "Auckland",
"6465617", "Mokau",
"6477886", "Rotorua",
"6467778", "Wairoa",
"6479026", "Paeroa",
"6434285", "Cheviot",
"6439009", "Greymouth",
"6469019", "Pahiatua",
"6439761", "Kurow",
"6433989", "Waimate",
"6478598", "Hamilton",
"643419", "Balclutha",
"644370", "Wellington",
"6435563", "Queenstown",
"6432652", "Cromwell",
"644204", "Wellington",
"6499810", "Hibiscus\ Coast",
"6499475", "Hibiscus\ Coast",
"6473994", "Rotorua",
"6467529", "Mokau",
"6468245", "Wairoa",
"6435526", "Kurow",
"644777", "Wellington",
"643768", "Greymouth",
"6435672", "Balclutha",
"6434271", "Balclutha",
"649632", "Auckland",
"6472610", "Morrinsville",
"6432715", "Culverden",
"6436617", "Cromwell",
"647856", "Hamilton",
"6469615", "Masterton",
"6433955", "Mt\ Cook",
"643488", "Dunedin",
"643924", "Christchurch",
"643961", "Christchurch",
"643270", "Christchurch",
"64943", "Whangarei",
"646279", "Hawera",
"643304", "Ashburton\/Akaroa\/Chatham\ Islands",
"6462139", "Palmerston\ North",
"6475481", "Tauranga",
"6472813", "Waihi",
"649348", "Auckland",
"6475613", "Te\ Awamutu",
"649394", "Auckland",
"6439870", "Queenstown",
"6466526", "Waiouru",
"64757", "Tauranga",
"643940", "Christchurch",
"643451", "Queenstown",
"647983", "Hamilton",
"646949", "Levin\ W100",
"6439853", "Amberley",
"6436584", "Winton",
"6432647", "Fairlie",
"6432633", "Otautau",
"6478998", "Hamilton",
"646754", "New\ Plymouth",
"6437459", "Rangiora",
"6463990", "Featherston",
"646362", "Levin",
"6439080", "Ashburton",
"6468253", "Marton",
"6496508", "Hibiscus\ Coast",
"64952", "Auckland",
"6478070", "Morrinsville",
"643219", "Invercargill",
"649555", "Auckland",
"647855", "Hamilton",
"643332", "Christchurch",
"643211", "Invercargill",
"6434269", "Twizel",
"647349", "Rotorua",
"6492225", "Pukekohe",
"64338", "Christchurch",
"6439528", "Lawrence",
"6494703", "Whangarei",
"6466010", "Taihape",
"6462115", "Wairoa",
"6432620", "Palmerston",
"649953", "Auckland",
"64944", "Auckland",
"6469278", "Gisborne",
"6435666", "Oamaru",
"6499047", "Pukekohe",
"6432739", "Balclutha",
"6499818", "Great\ Barrier\ Island",
"6435545", "Gore",
"6496100", "Pukekohe",
"649813", "Auckland",
"6468994", "Waipukurau",
"6439863", "Motueka",
"6436685", "Nelson",
"6466553", "New\ Plymouth",
"6436529", "Westport",
"6462420", "Palmerston\ North",
"6493931", "Whangarei",
"6434351", "Mt\ Cook",
"6467770", "Gisborne",
"643614", "Timaru",
"6478590", "Hamilton",
"6435532", "Motueka",
"6437469", "Alexandra",
"643930", "Christchurch",
"6479841", "Huntly",
"6474443", "Matamata",
"649886", "Auckland",
"6439315", "Tokanui",
"6479045", "Taumarunui",
"6469305", "New\ Plymouth",
"6468263", "Napier",
"6435953", "Christchurch",
"649986", "Whangarei",
"649297", "Auckland",
"6462121", "Palmerston\ North",
"6439284", "Blenheim",
"646839", "Napier\/Hastings",
"6499719", "Whangarei",
"646831", "Napier\/Hastings",
"6434297", "Westport",
"647895", "Taumarunui",
"6436659", "Haast",
"6479299", "Rotorua",
"6479708", "Thames",
"6468884", "Palmerston\ North",
"649913", "Auckland",
"6472192", "Whakatane",
"64456", "Wellington",
"647862", "Paeroa",
"6499004", "Hibiscus\ Coast",
"6439751", "Culverden",
"644577", "Wellington",
"6478990", "Thames",
"649282", "Auckland",
"6463998", "Palmerston\ North",
"643288", "Christchurch",
"6435553", "Wanaka",
"6463918", "Wanganui",
"6462223", "Palmerston\ North",
"6432662", "Christchurch",
"644391", "Wellington",
"6439321", "Amberley",
"643654", "Timaru",
"6439016", "Alexandra",
"643903", "Christchurch",
"6469006", "Gisborne",
"644399", "Wellington",
"6472424", "Tauranga",
"6477774", "Thames",
"6439533", "Geraldine",
"6432621", "Oamaru",
"6439452", "Gore",
"6437478", "Twizel",
"6432728", "Haast",
"649426", "Hibiscus\ Coast",
"647927", "Tauranga",
"6495564", "Whangarei",
"6435559", "Haast",
"6478085", "Tauranga",
"643439", "Oamaru",
"643689", "Waimate",
"6448880", "Paraparaumu",
"6478071", "Otorohanga",
"643681", "Timaru",
"643431", "Oamaru",
"6466011", "Marton",
"6479712", "Te\ Awamutu",
"647307", "Whakatane",
"6472602", "Hamilton",
"6472124", "Matamata",
"6439768", "Ranfurly",
"643521", "Nelson",
"6478591", "Hamilton",
"6463902", "Gisborne",
"6433912", "Motueka",
"6433992", "Riverton",
"6432752", "Te\ Anau",
"6462421", "New\ Plymouth",
"6439048", "Lawrence",
"6493930", "Whangarei",
"6434350", "Twizel",
"6467771", "New\ Plymouth",
"643529", "Nelson",
"6462162", "Masterton",
"6493944", "Hibiscus\ Coast",
"647351", "Rotorua",
"644915", "Wellington",
"6436653", "Edendale",
"6479293", "Hamilton",
"6498854", "Hibiscus\ Coast",
"644586", "Wellington",
"6434278", "Roxburgh",
"649652", "Warkworth",
"647836", "Hamilton",
"643260", "Christchurch",
"6439736", "Riverton",
"643979", "Christchurch",
"6436566", "Kurow",
"6439705", "Motueka",
"6469715", "Mokau",
"647543", "Tauranga",
"6432615", "Amberley",
"6462605", "Marton",
"644815", "Wellington",
"6499877", "Maungaturoto",
"6492837", "Hibiscus\ Coast",
"6439869", "Blenheim",
"6466559", "Mokau",
"6436523", "Hokitika",
"6439027", "Winton",
"6439272", "Timaru",
"6437463", "Mt\ Cook",
"644465", "Wellington",
"6462120", "Palmerston\ North",
"6474449", "Opotiki",
"6468269", "New\ Plymouth",
"644895", "Paraparaumu",
"6472806", "Matamata",
"6439320", "Akaroa",
"6468807", "Gisborne",
"6434263", "Lawrence",
"643249", "Te\ Anau",
"6436632", "Murchison",
"6462415", "Levin",
"6475606", "Matamata",
"6469297", "Masterton",
"6439750", "Kaikoura",
"6478991", "Whangamata",
"647827", "Hamilton",
"6434226", "Lumsden",
"64941", "Auckland",
"6434994", "Palmerston",
"646372", "Masterton",
"6494313", "Warkworth",
"6436645", "Ranfurly",
"6432747", "Queenstown",
"647391", "Hamilton",
"646346", "Wanganui",
"6432733", "Geraldine",
"6439333", "Franz\ Josef",
"6469285", "Hawera",
"6439347", "Christchurch",
"644816", "Wellington",
"6439521", "Dunedin",
"643484", "Dunedin",
"6475825", "Hamilton",
"6474654", "Taumarunui",
"6498825", "Maungaturoto",
"647533", "Tauranga",
"6432639", "Edendale",
"6466997", "New\ Plymouth",
"6437453", "Amberley",
"644466", "Wellington",
"6472625", "Opotiki",
"6437470", "Balclutha",
"643308", "Ashburton\/Akaroa\/Chatham\ Islands",
"6432720", "Nelson",
"64925", "Auckland",
"6435517", "Lawrence",
"6468259", "Levin",
"649666", "Auckland",
"644896", "Wellington",
"6496882", "Auckland",
"6469271", "Pahiatua",
"6496007", "Helensville",
"6499015", "Dargaville",
"6499811", "Hibiscus\ Coast",
"6463925", "Waiouru",
"6492808", "Great\ Barrier\ Island",
"6434270", "Oamaru",
"6435684", "Winton",
"6435887", "Invercargill",
"6439760", "Twizel",
"6496512", "Whangarei",
"6439040", "Balclutha",
"6493938", "Auckland",
"6472819", "Rotorua",
"6465626", "Ruatoria",
"643239", "Invercargill",
"649473", "Auckland",
"646345", "Wanganui",
"6475619", "Hamilton",
"643231", "Invercargill",
"6479848", "Te\ Kuiti",
"649320", "Auckland",
"646758", "New\ Plymouth",
"6434405", "Alexandra",
"6436507", "Kaikoura",
"6439003", "Ashburton",
"6462128", "Ohakune",
"6433983", "Ranfurly",
"6475480", "Tauranga",
"6435997", "Amberley",
"649425", "Warkworth",
"646951", "Palmerston\ North",
"643950", "Dunedin",
"643441", "Queenstown",
"643449", "Alexandra",
"6462104", "Marton",
"6439722", "Blenheim",
"644292", "Paraparaumu",
"6479102", "Rotorua",
"6466002", "Napier",
"6472611", "Matamata",
"644212", "Wellington",
"6432226", "Timaru",
"6437445", "Fox\ Glacier",
"6432994", "Otautau",
"6439758", "Ashburton",
"647846", "Hamilton",
"6496992", "Kawakawa",
"6436626", "Akaroa",
"6462152", "New\ Plymouth",
"647872", "Te\ Awamutu",
"6439081", "Ashburton",
"6463911", "New\ Plymouth",
"6463991", "Masterton",
"646327", "Marton",
"6434245", "Culverden",
"6439885", "Fox\ Glacier",
"649237", "Pukekohe",
"6433949", "Rangiora",
"6437772", "Timaru",
"649822", "Auckland",
"644916", "Wellington",
"6439266", "Dunedin",
"6473922", "Morrinsville",
"6439075", "Takaka",
"6439871", "Queenstown",
"6468823", "Napier\/Hastings",
"6472143", "Morrinsville",
"6469573", "Palmerston\ North",
"6478097", "Whakatane",
"64320", "Gore",
"6434232", "Ashburton",
"6469314", "Waiouru",
"6432625", "Twizel",
"643946", "Invercargill",
"649214", "Auckland",
"647308", "Whakatane",
"643743", "Christchurch",
"6478081", "Rotorua",
"6478075", "Te\ Kuiti",
"647928", "Tauranga",
"649294", "Auckland",
"6479859", "Tauranga",
"6439097", "Darfield",
"6492220", "Auckland",
"6436593", "Nelson",
"6499631", "Pukekohe",
"6439017", "Cromwell",
"6469007", "Masterton",
"6479420", "Tauranga",
"6436680", "Akaroa",
"6435699", "Amberley",
"6462425", "Masterton",
"6467775", "Palmerston\ North",
"647312", "Whakatane",
"6468992", "Wairoa",
"6465609", "Pahiatua",
"6478595", "Hamilton",
"6434288", "Cromwell",
"643657", "Queenstown",
"647850", "Hamilton",
"649550", "Auckland",
"646763", "Opunake",
"644499", "Wellington",
"6439310", "Invercargill",
"6479040", "Otorohanga",
"649248", "Auckland",
"6469300", "Gisborne",
"6432819", "Christchurch",
"6462809", "Napier\/Hastings",
"6499478", "Pukekohe",
"6468248", "New\ Plymouth",
"6435540", "Edendale",
"646379", "Masterton",
"6435534", "Takaka",
"6434296", "Greymouth",
"6472226", "Te\ Kuiti",
"6432718", "Rangiora",
"6435503", "Christchurch",
"6497773", "Dargaville",
"6433958", "Oamaru",
"6439282", "Christchurch",
"6439749", "Christchurch",
"6449120", "Wellington",
"6439701", "Nelson",
"6469711", "New\ Plymouth",
"6432611", "Kaikoura",
"6462601", "Palmerston\ North",
"6436993", "Kaikoura",
"6439069", "Haast",
"6472194", "Whakatane",
"644488", "Wellington",
"644924", "Wellington",
"6468300", "Napier",
"6472458", "Rotorua",
"6468882", "Napier\/Hastings",
"6479003", "Thames",
"643432", "Oamaru",
"6432664", "Christchurch",
"643522", "Nelson",
"6449080", "Paraparaumu",
"6432449", "Queenstown",
"647828", "Huntly",
"6499002", "Auckland",
"6462411", "New\ Plymouth",
"6499463", "Whangarei",
"647460", "Rotorua",
"643697", "Geraldine",
"6435667", "Waitangi\ \(Chatham\ Is\.\)",
"6473949", "Taupo",
"6499046", "Pukekohe",
"6478995", "Matamata",
"6477772", "Rotorua",
"6499426", "Auckland",
"6496013", "Whangarei",
"649590", "Auckland",
"6436641", "Lawrence",
"644299", "Paraparaumu",
"6469281", "Wairoa",
"646952", "Palmerston\ North\ W100",
"643442", "Queenstown",
"6439712", "Fairlie",
"643307", "Ashburton\/Akaroa\/Chatham\ Islands",
"6437480", "Gore",
"6492228", "Warkworth",
"6466527", "Taihape",
"6499064", "Helensville",
"6439525", "Milton",
"6462118", "Waipukurau",
"644211", "Wellington",
"6479244", "Tauranga",
"644219", "Wellington",
"6475821", "Hamilton",
"6498821", "Dargaville",
"64933", "Auckland",
"6479230", "Opotiki",
"646865", "Gisborne",
"6469275", "Wanganui",
"6472621", "Tauranga",
"644803", "Wellington",
"64438", "Wellington",
"6432646", "Timaru",
"646757", "New\ Plymouth",
"647871", "Te\ Awamutu",
"6432654", "Blenheim",
"6499470", "Hibiscus\ Coast",
"6463921", "Palmerston\ North",
"6499011", "Kaitaia",
"6435548", "Westport",
"6474639", "Opotiki",
"6492008", "Hibiscus\ Coast",
"649980", "Auckland",
"6439293", "Blenheim",
"6445953", "Wellington",
"6469203", "New\ Plymouth",
"6468690", "Gisborne",
"6436616", "Geraldine",
"6499453", "Warkworth",
"6435674", "Milton",
"6436688", "Waitangi\ \(Chatham\ Is\.\)",
"6434280", "Queenstown",
"6478139", "Whangamata",
"6473992", "Opotiki",
"6473337", "Rotorua",
"6439318", "Lumsden",
"6469308", "Opunake",
"649829", "Auckland",
"6468813", "Taihape",
"6469893", "Ruatoria",
"6468308", "Napier",
"6434401", "Cromwell",
"647366", "Rotorua",
"649964", "Auckland",
"6479027", "Paeroa",
"649880", "Auckland",
"6472615", "Te\ Kuiti",
"6432710", "Christchurch",
"6469610", "Wanganui",
"6435527", "Alexandra",
"6433950", "Waitangi\ \(Chatham\ Is\.\)",
"6437441", "Motueka",
"6498815", "Helensville",
"6469240", "Gisborne",
"646965", "Wanganui\ W100",
"644903", "Wellington",
"6463995", "Marton",
"6434241", "Rangiora",
"6439881", "Greymouth",
"6479750", "Tauranga",
"6439085", "Waitangi\ \(Chatham\ Is\.\)",
"6499559", "Whangarei",
"6463915", "Opunake",
"649238", "Pukekohe",
"6439875", "Ranfurly",
"6477887", "Te\ Awamutu",
"646328", "Palmerston\ North",
"6465616", "Hawera",
"6439071", "Motueka",
"6466548", "Ruatoria",
"6432806", "Edendale",
"6462816", "Gisborne",
"6472829", "Tauranga",
"6495539", "Auckland",
"6436582", "Riverton",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+64|\D)//g;
      my $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;