# automatically generated file, don't edit



# Copyright 2011 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::MY;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20210602223300;

my $formatters = [
                {
                  'format' => '$1-$2 $3',
                  'leading_digits' => '[4-79]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d)(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1-$2 $3',
                  'leading_digits' => '
            1(?:
              [02469]|
              [378][1-9]
            )|
            8
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{3,4})'
                },
                {
                  'format' => '$1-$2 $3',
                  'leading_digits' => '3',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d)(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3-$4',
                  'leading_digits' => '1[36-8]',
                  'pattern' => '(\\d)(\\d{3})(\\d{2})(\\d{4})'
                },
                {
                  'format' => '$1-$2 $3',
                  'leading_digits' => '15',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1-$2 $3',
                  'leading_digits' => '1',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{4})(\\d{4})'
                }
              ];

my $validators = {
                'fixed_line' => '
          (?:
            3(?:
              2[0-36-9]|
              3[0-368]|
              4[0-278]|
              5[0-24-8]|
              6[0-467]|
              7[1246-9]|
              8\\d|
              9[0-57]
            )\\d|
            4(?:
              2[0-689]|
              [3-79]\\d|
              8[1-35689]
            )|
            5(?:
              2[0-589]|
              [3468]\\d|
              5[0-489]|
              7[1-9]|
              9[23]
            )|
            6(?:
              2[2-9]|
              3[1357-9]|
              [46]\\d|
              5[0-6]|
              7[0-35-9]|
              85|
              9[015-8]
            )|
            7(?:
              [2579]\\d|
              3[03-68]|
              4[0-8]|
              6[5-9]|
              8[0-35-9]
            )|
            8(?:
              [24][2-8]|
              3[2-5]|
              5[2-7]|
              6[2-589]|
              7[2-578]|
              [89][2-9]
            )|
            9(?:
              0[57]|
              13|
              [25-7]\\d|
              [3489][0-8]
            )
          )\\d{5}
        ',
                'geographic' => '
          (?:
            3(?:
              2[0-36-9]|
              3[0-368]|
              4[0-278]|
              5[0-24-8]|
              6[0-467]|
              7[1246-9]|
              8\\d|
              9[0-57]
            )\\d|
            4(?:
              2[0-689]|
              [3-79]\\d|
              8[1-35689]
            )|
            5(?:
              2[0-589]|
              [3468]\\d|
              5[0-489]|
              7[1-9]|
              9[23]
            )|
            6(?:
              2[2-9]|
              3[1357-9]|
              [46]\\d|
              5[0-6]|
              7[0-35-9]|
              85|
              9[015-8]
            )|
            7(?:
              [2579]\\d|
              3[03-68]|
              4[0-8]|
              6[5-9]|
              8[0-35-9]
            )|
            8(?:
              [24][2-8]|
              3[2-5]|
              5[2-7]|
              6[2-589]|
              7[2-578]|
              [89][2-9]
            )|
            9(?:
              0[57]|
              13|
              [25-7]\\d|
              [3489][0-8]
            )
          )\\d{5}
        ',
                'mobile' => '
          1(?:
            1888[69]|
            4400|
            8(?:
              47|
              8[27]
            )[0-4]
          )\\d{4}|
          1(?:
            0(?:
              [23568]\\d|
              4[0-6]|
              7[016-9]|
              9[0-8]
            )|
            1(?:
              [1-5]\\d\\d|
              6(?:
                0[5-9]|
                [1-9]\\d
              )|
              7(?:
                [0134]\\d|
                2[1-9]|
                5[0-6]
              )
            )|
            (?:
              (?:
                [269]|
                59
              )\\d|
              [37][1-9]|
              4[235-9]
            )\\d|
            8(?:
              1[23]|
              [236]\\d|
              4[06]|
              5[7-9]|
              7[016-9]|
              8[01]|
              9[0-8]
            )
          )\\d{5}
        ',
                'pager' => '',
                'personal_number' => '',
                'specialrate' => '(1600\\d{6})',
                'toll_free' => '1[378]00\\d{6}',
                'voip' => '
          15(?:
            4(?:
              6[0-4]\\d|
              8(?:
                0[125]|
                [17]\\d|
                21|
                3[01]|
                4[01589]|
                5[014]|
                6[02]
              )
            )|
            6(?:
              32[0-6]|
              78\\d
            )
          )\\d{4}
        '
              };
my %areanames = ();
$areanames{en} = {"608978", "Semporna",
"609531", "Kuantan",
"6032180", "Kuala\ Lumpur",
"6089663", "Elopura",
"606549", "Durian\ Tunggal",
"6087225", "Beaufort",
"604453", "Kulim",
"6089864", "Lahad\ Datu",
"606512", "Jasin",
"6037610", "Kuala\ Lumpur",
"604377", "Penang",
"6033325", "Kelang",
"6033277", "Kuala\ Selangor",
"6039174", "Kuala\ Lumpur",
"6036064", "Kuala\ Kubu\ Baru",
"603209", "Kuala\ Lumpur",
"609418", "Nenasi",
"604680", "Penang",
"6034294", "Kuala\ Lumpur",
"6082286", "Kuching",
"6032191", "Kuala\ Lumpur",
"604980", "Kangar",
"605850", "Sungai\ Nyior",
"606471", "Simpang\ Durian",
"606253", "Melaka",
"6082878", "Baki",
"6083337", "Bandar\ Sri\ Aman",
"607964", "Bukit\ Gambir",
"6037718", "Kuala\ Lumpur",
"604607", "Penang",
"6086323", "Bintulu",
"6082826", "Asajaya",
"604916", "Alor\ Setar",
"609237", "Bilut\ Valley",
"6085631", "Miri",
"604673", "Penang",
"604716", "Alor\ Setar",
"607764", "Felda\ Tenggaroh",
"604616", "Penang",
"6038725", "Semenyih",
"606312", "Melaka",
"607298", "Johor\ Bahru",
"6039085", "Cheras",
"607423", "Rengit",
"6089671", "Elopura",
"6032026", "Kuala\ Lumpur",
"6089672", "Elopura",
"605427", "Tapah",
"6087885", "Kuala\ Penyu",
"605642", "Hutan\ Melintang",
"605719", "Parit\ Buntar",
"6033134", "Kelang",
"605225", "Ipoh",
"6085632", "Miri",
"606651", "Port\ Dickson",
"6089748", "Tawau",
"605293", "Tanjung\ Rambutan",
"6035102", "Kinrara",
"606240", "Melaka",
"609556", "Kuantan",
"605369", "Pusing",
"6088653", "Kotamarudu",
"6089965", "Lahad\ Datu",
"6088854", "Ranau",
"6032336", "Kuala\ Lumpur",
"6036075", "Kuala\ Kubu\ Baru",
"6035110", "Kinrara",
"606544", "Durian\ Tunggal",
"6087773", "Tambunan",
"609272", "Lanchang",
"6088333", "Kota\ Kinabalu",
"609238", "Karak",
"6085733", "Batu\ Niah",
"6035035", "Kinrara",
"606662", "Tekok\ Kemang",
"606962", "Bakri",
"604908", "Kangar",
"604838", "Penang",
"6082228", "Kuching",
"607297", "Johor\ Bahru",
"6088203", "Kota\ Kinabalu",
"6037735", "Kuala\ Lumpur",
"6035101", "Kinrara",
"6039075", "Cheras",
"6033102", "Pulau\ Ketam",
"6037931", "Kuala\ Lumpur",
"605791", "Grik",
"6085604", "Miri",
"609417", "Nenasi",
"605691", "Sitiawan",
"609356", "Raub",
"607210", "Johor\ Bahru",
"609215", "Genting",
"6039520", "Kuala\ Lumpur",
"6089798", "Tawau",
"6082860", "Kota\ Samarahan",
"605714", "Parit\ Buntar",
"6082888", "Serian",
"6036184", "Kuala\ Lumpur",
"605614", "Sitiawan",
"6033109", "Pulau\ Ketam",
"6087727", "Tenom",
"607969", "Bukit\ Gambir",
"608977", "Tawau",
"6033110", "Pulau\ Ketam",
"60974", "Kota\ Bharu",
"6083466", "Debak",
"604566", "Tasekgelugor",
"607514", "Tanjung\ Kupang",
"603300", "Kelang",
"6032088", "Kuala\ Lumpur",
"6082553", "Kuching",
"604332", "Penang",
"6087761", "Tenom",
"606736", "Mantin",
"6089984", "Tawau",
"6033101", "Pulau\ Ketam",
"604378", "Penang",
"6037932", "Kuala\ Lumpur",
"6089727", "Tawau",
"6082843", "Damai\ Beach",
"609525", "Kuantan",
"604400", "Padang\ Serai",
"606974", "Pagoh",
"607533", "Senai",
"604748", "Alor\ Setar",
"6033241", "Sekinchan",
"608241", "Kuching",
"608891", "Papar",
"6044110", "Serdang",
"6083461", "Debak",
"6082279", "Kuching",
"6082272", "Kuching",
"6084610", "Rejang",
"6087766", "Tambunan",
"609264", "Mentakab",
"605765", "Lenggong",
"607520", "Senai",
"6089518", "Beluran",
"6085758", "Marudi",
"605665", "Sitiawan",
"6083427", "Roban",
"6087341", "Keningau",
"6086294", "Bintulu",
"6087342", "Keningau",
"603894", "Cheras",
"6082271", "Kuching",
"6038011", "Kinrara",
"605720", "Parit\ Buntar",
"6083469", "Sebuyau",
"605620", "Telukintan",
"605920", "Sitiawan",
"6033242", "Sekinchan",
"609560", "Kuantan",
"605733", "Parit\ Buntar",
"6039548", "Cheras",
"6038000", "Putrajaya",
"605633", "Kampong\ Gajah",
"605537", "Tanjung\ Rambutan",
"6083564", "Engkilili",
"6035270", "Kinrara",
"607224", "Johor\ Bahru",
"6082538", "Kuching",
"6084307", "Sibu",
"6085461", "Miri",
"6032332", "Kuala\ Lumpur",
"6087405", "Labuan",
"6032202", "Kuala\ Lumpur",
"6083585", "Lubukantu",
"6038870", "Putrajaya",
"6038988", "Cheras",
"6083473", "Betong",
"6084237", "Sibu",
"6082625", "Kuching",
"6032201", "Kuala\ Lumpur",
"609854", "Chukai",
"607365", "Johor\ Bahru",
"604487", "Sungai\ Bakap",
"6032331", "Kuala\ Lumpur",
"6085462", "Miri",
"604254", "Penang",
"6034104", "Kuala\ Lumpur",
"6033270", "Batang\ Berjuntai",
"607880", "Kota\ Tinggi",
"6085200", "Limbang",
"6032021", "Kuala\ Lumpur",
"6038891", "Putrajaya",
"6084634", "Pakan",
"6082829", "Asajaya",
"607915", "Bukit\ Kepong",
"609710", "Kota\ Bharu",
"604488", "Padang\ Serai",
"6087392", "Keningau",
"609610", "Bandar\ Permaisuri",
"6089244", "Elopura",
"6082822", "Asajaya",
"6033280", "Kuala\ Selangor",
"6033292", "Kelang",
"6033344", "Kelang",
"6033268", "Kuala\ Selangor",
"6084833", "Matu",
"608842", "Kota\ Kinabalu",
"606509", "Jasin",
"6033291", "Kelang",
"604869", "Penang",
"606979", "Tangkak",
"6085636", "Miri",
"6087503", "Labuan",
"6082821", "Asajaya",
"6086391", "Bintulu",
"6087391", "Keningau",
"607302", "Johor\ Bahru",
"6032022", "Kuala\ Lumpur",
"6038892", "Putrajaya",
"6089676", "Elopura",
"609269", "Damak",
"6082867", "Kota\ Samarahan",
"609859", "Chukai",
"6084805", "Kuala\ Igan",
"606222", "Melaka",
"6088615", "Kudat",
"6082281", "Kuching",
"6038993", "Cheras",
"6038744", "Semenyih",
"604259", "Penang",
"606645", "Port\ Dickson",
"604747", "Alor\ Setar",
"607738", "Lavang\-Lavang",
"6089535", "Elopura",
"6082290", "Kuching",
"607938", "Tenang",
"6082282", "Kuching",
"6065350", "Jasin",
"609593", "Gambang",
"606459", "Serting",
"6088908", "Papar",
"605256", "Ipoh",
"609786", "Pasirputih",
"6034131", "Kuala\ Lumpur",
"609686", "Kuala\ Brang",
"604947", "Kangar",
"608465", "Sarikei",
"607788", "Kahang",
"6085613", "Miri",
"607688", "Pontian",
"6089926", "Tawau",
"6082627", "Kuching",
"609936", "Kuala\ Balah",
"604217", "Penang",
"6032603", "Kuala\ Lumpur",
"607279", "Johor\ Bahru",
"608267", "Kota\ Samarahan",
"605322", "Ipoh",
"609817", "Dungun",
"6082661", "Kota\ Samarahan",
"604415", "Sungai\ Petani",
"6036126", "Kuala\ Lumpur",
"6082662", "Kota\ Samarahan",
"6087407", "Labuan",
"6082698", "Kuching",
"6045960", "Parit\ Buntar",
"608433", "Sibu",
"6084305", "Sibu",
"6084816", "Rejang",
"604952", "Kuah",
"605209", "Ipoh",
"606729", "Seremban",
"6084235", "Sibu",
"6036193", "Kuala\ Lumpur",
"6082669", "Kota\ Samarahan",
"6088606", "Kudat",
"6034262", "Kuala\ Lumpur",
"6082506", "Kuching",
"604511", "Padang\ Serai",
"609544", "Kuantan",
"6082321", "Kuching",
"609662", "Kuala\ Brang",
"6082781", "Gedong",
"6036092", "Rawang",
"609762", "Pasir\ Putih",
"605443", "Tapah",
"6036099", "Rawang",
"6039080", "Cheras",
"6036178", "Kuala\ Lumpur",
"606490", "Rembau",
"605522", "Ipoh",
"604594", "Parit\ Buntar",
"6066920", "Linggi",
"6082329", "Serian",
"6086880", "Bakun",
"609240", "Kemayan",
"6087880", "Membakut",
"607722", "Renggam",
"607447", "Batu\ Pahat",
"6083425", "Roban",
"6082782", "Gedong",
"605388", "Bota",
"6082790", "Tebedu",
"6036091", "Rawang",
"607895", "Air\ Tawar",
"6089868", "Lahad\ Datu",
"604290", "Penang",
"607922", "Bekok",
"6082322", "Kuching",
"609951", "Machang",
"6084752", "Kanowit",
"6089537", "Elopura",
"609575", "Kuantan",
"607448", "Batu\ Pahat",
"60648", "Kuala\ Pilah",
"609835", "Dungun",
"607823", "Penawar",
"606463", "Palong",
"607900", "Tenggara",
"6036143", "Kuala\ Lumpur",
"607830", "Penggerang",
"6032084", "Kuala\ Lumpur",
"605281", "Ipoh",
"609751", "Kota\ Bharu",
"607570", "Senai",
"6038686", "Putrajaya",
"609651", "Batu\ Rakit",
"6035030", "Kinrara",
"6088617", "Kudat",
"609863", "Chukai",
"606331", "Melaka",
"605670", "Sitiawan",
"6084807", "Sibu",
"6082683", "Kuching",
"6035115", "Kinrara",
"604399", "Penang",
"6039070", "Cheras",
"609312", "Kuala\ Lipis",
"6036188", "Kuala\ Lumpur",
"607274", "Johor\ Bahru",
"606435", "Tampin",
"6084751", "Kanowit",
"604263", "Penang",
"6085719", "Bekenu",
"6038766", "Semenyih",
"6089849", "Kunak",
"6082224", "Kuching",
"605596", "Chemor",
"6082865", "Kota\ Samarahan",
"605783", "Kuala\ Kangsar",
"609471", "Sungai\ Tekam",
"605683", "Sitiawan",
"607696", "Pontian",
"607787", "Keluang",
"606531", "Jasin",
"607687", "Pontian",
"6036042", "Kampong\ Suharto",
"604961", "Kuah",
"609549", "Gambang",
"6084480", "Sibu",
"604218", "Penang",
"604599", "Parit\ Buntar",
"609818", "Kerteh",
"6082763", "Bau",
"6036049", "Kerling",
"6088858", "Ranau",
"6032857", "Kuala\ Lumpur",
"6087887", "Membakut",
"605478", "Tapah",
"606986", "Bakri",
"605432", "Trolak",
"607262", "Johor\ Bahru",
"6038769", "Semenyih",
"6082797", "Tebedu",
"605540", "Ipoh",
"606797", "Mantin",
"6085494", "Bekenu",
"6034108", "Kuala\ Lumpur",
"606697", "Linggi",
"6088931", "Kota\ Belud",
"607408", "Kampong\ Parit\ Tengah",
"6039235", "Kuala\ Lumpur",
"609222", "Bentong",
"607740", "Kahang",
"609945", "Ayer\ Lanas",
"6036087", "Rawang",
"605811", "Taiping",
"6038761", "Semenyih",
"605894", "Taiping",
"605244", "Ipoh",
"6082388", "Kuching",
"6089273", "Elopura",
"6036046", "Kampong\ Suharto",
"603620", "Kuala\ Lumpur",
"6088703", "Kinarut",
"607940", "Segamat",
"6038727", "Semenyih",
"6035622", "Kinrara",
"6038690", "Semenyih",
"609509", "Kuantan",
"609288", "Bukit\ Tinggi",
"605758", "Kuala\ Kangsar",
"608234", "Kuching",
"6094310", "Pekan",
"609979", "Machang",
"6086298", "Bintulu",
"609679", "Jerteh",
"6083568", "Engkilili",
"6083592", "Lubuk\ Antu",
"605466", "Kampar",
"609779", "Bachok",
"6033362", "Kelang",
"6039544", "Cheras",
"6038689", "Putrajaya",
"604888", "Penang",
"6035629", "Kinrara",
"6033361", "Kelang",
"6087227", "Beaufort",
"603337", "Kelang",
"6082620", "Kuching",
"6089514", "Beluran",
"606910", "Muar",
"6033275", "Batang\ Berjuntai",
"604469", "Jeniang",
"6035621", "Kinrara",
"605212", "Ipoh",
"609821", "Sri\ Gading",
"6087725", "Tenom",
"6089725", "Tawau",
"6038323", "Putrajaya",
"6088904", "Papar",
"6088307", "Kota\ Kinabalu",
"605249", "Ipoh",
"6038783", "Mantin",
"605899", "Semanggol",
"6034266", "Kuala\ Lumpur",
"6082502", "Kuching",
"607753", "Renggam",
"609846", "Kuala\ Brang",
"607861", "Tiram",
"6082326", "Kuching",
"6087823", "Sipitang",
"605757", "Kuala\ Kangsar",
"6082501", "Kuching",
"6083570", "Lingga",
"609485", "Jengka\ Lapan\ Belas",
"609454", "Bukit\ Ibam",
"6093141", "Kuala\ Lipis",
"606421", "Bahau",
"6084730", "Julau",
"6082393", "Sejingkat",
"607407", "Parit\ Sulong",
"6086283", "Bintulu",
"604923", "Changlon",
"604930", "Alor\ Setar",
"6036737", "Kuala\ Kubu\ Baru",
"6089922", "Tawau",
"6084811", "Mukah",
"606560", "Simpang\ Empat",
"604623", "Penang",
"604464", "Jeniang",
"607251", "Johor\ Bahru",
"6037480", "Kuala\ Lumpur",
"605477", "Kampar",
"6083549", "Pantu",
"6088602", "Kudat",
"606525", "Jasin",
"609974", "Machang",
"6033051", "Kelang",
"605353", "Ipoh",
"6084812", "Stapang",
"6089921", "Balung",
"609581", "Gebeng",
"6033264", "Kuala\ Selangor",
"6033348", "Kelang",
"605403", "Tapah",
"6089248", "Elopura",
"606798", "Mantin",
"609774", "Kota\ Bharu",
"6036122", "Kuala\ Lumpur",
"6088609", "Kudat",
"6082666", "Kota\ Samarahan",
"6089967", "Lahad\ Datu",
"606698", "Linggi",
"609234", "Karak",
"604704", "Pokok\ Sena",
"6084231", "Sibu",
"606292", "Melaka",
"6032182", "Kuala\ Lumpur",
"605805", "Taiping",
"6035878", "Kinrara",
"604981", "Kangar",
"6082764", "Bau",
"6084301", "Sibu",
"607767", "Mersing",
"6084239", "Sibu",
"609419", "Kuala\ Rompin",
"6085738", "Batu\ Niah",
"605763", "Lenggong",
"6084302", "Sibu",
"6092620", "Jerantut",
"6037611", "Kuala\ Lumpur",
"6082665", "Kota\ Samarahan",
"6087453", "Labuan",
"6032181", "Kuala\ Lumpur",
"6082223", "Kuching",
"6033008", "Banting",
"6084232", "Sibu",
"604283", "Penang",
"607518", "Senai",
"6089726", "Tawau",
"6036095", "Rawang",
"6034265", "Kuala\ Lumpur",
"6082684", "Kuching",
"607363", "Johor\ Bahru",
"6083467", "Sebuyau",
"606650", "Port\ Dickson",
"607299", "Johor\ Bahru",
"6087726", "Tenom",
"6089670", "Elopura",
"60782", "Penggerang",
"605367", "Pusing",
"605618", "Changkat\ Keruing",
"6085630", "Miri",
"6036144", "Kuala\ Lumpur",
"6082325", "Serian",
"609323", "Kuala\ Lipis",
"6032083", "Kuala\ Lumpur",
"605429", "Trolak",
"6038966", "Cheras",
"6032733", "Kuala\ Lumpur",
"6089668", "Elopura",
"605368", "Pusing",
"609414", "Kuala\ Rompin",
"6084755", "Kanowit",
"606226", "Melaka",
"6082287", "Damai\ Beach",
"605836", "Selama",
"605617", "Telukintan",
"605717", "Parit\ Buntar",
"6085206", "Kampung\ Pahlawan",
"609239", "Telemong",
"604709", "Alor\ Setar",
"604609", "Penang",
"609782", "Bachok",
"6033860", "Sekinchan",
"609682", "Kuala\ Brang",
"607913", "Labis",
"607506", "Senai",
"603207", "Kuala\ Lumpur",
"608821", "Kota\ Kinabalu",
"6086328", "Bintulu",
"6037713", "Kuala\ Lumpur",
"609595", "Gebeng",
"6086555", "Bintulu",
"6087760", "Tenom",
"609928", "Gua\ Musang",
"607590", "Senai",
"604545", "Sungai\ Bakap",
"605313", "Ipoh",
"6082898", "Serian",
"6032027", "Kuala\ Lumpur",
"605376", "Bota",
"6082862", "Kota\ Samarahan",
"603216", "Kuala\ Lumpur",
"606643", "Port\ Dickson",
"6085614", "Miri",
"605690", "Sitiawan",
"607968", "Gemas",
"6039521", "Kuala\ Lumpur",
"6032604", "Kuala\ Lumpur",
"607211", "Johor\ Bahru",
"608287", "Serian",
"606547", "Durian\ Tunggal",
"6039236", "Kuala\ Lumpur",
"6035888", "Kuala\ Lumpur",
"6082827", "Asajaya",
"6033297", "Kelang",
"607668", "Kulai",
"607768", "Paloh",
"6089677", "Elopura",
"605721", "Parit\ Buntar",
"605621", "Telukintan",
"608544", "Miri",
"6039231", "Kuala\ Lumpur",
"609561", "Kuantan",
"6084612", "Rejang",
"6085637", "Miri",
"6082270", "Kuching",
"604949", "Kangar",
"604612", "Penang",
"606316", "Durian\ Tunggal",
"6087340", "Keningau",
"6086284", "Bintulu",
"604401", "Kulim",
"6087508", "Labuan",
"6088801", "Tuaran",
"6086508", "Bintulu",
"605646", "Bagan\ Datoh",
"6039232", "Kuala\ Lumpur",
"604455", "Sungai\ Petani",
"604351", "Kepala\ Batas",
"6083460", "Sebuyau",
"60472", "Alor\ Setar",
"607521", "Senai",
"6083339", "Bandar\ Sri\ Aman",
"604305", "Penang",
"6089623", "Elopura",
"6085201", "Limbang",
"607734", "Ayer\ Hitam",
"6033271", "Batang\ Berjuntai",
"6035625", "Kinrara",
"606603", "Seremban",
"6032330", "Kuala\ Lumpur",
"606977", "Tangkak",
"605230", "Ipoh",
"609361", "Raub",
"6086371", "Sebauh",
"6085331", "Miri",
"6038962", "Cheras",
"609267", "Jerantut",
"6038872", "Putrajaya",
"607881", "Air\ Tawar",
"6038998", "Cheras",
"607934", "Labis",
"6038961", "Cheras",
"607425", "Parit\ Betak",
"6033279", "Batang\ Berjuntai",
"6038871", "Putrajaya",
"607227", "Johor\ Bahru",
"604551", "Tasek\ Gelugor",
"6038324", "Putrajaya",
"6085460", "Miri",
"6082403", "Kuching",
"6088903", "Papar",
"6085202", "Limbang",
"6033272", "Batang\ Berjuntai",
"609352", "Sungai\ Koyan",
"6033289", "Kuala\ Selangor",
"6089729", "Tawau",
"6086390", "Bintulu",
"607228", "Johor\ Bahru",
"609402", "Chini",
"6089513", "Beluran",
"6082505", "Kuching",
"6088353", "Kota\ Kinabalu",
"6089722", "Tawau",
"6087438", "Labuan",
"6033290", "Kelang",
"6087729", "Tenom",
"6033282", "Kuala\ Selangor",
"604868", "Penang",
"604562", "Kepala\ Batas",
"6033281", "Kuala\ Selangor",
"604744", "Alor\ Setar",
"605486", "Cameron\ Highland",
"606978", "Tangkak",
"609611", "Bandar\ Permaisuri",
"609794", "Kok\ Lanas",
"604944", "Kangar",
"6086381", "Tatau",
"606632", "Seremban",
"609268", "Damak",
"6039543", "Cheras",
"6038890", "Putrajaya",
"6032020", "Kuala\ Lumpur",
"609858", "Chukai",
"609552", "Kuantan",
"6082291", "Kuching",
"605410", "Tapah",
"604258", "Penang",
"6089274", "Elopura",
"6089925", "Tawau",
"6088704", "Kota\ Kinabalu",
"6084236", "Sibu",
"6084815", "Rejang",
"606666", "Sepang",
"6082299", "Kuching",
"609213", "Jengka\ Lapan\ Belas",
"6088605", "Kudat",
"609276", "Mentakab",
"607739", "Kluang",
"606458", "Serting",
"6082280", "Kuching",
"6036125", "Kuala\ Lumpur",
"6082292", "Kuching",
"6083545", "Pantu",
"6085493", "Sundar",
"606966", "Bakri",
"6084306", "Sibu",
"6047210", "Sungai\ Petani",
"604536", "Tasek\ Gelugor",
"607689", "Pontian",
"6087222", "Beaufort",
"607789", "Keluang",
"609547", "Kuantan",
"6089983", "Tawau",
"608421", "Sibu",
"604597", "Parit\ Buntar",
"6033322", "Kelang",
"6084806", "Kapit",
"607278", "Johor\ Bahru",
"6082844", "Damai\ Beach",
"6036148", "Kuala\ Lumpur",
"6087229", "Beaufort",
"6088616", "Kudat",
"604310", "Penang",
"6082688", "Kuching",
"6038687", "Putrajaya",
"607444", "Senggarang",
"6033321", "Kelang",
"606728", "Seremban",
"605208", "Ipoh",
"6089536", "Elopura",
"6087221", "Beaufort",
"605436", "Tapah",
"6087774", "Tambunan",
"6032856", "Kuala\ Lumpur",
"6088334", "Kota\ Kinabalu",
"6034288", "Kuala\ Lumpur",
"607266", "Johor\ Bahru",
"6032938", "Kuala\ Lumpur",
"6034260", "Kuala\ Lumpur",
"6036090", "Rawang",
"6082791", "Tebedu",
"606682", "Seremban",
"605829", "Taiping",
"606782", "Seremban",
"6039082", "Cheras",
"604397", "Penang",
"609814", "Paka",
"6088204", "Kota\ Kinabalu",
"6087881", "Kuala\ Penyu",
"604291", "Penang",
"608264", "Kuching",
"6084736", "Julau",
"604510", "Tasek\ Gelugor",
"6039081", "Cheras",
"6089675", "Elopura",
"603261", "Kuala\ Lumpur",
"6088853", "Ranau",
"6082780", "Gedong",
"605389", "Bota",
"6036081", "Batu\ Arang",
"604826", "Penang",
"6038767", "Semenyih",
"606491", "Simpang\ Durian",
"6082320", "Semantan",
"6085635", "Miri",
"6087889", "Membakut",
"6088607", "Kudat",
"6089969", "Lahad\ Datu",
"6084750", "Kanowit",
"6087872", "Weston",
"606330", "Melaka",
"605671", "Sitiawan",
"6085618", "Miri",
"6037731", "Kuala\ Lumpur",
"605771", "Grik",
"6082770", "Bau",
"607412", "Batu\ Pahat",
"6087406", "Labuan",
"6083547", "Maludam",
"605501", "Ipoh",
"6036127", "Kuala\ Lumpur",
"6035031", "Kinrara",
"6034278", "Kuala\ Lumpur",
"6089871", "Tungku",
"60450", "Tasek\ Gelugor",
"609950", "Machang",
"607755", "Renggam",
"607655", "Kulai",
"6035032", "Kinrara",
"607684", "Pontian",
"60497", "Kangar",
"607784", "Kahang",
"6086324", "Bintulu",
"6036739", "Kuala\ Kubu\ Baru",
"60477", "Alor\ Setar",
"6082894", "Serian",
"6082626", "Kuching",
"604398", "Penang",
"6037732", "Kuala\ Lumpur",
"6089927", "Tawau",
"6035039", "Kinrara",
"609750", "Kota\ Bharu",
"605280", "Ipoh",
"6087871", "Weston",
"609650", "Batu\ Rakit",
"607571", "Senai",
"6033224", "Sabak\ Bernam",
"606530", "Jasin",
"6087765", "Tambunan",
"6039173", "Kuala\ Lumpur",
"6036063", "Kuala\ Kubu\ Baru",
"604960", "Kuah",
"6034293", "Kuala\ Lumpur",
"604434", "Padang\ Serai",
"6088301", "Kota\ Kinabalu",
"606727", "Seremban",
"604660", "Penang",
"606523", "Jasin",
"6033884", "Kelang",
"6085710", "Bekenu",
"604760", "Alor\ Setar",
"6082741", "Lundu",
"606234", "Melaka",
"607475", "Sri\ Gading",
"609842", "Dungun",
"609548", "Gambang",
"6088309", "Kota\ Kinabalu",
"604625", "Penang",
"604219", "Penang",
"6087863", "Bongawan",
"6089664", "Elopura",
"604598", "Parit\ Buntar",
"604242", "Penang",
"604892", "Penang",
"609819", "Paka",
"604925", "Ayer\ Hitam",
"607277", "Johor\ Bahru",
"6088302", "Kota\ Kinabalu",
"60445", "Bedong",
"6035740", "Kinrara",
"6089863", "Lahad\ Datu",
"609470", "Bukit\ Ibam",
"6082507", "Kuching",
"6036028", "Batu\ Arang",
"6033620", "Kelang",
"609666", "Kuala\ Brang",
"608237", "Kuching",
"607741", "Felda\ Kahang\ Timur",
"609766", "Bachok",
"605479", "Tapah",
"605810", "Taiping",
"606276", "Melaka",
"6038760", "Semenyih",
"609458", "Bukit\ Ibam",
"6082275", "Kuching",
"6032303", "Kuala\ Lumpur",
"609966", "Kuala\ Krai",
"6038328", "Putrajaya",
"605526", "Ipoh",
"6078710", "Tiram",
"606552", "Simpang\ Empat",
"604413", "Sungai\ Petani",
"607409", "Parit\ Sulong",
"604476", "Kupang",
"6087828", "Kuala\ Penyu",
"607926", "Labis",
"6038994", "Cheras",
"605541", "Ipoh",
"6083465", "Debak",
"609508", "Teruntum",
"6089966", "Lahad\ Datu",
"6082667", "Kota\ Samarahan",
"605759", "Kuala\ Kangsar",
"608871", "Kinarut",
"6087402", "Labuan",
"607893", "Kota\ Tinggi",
"6035620", "Kinrara",
"6087504", "Labuan",
"609978", "Kuala\ Krai",
"606611", "Kuala\ Klawang",
"6084353", "Sibu",
"6083589", "Lubukantu",
"6086260", "Bintulu",
"606694", "Rantau",
"6082621", "Kuching",
"609778", "Bachok",
"606794", "Mantin",
"6089288", "Elopura",
"609732", "Kota\ Bharu",
"6038699", "Semenyih",
"6087409", "Labuan",
"609632", "Kuala\ Brang",
"6084633", "Selalang",
"606352", "Tangga\ Batu",
"6082622", "Kuching",
"6039076", "Cheras",
"6036736", "Batu\ Arang",
"604468", "Bedong",
"6094311", "Pekan",
"6089243", "Elopura",
"6082629", "Kuching",
"604956", "Kuah",
"6033343", "Kelang",
"6084834", "Matu",
"6035036", "Kinrara",
"6038691", "Semenyih",
"6087401", "Labuan",
"605897", "Semanggol",
"6084731", "Julau",
"6038726", "Semenyih",
"607860", "Senai",
"6032859", "Kuala\ Lumpur",
"6093140", "Kuala\ Lipis",
"606433", "Jelai",
"6036047", "Kerling",
"609380", "Jerantut",
"6039086", "Cheras",
"607481", "Kangkar\ Baru",
"604467", "Jeniang",
"6034103", "Kuala\ Lumpur",
"604524", "Tasek\ Gelugor",
"609865", "Kemasik",
"605592", "Lintang",
"605898", "Semanggol",
"6082825", "Asajaya",
"606420", "Johol",
"60733", "Johor\ Bahru",
"6085238", "Limbang",
"609703", "Kota\ Bharu",
"609820", "Paka",
"609977", "Machang",
"606465", "Ayer\ Hitam",
"609833", "Bukit\ Besi",
"6032025", "Kuala\ Lumpur",
"604220", "Penang",
"6089278", "Elopura",
"6089557", "Kinabatangan",
"609573", "Kuantan",
"6082383", "Kuching",
"6085540", "Miri",
"6083474", "Debak",
"6085717", "Bekenu",
"6088612", "Kudat",
"6086293", "Bintulu",
"609580", "Gebeng",
"6033326", "Kelang",
"6084802", "Sibu",
"604324", "Penang",
"6084809", "Sibu",
"6089920", "Tawau",
"6033393", "Kelang",
"607585", "Senai",
"6033050", "Kelang",
"6087226", "Beaufort",
"6083563", "Engkilili",
"6089531", "Elopura",
"6037481", "Kuala\ Lumpur",
"605685", "Sitiawan",
"609255", "Triang",
"6089532", "Elopura",
"609284", "Mentakab",
"6084810", "Julau",
"60787", "Kota\ Tinggi",
"605654", "Kampong\ Gajah",
"604884", "Penang",
"604931", "Changlon",
"6038778", "Mantin",
"609457", "Chini",
"6084801", "Sibu",
"6088611", "Kudat",
"6083308", "Bandar\ Sri\ Aman",
"6085474", "Miri",
"6036120", "Kuala\ Lumpur",
"6082285", "Kuching",
"606699", "Linggi",
"607250", "Johor\ Bahru",
"606799", "Mantin",
"6034009", "Kuala\ Lumpur",
"604412", "Penang",
"6033093", "Pulau\ Ketam",
"6088920", "Papar",
"606757", "Mantin",
"6089619", "Elopura",
"6035191", "Kinrara",
"6089612", "Elopura",
"605421", "Besout",
"6085286", "Lawas",
"604449", "Baling",
"6087250", "Beaufort",
"6084363", "Sibu",
"6033630", "Banting",
"604901", "Changlon",
"604984", "Kangar",
"6035524", "Kinrara",
"6036038", "Kuala\ Lumpur",
"6032223", "Kuala\ Lumpur",
"605854", "Sungai\ Nyior",
"60777", "Keluang",
"6089611", "Elopura",
"604571", "Tasek\ Gelugor",
"605885", "Taiping",
"604955", "Kuah",
"6085455", "Miri",
"60442", "Sungai\ Petani",
"6088532", "Kota\ Kinabalu",
"6035192", "Kinrara",
"605446", "Tapah",
"609231", "Karak",
"604701", "Bedong",
"604784", "Lubuk\ Merbau",
"604684", "Penang",
"6032296", "Kuala\ Lumpur",
"6036156", "Kuala\ Lumpur",
"6038750", "Semenyih",
"606353", "Tangga\ Batu",
"605525", "Ipoh",
"607760", "Keluang",
"609965", "Kuala\ Krai",
"6033191", "Banting",
"606477", "Palong",
"607660", "Kulai",
"6088395", "Kota\ Kinabalu",
"609765", "Bachok",
"607960", "Gemas",
"608829", "Kota\ Kinabalu",
"60537", "Pusing",
"605698", "Sitiawan",
"609665", "Kuala\ Brang",
"6082639", "Kuching",
"605798", "Lenggong",
"606275", "Melaka",
"6084696", "Bintangor",
"603745", "Kuala\ Lumpur",
"607925", "Labis",
"6092590", "Karak",
"60745", "Sri\ Gading",
"6089708", "Tawau",
"607598", "Senai",
"607892", "Kota\ Tinggi",
"6032848", "Kuala\ Lumpur",
"6032785", "Kuala\ Lumpur",
"6033217", "Sabak\ Bernam",
"604371", "Penang",
"604475", "Kupang",
"6033180", "Banting",
"6033192", "Banting",
"6033168", "Kelang",
"6034257", "Kuala\ Lumpur",
"6034024", "Kuala\ Lumpur",
"6088886", "Ranau",
"6052320", "Ipoh",
"607219", "Johor\ Bahru",
"609633", "Bandar\ Permaisuri",
"6087317", "Keningau",
"607586", "Senai",
"607597", "Senai",
"605859", "Taiping",
"6047455", "Alor\ Setar",
"604989", "Kangar",
"6038213", "Putrajaya",
"6032775", "Kuala\ Lumpur",
"607793", "Endau",
"6088402", "Kota\ Kinabalu",
"609602", "Bandar\ Permaisuri",
"604789", "Alor\ Setar",
"6088966", "Kota\ Belud",
"6084382", "Sibu",
"609832", "Merchang",
"6033170", "Kelang",
"609538", "Kuantan",
"6032035", "Kuala\ Lumpur",
"6032246", "Kuala\ Lumpur",
"609572", "Kuantan",
"6032110", "Kuala\ Lumpur",
"606432", "Gemencheh",
"6032109", "Kuala\ Lumpur",
"6084381", "Sibu",
"6085297", "Lawas",
"609315", "Kuala\ Lipis",
"609256", "Triang",
"6088401", "Kota\ Kinabalu",
"606540", "Durian\ Tunggal",
"6038076", "Kinrara",
"605710", "Parit\ Buntar",
"607386", "Johor\ Bahru",
"605610", "Telukintan",
"6033149", "Banting",
"6039130", "Kuala\ Lumpur",
"6089713", "Tawau",
"6058301", "Taiping",
"609866", "Kemasik",
"6086424", "Sebauh",
"6033142", "Sepang",
"6036130", "Kuala\ Lumpur",
"6033141", "Sepang",
"6088345", "Kota\ Kinabalu",
"6084687", "Sarikei",
"6082803", "Simunjan",
"606758", "Mantin",
"6089567", "Kinabatangan",
"606658", "Sepang",
"606958", "Bukit\ Gambir",
"607510", "Senai",
"6084646", "Sarikei",
"6035614", "Kinrara",
"608824", "Kota\ Kinabalu",
"606466", "Palong",
"6089521", "Telupid",
"606770", "Seremban",
"6086301", "Bintulu",
"6032270", "Kuala\ Lumpur",
"605237", "Ipoh",
"6087301", "Keningau",
"607467", "Sri\ Gading",
"609260", "Jerantut",
"6034250", "Kuala\ Lumpur",
"6084641", "Sarikei",
"603762", "Kuala\ Lumpur",
"607265", "Johor\ Bahru",
"6033187", "Banting",
"604860", "Penang",
"6065110", "Jasin",
"604404", "Mahang",
"606970", "Muar",
"6086231", "Bintulu",
"6087231", "Beaufort",
"609919", "Ayer\ Lanas",
"6088973", "Kota\ Belud",
"6086232", "Bintulu",
"6082473", "Kuching",
"607220", "Johor\ Bahru",
"6088863", "Bongawan",
"6087232", "Beaufort",
"6084642", "Sarikei",
"6083413", "Kabong",
"608541", "Miri",
"605624", "Hutan\ Melintang",
"609719", "Kota\ Bharu",
"606387", "Kuala\ Sungai\ Baru",
"6088664", "Kota\ Marudu",
"609225", "Bentong",
"6087302", "Keningau",
"608759", "Labuan",
"6085263", "Sundar",
"6032242", "Kuala\ Lumpur",
"6088962", "Papar",
"604554", "Tasek\ Gelugor",
"6088969", "Kota\ Belud",
"603806", "Kinrara",
"6038071", "Kinrara",
"6035652", "Kinrara",
"6032106", "Kuala\ Lumpur",
"6085240", "Kampung\ Pahlawan",
"6035651", "Kinrara",
"607884", "Kota\ Tinggi",
"6088784", "Tuaran",
"604250", "Penang",
"605418", "Tapah",
"606983", "Bakri",
"60676", "Seremban",
"6082650", "Kuching",
"6032241", "Kuala\ Lumpur",
"609850", "Chukai",
"6088961", "Kota\ Belud",
"6084895", "Kuala\ Igan",
"6038079", "Kinrara",
"6086257", "Bintulu",
"608247", "Sejingkat",
"6083408", "Maludam",
"605356", "Ipoh",
"6084680", "Sarikei",
"6084692", "Bintangor",
"6038082", "Kinrara",
"6035022", "Kinrara",
"6038090", "Kinrara",
"6089204", "Elopura",
"609914", "Gua\ Musang",
"604941", "Kangar",
"6089560", "Kinabatangan",
"605417", "Tapah",
"6088881", "Ranau",
"609714", "Kota\ Bharu",
"605406", "Tapah",
"604741", "Alor\ Setar",
"6089937", "Luasong",
"608248", "Kuching",
"605629", "Telukintan",
"6084699", "Bintangor",
"6089853", "Kunak",
"604926", "Ayer\ Hitam",
"6035545", "Kinrara",
"6039767", "Cheras",
"604409", "Kulim",
"6033123", "Tk\ Panglima\ Garang",
"607413", "Batu\ Pahat",
"6088889", "Ranau",
"6087853", "Kuala\ Penyu",
"6084691", "Bintangor",
"6035021", "Kinrara",
"6036137", "Kuala\ Lumpur",
"604626", "Penang",
"6038081", "Kinrara",
"6088675", "Pantai\ Pitas",
"609369", "Dong",
"6039274", "Kuala\ Lumpur",
"6089952", "Balung",
"6082314", "Kuching",
"607889", "Kota\ Tinggi",
"6089616", "Elopura",
"6085290", "Lawas",
"6085282", "Lawas",
"6084788", "Kapit",
"6084555", "Sibu",
"604893", "Penang",
"6084760", "Kanowit",
"6089959", "Lahad\ Datu",
"6086952", "Bintulu",
"6036274", "Kuala\ Lumpur",
"6036151", "Kuala\ Lumpur",
"606388", "Kuala\ Sungai\ Baru",
"608685", "Bintulu",
"6032268", "Kuala\ Lumpur",
"607468", "Sri\ Gading",
"604559", "Tasek\ Gelugor",
"6088536", "Kota\ Kinabalu",
"6033855", "Sabak\ Bernam",
"6086951", "Bintulu",
"6034815", "Kuala\ Lumpur",
"607656", "Kulai",
"6089951", "Balung",
"607756", "Renggam",
"6035123", "Kinrara",
"6033177", "Kelang",
"6032117", "Kuala\ Lumpur",
"606522", "Jasin",
"6032299", "Kuala\ Lumpur",
"6038605", "Kinrara",
"604390", "Penang",
"6083322", "Bandar\ Sri\ Aman",
"6039222", "Kuala\ Lumpur",
"6038952", "Cheras",
"609758", "Pasir\ Putih",
"6089704", "Tawau",
"605288", "Pusing",
"6038959", "Cheras",
"609958", "Batu\ Gajah",
"6086255", "Bintulu",
"609340", "Sungai\ Koyan",
"605679", "Sitiawan",
"6085662", "Miri",
"607441", "Senggarang",
"6034028", "Kuala\ Lumpur",
"6084897", "Stapang",
"609466", "Maran",
"6085450", "Miri",
"604913", "Alor\ Setar",
"6085661", "Miri",
"6037118", "Kuala\ Lumpur",
"6086486", "Balingan",
"6087486", "Labuan",
"6084828", "Daro",
"6039221", "Kuala\ Lumpur",
"607426", "Parit\ Betak",
"6038951", "Cheras",
"6032688", "Kuala\ Lumpur",
"6085627", "Miri",
"6037948", "Kuala\ Lumpur",
"6083321", "Bandar\ Sri\ Aman",
"604613", "Penang",
"603798", "Kuala\ Lumpur",
"6088513", "Kota\ Kinabalu",
"6036034", "Rawang",
"606315", "Melaka",
"609478", "Maran",
"6085790", "Miri",
"6038588", "Putrajaya",
"606494", "Kuala\ Klawang",
"606411", "Simpang\ Empat",
"6082546", "Kuching",
"6035164", "Kinrara",
"609540", "Kuantan",
"6089633", "Elopura",
"6083450", "Saratok",
"608261", "Kuching",
"6032780", "Kuala\ Lumpur",
"6098000", "Kerteh",
"604306", "Penang",
"604768", "Alor\ Setar",
"604668", "Penang",
"605645", "Bagan\ Datoh",
"604968", "Kuah",
"6037882", "Kuala\ Lumpur",
"6037890", "Kuala\ Lumpur",
"609244", "Triang",
"6033185", "Banting",
"6083436", "Saratok",
"604563", "Sungai\ Bakap",
"606620", "Port\ Dickson",
"6032770", "Kuala\ Lumpur",
"606720", "Seremban",
"6047450", "Alor\ Setar",
"6037879", "Kuala\ Lumpur",
"604667", "Penang",
"607904", "Tenang",
"6036103", "Genting",
"6039103", "Cheras",
"6085771", "Long\ Lama",
"604967", "Kuah",
"6032115", "Kuala\ Lumpur",
"606537", "Jasin",
"607781", "Paloh",
"6037872", "Kuala\ Lumpur",
"6087731", "Tenom",
"60458", "Sungai\ Bakap",
"606633", "Seremban",
"6084395", "Sibu",
"6032030", "Kuala\ Lumpur",
"606733", "Mantin",
"609353", "Raub",
"6088415", "Kota\ Kinabalu",
"6038024", "Kinrara",
"6089903", "Merotai",
"605581", "Chemor",
"609477", "Maran",
"606965", "Tangkak",
"605674", "Bruas",
"6082830", "Sebangan",
"6085779", "Long\ Lama",
"6087739", "Tenom",
"6082700", "Lundu",
"6039010", "Cheras",
"609212", "Maran",
"608862", "Kudat",
"6039765", "Cheras",
"6087476", "Labuan",
"6088363", "Kota\ Kinabalu",
"6032742", "Kuala\ Lumpur",
"609249", "Bera",
"606337", "Melaka",
"604518", "Tasekgelugor",
"6087802", "Sipitang",
"607283", "Johor\ Bahru",
"6036135", "Kuala\ Lumpur",
"6082711", "Semantan",
"60438", "Penang",
"6038526", "Mantin",
"606231", "Melaka",
"6033831", "Semenyih",
"6085740", "Mu",
"6033084", "Kelang",
"6082712", "Semantan",
"603269", "Kuala\ Lumpur",
"6037664", "Kuala\ Lumpur",
"605381", "Batugajah",
"606499", "Batu\ Kikir",
"609553", "Kuantan",
"605296", "Tanjung\ Rambutan",
"605846", "Taiping",
"605287", "Pusing",
"6085224", "Limbang",
"6087801", "Sipitang",
"6082596", "Kuching",
"6087810", "Sipitang",
"609957", "Batu\ Gajah",
"6037863", "Kuala\ Lumpur",
"605485", "Cameron\ Highland",
"6038522", "Semenyih",
"6088788", "Tuaran",
"6084229", "Sibu",
"6035590", "Kinrara",
"6032787", "Kuala\ Lumpur",
"604228", "Penang",
"6082303", "Kuching",
"6032275", "Kuala\ Lumpur",
"6035484", "Kinrara",
"6087479", "Labuan",
"6087472", "Labuan",
"608921", "Elopura",
"6087315", "Keningau",
"609443", "Bandar\ Tun\ Razak",
"6084222", "Sibu",
"6038529", "Mantin",
"609828", "Paka",
"6034255", "Kuala\ Lumpur",
"6088743", "Kinarut",
"6088397", "Kota\ Kinabalu",
"607944", "Segamat",
"6084221", "Sibu",
"6056340", "Kampong\ Gajah",
"606428", "Kuala\ Pilah",
"605890", "Semanggol",
"605240", "Ipoh",
"6082592", "Kota\ Samarahan",
"6082580", "Kota\ Samarahan",
"606293", "Melaka",
"60951", "Kuantan",
"607868", "Tiram",
"607562", "Senai",
"6038521", "Sepang",
"6082716", "Semantan",
"607744", "Ayer\ Hitam",
"605806", "Taiping",
"6083439", "Saratok",
"608223", "Kuching",
"6062710", "Sungai\ Rambai",
"6037876", "Kuala\ Lumpur",
"6085620", "Miri",
"6087213", "Beaufort",
"6088668", "Kota\ Marudu",
"6087440", "Labuan",
"609322", "Kuala\ Lipis",
"605636", "Sabak\ Bernam",
"6037260", "Kuala\ Lumpur",
"604282", "Penang",
"6089463", "Elopura",
"6089736", "Tawau",
"606691", "Linggi",
"6083343", "Bandar\ Sri\ Aman",
"606791", "Seremban",
"6039410", "Cheras",
"606614", "Kuala\ Klawang",
"607362", "Johor\ Bharu",
"6087736", "Tenom",
"6036243", "Kuala\ Lumpur",
"6087463", "Labuan",
"6089565", "Kinabatangan",
"6084879", "Dalat",
"6082542", "Sejingkat",
"6038095", "Kinrara",
"6088793", "Tuaran",
"605375", "Bota",
"6089817", "Lahatdatu",
"6088347", "Kota\ Kinabalu",
"6032264", "Kuala\ Lumpur",
"6034161", "Kuala\ Lumpur",
"605253", "Ipoh",
"609783", "Bachok",
"607912", "Aver\ Panas",
"607749", "Ayer\ Hitam",
"606850", "Mantin",
"609587", "Gebeng",
"6082549", "Kuching",
"6084872", "Mukah",
"6087750", "Tenom",
"609450", "Bukit\ Ibam",
"6038708", "Mantin",
"6082707", "Kota\ Samarahan",
"6084871", "Mukah",
"6032723", "Kuala\ Lumpur",
"605549", "Ipoh",
"607257", "Johor\ Bharu",
"6034162", "Kuala\ Lumpur",
"608486", "Dalat",
"607305", "Johor\ Bahru",
"6035540", "Kinrara",
"60447", "Baling",
"6037886", "Kuala\ Lumpur",
"6032383", "Kuala\ Lumpur",
"604521", "Tasek\ Gelugor",
"6085404", "Miri",
"609300", "Mentakab",
"607484", "Batu\ Pahat",
"6082541", "Sejingkat",
"608845", "Kota\ Kinabalu",
"6085666", "Limbang",
"606642", "Port\ Dickson",
"6088641", "Kudat",
"6085295", "Lawas",
"604460", "Bedong",
"6087481", "Labuan",
"606427", "Kuala\ Pilah",
"604881", "Penang",
"6084840", "Kuala\ Igan",
"609204", "Jerantut",
"6038956", "Serdang",
"609281", "Kuala\ Krau",
"605751", "Kuala\ Kangsar",
"607867", "Tiram",
"6039226", "Kuala\ Lumpur",
"6034802", "Kuala\ Lumpur",
"6083326", "Bandar\ Sri\ Aman",
"6084765", "Kanowit",
"605349", "Batu\ Gajah",
"6033850", "Banting",
"6089208", "Elopura",
"6034801", "Kuala\ Lumpur",
"604227", "Penang",
"609770", "Bachok",
"60465", "Penang",
"607505", "Tanjung\ Kupang",
"60475", "Lubuk\ Merbau",
"6038600", "Kinrara",
"6087490", "Labuan",
"6087482", "Labuan",
"6087208", "Beaufort",
"6032037", "Kuala\ Lumpur",
"605312", "Ipoh",
"607675", "Pontian",
"6086584", "Tatau",
"609827", "Paka",
"609970", "Machang",
"6034810", "Kuala\ Lumpur",
"606474", "Palong",
"609223", "Bentong",
"605465", "Kampar",
"604830", "Penang",
"6039225", "Kuala\ Lumpur",
"6033083", "Kelang",
"6037663", "Kuala\ Lumpur",
"6038955", "Serdang",
"604570", "Tasek\ Gelugor",
"6085223", "Limbang",
"603778", "Kuala\ Lumpur",
"6084766", "Kanowit",
"6083325", "Bandar\ Sri\ Aman",
"6033359", "Kelang",
"6085665", "Miri",
"6085296", "Lawas",
"604700", "Alor\ Setar",
"6086252", "Bintulu",
"6086251", "Bintulu",
"6032247", "Kuala\ Lumpur",
"6088364", "Kota\ Kinabalu",
"605433", "Tapah",
"6088967", "Tenghilan",
"609874", "Kemasik",
"609534", "Kuantan",
"6085785", "Marudi",
"6038023", "Kinrara",
"609721", "Kota\ Bharu",
"606654", "Port\ Dickson",
"6038752", "Semenyih",
"6087237", "Beaufort",
"6089718", "Tawau",
"6052321", "Ipoh",
"6084647", "Sarikei",
"6033181", "Banting",
"604370", "Penang",
"6089566", "Kinabatangan",
"606985", "Muar",
"605799", "Lenggong",
"6084405", "Sibu",
"608828", "Kota\ Kinabalu",
"605699", "Sitiawan",
"6086307", "Bintulu",
"6087718", "Tenom",
"607599", "Senai",
"607761", "Ayer\ Hitam",
"6036104", "Genting",
"6082808", "Simunjan",
"607661", "Kulai",
"604987", "Kangar",
"605857", "Taiping",
"609946", "Ayer\ Lanas",
"607961", "Segamat",
"604687", "Penang",
"6033190", "Banting",
"604787", "Alor\ Setar",
"6033182", "Banting",
"607218", "Johor\ Bahru",
"6038751", "Semenyih",
"6037885", "Kuala\ Lumpur",
"6036157", "Kuala\ Lumpur",
"6032297", "Kuala\ Lumpur",
"6032119", "Kuala\ Lumpur",
"6089634", "Elopura",
"6087833", "Menumbok",
"607415", "Batu\ Pahat",
"6033179", "Kelang",
"605858", "Taiping",
"6036690", "Batuarang",
"604988", "Kangar",
"604688", "Penang",
"609410", "Pekan",
"6088411", "Kota\ Kinabalu",
"6084392", "Sibu",
"609539", "Kuantan",
"6084380", "Sibu",
"606541", "Durian\ Tunggal",
"607217", "Johor\ Bahru",
"6037875", "Kuala\ Lumpur",
"6087735", "Tenom",
"606479", "Ayer\ Hitam",
"6084391", "Sibu",
"6088412", "Kota\ Kinabalu",
"6085287", "Lawas",
"6037773", "Kuala\ Lumpur",
"6089735", "Semporna",
"608827", "Kota\ Kinabalu",
"607652", "Kulai",
"607752", "Lavang\-Lavang",
"6035163", "Kinrara",
"6039132", "Kuala\ Lumpur",
"6087316", "Keningau",
"6036139", "Kuala\ Lumpur",
"6089520", "Telupid",
"6089805", "Lahad\ Datu",
"6034256", "Kuala\ Lumpur",
"607511", "Senai",
"6033216", "Sabak\ Bernam",
"6032276", "Kuala\ Lumpur",
"6039769", "Cheras",
"6039139", "Kuala\ Lumpur",
"6033140", "Banting",
"609486", "Jengka\ Tiga\ Belas",
"6036131", "Kuala\ Lumpur",
"6082715", "Semantan",
"606659", "Sepang",
"6089703", "Tawau",
"604922", "Kangar",
"606759", "Mantin",
"604722", "Kulim",
"6058300", "Taiping",
"609845", "Dungun",
"6039131", "Kuala\ Lumpur",
"605794", "Grik",
"6033163", "Kelang",
"604447", "Bedong",
"6039058", "Cheras",
"6087319", "Keningau",
"6036136", "Kuala\ Lumpur",
"604557", "Tasek\ Gelugor",
"607221", "Johor\ Bahru",
"6036433", "Genting",
"6032272", "Kuala\ Lumpur",
"6038525", "Mantin",
"6034259", "Kuala\ Lumpur",
"608432", "Sibu",
"6088552", "Telupid",
"6038800", "Putrajaya\/Cyberjaya",
"6033197", "Banting",
"605883", "Taiping",
"604953", "Kuah",
"6034252", "Kuala\ Lumpur",
"6087475", "Labuan",
"6039766", "Cheras",
"6032279", "Kuala\ Lumpur",
"6087312", "Keningau",
"6087230", "Beaufort",
"609367", "Dong",
"606771", "Seremban",
"6087311", "Keningau",
"609918", "Gua\ Musang",
"6089936", "Luasong",
"607887", "Kota\ Tinggi",
"6085270", "Lawas",
"607896", "Tenggara",
"6034251", "Kuala\ Lumpur",
"6084640", "Sarikei",
"605323", "Ipoh",
"608244", "Kuching",
"606971", "Bukit\ Kepong",
"609718", "Kota\ Bharu",
"6086300", "Bintulu",
"6032724", "Kuala\ Lumpur",
"6038913", "Semenyih",
"609635", "Kuala\ Brang",
"607930", "Labis",
"609735", "Kota\ Bharu",
"6032116", "Kuala\ Lumpur",
"608758", "Labuan",
"604251", "Penang",
"604416", "Sungai\ Petani",
"6033176", "Kelang",
"6088960", "Tenghilan",
"6085403", "Miri",
"6082651", "Kuching",
"6032240", "Kuala\ Lumpur",
"607527", "Kangkar\ Pulai",
"609851", "Chukai",
"6088537", "Kota\ Kinabalu",
"604407", "Serdang",
"6083435", "Saratok",
"6035650", "Kinrara",
"6088695", "Kudat",
"6085241", "Kampung\ Pahlawan",
"6084671", "Sarikei",
"607923", "Bukit\ Kepong",
"6038070", "Kinrara",
"6085242", "Limbang",
"609567", "Kuantan",
"605419", "Tapah",
"609663", "Batu\ Rakit",
"6082659", "Kota\ Samarahan",
"6032263", "Kuala\ Lumpur",
"605530", "Tanjung\ Rambutan",
"6088794", "Tuaran",
"6088943", "Kota\ Belud",
"6089617", "Elopura",
"606384", "Tangga\ Batu",
"605727", "Parit\ Buntar",
"6038092", "Kinrara",
"6089464", "Elopura",
"6038080", "Kinrara",
"605595", "Chemor",
"6035020", "Kinrara",
"609862", "Chukai",
"6039368", "Kuala\ Lumpur",
"609568", "Kuantan",
"6084690", "Bintangor",
"6084682", "Sarikei",
"6083344", "Bandar\ Sri\ Aman",
"6089562", "Kinabatangan",
"607382", "Johor\ Bahru",
"6082545", "Kuching",
"6089569", "Kinabatangan",
"6084875", "Mukah",
"6058307", "Selama",
"6084689", "Bintangor",
"6087464", "Labuan",
"604262", "Penang",
"605728", "Parit\ Buntar",
"6083418", "Bandar\ Sri\ Aman",
"604358", "Tasek\ Gelugor",
"604940", "Kangar",
"607822", "Penawar",
"607528", "Kangkar\ Pulai",
"6088880", "Ranau",
"604740", "Alor\ Setar",
"6087214", "Beaufort",
"606462", "Palong",
"607795", "Felda\ Tenggaroh",
"6089561", "Kinabatangan",
"604408", "Kulim",
"6038091", "Kinrara",
"6084773", "Song",
"6084681", "Sarikei",
"609368", "Raub",
"6086256", "Bintulu",
"609706", "Kota\ Bharu",
"6082493", "Kuching",
"609606", "Tenang",
"6088744", "Kinarut",
"605395", "Besout",
"6085280", "Lawas",
"6085268", "Sundar",
"6089950", "Balung",
"6084762", "Kanowit",
"6085299", "Lawas",
"6084798", "Kapit",
"6032107", "Kuala\ Lumpur",
"604852", "Penang",
"604558", "Tasek\ Gelugor",
"607469", "Sri\ Gading",
"60449", "Kulim",
"6036150", "Kuala\ Lumpur",
"6082304", "Kota\ Samarahan",
"6035483", "Kinrara",
"606436", "Johol",
"605782", "Kuala\ Kangsar",
"609252", "Triang",
"6087485", "Labuan",
"605682", "Changkat\ Keruing",
"6086485", "Belaga",
"606497", "Rembau",
"6083320", "Bandar\ Sri\ Aman",
"6036108", "Genting",
"6082804", "Simunjan",
"606486", "Simpang\ Durian",
"6038950", "Cheras",
"605289", "Pusing",
"609759", "Pasirputih",
"609659", "Batu\ Rakit",
"609959", "Batu\ Gajah",
"6035613", "Kinrara",
"605732", "Parit\ Buntar",
"606295", "Melaka",
"605632", "Kampong\ Gajah",
"6089615", "Elopura",
"6085660", "Miri",
"605678", "Bruas",
"607838", "Penawar",
"604391", "Penang",
"607532", "Senai",
"607908", "Bekok",
"609445", "Bandar\ Tun\ Razak",
"6034816", "Kuala\ Lumpur",
"6085452", "Miri",
"607578", "Senai",
"6089714", "Tawau",
"6086423", "Sebauh",
"609247", "Bera",
"607708", "Keluang",
"6033856", "Sabak\ Bernam",
"604314", "Penang",
"6083437", "Saratok",
"607440", "Batu\ Pahat",
"6035195", "Kinrara",
"6088535", "Kota\ Kinabalu",
"6088368", "Kota\ Kinabalu",
"6085768", "Marudi",
"6085792", "Mulu",
"605766", "Lenggong",
"6082597", "Kuching",
"609479", "Maran",
"6098001", "Kerteh",
"6032781", "Kuala\ Lumpur",
"604210", "Penang",
"6032782", "Kuala\ Lumpur",
"608564", "Miri",
"6038527", "Mantin",
"60779", "Mersing",
"604669", "Penang",
"608742", "Labuan",
"604769", "Alor\ Setar",
"60769", "Air\ Baloi",
"6037880", "Kuala\ Lumpur",
"6087477", "Labuan",
"6085791", "Miri",
"604969", "Kuah",
"608225", "Kuching",
"606410", "Tampin",
"6082734", "Lundu",
"6084375", "Sibu",
"609541", "Sungai\ Lembing",
"6047452", "Alor\ Setar",
"607271", "Johor\ Bahru",
"608843", "Kota\ Kinabalu",
"6032772", "Kuala\ Lumpur",
"6032039", "Kuala\ Lumpur",
"6088405", "Kota\ Kinabalu",
"6085626", "Miri",
"606646", "Port\ Dickson",
"6082831", "Sebangan",
"6037870", "Kuala\ Lumpur",
"6034023", "Kuala\ Lumpur",
"607303", "Johor\ Bahru",
"6032032", "Kuala\ Lumpur",
"606334", "Melaka",
"609754", "Bachok",
"6084896", "Stapang",
"605201", "Chemor",
"6032031", "Kuala\ Lumpur",
"6087730", "Tenom",
"609685", "Kuala\ Brang",
"6085770", "Long\ Lama",
"609785", "Pasirputih",
"605255", "Ipoh",
"607980", "Bakri",
"607680", "Pontian",
"607780", "Kahang",
"6047451", "Alor\ Setar",
"6032771", "Kuala\ Lumpur",
"609954", "Machang",
"6084823", "Daro",
"6089730", "Tawau",
"607907", "Labis",
"605380", "Pusing",
"6039012", "Cheras",
"6099560", "Batu\ Gajah",
"604764", "Alor\ Setar",
"6035523", "Kinrara",
"6032224", "Kuala\ Lumpur",
"6088518", "Kota\ Kinabalu",
"6033258", "Kelang",
"604298", "Penang",
"6087811", "Sipitang",
"6033145", "Banting",
"609592", "Kuantan",
"609248", "Bera",
"6088341", "Kota\ Kinabalu",
"606534", "Jasin",
"608991", "Tawau",
"607707", "Keluang",
"6082709", "Kota\ Samarahan",
"607916", "Bekok",
"6039019", "Cheras",
"604964", "Kuah",
"605820", "Taiping",
"606498", "Batu\ Kikir",
"609474", "Kota\ Gelangi",
"6082547", "Kuching",
"6085742", "Beluru",
"60655", "Durian\ Tunggal",
"605507", "Ipoh",
"6088342", "Kota\ Kinabalu",
"6088349", "Kota\ Kinabalu",
"6087812", "Sipitang",
"6084877", "Mukah",
"6039011", "Cheras",
"6084364", "Sibu",
"6082701", "Lundu",
"605677", "Bruas",
"606230", "Melaka",
"604615", "Penang",
"604229", "Penang",
"6035568", "Kinrara",
"6088798", "Tuaran",
"6038520", "Kinrara",
"605241", "Ipoh",
"605891", "Taiping",
"6082581", "Kota\ Samarahan",
"6035124", "Kinrara",
"6037887", "Kuala\ Lumpur",
"60644", "Tampin",
"609829", "Paka",
"607488", "Batu\ Pahat",
"6084220", "Sibu",
"606252", "Melaka",
"604915", "Changlon",
"6032388", "Kuala\ Lumpur",
"6084645", "Sarikei",
"605226", "Ipoh",
"6082582", "Kota\ Samarahan",
"6082590", "Kuching",
"606429", "Bahau",
"60929", "Mentakab",
"6038703", "Mantin",
"6082313", "Kuching",
"6088346", "Kota\ Kinabalu",
"6036273", "Kuala\ Lumpur",
"608877", "Kinarut",
"607869", "Senai",
"608733", "Keningau",
"608633", "Bintulu",
"606906", "Muar",
"6035591", "Kinrara",
"606617", "Kuala\ Klawang",
"6032245", "Kuala\ Lumpur",
"605547", "Ipoh",
"6089854", "Kunak",
"6084891", "Selangau",
"6086449", "Pelagus",
"6032036", "Kuala\ Lumpur",
"605743", "Manong",
"605643", "Hutan\ Melintang",
"606790", "Mantin",
"607259", "Johor\ Bahru",
"6036411", "Kuala\ Lumpur",
"60741", "Parit\ Sulong",
"6039411", "Cheras",
"6085622", "Miri",
"6033124", "Tk\ Panglima\ Garang",
"6088690", "Kota\ Marudu",
"6083430", "Saratok",
"6087442", "Labuan",
"6047456", "Alor\ Setar",
"6036262", "Kuala\ Lumpur",
"6087854", "Bongawan",
"6032776", "Kuala\ Lumpur",
"6037261", "Kuala\ Lumpur",
"6083327", "Bandar\ Sri\ Aman",
"6087441", "Labuan",
"6036261", "Kuala\ Lumpur",
"6039514", "Kuala\ Lumpur",
"604938", "Kangar",
"6036419", "Kuala\ Lumpur",
"6039054", "Cheras",
"6085621", "Miri",
"6038957", "Cheras",
"6089203", "Elopura",
"6038075", "Kinrara",
"604672", "Penang",
"607747", "Ayer\ Hitam",
"6036412", "Kuala\ Lumpur",
"6084892", "Selangau",
"609208", "Sungai\ Tekam",
"6084880", "Daro",
"6085667", "Miri",
"607422", "Kampung\ Parit\ Tengah",
"6082308", "Kuching",
"609451", "Bandar\ Tun\ Razak",
"606424", "Batu\ Kikir",
"6084695", "Bintangor",
"606663", "Tekok\ Kemang",
"609405", "Pekan",
"6088783", "Tuaran",
"6082850", "Serian",
"6088671", "Kudat",
"609301", "Jerantut",
"607748", "Keluang",
"603928", "Kuala\ Lumpur",
"606963", "Tangkak",
"6035541", "Kinrara",
"60668", "Rembau",
"607400", "Rengit",
"6088396", "Kota\ Kinabalu",
"6084870", "Mukah",
"609355", "Raub",
"605292", "Tanjung\ Rambutan",
"605548", "Ipoh",
"6088885", "Ranau",
"6085264", "Sundar",
"604224", "Penang",
"6032393", "Kuala\ Lumpur",
"6035542", "Kinrara",
"6035549", "Kinrara",
"609824", "Kerteh",
"606851", "Seremban",
"605470", "Kampar",
"6032786", "Kuala\ Lumpur",
"604565", "Kepala\ Batas",
"6034811", "Kuala\ Lumpur",
"6087737", "Tenom",
"6085285", "Lawas",
"6082474", "Kuching",
"609771", "Kota\ Bharu",
"604320", "Penang",
"6083414", "Kabong",
"6033318", "Kelang",
"6038601", "Kinrara",
"604333", "Penang",
"6089491", "Beluran",
"609584", "Gebeng",
"603414", "Kuala\ Lumpur",
"6088663", "Kotamarudu",
"6049373", "Kangar",
"609555", "Kuantan",
"60723", "Johor\ Bahru",
"608832", "Kota\ Kinabalu",
"6087218", "Beaufort",
"6034800", "Kuala\ Lumpur",
"6033851", "Banting",
"6083348", "Bandar\ Sri\ Aman",
"6033852", "Banting",
"605348", "Batu\ Gajah",
"607254", "Johor\ Bahru",
"6034819", "Kuala\ Lumpur",
"604461", "Bedong",
"6038609", "Kinrara",
"6032295", "Kuala\ Lumpur",
"6089492", "Beluran",
"609280", "Lanchang",
"6086480", "Balingan",
"6087468", "Labuan",
"605750", "Kuala\ Kangsar",
"6087480", "Labuan",
"6037877", "Kuala\ Lumpur",
"6086468", "Belaga",
"6038602", "Kinrara",
"6034812", "Kuala\ Lumpur",
"6085456", "Miri",
"604369", "Serdang",
"6085496", "Ladang\ Tiga",
"6084303", "Sibu",
"607678", "Pontian",
"6087452", "Labuan",
"604293", "Penang",
"6039195", "Kuala\ Lumpur",
"607289", "Johor\ Bahru",
"6036195", "Kuala\ Lumpur",
"6087459", "Labuan",
"6082222", "Kuching",
"607508", "Tanjung\ Kupang",
"609243", "Triang",
"6033868", "Batang\ Berjuntai",
"6083477", "Betong",
"609559", "Kuantan",
"606493", "Kuala\ Klawang",
"6032605", "Kuala\ Lumpur",
"6036044", "Kampong\ Suharto",
"605440", "Tapah",
"605608", "Teluk\ Intan",
"603263", "Kuala\ Lumpur",
"606228", "Melaka",
"6085615", "Miri",
"6082221", "Kuching",
"6089660", "Elopura",
"605872", "Semanggol",
"6087451", "Labuan",
"6082536", "Kuching",
"605838", "Selama",
"608542", "Miri",
"608848", "Kota\ Kinabalu",
"6039546", "Cheras",
"6084754", "Kanowit",
"6083496", "Lingga",
"604569", "Kepala\ Batas",
"6032089", "Kuala\ Lumpur",
"604914", "Alor\ Setar",
"607666", "Kulai",
"6087437", "Labuan",
"604614", "Penang",
"607766", "Mersing",
"604714", "Alor\ Setar",
"6035880", "Kinrara",
"6032082", "Kuala\ Lumpur",
"6035892", "Kinrara",
"6032081", "Kuala\ Lumpur",
"6088356", "Kota\ Kinabalu",
"6087768", "Tambunan",
"6035891", "Kinrara",
"6082889", "Serian",
"6086320", "Bintulu",
"6085756", "Marudi",
"6098710", "Cheneh",
"6082890", "Serian",
"6082882", "Serian",
"6089792", "Semporna",
"609726", "Kota\ Bharu",
"6082685", "Kuching",
"6034264", "Kuala\ Lumpur",
"609585", "Gebeng",
"6087770", "Tambunan",
"6077690", "Paloh",
"6088330", "Kota\ Kinabalu",
"6036094", "Rawang",
"606521", "Jasin",
"6088469", "Kota\ Kinabalu",
"6088906", "Papar",
"6034051", "Kuala\ Lumpur",
"603217", "Kuala\ Lumpur",
"6032731", "Kuala\ Lumpur",
"6032732", "Kuala\ Lumpur",
"608847", "Kota\ Kinabalu",
"6039145", "Kuala\ Lumpur",
"606546", "Durian\ Tunggal",
"605680", "Sitiawan",
"6082871", "Baki",
"609250", "Triang",
"607255", "Johor\ Bahru",
"604850", "Penang",
"6036145", "Kuala\ Lumpur",
"6082324", "Asajaya",
"6089894", "Kunak",
"606227", "Melaka",
"6089749", "Tawau",
"607865", "Tiram",
"604260", "Penang",
"6082550", "Kuching",
"609860", "Chukai",
"6082765", "Bau",
"60695", "Muar",
"606425", "Tampin",
"605837", "Selama",
"605616", "Bruas",
"607380", "Johor\ Bahru",
"6037711", "Kuala\ Lumpur",
"6085638", "Miri",
"609404", "Pekan",
"605716", "Parit\ Buntar",
"605673", "Bruas",
"609481", "Kota\ Gelangi",
"6082840", "Damai\ Beach",
"609825", "Kerteh",
"6034285", "Kuala\ Lumpur",
"6082664", "Kota\ Samarahan",
"6037712", "Kuala\ Lumpur",
"606460", "Bahau",
"6032935", "Kuala\ Lumpur",
"604919", "Alor\ Setar",
"607677", "Pontian",
"604427", "Kulim",
"6087507", "Labuan",
"607516", "Tanjung\ Kupang",
"6086507", "Bintulu",
"604564", "Kepala\ Batas",
"607507", "Tanjung\ Kupang",
"606634", "Seremban",
"604619", "Penang",
"6082863", "Kota\ Samarahan",
"6037719", "Kuala\ Lumpur",
"604719", "Sungai\ Petani",
"605488", "Tanjung\ Malim",
"606976", "Bukit\ Gambir",
"604866", "Penang",
"6036303", "Genting",
"6089746", "Tawau",
"6086327", "Bintulu",
"609266", "Jerantut",
"606517", "Jasin",
"607891", "Kota\ Tinggi",
"6032028", "Kuala\ Lumpur",
"608873", "Kinarut",
"607241", "Johor\ Bahru",
"6089275", "Elopura",
"6088705", "Kota\ Kinabalu",
"606613", "Kuala\ Klawang",
"606776", "Seremban",
"606390", "Tangga\ Batu",
"608224", "Kuching",
"6033269", "Kuala\ Selangor",
"604515", "Tasekgelugor",
"6038861", "Putrajaya",
"608565", "Miri",
"6084613", "Selalang",
"607226", "Johor\ Bahru",
"6082828", "Asajaya",
"6085470", "Miri",
"6035887", "Kinrara",
"6036124", "Kuala\ Lumpur",
"606294", "Melaka",
"609278", "Mentakab",
"607943", "Tenang",
"6088909", "Papar",
"604702", "Alor\ Setar",
"609232", "Karak",
"6089667", "Elopura",
"606968", "Pagoh",
"607743", "Keluang",
"6082402", "Kuching",
"6088902", "Papar",
"609789", "Pasir\ Putih",
"6039205", "Kuala\ Lumpur",
"606317", "Melaka",
"604538", "Tasek\ Gelugor",
"6038775", "Mantin",
"6033273", "Batang\ Berjuntai",
"6082288", "Kuching",
"604572", "Tasek\ Gelugor",
"6082260", "Kuching",
"6082504", "Kuching",
"605543", "Ipoh",
"6089622", "Elopura",
"6082401", "Kuching",
"609856", "Chukai",
"6048640", "Penang",
"6083470", "Betong",
"6038873", "Putrajaya",
"6038963", "Cheras",
"6035624", "Kinrara",
"6039549", "Cheras",
"6038684", "Putrajaya",
"6088351", "Kota\ Kinabalu",
"6089511", "Beluran",
"6034770", "Kuala\ Lumpur",
"605648", "Hutan\ Melintang",
"6037859", "Kuala\ Lumpur",
"604765", "Alor\ Setar",
"6083480", "Betong",
"605350", "Batu\ Gajah",
"6083468", "Sebuyau",
"6089796", "Merotai",
"604620", "Penang",
"604933", "Kuah",
"609277", "Mentakab",
"6085759", "Marudi",
"6082886", "Serian",
"606667", "Sepang",
"6089519", "Beluran",
"6089512", "Beluran",
"606967", "Bakri",
"604537", "Tasek\ Gelugor",
"609475", "Maran",
"606318", "Melaka",
"6033283", "Kuala\ Selangor",
"6082278", "Kuching",
"6088352", "Kota\ Kinabalu",
"6084830", "Matu",
"603795", "Kuala\ Lumpur",
"6039025", "Kuala\ Lumpur",
"604920", "Kangar",
"6038325", "Putrajaya",
"609412", "Kuala\ Rompin",
"603888", "Putrajaya",
"604499", "Baling",
"6088657", "Kotamarudu",
"606335", "Melaka",
"6082226", "Kuching",
"606431", "Gemencheh",
"6082531", "Kuching",
"6082293", "Kuching",
"607483", "Batu\ Pahat",
"6085492", "Bekenu",
"6087777", "Tambunan",
"605487", "Cameron\ Highland",
"6085491", "Miri",
"609831", "Paka",
"6085737", "Batu\ Niah",
"6086285", "Bintulu",
"60942", "Pekan",
"609955", "Machang",
"6082532", "Kuching",
"607750", "Lavang\-Lavang",
"609571", "Kuantan",
"607650", "Layang\-Layang",
"6038989", "Cheras",
"609755", "Kota\ Bharu",
"607950", "Aver\ Panas",
"6084719", "Pakan",
"605285", "Ipoh",
"6038990", "Cheras",
"6082539", "Kuching",
"6033007", "Kuala\ Selangor",
"6089285", "Elopura",
"6033385", "Kelang",
"6088207", "Kota\ Kinabalu",
"609684", "Bukit\ Bading",
"609784", "Pasirputih",
"605254", "Ipoh",
"609701", "Kota\ Bharu",
"609460", "Maran",
"6036189", "Kuala\ Lumpur",
"608988", "Lahad\ Datu",
"6036420", "Rawang",
"607361", "Johor\ Bharu",
"607267", "Johor\ Bahru",
"605437", "Tapah",
"6089981", "Tawau",
"6034270", "Kuala\ Lumpur",
"609634", "Bandar\ Permaisuri",
"6033885", "Kelang",
"604281", "Penang",
"606792", "Sepang",
"6085609", "Miri",
"6087223", "Beaufort",
"6036181", "Kuala\ Lumpur",
"6089665", "Elopura",
"606385", "Tangga\ Batu",
"6083566", "Pantu",
"6089296", "Elopura",
"6085610", "Miri",
"607420", "Senggarang",
"606354", "Tangga\ Batu",
"6033396", "Kelang",
"6032600", "Kuala\ Lumpur",
"609321", "Kuala\ Lipis",
"604500", "Kulim",
"6089982", "Tawau",
"6033323", "Kelang",
"604827", "Penang",
"6086296", "Bintulu",
"6085601", "Miri",
"6038777", "Mantin",
"6039207", "Kuala\ Lumpur",
"609546", "Gambang",
"607561", "Senai",
"6038051", "Kinrara",
"6087883", "Kuala\ Penyu",
"607699", "Pontian",
"6036048", "Kerling",
"605853", "Sungai\ Nyior",
"604683", "Penang",
"6082793", "Tebedu",
"6088852", "Ranau",
"6035885", "Kinrara",
"604783", "Lubuk\ Merbau",
"6047931", "Pokok\ Sena",
"608245", "Kuching",
"6086325", "Bintulu",
"6087848", "Sipitang",
"608922", "Elopura",
"609521", "Kuantan",
"6034106", "Kuala\ Lumpur",
"6088851", "Ranau",
"606554", "Tampin",
"6085718", "Bekenu",
"6033225", "Sabak\ Bernam",
"605661", "Ipoh",
"6038723", "Semenyih",
"605599", "Chemor",
"6038052", "Kinrara",
"6082895", "Serian",
"6089277", "Elopura",
"6089848", "Kunak",
"6033346", "Kelang",
"6085735", "Batu\ Niah",
"6035033", "Kinrara",
"6087775", "Tambunan",
"6034820", "Kuala\ Lumpur",
"6082668", "Kota\ Samarahan",
"603271", "Kuala\ Lumpur",
"6036073", "Kuala\ Kubu\ Baru",
"6089246", "Elopura",
"605311", "Ipoh",
"6037733", "Kuala\ Lumpur",
"6088205", "Kota\ Kinabalu",
"6082699", "Kuching",
"605415", "Tapah",
"608823", "Kota\ Kinabalu",
"606726", "Seremban",
"6089287", "Elopura",
"609282", "Lanchang",
"605752", "Kuala\ Kangsar",
"6089674", "Elopura",
"6037910", "Kuala\ Lumpur",
"6039140", "Kuala\ Lumpur",
"6033132", "Tk\ Panglima\ Garang",
"6036140", "Kuala\ Lumpur",
"606641", "Port\ Dickson",
"609639", "Kuala\ Brang",
"603780", "Kuala\ Lumpur",
"607276", "Johor\ Bahru",
"609228", "Bilut\ Valley",
"6087862", "Bongawan",
"603673", "Kuala\ Lumpur",
"6035131", "Kinrara",
"6089869", "Lahad\ Datu",
"6082845", "Damai\ Beach",
"6088303", "Kota\ Kinabalu",
"605594", "Chemor",
"6089862", "Lahad\ Datu",
"6034291", "Kuala\ Lumpur",
"6082328", "Serian",
"6039171", "Kuala\ Lumpur",
"6082760", "Bau",
"604522", "Tasek\ Gelugor",
"6036061", "Kuala\ Kubu\ Baru",
"604828", "Penang",
"6038787", "Mantin",
"6082555", "Kuching",
"6036179", "Kuala\ Lumpur",
"6039172", "Kuala\ Lumpur",
"607911", "Aver\ Panas",
"607794", "Endau",
"605438", "Tapah",
"6089861", "Lahad\ Datu",
"607268", "Johor\ Bahru",
"6034292", "Kuala\ Lumpur",
"6034280", "Kuala\ Lumpur",
"6087861", "Bongawan",
"6034299", "Kuala\ Lumpur",
"605840", "Taiping",
"605290", "Tanjung\ Rambutan",
"607711", "Keluang",
"6039179", "Kuala\ Lumpur",
"606984", "Bukit\ Gambir",
"606901", "Muar",
"609363", "Fraser\ Hill",
"6032301", "Kuala\ Lumpur",
"607883", "Kota\ Tinggi",
"6038749", "Semenyih",
"609849", "Dungun",
"6089866", "Lahad\ Datu",
"606655", "Port\ Dickson",
"604899", "Penang",
"606701", "Linggi",
"606601", "Seremban",
"604757", "Alor\ Setar",
"6038741", "Semenyih",
"6034296", "Kuala\ Lumpur",
"6082284", "Kuching",
"6085475", "Miri",
"605246", "Ipoh",
"6032302", "Kuala\ Lumpur",
"6036066", "Kuala\ Kubu\ Baru",
"6037200", "Kuala\ Lumpur",
"6085617", "Miri",
"606277", "Melaka",
"6033349", "Kelang",
"6084632", "Selalang",
"6084818", "Daro",
"6088608", "Kudat",
"609667", "Kuala\ Brang",
"6036462", "Kerling",
"609767", "Bachok",
"608236", "Kuching",
"606475", "Ayer\ Hitam",
"6089242", "Elopura",
"605527", "Ipoh",
"6083548", "Maludam",
"6084351", "Miri",
"6083300", "Bandar\ Sri\ Aman",
"6082824", "Asajaya",
"6036128", "Kuala\ Lumpur",
"6036211", "Kuala\ Lumpur",
"6039200", "Kuala\ Lumpur",
"605623", "Telukintan",
"6033342", "Kelang",
"605930", "Sitiawan",
"605723", "Parit\ Buntar",
"6087403", "Labuan",
"6033341", "Kelang",
"607442", "Senggarang",
"6089241", "Elopura",
"608852", "Kota\ Kinabalu",
"607523", "Senai",
"6088830", "Tuaran",
"6084352", "Sibu",
"6037650", "Kuala\ Lumpur",
"6036461", "Kerling",
"604403", "Kulim",
"607530", "Senai",
"6083475", "Debak",
"6032024", "Kuala\ Lumpur",
"6038894", "Putrajaya",
"6084631", "Selalang",
"607927", "Tenang",
"6039212", "Kuala\ Lumpur",
"6087505", "Labuan",
"6082389", "Kuching",
"609590", "Kuantan",
"604432", "Kulim",
"6087820", "Sipitang",
"606856", "Mantin",
"6034287", "Kuala\ Lumpur",
"6088938", "Kota\ Belud",
"6034101", "Kuala\ Lumpur",
"6083485", "Betong",
"607595", "Senai",
"6089505", "Beluran",
"604540", "Tasek\ Gelugor",
"607928", "Aver\ Panas",
"6082382", "Kuching",
"606278", "Melaka",
"604811", "Penang",
"609844", "Dungun",
"6082381", "Kuching",
"609294", "Kuala\ Krau",
"605795", "Grik",
"609668", "Batu\ Rakit",
"606232", "Melaka",
"606989", "Bakri",
"6036020", "Batu\ Arang",
"609768", "Bachok",
"6038320", "Putrajaya",
"605528", "Ipoh",
"6034102", "Kuala\ Lumpur",
"6038780", "Mantin",
"609456", "Chini",
"6038768", "Semenyih",
"6036186", "Kuala\ Lumpur",
"6089533", "Elopura",
"608251", "Kuching",
"604758", "Alor\ Setar",
"604958", "Kuah",
"6082274", "Kuching",
"6085485", "Kampung\ Bakam",
"605888", "Taiping",
"607414", "Rengit",
"6092870", "Kuala\ Krau",
"604466", "Bedong",
"6086291", "Bintulu",
"609976", "Machang",
"6095071", "Kuantan",
"607782", "Paloh",
"6088613", "Kudat",
"6086292", "Bintulu",
"609913", "Gua\ Musang",
"6087344", "Keningau",
"6083569", "Engkilili",
"607682", "Air\ Baloi",
"6089986", "Tawau",
"6038688", "Putrajaya",
"6084803", "Sibu",
"6082687", "Kuching",
"6035628", "Kinrara",
"6038660", "Mantin",
"605328", "Ipoh",
"6083464", "Debak",
"606266", "Sungai\ Rambai",
"6033392", "Kelang",
"6089280", "Elopura",
"6083562", "Roban",
"605469", "Kampar",
"609776", "Bachok",
"6038995", "Cheras",
"609713", "Kota\ Bharu",
"607679", "Pontian",
"604917", "Alor\ Setar",
"604368", "Kepala\ Batas",
"609236", "Bilut\ Valley",
"605441", "Trolak",
"6085605", "Miri",
"6057180", "Parit\ Buntar",
"6087450", "Labuan",
"604513", "Padang\ Serai",
"6036185", "Kuala\ Lumpur",
"607288", "Johor\ Bahru",
"6082220", "Kuching",
"607509", "Senai",
"604717", "Pokok\ Sena",
"604906", "Changlon",
"605609", "Teluk\ Intan",
"606615", "Kuala\ Klawang",
"606229", "Melaka",
"609558", "Kuantan",
"609852", "Chukai",
"6038996", "Cheras",
"608875", "Kinarut",
"6032193", "Kuala\ Lumpur",
"6038408", "Cheras",
"6089669", "Elopura",
"6088304", "Kota\ Kinabalu",
"60444", "Sungai\ Petani",
"6089985", "Tawau",
"604252", "Penang",
"605839", "Selama",
"604568", "Sungai\ Bakap",
"6035889", "Kinrara",
"6087874", "Weston",
"6089673", "Elopura",
"608849", "Kota\ Kinabalu",
"606972", "Bukit\ Gambir",
"6089506", "Beluran",
"6086506", "Bintulu",
"6098700", "Kemasik",
"604376", "Penang",
"6085633", "Miri",
"6086321", "Bintulu",
"6087506", "Labuan",
"604313", "Penang",
"606638", "Kuala\ Pilah",
"6035882", "Kinrara",
"6032080", "Kuala\ Lumpur",
"605545", "Ipoh",
"609358", "Raub",
"6087782", "Tambunan",
"603892", "Semenyih",
"604790", "Pokok\ Sena",
"6082899", "Serian",
"6086322", "Bintulu",
"607745", "Renggam",
"605379", "Batu\ Gajah",
"607222", "Johor\ Bahru",
"603625", "Kuala\ Lumpur",
"609408", "Kuala\ Rompin",
"6037734", "Kuala\ Lumpur",
"6082868", "Kota\ Samarahan",
"607945", "Tenang",
"6039074", "Cheras",
"6089790", "Merotai",
"608431", "Sibu",
"6087772", "Tambunan",
"6084850", "Dalat",
"6088332", "Kota\ Kinabalu",
"609205", "Jerantut",
"605681", "Sitiawan",
"609473", "Bukit\ Ibam",
"606224", "Melaka",
"6082537", "Kuching",
"6036084", "Batu\ Arang",
"6084717", "Pakan",
"6084308", "Sibu",
"6037831", "Kuala\ Lumpur",
"605834", "Taiping",
"6084238", "Sibu",
"6085739", "Batu\ Niah",
"6038724", "Semenyih",
"6035103", "Kinrara",
"6087884", "Kuala\ Penyu",
"6088201", "Kota\ Kinabalu",
"6035879", "Kinrara",
"6032730", "Kuala\ Lumpur",
"6037839", "Kuala\ Lumpur",
"608976", "Tawau",
"6088652", "Kotamarudu",
"607674", "Pontian",
"6034050", "Kuala\ Lumpur",
"604963", "Kuah",
"6033010", "Pulau\ Ketam",
"60478", "Pokok\ Sena",
"606533", "Jasin",
"6037832", "Kuala\ Lumpur",
"6088331", "Kota\ Kinabalu",
"6087771", "Tambunan",
"606637", "Seremban",
"607504", "Tanjung\ Kupang",
"6033135", "Kelang",
"606737", "Mantin",
"6087224", "Beaufort",
"606461", "Ladanggeddes",
"609557", "Kuantan",
"609653", "Batu\ Rakit",
"609753", "Bachok",
"6089517", "Beluran",
"6032800", "Kuala\ Lumpur",
"6033324", "Kelang",
"60743", "Batu\ Pahat",
"6082552", "Kuching",
"603214", "Kuala\ Lumpur",
"6082842", "Damai\ Beach",
"6089865", "Lahad\ Datu",
"6037933", "Kuala\ Lumpur",
"6088357", "Kota\ Kinabalu",
"604918", "Alor\ Setar",
"6034295", "Kuala\ Lumpur",
"607485", "Batu\ Pahat",
"6033103", "Pulau\ Ketam",
"6037710", "Kuala\ Lumpur",
"604367", "Serdang",
"6039175", "Kuala\ Lumpur",
"604261", "Penang",
"6036065", "Kuala\ Kubu\ Baru",
"6087436", "Labuan",
"608844", "Kota\ Kinabalu",
"6082551", "Kuching",
"606333", "Melaka",
"607296", "Johor\ Bahru",
"6089436", "Kinabatangan",
"607304", "Johor\ Bahru",
"607381", "Johor\ Bahru",
"604618", "Penang",
"6039547", "Cheras",
"609480", "Maran",
"6088614", "Kudat",
"606391", "Tangga\ Batu",
"6085471", "Miri",
"6082846", "Damai\ Beach",
"6087431", "Labuan",
"6084804", "Sarikei",
"6083463", "Debak",
"6082887", "Serian",
"6033243", "Sekinchan",
"607662", "Kulai",
"606495", "Simpang\ Durian",
"607762", "Renggam",
"60961", "Kuala\ Brang",
"605644", "Hutan\ Melintang",
"604497", "Bedong",
"6086360", "Bintulu",
"608521", "Limbang",
"605744", "Manong",
"6089534", "Elopura",
"6087728", "Tenom",
"609245", "Triang",
"6087439", "Labuan",
"607240", "Johor\ Bahru",
"6033260", "Kuala\ Selangor",
"607890", "Linggiu",
"6089728", "Tawau",
"6082273", "Kuching",
"6033288", "Kuala\ Selangor",
"609447", "Bandar\ Tun\ Razak",
"6085472", "Miri",
"6032087", "Kuala\ Lumpur",
"609279", "Mentakab",
"6088206", "Kota\ Kinabalu",
"6083471", "Betong",
"6033006", "Sabak\ Bernam",
"609788", "Kok\ Lanas",
"604539", "Tasek\ Gelugor",
"609688", "Kuala\ Brang",
"606969", "Bukit\ Kepong",
"6085463", "Miri",
"6033345", "Kelang",
"6085736", "Batu\ Niah",
"604410", "Kulim",
"608634", "Bintulu",
"6087776", "Keningau",
"606514", "Jasin",
"6038100", "Kinrara",
"6082261", "Kuching",
"6086457", "Belaga",
"6032333", "Kuala\ Lumpur",
"6082227", "Kuching",
"605536", "Tanjung\ Rambutan",
"6032203", "Kuala\ Lumpur",
"6088656", "Kotamarudu",
"6084734", "Julau",
"608425", "Sibu",
"6083472", "Betong",
"6037717", "Kuala\ Lumpur",
"604621", "Penang",
"6084831", "Matu",
"6035886", "Kinrara",
"6087404", "Labuan",
"607253", "Johor\ Bahru",
"6087502", "Labuan",
"609370", "Dong",
"605649", "Hutan\ Melintang",
"6083338", "Bandar\ Sri\ Aman",
"605612", "Sitiawan",
"6083584", "Lubukantu",
"6034032", "Kuala\ Lumpur",
"605712", "Parit\ Buntar",
"6087509", "Labuan",
"6039540", "Kuala\ Lumpur",
"6038008", "Putrajaya",
"6032023", "Kuala\ Lumpur",
"6038893", "Putrajaya",
"604921", "Kangar",
"607512", "Senai",
"6034031", "Kuala\ Lumpur",
"6082896", "Serian",
"605401", "Tapah",
"6087501", "Labuan",
"6085750", "Marudi",
"6086326", "Bintulu",
"609787", "Machang",
"606319", "Melaka",
"6089747", "Tawau",
"604946", "Kangar",
"609687", "Bukit\ Bading",
"6089510", "Beluran",
"609583", "Gebeng",
"6088350", "Kota\ Kinabalu",
"6084832", "Matu",
"605351", "Batu\ Gajah",
"6034105", "Kuala\ Lumpur",
"609830", "Paka",
"604223", "Penang",
"609900", "Gua\ Musang",
"607705", "Keluang",
"607751", "Lavang\-Lavang",
"6038991", "Cheras",
"6084702", "Bintangor",
"607651", "Layang\-Layang",
"609570", "Kuantan",
"6082283", "Kuching",
"6085482", "Kampung\ Bakam",
"609700", "Kota\ Bharu",
"609823", "Al\ Muktafi\ Billa\ H\ Shah",
"606664", "Tekok\ Kemang",
"605675", "Changkat\ Keruing",
"6085481", "Bekenu",
"6038999", "Cheras",
"606423", "Simpang\ Durian",
"6086295", "Bintulu",
"606542", "Durian\ Tunggal",
"6082530", "Kuching",
"6089666", "Elopura",
"606430", "Gemencheh",
"6089295", "Elopura",
"607863", "Tiram",
"6038992", "Cheras",
"606519", "Jasin",
"606964", "Tangkak",
"6036078", "Batu\ Arang",
"6082663", "Kota\ Samarahan",
"608989", "Lahad\ Datu",
"607421", "Kampung\ Parit\ Tengah",
"6032601", "Kuala\ Lumpur",
"6034279", "Kuala\ Lumpur",
"6085611", "Miri",
"6036192", "Kuala\ Lumpur",
"606480", "Ayer\ Hitam",
"6082225", "Kuching",
"6036738", "Kuala\ Kubu\ Baru",
"6039078", "Cheras",
"6082864", "Kota\ Samarahan",
"604555", "Tasek\ Gelugor",
"6085612", "Miri",
"6036191", "Kuala\ Lumpur",
"607446", "Senggarang",
"6089286", "Elopura",
"607360", "Johor\ Bahru",
"6032602", "Kuala\ Lumpur",
"606653", "Port\ Dickson",
"6034271", "Kuala\ Lumpur",
"6089247", "Elopura",
"604280", "Penang",
"6089968", "Lahad\ Datu",
"607885", "Kota\ Tinggi",
"6036421", "Rawang",
"60577", "Kuala\ Kangsar",
"6086286", "Bintulu",
"609365", "Dong",
"6039191", "Kuala\ Lumpur",
"6092410", "Telemong",
"609937", "Kuala\ Balah",
"604451", "Jeniang",
"605434", "Tapah",
"604405", "Padang\ Serai",
"609520", "Kuantan",
"6032085", "Kuala\ Lumpur",
"6088850", "Ranau",
"6082323", "Damai\ Beach",
"609873", "Cheneh",
"6088308", "Kota\ Kinabalu",
"609637", "Kuala\ Brang",
"609816", "Dungun",
"6054620", "Kampar",
"607560", "Senai",
"605725", "Parit\ Buntar",
"606357", "Tangga\ Batu",
"605625", "Telukintan",
"6047930", "Pokok\ Sena",
"606251", "Melaka",
"6036093", "Rawang",
"606473", "Kemavan",
"609224", "Bentong",
"604824", "Penang",
"60545", "Tanjung\ Malim",
"609565", "Kuantan",
"605892", "Semanggol",
"605598", "Chemor",
"605242", "Ipoh",
"6082885", "Serian",
"6039206", "Kuala\ Lumpur",
"6038776", "Mantin",
"606358", "Tangga\ Batu",
"6086297", "Bintulu",
"6082682", "Kuching",
"6036141", "Kuala\ Lumpur",
"6082690", "Kuching",
"605693", "Sitiawan",
"604462", "Jeniang",
"6039141", "Kuala\ Lumpur",
"606640", "Port\ Dickson",
"605793", "Grik",
"6089942", "Tawau",
"6083567", "Lingga",
"605597", "Chemor",
"6084753", "Kanowit",
"6089941", "Tawau",
"607786", "Felda\ Kahang\ Timur",
"607697", "Pontian",
"605310", "Ipoh",
"6087228", "Beaufort",
"608831", "Kota\ Kinabalu",
"607686", "Pontian",
"6082681", "Kuching",
"6036142", "Kuala\ Lumpur",
"609772", "Kok\ Lanas",
"6034821", "Kuala\ Lumpur",
"609738", "Kota\ Bharu",
"609638", "Kuala\ Berang",
"6089276", "Elopura",
"606852", "Melaka",
"607910", "Tenang",
"609229", "Bilut\ Valley",
"6079010", "Tenggara",
"6087888", "Membakut",
"6086860", "Bintulu",
"605291", "Tanjung\ Rambutan",
"6034107", "Kuala\ Lumpur",
"605841", "Taiping",
"609915", "Gua\ Musang",
"607710", "Keluang",
"6082798", "Tebedu",
"6082762", "Bau",
"6089745", "Merotai",
"604829", "Penang",
"6082761", "Bau",
"6084304", "Sibu",
"6039170", "Kuala\ Lumpur",
"6034290", "Kuala\ Lumpur",
"605439", "Tapah",
"6089843", "Kunak",
"609452", "Bukit\ Ibam",
"6034289", "Kuala\ Lumpur",
"6084234", "Sibu",
"6082766", "Bau",
"6088709", "Kinarut",
"609764", "Bachok",
"6089279", "Elopura",
"609664", "Batu\ Rakit",
"609542", "Sungai\ Lembing",
"609848", "Dungun",
"606274", "Melaka",
"609423", "Chini",
"604898", "Penang",
"604248", "Penang",
"604592", "Parit\ Buntar",
"6084738", "Julau",
"6038740", "Semenyih",
"609430", "Pekan",
"606383", "Tangga\ Batu",
"6089272", "Elopura",
"605467", "Kampar",
"608741", "Labuan",
"6088702", "Kinarut",
"6089271", "Elopura",
"6088701", "Kinarut",
"6085310", "Limbang",
"607924", "Labis",
"6085231", "Kampung\ Pahlawan",
"6082294", "Kuching",
"6032858", "Kuala\ Lumpur",
"6032300", "Kuala\ Lumpur",
"605220", "Ipoh",
"6033265", "Kuala\ Selangor",
"6038779", "Mantin",
"6037202", "Kuala\ Lumpur",
"6089538", "Elopura",
"6037651", "Kuala\ Lumpur",
"606987", "Bakri",
"6036460", "Kerling",
"6083309", "Bandar\ Sri\ Aman",
"607531", "Senai",
"6082686", "Kuching",
"604392", "Penang",
"606696", "Linggi",
"6089240", "Elopura",
"60473", "Alor\ Setar",
"6039202", "Kuala\ Lumpur",
"6033284", "Kuala\ Selangor",
"60463", "Penang",
"608243", "Sejingkat",
"605631", "Kampong\ Gajah",
"6084808", "Sibu",
"6035623", "Kinrara",
"6039201", "Kuala\ Lumpur",
"6084350", "Sibu",
"6088618", "Kudat",
"604685", "Penang",
"604985", "Kangar",
"605855", "Taiping",
"6083310", "Bandar\ Sri\ Aman",
"6037652", "Kuala\ Lumpur",
"605801", "Taiping",
"6033363", "Kelang",
"6036187", "Kuala\ Lumpur",
"6087822", "Sipitang",
"6035721", "Kinrara",
"604810", "Penang",
"6039021", "Kuala\ Lumpur",
"6034297", "Kuala\ Lumpur",
"6038321", "Putrajaya",
"6036021", "Batuarang",
"6082720", "Lundu",
"604526", "Kulim",
"6039545", "Kuala\ Lumpur",
"607929", "Aver\ Panas",
"6038964", "Cheras",
"6082380", "Kuching",
"603749", "Kuala\ Lumpur",
"6036177", "Kuala\ Lumpur",
"609591", "Kuantan",
"6082391", "Kuching",
"608825", "Kota\ Kinabalu",
"6038329", "Putrajaya",
"609769", "Bachok",
"605476", "Kampar",
"6036022", "Batu\ Arang",
"60794", "Gemas",
"605413", "Cameron\ Highland",
"609669", "Batu\ Rakit",
"606988", "Bakri",
"6089867", "Lahad\ Datu",
"6034100", "Kuala\ Lumpur",
"605529", "Ipoh",
"6088355", "Kota\ Kinabalu",
"6038322", "Putrajaya",
"6087821", "Sipitang",
"6089515", "Beluran",
"603401", "Kuala\ Lumpur",
"6082503", "Kuching",
"6085755", "Marudi",
"6038790", "Mantin",
"6082628", "Kuching",
"6036196", "Kuala\ Lumpur",
"6089281", "Elopura",
"6033381", "Kelang",
"604759", "Alor\ Setar",
"6038661", "Mantin",
"6084614", "Rejang",
"604959", "Kuah",
"6085495", "Miri",
"605889", "Taiping",
"6036123", "Kuala\ Lumpur",
"6086281", "Bintulu",
"6095070", "Kuantan",
"6089289", "Elopura",
"6086282", "Bintulu",
"6086290", "Bintulu",
"6092871", "Kuala\ Krau",
"603551", "Kinrara",
"6087408", "Labuan",
"609286", "Kuala\ Krau",
"605756", "Kuala\ Kangsar",
"6089923", "Tawau",
"6033382", "Kelang",
"604886", "Penang",
"607272", "Johor\ Bahru",
"6089290", "Elopura",
"6085616", "Miri",
"605468", "Kampar",
"606695", "Linggi",
"604859", "Penang",
"6099200", "Ayer\ Lanas",
"6032108", "Kuala\ Lumpur",
"6085221", "Limbang",
"605689", "Sitiawan",
"6033081", "Kelang",
"603563", "Kinrara",
"6037661", "Kuala\ Lumpur",
"6084797", "Kapit",
"6033082", "Kelang",
"6037662", "Kuala\ Lumpur",
"604997", "Kangar",
"6088408", "Kota\ Kinabalu",
"605856", "Taiping",
"604986", "Kangar",
"609543", "Sungai\ Lembing",
"6085222", "Limbang",
"607208", "Johor\ Bahru",
"604593", "Parit\ Buntar",
"604797", "Ayer\ Hitam",
"604686", "Penang",
"609947", "Ayer\ Lanas",
"6086253", "Bintulu",
"6037669", "Kuala\ Lumpur",
"608434", "Sibu",
"604610", "Penang",
"604710", "Alor\ Setar",
"6033183", "Banting",
"606469", "Kemavan",
"6037874", "Kuala\ Lumpur",
"6038021", "Kinrara",
"6084620", "Sarikei",
"609869", "Kemasik",
"6087734", "Tenom",
"6088977", "Kota\ Belud",
"6038022", "Kinrara",
"6088515", "Kota\ Kinabalu",
"6083417", "Betong",
"6036789", "Genting",
"6033148", "Banting",
"604269", "Penang",
"608242", "Kuching",
"6088413", "Kota\ Kinabalu",
"6085784", "Bakun",
"6036032", "Rawang",
"605412", "Trolak",
"6039772", "Kuala\ Lumpur",
"6039779", "Kuala\ Lumpur",
"609550", "Kuantan",
"6032266", "Kuala\ Lumpur",
"6037772", "Kuala\ Lumpur",
"6036039", "Kuala\ Lumpur",
"605449", "Tanjung\ Malim",
"60457", "Kepala\ Batas",
"6087831", "Menumbok",
"6035162", "Kinrara",
"6035198", "Kinrara",
"6088538", "Kota\ Kinabalu",
"6038659", "Cheras",
"604885", "Penang",
"6035161", "Kinrara",
"6036105", "Genting",
"6087832", "Menumbok",
"6038210", "Semenyih",
"6037771", "Kuala\ Lumpur",
"6038331", "Putrajaya",
"605831", "Selama",
"6082730", "Lundu",
"6084393", "Sibu",
"605684", "Sitiawan",
"6085406", "Miri",
"606221", "Melaka",
"6037884", "Kuala\ Lumpur",
"6039771", "Kuala\ Lumpur",
"609254", "Triang",
"609285", "Mentakab",
"6089618", "Elopura",
"605655", "Kampong\ Gajah",
"6039105", "Cheras",
"6032113", "Kuala\ Lumpur",
"6033169", "Kelang",
"607301", "Johor\ Bahru",
"6083324", "Bandar\ Sri\ Aman",
"6039057", "Cheras",
"609864", "Kemasik",
"6039224", "Kuala\ Lumpur",
"6057970", "Grik",
"607207", "Johor\ Bahru",
"6089702", "Tawau",
"607451", "Batu\ Pahat",
"607216", "Johor\ Bahru",
"604264", "Penang",
"6037865", "Kuala\ Lumpur",
"6036057", "Kuala\ Kubu\ Baru",
"609350", "Raub",
"6033198", "Banting",
"6085664", "Miri",
"6033162", "Kelang",
"6039133", "Kuala\ Lumpur",
"6033161", "Kelang",
"6085765", "Marudi",
"606630", "Seremban",
"6032011", "Kuala\ Lumpur",
"605203", "Chemor",
"6089701", "Tawau",
"6083406", "Maludam",
"604560", "Kepala\ Batas",
"606527", "Jasin",
"6036436", "Genting",
"606464", "Ladang\ Geddes",
"608826", "Kota\ Kinabalu",
"6088888", "Ranau",
"6088970", "Kota\ Belud",
"6086581", "Tatau",
"604417", "Mahang",
"6033166", "Kelang",
"609815", "Kerteh",
"604356", "Tasek\ Gelugor",
"6083410", "Kabong",
"604929", "Alor\ Setar",
"6088745", "Kinarut",
"604629", "Penang",
"607810", "Paloh",
"6089706", "Tawau",
"6084661", "Sarikei",
"6078010", "Mersing",
"605641", "Hutan\ Melintang",
"604406", "Padang\ Serai",
"6032273", "Kuala\ Lumpur",
"6082305", "Kuching",
"606311", "Melaka",
"608233", "Kuching",
"60464", "Penang",
"6084698", "Bintangor",
"605359", "Batu\ Gajah",
"609566", "Kuantan",
"6039388", "Cheras",
"6033213", "Hutan\ Melintang",
"6084662", "Sarikei",
"605626", "Telukintan",
"6034253", "Kuala\ Lumpur",
"6087484", "Labuan",
"605726", "Parit\ Buntar",
"6086484", "Balingan",
"6087313", "Keningau",
"60979", "Kota\ Bharu",
"6086590", "Tatau",
"6058710", "Semanggol",
"608220", "Kuching",
"60969", "Jerteh",
"606415", "Tampin",
"606438", "Simpang\ Empat",
"6082544", "Kuching",
"6035166", "Kinrara",
"6032298", "Kuala\ Lumpur",
"6089465", "Elopura",
"6036158", "Kuala\ Lumpur",
"606472", "Kuala\ Klawang",
"6032262", "Kuala\ Lumpur",
"6087465", "Labuan",
"6039776", "Kuala\ Lumpur",
"6036036", "Batuarang",
"6085401", "Miri",
"607759", "Ayer\ Hitam",
"6084874", "Mukah",
"6084367", "Sibu",
"6038911", "Semenyih",
"607659", "Linggiu",
"605893", "Taiping",
"605243", "Ipoh",
"607886", "Penawar",
"608631", "Bintulu",
"6038656", "Cheras",
"607897", "Tiram",
"6085288", "Lawas",
"6084789", "Kapit",
"6038912", "Semenyih",
"604238", "Penang",
"609708", "Kota\ Bharu",
"609440", "Bandar\ Tun\ Razak",
"6085402", "Miri",
"609838", "Merchang",
"6032261", "Kuala\ Lumpur",
"607445", "Batu\ Pahat",
"6084790", "Kapit",
"609872", "Cheneh",
"6087215", "Beaufort",
"6089850", "Kunak",
"6032385", "Kuala\ Lumpur",
"60628", "Melaka",
"607898", "Tenggara",
"604331", "Penang",
"605354", "Ipoh",
"605385", "Bota",
"609707", "Kota\ Bharu",
"6032725", "Kuala\ Lumpur",
"6082752", "Kuching",
"6089717", "Tawau",
"609773", "Kota\ Bharu",
"6033120", "Tk\ Panglima\ Garang",
"605404", "Tapah",
"605481", "Tanjung\ Malim",
"6087850", "Kuala\ Penyu",
"6084772", "Song",
"603228", "Kuala\ Lumpur",
"6035565", "Kinrara",
"6084683", "Sarikei",
"6082807", "Simunjan",
"6038093", "Kinrara",
"604924", "Changlon",
"606437", "Johol",
"6089563", "Kinabatangan",
"60448", "Kulim",
"6039050", "Cheras",
"6085395", "Miri",
"604463", "Jeniang",
"605692", "Sitiawan",
"6082751", "Bau",
"606235", "Melaka",
"605792", "Grik",
"6038026", "Kinrara",
"6035482", "Kinrara",
"609271", "Mentakab",
"609453", "Bukit\ Ibam",
"6035120", "Kinrara",
"6082737", "Lundu",
"60793", "Segamat",
"6082491", "Kuching",
"606661", "Tekok\ Kemang",
"6084224", "Sibu",
"6082492", "Kuching",
"604418", "Mahang",
"609680", "Kuala\ Brang",
"609780", "Kok\ Lanas",
"6088968", "Kota\ Belud",
"607754", "Ayer\ Hitam",
"6035481", "Kinrara",
"6034065", "Kuala\ Lumpur",
"607654", "Linggiu",
"607685", "Pontian",
"609980", "Kuala\ Krai",
"607785", "Keluang",
"6033086", "Kelang",
"6037666", "Kuala\ Lumpur",
"6082499", "Kuching",
"605667", "Bruas",
"6085453", "Miri",
"605767", "Lenggong",
"6089524", "Telupid",
"6033317", "Kelang",
"609630", "Kuala\ Brang",
"6087738", "Tenom",
"6035611", "Kinrara",
"604200", "Penang",
"6087217", "Beaufort",
"6086422", "Sebauh",
"605318", "Ipoh",
"606648", "Port\ Dickson",
"605535", "Tanjung\ Rambutan",
"6036286", "Kuala\ Lumpur",
"6084365", "Sibu",
"607424", "Rengit",
"606350", "Tangga\ Batu",
"6035612", "Kinrara",
"6087467", "Labuan",
"607663", "Kulai",
"607763", "Ayer\ Hitam",
"6089630", "Elopura",
"60443", "Sungai\ Petani",
"605299", "Tanjung\ Rambutan",
"605849", "Taiping",
"6032783", "Kuala\ Lumpur",
"606496", "Kuala\ Klawang",
"6038308", "Putrajaya",
"6088404", "Kota\ Kinabalu",
"6084384", "Sibu",
"6093261", "Padang\ Tengku",
"609221", "Bentong",
"609327", "Padang\ Tengku",
"605812", "Taiping",
"6088393", "Kota\ Kinabalu",
"6088747", "Kinarut",
"6033250", "Kelang",
"6093262", "Padang\ Tengku",
"604485", "Padang\ Serai",
"6086350", "Bintulu",
"607918", "Aver\ Panas",
"6088786", "Tuaran",
"606550", "Tampin",
"609246", "Bera",
"605431", "Besout",
"604454", "Sungai\ Petani",
"607261", "Johor\ Bahru",
"604288", "Penang",
"607513", "Tanjung\ Kupang",
"6037949", "Kuala\ Lumpur",
"607906", "Segamat",
"6034021", "Kuala\ Lumpur",
"607706", "Keluang",
"604779", "Pokok\ Sena",
"6089206", "Elopura",
"607917", "Tenang",
"608981", "Felda\ Sahabat",
"609888", "Kemasik",
"607429", "Senggarang",
"609582", "Gebeng",
"6084821", "Daro",
"605506", "Ipoh",
"603784", "Kuala\ Lumpur",
"6038958", "Cheras",
"6047453", "Alor\ Setar",
"6032681", "Kuala\ Lumpur",
"6083555", "Bandar\ Sri\ Aman",
"6032773", "Kuala\ Lumpur",
"607252", "Johor\ Bahru",
"6036100", "Genting",
"6037941", "Kuala\ Lumpur",
"6085680", "Miri",
"605613", "Teluk\ Intan",
"6039100", "Cheras",
"605676", "Changkat\ Keruing",
"6034022", "Kuala\ Lumpur",
"6085668", "Miri",
"609328", "Kuala\ Lipis",
"603831", "Putrajaya",
"605517", "Tanjung\ Rambutan",
"6082735", "Lundu",
"606647", "Port\ Dickson",
"6085743", "Beluru",
"604309", "Sungai\ Petani",
"606422", "Tampin",
"6082805", "Simunjan",
"6088343", "Kota\ Kinabalu",
"6036276", "Kuala\ Lumpur",
"6035567", "Kinrara",
"6088797", "Tuaran",
"6082520", "Kuching",
"6089614", "Elopura",
"607862", "Tiram",
"6038706", "Mantin",
"6035521", "Kinrara",
"607990", "Bakri",
"6035522", "Kinrara",
"6032727", "Kuala\ Lumpur",
"6085555", "Miri",
"605668", "Sitiawan",
"604945", "Kangar",
"6089715", "Tawau",
"605768", "Lenggong",
"6085760", "Marudi",
"604222", "Penang",
"6032387", "Kuala\ Lumpur",
"6088360", "Kota\ Kinabalu",
"605294", "Tanjung\ Rambutan",
"605211", "Ipoh",
"6088534", "Kota\ Kinabalu",
"609822", "Al\ Muktafi\ Billa\ H\ Shah",
"6088740", "Kinarut",
"6088517", "Kota\ Kinabalu",
"609853", "Chukai",
"604375", "Penang",
"607921", "Labis",
"605546", "Ipoh",
"6036279", "Kuala\ Lumpur",
"6082312", "Kuching",
"6089954", "Balung",
"6082583", "Kota\ Samarahan",
"6088975", "Kota\ Belud",
"6085284", "Lawas",
"607721", "Renggam",
"6082319", "Kuching",
"60735", "Johor\ Bahru",
"6036272", "Kuala\ Lumpur",
"606980", "Bukit\ Gambir",
"604471", "Sungai\ Bakap",
"6034217", "Kuala\ Lumpur",
"604253", "Penang",
"609961", "Kuala\ Krai",
"604549", "Tasek\ Gelugor",
"6082548", "Kuching",
"6082300", "Kuching",
"6039271", "Kuala\ Lumpur",
"609599", "Gambang",
"6082311", "Kuching",
"604818", "Penang",
"604512", "Penang",
"6063131", "Melaka",
"607746", "Renggam",
"6035526", "Kinrara",
"6032686", "Kuala\ Lumpur",
"609437", "Perwira\ Jaya",
"6084694", "Bintangor",
"6038084", "Kinrara",
"604951", "Kuah",
"605881", "Selama",
"605804", "Taiping",
"604835", "Penang",
"6089202", "Elopura",
"6037946", "Kuala\ Lumpur",
"603893", "Cheras",
"6087209", "Beaufort",
"6083340", "Bandar\ Sri\ Aman",
"609235", "Genting",
"60755", "Senai",
"604705", "Alor\ Setar",
"608258", "Kuching",
"607223", "Johor\ Bahru",
"6089209", "Elopura",
"6086460", "Belaga",
"6084893", "Selangau",
"6086488", "Balingan",
"6087460", "Labuan",
"60565", "Langkap",
"605321", "Ipoh",
"6034026", "Kuala\ Lumpur",
"6087201", "Beaufort",
"6085265", "Sundar",
"606973", "Bukit\ Gambir",
"6086201", "Bintulu",
"6089201", "Elopura",
"606907", "Muar",
"6036263", "Kuala\ Lumpur",
"608876", "Kinarut",
"6087443", "Labuan",
"609263", "Damak",
"603404", "Kuala\ Lumpur",
"6085767", "Marudi",
"6032720", "Kuala\ Lumpur",
"6088367", "Kota\ Kinabalu",
"604762", "Alor\ Setar",
"6035543", "Kinrara",
"6032380", "Kuala\ Lumpur",
"6089855", "Kunak",
"6032392", "Kuala\ Lumpur",
"6088781", "Tuaran",
"604962", "Kuah",
"606532", "Jasin",
"609438", "Perwira\ Jaya",
"6039055", "Cheras",
"607295", "Johor\ Bahru",
"604240", "Penang",
"6038074", "Kinrara",
"604890", "Penang",
"6088782", "Tuaran",
"6088790", "Tuaran",
"607486", "Batu\ Pahat",
"608257", "Kuching",
"6084228", "Sibu",
"6032391", "Kuala\ Lumpur",
"6087478", "Labuan",
"6036055", "Kuala\ Kubu\ Baru",
"609840", "Dungun",
"6049371", "Kangar",
"6088661", "Kotamarudu",
"609217", "Mentakab",
"6036281", "Kuala\ Lumpur",
"607879", "Linggiu",
"604936", "Kangar",
"606332", "Melaka",
"609415", "Kuala\ Rompin",
"6035125", "Kinrara",
"6034813", "Kuala\ Lumpur",
"6088669", "Kota\ Marudu",
"6087234", "Beaufort",
"6096830", "Kuala\ Brang",
"6084644", "Sarikei",
"605809", "Taiping",
"609752", "Pasir\ Putih",
"605282", "Ipoh",
"6077120", "Keluang",
"6083438", "Saratok",
"609952", "Machang",
"6088662", "Kota\ Marudu",
"6049372", "Kangar",
"6087304", "Keningau",
"608975", "Tawau",
"6084361", "Sibu",
"604552", "Tasek\ Gelugor",
"6032222", "Kuala\ Lumpur",
"606476", "Ladang\ Geddes",
"6085407", "Miri",
"6035126", "Kinrara",
"6088533", "Kota\ Kinabalu",
"608235", "Kuching",
"605688", "Sitiawan",
"606529", "Jasin",
"609362", "Fraser\ Hill",
"6037660", "Kuala\ Lumpur",
"6033080", "Kelang",
"6085744", "Beluru",
"607882", "Kota\ Tinggi",
"6085220", "Limbang",
"607209", "Johor\ Bahru",
"6088344", "Kota\ Kinabalu",
"6032267", "Kuala\ Lumpur",
"6089814", "Tungku",
"6032118", "Kuala\ Lumpur",
"609813", "Paka",
"6089613", "Elopura",
"6084362", "Sibu",
"609536", "Kuantan",
"6033099", "Pulau\ Ketam",
"6084398", "Sibu",
"6047454", "Alor\ Setar",
"606656", "Port\ Dickson",
"6033126", "Tk\ Panglima\ Garang",
"607443", "Rengit",
"607522", "Senai",
"607828", "Penawar",
"609489", "Maran",
"606468", "Ayer\ Hitam",
"604402", "Kulim",
"6089856", "Kunak",
"6032034", "Kuala\ Lumpur",
"605245", "Ipoh",
"6038020", "Kinrara",
"605895", "Taiping",
"609868", "Chukai",
"604611", "Penang",
"6083220", "Bandar\ Sri\ Aman",
"607388", "Johor\ Bahru",
"604794", "Ayer\ Hitam",
"6036138", "Kuala\ Lumpur",
"609944", "Ayer\ Lanas",
"604911", "Alor\ Setar",
"6039056", "Cheras",
"605622", "Telukintan",
"605722", "Parit\ Buntar",
"604268", "Penang",
"6088394", "Kota\ Kinabalu",
"609867", "Kemasik",
"606233", "Melaka",
"6039770", "Kuala\ Lumpur",
"604465", "Bedong",
"6082731", "Lundu",
"607387", "Johor\ Bahru",
"605448", "Tanjung\ Malim",
"6037770", "Kuala\ Lumpur",
"6032685", "Kuala\ Lumpur",
"6038211", "Semenyih",
"604267", "Penang",
"6084796", "Kapit",
"606265", "Sungai\ Rambai",
"607500", "Tanjung\ Kupang",
"6033358", "Kelang",
"6082739", "Lundu",
"6088403", "Kota\ Kinabalu",
"609775", "Kota\ Bharu",
"607970", "Segamat",
"6088928", "Papar",
"60536", "Batu\ Gajah",
"606467", "Ayer\ Hitam",
"609551", "Kuantan",
"607670", "Kulai",
"6084383", "Sibu",
"606524", "Jasin",
"609975", "Machang",
"6085266", "Lawas",
"609505", "Kuantan",
"6034025", "Kuala\ Lumpur",
"607783", "Keluang",
"605370", "Batu\ Gajah",
"607683", "Pontian",
"609912", "Gua\ Musang",
"607587", "Senai",
"606631", "Seremban",
"607596", "Senai",
"604561", "Kepala\ Batas",
"6089711", "Tawau",
"6033160", "Kelang",
"6088976", "Kota\ Belud",
"604699", "Alor\ Setar",
"609949", "Ayer\ Lanas",
"609712", "Kota\ Bharu",
"6082809", "Simunjan",
"604799", "Pokok\ Sena",
"607300", "Johor\ Bahru",
"6089523", "Telupid",
"6082810", "Asajaya",
"6085454", "Miri",
"6035525", "Kinrara",
"609455", "Bukit\ Ibam",
"6089712", "Tawau",
"605583", "Chemor",
"607450", "Senggarang",
"609351", "Raub",
"60962", "Kuala\ Brang",
"6084777", "Song",
"6033143", "Sepang",
"605687", "Sitiawan",
"605796", "Grik",
"6038705", "Mantin",
"6082315", "Kuching",
"6087233", "Beaufort",
"603873", "Semenyih",
"6088972", "Kota\ Belud",
"6038027", "Kinrara",
"6082472", "Kuching",
"604928", "Changlon",
"604595", "Parit\ Buntar",
"604628", "Penang",
"6084844", "Mukah",
"6088979", "Kota\ Belud",
"6089591", "Telupid",
"6087303", "Keningau",
"6036275", "Kuala\ Lumpur",
"6086303", "Bintulu",
"608221", "Kuching",
"6078011", "Mersing",
"6089568", "Kinabatangan",
"607244", "Johor\ Bahru",
"605358", "Batu\ Gajah",
"607894", "Kota\ Tinggi",
"6084660", "Sarikei",
"608887", "Ranau",
"6089716", "Tawau",
"6083411", "Kabong",
"608246", "Kuching",
"605640", "Hutan\ Melintang",
"606793", "Mantin",
"6088861", "Bongawan",
"606693", "Rantau",
"6086580", "Tatau",
"6082471", "Kuching",
"6088971", "Kota\ Belud",
"606439", "Simpang\ Empat",
"6089205", "Elopura",
"6038073", "Kinrara",
"608923", "Elopura",
"607340", "Johor\ Bahru",
"6032260", "Kuala\ Lumpur",
"6088940", "Kota\ Belud",
"604414", "Serdang",
"605236", "Ipoh",
"609345", "Raub",
"607658", "Kulai",
"607758", "Ayer\ Hitam",
"6085298", "Lawas",
"6084799", "Kapit",
"60549", "Cameron\ Highland",
"609609", "Bandar\ Permaisuri",
"605852", "Taiping",
"6035544", "Kinrara",
"604982", "Kangar",
"6038216", "Kuala\ Lumpur",
"6088674", "Kudat",
"609839", "Merchang",
"6035653", "Kinrara",
"6084780", "Kapit",
"607899", "Tiram",
"605753", "Kuala\ Kangsar",
"6089852", "Kunak",
"6033129", "Tk\ Panglima\ Garang",
"6082750", "Kota\ Samarahan",
"6039051", "Cheras",
"606398", "Tangga\ Batu",
"60667", "Seremban",
"6033122", "Tk\ Panglima\ Garang",
"6089859", "Kunak",
"6087852", "Menumbok",
"6084770", "Song",
"6088785", "Tuaran",
"604330", "Penang",
"6084693", "Bintangor",
"6087851", "Kuala\ Penyu",
"6032847", "Kuala\ Lumpur",
"6032278", "Kuala\ Lumpur",
"6039059", "Cheras",
"6087318", "Keningau",
"605480", "Tanjung\ Malim",
"608822", "Kota\ Kinabalu",
"607657", "Kulai",
"604323", "Penang",
"6084894", "Stapang",
"6034258", "Kuala\ Lumpur",
"6089851", "Kunak",
"6033167", "Kelang",
"607757", "Renggam",
"605473", "Bagan\ Datoh",
"609681", "Kuala\ Brang",
"6089570", "Kinabatangan",
"605416", "Tapah",
"609781", "Machang",
"605357", "Ipoh",
"6035480", "Kinrara",
"605205", "Ipoh",
"606242", "Melaka",
"6035122", "Kinrara",
"60645", "Bahau",
"609834", "Bukit\ Besi",
"6082658", "Kuching",
"6038657", "Cheras",
"6088981", "Tenghilan",
"609981", "Kuala\ Krai",
"604530", "Tasek\ Gelugor",
"6088982", "Tenghilan",
"604419", "Sungai\ Petani",
"6084366", "Sibu",
"606960", "Bukit\ Gambir",
"604927", "Ayer\ Hitam",
"6085283", "Lawas",
"6036037", "Rawang",
"606434", "Jelai",
"6035121", "Kinrara",
"603772", "Kuala\ Lumpur",
"604727", "Bedong",
"609270", "Mentakab",
"6088665", "Kotamarudu",
"604627", "Penang",
"606660", "Tekok\ Kemang",
"6035167", "Kinrara",
"607477", "Sri\ Gading",
"6036285", "Kuala\ Lumpur",
"6039134", "Kuala\ Lumpur",
"606351", "Tangga\ Batu",
"609324", "Kuala\ Lipis",
"607850", "Tiram",
"604255", "Penang",
"6083323", "Bandar\ Sri\ Aman",
"604307", "Penang",
"6085225", "Limbang",
"6033085", "Kelang",
"609631", "Kuala\ Brang",
"6038953", "Cheras",
"6089207", "Elopura",
"6037665", "Kuala\ Lumpur",
"604201", "Penang",
"6039223", "Kuala\ Lumpur",
"608872", "Kinarut",
"609801", "Paka",
"6085663", "Miri",
"609855", "Chukai",
"604373", "Penang",
"608532", "Miri",
"608838", "Kota\ Kinabalu",
"606612", "Kuala\ Klawang",
"607364", "Johor\ Bahru",
"605542", "Ipoh",
"605848", "Taiping",
"6089818", "Lahad\ Datu",
"605423", "Tapah",
"609265", "Jerantut",
"6089632", "Elopura",
"6088348", "Kota\ Kinabalu",
"606775", "Seremban",
"6086351", "Bintulu",
"605664", "Sitiawan",
"6037883", "Kuala\ Lumpur",
"606975", "Muar",
"606551", "Simpang\ Empat",
"609467", "Maran",
"6084394", "Sibu",
"6032386", "Kuala\ Lumpur",
"6088511", "Kota\ Kinabalu",
"6032114", "Kuala\ Lumpur",
"6032726", "Kuala\ Lumpur",
"605430", "Besout",
"6087818", "Sipitang",
"6088512", "Kota\ Kinabalu",
"6082708", "Kota\ Samarahan",
"6038707", "Mantin",
"6039018", "Cheras",
"604820", "Penang",
"6088414", "Kota\ Kinabalu",
"6038025", "Kinrara",
"6093260", "Padang\ Tengku",
"609233", "Genting",
"604703", "Bedong",
"607225", "Johor\ Bahru",
"607742", "Lavang\-Lavang",
"607919", "Labis",
"6088796", "Tuaran",
"609220", "Bentong",
"6036277", "Kuala\ Lumpur",
"6035566", "Kinrara",
"604903", "Kuah",
"6033610", "Kuala\ Selangor",
"607427", "Senggarang",
"6088519", "Kota\ Kinabalu",
"604573", "Tasek\ Gelugor",
"6033259", "Kelang",
"6089631", "Elopura",
"6036035", "Batuarang",
"6086466", "Sebauh",
"6089902", "Merotai",
"6087733", "Tenom",
"604289", "Penang",
"604932", "Ayer\ Hitam",
"6039775", "Kuala\ Lumpur",
"6087466", "Labuan",
"6039101", "Cheras",
"606644", "Port\ Dickson",
"6035165", "Kinrara",
"6036101", "Genting",
"6037940", "Kuala\ Lumpur",
"6036287", "Kuala\ Lumpur",
"604778", "Pokok\ Sena",
"606336", "Melaka",
"6089466", "Elopura",
"6088667", "Kota\ Marudu",
"607428", "Senggarang",
"6084820", "Daro",
"605847", "Taiping",
"605286", "Ipoh",
"606489", "Kuala\ Klawang",
"6036102", "Genting",
"6087216", "Beaufort",
"6034020", "Kuala\ Lumpur",
"6037873", "Kuala\ Lumpur",
"6039102", "Cheras",
"609468", "Maran",
"6038655", "Cheras",
"6033184", "Banting",
"6089901", "Merotai",
"609329", "Padangtengku",
"604308", "Tasek\ Gelugor",
"604766", "Alor\ Setar",
"6082713", "Semantan",
"6089705", "Tawau",
"6032788", "Kuala\ Lumpur",
"6088787", "Tuaran",
"6088361", "Kota\ Kinabalu",
"605210", "Ipoh",
"6033165", "Kelang",
"6037972", "Kuala\ Lumpur",
"6085761", "Layang\-Layang",
"604966", "Kuah",
"607791", "Felda\ Tenggaroh",
"6088746", "Kinarut",
"607914", "Tenang",
"6037862", "Kuala\ Lumpur",
"6086254", "Bintulu",
"606536", "Jasin",
"6037971", "Kuala\ Lumpur",
"605769", "Lenggong",
"609476", "Maran",
"6037861", "Kuala\ Lumpur",
"609413", "Kuala\ Rompin",
"6035520", "Kinrara",
"605669", "Sitiawan",
"605591", "Lintang",
"6088362", "Kota\ Kinabalu",
"603796", "Kuala\ Lumpur",
"6087803", "Sipitang",
"6082306", "Kuching",
"6088369", "Kota\ Kinabalu",
"609529", "Kuantan",
"607482", "Kangkar\ Baru",
"6085769", "Marudi",
"6037866", "Kuala\ Lumpur",
"605520", "Ipoh",
"609960", "Kuala\ Krai",
"606492", "Kuala\ Klawang",
"607765", "Endau",
"6035548", "Kinrara",
"607665", "Kulai",
"6088742", "Kinarut",
"6082593", "Kuching",
"605807", "Taiping",
"6063130", "Melaka",
"6036270", "Kuala\ Lumpur",
"6082301", "Kuching",
"606270", "Melaka",
"605637", "Sabak\ Bernam",
"605533", "Tanjung\ Rambutan",
"607965", "Kota\ Tinggi",
"609760", "Bachok",
"609660", "Kuala\ Brang",
"606781", "Sepang",
"606681", "Seremban",
"6038523", "Kinrara",
"6082302", "Kuching",
"607920", "Segamat",
"609725", "Kota\ Bharu",
"604292", "Penang",
"604548", "Tasek\ Gelugor",
"607720", "Mersing",
"609242", "Bera",
"609598", "Gambang",
"604819", "Penang",
"6088366", "Kota\ Kinabalu",
"6082309", "Kuching",
"6084223", "Sibu",
"606981", "Bakri",
"6085766", "Marudi",
"6088741", "Kinarut",
"6038094", "Kinrara",
"6086469", "Belaga",
"6089462", "Elopura",
"605320", "Ipoh",
"6032265", "Kuala\ Lumpur",
"6084684", "Sarikei",
"6087211", "Beaufort",
"6083342", "Bandar\ Sri\ Aman",
"604483", "Baling",
"6036242", "Kuala\ Lumpur",
"6087462", "Labuan",
"6086462", "Bakun",
"6087461", "Labuan",
"6036241", "Kuala\ Lumpur",
"608543", "Miri",
"605880", "Selama",
"6085405", "Miri",
"604950", "Kuah",
"6086461", "Belaga",
"6039106", "Cheras",
"605461", "Tapah",
"6087219", "Beaufort",
"6083341", "Bandar\ Sri\ Aman",
"6087212", "Beaufort",
"6033319", "Kelang",
"6089461", "Elopura",
"60626", "Melaka",
"6084848", "Kuala\ Igan",
"6032722", "Kuala\ Lumpur",
"606426", "Ayer\ Hitam",
"6082755", "Kuching",
"604891", "Penang",
"609214", "Bentong",
"604241", "Penang",
"604347", "Penang",
"6032382", "Kuala\ Lumpur",
"6035561", "Kinrara",
"6088791", "Tuaran",
"6032389", "Kuala\ Lumpur",
"609841", "Dungun",
"6082543", "Kuching",
"6035562", "Kinrara",
"6088792", "Tuaran",
"6085720", "Batu\ Niah",
"604226", "Penang",
"6088780", "Kota\ Kinabalu",
"6088799", "Tuaran",
"6032381", "Kuala\ Lumpur",
"609826", "Kerteh",
"6035569", "Kinrara",
"6032721", "Kuala\ Lumpur",
"607515", "Tanjung\ Kupang",
"6033256", "Kelang",
"6088516", "Kota\ Kinabalu",
"6084873", "Mukah",
"607832", "Penawar",
"607902", "Tangkak",
"6035485", "Kinrara",
"6032274", "Kuala\ Lumpur",
"6033214", "Sabak\ Bernam",
"6084869", "Kuala\ Igan",
"609586", "Gebeng",
"6086483", "Pelagus",
"6034027", "Kuala\ Lumpur",
"6084898", "Sibu",
"6087483", "Labuan",
"606379", "Tangga\ Batu",
"6087314", "Keningau",
"604943", "Kangar",
"603205", "Kuala\ Lumpur",
"607256", "Johor\ Bahru",
"609310", "Kuala\ Lipis",
"6082495", "Kuching",
"605808", "Taiping",
"6036280", "Kuala\ Lumpur",
"606545", "Durian\ Tunggal",
"6037947", "Kuala\ Lumpur",
"6049370", "Kangar",
"6032687", "Kuala\ Lumpur",
"6085628", "Miri",
"6088451", "Kinarut",
"605672", "Sitiawan",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+60|\D)//g;
      my $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;