# automatically generated file, don't edit



# Copyright 2011 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::DE;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20210309172131;

my $formatters = [
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            3[02]|
            40|
            [68]9
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3,13})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            2(?:
              0[1-389]|
              12[0-8]
            )|
            3(?:
              [35-9][15]|
              4[015]
            )|
            906|
            2(?:
              [13][14]|
              2[18]
            )|
            (?:
              2[4-9]|
              4[2-9]|
              [579][1-9]|
              [68][1-8]
            )1
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3,12})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            [24-6]|
            3(?:
              3(?:
                0[1-467]|
                2[127-9]|
                3[124578]|
                7[1257-9]|
                8[1256]|
                9[145]
              )|
              4(?:
                2[135]|
                4[13578]|
                9[1346]
              )|
              5(?:
                0[14]|
                2[1-3589]|
                6[1-4]|
                7[13468]|
                8[13568]
              )|
              6(?:
                2[1-489]|
                3[124-6]|
                6[13]|
                7[12579]|
                8[1-356]|
                9[135]
              )|
              7(?:
                2[1-7]|
                4[145]|
                6[1-5]|
                7[1-4]
              )|
              8(?:
                21|
                3[1468]|
                6|
                7[1467]|
                8[136]
              )|
              9(?:
                0[12479]|
                2[1358]|
                4[134679]|
                6[1-9]|
                7[136]|
                8[147]|
                9[1468]
              )
            )|
            70[2-8]|
            8(?:
              0[2-9]|
              [1-8]
            )|
            90[7-9]|
            [79][1-9]|
            3[68]4[1347]|
            3(?:
              47|
              60
            )[1356]|
            3(?:
              3[46]|
              46|
              5[49]
            )[1246]|
            3[4579]3[1357]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{2,11})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '138',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '3',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{2,10})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '181',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{5,11})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            1(?:
              3|
              80
            )|
            9
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d)(\\d{4,10})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '1[67]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{7,8})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '8',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{7,12})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '18500',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{6})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '7',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '18[68]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{7})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '15[0568]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{6})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '15[1279]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{7})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '18',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{8})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            1(?:
              6[023]|
              7
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{7,8})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '15[279]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{7})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '15',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{8})'
                }
              ];

my $validators = {
                'fixed_line' => '
          32\\d{9,11}|
          49[3-6]\\d{10}|
          49[0-7]\\d{3,9}|
          (?:
            [34]0|
            [68]9
          )\\d{3,13}|
          (?:
            2(?:
              0[1-689]|
              [1-3569]\\d|
              4[0-8]|
              7[1-7]|
              8[0-7]
            )|
            3(?:
              [3569]\\d|
              4[0-79]|
              7[1-7]|
              8[1-8]
            )|
            4(?:
              1[02-9]|
              [2-48]\\d|
              5[0-6]|
              6[0-8]|
              7[0-79]
            )|
            5(?:
              0[2-8]|
              [124-6]\\d|
              [38][0-8]|
              [79][0-7]
            )|
            6(?:
              0[02-9]|
              [1-358]\\d|
              [47][0-8]|
              6[1-9]
            )|
            7(?:
              0[2-8]|
              1[1-9]|
              [27][0-7]|
              3\\d|
              [4-6][0-8]|
              8[0-5]|
              9[013-7]
            )|
            8(?:
              0[2-9]|
              1[0-79]|
              2\\d|
              3[0-46-9]|
              4[0-6]|
              5[013-9]|
              6[1-8]|
              7[0-8]|
              8[0-24-6]
            )|
            9(?:
              0[6-9]|
              [1-4]\\d|
              [589][0-7]|
              6[0-8]|
              7[0-467]
            )
          )\\d{3,12}
        ',
                'geographic' => '
          32\\d{9,11}|
          49[3-6]\\d{10}|
          49[0-7]\\d{3,9}|
          (?:
            [34]0|
            [68]9
          )\\d{3,13}|
          (?:
            2(?:
              0[1-689]|
              [1-3569]\\d|
              4[0-8]|
              7[1-7]|
              8[0-7]
            )|
            3(?:
              [3569]\\d|
              4[0-79]|
              7[1-7]|
              8[1-8]
            )|
            4(?:
              1[02-9]|
              [2-48]\\d|
              5[0-6]|
              6[0-8]|
              7[0-79]
            )|
            5(?:
              0[2-8]|
              [124-6]\\d|
              [38][0-8]|
              [79][0-7]
            )|
            6(?:
              0[02-9]|
              [1-358]\\d|
              [47][0-8]|
              6[1-9]
            )|
            7(?:
              0[2-8]|
              1[1-9]|
              [27][0-7]|
              3\\d|
              [4-6][0-8]|
              8[0-5]|
              9[013-7]
            )|
            8(?:
              0[2-9]|
              1[0-79]|
              2\\d|
              3[0-46-9]|
              4[0-6]|
              5[013-9]|
              6[1-8]|
              7[0-8]|
              8[0-24-6]
            )|
            9(?:
              0[6-9]|
              [1-4]\\d|
              [589][0-7]|
              6[0-8]|
              7[0-467]
            )
          )\\d{3,12}
        ',
                'mobile' => '
          15[0-25-9]\\d{8}|
          1(?:
            6[023]|
            7\\d
          )\\d{7,8}
        ',
                'pager' => '
          16(?:
            4\\d{1,10}|
            [89]\\d{1,11}
          )
        ',
                'personal_number' => '700\\d{8}',
                'specialrate' => '(
          180\\d{5,11}|
          13(?:
            7[1-6]\\d\\d|
            8
          )\\d{4}
        )|(
          (?:
            137[7-9]|
            900(?:
              [135]|
              9\\d
            )
          )\\d{6}
        )|(
          18(?:
            1\\d{5,11}|
            [2-9]\\d{8}
          )
        )',
                'toll_free' => '800\\d{7,12}',
                'voip' => ''
              };
my %areanames = ();
$areanames{de} = {"495053", "Faßberg\-Müden",
"4936484", "Knau\ bei\ Pößneck",
"49911", "Nürnberg",
"4935240", "Tauscha\ bei\ Großenhain",
"497351", "Biberach\ an\ der\ Riß",
"494684", "Langeneß\ Hallig",
"499636", "Plößberg",
"498170", "Straßlach\-Dingharting",
"4934493", "Gößnitz\ Thüringen",
"493647", "Pößneck",
"4938234", "Born\ Darß",
"495384", "Seesen\-Groß\ Rhüden",
"497162", "Süßen",
"495064", "Groß\ Düngen",
"4935248", "Schönfeld\ bei\ Großenhain",
"495827", "Unterlüß",
"499567", "Seßlach\-Gemünda",
"499656", "Moosbach\ bei\ Vohenstrauß",
"498633", "Tüßling",
"4935753", "Großräschen",
"4989", "München",
"4939883", "Groß\ Dölln",
"496663", "Steinau\ an\ der\ Straße",
"497355", "Hochdorf\ Riß",
"496364", "Nußbach\ Pfalz",
"494509", "Groß\ Grönau",
"498367", "Roßhaupten\ Forggensee",
"498807", "Dießen\ am\ Ammersee",
"492203", "Köln\-Porz",
"494497", "Barßel\-Harkebrügge",
"4935726", "Groß\ Särchen",
"4939934", "Groß\ Plasten",
"496252", "Heppenheim\ Bergstraße",
"4934901", "Roßlau\ Elbe",
"498536", "Kößlarn",
"499135", "Heßdorf\ Mittelfrankenanken",
"4934445", "Stößen",
"4936072", "Weißenborn\-Lüderode",
"494483", "Ovelgönne\-Großenmeer",
"496321", "Neustadt\ an\ der\ Weinstraße",
"499141", "Weißenburg\ in\ Bayern",
"49221", "Köln",
"492339", "Sprockhövel\-Haßlinghausen",
"4936705", "Oberweißbach\ Thüringer\ Wald",
"4936949", "Obermaßfeld\-Grimmenthal",
"499242", "Gößweinstein",
"4935841", "Großschönau\ Sachsen",
"4939976", "Groß\ Bützin",
"4935952", "Großröhrsdorf\ OL",
"4935938", "Großpostwitz\ OL",};
$areanames{en} = {"492485", "Schleiden\-Dreiborn",
"499306", "Kist",
"493386", "Premnitz",
"495022", "Wietzen",
"497055", "Neuweiler\ Kreis\ Calw",
"496532", "Zeltingen\-Rachtig",
"497472", "Rottenburg\ am\ Neckar",
"4936940", "Oepfershausen",
"496821", "Neunkirchen\ Saar",
"4933920", "Walsleben\ bei\ Neuruppin",
"492183", "Rommerskirchen",
"4937296", "Stollberg\ Erzgebirge",
"497736", "Tengen",
"49611", "Wiesbaden",
"492391", "Plettenberg",
"498753", "Elsendorf\ Niederbayern",
"499604", "Wernberg\-Köblitz",
"495026", "Steimbke",
"493382", "Lehnin",
"499302", "Rottendorf\ Unterfranken",
"497476", "Bisingen",
"496536", "Kleinich",
"4933769", "Töpchin",
"494171", "Winsen\ Luhe",
"499178", "Abenberg\ Mittelfranken",
"4935607", "Jänschwalde",
"4933232", "Brieselang",
"497732", "Radolfzell\ am\ Bodensee",
"4935021", "Königstein\ Sächsische\ Schweiz",
"49841", "Ingolstadt\ Donau",
"49234", "Bochum",
"496755", "Odernheim\ am\ Glan",
"496646", "Grebenau",
"494958", "Jemgum",
"493621", "Gotha\ Thüringen",
"4933435", "Rehfelde",
"4937384", "Wechselburg",
"499951", "Landau\ an\ der\ Isar",
"494443", "Dinklage",
"495947", "Laar\ Vechte",
"496036", "Wölfersheim",
"496642", "Schlitz",
"4933831", "Weseram",
"499427", "Leiblfing",
"496344", "Schwegenheim",
"495522", "Osterode\ am\ Harz",
"499083", "Möttingen",
"496032", "Bad\ Nauheim",
"497555", "Deggenhausertal",
"4939957", "Gielow",
"495831", "Wittingen",
"498252", "Schrobenhausen",
"499636", "Plössberg",
"4934672", "Rossleben",
"4933654", "Fünfeichen",
"496504", "Thalfang",
"4938425", "Kirchdorf\ Poel",
"497972", "Gschwend\ bei\ Gaildorf",
"492985", "Winterberg\-Niedersfeld",
"494482", "Hatten",
"4936845", "Gehlberg",
"4939403", "Gröningen\ Sachsen\-Anhalt",
"493969", "Siedenbollentin",
"495429", "Melle\-Wellingholzhausen",
"4938757", "Neustadt\-Glewe",
"497976", "Sulzbach\-Laufen",
"497181", "Schorndorf\ Württemberg",
"499334", "Giebelstadt",
"497233", "Niefern\-Öschelbronn",
"4934906", "Raguhn",
"496683", "Ehrenberg\ Rhön",
"4938456", "Langhagen\ bei\ Güstrow",
"499632", "Waldsassen",
"4938821", "Lüdersdorf",
"497704", "Geisingen\ Baden",
"499294", "Regnitzlosau",
"498139", "Röhrmoos",
"497393", "Munderkingen",
"4938373", "Katzow",
"496857", "Namborn",
"49261", "Koblenz\ am\ Rhein",
"494486", "Edewecht\-Friedrichsfehn",
"499542", "Schesslitz",
"4935341", "Bad\ Liebenwerda",
"499363", "Arnstein\ Unterfranken",
"497264", "Bad\ Rappenau",
"497124", "Trochtelfingen\ Hohenz",
"495447", "Lembruch",
"494943", "Grossefehn",
"4939087", "Jerchel\ Altmark",
"495661", "Melsungen",
"499451", "Schierling",
"494458", "Wiefelstede\-Spohle",
"499927", "Kirchberg\ Wald",
"4938222", "Semlow",
"4936205", "Gräfenroda",
"499546", "Burgebrach",
"496439", "Holzappel",
"497579", "Schwenningen\ Baden",
"499803", "Colmberg",
"493883", "Hagenow",
"498685", "Kirchanschöring",
"493562", "Forst\ Lausitz",
"496004", "Lich\-Eberstadt",
"4939753", "Strasburg",
"498170", "Strasslach\-Dingharting",
"4933932", "Fehrbellin",
"498171", "Wolfratshausen",
"4939206", "Eichenbarleben",
"495721", "Stadthagen",
"497031", "Böblingen",
"494753", "Balje",
"4937605", "Hartenstein\ Sachsen",
"4933679", "Wendisch\ Rietz",
"492255", "Euskirchen\-Flamersheim",
"4933743", "Blönsdorf",
"497641", "Emmendingen",
"4939722", "Sarnow\ bei\ Anklam",
"496445", "Schöffengrund",
"497467", "Neuhausen\ ob\ Eck",
"495244", "Rietberg",
"495592", "Gleichen\-Bremke",
"492844", "Rheinberg\-Orsoy",
"497531", "Konstanz",
"496471", "Weilburg",
"492682", "Hamm\ Sieg",
"497675", "Bernau\ Baden",
"4935792", "Ossling",
"492384", "Welver",
"495855", "Nahrendorf",
"497822", "Ettenheim",
"499497", "Seubersdorf\ in\ der\ Oberpfalz",
"493691", "Eisenach\ Thüringen",
"498443", "Hohenwart\ Paar",
"498145", "Mammendorf",
"496731", "Alzey",
"499935", "Stephansposching",
"4935775", "Pechern",
"497826", "Schuttertal",
"492686", "Weyerbusch",
"49441", "Oldenburg",
"495101", "Pattensen",
"4937322", "Brand\-Erbisdorf",
"499164", "Langenfeld\ Mittelfranken",
"497323", "Gerstetten",
"492564", "Vreden",
"494139", "Hohnstorf\ Elbe",
"4936967", "Geisa",
"494256", "Hilgermissen",
"4934206", "Rötha",
"498369", "Rückholz",
"493761", "Werdau\ Sachsen",
"492357", "Herscheid\ Westfalen",
"492643", "Altenahr",
"499741", "Bad\ Brückenau",
"4936927", "Unterellen",
"494748", "Stubben\ bei\ Bremerhaven",
"4937362", "Seiffen\ Erzgebirge",
"497967", "Jagstzell",
"498809", "Wessobrunn",
"4940", "Hamburg",
"4934722", "Preusslitz",
"494252", "Bruchhausen\-Vilsen",
"496158", "Riedstadt",
"49331", "Potsdam",
"499775", "Schönau\ an\ der\ Brend",
"496186", "Grosskrotzenburg",
"497194", "Spiegelberg",
"498458", "Gaimersheim",
"499280", "Selbitz\ Oberfranken",
"499133", "Baiersdorf\ Mittelfrankenanken",
"494288", "Horstedt\ Kreis\ Rotenburg",
"499281", "Hof\ Saale",
"496182", "Seligenstadt",
"49491", "Leer\ Ostfriesland",
"492064", "Dinslaken",
"499435", "Schwarzenfeld",
"492533", "Münster\-Nienberge",
"4935820", "Zodel",
"497042", "Vaihingen\ an\ der\ Enz",
"495691", "Bad\ Arolsen",
"4935453", "Drahnsdorf",
"499704", "Euerdorf",
"493596", "Neustadt\ in\ Sachsen",
"499393", "Rothenfels\ Unterfranken",
"497632", "Badenweiler",
"497949", "Pfedelbach\-Untersteinbach",
"492581", "Warendorf",
"496282", "Walldürn",
"499976", "Rötz",
"499181", "Neumarkt\ in\ der\ Oberpfalz",
"494188", "Welle\ Nordheide",
"499180", "Pyrbaum",
"499233", "Arzberg\ Oberfranken",
"497334", "Deggingen",
"493592", "Kirschau",
"497046", "Zaberfeld",
"499972", "Waldmünchen",
"4934244", "Mockrehna",
"496286", "Walldürn\-Rippberg",
"498347", "Friesenried",
"497636", "Münstertal\ Schwarzwald",
"492953", "Wünnenberg",
"4933983", "Gross\ Pankow\ Kreis\ Prignitz",
"497803", "Gengenbach",
"492448", "Hellenthal\-Rescheid",
"496742", "Boppard",
"496258", "Gernsheim",
"494152", "Geesthacht",
"497546", "Oberteuringen",
"49345", "Halle\ Saale",
"497451", "Horb\ am\ Neckar",
"4935931", "Königswartha",
"496655", "Neuhof\ Kreis\ Fulda",
"492524", "Ennigerloh",
"496746", "Pfalzfeld",
"494239", "Dörverden\-Westen",
"499264", "Küps",
"497363", "Lauchheim",
"4934639", "Wallendorf\ Luppe",
"497542", "Tettnang",
"493721", "Meinersdorf",
"4934606", "Teicha\ Sachsen\-Anhalt",
"4936074", "Worbis",
"494156", "Talkau",
"496783", "Baumholder",
"498245", "Türkheim\ Wertach",
"499732", "Hammelburg",
"4939349", "Parey\ Elbe",
"497302", "Pfaffenhofen\ an\ der\ Roth",
"495201", "Halle\ Westfalen",
"49271", "Siegen",
"497449", "Baiersbronn\-Obertal",
"49531", "Braunschweig",
"498038", "Vogtareuth",
"499736", "Oberthulba",
"4936330", "Grossberndten",
"497583", "Bad\ Schussenried",
"497306", "Vöhringen\ Iller",
"4939244", "Steutz",
"499472", "Hohenfels\ Oberpfalz",
"4937752", "Eibenstock",
"492360", "Haltern\-Lippramsdorf",
"492948", "Lippstadt\-Rebbeke",
"492361", "Recklinghausen",
"497083", "Bad\ Herrenalb",
"4936738", "Königsee",
"492453", "Heinsberg\-Randerath",
"499555", "Schlüsselfeld\-Aschbach",
"498785", "Rottenburg\-Oberroning",
"498538", "Pocking\-Hartkirchen",
"498507", "Neuburg\ am\ Inn",
"496243", "Monsheim",
"495144", "Wathlingen",
"497427", "Schömberg\ bei\ Balingen",
"4939972", "Walkendorf",
"4936640", "Remptendorf",
"4933053", "Zehlendorf\ Kreis\ Oberhavel",
"498271", "Meitingen",
"492801", "Xanten",
"497950", "Schnelldorf",
"497951", "Crailsheim",
"49395", "Neubrandenburg",
"4939995", "Nossendorf",
"495761", "Stolzenau",
"4939606", "Glienke",
"4933084", "Gutengermendorf",
"492246", "Lohmar\ Rheinland",
"495358", "Bahrdorf\-Mackendorf",
"4933337", "Altkünkendorf",
"494347", "Flintbek",
"4936605", "Bad\ Köstritz",
"493522", "Grossenhain\ Sachsen",
"498573", "Ering",
"493831", "Stralsund",
"497741", "Tiengen\ Hochrhein",
"496456", "Haina\ Kloster",
"4934363", "Cavertitz",
"496541", "Traben\-Trarbach",
"4934492", "Lucka",
"4936042", "Tonna",
"492242", "Hennef\ Sieg",
"492758", "Bad\ Berleburg\-Girkhausen",
"495621", "Bad\ Wildungen",
"496452", "Battenberg\ Eder",
"493947", "Thale",
"497164", "Boll\ Kreis\ Göppingen",
"499323", "Iphofen",
"497224", "Gernsbach",
"496631", "Alsfeld",
"495684", "Frielendorf",
"497435", "Albstadt\-Laufen",
"496630", "Schwalmtal\-Storndorf",
"496575", "Landscheid",
"494329", "Langwedel\ Holstein",
"497133", "Lauffen\ am\ Neckar",
"4934295", "Krensitz",
"495382", "Bad\ Gandersheim",
"496041", "Glauburg",
"492594", "Dülmen",
"499194", "Ebermannstadt",
"498239", "Langenneufnach",
"495842", "Schnega",
"495503", "Nörten\-Hardenberg",
"498073", "Gars\ am\ Inn",
"498152", "Herrsching\ am\ Ammersee",
"495846", "Gartow\ Niedersachsen",
"499659", "Leuchtenberg",
"497775", "Mühlingen",
"499467", "Michelsneukirchen",
"495657", "Meissner",
"499641", "Grafenwöhr",
"4935265", "Glaubitz",
"4933088", "Falkenthal",
"4939363", "Angern",
"495883", "Lemgow",
"495562", "Dassel\-Markoldendorf",
"496059", "Jossgrund",
"4938305", "Gingst",
"493447", "Altenburg\ Thüringen",
"492743", "Daaden",
"4936734", "Leutenberg",
"4939323", "Schönhausen\ Elbe",
"494245", "Neuenkirchen\ bei\ Bassum",
"493661", "Greiz",
"4939295", "Zuchau",
"495066", "Sarstedt",
"496301", "Otterbach\ Pfalz",
"497935", "Schrozberg",
"499826", "Weidenbach\ Mittelfranken",
"4939248", "Dobritz",
"4933632", "Hangelsberg",
"4935207", "Moritzburg",
"494854", "Friedrichskoog",
"496559", "Leidenborn",
"499278", "Weidenberg",
"494271", "Sulingen",
"4938327", "Elmenhorst\ Vorpom",
"496861", "Merzig",
"492131", "Neuss",
"499822", "Bechhofen\ an\ der\ Heide",
"499531", "Ebern",
"495062", "Holle\ bei\ Hildesheim",
"499675", "Altendorf\ am\ Nabburg",
"49621", "Mannheim",
"4933979", "Wusterhausen\ Dosse",
"4939062", "Bebertal",
"498784", "Hohenthann",
"495145", "Beedenbostel",
"499367", "Unterpleichfeld",
"495443", "Lemförde",
"494526", "Ascheberg\ Holstein",
"494947", "Aurich\-Ogenbargen",
"492154", "Willich",
"499554", "Untersteinbach\ Unterfranken",
"494522", "Plön",
"496568", "Wolsfeld",
"494830", "Süderhastedt",
"4934342", "Neukieritzsch",
"498592", "Wegscheid\ Niederbayern",
"4936023", "Horsmar",
"499923", "Teisnach",
"494929", "Ihlow\ Kreis\ Aurich",
"496400", "Mücke",
"496401", "Grünberg\ Hessen",
"496068", "Beerfelden",
"498092", "Grafing\ bei\ München",
"4934632", "Mücheln\ Geiseltal",
"495171", "Peine",
"4938333", "Horst\ bei\ Grimmen",
"496853", "Marpingen",
"4935608", "Gross\ Ossnig",
"4935385", "Annaburg",
"4934979", "Wulfen\ Sachsen\-Anhalt",
"498721", "Eggenfelden",
"493329", "Stahnsdorf",
"497237", "Neulingen\ Enzkreis",
"494791", "Osterholz\-Scharmbeck",
"494447", "Vechta\-Langförden",
"4936924", "Mihla",
"4937436", "Weischlitz",
"495943", "Emlichheim",
"4933475", "Letschin",
"494661", "Niebüll",
"4939088", "Letzlingen",
"495458", "Hopsten",
"4933363", "Altenhof\ Kreis\ Barnim",
"496356", "Carlsberg\ Pfalz",
"4938875", "Schlagsdorf\ bei\ Gadebusch",
"4939342", "Gladau",
"4936964", "Dermbach\ Rhön",
"499087", "Marktoffingen",
"499423", "Geiselhöring",
"492525", "Beckum\-Neubeckum",
"496654", "Gersfeld\ Rhön",
"499265", "Pressig",
"496352", "Kirchheimbolanden",
"495482", "Tecklenburg",
"4938758", "Dömitz",
"497335", "Wiesensteig",
"496848", "Homburg\-Einöd",
"494855", "Eddelak",
"497934", "Weikersheim",
"497402", "Fluorn\-Winzeln",
"499376", "Collenberg",
"493573", "Senftenberg",
"4935604", "Krieschow",
"492508", "Drensteinfurt",
"49541", "Osnabrück",
"4939030", "Brunau",
"494101", "Pinneberg",
"499372", "Klingenberg\ am\ Main",
"499674", "Schönsee",
"492353", "Halver",
"498026", "Hausham",
"492647", "Kesseling",
"499728", "Wülfershausen\ Unterfranken",
"494721", "Cuxhaven",
"492461", "Jülich",
"4935246", "Ziegenhain\ Sachsen",
"4939954", "Stavenhagen\ Reuterstadt",
"497327", "Dischingen",
"494244", "Harpstedt",
"497963", "Adelmannsfelden",
"498022", "Tegernsee",
"495753", "Auetal\-Bernsen",
"492595", "Olfen",
"499493", "Beratzhausen",
"499195", "Adelsdorf\ Mittelfranken",
"496574", "Hasborn",
"497434", "Winterlingen",
"495685", "Knüllwald",
"492852", "Hamminkeln",
"4933657", "Steinsdorf\ Brandenburg",
"4938783", "Dallmin",
"49591", "Lingen\ \(Ems\)",
"497774", "Eigeltingen",
"496129", "Schlangenbad",
"496269", "Gundelsheim\ Württemberg",
"498661", "Grabenstätt\ Chiemsee",
"492856", "Hamminkeln\-Brünen",
"4938754", "Leussow\ bei\ Ludwigslust",
"497906", "Braunsbach",
"492961", "Brilon",
"496709", "Fürfeld\ Kreis\ Bad\ Kreuznach",
"4934954", "Roitzsch\ bei\ Bitterfeld",
"4933972", "Breddin",
"497628", "Efringen\-Kirchen",
"495139", "Burgwedel",
"4936968", "Rossdorf\ Rhön",
"497463", "Mühlheim\ an\ der\ Donau",
"496147", "Trebur",
"496074", "Rödermark",
"4939053", "Süplingen",
"49335", "Frankfurt\ \(Oder\)",
"497351", "Biberach\ an\ der\ Riss",
"495252", "Bad\ Lippspringe",
"497165", "Göppingen\-Hohenstaufen",
"497225", "Gaggenau",
"499873", "Abenberg\-Wassermungenau",
"4936928", "Neuenhof\ Thüringen",
"4933606", "Müllrose",
"494757", "Wanna",
"494499", "Barssel",
"4939084", "Lindstedt",
"497265", "Angelbachtal",
"497125", "Bad\ Urach",
"495152", "Hessisch\ Oldendorf",
"498386", "Oberstaufen",
"498503", "Neuhaus\ am\ Inn",
"495073", "Neustadt\-Esperke",
"496247", "Worms\-Pfeddersheim",
"497423", "Oberndorf\ am\ Neckar",
"4939932", "Malchow\ bei\ Waren",
"4933239", "Gross\ Behnitz",
"4933762", "Zeuthen",
"498469", "Freystadt\-Burggriesbach",
"498846", "Uffing\ am\ Staffelsee",
"4933206", "Fichtenwalde",
"4936701", "Lichte",
"498382", "Lindau\ Bodensee",
"4933334", "Greiffenberg",
"4939743", "Zerrenthin",
"498684", "Fridolfing",
"495156", "Coppenbrügge",
"492921", "Soest",
"497668", "Ihringen",
"4936742", "Uhlstädt",
"496229", "Neckarsteinach",
"492839", "Straelen\-Herongen",
"49341", "Leipzig",
"496787", "Niederbrombach",
"496505", "Kordel",
"498621", "Trostberg",
"492984", "Hallenberg",
"4936624", "Teichwolframsdorf",
"497705", "Wolterdingen\ Schwarzw",
"497587", "Hosskirch",
"499295", "Töpen",
"4933846", "Dippmannsdorf",
"4936370", "Grossenehrich",
"499335", "Aub\ Kreis\ Würzburg",
"495573", "Uslar\-Volpriehausen",
"4936451", "Buttelstedt",
"4934658", "Hayn\ Harz",
"498062", "Bruckmühl\ Mangfall",
"4935844", "Oybin\ Kurort",
"494144", "Himmelpforten",
"4930", "Berlin",
"497807", "Neuried\ Ortenaukreis",
"497838", "Nordrach",
"492957", "Wünnenberg\-Haaren",
"496754", "Martinstein",
"4936737", "Drognitz",
"4937343", "Jöhstadt",
"492421", "Düren",
"494761", "Bremervörde",
"4934743", "Ermsleben",
"497554", "Heiligenberg\ Baden",
"498066", "Bad\ Feilnbach",
"497367", "Aalen\-Ebnat",
"4935971", "Sebnitz",
"496345", "Albersweiler",
"49391", "Magdeburg",
"499208", "Bindlach",
"4938229", "Bad\ Sülze",
"492484", "Mechernich\-Eiserfey",
"499397", "Wertheim\-Dertingen",
"497054", "Wildberg\ Württemberg",
"496371", "Landstuhl",
"4938732", "Gallin\ bei\ Lübz",
"498657", "Ramsau\ bei\ Berchtesgaden",
"498343", "Aitrang",
"498562", "Triftern",
"4935204", "Wilsdruff",
"49431", "Kiel",
"493685", "Hildburghausen",
"499605", "Weiherhammer",
"4938324", "Velgast",
"4934461", "Nebra\ Unstrut",
"499906", "Mariaposching",
"494842", "Nordstrand",
"4933672", "Pfaffendorfb\ Beeskow",
"4934654", "Stolberg\ Harz",
"494684", "Langeness\ Hallig",
"499774", "Oberelsbach",
"495329", "Schulenberg\ im\ Oberharz",
"492991", "Marsberg\-Bredelar",
"494382", "Wangels",
"494846", "Hattstedt",
"494469", "Wangerooge",
"492065", "Duisburg\-Rheinhausen",
"4936628", "Zeulenroda",
"499434", "Bodenwöhr",
"497195", "Winnenden",
"494503", "Timmendorfer\ Strand",
"499351", "Gemünden\ am\ Main",
"4933338", "Stolpe\/Oder",
"499350", "Eussenheim\-Hundsbach",
"499165", "Sugenheim",
"499225", "Stadtsteinach",
"494358", "Loose\ bei\ Eckernförde",
"499463", "Wald\ Oberpfalz",
"492565", "Gronau\-Epe",
"495653", "Sontra",
"495347", "Burgdorf\ bei\ Salzgitter",
"4936077", "Grossbodungen",
"496339", "Grosssteinhausen",
"499628", "Ursensollen",
"494621", "Schleswig",
"493443", "Weissenfels\ Sachsen\-Anhalt",
"492747", "Molzhain",
"4939831", "Feldberg",
"4937369", "Wolkenstein",
"4935208", "Radeburg",
"497674", "Todtmoos",
"4934920", "Kropstädt",
"495854", "Bleckede\-Barskamp",
"492385", "Hamm\-Rhynern",
"499406", "Mintraching",
"4938328", "Miltzow",
"495271", "Höxter",
"4939825", "Wokuhl",
"4939247", "Güterglück",
"498761", "Moosburg\ an\ der\ Isar",
"492845", "Neukirchen\-Vluyn",
"499402", "Regenstauf",
"4939421", "Osterwieck",
"497376", "Langenenslingen",
"4937329", "Grosshartmannsdorf",
"499349", "Werbach\-Wenkheim",
"498144", "Grafrath",
"496028", "Sulzbach\ am\ Main",
"495507", "Ebergötzen",
"4939856", "Beenz\ bei\ Prenzlau",
"494883", "Süderstapel",
"49831", "Kempten\ Allgäu",
"494562", "Grömitz",
"494343", "Laboe",
"499963", "Konzell",
"4935872", "Neusalza\-Spremberg",
"495648", "Brakel\-Gehrden",
"4933087", "Bredereiche",
"493943", "Wernigerode",
"496444", "Bischoffen",
"495245", "Herzebrock\-Clarholz",
"4938720", "Grebbin",
"497728", "Niedereschach",
"492871", "Bocholt",
"4935895", "Klitten",
"492254", "Weilerswist",
"495677", "Calden\-Westuffeln",
"496704", "Langenlonsheim",
"492938", "Ense",
"496393", "Fischbach\ bei\ Dahn",
"497683", "Simonswald",
"4936965", "Stadtlengsfeld",
"496181", "Hanau",
"499282", "Naila",
"498548", "Vilshofen\-Sandbach",
"496233", "Frankenthal\ Pfalz",
"492823", "Goch",
"4938874", "Lützow",
"497504", "Horgenzell",
"499286", "Oberkotzau",
"4933474", "Neutrebbin",
"498424", "Nassenfels",
"494494", "Bösel\ Oldenburg",
"4936925", "Marksuhl",
"49212", "Solingen",
"499742", "Kalbach\ Rhön",
"4937341", "Ehrenfriedersdorf",
"494874", "Todenbüttel",
"494251", "Hoya",
"498395", "Tannheim\ Württemberg",
"493925", "Stassfurt",
"499746", "Zeitlofs",
"499655", "Tännesberg",
"495465", "Neuenkirchen\ bei\ Bramsche",
"496264", "Neudenau",
"496124", "Bad\ Schwalbach",
"495223", "Bünde",
"495163", "Fallingbostel\-Dorfmark",
"4935973", "Stolpen",
"4934741", "Frose",
"493762", "Crimmitschau",
"498638", "Waldkraiburg",
"492407", "Herzogenrath\-Kohlscheid",
"494673", "Joldelund",
"496732", "Wörrstadt",
"493394", "Wittstock\ Dosse",
"495378", "Sassenburg\-Platendorf",
"495102", "Laatzen",
"496476", "Mengerskirchen",
"498553", "Spiegelau",
"49711", "Stuttgart",
"4936453", "Mellingen",
"494249", "Bassum\-Nordwohlde",
"496736", "Bechenheim",
"497821", "Lahr\ Schwarzwald",
"4936484", "Knau\ bei\ Pössneck",
"492680", "Mündersbach",
"4937607", "Ebersbrunn\ Sachsen",
"492778", "Siegbach",
"4936376", "Straussfurt",
"496055", "Freigericht",
"4939452", "Ilsenburg",
"492681", "Altenkirchen\ Westerwald",
"497532", "Meersburg",
"496472", "Weilmünster",
"498176", "Egling\ bei\ Wolfratshausen",
"497032", "Herrenberg",
"492624", "Höhr\-Grenzhausen",
"4936703", "Gräfenthal",
"496555", "Bleialf",
"4933200", "Bergholz\-Rehbrücke",
"497344", "Blaubeuren",
"499243", "Pottenstein",
"4935384", "Steinsdorf\ bei\ Jessen",
"495726", "Wiedensahl",
"4939266", "Förderstedt",
"497642", "Endingen\ Kaiserstuhl",
"497939", "Schrozberg\-Spielbach",
"498868", "Schwabsoien",
"4935476", "Wittmannsdorf\-Bückchen",
"494167", "Apensen",
"495965", "Klein\ Berssen",
"498053", "Bad\ Endorf",
"493425", "Wurzen",
"495722", "Bückeburg",
"4939226", "Hohenziatz",
"497755", "Weilheim\ Kreis\ Waldshut",
"497646", "Weisweil\ Breisgau",
"4939741", "Jatznick",
"498337", "Altenstadt\ Iller",
"4938755", "Eldena",
"4935322", "Doberlug\-Kirchhain",
"497945", "Wüstenrot",
"497158", "Neuhausen\ auf\ den\ Fildern",
"4938202", "Volkenshagen",
"4936847", "Steinbach\-Hallenberg",
"492764", "Welschen\ Ennest",
"493561", "Guben",
"4938427", "Blowatz",
"495804", "Rätzlingen\ Kreis\ Uelzen",
"4938726", "Spornitz",
"4935362", "Schönewalde\ bei\ Herzberg",
"4936256", "Wechmar",
"495662", "Felsberg\ Hessen",
"499452", "Langquaid",
"499075", "Glött",
"496323", "Edenkoben",
"495364", "Velpke",
"499631", "Tirschenreuth",
"4933478", "Gross\ Neuendorf",
"492473", "Simmerath",
"499575", "Weismain",
"4939085", "Zichtau",
"494638", "Tarp",
"494607", "Janneby",
"4936462", "Ossmannstedt",
"492175", "Leichlingen\ Rheinland",
"495333", "Dettum",
"4934926", "Pretzsch\ Elbe",
"497182", "Welzheim",
"495293", "Paderborn\-Dahl",
"4939392", "Rönnebeck\ Sachsen\-Anhalt",
"4936422", "Reinstädt\ Thüringen",
"497971", "Gaildorf",
"492204", "Bensberg",
"4934955", "Gossa",
"498251", "Aichach",
"498325", "Oberstaufen\-Thalkirchdorf",
"498250", "Hilgertshausen\-Tandern",
"496659", "Eichenzell",
"494235", "Langwedel\-Etelsen",
"4939423", "Wegeleben",
"494481", "Hatten\-Sandkrug",
"4938842", "Lüttenmark",
"493437", "Grimma",
"4936207", "Plaue\ Thüringen",
"492733", "Hilchenbach",
"494480", "Ovelgönne\-Strückhausen",
"496467", "Hatzfeld\ Eder",
"497143", "Besigheim",
"494924", "Moormerland\-Oldersum",
"4938859", "Alt\ Zachun",
"496641", "Lauterbach\ Hessen",
"497445", "Pfalzgrafenweiler",
"498249", "Ettringen\ Wertach",
"495832", "Hankensbüttel",
"499956", "Eichendorf\-Aufhausen",
"496031", "Friedberg\ Hessen",
"495520", "Braunlage",
"495084", "Hambühren",
"495521", "Herzberg\ am\ Harz",
"494553", "Geschendorf",
"4935388", "Klöden",
"4935605", "Komptendorf",
"495836", "Wittingen\-Radenbeck",
"499952", "Eichendorf",
"493622", "Waltershausen\ Thüringen",
"4939833", "Mirow\ Kreis\ Neustrelitz",
"4939926", "Grabowhöfe",
"494337", "Jevenstedt",
"494308", "Schwedeneck",
"493381", "Brandenburg\ an\ der\ Havel",
"492973", "Eslohe\ Sauerland",
"492236", "Wesseling\ Rheinland",
"4933437", "Reichenberg\ bei\ Strausberg",
"496826", "Bexbach",
"495603", "Gudensberg",
"494297", "Ottersberg\-Posthausen",
"493841", "Wismar",
"497731", "Singen\ Hohentwiel",
"492159", "Meerbusch\-Osterath",
"4934463", "Bad\ Kösen",
"494172", "Salzhausen",
"498167", "Zolling",
"4939955", "Jürgenstorf",
"499861", "Rothenburg\ ob\ der\ Tauber",
"492232", "Brühl\ Rheinland",
"497471", "Hechingen",
"496531", "Bernkastel\-Kues",
"495021", "Nienburg\ Weser",
"496675", "Breitenbach\ am\ Herzberg",
"495584", "Hattorf\ am\ Harz",
"493937", "Osterburg\ Altmark",
"49921", "Bayreuth",
"4933093", "Fürstenberg\ Havel",
"492392", "Werdohl",
"494176", "Marschacht",
"4934423", "Heuckewalde",
"492694", "Wershofen",
"496583", "Palzem",
"496306", "Trippstadt",
"499532", "Maroldsweisach",
"495060", "Bodenburg",
"492132", "Meerbusch\-Büderich",
"499820", "Lehrberg",
"494828", "Lägerdorf",
"49251", "Münster",
"492377", "Wickede\ Ruhr",
"4935267", "Diesbar\-Seusslitz",
"495437", "Menslage",
"494276", "Borstel\ bei\ Sulingen",
"49911", "Nuremberg",
"494933", "Dornum\ Ostfriesland",
"496866", "Perl\-Nennig",
"498085", "Sankt\ Wolfgang",
"4939776", "Hintersee",
"496449", "Ehringshausen\-Katzenfurt",
"495777", "Diepenau\-Essern",
"496302", "Winnweiler",
"499536", "Kirchlauter",
"494272", "Siedenburg",
"498267", "Dirlewang",
"4938307", "Poseritz",
"4938293", "Kühlungsborn\ Ostseebad",
"4938325", "Rolofshagen",
"4935752", "Ruhland",
"4933361", "Joachimsthal",
"4935205", "Ottendorf\-Okrilla",
"499646", "Freihung",
"4937430", "Eichigt",
"495859", "Thomasburg",
"498707", "Adlkofen",
"4939828", "Wustrow\ Kreis\ Mecklenburg\-Strelitz",
"498585", "Grainet",
"493364", "Eisenhüttenstadt",
"4939297", "Eickendorf\ Kreis\ Schönebeck",
"4933873", "Grosswudicke",
"4938356", "Behrenhoff",
"49201", "Essen",
"499642", "Kemnath\ Stadt",
"494964", "Rhede\ Ems",
"497243", "Ettlingen",
"499344", "Gerchsheim",
"496427", "Cölbe\-Schönstadt",
"495561", "Einbeck",
"496083", "Weilrod",
"498365", "Wertach",
"498151", "Starnberg",
"496636", "Romrod",
"492104", "Mettmann",
"499504", "Stadelhofen",
"494433", "Dötlingen",
"4936607", "Niederpöllnitz",
"492678", "Büchel\ bei\ Cochem",
"495937", "Geeste\-Gross\ Hesepe",
"495908", "Wietmarschen\-Lohne",
"496046", "Ortenberg\ Hessen",
"4933335", "Pinnow\ Kreis\ Uckermark",
"494135", "Kirchgellersen",
"498805", "Hohenpeissenberg",
"495381", "Seesen",
"496334", "Thaleischweiler\-Fröschen",
"492275", "Kerpen\-Buir",
"499683", "Friedenfels",
"494773", "Lamstedt",
"493603", "Bad\ Langensalza",
"4934776", "Rothenschirmbach",
"495840", "Schnackenburg",
"495841", "Lüchow\ Wendland",
"496294", "Krautheim\ Jagst",
"4938331", "Rakow\ Vorpom",
"495193", "Schneverdingen",
"495495", "Vörden\ Kreis\ Vechta",
"496042", "Büdingen\ Hessen",
"499857", "Schopfloch\ Mittelfranken",
"492241", "Siegburg",
"496542", "Bullay",
"495324", "Vienenburg",
"4934297", "Liebertwolkwitz",
"496363", "Niederkirchen",
"499779", "Nordheim\ von\ der\ Rhön",
"495875", "Emmendorf",
"496451", "Frankenberg\ Eder",
"495622", "Fritzlar",
"493836", "Wolgast",
"497655", "Feldberg\-Altglashütten",
"497746", "Wutöschingen",
"494464", "Wittmund\-Carolinensiel",
"492724", "Finnentrop\-Serkenrode",
"4936625", "Langenwetzendorf",
"497258", "Oberderdingen\-Flehingen",
"499439", "Neunburg\-Kemnath",
"4936021", "Schlotheim",
"496803", "Mandelbachtal\-Ommersheim",
"495626", "Bad\ Zwesten",
"497742", "Klettgau",
"4939882", "Gollin",
"493521", "Meissen",
"497952", "Gerabronn",
"492366", "Herten\ Westfalen",
"495925", "Wietmarschen",
"492802", "Alpen",
"494127", "Westerhorn",
"498272", "Wertingen",
"494267", "Lauenbrück",
"4939824", "Hohenzieritz",
"492664", "Rennerod",
"498276", "Baar\ Schwaben",
"492362", "Dorsten",
"492543", "Billerbeck\ Westfalen",
"499445", "Neustadt\ an\ der\ Donau",
"495766", "Rehburg\-Loccum",
"4939051", "Calvörde",
"499143", "Pappenheim\ Mittelfranken",
"494149", "Fredenbeck",
"4935894", "Hähnichen",
"492043", "Gladbeck",
"4937422", "Markneukirchen",
"49721", "Karlsruhe",
"499471", "Burglengenfeld",
"4937207", "Hainichen\ Sachsen",
"494478", "Cappeln\ Oldenburg",
"495206", "Bielefeld\-Jöllenbeck",
"492633", "Brohl\-Lützing",
"4937462", "Rothenkirchen\ Vogtland",
"493677", "Ilmenau\ Thüringen",
"4939997", "Jarmen",
"494707", "Langen\-Neuenwalde",
"4938781", "Mellen",
"497300", "Roggenburg",
"4935696", "Briesnig",
"495202", "Oerlinghausen",
"495123", "Schellerten",
"495263", "Barntrup",
"492834", "Straelen",
"496164", "Reichelsheim\ Odenwald",
"496224", "Sandhausen\ Baden",
"495425", "Borgholzhausen",
"4938797", "Karstädt\ Kreis\ Prignitz",
"497452", "Nagold",
"4935723", "Bernsdorf\ OL",
"493965", "Burow\ bei\ Altentreptow",
"498773", "Neufahrn\ in\ Niederbayern",
"493722", "Limbach\-Oberfrohna",
"497541", "Friedrichshafen",
"4935240", "Tauscha\ bei\ Grossenhain",
"494805", "Schafstedt",
"496741", "St\ Goar",
"498135", "Sulzemoos",
"497456", "Haiterbach",
"498433", "Königsmoos",
"492558", "Horstmar",
"499945", "Arnbruck",
"494151", "Schwarzenbek",
"493726", "Flöha",
"499158", "Offenhausen\ Mittelfranken",
"494365", "Heringsdorf\ Holstein",
"492058", "Wülfrath",
"495696", "Bad\ Arolsen\-Landau",
"496775", "Strüth\ Taunus",
"493591", "Bautzen",
"492586", "Beelen",
"492303", "Unna",
"498464", "Dietfurt\ an\ der\ Altmühl",
"49906", "Donauwörth",
"499971", "Cham",
"499186", "Lauterhofen\ Oberpfalz",
"495703", "Hille",
"4939036", "Binde",
"495692", "Wolfhagen",
"493378", "Ludwigsfelde",
"497041", "Mühlacker",
"4939009", "Badel",
"492863", "Velen",
"495234", "Horn\-Bad\ Meinberg",
"496133", "Oppenheim",
"499182", "Velburg",
"496281", "Buchen\ Odenwald",
"492582", "Everswinkel",
"497631", "Müllheim\ Baden",
"497575", "Messkirch",
"496435", "Wallmerod",
"495874", "Soltendieck",
"495250", "Delbrück\ Westfalen",
"495325", "Goslar\-Hahnenklee",
"495251", "Paderborn",
"497352", "Ochsenhausen",
"4935436", "Laasow\ bei\ Calau",
"497654", "Löffingen",
"4936646", "Tanna\ bei\ Schleiz",
"4938464", "Bernitt",
"498333", "Babenhausen\ Schwaben",
"497356", "Schemmerhofen",
"492962", "Olsberg",
"4936844", "Rohr\ Thüringen",
"4933051", "Nassenheide",
"4938424", "Bobitz",
"498057", "Aschau\-Sachrang",
"492725", "Lennestadt\-Oedingen",
"498293", "Welden\ bei\ Augsburg",
"494465", "Friedeburg\ Ostfriesland",
"494223", "Ganderkesee\-Bookholzberg",
"494163", "Horneburg\ Niederelbe",
"4939600", "Zwiedorf",
"4933655", "Grunow\ Kreis\ Oder\-Spree",
"499229", "Mainleus",
"498557", "Mauth",
"497388", "Pfronstetten",
"494134", "Embsen\ Kreis\ Lüneburg",
"498364", "Seeg",
"496698", "Schrecksbach",
"493585", "Löbau",
"499505", "Litzendorf",
"492403", "Eschweiler\ Rheinland",
"4936204", "Stotternheim",
"498662", "Siegsdorf\ Kreis\ Traunstein",
"4936336", "Klettenberg",
"496295", "Rosenberg\ Baden",
"495494", "Holdorf\ Niedersachsen",
"492851", "Rees",
"498666", "Teisendorf",
"496335", "Trulben",
"492274", "Elsdorf\ Rheinland",
"492850", "Rees\-Haldern",
"498584", "Breitenberg\ Niederbayern",
"498021", "Waakirchen",
"498020", "Weyarn",
"4933981", "Putlitz",
"497568", "Bad\ Wurzach\-Hauerz",
"492389", "Werne",
"492462", "Linnich",
"494722", "Cuxhaven\-Altenbruch",
"4934600", "Ostrau\ Saalkreis",
"495167", "Walsrode\-Westenholz",
"4935933", "Neschwitz",
"494965", "Surwold",
"499345", "Külsheim\ Baden",
"494102", "Ahrensburg",
"496237", "Maxdorf",
"492827", "Goch\-Hassum",
"4935826", "Königshain\ bei\ Görlitz",
"495673", "Immenhausen\ Hessen",
"492903", "Meschede\-Freienohl",
"496397", "Leimen\ Pfalz",
"4934785", "Sandersleben",
"4935451", "Dahme\ Brandenburg",
"499371", "Miltenberg",
"497853", "Kehl\-Bodersweier",
"4939889", "Boitzenburg",
"4933434", "Herzfelde\ bei\ Strausberg",
"494106", "Quickborn\ Kreis\ Pinneberg",
"4937608", "Waldenburg\ Sachsen",
"498084", "Taufkirchen\ Vils",
"49340", "Dessau\ Anh",
"498223", "Ichenhausen",
"494293", "Ottersberg\-Fischerhude",
"498465", "Kipfenberg",
"492977", "Schmallenberg\-Bödefeld",
"496774", "Kaub",
"497269", "Sulzfeld\ Baden",
"497129", "Lichtenstein\ Württemberg",
"495607", "Fuldatal",
"4933477", "Trebnitz\ bei\ Müncheberg",
"494333", "Erfde",
"495235", "Blomberg\ Lippe",
"4936208", "Ermstedt",
"493933", "Genthin",
"495481", "Lengerich\ Westfalen",
"497574", "Gammertingen",
"496434", "Bad\ Camberg",
"4939361", "Lüderitz",
"4938428", "Hohenkirchen\ bei\ Wismar",
"494804", "Nordhastedt",
"496509", "Büdlich",
"494666", "Ladelund",
"496351", "Eisenberg\ Pfalz",
"496165", "Breuberg",
"492835", "Issum",
"497147", "Sachsenheim\ Württemberg",
"495424", "Bad\ Rothenfelde",
"493964", "Bredenfelde\ bei\ Strasburg",
"4936848", "Wernshausen",
"496628", "Oberaula",
"499339", "Ippesheim",
"494662", "Leck",
"498677", "Burghausen\ Salzach",
"4939321", "Arneburg",
"499944", "Miltach",
"494364", "Dahme\ Kreis\ Ostholstein",
"498134", "Odelzhausen",
"497709", "Wutach",
"494557", "Blunk",
"495053", "Fassberg\-Müden",
"496406", "Lollar",
"495172", "Ilsede",
"494792", "Worpswede",
"495308", "Lehre",
"495337", "Kissenbrück",
"4933438", "Altlandsberg",
"498722", "Gangkofen",
"4937604", "Mosel",
"493773", "Johanngeorgenstadt",
"494603", "Havetoft",
"496402", "Hungen",
"493433", "Borna\ Stadt",
"492737", "Netphen\-Deuz",
"495176", "Edemissen",
"496349", "Billigheim\-Ingenheim",
"498091", "Kirchseeon",
"498726", "Schönau\ Niederbayern",
"494796", "Teufelsmoor",
"498591", "Obernzell",
"4939002", "Oebisfelde",
"494832", "Meldorf",
"492268", "Kürten",
"499528", "Donnersdorf",
"4935774", "Boxberg\ Sachsen",
"4934361", "Dahlen\ Sachsen",
"494521", "Eutin",
"493464", "Sangerhausen",
"498106", "Vaterstetten",
"495924", "Bad\ Bentheim\-Gildehaus",
"498378", "Buchenberg\ bei\ Kempten",
"496327", "Neustadt\-Lachen",
"4934321", "Leisnig",
"499444", "Siegenburg",
"4938482", "Warin",
"494836", "Hennstedt\ Dithmarschen",
"495553", "Kalefeld",
"4935387", "Seyda",
"498102", "Höhenkirchen\-Siegertsbrunn",
"497345", "Langenau\ Württemberg",
"4939245", "Loburg",
"4939827", "Schwarz\ bei\ Neustrelitz",
"4939298", "Barby\ Elbe",
"498202", "Althegnenberg",
"492872", "Rhede\ Westfalen",
"496554", "Waxweiler",
"4935343", "Hirschfeld\ bei\ Elsterwerda",
"492625", "Ochtendung",
"494859", "Windbergen",
"494561", "Neustadt\ in\ Holstein",
"497754", "Görwihl",
"499568", "Neustadt\ bei\ Coburg",
"496838", "Saarwellingen",
"4939751", "Penkun",
"492228", "Remagen\-Rolandseck",
"495964", "Lähden",
"498206", "Egling\ an\ der\ Paar",
"4933085", "Seilershof",
"4935268", "Stauchitz",
"4939401", "Neuwegersleben",
"495276", "Marienmünster",
"4939994", "Metschow",
"494408", "Hude\ Oldenburg",
"495933", "Lathen",
"499401", "Neutraubling",
"493395", "Pritzwalk",
"498766", "Gammelsdorf",
"495828", "Himbergen",
"4938823", "Selmsdorf",
"4938308", "Göhren\ Rügen",
"497371", "Riedlingen\ Württemberg",
"495272", "Brakel\ Westfalen",
"499853", "Wilburgstetten",
"4938450", "Tarnow\ bei\ Bützow",
"4938371", "Karlshagen",
"496054", "Birstein",
"495197", "Soltau\-Frielingen",
"494777", "Cadenberge",
"498762", "Wartenberg\ Oberbayern",
"4937204", "Lichtenstein\ Sachsen",
"494324", "Brokstedt",
"494875", "Stafstedt",
"4934298", "Taucha\ bei\ Leipzig",
"498703", "Essenbach",
"494622", "Taarstedt",
"498394", "Lautrach",
"496668", "Birstein\-Lichenroth",
"4935023", "Bad\ Gottleuba",
"492599", "Ascheberg\-Herbern",
"4939459", "Hasselfelde",
"499356", "Burgsinn",
"498234", "Bobingen",
"499199", "Kunreuth",
"494626", "Treia",
"496087", "Waldems",
"4938794", "Cumlosen",
"499654", "Pleystein",
"497247", "Linkenheim\-Hochstetten",
"495464", "Alfhausen",
"496423", "Wetter\ Hessen",
"4933833", "Wollin\ bei\ Brandenburg",
"496265", "Billigheim\ Baden",
"499352", "Lohr\ am\ Main",
"495433", "Badbergen",
"499901", "Hengersberg\ Bayern",
"493981", "Neustrelitz",
"4936075", "Dingelstädt\ Eichsfeld",
"4933926", "Herzberg\ Mark",
"4936608", "Seelingstädt\ bei\ Gera",
"495135", "Burgwedel\-Fuhrberg",
"4936946", "Erbenhausen\ Thüringen",
"492373", "Menden\ Sauerland",
"493868", "Rastow",
"496587", "Zerf",
"497505", "Fronreute",
"499848", "Simmershofen",
"494841", "Husum\ Nordsee",
"494193", "Henstedt\-Ulzburg",
"498263", "Breitenbrunn\ Schwaben",
"494495", "Friesoythe\-Thüle",
"498123", "Moosinning",
"4933966", "Dranse",
"494381", "Lütjenburg",
"492992", "Marsberg",
"493337", "Biesenthal\ Brandenburg",
"497229", "Iffezheim",
"495773", "Stemwede\-Wehdem",
"4936735", "Probstzella",
"4937208", "Auerswalde",
"494206", "Stuhr\-Heiligenrode",
"492307", "Kamen",
"492338", "Breckerfeld",
"493494", "Wolfen",
"495149", "Wienhausen",
"4938304", "Garz\ Rügen",
"498561", "Pfarrkirchen\ Niederbayern",
"4938209", "Sanitz\ bei\ Rostock",
"492867", "Heiden\ Kreis\ Borken",
"4935329", "Dollenchen",
"496108", "Mühlheim\ am\ Main",
"492695", "Insul",
"494202", "Achim\ bei\ Bremen",
"4935264", "Strehla",
"496372", "Bruchmühlbach\-Miesau",
"4939998", "Loitz\ bei\ Demmin",
"495585", "Herzberg\-Sieber",
"495707", "Petershagen\ Weser",
"496674", "Friedewald\ Hessen",
"4939386", "Seehausen\ Altmark",
"4939399", "Kleinau",
"496728", "Ober\-Hilbersheim",
"492422", "Kreuzau",
"494762", "Kutenholz",
"495085", "Burgdorf\-Ehlershausen",
"494925", "Hinte",
"497444", "Alpirsbach",
"4935052", "Kipsdorf\ Kurort",
"495127", "Harsum",
"493874", "Ludwigslust",
"494766", "Basdahl",
"492426", "Nörvenich",
"498061", "Bad\ Aibling",
"497528", "Neukirch\ bei\ Tettnang",
"4939294", "Gross\ Rosenburg",
"493994", "Malchin",
"496195", "Kelkheim\ Taunus",
"495978", "Hörstel\-Dreierwalde",
"492637", "Weissenthurm",
"492608", "Welschneudorf",
"499574", "Marktzeuln",
"492174", "Burscheid\ Rheinland",
"494234", "Dörverden",
"492529", "Oelde\-Stromberg",
"499269", "Tettau\ Kreis\ Kronach",
"499129", "Wendelstein",
"4938852", "Wittenburg",
"4934386", "Dürrweitzschen\ bei\ Grimma",
"494394", "Bokhorst",
"498622", "Tacherting\-Peterskirchen",
"4936604", "Münchenbernsdorf",
"494703", "Loxstedt\-Donnern",
"492205", "Rösrath",
"4933452", "Neulewin",
"498324", "Hindelang",
"492922", "Werl",
"498380", "Achberg",
"498381", "Lindenberg\ im\ Allgäu",
"495805", "Oetzen",
"497944", "Kupferzell",
"4939200", "Gommern",
"494123", "Barmstedt",
"494263", "Scheessel",
"494425", "Wangerland\-Hooksiel",
"498193", "Geltendorf",
"4933702", "Wünsdorf",
"498841", "Murnau\ am\ Staffelsee",
"4936761", "Heubisch",
"499147", "Nennslingen",
"499074", "Höchstädt\ an\ der\ Donau",
"495151", "Hameln",
"496873", "Nonnweiler",
"492547", "Rosendahl\-Osterwick",
"495365", "Wolfsburg\-Neindorf",
"4934294", "Rackwitz",
"4933741", "Niedergörsdorf",
"499190", "Heroldsbach",
"499191", "Forchheim\ Oberfranken",
"496292", "Seckach",
"499843", "Burgbernheim",
"492591", "Lüdinghausen",
"492590", "Dülmen\-Buldern",
"498268", "Tussenhausen",
"496044", "Schotten\ Hessen",
"493586", "Neugersdorf\ Sachsen",
"499383", "Wiesentheid",
"493303", "Birkenwerder",
"496332", "Zweibrücken",
"495681", "Homberg\ Efze",
"4934208", "Löbnitz\ bei\ Delitzsch",
"496634", "Gemünden\ Felda",
"494903", "Wymeer",
"4936335", "Grosswechsungen",
"495438", "Bakum\-Lüsche",
"495407", "Wallenhorst",
"492378", "Fröndenberg\-Langschede",
"4933607", "Briesen\ Mark",
"496296", "Ahorn\ Baden",
"4939487", "Friedrichsbrunn",
"493863", "Crivitz",
"494827", "Wacken",
"492102", "Ratingen",
"499502", "Frensdorf",
"498665", "Inzell",
"496336", "Dellfeld",
"4935435", "Gollmitz\ bei\ Calau",
"4937200", "Wittgensdorf\ bei\ Chemnitz",
"493834", "Greifswald",
"497744", "Stühlingen",
"495326", "Langelsheim",
"4938483", "Brüel",
"4938454", "Kritzkow",
"496428", "Stadtallendorf",
"4936645", "Mühltroff",
"492722", "Attendorn",
"494462", "Wittmund",
"4934904", "Oranienbaum",
"4934491", "Schmölln\ Thüringen",
"4936041", "Bad\ Tennstedt",
"497161", "Göppingen",
"497221", "Baden\-Baden",
"495322", "Bad\ Harzburg",
"497355", "Hochdorf\ Riss",
"497220", "Forbach\-Hundsbach",
"495624", "Bad\ Emstal",
"496663", "Steinau\ an\ der\ Strasse",
"4939003", "Jübar",
"498708", "Weihmichl\-Unterneuhausen",
"4933656", "Bahro",
"494466", "Wittmund\-Ardorf",
"496544", "Rhaunen",
"494849", "Hooge",
"494274", "Varrel\ bei\ Sulingen",
"494851", "Marne",
"4935247", "Zehren\ Sachsen",
"4935825", "Kodersdorf",
"4939208", "Loitsche",
"496304", "Wolfstein\ Pfalz",
"494105", "Seevetal",
"495907", "Geeste",
"4933631", "Bad\ Saarow\-Pieskow",
"494403", "Bad\ Zwischenahn",
"492677", "Lutzerath",
"499534", "Burgpreppach",
"496864", "Mettlach",
"495823", "Bienenbüttel",
"493366", "Beeskow",
"499563", "Rödental",
"492465", "Inden",
"494725", "Helgoland",
"496833", "Rehlingen\-Siersburg",
"492163", "Schwalmtal\ Niederrhein",
"492223", "Königswinter",
"499644", "Pressath",
"497257", "Bruchsal\-Untergrombach",
"499409", "Pielenhofen",
"4936873", "Themar",
"494962", "Papenburg\-Aschendorf",
"499342", "Wertheim",
"493362", "Erkner",
"4937294", "Grünhainichen",
"494966", "Neubörger",
"499346", "Grünsfeld",
"494665", "Emmelsbüll\-Horsbüll",
"4935932", "Guttau",
"492836", "Wachtendonk",
"496226", "Meckesheim",
"496166", "Fischbachtal",
"4938458", "Zehna",
"4938300", "Insel\ Hiddensee",
"49981", "Ansbach",
"493724", "Burgstädt",
"4936694", "Schkölen\ Thüringen",
"494128", "Kollmar",
"494268", "Bötersen",
"499120", "Leinburg",
"499260", "Wilhelmsthal\ Oberfranken",
"496162", "Reinheim\ Odenwald",
"496222", "Wiesloch",
"492832", "Kevelaer",
"499261", "Kronach",
"492521", "Beckum",
"497454", "Sulz\ am\ Neckar",
"492520", "Wadersloh\-Diestedde",
"498466", "Denkendorf\ Oberbayern",
"497331", "Geislingen\ an\ der\ Steige",
"495232", "Lage\ Lippe",
"499184", "Deining\ Oberpfalz",
"492584", "Warendorf\-Milte",
"494708", "Ringstedt",
"494737", "Stadland\-Schwei",
"499701", "Sandberg\ Unterfranken",
"498389", "Weissensberg",
"495694", "Diemelstadt",
"4937437", "Bad\ Elster",
"4934204", "Schkeuditz",
"498462", "Berching",
"494477", "Lastrup\-Hemmelte",
"495236", "Blomberg\-Grossenmarpe",
"492603", "Bad\ Ems",
"495973", "Neuenkirchen\ Kreis\ Steinfurt",
"495159", "Coppenbrügge\-Bisperode",
"499157", "Alfeld\ Mittelfranken",
"495141", "Celle",
"492557", "Wettringen\ Kreis\ Steinfurt",
"492662", "Hachenburg",
"498403", "Pförring",
"492364", "Haltern\ Westfalen",
"498105", "Gilching",
"4937298", "Oelsnitz\ Erzgebirge",
"494835", "Albersdorf\ Holstein",
"4939971", "Gnoien",
"496723", "Oestrich\-Winkel",
"495764", "Steyerberg",
"497954", "Kirchberg\ an\ der\ Jagst",
"492804", "Xanten\-Marienbaum",
"492666", "Freilingen\ Westerwald",
"498851", "Kochel\ am\ See",
"498274", "Buttenwiesen",
"496405", "Laubach\ Hessen",
"495204", "Steinhagen\ Westfalen",
"496103", "Langen\ Hessen",
"493377", "Zossen\ Brandenburg",
"49351", "Dresden",
"495733", "Vlotho",
"495473", "Ostercappeln",
"4936785", "Gräfinau\-Angstedt",
"497023", "Weilheim\ an\ der\ Teck",
"494977", "Blomberg\ Ostfriesland",
"4939204", "Niederndodeleben",
"495175", "Lehrte\-Arpke",
"492333", "Ennepetal",
"494795", "Garlstedt",
"492293", "Nümbrecht",
"498725", "Wurmannsquick",
"4938853", "Drönnewitz\ bei\ Hagenow",
"495275", "Höxter\-Ottbergen",
"4933086", "Grieben\ Kreis\ Oberhavel",
"492381", "Hamm\ Westfalen",
"493973", "Pasewalk",
"4939604", "Wildberg\ bei\ Altentreptow",
"497063", "Bad\ Wimpfen",
"497534", "Reichenau\ Baden",
"496474", "Villmar\-Aumenau",
"492841", "Moers",
"492193", "Dabringhausen",
"498765", "Bruckberg\ Niederbayern",
"498029", "Kreuth\ bei\ Tegernsee",
"4936840", "Trusetal",
"496203", "Ladenburg",
"498547", "Osterhofen\-Gergweis",
"492937", "Arnsberg\-Oeventrop",
"496734", "Flonheim",
"4939246", "Lindau\ Anh",
"495724", "Obernkirchen",
"496763", "Kirchberg\ Hunsrück",
"498637", "Lohkirchen",
"4935954", "Grossharthau",
"4939721", "Liepen\ bei\ Anklam",
"497346", "Illerkirchberg",
"492626", "Selters\ Westferwald",
"495241", "Gütersloh",
"496894", "St\ Ingbert",
"4939857", "Drense",
"499093", "Polsingen",
"4936200", "Elxleben\ bei\ Arnstadt",
"497644", "Kenzingen",
"499257", "Zell\ Oberfranken",
"498205", "Dasing",
"492324", "Hattingen\ Ruhr",
"4933931", "Rheinsberg\ Mark",
"4933703", "Sperenberg",
"497563", "Kisslegg",
"492622", "Bendorf\ am\ Rhein",
"497034", "Ehningen",
"4936076", "Niederorschel",
"497502", "Wolpertswende",
"4933925", "Wustrau\-Altfriesack",
"493473", "Aschersleben\ Sachsen\-Anhalt",
"498422", "Dollnstein",
"492777", "Breitscheid\ Hessen",
"4934604", "Niemberg",
"495136", "Burgdorf\ Kreis\ Hannover",
"4936945", "Henneberg",
"494492", "Saterland",
"496706", "Wallhausen\ Nahe",
"495259", "Bad\ Driburg\-Neuenheerse",
"494496", "Friesoythe\-Markhausen",
"499284", "Schwarzenbach\ an\ der\ Saale",
"4933965", "Herzsprung\ bei\ Wittstock",
"497506", "Wangen\-Leupolz",
"497383", "Münsingen\-Buttenhausen",
"495132", "Lehrte",
"498426", "Walting\ Kreis\ Eichstätt",
"495377", "Ehra\-Lessien",
"49551", "Göttingen",
"496693", "Neuental",
"497843", "Renchen",
"492408", "Aachen\-Kornelimünster",
"497191", "Backnang",
"493733", "Annaberg\-Buchholz",
"498338", "Böhen",
"4934721", "Nienburg\ Saale",
"494876", "Reher\ Holstein",
"493764", "Meerane",
"492561", "Ahaus",
"4937361", "Neuhausen\ Erzgebirge",
"499221", "Kulmbach",
"499161", "Neustadt\ an\ der\ Aisch",
"496262", "Aglasterhausen",
"496122", "Hofheim\-Wallau",
"499220", "Kasendorf\-Azendorf",
"494168", "Neu\ Wulmstorf\-Elstorf",
"499355", "Frammersbach",
"498867", "Rottenbuch\ Oberbayern",
"494872", "Hanerau\-Hademarschen",
"492859", "Wesel\-Bislich",
"494625", "Jübek",
"496266", "Hassmersheim",
"496126", "Idstein",
"4935053", "Glashütte\ Sachsen",
"499744", "Zeitlofs\-Detter",
"4937321", "Frankenstein\ Sachsen",
"498373", "Altusried",
"495086", "Celle\-Scheuen",
"493322", "Falkensee",
"499954", "Simbach\ Niederbayern",
"493624", "Ohrdruf",
"4933832", "Rogäsen",
"494547", "Gudow\ Lauenburg",
"494926", "Krummhörn\-Greetsiel",
"492263", "Engelskirchen",
"495834", "Wittingen\-Knesebeck",
"496881", "Lebach",
"4936459", "Blankenhain\ Thüringen",
"499523", "Hofheim\ in\ Unterfranken",
"494765", "Ebersdorf\ bei\ Bremervörde",
"492425", "Nideggen\-Embken",
"495082", "Langlingen",
"496341", "Landau\ in\ der\ Pfalz",
"494922", "Borkum",
"496340", "Wörth\-Schaidt",
"497157", "Waldenbuch",
"4935022", "Bad\ Schandau",
"4936736", "Arnsgereuth",
"4933231", "Pausin",
"492394", "Neuenrade\-Affeln",
"492692", "Kelberg",
"4934443", "Teuchern",
"494205", "Ottersberg",
"496375", "Wallhalben",
"495863", "Zernien",
"494529", "Süsel\-Bujendorf",
"492234", "Frechen",
"496824", "Ottweiler",
"495582", "Sankt\ Andreasberg",
"492696", "Nohn\ Eifel",
"494174", "Stelle\ Kreis\ Harburg",
"495303", "Wendeburg",
"495586", "Wieda",
"4939608", "Staven",
"494637", "Sterup",
"494608", "Handewitt",
"493681", "Suhl",
"495806", "Barum\ bei\ Bad\ Bevensen",
"496623", "Rotenburg\ an\ der\ Fulda",
"495664", "Morschen",
"499454", "Aufhausen\ Oberpfalz",
"497260", "Sinsheim\-Hilsbach",
"495362", "Wolfsburg\-Fallersleben",
"497261", "Sinsheim",
"497121", "Reutlingen",
"495543", "Staufenberg\ Niedersachsen",
"494426", "Wangerland\-Horumersiel",
"4938221", "Marlow",
"49781", "Offenburg",
"492925", "Warstein\-Allagen",
"495366", "Jembke",
"4937600", "Neumark\ Sachsen",
"495802", "Wrestedt",
"4933847", "Görzke",
"4935342", "Mühlberg\ Elbe",
"494422", "Sande\ Kreis\ Friesl",
"492762", "Wenden\ Südsauerland",
"496468", "Dautphetal\-Mornshausen",
"496196", "Bad\ Soden\ am\ Taunus",
"4933207", "Gross\ Kreutz",
"4933393", "Gross\ Schönebeck\ Kreis\ Barnim",
"496359", "Grünstadt",
"493907", "Gardelegen",
"4938822", "Diedrichshagen\ bei\ Grevesmühlen",
"496500", "Waldrach",
"496501", "Konz",
"492202", "Bergisch\ Gladbach",
"498168", "Attenkirchen",
"495043", "Lauenau",
"496192", "Hofheim\ am\ Taunus",
"494298", "Lilienthal",
"492206", "Overath",
"495633", "Diemelsee",
"4934385", "Mutzschen",
"4934671", "Bad\ Frankenhausen\ Kyffhäuser",
"499331", "Ochsenfurt",
"497184", "Kaisersbach",
"494307", "Raisdorf",
"494338", "Alt\ Duvenstedt",
"495462", "Ankum",
"499652", "Waidhaus",
"498236", "Fischach",
"497253", "Bad\ Schönborn",
"499354", "Rieneck",
"4939832", "Wesenberg",
"496837", "Wallerfangen",
"492227", "Bornheim\-Merten",
"493765", "Reichenbach\ Vogtland",
"494326", "Wankendorf",
"499567", "Sesslach\-Gemünda",
"498232", "Schwabmünchen",
"499656", "Moosbach\ bei\ Vohenstrauss",
"495466", "Merzen",
"499745", "Wildflecken",
"495849", "Waddeweitz",
"494322", "Bordesholm",
"494624", "Kropp",
"498392", "Markt\ Rettenbach",
"492994", "Marsberg\-Westheim",
"499771", "Bad\ Neustadt\ an\ der\ Saale",
"494681", "Wyk\ auf\ Föhr",
"4934207", "Zwochau",
"494778", "Wingst",
"4934422", "Osterfeld",
"495198", "Schneverdingen\-Wintermoor",
"4936966", "Kaltennordheim",
"493529", "Heidenau\ Sachsen",
"495827", "Unterlüss",
"495903", "Emsbüren",
"499431", "Schwandorf",
"4933671", "Lieberose",
"494407", "Wardenburg",
"492673", "Ellenz\-Poltersdorf",
"4937434", "Bobenneukirchen",
"4939488", "Güntersberge",
"499285", "Kirchenlamitz",
"4934462", "Laucha\ Unstrut",
"4936926", "Creuzburg",
"4933608", "Jacobsdorf\ Mark",
"496556", "Pronsfeld",
"4935363", "Fermerswalde",
"497248", "Marxzell",
"495962", "Herzlake",
"499829", "Flachslanden",
"495725", "Lindhorst\ bei\ Stadthagen",
"495069", "Nordstemmen",
"4935475", "Straupitz",
"4939265", "Löderburg",
"492251", "Euskirchen",
"495966", "Meppen\-Apeldorn",
"498204", "Mickhausen",
"492874", "Isselburg",
"492325", "Wanne\-Eickel",
"4938203", "Bad\ Doberan",
"496552", "Olzheim",
"4935323", "Sonnewalde",
"496667", "Steinau\-Ulmbach",
"498733", "Mengkofen",
"4939225", "Altengrabow",
"496441", "Wetzlar",
"497645", "Freiamt",
"496440", "Kölschhausen",
"498764", "Mauern\ Kreis\ Freising",
"4939207", "Colbitz",
"493338", "Bernau\ Brandenburg",
"493307", "Zehdenick",
"4936423", "Orlamünde",
"4939393", "Werben\ Elbe",
"495274", "Nieheim",
"495850", "Neetze",
"4938843", "Bennin",
"496173", "Kronberg\ im\ Taunus",
"495851", "Dahlenburg",
"497671", "Todtnau",
"4935248", "Schönfeld\ bei\ Grossenhain",
"496052", "Bad\ Orb",
"4939422", "Badersleben",
"496475", "Weilmünster\-Wolfenhausen",
"499847", "Ergersheim",
"498141", "Fürstenfeldbruck",
"496735", "Eppelsheim",
"496588", "Pluwig",
"4936463", "Gebstedt",
"493867", "Lübstorf",
"494823", "Wilster",
"493695", "Bad\ Salzungen",
"495105", "Barsinghausen",
"496056", "Bad\ Soden\-Salmünster",
"4936085", "Reinholterode",
"494938", "Hagermarsch",
"4936375", "Kindelbrück",
"495403", "Bad\ Iburg",
"499931", "Plattling",
"494392", "Nortorf\ bei\ Neumünster",
"4936452", "Berlstedt",
"492981", "Winterberg\ Westfalen",
"4939086", "Jävenitz",
"498624", "Obing",
"4934925", "Bad\ Schmiedeberg",
"4937438", "Bad\ Brambach",
"4939484", "Harzgerode",
"4933604", "Lebus",
"498322", "Oberstdorf",
"499576", "Lichtenfels\-Isling",
"4939453", "Derenburg",
"494232", "Langwedel\ Kreis\ Verden",
"4939820", "Triepkendorf",
"496138", "Mommenheim",
"496107", "Kelsterbach",
"493996", "Teterow",
"494159", "Basthorst",
"497483", "Horb\-Mühringen",
"492297", "Wildbergerhütte",
"499572", "Burgkunstadt",
"492053", "Velbert\-Neviges",
"498326", "Fischen\ im\ Allgäu",
"4934956", "Zörbig",
"492308", "Unna\-Hemmerde",
"492337", "Hagen\-Dahl",
"494236", "Kirchlinteln",
"494973", "Wittmund\-Burhafe",
"4933839", "Wusterwitz",
"4938756", "Grabow",
"4936741", "Bad\ Blankenburg",
"497946", "Bretzfeld",
"498407", "Grossmehring",
"497527", "Wolfegg",
"495665", "Guxhagen",
"492553", "Ochtrup",
"499072", "Lauingen\ Donau",
"499153", "Schnaittach",
"495128", "Hohenhameln",
"4936702", "Lauscha",
"4938725", "Gross\ Godems",
"497942", "Neuenstein\ Württemberg",
"4936255", "Goldbach\ bei\ Gotha",
"4939931", "Röbel\ Müritz",
"492924", "Möhnesee",
"496727", "Gensingen",
"4938457", "Krakow\ am\ See",
"498681", "Waging\ am\ See",
"499076", "Wittislingen",
"4934907", "Jeber\-Bergfrieden",
"496825", "Illingen\ Saar",
"4939925", "Wredenhagen",
"492235", "Erftstadt",
"496374", "Weilerbach",
"494733", "Butjadingen\-Burhave",
"497051", "Calw",
"496672", "Eiterfeld",
"492395", "Finnentrop\-Rönkhausen",
"493496", "Köthen\ Anhalt",
"4938731", "Lübz",
"494204", "Thedinghausen",
"4939956", "Neukalen",
"496676", "Hohenroda\ Hessen",
"4935244", "Krögis",
"494473", "Emstek",
"492607", "Kobern\-Gondorf",
"492638", "Waldbreitbach",
"495977", "Spelle",
"494175", "Egestorf\ Nordheide",
"496751", "Bad\ Sobernheim",
"497446", "Lossburg",
"4937297", "Thum\ Sachsen",
"492548", "Dülmen\-Rorup",
"498823", "Mittenwald",
"499955", "Mamming",
"494893", "Hohenaspe",
"494141", "Stade",
"499148", "Ettenstatt",
"494140", "Estorf\ Kreis\ Stade",
"4935606", "Briesen\ bei\ Cottbus",
"497309", "Weissenhorn",
"497442", "Baiersbronn",
"495835", "Wahrenholz",
"497551", "Überlingen\ Bodensee",
"49355", "Cottbus",
"493876", "Perleberg",
"494764", "Gnarrenburg\-Klenkendorf",
"492424", "Vettweiss",
"4938326", "Grimmen",
"499645", "Eschenbach\ in\ der\ Oberpfalz",
"4933470", "Lietzen",
"4935206", "Kreischa\ bei\ Dresden",
"494724", "Cuxhaven\-Lüdingworth",
"492464", "Aldenhoven\ bei\ Jülich",
"498303", "Waltenhofen",
"498586", "Hauzenberg",
"4938355", "Züssow",
"4935722", "Lauta\ bei\ Hoyerswerda",
"492689", "Dierdorf",
"494240", "Syke\-Heiligenfelde",
"4939858", "Bietikow",
"498582", "Röhrnbach",
"494241", "Bassum",
"498082", "Schwindegg",
"497930", "Boxberg\ Baden",
"497931", "Bad\ Mergentheim",
"496305", "Hochspeyer",
"494275", "Ehrenburg",
"492773", "Haiger",
"499671", "Oberviechtach",
"499535", "Pfarrweisach",
"492433", "Hückelhoven",
"4939775", "Ahlbeck\ bei\ Torgelow",
"493737", "Rochlitz",
"495373", "Hillerse\ Kreis\ Gifhorn",
"498086", "Buchbach\ Oberbayern",
"496865", "Mettlach\-Orscholz",
"496697", "Willingshausen",
"497387", "Hohenstein\ Württemberg",
"494104", "Aumühle\ bei\ Hamburg",
"498558", "Hohenau\ Niederbayern",
"498043", "Jachenau",
"495228", "Vlotho\-Exter",
"495168", "Walsrode\-Stellichte",
"497745", "Jestetten",
"497656", "Schluchsee",
"4933844", "Brück\ Brandenburg",
"498633", "Tüssling",
"492964", "Brilon\-Alme",
"497567", "Leutkirch\-Friesenhofen",
"4936626", "Auma",
"4933971", "Kyritz\ Brandenburg",
"496545", "Blankenrath",
"495872", "Stoetze",
"499097", "Marxheim",
"497354", "Erolzheim",
"499253", "Weissenstadt",
"495625", "Naumburg\ Hessen",
"496071", "Dieburg",
"497652", "Hinterzarten",
"498802", "Huglfing",
"492272", "Bedburg\ Erft",
"497431", "Albstadt\-Ebingen",
"498366", "Oy\-Mittelberg",
"496571", "Wittlich",
"496635", "Kirtorf",
"4937463", "Bergen\ Vogtland",
"494136", "Scharnebeck",
"495492", "Steinfeld\ Oldenburg",
"4933336", "Passow\ Kreis\ Uckermark",
"496045", "Gedern",
"498362", "Füssen",
"4933204", "Beelitz\ Mark",
"49451", "Lübeck",
"4937423", "Adorf\ Vogtland",
"492933", "Sundern\ Sauerland",
"498664", "Chieming",
"496398", "Vorderweidenthal",
"498806", "Utting\ am\ Ammersee",
"4934775", "Wippra",
"497771", "Stockach",
"496238", "Dirmstein",
"496207", "Wald\-Michelbach",
"492828", "Emmerich\-Elten",
"494132", "Amelinghausen",
"498543", "Aidenbach",
"496039", "Karben",
"494863", "Sankt\ Peter\-Ording",
"495529", "Rhumspringe",
"498241", "Buchloe",
"496404", "Lich\ Hessen",
"495205", "Bielefeld\-Sennestadt",
"494794", "Worpswede\-Ostersode",
"494303", "Schlesen",
"495608", "Söhrewald",
"4939607", "Kotelow",
"498724", "Massing",
"4935939", "Hochkirch",
"4935695", "Simmersdorf",
"495174", "Lahstedt",
"4939854", "Kleptow",
"499551", "Burgwindheim",
"494558", "Todesfelde",
"492365", "Marl",
"497739", "Hilzingen",
"493466", "Artern\ Unstrut",
"492150", "Meerbusch\-Lank",
"498104", "Sauerlach",
"495926", "Engden",
"492151", "Krefeld",
"4934341", "Geithain",
"499442", "Riedenburg",
"498678", "Marktl",
"4939883", "Gross\ Dölln",
"496627", "Nentershausen\ Hessen",
"498781", "Rottenburg\ an\ der\ Laaber",
"493462", "Bad\ Dürrenberg",
"497955", "Wallhausen\ Württemberg",
"495922", "Bad\ Bentheim",
"497148", "Grossbottwar",
"494834", "Büsum",
"4939061", "Weferlingen",
"499869", "Wettringen\ Mittelfranken",
"495765", "Raddestorf",
"499446", "Altmannstein",
"495695", "Twistetal",
"496776", "Dachsenhausen",
"4933208", "Fahrland",
"499185", "Mühlhausen\ Oberpfalz",
"4938292", "Kröpelin",
"492585", "Warendorf\-Hoetmar",
"492738", "Netphen",
"496432", "Diez",
"497572", "Mengen\ Württemberg",
"4934607", "Wettin",
"4939035", "Kuhfelde",
"494633", "Satrup",
"496772", "Nastätten",
"495307", "Braunschweig\-Wenden",
"496436", "Dornburg\ Hessen",
"497576", "Krauchenwies",
"499549", "Lisberg",
"494543", "Nusse",
"495426", "Glandorf",
"493966", "Cölpin",
"4933872", "Hohennauen",
"494806", "Sarzbüttel",
"494664", "Neukirchen\ bei\ Niebüll",
"4939341", "Redekin",
"499942", "Viechtach",
"496328", "Elmstein",
"499639", "Mähring",
"498377", "Unterthingau",
"49851", "Passau",
"494362", "Heiligenhafen",
"4989", "Munich",
"494489", "Apen",
"497153", "Plochingen",
"4933848", "Raben",
"498136", "Markt\ Indersdorf",
"495422", "Melle",
"496651", "Rasdorf",
"497072", "Gomaringen",
"496650", "Hosenfeld",
"497455", "Dornhan",
"4935753", "Grossräschen",
"493962", "Penzlin\ bei\ Waren",
"4934656", "Wallhausen\ Sachsen\-Anhalt",
"498259", "Schiltberg",
"499946", "Hohenwarth\ bei\ Kötzing",
"499527", "Knetzgau",
"493725", "Zschopau",
"494366", "Grömitz\-Cismar",
"492267", "Wipperfürth",
"494802", "Wrohm",
"498348", "Bidingen",
"499474", "Schmidmühlen",
"4939224", "Büden",
"4938782", "Reetz\ bei\ Perleberg",
"49561", "Kassel",
"496593", "Hillesheim\ Eifel",
"494187", "Holm\-Seppensen",
"497304", "Blaustein\ Württemberg",
"499203", "Neudrossenfeld",
"4935474", "Schönwalde\ bei\ Lübben",
"4939264", "Kroppenstedt",
"4935386", "Prettin",
"499734", "Burkardroth",
"4937421", "Oelsnitz\ Vogtland",
"492429", "Hürtgenwald",
"494769", "Bremervörde\-Iselersheim",
"4939329", "Möringen",
"498095", "Aying",
"4936374", "Weissensee",
"499763", "Sulzdorf\ an\ der\ Lederhecke",
"494525", "Ahrensbök",
"4936084", "Heuthen",
"4939052", "Erxleben\ bei\ Haldensleben",
"4939928", "Möllenhagen",
"495146", "Wietze",
"494209", "Schwanewede",
"495142", "Eschede",
"49465", "Sylt",
"496257", "Seeheim\-Jugenheim",
"496093", "Laufach",
"497833", "Hornberg\ Schwarzwaldbahn",
"492447", "Dahlem\ bei\ Kall",
"4933973", "Zernitz\ bei\ Neustadt\ Dosse",
"498856", "Penzberg",
"492661", "Bad\ Marienberg\ Westerwald",
"4934224", "Belgern\ Sachsen",
"499974", "Traitsching",
"498460", "Berching\-Holnstein",
"497336", "Lonsee",
"498461", "Beilngries",
"49228", "Bonn",
"493594", "Bischofswerda",
"4936258", "Friemar",
"495485", "Ladbergen",
"497634", "Sulzburg",
"495183", "Lamspringe",
"496284", "Mudau",
"4938728", "Domsühl",
"497332", "Lauterstein",
"495231", "Detmold",
"497044", "Mönsheim",
"4937435", "Reuth\ bei\ Plauen",
"498629", "Palling",
"4934928", "Seegrehna",
"497544", "Markdorf",
"4935200", "Arnsdorf\ bei\ Dresden",
"4933476", "Neuhardenberg",
"4938320", "Tribsees",
"497663", "Eichstetten",
"492522", "Oelde",
"499122", "Schwabach",
"499262", "Wallenfels",
"492831", "Geldern",
"4938876", "Roggendorf",
"496161", "Brensbach",
"496221", "Heidelberg",
"496355", "Albisheim\ Pfrimm",
"496220", "Wilhelmsfeld",
"494154", "Trittau",
"497428", "Rosenfeld",
"498537", "Bad\ Füssing\-Aigen",
"499126", "Eckental",
"499266", "Mitwitz",
"492947", "Anröchte",
"496744", "Oberwesel",
"492526", "Sendenhorst",
"4933734", "Felgentreu",
"493361", "Fürstenwalde\ Spree",
"4939343", "Jerichow",
"498025", "Miesbach",
"4935827", "Nieder\-Seifersdorf",
"4935245", "Burkhardswalde\-Munzig",
"497723", "Furtwangen\ im\ Schwarzwald",
"495033", "Wunstorf\-Grossenheidorn",
"495564", "Dassel",
"496523", "Holsthum",
"499341", "Tauberbischofsheim",
"4936378", "Ostramondra",
"494961", "Papenburg",
"499340", "Königheim\-Brehmen",
"494348", "Schönkirchen",
"4933362", "Liepe\ Kreis\ Barnim",
"495643", "Borgentreich",
"495357", "Grasleben",
"4939924", "Stuer",
"4935751", "Welzow",
"494856", "Kronprinzenkoog",
"4935478", "Goyatz",
"49371", "Chemnitz\ Sachsen",
"499824", "Dietenhofen",
"4939268", "Egeln",
"499375", "Freudenberg\ Baden",
"495533", "Bodenwerder",
"496023", "Alzenau\ in\ Unterfranken",
"495064", "Gross\ Düngen",
"494852", "Brunsbüttel",
"4934343", "Regis\-Breitingen",
"496454", "Lichtenfels\-Sachsenberg",
"493448", "Meuselwitz\ Thüringen",
"495320", "Torfhaus",
"495255", "Altenbeken",
"4939881", "Ringenwalde\ bei\ Templin",
"497222", "Rastatt",
"497162", "Süssen",
"495321", "Goslar",
"4936022", "Grossengottern",
"492244", "Königswinter\-Oberpleis",
"497226", "Bühl\-Sand",
"497166", "Adelberg",
"4934924", "Zahna",
"4939485", "Gernrode\ Harz",
"494353", "Ascheffel",
"4933605", "Boossen",
"492721", "Lennestadt",
"494461", "Jever",
"4936337", "Schiedungen",
"499468", "Zell\ Oberpfalz",
"495658", "Wehretal",
"499196", "Wiesenttal",
"4933989", "Sadenbeck",
"4938332", "Gross\ Bisdorf",
"499359", "Karlstadt\-Wiesenfeld",
"4936647", "Saalburg\ Thüringen",
"492596", "Nordkirchen",
"4936254", "Friedrichswerth",
"494508", "Krummesse",
"494537", "Sülfeld\ Holstein",
"493581", "Görlitz",
"4938724", "Siggelkow",
"495686", "Schwarzenborn\ Knüll",
"499277", "Warmensteinach",
"492592", "Selm",
"495844", "Clenze",
"496291", "Adelsheim",
"499192", "Gräfenberg",
"4934633", "Braunsbedra",
"497905", "Langenburg",
"495682", "Borken\ Hessen",
"496331", "Pirmasens",
"495384", "Seesen\-Gross\ Rhüden",
"492855", "Voerde\ Niederrhein",
"497702", "Blumberg\ Baden",
"496190", "Hattersheim\ am\ Main",
"4938841", "Neuhaus\ Elbe",
"499292", "Konradsreuth",
"49231", "Dortmund",
"496843", "Gersheim",
"499177", "Heideck",
"496506", "Welschbillig",
"496383", "Glan\-Münchweiler",
"499332", "Marktbreit",
"4936421", "Camburg",
"499634", "Wiesau",
"4939391", "Lückstedt",
"494484", "Hude\-Wüsting",
"497706", "Oberbaldingen",
"4933845", "Borkheide",
"49571", "Minden\ Westfalen",
"498254", "Altomünster",
"4936461", "Bad\ Sulza",
"497974", "Bühlerzell",
"496502", "Schweich",
"493533", "Elsterwerda",
"499336", "Bütthard",
"498385", "Hergatz",
"497266", "Kirchardt",
"497126", "Burladingen\-Melchingen",
"496002", "Ober\-Mörlen",
"493564", "Schwarze\ Pumpe",
"499428", "Kirchroth",
"4934774", "Röblingen\ am\ See",
"498845", "Bad\ Kohlgrub",
"4935361", "Schlieben",
"492761", "Olpe\ Biggesee",
"494421", "Wilhelmshaven",
"4933205", "Michendorf",
"493643", "Weimar\ Thüringen",
"495948", "Itterbeck",
"495361", "Wolfsburg",
"497262", "Eppingen",
"497122", "St\ Johann\ Württemberg",
"495155", "Emmerthal",
"495453", "Recke",
"499663", "Neukirchen\ bei\ Sulzbach\-Rosenberg",
"4939038", "Henningen",
"494957", "Detern",
"4935873", "Herrnhut",
"4938201", "Gelbensande",
"499544", "Baunach",
"496858", "Ottweiler\-Fürth",
"493844", "Schwaan",
"497734", "Gailingen",
"498565", "Dietersburg\-Baumgarten",
"499602", "Neustadt\ an\ der\ Waldnaab",
"493682", "Zella\-Mehlis",
"497203", "Walzbachtal",
"4938354", "Wusterhusen",
"492691", "Adenau",
"4933673", "Weichensdorf",
"495024", "Rohrsen\ Kreis\ Nienburg\ Weser",
"496063", "Bad\ König",
"496534", "Mülheim\ Mosel",
"497474", "Haigerloch",
"4936920", "Grossenlupnitz",
"494839", "Wöhrden\ Dithmarschen",
"499606", "Pfreimd",
"493686", "Eisfeld",
"496563", "Kyllburg",
"495524", "Bad\ Lauterberg\ im\ Harz",
"496034", "Wöllstadt",
"499833", "Heidenheim\ Mittelfranken",
"496644", "Grebenhain",
"496409", "Biebertal",
"494921", "Emden\ Stadt",
"499928", "Kirchdorf\ im\ Wald",
"496342", "Schweigen\-Rechtenbach",
"494920", "Wirdum",
"4939774", "Mönkebude",
"49203", "Duisburg",
"498065", "Tuntenhausen\-Schönau",
"4939387", "Havelberg",
"495953", "Börger",
"493321", "Nauen\ Brandenburg",
"495448", "Barver",
"4935698", "Hornow",
"496346", "Annweiler\ am\ Trifels",
"497763", "Murg",
"494254", "Eystrup",
"4934742", "Sylda",
"494871", "Hohenwestedt",
"492566", "Legden",
"495743", "Espelkamp\-Gestringen",
"4936947", "Jüchsen",
"4939034", "Fleetmark",
"499166", "Münchsteinach",
"4933927", "Linum",
"4939409", "Eilsleben",
"49681", "Saarbrücken",
"492657", "Uersfeld",
"4935600", "Döbern\ NL",
"498669", "Traunreut",
"4937342", "Cranzahl",
"496120", "Aarbergen",
"496261", "Mosbach\ Baden",
"499162", "Scheinfeld",
"499222", "Presseck",
"4933967", "Freyenstein",
"492562", "Gronau\ Westfalen",
"4938379", "Benz\ Usedom",
"497623", "Rheinfelden\ Baden",
"495131", "Garbsen",
"4938733", "Karbow\-Vietlübbe",
"496184", "Langenselbold",
"495283", "Lügde\-Rischenau",
"495130", "Wedemark",
"499905", "Bernried\ Niederbayern",
"497192", "Murrhardt",
"496701", "Sprendlingen\ Rheinhessen",
"497277", "Wörth\-Büchelberg",
"492066", "Duisburg\-Homberg",
"499498", "Laaber",
"494491", "Friesoythe",
"498421", "Eichstätt\ Bayern",
"494845", "Ostenfeld\ Husum",
"49361", "Erfurt",
"494385", "Hohenfelde\ bei\ Kiel",
"4935694", "Gosda\ bei\ Klinge",
"496157", "Pfungstadt",
"4939742", "Brüssow\ bei\ Pasewalk",
"495242", "Rheda\-Wiedenbrück",
"4938750", "Malliss",
"497340", "Neenstetten",
"492621", "Lahnstein",
"492620", "Neuhäusel\ Westerwald",
"4936743", "Teichel",
"494747", "Beverstedt",
"4939933", "Vollrathsruhe",
"495246", "Verl",
"492358", "Meinerzhagen\-Valbert",
"4939778", "Ferdinandshof\ bei\ Torgelow",
"499723", "Röthlein",
"494109", "Tangstedt\ Bz\ Hamburg",
"4933763", "Bestensee",
"499405", "Bad\ Abbach",
"4939451", "Wasserleben",
"4939080", "Kalbe\ Milde",
"499103", "Cadolzburg",
"494287", "Heeslingen\-Boitzen",
"493391", "Neuruppin",
"498457", "Vohburg\ an\ der\ Donau",
"4939826", "Blankensee\ bei\ Neustrelitz",
"492684", "Puderbach\ Westerwald",
"492382", "Ahlen\ Westfalen",
"497375", "Obermarchtal",
"497824", "Schwanau",
"495594", "Bovenden\-Reyershausen",
"493578", "Kamenz",
"4939855", "Parmen\-Weggun",
"492842", "Kamp\-Lintfort",
"497441", "Freudenstadt",
"497440", "Bad\ Rippoldsau",
"496645", "Ulrichstein",
"496756", "Winterbach\ Soonwald",
"4937363", "Zöblitz",
"497667", "Breisach\ am\ Rhein",
"495209", "Gütersloh\-Friedrichsdorf",
"495525", "Walkenried",
"496035", "Reichelsheim\ Wetterau",
"4933436", "Prötzel",
"497552", "Pfullendorf",
"4939927", "Nossentiner\ Hütte",
"494146", "Stade\-Bützfleth",
"492943", "Erwitte",
"4937323", "Lichtenberg\ Erzgebirge",
"496752", "Kirn\ Nahe",
"498064", "Au\ bei\ Bad\ Aibling",
"494142", "Steinkirchen\ Kreis\ Stade",
"498533", "Rotthalmünster",
"493871", "Parchim",
"497556", "Uhldingen\-Mühlhofen",
"498564", "Johanniskirchen",
"498033", "Oberaudorf",
"49461", "Flensburg",
"492486", "Nettersheim",
"499305", "Estenfeld",
"493385", "Rathenow",
"497056", "Gechingen",
"493491", "Lutherstadt\ Wittenberg",
"4937295", "Lugau\ Erzgebirge",
"492369", "Dorsten\-Wulfen",
"497735", "Öhningen",
"492482", "Hellenthal",
"495025", "Estorf\ Weser",
"497052", "Bad\ Liebenzell",
"496788", "Sien",
"496670", "Ludwigsau\ Hessen",
"497475", "Burladingen",
"496535", "Osann\-Monzel",
"495769", "Steyerberg\-Voigtei",
"499865", "Adelshofen\ Mittelfranken",
"497173", "Heubach",
"495187", "Delligsen",
"497959", "Frankenhardt",
"499189", "Berg\ bei\ Neumarkt\ in\ der\ Oberpfalz",
"4933742", "Oehna\ Brandenburg",
"497940", "Künzelsau",
"497941", "Öhringen",
"498384", "Röthenbach\ Allgäu",
"4934927", "Globig\-Bleddin",
"4936334", "Wolkramshausen",
"498682", "Laufen\ Salzach",
"4939723", "Krien",
"4936762", "Steinach\ Thüringen",
"492958", "Büren\-Harth",
"4933933", "Lindow\ Mark",
"4933701", "Grossbeeren",
"4936206", "Grossfahner",
"497837", "Oberharmersbach",
"499545", "Buttenheim",
"492443", "Mechernich",
"497808", "Hohberg\ bei\ Offenburg",
"498686", "Petting",
"496253", "Fürth\ Odenwald",
"495154", "Aerzen",
"499071", "Dillingen\ an\ der\ Donau",
"499070", "Tapfheim",
"496597", "Jünkerath",
"4933451", "Heckelberg",
"492171", "Leverkusen\-Opladen",
"499571", "Lichtenfels\ Bayern",
"4938426", "Neuburg\-Steinhausen",
"4933080", "Marienthal\ Kreis\ Oberhavel",
"499635", "Bärnau",
"4938851", "Zarrentin",
"4936846", "Suhl\-Dietzhausen",
"493991", "Waren\ Müritz",
"498321", "Sonthofen",
"4934905", "Wörlitz",
"4938466", "Jürgenshagen",
"498320", "Missen\-Wilhams",
"499398", "Birkenfeld\ bei\ Würzburg",
"4938455", "Plaaz",
"497975", "Untergröningen",
"492982", "Medebach",
"4936644", "Hirschberg\ Saale",
"494485", "Elsfleth\-Huntorf",
"4936257", "Luisenthal\ Thüringen",
"494230", "Verden\-Walle",
"494183", "Jesteburg",
"499207", "Königsfeld\ Oberfranken",
"499238", "Röslau",
"4935434", "Altdöbern",
"497459", "Nagold\-Hochdorf",
"4935793", "Elstra",
"494231", "Verden\ Aller",
"4938727", "Mestlin",
"4939267", "Schneidlingen",
"49291", "Meschede",
"4935477", "Rietzneuendorf\-Friedrichshof",
"494533", "Reinfeld\ Holstein",
"498142", "Olching",
"499932", "Osterhofen",
"4938372", "Usedom",
"499404", "Nittendorf",
"4937349", "Scheibenberg",
"497676", "Feldberg\ Schwarzwald",
"498146", "Moorenweis",
"4934673", "Heldrungen",
"492685", "Flammersfeld",
"496051", "Gelnhausen",
"497672", "St\ Blasien",
"496050", "Biebergemünd",
"4939402", "Völpke",
"499936", "Wallerfing",
"495852", "Bleckede",
"497825", "Kippenheim",
"497374", "Uttenweiler",
"499273", "Bad\ Berneck\ im\ Fichtelgebirge",
"496551", "Prüm",
"496550", "Irrhausen",
"4935828", "Reichenbach\ OL",
"4938223", "Saal\ Vorpom",
"492252", "Zülpich",
"4939752", "Blumenhagen\ bei\ Strasburg",
"496442", "Braunfels",
"4936784", "Stützerbach",
"4939205", "Langenweddingen",
"499627", "Freudenberg\ Oberpfalz",
"4937606", "Lengenfeld\ Vogtland",
"493421", "Torgau",
"492256", "Mechernich\-Satzvey",
"495961", "Haselünne",
"4936377", "Rastenberg",
"4936087", "Wüstheuterode",
"494643", "Gelting\ Angeln",
"494357", "Sehestedt\ Eider",
"49861", "Traunstein",
"49375", "Zwickau",
"497751", "Waldshut",
"496446", "Hohenahr",
"494564", "Schashagen",
"496869", "Merzig\-Silwingen",
"495508", "Gleichen\-Rittmarshausen",
"496027", "Stockstadt\ am\ Main",
"499776", "Mellrichstadt",
"4936730", "Sitzendorf",
"49241", "Aachen",
"4936695", "Söllmnitz",
"4933233", "Ketzin",
"496185", "Hammersbach\ Hessen",
"496483", "Selters\ Taunus",
"4934441", "Hohenmölsen",
"4936648", "Dittersdorf\ bei\ Schleiz",
"499904", "Lalling",
"493984", "Prenzlau",
"499772", "Bischofsheim\ an\ der\ Rhön",
"494682", "Amrum",
"494384", "Selent",
"497138", "Schwaigern",
"4939749", "Grambow\ bei\ Pasewalk",
"499436", "Nittenau",
"494844", "Pellworm",
"498231", "Königsbrunn\ bei\ Augsburg",
"498230", "Gablingen",
"496049", "Kefenrod",
"497727", "Vöhrenbach",
"4934205", "Markranstädt",
"492753", "Erndtebrück",
"496639", "Ottrau",
"494320", "Heidmühlen",
"494255", "Martfeld",
"494321", "Neumünster",
"495353", "Königslutter\ am\ Elm",
"495647", "Lichtenau\-Kleinenberg",
"495461", "Bramsche\ Hase",
"499651", "Vohenstrauss",
"4936338", "Bleicherode",
"493921", "Burg\ bei\ Magdeburg",
"495037", "Bad\ Rehburg",
"496527", "Oberweis",
"493961", "Altentreptow",
"497071", "Tübingen",
"496652", "Hünfeld",
"495421", "Dissen\ am\ Teutoburger\ Wald",
"4936871", "Bad\ Colberg\-Heldburg",
"4933964", "Fretzdorf",
"4939322", "Tangermünde",
"499837", "Haundorf",
"497545", "Immenstaad\ am\ Bodensee",
"496567", "Oberkail",
"4938789", "Wolfshagen\ bei\ Perleberg",
"498283", "Neuburg\ an\ der\ Kammel",
"496745", "Gondershausen",
"498131", "Dachau",
"496656", "Ebersburg",
"4936944", "Rentwertshausen",
"494948", "Wiesmoor\-Marcardsmoor",
"494361", "Oldenburg\ in\ Holstein",
"494155", "Büchen",
"499941", "Kötzting",
"494453", "Zetel",
"4933924", "Rägelin",
"4939037", "Pretzier",
"495957", "Lindern\ Oldenburg",
"4939362", "Grieben\ bei\ Tangerhütte",
"4934605", "Gröbers",
"496771", "St\ Goarshausen",
"4938796", "Viesecke",
"499975", "Waldmünchen\-Geigant",
"49471", "Bremerhaven",
"4939059", "Wegenstedt",
"497045", "Oberderdingen",
"497571", "Sigmaringen",
"496431", "Limburg\ an\ der\ Lahn",
"497635", "Schliengen",
"497570", "Sigmaringen\-Gutenstein",
"496430", "Hahnstätten",
"495484", "Lienen\-Kattenvenne",
"496285", "Walldürn\-Altheim",
"4933633", "Spreenhagen",
"498743", "Geisenhausen",
"493647", "Pössneck",
"499556", "Geiselwind",
"495921", "Nordhorn",
"492156", "Willich\-Anrath",
"4936043", "Kirchheilingen",
"4934493", "Gössnitz\ Thüringen",
"493461", "Merseburg\ Saale",
"4937206", "Frankenberg\ Sachsen",
"494524", "Scharbeutz\-Pönitz",
"499088", "Mönchsdeggingen",
"4938481", "Witzin",
"4934322", "Rosswein",
"492152", "Kempen",
"4935697", "Bagenz",
"494179", "Winsen\-Tönnhausen",
"499552", "Burghaslach",
"495457", "Hopsten\-Schale",
"498782", "Pfeffenhausen",
"4939388", "Goldbeck\ Altm",
"4939605", "Gross\ Nemerow",
"4934362", "Mügeln\ bei\ Oschatz",
"4939996", "Törpin",
"494953", "Bunde",
"499441", "Kelheim",
"4939001", "Apenburg",
"496387", "Sankt\ Julian",
"493629", "Stadtilm",
"498246", "Waal",
"499173", "Thalmässing",
"492573", "Nordwalde",
"493537", "Jessen\ Elster",
"499735", "Massbach",
"495839", "Wittingen\-Ohrdorf",
"498094", "Steinhöring",
"497305", "Erbach\ Donau",
"4935955", "Pulsnitz",
"498453", "Reichertshofen\ Oberbayern",
"4934296", "Groitzsch\ bei\ Pegau",
"497436", "Messstetten\-Oberdigisheim",
"498361", "Nesselwang",
"4933369", "Oderberg",
"494131", "Lüneburg",
"499107", "Trautskirchen",
"494283", "Tarmstedt",
"492507", "Havixbeck",
"492538", "Drensteinfurt\-Rinkerode",
"497904", "Ilshofen",
"497432", "Albstadt\-Tailfingen",
"496572", "Manderscheid\ Eifel",
"492271", "Bergheim\ Erft",
"498801", "Seeshaupt",
"495491", "Damme\ Dümmer",
"495845", "Bergen\ Dumme",
"499749", "Oberbach\ Unterfranken",
"4936948", "Römhild",
"494743", "Langen\ bei\ Bremerhaven",
"4936606", "Kraftsdorf",
"4933928", "Wildberg\ Brandenburg",
"492245", "Much",
"4933052", "Leegebruch",
"4934384", "Grossbothen",
"497651", "Titisee\-Neustadt",
"49365", "Gera",
"496455", "Frankenau\ Hessen",
"495254", "Paderborn\-Schloss\ Neuhaus",
"49871", "Landshut",
"497328", "Königsbronn",
"4933968", "Meyenburg\ Kreis\ Prignitz",
"499289", "Schwarzenbach\ am\ Wald",
"493525", "Riesa",
"499727", "Schonungen\-Marktsteinach",
"4939973", "Altkalen",
"497936", "Schrozberg\-Bartenstein",
"497273", "Hagenbach\ Pfalz",
"499374", "Eschau",
"4939296", "Welsleben",
"499825", "Herrieden",
"495065", "Sibbesse",
"499672", "Neunburg\ vorm\ Wald",
"498179", "Eurasburg\ an\ der\ Loisach",
"499676", "Winklarn",
"4935452", "Golssen",
"497404", "Epfendorf",
"497932", "Niederstetten\ Württemberg",
"498081", "Dorfen\ Stadt",
"4936029", "Menteroda",
"4939384", "Arendsee\ Altmark",
"494758", "Nordleda",
"496479", "Waldbrunn\ Westerwald",
"4935266", "Heyda\ bei\ Riesa",
"4938234", "Born\ Darss",
"494242", "Syke",
"498581", "Waldkirchen\ Niederbayern",
"498024", "Holzkirchen",
"495109", "Ronnenberg",
"497627", "Steinen\ Kreis\ Lörrach",
"4933982", "Hoppenrade\ Kreis\ Prignitz",
"4938306", "Samtens",
"494246", "Twistringen\-Heiligenloh",
"4934973", "Osternienburg",
"4939777", "Borkenfriede",
"495565", "Einbeck\-Wenzen",
"492653", "Kaisersesch",
"497172", "Lorch\ Württemberg",
"498036", "Stephanskirchen\ Simssee",
"499738", "Rottershausen",
"494731", "Nordenham",
"497053", "Bad\ Teinach\-Zavelstein",
"49641", "Giessen",
"497337", "Nellingen\ Alb",
"497308", "Nersingen",
"499149", "Weissenburg\-Suffersheim",
"497176", "Spraitbach",
"4939959", "Dargun",
"498032", "Rohrdorf\ Kreis\ Rosenheim",
"494471", "Cloppenburg",
"498344", "Westendorf\ bei\ Kaufbeuren",
"498642", "Übersee",
"49811", "Hallbergmoos",
"496753", "Meisenheim",
"492639", "Anhausen\ Kreis\ Neuwied",
"492942", "Geseke",
"4938855", "Lübtheen",
"498821", "Garmisch\-Partenkirchen",
"494445", "Visbek\ Kreis\ Vechta",
"4939400", "Wefensleben",
"498532", "Griesbach\ im\ Rottal",
"494143", "Drochtersen",
"492527", "Lippetal\-Lippborg",
"4933767", "Friedersdorf\ bei\ Berlin",
"4938826", "Dassow",
"499267", "Nordhalben",
"499127", "Rosstal\ Mittelfrankenanken",
"4935609", "Drachhausen",
"4934978", "Radegast\ Kreis\ Köthen",
"498536", "Kösslarn",
"4938451", "Hoppenrade\ bei\ Güstrow",
"499085", "Alerheim",
"497553", "Salem\ Baden",
"4934901", "Rosslau\ Elbe",
"4938370", "Kröslin",
"4934494", "Ehrenhain",
"492983", "Winterberg\-Siedlinghausen",
"493371", "Luckenwalde",
"4933634", "Berkenbrück\ Kreis\ Oder\-Spree",
"4939089", "Bismark\ Altmark",
"494182", "Tostedt",
"4938737", "Ganzlin",
"4935026", "Dürrröhrsdorf\-Dittersbach",
"495129", "Söhlde",
"495574", "Oberweser",
"492051", "Velbert",
"497235", "Unterreichenbach\ Kreis\ Calw",
"4933836", "Butzow\ bei\ Brandenburg",
"494971", "Esens",
"494186", "Buchholz\-Trelde",
"4935055", "Höckendorf\ bei\ Dippoldiswalde",
"497395", "Ehingen\-Dächingen",
"499978", "Schönthal\ Oberpfalz",
"4936943", "Bettenhausen\ Thüringen",
"4938759", "Tewswoos",
"4937291", "Augustusburg",
"4933923", "Flecken\ Zechlin",
"492309", "Waltrop",
"492551", "Steinfurt\-Burgsteinfurt",
"495074", "Rodewald",
"498504", "Tittling",
"495147", "Uetze\-Hänigsen",
"497424", "Spaichingen",
"499365", "Rimpar",
"494158", "Roseburg",
"499151", "Hersbruck",
"494945", "Grossefehn\-Timmel",
"496252", "Heppenheim\ Bergstrasse",
"4936732", "Könitz",
"498857", "Benediktbeuern",
"4933963", "Wulfersdorf\ bei\ Wittstock",
"496139", "Budenheim",
"492446", "Heimbach\ Eifel",
"498683", "Tittmoning",
"496256", "Lampertheim\-Hüttenfeld",
"499805", "Burgoberbach",
"4939978", "Gross\ Roge",
"494642", "Kappeln\ Schlei",
"494939", "Baltrum",
"4934445", "Stössen",
"494344", "Schönberg\ Holstein",
"4936691", "Eisenberg\ Thüringen",
"499964", "Stallwang",
"4934498", "Rositz",
"496589", "Kell\ am\ See",
"494884", "Schwabstedt",
"492253", "Bad\ Münstereifel",
"4936072", "Weissenborn\-Lüderode",
"4938233", "Prerow\ Ostseebad",
"494755", "Ihlienworth",
"494646", "Mohrkirch",
"498731", "Dingolfing",
"496145", "Flörsheim\ am\ Main",
"4939383", "Sandau\ Elbe",
"493944", "Blankenburg\ Harz",
"496443", "Ehringshausen\ Dill",
"497227", "Lichtenau\ Baden",
"494536", "Steinhorst\ Lauenburg",
"495853", "Neu\ Darchau",
"492597", "Senden\ Westfalen",
"499272", "Fichtelberg",
"496171", "Oberursel\ Taunus",
"499197", "Egloffstein",
"497673", "Schönau\ im\ Schwarzwald",
"498143", "Inning\ am\ Ammersee",
"495068", "Elze\ Leine",
"494532", "Bargteheide",
"4934242", "Hohenpriessnitz",
"499828", "Rügland",
"498445", "Gerolsbach",
"494821", "Itzehoe",
"497249", "Stutensee",
"4933677", "Glienicke\ bei\ Beeskow",
"495401", "Georgsmarienhütte",
"499933", "Wallersdorf",
"499276", "Bischofsgrün",
"495654", "Herleshausen",
"499464", "Walderbach",
"4933395", "Zerpenschleuse",
"497251", "Bruchsal",
"495352", "Schöningen",
"497250", "Kraichtal",
"497325", "Sontheim\ an\ der\ Brenz",
"492645", "Vettelschoss",
"493528", "Radeberg",
"4937754", "Zwönitz",
"492248", "Hennef\-Uckerath",
"4933082", "Menz\ Kreis\ Oberhavel",
"4935877", "Cunewalde",
"495356", "Helmstedt\-Barmke",
"495199", "Schneverdingen\-Heber",
"4938391", "Altenkirchen\ Rügen",
"494779", "Freiburg\ Elbe",
"496458", "Rosenthal\ Hessen",
"4934383", "Trebsen\ Mulde",
"492752", "Bad\ Laasphe",
"4939201", "Wolmirstedt",
"499773", "Unsleben",
"494683", "Oldsum",
"495848", "Trebel",
"494857", "Barlt",
"4936969", "Merkers",
"496486", "Katzenelnbogen",
"498158", "Tutzing",
"4939242", "Prödel",
"494504", "Ratekau",
"496809", "Grossrosseln",
"496482", "Runkel",
"492671", "Cochem",
"4936929", "Ruhla",
"495901", "Fürstenau\ bei\ Bramsche",
"492535", "Sendenhorst\-Albersloh",
"499433", "Nabburg",
"499135", "Hessdorf\ Mittelfrankenanken",
"4933638", "Rüdersdorf\ bei\ Berlin",
"4938485", "Dabel",
"499395", "Triefenstein",
"498258", "Sielenbach",
"4935433", "Vetschau",
"4933238", "Senzke",
"499235", "Thierstein",
"498742", "Velden\ Vils",
"499480", "Sünching",
"494488", "Westerstede",
"4936643", "Thimmendorf",
"499481", "Pfatter",
"499638", "Neualbenreuth",
"4934637", "Frankleben",
"499607", "Luhe\-Wildenau",
"4939005", "Kusey",
"496329", "Weidenthal\ Pfalz",
"494630", "Barderup",
"494631", "Glücksburg\ Ostsee",
"4939601", "Friedland",
"498282", "Krumbach\ Schwaben",
"499548", "Mühlhausen\ Mittelfranken",
"497805", "Appenweier",
"494541", "Ratzeburg",
"492955", "Büren\-Wewelsburg",
"494452", "Zetel\-Neuenburg",
"4934347", "Oelzschau\ bei\ Borna",
"495339", "Gielde",
"495944", "Hoogstede",
"492739", "Wilnsdorf",
"497365", "Essingen\ Württemberg",
"497150", "Korntal\-Münchingen",
"497151", "Waiblingen",
"499424", "Strasskirchen",
"4939724", "Klein\ Bünzow",
"4936333", "Heringen\ Helme",
"496653", "Burghaun",
"496347", "Hochstadt\ Pfalz",
"4935951", "Neukirch\ Lausitz",
"494456", "Varel\-Altjührden",
"496887", "Schmelz\ Saar",
"4934659", "Blankenheim\ bei\ Sangerhausen",
"494861", "Tönning",
"499868", "Schillingsfürst",
"497478", "Hirrlingen",
"496507", "Neumagen\-Dhron",
"496785", "Herrstein",
"495028", "Pennigsehl",
"498243", "Fuchstal",
"499176", "Allersberg",
"493901", "Salzwedel",
"49421", "Bremen",
"4936875", "Straufhain\-Streufdorf",
"4934601", "Teutschenthal",
"498679", "Burgkirchen\ an\ der\ Alz",
"499337", "Gaukönigshofen",
"497585", "Ostrach",
"497707", "Bräunlingen",
"497738", "Steisslingen",
"492572", "Emsdetten",
"496271", "Eberbach\ Baden",
"499172", "Georgensgmünd",
"496854", "Oberthal\ Saar",
"494559", "Wensin",
"4935936", "Sohland\ Spree",
"4935823", "Ostritz",
"497085", "Enzklösterle",
"492455", "Waldfeucht",
"499553", "Ebrach\ Oberfranken",
"4938228", "Dettmannsdorf\-Kölzow",
"492153", "Nettetal\-Lobberich",
"497267", "Gemmingen",
"495609", "Ahnatal",
"497127", "Neckartenzlingen",
"495444", "Wagenfeld",
"4939347", "Kade",
"4937324", "Reinsberg\ Sachsen",
"498783", "Rohr\ in\ Niederbayern",
"494952", "Rhauderfehn",
"496245", "Biblis",
"499924", "Bodenmais",
"496648", "Bad\ Salzschlirf",
"4937364", "Reitzenhain\ Erzgebirge",
"494956", "Uplengen",
"496007", "Rosbach\-Rodheim",
"495528", "Gieboldehausen",
"496239", "Bobenheim\-Roxheim",
"494746", "Hagen\ bei\ Bremerhaven",
"498041", "Bad\ Tölz",
"4937382", "Geringswalde",
"498631", "Mühldorf\ am\ Inn",
"498630", "Oberneukirchen",
"4939728", "Medow\ bei\ Anklam",
"494742", "Dorum",
"496152", "Gross\-Gerau",
"499251", "Münchberg",
"499325", "Kleinlangheim",
"494258", "Schwarme",
"499874", "Neuendettelsau",
"4934782", "Mansfeld\ Südharz",
"495247", "Harsewinkel",
"497464", "Talheim\ Kreis\ Tuttlingen",
"496073", "Babenhausen\ Hessen",
"497135", "Brackenheim",
"498456", "Lenting",
"497433", "Balingen",
"496573", "Gillenfeld",
"494286", "Gyhum",
"492387", "Drensteinfurt\-Walstedde",
"4933234", "Wustermark",
"492931", "Arnsberg",
"498452", "Geisenfeld",
"498075", "Amerang",
"495505", "Hardegsen",
"497773", "Bodman\-Ludwigshafen",
"496188", "Kahl\ am\ Main",
"498541", "Vilshofen\ Niederbayern",
"4939320", "Schinne",
"494282", "Sittensen",
"4935209", "Mohorn",
"4937368", "Deutschneudorf",
"499167", "Oberscheinfeld",
"499227", "Neuenmarkt",
"492567", "Ahaus\-Alstätte",
"495345", "Baddeckenstedt",
"492652", "Mendig",
"492354", "Meinerzhagen",
"4937328", "Grossschirma",
"4936783", "Gehren\ Thüringen",
"495754", "Extertal\-Bremke",
"49821", "Augsburg",
"4933977", "Gumtow",
"494243", "Twistringen",
"497964", "Stödtlen",
"498860", "Bernbeuren",
"4938224", "Gresenhorst",
"492745", "Brachbach\ Sieg",
"492656", "Virneburg",
"498861", "Schongau",
"497933", "Creglingen",
"493574", "Lauchhammer",
"497276", "Herxheim\ bei\ Landau\ Pfalz",
"492771", "Dillenburg",
"492688", "Kroppach",
"492770", "Eschenburg",
"4933652", "Neuzelle",
"492431", "Erkelenz",
"499673", "Tiefenbach\ Oberpfalz",
"495371", "Gifhorn",
"497272", "Rülzheim",
"499766", "Grosswenkheim",
"495445", "Drebber",
"496092", "Heimbuchenthal",
"496244", "Westhofen\ Rheinhessenen",
"495143", "Winsen\ Aller",
"497084", "Schömberg\ bei\ Neuenbürg",
"492454", "Gangelt",
"497520", "Bodnegg",
"497832", "Haslach\ im\ Kinzigtal",
"4934977", "Quellendorf",
"496721", "Bingen\ am\ Rhein",
"4939773", "Altwarp",
"499762", "Saal\ an\ der\ Saale",
"498687", "Taching\-Tengling",
"496096", "Wiesen\ Unterfranken",
"499925", "Bayerisch\ Eisenstein",
"4933768", "Prieros",
"4938296", "Rerik\ Ostseebad",
"497836", "Schiltach",
"499202", "Waischenfeld",
"496101", "Bad\ Vilbel",
"4933674", "Trebatsch",
"4934652", "Allstedt",
"496784", "Weierbach",
"496596", "Üdersdorf",
"4937431", "Mehltheuer\ Vogtland",
"495731", "Bad\ Oeynhausen",
"497021", "Kirchheim\ unter\ Teck",
"499206", "Mistelgau\-Obernsees",
"497584", "Altshausen",
"495471", "Bohmte",
"492331", "Hagen\ Westfalen",
"4933876", "Buschow",
"4938353", "Gützkow\ bei\ Greifswald",
"496855", "Freisen",
"492330", "Herdecke",
"496592", "Daun",
"492291", "Waldbröl",
"4937465", "Tannenbergsthal\ Vogtland",
"4935874", "Bernstadt\ an\ der\ Eigen",
"495158", "Hemeringen",
"495945", "Wilsum",
"497804", "Oppenau",
"497666", "Denzlingen",
"492954", "Rüthen\-Oestereiden",
"496757", "Becherbach\ bei\ Kirn",
"4934773", "Schwittersdorf",
"497557", "Herdwangen\-Schönach",
"4939977", "Jördenstorf",
"493679", "Neuhaus\ am\ Rennweg",
"498388", "Hergensweiler",
"499263", "Ludwigsstadt",
"497364", "Oberkochen",
"499123", "Lauf\ an\ der\ Pegnitz",
"497662", "Vogtsburg\ im\ Kaiserstuhl",
"4937757", "Rittersgrün",
"492523", "Wadersloh",
"4938738", "Karow\ bei\ Lübz",
"495182", "Gronau\ Leine",
"497333", "Laichingen",
"499234", "Neusorg",
"4936653", "Lehesten\ Thüringer\ Wald",
"494129", "Haseldorf",
"494269", "Ahausen\-Kirchwalsede",
"499394", "Esselbach",
"495186", "Salzhemmendorf\-Wallensen",
"495971", "Rheine",
"498654", "Freilassing",
"492601", "Nauort",
"4936020", "Ebeleben",
"494853", "Sankt\ Michaelisdonn",
"4936622", "Triebes",
"493631", "Nordhausen\ Thüringen",
"4939885", "Jakobshagen",
"499777", "Ostheim\ von\ der\ Rhön",
"495536", "Holzminden\-Neuhaus",
"496026", "Grossostheim",
"4939050", "Bartensleben",
"4933678", "Storkow\ Mark",
"494401", "Brake\ Unterweser",
"4933601", "Podelzig",
"49511", "Hannover",
"4939481", "Hedersleben\ bei\ Aschersleben",
"499408", "Altenthann",
"495532", "Stadtoldendorf",
"496022", "Obernburg\ am\ Main",
"495820", "Suhlendorf",
"495821", "Bad\ Bevensen",
"495032", "Neustadt\ am\ Rübenberge",
"4933764", "Mittenwalde\ Mark",
"499560", "Grub\ am\ Forst",
"496522", "Mettendorf",
"499561", "Coburg",
"496831", "Saarlouis",
"492161", "Mönchengladbach",
"492355", "Schalksmühle",
"495642", "Warburg\-Scherfede",
"495939", "Sustrum",
"497726", "Bad\ Dürrheim",
"4939934", "Gross\ Plasten",
"495344", "Lengede",
"4934497", "Langenleuba\-Niederhain",
"4936744", "Remda",
"4938780", "Lanz\ Brandenburg",
"497965", "Ellwangen\-Röhlingen",
"495036", "Neustadt\-Schneeren",
"496526", "Bollendorf",
"492744", "Herdorf",
"493541", "Calau",
"4935693", "Lauschütz",
"495755", "Kalletal\-Varenholz",
"4933332", "Gartz\ Oder",
"495646", "Willebadessen",
"497722", "Triberg\ im\ Schwarzwald",
"499193", "Höchstadt\ an\ der\ Aisch",
"499841", "Bad\ Windsheim",
"4935726", "Gross\ Särchen",
"494848", "Rantrum",
"495857", "Bleckede\-Brackede",
"499495", "Breitenbrunn\ Oberpfalz",
"492593", "Ascheberg\ Westfalen",
"4935241", "Lommatzsch",
"497134", "Weinsberg",
"493301", "Oranienburg",
"499381", "Volkach",
"498709", "Eching\ Niederbayern",
"495683", "Wabern\ Hessen",
"4938322", "Richtenberg",
"4935755", "Ortrand",
"499937", "Oberpöring",
"499908", "Schöfweg",
"496429", "Schweinsberg\ Hessen",
"4935202", "Klingenberg\ Sachsen",
"4933637", "Beerfelde",
"493860", "Raben\ Steinfeld",
"493861", "Plate",
"498074", "Schnaitsee",
"495504", "Friedland\ Kreis\ Göttingen",
"499626", "Hohenburg",
"498574", "Wittibreut",
"492379", "Menden\-Asbeck",
"494352", "Damp",
"4935842", "Oderwitz",
"495439", "Bersenbrück",
"499875", "Wolframs\-Eschenbach",
"496447", "Langgöns\-Niederkleen",
"497223", "Bühl\ Baden",
"499324", "Dettelbach",
"497163", "Ebersbach\ an\ der\ Fils",
"497465", "Emmingen\-Liptingen",
"496660", "Steinau\-Marjoss",
"499622", "Hirschau\ Oberpfalz",
"4939033", "Wallstawe",
"496661", "Schlüchtern",
"494356", "Gross\ Wittensee",
"498269", "Unteregg\ bei\ Mindelheim",
"492257", "Reckerscheid",
"496621", "Bad\ Hersfeld",
"498505", "Hutthurm",
"4934348", "Frohburg",
"495452", "Mettingen\ Westfalen",
"499662", "Vilseck",
"497425", "Trossingen",
"496620", "Philippsthal\ Werra",
"494339", "Christiansholm",
"4939952", "Grammentin",
"499364", "Zellingen",
"497123", "Metzingen\ Württemberg",
"497263", "Waibstadt",
"494944", "Wiesmoor",
"492157", "Nettetal\-Kaldenkirchen",
"495541", "Hann\.\ Münden",
"496003", "Rosbach\ von\ der\ Höhe",
"495456", "Westerkappeln\-Velpe",
"499666", "Illschwang",
"499804", "Aurach",
"496358", "Kriegsfeld",
"493344", "Bad\ Freienwalde",
"4933237", "Paulinenaue",
"4935602", "Drebkau",
"496386", "Altenkirchen\ Pfalz",
"496503", "Hermeskeil",
"498247", "Bad\ Wörishofen",
"493821", "Ribnitz\-Damgarten",
"4934263", "Hohburg",
"495041", "Springe\ Deister",
"497703", "Bonndorf\ im\ Schwarzwald",
"499293", "Berg\ Oberfranken",
"496842", "Blieskastel",
"497394", "Schelklingen",
"496684", "Hofbieber\-Schwarzbach",
"4934223", "Dommitzsch",
"4934638", "Zöschen",
"495631", "Korbach",
"496382", "Lauterecken",
"497234", "Tiefenbronn",
"499333", "Sommerhausen",
"494444", "Goldenstedt",
"496566", "Körperich",
"494609", "Eggebek",
"4939395", "Wanzer",
"4936425", "Isserstedt",
"498370", "Wiggensbach",
"4933974", "Dessow",
"4939348", "Klitsche",
"495952", "Sögel",
"499836", "Gunzenhausen\-Cronheim",
"497762", "Wehr\ Baden",
"4938227", "Lüdershagen\ bei\ Barth",
"4938845", "Kaarssen",
"499832", "Wassertrüdingen",
"495956", "Rastdorf",
"492261", "Gummersbach",
"4939082", "Mieste",
"499521", "Hassfurt",
"4936465", "Oberndorf\ bei\ Apolda",
"499084", "Bissingen\ Schwaben",
"496562", "Speicher",
"494528", "Schönwalde\ am\ Bungsberg",
"4933841", "Belzig",
"4936373", "Buttstädt",
"496657", "Hofbieber",
"496343", "Bad\ Bergzabern",
"4936083", "Uder",
"49281", "Wesel",
"49521", "Bielefeld",
"498754", "Volkenschwand",
"4933201", "Gross\ Glienicke",
"4936739", "Rottenbach",
"4935365", "Falkenberg\ Elster",
"495861", "Dannenberg\ Elbe",
"4939263", "Unseburg",
"4935473", "Neu\ Lübbenau",
"496062", "Erbach\ Odenwald",
"493504", "Dippoldiswalde",
"4935325", "Rückersdorf\ bei\ Finsterwalde",
"4938752", "Zierzow\ bei\ Ludwigslust",
"498345", "Stöttwang",
"4939740", "Nechlin",
"4938205", "Tessin\ bei\ Rostock",
"496066", "Michelstadt\-Vielbrunn",
"497202", "Karlsbad",
"495301", "Lehre\-Essenrode",
"495300", "Salzgitter\-Üfingen",
"4939223", "Theessen",
"499603", "Floss",
"493683", "Schmalkalden",
"493471", "Bernburg\ Saale",
"495286", "Ottenstein\ Niedersachsen",
"492858", "Hünxe",
"497937", "Dörzbach",
"492534", "Münster\-Roxel",
"494169", "Sauensiek",
"4936253", "Georgenthal\ Thüringer\ Wald",
"499134", "Neunkirchen\ am\ Brand",
"4935797", "Schwepnitz",
"497381", "Münsingen",
"495282", "Schieder\-Schwalenberg",
"4938723", "Kladrum",
"496691", "Schwalmstadt",
"497841", "Achern",
"493731", "Freiberg\ Sachsen",
"497193", "Sulzbach\ an\ der\ Murr",
"499677", "Oberviechtach\-Pullenried",
"494505", "Stockelsdorf\-Curau",
"492644", "Linz\ am\ Rhein",
"492409", "Stolberg\-Gressenich",
"4934923", "Cobbelsdorf",
"4939727", "Spantekow",
"495655", "Wanfried",
"499465", "Neukirchen\-Balbini",
"492563", "Stadtlohn",
"495746", "Rödinghausen",
"497622", "Schopfheim",
"497324", "Herbrechtingen",
"499223", "Rugendorf",
"499163", "Dachsbach",
"4939455", "Schierke",
"4939851", "Göritz\ bei\ Prenzlau",
"495258", "Salzkotten",
"493445", "Naumburg\ Saale",
"494247", "Affinghausen",
"4934344", "Kohren\-Sahlis",
"495742", "Preussisch\ Oldendorf",
"4939426", "Hessen",
"497626", "Kandern",
"492506", "Münster\-Wolbeck",
"492383", "Bönen",
"4933089", "Himmelpfort",
"493971", "Anklam",
"499106", "Markt\ Erlbach",
"49631", "Kaiserslautern",
"492843", "Rheinberg",
"492191", "Remscheid",
"496201", "Weinheim\ Bergstr",
"499102", "Wilhermsdorf",
"492502", "Nottuln",
"497777", "Sauldorf",
"499378", "Eichenbühl\-Riedern",
"498444", "Schweitenkirchen",
"494371", "Burg\ auf\ Fehmarn",
"499722", "Werneck",
"49214", "Leverkusen",
"496761", "Simmern\ Hunsrück",
"4939923", "Priborn",
"494885", "Bergenhusen",
"4937367", "Lengefeld\ Erzgebirge",
"4936922", "Gerstungen",
"499965", "Sankt\ Englmar",
"4934466", "Janisroda",
"498028", "Fischbachau",
"496144", "Bischofsheim\ bei\ Rüsselsheim",
"499091", "Monheim\ Schwaben",
"499090", "Rain\ Lech",
"499726", "Euerbach",
"4936962", "Vacha",
"4934426", "Kayna",
"4933733", "Stülpe",
"494754", "Bülkau",
"4933978", "Segeletz",
"4937327", "Rechenberg\-Bienenmühle",
"497561", "Leutkirch\ im\ Allgäu",
"4939344", "Güsen",
"496395", "Münchweiler\ an\ der\ Rodalb",
"4935471", "Birkenhainchen",
"4933203", "Kleinmachnow",
"492825", "Uedem",
"492374", "Iserlohn\-Letmathe",
"496235", "Schifferstadt",
"4933397", "Wandlitz",
"495434", "Essen\ Oldenburg",
"497685", "Gutach\-Bleibach",
"4935892", "Horka\ OL",
"495902", "Freren",
"492672", "Treis\-Karden",
"4939746", "Krackow",
"496638", "Schwalmtal\-Renzendorf",
"495774", "Wagenfeld\-Ströhen",
"4939221", "Möckern\ bei\ Magdeburg",
"49791", "Schwäbisch\ Hall",
"495906", "Lünne",
"496048", "Büdingen\-Eckartshausen",
"498124", "Forstern\ Oberbayern",
"492676", "Ulmen",
"4937464", "Schöneck\ Vogtland",
"4935875", "Obercunnersdorf\ bei\ Löbau",
"494194", "Sievershütten",
"498233", "Kissing",
"497256", "Philippsburg",
"4939862", "Schmölln\ bei\ Prenzlau",
"498704", "Altdorf\-Pfettrach",
"492751", "Bad\ Berleburg",
"498393", "Holzgünz",
"497139", "Neuenstadt\ am\ Kocher",
"492750", "Diedenshausen",
"494323", "Bornhöved",
"495225", "Spenge",
"4933843", "Niemegk",
"495165", "Rethem\ Aller",
"497252", "Bretten",
"4936371", "Schlossvippach",
"495351", "Helmstedt",
"4936081", "Arenshausen",
"494967", "Rhauderfehn\-Burlage",
"493923", "Zerbst",
"499347", "Wittighausen",
"499653", "Eslarn",
"4936450", "Kranichfeld",
"496424", "Ebsdorfergrund",
"493838", "Bergen\ auf\ Rügen",
"497748", "Grafenhausen\ Hochschwarzwald",
"4939822", "Kratzeburg",
"495509", "Rosdorf\ Kreis\ Göttingen",
"494822", "Kellinghusen",
"496868", "Mettlach\-Tünsdorf",
"494531", "Bad\ Oldesloe",
"4934261", "Kühren\ bei\ Wurzen",
"4937346", "Geyer",
"498555", "Perlesreut",
"495934", "Haren\-Rütenbrock",
"495402", "Bissendorf\ Kreis\ Osnabrück",
"4934221", "Schildau\ Gneisenaustadt",
"496308", "Olsbrücken",
"49741", "Rottweil",
"496337", "Grossbundenbach",
"494826", "Hohenlockstedt",
"4934746", "Giersleben",
"496297", "Ravenstein\ Baden",
"496053", "Wächtersbach",
"496172", "Bad\ Homburg\ von\ der\ Höhe",
"499271", "Thurnau\-Alladorf",
"495406", "Belm",
"499270", "Creussen",
"499854", "Wittelshofen",
"496553", "Schönecken",
"495327", "Bad\ Grund\ Harz",
"499245", "Obertrubach",
"4939888", "Lychen",
"498732", "Frontenhausen",
"495963", "Bawinkel",
"494467", "Wittmund\-Funnix",
"493423", "Eilenburg",
"498055", "Halfing",
"499648", "Neustadt\ am\ Kulm",
"4937609", "Wolkenburg\ Mulde",
"4933675", "Tauche",
"494641", "Süderbrarup",
"497753", "Albbruck",
"497458", "Ebhausen",
"498194", "Vilgertshofen",
"497943", "Schöntal\ Jagst",
"4938735", "Plau\ am\ See",
"494264", "Sottrum\ Kreis\ Rotenburg",
"494124", "Glückstadt",
"492556", "Metelen",
"499156", "Neuhaus\ an\ der\ Pegnitz",
"4935754", "Klettwitz",
"4939921", "Ankershagen",
"492667", "Stein\-Neukirch",
"4935057", "Hermsdorf\ Erzgebirge",
"4933731", "Trebbin",
"492441", "Kall",
"4936209", "Klettbach",
"492440", "Nettersheim\-Tondorf",
"496251", "Bensheim",
"499152", "Hartenstein\ Mittelfranken",
"496874", "Wadern\-Nunkirchen",
"496325", "Lambrecht\ Pfalz",
"499073", "Gundelfingen\ an\ der\ Donau",
"492552", "Steinfurt\-Borghorst",
"495335", "Schladen",
"4938429", "Glasin",
"492173", "Langenfeld\ Rheinland",
"497482", "Horb\-Dettingen",
"4937468", "Treuen\ Vogtland",
"492052", "Velbert\-Langenberg",
"499573", "Staffelstein\ Oberfranken",
"495295", "Lichtenau\ Westfalen",
"494972", "Langeoog",
"4936849", "Kleinschmalkalden",
"497486", "Horb\-Altheim",
"493372", "Jüterbog",
"498323", "Immenstadt\ im\ Allgäu",
"492056", "Heiligenhaus",
"494393", "Boostedt",
"494704", "Drangstedt",
"492735", "Neunkirchen\ Siegerl",
"492588", "Harsewinkel\-Greffen",
"494180", "Königsmoor",
"494233", "Blender",
"499188", "Postbauer\-Heng",
"494976", "Spiekeroog",
"494181", "Buchholz\ in\ der\ Nordheide",
"497443", "Dornstetten",
"492837", "Weeze",
"496167", "Modautal",
"496227", "Walldorf\ Baden",
"497145", "Markgröningen",
"497958", "Rot\ Am\ See\-Brettheim",
"495768", "Petershagen\-Heimsen",
"4934921", "Kemberg",
"4933439", "Fredersdorf\-Vogelsdorf",
"496789", "Heimbach\ Nahe",
"492941", "Lippstadt",
"492368", "Oer\-Erkenschwick",
"494555", "Seedorf\ bei\ Bad\ Segeberg",
"4939884", "Hassleben\ bei\ Prenzlau",
"498531", "Pocking",
"494892", "Schenefeld\ Mittelholstein",
"4939853", "Holzendorf\ bei\ Prenzlau",
"498822", "Oberammergau",
"498031", "Rosenheim\ Oberbayern",
"492975", "Schmallenberg\-Oberkirchen",
"495605", "Kaufungen\ Hessen",
"4933457", "Altreetz",
"494736", "Butjadingen\-Tossens",
"496249", "Guntersblum",
"498641", "Grassau\ Kreis\ Traunstein",
"493493", "Bitterfeld",
"498640", "Reit\ Im\ Winkl",
"498467", "Kinding",
"494472", "Lastrup",
"494732", "Stadland\-Rodenkirchen",
"496673", "Haunetal",
"497171", "Schwäbisch\ Gmünd",
"495237", "Augustdorf",
"495208", "Leopoldshöhe",
"4933765", "Märkisch\ Buchholz",
"4938721", "Ziegendorf",
"497271", "Wörth\ am\ Rhein",
"495372", "Meinersen",
"497854", "Kehl\-Goldscheuer",
"496585", "Ralingen",
"495674", "Grebenstein",
"496707", "Windesheim",
"492904", "Bestwig",
"492432", "Wassenberg",
"4936464", "Wormstedt",
"494935", "Juist",
"4936651", "Lobenstein",
"49941", "Regensburg",
"492776", "Bad\ Endbach\-Hartenrod",
"495137", "Seelze",
"495108", "Gehrden\ Han",
"4938844", "Gülze",
"492436", "Wegberg\-Rödgen",
"493335", "Finowfurt",
"495376", "Wesendorf\ Kreis\ Gifhorn",
"498083", "Isen",
"496478", "Greifenstein\-Ulm",
"4933975", "Dannenwalde\ Kreis\ Prignitz",
"4936026", "Struth\ bei\ Mühlhausen",
"498427", "Wellheim",
"492772", "Herborn\ Hessen",
"494497", "Barssel\-Harkebrügge",
"4939394", "Hohenberg\-Krusemark",
"4936424", "Kahla\ Thüringen",
"498862", "Steingaden\ Oberbayern",
"494877", "Hennstedt\ bei\ Itzehoe",
"4938204", "Broderstorf",
"498583", "Neureichenau",
"4935324", "Crinitz",
"498306", "Ronsberg",
"496898", "Völklingen",
"4938309", "Trent",
"497245", "Durmersheim",
"496127", "Niedernhausen\ Taunus",
"496267", "Fahrenbach\ Baden",
"498178", "Icking",
"4935364", "Lebusa",
"498302", "Görisried",
"4934771", "Querfurt",
"492651", "Mayen",
"496085", "Waldsolms",
"492404", "Alsdorf\ Rheinland",
"492932", "Neheim\-Hüsten",
"498450", "Ingolstadt\-Zuchering",
"4934299", "Gaschwitz",
"498363", "Pfronten",
"4937433", "Gutenfürst",
"49991", "Deggendorf",
"494281", "Zeven",
"498542", "Ortenburg",
"499288", "Bad\ Steben",
"4939458", "Heudeber",
"494133", "Wittorf\ Kreis\ Lüneburg",
"494435", "Grossenkneten",
"497329", "Steinheim\ am\ Albuch",
"4933366", "Chorin",
"4933870", "Zollchow\ bei\ Rathenow",
"494775", "Grossenwörden",
"493605", "Leinefelde",
"498803", "Peissenberg",
"492273", "Kerpen\-Horrem",
"495493", "Neuenkirchen\ Kreis\ Vechta",
"495195", "Neuenkirchen\ bei\ Soltau",
"498546", "Windorf\-Otterskirchen",
"4938351", "Mesekenhagen",
"499748", "Motten",
"494740", "Loxstedt\-Dedesdorf",
"494741", "Nordholz\ bei\ Bremerhaven",
"492627", "Braubach",
"498046", "Bad\ Heilbrunn",
"497653", "Lenzkirch",
"497347", "Dietenheim",
"495873", "Eimke",
"496150", "Weiterstadt",
"498636", "Ampfing",
"499252", "Helmbrechts",
"496151", "Darmstadt",
"494224", "Gross\ Ippener",
"494164", "Harsefeld",
"498042", "Lenggries",
"498294", "Horgau",
"499256", "Stammbach",
"4939771", "Ueckermünde",
"496805", "Kleinblittersdorf",
"498334", "Bad\ Grönenbach",
"4937209", "Einsiedel\ bei\ Chemnitz",
"495923", "Schüttorf",
"495807", "Altenmedingen",
"495838", "Gross\ Oesingen",
"4938208", "Kavelstorf",
"495554", "Moringen",
"494951", "Weener",
"493628", "Arnstadt",
"499145", "Solnhofen",
"494950", "Holtland",
"4939999", "Tutow",
"4939031", "Dähre",
"492545", "Rosendahl\-Darfeld",
"499443", "Abensberg",
"495367", "Rühen",
"493774", "Schwarzenberg",
"494604", "Grossenwiehe",
"4939345", "Parchen",
"4936428", "Stadtroda",
"4939398", "Gross\ Garz",
"494302", "Kirchbarkau",
"492045", "Bottrop\-Kirchhellen",
"499170", "Schwanstetten",
"494178", "Radbruch",
"499171", "Roth\ Mittelfranken",
"4938848", "Vellahn",
"496272", "Hirschhorn\ Neckar",
"492571", "Greven\ Westfalen",
"495054", "Bergen\-Sülze",
"492635", "Rheinbrohl",
"4935243", "Weinböhla",
"492238", "Pulheim",
"492207", "Kürten\-Dürscheid",
"4933472", "Golzow\ bei\ Seelow",
"499089", "Bissingen\-Unterringingen",
"494862", "Garding",
"4938872", "Rehna",
"496276", "Hesseneck",
"493902", "Diesdorf\ Altm",
"494546", "Mustin\ Lauenburg",
"496464", "Angelburg",
"495423", "Versmold",
"493963", "Woldegk",
"497073", "Ammerbuch",
"494927", "Krummhörn\-Loquard",
"497152", "Leonberg\ Württemberg",
"495265", "Dörentrup",
"494803", "Pahlen",
"497156", "Ditzingen",
"498435", "Ehekirchen",
"4935691", "Bärenklau\ NL",
"498133", "Haimhausen\ Oberbayern",
"494542", "Mölln\ Lauenburg",
"498281", "Thannhausen\ Schwaben",
"499943", "Lam\ Oberpfalz",
"493327", "Werder\ Havel",
"494363", "Lensahn",
"494451", "Varel\ Jadebusen",
"4939007", "Tangeln",
"4934635", "Bad\ Lauchstädt",
"494334", "Bredenbek\ bei\ Rendsburg",
"494632", "Steinbergkirche",
"4934345", "Bad\ Lausick",
"496773", "Kamp\-Bornhofen",
"499369", "Uettingen",
"494294", "Riede\ Kreis\ Verden",
"492305", "Castrop\-Rauxel",
"498224", "Offingen\ Donau",
"494636", "Langballig",
"4939454", "Elbingerode\ Harz",
"4936482", "Triptis",
"495705", "Petershagen\-Windheim",
"4939056", "Klüden",
"499482", "Wörth\ an\ der\ Donau",
"497573", "Stetten\ am\ kalten\ Markt",
"496433", "Hadamar",
"498741", "Vilsbiburg",
"496135", "Bodenheim\ Rhein",
"492865", "Raesfeld",
"4933603", "Falkenhagen\ bei\ Seelow",
"4939483", "Ballenstedt",
"492697", "Blankenheim\-Ahrhütte",
"499621", "Amberg\ Oberpfalz",
"4935054", "Lauenstein\ Sachsen",
"495323", "Clausthal\-Zellerfeld",
"496364", "Nussbach\ Pfalz",
"4935456", "Terpt",
"496557", "Hallschlag",
"4939292", "Biederitz",
"496804", "Mandelbachtal",
"496666", "Freiensteinau",
"494509", "Gross\ Grönau",
"498335", "Fellheim",
"499358", "Gössenheim",
"494165", "Hollenstedt\ Nordheide",
"4933635", "Arensdorf\ Kreis\ Oder\-Spree",
"494351", "Eckernförde",
"498295", "Altenmünster\ Schwaben",
"494463", "Wangerland",
"492723", "Kirchhundem",
"499469", "Roding\-Neubäu",
"495659", "Ringgau",
"499846", "Ipsheim",
"4933986", "Falkenhagen\ Kreis\ Prignitz",
"494434", "Colnrade",
"4938302", "Sagard",
"494902", "Jemgum\-Ditzum",
"4933398", "Werneuchen",
"499386", "Prosselsheim",
"499503", "Oberhaid\ Oberfranken",
"493583", "Zittau",
"493306", "Gransee",
"492405", "Würselen",
"492103", "Hilden",
"499842", "Uffenheim",
"496293", "Schefflenz",
"495194", "Bispingen",
"496057", "Flörsbachtal",
"493866", "Cambs",
"4934603", "Nauendorf\ Sachsen\-Anhalt",
"494774", "Hechthausen",
"4935930", "Seitschen",
"499382", "Gerolzhofen",
"493302", "Hennigsdorf",
"496333", "Waldfischbach\-Burgalben",
"494327", "Grossenaspe",
"4933704", "Baruth\ Mark",
"499566", "Meeder",
"4939887", "Gerswalde",
"49208", "Oberhausen\ Rheinland",
"496836", "Überherrn",
"492226", "Rheinbach",
"492166", "Mönchengladbach\-Rheydt",
"497721", "Villingen\ im\ Schwarzwald",
"497720", "Schwenningen\ am\ Neckar",
"493542", "Lübbenau\ Spreewald",
"498237", "Aindling",
"498208", "Eurasburg\ bei\ Augsburg",
"492162", "Viersen",
"492222", "Bornheim\ Rheinland",
"496832", "Beckingen\-Reimsbach",
"499562", "Sonnefeld",
"496084", "Schmitten\ Taunus",
"4934292", "Brandis\ bei\ Wurzen",
"495031", "Wunstorf",
"494963", "Dörpen",
"499657", "Waldthurn",
"499343", "Lauda\-Königshofen",
"497244", "Weingarten\ Baden",
"493546", "Lübben\ Spreewald",
"495467", "Voltlage",
"4935953", "Burkau",
"495641", "Warburg",
"4936331", "Ilfeld",
"4934495", "Dobitschen",
"494934", "Marienhafe",
"494402", "Rastede",
"494349", "Dänischenhagen",
"495822", "Ebstorf",
"493636", "Greussen",
"496021", "Aschaffenburg",
"495675", "Trendelburg",
"496584", "Wellen\ Mosel",
"495531", "Holzminden",
"496020", "Heigenbrücken",
"492905", "Bestwig\-Ramsbeck",
"4933454", "Wölsickendorf\/Wollenberg",
"4933056", "Mühlenbeck\ Kreis\ Oberhavel",
"495278", "Höxter\-Ovenhausen",
"494406", "Berne",
"4936602", "Ronneburg\ Thüringen",
"493334", "Eberswalde",
"4938854", "Redefin",
"495826", "Suderburg",
"493632", "Sondershausen",
"4939603", "Burg\ Stargard",
"493949", "Oschersleben\ Bode",
"492602", "Montabaur",
"494295", "Emtinghausen",
"498463", "Greding",
"492304", "Schwerte",
"498165", "Neufahrn\ bei\ Freising",
"498225", "Jettingen\-Scheppach",
"497429", "Egesheim",
"494335", "Hohn\ bei\ Rendsburg",
"4939992", "Görmin",
"498509", "Ruderting",
"4937467", "Klingenthal\ Sachsen",
"4937755", "Schönheide\ Erzgebirge",
"493935", "Tangerhütte",
"495233", "Steinheim\ Westfalen",
"492864", "Reken",
"4937202", "Claussnitz\ bei\ Chemnitz",
"496134", "Mainz\-Kastel",
"492606", "Winningen\ Mosel",
"495181", "Alfeld\ Leine",
"495976", "Salzbergen",
"4939975", "Thürkow",
"498628", "Kienberg\ Oberbayern",
"4933394", "Blumberg\ Kreis\ Barnim",
"496677", "Neuenstein\ Hessen",
"495704", "Petershagen\-Friedewalde",
"4933479", "Küstrin\-Kietz",
"498774", "Bayerbach\ bei\ Ergoldsbach",
"492928", "Soest\-Ostönnen",
"496465", "Breidenbach\ bei\ Biedenkopf",
"497660", "St\ Peter\ Schwarzwald",
"497661", "Kirchzarten",
"495264", "Kalletal",
"497447", "Baiersbronn\-Schwarzenberg",
"492833", "Kerken",
"496163", "Höchst\ im\ Odenwald",
"496223", "Neckargemünd",
"493877", "Wittenberge",
"498434", "Rennertshofen",
"4935058", "Pretzschendorf",
"4936781", "Grossbreitenbach",
"4938858", "Lassahn",
"492332", "Gevelsberg",
"495055", "Fassberg",
"495472", "Bad\ Essen",
"496106", "Rodgau",
"497022", "Nürtingen",
"492634", "Rengsdorf",
"4933458", "Falkenberg\ Mark",
"494605", "Medelby",
"492292", "Windeck\ Sieg",
"49931", "Würzburg",
"496591", "Gerolstein",
"4939366", "Kehnert",
"494237", "Bendingbostel",
"495476", "Ostercappeln\-Venne",
"494208", "Grasberg",
"497026", "Lenningen",
"496102", "Neu\-Isenburg",
"499201", "Gesees",
"4935389", "Holzdorf\ Elster",
"492336", "Schwelm",
"493435", "Oschatz",
"495732", "Löhne",
"4934444", "Lützen",
"4934975", "Görzig\ Kreis\ Köthen",
"492296", "Reichshof\-Brüchermühle",
"498327", "Rettenberg",
"494768", "Hipstedt",
"492428", "Niederzier",
"499761", "Bad\ Königshofen\ im\ Grabfeld",
"496722", "Rüdesheim\ am\ Rhein",
"497947", "Forchtenberg",
"498406", "Böhmfeld",
"499144", "Pleinfeld",
"499077", "Bachhagel",
"496726", "Lorch\ Rheingau",
"497831", "Hausach",
"4933708", "Rangsdorf",
"498349", "Stötten\ am\ Auerberg",
"493741", "Plauen",
"4938792", "Lenzen\ \(Elbe\)",
"498402", "Münchsmünster",
"495555", "Moringen\-Fredelsloh",
"492663", "Westerburg\ Westerwald",
"497522", "Wangen\ im\ Allgäu",
"496766", "Kisselbach",
"499092", "Wemding",
"497343", "Buch\ bei\ Illertissen",
"499244", "Betzenstein",
"497657", "Eisenbach\ Hochschwarzwald",
"497562", "Isny\ im\ Allgäu",
"492623", "Ransbach\-Baumbach",
"4936941", "Wasungen",
"4937293", "Eppendorf\ Sachsen",
"4933921", "Zechlinerhütte",
"496762", "Kastellaun",
"499721", "Schweinfurt",
"499720", "Üchtelhausen",
"4936874", "Schönbrunn\ bei\ Hildburghaus",
"498054", "Breitbrunn\ am\ Chiemsee",
"497566", "Argenbühl",
"492501", "Münster\-Hiltrup",
"495935", "Twist\-Schöninghsdorf",
"498554", "Schönberg\ Niederbayern",
"499101", "Langenzenn",
"493976", "Torgelow\ bei\ Ueckermünde",
"4937365", "Sayda",
"496202", "Schwetzingen",
"497066", "Bad\ Rappenau\-Bonfeld",
"494137", "Barendorf",
"494108", "Rosengarten\ Kreis\ Harburg",
"498367", "Rosshaupten\ Forggensee",
"494372", "Westfehmarn",
"4935020", "Struppen",
"4939829", "Blankenförde",
"492196", "Wermelskirchen",
"492359", "Kierspe",
"494674", "Ockholm",
"496206", "Lampertheim",
"497062", "Beilstein\ Württemberg",
"4937325", "Niederbobritzsch",
"499855", "Dentlein\ am\ Forst",
"498807", "Diessen\ am\ Ammersee",
"492192", "Hückeswagen",
"4933830", "Ziesar",
"498705", "Altfraunhofen",
"494873", "Aukrug",
"497358", "Eberhardzell\-Füramoos",
"4939406", "Harbke",
"4935772", "Rietschen",
"495741", "Lübbecke",
"499499", "Painten",
"4939004", "Köckte\ bei\ Gardelegen",
"4938453", "Mistorf",
"4934903", "Coswig\ Anhalt",
"496123", "Eltville\ am\ Rhein",
"496263", "Neckargerach",
"495224", "Enger\ Westfalen",
"495164", "Hodenhagen",
"4935795", "Königsbrück",
"4938376", "Zirchow",
"497621", "Lörrach",
"496425", "Rauschenberg\ Hessen",
"497620", "Schopfheim\-Gersbach",
"4938484", "Ventschow",
"495281", "Bad\ Pyrmont",
"497382", "Römerstein",
"4939457", "Benneckenstein\ Harz",
"4937602", "Kirchberg\ Sachsen",
"496234", "Mutterstadt",
"492375", "Balve",
"493476", "Hettstedt\ Sachsen\-Anhalt",
"492824", "Kalkar",
"497684", "Glottertal",
"495435", "Berge\ bei\ Quakenbrück",
"496703", "Wöllstein\ Rheinhessen",
"496394", "Bundenthal",
"497842", "Kappelrodeck",
"496692", "Neustadt\ Hessen",
"494493", "Friesoythe\-Gehlenberg",
"498265", "Pfaffenhausen\ Schwaben",
"497503", "Wilhelmsdorf\ Württemberg",
"497386", "Hayingen",
"498423", "Titting",
"494195", "Hartenholm",
"495775", "Diepenau",
"496696", "Gilserberg",
"4938847", "Boizenburg\ Elbe",
"4938225", "Trinwillershagen",
"4936202", "Neudietendorf",
"4936766", "Schalkau",
"492974", "Schmallenberg\-Fredeburg",
"498728", "Geratskirchen",
"4939203", "Barleben",
"495604", "Grossalmerode",
"4936427", "Dornburg\ Saale",
"495302", "Vechelde",
"4939397", "Geestgottberg",
"4933746", "Werbig\ bei\ Jüterbog",
"492693", "Antweiler",
"499929", "Ruhmannsfelden",
"496408", "Buseck",
"497577", "Veringenstadt",
"49731", "Ulm\ Donau",
"496061", "Michelstadt",
"495306", "Cremlingen",
"495583", "Braunlage\-Hohegeiss",
"495862", "Hitzacker\ Elbe",
"4934692", "Alsleben\ Saale",
"4938462", "Baumgarten",
"498376", "Sulzberg\ Allgäu",
"495083", "Hohne\ bei\ Celle",
"496561", "Bitburg",
"499522", "Eltmann",
"492262", "Wiehl",
"499831", "Gunzenhausen",
"494838", "Tellingstedt",
"4935032", "Langenhennersdorf",
"495427", "Melle\-Buer",
"497144", "Marbach\ am\ Neckar",
"4936878", "Oberland",
"493967", "Oertzenhof\ bei\ Strasburg",
"494923", "Krummhörn\-Pewsum",
"492266", "Lindlar",
"495951", "Werlte",
"4934381", "Colditz",
"4938422", "Neukloster",
"499947", "Neukirchen\ bei\ Hl\ Blut",
"499526", "Riedbach",
"494367", "Grossenbrode",
"498372", "Obergünzburg",
"498137", "Petershausen",
"4938207", "Stäbelow",
"4936842", "Oberhof\ Thüringen",
"494554", "Wahlstedt",
"4938393", "Binz\ Ostseebad",
"497761", "Bad\ Säckingen",
"4935327", "Priessen",
"495294", "Hövelhof\-Espeln",
"496841", "Homburg\ Saar",
"495042", "Bad\ Münder\ am\ Deister",
"495334", "Hornburg\ Kreis\ Wolfenbüttel",
"496381", "Kusel",
"495632", "Willingen\ Upland",
"492474", "Nideggen\-Schmidt",
"4934203", "Zwenkau",
"492734", "Freudenberg\ Westfalen",
"499429", "Rain\ Niederbayern",
"492203", "Cologne\-Porz",
"4933432", "Müncheberg",
"495636", "Lichtenfels\-Goddelsheim",
"493531", "Finsterwalde",
"493675", "Sonneberg\ Thüringen",
"494705", "Wremen",
"496626", "Wildeck\-Obersuhl",
"495803", "Rosche",
"4938488", "Demen",
"495546", "Scheden",
"492763", "Drolshagen\-Bleche",
"498195", "Weil\ Kreis\ Landsberg\ am\ Lech",
"494423", "Fedderwarden",
"4933235", "Friesack",
"493641", "Jena",
"4936693", "Crossen\ an\ der\ Elster",
"494265", "Fintel",
"494125", "Seestermühe",
"496324", "Hassloch",
"496875", "Nonnweiler\-Primstal",
"499447", "Essing",
"495363", "Wolfsburg\-Vorsfelde",
"4939008", "Kunrau",
"494668", "Klanxbüll",
"495451", "Ibbenbüren",
"499661", "Sulzbach\-Rosenberg",
"496622", "Bebra",
"4938231", "Barth",
"495542", "Witzenhausen",
"499491", "Hemau",
"494498", "Saterland\-Ramsloh",
"496477", "Greifenstein\-Nenderoth",
"499845", "Oberdachstetten",
"492406", "Herzogenrath",
"499385", "Kolitzheim",
"4936870", "Masserberg",
"497629", "Tegernau\ Baden",
"495138", "Sehnde",
"498544", "Eging\ am\ See",
"498663", "Ruhpolding",
"492934", "Sundern\-Altenhellefeld",
"492402", "Stolberg\ Rheinland",
"496737", "Köngernheim",
"496708", "Bad\ Münster\ am\ Stein\-Ebernburg",
"493865", "Holthusen",
"498634", "Garching\ an\ der\ Alz",
"492963", "Brilon\-Messinghausen",
"4935455", "Walddrehna",
"4934781", "Greifenhagen",
"4933834", "Pritzerbe",
"498332", "Ottobeuren",
"498177", "Münsing\ Starnberger\ See",
"494222", "Ganderkesee",
"494162", "Jork",
"496128", "Taunusstein",
"496268", "Hüffenhardt",
"4938793", "Dergenthin",
"498292", "Dinkelscherben",
"4935727", "Burghammer",
"496665", "Sinntal\-Altengronau",
"498336", "Erkheim",
"496897", "Sulzbach\ Saar",
"497461", "Tuttlingen",
"4935024", "Stadt\ Wehlen",
"499871", "Windsbach",
"497353", "Schwendi",
"499254", "Gefrees",
"4933636", "Steinhöfel\ Kreis\ Oder\-Spree",
"4937381", "Penig",
"492327", "Bochum\-Wattenscheid",
"498296", "Villenbach",
"494166", "Ahlerstedt",
"4939489", "Strassberg\ Harz",
"4933609", "Brieskow\-Finkenheerd",
"4934496", "Nöbdenitz",
"4937203", "Gersdorf\ bei\ Chemnitz",
"492774", "Dietzhölztal",
"495676", "Liebenau\ Hessen",
"4938824", "Mallentin",
"493571", "Hoyerswerda",
"493635", "Kölleda",
"494405", "Edewecht",
"499287", "Selb",
"494103", "Wedel",
"4939000", "Beetzendorf",
"4933055", "Kremmen",
"499729", "Grettstadt",
"495825", "Wieren",
"495374", "Isenbüttel",
"497852", "Willstätt",
"495672", "Bad\ Karlshafen",
"492434", "Wegberg",
"492902", "Warstein",
"4939993", "Hohenmocker",
"498304", "Wildpoldsried",
"492351", "Lüdenscheid",
"492225", "Meckenheim\ Rheinland",
"492165", "Jüchen",
"496835", "Beckingen",
"492463", "Titz",
"499565", "Untersiemau",
"494723", "Cuxhaven\-Altenwalde",
"4935249", "Basslitz",
"492509", "Nottuln\-Appelhülsen",
"497961", "Ellwangen\ Jagst",
"497348", "Beimerstetten",
"492628", "Rhens",
"495751", "Rinteln",
"499747", "Geroda\ Bayern",
"4934293", "Naunhof\ bei\ Grimma",
"495941", "Neuenhaus\ Dinkel",
"495368", "Parsau",
"4937439", "Jocketa",
"494663", "Süderlügum",
"4935952", "Grossröhrsdorf\ OL",
"4935028", "Krippen",
"496466", "Dautphetal\-Friedensdorf",
"494544", "Berkenthin",
"496849", "Kirkel",
"495808", "Gerdau",
"495837", "Sprakensehl",
"499421", "Straubing",
"496462", "Gladenbach",
"499420", "Feldkirchen\ Niederbayern",
"497154", "Kornwestheim",
"4933838", "Päwesin",
"499484", "Brennberg",
"4936603", "Weida",
"498166", "Allershausen\ Oberbayern",
"498226", "Bibertal",
"494296", "Schwanewede\-Aschwarden",
"4939602", "Kleeth",
"492208", "Niederkassel",
"492237", "Kerpen\ Rheinland\-Türnich",
"496827", "Eppelborn",
"494336", "Owschlag",
"492605", "Löf",
"494292", "Ritterhude",
"495975", "Rheine\-Mesum",
"496198", "Eppstein",
"4937756", "Breitenbrunn\ Erzgebirge",
"494177", "Drage\ Elbe",
"498222", "Burgau\ Schwaben",
"494332", "Hamdorf\ bei\ Rendsburg",
"4939976", "Gross\ Bützin",
"495459", "Hörstel",
"4934325", "Mochau\-Lüttewitz",
"494634", "Husby",
"493328", "Teltow",
"4939293", "Dreileben",
"495441", "Diepholz",
"498405", "Stammham\ bei\ Ingolstadt",
"495552", "Katlenburg",
"497525", "Aulendorf",
"496725", "Gau\-Algesheim",
"494833", "Wesselburen",
"4933877", "Nitzahn",
"495556", "Lindau\ Harz",
"499920", "Bischofsmais",
"494928", "Ihlow\-Riepe",
"499921", "Regen",
"495056", "Winsen\-Meissendorf",
"496105", "Mörfelden\-Walldorf",
"4935263", "Gröditz\ bei\ Riesa",
"496403", "Linden\ Hessen",
"493904", "Haldensleben",
"494864", "Oldenswort",
"496569", "Bickendorf",
"494606", "Wanderup",
"4934602", "Landsberg\ Sachsen\-Anhalt",
"4939365", "Bellingen\ bei\ Stendal",
"496851", "St\ Wendel",
"496274", "Waldbrunn\ Odenwald",
"4938828", "Schönberg",
"4938303", "Sellin\ Ostseebad",
"492335", "Wetter\ Ruhr",
"495173", "Uetze",
"4938297", "Moitin",
"495052", "Hermannsburg",
"495475", "Bohmte\-Hunteburg",
"497025", "Neuffen",
"493772", "Schneeberg\ Erzgebirge",
"494602", "Freienwill",
"4939325", "Vinzelberg",
"492295", "Ruppichteroth",
"498723", "Arnstorf",
"494793", "Hambergen",
"4934976", "Gröbzig",
"4934467", "Eckartsberga",
"495273", "Beverungen",
"496174", "Königstein\ im\ Taunus",
"497729", "Tennenbronn",
"499852", "Feuchtwangen",
"495936", "Twist",
"4937366", "Rübenau",
"496047", "Altenstadt\ Hessen",
"4934241", "Jesewitz",
"492195", "Radevormwald",
"4933433", "Buckow\ Märkische\ Schweiz",
"496637", "Feldatal",
"495404", "Westerkappeln",
"495932", "Haren\ Ems",
"499856", "Dürrwangen",
"4937326", "Frauenstein\ Sachsen",
"496205", "Hockenheim",
"4934202", "Delitzsch",
"4939859", "Fürstenwerder",
"494824", "Krempe",
"496029", "Mömbris",
"494881", "Friedrichstadt",
"4935934", "Grossdubrau",
"497747", "Berau",
"496765", "Gemünden\ Hunsrück",
"499348", "Werbach\-Gamburg",
"494340", "Achterwehr",
"499961", "Mitterfels",
"494968", "Neulehe",
"4936071", "Teistungen",
"493941", "Halberstadt",
"498734", "Reisbach\ Niederbayern",
"4936692", "Bürgel",
"497565", "Aichstetten\ Kreis\ Ravensburg",
"498203", "Grossaitingen",
"492873", "Isselburg\-Werth",
"498262", "Mittelneufnach",
"495436", "Nortrup",
"498122", "Erding",
"494277", "Schwaförden",
"496298", "Möckmühl",
"494192", "Bad\ Bramstedt",
"493475", "Lutherstadt\ Eisleben",
"495772", "Espelkamp",
"4939726", "Ducherow",
"492993", "Marsberg\-Canstein",
"496338", "Hornbach\ Pfalz",
"4939241", "Leitzkau",
"496307", "Schopp",
"4939427", "Ströbeck",
"497385", "Gomadingen",
"492372", "Hemer",
"495904", "Lengerich\ Emsl",
"495432", "Löningen",
"498266", "Kirchheim\ in\ Schwaben",
"4936203", "Vieselbach",
"492674", "Bad\ Bertrich",
"494501", "Kastorf\ Holstein",
"493735", "Marienberg\ Sachsen",
"493588", "Niesky",
"496867", "Perl",
"492137", "Neuss\-Norf",
"495776", "Preussisch\ Ströhen",
"4939202", "Gross\ Ammensleben",
"496695", "Jesberg",
"4938850", "Gammelin",
"4938423", "Bad\ Kleinen",
"498706", "Vilsheim",
"499647", "Kirchenthumbach",
"499353", "Karlstadt",
"497254", "Waghäusel",
"4938392", "Sassnitz",
"4939405", "Hötensleben",
"4936843", "Benshausen",
"494468", "Friedeburg\-Reepsholt",
"495650", "Cornberg",
"496422", "Kirchhain",
"499461", "Roding",
"495651", "Eschwege",
"494623", "Böklund",
"498702", "Wörth\ an\ der\ Isar",
"493441", "Zeitz",
"495328", "Altenau\ Harz",
"4935796", "Panschwitz\-Kuckau",
"4938375", "Koserow",
"496426", "Fronhausen",
"4935033", "Rosenthal\ Sächsische\ Schweiz",
"496599", "Weidenbach\ bei\ Gerolstein",
"4938452", "Lalendorf",
"498824", "Oberau\ Loisach",
"498375", "Weitnau",
"493727", "Mittweida",
"499525", "Königsberg\ in\ Bayern",
"494763", "Gnarrenburg",
"492423", "Langerwehe",
"492265", "Reichshof\-Eckenhagen",
"4935938", "Grosspostwitz\ OL",
"497457", "Rottenburg\-Ergenzingen",
"499209", "Emtmannsberg",
"4935773", "Schleife",
"494203", "Weyhe\ bei\ Bremen",
"499187", "Altdorf\ bei\ Nürnberg",
"4938226", "Dierhagen\ Ostseebad",
"492587", "Ennigerloh\-Westkirchen",
"494734", "Stadland\-Seefeld",
"495865", "Gusborn",
"496373", "Schönenberg\-Kübelberg",
"4933745", "Petkus",
"498341", "Kaufbeuren",
"494474", "Garrel",
"497839", "Schapbach",
"4937603", "Wildenfels",
"498340", "Baisweil",
"495305", "Sickte",
"499154", "Pommelsbrunn",
"496872", "Losheim\ am\ See",
"492554", "Laer\ Kreis\ Steinfurt",
"498501", "Thyrnau",
"496625", "Niederaula",
"497420", "Deisslingen",
"495071", "Schwarmstedt",
"4933209", "Caputh",
"494266", "Brockel",
"494126", "Horst\ Holstein",
"498196", "Pürgen",
"492367", "Henrichenburg",
"495545", "Hedemünden",
"4936731", "Unterloquitz",
"492923", "Lippetal\-Herzfeld",
"496876", "Weiskirchen\ Saar",
"495767", "Warmsen",
"497957", "Kressberg",
"498192", "Schondorf\ am\ Ammersee",
"4937292", "Oederan",
"492838", "Sonsbeck",
"496228", "Schönau\ Odenwald",
"494262", "Visselhövede",
"494122", "Uetersen",
"497669", "St\ Märgen",
"495238", "Nieheim\-Himmighausen",
"495207", "Schloss\ Holte\-Stukenbrock",
"493672", "Rudolstadt",
"494702", "Sandstedt",
"498623", "Kirchweidach",
"494974", "Neuharlingersiel",
"498468", "Altmannstein\-Pondorf",
"4933849", "Wiesenburg\ Mark",
"495045", "Springe\-Bennigsen",
"494706", "Schiffdorf",
"495635", "Vöhl",
"497484", "Simmersfeld",
"495571", "Uslar",
"492054", "Essen\-Kettwig",
"495222", "Bad\ Salzuflen",
"497321", "Heidenheim\ an\ der\ Brenz",
"495162", "Fallingbostel",
"497255", "Graben\-Neudorf",
"494289", "Kirchtimke",
"4935728", "Uhyst\ Spree",
"4939390", "Iden",
"493763", "Glauchau",
"498459", "Manching",
"4939852", "Schönermark\ bei\ Prenzlau",
"492641", "Bad\ Neuenahr\-Ahrweiler",
"495226", "Bruchmühlen\ Westfalen",
"495166", "Walsrode\-Kirchboitzen",
"496159", "Messel",
"498808", "Pähl",
"496396", "Hinterweidenthal",
"494749", "Schiffdorf\-Geestenseth",
"496236", "Neuhofen\ Pfalz",
"492826", "Kranenburg\ Niederrhein",
"496392", "Hauenstein\ Pfalz",
"497844", "Rheinau",
"4939745", "Hetzdorf\ bei\ Strasburg",
"498368", "Halblech",
"496694", "Neukirchen\ Knüll",
"497384", "Schelklingen\-Hütten",
"499283", "Rehau",
"494138", "Betzendorf\ Kreis\ Lüneburg",
"494107", "Siek\ Kreis\ Stormarn",
"499131", "Erlangen",
"492822", "Emmerich",
"496232", "Speyer",
"4935876", "Weissenberg\ Sachsen",
"497682", "Elzach",
"495905", "Beesten",
"492675", "Ediger\-Eller",
"498052", "Aschau\ im\ Chiemgau",
"4936961", "Bad\ Liebenstein",
"4939209", "Wanzleben",
"499246", "Pegnitz\-Trockau",
"4933874", "Stechow\ Brandenburg",
"495723", "Bad\ Nenndorf",
"496764", "Rheinböllen",
"497564", "Bad\ Wurzach",
"4936921", "Wutha\-Farnroda",
"497033", "Weil\ Der\ Stadt",
"494751", "Otterndorf",
"4933676", "Friedland\ bei\ Beeskow",
"492323", "Herne",
"498056", "Eggstätt",
"499094", "Tagmersheim",
"497357", "Attenweiler",
"497643", "Herbolzheim\ Breisgau",
"499242", "Gössweinstein",
"496893", "Saarbrücken\-Ensheim",
"498735", "Gangkofen\-Kollbach",
"4938294", "Neubukow",
"496473", "Leun",
"497533", "Allensbach",
"496175", "Friedrichsdorf\ Taunus",
"498556", "Haidmühle",
"494825", "Burg\ Dithmarschen",
"498441", "Pfaffenhofen\ an\ der\ Ilm",
"493693", "Meiningen",
"498667", "Seeon\-Seebruck",
"494672", "Langenhorn",
"4934745", "Winningen\ Sachsen\-Anhalt",
"496733", "Gau\-Odernheim",
"498552", "Grafenau\ Niederbayern",
"495405", "Hasbergen\ Kreis\ Osnabrück",
"496204", "Viernheim",
"495103", "Wennigsen\ Deister",
"493375", "Königs\ Wusterhausen",
"49971", "Bad\ Kissingen",
"495336", "Semmenstedt",
"496407", "Rabenau\ Hessen",
"497578", "Wald\ Hohenz",
"496438", "Hünfelden",
"492732", "Kreuztal",
"495332", "Schöppenstedt",
"497231", "Pforzheim",
"4938459", "Laage",
"497183", "Rudersberg\ Württemberg",
"497485", "Empfingen",
"4934909", "Aken\ Elbe",
"495634", "Waldeck\-Sachsenhausen",
"496681", "Hilders",
"498727", "Falkenberg\ Niederbayern",
"492472", "Monschau",
"497391", "Ehingen\ Donau",
"495292", "Lichtenau\-Atteln",
"494975", "Westerholt\ Ostfriesland",
"4935601", "Peitz",
"495044", "Springe\-Eldagsen",
"495177", "Edemissen\-Abbensen",
"492736", "Burbach\ Siegerl",
"4935027", "Weesenstein",
"495544", "Reinhardshagen",
"498138", "Schwabhausen\ bei\ Dachau",
"4938736", "Goldberg",
"499360", "Thüngen",
"494941", "Aurich",
"499155", "Simmelsdorf",
"499948", "Eschlkam",
"496322", "Bad\ Dürkheim",
"496624", "Heringen\ Werra",
"492555", "Schöppingen",
"499453", "Thalmassing",
"495663", "Spangenberg",
"493968", "Schönbeck",
"493341", "Strausberg",
"495428", "Melle\-Neuenkirchen",
"4933837", "Brielow",
"494837", "Neuenkirchen\ Dithmarschen",
"493881", "Grevesmühlen",
"4935724", "Lohsa",
"4939951", "Faulenrost",
"496326", "Deidesheim",
"494735", "Butjadingen\-Stollhamm",
"493501", "Pirna",
"492181", "Grevenbroich",
"492233", "Hürth\ Rheinland",
"495864", "Jameln",
"495606", "Zierenberg",
"49761", "Freiburg\ im\ Breisgau",
"498751", "Mainburg",
"492393", "Sundern\-Allendorf",
"4938751", "Picher",
"492972", "Schmallenberg",
"495602", "Hessisch\ Lichtenau",
"494959", "Dollart",
"495304", "Meine",
"4938827", "Kalkhorst",
"4935893", "Mücka",
"494173", "Wulfsen",
"4933202", "Töplitz",
"494475", "Molbergen",
"4933766", "Teupitz",
"497146", "Remseck\ am\ Neckar",
"494552", "Leezen",
"499179", "Freystadt",
"499953", "Pilsting",
"4939823", "Rechlin",
"493623", "Friedrichroda",
"494667", "Dagebüll",
"4939081", "Kakerbeck\ Sachsen\-Anhalt",
"499448", "Hausen\ Niederbayern",
"498374", "Dietmannsried",
"494441", "Vechta",
"498825", "Krün",
"494556", "Ahrensbök\-Gnissau",
"4933878", "Nennhausen",
"497142", "Bietigheim\-Bissingen",
"499080", "Harburg\ Schwaben",
"499524", "Zeil\ am\ Main",
"499081", "Nördlingen",
"495833", "Brome",
"492264", "Marienheide",
"4939863", "Seehausen\ bei\ Prenzlau",
"497242", "Rheinstetten",
"4933331", "Casekow",
"495341", "Salzgitter",
"499643", "Auerbach\ in\ der\ Oberpfalz",
"499357", "Gräfendorf\ Bayern",
"496834", "Bous",
"494539", "Westerau",
"492224", "Bad\ Honnef",
"492164", "Jüchen\-Otzenrath",
"499564", "Bad\ Rodach",
"496082", "Niederreifenberg",
"496558", "Büdesheim\ Eifel",
"499279", "Mistelgau",
"4935383", "Elster\ Elbe",
"493544", "Luckau\ Brandenburg",
"497246", "Malsch\ Kreis\ Karlsruhe",
"496086", "Grävenwiesbach",
"492741", "Betzdorf",
"4936704", "Steinheid",
"494627", "Dörpstedt",
"493663", "Schleiz",
"496586", "Beuren\ Hochwald",
"496303", "Enkenbach\-Alsenborn",
"4936483", "Ziegenrück",
"493332", "Schwedt\/Oder",
"493634", "Sömmerda",
"496058", "Gründau",
"4939482", "Gatersleben",
"492775", "Driedorf",
"4933602", "Alt\ Zeschdorf",
"494273", "Kirchdorf\ bei\ Sulingen",
"4936454", "Magdala",
"494936", "Grossheide",
"495375", "Müden\ Aller",
"495824", "Bad\ Bodenteich",
"492133", "Dormagen",
"496582", "Freudenburg",
"492435", "Erkelenz\-Lövenich",
"499533", "Untermerzbach",
"494404", "Elsfleth",
"4933976", "Wutike",
"494932", "Norderney",
"4936025", "Körner",
"4936621", "Elsterberg\ bei\ Plauen",
"498045", "Lenggries\-Fall",
"499658", "Georgenberg",
"495468", "Bramsche\-Engter",
"493928", "Schönebeck\ Elbe",
"498571", "Simbach\ am\ Inn",
"498635", "Pleiskirchen",
"496802", "Völklingen\-Lauterbach",
"4935974", "Hinterhermsdorf",
"497743", "Ühlingen\-Birkendorf",
"4935841", "Grossschönau\ Sachsen",
"498238", "Gessertshausen",
"498207", "Affing",
"496543", "Büchenbeuren",
"495623", "Edertal",
"496806", "Heusweiler",
"496664", "Sinntal\-Sterbfritz",
"496362", "Alsenz",
"499321", "Kitzingen",
"494328", "Rickling",
"499255", "Marktleugast",
"494772", "Oberndorf\ Oste",
"499682", "Erbendorf",
"496633", "Homberg\ Ohm",
"4933473", "Zechin",
"492759", "Bad\ Berleburg\-Aue",
"497130", "Löwenstein\ Württemberg",
"499384", "Schwanfeld",
"493304", "Velten",
"497131", "Heilbronn\ Neckar",
"495277", "Höxter\-Fürstenau",
"4938873", "Carlow",
"4935201", "Langebrück",
"496043", "Nidda",
"4933365", "Lüdersdorf\ Kreis\ Barnim",
"495192", "Munster",
"4938321", "Martensdorf\ bei\ Stralsund",
"499844", "Obernzenn",
"498071", "Wasserburg\ am\ Inn",
"492935", "Sundern\-Hachen",
"493606", "Heiligenstadt\ Heilbad",
"494776", "Osten\-Altendorf",
"4935242", "Nossen",
"498545", "Hofkirchen\ Bayern",
"4939428", "Pabstorf",
"495196", "Wietzendorf",
"494432", "Dötlingen\-Brettorf",
"4933094", "Löwenberg",
"496678", "Wildeck\-Hönebach",
"495734", "Bergkirchen\ Westfalen",
"4939346", "Tucheim",
"496781", "Idar\-Oberstein",
"4934424", "Reuden\ bei\ Zeitz",
"494865", "Osterhever",
"495203", "Werther\ Westfalen",
"492636", "Burgbrohl",
"496104", "Heusenstamm",
"4937432", "Pausa\ Vogtland",
"4934464", "Freyburg\ Unstrut",
"492294", "Morsbach\ Sieg",
"4936458", "Bad\ Berka",
"4934651", "Rossla",
"494305", "Westensee",
"49961", "Weiden\ in\ der\ Oberpfalz",
"496275", "Rothenberg\ Odenwald",
"492334", "Hagen\-Hohenlimburg",
"495474", "Stemwede\-Dielingen",
"492632", "Andernach",
"497024", "Wendlingen\ am\ Neckar",
"497581", "Saulgau",
"492363", "Datteln",
"492451", "Geilenkirchen",
"498404", "Oberdolling",
"498649", "Schleching",
"497081", "Bad\ Wildbad",
"497524", "Bad\ Waldsee",
"496241", "Worms",
"499142", "Treuchtlingen",
"498039", "Rott\ am\ Inn",
"492542", "Gescher",
"492803", "Wesel\-Büderich",
"497448", "Seewald",
"4935937", "Prischwitz",
"498273", "Nordendorf",
"497953", "Blaufelden",
"492927", "Neuengeseke",
"496724", "Stromberg\ Hunsrück",
"492546", "Coesfeld\-Lette",
"495763", "Uchte",
"499146", "Markt\ Berolzheim",
"498328", "Balderschwang",
"495693", "Volkmarsen",
"4939424", "Schwanebeck\ Sachsen\-Anhalt",
"49651", "Trier",
"499391", "Marktheidenfeld",
"495702", "Petershagen\-Lahde",
"4934346", "Narsdorf",
"492583", "Sassenberg",
"492306", "Lünen",
"496132", "Ingelheim\ am\ Rhein",
"499231", "Marktredwitz",
"492862", "Südlohn",
"494238", "Neddenaverbergen",
"494207", "Oyten",
"499183", "Burgthann",
"495706", "Porta\ Westfalica",
"4939055", "Hörsingen",
"494635", "Sörup",
"492866", "Dorsten\-Rhade",
"498651", "Bad\ Reichenhall",
"492449", "Blankenheim\ Ahr",
"496136", "Nieder\-Olm",
"492604", "Nassau\ Lahn",
"498650", "Marktschellenberg",
"492302", "Witten",
"4969", "Frankfurt\ am\ Main",
"49771", "Donaueschingen",
"493998", "Demmin",
"498432", "Burgheim",
"495266", "Lemgo\-Kirchheide",
"492951", "Büren",
"495126", "Algermissen",
"494545", "Seedorf\ Lauenburg",
"499078", "Mertingen",
"497453", "Altensteig\ Württemberg",
"494189", "Undeloh",
"497948", "Öhringen\-Ohrnberg",
"497361", "Aalen",
"4938785", "Berge\ bei\ Perleberg",
"495262", "Extertal",
"4934609", "Salzmünde",
"4934636", "Schafstädt",
"493723", "Hohenstein\-Ernstthal",
"498772", "Mallersdorf\-Pfaffenberg",
"494767", "Bremervörde\-Bevern",
"492427", "Nideggen",
"4938871", "Mühlen\ Eichsen",
"492574", "Saerbeck",
"4935203", "Tharandt",
"495051", "Bergen\ Kreis\ Celle",
"499174", "Hilpoltstein",
"496852", "Nohfelden",
"4938323", "Prohn",
"496595", "Dockweiler",
"493771", "Aue\ Sachsen",
"498379", "Waltenhofen\-Oberdorf",
"499608", "Kohlberg\ Oberpfalz",
"499637", "Falkenberg\ Oberpfalz",
"493431", "Döbeln",
"496856", "St\ Wendel\-Niederkirchen",
"494487", "Grossenkneten\-Huntlosen",
"499205", "Vorbach",
"4933875", "Rhinow",
"499529", "Oberaurach",
"498093", "Glonn\ Kreis\ Ebersberg",
"498257", "Inchenhofen",
"497977", "Oberrot\ bei\ Gaildorf",
"492129", "Haan\ Rheinland",
"492269", "Kierspe\-Rönsahl",
"4939032", "Mahlsdorf\ bei\ Salzwedel",
"498593", "Untergriesbach",
"496888", "Lebach\-Steinbach",
"495446", "Rehden",
"494523", "Malente",
"499765", "Trappstadt",
"496348", "Offenbach\ an\ der\ Queich",
"499922", "Zwiesel",
"495442", "Barnstorf\ Kreis\ Diepholz",
"496095", "Bessenbach",
"4937344", "Crottendorf\ Sachsen",
"495309", "Lehre\-Wendhausen",
"4939327", "Klietz",
"494954", "Moormerland",
"4935843", "Hirschfelde\ bei\ Zittau",
"495551", "Northeim",
"4938295", "Satow\ bei\ Bad\ Doberan",
"499926", "Frauenau",
"493745", "Falkenstein\ Vogtland",
"497835", "Zell\ am\ Harmersbach",
"499547", "Zapfendorf",
"498221", "Günzburg",
"498161", "Freising",
"493847", "Sternberg",
"497708", "Geisingen\-Leipferdingen",
"4936481", "Neustadt\ an\ der\ Orla",
"499307", "Altertheim",
"499338", "Röttingen\ Unterfranken",
"494330", "Emkendorf",
"496629", "Schenklengsfeld",
"494331", "Rendsburg",
"495185", "Duingen",
"498744", "Gerzen",
"4936623", "Berga\ Elster",
"493931", "Stendal",
"495483", "Lienen",
"495027", "Linsburg",
"496508", "Hetzerath\ Mosel",
"497477", "Jungingen\ bei\ Hechingen",
"499867", "Geslau",
"4933970", "Neustadt\ Dosse",
"495527", "Duderstadt",
"495946", "Georgsdorf",
"496008", "Echzell",
"496647", "Herbstein\-Stockhausen",
"496353", "Freinsheim",
"4933333", "Tantow",
"497665", "March\ Breisgau",
"4935692", "Kerkwitz",
"496461", "Biedenkopf",
"4939744", "Rothenklempenow",
"499422", "Bogen\ Niederbayern",
"494454", "Jade",
"4934327", "Waldheim\ Sachsen",
"497268", "Bad\ Rappenau\-Obergimpern",
"497128", "Sonnenbühl",
"495942", "Uelsen",
"498284", "Ziemetshausen",
"499426", "Oberschneiding",
"495248", "Langenberg\ Kreis\ Gütersloh",
"497962", "Fichtenau",
"498023", "Bayrischzell",
"494257", "Schweringen",
"4934772", "Helbra",
"495752", "Auetal\-Hattendorf",
"4937348", "Oberwiesenthal\ Kurort",
"497725", "Königsfeld\ im\ Schwarzwald",
"495035", "Gross\ Munzel",
"496525", "Irrel",
"492654", "Polch",
"497966", "Unterschneidheim",
"492352", "Altena\ Westfalen",
"495645", "Borgentreich\-Borgholz",
"496209", "Mörlenbach",
"496187", "Schöneck",
"4935829", "Gersdorf\ bei\ Görlitz",
"4939886", "Milmersdorf",
"495535", "Polle",
"495671", "Hofgeismar",
"497851", "Kehl",
"49385", "Schwerin",
"497274", "Germersheim",
"499373", "Amorbach",
"493576", "Weisswasser",
"492388", "Hamm\-Uentrop",
"4936652", "Wurzbach",
"497569", "Isny\-Eisenbach",
"497403", "Dunningen",
"499099", "Kaisheim",
"495253", "Bad\ Driburg",
"496154", "Ober\-Ramstadt",
"499872", "Heilsbronn",
"4939772", "Rothemühl",
"497462", "Immendingen",
"4935439", "Zinnitz",
"499625", "Kastl\ bei\ Amberg",
"494744", "Loxstedt",
"4936649", "Gefell\ bei\ Schleiz",
"498331", "Memmingen",
"497466", "Beuron",
"498330", "Legau",
"4939748", "Viereck",
"499876", "Rohr\ Mittelfranken",
"498291", "Zusmarshausen",
"492568", "Heek",
"497389", "Heroldstatt",
"499228", "Thurnau",
"494355", "Rieseby",
"494221", "Delmenhorst",
"494161", "Buxtehude",
"4935725", "Wittichenau",
"4938352", "Kemnitz\ bei\ Greifswald",
"494284", "Selsingen",
"492401", "Baesweiler",
"498454", "Karlshuld",
"492687", "Horhausen\ Westerwald",
"4935756", "Hosena",
"499492", "Parsberg",
"492853", "Schermbeck",
"4934653", "Rottleberode",
"497903", "Mainhardt",
"495572", "Bodenfelde",
"496385", "Reichenbach\-Steegen",
"494184", "Hanstedt\ Nordheide",
"4935975", "Hohnstein",
"497307", "Senden\ Iller",
"4938788", "Gross\ Warnow",
"493671", "Saalfeld\ Saale",
"499708", "Bad\ Bocklet",
"499737", "Wartmannsroth",
"493535", "Herzberg\ Elster",
"49481", "Heide\ Holstein",
"498383", "Grünenbach\ Allgäu",
"498506", "Bad\ Höhenstadt",
"497426", "Gosheim",
"494261", "Rotenburg\ Wümme",
"494121", "Elmshorn",
"494120", "Ellerhoop",
"494260", "Visselhövede\-Wittorf",
"499128", "Feucht",
"499268", "Teuschnitz",
"4933732", "Hennickendorf\ bei\ Luckenwalde",
"492528", "Ennigerloh\-Enniger",
"498191", "Landsberg\ am\ Lech",
"4936963", "Dorndorf\ Rhön",
"498502", "Fürstenzell",
"4933364", "Gross\ Ziethen\ Kreis\ Barnim",
"495072", "Neustadt\-Mandelsloh",
"4939058", "Uthmöden",
"499665", "Königstein\ Oberpfalz",
"495455", "Tecklenburg\-Brochterbeck",
"497422", "Schramberg",
"4939922", "Dambeck\ bei\ Röbel",
"496871", "Wadern",
"496254", "Lautertal\ Odenwald",
"495153", "Salzhemmendorf",
"4936923", "Treffurt",
"492444", "Schleiden\-Gemünd",
"4936705", "Oberweissbach\ Thüringer\ Wald",
"4938722", "Raduhn",
"499977", "Arnschwang",
"498342", "Marktoberdorf",
"497529", "Waldburg\ Württemberg",
"4936252", "Tambach\-Dietharz",
"4938334", "Grammendorf",
"498563", "Bad\ Birnbach\ Rottal",
"498034", "Brannenburg",
"4935326", "Schönborn\ Kreis\ Elbe\-Elster",
"496287", "Limbach\ Baden",
"498346", "Pforzen",
"4938206", "Graal\-Müritz\ Seeheilbad",
"497174", "Mögglingen",
"4939389", "Schollene",
"4939396", "Neukirchen\ Altmark",
"499835", "Ehingen\ Mittelfranken",
"4936426", "Ottendorf\ bei\ Stadtroda",
"496565", "Dudeldorf",
"4936024", "Diedorf\ bei\ Mühlhausen",
"496109", "Frankfurt\-Bergen\-Enkheim",
"498858", "Kochel\-Walchensee",
"498063", "Feldkirchen\-Westerham",
"4934922", "Mühlanger",
"495148", "Steinhorst\ Niedersachsen",
"495955", "Esterwegen",
"498534", "Tettenweis",
"497765", "Rickenbach\ Hotzenwald",
"492339", "Sprockhövel\-Hasslinghausen",
"492944", "Rietberg\-Mastholte",
"496747", "Emmelshausen",
"4933747", "Marzahna",
"497228", "Forbach",
"4939821", "Carpin",
"4939083", "Messdorf",
"492754", "Bad\ Laasphe\-Feudingen",
"4939054", "Flechtingen",
"4933368", "Hohensaaten",
"495745", "Stemwede\-Levern",
"4939456", "Altenbrak",
"4936082", "Ershausen",
"4936372", "Kleinneuhausen",
"499466", "Stamsried",
"495656", "Waldkappel",
"4934953", "Gräfenhainichen",
"4939861", "Gramzow\ bei\ Prenzlau",
"493869", "Dümmer",
"499462", "Falkenstein\ Oberpfalz",
"495652", "Bad\ Sooden\-Allendorf",
"496421", "Marburg",
"496420", "Lahntal",
"497625", "Zell\ im\ Wiesental",
"495354", "Jerxheim",
"4939425", "Dingelstedt\ am\ Huy",
"4936949", "Obermassfeld\-Grimmenthal",
"496484", "Beselich",
"495431", "Quakenbrück",
"499903", "Schöllnach",
"4939407", "Seehausen\ Börde",
"492371", "Iserlohn",
"4933929", "Gühlen\-Glienicke",
"495285", "Bad\ Pyrmont\-Kleinenberg",
"4938753", "Wöbbelin",
"499827", "Lichtenau\ Mittelfranken",
"4939222", "Möser",
"4938784", "Kleinow\ Kreis\ Prignitz",
"494502", "Lübeck\-Travemünde",
"495067", "Bockenem",
"4933969", "Stepenitz",
"494843", "Viöl",
"494191", "Kaltenkirchen\ Holstein",
"4935891", "Rothenburg\ OL",
"499198", "Heiligenstadt\ in\ Oberfranken",
"492598", "Senden\-Ottmarsbocholt",
"4938377", "Zinnowitz",
"498261", "Mindelheim",
"498121", "Markt\ Schwaben",
"496669", "Neuhof\-Hauswurz",
"494383", "Grebin",
"494506", "Stockelsdorf\-Krumbeck",
"4933760", "Münchehofe\ Kreis\ Dahme\-Spreewald",
"4935472", "Schlepzig",
"4939262", "Güsten\ Anh",
"49881", "Weilheim\ in\ Oberbayern",
"495771", "Rahden\ Westfalen",
"496457", "Burgwald\ Eder",
"494346", "Gettorf",
"499966", "Wiesenfelden",
"4934465", "Bad\ Bibra",
"492247", "Neunkirchen\-Seelscheid",
"493946", "Quedlinburg",
"499725", "Poppenhausen\ Unterfranken",
"495829", "Wriedel",
"494563", "Scharbeutz\-Haffkrug",
"4939953", "Schwinkendorf",
"494882", "Lunden",
"4934425", "Droyssig",
"494409", "Westerstede\-Ocholt",
"494644", "Karby",
"494342", "Preetz\ Kreis\ Plön",
"4936028", "Kammerforst\ Thüringen",
"499962", "Schwarzach\ Niederbayern",
"499105", "Grosshabersdorf",
"495931", "Meppen",
"499403", "Donaustauf",
"492505", "Altenberge\ Westfalen",
"494534", "Steinburg\ Kreis\ Storman",
"498157", "Feldafing",
"4934222", "Arzberg\ bei\ Torgau",
"499569", "Sesslach",
"499851", "Dinkelsbühl",
"494858", "Sankt\ Margarethen\ Holstein",
"497373", "Zwiefalten",
"499274", "Hollfeld",
"4935603", "Burg\ Spreewald",
"4934262", "Falkenhain\ bei\ Wurzen",
"497141", "Ludwigsburg\ Württemberg",
"4936841", "Schleusingen",
"4938856", "Pritzier\ bei\ Hagenow",
"493909", "Klötze\ Altmark",
"496643", "Herbstein",
"496357", "Standenbühl",
"4933083", "Schulzendorf\ Kreis\ Oberhavel",
"499834", "Theilenhofen",
"4934382", "Nerchau",
"4933054", "Liebenwalde",
"499082", "Oettingen\ in\ Bayern",
"496564", "Neuerburg\ Eifel",
"494446", "Bakum\ Kreis\ Vechta",
"495523", "Bad\ Sachsa",
"496033", "Butzbach",
"4933456", "Wriezen",
"494550", "Bühnsdorf",
"497764", "Herrischried",
"494551", "Bad\ Segeberg",
"492945", "Lippstadt\-Benninghausen",
"4938825", "Klütz",
"492158", "Grefrath\ bei\ Krefeld",
"499086", "Fremdingen",
"494442", "Lohne\ Oldenburg",
"498671", "Altötting",
"495954", "Lorup",
"498670", "Reischach\ Kreis\ Altötting",
"498535", "Haarbach",
"4938461", "Bützow",
"4934691", "Könnern",
"4939328", "Rochau",
"499303", "Eibelstadt",
"497204", "Malsch\-Völkersbach",
"4939243", "Nedlitz\ bei\ Zerbst",
"495601", "Schauenburg",
"4939929", "Jabel\ bei\ Waren",
"492971", "Schmallenberg\-Dorlar",
"498035", "Raubling",
"493843", "Güstrow",
"497733", "Engen\ Hegau",
"498756", "Nandlstadt",
"497175", "Leinzell",
"492182", "Grevenbroich\-Kapellen",
"495023", "Liebenau\ Kreis\ Nieburg\ Weser",
"498248", "Lamerdingen",
"497473", "Mössingen",
"496533", "Morbach\ Hunsrück",
"498752", "Au\ in\ der\ Hallertau",
"4936201", "Walschleben",
"493644", "Apolda",
"4938232", "Zingst\ Ostseebad",
"496658", "Poppenhausen\ Wasserkuppe",
"493342", "Neuenhagen\ bei\ Berlin",
"493563", "Spremberg",
"499366", "Geroldshausen\ Unterfranken",
"494527", "Bosau",
"494946", "Grossefehn\-Bagband",
"499802", "Ansbach\-Katterbach",
"4939382", "Kamern",
"4936259", "Tabarz\ Thüringer\ Wald",
"499543", "Hirschaid",
"492445", "Schleiden\ Eifel",
"493346", "Seelow",
"4938729", "Marnitz",
"499664", "Hahnbach",
"495454", "Hörstel\-Riesenbeck",
"493886", "Gadebusch",
"4934328", "Hartha\ bei\ Döbeln",
"4933984", "Blumenthal\ bei\ Pritzwalk",
"496321", "Neustadt\ an\ der\ Weinstrasse",
"494639", "Schafflund",
"496255", "Lindenfels",
"494942", "Südbrookmerland",
"492471", "Roetgen\ Eifel",
"4934929", "Straach",
"496682", "Tann\ Rhön",
"499633", "Mitterteich",
"4934243", "Bad\ Düben",
"4937360", "Olbernhau",
"496384", "Konken",
"497232", "Königsbach\-Stein",
"495331", "Wolfenbüttel",
"497392", "Laupheim",
"4935025", "Liebstadt",
"496844", "Blieskastel\-Altheim",
"497973", "Obersontheim",
"497236", "Keltern",
"4937320", "Mulda\ Sachsen",
"498253", "Pöttmes",
"4935454", "Uckro",
"494185", "Marxen\ Auetal",
"4933835", "Golzow\ bei\ Brandenburg",
"4935056", "Altenberg\ Sachsen",
"497159", "Renningen",
"494483", "Ovelgönne\-Grossenmeer",
"494535", "Nahe",
"494671", "Bredstedt",
"498442", "Wolnzach",
"499104", "Emskirchen",
"492504", "Telgte",
"498551", "Freyung",
"498550", "Philippsreut",
"498869", "Kinsau",
"497938", "Mulfingen\ Jagst",
"497907", "Schwäbisch\ Hall\-Sulzdorf",
"498446", "Pörnbach",
"495593", "Bovenden\-Lenglern",
"49661", "Fulda",
"492857", "Rees\-Mehr",
"4936379", "Holzengel",
"499275", "Speichersdorf",
"497823", "Seelbach\ Schutter",
"492683", "Asbach\ Westerwald",
"492779", "Greifenstein\-Beilstein",
"4934446", "Grosskorbetha",
"494752", "Neuhaus\ Oste",
"4933962", "Heiligengrabe",
"4939324", "Kläden\ bei\ Stendal",
"4936733", "Kaulsdorf",
"4937347", "Bärenstein\ Kreis\ Annaberg",
"496142", "Rüsselsheim",
"499241", "Pegnitz",
"494248", "Bassum\-Neubruchhausen",
"4933230", "Börnicke\ Kreis\ Havelland",
"495257", "Hövelhof",
"494756", "Odisheim",
"4933922", "Karwesee",
"4939364", "Dolle",
"498051", "Prien\ am\ Chiemsee",
"495379", "Sassenburg\-Grussendorf",
"49381", "Rostock",
"499724", "Stadtlauringen",
"496146", "Hochheim\ am\ Main",
"498639", "Neumarkt\-Sankt\ Veit",
"49951", "Bamberg",
"499377", "Freudenberg\-Boxtal",
"49211", "Düsseldorf",
"496391", "Dahn",
"4938220", "Wustrow\ Ostseebad",
"496485", "Nentershausen\ Westerwald",
"497681", "Waldkirch\ Breisgau",
"492532", "Ostbevern",
"496231", "Hochdorf\-Assenheim",
"492821", "Kleve\ Niederrhein",
"499132", "Herzogenaurach",
"496183", "Erlensee",
"495284", "Schwalenberg",
"496578", "Salmtal",
"4937601", "Mülsen\ Skt\ Jacob",
"492536", "Münster\-Albachten",
"4934324", "Ostrau\ Sachsen",
"4933396", "Klosterfelde",
"497326", "Neresheim",
"495744", "Hüllhorst",
"494253", "Asendorf\ Kreis\ Diepholz",
"496078", "Gross\-Umstadt",
"492755", "Bad\ Berleburg\-Schwarzenau",
"498027", "Dietramszell",
"492646", "Königsfeld\ Eifel",
"498549", "Vilshofen\-Pleinting",
"497624", "Grenzach\-Wyhlen",
"495355", "Frellstedt",
"4934364", "Wermsdorf",
"4935771", "Bad\ Muskau",
"495221", "Herford",
"497322", "Giengen\ an\ der\ Brenz",
"495161", "Walsrode",
"492642", "Remagen",
"4939747", "Züsedom",
"495121", "Hildesheim",
"497362", "Bopfingen",
"495261", "Lemgo",
"4936782", "Schmiedefeld\ am\ Rennsteig",
"497806", "Bad\ Peterstal\-Griesbach",
"497664", "Freiburg\-Tiengen",
"4939754", "Löcknitz\ Vorpom",
"493379", "Mahlow",
"498771", "Ergoldsbach",
"49581", "Uelzen",
"497543", "Kressbronn\ am\ Bodensee",
"497802", "Oberkirch\ Baden",
"498285", "Burtenbach",
"496743", "Bacharach",
"498431", "Neuburg\ an\ der\ Donau",
"492952", "Rüthen",
"497366", "Abtsgmünd",
"498067", "Tuntenhausen",
"494455", "Jade\-Schweiburg",
"4939057", "Rätzlingen\ Sachsen\-Anhalt",
"494153", "Lauenburg\ Elbe",
"4938486", "Gustävel",
"4938374", "Lassan\ bei\ Wolgast",
"499396", "Urspringen\ bei\ Lohr",
"492301", "Holzwickede",
"499973", "Furth\ im\ Wald",
"499236", "Nagel",
"498652", "Berchtesgaden",
"4939006", "Miesterhorst",
"499392", "Faulbach\ Unterfranken",
"49221", "Cologne",
"4939039", "Bonese",
"497043", "Maulbronn",
"4939404", "Ausleben",
"4939991", "Daberkow",
"4933653", "Ziltendorf",
"495184", "Freden\ Leine",
"4938787", "Glöwen",
"496130", "Schwabenheim\ an\ der\ Selz",
"496283", "Hardheim\ Odenwald",
"499232", "Wunsiedel",
"498656", "Anger",
"492861", "Borken\ Westfalen",
"498745", "Bodenkirchen",
"496131", "Mainz",
"497633", "Staufen\ im\ Breisgau",
"498847", "Obersöchering",
"4938791", "Bad\ Wilsnack",
"492456", "Selfkant",
"49209", "Gelsenkirchen",
"498387", "Weiler\-Simmerberg",
"496246", "Eich\ Rheinhessen",
"4934783", "Gerbstedt",
"499764", "Höchheim",
"497558", "Illmensee",
"497082", "Neuenbürg\ Württemberg",
"496758", "Waldböckelheim",
"4937383", "Lunzenau",
"492452", "Heinsberg\ Rheinland",
"4933748", "Treuenbrietzen",
"497834", "Wolfach",
"494479", "Molbergen\-Peheim",
"493744", "Auerbach\ Vogtland",
"492541", "Coesfeld",
"495157", "Emmerthal\-Börry",
"496094", "Weibersbrunn",
"494148", "Drochtersen\-Assel",
"499141", "Weissenburg\ in\ Bayern",
"496242", "Osthofen",
"494955", "Westoverledingen",
"496786", "Kempfeld",
"492041", "Bottrop",
"496594", "Birresborn",
"497582", "Bad\ Buchau",
"492631", "Neuwied",
"499473", "Kallmünz",
"492630", "Mülheim\-Kärlich",
"492575", "Greven\-Reckenfeld",
"499175", "Spalt",
"496782", "Birkenfeld\ Nahe",
"499733", "Münnerstadt",
"497303", "Illertissen",
"499204", "Plankenfels",
"497586", "Herbertingen",
"4935935", "Kleinwelka",
"498153", "Wessling",
"49671", "Bad\ Kreuznach",
"497136", "Bad\ Friedrichshall",
"495502", "Dransfeld",
"498072", "Haag\ in\ Oberbayern",
"497259", "Östringen\-Odenheim",
"499438", "Fensterbach",
"499407", "Wenzenbach",
"494431", "Wildeshausen",
"494285", "Rhade\ bei\ Zeven",
"4939408", "Hadmersleben",
"497132", "Neckarsulm",
"4934779", "Abberode",
"495506", "Adelebsen",
"498076", "Pfaffing",
"495383", "Lutter\ am\ Barenberge",
"499778", "Fladungen",
"494770", "Wischhafen",
"499681", "Windischeschenbach",
"49760", "Oberried\ Breisgau",
"493601", "Mühlhausen\ Thüringen",
"494771", "Hemmoor",
"495843", "Wustrow\ Wendland",
"495191", "Soltau",
"4938301", "Putbus",
"495190", "Soltau\-Emmingen",
"4938378", "Heringsdorf\ Seebad",
"49751", "Ravensburg",
"492243", "Eitorf",
"4933367", "Friedrichswalde\ Brandenburg",
"494745", "Bad\ Bederkesa",
"496155", "Griesheim\ Hessen",
"496361", "Rockenhausen",
"496453", "Gemünden\ Wohra",
"4939291", "Calbe\ Saale",
"499624", "Ensdorf\ Oberpfalz",
"494354", "Fleckeby",
"495909", "Wettrup",
"4935822", "Hagenwerder",
"498572", "Tann\ Niederbayern",
"499326", "Markt\ Einersheim",
"493523", "Coswig\ bei\ Dresden",
"495534", "Eschershausen\ an\ der\ Lenne",
"496580", "Zemmer",
"496024", "Schöllkrippen",
"496581", "Saarburg",
"495063", "Bad\ Salzdetfurth",
"499823", "Leutershausen",
"497275", "Kandel",
"4936601", "Hermsdorf\ Thüringen",
"494931", "Norden",
"493987", "Templin",
"499938", "Moos\ Niederbayern",
"499907", "Zenting",
"49202", "Wuppertal",
"493331", "Angermünde",
"4939779", "Eggesin",
"4936642", "Harra",
"495858", "Hitzacker\-Wietzetze",
"494847", "Oster\-Ohrstedt",
"4936332", "Ellrich",
"495346", "Liebenburg",
"497724", "St\ Georgen\ im\ Schwarzwald",
"4934291", "Borsdorf",
"4933744", "Hohenseefeld",
"492742", "Wissen",
"495409", "Hilter\ am\ Teutoburger\ Wald",
"495644", "Willebadessen\-Peckelsheim",
"4936027", "Lengenfeld\ Unterm\ Stein",
"497240", "Pfinztal",
"495034", "Neustadt\-Hagen",
"496081", "Usingen",
"495563", "Kreiensen",
"494829", "Wewelsfleth",
"492655", "Weibern",
"496524", "Rodershausen",
"4936764", "Neuhaus\-Schierschnitz",
"495882", "Gorleben",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+49|\D)//g;
      my $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;