# automatically generated file, don't edit



# Copyright 2011 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::IM;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20210204173826;

my $formatters = [
                {
                  'format' => '$1 $2',
                  'leading_digits' => '8001111',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '845464',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{2})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '800',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{6})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            1(?:
              3873|
              5(?:
                242|
                39[4-6]
              )|
              (?:
                697|
                768
              )[347]|
              9467
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{4,5})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            1(?:
              [2-69][02-9]|
              [78]
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{5,6})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            [25]|
            7(?:
              0|
              6(?:
                [03-9]|
                2[356]
              )
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '7',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{6})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '[1389]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{4})'
                }
              ];

my $validators = {
                'fixed_line' => '1624[5-8]\\d{5}',
                'geographic' => '1624[5-8]\\d{5}',
                'mobile' => '
          76245[06]\\d{4}|
          7(?:
            4576|
            [59]24\\d|
            624[0-4689]
          )\\d{5}
        ',
                'pager' => '',
                'personal_number' => '70\\d{8}',
                'specialrate' => '(
          8(?:
            440[49]06|
            72299\\d
          )\\d{3}|
          (?:
            8(?:
              45|
              70
            )|
            90[0167]
          )624\\d{4}
        )|(
          3440[49]06\\d{3}|
          (?:
            3(?:
              08162|
              3\\d{4}|
              45624|
              7(?:
                0624|
                2299
              )
            )|
            55\\d{4}
          )\\d{4}
        )',
                'toll_free' => '808162\\d{4}',
                'voip' => '56\\d{8}'
              };
my %areanames = ();
$areanames{en} = {"441625", "Macclesfield",
"441884", "Tiverton",
"441880", "Tarbert",
"441631", "Oban",
"441626", "Newton\ Abbot",
"441422", "Halifax",
"441887", "Aberfeldy",
"441280", "Buckingham",
"441141", "Sheffield",
"4414346", "Hexham",
"441581", "New\ Luce",
"441287", "Guisborough",
"441382", "Dundee",
"4414306", "Market\ Weighton",
"4414376", "Haverfordwest",
"441284", "Bury\ St\ Edmunds",
"441756", "Skipton",
"441429", "Hartlepool",
"441992", "Lea\ Valley",
"442828", "Larne",
"441769", "South\ Molton",
"4418476", "Tongue",
"441505", "Johnstone",
"441389", "Dumbarton",
"441478", "Isle\ of\ Skye\ \-\ Portree",
"441506", "Bathgate",
"442879", "Magherafelt",
"441993", "Witney",
"441911", "Tyneside\/Durham\/Sunderland",
"441438", "Stevenage",
"441295", "Banbury",
"441671", "Newton\ Stewart",
"4413398", "Aboyne",
"44147982", "Nethy\ Bridge",
"4412293", "Millom",
"441848", "Thornhill",
"441296", "Aylesbury",
"441763", "Royston",
"441308", "Bridport",
"4419642", "Hornsea",
"441896", "Galashiels",
"4419752", "Alford\ \(Aberdeen\)",
"441895", "Uxbridge",
"441383", "Dunfermline",
"441248", "Bangor\ \(Gwynedd\)",
"441445", "Gairloch",
"441972", "Glenborrodale",
"441933", "Wellingborough",
"441446", "Barry",
"441642", "Middlesbrough",
"441600", "Monmouth",
"4412294", "Barrow\-in\-Furness",
"4418908", "Coldstream",
"4415396", "Sedbergh",
"441604", "Northampton",
"44131", "Edinburgh",
"4413881", "Bishop\ Auckland\/Stanhope\ \(Eastgate\)",
"441520", "Lochcarron",
"441527", "Redditch",
"441236", "Coatbridge",
"44147984", "Carrbridge",
"441235", "Abingdon",
"441558", "Llandeilo",
"441524", "Lancaster",
"441708", "Romford",
"442892", "Lisburn",
"441954", "Madingley",
"441928", "Runcorn",
"441363", "Crediton",
"441835", "St\ Boswells",
"441957", "Mid\ Yell",
"441821", "Kinrossie",
"441950", "Sandwick",
"4419640", "Hornsea\/Patrington",
"441691", "Oswestry",
"441275", "Clevedon",
"441782", "Stoke\-on\-Trent",
"441939", "Wem",
"4417687", "Keswick",
"441276", "Camberley",
"441864", "Abington\ \(Crawford\)",
"441876", "Lochmaddy",
"441362", "Dereham",
"442893", "Ballyclare",
"441264", "Andover",
"4419750", "Alford\ \(Aberdeen\)\/Strathdon",
"441875", "Tranent",
"4415078", "Alford\ \(Lincs\)",
"441260", "Congleton",
"441561", "Laurencekirk",
"441267", "Carmarthen",
"441932", "Weybridge",
"441643", "Minehead",
"441789", "Stratford\-upon\-Avon",
"4419467", "Gosforth",
"441355", "East\ Kilbride",
"441356", "Brechin",
"441369", "Dunoon",
"442841", "Rostrevor",
"4418516", "Great\ Bernera",
"4415394", "Hawkshead",
"441799", "Saffron\ Walden",
"441962", "Winchester",
"441253", "Blackpool",
"441606", "Northwich",
"4412296", "Barrow\-in\-Furness",
"441444", "Haywards\ Heath",
"441440", "Haverhill",
"4414238", "Harrogate",
"441955", "Wick",
"441834", "Narberth",
"44292", "Cardiff",
"441830", "Kirkwhelpington",
"441409", "Holsworthy",
"441681", "Isle\ of\ Mull\ \-\ Fionnphort",
"441792", "Swansea",
"441969", "Leyburn",
"441837", "Okehampton",
"441526", "Martin",
"441531", "Ledbury",
"441237", "Bideford",
"441373", "Frome",
"441332", "Derby",
"441234", "Bedford",
"441525", "Leighton\ Buzzard",
"441877", "Callander",
"441870", "Isle\ of\ Benbecula",
"4418473", "Thurso",
"441259", "Alloa",
"441874", "Brecon",
"441793", "Swindon",
"441274", "Bradford",
"441859", "Harris",
"441866", "Kilchrenan",
"441372", "Esher",
"441333", "Peat\ Inn\ \(Leven\ \(Fife\)\)",
"4416869", "Newtown",
"441571", "Lochinver",
"441277", "Brentwood",
"441865", "Oxford",
"44147983", "Boat\ of\ Garten",
"442882", "Omagh",
"441270", "Crewe",
"441963", "Wincanton",
"441354", "Chatteris",
"441328", "Fakenham",
"4418514", "Great\ Bernera",
"441403", "Horsham",
"441252", "Aldershot",
"441357", "Strathaven",
"441350", "Dunkeld",
"4420", "London",
"442889", "Fivemiletown",
"4414303", "North\ Cave",
"441488", "Hungerford",
"4414373", "Clynderwen\ \(Clunderwen\)",
"441379", "Diss",
"4414343", "Haltwhistle",
"441852", "Kilmelford",
"441733", "Peterborough",
"4414304", "North\ Cave",
"441286", "Caernarfon",
"4414374", "Clynderwen\ \(Clunderwen\)",
"441285", "Cirencester",
"4414344", "Bellingham",
"441772", "Preston",
"441885", "Pencombe",
"4418513", "Stornoway",
"441624", "Isle\ of\ Man",
"441620", "North\ Berwick",
"441549", "Lairg",
"441886", "Bromyard\ \(Knightwick\/Leigh\ Sinton\)",
"44247", "Coventry",
"441779", "Peterhead",
"441983", "Isle\ of\ Wight",
"441757", "Selby",
"4418474", "Thurso",
"441750", "Selkirk",
"4416867", "Llanidloes",
"441542", "Keith",
"441341", "Barmouth",
"441908", "Milton\ Keynes",
"441728", "Saxmundham",
"441754", "Skegness",
"441982", "Builth\ Wells",
"441451", "Stow\-on\-the\-Wold",
"441543", "Cannock",
"44281", "Northern\ Ireland",
"441732", "Sevenoaks",
"441661", "Prudhoe",
"441989", "Ross\-on\-Wye",
"4419645", "Hornsea",
"441773", "Ripley",
"441294", "Ardrossan",
"4416861", "Newtown\/Llanidloes",
"441392", "Exeter",
"441591", "Llanwrtyd\ Wells",
"441297", "Axminster",
"4419755", "Alford\ \(Aberdeen\)",
"441290", "Cumnock",
"441239", "Cardigan",
"441646", "Milford\ Haven",
"441442", "Hemel\ Hempstead",
"441568", "Leominster",
"441353", "Ely",
"4414232", "Harrogate",
"441698", "Motherwell",
"441404", "Honiton",
"441967", "Strontian",
"441400", "Honington",
"4418905", "Ayton",
"441407", "Holyhead",
"441273", "Brighton",
"441337", "Ladybank",
"441330", "Banchory",
"4416866", "Newtown",
"441334", "St\ Andrews",
"441449", "Stowmarket",
"442895", "Belfast",
"4417683", "Appleby",
"441790", "Spilsby",
"441797", "Rye",
"441832", "Clopton",
"441873", "Abergavenny",
"442896", "Belfast",
"441794", "Romsey",
"441785", "Stafford",
"442880", "Carrickmore",
"442887", "Dungannon",
"441786", "Stirling",
"441491", "Henley\-on\-Thames",
"441377", "Driffield",
"441233", "Ashford\ \(Kent\)",
"441833", "Barnard\ Castle",
"4415075", "Spilsby\ \(Horncastle\)",
"441872", "Truro",
"441366", "Downham\ Market",
"441359", "Pakenham",
"441443", "Pontypridd",
"441857", "Sanday",
"441935", "Yeovil",
"441279", "Bishops\ Stortford",
"441828", "Coupar\ Angus",
"441854", "Ullapool",
"441352", "Mold",
"4412299", "Millom",
"441254", "Blackburn",
"441228", "Carlisle",
"441879", "Scarinish",
"441250", "Blairgowrie",
"441257", "Coppull",
"441766", "Porthmadog",
"441293", "Crawley",
"441431", "Helmsdale",
"441622", "Maidstone",
"441759", "Pocklington",
"441765", "Ripon",
"4412180", "Birmingham",
"441211", "Birmingham",
"442867", "Lisnaskea",
"441425", "Ringwood",
"441386", "Evesham",
"441770", "Isle\ of\ Arran",
"441777", "Retford",
"4412297", "Millom",
"441509", "Loughborough",
"441918", "Tyneside",
"441995", "Garstang",
"441544", "Kington",
"441540", "Kingussie",
"441752", "Plymouth",
"441629", "Matlock",
"441241", "Arbroath",
"441547", "Knighton",
"441678", "Bala",
"441502", "Lowestoft",
"441841", "Newquay\ \(Padstow\)",
"441948", "Whitchurch",
"441301", "Arrochar",
"4414230", "Harrogate\/Boroughbridge",
"4417684", "Pooley\ Bridge",
"441588", "Bishops\ Castle",
"441753", "Slough",
"441299", "Bewdley",
"4415242", "Hornby",
"441987", "Ebbsfleet",
"441503", "Looe",
"441980", "Amesbury",
"441899", "Biggar",
"441984", "Watchet\ \(Williton\)",
"4412291", "Barrow\-in\-Furness\/Millom",
"441638", "Newmarket",
"441292", "Ayr",
"441623", "Mansfield",
"441394", "Felixstowe",
"441471", "Isle\ of\ Skye\ \-\ Broadford",
"441397", "Fort\ William",
"4413395", "Aboyne",
"442821", "Martinstown",
"441892", "Tunbridge\ Wells",
"441737", "Redhill",
"441730", "Petersfield",
"441387", "Dumfries",
"441776", "Stranraer",
"441380", "Devizes",
"44291", "Cardiff",
"441384", "Dudley",
"442877", "Limavady",
"441775", "Spalding",
"441282", "Burnley",
"442870", "Coleraine",
"441420", "Alton",
"441767", "Sandy",
"441427", "Gainsborough",
"441882", "Kinloch\ Rannoch",
"441760", "Swaffham",
"441764", "Crieff",
"442866", "Enniskillen",
"441424", "Hastings",
"441458", "Glastonbury",
"441289", "Berwick\-upon\-Tweed",
"441598", "Lynton",
"4418511", "Great\ Bernera\/Stornoway",
"4416973", "Wigton",
"441545", "Llanarth",
"4418900", "Coldstream\/Ayton",
"441994", "St\ Clears",
"441668", "Bamburgh",
"441889", "Rugeley",
"441546", "Lochgilphead",
"441997", "Strathpeffer",
"441986", "Bungay",
"441651", "Oldmeldrum",
"441985", "Warminster",
"4416863", "Llanidloes",
"4418479", "Tongue",
"4414379", "Haverfordwest",
"442830", "Newry",
"441808", "Tomatin",
"442837", "Armagh",
"4414309", "Market\ Weighton",
"4419648", "Hornsea",
"4413392", "Aboyne",
"441736", "Penzance",
"441721", "Peebles",
"441348", "Fishguard",
"4414349", "Bellingham",
"441283", "Burton\-on\-Trent",
"4418517", "Stornoway",
"441461", "Gretna",
"4419758", "Strathdon",
"441883", "Caterham",
"441395", "Budleigh\ Salterton",
"4415070", "Louth\/Alford\ \(Lincs\)\/Spilsby\ \(Horncastle\)",
"441208", "Bodmin",
"4418519", "Great\ Bernera",
"441405", "Goole",
"4414347", "Hexham",
"441578", "Lauder",
"4414307", "Market\ Weighton",
"441406", "Holbeach",
"441959", "Westerham",
"4414377", "Haverfordwest",
"441529", "Sleaford",
"441647", "Moretonhampstead",
"4414235", "Harrogate",
"441974", "Llanon",
"441970", "Aberystwyth",
"4418902", "Coldstream",
"441644", "New\ Galloway",
"441977", "Pontefract",
"441609", "Northallerton",
"442894", "Antrim",
"441952", "Telford",
"441796", "Pitlochry",
"441263", "Cromer",
"441481", "Guernsey",
"442897", "Saintfield",
"441795", "Sittingbourne",
"442890", "Belfast",
"441748", "Richmond",
"441335", "Ashbourne",
"4416864", "Llanidloes",
"441522", "Lincoln",
"441863", "Ardgay",
"4418477", "Tongue",
"441364", "Ashburton",
"441953", "Wymondham",
"4414341", "Bellingham\/Haltwhistle\/Hexham",
"4416974", "Raughton\ Head",
"4413390", "Aboyne\/Ballater",
"441262", "Bridlington",
"441367", "Faringdon",
"4414371", "Haverfordwest\/Clynderwen\ \(Clunderwen\)",
"441360", "Killearn",
"4414301", "North\ Cave\/Market\ Weighton",
"4415072", "Spilsby\ \(Horncastle\)",
"441784", "Staines",
"442311", "Southampton",
"442886", "Cookstown",
"441375", "Grays\ Thurrock",
"441787", "Sudbury",
"442885", "Ballygawley",
"441862", "Tain",
"441780", "Stamford",
"441376", "Braintree",
"441255", "Clacton\-on\-Sea",
"441538", "Ipstones",
"441269", "Ammanford",
"441256", "Basingstoke",
"441603", "Norwich",
"441937", "Wetherby",
"441869", "Bicester",
"441856", "Orkney",
"4418471", "Thurso\/Tongue",
"441934", "Weston\-super\-Mare",
"441855", "Ballachulish",
"441688", "Isle\ of\ Mull\ \-\ Tobermory",
"441806", "Shetland",
"441738", "Perth",
"441346", "Fraserburgh",
"441805", "Torrington",
"441205", "Boston",
"44141", "Glasgow",
"441206", "Colchester",
"441653", "Malton",
"441398", "Dulverton",
"441988", "Wigtown",
"4418909", "Ayton",
"441634", "Medway",
"441630", "Market\ Drayton",
"441637", "Newquay",
"441140", "Sheffield",
"441903", "Worthing",
"441580", "Cranbrook",
"441723", "Scarborough",
"441463", "Inverness",
"4418512", "Stornoway",
"441144", "Sheffield",
"4413397", "Ballater",
"441584", "Ludlow",
"441595", "Lerwick\,\ Foula\ \&\ Fair\ Isle",
"441677", "Bedale",
"441944", "West\ Heslerton",
"441670", "Morpeth",
"4418470", "Thurso\/Tongue",
"441674", "Montrose",
"441947", "Whitby",
"4412295", "Barrow\-in\-Furness",
"441659", "Sanquhar",
"441722", "Salisbury",
"441902", "Wolverhampton",
"441462", "Hitchin",
"441666", "Malmesbury",
"441548", "Kingsbridge",
"441665", "Alnwick",
"441778", "Bourne",
"441914", "Tyneside",
"44238", "Southampton",
"4415079", "Alford\ \(Lincs\)",
"441910", "Tyneside\/Durham\/Sunderland",
"441917", "Sunderland",
"4414300", "North\ Cave\/Market\ Weighton",
"4414370", "Haverfordwest\/Clynderwen\ \(Clunderwen\)",
"441455", "Hinckley",
"4413391", "Aboyne\/Ballater",
"441469", "Killingholme",
"4414340", "Bellingham\/Haltwhistle\/Hexham",
"441456", "Glenurquhart",
"441652", "Brigg",
"442868", "Kesh",
"441729", "Settle",
"441909", "Worksop",
"441536", "Kettering",
"441227", "Canterbury",
"4415077", "Louth",
"4418901", "Coldstream\/Ayton",
"441322", "Dartford",
"441258", "Blandford",
"441224", "Aberdeen",
"441535", "Keighley",
"4418510", "Great\ Bernera\/Stornoway",
"441824", "Ruthin",
"441858", "Market\ Harborough",
"441685", "Merthyr\ Tydfil",
"441951", "Colonsay",
"441827", "Tamworth",
"441482", "Kingston\-upon\-Hull",
"441329", "Fareham",
"4419646", "Patrington",
"441489", "Bishops\ Waltham",
"4419756", "Strathdon",
"4415071", "Louth\/Alford\ \(Lincs\)\/Spilsby\ \(Horncastle\)",
"441798", "Pulborough",
"4418907", "Ayton",
"4413873", "Langholm",
"441746", "Bridgnorth",
"4413399", "Ballater",
"4414342", "Bellingham",
"442844", "Downpatrick",
"441745", "Rhyl",
"4414372", "Clynderwen\ \(Clunderwen\)",
"442840", "Banbridge",
"4414302", "North\ Cave",
"441697", "Brampton",
"441575", "Kirriemuir",
"441690", "Betws\-y\-Coed",
"441323", "Eastbourne",
"441576", "Lockerbie",
"441968", "Penicuik",
"441694", "Church\ Stretton",
"4418472", "Thurso",
"441408", "Golspie",
"441564", "Lapworth",
"441560", "Moscow",
"441483", "Guildford",
"441567", "Killin",
"441261", "Banff",
"441938", "Welshpool",
"4414231", "Harrogate\/Boroughbridge",
"441684", "Malvern",
"44147981", "Aviemore",
"441825", "Uckfield",
"441680", "Isle\ of\ Mull\ \-\ Craignure",
"441687", "Mallaig",
"441493", "Great\ Yarmouth",
"441530", "Coalville",
"441226", "Barnsley",
"441225", "Bath",
"441534", "Jersey",
"441553", "Kings\ Lynn",
"4419754", "Alford\ \(Aberdeen\)",
"441788", "Rugby",
"4419644", "Patrington",
"441368", "Dunbar",
"441923", "Watford",
"441747", "Shaftesbury",
"441740", "Sedgefield",
"4414237", "Harrogate",
"441744", "St\ Helens",
"4414345", "Haltwhistle",
"442898", "Belfast",
"441922", "Walsall",
"4414305", "North\ Cave",
"441702", "Southend\-on\-Sea",
"4414375", "Clynderwen\ \(Clunderwen\)",
"441499", "Inveraray",
"441871", "Castlebay",
"4412290", "Barrow\-in\-Furness\/Millom",
"441565", "Knutsford",
"441559", "Llandysul",
"4418475", "Thurso",
"441978", "Wrexham",
"441566", "Launceston",
"441492", "Colwyn\ Bay",
"441929", "Wareham",
"441709", "Rotherham",
"441271", "Barnstaple",
"441695", "Skelmersdale",
"441577", "Kinross",
"441570", "Lampeter",
"441302", "Doncaster",
"44239", "Portsmouth",
"441204", "Bolton",
"441200", "Clitheroe",
"441207", "Consett",
"441501", "Harthill",
"441842", "Thetford",
"441344", "Bracknell",
"441751", "Pickering",
"441439", "Helmsley",
"442838", "Portadown",
"441242", "Cheltenham",
"441807", "Ballindalloch",
"441347", "Easingwold",
"441340", "Craigellachie\ \(Aberlour\)",
"441586", "Campbeltown",
"4414239", "Boroughbridge",
"441309", "Forres",
"441145", "Sheffield",
"441473", "Ipswich",
"441212", "Birmingham",
"441635", "Newbury",
"441249", "Chippenham",
"4418515", "Stornoway",
"441636", "Newark\-on\-Trent",
"441621", "Maldon",
"441432", "Hereford",
"4419643", "Patrington",
"441667", "Nairn",
"441664", "Melton\ Mowbray",
"4412292", "Barrow\-in\-Furness",
"441213", "Birmingham",
"441945", "Wisbech",
"441676", "Meriden",
"441594", "Lydney",
"441472", "Grimsby",
"4419753", "Strathdon",
"4415395", "Grange\-over\-Sands",
"441946", "Whitehaven",
"441597", "Llandrindod\ Wells",
"441291", "Chepstow",
"441675", "Coleshill",
"441433", "Hathersage",
"441590", "Lymington",
"442829", "Kilrea",
"441768", "Penrith",
"441303", "Folkestone",
"44115", "Nottingham",
"441428", "Haslemere",
"441454", "Chipping\ Sodbury",
"4416868", "Newtown",
"441450", "Hawick",
"441843", "Thanet",
"441457", "Glossop",
"441388", "Bishop\ Auckland",
"441243", "Chichester",
"441915", "Sunderland",
"441916", "Tyneside",
"441479", "Grantown\-on\-Spey",
"441573", "Kelso",
"441326", "Falmouth",
"4413885", "Stanhope\ \(Eastgate\)",
"441325", "Darlington",
"441485", "Hunstanton",
"441539", "Kendal",
"441268", "Basildon",
"4413394", "Ballater",
"4418903", "Coldstream",
"441743", "Shrewsbury",
"441689", "Orpington",
"441707", "Welwyn\ Garden\ City",
"441920", "Ware",
"441700", "Rothesay",
"441924", "Wakefield",
"441704", "Southport",
"4416860", "Newtown\/Llanidloes",
"441579", "Liskeard",
"44241", "Coventry",
"441554", "Llanelli",
"441528", "Laggan",
"441550", "Llandovery",
"441557", "Kirkcudbright",
"441572", "Oakham",
"441494", "High\ Wycombe",
"44147985", "Dulnain\ Bridge",
"441608", "Chipping\ Norton",
"442881", "Newtownstewart",
"441497", "Hay\-on\-Wye",
"441371", "Great\ Dunmow",
"441490", "Corwen",
"441683", "Moffat",
"441749", "Shepton\ Mallet",
"44147986", "Cairngorm",
"4415073", "Louth",
"441342", "East\ Grinstead",
"441244", "Chester",
"4415074", "Alford\ \(Lincs\)",
"44161", "Manchester",
"441304", "Dover",
"441840", "Camelford",
"441453", "Dursley",
"441202", "Bournemouth",
"441307", "Forfar",
"441300", "Cerne\ Abbas",
"441844", "Thame",
"441593", "Lybster",
"441809", "Tomdoun",
"441214", "Birmingham",
"441217", "Birmingham",
"441349", "Dingwall",
"44113", "Leeds",
"441210", "Birmingham",
"441771", "Maud",
"441209", "Redruth",
"441663", "New\ Mills",
"44117", "Bristol",
"441474", "Gravesend",
"441592", "Kirkcaldy",
"4413393", "Aboyne",
"4418904", "Coldstream",
"4412298", "Barrow\-in\-Furness",
"441477", "Holmes\ Chapel",
"441470", "Isle\ of\ Skye\ \-\ Edinbane",
"442820", "Ballycastle",
"441905", "Worcester",
"441725", "Rockbourne",
"442827", "Ballymoney",
"441465", "Girvan",
"4414236", "Harrogate",
"441726", "St\ Austell",
"441466", "Huntly",
"441343", "Elgin",
"4416862", "Llanidloes",
"441288", "Bude",
"441803", "Torquay",
"441599", "Kyle",
"441669", "Rothbury",
"441981", "Wormbridge",
"441656", "Bridgend",
"441452", "Gloucester",
"441888", "Turriff",
"441655", "Maybole",
"441305", "Dorchester",
"441298", "Buxton",
"441306", "Dorking",
"441845", "Thirsk",
"441913", "Durham",
"441245", "Chelmsford",
"4415076", "Louth",
"441639", "Neath",
"441246", "Chesterfield",
"4413880", "Bishop\ Auckland\/Stanhope\ \(Eastgate\)",
"441381", "Fortrose",
"442871", "Londonderry",
"4419757", "Strathdon",
"441142", "Sheffield",
"441582", "Luton",
"441215", "Birmingham",
"441943", "Guiseley",
"4418518", "Stornoway",
"441761", "Temple\ Cloud",
"441436", "Helensburgh",
"441216", "Birmingham",
"441673", "Market\ Rasen",
"4419647", "Patrington",
"441435", "Heathfield",
"441724", "Scunthorpe",
"441758", "Pwllheli",
"441904", "York",
"44116", "Leicester",
"441464", "Insch",
"441727", "St\ Albans",
"441460", "Chard",
"4414234", "Boroughbridge",
"441583", "Carradale",
"441720", "Isles\ of\ Scilly",
"441143", "Sheffield",
"442825", "Ballymena",
"441900", "Workington",
"441467", "Inverurie",
"441475", "Greenock",
"441942", "Wigan",
"441633", "Newport",
"441476", "Grantham",
"441672", "Marlborough",
"441919", "Durham",
"441508", "Brooke",
"4418906", "Ayton",
"441650", "Cemmaes\ Road",
"4416865", "Newtown",
"4419751", "Alford\ \(Aberdeen\)\/Strathdon",
"441654", "Machynlleth",
"441628", "Maidenhead",
"441912", "Tyneside",
"4419641", "Hornsea\/Patrington",
"441949", "Whatton",
"441480", "Huntingdon",
"441563", "Kilmarnock",
"441822", "Tavistock",
"441487", "Warboys",
"442891", "Bangor\ \(Co\.\ Down\)",
"44118", "Reading",
"4413882", "Stanhope\ \(Eastgate\)",
"441484", "Huddersfield",
"441327", "Daventry",
"441320", "Fort\ Augustus",
"441324", "Falkirk",
"441358", "Ellon",
"442843", "Newcastle\ \(Co\.\ Down\)",
"441278", "Bridgwater",
"441829", "Tarporley",
"44151", "Liverpool",
"4413396", "Ballater",
"441878", "Lochboisdale",
"441641", "Strathy",
"4414233", "Boroughbridge",
"441971", "Scourie",
"4419759", "Alford\ \(Aberdeen\)",
"441555", "Lanark",
"442842", "Kircubbin",
"441569", "Stonehaven",
"441556", "Castle\ Douglas",
"441706", "Rochdale",
"4414378", "Haverfordwest",
"441931", "Shap",
"441926", "Warwick",
"4414308", "Market\ Weighton",
"4419649", "Hornsea",
"441925", "Warrington",
"4414348", "Hexham",
"441838", "Dalmally",
"4418478", "Thurso",
"441823", "Taunton",
"441562", "Kidderminster",
"441361", "Duns",
"442310", "Portsmouth",
"441495", "Pontypool",
"441496", "Port\ Ellen",
"441692", "North\ Walsham",
"441223", "Cambridge",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+44|\D)//g;
      my $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      my $prefix = qr/^(?:0|([5-8]\d{5})$)/;
      my @matches = $number =~ /$prefix/;
      if (defined $matches[-1]) {
        no warnings 'uninitialized';
        $number =~ s/$prefix/1624$1/;
      }
      else {
        $number =~ s/$prefix//;
      }
      $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;