#!perl
use strict;
use warnings FATAL => 'all';
use Test::More;
use FindBin;
use Lingua::Thesaurus;
use List::MoreUtils qw/firstval/;

plan tests => 13;

my $db_file    = 'TEST.sqlite';
my $thesaurus = Lingua::Thesaurus->new(SQLite => $db_file);

my @terms   = $thesaurus->search_terms('accord*');
my $n_terms = @terms;
ok ($n_terms, "found $n_terms terms 'accord*'");

my $term = $thesaurus->fetch_term('ACCS  UN TRIBUNAL');
my $SN   = $term->SN;
is ($SN, "seulement au sens de l'art. 29a Cst. et de l'art. 6 CEDH; au sens de l'art. 5 par. 4 CEDH, utiliser CONTRLE DE LA DTENTION & AUTORIT JUDICIAIRE(TRIBUNAL)", "continuation line OK");

is ($term->origin, 'TF', "origin TF");

my @UF = $term->UF;
is(scalar(@UF), 5, "5 UF terms for 'ACCS  UN TRIBUNAL'");

my $first_UF = $term->UF;
is($first_UF, "accs", "scalar UF 'ACCS  UN TRIBUNAL' is 'accs'");


$term = $thesaurus->fetch_term('action tardive');
is ($term->origin, 'GE', "action tardive origin GE");

# same term in both thesauri
@terms = $thesaurus->search_terms('RETARD');
my @origins = sort map {$_->origin} @terms;
is_deeply(\@origins, [qw/GE TF/], "'RETARD' in both thesauri");


# API with specific origin
@terms = $thesaurus->search_terms('RETARD', 'TF');
@origins = sort map {$_->origin} @terms;
is_deeply(\@origins, [qw/TF/], "'RETARD' from one specific origin");

$term = $thesaurus->fetch_term('RETARD', 'TF');
is ($term->origin, 'TF', "RETARD, origin TF");

$term = $thesaurus->fetch_term('RETARD', 'GE');
is ($term->origin, 'GE', "RETARD, origin GE");


# special relations
$term = $thesaurus->fetch_term("ACCORD(EXAMEN DES DEMANDES D'ASILE)");
my @SA = $term->SA;
is_deeply(\@SA, ["ACCORD BILATRAL EN MATIRE DE POLICE",
                 "ACCORD BILATRAL EN MATIRE D'ENTRAIDE JUDICIAIRE"], "SA");
$SN = $term->SN;
like($SN, qr/examen d'une demande d'asile/, 'SN');


# Test loading the same file a 2nd time (2nd creation of the Term class)
undef $thesaurus;
$thesaurus = Lingua::Thesaurus->new(SQLite => $db_file);
@terms   = $thesaurus->search_terms('accord*');
$n_terms = @terms;
ok ($n_terms, "found again $n_terms terms 'accord*'");



