package OpenInteract2::SQLInstall::FullText;

# $Id: FullText.pm,v 1.2 2003/10/20 03:05:54 lachoy Exp $

use strict;
use base qw( OpenInteract2::SQLInstall );
use OpenInteract2::Context   qw( CTX );

$OpenInteract2::SQLInstall::FullText::VERSION = sprintf("%d.%02d", q$Revision: 1.2 $ =~ /(\d+)\.(\d+)/);

# NOTE: Don't define 'get_migration_information()' and migrate index
# data -- it will be regenerated with participating objects are
# migrated

sub get_structure_set {
    my ( $self ) = @_;
    my $ft_ds_name = CTX->server_config->{fulltext}{datasource};
    if ( $ft_ds_name ) {
        return "datasource: $ft_ds_name";
    }
    return 'system';
}

sub get_structure_file {
    my ( $self, $set, $type ) = @_;
    if ( $type eq 'Oracle' ) {
        return 'full_text_index_oracle.sql';
    }
    else {
        return 'full_text_index.sql';
    }
}

1;
