package OpenInteract::Handler::Package;

# $Id: Package.pm,v 1.2 2001/02/20 04:14:28 lachoy Exp $

use strict;
use SPOPS::Secure qw( :level );
use Data::Dumper  qw( Dumper );

@OpenInteract::Handler::Package::ISA               = qw( OpenInteract::Handler::GenericDispatcher SPOPS::Secure );
$OpenInteract::Handler::Package::VERSION           = sprintf("%d.%02d", q$Revision: 1.2 $ =~ /(\d+)\.(\d+)/);
$OpenInteract::Handler::Package::author            = 'chris@cwinters.com';
$OpenInteract::Handler::Package::default_method    = 'listing';
@OpenInteract::Handler::Package::forbidden_methods = ();
%OpenInteract::Handler::Package::security          = ( 
 listing => SEC_LEVEL_READ,  show   => SEC_LEVEL_WRITE,    
 edit    => SEC_LEVEL_WRITE, remove => SEC_LEVEL_WRITE,
);

use constant DEBUG => 1;

my $MAIN_SCRIPT = '/Package';

# List packages in the main interact directory as well as
# the packages in the website directory

sub listing {
  my ( $class, $p ) = @_;
  my $R = OpenInteract::Request->instance;
  my $params = { main_script => $MAIN_SCRIPT, error_msg => $p->{error_msg} };

  # First retrieve the packages from this app

  my $website_dir = $R->CONFIG->{dir}->{base};
  $R->scrib( 1, "Trying to open repository in website dir ($website_dir)" );
  my $website_repository  = $R->repository->fetch( 
                                     undef, { directory => $website_dir } );
  $params->{website_pkg}  = $website_repository->fetch_all_packages();

  # Next, retrieve the packages from base installation

  my $base_install_dir = $R->CONFIG->{dir}->{interact};
  $R->scrib( 1, "Trying to open repository in base installation dir ($base_install_dir)" );
  my $base_repository     = $R->repository->fetch( 
                                     undef, { directory => $base_install_dir } );
  $params->{interact_pkg} = $base_repository->fetch_all_packages();
  $R->{page}->{title} = "Package Listing";
  return $R->template->handler( {}, $params, 
                                { db => 'package_listing', package => 'base' } );
}


# The only thing you can edit is the notes, so we don't need to go
# through contortions here

sub show {
  my ( $class, $p ) = @_;
  my $R = OpenInteract::Request->instance;
  my $params = { main_script => $MAIN_SCRIPT, error_msg => $p->{error_msg} };
  my $do_edit = ( $R->apache->param( 'edit' ) and $p->{level} >= SEC_LEVEL_WRITE );

  $params->{scope} = $R->apache->param( 'scope' ) || 'local';
  my $base_dir = ( $params->{scope} eq 'interact' ) 
                   ? $R->CONFIG->{dir}->{interact} 
                   : $R->CONFIG->{dir}->{base};
  my $repository = $R->repository->fetch( undef, { directory => $base_dir } );

  my $name    = $R->apache->param( 'name' );
  my $version = $R->apache->param( 'version' );
  my $pkg = $p->{pkg} || 
            $repository->fetch_package_by_name({ name => $name, 
                                                 version => $version });
  unless ( $pkg ) {
    my $error_msg = "Sorry, couldn't find a package matching the criteria you specified.";
    return $class->listing( { error_msg => $error_msg } );
  }
  if ( $version and $version != $pkg->{version} ) {
    $params->{error_msg} .= "Found a working package, but it wasn't the version you requested.";
  }
  $params->{pkg} = $pkg;
  return $R->template->handler( {}, $params, { db => 'package_detail', 
                                               package => 'base' } );
}

sub edit {
  my ( $class, $p ) = @_;
  my $params = {};
  my $R = OpenInteract::Request->instance;
  my $name    = $R->apache->param( 'name' );
  my $version = $R->apache->param( 'version' );
  my $scope   = $R->apache->param( 'scope' );
  my $base_dir = ( $scope eq 'interact' ) ? $R->CONFIG->{dir}->{interact} : $R->CONFIG->{dir}->{base};
  my $repository = $R->repository->fetch( undef, { directory => $base_dir,
                                                   perm      => 'write' } );
  
  my $pkg = $repository->fetch_package_by_name({ name => $name, 
                                                 version => $version });
  if ( $@ or ! $pkg ) {
    my $error = $@ || "No package found using $name-$version";
    my $error_msg = "No changes made; cannot retrieve package for editing. Error: $error";
    return $class->listing( { error_msg => $error_msg } );
  }
  my @editable_fields = qw( notes );
  foreach my $field ( @editable_fields ) {
    $pkg->{ $field } = $R->apache->param( $field );
  }
  $pkg->{last_updated_on} = $repository->now;
  $pkg->{last_updated_by} = join( ' ', $R->{auth}->{user}->{login_name}, "<$R->{auth}->{user}->{email}>" );
  $repository->save_package( $pkg );
  eval { $repository->save() };
  if ( $@ ) {
    $params->{error_msg} = "Cannot save package changes! Error returned: $@";
  }
  $params->{pkg} = $pkg;
  return $class->show( $params );
}

sub remove {
 my ( $class, $p ) = @_;
 my $msg = <<MSG;
Sorry, removal of packages is not supported yet. Please use the 
command line interface provided by <code>oi_manage</code>.
MSG
 return $class->listing({ error_msg =>  });
}

1;

__END__

=pod

=head1 NAME

OpenInteract::Handler::Package - Allow viewing/editing of package information in base and website

=head1 SYNOPSIS

=head1 DESCRIPTION

=head1 METHODS

=head1 TO DO

=head1 BUGS

A few things do not work in here yet. Need to take a good look at this.

=head1 COPYRIGHT

Copyright (c) 2001 intes.net, inc.. All rights reserved.

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.

=head1 AUTHORS

Chris Winters <chris@cwinters.com>

=cut
