$spops = {
            'news' => {
              class        => 'OpenInteract::News',
              isa          => [ qw/ OpenInteract::SPOPS  SPOPS::Utility 
                                    SPOPS::Secure  SPOPS::DBI::MySQL  SPOPS::DBI / ],
              field        => [ qw/ news_id posted_on posted_by title 
                                    news_item active expires_on active_on / ],
              id_field     => 'news_id',
              no_insert    => [ qw/ news_id / ],
              skip_undef   => [ qw/ active expires_on / ],
              no_update    => [ qw/ news_id posted_on / ],
              base_table   => 'news',
              sql_defaults => [ qw/ active / ],
              field_alter  => {},
              alias        => [],
              has_a        => { 'OpenInteract::User' => [ 'posted_by' ] },
              links_to     => {},
              creation_security => {
                 u   => undef,
                 g   => { 3 => 'WRITE' },
                 w   => 'READ',
              },
              as_string_order => [ qw/ news_id title news_item posted_on posted_by expires_on / ],
              as_string_label => { news_id => 'ID', title => 'Title', news_item => 'News Item',
                                   posted_on => 'Posted On',  posted_by => 'Posted By',
                                   expires_on => 'Expires On' },
              track => { create => 1, update => 1, remove => 1 },
              display => { url => '/News/show/' },
              name => 'title',
              object_name => 'News',
            },

};