use 5.14.0;
use warnings;

use Moops;

our $VERSION = '0.1210'; # VERSION:
# PODNAME: Types::Stenciller
# ABSTRACT: Types for Stenciller

library Types::Stenciller

extends Types::Standard, Types::Path::Tiny

{

    class_type Stenciller => { class => 'Stenciller::Wrap' };
    class_type Stencil    => { class => 'Stenciller::Stencil' };

}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Types::Stenciller - Types for Stenciller

=head1 VERSION

Version 0.1210, released 2015-02-09.



=head1 SYNOPSIS

    use Types::Stenciller -types;

=head1 DESCRIPTION

Defines a couple of types used in the C<Stenciller> namespace.

=head1 TYPES

=over 4

=item *

C<Stenciller> is a L<Stenciller>

=item *

C<Stencil> is a L<Stenciller::Stencil>

=back

It also inherits from L<Types::Standard> and L<Types::Path::Tiny>.

=head1 SOURCE

L<https://github.com/Csson/p5-Stenciller>

=head1 HOMEPAGE

L<https://metacpan.org/release/Stenciller>

=head1 AUTHOR

Erik Carlsson <info@code301.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by Erik Carlsson <info@code301.com>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
