use 5.14.0;
use strict;
use warnings;

package Opendata::GTFS::Standard {

    our $VERSION = '0.0101'; # VERSION

    use base 'Moops';
    use List::AllUtils();
    use MooseX::StrictConstructor();
    use Types::Opendata::GTFS();
    use Safe::Isa;

    sub import {
        my $class = shift;
        my %opts = @_;

        push @{ $opts{'imports'} ||= [] } => (
            'List::AllUtils'    => [qw/any none sum uniq zip first_index/],
            'Types::Opendata::GTFS' => [{ replace => 1 }, '-types'],
            'MooseX::StrictConstructor' => [],
            'Safe::Isa' => ['$_does'],
        );

        $class->SUPER::import(%opts);
    }
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Opendata::GTFS::Standard

=head1 VERSION

Version 0.0101, released 2015-02-19.

=head1 HOMEPAGE

L<https://metacpan.org/release/Opendata-GTFS-Feed>

=head1 AUTHOR

Erik Carlsson <info@code301.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by Erik Carlsson <info@code301.com>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
