use 5.14.0;

package Map::Metro::Plugin::Map::Oslo;

our $VERSION = '0.1102'; # VERSION
# ABSTRACT: Map::Metro map for Oslo

use Moose;

with 'Map::Metro::Plugin::Map';

has '+mapfile' => (
    default => 'map-oslo.metro',
);
sub map_version {
    return $VERSION;
}
sub map_package {
    return __PACKAGE__;
}

1;

__END__

=pod

=encoding utf-8

=head1 NAME

Map::Metro::Plugin::Map::Oslo - Map::Metro map for Oslo

=head1 VERSION

Version 0.1102, released 2015-01-22.

=head1 SYNOPSIS

    use Map::Metro;
    my $graph = Map::Metro->new('Oslo')->parse;

Or:

	map-metro.pl route Oslo Veitvet Holmenkollen

=head1 DESCRIPTION

See L<Map::Metro> for usage information.

=head1 Status

This map L<contains|Map::Metro::Plugin::Map::Oslo::Lines>:

=over 4

=item *

All six metro lines [L<wikipedia|https://en.wikipedia.org/wiki/Oslo_metro>]

=back

=head2 Note

Line 1 terminates at Helsfyr.

=for HTML <p><a href="https://raw.githubusercontent.com/Csson/p5-Map-Metro-Oslo/master/static/images/oslo.png"><img src="https://raw.githubusercontent.com/Csson/p5-Map-Metro-Oslo/master/static/images/oslo.png" style="max-width: 600px" /></a></p>

=head1 SOURCE

L<https://github.com/Csson/p5-Map-Metro-Oslo>

=head1 HOMEPAGE

L<https://metacpan.org/release/Map-Metro-Plugin-Map-Oslo>

=head1 AUTHOR

Erik Carlsson <info@code301.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by Erik Carlsson <info@code301.com>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
