use strict;
use warnings;
use Dist::Iller::Standard;

our $VERSION = '0.1203'; # VERSION
# PODNAME: Dist::Iller::Role::Config

role Dist::Iller::Role::Config using Moose {
    use File::ShareDir 'dist_dir';

    requires 'filepath';
    has distribution_name => (
        is => 'ro',
        isa => Str,
    );

    method configlocation {
        my $package = $self->meta->name;
        $package =~ s{::}{-}g;
        my $dir = path('.');
        try {
            $dir = path(dist_dir($package));
        }
        finally { };
        return $dir->child($self->filepath);
    }

    method get_yaml_for(IllerDoctype $doctype) {
        return $self->get_yaml_for_dist if $doctype->type eq 'dist';
        return $self->get_yaml_for_weaver if $doctype->type eq 'weaver';
        return;
    }

    method get_yaml_for_dist {
        my $yaml = YAML::Tiny->read($self->configlocation->absolute->stringify);

        return (grep { $_->{'doctype'} eq 'dist'} @$yaml)[0];
    }
    method get_yaml_for_weaver {
        my $yaml = YAML::Tiny->read($self->configlocation->stringify);

        return (grep { $_->{'doctype'} eq 'weaver'} @$yaml)[0];
    }


}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Dist::Iller::Role::Config

=head1 VERSION

Version 0.1203, released 2016-01-09.

=head1 SOURCE

L<https://github.com/Csson/p5-Dist-Iller>

=head1 HOMEPAGE

L<https://metacpan.org/release/Dist-Iller>

=head1 AUTHOR

Erik Carlsson <info@code301.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by Erik Carlsson.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
