use 5.20.0;

our $VERSION = '0.0101'; # VERSION

package CairoX::Sweet::Standard {

    use base 'Moops';
    use Types::CairoX::Sweet();
    use MooseX::StrictConstructor();
    use List::AllUtils();
    use Eponymous::Hash();
    use Path::Tiny();

    sub import {
        my $class = shift;
        my %opts = @_;

        push @{ $opts{'imports'} ||= [] } => (
            'Types::CairoX::Sweet' => [{ replace => 1 }, '-types'],
            'MooseX::StrictConstructor' => [],
            'List::AllUtils' => [qw/any sum zip/],
            'Eponymous::Hash' => ['eh'],
            'Path::Tiny' => ['path'],
        );

        $class->SUPER::import(%opts);
    }
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

CairoX::Sweet::Standard

=head1 VERSION

Version 0.0101, released 2015-01-11.

=head1 SOURCE

L<https://github.com/Csson/p5-CairoX-Sweet>

=head1 HOMEPAGE

L<https://metacpan.org/release/CairoX-Sweet>

=head1 AUTHOR

Erik Carlsson <info@code301.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by Erik Carlsson <info@code301.com>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
