# $Id: Net-DNS.spec.PL,v 1.1 2002/11/15 10:42:50 ctriv Exp $
# Copyright (C) 2001,2002 Rob Brown (bbb@cpan.org)
# General rpm SPEC file generator.

use strict;

my $p = $1 if $0 =~ m%([^/]*)$%;
my $output = shift || do {
  my $dest = $p;
  $dest =~ /\.PL$/;
  $dest;
};

### Extract $VERSION from VERSION_FROM
my $name;
my $version;
$INC{"ExtUtils/MakeMaker.pm"} = 1;

# Hack to let prompt work right.
sub prompt {-e "t/online.enabled"?"y":"n"}

sub WriteMakefile {
  my %props = @_;
  $name = $props{NAME} || die "Makefile.PL: Missing NAME";
  if ($version = $props{VERSION}) {
    # done
  } elsif (my $version_from = $props{VERSION_FROM}) {
    $@ = "";
    $version = eval qq{
      do "$version_from";
      \$$name\::VERSION || die "$version_from: Missing VERSION";
    };
    die $@ if $@;
    if (!defined $version) {
      die "$version_from: Missing VERSION";
    }
  } else {
    die "Makefile.PL: Could not determine version!";
  }
}
do "Makefile.PL";
if ($name) {
  $name =~ s/::/-/g;
} else {
  die "Makefile.PL: Missing WriteMakefile";
}

my ($class,$subclass) = split(/\-/,$name,2);
local $/ = undef;
$_ = <DATA>;
s/\@CLASS\@/$class/g;
s/\@SUBCLASS\@/$subclass/g;
s/\@VERSION\@/$version/g;

open SPEC, ">$output" or die "$output: $!";
print SPEC "# Automatically generated by $p\n";
print SPEC $_;
close SPEC;

__DATA__
%define class @CLASS@
%define subclass @SUBCLASS@
%define version @VERSION@
%define release 1
%define defperlver 5.6.1

# Derived values
%define real_name %{class}-%{subclass}
%define name perl-%{real_name}
%define perlver %(rpm -q perl --queryformat '%%{version}' 2> /dev/null || echo %{defperlver})

# Provide perl-specific find-{provides,requires}.
%define __find_provides %( echo -n /usr/lib/rpm/find-provides && [ -x /usr/lib/rpm/find-provides.perl ] && echo .perl )
%define __find_requires %( echo -n /usr/lib/rpm/find-requires && [ -x /usr/lib/rpm/find-requires.perl ] && echo .perl )

Summary:        Perl module %{class}::%{subclass}
Name:           %{name}
Version:        %{version}
Release:        %{release}
Group:          Development/Perl
License:        See documentation
Source:         http://www.cpan.org/modules/by-module/%{class}/%{real_name}-%{version}.tar.gz
Url:            http://search.cpan.org/search?dist=%{real_name}
Vendor:         Rob Brown <bbb@cpan.org>
BuildRequires:  perl
BuildRoot:      %{_tmppath}/%{name}-%{version}-buildroot-%(id -u -n)
Requires:       perl = %{perlver}
Provides:       %{real_name} = %{version}

%description
Perl module which implements the %{class}::%{subclass} class.

%prep
%setup -q -n %{real_name}-%{version}

%build
%{__perl} Makefile.PL
%{__make} OPTIMIZE="$RPM_OPT_FLAGS"

%install
rm -rf $RPM_BUILD_ROOT
%{makeinstall} PREFIX=$RPM_BUILD_ROOT%{_prefix}
[ -x /usr/lib/rpm/brp-compress ] && /usr/lib/rpm/brp-compress
# Clean up some files we don't want/need
rm -rf `find $RPM_BUILD_ROOT -name "perllocal.pod" -o -name ".packlist" -o -name "*.bs"`
find $RPM_BUILD_ROOT%{_prefix} -type d | tac | xargs rmdir --ign

%clean
rm -rf $RPM_BUILD_ROOT
HERE=`pwd`
cd ..
rm -rf $HERE

%files
%defattr(-,root,root)
%doc README Changes TODO contrib demo
%{_prefix}

%changelog
* Thu Nov 07 2002 Rob Brown <bbb@cpan.org>
- Version 0.30
* Fri Apr 20 2001 Rob Brown <bbb@cpan.org>
- Force man3 path to work with RH6.1 MakeMaker
* Wed Apr 18 2001 Kenneth Porter <shiva@well.com>
- (Date submitted - Sat Mar 03 2001)
- Add anti-root-clobberage to clean.
- Add contrib and demo to doc directory.
* Thu Mar 29 2001 Rob Brown <bbb@cpan.org>
- Generalize files more
* Wed Feb 07 2001 Rob Brown <bbb@cpan.org>
- Initial rpm
