#!/usr/bin/perl
use Test::More tests => 59;
use PostScript::Graph::Paper 0.08;
ok(1, 'PostScript::Graph::Paper loaded');

my $gp = new PostScript::Graph::Paper();
ok($gp, 'PostScript::Graph::Paper created');
is($gp->layout_left_edge(), 37, 'layout_left_edge');
is($gp->layout_bottom_edge(), 37, 'layout_bottom_edge');
is($gp->layout_right_edge(), 558.27559, 'layout_right_edge');
is($gp->layout_top_edge(), 804.88976, 'layout_top_edge');
is($gp->layout_right_margin(), 15, 'layout_right_margin');
is($gp->layout_top_margin(), 5, 'layout_top_margin');
is($gp->layout_spacing(), 0, 'layout_spacing');
is($gp->layout_dots_per_inch(), 300, 'layout_dots_per_inch');
is($gp->layout_heading(), '', 'layout_heading');
is($gp->layout_heading_height(), 27, 'layout_heading_height');
is($gp->layout_key_width(), 0, 'layout_key_width');
is($gp->layout_background(), 1, 'layout_background');
is($gp->layout_color(), 0.5, 'layout_color');
is($gp->layout_heavy_color(), 0.5, 'layout_heavy_color');
is($gp->layout_mid_color(), 0.5, 'layout_mid_color');
is($gp->layout_light_color(), 0.5, 'layout_light_color');
is($gp->layout_heavy_width(), 0.75, 'layout_heavy_width');
is($gp->layout_mid_width(), 0.5, 'layout_mid_width');
is($gp->layout_light_width(), 0.25, 'layout_light_width');
is($gp->layout_font(), 'Helvetica', 'layout_font');
is($gp->layout_font_size(), 10, 'layout_font_size');
is($gp->layout_font_color(), 0, 'layout_font_color');
is($gp->layout_heading_font(), 'Helvetica-Bold', 'layout_heading_font');
is($gp->layout_heading_font_size(), 12, 'layout_heading_font_size');
is($gp->layout_heading_font_color(), 0, 'layout_heading_font_color');
is($gp->x_axis_low(), 0, 'x_axis_low');
is($gp->x_axis_high(), 100, 'x_axis_high');
is($gp->x_axis_width(), 475.27559, 'x_axis_width');
is($gp->x_axis_height(), 33, 'x_axis_height');
is($gp->x_axis_label_gap(), 30, 'x_axis_label_gap');
is($gp->x_axis_smallest(), 0.72, 'x_axis_smallest');
is($gp->x_axis_title(), '', 'x_axis_title');
is($gp->x_axis_font(), 'Helvetica', 'x_axis_font');
is($gp->x_axis_font_color(), 0, 'x_axis_font_color');
is($gp->x_axis_font_size(), 10, 'x_axis_font_size');
is($gp->x_axis_mark_min(), 0.5, 'x_axis_mark_min');
is($gp->x_axis_mark_max(), 8, 'x_axis_mark_max');
is($gp->x_axis_labels_req(), 15, 'x_axis_labels_req');
is($gp->x_axis_rotate(), '', 'x_axis_rotate');
is($gp->x_axis_center(), '', 'x_axis_center');
is($gp->x_axis_show_lines(), '1', 'x_axis_show_lines');
is($gp->y_axis_low(), 0, 'y_axis_low');
is($gp->y_axis_high(), 100, 'y_axis_high');
is($gp->y_axis_width(), 30, 'y_axis_width');
is($gp->y_axis_height(), 767.88976, 'y_axis_height');
is($gp->y_axis_label_gap(), 30, 'y_axis_label_gap');
is($gp->y_axis_smallest(), 0.72, 'y_axis_smallest');
is($gp->y_axis_title(), '', 'y_axis_title');
is($gp->y_axis_font(), 'Helvetica', 'y_axis_font');
is($gp->y_axis_font_color(), 0, 'y_axis_font_color');
is($gp->y_axis_font_size(), 10, 'y_axis_font_size');
is($gp->y_axis_mark_min(), 0.5, 'y_axis_mark_min');
is($gp->y_axis_mark_max(), 8, 'y_axis_mark_max');
is($gp->y_axis_labels_req(), 23, 'y_axis_labels_req');
is($gp->y_axis_rotate(), '', 'y_axis_rotate');
is($gp->y_axis_center(), '', 'y_axis_center');
is($gp->y_axis_show_lines(), '1', 'y_axis_show_lines');
