# vi: syntax=bash:ts=4:sw=4:et
#!/usr/bin/env bash

VERSION=$(cat dist.ini | grep -w version | cut -d' ' -f3)
MINOR_VERSION=$(echo $VERSION | cut -d'.' -f2)
DEVELOPER_RELEASE=$((($MINOR_VERSION % 2 != 0)))
NAME="DBIx-Squirrel"
ARTEFACT="${NAME}-${VERSION}.tar.gz"
FOLDER="${NAME}-${VERSION}"

dzil clean &&
    dzil build || exit $?
dzil cover --outputdir ../cover_db

sleep 2

cd "${FOLDER}"
perl Makefile.PL
cd -
cp "${FOLDER}/cpanfile" ./
cp "${FOLDER}/Makefile.PL" ./
cp "${FOLDER}/MYMETA.yml" ./
cp "${FOLDER}/MYMETA.json" ./

pod2markdown lib/DBIx/Squirrel.pod >docs/POD/README.md

if [ $DEVELOPER_RELEASE -eq 1 ]; then
    dzil release --trial
else
    dzil release
fi
