# NAME

Task::Cpanel::Core - This module provides a spec of packages needed to operate a __cPanel & WHM__ system.

# SYNOPSIS

    cpan Task::Cpanel::Core

# DESCRIPTION

This package includes all of the needed CPAN to run a __cPanel & WHM__ system.

The first two numbers of this version (eg: 11.36) refer to the major version of __cPanel & WHM__ system.  which it applies to.

## MODULES REQUIRED

- [Acme::Spork](http://search.cpan.org/perldoc?Acme::Spork)

Perl extension for spork()ing in your script

- [Archive::Tar](http://search.cpan.org/perldoc?Archive::Tar)

module for manipulations of tar archives

- [Archive::Tar::Streamed](http://search.cpan.org/perldoc?Archive::Tar::Streamed)

Tar archives, non memory resident

- [Archive::Zip](http://search.cpan.org/perldoc?Archive::Zip)

Provide an interface to ZIP archive files.

- [Authen::Libwrap](http://search.cpan.org/perldoc?Authen::Libwrap)

access to Wietse Venema's TCP Wrappers library

- [BSD::Resource](http://search.cpan.org/perldoc?BSD::Resource)

BSD process resource limit and priority functions

- [Business::OnlinePayment::AuthorizeNet](http://search.cpan.org/perldoc?Business::OnlinePayment::AuthorizeNet)

AuthorizeNet backend for Business::OnlinePayment

- [Business::UPS](http://search.cpan.org/perldoc?Business::UPS)

A UPS Interface Module

- [CDB\_File](http://search.cpan.org/perldoc?CDB\_File)

Perl extension for access to cdb databases

- [CGI](http://search.cpan.org/perldoc?CGI)

Handle Common Gateway Interface requests and responses

- [CPAN](http://search.cpan.org/perldoc?CPAN)

query, download and build perl modules from CPAN sites

- [CPAN::SQLite](http://search.cpan.org/perldoc?CPAN::SQLite)

maintain and search a minimal CPAN database

- [Class::Accessor::Fast](http://search.cpan.org/perldoc?Class::Accessor::Fast)

Faster, but less expandable, accessors

- [Class::Std](http://search.cpan.org/perldoc?Class::Std)

Support for creating standard "inside-out" classes

- [Compress::Bzip2](http://search.cpan.org/perldoc?Compress::Bzip2)

Interface to Bzip2 compression library

- [Compress::Raw::Zlib](http://search.cpan.org/perldoc?Compress::Raw::Zlib)

Low-Level Interface to zlib compression library

- [Compress::Zlib](http://search.cpan.org/perldoc?Compress::Zlib)

Interface to zlib compression library

- [Crypt::GPG](http://search.cpan.org/perldoc?Crypt::GPG)

An Object Oriented Interface to GnuPG.

- [Crypt::Passwd::XS](http://search.cpan.org/perldoc?Crypt::Passwd::XS)

Full XS implementation of common crypt() algorithms

- [Crypt::SSLeay](http://search.cpan.org/perldoc?Crypt::SSLeay)

OpenSSL support for LWP

- [Curses](http://search.cpan.org/perldoc?Curses)

terminal screen handling and optimization

- [Curses::UI](http://search.cpan.org/perldoc?Curses::UI)

A curses based OO user interface framework

- [Cwd](http://search.cpan.org/perldoc?Cwd)

get pathname of current working directory

- [DBD::SQLite2](http://search.cpan.org/perldoc?DBD::SQLite2)

Self Contained RDBMS in a DBI Driver (sqlite 2.x)

- [DBD::mysql](http://search.cpan.org/perldoc?DBD::mysql)

MySQL driver for the Perl5 Database Interface (DBI)

- [DBI](http://search.cpan.org/perldoc?DBI)

Database independent interface for Perl

- [DBIx::MyParsePP](http://search.cpan.org/perldoc?DBIx::MyParsePP)

Pure-perl SQL parser based on MySQL grammar and lexer

- [Data::Dump](http://search.cpan.org/perldoc?Data::Dump)

Pretty printing of data structures

- [Data::Dumper](http://search.cpan.org/perldoc?Data::Dumper)

stringified perl data structures, suitable for both printing and eval

- [Date::Parse](http://search.cpan.org/perldoc?Date::Parse)

Parse date strings into time values

- [DateTime](http://search.cpan.org/perldoc?DateTime)

A date and time object

- [DateTime::Locale](http://search.cpan.org/perldoc?DateTime::Locale)

Localization support for DateTime.pm

- [DateTime::TimeZone](http://search.cpan.org/perldoc?DateTime::TimeZone)

Time zone object base class and factory

- [Devel::PPPort](http://search.cpan.org/perldoc?Devel::PPPort)

Perl/Pollution/Portability

- [Digest::MD5](http://search.cpan.org/perldoc?Digest::MD5)

Perl interface to the MD5 Algorithm

- [Digest::MD5::File](http://search.cpan.org/perldoc?Digest::MD5::File)

Perl extension for getting MD5 sums for files and urls.

- [Digest::SHA1](http://search.cpan.org/perldoc?Digest::SHA1)

Perl interface to the SHA-1 algorithm

- [Email::Valid](http://search.cpan.org/perldoc?Email::Valid)

Check validity of Internet email addresses

- [Encode](http://search.cpan.org/perldoc?Encode)

character encodings in Perl

- [Encode::Detect::Detector](http://search.cpan.org/perldoc?Encode::Detect::Detector)

Detects the encoding of data

- [Errno](http://search.cpan.org/perldoc?Errno)

System errno constants

- [ExtUtils::Constant](http://search.cpan.org/perldoc?ExtUtils::Constant)

generate XS code to import C header constants

- [ExtUtils::Install](http://search.cpan.org/perldoc?ExtUtils::Install)

install files from here to there

- [ExtUtils::MakeMaker](http://search.cpan.org/perldoc?ExtUtils::MakeMaker)

Create a module Makefile

- [ExtUtils::ParseXS](http://search.cpan.org/perldoc?ExtUtils::ParseXS)

converts Perl XS code into C code

- [File::Copy::Recursive](http://search.cpan.org/perldoc?File::Copy::Recursive)

Perl extension for recursively copying files and directories

- [File::Find::Rule](http://search.cpan.org/perldoc?File::Find::Rule)

Alternative interface to File::Find

- [File::MMagic::XS](http://search.cpan.org/perldoc?File::MMagic::XS)

Guess File Type With XS (a la mod\_mime\_magic)

- [File::Tail](http://search.cpan.org/perldoc?File::Tail)

Perl extension for reading from continously updated files

- [File::Touch](http://search.cpan.org/perldoc?File::Touch)

update access and modification timestamps, creating nonexistent files where necessary.

- [File::Which](http://search.cpan.org/perldoc?File::Which)

Portable implementation of the \`which&\#39; utility

- [Filesys::Df](http://search.cpan.org/perldoc?Filesys::Df)

Perl extension for filesystem disk space information.

- [Filesys::Statvfs](http://search.cpan.org/perldoc?Filesys::Statvfs)

Perl extension for statvfs() and fstatvfs()

- [Filesys::Virtual](http://search.cpan.org/perldoc?Filesys::Virtual)

Perl extension to provide a framework for a virtual filesystem

- [Filter::Util::Call](http://search.cpan.org/perldoc?Filter::Util::Call)

Perl Source Filter Utility Module

- [GD::Graph](http://search.cpan.org/perldoc?GD::Graph)

Graph Plotting Module for Perl 5

- [GD::Text::Align](http://search.cpan.org/perldoc?GD::Text::Align)

Draw aligned strings

- [Geo::IPfree](http://search.cpan.org/perldoc?Geo::IPfree)

Look up the country of an IPv4 address

- [Getopt::Long](http://search.cpan.org/perldoc?Getopt::Long)

Extended processing of command line options

- [Getopt::Param::Tiny](http://search.cpan.org/perldoc?Getopt::Param::Tiny)

Subset of Getopt::Param functionality with smaller memory footprint

- [Graph::Easy](http://search.cpan.org/perldoc?Graph::Easy)

Convert or render graphs (as ASCII, HTML, SVG or via Graphviz)

- [Graph::Flowchart](http://search.cpan.org/perldoc?Graph::Flowchart)

Generate easily flowcharts as Graph::Easy objects

- [HTML::Parser](http://search.cpan.org/perldoc?HTML::Parser)

HTML parser class

- [HTML::Tagset](http://search.cpan.org/perldoc?HTML::Tagset)

data tables useful in parsing HTML

- [HTML::Template](http://search.cpan.org/perldoc?HTML::Template)

Perl module to use HTML-like templating language

- [HTTP::Daemon::App](http://search.cpan.org/perldoc?HTTP::Daemon::App)

Create 2 or 3 line, fully functional (SSL) HTTP server(s)

- [HTTP::Date](http://search.cpan.org/perldoc?HTTP::Date)

date conversion routines

- [IO::Compress::Gzip](http://search.cpan.org/perldoc?IO::Compress::Gzip)

Write RFC 1952 files/buffers

- [IO::Interactive::Tiny](http://search.cpan.org/perldoc?IO::Interactive::Tiny)

is\_interactive() without large deps

- [IO::Scalar](http://search.cpan.org/perldoc?IO::Scalar)

IO:: interface for reading/writing a scalar

- [IO::Socket::ByteCounter](http://search.cpan.org/perldoc?IO::Socket::ByteCounter)

Perl extension to track the byte sizes of data in and out of a socket

- [IO::Socket::INET6](http://search.cpan.org/perldoc?IO::Socket::INET6)

Object interface for AF\_INET|AF\_INET6 domain sockets

- [IO::Tty](http://search.cpan.org/perldoc?IO::Tty)

Low-level allocate a pseudo-Tty, import constants.

- [IO::Uncompress::Gunzip](http://search.cpan.org/perldoc?IO::Uncompress::Gunzip)

Read RFC 1952 files/buffers

- [IP::Country](http://search.cpan.org/perldoc?IP::Country)

fast lookup of country codes from IP addresses

- [IPC::Pipeline](http://search.cpan.org/perldoc?IPC::Pipeline)

Create a shell-like pipeline of many running commands

- [Image::Size](http://search.cpan.org/perldoc?Image::Size)

read the dimensions of an image in several popular formats

- [JSON::Syck](http://search.cpan.org/perldoc?JSON::Syck)

JSON is YAML (but consider using JSON::XS instead!)

- [LWP::Protocol::https](http://search.cpan.org/perldoc?LWP::Protocol::https)

Provide https support for LWP::UserAgent

- [Lchown](http://search.cpan.org/perldoc?Lchown)

Use the lchown(2) system call from Perl

- [Linux::Inotify2](http://search.cpan.org/perldoc?Linux::Inotify2)

scalable directory/file change notification

- [List::MoreUtils](http://search.cpan.org/perldoc?List::MoreUtils)

Provide the stuff missing in List::Util

- [List::Util](http://search.cpan.org/perldoc?List::Util)

A selection of general-utility list subroutines

- [Locale::Maketext::Utils](http://search.cpan.org/perldoc?Locale::Maketext::Utils)

Adds some utility functionality and failure handling to Local::Maketext handles

- [Locales](http://search.cpan.org/perldoc?Locales)

Methods for getting localized CLDR language/territory names (and a subset of other data)

- [Log::Log4perl](http://search.cpan.org/perldoc?Log::Log4perl)

Log4j implementation for Perl

- [MD5](http://search.cpan.org/perldoc?MD5)

Perl interface to the MD5 Message-Digest Algorithm

- [MIME::Base64](http://search.cpan.org/perldoc?MIME::Base64)

Encoding and decoding of base64 strings

- [MIME::Lite](http://search.cpan.org/perldoc?MIME::Lite)

low-calorie MIME generator

- [Mail::Alias::Reader](http://search.cpan.org/perldoc?Mail::Alias::Reader)

Read aliases(5) and ~/.forward declarations

- [Mail::DKIM](http://search.cpan.org/perldoc?Mail::DKIM)

Signs/verifies Internet mail with DKIM/DomainKey signatures

- [Mail::DomainKeys](http://search.cpan.org/perldoc?Mail::DomainKeys)

A perl implementation of DomainKeys

- [Mail::SPF](http://search.cpan.org/perldoc?Mail::SPF)

An object-oriented implementation of Sender Policy Framework

- [Mail::SRS](http://search.cpan.org/perldoc?Mail::SRS)

Interface to Sender Rewriting Scheme

- [Mail::SpamAssassin](http://search.cpan.org/perldoc?Mail::SpamAssassin)

Spam detector and markup engine

- [Math::Base85](http://search.cpan.org/perldoc?Math::Base85)

Perl extension for base 85 numbers, as referenced by RFC 1924

- [Math::BigFloat](http://search.cpan.org/perldoc?Math::BigFloat)

Arbitrary size floating point math package

- [Math::BigInt](http://search.cpan.org/perldoc?Math::BigInt)

Arbitrary size integer/float math package

- [Memoize](http://search.cpan.org/perldoc?Memoize)

Make functions faster by trading space for time

- [Module::Build](http://search.cpan.org/perldoc?Module::Build)

Build and install Perl modules

- [Net::AIM](http://search.cpan.org/perldoc?Net::AIM)

Perl extension for AOL Instant Messenger TOC protocol

- [Net::DAV::Server](http://search.cpan.org/perldoc?Net::DAV::Server)

Provide a DAV Server

- [Net::DNS](http://search.cpan.org/perldoc?Net::DNS)

Perl interface to the Domain Name System

- [Net::Daemon::SSL](http://search.cpan.org/perldoc?Net::Daemon::SSL)

perl extensions for portable ssl daemons

- [Net::FTP](http://search.cpan.org/perldoc?Net::FTP)

FTP Client class

- [Net::FTPSSL](http://search.cpan.org/perldoc?Net::FTPSSL)

A FTP over SSL/TLS class

- [Net::IP::Match::Regexp](http://search.cpan.org/perldoc?Net::IP::Match::Regexp)

Efficiently match IP addresses against ranges

- [Net::IPv4Addr](http://search.cpan.org/perldoc?Net::IPv4Addr)

Perl extension for manipulating IPv4 addresses.

- [Net::LDAP](http://search.cpan.org/perldoc?Net::LDAP)

Lightweight Directory Access Protocol

- [Net::LDAP::Schema](http://search.cpan.org/perldoc?Net::LDAP::Schema)

Load and manipulate an LDAP v3 Schema

- [Net::LDAP::Server](http://search.cpan.org/perldoc?Net::LDAP::Server)

LDAP server side protocol handling

- [Net::LibIDN](http://search.cpan.org/perldoc?Net::LibIDN)

Perl bindings for GNU Libidn

- [Net::OSCAR](http://search.cpan.org/perldoc?Net::OSCAR)

Implementation of AOL's OSCAR protocol for instant messaging (for interacting with AIM a.k.a. AOL IM a.k.a. AOL Instant Messenger - and ICQ, too!)

- [Net::SNMP](http://search.cpan.org/perldoc?Net::SNMP)

Object oriented interface to SNMP

- [Net::SSL](http://search.cpan.org/perldoc?Net::SSL)

support for Secure Sockets Layer

- [Net::SSLeay](http://search.cpan.org/perldoc?Net::SSLeay)

Perl extension for using OpenSSL

- [Net::Server](http://search.cpan.org/perldoc?Net::Server)

Extensible, general Perl server engine

- [Net::Server::Fork](http://search.cpan.org/perldoc?Net::Server::Fork)

Net::Server personality

- [OLE::Storage\_Lite](http://search.cpan.org/perldoc?OLE::Storage\_Lite)

Simple Class for OLE document interface.

- [Parse::RecDescent](http://search.cpan.org/perldoc?Parse::RecDescent)

Generate Recursive-Descent Parsers

- [Pod::Perldoc](http://search.cpan.org/perldoc?Pod::Perldoc)

Look up Perl documentation in Pod format.

- [Quota](http://search.cpan.org/perldoc?Quota)

Perl interface to file system quotas

- [SQL::Statement](http://search.cpan.org/perldoc?SQL::Statement)

SQL parsing and processing engine

- [SVG::TT::Graph](http://search.cpan.org/perldoc?SVG::TT::Graph)

Base object for generating SVG Graphs

- [Safe::Hole](http://search.cpan.org/perldoc?Safe::Hole)

make a hole to the original main compartment in the Safe compartment

- [Scalar::Util](http://search.cpan.org/perldoc?Scalar::Util)

A selection of general-utility scalar subroutines

- [Set::Crontab](http://search.cpan.org/perldoc?Set::Crontab)

Expand crontab(5)-style integer lists

- [Socket6](http://search.cpan.org/perldoc?Socket6)

IPv6 related part of the C socket.h defines and structure manipulators

- [Spreadsheet::ParseExcel](http://search.cpan.org/perldoc?Spreadsheet::ParseExcel)

Read information from an Excel file.

- [Spreadsheet::WriteExcel](http://search.cpan.org/perldoc?Spreadsheet::WriteExcel)

Write to a cross-platform Excel binary file.

- [Storable](http://search.cpan.org/perldoc?Storable)

persistence for Perl data structures

- [String::CRC32](http://search.cpan.org/perldoc?String::CRC32)

Perl interface for cyclic redundency check generation

- [Sys::Hostname::Long](http://search.cpan.org/perldoc?Sys::Hostname::Long)

Try every conceivable way to get full hostname

- [Sys::Mmap](http://search.cpan.org/perldoc?Sys::Mmap)

uses mmap to map in a file as a Perl variable

- [Sys::Syslog](http://search.cpan.org/perldoc?Sys::Syslog)

Perl interface to the UNIX syslog(3) calls

- [Term::ReadKey](http://search.cpan.org/perldoc?Term::ReadKey)

A perl module for simple terminal control

- [TAP::Harness](http://search.cpan.org/perldoc?TAP::Harness)

Run test scripts with statistics

- [Template](http://search.cpan.org/perldoc?Template)

Template Toolkit Processing System

- [Text::CSV](http://search.cpan.org/perldoc?Text::CSV)

comma-separated values manipulator (using XS or PurePerl)

- [Text::Query](http://search.cpan.org/perldoc?Text::Query)

Query processing framework

- [Tie::DBI](http://search.cpan.org/perldoc?Tie::DBI)

Tie hashes to DBI relational databases

- [Tie::IxHash](http://search.cpan.org/perldoc?Tie::IxHash)

ordered associative arrays for Perl

- [Tie::ShadowHash](http://search.cpan.org/perldoc?Tie::ShadowHash)

Merge multiple data sources into a hash

- [Time::HiRes](http://search.cpan.org/perldoc?Time::HiRes)

High resolution alarm, sleep, gettimeofday, interval timers

- [Tree::MultiNode](http://search.cpan.org/perldoc?Tree::MultiNode)

A multi-node tree object. Most useful for modeling hierarchical data structures.

- [URI](http://search.cpan.org/perldoc?URI)

Uniform Resource Identifiers (absolute and relative)

- [URI::Escape](http://search.cpan.org/perldoc?URI::Escape)

Percent-encode and percent-decode unsafe characters

- [URI::URL](http://search.cpan.org/perldoc?URI::URL)

Uniform Resource Locators

- [Unix::PID](http://search.cpan.org/perldoc?Unix::PID)

Perl extension for getting PID info.

- [Unix::PID::Tiny](http://search.cpan.org/perldoc?Unix::PID::Tiny)

Subset of Unix::PID functionality with smaller memory footprint

- [XML::LibXML](http://search.cpan.org/perldoc?XML::LibXML)

Perl Binding for libxml2

- [XML::LibXML::Common](http://search.cpan.org/perldoc?XML::LibXML::Common)

Constants and Character Encoding Routines

- [XML::LibXML::Error](http://search.cpan.org/perldoc?XML::LibXML::Error)

Structured Errors

- [XML::Parser](http://search.cpan.org/perldoc?XML::Parser)

A perl module for parsing XML documents

- [XML::SAX](http://search.cpan.org/perldoc?XML::SAX)

Simple API for XML

- [XML::SAX::Expat](http://search.cpan.org/perldoc?XML::SAX::Expat)

SAX2 Driver for Expat (XML::Parser)

- [XML::Simple](http://search.cpan.org/perldoc?XML::Simple)

Easy API to maintain XML (esp config files)

- [YAML::Syck](http://search.cpan.org/perldoc?YAML::Syck)

Fast, lightweight YAML loader and dumper

- [cPanel::MemTest](http://search.cpan.org/perldoc?cPanel::MemTest)

Test Memory Allocation

- [lib::restrict](http://search.cpan.org/perldoc?lib::restrict)

Perl extension for restricting what goes into @INC

- [local::lib](http://search.cpan.org/perldoc?local::lib)

create and use a local lib/ for perl modules with PERL5LIB

# AUTHOR

cPanel, `<cpanel at cpan.org>`

# BUGS

Please report any bugs or feature requests to `bug-task-cpanel-core at rt.cpan.org`, or through
the web interface at [http://rt.cpan.org/NoAuth/ReportBug.html?Queue=Task-Cpanel-Core](http://rt.cpan.org/NoAuth/ReportBug.html?Queue=Task-Cpanel-Core).  We will be notified, and then you'll
automatically be notified of progress on your bug as we make changes.

# SUPPORT

You can find documentation for this module with the perldoc command.

    perldoc Task::Cpanel::Core



You can also look for information at:

- RT: CPAN's request tracker (report bugs here)

[http://rt.cpan.org/NoAuth/Bugs.html?Dist=Task-Cpanel-Core](http://rt.cpan.org/NoAuth/Bugs.html?Dist=Task-Cpanel-Core)

- AnnoCPAN: Annotated CPAN documentation

[http://annocpan.org/dist/Task-Cpanel-Core](http://annocpan.org/dist/Task-Cpanel-Core)

- CPAN Ratings

[http://cpanratings.perl.org/d/Task-Cpanel-Core](http://cpanratings.perl.org/d/Task-Cpanel-Core)

- Meta CPAN

[http://metacpan.org/module/Task-Cpanel-Core/](http://metacpan.org/module/Task-Cpanel-Core/)



# LICENSE AND COPYRIGHT

Copyright 2012 cPanel.

All rights reserved

http://cpanel.net

This is free software; you can redistribute it and/or modify it under the
same terms as Perl itself. See [perlartistic](http://search.cpan.org/perldoc?perlartistic).

See http://dev.perl.org/licenses/ for more information.


