
use strict;
use warnings;



use ExtUtils::MakeMaker 6.30;



my %WriteMakefileArgs = (
  "ABSTRACT" => "This module provides a spec of packages needed to operate a B<cPanel & WHM> system.",
  "AUTHOR" => "cPanel <cpanel\@cpan.org>",
  "BUILD_REQUIRES" => {
    "FindBin" => 0,
    "Test::More" => 0
  },
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker" => "6.30"
  },
  "DISTNAME" => "Task-Cpanel-Core",
  "EXE_FILES" => [],
  "LICENSE" => "perl",
  "NAME" => "Task::Cpanel::Core",
  "PREREQ_PM" => {
    "Acme::Spork" => 0,
    "Archive::Tar" => 0,
    "Archive::Tar::Streamed" => 0,
    "Archive::Zip" => 0,
    "Authen::Libwrap" => 0,
    "BSD::Resource" => 0,
    "Business::OnlinePayment::AuthorizeNet" => 0,
    "Business::UPS" => 0,
    "CDB_File" => 0,
    "CGI" => 0,
    "CPAN" => 0,
    "CPAN::SQLite" => 0,
    "Class::Accessor::Fast" => 0,
    "Class::Std" => 0,
    "Compress::Bzip2" => 0,
    "Compress::Raw::Zlib" => 0,
    "Compress::Zlib" => 0,
    "Crypt::GPG" => 0,
    "Crypt::Passwd::XS" => 0,
    "Crypt::SSLeay" => 0,
    "Curses" => 0,
    "Curses::UI" => 0,
    "Cwd" => 0,
    "DBD::SQLite2" => 0,
    "DBD::mysql" => 0,
    "DBI" => 0,
    "DBIx::MyParsePP" => 0,
    "Data::Dump" => 0,
    "Data::Dumper" => 0,
    "Date::Parse" => 0,
    "DateTime" => 0,
    "DateTime::Locale" => 0,
    "DateTime::TimeZone" => 0,
    "Devel::PPPort" => 0,
    "Digest::MD5" => 0,
    "Digest::MD5::File" => 0,
    "Digest::SHA1" => 0,
    "Email::Valid" => 0,
    "Encode" => 0,
    "Encode::Detect::Detector" => 0,
    "Errno" => 0,
    "ExtUtils::Constant" => 0,
    "ExtUtils::Install" => 0,
    "ExtUtils::MakeMaker" => 0,
    "ExtUtils::ParseXS" => 0,
    "File::Copy::Recursive" => 0,
    "File::Find::Rule" => 0,
    "File::MMagic::XS" => 0,
    "File::Tail" => 0,
    "File::Touch" => 0,
    "File::Which" => 0,
    "Filesys::Df" => 0,
    "Filesys::Statvfs" => 0,
    "Filesys::Virtual" => 0,
    "Filter::Util::Call" => 0,
    "GD::Graph" => 0,
    "GD::Text::Align" => 0,
    "Geo::IPfree" => 0,
    "Getopt::Long" => 0,
    "Getopt::Param::Tiny" => 0,
    "Graph::Easy" => 0,
    "Graph::Flowchart" => 0,
    "HTML::Parser" => 0,
    "HTML::Tagset" => 0,
    "HTML::Template" => 0,
    "HTTP::Daemon::App" => 0,
    "HTTP::Date" => 0,
    "IO::Compress::Gzip" => 0,
    "IO::Interactive::Tiny" => 0,
    "IO::Scalar" => 0,
    "IO::Socket::ByteCounter" => 0,
    "IO::Socket::INET6" => 0,
    "IO::Tty" => 0,
    "IO::Uncompress::Gunzip" => 0,
    "IP::Country" => 0,
    "IPC::Pipeline" => 0,
    "Image::Size" => 0,
    "JSON::Syck" => 0,
    "LWP::Protocol::https" => 0,
    "Lchown" => 0,
    "Linux::Inotify2" => 0,
    "List::MoreUtils" => 0,
    "List::Util" => 0,
    "Locale::Maketext::Utils" => 0,
    "Locales" => 0,
    "Log::Log4perl" => 0,
    "MD5" => 0,
    "MIME::Base64" => 0,
    "MIME::Lite" => 0,
    "Mail::Alias::Reader" => 0,
    "Mail::DKIM" => 0,
    "Mail::DomainKeys" => 0,
    "Mail::SPF" => 0,
    "Mail::SRS" => 0,
    "Mail::SpamAssassin" => 0,
    "Math::Base85" => 0,
    "Math::BigFloat" => 0,
    "Math::BigInt" => 0,
    "Memoize" => 0,
    "Module::Build" => 0,
    "Net::AIM" => 0,
    "Net::DAV::Server" => 0,
    "Net::DNS" => 0,
    "Net::Daemon::SSL" => 0,
    "Net::FTP" => 0,
    "Net::FTPSSL" => 0,
    "Net::IP::Match::Regexp" => 0,
    "Net::IPv4Addr" => 0,
    "Net::LDAP" => 0,
    "Net::LDAP::Schema" => 0,
    "Net::LDAP::Server" => 0,
    "Net::LibIDN" => 0,
    "Net::OSCAR" => 0,
    "Net::SNMP" => 0,
    "Net::SSL" => 0,
    "Net::SSLeay" => 0,
    "Net::Server" => 0,
    "Net::Server::Fork" => 0,
    "OLE::Storage_Lite" => 0,
    "Parse::RecDescent" => 0,
    "Pod::Perldoc" => 0,
    "Quota" => 0,
    "SQL::Statement" => 0,
    "SVG::TT::Graph" => 0,
    "Safe::Hole" => 0,
    "Scalar::Util" => 0,
    "Set::Crontab" => 0,
    "Socket6" => 0,
    "Spreadsheet::ParseExcel" => 0,
    "Spreadsheet::WriteExcel" => 0,
    "Storable" => 0,
    "String::CRC32" => 0,
    "Sys::Hostname::Long" => 0,
    "Sys::Mmap" => 0,
    "Sys::Syslog" => 0,
    "TAP::Harness" => 0,
    "Template" => 0,
    "Term::ReadKey" => 0,
    "Text::CSV" => 0,
    "Tie::DBI" => 0,
    "Tie::IxHash" => 0,
    "Tie::ShadowHash" => 0,
    "Time::HiRes" => 0,
    "Tree::MultiNode" => 0,
    "URI" => 0,
    "URI::Escape" => 0,
    "URI::URL" => 0,
    "Unix::PID" => 0,
    "Unix::PID::Tiny" => 0,
    "XML::LibXML" => 0,
    "XML::LibXML::Common" => 0,
    "XML::LibXML::Error" => 0,
    "XML::Parser" => 0,
    "XML::SAX" => 0,
    "XML::SAX::Expat" => 0,
    "XML::Simple" => 0,
    "YAML::Syck" => 0,
    "cPanel::MemTest" => 0,
    "lib::restrict" => 0,
    "local::lib" => 0,
    "strict" => 0,
    "warnings" => 0
  },
  "VERSION" => "11.36.002",
  "test" => {
    "TESTS" => "t/*.t"
  }
);


unless ( eval { ExtUtils::MakeMaker->VERSION(6.56) } ) {
  my $br = delete $WriteMakefileArgs{BUILD_REQUIRES};
  my $pp = $WriteMakefileArgs{PREREQ_PM};
  for my $mod ( keys %$br ) {
    if ( exists $pp->{$mod} ) {
      $pp->{$mod} = $br->{$mod} if $br->{$mod} > $pp->{$mod};
    }
    else {
      $pp->{$mod} = $br->{$mod};
    }
  }
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);



