use strict;

${Lingua::Identify::languages{_versions}{fy}} = '0.01';

${Lingua::Identify::languages{_names}{fy}} = 'frisian';

=head1 NAME

Lingua::Identify::PT - Meta-information on the Frisian natural language.

=head1 SYNOPSIS

Nothing here is meant for public comsuption. This module is to be loaded by
Lingua::Identify.

=head1 DESCRIPTION

Automatically generated. Do not change this module yourself (yet).

=head1 SEE ALSO

Lingua::Identify(3).

=head1 AUTHOR

Jose Alves de Castro, E<lt>cog@cpan.orgE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2004 by Jose Alves de Castro

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.8.4 or,
at your option, any later version of Perl 5 you may have available.

=cut

${Lingua::Identify::languages{prefixes1}{fy}} = {
  'd'	=> 0.1001221001221,
  'f'	=> 0.072039072039072,
  's'	=> 0.0683760683760684,
  'w'	=> 0.0659340659340659,
  'i'	=> 0.0634920634920635,
  'e'	=> 0.0525030525030525,
  'o'	=> 0.0476190476190476,
  'b'	=> 0.0427350427350427,
  'h'	=> 0.0427350427350427,
  'n'	=> 0.0427350427350427,
  't'	=> 0.0366300366300366,
  'm'	=> 0.0341880341880342,
  'k'	=> 0.0293040293040293,
  'y'	=> 0.0268620268620269,
  'a'	=> 0.0244200244200244,
  'p'	=> 0.0207570207570208,
  'l'	=> 0.0195360195360195,
  'r'	=> 0.0170940170940171,
  'g'	=> 0.0158730158730159,
  'F'	=> 0.0146520146520147,
};

${Lingua::Identify::languages{prefixes2}{fy}} = {
  'fa'	=> 0.0324232081911263,
  'fo'	=> 0.0307167235494881,
  'ha'	=> 0.0290102389078498,
  'be'	=> 0.0290102389078498,
  'da'	=> 0.0255972696245734,
  'ne'	=> 0.0238907849829352,
  'wa'	=> 0.0238907849829352,
  'fe'	=> 0.0221843003412969,
  'we'	=> 0.0204778156996587,
  'me'	=> 0.0187713310580205,
  'de'	=> 0.0187713310580205,
  'ma'	=> 0.0170648464163823,
  'oa'	=> 0.0170648464163823,
  'Fr'	=> 0.0170648464163823,
  'tr'	=> 0.015358361774744,
  'se'	=> 0.015358361774744,
  'hi'	=> 0.0136518771331058,
  'wu'	=> 0.0136518771331058,
  'wi'	=> 0.0136518771331058,
  'sk'	=> 0.0136518771331058,
};

${Lingua::Identify::languages{prefixes3}{fy}} = {
  'fer'	=> 0.0292682926829268,
  'foa'	=> 0.0268292682926829,
  'Fry'	=> 0.0195121951219512,
  'wur'	=> 0.0195121951219512,
  'bin'	=> 0.0146341463414634,
  'fol'	=> 0.0146341463414634,
  'all'	=> 0.0121951219512195,
  'bes'	=> 0.0121951219512195,
  'tro'	=> 0.0121951219512195,
  'skr'	=> 0.00975609756097561,
  'sel'	=> 0.00975609756097561,
  'bet'	=> 0.00975609756097561,
  'waa'	=> 0.00731707317073171,
  'kin'	=> 0.00731707317073171,
  'wes'	=> 0.00731707317073171,
  'Ams'	=> 0.00731707317073171,
  'Tri'	=> 0.00731707317073171,
  'sei'	=> 0.00731707317073171,
  'pro'	=> 0.00731707317073171,
  'haw'	=> 0.00731707317073171,
};

${Lingua::Identify::languages{prefixes4}{fy}} = {
  'Frys'	=> 0.0253164556962025,
  'binn'	=> 0.0189873417721519,
  'wurd'	=> 0.0158227848101266,
  'fers'	=> 0.0126582278481013,
  'troc'	=> 0.0126582278481013,
  'haww'	=> 0.00949367088607595,
  'mins'	=> 0.00949367088607595,
  'bets'	=> 0.00949367088607595,
  'nder'	=> 0.00949367088607595,
  'foar'	=> 0.00949367088607595,
  'tusk'	=> 0.00949367088607595,
  'doch'	=> 0.00949367088607595,
  'waar'	=> 0.00949367088607595,
  'folw'	=> 0.00949367088607595,
  'skri'	=> 0.00949367088607595,
  'best'	=> 0.00949367088607595,
  'Amst'	=> 0.00949367088607595,
  'groe'	=> 0.00632911392405063,
  'Bewe'	=> 0.00632911392405063,
  'doel'	=> 0.00632911392405063,
};

${Lingua::Identify::languages{suffixes1}{fy}} = {
  'n'	=> 0.242979242979243,
  'e'	=> 0.19047619047619,
  't'	=> 0.152625152625153,
  'r'	=> 0.0683760683760684,
  's'	=> 0.0647130647130647,
  'k'	=> 0.0341880341880342,
  'p'	=> 0.0317460317460317,
  'l'	=> 0.0293040293040293,
  'y'	=> 0.0268620268620269,
  'i'	=> 0.0268620268620269,
  'm'	=> 0.0244200244200244,
  'h'	=> 0.0207570207570208,
  'a'	=> 0.0134310134310134,
  'd'	=> 0.0134310134310134,
  'f'	=> 0.00976800976800977,
  'u'	=> 0.00854700854700855,
  'g'	=> 0.00854700854700855,
  'o'	=> 0.00732600732600733,
  '2'	=> 0.00366300366300366,
  'j'	=> 0.00244200244200244,
};

${Lingua::Identify::languages{suffixes2}{fy}} = {
  'en'	=> 0.13481228668942,
  'an'	=> 0.0614334470989761,
  'at'	=> 0.0563139931740614,
  'er'	=> 0.052901023890785,
  'ei'	=> 0.0358361774744027,
  'et'	=> 0.0324232081911263,
  'ar'	=> 0.0307167235494881,
  'je'	=> 0.0273037542662116,
  'st'	=> 0.0238907849829352,
  'le'	=> 0.0221843003412969,
  'ch'	=> 0.0204778156996587,
  'de'	=> 0.0204778156996587,
  'ke'	=> 0.0187713310580205,
  'ne'	=> 0.0170648464163823,
  'nt'	=> 0.0170648464163823,
  'es'	=> 0.0170648464163823,
  're'	=> 0.0170648464163823,
  'yn'	=> 0.0136518771331058,
  'ht'	=> 0.0119453924914676,
  'ng'	=> 0.0119453924914676,
};

${Lingua::Identify::languages{suffixes3}{fy}} = {
  'den'	=> 0.024390243902439,
  'lle'	=> 0.024390243902439,
  'nne'	=> 0.0219512195121951,
  'ske'	=> 0.0219512195121951,
  'ken'	=> 0.0219512195121951,
  'oar'	=> 0.0219512195121951,
  'cht'	=> 0.0170731707317073,
  'ten'	=> 0.0170731707317073,
  'jen'	=> 0.0146341463414634,
  'sje'	=> 0.0146341463414634,
  'ant'	=> 0.0146341463414634,
  'gen'	=> 0.0146341463414634,
  'nen'	=> 0.0146341463414634,
  'ing'	=> 0.0146341463414634,
  'ren'	=> 0.0121951219512195,
  'men'	=> 0.0121951219512195,
  'och'	=> 0.0121951219512195,
  'ers'	=> 0.0121951219512195,
  'est'	=> 0.00975609756097561,
  'ije'	=> 0.00975609756097561,
};

${Lingua::Identify::languages{suffixes4}{fy}} = {
  'inne'	=> 0.0284810126582278,
  'yske'	=> 0.0189873417721519,
  'sken'	=> 0.0158227848101266,
  'ocht'	=> 0.0158227848101266,
  'lden'	=> 0.0158227848101266,
  'rren'	=> 0.0126582278481013,
  'enen'	=> 0.0126582278481013,
  'awwe'	=> 0.00949367088607595,
  'utte'	=> 0.00949367088607595,
  'tter'	=> 0.00949367088607595,
  'aard'	=> 0.00949367088607595,
  'rdam'	=> 0.00949367088607595,
  'urde'	=> 0.00949367088607595,
  'rije'	=> 0.00949367088607595,
  'ngen'	=> 0.00949367088607595,
  'eden'	=> 0.00949367088607595,
  'sjes'	=> 0.00949367088607595,
  'ters'	=> 0.00949367088607595,
  'roep'	=> 0.00949367088607595,
  'mmen'	=> 0.00949367088607595,
};

${Lingua::Identify::languages{smallwords}{fy}} = {
  'de'	=> 0.0475609756097561,
  'en'	=> 0.0317073170731707,
  'in'	=> 0.025609756097561,
  'yn'	=> 0.0231707317073171,
  'it'	=> 0.0231707317073171,
  'fan'	=> 0.0219512195121951,
  'dat'	=> 0.0182926829268293,
  'op'	=> 0.0182926829268293,
  'mei'	=> 0.0134146341463415,
  'wat'	=> 0.0121951219512195,
  'ek'	=> 0.0109756097560976,
  'der'	=> 0.0109756097560976,
  'net'	=> 0.0109756097560976,
  'is'	=> 0.00975609756097561,
  'foar'	=> 0.00975609756097561,
  'hat'	=> 0.00853658536585366,
  'oan'	=> 0.00853658536585366,
  'syn'	=> 0.00853658536585366,
  'alle'	=> 0.00731707317073171,
  'wer'	=> 0.00731707317073171,
};

${Lingua::Identify::languages{ngrams1}{fy}} = {
  ' ' => 0.339058073654391,
  'e' => 0.106409348441926,
  'n' => 0.0619688385269122,
  't' => 0.0490439093484419,
  'a' => 0.0472733711048159,
  'i' => 0.0439093484419263,
  'r' => 0.0435552407932011,
  's' => 0.0423158640226629,
  'o' => 0.0325779036827195,
  'd' => 0.0308073654390935,
  'k' => 0.0254957507082153,
  'l' => 0.0254957507082153,
  'm' => 0.0180594900849858,
  'f' => 0.017528328611898,
  'y' => 0.0155807365439093,
  'h' => 0.0155807365439093,
  'w' => 0.0150495750708215,
  'p' => 0.0146954674220963,
  'u' => 0.0132790368271955,
  'j' => 0.0123937677053824,
};

${Lingua::Identify::languages{ngrams2}{fy}} = {
  'n ' => 0.04227710339054,
  '  ' => 0.0389284219338635,
  'e ' => 0.0336961071578066,
  't ' => 0.0282544997907074,
  'en' => 0.0261615738802846,
  ' d' => 0.0209292591042277,
  'er' => 0.0186270406027627,
  'de' => 0.0184177480117204,
  ' f' => 0.0154876517371285,
  ' s' => 0.0148597739640017,
  'in' => 0.0129761406446212,
  ' w' => 0.0127668480535789,
  ' i' => 0.0127668480535789,
  's ' => 0.0127668480535789,
  'r ' => 0.0125575554625366,
  ' e' => 0.0108832147341984,
  'an' => 0.0108832147341984,
  'te' => 0.0108832147341984,
  'ar' => 0.00941816659690247,
  ' o' => 0.00941816659690247,
};

${Lingua::Identify::languages{ngrams3}{fy}} = {
  'en ' => 0.0271238485158649,
  'de ' => 0.013050153531218,
  ' de' => 0.013050153531218,
  'an ' => 0.00921187308085977,
  'at ' => 0.00844421699078813,
  'er ' => 0.00793244626407369,
  'yn ' => 0.00690890481064483,
  'in ' => 0.00690890481064483,
  ' en' => 0.00665301944728762,
  'it ' => 0.0063971340839304,
  '  d' => 0.00614124872057318,
  ' yn' => 0.00588536335721597,
  ' in' => 0.00562947799385875,
  'ei ' => 0.00537359263050154,
  ' fa' => 0.00511770726714432,
  ' be' => 0.00511770726714432,
  ' it' => 0.00511770726714432,
  'op ' => 0.0048618219037871,
  'ter' => 0.0048618219037871,
  ' ha' => 0.0048618219037871,
};

${Lingua::Identify::languages{ngrams4}{fy}} = {
  ' de ' => 0.0128373930217248,
  ' en ' => 0.00855826201448321,
  ' in ' => 0.00691244239631336,
  ' it ' => 0.00625411454904542,
  ' yn ' => 0.00625411454904542,
  'fan ' => 0.00592495062541146,
  ' fan' => 0.00592495062541146,
  ' op ' => 0.00526662277814352,
  ' dat' => 0.00493745885450955,
  'dat ' => 0.00493745885450955,
  'mei ' => 0.00427913100724161,
  ' mei' => 0.00394996708360764,
  'der ' => 0.00394996708360764,
  ' fer' => 0.00394996708360764,
  'den ' => 0.00362080315997367,
  ' foa' => 0.00362080315997367,
  'net ' => 0.00362080315997367,
  'foar' => 0.00362080315997367,
  'lle ' => 0.0032916392363397,
  ' wat' => 0.0032916392363397,
};
