# Copyright (C) 2006-2008, The Perl Foundation.
# $Id: /mirror/trunk/languages/WMLScript/wmls2pir.pir 32679 2008-11-14T21:43:51.902804Z fperrad  $

=head1 NAME

wmls2pir - WMLScript bytecode to Parrot PIR Translator

=head1 SYNOPSYS

 parrot wmls2pir.pir file.wmlsc

=head1 DESCRIPTION

B<wmls2pir> translates a WMLScript bytecode file to Parrot PIR.

=head1 SEE ALSO

wmlsd, wmls2pbc, wmlsi

=cut

.loadlib 'wmls_ops'
.HLL 'WMLScript', 'wmls_group'

.sub 'main' :main
    .param pmc argv
    load_bytecode 'languages/WMLScript/src/WMLScript.pbc'
    .local int argc
    .local string progname
    .local string filename
    .local string content
    argc = elements argv
    if argc != 2 goto USAGE
    progname = shift argv
    filename = shift argv
    content = load_script(filename)
    unless content goto L1
    .local pmc loader
    .local pmc script
    new loader, 'WmlsBytecode'
    push_eh _handler
    script = loader.'load'(content)
    script['filename'] = filename
    .local string gen_pir
    gen_pir = script.'translate'()
    save_pir(gen_pir, filename)
    end
  _handler:
    .local pmc e
    .local string s
    .get_results (e)
    s = e
    print s
    print "\n"
  L1:
    end
  USAGE:
    printerr "Usage: parrot wmls2pir.pbc filename\n"
    exit -1
.end


# Local Variables:
#   mode: pir
#   fill-column: 100
# End:
# vim: expandtab shiftwidth=4 ft=pir:
