/* register.h
 *  Copyright (C) 2001-2008, The Perl Foundation.
 *  SVN Info
 *     $Id: /mirror/trunk/include/parrot/register.h 27459 2008-05-12T02:15:12.435938Z petdance  $
 *  Overview:
 *     Defines the register api
 *  Data Structure and Algorithms:
 *  History:
 *  Notes:
 *  References:
 */

#ifndef PARROT_REGISTER_H_GUARD
#define PARROT_REGISTER_H_GUARD

#include "parrot/string.h"
#include "parrot/compiler.h"
#include "parrot/stacks.h"

/*
 * Macros to make accessing registers more convenient/readable.
 */

#define CTX_REG_NUM(ctx, x) (ctx)->bp.regs_n[-1L-(x)]
#define CTX_REG_INT(ctx, x) (ctx)->bp.regs_i[x]
#define CTX_REG_PMC(ctx, x) (ctx)->bp_ps.regs_p[-1L-(x)]
#define CTX_REG_STR(ctx, x) (ctx)->bp_ps.regs_s[x]

#define REG_NUM(interp, x) CTX_REG_NUM(&(interp)->ctx, (x))
#define REG_INT(interp, x) CTX_REG_INT(&(interp)->ctx, (x))
#define REG_PMC(interp, x) CTX_REG_PMC(&(interp)->ctx, (x))
#define REG_STR(interp, x) CTX_REG_STR(&(interp)->ctx, (x))

/*
 * and a set of macros to access a register by offset, used
 * in JIT emit prederef code
 * The offsets are relative to interp->ctx.bp.
 *
 * Reg order in imcc/reg_alloc.c is "INSP"   TODO make defines
 */

#define REGNO_INT 0
#define REGNO_NUM 1
#define REGNO_STR 2
#define REGNO_PMC 3

#define __CTX interp->ctx.state
#define _SIZEOF_INTS    (sizeof (INTVAL) * __CTX->n_regs_used[REGNO_INT])
#define _SIZEOF_NUMS    (sizeof (FLOATVAL) * __CTX->n_regs_used[REGNO_NUM])
#define _SIZEOF_PMCS    (sizeof (PMC*) * __CTX->n_regs_used[REGNO_PMC])
#define _SIZEOF_STRS    (sizeof (STRING*) * __CTX->n_regs_used[REGNO_STR])

#define REG_OFFS_NUM(x) (sizeof (FLOATVAL) * (-1L - (x)))
#define REG_OFFS_INT(x) (sizeof (INTVAL) * (x))
#define REG_OFFS_PMC(x) (_SIZEOF_INTS + sizeof (PMC*) * \
        (__CTX->n_regs_used[REGNO_PMC] - 1L - (x)))
#define REG_OFFS_STR(x) (sizeof (STRING*) * (x) + _SIZEOF_INTS + _SIZEOF_PMCS)


struct Stack_Chunk;
struct Parrot_Context;        /* parrot/interpreter.h */

/* HEADERIZER BEGIN: src/gc/register.c */
/* Don't modify between HEADERIZER BEGIN / HEADERIZER END.  Your changes will be lost. */

PARROT_API
void Parrot_clear_i(PARROT_INTERP)
        __attribute__nonnull__(1);

PARROT_API
void Parrot_clear_n(PARROT_INTERP)
        __attribute__nonnull__(1);

PARROT_API
void Parrot_clear_p(PARROT_INTERP)
        __attribute__nonnull__(1);

PARROT_API
void Parrot_clear_s(PARROT_INTERP)
        __attribute__nonnull__(1);

PARROT_API
void Parrot_free_context(PARROT_INTERP,
    ARGMOD(struct Parrot_Context *ctxp),
    int re_use)
        __attribute__nonnull__(1)
        __attribute__nonnull__(2)
        FUNC_MODIFIES(*ctxp);

PARROT_API
void parrot_gc_context(PARROT_INTERP)
        __attribute__nonnull__(1);

PARROT_API
void Parrot_pop_context(PARROT_INTERP)
        __attribute__nonnull__(1);

PARROT_API
PARROT_WARN_UNUSED_RESULT
PARROT_CANNOT_RETURN_NULL
struct Parrot_Context * Parrot_push_context(PARROT_INTERP,
    ARGMOD(INTVAL *n_regs_used))
        __attribute__nonnull__(1)
        __attribute__nonnull__(2)
        FUNC_MODIFIES(*n_regs_used);

PARROT_API
void Parrot_set_context_threshold(SHIM_INTERP,
    SHIM(struct Parrot_Context *ctxp));

void create_initial_context(PARROT_INTERP)
        __attribute__nonnull__(1);

void destroy_context(PARROT_INTERP)
        __attribute__nonnull__(1);

PARROT_CANNOT_RETURN_NULL
PARROT_WARN_UNUSED_RESULT
struct Parrot_Context * Parrot_alloc_context(PARROT_INTERP,
    ARGMOD(INTVAL *number_regs_used))
        __attribute__nonnull__(1)
        __attribute__nonnull__(2)
        FUNC_MODIFIES(*number_regs_used);

PARROT_WARN_UNUSED_RESULT
PARROT_CANNOT_RETURN_NULL
struct Parrot_Context * Parrot_dup_context(PARROT_INTERP,
    ARGIN(const struct Parrot_Context *old))
        __attribute__nonnull__(1)
        __attribute__nonnull__(2);

/* Don't modify between HEADERIZER BEGIN / HEADERIZER END.  Your changes will be lost. */
/* HEADERIZER END: src/gc/register.c */

#endif /* PARROT_REGISTER_H_GUARD */

/*
 * Local variables:
 *   c-file-style: "parrot"
 * End:
 * vim: expandtab shiftwidth=4:
 */
