#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"
#include "ppport.h"

#ifdef newXS
	#undef newXS
	#define newXS ;
#endif

MODULE = P5NCI  PACKAGE = P5NCI

void *
nci_pp( c_func, p0 )
	SV* c_func
	void * p0
PREINIT:
	void *(*func)(void *);
CODE:
	func   = INT2PTR(void *(*)(void *), SvIV(c_func) );
	RETVAL = (*func)(p0);
OUTPUT:
	RETVAL

void *
nci_pv( c_func )
	SV* c_func
PREINIT:
	void *(*func)( );
CODE:
	func   = INT2PTR(void *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void *
nci_pd( c_func, d0 )
	SV* c_func
	double d0
PREINIT:
	void *(*func)(double);
CODE:
	func   = INT2PTR(void *(*)(double), SvIV(c_func) );
	RETVAL = (*func)(d0);
OUTPUT:
	RETVAL

void *
nci_ps( c_func, s0 )
	SV* c_func
	short s0
PREINIT:
	void *(*func)(short);
CODE:
	func   = INT2PTR(void *(*)(short), SvIV(c_func) );
	RETVAL = (*func)(s0);
OUTPUT:
	RETVAL

void *
nci_pf( c_func, f0 )
	SV* c_func
	float f0
PREINIT:
	void *(*func)(float);
CODE:
	func   = INT2PTR(void *(*)(float), SvIV(c_func) );
	RETVAL = (*func)(f0);
OUTPUT:
	RETVAL

void *
nci_pt( c_func, t0 )
	SV* c_func
	char * t0
PREINIT:
	void *(*func)(char *);
CODE:
	func   = INT2PTR(void *(*)(char *), SvIV(c_func) );
	RETVAL = (*func)(t0);
OUTPUT:
	RETVAL

void *
nci_pi( c_func, i0 )
	SV* c_func
	int i0
PREINIT:
	void *(*func)(int);
CODE:
	func   = INT2PTR(void *(*)(int), SvIV(c_func) );
	RETVAL = (*func)(i0);
OUTPUT:
	RETVAL

void
nci_vp( c_func, p0 )
	SV* c_func
	void * p0
PREINIT:
	void(*func)(void *);
CODE:
	func   = INT2PTR(void(*)(void *), SvIV(c_func) );
	(*func)(p0);

void
nci_vv( c_func )
	SV* c_func
PREINIT:
	void(*func)( );
CODE:
	func   = INT2PTR(void(*)( ), SvIV(c_func) );
	(*func)();

void
nci_vd( c_func, d0 )
	SV* c_func
	double d0
PREINIT:
	void(*func)(double);
CODE:
	func   = INT2PTR(void(*)(double), SvIV(c_func) );
	(*func)(d0);

void
nci_vs( c_func, s0 )
	SV* c_func
	short s0
PREINIT:
	void(*func)(short);
CODE:
	func   = INT2PTR(void(*)(short), SvIV(c_func) );
	(*func)(s0);

void
nci_vf( c_func, f0 )
	SV* c_func
	float f0
PREINIT:
	void(*func)(float);
CODE:
	func   = INT2PTR(void(*)(float), SvIV(c_func) );
	(*func)(f0);

void
nci_vt( c_func, t0 )
	SV* c_func
	char * t0
PREINIT:
	void(*func)(char *);
CODE:
	func   = INT2PTR(void(*)(char *), SvIV(c_func) );
	(*func)(t0);

void
nci_vi( c_func, i0 )
	SV* c_func
	int i0
PREINIT:
	void(*func)(int);
CODE:
	func   = INT2PTR(void(*)(int), SvIV(c_func) );
	(*func)(i0);

double
nci_dp( c_func, p0 )
	SV* c_func
	void * p0
PREINIT:
	double(*func)(void *);
CODE:
	func   = INT2PTR(double(*)(void *), SvIV(c_func) );
	RETVAL = (*func)(p0);
OUTPUT:
	RETVAL

double
nci_dv( c_func )
	SV* c_func
PREINIT:
	double(*func)( );
CODE:
	func   = INT2PTR(double(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

double
nci_dd( c_func, d0 )
	SV* c_func
	double d0
PREINIT:
	double(*func)(double);
CODE:
	func   = INT2PTR(double(*)(double), SvIV(c_func) );
	RETVAL = (*func)(d0);
OUTPUT:
	RETVAL

double
nci_ds( c_func, s0 )
	SV* c_func
	short s0
PREINIT:
	double(*func)(short);
CODE:
	func   = INT2PTR(double(*)(short), SvIV(c_func) );
	RETVAL = (*func)(s0);
OUTPUT:
	RETVAL

double
nci_df( c_func, f0 )
	SV* c_func
	float f0
PREINIT:
	double(*func)(float);
CODE:
	func   = INT2PTR(double(*)(float), SvIV(c_func) );
	RETVAL = (*func)(f0);
OUTPUT:
	RETVAL

double
nci_dt( c_func, t0 )
	SV* c_func
	char * t0
PREINIT:
	double(*func)(char *);
CODE:
	func   = INT2PTR(double(*)(char *), SvIV(c_func) );
	RETVAL = (*func)(t0);
OUTPUT:
	RETVAL

double
nci_di( c_func, i0 )
	SV* c_func
	int i0
PREINIT:
	double(*func)(int);
CODE:
	func   = INT2PTR(double(*)(int), SvIV(c_func) );
	RETVAL = (*func)(i0);
OUTPUT:
	RETVAL

short
nci_sp( c_func, p0 )
	SV* c_func
	void * p0
PREINIT:
	short(*func)(void *);
CODE:
	func   = INT2PTR(short(*)(void *), SvIV(c_func) );
	RETVAL = (*func)(p0);
OUTPUT:
	RETVAL

short
nci_sv( c_func )
	SV* c_func
PREINIT:
	short(*func)( );
CODE:
	func   = INT2PTR(short(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

short
nci_sd( c_func, d0 )
	SV* c_func
	double d0
PREINIT:
	short(*func)(double);
CODE:
	func   = INT2PTR(short(*)(double), SvIV(c_func) );
	RETVAL = (*func)(d0);
OUTPUT:
	RETVAL

short
nci_ss( c_func, s0 )
	SV* c_func
	short s0
PREINIT:
	short(*func)(short);
CODE:
	func   = INT2PTR(short(*)(short), SvIV(c_func) );
	RETVAL = (*func)(s0);
OUTPUT:
	RETVAL

short
nci_sf( c_func, f0 )
	SV* c_func
	float f0
PREINIT:
	short(*func)(float);
CODE:
	func   = INT2PTR(short(*)(float), SvIV(c_func) );
	RETVAL = (*func)(f0);
OUTPUT:
	RETVAL

short
nci_st( c_func, t0 )
	SV* c_func
	char * t0
PREINIT:
	short(*func)(char *);
CODE:
	func   = INT2PTR(short(*)(char *), SvIV(c_func) );
	RETVAL = (*func)(t0);
OUTPUT:
	RETVAL

short
nci_si( c_func, i0 )
	SV* c_func
	int i0
PREINIT:
	short(*func)(int);
CODE:
	func   = INT2PTR(short(*)(int), SvIV(c_func) );
	RETVAL = (*func)(i0);
OUTPUT:
	RETVAL

float
nci_fp( c_func, p0 )
	SV* c_func
	void * p0
PREINIT:
	float(*func)(void *);
CODE:
	func   = INT2PTR(float(*)(void *), SvIV(c_func) );
	RETVAL = (*func)(p0);
OUTPUT:
	RETVAL

float
nci_fv( c_func )
	SV* c_func
PREINIT:
	float(*func)( );
CODE:
	func   = INT2PTR(float(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

float
nci_fd( c_func, d0 )
	SV* c_func
	double d0
PREINIT:
	float(*func)(double);
CODE:
	func   = INT2PTR(float(*)(double), SvIV(c_func) );
	RETVAL = (*func)(d0);
OUTPUT:
	RETVAL

float
nci_fs( c_func, s0 )
	SV* c_func
	short s0
PREINIT:
	float(*func)(short);
CODE:
	func   = INT2PTR(float(*)(short), SvIV(c_func) );
	RETVAL = (*func)(s0);
OUTPUT:
	RETVAL

float
nci_ff( c_func, f0 )
	SV* c_func
	float f0
PREINIT:
	float(*func)(float);
CODE:
	func   = INT2PTR(float(*)(float), SvIV(c_func) );
	RETVAL = (*func)(f0);
OUTPUT:
	RETVAL

float
nci_ft( c_func, t0 )
	SV* c_func
	char * t0
PREINIT:
	float(*func)(char *);
CODE:
	func   = INT2PTR(float(*)(char *), SvIV(c_func) );
	RETVAL = (*func)(t0);
OUTPUT:
	RETVAL

float
nci_fi( c_func, i0 )
	SV* c_func
	int i0
PREINIT:
	float(*func)(int);
CODE:
	func   = INT2PTR(float(*)(int), SvIV(c_func) );
	RETVAL = (*func)(i0);
OUTPUT:
	RETVAL

char *
nci_tp( c_func, p0 )
	SV* c_func
	void * p0
PREINIT:
	char *(*func)(void *);
CODE:
	func   = INT2PTR(char *(*)(void *), SvIV(c_func) );
	RETVAL = (*func)(p0);
OUTPUT:
	RETVAL

char *
nci_tv( c_func )
	SV* c_func
PREINIT:
	char *(*func)( );
CODE:
	func   = INT2PTR(char *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

char *
nci_td( c_func, d0 )
	SV* c_func
	double d0
PREINIT:
	char *(*func)(double);
CODE:
	func   = INT2PTR(char *(*)(double), SvIV(c_func) );
	RETVAL = (*func)(d0);
OUTPUT:
	RETVAL

char *
nci_ts( c_func, s0 )
	SV* c_func
	short s0
PREINIT:
	char *(*func)(short);
CODE:
	func   = INT2PTR(char *(*)(short), SvIV(c_func) );
	RETVAL = (*func)(s0);
OUTPUT:
	RETVAL

char *
nci_tf( c_func, f0 )
	SV* c_func
	float f0
PREINIT:
	char *(*func)(float);
CODE:
	func   = INT2PTR(char *(*)(float), SvIV(c_func) );
	RETVAL = (*func)(f0);
OUTPUT:
	RETVAL

char *
nci_tt( c_func, t0 )
	SV* c_func
	char * t0
PREINIT:
	char *(*func)(char *);
CODE:
	func   = INT2PTR(char *(*)(char *), SvIV(c_func) );
	RETVAL = (*func)(t0);
OUTPUT:
	RETVAL

char *
nci_ti( c_func, i0 )
	SV* c_func
	int i0
PREINIT:
	char *(*func)(int);
CODE:
	func   = INT2PTR(char *(*)(int), SvIV(c_func) );
	RETVAL = (*func)(i0);
OUTPUT:
	RETVAL

int
nci_ip( c_func, p0 )
	SV* c_func
	void * p0
PREINIT:
	int(*func)(void *);
CODE:
	func   = INT2PTR(int(*)(void *), SvIV(c_func) );
	RETVAL = (*func)(p0);
OUTPUT:
	RETVAL

int
nci_iv( c_func )
	SV* c_func
PREINIT:
	int(*func)( );
CODE:
	func   = INT2PTR(int(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

int
nci_id( c_func, d0 )
	SV* c_func
	double d0
PREINIT:
	int(*func)(double);
CODE:
	func   = INT2PTR(int(*)(double), SvIV(c_func) );
	RETVAL = (*func)(d0);
OUTPUT:
	RETVAL

int
nci_is( c_func, s0 )
	SV* c_func
	short s0
PREINIT:
	int(*func)(short);
CODE:
	func   = INT2PTR(int(*)(short), SvIV(c_func) );
	RETVAL = (*func)(s0);
OUTPUT:
	RETVAL

int
nci_if( c_func, f0 )
	SV* c_func
	float f0
PREINIT:
	int(*func)(float);
CODE:
	func   = INT2PTR(int(*)(float), SvIV(c_func) );
	RETVAL = (*func)(f0);
OUTPUT:
	RETVAL

int
nci_it( c_func, t0 )
	SV* c_func
	char * t0
PREINIT:
	int(*func)(char *);
CODE:
	func   = INT2PTR(int(*)(char *), SvIV(c_func) );
	RETVAL = (*func)(t0);
OUTPUT:
	RETVAL

int
nci_ii( c_func, i0 )
	SV* c_func
	int i0
PREINIT:
	int(*func)(int);
CODE:
	func   = INT2PTR(int(*)(int), SvIV(c_func) );
	RETVAL = (*func)(i0);
OUTPUT:
	RETVAL

void
nci_vpp( c_func, p0, p1 )
	SV* c_func
	void * p0
	void * p1
PREINIT:
	void(*func)(void *, void *);
CODE:
	func   = INT2PTR(void(*)(void *, void *), SvIV(c_func) );
	(*func)(p0, p1);

void
nci_vpd( c_func, p0, d1 )
	SV* c_func
	void * p0
	double d1
PREINIT:
	void(*func)(void *, double);
CODE:
	func   = INT2PTR(void(*)(void *, double), SvIV(c_func) );
	(*func)(p0, d1);

void
nci_vps( c_func, p0, s1 )
	SV* c_func
	void * p0
	short s1
PREINIT:
	void(*func)(void *, short);
CODE:
	func   = INT2PTR(void(*)(void *, short), SvIV(c_func) );
	(*func)(p0, s1);

void
nci_vpf( c_func, p0, f1 )
	SV* c_func
	void * p0
	float f1
PREINIT:
	void(*func)(void *, float);
CODE:
	func   = INT2PTR(void(*)(void *, float), SvIV(c_func) );
	(*func)(p0, f1);

void
nci_vpt( c_func, p0, t1 )
	SV* c_func
	void * p0
	char * t1
PREINIT:
	void(*func)(void *, char *);
CODE:
	func   = INT2PTR(void(*)(void *, char *), SvIV(c_func) );
	(*func)(p0, t1);

void
nci_vpi( c_func, p0, i1 )
	SV* c_func
	void * p0
	int i1
PREINIT:
	void(*func)(void *, int);
CODE:
	func   = INT2PTR(void(*)(void *, int), SvIV(c_func) );
	(*func)(p0, i1);

void
nci_vdp( c_func, d0, p1 )
	SV* c_func
	double d0
	void * p1
PREINIT:
	void(*func)(double, void *);
CODE:
	func   = INT2PTR(void(*)(double, void *), SvIV(c_func) );
	(*func)(d0, p1);

void
nci_vdd( c_func, d0, d1 )
	SV* c_func
	double d0
	double d1
PREINIT:
	void(*func)(double, double);
CODE:
	func   = INT2PTR(void(*)(double, double), SvIV(c_func) );
	(*func)(d0, d1);

void
nci_vds( c_func, d0, s1 )
	SV* c_func
	double d0
	short s1
PREINIT:
	void(*func)(double, short);
CODE:
	func   = INT2PTR(void(*)(double, short), SvIV(c_func) );
	(*func)(d0, s1);

void
nci_vdf( c_func, d0, f1 )
	SV* c_func
	double d0
	float f1
PREINIT:
	void(*func)(double, float);
CODE:
	func   = INT2PTR(void(*)(double, float), SvIV(c_func) );
	(*func)(d0, f1);

void
nci_vdt( c_func, d0, t1 )
	SV* c_func
	double d0
	char * t1
PREINIT:
	void(*func)(double, char *);
CODE:
	func   = INT2PTR(void(*)(double, char *), SvIV(c_func) );
	(*func)(d0, t1);

void
nci_vdi( c_func, d0, i1 )
	SV* c_func
	double d0
	int i1
PREINIT:
	void(*func)(double, int);
CODE:
	func   = INT2PTR(void(*)(double, int), SvIV(c_func) );
	(*func)(d0, i1);

void
nci_vsp( c_func, s0, p1 )
	SV* c_func
	short s0
	void * p1
PREINIT:
	void(*func)(short, void *);
CODE:
	func   = INT2PTR(void(*)(short, void *), SvIV(c_func) );
	(*func)(s0, p1);

void
nci_vsd( c_func, s0, d1 )
	SV* c_func
	short s0
	double d1
PREINIT:
	void(*func)(short, double);
CODE:
	func   = INT2PTR(void(*)(short, double), SvIV(c_func) );
	(*func)(s0, d1);

void
nci_vss( c_func, s0, s1 )
	SV* c_func
	short s0
	short s1
PREINIT:
	void(*func)(short, short);
CODE:
	func   = INT2PTR(void(*)(short, short), SvIV(c_func) );
	(*func)(s0, s1);

void
nci_vsf( c_func, s0, f1 )
	SV* c_func
	short s0
	float f1
PREINIT:
	void(*func)(short, float);
CODE:
	func   = INT2PTR(void(*)(short, float), SvIV(c_func) );
	(*func)(s0, f1);

void
nci_vst( c_func, s0, t1 )
	SV* c_func
	short s0
	char * t1
PREINIT:
	void(*func)(short, char *);
CODE:
	func   = INT2PTR(void(*)(short, char *), SvIV(c_func) );
	(*func)(s0, t1);

void
nci_vsi( c_func, s0, i1 )
	SV* c_func
	short s0
	int i1
PREINIT:
	void(*func)(short, int);
CODE:
	func   = INT2PTR(void(*)(short, int), SvIV(c_func) );
	(*func)(s0, i1);

void
nci_vfp( c_func, f0, p1 )
	SV* c_func
	float f0
	void * p1
PREINIT:
	void(*func)(float, void *);
CODE:
	func   = INT2PTR(void(*)(float, void *), SvIV(c_func) );
	(*func)(f0, p1);

void
nci_vfd( c_func, f0, d1 )
	SV* c_func
	float f0
	double d1
PREINIT:
	void(*func)(float, double);
CODE:
	func   = INT2PTR(void(*)(float, double), SvIV(c_func) );
	(*func)(f0, d1);

void
nci_vfs( c_func, f0, s1 )
	SV* c_func
	float f0
	short s1
PREINIT:
	void(*func)(float, short);
CODE:
	func   = INT2PTR(void(*)(float, short), SvIV(c_func) );
	(*func)(f0, s1);

void
nci_vff( c_func, f0, f1 )
	SV* c_func
	float f0
	float f1
PREINIT:
	void(*func)(float, float);
CODE:
	func   = INT2PTR(void(*)(float, float), SvIV(c_func) );
	(*func)(f0, f1);

void
nci_vft( c_func, f0, t1 )
	SV* c_func
	float f0
	char * t1
PREINIT:
	void(*func)(float, char *);
CODE:
	func   = INT2PTR(void(*)(float, char *), SvIV(c_func) );
	(*func)(f0, t1);

void
nci_vfi( c_func, f0, i1 )
	SV* c_func
	float f0
	int i1
PREINIT:
	void(*func)(float, int);
CODE:
	func   = INT2PTR(void(*)(float, int), SvIV(c_func) );
	(*func)(f0, i1);

void
nci_vtp( c_func, t0, p1 )
	SV* c_func
	char * t0
	void * p1
PREINIT:
	void(*func)(char *, void *);
CODE:
	func   = INT2PTR(void(*)(char *, void *), SvIV(c_func) );
	(*func)(t0, p1);

void
nci_vtd( c_func, t0, d1 )
	SV* c_func
	char * t0
	double d1
PREINIT:
	void(*func)(char *, double);
CODE:
	func   = INT2PTR(void(*)(char *, double), SvIV(c_func) );
	(*func)(t0, d1);

void
nci_vts( c_func, t0, s1 )
	SV* c_func
	char * t0
	short s1
PREINIT:
	void(*func)(char *, short);
CODE:
	func   = INT2PTR(void(*)(char *, short), SvIV(c_func) );
	(*func)(t0, s1);

void
nci_vtf( c_func, t0, f1 )
	SV* c_func
	char * t0
	float f1
PREINIT:
	void(*func)(char *, float);
CODE:
	func   = INT2PTR(void(*)(char *, float), SvIV(c_func) );
	(*func)(t0, f1);

void
nci_vtt( c_func, t0, t1 )
	SV* c_func
	char * t0
	char * t1
PREINIT:
	void(*func)(char *, char *);
CODE:
	func   = INT2PTR(void(*)(char *, char *), SvIV(c_func) );
	(*func)(t0, t1);

void
nci_vti( c_func, t0, i1 )
	SV* c_func
	char * t0
	int i1
PREINIT:
	void(*func)(char *, int);
CODE:
	func   = INT2PTR(void(*)(char *, int), SvIV(c_func) );
	(*func)(t0, i1);

void
nci_vip( c_func, i0, p1 )
	SV* c_func
	int i0
	void * p1
PREINIT:
	void(*func)(int, void *);
CODE:
	func   = INT2PTR(void(*)(int, void *), SvIV(c_func) );
	(*func)(i0, p1);

void
nci_vid( c_func, i0, d1 )
	SV* c_func
	int i0
	double d1
PREINIT:
	void(*func)(int, double);
CODE:
	func   = INT2PTR(void(*)(int, double), SvIV(c_func) );
	(*func)(i0, d1);

void
nci_vis( c_func, i0, s1 )
	SV* c_func
	int i0
	short s1
PREINIT:
	void(*func)(int, short);
CODE:
	func   = INT2PTR(void(*)(int, short), SvIV(c_func) );
	(*func)(i0, s1);

void
nci_vif( c_func, i0, f1 )
	SV* c_func
	int i0
	float f1
PREINIT:
	void(*func)(int, float);
CODE:
	func   = INT2PTR(void(*)(int, float), SvIV(c_func) );
	(*func)(i0, f1);

void
nci_vit( c_func, i0, t1 )
	SV* c_func
	int i0
	char * t1
PREINIT:
	void(*func)(int, char *);
CODE:
	func   = INT2PTR(void(*)(int, char *), SvIV(c_func) );
	(*func)(i0, t1);

void
nci_vii( c_func, i0, i1 )
	SV* c_func
	int i0
	int i1
PREINIT:
	void(*func)(int, int);
CODE:
	func   = INT2PTR(void(*)(int, int), SvIV(c_func) );
	(*func)(i0, i1);

double
nci_dpp( c_func, p0, p1 )
	SV* c_func
	void * p0
	void * p1
PREINIT:
	double(*func)(void *, void *);
CODE:
	func   = INT2PTR(double(*)(void *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, p1);
OUTPUT:
	RETVAL

double
nci_dpd( c_func, p0, d1 )
	SV* c_func
	void * p0
	double d1
PREINIT:
	double(*func)(void *, double);
CODE:
	func   = INT2PTR(double(*)(void *, double), SvIV(c_func) );
	RETVAL = (*func)(p0, d1);
OUTPUT:
	RETVAL

double
nci_dps( c_func, p0, s1 )
	SV* c_func
	void * p0
	short s1
PREINIT:
	double(*func)(void *, short);
CODE:
	func   = INT2PTR(double(*)(void *, short), SvIV(c_func) );
	RETVAL = (*func)(p0, s1);
OUTPUT:
	RETVAL

double
nci_dpf( c_func, p0, f1 )
	SV* c_func
	void * p0
	float f1
PREINIT:
	double(*func)(void *, float);
CODE:
	func   = INT2PTR(double(*)(void *, float), SvIV(c_func) );
	RETVAL = (*func)(p0, f1);
OUTPUT:
	RETVAL

double
nci_dpt( c_func, p0, t1 )
	SV* c_func
	void * p0
	char * t1
PREINIT:
	double(*func)(void *, char *);
CODE:
	func   = INT2PTR(double(*)(void *, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, t1);
OUTPUT:
	RETVAL

double
nci_dpi( c_func, p0, i1 )
	SV* c_func
	void * p0
	int i1
PREINIT:
	double(*func)(void *, int);
CODE:
	func   = INT2PTR(double(*)(void *, int), SvIV(c_func) );
	RETVAL = (*func)(p0, i1);
OUTPUT:
	RETVAL

double
nci_ddp( c_func, d0, p1 )
	SV* c_func
	double d0
	void * p1
PREINIT:
	double(*func)(double, void *);
CODE:
	func   = INT2PTR(double(*)(double, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, p1);
OUTPUT:
	RETVAL

double
nci_ddd( c_func, d0, d1 )
	SV* c_func
	double d0
	double d1
PREINIT:
	double(*func)(double, double);
CODE:
	func   = INT2PTR(double(*)(double, double), SvIV(c_func) );
	RETVAL = (*func)(d0, d1);
OUTPUT:
	RETVAL

double
nci_dds( c_func, d0, s1 )
	SV* c_func
	double d0
	short s1
PREINIT:
	double(*func)(double, short);
CODE:
	func   = INT2PTR(double(*)(double, short), SvIV(c_func) );
	RETVAL = (*func)(d0, s1);
OUTPUT:
	RETVAL

double
nci_ddf( c_func, d0, f1 )
	SV* c_func
	double d0
	float f1
PREINIT:
	double(*func)(double, float);
CODE:
	func   = INT2PTR(double(*)(double, float), SvIV(c_func) );
	RETVAL = (*func)(d0, f1);
OUTPUT:
	RETVAL

double
nci_ddt( c_func, d0, t1 )
	SV* c_func
	double d0
	char * t1
PREINIT:
	double(*func)(double, char *);
CODE:
	func   = INT2PTR(double(*)(double, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, t1);
OUTPUT:
	RETVAL

double
nci_ddi( c_func, d0, i1 )
	SV* c_func
	double d0
	int i1
PREINIT:
	double(*func)(double, int);
CODE:
	func   = INT2PTR(double(*)(double, int), SvIV(c_func) );
	RETVAL = (*func)(d0, i1);
OUTPUT:
	RETVAL

double
nci_dsp( c_func, s0, p1 )
	SV* c_func
	short s0
	void * p1
PREINIT:
	double(*func)(short, void *);
CODE:
	func   = INT2PTR(double(*)(short, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, p1);
OUTPUT:
	RETVAL

double
nci_dsd( c_func, s0, d1 )
	SV* c_func
	short s0
	double d1
PREINIT:
	double(*func)(short, double);
CODE:
	func   = INT2PTR(double(*)(short, double), SvIV(c_func) );
	RETVAL = (*func)(s0, d1);
OUTPUT:
	RETVAL

double
nci_dss( c_func, s0, s1 )
	SV* c_func
	short s0
	short s1
PREINIT:
	double(*func)(short, short);
CODE:
	func   = INT2PTR(double(*)(short, short), SvIV(c_func) );
	RETVAL = (*func)(s0, s1);
OUTPUT:
	RETVAL

double
nci_dsf( c_func, s0, f1 )
	SV* c_func
	short s0
	float f1
PREINIT:
	double(*func)(short, float);
CODE:
	func   = INT2PTR(double(*)(short, float), SvIV(c_func) );
	RETVAL = (*func)(s0, f1);
OUTPUT:
	RETVAL

double
nci_dst( c_func, s0, t1 )
	SV* c_func
	short s0
	char * t1
PREINIT:
	double(*func)(short, char *);
CODE:
	func   = INT2PTR(double(*)(short, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, t1);
OUTPUT:
	RETVAL

double
nci_dsi( c_func, s0, i1 )
	SV* c_func
	short s0
	int i1
PREINIT:
	double(*func)(short, int);
CODE:
	func   = INT2PTR(double(*)(short, int), SvIV(c_func) );
	RETVAL = (*func)(s0, i1);
OUTPUT:
	RETVAL

double
nci_dfp( c_func, f0, p1 )
	SV* c_func
	float f0
	void * p1
PREINIT:
	double(*func)(float, void *);
CODE:
	func   = INT2PTR(double(*)(float, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, p1);
OUTPUT:
	RETVAL

double
nci_dfd( c_func, f0, d1 )
	SV* c_func
	float f0
	double d1
PREINIT:
	double(*func)(float, double);
CODE:
	func   = INT2PTR(double(*)(float, double), SvIV(c_func) );
	RETVAL = (*func)(f0, d1);
OUTPUT:
	RETVAL

double
nci_dfs( c_func, f0, s1 )
	SV* c_func
	float f0
	short s1
PREINIT:
	double(*func)(float, short);
CODE:
	func   = INT2PTR(double(*)(float, short), SvIV(c_func) );
	RETVAL = (*func)(f0, s1);
OUTPUT:
	RETVAL

double
nci_dff( c_func, f0, f1 )
	SV* c_func
	float f0
	float f1
PREINIT:
	double(*func)(float, float);
CODE:
	func   = INT2PTR(double(*)(float, float), SvIV(c_func) );
	RETVAL = (*func)(f0, f1);
OUTPUT:
	RETVAL

double
nci_dft( c_func, f0, t1 )
	SV* c_func
	float f0
	char * t1
PREINIT:
	double(*func)(float, char *);
CODE:
	func   = INT2PTR(double(*)(float, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, t1);
OUTPUT:
	RETVAL

double
nci_dfi( c_func, f0, i1 )
	SV* c_func
	float f0
	int i1
PREINIT:
	double(*func)(float, int);
CODE:
	func   = INT2PTR(double(*)(float, int), SvIV(c_func) );
	RETVAL = (*func)(f0, i1);
OUTPUT:
	RETVAL

double
nci_dtp( c_func, t0, p1 )
	SV* c_func
	char * t0
	void * p1
PREINIT:
	double(*func)(char *, void *);
CODE:
	func   = INT2PTR(double(*)(char *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, p1);
OUTPUT:
	RETVAL

double
nci_dtd( c_func, t0, d1 )
	SV* c_func
	char * t0
	double d1
PREINIT:
	double(*func)(char *, double);
CODE:
	func   = INT2PTR(double(*)(char *, double), SvIV(c_func) );
	RETVAL = (*func)(t0, d1);
OUTPUT:
	RETVAL

double
nci_dts( c_func, t0, s1 )
	SV* c_func
	char * t0
	short s1
PREINIT:
	double(*func)(char *, short);
CODE:
	func   = INT2PTR(double(*)(char *, short), SvIV(c_func) );
	RETVAL = (*func)(t0, s1);
OUTPUT:
	RETVAL

double
nci_dtf( c_func, t0, f1 )
	SV* c_func
	char * t0
	float f1
PREINIT:
	double(*func)(char *, float);
CODE:
	func   = INT2PTR(double(*)(char *, float), SvIV(c_func) );
	RETVAL = (*func)(t0, f1);
OUTPUT:
	RETVAL

double
nci_dtt( c_func, t0, t1 )
	SV* c_func
	char * t0
	char * t1
PREINIT:
	double(*func)(char *, char *);
CODE:
	func   = INT2PTR(double(*)(char *, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, t1);
OUTPUT:
	RETVAL

double
nci_dti( c_func, t0, i1 )
	SV* c_func
	char * t0
	int i1
PREINIT:
	double(*func)(char *, int);
CODE:
	func   = INT2PTR(double(*)(char *, int), SvIV(c_func) );
	RETVAL = (*func)(t0, i1);
OUTPUT:
	RETVAL

double
nci_dip( c_func, i0, p1 )
	SV* c_func
	int i0
	void * p1
PREINIT:
	double(*func)(int, void *);
CODE:
	func   = INT2PTR(double(*)(int, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, p1);
OUTPUT:
	RETVAL

double
nci_did( c_func, i0, d1 )
	SV* c_func
	int i0
	double d1
PREINIT:
	double(*func)(int, double);
CODE:
	func   = INT2PTR(double(*)(int, double), SvIV(c_func) );
	RETVAL = (*func)(i0, d1);
OUTPUT:
	RETVAL

double
nci_dis( c_func, i0, s1 )
	SV* c_func
	int i0
	short s1
PREINIT:
	double(*func)(int, short);
CODE:
	func   = INT2PTR(double(*)(int, short), SvIV(c_func) );
	RETVAL = (*func)(i0, s1);
OUTPUT:
	RETVAL

double
nci_dif( c_func, i0, f1 )
	SV* c_func
	int i0
	float f1
PREINIT:
	double(*func)(int, float);
CODE:
	func   = INT2PTR(double(*)(int, float), SvIV(c_func) );
	RETVAL = (*func)(i0, f1);
OUTPUT:
	RETVAL

double
nci_dit( c_func, i0, t1 )
	SV* c_func
	int i0
	char * t1
PREINIT:
	double(*func)(int, char *);
CODE:
	func   = INT2PTR(double(*)(int, char *), SvIV(c_func) );
	RETVAL = (*func)(i0, t1);
OUTPUT:
	RETVAL

double
nci_dii( c_func, i0, i1 )
	SV* c_func
	int i0
	int i1
PREINIT:
	double(*func)(int, int);
CODE:
	func   = INT2PTR(double(*)(int, int), SvIV(c_func) );
	RETVAL = (*func)(i0, i1);
OUTPUT:
	RETVAL

short
nci_spp( c_func, p0, p1 )
	SV* c_func
	void * p0
	void * p1
PREINIT:
	short(*func)(void *, void *);
CODE:
	func   = INT2PTR(short(*)(void *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, p1);
OUTPUT:
	RETVAL

short
nci_spd( c_func, p0, d1 )
	SV* c_func
	void * p0
	double d1
PREINIT:
	short(*func)(void *, double);
CODE:
	func   = INT2PTR(short(*)(void *, double), SvIV(c_func) );
	RETVAL = (*func)(p0, d1);
OUTPUT:
	RETVAL

short
nci_sps( c_func, p0, s1 )
	SV* c_func
	void * p0
	short s1
PREINIT:
	short(*func)(void *, short);
CODE:
	func   = INT2PTR(short(*)(void *, short), SvIV(c_func) );
	RETVAL = (*func)(p0, s1);
OUTPUT:
	RETVAL

short
nci_spf( c_func, p0, f1 )
	SV* c_func
	void * p0
	float f1
PREINIT:
	short(*func)(void *, float);
CODE:
	func   = INT2PTR(short(*)(void *, float), SvIV(c_func) );
	RETVAL = (*func)(p0, f1);
OUTPUT:
	RETVAL

short
nci_spt( c_func, p0, t1 )
	SV* c_func
	void * p0
	char * t1
PREINIT:
	short(*func)(void *, char *);
CODE:
	func   = INT2PTR(short(*)(void *, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, t1);
OUTPUT:
	RETVAL

short
nci_spi( c_func, p0, i1 )
	SV* c_func
	void * p0
	int i1
PREINIT:
	short(*func)(void *, int);
CODE:
	func   = INT2PTR(short(*)(void *, int), SvIV(c_func) );
	RETVAL = (*func)(p0, i1);
OUTPUT:
	RETVAL

short
nci_sdp( c_func, d0, p1 )
	SV* c_func
	double d0
	void * p1
PREINIT:
	short(*func)(double, void *);
CODE:
	func   = INT2PTR(short(*)(double, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, p1);
OUTPUT:
	RETVAL

short
nci_sdd( c_func, d0, d1 )
	SV* c_func
	double d0
	double d1
PREINIT:
	short(*func)(double, double);
CODE:
	func   = INT2PTR(short(*)(double, double), SvIV(c_func) );
	RETVAL = (*func)(d0, d1);
OUTPUT:
	RETVAL

short
nci_sds( c_func, d0, s1 )
	SV* c_func
	double d0
	short s1
PREINIT:
	short(*func)(double, short);
CODE:
	func   = INT2PTR(short(*)(double, short), SvIV(c_func) );
	RETVAL = (*func)(d0, s1);
OUTPUT:
	RETVAL

short
nci_sdf( c_func, d0, f1 )
	SV* c_func
	double d0
	float f1
PREINIT:
	short(*func)(double, float);
CODE:
	func   = INT2PTR(short(*)(double, float), SvIV(c_func) );
	RETVAL = (*func)(d0, f1);
OUTPUT:
	RETVAL

short
nci_sdt( c_func, d0, t1 )
	SV* c_func
	double d0
	char * t1
PREINIT:
	short(*func)(double, char *);
CODE:
	func   = INT2PTR(short(*)(double, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, t1);
OUTPUT:
	RETVAL

short
nci_sdi( c_func, d0, i1 )
	SV* c_func
	double d0
	int i1
PREINIT:
	short(*func)(double, int);
CODE:
	func   = INT2PTR(short(*)(double, int), SvIV(c_func) );
	RETVAL = (*func)(d0, i1);
OUTPUT:
	RETVAL

short
nci_ssp( c_func, s0, p1 )
	SV* c_func
	short s0
	void * p1
PREINIT:
	short(*func)(short, void *);
CODE:
	func   = INT2PTR(short(*)(short, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, p1);
OUTPUT:
	RETVAL

short
nci_ssd( c_func, s0, d1 )
	SV* c_func
	short s0
	double d1
PREINIT:
	short(*func)(short, double);
CODE:
	func   = INT2PTR(short(*)(short, double), SvIV(c_func) );
	RETVAL = (*func)(s0, d1);
OUTPUT:
	RETVAL

short
nci_sss( c_func, s0, s1 )
	SV* c_func
	short s0
	short s1
PREINIT:
	short(*func)(short, short);
CODE:
	func   = INT2PTR(short(*)(short, short), SvIV(c_func) );
	RETVAL = (*func)(s0, s1);
OUTPUT:
	RETVAL

short
nci_ssf( c_func, s0, f1 )
	SV* c_func
	short s0
	float f1
PREINIT:
	short(*func)(short, float);
CODE:
	func   = INT2PTR(short(*)(short, float), SvIV(c_func) );
	RETVAL = (*func)(s0, f1);
OUTPUT:
	RETVAL

short
nci_sst( c_func, s0, t1 )
	SV* c_func
	short s0
	char * t1
PREINIT:
	short(*func)(short, char *);
CODE:
	func   = INT2PTR(short(*)(short, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, t1);
OUTPUT:
	RETVAL

short
nci_ssi( c_func, s0, i1 )
	SV* c_func
	short s0
	int i1
PREINIT:
	short(*func)(short, int);
CODE:
	func   = INT2PTR(short(*)(short, int), SvIV(c_func) );
	RETVAL = (*func)(s0, i1);
OUTPUT:
	RETVAL

short
nci_sfp( c_func, f0, p1 )
	SV* c_func
	float f0
	void * p1
PREINIT:
	short(*func)(float, void *);
CODE:
	func   = INT2PTR(short(*)(float, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, p1);
OUTPUT:
	RETVAL

short
nci_sfd( c_func, f0, d1 )
	SV* c_func
	float f0
	double d1
PREINIT:
	short(*func)(float, double);
CODE:
	func   = INT2PTR(short(*)(float, double), SvIV(c_func) );
	RETVAL = (*func)(f0, d1);
OUTPUT:
	RETVAL

short
nci_sfs( c_func, f0, s1 )
	SV* c_func
	float f0
	short s1
PREINIT:
	short(*func)(float, short);
CODE:
	func   = INT2PTR(short(*)(float, short), SvIV(c_func) );
	RETVAL = (*func)(f0, s1);
OUTPUT:
	RETVAL

short
nci_sff( c_func, f0, f1 )
	SV* c_func
	float f0
	float f1
PREINIT:
	short(*func)(float, float);
CODE:
	func   = INT2PTR(short(*)(float, float), SvIV(c_func) );
	RETVAL = (*func)(f0, f1);
OUTPUT:
	RETVAL

short
nci_sft( c_func, f0, t1 )
	SV* c_func
	float f0
	char * t1
PREINIT:
	short(*func)(float, char *);
CODE:
	func   = INT2PTR(short(*)(float, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, t1);
OUTPUT:
	RETVAL

short
nci_sfi( c_func, f0, i1 )
	SV* c_func
	float f0
	int i1
PREINIT:
	short(*func)(float, int);
CODE:
	func   = INT2PTR(short(*)(float, int), SvIV(c_func) );
	RETVAL = (*func)(f0, i1);
OUTPUT:
	RETVAL

short
nci_stp( c_func, t0, p1 )
	SV* c_func
	char * t0
	void * p1
PREINIT:
	short(*func)(char *, void *);
CODE:
	func   = INT2PTR(short(*)(char *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, p1);
OUTPUT:
	RETVAL

short
nci_std( c_func, t0, d1 )
	SV* c_func
	char * t0
	double d1
PREINIT:
	short(*func)(char *, double);
CODE:
	func   = INT2PTR(short(*)(char *, double), SvIV(c_func) );
	RETVAL = (*func)(t0, d1);
OUTPUT:
	RETVAL

short
nci_sts( c_func, t0, s1 )
	SV* c_func
	char * t0
	short s1
PREINIT:
	short(*func)(char *, short);
CODE:
	func   = INT2PTR(short(*)(char *, short), SvIV(c_func) );
	RETVAL = (*func)(t0, s1);
OUTPUT:
	RETVAL

short
nci_stf( c_func, t0, f1 )
	SV* c_func
	char * t0
	float f1
PREINIT:
	short(*func)(char *, float);
CODE:
	func   = INT2PTR(short(*)(char *, float), SvIV(c_func) );
	RETVAL = (*func)(t0, f1);
OUTPUT:
	RETVAL

short
nci_stt( c_func, t0, t1 )
	SV* c_func
	char * t0
	char * t1
PREINIT:
	short(*func)(char *, char *);
CODE:
	func   = INT2PTR(short(*)(char *, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, t1);
OUTPUT:
	RETVAL

short
nci_sti( c_func, t0, i1 )
	SV* c_func
	char * t0
	int i1
PREINIT:
	short(*func)(char *, int);
CODE:
	func   = INT2PTR(short(*)(char *, int), SvIV(c_func) );
	RETVAL = (*func)(t0, i1);
OUTPUT:
	RETVAL

short
nci_sip( c_func, i0, p1 )
	SV* c_func
	int i0
	void * p1
PREINIT:
	short(*func)(int, void *);
CODE:
	func   = INT2PTR(short(*)(int, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, p1);
OUTPUT:
	RETVAL

short
nci_sid( c_func, i0, d1 )
	SV* c_func
	int i0
	double d1
PREINIT:
	short(*func)(int, double);
CODE:
	func   = INT2PTR(short(*)(int, double), SvIV(c_func) );
	RETVAL = (*func)(i0, d1);
OUTPUT:
	RETVAL

short
nci_sis( c_func, i0, s1 )
	SV* c_func
	int i0
	short s1
PREINIT:
	short(*func)(int, short);
CODE:
	func   = INT2PTR(short(*)(int, short), SvIV(c_func) );
	RETVAL = (*func)(i0, s1);
OUTPUT:
	RETVAL

short
nci_sif( c_func, i0, f1 )
	SV* c_func
	int i0
	float f1
PREINIT:
	short(*func)(int, float);
CODE:
	func   = INT2PTR(short(*)(int, float), SvIV(c_func) );
	RETVAL = (*func)(i0, f1);
OUTPUT:
	RETVAL

short
nci_sit( c_func, i0, t1 )
	SV* c_func
	int i0
	char * t1
PREINIT:
	short(*func)(int, char *);
CODE:
	func   = INT2PTR(short(*)(int, char *), SvIV(c_func) );
	RETVAL = (*func)(i0, t1);
OUTPUT:
	RETVAL

short
nci_sii( c_func, i0, i1 )
	SV* c_func
	int i0
	int i1
PREINIT:
	short(*func)(int, int);
CODE:
	func   = INT2PTR(short(*)(int, int), SvIV(c_func) );
	RETVAL = (*func)(i0, i1);
OUTPUT:
	RETVAL

float
nci_fpp( c_func, p0, p1 )
	SV* c_func
	void * p0
	void * p1
PREINIT:
	float(*func)(void *, void *);
CODE:
	func   = INT2PTR(float(*)(void *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, p1);
OUTPUT:
	RETVAL

float
nci_fpd( c_func, p0, d1 )
	SV* c_func
	void * p0
	double d1
PREINIT:
	float(*func)(void *, double);
CODE:
	func   = INT2PTR(float(*)(void *, double), SvIV(c_func) );
	RETVAL = (*func)(p0, d1);
OUTPUT:
	RETVAL

float
nci_fps( c_func, p0, s1 )
	SV* c_func
	void * p0
	short s1
PREINIT:
	float(*func)(void *, short);
CODE:
	func   = INT2PTR(float(*)(void *, short), SvIV(c_func) );
	RETVAL = (*func)(p0, s1);
OUTPUT:
	RETVAL

float
nci_fpf( c_func, p0, f1 )
	SV* c_func
	void * p0
	float f1
PREINIT:
	float(*func)(void *, float);
CODE:
	func   = INT2PTR(float(*)(void *, float), SvIV(c_func) );
	RETVAL = (*func)(p0, f1);
OUTPUT:
	RETVAL

float
nci_fpt( c_func, p0, t1 )
	SV* c_func
	void * p0
	char * t1
PREINIT:
	float(*func)(void *, char *);
CODE:
	func   = INT2PTR(float(*)(void *, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, t1);
OUTPUT:
	RETVAL

float
nci_fpi( c_func, p0, i1 )
	SV* c_func
	void * p0
	int i1
PREINIT:
	float(*func)(void *, int);
CODE:
	func   = INT2PTR(float(*)(void *, int), SvIV(c_func) );
	RETVAL = (*func)(p0, i1);
OUTPUT:
	RETVAL

float
nci_fdp( c_func, d0, p1 )
	SV* c_func
	double d0
	void * p1
PREINIT:
	float(*func)(double, void *);
CODE:
	func   = INT2PTR(float(*)(double, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, p1);
OUTPUT:
	RETVAL

float
nci_fdd( c_func, d0, d1 )
	SV* c_func
	double d0
	double d1
PREINIT:
	float(*func)(double, double);
CODE:
	func   = INT2PTR(float(*)(double, double), SvIV(c_func) );
	RETVAL = (*func)(d0, d1);
OUTPUT:
	RETVAL

float
nci_fds( c_func, d0, s1 )
	SV* c_func
	double d0
	short s1
PREINIT:
	float(*func)(double, short);
CODE:
	func   = INT2PTR(float(*)(double, short), SvIV(c_func) );
	RETVAL = (*func)(d0, s1);
OUTPUT:
	RETVAL

float
nci_fdf( c_func, d0, f1 )
	SV* c_func
	double d0
	float f1
PREINIT:
	float(*func)(double, float);
CODE:
	func   = INT2PTR(float(*)(double, float), SvIV(c_func) );
	RETVAL = (*func)(d0, f1);
OUTPUT:
	RETVAL

float
nci_fdt( c_func, d0, t1 )
	SV* c_func
	double d0
	char * t1
PREINIT:
	float(*func)(double, char *);
CODE:
	func   = INT2PTR(float(*)(double, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, t1);
OUTPUT:
	RETVAL

float
nci_fdi( c_func, d0, i1 )
	SV* c_func
	double d0
	int i1
PREINIT:
	float(*func)(double, int);
CODE:
	func   = INT2PTR(float(*)(double, int), SvIV(c_func) );
	RETVAL = (*func)(d0, i1);
OUTPUT:
	RETVAL

float
nci_fsp( c_func, s0, p1 )
	SV* c_func
	short s0
	void * p1
PREINIT:
	float(*func)(short, void *);
CODE:
	func   = INT2PTR(float(*)(short, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, p1);
OUTPUT:
	RETVAL

float
nci_fsd( c_func, s0, d1 )
	SV* c_func
	short s0
	double d1
PREINIT:
	float(*func)(short, double);
CODE:
	func   = INT2PTR(float(*)(short, double), SvIV(c_func) );
	RETVAL = (*func)(s0, d1);
OUTPUT:
	RETVAL

float
nci_fss( c_func, s0, s1 )
	SV* c_func
	short s0
	short s1
PREINIT:
	float(*func)(short, short);
CODE:
	func   = INT2PTR(float(*)(short, short), SvIV(c_func) );
	RETVAL = (*func)(s0, s1);
OUTPUT:
	RETVAL

float
nci_fsf( c_func, s0, f1 )
	SV* c_func
	short s0
	float f1
PREINIT:
	float(*func)(short, float);
CODE:
	func   = INT2PTR(float(*)(short, float), SvIV(c_func) );
	RETVAL = (*func)(s0, f1);
OUTPUT:
	RETVAL

float
nci_fst( c_func, s0, t1 )
	SV* c_func
	short s0
	char * t1
PREINIT:
	float(*func)(short, char *);
CODE:
	func   = INT2PTR(float(*)(short, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, t1);
OUTPUT:
	RETVAL

float
nci_fsi( c_func, s0, i1 )
	SV* c_func
	short s0
	int i1
PREINIT:
	float(*func)(short, int);
CODE:
	func   = INT2PTR(float(*)(short, int), SvIV(c_func) );
	RETVAL = (*func)(s0, i1);
OUTPUT:
	RETVAL

float
nci_ffp( c_func, f0, p1 )
	SV* c_func
	float f0
	void * p1
PREINIT:
	float(*func)(float, void *);
CODE:
	func   = INT2PTR(float(*)(float, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, p1);
OUTPUT:
	RETVAL

float
nci_ffd( c_func, f0, d1 )
	SV* c_func
	float f0
	double d1
PREINIT:
	float(*func)(float, double);
CODE:
	func   = INT2PTR(float(*)(float, double), SvIV(c_func) );
	RETVAL = (*func)(f0, d1);
OUTPUT:
	RETVAL

float
nci_ffs( c_func, f0, s1 )
	SV* c_func
	float f0
	short s1
PREINIT:
	float(*func)(float, short);
CODE:
	func   = INT2PTR(float(*)(float, short), SvIV(c_func) );
	RETVAL = (*func)(f0, s1);
OUTPUT:
	RETVAL

float
nci_fff( c_func, f0, f1 )
	SV* c_func
	float f0
	float f1
PREINIT:
	float(*func)(float, float);
CODE:
	func   = INT2PTR(float(*)(float, float), SvIV(c_func) );
	RETVAL = (*func)(f0, f1);
OUTPUT:
	RETVAL

float
nci_fft( c_func, f0, t1 )
	SV* c_func
	float f0
	char * t1
PREINIT:
	float(*func)(float, char *);
CODE:
	func   = INT2PTR(float(*)(float, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, t1);
OUTPUT:
	RETVAL

float
nci_ffi( c_func, f0, i1 )
	SV* c_func
	float f0
	int i1
PREINIT:
	float(*func)(float, int);
CODE:
	func   = INT2PTR(float(*)(float, int), SvIV(c_func) );
	RETVAL = (*func)(f0, i1);
OUTPUT:
	RETVAL

float
nci_ftp( c_func, t0, p1 )
	SV* c_func
	char * t0
	void * p1
PREINIT:
	float(*func)(char *, void *);
CODE:
	func   = INT2PTR(float(*)(char *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, p1);
OUTPUT:
	RETVAL

float
nci_ftd( c_func, t0, d1 )
	SV* c_func
	char * t0
	double d1
PREINIT:
	float(*func)(char *, double);
CODE:
	func   = INT2PTR(float(*)(char *, double), SvIV(c_func) );
	RETVAL = (*func)(t0, d1);
OUTPUT:
	RETVAL

float
nci_fts( c_func, t0, s1 )
	SV* c_func
	char * t0
	short s1
PREINIT:
	float(*func)(char *, short);
CODE:
	func   = INT2PTR(float(*)(char *, short), SvIV(c_func) );
	RETVAL = (*func)(t0, s1);
OUTPUT:
	RETVAL

float
nci_ftf( c_func, t0, f1 )
	SV* c_func
	char * t0
	float f1
PREINIT:
	float(*func)(char *, float);
CODE:
	func   = INT2PTR(float(*)(char *, float), SvIV(c_func) );
	RETVAL = (*func)(t0, f1);
OUTPUT:
	RETVAL

float
nci_ftt( c_func, t0, t1 )
	SV* c_func
	char * t0
	char * t1
PREINIT:
	float(*func)(char *, char *);
CODE:
	func   = INT2PTR(float(*)(char *, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, t1);
OUTPUT:
	RETVAL

float
nci_fti( c_func, t0, i1 )
	SV* c_func
	char * t0
	int i1
PREINIT:
	float(*func)(char *, int);
CODE:
	func   = INT2PTR(float(*)(char *, int), SvIV(c_func) );
	RETVAL = (*func)(t0, i1);
OUTPUT:
	RETVAL

float
nci_fip( c_func, i0, p1 )
	SV* c_func
	int i0
	void * p1
PREINIT:
	float(*func)(int, void *);
CODE:
	func   = INT2PTR(float(*)(int, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, p1);
OUTPUT:
	RETVAL

float
nci_fid( c_func, i0, d1 )
	SV* c_func
	int i0
	double d1
PREINIT:
	float(*func)(int, double);
CODE:
	func   = INT2PTR(float(*)(int, double), SvIV(c_func) );
	RETVAL = (*func)(i0, d1);
OUTPUT:
	RETVAL

float
nci_fis( c_func, i0, s1 )
	SV* c_func
	int i0
	short s1
PREINIT:
	float(*func)(int, short);
CODE:
	func   = INT2PTR(float(*)(int, short), SvIV(c_func) );
	RETVAL = (*func)(i0, s1);
OUTPUT:
	RETVAL

float
nci_fif( c_func, i0, f1 )
	SV* c_func
	int i0
	float f1
PREINIT:
	float(*func)(int, float);
CODE:
	func   = INT2PTR(float(*)(int, float), SvIV(c_func) );
	RETVAL = (*func)(i0, f1);
OUTPUT:
	RETVAL

float
nci_fit( c_func, i0, t1 )
	SV* c_func
	int i0
	char * t1
PREINIT:
	float(*func)(int, char *);
CODE:
	func   = INT2PTR(float(*)(int, char *), SvIV(c_func) );
	RETVAL = (*func)(i0, t1);
OUTPUT:
	RETVAL

float
nci_fii( c_func, i0, i1 )
	SV* c_func
	int i0
	int i1
PREINIT:
	float(*func)(int, int);
CODE:
	func   = INT2PTR(float(*)(int, int), SvIV(c_func) );
	RETVAL = (*func)(i0, i1);
OUTPUT:
	RETVAL

char *
nci_tpp( c_func, p0, p1 )
	SV* c_func
	void * p0
	void * p1
PREINIT:
	char *(*func)(void *, void *);
CODE:
	func   = INT2PTR(char *(*)(void *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, p1);
OUTPUT:
	RETVAL

char *
nci_tpd( c_func, p0, d1 )
	SV* c_func
	void * p0
	double d1
PREINIT:
	char *(*func)(void *, double);
CODE:
	func   = INT2PTR(char *(*)(void *, double), SvIV(c_func) );
	RETVAL = (*func)(p0, d1);
OUTPUT:
	RETVAL

char *
nci_tps( c_func, p0, s1 )
	SV* c_func
	void * p0
	short s1
PREINIT:
	char *(*func)(void *, short);
CODE:
	func   = INT2PTR(char *(*)(void *, short), SvIV(c_func) );
	RETVAL = (*func)(p0, s1);
OUTPUT:
	RETVAL

char *
nci_tpf( c_func, p0, f1 )
	SV* c_func
	void * p0
	float f1
PREINIT:
	char *(*func)(void *, float);
CODE:
	func   = INT2PTR(char *(*)(void *, float), SvIV(c_func) );
	RETVAL = (*func)(p0, f1);
OUTPUT:
	RETVAL

char *
nci_tpt( c_func, p0, t1 )
	SV* c_func
	void * p0
	char * t1
PREINIT:
	char *(*func)(void *, char *);
CODE:
	func   = INT2PTR(char *(*)(void *, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, t1);
OUTPUT:
	RETVAL

char *
nci_tpi( c_func, p0, i1 )
	SV* c_func
	void * p0
	int i1
PREINIT:
	char *(*func)(void *, int);
CODE:
	func   = INT2PTR(char *(*)(void *, int), SvIV(c_func) );
	RETVAL = (*func)(p0, i1);
OUTPUT:
	RETVAL

char *
nci_tdp( c_func, d0, p1 )
	SV* c_func
	double d0
	void * p1
PREINIT:
	char *(*func)(double, void *);
CODE:
	func   = INT2PTR(char *(*)(double, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, p1);
OUTPUT:
	RETVAL

char *
nci_tdd( c_func, d0, d1 )
	SV* c_func
	double d0
	double d1
PREINIT:
	char *(*func)(double, double);
CODE:
	func   = INT2PTR(char *(*)(double, double), SvIV(c_func) );
	RETVAL = (*func)(d0, d1);
OUTPUT:
	RETVAL

char *
nci_tds( c_func, d0, s1 )
	SV* c_func
	double d0
	short s1
PREINIT:
	char *(*func)(double, short);
CODE:
	func   = INT2PTR(char *(*)(double, short), SvIV(c_func) );
	RETVAL = (*func)(d0, s1);
OUTPUT:
	RETVAL

char *
nci_tdf( c_func, d0, f1 )
	SV* c_func
	double d0
	float f1
PREINIT:
	char *(*func)(double, float);
CODE:
	func   = INT2PTR(char *(*)(double, float), SvIV(c_func) );
	RETVAL = (*func)(d0, f1);
OUTPUT:
	RETVAL

char *
nci_tdt( c_func, d0, t1 )
	SV* c_func
	double d0
	char * t1
PREINIT:
	char *(*func)(double, char *);
CODE:
	func   = INT2PTR(char *(*)(double, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, t1);
OUTPUT:
	RETVAL

char *
nci_tdi( c_func, d0, i1 )
	SV* c_func
	double d0
	int i1
PREINIT:
	char *(*func)(double, int);
CODE:
	func   = INT2PTR(char *(*)(double, int), SvIV(c_func) );
	RETVAL = (*func)(d0, i1);
OUTPUT:
	RETVAL

char *
nci_tsp( c_func, s0, p1 )
	SV* c_func
	short s0
	void * p1
PREINIT:
	char *(*func)(short, void *);
CODE:
	func   = INT2PTR(char *(*)(short, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, p1);
OUTPUT:
	RETVAL

char *
nci_tsd( c_func, s0, d1 )
	SV* c_func
	short s0
	double d1
PREINIT:
	char *(*func)(short, double);
CODE:
	func   = INT2PTR(char *(*)(short, double), SvIV(c_func) );
	RETVAL = (*func)(s0, d1);
OUTPUT:
	RETVAL

char *
nci_tss( c_func, s0, s1 )
	SV* c_func
	short s0
	short s1
PREINIT:
	char *(*func)(short, short);
CODE:
	func   = INT2PTR(char *(*)(short, short), SvIV(c_func) );
	RETVAL = (*func)(s0, s1);
OUTPUT:
	RETVAL

char *
nci_tsf( c_func, s0, f1 )
	SV* c_func
	short s0
	float f1
PREINIT:
	char *(*func)(short, float);
CODE:
	func   = INT2PTR(char *(*)(short, float), SvIV(c_func) );
	RETVAL = (*func)(s0, f1);
OUTPUT:
	RETVAL

char *
nci_tst( c_func, s0, t1 )
	SV* c_func
	short s0
	char * t1
PREINIT:
	char *(*func)(short, char *);
CODE:
	func   = INT2PTR(char *(*)(short, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, t1);
OUTPUT:
	RETVAL

char *
nci_tsi( c_func, s0, i1 )
	SV* c_func
	short s0
	int i1
PREINIT:
	char *(*func)(short, int);
CODE:
	func   = INT2PTR(char *(*)(short, int), SvIV(c_func) );
	RETVAL = (*func)(s0, i1);
OUTPUT:
	RETVAL

char *
nci_tfp( c_func, f0, p1 )
	SV* c_func
	float f0
	void * p1
PREINIT:
	char *(*func)(float, void *);
CODE:
	func   = INT2PTR(char *(*)(float, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, p1);
OUTPUT:
	RETVAL

char *
nci_tfd( c_func, f0, d1 )
	SV* c_func
	float f0
	double d1
PREINIT:
	char *(*func)(float, double);
CODE:
	func   = INT2PTR(char *(*)(float, double), SvIV(c_func) );
	RETVAL = (*func)(f0, d1);
OUTPUT:
	RETVAL

char *
nci_tfs( c_func, f0, s1 )
	SV* c_func
	float f0
	short s1
PREINIT:
	char *(*func)(float, short);
CODE:
	func   = INT2PTR(char *(*)(float, short), SvIV(c_func) );
	RETVAL = (*func)(f0, s1);
OUTPUT:
	RETVAL

char *
nci_tff( c_func, f0, f1 )
	SV* c_func
	float f0
	float f1
PREINIT:
	char *(*func)(float, float);
CODE:
	func   = INT2PTR(char *(*)(float, float), SvIV(c_func) );
	RETVAL = (*func)(f0, f1);
OUTPUT:
	RETVAL

char *
nci_tft( c_func, f0, t1 )
	SV* c_func
	float f0
	char * t1
PREINIT:
	char *(*func)(float, char *);
CODE:
	func   = INT2PTR(char *(*)(float, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, t1);
OUTPUT:
	RETVAL

char *
nci_tfi( c_func, f0, i1 )
	SV* c_func
	float f0
	int i1
PREINIT:
	char *(*func)(float, int);
CODE:
	func   = INT2PTR(char *(*)(float, int), SvIV(c_func) );
	RETVAL = (*func)(f0, i1);
OUTPUT:
	RETVAL

char *
nci_ttp( c_func, t0, p1 )
	SV* c_func
	char * t0
	void * p1
PREINIT:
	char *(*func)(char *, void *);
CODE:
	func   = INT2PTR(char *(*)(char *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, p1);
OUTPUT:
	RETVAL

char *
nci_ttd( c_func, t0, d1 )
	SV* c_func
	char * t0
	double d1
PREINIT:
	char *(*func)(char *, double);
CODE:
	func   = INT2PTR(char *(*)(char *, double), SvIV(c_func) );
	RETVAL = (*func)(t0, d1);
OUTPUT:
	RETVAL

char *
nci_tts( c_func, t0, s1 )
	SV* c_func
	char * t0
	short s1
PREINIT:
	char *(*func)(char *, short);
CODE:
	func   = INT2PTR(char *(*)(char *, short), SvIV(c_func) );
	RETVAL = (*func)(t0, s1);
OUTPUT:
	RETVAL

char *
nci_ttf( c_func, t0, f1 )
	SV* c_func
	char * t0
	float f1
PREINIT:
	char *(*func)(char *, float);
CODE:
	func   = INT2PTR(char *(*)(char *, float), SvIV(c_func) );
	RETVAL = (*func)(t0, f1);
OUTPUT:
	RETVAL

char *
nci_ttt( c_func, t0, t1 )
	SV* c_func
	char * t0
	char * t1
PREINIT:
	char *(*func)(char *, char *);
CODE:
	func   = INT2PTR(char *(*)(char *, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, t1);
OUTPUT:
	RETVAL

char *
nci_tti( c_func, t0, i1 )
	SV* c_func
	char * t0
	int i1
PREINIT:
	char *(*func)(char *, int);
CODE:
	func   = INT2PTR(char *(*)(char *, int), SvIV(c_func) );
	RETVAL = (*func)(t0, i1);
OUTPUT:
	RETVAL

char *
nci_tip( c_func, i0, p1 )
	SV* c_func
	int i0
	void * p1
PREINIT:
	char *(*func)(int, void *);
CODE:
	func   = INT2PTR(char *(*)(int, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, p1);
OUTPUT:
	RETVAL

char *
nci_tid( c_func, i0, d1 )
	SV* c_func
	int i0
	double d1
PREINIT:
	char *(*func)(int, double);
CODE:
	func   = INT2PTR(char *(*)(int, double), SvIV(c_func) );
	RETVAL = (*func)(i0, d1);
OUTPUT:
	RETVAL

char *
nci_tis( c_func, i0, s1 )
	SV* c_func
	int i0
	short s1
PREINIT:
	char *(*func)(int, short);
CODE:
	func   = INT2PTR(char *(*)(int, short), SvIV(c_func) );
	RETVAL = (*func)(i0, s1);
OUTPUT:
	RETVAL

char *
nci_tif( c_func, i0, f1 )
	SV* c_func
	int i0
	float f1
PREINIT:
	char *(*func)(int, float);
CODE:
	func   = INT2PTR(char *(*)(int, float), SvIV(c_func) );
	RETVAL = (*func)(i0, f1);
OUTPUT:
	RETVAL

char *
nci_tit( c_func, i0, t1 )
	SV* c_func
	int i0
	char * t1
PREINIT:
	char *(*func)(int, char *);
CODE:
	func   = INT2PTR(char *(*)(int, char *), SvIV(c_func) );
	RETVAL = (*func)(i0, t1);
OUTPUT:
	RETVAL

char *
nci_tii( c_func, i0, i1 )
	SV* c_func
	int i0
	int i1
PREINIT:
	char *(*func)(int, int);
CODE:
	func   = INT2PTR(char *(*)(int, int), SvIV(c_func) );
	RETVAL = (*func)(i0, i1);
OUTPUT:
	RETVAL

int
nci_ipp( c_func, p0, p1 )
	SV* c_func
	void * p0
	void * p1
PREINIT:
	int(*func)(void *, void *);
CODE:
	func   = INT2PTR(int(*)(void *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, p1);
OUTPUT:
	RETVAL

int
nci_ipd( c_func, p0, d1 )
	SV* c_func
	void * p0
	double d1
PREINIT:
	int(*func)(void *, double);
CODE:
	func   = INT2PTR(int(*)(void *, double), SvIV(c_func) );
	RETVAL = (*func)(p0, d1);
OUTPUT:
	RETVAL

int
nci_ips( c_func, p0, s1 )
	SV* c_func
	void * p0
	short s1
PREINIT:
	int(*func)(void *, short);
CODE:
	func   = INT2PTR(int(*)(void *, short), SvIV(c_func) );
	RETVAL = (*func)(p0, s1);
OUTPUT:
	RETVAL

int
nci_ipf( c_func, p0, f1 )
	SV* c_func
	void * p0
	float f1
PREINIT:
	int(*func)(void *, float);
CODE:
	func   = INT2PTR(int(*)(void *, float), SvIV(c_func) );
	RETVAL = (*func)(p0, f1);
OUTPUT:
	RETVAL

int
nci_ipt( c_func, p0, t1 )
	SV* c_func
	void * p0
	char * t1
PREINIT:
	int(*func)(void *, char *);
CODE:
	func   = INT2PTR(int(*)(void *, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, t1);
OUTPUT:
	RETVAL

int
nci_ipi( c_func, p0, i1 )
	SV* c_func
	void * p0
	int i1
PREINIT:
	int(*func)(void *, int);
CODE:
	func   = INT2PTR(int(*)(void *, int), SvIV(c_func) );
	RETVAL = (*func)(p0, i1);
OUTPUT:
	RETVAL

int
nci_idp( c_func, d0, p1 )
	SV* c_func
	double d0
	void * p1
PREINIT:
	int(*func)(double, void *);
CODE:
	func   = INT2PTR(int(*)(double, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, p1);
OUTPUT:
	RETVAL

int
nci_idd( c_func, d0, d1 )
	SV* c_func
	double d0
	double d1
PREINIT:
	int(*func)(double, double);
CODE:
	func   = INT2PTR(int(*)(double, double), SvIV(c_func) );
	RETVAL = (*func)(d0, d1);
OUTPUT:
	RETVAL

int
nci_ids( c_func, d0, s1 )
	SV* c_func
	double d0
	short s1
PREINIT:
	int(*func)(double, short);
CODE:
	func   = INT2PTR(int(*)(double, short), SvIV(c_func) );
	RETVAL = (*func)(d0, s1);
OUTPUT:
	RETVAL

int
nci_idf( c_func, d0, f1 )
	SV* c_func
	double d0
	float f1
PREINIT:
	int(*func)(double, float);
CODE:
	func   = INT2PTR(int(*)(double, float), SvIV(c_func) );
	RETVAL = (*func)(d0, f1);
OUTPUT:
	RETVAL

int
nci_idt( c_func, d0, t1 )
	SV* c_func
	double d0
	char * t1
PREINIT:
	int(*func)(double, char *);
CODE:
	func   = INT2PTR(int(*)(double, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, t1);
OUTPUT:
	RETVAL

int
nci_idi( c_func, d0, i1 )
	SV* c_func
	double d0
	int i1
PREINIT:
	int(*func)(double, int);
CODE:
	func   = INT2PTR(int(*)(double, int), SvIV(c_func) );
	RETVAL = (*func)(d0, i1);
OUTPUT:
	RETVAL

int
nci_isp( c_func, s0, p1 )
	SV* c_func
	short s0
	void * p1
PREINIT:
	int(*func)(short, void *);
CODE:
	func   = INT2PTR(int(*)(short, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, p1);
OUTPUT:
	RETVAL

int
nci_isd( c_func, s0, d1 )
	SV* c_func
	short s0
	double d1
PREINIT:
	int(*func)(short, double);
CODE:
	func   = INT2PTR(int(*)(short, double), SvIV(c_func) );
	RETVAL = (*func)(s0, d1);
OUTPUT:
	RETVAL

int
nci_iss( c_func, s0, s1 )
	SV* c_func
	short s0
	short s1
PREINIT:
	int(*func)(short, short);
CODE:
	func   = INT2PTR(int(*)(short, short), SvIV(c_func) );
	RETVAL = (*func)(s0, s1);
OUTPUT:
	RETVAL

int
nci_isf( c_func, s0, f1 )
	SV* c_func
	short s0
	float f1
PREINIT:
	int(*func)(short, float);
CODE:
	func   = INT2PTR(int(*)(short, float), SvIV(c_func) );
	RETVAL = (*func)(s0, f1);
OUTPUT:
	RETVAL

int
nci_ist( c_func, s0, t1 )
	SV* c_func
	short s0
	char * t1
PREINIT:
	int(*func)(short, char *);
CODE:
	func   = INT2PTR(int(*)(short, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, t1);
OUTPUT:
	RETVAL

int
nci_isi( c_func, s0, i1 )
	SV* c_func
	short s0
	int i1
PREINIT:
	int(*func)(short, int);
CODE:
	func   = INT2PTR(int(*)(short, int), SvIV(c_func) );
	RETVAL = (*func)(s0, i1);
OUTPUT:
	RETVAL

int
nci_ifp( c_func, f0, p1 )
	SV* c_func
	float f0
	void * p1
PREINIT:
	int(*func)(float, void *);
CODE:
	func   = INT2PTR(int(*)(float, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, p1);
OUTPUT:
	RETVAL

int
nci_ifd( c_func, f0, d1 )
	SV* c_func
	float f0
	double d1
PREINIT:
	int(*func)(float, double);
CODE:
	func   = INT2PTR(int(*)(float, double), SvIV(c_func) );
	RETVAL = (*func)(f0, d1);
OUTPUT:
	RETVAL

int
nci_ifs( c_func, f0, s1 )
	SV* c_func
	float f0
	short s1
PREINIT:
	int(*func)(float, short);
CODE:
	func   = INT2PTR(int(*)(float, short), SvIV(c_func) );
	RETVAL = (*func)(f0, s1);
OUTPUT:
	RETVAL

int
nci_iff( c_func, f0, f1 )
	SV* c_func
	float f0
	float f1
PREINIT:
	int(*func)(float, float);
CODE:
	func   = INT2PTR(int(*)(float, float), SvIV(c_func) );
	RETVAL = (*func)(f0, f1);
OUTPUT:
	RETVAL

int
nci_ift( c_func, f0, t1 )
	SV* c_func
	float f0
	char * t1
PREINIT:
	int(*func)(float, char *);
CODE:
	func   = INT2PTR(int(*)(float, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, t1);
OUTPUT:
	RETVAL

int
nci_ifi( c_func, f0, i1 )
	SV* c_func
	float f0
	int i1
PREINIT:
	int(*func)(float, int);
CODE:
	func   = INT2PTR(int(*)(float, int), SvIV(c_func) );
	RETVAL = (*func)(f0, i1);
OUTPUT:
	RETVAL

int
nci_itp( c_func, t0, p1 )
	SV* c_func
	char * t0
	void * p1
PREINIT:
	int(*func)(char *, void *);
CODE:
	func   = INT2PTR(int(*)(char *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, p1);
OUTPUT:
	RETVAL

int
nci_itd( c_func, t0, d1 )
	SV* c_func
	char * t0
	double d1
PREINIT:
	int(*func)(char *, double);
CODE:
	func   = INT2PTR(int(*)(char *, double), SvIV(c_func) );
	RETVAL = (*func)(t0, d1);
OUTPUT:
	RETVAL

int
nci_its( c_func, t0, s1 )
	SV* c_func
	char * t0
	short s1
PREINIT:
	int(*func)(char *, short);
CODE:
	func   = INT2PTR(int(*)(char *, short), SvIV(c_func) );
	RETVAL = (*func)(t0, s1);
OUTPUT:
	RETVAL

int
nci_itf( c_func, t0, f1 )
	SV* c_func
	char * t0
	float f1
PREINIT:
	int(*func)(char *, float);
CODE:
	func   = INT2PTR(int(*)(char *, float), SvIV(c_func) );
	RETVAL = (*func)(t0, f1);
OUTPUT:
	RETVAL

int
nci_itt( c_func, t0, t1 )
	SV* c_func
	char * t0
	char * t1
PREINIT:
	int(*func)(char *, char *);
CODE:
	func   = INT2PTR(int(*)(char *, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, t1);
OUTPUT:
	RETVAL

int
nci_iti( c_func, t0, i1 )
	SV* c_func
	char * t0
	int i1
PREINIT:
	int(*func)(char *, int);
CODE:
	func   = INT2PTR(int(*)(char *, int), SvIV(c_func) );
	RETVAL = (*func)(t0, i1);
OUTPUT:
	RETVAL

int
nci_iip( c_func, i0, p1 )
	SV* c_func
	int i0
	void * p1
PREINIT:
	int(*func)(int, void *);
CODE:
	func   = INT2PTR(int(*)(int, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, p1);
OUTPUT:
	RETVAL

int
nci_iid( c_func, i0, d1 )
	SV* c_func
	int i0
	double d1
PREINIT:
	int(*func)(int, double);
CODE:
	func   = INT2PTR(int(*)(int, double), SvIV(c_func) );
	RETVAL = (*func)(i0, d1);
OUTPUT:
	RETVAL

int
nci_iis( c_func, i0, s1 )
	SV* c_func
	int i0
	short s1
PREINIT:
	int(*func)(int, short);
CODE:
	func   = INT2PTR(int(*)(int, short), SvIV(c_func) );
	RETVAL = (*func)(i0, s1);
OUTPUT:
	RETVAL

int
nci_iif( c_func, i0, f1 )
	SV* c_func
	int i0
	float f1
PREINIT:
	int(*func)(int, float);
CODE:
	func   = INT2PTR(int(*)(int, float), SvIV(c_func) );
	RETVAL = (*func)(i0, f1);
OUTPUT:
	RETVAL

int
nci_iit( c_func, i0, t1 )
	SV* c_func
	int i0
	char * t1
PREINIT:
	int(*func)(int, char *);
CODE:
	func   = INT2PTR(int(*)(int, char *), SvIV(c_func) );
	RETVAL = (*func)(i0, t1);
OUTPUT:
	RETVAL

int
nci_iii( c_func, i0, i1 )
	SV* c_func
	int i0
	int i1
PREINIT:
	int(*func)(int, int);
CODE:
	func   = INT2PTR(int(*)(int, int), SvIV(c_func) );
	RETVAL = (*func)(i0, i1);
OUTPUT:
	RETVAL

void
nci_vppp( c_func, p0, p1, p2 )
	SV* c_func
	void * p0
	void * p1
	void * p2
PREINIT:
	void(*func)(void *, void *, void *);
CODE:
	func   = INT2PTR(void(*)(void *, void *, void *), SvIV(c_func) );
	(*func)(p0, p1, p2);

void
nci_vppd( c_func, p0, p1, d2 )
	SV* c_func
	void * p0
	void * p1
	double d2
PREINIT:
	void(*func)(void *, void *, double);
CODE:
	func   = INT2PTR(void(*)(void *, void *, double), SvIV(c_func) );
	(*func)(p0, p1, d2);

void
nci_vpps( c_func, p0, p1, s2 )
	SV* c_func
	void * p0
	void * p1
	short s2
PREINIT:
	void(*func)(void *, void *, short);
CODE:
	func   = INT2PTR(void(*)(void *, void *, short), SvIV(c_func) );
	(*func)(p0, p1, s2);

void
nci_vppf( c_func, p0, p1, f2 )
	SV* c_func
	void * p0
	void * p1
	float f2
PREINIT:
	void(*func)(void *, void *, float);
CODE:
	func   = INT2PTR(void(*)(void *, void *, float), SvIV(c_func) );
	(*func)(p0, p1, f2);

void
nci_vppt( c_func, p0, p1, t2 )
	SV* c_func
	void * p0
	void * p1
	char * t2
PREINIT:
	void(*func)(void *, void *, char *);
CODE:
	func   = INT2PTR(void(*)(void *, void *, char *), SvIV(c_func) );
	(*func)(p0, p1, t2);

void
nci_vppi( c_func, p0, p1, i2 )
	SV* c_func
	void * p0
	void * p1
	int i2
PREINIT:
	void(*func)(void *, void *, int);
CODE:
	func   = INT2PTR(void(*)(void *, void *, int), SvIV(c_func) );
	(*func)(p0, p1, i2);

void
nci_vpdp( c_func, p0, d1, p2 )
	SV* c_func
	void * p0
	double d1
	void * p2
PREINIT:
	void(*func)(void *, double, void *);
CODE:
	func   = INT2PTR(void(*)(void *, double, void *), SvIV(c_func) );
	(*func)(p0, d1, p2);

void
nci_vpdd( c_func, p0, d1, d2 )
	SV* c_func
	void * p0
	double d1
	double d2
PREINIT:
	void(*func)(void *, double, double);
CODE:
	func   = INT2PTR(void(*)(void *, double, double), SvIV(c_func) );
	(*func)(p0, d1, d2);

void
nci_vpds( c_func, p0, d1, s2 )
	SV* c_func
	void * p0
	double d1
	short s2
PREINIT:
	void(*func)(void *, double, short);
CODE:
	func   = INT2PTR(void(*)(void *, double, short), SvIV(c_func) );
	(*func)(p0, d1, s2);

void
nci_vpdf( c_func, p0, d1, f2 )
	SV* c_func
	void * p0
	double d1
	float f2
PREINIT:
	void(*func)(void *, double, float);
CODE:
	func   = INT2PTR(void(*)(void *, double, float), SvIV(c_func) );
	(*func)(p0, d1, f2);

void
nci_vpdt( c_func, p0, d1, t2 )
	SV* c_func
	void * p0
	double d1
	char * t2
PREINIT:
	void(*func)(void *, double, char *);
CODE:
	func   = INT2PTR(void(*)(void *, double, char *), SvIV(c_func) );
	(*func)(p0, d1, t2);

void
nci_vpdi( c_func, p0, d1, i2 )
	SV* c_func
	void * p0
	double d1
	int i2
PREINIT:
	void(*func)(void *, double, int);
CODE:
	func   = INT2PTR(void(*)(void *, double, int), SvIV(c_func) );
	(*func)(p0, d1, i2);

void
nci_vpsp( c_func, p0, s1, p2 )
	SV* c_func
	void * p0
	short s1
	void * p2
PREINIT:
	void(*func)(void *, short, void *);
CODE:
	func   = INT2PTR(void(*)(void *, short, void *), SvIV(c_func) );
	(*func)(p0, s1, p2);

void
nci_vpsd( c_func, p0, s1, d2 )
	SV* c_func
	void * p0
	short s1
	double d2
PREINIT:
	void(*func)(void *, short, double);
CODE:
	func   = INT2PTR(void(*)(void *, short, double), SvIV(c_func) );
	(*func)(p0, s1, d2);

void
nci_vpss( c_func, p0, s1, s2 )
	SV* c_func
	void * p0
	short s1
	short s2
PREINIT:
	void(*func)(void *, short, short);
CODE:
	func   = INT2PTR(void(*)(void *, short, short), SvIV(c_func) );
	(*func)(p0, s1, s2);

void
nci_vpsf( c_func, p0, s1, f2 )
	SV* c_func
	void * p0
	short s1
	float f2
PREINIT:
	void(*func)(void *, short, float);
CODE:
	func   = INT2PTR(void(*)(void *, short, float), SvIV(c_func) );
	(*func)(p0, s1, f2);

void
nci_vpst( c_func, p0, s1, t2 )
	SV* c_func
	void * p0
	short s1
	char * t2
PREINIT:
	void(*func)(void *, short, char *);
CODE:
	func   = INT2PTR(void(*)(void *, short, char *), SvIV(c_func) );
	(*func)(p0, s1, t2);

void
nci_vpsi( c_func, p0, s1, i2 )
	SV* c_func
	void * p0
	short s1
	int i2
PREINIT:
	void(*func)(void *, short, int);
CODE:
	func   = INT2PTR(void(*)(void *, short, int), SvIV(c_func) );
	(*func)(p0, s1, i2);

void
nci_vpfp( c_func, p0, f1, p2 )
	SV* c_func
	void * p0
	float f1
	void * p2
PREINIT:
	void(*func)(void *, float, void *);
CODE:
	func   = INT2PTR(void(*)(void *, float, void *), SvIV(c_func) );
	(*func)(p0, f1, p2);

void
nci_vpfd( c_func, p0, f1, d2 )
	SV* c_func
	void * p0
	float f1
	double d2
PREINIT:
	void(*func)(void *, float, double);
CODE:
	func   = INT2PTR(void(*)(void *, float, double), SvIV(c_func) );
	(*func)(p0, f1, d2);

void
nci_vpfs( c_func, p0, f1, s2 )
	SV* c_func
	void * p0
	float f1
	short s2
PREINIT:
	void(*func)(void *, float, short);
CODE:
	func   = INT2PTR(void(*)(void *, float, short), SvIV(c_func) );
	(*func)(p0, f1, s2);

void
nci_vpff( c_func, p0, f1, f2 )
	SV* c_func
	void * p0
	float f1
	float f2
PREINIT:
	void(*func)(void *, float, float);
CODE:
	func   = INT2PTR(void(*)(void *, float, float), SvIV(c_func) );
	(*func)(p0, f1, f2);

void
nci_vpft( c_func, p0, f1, t2 )
	SV* c_func
	void * p0
	float f1
	char * t2
PREINIT:
	void(*func)(void *, float, char *);
CODE:
	func   = INT2PTR(void(*)(void *, float, char *), SvIV(c_func) );
	(*func)(p0, f1, t2);

void
nci_vpfi( c_func, p0, f1, i2 )
	SV* c_func
	void * p0
	float f1
	int i2
PREINIT:
	void(*func)(void *, float, int);
CODE:
	func   = INT2PTR(void(*)(void *, float, int), SvIV(c_func) );
	(*func)(p0, f1, i2);

void
nci_vptp( c_func, p0, t1, p2 )
	SV* c_func
	void * p0
	char * t1
	void * p2
PREINIT:
	void(*func)(void *, char *, void *);
CODE:
	func   = INT2PTR(void(*)(void *, char *, void *), SvIV(c_func) );
	(*func)(p0, t1, p2);

void
nci_vptd( c_func, p0, t1, d2 )
	SV* c_func
	void * p0
	char * t1
	double d2
PREINIT:
	void(*func)(void *, char *, double);
CODE:
	func   = INT2PTR(void(*)(void *, char *, double), SvIV(c_func) );
	(*func)(p0, t1, d2);

void
nci_vpts( c_func, p0, t1, s2 )
	SV* c_func
	void * p0
	char * t1
	short s2
PREINIT:
	void(*func)(void *, char *, short);
CODE:
	func   = INT2PTR(void(*)(void *, char *, short), SvIV(c_func) );
	(*func)(p0, t1, s2);

void
nci_vptf( c_func, p0, t1, f2 )
	SV* c_func
	void * p0
	char * t1
	float f2
PREINIT:
	void(*func)(void *, char *, float);
CODE:
	func   = INT2PTR(void(*)(void *, char *, float), SvIV(c_func) );
	(*func)(p0, t1, f2);

void
nci_vptt( c_func, p0, t1, t2 )
	SV* c_func
	void * p0
	char * t1
	char * t2
PREINIT:
	void(*func)(void *, char *, char *);
CODE:
	func   = INT2PTR(void(*)(void *, char *, char *), SvIV(c_func) );
	(*func)(p0, t1, t2);

void
nci_vpti( c_func, p0, t1, i2 )
	SV* c_func
	void * p0
	char * t1
	int i2
PREINIT:
	void(*func)(void *, char *, int);
CODE:
	func   = INT2PTR(void(*)(void *, char *, int), SvIV(c_func) );
	(*func)(p0, t1, i2);

void
nci_vpip( c_func, p0, i1, p2 )
	SV* c_func
	void * p0
	int i1
	void * p2
PREINIT:
	void(*func)(void *, int, void *);
CODE:
	func   = INT2PTR(void(*)(void *, int, void *), SvIV(c_func) );
	(*func)(p0, i1, p2);

void
nci_vpid( c_func, p0, i1, d2 )
	SV* c_func
	void * p0
	int i1
	double d2
PREINIT:
	void(*func)(void *, int, double);
CODE:
	func   = INT2PTR(void(*)(void *, int, double), SvIV(c_func) );
	(*func)(p0, i1, d2);

void
nci_vpis( c_func, p0, i1, s2 )
	SV* c_func
	void * p0
	int i1
	short s2
PREINIT:
	void(*func)(void *, int, short);
CODE:
	func   = INT2PTR(void(*)(void *, int, short), SvIV(c_func) );
	(*func)(p0, i1, s2);

void
nci_vpif( c_func, p0, i1, f2 )
	SV* c_func
	void * p0
	int i1
	float f2
PREINIT:
	void(*func)(void *, int, float);
CODE:
	func   = INT2PTR(void(*)(void *, int, float), SvIV(c_func) );
	(*func)(p0, i1, f2);

void
nci_vpit( c_func, p0, i1, t2 )
	SV* c_func
	void * p0
	int i1
	char * t2
PREINIT:
	void(*func)(void *, int, char *);
CODE:
	func   = INT2PTR(void(*)(void *, int, char *), SvIV(c_func) );
	(*func)(p0, i1, t2);

void
nci_vpii( c_func, p0, i1, i2 )
	SV* c_func
	void * p0
	int i1
	int i2
PREINIT:
	void(*func)(void *, int, int);
CODE:
	func   = INT2PTR(void(*)(void *, int, int), SvIV(c_func) );
	(*func)(p0, i1, i2);

void
nci_vdpp( c_func, d0, p1, p2 )
	SV* c_func
	double d0
	void * p1
	void * p2
PREINIT:
	void(*func)(double, void *, void *);
CODE:
	func   = INT2PTR(void(*)(double, void *, void *), SvIV(c_func) );
	(*func)(d0, p1, p2);

void
nci_vdpd( c_func, d0, p1, d2 )
	SV* c_func
	double d0
	void * p1
	double d2
PREINIT:
	void(*func)(double, void *, double);
CODE:
	func   = INT2PTR(void(*)(double, void *, double), SvIV(c_func) );
	(*func)(d0, p1, d2);

void
nci_vdps( c_func, d0, p1, s2 )
	SV* c_func
	double d0
	void * p1
	short s2
PREINIT:
	void(*func)(double, void *, short);
CODE:
	func   = INT2PTR(void(*)(double, void *, short), SvIV(c_func) );
	(*func)(d0, p1, s2);

void
nci_vdpf( c_func, d0, p1, f2 )
	SV* c_func
	double d0
	void * p1
	float f2
PREINIT:
	void(*func)(double, void *, float);
CODE:
	func   = INT2PTR(void(*)(double, void *, float), SvIV(c_func) );
	(*func)(d0, p1, f2);

void
nci_vdpt( c_func, d0, p1, t2 )
	SV* c_func
	double d0
	void * p1
	char * t2
PREINIT:
	void(*func)(double, void *, char *);
CODE:
	func   = INT2PTR(void(*)(double, void *, char *), SvIV(c_func) );
	(*func)(d0, p1, t2);

void
nci_vdpi( c_func, d0, p1, i2 )
	SV* c_func
	double d0
	void * p1
	int i2
PREINIT:
	void(*func)(double, void *, int);
CODE:
	func   = INT2PTR(void(*)(double, void *, int), SvIV(c_func) );
	(*func)(d0, p1, i2);

void
nci_vddp( c_func, d0, d1, p2 )
	SV* c_func
	double d0
	double d1
	void * p2
PREINIT:
	void(*func)(double, double, void *);
CODE:
	func   = INT2PTR(void(*)(double, double, void *), SvIV(c_func) );
	(*func)(d0, d1, p2);

void
nci_vddd( c_func, d0, d1, d2 )
	SV* c_func
	double d0
	double d1
	double d2
PREINIT:
	void(*func)(double, double, double);
CODE:
	func   = INT2PTR(void(*)(double, double, double), SvIV(c_func) );
	(*func)(d0, d1, d2);

void
nci_vdds( c_func, d0, d1, s2 )
	SV* c_func
	double d0
	double d1
	short s2
PREINIT:
	void(*func)(double, double, short);
CODE:
	func   = INT2PTR(void(*)(double, double, short), SvIV(c_func) );
	(*func)(d0, d1, s2);

void
nci_vddf( c_func, d0, d1, f2 )
	SV* c_func
	double d0
	double d1
	float f2
PREINIT:
	void(*func)(double, double, float);
CODE:
	func   = INT2PTR(void(*)(double, double, float), SvIV(c_func) );
	(*func)(d0, d1, f2);

void
nci_vddt( c_func, d0, d1, t2 )
	SV* c_func
	double d0
	double d1
	char * t2
PREINIT:
	void(*func)(double, double, char *);
CODE:
	func   = INT2PTR(void(*)(double, double, char *), SvIV(c_func) );
	(*func)(d0, d1, t2);

void
nci_vddi( c_func, d0, d1, i2 )
	SV* c_func
	double d0
	double d1
	int i2
PREINIT:
	void(*func)(double, double, int);
CODE:
	func   = INT2PTR(void(*)(double, double, int), SvIV(c_func) );
	(*func)(d0, d1, i2);

void
nci_vdsp( c_func, d0, s1, p2 )
	SV* c_func
	double d0
	short s1
	void * p2
PREINIT:
	void(*func)(double, short, void *);
CODE:
	func   = INT2PTR(void(*)(double, short, void *), SvIV(c_func) );
	(*func)(d0, s1, p2);

void
nci_vdsd( c_func, d0, s1, d2 )
	SV* c_func
	double d0
	short s1
	double d2
PREINIT:
	void(*func)(double, short, double);
CODE:
	func   = INT2PTR(void(*)(double, short, double), SvIV(c_func) );
	(*func)(d0, s1, d2);

void
nci_vdss( c_func, d0, s1, s2 )
	SV* c_func
	double d0
	short s1
	short s2
PREINIT:
	void(*func)(double, short, short);
CODE:
	func   = INT2PTR(void(*)(double, short, short), SvIV(c_func) );
	(*func)(d0, s1, s2);

void
nci_vdsf( c_func, d0, s1, f2 )
	SV* c_func
	double d0
	short s1
	float f2
PREINIT:
	void(*func)(double, short, float);
CODE:
	func   = INT2PTR(void(*)(double, short, float), SvIV(c_func) );
	(*func)(d0, s1, f2);

void
nci_vdst( c_func, d0, s1, t2 )
	SV* c_func
	double d0
	short s1
	char * t2
PREINIT:
	void(*func)(double, short, char *);
CODE:
	func   = INT2PTR(void(*)(double, short, char *), SvIV(c_func) );
	(*func)(d0, s1, t2);

void
nci_vdsi( c_func, d0, s1, i2 )
	SV* c_func
	double d0
	short s1
	int i2
PREINIT:
	void(*func)(double, short, int);
CODE:
	func   = INT2PTR(void(*)(double, short, int), SvIV(c_func) );
	(*func)(d0, s1, i2);

void
nci_vdfp( c_func, d0, f1, p2 )
	SV* c_func
	double d0
	float f1
	void * p2
PREINIT:
	void(*func)(double, float, void *);
CODE:
	func   = INT2PTR(void(*)(double, float, void *), SvIV(c_func) );
	(*func)(d0, f1, p2);

void
nci_vdfd( c_func, d0, f1, d2 )
	SV* c_func
	double d0
	float f1
	double d2
PREINIT:
	void(*func)(double, float, double);
CODE:
	func   = INT2PTR(void(*)(double, float, double), SvIV(c_func) );
	(*func)(d0, f1, d2);

void
nci_vdfs( c_func, d0, f1, s2 )
	SV* c_func
	double d0
	float f1
	short s2
PREINIT:
	void(*func)(double, float, short);
CODE:
	func   = INT2PTR(void(*)(double, float, short), SvIV(c_func) );
	(*func)(d0, f1, s2);

void
nci_vdff( c_func, d0, f1, f2 )
	SV* c_func
	double d0
	float f1
	float f2
PREINIT:
	void(*func)(double, float, float);
CODE:
	func   = INT2PTR(void(*)(double, float, float), SvIV(c_func) );
	(*func)(d0, f1, f2);

void
nci_vdft( c_func, d0, f1, t2 )
	SV* c_func
	double d0
	float f1
	char * t2
PREINIT:
	void(*func)(double, float, char *);
CODE:
	func   = INT2PTR(void(*)(double, float, char *), SvIV(c_func) );
	(*func)(d0, f1, t2);

void
nci_vdfi( c_func, d0, f1, i2 )
	SV* c_func
	double d0
	float f1
	int i2
PREINIT:
	void(*func)(double, float, int);
CODE:
	func   = INT2PTR(void(*)(double, float, int), SvIV(c_func) );
	(*func)(d0, f1, i2);

void
nci_vdtp( c_func, d0, t1, p2 )
	SV* c_func
	double d0
	char * t1
	void * p2
PREINIT:
	void(*func)(double, char *, void *);
CODE:
	func   = INT2PTR(void(*)(double, char *, void *), SvIV(c_func) );
	(*func)(d0, t1, p2);

void
nci_vdtd( c_func, d0, t1, d2 )
	SV* c_func
	double d0
	char * t1
	double d2
PREINIT:
	void(*func)(double, char *, double);
CODE:
	func   = INT2PTR(void(*)(double, char *, double), SvIV(c_func) );
	(*func)(d0, t1, d2);

void
nci_vdts( c_func, d0, t1, s2 )
	SV* c_func
	double d0
	char * t1
	short s2
PREINIT:
	void(*func)(double, char *, short);
CODE:
	func   = INT2PTR(void(*)(double, char *, short), SvIV(c_func) );
	(*func)(d0, t1, s2);

void
nci_vdtf( c_func, d0, t1, f2 )
	SV* c_func
	double d0
	char * t1
	float f2
PREINIT:
	void(*func)(double, char *, float);
CODE:
	func   = INT2PTR(void(*)(double, char *, float), SvIV(c_func) );
	(*func)(d0, t1, f2);

void
nci_vdtt( c_func, d0, t1, t2 )
	SV* c_func
	double d0
	char * t1
	char * t2
PREINIT:
	void(*func)(double, char *, char *);
CODE:
	func   = INT2PTR(void(*)(double, char *, char *), SvIV(c_func) );
	(*func)(d0, t1, t2);

void
nci_vdti( c_func, d0, t1, i2 )
	SV* c_func
	double d0
	char * t1
	int i2
PREINIT:
	void(*func)(double, char *, int);
CODE:
	func   = INT2PTR(void(*)(double, char *, int), SvIV(c_func) );
	(*func)(d0, t1, i2);

void
nci_vdip( c_func, d0, i1, p2 )
	SV* c_func
	double d0
	int i1
	void * p2
PREINIT:
	void(*func)(double, int, void *);
CODE:
	func   = INT2PTR(void(*)(double, int, void *), SvIV(c_func) );
	(*func)(d0, i1, p2);

void
nci_vdid( c_func, d0, i1, d2 )
	SV* c_func
	double d0
	int i1
	double d2
PREINIT:
	void(*func)(double, int, double);
CODE:
	func   = INT2PTR(void(*)(double, int, double), SvIV(c_func) );
	(*func)(d0, i1, d2);

void
nci_vdis( c_func, d0, i1, s2 )
	SV* c_func
	double d0
	int i1
	short s2
PREINIT:
	void(*func)(double, int, short);
CODE:
	func   = INT2PTR(void(*)(double, int, short), SvIV(c_func) );
	(*func)(d0, i1, s2);

void
nci_vdif( c_func, d0, i1, f2 )
	SV* c_func
	double d0
	int i1
	float f2
PREINIT:
	void(*func)(double, int, float);
CODE:
	func   = INT2PTR(void(*)(double, int, float), SvIV(c_func) );
	(*func)(d0, i1, f2);

void
nci_vdit( c_func, d0, i1, t2 )
	SV* c_func
	double d0
	int i1
	char * t2
PREINIT:
	void(*func)(double, int, char *);
CODE:
	func   = INT2PTR(void(*)(double, int, char *), SvIV(c_func) );
	(*func)(d0, i1, t2);

void
nci_vdii( c_func, d0, i1, i2 )
	SV* c_func
	double d0
	int i1
	int i2
PREINIT:
	void(*func)(double, int, int);
CODE:
	func   = INT2PTR(void(*)(double, int, int), SvIV(c_func) );
	(*func)(d0, i1, i2);

void
nci_vspp( c_func, s0, p1, p2 )
	SV* c_func
	short s0
	void * p1
	void * p2
PREINIT:
	void(*func)(short, void *, void *);
CODE:
	func   = INT2PTR(void(*)(short, void *, void *), SvIV(c_func) );
	(*func)(s0, p1, p2);

void
nci_vspd( c_func, s0, p1, d2 )
	SV* c_func
	short s0
	void * p1
	double d2
PREINIT:
	void(*func)(short, void *, double);
CODE:
	func   = INT2PTR(void(*)(short, void *, double), SvIV(c_func) );
	(*func)(s0, p1, d2);

void
nci_vsps( c_func, s0, p1, s2 )
	SV* c_func
	short s0
	void * p1
	short s2
PREINIT:
	void(*func)(short, void *, short);
CODE:
	func   = INT2PTR(void(*)(short, void *, short), SvIV(c_func) );
	(*func)(s0, p1, s2);

void
nci_vspf( c_func, s0, p1, f2 )
	SV* c_func
	short s0
	void * p1
	float f2
PREINIT:
	void(*func)(short, void *, float);
CODE:
	func   = INT2PTR(void(*)(short, void *, float), SvIV(c_func) );
	(*func)(s0, p1, f2);

void
nci_vspt( c_func, s0, p1, t2 )
	SV* c_func
	short s0
	void * p1
	char * t2
PREINIT:
	void(*func)(short, void *, char *);
CODE:
	func   = INT2PTR(void(*)(short, void *, char *), SvIV(c_func) );
	(*func)(s0, p1, t2);

void
nci_vspi( c_func, s0, p1, i2 )
	SV* c_func
	short s0
	void * p1
	int i2
PREINIT:
	void(*func)(short, void *, int);
CODE:
	func   = INT2PTR(void(*)(short, void *, int), SvIV(c_func) );
	(*func)(s0, p1, i2);

void
nci_vsdp( c_func, s0, d1, p2 )
	SV* c_func
	short s0
	double d1
	void * p2
PREINIT:
	void(*func)(short, double, void *);
CODE:
	func   = INT2PTR(void(*)(short, double, void *), SvIV(c_func) );
	(*func)(s0, d1, p2);

void
nci_vsdd( c_func, s0, d1, d2 )
	SV* c_func
	short s0
	double d1
	double d2
PREINIT:
	void(*func)(short, double, double);
CODE:
	func   = INT2PTR(void(*)(short, double, double), SvIV(c_func) );
	(*func)(s0, d1, d2);

void
nci_vsds( c_func, s0, d1, s2 )
	SV* c_func
	short s0
	double d1
	short s2
PREINIT:
	void(*func)(short, double, short);
CODE:
	func   = INT2PTR(void(*)(short, double, short), SvIV(c_func) );
	(*func)(s0, d1, s2);

void
nci_vsdf( c_func, s0, d1, f2 )
	SV* c_func
	short s0
	double d1
	float f2
PREINIT:
	void(*func)(short, double, float);
CODE:
	func   = INT2PTR(void(*)(short, double, float), SvIV(c_func) );
	(*func)(s0, d1, f2);

void
nci_vsdt( c_func, s0, d1, t2 )
	SV* c_func
	short s0
	double d1
	char * t2
PREINIT:
	void(*func)(short, double, char *);
CODE:
	func   = INT2PTR(void(*)(short, double, char *), SvIV(c_func) );
	(*func)(s0, d1, t2);

void
nci_vsdi( c_func, s0, d1, i2 )
	SV* c_func
	short s0
	double d1
	int i2
PREINIT:
	void(*func)(short, double, int);
CODE:
	func   = INT2PTR(void(*)(short, double, int), SvIV(c_func) );
	(*func)(s0, d1, i2);

void
nci_vssp( c_func, s0, s1, p2 )
	SV* c_func
	short s0
	short s1
	void * p2
PREINIT:
	void(*func)(short, short, void *);
CODE:
	func   = INT2PTR(void(*)(short, short, void *), SvIV(c_func) );
	(*func)(s0, s1, p2);

void
nci_vssd( c_func, s0, s1, d2 )
	SV* c_func
	short s0
	short s1
	double d2
PREINIT:
	void(*func)(short, short, double);
CODE:
	func   = INT2PTR(void(*)(short, short, double), SvIV(c_func) );
	(*func)(s0, s1, d2);

void
nci_vsss( c_func, s0, s1, s2 )
	SV* c_func
	short s0
	short s1
	short s2
PREINIT:
	void(*func)(short, short, short);
CODE:
	func   = INT2PTR(void(*)(short, short, short), SvIV(c_func) );
	(*func)(s0, s1, s2);

void
nci_vssf( c_func, s0, s1, f2 )
	SV* c_func
	short s0
	short s1
	float f2
PREINIT:
	void(*func)(short, short, float);
CODE:
	func   = INT2PTR(void(*)(short, short, float), SvIV(c_func) );
	(*func)(s0, s1, f2);

void
nci_vsst( c_func, s0, s1, t2 )
	SV* c_func
	short s0
	short s1
	char * t2
PREINIT:
	void(*func)(short, short, char *);
CODE:
	func   = INT2PTR(void(*)(short, short, char *), SvIV(c_func) );
	(*func)(s0, s1, t2);

void
nci_vssi( c_func, s0, s1, i2 )
	SV* c_func
	short s0
	short s1
	int i2
PREINIT:
	void(*func)(short, short, int);
CODE:
	func   = INT2PTR(void(*)(short, short, int), SvIV(c_func) );
	(*func)(s0, s1, i2);

void
nci_vsfp( c_func, s0, f1, p2 )
	SV* c_func
	short s0
	float f1
	void * p2
PREINIT:
	void(*func)(short, float, void *);
CODE:
	func   = INT2PTR(void(*)(short, float, void *), SvIV(c_func) );
	(*func)(s0, f1, p2);

void
nci_vsfd( c_func, s0, f1, d2 )
	SV* c_func
	short s0
	float f1
	double d2
PREINIT:
	void(*func)(short, float, double);
CODE:
	func   = INT2PTR(void(*)(short, float, double), SvIV(c_func) );
	(*func)(s0, f1, d2);

void
nci_vsfs( c_func, s0, f1, s2 )
	SV* c_func
	short s0
	float f1
	short s2
PREINIT:
	void(*func)(short, float, short);
CODE:
	func   = INT2PTR(void(*)(short, float, short), SvIV(c_func) );
	(*func)(s0, f1, s2);

void
nci_vsff( c_func, s0, f1, f2 )
	SV* c_func
	short s0
	float f1
	float f2
PREINIT:
	void(*func)(short, float, float);
CODE:
	func   = INT2PTR(void(*)(short, float, float), SvIV(c_func) );
	(*func)(s0, f1, f2);

void
nci_vsft( c_func, s0, f1, t2 )
	SV* c_func
	short s0
	float f1
	char * t2
PREINIT:
	void(*func)(short, float, char *);
CODE:
	func   = INT2PTR(void(*)(short, float, char *), SvIV(c_func) );
	(*func)(s0, f1, t2);

void
nci_vsfi( c_func, s0, f1, i2 )
	SV* c_func
	short s0
	float f1
	int i2
PREINIT:
	void(*func)(short, float, int);
CODE:
	func   = INT2PTR(void(*)(short, float, int), SvIV(c_func) );
	(*func)(s0, f1, i2);

void
nci_vstp( c_func, s0, t1, p2 )
	SV* c_func
	short s0
	char * t1
	void * p2
PREINIT:
	void(*func)(short, char *, void *);
CODE:
	func   = INT2PTR(void(*)(short, char *, void *), SvIV(c_func) );
	(*func)(s0, t1, p2);

void
nci_vstd( c_func, s0, t1, d2 )
	SV* c_func
	short s0
	char * t1
	double d2
PREINIT:
	void(*func)(short, char *, double);
CODE:
	func   = INT2PTR(void(*)(short, char *, double), SvIV(c_func) );
	(*func)(s0, t1, d2);

void
nci_vsts( c_func, s0, t1, s2 )
	SV* c_func
	short s0
	char * t1
	short s2
PREINIT:
	void(*func)(short, char *, short);
CODE:
	func   = INT2PTR(void(*)(short, char *, short), SvIV(c_func) );
	(*func)(s0, t1, s2);

void
nci_vstf( c_func, s0, t1, f2 )
	SV* c_func
	short s0
	char * t1
	float f2
PREINIT:
	void(*func)(short, char *, float);
CODE:
	func   = INT2PTR(void(*)(short, char *, float), SvIV(c_func) );
	(*func)(s0, t1, f2);

void
nci_vstt( c_func, s0, t1, t2 )
	SV* c_func
	short s0
	char * t1
	char * t2
PREINIT:
	void(*func)(short, char *, char *);
CODE:
	func   = INT2PTR(void(*)(short, char *, char *), SvIV(c_func) );
	(*func)(s0, t1, t2);

void
nci_vsti( c_func, s0, t1, i2 )
	SV* c_func
	short s0
	char * t1
	int i2
PREINIT:
	void(*func)(short, char *, int);
CODE:
	func   = INT2PTR(void(*)(short, char *, int), SvIV(c_func) );
	(*func)(s0, t1, i2);

void
nci_vsip( c_func, s0, i1, p2 )
	SV* c_func
	short s0
	int i1
	void * p2
PREINIT:
	void(*func)(short, int, void *);
CODE:
	func   = INT2PTR(void(*)(short, int, void *), SvIV(c_func) );
	(*func)(s0, i1, p2);

void
nci_vsid( c_func, s0, i1, d2 )
	SV* c_func
	short s0
	int i1
	double d2
PREINIT:
	void(*func)(short, int, double);
CODE:
	func   = INT2PTR(void(*)(short, int, double), SvIV(c_func) );
	(*func)(s0, i1, d2);

void
nci_vsis( c_func, s0, i1, s2 )
	SV* c_func
	short s0
	int i1
	short s2
PREINIT:
	void(*func)(short, int, short);
CODE:
	func   = INT2PTR(void(*)(short, int, short), SvIV(c_func) );
	(*func)(s0, i1, s2);

void
nci_vsif( c_func, s0, i1, f2 )
	SV* c_func
	short s0
	int i1
	float f2
PREINIT:
	void(*func)(short, int, float);
CODE:
	func   = INT2PTR(void(*)(short, int, float), SvIV(c_func) );
	(*func)(s0, i1, f2);

void
nci_vsit( c_func, s0, i1, t2 )
	SV* c_func
	short s0
	int i1
	char * t2
PREINIT:
	void(*func)(short, int, char *);
CODE:
	func   = INT2PTR(void(*)(short, int, char *), SvIV(c_func) );
	(*func)(s0, i1, t2);

void
nci_vsii( c_func, s0, i1, i2 )
	SV* c_func
	short s0
	int i1
	int i2
PREINIT:
	void(*func)(short, int, int);
CODE:
	func   = INT2PTR(void(*)(short, int, int), SvIV(c_func) );
	(*func)(s0, i1, i2);

void
nci_vfpp( c_func, f0, p1, p2 )
	SV* c_func
	float f0
	void * p1
	void * p2
PREINIT:
	void(*func)(float, void *, void *);
CODE:
	func   = INT2PTR(void(*)(float, void *, void *), SvIV(c_func) );
	(*func)(f0, p1, p2);

void
nci_vfpd( c_func, f0, p1, d2 )
	SV* c_func
	float f0
	void * p1
	double d2
PREINIT:
	void(*func)(float, void *, double);
CODE:
	func   = INT2PTR(void(*)(float, void *, double), SvIV(c_func) );
	(*func)(f0, p1, d2);

void
nci_vfps( c_func, f0, p1, s2 )
	SV* c_func
	float f0
	void * p1
	short s2
PREINIT:
	void(*func)(float, void *, short);
CODE:
	func   = INT2PTR(void(*)(float, void *, short), SvIV(c_func) );
	(*func)(f0, p1, s2);

void
nci_vfpf( c_func, f0, p1, f2 )
	SV* c_func
	float f0
	void * p1
	float f2
PREINIT:
	void(*func)(float, void *, float);
CODE:
	func   = INT2PTR(void(*)(float, void *, float), SvIV(c_func) );
	(*func)(f0, p1, f2);

void
nci_vfpt( c_func, f0, p1, t2 )
	SV* c_func
	float f0
	void * p1
	char * t2
PREINIT:
	void(*func)(float, void *, char *);
CODE:
	func   = INT2PTR(void(*)(float, void *, char *), SvIV(c_func) );
	(*func)(f0, p1, t2);

void
nci_vfpi( c_func, f0, p1, i2 )
	SV* c_func
	float f0
	void * p1
	int i2
PREINIT:
	void(*func)(float, void *, int);
CODE:
	func   = INT2PTR(void(*)(float, void *, int), SvIV(c_func) );
	(*func)(f0, p1, i2);

void
nci_vfdp( c_func, f0, d1, p2 )
	SV* c_func
	float f0
	double d1
	void * p2
PREINIT:
	void(*func)(float, double, void *);
CODE:
	func   = INT2PTR(void(*)(float, double, void *), SvIV(c_func) );
	(*func)(f0, d1, p2);

void
nci_vfdd( c_func, f0, d1, d2 )
	SV* c_func
	float f0
	double d1
	double d2
PREINIT:
	void(*func)(float, double, double);
CODE:
	func   = INT2PTR(void(*)(float, double, double), SvIV(c_func) );
	(*func)(f0, d1, d2);

void
nci_vfds( c_func, f0, d1, s2 )
	SV* c_func
	float f0
	double d1
	short s2
PREINIT:
	void(*func)(float, double, short);
CODE:
	func   = INT2PTR(void(*)(float, double, short), SvIV(c_func) );
	(*func)(f0, d1, s2);

void
nci_vfdf( c_func, f0, d1, f2 )
	SV* c_func
	float f0
	double d1
	float f2
PREINIT:
	void(*func)(float, double, float);
CODE:
	func   = INT2PTR(void(*)(float, double, float), SvIV(c_func) );
	(*func)(f0, d1, f2);

void
nci_vfdt( c_func, f0, d1, t2 )
	SV* c_func
	float f0
	double d1
	char * t2
PREINIT:
	void(*func)(float, double, char *);
CODE:
	func   = INT2PTR(void(*)(float, double, char *), SvIV(c_func) );
	(*func)(f0, d1, t2);

void
nci_vfdi( c_func, f0, d1, i2 )
	SV* c_func
	float f0
	double d1
	int i2
PREINIT:
	void(*func)(float, double, int);
CODE:
	func   = INT2PTR(void(*)(float, double, int), SvIV(c_func) );
	(*func)(f0, d1, i2);

void
nci_vfsp( c_func, f0, s1, p2 )
	SV* c_func
	float f0
	short s1
	void * p2
PREINIT:
	void(*func)(float, short, void *);
CODE:
	func   = INT2PTR(void(*)(float, short, void *), SvIV(c_func) );
	(*func)(f0, s1, p2);

void
nci_vfsd( c_func, f0, s1, d2 )
	SV* c_func
	float f0
	short s1
	double d2
PREINIT:
	void(*func)(float, short, double);
CODE:
	func   = INT2PTR(void(*)(float, short, double), SvIV(c_func) );
	(*func)(f0, s1, d2);

void
nci_vfss( c_func, f0, s1, s2 )
	SV* c_func
	float f0
	short s1
	short s2
PREINIT:
	void(*func)(float, short, short);
CODE:
	func   = INT2PTR(void(*)(float, short, short), SvIV(c_func) );
	(*func)(f0, s1, s2);

void
nci_vfsf( c_func, f0, s1, f2 )
	SV* c_func
	float f0
	short s1
	float f2
PREINIT:
	void(*func)(float, short, float);
CODE:
	func   = INT2PTR(void(*)(float, short, float), SvIV(c_func) );
	(*func)(f0, s1, f2);

void
nci_vfst( c_func, f0, s1, t2 )
	SV* c_func
	float f0
	short s1
	char * t2
PREINIT:
	void(*func)(float, short, char *);
CODE:
	func   = INT2PTR(void(*)(float, short, char *), SvIV(c_func) );
	(*func)(f0, s1, t2);

void
nci_vfsi( c_func, f0, s1, i2 )
	SV* c_func
	float f0
	short s1
	int i2
PREINIT:
	void(*func)(float, short, int);
CODE:
	func   = INT2PTR(void(*)(float, short, int), SvIV(c_func) );
	(*func)(f0, s1, i2);

void
nci_vffp( c_func, f0, f1, p2 )
	SV* c_func
	float f0
	float f1
	void * p2
PREINIT:
	void(*func)(float, float, void *);
CODE:
	func   = INT2PTR(void(*)(float, float, void *), SvIV(c_func) );
	(*func)(f0, f1, p2);

void
nci_vffd( c_func, f0, f1, d2 )
	SV* c_func
	float f0
	float f1
	double d2
PREINIT:
	void(*func)(float, float, double);
CODE:
	func   = INT2PTR(void(*)(float, float, double), SvIV(c_func) );
	(*func)(f0, f1, d2);

void
nci_vffs( c_func, f0, f1, s2 )
	SV* c_func
	float f0
	float f1
	short s2
PREINIT:
	void(*func)(float, float, short);
CODE:
	func   = INT2PTR(void(*)(float, float, short), SvIV(c_func) );
	(*func)(f0, f1, s2);

void
nci_vfff( c_func, f0, f1, f2 )
	SV* c_func
	float f0
	float f1
	float f2
PREINIT:
	void(*func)(float, float, float);
CODE:
	func   = INT2PTR(void(*)(float, float, float), SvIV(c_func) );
	(*func)(f0, f1, f2);

void
nci_vfft( c_func, f0, f1, t2 )
	SV* c_func
	float f0
	float f1
	char * t2
PREINIT:
	void(*func)(float, float, char *);
CODE:
	func   = INT2PTR(void(*)(float, float, char *), SvIV(c_func) );
	(*func)(f0, f1, t2);

void
nci_vffi( c_func, f0, f1, i2 )
	SV* c_func
	float f0
	float f1
	int i2
PREINIT:
	void(*func)(float, float, int);
CODE:
	func   = INT2PTR(void(*)(float, float, int), SvIV(c_func) );
	(*func)(f0, f1, i2);

void
nci_vftp( c_func, f0, t1, p2 )
	SV* c_func
	float f0
	char * t1
	void * p2
PREINIT:
	void(*func)(float, char *, void *);
CODE:
	func   = INT2PTR(void(*)(float, char *, void *), SvIV(c_func) );
	(*func)(f0, t1, p2);

void
nci_vftd( c_func, f0, t1, d2 )
	SV* c_func
	float f0
	char * t1
	double d2
PREINIT:
	void(*func)(float, char *, double);
CODE:
	func   = INT2PTR(void(*)(float, char *, double), SvIV(c_func) );
	(*func)(f0, t1, d2);

void
nci_vfts( c_func, f0, t1, s2 )
	SV* c_func
	float f0
	char * t1
	short s2
PREINIT:
	void(*func)(float, char *, short);
CODE:
	func   = INT2PTR(void(*)(float, char *, short), SvIV(c_func) );
	(*func)(f0, t1, s2);

void
nci_vftf( c_func, f0, t1, f2 )
	SV* c_func
	float f0
	char * t1
	float f2
PREINIT:
	void(*func)(float, char *, float);
CODE:
	func   = INT2PTR(void(*)(float, char *, float), SvIV(c_func) );
	(*func)(f0, t1, f2);

void
nci_vftt( c_func, f0, t1, t2 )
	SV* c_func
	float f0
	char * t1
	char * t2
PREINIT:
	void(*func)(float, char *, char *);
CODE:
	func   = INT2PTR(void(*)(float, char *, char *), SvIV(c_func) );
	(*func)(f0, t1, t2);

void
nci_vfti( c_func, f0, t1, i2 )
	SV* c_func
	float f0
	char * t1
	int i2
PREINIT:
	void(*func)(float, char *, int);
CODE:
	func   = INT2PTR(void(*)(float, char *, int), SvIV(c_func) );
	(*func)(f0, t1, i2);

void
nci_vfip( c_func, f0, i1, p2 )
	SV* c_func
	float f0
	int i1
	void * p2
PREINIT:
	void(*func)(float, int, void *);
CODE:
	func   = INT2PTR(void(*)(float, int, void *), SvIV(c_func) );
	(*func)(f0, i1, p2);

void
nci_vfid( c_func, f0, i1, d2 )
	SV* c_func
	float f0
	int i1
	double d2
PREINIT:
	void(*func)(float, int, double);
CODE:
	func   = INT2PTR(void(*)(float, int, double), SvIV(c_func) );
	(*func)(f0, i1, d2);

void
nci_vfis( c_func, f0, i1, s2 )
	SV* c_func
	float f0
	int i1
	short s2
PREINIT:
	void(*func)(float, int, short);
CODE:
	func   = INT2PTR(void(*)(float, int, short), SvIV(c_func) );
	(*func)(f0, i1, s2);

void
nci_vfif( c_func, f0, i1, f2 )
	SV* c_func
	float f0
	int i1
	float f2
PREINIT:
	void(*func)(float, int, float);
CODE:
	func   = INT2PTR(void(*)(float, int, float), SvIV(c_func) );
	(*func)(f0, i1, f2);

void
nci_vfit( c_func, f0, i1, t2 )
	SV* c_func
	float f0
	int i1
	char * t2
PREINIT:
	void(*func)(float, int, char *);
CODE:
	func   = INT2PTR(void(*)(float, int, char *), SvIV(c_func) );
	(*func)(f0, i1, t2);

void
nci_vfii( c_func, f0, i1, i2 )
	SV* c_func
	float f0
	int i1
	int i2
PREINIT:
	void(*func)(float, int, int);
CODE:
	func   = INT2PTR(void(*)(float, int, int), SvIV(c_func) );
	(*func)(f0, i1, i2);

void
nci_vtpp( c_func, t0, p1, p2 )
	SV* c_func
	char * t0
	void * p1
	void * p2
PREINIT:
	void(*func)(char *, void *, void *);
CODE:
	func   = INT2PTR(void(*)(char *, void *, void *), SvIV(c_func) );
	(*func)(t0, p1, p2);

void
nci_vtpd( c_func, t0, p1, d2 )
	SV* c_func
	char * t0
	void * p1
	double d2
PREINIT:
	void(*func)(char *, void *, double);
CODE:
	func   = INT2PTR(void(*)(char *, void *, double), SvIV(c_func) );
	(*func)(t0, p1, d2);

void
nci_vtps( c_func, t0, p1, s2 )
	SV* c_func
	char * t0
	void * p1
	short s2
PREINIT:
	void(*func)(char *, void *, short);
CODE:
	func   = INT2PTR(void(*)(char *, void *, short), SvIV(c_func) );
	(*func)(t0, p1, s2);

void
nci_vtpf( c_func, t0, p1, f2 )
	SV* c_func
	char * t0
	void * p1
	float f2
PREINIT:
	void(*func)(char *, void *, float);
CODE:
	func   = INT2PTR(void(*)(char *, void *, float), SvIV(c_func) );
	(*func)(t0, p1, f2);

void
nci_vtpt( c_func, t0, p1, t2 )
	SV* c_func
	char * t0
	void * p1
	char * t2
PREINIT:
	void(*func)(char *, void *, char *);
CODE:
	func   = INT2PTR(void(*)(char *, void *, char *), SvIV(c_func) );
	(*func)(t0, p1, t2);

void
nci_vtpi( c_func, t0, p1, i2 )
	SV* c_func
	char * t0
	void * p1
	int i2
PREINIT:
	void(*func)(char *, void *, int);
CODE:
	func   = INT2PTR(void(*)(char *, void *, int), SvIV(c_func) );
	(*func)(t0, p1, i2);

void
nci_vtdp( c_func, t0, d1, p2 )
	SV* c_func
	char * t0
	double d1
	void * p2
PREINIT:
	void(*func)(char *, double, void *);
CODE:
	func   = INT2PTR(void(*)(char *, double, void *), SvIV(c_func) );
	(*func)(t0, d1, p2);

void
nci_vtdd( c_func, t0, d1, d2 )
	SV* c_func
	char * t0
	double d1
	double d2
PREINIT:
	void(*func)(char *, double, double);
CODE:
	func   = INT2PTR(void(*)(char *, double, double), SvIV(c_func) );
	(*func)(t0, d1, d2);

void
nci_vtds( c_func, t0, d1, s2 )
	SV* c_func
	char * t0
	double d1
	short s2
PREINIT:
	void(*func)(char *, double, short);
CODE:
	func   = INT2PTR(void(*)(char *, double, short), SvIV(c_func) );
	(*func)(t0, d1, s2);

void
nci_vtdf( c_func, t0, d1, f2 )
	SV* c_func
	char * t0
	double d1
	float f2
PREINIT:
	void(*func)(char *, double, float);
CODE:
	func   = INT2PTR(void(*)(char *, double, float), SvIV(c_func) );
	(*func)(t0, d1, f2);

void
nci_vtdt( c_func, t0, d1, t2 )
	SV* c_func
	char * t0
	double d1
	char * t2
PREINIT:
	void(*func)(char *, double, char *);
CODE:
	func   = INT2PTR(void(*)(char *, double, char *), SvIV(c_func) );
	(*func)(t0, d1, t2);

void
nci_vtdi( c_func, t0, d1, i2 )
	SV* c_func
	char * t0
	double d1
	int i2
PREINIT:
	void(*func)(char *, double, int);
CODE:
	func   = INT2PTR(void(*)(char *, double, int), SvIV(c_func) );
	(*func)(t0, d1, i2);

void
nci_vtsp( c_func, t0, s1, p2 )
	SV* c_func
	char * t0
	short s1
	void * p2
PREINIT:
	void(*func)(char *, short, void *);
CODE:
	func   = INT2PTR(void(*)(char *, short, void *), SvIV(c_func) );
	(*func)(t0, s1, p2);

void
nci_vtsd( c_func, t0, s1, d2 )
	SV* c_func
	char * t0
	short s1
	double d2
PREINIT:
	void(*func)(char *, short, double);
CODE:
	func   = INT2PTR(void(*)(char *, short, double), SvIV(c_func) );
	(*func)(t0, s1, d2);

void
nci_vtss( c_func, t0, s1, s2 )
	SV* c_func
	char * t0
	short s1
	short s2
PREINIT:
	void(*func)(char *, short, short);
CODE:
	func   = INT2PTR(void(*)(char *, short, short), SvIV(c_func) );
	(*func)(t0, s1, s2);

void
nci_vtsf( c_func, t0, s1, f2 )
	SV* c_func
	char * t0
	short s1
	float f2
PREINIT:
	void(*func)(char *, short, float);
CODE:
	func   = INT2PTR(void(*)(char *, short, float), SvIV(c_func) );
	(*func)(t0, s1, f2);

void
nci_vtst( c_func, t0, s1, t2 )
	SV* c_func
	char * t0
	short s1
	char * t2
PREINIT:
	void(*func)(char *, short, char *);
CODE:
	func   = INT2PTR(void(*)(char *, short, char *), SvIV(c_func) );
	(*func)(t0, s1, t2);

void
nci_vtsi( c_func, t0, s1, i2 )
	SV* c_func
	char * t0
	short s1
	int i2
PREINIT:
	void(*func)(char *, short, int);
CODE:
	func   = INT2PTR(void(*)(char *, short, int), SvIV(c_func) );
	(*func)(t0, s1, i2);

void
nci_vtfp( c_func, t0, f1, p2 )
	SV* c_func
	char * t0
	float f1
	void * p2
PREINIT:
	void(*func)(char *, float, void *);
CODE:
	func   = INT2PTR(void(*)(char *, float, void *), SvIV(c_func) );
	(*func)(t0, f1, p2);

void
nci_vtfd( c_func, t0, f1, d2 )
	SV* c_func
	char * t0
	float f1
	double d2
PREINIT:
	void(*func)(char *, float, double);
CODE:
	func   = INT2PTR(void(*)(char *, float, double), SvIV(c_func) );
	(*func)(t0, f1, d2);

void
nci_vtfs( c_func, t0, f1, s2 )
	SV* c_func
	char * t0
	float f1
	short s2
PREINIT:
	void(*func)(char *, float, short);
CODE:
	func   = INT2PTR(void(*)(char *, float, short), SvIV(c_func) );
	(*func)(t0, f1, s2);

void
nci_vtff( c_func, t0, f1, f2 )
	SV* c_func
	char * t0
	float f1
	float f2
PREINIT:
	void(*func)(char *, float, float);
CODE:
	func   = INT2PTR(void(*)(char *, float, float), SvIV(c_func) );
	(*func)(t0, f1, f2);

void
nci_vtft( c_func, t0, f1, t2 )
	SV* c_func
	char * t0
	float f1
	char * t2
PREINIT:
	void(*func)(char *, float, char *);
CODE:
	func   = INT2PTR(void(*)(char *, float, char *), SvIV(c_func) );
	(*func)(t0, f1, t2);

void
nci_vtfi( c_func, t0, f1, i2 )
	SV* c_func
	char * t0
	float f1
	int i2
PREINIT:
	void(*func)(char *, float, int);
CODE:
	func   = INT2PTR(void(*)(char *, float, int), SvIV(c_func) );
	(*func)(t0, f1, i2);

void
nci_vttp( c_func, t0, t1, p2 )
	SV* c_func
	char * t0
	char * t1
	void * p2
PREINIT:
	void(*func)(char *, char *, void *);
CODE:
	func   = INT2PTR(void(*)(char *, char *, void *), SvIV(c_func) );
	(*func)(t0, t1, p2);

void
nci_vttd( c_func, t0, t1, d2 )
	SV* c_func
	char * t0
	char * t1
	double d2
PREINIT:
	void(*func)(char *, char *, double);
CODE:
	func   = INT2PTR(void(*)(char *, char *, double), SvIV(c_func) );
	(*func)(t0, t1, d2);

void
nci_vtts( c_func, t0, t1, s2 )
	SV* c_func
	char * t0
	char * t1
	short s2
PREINIT:
	void(*func)(char *, char *, short);
CODE:
	func   = INT2PTR(void(*)(char *, char *, short), SvIV(c_func) );
	(*func)(t0, t1, s2);

void
nci_vttf( c_func, t0, t1, f2 )
	SV* c_func
	char * t0
	char * t1
	float f2
PREINIT:
	void(*func)(char *, char *, float);
CODE:
	func   = INT2PTR(void(*)(char *, char *, float), SvIV(c_func) );
	(*func)(t0, t1, f2);

void
nci_vttt( c_func, t0, t1, t2 )
	SV* c_func
	char * t0
	char * t1
	char * t2
PREINIT:
	void(*func)(char *, char *, char *);
CODE:
	func   = INT2PTR(void(*)(char *, char *, char *), SvIV(c_func) );
	(*func)(t0, t1, t2);

void
nci_vtti( c_func, t0, t1, i2 )
	SV* c_func
	char * t0
	char * t1
	int i2
PREINIT:
	void(*func)(char *, char *, int);
CODE:
	func   = INT2PTR(void(*)(char *, char *, int), SvIV(c_func) );
	(*func)(t0, t1, i2);

void
nci_vtip( c_func, t0, i1, p2 )
	SV* c_func
	char * t0
	int i1
	void * p2
PREINIT:
	void(*func)(char *, int, void *);
CODE:
	func   = INT2PTR(void(*)(char *, int, void *), SvIV(c_func) );
	(*func)(t0, i1, p2);

void
nci_vtid( c_func, t0, i1, d2 )
	SV* c_func
	char * t0
	int i1
	double d2
PREINIT:
	void(*func)(char *, int, double);
CODE:
	func   = INT2PTR(void(*)(char *, int, double), SvIV(c_func) );
	(*func)(t0, i1, d2);

void
nci_vtis( c_func, t0, i1, s2 )
	SV* c_func
	char * t0
	int i1
	short s2
PREINIT:
	void(*func)(char *, int, short);
CODE:
	func   = INT2PTR(void(*)(char *, int, short), SvIV(c_func) );
	(*func)(t0, i1, s2);

void
nci_vtif( c_func, t0, i1, f2 )
	SV* c_func
	char * t0
	int i1
	float f2
PREINIT:
	void(*func)(char *, int, float);
CODE:
	func   = INT2PTR(void(*)(char *, int, float), SvIV(c_func) );
	(*func)(t0, i1, f2);

void
nci_vtit( c_func, t0, i1, t2 )
	SV* c_func
	char * t0
	int i1
	char * t2
PREINIT:
	void(*func)(char *, int, char *);
CODE:
	func   = INT2PTR(void(*)(char *, int, char *), SvIV(c_func) );
	(*func)(t0, i1, t2);

void
nci_vtii( c_func, t0, i1, i2 )
	SV* c_func
	char * t0
	int i1
	int i2
PREINIT:
	void(*func)(char *, int, int);
CODE:
	func   = INT2PTR(void(*)(char *, int, int), SvIV(c_func) );
	(*func)(t0, i1, i2);

void
nci_vipp( c_func, i0, p1, p2 )
	SV* c_func
	int i0
	void * p1
	void * p2
PREINIT:
	void(*func)(int, void *, void *);
CODE:
	func   = INT2PTR(void(*)(int, void *, void *), SvIV(c_func) );
	(*func)(i0, p1, p2);

void
nci_vipd( c_func, i0, p1, d2 )
	SV* c_func
	int i0
	void * p1
	double d2
PREINIT:
	void(*func)(int, void *, double);
CODE:
	func   = INT2PTR(void(*)(int, void *, double), SvIV(c_func) );
	(*func)(i0, p1, d2);

void
nci_vips( c_func, i0, p1, s2 )
	SV* c_func
	int i0
	void * p1
	short s2
PREINIT:
	void(*func)(int, void *, short);
CODE:
	func   = INT2PTR(void(*)(int, void *, short), SvIV(c_func) );
	(*func)(i0, p1, s2);

void
nci_vipf( c_func, i0, p1, f2 )
	SV* c_func
	int i0
	void * p1
	float f2
PREINIT:
	void(*func)(int, void *, float);
CODE:
	func   = INT2PTR(void(*)(int, void *, float), SvIV(c_func) );
	(*func)(i0, p1, f2);

void
nci_vipt( c_func, i0, p1, t2 )
	SV* c_func
	int i0
	void * p1
	char * t2
PREINIT:
	void(*func)(int, void *, char *);
CODE:
	func   = INT2PTR(void(*)(int, void *, char *), SvIV(c_func) );
	(*func)(i0, p1, t2);

void
nci_vipi( c_func, i0, p1, i2 )
	SV* c_func
	int i0
	void * p1
	int i2
PREINIT:
	void(*func)(int, void *, int);
CODE:
	func   = INT2PTR(void(*)(int, void *, int), SvIV(c_func) );
	(*func)(i0, p1, i2);

void
nci_vidp( c_func, i0, d1, p2 )
	SV* c_func
	int i0
	double d1
	void * p2
PREINIT:
	void(*func)(int, double, void *);
CODE:
	func   = INT2PTR(void(*)(int, double, void *), SvIV(c_func) );
	(*func)(i0, d1, p2);

void
nci_vidd( c_func, i0, d1, d2 )
	SV* c_func
	int i0
	double d1
	double d2
PREINIT:
	void(*func)(int, double, double);
CODE:
	func   = INT2PTR(void(*)(int, double, double), SvIV(c_func) );
	(*func)(i0, d1, d2);

void
nci_vids( c_func, i0, d1, s2 )
	SV* c_func
	int i0
	double d1
	short s2
PREINIT:
	void(*func)(int, double, short);
CODE:
	func   = INT2PTR(void(*)(int, double, short), SvIV(c_func) );
	(*func)(i0, d1, s2);

void
nci_vidf( c_func, i0, d1, f2 )
	SV* c_func
	int i0
	double d1
	float f2
PREINIT:
	void(*func)(int, double, float);
CODE:
	func   = INT2PTR(void(*)(int, double, float), SvIV(c_func) );
	(*func)(i0, d1, f2);

void
nci_vidt( c_func, i0, d1, t2 )
	SV* c_func
	int i0
	double d1
	char * t2
PREINIT:
	void(*func)(int, double, char *);
CODE:
	func   = INT2PTR(void(*)(int, double, char *), SvIV(c_func) );
	(*func)(i0, d1, t2);

void
nci_vidi( c_func, i0, d1, i2 )
	SV* c_func
	int i0
	double d1
	int i2
PREINIT:
	void(*func)(int, double, int);
CODE:
	func   = INT2PTR(void(*)(int, double, int), SvIV(c_func) );
	(*func)(i0, d1, i2);

void
nci_visp( c_func, i0, s1, p2 )
	SV* c_func
	int i0
	short s1
	void * p2
PREINIT:
	void(*func)(int, short, void *);
CODE:
	func   = INT2PTR(void(*)(int, short, void *), SvIV(c_func) );
	(*func)(i0, s1, p2);

void
nci_visd( c_func, i0, s1, d2 )
	SV* c_func
	int i0
	short s1
	double d2
PREINIT:
	void(*func)(int, short, double);
CODE:
	func   = INT2PTR(void(*)(int, short, double), SvIV(c_func) );
	(*func)(i0, s1, d2);

void
nci_viss( c_func, i0, s1, s2 )
	SV* c_func
	int i0
	short s1
	short s2
PREINIT:
	void(*func)(int, short, short);
CODE:
	func   = INT2PTR(void(*)(int, short, short), SvIV(c_func) );
	(*func)(i0, s1, s2);

void
nci_visf( c_func, i0, s1, f2 )
	SV* c_func
	int i0
	short s1
	float f2
PREINIT:
	void(*func)(int, short, float);
CODE:
	func   = INT2PTR(void(*)(int, short, float), SvIV(c_func) );
	(*func)(i0, s1, f2);

void
nci_vist( c_func, i0, s1, t2 )
	SV* c_func
	int i0
	short s1
	char * t2
PREINIT:
	void(*func)(int, short, char *);
CODE:
	func   = INT2PTR(void(*)(int, short, char *), SvIV(c_func) );
	(*func)(i0, s1, t2);

void
nci_visi( c_func, i0, s1, i2 )
	SV* c_func
	int i0
	short s1
	int i2
PREINIT:
	void(*func)(int, short, int);
CODE:
	func   = INT2PTR(void(*)(int, short, int), SvIV(c_func) );
	(*func)(i0, s1, i2);

void
nci_vifp( c_func, i0, f1, p2 )
	SV* c_func
	int i0
	float f1
	void * p2
PREINIT:
	void(*func)(int, float, void *);
CODE:
	func   = INT2PTR(void(*)(int, float, void *), SvIV(c_func) );
	(*func)(i0, f1, p2);

void
nci_vifd( c_func, i0, f1, d2 )
	SV* c_func
	int i0
	float f1
	double d2
PREINIT:
	void(*func)(int, float, double);
CODE:
	func   = INT2PTR(void(*)(int, float, double), SvIV(c_func) );
	(*func)(i0, f1, d2);

void
nci_vifs( c_func, i0, f1, s2 )
	SV* c_func
	int i0
	float f1
	short s2
PREINIT:
	void(*func)(int, float, short);
CODE:
	func   = INT2PTR(void(*)(int, float, short), SvIV(c_func) );
	(*func)(i0, f1, s2);

void
nci_viff( c_func, i0, f1, f2 )
	SV* c_func
	int i0
	float f1
	float f2
PREINIT:
	void(*func)(int, float, float);
CODE:
	func   = INT2PTR(void(*)(int, float, float), SvIV(c_func) );
	(*func)(i0, f1, f2);

void
nci_vift( c_func, i0, f1, t2 )
	SV* c_func
	int i0
	float f1
	char * t2
PREINIT:
	void(*func)(int, float, char *);
CODE:
	func   = INT2PTR(void(*)(int, float, char *), SvIV(c_func) );
	(*func)(i0, f1, t2);

void
nci_vifi( c_func, i0, f1, i2 )
	SV* c_func
	int i0
	float f1
	int i2
PREINIT:
	void(*func)(int, float, int);
CODE:
	func   = INT2PTR(void(*)(int, float, int), SvIV(c_func) );
	(*func)(i0, f1, i2);

void
nci_vitp( c_func, i0, t1, p2 )
	SV* c_func
	int i0
	char * t1
	void * p2
PREINIT:
	void(*func)(int, char *, void *);
CODE:
	func   = INT2PTR(void(*)(int, char *, void *), SvIV(c_func) );
	(*func)(i0, t1, p2);

void
nci_vitd( c_func, i0, t1, d2 )
	SV* c_func
	int i0
	char * t1
	double d2
PREINIT:
	void(*func)(int, char *, double);
CODE:
	func   = INT2PTR(void(*)(int, char *, double), SvIV(c_func) );
	(*func)(i0, t1, d2);

void
nci_vits( c_func, i0, t1, s2 )
	SV* c_func
	int i0
	char * t1
	short s2
PREINIT:
	void(*func)(int, char *, short);
CODE:
	func   = INT2PTR(void(*)(int, char *, short), SvIV(c_func) );
	(*func)(i0, t1, s2);

void
nci_vitf( c_func, i0, t1, f2 )
	SV* c_func
	int i0
	char * t1
	float f2
PREINIT:
	void(*func)(int, char *, float);
CODE:
	func   = INT2PTR(void(*)(int, char *, float), SvIV(c_func) );
	(*func)(i0, t1, f2);

void
nci_vitt( c_func, i0, t1, t2 )
	SV* c_func
	int i0
	char * t1
	char * t2
PREINIT:
	void(*func)(int, char *, char *);
CODE:
	func   = INT2PTR(void(*)(int, char *, char *), SvIV(c_func) );
	(*func)(i0, t1, t2);

void
nci_viti( c_func, i0, t1, i2 )
	SV* c_func
	int i0
	char * t1
	int i2
PREINIT:
	void(*func)(int, char *, int);
CODE:
	func   = INT2PTR(void(*)(int, char *, int), SvIV(c_func) );
	(*func)(i0, t1, i2);

void
nci_viip( c_func, i0, i1, p2 )
	SV* c_func
	int i0
	int i1
	void * p2
PREINIT:
	void(*func)(int, int, void *);
CODE:
	func   = INT2PTR(void(*)(int, int, void *), SvIV(c_func) );
	(*func)(i0, i1, p2);

void
nci_viid( c_func, i0, i1, d2 )
	SV* c_func
	int i0
	int i1
	double d2
PREINIT:
	void(*func)(int, int, double);
CODE:
	func   = INT2PTR(void(*)(int, int, double), SvIV(c_func) );
	(*func)(i0, i1, d2);

void
nci_viis( c_func, i0, i1, s2 )
	SV* c_func
	int i0
	int i1
	short s2
PREINIT:
	void(*func)(int, int, short);
CODE:
	func   = INT2PTR(void(*)(int, int, short), SvIV(c_func) );
	(*func)(i0, i1, s2);

void
nci_viif( c_func, i0, i1, f2 )
	SV* c_func
	int i0
	int i1
	float f2
PREINIT:
	void(*func)(int, int, float);
CODE:
	func   = INT2PTR(void(*)(int, int, float), SvIV(c_func) );
	(*func)(i0, i1, f2);

void
nci_viit( c_func, i0, i1, t2 )
	SV* c_func
	int i0
	int i1
	char * t2
PREINIT:
	void(*func)(int, int, char *);
CODE:
	func   = INT2PTR(void(*)(int, int, char *), SvIV(c_func) );
	(*func)(i0, i1, t2);

void
nci_viii( c_func, i0, i1, i2 )
	SV* c_func
	int i0
	int i1
	int i2
PREINIT:
	void(*func)(int, int, int);
CODE:
	func   = INT2PTR(void(*)(int, int, int), SvIV(c_func) );
	(*func)(i0, i1, i2);

double
nci_dppp( c_func, p0, p1, p2 )
	SV* c_func
	void * p0
	void * p1
	void * p2
PREINIT:
	double(*func)(void *, void *, void *);
CODE:
	func   = INT2PTR(double(*)(void *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, p2);
OUTPUT:
	RETVAL

double
nci_dppd( c_func, p0, p1, d2 )
	SV* c_func
	void * p0
	void * p1
	double d2
PREINIT:
	double(*func)(void *, void *, double);
CODE:
	func   = INT2PTR(double(*)(void *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, d2);
OUTPUT:
	RETVAL

double
nci_dpps( c_func, p0, p1, s2 )
	SV* c_func
	void * p0
	void * p1
	short s2
PREINIT:
	double(*func)(void *, void *, short);
CODE:
	func   = INT2PTR(double(*)(void *, void *, short), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, s2);
OUTPUT:
	RETVAL

double
nci_dppf( c_func, p0, p1, f2 )
	SV* c_func
	void * p0
	void * p1
	float f2
PREINIT:
	double(*func)(void *, void *, float);
CODE:
	func   = INT2PTR(double(*)(void *, void *, float), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, f2);
OUTPUT:
	RETVAL

double
nci_dppt( c_func, p0, p1, t2 )
	SV* c_func
	void * p0
	void * p1
	char * t2
PREINIT:
	double(*func)(void *, void *, char *);
CODE:
	func   = INT2PTR(double(*)(void *, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, t2);
OUTPUT:
	RETVAL

double
nci_dppi( c_func, p0, p1, i2 )
	SV* c_func
	void * p0
	void * p1
	int i2
PREINIT:
	double(*func)(void *, void *, int);
CODE:
	func   = INT2PTR(double(*)(void *, void *, int), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, i2);
OUTPUT:
	RETVAL

double
nci_dpdp( c_func, p0, d1, p2 )
	SV* c_func
	void * p0
	double d1
	void * p2
PREINIT:
	double(*func)(void *, double, void *);
CODE:
	func   = INT2PTR(double(*)(void *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, p2);
OUTPUT:
	RETVAL

double
nci_dpdd( c_func, p0, d1, d2 )
	SV* c_func
	void * p0
	double d1
	double d2
PREINIT:
	double(*func)(void *, double, double);
CODE:
	func   = INT2PTR(double(*)(void *, double, double), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, d2);
OUTPUT:
	RETVAL

double
nci_dpds( c_func, p0, d1, s2 )
	SV* c_func
	void * p0
	double d1
	short s2
PREINIT:
	double(*func)(void *, double, short);
CODE:
	func   = INT2PTR(double(*)(void *, double, short), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, s2);
OUTPUT:
	RETVAL

double
nci_dpdf( c_func, p0, d1, f2 )
	SV* c_func
	void * p0
	double d1
	float f2
PREINIT:
	double(*func)(void *, double, float);
CODE:
	func   = INT2PTR(double(*)(void *, double, float), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, f2);
OUTPUT:
	RETVAL

double
nci_dpdt( c_func, p0, d1, t2 )
	SV* c_func
	void * p0
	double d1
	char * t2
PREINIT:
	double(*func)(void *, double, char *);
CODE:
	func   = INT2PTR(double(*)(void *, double, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, t2);
OUTPUT:
	RETVAL

double
nci_dpdi( c_func, p0, d1, i2 )
	SV* c_func
	void * p0
	double d1
	int i2
PREINIT:
	double(*func)(void *, double, int);
CODE:
	func   = INT2PTR(double(*)(void *, double, int), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, i2);
OUTPUT:
	RETVAL

double
nci_dpsp( c_func, p0, s1, p2 )
	SV* c_func
	void * p0
	short s1
	void * p2
PREINIT:
	double(*func)(void *, short, void *);
CODE:
	func   = INT2PTR(double(*)(void *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, p2);
OUTPUT:
	RETVAL

double
nci_dpsd( c_func, p0, s1, d2 )
	SV* c_func
	void * p0
	short s1
	double d2
PREINIT:
	double(*func)(void *, short, double);
CODE:
	func   = INT2PTR(double(*)(void *, short, double), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, d2);
OUTPUT:
	RETVAL

double
nci_dpss( c_func, p0, s1, s2 )
	SV* c_func
	void * p0
	short s1
	short s2
PREINIT:
	double(*func)(void *, short, short);
CODE:
	func   = INT2PTR(double(*)(void *, short, short), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, s2);
OUTPUT:
	RETVAL

double
nci_dpsf( c_func, p0, s1, f2 )
	SV* c_func
	void * p0
	short s1
	float f2
PREINIT:
	double(*func)(void *, short, float);
CODE:
	func   = INT2PTR(double(*)(void *, short, float), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, f2);
OUTPUT:
	RETVAL

double
nci_dpst( c_func, p0, s1, t2 )
	SV* c_func
	void * p0
	short s1
	char * t2
PREINIT:
	double(*func)(void *, short, char *);
CODE:
	func   = INT2PTR(double(*)(void *, short, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, t2);
OUTPUT:
	RETVAL

double
nci_dpsi( c_func, p0, s1, i2 )
	SV* c_func
	void * p0
	short s1
	int i2
PREINIT:
	double(*func)(void *, short, int);
CODE:
	func   = INT2PTR(double(*)(void *, short, int), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, i2);
OUTPUT:
	RETVAL

double
nci_dpfp( c_func, p0, f1, p2 )
	SV* c_func
	void * p0
	float f1
	void * p2
PREINIT:
	double(*func)(void *, float, void *);
CODE:
	func   = INT2PTR(double(*)(void *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, p2);
OUTPUT:
	RETVAL

double
nci_dpfd( c_func, p0, f1, d2 )
	SV* c_func
	void * p0
	float f1
	double d2
PREINIT:
	double(*func)(void *, float, double);
CODE:
	func   = INT2PTR(double(*)(void *, float, double), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, d2);
OUTPUT:
	RETVAL

double
nci_dpfs( c_func, p0, f1, s2 )
	SV* c_func
	void * p0
	float f1
	short s2
PREINIT:
	double(*func)(void *, float, short);
CODE:
	func   = INT2PTR(double(*)(void *, float, short), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, s2);
OUTPUT:
	RETVAL

double
nci_dpff( c_func, p0, f1, f2 )
	SV* c_func
	void * p0
	float f1
	float f2
PREINIT:
	double(*func)(void *, float, float);
CODE:
	func   = INT2PTR(double(*)(void *, float, float), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, f2);
OUTPUT:
	RETVAL

double
nci_dpft( c_func, p0, f1, t2 )
	SV* c_func
	void * p0
	float f1
	char * t2
PREINIT:
	double(*func)(void *, float, char *);
CODE:
	func   = INT2PTR(double(*)(void *, float, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, t2);
OUTPUT:
	RETVAL

double
nci_dpfi( c_func, p0, f1, i2 )
	SV* c_func
	void * p0
	float f1
	int i2
PREINIT:
	double(*func)(void *, float, int);
CODE:
	func   = INT2PTR(double(*)(void *, float, int), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, i2);
OUTPUT:
	RETVAL

double
nci_dptp( c_func, p0, t1, p2 )
	SV* c_func
	void * p0
	char * t1
	void * p2
PREINIT:
	double(*func)(void *, char *, void *);
CODE:
	func   = INT2PTR(double(*)(void *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, p2);
OUTPUT:
	RETVAL

double
nci_dptd( c_func, p0, t1, d2 )
	SV* c_func
	void * p0
	char * t1
	double d2
PREINIT:
	double(*func)(void *, char *, double);
CODE:
	func   = INT2PTR(double(*)(void *, char *, double), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, d2);
OUTPUT:
	RETVAL

double
nci_dpts( c_func, p0, t1, s2 )
	SV* c_func
	void * p0
	char * t1
	short s2
PREINIT:
	double(*func)(void *, char *, short);
CODE:
	func   = INT2PTR(double(*)(void *, char *, short), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, s2);
OUTPUT:
	RETVAL

double
nci_dptf( c_func, p0, t1, f2 )
	SV* c_func
	void * p0
	char * t1
	float f2
PREINIT:
	double(*func)(void *, char *, float);
CODE:
	func   = INT2PTR(double(*)(void *, char *, float), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, f2);
OUTPUT:
	RETVAL

double
nci_dptt( c_func, p0, t1, t2 )
	SV* c_func
	void * p0
	char * t1
	char * t2
PREINIT:
	double(*func)(void *, char *, char *);
CODE:
	func   = INT2PTR(double(*)(void *, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, t2);
OUTPUT:
	RETVAL

double
nci_dpti( c_func, p0, t1, i2 )
	SV* c_func
	void * p0
	char * t1
	int i2
PREINIT:
	double(*func)(void *, char *, int);
CODE:
	func   = INT2PTR(double(*)(void *, char *, int), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, i2);
OUTPUT:
	RETVAL

double
nci_dpip( c_func, p0, i1, p2 )
	SV* c_func
	void * p0
	int i1
	void * p2
PREINIT:
	double(*func)(void *, int, void *);
CODE:
	func   = INT2PTR(double(*)(void *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, p2);
OUTPUT:
	RETVAL

double
nci_dpid( c_func, p0, i1, d2 )
	SV* c_func
	void * p0
	int i1
	double d2
PREINIT:
	double(*func)(void *, int, double);
CODE:
	func   = INT2PTR(double(*)(void *, int, double), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, d2);
OUTPUT:
	RETVAL

double
nci_dpis( c_func, p0, i1, s2 )
	SV* c_func
	void * p0
	int i1
	short s2
PREINIT:
	double(*func)(void *, int, short);
CODE:
	func   = INT2PTR(double(*)(void *, int, short), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, s2);
OUTPUT:
	RETVAL

double
nci_dpif( c_func, p0, i1, f2 )
	SV* c_func
	void * p0
	int i1
	float f2
PREINIT:
	double(*func)(void *, int, float);
CODE:
	func   = INT2PTR(double(*)(void *, int, float), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, f2);
OUTPUT:
	RETVAL

double
nci_dpit( c_func, p0, i1, t2 )
	SV* c_func
	void * p0
	int i1
	char * t2
PREINIT:
	double(*func)(void *, int, char *);
CODE:
	func   = INT2PTR(double(*)(void *, int, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, t2);
OUTPUT:
	RETVAL

double
nci_dpii( c_func, p0, i1, i2 )
	SV* c_func
	void * p0
	int i1
	int i2
PREINIT:
	double(*func)(void *, int, int);
CODE:
	func   = INT2PTR(double(*)(void *, int, int), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, i2);
OUTPUT:
	RETVAL

double
nci_ddpp( c_func, d0, p1, p2 )
	SV* c_func
	double d0
	void * p1
	void * p2
PREINIT:
	double(*func)(double, void *, void *);
CODE:
	func   = INT2PTR(double(*)(double, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, p2);
OUTPUT:
	RETVAL

double
nci_ddpd( c_func, d0, p1, d2 )
	SV* c_func
	double d0
	void * p1
	double d2
PREINIT:
	double(*func)(double, void *, double);
CODE:
	func   = INT2PTR(double(*)(double, void *, double), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, d2);
OUTPUT:
	RETVAL

double
nci_ddps( c_func, d0, p1, s2 )
	SV* c_func
	double d0
	void * p1
	short s2
PREINIT:
	double(*func)(double, void *, short);
CODE:
	func   = INT2PTR(double(*)(double, void *, short), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, s2);
OUTPUT:
	RETVAL

double
nci_ddpf( c_func, d0, p1, f2 )
	SV* c_func
	double d0
	void * p1
	float f2
PREINIT:
	double(*func)(double, void *, float);
CODE:
	func   = INT2PTR(double(*)(double, void *, float), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, f2);
OUTPUT:
	RETVAL

double
nci_ddpt( c_func, d0, p1, t2 )
	SV* c_func
	double d0
	void * p1
	char * t2
PREINIT:
	double(*func)(double, void *, char *);
CODE:
	func   = INT2PTR(double(*)(double, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, t2);
OUTPUT:
	RETVAL

double
nci_ddpi( c_func, d0, p1, i2 )
	SV* c_func
	double d0
	void * p1
	int i2
PREINIT:
	double(*func)(double, void *, int);
CODE:
	func   = INT2PTR(double(*)(double, void *, int), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, i2);
OUTPUT:
	RETVAL

double
nci_dddp( c_func, d0, d1, p2 )
	SV* c_func
	double d0
	double d1
	void * p2
PREINIT:
	double(*func)(double, double, void *);
CODE:
	func   = INT2PTR(double(*)(double, double, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, p2);
OUTPUT:
	RETVAL

double
nci_dddd( c_func, d0, d1, d2 )
	SV* c_func
	double d0
	double d1
	double d2
PREINIT:
	double(*func)(double, double, double);
CODE:
	func   = INT2PTR(double(*)(double, double, double), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, d2);
OUTPUT:
	RETVAL

double
nci_ddds( c_func, d0, d1, s2 )
	SV* c_func
	double d0
	double d1
	short s2
PREINIT:
	double(*func)(double, double, short);
CODE:
	func   = INT2PTR(double(*)(double, double, short), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, s2);
OUTPUT:
	RETVAL

double
nci_dddf( c_func, d0, d1, f2 )
	SV* c_func
	double d0
	double d1
	float f2
PREINIT:
	double(*func)(double, double, float);
CODE:
	func   = INT2PTR(double(*)(double, double, float), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, f2);
OUTPUT:
	RETVAL

double
nci_dddt( c_func, d0, d1, t2 )
	SV* c_func
	double d0
	double d1
	char * t2
PREINIT:
	double(*func)(double, double, char *);
CODE:
	func   = INT2PTR(double(*)(double, double, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, t2);
OUTPUT:
	RETVAL

double
nci_dddi( c_func, d0, d1, i2 )
	SV* c_func
	double d0
	double d1
	int i2
PREINIT:
	double(*func)(double, double, int);
CODE:
	func   = INT2PTR(double(*)(double, double, int), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, i2);
OUTPUT:
	RETVAL

double
nci_ddsp( c_func, d0, s1, p2 )
	SV* c_func
	double d0
	short s1
	void * p2
PREINIT:
	double(*func)(double, short, void *);
CODE:
	func   = INT2PTR(double(*)(double, short, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, p2);
OUTPUT:
	RETVAL

double
nci_ddsd( c_func, d0, s1, d2 )
	SV* c_func
	double d0
	short s1
	double d2
PREINIT:
	double(*func)(double, short, double);
CODE:
	func   = INT2PTR(double(*)(double, short, double), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, d2);
OUTPUT:
	RETVAL

double
nci_ddss( c_func, d0, s1, s2 )
	SV* c_func
	double d0
	short s1
	short s2
PREINIT:
	double(*func)(double, short, short);
CODE:
	func   = INT2PTR(double(*)(double, short, short), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, s2);
OUTPUT:
	RETVAL

double
nci_ddsf( c_func, d0, s1, f2 )
	SV* c_func
	double d0
	short s1
	float f2
PREINIT:
	double(*func)(double, short, float);
CODE:
	func   = INT2PTR(double(*)(double, short, float), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, f2);
OUTPUT:
	RETVAL

double
nci_ddst( c_func, d0, s1, t2 )
	SV* c_func
	double d0
	short s1
	char * t2
PREINIT:
	double(*func)(double, short, char *);
CODE:
	func   = INT2PTR(double(*)(double, short, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, t2);
OUTPUT:
	RETVAL

double
nci_ddsi( c_func, d0, s1, i2 )
	SV* c_func
	double d0
	short s1
	int i2
PREINIT:
	double(*func)(double, short, int);
CODE:
	func   = INT2PTR(double(*)(double, short, int), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, i2);
OUTPUT:
	RETVAL

double
nci_ddfp( c_func, d0, f1, p2 )
	SV* c_func
	double d0
	float f1
	void * p2
PREINIT:
	double(*func)(double, float, void *);
CODE:
	func   = INT2PTR(double(*)(double, float, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, p2);
OUTPUT:
	RETVAL

double
nci_ddfd( c_func, d0, f1, d2 )
	SV* c_func
	double d0
	float f1
	double d2
PREINIT:
	double(*func)(double, float, double);
CODE:
	func   = INT2PTR(double(*)(double, float, double), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, d2);
OUTPUT:
	RETVAL

double
nci_ddfs( c_func, d0, f1, s2 )
	SV* c_func
	double d0
	float f1
	short s2
PREINIT:
	double(*func)(double, float, short);
CODE:
	func   = INT2PTR(double(*)(double, float, short), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, s2);
OUTPUT:
	RETVAL

double
nci_ddff( c_func, d0, f1, f2 )
	SV* c_func
	double d0
	float f1
	float f2
PREINIT:
	double(*func)(double, float, float);
CODE:
	func   = INT2PTR(double(*)(double, float, float), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, f2);
OUTPUT:
	RETVAL

double
nci_ddft( c_func, d0, f1, t2 )
	SV* c_func
	double d0
	float f1
	char * t2
PREINIT:
	double(*func)(double, float, char *);
CODE:
	func   = INT2PTR(double(*)(double, float, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, t2);
OUTPUT:
	RETVAL

double
nci_ddfi( c_func, d0, f1, i2 )
	SV* c_func
	double d0
	float f1
	int i2
PREINIT:
	double(*func)(double, float, int);
CODE:
	func   = INT2PTR(double(*)(double, float, int), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, i2);
OUTPUT:
	RETVAL

double
nci_ddtp( c_func, d0, t1, p2 )
	SV* c_func
	double d0
	char * t1
	void * p2
PREINIT:
	double(*func)(double, char *, void *);
CODE:
	func   = INT2PTR(double(*)(double, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, p2);
OUTPUT:
	RETVAL

double
nci_ddtd( c_func, d0, t1, d2 )
	SV* c_func
	double d0
	char * t1
	double d2
PREINIT:
	double(*func)(double, char *, double);
CODE:
	func   = INT2PTR(double(*)(double, char *, double), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, d2);
OUTPUT:
	RETVAL

double
nci_ddts( c_func, d0, t1, s2 )
	SV* c_func
	double d0
	char * t1
	short s2
PREINIT:
	double(*func)(double, char *, short);
CODE:
	func   = INT2PTR(double(*)(double, char *, short), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, s2);
OUTPUT:
	RETVAL

double
nci_ddtf( c_func, d0, t1, f2 )
	SV* c_func
	double d0
	char * t1
	float f2
PREINIT:
	double(*func)(double, char *, float);
CODE:
	func   = INT2PTR(double(*)(double, char *, float), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, f2);
OUTPUT:
	RETVAL

double
nci_ddtt( c_func, d0, t1, t2 )
	SV* c_func
	double d0
	char * t1
	char * t2
PREINIT:
	double(*func)(double, char *, char *);
CODE:
	func   = INT2PTR(double(*)(double, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, t2);
OUTPUT:
	RETVAL

double
nci_ddti( c_func, d0, t1, i2 )
	SV* c_func
	double d0
	char * t1
	int i2
PREINIT:
	double(*func)(double, char *, int);
CODE:
	func   = INT2PTR(double(*)(double, char *, int), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, i2);
OUTPUT:
	RETVAL

double
nci_ddip( c_func, d0, i1, p2 )
	SV* c_func
	double d0
	int i1
	void * p2
PREINIT:
	double(*func)(double, int, void *);
CODE:
	func   = INT2PTR(double(*)(double, int, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, p2);
OUTPUT:
	RETVAL

double
nci_ddid( c_func, d0, i1, d2 )
	SV* c_func
	double d0
	int i1
	double d2
PREINIT:
	double(*func)(double, int, double);
CODE:
	func   = INT2PTR(double(*)(double, int, double), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, d2);
OUTPUT:
	RETVAL

double
nci_ddis( c_func, d0, i1, s2 )
	SV* c_func
	double d0
	int i1
	short s2
PREINIT:
	double(*func)(double, int, short);
CODE:
	func   = INT2PTR(double(*)(double, int, short), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, s2);
OUTPUT:
	RETVAL

double
nci_ddif( c_func, d0, i1, f2 )
	SV* c_func
	double d0
	int i1
	float f2
PREINIT:
	double(*func)(double, int, float);
CODE:
	func   = INT2PTR(double(*)(double, int, float), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, f2);
OUTPUT:
	RETVAL

double
nci_ddit( c_func, d0, i1, t2 )
	SV* c_func
	double d0
	int i1
	char * t2
PREINIT:
	double(*func)(double, int, char *);
CODE:
	func   = INT2PTR(double(*)(double, int, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, t2);
OUTPUT:
	RETVAL

double
nci_ddii( c_func, d0, i1, i2 )
	SV* c_func
	double d0
	int i1
	int i2
PREINIT:
	double(*func)(double, int, int);
CODE:
	func   = INT2PTR(double(*)(double, int, int), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, i2);
OUTPUT:
	RETVAL

double
nci_dspp( c_func, s0, p1, p2 )
	SV* c_func
	short s0
	void * p1
	void * p2
PREINIT:
	double(*func)(short, void *, void *);
CODE:
	func   = INT2PTR(double(*)(short, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, p2);
OUTPUT:
	RETVAL

double
nci_dspd( c_func, s0, p1, d2 )
	SV* c_func
	short s0
	void * p1
	double d2
PREINIT:
	double(*func)(short, void *, double);
CODE:
	func   = INT2PTR(double(*)(short, void *, double), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, d2);
OUTPUT:
	RETVAL

double
nci_dsps( c_func, s0, p1, s2 )
	SV* c_func
	short s0
	void * p1
	short s2
PREINIT:
	double(*func)(short, void *, short);
CODE:
	func   = INT2PTR(double(*)(short, void *, short), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, s2);
OUTPUT:
	RETVAL

double
nci_dspf( c_func, s0, p1, f2 )
	SV* c_func
	short s0
	void * p1
	float f2
PREINIT:
	double(*func)(short, void *, float);
CODE:
	func   = INT2PTR(double(*)(short, void *, float), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, f2);
OUTPUT:
	RETVAL

double
nci_dspt( c_func, s0, p1, t2 )
	SV* c_func
	short s0
	void * p1
	char * t2
PREINIT:
	double(*func)(short, void *, char *);
CODE:
	func   = INT2PTR(double(*)(short, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, t2);
OUTPUT:
	RETVAL

double
nci_dspi( c_func, s0, p1, i2 )
	SV* c_func
	short s0
	void * p1
	int i2
PREINIT:
	double(*func)(short, void *, int);
CODE:
	func   = INT2PTR(double(*)(short, void *, int), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, i2);
OUTPUT:
	RETVAL

double
nci_dsdp( c_func, s0, d1, p2 )
	SV* c_func
	short s0
	double d1
	void * p2
PREINIT:
	double(*func)(short, double, void *);
CODE:
	func   = INT2PTR(double(*)(short, double, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, p2);
OUTPUT:
	RETVAL

double
nci_dsdd( c_func, s0, d1, d2 )
	SV* c_func
	short s0
	double d1
	double d2
PREINIT:
	double(*func)(short, double, double);
CODE:
	func   = INT2PTR(double(*)(short, double, double), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, d2);
OUTPUT:
	RETVAL

double
nci_dsds( c_func, s0, d1, s2 )
	SV* c_func
	short s0
	double d1
	short s2
PREINIT:
	double(*func)(short, double, short);
CODE:
	func   = INT2PTR(double(*)(short, double, short), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, s2);
OUTPUT:
	RETVAL

double
nci_dsdf( c_func, s0, d1, f2 )
	SV* c_func
	short s0
	double d1
	float f2
PREINIT:
	double(*func)(short, double, float);
CODE:
	func   = INT2PTR(double(*)(short, double, float), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, f2);
OUTPUT:
	RETVAL

double
nci_dsdt( c_func, s0, d1, t2 )
	SV* c_func
	short s0
	double d1
	char * t2
PREINIT:
	double(*func)(short, double, char *);
CODE:
	func   = INT2PTR(double(*)(short, double, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, t2);
OUTPUT:
	RETVAL

double
nci_dsdi( c_func, s0, d1, i2 )
	SV* c_func
	short s0
	double d1
	int i2
PREINIT:
	double(*func)(short, double, int);
CODE:
	func   = INT2PTR(double(*)(short, double, int), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, i2);
OUTPUT:
	RETVAL

double
nci_dssp( c_func, s0, s1, p2 )
	SV* c_func
	short s0
	short s1
	void * p2
PREINIT:
	double(*func)(short, short, void *);
CODE:
	func   = INT2PTR(double(*)(short, short, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, p2);
OUTPUT:
	RETVAL

double
nci_dssd( c_func, s0, s1, d2 )
	SV* c_func
	short s0
	short s1
	double d2
PREINIT:
	double(*func)(short, short, double);
CODE:
	func   = INT2PTR(double(*)(short, short, double), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, d2);
OUTPUT:
	RETVAL

double
nci_dsss( c_func, s0, s1, s2 )
	SV* c_func
	short s0
	short s1
	short s2
PREINIT:
	double(*func)(short, short, short);
CODE:
	func   = INT2PTR(double(*)(short, short, short), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, s2);
OUTPUT:
	RETVAL

double
nci_dssf( c_func, s0, s1, f2 )
	SV* c_func
	short s0
	short s1
	float f2
PREINIT:
	double(*func)(short, short, float);
CODE:
	func   = INT2PTR(double(*)(short, short, float), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, f2);
OUTPUT:
	RETVAL

double
nci_dsst( c_func, s0, s1, t2 )
	SV* c_func
	short s0
	short s1
	char * t2
PREINIT:
	double(*func)(short, short, char *);
CODE:
	func   = INT2PTR(double(*)(short, short, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, t2);
OUTPUT:
	RETVAL

double
nci_dssi( c_func, s0, s1, i2 )
	SV* c_func
	short s0
	short s1
	int i2
PREINIT:
	double(*func)(short, short, int);
CODE:
	func   = INT2PTR(double(*)(short, short, int), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, i2);
OUTPUT:
	RETVAL

double
nci_dsfp( c_func, s0, f1, p2 )
	SV* c_func
	short s0
	float f1
	void * p2
PREINIT:
	double(*func)(short, float, void *);
CODE:
	func   = INT2PTR(double(*)(short, float, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, p2);
OUTPUT:
	RETVAL

double
nci_dsfd( c_func, s0, f1, d2 )
	SV* c_func
	short s0
	float f1
	double d2
PREINIT:
	double(*func)(short, float, double);
CODE:
	func   = INT2PTR(double(*)(short, float, double), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, d2);
OUTPUT:
	RETVAL

double
nci_dsfs( c_func, s0, f1, s2 )
	SV* c_func
	short s0
	float f1
	short s2
PREINIT:
	double(*func)(short, float, short);
CODE:
	func   = INT2PTR(double(*)(short, float, short), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, s2);
OUTPUT:
	RETVAL

double
nci_dsff( c_func, s0, f1, f2 )
	SV* c_func
	short s0
	float f1
	float f2
PREINIT:
	double(*func)(short, float, float);
CODE:
	func   = INT2PTR(double(*)(short, float, float), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, f2);
OUTPUT:
	RETVAL

double
nci_dsft( c_func, s0, f1, t2 )
	SV* c_func
	short s0
	float f1
	char * t2
PREINIT:
	double(*func)(short, float, char *);
CODE:
	func   = INT2PTR(double(*)(short, float, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, t2);
OUTPUT:
	RETVAL

double
nci_dsfi( c_func, s0, f1, i2 )
	SV* c_func
	short s0
	float f1
	int i2
PREINIT:
	double(*func)(short, float, int);
CODE:
	func   = INT2PTR(double(*)(short, float, int), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, i2);
OUTPUT:
	RETVAL

double
nci_dstp( c_func, s0, t1, p2 )
	SV* c_func
	short s0
	char * t1
	void * p2
PREINIT:
	double(*func)(short, char *, void *);
CODE:
	func   = INT2PTR(double(*)(short, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, p2);
OUTPUT:
	RETVAL

double
nci_dstd( c_func, s0, t1, d2 )
	SV* c_func
	short s0
	char * t1
	double d2
PREINIT:
	double(*func)(short, char *, double);
CODE:
	func   = INT2PTR(double(*)(short, char *, double), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, d2);
OUTPUT:
	RETVAL

double
nci_dsts( c_func, s0, t1, s2 )
	SV* c_func
	short s0
	char * t1
	short s2
PREINIT:
	double(*func)(short, char *, short);
CODE:
	func   = INT2PTR(double(*)(short, char *, short), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, s2);
OUTPUT:
	RETVAL

double
nci_dstf( c_func, s0, t1, f2 )
	SV* c_func
	short s0
	char * t1
	float f2
PREINIT:
	double(*func)(short, char *, float);
CODE:
	func   = INT2PTR(double(*)(short, char *, float), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, f2);
OUTPUT:
	RETVAL

double
nci_dstt( c_func, s0, t1, t2 )
	SV* c_func
	short s0
	char * t1
	char * t2
PREINIT:
	double(*func)(short, char *, char *);
CODE:
	func   = INT2PTR(double(*)(short, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, t2);
OUTPUT:
	RETVAL

double
nci_dsti( c_func, s0, t1, i2 )
	SV* c_func
	short s0
	char * t1
	int i2
PREINIT:
	double(*func)(short, char *, int);
CODE:
	func   = INT2PTR(double(*)(short, char *, int), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, i2);
OUTPUT:
	RETVAL

double
nci_dsip( c_func, s0, i1, p2 )
	SV* c_func
	short s0
	int i1
	void * p2
PREINIT:
	double(*func)(short, int, void *);
CODE:
	func   = INT2PTR(double(*)(short, int, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, p2);
OUTPUT:
	RETVAL

double
nci_dsid( c_func, s0, i1, d2 )
	SV* c_func
	short s0
	int i1
	double d2
PREINIT:
	double(*func)(short, int, double);
CODE:
	func   = INT2PTR(double(*)(short, int, double), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, d2);
OUTPUT:
	RETVAL

double
nci_dsis( c_func, s0, i1, s2 )
	SV* c_func
	short s0
	int i1
	short s2
PREINIT:
	double(*func)(short, int, short);
CODE:
	func   = INT2PTR(double(*)(short, int, short), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, s2);
OUTPUT:
	RETVAL

double
nci_dsif( c_func, s0, i1, f2 )
	SV* c_func
	short s0
	int i1
	float f2
PREINIT:
	double(*func)(short, int, float);
CODE:
	func   = INT2PTR(double(*)(short, int, float), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, f2);
OUTPUT:
	RETVAL

double
nci_dsit( c_func, s0, i1, t2 )
	SV* c_func
	short s0
	int i1
	char * t2
PREINIT:
	double(*func)(short, int, char *);
CODE:
	func   = INT2PTR(double(*)(short, int, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, t2);
OUTPUT:
	RETVAL

double
nci_dsii( c_func, s0, i1, i2 )
	SV* c_func
	short s0
	int i1
	int i2
PREINIT:
	double(*func)(short, int, int);
CODE:
	func   = INT2PTR(double(*)(short, int, int), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, i2);
OUTPUT:
	RETVAL

double
nci_dfpp( c_func, f0, p1, p2 )
	SV* c_func
	float f0
	void * p1
	void * p2
PREINIT:
	double(*func)(float, void *, void *);
CODE:
	func   = INT2PTR(double(*)(float, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, p2);
OUTPUT:
	RETVAL

double
nci_dfpd( c_func, f0, p1, d2 )
	SV* c_func
	float f0
	void * p1
	double d2
PREINIT:
	double(*func)(float, void *, double);
CODE:
	func   = INT2PTR(double(*)(float, void *, double), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, d2);
OUTPUT:
	RETVAL

double
nci_dfps( c_func, f0, p1, s2 )
	SV* c_func
	float f0
	void * p1
	short s2
PREINIT:
	double(*func)(float, void *, short);
CODE:
	func   = INT2PTR(double(*)(float, void *, short), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, s2);
OUTPUT:
	RETVAL

double
nci_dfpf( c_func, f0, p1, f2 )
	SV* c_func
	float f0
	void * p1
	float f2
PREINIT:
	double(*func)(float, void *, float);
CODE:
	func   = INT2PTR(double(*)(float, void *, float), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, f2);
OUTPUT:
	RETVAL

double
nci_dfpt( c_func, f0, p1, t2 )
	SV* c_func
	float f0
	void * p1
	char * t2
PREINIT:
	double(*func)(float, void *, char *);
CODE:
	func   = INT2PTR(double(*)(float, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, t2);
OUTPUT:
	RETVAL

double
nci_dfpi( c_func, f0, p1, i2 )
	SV* c_func
	float f0
	void * p1
	int i2
PREINIT:
	double(*func)(float, void *, int);
CODE:
	func   = INT2PTR(double(*)(float, void *, int), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, i2);
OUTPUT:
	RETVAL

double
nci_dfdp( c_func, f0, d1, p2 )
	SV* c_func
	float f0
	double d1
	void * p2
PREINIT:
	double(*func)(float, double, void *);
CODE:
	func   = INT2PTR(double(*)(float, double, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, p2);
OUTPUT:
	RETVAL

double
nci_dfdd( c_func, f0, d1, d2 )
	SV* c_func
	float f0
	double d1
	double d2
PREINIT:
	double(*func)(float, double, double);
CODE:
	func   = INT2PTR(double(*)(float, double, double), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, d2);
OUTPUT:
	RETVAL

double
nci_dfds( c_func, f0, d1, s2 )
	SV* c_func
	float f0
	double d1
	short s2
PREINIT:
	double(*func)(float, double, short);
CODE:
	func   = INT2PTR(double(*)(float, double, short), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, s2);
OUTPUT:
	RETVAL

double
nci_dfdf( c_func, f0, d1, f2 )
	SV* c_func
	float f0
	double d1
	float f2
PREINIT:
	double(*func)(float, double, float);
CODE:
	func   = INT2PTR(double(*)(float, double, float), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, f2);
OUTPUT:
	RETVAL

double
nci_dfdt( c_func, f0, d1, t2 )
	SV* c_func
	float f0
	double d1
	char * t2
PREINIT:
	double(*func)(float, double, char *);
CODE:
	func   = INT2PTR(double(*)(float, double, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, t2);
OUTPUT:
	RETVAL

double
nci_dfdi( c_func, f0, d1, i2 )
	SV* c_func
	float f0
	double d1
	int i2
PREINIT:
	double(*func)(float, double, int);
CODE:
	func   = INT2PTR(double(*)(float, double, int), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, i2);
OUTPUT:
	RETVAL

double
nci_dfsp( c_func, f0, s1, p2 )
	SV* c_func
	float f0
	short s1
	void * p2
PREINIT:
	double(*func)(float, short, void *);
CODE:
	func   = INT2PTR(double(*)(float, short, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, p2);
OUTPUT:
	RETVAL

double
nci_dfsd( c_func, f0, s1, d2 )
	SV* c_func
	float f0
	short s1
	double d2
PREINIT:
	double(*func)(float, short, double);
CODE:
	func   = INT2PTR(double(*)(float, short, double), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, d2);
OUTPUT:
	RETVAL

double
nci_dfss( c_func, f0, s1, s2 )
	SV* c_func
	float f0
	short s1
	short s2
PREINIT:
	double(*func)(float, short, short);
CODE:
	func   = INT2PTR(double(*)(float, short, short), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, s2);
OUTPUT:
	RETVAL

double
nci_dfsf( c_func, f0, s1, f2 )
	SV* c_func
	float f0
	short s1
	float f2
PREINIT:
	double(*func)(float, short, float);
CODE:
	func   = INT2PTR(double(*)(float, short, float), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, f2);
OUTPUT:
	RETVAL

double
nci_dfst( c_func, f0, s1, t2 )
	SV* c_func
	float f0
	short s1
	char * t2
PREINIT:
	double(*func)(float, short, char *);
CODE:
	func   = INT2PTR(double(*)(float, short, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, t2);
OUTPUT:
	RETVAL

double
nci_dfsi( c_func, f0, s1, i2 )
	SV* c_func
	float f0
	short s1
	int i2
PREINIT:
	double(*func)(float, short, int);
CODE:
	func   = INT2PTR(double(*)(float, short, int), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, i2);
OUTPUT:
	RETVAL

double
nci_dffp( c_func, f0, f1, p2 )
	SV* c_func
	float f0
	float f1
	void * p2
PREINIT:
	double(*func)(float, float, void *);
CODE:
	func   = INT2PTR(double(*)(float, float, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, p2);
OUTPUT:
	RETVAL

double
nci_dffd( c_func, f0, f1, d2 )
	SV* c_func
	float f0
	float f1
	double d2
PREINIT:
	double(*func)(float, float, double);
CODE:
	func   = INT2PTR(double(*)(float, float, double), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, d2);
OUTPUT:
	RETVAL

double
nci_dffs( c_func, f0, f1, s2 )
	SV* c_func
	float f0
	float f1
	short s2
PREINIT:
	double(*func)(float, float, short);
CODE:
	func   = INT2PTR(double(*)(float, float, short), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, s2);
OUTPUT:
	RETVAL

double
nci_dfff( c_func, f0, f1, f2 )
	SV* c_func
	float f0
	float f1
	float f2
PREINIT:
	double(*func)(float, float, float);
CODE:
	func   = INT2PTR(double(*)(float, float, float), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, f2);
OUTPUT:
	RETVAL

double
nci_dfft( c_func, f0, f1, t2 )
	SV* c_func
	float f0
	float f1
	char * t2
PREINIT:
	double(*func)(float, float, char *);
CODE:
	func   = INT2PTR(double(*)(float, float, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, t2);
OUTPUT:
	RETVAL

double
nci_dffi( c_func, f0, f1, i2 )
	SV* c_func
	float f0
	float f1
	int i2
PREINIT:
	double(*func)(float, float, int);
CODE:
	func   = INT2PTR(double(*)(float, float, int), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, i2);
OUTPUT:
	RETVAL

double
nci_dftp( c_func, f0, t1, p2 )
	SV* c_func
	float f0
	char * t1
	void * p2
PREINIT:
	double(*func)(float, char *, void *);
CODE:
	func   = INT2PTR(double(*)(float, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, p2);
OUTPUT:
	RETVAL

double
nci_dftd( c_func, f0, t1, d2 )
	SV* c_func
	float f0
	char * t1
	double d2
PREINIT:
	double(*func)(float, char *, double);
CODE:
	func   = INT2PTR(double(*)(float, char *, double), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, d2);
OUTPUT:
	RETVAL

double
nci_dfts( c_func, f0, t1, s2 )
	SV* c_func
	float f0
	char * t1
	short s2
PREINIT:
	double(*func)(float, char *, short);
CODE:
	func   = INT2PTR(double(*)(float, char *, short), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, s2);
OUTPUT:
	RETVAL

double
nci_dftf( c_func, f0, t1, f2 )
	SV* c_func
	float f0
	char * t1
	float f2
PREINIT:
	double(*func)(float, char *, float);
CODE:
	func   = INT2PTR(double(*)(float, char *, float), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, f2);
OUTPUT:
	RETVAL

double
nci_dftt( c_func, f0, t1, t2 )
	SV* c_func
	float f0
	char * t1
	char * t2
PREINIT:
	double(*func)(float, char *, char *);
CODE:
	func   = INT2PTR(double(*)(float, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, t2);
OUTPUT:
	RETVAL

double
nci_dfti( c_func, f0, t1, i2 )
	SV* c_func
	float f0
	char * t1
	int i2
PREINIT:
	double(*func)(float, char *, int);
CODE:
	func   = INT2PTR(double(*)(float, char *, int), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, i2);
OUTPUT:
	RETVAL

double
nci_dfip( c_func, f0, i1, p2 )
	SV* c_func
	float f0
	int i1
	void * p2
PREINIT:
	double(*func)(float, int, void *);
CODE:
	func   = INT2PTR(double(*)(float, int, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, p2);
OUTPUT:
	RETVAL

double
nci_dfid( c_func, f0, i1, d2 )
	SV* c_func
	float f0
	int i1
	double d2
PREINIT:
	double(*func)(float, int, double);
CODE:
	func   = INT2PTR(double(*)(float, int, double), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, d2);
OUTPUT:
	RETVAL

double
nci_dfis( c_func, f0, i1, s2 )
	SV* c_func
	float f0
	int i1
	short s2
PREINIT:
	double(*func)(float, int, short);
CODE:
	func   = INT2PTR(double(*)(float, int, short), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, s2);
OUTPUT:
	RETVAL

double
nci_dfif( c_func, f0, i1, f2 )
	SV* c_func
	float f0
	int i1
	float f2
PREINIT:
	double(*func)(float, int, float);
CODE:
	func   = INT2PTR(double(*)(float, int, float), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, f2);
OUTPUT:
	RETVAL

double
nci_dfit( c_func, f0, i1, t2 )
	SV* c_func
	float f0
	int i1
	char * t2
PREINIT:
	double(*func)(float, int, char *);
CODE:
	func   = INT2PTR(double(*)(float, int, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, t2);
OUTPUT:
	RETVAL

double
nci_dfii( c_func, f0, i1, i2 )
	SV* c_func
	float f0
	int i1
	int i2
PREINIT:
	double(*func)(float, int, int);
CODE:
	func   = INT2PTR(double(*)(float, int, int), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, i2);
OUTPUT:
	RETVAL

double
nci_dtpp( c_func, t0, p1, p2 )
	SV* c_func
	char * t0
	void * p1
	void * p2
PREINIT:
	double(*func)(char *, void *, void *);
CODE:
	func   = INT2PTR(double(*)(char *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, p2);
OUTPUT:
	RETVAL

double
nci_dtpd( c_func, t0, p1, d2 )
	SV* c_func
	char * t0
	void * p1
	double d2
PREINIT:
	double(*func)(char *, void *, double);
CODE:
	func   = INT2PTR(double(*)(char *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, d2);
OUTPUT:
	RETVAL

double
nci_dtps( c_func, t0, p1, s2 )
	SV* c_func
	char * t0
	void * p1
	short s2
PREINIT:
	double(*func)(char *, void *, short);
CODE:
	func   = INT2PTR(double(*)(char *, void *, short), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, s2);
OUTPUT:
	RETVAL

double
nci_dtpf( c_func, t0, p1, f2 )
	SV* c_func
	char * t0
	void * p1
	float f2
PREINIT:
	double(*func)(char *, void *, float);
CODE:
	func   = INT2PTR(double(*)(char *, void *, float), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, f2);
OUTPUT:
	RETVAL

double
nci_dtpt( c_func, t0, p1, t2 )
	SV* c_func
	char * t0
	void * p1
	char * t2
PREINIT:
	double(*func)(char *, void *, char *);
CODE:
	func   = INT2PTR(double(*)(char *, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, t2);
OUTPUT:
	RETVAL

double
nci_dtpi( c_func, t0, p1, i2 )
	SV* c_func
	char * t0
	void * p1
	int i2
PREINIT:
	double(*func)(char *, void *, int);
CODE:
	func   = INT2PTR(double(*)(char *, void *, int), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, i2);
OUTPUT:
	RETVAL

double
nci_dtdp( c_func, t0, d1, p2 )
	SV* c_func
	char * t0
	double d1
	void * p2
PREINIT:
	double(*func)(char *, double, void *);
CODE:
	func   = INT2PTR(double(*)(char *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, p2);
OUTPUT:
	RETVAL

double
nci_dtdd( c_func, t0, d1, d2 )
	SV* c_func
	char * t0
	double d1
	double d2
PREINIT:
	double(*func)(char *, double, double);
CODE:
	func   = INT2PTR(double(*)(char *, double, double), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, d2);
OUTPUT:
	RETVAL

double
nci_dtds( c_func, t0, d1, s2 )
	SV* c_func
	char * t0
	double d1
	short s2
PREINIT:
	double(*func)(char *, double, short);
CODE:
	func   = INT2PTR(double(*)(char *, double, short), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, s2);
OUTPUT:
	RETVAL

double
nci_dtdf( c_func, t0, d1, f2 )
	SV* c_func
	char * t0
	double d1
	float f2
PREINIT:
	double(*func)(char *, double, float);
CODE:
	func   = INT2PTR(double(*)(char *, double, float), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, f2);
OUTPUT:
	RETVAL

double
nci_dtdt( c_func, t0, d1, t2 )
	SV* c_func
	char * t0
	double d1
	char * t2
PREINIT:
	double(*func)(char *, double, char *);
CODE:
	func   = INT2PTR(double(*)(char *, double, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, t2);
OUTPUT:
	RETVAL

double
nci_dtdi( c_func, t0, d1, i2 )
	SV* c_func
	char * t0
	double d1
	int i2
PREINIT:
	double(*func)(char *, double, int);
CODE:
	func   = INT2PTR(double(*)(char *, double, int), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, i2);
OUTPUT:
	RETVAL

double
nci_dtsp( c_func, t0, s1, p2 )
	SV* c_func
	char * t0
	short s1
	void * p2
PREINIT:
	double(*func)(char *, short, void *);
CODE:
	func   = INT2PTR(double(*)(char *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, p2);
OUTPUT:
	RETVAL

double
nci_dtsd( c_func, t0, s1, d2 )
	SV* c_func
	char * t0
	short s1
	double d2
PREINIT:
	double(*func)(char *, short, double);
CODE:
	func   = INT2PTR(double(*)(char *, short, double), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, d2);
OUTPUT:
	RETVAL

double
nci_dtss( c_func, t0, s1, s2 )
	SV* c_func
	char * t0
	short s1
	short s2
PREINIT:
	double(*func)(char *, short, short);
CODE:
	func   = INT2PTR(double(*)(char *, short, short), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, s2);
OUTPUT:
	RETVAL

double
nci_dtsf( c_func, t0, s1, f2 )
	SV* c_func
	char * t0
	short s1
	float f2
PREINIT:
	double(*func)(char *, short, float);
CODE:
	func   = INT2PTR(double(*)(char *, short, float), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, f2);
OUTPUT:
	RETVAL

double
nci_dtst( c_func, t0, s1, t2 )
	SV* c_func
	char * t0
	short s1
	char * t2
PREINIT:
	double(*func)(char *, short, char *);
CODE:
	func   = INT2PTR(double(*)(char *, short, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, t2);
OUTPUT:
	RETVAL

double
nci_dtsi( c_func, t0, s1, i2 )
	SV* c_func
	char * t0
	short s1
	int i2
PREINIT:
	double(*func)(char *, short, int);
CODE:
	func   = INT2PTR(double(*)(char *, short, int), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, i2);
OUTPUT:
	RETVAL

double
nci_dtfp( c_func, t0, f1, p2 )
	SV* c_func
	char * t0
	float f1
	void * p2
PREINIT:
	double(*func)(char *, float, void *);
CODE:
	func   = INT2PTR(double(*)(char *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, p2);
OUTPUT:
	RETVAL

double
nci_dtfd( c_func, t0, f1, d2 )
	SV* c_func
	char * t0
	float f1
	double d2
PREINIT:
	double(*func)(char *, float, double);
CODE:
	func   = INT2PTR(double(*)(char *, float, double), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, d2);
OUTPUT:
	RETVAL

double
nci_dtfs( c_func, t0, f1, s2 )
	SV* c_func
	char * t0
	float f1
	short s2
PREINIT:
	double(*func)(char *, float, short);
CODE:
	func   = INT2PTR(double(*)(char *, float, short), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, s2);
OUTPUT:
	RETVAL

double
nci_dtff( c_func, t0, f1, f2 )
	SV* c_func
	char * t0
	float f1
	float f2
PREINIT:
	double(*func)(char *, float, float);
CODE:
	func   = INT2PTR(double(*)(char *, float, float), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, f2);
OUTPUT:
	RETVAL

double
nci_dtft( c_func, t0, f1, t2 )
	SV* c_func
	char * t0
	float f1
	char * t2
PREINIT:
	double(*func)(char *, float, char *);
CODE:
	func   = INT2PTR(double(*)(char *, float, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, t2);
OUTPUT:
	RETVAL

double
nci_dtfi( c_func, t0, f1, i2 )
	SV* c_func
	char * t0
	float f1
	int i2
PREINIT:
	double(*func)(char *, float, int);
CODE:
	func   = INT2PTR(double(*)(char *, float, int), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, i2);
OUTPUT:
	RETVAL

double
nci_dttp( c_func, t0, t1, p2 )
	SV* c_func
	char * t0
	char * t1
	void * p2
PREINIT:
	double(*func)(char *, char *, void *);
CODE:
	func   = INT2PTR(double(*)(char *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, p2);
OUTPUT:
	RETVAL

double
nci_dttd( c_func, t0, t1, d2 )
	SV* c_func
	char * t0
	char * t1
	double d2
PREINIT:
	double(*func)(char *, char *, double);
CODE:
	func   = INT2PTR(double(*)(char *, char *, double), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, d2);
OUTPUT:
	RETVAL

double
nci_dtts( c_func, t0, t1, s2 )
	SV* c_func
	char * t0
	char * t1
	short s2
PREINIT:
	double(*func)(char *, char *, short);
CODE:
	func   = INT2PTR(double(*)(char *, char *, short), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, s2);
OUTPUT:
	RETVAL

double
nci_dttf( c_func, t0, t1, f2 )
	SV* c_func
	char * t0
	char * t1
	float f2
PREINIT:
	double(*func)(char *, char *, float);
CODE:
	func   = INT2PTR(double(*)(char *, char *, float), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, f2);
OUTPUT:
	RETVAL

double
nci_dttt( c_func, t0, t1, t2 )
	SV* c_func
	char * t0
	char * t1
	char * t2
PREINIT:
	double(*func)(char *, char *, char *);
CODE:
	func   = INT2PTR(double(*)(char *, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, t2);
OUTPUT:
	RETVAL

double
nci_dtti( c_func, t0, t1, i2 )
	SV* c_func
	char * t0
	char * t1
	int i2
PREINIT:
	double(*func)(char *, char *, int);
CODE:
	func   = INT2PTR(double(*)(char *, char *, int), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, i2);
OUTPUT:
	RETVAL

double
nci_dtip( c_func, t0, i1, p2 )
	SV* c_func
	char * t0
	int i1
	void * p2
PREINIT:
	double(*func)(char *, int, void *);
CODE:
	func   = INT2PTR(double(*)(char *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, p2);
OUTPUT:
	RETVAL

double
nci_dtid( c_func, t0, i1, d2 )
	SV* c_func
	char * t0
	int i1
	double d2
PREINIT:
	double(*func)(char *, int, double);
CODE:
	func   = INT2PTR(double(*)(char *, int, double), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, d2);
OUTPUT:
	RETVAL

double
nci_dtis( c_func, t0, i1, s2 )
	SV* c_func
	char * t0
	int i1
	short s2
PREINIT:
	double(*func)(char *, int, short);
CODE:
	func   = INT2PTR(double(*)(char *, int, short), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, s2);
OUTPUT:
	RETVAL

double
nci_dtif( c_func, t0, i1, f2 )
	SV* c_func
	char * t0
	int i1
	float f2
PREINIT:
	double(*func)(char *, int, float);
CODE:
	func   = INT2PTR(double(*)(char *, int, float), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, f2);
OUTPUT:
	RETVAL

double
nci_dtit( c_func, t0, i1, t2 )
	SV* c_func
	char * t0
	int i1
	char * t2
PREINIT:
	double(*func)(char *, int, char *);
CODE:
	func   = INT2PTR(double(*)(char *, int, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, t2);
OUTPUT:
	RETVAL

double
nci_dtii( c_func, t0, i1, i2 )
	SV* c_func
	char * t0
	int i1
	int i2
PREINIT:
	double(*func)(char *, int, int);
CODE:
	func   = INT2PTR(double(*)(char *, int, int), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, i2);
OUTPUT:
	RETVAL

double
nci_dipp( c_func, i0, p1, p2 )
	SV* c_func
	int i0
	void * p1
	void * p2
PREINIT:
	double(*func)(int, void *, void *);
CODE:
	func   = INT2PTR(double(*)(int, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, p2);
OUTPUT:
	RETVAL

double
nci_dipd( c_func, i0, p1, d2 )
	SV* c_func
	int i0
	void * p1
	double d2
PREINIT:
	double(*func)(int, void *, double);
CODE:
	func   = INT2PTR(double(*)(int, void *, double), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, d2);
OUTPUT:
	RETVAL

double
nci_dips( c_func, i0, p1, s2 )
	SV* c_func
	int i0
	void * p1
	short s2
PREINIT:
	double(*func)(int, void *, short);
CODE:
	func   = INT2PTR(double(*)(int, void *, short), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, s2);
OUTPUT:
	RETVAL

double
nci_dipf( c_func, i0, p1, f2 )
	SV* c_func
	int i0
	void * p1
	float f2
PREINIT:
	double(*func)(int, void *, float);
CODE:
	func   = INT2PTR(double(*)(int, void *, float), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, f2);
OUTPUT:
	RETVAL

double
nci_dipt( c_func, i0, p1, t2 )
	SV* c_func
	int i0
	void * p1
	char * t2
PREINIT:
	double(*func)(int, void *, char *);
CODE:
	func   = INT2PTR(double(*)(int, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, t2);
OUTPUT:
	RETVAL

double
nci_dipi( c_func, i0, p1, i2 )
	SV* c_func
	int i0
	void * p1
	int i2
PREINIT:
	double(*func)(int, void *, int);
CODE:
	func   = INT2PTR(double(*)(int, void *, int), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, i2);
OUTPUT:
	RETVAL

double
nci_didp( c_func, i0, d1, p2 )
	SV* c_func
	int i0
	double d1
	void * p2
PREINIT:
	double(*func)(int, double, void *);
CODE:
	func   = INT2PTR(double(*)(int, double, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, p2);
OUTPUT:
	RETVAL

double
nci_didd( c_func, i0, d1, d2 )
	SV* c_func
	int i0
	double d1
	double d2
PREINIT:
	double(*func)(int, double, double);
CODE:
	func   = INT2PTR(double(*)(int, double, double), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, d2);
OUTPUT:
	RETVAL

double
nci_dids( c_func, i0, d1, s2 )
	SV* c_func
	int i0
	double d1
	short s2
PREINIT:
	double(*func)(int, double, short);
CODE:
	func   = INT2PTR(double(*)(int, double, short), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, s2);
OUTPUT:
	RETVAL

double
nci_didf( c_func, i0, d1, f2 )
	SV* c_func
	int i0
	double d1
	float f2
PREINIT:
	double(*func)(int, double, float);
CODE:
	func   = INT2PTR(double(*)(int, double, float), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, f2);
OUTPUT:
	RETVAL

double
nci_didt( c_func, i0, d1, t2 )
	SV* c_func
	int i0
	double d1
	char * t2
PREINIT:
	double(*func)(int, double, char *);
CODE:
	func   = INT2PTR(double(*)(int, double, char *), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, t2);
OUTPUT:
	RETVAL

double
nci_didi( c_func, i0, d1, i2 )
	SV* c_func
	int i0
	double d1
	int i2
PREINIT:
	double(*func)(int, double, int);
CODE:
	func   = INT2PTR(double(*)(int, double, int), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, i2);
OUTPUT:
	RETVAL

double
nci_disp( c_func, i0, s1, p2 )
	SV* c_func
	int i0
	short s1
	void * p2
PREINIT:
	double(*func)(int, short, void *);
CODE:
	func   = INT2PTR(double(*)(int, short, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, p2);
OUTPUT:
	RETVAL

double
nci_disd( c_func, i0, s1, d2 )
	SV* c_func
	int i0
	short s1
	double d2
PREINIT:
	double(*func)(int, short, double);
CODE:
	func   = INT2PTR(double(*)(int, short, double), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, d2);
OUTPUT:
	RETVAL

double
nci_diss( c_func, i0, s1, s2 )
	SV* c_func
	int i0
	short s1
	short s2
PREINIT:
	double(*func)(int, short, short);
CODE:
	func   = INT2PTR(double(*)(int, short, short), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, s2);
OUTPUT:
	RETVAL

double
nci_disf( c_func, i0, s1, f2 )
	SV* c_func
	int i0
	short s1
	float f2
PREINIT:
	double(*func)(int, short, float);
CODE:
	func   = INT2PTR(double(*)(int, short, float), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, f2);
OUTPUT:
	RETVAL

double
nci_dist( c_func, i0, s1, t2 )
	SV* c_func
	int i0
	short s1
	char * t2
PREINIT:
	double(*func)(int, short, char *);
CODE:
	func   = INT2PTR(double(*)(int, short, char *), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, t2);
OUTPUT:
	RETVAL

double
nci_disi( c_func, i0, s1, i2 )
	SV* c_func
	int i0
	short s1
	int i2
PREINIT:
	double(*func)(int, short, int);
CODE:
	func   = INT2PTR(double(*)(int, short, int), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, i2);
OUTPUT:
	RETVAL

double
nci_difp( c_func, i0, f1, p2 )
	SV* c_func
	int i0
	float f1
	void * p2
PREINIT:
	double(*func)(int, float, void *);
CODE:
	func   = INT2PTR(double(*)(int, float, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, p2);
OUTPUT:
	RETVAL

double
nci_difd( c_func, i0, f1, d2 )
	SV* c_func
	int i0
	float f1
	double d2
PREINIT:
	double(*func)(int, float, double);
CODE:
	func   = INT2PTR(double(*)(int, float, double), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, d2);
OUTPUT:
	RETVAL

double
nci_difs( c_func, i0, f1, s2 )
	SV* c_func
	int i0
	float f1
	short s2
PREINIT:
	double(*func)(int, float, short);
CODE:
	func   = INT2PTR(double(*)(int, float, short), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, s2);
OUTPUT:
	RETVAL

double
nci_diff( c_func, i0, f1, f2 )
	SV* c_func
	int i0
	float f1
	float f2
PREINIT:
	double(*func)(int, float, float);
CODE:
	func   = INT2PTR(double(*)(int, float, float), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, f2);
OUTPUT:
	RETVAL

double
nci_dift( c_func, i0, f1, t2 )
	SV* c_func
	int i0
	float f1
	char * t2
PREINIT:
	double(*func)(int, float, char *);
CODE:
	func   = INT2PTR(double(*)(int, float, char *), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, t2);
OUTPUT:
	RETVAL

double
nci_difi( c_func, i0, f1, i2 )
	SV* c_func
	int i0
	float f1
	int i2
PREINIT:
	double(*func)(int, float, int);
CODE:
	func   = INT2PTR(double(*)(int, float, int), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, i2);
OUTPUT:
	RETVAL

double
nci_ditp( c_func, i0, t1, p2 )
	SV* c_func
	int i0
	char * t1
	void * p2
PREINIT:
	double(*func)(int, char *, void *);
CODE:
	func   = INT2PTR(double(*)(int, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, p2);
OUTPUT:
	RETVAL

double
nci_ditd( c_func, i0, t1, d2 )
	SV* c_func
	int i0
	char * t1
	double d2
PREINIT:
	double(*func)(int, char *, double);
CODE:
	func   = INT2PTR(double(*)(int, char *, double), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, d2);
OUTPUT:
	RETVAL

double
nci_dits( c_func, i0, t1, s2 )
	SV* c_func
	int i0
	char * t1
	short s2
PREINIT:
	double(*func)(int, char *, short);
CODE:
	func   = INT2PTR(double(*)(int, char *, short), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, s2);
OUTPUT:
	RETVAL

double
nci_ditf( c_func, i0, t1, f2 )
	SV* c_func
	int i0
	char * t1
	float f2
PREINIT:
	double(*func)(int, char *, float);
CODE:
	func   = INT2PTR(double(*)(int, char *, float), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, f2);
OUTPUT:
	RETVAL

double
nci_ditt( c_func, i0, t1, t2 )
	SV* c_func
	int i0
	char * t1
	char * t2
PREINIT:
	double(*func)(int, char *, char *);
CODE:
	func   = INT2PTR(double(*)(int, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, t2);
OUTPUT:
	RETVAL

double
nci_diti( c_func, i0, t1, i2 )
	SV* c_func
	int i0
	char * t1
	int i2
PREINIT:
	double(*func)(int, char *, int);
CODE:
	func   = INT2PTR(double(*)(int, char *, int), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, i2);
OUTPUT:
	RETVAL

double
nci_diip( c_func, i0, i1, p2 )
	SV* c_func
	int i0
	int i1
	void * p2
PREINIT:
	double(*func)(int, int, void *);
CODE:
	func   = INT2PTR(double(*)(int, int, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, p2);
OUTPUT:
	RETVAL

double
nci_diid( c_func, i0, i1, d2 )
	SV* c_func
	int i0
	int i1
	double d2
PREINIT:
	double(*func)(int, int, double);
CODE:
	func   = INT2PTR(double(*)(int, int, double), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, d2);
OUTPUT:
	RETVAL

double
nci_diis( c_func, i0, i1, s2 )
	SV* c_func
	int i0
	int i1
	short s2
PREINIT:
	double(*func)(int, int, short);
CODE:
	func   = INT2PTR(double(*)(int, int, short), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, s2);
OUTPUT:
	RETVAL

double
nci_diif( c_func, i0, i1, f2 )
	SV* c_func
	int i0
	int i1
	float f2
PREINIT:
	double(*func)(int, int, float);
CODE:
	func   = INT2PTR(double(*)(int, int, float), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, f2);
OUTPUT:
	RETVAL

double
nci_diit( c_func, i0, i1, t2 )
	SV* c_func
	int i0
	int i1
	char * t2
PREINIT:
	double(*func)(int, int, char *);
CODE:
	func   = INT2PTR(double(*)(int, int, char *), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, t2);
OUTPUT:
	RETVAL

double
nci_diii( c_func, i0, i1, i2 )
	SV* c_func
	int i0
	int i1
	int i2
PREINIT:
	double(*func)(int, int, int);
CODE:
	func   = INT2PTR(double(*)(int, int, int), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, i2);
OUTPUT:
	RETVAL

short
nci_sppp( c_func, p0, p1, p2 )
	SV* c_func
	void * p0
	void * p1
	void * p2
PREINIT:
	short(*func)(void *, void *, void *);
CODE:
	func   = INT2PTR(short(*)(void *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, p2);
OUTPUT:
	RETVAL

short
nci_sppd( c_func, p0, p1, d2 )
	SV* c_func
	void * p0
	void * p1
	double d2
PREINIT:
	short(*func)(void *, void *, double);
CODE:
	func   = INT2PTR(short(*)(void *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, d2);
OUTPUT:
	RETVAL

short
nci_spps( c_func, p0, p1, s2 )
	SV* c_func
	void * p0
	void * p1
	short s2
PREINIT:
	short(*func)(void *, void *, short);
CODE:
	func   = INT2PTR(short(*)(void *, void *, short), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, s2);
OUTPUT:
	RETVAL

short
nci_sppf( c_func, p0, p1, f2 )
	SV* c_func
	void * p0
	void * p1
	float f2
PREINIT:
	short(*func)(void *, void *, float);
CODE:
	func   = INT2PTR(short(*)(void *, void *, float), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, f2);
OUTPUT:
	RETVAL

short
nci_sppt( c_func, p0, p1, t2 )
	SV* c_func
	void * p0
	void * p1
	char * t2
PREINIT:
	short(*func)(void *, void *, char *);
CODE:
	func   = INT2PTR(short(*)(void *, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, t2);
OUTPUT:
	RETVAL

short
nci_sppi( c_func, p0, p1, i2 )
	SV* c_func
	void * p0
	void * p1
	int i2
PREINIT:
	short(*func)(void *, void *, int);
CODE:
	func   = INT2PTR(short(*)(void *, void *, int), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, i2);
OUTPUT:
	RETVAL

short
nci_spdp( c_func, p0, d1, p2 )
	SV* c_func
	void * p0
	double d1
	void * p2
PREINIT:
	short(*func)(void *, double, void *);
CODE:
	func   = INT2PTR(short(*)(void *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, p2);
OUTPUT:
	RETVAL

short
nci_spdd( c_func, p0, d1, d2 )
	SV* c_func
	void * p0
	double d1
	double d2
PREINIT:
	short(*func)(void *, double, double);
CODE:
	func   = INT2PTR(short(*)(void *, double, double), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, d2);
OUTPUT:
	RETVAL

short
nci_spds( c_func, p0, d1, s2 )
	SV* c_func
	void * p0
	double d1
	short s2
PREINIT:
	short(*func)(void *, double, short);
CODE:
	func   = INT2PTR(short(*)(void *, double, short), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, s2);
OUTPUT:
	RETVAL

short
nci_spdf( c_func, p0, d1, f2 )
	SV* c_func
	void * p0
	double d1
	float f2
PREINIT:
	short(*func)(void *, double, float);
CODE:
	func   = INT2PTR(short(*)(void *, double, float), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, f2);
OUTPUT:
	RETVAL

short
nci_spdt( c_func, p0, d1, t2 )
	SV* c_func
	void * p0
	double d1
	char * t2
PREINIT:
	short(*func)(void *, double, char *);
CODE:
	func   = INT2PTR(short(*)(void *, double, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, t2);
OUTPUT:
	RETVAL

short
nci_spdi( c_func, p0, d1, i2 )
	SV* c_func
	void * p0
	double d1
	int i2
PREINIT:
	short(*func)(void *, double, int);
CODE:
	func   = INT2PTR(short(*)(void *, double, int), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, i2);
OUTPUT:
	RETVAL

short
nci_spsp( c_func, p0, s1, p2 )
	SV* c_func
	void * p0
	short s1
	void * p2
PREINIT:
	short(*func)(void *, short, void *);
CODE:
	func   = INT2PTR(short(*)(void *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, p2);
OUTPUT:
	RETVAL

short
nci_spsd( c_func, p0, s1, d2 )
	SV* c_func
	void * p0
	short s1
	double d2
PREINIT:
	short(*func)(void *, short, double);
CODE:
	func   = INT2PTR(short(*)(void *, short, double), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, d2);
OUTPUT:
	RETVAL

short
nci_spss( c_func, p0, s1, s2 )
	SV* c_func
	void * p0
	short s1
	short s2
PREINIT:
	short(*func)(void *, short, short);
CODE:
	func   = INT2PTR(short(*)(void *, short, short), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, s2);
OUTPUT:
	RETVAL

short
nci_spsf( c_func, p0, s1, f2 )
	SV* c_func
	void * p0
	short s1
	float f2
PREINIT:
	short(*func)(void *, short, float);
CODE:
	func   = INT2PTR(short(*)(void *, short, float), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, f2);
OUTPUT:
	RETVAL

short
nci_spst( c_func, p0, s1, t2 )
	SV* c_func
	void * p0
	short s1
	char * t2
PREINIT:
	short(*func)(void *, short, char *);
CODE:
	func   = INT2PTR(short(*)(void *, short, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, t2);
OUTPUT:
	RETVAL

short
nci_spsi( c_func, p0, s1, i2 )
	SV* c_func
	void * p0
	short s1
	int i2
PREINIT:
	short(*func)(void *, short, int);
CODE:
	func   = INT2PTR(short(*)(void *, short, int), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, i2);
OUTPUT:
	RETVAL

short
nci_spfp( c_func, p0, f1, p2 )
	SV* c_func
	void * p0
	float f1
	void * p2
PREINIT:
	short(*func)(void *, float, void *);
CODE:
	func   = INT2PTR(short(*)(void *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, p2);
OUTPUT:
	RETVAL

short
nci_spfd( c_func, p0, f1, d2 )
	SV* c_func
	void * p0
	float f1
	double d2
PREINIT:
	short(*func)(void *, float, double);
CODE:
	func   = INT2PTR(short(*)(void *, float, double), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, d2);
OUTPUT:
	RETVAL

short
nci_spfs( c_func, p0, f1, s2 )
	SV* c_func
	void * p0
	float f1
	short s2
PREINIT:
	short(*func)(void *, float, short);
CODE:
	func   = INT2PTR(short(*)(void *, float, short), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, s2);
OUTPUT:
	RETVAL

short
nci_spff( c_func, p0, f1, f2 )
	SV* c_func
	void * p0
	float f1
	float f2
PREINIT:
	short(*func)(void *, float, float);
CODE:
	func   = INT2PTR(short(*)(void *, float, float), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, f2);
OUTPUT:
	RETVAL

short
nci_spft( c_func, p0, f1, t2 )
	SV* c_func
	void * p0
	float f1
	char * t2
PREINIT:
	short(*func)(void *, float, char *);
CODE:
	func   = INT2PTR(short(*)(void *, float, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, t2);
OUTPUT:
	RETVAL

short
nci_spfi( c_func, p0, f1, i2 )
	SV* c_func
	void * p0
	float f1
	int i2
PREINIT:
	short(*func)(void *, float, int);
CODE:
	func   = INT2PTR(short(*)(void *, float, int), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, i2);
OUTPUT:
	RETVAL

short
nci_sptp( c_func, p0, t1, p2 )
	SV* c_func
	void * p0
	char * t1
	void * p2
PREINIT:
	short(*func)(void *, char *, void *);
CODE:
	func   = INT2PTR(short(*)(void *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, p2);
OUTPUT:
	RETVAL

short
nci_sptd( c_func, p0, t1, d2 )
	SV* c_func
	void * p0
	char * t1
	double d2
PREINIT:
	short(*func)(void *, char *, double);
CODE:
	func   = INT2PTR(short(*)(void *, char *, double), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, d2);
OUTPUT:
	RETVAL

short
nci_spts( c_func, p0, t1, s2 )
	SV* c_func
	void * p0
	char * t1
	short s2
PREINIT:
	short(*func)(void *, char *, short);
CODE:
	func   = INT2PTR(short(*)(void *, char *, short), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, s2);
OUTPUT:
	RETVAL

short
nci_sptf( c_func, p0, t1, f2 )
	SV* c_func
	void * p0
	char * t1
	float f2
PREINIT:
	short(*func)(void *, char *, float);
CODE:
	func   = INT2PTR(short(*)(void *, char *, float), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, f2);
OUTPUT:
	RETVAL

short
nci_sptt( c_func, p0, t1, t2 )
	SV* c_func
	void * p0
	char * t1
	char * t2
PREINIT:
	short(*func)(void *, char *, char *);
CODE:
	func   = INT2PTR(short(*)(void *, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, t2);
OUTPUT:
	RETVAL

short
nci_spti( c_func, p0, t1, i2 )
	SV* c_func
	void * p0
	char * t1
	int i2
PREINIT:
	short(*func)(void *, char *, int);
CODE:
	func   = INT2PTR(short(*)(void *, char *, int), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, i2);
OUTPUT:
	RETVAL

short
nci_spip( c_func, p0, i1, p2 )
	SV* c_func
	void * p0
	int i1
	void * p2
PREINIT:
	short(*func)(void *, int, void *);
CODE:
	func   = INT2PTR(short(*)(void *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, p2);
OUTPUT:
	RETVAL

short
nci_spid( c_func, p0, i1, d2 )
	SV* c_func
	void * p0
	int i1
	double d2
PREINIT:
	short(*func)(void *, int, double);
CODE:
	func   = INT2PTR(short(*)(void *, int, double), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, d2);
OUTPUT:
	RETVAL

short
nci_spis( c_func, p0, i1, s2 )
	SV* c_func
	void * p0
	int i1
	short s2
PREINIT:
	short(*func)(void *, int, short);
CODE:
	func   = INT2PTR(short(*)(void *, int, short), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, s2);
OUTPUT:
	RETVAL

short
nci_spif( c_func, p0, i1, f2 )
	SV* c_func
	void * p0
	int i1
	float f2
PREINIT:
	short(*func)(void *, int, float);
CODE:
	func   = INT2PTR(short(*)(void *, int, float), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, f2);
OUTPUT:
	RETVAL

short
nci_spit( c_func, p0, i1, t2 )
	SV* c_func
	void * p0
	int i1
	char * t2
PREINIT:
	short(*func)(void *, int, char *);
CODE:
	func   = INT2PTR(short(*)(void *, int, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, t2);
OUTPUT:
	RETVAL

short
nci_spii( c_func, p0, i1, i2 )
	SV* c_func
	void * p0
	int i1
	int i2
PREINIT:
	short(*func)(void *, int, int);
CODE:
	func   = INT2PTR(short(*)(void *, int, int), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, i2);
OUTPUT:
	RETVAL

short
nci_sdpp( c_func, d0, p1, p2 )
	SV* c_func
	double d0
	void * p1
	void * p2
PREINIT:
	short(*func)(double, void *, void *);
CODE:
	func   = INT2PTR(short(*)(double, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, p2);
OUTPUT:
	RETVAL

short
nci_sdpd( c_func, d0, p1, d2 )
	SV* c_func
	double d0
	void * p1
	double d2
PREINIT:
	short(*func)(double, void *, double);
CODE:
	func   = INT2PTR(short(*)(double, void *, double), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, d2);
OUTPUT:
	RETVAL

short
nci_sdps( c_func, d0, p1, s2 )
	SV* c_func
	double d0
	void * p1
	short s2
PREINIT:
	short(*func)(double, void *, short);
CODE:
	func   = INT2PTR(short(*)(double, void *, short), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, s2);
OUTPUT:
	RETVAL

short
nci_sdpf( c_func, d0, p1, f2 )
	SV* c_func
	double d0
	void * p1
	float f2
PREINIT:
	short(*func)(double, void *, float);
CODE:
	func   = INT2PTR(short(*)(double, void *, float), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, f2);
OUTPUT:
	RETVAL

short
nci_sdpt( c_func, d0, p1, t2 )
	SV* c_func
	double d0
	void * p1
	char * t2
PREINIT:
	short(*func)(double, void *, char *);
CODE:
	func   = INT2PTR(short(*)(double, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, t2);
OUTPUT:
	RETVAL

short
nci_sdpi( c_func, d0, p1, i2 )
	SV* c_func
	double d0
	void * p1
	int i2
PREINIT:
	short(*func)(double, void *, int);
CODE:
	func   = INT2PTR(short(*)(double, void *, int), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, i2);
OUTPUT:
	RETVAL

short
nci_sddp( c_func, d0, d1, p2 )
	SV* c_func
	double d0
	double d1
	void * p2
PREINIT:
	short(*func)(double, double, void *);
CODE:
	func   = INT2PTR(short(*)(double, double, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, p2);
OUTPUT:
	RETVAL

short
nci_sddd( c_func, d0, d1, d2 )
	SV* c_func
	double d0
	double d1
	double d2
PREINIT:
	short(*func)(double, double, double);
CODE:
	func   = INT2PTR(short(*)(double, double, double), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, d2);
OUTPUT:
	RETVAL

short
nci_sdds( c_func, d0, d1, s2 )
	SV* c_func
	double d0
	double d1
	short s2
PREINIT:
	short(*func)(double, double, short);
CODE:
	func   = INT2PTR(short(*)(double, double, short), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, s2);
OUTPUT:
	RETVAL

short
nci_sddf( c_func, d0, d1, f2 )
	SV* c_func
	double d0
	double d1
	float f2
PREINIT:
	short(*func)(double, double, float);
CODE:
	func   = INT2PTR(short(*)(double, double, float), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, f2);
OUTPUT:
	RETVAL

short
nci_sddt( c_func, d0, d1, t2 )
	SV* c_func
	double d0
	double d1
	char * t2
PREINIT:
	short(*func)(double, double, char *);
CODE:
	func   = INT2PTR(short(*)(double, double, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, t2);
OUTPUT:
	RETVAL

short
nci_sddi( c_func, d0, d1, i2 )
	SV* c_func
	double d0
	double d1
	int i2
PREINIT:
	short(*func)(double, double, int);
CODE:
	func   = INT2PTR(short(*)(double, double, int), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, i2);
OUTPUT:
	RETVAL

short
nci_sdsp( c_func, d0, s1, p2 )
	SV* c_func
	double d0
	short s1
	void * p2
PREINIT:
	short(*func)(double, short, void *);
CODE:
	func   = INT2PTR(short(*)(double, short, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, p2);
OUTPUT:
	RETVAL

short
nci_sdsd( c_func, d0, s1, d2 )
	SV* c_func
	double d0
	short s1
	double d2
PREINIT:
	short(*func)(double, short, double);
CODE:
	func   = INT2PTR(short(*)(double, short, double), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, d2);
OUTPUT:
	RETVAL

short
nci_sdss( c_func, d0, s1, s2 )
	SV* c_func
	double d0
	short s1
	short s2
PREINIT:
	short(*func)(double, short, short);
CODE:
	func   = INT2PTR(short(*)(double, short, short), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, s2);
OUTPUT:
	RETVAL

short
nci_sdsf( c_func, d0, s1, f2 )
	SV* c_func
	double d0
	short s1
	float f2
PREINIT:
	short(*func)(double, short, float);
CODE:
	func   = INT2PTR(short(*)(double, short, float), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, f2);
OUTPUT:
	RETVAL

short
nci_sdst( c_func, d0, s1, t2 )
	SV* c_func
	double d0
	short s1
	char * t2
PREINIT:
	short(*func)(double, short, char *);
CODE:
	func   = INT2PTR(short(*)(double, short, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, t2);
OUTPUT:
	RETVAL

short
nci_sdsi( c_func, d0, s1, i2 )
	SV* c_func
	double d0
	short s1
	int i2
PREINIT:
	short(*func)(double, short, int);
CODE:
	func   = INT2PTR(short(*)(double, short, int), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, i2);
OUTPUT:
	RETVAL

short
nci_sdfp( c_func, d0, f1, p2 )
	SV* c_func
	double d0
	float f1
	void * p2
PREINIT:
	short(*func)(double, float, void *);
CODE:
	func   = INT2PTR(short(*)(double, float, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, p2);
OUTPUT:
	RETVAL

short
nci_sdfd( c_func, d0, f1, d2 )
	SV* c_func
	double d0
	float f1
	double d2
PREINIT:
	short(*func)(double, float, double);
CODE:
	func   = INT2PTR(short(*)(double, float, double), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, d2);
OUTPUT:
	RETVAL

short
nci_sdfs( c_func, d0, f1, s2 )
	SV* c_func
	double d0
	float f1
	short s2
PREINIT:
	short(*func)(double, float, short);
CODE:
	func   = INT2PTR(short(*)(double, float, short), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, s2);
OUTPUT:
	RETVAL

short
nci_sdff( c_func, d0, f1, f2 )
	SV* c_func
	double d0
	float f1
	float f2
PREINIT:
	short(*func)(double, float, float);
CODE:
	func   = INT2PTR(short(*)(double, float, float), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, f2);
OUTPUT:
	RETVAL

short
nci_sdft( c_func, d0, f1, t2 )
	SV* c_func
	double d0
	float f1
	char * t2
PREINIT:
	short(*func)(double, float, char *);
CODE:
	func   = INT2PTR(short(*)(double, float, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, t2);
OUTPUT:
	RETVAL

short
nci_sdfi( c_func, d0, f1, i2 )
	SV* c_func
	double d0
	float f1
	int i2
PREINIT:
	short(*func)(double, float, int);
CODE:
	func   = INT2PTR(short(*)(double, float, int), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, i2);
OUTPUT:
	RETVAL

short
nci_sdtp( c_func, d0, t1, p2 )
	SV* c_func
	double d0
	char * t1
	void * p2
PREINIT:
	short(*func)(double, char *, void *);
CODE:
	func   = INT2PTR(short(*)(double, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, p2);
OUTPUT:
	RETVAL

short
nci_sdtd( c_func, d0, t1, d2 )
	SV* c_func
	double d0
	char * t1
	double d2
PREINIT:
	short(*func)(double, char *, double);
CODE:
	func   = INT2PTR(short(*)(double, char *, double), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, d2);
OUTPUT:
	RETVAL

short
nci_sdts( c_func, d0, t1, s2 )
	SV* c_func
	double d0
	char * t1
	short s2
PREINIT:
	short(*func)(double, char *, short);
CODE:
	func   = INT2PTR(short(*)(double, char *, short), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, s2);
OUTPUT:
	RETVAL

short
nci_sdtf( c_func, d0, t1, f2 )
	SV* c_func
	double d0
	char * t1
	float f2
PREINIT:
	short(*func)(double, char *, float);
CODE:
	func   = INT2PTR(short(*)(double, char *, float), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, f2);
OUTPUT:
	RETVAL

short
nci_sdtt( c_func, d0, t1, t2 )
	SV* c_func
	double d0
	char * t1
	char * t2
PREINIT:
	short(*func)(double, char *, char *);
CODE:
	func   = INT2PTR(short(*)(double, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, t2);
OUTPUT:
	RETVAL

short
nci_sdti( c_func, d0, t1, i2 )
	SV* c_func
	double d0
	char * t1
	int i2
PREINIT:
	short(*func)(double, char *, int);
CODE:
	func   = INT2PTR(short(*)(double, char *, int), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, i2);
OUTPUT:
	RETVAL

short
nci_sdip( c_func, d0, i1, p2 )
	SV* c_func
	double d0
	int i1
	void * p2
PREINIT:
	short(*func)(double, int, void *);
CODE:
	func   = INT2PTR(short(*)(double, int, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, p2);
OUTPUT:
	RETVAL

short
nci_sdid( c_func, d0, i1, d2 )
	SV* c_func
	double d0
	int i1
	double d2
PREINIT:
	short(*func)(double, int, double);
CODE:
	func   = INT2PTR(short(*)(double, int, double), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, d2);
OUTPUT:
	RETVAL

short
nci_sdis( c_func, d0, i1, s2 )
	SV* c_func
	double d0
	int i1
	short s2
PREINIT:
	short(*func)(double, int, short);
CODE:
	func   = INT2PTR(short(*)(double, int, short), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, s2);
OUTPUT:
	RETVAL

short
nci_sdif( c_func, d0, i1, f2 )
	SV* c_func
	double d0
	int i1
	float f2
PREINIT:
	short(*func)(double, int, float);
CODE:
	func   = INT2PTR(short(*)(double, int, float), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, f2);
OUTPUT:
	RETVAL

short
nci_sdit( c_func, d0, i1, t2 )
	SV* c_func
	double d0
	int i1
	char * t2
PREINIT:
	short(*func)(double, int, char *);
CODE:
	func   = INT2PTR(short(*)(double, int, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, t2);
OUTPUT:
	RETVAL

short
nci_sdii( c_func, d0, i1, i2 )
	SV* c_func
	double d0
	int i1
	int i2
PREINIT:
	short(*func)(double, int, int);
CODE:
	func   = INT2PTR(short(*)(double, int, int), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, i2);
OUTPUT:
	RETVAL

short
nci_sspp( c_func, s0, p1, p2 )
	SV* c_func
	short s0
	void * p1
	void * p2
PREINIT:
	short(*func)(short, void *, void *);
CODE:
	func   = INT2PTR(short(*)(short, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, p2);
OUTPUT:
	RETVAL

short
nci_sspd( c_func, s0, p1, d2 )
	SV* c_func
	short s0
	void * p1
	double d2
PREINIT:
	short(*func)(short, void *, double);
CODE:
	func   = INT2PTR(short(*)(short, void *, double), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, d2);
OUTPUT:
	RETVAL

short
nci_ssps( c_func, s0, p1, s2 )
	SV* c_func
	short s0
	void * p1
	short s2
PREINIT:
	short(*func)(short, void *, short);
CODE:
	func   = INT2PTR(short(*)(short, void *, short), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, s2);
OUTPUT:
	RETVAL

short
nci_sspf( c_func, s0, p1, f2 )
	SV* c_func
	short s0
	void * p1
	float f2
PREINIT:
	short(*func)(short, void *, float);
CODE:
	func   = INT2PTR(short(*)(short, void *, float), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, f2);
OUTPUT:
	RETVAL

short
nci_sspt( c_func, s0, p1, t2 )
	SV* c_func
	short s0
	void * p1
	char * t2
PREINIT:
	short(*func)(short, void *, char *);
CODE:
	func   = INT2PTR(short(*)(short, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, t2);
OUTPUT:
	RETVAL

short
nci_sspi( c_func, s0, p1, i2 )
	SV* c_func
	short s0
	void * p1
	int i2
PREINIT:
	short(*func)(short, void *, int);
CODE:
	func   = INT2PTR(short(*)(short, void *, int), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, i2);
OUTPUT:
	RETVAL

short
nci_ssdp( c_func, s0, d1, p2 )
	SV* c_func
	short s0
	double d1
	void * p2
PREINIT:
	short(*func)(short, double, void *);
CODE:
	func   = INT2PTR(short(*)(short, double, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, p2);
OUTPUT:
	RETVAL

short
nci_ssdd( c_func, s0, d1, d2 )
	SV* c_func
	short s0
	double d1
	double d2
PREINIT:
	short(*func)(short, double, double);
CODE:
	func   = INT2PTR(short(*)(short, double, double), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, d2);
OUTPUT:
	RETVAL

short
nci_ssds( c_func, s0, d1, s2 )
	SV* c_func
	short s0
	double d1
	short s2
PREINIT:
	short(*func)(short, double, short);
CODE:
	func   = INT2PTR(short(*)(short, double, short), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, s2);
OUTPUT:
	RETVAL

short
nci_ssdf( c_func, s0, d1, f2 )
	SV* c_func
	short s0
	double d1
	float f2
PREINIT:
	short(*func)(short, double, float);
CODE:
	func   = INT2PTR(short(*)(short, double, float), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, f2);
OUTPUT:
	RETVAL

short
nci_ssdt( c_func, s0, d1, t2 )
	SV* c_func
	short s0
	double d1
	char * t2
PREINIT:
	short(*func)(short, double, char *);
CODE:
	func   = INT2PTR(short(*)(short, double, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, t2);
OUTPUT:
	RETVAL

short
nci_ssdi( c_func, s0, d1, i2 )
	SV* c_func
	short s0
	double d1
	int i2
PREINIT:
	short(*func)(short, double, int);
CODE:
	func   = INT2PTR(short(*)(short, double, int), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, i2);
OUTPUT:
	RETVAL

short
nci_sssp( c_func, s0, s1, p2 )
	SV* c_func
	short s0
	short s1
	void * p2
PREINIT:
	short(*func)(short, short, void *);
CODE:
	func   = INT2PTR(short(*)(short, short, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, p2);
OUTPUT:
	RETVAL

short
nci_sssd( c_func, s0, s1, d2 )
	SV* c_func
	short s0
	short s1
	double d2
PREINIT:
	short(*func)(short, short, double);
CODE:
	func   = INT2PTR(short(*)(short, short, double), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, d2);
OUTPUT:
	RETVAL

short
nci_ssss( c_func, s0, s1, s2 )
	SV* c_func
	short s0
	short s1
	short s2
PREINIT:
	short(*func)(short, short, short);
CODE:
	func   = INT2PTR(short(*)(short, short, short), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, s2);
OUTPUT:
	RETVAL

short
nci_sssf( c_func, s0, s1, f2 )
	SV* c_func
	short s0
	short s1
	float f2
PREINIT:
	short(*func)(short, short, float);
CODE:
	func   = INT2PTR(short(*)(short, short, float), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, f2);
OUTPUT:
	RETVAL

short
nci_ssst( c_func, s0, s1, t2 )
	SV* c_func
	short s0
	short s1
	char * t2
PREINIT:
	short(*func)(short, short, char *);
CODE:
	func   = INT2PTR(short(*)(short, short, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, t2);
OUTPUT:
	RETVAL

short
nci_sssi( c_func, s0, s1, i2 )
	SV* c_func
	short s0
	short s1
	int i2
PREINIT:
	short(*func)(short, short, int);
CODE:
	func   = INT2PTR(short(*)(short, short, int), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, i2);
OUTPUT:
	RETVAL

short
nci_ssfp( c_func, s0, f1, p2 )
	SV* c_func
	short s0
	float f1
	void * p2
PREINIT:
	short(*func)(short, float, void *);
CODE:
	func   = INT2PTR(short(*)(short, float, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, p2);
OUTPUT:
	RETVAL

short
nci_ssfd( c_func, s0, f1, d2 )
	SV* c_func
	short s0
	float f1
	double d2
PREINIT:
	short(*func)(short, float, double);
CODE:
	func   = INT2PTR(short(*)(short, float, double), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, d2);
OUTPUT:
	RETVAL

short
nci_ssfs( c_func, s0, f1, s2 )
	SV* c_func
	short s0
	float f1
	short s2
PREINIT:
	short(*func)(short, float, short);
CODE:
	func   = INT2PTR(short(*)(short, float, short), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, s2);
OUTPUT:
	RETVAL

short
nci_ssff( c_func, s0, f1, f2 )
	SV* c_func
	short s0
	float f1
	float f2
PREINIT:
	short(*func)(short, float, float);
CODE:
	func   = INT2PTR(short(*)(short, float, float), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, f2);
OUTPUT:
	RETVAL

short
nci_ssft( c_func, s0, f1, t2 )
	SV* c_func
	short s0
	float f1
	char * t2
PREINIT:
	short(*func)(short, float, char *);
CODE:
	func   = INT2PTR(short(*)(short, float, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, t2);
OUTPUT:
	RETVAL

short
nci_ssfi( c_func, s0, f1, i2 )
	SV* c_func
	short s0
	float f1
	int i2
PREINIT:
	short(*func)(short, float, int);
CODE:
	func   = INT2PTR(short(*)(short, float, int), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, i2);
OUTPUT:
	RETVAL

short
nci_sstp( c_func, s0, t1, p2 )
	SV* c_func
	short s0
	char * t1
	void * p2
PREINIT:
	short(*func)(short, char *, void *);
CODE:
	func   = INT2PTR(short(*)(short, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, p2);
OUTPUT:
	RETVAL

short
nci_sstd( c_func, s0, t1, d2 )
	SV* c_func
	short s0
	char * t1
	double d2
PREINIT:
	short(*func)(short, char *, double);
CODE:
	func   = INT2PTR(short(*)(short, char *, double), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, d2);
OUTPUT:
	RETVAL

short
nci_ssts( c_func, s0, t1, s2 )
	SV* c_func
	short s0
	char * t1
	short s2
PREINIT:
	short(*func)(short, char *, short);
CODE:
	func   = INT2PTR(short(*)(short, char *, short), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, s2);
OUTPUT:
	RETVAL

short
nci_sstf( c_func, s0, t1, f2 )
	SV* c_func
	short s0
	char * t1
	float f2
PREINIT:
	short(*func)(short, char *, float);
CODE:
	func   = INT2PTR(short(*)(short, char *, float), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, f2);
OUTPUT:
	RETVAL

short
nci_sstt( c_func, s0, t1, t2 )
	SV* c_func
	short s0
	char * t1
	char * t2
PREINIT:
	short(*func)(short, char *, char *);
CODE:
	func   = INT2PTR(short(*)(short, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, t2);
OUTPUT:
	RETVAL

short
nci_ssti( c_func, s0, t1, i2 )
	SV* c_func
	short s0
	char * t1
	int i2
PREINIT:
	short(*func)(short, char *, int);
CODE:
	func   = INT2PTR(short(*)(short, char *, int), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, i2);
OUTPUT:
	RETVAL

short
nci_ssip( c_func, s0, i1, p2 )
	SV* c_func
	short s0
	int i1
	void * p2
PREINIT:
	short(*func)(short, int, void *);
CODE:
	func   = INT2PTR(short(*)(short, int, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, p2);
OUTPUT:
	RETVAL

short
nci_ssid( c_func, s0, i1, d2 )
	SV* c_func
	short s0
	int i1
	double d2
PREINIT:
	short(*func)(short, int, double);
CODE:
	func   = INT2PTR(short(*)(short, int, double), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, d2);
OUTPUT:
	RETVAL

short
nci_ssis( c_func, s0, i1, s2 )
	SV* c_func
	short s0
	int i1
	short s2
PREINIT:
	short(*func)(short, int, short);
CODE:
	func   = INT2PTR(short(*)(short, int, short), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, s2);
OUTPUT:
	RETVAL

short
nci_ssif( c_func, s0, i1, f2 )
	SV* c_func
	short s0
	int i1
	float f2
PREINIT:
	short(*func)(short, int, float);
CODE:
	func   = INT2PTR(short(*)(short, int, float), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, f2);
OUTPUT:
	RETVAL

short
nci_ssit( c_func, s0, i1, t2 )
	SV* c_func
	short s0
	int i1
	char * t2
PREINIT:
	short(*func)(short, int, char *);
CODE:
	func   = INT2PTR(short(*)(short, int, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, t2);
OUTPUT:
	RETVAL

short
nci_ssii( c_func, s0, i1, i2 )
	SV* c_func
	short s0
	int i1
	int i2
PREINIT:
	short(*func)(short, int, int);
CODE:
	func   = INT2PTR(short(*)(short, int, int), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, i2);
OUTPUT:
	RETVAL

short
nci_sfpp( c_func, f0, p1, p2 )
	SV* c_func
	float f0
	void * p1
	void * p2
PREINIT:
	short(*func)(float, void *, void *);
CODE:
	func   = INT2PTR(short(*)(float, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, p2);
OUTPUT:
	RETVAL

short
nci_sfpd( c_func, f0, p1, d2 )
	SV* c_func
	float f0
	void * p1
	double d2
PREINIT:
	short(*func)(float, void *, double);
CODE:
	func   = INT2PTR(short(*)(float, void *, double), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, d2);
OUTPUT:
	RETVAL

short
nci_sfps( c_func, f0, p1, s2 )
	SV* c_func
	float f0
	void * p1
	short s2
PREINIT:
	short(*func)(float, void *, short);
CODE:
	func   = INT2PTR(short(*)(float, void *, short), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, s2);
OUTPUT:
	RETVAL

short
nci_sfpf( c_func, f0, p1, f2 )
	SV* c_func
	float f0
	void * p1
	float f2
PREINIT:
	short(*func)(float, void *, float);
CODE:
	func   = INT2PTR(short(*)(float, void *, float), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, f2);
OUTPUT:
	RETVAL

short
nci_sfpt( c_func, f0, p1, t2 )
	SV* c_func
	float f0
	void * p1
	char * t2
PREINIT:
	short(*func)(float, void *, char *);
CODE:
	func   = INT2PTR(short(*)(float, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, t2);
OUTPUT:
	RETVAL

short
nci_sfpi( c_func, f0, p1, i2 )
	SV* c_func
	float f0
	void * p1
	int i2
PREINIT:
	short(*func)(float, void *, int);
CODE:
	func   = INT2PTR(short(*)(float, void *, int), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, i2);
OUTPUT:
	RETVAL

short
nci_sfdp( c_func, f0, d1, p2 )
	SV* c_func
	float f0
	double d1
	void * p2
PREINIT:
	short(*func)(float, double, void *);
CODE:
	func   = INT2PTR(short(*)(float, double, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, p2);
OUTPUT:
	RETVAL

short
nci_sfdd( c_func, f0, d1, d2 )
	SV* c_func
	float f0
	double d1
	double d2
PREINIT:
	short(*func)(float, double, double);
CODE:
	func   = INT2PTR(short(*)(float, double, double), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, d2);
OUTPUT:
	RETVAL

short
nci_sfds( c_func, f0, d1, s2 )
	SV* c_func
	float f0
	double d1
	short s2
PREINIT:
	short(*func)(float, double, short);
CODE:
	func   = INT2PTR(short(*)(float, double, short), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, s2);
OUTPUT:
	RETVAL

short
nci_sfdf( c_func, f0, d1, f2 )
	SV* c_func
	float f0
	double d1
	float f2
PREINIT:
	short(*func)(float, double, float);
CODE:
	func   = INT2PTR(short(*)(float, double, float), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, f2);
OUTPUT:
	RETVAL

short
nci_sfdt( c_func, f0, d1, t2 )
	SV* c_func
	float f0
	double d1
	char * t2
PREINIT:
	short(*func)(float, double, char *);
CODE:
	func   = INT2PTR(short(*)(float, double, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, t2);
OUTPUT:
	RETVAL

short
nci_sfdi( c_func, f0, d1, i2 )
	SV* c_func
	float f0
	double d1
	int i2
PREINIT:
	short(*func)(float, double, int);
CODE:
	func   = INT2PTR(short(*)(float, double, int), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, i2);
OUTPUT:
	RETVAL

short
nci_sfsp( c_func, f0, s1, p2 )
	SV* c_func
	float f0
	short s1
	void * p2
PREINIT:
	short(*func)(float, short, void *);
CODE:
	func   = INT2PTR(short(*)(float, short, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, p2);
OUTPUT:
	RETVAL

short
nci_sfsd( c_func, f0, s1, d2 )
	SV* c_func
	float f0
	short s1
	double d2
PREINIT:
	short(*func)(float, short, double);
CODE:
	func   = INT2PTR(short(*)(float, short, double), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, d2);
OUTPUT:
	RETVAL

short
nci_sfss( c_func, f0, s1, s2 )
	SV* c_func
	float f0
	short s1
	short s2
PREINIT:
	short(*func)(float, short, short);
CODE:
	func   = INT2PTR(short(*)(float, short, short), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, s2);
OUTPUT:
	RETVAL

short
nci_sfsf( c_func, f0, s1, f2 )
	SV* c_func
	float f0
	short s1
	float f2
PREINIT:
	short(*func)(float, short, float);
CODE:
	func   = INT2PTR(short(*)(float, short, float), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, f2);
OUTPUT:
	RETVAL

short
nci_sfst( c_func, f0, s1, t2 )
	SV* c_func
	float f0
	short s1
	char * t2
PREINIT:
	short(*func)(float, short, char *);
CODE:
	func   = INT2PTR(short(*)(float, short, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, t2);
OUTPUT:
	RETVAL

short
nci_sfsi( c_func, f0, s1, i2 )
	SV* c_func
	float f0
	short s1
	int i2
PREINIT:
	short(*func)(float, short, int);
CODE:
	func   = INT2PTR(short(*)(float, short, int), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, i2);
OUTPUT:
	RETVAL

short
nci_sffp( c_func, f0, f1, p2 )
	SV* c_func
	float f0
	float f1
	void * p2
PREINIT:
	short(*func)(float, float, void *);
CODE:
	func   = INT2PTR(short(*)(float, float, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, p2);
OUTPUT:
	RETVAL

short
nci_sffd( c_func, f0, f1, d2 )
	SV* c_func
	float f0
	float f1
	double d2
PREINIT:
	short(*func)(float, float, double);
CODE:
	func   = INT2PTR(short(*)(float, float, double), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, d2);
OUTPUT:
	RETVAL

short
nci_sffs( c_func, f0, f1, s2 )
	SV* c_func
	float f0
	float f1
	short s2
PREINIT:
	short(*func)(float, float, short);
CODE:
	func   = INT2PTR(short(*)(float, float, short), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, s2);
OUTPUT:
	RETVAL

short
nci_sfff( c_func, f0, f1, f2 )
	SV* c_func
	float f0
	float f1
	float f2
PREINIT:
	short(*func)(float, float, float);
CODE:
	func   = INT2PTR(short(*)(float, float, float), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, f2);
OUTPUT:
	RETVAL

short
nci_sfft( c_func, f0, f1, t2 )
	SV* c_func
	float f0
	float f1
	char * t2
PREINIT:
	short(*func)(float, float, char *);
CODE:
	func   = INT2PTR(short(*)(float, float, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, t2);
OUTPUT:
	RETVAL

short
nci_sffi( c_func, f0, f1, i2 )
	SV* c_func
	float f0
	float f1
	int i2
PREINIT:
	short(*func)(float, float, int);
CODE:
	func   = INT2PTR(short(*)(float, float, int), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, i2);
OUTPUT:
	RETVAL

short
nci_sftp( c_func, f0, t1, p2 )
	SV* c_func
	float f0
	char * t1
	void * p2
PREINIT:
	short(*func)(float, char *, void *);
CODE:
	func   = INT2PTR(short(*)(float, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, p2);
OUTPUT:
	RETVAL

short
nci_sftd( c_func, f0, t1, d2 )
	SV* c_func
	float f0
	char * t1
	double d2
PREINIT:
	short(*func)(float, char *, double);
CODE:
	func   = INT2PTR(short(*)(float, char *, double), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, d2);
OUTPUT:
	RETVAL

short
nci_sfts( c_func, f0, t1, s2 )
	SV* c_func
	float f0
	char * t1
	short s2
PREINIT:
	short(*func)(float, char *, short);
CODE:
	func   = INT2PTR(short(*)(float, char *, short), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, s2);
OUTPUT:
	RETVAL

short
nci_sftf( c_func, f0, t1, f2 )
	SV* c_func
	float f0
	char * t1
	float f2
PREINIT:
	short(*func)(float, char *, float);
CODE:
	func   = INT2PTR(short(*)(float, char *, float), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, f2);
OUTPUT:
	RETVAL

short
nci_sftt( c_func, f0, t1, t2 )
	SV* c_func
	float f0
	char * t1
	char * t2
PREINIT:
	short(*func)(float, char *, char *);
CODE:
	func   = INT2PTR(short(*)(float, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, t2);
OUTPUT:
	RETVAL

short
nci_sfti( c_func, f0, t1, i2 )
	SV* c_func
	float f0
	char * t1
	int i2
PREINIT:
	short(*func)(float, char *, int);
CODE:
	func   = INT2PTR(short(*)(float, char *, int), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, i2);
OUTPUT:
	RETVAL

short
nci_sfip( c_func, f0, i1, p2 )
	SV* c_func
	float f0
	int i1
	void * p2
PREINIT:
	short(*func)(float, int, void *);
CODE:
	func   = INT2PTR(short(*)(float, int, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, p2);
OUTPUT:
	RETVAL

short
nci_sfid( c_func, f0, i1, d2 )
	SV* c_func
	float f0
	int i1
	double d2
PREINIT:
	short(*func)(float, int, double);
CODE:
	func   = INT2PTR(short(*)(float, int, double), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, d2);
OUTPUT:
	RETVAL

short
nci_sfis( c_func, f0, i1, s2 )
	SV* c_func
	float f0
	int i1
	short s2
PREINIT:
	short(*func)(float, int, short);
CODE:
	func   = INT2PTR(short(*)(float, int, short), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, s2);
OUTPUT:
	RETVAL

short
nci_sfif( c_func, f0, i1, f2 )
	SV* c_func
	float f0
	int i1
	float f2
PREINIT:
	short(*func)(float, int, float);
CODE:
	func   = INT2PTR(short(*)(float, int, float), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, f2);
OUTPUT:
	RETVAL

short
nci_sfit( c_func, f0, i1, t2 )
	SV* c_func
	float f0
	int i1
	char * t2
PREINIT:
	short(*func)(float, int, char *);
CODE:
	func   = INT2PTR(short(*)(float, int, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, t2);
OUTPUT:
	RETVAL

short
nci_sfii( c_func, f0, i1, i2 )
	SV* c_func
	float f0
	int i1
	int i2
PREINIT:
	short(*func)(float, int, int);
CODE:
	func   = INT2PTR(short(*)(float, int, int), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, i2);
OUTPUT:
	RETVAL

short
nci_stpp( c_func, t0, p1, p2 )
	SV* c_func
	char * t0
	void * p1
	void * p2
PREINIT:
	short(*func)(char *, void *, void *);
CODE:
	func   = INT2PTR(short(*)(char *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, p2);
OUTPUT:
	RETVAL

short
nci_stpd( c_func, t0, p1, d2 )
	SV* c_func
	char * t0
	void * p1
	double d2
PREINIT:
	short(*func)(char *, void *, double);
CODE:
	func   = INT2PTR(short(*)(char *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, d2);
OUTPUT:
	RETVAL

short
nci_stps( c_func, t0, p1, s2 )
	SV* c_func
	char * t0
	void * p1
	short s2
PREINIT:
	short(*func)(char *, void *, short);
CODE:
	func   = INT2PTR(short(*)(char *, void *, short), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, s2);
OUTPUT:
	RETVAL

short
nci_stpf( c_func, t0, p1, f2 )
	SV* c_func
	char * t0
	void * p1
	float f2
PREINIT:
	short(*func)(char *, void *, float);
CODE:
	func   = INT2PTR(short(*)(char *, void *, float), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, f2);
OUTPUT:
	RETVAL

short
nci_stpt( c_func, t0, p1, t2 )
	SV* c_func
	char * t0
	void * p1
	char * t2
PREINIT:
	short(*func)(char *, void *, char *);
CODE:
	func   = INT2PTR(short(*)(char *, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, t2);
OUTPUT:
	RETVAL

short
nci_stpi( c_func, t0, p1, i2 )
	SV* c_func
	char * t0
	void * p1
	int i2
PREINIT:
	short(*func)(char *, void *, int);
CODE:
	func   = INT2PTR(short(*)(char *, void *, int), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, i2);
OUTPUT:
	RETVAL

short
nci_stdp( c_func, t0, d1, p2 )
	SV* c_func
	char * t0
	double d1
	void * p2
PREINIT:
	short(*func)(char *, double, void *);
CODE:
	func   = INT2PTR(short(*)(char *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, p2);
OUTPUT:
	RETVAL

short
nci_stdd( c_func, t0, d1, d2 )
	SV* c_func
	char * t0
	double d1
	double d2
PREINIT:
	short(*func)(char *, double, double);
CODE:
	func   = INT2PTR(short(*)(char *, double, double), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, d2);
OUTPUT:
	RETVAL

short
nci_stds( c_func, t0, d1, s2 )
	SV* c_func
	char * t0
	double d1
	short s2
PREINIT:
	short(*func)(char *, double, short);
CODE:
	func   = INT2PTR(short(*)(char *, double, short), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, s2);
OUTPUT:
	RETVAL

short
nci_stdf( c_func, t0, d1, f2 )
	SV* c_func
	char * t0
	double d1
	float f2
PREINIT:
	short(*func)(char *, double, float);
CODE:
	func   = INT2PTR(short(*)(char *, double, float), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, f2);
OUTPUT:
	RETVAL

short
nci_stdt( c_func, t0, d1, t2 )
	SV* c_func
	char * t0
	double d1
	char * t2
PREINIT:
	short(*func)(char *, double, char *);
CODE:
	func   = INT2PTR(short(*)(char *, double, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, t2);
OUTPUT:
	RETVAL

short
nci_stdi( c_func, t0, d1, i2 )
	SV* c_func
	char * t0
	double d1
	int i2
PREINIT:
	short(*func)(char *, double, int);
CODE:
	func   = INT2PTR(short(*)(char *, double, int), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, i2);
OUTPUT:
	RETVAL

short
nci_stsp( c_func, t0, s1, p2 )
	SV* c_func
	char * t0
	short s1
	void * p2
PREINIT:
	short(*func)(char *, short, void *);
CODE:
	func   = INT2PTR(short(*)(char *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, p2);
OUTPUT:
	RETVAL

short
nci_stsd( c_func, t0, s1, d2 )
	SV* c_func
	char * t0
	short s1
	double d2
PREINIT:
	short(*func)(char *, short, double);
CODE:
	func   = INT2PTR(short(*)(char *, short, double), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, d2);
OUTPUT:
	RETVAL

short
nci_stss( c_func, t0, s1, s2 )
	SV* c_func
	char * t0
	short s1
	short s2
PREINIT:
	short(*func)(char *, short, short);
CODE:
	func   = INT2PTR(short(*)(char *, short, short), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, s2);
OUTPUT:
	RETVAL

short
nci_stsf( c_func, t0, s1, f2 )
	SV* c_func
	char * t0
	short s1
	float f2
PREINIT:
	short(*func)(char *, short, float);
CODE:
	func   = INT2PTR(short(*)(char *, short, float), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, f2);
OUTPUT:
	RETVAL

short
nci_stst( c_func, t0, s1, t2 )
	SV* c_func
	char * t0
	short s1
	char * t2
PREINIT:
	short(*func)(char *, short, char *);
CODE:
	func   = INT2PTR(short(*)(char *, short, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, t2);
OUTPUT:
	RETVAL

short
nci_stsi( c_func, t0, s1, i2 )
	SV* c_func
	char * t0
	short s1
	int i2
PREINIT:
	short(*func)(char *, short, int);
CODE:
	func   = INT2PTR(short(*)(char *, short, int), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, i2);
OUTPUT:
	RETVAL

short
nci_stfp( c_func, t0, f1, p2 )
	SV* c_func
	char * t0
	float f1
	void * p2
PREINIT:
	short(*func)(char *, float, void *);
CODE:
	func   = INT2PTR(short(*)(char *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, p2);
OUTPUT:
	RETVAL

short
nci_stfd( c_func, t0, f1, d2 )
	SV* c_func
	char * t0
	float f1
	double d2
PREINIT:
	short(*func)(char *, float, double);
CODE:
	func   = INT2PTR(short(*)(char *, float, double), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, d2);
OUTPUT:
	RETVAL

short
nci_stfs( c_func, t0, f1, s2 )
	SV* c_func
	char * t0
	float f1
	short s2
PREINIT:
	short(*func)(char *, float, short);
CODE:
	func   = INT2PTR(short(*)(char *, float, short), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, s2);
OUTPUT:
	RETVAL

short
nci_stff( c_func, t0, f1, f2 )
	SV* c_func
	char * t0
	float f1
	float f2
PREINIT:
	short(*func)(char *, float, float);
CODE:
	func   = INT2PTR(short(*)(char *, float, float), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, f2);
OUTPUT:
	RETVAL

short
nci_stft( c_func, t0, f1, t2 )
	SV* c_func
	char * t0
	float f1
	char * t2
PREINIT:
	short(*func)(char *, float, char *);
CODE:
	func   = INT2PTR(short(*)(char *, float, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, t2);
OUTPUT:
	RETVAL

short
nci_stfi( c_func, t0, f1, i2 )
	SV* c_func
	char * t0
	float f1
	int i2
PREINIT:
	short(*func)(char *, float, int);
CODE:
	func   = INT2PTR(short(*)(char *, float, int), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, i2);
OUTPUT:
	RETVAL

short
nci_sttp( c_func, t0, t1, p2 )
	SV* c_func
	char * t0
	char * t1
	void * p2
PREINIT:
	short(*func)(char *, char *, void *);
CODE:
	func   = INT2PTR(short(*)(char *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, p2);
OUTPUT:
	RETVAL

short
nci_sttd( c_func, t0, t1, d2 )
	SV* c_func
	char * t0
	char * t1
	double d2
PREINIT:
	short(*func)(char *, char *, double);
CODE:
	func   = INT2PTR(short(*)(char *, char *, double), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, d2);
OUTPUT:
	RETVAL

short
nci_stts( c_func, t0, t1, s2 )
	SV* c_func
	char * t0
	char * t1
	short s2
PREINIT:
	short(*func)(char *, char *, short);
CODE:
	func   = INT2PTR(short(*)(char *, char *, short), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, s2);
OUTPUT:
	RETVAL

short
nci_sttf( c_func, t0, t1, f2 )
	SV* c_func
	char * t0
	char * t1
	float f2
PREINIT:
	short(*func)(char *, char *, float);
CODE:
	func   = INT2PTR(short(*)(char *, char *, float), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, f2);
OUTPUT:
	RETVAL

short
nci_sttt( c_func, t0, t1, t2 )
	SV* c_func
	char * t0
	char * t1
	char * t2
PREINIT:
	short(*func)(char *, char *, char *);
CODE:
	func   = INT2PTR(short(*)(char *, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, t2);
OUTPUT:
	RETVAL

short
nci_stti( c_func, t0, t1, i2 )
	SV* c_func
	char * t0
	char * t1
	int i2
PREINIT:
	short(*func)(char *, char *, int);
CODE:
	func   = INT2PTR(short(*)(char *, char *, int), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, i2);
OUTPUT:
	RETVAL

short
nci_stip( c_func, t0, i1, p2 )
	SV* c_func
	char * t0
	int i1
	void * p2
PREINIT:
	short(*func)(char *, int, void *);
CODE:
	func   = INT2PTR(short(*)(char *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, p2);
OUTPUT:
	RETVAL

short
nci_stid( c_func, t0, i1, d2 )
	SV* c_func
	char * t0
	int i1
	double d2
PREINIT:
	short(*func)(char *, int, double);
CODE:
	func   = INT2PTR(short(*)(char *, int, double), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, d2);
OUTPUT:
	RETVAL

short
nci_stis( c_func, t0, i1, s2 )
	SV* c_func
	char * t0
	int i1
	short s2
PREINIT:
	short(*func)(char *, int, short);
CODE:
	func   = INT2PTR(short(*)(char *, int, short), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, s2);
OUTPUT:
	RETVAL

short
nci_stif( c_func, t0, i1, f2 )
	SV* c_func
	char * t0
	int i1
	float f2
PREINIT:
	short(*func)(char *, int, float);
CODE:
	func   = INT2PTR(short(*)(char *, int, float), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, f2);
OUTPUT:
	RETVAL

short
nci_stit( c_func, t0, i1, t2 )
	SV* c_func
	char * t0
	int i1
	char * t2
PREINIT:
	short(*func)(char *, int, char *);
CODE:
	func   = INT2PTR(short(*)(char *, int, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, t2);
OUTPUT:
	RETVAL

short
nci_stii( c_func, t0, i1, i2 )
	SV* c_func
	char * t0
	int i1
	int i2
PREINIT:
	short(*func)(char *, int, int);
CODE:
	func   = INT2PTR(short(*)(char *, int, int), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, i2);
OUTPUT:
	RETVAL

short
nci_sipp( c_func, i0, p1, p2 )
	SV* c_func
	int i0
	void * p1
	void * p2
PREINIT:
	short(*func)(int, void *, void *);
CODE:
	func   = INT2PTR(short(*)(int, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, p2);
OUTPUT:
	RETVAL

short
nci_sipd( c_func, i0, p1, d2 )
	SV* c_func
	int i0
	void * p1
	double d2
PREINIT:
	short(*func)(int, void *, double);
CODE:
	func   = INT2PTR(short(*)(int, void *, double), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, d2);
OUTPUT:
	RETVAL

short
nci_sips( c_func, i0, p1, s2 )
	SV* c_func
	int i0
	void * p1
	short s2
PREINIT:
	short(*func)(int, void *, short);
CODE:
	func   = INT2PTR(short(*)(int, void *, short), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, s2);
OUTPUT:
	RETVAL

short
nci_sipf( c_func, i0, p1, f2 )
	SV* c_func
	int i0
	void * p1
	float f2
PREINIT:
	short(*func)(int, void *, float);
CODE:
	func   = INT2PTR(short(*)(int, void *, float), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, f2);
OUTPUT:
	RETVAL

short
nci_sipt( c_func, i0, p1, t2 )
	SV* c_func
	int i0
	void * p1
	char * t2
PREINIT:
	short(*func)(int, void *, char *);
CODE:
	func   = INT2PTR(short(*)(int, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, t2);
OUTPUT:
	RETVAL

short
nci_sipi( c_func, i0, p1, i2 )
	SV* c_func
	int i0
	void * p1
	int i2
PREINIT:
	short(*func)(int, void *, int);
CODE:
	func   = INT2PTR(short(*)(int, void *, int), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, i2);
OUTPUT:
	RETVAL

short
nci_sidp( c_func, i0, d1, p2 )
	SV* c_func
	int i0
	double d1
	void * p2
PREINIT:
	short(*func)(int, double, void *);
CODE:
	func   = INT2PTR(short(*)(int, double, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, p2);
OUTPUT:
	RETVAL

short
nci_sidd( c_func, i0, d1, d2 )
	SV* c_func
	int i0
	double d1
	double d2
PREINIT:
	short(*func)(int, double, double);
CODE:
	func   = INT2PTR(short(*)(int, double, double), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, d2);
OUTPUT:
	RETVAL

short
nci_sids( c_func, i0, d1, s2 )
	SV* c_func
	int i0
	double d1
	short s2
PREINIT:
	short(*func)(int, double, short);
CODE:
	func   = INT2PTR(short(*)(int, double, short), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, s2);
OUTPUT:
	RETVAL

short
nci_sidf( c_func, i0, d1, f2 )
	SV* c_func
	int i0
	double d1
	float f2
PREINIT:
	short(*func)(int, double, float);
CODE:
	func   = INT2PTR(short(*)(int, double, float), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, f2);
OUTPUT:
	RETVAL

short
nci_sidt( c_func, i0, d1, t2 )
	SV* c_func
	int i0
	double d1
	char * t2
PREINIT:
	short(*func)(int, double, char *);
CODE:
	func   = INT2PTR(short(*)(int, double, char *), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, t2);
OUTPUT:
	RETVAL

short
nci_sidi( c_func, i0, d1, i2 )
	SV* c_func
	int i0
	double d1
	int i2
PREINIT:
	short(*func)(int, double, int);
CODE:
	func   = INT2PTR(short(*)(int, double, int), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, i2);
OUTPUT:
	RETVAL

short
nci_sisp( c_func, i0, s1, p2 )
	SV* c_func
	int i0
	short s1
	void * p2
PREINIT:
	short(*func)(int, short, void *);
CODE:
	func   = INT2PTR(short(*)(int, short, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, p2);
OUTPUT:
	RETVAL

short
nci_sisd( c_func, i0, s1, d2 )
	SV* c_func
	int i0
	short s1
	double d2
PREINIT:
	short(*func)(int, short, double);
CODE:
	func   = INT2PTR(short(*)(int, short, double), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, d2);
OUTPUT:
	RETVAL

short
nci_siss( c_func, i0, s1, s2 )
	SV* c_func
	int i0
	short s1
	short s2
PREINIT:
	short(*func)(int, short, short);
CODE:
	func   = INT2PTR(short(*)(int, short, short), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, s2);
OUTPUT:
	RETVAL

short
nci_sisf( c_func, i0, s1, f2 )
	SV* c_func
	int i0
	short s1
	float f2
PREINIT:
	short(*func)(int, short, float);
CODE:
	func   = INT2PTR(short(*)(int, short, float), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, f2);
OUTPUT:
	RETVAL

short
nci_sist( c_func, i0, s1, t2 )
	SV* c_func
	int i0
	short s1
	char * t2
PREINIT:
	short(*func)(int, short, char *);
CODE:
	func   = INT2PTR(short(*)(int, short, char *), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, t2);
OUTPUT:
	RETVAL

short
nci_sisi( c_func, i0, s1, i2 )
	SV* c_func
	int i0
	short s1
	int i2
PREINIT:
	short(*func)(int, short, int);
CODE:
	func   = INT2PTR(short(*)(int, short, int), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, i2);
OUTPUT:
	RETVAL

short
nci_sifp( c_func, i0, f1, p2 )
	SV* c_func
	int i0
	float f1
	void * p2
PREINIT:
	short(*func)(int, float, void *);
CODE:
	func   = INT2PTR(short(*)(int, float, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, p2);
OUTPUT:
	RETVAL

short
nci_sifd( c_func, i0, f1, d2 )
	SV* c_func
	int i0
	float f1
	double d2
PREINIT:
	short(*func)(int, float, double);
CODE:
	func   = INT2PTR(short(*)(int, float, double), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, d2);
OUTPUT:
	RETVAL

short
nci_sifs( c_func, i0, f1, s2 )
	SV* c_func
	int i0
	float f1
	short s2
PREINIT:
	short(*func)(int, float, short);
CODE:
	func   = INT2PTR(short(*)(int, float, short), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, s2);
OUTPUT:
	RETVAL

short
nci_siff( c_func, i0, f1, f2 )
	SV* c_func
	int i0
	float f1
	float f2
PREINIT:
	short(*func)(int, float, float);
CODE:
	func   = INT2PTR(short(*)(int, float, float), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, f2);
OUTPUT:
	RETVAL

short
nci_sift( c_func, i0, f1, t2 )
	SV* c_func
	int i0
	float f1
	char * t2
PREINIT:
	short(*func)(int, float, char *);
CODE:
	func   = INT2PTR(short(*)(int, float, char *), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, t2);
OUTPUT:
	RETVAL

short
nci_sifi( c_func, i0, f1, i2 )
	SV* c_func
	int i0
	float f1
	int i2
PREINIT:
	short(*func)(int, float, int);
CODE:
	func   = INT2PTR(short(*)(int, float, int), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, i2);
OUTPUT:
	RETVAL

short
nci_sitp( c_func, i0, t1, p2 )
	SV* c_func
	int i0
	char * t1
	void * p2
PREINIT:
	short(*func)(int, char *, void *);
CODE:
	func   = INT2PTR(short(*)(int, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, p2);
OUTPUT:
	RETVAL

short
nci_sitd( c_func, i0, t1, d2 )
	SV* c_func
	int i0
	char * t1
	double d2
PREINIT:
	short(*func)(int, char *, double);
CODE:
	func   = INT2PTR(short(*)(int, char *, double), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, d2);
OUTPUT:
	RETVAL

short
nci_sits( c_func, i0, t1, s2 )
	SV* c_func
	int i0
	char * t1
	short s2
PREINIT:
	short(*func)(int, char *, short);
CODE:
	func   = INT2PTR(short(*)(int, char *, short), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, s2);
OUTPUT:
	RETVAL

short
nci_sitf( c_func, i0, t1, f2 )
	SV* c_func
	int i0
	char * t1
	float f2
PREINIT:
	short(*func)(int, char *, float);
CODE:
	func   = INT2PTR(short(*)(int, char *, float), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, f2);
OUTPUT:
	RETVAL

short
nci_sitt( c_func, i0, t1, t2 )
	SV* c_func
	int i0
	char * t1
	char * t2
PREINIT:
	short(*func)(int, char *, char *);
CODE:
	func   = INT2PTR(short(*)(int, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, t2);
OUTPUT:
	RETVAL

short
nci_siti( c_func, i0, t1, i2 )
	SV* c_func
	int i0
	char * t1
	int i2
PREINIT:
	short(*func)(int, char *, int);
CODE:
	func   = INT2PTR(short(*)(int, char *, int), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, i2);
OUTPUT:
	RETVAL

short
nci_siip( c_func, i0, i1, p2 )
	SV* c_func
	int i0
	int i1
	void * p2
PREINIT:
	short(*func)(int, int, void *);
CODE:
	func   = INT2PTR(short(*)(int, int, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, p2);
OUTPUT:
	RETVAL

short
nci_siid( c_func, i0, i1, d2 )
	SV* c_func
	int i0
	int i1
	double d2
PREINIT:
	short(*func)(int, int, double);
CODE:
	func   = INT2PTR(short(*)(int, int, double), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, d2);
OUTPUT:
	RETVAL

short
nci_siis( c_func, i0, i1, s2 )
	SV* c_func
	int i0
	int i1
	short s2
PREINIT:
	short(*func)(int, int, short);
CODE:
	func   = INT2PTR(short(*)(int, int, short), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, s2);
OUTPUT:
	RETVAL

short
nci_siif( c_func, i0, i1, f2 )
	SV* c_func
	int i0
	int i1
	float f2
PREINIT:
	short(*func)(int, int, float);
CODE:
	func   = INT2PTR(short(*)(int, int, float), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, f2);
OUTPUT:
	RETVAL

short
nci_siit( c_func, i0, i1, t2 )
	SV* c_func
	int i0
	int i1
	char * t2
PREINIT:
	short(*func)(int, int, char *);
CODE:
	func   = INT2PTR(short(*)(int, int, char *), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, t2);
OUTPUT:
	RETVAL

short
nci_siii( c_func, i0, i1, i2 )
	SV* c_func
	int i0
	int i1
	int i2
PREINIT:
	short(*func)(int, int, int);
CODE:
	func   = INT2PTR(short(*)(int, int, int), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, i2);
OUTPUT:
	RETVAL

float
nci_fppp( c_func, p0, p1, p2 )
	SV* c_func
	void * p0
	void * p1
	void * p2
PREINIT:
	float(*func)(void *, void *, void *);
CODE:
	func   = INT2PTR(float(*)(void *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, p2);
OUTPUT:
	RETVAL

float
nci_fppd( c_func, p0, p1, d2 )
	SV* c_func
	void * p0
	void * p1
	double d2
PREINIT:
	float(*func)(void *, void *, double);
CODE:
	func   = INT2PTR(float(*)(void *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, d2);
OUTPUT:
	RETVAL

float
nci_fpps( c_func, p0, p1, s2 )
	SV* c_func
	void * p0
	void * p1
	short s2
PREINIT:
	float(*func)(void *, void *, short);
CODE:
	func   = INT2PTR(float(*)(void *, void *, short), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, s2);
OUTPUT:
	RETVAL

float
nci_fppf( c_func, p0, p1, f2 )
	SV* c_func
	void * p0
	void * p1
	float f2
PREINIT:
	float(*func)(void *, void *, float);
CODE:
	func   = INT2PTR(float(*)(void *, void *, float), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, f2);
OUTPUT:
	RETVAL

float
nci_fppt( c_func, p0, p1, t2 )
	SV* c_func
	void * p0
	void * p1
	char * t2
PREINIT:
	float(*func)(void *, void *, char *);
CODE:
	func   = INT2PTR(float(*)(void *, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, t2);
OUTPUT:
	RETVAL

float
nci_fppi( c_func, p0, p1, i2 )
	SV* c_func
	void * p0
	void * p1
	int i2
PREINIT:
	float(*func)(void *, void *, int);
CODE:
	func   = INT2PTR(float(*)(void *, void *, int), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, i2);
OUTPUT:
	RETVAL

float
nci_fpdp( c_func, p0, d1, p2 )
	SV* c_func
	void * p0
	double d1
	void * p2
PREINIT:
	float(*func)(void *, double, void *);
CODE:
	func   = INT2PTR(float(*)(void *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, p2);
OUTPUT:
	RETVAL

float
nci_fpdd( c_func, p0, d1, d2 )
	SV* c_func
	void * p0
	double d1
	double d2
PREINIT:
	float(*func)(void *, double, double);
CODE:
	func   = INT2PTR(float(*)(void *, double, double), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, d2);
OUTPUT:
	RETVAL

float
nci_fpds( c_func, p0, d1, s2 )
	SV* c_func
	void * p0
	double d1
	short s2
PREINIT:
	float(*func)(void *, double, short);
CODE:
	func   = INT2PTR(float(*)(void *, double, short), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, s2);
OUTPUT:
	RETVAL

float
nci_fpdf( c_func, p0, d1, f2 )
	SV* c_func
	void * p0
	double d1
	float f2
PREINIT:
	float(*func)(void *, double, float);
CODE:
	func   = INT2PTR(float(*)(void *, double, float), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, f2);
OUTPUT:
	RETVAL

float
nci_fpdt( c_func, p0, d1, t2 )
	SV* c_func
	void * p0
	double d1
	char * t2
PREINIT:
	float(*func)(void *, double, char *);
CODE:
	func   = INT2PTR(float(*)(void *, double, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, t2);
OUTPUT:
	RETVAL

float
nci_fpdi( c_func, p0, d1, i2 )
	SV* c_func
	void * p0
	double d1
	int i2
PREINIT:
	float(*func)(void *, double, int);
CODE:
	func   = INT2PTR(float(*)(void *, double, int), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, i2);
OUTPUT:
	RETVAL

float
nci_fpsp( c_func, p0, s1, p2 )
	SV* c_func
	void * p0
	short s1
	void * p2
PREINIT:
	float(*func)(void *, short, void *);
CODE:
	func   = INT2PTR(float(*)(void *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, p2);
OUTPUT:
	RETVAL

float
nci_fpsd( c_func, p0, s1, d2 )
	SV* c_func
	void * p0
	short s1
	double d2
PREINIT:
	float(*func)(void *, short, double);
CODE:
	func   = INT2PTR(float(*)(void *, short, double), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, d2);
OUTPUT:
	RETVAL

float
nci_fpss( c_func, p0, s1, s2 )
	SV* c_func
	void * p0
	short s1
	short s2
PREINIT:
	float(*func)(void *, short, short);
CODE:
	func   = INT2PTR(float(*)(void *, short, short), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, s2);
OUTPUT:
	RETVAL

float
nci_fpsf( c_func, p0, s1, f2 )
	SV* c_func
	void * p0
	short s1
	float f2
PREINIT:
	float(*func)(void *, short, float);
CODE:
	func   = INT2PTR(float(*)(void *, short, float), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, f2);
OUTPUT:
	RETVAL

float
nci_fpst( c_func, p0, s1, t2 )
	SV* c_func
	void * p0
	short s1
	char * t2
PREINIT:
	float(*func)(void *, short, char *);
CODE:
	func   = INT2PTR(float(*)(void *, short, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, t2);
OUTPUT:
	RETVAL

float
nci_fpsi( c_func, p0, s1, i2 )
	SV* c_func
	void * p0
	short s1
	int i2
PREINIT:
	float(*func)(void *, short, int);
CODE:
	func   = INT2PTR(float(*)(void *, short, int), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, i2);
OUTPUT:
	RETVAL

float
nci_fpfp( c_func, p0, f1, p2 )
	SV* c_func
	void * p0
	float f1
	void * p2
PREINIT:
	float(*func)(void *, float, void *);
CODE:
	func   = INT2PTR(float(*)(void *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, p2);
OUTPUT:
	RETVAL

float
nci_fpfd( c_func, p0, f1, d2 )
	SV* c_func
	void * p0
	float f1
	double d2
PREINIT:
	float(*func)(void *, float, double);
CODE:
	func   = INT2PTR(float(*)(void *, float, double), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, d2);
OUTPUT:
	RETVAL

float
nci_fpfs( c_func, p0, f1, s2 )
	SV* c_func
	void * p0
	float f1
	short s2
PREINIT:
	float(*func)(void *, float, short);
CODE:
	func   = INT2PTR(float(*)(void *, float, short), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, s2);
OUTPUT:
	RETVAL

float
nci_fpff( c_func, p0, f1, f2 )
	SV* c_func
	void * p0
	float f1
	float f2
PREINIT:
	float(*func)(void *, float, float);
CODE:
	func   = INT2PTR(float(*)(void *, float, float), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, f2);
OUTPUT:
	RETVAL

float
nci_fpft( c_func, p0, f1, t2 )
	SV* c_func
	void * p0
	float f1
	char * t2
PREINIT:
	float(*func)(void *, float, char *);
CODE:
	func   = INT2PTR(float(*)(void *, float, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, t2);
OUTPUT:
	RETVAL

float
nci_fpfi( c_func, p0, f1, i2 )
	SV* c_func
	void * p0
	float f1
	int i2
PREINIT:
	float(*func)(void *, float, int);
CODE:
	func   = INT2PTR(float(*)(void *, float, int), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, i2);
OUTPUT:
	RETVAL

float
nci_fptp( c_func, p0, t1, p2 )
	SV* c_func
	void * p0
	char * t1
	void * p2
PREINIT:
	float(*func)(void *, char *, void *);
CODE:
	func   = INT2PTR(float(*)(void *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, p2);
OUTPUT:
	RETVAL

float
nci_fptd( c_func, p0, t1, d2 )
	SV* c_func
	void * p0
	char * t1
	double d2
PREINIT:
	float(*func)(void *, char *, double);
CODE:
	func   = INT2PTR(float(*)(void *, char *, double), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, d2);
OUTPUT:
	RETVAL

float
nci_fpts( c_func, p0, t1, s2 )
	SV* c_func
	void * p0
	char * t1
	short s2
PREINIT:
	float(*func)(void *, char *, short);
CODE:
	func   = INT2PTR(float(*)(void *, char *, short), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, s2);
OUTPUT:
	RETVAL

float
nci_fptf( c_func, p0, t1, f2 )
	SV* c_func
	void * p0
	char * t1
	float f2
PREINIT:
	float(*func)(void *, char *, float);
CODE:
	func   = INT2PTR(float(*)(void *, char *, float), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, f2);
OUTPUT:
	RETVAL

float
nci_fptt( c_func, p0, t1, t2 )
	SV* c_func
	void * p0
	char * t1
	char * t2
PREINIT:
	float(*func)(void *, char *, char *);
CODE:
	func   = INT2PTR(float(*)(void *, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, t2);
OUTPUT:
	RETVAL

float
nci_fpti( c_func, p0, t1, i2 )
	SV* c_func
	void * p0
	char * t1
	int i2
PREINIT:
	float(*func)(void *, char *, int);
CODE:
	func   = INT2PTR(float(*)(void *, char *, int), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, i2);
OUTPUT:
	RETVAL

float
nci_fpip( c_func, p0, i1, p2 )
	SV* c_func
	void * p0
	int i1
	void * p2
PREINIT:
	float(*func)(void *, int, void *);
CODE:
	func   = INT2PTR(float(*)(void *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, p2);
OUTPUT:
	RETVAL

float
nci_fpid( c_func, p0, i1, d2 )
	SV* c_func
	void * p0
	int i1
	double d2
PREINIT:
	float(*func)(void *, int, double);
CODE:
	func   = INT2PTR(float(*)(void *, int, double), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, d2);
OUTPUT:
	RETVAL

float
nci_fpis( c_func, p0, i1, s2 )
	SV* c_func
	void * p0
	int i1
	short s2
PREINIT:
	float(*func)(void *, int, short);
CODE:
	func   = INT2PTR(float(*)(void *, int, short), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, s2);
OUTPUT:
	RETVAL

float
nci_fpif( c_func, p0, i1, f2 )
	SV* c_func
	void * p0
	int i1
	float f2
PREINIT:
	float(*func)(void *, int, float);
CODE:
	func   = INT2PTR(float(*)(void *, int, float), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, f2);
OUTPUT:
	RETVAL

float
nci_fpit( c_func, p0, i1, t2 )
	SV* c_func
	void * p0
	int i1
	char * t2
PREINIT:
	float(*func)(void *, int, char *);
CODE:
	func   = INT2PTR(float(*)(void *, int, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, t2);
OUTPUT:
	RETVAL

float
nci_fpii( c_func, p0, i1, i2 )
	SV* c_func
	void * p0
	int i1
	int i2
PREINIT:
	float(*func)(void *, int, int);
CODE:
	func   = INT2PTR(float(*)(void *, int, int), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, i2);
OUTPUT:
	RETVAL

float
nci_fdpp( c_func, d0, p1, p2 )
	SV* c_func
	double d0
	void * p1
	void * p2
PREINIT:
	float(*func)(double, void *, void *);
CODE:
	func   = INT2PTR(float(*)(double, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, p2);
OUTPUT:
	RETVAL

float
nci_fdpd( c_func, d0, p1, d2 )
	SV* c_func
	double d0
	void * p1
	double d2
PREINIT:
	float(*func)(double, void *, double);
CODE:
	func   = INT2PTR(float(*)(double, void *, double), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, d2);
OUTPUT:
	RETVAL

float
nci_fdps( c_func, d0, p1, s2 )
	SV* c_func
	double d0
	void * p1
	short s2
PREINIT:
	float(*func)(double, void *, short);
CODE:
	func   = INT2PTR(float(*)(double, void *, short), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, s2);
OUTPUT:
	RETVAL

float
nci_fdpf( c_func, d0, p1, f2 )
	SV* c_func
	double d0
	void * p1
	float f2
PREINIT:
	float(*func)(double, void *, float);
CODE:
	func   = INT2PTR(float(*)(double, void *, float), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, f2);
OUTPUT:
	RETVAL

float
nci_fdpt( c_func, d0, p1, t2 )
	SV* c_func
	double d0
	void * p1
	char * t2
PREINIT:
	float(*func)(double, void *, char *);
CODE:
	func   = INT2PTR(float(*)(double, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, t2);
OUTPUT:
	RETVAL

float
nci_fdpi( c_func, d0, p1, i2 )
	SV* c_func
	double d0
	void * p1
	int i2
PREINIT:
	float(*func)(double, void *, int);
CODE:
	func   = INT2PTR(float(*)(double, void *, int), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, i2);
OUTPUT:
	RETVAL

float
nci_fddp( c_func, d0, d1, p2 )
	SV* c_func
	double d0
	double d1
	void * p2
PREINIT:
	float(*func)(double, double, void *);
CODE:
	func   = INT2PTR(float(*)(double, double, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, p2);
OUTPUT:
	RETVAL

float
nci_fddd( c_func, d0, d1, d2 )
	SV* c_func
	double d0
	double d1
	double d2
PREINIT:
	float(*func)(double, double, double);
CODE:
	func   = INT2PTR(float(*)(double, double, double), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, d2);
OUTPUT:
	RETVAL

float
nci_fdds( c_func, d0, d1, s2 )
	SV* c_func
	double d0
	double d1
	short s2
PREINIT:
	float(*func)(double, double, short);
CODE:
	func   = INT2PTR(float(*)(double, double, short), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, s2);
OUTPUT:
	RETVAL

float
nci_fddf( c_func, d0, d1, f2 )
	SV* c_func
	double d0
	double d1
	float f2
PREINIT:
	float(*func)(double, double, float);
CODE:
	func   = INT2PTR(float(*)(double, double, float), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, f2);
OUTPUT:
	RETVAL

float
nci_fddt( c_func, d0, d1, t2 )
	SV* c_func
	double d0
	double d1
	char * t2
PREINIT:
	float(*func)(double, double, char *);
CODE:
	func   = INT2PTR(float(*)(double, double, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, t2);
OUTPUT:
	RETVAL

float
nci_fddi( c_func, d0, d1, i2 )
	SV* c_func
	double d0
	double d1
	int i2
PREINIT:
	float(*func)(double, double, int);
CODE:
	func   = INT2PTR(float(*)(double, double, int), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, i2);
OUTPUT:
	RETVAL

float
nci_fdsp( c_func, d0, s1, p2 )
	SV* c_func
	double d0
	short s1
	void * p2
PREINIT:
	float(*func)(double, short, void *);
CODE:
	func   = INT2PTR(float(*)(double, short, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, p2);
OUTPUT:
	RETVAL

float
nci_fdsd( c_func, d0, s1, d2 )
	SV* c_func
	double d0
	short s1
	double d2
PREINIT:
	float(*func)(double, short, double);
CODE:
	func   = INT2PTR(float(*)(double, short, double), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, d2);
OUTPUT:
	RETVAL

float
nci_fdss( c_func, d0, s1, s2 )
	SV* c_func
	double d0
	short s1
	short s2
PREINIT:
	float(*func)(double, short, short);
CODE:
	func   = INT2PTR(float(*)(double, short, short), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, s2);
OUTPUT:
	RETVAL

float
nci_fdsf( c_func, d0, s1, f2 )
	SV* c_func
	double d0
	short s1
	float f2
PREINIT:
	float(*func)(double, short, float);
CODE:
	func   = INT2PTR(float(*)(double, short, float), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, f2);
OUTPUT:
	RETVAL

float
nci_fdst( c_func, d0, s1, t2 )
	SV* c_func
	double d0
	short s1
	char * t2
PREINIT:
	float(*func)(double, short, char *);
CODE:
	func   = INT2PTR(float(*)(double, short, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, t2);
OUTPUT:
	RETVAL

float
nci_fdsi( c_func, d0, s1, i2 )
	SV* c_func
	double d0
	short s1
	int i2
PREINIT:
	float(*func)(double, short, int);
CODE:
	func   = INT2PTR(float(*)(double, short, int), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, i2);
OUTPUT:
	RETVAL

float
nci_fdfp( c_func, d0, f1, p2 )
	SV* c_func
	double d0
	float f1
	void * p2
PREINIT:
	float(*func)(double, float, void *);
CODE:
	func   = INT2PTR(float(*)(double, float, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, p2);
OUTPUT:
	RETVAL

float
nci_fdfd( c_func, d0, f1, d2 )
	SV* c_func
	double d0
	float f1
	double d2
PREINIT:
	float(*func)(double, float, double);
CODE:
	func   = INT2PTR(float(*)(double, float, double), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, d2);
OUTPUT:
	RETVAL

float
nci_fdfs( c_func, d0, f1, s2 )
	SV* c_func
	double d0
	float f1
	short s2
PREINIT:
	float(*func)(double, float, short);
CODE:
	func   = INT2PTR(float(*)(double, float, short), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, s2);
OUTPUT:
	RETVAL

float
nci_fdff( c_func, d0, f1, f2 )
	SV* c_func
	double d0
	float f1
	float f2
PREINIT:
	float(*func)(double, float, float);
CODE:
	func   = INT2PTR(float(*)(double, float, float), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, f2);
OUTPUT:
	RETVAL

float
nci_fdft( c_func, d0, f1, t2 )
	SV* c_func
	double d0
	float f1
	char * t2
PREINIT:
	float(*func)(double, float, char *);
CODE:
	func   = INT2PTR(float(*)(double, float, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, t2);
OUTPUT:
	RETVAL

float
nci_fdfi( c_func, d0, f1, i2 )
	SV* c_func
	double d0
	float f1
	int i2
PREINIT:
	float(*func)(double, float, int);
CODE:
	func   = INT2PTR(float(*)(double, float, int), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, i2);
OUTPUT:
	RETVAL

float
nci_fdtp( c_func, d0, t1, p2 )
	SV* c_func
	double d0
	char * t1
	void * p2
PREINIT:
	float(*func)(double, char *, void *);
CODE:
	func   = INT2PTR(float(*)(double, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, p2);
OUTPUT:
	RETVAL

float
nci_fdtd( c_func, d0, t1, d2 )
	SV* c_func
	double d0
	char * t1
	double d2
PREINIT:
	float(*func)(double, char *, double);
CODE:
	func   = INT2PTR(float(*)(double, char *, double), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, d2);
OUTPUT:
	RETVAL

float
nci_fdts( c_func, d0, t1, s2 )
	SV* c_func
	double d0
	char * t1
	short s2
PREINIT:
	float(*func)(double, char *, short);
CODE:
	func   = INT2PTR(float(*)(double, char *, short), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, s2);
OUTPUT:
	RETVAL

float
nci_fdtf( c_func, d0, t1, f2 )
	SV* c_func
	double d0
	char * t1
	float f2
PREINIT:
	float(*func)(double, char *, float);
CODE:
	func   = INT2PTR(float(*)(double, char *, float), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, f2);
OUTPUT:
	RETVAL

float
nci_fdtt( c_func, d0, t1, t2 )
	SV* c_func
	double d0
	char * t1
	char * t2
PREINIT:
	float(*func)(double, char *, char *);
CODE:
	func   = INT2PTR(float(*)(double, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, t2);
OUTPUT:
	RETVAL

float
nci_fdti( c_func, d0, t1, i2 )
	SV* c_func
	double d0
	char * t1
	int i2
PREINIT:
	float(*func)(double, char *, int);
CODE:
	func   = INT2PTR(float(*)(double, char *, int), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, i2);
OUTPUT:
	RETVAL

float
nci_fdip( c_func, d0, i1, p2 )
	SV* c_func
	double d0
	int i1
	void * p2
PREINIT:
	float(*func)(double, int, void *);
CODE:
	func   = INT2PTR(float(*)(double, int, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, p2);
OUTPUT:
	RETVAL

float
nci_fdid( c_func, d0, i1, d2 )
	SV* c_func
	double d0
	int i1
	double d2
PREINIT:
	float(*func)(double, int, double);
CODE:
	func   = INT2PTR(float(*)(double, int, double), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, d2);
OUTPUT:
	RETVAL

float
nci_fdis( c_func, d0, i1, s2 )
	SV* c_func
	double d0
	int i1
	short s2
PREINIT:
	float(*func)(double, int, short);
CODE:
	func   = INT2PTR(float(*)(double, int, short), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, s2);
OUTPUT:
	RETVAL

float
nci_fdif( c_func, d0, i1, f2 )
	SV* c_func
	double d0
	int i1
	float f2
PREINIT:
	float(*func)(double, int, float);
CODE:
	func   = INT2PTR(float(*)(double, int, float), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, f2);
OUTPUT:
	RETVAL

float
nci_fdit( c_func, d0, i1, t2 )
	SV* c_func
	double d0
	int i1
	char * t2
PREINIT:
	float(*func)(double, int, char *);
CODE:
	func   = INT2PTR(float(*)(double, int, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, t2);
OUTPUT:
	RETVAL

float
nci_fdii( c_func, d0, i1, i2 )
	SV* c_func
	double d0
	int i1
	int i2
PREINIT:
	float(*func)(double, int, int);
CODE:
	func   = INT2PTR(float(*)(double, int, int), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, i2);
OUTPUT:
	RETVAL

float
nci_fspp( c_func, s0, p1, p2 )
	SV* c_func
	short s0
	void * p1
	void * p2
PREINIT:
	float(*func)(short, void *, void *);
CODE:
	func   = INT2PTR(float(*)(short, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, p2);
OUTPUT:
	RETVAL

float
nci_fspd( c_func, s0, p1, d2 )
	SV* c_func
	short s0
	void * p1
	double d2
PREINIT:
	float(*func)(short, void *, double);
CODE:
	func   = INT2PTR(float(*)(short, void *, double), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, d2);
OUTPUT:
	RETVAL

float
nci_fsps( c_func, s0, p1, s2 )
	SV* c_func
	short s0
	void * p1
	short s2
PREINIT:
	float(*func)(short, void *, short);
CODE:
	func   = INT2PTR(float(*)(short, void *, short), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, s2);
OUTPUT:
	RETVAL

float
nci_fspf( c_func, s0, p1, f2 )
	SV* c_func
	short s0
	void * p1
	float f2
PREINIT:
	float(*func)(short, void *, float);
CODE:
	func   = INT2PTR(float(*)(short, void *, float), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, f2);
OUTPUT:
	RETVAL

float
nci_fspt( c_func, s0, p1, t2 )
	SV* c_func
	short s0
	void * p1
	char * t2
PREINIT:
	float(*func)(short, void *, char *);
CODE:
	func   = INT2PTR(float(*)(short, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, t2);
OUTPUT:
	RETVAL

float
nci_fspi( c_func, s0, p1, i2 )
	SV* c_func
	short s0
	void * p1
	int i2
PREINIT:
	float(*func)(short, void *, int);
CODE:
	func   = INT2PTR(float(*)(short, void *, int), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, i2);
OUTPUT:
	RETVAL

float
nci_fsdp( c_func, s0, d1, p2 )
	SV* c_func
	short s0
	double d1
	void * p2
PREINIT:
	float(*func)(short, double, void *);
CODE:
	func   = INT2PTR(float(*)(short, double, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, p2);
OUTPUT:
	RETVAL

float
nci_fsdd( c_func, s0, d1, d2 )
	SV* c_func
	short s0
	double d1
	double d2
PREINIT:
	float(*func)(short, double, double);
CODE:
	func   = INT2PTR(float(*)(short, double, double), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, d2);
OUTPUT:
	RETVAL

float
nci_fsds( c_func, s0, d1, s2 )
	SV* c_func
	short s0
	double d1
	short s2
PREINIT:
	float(*func)(short, double, short);
CODE:
	func   = INT2PTR(float(*)(short, double, short), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, s2);
OUTPUT:
	RETVAL

float
nci_fsdf( c_func, s0, d1, f2 )
	SV* c_func
	short s0
	double d1
	float f2
PREINIT:
	float(*func)(short, double, float);
CODE:
	func   = INT2PTR(float(*)(short, double, float), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, f2);
OUTPUT:
	RETVAL

float
nci_fsdt( c_func, s0, d1, t2 )
	SV* c_func
	short s0
	double d1
	char * t2
PREINIT:
	float(*func)(short, double, char *);
CODE:
	func   = INT2PTR(float(*)(short, double, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, t2);
OUTPUT:
	RETVAL

float
nci_fsdi( c_func, s0, d1, i2 )
	SV* c_func
	short s0
	double d1
	int i2
PREINIT:
	float(*func)(short, double, int);
CODE:
	func   = INT2PTR(float(*)(short, double, int), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, i2);
OUTPUT:
	RETVAL

float
nci_fssp( c_func, s0, s1, p2 )
	SV* c_func
	short s0
	short s1
	void * p2
PREINIT:
	float(*func)(short, short, void *);
CODE:
	func   = INT2PTR(float(*)(short, short, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, p2);
OUTPUT:
	RETVAL

float
nci_fssd( c_func, s0, s1, d2 )
	SV* c_func
	short s0
	short s1
	double d2
PREINIT:
	float(*func)(short, short, double);
CODE:
	func   = INT2PTR(float(*)(short, short, double), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, d2);
OUTPUT:
	RETVAL

float
nci_fsss( c_func, s0, s1, s2 )
	SV* c_func
	short s0
	short s1
	short s2
PREINIT:
	float(*func)(short, short, short);
CODE:
	func   = INT2PTR(float(*)(short, short, short), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, s2);
OUTPUT:
	RETVAL

float
nci_fssf( c_func, s0, s1, f2 )
	SV* c_func
	short s0
	short s1
	float f2
PREINIT:
	float(*func)(short, short, float);
CODE:
	func   = INT2PTR(float(*)(short, short, float), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, f2);
OUTPUT:
	RETVAL

float
nci_fsst( c_func, s0, s1, t2 )
	SV* c_func
	short s0
	short s1
	char * t2
PREINIT:
	float(*func)(short, short, char *);
CODE:
	func   = INT2PTR(float(*)(short, short, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, t2);
OUTPUT:
	RETVAL

float
nci_fssi( c_func, s0, s1, i2 )
	SV* c_func
	short s0
	short s1
	int i2
PREINIT:
	float(*func)(short, short, int);
CODE:
	func   = INT2PTR(float(*)(short, short, int), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, i2);
OUTPUT:
	RETVAL

float
nci_fsfp( c_func, s0, f1, p2 )
	SV* c_func
	short s0
	float f1
	void * p2
PREINIT:
	float(*func)(short, float, void *);
CODE:
	func   = INT2PTR(float(*)(short, float, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, p2);
OUTPUT:
	RETVAL

float
nci_fsfd( c_func, s0, f1, d2 )
	SV* c_func
	short s0
	float f1
	double d2
PREINIT:
	float(*func)(short, float, double);
CODE:
	func   = INT2PTR(float(*)(short, float, double), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, d2);
OUTPUT:
	RETVAL

float
nci_fsfs( c_func, s0, f1, s2 )
	SV* c_func
	short s0
	float f1
	short s2
PREINIT:
	float(*func)(short, float, short);
CODE:
	func   = INT2PTR(float(*)(short, float, short), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, s2);
OUTPUT:
	RETVAL

float
nci_fsff( c_func, s0, f1, f2 )
	SV* c_func
	short s0
	float f1
	float f2
PREINIT:
	float(*func)(short, float, float);
CODE:
	func   = INT2PTR(float(*)(short, float, float), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, f2);
OUTPUT:
	RETVAL

float
nci_fsft( c_func, s0, f1, t2 )
	SV* c_func
	short s0
	float f1
	char * t2
PREINIT:
	float(*func)(short, float, char *);
CODE:
	func   = INT2PTR(float(*)(short, float, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, t2);
OUTPUT:
	RETVAL

float
nci_fsfi( c_func, s0, f1, i2 )
	SV* c_func
	short s0
	float f1
	int i2
PREINIT:
	float(*func)(short, float, int);
CODE:
	func   = INT2PTR(float(*)(short, float, int), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, i2);
OUTPUT:
	RETVAL

float
nci_fstp( c_func, s0, t1, p2 )
	SV* c_func
	short s0
	char * t1
	void * p2
PREINIT:
	float(*func)(short, char *, void *);
CODE:
	func   = INT2PTR(float(*)(short, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, p2);
OUTPUT:
	RETVAL

float
nci_fstd( c_func, s0, t1, d2 )
	SV* c_func
	short s0
	char * t1
	double d2
PREINIT:
	float(*func)(short, char *, double);
CODE:
	func   = INT2PTR(float(*)(short, char *, double), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, d2);
OUTPUT:
	RETVAL

float
nci_fsts( c_func, s0, t1, s2 )
	SV* c_func
	short s0
	char * t1
	short s2
PREINIT:
	float(*func)(short, char *, short);
CODE:
	func   = INT2PTR(float(*)(short, char *, short), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, s2);
OUTPUT:
	RETVAL

float
nci_fstf( c_func, s0, t1, f2 )
	SV* c_func
	short s0
	char * t1
	float f2
PREINIT:
	float(*func)(short, char *, float);
CODE:
	func   = INT2PTR(float(*)(short, char *, float), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, f2);
OUTPUT:
	RETVAL

float
nci_fstt( c_func, s0, t1, t2 )
	SV* c_func
	short s0
	char * t1
	char * t2
PREINIT:
	float(*func)(short, char *, char *);
CODE:
	func   = INT2PTR(float(*)(short, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, t2);
OUTPUT:
	RETVAL

float
nci_fsti( c_func, s0, t1, i2 )
	SV* c_func
	short s0
	char * t1
	int i2
PREINIT:
	float(*func)(short, char *, int);
CODE:
	func   = INT2PTR(float(*)(short, char *, int), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, i2);
OUTPUT:
	RETVAL

float
nci_fsip( c_func, s0, i1, p2 )
	SV* c_func
	short s0
	int i1
	void * p2
PREINIT:
	float(*func)(short, int, void *);
CODE:
	func   = INT2PTR(float(*)(short, int, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, p2);
OUTPUT:
	RETVAL

float
nci_fsid( c_func, s0, i1, d2 )
	SV* c_func
	short s0
	int i1
	double d2
PREINIT:
	float(*func)(short, int, double);
CODE:
	func   = INT2PTR(float(*)(short, int, double), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, d2);
OUTPUT:
	RETVAL

float
nci_fsis( c_func, s0, i1, s2 )
	SV* c_func
	short s0
	int i1
	short s2
PREINIT:
	float(*func)(short, int, short);
CODE:
	func   = INT2PTR(float(*)(short, int, short), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, s2);
OUTPUT:
	RETVAL

float
nci_fsif( c_func, s0, i1, f2 )
	SV* c_func
	short s0
	int i1
	float f2
PREINIT:
	float(*func)(short, int, float);
CODE:
	func   = INT2PTR(float(*)(short, int, float), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, f2);
OUTPUT:
	RETVAL

float
nci_fsit( c_func, s0, i1, t2 )
	SV* c_func
	short s0
	int i1
	char * t2
PREINIT:
	float(*func)(short, int, char *);
CODE:
	func   = INT2PTR(float(*)(short, int, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, t2);
OUTPUT:
	RETVAL

float
nci_fsii( c_func, s0, i1, i2 )
	SV* c_func
	short s0
	int i1
	int i2
PREINIT:
	float(*func)(short, int, int);
CODE:
	func   = INT2PTR(float(*)(short, int, int), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, i2);
OUTPUT:
	RETVAL

float
nci_ffpp( c_func, f0, p1, p2 )
	SV* c_func
	float f0
	void * p1
	void * p2
PREINIT:
	float(*func)(float, void *, void *);
CODE:
	func   = INT2PTR(float(*)(float, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, p2);
OUTPUT:
	RETVAL

float
nci_ffpd( c_func, f0, p1, d2 )
	SV* c_func
	float f0
	void * p1
	double d2
PREINIT:
	float(*func)(float, void *, double);
CODE:
	func   = INT2PTR(float(*)(float, void *, double), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, d2);
OUTPUT:
	RETVAL

float
nci_ffps( c_func, f0, p1, s2 )
	SV* c_func
	float f0
	void * p1
	short s2
PREINIT:
	float(*func)(float, void *, short);
CODE:
	func   = INT2PTR(float(*)(float, void *, short), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, s2);
OUTPUT:
	RETVAL

float
nci_ffpf( c_func, f0, p1, f2 )
	SV* c_func
	float f0
	void * p1
	float f2
PREINIT:
	float(*func)(float, void *, float);
CODE:
	func   = INT2PTR(float(*)(float, void *, float), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, f2);
OUTPUT:
	RETVAL

float
nci_ffpt( c_func, f0, p1, t2 )
	SV* c_func
	float f0
	void * p1
	char * t2
PREINIT:
	float(*func)(float, void *, char *);
CODE:
	func   = INT2PTR(float(*)(float, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, t2);
OUTPUT:
	RETVAL

float
nci_ffpi( c_func, f0, p1, i2 )
	SV* c_func
	float f0
	void * p1
	int i2
PREINIT:
	float(*func)(float, void *, int);
CODE:
	func   = INT2PTR(float(*)(float, void *, int), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, i2);
OUTPUT:
	RETVAL

float
nci_ffdp( c_func, f0, d1, p2 )
	SV* c_func
	float f0
	double d1
	void * p2
PREINIT:
	float(*func)(float, double, void *);
CODE:
	func   = INT2PTR(float(*)(float, double, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, p2);
OUTPUT:
	RETVAL

float
nci_ffdd( c_func, f0, d1, d2 )
	SV* c_func
	float f0
	double d1
	double d2
PREINIT:
	float(*func)(float, double, double);
CODE:
	func   = INT2PTR(float(*)(float, double, double), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, d2);
OUTPUT:
	RETVAL

float
nci_ffds( c_func, f0, d1, s2 )
	SV* c_func
	float f0
	double d1
	short s2
PREINIT:
	float(*func)(float, double, short);
CODE:
	func   = INT2PTR(float(*)(float, double, short), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, s2);
OUTPUT:
	RETVAL

float
nci_ffdf( c_func, f0, d1, f2 )
	SV* c_func
	float f0
	double d1
	float f2
PREINIT:
	float(*func)(float, double, float);
CODE:
	func   = INT2PTR(float(*)(float, double, float), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, f2);
OUTPUT:
	RETVAL

float
nci_ffdt( c_func, f0, d1, t2 )
	SV* c_func
	float f0
	double d1
	char * t2
PREINIT:
	float(*func)(float, double, char *);
CODE:
	func   = INT2PTR(float(*)(float, double, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, t2);
OUTPUT:
	RETVAL

float
nci_ffdi( c_func, f0, d1, i2 )
	SV* c_func
	float f0
	double d1
	int i2
PREINIT:
	float(*func)(float, double, int);
CODE:
	func   = INT2PTR(float(*)(float, double, int), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, i2);
OUTPUT:
	RETVAL

float
nci_ffsp( c_func, f0, s1, p2 )
	SV* c_func
	float f0
	short s1
	void * p2
PREINIT:
	float(*func)(float, short, void *);
CODE:
	func   = INT2PTR(float(*)(float, short, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, p2);
OUTPUT:
	RETVAL

float
nci_ffsd( c_func, f0, s1, d2 )
	SV* c_func
	float f0
	short s1
	double d2
PREINIT:
	float(*func)(float, short, double);
CODE:
	func   = INT2PTR(float(*)(float, short, double), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, d2);
OUTPUT:
	RETVAL

float
nci_ffss( c_func, f0, s1, s2 )
	SV* c_func
	float f0
	short s1
	short s2
PREINIT:
	float(*func)(float, short, short);
CODE:
	func   = INT2PTR(float(*)(float, short, short), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, s2);
OUTPUT:
	RETVAL

float
nci_ffsf( c_func, f0, s1, f2 )
	SV* c_func
	float f0
	short s1
	float f2
PREINIT:
	float(*func)(float, short, float);
CODE:
	func   = INT2PTR(float(*)(float, short, float), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, f2);
OUTPUT:
	RETVAL

float
nci_ffst( c_func, f0, s1, t2 )
	SV* c_func
	float f0
	short s1
	char * t2
PREINIT:
	float(*func)(float, short, char *);
CODE:
	func   = INT2PTR(float(*)(float, short, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, t2);
OUTPUT:
	RETVAL

float
nci_ffsi( c_func, f0, s1, i2 )
	SV* c_func
	float f0
	short s1
	int i2
PREINIT:
	float(*func)(float, short, int);
CODE:
	func   = INT2PTR(float(*)(float, short, int), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, i2);
OUTPUT:
	RETVAL

float
nci_fffp( c_func, f0, f1, p2 )
	SV* c_func
	float f0
	float f1
	void * p2
PREINIT:
	float(*func)(float, float, void *);
CODE:
	func   = INT2PTR(float(*)(float, float, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, p2);
OUTPUT:
	RETVAL

float
nci_fffd( c_func, f0, f1, d2 )
	SV* c_func
	float f0
	float f1
	double d2
PREINIT:
	float(*func)(float, float, double);
CODE:
	func   = INT2PTR(float(*)(float, float, double), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, d2);
OUTPUT:
	RETVAL

float
nci_fffs( c_func, f0, f1, s2 )
	SV* c_func
	float f0
	float f1
	short s2
PREINIT:
	float(*func)(float, float, short);
CODE:
	func   = INT2PTR(float(*)(float, float, short), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, s2);
OUTPUT:
	RETVAL

float
nci_ffff( c_func, f0, f1, f2 )
	SV* c_func
	float f0
	float f1
	float f2
PREINIT:
	float(*func)(float, float, float);
CODE:
	func   = INT2PTR(float(*)(float, float, float), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, f2);
OUTPUT:
	RETVAL

float
nci_ffft( c_func, f0, f1, t2 )
	SV* c_func
	float f0
	float f1
	char * t2
PREINIT:
	float(*func)(float, float, char *);
CODE:
	func   = INT2PTR(float(*)(float, float, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, t2);
OUTPUT:
	RETVAL

float
nci_fffi( c_func, f0, f1, i2 )
	SV* c_func
	float f0
	float f1
	int i2
PREINIT:
	float(*func)(float, float, int);
CODE:
	func   = INT2PTR(float(*)(float, float, int), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, i2);
OUTPUT:
	RETVAL

float
nci_fftp( c_func, f0, t1, p2 )
	SV* c_func
	float f0
	char * t1
	void * p2
PREINIT:
	float(*func)(float, char *, void *);
CODE:
	func   = INT2PTR(float(*)(float, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, p2);
OUTPUT:
	RETVAL

float
nci_fftd( c_func, f0, t1, d2 )
	SV* c_func
	float f0
	char * t1
	double d2
PREINIT:
	float(*func)(float, char *, double);
CODE:
	func   = INT2PTR(float(*)(float, char *, double), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, d2);
OUTPUT:
	RETVAL

float
nci_ffts( c_func, f0, t1, s2 )
	SV* c_func
	float f0
	char * t1
	short s2
PREINIT:
	float(*func)(float, char *, short);
CODE:
	func   = INT2PTR(float(*)(float, char *, short), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, s2);
OUTPUT:
	RETVAL

float
nci_fftf( c_func, f0, t1, f2 )
	SV* c_func
	float f0
	char * t1
	float f2
PREINIT:
	float(*func)(float, char *, float);
CODE:
	func   = INT2PTR(float(*)(float, char *, float), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, f2);
OUTPUT:
	RETVAL

float
nci_fftt( c_func, f0, t1, t2 )
	SV* c_func
	float f0
	char * t1
	char * t2
PREINIT:
	float(*func)(float, char *, char *);
CODE:
	func   = INT2PTR(float(*)(float, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, t2);
OUTPUT:
	RETVAL

float
nci_ffti( c_func, f0, t1, i2 )
	SV* c_func
	float f0
	char * t1
	int i2
PREINIT:
	float(*func)(float, char *, int);
CODE:
	func   = INT2PTR(float(*)(float, char *, int), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, i2);
OUTPUT:
	RETVAL

float
nci_ffip( c_func, f0, i1, p2 )
	SV* c_func
	float f0
	int i1
	void * p2
PREINIT:
	float(*func)(float, int, void *);
CODE:
	func   = INT2PTR(float(*)(float, int, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, p2);
OUTPUT:
	RETVAL

float
nci_ffid( c_func, f0, i1, d2 )
	SV* c_func
	float f0
	int i1
	double d2
PREINIT:
	float(*func)(float, int, double);
CODE:
	func   = INT2PTR(float(*)(float, int, double), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, d2);
OUTPUT:
	RETVAL

float
nci_ffis( c_func, f0, i1, s2 )
	SV* c_func
	float f0
	int i1
	short s2
PREINIT:
	float(*func)(float, int, short);
CODE:
	func   = INT2PTR(float(*)(float, int, short), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, s2);
OUTPUT:
	RETVAL

float
nci_ffif( c_func, f0, i1, f2 )
	SV* c_func
	float f0
	int i1
	float f2
PREINIT:
	float(*func)(float, int, float);
CODE:
	func   = INT2PTR(float(*)(float, int, float), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, f2);
OUTPUT:
	RETVAL

float
nci_ffit( c_func, f0, i1, t2 )
	SV* c_func
	float f0
	int i1
	char * t2
PREINIT:
	float(*func)(float, int, char *);
CODE:
	func   = INT2PTR(float(*)(float, int, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, t2);
OUTPUT:
	RETVAL

float
nci_ffii( c_func, f0, i1, i2 )
	SV* c_func
	float f0
	int i1
	int i2
PREINIT:
	float(*func)(float, int, int);
CODE:
	func   = INT2PTR(float(*)(float, int, int), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, i2);
OUTPUT:
	RETVAL

float
nci_ftpp( c_func, t0, p1, p2 )
	SV* c_func
	char * t0
	void * p1
	void * p2
PREINIT:
	float(*func)(char *, void *, void *);
CODE:
	func   = INT2PTR(float(*)(char *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, p2);
OUTPUT:
	RETVAL

float
nci_ftpd( c_func, t0, p1, d2 )
	SV* c_func
	char * t0
	void * p1
	double d2
PREINIT:
	float(*func)(char *, void *, double);
CODE:
	func   = INT2PTR(float(*)(char *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, d2);
OUTPUT:
	RETVAL

float
nci_ftps( c_func, t0, p1, s2 )
	SV* c_func
	char * t0
	void * p1
	short s2
PREINIT:
	float(*func)(char *, void *, short);
CODE:
	func   = INT2PTR(float(*)(char *, void *, short), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, s2);
OUTPUT:
	RETVAL

float
nci_ftpf( c_func, t0, p1, f2 )
	SV* c_func
	char * t0
	void * p1
	float f2
PREINIT:
	float(*func)(char *, void *, float);
CODE:
	func   = INT2PTR(float(*)(char *, void *, float), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, f2);
OUTPUT:
	RETVAL

float
nci_ftpt( c_func, t0, p1, t2 )
	SV* c_func
	char * t0
	void * p1
	char * t2
PREINIT:
	float(*func)(char *, void *, char *);
CODE:
	func   = INT2PTR(float(*)(char *, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, t2);
OUTPUT:
	RETVAL

float
nci_ftpi( c_func, t0, p1, i2 )
	SV* c_func
	char * t0
	void * p1
	int i2
PREINIT:
	float(*func)(char *, void *, int);
CODE:
	func   = INT2PTR(float(*)(char *, void *, int), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, i2);
OUTPUT:
	RETVAL

float
nci_ftdp( c_func, t0, d1, p2 )
	SV* c_func
	char * t0
	double d1
	void * p2
PREINIT:
	float(*func)(char *, double, void *);
CODE:
	func   = INT2PTR(float(*)(char *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, p2);
OUTPUT:
	RETVAL

float
nci_ftdd( c_func, t0, d1, d2 )
	SV* c_func
	char * t0
	double d1
	double d2
PREINIT:
	float(*func)(char *, double, double);
CODE:
	func   = INT2PTR(float(*)(char *, double, double), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, d2);
OUTPUT:
	RETVAL

float
nci_ftds( c_func, t0, d1, s2 )
	SV* c_func
	char * t0
	double d1
	short s2
PREINIT:
	float(*func)(char *, double, short);
CODE:
	func   = INT2PTR(float(*)(char *, double, short), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, s2);
OUTPUT:
	RETVAL

float
nci_ftdf( c_func, t0, d1, f2 )
	SV* c_func
	char * t0
	double d1
	float f2
PREINIT:
	float(*func)(char *, double, float);
CODE:
	func   = INT2PTR(float(*)(char *, double, float), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, f2);
OUTPUT:
	RETVAL

float
nci_ftdt( c_func, t0, d1, t2 )
	SV* c_func
	char * t0
	double d1
	char * t2
PREINIT:
	float(*func)(char *, double, char *);
CODE:
	func   = INT2PTR(float(*)(char *, double, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, t2);
OUTPUT:
	RETVAL

float
nci_ftdi( c_func, t0, d1, i2 )
	SV* c_func
	char * t0
	double d1
	int i2
PREINIT:
	float(*func)(char *, double, int);
CODE:
	func   = INT2PTR(float(*)(char *, double, int), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, i2);
OUTPUT:
	RETVAL

float
nci_ftsp( c_func, t0, s1, p2 )
	SV* c_func
	char * t0
	short s1
	void * p2
PREINIT:
	float(*func)(char *, short, void *);
CODE:
	func   = INT2PTR(float(*)(char *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, p2);
OUTPUT:
	RETVAL

float
nci_ftsd( c_func, t0, s1, d2 )
	SV* c_func
	char * t0
	short s1
	double d2
PREINIT:
	float(*func)(char *, short, double);
CODE:
	func   = INT2PTR(float(*)(char *, short, double), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, d2);
OUTPUT:
	RETVAL

float
nci_ftss( c_func, t0, s1, s2 )
	SV* c_func
	char * t0
	short s1
	short s2
PREINIT:
	float(*func)(char *, short, short);
CODE:
	func   = INT2PTR(float(*)(char *, short, short), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, s2);
OUTPUT:
	RETVAL

float
nci_ftsf( c_func, t0, s1, f2 )
	SV* c_func
	char * t0
	short s1
	float f2
PREINIT:
	float(*func)(char *, short, float);
CODE:
	func   = INT2PTR(float(*)(char *, short, float), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, f2);
OUTPUT:
	RETVAL

float
nci_ftst( c_func, t0, s1, t2 )
	SV* c_func
	char * t0
	short s1
	char * t2
PREINIT:
	float(*func)(char *, short, char *);
CODE:
	func   = INT2PTR(float(*)(char *, short, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, t2);
OUTPUT:
	RETVAL

float
nci_ftsi( c_func, t0, s1, i2 )
	SV* c_func
	char * t0
	short s1
	int i2
PREINIT:
	float(*func)(char *, short, int);
CODE:
	func   = INT2PTR(float(*)(char *, short, int), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, i2);
OUTPUT:
	RETVAL

float
nci_ftfp( c_func, t0, f1, p2 )
	SV* c_func
	char * t0
	float f1
	void * p2
PREINIT:
	float(*func)(char *, float, void *);
CODE:
	func   = INT2PTR(float(*)(char *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, p2);
OUTPUT:
	RETVAL

float
nci_ftfd( c_func, t0, f1, d2 )
	SV* c_func
	char * t0
	float f1
	double d2
PREINIT:
	float(*func)(char *, float, double);
CODE:
	func   = INT2PTR(float(*)(char *, float, double), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, d2);
OUTPUT:
	RETVAL

float
nci_ftfs( c_func, t0, f1, s2 )
	SV* c_func
	char * t0
	float f1
	short s2
PREINIT:
	float(*func)(char *, float, short);
CODE:
	func   = INT2PTR(float(*)(char *, float, short), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, s2);
OUTPUT:
	RETVAL

float
nci_ftff( c_func, t0, f1, f2 )
	SV* c_func
	char * t0
	float f1
	float f2
PREINIT:
	float(*func)(char *, float, float);
CODE:
	func   = INT2PTR(float(*)(char *, float, float), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, f2);
OUTPUT:
	RETVAL

float
nci_ftft( c_func, t0, f1, t2 )
	SV* c_func
	char * t0
	float f1
	char * t2
PREINIT:
	float(*func)(char *, float, char *);
CODE:
	func   = INT2PTR(float(*)(char *, float, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, t2);
OUTPUT:
	RETVAL

float
nci_ftfi( c_func, t0, f1, i2 )
	SV* c_func
	char * t0
	float f1
	int i2
PREINIT:
	float(*func)(char *, float, int);
CODE:
	func   = INT2PTR(float(*)(char *, float, int), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, i2);
OUTPUT:
	RETVAL

float
nci_fttp( c_func, t0, t1, p2 )
	SV* c_func
	char * t0
	char * t1
	void * p2
PREINIT:
	float(*func)(char *, char *, void *);
CODE:
	func   = INT2PTR(float(*)(char *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, p2);
OUTPUT:
	RETVAL

float
nci_fttd( c_func, t0, t1, d2 )
	SV* c_func
	char * t0
	char * t1
	double d2
PREINIT:
	float(*func)(char *, char *, double);
CODE:
	func   = INT2PTR(float(*)(char *, char *, double), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, d2);
OUTPUT:
	RETVAL

float
nci_ftts( c_func, t0, t1, s2 )
	SV* c_func
	char * t0
	char * t1
	short s2
PREINIT:
	float(*func)(char *, char *, short);
CODE:
	func   = INT2PTR(float(*)(char *, char *, short), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, s2);
OUTPUT:
	RETVAL

float
nci_fttf( c_func, t0, t1, f2 )
	SV* c_func
	char * t0
	char * t1
	float f2
PREINIT:
	float(*func)(char *, char *, float);
CODE:
	func   = INT2PTR(float(*)(char *, char *, float), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, f2);
OUTPUT:
	RETVAL

float
nci_fttt( c_func, t0, t1, t2 )
	SV* c_func
	char * t0
	char * t1
	char * t2
PREINIT:
	float(*func)(char *, char *, char *);
CODE:
	func   = INT2PTR(float(*)(char *, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, t2);
OUTPUT:
	RETVAL

float
nci_ftti( c_func, t0, t1, i2 )
	SV* c_func
	char * t0
	char * t1
	int i2
PREINIT:
	float(*func)(char *, char *, int);
CODE:
	func   = INT2PTR(float(*)(char *, char *, int), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, i2);
OUTPUT:
	RETVAL

float
nci_ftip( c_func, t0, i1, p2 )
	SV* c_func
	char * t0
	int i1
	void * p2
PREINIT:
	float(*func)(char *, int, void *);
CODE:
	func   = INT2PTR(float(*)(char *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, p2);
OUTPUT:
	RETVAL

float
nci_ftid( c_func, t0, i1, d2 )
	SV* c_func
	char * t0
	int i1
	double d2
PREINIT:
	float(*func)(char *, int, double);
CODE:
	func   = INT2PTR(float(*)(char *, int, double), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, d2);
OUTPUT:
	RETVAL

float
nci_ftis( c_func, t0, i1, s2 )
	SV* c_func
	char * t0
	int i1
	short s2
PREINIT:
	float(*func)(char *, int, short);
CODE:
	func   = INT2PTR(float(*)(char *, int, short), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, s2);
OUTPUT:
	RETVAL

float
nci_ftif( c_func, t0, i1, f2 )
	SV* c_func
	char * t0
	int i1
	float f2
PREINIT:
	float(*func)(char *, int, float);
CODE:
	func   = INT2PTR(float(*)(char *, int, float), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, f2);
OUTPUT:
	RETVAL

float
nci_ftit( c_func, t0, i1, t2 )
	SV* c_func
	char * t0
	int i1
	char * t2
PREINIT:
	float(*func)(char *, int, char *);
CODE:
	func   = INT2PTR(float(*)(char *, int, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, t2);
OUTPUT:
	RETVAL

float
nci_ftii( c_func, t0, i1, i2 )
	SV* c_func
	char * t0
	int i1
	int i2
PREINIT:
	float(*func)(char *, int, int);
CODE:
	func   = INT2PTR(float(*)(char *, int, int), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, i2);
OUTPUT:
	RETVAL

float
nci_fipp( c_func, i0, p1, p2 )
	SV* c_func
	int i0
	void * p1
	void * p2
PREINIT:
	float(*func)(int, void *, void *);
CODE:
	func   = INT2PTR(float(*)(int, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, p2);
OUTPUT:
	RETVAL

float
nci_fipd( c_func, i0, p1, d2 )
	SV* c_func
	int i0
	void * p1
	double d2
PREINIT:
	float(*func)(int, void *, double);
CODE:
	func   = INT2PTR(float(*)(int, void *, double), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, d2);
OUTPUT:
	RETVAL

float
nci_fips( c_func, i0, p1, s2 )
	SV* c_func
	int i0
	void * p1
	short s2
PREINIT:
	float(*func)(int, void *, short);
CODE:
	func   = INT2PTR(float(*)(int, void *, short), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, s2);
OUTPUT:
	RETVAL

float
nci_fipf( c_func, i0, p1, f2 )
	SV* c_func
	int i0
	void * p1
	float f2
PREINIT:
	float(*func)(int, void *, float);
CODE:
	func   = INT2PTR(float(*)(int, void *, float), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, f2);
OUTPUT:
	RETVAL

float
nci_fipt( c_func, i0, p1, t2 )
	SV* c_func
	int i0
	void * p1
	char * t2
PREINIT:
	float(*func)(int, void *, char *);
CODE:
	func   = INT2PTR(float(*)(int, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, t2);
OUTPUT:
	RETVAL

float
nci_fipi( c_func, i0, p1, i2 )
	SV* c_func
	int i0
	void * p1
	int i2
PREINIT:
	float(*func)(int, void *, int);
CODE:
	func   = INT2PTR(float(*)(int, void *, int), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, i2);
OUTPUT:
	RETVAL

float
nci_fidp( c_func, i0, d1, p2 )
	SV* c_func
	int i0
	double d1
	void * p2
PREINIT:
	float(*func)(int, double, void *);
CODE:
	func   = INT2PTR(float(*)(int, double, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, p2);
OUTPUT:
	RETVAL

float
nci_fidd( c_func, i0, d1, d2 )
	SV* c_func
	int i0
	double d1
	double d2
PREINIT:
	float(*func)(int, double, double);
CODE:
	func   = INT2PTR(float(*)(int, double, double), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, d2);
OUTPUT:
	RETVAL

float
nci_fids( c_func, i0, d1, s2 )
	SV* c_func
	int i0
	double d1
	short s2
PREINIT:
	float(*func)(int, double, short);
CODE:
	func   = INT2PTR(float(*)(int, double, short), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, s2);
OUTPUT:
	RETVAL

float
nci_fidf( c_func, i0, d1, f2 )
	SV* c_func
	int i0
	double d1
	float f2
PREINIT:
	float(*func)(int, double, float);
CODE:
	func   = INT2PTR(float(*)(int, double, float), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, f2);
OUTPUT:
	RETVAL

float
nci_fidt( c_func, i0, d1, t2 )
	SV* c_func
	int i0
	double d1
	char * t2
PREINIT:
	float(*func)(int, double, char *);
CODE:
	func   = INT2PTR(float(*)(int, double, char *), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, t2);
OUTPUT:
	RETVAL

float
nci_fidi( c_func, i0, d1, i2 )
	SV* c_func
	int i0
	double d1
	int i2
PREINIT:
	float(*func)(int, double, int);
CODE:
	func   = INT2PTR(float(*)(int, double, int), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, i2);
OUTPUT:
	RETVAL

float
nci_fisp( c_func, i0, s1, p2 )
	SV* c_func
	int i0
	short s1
	void * p2
PREINIT:
	float(*func)(int, short, void *);
CODE:
	func   = INT2PTR(float(*)(int, short, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, p2);
OUTPUT:
	RETVAL

float
nci_fisd( c_func, i0, s1, d2 )
	SV* c_func
	int i0
	short s1
	double d2
PREINIT:
	float(*func)(int, short, double);
CODE:
	func   = INT2PTR(float(*)(int, short, double), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, d2);
OUTPUT:
	RETVAL

float
nci_fiss( c_func, i0, s1, s2 )
	SV* c_func
	int i0
	short s1
	short s2
PREINIT:
	float(*func)(int, short, short);
CODE:
	func   = INT2PTR(float(*)(int, short, short), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, s2);
OUTPUT:
	RETVAL

float
nci_fisf( c_func, i0, s1, f2 )
	SV* c_func
	int i0
	short s1
	float f2
PREINIT:
	float(*func)(int, short, float);
CODE:
	func   = INT2PTR(float(*)(int, short, float), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, f2);
OUTPUT:
	RETVAL

float
nci_fist( c_func, i0, s1, t2 )
	SV* c_func
	int i0
	short s1
	char * t2
PREINIT:
	float(*func)(int, short, char *);
CODE:
	func   = INT2PTR(float(*)(int, short, char *), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, t2);
OUTPUT:
	RETVAL

float
nci_fisi( c_func, i0, s1, i2 )
	SV* c_func
	int i0
	short s1
	int i2
PREINIT:
	float(*func)(int, short, int);
CODE:
	func   = INT2PTR(float(*)(int, short, int), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, i2);
OUTPUT:
	RETVAL

float
nci_fifp( c_func, i0, f1, p2 )
	SV* c_func
	int i0
	float f1
	void * p2
PREINIT:
	float(*func)(int, float, void *);
CODE:
	func   = INT2PTR(float(*)(int, float, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, p2);
OUTPUT:
	RETVAL

float
nci_fifd( c_func, i0, f1, d2 )
	SV* c_func
	int i0
	float f1
	double d2
PREINIT:
	float(*func)(int, float, double);
CODE:
	func   = INT2PTR(float(*)(int, float, double), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, d2);
OUTPUT:
	RETVAL

float
nci_fifs( c_func, i0, f1, s2 )
	SV* c_func
	int i0
	float f1
	short s2
PREINIT:
	float(*func)(int, float, short);
CODE:
	func   = INT2PTR(float(*)(int, float, short), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, s2);
OUTPUT:
	RETVAL

float
nci_fiff( c_func, i0, f1, f2 )
	SV* c_func
	int i0
	float f1
	float f2
PREINIT:
	float(*func)(int, float, float);
CODE:
	func   = INT2PTR(float(*)(int, float, float), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, f2);
OUTPUT:
	RETVAL

float
nci_fift( c_func, i0, f1, t2 )
	SV* c_func
	int i0
	float f1
	char * t2
PREINIT:
	float(*func)(int, float, char *);
CODE:
	func   = INT2PTR(float(*)(int, float, char *), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, t2);
OUTPUT:
	RETVAL

float
nci_fifi( c_func, i0, f1, i2 )
	SV* c_func
	int i0
	float f1
	int i2
PREINIT:
	float(*func)(int, float, int);
CODE:
	func   = INT2PTR(float(*)(int, float, int), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, i2);
OUTPUT:
	RETVAL

float
nci_fitp( c_func, i0, t1, p2 )
	SV* c_func
	int i0
	char * t1
	void * p2
PREINIT:
	float(*func)(int, char *, void *);
CODE:
	func   = INT2PTR(float(*)(int, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, p2);
OUTPUT:
	RETVAL

float
nci_fitd( c_func, i0, t1, d2 )
	SV* c_func
	int i0
	char * t1
	double d2
PREINIT:
	float(*func)(int, char *, double);
CODE:
	func   = INT2PTR(float(*)(int, char *, double), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, d2);
OUTPUT:
	RETVAL

float
nci_fits( c_func, i0, t1, s2 )
	SV* c_func
	int i0
	char * t1
	short s2
PREINIT:
	float(*func)(int, char *, short);
CODE:
	func   = INT2PTR(float(*)(int, char *, short), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, s2);
OUTPUT:
	RETVAL

float
nci_fitf( c_func, i0, t1, f2 )
	SV* c_func
	int i0
	char * t1
	float f2
PREINIT:
	float(*func)(int, char *, float);
CODE:
	func   = INT2PTR(float(*)(int, char *, float), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, f2);
OUTPUT:
	RETVAL

float
nci_fitt( c_func, i0, t1, t2 )
	SV* c_func
	int i0
	char * t1
	char * t2
PREINIT:
	float(*func)(int, char *, char *);
CODE:
	func   = INT2PTR(float(*)(int, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, t2);
OUTPUT:
	RETVAL

float
nci_fiti( c_func, i0, t1, i2 )
	SV* c_func
	int i0
	char * t1
	int i2
PREINIT:
	float(*func)(int, char *, int);
CODE:
	func   = INT2PTR(float(*)(int, char *, int), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, i2);
OUTPUT:
	RETVAL

float
nci_fiip( c_func, i0, i1, p2 )
	SV* c_func
	int i0
	int i1
	void * p2
PREINIT:
	float(*func)(int, int, void *);
CODE:
	func   = INT2PTR(float(*)(int, int, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, p2);
OUTPUT:
	RETVAL

float
nci_fiid( c_func, i0, i1, d2 )
	SV* c_func
	int i0
	int i1
	double d2
PREINIT:
	float(*func)(int, int, double);
CODE:
	func   = INT2PTR(float(*)(int, int, double), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, d2);
OUTPUT:
	RETVAL

float
nci_fiis( c_func, i0, i1, s2 )
	SV* c_func
	int i0
	int i1
	short s2
PREINIT:
	float(*func)(int, int, short);
CODE:
	func   = INT2PTR(float(*)(int, int, short), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, s2);
OUTPUT:
	RETVAL

float
nci_fiif( c_func, i0, i1, f2 )
	SV* c_func
	int i0
	int i1
	float f2
PREINIT:
	float(*func)(int, int, float);
CODE:
	func   = INT2PTR(float(*)(int, int, float), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, f2);
OUTPUT:
	RETVAL

float
nci_fiit( c_func, i0, i1, t2 )
	SV* c_func
	int i0
	int i1
	char * t2
PREINIT:
	float(*func)(int, int, char *);
CODE:
	func   = INT2PTR(float(*)(int, int, char *), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, t2);
OUTPUT:
	RETVAL

float
nci_fiii( c_func, i0, i1, i2 )
	SV* c_func
	int i0
	int i1
	int i2
PREINIT:
	float(*func)(int, int, int);
CODE:
	func   = INT2PTR(float(*)(int, int, int), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, i2);
OUTPUT:
	RETVAL

char *
nci_tppp( c_func, p0, p1, p2 )
	SV* c_func
	void * p0
	void * p1
	void * p2
PREINIT:
	char *(*func)(void *, void *, void *);
CODE:
	func   = INT2PTR(char *(*)(void *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, p2);
OUTPUT:
	RETVAL

char *
nci_tppd( c_func, p0, p1, d2 )
	SV* c_func
	void * p0
	void * p1
	double d2
PREINIT:
	char *(*func)(void *, void *, double);
CODE:
	func   = INT2PTR(char *(*)(void *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, d2);
OUTPUT:
	RETVAL

char *
nci_tpps( c_func, p0, p1, s2 )
	SV* c_func
	void * p0
	void * p1
	short s2
PREINIT:
	char *(*func)(void *, void *, short);
CODE:
	func   = INT2PTR(char *(*)(void *, void *, short), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, s2);
OUTPUT:
	RETVAL

char *
nci_tppf( c_func, p0, p1, f2 )
	SV* c_func
	void * p0
	void * p1
	float f2
PREINIT:
	char *(*func)(void *, void *, float);
CODE:
	func   = INT2PTR(char *(*)(void *, void *, float), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, f2);
OUTPUT:
	RETVAL

char *
nci_tppt( c_func, p0, p1, t2 )
	SV* c_func
	void * p0
	void * p1
	char * t2
PREINIT:
	char *(*func)(void *, void *, char *);
CODE:
	func   = INT2PTR(char *(*)(void *, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, t2);
OUTPUT:
	RETVAL

char *
nci_tppi( c_func, p0, p1, i2 )
	SV* c_func
	void * p0
	void * p1
	int i2
PREINIT:
	char *(*func)(void *, void *, int);
CODE:
	func   = INT2PTR(char *(*)(void *, void *, int), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, i2);
OUTPUT:
	RETVAL

char *
nci_tpdp( c_func, p0, d1, p2 )
	SV* c_func
	void * p0
	double d1
	void * p2
PREINIT:
	char *(*func)(void *, double, void *);
CODE:
	func   = INT2PTR(char *(*)(void *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, p2);
OUTPUT:
	RETVAL

char *
nci_tpdd( c_func, p0, d1, d2 )
	SV* c_func
	void * p0
	double d1
	double d2
PREINIT:
	char *(*func)(void *, double, double);
CODE:
	func   = INT2PTR(char *(*)(void *, double, double), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, d2);
OUTPUT:
	RETVAL

char *
nci_tpds( c_func, p0, d1, s2 )
	SV* c_func
	void * p0
	double d1
	short s2
PREINIT:
	char *(*func)(void *, double, short);
CODE:
	func   = INT2PTR(char *(*)(void *, double, short), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, s2);
OUTPUT:
	RETVAL

char *
nci_tpdf( c_func, p0, d1, f2 )
	SV* c_func
	void * p0
	double d1
	float f2
PREINIT:
	char *(*func)(void *, double, float);
CODE:
	func   = INT2PTR(char *(*)(void *, double, float), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, f2);
OUTPUT:
	RETVAL

char *
nci_tpdt( c_func, p0, d1, t2 )
	SV* c_func
	void * p0
	double d1
	char * t2
PREINIT:
	char *(*func)(void *, double, char *);
CODE:
	func   = INT2PTR(char *(*)(void *, double, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, t2);
OUTPUT:
	RETVAL

char *
nci_tpdi( c_func, p0, d1, i2 )
	SV* c_func
	void * p0
	double d1
	int i2
PREINIT:
	char *(*func)(void *, double, int);
CODE:
	func   = INT2PTR(char *(*)(void *, double, int), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, i2);
OUTPUT:
	RETVAL

char *
nci_tpsp( c_func, p0, s1, p2 )
	SV* c_func
	void * p0
	short s1
	void * p2
PREINIT:
	char *(*func)(void *, short, void *);
CODE:
	func   = INT2PTR(char *(*)(void *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, p2);
OUTPUT:
	RETVAL

char *
nci_tpsd( c_func, p0, s1, d2 )
	SV* c_func
	void * p0
	short s1
	double d2
PREINIT:
	char *(*func)(void *, short, double);
CODE:
	func   = INT2PTR(char *(*)(void *, short, double), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, d2);
OUTPUT:
	RETVAL

char *
nci_tpss( c_func, p0, s1, s2 )
	SV* c_func
	void * p0
	short s1
	short s2
PREINIT:
	char *(*func)(void *, short, short);
CODE:
	func   = INT2PTR(char *(*)(void *, short, short), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, s2);
OUTPUT:
	RETVAL

char *
nci_tpsf( c_func, p0, s1, f2 )
	SV* c_func
	void * p0
	short s1
	float f2
PREINIT:
	char *(*func)(void *, short, float);
CODE:
	func   = INT2PTR(char *(*)(void *, short, float), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, f2);
OUTPUT:
	RETVAL

char *
nci_tpst( c_func, p0, s1, t2 )
	SV* c_func
	void * p0
	short s1
	char * t2
PREINIT:
	char *(*func)(void *, short, char *);
CODE:
	func   = INT2PTR(char *(*)(void *, short, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, t2);
OUTPUT:
	RETVAL

char *
nci_tpsi( c_func, p0, s1, i2 )
	SV* c_func
	void * p0
	short s1
	int i2
PREINIT:
	char *(*func)(void *, short, int);
CODE:
	func   = INT2PTR(char *(*)(void *, short, int), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, i2);
OUTPUT:
	RETVAL

char *
nci_tpfp( c_func, p0, f1, p2 )
	SV* c_func
	void * p0
	float f1
	void * p2
PREINIT:
	char *(*func)(void *, float, void *);
CODE:
	func   = INT2PTR(char *(*)(void *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, p2);
OUTPUT:
	RETVAL

char *
nci_tpfd( c_func, p0, f1, d2 )
	SV* c_func
	void * p0
	float f1
	double d2
PREINIT:
	char *(*func)(void *, float, double);
CODE:
	func   = INT2PTR(char *(*)(void *, float, double), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, d2);
OUTPUT:
	RETVAL

char *
nci_tpfs( c_func, p0, f1, s2 )
	SV* c_func
	void * p0
	float f1
	short s2
PREINIT:
	char *(*func)(void *, float, short);
CODE:
	func   = INT2PTR(char *(*)(void *, float, short), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, s2);
OUTPUT:
	RETVAL

char *
nci_tpff( c_func, p0, f1, f2 )
	SV* c_func
	void * p0
	float f1
	float f2
PREINIT:
	char *(*func)(void *, float, float);
CODE:
	func   = INT2PTR(char *(*)(void *, float, float), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, f2);
OUTPUT:
	RETVAL

char *
nci_tpft( c_func, p0, f1, t2 )
	SV* c_func
	void * p0
	float f1
	char * t2
PREINIT:
	char *(*func)(void *, float, char *);
CODE:
	func   = INT2PTR(char *(*)(void *, float, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, t2);
OUTPUT:
	RETVAL

char *
nci_tpfi( c_func, p0, f1, i2 )
	SV* c_func
	void * p0
	float f1
	int i2
PREINIT:
	char *(*func)(void *, float, int);
CODE:
	func   = INT2PTR(char *(*)(void *, float, int), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, i2);
OUTPUT:
	RETVAL

char *
nci_tptp( c_func, p0, t1, p2 )
	SV* c_func
	void * p0
	char * t1
	void * p2
PREINIT:
	char *(*func)(void *, char *, void *);
CODE:
	func   = INT2PTR(char *(*)(void *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, p2);
OUTPUT:
	RETVAL

char *
nci_tptd( c_func, p0, t1, d2 )
	SV* c_func
	void * p0
	char * t1
	double d2
PREINIT:
	char *(*func)(void *, char *, double);
CODE:
	func   = INT2PTR(char *(*)(void *, char *, double), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, d2);
OUTPUT:
	RETVAL

char *
nci_tpts( c_func, p0, t1, s2 )
	SV* c_func
	void * p0
	char * t1
	short s2
PREINIT:
	char *(*func)(void *, char *, short);
CODE:
	func   = INT2PTR(char *(*)(void *, char *, short), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, s2);
OUTPUT:
	RETVAL

char *
nci_tptf( c_func, p0, t1, f2 )
	SV* c_func
	void * p0
	char * t1
	float f2
PREINIT:
	char *(*func)(void *, char *, float);
CODE:
	func   = INT2PTR(char *(*)(void *, char *, float), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, f2);
OUTPUT:
	RETVAL

char *
nci_tptt( c_func, p0, t1, t2 )
	SV* c_func
	void * p0
	char * t1
	char * t2
PREINIT:
	char *(*func)(void *, char *, char *);
CODE:
	func   = INT2PTR(char *(*)(void *, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, t2);
OUTPUT:
	RETVAL

char *
nci_tpti( c_func, p0, t1, i2 )
	SV* c_func
	void * p0
	char * t1
	int i2
PREINIT:
	char *(*func)(void *, char *, int);
CODE:
	func   = INT2PTR(char *(*)(void *, char *, int), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, i2);
OUTPUT:
	RETVAL

char *
nci_tpip( c_func, p0, i1, p2 )
	SV* c_func
	void * p0
	int i1
	void * p2
PREINIT:
	char *(*func)(void *, int, void *);
CODE:
	func   = INT2PTR(char *(*)(void *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, p2);
OUTPUT:
	RETVAL

char *
nci_tpid( c_func, p0, i1, d2 )
	SV* c_func
	void * p0
	int i1
	double d2
PREINIT:
	char *(*func)(void *, int, double);
CODE:
	func   = INT2PTR(char *(*)(void *, int, double), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, d2);
OUTPUT:
	RETVAL

char *
nci_tpis( c_func, p0, i1, s2 )
	SV* c_func
	void * p0
	int i1
	short s2
PREINIT:
	char *(*func)(void *, int, short);
CODE:
	func   = INT2PTR(char *(*)(void *, int, short), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, s2);
OUTPUT:
	RETVAL

char *
nci_tpif( c_func, p0, i1, f2 )
	SV* c_func
	void * p0
	int i1
	float f2
PREINIT:
	char *(*func)(void *, int, float);
CODE:
	func   = INT2PTR(char *(*)(void *, int, float), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, f2);
OUTPUT:
	RETVAL

char *
nci_tpit( c_func, p0, i1, t2 )
	SV* c_func
	void * p0
	int i1
	char * t2
PREINIT:
	char *(*func)(void *, int, char *);
CODE:
	func   = INT2PTR(char *(*)(void *, int, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, t2);
OUTPUT:
	RETVAL

char *
nci_tpii( c_func, p0, i1, i2 )
	SV* c_func
	void * p0
	int i1
	int i2
PREINIT:
	char *(*func)(void *, int, int);
CODE:
	func   = INT2PTR(char *(*)(void *, int, int), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, i2);
OUTPUT:
	RETVAL

char *
nci_tdpp( c_func, d0, p1, p2 )
	SV* c_func
	double d0
	void * p1
	void * p2
PREINIT:
	char *(*func)(double, void *, void *);
CODE:
	func   = INT2PTR(char *(*)(double, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, p2);
OUTPUT:
	RETVAL

char *
nci_tdpd( c_func, d0, p1, d2 )
	SV* c_func
	double d0
	void * p1
	double d2
PREINIT:
	char *(*func)(double, void *, double);
CODE:
	func   = INT2PTR(char *(*)(double, void *, double), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, d2);
OUTPUT:
	RETVAL

char *
nci_tdps( c_func, d0, p1, s2 )
	SV* c_func
	double d0
	void * p1
	short s2
PREINIT:
	char *(*func)(double, void *, short);
CODE:
	func   = INT2PTR(char *(*)(double, void *, short), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, s2);
OUTPUT:
	RETVAL

char *
nci_tdpf( c_func, d0, p1, f2 )
	SV* c_func
	double d0
	void * p1
	float f2
PREINIT:
	char *(*func)(double, void *, float);
CODE:
	func   = INT2PTR(char *(*)(double, void *, float), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, f2);
OUTPUT:
	RETVAL

char *
nci_tdpt( c_func, d0, p1, t2 )
	SV* c_func
	double d0
	void * p1
	char * t2
PREINIT:
	char *(*func)(double, void *, char *);
CODE:
	func   = INT2PTR(char *(*)(double, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, t2);
OUTPUT:
	RETVAL

char *
nci_tdpi( c_func, d0, p1, i2 )
	SV* c_func
	double d0
	void * p1
	int i2
PREINIT:
	char *(*func)(double, void *, int);
CODE:
	func   = INT2PTR(char *(*)(double, void *, int), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, i2);
OUTPUT:
	RETVAL

char *
nci_tddp( c_func, d0, d1, p2 )
	SV* c_func
	double d0
	double d1
	void * p2
PREINIT:
	char *(*func)(double, double, void *);
CODE:
	func   = INT2PTR(char *(*)(double, double, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, p2);
OUTPUT:
	RETVAL

char *
nci_tddd( c_func, d0, d1, d2 )
	SV* c_func
	double d0
	double d1
	double d2
PREINIT:
	char *(*func)(double, double, double);
CODE:
	func   = INT2PTR(char *(*)(double, double, double), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, d2);
OUTPUT:
	RETVAL

char *
nci_tdds( c_func, d0, d1, s2 )
	SV* c_func
	double d0
	double d1
	short s2
PREINIT:
	char *(*func)(double, double, short);
CODE:
	func   = INT2PTR(char *(*)(double, double, short), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, s2);
OUTPUT:
	RETVAL

char *
nci_tddf( c_func, d0, d1, f2 )
	SV* c_func
	double d0
	double d1
	float f2
PREINIT:
	char *(*func)(double, double, float);
CODE:
	func   = INT2PTR(char *(*)(double, double, float), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, f2);
OUTPUT:
	RETVAL

char *
nci_tddt( c_func, d0, d1, t2 )
	SV* c_func
	double d0
	double d1
	char * t2
PREINIT:
	char *(*func)(double, double, char *);
CODE:
	func   = INT2PTR(char *(*)(double, double, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, t2);
OUTPUT:
	RETVAL

char *
nci_tddi( c_func, d0, d1, i2 )
	SV* c_func
	double d0
	double d1
	int i2
PREINIT:
	char *(*func)(double, double, int);
CODE:
	func   = INT2PTR(char *(*)(double, double, int), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, i2);
OUTPUT:
	RETVAL

char *
nci_tdsp( c_func, d0, s1, p2 )
	SV* c_func
	double d0
	short s1
	void * p2
PREINIT:
	char *(*func)(double, short, void *);
CODE:
	func   = INT2PTR(char *(*)(double, short, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, p2);
OUTPUT:
	RETVAL

char *
nci_tdsd( c_func, d0, s1, d2 )
	SV* c_func
	double d0
	short s1
	double d2
PREINIT:
	char *(*func)(double, short, double);
CODE:
	func   = INT2PTR(char *(*)(double, short, double), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, d2);
OUTPUT:
	RETVAL

char *
nci_tdss( c_func, d0, s1, s2 )
	SV* c_func
	double d0
	short s1
	short s2
PREINIT:
	char *(*func)(double, short, short);
CODE:
	func   = INT2PTR(char *(*)(double, short, short), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, s2);
OUTPUT:
	RETVAL

char *
nci_tdsf( c_func, d0, s1, f2 )
	SV* c_func
	double d0
	short s1
	float f2
PREINIT:
	char *(*func)(double, short, float);
CODE:
	func   = INT2PTR(char *(*)(double, short, float), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, f2);
OUTPUT:
	RETVAL

char *
nci_tdst( c_func, d0, s1, t2 )
	SV* c_func
	double d0
	short s1
	char * t2
PREINIT:
	char *(*func)(double, short, char *);
CODE:
	func   = INT2PTR(char *(*)(double, short, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, t2);
OUTPUT:
	RETVAL

char *
nci_tdsi( c_func, d0, s1, i2 )
	SV* c_func
	double d0
	short s1
	int i2
PREINIT:
	char *(*func)(double, short, int);
CODE:
	func   = INT2PTR(char *(*)(double, short, int), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, i2);
OUTPUT:
	RETVAL

char *
nci_tdfp( c_func, d0, f1, p2 )
	SV* c_func
	double d0
	float f1
	void * p2
PREINIT:
	char *(*func)(double, float, void *);
CODE:
	func   = INT2PTR(char *(*)(double, float, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, p2);
OUTPUT:
	RETVAL

char *
nci_tdfd( c_func, d0, f1, d2 )
	SV* c_func
	double d0
	float f1
	double d2
PREINIT:
	char *(*func)(double, float, double);
CODE:
	func   = INT2PTR(char *(*)(double, float, double), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, d2);
OUTPUT:
	RETVAL

char *
nci_tdfs( c_func, d0, f1, s2 )
	SV* c_func
	double d0
	float f1
	short s2
PREINIT:
	char *(*func)(double, float, short);
CODE:
	func   = INT2PTR(char *(*)(double, float, short), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, s2);
OUTPUT:
	RETVAL

char *
nci_tdff( c_func, d0, f1, f2 )
	SV* c_func
	double d0
	float f1
	float f2
PREINIT:
	char *(*func)(double, float, float);
CODE:
	func   = INT2PTR(char *(*)(double, float, float), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, f2);
OUTPUT:
	RETVAL

char *
nci_tdft( c_func, d0, f1, t2 )
	SV* c_func
	double d0
	float f1
	char * t2
PREINIT:
	char *(*func)(double, float, char *);
CODE:
	func   = INT2PTR(char *(*)(double, float, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, t2);
OUTPUT:
	RETVAL

char *
nci_tdfi( c_func, d0, f1, i2 )
	SV* c_func
	double d0
	float f1
	int i2
PREINIT:
	char *(*func)(double, float, int);
CODE:
	func   = INT2PTR(char *(*)(double, float, int), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, i2);
OUTPUT:
	RETVAL

char *
nci_tdtp( c_func, d0, t1, p2 )
	SV* c_func
	double d0
	char * t1
	void * p2
PREINIT:
	char *(*func)(double, char *, void *);
CODE:
	func   = INT2PTR(char *(*)(double, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, p2);
OUTPUT:
	RETVAL

char *
nci_tdtd( c_func, d0, t1, d2 )
	SV* c_func
	double d0
	char * t1
	double d2
PREINIT:
	char *(*func)(double, char *, double);
CODE:
	func   = INT2PTR(char *(*)(double, char *, double), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, d2);
OUTPUT:
	RETVAL

char *
nci_tdts( c_func, d0, t1, s2 )
	SV* c_func
	double d0
	char * t1
	short s2
PREINIT:
	char *(*func)(double, char *, short);
CODE:
	func   = INT2PTR(char *(*)(double, char *, short), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, s2);
OUTPUT:
	RETVAL

char *
nci_tdtf( c_func, d0, t1, f2 )
	SV* c_func
	double d0
	char * t1
	float f2
PREINIT:
	char *(*func)(double, char *, float);
CODE:
	func   = INT2PTR(char *(*)(double, char *, float), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, f2);
OUTPUT:
	RETVAL

char *
nci_tdtt( c_func, d0, t1, t2 )
	SV* c_func
	double d0
	char * t1
	char * t2
PREINIT:
	char *(*func)(double, char *, char *);
CODE:
	func   = INT2PTR(char *(*)(double, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, t2);
OUTPUT:
	RETVAL

char *
nci_tdti( c_func, d0, t1, i2 )
	SV* c_func
	double d0
	char * t1
	int i2
PREINIT:
	char *(*func)(double, char *, int);
CODE:
	func   = INT2PTR(char *(*)(double, char *, int), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, i2);
OUTPUT:
	RETVAL

char *
nci_tdip( c_func, d0, i1, p2 )
	SV* c_func
	double d0
	int i1
	void * p2
PREINIT:
	char *(*func)(double, int, void *);
CODE:
	func   = INT2PTR(char *(*)(double, int, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, p2);
OUTPUT:
	RETVAL

char *
nci_tdid( c_func, d0, i1, d2 )
	SV* c_func
	double d0
	int i1
	double d2
PREINIT:
	char *(*func)(double, int, double);
CODE:
	func   = INT2PTR(char *(*)(double, int, double), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, d2);
OUTPUT:
	RETVAL

char *
nci_tdis( c_func, d0, i1, s2 )
	SV* c_func
	double d0
	int i1
	short s2
PREINIT:
	char *(*func)(double, int, short);
CODE:
	func   = INT2PTR(char *(*)(double, int, short), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, s2);
OUTPUT:
	RETVAL

char *
nci_tdif( c_func, d0, i1, f2 )
	SV* c_func
	double d0
	int i1
	float f2
PREINIT:
	char *(*func)(double, int, float);
CODE:
	func   = INT2PTR(char *(*)(double, int, float), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, f2);
OUTPUT:
	RETVAL

char *
nci_tdit( c_func, d0, i1, t2 )
	SV* c_func
	double d0
	int i1
	char * t2
PREINIT:
	char *(*func)(double, int, char *);
CODE:
	func   = INT2PTR(char *(*)(double, int, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, t2);
OUTPUT:
	RETVAL

char *
nci_tdii( c_func, d0, i1, i2 )
	SV* c_func
	double d0
	int i1
	int i2
PREINIT:
	char *(*func)(double, int, int);
CODE:
	func   = INT2PTR(char *(*)(double, int, int), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, i2);
OUTPUT:
	RETVAL

char *
nci_tspp( c_func, s0, p1, p2 )
	SV* c_func
	short s0
	void * p1
	void * p2
PREINIT:
	char *(*func)(short, void *, void *);
CODE:
	func   = INT2PTR(char *(*)(short, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, p2);
OUTPUT:
	RETVAL

char *
nci_tspd( c_func, s0, p1, d2 )
	SV* c_func
	short s0
	void * p1
	double d2
PREINIT:
	char *(*func)(short, void *, double);
CODE:
	func   = INT2PTR(char *(*)(short, void *, double), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, d2);
OUTPUT:
	RETVAL

char *
nci_tsps( c_func, s0, p1, s2 )
	SV* c_func
	short s0
	void * p1
	short s2
PREINIT:
	char *(*func)(short, void *, short);
CODE:
	func   = INT2PTR(char *(*)(short, void *, short), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, s2);
OUTPUT:
	RETVAL

char *
nci_tspf( c_func, s0, p1, f2 )
	SV* c_func
	short s0
	void * p1
	float f2
PREINIT:
	char *(*func)(short, void *, float);
CODE:
	func   = INT2PTR(char *(*)(short, void *, float), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, f2);
OUTPUT:
	RETVAL

char *
nci_tspt( c_func, s0, p1, t2 )
	SV* c_func
	short s0
	void * p1
	char * t2
PREINIT:
	char *(*func)(short, void *, char *);
CODE:
	func   = INT2PTR(char *(*)(short, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, t2);
OUTPUT:
	RETVAL

char *
nci_tspi( c_func, s0, p1, i2 )
	SV* c_func
	short s0
	void * p1
	int i2
PREINIT:
	char *(*func)(short, void *, int);
CODE:
	func   = INT2PTR(char *(*)(short, void *, int), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, i2);
OUTPUT:
	RETVAL

char *
nci_tsdp( c_func, s0, d1, p2 )
	SV* c_func
	short s0
	double d1
	void * p2
PREINIT:
	char *(*func)(short, double, void *);
CODE:
	func   = INT2PTR(char *(*)(short, double, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, p2);
OUTPUT:
	RETVAL

char *
nci_tsdd( c_func, s0, d1, d2 )
	SV* c_func
	short s0
	double d1
	double d2
PREINIT:
	char *(*func)(short, double, double);
CODE:
	func   = INT2PTR(char *(*)(short, double, double), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, d2);
OUTPUT:
	RETVAL

char *
nci_tsds( c_func, s0, d1, s2 )
	SV* c_func
	short s0
	double d1
	short s2
PREINIT:
	char *(*func)(short, double, short);
CODE:
	func   = INT2PTR(char *(*)(short, double, short), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, s2);
OUTPUT:
	RETVAL

char *
nci_tsdf( c_func, s0, d1, f2 )
	SV* c_func
	short s0
	double d1
	float f2
PREINIT:
	char *(*func)(short, double, float);
CODE:
	func   = INT2PTR(char *(*)(short, double, float), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, f2);
OUTPUT:
	RETVAL

char *
nci_tsdt( c_func, s0, d1, t2 )
	SV* c_func
	short s0
	double d1
	char * t2
PREINIT:
	char *(*func)(short, double, char *);
CODE:
	func   = INT2PTR(char *(*)(short, double, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, t2);
OUTPUT:
	RETVAL

char *
nci_tsdi( c_func, s0, d1, i2 )
	SV* c_func
	short s0
	double d1
	int i2
PREINIT:
	char *(*func)(short, double, int);
CODE:
	func   = INT2PTR(char *(*)(short, double, int), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, i2);
OUTPUT:
	RETVAL

char *
nci_tssp( c_func, s0, s1, p2 )
	SV* c_func
	short s0
	short s1
	void * p2
PREINIT:
	char *(*func)(short, short, void *);
CODE:
	func   = INT2PTR(char *(*)(short, short, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, p2);
OUTPUT:
	RETVAL

char *
nci_tssd( c_func, s0, s1, d2 )
	SV* c_func
	short s0
	short s1
	double d2
PREINIT:
	char *(*func)(short, short, double);
CODE:
	func   = INT2PTR(char *(*)(short, short, double), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, d2);
OUTPUT:
	RETVAL

char *
nci_tsss( c_func, s0, s1, s2 )
	SV* c_func
	short s0
	short s1
	short s2
PREINIT:
	char *(*func)(short, short, short);
CODE:
	func   = INT2PTR(char *(*)(short, short, short), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, s2);
OUTPUT:
	RETVAL

char *
nci_tssf( c_func, s0, s1, f2 )
	SV* c_func
	short s0
	short s1
	float f2
PREINIT:
	char *(*func)(short, short, float);
CODE:
	func   = INT2PTR(char *(*)(short, short, float), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, f2);
OUTPUT:
	RETVAL

char *
nci_tsst( c_func, s0, s1, t2 )
	SV* c_func
	short s0
	short s1
	char * t2
PREINIT:
	char *(*func)(short, short, char *);
CODE:
	func   = INT2PTR(char *(*)(short, short, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, t2);
OUTPUT:
	RETVAL

char *
nci_tssi( c_func, s0, s1, i2 )
	SV* c_func
	short s0
	short s1
	int i2
PREINIT:
	char *(*func)(short, short, int);
CODE:
	func   = INT2PTR(char *(*)(short, short, int), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, i2);
OUTPUT:
	RETVAL

char *
nci_tsfp( c_func, s0, f1, p2 )
	SV* c_func
	short s0
	float f1
	void * p2
PREINIT:
	char *(*func)(short, float, void *);
CODE:
	func   = INT2PTR(char *(*)(short, float, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, p2);
OUTPUT:
	RETVAL

char *
nci_tsfd( c_func, s0, f1, d2 )
	SV* c_func
	short s0
	float f1
	double d2
PREINIT:
	char *(*func)(short, float, double);
CODE:
	func   = INT2PTR(char *(*)(short, float, double), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, d2);
OUTPUT:
	RETVAL

char *
nci_tsfs( c_func, s0, f1, s2 )
	SV* c_func
	short s0
	float f1
	short s2
PREINIT:
	char *(*func)(short, float, short);
CODE:
	func   = INT2PTR(char *(*)(short, float, short), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, s2);
OUTPUT:
	RETVAL

char *
nci_tsff( c_func, s0, f1, f2 )
	SV* c_func
	short s0
	float f1
	float f2
PREINIT:
	char *(*func)(short, float, float);
CODE:
	func   = INT2PTR(char *(*)(short, float, float), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, f2);
OUTPUT:
	RETVAL

char *
nci_tsft( c_func, s0, f1, t2 )
	SV* c_func
	short s0
	float f1
	char * t2
PREINIT:
	char *(*func)(short, float, char *);
CODE:
	func   = INT2PTR(char *(*)(short, float, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, t2);
OUTPUT:
	RETVAL

char *
nci_tsfi( c_func, s0, f1, i2 )
	SV* c_func
	short s0
	float f1
	int i2
PREINIT:
	char *(*func)(short, float, int);
CODE:
	func   = INT2PTR(char *(*)(short, float, int), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, i2);
OUTPUT:
	RETVAL

char *
nci_tstp( c_func, s0, t1, p2 )
	SV* c_func
	short s0
	char * t1
	void * p2
PREINIT:
	char *(*func)(short, char *, void *);
CODE:
	func   = INT2PTR(char *(*)(short, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, p2);
OUTPUT:
	RETVAL

char *
nci_tstd( c_func, s0, t1, d2 )
	SV* c_func
	short s0
	char * t1
	double d2
PREINIT:
	char *(*func)(short, char *, double);
CODE:
	func   = INT2PTR(char *(*)(short, char *, double), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, d2);
OUTPUT:
	RETVAL

char *
nci_tsts( c_func, s0, t1, s2 )
	SV* c_func
	short s0
	char * t1
	short s2
PREINIT:
	char *(*func)(short, char *, short);
CODE:
	func   = INT2PTR(char *(*)(short, char *, short), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, s2);
OUTPUT:
	RETVAL

char *
nci_tstf( c_func, s0, t1, f2 )
	SV* c_func
	short s0
	char * t1
	float f2
PREINIT:
	char *(*func)(short, char *, float);
CODE:
	func   = INT2PTR(char *(*)(short, char *, float), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, f2);
OUTPUT:
	RETVAL

char *
nci_tstt( c_func, s0, t1, t2 )
	SV* c_func
	short s0
	char * t1
	char * t2
PREINIT:
	char *(*func)(short, char *, char *);
CODE:
	func   = INT2PTR(char *(*)(short, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, t2);
OUTPUT:
	RETVAL

char *
nci_tsti( c_func, s0, t1, i2 )
	SV* c_func
	short s0
	char * t1
	int i2
PREINIT:
	char *(*func)(short, char *, int);
CODE:
	func   = INT2PTR(char *(*)(short, char *, int), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, i2);
OUTPUT:
	RETVAL

char *
nci_tsip( c_func, s0, i1, p2 )
	SV* c_func
	short s0
	int i1
	void * p2
PREINIT:
	char *(*func)(short, int, void *);
CODE:
	func   = INT2PTR(char *(*)(short, int, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, p2);
OUTPUT:
	RETVAL

char *
nci_tsid( c_func, s0, i1, d2 )
	SV* c_func
	short s0
	int i1
	double d2
PREINIT:
	char *(*func)(short, int, double);
CODE:
	func   = INT2PTR(char *(*)(short, int, double), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, d2);
OUTPUT:
	RETVAL

char *
nci_tsis( c_func, s0, i1, s2 )
	SV* c_func
	short s0
	int i1
	short s2
PREINIT:
	char *(*func)(short, int, short);
CODE:
	func   = INT2PTR(char *(*)(short, int, short), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, s2);
OUTPUT:
	RETVAL

char *
nci_tsif( c_func, s0, i1, f2 )
	SV* c_func
	short s0
	int i1
	float f2
PREINIT:
	char *(*func)(short, int, float);
CODE:
	func   = INT2PTR(char *(*)(short, int, float), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, f2);
OUTPUT:
	RETVAL

char *
nci_tsit( c_func, s0, i1, t2 )
	SV* c_func
	short s0
	int i1
	char * t2
PREINIT:
	char *(*func)(short, int, char *);
CODE:
	func   = INT2PTR(char *(*)(short, int, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, t2);
OUTPUT:
	RETVAL

char *
nci_tsii( c_func, s0, i1, i2 )
	SV* c_func
	short s0
	int i1
	int i2
PREINIT:
	char *(*func)(short, int, int);
CODE:
	func   = INT2PTR(char *(*)(short, int, int), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, i2);
OUTPUT:
	RETVAL

char *
nci_tfpp( c_func, f0, p1, p2 )
	SV* c_func
	float f0
	void * p1
	void * p2
PREINIT:
	char *(*func)(float, void *, void *);
CODE:
	func   = INT2PTR(char *(*)(float, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, p2);
OUTPUT:
	RETVAL

char *
nci_tfpd( c_func, f0, p1, d2 )
	SV* c_func
	float f0
	void * p1
	double d2
PREINIT:
	char *(*func)(float, void *, double);
CODE:
	func   = INT2PTR(char *(*)(float, void *, double), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, d2);
OUTPUT:
	RETVAL

char *
nci_tfps( c_func, f0, p1, s2 )
	SV* c_func
	float f0
	void * p1
	short s2
PREINIT:
	char *(*func)(float, void *, short);
CODE:
	func   = INT2PTR(char *(*)(float, void *, short), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, s2);
OUTPUT:
	RETVAL

char *
nci_tfpf( c_func, f0, p1, f2 )
	SV* c_func
	float f0
	void * p1
	float f2
PREINIT:
	char *(*func)(float, void *, float);
CODE:
	func   = INT2PTR(char *(*)(float, void *, float), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, f2);
OUTPUT:
	RETVAL

char *
nci_tfpt( c_func, f0, p1, t2 )
	SV* c_func
	float f0
	void * p1
	char * t2
PREINIT:
	char *(*func)(float, void *, char *);
CODE:
	func   = INT2PTR(char *(*)(float, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, t2);
OUTPUT:
	RETVAL

char *
nci_tfpi( c_func, f0, p1, i2 )
	SV* c_func
	float f0
	void * p1
	int i2
PREINIT:
	char *(*func)(float, void *, int);
CODE:
	func   = INT2PTR(char *(*)(float, void *, int), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, i2);
OUTPUT:
	RETVAL

char *
nci_tfdp( c_func, f0, d1, p2 )
	SV* c_func
	float f0
	double d1
	void * p2
PREINIT:
	char *(*func)(float, double, void *);
CODE:
	func   = INT2PTR(char *(*)(float, double, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, p2);
OUTPUT:
	RETVAL

char *
nci_tfdd( c_func, f0, d1, d2 )
	SV* c_func
	float f0
	double d1
	double d2
PREINIT:
	char *(*func)(float, double, double);
CODE:
	func   = INT2PTR(char *(*)(float, double, double), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, d2);
OUTPUT:
	RETVAL

char *
nci_tfds( c_func, f0, d1, s2 )
	SV* c_func
	float f0
	double d1
	short s2
PREINIT:
	char *(*func)(float, double, short);
CODE:
	func   = INT2PTR(char *(*)(float, double, short), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, s2);
OUTPUT:
	RETVAL

char *
nci_tfdf( c_func, f0, d1, f2 )
	SV* c_func
	float f0
	double d1
	float f2
PREINIT:
	char *(*func)(float, double, float);
CODE:
	func   = INT2PTR(char *(*)(float, double, float), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, f2);
OUTPUT:
	RETVAL

char *
nci_tfdt( c_func, f0, d1, t2 )
	SV* c_func
	float f0
	double d1
	char * t2
PREINIT:
	char *(*func)(float, double, char *);
CODE:
	func   = INT2PTR(char *(*)(float, double, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, t2);
OUTPUT:
	RETVAL

char *
nci_tfdi( c_func, f0, d1, i2 )
	SV* c_func
	float f0
	double d1
	int i2
PREINIT:
	char *(*func)(float, double, int);
CODE:
	func   = INT2PTR(char *(*)(float, double, int), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, i2);
OUTPUT:
	RETVAL

char *
nci_tfsp( c_func, f0, s1, p2 )
	SV* c_func
	float f0
	short s1
	void * p2
PREINIT:
	char *(*func)(float, short, void *);
CODE:
	func   = INT2PTR(char *(*)(float, short, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, p2);
OUTPUT:
	RETVAL

char *
nci_tfsd( c_func, f0, s1, d2 )
	SV* c_func
	float f0
	short s1
	double d2
PREINIT:
	char *(*func)(float, short, double);
CODE:
	func   = INT2PTR(char *(*)(float, short, double), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, d2);
OUTPUT:
	RETVAL

char *
nci_tfss( c_func, f0, s1, s2 )
	SV* c_func
	float f0
	short s1
	short s2
PREINIT:
	char *(*func)(float, short, short);
CODE:
	func   = INT2PTR(char *(*)(float, short, short), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, s2);
OUTPUT:
	RETVAL

char *
nci_tfsf( c_func, f0, s1, f2 )
	SV* c_func
	float f0
	short s1
	float f2
PREINIT:
	char *(*func)(float, short, float);
CODE:
	func   = INT2PTR(char *(*)(float, short, float), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, f2);
OUTPUT:
	RETVAL

char *
nci_tfst( c_func, f0, s1, t2 )
	SV* c_func
	float f0
	short s1
	char * t2
PREINIT:
	char *(*func)(float, short, char *);
CODE:
	func   = INT2PTR(char *(*)(float, short, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, t2);
OUTPUT:
	RETVAL

char *
nci_tfsi( c_func, f0, s1, i2 )
	SV* c_func
	float f0
	short s1
	int i2
PREINIT:
	char *(*func)(float, short, int);
CODE:
	func   = INT2PTR(char *(*)(float, short, int), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, i2);
OUTPUT:
	RETVAL

char *
nci_tffp( c_func, f0, f1, p2 )
	SV* c_func
	float f0
	float f1
	void * p2
PREINIT:
	char *(*func)(float, float, void *);
CODE:
	func   = INT2PTR(char *(*)(float, float, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, p2);
OUTPUT:
	RETVAL

char *
nci_tffd( c_func, f0, f1, d2 )
	SV* c_func
	float f0
	float f1
	double d2
PREINIT:
	char *(*func)(float, float, double);
CODE:
	func   = INT2PTR(char *(*)(float, float, double), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, d2);
OUTPUT:
	RETVAL

char *
nci_tffs( c_func, f0, f1, s2 )
	SV* c_func
	float f0
	float f1
	short s2
PREINIT:
	char *(*func)(float, float, short);
CODE:
	func   = INT2PTR(char *(*)(float, float, short), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, s2);
OUTPUT:
	RETVAL

char *
nci_tfff( c_func, f0, f1, f2 )
	SV* c_func
	float f0
	float f1
	float f2
PREINIT:
	char *(*func)(float, float, float);
CODE:
	func   = INT2PTR(char *(*)(float, float, float), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, f2);
OUTPUT:
	RETVAL

char *
nci_tfft( c_func, f0, f1, t2 )
	SV* c_func
	float f0
	float f1
	char * t2
PREINIT:
	char *(*func)(float, float, char *);
CODE:
	func   = INT2PTR(char *(*)(float, float, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, t2);
OUTPUT:
	RETVAL

char *
nci_tffi( c_func, f0, f1, i2 )
	SV* c_func
	float f0
	float f1
	int i2
PREINIT:
	char *(*func)(float, float, int);
CODE:
	func   = INT2PTR(char *(*)(float, float, int), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, i2);
OUTPUT:
	RETVAL

char *
nci_tftp( c_func, f0, t1, p2 )
	SV* c_func
	float f0
	char * t1
	void * p2
PREINIT:
	char *(*func)(float, char *, void *);
CODE:
	func   = INT2PTR(char *(*)(float, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, p2);
OUTPUT:
	RETVAL

char *
nci_tftd( c_func, f0, t1, d2 )
	SV* c_func
	float f0
	char * t1
	double d2
PREINIT:
	char *(*func)(float, char *, double);
CODE:
	func   = INT2PTR(char *(*)(float, char *, double), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, d2);
OUTPUT:
	RETVAL

char *
nci_tfts( c_func, f0, t1, s2 )
	SV* c_func
	float f0
	char * t1
	short s2
PREINIT:
	char *(*func)(float, char *, short);
CODE:
	func   = INT2PTR(char *(*)(float, char *, short), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, s2);
OUTPUT:
	RETVAL

char *
nci_tftf( c_func, f0, t1, f2 )
	SV* c_func
	float f0
	char * t1
	float f2
PREINIT:
	char *(*func)(float, char *, float);
CODE:
	func   = INT2PTR(char *(*)(float, char *, float), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, f2);
OUTPUT:
	RETVAL

char *
nci_tftt( c_func, f0, t1, t2 )
	SV* c_func
	float f0
	char * t1
	char * t2
PREINIT:
	char *(*func)(float, char *, char *);
CODE:
	func   = INT2PTR(char *(*)(float, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, t2);
OUTPUT:
	RETVAL

char *
nci_tfti( c_func, f0, t1, i2 )
	SV* c_func
	float f0
	char * t1
	int i2
PREINIT:
	char *(*func)(float, char *, int);
CODE:
	func   = INT2PTR(char *(*)(float, char *, int), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, i2);
OUTPUT:
	RETVAL

char *
nci_tfip( c_func, f0, i1, p2 )
	SV* c_func
	float f0
	int i1
	void * p2
PREINIT:
	char *(*func)(float, int, void *);
CODE:
	func   = INT2PTR(char *(*)(float, int, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, p2);
OUTPUT:
	RETVAL

char *
nci_tfid( c_func, f0, i1, d2 )
	SV* c_func
	float f0
	int i1
	double d2
PREINIT:
	char *(*func)(float, int, double);
CODE:
	func   = INT2PTR(char *(*)(float, int, double), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, d2);
OUTPUT:
	RETVAL

char *
nci_tfis( c_func, f0, i1, s2 )
	SV* c_func
	float f0
	int i1
	short s2
PREINIT:
	char *(*func)(float, int, short);
CODE:
	func   = INT2PTR(char *(*)(float, int, short), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, s2);
OUTPUT:
	RETVAL

char *
nci_tfif( c_func, f0, i1, f2 )
	SV* c_func
	float f0
	int i1
	float f2
PREINIT:
	char *(*func)(float, int, float);
CODE:
	func   = INT2PTR(char *(*)(float, int, float), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, f2);
OUTPUT:
	RETVAL

char *
nci_tfit( c_func, f0, i1, t2 )
	SV* c_func
	float f0
	int i1
	char * t2
PREINIT:
	char *(*func)(float, int, char *);
CODE:
	func   = INT2PTR(char *(*)(float, int, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, t2);
OUTPUT:
	RETVAL

char *
nci_tfii( c_func, f0, i1, i2 )
	SV* c_func
	float f0
	int i1
	int i2
PREINIT:
	char *(*func)(float, int, int);
CODE:
	func   = INT2PTR(char *(*)(float, int, int), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, i2);
OUTPUT:
	RETVAL

char *
nci_ttpp( c_func, t0, p1, p2 )
	SV* c_func
	char * t0
	void * p1
	void * p2
PREINIT:
	char *(*func)(char *, void *, void *);
CODE:
	func   = INT2PTR(char *(*)(char *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, p2);
OUTPUT:
	RETVAL

char *
nci_ttpd( c_func, t0, p1, d2 )
	SV* c_func
	char * t0
	void * p1
	double d2
PREINIT:
	char *(*func)(char *, void *, double);
CODE:
	func   = INT2PTR(char *(*)(char *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, d2);
OUTPUT:
	RETVAL

char *
nci_ttps( c_func, t0, p1, s2 )
	SV* c_func
	char * t0
	void * p1
	short s2
PREINIT:
	char *(*func)(char *, void *, short);
CODE:
	func   = INT2PTR(char *(*)(char *, void *, short), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, s2);
OUTPUT:
	RETVAL

char *
nci_ttpf( c_func, t0, p1, f2 )
	SV* c_func
	char * t0
	void * p1
	float f2
PREINIT:
	char *(*func)(char *, void *, float);
CODE:
	func   = INT2PTR(char *(*)(char *, void *, float), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, f2);
OUTPUT:
	RETVAL

char *
nci_ttpt( c_func, t0, p1, t2 )
	SV* c_func
	char * t0
	void * p1
	char * t2
PREINIT:
	char *(*func)(char *, void *, char *);
CODE:
	func   = INT2PTR(char *(*)(char *, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, t2);
OUTPUT:
	RETVAL

char *
nci_ttpi( c_func, t0, p1, i2 )
	SV* c_func
	char * t0
	void * p1
	int i2
PREINIT:
	char *(*func)(char *, void *, int);
CODE:
	func   = INT2PTR(char *(*)(char *, void *, int), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, i2);
OUTPUT:
	RETVAL

char *
nci_ttdp( c_func, t0, d1, p2 )
	SV* c_func
	char * t0
	double d1
	void * p2
PREINIT:
	char *(*func)(char *, double, void *);
CODE:
	func   = INT2PTR(char *(*)(char *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, p2);
OUTPUT:
	RETVAL

char *
nci_ttdd( c_func, t0, d1, d2 )
	SV* c_func
	char * t0
	double d1
	double d2
PREINIT:
	char *(*func)(char *, double, double);
CODE:
	func   = INT2PTR(char *(*)(char *, double, double), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, d2);
OUTPUT:
	RETVAL

char *
nci_ttds( c_func, t0, d1, s2 )
	SV* c_func
	char * t0
	double d1
	short s2
PREINIT:
	char *(*func)(char *, double, short);
CODE:
	func   = INT2PTR(char *(*)(char *, double, short), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, s2);
OUTPUT:
	RETVAL

char *
nci_ttdf( c_func, t0, d1, f2 )
	SV* c_func
	char * t0
	double d1
	float f2
PREINIT:
	char *(*func)(char *, double, float);
CODE:
	func   = INT2PTR(char *(*)(char *, double, float), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, f2);
OUTPUT:
	RETVAL

char *
nci_ttdt( c_func, t0, d1, t2 )
	SV* c_func
	char * t0
	double d1
	char * t2
PREINIT:
	char *(*func)(char *, double, char *);
CODE:
	func   = INT2PTR(char *(*)(char *, double, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, t2);
OUTPUT:
	RETVAL

char *
nci_ttdi( c_func, t0, d1, i2 )
	SV* c_func
	char * t0
	double d1
	int i2
PREINIT:
	char *(*func)(char *, double, int);
CODE:
	func   = INT2PTR(char *(*)(char *, double, int), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, i2);
OUTPUT:
	RETVAL

char *
nci_ttsp( c_func, t0, s1, p2 )
	SV* c_func
	char * t0
	short s1
	void * p2
PREINIT:
	char *(*func)(char *, short, void *);
CODE:
	func   = INT2PTR(char *(*)(char *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, p2);
OUTPUT:
	RETVAL

char *
nci_ttsd( c_func, t0, s1, d2 )
	SV* c_func
	char * t0
	short s1
	double d2
PREINIT:
	char *(*func)(char *, short, double);
CODE:
	func   = INT2PTR(char *(*)(char *, short, double), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, d2);
OUTPUT:
	RETVAL

char *
nci_ttss( c_func, t0, s1, s2 )
	SV* c_func
	char * t0
	short s1
	short s2
PREINIT:
	char *(*func)(char *, short, short);
CODE:
	func   = INT2PTR(char *(*)(char *, short, short), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, s2);
OUTPUT:
	RETVAL

char *
nci_ttsf( c_func, t0, s1, f2 )
	SV* c_func
	char * t0
	short s1
	float f2
PREINIT:
	char *(*func)(char *, short, float);
CODE:
	func   = INT2PTR(char *(*)(char *, short, float), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, f2);
OUTPUT:
	RETVAL

char *
nci_ttst( c_func, t0, s1, t2 )
	SV* c_func
	char * t0
	short s1
	char * t2
PREINIT:
	char *(*func)(char *, short, char *);
CODE:
	func   = INT2PTR(char *(*)(char *, short, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, t2);
OUTPUT:
	RETVAL

char *
nci_ttsi( c_func, t0, s1, i2 )
	SV* c_func
	char * t0
	short s1
	int i2
PREINIT:
	char *(*func)(char *, short, int);
CODE:
	func   = INT2PTR(char *(*)(char *, short, int), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, i2);
OUTPUT:
	RETVAL

char *
nci_ttfp( c_func, t0, f1, p2 )
	SV* c_func
	char * t0
	float f1
	void * p2
PREINIT:
	char *(*func)(char *, float, void *);
CODE:
	func   = INT2PTR(char *(*)(char *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, p2);
OUTPUT:
	RETVAL

char *
nci_ttfd( c_func, t0, f1, d2 )
	SV* c_func
	char * t0
	float f1
	double d2
PREINIT:
	char *(*func)(char *, float, double);
CODE:
	func   = INT2PTR(char *(*)(char *, float, double), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, d2);
OUTPUT:
	RETVAL

char *
nci_ttfs( c_func, t0, f1, s2 )
	SV* c_func
	char * t0
	float f1
	short s2
PREINIT:
	char *(*func)(char *, float, short);
CODE:
	func   = INT2PTR(char *(*)(char *, float, short), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, s2);
OUTPUT:
	RETVAL

char *
nci_ttff( c_func, t0, f1, f2 )
	SV* c_func
	char * t0
	float f1
	float f2
PREINIT:
	char *(*func)(char *, float, float);
CODE:
	func   = INT2PTR(char *(*)(char *, float, float), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, f2);
OUTPUT:
	RETVAL

char *
nci_ttft( c_func, t0, f1, t2 )
	SV* c_func
	char * t0
	float f1
	char * t2
PREINIT:
	char *(*func)(char *, float, char *);
CODE:
	func   = INT2PTR(char *(*)(char *, float, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, t2);
OUTPUT:
	RETVAL

char *
nci_ttfi( c_func, t0, f1, i2 )
	SV* c_func
	char * t0
	float f1
	int i2
PREINIT:
	char *(*func)(char *, float, int);
CODE:
	func   = INT2PTR(char *(*)(char *, float, int), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, i2);
OUTPUT:
	RETVAL

char *
nci_tttp( c_func, t0, t1, p2 )
	SV* c_func
	char * t0
	char * t1
	void * p2
PREINIT:
	char *(*func)(char *, char *, void *);
CODE:
	func   = INT2PTR(char *(*)(char *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, p2);
OUTPUT:
	RETVAL

char *
nci_tttd( c_func, t0, t1, d2 )
	SV* c_func
	char * t0
	char * t1
	double d2
PREINIT:
	char *(*func)(char *, char *, double);
CODE:
	func   = INT2PTR(char *(*)(char *, char *, double), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, d2);
OUTPUT:
	RETVAL

char *
nci_ttts( c_func, t0, t1, s2 )
	SV* c_func
	char * t0
	char * t1
	short s2
PREINIT:
	char *(*func)(char *, char *, short);
CODE:
	func   = INT2PTR(char *(*)(char *, char *, short), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, s2);
OUTPUT:
	RETVAL

char *
nci_tttf( c_func, t0, t1, f2 )
	SV* c_func
	char * t0
	char * t1
	float f2
PREINIT:
	char *(*func)(char *, char *, float);
CODE:
	func   = INT2PTR(char *(*)(char *, char *, float), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, f2);
OUTPUT:
	RETVAL

char *
nci_tttt( c_func, t0, t1, t2 )
	SV* c_func
	char * t0
	char * t1
	char * t2
PREINIT:
	char *(*func)(char *, char *, char *);
CODE:
	func   = INT2PTR(char *(*)(char *, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, t2);
OUTPUT:
	RETVAL

char *
nci_ttti( c_func, t0, t1, i2 )
	SV* c_func
	char * t0
	char * t1
	int i2
PREINIT:
	char *(*func)(char *, char *, int);
CODE:
	func   = INT2PTR(char *(*)(char *, char *, int), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, i2);
OUTPUT:
	RETVAL

char *
nci_ttip( c_func, t0, i1, p2 )
	SV* c_func
	char * t0
	int i1
	void * p2
PREINIT:
	char *(*func)(char *, int, void *);
CODE:
	func   = INT2PTR(char *(*)(char *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, p2);
OUTPUT:
	RETVAL

char *
nci_ttid( c_func, t0, i1, d2 )
	SV* c_func
	char * t0
	int i1
	double d2
PREINIT:
	char *(*func)(char *, int, double);
CODE:
	func   = INT2PTR(char *(*)(char *, int, double), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, d2);
OUTPUT:
	RETVAL

char *
nci_ttis( c_func, t0, i1, s2 )
	SV* c_func
	char * t0
	int i1
	short s2
PREINIT:
	char *(*func)(char *, int, short);
CODE:
	func   = INT2PTR(char *(*)(char *, int, short), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, s2);
OUTPUT:
	RETVAL

char *
nci_ttif( c_func, t0, i1, f2 )
	SV* c_func
	char * t0
	int i1
	float f2
PREINIT:
	char *(*func)(char *, int, float);
CODE:
	func   = INT2PTR(char *(*)(char *, int, float), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, f2);
OUTPUT:
	RETVAL

char *
nci_ttit( c_func, t0, i1, t2 )
	SV* c_func
	char * t0
	int i1
	char * t2
PREINIT:
	char *(*func)(char *, int, char *);
CODE:
	func   = INT2PTR(char *(*)(char *, int, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, t2);
OUTPUT:
	RETVAL

char *
nci_ttii( c_func, t0, i1, i2 )
	SV* c_func
	char * t0
	int i1
	int i2
PREINIT:
	char *(*func)(char *, int, int);
CODE:
	func   = INT2PTR(char *(*)(char *, int, int), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, i2);
OUTPUT:
	RETVAL

char *
nci_tipp( c_func, i0, p1, p2 )
	SV* c_func
	int i0
	void * p1
	void * p2
PREINIT:
	char *(*func)(int, void *, void *);
CODE:
	func   = INT2PTR(char *(*)(int, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, p2);
OUTPUT:
	RETVAL

char *
nci_tipd( c_func, i0, p1, d2 )
	SV* c_func
	int i0
	void * p1
	double d2
PREINIT:
	char *(*func)(int, void *, double);
CODE:
	func   = INT2PTR(char *(*)(int, void *, double), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, d2);
OUTPUT:
	RETVAL

char *
nci_tips( c_func, i0, p1, s2 )
	SV* c_func
	int i0
	void * p1
	short s2
PREINIT:
	char *(*func)(int, void *, short);
CODE:
	func   = INT2PTR(char *(*)(int, void *, short), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, s2);
OUTPUT:
	RETVAL

char *
nci_tipf( c_func, i0, p1, f2 )
	SV* c_func
	int i0
	void * p1
	float f2
PREINIT:
	char *(*func)(int, void *, float);
CODE:
	func   = INT2PTR(char *(*)(int, void *, float), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, f2);
OUTPUT:
	RETVAL

char *
nci_tipt( c_func, i0, p1, t2 )
	SV* c_func
	int i0
	void * p1
	char * t2
PREINIT:
	char *(*func)(int, void *, char *);
CODE:
	func   = INT2PTR(char *(*)(int, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, t2);
OUTPUT:
	RETVAL

char *
nci_tipi( c_func, i0, p1, i2 )
	SV* c_func
	int i0
	void * p1
	int i2
PREINIT:
	char *(*func)(int, void *, int);
CODE:
	func   = INT2PTR(char *(*)(int, void *, int), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, i2);
OUTPUT:
	RETVAL

char *
nci_tidp( c_func, i0, d1, p2 )
	SV* c_func
	int i0
	double d1
	void * p2
PREINIT:
	char *(*func)(int, double, void *);
CODE:
	func   = INT2PTR(char *(*)(int, double, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, p2);
OUTPUT:
	RETVAL

char *
nci_tidd( c_func, i0, d1, d2 )
	SV* c_func
	int i0
	double d1
	double d2
PREINIT:
	char *(*func)(int, double, double);
CODE:
	func   = INT2PTR(char *(*)(int, double, double), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, d2);
OUTPUT:
	RETVAL

char *
nci_tids( c_func, i0, d1, s2 )
	SV* c_func
	int i0
	double d1
	short s2
PREINIT:
	char *(*func)(int, double, short);
CODE:
	func   = INT2PTR(char *(*)(int, double, short), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, s2);
OUTPUT:
	RETVAL

char *
nci_tidf( c_func, i0, d1, f2 )
	SV* c_func
	int i0
	double d1
	float f2
PREINIT:
	char *(*func)(int, double, float);
CODE:
	func   = INT2PTR(char *(*)(int, double, float), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, f2);
OUTPUT:
	RETVAL

char *
nci_tidt( c_func, i0, d1, t2 )
	SV* c_func
	int i0
	double d1
	char * t2
PREINIT:
	char *(*func)(int, double, char *);
CODE:
	func   = INT2PTR(char *(*)(int, double, char *), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, t2);
OUTPUT:
	RETVAL

char *
nci_tidi( c_func, i0, d1, i2 )
	SV* c_func
	int i0
	double d1
	int i2
PREINIT:
	char *(*func)(int, double, int);
CODE:
	func   = INT2PTR(char *(*)(int, double, int), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, i2);
OUTPUT:
	RETVAL

char *
nci_tisp( c_func, i0, s1, p2 )
	SV* c_func
	int i0
	short s1
	void * p2
PREINIT:
	char *(*func)(int, short, void *);
CODE:
	func   = INT2PTR(char *(*)(int, short, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, p2);
OUTPUT:
	RETVAL

char *
nci_tisd( c_func, i0, s1, d2 )
	SV* c_func
	int i0
	short s1
	double d2
PREINIT:
	char *(*func)(int, short, double);
CODE:
	func   = INT2PTR(char *(*)(int, short, double), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, d2);
OUTPUT:
	RETVAL

char *
nci_tiss( c_func, i0, s1, s2 )
	SV* c_func
	int i0
	short s1
	short s2
PREINIT:
	char *(*func)(int, short, short);
CODE:
	func   = INT2PTR(char *(*)(int, short, short), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, s2);
OUTPUT:
	RETVAL

char *
nci_tisf( c_func, i0, s1, f2 )
	SV* c_func
	int i0
	short s1
	float f2
PREINIT:
	char *(*func)(int, short, float);
CODE:
	func   = INT2PTR(char *(*)(int, short, float), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, f2);
OUTPUT:
	RETVAL

char *
nci_tist( c_func, i0, s1, t2 )
	SV* c_func
	int i0
	short s1
	char * t2
PREINIT:
	char *(*func)(int, short, char *);
CODE:
	func   = INT2PTR(char *(*)(int, short, char *), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, t2);
OUTPUT:
	RETVAL

char *
nci_tisi( c_func, i0, s1, i2 )
	SV* c_func
	int i0
	short s1
	int i2
PREINIT:
	char *(*func)(int, short, int);
CODE:
	func   = INT2PTR(char *(*)(int, short, int), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, i2);
OUTPUT:
	RETVAL

char *
nci_tifp( c_func, i0, f1, p2 )
	SV* c_func
	int i0
	float f1
	void * p2
PREINIT:
	char *(*func)(int, float, void *);
CODE:
	func   = INT2PTR(char *(*)(int, float, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, p2);
OUTPUT:
	RETVAL

char *
nci_tifd( c_func, i0, f1, d2 )
	SV* c_func
	int i0
	float f1
	double d2
PREINIT:
	char *(*func)(int, float, double);
CODE:
	func   = INT2PTR(char *(*)(int, float, double), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, d2);
OUTPUT:
	RETVAL

char *
nci_tifs( c_func, i0, f1, s2 )
	SV* c_func
	int i0
	float f1
	short s2
PREINIT:
	char *(*func)(int, float, short);
CODE:
	func   = INT2PTR(char *(*)(int, float, short), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, s2);
OUTPUT:
	RETVAL

char *
nci_tiff( c_func, i0, f1, f2 )
	SV* c_func
	int i0
	float f1
	float f2
PREINIT:
	char *(*func)(int, float, float);
CODE:
	func   = INT2PTR(char *(*)(int, float, float), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, f2);
OUTPUT:
	RETVAL

char *
nci_tift( c_func, i0, f1, t2 )
	SV* c_func
	int i0
	float f1
	char * t2
PREINIT:
	char *(*func)(int, float, char *);
CODE:
	func   = INT2PTR(char *(*)(int, float, char *), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, t2);
OUTPUT:
	RETVAL

char *
nci_tifi( c_func, i0, f1, i2 )
	SV* c_func
	int i0
	float f1
	int i2
PREINIT:
	char *(*func)(int, float, int);
CODE:
	func   = INT2PTR(char *(*)(int, float, int), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, i2);
OUTPUT:
	RETVAL

char *
nci_titp( c_func, i0, t1, p2 )
	SV* c_func
	int i0
	char * t1
	void * p2
PREINIT:
	char *(*func)(int, char *, void *);
CODE:
	func   = INT2PTR(char *(*)(int, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, p2);
OUTPUT:
	RETVAL

char *
nci_titd( c_func, i0, t1, d2 )
	SV* c_func
	int i0
	char * t1
	double d2
PREINIT:
	char *(*func)(int, char *, double);
CODE:
	func   = INT2PTR(char *(*)(int, char *, double), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, d2);
OUTPUT:
	RETVAL

char *
nci_tits( c_func, i0, t1, s2 )
	SV* c_func
	int i0
	char * t1
	short s2
PREINIT:
	char *(*func)(int, char *, short);
CODE:
	func   = INT2PTR(char *(*)(int, char *, short), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, s2);
OUTPUT:
	RETVAL

char *
nci_titf( c_func, i0, t1, f2 )
	SV* c_func
	int i0
	char * t1
	float f2
PREINIT:
	char *(*func)(int, char *, float);
CODE:
	func   = INT2PTR(char *(*)(int, char *, float), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, f2);
OUTPUT:
	RETVAL

char *
nci_titt( c_func, i0, t1, t2 )
	SV* c_func
	int i0
	char * t1
	char * t2
PREINIT:
	char *(*func)(int, char *, char *);
CODE:
	func   = INT2PTR(char *(*)(int, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, t2);
OUTPUT:
	RETVAL

char *
nci_titi( c_func, i0, t1, i2 )
	SV* c_func
	int i0
	char * t1
	int i2
PREINIT:
	char *(*func)(int, char *, int);
CODE:
	func   = INT2PTR(char *(*)(int, char *, int), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, i2);
OUTPUT:
	RETVAL

char *
nci_tiip( c_func, i0, i1, p2 )
	SV* c_func
	int i0
	int i1
	void * p2
PREINIT:
	char *(*func)(int, int, void *);
CODE:
	func   = INT2PTR(char *(*)(int, int, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, p2);
OUTPUT:
	RETVAL

char *
nci_tiid( c_func, i0, i1, d2 )
	SV* c_func
	int i0
	int i1
	double d2
PREINIT:
	char *(*func)(int, int, double);
CODE:
	func   = INT2PTR(char *(*)(int, int, double), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, d2);
OUTPUT:
	RETVAL

char *
nci_tiis( c_func, i0, i1, s2 )
	SV* c_func
	int i0
	int i1
	short s2
PREINIT:
	char *(*func)(int, int, short);
CODE:
	func   = INT2PTR(char *(*)(int, int, short), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, s2);
OUTPUT:
	RETVAL

char *
nci_tiif( c_func, i0, i1, f2 )
	SV* c_func
	int i0
	int i1
	float f2
PREINIT:
	char *(*func)(int, int, float);
CODE:
	func   = INT2PTR(char *(*)(int, int, float), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, f2);
OUTPUT:
	RETVAL

char *
nci_tiit( c_func, i0, i1, t2 )
	SV* c_func
	int i0
	int i1
	char * t2
PREINIT:
	char *(*func)(int, int, char *);
CODE:
	func   = INT2PTR(char *(*)(int, int, char *), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, t2);
OUTPUT:
	RETVAL

char *
nci_tiii( c_func, i0, i1, i2 )
	SV* c_func
	int i0
	int i1
	int i2
PREINIT:
	char *(*func)(int, int, int);
CODE:
	func   = INT2PTR(char *(*)(int, int, int), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, i2);
OUTPUT:
	RETVAL

int
nci_ippp( c_func, p0, p1, p2 )
	SV* c_func
	void * p0
	void * p1
	void * p2
PREINIT:
	int(*func)(void *, void *, void *);
CODE:
	func   = INT2PTR(int(*)(void *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, p2);
OUTPUT:
	RETVAL

int
nci_ippd( c_func, p0, p1, d2 )
	SV* c_func
	void * p0
	void * p1
	double d2
PREINIT:
	int(*func)(void *, void *, double);
CODE:
	func   = INT2PTR(int(*)(void *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, d2);
OUTPUT:
	RETVAL

int
nci_ipps( c_func, p0, p1, s2 )
	SV* c_func
	void * p0
	void * p1
	short s2
PREINIT:
	int(*func)(void *, void *, short);
CODE:
	func   = INT2PTR(int(*)(void *, void *, short), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, s2);
OUTPUT:
	RETVAL

int
nci_ippf( c_func, p0, p1, f2 )
	SV* c_func
	void * p0
	void * p1
	float f2
PREINIT:
	int(*func)(void *, void *, float);
CODE:
	func   = INT2PTR(int(*)(void *, void *, float), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, f2);
OUTPUT:
	RETVAL

int
nci_ippt( c_func, p0, p1, t2 )
	SV* c_func
	void * p0
	void * p1
	char * t2
PREINIT:
	int(*func)(void *, void *, char *);
CODE:
	func   = INT2PTR(int(*)(void *, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, t2);
OUTPUT:
	RETVAL

int
nci_ippi( c_func, p0, p1, i2 )
	SV* c_func
	void * p0
	void * p1
	int i2
PREINIT:
	int(*func)(void *, void *, int);
CODE:
	func   = INT2PTR(int(*)(void *, void *, int), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, i2);
OUTPUT:
	RETVAL

int
nci_ipdp( c_func, p0, d1, p2 )
	SV* c_func
	void * p0
	double d1
	void * p2
PREINIT:
	int(*func)(void *, double, void *);
CODE:
	func   = INT2PTR(int(*)(void *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, p2);
OUTPUT:
	RETVAL

int
nci_ipdd( c_func, p0, d1, d2 )
	SV* c_func
	void * p0
	double d1
	double d2
PREINIT:
	int(*func)(void *, double, double);
CODE:
	func   = INT2PTR(int(*)(void *, double, double), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, d2);
OUTPUT:
	RETVAL

int
nci_ipds( c_func, p0, d1, s2 )
	SV* c_func
	void * p0
	double d1
	short s2
PREINIT:
	int(*func)(void *, double, short);
CODE:
	func   = INT2PTR(int(*)(void *, double, short), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, s2);
OUTPUT:
	RETVAL

int
nci_ipdf( c_func, p0, d1, f2 )
	SV* c_func
	void * p0
	double d1
	float f2
PREINIT:
	int(*func)(void *, double, float);
CODE:
	func   = INT2PTR(int(*)(void *, double, float), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, f2);
OUTPUT:
	RETVAL

int
nci_ipdt( c_func, p0, d1, t2 )
	SV* c_func
	void * p0
	double d1
	char * t2
PREINIT:
	int(*func)(void *, double, char *);
CODE:
	func   = INT2PTR(int(*)(void *, double, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, t2);
OUTPUT:
	RETVAL

int
nci_ipdi( c_func, p0, d1, i2 )
	SV* c_func
	void * p0
	double d1
	int i2
PREINIT:
	int(*func)(void *, double, int);
CODE:
	func   = INT2PTR(int(*)(void *, double, int), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, i2);
OUTPUT:
	RETVAL

int
nci_ipsp( c_func, p0, s1, p2 )
	SV* c_func
	void * p0
	short s1
	void * p2
PREINIT:
	int(*func)(void *, short, void *);
CODE:
	func   = INT2PTR(int(*)(void *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, p2);
OUTPUT:
	RETVAL

int
nci_ipsd( c_func, p0, s1, d2 )
	SV* c_func
	void * p0
	short s1
	double d2
PREINIT:
	int(*func)(void *, short, double);
CODE:
	func   = INT2PTR(int(*)(void *, short, double), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, d2);
OUTPUT:
	RETVAL

int
nci_ipss( c_func, p0, s1, s2 )
	SV* c_func
	void * p0
	short s1
	short s2
PREINIT:
	int(*func)(void *, short, short);
CODE:
	func   = INT2PTR(int(*)(void *, short, short), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, s2);
OUTPUT:
	RETVAL

int
nci_ipsf( c_func, p0, s1, f2 )
	SV* c_func
	void * p0
	short s1
	float f2
PREINIT:
	int(*func)(void *, short, float);
CODE:
	func   = INT2PTR(int(*)(void *, short, float), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, f2);
OUTPUT:
	RETVAL

int
nci_ipst( c_func, p0, s1, t2 )
	SV* c_func
	void * p0
	short s1
	char * t2
PREINIT:
	int(*func)(void *, short, char *);
CODE:
	func   = INT2PTR(int(*)(void *, short, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, t2);
OUTPUT:
	RETVAL

int
nci_ipsi( c_func, p0, s1, i2 )
	SV* c_func
	void * p0
	short s1
	int i2
PREINIT:
	int(*func)(void *, short, int);
CODE:
	func   = INT2PTR(int(*)(void *, short, int), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, i2);
OUTPUT:
	RETVAL

int
nci_ipfp( c_func, p0, f1, p2 )
	SV* c_func
	void * p0
	float f1
	void * p2
PREINIT:
	int(*func)(void *, float, void *);
CODE:
	func   = INT2PTR(int(*)(void *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, p2);
OUTPUT:
	RETVAL

int
nci_ipfd( c_func, p0, f1, d2 )
	SV* c_func
	void * p0
	float f1
	double d2
PREINIT:
	int(*func)(void *, float, double);
CODE:
	func   = INT2PTR(int(*)(void *, float, double), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, d2);
OUTPUT:
	RETVAL

int
nci_ipfs( c_func, p0, f1, s2 )
	SV* c_func
	void * p0
	float f1
	short s2
PREINIT:
	int(*func)(void *, float, short);
CODE:
	func   = INT2PTR(int(*)(void *, float, short), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, s2);
OUTPUT:
	RETVAL

int
nci_ipff( c_func, p0, f1, f2 )
	SV* c_func
	void * p0
	float f1
	float f2
PREINIT:
	int(*func)(void *, float, float);
CODE:
	func   = INT2PTR(int(*)(void *, float, float), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, f2);
OUTPUT:
	RETVAL

int
nci_ipft( c_func, p0, f1, t2 )
	SV* c_func
	void * p0
	float f1
	char * t2
PREINIT:
	int(*func)(void *, float, char *);
CODE:
	func   = INT2PTR(int(*)(void *, float, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, t2);
OUTPUT:
	RETVAL

int
nci_ipfi( c_func, p0, f1, i2 )
	SV* c_func
	void * p0
	float f1
	int i2
PREINIT:
	int(*func)(void *, float, int);
CODE:
	func   = INT2PTR(int(*)(void *, float, int), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, i2);
OUTPUT:
	RETVAL

int
nci_iptp( c_func, p0, t1, p2 )
	SV* c_func
	void * p0
	char * t1
	void * p2
PREINIT:
	int(*func)(void *, char *, void *);
CODE:
	func   = INT2PTR(int(*)(void *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, p2);
OUTPUT:
	RETVAL

int
nci_iptd( c_func, p0, t1, d2 )
	SV* c_func
	void * p0
	char * t1
	double d2
PREINIT:
	int(*func)(void *, char *, double);
CODE:
	func   = INT2PTR(int(*)(void *, char *, double), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, d2);
OUTPUT:
	RETVAL

int
nci_ipts( c_func, p0, t1, s2 )
	SV* c_func
	void * p0
	char * t1
	short s2
PREINIT:
	int(*func)(void *, char *, short);
CODE:
	func   = INT2PTR(int(*)(void *, char *, short), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, s2);
OUTPUT:
	RETVAL

int
nci_iptf( c_func, p0, t1, f2 )
	SV* c_func
	void * p0
	char * t1
	float f2
PREINIT:
	int(*func)(void *, char *, float);
CODE:
	func   = INT2PTR(int(*)(void *, char *, float), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, f2);
OUTPUT:
	RETVAL

int
nci_iptt( c_func, p0, t1, t2 )
	SV* c_func
	void * p0
	char * t1
	char * t2
PREINIT:
	int(*func)(void *, char *, char *);
CODE:
	func   = INT2PTR(int(*)(void *, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, t2);
OUTPUT:
	RETVAL

int
nci_ipti( c_func, p0, t1, i2 )
	SV* c_func
	void * p0
	char * t1
	int i2
PREINIT:
	int(*func)(void *, char *, int);
CODE:
	func   = INT2PTR(int(*)(void *, char *, int), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, i2);
OUTPUT:
	RETVAL

int
nci_ipip( c_func, p0, i1, p2 )
	SV* c_func
	void * p0
	int i1
	void * p2
PREINIT:
	int(*func)(void *, int, void *);
CODE:
	func   = INT2PTR(int(*)(void *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, p2);
OUTPUT:
	RETVAL

int
nci_ipid( c_func, p0, i1, d2 )
	SV* c_func
	void * p0
	int i1
	double d2
PREINIT:
	int(*func)(void *, int, double);
CODE:
	func   = INT2PTR(int(*)(void *, int, double), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, d2);
OUTPUT:
	RETVAL

int
nci_ipis( c_func, p0, i1, s2 )
	SV* c_func
	void * p0
	int i1
	short s2
PREINIT:
	int(*func)(void *, int, short);
CODE:
	func   = INT2PTR(int(*)(void *, int, short), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, s2);
OUTPUT:
	RETVAL

int
nci_ipif( c_func, p0, i1, f2 )
	SV* c_func
	void * p0
	int i1
	float f2
PREINIT:
	int(*func)(void *, int, float);
CODE:
	func   = INT2PTR(int(*)(void *, int, float), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, f2);
OUTPUT:
	RETVAL

int
nci_ipit( c_func, p0, i1, t2 )
	SV* c_func
	void * p0
	int i1
	char * t2
PREINIT:
	int(*func)(void *, int, char *);
CODE:
	func   = INT2PTR(int(*)(void *, int, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, t2);
OUTPUT:
	RETVAL

int
nci_ipii( c_func, p0, i1, i2 )
	SV* c_func
	void * p0
	int i1
	int i2
PREINIT:
	int(*func)(void *, int, int);
CODE:
	func   = INT2PTR(int(*)(void *, int, int), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, i2);
OUTPUT:
	RETVAL

int
nci_idpp( c_func, d0, p1, p2 )
	SV* c_func
	double d0
	void * p1
	void * p2
PREINIT:
	int(*func)(double, void *, void *);
CODE:
	func   = INT2PTR(int(*)(double, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, p2);
OUTPUT:
	RETVAL

int
nci_idpd( c_func, d0, p1, d2 )
	SV* c_func
	double d0
	void * p1
	double d2
PREINIT:
	int(*func)(double, void *, double);
CODE:
	func   = INT2PTR(int(*)(double, void *, double), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, d2);
OUTPUT:
	RETVAL

int
nci_idps( c_func, d0, p1, s2 )
	SV* c_func
	double d0
	void * p1
	short s2
PREINIT:
	int(*func)(double, void *, short);
CODE:
	func   = INT2PTR(int(*)(double, void *, short), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, s2);
OUTPUT:
	RETVAL

int
nci_idpf( c_func, d0, p1, f2 )
	SV* c_func
	double d0
	void * p1
	float f2
PREINIT:
	int(*func)(double, void *, float);
CODE:
	func   = INT2PTR(int(*)(double, void *, float), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, f2);
OUTPUT:
	RETVAL

int
nci_idpt( c_func, d0, p1, t2 )
	SV* c_func
	double d0
	void * p1
	char * t2
PREINIT:
	int(*func)(double, void *, char *);
CODE:
	func   = INT2PTR(int(*)(double, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, t2);
OUTPUT:
	RETVAL

int
nci_idpi( c_func, d0, p1, i2 )
	SV* c_func
	double d0
	void * p1
	int i2
PREINIT:
	int(*func)(double, void *, int);
CODE:
	func   = INT2PTR(int(*)(double, void *, int), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, i2);
OUTPUT:
	RETVAL

int
nci_iddp( c_func, d0, d1, p2 )
	SV* c_func
	double d0
	double d1
	void * p2
PREINIT:
	int(*func)(double, double, void *);
CODE:
	func   = INT2PTR(int(*)(double, double, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, p2);
OUTPUT:
	RETVAL

int
nci_iddd( c_func, d0, d1, d2 )
	SV* c_func
	double d0
	double d1
	double d2
PREINIT:
	int(*func)(double, double, double);
CODE:
	func   = INT2PTR(int(*)(double, double, double), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, d2);
OUTPUT:
	RETVAL

int
nci_idds( c_func, d0, d1, s2 )
	SV* c_func
	double d0
	double d1
	short s2
PREINIT:
	int(*func)(double, double, short);
CODE:
	func   = INT2PTR(int(*)(double, double, short), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, s2);
OUTPUT:
	RETVAL

int
nci_iddf( c_func, d0, d1, f2 )
	SV* c_func
	double d0
	double d1
	float f2
PREINIT:
	int(*func)(double, double, float);
CODE:
	func   = INT2PTR(int(*)(double, double, float), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, f2);
OUTPUT:
	RETVAL

int
nci_iddt( c_func, d0, d1, t2 )
	SV* c_func
	double d0
	double d1
	char * t2
PREINIT:
	int(*func)(double, double, char *);
CODE:
	func   = INT2PTR(int(*)(double, double, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, t2);
OUTPUT:
	RETVAL

int
nci_iddi( c_func, d0, d1, i2 )
	SV* c_func
	double d0
	double d1
	int i2
PREINIT:
	int(*func)(double, double, int);
CODE:
	func   = INT2PTR(int(*)(double, double, int), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, i2);
OUTPUT:
	RETVAL

int
nci_idsp( c_func, d0, s1, p2 )
	SV* c_func
	double d0
	short s1
	void * p2
PREINIT:
	int(*func)(double, short, void *);
CODE:
	func   = INT2PTR(int(*)(double, short, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, p2);
OUTPUT:
	RETVAL

int
nci_idsd( c_func, d0, s1, d2 )
	SV* c_func
	double d0
	short s1
	double d2
PREINIT:
	int(*func)(double, short, double);
CODE:
	func   = INT2PTR(int(*)(double, short, double), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, d2);
OUTPUT:
	RETVAL

int
nci_idss( c_func, d0, s1, s2 )
	SV* c_func
	double d0
	short s1
	short s2
PREINIT:
	int(*func)(double, short, short);
CODE:
	func   = INT2PTR(int(*)(double, short, short), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, s2);
OUTPUT:
	RETVAL

int
nci_idsf( c_func, d0, s1, f2 )
	SV* c_func
	double d0
	short s1
	float f2
PREINIT:
	int(*func)(double, short, float);
CODE:
	func   = INT2PTR(int(*)(double, short, float), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, f2);
OUTPUT:
	RETVAL

int
nci_idst( c_func, d0, s1, t2 )
	SV* c_func
	double d0
	short s1
	char * t2
PREINIT:
	int(*func)(double, short, char *);
CODE:
	func   = INT2PTR(int(*)(double, short, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, t2);
OUTPUT:
	RETVAL

int
nci_idsi( c_func, d0, s1, i2 )
	SV* c_func
	double d0
	short s1
	int i2
PREINIT:
	int(*func)(double, short, int);
CODE:
	func   = INT2PTR(int(*)(double, short, int), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, i2);
OUTPUT:
	RETVAL

int
nci_idfp( c_func, d0, f1, p2 )
	SV* c_func
	double d0
	float f1
	void * p2
PREINIT:
	int(*func)(double, float, void *);
CODE:
	func   = INT2PTR(int(*)(double, float, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, p2);
OUTPUT:
	RETVAL

int
nci_idfd( c_func, d0, f1, d2 )
	SV* c_func
	double d0
	float f1
	double d2
PREINIT:
	int(*func)(double, float, double);
CODE:
	func   = INT2PTR(int(*)(double, float, double), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, d2);
OUTPUT:
	RETVAL

int
nci_idfs( c_func, d0, f1, s2 )
	SV* c_func
	double d0
	float f1
	short s2
PREINIT:
	int(*func)(double, float, short);
CODE:
	func   = INT2PTR(int(*)(double, float, short), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, s2);
OUTPUT:
	RETVAL

int
nci_idff( c_func, d0, f1, f2 )
	SV* c_func
	double d0
	float f1
	float f2
PREINIT:
	int(*func)(double, float, float);
CODE:
	func   = INT2PTR(int(*)(double, float, float), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, f2);
OUTPUT:
	RETVAL

int
nci_idft( c_func, d0, f1, t2 )
	SV* c_func
	double d0
	float f1
	char * t2
PREINIT:
	int(*func)(double, float, char *);
CODE:
	func   = INT2PTR(int(*)(double, float, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, t2);
OUTPUT:
	RETVAL

int
nci_idfi( c_func, d0, f1, i2 )
	SV* c_func
	double d0
	float f1
	int i2
PREINIT:
	int(*func)(double, float, int);
CODE:
	func   = INT2PTR(int(*)(double, float, int), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, i2);
OUTPUT:
	RETVAL

int
nci_idtp( c_func, d0, t1, p2 )
	SV* c_func
	double d0
	char * t1
	void * p2
PREINIT:
	int(*func)(double, char *, void *);
CODE:
	func   = INT2PTR(int(*)(double, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, p2);
OUTPUT:
	RETVAL

int
nci_idtd( c_func, d0, t1, d2 )
	SV* c_func
	double d0
	char * t1
	double d2
PREINIT:
	int(*func)(double, char *, double);
CODE:
	func   = INT2PTR(int(*)(double, char *, double), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, d2);
OUTPUT:
	RETVAL

int
nci_idts( c_func, d0, t1, s2 )
	SV* c_func
	double d0
	char * t1
	short s2
PREINIT:
	int(*func)(double, char *, short);
CODE:
	func   = INT2PTR(int(*)(double, char *, short), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, s2);
OUTPUT:
	RETVAL

int
nci_idtf( c_func, d0, t1, f2 )
	SV* c_func
	double d0
	char * t1
	float f2
PREINIT:
	int(*func)(double, char *, float);
CODE:
	func   = INT2PTR(int(*)(double, char *, float), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, f2);
OUTPUT:
	RETVAL

int
nci_idtt( c_func, d0, t1, t2 )
	SV* c_func
	double d0
	char * t1
	char * t2
PREINIT:
	int(*func)(double, char *, char *);
CODE:
	func   = INT2PTR(int(*)(double, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, t2);
OUTPUT:
	RETVAL

int
nci_idti( c_func, d0, t1, i2 )
	SV* c_func
	double d0
	char * t1
	int i2
PREINIT:
	int(*func)(double, char *, int);
CODE:
	func   = INT2PTR(int(*)(double, char *, int), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, i2);
OUTPUT:
	RETVAL

int
nci_idip( c_func, d0, i1, p2 )
	SV* c_func
	double d0
	int i1
	void * p2
PREINIT:
	int(*func)(double, int, void *);
CODE:
	func   = INT2PTR(int(*)(double, int, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, p2);
OUTPUT:
	RETVAL

int
nci_idid( c_func, d0, i1, d2 )
	SV* c_func
	double d0
	int i1
	double d2
PREINIT:
	int(*func)(double, int, double);
CODE:
	func   = INT2PTR(int(*)(double, int, double), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, d2);
OUTPUT:
	RETVAL

int
nci_idis( c_func, d0, i1, s2 )
	SV* c_func
	double d0
	int i1
	short s2
PREINIT:
	int(*func)(double, int, short);
CODE:
	func   = INT2PTR(int(*)(double, int, short), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, s2);
OUTPUT:
	RETVAL

int
nci_idif( c_func, d0, i1, f2 )
	SV* c_func
	double d0
	int i1
	float f2
PREINIT:
	int(*func)(double, int, float);
CODE:
	func   = INT2PTR(int(*)(double, int, float), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, f2);
OUTPUT:
	RETVAL

int
nci_idit( c_func, d0, i1, t2 )
	SV* c_func
	double d0
	int i1
	char * t2
PREINIT:
	int(*func)(double, int, char *);
CODE:
	func   = INT2PTR(int(*)(double, int, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, t2);
OUTPUT:
	RETVAL

int
nci_idii( c_func, d0, i1, i2 )
	SV* c_func
	double d0
	int i1
	int i2
PREINIT:
	int(*func)(double, int, int);
CODE:
	func   = INT2PTR(int(*)(double, int, int), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, i2);
OUTPUT:
	RETVAL

int
nci_ispp( c_func, s0, p1, p2 )
	SV* c_func
	short s0
	void * p1
	void * p2
PREINIT:
	int(*func)(short, void *, void *);
CODE:
	func   = INT2PTR(int(*)(short, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, p2);
OUTPUT:
	RETVAL

int
nci_ispd( c_func, s0, p1, d2 )
	SV* c_func
	short s0
	void * p1
	double d2
PREINIT:
	int(*func)(short, void *, double);
CODE:
	func   = INT2PTR(int(*)(short, void *, double), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, d2);
OUTPUT:
	RETVAL

int
nci_isps( c_func, s0, p1, s2 )
	SV* c_func
	short s0
	void * p1
	short s2
PREINIT:
	int(*func)(short, void *, short);
CODE:
	func   = INT2PTR(int(*)(short, void *, short), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, s2);
OUTPUT:
	RETVAL

int
nci_ispf( c_func, s0, p1, f2 )
	SV* c_func
	short s0
	void * p1
	float f2
PREINIT:
	int(*func)(short, void *, float);
CODE:
	func   = INT2PTR(int(*)(short, void *, float), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, f2);
OUTPUT:
	RETVAL

int
nci_ispt( c_func, s0, p1, t2 )
	SV* c_func
	short s0
	void * p1
	char * t2
PREINIT:
	int(*func)(short, void *, char *);
CODE:
	func   = INT2PTR(int(*)(short, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, t2);
OUTPUT:
	RETVAL

int
nci_ispi( c_func, s0, p1, i2 )
	SV* c_func
	short s0
	void * p1
	int i2
PREINIT:
	int(*func)(short, void *, int);
CODE:
	func   = INT2PTR(int(*)(short, void *, int), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, i2);
OUTPUT:
	RETVAL

int
nci_isdp( c_func, s0, d1, p2 )
	SV* c_func
	short s0
	double d1
	void * p2
PREINIT:
	int(*func)(short, double, void *);
CODE:
	func   = INT2PTR(int(*)(short, double, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, p2);
OUTPUT:
	RETVAL

int
nci_isdd( c_func, s0, d1, d2 )
	SV* c_func
	short s0
	double d1
	double d2
PREINIT:
	int(*func)(short, double, double);
CODE:
	func   = INT2PTR(int(*)(short, double, double), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, d2);
OUTPUT:
	RETVAL

int
nci_isds( c_func, s0, d1, s2 )
	SV* c_func
	short s0
	double d1
	short s2
PREINIT:
	int(*func)(short, double, short);
CODE:
	func   = INT2PTR(int(*)(short, double, short), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, s2);
OUTPUT:
	RETVAL

int
nci_isdf( c_func, s0, d1, f2 )
	SV* c_func
	short s0
	double d1
	float f2
PREINIT:
	int(*func)(short, double, float);
CODE:
	func   = INT2PTR(int(*)(short, double, float), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, f2);
OUTPUT:
	RETVAL

int
nci_isdt( c_func, s0, d1, t2 )
	SV* c_func
	short s0
	double d1
	char * t2
PREINIT:
	int(*func)(short, double, char *);
CODE:
	func   = INT2PTR(int(*)(short, double, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, t2);
OUTPUT:
	RETVAL

int
nci_isdi( c_func, s0, d1, i2 )
	SV* c_func
	short s0
	double d1
	int i2
PREINIT:
	int(*func)(short, double, int);
CODE:
	func   = INT2PTR(int(*)(short, double, int), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, i2);
OUTPUT:
	RETVAL

int
nci_issp( c_func, s0, s1, p2 )
	SV* c_func
	short s0
	short s1
	void * p2
PREINIT:
	int(*func)(short, short, void *);
CODE:
	func   = INT2PTR(int(*)(short, short, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, p2);
OUTPUT:
	RETVAL

int
nci_issd( c_func, s0, s1, d2 )
	SV* c_func
	short s0
	short s1
	double d2
PREINIT:
	int(*func)(short, short, double);
CODE:
	func   = INT2PTR(int(*)(short, short, double), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, d2);
OUTPUT:
	RETVAL

int
nci_isss( c_func, s0, s1, s2 )
	SV* c_func
	short s0
	short s1
	short s2
PREINIT:
	int(*func)(short, short, short);
CODE:
	func   = INT2PTR(int(*)(short, short, short), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, s2);
OUTPUT:
	RETVAL

int
nci_issf( c_func, s0, s1, f2 )
	SV* c_func
	short s0
	short s1
	float f2
PREINIT:
	int(*func)(short, short, float);
CODE:
	func   = INT2PTR(int(*)(short, short, float), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, f2);
OUTPUT:
	RETVAL

int
nci_isst( c_func, s0, s1, t2 )
	SV* c_func
	short s0
	short s1
	char * t2
PREINIT:
	int(*func)(short, short, char *);
CODE:
	func   = INT2PTR(int(*)(short, short, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, t2);
OUTPUT:
	RETVAL

int
nci_issi( c_func, s0, s1, i2 )
	SV* c_func
	short s0
	short s1
	int i2
PREINIT:
	int(*func)(short, short, int);
CODE:
	func   = INT2PTR(int(*)(short, short, int), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, i2);
OUTPUT:
	RETVAL

int
nci_isfp( c_func, s0, f1, p2 )
	SV* c_func
	short s0
	float f1
	void * p2
PREINIT:
	int(*func)(short, float, void *);
CODE:
	func   = INT2PTR(int(*)(short, float, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, p2);
OUTPUT:
	RETVAL

int
nci_isfd( c_func, s0, f1, d2 )
	SV* c_func
	short s0
	float f1
	double d2
PREINIT:
	int(*func)(short, float, double);
CODE:
	func   = INT2PTR(int(*)(short, float, double), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, d2);
OUTPUT:
	RETVAL

int
nci_isfs( c_func, s0, f1, s2 )
	SV* c_func
	short s0
	float f1
	short s2
PREINIT:
	int(*func)(short, float, short);
CODE:
	func   = INT2PTR(int(*)(short, float, short), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, s2);
OUTPUT:
	RETVAL

int
nci_isff( c_func, s0, f1, f2 )
	SV* c_func
	short s0
	float f1
	float f2
PREINIT:
	int(*func)(short, float, float);
CODE:
	func   = INT2PTR(int(*)(short, float, float), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, f2);
OUTPUT:
	RETVAL

int
nci_isft( c_func, s0, f1, t2 )
	SV* c_func
	short s0
	float f1
	char * t2
PREINIT:
	int(*func)(short, float, char *);
CODE:
	func   = INT2PTR(int(*)(short, float, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, t2);
OUTPUT:
	RETVAL

int
nci_isfi( c_func, s0, f1, i2 )
	SV* c_func
	short s0
	float f1
	int i2
PREINIT:
	int(*func)(short, float, int);
CODE:
	func   = INT2PTR(int(*)(short, float, int), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, i2);
OUTPUT:
	RETVAL

int
nci_istp( c_func, s0, t1, p2 )
	SV* c_func
	short s0
	char * t1
	void * p2
PREINIT:
	int(*func)(short, char *, void *);
CODE:
	func   = INT2PTR(int(*)(short, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, p2);
OUTPUT:
	RETVAL

int
nci_istd( c_func, s0, t1, d2 )
	SV* c_func
	short s0
	char * t1
	double d2
PREINIT:
	int(*func)(short, char *, double);
CODE:
	func   = INT2PTR(int(*)(short, char *, double), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, d2);
OUTPUT:
	RETVAL

int
nci_ists( c_func, s0, t1, s2 )
	SV* c_func
	short s0
	char * t1
	short s2
PREINIT:
	int(*func)(short, char *, short);
CODE:
	func   = INT2PTR(int(*)(short, char *, short), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, s2);
OUTPUT:
	RETVAL

int
nci_istf( c_func, s0, t1, f2 )
	SV* c_func
	short s0
	char * t1
	float f2
PREINIT:
	int(*func)(short, char *, float);
CODE:
	func   = INT2PTR(int(*)(short, char *, float), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, f2);
OUTPUT:
	RETVAL

int
nci_istt( c_func, s0, t1, t2 )
	SV* c_func
	short s0
	char * t1
	char * t2
PREINIT:
	int(*func)(short, char *, char *);
CODE:
	func   = INT2PTR(int(*)(short, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, t2);
OUTPUT:
	RETVAL

int
nci_isti( c_func, s0, t1, i2 )
	SV* c_func
	short s0
	char * t1
	int i2
PREINIT:
	int(*func)(short, char *, int);
CODE:
	func   = INT2PTR(int(*)(short, char *, int), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, i2);
OUTPUT:
	RETVAL

int
nci_isip( c_func, s0, i1, p2 )
	SV* c_func
	short s0
	int i1
	void * p2
PREINIT:
	int(*func)(short, int, void *);
CODE:
	func   = INT2PTR(int(*)(short, int, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, p2);
OUTPUT:
	RETVAL

int
nci_isid( c_func, s0, i1, d2 )
	SV* c_func
	short s0
	int i1
	double d2
PREINIT:
	int(*func)(short, int, double);
CODE:
	func   = INT2PTR(int(*)(short, int, double), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, d2);
OUTPUT:
	RETVAL

int
nci_isis( c_func, s0, i1, s2 )
	SV* c_func
	short s0
	int i1
	short s2
PREINIT:
	int(*func)(short, int, short);
CODE:
	func   = INT2PTR(int(*)(short, int, short), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, s2);
OUTPUT:
	RETVAL

int
nci_isif( c_func, s0, i1, f2 )
	SV* c_func
	short s0
	int i1
	float f2
PREINIT:
	int(*func)(short, int, float);
CODE:
	func   = INT2PTR(int(*)(short, int, float), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, f2);
OUTPUT:
	RETVAL

int
nci_isit( c_func, s0, i1, t2 )
	SV* c_func
	short s0
	int i1
	char * t2
PREINIT:
	int(*func)(short, int, char *);
CODE:
	func   = INT2PTR(int(*)(short, int, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, t2);
OUTPUT:
	RETVAL

int
nci_isii( c_func, s0, i1, i2 )
	SV* c_func
	short s0
	int i1
	int i2
PREINIT:
	int(*func)(short, int, int);
CODE:
	func   = INT2PTR(int(*)(short, int, int), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, i2);
OUTPUT:
	RETVAL

int
nci_ifpp( c_func, f0, p1, p2 )
	SV* c_func
	float f0
	void * p1
	void * p2
PREINIT:
	int(*func)(float, void *, void *);
CODE:
	func   = INT2PTR(int(*)(float, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, p2);
OUTPUT:
	RETVAL

int
nci_ifpd( c_func, f0, p1, d2 )
	SV* c_func
	float f0
	void * p1
	double d2
PREINIT:
	int(*func)(float, void *, double);
CODE:
	func   = INT2PTR(int(*)(float, void *, double), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, d2);
OUTPUT:
	RETVAL

int
nci_ifps( c_func, f0, p1, s2 )
	SV* c_func
	float f0
	void * p1
	short s2
PREINIT:
	int(*func)(float, void *, short);
CODE:
	func   = INT2PTR(int(*)(float, void *, short), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, s2);
OUTPUT:
	RETVAL

int
nci_ifpf( c_func, f0, p1, f2 )
	SV* c_func
	float f0
	void * p1
	float f2
PREINIT:
	int(*func)(float, void *, float);
CODE:
	func   = INT2PTR(int(*)(float, void *, float), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, f2);
OUTPUT:
	RETVAL

int
nci_ifpt( c_func, f0, p1, t2 )
	SV* c_func
	float f0
	void * p1
	char * t2
PREINIT:
	int(*func)(float, void *, char *);
CODE:
	func   = INT2PTR(int(*)(float, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, t2);
OUTPUT:
	RETVAL

int
nci_ifpi( c_func, f0, p1, i2 )
	SV* c_func
	float f0
	void * p1
	int i2
PREINIT:
	int(*func)(float, void *, int);
CODE:
	func   = INT2PTR(int(*)(float, void *, int), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, i2);
OUTPUT:
	RETVAL

int
nci_ifdp( c_func, f0, d1, p2 )
	SV* c_func
	float f0
	double d1
	void * p2
PREINIT:
	int(*func)(float, double, void *);
CODE:
	func   = INT2PTR(int(*)(float, double, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, p2);
OUTPUT:
	RETVAL

int
nci_ifdd( c_func, f0, d1, d2 )
	SV* c_func
	float f0
	double d1
	double d2
PREINIT:
	int(*func)(float, double, double);
CODE:
	func   = INT2PTR(int(*)(float, double, double), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, d2);
OUTPUT:
	RETVAL

int
nci_ifds( c_func, f0, d1, s2 )
	SV* c_func
	float f0
	double d1
	short s2
PREINIT:
	int(*func)(float, double, short);
CODE:
	func   = INT2PTR(int(*)(float, double, short), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, s2);
OUTPUT:
	RETVAL

int
nci_ifdf( c_func, f0, d1, f2 )
	SV* c_func
	float f0
	double d1
	float f2
PREINIT:
	int(*func)(float, double, float);
CODE:
	func   = INT2PTR(int(*)(float, double, float), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, f2);
OUTPUT:
	RETVAL

int
nci_ifdt( c_func, f0, d1, t2 )
	SV* c_func
	float f0
	double d1
	char * t2
PREINIT:
	int(*func)(float, double, char *);
CODE:
	func   = INT2PTR(int(*)(float, double, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, t2);
OUTPUT:
	RETVAL

int
nci_ifdi( c_func, f0, d1, i2 )
	SV* c_func
	float f0
	double d1
	int i2
PREINIT:
	int(*func)(float, double, int);
CODE:
	func   = INT2PTR(int(*)(float, double, int), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, i2);
OUTPUT:
	RETVAL

int
nci_ifsp( c_func, f0, s1, p2 )
	SV* c_func
	float f0
	short s1
	void * p2
PREINIT:
	int(*func)(float, short, void *);
CODE:
	func   = INT2PTR(int(*)(float, short, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, p2);
OUTPUT:
	RETVAL

int
nci_ifsd( c_func, f0, s1, d2 )
	SV* c_func
	float f0
	short s1
	double d2
PREINIT:
	int(*func)(float, short, double);
CODE:
	func   = INT2PTR(int(*)(float, short, double), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, d2);
OUTPUT:
	RETVAL

int
nci_ifss( c_func, f0, s1, s2 )
	SV* c_func
	float f0
	short s1
	short s2
PREINIT:
	int(*func)(float, short, short);
CODE:
	func   = INT2PTR(int(*)(float, short, short), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, s2);
OUTPUT:
	RETVAL

int
nci_ifsf( c_func, f0, s1, f2 )
	SV* c_func
	float f0
	short s1
	float f2
PREINIT:
	int(*func)(float, short, float);
CODE:
	func   = INT2PTR(int(*)(float, short, float), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, f2);
OUTPUT:
	RETVAL

int
nci_ifst( c_func, f0, s1, t2 )
	SV* c_func
	float f0
	short s1
	char * t2
PREINIT:
	int(*func)(float, short, char *);
CODE:
	func   = INT2PTR(int(*)(float, short, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, t2);
OUTPUT:
	RETVAL

int
nci_ifsi( c_func, f0, s1, i2 )
	SV* c_func
	float f0
	short s1
	int i2
PREINIT:
	int(*func)(float, short, int);
CODE:
	func   = INT2PTR(int(*)(float, short, int), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, i2);
OUTPUT:
	RETVAL

int
nci_iffp( c_func, f0, f1, p2 )
	SV* c_func
	float f0
	float f1
	void * p2
PREINIT:
	int(*func)(float, float, void *);
CODE:
	func   = INT2PTR(int(*)(float, float, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, p2);
OUTPUT:
	RETVAL

int
nci_iffd( c_func, f0, f1, d2 )
	SV* c_func
	float f0
	float f1
	double d2
PREINIT:
	int(*func)(float, float, double);
CODE:
	func   = INT2PTR(int(*)(float, float, double), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, d2);
OUTPUT:
	RETVAL

int
nci_iffs( c_func, f0, f1, s2 )
	SV* c_func
	float f0
	float f1
	short s2
PREINIT:
	int(*func)(float, float, short);
CODE:
	func   = INT2PTR(int(*)(float, float, short), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, s2);
OUTPUT:
	RETVAL

int
nci_ifff( c_func, f0, f1, f2 )
	SV* c_func
	float f0
	float f1
	float f2
PREINIT:
	int(*func)(float, float, float);
CODE:
	func   = INT2PTR(int(*)(float, float, float), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, f2);
OUTPUT:
	RETVAL

int
nci_ifft( c_func, f0, f1, t2 )
	SV* c_func
	float f0
	float f1
	char * t2
PREINIT:
	int(*func)(float, float, char *);
CODE:
	func   = INT2PTR(int(*)(float, float, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, t2);
OUTPUT:
	RETVAL

int
nci_iffi( c_func, f0, f1, i2 )
	SV* c_func
	float f0
	float f1
	int i2
PREINIT:
	int(*func)(float, float, int);
CODE:
	func   = INT2PTR(int(*)(float, float, int), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, i2);
OUTPUT:
	RETVAL

int
nci_iftp( c_func, f0, t1, p2 )
	SV* c_func
	float f0
	char * t1
	void * p2
PREINIT:
	int(*func)(float, char *, void *);
CODE:
	func   = INT2PTR(int(*)(float, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, p2);
OUTPUT:
	RETVAL

int
nci_iftd( c_func, f0, t1, d2 )
	SV* c_func
	float f0
	char * t1
	double d2
PREINIT:
	int(*func)(float, char *, double);
CODE:
	func   = INT2PTR(int(*)(float, char *, double), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, d2);
OUTPUT:
	RETVAL

int
nci_ifts( c_func, f0, t1, s2 )
	SV* c_func
	float f0
	char * t1
	short s2
PREINIT:
	int(*func)(float, char *, short);
CODE:
	func   = INT2PTR(int(*)(float, char *, short), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, s2);
OUTPUT:
	RETVAL

int
nci_iftf( c_func, f0, t1, f2 )
	SV* c_func
	float f0
	char * t1
	float f2
PREINIT:
	int(*func)(float, char *, float);
CODE:
	func   = INT2PTR(int(*)(float, char *, float), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, f2);
OUTPUT:
	RETVAL

int
nci_iftt( c_func, f0, t1, t2 )
	SV* c_func
	float f0
	char * t1
	char * t2
PREINIT:
	int(*func)(float, char *, char *);
CODE:
	func   = INT2PTR(int(*)(float, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, t2);
OUTPUT:
	RETVAL

int
nci_ifti( c_func, f0, t1, i2 )
	SV* c_func
	float f0
	char * t1
	int i2
PREINIT:
	int(*func)(float, char *, int);
CODE:
	func   = INT2PTR(int(*)(float, char *, int), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, i2);
OUTPUT:
	RETVAL

int
nci_ifip( c_func, f0, i1, p2 )
	SV* c_func
	float f0
	int i1
	void * p2
PREINIT:
	int(*func)(float, int, void *);
CODE:
	func   = INT2PTR(int(*)(float, int, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, p2);
OUTPUT:
	RETVAL

int
nci_ifid( c_func, f0, i1, d2 )
	SV* c_func
	float f0
	int i1
	double d2
PREINIT:
	int(*func)(float, int, double);
CODE:
	func   = INT2PTR(int(*)(float, int, double), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, d2);
OUTPUT:
	RETVAL

int
nci_ifis( c_func, f0, i1, s2 )
	SV* c_func
	float f0
	int i1
	short s2
PREINIT:
	int(*func)(float, int, short);
CODE:
	func   = INT2PTR(int(*)(float, int, short), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, s2);
OUTPUT:
	RETVAL

int
nci_ifif( c_func, f0, i1, f2 )
	SV* c_func
	float f0
	int i1
	float f2
PREINIT:
	int(*func)(float, int, float);
CODE:
	func   = INT2PTR(int(*)(float, int, float), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, f2);
OUTPUT:
	RETVAL

int
nci_ifit( c_func, f0, i1, t2 )
	SV* c_func
	float f0
	int i1
	char * t2
PREINIT:
	int(*func)(float, int, char *);
CODE:
	func   = INT2PTR(int(*)(float, int, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, t2);
OUTPUT:
	RETVAL

int
nci_ifii( c_func, f0, i1, i2 )
	SV* c_func
	float f0
	int i1
	int i2
PREINIT:
	int(*func)(float, int, int);
CODE:
	func   = INT2PTR(int(*)(float, int, int), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, i2);
OUTPUT:
	RETVAL

int
nci_itpp( c_func, t0, p1, p2 )
	SV* c_func
	char * t0
	void * p1
	void * p2
PREINIT:
	int(*func)(char *, void *, void *);
CODE:
	func   = INT2PTR(int(*)(char *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, p2);
OUTPUT:
	RETVAL

int
nci_itpd( c_func, t0, p1, d2 )
	SV* c_func
	char * t0
	void * p1
	double d2
PREINIT:
	int(*func)(char *, void *, double);
CODE:
	func   = INT2PTR(int(*)(char *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, d2);
OUTPUT:
	RETVAL

int
nci_itps( c_func, t0, p1, s2 )
	SV* c_func
	char * t0
	void * p1
	short s2
PREINIT:
	int(*func)(char *, void *, short);
CODE:
	func   = INT2PTR(int(*)(char *, void *, short), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, s2);
OUTPUT:
	RETVAL

int
nci_itpf( c_func, t0, p1, f2 )
	SV* c_func
	char * t0
	void * p1
	float f2
PREINIT:
	int(*func)(char *, void *, float);
CODE:
	func   = INT2PTR(int(*)(char *, void *, float), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, f2);
OUTPUT:
	RETVAL

int
nci_itpt( c_func, t0, p1, t2 )
	SV* c_func
	char * t0
	void * p1
	char * t2
PREINIT:
	int(*func)(char *, void *, char *);
CODE:
	func   = INT2PTR(int(*)(char *, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, t2);
OUTPUT:
	RETVAL

int
nci_itpi( c_func, t0, p1, i2 )
	SV* c_func
	char * t0
	void * p1
	int i2
PREINIT:
	int(*func)(char *, void *, int);
CODE:
	func   = INT2PTR(int(*)(char *, void *, int), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, i2);
OUTPUT:
	RETVAL

int
nci_itdp( c_func, t0, d1, p2 )
	SV* c_func
	char * t0
	double d1
	void * p2
PREINIT:
	int(*func)(char *, double, void *);
CODE:
	func   = INT2PTR(int(*)(char *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, p2);
OUTPUT:
	RETVAL

int
nci_itdd( c_func, t0, d1, d2 )
	SV* c_func
	char * t0
	double d1
	double d2
PREINIT:
	int(*func)(char *, double, double);
CODE:
	func   = INT2PTR(int(*)(char *, double, double), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, d2);
OUTPUT:
	RETVAL

int
nci_itds( c_func, t0, d1, s2 )
	SV* c_func
	char * t0
	double d1
	short s2
PREINIT:
	int(*func)(char *, double, short);
CODE:
	func   = INT2PTR(int(*)(char *, double, short), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, s2);
OUTPUT:
	RETVAL

int
nci_itdf( c_func, t0, d1, f2 )
	SV* c_func
	char * t0
	double d1
	float f2
PREINIT:
	int(*func)(char *, double, float);
CODE:
	func   = INT2PTR(int(*)(char *, double, float), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, f2);
OUTPUT:
	RETVAL

int
nci_itdt( c_func, t0, d1, t2 )
	SV* c_func
	char * t0
	double d1
	char * t2
PREINIT:
	int(*func)(char *, double, char *);
CODE:
	func   = INT2PTR(int(*)(char *, double, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, t2);
OUTPUT:
	RETVAL

int
nci_itdi( c_func, t0, d1, i2 )
	SV* c_func
	char * t0
	double d1
	int i2
PREINIT:
	int(*func)(char *, double, int);
CODE:
	func   = INT2PTR(int(*)(char *, double, int), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, i2);
OUTPUT:
	RETVAL

int
nci_itsp( c_func, t0, s1, p2 )
	SV* c_func
	char * t0
	short s1
	void * p2
PREINIT:
	int(*func)(char *, short, void *);
CODE:
	func   = INT2PTR(int(*)(char *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, p2);
OUTPUT:
	RETVAL

int
nci_itsd( c_func, t0, s1, d2 )
	SV* c_func
	char * t0
	short s1
	double d2
PREINIT:
	int(*func)(char *, short, double);
CODE:
	func   = INT2PTR(int(*)(char *, short, double), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, d2);
OUTPUT:
	RETVAL

int
nci_itss( c_func, t0, s1, s2 )
	SV* c_func
	char * t0
	short s1
	short s2
PREINIT:
	int(*func)(char *, short, short);
CODE:
	func   = INT2PTR(int(*)(char *, short, short), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, s2);
OUTPUT:
	RETVAL

int
nci_itsf( c_func, t0, s1, f2 )
	SV* c_func
	char * t0
	short s1
	float f2
PREINIT:
	int(*func)(char *, short, float);
CODE:
	func   = INT2PTR(int(*)(char *, short, float), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, f2);
OUTPUT:
	RETVAL

int
nci_itst( c_func, t0, s1, t2 )
	SV* c_func
	char * t0
	short s1
	char * t2
PREINIT:
	int(*func)(char *, short, char *);
CODE:
	func   = INT2PTR(int(*)(char *, short, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, t2);
OUTPUT:
	RETVAL

int
nci_itsi( c_func, t0, s1, i2 )
	SV* c_func
	char * t0
	short s1
	int i2
PREINIT:
	int(*func)(char *, short, int);
CODE:
	func   = INT2PTR(int(*)(char *, short, int), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, i2);
OUTPUT:
	RETVAL

int
nci_itfp( c_func, t0, f1, p2 )
	SV* c_func
	char * t0
	float f1
	void * p2
PREINIT:
	int(*func)(char *, float, void *);
CODE:
	func   = INT2PTR(int(*)(char *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, p2);
OUTPUT:
	RETVAL

int
nci_itfd( c_func, t0, f1, d2 )
	SV* c_func
	char * t0
	float f1
	double d2
PREINIT:
	int(*func)(char *, float, double);
CODE:
	func   = INT2PTR(int(*)(char *, float, double), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, d2);
OUTPUT:
	RETVAL

int
nci_itfs( c_func, t0, f1, s2 )
	SV* c_func
	char * t0
	float f1
	short s2
PREINIT:
	int(*func)(char *, float, short);
CODE:
	func   = INT2PTR(int(*)(char *, float, short), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, s2);
OUTPUT:
	RETVAL

int
nci_itff( c_func, t0, f1, f2 )
	SV* c_func
	char * t0
	float f1
	float f2
PREINIT:
	int(*func)(char *, float, float);
CODE:
	func   = INT2PTR(int(*)(char *, float, float), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, f2);
OUTPUT:
	RETVAL

int
nci_itft( c_func, t0, f1, t2 )
	SV* c_func
	char * t0
	float f1
	char * t2
PREINIT:
	int(*func)(char *, float, char *);
CODE:
	func   = INT2PTR(int(*)(char *, float, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, t2);
OUTPUT:
	RETVAL

int
nci_itfi( c_func, t0, f1, i2 )
	SV* c_func
	char * t0
	float f1
	int i2
PREINIT:
	int(*func)(char *, float, int);
CODE:
	func   = INT2PTR(int(*)(char *, float, int), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, i2);
OUTPUT:
	RETVAL

int
nci_ittp( c_func, t0, t1, p2 )
	SV* c_func
	char * t0
	char * t1
	void * p2
PREINIT:
	int(*func)(char *, char *, void *);
CODE:
	func   = INT2PTR(int(*)(char *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, p2);
OUTPUT:
	RETVAL

int
nci_ittd( c_func, t0, t1, d2 )
	SV* c_func
	char * t0
	char * t1
	double d2
PREINIT:
	int(*func)(char *, char *, double);
CODE:
	func   = INT2PTR(int(*)(char *, char *, double), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, d2);
OUTPUT:
	RETVAL

int
nci_itts( c_func, t0, t1, s2 )
	SV* c_func
	char * t0
	char * t1
	short s2
PREINIT:
	int(*func)(char *, char *, short);
CODE:
	func   = INT2PTR(int(*)(char *, char *, short), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, s2);
OUTPUT:
	RETVAL

int
nci_ittf( c_func, t0, t1, f2 )
	SV* c_func
	char * t0
	char * t1
	float f2
PREINIT:
	int(*func)(char *, char *, float);
CODE:
	func   = INT2PTR(int(*)(char *, char *, float), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, f2);
OUTPUT:
	RETVAL

int
nci_ittt( c_func, t0, t1, t2 )
	SV* c_func
	char * t0
	char * t1
	char * t2
PREINIT:
	int(*func)(char *, char *, char *);
CODE:
	func   = INT2PTR(int(*)(char *, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, t2);
OUTPUT:
	RETVAL

int
nci_itti( c_func, t0, t1, i2 )
	SV* c_func
	char * t0
	char * t1
	int i2
PREINIT:
	int(*func)(char *, char *, int);
CODE:
	func   = INT2PTR(int(*)(char *, char *, int), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, i2);
OUTPUT:
	RETVAL

int
nci_itip( c_func, t0, i1, p2 )
	SV* c_func
	char * t0
	int i1
	void * p2
PREINIT:
	int(*func)(char *, int, void *);
CODE:
	func   = INT2PTR(int(*)(char *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, p2);
OUTPUT:
	RETVAL

int
nci_itid( c_func, t0, i1, d2 )
	SV* c_func
	char * t0
	int i1
	double d2
PREINIT:
	int(*func)(char *, int, double);
CODE:
	func   = INT2PTR(int(*)(char *, int, double), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, d2);
OUTPUT:
	RETVAL

int
nci_itis( c_func, t0, i1, s2 )
	SV* c_func
	char * t0
	int i1
	short s2
PREINIT:
	int(*func)(char *, int, short);
CODE:
	func   = INT2PTR(int(*)(char *, int, short), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, s2);
OUTPUT:
	RETVAL

int
nci_itif( c_func, t0, i1, f2 )
	SV* c_func
	char * t0
	int i1
	float f2
PREINIT:
	int(*func)(char *, int, float);
CODE:
	func   = INT2PTR(int(*)(char *, int, float), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, f2);
OUTPUT:
	RETVAL

int
nci_itit( c_func, t0, i1, t2 )
	SV* c_func
	char * t0
	int i1
	char * t2
PREINIT:
	int(*func)(char *, int, char *);
CODE:
	func   = INT2PTR(int(*)(char *, int, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, t2);
OUTPUT:
	RETVAL

int
nci_itii( c_func, t0, i1, i2 )
	SV* c_func
	char * t0
	int i1
	int i2
PREINIT:
	int(*func)(char *, int, int);
CODE:
	func   = INT2PTR(int(*)(char *, int, int), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, i2);
OUTPUT:
	RETVAL

int
nci_iipp( c_func, i0, p1, p2 )
	SV* c_func
	int i0
	void * p1
	void * p2
PREINIT:
	int(*func)(int, void *, void *);
CODE:
	func   = INT2PTR(int(*)(int, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, p2);
OUTPUT:
	RETVAL

int
nci_iipd( c_func, i0, p1, d2 )
	SV* c_func
	int i0
	void * p1
	double d2
PREINIT:
	int(*func)(int, void *, double);
CODE:
	func   = INT2PTR(int(*)(int, void *, double), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, d2);
OUTPUT:
	RETVAL

int
nci_iips( c_func, i0, p1, s2 )
	SV* c_func
	int i0
	void * p1
	short s2
PREINIT:
	int(*func)(int, void *, short);
CODE:
	func   = INT2PTR(int(*)(int, void *, short), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, s2);
OUTPUT:
	RETVAL

int
nci_iipf( c_func, i0, p1, f2 )
	SV* c_func
	int i0
	void * p1
	float f2
PREINIT:
	int(*func)(int, void *, float);
CODE:
	func   = INT2PTR(int(*)(int, void *, float), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, f2);
OUTPUT:
	RETVAL

int
nci_iipt( c_func, i0, p1, t2 )
	SV* c_func
	int i0
	void * p1
	char * t2
PREINIT:
	int(*func)(int, void *, char *);
CODE:
	func   = INT2PTR(int(*)(int, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, t2);
OUTPUT:
	RETVAL

int
nci_iipi( c_func, i0, p1, i2 )
	SV* c_func
	int i0
	void * p1
	int i2
PREINIT:
	int(*func)(int, void *, int);
CODE:
	func   = INT2PTR(int(*)(int, void *, int), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, i2);
OUTPUT:
	RETVAL

int
nci_iidp( c_func, i0, d1, p2 )
	SV* c_func
	int i0
	double d1
	void * p2
PREINIT:
	int(*func)(int, double, void *);
CODE:
	func   = INT2PTR(int(*)(int, double, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, p2);
OUTPUT:
	RETVAL

int
nci_iidd( c_func, i0, d1, d2 )
	SV* c_func
	int i0
	double d1
	double d2
PREINIT:
	int(*func)(int, double, double);
CODE:
	func   = INT2PTR(int(*)(int, double, double), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, d2);
OUTPUT:
	RETVAL

int
nci_iids( c_func, i0, d1, s2 )
	SV* c_func
	int i0
	double d1
	short s2
PREINIT:
	int(*func)(int, double, short);
CODE:
	func   = INT2PTR(int(*)(int, double, short), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, s2);
OUTPUT:
	RETVAL

int
nci_iidf( c_func, i0, d1, f2 )
	SV* c_func
	int i0
	double d1
	float f2
PREINIT:
	int(*func)(int, double, float);
CODE:
	func   = INT2PTR(int(*)(int, double, float), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, f2);
OUTPUT:
	RETVAL

int
nci_iidt( c_func, i0, d1, t2 )
	SV* c_func
	int i0
	double d1
	char * t2
PREINIT:
	int(*func)(int, double, char *);
CODE:
	func   = INT2PTR(int(*)(int, double, char *), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, t2);
OUTPUT:
	RETVAL

int
nci_iidi( c_func, i0, d1, i2 )
	SV* c_func
	int i0
	double d1
	int i2
PREINIT:
	int(*func)(int, double, int);
CODE:
	func   = INT2PTR(int(*)(int, double, int), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, i2);
OUTPUT:
	RETVAL

int
nci_iisp( c_func, i0, s1, p2 )
	SV* c_func
	int i0
	short s1
	void * p2
PREINIT:
	int(*func)(int, short, void *);
CODE:
	func   = INT2PTR(int(*)(int, short, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, p2);
OUTPUT:
	RETVAL

int
nci_iisd( c_func, i0, s1, d2 )
	SV* c_func
	int i0
	short s1
	double d2
PREINIT:
	int(*func)(int, short, double);
CODE:
	func   = INT2PTR(int(*)(int, short, double), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, d2);
OUTPUT:
	RETVAL

int
nci_iiss( c_func, i0, s1, s2 )
	SV* c_func
	int i0
	short s1
	short s2
PREINIT:
	int(*func)(int, short, short);
CODE:
	func   = INT2PTR(int(*)(int, short, short), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, s2);
OUTPUT:
	RETVAL

int
nci_iisf( c_func, i0, s1, f2 )
	SV* c_func
	int i0
	short s1
	float f2
PREINIT:
	int(*func)(int, short, float);
CODE:
	func   = INT2PTR(int(*)(int, short, float), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, f2);
OUTPUT:
	RETVAL

int
nci_iist( c_func, i0, s1, t2 )
	SV* c_func
	int i0
	short s1
	char * t2
PREINIT:
	int(*func)(int, short, char *);
CODE:
	func   = INT2PTR(int(*)(int, short, char *), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, t2);
OUTPUT:
	RETVAL

int
nci_iisi( c_func, i0, s1, i2 )
	SV* c_func
	int i0
	short s1
	int i2
PREINIT:
	int(*func)(int, short, int);
CODE:
	func   = INT2PTR(int(*)(int, short, int), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, i2);
OUTPUT:
	RETVAL

int
nci_iifp( c_func, i0, f1, p2 )
	SV* c_func
	int i0
	float f1
	void * p2
PREINIT:
	int(*func)(int, float, void *);
CODE:
	func   = INT2PTR(int(*)(int, float, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, p2);
OUTPUT:
	RETVAL

int
nci_iifd( c_func, i0, f1, d2 )
	SV* c_func
	int i0
	float f1
	double d2
PREINIT:
	int(*func)(int, float, double);
CODE:
	func   = INT2PTR(int(*)(int, float, double), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, d2);
OUTPUT:
	RETVAL

int
nci_iifs( c_func, i0, f1, s2 )
	SV* c_func
	int i0
	float f1
	short s2
PREINIT:
	int(*func)(int, float, short);
CODE:
	func   = INT2PTR(int(*)(int, float, short), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, s2);
OUTPUT:
	RETVAL

int
nci_iiff( c_func, i0, f1, f2 )
	SV* c_func
	int i0
	float f1
	float f2
PREINIT:
	int(*func)(int, float, float);
CODE:
	func   = INT2PTR(int(*)(int, float, float), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, f2);
OUTPUT:
	RETVAL

int
nci_iift( c_func, i0, f1, t2 )
	SV* c_func
	int i0
	float f1
	char * t2
PREINIT:
	int(*func)(int, float, char *);
CODE:
	func   = INT2PTR(int(*)(int, float, char *), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, t2);
OUTPUT:
	RETVAL

int
nci_iifi( c_func, i0, f1, i2 )
	SV* c_func
	int i0
	float f1
	int i2
PREINIT:
	int(*func)(int, float, int);
CODE:
	func   = INT2PTR(int(*)(int, float, int), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, i2);
OUTPUT:
	RETVAL

int
nci_iitp( c_func, i0, t1, p2 )
	SV* c_func
	int i0
	char * t1
	void * p2
PREINIT:
	int(*func)(int, char *, void *);
CODE:
	func   = INT2PTR(int(*)(int, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, p2);
OUTPUT:
	RETVAL

int
nci_iitd( c_func, i0, t1, d2 )
	SV* c_func
	int i0
	char * t1
	double d2
PREINIT:
	int(*func)(int, char *, double);
CODE:
	func   = INT2PTR(int(*)(int, char *, double), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, d2);
OUTPUT:
	RETVAL

int
nci_iits( c_func, i0, t1, s2 )
	SV* c_func
	int i0
	char * t1
	short s2
PREINIT:
	int(*func)(int, char *, short);
CODE:
	func   = INT2PTR(int(*)(int, char *, short), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, s2);
OUTPUT:
	RETVAL

int
nci_iitf( c_func, i0, t1, f2 )
	SV* c_func
	int i0
	char * t1
	float f2
PREINIT:
	int(*func)(int, char *, float);
CODE:
	func   = INT2PTR(int(*)(int, char *, float), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, f2);
OUTPUT:
	RETVAL

int
nci_iitt( c_func, i0, t1, t2 )
	SV* c_func
	int i0
	char * t1
	char * t2
PREINIT:
	int(*func)(int, char *, char *);
CODE:
	func   = INT2PTR(int(*)(int, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, t2);
OUTPUT:
	RETVAL

int
nci_iiti( c_func, i0, t1, i2 )
	SV* c_func
	int i0
	char * t1
	int i2
PREINIT:
	int(*func)(int, char *, int);
CODE:
	func   = INT2PTR(int(*)(int, char *, int), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, i2);
OUTPUT:
	RETVAL

int
nci_iiip( c_func, i0, i1, p2 )
	SV* c_func
	int i0
	int i1
	void * p2
PREINIT:
	int(*func)(int, int, void *);
CODE:
	func   = INT2PTR(int(*)(int, int, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, p2);
OUTPUT:
	RETVAL

int
nci_iiid( c_func, i0, i1, d2 )
	SV* c_func
	int i0
	int i1
	double d2
PREINIT:
	int(*func)(int, int, double);
CODE:
	func   = INT2PTR(int(*)(int, int, double), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, d2);
OUTPUT:
	RETVAL

int
nci_iiis( c_func, i0, i1, s2 )
	SV* c_func
	int i0
	int i1
	short s2
PREINIT:
	int(*func)(int, int, short);
CODE:
	func   = INT2PTR(int(*)(int, int, short), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, s2);
OUTPUT:
	RETVAL

int
nci_iiif( c_func, i0, i1, f2 )
	SV* c_func
	int i0
	int i1
	float f2
PREINIT:
	int(*func)(int, int, float);
CODE:
	func   = INT2PTR(int(*)(int, int, float), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, f2);
OUTPUT:
	RETVAL

int
nci_iiit( c_func, i0, i1, t2 )
	SV* c_func
	int i0
	int i1
	char * t2
PREINIT:
	int(*func)(int, int, char *);
CODE:
	func   = INT2PTR(int(*)(int, int, char *), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, t2);
OUTPUT:
	RETVAL

int
nci_iiii( c_func, i0, i1, i2 )
	SV* c_func
	int i0
	int i1
	int i2
PREINIT:
	int(*func)(int, int, int);
CODE:
	func   = INT2PTR(int(*)(int, int, int), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, i2);
OUTPUT:
	RETVAL

void
nci_vpppp( c_func, p0, p1, p2, p3 )
	SV* c_func
	void * p0
	void * p1
	void * p2
	void * p3
PREINIT:
	void(*func)(void *, void *, void *, void *);
CODE:
	func   = INT2PTR(void(*)(void *, void *, void *, void *), SvIV(c_func) );
	(*func)(p0, p1, p2, p3);

void
nci_vpppd( c_func, p0, p1, p2, d3 )
	SV* c_func
	void * p0
	void * p1
	void * p2
	double d3
PREINIT:
	void(*func)(void *, void *, void *, double);
CODE:
	func   = INT2PTR(void(*)(void *, void *, void *, double), SvIV(c_func) );
	(*func)(p0, p1, p2, d3);

void
nci_vppps( c_func, p0, p1, p2, s3 )
	SV* c_func
	void * p0
	void * p1
	void * p2
	short s3
PREINIT:
	void(*func)(void *, void *, void *, short);
CODE:
	func   = INT2PTR(void(*)(void *, void *, void *, short), SvIV(c_func) );
	(*func)(p0, p1, p2, s3);

void
nci_vpppf( c_func, p0, p1, p2, f3 )
	SV* c_func
	void * p0
	void * p1
	void * p2
	float f3
PREINIT:
	void(*func)(void *, void *, void *, float);
CODE:
	func   = INT2PTR(void(*)(void *, void *, void *, float), SvIV(c_func) );
	(*func)(p0, p1, p2, f3);

void
nci_vpppt( c_func, p0, p1, p2, t3 )
	SV* c_func
	void * p0
	void * p1
	void * p2
	char * t3
PREINIT:
	void(*func)(void *, void *, void *, char *);
CODE:
	func   = INT2PTR(void(*)(void *, void *, void *, char *), SvIV(c_func) );
	(*func)(p0, p1, p2, t3);

void
nci_vpppi( c_func, p0, p1, p2, i3 )
	SV* c_func
	void * p0
	void * p1
	void * p2
	int i3
PREINIT:
	void(*func)(void *, void *, void *, int);
CODE:
	func   = INT2PTR(void(*)(void *, void *, void *, int), SvIV(c_func) );
	(*func)(p0, p1, p2, i3);

void
nci_vppdp( c_func, p0, p1, d2, p3 )
	SV* c_func
	void * p0
	void * p1
	double d2
	void * p3
PREINIT:
	void(*func)(void *, void *, double, void *);
CODE:
	func   = INT2PTR(void(*)(void *, void *, double, void *), SvIV(c_func) );
	(*func)(p0, p1, d2, p3);

void
nci_vppdd( c_func, p0, p1, d2, d3 )
	SV* c_func
	void * p0
	void * p1
	double d2
	double d3
PREINIT:
	void(*func)(void *, void *, double, double);
CODE:
	func   = INT2PTR(void(*)(void *, void *, double, double), SvIV(c_func) );
	(*func)(p0, p1, d2, d3);

void
nci_vppds( c_func, p0, p1, d2, s3 )
	SV* c_func
	void * p0
	void * p1
	double d2
	short s3
PREINIT:
	void(*func)(void *, void *, double, short);
CODE:
	func   = INT2PTR(void(*)(void *, void *, double, short), SvIV(c_func) );
	(*func)(p0, p1, d2, s3);

void
nci_vppdf( c_func, p0, p1, d2, f3 )
	SV* c_func
	void * p0
	void * p1
	double d2
	float f3
PREINIT:
	void(*func)(void *, void *, double, float);
CODE:
	func   = INT2PTR(void(*)(void *, void *, double, float), SvIV(c_func) );
	(*func)(p0, p1, d2, f3);

void
nci_vppdt( c_func, p0, p1, d2, t3 )
	SV* c_func
	void * p0
	void * p1
	double d2
	char * t3
PREINIT:
	void(*func)(void *, void *, double, char *);
CODE:
	func   = INT2PTR(void(*)(void *, void *, double, char *), SvIV(c_func) );
	(*func)(p0, p1, d2, t3);

void
nci_vppdi( c_func, p0, p1, d2, i3 )
	SV* c_func
	void * p0
	void * p1
	double d2
	int i3
PREINIT:
	void(*func)(void *, void *, double, int);
CODE:
	func   = INT2PTR(void(*)(void *, void *, double, int), SvIV(c_func) );
	(*func)(p0, p1, d2, i3);

void
nci_vppsp( c_func, p0, p1, s2, p3 )
	SV* c_func
	void * p0
	void * p1
	short s2
	void * p3
PREINIT:
	void(*func)(void *, void *, short, void *);
CODE:
	func   = INT2PTR(void(*)(void *, void *, short, void *), SvIV(c_func) );
	(*func)(p0, p1, s2, p3);

void
nci_vppsd( c_func, p0, p1, s2, d3 )
	SV* c_func
	void * p0
	void * p1
	short s2
	double d3
PREINIT:
	void(*func)(void *, void *, short, double);
CODE:
	func   = INT2PTR(void(*)(void *, void *, short, double), SvIV(c_func) );
	(*func)(p0, p1, s2, d3);

void
nci_vppss( c_func, p0, p1, s2, s3 )
	SV* c_func
	void * p0
	void * p1
	short s2
	short s3
PREINIT:
	void(*func)(void *, void *, short, short);
CODE:
	func   = INT2PTR(void(*)(void *, void *, short, short), SvIV(c_func) );
	(*func)(p0, p1, s2, s3);

void
nci_vppsf( c_func, p0, p1, s2, f3 )
	SV* c_func
	void * p0
	void * p1
	short s2
	float f3
PREINIT:
	void(*func)(void *, void *, short, float);
CODE:
	func   = INT2PTR(void(*)(void *, void *, short, float), SvIV(c_func) );
	(*func)(p0, p1, s2, f3);

void
nci_vppst( c_func, p0, p1, s2, t3 )
	SV* c_func
	void * p0
	void * p1
	short s2
	char * t3
PREINIT:
	void(*func)(void *, void *, short, char *);
CODE:
	func   = INT2PTR(void(*)(void *, void *, short, char *), SvIV(c_func) );
	(*func)(p0, p1, s2, t3);

void
nci_vppsi( c_func, p0, p1, s2, i3 )
	SV* c_func
	void * p0
	void * p1
	short s2
	int i3
PREINIT:
	void(*func)(void *, void *, short, int);
CODE:
	func   = INT2PTR(void(*)(void *, void *, short, int), SvIV(c_func) );
	(*func)(p0, p1, s2, i3);

void
nci_vppfp( c_func, p0, p1, f2, p3 )
	SV* c_func
	void * p0
	void * p1
	float f2
	void * p3
PREINIT:
	void(*func)(void *, void *, float, void *);
CODE:
	func   = INT2PTR(void(*)(void *, void *, float, void *), SvIV(c_func) );
	(*func)(p0, p1, f2, p3);

void
nci_vppfd( c_func, p0, p1, f2, d3 )
	SV* c_func
	void * p0
	void * p1
	float f2
	double d3
PREINIT:
	void(*func)(void *, void *, float, double);
CODE:
	func   = INT2PTR(void(*)(void *, void *, float, double), SvIV(c_func) );
	(*func)(p0, p1, f2, d3);

void
nci_vppfs( c_func, p0, p1, f2, s3 )
	SV* c_func
	void * p0
	void * p1
	float f2
	short s3
PREINIT:
	void(*func)(void *, void *, float, short);
CODE:
	func   = INT2PTR(void(*)(void *, void *, float, short), SvIV(c_func) );
	(*func)(p0, p1, f2, s3);

void
nci_vppff( c_func, p0, p1, f2, f3 )
	SV* c_func
	void * p0
	void * p1
	float f2
	float f3
PREINIT:
	void(*func)(void *, void *, float, float);
CODE:
	func   = INT2PTR(void(*)(void *, void *, float, float), SvIV(c_func) );
	(*func)(p0, p1, f2, f3);

void
nci_vppft( c_func, p0, p1, f2, t3 )
	SV* c_func
	void * p0
	void * p1
	float f2
	char * t3
PREINIT:
	void(*func)(void *, void *, float, char *);
CODE:
	func   = INT2PTR(void(*)(void *, void *, float, char *), SvIV(c_func) );
	(*func)(p0, p1, f2, t3);

void
nci_vppfi( c_func, p0, p1, f2, i3 )
	SV* c_func
	void * p0
	void * p1
	float f2
	int i3
PREINIT:
	void(*func)(void *, void *, float, int);
CODE:
	func   = INT2PTR(void(*)(void *, void *, float, int), SvIV(c_func) );
	(*func)(p0, p1, f2, i3);

void
nci_vpptp( c_func, p0, p1, t2, p3 )
	SV* c_func
	void * p0
	void * p1
	char * t2
	void * p3
PREINIT:
	void(*func)(void *, void *, char *, void *);
CODE:
	func   = INT2PTR(void(*)(void *, void *, char *, void *), SvIV(c_func) );
	(*func)(p0, p1, t2, p3);

void
nci_vpptd( c_func, p0, p1, t2, d3 )
	SV* c_func
	void * p0
	void * p1
	char * t2
	double d3
PREINIT:
	void(*func)(void *, void *, char *, double);
CODE:
	func   = INT2PTR(void(*)(void *, void *, char *, double), SvIV(c_func) );
	(*func)(p0, p1, t2, d3);

void
nci_vppts( c_func, p0, p1, t2, s3 )
	SV* c_func
	void * p0
	void * p1
	char * t2
	short s3
PREINIT:
	void(*func)(void *, void *, char *, short);
CODE:
	func   = INT2PTR(void(*)(void *, void *, char *, short), SvIV(c_func) );
	(*func)(p0, p1, t2, s3);

void
nci_vpptf( c_func, p0, p1, t2, f3 )
	SV* c_func
	void * p0
	void * p1
	char * t2
	float f3
PREINIT:
	void(*func)(void *, void *, char *, float);
CODE:
	func   = INT2PTR(void(*)(void *, void *, char *, float), SvIV(c_func) );
	(*func)(p0, p1, t2, f3);

void
nci_vpptt( c_func, p0, p1, t2, t3 )
	SV* c_func
	void * p0
	void * p1
	char * t2
	char * t3
PREINIT:
	void(*func)(void *, void *, char *, char *);
CODE:
	func   = INT2PTR(void(*)(void *, void *, char *, char *), SvIV(c_func) );
	(*func)(p0, p1, t2, t3);

void
nci_vppti( c_func, p0, p1, t2, i3 )
	SV* c_func
	void * p0
	void * p1
	char * t2
	int i3
PREINIT:
	void(*func)(void *, void *, char *, int);
CODE:
	func   = INT2PTR(void(*)(void *, void *, char *, int), SvIV(c_func) );
	(*func)(p0, p1, t2, i3);

void
nci_vppip( c_func, p0, p1, i2, p3 )
	SV* c_func
	void * p0
	void * p1
	int i2
	void * p3
PREINIT:
	void(*func)(void *, void *, int, void *);
CODE:
	func   = INT2PTR(void(*)(void *, void *, int, void *), SvIV(c_func) );
	(*func)(p0, p1, i2, p3);

void
nci_vppid( c_func, p0, p1, i2, d3 )
	SV* c_func
	void * p0
	void * p1
	int i2
	double d3
PREINIT:
	void(*func)(void *, void *, int, double);
CODE:
	func   = INT2PTR(void(*)(void *, void *, int, double), SvIV(c_func) );
	(*func)(p0, p1, i2, d3);

void
nci_vppis( c_func, p0, p1, i2, s3 )
	SV* c_func
	void * p0
	void * p1
	int i2
	short s3
PREINIT:
	void(*func)(void *, void *, int, short);
CODE:
	func   = INT2PTR(void(*)(void *, void *, int, short), SvIV(c_func) );
	(*func)(p0, p1, i2, s3);

void
nci_vppif( c_func, p0, p1, i2, f3 )
	SV* c_func
	void * p0
	void * p1
	int i2
	float f3
PREINIT:
	void(*func)(void *, void *, int, float);
CODE:
	func   = INT2PTR(void(*)(void *, void *, int, float), SvIV(c_func) );
	(*func)(p0, p1, i2, f3);

void
nci_vppit( c_func, p0, p1, i2, t3 )
	SV* c_func
	void * p0
	void * p1
	int i2
	char * t3
PREINIT:
	void(*func)(void *, void *, int, char *);
CODE:
	func   = INT2PTR(void(*)(void *, void *, int, char *), SvIV(c_func) );
	(*func)(p0, p1, i2, t3);

void
nci_vppii( c_func, p0, p1, i2, i3 )
	SV* c_func
	void * p0
	void * p1
	int i2
	int i3
PREINIT:
	void(*func)(void *, void *, int, int);
CODE:
	func   = INT2PTR(void(*)(void *, void *, int, int), SvIV(c_func) );
	(*func)(p0, p1, i2, i3);

void
nci_vpdpp( c_func, p0, d1, p2, p3 )
	SV* c_func
	void * p0
	double d1
	void * p2
	void * p3
PREINIT:
	void(*func)(void *, double, void *, void *);
CODE:
	func   = INT2PTR(void(*)(void *, double, void *, void *), SvIV(c_func) );
	(*func)(p0, d1, p2, p3);

void
nci_vpdpd( c_func, p0, d1, p2, d3 )
	SV* c_func
	void * p0
	double d1
	void * p2
	double d3
PREINIT:
	void(*func)(void *, double, void *, double);
CODE:
	func   = INT2PTR(void(*)(void *, double, void *, double), SvIV(c_func) );
	(*func)(p0, d1, p2, d3);

void
nci_vpdps( c_func, p0, d1, p2, s3 )
	SV* c_func
	void * p0
	double d1
	void * p2
	short s3
PREINIT:
	void(*func)(void *, double, void *, short);
CODE:
	func   = INT2PTR(void(*)(void *, double, void *, short), SvIV(c_func) );
	(*func)(p0, d1, p2, s3);

void
nci_vpdpf( c_func, p0, d1, p2, f3 )
	SV* c_func
	void * p0
	double d1
	void * p2
	float f3
PREINIT:
	void(*func)(void *, double, void *, float);
CODE:
	func   = INT2PTR(void(*)(void *, double, void *, float), SvIV(c_func) );
	(*func)(p0, d1, p2, f3);

void
nci_vpdpt( c_func, p0, d1, p2, t3 )
	SV* c_func
	void * p0
	double d1
	void * p2
	char * t3
PREINIT:
	void(*func)(void *, double, void *, char *);
CODE:
	func   = INT2PTR(void(*)(void *, double, void *, char *), SvIV(c_func) );
	(*func)(p0, d1, p2, t3);

void
nci_vpdpi( c_func, p0, d1, p2, i3 )
	SV* c_func
	void * p0
	double d1
	void * p2
	int i3
PREINIT:
	void(*func)(void *, double, void *, int);
CODE:
	func   = INT2PTR(void(*)(void *, double, void *, int), SvIV(c_func) );
	(*func)(p0, d1, p2, i3);

void
nci_vpddp( c_func, p0, d1, d2, p3 )
	SV* c_func
	void * p0
	double d1
	double d2
	void * p3
PREINIT:
	void(*func)(void *, double, double, void *);
CODE:
	func   = INT2PTR(void(*)(void *, double, double, void *), SvIV(c_func) );
	(*func)(p0, d1, d2, p3);

void
nci_vpddd( c_func, p0, d1, d2, d3 )
	SV* c_func
	void * p0
	double d1
	double d2
	double d3
PREINIT:
	void(*func)(void *, double, double, double);
CODE:
	func   = INT2PTR(void(*)(void *, double, double, double), SvIV(c_func) );
	(*func)(p0, d1, d2, d3);

void
nci_vpdds( c_func, p0, d1, d2, s3 )
	SV* c_func
	void * p0
	double d1
	double d2
	short s3
PREINIT:
	void(*func)(void *, double, double, short);
CODE:
	func   = INT2PTR(void(*)(void *, double, double, short), SvIV(c_func) );
	(*func)(p0, d1, d2, s3);

void
nci_vpddf( c_func, p0, d1, d2, f3 )
	SV* c_func
	void * p0
	double d1
	double d2
	float f3
PREINIT:
	void(*func)(void *, double, double, float);
CODE:
	func   = INT2PTR(void(*)(void *, double, double, float), SvIV(c_func) );
	(*func)(p0, d1, d2, f3);

void
nci_vpddt( c_func, p0, d1, d2, t3 )
	SV* c_func
	void * p0
	double d1
	double d2
	char * t3
PREINIT:
	void(*func)(void *, double, double, char *);
CODE:
	func   = INT2PTR(void(*)(void *, double, double, char *), SvIV(c_func) );
	(*func)(p0, d1, d2, t3);

void
nci_vpddi( c_func, p0, d1, d2, i3 )
	SV* c_func
	void * p0
	double d1
	double d2
	int i3
PREINIT:
	void(*func)(void *, double, double, int);
CODE:
	func   = INT2PTR(void(*)(void *, double, double, int), SvIV(c_func) );
	(*func)(p0, d1, d2, i3);

void
nci_vpdsp( c_func, p0, d1, s2, p3 )
	SV* c_func
	void * p0
	double d1
	short s2
	void * p3
PREINIT:
	void(*func)(void *, double, short, void *);
CODE:
	func   = INT2PTR(void(*)(void *, double, short, void *), SvIV(c_func) );
	(*func)(p0, d1, s2, p3);

void
nci_vpdsd( c_func, p0, d1, s2, d3 )
	SV* c_func
	void * p0
	double d1
	short s2
	double d3
PREINIT:
	void(*func)(void *, double, short, double);
CODE:
	func   = INT2PTR(void(*)(void *, double, short, double), SvIV(c_func) );
	(*func)(p0, d1, s2, d3);

void
nci_vpdss( c_func, p0, d1, s2, s3 )
	SV* c_func
	void * p0
	double d1
	short s2
	short s3
PREINIT:
	void(*func)(void *, double, short, short);
CODE:
	func   = INT2PTR(void(*)(void *, double, short, short), SvIV(c_func) );
	(*func)(p0, d1, s2, s3);

void
nci_vpdsf( c_func, p0, d1, s2, f3 )
	SV* c_func
	void * p0
	double d1
	short s2
	float f3
PREINIT:
	void(*func)(void *, double, short, float);
CODE:
	func   = INT2PTR(void(*)(void *, double, short, float), SvIV(c_func) );
	(*func)(p0, d1, s2, f3);

void
nci_vpdst( c_func, p0, d1, s2, t3 )
	SV* c_func
	void * p0
	double d1
	short s2
	char * t3
PREINIT:
	void(*func)(void *, double, short, char *);
CODE:
	func   = INT2PTR(void(*)(void *, double, short, char *), SvIV(c_func) );
	(*func)(p0, d1, s2, t3);

void
nci_vpdsi( c_func, p0, d1, s2, i3 )
	SV* c_func
	void * p0
	double d1
	short s2
	int i3
PREINIT:
	void(*func)(void *, double, short, int);
CODE:
	func   = INT2PTR(void(*)(void *, double, short, int), SvIV(c_func) );
	(*func)(p0, d1, s2, i3);

void
nci_vpdfp( c_func, p0, d1, f2, p3 )
	SV* c_func
	void * p0
	double d1
	float f2
	void * p3
PREINIT:
	void(*func)(void *, double, float, void *);
CODE:
	func   = INT2PTR(void(*)(void *, double, float, void *), SvIV(c_func) );
	(*func)(p0, d1, f2, p3);

void
nci_vpdfd( c_func, p0, d1, f2, d3 )
	SV* c_func
	void * p0
	double d1
	float f2
	double d3
PREINIT:
	void(*func)(void *, double, float, double);
CODE:
	func   = INT2PTR(void(*)(void *, double, float, double), SvIV(c_func) );
	(*func)(p0, d1, f2, d3);

void
nci_vpdfs( c_func, p0, d1, f2, s3 )
	SV* c_func
	void * p0
	double d1
	float f2
	short s3
PREINIT:
	void(*func)(void *, double, float, short);
CODE:
	func   = INT2PTR(void(*)(void *, double, float, short), SvIV(c_func) );
	(*func)(p0, d1, f2, s3);

void
nci_vpdff( c_func, p0, d1, f2, f3 )
	SV* c_func
	void * p0
	double d1
	float f2
	float f3
PREINIT:
	void(*func)(void *, double, float, float);
CODE:
	func   = INT2PTR(void(*)(void *, double, float, float), SvIV(c_func) );
	(*func)(p0, d1, f2, f3);

void
nci_vpdft( c_func, p0, d1, f2, t3 )
	SV* c_func
	void * p0
	double d1
	float f2
	char * t3
PREINIT:
	void(*func)(void *, double, float, char *);
CODE:
	func   = INT2PTR(void(*)(void *, double, float, char *), SvIV(c_func) );
	(*func)(p0, d1, f2, t3);

void
nci_vpdfi( c_func, p0, d1, f2, i3 )
	SV* c_func
	void * p0
	double d1
	float f2
	int i3
PREINIT:
	void(*func)(void *, double, float, int);
CODE:
	func   = INT2PTR(void(*)(void *, double, float, int), SvIV(c_func) );
	(*func)(p0, d1, f2, i3);

void
nci_vpdtp( c_func, p0, d1, t2, p3 )
	SV* c_func
	void * p0
	double d1
	char * t2
	void * p3
PREINIT:
	void(*func)(void *, double, char *, void *);
CODE:
	func   = INT2PTR(void(*)(void *, double, char *, void *), SvIV(c_func) );
	(*func)(p0, d1, t2, p3);

void
nci_vpdtd( c_func, p0, d1, t2, d3 )
	SV* c_func
	void * p0
	double d1
	char * t2
	double d3
PREINIT:
	void(*func)(void *, double, char *, double);
CODE:
	func   = INT2PTR(void(*)(void *, double, char *, double), SvIV(c_func) );
	(*func)(p0, d1, t2, d3);

void
nci_vpdts( c_func, p0, d1, t2, s3 )
	SV* c_func
	void * p0
	double d1
	char * t2
	short s3
PREINIT:
	void(*func)(void *, double, char *, short);
CODE:
	func   = INT2PTR(void(*)(void *, double, char *, short), SvIV(c_func) );
	(*func)(p0, d1, t2, s3);

void
nci_vpdtf( c_func, p0, d1, t2, f3 )
	SV* c_func
	void * p0
	double d1
	char * t2
	float f3
PREINIT:
	void(*func)(void *, double, char *, float);
CODE:
	func   = INT2PTR(void(*)(void *, double, char *, float), SvIV(c_func) );
	(*func)(p0, d1, t2, f3);

void
nci_vpdtt( c_func, p0, d1, t2, t3 )
	SV* c_func
	void * p0
	double d1
	char * t2
	char * t3
PREINIT:
	void(*func)(void *, double, char *, char *);
CODE:
	func   = INT2PTR(void(*)(void *, double, char *, char *), SvIV(c_func) );
	(*func)(p0, d1, t2, t3);

void
nci_vpdti( c_func, p0, d1, t2, i3 )
	SV* c_func
	void * p0
	double d1
	char * t2
	int i3
PREINIT:
	void(*func)(void *, double, char *, int);
CODE:
	func   = INT2PTR(void(*)(void *, double, char *, int), SvIV(c_func) );
	(*func)(p0, d1, t2, i3);

void
nci_vpdip( c_func, p0, d1, i2, p3 )
	SV* c_func
	void * p0
	double d1
	int i2
	void * p3
PREINIT:
	void(*func)(void *, double, int, void *);
CODE:
	func   = INT2PTR(void(*)(void *, double, int, void *), SvIV(c_func) );
	(*func)(p0, d1, i2, p3);

void
nci_vpdid( c_func, p0, d1, i2, d3 )
	SV* c_func
	void * p0
	double d1
	int i2
	double d3
PREINIT:
	void(*func)(void *, double, int, double);
CODE:
	func   = INT2PTR(void(*)(void *, double, int, double), SvIV(c_func) );
	(*func)(p0, d1, i2, d3);

void
nci_vpdis( c_func, p0, d1, i2, s3 )
	SV* c_func
	void * p0
	double d1
	int i2
	short s3
PREINIT:
	void(*func)(void *, double, int, short);
CODE:
	func   = INT2PTR(void(*)(void *, double, int, short), SvIV(c_func) );
	(*func)(p0, d1, i2, s3);

void
nci_vpdif( c_func, p0, d1, i2, f3 )
	SV* c_func
	void * p0
	double d1
	int i2
	float f3
PREINIT:
	void(*func)(void *, double, int, float);
CODE:
	func   = INT2PTR(void(*)(void *, double, int, float), SvIV(c_func) );
	(*func)(p0, d1, i2, f3);

void
nci_vpdit( c_func, p0, d1, i2, t3 )
	SV* c_func
	void * p0
	double d1
	int i2
	char * t3
PREINIT:
	void(*func)(void *, double, int, char *);
CODE:
	func   = INT2PTR(void(*)(void *, double, int, char *), SvIV(c_func) );
	(*func)(p0, d1, i2, t3);

void
nci_vpdii( c_func, p0, d1, i2, i3 )
	SV* c_func
	void * p0
	double d1
	int i2
	int i3
PREINIT:
	void(*func)(void *, double, int, int);
CODE:
	func   = INT2PTR(void(*)(void *, double, int, int), SvIV(c_func) );
	(*func)(p0, d1, i2, i3);

void
nci_vpspp( c_func, p0, s1, p2, p3 )
	SV* c_func
	void * p0
	short s1
	void * p2
	void * p3
PREINIT:
	void(*func)(void *, short, void *, void *);
CODE:
	func   = INT2PTR(void(*)(void *, short, void *, void *), SvIV(c_func) );
	(*func)(p0, s1, p2, p3);

void
nci_vpspd( c_func, p0, s1, p2, d3 )
	SV* c_func
	void * p0
	short s1
	void * p2
	double d3
PREINIT:
	void(*func)(void *, short, void *, double);
CODE:
	func   = INT2PTR(void(*)(void *, short, void *, double), SvIV(c_func) );
	(*func)(p0, s1, p2, d3);

void
nci_vpsps( c_func, p0, s1, p2, s3 )
	SV* c_func
	void * p0
	short s1
	void * p2
	short s3
PREINIT:
	void(*func)(void *, short, void *, short);
CODE:
	func   = INT2PTR(void(*)(void *, short, void *, short), SvIV(c_func) );
	(*func)(p0, s1, p2, s3);

void
nci_vpspf( c_func, p0, s1, p2, f3 )
	SV* c_func
	void * p0
	short s1
	void * p2
	float f3
PREINIT:
	void(*func)(void *, short, void *, float);
CODE:
	func   = INT2PTR(void(*)(void *, short, void *, float), SvIV(c_func) );
	(*func)(p0, s1, p2, f3);

void
nci_vpspt( c_func, p0, s1, p2, t3 )
	SV* c_func
	void * p0
	short s1
	void * p2
	char * t3
PREINIT:
	void(*func)(void *, short, void *, char *);
CODE:
	func   = INT2PTR(void(*)(void *, short, void *, char *), SvIV(c_func) );
	(*func)(p0, s1, p2, t3);

void
nci_vpspi( c_func, p0, s1, p2, i3 )
	SV* c_func
	void * p0
	short s1
	void * p2
	int i3
PREINIT:
	void(*func)(void *, short, void *, int);
CODE:
	func   = INT2PTR(void(*)(void *, short, void *, int), SvIV(c_func) );
	(*func)(p0, s1, p2, i3);

void
nci_vpsdp( c_func, p0, s1, d2, p3 )
	SV* c_func
	void * p0
	short s1
	double d2
	void * p3
PREINIT:
	void(*func)(void *, short, double, void *);
CODE:
	func   = INT2PTR(void(*)(void *, short, double, void *), SvIV(c_func) );
	(*func)(p0, s1, d2, p3);

void
nci_vpsdd( c_func, p0, s1, d2, d3 )
	SV* c_func
	void * p0
	short s1
	double d2
	double d3
PREINIT:
	void(*func)(void *, short, double, double);
CODE:
	func   = INT2PTR(void(*)(void *, short, double, double), SvIV(c_func) );
	(*func)(p0, s1, d2, d3);

void
nci_vpsds( c_func, p0, s1, d2, s3 )
	SV* c_func
	void * p0
	short s1
	double d2
	short s3
PREINIT:
	void(*func)(void *, short, double, short);
CODE:
	func   = INT2PTR(void(*)(void *, short, double, short), SvIV(c_func) );
	(*func)(p0, s1, d2, s3);

void
nci_vpsdf( c_func, p0, s1, d2, f3 )
	SV* c_func
	void * p0
	short s1
	double d2
	float f3
PREINIT:
	void(*func)(void *, short, double, float);
CODE:
	func   = INT2PTR(void(*)(void *, short, double, float), SvIV(c_func) );
	(*func)(p0, s1, d2, f3);

void
nci_vpsdt( c_func, p0, s1, d2, t3 )
	SV* c_func
	void * p0
	short s1
	double d2
	char * t3
PREINIT:
	void(*func)(void *, short, double, char *);
CODE:
	func   = INT2PTR(void(*)(void *, short, double, char *), SvIV(c_func) );
	(*func)(p0, s1, d2, t3);

void
nci_vpsdi( c_func, p0, s1, d2, i3 )
	SV* c_func
	void * p0
	short s1
	double d2
	int i3
PREINIT:
	void(*func)(void *, short, double, int);
CODE:
	func   = INT2PTR(void(*)(void *, short, double, int), SvIV(c_func) );
	(*func)(p0, s1, d2, i3);

void
nci_vpssp( c_func, p0, s1, s2, p3 )
	SV* c_func
	void * p0
	short s1
	short s2
	void * p3
PREINIT:
	void(*func)(void *, short, short, void *);
CODE:
	func   = INT2PTR(void(*)(void *, short, short, void *), SvIV(c_func) );
	(*func)(p0, s1, s2, p3);

void
nci_vpssd( c_func, p0, s1, s2, d3 )
	SV* c_func
	void * p0
	short s1
	short s2
	double d3
PREINIT:
	void(*func)(void *, short, short, double);
CODE:
	func   = INT2PTR(void(*)(void *, short, short, double), SvIV(c_func) );
	(*func)(p0, s1, s2, d3);

void
nci_vpsss( c_func, p0, s1, s2, s3 )
	SV* c_func
	void * p0
	short s1
	short s2
	short s3
PREINIT:
	void(*func)(void *, short, short, short);
CODE:
	func   = INT2PTR(void(*)(void *, short, short, short), SvIV(c_func) );
	(*func)(p0, s1, s2, s3);

void
nci_vpssf( c_func, p0, s1, s2, f3 )
	SV* c_func
	void * p0
	short s1
	short s2
	float f3
PREINIT:
	void(*func)(void *, short, short, float);
CODE:
	func   = INT2PTR(void(*)(void *, short, short, float), SvIV(c_func) );
	(*func)(p0, s1, s2, f3);

void
nci_vpsst( c_func, p0, s1, s2, t3 )
	SV* c_func
	void * p0
	short s1
	short s2
	char * t3
PREINIT:
	void(*func)(void *, short, short, char *);
CODE:
	func   = INT2PTR(void(*)(void *, short, short, char *), SvIV(c_func) );
	(*func)(p0, s1, s2, t3);

void
nci_vpssi( c_func, p0, s1, s2, i3 )
	SV* c_func
	void * p0
	short s1
	short s2
	int i3
PREINIT:
	void(*func)(void *, short, short, int);
CODE:
	func   = INT2PTR(void(*)(void *, short, short, int), SvIV(c_func) );
	(*func)(p0, s1, s2, i3);

void
nci_vpsfp( c_func, p0, s1, f2, p3 )
	SV* c_func
	void * p0
	short s1
	float f2
	void * p3
PREINIT:
	void(*func)(void *, short, float, void *);
CODE:
	func   = INT2PTR(void(*)(void *, short, float, void *), SvIV(c_func) );
	(*func)(p0, s1, f2, p3);

void
nci_vpsfd( c_func, p0, s1, f2, d3 )
	SV* c_func
	void * p0
	short s1
	float f2
	double d3
PREINIT:
	void(*func)(void *, short, float, double);
CODE:
	func   = INT2PTR(void(*)(void *, short, float, double), SvIV(c_func) );
	(*func)(p0, s1, f2, d3);

void
nci_vpsfs( c_func, p0, s1, f2, s3 )
	SV* c_func
	void * p0
	short s1
	float f2
	short s3
PREINIT:
	void(*func)(void *, short, float, short);
CODE:
	func   = INT2PTR(void(*)(void *, short, float, short), SvIV(c_func) );
	(*func)(p0, s1, f2, s3);

void
nci_vpsff( c_func, p0, s1, f2, f3 )
	SV* c_func
	void * p0
	short s1
	float f2
	float f3
PREINIT:
	void(*func)(void *, short, float, float);
CODE:
	func   = INT2PTR(void(*)(void *, short, float, float), SvIV(c_func) );
	(*func)(p0, s1, f2, f3);

void
nci_vpsft( c_func, p0, s1, f2, t3 )
	SV* c_func
	void * p0
	short s1
	float f2
	char * t3
PREINIT:
	void(*func)(void *, short, float, char *);
CODE:
	func   = INT2PTR(void(*)(void *, short, float, char *), SvIV(c_func) );
	(*func)(p0, s1, f2, t3);

void
nci_vpsfi( c_func, p0, s1, f2, i3 )
	SV* c_func
	void * p0
	short s1
	float f2
	int i3
PREINIT:
	void(*func)(void *, short, float, int);
CODE:
	func   = INT2PTR(void(*)(void *, short, float, int), SvIV(c_func) );
	(*func)(p0, s1, f2, i3);

void
nci_vpstp( c_func, p0, s1, t2, p3 )
	SV* c_func
	void * p0
	short s1
	char * t2
	void * p3
PREINIT:
	void(*func)(void *, short, char *, void *);
CODE:
	func   = INT2PTR(void(*)(void *, short, char *, void *), SvIV(c_func) );
	(*func)(p0, s1, t2, p3);

void
nci_vpstd( c_func, p0, s1, t2, d3 )
	SV* c_func
	void * p0
	short s1
	char * t2
	double d3
PREINIT:
	void(*func)(void *, short, char *, double);
CODE:
	func   = INT2PTR(void(*)(void *, short, char *, double), SvIV(c_func) );
	(*func)(p0, s1, t2, d3);

void
nci_vpsts( c_func, p0, s1, t2, s3 )
	SV* c_func
	void * p0
	short s1
	char * t2
	short s3
PREINIT:
	void(*func)(void *, short, char *, short);
CODE:
	func   = INT2PTR(void(*)(void *, short, char *, short), SvIV(c_func) );
	(*func)(p0, s1, t2, s3);

void
nci_vpstf( c_func, p0, s1, t2, f3 )
	SV* c_func
	void * p0
	short s1
	char * t2
	float f3
PREINIT:
	void(*func)(void *, short, char *, float);
CODE:
	func   = INT2PTR(void(*)(void *, short, char *, float), SvIV(c_func) );
	(*func)(p0, s1, t2, f3);

void
nci_vpstt( c_func, p0, s1, t2, t3 )
	SV* c_func
	void * p0
	short s1
	char * t2
	char * t3
PREINIT:
	void(*func)(void *, short, char *, char *);
CODE:
	func   = INT2PTR(void(*)(void *, short, char *, char *), SvIV(c_func) );
	(*func)(p0, s1, t2, t3);

void
nci_vpsti( c_func, p0, s1, t2, i3 )
	SV* c_func
	void * p0
	short s1
	char * t2
	int i3
PREINIT:
	void(*func)(void *, short, char *, int);
CODE:
	func   = INT2PTR(void(*)(void *, short, char *, int), SvIV(c_func) );
	(*func)(p0, s1, t2, i3);

void
nci_vpsip( c_func, p0, s1, i2, p3 )
	SV* c_func
	void * p0
	short s1
	int i2
	void * p3
PREINIT:
	void(*func)(void *, short, int, void *);
CODE:
	func   = INT2PTR(void(*)(void *, short, int, void *), SvIV(c_func) );
	(*func)(p0, s1, i2, p3);

void
nci_vpsid( c_func, p0, s1, i2, d3 )
	SV* c_func
	void * p0
	short s1
	int i2
	double d3
PREINIT:
	void(*func)(void *, short, int, double);
CODE:
	func   = INT2PTR(void(*)(void *, short, int, double), SvIV(c_func) );
	(*func)(p0, s1, i2, d3);

void
nci_vpsis( c_func, p0, s1, i2, s3 )
	SV* c_func
	void * p0
	short s1
	int i2
	short s3
PREINIT:
	void(*func)(void *, short, int, short);
CODE:
	func   = INT2PTR(void(*)(void *, short, int, short), SvIV(c_func) );
	(*func)(p0, s1, i2, s3);

void
nci_vpsif( c_func, p0, s1, i2, f3 )
	SV* c_func
	void * p0
	short s1
	int i2
	float f3
PREINIT:
	void(*func)(void *, short, int, float);
CODE:
	func   = INT2PTR(void(*)(void *, short, int, float), SvIV(c_func) );
	(*func)(p0, s1, i2, f3);

void
nci_vpsit( c_func, p0, s1, i2, t3 )
	SV* c_func
	void * p0
	short s1
	int i2
	char * t3
PREINIT:
	void(*func)(void *, short, int, char *);
CODE:
	func   = INT2PTR(void(*)(void *, short, int, char *), SvIV(c_func) );
	(*func)(p0, s1, i2, t3);

void
nci_vpsii( c_func, p0, s1, i2, i3 )
	SV* c_func
	void * p0
	short s1
	int i2
	int i3
PREINIT:
	void(*func)(void *, short, int, int);
CODE:
	func   = INT2PTR(void(*)(void *, short, int, int), SvIV(c_func) );
	(*func)(p0, s1, i2, i3);

void
nci_vpfpp( c_func, p0, f1, p2, p3 )
	SV* c_func
	void * p0
	float f1
	void * p2
	void * p3
PREINIT:
	void(*func)(void *, float, void *, void *);
CODE:
	func   = INT2PTR(void(*)(void *, float, void *, void *), SvIV(c_func) );
	(*func)(p0, f1, p2, p3);

void
nci_vpfpd( c_func, p0, f1, p2, d3 )
	SV* c_func
	void * p0
	float f1
	void * p2
	double d3
PREINIT:
	void(*func)(void *, float, void *, double);
CODE:
	func   = INT2PTR(void(*)(void *, float, void *, double), SvIV(c_func) );
	(*func)(p0, f1, p2, d3);

void
nci_vpfps( c_func, p0, f1, p2, s3 )
	SV* c_func
	void * p0
	float f1
	void * p2
	short s3
PREINIT:
	void(*func)(void *, float, void *, short);
CODE:
	func   = INT2PTR(void(*)(void *, float, void *, short), SvIV(c_func) );
	(*func)(p0, f1, p2, s3);

void
nci_vpfpf( c_func, p0, f1, p2, f3 )
	SV* c_func
	void * p0
	float f1
	void * p2
	float f3
PREINIT:
	void(*func)(void *, float, void *, float);
CODE:
	func   = INT2PTR(void(*)(void *, float, void *, float), SvIV(c_func) );
	(*func)(p0, f1, p2, f3);

void
nci_vpfpt( c_func, p0, f1, p2, t3 )
	SV* c_func
	void * p0
	float f1
	void * p2
	char * t3
PREINIT:
	void(*func)(void *, float, void *, char *);
CODE:
	func   = INT2PTR(void(*)(void *, float, void *, char *), SvIV(c_func) );
	(*func)(p0, f1, p2, t3);

void
nci_vpfpi( c_func, p0, f1, p2, i3 )
	SV* c_func
	void * p0
	float f1
	void * p2
	int i3
PREINIT:
	void(*func)(void *, float, void *, int);
CODE:
	func   = INT2PTR(void(*)(void *, float, void *, int), SvIV(c_func) );
	(*func)(p0, f1, p2, i3);

void
nci_vpfdp( c_func, p0, f1, d2, p3 )
	SV* c_func
	void * p0
	float f1
	double d2
	void * p3
PREINIT:
	void(*func)(void *, float, double, void *);
CODE:
	func   = INT2PTR(void(*)(void *, float, double, void *), SvIV(c_func) );
	(*func)(p0, f1, d2, p3);

void
nci_vpfdd( c_func, p0, f1, d2, d3 )
	SV* c_func
	void * p0
	float f1
	double d2
	double d3
PREINIT:
	void(*func)(void *, float, double, double);
CODE:
	func   = INT2PTR(void(*)(void *, float, double, double), SvIV(c_func) );
	(*func)(p0, f1, d2, d3);

void
nci_vpfds( c_func, p0, f1, d2, s3 )
	SV* c_func
	void * p0
	float f1
	double d2
	short s3
PREINIT:
	void(*func)(void *, float, double, short);
CODE:
	func   = INT2PTR(void(*)(void *, float, double, short), SvIV(c_func) );
	(*func)(p0, f1, d2, s3);

void
nci_vpfdf( c_func, p0, f1, d2, f3 )
	SV* c_func
	void * p0
	float f1
	double d2
	float f3
PREINIT:
	void(*func)(void *, float, double, float);
CODE:
	func   = INT2PTR(void(*)(void *, float, double, float), SvIV(c_func) );
	(*func)(p0, f1, d2, f3);

void
nci_vpfdt( c_func, p0, f1, d2, t3 )
	SV* c_func
	void * p0
	float f1
	double d2
	char * t3
PREINIT:
	void(*func)(void *, float, double, char *);
CODE:
	func   = INT2PTR(void(*)(void *, float, double, char *), SvIV(c_func) );
	(*func)(p0, f1, d2, t3);

void
nci_vpfdi( c_func, p0, f1, d2, i3 )
	SV* c_func
	void * p0
	float f1
	double d2
	int i3
PREINIT:
	void(*func)(void *, float, double, int);
CODE:
	func   = INT2PTR(void(*)(void *, float, double, int), SvIV(c_func) );
	(*func)(p0, f1, d2, i3);

void
nci_vpfsp( c_func, p0, f1, s2, p3 )
	SV* c_func
	void * p0
	float f1
	short s2
	void * p3
PREINIT:
	void(*func)(void *, float, short, void *);
CODE:
	func   = INT2PTR(void(*)(void *, float, short, void *), SvIV(c_func) );
	(*func)(p0, f1, s2, p3);

void
nci_vpfsd( c_func, p0, f1, s2, d3 )
	SV* c_func
	void * p0
	float f1
	short s2
	double d3
PREINIT:
	void(*func)(void *, float, short, double);
CODE:
	func   = INT2PTR(void(*)(void *, float, short, double), SvIV(c_func) );
	(*func)(p0, f1, s2, d3);

void
nci_vpfss( c_func, p0, f1, s2, s3 )
	SV* c_func
	void * p0
	float f1
	short s2
	short s3
PREINIT:
	void(*func)(void *, float, short, short);
CODE:
	func   = INT2PTR(void(*)(void *, float, short, short), SvIV(c_func) );
	(*func)(p0, f1, s2, s3);

void
nci_vpfsf( c_func, p0, f1, s2, f3 )
	SV* c_func
	void * p0
	float f1
	short s2
	float f3
PREINIT:
	void(*func)(void *, float, short, float);
CODE:
	func   = INT2PTR(void(*)(void *, float, short, float), SvIV(c_func) );
	(*func)(p0, f1, s2, f3);

void
nci_vpfst( c_func, p0, f1, s2, t3 )
	SV* c_func
	void * p0
	float f1
	short s2
	char * t3
PREINIT:
	void(*func)(void *, float, short, char *);
CODE:
	func   = INT2PTR(void(*)(void *, float, short, char *), SvIV(c_func) );
	(*func)(p0, f1, s2, t3);

void
nci_vpfsi( c_func, p0, f1, s2, i3 )
	SV* c_func
	void * p0
	float f1
	short s2
	int i3
PREINIT:
	void(*func)(void *, float, short, int);
CODE:
	func   = INT2PTR(void(*)(void *, float, short, int), SvIV(c_func) );
	(*func)(p0, f1, s2, i3);

void
nci_vpffp( c_func, p0, f1, f2, p3 )
	SV* c_func
	void * p0
	float f1
	float f2
	void * p3
PREINIT:
	void(*func)(void *, float, float, void *);
CODE:
	func   = INT2PTR(void(*)(void *, float, float, void *), SvIV(c_func) );
	(*func)(p0, f1, f2, p3);

void
nci_vpffd( c_func, p0, f1, f2, d3 )
	SV* c_func
	void * p0
	float f1
	float f2
	double d3
PREINIT:
	void(*func)(void *, float, float, double);
CODE:
	func   = INT2PTR(void(*)(void *, float, float, double), SvIV(c_func) );
	(*func)(p0, f1, f2, d3);

void
nci_vpffs( c_func, p0, f1, f2, s3 )
	SV* c_func
	void * p0
	float f1
	float f2
	short s3
PREINIT:
	void(*func)(void *, float, float, short);
CODE:
	func   = INT2PTR(void(*)(void *, float, float, short), SvIV(c_func) );
	(*func)(p0, f1, f2, s3);

void
nci_vpfff( c_func, p0, f1, f2, f3 )
	SV* c_func
	void * p0
	float f1
	float f2
	float f3
PREINIT:
	void(*func)(void *, float, float, float);
CODE:
	func   = INT2PTR(void(*)(void *, float, float, float), SvIV(c_func) );
	(*func)(p0, f1, f2, f3);

void
nci_vpfft( c_func, p0, f1, f2, t3 )
	SV* c_func
	void * p0
	float f1
	float f2
	char * t3
PREINIT:
	void(*func)(void *, float, float, char *);
CODE:
	func   = INT2PTR(void(*)(void *, float, float, char *), SvIV(c_func) );
	(*func)(p0, f1, f2, t3);

void
nci_vpffi( c_func, p0, f1, f2, i3 )
	SV* c_func
	void * p0
	float f1
	float f2
	int i3
PREINIT:
	void(*func)(void *, float, float, int);
CODE:
	func   = INT2PTR(void(*)(void *, float, float, int), SvIV(c_func) );
	(*func)(p0, f1, f2, i3);

void
nci_vpftp( c_func, p0, f1, t2, p3 )
	SV* c_func
	void * p0
	float f1
	char * t2
	void * p3
PREINIT:
	void(*func)(void *, float, char *, void *);
CODE:
	func   = INT2PTR(void(*)(void *, float, char *, void *), SvIV(c_func) );
	(*func)(p0, f1, t2, p3);

void
nci_vpftd( c_func, p0, f1, t2, d3 )
	SV* c_func
	void * p0
	float f1
	char * t2
	double d3
PREINIT:
	void(*func)(void *, float, char *, double);
CODE:
	func   = INT2PTR(void(*)(void *, float, char *, double), SvIV(c_func) );
	(*func)(p0, f1, t2, d3);

void
nci_vpfts( c_func, p0, f1, t2, s3 )
	SV* c_func
	void * p0
	float f1
	char * t2
	short s3
PREINIT:
	void(*func)(void *, float, char *, short);
CODE:
	func   = INT2PTR(void(*)(void *, float, char *, short), SvIV(c_func) );
	(*func)(p0, f1, t2, s3);

void
nci_vpftf( c_func, p0, f1, t2, f3 )
	SV* c_func
	void * p0
	float f1
	char * t2
	float f3
PREINIT:
	void(*func)(void *, float, char *, float);
CODE:
	func   = INT2PTR(void(*)(void *, float, char *, float), SvIV(c_func) );
	(*func)(p0, f1, t2, f3);

void
nci_vpftt( c_func, p0, f1, t2, t3 )
	SV* c_func
	void * p0
	float f1
	char * t2
	char * t3
PREINIT:
	void(*func)(void *, float, char *, char *);
CODE:
	func   = INT2PTR(void(*)(void *, float, char *, char *), SvIV(c_func) );
	(*func)(p0, f1, t2, t3);

void
nci_vpfti( c_func, p0, f1, t2, i3 )
	SV* c_func
	void * p0
	float f1
	char * t2
	int i3
PREINIT:
	void(*func)(void *, float, char *, int);
CODE:
	func   = INT2PTR(void(*)(void *, float, char *, int), SvIV(c_func) );
	(*func)(p0, f1, t2, i3);

void
nci_vpfip( c_func, p0, f1, i2, p3 )
	SV* c_func
	void * p0
	float f1
	int i2
	void * p3
PREINIT:
	void(*func)(void *, float, int, void *);
CODE:
	func   = INT2PTR(void(*)(void *, float, int, void *), SvIV(c_func) );
	(*func)(p0, f1, i2, p3);

void
nci_vpfid( c_func, p0, f1, i2, d3 )
	SV* c_func
	void * p0
	float f1
	int i2
	double d3
PREINIT:
	void(*func)(void *, float, int, double);
CODE:
	func   = INT2PTR(void(*)(void *, float, int, double), SvIV(c_func) );
	(*func)(p0, f1, i2, d3);

void
nci_vpfis( c_func, p0, f1, i2, s3 )
	SV* c_func
	void * p0
	float f1
	int i2
	short s3
PREINIT:
	void(*func)(void *, float, int, short);
CODE:
	func   = INT2PTR(void(*)(void *, float, int, short), SvIV(c_func) );
	(*func)(p0, f1, i2, s3);

void
nci_vpfif( c_func, p0, f1, i2, f3 )
	SV* c_func
	void * p0
	float f1
	int i2
	float f3
PREINIT:
	void(*func)(void *, float, int, float);
CODE:
	func   = INT2PTR(void(*)(void *, float, int, float), SvIV(c_func) );
	(*func)(p0, f1, i2, f3);

void
nci_vpfit( c_func, p0, f1, i2, t3 )
	SV* c_func
	void * p0
	float f1
	int i2
	char * t3
PREINIT:
	void(*func)(void *, float, int, char *);
CODE:
	func   = INT2PTR(void(*)(void *, float, int, char *), SvIV(c_func) );
	(*func)(p0, f1, i2, t3);

void
nci_vpfii( c_func, p0, f1, i2, i3 )
	SV* c_func
	void * p0
	float f1
	int i2
	int i3
PREINIT:
	void(*func)(void *, float, int, int);
CODE:
	func   = INT2PTR(void(*)(void *, float, int, int), SvIV(c_func) );
	(*func)(p0, f1, i2, i3);

void
nci_vptpp( c_func, p0, t1, p2, p3 )
	SV* c_func
	void * p0
	char * t1
	void * p2
	void * p3
PREINIT:
	void(*func)(void *, char *, void *, void *);
CODE:
	func   = INT2PTR(void(*)(void *, char *, void *, void *), SvIV(c_func) );
	(*func)(p0, t1, p2, p3);

void
nci_vptpd( c_func, p0, t1, p2, d3 )
	SV* c_func
	void * p0
	char * t1
	void * p2
	double d3
PREINIT:
	void(*func)(void *, char *, void *, double);
CODE:
	func   = INT2PTR(void(*)(void *, char *, void *, double), SvIV(c_func) );
	(*func)(p0, t1, p2, d3);

void
nci_vptps( c_func, p0, t1, p2, s3 )
	SV* c_func
	void * p0
	char * t1
	void * p2
	short s3
PREINIT:
	void(*func)(void *, char *, void *, short);
CODE:
	func   = INT2PTR(void(*)(void *, char *, void *, short), SvIV(c_func) );
	(*func)(p0, t1, p2, s3);

void
nci_vptpf( c_func, p0, t1, p2, f3 )
	SV* c_func
	void * p0
	char * t1
	void * p2
	float f3
PREINIT:
	void(*func)(void *, char *, void *, float);
CODE:
	func   = INT2PTR(void(*)(void *, char *, void *, float), SvIV(c_func) );
	(*func)(p0, t1, p2, f3);

void
nci_vptpt( c_func, p0, t1, p2, t3 )
	SV* c_func
	void * p0
	char * t1
	void * p2
	char * t3
PREINIT:
	void(*func)(void *, char *, void *, char *);
CODE:
	func   = INT2PTR(void(*)(void *, char *, void *, char *), SvIV(c_func) );
	(*func)(p0, t1, p2, t3);

void
nci_vptpi( c_func, p0, t1, p2, i3 )
	SV* c_func
	void * p0
	char * t1
	void * p2
	int i3
PREINIT:
	void(*func)(void *, char *, void *, int);
CODE:
	func   = INT2PTR(void(*)(void *, char *, void *, int), SvIV(c_func) );
	(*func)(p0, t1, p2, i3);

void
nci_vptdp( c_func, p0, t1, d2, p3 )
	SV* c_func
	void * p0
	char * t1
	double d2
	void * p3
PREINIT:
	void(*func)(void *, char *, double, void *);
CODE:
	func   = INT2PTR(void(*)(void *, char *, double, void *), SvIV(c_func) );
	(*func)(p0, t1, d2, p3);

void
nci_vptdd( c_func, p0, t1, d2, d3 )
	SV* c_func
	void * p0
	char * t1
	double d2
	double d3
PREINIT:
	void(*func)(void *, char *, double, double);
CODE:
	func   = INT2PTR(void(*)(void *, char *, double, double), SvIV(c_func) );
	(*func)(p0, t1, d2, d3);

void
nci_vptds( c_func, p0, t1, d2, s3 )
	SV* c_func
	void * p0
	char * t1
	double d2
	short s3
PREINIT:
	void(*func)(void *, char *, double, short);
CODE:
	func   = INT2PTR(void(*)(void *, char *, double, short), SvIV(c_func) );
	(*func)(p0, t1, d2, s3);

void
nci_vptdf( c_func, p0, t1, d2, f3 )
	SV* c_func
	void * p0
	char * t1
	double d2
	float f3
PREINIT:
	void(*func)(void *, char *, double, float);
CODE:
	func   = INT2PTR(void(*)(void *, char *, double, float), SvIV(c_func) );
	(*func)(p0, t1, d2, f3);

void
nci_vptdt( c_func, p0, t1, d2, t3 )
	SV* c_func
	void * p0
	char * t1
	double d2
	char * t3
PREINIT:
	void(*func)(void *, char *, double, char *);
CODE:
	func   = INT2PTR(void(*)(void *, char *, double, char *), SvIV(c_func) );
	(*func)(p0, t1, d2, t3);

void
nci_vptdi( c_func, p0, t1, d2, i3 )
	SV* c_func
	void * p0
	char * t1
	double d2
	int i3
PREINIT:
	void(*func)(void *, char *, double, int);
CODE:
	func   = INT2PTR(void(*)(void *, char *, double, int), SvIV(c_func) );
	(*func)(p0, t1, d2, i3);

void
nci_vptsp( c_func, p0, t1, s2, p3 )
	SV* c_func
	void * p0
	char * t1
	short s2
	void * p3
PREINIT:
	void(*func)(void *, char *, short, void *);
CODE:
	func   = INT2PTR(void(*)(void *, char *, short, void *), SvIV(c_func) );
	(*func)(p0, t1, s2, p3);

void
nci_vptsd( c_func, p0, t1, s2, d3 )
	SV* c_func
	void * p0
	char * t1
	short s2
	double d3
PREINIT:
	void(*func)(void *, char *, short, double);
CODE:
	func   = INT2PTR(void(*)(void *, char *, short, double), SvIV(c_func) );
	(*func)(p0, t1, s2, d3);

void
nci_vptss( c_func, p0, t1, s2, s3 )
	SV* c_func
	void * p0
	char * t1
	short s2
	short s3
PREINIT:
	void(*func)(void *, char *, short, short);
CODE:
	func   = INT2PTR(void(*)(void *, char *, short, short), SvIV(c_func) );
	(*func)(p0, t1, s2, s3);

void
nci_vptsf( c_func, p0, t1, s2, f3 )
	SV* c_func
	void * p0
	char * t1
	short s2
	float f3
PREINIT:
	void(*func)(void *, char *, short, float);
CODE:
	func   = INT2PTR(void(*)(void *, char *, short, float), SvIV(c_func) );
	(*func)(p0, t1, s2, f3);

void
nci_vptst( c_func, p0, t1, s2, t3 )
	SV* c_func
	void * p0
	char * t1
	short s2
	char * t3
PREINIT:
	void(*func)(void *, char *, short, char *);
CODE:
	func   = INT2PTR(void(*)(void *, char *, short, char *), SvIV(c_func) );
	(*func)(p0, t1, s2, t3);

void
nci_vptsi( c_func, p0, t1, s2, i3 )
	SV* c_func
	void * p0
	char * t1
	short s2
	int i3
PREINIT:
	void(*func)(void *, char *, short, int);
CODE:
	func   = INT2PTR(void(*)(void *, char *, short, int), SvIV(c_func) );
	(*func)(p0, t1, s2, i3);

void
nci_vptfp( c_func, p0, t1, f2, p3 )
	SV* c_func
	void * p0
	char * t1
	float f2
	void * p3
PREINIT:
	void(*func)(void *, char *, float, void *);
CODE:
	func   = INT2PTR(void(*)(void *, char *, float, void *), SvIV(c_func) );
	(*func)(p0, t1, f2, p3);

void
nci_vptfd( c_func, p0, t1, f2, d3 )
	SV* c_func
	void * p0
	char * t1
	float f2
	double d3
PREINIT:
	void(*func)(void *, char *, float, double);
CODE:
	func   = INT2PTR(void(*)(void *, char *, float, double), SvIV(c_func) );
	(*func)(p0, t1, f2, d3);

void
nci_vptfs( c_func, p0, t1, f2, s3 )
	SV* c_func
	void * p0
	char * t1
	float f2
	short s3
PREINIT:
	void(*func)(void *, char *, float, short);
CODE:
	func   = INT2PTR(void(*)(void *, char *, float, short), SvIV(c_func) );
	(*func)(p0, t1, f2, s3);

void
nci_vptff( c_func, p0, t1, f2, f3 )
	SV* c_func
	void * p0
	char * t1
	float f2
	float f3
PREINIT:
	void(*func)(void *, char *, float, float);
CODE:
	func   = INT2PTR(void(*)(void *, char *, float, float), SvIV(c_func) );
	(*func)(p0, t1, f2, f3);

void
nci_vptft( c_func, p0, t1, f2, t3 )
	SV* c_func
	void * p0
	char * t1
	float f2
	char * t3
PREINIT:
	void(*func)(void *, char *, float, char *);
CODE:
	func   = INT2PTR(void(*)(void *, char *, float, char *), SvIV(c_func) );
	(*func)(p0, t1, f2, t3);

void
nci_vptfi( c_func, p0, t1, f2, i3 )
	SV* c_func
	void * p0
	char * t1
	float f2
	int i3
PREINIT:
	void(*func)(void *, char *, float, int);
CODE:
	func   = INT2PTR(void(*)(void *, char *, float, int), SvIV(c_func) );
	(*func)(p0, t1, f2, i3);

void
nci_vpttp( c_func, p0, t1, t2, p3 )
	SV* c_func
	void * p0
	char * t1
	char * t2
	void * p3
PREINIT:
	void(*func)(void *, char *, char *, void *);
CODE:
	func   = INT2PTR(void(*)(void *, char *, char *, void *), SvIV(c_func) );
	(*func)(p0, t1, t2, p3);

void
nci_vpttd( c_func, p0, t1, t2, d3 )
	SV* c_func
	void * p0
	char * t1
	char * t2
	double d3
PREINIT:
	void(*func)(void *, char *, char *, double);
CODE:
	func   = INT2PTR(void(*)(void *, char *, char *, double), SvIV(c_func) );
	(*func)(p0, t1, t2, d3);

void
nci_vptts( c_func, p0, t1, t2, s3 )
	SV* c_func
	void * p0
	char * t1
	char * t2
	short s3
PREINIT:
	void(*func)(void *, char *, char *, short);
CODE:
	func   = INT2PTR(void(*)(void *, char *, char *, short), SvIV(c_func) );
	(*func)(p0, t1, t2, s3);

void
nci_vpttf( c_func, p0, t1, t2, f3 )
	SV* c_func
	void * p0
	char * t1
	char * t2
	float f3
PREINIT:
	void(*func)(void *, char *, char *, float);
CODE:
	func   = INT2PTR(void(*)(void *, char *, char *, float), SvIV(c_func) );
	(*func)(p0, t1, t2, f3);

void
nci_vpttt( c_func, p0, t1, t2, t3 )
	SV* c_func
	void * p0
	char * t1
	char * t2
	char * t3
PREINIT:
	void(*func)(void *, char *, char *, char *);
CODE:
	func   = INT2PTR(void(*)(void *, char *, char *, char *), SvIV(c_func) );
	(*func)(p0, t1, t2, t3);

void
nci_vptti( c_func, p0, t1, t2, i3 )
	SV* c_func
	void * p0
	char * t1
	char * t2
	int i3
PREINIT:
	void(*func)(void *, char *, char *, int);
CODE:
	func   = INT2PTR(void(*)(void *, char *, char *, int), SvIV(c_func) );
	(*func)(p0, t1, t2, i3);

void
nci_vptip( c_func, p0, t1, i2, p3 )
	SV* c_func
	void * p0
	char * t1
	int i2
	void * p3
PREINIT:
	void(*func)(void *, char *, int, void *);
CODE:
	func   = INT2PTR(void(*)(void *, char *, int, void *), SvIV(c_func) );
	(*func)(p0, t1, i2, p3);

void
nci_vptid( c_func, p0, t1, i2, d3 )
	SV* c_func
	void * p0
	char * t1
	int i2
	double d3
PREINIT:
	void(*func)(void *, char *, int, double);
CODE:
	func   = INT2PTR(void(*)(void *, char *, int, double), SvIV(c_func) );
	(*func)(p0, t1, i2, d3);

void
nci_vptis( c_func, p0, t1, i2, s3 )
	SV* c_func
	void * p0
	char * t1
	int i2
	short s3
PREINIT:
	void(*func)(void *, char *, int, short);
CODE:
	func   = INT2PTR(void(*)(void *, char *, int, short), SvIV(c_func) );
	(*func)(p0, t1, i2, s3);

void
nci_vptif( c_func, p0, t1, i2, f3 )
	SV* c_func
	void * p0
	char * t1
	int i2
	float f3
PREINIT:
	void(*func)(void *, char *, int, float);
CODE:
	func   = INT2PTR(void(*)(void *, char *, int, float), SvIV(c_func) );
	(*func)(p0, t1, i2, f3);

void
nci_vptit( c_func, p0, t1, i2, t3 )
	SV* c_func
	void * p0
	char * t1
	int i2
	char * t3
PREINIT:
	void(*func)(void *, char *, int, char *);
CODE:
	func   = INT2PTR(void(*)(void *, char *, int, char *), SvIV(c_func) );
	(*func)(p0, t1, i2, t3);

void
nci_vptii( c_func, p0, t1, i2, i3 )
	SV* c_func
	void * p0
	char * t1
	int i2
	int i3
PREINIT:
	void(*func)(void *, char *, int, int);
CODE:
	func   = INT2PTR(void(*)(void *, char *, int, int), SvIV(c_func) );
	(*func)(p0, t1, i2, i3);

void
nci_vpipp( c_func, p0, i1, p2, p3 )
	SV* c_func
	void * p0
	int i1
	void * p2
	void * p3
PREINIT:
	void(*func)(void *, int, void *, void *);
CODE:
	func   = INT2PTR(void(*)(void *, int, void *, void *), SvIV(c_func) );
	(*func)(p0, i1, p2, p3);

void
nci_vpipd( c_func, p0, i1, p2, d3 )
	SV* c_func
	void * p0
	int i1
	void * p2
	double d3
PREINIT:
	void(*func)(void *, int, void *, double);
CODE:
	func   = INT2PTR(void(*)(void *, int, void *, double), SvIV(c_func) );
	(*func)(p0, i1, p2, d3);

void
nci_vpips( c_func, p0, i1, p2, s3 )
	SV* c_func
	void * p0
	int i1
	void * p2
	short s3
PREINIT:
	void(*func)(void *, int, void *, short);
CODE:
	func   = INT2PTR(void(*)(void *, int, void *, short), SvIV(c_func) );
	(*func)(p0, i1, p2, s3);

void
nci_vpipf( c_func, p0, i1, p2, f3 )
	SV* c_func
	void * p0
	int i1
	void * p2
	float f3
PREINIT:
	void(*func)(void *, int, void *, float);
CODE:
	func   = INT2PTR(void(*)(void *, int, void *, float), SvIV(c_func) );
	(*func)(p0, i1, p2, f3);

void
nci_vpipt( c_func, p0, i1, p2, t3 )
	SV* c_func
	void * p0
	int i1
	void * p2
	char * t3
PREINIT:
	void(*func)(void *, int, void *, char *);
CODE:
	func   = INT2PTR(void(*)(void *, int, void *, char *), SvIV(c_func) );
	(*func)(p0, i1, p2, t3);

void
nci_vpipi( c_func, p0, i1, p2, i3 )
	SV* c_func
	void * p0
	int i1
	void * p2
	int i3
PREINIT:
	void(*func)(void *, int, void *, int);
CODE:
	func   = INT2PTR(void(*)(void *, int, void *, int), SvIV(c_func) );
	(*func)(p0, i1, p2, i3);

void
nci_vpidp( c_func, p0, i1, d2, p3 )
	SV* c_func
	void * p0
	int i1
	double d2
	void * p3
PREINIT:
	void(*func)(void *, int, double, void *);
CODE:
	func   = INT2PTR(void(*)(void *, int, double, void *), SvIV(c_func) );
	(*func)(p0, i1, d2, p3);

void
nci_vpidd( c_func, p0, i1, d2, d3 )
	SV* c_func
	void * p0
	int i1
	double d2
	double d3
PREINIT:
	void(*func)(void *, int, double, double);
CODE:
	func   = INT2PTR(void(*)(void *, int, double, double), SvIV(c_func) );
	(*func)(p0, i1, d2, d3);

void
nci_vpids( c_func, p0, i1, d2, s3 )
	SV* c_func
	void * p0
	int i1
	double d2
	short s3
PREINIT:
	void(*func)(void *, int, double, short);
CODE:
	func   = INT2PTR(void(*)(void *, int, double, short), SvIV(c_func) );
	(*func)(p0, i1, d2, s3);

void
nci_vpidf( c_func, p0, i1, d2, f3 )
	SV* c_func
	void * p0
	int i1
	double d2
	float f3
PREINIT:
	void(*func)(void *, int, double, float);
CODE:
	func   = INT2PTR(void(*)(void *, int, double, float), SvIV(c_func) );
	(*func)(p0, i1, d2, f3);

void
nci_vpidt( c_func, p0, i1, d2, t3 )
	SV* c_func
	void * p0
	int i1
	double d2
	char * t3
PREINIT:
	void(*func)(void *, int, double, char *);
CODE:
	func   = INT2PTR(void(*)(void *, int, double, char *), SvIV(c_func) );
	(*func)(p0, i1, d2, t3);

void
nci_vpidi( c_func, p0, i1, d2, i3 )
	SV* c_func
	void * p0
	int i1
	double d2
	int i3
PREINIT:
	void(*func)(void *, int, double, int);
CODE:
	func   = INT2PTR(void(*)(void *, int, double, int), SvIV(c_func) );
	(*func)(p0, i1, d2, i3);

void
nci_vpisp( c_func, p0, i1, s2, p3 )
	SV* c_func
	void * p0
	int i1
	short s2
	void * p3
PREINIT:
	void(*func)(void *, int, short, void *);
CODE:
	func   = INT2PTR(void(*)(void *, int, short, void *), SvIV(c_func) );
	(*func)(p0, i1, s2, p3);

void
nci_vpisd( c_func, p0, i1, s2, d3 )
	SV* c_func
	void * p0
	int i1
	short s2
	double d3
PREINIT:
	void(*func)(void *, int, short, double);
CODE:
	func   = INT2PTR(void(*)(void *, int, short, double), SvIV(c_func) );
	(*func)(p0, i1, s2, d3);

void
nci_vpiss( c_func, p0, i1, s2, s3 )
	SV* c_func
	void * p0
	int i1
	short s2
	short s3
PREINIT:
	void(*func)(void *, int, short, short);
CODE:
	func   = INT2PTR(void(*)(void *, int, short, short), SvIV(c_func) );
	(*func)(p0, i1, s2, s3);

void
nci_vpisf( c_func, p0, i1, s2, f3 )
	SV* c_func
	void * p0
	int i1
	short s2
	float f3
PREINIT:
	void(*func)(void *, int, short, float);
CODE:
	func   = INT2PTR(void(*)(void *, int, short, float), SvIV(c_func) );
	(*func)(p0, i1, s2, f3);

void
nci_vpist( c_func, p0, i1, s2, t3 )
	SV* c_func
	void * p0
	int i1
	short s2
	char * t3
PREINIT:
	void(*func)(void *, int, short, char *);
CODE:
	func   = INT2PTR(void(*)(void *, int, short, char *), SvIV(c_func) );
	(*func)(p0, i1, s2, t3);

void
nci_vpisi( c_func, p0, i1, s2, i3 )
	SV* c_func
	void * p0
	int i1
	short s2
	int i3
PREINIT:
	void(*func)(void *, int, short, int);
CODE:
	func   = INT2PTR(void(*)(void *, int, short, int), SvIV(c_func) );
	(*func)(p0, i1, s2, i3);

void
nci_vpifp( c_func, p0, i1, f2, p3 )
	SV* c_func
	void * p0
	int i1
	float f2
	void * p3
PREINIT:
	void(*func)(void *, int, float, void *);
CODE:
	func   = INT2PTR(void(*)(void *, int, float, void *), SvIV(c_func) );
	(*func)(p0, i1, f2, p3);

void
nci_vpifd( c_func, p0, i1, f2, d3 )
	SV* c_func
	void * p0
	int i1
	float f2
	double d3
PREINIT:
	void(*func)(void *, int, float, double);
CODE:
	func   = INT2PTR(void(*)(void *, int, float, double), SvIV(c_func) );
	(*func)(p0, i1, f2, d3);

void
nci_vpifs( c_func, p0, i1, f2, s3 )
	SV* c_func
	void * p0
	int i1
	float f2
	short s3
PREINIT:
	void(*func)(void *, int, float, short);
CODE:
	func   = INT2PTR(void(*)(void *, int, float, short), SvIV(c_func) );
	(*func)(p0, i1, f2, s3);

void
nci_vpiff( c_func, p0, i1, f2, f3 )
	SV* c_func
	void * p0
	int i1
	float f2
	float f3
PREINIT:
	void(*func)(void *, int, float, float);
CODE:
	func   = INT2PTR(void(*)(void *, int, float, float), SvIV(c_func) );
	(*func)(p0, i1, f2, f3);

void
nci_vpift( c_func, p0, i1, f2, t3 )
	SV* c_func
	void * p0
	int i1
	float f2
	char * t3
PREINIT:
	void(*func)(void *, int, float, char *);
CODE:
	func   = INT2PTR(void(*)(void *, int, float, char *), SvIV(c_func) );
	(*func)(p0, i1, f2, t3);

void
nci_vpifi( c_func, p0, i1, f2, i3 )
	SV* c_func
	void * p0
	int i1
	float f2
	int i3
PREINIT:
	void(*func)(void *, int, float, int);
CODE:
	func   = INT2PTR(void(*)(void *, int, float, int), SvIV(c_func) );
	(*func)(p0, i1, f2, i3);

void
nci_vpitp( c_func, p0, i1, t2, p3 )
	SV* c_func
	void * p0
	int i1
	char * t2
	void * p3
PREINIT:
	void(*func)(void *, int, char *, void *);
CODE:
	func   = INT2PTR(void(*)(void *, int, char *, void *), SvIV(c_func) );
	(*func)(p0, i1, t2, p3);

void
nci_vpitd( c_func, p0, i1, t2, d3 )
	SV* c_func
	void * p0
	int i1
	char * t2
	double d3
PREINIT:
	void(*func)(void *, int, char *, double);
CODE:
	func   = INT2PTR(void(*)(void *, int, char *, double), SvIV(c_func) );
	(*func)(p0, i1, t2, d3);

void
nci_vpits( c_func, p0, i1, t2, s3 )
	SV* c_func
	void * p0
	int i1
	char * t2
	short s3
PREINIT:
	void(*func)(void *, int, char *, short);
CODE:
	func   = INT2PTR(void(*)(void *, int, char *, short), SvIV(c_func) );
	(*func)(p0, i1, t2, s3);

void
nci_vpitf( c_func, p0, i1, t2, f3 )
	SV* c_func
	void * p0
	int i1
	char * t2
	float f3
PREINIT:
	void(*func)(void *, int, char *, float);
CODE:
	func   = INT2PTR(void(*)(void *, int, char *, float), SvIV(c_func) );
	(*func)(p0, i1, t2, f3);

void
nci_vpitt( c_func, p0, i1, t2, t3 )
	SV* c_func
	void * p0
	int i1
	char * t2
	char * t3
PREINIT:
	void(*func)(void *, int, char *, char *);
CODE:
	func   = INT2PTR(void(*)(void *, int, char *, char *), SvIV(c_func) );
	(*func)(p0, i1, t2, t3);

void
nci_vpiti( c_func, p0, i1, t2, i3 )
	SV* c_func
	void * p0
	int i1
	char * t2
	int i3
PREINIT:
	void(*func)(void *, int, char *, int);
CODE:
	func   = INT2PTR(void(*)(void *, int, char *, int), SvIV(c_func) );
	(*func)(p0, i1, t2, i3);

void
nci_vpiip( c_func, p0, i1, i2, p3 )
	SV* c_func
	void * p0
	int i1
	int i2
	void * p3
PREINIT:
	void(*func)(void *, int, int, void *);
CODE:
	func   = INT2PTR(void(*)(void *, int, int, void *), SvIV(c_func) );
	(*func)(p0, i1, i2, p3);

void
nci_vpiid( c_func, p0, i1, i2, d3 )
	SV* c_func
	void * p0
	int i1
	int i2
	double d3
PREINIT:
	void(*func)(void *, int, int, double);
CODE:
	func   = INT2PTR(void(*)(void *, int, int, double), SvIV(c_func) );
	(*func)(p0, i1, i2, d3);

void
nci_vpiis( c_func, p0, i1, i2, s3 )
	SV* c_func
	void * p0
	int i1
	int i2
	short s3
PREINIT:
	void(*func)(void *, int, int, short);
CODE:
	func   = INT2PTR(void(*)(void *, int, int, short), SvIV(c_func) );
	(*func)(p0, i1, i2, s3);

void
nci_vpiif( c_func, p0, i1, i2, f3 )
	SV* c_func
	void * p0
	int i1
	int i2
	float f3
PREINIT:
	void(*func)(void *, int, int, float);
CODE:
	func   = INT2PTR(void(*)(void *, int, int, float), SvIV(c_func) );
	(*func)(p0, i1, i2, f3);

void
nci_vpiit( c_func, p0, i1, i2, t3 )
	SV* c_func
	void * p0
	int i1
	int i2
	char * t3
PREINIT:
	void(*func)(void *, int, int, char *);
CODE:
	func   = INT2PTR(void(*)(void *, int, int, char *), SvIV(c_func) );
	(*func)(p0, i1, i2, t3);

void
nci_vpiii( c_func, p0, i1, i2, i3 )
	SV* c_func
	void * p0
	int i1
	int i2
	int i3
PREINIT:
	void(*func)(void *, int, int, int);
CODE:
	func   = INT2PTR(void(*)(void *, int, int, int), SvIV(c_func) );
	(*func)(p0, i1, i2, i3);

void
nci_vdppp( c_func, d0, p1, p2, p3 )
	SV* c_func
	double d0
	void * p1
	void * p2
	void * p3
PREINIT:
	void(*func)(double, void *, void *, void *);
CODE:
	func   = INT2PTR(void(*)(double, void *, void *, void *), SvIV(c_func) );
	(*func)(d0, p1, p2, p3);

void
nci_vdppd( c_func, d0, p1, p2, d3 )
	SV* c_func
	double d0
	void * p1
	void * p2
	double d3
PREINIT:
	void(*func)(double, void *, void *, double);
CODE:
	func   = INT2PTR(void(*)(double, void *, void *, double), SvIV(c_func) );
	(*func)(d0, p1, p2, d3);

void
nci_vdpps( c_func, d0, p1, p2, s3 )
	SV* c_func
	double d0
	void * p1
	void * p2
	short s3
PREINIT:
	void(*func)(double, void *, void *, short);
CODE:
	func   = INT2PTR(void(*)(double, void *, void *, short), SvIV(c_func) );
	(*func)(d0, p1, p2, s3);

void
nci_vdppf( c_func, d0, p1, p2, f3 )
	SV* c_func
	double d0
	void * p1
	void * p2
	float f3
PREINIT:
	void(*func)(double, void *, void *, float);
CODE:
	func   = INT2PTR(void(*)(double, void *, void *, float), SvIV(c_func) );
	(*func)(d0, p1, p2, f3);

void
nci_vdppt( c_func, d0, p1, p2, t3 )
	SV* c_func
	double d0
	void * p1
	void * p2
	char * t3
PREINIT:
	void(*func)(double, void *, void *, char *);
CODE:
	func   = INT2PTR(void(*)(double, void *, void *, char *), SvIV(c_func) );
	(*func)(d0, p1, p2, t3);

void
nci_vdppi( c_func, d0, p1, p2, i3 )
	SV* c_func
	double d0
	void * p1
	void * p2
	int i3
PREINIT:
	void(*func)(double, void *, void *, int);
CODE:
	func   = INT2PTR(void(*)(double, void *, void *, int), SvIV(c_func) );
	(*func)(d0, p1, p2, i3);

void
nci_vdpdp( c_func, d0, p1, d2, p3 )
	SV* c_func
	double d0
	void * p1
	double d2
	void * p3
PREINIT:
	void(*func)(double, void *, double, void *);
CODE:
	func   = INT2PTR(void(*)(double, void *, double, void *), SvIV(c_func) );
	(*func)(d0, p1, d2, p3);

void
nci_vdpdd( c_func, d0, p1, d2, d3 )
	SV* c_func
	double d0
	void * p1
	double d2
	double d3
PREINIT:
	void(*func)(double, void *, double, double);
CODE:
	func   = INT2PTR(void(*)(double, void *, double, double), SvIV(c_func) );
	(*func)(d0, p1, d2, d3);

void
nci_vdpds( c_func, d0, p1, d2, s3 )
	SV* c_func
	double d0
	void * p1
	double d2
	short s3
PREINIT:
	void(*func)(double, void *, double, short);
CODE:
	func   = INT2PTR(void(*)(double, void *, double, short), SvIV(c_func) );
	(*func)(d0, p1, d2, s3);

void
nci_vdpdf( c_func, d0, p1, d2, f3 )
	SV* c_func
	double d0
	void * p1
	double d2
	float f3
PREINIT:
	void(*func)(double, void *, double, float);
CODE:
	func   = INT2PTR(void(*)(double, void *, double, float), SvIV(c_func) );
	(*func)(d0, p1, d2, f3);

void
nci_vdpdt( c_func, d0, p1, d2, t3 )
	SV* c_func
	double d0
	void * p1
	double d2
	char * t3
PREINIT:
	void(*func)(double, void *, double, char *);
CODE:
	func   = INT2PTR(void(*)(double, void *, double, char *), SvIV(c_func) );
	(*func)(d0, p1, d2, t3);

void
nci_vdpdi( c_func, d0, p1, d2, i3 )
	SV* c_func
	double d0
	void * p1
	double d2
	int i3
PREINIT:
	void(*func)(double, void *, double, int);
CODE:
	func   = INT2PTR(void(*)(double, void *, double, int), SvIV(c_func) );
	(*func)(d0, p1, d2, i3);

void
nci_vdpsp( c_func, d0, p1, s2, p3 )
	SV* c_func
	double d0
	void * p1
	short s2
	void * p3
PREINIT:
	void(*func)(double, void *, short, void *);
CODE:
	func   = INT2PTR(void(*)(double, void *, short, void *), SvIV(c_func) );
	(*func)(d0, p1, s2, p3);

void
nci_vdpsd( c_func, d0, p1, s2, d3 )
	SV* c_func
	double d0
	void * p1
	short s2
	double d3
PREINIT:
	void(*func)(double, void *, short, double);
CODE:
	func   = INT2PTR(void(*)(double, void *, short, double), SvIV(c_func) );
	(*func)(d0, p1, s2, d3);

void
nci_vdpss( c_func, d0, p1, s2, s3 )
	SV* c_func
	double d0
	void * p1
	short s2
	short s3
PREINIT:
	void(*func)(double, void *, short, short);
CODE:
	func   = INT2PTR(void(*)(double, void *, short, short), SvIV(c_func) );
	(*func)(d0, p1, s2, s3);

void
nci_vdpsf( c_func, d0, p1, s2, f3 )
	SV* c_func
	double d0
	void * p1
	short s2
	float f3
PREINIT:
	void(*func)(double, void *, short, float);
CODE:
	func   = INT2PTR(void(*)(double, void *, short, float), SvIV(c_func) );
	(*func)(d0, p1, s2, f3);

void
nci_vdpst( c_func, d0, p1, s2, t3 )
	SV* c_func
	double d0
	void * p1
	short s2
	char * t3
PREINIT:
	void(*func)(double, void *, short, char *);
CODE:
	func   = INT2PTR(void(*)(double, void *, short, char *), SvIV(c_func) );
	(*func)(d0, p1, s2, t3);

void
nci_vdpsi( c_func, d0, p1, s2, i3 )
	SV* c_func
	double d0
	void * p1
	short s2
	int i3
PREINIT:
	void(*func)(double, void *, short, int);
CODE:
	func   = INT2PTR(void(*)(double, void *, short, int), SvIV(c_func) );
	(*func)(d0, p1, s2, i3);

void
nci_vdpfp( c_func, d0, p1, f2, p3 )
	SV* c_func
	double d0
	void * p1
	float f2
	void * p3
PREINIT:
	void(*func)(double, void *, float, void *);
CODE:
	func   = INT2PTR(void(*)(double, void *, float, void *), SvIV(c_func) );
	(*func)(d0, p1, f2, p3);

void
nci_vdpfd( c_func, d0, p1, f2, d3 )
	SV* c_func
	double d0
	void * p1
	float f2
	double d3
PREINIT:
	void(*func)(double, void *, float, double);
CODE:
	func   = INT2PTR(void(*)(double, void *, float, double), SvIV(c_func) );
	(*func)(d0, p1, f2, d3);

void
nci_vdpfs( c_func, d0, p1, f2, s3 )
	SV* c_func
	double d0
	void * p1
	float f2
	short s3
PREINIT:
	void(*func)(double, void *, float, short);
CODE:
	func   = INT2PTR(void(*)(double, void *, float, short), SvIV(c_func) );
	(*func)(d0, p1, f2, s3);

void
nci_vdpff( c_func, d0, p1, f2, f3 )
	SV* c_func
	double d0
	void * p1
	float f2
	float f3
PREINIT:
	void(*func)(double, void *, float, float);
CODE:
	func   = INT2PTR(void(*)(double, void *, float, float), SvIV(c_func) );
	(*func)(d0, p1, f2, f3);

void
nci_vdpft( c_func, d0, p1, f2, t3 )
	SV* c_func
	double d0
	void * p1
	float f2
	char * t3
PREINIT:
	void(*func)(double, void *, float, char *);
CODE:
	func   = INT2PTR(void(*)(double, void *, float, char *), SvIV(c_func) );
	(*func)(d0, p1, f2, t3);

void
nci_vdpfi( c_func, d0, p1, f2, i3 )
	SV* c_func
	double d0
	void * p1
	float f2
	int i3
PREINIT:
	void(*func)(double, void *, float, int);
CODE:
	func   = INT2PTR(void(*)(double, void *, float, int), SvIV(c_func) );
	(*func)(d0, p1, f2, i3);

void
nci_vdptp( c_func, d0, p1, t2, p3 )
	SV* c_func
	double d0
	void * p1
	char * t2
	void * p3
PREINIT:
	void(*func)(double, void *, char *, void *);
CODE:
	func   = INT2PTR(void(*)(double, void *, char *, void *), SvIV(c_func) );
	(*func)(d0, p1, t2, p3);

void
nci_vdptd( c_func, d0, p1, t2, d3 )
	SV* c_func
	double d0
	void * p1
	char * t2
	double d3
PREINIT:
	void(*func)(double, void *, char *, double);
CODE:
	func   = INT2PTR(void(*)(double, void *, char *, double), SvIV(c_func) );
	(*func)(d0, p1, t2, d3);

void
nci_vdpts( c_func, d0, p1, t2, s3 )
	SV* c_func
	double d0
	void * p1
	char * t2
	short s3
PREINIT:
	void(*func)(double, void *, char *, short);
CODE:
	func   = INT2PTR(void(*)(double, void *, char *, short), SvIV(c_func) );
	(*func)(d0, p1, t2, s3);

void
nci_vdptf( c_func, d0, p1, t2, f3 )
	SV* c_func
	double d0
	void * p1
	char * t2
	float f3
PREINIT:
	void(*func)(double, void *, char *, float);
CODE:
	func   = INT2PTR(void(*)(double, void *, char *, float), SvIV(c_func) );
	(*func)(d0, p1, t2, f3);

void
nci_vdptt( c_func, d0, p1, t2, t3 )
	SV* c_func
	double d0
	void * p1
	char * t2
	char * t3
PREINIT:
	void(*func)(double, void *, char *, char *);
CODE:
	func   = INT2PTR(void(*)(double, void *, char *, char *), SvIV(c_func) );
	(*func)(d0, p1, t2, t3);

void
nci_vdpti( c_func, d0, p1, t2, i3 )
	SV* c_func
	double d0
	void * p1
	char * t2
	int i3
PREINIT:
	void(*func)(double, void *, char *, int);
CODE:
	func   = INT2PTR(void(*)(double, void *, char *, int), SvIV(c_func) );
	(*func)(d0, p1, t2, i3);

void
nci_vdpip( c_func, d0, p1, i2, p3 )
	SV* c_func
	double d0
	void * p1
	int i2
	void * p3
PREINIT:
	void(*func)(double, void *, int, void *);
CODE:
	func   = INT2PTR(void(*)(double, void *, int, void *), SvIV(c_func) );
	(*func)(d0, p1, i2, p3);

void
nci_vdpid( c_func, d0, p1, i2, d3 )
	SV* c_func
	double d0
	void * p1
	int i2
	double d3
PREINIT:
	void(*func)(double, void *, int, double);
CODE:
	func   = INT2PTR(void(*)(double, void *, int, double), SvIV(c_func) );
	(*func)(d0, p1, i2, d3);

void
nci_vdpis( c_func, d0, p1, i2, s3 )
	SV* c_func
	double d0
	void * p1
	int i2
	short s3
PREINIT:
	void(*func)(double, void *, int, short);
CODE:
	func   = INT2PTR(void(*)(double, void *, int, short), SvIV(c_func) );
	(*func)(d0, p1, i2, s3);

void
nci_vdpif( c_func, d0, p1, i2, f3 )
	SV* c_func
	double d0
	void * p1
	int i2
	float f3
PREINIT:
	void(*func)(double, void *, int, float);
CODE:
	func   = INT2PTR(void(*)(double, void *, int, float), SvIV(c_func) );
	(*func)(d0, p1, i2, f3);

void
nci_vdpit( c_func, d0, p1, i2, t3 )
	SV* c_func
	double d0
	void * p1
	int i2
	char * t3
PREINIT:
	void(*func)(double, void *, int, char *);
CODE:
	func   = INT2PTR(void(*)(double, void *, int, char *), SvIV(c_func) );
	(*func)(d0, p1, i2, t3);

void
nci_vdpii( c_func, d0, p1, i2, i3 )
	SV* c_func
	double d0
	void * p1
	int i2
	int i3
PREINIT:
	void(*func)(double, void *, int, int);
CODE:
	func   = INT2PTR(void(*)(double, void *, int, int), SvIV(c_func) );
	(*func)(d0, p1, i2, i3);

void
nci_vddpp( c_func, d0, d1, p2, p3 )
	SV* c_func
	double d0
	double d1
	void * p2
	void * p3
PREINIT:
	void(*func)(double, double, void *, void *);
CODE:
	func   = INT2PTR(void(*)(double, double, void *, void *), SvIV(c_func) );
	(*func)(d0, d1, p2, p3);

void
nci_vddpd( c_func, d0, d1, p2, d3 )
	SV* c_func
	double d0
	double d1
	void * p2
	double d3
PREINIT:
	void(*func)(double, double, void *, double);
CODE:
	func   = INT2PTR(void(*)(double, double, void *, double), SvIV(c_func) );
	(*func)(d0, d1, p2, d3);

void
nci_vddps( c_func, d0, d1, p2, s3 )
	SV* c_func
	double d0
	double d1
	void * p2
	short s3
PREINIT:
	void(*func)(double, double, void *, short);
CODE:
	func   = INT2PTR(void(*)(double, double, void *, short), SvIV(c_func) );
	(*func)(d0, d1, p2, s3);

void
nci_vddpf( c_func, d0, d1, p2, f3 )
	SV* c_func
	double d0
	double d1
	void * p2
	float f3
PREINIT:
	void(*func)(double, double, void *, float);
CODE:
	func   = INT2PTR(void(*)(double, double, void *, float), SvIV(c_func) );
	(*func)(d0, d1, p2, f3);

void
nci_vddpt( c_func, d0, d1, p2, t3 )
	SV* c_func
	double d0
	double d1
	void * p2
	char * t3
PREINIT:
	void(*func)(double, double, void *, char *);
CODE:
	func   = INT2PTR(void(*)(double, double, void *, char *), SvIV(c_func) );
	(*func)(d0, d1, p2, t3);

void
nci_vddpi( c_func, d0, d1, p2, i3 )
	SV* c_func
	double d0
	double d1
	void * p2
	int i3
PREINIT:
	void(*func)(double, double, void *, int);
CODE:
	func   = INT2PTR(void(*)(double, double, void *, int), SvIV(c_func) );
	(*func)(d0, d1, p2, i3);

void
nci_vdddp( c_func, d0, d1, d2, p3 )
	SV* c_func
	double d0
	double d1
	double d2
	void * p3
PREINIT:
	void(*func)(double, double, double, void *);
CODE:
	func   = INT2PTR(void(*)(double, double, double, void *), SvIV(c_func) );
	(*func)(d0, d1, d2, p3);

void
nci_vdddd( c_func, d0, d1, d2, d3 )
	SV* c_func
	double d0
	double d1
	double d2
	double d3
PREINIT:
	void(*func)(double, double, double, double);
CODE:
	func   = INT2PTR(void(*)(double, double, double, double), SvIV(c_func) );
	(*func)(d0, d1, d2, d3);

void
nci_vddds( c_func, d0, d1, d2, s3 )
	SV* c_func
	double d0
	double d1
	double d2
	short s3
PREINIT:
	void(*func)(double, double, double, short);
CODE:
	func   = INT2PTR(void(*)(double, double, double, short), SvIV(c_func) );
	(*func)(d0, d1, d2, s3);

void
nci_vdddf( c_func, d0, d1, d2, f3 )
	SV* c_func
	double d0
	double d1
	double d2
	float f3
PREINIT:
	void(*func)(double, double, double, float);
CODE:
	func   = INT2PTR(void(*)(double, double, double, float), SvIV(c_func) );
	(*func)(d0, d1, d2, f3);

void
nci_vdddt( c_func, d0, d1, d2, t3 )
	SV* c_func
	double d0
	double d1
	double d2
	char * t3
PREINIT:
	void(*func)(double, double, double, char *);
CODE:
	func   = INT2PTR(void(*)(double, double, double, char *), SvIV(c_func) );
	(*func)(d0, d1, d2, t3);

void
nci_vdddi( c_func, d0, d1, d2, i3 )
	SV* c_func
	double d0
	double d1
	double d2
	int i3
PREINIT:
	void(*func)(double, double, double, int);
CODE:
	func   = INT2PTR(void(*)(double, double, double, int), SvIV(c_func) );
	(*func)(d0, d1, d2, i3);

void
nci_vddsp( c_func, d0, d1, s2, p3 )
	SV* c_func
	double d0
	double d1
	short s2
	void * p3
PREINIT:
	void(*func)(double, double, short, void *);
CODE:
	func   = INT2PTR(void(*)(double, double, short, void *), SvIV(c_func) );
	(*func)(d0, d1, s2, p3);

void
nci_vddsd( c_func, d0, d1, s2, d3 )
	SV* c_func
	double d0
	double d1
	short s2
	double d3
PREINIT:
	void(*func)(double, double, short, double);
CODE:
	func   = INT2PTR(void(*)(double, double, short, double), SvIV(c_func) );
	(*func)(d0, d1, s2, d3);

void
nci_vddss( c_func, d0, d1, s2, s3 )
	SV* c_func
	double d0
	double d1
	short s2
	short s3
PREINIT:
	void(*func)(double, double, short, short);
CODE:
	func   = INT2PTR(void(*)(double, double, short, short), SvIV(c_func) );
	(*func)(d0, d1, s2, s3);

void
nci_vddsf( c_func, d0, d1, s2, f3 )
	SV* c_func
	double d0
	double d1
	short s2
	float f3
PREINIT:
	void(*func)(double, double, short, float);
CODE:
	func   = INT2PTR(void(*)(double, double, short, float), SvIV(c_func) );
	(*func)(d0, d1, s2, f3);

void
nci_vddst( c_func, d0, d1, s2, t3 )
	SV* c_func
	double d0
	double d1
	short s2
	char * t3
PREINIT:
	void(*func)(double, double, short, char *);
CODE:
	func   = INT2PTR(void(*)(double, double, short, char *), SvIV(c_func) );
	(*func)(d0, d1, s2, t3);

void
nci_vddsi( c_func, d0, d1, s2, i3 )
	SV* c_func
	double d0
	double d1
	short s2
	int i3
PREINIT:
	void(*func)(double, double, short, int);
CODE:
	func   = INT2PTR(void(*)(double, double, short, int), SvIV(c_func) );
	(*func)(d0, d1, s2, i3);

void
nci_vddfp( c_func, d0, d1, f2, p3 )
	SV* c_func
	double d0
	double d1
	float f2
	void * p3
PREINIT:
	void(*func)(double, double, float, void *);
CODE:
	func   = INT2PTR(void(*)(double, double, float, void *), SvIV(c_func) );
	(*func)(d0, d1, f2, p3);

void
nci_vddfd( c_func, d0, d1, f2, d3 )
	SV* c_func
	double d0
	double d1
	float f2
	double d3
PREINIT:
	void(*func)(double, double, float, double);
CODE:
	func   = INT2PTR(void(*)(double, double, float, double), SvIV(c_func) );
	(*func)(d0, d1, f2, d3);

void
nci_vddfs( c_func, d0, d1, f2, s3 )
	SV* c_func
	double d0
	double d1
	float f2
	short s3
PREINIT:
	void(*func)(double, double, float, short);
CODE:
	func   = INT2PTR(void(*)(double, double, float, short), SvIV(c_func) );
	(*func)(d0, d1, f2, s3);

void
nci_vddff( c_func, d0, d1, f2, f3 )
	SV* c_func
	double d0
	double d1
	float f2
	float f3
PREINIT:
	void(*func)(double, double, float, float);
CODE:
	func   = INT2PTR(void(*)(double, double, float, float), SvIV(c_func) );
	(*func)(d0, d1, f2, f3);

void
nci_vddft( c_func, d0, d1, f2, t3 )
	SV* c_func
	double d0
	double d1
	float f2
	char * t3
PREINIT:
	void(*func)(double, double, float, char *);
CODE:
	func   = INT2PTR(void(*)(double, double, float, char *), SvIV(c_func) );
	(*func)(d0, d1, f2, t3);

void
nci_vddfi( c_func, d0, d1, f2, i3 )
	SV* c_func
	double d0
	double d1
	float f2
	int i3
PREINIT:
	void(*func)(double, double, float, int);
CODE:
	func   = INT2PTR(void(*)(double, double, float, int), SvIV(c_func) );
	(*func)(d0, d1, f2, i3);

void
nci_vddtp( c_func, d0, d1, t2, p3 )
	SV* c_func
	double d0
	double d1
	char * t2
	void * p3
PREINIT:
	void(*func)(double, double, char *, void *);
CODE:
	func   = INT2PTR(void(*)(double, double, char *, void *), SvIV(c_func) );
	(*func)(d0, d1, t2, p3);

void
nci_vddtd( c_func, d0, d1, t2, d3 )
	SV* c_func
	double d0
	double d1
	char * t2
	double d3
PREINIT:
	void(*func)(double, double, char *, double);
CODE:
	func   = INT2PTR(void(*)(double, double, char *, double), SvIV(c_func) );
	(*func)(d0, d1, t2, d3);

void
nci_vddts( c_func, d0, d1, t2, s3 )
	SV* c_func
	double d0
	double d1
	char * t2
	short s3
PREINIT:
	void(*func)(double, double, char *, short);
CODE:
	func   = INT2PTR(void(*)(double, double, char *, short), SvIV(c_func) );
	(*func)(d0, d1, t2, s3);

void
nci_vddtf( c_func, d0, d1, t2, f3 )
	SV* c_func
	double d0
	double d1
	char * t2
	float f3
PREINIT:
	void(*func)(double, double, char *, float);
CODE:
	func   = INT2PTR(void(*)(double, double, char *, float), SvIV(c_func) );
	(*func)(d0, d1, t2, f3);

void
nci_vddtt( c_func, d0, d1, t2, t3 )
	SV* c_func
	double d0
	double d1
	char * t2
	char * t3
PREINIT:
	void(*func)(double, double, char *, char *);
CODE:
	func   = INT2PTR(void(*)(double, double, char *, char *), SvIV(c_func) );
	(*func)(d0, d1, t2, t3);

void
nci_vddti( c_func, d0, d1, t2, i3 )
	SV* c_func
	double d0
	double d1
	char * t2
	int i3
PREINIT:
	void(*func)(double, double, char *, int);
CODE:
	func   = INT2PTR(void(*)(double, double, char *, int), SvIV(c_func) );
	(*func)(d0, d1, t2, i3);

void
nci_vddip( c_func, d0, d1, i2, p3 )
	SV* c_func
	double d0
	double d1
	int i2
	void * p3
PREINIT:
	void(*func)(double, double, int, void *);
CODE:
	func   = INT2PTR(void(*)(double, double, int, void *), SvIV(c_func) );
	(*func)(d0, d1, i2, p3);

void
nci_vddid( c_func, d0, d1, i2, d3 )
	SV* c_func
	double d0
	double d1
	int i2
	double d3
PREINIT:
	void(*func)(double, double, int, double);
CODE:
	func   = INT2PTR(void(*)(double, double, int, double), SvIV(c_func) );
	(*func)(d0, d1, i2, d3);

void
nci_vddis( c_func, d0, d1, i2, s3 )
	SV* c_func
	double d0
	double d1
	int i2
	short s3
PREINIT:
	void(*func)(double, double, int, short);
CODE:
	func   = INT2PTR(void(*)(double, double, int, short), SvIV(c_func) );
	(*func)(d0, d1, i2, s3);

void
nci_vddif( c_func, d0, d1, i2, f3 )
	SV* c_func
	double d0
	double d1
	int i2
	float f3
PREINIT:
	void(*func)(double, double, int, float);
CODE:
	func   = INT2PTR(void(*)(double, double, int, float), SvIV(c_func) );
	(*func)(d0, d1, i2, f3);

void
nci_vddit( c_func, d0, d1, i2, t3 )
	SV* c_func
	double d0
	double d1
	int i2
	char * t3
PREINIT:
	void(*func)(double, double, int, char *);
CODE:
	func   = INT2PTR(void(*)(double, double, int, char *), SvIV(c_func) );
	(*func)(d0, d1, i2, t3);

void
nci_vddii( c_func, d0, d1, i2, i3 )
	SV* c_func
	double d0
	double d1
	int i2
	int i3
PREINIT:
	void(*func)(double, double, int, int);
CODE:
	func   = INT2PTR(void(*)(double, double, int, int), SvIV(c_func) );
	(*func)(d0, d1, i2, i3);

void
nci_vdspp( c_func, d0, s1, p2, p3 )
	SV* c_func
	double d0
	short s1
	void * p2
	void * p3
PREINIT:
	void(*func)(double, short, void *, void *);
CODE:
	func   = INT2PTR(void(*)(double, short, void *, void *), SvIV(c_func) );
	(*func)(d0, s1, p2, p3);

void
nci_vdspd( c_func, d0, s1, p2, d3 )
	SV* c_func
	double d0
	short s1
	void * p2
	double d3
PREINIT:
	void(*func)(double, short, void *, double);
CODE:
	func   = INT2PTR(void(*)(double, short, void *, double), SvIV(c_func) );
	(*func)(d0, s1, p2, d3);

void
nci_vdsps( c_func, d0, s1, p2, s3 )
	SV* c_func
	double d0
	short s1
	void * p2
	short s3
PREINIT:
	void(*func)(double, short, void *, short);
CODE:
	func   = INT2PTR(void(*)(double, short, void *, short), SvIV(c_func) );
	(*func)(d0, s1, p2, s3);

void
nci_vdspf( c_func, d0, s1, p2, f3 )
	SV* c_func
	double d0
	short s1
	void * p2
	float f3
PREINIT:
	void(*func)(double, short, void *, float);
CODE:
	func   = INT2PTR(void(*)(double, short, void *, float), SvIV(c_func) );
	(*func)(d0, s1, p2, f3);

void
nci_vdspt( c_func, d0, s1, p2, t3 )
	SV* c_func
	double d0
	short s1
	void * p2
	char * t3
PREINIT:
	void(*func)(double, short, void *, char *);
CODE:
	func   = INT2PTR(void(*)(double, short, void *, char *), SvIV(c_func) );
	(*func)(d0, s1, p2, t3);

void
nci_vdspi( c_func, d0, s1, p2, i3 )
	SV* c_func
	double d0
	short s1
	void * p2
	int i3
PREINIT:
	void(*func)(double, short, void *, int);
CODE:
	func   = INT2PTR(void(*)(double, short, void *, int), SvIV(c_func) );
	(*func)(d0, s1, p2, i3);

void
nci_vdsdp( c_func, d0, s1, d2, p3 )
	SV* c_func
	double d0
	short s1
	double d2
	void * p3
PREINIT:
	void(*func)(double, short, double, void *);
CODE:
	func   = INT2PTR(void(*)(double, short, double, void *), SvIV(c_func) );
	(*func)(d0, s1, d2, p3);

void
nci_vdsdd( c_func, d0, s1, d2, d3 )
	SV* c_func
	double d0
	short s1
	double d2
	double d3
PREINIT:
	void(*func)(double, short, double, double);
CODE:
	func   = INT2PTR(void(*)(double, short, double, double), SvIV(c_func) );
	(*func)(d0, s1, d2, d3);

void
nci_vdsds( c_func, d0, s1, d2, s3 )
	SV* c_func
	double d0
	short s1
	double d2
	short s3
PREINIT:
	void(*func)(double, short, double, short);
CODE:
	func   = INT2PTR(void(*)(double, short, double, short), SvIV(c_func) );
	(*func)(d0, s1, d2, s3);

void
nci_vdsdf( c_func, d0, s1, d2, f3 )
	SV* c_func
	double d0
	short s1
	double d2
	float f3
PREINIT:
	void(*func)(double, short, double, float);
CODE:
	func   = INT2PTR(void(*)(double, short, double, float), SvIV(c_func) );
	(*func)(d0, s1, d2, f3);

void
nci_vdsdt( c_func, d0, s1, d2, t3 )
	SV* c_func
	double d0
	short s1
	double d2
	char * t3
PREINIT:
	void(*func)(double, short, double, char *);
CODE:
	func   = INT2PTR(void(*)(double, short, double, char *), SvIV(c_func) );
	(*func)(d0, s1, d2, t3);

void
nci_vdsdi( c_func, d0, s1, d2, i3 )
	SV* c_func
	double d0
	short s1
	double d2
	int i3
PREINIT:
	void(*func)(double, short, double, int);
CODE:
	func   = INT2PTR(void(*)(double, short, double, int), SvIV(c_func) );
	(*func)(d0, s1, d2, i3);

void
nci_vdssp( c_func, d0, s1, s2, p3 )
	SV* c_func
	double d0
	short s1
	short s2
	void * p3
PREINIT:
	void(*func)(double, short, short, void *);
CODE:
	func   = INT2PTR(void(*)(double, short, short, void *), SvIV(c_func) );
	(*func)(d0, s1, s2, p3);

void
nci_vdssd( c_func, d0, s1, s2, d3 )
	SV* c_func
	double d0
	short s1
	short s2
	double d3
PREINIT:
	void(*func)(double, short, short, double);
CODE:
	func   = INT2PTR(void(*)(double, short, short, double), SvIV(c_func) );
	(*func)(d0, s1, s2, d3);

void
nci_vdsss( c_func, d0, s1, s2, s3 )
	SV* c_func
	double d0
	short s1
	short s2
	short s3
PREINIT:
	void(*func)(double, short, short, short);
CODE:
	func   = INT2PTR(void(*)(double, short, short, short), SvIV(c_func) );
	(*func)(d0, s1, s2, s3);

void
nci_vdssf( c_func, d0, s1, s2, f3 )
	SV* c_func
	double d0
	short s1
	short s2
	float f3
PREINIT:
	void(*func)(double, short, short, float);
CODE:
	func   = INT2PTR(void(*)(double, short, short, float), SvIV(c_func) );
	(*func)(d0, s1, s2, f3);

void
nci_vdsst( c_func, d0, s1, s2, t3 )
	SV* c_func
	double d0
	short s1
	short s2
	char * t3
PREINIT:
	void(*func)(double, short, short, char *);
CODE:
	func   = INT2PTR(void(*)(double, short, short, char *), SvIV(c_func) );
	(*func)(d0, s1, s2, t3);

void
nci_vdssi( c_func, d0, s1, s2, i3 )
	SV* c_func
	double d0
	short s1
	short s2
	int i3
PREINIT:
	void(*func)(double, short, short, int);
CODE:
	func   = INT2PTR(void(*)(double, short, short, int), SvIV(c_func) );
	(*func)(d0, s1, s2, i3);

void
nci_vdsfp( c_func, d0, s1, f2, p3 )
	SV* c_func
	double d0
	short s1
	float f2
	void * p3
PREINIT:
	void(*func)(double, short, float, void *);
CODE:
	func   = INT2PTR(void(*)(double, short, float, void *), SvIV(c_func) );
	(*func)(d0, s1, f2, p3);

void
nci_vdsfd( c_func, d0, s1, f2, d3 )
	SV* c_func
	double d0
	short s1
	float f2
	double d3
PREINIT:
	void(*func)(double, short, float, double);
CODE:
	func   = INT2PTR(void(*)(double, short, float, double), SvIV(c_func) );
	(*func)(d0, s1, f2, d3);

void
nci_vdsfs( c_func, d0, s1, f2, s3 )
	SV* c_func
	double d0
	short s1
	float f2
	short s3
PREINIT:
	void(*func)(double, short, float, short);
CODE:
	func   = INT2PTR(void(*)(double, short, float, short), SvIV(c_func) );
	(*func)(d0, s1, f2, s3);

void
nci_vdsff( c_func, d0, s1, f2, f3 )
	SV* c_func
	double d0
	short s1
	float f2
	float f3
PREINIT:
	void(*func)(double, short, float, float);
CODE:
	func   = INT2PTR(void(*)(double, short, float, float), SvIV(c_func) );
	(*func)(d0, s1, f2, f3);

void
nci_vdsft( c_func, d0, s1, f2, t3 )
	SV* c_func
	double d0
	short s1
	float f2
	char * t3
PREINIT:
	void(*func)(double, short, float, char *);
CODE:
	func   = INT2PTR(void(*)(double, short, float, char *), SvIV(c_func) );
	(*func)(d0, s1, f2, t3);

void
nci_vdsfi( c_func, d0, s1, f2, i3 )
	SV* c_func
	double d0
	short s1
	float f2
	int i3
PREINIT:
	void(*func)(double, short, float, int);
CODE:
	func   = INT2PTR(void(*)(double, short, float, int), SvIV(c_func) );
	(*func)(d0, s1, f2, i3);

void
nci_vdstp( c_func, d0, s1, t2, p3 )
	SV* c_func
	double d0
	short s1
	char * t2
	void * p3
PREINIT:
	void(*func)(double, short, char *, void *);
CODE:
	func   = INT2PTR(void(*)(double, short, char *, void *), SvIV(c_func) );
	(*func)(d0, s1, t2, p3);

void
nci_vdstd( c_func, d0, s1, t2, d3 )
	SV* c_func
	double d0
	short s1
	char * t2
	double d3
PREINIT:
	void(*func)(double, short, char *, double);
CODE:
	func   = INT2PTR(void(*)(double, short, char *, double), SvIV(c_func) );
	(*func)(d0, s1, t2, d3);

void
nci_vdsts( c_func, d0, s1, t2, s3 )
	SV* c_func
	double d0
	short s1
	char * t2
	short s3
PREINIT:
	void(*func)(double, short, char *, short);
CODE:
	func   = INT2PTR(void(*)(double, short, char *, short), SvIV(c_func) );
	(*func)(d0, s1, t2, s3);

void
nci_vdstf( c_func, d0, s1, t2, f3 )
	SV* c_func
	double d0
	short s1
	char * t2
	float f3
PREINIT:
	void(*func)(double, short, char *, float);
CODE:
	func   = INT2PTR(void(*)(double, short, char *, float), SvIV(c_func) );
	(*func)(d0, s1, t2, f3);

void
nci_vdstt( c_func, d0, s1, t2, t3 )
	SV* c_func
	double d0
	short s1
	char * t2
	char * t3
PREINIT:
	void(*func)(double, short, char *, char *);
CODE:
	func   = INT2PTR(void(*)(double, short, char *, char *), SvIV(c_func) );
	(*func)(d0, s1, t2, t3);

void
nci_vdsti( c_func, d0, s1, t2, i3 )
	SV* c_func
	double d0
	short s1
	char * t2
	int i3
PREINIT:
	void(*func)(double, short, char *, int);
CODE:
	func   = INT2PTR(void(*)(double, short, char *, int), SvIV(c_func) );
	(*func)(d0, s1, t2, i3);

void
nci_vdsip( c_func, d0, s1, i2, p3 )
	SV* c_func
	double d0
	short s1
	int i2
	void * p3
PREINIT:
	void(*func)(double, short, int, void *);
CODE:
	func   = INT2PTR(void(*)(double, short, int, void *), SvIV(c_func) );
	(*func)(d0, s1, i2, p3);

void
nci_vdsid( c_func, d0, s1, i2, d3 )
	SV* c_func
	double d0
	short s1
	int i2
	double d3
PREINIT:
	void(*func)(double, short, int, double);
CODE:
	func   = INT2PTR(void(*)(double, short, int, double), SvIV(c_func) );
	(*func)(d0, s1, i2, d3);

void
nci_vdsis( c_func, d0, s1, i2, s3 )
	SV* c_func
	double d0
	short s1
	int i2
	short s3
PREINIT:
	void(*func)(double, short, int, short);
CODE:
	func   = INT2PTR(void(*)(double, short, int, short), SvIV(c_func) );
	(*func)(d0, s1, i2, s3);

void
nci_vdsif( c_func, d0, s1, i2, f3 )
	SV* c_func
	double d0
	short s1
	int i2
	float f3
PREINIT:
	void(*func)(double, short, int, float);
CODE:
	func   = INT2PTR(void(*)(double, short, int, float), SvIV(c_func) );
	(*func)(d0, s1, i2, f3);

void
nci_vdsit( c_func, d0, s1, i2, t3 )
	SV* c_func
	double d0
	short s1
	int i2
	char * t3
PREINIT:
	void(*func)(double, short, int, char *);
CODE:
	func   = INT2PTR(void(*)(double, short, int, char *), SvIV(c_func) );
	(*func)(d0, s1, i2, t3);

void
nci_vdsii( c_func, d0, s1, i2, i3 )
	SV* c_func
	double d0
	short s1
	int i2
	int i3
PREINIT:
	void(*func)(double, short, int, int);
CODE:
	func   = INT2PTR(void(*)(double, short, int, int), SvIV(c_func) );
	(*func)(d0, s1, i2, i3);

void
nci_vdfpp( c_func, d0, f1, p2, p3 )
	SV* c_func
	double d0
	float f1
	void * p2
	void * p3
PREINIT:
	void(*func)(double, float, void *, void *);
CODE:
	func   = INT2PTR(void(*)(double, float, void *, void *), SvIV(c_func) );
	(*func)(d0, f1, p2, p3);

void
nci_vdfpd( c_func, d0, f1, p2, d3 )
	SV* c_func
	double d0
	float f1
	void * p2
	double d3
PREINIT:
	void(*func)(double, float, void *, double);
CODE:
	func   = INT2PTR(void(*)(double, float, void *, double), SvIV(c_func) );
	(*func)(d0, f1, p2, d3);

void
nci_vdfps( c_func, d0, f1, p2, s3 )
	SV* c_func
	double d0
	float f1
	void * p2
	short s3
PREINIT:
	void(*func)(double, float, void *, short);
CODE:
	func   = INT2PTR(void(*)(double, float, void *, short), SvIV(c_func) );
	(*func)(d0, f1, p2, s3);

void
nci_vdfpf( c_func, d0, f1, p2, f3 )
	SV* c_func
	double d0
	float f1
	void * p2
	float f3
PREINIT:
	void(*func)(double, float, void *, float);
CODE:
	func   = INT2PTR(void(*)(double, float, void *, float), SvIV(c_func) );
	(*func)(d0, f1, p2, f3);

void
nci_vdfpt( c_func, d0, f1, p2, t3 )
	SV* c_func
	double d0
	float f1
	void * p2
	char * t3
PREINIT:
	void(*func)(double, float, void *, char *);
CODE:
	func   = INT2PTR(void(*)(double, float, void *, char *), SvIV(c_func) );
	(*func)(d0, f1, p2, t3);

void
nci_vdfpi( c_func, d0, f1, p2, i3 )
	SV* c_func
	double d0
	float f1
	void * p2
	int i3
PREINIT:
	void(*func)(double, float, void *, int);
CODE:
	func   = INT2PTR(void(*)(double, float, void *, int), SvIV(c_func) );
	(*func)(d0, f1, p2, i3);

void
nci_vdfdp( c_func, d0, f1, d2, p3 )
	SV* c_func
	double d0
	float f1
	double d2
	void * p3
PREINIT:
	void(*func)(double, float, double, void *);
CODE:
	func   = INT2PTR(void(*)(double, float, double, void *), SvIV(c_func) );
	(*func)(d0, f1, d2, p3);

void
nci_vdfdd( c_func, d0, f1, d2, d3 )
	SV* c_func
	double d0
	float f1
	double d2
	double d3
PREINIT:
	void(*func)(double, float, double, double);
CODE:
	func   = INT2PTR(void(*)(double, float, double, double), SvIV(c_func) );
	(*func)(d0, f1, d2, d3);

void
nci_vdfds( c_func, d0, f1, d2, s3 )
	SV* c_func
	double d0
	float f1
	double d2
	short s3
PREINIT:
	void(*func)(double, float, double, short);
CODE:
	func   = INT2PTR(void(*)(double, float, double, short), SvIV(c_func) );
	(*func)(d0, f1, d2, s3);

void
nci_vdfdf( c_func, d0, f1, d2, f3 )
	SV* c_func
	double d0
	float f1
	double d2
	float f3
PREINIT:
	void(*func)(double, float, double, float);
CODE:
	func   = INT2PTR(void(*)(double, float, double, float), SvIV(c_func) );
	(*func)(d0, f1, d2, f3);

void
nci_vdfdt( c_func, d0, f1, d2, t3 )
	SV* c_func
	double d0
	float f1
	double d2
	char * t3
PREINIT:
	void(*func)(double, float, double, char *);
CODE:
	func   = INT2PTR(void(*)(double, float, double, char *), SvIV(c_func) );
	(*func)(d0, f1, d2, t3);

void
nci_vdfdi( c_func, d0, f1, d2, i3 )
	SV* c_func
	double d0
	float f1
	double d2
	int i3
PREINIT:
	void(*func)(double, float, double, int);
CODE:
	func   = INT2PTR(void(*)(double, float, double, int), SvIV(c_func) );
	(*func)(d0, f1, d2, i3);

void
nci_vdfsp( c_func, d0, f1, s2, p3 )
	SV* c_func
	double d0
	float f1
	short s2
	void * p3
PREINIT:
	void(*func)(double, float, short, void *);
CODE:
	func   = INT2PTR(void(*)(double, float, short, void *), SvIV(c_func) );
	(*func)(d0, f1, s2, p3);

void
nci_vdfsd( c_func, d0, f1, s2, d3 )
	SV* c_func
	double d0
	float f1
	short s2
	double d3
PREINIT:
	void(*func)(double, float, short, double);
CODE:
	func   = INT2PTR(void(*)(double, float, short, double), SvIV(c_func) );
	(*func)(d0, f1, s2, d3);

void
nci_vdfss( c_func, d0, f1, s2, s3 )
	SV* c_func
	double d0
	float f1
	short s2
	short s3
PREINIT:
	void(*func)(double, float, short, short);
CODE:
	func   = INT2PTR(void(*)(double, float, short, short), SvIV(c_func) );
	(*func)(d0, f1, s2, s3);

void
nci_vdfsf( c_func, d0, f1, s2, f3 )
	SV* c_func
	double d0
	float f1
	short s2
	float f3
PREINIT:
	void(*func)(double, float, short, float);
CODE:
	func   = INT2PTR(void(*)(double, float, short, float), SvIV(c_func) );
	(*func)(d0, f1, s2, f3);

void
nci_vdfst( c_func, d0, f1, s2, t3 )
	SV* c_func
	double d0
	float f1
	short s2
	char * t3
PREINIT:
	void(*func)(double, float, short, char *);
CODE:
	func   = INT2PTR(void(*)(double, float, short, char *), SvIV(c_func) );
	(*func)(d0, f1, s2, t3);

void
nci_vdfsi( c_func, d0, f1, s2, i3 )
	SV* c_func
	double d0
	float f1
	short s2
	int i3
PREINIT:
	void(*func)(double, float, short, int);
CODE:
	func   = INT2PTR(void(*)(double, float, short, int), SvIV(c_func) );
	(*func)(d0, f1, s2, i3);

void
nci_vdffp( c_func, d0, f1, f2, p3 )
	SV* c_func
	double d0
	float f1
	float f2
	void * p3
PREINIT:
	void(*func)(double, float, float, void *);
CODE:
	func   = INT2PTR(void(*)(double, float, float, void *), SvIV(c_func) );
	(*func)(d0, f1, f2, p3);

void
nci_vdffd( c_func, d0, f1, f2, d3 )
	SV* c_func
	double d0
	float f1
	float f2
	double d3
PREINIT:
	void(*func)(double, float, float, double);
CODE:
	func   = INT2PTR(void(*)(double, float, float, double), SvIV(c_func) );
	(*func)(d0, f1, f2, d3);

void
nci_vdffs( c_func, d0, f1, f2, s3 )
	SV* c_func
	double d0
	float f1
	float f2
	short s3
PREINIT:
	void(*func)(double, float, float, short);
CODE:
	func   = INT2PTR(void(*)(double, float, float, short), SvIV(c_func) );
	(*func)(d0, f1, f2, s3);

void
nci_vdfff( c_func, d0, f1, f2, f3 )
	SV* c_func
	double d0
	float f1
	float f2
	float f3
PREINIT:
	void(*func)(double, float, float, float);
CODE:
	func   = INT2PTR(void(*)(double, float, float, float), SvIV(c_func) );
	(*func)(d0, f1, f2, f3);

void
nci_vdfft( c_func, d0, f1, f2, t3 )
	SV* c_func
	double d0
	float f1
	float f2
	char * t3
PREINIT:
	void(*func)(double, float, float, char *);
CODE:
	func   = INT2PTR(void(*)(double, float, float, char *), SvIV(c_func) );
	(*func)(d0, f1, f2, t3);

void
nci_vdffi( c_func, d0, f1, f2, i3 )
	SV* c_func
	double d0
	float f1
	float f2
	int i3
PREINIT:
	void(*func)(double, float, float, int);
CODE:
	func   = INT2PTR(void(*)(double, float, float, int), SvIV(c_func) );
	(*func)(d0, f1, f2, i3);

void
nci_vdftp( c_func, d0, f1, t2, p3 )
	SV* c_func
	double d0
	float f1
	char * t2
	void * p3
PREINIT:
	void(*func)(double, float, char *, void *);
CODE:
	func   = INT2PTR(void(*)(double, float, char *, void *), SvIV(c_func) );
	(*func)(d0, f1, t2, p3);

void
nci_vdftd( c_func, d0, f1, t2, d3 )
	SV* c_func
	double d0
	float f1
	char * t2
	double d3
PREINIT:
	void(*func)(double, float, char *, double);
CODE:
	func   = INT2PTR(void(*)(double, float, char *, double), SvIV(c_func) );
	(*func)(d0, f1, t2, d3);

void
nci_vdfts( c_func, d0, f1, t2, s3 )
	SV* c_func
	double d0
	float f1
	char * t2
	short s3
PREINIT:
	void(*func)(double, float, char *, short);
CODE:
	func   = INT2PTR(void(*)(double, float, char *, short), SvIV(c_func) );
	(*func)(d0, f1, t2, s3);

void
nci_vdftf( c_func, d0, f1, t2, f3 )
	SV* c_func
	double d0
	float f1
	char * t2
	float f3
PREINIT:
	void(*func)(double, float, char *, float);
CODE:
	func   = INT2PTR(void(*)(double, float, char *, float), SvIV(c_func) );
	(*func)(d0, f1, t2, f3);

void
nci_vdftt( c_func, d0, f1, t2, t3 )
	SV* c_func
	double d0
	float f1
	char * t2
	char * t3
PREINIT:
	void(*func)(double, float, char *, char *);
CODE:
	func   = INT2PTR(void(*)(double, float, char *, char *), SvIV(c_func) );
	(*func)(d0, f1, t2, t3);

void
nci_vdfti( c_func, d0, f1, t2, i3 )
	SV* c_func
	double d0
	float f1
	char * t2
	int i3
PREINIT:
	void(*func)(double, float, char *, int);
CODE:
	func   = INT2PTR(void(*)(double, float, char *, int), SvIV(c_func) );
	(*func)(d0, f1, t2, i3);

void
nci_vdfip( c_func, d0, f1, i2, p3 )
	SV* c_func
	double d0
	float f1
	int i2
	void * p3
PREINIT:
	void(*func)(double, float, int, void *);
CODE:
	func   = INT2PTR(void(*)(double, float, int, void *), SvIV(c_func) );
	(*func)(d0, f1, i2, p3);

void
nci_vdfid( c_func, d0, f1, i2, d3 )
	SV* c_func
	double d0
	float f1
	int i2
	double d3
PREINIT:
	void(*func)(double, float, int, double);
CODE:
	func   = INT2PTR(void(*)(double, float, int, double), SvIV(c_func) );
	(*func)(d0, f1, i2, d3);

void
nci_vdfis( c_func, d0, f1, i2, s3 )
	SV* c_func
	double d0
	float f1
	int i2
	short s3
PREINIT:
	void(*func)(double, float, int, short);
CODE:
	func   = INT2PTR(void(*)(double, float, int, short), SvIV(c_func) );
	(*func)(d0, f1, i2, s3);

void
nci_vdfif( c_func, d0, f1, i2, f3 )
	SV* c_func
	double d0
	float f1
	int i2
	float f3
PREINIT:
	void(*func)(double, float, int, float);
CODE:
	func   = INT2PTR(void(*)(double, float, int, float), SvIV(c_func) );
	(*func)(d0, f1, i2, f3);

void
nci_vdfit( c_func, d0, f1, i2, t3 )
	SV* c_func
	double d0
	float f1
	int i2
	char * t3
PREINIT:
	void(*func)(double, float, int, char *);
CODE:
	func   = INT2PTR(void(*)(double, float, int, char *), SvIV(c_func) );
	(*func)(d0, f1, i2, t3);

void
nci_vdfii( c_func, d0, f1, i2, i3 )
	SV* c_func
	double d0
	float f1
	int i2
	int i3
PREINIT:
	void(*func)(double, float, int, int);
CODE:
	func   = INT2PTR(void(*)(double, float, int, int), SvIV(c_func) );
	(*func)(d0, f1, i2, i3);

void
nci_vdtpp( c_func, d0, t1, p2, p3 )
	SV* c_func
	double d0
	char * t1
	void * p2
	void * p3
PREINIT:
	void(*func)(double, char *, void *, void *);
CODE:
	func   = INT2PTR(void(*)(double, char *, void *, void *), SvIV(c_func) );
	(*func)(d0, t1, p2, p3);

void
nci_vdtpd( c_func, d0, t1, p2, d3 )
	SV* c_func
	double d0
	char * t1
	void * p2
	double d3
PREINIT:
	void(*func)(double, char *, void *, double);
CODE:
	func   = INT2PTR(void(*)(double, char *, void *, double), SvIV(c_func) );
	(*func)(d0, t1, p2, d3);

void
nci_vdtps( c_func, d0, t1, p2, s3 )
	SV* c_func
	double d0
	char * t1
	void * p2
	short s3
PREINIT:
	void(*func)(double, char *, void *, short);
CODE:
	func   = INT2PTR(void(*)(double, char *, void *, short), SvIV(c_func) );
	(*func)(d0, t1, p2, s3);

void
nci_vdtpf( c_func, d0, t1, p2, f3 )
	SV* c_func
	double d0
	char * t1
	void * p2
	float f3
PREINIT:
	void(*func)(double, char *, void *, float);
CODE:
	func   = INT2PTR(void(*)(double, char *, void *, float), SvIV(c_func) );
	(*func)(d0, t1, p2, f3);

void
nci_vdtpt( c_func, d0, t1, p2, t3 )
	SV* c_func
	double d0
	char * t1
	void * p2
	char * t3
PREINIT:
	void(*func)(double, char *, void *, char *);
CODE:
	func   = INT2PTR(void(*)(double, char *, void *, char *), SvIV(c_func) );
	(*func)(d0, t1, p2, t3);

void
nci_vdtpi( c_func, d0, t1, p2, i3 )
	SV* c_func
	double d0
	char * t1
	void * p2
	int i3
PREINIT:
	void(*func)(double, char *, void *, int);
CODE:
	func   = INT2PTR(void(*)(double, char *, void *, int), SvIV(c_func) );
	(*func)(d0, t1, p2, i3);

void
nci_vdtdp( c_func, d0, t1, d2, p3 )
	SV* c_func
	double d0
	char * t1
	double d2
	void * p3
PREINIT:
	void(*func)(double, char *, double, void *);
CODE:
	func   = INT2PTR(void(*)(double, char *, double, void *), SvIV(c_func) );
	(*func)(d0, t1, d2, p3);

void
nci_vdtdd( c_func, d0, t1, d2, d3 )
	SV* c_func
	double d0
	char * t1
	double d2
	double d3
PREINIT:
	void(*func)(double, char *, double, double);
CODE:
	func   = INT2PTR(void(*)(double, char *, double, double), SvIV(c_func) );
	(*func)(d0, t1, d2, d3);

void
nci_vdtds( c_func, d0, t1, d2, s3 )
	SV* c_func
	double d0
	char * t1
	double d2
	short s3
PREINIT:
	void(*func)(double, char *, double, short);
CODE:
	func   = INT2PTR(void(*)(double, char *, double, short), SvIV(c_func) );
	(*func)(d0, t1, d2, s3);

void
nci_vdtdf( c_func, d0, t1, d2, f3 )
	SV* c_func
	double d0
	char * t1
	double d2
	float f3
PREINIT:
	void(*func)(double, char *, double, float);
CODE:
	func   = INT2PTR(void(*)(double, char *, double, float), SvIV(c_func) );
	(*func)(d0, t1, d2, f3);

void
nci_vdtdt( c_func, d0, t1, d2, t3 )
	SV* c_func
	double d0
	char * t1
	double d2
	char * t3
PREINIT:
	void(*func)(double, char *, double, char *);
CODE:
	func   = INT2PTR(void(*)(double, char *, double, char *), SvIV(c_func) );
	(*func)(d0, t1, d2, t3);

void
nci_vdtdi( c_func, d0, t1, d2, i3 )
	SV* c_func
	double d0
	char * t1
	double d2
	int i3
PREINIT:
	void(*func)(double, char *, double, int);
CODE:
	func   = INT2PTR(void(*)(double, char *, double, int), SvIV(c_func) );
	(*func)(d0, t1, d2, i3);

void
nci_vdtsp( c_func, d0, t1, s2, p3 )
	SV* c_func
	double d0
	char * t1
	short s2
	void * p3
PREINIT:
	void(*func)(double, char *, short, void *);
CODE:
	func   = INT2PTR(void(*)(double, char *, short, void *), SvIV(c_func) );
	(*func)(d0, t1, s2, p3);

void
nci_vdtsd( c_func, d0, t1, s2, d3 )
	SV* c_func
	double d0
	char * t1
	short s2
	double d3
PREINIT:
	void(*func)(double, char *, short, double);
CODE:
	func   = INT2PTR(void(*)(double, char *, short, double), SvIV(c_func) );
	(*func)(d0, t1, s2, d3);

void
nci_vdtss( c_func, d0, t1, s2, s3 )
	SV* c_func
	double d0
	char * t1
	short s2
	short s3
PREINIT:
	void(*func)(double, char *, short, short);
CODE:
	func   = INT2PTR(void(*)(double, char *, short, short), SvIV(c_func) );
	(*func)(d0, t1, s2, s3);

void
nci_vdtsf( c_func, d0, t1, s2, f3 )
	SV* c_func
	double d0
	char * t1
	short s2
	float f3
PREINIT:
	void(*func)(double, char *, short, float);
CODE:
	func   = INT2PTR(void(*)(double, char *, short, float), SvIV(c_func) );
	(*func)(d0, t1, s2, f3);

void
nci_vdtst( c_func, d0, t1, s2, t3 )
	SV* c_func
	double d0
	char * t1
	short s2
	char * t3
PREINIT:
	void(*func)(double, char *, short, char *);
CODE:
	func   = INT2PTR(void(*)(double, char *, short, char *), SvIV(c_func) );
	(*func)(d0, t1, s2, t3);

void
nci_vdtsi( c_func, d0, t1, s2, i3 )
	SV* c_func
	double d0
	char * t1
	short s2
	int i3
PREINIT:
	void(*func)(double, char *, short, int);
CODE:
	func   = INT2PTR(void(*)(double, char *, short, int), SvIV(c_func) );
	(*func)(d0, t1, s2, i3);

void
nci_vdtfp( c_func, d0, t1, f2, p3 )
	SV* c_func
	double d0
	char * t1
	float f2
	void * p3
PREINIT:
	void(*func)(double, char *, float, void *);
CODE:
	func   = INT2PTR(void(*)(double, char *, float, void *), SvIV(c_func) );
	(*func)(d0, t1, f2, p3);

void
nci_vdtfd( c_func, d0, t1, f2, d3 )
	SV* c_func
	double d0
	char * t1
	float f2
	double d3
PREINIT:
	void(*func)(double, char *, float, double);
CODE:
	func   = INT2PTR(void(*)(double, char *, float, double), SvIV(c_func) );
	(*func)(d0, t1, f2, d3);

void
nci_vdtfs( c_func, d0, t1, f2, s3 )
	SV* c_func
	double d0
	char * t1
	float f2
	short s3
PREINIT:
	void(*func)(double, char *, float, short);
CODE:
	func   = INT2PTR(void(*)(double, char *, float, short), SvIV(c_func) );
	(*func)(d0, t1, f2, s3);

void
nci_vdtff( c_func, d0, t1, f2, f3 )
	SV* c_func
	double d0
	char * t1
	float f2
	float f3
PREINIT:
	void(*func)(double, char *, float, float);
CODE:
	func   = INT2PTR(void(*)(double, char *, float, float), SvIV(c_func) );
	(*func)(d0, t1, f2, f3);

void
nci_vdtft( c_func, d0, t1, f2, t3 )
	SV* c_func
	double d0
	char * t1
	float f2
	char * t3
PREINIT:
	void(*func)(double, char *, float, char *);
CODE:
	func   = INT2PTR(void(*)(double, char *, float, char *), SvIV(c_func) );
	(*func)(d0, t1, f2, t3);

void
nci_vdtfi( c_func, d0, t1, f2, i3 )
	SV* c_func
	double d0
	char * t1
	float f2
	int i3
PREINIT:
	void(*func)(double, char *, float, int);
CODE:
	func   = INT2PTR(void(*)(double, char *, float, int), SvIV(c_func) );
	(*func)(d0, t1, f2, i3);

void
nci_vdttp( c_func, d0, t1, t2, p3 )
	SV* c_func
	double d0
	char * t1
	char * t2
	void * p3
PREINIT:
	void(*func)(double, char *, char *, void *);
CODE:
	func   = INT2PTR(void(*)(double, char *, char *, void *), SvIV(c_func) );
	(*func)(d0, t1, t2, p3);

void
nci_vdttd( c_func, d0, t1, t2, d3 )
	SV* c_func
	double d0
	char * t1
	char * t2
	double d3
PREINIT:
	void(*func)(double, char *, char *, double);
CODE:
	func   = INT2PTR(void(*)(double, char *, char *, double), SvIV(c_func) );
	(*func)(d0, t1, t2, d3);

void
nci_vdtts( c_func, d0, t1, t2, s3 )
	SV* c_func
	double d0
	char * t1
	char * t2
	short s3
PREINIT:
	void(*func)(double, char *, char *, short);
CODE:
	func   = INT2PTR(void(*)(double, char *, char *, short), SvIV(c_func) );
	(*func)(d0, t1, t2, s3);

void
nci_vdttf( c_func, d0, t1, t2, f3 )
	SV* c_func
	double d0
	char * t1
	char * t2
	float f3
PREINIT:
	void(*func)(double, char *, char *, float);
CODE:
	func   = INT2PTR(void(*)(double, char *, char *, float), SvIV(c_func) );
	(*func)(d0, t1, t2, f3);

void
nci_vdttt( c_func, d0, t1, t2, t3 )
	SV* c_func
	double d0
	char * t1
	char * t2
	char * t3
PREINIT:
	void(*func)(double, char *, char *, char *);
CODE:
	func   = INT2PTR(void(*)(double, char *, char *, char *), SvIV(c_func) );
	(*func)(d0, t1, t2, t3);

void
nci_vdtti( c_func, d0, t1, t2, i3 )
	SV* c_func
	double d0
	char * t1
	char * t2
	int i3
PREINIT:
	void(*func)(double, char *, char *, int);
CODE:
	func   = INT2PTR(void(*)(double, char *, char *, int), SvIV(c_func) );
	(*func)(d0, t1, t2, i3);

void
nci_vdtip( c_func, d0, t1, i2, p3 )
	SV* c_func
	double d0
	char * t1
	int i2
	void * p3
PREINIT:
	void(*func)(double, char *, int, void *);
CODE:
	func   = INT2PTR(void(*)(double, char *, int, void *), SvIV(c_func) );
	(*func)(d0, t1, i2, p3);

void
nci_vdtid( c_func, d0, t1, i2, d3 )
	SV* c_func
	double d0
	char * t1
	int i2
	double d3
PREINIT:
	void(*func)(double, char *, int, double);
CODE:
	func   = INT2PTR(void(*)(double, char *, int, double), SvIV(c_func) );
	(*func)(d0, t1, i2, d3);

void
nci_vdtis( c_func, d0, t1, i2, s3 )
	SV* c_func
	double d0
	char * t1
	int i2
	short s3
PREINIT:
	void(*func)(double, char *, int, short);
CODE:
	func   = INT2PTR(void(*)(double, char *, int, short), SvIV(c_func) );
	(*func)(d0, t1, i2, s3);

void
nci_vdtif( c_func, d0, t1, i2, f3 )
	SV* c_func
	double d0
	char * t1
	int i2
	float f3
PREINIT:
	void(*func)(double, char *, int, float);
CODE:
	func   = INT2PTR(void(*)(double, char *, int, float), SvIV(c_func) );
	(*func)(d0, t1, i2, f3);

void
nci_vdtit( c_func, d0, t1, i2, t3 )
	SV* c_func
	double d0
	char * t1
	int i2
	char * t3
PREINIT:
	void(*func)(double, char *, int, char *);
CODE:
	func   = INT2PTR(void(*)(double, char *, int, char *), SvIV(c_func) );
	(*func)(d0, t1, i2, t3);

void
nci_vdtii( c_func, d0, t1, i2, i3 )
	SV* c_func
	double d0
	char * t1
	int i2
	int i3
PREINIT:
	void(*func)(double, char *, int, int);
CODE:
	func   = INT2PTR(void(*)(double, char *, int, int), SvIV(c_func) );
	(*func)(d0, t1, i2, i3);

void
nci_vdipp( c_func, d0, i1, p2, p3 )
	SV* c_func
	double d0
	int i1
	void * p2
	void * p3
PREINIT:
	void(*func)(double, int, void *, void *);
CODE:
	func   = INT2PTR(void(*)(double, int, void *, void *), SvIV(c_func) );
	(*func)(d0, i1, p2, p3);

void
nci_vdipd( c_func, d0, i1, p2, d3 )
	SV* c_func
	double d0
	int i1
	void * p2
	double d3
PREINIT:
	void(*func)(double, int, void *, double);
CODE:
	func   = INT2PTR(void(*)(double, int, void *, double), SvIV(c_func) );
	(*func)(d0, i1, p2, d3);

void
nci_vdips( c_func, d0, i1, p2, s3 )
	SV* c_func
	double d0
	int i1
	void * p2
	short s3
PREINIT:
	void(*func)(double, int, void *, short);
CODE:
	func   = INT2PTR(void(*)(double, int, void *, short), SvIV(c_func) );
	(*func)(d0, i1, p2, s3);

void
nci_vdipf( c_func, d0, i1, p2, f3 )
	SV* c_func
	double d0
	int i1
	void * p2
	float f3
PREINIT:
	void(*func)(double, int, void *, float);
CODE:
	func   = INT2PTR(void(*)(double, int, void *, float), SvIV(c_func) );
	(*func)(d0, i1, p2, f3);

void
nci_vdipt( c_func, d0, i1, p2, t3 )
	SV* c_func
	double d0
	int i1
	void * p2
	char * t3
PREINIT:
	void(*func)(double, int, void *, char *);
CODE:
	func   = INT2PTR(void(*)(double, int, void *, char *), SvIV(c_func) );
	(*func)(d0, i1, p2, t3);

void
nci_vdipi( c_func, d0, i1, p2, i3 )
	SV* c_func
	double d0
	int i1
	void * p2
	int i3
PREINIT:
	void(*func)(double, int, void *, int);
CODE:
	func   = INT2PTR(void(*)(double, int, void *, int), SvIV(c_func) );
	(*func)(d0, i1, p2, i3);

void
nci_vdidp( c_func, d0, i1, d2, p3 )
	SV* c_func
	double d0
	int i1
	double d2
	void * p3
PREINIT:
	void(*func)(double, int, double, void *);
CODE:
	func   = INT2PTR(void(*)(double, int, double, void *), SvIV(c_func) );
	(*func)(d0, i1, d2, p3);

void
nci_vdidd( c_func, d0, i1, d2, d3 )
	SV* c_func
	double d0
	int i1
	double d2
	double d3
PREINIT:
	void(*func)(double, int, double, double);
CODE:
	func   = INT2PTR(void(*)(double, int, double, double), SvIV(c_func) );
	(*func)(d0, i1, d2, d3);

void
nci_vdids( c_func, d0, i1, d2, s3 )
	SV* c_func
	double d0
	int i1
	double d2
	short s3
PREINIT:
	void(*func)(double, int, double, short);
CODE:
	func   = INT2PTR(void(*)(double, int, double, short), SvIV(c_func) );
	(*func)(d0, i1, d2, s3);

void
nci_vdidf( c_func, d0, i1, d2, f3 )
	SV* c_func
	double d0
	int i1
	double d2
	float f3
PREINIT:
	void(*func)(double, int, double, float);
CODE:
	func   = INT2PTR(void(*)(double, int, double, float), SvIV(c_func) );
	(*func)(d0, i1, d2, f3);

void
nci_vdidt( c_func, d0, i1, d2, t3 )
	SV* c_func
	double d0
	int i1
	double d2
	char * t3
PREINIT:
	void(*func)(double, int, double, char *);
CODE:
	func   = INT2PTR(void(*)(double, int, double, char *), SvIV(c_func) );
	(*func)(d0, i1, d2, t3);

void
nci_vdidi( c_func, d0, i1, d2, i3 )
	SV* c_func
	double d0
	int i1
	double d2
	int i3
PREINIT:
	void(*func)(double, int, double, int);
CODE:
	func   = INT2PTR(void(*)(double, int, double, int), SvIV(c_func) );
	(*func)(d0, i1, d2, i3);

void
nci_vdisp( c_func, d0, i1, s2, p3 )
	SV* c_func
	double d0
	int i1
	short s2
	void * p3
PREINIT:
	void(*func)(double, int, short, void *);
CODE:
	func   = INT2PTR(void(*)(double, int, short, void *), SvIV(c_func) );
	(*func)(d0, i1, s2, p3);

void
nci_vdisd( c_func, d0, i1, s2, d3 )
	SV* c_func
	double d0
	int i1
	short s2
	double d3
PREINIT:
	void(*func)(double, int, short, double);
CODE:
	func   = INT2PTR(void(*)(double, int, short, double), SvIV(c_func) );
	(*func)(d0, i1, s2, d3);

void
nci_vdiss( c_func, d0, i1, s2, s3 )
	SV* c_func
	double d0
	int i1
	short s2
	short s3
PREINIT:
	void(*func)(double, int, short, short);
CODE:
	func   = INT2PTR(void(*)(double, int, short, short), SvIV(c_func) );
	(*func)(d0, i1, s2, s3);

void
nci_vdisf( c_func, d0, i1, s2, f3 )
	SV* c_func
	double d0
	int i1
	short s2
	float f3
PREINIT:
	void(*func)(double, int, short, float);
CODE:
	func   = INT2PTR(void(*)(double, int, short, float), SvIV(c_func) );
	(*func)(d0, i1, s2, f3);

void
nci_vdist( c_func, d0, i1, s2, t3 )
	SV* c_func
	double d0
	int i1
	short s2
	char * t3
PREINIT:
	void(*func)(double, int, short, char *);
CODE:
	func   = INT2PTR(void(*)(double, int, short, char *), SvIV(c_func) );
	(*func)(d0, i1, s2, t3);

void
nci_vdisi( c_func, d0, i1, s2, i3 )
	SV* c_func
	double d0
	int i1
	short s2
	int i3
PREINIT:
	void(*func)(double, int, short, int);
CODE:
	func   = INT2PTR(void(*)(double, int, short, int), SvIV(c_func) );
	(*func)(d0, i1, s2, i3);

void
nci_vdifp( c_func, d0, i1, f2, p3 )
	SV* c_func
	double d0
	int i1
	float f2
	void * p3
PREINIT:
	void(*func)(double, int, float, void *);
CODE:
	func   = INT2PTR(void(*)(double, int, float, void *), SvIV(c_func) );
	(*func)(d0, i1, f2, p3);

void
nci_vdifd( c_func, d0, i1, f2, d3 )
	SV* c_func
	double d0
	int i1
	float f2
	double d3
PREINIT:
	void(*func)(double, int, float, double);
CODE:
	func   = INT2PTR(void(*)(double, int, float, double), SvIV(c_func) );
	(*func)(d0, i1, f2, d3);

void
nci_vdifs( c_func, d0, i1, f2, s3 )
	SV* c_func
	double d0
	int i1
	float f2
	short s3
PREINIT:
	void(*func)(double, int, float, short);
CODE:
	func   = INT2PTR(void(*)(double, int, float, short), SvIV(c_func) );
	(*func)(d0, i1, f2, s3);

void
nci_vdiff( c_func, d0, i1, f2, f3 )
	SV* c_func
	double d0
	int i1
	float f2
	float f3
PREINIT:
	void(*func)(double, int, float, float);
CODE:
	func   = INT2PTR(void(*)(double, int, float, float), SvIV(c_func) );
	(*func)(d0, i1, f2, f3);

void
nci_vdift( c_func, d0, i1, f2, t3 )
	SV* c_func
	double d0
	int i1
	float f2
	char * t3
PREINIT:
	void(*func)(double, int, float, char *);
CODE:
	func   = INT2PTR(void(*)(double, int, float, char *), SvIV(c_func) );
	(*func)(d0, i1, f2, t3);

void
nci_vdifi( c_func, d0, i1, f2, i3 )
	SV* c_func
	double d0
	int i1
	float f2
	int i3
PREINIT:
	void(*func)(double, int, float, int);
CODE:
	func   = INT2PTR(void(*)(double, int, float, int), SvIV(c_func) );
	(*func)(d0, i1, f2, i3);

void
nci_vditp( c_func, d0, i1, t2, p3 )
	SV* c_func
	double d0
	int i1
	char * t2
	void * p3
PREINIT:
	void(*func)(double, int, char *, void *);
CODE:
	func   = INT2PTR(void(*)(double, int, char *, void *), SvIV(c_func) );
	(*func)(d0, i1, t2, p3);

void
nci_vditd( c_func, d0, i1, t2, d3 )
	SV* c_func
	double d0
	int i1
	char * t2
	double d3
PREINIT:
	void(*func)(double, int, char *, double);
CODE:
	func   = INT2PTR(void(*)(double, int, char *, double), SvIV(c_func) );
	(*func)(d0, i1, t2, d3);

void
nci_vdits( c_func, d0, i1, t2, s3 )
	SV* c_func
	double d0
	int i1
	char * t2
	short s3
PREINIT:
	void(*func)(double, int, char *, short);
CODE:
	func   = INT2PTR(void(*)(double, int, char *, short), SvIV(c_func) );
	(*func)(d0, i1, t2, s3);

void
nci_vditf( c_func, d0, i1, t2, f3 )
	SV* c_func
	double d0
	int i1
	char * t2
	float f3
PREINIT:
	void(*func)(double, int, char *, float);
CODE:
	func   = INT2PTR(void(*)(double, int, char *, float), SvIV(c_func) );
	(*func)(d0, i1, t2, f3);

void
nci_vditt( c_func, d0, i1, t2, t3 )
	SV* c_func
	double d0
	int i1
	char * t2
	char * t3
PREINIT:
	void(*func)(double, int, char *, char *);
CODE:
	func   = INT2PTR(void(*)(double, int, char *, char *), SvIV(c_func) );
	(*func)(d0, i1, t2, t3);

void
nci_vditi( c_func, d0, i1, t2, i3 )
	SV* c_func
	double d0
	int i1
	char * t2
	int i3
PREINIT:
	void(*func)(double, int, char *, int);
CODE:
	func   = INT2PTR(void(*)(double, int, char *, int), SvIV(c_func) );
	(*func)(d0, i1, t2, i3);

void
nci_vdiip( c_func, d0, i1, i2, p3 )
	SV* c_func
	double d0
	int i1
	int i2
	void * p3
PREINIT:
	void(*func)(double, int, int, void *);
CODE:
	func   = INT2PTR(void(*)(double, int, int, void *), SvIV(c_func) );
	(*func)(d0, i1, i2, p3);

void
nci_vdiid( c_func, d0, i1, i2, d3 )
	SV* c_func
	double d0
	int i1
	int i2
	double d3
PREINIT:
	void(*func)(double, int, int, double);
CODE:
	func   = INT2PTR(void(*)(double, int, int, double), SvIV(c_func) );
	(*func)(d0, i1, i2, d3);

void
nci_vdiis( c_func, d0, i1, i2, s3 )
	SV* c_func
	double d0
	int i1
	int i2
	short s3
PREINIT:
	void(*func)(double, int, int, short);
CODE:
	func   = INT2PTR(void(*)(double, int, int, short), SvIV(c_func) );
	(*func)(d0, i1, i2, s3);

void
nci_vdiif( c_func, d0, i1, i2, f3 )
	SV* c_func
	double d0
	int i1
	int i2
	float f3
PREINIT:
	void(*func)(double, int, int, float);
CODE:
	func   = INT2PTR(void(*)(double, int, int, float), SvIV(c_func) );
	(*func)(d0, i1, i2, f3);

void
nci_vdiit( c_func, d0, i1, i2, t3 )
	SV* c_func
	double d0
	int i1
	int i2
	char * t3
PREINIT:
	void(*func)(double, int, int, char *);
CODE:
	func   = INT2PTR(void(*)(double, int, int, char *), SvIV(c_func) );
	(*func)(d0, i1, i2, t3);

void
nci_vdiii( c_func, d0, i1, i2, i3 )
	SV* c_func
	double d0
	int i1
	int i2
	int i3
PREINIT:
	void(*func)(double, int, int, int);
CODE:
	func   = INT2PTR(void(*)(double, int, int, int), SvIV(c_func) );
	(*func)(d0, i1, i2, i3);

void
nci_vsppp( c_func, s0, p1, p2, p3 )
	SV* c_func
	short s0
	void * p1
	void * p2
	void * p3
PREINIT:
	void(*func)(short, void *, void *, void *);
CODE:
	func   = INT2PTR(void(*)(short, void *, void *, void *), SvIV(c_func) );
	(*func)(s0, p1, p2, p3);

void
nci_vsppd( c_func, s0, p1, p2, d3 )
	SV* c_func
	short s0
	void * p1
	void * p2
	double d3
PREINIT:
	void(*func)(short, void *, void *, double);
CODE:
	func   = INT2PTR(void(*)(short, void *, void *, double), SvIV(c_func) );
	(*func)(s0, p1, p2, d3);

void
nci_vspps( c_func, s0, p1, p2, s3 )
	SV* c_func
	short s0
	void * p1
	void * p2
	short s3
PREINIT:
	void(*func)(short, void *, void *, short);
CODE:
	func   = INT2PTR(void(*)(short, void *, void *, short), SvIV(c_func) );
	(*func)(s0, p1, p2, s3);

void
nci_vsppf( c_func, s0, p1, p2, f3 )
	SV* c_func
	short s0
	void * p1
	void * p2
	float f3
PREINIT:
	void(*func)(short, void *, void *, float);
CODE:
	func   = INT2PTR(void(*)(short, void *, void *, float), SvIV(c_func) );
	(*func)(s0, p1, p2, f3);

void
nci_vsppt( c_func, s0, p1, p2, t3 )
	SV* c_func
	short s0
	void * p1
	void * p2
	char * t3
PREINIT:
	void(*func)(short, void *, void *, char *);
CODE:
	func   = INT2PTR(void(*)(short, void *, void *, char *), SvIV(c_func) );
	(*func)(s0, p1, p2, t3);

void
nci_vsppi( c_func, s0, p1, p2, i3 )
	SV* c_func
	short s0
	void * p1
	void * p2
	int i3
PREINIT:
	void(*func)(short, void *, void *, int);
CODE:
	func   = INT2PTR(void(*)(short, void *, void *, int), SvIV(c_func) );
	(*func)(s0, p1, p2, i3);

void
nci_vspdp( c_func, s0, p1, d2, p3 )
	SV* c_func
	short s0
	void * p1
	double d2
	void * p3
PREINIT:
	void(*func)(short, void *, double, void *);
CODE:
	func   = INT2PTR(void(*)(short, void *, double, void *), SvIV(c_func) );
	(*func)(s0, p1, d2, p3);

void
nci_vspdd( c_func, s0, p1, d2, d3 )
	SV* c_func
	short s0
	void * p1
	double d2
	double d3
PREINIT:
	void(*func)(short, void *, double, double);
CODE:
	func   = INT2PTR(void(*)(short, void *, double, double), SvIV(c_func) );
	(*func)(s0, p1, d2, d3);

void
nci_vspds( c_func, s0, p1, d2, s3 )
	SV* c_func
	short s0
	void * p1
	double d2
	short s3
PREINIT:
	void(*func)(short, void *, double, short);
CODE:
	func   = INT2PTR(void(*)(short, void *, double, short), SvIV(c_func) );
	(*func)(s0, p1, d2, s3);

void
nci_vspdf( c_func, s0, p1, d2, f3 )
	SV* c_func
	short s0
	void * p1
	double d2
	float f3
PREINIT:
	void(*func)(short, void *, double, float);
CODE:
	func   = INT2PTR(void(*)(short, void *, double, float), SvIV(c_func) );
	(*func)(s0, p1, d2, f3);

void
nci_vspdt( c_func, s0, p1, d2, t3 )
	SV* c_func
	short s0
	void * p1
	double d2
	char * t3
PREINIT:
	void(*func)(short, void *, double, char *);
CODE:
	func   = INT2PTR(void(*)(short, void *, double, char *), SvIV(c_func) );
	(*func)(s0, p1, d2, t3);

void
nci_vspdi( c_func, s0, p1, d2, i3 )
	SV* c_func
	short s0
	void * p1
	double d2
	int i3
PREINIT:
	void(*func)(short, void *, double, int);
CODE:
	func   = INT2PTR(void(*)(short, void *, double, int), SvIV(c_func) );
	(*func)(s0, p1, d2, i3);

void
nci_vspsp( c_func, s0, p1, s2, p3 )
	SV* c_func
	short s0
	void * p1
	short s2
	void * p3
PREINIT:
	void(*func)(short, void *, short, void *);
CODE:
	func   = INT2PTR(void(*)(short, void *, short, void *), SvIV(c_func) );
	(*func)(s0, p1, s2, p3);

void
nci_vspsd( c_func, s0, p1, s2, d3 )
	SV* c_func
	short s0
	void * p1
	short s2
	double d3
PREINIT:
	void(*func)(short, void *, short, double);
CODE:
	func   = INT2PTR(void(*)(short, void *, short, double), SvIV(c_func) );
	(*func)(s0, p1, s2, d3);

void
nci_vspss( c_func, s0, p1, s2, s3 )
	SV* c_func
	short s0
	void * p1
	short s2
	short s3
PREINIT:
	void(*func)(short, void *, short, short);
CODE:
	func   = INT2PTR(void(*)(short, void *, short, short), SvIV(c_func) );
	(*func)(s0, p1, s2, s3);

void
nci_vspsf( c_func, s0, p1, s2, f3 )
	SV* c_func
	short s0
	void * p1
	short s2
	float f3
PREINIT:
	void(*func)(short, void *, short, float);
CODE:
	func   = INT2PTR(void(*)(short, void *, short, float), SvIV(c_func) );
	(*func)(s0, p1, s2, f3);

void
nci_vspst( c_func, s0, p1, s2, t3 )
	SV* c_func
	short s0
	void * p1
	short s2
	char * t3
PREINIT:
	void(*func)(short, void *, short, char *);
CODE:
	func   = INT2PTR(void(*)(short, void *, short, char *), SvIV(c_func) );
	(*func)(s0, p1, s2, t3);

void
nci_vspsi( c_func, s0, p1, s2, i3 )
	SV* c_func
	short s0
	void * p1
	short s2
	int i3
PREINIT:
	void(*func)(short, void *, short, int);
CODE:
	func   = INT2PTR(void(*)(short, void *, short, int), SvIV(c_func) );
	(*func)(s0, p1, s2, i3);

void
nci_vspfp( c_func, s0, p1, f2, p3 )
	SV* c_func
	short s0
	void * p1
	float f2
	void * p3
PREINIT:
	void(*func)(short, void *, float, void *);
CODE:
	func   = INT2PTR(void(*)(short, void *, float, void *), SvIV(c_func) );
	(*func)(s0, p1, f2, p3);

void
nci_vspfd( c_func, s0, p1, f2, d3 )
	SV* c_func
	short s0
	void * p1
	float f2
	double d3
PREINIT:
	void(*func)(short, void *, float, double);
CODE:
	func   = INT2PTR(void(*)(short, void *, float, double), SvIV(c_func) );
	(*func)(s0, p1, f2, d3);

void
nci_vspfs( c_func, s0, p1, f2, s3 )
	SV* c_func
	short s0
	void * p1
	float f2
	short s3
PREINIT:
	void(*func)(short, void *, float, short);
CODE:
	func   = INT2PTR(void(*)(short, void *, float, short), SvIV(c_func) );
	(*func)(s0, p1, f2, s3);

void
nci_vspff( c_func, s0, p1, f2, f3 )
	SV* c_func
	short s0
	void * p1
	float f2
	float f3
PREINIT:
	void(*func)(short, void *, float, float);
CODE:
	func   = INT2PTR(void(*)(short, void *, float, float), SvIV(c_func) );
	(*func)(s0, p1, f2, f3);

void
nci_vspft( c_func, s0, p1, f2, t3 )
	SV* c_func
	short s0
	void * p1
	float f2
	char * t3
PREINIT:
	void(*func)(short, void *, float, char *);
CODE:
	func   = INT2PTR(void(*)(short, void *, float, char *), SvIV(c_func) );
	(*func)(s0, p1, f2, t3);

void
nci_vspfi( c_func, s0, p1, f2, i3 )
	SV* c_func
	short s0
	void * p1
	float f2
	int i3
PREINIT:
	void(*func)(short, void *, float, int);
CODE:
	func   = INT2PTR(void(*)(short, void *, float, int), SvIV(c_func) );
	(*func)(s0, p1, f2, i3);

void
nci_vsptp( c_func, s0, p1, t2, p3 )
	SV* c_func
	short s0
	void * p1
	char * t2
	void * p3
PREINIT:
	void(*func)(short, void *, char *, void *);
CODE:
	func   = INT2PTR(void(*)(short, void *, char *, void *), SvIV(c_func) );
	(*func)(s0, p1, t2, p3);

void
nci_vsptd( c_func, s0, p1, t2, d3 )
	SV* c_func
	short s0
	void * p1
	char * t2
	double d3
PREINIT:
	void(*func)(short, void *, char *, double);
CODE:
	func   = INT2PTR(void(*)(short, void *, char *, double), SvIV(c_func) );
	(*func)(s0, p1, t2, d3);

void
nci_vspts( c_func, s0, p1, t2, s3 )
	SV* c_func
	short s0
	void * p1
	char * t2
	short s3
PREINIT:
	void(*func)(short, void *, char *, short);
CODE:
	func   = INT2PTR(void(*)(short, void *, char *, short), SvIV(c_func) );
	(*func)(s0, p1, t2, s3);

void
nci_vsptf( c_func, s0, p1, t2, f3 )
	SV* c_func
	short s0
	void * p1
	char * t2
	float f3
PREINIT:
	void(*func)(short, void *, char *, float);
CODE:
	func   = INT2PTR(void(*)(short, void *, char *, float), SvIV(c_func) );
	(*func)(s0, p1, t2, f3);

void
nci_vsptt( c_func, s0, p1, t2, t3 )
	SV* c_func
	short s0
	void * p1
	char * t2
	char * t3
PREINIT:
	void(*func)(short, void *, char *, char *);
CODE:
	func   = INT2PTR(void(*)(short, void *, char *, char *), SvIV(c_func) );
	(*func)(s0, p1, t2, t3);

void
nci_vspti( c_func, s0, p1, t2, i3 )
	SV* c_func
	short s0
	void * p1
	char * t2
	int i3
PREINIT:
	void(*func)(short, void *, char *, int);
CODE:
	func   = INT2PTR(void(*)(short, void *, char *, int), SvIV(c_func) );
	(*func)(s0, p1, t2, i3);

void
nci_vspip( c_func, s0, p1, i2, p3 )
	SV* c_func
	short s0
	void * p1
	int i2
	void * p3
PREINIT:
	void(*func)(short, void *, int, void *);
CODE:
	func   = INT2PTR(void(*)(short, void *, int, void *), SvIV(c_func) );
	(*func)(s0, p1, i2, p3);

void
nci_vspid( c_func, s0, p1, i2, d3 )
	SV* c_func
	short s0
	void * p1
	int i2
	double d3
PREINIT:
	void(*func)(short, void *, int, double);
CODE:
	func   = INT2PTR(void(*)(short, void *, int, double), SvIV(c_func) );
	(*func)(s0, p1, i2, d3);

void
nci_vspis( c_func, s0, p1, i2, s3 )
	SV* c_func
	short s0
	void * p1
	int i2
	short s3
PREINIT:
	void(*func)(short, void *, int, short);
CODE:
	func   = INT2PTR(void(*)(short, void *, int, short), SvIV(c_func) );
	(*func)(s0, p1, i2, s3);

void
nci_vspif( c_func, s0, p1, i2, f3 )
	SV* c_func
	short s0
	void * p1
	int i2
	float f3
PREINIT:
	void(*func)(short, void *, int, float);
CODE:
	func   = INT2PTR(void(*)(short, void *, int, float), SvIV(c_func) );
	(*func)(s0, p1, i2, f3);

void
nci_vspit( c_func, s0, p1, i2, t3 )
	SV* c_func
	short s0
	void * p1
	int i2
	char * t3
PREINIT:
	void(*func)(short, void *, int, char *);
CODE:
	func   = INT2PTR(void(*)(short, void *, int, char *), SvIV(c_func) );
	(*func)(s0, p1, i2, t3);

void
nci_vspii( c_func, s0, p1, i2, i3 )
	SV* c_func
	short s0
	void * p1
	int i2
	int i3
PREINIT:
	void(*func)(short, void *, int, int);
CODE:
	func   = INT2PTR(void(*)(short, void *, int, int), SvIV(c_func) );
	(*func)(s0, p1, i2, i3);

void
nci_vsdpp( c_func, s0, d1, p2, p3 )
	SV* c_func
	short s0
	double d1
	void * p2
	void * p3
PREINIT:
	void(*func)(short, double, void *, void *);
CODE:
	func   = INT2PTR(void(*)(short, double, void *, void *), SvIV(c_func) );
	(*func)(s0, d1, p2, p3);

void
nci_vsdpd( c_func, s0, d1, p2, d3 )
	SV* c_func
	short s0
	double d1
	void * p2
	double d3
PREINIT:
	void(*func)(short, double, void *, double);
CODE:
	func   = INT2PTR(void(*)(short, double, void *, double), SvIV(c_func) );
	(*func)(s0, d1, p2, d3);

void
nci_vsdps( c_func, s0, d1, p2, s3 )
	SV* c_func
	short s0
	double d1
	void * p2
	short s3
PREINIT:
	void(*func)(short, double, void *, short);
CODE:
	func   = INT2PTR(void(*)(short, double, void *, short), SvIV(c_func) );
	(*func)(s0, d1, p2, s3);

void
nci_vsdpf( c_func, s0, d1, p2, f3 )
	SV* c_func
	short s0
	double d1
	void * p2
	float f3
PREINIT:
	void(*func)(short, double, void *, float);
CODE:
	func   = INT2PTR(void(*)(short, double, void *, float), SvIV(c_func) );
	(*func)(s0, d1, p2, f3);

void
nci_vsdpt( c_func, s0, d1, p2, t3 )
	SV* c_func
	short s0
	double d1
	void * p2
	char * t3
PREINIT:
	void(*func)(short, double, void *, char *);
CODE:
	func   = INT2PTR(void(*)(short, double, void *, char *), SvIV(c_func) );
	(*func)(s0, d1, p2, t3);

void
nci_vsdpi( c_func, s0, d1, p2, i3 )
	SV* c_func
	short s0
	double d1
	void * p2
	int i3
PREINIT:
	void(*func)(short, double, void *, int);
CODE:
	func   = INT2PTR(void(*)(short, double, void *, int), SvIV(c_func) );
	(*func)(s0, d1, p2, i3);

void
nci_vsddp( c_func, s0, d1, d2, p3 )
	SV* c_func
	short s0
	double d1
	double d2
	void * p3
PREINIT:
	void(*func)(short, double, double, void *);
CODE:
	func   = INT2PTR(void(*)(short, double, double, void *), SvIV(c_func) );
	(*func)(s0, d1, d2, p3);

void
nci_vsddd( c_func, s0, d1, d2, d3 )
	SV* c_func
	short s0
	double d1
	double d2
	double d3
PREINIT:
	void(*func)(short, double, double, double);
CODE:
	func   = INT2PTR(void(*)(short, double, double, double), SvIV(c_func) );
	(*func)(s0, d1, d2, d3);

void
nci_vsdds( c_func, s0, d1, d2, s3 )
	SV* c_func
	short s0
	double d1
	double d2
	short s3
PREINIT:
	void(*func)(short, double, double, short);
CODE:
	func   = INT2PTR(void(*)(short, double, double, short), SvIV(c_func) );
	(*func)(s0, d1, d2, s3);

void
nci_vsddf( c_func, s0, d1, d2, f3 )
	SV* c_func
	short s0
	double d1
	double d2
	float f3
PREINIT:
	void(*func)(short, double, double, float);
CODE:
	func   = INT2PTR(void(*)(short, double, double, float), SvIV(c_func) );
	(*func)(s0, d1, d2, f3);

void
nci_vsddt( c_func, s0, d1, d2, t3 )
	SV* c_func
	short s0
	double d1
	double d2
	char * t3
PREINIT:
	void(*func)(short, double, double, char *);
CODE:
	func   = INT2PTR(void(*)(short, double, double, char *), SvIV(c_func) );
	(*func)(s0, d1, d2, t3);

void
nci_vsddi( c_func, s0, d1, d2, i3 )
	SV* c_func
	short s0
	double d1
	double d2
	int i3
PREINIT:
	void(*func)(short, double, double, int);
CODE:
	func   = INT2PTR(void(*)(short, double, double, int), SvIV(c_func) );
	(*func)(s0, d1, d2, i3);

void
nci_vsdsp( c_func, s0, d1, s2, p3 )
	SV* c_func
	short s0
	double d1
	short s2
	void * p3
PREINIT:
	void(*func)(short, double, short, void *);
CODE:
	func   = INT2PTR(void(*)(short, double, short, void *), SvIV(c_func) );
	(*func)(s0, d1, s2, p3);

void
nci_vsdsd( c_func, s0, d1, s2, d3 )
	SV* c_func
	short s0
	double d1
	short s2
	double d3
PREINIT:
	void(*func)(short, double, short, double);
CODE:
	func   = INT2PTR(void(*)(short, double, short, double), SvIV(c_func) );
	(*func)(s0, d1, s2, d3);

void
nci_vsdss( c_func, s0, d1, s2, s3 )
	SV* c_func
	short s0
	double d1
	short s2
	short s3
PREINIT:
	void(*func)(short, double, short, short);
CODE:
	func   = INT2PTR(void(*)(short, double, short, short), SvIV(c_func) );
	(*func)(s0, d1, s2, s3);

void
nci_vsdsf( c_func, s0, d1, s2, f3 )
	SV* c_func
	short s0
	double d1
	short s2
	float f3
PREINIT:
	void(*func)(short, double, short, float);
CODE:
	func   = INT2PTR(void(*)(short, double, short, float), SvIV(c_func) );
	(*func)(s0, d1, s2, f3);

void
nci_vsdst( c_func, s0, d1, s2, t3 )
	SV* c_func
	short s0
	double d1
	short s2
	char * t3
PREINIT:
	void(*func)(short, double, short, char *);
CODE:
	func   = INT2PTR(void(*)(short, double, short, char *), SvIV(c_func) );
	(*func)(s0, d1, s2, t3);

void
nci_vsdsi( c_func, s0, d1, s2, i3 )
	SV* c_func
	short s0
	double d1
	short s2
	int i3
PREINIT:
	void(*func)(short, double, short, int);
CODE:
	func   = INT2PTR(void(*)(short, double, short, int), SvIV(c_func) );
	(*func)(s0, d1, s2, i3);

void
nci_vsdfp( c_func, s0, d1, f2, p3 )
	SV* c_func
	short s0
	double d1
	float f2
	void * p3
PREINIT:
	void(*func)(short, double, float, void *);
CODE:
	func   = INT2PTR(void(*)(short, double, float, void *), SvIV(c_func) );
	(*func)(s0, d1, f2, p3);

void
nci_vsdfd( c_func, s0, d1, f2, d3 )
	SV* c_func
	short s0
	double d1
	float f2
	double d3
PREINIT:
	void(*func)(short, double, float, double);
CODE:
	func   = INT2PTR(void(*)(short, double, float, double), SvIV(c_func) );
	(*func)(s0, d1, f2, d3);

void
nci_vsdfs( c_func, s0, d1, f2, s3 )
	SV* c_func
	short s0
	double d1
	float f2
	short s3
PREINIT:
	void(*func)(short, double, float, short);
CODE:
	func   = INT2PTR(void(*)(short, double, float, short), SvIV(c_func) );
	(*func)(s0, d1, f2, s3);

void
nci_vsdff( c_func, s0, d1, f2, f3 )
	SV* c_func
	short s0
	double d1
	float f2
	float f3
PREINIT:
	void(*func)(short, double, float, float);
CODE:
	func   = INT2PTR(void(*)(short, double, float, float), SvIV(c_func) );
	(*func)(s0, d1, f2, f3);

void
nci_vsdft( c_func, s0, d1, f2, t3 )
	SV* c_func
	short s0
	double d1
	float f2
	char * t3
PREINIT:
	void(*func)(short, double, float, char *);
CODE:
	func   = INT2PTR(void(*)(short, double, float, char *), SvIV(c_func) );
	(*func)(s0, d1, f2, t3);

void
nci_vsdfi( c_func, s0, d1, f2, i3 )
	SV* c_func
	short s0
	double d1
	float f2
	int i3
PREINIT:
	void(*func)(short, double, float, int);
CODE:
	func   = INT2PTR(void(*)(short, double, float, int), SvIV(c_func) );
	(*func)(s0, d1, f2, i3);

void
nci_vsdtp( c_func, s0, d1, t2, p3 )
	SV* c_func
	short s0
	double d1
	char * t2
	void * p3
PREINIT:
	void(*func)(short, double, char *, void *);
CODE:
	func   = INT2PTR(void(*)(short, double, char *, void *), SvIV(c_func) );
	(*func)(s0, d1, t2, p3);

void
nci_vsdtd( c_func, s0, d1, t2, d3 )
	SV* c_func
	short s0
	double d1
	char * t2
	double d3
PREINIT:
	void(*func)(short, double, char *, double);
CODE:
	func   = INT2PTR(void(*)(short, double, char *, double), SvIV(c_func) );
	(*func)(s0, d1, t2, d3);

void
nci_vsdts( c_func, s0, d1, t2, s3 )
	SV* c_func
	short s0
	double d1
	char * t2
	short s3
PREINIT:
	void(*func)(short, double, char *, short);
CODE:
	func   = INT2PTR(void(*)(short, double, char *, short), SvIV(c_func) );
	(*func)(s0, d1, t2, s3);

void
nci_vsdtf( c_func, s0, d1, t2, f3 )
	SV* c_func
	short s0
	double d1
	char * t2
	float f3
PREINIT:
	void(*func)(short, double, char *, float);
CODE:
	func   = INT2PTR(void(*)(short, double, char *, float), SvIV(c_func) );
	(*func)(s0, d1, t2, f3);

void
nci_vsdtt( c_func, s0, d1, t2, t3 )
	SV* c_func
	short s0
	double d1
	char * t2
	char * t3
PREINIT:
	void(*func)(short, double, char *, char *);
CODE:
	func   = INT2PTR(void(*)(short, double, char *, char *), SvIV(c_func) );
	(*func)(s0, d1, t2, t3);

void
nci_vsdti( c_func, s0, d1, t2, i3 )
	SV* c_func
	short s0
	double d1
	char * t2
	int i3
PREINIT:
	void(*func)(short, double, char *, int);
CODE:
	func   = INT2PTR(void(*)(short, double, char *, int), SvIV(c_func) );
	(*func)(s0, d1, t2, i3);

void
nci_vsdip( c_func, s0, d1, i2, p3 )
	SV* c_func
	short s0
	double d1
	int i2
	void * p3
PREINIT:
	void(*func)(short, double, int, void *);
CODE:
	func   = INT2PTR(void(*)(short, double, int, void *), SvIV(c_func) );
	(*func)(s0, d1, i2, p3);

void
nci_vsdid( c_func, s0, d1, i2, d3 )
	SV* c_func
	short s0
	double d1
	int i2
	double d3
PREINIT:
	void(*func)(short, double, int, double);
CODE:
	func   = INT2PTR(void(*)(short, double, int, double), SvIV(c_func) );
	(*func)(s0, d1, i2, d3);

void
nci_vsdis( c_func, s0, d1, i2, s3 )
	SV* c_func
	short s0
	double d1
	int i2
	short s3
PREINIT:
	void(*func)(short, double, int, short);
CODE:
	func   = INT2PTR(void(*)(short, double, int, short), SvIV(c_func) );
	(*func)(s0, d1, i2, s3);

void
nci_vsdif( c_func, s0, d1, i2, f3 )
	SV* c_func
	short s0
	double d1
	int i2
	float f3
PREINIT:
	void(*func)(short, double, int, float);
CODE:
	func   = INT2PTR(void(*)(short, double, int, float), SvIV(c_func) );
	(*func)(s0, d1, i2, f3);

void
nci_vsdit( c_func, s0, d1, i2, t3 )
	SV* c_func
	short s0
	double d1
	int i2
	char * t3
PREINIT:
	void(*func)(short, double, int, char *);
CODE:
	func   = INT2PTR(void(*)(short, double, int, char *), SvIV(c_func) );
	(*func)(s0, d1, i2, t3);

void
nci_vsdii( c_func, s0, d1, i2, i3 )
	SV* c_func
	short s0
	double d1
	int i2
	int i3
PREINIT:
	void(*func)(short, double, int, int);
CODE:
	func   = INT2PTR(void(*)(short, double, int, int), SvIV(c_func) );
	(*func)(s0, d1, i2, i3);

void
nci_vsspp( c_func, s0, s1, p2, p3 )
	SV* c_func
	short s0
	short s1
	void * p2
	void * p3
PREINIT:
	void(*func)(short, short, void *, void *);
CODE:
	func   = INT2PTR(void(*)(short, short, void *, void *), SvIV(c_func) );
	(*func)(s0, s1, p2, p3);

void
nci_vsspd( c_func, s0, s1, p2, d3 )
	SV* c_func
	short s0
	short s1
	void * p2
	double d3
PREINIT:
	void(*func)(short, short, void *, double);
CODE:
	func   = INT2PTR(void(*)(short, short, void *, double), SvIV(c_func) );
	(*func)(s0, s1, p2, d3);

void
nci_vssps( c_func, s0, s1, p2, s3 )
	SV* c_func
	short s0
	short s1
	void * p2
	short s3
PREINIT:
	void(*func)(short, short, void *, short);
CODE:
	func   = INT2PTR(void(*)(short, short, void *, short), SvIV(c_func) );
	(*func)(s0, s1, p2, s3);

void
nci_vsspf( c_func, s0, s1, p2, f3 )
	SV* c_func
	short s0
	short s1
	void * p2
	float f3
PREINIT:
	void(*func)(short, short, void *, float);
CODE:
	func   = INT2PTR(void(*)(short, short, void *, float), SvIV(c_func) );
	(*func)(s0, s1, p2, f3);

void
nci_vsspt( c_func, s0, s1, p2, t3 )
	SV* c_func
	short s0
	short s1
	void * p2
	char * t3
PREINIT:
	void(*func)(short, short, void *, char *);
CODE:
	func   = INT2PTR(void(*)(short, short, void *, char *), SvIV(c_func) );
	(*func)(s0, s1, p2, t3);

void
nci_vsspi( c_func, s0, s1, p2, i3 )
	SV* c_func
	short s0
	short s1
	void * p2
	int i3
PREINIT:
	void(*func)(short, short, void *, int);
CODE:
	func   = INT2PTR(void(*)(short, short, void *, int), SvIV(c_func) );
	(*func)(s0, s1, p2, i3);

void
nci_vssdp( c_func, s0, s1, d2, p3 )
	SV* c_func
	short s0
	short s1
	double d2
	void * p3
PREINIT:
	void(*func)(short, short, double, void *);
CODE:
	func   = INT2PTR(void(*)(short, short, double, void *), SvIV(c_func) );
	(*func)(s0, s1, d2, p3);

void
nci_vssdd( c_func, s0, s1, d2, d3 )
	SV* c_func
	short s0
	short s1
	double d2
	double d3
PREINIT:
	void(*func)(short, short, double, double);
CODE:
	func   = INT2PTR(void(*)(short, short, double, double), SvIV(c_func) );
	(*func)(s0, s1, d2, d3);

void
nci_vssds( c_func, s0, s1, d2, s3 )
	SV* c_func
	short s0
	short s1
	double d2
	short s3
PREINIT:
	void(*func)(short, short, double, short);
CODE:
	func   = INT2PTR(void(*)(short, short, double, short), SvIV(c_func) );
	(*func)(s0, s1, d2, s3);

void
nci_vssdf( c_func, s0, s1, d2, f3 )
	SV* c_func
	short s0
	short s1
	double d2
	float f3
PREINIT:
	void(*func)(short, short, double, float);
CODE:
	func   = INT2PTR(void(*)(short, short, double, float), SvIV(c_func) );
	(*func)(s0, s1, d2, f3);

void
nci_vssdt( c_func, s0, s1, d2, t3 )
	SV* c_func
	short s0
	short s1
	double d2
	char * t3
PREINIT:
	void(*func)(short, short, double, char *);
CODE:
	func   = INT2PTR(void(*)(short, short, double, char *), SvIV(c_func) );
	(*func)(s0, s1, d2, t3);

void
nci_vssdi( c_func, s0, s1, d2, i3 )
	SV* c_func
	short s0
	short s1
	double d2
	int i3
PREINIT:
	void(*func)(short, short, double, int);
CODE:
	func   = INT2PTR(void(*)(short, short, double, int), SvIV(c_func) );
	(*func)(s0, s1, d2, i3);

void
nci_vsssp( c_func, s0, s1, s2, p3 )
	SV* c_func
	short s0
	short s1
	short s2
	void * p3
PREINIT:
	void(*func)(short, short, short, void *);
CODE:
	func   = INT2PTR(void(*)(short, short, short, void *), SvIV(c_func) );
	(*func)(s0, s1, s2, p3);

void
nci_vsssd( c_func, s0, s1, s2, d3 )
	SV* c_func
	short s0
	short s1
	short s2
	double d3
PREINIT:
	void(*func)(short, short, short, double);
CODE:
	func   = INT2PTR(void(*)(short, short, short, double), SvIV(c_func) );
	(*func)(s0, s1, s2, d3);

void
nci_vssss( c_func, s0, s1, s2, s3 )
	SV* c_func
	short s0
	short s1
	short s2
	short s3
PREINIT:
	void(*func)(short, short, short, short);
CODE:
	func   = INT2PTR(void(*)(short, short, short, short), SvIV(c_func) );
	(*func)(s0, s1, s2, s3);

void
nci_vsssf( c_func, s0, s1, s2, f3 )
	SV* c_func
	short s0
	short s1
	short s2
	float f3
PREINIT:
	void(*func)(short, short, short, float);
CODE:
	func   = INT2PTR(void(*)(short, short, short, float), SvIV(c_func) );
	(*func)(s0, s1, s2, f3);

void
nci_vssst( c_func, s0, s1, s2, t3 )
	SV* c_func
	short s0
	short s1
	short s2
	char * t3
PREINIT:
	void(*func)(short, short, short, char *);
CODE:
	func   = INT2PTR(void(*)(short, short, short, char *), SvIV(c_func) );
	(*func)(s0, s1, s2, t3);

void
nci_vsssi( c_func, s0, s1, s2, i3 )
	SV* c_func
	short s0
	short s1
	short s2
	int i3
PREINIT:
	void(*func)(short, short, short, int);
CODE:
	func   = INT2PTR(void(*)(short, short, short, int), SvIV(c_func) );
	(*func)(s0, s1, s2, i3);

void
nci_vssfp( c_func, s0, s1, f2, p3 )
	SV* c_func
	short s0
	short s1
	float f2
	void * p3
PREINIT:
	void(*func)(short, short, float, void *);
CODE:
	func   = INT2PTR(void(*)(short, short, float, void *), SvIV(c_func) );
	(*func)(s0, s1, f2, p3);

void
nci_vssfd( c_func, s0, s1, f2, d3 )
	SV* c_func
	short s0
	short s1
	float f2
	double d3
PREINIT:
	void(*func)(short, short, float, double);
CODE:
	func   = INT2PTR(void(*)(short, short, float, double), SvIV(c_func) );
	(*func)(s0, s1, f2, d3);

void
nci_vssfs( c_func, s0, s1, f2, s3 )
	SV* c_func
	short s0
	short s1
	float f2
	short s3
PREINIT:
	void(*func)(short, short, float, short);
CODE:
	func   = INT2PTR(void(*)(short, short, float, short), SvIV(c_func) );
	(*func)(s0, s1, f2, s3);

void
nci_vssff( c_func, s0, s1, f2, f3 )
	SV* c_func
	short s0
	short s1
	float f2
	float f3
PREINIT:
	void(*func)(short, short, float, float);
CODE:
	func   = INT2PTR(void(*)(short, short, float, float), SvIV(c_func) );
	(*func)(s0, s1, f2, f3);

void
nci_vssft( c_func, s0, s1, f2, t3 )
	SV* c_func
	short s0
	short s1
	float f2
	char * t3
PREINIT:
	void(*func)(short, short, float, char *);
CODE:
	func   = INT2PTR(void(*)(short, short, float, char *), SvIV(c_func) );
	(*func)(s0, s1, f2, t3);

void
nci_vssfi( c_func, s0, s1, f2, i3 )
	SV* c_func
	short s0
	short s1
	float f2
	int i3
PREINIT:
	void(*func)(short, short, float, int);
CODE:
	func   = INT2PTR(void(*)(short, short, float, int), SvIV(c_func) );
	(*func)(s0, s1, f2, i3);

void
nci_vsstp( c_func, s0, s1, t2, p3 )
	SV* c_func
	short s0
	short s1
	char * t2
	void * p3
PREINIT:
	void(*func)(short, short, char *, void *);
CODE:
	func   = INT2PTR(void(*)(short, short, char *, void *), SvIV(c_func) );
	(*func)(s0, s1, t2, p3);

void
nci_vsstd( c_func, s0, s1, t2, d3 )
	SV* c_func
	short s0
	short s1
	char * t2
	double d3
PREINIT:
	void(*func)(short, short, char *, double);
CODE:
	func   = INT2PTR(void(*)(short, short, char *, double), SvIV(c_func) );
	(*func)(s0, s1, t2, d3);

void
nci_vssts( c_func, s0, s1, t2, s3 )
	SV* c_func
	short s0
	short s1
	char * t2
	short s3
PREINIT:
	void(*func)(short, short, char *, short);
CODE:
	func   = INT2PTR(void(*)(short, short, char *, short), SvIV(c_func) );
	(*func)(s0, s1, t2, s3);

void
nci_vsstf( c_func, s0, s1, t2, f3 )
	SV* c_func
	short s0
	short s1
	char * t2
	float f3
PREINIT:
	void(*func)(short, short, char *, float);
CODE:
	func   = INT2PTR(void(*)(short, short, char *, float), SvIV(c_func) );
	(*func)(s0, s1, t2, f3);

void
nci_vsstt( c_func, s0, s1, t2, t3 )
	SV* c_func
	short s0
	short s1
	char * t2
	char * t3
PREINIT:
	void(*func)(short, short, char *, char *);
CODE:
	func   = INT2PTR(void(*)(short, short, char *, char *), SvIV(c_func) );
	(*func)(s0, s1, t2, t3);

void
nci_vssti( c_func, s0, s1, t2, i3 )
	SV* c_func
	short s0
	short s1
	char * t2
	int i3
PREINIT:
	void(*func)(short, short, char *, int);
CODE:
	func   = INT2PTR(void(*)(short, short, char *, int), SvIV(c_func) );
	(*func)(s0, s1, t2, i3);

void
nci_vssip( c_func, s0, s1, i2, p3 )
	SV* c_func
	short s0
	short s1
	int i2
	void * p3
PREINIT:
	void(*func)(short, short, int, void *);
CODE:
	func   = INT2PTR(void(*)(short, short, int, void *), SvIV(c_func) );
	(*func)(s0, s1, i2, p3);

void
nci_vssid( c_func, s0, s1, i2, d3 )
	SV* c_func
	short s0
	short s1
	int i2
	double d3
PREINIT:
	void(*func)(short, short, int, double);
CODE:
	func   = INT2PTR(void(*)(short, short, int, double), SvIV(c_func) );
	(*func)(s0, s1, i2, d3);

void
nci_vssis( c_func, s0, s1, i2, s3 )
	SV* c_func
	short s0
	short s1
	int i2
	short s3
PREINIT:
	void(*func)(short, short, int, short);
CODE:
	func   = INT2PTR(void(*)(short, short, int, short), SvIV(c_func) );
	(*func)(s0, s1, i2, s3);

void
nci_vssif( c_func, s0, s1, i2, f3 )
	SV* c_func
	short s0
	short s1
	int i2
	float f3
PREINIT:
	void(*func)(short, short, int, float);
CODE:
	func   = INT2PTR(void(*)(short, short, int, float), SvIV(c_func) );
	(*func)(s0, s1, i2, f3);

void
nci_vssit( c_func, s0, s1, i2, t3 )
	SV* c_func
	short s0
	short s1
	int i2
	char * t3
PREINIT:
	void(*func)(short, short, int, char *);
CODE:
	func   = INT2PTR(void(*)(short, short, int, char *), SvIV(c_func) );
	(*func)(s0, s1, i2, t3);

void
nci_vssii( c_func, s0, s1, i2, i3 )
	SV* c_func
	short s0
	short s1
	int i2
	int i3
PREINIT:
	void(*func)(short, short, int, int);
CODE:
	func   = INT2PTR(void(*)(short, short, int, int), SvIV(c_func) );
	(*func)(s0, s1, i2, i3);

void
nci_vsfpp( c_func, s0, f1, p2, p3 )
	SV* c_func
	short s0
	float f1
	void * p2
	void * p3
PREINIT:
	void(*func)(short, float, void *, void *);
CODE:
	func   = INT2PTR(void(*)(short, float, void *, void *), SvIV(c_func) );
	(*func)(s0, f1, p2, p3);

void
nci_vsfpd( c_func, s0, f1, p2, d3 )
	SV* c_func
	short s0
	float f1
	void * p2
	double d3
PREINIT:
	void(*func)(short, float, void *, double);
CODE:
	func   = INT2PTR(void(*)(short, float, void *, double), SvIV(c_func) );
	(*func)(s0, f1, p2, d3);

void
nci_vsfps( c_func, s0, f1, p2, s3 )
	SV* c_func
	short s0
	float f1
	void * p2
	short s3
PREINIT:
	void(*func)(short, float, void *, short);
CODE:
	func   = INT2PTR(void(*)(short, float, void *, short), SvIV(c_func) );
	(*func)(s0, f1, p2, s3);

void
nci_vsfpf( c_func, s0, f1, p2, f3 )
	SV* c_func
	short s0
	float f1
	void * p2
	float f3
PREINIT:
	void(*func)(short, float, void *, float);
CODE:
	func   = INT2PTR(void(*)(short, float, void *, float), SvIV(c_func) );
	(*func)(s0, f1, p2, f3);

void
nci_vsfpt( c_func, s0, f1, p2, t3 )
	SV* c_func
	short s0
	float f1
	void * p2
	char * t3
PREINIT:
	void(*func)(short, float, void *, char *);
CODE:
	func   = INT2PTR(void(*)(short, float, void *, char *), SvIV(c_func) );
	(*func)(s0, f1, p2, t3);

void
nci_vsfpi( c_func, s0, f1, p2, i3 )
	SV* c_func
	short s0
	float f1
	void * p2
	int i3
PREINIT:
	void(*func)(short, float, void *, int);
CODE:
	func   = INT2PTR(void(*)(short, float, void *, int), SvIV(c_func) );
	(*func)(s0, f1, p2, i3);

void
nci_vsfdp( c_func, s0, f1, d2, p3 )
	SV* c_func
	short s0
	float f1
	double d2
	void * p3
PREINIT:
	void(*func)(short, float, double, void *);
CODE:
	func   = INT2PTR(void(*)(short, float, double, void *), SvIV(c_func) );
	(*func)(s0, f1, d2, p3);

void
nci_vsfdd( c_func, s0, f1, d2, d3 )
	SV* c_func
	short s0
	float f1
	double d2
	double d3
PREINIT:
	void(*func)(short, float, double, double);
CODE:
	func   = INT2PTR(void(*)(short, float, double, double), SvIV(c_func) );
	(*func)(s0, f1, d2, d3);

void
nci_vsfds( c_func, s0, f1, d2, s3 )
	SV* c_func
	short s0
	float f1
	double d2
	short s3
PREINIT:
	void(*func)(short, float, double, short);
CODE:
	func   = INT2PTR(void(*)(short, float, double, short), SvIV(c_func) );
	(*func)(s0, f1, d2, s3);

void
nci_vsfdf( c_func, s0, f1, d2, f3 )
	SV* c_func
	short s0
	float f1
	double d2
	float f3
PREINIT:
	void(*func)(short, float, double, float);
CODE:
	func   = INT2PTR(void(*)(short, float, double, float), SvIV(c_func) );
	(*func)(s0, f1, d2, f3);

void
nci_vsfdt( c_func, s0, f1, d2, t3 )
	SV* c_func
	short s0
	float f1
	double d2
	char * t3
PREINIT:
	void(*func)(short, float, double, char *);
CODE:
	func   = INT2PTR(void(*)(short, float, double, char *), SvIV(c_func) );
	(*func)(s0, f1, d2, t3);

void
nci_vsfdi( c_func, s0, f1, d2, i3 )
	SV* c_func
	short s0
	float f1
	double d2
	int i3
PREINIT:
	void(*func)(short, float, double, int);
CODE:
	func   = INT2PTR(void(*)(short, float, double, int), SvIV(c_func) );
	(*func)(s0, f1, d2, i3);

void
nci_vsfsp( c_func, s0, f1, s2, p3 )
	SV* c_func
	short s0
	float f1
	short s2
	void * p3
PREINIT:
	void(*func)(short, float, short, void *);
CODE:
	func   = INT2PTR(void(*)(short, float, short, void *), SvIV(c_func) );
	(*func)(s0, f1, s2, p3);

void
nci_vsfsd( c_func, s0, f1, s2, d3 )
	SV* c_func
	short s0
	float f1
	short s2
	double d3
PREINIT:
	void(*func)(short, float, short, double);
CODE:
	func   = INT2PTR(void(*)(short, float, short, double), SvIV(c_func) );
	(*func)(s0, f1, s2, d3);

void
nci_vsfss( c_func, s0, f1, s2, s3 )
	SV* c_func
	short s0
	float f1
	short s2
	short s3
PREINIT:
	void(*func)(short, float, short, short);
CODE:
	func   = INT2PTR(void(*)(short, float, short, short), SvIV(c_func) );
	(*func)(s0, f1, s2, s3);

void
nci_vsfsf( c_func, s0, f1, s2, f3 )
	SV* c_func
	short s0
	float f1
	short s2
	float f3
PREINIT:
	void(*func)(short, float, short, float);
CODE:
	func   = INT2PTR(void(*)(short, float, short, float), SvIV(c_func) );
	(*func)(s0, f1, s2, f3);

void
nci_vsfst( c_func, s0, f1, s2, t3 )
	SV* c_func
	short s0
	float f1
	short s2
	char * t3
PREINIT:
	void(*func)(short, float, short, char *);
CODE:
	func   = INT2PTR(void(*)(short, float, short, char *), SvIV(c_func) );
	(*func)(s0, f1, s2, t3);

void
nci_vsfsi( c_func, s0, f1, s2, i3 )
	SV* c_func
	short s0
	float f1
	short s2
	int i3
PREINIT:
	void(*func)(short, float, short, int);
CODE:
	func   = INT2PTR(void(*)(short, float, short, int), SvIV(c_func) );
	(*func)(s0, f1, s2, i3);

void
nci_vsffp( c_func, s0, f1, f2, p3 )
	SV* c_func
	short s0
	float f1
	float f2
	void * p3
PREINIT:
	void(*func)(short, float, float, void *);
CODE:
	func   = INT2PTR(void(*)(short, float, float, void *), SvIV(c_func) );
	(*func)(s0, f1, f2, p3);

void
nci_vsffd( c_func, s0, f1, f2, d3 )
	SV* c_func
	short s0
	float f1
	float f2
	double d3
PREINIT:
	void(*func)(short, float, float, double);
CODE:
	func   = INT2PTR(void(*)(short, float, float, double), SvIV(c_func) );
	(*func)(s0, f1, f2, d3);

void
nci_vsffs( c_func, s0, f1, f2, s3 )
	SV* c_func
	short s0
	float f1
	float f2
	short s3
PREINIT:
	void(*func)(short, float, float, short);
CODE:
	func   = INT2PTR(void(*)(short, float, float, short), SvIV(c_func) );
	(*func)(s0, f1, f2, s3);

void
nci_vsfff( c_func, s0, f1, f2, f3 )
	SV* c_func
	short s0
	float f1
	float f2
	float f3
PREINIT:
	void(*func)(short, float, float, float);
CODE:
	func   = INT2PTR(void(*)(short, float, float, float), SvIV(c_func) );
	(*func)(s0, f1, f2, f3);

void
nci_vsfft( c_func, s0, f1, f2, t3 )
	SV* c_func
	short s0
	float f1
	float f2
	char * t3
PREINIT:
	void(*func)(short, float, float, char *);
CODE:
	func   = INT2PTR(void(*)(short, float, float, char *), SvIV(c_func) );
	(*func)(s0, f1, f2, t3);

void
nci_vsffi( c_func, s0, f1, f2, i3 )
	SV* c_func
	short s0
	float f1
	float f2
	int i3
PREINIT:
	void(*func)(short, float, float, int);
CODE:
	func   = INT2PTR(void(*)(short, float, float, int), SvIV(c_func) );
	(*func)(s0, f1, f2, i3);

void
nci_vsftp( c_func, s0, f1, t2, p3 )
	SV* c_func
	short s0
	float f1
	char * t2
	void * p3
PREINIT:
	void(*func)(short, float, char *, void *);
CODE:
	func   = INT2PTR(void(*)(short, float, char *, void *), SvIV(c_func) );
	(*func)(s0, f1, t2, p3);

void
nci_vsftd( c_func, s0, f1, t2, d3 )
	SV* c_func
	short s0
	float f1
	char * t2
	double d3
PREINIT:
	void(*func)(short, float, char *, double);
CODE:
	func   = INT2PTR(void(*)(short, float, char *, double), SvIV(c_func) );
	(*func)(s0, f1, t2, d3);

void
nci_vsfts( c_func, s0, f1, t2, s3 )
	SV* c_func
	short s0
	float f1
	char * t2
	short s3
PREINIT:
	void(*func)(short, float, char *, short);
CODE:
	func   = INT2PTR(void(*)(short, float, char *, short), SvIV(c_func) );
	(*func)(s0, f1, t2, s3);

void
nci_vsftf( c_func, s0, f1, t2, f3 )
	SV* c_func
	short s0
	float f1
	char * t2
	float f3
PREINIT:
	void(*func)(short, float, char *, float);
CODE:
	func   = INT2PTR(void(*)(short, float, char *, float), SvIV(c_func) );
	(*func)(s0, f1, t2, f3);

void
nci_vsftt( c_func, s0, f1, t2, t3 )
	SV* c_func
	short s0
	float f1
	char * t2
	char * t3
PREINIT:
	void(*func)(short, float, char *, char *);
CODE:
	func   = INT2PTR(void(*)(short, float, char *, char *), SvIV(c_func) );
	(*func)(s0, f1, t2, t3);

void
nci_vsfti( c_func, s0, f1, t2, i3 )
	SV* c_func
	short s0
	float f1
	char * t2
	int i3
PREINIT:
	void(*func)(short, float, char *, int);
CODE:
	func   = INT2PTR(void(*)(short, float, char *, int), SvIV(c_func) );
	(*func)(s0, f1, t2, i3);

void
nci_vsfip( c_func, s0, f1, i2, p3 )
	SV* c_func
	short s0
	float f1
	int i2
	void * p3
PREINIT:
	void(*func)(short, float, int, void *);
CODE:
	func   = INT2PTR(void(*)(short, float, int, void *), SvIV(c_func) );
	(*func)(s0, f1, i2, p3);

void
nci_vsfid( c_func, s0, f1, i2, d3 )
	SV* c_func
	short s0
	float f1
	int i2
	double d3
PREINIT:
	void(*func)(short, float, int, double);
CODE:
	func   = INT2PTR(void(*)(short, float, int, double), SvIV(c_func) );
	(*func)(s0, f1, i2, d3);

void
nci_vsfis( c_func, s0, f1, i2, s3 )
	SV* c_func
	short s0
	float f1
	int i2
	short s3
PREINIT:
	void(*func)(short, float, int, short);
CODE:
	func   = INT2PTR(void(*)(short, float, int, short), SvIV(c_func) );
	(*func)(s0, f1, i2, s3);

void
nci_vsfif( c_func, s0, f1, i2, f3 )
	SV* c_func
	short s0
	float f1
	int i2
	float f3
PREINIT:
	void(*func)(short, float, int, float);
CODE:
	func   = INT2PTR(void(*)(short, float, int, float), SvIV(c_func) );
	(*func)(s0, f1, i2, f3);

void
nci_vsfit( c_func, s0, f1, i2, t3 )
	SV* c_func
	short s0
	float f1
	int i2
	char * t3
PREINIT:
	void(*func)(short, float, int, char *);
CODE:
	func   = INT2PTR(void(*)(short, float, int, char *), SvIV(c_func) );
	(*func)(s0, f1, i2, t3);

void
nci_vsfii( c_func, s0, f1, i2, i3 )
	SV* c_func
	short s0
	float f1
	int i2
	int i3
PREINIT:
	void(*func)(short, float, int, int);
CODE:
	func   = INT2PTR(void(*)(short, float, int, int), SvIV(c_func) );
	(*func)(s0, f1, i2, i3);

void
nci_vstpp( c_func, s0, t1, p2, p3 )
	SV* c_func
	short s0
	char * t1
	void * p2
	void * p3
PREINIT:
	void(*func)(short, char *, void *, void *);
CODE:
	func   = INT2PTR(void(*)(short, char *, void *, void *), SvIV(c_func) );
	(*func)(s0, t1, p2, p3);

void
nci_vstpd( c_func, s0, t1, p2, d3 )
	SV* c_func
	short s0
	char * t1
	void * p2
	double d3
PREINIT:
	void(*func)(short, char *, void *, double);
CODE:
	func   = INT2PTR(void(*)(short, char *, void *, double), SvIV(c_func) );
	(*func)(s0, t1, p2, d3);

void
nci_vstps( c_func, s0, t1, p2, s3 )
	SV* c_func
	short s0
	char * t1
	void * p2
	short s3
PREINIT:
	void(*func)(short, char *, void *, short);
CODE:
	func   = INT2PTR(void(*)(short, char *, void *, short), SvIV(c_func) );
	(*func)(s0, t1, p2, s3);

void
nci_vstpf( c_func, s0, t1, p2, f3 )
	SV* c_func
	short s0
	char * t1
	void * p2
	float f3
PREINIT:
	void(*func)(short, char *, void *, float);
CODE:
	func   = INT2PTR(void(*)(short, char *, void *, float), SvIV(c_func) );
	(*func)(s0, t1, p2, f3);

void
nci_vstpt( c_func, s0, t1, p2, t3 )
	SV* c_func
	short s0
	char * t1
	void * p2
	char * t3
PREINIT:
	void(*func)(short, char *, void *, char *);
CODE:
	func   = INT2PTR(void(*)(short, char *, void *, char *), SvIV(c_func) );
	(*func)(s0, t1, p2, t3);

void
nci_vstpi( c_func, s0, t1, p2, i3 )
	SV* c_func
	short s0
	char * t1
	void * p2
	int i3
PREINIT:
	void(*func)(short, char *, void *, int);
CODE:
	func   = INT2PTR(void(*)(short, char *, void *, int), SvIV(c_func) );
	(*func)(s0, t1, p2, i3);

void
nci_vstdp( c_func, s0, t1, d2, p3 )
	SV* c_func
	short s0
	char * t1
	double d2
	void * p3
PREINIT:
	void(*func)(short, char *, double, void *);
CODE:
	func   = INT2PTR(void(*)(short, char *, double, void *), SvIV(c_func) );
	(*func)(s0, t1, d2, p3);

void
nci_vstdd( c_func, s0, t1, d2, d3 )
	SV* c_func
	short s0
	char * t1
	double d2
	double d3
PREINIT:
	void(*func)(short, char *, double, double);
CODE:
	func   = INT2PTR(void(*)(short, char *, double, double), SvIV(c_func) );
	(*func)(s0, t1, d2, d3);

void
nci_vstds( c_func, s0, t1, d2, s3 )
	SV* c_func
	short s0
	char * t1
	double d2
	short s3
PREINIT:
	void(*func)(short, char *, double, short);
CODE:
	func   = INT2PTR(void(*)(short, char *, double, short), SvIV(c_func) );
	(*func)(s0, t1, d2, s3);

void
nci_vstdf( c_func, s0, t1, d2, f3 )
	SV* c_func
	short s0
	char * t1
	double d2
	float f3
PREINIT:
	void(*func)(short, char *, double, float);
CODE:
	func   = INT2PTR(void(*)(short, char *, double, float), SvIV(c_func) );
	(*func)(s0, t1, d2, f3);

void
nci_vstdt( c_func, s0, t1, d2, t3 )
	SV* c_func
	short s0
	char * t1
	double d2
	char * t3
PREINIT:
	void(*func)(short, char *, double, char *);
CODE:
	func   = INT2PTR(void(*)(short, char *, double, char *), SvIV(c_func) );
	(*func)(s0, t1, d2, t3);

void
nci_vstdi( c_func, s0, t1, d2, i3 )
	SV* c_func
	short s0
	char * t1
	double d2
	int i3
PREINIT:
	void(*func)(short, char *, double, int);
CODE:
	func   = INT2PTR(void(*)(short, char *, double, int), SvIV(c_func) );
	(*func)(s0, t1, d2, i3);

void
nci_vstsp( c_func, s0, t1, s2, p3 )
	SV* c_func
	short s0
	char * t1
	short s2
	void * p3
PREINIT:
	void(*func)(short, char *, short, void *);
CODE:
	func   = INT2PTR(void(*)(short, char *, short, void *), SvIV(c_func) );
	(*func)(s0, t1, s2, p3);

void
nci_vstsd( c_func, s0, t1, s2, d3 )
	SV* c_func
	short s0
	char * t1
	short s2
	double d3
PREINIT:
	void(*func)(short, char *, short, double);
CODE:
	func   = INT2PTR(void(*)(short, char *, short, double), SvIV(c_func) );
	(*func)(s0, t1, s2, d3);

void
nci_vstss( c_func, s0, t1, s2, s3 )
	SV* c_func
	short s0
	char * t1
	short s2
	short s3
PREINIT:
	void(*func)(short, char *, short, short);
CODE:
	func   = INT2PTR(void(*)(short, char *, short, short), SvIV(c_func) );
	(*func)(s0, t1, s2, s3);

void
nci_vstsf( c_func, s0, t1, s2, f3 )
	SV* c_func
	short s0
	char * t1
	short s2
	float f3
PREINIT:
	void(*func)(short, char *, short, float);
CODE:
	func   = INT2PTR(void(*)(short, char *, short, float), SvIV(c_func) );
	(*func)(s0, t1, s2, f3);

void
nci_vstst( c_func, s0, t1, s2, t3 )
	SV* c_func
	short s0
	char * t1
	short s2
	char * t3
PREINIT:
	void(*func)(short, char *, short, char *);
CODE:
	func   = INT2PTR(void(*)(short, char *, short, char *), SvIV(c_func) );
	(*func)(s0, t1, s2, t3);

void
nci_vstsi( c_func, s0, t1, s2, i3 )
	SV* c_func
	short s0
	char * t1
	short s2
	int i3
PREINIT:
	void(*func)(short, char *, short, int);
CODE:
	func   = INT2PTR(void(*)(short, char *, short, int), SvIV(c_func) );
	(*func)(s0, t1, s2, i3);

void
nci_vstfp( c_func, s0, t1, f2, p3 )
	SV* c_func
	short s0
	char * t1
	float f2
	void * p3
PREINIT:
	void(*func)(short, char *, float, void *);
CODE:
	func   = INT2PTR(void(*)(short, char *, float, void *), SvIV(c_func) );
	(*func)(s0, t1, f2, p3);

void
nci_vstfd( c_func, s0, t1, f2, d3 )
	SV* c_func
	short s0
	char * t1
	float f2
	double d3
PREINIT:
	void(*func)(short, char *, float, double);
CODE:
	func   = INT2PTR(void(*)(short, char *, float, double), SvIV(c_func) );
	(*func)(s0, t1, f2, d3);

void
nci_vstfs( c_func, s0, t1, f2, s3 )
	SV* c_func
	short s0
	char * t1
	float f2
	short s3
PREINIT:
	void(*func)(short, char *, float, short);
CODE:
	func   = INT2PTR(void(*)(short, char *, float, short), SvIV(c_func) );
	(*func)(s0, t1, f2, s3);

void
nci_vstff( c_func, s0, t1, f2, f3 )
	SV* c_func
	short s0
	char * t1
	float f2
	float f3
PREINIT:
	void(*func)(short, char *, float, float);
CODE:
	func   = INT2PTR(void(*)(short, char *, float, float), SvIV(c_func) );
	(*func)(s0, t1, f2, f3);

void
nci_vstft( c_func, s0, t1, f2, t3 )
	SV* c_func
	short s0
	char * t1
	float f2
	char * t3
PREINIT:
	void(*func)(short, char *, float, char *);
CODE:
	func   = INT2PTR(void(*)(short, char *, float, char *), SvIV(c_func) );
	(*func)(s0, t1, f2, t3);

void
nci_vstfi( c_func, s0, t1, f2, i3 )
	SV* c_func
	short s0
	char * t1
	float f2
	int i3
PREINIT:
	void(*func)(short, char *, float, int);
CODE:
	func   = INT2PTR(void(*)(short, char *, float, int), SvIV(c_func) );
	(*func)(s0, t1, f2, i3);

void
nci_vsttp( c_func, s0, t1, t2, p3 )
	SV* c_func
	short s0
	char * t1
	char * t2
	void * p3
PREINIT:
	void(*func)(short, char *, char *, void *);
CODE:
	func   = INT2PTR(void(*)(short, char *, char *, void *), SvIV(c_func) );
	(*func)(s0, t1, t2, p3);

void
nci_vsttd( c_func, s0, t1, t2, d3 )
	SV* c_func
	short s0
	char * t1
	char * t2
	double d3
PREINIT:
	void(*func)(short, char *, char *, double);
CODE:
	func   = INT2PTR(void(*)(short, char *, char *, double), SvIV(c_func) );
	(*func)(s0, t1, t2, d3);

void
nci_vstts( c_func, s0, t1, t2, s3 )
	SV* c_func
	short s0
	char * t1
	char * t2
	short s3
PREINIT:
	void(*func)(short, char *, char *, short);
CODE:
	func   = INT2PTR(void(*)(short, char *, char *, short), SvIV(c_func) );
	(*func)(s0, t1, t2, s3);

void
nci_vsttf( c_func, s0, t1, t2, f3 )
	SV* c_func
	short s0
	char * t1
	char * t2
	float f3
PREINIT:
	void(*func)(short, char *, char *, float);
CODE:
	func   = INT2PTR(void(*)(short, char *, char *, float), SvIV(c_func) );
	(*func)(s0, t1, t2, f3);

void
nci_vsttt( c_func, s0, t1, t2, t3 )
	SV* c_func
	short s0
	char * t1
	char * t2
	char * t3
PREINIT:
	void(*func)(short, char *, char *, char *);
CODE:
	func   = INT2PTR(void(*)(short, char *, char *, char *), SvIV(c_func) );
	(*func)(s0, t1, t2, t3);

void
nci_vstti( c_func, s0, t1, t2, i3 )
	SV* c_func
	short s0
	char * t1
	char * t2
	int i3
PREINIT:
	void(*func)(short, char *, char *, int);
CODE:
	func   = INT2PTR(void(*)(short, char *, char *, int), SvIV(c_func) );
	(*func)(s0, t1, t2, i3);

void
nci_vstip( c_func, s0, t1, i2, p3 )
	SV* c_func
	short s0
	char * t1
	int i2
	void * p3
PREINIT:
	void(*func)(short, char *, int, void *);
CODE:
	func   = INT2PTR(void(*)(short, char *, int, void *), SvIV(c_func) );
	(*func)(s0, t1, i2, p3);

void
nci_vstid( c_func, s0, t1, i2, d3 )
	SV* c_func
	short s0
	char * t1
	int i2
	double d3
PREINIT:
	void(*func)(short, char *, int, double);
CODE:
	func   = INT2PTR(void(*)(short, char *, int, double), SvIV(c_func) );
	(*func)(s0, t1, i2, d3);

void
nci_vstis( c_func, s0, t1, i2, s3 )
	SV* c_func
	short s0
	char * t1
	int i2
	short s3
PREINIT:
	void(*func)(short, char *, int, short);
CODE:
	func   = INT2PTR(void(*)(short, char *, int, short), SvIV(c_func) );
	(*func)(s0, t1, i2, s3);

void
nci_vstif( c_func, s0, t1, i2, f3 )
	SV* c_func
	short s0
	char * t1
	int i2
	float f3
PREINIT:
	void(*func)(short, char *, int, float);
CODE:
	func   = INT2PTR(void(*)(short, char *, int, float), SvIV(c_func) );
	(*func)(s0, t1, i2, f3);

void
nci_vstit( c_func, s0, t1, i2, t3 )
	SV* c_func
	short s0
	char * t1
	int i2
	char * t3
PREINIT:
	void(*func)(short, char *, int, char *);
CODE:
	func   = INT2PTR(void(*)(short, char *, int, char *), SvIV(c_func) );
	(*func)(s0, t1, i2, t3);

void
nci_vstii( c_func, s0, t1, i2, i3 )
	SV* c_func
	short s0
	char * t1
	int i2
	int i3
PREINIT:
	void(*func)(short, char *, int, int);
CODE:
	func   = INT2PTR(void(*)(short, char *, int, int), SvIV(c_func) );
	(*func)(s0, t1, i2, i3);

void
nci_vsipp( c_func, s0, i1, p2, p3 )
	SV* c_func
	short s0
	int i1
	void * p2
	void * p3
PREINIT:
	void(*func)(short, int, void *, void *);
CODE:
	func   = INT2PTR(void(*)(short, int, void *, void *), SvIV(c_func) );
	(*func)(s0, i1, p2, p3);

void
nci_vsipd( c_func, s0, i1, p2, d3 )
	SV* c_func
	short s0
	int i1
	void * p2
	double d3
PREINIT:
	void(*func)(short, int, void *, double);
CODE:
	func   = INT2PTR(void(*)(short, int, void *, double), SvIV(c_func) );
	(*func)(s0, i1, p2, d3);

void
nci_vsips( c_func, s0, i1, p2, s3 )
	SV* c_func
	short s0
	int i1
	void * p2
	short s3
PREINIT:
	void(*func)(short, int, void *, short);
CODE:
	func   = INT2PTR(void(*)(short, int, void *, short), SvIV(c_func) );
	(*func)(s0, i1, p2, s3);

void
nci_vsipf( c_func, s0, i1, p2, f3 )
	SV* c_func
	short s0
	int i1
	void * p2
	float f3
PREINIT:
	void(*func)(short, int, void *, float);
CODE:
	func   = INT2PTR(void(*)(short, int, void *, float), SvIV(c_func) );
	(*func)(s0, i1, p2, f3);

void
nci_vsipt( c_func, s0, i1, p2, t3 )
	SV* c_func
	short s0
	int i1
	void * p2
	char * t3
PREINIT:
	void(*func)(short, int, void *, char *);
CODE:
	func   = INT2PTR(void(*)(short, int, void *, char *), SvIV(c_func) );
	(*func)(s0, i1, p2, t3);

void
nci_vsipi( c_func, s0, i1, p2, i3 )
	SV* c_func
	short s0
	int i1
	void * p2
	int i3
PREINIT:
	void(*func)(short, int, void *, int);
CODE:
	func   = INT2PTR(void(*)(short, int, void *, int), SvIV(c_func) );
	(*func)(s0, i1, p2, i3);

void
nci_vsidp( c_func, s0, i1, d2, p3 )
	SV* c_func
	short s0
	int i1
	double d2
	void * p3
PREINIT:
	void(*func)(short, int, double, void *);
CODE:
	func   = INT2PTR(void(*)(short, int, double, void *), SvIV(c_func) );
	(*func)(s0, i1, d2, p3);

void
nci_vsidd( c_func, s0, i1, d2, d3 )
	SV* c_func
	short s0
	int i1
	double d2
	double d3
PREINIT:
	void(*func)(short, int, double, double);
CODE:
	func   = INT2PTR(void(*)(short, int, double, double), SvIV(c_func) );
	(*func)(s0, i1, d2, d3);

void
nci_vsids( c_func, s0, i1, d2, s3 )
	SV* c_func
	short s0
	int i1
	double d2
	short s3
PREINIT:
	void(*func)(short, int, double, short);
CODE:
	func   = INT2PTR(void(*)(short, int, double, short), SvIV(c_func) );
	(*func)(s0, i1, d2, s3);

void
nci_vsidf( c_func, s0, i1, d2, f3 )
	SV* c_func
	short s0
	int i1
	double d2
	float f3
PREINIT:
	void(*func)(short, int, double, float);
CODE:
	func   = INT2PTR(void(*)(short, int, double, float), SvIV(c_func) );
	(*func)(s0, i1, d2, f3);

void
nci_vsidt( c_func, s0, i1, d2, t3 )
	SV* c_func
	short s0
	int i1
	double d2
	char * t3
PREINIT:
	void(*func)(short, int, double, char *);
CODE:
	func   = INT2PTR(void(*)(short, int, double, char *), SvIV(c_func) );
	(*func)(s0, i1, d2, t3);

void
nci_vsidi( c_func, s0, i1, d2, i3 )
	SV* c_func
	short s0
	int i1
	double d2
	int i3
PREINIT:
	void(*func)(short, int, double, int);
CODE:
	func   = INT2PTR(void(*)(short, int, double, int), SvIV(c_func) );
	(*func)(s0, i1, d2, i3);

void
nci_vsisp( c_func, s0, i1, s2, p3 )
	SV* c_func
	short s0
	int i1
	short s2
	void * p3
PREINIT:
	void(*func)(short, int, short, void *);
CODE:
	func   = INT2PTR(void(*)(short, int, short, void *), SvIV(c_func) );
	(*func)(s0, i1, s2, p3);

void
nci_vsisd( c_func, s0, i1, s2, d3 )
	SV* c_func
	short s0
	int i1
	short s2
	double d3
PREINIT:
	void(*func)(short, int, short, double);
CODE:
	func   = INT2PTR(void(*)(short, int, short, double), SvIV(c_func) );
	(*func)(s0, i1, s2, d3);

void
nci_vsiss( c_func, s0, i1, s2, s3 )
	SV* c_func
	short s0
	int i1
	short s2
	short s3
PREINIT:
	void(*func)(short, int, short, short);
CODE:
	func   = INT2PTR(void(*)(short, int, short, short), SvIV(c_func) );
	(*func)(s0, i1, s2, s3);

void
nci_vsisf( c_func, s0, i1, s2, f3 )
	SV* c_func
	short s0
	int i1
	short s2
	float f3
PREINIT:
	void(*func)(short, int, short, float);
CODE:
	func   = INT2PTR(void(*)(short, int, short, float), SvIV(c_func) );
	(*func)(s0, i1, s2, f3);

void
nci_vsist( c_func, s0, i1, s2, t3 )
	SV* c_func
	short s0
	int i1
	short s2
	char * t3
PREINIT:
	void(*func)(short, int, short, char *);
CODE:
	func   = INT2PTR(void(*)(short, int, short, char *), SvIV(c_func) );
	(*func)(s0, i1, s2, t3);

void
nci_vsisi( c_func, s0, i1, s2, i3 )
	SV* c_func
	short s0
	int i1
	short s2
	int i3
PREINIT:
	void(*func)(short, int, short, int);
CODE:
	func   = INT2PTR(void(*)(short, int, short, int), SvIV(c_func) );
	(*func)(s0, i1, s2, i3);

void
nci_vsifp( c_func, s0, i1, f2, p3 )
	SV* c_func
	short s0
	int i1
	float f2
	void * p3
PREINIT:
	void(*func)(short, int, float, void *);
CODE:
	func   = INT2PTR(void(*)(short, int, float, void *), SvIV(c_func) );
	(*func)(s0, i1, f2, p3);

void
nci_vsifd( c_func, s0, i1, f2, d3 )
	SV* c_func
	short s0
	int i1
	float f2
	double d3
PREINIT:
	void(*func)(short, int, float, double);
CODE:
	func   = INT2PTR(void(*)(short, int, float, double), SvIV(c_func) );
	(*func)(s0, i1, f2, d3);

void
nci_vsifs( c_func, s0, i1, f2, s3 )
	SV* c_func
	short s0
	int i1
	float f2
	short s3
PREINIT:
	void(*func)(short, int, float, short);
CODE:
	func   = INT2PTR(void(*)(short, int, float, short), SvIV(c_func) );
	(*func)(s0, i1, f2, s3);

void
nci_vsiff( c_func, s0, i1, f2, f3 )
	SV* c_func
	short s0
	int i1
	float f2
	float f3
PREINIT:
	void(*func)(short, int, float, float);
CODE:
	func   = INT2PTR(void(*)(short, int, float, float), SvIV(c_func) );
	(*func)(s0, i1, f2, f3);

void
nci_vsift( c_func, s0, i1, f2, t3 )
	SV* c_func
	short s0
	int i1
	float f2
	char * t3
PREINIT:
	void(*func)(short, int, float, char *);
CODE:
	func   = INT2PTR(void(*)(short, int, float, char *), SvIV(c_func) );
	(*func)(s0, i1, f2, t3);

void
nci_vsifi( c_func, s0, i1, f2, i3 )
	SV* c_func
	short s0
	int i1
	float f2
	int i3
PREINIT:
	void(*func)(short, int, float, int);
CODE:
	func   = INT2PTR(void(*)(short, int, float, int), SvIV(c_func) );
	(*func)(s0, i1, f2, i3);

void
nci_vsitp( c_func, s0, i1, t2, p3 )
	SV* c_func
	short s0
	int i1
	char * t2
	void * p3
PREINIT:
	void(*func)(short, int, char *, void *);
CODE:
	func   = INT2PTR(void(*)(short, int, char *, void *), SvIV(c_func) );
	(*func)(s0, i1, t2, p3);

void
nci_vsitd( c_func, s0, i1, t2, d3 )
	SV* c_func
	short s0
	int i1
	char * t2
	double d3
PREINIT:
	void(*func)(short, int, char *, double);
CODE:
	func   = INT2PTR(void(*)(short, int, char *, double), SvIV(c_func) );
	(*func)(s0, i1, t2, d3);

void
nci_vsits( c_func, s0, i1, t2, s3 )
	SV* c_func
	short s0
	int i1
	char * t2
	short s3
PREINIT:
	void(*func)(short, int, char *, short);
CODE:
	func   = INT2PTR(void(*)(short, int, char *, short), SvIV(c_func) );
	(*func)(s0, i1, t2, s3);

void
nci_vsitf( c_func, s0, i1, t2, f3 )
	SV* c_func
	short s0
	int i1
	char * t2
	float f3
PREINIT:
	void(*func)(short, int, char *, float);
CODE:
	func   = INT2PTR(void(*)(short, int, char *, float), SvIV(c_func) );
	(*func)(s0, i1, t2, f3);

void
nci_vsitt( c_func, s0, i1, t2, t3 )
	SV* c_func
	short s0
	int i1
	char * t2
	char * t3
PREINIT:
	void(*func)(short, int, char *, char *);
CODE:
	func   = INT2PTR(void(*)(short, int, char *, char *), SvIV(c_func) );
	(*func)(s0, i1, t2, t3);

void
nci_vsiti( c_func, s0, i1, t2, i3 )
	SV* c_func
	short s0
	int i1
	char * t2
	int i3
PREINIT:
	void(*func)(short, int, char *, int);
CODE:
	func   = INT2PTR(void(*)(short, int, char *, int), SvIV(c_func) );
	(*func)(s0, i1, t2, i3);

void
nci_vsiip( c_func, s0, i1, i2, p3 )
	SV* c_func
	short s0
	int i1
	int i2
	void * p3
PREINIT:
	void(*func)(short, int, int, void *);
CODE:
	func   = INT2PTR(void(*)(short, int, int, void *), SvIV(c_func) );
	(*func)(s0, i1, i2, p3);

void
nci_vsiid( c_func, s0, i1, i2, d3 )
	SV* c_func
	short s0
	int i1
	int i2
	double d3
PREINIT:
	void(*func)(short, int, int, double);
CODE:
	func   = INT2PTR(void(*)(short, int, int, double), SvIV(c_func) );
	(*func)(s0, i1, i2, d3);

void
nci_vsiis( c_func, s0, i1, i2, s3 )
	SV* c_func
	short s0
	int i1
	int i2
	short s3
PREINIT:
	void(*func)(short, int, int, short);
CODE:
	func   = INT2PTR(void(*)(short, int, int, short), SvIV(c_func) );
	(*func)(s0, i1, i2, s3);

void
nci_vsiif( c_func, s0, i1, i2, f3 )
	SV* c_func
	short s0
	int i1
	int i2
	float f3
PREINIT:
	void(*func)(short, int, int, float);
CODE:
	func   = INT2PTR(void(*)(short, int, int, float), SvIV(c_func) );
	(*func)(s0, i1, i2, f3);

void
nci_vsiit( c_func, s0, i1, i2, t3 )
	SV* c_func
	short s0
	int i1
	int i2
	char * t3
PREINIT:
	void(*func)(short, int, int, char *);
CODE:
	func   = INT2PTR(void(*)(short, int, int, char *), SvIV(c_func) );
	(*func)(s0, i1, i2, t3);

void
nci_vsiii( c_func, s0, i1, i2, i3 )
	SV* c_func
	short s0
	int i1
	int i2
	int i3
PREINIT:
	void(*func)(short, int, int, int);
CODE:
	func   = INT2PTR(void(*)(short, int, int, int), SvIV(c_func) );
	(*func)(s0, i1, i2, i3);

void
nci_vfppp( c_func, f0, p1, p2, p3 )
	SV* c_func
	float f0
	void * p1
	void * p2
	void * p3
PREINIT:
	void(*func)(float, void *, void *, void *);
CODE:
	func   = INT2PTR(void(*)(float, void *, void *, void *), SvIV(c_func) );
	(*func)(f0, p1, p2, p3);

void
nci_vfppd( c_func, f0, p1, p2, d3 )
	SV* c_func
	float f0
	void * p1
	void * p2
	double d3
PREINIT:
	void(*func)(float, void *, void *, double);
CODE:
	func   = INT2PTR(void(*)(float, void *, void *, double), SvIV(c_func) );
	(*func)(f0, p1, p2, d3);

void
nci_vfpps( c_func, f0, p1, p2, s3 )
	SV* c_func
	float f0
	void * p1
	void * p2
	short s3
PREINIT:
	void(*func)(float, void *, void *, short);
CODE:
	func   = INT2PTR(void(*)(float, void *, void *, short), SvIV(c_func) );
	(*func)(f0, p1, p2, s3);

void
nci_vfppf( c_func, f0, p1, p2, f3 )
	SV* c_func
	float f0
	void * p1
	void * p2
	float f3
PREINIT:
	void(*func)(float, void *, void *, float);
CODE:
	func   = INT2PTR(void(*)(float, void *, void *, float), SvIV(c_func) );
	(*func)(f0, p1, p2, f3);

void
nci_vfppt( c_func, f0, p1, p2, t3 )
	SV* c_func
	float f0
	void * p1
	void * p2
	char * t3
PREINIT:
	void(*func)(float, void *, void *, char *);
CODE:
	func   = INT2PTR(void(*)(float, void *, void *, char *), SvIV(c_func) );
	(*func)(f0, p1, p2, t3);

void
nci_vfppi( c_func, f0, p1, p2, i3 )
	SV* c_func
	float f0
	void * p1
	void * p2
	int i3
PREINIT:
	void(*func)(float, void *, void *, int);
CODE:
	func   = INT2PTR(void(*)(float, void *, void *, int), SvIV(c_func) );
	(*func)(f0, p1, p2, i3);

void
nci_vfpdp( c_func, f0, p1, d2, p3 )
	SV* c_func
	float f0
	void * p1
	double d2
	void * p3
PREINIT:
	void(*func)(float, void *, double, void *);
CODE:
	func   = INT2PTR(void(*)(float, void *, double, void *), SvIV(c_func) );
	(*func)(f0, p1, d2, p3);

void
nci_vfpdd( c_func, f0, p1, d2, d3 )
	SV* c_func
	float f0
	void * p1
	double d2
	double d3
PREINIT:
	void(*func)(float, void *, double, double);
CODE:
	func   = INT2PTR(void(*)(float, void *, double, double), SvIV(c_func) );
	(*func)(f0, p1, d2, d3);

void
nci_vfpds( c_func, f0, p1, d2, s3 )
	SV* c_func
	float f0
	void * p1
	double d2
	short s3
PREINIT:
	void(*func)(float, void *, double, short);
CODE:
	func   = INT2PTR(void(*)(float, void *, double, short), SvIV(c_func) );
	(*func)(f0, p1, d2, s3);

void
nci_vfpdf( c_func, f0, p1, d2, f3 )
	SV* c_func
	float f0
	void * p1
	double d2
	float f3
PREINIT:
	void(*func)(float, void *, double, float);
CODE:
	func   = INT2PTR(void(*)(float, void *, double, float), SvIV(c_func) );
	(*func)(f0, p1, d2, f3);

void
nci_vfpdt( c_func, f0, p1, d2, t3 )
	SV* c_func
	float f0
	void * p1
	double d2
	char * t3
PREINIT:
	void(*func)(float, void *, double, char *);
CODE:
	func   = INT2PTR(void(*)(float, void *, double, char *), SvIV(c_func) );
	(*func)(f0, p1, d2, t3);

void
nci_vfpdi( c_func, f0, p1, d2, i3 )
	SV* c_func
	float f0
	void * p1
	double d2
	int i3
PREINIT:
	void(*func)(float, void *, double, int);
CODE:
	func   = INT2PTR(void(*)(float, void *, double, int), SvIV(c_func) );
	(*func)(f0, p1, d2, i3);

void
nci_vfpsp( c_func, f0, p1, s2, p3 )
	SV* c_func
	float f0
	void * p1
	short s2
	void * p3
PREINIT:
	void(*func)(float, void *, short, void *);
CODE:
	func   = INT2PTR(void(*)(float, void *, short, void *), SvIV(c_func) );
	(*func)(f0, p1, s2, p3);

void
nci_vfpsd( c_func, f0, p1, s2, d3 )
	SV* c_func
	float f0
	void * p1
	short s2
	double d3
PREINIT:
	void(*func)(float, void *, short, double);
CODE:
	func   = INT2PTR(void(*)(float, void *, short, double), SvIV(c_func) );
	(*func)(f0, p1, s2, d3);

void
nci_vfpss( c_func, f0, p1, s2, s3 )
	SV* c_func
	float f0
	void * p1
	short s2
	short s3
PREINIT:
	void(*func)(float, void *, short, short);
CODE:
	func   = INT2PTR(void(*)(float, void *, short, short), SvIV(c_func) );
	(*func)(f0, p1, s2, s3);

void
nci_vfpsf( c_func, f0, p1, s2, f3 )
	SV* c_func
	float f0
	void * p1
	short s2
	float f3
PREINIT:
	void(*func)(float, void *, short, float);
CODE:
	func   = INT2PTR(void(*)(float, void *, short, float), SvIV(c_func) );
	(*func)(f0, p1, s2, f3);

void
nci_vfpst( c_func, f0, p1, s2, t3 )
	SV* c_func
	float f0
	void * p1
	short s2
	char * t3
PREINIT:
	void(*func)(float, void *, short, char *);
CODE:
	func   = INT2PTR(void(*)(float, void *, short, char *), SvIV(c_func) );
	(*func)(f0, p1, s2, t3);

void
nci_vfpsi( c_func, f0, p1, s2, i3 )
	SV* c_func
	float f0
	void * p1
	short s2
	int i3
PREINIT:
	void(*func)(float, void *, short, int);
CODE:
	func   = INT2PTR(void(*)(float, void *, short, int), SvIV(c_func) );
	(*func)(f0, p1, s2, i3);

void
nci_vfpfp( c_func, f0, p1, f2, p3 )
	SV* c_func
	float f0
	void * p1
	float f2
	void * p3
PREINIT:
	void(*func)(float, void *, float, void *);
CODE:
	func   = INT2PTR(void(*)(float, void *, float, void *), SvIV(c_func) );
	(*func)(f0, p1, f2, p3);

void
nci_vfpfd( c_func, f0, p1, f2, d3 )
	SV* c_func
	float f0
	void * p1
	float f2
	double d3
PREINIT:
	void(*func)(float, void *, float, double);
CODE:
	func   = INT2PTR(void(*)(float, void *, float, double), SvIV(c_func) );
	(*func)(f0, p1, f2, d3);

void
nci_vfpfs( c_func, f0, p1, f2, s3 )
	SV* c_func
	float f0
	void * p1
	float f2
	short s3
PREINIT:
	void(*func)(float, void *, float, short);
CODE:
	func   = INT2PTR(void(*)(float, void *, float, short), SvIV(c_func) );
	(*func)(f0, p1, f2, s3);

void
nci_vfpff( c_func, f0, p1, f2, f3 )
	SV* c_func
	float f0
	void * p1
	float f2
	float f3
PREINIT:
	void(*func)(float, void *, float, float);
CODE:
	func   = INT2PTR(void(*)(float, void *, float, float), SvIV(c_func) );
	(*func)(f0, p1, f2, f3);

void
nci_vfpft( c_func, f0, p1, f2, t3 )
	SV* c_func
	float f0
	void * p1
	float f2
	char * t3
PREINIT:
	void(*func)(float, void *, float, char *);
CODE:
	func   = INT2PTR(void(*)(float, void *, float, char *), SvIV(c_func) );
	(*func)(f0, p1, f2, t3);

void
nci_vfpfi( c_func, f0, p1, f2, i3 )
	SV* c_func
	float f0
	void * p1
	float f2
	int i3
PREINIT:
	void(*func)(float, void *, float, int);
CODE:
	func   = INT2PTR(void(*)(float, void *, float, int), SvIV(c_func) );
	(*func)(f0, p1, f2, i3);

void
nci_vfptp( c_func, f0, p1, t2, p3 )
	SV* c_func
	float f0
	void * p1
	char * t2
	void * p3
PREINIT:
	void(*func)(float, void *, char *, void *);
CODE:
	func   = INT2PTR(void(*)(float, void *, char *, void *), SvIV(c_func) );
	(*func)(f0, p1, t2, p3);

void
nci_vfptd( c_func, f0, p1, t2, d3 )
	SV* c_func
	float f0
	void * p1
	char * t2
	double d3
PREINIT:
	void(*func)(float, void *, char *, double);
CODE:
	func   = INT2PTR(void(*)(float, void *, char *, double), SvIV(c_func) );
	(*func)(f0, p1, t2, d3);

void
nci_vfpts( c_func, f0, p1, t2, s3 )
	SV* c_func
	float f0
	void * p1
	char * t2
	short s3
PREINIT:
	void(*func)(float, void *, char *, short);
CODE:
	func   = INT2PTR(void(*)(float, void *, char *, short), SvIV(c_func) );
	(*func)(f0, p1, t2, s3);

void
nci_vfptf( c_func, f0, p1, t2, f3 )
	SV* c_func
	float f0
	void * p1
	char * t2
	float f3
PREINIT:
	void(*func)(float, void *, char *, float);
CODE:
	func   = INT2PTR(void(*)(float, void *, char *, float), SvIV(c_func) );
	(*func)(f0, p1, t2, f3);

void
nci_vfptt( c_func, f0, p1, t2, t3 )
	SV* c_func
	float f0
	void * p1
	char * t2
	char * t3
PREINIT:
	void(*func)(float, void *, char *, char *);
CODE:
	func   = INT2PTR(void(*)(float, void *, char *, char *), SvIV(c_func) );
	(*func)(f0, p1, t2, t3);

void
nci_vfpti( c_func, f0, p1, t2, i3 )
	SV* c_func
	float f0
	void * p1
	char * t2
	int i3
PREINIT:
	void(*func)(float, void *, char *, int);
CODE:
	func   = INT2PTR(void(*)(float, void *, char *, int), SvIV(c_func) );
	(*func)(f0, p1, t2, i3);

void
nci_vfpip( c_func, f0, p1, i2, p3 )
	SV* c_func
	float f0
	void * p1
	int i2
	void * p3
PREINIT:
	void(*func)(float, void *, int, void *);
CODE:
	func   = INT2PTR(void(*)(float, void *, int, void *), SvIV(c_func) );
	(*func)(f0, p1, i2, p3);

void
nci_vfpid( c_func, f0, p1, i2, d3 )
	SV* c_func
	float f0
	void * p1
	int i2
	double d3
PREINIT:
	void(*func)(float, void *, int, double);
CODE:
	func   = INT2PTR(void(*)(float, void *, int, double), SvIV(c_func) );
	(*func)(f0, p1, i2, d3);

void
nci_vfpis( c_func, f0, p1, i2, s3 )
	SV* c_func
	float f0
	void * p1
	int i2
	short s3
PREINIT:
	void(*func)(float, void *, int, short);
CODE:
	func   = INT2PTR(void(*)(float, void *, int, short), SvIV(c_func) );
	(*func)(f0, p1, i2, s3);

void
nci_vfpif( c_func, f0, p1, i2, f3 )
	SV* c_func
	float f0
	void * p1
	int i2
	float f3
PREINIT:
	void(*func)(float, void *, int, float);
CODE:
	func   = INT2PTR(void(*)(float, void *, int, float), SvIV(c_func) );
	(*func)(f0, p1, i2, f3);

void
nci_vfpit( c_func, f0, p1, i2, t3 )
	SV* c_func
	float f0
	void * p1
	int i2
	char * t3
PREINIT:
	void(*func)(float, void *, int, char *);
CODE:
	func   = INT2PTR(void(*)(float, void *, int, char *), SvIV(c_func) );
	(*func)(f0, p1, i2, t3);

void
nci_vfpii( c_func, f0, p1, i2, i3 )
	SV* c_func
	float f0
	void * p1
	int i2
	int i3
PREINIT:
	void(*func)(float, void *, int, int);
CODE:
	func   = INT2PTR(void(*)(float, void *, int, int), SvIV(c_func) );
	(*func)(f0, p1, i2, i3);

void
nci_vfdpp( c_func, f0, d1, p2, p3 )
	SV* c_func
	float f0
	double d1
	void * p2
	void * p3
PREINIT:
	void(*func)(float, double, void *, void *);
CODE:
	func   = INT2PTR(void(*)(float, double, void *, void *), SvIV(c_func) );
	(*func)(f0, d1, p2, p3);

void
nci_vfdpd( c_func, f0, d1, p2, d3 )
	SV* c_func
	float f0
	double d1
	void * p2
	double d3
PREINIT:
	void(*func)(float, double, void *, double);
CODE:
	func   = INT2PTR(void(*)(float, double, void *, double), SvIV(c_func) );
	(*func)(f0, d1, p2, d3);

void
nci_vfdps( c_func, f0, d1, p2, s3 )
	SV* c_func
	float f0
	double d1
	void * p2
	short s3
PREINIT:
	void(*func)(float, double, void *, short);
CODE:
	func   = INT2PTR(void(*)(float, double, void *, short), SvIV(c_func) );
	(*func)(f0, d1, p2, s3);

void
nci_vfdpf( c_func, f0, d1, p2, f3 )
	SV* c_func
	float f0
	double d1
	void * p2
	float f3
PREINIT:
	void(*func)(float, double, void *, float);
CODE:
	func   = INT2PTR(void(*)(float, double, void *, float), SvIV(c_func) );
	(*func)(f0, d1, p2, f3);

void
nci_vfdpt( c_func, f0, d1, p2, t3 )
	SV* c_func
	float f0
	double d1
	void * p2
	char * t3
PREINIT:
	void(*func)(float, double, void *, char *);
CODE:
	func   = INT2PTR(void(*)(float, double, void *, char *), SvIV(c_func) );
	(*func)(f0, d1, p2, t3);

void
nci_vfdpi( c_func, f0, d1, p2, i3 )
	SV* c_func
	float f0
	double d1
	void * p2
	int i3
PREINIT:
	void(*func)(float, double, void *, int);
CODE:
	func   = INT2PTR(void(*)(float, double, void *, int), SvIV(c_func) );
	(*func)(f0, d1, p2, i3);

void
nci_vfddp( c_func, f0, d1, d2, p3 )
	SV* c_func
	float f0
	double d1
	double d2
	void * p3
PREINIT:
	void(*func)(float, double, double, void *);
CODE:
	func   = INT2PTR(void(*)(float, double, double, void *), SvIV(c_func) );
	(*func)(f0, d1, d2, p3);

void
nci_vfddd( c_func, f0, d1, d2, d3 )
	SV* c_func
	float f0
	double d1
	double d2
	double d3
PREINIT:
	void(*func)(float, double, double, double);
CODE:
	func   = INT2PTR(void(*)(float, double, double, double), SvIV(c_func) );
	(*func)(f0, d1, d2, d3);

void
nci_vfdds( c_func, f0, d1, d2, s3 )
	SV* c_func
	float f0
	double d1
	double d2
	short s3
PREINIT:
	void(*func)(float, double, double, short);
CODE:
	func   = INT2PTR(void(*)(float, double, double, short), SvIV(c_func) );
	(*func)(f0, d1, d2, s3);

void
nci_vfddf( c_func, f0, d1, d2, f3 )
	SV* c_func
	float f0
	double d1
	double d2
	float f3
PREINIT:
	void(*func)(float, double, double, float);
CODE:
	func   = INT2PTR(void(*)(float, double, double, float), SvIV(c_func) );
	(*func)(f0, d1, d2, f3);

void
nci_vfddt( c_func, f0, d1, d2, t3 )
	SV* c_func
	float f0
	double d1
	double d2
	char * t3
PREINIT:
	void(*func)(float, double, double, char *);
CODE:
	func   = INT2PTR(void(*)(float, double, double, char *), SvIV(c_func) );
	(*func)(f0, d1, d2, t3);

void
nci_vfddi( c_func, f0, d1, d2, i3 )
	SV* c_func
	float f0
	double d1
	double d2
	int i3
PREINIT:
	void(*func)(float, double, double, int);
CODE:
	func   = INT2PTR(void(*)(float, double, double, int), SvIV(c_func) );
	(*func)(f0, d1, d2, i3);

void
nci_vfdsp( c_func, f0, d1, s2, p3 )
	SV* c_func
	float f0
	double d1
	short s2
	void * p3
PREINIT:
	void(*func)(float, double, short, void *);
CODE:
	func   = INT2PTR(void(*)(float, double, short, void *), SvIV(c_func) );
	(*func)(f0, d1, s2, p3);

void
nci_vfdsd( c_func, f0, d1, s2, d3 )
	SV* c_func
	float f0
	double d1
	short s2
	double d3
PREINIT:
	void(*func)(float, double, short, double);
CODE:
	func   = INT2PTR(void(*)(float, double, short, double), SvIV(c_func) );
	(*func)(f0, d1, s2, d3);

void
nci_vfdss( c_func, f0, d1, s2, s3 )
	SV* c_func
	float f0
	double d1
	short s2
	short s3
PREINIT:
	void(*func)(float, double, short, short);
CODE:
	func   = INT2PTR(void(*)(float, double, short, short), SvIV(c_func) );
	(*func)(f0, d1, s2, s3);

void
nci_vfdsf( c_func, f0, d1, s2, f3 )
	SV* c_func
	float f0
	double d1
	short s2
	float f3
PREINIT:
	void(*func)(float, double, short, float);
CODE:
	func   = INT2PTR(void(*)(float, double, short, float), SvIV(c_func) );
	(*func)(f0, d1, s2, f3);

void
nci_vfdst( c_func, f0, d1, s2, t3 )
	SV* c_func
	float f0
	double d1
	short s2
	char * t3
PREINIT:
	void(*func)(float, double, short, char *);
CODE:
	func   = INT2PTR(void(*)(float, double, short, char *), SvIV(c_func) );
	(*func)(f0, d1, s2, t3);

void
nci_vfdsi( c_func, f0, d1, s2, i3 )
	SV* c_func
	float f0
	double d1
	short s2
	int i3
PREINIT:
	void(*func)(float, double, short, int);
CODE:
	func   = INT2PTR(void(*)(float, double, short, int), SvIV(c_func) );
	(*func)(f0, d1, s2, i3);

void
nci_vfdfp( c_func, f0, d1, f2, p3 )
	SV* c_func
	float f0
	double d1
	float f2
	void * p3
PREINIT:
	void(*func)(float, double, float, void *);
CODE:
	func   = INT2PTR(void(*)(float, double, float, void *), SvIV(c_func) );
	(*func)(f0, d1, f2, p3);

void
nci_vfdfd( c_func, f0, d1, f2, d3 )
	SV* c_func
	float f0
	double d1
	float f2
	double d3
PREINIT:
	void(*func)(float, double, float, double);
CODE:
	func   = INT2PTR(void(*)(float, double, float, double), SvIV(c_func) );
	(*func)(f0, d1, f2, d3);

void
nci_vfdfs( c_func, f0, d1, f2, s3 )
	SV* c_func
	float f0
	double d1
	float f2
	short s3
PREINIT:
	void(*func)(float, double, float, short);
CODE:
	func   = INT2PTR(void(*)(float, double, float, short), SvIV(c_func) );
	(*func)(f0, d1, f2, s3);

void
nci_vfdff( c_func, f0, d1, f2, f3 )
	SV* c_func
	float f0
	double d1
	float f2
	float f3
PREINIT:
	void(*func)(float, double, float, float);
CODE:
	func   = INT2PTR(void(*)(float, double, float, float), SvIV(c_func) );
	(*func)(f0, d1, f2, f3);

void
nci_vfdft( c_func, f0, d1, f2, t3 )
	SV* c_func
	float f0
	double d1
	float f2
	char * t3
PREINIT:
	void(*func)(float, double, float, char *);
CODE:
	func   = INT2PTR(void(*)(float, double, float, char *), SvIV(c_func) );
	(*func)(f0, d1, f2, t3);

void
nci_vfdfi( c_func, f0, d1, f2, i3 )
	SV* c_func
	float f0
	double d1
	float f2
	int i3
PREINIT:
	void(*func)(float, double, float, int);
CODE:
	func   = INT2PTR(void(*)(float, double, float, int), SvIV(c_func) );
	(*func)(f0, d1, f2, i3);

void
nci_vfdtp( c_func, f0, d1, t2, p3 )
	SV* c_func
	float f0
	double d1
	char * t2
	void * p3
PREINIT:
	void(*func)(float, double, char *, void *);
CODE:
	func   = INT2PTR(void(*)(float, double, char *, void *), SvIV(c_func) );
	(*func)(f0, d1, t2, p3);

void
nci_vfdtd( c_func, f0, d1, t2, d3 )
	SV* c_func
	float f0
	double d1
	char * t2
	double d3
PREINIT:
	void(*func)(float, double, char *, double);
CODE:
	func   = INT2PTR(void(*)(float, double, char *, double), SvIV(c_func) );
	(*func)(f0, d1, t2, d3);

void
nci_vfdts( c_func, f0, d1, t2, s3 )
	SV* c_func
	float f0
	double d1
	char * t2
	short s3
PREINIT:
	void(*func)(float, double, char *, short);
CODE:
	func   = INT2PTR(void(*)(float, double, char *, short), SvIV(c_func) );
	(*func)(f0, d1, t2, s3);

void
nci_vfdtf( c_func, f0, d1, t2, f3 )
	SV* c_func
	float f0
	double d1
	char * t2
	float f3
PREINIT:
	void(*func)(float, double, char *, float);
CODE:
	func   = INT2PTR(void(*)(float, double, char *, float), SvIV(c_func) );
	(*func)(f0, d1, t2, f3);

void
nci_vfdtt( c_func, f0, d1, t2, t3 )
	SV* c_func
	float f0
	double d1
	char * t2
	char * t3
PREINIT:
	void(*func)(float, double, char *, char *);
CODE:
	func   = INT2PTR(void(*)(float, double, char *, char *), SvIV(c_func) );
	(*func)(f0, d1, t2, t3);

void
nci_vfdti( c_func, f0, d1, t2, i3 )
	SV* c_func
	float f0
	double d1
	char * t2
	int i3
PREINIT:
	void(*func)(float, double, char *, int);
CODE:
	func   = INT2PTR(void(*)(float, double, char *, int), SvIV(c_func) );
	(*func)(f0, d1, t2, i3);

void
nci_vfdip( c_func, f0, d1, i2, p3 )
	SV* c_func
	float f0
	double d1
	int i2
	void * p3
PREINIT:
	void(*func)(float, double, int, void *);
CODE:
	func   = INT2PTR(void(*)(float, double, int, void *), SvIV(c_func) );
	(*func)(f0, d1, i2, p3);

void
nci_vfdid( c_func, f0, d1, i2, d3 )
	SV* c_func
	float f0
	double d1
	int i2
	double d3
PREINIT:
	void(*func)(float, double, int, double);
CODE:
	func   = INT2PTR(void(*)(float, double, int, double), SvIV(c_func) );
	(*func)(f0, d1, i2, d3);

void
nci_vfdis( c_func, f0, d1, i2, s3 )
	SV* c_func
	float f0
	double d1
	int i2
	short s3
PREINIT:
	void(*func)(float, double, int, short);
CODE:
	func   = INT2PTR(void(*)(float, double, int, short), SvIV(c_func) );
	(*func)(f0, d1, i2, s3);

void
nci_vfdif( c_func, f0, d1, i2, f3 )
	SV* c_func
	float f0
	double d1
	int i2
	float f3
PREINIT:
	void(*func)(float, double, int, float);
CODE:
	func   = INT2PTR(void(*)(float, double, int, float), SvIV(c_func) );
	(*func)(f0, d1, i2, f3);

void
nci_vfdit( c_func, f0, d1, i2, t3 )
	SV* c_func
	float f0
	double d1
	int i2
	char * t3
PREINIT:
	void(*func)(float, double, int, char *);
CODE:
	func   = INT2PTR(void(*)(float, double, int, char *), SvIV(c_func) );
	(*func)(f0, d1, i2, t3);

void
nci_vfdii( c_func, f0, d1, i2, i3 )
	SV* c_func
	float f0
	double d1
	int i2
	int i3
PREINIT:
	void(*func)(float, double, int, int);
CODE:
	func   = INT2PTR(void(*)(float, double, int, int), SvIV(c_func) );
	(*func)(f0, d1, i2, i3);

void
nci_vfspp( c_func, f0, s1, p2, p3 )
	SV* c_func
	float f0
	short s1
	void * p2
	void * p3
PREINIT:
	void(*func)(float, short, void *, void *);
CODE:
	func   = INT2PTR(void(*)(float, short, void *, void *), SvIV(c_func) );
	(*func)(f0, s1, p2, p3);

void
nci_vfspd( c_func, f0, s1, p2, d3 )
	SV* c_func
	float f0
	short s1
	void * p2
	double d3
PREINIT:
	void(*func)(float, short, void *, double);
CODE:
	func   = INT2PTR(void(*)(float, short, void *, double), SvIV(c_func) );
	(*func)(f0, s1, p2, d3);

void
nci_vfsps( c_func, f0, s1, p2, s3 )
	SV* c_func
	float f0
	short s1
	void * p2
	short s3
PREINIT:
	void(*func)(float, short, void *, short);
CODE:
	func   = INT2PTR(void(*)(float, short, void *, short), SvIV(c_func) );
	(*func)(f0, s1, p2, s3);

void
nci_vfspf( c_func, f0, s1, p2, f3 )
	SV* c_func
	float f0
	short s1
	void * p2
	float f3
PREINIT:
	void(*func)(float, short, void *, float);
CODE:
	func   = INT2PTR(void(*)(float, short, void *, float), SvIV(c_func) );
	(*func)(f0, s1, p2, f3);

void
nci_vfspt( c_func, f0, s1, p2, t3 )
	SV* c_func
	float f0
	short s1
	void * p2
	char * t3
PREINIT:
	void(*func)(float, short, void *, char *);
CODE:
	func   = INT2PTR(void(*)(float, short, void *, char *), SvIV(c_func) );
	(*func)(f0, s1, p2, t3);

void
nci_vfspi( c_func, f0, s1, p2, i3 )
	SV* c_func
	float f0
	short s1
	void * p2
	int i3
PREINIT:
	void(*func)(float, short, void *, int);
CODE:
	func   = INT2PTR(void(*)(float, short, void *, int), SvIV(c_func) );
	(*func)(f0, s1, p2, i3);

void
nci_vfsdp( c_func, f0, s1, d2, p3 )
	SV* c_func
	float f0
	short s1
	double d2
	void * p3
PREINIT:
	void(*func)(float, short, double, void *);
CODE:
	func   = INT2PTR(void(*)(float, short, double, void *), SvIV(c_func) );
	(*func)(f0, s1, d2, p3);

void
nci_vfsdd( c_func, f0, s1, d2, d3 )
	SV* c_func
	float f0
	short s1
	double d2
	double d3
PREINIT:
	void(*func)(float, short, double, double);
CODE:
	func   = INT2PTR(void(*)(float, short, double, double), SvIV(c_func) );
	(*func)(f0, s1, d2, d3);

void
nci_vfsds( c_func, f0, s1, d2, s3 )
	SV* c_func
	float f0
	short s1
	double d2
	short s3
PREINIT:
	void(*func)(float, short, double, short);
CODE:
	func   = INT2PTR(void(*)(float, short, double, short), SvIV(c_func) );
	(*func)(f0, s1, d2, s3);

void
nci_vfsdf( c_func, f0, s1, d2, f3 )
	SV* c_func
	float f0
	short s1
	double d2
	float f3
PREINIT:
	void(*func)(float, short, double, float);
CODE:
	func   = INT2PTR(void(*)(float, short, double, float), SvIV(c_func) );
	(*func)(f0, s1, d2, f3);

void
nci_vfsdt( c_func, f0, s1, d2, t3 )
	SV* c_func
	float f0
	short s1
	double d2
	char * t3
PREINIT:
	void(*func)(float, short, double, char *);
CODE:
	func   = INT2PTR(void(*)(float, short, double, char *), SvIV(c_func) );
	(*func)(f0, s1, d2, t3);

void
nci_vfsdi( c_func, f0, s1, d2, i3 )
	SV* c_func
	float f0
	short s1
	double d2
	int i3
PREINIT:
	void(*func)(float, short, double, int);
CODE:
	func   = INT2PTR(void(*)(float, short, double, int), SvIV(c_func) );
	(*func)(f0, s1, d2, i3);

void
nci_vfssp( c_func, f0, s1, s2, p3 )
	SV* c_func
	float f0
	short s1
	short s2
	void * p3
PREINIT:
	void(*func)(float, short, short, void *);
CODE:
	func   = INT2PTR(void(*)(float, short, short, void *), SvIV(c_func) );
	(*func)(f0, s1, s2, p3);

void
nci_vfssd( c_func, f0, s1, s2, d3 )
	SV* c_func
	float f0
	short s1
	short s2
	double d3
PREINIT:
	void(*func)(float, short, short, double);
CODE:
	func   = INT2PTR(void(*)(float, short, short, double), SvIV(c_func) );
	(*func)(f0, s1, s2, d3);

void
nci_vfsss( c_func, f0, s1, s2, s3 )
	SV* c_func
	float f0
	short s1
	short s2
	short s3
PREINIT:
	void(*func)(float, short, short, short);
CODE:
	func   = INT2PTR(void(*)(float, short, short, short), SvIV(c_func) );
	(*func)(f0, s1, s2, s3);

void
nci_vfssf( c_func, f0, s1, s2, f3 )
	SV* c_func
	float f0
	short s1
	short s2
	float f3
PREINIT:
	void(*func)(float, short, short, float);
CODE:
	func   = INT2PTR(void(*)(float, short, short, float), SvIV(c_func) );
	(*func)(f0, s1, s2, f3);

void
nci_vfsst( c_func, f0, s1, s2, t3 )
	SV* c_func
	float f0
	short s1
	short s2
	char * t3
PREINIT:
	void(*func)(float, short, short, char *);
CODE:
	func   = INT2PTR(void(*)(float, short, short, char *), SvIV(c_func) );
	(*func)(f0, s1, s2, t3);

void
nci_vfssi( c_func, f0, s1, s2, i3 )
	SV* c_func
	float f0
	short s1
	short s2
	int i3
PREINIT:
	void(*func)(float, short, short, int);
CODE:
	func   = INT2PTR(void(*)(float, short, short, int), SvIV(c_func) );
	(*func)(f0, s1, s2, i3);

void
nci_vfsfp( c_func, f0, s1, f2, p3 )
	SV* c_func
	float f0
	short s1
	float f2
	void * p3
PREINIT:
	void(*func)(float, short, float, void *);
CODE:
	func   = INT2PTR(void(*)(float, short, float, void *), SvIV(c_func) );
	(*func)(f0, s1, f2, p3);

void
nci_vfsfd( c_func, f0, s1, f2, d3 )
	SV* c_func
	float f0
	short s1
	float f2
	double d3
PREINIT:
	void(*func)(float, short, float, double);
CODE:
	func   = INT2PTR(void(*)(float, short, float, double), SvIV(c_func) );
	(*func)(f0, s1, f2, d3);

void
nci_vfsfs( c_func, f0, s1, f2, s3 )
	SV* c_func
	float f0
	short s1
	float f2
	short s3
PREINIT:
	void(*func)(float, short, float, short);
CODE:
	func   = INT2PTR(void(*)(float, short, float, short), SvIV(c_func) );
	(*func)(f0, s1, f2, s3);

void
nci_vfsff( c_func, f0, s1, f2, f3 )
	SV* c_func
	float f0
	short s1
	float f2
	float f3
PREINIT:
	void(*func)(float, short, float, float);
CODE:
	func   = INT2PTR(void(*)(float, short, float, float), SvIV(c_func) );
	(*func)(f0, s1, f2, f3);

void
nci_vfsft( c_func, f0, s1, f2, t3 )
	SV* c_func
	float f0
	short s1
	float f2
	char * t3
PREINIT:
	void(*func)(float, short, float, char *);
CODE:
	func   = INT2PTR(void(*)(float, short, float, char *), SvIV(c_func) );
	(*func)(f0, s1, f2, t3);

void
nci_vfsfi( c_func, f0, s1, f2, i3 )
	SV* c_func
	float f0
	short s1
	float f2
	int i3
PREINIT:
	void(*func)(float, short, float, int);
CODE:
	func   = INT2PTR(void(*)(float, short, float, int), SvIV(c_func) );
	(*func)(f0, s1, f2, i3);

void
nci_vfstp( c_func, f0, s1, t2, p3 )
	SV* c_func
	float f0
	short s1
	char * t2
	void * p3
PREINIT:
	void(*func)(float, short, char *, void *);
CODE:
	func   = INT2PTR(void(*)(float, short, char *, void *), SvIV(c_func) );
	(*func)(f0, s1, t2, p3);

void
nci_vfstd( c_func, f0, s1, t2, d3 )
	SV* c_func
	float f0
	short s1
	char * t2
	double d3
PREINIT:
	void(*func)(float, short, char *, double);
CODE:
	func   = INT2PTR(void(*)(float, short, char *, double), SvIV(c_func) );
	(*func)(f0, s1, t2, d3);

void
nci_vfsts( c_func, f0, s1, t2, s3 )
	SV* c_func
	float f0
	short s1
	char * t2
	short s3
PREINIT:
	void(*func)(float, short, char *, short);
CODE:
	func   = INT2PTR(void(*)(float, short, char *, short), SvIV(c_func) );
	(*func)(f0, s1, t2, s3);

void
nci_vfstf( c_func, f0, s1, t2, f3 )
	SV* c_func
	float f0
	short s1
	char * t2
	float f3
PREINIT:
	void(*func)(float, short, char *, float);
CODE:
	func   = INT2PTR(void(*)(float, short, char *, float), SvIV(c_func) );
	(*func)(f0, s1, t2, f3);

void
nci_vfstt( c_func, f0, s1, t2, t3 )
	SV* c_func
	float f0
	short s1
	char * t2
	char * t3
PREINIT:
	void(*func)(float, short, char *, char *);
CODE:
	func   = INT2PTR(void(*)(float, short, char *, char *), SvIV(c_func) );
	(*func)(f0, s1, t2, t3);

void
nci_vfsti( c_func, f0, s1, t2, i3 )
	SV* c_func
	float f0
	short s1
	char * t2
	int i3
PREINIT:
	void(*func)(float, short, char *, int);
CODE:
	func   = INT2PTR(void(*)(float, short, char *, int), SvIV(c_func) );
	(*func)(f0, s1, t2, i3);

void
nci_vfsip( c_func, f0, s1, i2, p3 )
	SV* c_func
	float f0
	short s1
	int i2
	void * p3
PREINIT:
	void(*func)(float, short, int, void *);
CODE:
	func   = INT2PTR(void(*)(float, short, int, void *), SvIV(c_func) );
	(*func)(f0, s1, i2, p3);

void
nci_vfsid( c_func, f0, s1, i2, d3 )
	SV* c_func
	float f0
	short s1
	int i2
	double d3
PREINIT:
	void(*func)(float, short, int, double);
CODE:
	func   = INT2PTR(void(*)(float, short, int, double), SvIV(c_func) );
	(*func)(f0, s1, i2, d3);

void
nci_vfsis( c_func, f0, s1, i2, s3 )
	SV* c_func
	float f0
	short s1
	int i2
	short s3
PREINIT:
	void(*func)(float, short, int, short);
CODE:
	func   = INT2PTR(void(*)(float, short, int, short), SvIV(c_func) );
	(*func)(f0, s1, i2, s3);

void
nci_vfsif( c_func, f0, s1, i2, f3 )
	SV* c_func
	float f0
	short s1
	int i2
	float f3
PREINIT:
	void(*func)(float, short, int, float);
CODE:
	func   = INT2PTR(void(*)(float, short, int, float), SvIV(c_func) );
	(*func)(f0, s1, i2, f3);

void
nci_vfsit( c_func, f0, s1, i2, t3 )
	SV* c_func
	float f0
	short s1
	int i2
	char * t3
PREINIT:
	void(*func)(float, short, int, char *);
CODE:
	func   = INT2PTR(void(*)(float, short, int, char *), SvIV(c_func) );
	(*func)(f0, s1, i2, t3);

void
nci_vfsii( c_func, f0, s1, i2, i3 )
	SV* c_func
	float f0
	short s1
	int i2
	int i3
PREINIT:
	void(*func)(float, short, int, int);
CODE:
	func   = INT2PTR(void(*)(float, short, int, int), SvIV(c_func) );
	(*func)(f0, s1, i2, i3);

void
nci_vffpp( c_func, f0, f1, p2, p3 )
	SV* c_func
	float f0
	float f1
	void * p2
	void * p3
PREINIT:
	void(*func)(float, float, void *, void *);
CODE:
	func   = INT2PTR(void(*)(float, float, void *, void *), SvIV(c_func) );
	(*func)(f0, f1, p2, p3);

void
nci_vffpd( c_func, f0, f1, p2, d3 )
	SV* c_func
	float f0
	float f1
	void * p2
	double d3
PREINIT:
	void(*func)(float, float, void *, double);
CODE:
	func   = INT2PTR(void(*)(float, float, void *, double), SvIV(c_func) );
	(*func)(f0, f1, p2, d3);

void
nci_vffps( c_func, f0, f1, p2, s3 )
	SV* c_func
	float f0
	float f1
	void * p2
	short s3
PREINIT:
	void(*func)(float, float, void *, short);
CODE:
	func   = INT2PTR(void(*)(float, float, void *, short), SvIV(c_func) );
	(*func)(f0, f1, p2, s3);

void
nci_vffpf( c_func, f0, f1, p2, f3 )
	SV* c_func
	float f0
	float f1
	void * p2
	float f3
PREINIT:
	void(*func)(float, float, void *, float);
CODE:
	func   = INT2PTR(void(*)(float, float, void *, float), SvIV(c_func) );
	(*func)(f0, f1, p2, f3);

void
nci_vffpt( c_func, f0, f1, p2, t3 )
	SV* c_func
	float f0
	float f1
	void * p2
	char * t3
PREINIT:
	void(*func)(float, float, void *, char *);
CODE:
	func   = INT2PTR(void(*)(float, float, void *, char *), SvIV(c_func) );
	(*func)(f0, f1, p2, t3);

void
nci_vffpi( c_func, f0, f1, p2, i3 )
	SV* c_func
	float f0
	float f1
	void * p2
	int i3
PREINIT:
	void(*func)(float, float, void *, int);
CODE:
	func   = INT2PTR(void(*)(float, float, void *, int), SvIV(c_func) );
	(*func)(f0, f1, p2, i3);

void
nci_vffdp( c_func, f0, f1, d2, p3 )
	SV* c_func
	float f0
	float f1
	double d2
	void * p3
PREINIT:
	void(*func)(float, float, double, void *);
CODE:
	func   = INT2PTR(void(*)(float, float, double, void *), SvIV(c_func) );
	(*func)(f0, f1, d2, p3);

void
nci_vffdd( c_func, f0, f1, d2, d3 )
	SV* c_func
	float f0
	float f1
	double d2
	double d3
PREINIT:
	void(*func)(float, float, double, double);
CODE:
	func   = INT2PTR(void(*)(float, float, double, double), SvIV(c_func) );
	(*func)(f0, f1, d2, d3);

void
nci_vffds( c_func, f0, f1, d2, s3 )
	SV* c_func
	float f0
	float f1
	double d2
	short s3
PREINIT:
	void(*func)(float, float, double, short);
CODE:
	func   = INT2PTR(void(*)(float, float, double, short), SvIV(c_func) );
	(*func)(f0, f1, d2, s3);

void
nci_vffdf( c_func, f0, f1, d2, f3 )
	SV* c_func
	float f0
	float f1
	double d2
	float f3
PREINIT:
	void(*func)(float, float, double, float);
CODE:
	func   = INT2PTR(void(*)(float, float, double, float), SvIV(c_func) );
	(*func)(f0, f1, d2, f3);

void
nci_vffdt( c_func, f0, f1, d2, t3 )
	SV* c_func
	float f0
	float f1
	double d2
	char * t3
PREINIT:
	void(*func)(float, float, double, char *);
CODE:
	func   = INT2PTR(void(*)(float, float, double, char *), SvIV(c_func) );
	(*func)(f0, f1, d2, t3);

void
nci_vffdi( c_func, f0, f1, d2, i3 )
	SV* c_func
	float f0
	float f1
	double d2
	int i3
PREINIT:
	void(*func)(float, float, double, int);
CODE:
	func   = INT2PTR(void(*)(float, float, double, int), SvIV(c_func) );
	(*func)(f0, f1, d2, i3);

void
nci_vffsp( c_func, f0, f1, s2, p3 )
	SV* c_func
	float f0
	float f1
	short s2
	void * p3
PREINIT:
	void(*func)(float, float, short, void *);
CODE:
	func   = INT2PTR(void(*)(float, float, short, void *), SvIV(c_func) );
	(*func)(f0, f1, s2, p3);

void
nci_vffsd( c_func, f0, f1, s2, d3 )
	SV* c_func
	float f0
	float f1
	short s2
	double d3
PREINIT:
	void(*func)(float, float, short, double);
CODE:
	func   = INT2PTR(void(*)(float, float, short, double), SvIV(c_func) );
	(*func)(f0, f1, s2, d3);

void
nci_vffss( c_func, f0, f1, s2, s3 )
	SV* c_func
	float f0
	float f1
	short s2
	short s3
PREINIT:
	void(*func)(float, float, short, short);
CODE:
	func   = INT2PTR(void(*)(float, float, short, short), SvIV(c_func) );
	(*func)(f0, f1, s2, s3);

void
nci_vffsf( c_func, f0, f1, s2, f3 )
	SV* c_func
	float f0
	float f1
	short s2
	float f3
PREINIT:
	void(*func)(float, float, short, float);
CODE:
	func   = INT2PTR(void(*)(float, float, short, float), SvIV(c_func) );
	(*func)(f0, f1, s2, f3);

void
nci_vffst( c_func, f0, f1, s2, t3 )
	SV* c_func
	float f0
	float f1
	short s2
	char * t3
PREINIT:
	void(*func)(float, float, short, char *);
CODE:
	func   = INT2PTR(void(*)(float, float, short, char *), SvIV(c_func) );
	(*func)(f0, f1, s2, t3);

void
nci_vffsi( c_func, f0, f1, s2, i3 )
	SV* c_func
	float f0
	float f1
	short s2
	int i3
PREINIT:
	void(*func)(float, float, short, int);
CODE:
	func   = INT2PTR(void(*)(float, float, short, int), SvIV(c_func) );
	(*func)(f0, f1, s2, i3);

void
nci_vfffp( c_func, f0, f1, f2, p3 )
	SV* c_func
	float f0
	float f1
	float f2
	void * p3
PREINIT:
	void(*func)(float, float, float, void *);
CODE:
	func   = INT2PTR(void(*)(float, float, float, void *), SvIV(c_func) );
	(*func)(f0, f1, f2, p3);

void
nci_vfffd( c_func, f0, f1, f2, d3 )
	SV* c_func
	float f0
	float f1
	float f2
	double d3
PREINIT:
	void(*func)(float, float, float, double);
CODE:
	func   = INT2PTR(void(*)(float, float, float, double), SvIV(c_func) );
	(*func)(f0, f1, f2, d3);

void
nci_vfffs( c_func, f0, f1, f2, s3 )
	SV* c_func
	float f0
	float f1
	float f2
	short s3
PREINIT:
	void(*func)(float, float, float, short);
CODE:
	func   = INT2PTR(void(*)(float, float, float, short), SvIV(c_func) );
	(*func)(f0, f1, f2, s3);

void
nci_vffff( c_func, f0, f1, f2, f3 )
	SV* c_func
	float f0
	float f1
	float f2
	float f3
PREINIT:
	void(*func)(float, float, float, float);
CODE:
	func   = INT2PTR(void(*)(float, float, float, float), SvIV(c_func) );
	(*func)(f0, f1, f2, f3);

void
nci_vffft( c_func, f0, f1, f2, t3 )
	SV* c_func
	float f0
	float f1
	float f2
	char * t3
PREINIT:
	void(*func)(float, float, float, char *);
CODE:
	func   = INT2PTR(void(*)(float, float, float, char *), SvIV(c_func) );
	(*func)(f0, f1, f2, t3);

void
nci_vfffi( c_func, f0, f1, f2, i3 )
	SV* c_func
	float f0
	float f1
	float f2
	int i3
PREINIT:
	void(*func)(float, float, float, int);
CODE:
	func   = INT2PTR(void(*)(float, float, float, int), SvIV(c_func) );
	(*func)(f0, f1, f2, i3);

void
nci_vfftp( c_func, f0, f1, t2, p3 )
	SV* c_func
	float f0
	float f1
	char * t2
	void * p3
PREINIT:
	void(*func)(float, float, char *, void *);
CODE:
	func   = INT2PTR(void(*)(float, float, char *, void *), SvIV(c_func) );
	(*func)(f0, f1, t2, p3);

void
nci_vfftd( c_func, f0, f1, t2, d3 )
	SV* c_func
	float f0
	float f1
	char * t2
	double d3
PREINIT:
	void(*func)(float, float, char *, double);
CODE:
	func   = INT2PTR(void(*)(float, float, char *, double), SvIV(c_func) );
	(*func)(f0, f1, t2, d3);

void
nci_vffts( c_func, f0, f1, t2, s3 )
	SV* c_func
	float f0
	float f1
	char * t2
	short s3
PREINIT:
	void(*func)(float, float, char *, short);
CODE:
	func   = INT2PTR(void(*)(float, float, char *, short), SvIV(c_func) );
	(*func)(f0, f1, t2, s3);

void
nci_vfftf( c_func, f0, f1, t2, f3 )
	SV* c_func
	float f0
	float f1
	char * t2
	float f3
PREINIT:
	void(*func)(float, float, char *, float);
CODE:
	func   = INT2PTR(void(*)(float, float, char *, float), SvIV(c_func) );
	(*func)(f0, f1, t2, f3);

void
nci_vfftt( c_func, f0, f1, t2, t3 )
	SV* c_func
	float f0
	float f1
	char * t2
	char * t3
PREINIT:
	void(*func)(float, float, char *, char *);
CODE:
	func   = INT2PTR(void(*)(float, float, char *, char *), SvIV(c_func) );
	(*func)(f0, f1, t2, t3);

void
nci_vffti( c_func, f0, f1, t2, i3 )
	SV* c_func
	float f0
	float f1
	char * t2
	int i3
PREINIT:
	void(*func)(float, float, char *, int);
CODE:
	func   = INT2PTR(void(*)(float, float, char *, int), SvIV(c_func) );
	(*func)(f0, f1, t2, i3);

void
nci_vffip( c_func, f0, f1, i2, p3 )
	SV* c_func
	float f0
	float f1
	int i2
	void * p3
PREINIT:
	void(*func)(float, float, int, void *);
CODE:
	func   = INT2PTR(void(*)(float, float, int, void *), SvIV(c_func) );
	(*func)(f0, f1, i2, p3);

void
nci_vffid( c_func, f0, f1, i2, d3 )
	SV* c_func
	float f0
	float f1
	int i2
	double d3
PREINIT:
	void(*func)(float, float, int, double);
CODE:
	func   = INT2PTR(void(*)(float, float, int, double), SvIV(c_func) );
	(*func)(f0, f1, i2, d3);

void
nci_vffis( c_func, f0, f1, i2, s3 )
	SV* c_func
	float f0
	float f1
	int i2
	short s3
PREINIT:
	void(*func)(float, float, int, short);
CODE:
	func   = INT2PTR(void(*)(float, float, int, short), SvIV(c_func) );
	(*func)(f0, f1, i2, s3);

void
nci_vffif( c_func, f0, f1, i2, f3 )
	SV* c_func
	float f0
	float f1
	int i2
	float f3
PREINIT:
	void(*func)(float, float, int, float);
CODE:
	func   = INT2PTR(void(*)(float, float, int, float), SvIV(c_func) );
	(*func)(f0, f1, i2, f3);

void
nci_vffit( c_func, f0, f1, i2, t3 )
	SV* c_func
	float f0
	float f1
	int i2
	char * t3
PREINIT:
	void(*func)(float, float, int, char *);
CODE:
	func   = INT2PTR(void(*)(float, float, int, char *), SvIV(c_func) );
	(*func)(f0, f1, i2, t3);

void
nci_vffii( c_func, f0, f1, i2, i3 )
	SV* c_func
	float f0
	float f1
	int i2
	int i3
PREINIT:
	void(*func)(float, float, int, int);
CODE:
	func   = INT2PTR(void(*)(float, float, int, int), SvIV(c_func) );
	(*func)(f0, f1, i2, i3);

void
nci_vftpp( c_func, f0, t1, p2, p3 )
	SV* c_func
	float f0
	char * t1
	void * p2
	void * p3
PREINIT:
	void(*func)(float, char *, void *, void *);
CODE:
	func   = INT2PTR(void(*)(float, char *, void *, void *), SvIV(c_func) );
	(*func)(f0, t1, p2, p3);

void
nci_vftpd( c_func, f0, t1, p2, d3 )
	SV* c_func
	float f0
	char * t1
	void * p2
	double d3
PREINIT:
	void(*func)(float, char *, void *, double);
CODE:
	func   = INT2PTR(void(*)(float, char *, void *, double), SvIV(c_func) );
	(*func)(f0, t1, p2, d3);

void
nci_vftps( c_func, f0, t1, p2, s3 )
	SV* c_func
	float f0
	char * t1
	void * p2
	short s3
PREINIT:
	void(*func)(float, char *, void *, short);
CODE:
	func   = INT2PTR(void(*)(float, char *, void *, short), SvIV(c_func) );
	(*func)(f0, t1, p2, s3);

void
nci_vftpf( c_func, f0, t1, p2, f3 )
	SV* c_func
	float f0
	char * t1
	void * p2
	float f3
PREINIT:
	void(*func)(float, char *, void *, float);
CODE:
	func   = INT2PTR(void(*)(float, char *, void *, float), SvIV(c_func) );
	(*func)(f0, t1, p2, f3);

void
nci_vftpt( c_func, f0, t1, p2, t3 )
	SV* c_func
	float f0
	char * t1
	void * p2
	char * t3
PREINIT:
	void(*func)(float, char *, void *, char *);
CODE:
	func   = INT2PTR(void(*)(float, char *, void *, char *), SvIV(c_func) );
	(*func)(f0, t1, p2, t3);

void
nci_vftpi( c_func, f0, t1, p2, i3 )
	SV* c_func
	float f0
	char * t1
	void * p2
	int i3
PREINIT:
	void(*func)(float, char *, void *, int);
CODE:
	func   = INT2PTR(void(*)(float, char *, void *, int), SvIV(c_func) );
	(*func)(f0, t1, p2, i3);

void
nci_vftdp( c_func, f0, t1, d2, p3 )
	SV* c_func
	float f0
	char * t1
	double d2
	void * p3
PREINIT:
	void(*func)(float, char *, double, void *);
CODE:
	func   = INT2PTR(void(*)(float, char *, double, void *), SvIV(c_func) );
	(*func)(f0, t1, d2, p3);

void
nci_vftdd( c_func, f0, t1, d2, d3 )
	SV* c_func
	float f0
	char * t1
	double d2
	double d3
PREINIT:
	void(*func)(float, char *, double, double);
CODE:
	func   = INT2PTR(void(*)(float, char *, double, double), SvIV(c_func) );
	(*func)(f0, t1, d2, d3);

void
nci_vftds( c_func, f0, t1, d2, s3 )
	SV* c_func
	float f0
	char * t1
	double d2
	short s3
PREINIT:
	void(*func)(float, char *, double, short);
CODE:
	func   = INT2PTR(void(*)(float, char *, double, short), SvIV(c_func) );
	(*func)(f0, t1, d2, s3);

void
nci_vftdf( c_func, f0, t1, d2, f3 )
	SV* c_func
	float f0
	char * t1
	double d2
	float f3
PREINIT:
	void(*func)(float, char *, double, float);
CODE:
	func   = INT2PTR(void(*)(float, char *, double, float), SvIV(c_func) );
	(*func)(f0, t1, d2, f3);

void
nci_vftdt( c_func, f0, t1, d2, t3 )
	SV* c_func
	float f0
	char * t1
	double d2
	char * t3
PREINIT:
	void(*func)(float, char *, double, char *);
CODE:
	func   = INT2PTR(void(*)(float, char *, double, char *), SvIV(c_func) );
	(*func)(f0, t1, d2, t3);

void
nci_vftdi( c_func, f0, t1, d2, i3 )
	SV* c_func
	float f0
	char * t1
	double d2
	int i3
PREINIT:
	void(*func)(float, char *, double, int);
CODE:
	func   = INT2PTR(void(*)(float, char *, double, int), SvIV(c_func) );
	(*func)(f0, t1, d2, i3);

void
nci_vftsp( c_func, f0, t1, s2, p3 )
	SV* c_func
	float f0
	char * t1
	short s2
	void * p3
PREINIT:
	void(*func)(float, char *, short, void *);
CODE:
	func   = INT2PTR(void(*)(float, char *, short, void *), SvIV(c_func) );
	(*func)(f0, t1, s2, p3);

void
nci_vftsd( c_func, f0, t1, s2, d3 )
	SV* c_func
	float f0
	char * t1
	short s2
	double d3
PREINIT:
	void(*func)(float, char *, short, double);
CODE:
	func   = INT2PTR(void(*)(float, char *, short, double), SvIV(c_func) );
	(*func)(f0, t1, s2, d3);

void
nci_vftss( c_func, f0, t1, s2, s3 )
	SV* c_func
	float f0
	char * t1
	short s2
	short s3
PREINIT:
	void(*func)(float, char *, short, short);
CODE:
	func   = INT2PTR(void(*)(float, char *, short, short), SvIV(c_func) );
	(*func)(f0, t1, s2, s3);

void
nci_vftsf( c_func, f0, t1, s2, f3 )
	SV* c_func
	float f0
	char * t1
	short s2
	float f3
PREINIT:
	void(*func)(float, char *, short, float);
CODE:
	func   = INT2PTR(void(*)(float, char *, short, float), SvIV(c_func) );
	(*func)(f0, t1, s2, f3);

void
nci_vftst( c_func, f0, t1, s2, t3 )
	SV* c_func
	float f0
	char * t1
	short s2
	char * t3
PREINIT:
	void(*func)(float, char *, short, char *);
CODE:
	func   = INT2PTR(void(*)(float, char *, short, char *), SvIV(c_func) );
	(*func)(f0, t1, s2, t3);

void
nci_vftsi( c_func, f0, t1, s2, i3 )
	SV* c_func
	float f0
	char * t1
	short s2
	int i3
PREINIT:
	void(*func)(float, char *, short, int);
CODE:
	func   = INT2PTR(void(*)(float, char *, short, int), SvIV(c_func) );
	(*func)(f0, t1, s2, i3);

void
nci_vftfp( c_func, f0, t1, f2, p3 )
	SV* c_func
	float f0
	char * t1
	float f2
	void * p3
PREINIT:
	void(*func)(float, char *, float, void *);
CODE:
	func   = INT2PTR(void(*)(float, char *, float, void *), SvIV(c_func) );
	(*func)(f0, t1, f2, p3);

void
nci_vftfd( c_func, f0, t1, f2, d3 )
	SV* c_func
	float f0
	char * t1
	float f2
	double d3
PREINIT:
	void(*func)(float, char *, float, double);
CODE:
	func   = INT2PTR(void(*)(float, char *, float, double), SvIV(c_func) );
	(*func)(f0, t1, f2, d3);

void
nci_vftfs( c_func, f0, t1, f2, s3 )
	SV* c_func
	float f0
	char * t1
	float f2
	short s3
PREINIT:
	void(*func)(float, char *, float, short);
CODE:
	func   = INT2PTR(void(*)(float, char *, float, short), SvIV(c_func) );
	(*func)(f0, t1, f2, s3);

void
nci_vftff( c_func, f0, t1, f2, f3 )
	SV* c_func
	float f0
	char * t1
	float f2
	float f3
PREINIT:
	void(*func)(float, char *, float, float);
CODE:
	func   = INT2PTR(void(*)(float, char *, float, float), SvIV(c_func) );
	(*func)(f0, t1, f2, f3);

void
nci_vftft( c_func, f0, t1, f2, t3 )
	SV* c_func
	float f0
	char * t1
	float f2
	char * t3
PREINIT:
	void(*func)(float, char *, float, char *);
CODE:
	func   = INT2PTR(void(*)(float, char *, float, char *), SvIV(c_func) );
	(*func)(f0, t1, f2, t3);

void
nci_vftfi( c_func, f0, t1, f2, i3 )
	SV* c_func
	float f0
	char * t1
	float f2
	int i3
PREINIT:
	void(*func)(float, char *, float, int);
CODE:
	func   = INT2PTR(void(*)(float, char *, float, int), SvIV(c_func) );
	(*func)(f0, t1, f2, i3);

void
nci_vfttp( c_func, f0, t1, t2, p3 )
	SV* c_func
	float f0
	char * t1
	char * t2
	void * p3
PREINIT:
	void(*func)(float, char *, char *, void *);
CODE:
	func   = INT2PTR(void(*)(float, char *, char *, void *), SvIV(c_func) );
	(*func)(f0, t1, t2, p3);

void
nci_vfttd( c_func, f0, t1, t2, d3 )
	SV* c_func
	float f0
	char * t1
	char * t2
	double d3
PREINIT:
	void(*func)(float, char *, char *, double);
CODE:
	func   = INT2PTR(void(*)(float, char *, char *, double), SvIV(c_func) );
	(*func)(f0, t1, t2, d3);

void
nci_vftts( c_func, f0, t1, t2, s3 )
	SV* c_func
	float f0
	char * t1
	char * t2
	short s3
PREINIT:
	void(*func)(float, char *, char *, short);
CODE:
	func   = INT2PTR(void(*)(float, char *, char *, short), SvIV(c_func) );
	(*func)(f0, t1, t2, s3);

void
nci_vfttf( c_func, f0, t1, t2, f3 )
	SV* c_func
	float f0
	char * t1
	char * t2
	float f3
PREINIT:
	void(*func)(float, char *, char *, float);
CODE:
	func   = INT2PTR(void(*)(float, char *, char *, float), SvIV(c_func) );
	(*func)(f0, t1, t2, f3);

void
nci_vfttt( c_func, f0, t1, t2, t3 )
	SV* c_func
	float f0
	char * t1
	char * t2
	char * t3
PREINIT:
	void(*func)(float, char *, char *, char *);
CODE:
	func   = INT2PTR(void(*)(float, char *, char *, char *), SvIV(c_func) );
	(*func)(f0, t1, t2, t3);

void
nci_vftti( c_func, f0, t1, t2, i3 )
	SV* c_func
	float f0
	char * t1
	char * t2
	int i3
PREINIT:
	void(*func)(float, char *, char *, int);
CODE:
	func   = INT2PTR(void(*)(float, char *, char *, int), SvIV(c_func) );
	(*func)(f0, t1, t2, i3);

void
nci_vftip( c_func, f0, t1, i2, p3 )
	SV* c_func
	float f0
	char * t1
	int i2
	void * p3
PREINIT:
	void(*func)(float, char *, int, void *);
CODE:
	func   = INT2PTR(void(*)(float, char *, int, void *), SvIV(c_func) );
	(*func)(f0, t1, i2, p3);

void
nci_vftid( c_func, f0, t1, i2, d3 )
	SV* c_func
	float f0
	char * t1
	int i2
	double d3
PREINIT:
	void(*func)(float, char *, int, double);
CODE:
	func   = INT2PTR(void(*)(float, char *, int, double), SvIV(c_func) );
	(*func)(f0, t1, i2, d3);

void
nci_vftis( c_func, f0, t1, i2, s3 )
	SV* c_func
	float f0
	char * t1
	int i2
	short s3
PREINIT:
	void(*func)(float, char *, int, short);
CODE:
	func   = INT2PTR(void(*)(float, char *, int, short), SvIV(c_func) );
	(*func)(f0, t1, i2, s3);

void
nci_vftif( c_func, f0, t1, i2, f3 )
	SV* c_func
	float f0
	char * t1
	int i2
	float f3
PREINIT:
	void(*func)(float, char *, int, float);
CODE:
	func   = INT2PTR(void(*)(float, char *, int, float), SvIV(c_func) );
	(*func)(f0, t1, i2, f3);

void
nci_vftit( c_func, f0, t1, i2, t3 )
	SV* c_func
	float f0
	char * t1
	int i2
	char * t3
PREINIT:
	void(*func)(float, char *, int, char *);
CODE:
	func   = INT2PTR(void(*)(float, char *, int, char *), SvIV(c_func) );
	(*func)(f0, t1, i2, t3);

void
nci_vftii( c_func, f0, t1, i2, i3 )
	SV* c_func
	float f0
	char * t1
	int i2
	int i3
PREINIT:
	void(*func)(float, char *, int, int);
CODE:
	func   = INT2PTR(void(*)(float, char *, int, int), SvIV(c_func) );
	(*func)(f0, t1, i2, i3);

void
nci_vfipp( c_func, f0, i1, p2, p3 )
	SV* c_func
	float f0
	int i1
	void * p2
	void * p3
PREINIT:
	void(*func)(float, int, void *, void *);
CODE:
	func   = INT2PTR(void(*)(float, int, void *, void *), SvIV(c_func) );
	(*func)(f0, i1, p2, p3);

void
nci_vfipd( c_func, f0, i1, p2, d3 )
	SV* c_func
	float f0
	int i1
	void * p2
	double d3
PREINIT:
	void(*func)(float, int, void *, double);
CODE:
	func   = INT2PTR(void(*)(float, int, void *, double), SvIV(c_func) );
	(*func)(f0, i1, p2, d3);

void
nci_vfips( c_func, f0, i1, p2, s3 )
	SV* c_func
	float f0
	int i1
	void * p2
	short s3
PREINIT:
	void(*func)(float, int, void *, short);
CODE:
	func   = INT2PTR(void(*)(float, int, void *, short), SvIV(c_func) );
	(*func)(f0, i1, p2, s3);

void
nci_vfipf( c_func, f0, i1, p2, f3 )
	SV* c_func
	float f0
	int i1
	void * p2
	float f3
PREINIT:
	void(*func)(float, int, void *, float);
CODE:
	func   = INT2PTR(void(*)(float, int, void *, float), SvIV(c_func) );
	(*func)(f0, i1, p2, f3);

void
nci_vfipt( c_func, f0, i1, p2, t3 )
	SV* c_func
	float f0
	int i1
	void * p2
	char * t3
PREINIT:
	void(*func)(float, int, void *, char *);
CODE:
	func   = INT2PTR(void(*)(float, int, void *, char *), SvIV(c_func) );
	(*func)(f0, i1, p2, t3);

void
nci_vfipi( c_func, f0, i1, p2, i3 )
	SV* c_func
	float f0
	int i1
	void * p2
	int i3
PREINIT:
	void(*func)(float, int, void *, int);
CODE:
	func   = INT2PTR(void(*)(float, int, void *, int), SvIV(c_func) );
	(*func)(f0, i1, p2, i3);

void
nci_vfidp( c_func, f0, i1, d2, p3 )
	SV* c_func
	float f0
	int i1
	double d2
	void * p3
PREINIT:
	void(*func)(float, int, double, void *);
CODE:
	func   = INT2PTR(void(*)(float, int, double, void *), SvIV(c_func) );
	(*func)(f0, i1, d2, p3);

void
nci_vfidd( c_func, f0, i1, d2, d3 )
	SV* c_func
	float f0
	int i1
	double d2
	double d3
PREINIT:
	void(*func)(float, int, double, double);
CODE:
	func   = INT2PTR(void(*)(float, int, double, double), SvIV(c_func) );
	(*func)(f0, i1, d2, d3);

void
nci_vfids( c_func, f0, i1, d2, s3 )
	SV* c_func
	float f0
	int i1
	double d2
	short s3
PREINIT:
	void(*func)(float, int, double, short);
CODE:
	func   = INT2PTR(void(*)(float, int, double, short), SvIV(c_func) );
	(*func)(f0, i1, d2, s3);

void
nci_vfidf( c_func, f0, i1, d2, f3 )
	SV* c_func
	float f0
	int i1
	double d2
	float f3
PREINIT:
	void(*func)(float, int, double, float);
CODE:
	func   = INT2PTR(void(*)(float, int, double, float), SvIV(c_func) );
	(*func)(f0, i1, d2, f3);

void
nci_vfidt( c_func, f0, i1, d2, t3 )
	SV* c_func
	float f0
	int i1
	double d2
	char * t3
PREINIT:
	void(*func)(float, int, double, char *);
CODE:
	func   = INT2PTR(void(*)(float, int, double, char *), SvIV(c_func) );
	(*func)(f0, i1, d2, t3);

void
nci_vfidi( c_func, f0, i1, d2, i3 )
	SV* c_func
	float f0
	int i1
	double d2
	int i3
PREINIT:
	void(*func)(float, int, double, int);
CODE:
	func   = INT2PTR(void(*)(float, int, double, int), SvIV(c_func) );
	(*func)(f0, i1, d2, i3);

void
nci_vfisp( c_func, f0, i1, s2, p3 )
	SV* c_func
	float f0
	int i1
	short s2
	void * p3
PREINIT:
	void(*func)(float, int, short, void *);
CODE:
	func   = INT2PTR(void(*)(float, int, short, void *), SvIV(c_func) );
	(*func)(f0, i1, s2, p3);

void
nci_vfisd( c_func, f0, i1, s2, d3 )
	SV* c_func
	float f0
	int i1
	short s2
	double d3
PREINIT:
	void(*func)(float, int, short, double);
CODE:
	func   = INT2PTR(void(*)(float, int, short, double), SvIV(c_func) );
	(*func)(f0, i1, s2, d3);

void
nci_vfiss( c_func, f0, i1, s2, s3 )
	SV* c_func
	float f0
	int i1
	short s2
	short s3
PREINIT:
	void(*func)(float, int, short, short);
CODE:
	func   = INT2PTR(void(*)(float, int, short, short), SvIV(c_func) );
	(*func)(f0, i1, s2, s3);

void
nci_vfisf( c_func, f0, i1, s2, f3 )
	SV* c_func
	float f0
	int i1
	short s2
	float f3
PREINIT:
	void(*func)(float, int, short, float);
CODE:
	func   = INT2PTR(void(*)(float, int, short, float), SvIV(c_func) );
	(*func)(f0, i1, s2, f3);

void
nci_vfist( c_func, f0, i1, s2, t3 )
	SV* c_func
	float f0
	int i1
	short s2
	char * t3
PREINIT:
	void(*func)(float, int, short, char *);
CODE:
	func   = INT2PTR(void(*)(float, int, short, char *), SvIV(c_func) );
	(*func)(f0, i1, s2, t3);

void
nci_vfisi( c_func, f0, i1, s2, i3 )
	SV* c_func
	float f0
	int i1
	short s2
	int i3
PREINIT:
	void(*func)(float, int, short, int);
CODE:
	func   = INT2PTR(void(*)(float, int, short, int), SvIV(c_func) );
	(*func)(f0, i1, s2, i3);

void
nci_vfifp( c_func, f0, i1, f2, p3 )
	SV* c_func
	float f0
	int i1
	float f2
	void * p3
PREINIT:
	void(*func)(float, int, float, void *);
CODE:
	func   = INT2PTR(void(*)(float, int, float, void *), SvIV(c_func) );
	(*func)(f0, i1, f2, p3);

void
nci_vfifd( c_func, f0, i1, f2, d3 )
	SV* c_func
	float f0
	int i1
	float f2
	double d3
PREINIT:
	void(*func)(float, int, float, double);
CODE:
	func   = INT2PTR(void(*)(float, int, float, double), SvIV(c_func) );
	(*func)(f0, i1, f2, d3);

void
nci_vfifs( c_func, f0, i1, f2, s3 )
	SV* c_func
	float f0
	int i1
	float f2
	short s3
PREINIT:
	void(*func)(float, int, float, short);
CODE:
	func   = INT2PTR(void(*)(float, int, float, short), SvIV(c_func) );
	(*func)(f0, i1, f2, s3);

void
nci_vfiff( c_func, f0, i1, f2, f3 )
	SV* c_func
	float f0
	int i1
	float f2
	float f3
PREINIT:
	void(*func)(float, int, float, float);
CODE:
	func   = INT2PTR(void(*)(float, int, float, float), SvIV(c_func) );
	(*func)(f0, i1, f2, f3);

void
nci_vfift( c_func, f0, i1, f2, t3 )
	SV* c_func
	float f0
	int i1
	float f2
	char * t3
PREINIT:
	void(*func)(float, int, float, char *);
CODE:
	func   = INT2PTR(void(*)(float, int, float, char *), SvIV(c_func) );
	(*func)(f0, i1, f2, t3);

void
nci_vfifi( c_func, f0, i1, f2, i3 )
	SV* c_func
	float f0
	int i1
	float f2
	int i3
PREINIT:
	void(*func)(float, int, float, int);
CODE:
	func   = INT2PTR(void(*)(float, int, float, int), SvIV(c_func) );
	(*func)(f0, i1, f2, i3);

void
nci_vfitp( c_func, f0, i1, t2, p3 )
	SV* c_func
	float f0
	int i1
	char * t2
	void * p3
PREINIT:
	void(*func)(float, int, char *, void *);
CODE:
	func   = INT2PTR(void(*)(float, int, char *, void *), SvIV(c_func) );
	(*func)(f0, i1, t2, p3);

void
nci_vfitd( c_func, f0, i1, t2, d3 )
	SV* c_func
	float f0
	int i1
	char * t2
	double d3
PREINIT:
	void(*func)(float, int, char *, double);
CODE:
	func   = INT2PTR(void(*)(float, int, char *, double), SvIV(c_func) );
	(*func)(f0, i1, t2, d3);

void
nci_vfits( c_func, f0, i1, t2, s3 )
	SV* c_func
	float f0
	int i1
	char * t2
	short s3
PREINIT:
	void(*func)(float, int, char *, short);
CODE:
	func   = INT2PTR(void(*)(float, int, char *, short), SvIV(c_func) );
	(*func)(f0, i1, t2, s3);

void
nci_vfitf( c_func, f0, i1, t2, f3 )
	SV* c_func
	float f0
	int i1
	char * t2
	float f3
PREINIT:
	void(*func)(float, int, char *, float);
CODE:
	func   = INT2PTR(void(*)(float, int, char *, float), SvIV(c_func) );
	(*func)(f0, i1, t2, f3);

void
nci_vfitt( c_func, f0, i1, t2, t3 )
	SV* c_func
	float f0
	int i1
	char * t2
	char * t3
PREINIT:
	void(*func)(float, int, char *, char *);
CODE:
	func   = INT2PTR(void(*)(float, int, char *, char *), SvIV(c_func) );
	(*func)(f0, i1, t2, t3);

void
nci_vfiti( c_func, f0, i1, t2, i3 )
	SV* c_func
	float f0
	int i1
	char * t2
	int i3
PREINIT:
	void(*func)(float, int, char *, int);
CODE:
	func   = INT2PTR(void(*)(float, int, char *, int), SvIV(c_func) );
	(*func)(f0, i1, t2, i3);

void
nci_vfiip( c_func, f0, i1, i2, p3 )
	SV* c_func
	float f0
	int i1
	int i2
	void * p3
PREINIT:
	void(*func)(float, int, int, void *);
CODE:
	func   = INT2PTR(void(*)(float, int, int, void *), SvIV(c_func) );
	(*func)(f0, i1, i2, p3);

void
nci_vfiid( c_func, f0, i1, i2, d3 )
	SV* c_func
	float f0
	int i1
	int i2
	double d3
PREINIT:
	void(*func)(float, int, int, double);
CODE:
	func   = INT2PTR(void(*)(float, int, int, double), SvIV(c_func) );
	(*func)(f0, i1, i2, d3);

void
nci_vfiis( c_func, f0, i1, i2, s3 )
	SV* c_func
	float f0
	int i1
	int i2
	short s3
PREINIT:
	void(*func)(float, int, int, short);
CODE:
	func   = INT2PTR(void(*)(float, int, int, short), SvIV(c_func) );
	(*func)(f0, i1, i2, s3);

void
nci_vfiif( c_func, f0, i1, i2, f3 )
	SV* c_func
	float f0
	int i1
	int i2
	float f3
PREINIT:
	void(*func)(float, int, int, float);
CODE:
	func   = INT2PTR(void(*)(float, int, int, float), SvIV(c_func) );
	(*func)(f0, i1, i2, f3);

void
nci_vfiit( c_func, f0, i1, i2, t3 )
	SV* c_func
	float f0
	int i1
	int i2
	char * t3
PREINIT:
	void(*func)(float, int, int, char *);
CODE:
	func   = INT2PTR(void(*)(float, int, int, char *), SvIV(c_func) );
	(*func)(f0, i1, i2, t3);

void
nci_vfiii( c_func, f0, i1, i2, i3 )
	SV* c_func
	float f0
	int i1
	int i2
	int i3
PREINIT:
	void(*func)(float, int, int, int);
CODE:
	func   = INT2PTR(void(*)(float, int, int, int), SvIV(c_func) );
	(*func)(f0, i1, i2, i3);

void
nci_vtppp( c_func, t0, p1, p2, p3 )
	SV* c_func
	char * t0
	void * p1
	void * p2
	void * p3
PREINIT:
	void(*func)(char *, void *, void *, void *);
CODE:
	func   = INT2PTR(void(*)(char *, void *, void *, void *), SvIV(c_func) );
	(*func)(t0, p1, p2, p3);

void
nci_vtppd( c_func, t0, p1, p2, d3 )
	SV* c_func
	char * t0
	void * p1
	void * p2
	double d3
PREINIT:
	void(*func)(char *, void *, void *, double);
CODE:
	func   = INT2PTR(void(*)(char *, void *, void *, double), SvIV(c_func) );
	(*func)(t0, p1, p2, d3);

void
nci_vtpps( c_func, t0, p1, p2, s3 )
	SV* c_func
	char * t0
	void * p1
	void * p2
	short s3
PREINIT:
	void(*func)(char *, void *, void *, short);
CODE:
	func   = INT2PTR(void(*)(char *, void *, void *, short), SvIV(c_func) );
	(*func)(t0, p1, p2, s3);

void
nci_vtppf( c_func, t0, p1, p2, f3 )
	SV* c_func
	char * t0
	void * p1
	void * p2
	float f3
PREINIT:
	void(*func)(char *, void *, void *, float);
CODE:
	func   = INT2PTR(void(*)(char *, void *, void *, float), SvIV(c_func) );
	(*func)(t0, p1, p2, f3);

void
nci_vtppt( c_func, t0, p1, p2, t3 )
	SV* c_func
	char * t0
	void * p1
	void * p2
	char * t3
PREINIT:
	void(*func)(char *, void *, void *, char *);
CODE:
	func   = INT2PTR(void(*)(char *, void *, void *, char *), SvIV(c_func) );
	(*func)(t0, p1, p2, t3);

void
nci_vtppi( c_func, t0, p1, p2, i3 )
	SV* c_func
	char * t0
	void * p1
	void * p2
	int i3
PREINIT:
	void(*func)(char *, void *, void *, int);
CODE:
	func   = INT2PTR(void(*)(char *, void *, void *, int), SvIV(c_func) );
	(*func)(t0, p1, p2, i3);

void
nci_vtpdp( c_func, t0, p1, d2, p3 )
	SV* c_func
	char * t0
	void * p1
	double d2
	void * p3
PREINIT:
	void(*func)(char *, void *, double, void *);
CODE:
	func   = INT2PTR(void(*)(char *, void *, double, void *), SvIV(c_func) );
	(*func)(t0, p1, d2, p3);

void
nci_vtpdd( c_func, t0, p1, d2, d3 )
	SV* c_func
	char * t0
	void * p1
	double d2
	double d3
PREINIT:
	void(*func)(char *, void *, double, double);
CODE:
	func   = INT2PTR(void(*)(char *, void *, double, double), SvIV(c_func) );
	(*func)(t0, p1, d2, d3);

void
nci_vtpds( c_func, t0, p1, d2, s3 )
	SV* c_func
	char * t0
	void * p1
	double d2
	short s3
PREINIT:
	void(*func)(char *, void *, double, short);
CODE:
	func   = INT2PTR(void(*)(char *, void *, double, short), SvIV(c_func) );
	(*func)(t0, p1, d2, s3);

void
nci_vtpdf( c_func, t0, p1, d2, f3 )
	SV* c_func
	char * t0
	void * p1
	double d2
	float f3
PREINIT:
	void(*func)(char *, void *, double, float);
CODE:
	func   = INT2PTR(void(*)(char *, void *, double, float), SvIV(c_func) );
	(*func)(t0, p1, d2, f3);

void
nci_vtpdt( c_func, t0, p1, d2, t3 )
	SV* c_func
	char * t0
	void * p1
	double d2
	char * t3
PREINIT:
	void(*func)(char *, void *, double, char *);
CODE:
	func   = INT2PTR(void(*)(char *, void *, double, char *), SvIV(c_func) );
	(*func)(t0, p1, d2, t3);

void
nci_vtpdi( c_func, t0, p1, d2, i3 )
	SV* c_func
	char * t0
	void * p1
	double d2
	int i3
PREINIT:
	void(*func)(char *, void *, double, int);
CODE:
	func   = INT2PTR(void(*)(char *, void *, double, int), SvIV(c_func) );
	(*func)(t0, p1, d2, i3);

void
nci_vtpsp( c_func, t0, p1, s2, p3 )
	SV* c_func
	char * t0
	void * p1
	short s2
	void * p3
PREINIT:
	void(*func)(char *, void *, short, void *);
CODE:
	func   = INT2PTR(void(*)(char *, void *, short, void *), SvIV(c_func) );
	(*func)(t0, p1, s2, p3);

void
nci_vtpsd( c_func, t0, p1, s2, d3 )
	SV* c_func
	char * t0
	void * p1
	short s2
	double d3
PREINIT:
	void(*func)(char *, void *, short, double);
CODE:
	func   = INT2PTR(void(*)(char *, void *, short, double), SvIV(c_func) );
	(*func)(t0, p1, s2, d3);

void
nci_vtpss( c_func, t0, p1, s2, s3 )
	SV* c_func
	char * t0
	void * p1
	short s2
	short s3
PREINIT:
	void(*func)(char *, void *, short, short);
CODE:
	func   = INT2PTR(void(*)(char *, void *, short, short), SvIV(c_func) );
	(*func)(t0, p1, s2, s3);

void
nci_vtpsf( c_func, t0, p1, s2, f3 )
	SV* c_func
	char * t0
	void * p1
	short s2
	float f3
PREINIT:
	void(*func)(char *, void *, short, float);
CODE:
	func   = INT2PTR(void(*)(char *, void *, short, float), SvIV(c_func) );
	(*func)(t0, p1, s2, f3);

void
nci_vtpst( c_func, t0, p1, s2, t3 )
	SV* c_func
	char * t0
	void * p1
	short s2
	char * t3
PREINIT:
	void(*func)(char *, void *, short, char *);
CODE:
	func   = INT2PTR(void(*)(char *, void *, short, char *), SvIV(c_func) );
	(*func)(t0, p1, s2, t3);

void
nci_vtpsi( c_func, t0, p1, s2, i3 )
	SV* c_func
	char * t0
	void * p1
	short s2
	int i3
PREINIT:
	void(*func)(char *, void *, short, int);
CODE:
	func   = INT2PTR(void(*)(char *, void *, short, int), SvIV(c_func) );
	(*func)(t0, p1, s2, i3);

void
nci_vtpfp( c_func, t0, p1, f2, p3 )
	SV* c_func
	char * t0
	void * p1
	float f2
	void * p3
PREINIT:
	void(*func)(char *, void *, float, void *);
CODE:
	func   = INT2PTR(void(*)(char *, void *, float, void *), SvIV(c_func) );
	(*func)(t0, p1, f2, p3);

void
nci_vtpfd( c_func, t0, p1, f2, d3 )
	SV* c_func
	char * t0
	void * p1
	float f2
	double d3
PREINIT:
	void(*func)(char *, void *, float, double);
CODE:
	func   = INT2PTR(void(*)(char *, void *, float, double), SvIV(c_func) );
	(*func)(t0, p1, f2, d3);

void
nci_vtpfs( c_func, t0, p1, f2, s3 )
	SV* c_func
	char * t0
	void * p1
	float f2
	short s3
PREINIT:
	void(*func)(char *, void *, float, short);
CODE:
	func   = INT2PTR(void(*)(char *, void *, float, short), SvIV(c_func) );
	(*func)(t0, p1, f2, s3);

void
nci_vtpff( c_func, t0, p1, f2, f3 )
	SV* c_func
	char * t0
	void * p1
	float f2
	float f3
PREINIT:
	void(*func)(char *, void *, float, float);
CODE:
	func   = INT2PTR(void(*)(char *, void *, float, float), SvIV(c_func) );
	(*func)(t0, p1, f2, f3);

void
nci_vtpft( c_func, t0, p1, f2, t3 )
	SV* c_func
	char * t0
	void * p1
	float f2
	char * t3
PREINIT:
	void(*func)(char *, void *, float, char *);
CODE:
	func   = INT2PTR(void(*)(char *, void *, float, char *), SvIV(c_func) );
	(*func)(t0, p1, f2, t3);

void
nci_vtpfi( c_func, t0, p1, f2, i3 )
	SV* c_func
	char * t0
	void * p1
	float f2
	int i3
PREINIT:
	void(*func)(char *, void *, float, int);
CODE:
	func   = INT2PTR(void(*)(char *, void *, float, int), SvIV(c_func) );
	(*func)(t0, p1, f2, i3);

void
nci_vtptp( c_func, t0, p1, t2, p3 )
	SV* c_func
	char * t0
	void * p1
	char * t2
	void * p3
PREINIT:
	void(*func)(char *, void *, char *, void *);
CODE:
	func   = INT2PTR(void(*)(char *, void *, char *, void *), SvIV(c_func) );
	(*func)(t0, p1, t2, p3);

void
nci_vtptd( c_func, t0, p1, t2, d3 )
	SV* c_func
	char * t0
	void * p1
	char * t2
	double d3
PREINIT:
	void(*func)(char *, void *, char *, double);
CODE:
	func   = INT2PTR(void(*)(char *, void *, char *, double), SvIV(c_func) );
	(*func)(t0, p1, t2, d3);

void
nci_vtpts( c_func, t0, p1, t2, s3 )
	SV* c_func
	char * t0
	void * p1
	char * t2
	short s3
PREINIT:
	void(*func)(char *, void *, char *, short);
CODE:
	func   = INT2PTR(void(*)(char *, void *, char *, short), SvIV(c_func) );
	(*func)(t0, p1, t2, s3);

void
nci_vtptf( c_func, t0, p1, t2, f3 )
	SV* c_func
	char * t0
	void * p1
	char * t2
	float f3
PREINIT:
	void(*func)(char *, void *, char *, float);
CODE:
	func   = INT2PTR(void(*)(char *, void *, char *, float), SvIV(c_func) );
	(*func)(t0, p1, t2, f3);

void
nci_vtptt( c_func, t0, p1, t2, t3 )
	SV* c_func
	char * t0
	void * p1
	char * t2
	char * t3
PREINIT:
	void(*func)(char *, void *, char *, char *);
CODE:
	func   = INT2PTR(void(*)(char *, void *, char *, char *), SvIV(c_func) );
	(*func)(t0, p1, t2, t3);

void
nci_vtpti( c_func, t0, p1, t2, i3 )
	SV* c_func
	char * t0
	void * p1
	char * t2
	int i3
PREINIT:
	void(*func)(char *, void *, char *, int);
CODE:
	func   = INT2PTR(void(*)(char *, void *, char *, int), SvIV(c_func) );
	(*func)(t0, p1, t2, i3);

void
nci_vtpip( c_func, t0, p1, i2, p3 )
	SV* c_func
	char * t0
	void * p1
	int i2
	void * p3
PREINIT:
	void(*func)(char *, void *, int, void *);
CODE:
	func   = INT2PTR(void(*)(char *, void *, int, void *), SvIV(c_func) );
	(*func)(t0, p1, i2, p3);

void
nci_vtpid( c_func, t0, p1, i2, d3 )
	SV* c_func
	char * t0
	void * p1
	int i2
	double d3
PREINIT:
	void(*func)(char *, void *, int, double);
CODE:
	func   = INT2PTR(void(*)(char *, void *, int, double), SvIV(c_func) );
	(*func)(t0, p1, i2, d3);

void
nci_vtpis( c_func, t0, p1, i2, s3 )
	SV* c_func
	char * t0
	void * p1
	int i2
	short s3
PREINIT:
	void(*func)(char *, void *, int, short);
CODE:
	func   = INT2PTR(void(*)(char *, void *, int, short), SvIV(c_func) );
	(*func)(t0, p1, i2, s3);

void
nci_vtpif( c_func, t0, p1, i2, f3 )
	SV* c_func
	char * t0
	void * p1
	int i2
	float f3
PREINIT:
	void(*func)(char *, void *, int, float);
CODE:
	func   = INT2PTR(void(*)(char *, void *, int, float), SvIV(c_func) );
	(*func)(t0, p1, i2, f3);

void
nci_vtpit( c_func, t0, p1, i2, t3 )
	SV* c_func
	char * t0
	void * p1
	int i2
	char * t3
PREINIT:
	void(*func)(char *, void *, int, char *);
CODE:
	func   = INT2PTR(void(*)(char *, void *, int, char *), SvIV(c_func) );
	(*func)(t0, p1, i2, t3);

void
nci_vtpii( c_func, t0, p1, i2, i3 )
	SV* c_func
	char * t0
	void * p1
	int i2
	int i3
PREINIT:
	void(*func)(char *, void *, int, int);
CODE:
	func   = INT2PTR(void(*)(char *, void *, int, int), SvIV(c_func) );
	(*func)(t0, p1, i2, i3);

void
nci_vtdpp( c_func, t0, d1, p2, p3 )
	SV* c_func
	char * t0
	double d1
	void * p2
	void * p3
PREINIT:
	void(*func)(char *, double, void *, void *);
CODE:
	func   = INT2PTR(void(*)(char *, double, void *, void *), SvIV(c_func) );
	(*func)(t0, d1, p2, p3);

void
nci_vtdpd( c_func, t0, d1, p2, d3 )
	SV* c_func
	char * t0
	double d1
	void * p2
	double d3
PREINIT:
	void(*func)(char *, double, void *, double);
CODE:
	func   = INT2PTR(void(*)(char *, double, void *, double), SvIV(c_func) );
	(*func)(t0, d1, p2, d3);

void
nci_vtdps( c_func, t0, d1, p2, s3 )
	SV* c_func
	char * t0
	double d1
	void * p2
	short s3
PREINIT:
	void(*func)(char *, double, void *, short);
CODE:
	func   = INT2PTR(void(*)(char *, double, void *, short), SvIV(c_func) );
	(*func)(t0, d1, p2, s3);

void
nci_vtdpf( c_func, t0, d1, p2, f3 )
	SV* c_func
	char * t0
	double d1
	void * p2
	float f3
PREINIT:
	void(*func)(char *, double, void *, float);
CODE:
	func   = INT2PTR(void(*)(char *, double, void *, float), SvIV(c_func) );
	(*func)(t0, d1, p2, f3);

void
nci_vtdpt( c_func, t0, d1, p2, t3 )
	SV* c_func
	char * t0
	double d1
	void * p2
	char * t3
PREINIT:
	void(*func)(char *, double, void *, char *);
CODE:
	func   = INT2PTR(void(*)(char *, double, void *, char *), SvIV(c_func) );
	(*func)(t0, d1, p2, t3);

void
nci_vtdpi( c_func, t0, d1, p2, i3 )
	SV* c_func
	char * t0
	double d1
	void * p2
	int i3
PREINIT:
	void(*func)(char *, double, void *, int);
CODE:
	func   = INT2PTR(void(*)(char *, double, void *, int), SvIV(c_func) );
	(*func)(t0, d1, p2, i3);

void
nci_vtddp( c_func, t0, d1, d2, p3 )
	SV* c_func
	char * t0
	double d1
	double d2
	void * p3
PREINIT:
	void(*func)(char *, double, double, void *);
CODE:
	func   = INT2PTR(void(*)(char *, double, double, void *), SvIV(c_func) );
	(*func)(t0, d1, d2, p3);

void
nci_vtddd( c_func, t0, d1, d2, d3 )
	SV* c_func
	char * t0
	double d1
	double d2
	double d3
PREINIT:
	void(*func)(char *, double, double, double);
CODE:
	func   = INT2PTR(void(*)(char *, double, double, double), SvIV(c_func) );
	(*func)(t0, d1, d2, d3);

void
nci_vtdds( c_func, t0, d1, d2, s3 )
	SV* c_func
	char * t0
	double d1
	double d2
	short s3
PREINIT:
	void(*func)(char *, double, double, short);
CODE:
	func   = INT2PTR(void(*)(char *, double, double, short), SvIV(c_func) );
	(*func)(t0, d1, d2, s3);

void
nci_vtddf( c_func, t0, d1, d2, f3 )
	SV* c_func
	char * t0
	double d1
	double d2
	float f3
PREINIT:
	void(*func)(char *, double, double, float);
CODE:
	func   = INT2PTR(void(*)(char *, double, double, float), SvIV(c_func) );
	(*func)(t0, d1, d2, f3);

void
nci_vtddt( c_func, t0, d1, d2, t3 )
	SV* c_func
	char * t0
	double d1
	double d2
	char * t3
PREINIT:
	void(*func)(char *, double, double, char *);
CODE:
	func   = INT2PTR(void(*)(char *, double, double, char *), SvIV(c_func) );
	(*func)(t0, d1, d2, t3);

void
nci_vtddi( c_func, t0, d1, d2, i3 )
	SV* c_func
	char * t0
	double d1
	double d2
	int i3
PREINIT:
	void(*func)(char *, double, double, int);
CODE:
	func   = INT2PTR(void(*)(char *, double, double, int), SvIV(c_func) );
	(*func)(t0, d1, d2, i3);

void
nci_vtdsp( c_func, t0, d1, s2, p3 )
	SV* c_func
	char * t0
	double d1
	short s2
	void * p3
PREINIT:
	void(*func)(char *, double, short, void *);
CODE:
	func   = INT2PTR(void(*)(char *, double, short, void *), SvIV(c_func) );
	(*func)(t0, d1, s2, p3);

void
nci_vtdsd( c_func, t0, d1, s2, d3 )
	SV* c_func
	char * t0
	double d1
	short s2
	double d3
PREINIT:
	void(*func)(char *, double, short, double);
CODE:
	func   = INT2PTR(void(*)(char *, double, short, double), SvIV(c_func) );
	(*func)(t0, d1, s2, d3);

void
nci_vtdss( c_func, t0, d1, s2, s3 )
	SV* c_func
	char * t0
	double d1
	short s2
	short s3
PREINIT:
	void(*func)(char *, double, short, short);
CODE:
	func   = INT2PTR(void(*)(char *, double, short, short), SvIV(c_func) );
	(*func)(t0, d1, s2, s3);

void
nci_vtdsf( c_func, t0, d1, s2, f3 )
	SV* c_func
	char * t0
	double d1
	short s2
	float f3
PREINIT:
	void(*func)(char *, double, short, float);
CODE:
	func   = INT2PTR(void(*)(char *, double, short, float), SvIV(c_func) );
	(*func)(t0, d1, s2, f3);

void
nci_vtdst( c_func, t0, d1, s2, t3 )
	SV* c_func
	char * t0
	double d1
	short s2
	char * t3
PREINIT:
	void(*func)(char *, double, short, char *);
CODE:
	func   = INT2PTR(void(*)(char *, double, short, char *), SvIV(c_func) );
	(*func)(t0, d1, s2, t3);

void
nci_vtdsi( c_func, t0, d1, s2, i3 )
	SV* c_func
	char * t0
	double d1
	short s2
	int i3
PREINIT:
	void(*func)(char *, double, short, int);
CODE:
	func   = INT2PTR(void(*)(char *, double, short, int), SvIV(c_func) );
	(*func)(t0, d1, s2, i3);

void
nci_vtdfp( c_func, t0, d1, f2, p3 )
	SV* c_func
	char * t0
	double d1
	float f2
	void * p3
PREINIT:
	void(*func)(char *, double, float, void *);
CODE:
	func   = INT2PTR(void(*)(char *, double, float, void *), SvIV(c_func) );
	(*func)(t0, d1, f2, p3);

void
nci_vtdfd( c_func, t0, d1, f2, d3 )
	SV* c_func
	char * t0
	double d1
	float f2
	double d3
PREINIT:
	void(*func)(char *, double, float, double);
CODE:
	func   = INT2PTR(void(*)(char *, double, float, double), SvIV(c_func) );
	(*func)(t0, d1, f2, d3);

void
nci_vtdfs( c_func, t0, d1, f2, s3 )
	SV* c_func
	char * t0
	double d1
	float f2
	short s3
PREINIT:
	void(*func)(char *, double, float, short);
CODE:
	func   = INT2PTR(void(*)(char *, double, float, short), SvIV(c_func) );
	(*func)(t0, d1, f2, s3);

void
nci_vtdff( c_func, t0, d1, f2, f3 )
	SV* c_func
	char * t0
	double d1
	float f2
	float f3
PREINIT:
	void(*func)(char *, double, float, float);
CODE:
	func   = INT2PTR(void(*)(char *, double, float, float), SvIV(c_func) );
	(*func)(t0, d1, f2, f3);

void
nci_vtdft( c_func, t0, d1, f2, t3 )
	SV* c_func
	char * t0
	double d1
	float f2
	char * t3
PREINIT:
	void(*func)(char *, double, float, char *);
CODE:
	func   = INT2PTR(void(*)(char *, double, float, char *), SvIV(c_func) );
	(*func)(t0, d1, f2, t3);

void
nci_vtdfi( c_func, t0, d1, f2, i3 )
	SV* c_func
	char * t0
	double d1
	float f2
	int i3
PREINIT:
	void(*func)(char *, double, float, int);
CODE:
	func   = INT2PTR(void(*)(char *, double, float, int), SvIV(c_func) );
	(*func)(t0, d1, f2, i3);

void
nci_vtdtp( c_func, t0, d1, t2, p3 )
	SV* c_func
	char * t0
	double d1
	char * t2
	void * p3
PREINIT:
	void(*func)(char *, double, char *, void *);
CODE:
	func   = INT2PTR(void(*)(char *, double, char *, void *), SvIV(c_func) );
	(*func)(t0, d1, t2, p3);

void
nci_vtdtd( c_func, t0, d1, t2, d3 )
	SV* c_func
	char * t0
	double d1
	char * t2
	double d3
PREINIT:
	void(*func)(char *, double, char *, double);
CODE:
	func   = INT2PTR(void(*)(char *, double, char *, double), SvIV(c_func) );
	(*func)(t0, d1, t2, d3);

void
nci_vtdts( c_func, t0, d1, t2, s3 )
	SV* c_func
	char * t0
	double d1
	char * t2
	short s3
PREINIT:
	void(*func)(char *, double, char *, short);
CODE:
	func   = INT2PTR(void(*)(char *, double, char *, short), SvIV(c_func) );
	(*func)(t0, d1, t2, s3);

void
nci_vtdtf( c_func, t0, d1, t2, f3 )
	SV* c_func
	char * t0
	double d1
	char * t2
	float f3
PREINIT:
	void(*func)(char *, double, char *, float);
CODE:
	func   = INT2PTR(void(*)(char *, double, char *, float), SvIV(c_func) );
	(*func)(t0, d1, t2, f3);

void
nci_vtdtt( c_func, t0, d1, t2, t3 )
	SV* c_func
	char * t0
	double d1
	char * t2
	char * t3
PREINIT:
	void(*func)(char *, double, char *, char *);
CODE:
	func   = INT2PTR(void(*)(char *, double, char *, char *), SvIV(c_func) );
	(*func)(t0, d1, t2, t3);

void
nci_vtdti( c_func, t0, d1, t2, i3 )
	SV* c_func
	char * t0
	double d1
	char * t2
	int i3
PREINIT:
	void(*func)(char *, double, char *, int);
CODE:
	func   = INT2PTR(void(*)(char *, double, char *, int), SvIV(c_func) );
	(*func)(t0, d1, t2, i3);

void
nci_vtdip( c_func, t0, d1, i2, p3 )
	SV* c_func
	char * t0
	double d1
	int i2
	void * p3
PREINIT:
	void(*func)(char *, double, int, void *);
CODE:
	func   = INT2PTR(void(*)(char *, double, int, void *), SvIV(c_func) );
	(*func)(t0, d1, i2, p3);

void
nci_vtdid( c_func, t0, d1, i2, d3 )
	SV* c_func
	char * t0
	double d1
	int i2
	double d3
PREINIT:
	void(*func)(char *, double, int, double);
CODE:
	func   = INT2PTR(void(*)(char *, double, int, double), SvIV(c_func) );
	(*func)(t0, d1, i2, d3);

void
nci_vtdis( c_func, t0, d1, i2, s3 )
	SV* c_func
	char * t0
	double d1
	int i2
	short s3
PREINIT:
	void(*func)(char *, double, int, short);
CODE:
	func   = INT2PTR(void(*)(char *, double, int, short), SvIV(c_func) );
	(*func)(t0, d1, i2, s3);

void
nci_vtdif( c_func, t0, d1, i2, f3 )
	SV* c_func
	char * t0
	double d1
	int i2
	float f3
PREINIT:
	void(*func)(char *, double, int, float);
CODE:
	func   = INT2PTR(void(*)(char *, double, int, float), SvIV(c_func) );
	(*func)(t0, d1, i2, f3);

void
nci_vtdit( c_func, t0, d1, i2, t3 )
	SV* c_func
	char * t0
	double d1
	int i2
	char * t3
PREINIT:
	void(*func)(char *, double, int, char *);
CODE:
	func   = INT2PTR(void(*)(char *, double, int, char *), SvIV(c_func) );
	(*func)(t0, d1, i2, t3);

void
nci_vtdii( c_func, t0, d1, i2, i3 )
	SV* c_func
	char * t0
	double d1
	int i2
	int i3
PREINIT:
	void(*func)(char *, double, int, int);
CODE:
	func   = INT2PTR(void(*)(char *, double, int, int), SvIV(c_func) );
	(*func)(t0, d1, i2, i3);

void
nci_vtspp( c_func, t0, s1, p2, p3 )
	SV* c_func
	char * t0
	short s1
	void * p2
	void * p3
PREINIT:
	void(*func)(char *, short, void *, void *);
CODE:
	func   = INT2PTR(void(*)(char *, short, void *, void *), SvIV(c_func) );
	(*func)(t0, s1, p2, p3);

void
nci_vtspd( c_func, t0, s1, p2, d3 )
	SV* c_func
	char * t0
	short s1
	void * p2
	double d3
PREINIT:
	void(*func)(char *, short, void *, double);
CODE:
	func   = INT2PTR(void(*)(char *, short, void *, double), SvIV(c_func) );
	(*func)(t0, s1, p2, d3);

void
nci_vtsps( c_func, t0, s1, p2, s3 )
	SV* c_func
	char * t0
	short s1
	void * p2
	short s3
PREINIT:
	void(*func)(char *, short, void *, short);
CODE:
	func   = INT2PTR(void(*)(char *, short, void *, short), SvIV(c_func) );
	(*func)(t0, s1, p2, s3);

void
nci_vtspf( c_func, t0, s1, p2, f3 )
	SV* c_func
	char * t0
	short s1
	void * p2
	float f3
PREINIT:
	void(*func)(char *, short, void *, float);
CODE:
	func   = INT2PTR(void(*)(char *, short, void *, float), SvIV(c_func) );
	(*func)(t0, s1, p2, f3);

void
nci_vtspt( c_func, t0, s1, p2, t3 )
	SV* c_func
	char * t0
	short s1
	void * p2
	char * t3
PREINIT:
	void(*func)(char *, short, void *, char *);
CODE:
	func   = INT2PTR(void(*)(char *, short, void *, char *), SvIV(c_func) );
	(*func)(t0, s1, p2, t3);

void
nci_vtspi( c_func, t0, s1, p2, i3 )
	SV* c_func
	char * t0
	short s1
	void * p2
	int i3
PREINIT:
	void(*func)(char *, short, void *, int);
CODE:
	func   = INT2PTR(void(*)(char *, short, void *, int), SvIV(c_func) );
	(*func)(t0, s1, p2, i3);

void
nci_vtsdp( c_func, t0, s1, d2, p3 )
	SV* c_func
	char * t0
	short s1
	double d2
	void * p3
PREINIT:
	void(*func)(char *, short, double, void *);
CODE:
	func   = INT2PTR(void(*)(char *, short, double, void *), SvIV(c_func) );
	(*func)(t0, s1, d2, p3);

void
nci_vtsdd( c_func, t0, s1, d2, d3 )
	SV* c_func
	char * t0
	short s1
	double d2
	double d3
PREINIT:
	void(*func)(char *, short, double, double);
CODE:
	func   = INT2PTR(void(*)(char *, short, double, double), SvIV(c_func) );
	(*func)(t0, s1, d2, d3);

void
nci_vtsds( c_func, t0, s1, d2, s3 )
	SV* c_func
	char * t0
	short s1
	double d2
	short s3
PREINIT:
	void(*func)(char *, short, double, short);
CODE:
	func   = INT2PTR(void(*)(char *, short, double, short), SvIV(c_func) );
	(*func)(t0, s1, d2, s3);

void
nci_vtsdf( c_func, t0, s1, d2, f3 )
	SV* c_func
	char * t0
	short s1
	double d2
	float f3
PREINIT:
	void(*func)(char *, short, double, float);
CODE:
	func   = INT2PTR(void(*)(char *, short, double, float), SvIV(c_func) );
	(*func)(t0, s1, d2, f3);

void
nci_vtsdt( c_func, t0, s1, d2, t3 )
	SV* c_func
	char * t0
	short s1
	double d2
	char * t3
PREINIT:
	void(*func)(char *, short, double, char *);
CODE:
	func   = INT2PTR(void(*)(char *, short, double, char *), SvIV(c_func) );
	(*func)(t0, s1, d2, t3);

void
nci_vtsdi( c_func, t0, s1, d2, i3 )
	SV* c_func
	char * t0
	short s1
	double d2
	int i3
PREINIT:
	void(*func)(char *, short, double, int);
CODE:
	func   = INT2PTR(void(*)(char *, short, double, int), SvIV(c_func) );
	(*func)(t0, s1, d2, i3);

void
nci_vtssp( c_func, t0, s1, s2, p3 )
	SV* c_func
	char * t0
	short s1
	short s2
	void * p3
PREINIT:
	void(*func)(char *, short, short, void *);
CODE:
	func   = INT2PTR(void(*)(char *, short, short, void *), SvIV(c_func) );
	(*func)(t0, s1, s2, p3);

void
nci_vtssd( c_func, t0, s1, s2, d3 )
	SV* c_func
	char * t0
	short s1
	short s2
	double d3
PREINIT:
	void(*func)(char *, short, short, double);
CODE:
	func   = INT2PTR(void(*)(char *, short, short, double), SvIV(c_func) );
	(*func)(t0, s1, s2, d3);

void
nci_vtsss( c_func, t0, s1, s2, s3 )
	SV* c_func
	char * t0
	short s1
	short s2
	short s3
PREINIT:
	void(*func)(char *, short, short, short);
CODE:
	func   = INT2PTR(void(*)(char *, short, short, short), SvIV(c_func) );
	(*func)(t0, s1, s2, s3);

void
nci_vtssf( c_func, t0, s1, s2, f3 )
	SV* c_func
	char * t0
	short s1
	short s2
	float f3
PREINIT:
	void(*func)(char *, short, short, float);
CODE:
	func   = INT2PTR(void(*)(char *, short, short, float), SvIV(c_func) );
	(*func)(t0, s1, s2, f3);

void
nci_vtsst( c_func, t0, s1, s2, t3 )
	SV* c_func
	char * t0
	short s1
	short s2
	char * t3
PREINIT:
	void(*func)(char *, short, short, char *);
CODE:
	func   = INT2PTR(void(*)(char *, short, short, char *), SvIV(c_func) );
	(*func)(t0, s1, s2, t3);

void
nci_vtssi( c_func, t0, s1, s2, i3 )
	SV* c_func
	char * t0
	short s1
	short s2
	int i3
PREINIT:
	void(*func)(char *, short, short, int);
CODE:
	func   = INT2PTR(void(*)(char *, short, short, int), SvIV(c_func) );
	(*func)(t0, s1, s2, i3);

void
nci_vtsfp( c_func, t0, s1, f2, p3 )
	SV* c_func
	char * t0
	short s1
	float f2
	void * p3
PREINIT:
	void(*func)(char *, short, float, void *);
CODE:
	func   = INT2PTR(void(*)(char *, short, float, void *), SvIV(c_func) );
	(*func)(t0, s1, f2, p3);

void
nci_vtsfd( c_func, t0, s1, f2, d3 )
	SV* c_func
	char * t0
	short s1
	float f2
	double d3
PREINIT:
	void(*func)(char *, short, float, double);
CODE:
	func   = INT2PTR(void(*)(char *, short, float, double), SvIV(c_func) );
	(*func)(t0, s1, f2, d3);

void
nci_vtsfs( c_func, t0, s1, f2, s3 )
	SV* c_func
	char * t0
	short s1
	float f2
	short s3
PREINIT:
	void(*func)(char *, short, float, short);
CODE:
	func   = INT2PTR(void(*)(char *, short, float, short), SvIV(c_func) );
	(*func)(t0, s1, f2, s3);

void
nci_vtsff( c_func, t0, s1, f2, f3 )
	SV* c_func
	char * t0
	short s1
	float f2
	float f3
PREINIT:
	void(*func)(char *, short, float, float);
CODE:
	func   = INT2PTR(void(*)(char *, short, float, float), SvIV(c_func) );
	(*func)(t0, s1, f2, f3);

void
nci_vtsft( c_func, t0, s1, f2, t3 )
	SV* c_func
	char * t0
	short s1
	float f2
	char * t3
PREINIT:
	void(*func)(char *, short, float, char *);
CODE:
	func   = INT2PTR(void(*)(char *, short, float, char *), SvIV(c_func) );
	(*func)(t0, s1, f2, t3);

void
nci_vtsfi( c_func, t0, s1, f2, i3 )
	SV* c_func
	char * t0
	short s1
	float f2
	int i3
PREINIT:
	void(*func)(char *, short, float, int);
CODE:
	func   = INT2PTR(void(*)(char *, short, float, int), SvIV(c_func) );
	(*func)(t0, s1, f2, i3);

void
nci_vtstp( c_func, t0, s1, t2, p3 )
	SV* c_func
	char * t0
	short s1
	char * t2
	void * p3
PREINIT:
	void(*func)(char *, short, char *, void *);
CODE:
	func   = INT2PTR(void(*)(char *, short, char *, void *), SvIV(c_func) );
	(*func)(t0, s1, t2, p3);

void
nci_vtstd( c_func, t0, s1, t2, d3 )
	SV* c_func
	char * t0
	short s1
	char * t2
	double d3
PREINIT:
	void(*func)(char *, short, char *, double);
CODE:
	func   = INT2PTR(void(*)(char *, short, char *, double), SvIV(c_func) );
	(*func)(t0, s1, t2, d3);

void
nci_vtsts( c_func, t0, s1, t2, s3 )
	SV* c_func
	char * t0
	short s1
	char * t2
	short s3
PREINIT:
	void(*func)(char *, short, char *, short);
CODE:
	func   = INT2PTR(void(*)(char *, short, char *, short), SvIV(c_func) );
	(*func)(t0, s1, t2, s3);

void
nci_vtstf( c_func, t0, s1, t2, f3 )
	SV* c_func
	char * t0
	short s1
	char * t2
	float f3
PREINIT:
	void(*func)(char *, short, char *, float);
CODE:
	func   = INT2PTR(void(*)(char *, short, char *, float), SvIV(c_func) );
	(*func)(t0, s1, t2, f3);

void
nci_vtstt( c_func, t0, s1, t2, t3 )
	SV* c_func
	char * t0
	short s1
	char * t2
	char * t3
PREINIT:
	void(*func)(char *, short, char *, char *);
CODE:
	func   = INT2PTR(void(*)(char *, short, char *, char *), SvIV(c_func) );
	(*func)(t0, s1, t2, t3);

void
nci_vtsti( c_func, t0, s1, t2, i3 )
	SV* c_func
	char * t0
	short s1
	char * t2
	int i3
PREINIT:
	void(*func)(char *, short, char *, int);
CODE:
	func   = INT2PTR(void(*)(char *, short, char *, int), SvIV(c_func) );
	(*func)(t0, s1, t2, i3);

void
nci_vtsip( c_func, t0, s1, i2, p3 )
	SV* c_func
	char * t0
	short s1
	int i2
	void * p3
PREINIT:
	void(*func)(char *, short, int, void *);
CODE:
	func   = INT2PTR(void(*)(char *, short, int, void *), SvIV(c_func) );
	(*func)(t0, s1, i2, p3);

void
nci_vtsid( c_func, t0, s1, i2, d3 )
	SV* c_func
	char * t0
	short s1
	int i2
	double d3
PREINIT:
	void(*func)(char *, short, int, double);
CODE:
	func   = INT2PTR(void(*)(char *, short, int, double), SvIV(c_func) );
	(*func)(t0, s1, i2, d3);

void
nci_vtsis( c_func, t0, s1, i2, s3 )
	SV* c_func
	char * t0
	short s1
	int i2
	short s3
PREINIT:
	void(*func)(char *, short, int, short);
CODE:
	func   = INT2PTR(void(*)(char *, short, int, short), SvIV(c_func) );
	(*func)(t0, s1, i2, s3);

void
nci_vtsif( c_func, t0, s1, i2, f3 )
	SV* c_func
	char * t0
	short s1
	int i2
	float f3
PREINIT:
	void(*func)(char *, short, int, float);
CODE:
	func   = INT2PTR(void(*)(char *, short, int, float), SvIV(c_func) );
	(*func)(t0, s1, i2, f3);

void
nci_vtsit( c_func, t0, s1, i2, t3 )
	SV* c_func
	char * t0
	short s1
	int i2
	char * t3
PREINIT:
	void(*func)(char *, short, int, char *);
CODE:
	func   = INT2PTR(void(*)(char *, short, int, char *), SvIV(c_func) );
	(*func)(t0, s1, i2, t3);

void
nci_vtsii( c_func, t0, s1, i2, i3 )
	SV* c_func
	char * t0
	short s1
	int i2
	int i3
PREINIT:
	void(*func)(char *, short, int, int);
CODE:
	func   = INT2PTR(void(*)(char *, short, int, int), SvIV(c_func) );
	(*func)(t0, s1, i2, i3);

void
nci_vtfpp( c_func, t0, f1, p2, p3 )
	SV* c_func
	char * t0
	float f1
	void * p2
	void * p3
PREINIT:
	void(*func)(char *, float, void *, void *);
CODE:
	func   = INT2PTR(void(*)(char *, float, void *, void *), SvIV(c_func) );
	(*func)(t0, f1, p2, p3);

void
nci_vtfpd( c_func, t0, f1, p2, d3 )
	SV* c_func
	char * t0
	float f1
	void * p2
	double d3
PREINIT:
	void(*func)(char *, float, void *, double);
CODE:
	func   = INT2PTR(void(*)(char *, float, void *, double), SvIV(c_func) );
	(*func)(t0, f1, p2, d3);

void
nci_vtfps( c_func, t0, f1, p2, s3 )
	SV* c_func
	char * t0
	float f1
	void * p2
	short s3
PREINIT:
	void(*func)(char *, float, void *, short);
CODE:
	func   = INT2PTR(void(*)(char *, float, void *, short), SvIV(c_func) );
	(*func)(t0, f1, p2, s3);

void
nci_vtfpf( c_func, t0, f1, p2, f3 )
	SV* c_func
	char * t0
	float f1
	void * p2
	float f3
PREINIT:
	void(*func)(char *, float, void *, float);
CODE:
	func   = INT2PTR(void(*)(char *, float, void *, float), SvIV(c_func) );
	(*func)(t0, f1, p2, f3);

void
nci_vtfpt( c_func, t0, f1, p2, t3 )
	SV* c_func
	char * t0
	float f1
	void * p2
	char * t3
PREINIT:
	void(*func)(char *, float, void *, char *);
CODE:
	func   = INT2PTR(void(*)(char *, float, void *, char *), SvIV(c_func) );
	(*func)(t0, f1, p2, t3);

void
nci_vtfpi( c_func, t0, f1, p2, i3 )
	SV* c_func
	char * t0
	float f1
	void * p2
	int i3
PREINIT:
	void(*func)(char *, float, void *, int);
CODE:
	func   = INT2PTR(void(*)(char *, float, void *, int), SvIV(c_func) );
	(*func)(t0, f1, p2, i3);

void
nci_vtfdp( c_func, t0, f1, d2, p3 )
	SV* c_func
	char * t0
	float f1
	double d2
	void * p3
PREINIT:
	void(*func)(char *, float, double, void *);
CODE:
	func   = INT2PTR(void(*)(char *, float, double, void *), SvIV(c_func) );
	(*func)(t0, f1, d2, p3);

void
nci_vtfdd( c_func, t0, f1, d2, d3 )
	SV* c_func
	char * t0
	float f1
	double d2
	double d3
PREINIT:
	void(*func)(char *, float, double, double);
CODE:
	func   = INT2PTR(void(*)(char *, float, double, double), SvIV(c_func) );
	(*func)(t0, f1, d2, d3);

void
nci_vtfds( c_func, t0, f1, d2, s3 )
	SV* c_func
	char * t0
	float f1
	double d2
	short s3
PREINIT:
	void(*func)(char *, float, double, short);
CODE:
	func   = INT2PTR(void(*)(char *, float, double, short), SvIV(c_func) );
	(*func)(t0, f1, d2, s3);

void
nci_vtfdf( c_func, t0, f1, d2, f3 )
	SV* c_func
	char * t0
	float f1
	double d2
	float f3
PREINIT:
	void(*func)(char *, float, double, float);
CODE:
	func   = INT2PTR(void(*)(char *, float, double, float), SvIV(c_func) );
	(*func)(t0, f1, d2, f3);

void
nci_vtfdt( c_func, t0, f1, d2, t3 )
	SV* c_func
	char * t0
	float f1
	double d2
	char * t3
PREINIT:
	void(*func)(char *, float, double, char *);
CODE:
	func   = INT2PTR(void(*)(char *, float, double, char *), SvIV(c_func) );
	(*func)(t0, f1, d2, t3);

void
nci_vtfdi( c_func, t0, f1, d2, i3 )
	SV* c_func
	char * t0
	float f1
	double d2
	int i3
PREINIT:
	void(*func)(char *, float, double, int);
CODE:
	func   = INT2PTR(void(*)(char *, float, double, int), SvIV(c_func) );
	(*func)(t0, f1, d2, i3);

void
nci_vtfsp( c_func, t0, f1, s2, p3 )
	SV* c_func
	char * t0
	float f1
	short s2
	void * p3
PREINIT:
	void(*func)(char *, float, short, void *);
CODE:
	func   = INT2PTR(void(*)(char *, float, short, void *), SvIV(c_func) );
	(*func)(t0, f1, s2, p3);

void
nci_vtfsd( c_func, t0, f1, s2, d3 )
	SV* c_func
	char * t0
	float f1
	short s2
	double d3
PREINIT:
	void(*func)(char *, float, short, double);
CODE:
	func   = INT2PTR(void(*)(char *, float, short, double), SvIV(c_func) );
	(*func)(t0, f1, s2, d3);

void
nci_vtfss( c_func, t0, f1, s2, s3 )
	SV* c_func
	char * t0
	float f1
	short s2
	short s3
PREINIT:
	void(*func)(char *, float, short, short);
CODE:
	func   = INT2PTR(void(*)(char *, float, short, short), SvIV(c_func) );
	(*func)(t0, f1, s2, s3);

void
nci_vtfsf( c_func, t0, f1, s2, f3 )
	SV* c_func
	char * t0
	float f1
	short s2
	float f3
PREINIT:
	void(*func)(char *, float, short, float);
CODE:
	func   = INT2PTR(void(*)(char *, float, short, float), SvIV(c_func) );
	(*func)(t0, f1, s2, f3);

void
nci_vtfst( c_func, t0, f1, s2, t3 )
	SV* c_func
	char * t0
	float f1
	short s2
	char * t3
PREINIT:
	void(*func)(char *, float, short, char *);
CODE:
	func   = INT2PTR(void(*)(char *, float, short, char *), SvIV(c_func) );
	(*func)(t0, f1, s2, t3);

void
nci_vtfsi( c_func, t0, f1, s2, i3 )
	SV* c_func
	char * t0
	float f1
	short s2
	int i3
PREINIT:
	void(*func)(char *, float, short, int);
CODE:
	func   = INT2PTR(void(*)(char *, float, short, int), SvIV(c_func) );
	(*func)(t0, f1, s2, i3);

void
nci_vtffp( c_func, t0, f1, f2, p3 )
	SV* c_func
	char * t0
	float f1
	float f2
	void * p3
PREINIT:
	void(*func)(char *, float, float, void *);
CODE:
	func   = INT2PTR(void(*)(char *, float, float, void *), SvIV(c_func) );
	(*func)(t0, f1, f2, p3);

void
nci_vtffd( c_func, t0, f1, f2, d3 )
	SV* c_func
	char * t0
	float f1
	float f2
	double d3
PREINIT:
	void(*func)(char *, float, float, double);
CODE:
	func   = INT2PTR(void(*)(char *, float, float, double), SvIV(c_func) );
	(*func)(t0, f1, f2, d3);

void
nci_vtffs( c_func, t0, f1, f2, s3 )
	SV* c_func
	char * t0
	float f1
	float f2
	short s3
PREINIT:
	void(*func)(char *, float, float, short);
CODE:
	func   = INT2PTR(void(*)(char *, float, float, short), SvIV(c_func) );
	(*func)(t0, f1, f2, s3);

void
nci_vtfff( c_func, t0, f1, f2, f3 )
	SV* c_func
	char * t0
	float f1
	float f2
	float f3
PREINIT:
	void(*func)(char *, float, float, float);
CODE:
	func   = INT2PTR(void(*)(char *, float, float, float), SvIV(c_func) );
	(*func)(t0, f1, f2, f3);

void
nci_vtfft( c_func, t0, f1, f2, t3 )
	SV* c_func
	char * t0
	float f1
	float f2
	char * t3
PREINIT:
	void(*func)(char *, float, float, char *);
CODE:
	func   = INT2PTR(void(*)(char *, float, float, char *), SvIV(c_func) );
	(*func)(t0, f1, f2, t3);

void
nci_vtffi( c_func, t0, f1, f2, i3 )
	SV* c_func
	char * t0
	float f1
	float f2
	int i3
PREINIT:
	void(*func)(char *, float, float, int);
CODE:
	func   = INT2PTR(void(*)(char *, float, float, int), SvIV(c_func) );
	(*func)(t0, f1, f2, i3);

void
nci_vtftp( c_func, t0, f1, t2, p3 )
	SV* c_func
	char * t0
	float f1
	char * t2
	void * p3
PREINIT:
	void(*func)(char *, float, char *, void *);
CODE:
	func   = INT2PTR(void(*)(char *, float, char *, void *), SvIV(c_func) );
	(*func)(t0, f1, t2, p3);

void
nci_vtftd( c_func, t0, f1, t2, d3 )
	SV* c_func
	char * t0
	float f1
	char * t2
	double d3
PREINIT:
	void(*func)(char *, float, char *, double);
CODE:
	func   = INT2PTR(void(*)(char *, float, char *, double), SvIV(c_func) );
	(*func)(t0, f1, t2, d3);

void
nci_vtfts( c_func, t0, f1, t2, s3 )
	SV* c_func
	char * t0
	float f1
	char * t2
	short s3
PREINIT:
	void(*func)(char *, float, char *, short);
CODE:
	func   = INT2PTR(void(*)(char *, float, char *, short), SvIV(c_func) );
	(*func)(t0, f1, t2, s3);

void
nci_vtftf( c_func, t0, f1, t2, f3 )
	SV* c_func
	char * t0
	float f1
	char * t2
	float f3
PREINIT:
	void(*func)(char *, float, char *, float);
CODE:
	func   = INT2PTR(void(*)(char *, float, char *, float), SvIV(c_func) );
	(*func)(t0, f1, t2, f3);

void
nci_vtftt( c_func, t0, f1, t2, t3 )
	SV* c_func
	char * t0
	float f1
	char * t2
	char * t3
PREINIT:
	void(*func)(char *, float, char *, char *);
CODE:
	func   = INT2PTR(void(*)(char *, float, char *, char *), SvIV(c_func) );
	(*func)(t0, f1, t2, t3);

void
nci_vtfti( c_func, t0, f1, t2, i3 )
	SV* c_func
	char * t0
	float f1
	char * t2
	int i3
PREINIT:
	void(*func)(char *, float, char *, int);
CODE:
	func   = INT2PTR(void(*)(char *, float, char *, int), SvIV(c_func) );
	(*func)(t0, f1, t2, i3);

void
nci_vtfip( c_func, t0, f1, i2, p3 )
	SV* c_func
	char * t0
	float f1
	int i2
	void * p3
PREINIT:
	void(*func)(char *, float, int, void *);
CODE:
	func   = INT2PTR(void(*)(char *, float, int, void *), SvIV(c_func) );
	(*func)(t0, f1, i2, p3);

void
nci_vtfid( c_func, t0, f1, i2, d3 )
	SV* c_func
	char * t0
	float f1
	int i2
	double d3
PREINIT:
	void(*func)(char *, float, int, double);
CODE:
	func   = INT2PTR(void(*)(char *, float, int, double), SvIV(c_func) );
	(*func)(t0, f1, i2, d3);

void
nci_vtfis( c_func, t0, f1, i2, s3 )
	SV* c_func
	char * t0
	float f1
	int i2
	short s3
PREINIT:
	void(*func)(char *, float, int, short);
CODE:
	func   = INT2PTR(void(*)(char *, float, int, short), SvIV(c_func) );
	(*func)(t0, f1, i2, s3);

void
nci_vtfif( c_func, t0, f1, i2, f3 )
	SV* c_func
	char * t0
	float f1
	int i2
	float f3
PREINIT:
	void(*func)(char *, float, int, float);
CODE:
	func   = INT2PTR(void(*)(char *, float, int, float), SvIV(c_func) );
	(*func)(t0, f1, i2, f3);

void
nci_vtfit( c_func, t0, f1, i2, t3 )
	SV* c_func
	char * t0
	float f1
	int i2
	char * t3
PREINIT:
	void(*func)(char *, float, int, char *);
CODE:
	func   = INT2PTR(void(*)(char *, float, int, char *), SvIV(c_func) );
	(*func)(t0, f1, i2, t3);

void
nci_vtfii( c_func, t0, f1, i2, i3 )
	SV* c_func
	char * t0
	float f1
	int i2
	int i3
PREINIT:
	void(*func)(char *, float, int, int);
CODE:
	func   = INT2PTR(void(*)(char *, float, int, int), SvIV(c_func) );
	(*func)(t0, f1, i2, i3);

void
nci_vttpp( c_func, t0, t1, p2, p3 )
	SV* c_func
	char * t0
	char * t1
	void * p2
	void * p3
PREINIT:
	void(*func)(char *, char *, void *, void *);
CODE:
	func   = INT2PTR(void(*)(char *, char *, void *, void *), SvIV(c_func) );
	(*func)(t0, t1, p2, p3);

void
nci_vttpd( c_func, t0, t1, p2, d3 )
	SV* c_func
	char * t0
	char * t1
	void * p2
	double d3
PREINIT:
	void(*func)(char *, char *, void *, double);
CODE:
	func   = INT2PTR(void(*)(char *, char *, void *, double), SvIV(c_func) );
	(*func)(t0, t1, p2, d3);

void
nci_vttps( c_func, t0, t1, p2, s3 )
	SV* c_func
	char * t0
	char * t1
	void * p2
	short s3
PREINIT:
	void(*func)(char *, char *, void *, short);
CODE:
	func   = INT2PTR(void(*)(char *, char *, void *, short), SvIV(c_func) );
	(*func)(t0, t1, p2, s3);

void
nci_vttpf( c_func, t0, t1, p2, f3 )
	SV* c_func
	char * t0
	char * t1
	void * p2
	float f3
PREINIT:
	void(*func)(char *, char *, void *, float);
CODE:
	func   = INT2PTR(void(*)(char *, char *, void *, float), SvIV(c_func) );
	(*func)(t0, t1, p2, f3);

void
nci_vttpt( c_func, t0, t1, p2, t3 )
	SV* c_func
	char * t0
	char * t1
	void * p2
	char * t3
PREINIT:
	void(*func)(char *, char *, void *, char *);
CODE:
	func   = INT2PTR(void(*)(char *, char *, void *, char *), SvIV(c_func) );
	(*func)(t0, t1, p2, t3);

void
nci_vttpi( c_func, t0, t1, p2, i3 )
	SV* c_func
	char * t0
	char * t1
	void * p2
	int i3
PREINIT:
	void(*func)(char *, char *, void *, int);
CODE:
	func   = INT2PTR(void(*)(char *, char *, void *, int), SvIV(c_func) );
	(*func)(t0, t1, p2, i3);

void
nci_vttdp( c_func, t0, t1, d2, p3 )
	SV* c_func
	char * t0
	char * t1
	double d2
	void * p3
PREINIT:
	void(*func)(char *, char *, double, void *);
CODE:
	func   = INT2PTR(void(*)(char *, char *, double, void *), SvIV(c_func) );
	(*func)(t0, t1, d2, p3);

void
nci_vttdd( c_func, t0, t1, d2, d3 )
	SV* c_func
	char * t0
	char * t1
	double d2
	double d3
PREINIT:
	void(*func)(char *, char *, double, double);
CODE:
	func   = INT2PTR(void(*)(char *, char *, double, double), SvIV(c_func) );
	(*func)(t0, t1, d2, d3);

void
nci_vttds( c_func, t0, t1, d2, s3 )
	SV* c_func
	char * t0
	char * t1
	double d2
	short s3
PREINIT:
	void(*func)(char *, char *, double, short);
CODE:
	func   = INT2PTR(void(*)(char *, char *, double, short), SvIV(c_func) );
	(*func)(t0, t1, d2, s3);

void
nci_vttdf( c_func, t0, t1, d2, f3 )
	SV* c_func
	char * t0
	char * t1
	double d2
	float f3
PREINIT:
	void(*func)(char *, char *, double, float);
CODE:
	func   = INT2PTR(void(*)(char *, char *, double, float), SvIV(c_func) );
	(*func)(t0, t1, d2, f3);

void
nci_vttdt( c_func, t0, t1, d2, t3 )
	SV* c_func
	char * t0
	char * t1
	double d2
	char * t3
PREINIT:
	void(*func)(char *, char *, double, char *);
CODE:
	func   = INT2PTR(void(*)(char *, char *, double, char *), SvIV(c_func) );
	(*func)(t0, t1, d2, t3);

void
nci_vttdi( c_func, t0, t1, d2, i3 )
	SV* c_func
	char * t0
	char * t1
	double d2
	int i3
PREINIT:
	void(*func)(char *, char *, double, int);
CODE:
	func   = INT2PTR(void(*)(char *, char *, double, int), SvIV(c_func) );
	(*func)(t0, t1, d2, i3);

void
nci_vttsp( c_func, t0, t1, s2, p3 )
	SV* c_func
	char * t0
	char * t1
	short s2
	void * p3
PREINIT:
	void(*func)(char *, char *, short, void *);
CODE:
	func   = INT2PTR(void(*)(char *, char *, short, void *), SvIV(c_func) );
	(*func)(t0, t1, s2, p3);

void
nci_vttsd( c_func, t0, t1, s2, d3 )
	SV* c_func
	char * t0
	char * t1
	short s2
	double d3
PREINIT:
	void(*func)(char *, char *, short, double);
CODE:
	func   = INT2PTR(void(*)(char *, char *, short, double), SvIV(c_func) );
	(*func)(t0, t1, s2, d3);

void
nci_vttss( c_func, t0, t1, s2, s3 )
	SV* c_func
	char * t0
	char * t1
	short s2
	short s3
PREINIT:
	void(*func)(char *, char *, short, short);
CODE:
	func   = INT2PTR(void(*)(char *, char *, short, short), SvIV(c_func) );
	(*func)(t0, t1, s2, s3);

void
nci_vttsf( c_func, t0, t1, s2, f3 )
	SV* c_func
	char * t0
	char * t1
	short s2
	float f3
PREINIT:
	void(*func)(char *, char *, short, float);
CODE:
	func   = INT2PTR(void(*)(char *, char *, short, float), SvIV(c_func) );
	(*func)(t0, t1, s2, f3);

void
nci_vttst( c_func, t0, t1, s2, t3 )
	SV* c_func
	char * t0
	char * t1
	short s2
	char * t3
PREINIT:
	void(*func)(char *, char *, short, char *);
CODE:
	func   = INT2PTR(void(*)(char *, char *, short, char *), SvIV(c_func) );
	(*func)(t0, t1, s2, t3);

void
nci_vttsi( c_func, t0, t1, s2, i3 )
	SV* c_func
	char * t0
	char * t1
	short s2
	int i3
PREINIT:
	void(*func)(char *, char *, short, int);
CODE:
	func   = INT2PTR(void(*)(char *, char *, short, int), SvIV(c_func) );
	(*func)(t0, t1, s2, i3);

void
nci_vttfp( c_func, t0, t1, f2, p3 )
	SV* c_func
	char * t0
	char * t1
	float f2
	void * p3
PREINIT:
	void(*func)(char *, char *, float, void *);
CODE:
	func   = INT2PTR(void(*)(char *, char *, float, void *), SvIV(c_func) );
	(*func)(t0, t1, f2, p3);

void
nci_vttfd( c_func, t0, t1, f2, d3 )
	SV* c_func
	char * t0
	char * t1
	float f2
	double d3
PREINIT:
	void(*func)(char *, char *, float, double);
CODE:
	func   = INT2PTR(void(*)(char *, char *, float, double), SvIV(c_func) );
	(*func)(t0, t1, f2, d3);

void
nci_vttfs( c_func, t0, t1, f2, s3 )
	SV* c_func
	char * t0
	char * t1
	float f2
	short s3
PREINIT:
	void(*func)(char *, char *, float, short);
CODE:
	func   = INT2PTR(void(*)(char *, char *, float, short), SvIV(c_func) );
	(*func)(t0, t1, f2, s3);

void
nci_vttff( c_func, t0, t1, f2, f3 )
	SV* c_func
	char * t0
	char * t1
	float f2
	float f3
PREINIT:
	void(*func)(char *, char *, float, float);
CODE:
	func   = INT2PTR(void(*)(char *, char *, float, float), SvIV(c_func) );
	(*func)(t0, t1, f2, f3);

void
nci_vttft( c_func, t0, t1, f2, t3 )
	SV* c_func
	char * t0
	char * t1
	float f2
	char * t3
PREINIT:
	void(*func)(char *, char *, float, char *);
CODE:
	func   = INT2PTR(void(*)(char *, char *, float, char *), SvIV(c_func) );
	(*func)(t0, t1, f2, t3);

void
nci_vttfi( c_func, t0, t1, f2, i3 )
	SV* c_func
	char * t0
	char * t1
	float f2
	int i3
PREINIT:
	void(*func)(char *, char *, float, int);
CODE:
	func   = INT2PTR(void(*)(char *, char *, float, int), SvIV(c_func) );
	(*func)(t0, t1, f2, i3);

void
nci_vtttp( c_func, t0, t1, t2, p3 )
	SV* c_func
	char * t0
	char * t1
	char * t2
	void * p3
PREINIT:
	void(*func)(char *, char *, char *, void *);
CODE:
	func   = INT2PTR(void(*)(char *, char *, char *, void *), SvIV(c_func) );
	(*func)(t0, t1, t2, p3);

void
nci_vtttd( c_func, t0, t1, t2, d3 )
	SV* c_func
	char * t0
	char * t1
	char * t2
	double d3
PREINIT:
	void(*func)(char *, char *, char *, double);
CODE:
	func   = INT2PTR(void(*)(char *, char *, char *, double), SvIV(c_func) );
	(*func)(t0, t1, t2, d3);

void
nci_vttts( c_func, t0, t1, t2, s3 )
	SV* c_func
	char * t0
	char * t1
	char * t2
	short s3
PREINIT:
	void(*func)(char *, char *, char *, short);
CODE:
	func   = INT2PTR(void(*)(char *, char *, char *, short), SvIV(c_func) );
	(*func)(t0, t1, t2, s3);

void
nci_vtttf( c_func, t0, t1, t2, f3 )
	SV* c_func
	char * t0
	char * t1
	char * t2
	float f3
PREINIT:
	void(*func)(char *, char *, char *, float);
CODE:
	func   = INT2PTR(void(*)(char *, char *, char *, float), SvIV(c_func) );
	(*func)(t0, t1, t2, f3);

void
nci_vtttt( c_func, t0, t1, t2, t3 )
	SV* c_func
	char * t0
	char * t1
	char * t2
	char * t3
PREINIT:
	void(*func)(char *, char *, char *, char *);
CODE:
	func   = INT2PTR(void(*)(char *, char *, char *, char *), SvIV(c_func) );
	(*func)(t0, t1, t2, t3);

void
nci_vttti( c_func, t0, t1, t2, i3 )
	SV* c_func
	char * t0
	char * t1
	char * t2
	int i3
PREINIT:
	void(*func)(char *, char *, char *, int);
CODE:
	func   = INT2PTR(void(*)(char *, char *, char *, int), SvIV(c_func) );
	(*func)(t0, t1, t2, i3);

void
nci_vttip( c_func, t0, t1, i2, p3 )
	SV* c_func
	char * t0
	char * t1
	int i2
	void * p3
PREINIT:
	void(*func)(char *, char *, int, void *);
CODE:
	func   = INT2PTR(void(*)(char *, char *, int, void *), SvIV(c_func) );
	(*func)(t0, t1, i2, p3);

void
nci_vttid( c_func, t0, t1, i2, d3 )
	SV* c_func
	char * t0
	char * t1
	int i2
	double d3
PREINIT:
	void(*func)(char *, char *, int, double);
CODE:
	func   = INT2PTR(void(*)(char *, char *, int, double), SvIV(c_func) );
	(*func)(t0, t1, i2, d3);

void
nci_vttis( c_func, t0, t1, i2, s3 )
	SV* c_func
	char * t0
	char * t1
	int i2
	short s3
PREINIT:
	void(*func)(char *, char *, int, short);
CODE:
	func   = INT2PTR(void(*)(char *, char *, int, short), SvIV(c_func) );
	(*func)(t0, t1, i2, s3);

void
nci_vttif( c_func, t0, t1, i2, f3 )
	SV* c_func
	char * t0
	char * t1
	int i2
	float f3
PREINIT:
	void(*func)(char *, char *, int, float);
CODE:
	func   = INT2PTR(void(*)(char *, char *, int, float), SvIV(c_func) );
	(*func)(t0, t1, i2, f3);

void
nci_vttit( c_func, t0, t1, i2, t3 )
	SV* c_func
	char * t0
	char * t1
	int i2
	char * t3
PREINIT:
	void(*func)(char *, char *, int, char *);
CODE:
	func   = INT2PTR(void(*)(char *, char *, int, char *), SvIV(c_func) );
	(*func)(t0, t1, i2, t3);

void
nci_vttii( c_func, t0, t1, i2, i3 )
	SV* c_func
	char * t0
	char * t1
	int i2
	int i3
PREINIT:
	void(*func)(char *, char *, int, int);
CODE:
	func   = INT2PTR(void(*)(char *, char *, int, int), SvIV(c_func) );
	(*func)(t0, t1, i2, i3);

void
nci_vtipp( c_func, t0, i1, p2, p3 )
	SV* c_func
	char * t0
	int i1
	void * p2
	void * p3
PREINIT:
	void(*func)(char *, int, void *, void *);
CODE:
	func   = INT2PTR(void(*)(char *, int, void *, void *), SvIV(c_func) );
	(*func)(t0, i1, p2, p3);

void
nci_vtipd( c_func, t0, i1, p2, d3 )
	SV* c_func
	char * t0
	int i1
	void * p2
	double d3
PREINIT:
	void(*func)(char *, int, void *, double);
CODE:
	func   = INT2PTR(void(*)(char *, int, void *, double), SvIV(c_func) );
	(*func)(t0, i1, p2, d3);

void
nci_vtips( c_func, t0, i1, p2, s3 )
	SV* c_func
	char * t0
	int i1
	void * p2
	short s3
PREINIT:
	void(*func)(char *, int, void *, short);
CODE:
	func   = INT2PTR(void(*)(char *, int, void *, short), SvIV(c_func) );
	(*func)(t0, i1, p2, s3);

void
nci_vtipf( c_func, t0, i1, p2, f3 )
	SV* c_func
	char * t0
	int i1
	void * p2
	float f3
PREINIT:
	void(*func)(char *, int, void *, float);
CODE:
	func   = INT2PTR(void(*)(char *, int, void *, float), SvIV(c_func) );
	(*func)(t0, i1, p2, f3);

void
nci_vtipt( c_func, t0, i1, p2, t3 )
	SV* c_func
	char * t0
	int i1
	void * p2
	char * t3
PREINIT:
	void(*func)(char *, int, void *, char *);
CODE:
	func   = INT2PTR(void(*)(char *, int, void *, char *), SvIV(c_func) );
	(*func)(t0, i1, p2, t3);

void
nci_vtipi( c_func, t0, i1, p2, i3 )
	SV* c_func
	char * t0
	int i1
	void * p2
	int i3
PREINIT:
	void(*func)(char *, int, void *, int);
CODE:
	func   = INT2PTR(void(*)(char *, int, void *, int), SvIV(c_func) );
	(*func)(t0, i1, p2, i3);

void
nci_vtidp( c_func, t0, i1, d2, p3 )
	SV* c_func
	char * t0
	int i1
	double d2
	void * p3
PREINIT:
	void(*func)(char *, int, double, void *);
CODE:
	func   = INT2PTR(void(*)(char *, int, double, void *), SvIV(c_func) );
	(*func)(t0, i1, d2, p3);

void
nci_vtidd( c_func, t0, i1, d2, d3 )
	SV* c_func
	char * t0
	int i1
	double d2
	double d3
PREINIT:
	void(*func)(char *, int, double, double);
CODE:
	func   = INT2PTR(void(*)(char *, int, double, double), SvIV(c_func) );
	(*func)(t0, i1, d2, d3);

void
nci_vtids( c_func, t0, i1, d2, s3 )
	SV* c_func
	char * t0
	int i1
	double d2
	short s3
PREINIT:
	void(*func)(char *, int, double, short);
CODE:
	func   = INT2PTR(void(*)(char *, int, double, short), SvIV(c_func) );
	(*func)(t0, i1, d2, s3);

void
nci_vtidf( c_func, t0, i1, d2, f3 )
	SV* c_func
	char * t0
	int i1
	double d2
	float f3
PREINIT:
	void(*func)(char *, int, double, float);
CODE:
	func   = INT2PTR(void(*)(char *, int, double, float), SvIV(c_func) );
	(*func)(t0, i1, d2, f3);

void
nci_vtidt( c_func, t0, i1, d2, t3 )
	SV* c_func
	char * t0
	int i1
	double d2
	char * t3
PREINIT:
	void(*func)(char *, int, double, char *);
CODE:
	func   = INT2PTR(void(*)(char *, int, double, char *), SvIV(c_func) );
	(*func)(t0, i1, d2, t3);

void
nci_vtidi( c_func, t0, i1, d2, i3 )
	SV* c_func
	char * t0
	int i1
	double d2
	int i3
PREINIT:
	void(*func)(char *, int, double, int);
CODE:
	func   = INT2PTR(void(*)(char *, int, double, int), SvIV(c_func) );
	(*func)(t0, i1, d2, i3);

void
nci_vtisp( c_func, t0, i1, s2, p3 )
	SV* c_func
	char * t0
	int i1
	short s2
	void * p3
PREINIT:
	void(*func)(char *, int, short, void *);
CODE:
	func   = INT2PTR(void(*)(char *, int, short, void *), SvIV(c_func) );
	(*func)(t0, i1, s2, p3);

void
nci_vtisd( c_func, t0, i1, s2, d3 )
	SV* c_func
	char * t0
	int i1
	short s2
	double d3
PREINIT:
	void(*func)(char *, int, short, double);
CODE:
	func   = INT2PTR(void(*)(char *, int, short, double), SvIV(c_func) );
	(*func)(t0, i1, s2, d3);

void
nci_vtiss( c_func, t0, i1, s2, s3 )
	SV* c_func
	char * t0
	int i1
	short s2
	short s3
PREINIT:
	void(*func)(char *, int, short, short);
CODE:
	func   = INT2PTR(void(*)(char *, int, short, short), SvIV(c_func) );
	(*func)(t0, i1, s2, s3);

void
nci_vtisf( c_func, t0, i1, s2, f3 )
	SV* c_func
	char * t0
	int i1
	short s2
	float f3
PREINIT:
	void(*func)(char *, int, short, float);
CODE:
	func   = INT2PTR(void(*)(char *, int, short, float), SvIV(c_func) );
	(*func)(t0, i1, s2, f3);

void
nci_vtist( c_func, t0, i1, s2, t3 )
	SV* c_func
	char * t0
	int i1
	short s2
	char * t3
PREINIT:
	void(*func)(char *, int, short, char *);
CODE:
	func   = INT2PTR(void(*)(char *, int, short, char *), SvIV(c_func) );
	(*func)(t0, i1, s2, t3);

void
nci_vtisi( c_func, t0, i1, s2, i3 )
	SV* c_func
	char * t0
	int i1
	short s2
	int i3
PREINIT:
	void(*func)(char *, int, short, int);
CODE:
	func   = INT2PTR(void(*)(char *, int, short, int), SvIV(c_func) );
	(*func)(t0, i1, s2, i3);

void
nci_vtifp( c_func, t0, i1, f2, p3 )
	SV* c_func
	char * t0
	int i1
	float f2
	void * p3
PREINIT:
	void(*func)(char *, int, float, void *);
CODE:
	func   = INT2PTR(void(*)(char *, int, float, void *), SvIV(c_func) );
	(*func)(t0, i1, f2, p3);

void
nci_vtifd( c_func, t0, i1, f2, d3 )
	SV* c_func
	char * t0
	int i1
	float f2
	double d3
PREINIT:
	void(*func)(char *, int, float, double);
CODE:
	func   = INT2PTR(void(*)(char *, int, float, double), SvIV(c_func) );
	(*func)(t0, i1, f2, d3);

void
nci_vtifs( c_func, t0, i1, f2, s3 )
	SV* c_func
	char * t0
	int i1
	float f2
	short s3
PREINIT:
	void(*func)(char *, int, float, short);
CODE:
	func   = INT2PTR(void(*)(char *, int, float, short), SvIV(c_func) );
	(*func)(t0, i1, f2, s3);

void
nci_vtiff( c_func, t0, i1, f2, f3 )
	SV* c_func
	char * t0
	int i1
	float f2
	float f3
PREINIT:
	void(*func)(char *, int, float, float);
CODE:
	func   = INT2PTR(void(*)(char *, int, float, float), SvIV(c_func) );
	(*func)(t0, i1, f2, f3);

void
nci_vtift( c_func, t0, i1, f2, t3 )
	SV* c_func
	char * t0
	int i1
	float f2
	char * t3
PREINIT:
	void(*func)(char *, int, float, char *);
CODE:
	func   = INT2PTR(void(*)(char *, int, float, char *), SvIV(c_func) );
	(*func)(t0, i1, f2, t3);

void
nci_vtifi( c_func, t0, i1, f2, i3 )
	SV* c_func
	char * t0
	int i1
	float f2
	int i3
PREINIT:
	void(*func)(char *, int, float, int);
CODE:
	func   = INT2PTR(void(*)(char *, int, float, int), SvIV(c_func) );
	(*func)(t0, i1, f2, i3);

void
nci_vtitp( c_func, t0, i1, t2, p3 )
	SV* c_func
	char * t0
	int i1
	char * t2
	void * p3
PREINIT:
	void(*func)(char *, int, char *, void *);
CODE:
	func   = INT2PTR(void(*)(char *, int, char *, void *), SvIV(c_func) );
	(*func)(t0, i1, t2, p3);

void
nci_vtitd( c_func, t0, i1, t2, d3 )
	SV* c_func
	char * t0
	int i1
	char * t2
	double d3
PREINIT:
	void(*func)(char *, int, char *, double);
CODE:
	func   = INT2PTR(void(*)(char *, int, char *, double), SvIV(c_func) );
	(*func)(t0, i1, t2, d3);

void
nci_vtits( c_func, t0, i1, t2, s3 )
	SV* c_func
	char * t0
	int i1
	char * t2
	short s3
PREINIT:
	void(*func)(char *, int, char *, short);
CODE:
	func   = INT2PTR(void(*)(char *, int, char *, short), SvIV(c_func) );
	(*func)(t0, i1, t2, s3);

void
nci_vtitf( c_func, t0, i1, t2, f3 )
	SV* c_func
	char * t0
	int i1
	char * t2
	float f3
PREINIT:
	void(*func)(char *, int, char *, float);
CODE:
	func   = INT2PTR(void(*)(char *, int, char *, float), SvIV(c_func) );
	(*func)(t0, i1, t2, f3);

void
nci_vtitt( c_func, t0, i1, t2, t3 )
	SV* c_func
	char * t0
	int i1
	char * t2
	char * t3
PREINIT:
	void(*func)(char *, int, char *, char *);
CODE:
	func   = INT2PTR(void(*)(char *, int, char *, char *), SvIV(c_func) );
	(*func)(t0, i1, t2, t3);

void
nci_vtiti( c_func, t0, i1, t2, i3 )
	SV* c_func
	char * t0
	int i1
	char * t2
	int i3
PREINIT:
	void(*func)(char *, int, char *, int);
CODE:
	func   = INT2PTR(void(*)(char *, int, char *, int), SvIV(c_func) );
	(*func)(t0, i1, t2, i3);

void
nci_vtiip( c_func, t0, i1, i2, p3 )
	SV* c_func
	char * t0
	int i1
	int i2
	void * p3
PREINIT:
	void(*func)(char *, int, int, void *);
CODE:
	func   = INT2PTR(void(*)(char *, int, int, void *), SvIV(c_func) );
	(*func)(t0, i1, i2, p3);

void
nci_vtiid( c_func, t0, i1, i2, d3 )
	SV* c_func
	char * t0
	int i1
	int i2
	double d3
PREINIT:
	void(*func)(char *, int, int, double);
CODE:
	func   = INT2PTR(void(*)(char *, int, int, double), SvIV(c_func) );
	(*func)(t0, i1, i2, d3);

void
nci_vtiis( c_func, t0, i1, i2, s3 )
	SV* c_func
	char * t0
	int i1
	int i2
	short s3
PREINIT:
	void(*func)(char *, int, int, short);
CODE:
	func   = INT2PTR(void(*)(char *, int, int, short), SvIV(c_func) );
	(*func)(t0, i1, i2, s3);

void
nci_vtiif( c_func, t0, i1, i2, f3 )
	SV* c_func
	char * t0
	int i1
	int i2
	float f3
PREINIT:
	void(*func)(char *, int, int, float);
CODE:
	func   = INT2PTR(void(*)(char *, int, int, float), SvIV(c_func) );
	(*func)(t0, i1, i2, f3);

void
nci_vtiit( c_func, t0, i1, i2, t3 )
	SV* c_func
	char * t0
	int i1
	int i2
	char * t3
PREINIT:
	void(*func)(char *, int, int, char *);
CODE:
	func   = INT2PTR(void(*)(char *, int, int, char *), SvIV(c_func) );
	(*func)(t0, i1, i2, t3);

void
nci_vtiii( c_func, t0, i1, i2, i3 )
	SV* c_func
	char * t0
	int i1
	int i2
	int i3
PREINIT:
	void(*func)(char *, int, int, int);
CODE:
	func   = INT2PTR(void(*)(char *, int, int, int), SvIV(c_func) );
	(*func)(t0, i1, i2, i3);

void
nci_vippp( c_func, i0, p1, p2, p3 )
	SV* c_func
	int i0
	void * p1
	void * p2
	void * p3
PREINIT:
	void(*func)(int, void *, void *, void *);
CODE:
	func   = INT2PTR(void(*)(int, void *, void *, void *), SvIV(c_func) );
	(*func)(i0, p1, p2, p3);

void
nci_vippd( c_func, i0, p1, p2, d3 )
	SV* c_func
	int i0
	void * p1
	void * p2
	double d3
PREINIT:
	void(*func)(int, void *, void *, double);
CODE:
	func   = INT2PTR(void(*)(int, void *, void *, double), SvIV(c_func) );
	(*func)(i0, p1, p2, d3);

void
nci_vipps( c_func, i0, p1, p2, s3 )
	SV* c_func
	int i0
	void * p1
	void * p2
	short s3
PREINIT:
	void(*func)(int, void *, void *, short);
CODE:
	func   = INT2PTR(void(*)(int, void *, void *, short), SvIV(c_func) );
	(*func)(i0, p1, p2, s3);

void
nci_vippf( c_func, i0, p1, p2, f3 )
	SV* c_func
	int i0
	void * p1
	void * p2
	float f3
PREINIT:
	void(*func)(int, void *, void *, float);
CODE:
	func   = INT2PTR(void(*)(int, void *, void *, float), SvIV(c_func) );
	(*func)(i0, p1, p2, f3);

void
nci_vippt( c_func, i0, p1, p2, t3 )
	SV* c_func
	int i0
	void * p1
	void * p2
	char * t3
PREINIT:
	void(*func)(int, void *, void *, char *);
CODE:
	func   = INT2PTR(void(*)(int, void *, void *, char *), SvIV(c_func) );
	(*func)(i0, p1, p2, t3);

void
nci_vippi( c_func, i0, p1, p2, i3 )
	SV* c_func
	int i0
	void * p1
	void * p2
	int i3
PREINIT:
	void(*func)(int, void *, void *, int);
CODE:
	func   = INT2PTR(void(*)(int, void *, void *, int), SvIV(c_func) );
	(*func)(i0, p1, p2, i3);

void
nci_vipdp( c_func, i0, p1, d2, p3 )
	SV* c_func
	int i0
	void * p1
	double d2
	void * p3
PREINIT:
	void(*func)(int, void *, double, void *);
CODE:
	func   = INT2PTR(void(*)(int, void *, double, void *), SvIV(c_func) );
	(*func)(i0, p1, d2, p3);

void
nci_vipdd( c_func, i0, p1, d2, d3 )
	SV* c_func
	int i0
	void * p1
	double d2
	double d3
PREINIT:
	void(*func)(int, void *, double, double);
CODE:
	func   = INT2PTR(void(*)(int, void *, double, double), SvIV(c_func) );
	(*func)(i0, p1, d2, d3);

void
nci_vipds( c_func, i0, p1, d2, s3 )
	SV* c_func
	int i0
	void * p1
	double d2
	short s3
PREINIT:
	void(*func)(int, void *, double, short);
CODE:
	func   = INT2PTR(void(*)(int, void *, double, short), SvIV(c_func) );
	(*func)(i0, p1, d2, s3);

void
nci_vipdf( c_func, i0, p1, d2, f3 )
	SV* c_func
	int i0
	void * p1
	double d2
	float f3
PREINIT:
	void(*func)(int, void *, double, float);
CODE:
	func   = INT2PTR(void(*)(int, void *, double, float), SvIV(c_func) );
	(*func)(i0, p1, d2, f3);

void
nci_vipdt( c_func, i0, p1, d2, t3 )
	SV* c_func
	int i0
	void * p1
	double d2
	char * t3
PREINIT:
	void(*func)(int, void *, double, char *);
CODE:
	func   = INT2PTR(void(*)(int, void *, double, char *), SvIV(c_func) );
	(*func)(i0, p1, d2, t3);

void
nci_vipdi( c_func, i0, p1, d2, i3 )
	SV* c_func
	int i0
	void * p1
	double d2
	int i3
PREINIT:
	void(*func)(int, void *, double, int);
CODE:
	func   = INT2PTR(void(*)(int, void *, double, int), SvIV(c_func) );
	(*func)(i0, p1, d2, i3);

void
nci_vipsp( c_func, i0, p1, s2, p3 )
	SV* c_func
	int i0
	void * p1
	short s2
	void * p3
PREINIT:
	void(*func)(int, void *, short, void *);
CODE:
	func   = INT2PTR(void(*)(int, void *, short, void *), SvIV(c_func) );
	(*func)(i0, p1, s2, p3);

void
nci_vipsd( c_func, i0, p1, s2, d3 )
	SV* c_func
	int i0
	void * p1
	short s2
	double d3
PREINIT:
	void(*func)(int, void *, short, double);
CODE:
	func   = INT2PTR(void(*)(int, void *, short, double), SvIV(c_func) );
	(*func)(i0, p1, s2, d3);

void
nci_vipss( c_func, i0, p1, s2, s3 )
	SV* c_func
	int i0
	void * p1
	short s2
	short s3
PREINIT:
	void(*func)(int, void *, short, short);
CODE:
	func   = INT2PTR(void(*)(int, void *, short, short), SvIV(c_func) );
	(*func)(i0, p1, s2, s3);

void
nci_vipsf( c_func, i0, p1, s2, f3 )
	SV* c_func
	int i0
	void * p1
	short s2
	float f3
PREINIT:
	void(*func)(int, void *, short, float);
CODE:
	func   = INT2PTR(void(*)(int, void *, short, float), SvIV(c_func) );
	(*func)(i0, p1, s2, f3);

void
nci_vipst( c_func, i0, p1, s2, t3 )
	SV* c_func
	int i0
	void * p1
	short s2
	char * t3
PREINIT:
	void(*func)(int, void *, short, char *);
CODE:
	func   = INT2PTR(void(*)(int, void *, short, char *), SvIV(c_func) );
	(*func)(i0, p1, s2, t3);

void
nci_vipsi( c_func, i0, p1, s2, i3 )
	SV* c_func
	int i0
	void * p1
	short s2
	int i3
PREINIT:
	void(*func)(int, void *, short, int);
CODE:
	func   = INT2PTR(void(*)(int, void *, short, int), SvIV(c_func) );
	(*func)(i0, p1, s2, i3);

void
nci_vipfp( c_func, i0, p1, f2, p3 )
	SV* c_func
	int i0
	void * p1
	float f2
	void * p3
PREINIT:
	void(*func)(int, void *, float, void *);
CODE:
	func   = INT2PTR(void(*)(int, void *, float, void *), SvIV(c_func) );
	(*func)(i0, p1, f2, p3);

void
nci_vipfd( c_func, i0, p1, f2, d3 )
	SV* c_func
	int i0
	void * p1
	float f2
	double d3
PREINIT:
	void(*func)(int, void *, float, double);
CODE:
	func   = INT2PTR(void(*)(int, void *, float, double), SvIV(c_func) );
	(*func)(i0, p1, f2, d3);

void
nci_vipfs( c_func, i0, p1, f2, s3 )
	SV* c_func
	int i0
	void * p1
	float f2
	short s3
PREINIT:
	void(*func)(int, void *, float, short);
CODE:
	func   = INT2PTR(void(*)(int, void *, float, short), SvIV(c_func) );
	(*func)(i0, p1, f2, s3);

void
nci_vipff( c_func, i0, p1, f2, f3 )
	SV* c_func
	int i0
	void * p1
	float f2
	float f3
PREINIT:
	void(*func)(int, void *, float, float);
CODE:
	func   = INT2PTR(void(*)(int, void *, float, float), SvIV(c_func) );
	(*func)(i0, p1, f2, f3);

void
nci_vipft( c_func, i0, p1, f2, t3 )
	SV* c_func
	int i0
	void * p1
	float f2
	char * t3
PREINIT:
	void(*func)(int, void *, float, char *);
CODE:
	func   = INT2PTR(void(*)(int, void *, float, char *), SvIV(c_func) );
	(*func)(i0, p1, f2, t3);

void
nci_vipfi( c_func, i0, p1, f2, i3 )
	SV* c_func
	int i0
	void * p1
	float f2
	int i3
PREINIT:
	void(*func)(int, void *, float, int);
CODE:
	func   = INT2PTR(void(*)(int, void *, float, int), SvIV(c_func) );
	(*func)(i0, p1, f2, i3);

void
nci_viptp( c_func, i0, p1, t2, p3 )
	SV* c_func
	int i0
	void * p1
	char * t2
	void * p3
PREINIT:
	void(*func)(int, void *, char *, void *);
CODE:
	func   = INT2PTR(void(*)(int, void *, char *, void *), SvIV(c_func) );
	(*func)(i0, p1, t2, p3);

void
nci_viptd( c_func, i0, p1, t2, d3 )
	SV* c_func
	int i0
	void * p1
	char * t2
	double d3
PREINIT:
	void(*func)(int, void *, char *, double);
CODE:
	func   = INT2PTR(void(*)(int, void *, char *, double), SvIV(c_func) );
	(*func)(i0, p1, t2, d3);

void
nci_vipts( c_func, i0, p1, t2, s3 )
	SV* c_func
	int i0
	void * p1
	char * t2
	short s3
PREINIT:
	void(*func)(int, void *, char *, short);
CODE:
	func   = INT2PTR(void(*)(int, void *, char *, short), SvIV(c_func) );
	(*func)(i0, p1, t2, s3);

void
nci_viptf( c_func, i0, p1, t2, f3 )
	SV* c_func
	int i0
	void * p1
	char * t2
	float f3
PREINIT:
	void(*func)(int, void *, char *, float);
CODE:
	func   = INT2PTR(void(*)(int, void *, char *, float), SvIV(c_func) );
	(*func)(i0, p1, t2, f3);

void
nci_viptt( c_func, i0, p1, t2, t3 )
	SV* c_func
	int i0
	void * p1
	char * t2
	char * t3
PREINIT:
	void(*func)(int, void *, char *, char *);
CODE:
	func   = INT2PTR(void(*)(int, void *, char *, char *), SvIV(c_func) );
	(*func)(i0, p1, t2, t3);

void
nci_vipti( c_func, i0, p1, t2, i3 )
	SV* c_func
	int i0
	void * p1
	char * t2
	int i3
PREINIT:
	void(*func)(int, void *, char *, int);
CODE:
	func   = INT2PTR(void(*)(int, void *, char *, int), SvIV(c_func) );
	(*func)(i0, p1, t2, i3);

void
nci_vipip( c_func, i0, p1, i2, p3 )
	SV* c_func
	int i0
	void * p1
	int i2
	void * p3
PREINIT:
	void(*func)(int, void *, int, void *);
CODE:
	func   = INT2PTR(void(*)(int, void *, int, void *), SvIV(c_func) );
	(*func)(i0, p1, i2, p3);

void
nci_vipid( c_func, i0, p1, i2, d3 )
	SV* c_func
	int i0
	void * p1
	int i2
	double d3
PREINIT:
	void(*func)(int, void *, int, double);
CODE:
	func   = INT2PTR(void(*)(int, void *, int, double), SvIV(c_func) );
	(*func)(i0, p1, i2, d3);

void
nci_vipis( c_func, i0, p1, i2, s3 )
	SV* c_func
	int i0
	void * p1
	int i2
	short s3
PREINIT:
	void(*func)(int, void *, int, short);
CODE:
	func   = INT2PTR(void(*)(int, void *, int, short), SvIV(c_func) );
	(*func)(i0, p1, i2, s3);

void
nci_vipif( c_func, i0, p1, i2, f3 )
	SV* c_func
	int i0
	void * p1
	int i2
	float f3
PREINIT:
	void(*func)(int, void *, int, float);
CODE:
	func   = INT2PTR(void(*)(int, void *, int, float), SvIV(c_func) );
	(*func)(i0, p1, i2, f3);

void
nci_vipit( c_func, i0, p1, i2, t3 )
	SV* c_func
	int i0
	void * p1
	int i2
	char * t3
PREINIT:
	void(*func)(int, void *, int, char *);
CODE:
	func   = INT2PTR(void(*)(int, void *, int, char *), SvIV(c_func) );
	(*func)(i0, p1, i2, t3);

void
nci_vipii( c_func, i0, p1, i2, i3 )
	SV* c_func
	int i0
	void * p1
	int i2
	int i3
PREINIT:
	void(*func)(int, void *, int, int);
CODE:
	func   = INT2PTR(void(*)(int, void *, int, int), SvIV(c_func) );
	(*func)(i0, p1, i2, i3);

void
nci_vidpp( c_func, i0, d1, p2, p3 )
	SV* c_func
	int i0
	double d1
	void * p2
	void * p3
PREINIT:
	void(*func)(int, double, void *, void *);
CODE:
	func   = INT2PTR(void(*)(int, double, void *, void *), SvIV(c_func) );
	(*func)(i0, d1, p2, p3);

void
nci_vidpd( c_func, i0, d1, p2, d3 )
	SV* c_func
	int i0
	double d1
	void * p2
	double d3
PREINIT:
	void(*func)(int, double, void *, double);
CODE:
	func   = INT2PTR(void(*)(int, double, void *, double), SvIV(c_func) );
	(*func)(i0, d1, p2, d3);

void
nci_vidps( c_func, i0, d1, p2, s3 )
	SV* c_func
	int i0
	double d1
	void * p2
	short s3
PREINIT:
	void(*func)(int, double, void *, short);
CODE:
	func   = INT2PTR(void(*)(int, double, void *, short), SvIV(c_func) );
	(*func)(i0, d1, p2, s3);

void
nci_vidpf( c_func, i0, d1, p2, f3 )
	SV* c_func
	int i0
	double d1
	void * p2
	float f3
PREINIT:
	void(*func)(int, double, void *, float);
CODE:
	func   = INT2PTR(void(*)(int, double, void *, float), SvIV(c_func) );
	(*func)(i0, d1, p2, f3);

void
nci_vidpt( c_func, i0, d1, p2, t3 )
	SV* c_func
	int i0
	double d1
	void * p2
	char * t3
PREINIT:
	void(*func)(int, double, void *, char *);
CODE:
	func   = INT2PTR(void(*)(int, double, void *, char *), SvIV(c_func) );
	(*func)(i0, d1, p2, t3);

void
nci_vidpi( c_func, i0, d1, p2, i3 )
	SV* c_func
	int i0
	double d1
	void * p2
	int i3
PREINIT:
	void(*func)(int, double, void *, int);
CODE:
	func   = INT2PTR(void(*)(int, double, void *, int), SvIV(c_func) );
	(*func)(i0, d1, p2, i3);

void
nci_viddp( c_func, i0, d1, d2, p3 )
	SV* c_func
	int i0
	double d1
	double d2
	void * p3
PREINIT:
	void(*func)(int, double, double, void *);
CODE:
	func   = INT2PTR(void(*)(int, double, double, void *), SvIV(c_func) );
	(*func)(i0, d1, d2, p3);

void
nci_viddd( c_func, i0, d1, d2, d3 )
	SV* c_func
	int i0
	double d1
	double d2
	double d3
PREINIT:
	void(*func)(int, double, double, double);
CODE:
	func   = INT2PTR(void(*)(int, double, double, double), SvIV(c_func) );
	(*func)(i0, d1, d2, d3);

void
nci_vidds( c_func, i0, d1, d2, s3 )
	SV* c_func
	int i0
	double d1
	double d2
	short s3
PREINIT:
	void(*func)(int, double, double, short);
CODE:
	func   = INT2PTR(void(*)(int, double, double, short), SvIV(c_func) );
	(*func)(i0, d1, d2, s3);

void
nci_viddf( c_func, i0, d1, d2, f3 )
	SV* c_func
	int i0
	double d1
	double d2
	float f3
PREINIT:
	void(*func)(int, double, double, float);
CODE:
	func   = INT2PTR(void(*)(int, double, double, float), SvIV(c_func) );
	(*func)(i0, d1, d2, f3);

void
nci_viddt( c_func, i0, d1, d2, t3 )
	SV* c_func
	int i0
	double d1
	double d2
	char * t3
PREINIT:
	void(*func)(int, double, double, char *);
CODE:
	func   = INT2PTR(void(*)(int, double, double, char *), SvIV(c_func) );
	(*func)(i0, d1, d2, t3);

void
nci_viddi( c_func, i0, d1, d2, i3 )
	SV* c_func
	int i0
	double d1
	double d2
	int i3
PREINIT:
	void(*func)(int, double, double, int);
CODE:
	func   = INT2PTR(void(*)(int, double, double, int), SvIV(c_func) );
	(*func)(i0, d1, d2, i3);

void
nci_vidsp( c_func, i0, d1, s2, p3 )
	SV* c_func
	int i0
	double d1
	short s2
	void * p3
PREINIT:
	void(*func)(int, double, short, void *);
CODE:
	func   = INT2PTR(void(*)(int, double, short, void *), SvIV(c_func) );
	(*func)(i0, d1, s2, p3);

void
nci_vidsd( c_func, i0, d1, s2, d3 )
	SV* c_func
	int i0
	double d1
	short s2
	double d3
PREINIT:
	void(*func)(int, double, short, double);
CODE:
	func   = INT2PTR(void(*)(int, double, short, double), SvIV(c_func) );
	(*func)(i0, d1, s2, d3);

void
nci_vidss( c_func, i0, d1, s2, s3 )
	SV* c_func
	int i0
	double d1
	short s2
	short s3
PREINIT:
	void(*func)(int, double, short, short);
CODE:
	func   = INT2PTR(void(*)(int, double, short, short), SvIV(c_func) );
	(*func)(i0, d1, s2, s3);

void
nci_vidsf( c_func, i0, d1, s2, f3 )
	SV* c_func
	int i0
	double d1
	short s2
	float f3
PREINIT:
	void(*func)(int, double, short, float);
CODE:
	func   = INT2PTR(void(*)(int, double, short, float), SvIV(c_func) );
	(*func)(i0, d1, s2, f3);

void
nci_vidst( c_func, i0, d1, s2, t3 )
	SV* c_func
	int i0
	double d1
	short s2
	char * t3
PREINIT:
	void(*func)(int, double, short, char *);
CODE:
	func   = INT2PTR(void(*)(int, double, short, char *), SvIV(c_func) );
	(*func)(i0, d1, s2, t3);

void
nci_vidsi( c_func, i0, d1, s2, i3 )
	SV* c_func
	int i0
	double d1
	short s2
	int i3
PREINIT:
	void(*func)(int, double, short, int);
CODE:
	func   = INT2PTR(void(*)(int, double, short, int), SvIV(c_func) );
	(*func)(i0, d1, s2, i3);

void
nci_vidfp( c_func, i0, d1, f2, p3 )
	SV* c_func
	int i0
	double d1
	float f2
	void * p3
PREINIT:
	void(*func)(int, double, float, void *);
CODE:
	func   = INT2PTR(void(*)(int, double, float, void *), SvIV(c_func) );
	(*func)(i0, d1, f2, p3);

void
nci_vidfd( c_func, i0, d1, f2, d3 )
	SV* c_func
	int i0
	double d1
	float f2
	double d3
PREINIT:
	void(*func)(int, double, float, double);
CODE:
	func   = INT2PTR(void(*)(int, double, float, double), SvIV(c_func) );
	(*func)(i0, d1, f2, d3);

void
nci_vidfs( c_func, i0, d1, f2, s3 )
	SV* c_func
	int i0
	double d1
	float f2
	short s3
PREINIT:
	void(*func)(int, double, float, short);
CODE:
	func   = INT2PTR(void(*)(int, double, float, short), SvIV(c_func) );
	(*func)(i0, d1, f2, s3);

void
nci_vidff( c_func, i0, d1, f2, f3 )
	SV* c_func
	int i0
	double d1
	float f2
	float f3
PREINIT:
	void(*func)(int, double, float, float);
CODE:
	func   = INT2PTR(void(*)(int, double, float, float), SvIV(c_func) );
	(*func)(i0, d1, f2, f3);

void
nci_vidft( c_func, i0, d1, f2, t3 )
	SV* c_func
	int i0
	double d1
	float f2
	char * t3
PREINIT:
	void(*func)(int, double, float, char *);
CODE:
	func   = INT2PTR(void(*)(int, double, float, char *), SvIV(c_func) );
	(*func)(i0, d1, f2, t3);

void
nci_vidfi( c_func, i0, d1, f2, i3 )
	SV* c_func
	int i0
	double d1
	float f2
	int i3
PREINIT:
	void(*func)(int, double, float, int);
CODE:
	func   = INT2PTR(void(*)(int, double, float, int), SvIV(c_func) );
	(*func)(i0, d1, f2, i3);

void
nci_vidtp( c_func, i0, d1, t2, p3 )
	SV* c_func
	int i0
	double d1
	char * t2
	void * p3
PREINIT:
	void(*func)(int, double, char *, void *);
CODE:
	func   = INT2PTR(void(*)(int, double, char *, void *), SvIV(c_func) );
	(*func)(i0, d1, t2, p3);

void
nci_vidtd( c_func, i0, d1, t2, d3 )
	SV* c_func
	int i0
	double d1
	char * t2
	double d3
PREINIT:
	void(*func)(int, double, char *, double);
CODE:
	func   = INT2PTR(void(*)(int, double, char *, double), SvIV(c_func) );
	(*func)(i0, d1, t2, d3);

void
nci_vidts( c_func, i0, d1, t2, s3 )
	SV* c_func
	int i0
	double d1
	char * t2
	short s3
PREINIT:
	void(*func)(int, double, char *, short);
CODE:
	func   = INT2PTR(void(*)(int, double, char *, short), SvIV(c_func) );
	(*func)(i0, d1, t2, s3);

void
nci_vidtf( c_func, i0, d1, t2, f3 )
	SV* c_func
	int i0
	double d1
	char * t2
	float f3
PREINIT:
	void(*func)(int, double, char *, float);
CODE:
	func   = INT2PTR(void(*)(int, double, char *, float), SvIV(c_func) );
	(*func)(i0, d1, t2, f3);

void
nci_vidtt( c_func, i0, d1, t2, t3 )
	SV* c_func
	int i0
	double d1
	char * t2
	char * t3
PREINIT:
	void(*func)(int, double, char *, char *);
CODE:
	func   = INT2PTR(void(*)(int, double, char *, char *), SvIV(c_func) );
	(*func)(i0, d1, t2, t3);

void
nci_vidti( c_func, i0, d1, t2, i3 )
	SV* c_func
	int i0
	double d1
	char * t2
	int i3
PREINIT:
	void(*func)(int, double, char *, int);
CODE:
	func   = INT2PTR(void(*)(int, double, char *, int), SvIV(c_func) );
	(*func)(i0, d1, t2, i3);

void
nci_vidip( c_func, i0, d1, i2, p3 )
	SV* c_func
	int i0
	double d1
	int i2
	void * p3
PREINIT:
	void(*func)(int, double, int, void *);
CODE:
	func   = INT2PTR(void(*)(int, double, int, void *), SvIV(c_func) );
	(*func)(i0, d1, i2, p3);

void
nci_vidid( c_func, i0, d1, i2, d3 )
	SV* c_func
	int i0
	double d1
	int i2
	double d3
PREINIT:
	void(*func)(int, double, int, double);
CODE:
	func   = INT2PTR(void(*)(int, double, int, double), SvIV(c_func) );
	(*func)(i0, d1, i2, d3);

void
nci_vidis( c_func, i0, d1, i2, s3 )
	SV* c_func
	int i0
	double d1
	int i2
	short s3
PREINIT:
	void(*func)(int, double, int, short);
CODE:
	func   = INT2PTR(void(*)(int, double, int, short), SvIV(c_func) );
	(*func)(i0, d1, i2, s3);

void
nci_vidif( c_func, i0, d1, i2, f3 )
	SV* c_func
	int i0
	double d1
	int i2
	float f3
PREINIT:
	void(*func)(int, double, int, float);
CODE:
	func   = INT2PTR(void(*)(int, double, int, float), SvIV(c_func) );
	(*func)(i0, d1, i2, f3);

void
nci_vidit( c_func, i0, d1, i2, t3 )
	SV* c_func
	int i0
	double d1
	int i2
	char * t3
PREINIT:
	void(*func)(int, double, int, char *);
CODE:
	func   = INT2PTR(void(*)(int, double, int, char *), SvIV(c_func) );
	(*func)(i0, d1, i2, t3);

void
nci_vidii( c_func, i0, d1, i2, i3 )
	SV* c_func
	int i0
	double d1
	int i2
	int i3
PREINIT:
	void(*func)(int, double, int, int);
CODE:
	func   = INT2PTR(void(*)(int, double, int, int), SvIV(c_func) );
	(*func)(i0, d1, i2, i3);

void
nci_vispp( c_func, i0, s1, p2, p3 )
	SV* c_func
	int i0
	short s1
	void * p2
	void * p3
PREINIT:
	void(*func)(int, short, void *, void *);
CODE:
	func   = INT2PTR(void(*)(int, short, void *, void *), SvIV(c_func) );
	(*func)(i0, s1, p2, p3);

void
nci_vispd( c_func, i0, s1, p2, d3 )
	SV* c_func
	int i0
	short s1
	void * p2
	double d3
PREINIT:
	void(*func)(int, short, void *, double);
CODE:
	func   = INT2PTR(void(*)(int, short, void *, double), SvIV(c_func) );
	(*func)(i0, s1, p2, d3);

void
nci_visps( c_func, i0, s1, p2, s3 )
	SV* c_func
	int i0
	short s1
	void * p2
	short s3
PREINIT:
	void(*func)(int, short, void *, short);
CODE:
	func   = INT2PTR(void(*)(int, short, void *, short), SvIV(c_func) );
	(*func)(i0, s1, p2, s3);

void
nci_vispf( c_func, i0, s1, p2, f3 )
	SV* c_func
	int i0
	short s1
	void * p2
	float f3
PREINIT:
	void(*func)(int, short, void *, float);
CODE:
	func   = INT2PTR(void(*)(int, short, void *, float), SvIV(c_func) );
	(*func)(i0, s1, p2, f3);

void
nci_vispt( c_func, i0, s1, p2, t3 )
	SV* c_func
	int i0
	short s1
	void * p2
	char * t3
PREINIT:
	void(*func)(int, short, void *, char *);
CODE:
	func   = INT2PTR(void(*)(int, short, void *, char *), SvIV(c_func) );
	(*func)(i0, s1, p2, t3);

void
nci_vispi( c_func, i0, s1, p2, i3 )
	SV* c_func
	int i0
	short s1
	void * p2
	int i3
PREINIT:
	void(*func)(int, short, void *, int);
CODE:
	func   = INT2PTR(void(*)(int, short, void *, int), SvIV(c_func) );
	(*func)(i0, s1, p2, i3);

void
nci_visdp( c_func, i0, s1, d2, p3 )
	SV* c_func
	int i0
	short s1
	double d2
	void * p3
PREINIT:
	void(*func)(int, short, double, void *);
CODE:
	func   = INT2PTR(void(*)(int, short, double, void *), SvIV(c_func) );
	(*func)(i0, s1, d2, p3);

void
nci_visdd( c_func, i0, s1, d2, d3 )
	SV* c_func
	int i0
	short s1
	double d2
	double d3
PREINIT:
	void(*func)(int, short, double, double);
CODE:
	func   = INT2PTR(void(*)(int, short, double, double), SvIV(c_func) );
	(*func)(i0, s1, d2, d3);

void
nci_visds( c_func, i0, s1, d2, s3 )
	SV* c_func
	int i0
	short s1
	double d2
	short s3
PREINIT:
	void(*func)(int, short, double, short);
CODE:
	func   = INT2PTR(void(*)(int, short, double, short), SvIV(c_func) );
	(*func)(i0, s1, d2, s3);

void
nci_visdf( c_func, i0, s1, d2, f3 )
	SV* c_func
	int i0
	short s1
	double d2
	float f3
PREINIT:
	void(*func)(int, short, double, float);
CODE:
	func   = INT2PTR(void(*)(int, short, double, float), SvIV(c_func) );
	(*func)(i0, s1, d2, f3);

void
nci_visdt( c_func, i0, s1, d2, t3 )
	SV* c_func
	int i0
	short s1
	double d2
	char * t3
PREINIT:
	void(*func)(int, short, double, char *);
CODE:
	func   = INT2PTR(void(*)(int, short, double, char *), SvIV(c_func) );
	(*func)(i0, s1, d2, t3);

void
nci_visdi( c_func, i0, s1, d2, i3 )
	SV* c_func
	int i0
	short s1
	double d2
	int i3
PREINIT:
	void(*func)(int, short, double, int);
CODE:
	func   = INT2PTR(void(*)(int, short, double, int), SvIV(c_func) );
	(*func)(i0, s1, d2, i3);

void
nci_vissp( c_func, i0, s1, s2, p3 )
	SV* c_func
	int i0
	short s1
	short s2
	void * p3
PREINIT:
	void(*func)(int, short, short, void *);
CODE:
	func   = INT2PTR(void(*)(int, short, short, void *), SvIV(c_func) );
	(*func)(i0, s1, s2, p3);

void
nci_vissd( c_func, i0, s1, s2, d3 )
	SV* c_func
	int i0
	short s1
	short s2
	double d3
PREINIT:
	void(*func)(int, short, short, double);
CODE:
	func   = INT2PTR(void(*)(int, short, short, double), SvIV(c_func) );
	(*func)(i0, s1, s2, d3);

void
nci_visss( c_func, i0, s1, s2, s3 )
	SV* c_func
	int i0
	short s1
	short s2
	short s3
PREINIT:
	void(*func)(int, short, short, short);
CODE:
	func   = INT2PTR(void(*)(int, short, short, short), SvIV(c_func) );
	(*func)(i0, s1, s2, s3);

void
nci_vissf( c_func, i0, s1, s2, f3 )
	SV* c_func
	int i0
	short s1
	short s2
	float f3
PREINIT:
	void(*func)(int, short, short, float);
CODE:
	func   = INT2PTR(void(*)(int, short, short, float), SvIV(c_func) );
	(*func)(i0, s1, s2, f3);

void
nci_visst( c_func, i0, s1, s2, t3 )
	SV* c_func
	int i0
	short s1
	short s2
	char * t3
PREINIT:
	void(*func)(int, short, short, char *);
CODE:
	func   = INT2PTR(void(*)(int, short, short, char *), SvIV(c_func) );
	(*func)(i0, s1, s2, t3);

void
nci_vissi( c_func, i0, s1, s2, i3 )
	SV* c_func
	int i0
	short s1
	short s2
	int i3
PREINIT:
	void(*func)(int, short, short, int);
CODE:
	func   = INT2PTR(void(*)(int, short, short, int), SvIV(c_func) );
	(*func)(i0, s1, s2, i3);

void
nci_visfp( c_func, i0, s1, f2, p3 )
	SV* c_func
	int i0
	short s1
	float f2
	void * p3
PREINIT:
	void(*func)(int, short, float, void *);
CODE:
	func   = INT2PTR(void(*)(int, short, float, void *), SvIV(c_func) );
	(*func)(i0, s1, f2, p3);

void
nci_visfd( c_func, i0, s1, f2, d3 )
	SV* c_func
	int i0
	short s1
	float f2
	double d3
PREINIT:
	void(*func)(int, short, float, double);
CODE:
	func   = INT2PTR(void(*)(int, short, float, double), SvIV(c_func) );
	(*func)(i0, s1, f2, d3);

void
nci_visfs( c_func, i0, s1, f2, s3 )
	SV* c_func
	int i0
	short s1
	float f2
	short s3
PREINIT:
	void(*func)(int, short, float, short);
CODE:
	func   = INT2PTR(void(*)(int, short, float, short), SvIV(c_func) );
	(*func)(i0, s1, f2, s3);

void
nci_visff( c_func, i0, s1, f2, f3 )
	SV* c_func
	int i0
	short s1
	float f2
	float f3
PREINIT:
	void(*func)(int, short, float, float);
CODE:
	func   = INT2PTR(void(*)(int, short, float, float), SvIV(c_func) );
	(*func)(i0, s1, f2, f3);

void
nci_visft( c_func, i0, s1, f2, t3 )
	SV* c_func
	int i0
	short s1
	float f2
	char * t3
PREINIT:
	void(*func)(int, short, float, char *);
CODE:
	func   = INT2PTR(void(*)(int, short, float, char *), SvIV(c_func) );
	(*func)(i0, s1, f2, t3);

void
nci_visfi( c_func, i0, s1, f2, i3 )
	SV* c_func
	int i0
	short s1
	float f2
	int i3
PREINIT:
	void(*func)(int, short, float, int);
CODE:
	func   = INT2PTR(void(*)(int, short, float, int), SvIV(c_func) );
	(*func)(i0, s1, f2, i3);

void
nci_vistp( c_func, i0, s1, t2, p3 )
	SV* c_func
	int i0
	short s1
	char * t2
	void * p3
PREINIT:
	void(*func)(int, short, char *, void *);
CODE:
	func   = INT2PTR(void(*)(int, short, char *, void *), SvIV(c_func) );
	(*func)(i0, s1, t2, p3);

void
nci_vistd( c_func, i0, s1, t2, d3 )
	SV* c_func
	int i0
	short s1
	char * t2
	double d3
PREINIT:
	void(*func)(int, short, char *, double);
CODE:
	func   = INT2PTR(void(*)(int, short, char *, double), SvIV(c_func) );
	(*func)(i0, s1, t2, d3);

void
nci_vists( c_func, i0, s1, t2, s3 )
	SV* c_func
	int i0
	short s1
	char * t2
	short s3
PREINIT:
	void(*func)(int, short, char *, short);
CODE:
	func   = INT2PTR(void(*)(int, short, char *, short), SvIV(c_func) );
	(*func)(i0, s1, t2, s3);

void
nci_vistf( c_func, i0, s1, t2, f3 )
	SV* c_func
	int i0
	short s1
	char * t2
	float f3
PREINIT:
	void(*func)(int, short, char *, float);
CODE:
	func   = INT2PTR(void(*)(int, short, char *, float), SvIV(c_func) );
	(*func)(i0, s1, t2, f3);

void
nci_vistt( c_func, i0, s1, t2, t3 )
	SV* c_func
	int i0
	short s1
	char * t2
	char * t3
PREINIT:
	void(*func)(int, short, char *, char *);
CODE:
	func   = INT2PTR(void(*)(int, short, char *, char *), SvIV(c_func) );
	(*func)(i0, s1, t2, t3);

void
nci_visti( c_func, i0, s1, t2, i3 )
	SV* c_func
	int i0
	short s1
	char * t2
	int i3
PREINIT:
	void(*func)(int, short, char *, int);
CODE:
	func   = INT2PTR(void(*)(int, short, char *, int), SvIV(c_func) );
	(*func)(i0, s1, t2, i3);

void
nci_visip( c_func, i0, s1, i2, p3 )
	SV* c_func
	int i0
	short s1
	int i2
	void * p3
PREINIT:
	void(*func)(int, short, int, void *);
CODE:
	func   = INT2PTR(void(*)(int, short, int, void *), SvIV(c_func) );
	(*func)(i0, s1, i2, p3);

void
nci_visid( c_func, i0, s1, i2, d3 )
	SV* c_func
	int i0
	short s1
	int i2
	double d3
PREINIT:
	void(*func)(int, short, int, double);
CODE:
	func   = INT2PTR(void(*)(int, short, int, double), SvIV(c_func) );
	(*func)(i0, s1, i2, d3);

void
nci_visis( c_func, i0, s1, i2, s3 )
	SV* c_func
	int i0
	short s1
	int i2
	short s3
PREINIT:
	void(*func)(int, short, int, short);
CODE:
	func   = INT2PTR(void(*)(int, short, int, short), SvIV(c_func) );
	(*func)(i0, s1, i2, s3);

void
nci_visif( c_func, i0, s1, i2, f3 )
	SV* c_func
	int i0
	short s1
	int i2
	float f3
PREINIT:
	void(*func)(int, short, int, float);
CODE:
	func   = INT2PTR(void(*)(int, short, int, float), SvIV(c_func) );
	(*func)(i0, s1, i2, f3);

void
nci_visit( c_func, i0, s1, i2, t3 )
	SV* c_func
	int i0
	short s1
	int i2
	char * t3
PREINIT:
	void(*func)(int, short, int, char *);
CODE:
	func   = INT2PTR(void(*)(int, short, int, char *), SvIV(c_func) );
	(*func)(i0, s1, i2, t3);

void
nci_visii( c_func, i0, s1, i2, i3 )
	SV* c_func
	int i0
	short s1
	int i2
	int i3
PREINIT:
	void(*func)(int, short, int, int);
CODE:
	func   = INT2PTR(void(*)(int, short, int, int), SvIV(c_func) );
	(*func)(i0, s1, i2, i3);

void
nci_vifpp( c_func, i0, f1, p2, p3 )
	SV* c_func
	int i0
	float f1
	void * p2
	void * p3
PREINIT:
	void(*func)(int, float, void *, void *);
CODE:
	func   = INT2PTR(void(*)(int, float, void *, void *), SvIV(c_func) );
	(*func)(i0, f1, p2, p3);

void
nci_vifpd( c_func, i0, f1, p2, d3 )
	SV* c_func
	int i0
	float f1
	void * p2
	double d3
PREINIT:
	void(*func)(int, float, void *, double);
CODE:
	func   = INT2PTR(void(*)(int, float, void *, double), SvIV(c_func) );
	(*func)(i0, f1, p2, d3);

void
nci_vifps( c_func, i0, f1, p2, s3 )
	SV* c_func
	int i0
	float f1
	void * p2
	short s3
PREINIT:
	void(*func)(int, float, void *, short);
CODE:
	func   = INT2PTR(void(*)(int, float, void *, short), SvIV(c_func) );
	(*func)(i0, f1, p2, s3);

void
nci_vifpf( c_func, i0, f1, p2, f3 )
	SV* c_func
	int i0
	float f1
	void * p2
	float f3
PREINIT:
	void(*func)(int, float, void *, float);
CODE:
	func   = INT2PTR(void(*)(int, float, void *, float), SvIV(c_func) );
	(*func)(i0, f1, p2, f3);

void
nci_vifpt( c_func, i0, f1, p2, t3 )
	SV* c_func
	int i0
	float f1
	void * p2
	char * t3
PREINIT:
	void(*func)(int, float, void *, char *);
CODE:
	func   = INT2PTR(void(*)(int, float, void *, char *), SvIV(c_func) );
	(*func)(i0, f1, p2, t3);

void
nci_vifpi( c_func, i0, f1, p2, i3 )
	SV* c_func
	int i0
	float f1
	void * p2
	int i3
PREINIT:
	void(*func)(int, float, void *, int);
CODE:
	func   = INT2PTR(void(*)(int, float, void *, int), SvIV(c_func) );
	(*func)(i0, f1, p2, i3);

void
nci_vifdp( c_func, i0, f1, d2, p3 )
	SV* c_func
	int i0
	float f1
	double d2
	void * p3
PREINIT:
	void(*func)(int, float, double, void *);
CODE:
	func   = INT2PTR(void(*)(int, float, double, void *), SvIV(c_func) );
	(*func)(i0, f1, d2, p3);

void
nci_vifdd( c_func, i0, f1, d2, d3 )
	SV* c_func
	int i0
	float f1
	double d2
	double d3
PREINIT:
	void(*func)(int, float, double, double);
CODE:
	func   = INT2PTR(void(*)(int, float, double, double), SvIV(c_func) );
	(*func)(i0, f1, d2, d3);

void
nci_vifds( c_func, i0, f1, d2, s3 )
	SV* c_func
	int i0
	float f1
	double d2
	short s3
PREINIT:
	void(*func)(int, float, double, short);
CODE:
	func   = INT2PTR(void(*)(int, float, double, short), SvIV(c_func) );
	(*func)(i0, f1, d2, s3);

void
nci_vifdf( c_func, i0, f1, d2, f3 )
	SV* c_func
	int i0
	float f1
	double d2
	float f3
PREINIT:
	void(*func)(int, float, double, float);
CODE:
	func   = INT2PTR(void(*)(int, float, double, float), SvIV(c_func) );
	(*func)(i0, f1, d2, f3);

void
nci_vifdt( c_func, i0, f1, d2, t3 )
	SV* c_func
	int i0
	float f1
	double d2
	char * t3
PREINIT:
	void(*func)(int, float, double, char *);
CODE:
	func   = INT2PTR(void(*)(int, float, double, char *), SvIV(c_func) );
	(*func)(i0, f1, d2, t3);

void
nci_vifdi( c_func, i0, f1, d2, i3 )
	SV* c_func
	int i0
	float f1
	double d2
	int i3
PREINIT:
	void(*func)(int, float, double, int);
CODE:
	func   = INT2PTR(void(*)(int, float, double, int), SvIV(c_func) );
	(*func)(i0, f1, d2, i3);

void
nci_vifsp( c_func, i0, f1, s2, p3 )
	SV* c_func
	int i0
	float f1
	short s2
	void * p3
PREINIT:
	void(*func)(int, float, short, void *);
CODE:
	func   = INT2PTR(void(*)(int, float, short, void *), SvIV(c_func) );
	(*func)(i0, f1, s2, p3);

void
nci_vifsd( c_func, i0, f1, s2, d3 )
	SV* c_func
	int i0
	float f1
	short s2
	double d3
PREINIT:
	void(*func)(int, float, short, double);
CODE:
	func   = INT2PTR(void(*)(int, float, short, double), SvIV(c_func) );
	(*func)(i0, f1, s2, d3);

void
nci_vifss( c_func, i0, f1, s2, s3 )
	SV* c_func
	int i0
	float f1
	short s2
	short s3
PREINIT:
	void(*func)(int, float, short, short);
CODE:
	func   = INT2PTR(void(*)(int, float, short, short), SvIV(c_func) );
	(*func)(i0, f1, s2, s3);

void
nci_vifsf( c_func, i0, f1, s2, f3 )
	SV* c_func
	int i0
	float f1
	short s2
	float f3
PREINIT:
	void(*func)(int, float, short, float);
CODE:
	func   = INT2PTR(void(*)(int, float, short, float), SvIV(c_func) );
	(*func)(i0, f1, s2, f3);

void
nci_vifst( c_func, i0, f1, s2, t3 )
	SV* c_func
	int i0
	float f1
	short s2
	char * t3
PREINIT:
	void(*func)(int, float, short, char *);
CODE:
	func   = INT2PTR(void(*)(int, float, short, char *), SvIV(c_func) );
	(*func)(i0, f1, s2, t3);

void
nci_vifsi( c_func, i0, f1, s2, i3 )
	SV* c_func
	int i0
	float f1
	short s2
	int i3
PREINIT:
	void(*func)(int, float, short, int);
CODE:
	func   = INT2PTR(void(*)(int, float, short, int), SvIV(c_func) );
	(*func)(i0, f1, s2, i3);

void
nci_viffp( c_func, i0, f1, f2, p3 )
	SV* c_func
	int i0
	float f1
	float f2
	void * p3
PREINIT:
	void(*func)(int, float, float, void *);
CODE:
	func   = INT2PTR(void(*)(int, float, float, void *), SvIV(c_func) );
	(*func)(i0, f1, f2, p3);

void
nci_viffd( c_func, i0, f1, f2, d3 )
	SV* c_func
	int i0
	float f1
	float f2
	double d3
PREINIT:
	void(*func)(int, float, float, double);
CODE:
	func   = INT2PTR(void(*)(int, float, float, double), SvIV(c_func) );
	(*func)(i0, f1, f2, d3);

void
nci_viffs( c_func, i0, f1, f2, s3 )
	SV* c_func
	int i0
	float f1
	float f2
	short s3
PREINIT:
	void(*func)(int, float, float, short);
CODE:
	func   = INT2PTR(void(*)(int, float, float, short), SvIV(c_func) );
	(*func)(i0, f1, f2, s3);

void
nci_vifff( c_func, i0, f1, f2, f3 )
	SV* c_func
	int i0
	float f1
	float f2
	float f3
PREINIT:
	void(*func)(int, float, float, float);
CODE:
	func   = INT2PTR(void(*)(int, float, float, float), SvIV(c_func) );
	(*func)(i0, f1, f2, f3);

void
nci_vifft( c_func, i0, f1, f2, t3 )
	SV* c_func
	int i0
	float f1
	float f2
	char * t3
PREINIT:
	void(*func)(int, float, float, char *);
CODE:
	func   = INT2PTR(void(*)(int, float, float, char *), SvIV(c_func) );
	(*func)(i0, f1, f2, t3);

void
nci_viffi( c_func, i0, f1, f2, i3 )
	SV* c_func
	int i0
	float f1
	float f2
	int i3
PREINIT:
	void(*func)(int, float, float, int);
CODE:
	func   = INT2PTR(void(*)(int, float, float, int), SvIV(c_func) );
	(*func)(i0, f1, f2, i3);

void
nci_viftp( c_func, i0, f1, t2, p3 )
	SV* c_func
	int i0
	float f1
	char * t2
	void * p3
PREINIT:
	void(*func)(int, float, char *, void *);
CODE:
	func   = INT2PTR(void(*)(int, float, char *, void *), SvIV(c_func) );
	(*func)(i0, f1, t2, p3);

void
nci_viftd( c_func, i0, f1, t2, d3 )
	SV* c_func
	int i0
	float f1
	char * t2
	double d3
PREINIT:
	void(*func)(int, float, char *, double);
CODE:
	func   = INT2PTR(void(*)(int, float, char *, double), SvIV(c_func) );
	(*func)(i0, f1, t2, d3);

void
nci_vifts( c_func, i0, f1, t2, s3 )
	SV* c_func
	int i0
	float f1
	char * t2
	short s3
PREINIT:
	void(*func)(int, float, char *, short);
CODE:
	func   = INT2PTR(void(*)(int, float, char *, short), SvIV(c_func) );
	(*func)(i0, f1, t2, s3);

void
nci_viftf( c_func, i0, f1, t2, f3 )
	SV* c_func
	int i0
	float f1
	char * t2
	float f3
PREINIT:
	void(*func)(int, float, char *, float);
CODE:
	func   = INT2PTR(void(*)(int, float, char *, float), SvIV(c_func) );
	(*func)(i0, f1, t2, f3);

void
nci_viftt( c_func, i0, f1, t2, t3 )
	SV* c_func
	int i0
	float f1
	char * t2
	char * t3
PREINIT:
	void(*func)(int, float, char *, char *);
CODE:
	func   = INT2PTR(void(*)(int, float, char *, char *), SvIV(c_func) );
	(*func)(i0, f1, t2, t3);

void
nci_vifti( c_func, i0, f1, t2, i3 )
	SV* c_func
	int i0
	float f1
	char * t2
	int i3
PREINIT:
	void(*func)(int, float, char *, int);
CODE:
	func   = INT2PTR(void(*)(int, float, char *, int), SvIV(c_func) );
	(*func)(i0, f1, t2, i3);

void
nci_vifip( c_func, i0, f1, i2, p3 )
	SV* c_func
	int i0
	float f1
	int i2
	void * p3
PREINIT:
	void(*func)(int, float, int, void *);
CODE:
	func   = INT2PTR(void(*)(int, float, int, void *), SvIV(c_func) );
	(*func)(i0, f1, i2, p3);

void
nci_vifid( c_func, i0, f1, i2, d3 )
	SV* c_func
	int i0
	float f1
	int i2
	double d3
PREINIT:
	void(*func)(int, float, int, double);
CODE:
	func   = INT2PTR(void(*)(int, float, int, double), SvIV(c_func) );
	(*func)(i0, f1, i2, d3);

void
nci_vifis( c_func, i0, f1, i2, s3 )
	SV* c_func
	int i0
	float f1
	int i2
	short s3
PREINIT:
	void(*func)(int, float, int, short);
CODE:
	func   = INT2PTR(void(*)(int, float, int, short), SvIV(c_func) );
	(*func)(i0, f1, i2, s3);

void
nci_vifif( c_func, i0, f1, i2, f3 )
	SV* c_func
	int i0
	float f1
	int i2
	float f3
PREINIT:
	void(*func)(int, float, int, float);
CODE:
	func   = INT2PTR(void(*)(int, float, int, float), SvIV(c_func) );
	(*func)(i0, f1, i2, f3);

void
nci_vifit( c_func, i0, f1, i2, t3 )
	SV* c_func
	int i0
	float f1
	int i2
	char * t3
PREINIT:
	void(*func)(int, float, int, char *);
CODE:
	func   = INT2PTR(void(*)(int, float, int, char *), SvIV(c_func) );
	(*func)(i0, f1, i2, t3);

void
nci_vifii( c_func, i0, f1, i2, i3 )
	SV* c_func
	int i0
	float f1
	int i2
	int i3
PREINIT:
	void(*func)(int, float, int, int);
CODE:
	func   = INT2PTR(void(*)(int, float, int, int), SvIV(c_func) );
	(*func)(i0, f1, i2, i3);

void
nci_vitpp( c_func, i0, t1, p2, p3 )
	SV* c_func
	int i0
	char * t1
	void * p2
	void * p3
PREINIT:
	void(*func)(int, char *, void *, void *);
CODE:
	func   = INT2PTR(void(*)(int, char *, void *, void *), SvIV(c_func) );
	(*func)(i0, t1, p2, p3);

void
nci_vitpd( c_func, i0, t1, p2, d3 )
	SV* c_func
	int i0
	char * t1
	void * p2
	double d3
PREINIT:
	void(*func)(int, char *, void *, double);
CODE:
	func   = INT2PTR(void(*)(int, char *, void *, double), SvIV(c_func) );
	(*func)(i0, t1, p2, d3);

void
nci_vitps( c_func, i0, t1, p2, s3 )
	SV* c_func
	int i0
	char * t1
	void * p2
	short s3
PREINIT:
	void(*func)(int, char *, void *, short);
CODE:
	func   = INT2PTR(void(*)(int, char *, void *, short), SvIV(c_func) );
	(*func)(i0, t1, p2, s3);

void
nci_vitpf( c_func, i0, t1, p2, f3 )
	SV* c_func
	int i0
	char * t1
	void * p2
	float f3
PREINIT:
	void(*func)(int, char *, void *, float);
CODE:
	func   = INT2PTR(void(*)(int, char *, void *, float), SvIV(c_func) );
	(*func)(i0, t1, p2, f3);

void
nci_vitpt( c_func, i0, t1, p2, t3 )
	SV* c_func
	int i0
	char * t1
	void * p2
	char * t3
PREINIT:
	void(*func)(int, char *, void *, char *);
CODE:
	func   = INT2PTR(void(*)(int, char *, void *, char *), SvIV(c_func) );
	(*func)(i0, t1, p2, t3);

void
nci_vitpi( c_func, i0, t1, p2, i3 )
	SV* c_func
	int i0
	char * t1
	void * p2
	int i3
PREINIT:
	void(*func)(int, char *, void *, int);
CODE:
	func   = INT2PTR(void(*)(int, char *, void *, int), SvIV(c_func) );
	(*func)(i0, t1, p2, i3);

void
nci_vitdp( c_func, i0, t1, d2, p3 )
	SV* c_func
	int i0
	char * t1
	double d2
	void * p3
PREINIT:
	void(*func)(int, char *, double, void *);
CODE:
	func   = INT2PTR(void(*)(int, char *, double, void *), SvIV(c_func) );
	(*func)(i0, t1, d2, p3);

void
nci_vitdd( c_func, i0, t1, d2, d3 )
	SV* c_func
	int i0
	char * t1
	double d2
	double d3
PREINIT:
	void(*func)(int, char *, double, double);
CODE:
	func   = INT2PTR(void(*)(int, char *, double, double), SvIV(c_func) );
	(*func)(i0, t1, d2, d3);

void
nci_vitds( c_func, i0, t1, d2, s3 )
	SV* c_func
	int i0
	char * t1
	double d2
	short s3
PREINIT:
	void(*func)(int, char *, double, short);
CODE:
	func   = INT2PTR(void(*)(int, char *, double, short), SvIV(c_func) );
	(*func)(i0, t1, d2, s3);

void
nci_vitdf( c_func, i0, t1, d2, f3 )
	SV* c_func
	int i0
	char * t1
	double d2
	float f3
PREINIT:
	void(*func)(int, char *, double, float);
CODE:
	func   = INT2PTR(void(*)(int, char *, double, float), SvIV(c_func) );
	(*func)(i0, t1, d2, f3);

void
nci_vitdt( c_func, i0, t1, d2, t3 )
	SV* c_func
	int i0
	char * t1
	double d2
	char * t3
PREINIT:
	void(*func)(int, char *, double, char *);
CODE:
	func   = INT2PTR(void(*)(int, char *, double, char *), SvIV(c_func) );
	(*func)(i0, t1, d2, t3);

void
nci_vitdi( c_func, i0, t1, d2, i3 )
	SV* c_func
	int i0
	char * t1
	double d2
	int i3
PREINIT:
	void(*func)(int, char *, double, int);
CODE:
	func   = INT2PTR(void(*)(int, char *, double, int), SvIV(c_func) );
	(*func)(i0, t1, d2, i3);

void
nci_vitsp( c_func, i0, t1, s2, p3 )
	SV* c_func
	int i0
	char * t1
	short s2
	void * p3
PREINIT:
	void(*func)(int, char *, short, void *);
CODE:
	func   = INT2PTR(void(*)(int, char *, short, void *), SvIV(c_func) );
	(*func)(i0, t1, s2, p3);

void
nci_vitsd( c_func, i0, t1, s2, d3 )
	SV* c_func
	int i0
	char * t1
	short s2
	double d3
PREINIT:
	void(*func)(int, char *, short, double);
CODE:
	func   = INT2PTR(void(*)(int, char *, short, double), SvIV(c_func) );
	(*func)(i0, t1, s2, d3);

void
nci_vitss( c_func, i0, t1, s2, s3 )
	SV* c_func
	int i0
	char * t1
	short s2
	short s3
PREINIT:
	void(*func)(int, char *, short, short);
CODE:
	func   = INT2PTR(void(*)(int, char *, short, short), SvIV(c_func) );
	(*func)(i0, t1, s2, s3);

void
nci_vitsf( c_func, i0, t1, s2, f3 )
	SV* c_func
	int i0
	char * t1
	short s2
	float f3
PREINIT:
	void(*func)(int, char *, short, float);
CODE:
	func   = INT2PTR(void(*)(int, char *, short, float), SvIV(c_func) );
	(*func)(i0, t1, s2, f3);

void
nci_vitst( c_func, i0, t1, s2, t3 )
	SV* c_func
	int i0
	char * t1
	short s2
	char * t3
PREINIT:
	void(*func)(int, char *, short, char *);
CODE:
	func   = INT2PTR(void(*)(int, char *, short, char *), SvIV(c_func) );
	(*func)(i0, t1, s2, t3);

void
nci_vitsi( c_func, i0, t1, s2, i3 )
	SV* c_func
	int i0
	char * t1
	short s2
	int i3
PREINIT:
	void(*func)(int, char *, short, int);
CODE:
	func   = INT2PTR(void(*)(int, char *, short, int), SvIV(c_func) );
	(*func)(i0, t1, s2, i3);

void
nci_vitfp( c_func, i0, t1, f2, p3 )
	SV* c_func
	int i0
	char * t1
	float f2
	void * p3
PREINIT:
	void(*func)(int, char *, float, void *);
CODE:
	func   = INT2PTR(void(*)(int, char *, float, void *), SvIV(c_func) );
	(*func)(i0, t1, f2, p3);

void
nci_vitfd( c_func, i0, t1, f2, d3 )
	SV* c_func
	int i0
	char * t1
	float f2
	double d3
PREINIT:
	void(*func)(int, char *, float, double);
CODE:
	func   = INT2PTR(void(*)(int, char *, float, double), SvIV(c_func) );
	(*func)(i0, t1, f2, d3);

void
nci_vitfs( c_func, i0, t1, f2, s3 )
	SV* c_func
	int i0
	char * t1
	float f2
	short s3
PREINIT:
	void(*func)(int, char *, float, short);
CODE:
	func   = INT2PTR(void(*)(int, char *, float, short), SvIV(c_func) );
	(*func)(i0, t1, f2, s3);

void
nci_vitff( c_func, i0, t1, f2, f3 )
	SV* c_func
	int i0
	char * t1
	float f2
	float f3
PREINIT:
	void(*func)(int, char *, float, float);
CODE:
	func   = INT2PTR(void(*)(int, char *, float, float), SvIV(c_func) );
	(*func)(i0, t1, f2, f3);

void
nci_vitft( c_func, i0, t1, f2, t3 )
	SV* c_func
	int i0
	char * t1
	float f2
	char * t3
PREINIT:
	void(*func)(int, char *, float, char *);
CODE:
	func   = INT2PTR(void(*)(int, char *, float, char *), SvIV(c_func) );
	(*func)(i0, t1, f2, t3);

void
nci_vitfi( c_func, i0, t1, f2, i3 )
	SV* c_func
	int i0
	char * t1
	float f2
	int i3
PREINIT:
	void(*func)(int, char *, float, int);
CODE:
	func   = INT2PTR(void(*)(int, char *, float, int), SvIV(c_func) );
	(*func)(i0, t1, f2, i3);

void
nci_vittp( c_func, i0, t1, t2, p3 )
	SV* c_func
	int i0
	char * t1
	char * t2
	void * p3
PREINIT:
	void(*func)(int, char *, char *, void *);
CODE:
	func   = INT2PTR(void(*)(int, char *, char *, void *), SvIV(c_func) );
	(*func)(i0, t1, t2, p3);

void
nci_vittd( c_func, i0, t1, t2, d3 )
	SV* c_func
	int i0
	char * t1
	char * t2
	double d3
PREINIT:
	void(*func)(int, char *, char *, double);
CODE:
	func   = INT2PTR(void(*)(int, char *, char *, double), SvIV(c_func) );
	(*func)(i0, t1, t2, d3);

void
nci_vitts( c_func, i0, t1, t2, s3 )
	SV* c_func
	int i0
	char * t1
	char * t2
	short s3
PREINIT:
	void(*func)(int, char *, char *, short);
CODE:
	func   = INT2PTR(void(*)(int, char *, char *, short), SvIV(c_func) );
	(*func)(i0, t1, t2, s3);

void
nci_vittf( c_func, i0, t1, t2, f3 )
	SV* c_func
	int i0
	char * t1
	char * t2
	float f3
PREINIT:
	void(*func)(int, char *, char *, float);
CODE:
	func   = INT2PTR(void(*)(int, char *, char *, float), SvIV(c_func) );
	(*func)(i0, t1, t2, f3);

void
nci_vittt( c_func, i0, t1, t2, t3 )
	SV* c_func
	int i0
	char * t1
	char * t2
	char * t3
PREINIT:
	void(*func)(int, char *, char *, char *);
CODE:
	func   = INT2PTR(void(*)(int, char *, char *, char *), SvIV(c_func) );
	(*func)(i0, t1, t2, t3);

void
nci_vitti( c_func, i0, t1, t2, i3 )
	SV* c_func
	int i0
	char * t1
	char * t2
	int i3
PREINIT:
	void(*func)(int, char *, char *, int);
CODE:
	func   = INT2PTR(void(*)(int, char *, char *, int), SvIV(c_func) );
	(*func)(i0, t1, t2, i3);

void
nci_vitip( c_func, i0, t1, i2, p3 )
	SV* c_func
	int i0
	char * t1
	int i2
	void * p3
PREINIT:
	void(*func)(int, char *, int, void *);
CODE:
	func   = INT2PTR(void(*)(int, char *, int, void *), SvIV(c_func) );
	(*func)(i0, t1, i2, p3);

void
nci_vitid( c_func, i0, t1, i2, d3 )
	SV* c_func
	int i0
	char * t1
	int i2
	double d3
PREINIT:
	void(*func)(int, char *, int, double);
CODE:
	func   = INT2PTR(void(*)(int, char *, int, double), SvIV(c_func) );
	(*func)(i0, t1, i2, d3);

void
nci_vitis( c_func, i0, t1, i2, s3 )
	SV* c_func
	int i0
	char * t1
	int i2
	short s3
PREINIT:
	void(*func)(int, char *, int, short);
CODE:
	func   = INT2PTR(void(*)(int, char *, int, short), SvIV(c_func) );
	(*func)(i0, t1, i2, s3);

void
nci_vitif( c_func, i0, t1, i2, f3 )
	SV* c_func
	int i0
	char * t1
	int i2
	float f3
PREINIT:
	void(*func)(int, char *, int, float);
CODE:
	func   = INT2PTR(void(*)(int, char *, int, float), SvIV(c_func) );
	(*func)(i0, t1, i2, f3);

void
nci_vitit( c_func, i0, t1, i2, t3 )
	SV* c_func
	int i0
	char * t1
	int i2
	char * t3
PREINIT:
	void(*func)(int, char *, int, char *);
CODE:
	func   = INT2PTR(void(*)(int, char *, int, char *), SvIV(c_func) );
	(*func)(i0, t1, i2, t3);

void
nci_vitii( c_func, i0, t1, i2, i3 )
	SV* c_func
	int i0
	char * t1
	int i2
	int i3
PREINIT:
	void(*func)(int, char *, int, int);
CODE:
	func   = INT2PTR(void(*)(int, char *, int, int), SvIV(c_func) );
	(*func)(i0, t1, i2, i3);

void
nci_viipp( c_func, i0, i1, p2, p3 )
	SV* c_func
	int i0
	int i1
	void * p2
	void * p3
PREINIT:
	void(*func)(int, int, void *, void *);
CODE:
	func   = INT2PTR(void(*)(int, int, void *, void *), SvIV(c_func) );
	(*func)(i0, i1, p2, p3);

void
nci_viipd( c_func, i0, i1, p2, d3 )
	SV* c_func
	int i0
	int i1
	void * p2
	double d3
PREINIT:
	void(*func)(int, int, void *, double);
CODE:
	func   = INT2PTR(void(*)(int, int, void *, double), SvIV(c_func) );
	(*func)(i0, i1, p2, d3);

void
nci_viips( c_func, i0, i1, p2, s3 )
	SV* c_func
	int i0
	int i1
	void * p2
	short s3
PREINIT:
	void(*func)(int, int, void *, short);
CODE:
	func   = INT2PTR(void(*)(int, int, void *, short), SvIV(c_func) );
	(*func)(i0, i1, p2, s3);

void
nci_viipf( c_func, i0, i1, p2, f3 )
	SV* c_func
	int i0
	int i1
	void * p2
	float f3
PREINIT:
	void(*func)(int, int, void *, float);
CODE:
	func   = INT2PTR(void(*)(int, int, void *, float), SvIV(c_func) );
	(*func)(i0, i1, p2, f3);

void
nci_viipt( c_func, i0, i1, p2, t3 )
	SV* c_func
	int i0
	int i1
	void * p2
	char * t3
PREINIT:
	void(*func)(int, int, void *, char *);
CODE:
	func   = INT2PTR(void(*)(int, int, void *, char *), SvIV(c_func) );
	(*func)(i0, i1, p2, t3);

void
nci_viipi( c_func, i0, i1, p2, i3 )
	SV* c_func
	int i0
	int i1
	void * p2
	int i3
PREINIT:
	void(*func)(int, int, void *, int);
CODE:
	func   = INT2PTR(void(*)(int, int, void *, int), SvIV(c_func) );
	(*func)(i0, i1, p2, i3);

void
nci_viidp( c_func, i0, i1, d2, p3 )
	SV* c_func
	int i0
	int i1
	double d2
	void * p3
PREINIT:
	void(*func)(int, int, double, void *);
CODE:
	func   = INT2PTR(void(*)(int, int, double, void *), SvIV(c_func) );
	(*func)(i0, i1, d2, p3);

void
nci_viidd( c_func, i0, i1, d2, d3 )
	SV* c_func
	int i0
	int i1
	double d2
	double d3
PREINIT:
	void(*func)(int, int, double, double);
CODE:
	func   = INT2PTR(void(*)(int, int, double, double), SvIV(c_func) );
	(*func)(i0, i1, d2, d3);

void
nci_viids( c_func, i0, i1, d2, s3 )
	SV* c_func
	int i0
	int i1
	double d2
	short s3
PREINIT:
	void(*func)(int, int, double, short);
CODE:
	func   = INT2PTR(void(*)(int, int, double, short), SvIV(c_func) );
	(*func)(i0, i1, d2, s3);

void
nci_viidf( c_func, i0, i1, d2, f3 )
	SV* c_func
	int i0
	int i1
	double d2
	float f3
PREINIT:
	void(*func)(int, int, double, float);
CODE:
	func   = INT2PTR(void(*)(int, int, double, float), SvIV(c_func) );
	(*func)(i0, i1, d2, f3);

void
nci_viidt( c_func, i0, i1, d2, t3 )
	SV* c_func
	int i0
	int i1
	double d2
	char * t3
PREINIT:
	void(*func)(int, int, double, char *);
CODE:
	func   = INT2PTR(void(*)(int, int, double, char *), SvIV(c_func) );
	(*func)(i0, i1, d2, t3);

void
nci_viidi( c_func, i0, i1, d2, i3 )
	SV* c_func
	int i0
	int i1
	double d2
	int i3
PREINIT:
	void(*func)(int, int, double, int);
CODE:
	func   = INT2PTR(void(*)(int, int, double, int), SvIV(c_func) );
	(*func)(i0, i1, d2, i3);

void
nci_viisp( c_func, i0, i1, s2, p3 )
	SV* c_func
	int i0
	int i1
	short s2
	void * p3
PREINIT:
	void(*func)(int, int, short, void *);
CODE:
	func   = INT2PTR(void(*)(int, int, short, void *), SvIV(c_func) );
	(*func)(i0, i1, s2, p3);

void
nci_viisd( c_func, i0, i1, s2, d3 )
	SV* c_func
	int i0
	int i1
	short s2
	double d3
PREINIT:
	void(*func)(int, int, short, double);
CODE:
	func   = INT2PTR(void(*)(int, int, short, double), SvIV(c_func) );
	(*func)(i0, i1, s2, d3);

void
nci_viiss( c_func, i0, i1, s2, s3 )
	SV* c_func
	int i0
	int i1
	short s2
	short s3
PREINIT:
	void(*func)(int, int, short, short);
CODE:
	func   = INT2PTR(void(*)(int, int, short, short), SvIV(c_func) );
	(*func)(i0, i1, s2, s3);

void
nci_viisf( c_func, i0, i1, s2, f3 )
	SV* c_func
	int i0
	int i1
	short s2
	float f3
PREINIT:
	void(*func)(int, int, short, float);
CODE:
	func   = INT2PTR(void(*)(int, int, short, float), SvIV(c_func) );
	(*func)(i0, i1, s2, f3);

void
nci_viist( c_func, i0, i1, s2, t3 )
	SV* c_func
	int i0
	int i1
	short s2
	char * t3
PREINIT:
	void(*func)(int, int, short, char *);
CODE:
	func   = INT2PTR(void(*)(int, int, short, char *), SvIV(c_func) );
	(*func)(i0, i1, s2, t3);

void
nci_viisi( c_func, i0, i1, s2, i3 )
	SV* c_func
	int i0
	int i1
	short s2
	int i3
PREINIT:
	void(*func)(int, int, short, int);
CODE:
	func   = INT2PTR(void(*)(int, int, short, int), SvIV(c_func) );
	(*func)(i0, i1, s2, i3);

void
nci_viifp( c_func, i0, i1, f2, p3 )
	SV* c_func
	int i0
	int i1
	float f2
	void * p3
PREINIT:
	void(*func)(int, int, float, void *);
CODE:
	func   = INT2PTR(void(*)(int, int, float, void *), SvIV(c_func) );
	(*func)(i0, i1, f2, p3);

void
nci_viifd( c_func, i0, i1, f2, d3 )
	SV* c_func
	int i0
	int i1
	float f2
	double d3
PREINIT:
	void(*func)(int, int, float, double);
CODE:
	func   = INT2PTR(void(*)(int, int, float, double), SvIV(c_func) );
	(*func)(i0, i1, f2, d3);

void
nci_viifs( c_func, i0, i1, f2, s3 )
	SV* c_func
	int i0
	int i1
	float f2
	short s3
PREINIT:
	void(*func)(int, int, float, short);
CODE:
	func   = INT2PTR(void(*)(int, int, float, short), SvIV(c_func) );
	(*func)(i0, i1, f2, s3);

void
nci_viiff( c_func, i0, i1, f2, f3 )
	SV* c_func
	int i0
	int i1
	float f2
	float f3
PREINIT:
	void(*func)(int, int, float, float);
CODE:
	func   = INT2PTR(void(*)(int, int, float, float), SvIV(c_func) );
	(*func)(i0, i1, f2, f3);

void
nci_viift( c_func, i0, i1, f2, t3 )
	SV* c_func
	int i0
	int i1
	float f2
	char * t3
PREINIT:
	void(*func)(int, int, float, char *);
CODE:
	func   = INT2PTR(void(*)(int, int, float, char *), SvIV(c_func) );
	(*func)(i0, i1, f2, t3);

void
nci_viifi( c_func, i0, i1, f2, i3 )
	SV* c_func
	int i0
	int i1
	float f2
	int i3
PREINIT:
	void(*func)(int, int, float, int);
CODE:
	func   = INT2PTR(void(*)(int, int, float, int), SvIV(c_func) );
	(*func)(i0, i1, f2, i3);

void
nci_viitp( c_func, i0, i1, t2, p3 )
	SV* c_func
	int i0
	int i1
	char * t2
	void * p3
PREINIT:
	void(*func)(int, int, char *, void *);
CODE:
	func   = INT2PTR(void(*)(int, int, char *, void *), SvIV(c_func) );
	(*func)(i0, i1, t2, p3);

void
nci_viitd( c_func, i0, i1, t2, d3 )
	SV* c_func
	int i0
	int i1
	char * t2
	double d3
PREINIT:
	void(*func)(int, int, char *, double);
CODE:
	func   = INT2PTR(void(*)(int, int, char *, double), SvIV(c_func) );
	(*func)(i0, i1, t2, d3);

void
nci_viits( c_func, i0, i1, t2, s3 )
	SV* c_func
	int i0
	int i1
	char * t2
	short s3
PREINIT:
	void(*func)(int, int, char *, short);
CODE:
	func   = INT2PTR(void(*)(int, int, char *, short), SvIV(c_func) );
	(*func)(i0, i1, t2, s3);

void
nci_viitf( c_func, i0, i1, t2, f3 )
	SV* c_func
	int i0
	int i1
	char * t2
	float f3
PREINIT:
	void(*func)(int, int, char *, float);
CODE:
	func   = INT2PTR(void(*)(int, int, char *, float), SvIV(c_func) );
	(*func)(i0, i1, t2, f3);

void
nci_viitt( c_func, i0, i1, t2, t3 )
	SV* c_func
	int i0
	int i1
	char * t2
	char * t3
PREINIT:
	void(*func)(int, int, char *, char *);
CODE:
	func   = INT2PTR(void(*)(int, int, char *, char *), SvIV(c_func) );
	(*func)(i0, i1, t2, t3);

void
nci_viiti( c_func, i0, i1, t2, i3 )
	SV* c_func
	int i0
	int i1
	char * t2
	int i3
PREINIT:
	void(*func)(int, int, char *, int);
CODE:
	func   = INT2PTR(void(*)(int, int, char *, int), SvIV(c_func) );
	(*func)(i0, i1, t2, i3);

void
nci_viiip( c_func, i0, i1, i2, p3 )
	SV* c_func
	int i0
	int i1
	int i2
	void * p3
PREINIT:
	void(*func)(int, int, int, void *);
CODE:
	func   = INT2PTR(void(*)(int, int, int, void *), SvIV(c_func) );
	(*func)(i0, i1, i2, p3);

void
nci_viiid( c_func, i0, i1, i2, d3 )
	SV* c_func
	int i0
	int i1
	int i2
	double d3
PREINIT:
	void(*func)(int, int, int, double);
CODE:
	func   = INT2PTR(void(*)(int, int, int, double), SvIV(c_func) );
	(*func)(i0, i1, i2, d3);

void
nci_viiis( c_func, i0, i1, i2, s3 )
	SV* c_func
	int i0
	int i1
	int i2
	short s3
PREINIT:
	void(*func)(int, int, int, short);
CODE:
	func   = INT2PTR(void(*)(int, int, int, short), SvIV(c_func) );
	(*func)(i0, i1, i2, s3);

void
nci_viiif( c_func, i0, i1, i2, f3 )
	SV* c_func
	int i0
	int i1
	int i2
	float f3
PREINIT:
	void(*func)(int, int, int, float);
CODE:
	func   = INT2PTR(void(*)(int, int, int, float), SvIV(c_func) );
	(*func)(i0, i1, i2, f3);

void
nci_viiit( c_func, i0, i1, i2, t3 )
	SV* c_func
	int i0
	int i1
	int i2
	char * t3
PREINIT:
	void(*func)(int, int, int, char *);
CODE:
	func   = INT2PTR(void(*)(int, int, int, char *), SvIV(c_func) );
	(*func)(i0, i1, i2, t3);

void
nci_viiii( c_func, i0, i1, i2, i3 )
	SV* c_func
	int i0
	int i1
	int i2
	int i3
PREINIT:
	void(*func)(int, int, int, int);
CODE:
	func   = INT2PTR(void(*)(int, int, int, int), SvIV(c_func) );
	(*func)(i0, i1, i2, i3);

double
nci_dpppp( c_func, p0, p1, p2, p3 )
	SV* c_func
	void * p0
	void * p1
	void * p2
	void * p3
PREINIT:
	double(*func)(void *, void *, void *, void *);
CODE:
	func   = INT2PTR(double(*)(void *, void *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, p2, p3);
OUTPUT:
	RETVAL

double
nci_dpppd( c_func, p0, p1, p2, d3 )
	SV* c_func
	void * p0
	void * p1
	void * p2
	double d3
PREINIT:
	double(*func)(void *, void *, void *, double);
CODE:
	func   = INT2PTR(double(*)(void *, void *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, p2, d3);
OUTPUT:
	RETVAL

double
nci_dppps( c_func, p0, p1, p2, s3 )
	SV* c_func
	void * p0
	void * p1
	void * p2
	short s3
PREINIT:
	double(*func)(void *, void *, void *, short);
CODE:
	func   = INT2PTR(double(*)(void *, void *, void *, short), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, p2, s3);
OUTPUT:
	RETVAL

double
nci_dpppf( c_func, p0, p1, p2, f3 )
	SV* c_func
	void * p0
	void * p1
	void * p2
	float f3
PREINIT:
	double(*func)(void *, void *, void *, float);
CODE:
	func   = INT2PTR(double(*)(void *, void *, void *, float), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, p2, f3);
OUTPUT:
	RETVAL

double
nci_dpppt( c_func, p0, p1, p2, t3 )
	SV* c_func
	void * p0
	void * p1
	void * p2
	char * t3
PREINIT:
	double(*func)(void *, void *, void *, char *);
CODE:
	func   = INT2PTR(double(*)(void *, void *, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, p2, t3);
OUTPUT:
	RETVAL

double
nci_dpppi( c_func, p0, p1, p2, i3 )
	SV* c_func
	void * p0
	void * p1
	void * p2
	int i3
PREINIT:
	double(*func)(void *, void *, void *, int);
CODE:
	func   = INT2PTR(double(*)(void *, void *, void *, int), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, p2, i3);
OUTPUT:
	RETVAL

double
nci_dppdp( c_func, p0, p1, d2, p3 )
	SV* c_func
	void * p0
	void * p1
	double d2
	void * p3
PREINIT:
	double(*func)(void *, void *, double, void *);
CODE:
	func   = INT2PTR(double(*)(void *, void *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, d2, p3);
OUTPUT:
	RETVAL

double
nci_dppdd( c_func, p0, p1, d2, d3 )
	SV* c_func
	void * p0
	void * p1
	double d2
	double d3
PREINIT:
	double(*func)(void *, void *, double, double);
CODE:
	func   = INT2PTR(double(*)(void *, void *, double, double), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, d2, d3);
OUTPUT:
	RETVAL

double
nci_dppds( c_func, p0, p1, d2, s3 )
	SV* c_func
	void * p0
	void * p1
	double d2
	short s3
PREINIT:
	double(*func)(void *, void *, double, short);
CODE:
	func   = INT2PTR(double(*)(void *, void *, double, short), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, d2, s3);
OUTPUT:
	RETVAL

double
nci_dppdf( c_func, p0, p1, d2, f3 )
	SV* c_func
	void * p0
	void * p1
	double d2
	float f3
PREINIT:
	double(*func)(void *, void *, double, float);
CODE:
	func   = INT2PTR(double(*)(void *, void *, double, float), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, d2, f3);
OUTPUT:
	RETVAL

double
nci_dppdt( c_func, p0, p1, d2, t3 )
	SV* c_func
	void * p0
	void * p1
	double d2
	char * t3
PREINIT:
	double(*func)(void *, void *, double, char *);
CODE:
	func   = INT2PTR(double(*)(void *, void *, double, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, d2, t3);
OUTPUT:
	RETVAL

double
nci_dppdi( c_func, p0, p1, d2, i3 )
	SV* c_func
	void * p0
	void * p1
	double d2
	int i3
PREINIT:
	double(*func)(void *, void *, double, int);
CODE:
	func   = INT2PTR(double(*)(void *, void *, double, int), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, d2, i3);
OUTPUT:
	RETVAL

double
nci_dppsp( c_func, p0, p1, s2, p3 )
	SV* c_func
	void * p0
	void * p1
	short s2
	void * p3
PREINIT:
	double(*func)(void *, void *, short, void *);
CODE:
	func   = INT2PTR(double(*)(void *, void *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, s2, p3);
OUTPUT:
	RETVAL

double
nci_dppsd( c_func, p0, p1, s2, d3 )
	SV* c_func
	void * p0
	void * p1
	short s2
	double d3
PREINIT:
	double(*func)(void *, void *, short, double);
CODE:
	func   = INT2PTR(double(*)(void *, void *, short, double), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, s2, d3);
OUTPUT:
	RETVAL

double
nci_dppss( c_func, p0, p1, s2, s3 )
	SV* c_func
	void * p0
	void * p1
	short s2
	short s3
PREINIT:
	double(*func)(void *, void *, short, short);
CODE:
	func   = INT2PTR(double(*)(void *, void *, short, short), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, s2, s3);
OUTPUT:
	RETVAL

double
nci_dppsf( c_func, p0, p1, s2, f3 )
	SV* c_func
	void * p0
	void * p1
	short s2
	float f3
PREINIT:
	double(*func)(void *, void *, short, float);
CODE:
	func   = INT2PTR(double(*)(void *, void *, short, float), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, s2, f3);
OUTPUT:
	RETVAL

double
nci_dppst( c_func, p0, p1, s2, t3 )
	SV* c_func
	void * p0
	void * p1
	short s2
	char * t3
PREINIT:
	double(*func)(void *, void *, short, char *);
CODE:
	func   = INT2PTR(double(*)(void *, void *, short, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, s2, t3);
OUTPUT:
	RETVAL

double
nci_dppsi( c_func, p0, p1, s2, i3 )
	SV* c_func
	void * p0
	void * p1
	short s2
	int i3
PREINIT:
	double(*func)(void *, void *, short, int);
CODE:
	func   = INT2PTR(double(*)(void *, void *, short, int), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, s2, i3);
OUTPUT:
	RETVAL

double
nci_dppfp( c_func, p0, p1, f2, p3 )
	SV* c_func
	void * p0
	void * p1
	float f2
	void * p3
PREINIT:
	double(*func)(void *, void *, float, void *);
CODE:
	func   = INT2PTR(double(*)(void *, void *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, f2, p3);
OUTPUT:
	RETVAL

double
nci_dppfd( c_func, p0, p1, f2, d3 )
	SV* c_func
	void * p0
	void * p1
	float f2
	double d3
PREINIT:
	double(*func)(void *, void *, float, double);
CODE:
	func   = INT2PTR(double(*)(void *, void *, float, double), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, f2, d3);
OUTPUT:
	RETVAL

double
nci_dppfs( c_func, p0, p1, f2, s3 )
	SV* c_func
	void * p0
	void * p1
	float f2
	short s3
PREINIT:
	double(*func)(void *, void *, float, short);
CODE:
	func   = INT2PTR(double(*)(void *, void *, float, short), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, f2, s3);
OUTPUT:
	RETVAL

double
nci_dppff( c_func, p0, p1, f2, f3 )
	SV* c_func
	void * p0
	void * p1
	float f2
	float f3
PREINIT:
	double(*func)(void *, void *, float, float);
CODE:
	func   = INT2PTR(double(*)(void *, void *, float, float), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, f2, f3);
OUTPUT:
	RETVAL

double
nci_dppft( c_func, p0, p1, f2, t3 )
	SV* c_func
	void * p0
	void * p1
	float f2
	char * t3
PREINIT:
	double(*func)(void *, void *, float, char *);
CODE:
	func   = INT2PTR(double(*)(void *, void *, float, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, f2, t3);
OUTPUT:
	RETVAL

double
nci_dppfi( c_func, p0, p1, f2, i3 )
	SV* c_func
	void * p0
	void * p1
	float f2
	int i3
PREINIT:
	double(*func)(void *, void *, float, int);
CODE:
	func   = INT2PTR(double(*)(void *, void *, float, int), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, f2, i3);
OUTPUT:
	RETVAL

double
nci_dpptp( c_func, p0, p1, t2, p3 )
	SV* c_func
	void * p0
	void * p1
	char * t2
	void * p3
PREINIT:
	double(*func)(void *, void *, char *, void *);
CODE:
	func   = INT2PTR(double(*)(void *, void *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, t2, p3);
OUTPUT:
	RETVAL

double
nci_dpptd( c_func, p0, p1, t2, d3 )
	SV* c_func
	void * p0
	void * p1
	char * t2
	double d3
PREINIT:
	double(*func)(void *, void *, char *, double);
CODE:
	func   = INT2PTR(double(*)(void *, void *, char *, double), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, t2, d3);
OUTPUT:
	RETVAL

double
nci_dppts( c_func, p0, p1, t2, s3 )
	SV* c_func
	void * p0
	void * p1
	char * t2
	short s3
PREINIT:
	double(*func)(void *, void *, char *, short);
CODE:
	func   = INT2PTR(double(*)(void *, void *, char *, short), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, t2, s3);
OUTPUT:
	RETVAL

double
nci_dpptf( c_func, p0, p1, t2, f3 )
	SV* c_func
	void * p0
	void * p1
	char * t2
	float f3
PREINIT:
	double(*func)(void *, void *, char *, float);
CODE:
	func   = INT2PTR(double(*)(void *, void *, char *, float), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, t2, f3);
OUTPUT:
	RETVAL

double
nci_dpptt( c_func, p0, p1, t2, t3 )
	SV* c_func
	void * p0
	void * p1
	char * t2
	char * t3
PREINIT:
	double(*func)(void *, void *, char *, char *);
CODE:
	func   = INT2PTR(double(*)(void *, void *, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, t2, t3);
OUTPUT:
	RETVAL

double
nci_dppti( c_func, p0, p1, t2, i3 )
	SV* c_func
	void * p0
	void * p1
	char * t2
	int i3
PREINIT:
	double(*func)(void *, void *, char *, int);
CODE:
	func   = INT2PTR(double(*)(void *, void *, char *, int), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, t2, i3);
OUTPUT:
	RETVAL

double
nci_dppip( c_func, p0, p1, i2, p3 )
	SV* c_func
	void * p0
	void * p1
	int i2
	void * p3
PREINIT:
	double(*func)(void *, void *, int, void *);
CODE:
	func   = INT2PTR(double(*)(void *, void *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, i2, p3);
OUTPUT:
	RETVAL

double
nci_dppid( c_func, p0, p1, i2, d3 )
	SV* c_func
	void * p0
	void * p1
	int i2
	double d3
PREINIT:
	double(*func)(void *, void *, int, double);
CODE:
	func   = INT2PTR(double(*)(void *, void *, int, double), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, i2, d3);
OUTPUT:
	RETVAL

double
nci_dppis( c_func, p0, p1, i2, s3 )
	SV* c_func
	void * p0
	void * p1
	int i2
	short s3
PREINIT:
	double(*func)(void *, void *, int, short);
CODE:
	func   = INT2PTR(double(*)(void *, void *, int, short), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, i2, s3);
OUTPUT:
	RETVAL

double
nci_dppif( c_func, p0, p1, i2, f3 )
	SV* c_func
	void * p0
	void * p1
	int i2
	float f3
PREINIT:
	double(*func)(void *, void *, int, float);
CODE:
	func   = INT2PTR(double(*)(void *, void *, int, float), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, i2, f3);
OUTPUT:
	RETVAL

double
nci_dppit( c_func, p0, p1, i2, t3 )
	SV* c_func
	void * p0
	void * p1
	int i2
	char * t3
PREINIT:
	double(*func)(void *, void *, int, char *);
CODE:
	func   = INT2PTR(double(*)(void *, void *, int, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, i2, t3);
OUTPUT:
	RETVAL

double
nci_dppii( c_func, p0, p1, i2, i3 )
	SV* c_func
	void * p0
	void * p1
	int i2
	int i3
PREINIT:
	double(*func)(void *, void *, int, int);
CODE:
	func   = INT2PTR(double(*)(void *, void *, int, int), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, i2, i3);
OUTPUT:
	RETVAL

double
nci_dpdpp( c_func, p0, d1, p2, p3 )
	SV* c_func
	void * p0
	double d1
	void * p2
	void * p3
PREINIT:
	double(*func)(void *, double, void *, void *);
CODE:
	func   = INT2PTR(double(*)(void *, double, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, p2, p3);
OUTPUT:
	RETVAL

double
nci_dpdpd( c_func, p0, d1, p2, d3 )
	SV* c_func
	void * p0
	double d1
	void * p2
	double d3
PREINIT:
	double(*func)(void *, double, void *, double);
CODE:
	func   = INT2PTR(double(*)(void *, double, void *, double), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, p2, d3);
OUTPUT:
	RETVAL

double
nci_dpdps( c_func, p0, d1, p2, s3 )
	SV* c_func
	void * p0
	double d1
	void * p2
	short s3
PREINIT:
	double(*func)(void *, double, void *, short);
CODE:
	func   = INT2PTR(double(*)(void *, double, void *, short), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, p2, s3);
OUTPUT:
	RETVAL

double
nci_dpdpf( c_func, p0, d1, p2, f3 )
	SV* c_func
	void * p0
	double d1
	void * p2
	float f3
PREINIT:
	double(*func)(void *, double, void *, float);
CODE:
	func   = INT2PTR(double(*)(void *, double, void *, float), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, p2, f3);
OUTPUT:
	RETVAL

double
nci_dpdpt( c_func, p0, d1, p2, t3 )
	SV* c_func
	void * p0
	double d1
	void * p2
	char * t3
PREINIT:
	double(*func)(void *, double, void *, char *);
CODE:
	func   = INT2PTR(double(*)(void *, double, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, p2, t3);
OUTPUT:
	RETVAL

double
nci_dpdpi( c_func, p0, d1, p2, i3 )
	SV* c_func
	void * p0
	double d1
	void * p2
	int i3
PREINIT:
	double(*func)(void *, double, void *, int);
CODE:
	func   = INT2PTR(double(*)(void *, double, void *, int), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, p2, i3);
OUTPUT:
	RETVAL

double
nci_dpddp( c_func, p0, d1, d2, p3 )
	SV* c_func
	void * p0
	double d1
	double d2
	void * p3
PREINIT:
	double(*func)(void *, double, double, void *);
CODE:
	func   = INT2PTR(double(*)(void *, double, double, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, d2, p3);
OUTPUT:
	RETVAL

double
nci_dpddd( c_func, p0, d1, d2, d3 )
	SV* c_func
	void * p0
	double d1
	double d2
	double d3
PREINIT:
	double(*func)(void *, double, double, double);
CODE:
	func   = INT2PTR(double(*)(void *, double, double, double), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, d2, d3);
OUTPUT:
	RETVAL

double
nci_dpdds( c_func, p0, d1, d2, s3 )
	SV* c_func
	void * p0
	double d1
	double d2
	short s3
PREINIT:
	double(*func)(void *, double, double, short);
CODE:
	func   = INT2PTR(double(*)(void *, double, double, short), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, d2, s3);
OUTPUT:
	RETVAL

double
nci_dpddf( c_func, p0, d1, d2, f3 )
	SV* c_func
	void * p0
	double d1
	double d2
	float f3
PREINIT:
	double(*func)(void *, double, double, float);
CODE:
	func   = INT2PTR(double(*)(void *, double, double, float), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, d2, f3);
OUTPUT:
	RETVAL

double
nci_dpddt( c_func, p0, d1, d2, t3 )
	SV* c_func
	void * p0
	double d1
	double d2
	char * t3
PREINIT:
	double(*func)(void *, double, double, char *);
CODE:
	func   = INT2PTR(double(*)(void *, double, double, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, d2, t3);
OUTPUT:
	RETVAL

double
nci_dpddi( c_func, p0, d1, d2, i3 )
	SV* c_func
	void * p0
	double d1
	double d2
	int i3
PREINIT:
	double(*func)(void *, double, double, int);
CODE:
	func   = INT2PTR(double(*)(void *, double, double, int), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, d2, i3);
OUTPUT:
	RETVAL

double
nci_dpdsp( c_func, p0, d1, s2, p3 )
	SV* c_func
	void * p0
	double d1
	short s2
	void * p3
PREINIT:
	double(*func)(void *, double, short, void *);
CODE:
	func   = INT2PTR(double(*)(void *, double, short, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, s2, p3);
OUTPUT:
	RETVAL

double
nci_dpdsd( c_func, p0, d1, s2, d3 )
	SV* c_func
	void * p0
	double d1
	short s2
	double d3
PREINIT:
	double(*func)(void *, double, short, double);
CODE:
	func   = INT2PTR(double(*)(void *, double, short, double), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, s2, d3);
OUTPUT:
	RETVAL

double
nci_dpdss( c_func, p0, d1, s2, s3 )
	SV* c_func
	void * p0
	double d1
	short s2
	short s3
PREINIT:
	double(*func)(void *, double, short, short);
CODE:
	func   = INT2PTR(double(*)(void *, double, short, short), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, s2, s3);
OUTPUT:
	RETVAL

double
nci_dpdsf( c_func, p0, d1, s2, f3 )
	SV* c_func
	void * p0
	double d1
	short s2
	float f3
PREINIT:
	double(*func)(void *, double, short, float);
CODE:
	func   = INT2PTR(double(*)(void *, double, short, float), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, s2, f3);
OUTPUT:
	RETVAL

double
nci_dpdst( c_func, p0, d1, s2, t3 )
	SV* c_func
	void * p0
	double d1
	short s2
	char * t3
PREINIT:
	double(*func)(void *, double, short, char *);
CODE:
	func   = INT2PTR(double(*)(void *, double, short, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, s2, t3);
OUTPUT:
	RETVAL

double
nci_dpdsi( c_func, p0, d1, s2, i3 )
	SV* c_func
	void * p0
	double d1
	short s2
	int i3
PREINIT:
	double(*func)(void *, double, short, int);
CODE:
	func   = INT2PTR(double(*)(void *, double, short, int), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, s2, i3);
OUTPUT:
	RETVAL

double
nci_dpdfp( c_func, p0, d1, f2, p3 )
	SV* c_func
	void * p0
	double d1
	float f2
	void * p3
PREINIT:
	double(*func)(void *, double, float, void *);
CODE:
	func   = INT2PTR(double(*)(void *, double, float, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, f2, p3);
OUTPUT:
	RETVAL

double
nci_dpdfd( c_func, p0, d1, f2, d3 )
	SV* c_func
	void * p0
	double d1
	float f2
	double d3
PREINIT:
	double(*func)(void *, double, float, double);
CODE:
	func   = INT2PTR(double(*)(void *, double, float, double), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, f2, d3);
OUTPUT:
	RETVAL

double
nci_dpdfs( c_func, p0, d1, f2, s3 )
	SV* c_func
	void * p0
	double d1
	float f2
	short s3
PREINIT:
	double(*func)(void *, double, float, short);
CODE:
	func   = INT2PTR(double(*)(void *, double, float, short), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, f2, s3);
OUTPUT:
	RETVAL

double
nci_dpdff( c_func, p0, d1, f2, f3 )
	SV* c_func
	void * p0
	double d1
	float f2
	float f3
PREINIT:
	double(*func)(void *, double, float, float);
CODE:
	func   = INT2PTR(double(*)(void *, double, float, float), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, f2, f3);
OUTPUT:
	RETVAL

double
nci_dpdft( c_func, p0, d1, f2, t3 )
	SV* c_func
	void * p0
	double d1
	float f2
	char * t3
PREINIT:
	double(*func)(void *, double, float, char *);
CODE:
	func   = INT2PTR(double(*)(void *, double, float, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, f2, t3);
OUTPUT:
	RETVAL

double
nci_dpdfi( c_func, p0, d1, f2, i3 )
	SV* c_func
	void * p0
	double d1
	float f2
	int i3
PREINIT:
	double(*func)(void *, double, float, int);
CODE:
	func   = INT2PTR(double(*)(void *, double, float, int), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, f2, i3);
OUTPUT:
	RETVAL

double
nci_dpdtp( c_func, p0, d1, t2, p3 )
	SV* c_func
	void * p0
	double d1
	char * t2
	void * p3
PREINIT:
	double(*func)(void *, double, char *, void *);
CODE:
	func   = INT2PTR(double(*)(void *, double, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, t2, p3);
OUTPUT:
	RETVAL

double
nci_dpdtd( c_func, p0, d1, t2, d3 )
	SV* c_func
	void * p0
	double d1
	char * t2
	double d3
PREINIT:
	double(*func)(void *, double, char *, double);
CODE:
	func   = INT2PTR(double(*)(void *, double, char *, double), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, t2, d3);
OUTPUT:
	RETVAL

double
nci_dpdts( c_func, p0, d1, t2, s3 )
	SV* c_func
	void * p0
	double d1
	char * t2
	short s3
PREINIT:
	double(*func)(void *, double, char *, short);
CODE:
	func   = INT2PTR(double(*)(void *, double, char *, short), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, t2, s3);
OUTPUT:
	RETVAL

double
nci_dpdtf( c_func, p0, d1, t2, f3 )
	SV* c_func
	void * p0
	double d1
	char * t2
	float f3
PREINIT:
	double(*func)(void *, double, char *, float);
CODE:
	func   = INT2PTR(double(*)(void *, double, char *, float), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, t2, f3);
OUTPUT:
	RETVAL

double
nci_dpdtt( c_func, p0, d1, t2, t3 )
	SV* c_func
	void * p0
	double d1
	char * t2
	char * t3
PREINIT:
	double(*func)(void *, double, char *, char *);
CODE:
	func   = INT2PTR(double(*)(void *, double, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, t2, t3);
OUTPUT:
	RETVAL

double
nci_dpdti( c_func, p0, d1, t2, i3 )
	SV* c_func
	void * p0
	double d1
	char * t2
	int i3
PREINIT:
	double(*func)(void *, double, char *, int);
CODE:
	func   = INT2PTR(double(*)(void *, double, char *, int), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, t2, i3);
OUTPUT:
	RETVAL

double
nci_dpdip( c_func, p0, d1, i2, p3 )
	SV* c_func
	void * p0
	double d1
	int i2
	void * p3
PREINIT:
	double(*func)(void *, double, int, void *);
CODE:
	func   = INT2PTR(double(*)(void *, double, int, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, i2, p3);
OUTPUT:
	RETVAL

double
nci_dpdid( c_func, p0, d1, i2, d3 )
	SV* c_func
	void * p0
	double d1
	int i2
	double d3
PREINIT:
	double(*func)(void *, double, int, double);
CODE:
	func   = INT2PTR(double(*)(void *, double, int, double), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, i2, d3);
OUTPUT:
	RETVAL

double
nci_dpdis( c_func, p0, d1, i2, s3 )
	SV* c_func
	void * p0
	double d1
	int i2
	short s3
PREINIT:
	double(*func)(void *, double, int, short);
CODE:
	func   = INT2PTR(double(*)(void *, double, int, short), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, i2, s3);
OUTPUT:
	RETVAL

double
nci_dpdif( c_func, p0, d1, i2, f3 )
	SV* c_func
	void * p0
	double d1
	int i2
	float f3
PREINIT:
	double(*func)(void *, double, int, float);
CODE:
	func   = INT2PTR(double(*)(void *, double, int, float), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, i2, f3);
OUTPUT:
	RETVAL

double
nci_dpdit( c_func, p0, d1, i2, t3 )
	SV* c_func
	void * p0
	double d1
	int i2
	char * t3
PREINIT:
	double(*func)(void *, double, int, char *);
CODE:
	func   = INT2PTR(double(*)(void *, double, int, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, i2, t3);
OUTPUT:
	RETVAL

double
nci_dpdii( c_func, p0, d1, i2, i3 )
	SV* c_func
	void * p0
	double d1
	int i2
	int i3
PREINIT:
	double(*func)(void *, double, int, int);
CODE:
	func   = INT2PTR(double(*)(void *, double, int, int), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, i2, i3);
OUTPUT:
	RETVAL

double
nci_dpspp( c_func, p0, s1, p2, p3 )
	SV* c_func
	void * p0
	short s1
	void * p2
	void * p3
PREINIT:
	double(*func)(void *, short, void *, void *);
CODE:
	func   = INT2PTR(double(*)(void *, short, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, p2, p3);
OUTPUT:
	RETVAL

double
nci_dpspd( c_func, p0, s1, p2, d3 )
	SV* c_func
	void * p0
	short s1
	void * p2
	double d3
PREINIT:
	double(*func)(void *, short, void *, double);
CODE:
	func   = INT2PTR(double(*)(void *, short, void *, double), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, p2, d3);
OUTPUT:
	RETVAL

double
nci_dpsps( c_func, p0, s1, p2, s3 )
	SV* c_func
	void * p0
	short s1
	void * p2
	short s3
PREINIT:
	double(*func)(void *, short, void *, short);
CODE:
	func   = INT2PTR(double(*)(void *, short, void *, short), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, p2, s3);
OUTPUT:
	RETVAL

double
nci_dpspf( c_func, p0, s1, p2, f3 )
	SV* c_func
	void * p0
	short s1
	void * p2
	float f3
PREINIT:
	double(*func)(void *, short, void *, float);
CODE:
	func   = INT2PTR(double(*)(void *, short, void *, float), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, p2, f3);
OUTPUT:
	RETVAL

double
nci_dpspt( c_func, p0, s1, p2, t3 )
	SV* c_func
	void * p0
	short s1
	void * p2
	char * t3
PREINIT:
	double(*func)(void *, short, void *, char *);
CODE:
	func   = INT2PTR(double(*)(void *, short, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, p2, t3);
OUTPUT:
	RETVAL

double
nci_dpspi( c_func, p0, s1, p2, i3 )
	SV* c_func
	void * p0
	short s1
	void * p2
	int i3
PREINIT:
	double(*func)(void *, short, void *, int);
CODE:
	func   = INT2PTR(double(*)(void *, short, void *, int), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, p2, i3);
OUTPUT:
	RETVAL

double
nci_dpsdp( c_func, p0, s1, d2, p3 )
	SV* c_func
	void * p0
	short s1
	double d2
	void * p3
PREINIT:
	double(*func)(void *, short, double, void *);
CODE:
	func   = INT2PTR(double(*)(void *, short, double, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, d2, p3);
OUTPUT:
	RETVAL

double
nci_dpsdd( c_func, p0, s1, d2, d3 )
	SV* c_func
	void * p0
	short s1
	double d2
	double d3
PREINIT:
	double(*func)(void *, short, double, double);
CODE:
	func   = INT2PTR(double(*)(void *, short, double, double), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, d2, d3);
OUTPUT:
	RETVAL

double
nci_dpsds( c_func, p0, s1, d2, s3 )
	SV* c_func
	void * p0
	short s1
	double d2
	short s3
PREINIT:
	double(*func)(void *, short, double, short);
CODE:
	func   = INT2PTR(double(*)(void *, short, double, short), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, d2, s3);
OUTPUT:
	RETVAL

double
nci_dpsdf( c_func, p0, s1, d2, f3 )
	SV* c_func
	void * p0
	short s1
	double d2
	float f3
PREINIT:
	double(*func)(void *, short, double, float);
CODE:
	func   = INT2PTR(double(*)(void *, short, double, float), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, d2, f3);
OUTPUT:
	RETVAL

double
nci_dpsdt( c_func, p0, s1, d2, t3 )
	SV* c_func
	void * p0
	short s1
	double d2
	char * t3
PREINIT:
	double(*func)(void *, short, double, char *);
CODE:
	func   = INT2PTR(double(*)(void *, short, double, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, d2, t3);
OUTPUT:
	RETVAL

double
nci_dpsdi( c_func, p0, s1, d2, i3 )
	SV* c_func
	void * p0
	short s1
	double d2
	int i3
PREINIT:
	double(*func)(void *, short, double, int);
CODE:
	func   = INT2PTR(double(*)(void *, short, double, int), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, d2, i3);
OUTPUT:
	RETVAL

double
nci_dpssp( c_func, p0, s1, s2, p3 )
	SV* c_func
	void * p0
	short s1
	short s2
	void * p3
PREINIT:
	double(*func)(void *, short, short, void *);
CODE:
	func   = INT2PTR(double(*)(void *, short, short, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, s2, p3);
OUTPUT:
	RETVAL

double
nci_dpssd( c_func, p0, s1, s2, d3 )
	SV* c_func
	void * p0
	short s1
	short s2
	double d3
PREINIT:
	double(*func)(void *, short, short, double);
CODE:
	func   = INT2PTR(double(*)(void *, short, short, double), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, s2, d3);
OUTPUT:
	RETVAL

double
nci_dpsss( c_func, p0, s1, s2, s3 )
	SV* c_func
	void * p0
	short s1
	short s2
	short s3
PREINIT:
	double(*func)(void *, short, short, short);
CODE:
	func   = INT2PTR(double(*)(void *, short, short, short), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, s2, s3);
OUTPUT:
	RETVAL

double
nci_dpssf( c_func, p0, s1, s2, f3 )
	SV* c_func
	void * p0
	short s1
	short s2
	float f3
PREINIT:
	double(*func)(void *, short, short, float);
CODE:
	func   = INT2PTR(double(*)(void *, short, short, float), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, s2, f3);
OUTPUT:
	RETVAL

double
nci_dpsst( c_func, p0, s1, s2, t3 )
	SV* c_func
	void * p0
	short s1
	short s2
	char * t3
PREINIT:
	double(*func)(void *, short, short, char *);
CODE:
	func   = INT2PTR(double(*)(void *, short, short, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, s2, t3);
OUTPUT:
	RETVAL

double
nci_dpssi( c_func, p0, s1, s2, i3 )
	SV* c_func
	void * p0
	short s1
	short s2
	int i3
PREINIT:
	double(*func)(void *, short, short, int);
CODE:
	func   = INT2PTR(double(*)(void *, short, short, int), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, s2, i3);
OUTPUT:
	RETVAL

double
nci_dpsfp( c_func, p0, s1, f2, p3 )
	SV* c_func
	void * p0
	short s1
	float f2
	void * p3
PREINIT:
	double(*func)(void *, short, float, void *);
CODE:
	func   = INT2PTR(double(*)(void *, short, float, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, f2, p3);
OUTPUT:
	RETVAL

double
nci_dpsfd( c_func, p0, s1, f2, d3 )
	SV* c_func
	void * p0
	short s1
	float f2
	double d3
PREINIT:
	double(*func)(void *, short, float, double);
CODE:
	func   = INT2PTR(double(*)(void *, short, float, double), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, f2, d3);
OUTPUT:
	RETVAL

double
nci_dpsfs( c_func, p0, s1, f2, s3 )
	SV* c_func
	void * p0
	short s1
	float f2
	short s3
PREINIT:
	double(*func)(void *, short, float, short);
CODE:
	func   = INT2PTR(double(*)(void *, short, float, short), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, f2, s3);
OUTPUT:
	RETVAL

double
nci_dpsff( c_func, p0, s1, f2, f3 )
	SV* c_func
	void * p0
	short s1
	float f2
	float f3
PREINIT:
	double(*func)(void *, short, float, float);
CODE:
	func   = INT2PTR(double(*)(void *, short, float, float), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, f2, f3);
OUTPUT:
	RETVAL

double
nci_dpsft( c_func, p0, s1, f2, t3 )
	SV* c_func
	void * p0
	short s1
	float f2
	char * t3
PREINIT:
	double(*func)(void *, short, float, char *);
CODE:
	func   = INT2PTR(double(*)(void *, short, float, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, f2, t3);
OUTPUT:
	RETVAL

double
nci_dpsfi( c_func, p0, s1, f2, i3 )
	SV* c_func
	void * p0
	short s1
	float f2
	int i3
PREINIT:
	double(*func)(void *, short, float, int);
CODE:
	func   = INT2PTR(double(*)(void *, short, float, int), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, f2, i3);
OUTPUT:
	RETVAL

double
nci_dpstp( c_func, p0, s1, t2, p3 )
	SV* c_func
	void * p0
	short s1
	char * t2
	void * p3
PREINIT:
	double(*func)(void *, short, char *, void *);
CODE:
	func   = INT2PTR(double(*)(void *, short, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, t2, p3);
OUTPUT:
	RETVAL

double
nci_dpstd( c_func, p0, s1, t2, d3 )
	SV* c_func
	void * p0
	short s1
	char * t2
	double d3
PREINIT:
	double(*func)(void *, short, char *, double);
CODE:
	func   = INT2PTR(double(*)(void *, short, char *, double), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, t2, d3);
OUTPUT:
	RETVAL

double
nci_dpsts( c_func, p0, s1, t2, s3 )
	SV* c_func
	void * p0
	short s1
	char * t2
	short s3
PREINIT:
	double(*func)(void *, short, char *, short);
CODE:
	func   = INT2PTR(double(*)(void *, short, char *, short), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, t2, s3);
OUTPUT:
	RETVAL

double
nci_dpstf( c_func, p0, s1, t2, f3 )
	SV* c_func
	void * p0
	short s1
	char * t2
	float f3
PREINIT:
	double(*func)(void *, short, char *, float);
CODE:
	func   = INT2PTR(double(*)(void *, short, char *, float), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, t2, f3);
OUTPUT:
	RETVAL

double
nci_dpstt( c_func, p0, s1, t2, t3 )
	SV* c_func
	void * p0
	short s1
	char * t2
	char * t3
PREINIT:
	double(*func)(void *, short, char *, char *);
CODE:
	func   = INT2PTR(double(*)(void *, short, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, t2, t3);
OUTPUT:
	RETVAL

double
nci_dpsti( c_func, p0, s1, t2, i3 )
	SV* c_func
	void * p0
	short s1
	char * t2
	int i3
PREINIT:
	double(*func)(void *, short, char *, int);
CODE:
	func   = INT2PTR(double(*)(void *, short, char *, int), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, t2, i3);
OUTPUT:
	RETVAL

double
nci_dpsip( c_func, p0, s1, i2, p3 )
	SV* c_func
	void * p0
	short s1
	int i2
	void * p3
PREINIT:
	double(*func)(void *, short, int, void *);
CODE:
	func   = INT2PTR(double(*)(void *, short, int, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, i2, p3);
OUTPUT:
	RETVAL

double
nci_dpsid( c_func, p0, s1, i2, d3 )
	SV* c_func
	void * p0
	short s1
	int i2
	double d3
PREINIT:
	double(*func)(void *, short, int, double);
CODE:
	func   = INT2PTR(double(*)(void *, short, int, double), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, i2, d3);
OUTPUT:
	RETVAL

double
nci_dpsis( c_func, p0, s1, i2, s3 )
	SV* c_func
	void * p0
	short s1
	int i2
	short s3
PREINIT:
	double(*func)(void *, short, int, short);
CODE:
	func   = INT2PTR(double(*)(void *, short, int, short), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, i2, s3);
OUTPUT:
	RETVAL

double
nci_dpsif( c_func, p0, s1, i2, f3 )
	SV* c_func
	void * p0
	short s1
	int i2
	float f3
PREINIT:
	double(*func)(void *, short, int, float);
CODE:
	func   = INT2PTR(double(*)(void *, short, int, float), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, i2, f3);
OUTPUT:
	RETVAL

double
nci_dpsit( c_func, p0, s1, i2, t3 )
	SV* c_func
	void * p0
	short s1
	int i2
	char * t3
PREINIT:
	double(*func)(void *, short, int, char *);
CODE:
	func   = INT2PTR(double(*)(void *, short, int, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, i2, t3);
OUTPUT:
	RETVAL

double
nci_dpsii( c_func, p0, s1, i2, i3 )
	SV* c_func
	void * p0
	short s1
	int i2
	int i3
PREINIT:
	double(*func)(void *, short, int, int);
CODE:
	func   = INT2PTR(double(*)(void *, short, int, int), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, i2, i3);
OUTPUT:
	RETVAL

double
nci_dpfpp( c_func, p0, f1, p2, p3 )
	SV* c_func
	void * p0
	float f1
	void * p2
	void * p3
PREINIT:
	double(*func)(void *, float, void *, void *);
CODE:
	func   = INT2PTR(double(*)(void *, float, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, p2, p3);
OUTPUT:
	RETVAL

double
nci_dpfpd( c_func, p0, f1, p2, d3 )
	SV* c_func
	void * p0
	float f1
	void * p2
	double d3
PREINIT:
	double(*func)(void *, float, void *, double);
CODE:
	func   = INT2PTR(double(*)(void *, float, void *, double), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, p2, d3);
OUTPUT:
	RETVAL

double
nci_dpfps( c_func, p0, f1, p2, s3 )
	SV* c_func
	void * p0
	float f1
	void * p2
	short s3
PREINIT:
	double(*func)(void *, float, void *, short);
CODE:
	func   = INT2PTR(double(*)(void *, float, void *, short), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, p2, s3);
OUTPUT:
	RETVAL

double
nci_dpfpf( c_func, p0, f1, p2, f3 )
	SV* c_func
	void * p0
	float f1
	void * p2
	float f3
PREINIT:
	double(*func)(void *, float, void *, float);
CODE:
	func   = INT2PTR(double(*)(void *, float, void *, float), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, p2, f3);
OUTPUT:
	RETVAL

double
nci_dpfpt( c_func, p0, f1, p2, t3 )
	SV* c_func
	void * p0
	float f1
	void * p2
	char * t3
PREINIT:
	double(*func)(void *, float, void *, char *);
CODE:
	func   = INT2PTR(double(*)(void *, float, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, p2, t3);
OUTPUT:
	RETVAL

double
nci_dpfpi( c_func, p0, f1, p2, i3 )
	SV* c_func
	void * p0
	float f1
	void * p2
	int i3
PREINIT:
	double(*func)(void *, float, void *, int);
CODE:
	func   = INT2PTR(double(*)(void *, float, void *, int), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, p2, i3);
OUTPUT:
	RETVAL

double
nci_dpfdp( c_func, p0, f1, d2, p3 )
	SV* c_func
	void * p0
	float f1
	double d2
	void * p3
PREINIT:
	double(*func)(void *, float, double, void *);
CODE:
	func   = INT2PTR(double(*)(void *, float, double, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, d2, p3);
OUTPUT:
	RETVAL

double
nci_dpfdd( c_func, p0, f1, d2, d3 )
	SV* c_func
	void * p0
	float f1
	double d2
	double d3
PREINIT:
	double(*func)(void *, float, double, double);
CODE:
	func   = INT2PTR(double(*)(void *, float, double, double), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, d2, d3);
OUTPUT:
	RETVAL

double
nci_dpfds( c_func, p0, f1, d2, s3 )
	SV* c_func
	void * p0
	float f1
	double d2
	short s3
PREINIT:
	double(*func)(void *, float, double, short);
CODE:
	func   = INT2PTR(double(*)(void *, float, double, short), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, d2, s3);
OUTPUT:
	RETVAL

double
nci_dpfdf( c_func, p0, f1, d2, f3 )
	SV* c_func
	void * p0
	float f1
	double d2
	float f3
PREINIT:
	double(*func)(void *, float, double, float);
CODE:
	func   = INT2PTR(double(*)(void *, float, double, float), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, d2, f3);
OUTPUT:
	RETVAL

double
nci_dpfdt( c_func, p0, f1, d2, t3 )
	SV* c_func
	void * p0
	float f1
	double d2
	char * t3
PREINIT:
	double(*func)(void *, float, double, char *);
CODE:
	func   = INT2PTR(double(*)(void *, float, double, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, d2, t3);
OUTPUT:
	RETVAL

double
nci_dpfdi( c_func, p0, f1, d2, i3 )
	SV* c_func
	void * p0
	float f1
	double d2
	int i3
PREINIT:
	double(*func)(void *, float, double, int);
CODE:
	func   = INT2PTR(double(*)(void *, float, double, int), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, d2, i3);
OUTPUT:
	RETVAL

double
nci_dpfsp( c_func, p0, f1, s2, p3 )
	SV* c_func
	void * p0
	float f1
	short s2
	void * p3
PREINIT:
	double(*func)(void *, float, short, void *);
CODE:
	func   = INT2PTR(double(*)(void *, float, short, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, s2, p3);
OUTPUT:
	RETVAL

double
nci_dpfsd( c_func, p0, f1, s2, d3 )
	SV* c_func
	void * p0
	float f1
	short s2
	double d3
PREINIT:
	double(*func)(void *, float, short, double);
CODE:
	func   = INT2PTR(double(*)(void *, float, short, double), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, s2, d3);
OUTPUT:
	RETVAL

double
nci_dpfss( c_func, p0, f1, s2, s3 )
	SV* c_func
	void * p0
	float f1
	short s2
	short s3
PREINIT:
	double(*func)(void *, float, short, short);
CODE:
	func   = INT2PTR(double(*)(void *, float, short, short), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, s2, s3);
OUTPUT:
	RETVAL

double
nci_dpfsf( c_func, p0, f1, s2, f3 )
	SV* c_func
	void * p0
	float f1
	short s2
	float f3
PREINIT:
	double(*func)(void *, float, short, float);
CODE:
	func   = INT2PTR(double(*)(void *, float, short, float), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, s2, f3);
OUTPUT:
	RETVAL

double
nci_dpfst( c_func, p0, f1, s2, t3 )
	SV* c_func
	void * p0
	float f1
	short s2
	char * t3
PREINIT:
	double(*func)(void *, float, short, char *);
CODE:
	func   = INT2PTR(double(*)(void *, float, short, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, s2, t3);
OUTPUT:
	RETVAL

double
nci_dpfsi( c_func, p0, f1, s2, i3 )
	SV* c_func
	void * p0
	float f1
	short s2
	int i3
PREINIT:
	double(*func)(void *, float, short, int);
CODE:
	func   = INT2PTR(double(*)(void *, float, short, int), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, s2, i3);
OUTPUT:
	RETVAL

double
nci_dpffp( c_func, p0, f1, f2, p3 )
	SV* c_func
	void * p0
	float f1
	float f2
	void * p3
PREINIT:
	double(*func)(void *, float, float, void *);
CODE:
	func   = INT2PTR(double(*)(void *, float, float, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, f2, p3);
OUTPUT:
	RETVAL

double
nci_dpffd( c_func, p0, f1, f2, d3 )
	SV* c_func
	void * p0
	float f1
	float f2
	double d3
PREINIT:
	double(*func)(void *, float, float, double);
CODE:
	func   = INT2PTR(double(*)(void *, float, float, double), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, f2, d3);
OUTPUT:
	RETVAL

double
nci_dpffs( c_func, p0, f1, f2, s3 )
	SV* c_func
	void * p0
	float f1
	float f2
	short s3
PREINIT:
	double(*func)(void *, float, float, short);
CODE:
	func   = INT2PTR(double(*)(void *, float, float, short), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, f2, s3);
OUTPUT:
	RETVAL

double
nci_dpfff( c_func, p0, f1, f2, f3 )
	SV* c_func
	void * p0
	float f1
	float f2
	float f3
PREINIT:
	double(*func)(void *, float, float, float);
CODE:
	func   = INT2PTR(double(*)(void *, float, float, float), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, f2, f3);
OUTPUT:
	RETVAL

double
nci_dpfft( c_func, p0, f1, f2, t3 )
	SV* c_func
	void * p0
	float f1
	float f2
	char * t3
PREINIT:
	double(*func)(void *, float, float, char *);
CODE:
	func   = INT2PTR(double(*)(void *, float, float, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, f2, t3);
OUTPUT:
	RETVAL

double
nci_dpffi( c_func, p0, f1, f2, i3 )
	SV* c_func
	void * p0
	float f1
	float f2
	int i3
PREINIT:
	double(*func)(void *, float, float, int);
CODE:
	func   = INT2PTR(double(*)(void *, float, float, int), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, f2, i3);
OUTPUT:
	RETVAL

double
nci_dpftp( c_func, p0, f1, t2, p3 )
	SV* c_func
	void * p0
	float f1
	char * t2
	void * p3
PREINIT:
	double(*func)(void *, float, char *, void *);
CODE:
	func   = INT2PTR(double(*)(void *, float, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, t2, p3);
OUTPUT:
	RETVAL

double
nci_dpftd( c_func, p0, f1, t2, d3 )
	SV* c_func
	void * p0
	float f1
	char * t2
	double d3
PREINIT:
	double(*func)(void *, float, char *, double);
CODE:
	func   = INT2PTR(double(*)(void *, float, char *, double), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, t2, d3);
OUTPUT:
	RETVAL

double
nci_dpfts( c_func, p0, f1, t2, s3 )
	SV* c_func
	void * p0
	float f1
	char * t2
	short s3
PREINIT:
	double(*func)(void *, float, char *, short);
CODE:
	func   = INT2PTR(double(*)(void *, float, char *, short), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, t2, s3);
OUTPUT:
	RETVAL

double
nci_dpftf( c_func, p0, f1, t2, f3 )
	SV* c_func
	void * p0
	float f1
	char * t2
	float f3
PREINIT:
	double(*func)(void *, float, char *, float);
CODE:
	func   = INT2PTR(double(*)(void *, float, char *, float), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, t2, f3);
OUTPUT:
	RETVAL

double
nci_dpftt( c_func, p0, f1, t2, t3 )
	SV* c_func
	void * p0
	float f1
	char * t2
	char * t3
PREINIT:
	double(*func)(void *, float, char *, char *);
CODE:
	func   = INT2PTR(double(*)(void *, float, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, t2, t3);
OUTPUT:
	RETVAL

double
nci_dpfti( c_func, p0, f1, t2, i3 )
	SV* c_func
	void * p0
	float f1
	char * t2
	int i3
PREINIT:
	double(*func)(void *, float, char *, int);
CODE:
	func   = INT2PTR(double(*)(void *, float, char *, int), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, t2, i3);
OUTPUT:
	RETVAL

double
nci_dpfip( c_func, p0, f1, i2, p3 )
	SV* c_func
	void * p0
	float f1
	int i2
	void * p3
PREINIT:
	double(*func)(void *, float, int, void *);
CODE:
	func   = INT2PTR(double(*)(void *, float, int, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, i2, p3);
OUTPUT:
	RETVAL

double
nci_dpfid( c_func, p0, f1, i2, d3 )
	SV* c_func
	void * p0
	float f1
	int i2
	double d3
PREINIT:
	double(*func)(void *, float, int, double);
CODE:
	func   = INT2PTR(double(*)(void *, float, int, double), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, i2, d3);
OUTPUT:
	RETVAL

double
nci_dpfis( c_func, p0, f1, i2, s3 )
	SV* c_func
	void * p0
	float f1
	int i2
	short s3
PREINIT:
	double(*func)(void *, float, int, short);
CODE:
	func   = INT2PTR(double(*)(void *, float, int, short), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, i2, s3);
OUTPUT:
	RETVAL

double
nci_dpfif( c_func, p0, f1, i2, f3 )
	SV* c_func
	void * p0
	float f1
	int i2
	float f3
PREINIT:
	double(*func)(void *, float, int, float);
CODE:
	func   = INT2PTR(double(*)(void *, float, int, float), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, i2, f3);
OUTPUT:
	RETVAL

double
nci_dpfit( c_func, p0, f1, i2, t3 )
	SV* c_func
	void * p0
	float f1
	int i2
	char * t3
PREINIT:
	double(*func)(void *, float, int, char *);
CODE:
	func   = INT2PTR(double(*)(void *, float, int, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, i2, t3);
OUTPUT:
	RETVAL

double
nci_dpfii( c_func, p0, f1, i2, i3 )
	SV* c_func
	void * p0
	float f1
	int i2
	int i3
PREINIT:
	double(*func)(void *, float, int, int);
CODE:
	func   = INT2PTR(double(*)(void *, float, int, int), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, i2, i3);
OUTPUT:
	RETVAL

double
nci_dptpp( c_func, p0, t1, p2, p3 )
	SV* c_func
	void * p0
	char * t1
	void * p2
	void * p3
PREINIT:
	double(*func)(void *, char *, void *, void *);
CODE:
	func   = INT2PTR(double(*)(void *, char *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, p2, p3);
OUTPUT:
	RETVAL

double
nci_dptpd( c_func, p0, t1, p2, d3 )
	SV* c_func
	void * p0
	char * t1
	void * p2
	double d3
PREINIT:
	double(*func)(void *, char *, void *, double);
CODE:
	func   = INT2PTR(double(*)(void *, char *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, p2, d3);
OUTPUT:
	RETVAL

double
nci_dptps( c_func, p0, t1, p2, s3 )
	SV* c_func
	void * p0
	char * t1
	void * p2
	short s3
PREINIT:
	double(*func)(void *, char *, void *, short);
CODE:
	func   = INT2PTR(double(*)(void *, char *, void *, short), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, p2, s3);
OUTPUT:
	RETVAL

double
nci_dptpf( c_func, p0, t1, p2, f3 )
	SV* c_func
	void * p0
	char * t1
	void * p2
	float f3
PREINIT:
	double(*func)(void *, char *, void *, float);
CODE:
	func   = INT2PTR(double(*)(void *, char *, void *, float), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, p2, f3);
OUTPUT:
	RETVAL

double
nci_dptpt( c_func, p0, t1, p2, t3 )
	SV* c_func
	void * p0
	char * t1
	void * p2
	char * t3
PREINIT:
	double(*func)(void *, char *, void *, char *);
CODE:
	func   = INT2PTR(double(*)(void *, char *, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, p2, t3);
OUTPUT:
	RETVAL

double
nci_dptpi( c_func, p0, t1, p2, i3 )
	SV* c_func
	void * p0
	char * t1
	void * p2
	int i3
PREINIT:
	double(*func)(void *, char *, void *, int);
CODE:
	func   = INT2PTR(double(*)(void *, char *, void *, int), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, p2, i3);
OUTPUT:
	RETVAL

double
nci_dptdp( c_func, p0, t1, d2, p3 )
	SV* c_func
	void * p0
	char * t1
	double d2
	void * p3
PREINIT:
	double(*func)(void *, char *, double, void *);
CODE:
	func   = INT2PTR(double(*)(void *, char *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, d2, p3);
OUTPUT:
	RETVAL

double
nci_dptdd( c_func, p0, t1, d2, d3 )
	SV* c_func
	void * p0
	char * t1
	double d2
	double d3
PREINIT:
	double(*func)(void *, char *, double, double);
CODE:
	func   = INT2PTR(double(*)(void *, char *, double, double), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, d2, d3);
OUTPUT:
	RETVAL

double
nci_dptds( c_func, p0, t1, d2, s3 )
	SV* c_func
	void * p0
	char * t1
	double d2
	short s3
PREINIT:
	double(*func)(void *, char *, double, short);
CODE:
	func   = INT2PTR(double(*)(void *, char *, double, short), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, d2, s3);
OUTPUT:
	RETVAL

double
nci_dptdf( c_func, p0, t1, d2, f3 )
	SV* c_func
	void * p0
	char * t1
	double d2
	float f3
PREINIT:
	double(*func)(void *, char *, double, float);
CODE:
	func   = INT2PTR(double(*)(void *, char *, double, float), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, d2, f3);
OUTPUT:
	RETVAL

double
nci_dptdt( c_func, p0, t1, d2, t3 )
	SV* c_func
	void * p0
	char * t1
	double d2
	char * t3
PREINIT:
	double(*func)(void *, char *, double, char *);
CODE:
	func   = INT2PTR(double(*)(void *, char *, double, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, d2, t3);
OUTPUT:
	RETVAL

double
nci_dptdi( c_func, p0, t1, d2, i3 )
	SV* c_func
	void * p0
	char * t1
	double d2
	int i3
PREINIT:
	double(*func)(void *, char *, double, int);
CODE:
	func   = INT2PTR(double(*)(void *, char *, double, int), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, d2, i3);
OUTPUT:
	RETVAL

double
nci_dptsp( c_func, p0, t1, s2, p3 )
	SV* c_func
	void * p0
	char * t1
	short s2
	void * p3
PREINIT:
	double(*func)(void *, char *, short, void *);
CODE:
	func   = INT2PTR(double(*)(void *, char *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, s2, p3);
OUTPUT:
	RETVAL

double
nci_dptsd( c_func, p0, t1, s2, d3 )
	SV* c_func
	void * p0
	char * t1
	short s2
	double d3
PREINIT:
	double(*func)(void *, char *, short, double);
CODE:
	func   = INT2PTR(double(*)(void *, char *, short, double), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, s2, d3);
OUTPUT:
	RETVAL

double
nci_dptss( c_func, p0, t1, s2, s3 )
	SV* c_func
	void * p0
	char * t1
	short s2
	short s3
PREINIT:
	double(*func)(void *, char *, short, short);
CODE:
	func   = INT2PTR(double(*)(void *, char *, short, short), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, s2, s3);
OUTPUT:
	RETVAL

double
nci_dptsf( c_func, p0, t1, s2, f3 )
	SV* c_func
	void * p0
	char * t1
	short s2
	float f3
PREINIT:
	double(*func)(void *, char *, short, float);
CODE:
	func   = INT2PTR(double(*)(void *, char *, short, float), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, s2, f3);
OUTPUT:
	RETVAL

double
nci_dptst( c_func, p0, t1, s2, t3 )
	SV* c_func
	void * p0
	char * t1
	short s2
	char * t3
PREINIT:
	double(*func)(void *, char *, short, char *);
CODE:
	func   = INT2PTR(double(*)(void *, char *, short, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, s2, t3);
OUTPUT:
	RETVAL

double
nci_dptsi( c_func, p0, t1, s2, i3 )
	SV* c_func
	void * p0
	char * t1
	short s2
	int i3
PREINIT:
	double(*func)(void *, char *, short, int);
CODE:
	func   = INT2PTR(double(*)(void *, char *, short, int), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, s2, i3);
OUTPUT:
	RETVAL

double
nci_dptfp( c_func, p0, t1, f2, p3 )
	SV* c_func
	void * p0
	char * t1
	float f2
	void * p3
PREINIT:
	double(*func)(void *, char *, float, void *);
CODE:
	func   = INT2PTR(double(*)(void *, char *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, f2, p3);
OUTPUT:
	RETVAL

double
nci_dptfd( c_func, p0, t1, f2, d3 )
	SV* c_func
	void * p0
	char * t1
	float f2
	double d3
PREINIT:
	double(*func)(void *, char *, float, double);
CODE:
	func   = INT2PTR(double(*)(void *, char *, float, double), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, f2, d3);
OUTPUT:
	RETVAL

double
nci_dptfs( c_func, p0, t1, f2, s3 )
	SV* c_func
	void * p0
	char * t1
	float f2
	short s3
PREINIT:
	double(*func)(void *, char *, float, short);
CODE:
	func   = INT2PTR(double(*)(void *, char *, float, short), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, f2, s3);
OUTPUT:
	RETVAL

double
nci_dptff( c_func, p0, t1, f2, f3 )
	SV* c_func
	void * p0
	char * t1
	float f2
	float f3
PREINIT:
	double(*func)(void *, char *, float, float);
CODE:
	func   = INT2PTR(double(*)(void *, char *, float, float), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, f2, f3);
OUTPUT:
	RETVAL

double
nci_dptft( c_func, p0, t1, f2, t3 )
	SV* c_func
	void * p0
	char * t1
	float f2
	char * t3
PREINIT:
	double(*func)(void *, char *, float, char *);
CODE:
	func   = INT2PTR(double(*)(void *, char *, float, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, f2, t3);
OUTPUT:
	RETVAL

double
nci_dptfi( c_func, p0, t1, f2, i3 )
	SV* c_func
	void * p0
	char * t1
	float f2
	int i3
PREINIT:
	double(*func)(void *, char *, float, int);
CODE:
	func   = INT2PTR(double(*)(void *, char *, float, int), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, f2, i3);
OUTPUT:
	RETVAL

double
nci_dpttp( c_func, p0, t1, t2, p3 )
	SV* c_func
	void * p0
	char * t1
	char * t2
	void * p3
PREINIT:
	double(*func)(void *, char *, char *, void *);
CODE:
	func   = INT2PTR(double(*)(void *, char *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, t2, p3);
OUTPUT:
	RETVAL

double
nci_dpttd( c_func, p0, t1, t2, d3 )
	SV* c_func
	void * p0
	char * t1
	char * t2
	double d3
PREINIT:
	double(*func)(void *, char *, char *, double);
CODE:
	func   = INT2PTR(double(*)(void *, char *, char *, double), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, t2, d3);
OUTPUT:
	RETVAL

double
nci_dptts( c_func, p0, t1, t2, s3 )
	SV* c_func
	void * p0
	char * t1
	char * t2
	short s3
PREINIT:
	double(*func)(void *, char *, char *, short);
CODE:
	func   = INT2PTR(double(*)(void *, char *, char *, short), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, t2, s3);
OUTPUT:
	RETVAL

double
nci_dpttf( c_func, p0, t1, t2, f3 )
	SV* c_func
	void * p0
	char * t1
	char * t2
	float f3
PREINIT:
	double(*func)(void *, char *, char *, float);
CODE:
	func   = INT2PTR(double(*)(void *, char *, char *, float), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, t2, f3);
OUTPUT:
	RETVAL

double
nci_dpttt( c_func, p0, t1, t2, t3 )
	SV* c_func
	void * p0
	char * t1
	char * t2
	char * t3
PREINIT:
	double(*func)(void *, char *, char *, char *);
CODE:
	func   = INT2PTR(double(*)(void *, char *, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, t2, t3);
OUTPUT:
	RETVAL

double
nci_dptti( c_func, p0, t1, t2, i3 )
	SV* c_func
	void * p0
	char * t1
	char * t2
	int i3
PREINIT:
	double(*func)(void *, char *, char *, int);
CODE:
	func   = INT2PTR(double(*)(void *, char *, char *, int), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, t2, i3);
OUTPUT:
	RETVAL

double
nci_dptip( c_func, p0, t1, i2, p3 )
	SV* c_func
	void * p0
	char * t1
	int i2
	void * p3
PREINIT:
	double(*func)(void *, char *, int, void *);
CODE:
	func   = INT2PTR(double(*)(void *, char *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, i2, p3);
OUTPUT:
	RETVAL

double
nci_dptid( c_func, p0, t1, i2, d3 )
	SV* c_func
	void * p0
	char * t1
	int i2
	double d3
PREINIT:
	double(*func)(void *, char *, int, double);
CODE:
	func   = INT2PTR(double(*)(void *, char *, int, double), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, i2, d3);
OUTPUT:
	RETVAL

double
nci_dptis( c_func, p0, t1, i2, s3 )
	SV* c_func
	void * p0
	char * t1
	int i2
	short s3
PREINIT:
	double(*func)(void *, char *, int, short);
CODE:
	func   = INT2PTR(double(*)(void *, char *, int, short), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, i2, s3);
OUTPUT:
	RETVAL

double
nci_dptif( c_func, p0, t1, i2, f3 )
	SV* c_func
	void * p0
	char * t1
	int i2
	float f3
PREINIT:
	double(*func)(void *, char *, int, float);
CODE:
	func   = INT2PTR(double(*)(void *, char *, int, float), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, i2, f3);
OUTPUT:
	RETVAL

double
nci_dptit( c_func, p0, t1, i2, t3 )
	SV* c_func
	void * p0
	char * t1
	int i2
	char * t3
PREINIT:
	double(*func)(void *, char *, int, char *);
CODE:
	func   = INT2PTR(double(*)(void *, char *, int, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, i2, t3);
OUTPUT:
	RETVAL

double
nci_dptii( c_func, p0, t1, i2, i3 )
	SV* c_func
	void * p0
	char * t1
	int i2
	int i3
PREINIT:
	double(*func)(void *, char *, int, int);
CODE:
	func   = INT2PTR(double(*)(void *, char *, int, int), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, i2, i3);
OUTPUT:
	RETVAL

double
nci_dpipp( c_func, p0, i1, p2, p3 )
	SV* c_func
	void * p0
	int i1
	void * p2
	void * p3
PREINIT:
	double(*func)(void *, int, void *, void *);
CODE:
	func   = INT2PTR(double(*)(void *, int, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, p2, p3);
OUTPUT:
	RETVAL

double
nci_dpipd( c_func, p0, i1, p2, d3 )
	SV* c_func
	void * p0
	int i1
	void * p2
	double d3
PREINIT:
	double(*func)(void *, int, void *, double);
CODE:
	func   = INT2PTR(double(*)(void *, int, void *, double), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, p2, d3);
OUTPUT:
	RETVAL

double
nci_dpips( c_func, p0, i1, p2, s3 )
	SV* c_func
	void * p0
	int i1
	void * p2
	short s3
PREINIT:
	double(*func)(void *, int, void *, short);
CODE:
	func   = INT2PTR(double(*)(void *, int, void *, short), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, p2, s3);
OUTPUT:
	RETVAL

double
nci_dpipf( c_func, p0, i1, p2, f3 )
	SV* c_func
	void * p0
	int i1
	void * p2
	float f3
PREINIT:
	double(*func)(void *, int, void *, float);
CODE:
	func   = INT2PTR(double(*)(void *, int, void *, float), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, p2, f3);
OUTPUT:
	RETVAL

double
nci_dpipt( c_func, p0, i1, p2, t3 )
	SV* c_func
	void * p0
	int i1
	void * p2
	char * t3
PREINIT:
	double(*func)(void *, int, void *, char *);
CODE:
	func   = INT2PTR(double(*)(void *, int, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, p2, t3);
OUTPUT:
	RETVAL

double
nci_dpipi( c_func, p0, i1, p2, i3 )
	SV* c_func
	void * p0
	int i1
	void * p2
	int i3
PREINIT:
	double(*func)(void *, int, void *, int);
CODE:
	func   = INT2PTR(double(*)(void *, int, void *, int), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, p2, i3);
OUTPUT:
	RETVAL

double
nci_dpidp( c_func, p0, i1, d2, p3 )
	SV* c_func
	void * p0
	int i1
	double d2
	void * p3
PREINIT:
	double(*func)(void *, int, double, void *);
CODE:
	func   = INT2PTR(double(*)(void *, int, double, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, d2, p3);
OUTPUT:
	RETVAL

double
nci_dpidd( c_func, p0, i1, d2, d3 )
	SV* c_func
	void * p0
	int i1
	double d2
	double d3
PREINIT:
	double(*func)(void *, int, double, double);
CODE:
	func   = INT2PTR(double(*)(void *, int, double, double), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, d2, d3);
OUTPUT:
	RETVAL

double
nci_dpids( c_func, p0, i1, d2, s3 )
	SV* c_func
	void * p0
	int i1
	double d2
	short s3
PREINIT:
	double(*func)(void *, int, double, short);
CODE:
	func   = INT2PTR(double(*)(void *, int, double, short), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, d2, s3);
OUTPUT:
	RETVAL

double
nci_dpidf( c_func, p0, i1, d2, f3 )
	SV* c_func
	void * p0
	int i1
	double d2
	float f3
PREINIT:
	double(*func)(void *, int, double, float);
CODE:
	func   = INT2PTR(double(*)(void *, int, double, float), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, d2, f3);
OUTPUT:
	RETVAL

double
nci_dpidt( c_func, p0, i1, d2, t3 )
	SV* c_func
	void * p0
	int i1
	double d2
	char * t3
PREINIT:
	double(*func)(void *, int, double, char *);
CODE:
	func   = INT2PTR(double(*)(void *, int, double, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, d2, t3);
OUTPUT:
	RETVAL

double
nci_dpidi( c_func, p0, i1, d2, i3 )
	SV* c_func
	void * p0
	int i1
	double d2
	int i3
PREINIT:
	double(*func)(void *, int, double, int);
CODE:
	func   = INT2PTR(double(*)(void *, int, double, int), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, d2, i3);
OUTPUT:
	RETVAL

double
nci_dpisp( c_func, p0, i1, s2, p3 )
	SV* c_func
	void * p0
	int i1
	short s2
	void * p3
PREINIT:
	double(*func)(void *, int, short, void *);
CODE:
	func   = INT2PTR(double(*)(void *, int, short, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, s2, p3);
OUTPUT:
	RETVAL

double
nci_dpisd( c_func, p0, i1, s2, d3 )
	SV* c_func
	void * p0
	int i1
	short s2
	double d3
PREINIT:
	double(*func)(void *, int, short, double);
CODE:
	func   = INT2PTR(double(*)(void *, int, short, double), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, s2, d3);
OUTPUT:
	RETVAL

double
nci_dpiss( c_func, p0, i1, s2, s3 )
	SV* c_func
	void * p0
	int i1
	short s2
	short s3
PREINIT:
	double(*func)(void *, int, short, short);
CODE:
	func   = INT2PTR(double(*)(void *, int, short, short), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, s2, s3);
OUTPUT:
	RETVAL

double
nci_dpisf( c_func, p0, i1, s2, f3 )
	SV* c_func
	void * p0
	int i1
	short s2
	float f3
PREINIT:
	double(*func)(void *, int, short, float);
CODE:
	func   = INT2PTR(double(*)(void *, int, short, float), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, s2, f3);
OUTPUT:
	RETVAL

double
nci_dpist( c_func, p0, i1, s2, t3 )
	SV* c_func
	void * p0
	int i1
	short s2
	char * t3
PREINIT:
	double(*func)(void *, int, short, char *);
CODE:
	func   = INT2PTR(double(*)(void *, int, short, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, s2, t3);
OUTPUT:
	RETVAL

double
nci_dpisi( c_func, p0, i1, s2, i3 )
	SV* c_func
	void * p0
	int i1
	short s2
	int i3
PREINIT:
	double(*func)(void *, int, short, int);
CODE:
	func   = INT2PTR(double(*)(void *, int, short, int), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, s2, i3);
OUTPUT:
	RETVAL

double
nci_dpifp( c_func, p0, i1, f2, p3 )
	SV* c_func
	void * p0
	int i1
	float f2
	void * p3
PREINIT:
	double(*func)(void *, int, float, void *);
CODE:
	func   = INT2PTR(double(*)(void *, int, float, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, f2, p3);
OUTPUT:
	RETVAL

double
nci_dpifd( c_func, p0, i1, f2, d3 )
	SV* c_func
	void * p0
	int i1
	float f2
	double d3
PREINIT:
	double(*func)(void *, int, float, double);
CODE:
	func   = INT2PTR(double(*)(void *, int, float, double), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, f2, d3);
OUTPUT:
	RETVAL

double
nci_dpifs( c_func, p0, i1, f2, s3 )
	SV* c_func
	void * p0
	int i1
	float f2
	short s3
PREINIT:
	double(*func)(void *, int, float, short);
CODE:
	func   = INT2PTR(double(*)(void *, int, float, short), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, f2, s3);
OUTPUT:
	RETVAL

double
nci_dpiff( c_func, p0, i1, f2, f3 )
	SV* c_func
	void * p0
	int i1
	float f2
	float f3
PREINIT:
	double(*func)(void *, int, float, float);
CODE:
	func   = INT2PTR(double(*)(void *, int, float, float), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, f2, f3);
OUTPUT:
	RETVAL

double
nci_dpift( c_func, p0, i1, f2, t3 )
	SV* c_func
	void * p0
	int i1
	float f2
	char * t3
PREINIT:
	double(*func)(void *, int, float, char *);
CODE:
	func   = INT2PTR(double(*)(void *, int, float, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, f2, t3);
OUTPUT:
	RETVAL

double
nci_dpifi( c_func, p0, i1, f2, i3 )
	SV* c_func
	void * p0
	int i1
	float f2
	int i3
PREINIT:
	double(*func)(void *, int, float, int);
CODE:
	func   = INT2PTR(double(*)(void *, int, float, int), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, f2, i3);
OUTPUT:
	RETVAL

double
nci_dpitp( c_func, p0, i1, t2, p3 )
	SV* c_func
	void * p0
	int i1
	char * t2
	void * p3
PREINIT:
	double(*func)(void *, int, char *, void *);
CODE:
	func   = INT2PTR(double(*)(void *, int, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, t2, p3);
OUTPUT:
	RETVAL

double
nci_dpitd( c_func, p0, i1, t2, d3 )
	SV* c_func
	void * p0
	int i1
	char * t2
	double d3
PREINIT:
	double(*func)(void *, int, char *, double);
CODE:
	func   = INT2PTR(double(*)(void *, int, char *, double), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, t2, d3);
OUTPUT:
	RETVAL

double
nci_dpits( c_func, p0, i1, t2, s3 )
	SV* c_func
	void * p0
	int i1
	char * t2
	short s3
PREINIT:
	double(*func)(void *, int, char *, short);
CODE:
	func   = INT2PTR(double(*)(void *, int, char *, short), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, t2, s3);
OUTPUT:
	RETVAL

double
nci_dpitf( c_func, p0, i1, t2, f3 )
	SV* c_func
	void * p0
	int i1
	char * t2
	float f3
PREINIT:
	double(*func)(void *, int, char *, float);
CODE:
	func   = INT2PTR(double(*)(void *, int, char *, float), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, t2, f3);
OUTPUT:
	RETVAL

double
nci_dpitt( c_func, p0, i1, t2, t3 )
	SV* c_func
	void * p0
	int i1
	char * t2
	char * t3
PREINIT:
	double(*func)(void *, int, char *, char *);
CODE:
	func   = INT2PTR(double(*)(void *, int, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, t2, t3);
OUTPUT:
	RETVAL

double
nci_dpiti( c_func, p0, i1, t2, i3 )
	SV* c_func
	void * p0
	int i1
	char * t2
	int i3
PREINIT:
	double(*func)(void *, int, char *, int);
CODE:
	func   = INT2PTR(double(*)(void *, int, char *, int), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, t2, i3);
OUTPUT:
	RETVAL

double
nci_dpiip( c_func, p0, i1, i2, p3 )
	SV* c_func
	void * p0
	int i1
	int i2
	void * p3
PREINIT:
	double(*func)(void *, int, int, void *);
CODE:
	func   = INT2PTR(double(*)(void *, int, int, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, i2, p3);
OUTPUT:
	RETVAL

double
nci_dpiid( c_func, p0, i1, i2, d3 )
	SV* c_func
	void * p0
	int i1
	int i2
	double d3
PREINIT:
	double(*func)(void *, int, int, double);
CODE:
	func   = INT2PTR(double(*)(void *, int, int, double), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, i2, d3);
OUTPUT:
	RETVAL

double
nci_dpiis( c_func, p0, i1, i2, s3 )
	SV* c_func
	void * p0
	int i1
	int i2
	short s3
PREINIT:
	double(*func)(void *, int, int, short);
CODE:
	func   = INT2PTR(double(*)(void *, int, int, short), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, i2, s3);
OUTPUT:
	RETVAL

double
nci_dpiif( c_func, p0, i1, i2, f3 )
	SV* c_func
	void * p0
	int i1
	int i2
	float f3
PREINIT:
	double(*func)(void *, int, int, float);
CODE:
	func   = INT2PTR(double(*)(void *, int, int, float), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, i2, f3);
OUTPUT:
	RETVAL

double
nci_dpiit( c_func, p0, i1, i2, t3 )
	SV* c_func
	void * p0
	int i1
	int i2
	char * t3
PREINIT:
	double(*func)(void *, int, int, char *);
CODE:
	func   = INT2PTR(double(*)(void *, int, int, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, i2, t3);
OUTPUT:
	RETVAL

double
nci_dpiii( c_func, p0, i1, i2, i3 )
	SV* c_func
	void * p0
	int i1
	int i2
	int i3
PREINIT:
	double(*func)(void *, int, int, int);
CODE:
	func   = INT2PTR(double(*)(void *, int, int, int), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, i2, i3);
OUTPUT:
	RETVAL

double
nci_ddppp( c_func, d0, p1, p2, p3 )
	SV* c_func
	double d0
	void * p1
	void * p2
	void * p3
PREINIT:
	double(*func)(double, void *, void *, void *);
CODE:
	func   = INT2PTR(double(*)(double, void *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, p2, p3);
OUTPUT:
	RETVAL

double
nci_ddppd( c_func, d0, p1, p2, d3 )
	SV* c_func
	double d0
	void * p1
	void * p2
	double d3
PREINIT:
	double(*func)(double, void *, void *, double);
CODE:
	func   = INT2PTR(double(*)(double, void *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, p2, d3);
OUTPUT:
	RETVAL

double
nci_ddpps( c_func, d0, p1, p2, s3 )
	SV* c_func
	double d0
	void * p1
	void * p2
	short s3
PREINIT:
	double(*func)(double, void *, void *, short);
CODE:
	func   = INT2PTR(double(*)(double, void *, void *, short), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, p2, s3);
OUTPUT:
	RETVAL

double
nci_ddppf( c_func, d0, p1, p2, f3 )
	SV* c_func
	double d0
	void * p1
	void * p2
	float f3
PREINIT:
	double(*func)(double, void *, void *, float);
CODE:
	func   = INT2PTR(double(*)(double, void *, void *, float), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, p2, f3);
OUTPUT:
	RETVAL

double
nci_ddppt( c_func, d0, p1, p2, t3 )
	SV* c_func
	double d0
	void * p1
	void * p2
	char * t3
PREINIT:
	double(*func)(double, void *, void *, char *);
CODE:
	func   = INT2PTR(double(*)(double, void *, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, p2, t3);
OUTPUT:
	RETVAL

double
nci_ddppi( c_func, d0, p1, p2, i3 )
	SV* c_func
	double d0
	void * p1
	void * p2
	int i3
PREINIT:
	double(*func)(double, void *, void *, int);
CODE:
	func   = INT2PTR(double(*)(double, void *, void *, int), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, p2, i3);
OUTPUT:
	RETVAL

double
nci_ddpdp( c_func, d0, p1, d2, p3 )
	SV* c_func
	double d0
	void * p1
	double d2
	void * p3
PREINIT:
	double(*func)(double, void *, double, void *);
CODE:
	func   = INT2PTR(double(*)(double, void *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, d2, p3);
OUTPUT:
	RETVAL

double
nci_ddpdd( c_func, d0, p1, d2, d3 )
	SV* c_func
	double d0
	void * p1
	double d2
	double d3
PREINIT:
	double(*func)(double, void *, double, double);
CODE:
	func   = INT2PTR(double(*)(double, void *, double, double), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, d2, d3);
OUTPUT:
	RETVAL

double
nci_ddpds( c_func, d0, p1, d2, s3 )
	SV* c_func
	double d0
	void * p1
	double d2
	short s3
PREINIT:
	double(*func)(double, void *, double, short);
CODE:
	func   = INT2PTR(double(*)(double, void *, double, short), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, d2, s3);
OUTPUT:
	RETVAL

double
nci_ddpdf( c_func, d0, p1, d2, f3 )
	SV* c_func
	double d0
	void * p1
	double d2
	float f3
PREINIT:
	double(*func)(double, void *, double, float);
CODE:
	func   = INT2PTR(double(*)(double, void *, double, float), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, d2, f3);
OUTPUT:
	RETVAL

double
nci_ddpdt( c_func, d0, p1, d2, t3 )
	SV* c_func
	double d0
	void * p1
	double d2
	char * t3
PREINIT:
	double(*func)(double, void *, double, char *);
CODE:
	func   = INT2PTR(double(*)(double, void *, double, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, d2, t3);
OUTPUT:
	RETVAL

double
nci_ddpdi( c_func, d0, p1, d2, i3 )
	SV* c_func
	double d0
	void * p1
	double d2
	int i3
PREINIT:
	double(*func)(double, void *, double, int);
CODE:
	func   = INT2PTR(double(*)(double, void *, double, int), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, d2, i3);
OUTPUT:
	RETVAL

double
nci_ddpsp( c_func, d0, p1, s2, p3 )
	SV* c_func
	double d0
	void * p1
	short s2
	void * p3
PREINIT:
	double(*func)(double, void *, short, void *);
CODE:
	func   = INT2PTR(double(*)(double, void *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, s2, p3);
OUTPUT:
	RETVAL

double
nci_ddpsd( c_func, d0, p1, s2, d3 )
	SV* c_func
	double d0
	void * p1
	short s2
	double d3
PREINIT:
	double(*func)(double, void *, short, double);
CODE:
	func   = INT2PTR(double(*)(double, void *, short, double), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, s2, d3);
OUTPUT:
	RETVAL

double
nci_ddpss( c_func, d0, p1, s2, s3 )
	SV* c_func
	double d0
	void * p1
	short s2
	short s3
PREINIT:
	double(*func)(double, void *, short, short);
CODE:
	func   = INT2PTR(double(*)(double, void *, short, short), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, s2, s3);
OUTPUT:
	RETVAL

double
nci_ddpsf( c_func, d0, p1, s2, f3 )
	SV* c_func
	double d0
	void * p1
	short s2
	float f3
PREINIT:
	double(*func)(double, void *, short, float);
CODE:
	func   = INT2PTR(double(*)(double, void *, short, float), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, s2, f3);
OUTPUT:
	RETVAL

double
nci_ddpst( c_func, d0, p1, s2, t3 )
	SV* c_func
	double d0
	void * p1
	short s2
	char * t3
PREINIT:
	double(*func)(double, void *, short, char *);
CODE:
	func   = INT2PTR(double(*)(double, void *, short, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, s2, t3);
OUTPUT:
	RETVAL

double
nci_ddpsi( c_func, d0, p1, s2, i3 )
	SV* c_func
	double d0
	void * p1
	short s2
	int i3
PREINIT:
	double(*func)(double, void *, short, int);
CODE:
	func   = INT2PTR(double(*)(double, void *, short, int), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, s2, i3);
OUTPUT:
	RETVAL

double
nci_ddpfp( c_func, d0, p1, f2, p3 )
	SV* c_func
	double d0
	void * p1
	float f2
	void * p3
PREINIT:
	double(*func)(double, void *, float, void *);
CODE:
	func   = INT2PTR(double(*)(double, void *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, f2, p3);
OUTPUT:
	RETVAL

double
nci_ddpfd( c_func, d0, p1, f2, d3 )
	SV* c_func
	double d0
	void * p1
	float f2
	double d3
PREINIT:
	double(*func)(double, void *, float, double);
CODE:
	func   = INT2PTR(double(*)(double, void *, float, double), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, f2, d3);
OUTPUT:
	RETVAL

double
nci_ddpfs( c_func, d0, p1, f2, s3 )
	SV* c_func
	double d0
	void * p1
	float f2
	short s3
PREINIT:
	double(*func)(double, void *, float, short);
CODE:
	func   = INT2PTR(double(*)(double, void *, float, short), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, f2, s3);
OUTPUT:
	RETVAL

double
nci_ddpff( c_func, d0, p1, f2, f3 )
	SV* c_func
	double d0
	void * p1
	float f2
	float f3
PREINIT:
	double(*func)(double, void *, float, float);
CODE:
	func   = INT2PTR(double(*)(double, void *, float, float), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, f2, f3);
OUTPUT:
	RETVAL

double
nci_ddpft( c_func, d0, p1, f2, t3 )
	SV* c_func
	double d0
	void * p1
	float f2
	char * t3
PREINIT:
	double(*func)(double, void *, float, char *);
CODE:
	func   = INT2PTR(double(*)(double, void *, float, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, f2, t3);
OUTPUT:
	RETVAL

double
nci_ddpfi( c_func, d0, p1, f2, i3 )
	SV* c_func
	double d0
	void * p1
	float f2
	int i3
PREINIT:
	double(*func)(double, void *, float, int);
CODE:
	func   = INT2PTR(double(*)(double, void *, float, int), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, f2, i3);
OUTPUT:
	RETVAL

double
nci_ddptp( c_func, d0, p1, t2, p3 )
	SV* c_func
	double d0
	void * p1
	char * t2
	void * p3
PREINIT:
	double(*func)(double, void *, char *, void *);
CODE:
	func   = INT2PTR(double(*)(double, void *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, t2, p3);
OUTPUT:
	RETVAL

double
nci_ddptd( c_func, d0, p1, t2, d3 )
	SV* c_func
	double d0
	void * p1
	char * t2
	double d3
PREINIT:
	double(*func)(double, void *, char *, double);
CODE:
	func   = INT2PTR(double(*)(double, void *, char *, double), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, t2, d3);
OUTPUT:
	RETVAL

double
nci_ddpts( c_func, d0, p1, t2, s3 )
	SV* c_func
	double d0
	void * p1
	char * t2
	short s3
PREINIT:
	double(*func)(double, void *, char *, short);
CODE:
	func   = INT2PTR(double(*)(double, void *, char *, short), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, t2, s3);
OUTPUT:
	RETVAL

double
nci_ddptf( c_func, d0, p1, t2, f3 )
	SV* c_func
	double d0
	void * p1
	char * t2
	float f3
PREINIT:
	double(*func)(double, void *, char *, float);
CODE:
	func   = INT2PTR(double(*)(double, void *, char *, float), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, t2, f3);
OUTPUT:
	RETVAL

double
nci_ddptt( c_func, d0, p1, t2, t3 )
	SV* c_func
	double d0
	void * p1
	char * t2
	char * t3
PREINIT:
	double(*func)(double, void *, char *, char *);
CODE:
	func   = INT2PTR(double(*)(double, void *, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, t2, t3);
OUTPUT:
	RETVAL

double
nci_ddpti( c_func, d0, p1, t2, i3 )
	SV* c_func
	double d0
	void * p1
	char * t2
	int i3
PREINIT:
	double(*func)(double, void *, char *, int);
CODE:
	func   = INT2PTR(double(*)(double, void *, char *, int), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, t2, i3);
OUTPUT:
	RETVAL

double
nci_ddpip( c_func, d0, p1, i2, p3 )
	SV* c_func
	double d0
	void * p1
	int i2
	void * p3
PREINIT:
	double(*func)(double, void *, int, void *);
CODE:
	func   = INT2PTR(double(*)(double, void *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, i2, p3);
OUTPUT:
	RETVAL

double
nci_ddpid( c_func, d0, p1, i2, d3 )
	SV* c_func
	double d0
	void * p1
	int i2
	double d3
PREINIT:
	double(*func)(double, void *, int, double);
CODE:
	func   = INT2PTR(double(*)(double, void *, int, double), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, i2, d3);
OUTPUT:
	RETVAL

double
nci_ddpis( c_func, d0, p1, i2, s3 )
	SV* c_func
	double d0
	void * p1
	int i2
	short s3
PREINIT:
	double(*func)(double, void *, int, short);
CODE:
	func   = INT2PTR(double(*)(double, void *, int, short), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, i2, s3);
OUTPUT:
	RETVAL

double
nci_ddpif( c_func, d0, p1, i2, f3 )
	SV* c_func
	double d0
	void * p1
	int i2
	float f3
PREINIT:
	double(*func)(double, void *, int, float);
CODE:
	func   = INT2PTR(double(*)(double, void *, int, float), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, i2, f3);
OUTPUT:
	RETVAL

double
nci_ddpit( c_func, d0, p1, i2, t3 )
	SV* c_func
	double d0
	void * p1
	int i2
	char * t3
PREINIT:
	double(*func)(double, void *, int, char *);
CODE:
	func   = INT2PTR(double(*)(double, void *, int, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, i2, t3);
OUTPUT:
	RETVAL

double
nci_ddpii( c_func, d0, p1, i2, i3 )
	SV* c_func
	double d0
	void * p1
	int i2
	int i3
PREINIT:
	double(*func)(double, void *, int, int);
CODE:
	func   = INT2PTR(double(*)(double, void *, int, int), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, i2, i3);
OUTPUT:
	RETVAL

double
nci_dddpp( c_func, d0, d1, p2, p3 )
	SV* c_func
	double d0
	double d1
	void * p2
	void * p3
PREINIT:
	double(*func)(double, double, void *, void *);
CODE:
	func   = INT2PTR(double(*)(double, double, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, p2, p3);
OUTPUT:
	RETVAL

double
nci_dddpd( c_func, d0, d1, p2, d3 )
	SV* c_func
	double d0
	double d1
	void * p2
	double d3
PREINIT:
	double(*func)(double, double, void *, double);
CODE:
	func   = INT2PTR(double(*)(double, double, void *, double), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, p2, d3);
OUTPUT:
	RETVAL

double
nci_dddps( c_func, d0, d1, p2, s3 )
	SV* c_func
	double d0
	double d1
	void * p2
	short s3
PREINIT:
	double(*func)(double, double, void *, short);
CODE:
	func   = INT2PTR(double(*)(double, double, void *, short), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, p2, s3);
OUTPUT:
	RETVAL

double
nci_dddpf( c_func, d0, d1, p2, f3 )
	SV* c_func
	double d0
	double d1
	void * p2
	float f3
PREINIT:
	double(*func)(double, double, void *, float);
CODE:
	func   = INT2PTR(double(*)(double, double, void *, float), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, p2, f3);
OUTPUT:
	RETVAL

double
nci_dddpt( c_func, d0, d1, p2, t3 )
	SV* c_func
	double d0
	double d1
	void * p2
	char * t3
PREINIT:
	double(*func)(double, double, void *, char *);
CODE:
	func   = INT2PTR(double(*)(double, double, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, p2, t3);
OUTPUT:
	RETVAL

double
nci_dddpi( c_func, d0, d1, p2, i3 )
	SV* c_func
	double d0
	double d1
	void * p2
	int i3
PREINIT:
	double(*func)(double, double, void *, int);
CODE:
	func   = INT2PTR(double(*)(double, double, void *, int), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, p2, i3);
OUTPUT:
	RETVAL

double
nci_ddddp( c_func, d0, d1, d2, p3 )
	SV* c_func
	double d0
	double d1
	double d2
	void * p3
PREINIT:
	double(*func)(double, double, double, void *);
CODE:
	func   = INT2PTR(double(*)(double, double, double, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, d2, p3);
OUTPUT:
	RETVAL

double
nci_ddddd( c_func, d0, d1, d2, d3 )
	SV* c_func
	double d0
	double d1
	double d2
	double d3
PREINIT:
	double(*func)(double, double, double, double);
CODE:
	func   = INT2PTR(double(*)(double, double, double, double), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, d2, d3);
OUTPUT:
	RETVAL

double
nci_dddds( c_func, d0, d1, d2, s3 )
	SV* c_func
	double d0
	double d1
	double d2
	short s3
PREINIT:
	double(*func)(double, double, double, short);
CODE:
	func   = INT2PTR(double(*)(double, double, double, short), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, d2, s3);
OUTPUT:
	RETVAL

double
nci_ddddf( c_func, d0, d1, d2, f3 )
	SV* c_func
	double d0
	double d1
	double d2
	float f3
PREINIT:
	double(*func)(double, double, double, float);
CODE:
	func   = INT2PTR(double(*)(double, double, double, float), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, d2, f3);
OUTPUT:
	RETVAL

double
nci_ddddt( c_func, d0, d1, d2, t3 )
	SV* c_func
	double d0
	double d1
	double d2
	char * t3
PREINIT:
	double(*func)(double, double, double, char *);
CODE:
	func   = INT2PTR(double(*)(double, double, double, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, d2, t3);
OUTPUT:
	RETVAL

double
nci_ddddi( c_func, d0, d1, d2, i3 )
	SV* c_func
	double d0
	double d1
	double d2
	int i3
PREINIT:
	double(*func)(double, double, double, int);
CODE:
	func   = INT2PTR(double(*)(double, double, double, int), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, d2, i3);
OUTPUT:
	RETVAL

double
nci_dddsp( c_func, d0, d1, s2, p3 )
	SV* c_func
	double d0
	double d1
	short s2
	void * p3
PREINIT:
	double(*func)(double, double, short, void *);
CODE:
	func   = INT2PTR(double(*)(double, double, short, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, s2, p3);
OUTPUT:
	RETVAL

double
nci_dddsd( c_func, d0, d1, s2, d3 )
	SV* c_func
	double d0
	double d1
	short s2
	double d3
PREINIT:
	double(*func)(double, double, short, double);
CODE:
	func   = INT2PTR(double(*)(double, double, short, double), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, s2, d3);
OUTPUT:
	RETVAL

double
nci_dddss( c_func, d0, d1, s2, s3 )
	SV* c_func
	double d0
	double d1
	short s2
	short s3
PREINIT:
	double(*func)(double, double, short, short);
CODE:
	func   = INT2PTR(double(*)(double, double, short, short), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, s2, s3);
OUTPUT:
	RETVAL

double
nci_dddsf( c_func, d0, d1, s2, f3 )
	SV* c_func
	double d0
	double d1
	short s2
	float f3
PREINIT:
	double(*func)(double, double, short, float);
CODE:
	func   = INT2PTR(double(*)(double, double, short, float), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, s2, f3);
OUTPUT:
	RETVAL

double
nci_dddst( c_func, d0, d1, s2, t3 )
	SV* c_func
	double d0
	double d1
	short s2
	char * t3
PREINIT:
	double(*func)(double, double, short, char *);
CODE:
	func   = INT2PTR(double(*)(double, double, short, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, s2, t3);
OUTPUT:
	RETVAL

double
nci_dddsi( c_func, d0, d1, s2, i3 )
	SV* c_func
	double d0
	double d1
	short s2
	int i3
PREINIT:
	double(*func)(double, double, short, int);
CODE:
	func   = INT2PTR(double(*)(double, double, short, int), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, s2, i3);
OUTPUT:
	RETVAL

double
nci_dddfp( c_func, d0, d1, f2, p3 )
	SV* c_func
	double d0
	double d1
	float f2
	void * p3
PREINIT:
	double(*func)(double, double, float, void *);
CODE:
	func   = INT2PTR(double(*)(double, double, float, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, f2, p3);
OUTPUT:
	RETVAL

double
nci_dddfd( c_func, d0, d1, f2, d3 )
	SV* c_func
	double d0
	double d1
	float f2
	double d3
PREINIT:
	double(*func)(double, double, float, double);
CODE:
	func   = INT2PTR(double(*)(double, double, float, double), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, f2, d3);
OUTPUT:
	RETVAL

double
nci_dddfs( c_func, d0, d1, f2, s3 )
	SV* c_func
	double d0
	double d1
	float f2
	short s3
PREINIT:
	double(*func)(double, double, float, short);
CODE:
	func   = INT2PTR(double(*)(double, double, float, short), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, f2, s3);
OUTPUT:
	RETVAL

double
nci_dddff( c_func, d0, d1, f2, f3 )
	SV* c_func
	double d0
	double d1
	float f2
	float f3
PREINIT:
	double(*func)(double, double, float, float);
CODE:
	func   = INT2PTR(double(*)(double, double, float, float), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, f2, f3);
OUTPUT:
	RETVAL

double
nci_dddft( c_func, d0, d1, f2, t3 )
	SV* c_func
	double d0
	double d1
	float f2
	char * t3
PREINIT:
	double(*func)(double, double, float, char *);
CODE:
	func   = INT2PTR(double(*)(double, double, float, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, f2, t3);
OUTPUT:
	RETVAL

double
nci_dddfi( c_func, d0, d1, f2, i3 )
	SV* c_func
	double d0
	double d1
	float f2
	int i3
PREINIT:
	double(*func)(double, double, float, int);
CODE:
	func   = INT2PTR(double(*)(double, double, float, int), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, f2, i3);
OUTPUT:
	RETVAL

double
nci_dddtp( c_func, d0, d1, t2, p3 )
	SV* c_func
	double d0
	double d1
	char * t2
	void * p3
PREINIT:
	double(*func)(double, double, char *, void *);
CODE:
	func   = INT2PTR(double(*)(double, double, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, t2, p3);
OUTPUT:
	RETVAL

double
nci_dddtd( c_func, d0, d1, t2, d3 )
	SV* c_func
	double d0
	double d1
	char * t2
	double d3
PREINIT:
	double(*func)(double, double, char *, double);
CODE:
	func   = INT2PTR(double(*)(double, double, char *, double), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, t2, d3);
OUTPUT:
	RETVAL

double
nci_dddts( c_func, d0, d1, t2, s3 )
	SV* c_func
	double d0
	double d1
	char * t2
	short s3
PREINIT:
	double(*func)(double, double, char *, short);
CODE:
	func   = INT2PTR(double(*)(double, double, char *, short), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, t2, s3);
OUTPUT:
	RETVAL

double
nci_dddtf( c_func, d0, d1, t2, f3 )
	SV* c_func
	double d0
	double d1
	char * t2
	float f3
PREINIT:
	double(*func)(double, double, char *, float);
CODE:
	func   = INT2PTR(double(*)(double, double, char *, float), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, t2, f3);
OUTPUT:
	RETVAL

double
nci_dddtt( c_func, d0, d1, t2, t3 )
	SV* c_func
	double d0
	double d1
	char * t2
	char * t3
PREINIT:
	double(*func)(double, double, char *, char *);
CODE:
	func   = INT2PTR(double(*)(double, double, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, t2, t3);
OUTPUT:
	RETVAL

double
nci_dddti( c_func, d0, d1, t2, i3 )
	SV* c_func
	double d0
	double d1
	char * t2
	int i3
PREINIT:
	double(*func)(double, double, char *, int);
CODE:
	func   = INT2PTR(double(*)(double, double, char *, int), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, t2, i3);
OUTPUT:
	RETVAL

double
nci_dddip( c_func, d0, d1, i2, p3 )
	SV* c_func
	double d0
	double d1
	int i2
	void * p3
PREINIT:
	double(*func)(double, double, int, void *);
CODE:
	func   = INT2PTR(double(*)(double, double, int, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, i2, p3);
OUTPUT:
	RETVAL

double
nci_dddid( c_func, d0, d1, i2, d3 )
	SV* c_func
	double d0
	double d1
	int i2
	double d3
PREINIT:
	double(*func)(double, double, int, double);
CODE:
	func   = INT2PTR(double(*)(double, double, int, double), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, i2, d3);
OUTPUT:
	RETVAL

double
nci_dddis( c_func, d0, d1, i2, s3 )
	SV* c_func
	double d0
	double d1
	int i2
	short s3
PREINIT:
	double(*func)(double, double, int, short);
CODE:
	func   = INT2PTR(double(*)(double, double, int, short), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, i2, s3);
OUTPUT:
	RETVAL

double
nci_dddif( c_func, d0, d1, i2, f3 )
	SV* c_func
	double d0
	double d1
	int i2
	float f3
PREINIT:
	double(*func)(double, double, int, float);
CODE:
	func   = INT2PTR(double(*)(double, double, int, float), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, i2, f3);
OUTPUT:
	RETVAL

double
nci_dddit( c_func, d0, d1, i2, t3 )
	SV* c_func
	double d0
	double d1
	int i2
	char * t3
PREINIT:
	double(*func)(double, double, int, char *);
CODE:
	func   = INT2PTR(double(*)(double, double, int, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, i2, t3);
OUTPUT:
	RETVAL

double
nci_dddii( c_func, d0, d1, i2, i3 )
	SV* c_func
	double d0
	double d1
	int i2
	int i3
PREINIT:
	double(*func)(double, double, int, int);
CODE:
	func   = INT2PTR(double(*)(double, double, int, int), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, i2, i3);
OUTPUT:
	RETVAL

double
nci_ddspp( c_func, d0, s1, p2, p3 )
	SV* c_func
	double d0
	short s1
	void * p2
	void * p3
PREINIT:
	double(*func)(double, short, void *, void *);
CODE:
	func   = INT2PTR(double(*)(double, short, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, p2, p3);
OUTPUT:
	RETVAL

double
nci_ddspd( c_func, d0, s1, p2, d3 )
	SV* c_func
	double d0
	short s1
	void * p2
	double d3
PREINIT:
	double(*func)(double, short, void *, double);
CODE:
	func   = INT2PTR(double(*)(double, short, void *, double), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, p2, d3);
OUTPUT:
	RETVAL

double
nci_ddsps( c_func, d0, s1, p2, s3 )
	SV* c_func
	double d0
	short s1
	void * p2
	short s3
PREINIT:
	double(*func)(double, short, void *, short);
CODE:
	func   = INT2PTR(double(*)(double, short, void *, short), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, p2, s3);
OUTPUT:
	RETVAL

double
nci_ddspf( c_func, d0, s1, p2, f3 )
	SV* c_func
	double d0
	short s1
	void * p2
	float f3
PREINIT:
	double(*func)(double, short, void *, float);
CODE:
	func   = INT2PTR(double(*)(double, short, void *, float), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, p2, f3);
OUTPUT:
	RETVAL

double
nci_ddspt( c_func, d0, s1, p2, t3 )
	SV* c_func
	double d0
	short s1
	void * p2
	char * t3
PREINIT:
	double(*func)(double, short, void *, char *);
CODE:
	func   = INT2PTR(double(*)(double, short, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, p2, t3);
OUTPUT:
	RETVAL

double
nci_ddspi( c_func, d0, s1, p2, i3 )
	SV* c_func
	double d0
	short s1
	void * p2
	int i3
PREINIT:
	double(*func)(double, short, void *, int);
CODE:
	func   = INT2PTR(double(*)(double, short, void *, int), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, p2, i3);
OUTPUT:
	RETVAL

double
nci_ddsdp( c_func, d0, s1, d2, p3 )
	SV* c_func
	double d0
	short s1
	double d2
	void * p3
PREINIT:
	double(*func)(double, short, double, void *);
CODE:
	func   = INT2PTR(double(*)(double, short, double, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, d2, p3);
OUTPUT:
	RETVAL

double
nci_ddsdd( c_func, d0, s1, d2, d3 )
	SV* c_func
	double d0
	short s1
	double d2
	double d3
PREINIT:
	double(*func)(double, short, double, double);
CODE:
	func   = INT2PTR(double(*)(double, short, double, double), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, d2, d3);
OUTPUT:
	RETVAL

double
nci_ddsds( c_func, d0, s1, d2, s3 )
	SV* c_func
	double d0
	short s1
	double d2
	short s3
PREINIT:
	double(*func)(double, short, double, short);
CODE:
	func   = INT2PTR(double(*)(double, short, double, short), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, d2, s3);
OUTPUT:
	RETVAL

double
nci_ddsdf( c_func, d0, s1, d2, f3 )
	SV* c_func
	double d0
	short s1
	double d2
	float f3
PREINIT:
	double(*func)(double, short, double, float);
CODE:
	func   = INT2PTR(double(*)(double, short, double, float), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, d2, f3);
OUTPUT:
	RETVAL

double
nci_ddsdt( c_func, d0, s1, d2, t3 )
	SV* c_func
	double d0
	short s1
	double d2
	char * t3
PREINIT:
	double(*func)(double, short, double, char *);
CODE:
	func   = INT2PTR(double(*)(double, short, double, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, d2, t3);
OUTPUT:
	RETVAL

double
nci_ddsdi( c_func, d0, s1, d2, i3 )
	SV* c_func
	double d0
	short s1
	double d2
	int i3
PREINIT:
	double(*func)(double, short, double, int);
CODE:
	func   = INT2PTR(double(*)(double, short, double, int), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, d2, i3);
OUTPUT:
	RETVAL

double
nci_ddssp( c_func, d0, s1, s2, p3 )
	SV* c_func
	double d0
	short s1
	short s2
	void * p3
PREINIT:
	double(*func)(double, short, short, void *);
CODE:
	func   = INT2PTR(double(*)(double, short, short, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, s2, p3);
OUTPUT:
	RETVAL

double
nci_ddssd( c_func, d0, s1, s2, d3 )
	SV* c_func
	double d0
	short s1
	short s2
	double d3
PREINIT:
	double(*func)(double, short, short, double);
CODE:
	func   = INT2PTR(double(*)(double, short, short, double), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, s2, d3);
OUTPUT:
	RETVAL

double
nci_ddsss( c_func, d0, s1, s2, s3 )
	SV* c_func
	double d0
	short s1
	short s2
	short s3
PREINIT:
	double(*func)(double, short, short, short);
CODE:
	func   = INT2PTR(double(*)(double, short, short, short), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, s2, s3);
OUTPUT:
	RETVAL

double
nci_ddssf( c_func, d0, s1, s2, f3 )
	SV* c_func
	double d0
	short s1
	short s2
	float f3
PREINIT:
	double(*func)(double, short, short, float);
CODE:
	func   = INT2PTR(double(*)(double, short, short, float), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, s2, f3);
OUTPUT:
	RETVAL

double
nci_ddsst( c_func, d0, s1, s2, t3 )
	SV* c_func
	double d0
	short s1
	short s2
	char * t3
PREINIT:
	double(*func)(double, short, short, char *);
CODE:
	func   = INT2PTR(double(*)(double, short, short, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, s2, t3);
OUTPUT:
	RETVAL

double
nci_ddssi( c_func, d0, s1, s2, i3 )
	SV* c_func
	double d0
	short s1
	short s2
	int i3
PREINIT:
	double(*func)(double, short, short, int);
CODE:
	func   = INT2PTR(double(*)(double, short, short, int), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, s2, i3);
OUTPUT:
	RETVAL

double
nci_ddsfp( c_func, d0, s1, f2, p3 )
	SV* c_func
	double d0
	short s1
	float f2
	void * p3
PREINIT:
	double(*func)(double, short, float, void *);
CODE:
	func   = INT2PTR(double(*)(double, short, float, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, f2, p3);
OUTPUT:
	RETVAL

double
nci_ddsfd( c_func, d0, s1, f2, d3 )
	SV* c_func
	double d0
	short s1
	float f2
	double d3
PREINIT:
	double(*func)(double, short, float, double);
CODE:
	func   = INT2PTR(double(*)(double, short, float, double), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, f2, d3);
OUTPUT:
	RETVAL

double
nci_ddsfs( c_func, d0, s1, f2, s3 )
	SV* c_func
	double d0
	short s1
	float f2
	short s3
PREINIT:
	double(*func)(double, short, float, short);
CODE:
	func   = INT2PTR(double(*)(double, short, float, short), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, f2, s3);
OUTPUT:
	RETVAL

double
nci_ddsff( c_func, d0, s1, f2, f3 )
	SV* c_func
	double d0
	short s1
	float f2
	float f3
PREINIT:
	double(*func)(double, short, float, float);
CODE:
	func   = INT2PTR(double(*)(double, short, float, float), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, f2, f3);
OUTPUT:
	RETVAL

double
nci_ddsft( c_func, d0, s1, f2, t3 )
	SV* c_func
	double d0
	short s1
	float f2
	char * t3
PREINIT:
	double(*func)(double, short, float, char *);
CODE:
	func   = INT2PTR(double(*)(double, short, float, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, f2, t3);
OUTPUT:
	RETVAL

double
nci_ddsfi( c_func, d0, s1, f2, i3 )
	SV* c_func
	double d0
	short s1
	float f2
	int i3
PREINIT:
	double(*func)(double, short, float, int);
CODE:
	func   = INT2PTR(double(*)(double, short, float, int), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, f2, i3);
OUTPUT:
	RETVAL

double
nci_ddstp( c_func, d0, s1, t2, p3 )
	SV* c_func
	double d0
	short s1
	char * t2
	void * p3
PREINIT:
	double(*func)(double, short, char *, void *);
CODE:
	func   = INT2PTR(double(*)(double, short, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, t2, p3);
OUTPUT:
	RETVAL

double
nci_ddstd( c_func, d0, s1, t2, d3 )
	SV* c_func
	double d0
	short s1
	char * t2
	double d3
PREINIT:
	double(*func)(double, short, char *, double);
CODE:
	func   = INT2PTR(double(*)(double, short, char *, double), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, t2, d3);
OUTPUT:
	RETVAL

double
nci_ddsts( c_func, d0, s1, t2, s3 )
	SV* c_func
	double d0
	short s1
	char * t2
	short s3
PREINIT:
	double(*func)(double, short, char *, short);
CODE:
	func   = INT2PTR(double(*)(double, short, char *, short), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, t2, s3);
OUTPUT:
	RETVAL

double
nci_ddstf( c_func, d0, s1, t2, f3 )
	SV* c_func
	double d0
	short s1
	char * t2
	float f3
PREINIT:
	double(*func)(double, short, char *, float);
CODE:
	func   = INT2PTR(double(*)(double, short, char *, float), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, t2, f3);
OUTPUT:
	RETVAL

double
nci_ddstt( c_func, d0, s1, t2, t3 )
	SV* c_func
	double d0
	short s1
	char * t2
	char * t3
PREINIT:
	double(*func)(double, short, char *, char *);
CODE:
	func   = INT2PTR(double(*)(double, short, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, t2, t3);
OUTPUT:
	RETVAL

double
nci_ddsti( c_func, d0, s1, t2, i3 )
	SV* c_func
	double d0
	short s1
	char * t2
	int i3
PREINIT:
	double(*func)(double, short, char *, int);
CODE:
	func   = INT2PTR(double(*)(double, short, char *, int), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, t2, i3);
OUTPUT:
	RETVAL

double
nci_ddsip( c_func, d0, s1, i2, p3 )
	SV* c_func
	double d0
	short s1
	int i2
	void * p3
PREINIT:
	double(*func)(double, short, int, void *);
CODE:
	func   = INT2PTR(double(*)(double, short, int, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, i2, p3);
OUTPUT:
	RETVAL

double
nci_ddsid( c_func, d0, s1, i2, d3 )
	SV* c_func
	double d0
	short s1
	int i2
	double d3
PREINIT:
	double(*func)(double, short, int, double);
CODE:
	func   = INT2PTR(double(*)(double, short, int, double), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, i2, d3);
OUTPUT:
	RETVAL

double
nci_ddsis( c_func, d0, s1, i2, s3 )
	SV* c_func
	double d0
	short s1
	int i2
	short s3
PREINIT:
	double(*func)(double, short, int, short);
CODE:
	func   = INT2PTR(double(*)(double, short, int, short), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, i2, s3);
OUTPUT:
	RETVAL

double
nci_ddsif( c_func, d0, s1, i2, f3 )
	SV* c_func
	double d0
	short s1
	int i2
	float f3
PREINIT:
	double(*func)(double, short, int, float);
CODE:
	func   = INT2PTR(double(*)(double, short, int, float), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, i2, f3);
OUTPUT:
	RETVAL

double
nci_ddsit( c_func, d0, s1, i2, t3 )
	SV* c_func
	double d0
	short s1
	int i2
	char * t3
PREINIT:
	double(*func)(double, short, int, char *);
CODE:
	func   = INT2PTR(double(*)(double, short, int, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, i2, t3);
OUTPUT:
	RETVAL

double
nci_ddsii( c_func, d0, s1, i2, i3 )
	SV* c_func
	double d0
	short s1
	int i2
	int i3
PREINIT:
	double(*func)(double, short, int, int);
CODE:
	func   = INT2PTR(double(*)(double, short, int, int), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, i2, i3);
OUTPUT:
	RETVAL

double
nci_ddfpp( c_func, d0, f1, p2, p3 )
	SV* c_func
	double d0
	float f1
	void * p2
	void * p3
PREINIT:
	double(*func)(double, float, void *, void *);
CODE:
	func   = INT2PTR(double(*)(double, float, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, p2, p3);
OUTPUT:
	RETVAL

double
nci_ddfpd( c_func, d0, f1, p2, d3 )
	SV* c_func
	double d0
	float f1
	void * p2
	double d3
PREINIT:
	double(*func)(double, float, void *, double);
CODE:
	func   = INT2PTR(double(*)(double, float, void *, double), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, p2, d3);
OUTPUT:
	RETVAL

double
nci_ddfps( c_func, d0, f1, p2, s3 )
	SV* c_func
	double d0
	float f1
	void * p2
	short s3
PREINIT:
	double(*func)(double, float, void *, short);
CODE:
	func   = INT2PTR(double(*)(double, float, void *, short), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, p2, s3);
OUTPUT:
	RETVAL

double
nci_ddfpf( c_func, d0, f1, p2, f3 )
	SV* c_func
	double d0
	float f1
	void * p2
	float f3
PREINIT:
	double(*func)(double, float, void *, float);
CODE:
	func   = INT2PTR(double(*)(double, float, void *, float), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, p2, f3);
OUTPUT:
	RETVAL

double
nci_ddfpt( c_func, d0, f1, p2, t3 )
	SV* c_func
	double d0
	float f1
	void * p2
	char * t3
PREINIT:
	double(*func)(double, float, void *, char *);
CODE:
	func   = INT2PTR(double(*)(double, float, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, p2, t3);
OUTPUT:
	RETVAL

double
nci_ddfpi( c_func, d0, f1, p2, i3 )
	SV* c_func
	double d0
	float f1
	void * p2
	int i3
PREINIT:
	double(*func)(double, float, void *, int);
CODE:
	func   = INT2PTR(double(*)(double, float, void *, int), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, p2, i3);
OUTPUT:
	RETVAL

double
nci_ddfdp( c_func, d0, f1, d2, p3 )
	SV* c_func
	double d0
	float f1
	double d2
	void * p3
PREINIT:
	double(*func)(double, float, double, void *);
CODE:
	func   = INT2PTR(double(*)(double, float, double, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, d2, p3);
OUTPUT:
	RETVAL

double
nci_ddfdd( c_func, d0, f1, d2, d3 )
	SV* c_func
	double d0
	float f1
	double d2
	double d3
PREINIT:
	double(*func)(double, float, double, double);
CODE:
	func   = INT2PTR(double(*)(double, float, double, double), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, d2, d3);
OUTPUT:
	RETVAL

double
nci_ddfds( c_func, d0, f1, d2, s3 )
	SV* c_func
	double d0
	float f1
	double d2
	short s3
PREINIT:
	double(*func)(double, float, double, short);
CODE:
	func   = INT2PTR(double(*)(double, float, double, short), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, d2, s3);
OUTPUT:
	RETVAL

double
nci_ddfdf( c_func, d0, f1, d2, f3 )
	SV* c_func
	double d0
	float f1
	double d2
	float f3
PREINIT:
	double(*func)(double, float, double, float);
CODE:
	func   = INT2PTR(double(*)(double, float, double, float), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, d2, f3);
OUTPUT:
	RETVAL

double
nci_ddfdt( c_func, d0, f1, d2, t3 )
	SV* c_func
	double d0
	float f1
	double d2
	char * t3
PREINIT:
	double(*func)(double, float, double, char *);
CODE:
	func   = INT2PTR(double(*)(double, float, double, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, d2, t3);
OUTPUT:
	RETVAL

double
nci_ddfdi( c_func, d0, f1, d2, i3 )
	SV* c_func
	double d0
	float f1
	double d2
	int i3
PREINIT:
	double(*func)(double, float, double, int);
CODE:
	func   = INT2PTR(double(*)(double, float, double, int), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, d2, i3);
OUTPUT:
	RETVAL

double
nci_ddfsp( c_func, d0, f1, s2, p3 )
	SV* c_func
	double d0
	float f1
	short s2
	void * p3
PREINIT:
	double(*func)(double, float, short, void *);
CODE:
	func   = INT2PTR(double(*)(double, float, short, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, s2, p3);
OUTPUT:
	RETVAL

double
nci_ddfsd( c_func, d0, f1, s2, d3 )
	SV* c_func
	double d0
	float f1
	short s2
	double d3
PREINIT:
	double(*func)(double, float, short, double);
CODE:
	func   = INT2PTR(double(*)(double, float, short, double), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, s2, d3);
OUTPUT:
	RETVAL

double
nci_ddfss( c_func, d0, f1, s2, s3 )
	SV* c_func
	double d0
	float f1
	short s2
	short s3
PREINIT:
	double(*func)(double, float, short, short);
CODE:
	func   = INT2PTR(double(*)(double, float, short, short), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, s2, s3);
OUTPUT:
	RETVAL

double
nci_ddfsf( c_func, d0, f1, s2, f3 )
	SV* c_func
	double d0
	float f1
	short s2
	float f3
PREINIT:
	double(*func)(double, float, short, float);
CODE:
	func   = INT2PTR(double(*)(double, float, short, float), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, s2, f3);
OUTPUT:
	RETVAL

double
nci_ddfst( c_func, d0, f1, s2, t3 )
	SV* c_func
	double d0
	float f1
	short s2
	char * t3
PREINIT:
	double(*func)(double, float, short, char *);
CODE:
	func   = INT2PTR(double(*)(double, float, short, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, s2, t3);
OUTPUT:
	RETVAL

double
nci_ddfsi( c_func, d0, f1, s2, i3 )
	SV* c_func
	double d0
	float f1
	short s2
	int i3
PREINIT:
	double(*func)(double, float, short, int);
CODE:
	func   = INT2PTR(double(*)(double, float, short, int), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, s2, i3);
OUTPUT:
	RETVAL

double
nci_ddffp( c_func, d0, f1, f2, p3 )
	SV* c_func
	double d0
	float f1
	float f2
	void * p3
PREINIT:
	double(*func)(double, float, float, void *);
CODE:
	func   = INT2PTR(double(*)(double, float, float, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, f2, p3);
OUTPUT:
	RETVAL

double
nci_ddffd( c_func, d0, f1, f2, d3 )
	SV* c_func
	double d0
	float f1
	float f2
	double d3
PREINIT:
	double(*func)(double, float, float, double);
CODE:
	func   = INT2PTR(double(*)(double, float, float, double), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, f2, d3);
OUTPUT:
	RETVAL

double
nci_ddffs( c_func, d0, f1, f2, s3 )
	SV* c_func
	double d0
	float f1
	float f2
	short s3
PREINIT:
	double(*func)(double, float, float, short);
CODE:
	func   = INT2PTR(double(*)(double, float, float, short), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, f2, s3);
OUTPUT:
	RETVAL

double
nci_ddfff( c_func, d0, f1, f2, f3 )
	SV* c_func
	double d0
	float f1
	float f2
	float f3
PREINIT:
	double(*func)(double, float, float, float);
CODE:
	func   = INT2PTR(double(*)(double, float, float, float), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, f2, f3);
OUTPUT:
	RETVAL

double
nci_ddfft( c_func, d0, f1, f2, t3 )
	SV* c_func
	double d0
	float f1
	float f2
	char * t3
PREINIT:
	double(*func)(double, float, float, char *);
CODE:
	func   = INT2PTR(double(*)(double, float, float, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, f2, t3);
OUTPUT:
	RETVAL

double
nci_ddffi( c_func, d0, f1, f2, i3 )
	SV* c_func
	double d0
	float f1
	float f2
	int i3
PREINIT:
	double(*func)(double, float, float, int);
CODE:
	func   = INT2PTR(double(*)(double, float, float, int), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, f2, i3);
OUTPUT:
	RETVAL

double
nci_ddftp( c_func, d0, f1, t2, p3 )
	SV* c_func
	double d0
	float f1
	char * t2
	void * p3
PREINIT:
	double(*func)(double, float, char *, void *);
CODE:
	func   = INT2PTR(double(*)(double, float, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, t2, p3);
OUTPUT:
	RETVAL

double
nci_ddftd( c_func, d0, f1, t2, d3 )
	SV* c_func
	double d0
	float f1
	char * t2
	double d3
PREINIT:
	double(*func)(double, float, char *, double);
CODE:
	func   = INT2PTR(double(*)(double, float, char *, double), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, t2, d3);
OUTPUT:
	RETVAL

double
nci_ddfts( c_func, d0, f1, t2, s3 )
	SV* c_func
	double d0
	float f1
	char * t2
	short s3
PREINIT:
	double(*func)(double, float, char *, short);
CODE:
	func   = INT2PTR(double(*)(double, float, char *, short), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, t2, s3);
OUTPUT:
	RETVAL

double
nci_ddftf( c_func, d0, f1, t2, f3 )
	SV* c_func
	double d0
	float f1
	char * t2
	float f3
PREINIT:
	double(*func)(double, float, char *, float);
CODE:
	func   = INT2PTR(double(*)(double, float, char *, float), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, t2, f3);
OUTPUT:
	RETVAL

double
nci_ddftt( c_func, d0, f1, t2, t3 )
	SV* c_func
	double d0
	float f1
	char * t2
	char * t3
PREINIT:
	double(*func)(double, float, char *, char *);
CODE:
	func   = INT2PTR(double(*)(double, float, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, t2, t3);
OUTPUT:
	RETVAL

double
nci_ddfti( c_func, d0, f1, t2, i3 )
	SV* c_func
	double d0
	float f1
	char * t2
	int i3
PREINIT:
	double(*func)(double, float, char *, int);
CODE:
	func   = INT2PTR(double(*)(double, float, char *, int), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, t2, i3);
OUTPUT:
	RETVAL

double
nci_ddfip( c_func, d0, f1, i2, p3 )
	SV* c_func
	double d0
	float f1
	int i2
	void * p3
PREINIT:
	double(*func)(double, float, int, void *);
CODE:
	func   = INT2PTR(double(*)(double, float, int, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, i2, p3);
OUTPUT:
	RETVAL

double
nci_ddfid( c_func, d0, f1, i2, d3 )
	SV* c_func
	double d0
	float f1
	int i2
	double d3
PREINIT:
	double(*func)(double, float, int, double);
CODE:
	func   = INT2PTR(double(*)(double, float, int, double), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, i2, d3);
OUTPUT:
	RETVAL

double
nci_ddfis( c_func, d0, f1, i2, s3 )
	SV* c_func
	double d0
	float f1
	int i2
	short s3
PREINIT:
	double(*func)(double, float, int, short);
CODE:
	func   = INT2PTR(double(*)(double, float, int, short), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, i2, s3);
OUTPUT:
	RETVAL

double
nci_ddfif( c_func, d0, f1, i2, f3 )
	SV* c_func
	double d0
	float f1
	int i2
	float f3
PREINIT:
	double(*func)(double, float, int, float);
CODE:
	func   = INT2PTR(double(*)(double, float, int, float), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, i2, f3);
OUTPUT:
	RETVAL

double
nci_ddfit( c_func, d0, f1, i2, t3 )
	SV* c_func
	double d0
	float f1
	int i2
	char * t3
PREINIT:
	double(*func)(double, float, int, char *);
CODE:
	func   = INT2PTR(double(*)(double, float, int, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, i2, t3);
OUTPUT:
	RETVAL

double
nci_ddfii( c_func, d0, f1, i2, i3 )
	SV* c_func
	double d0
	float f1
	int i2
	int i3
PREINIT:
	double(*func)(double, float, int, int);
CODE:
	func   = INT2PTR(double(*)(double, float, int, int), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, i2, i3);
OUTPUT:
	RETVAL

double
nci_ddtpp( c_func, d0, t1, p2, p3 )
	SV* c_func
	double d0
	char * t1
	void * p2
	void * p3
PREINIT:
	double(*func)(double, char *, void *, void *);
CODE:
	func   = INT2PTR(double(*)(double, char *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, p2, p3);
OUTPUT:
	RETVAL

double
nci_ddtpd( c_func, d0, t1, p2, d3 )
	SV* c_func
	double d0
	char * t1
	void * p2
	double d3
PREINIT:
	double(*func)(double, char *, void *, double);
CODE:
	func   = INT2PTR(double(*)(double, char *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, p2, d3);
OUTPUT:
	RETVAL

double
nci_ddtps( c_func, d0, t1, p2, s3 )
	SV* c_func
	double d0
	char * t1
	void * p2
	short s3
PREINIT:
	double(*func)(double, char *, void *, short);
CODE:
	func   = INT2PTR(double(*)(double, char *, void *, short), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, p2, s3);
OUTPUT:
	RETVAL

double
nci_ddtpf( c_func, d0, t1, p2, f3 )
	SV* c_func
	double d0
	char * t1
	void * p2
	float f3
PREINIT:
	double(*func)(double, char *, void *, float);
CODE:
	func   = INT2PTR(double(*)(double, char *, void *, float), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, p2, f3);
OUTPUT:
	RETVAL

double
nci_ddtpt( c_func, d0, t1, p2, t3 )
	SV* c_func
	double d0
	char * t1
	void * p2
	char * t3
PREINIT:
	double(*func)(double, char *, void *, char *);
CODE:
	func   = INT2PTR(double(*)(double, char *, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, p2, t3);
OUTPUT:
	RETVAL

double
nci_ddtpi( c_func, d0, t1, p2, i3 )
	SV* c_func
	double d0
	char * t1
	void * p2
	int i3
PREINIT:
	double(*func)(double, char *, void *, int);
CODE:
	func   = INT2PTR(double(*)(double, char *, void *, int), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, p2, i3);
OUTPUT:
	RETVAL

double
nci_ddtdp( c_func, d0, t1, d2, p3 )
	SV* c_func
	double d0
	char * t1
	double d2
	void * p3
PREINIT:
	double(*func)(double, char *, double, void *);
CODE:
	func   = INT2PTR(double(*)(double, char *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, d2, p3);
OUTPUT:
	RETVAL

double
nci_ddtdd( c_func, d0, t1, d2, d3 )
	SV* c_func
	double d0
	char * t1
	double d2
	double d3
PREINIT:
	double(*func)(double, char *, double, double);
CODE:
	func   = INT2PTR(double(*)(double, char *, double, double), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, d2, d3);
OUTPUT:
	RETVAL

double
nci_ddtds( c_func, d0, t1, d2, s3 )
	SV* c_func
	double d0
	char * t1
	double d2
	short s3
PREINIT:
	double(*func)(double, char *, double, short);
CODE:
	func   = INT2PTR(double(*)(double, char *, double, short), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, d2, s3);
OUTPUT:
	RETVAL

double
nci_ddtdf( c_func, d0, t1, d2, f3 )
	SV* c_func
	double d0
	char * t1
	double d2
	float f3
PREINIT:
	double(*func)(double, char *, double, float);
CODE:
	func   = INT2PTR(double(*)(double, char *, double, float), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, d2, f3);
OUTPUT:
	RETVAL

double
nci_ddtdt( c_func, d0, t1, d2, t3 )
	SV* c_func
	double d0
	char * t1
	double d2
	char * t3
PREINIT:
	double(*func)(double, char *, double, char *);
CODE:
	func   = INT2PTR(double(*)(double, char *, double, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, d2, t3);
OUTPUT:
	RETVAL

double
nci_ddtdi( c_func, d0, t1, d2, i3 )
	SV* c_func
	double d0
	char * t1
	double d2
	int i3
PREINIT:
	double(*func)(double, char *, double, int);
CODE:
	func   = INT2PTR(double(*)(double, char *, double, int), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, d2, i3);
OUTPUT:
	RETVAL

double
nci_ddtsp( c_func, d0, t1, s2, p3 )
	SV* c_func
	double d0
	char * t1
	short s2
	void * p3
PREINIT:
	double(*func)(double, char *, short, void *);
CODE:
	func   = INT2PTR(double(*)(double, char *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, s2, p3);
OUTPUT:
	RETVAL

double
nci_ddtsd( c_func, d0, t1, s2, d3 )
	SV* c_func
	double d0
	char * t1
	short s2
	double d3
PREINIT:
	double(*func)(double, char *, short, double);
CODE:
	func   = INT2PTR(double(*)(double, char *, short, double), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, s2, d3);
OUTPUT:
	RETVAL

double
nci_ddtss( c_func, d0, t1, s2, s3 )
	SV* c_func
	double d0
	char * t1
	short s2
	short s3
PREINIT:
	double(*func)(double, char *, short, short);
CODE:
	func   = INT2PTR(double(*)(double, char *, short, short), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, s2, s3);
OUTPUT:
	RETVAL

double
nci_ddtsf( c_func, d0, t1, s2, f3 )
	SV* c_func
	double d0
	char * t1
	short s2
	float f3
PREINIT:
	double(*func)(double, char *, short, float);
CODE:
	func   = INT2PTR(double(*)(double, char *, short, float), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, s2, f3);
OUTPUT:
	RETVAL

double
nci_ddtst( c_func, d0, t1, s2, t3 )
	SV* c_func
	double d0
	char * t1
	short s2
	char * t3
PREINIT:
	double(*func)(double, char *, short, char *);
CODE:
	func   = INT2PTR(double(*)(double, char *, short, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, s2, t3);
OUTPUT:
	RETVAL

double
nci_ddtsi( c_func, d0, t1, s2, i3 )
	SV* c_func
	double d0
	char * t1
	short s2
	int i3
PREINIT:
	double(*func)(double, char *, short, int);
CODE:
	func   = INT2PTR(double(*)(double, char *, short, int), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, s2, i3);
OUTPUT:
	RETVAL

double
nci_ddtfp( c_func, d0, t1, f2, p3 )
	SV* c_func
	double d0
	char * t1
	float f2
	void * p3
PREINIT:
	double(*func)(double, char *, float, void *);
CODE:
	func   = INT2PTR(double(*)(double, char *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, f2, p3);
OUTPUT:
	RETVAL

double
nci_ddtfd( c_func, d0, t1, f2, d3 )
	SV* c_func
	double d0
	char * t1
	float f2
	double d3
PREINIT:
	double(*func)(double, char *, float, double);
CODE:
	func   = INT2PTR(double(*)(double, char *, float, double), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, f2, d3);
OUTPUT:
	RETVAL

double
nci_ddtfs( c_func, d0, t1, f2, s3 )
	SV* c_func
	double d0
	char * t1
	float f2
	short s3
PREINIT:
	double(*func)(double, char *, float, short);
CODE:
	func   = INT2PTR(double(*)(double, char *, float, short), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, f2, s3);
OUTPUT:
	RETVAL

double
nci_ddtff( c_func, d0, t1, f2, f3 )
	SV* c_func
	double d0
	char * t1
	float f2
	float f3
PREINIT:
	double(*func)(double, char *, float, float);
CODE:
	func   = INT2PTR(double(*)(double, char *, float, float), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, f2, f3);
OUTPUT:
	RETVAL

double
nci_ddtft( c_func, d0, t1, f2, t3 )
	SV* c_func
	double d0
	char * t1
	float f2
	char * t3
PREINIT:
	double(*func)(double, char *, float, char *);
CODE:
	func   = INT2PTR(double(*)(double, char *, float, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, f2, t3);
OUTPUT:
	RETVAL

double
nci_ddtfi( c_func, d0, t1, f2, i3 )
	SV* c_func
	double d0
	char * t1
	float f2
	int i3
PREINIT:
	double(*func)(double, char *, float, int);
CODE:
	func   = INT2PTR(double(*)(double, char *, float, int), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, f2, i3);
OUTPUT:
	RETVAL

double
nci_ddttp( c_func, d0, t1, t2, p3 )
	SV* c_func
	double d0
	char * t1
	char * t2
	void * p3
PREINIT:
	double(*func)(double, char *, char *, void *);
CODE:
	func   = INT2PTR(double(*)(double, char *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, t2, p3);
OUTPUT:
	RETVAL

double
nci_ddttd( c_func, d0, t1, t2, d3 )
	SV* c_func
	double d0
	char * t1
	char * t2
	double d3
PREINIT:
	double(*func)(double, char *, char *, double);
CODE:
	func   = INT2PTR(double(*)(double, char *, char *, double), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, t2, d3);
OUTPUT:
	RETVAL

double
nci_ddtts( c_func, d0, t1, t2, s3 )
	SV* c_func
	double d0
	char * t1
	char * t2
	short s3
PREINIT:
	double(*func)(double, char *, char *, short);
CODE:
	func   = INT2PTR(double(*)(double, char *, char *, short), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, t2, s3);
OUTPUT:
	RETVAL

double
nci_ddttf( c_func, d0, t1, t2, f3 )
	SV* c_func
	double d0
	char * t1
	char * t2
	float f3
PREINIT:
	double(*func)(double, char *, char *, float);
CODE:
	func   = INT2PTR(double(*)(double, char *, char *, float), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, t2, f3);
OUTPUT:
	RETVAL

double
nci_ddttt( c_func, d0, t1, t2, t3 )
	SV* c_func
	double d0
	char * t1
	char * t2
	char * t3
PREINIT:
	double(*func)(double, char *, char *, char *);
CODE:
	func   = INT2PTR(double(*)(double, char *, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, t2, t3);
OUTPUT:
	RETVAL

double
nci_ddtti( c_func, d0, t1, t2, i3 )
	SV* c_func
	double d0
	char * t1
	char * t2
	int i3
PREINIT:
	double(*func)(double, char *, char *, int);
CODE:
	func   = INT2PTR(double(*)(double, char *, char *, int), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, t2, i3);
OUTPUT:
	RETVAL

double
nci_ddtip( c_func, d0, t1, i2, p3 )
	SV* c_func
	double d0
	char * t1
	int i2
	void * p3
PREINIT:
	double(*func)(double, char *, int, void *);
CODE:
	func   = INT2PTR(double(*)(double, char *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, i2, p3);
OUTPUT:
	RETVAL

double
nci_ddtid( c_func, d0, t1, i2, d3 )
	SV* c_func
	double d0
	char * t1
	int i2
	double d3
PREINIT:
	double(*func)(double, char *, int, double);
CODE:
	func   = INT2PTR(double(*)(double, char *, int, double), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, i2, d3);
OUTPUT:
	RETVAL

double
nci_ddtis( c_func, d0, t1, i2, s3 )
	SV* c_func
	double d0
	char * t1
	int i2
	short s3
PREINIT:
	double(*func)(double, char *, int, short);
CODE:
	func   = INT2PTR(double(*)(double, char *, int, short), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, i2, s3);
OUTPUT:
	RETVAL

double
nci_ddtif( c_func, d0, t1, i2, f3 )
	SV* c_func
	double d0
	char * t1
	int i2
	float f3
PREINIT:
	double(*func)(double, char *, int, float);
CODE:
	func   = INT2PTR(double(*)(double, char *, int, float), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, i2, f3);
OUTPUT:
	RETVAL

double
nci_ddtit( c_func, d0, t1, i2, t3 )
	SV* c_func
	double d0
	char * t1
	int i2
	char * t3
PREINIT:
	double(*func)(double, char *, int, char *);
CODE:
	func   = INT2PTR(double(*)(double, char *, int, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, i2, t3);
OUTPUT:
	RETVAL

double
nci_ddtii( c_func, d0, t1, i2, i3 )
	SV* c_func
	double d0
	char * t1
	int i2
	int i3
PREINIT:
	double(*func)(double, char *, int, int);
CODE:
	func   = INT2PTR(double(*)(double, char *, int, int), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, i2, i3);
OUTPUT:
	RETVAL

double
nci_ddipp( c_func, d0, i1, p2, p3 )
	SV* c_func
	double d0
	int i1
	void * p2
	void * p3
PREINIT:
	double(*func)(double, int, void *, void *);
CODE:
	func   = INT2PTR(double(*)(double, int, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, p2, p3);
OUTPUT:
	RETVAL

double
nci_ddipd( c_func, d0, i1, p2, d3 )
	SV* c_func
	double d0
	int i1
	void * p2
	double d3
PREINIT:
	double(*func)(double, int, void *, double);
CODE:
	func   = INT2PTR(double(*)(double, int, void *, double), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, p2, d3);
OUTPUT:
	RETVAL

double
nci_ddips( c_func, d0, i1, p2, s3 )
	SV* c_func
	double d0
	int i1
	void * p2
	short s3
PREINIT:
	double(*func)(double, int, void *, short);
CODE:
	func   = INT2PTR(double(*)(double, int, void *, short), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, p2, s3);
OUTPUT:
	RETVAL

double
nci_ddipf( c_func, d0, i1, p2, f3 )
	SV* c_func
	double d0
	int i1
	void * p2
	float f3
PREINIT:
	double(*func)(double, int, void *, float);
CODE:
	func   = INT2PTR(double(*)(double, int, void *, float), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, p2, f3);
OUTPUT:
	RETVAL

double
nci_ddipt( c_func, d0, i1, p2, t3 )
	SV* c_func
	double d0
	int i1
	void * p2
	char * t3
PREINIT:
	double(*func)(double, int, void *, char *);
CODE:
	func   = INT2PTR(double(*)(double, int, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, p2, t3);
OUTPUT:
	RETVAL

double
nci_ddipi( c_func, d0, i1, p2, i3 )
	SV* c_func
	double d0
	int i1
	void * p2
	int i3
PREINIT:
	double(*func)(double, int, void *, int);
CODE:
	func   = INT2PTR(double(*)(double, int, void *, int), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, p2, i3);
OUTPUT:
	RETVAL

double
nci_ddidp( c_func, d0, i1, d2, p3 )
	SV* c_func
	double d0
	int i1
	double d2
	void * p3
PREINIT:
	double(*func)(double, int, double, void *);
CODE:
	func   = INT2PTR(double(*)(double, int, double, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, d2, p3);
OUTPUT:
	RETVAL

double
nci_ddidd( c_func, d0, i1, d2, d3 )
	SV* c_func
	double d0
	int i1
	double d2
	double d3
PREINIT:
	double(*func)(double, int, double, double);
CODE:
	func   = INT2PTR(double(*)(double, int, double, double), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, d2, d3);
OUTPUT:
	RETVAL

double
nci_ddids( c_func, d0, i1, d2, s3 )
	SV* c_func
	double d0
	int i1
	double d2
	short s3
PREINIT:
	double(*func)(double, int, double, short);
CODE:
	func   = INT2PTR(double(*)(double, int, double, short), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, d2, s3);
OUTPUT:
	RETVAL

double
nci_ddidf( c_func, d0, i1, d2, f3 )
	SV* c_func
	double d0
	int i1
	double d2
	float f3
PREINIT:
	double(*func)(double, int, double, float);
CODE:
	func   = INT2PTR(double(*)(double, int, double, float), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, d2, f3);
OUTPUT:
	RETVAL

double
nci_ddidt( c_func, d0, i1, d2, t3 )
	SV* c_func
	double d0
	int i1
	double d2
	char * t3
PREINIT:
	double(*func)(double, int, double, char *);
CODE:
	func   = INT2PTR(double(*)(double, int, double, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, d2, t3);
OUTPUT:
	RETVAL

double
nci_ddidi( c_func, d0, i1, d2, i3 )
	SV* c_func
	double d0
	int i1
	double d2
	int i3
PREINIT:
	double(*func)(double, int, double, int);
CODE:
	func   = INT2PTR(double(*)(double, int, double, int), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, d2, i3);
OUTPUT:
	RETVAL

double
nci_ddisp( c_func, d0, i1, s2, p3 )
	SV* c_func
	double d0
	int i1
	short s2
	void * p3
PREINIT:
	double(*func)(double, int, short, void *);
CODE:
	func   = INT2PTR(double(*)(double, int, short, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, s2, p3);
OUTPUT:
	RETVAL

double
nci_ddisd( c_func, d0, i1, s2, d3 )
	SV* c_func
	double d0
	int i1
	short s2
	double d3
PREINIT:
	double(*func)(double, int, short, double);
CODE:
	func   = INT2PTR(double(*)(double, int, short, double), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, s2, d3);
OUTPUT:
	RETVAL

double
nci_ddiss( c_func, d0, i1, s2, s3 )
	SV* c_func
	double d0
	int i1
	short s2
	short s3
PREINIT:
	double(*func)(double, int, short, short);
CODE:
	func   = INT2PTR(double(*)(double, int, short, short), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, s2, s3);
OUTPUT:
	RETVAL

double
nci_ddisf( c_func, d0, i1, s2, f3 )
	SV* c_func
	double d0
	int i1
	short s2
	float f3
PREINIT:
	double(*func)(double, int, short, float);
CODE:
	func   = INT2PTR(double(*)(double, int, short, float), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, s2, f3);
OUTPUT:
	RETVAL

double
nci_ddist( c_func, d0, i1, s2, t3 )
	SV* c_func
	double d0
	int i1
	short s2
	char * t3
PREINIT:
	double(*func)(double, int, short, char *);
CODE:
	func   = INT2PTR(double(*)(double, int, short, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, s2, t3);
OUTPUT:
	RETVAL

double
nci_ddisi( c_func, d0, i1, s2, i3 )
	SV* c_func
	double d0
	int i1
	short s2
	int i3
PREINIT:
	double(*func)(double, int, short, int);
CODE:
	func   = INT2PTR(double(*)(double, int, short, int), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, s2, i3);
OUTPUT:
	RETVAL

double
nci_ddifp( c_func, d0, i1, f2, p3 )
	SV* c_func
	double d0
	int i1
	float f2
	void * p3
PREINIT:
	double(*func)(double, int, float, void *);
CODE:
	func   = INT2PTR(double(*)(double, int, float, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, f2, p3);
OUTPUT:
	RETVAL

double
nci_ddifd( c_func, d0, i1, f2, d3 )
	SV* c_func
	double d0
	int i1
	float f2
	double d3
PREINIT:
	double(*func)(double, int, float, double);
CODE:
	func   = INT2PTR(double(*)(double, int, float, double), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, f2, d3);
OUTPUT:
	RETVAL

double
nci_ddifs( c_func, d0, i1, f2, s3 )
	SV* c_func
	double d0
	int i1
	float f2
	short s3
PREINIT:
	double(*func)(double, int, float, short);
CODE:
	func   = INT2PTR(double(*)(double, int, float, short), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, f2, s3);
OUTPUT:
	RETVAL

double
nci_ddiff( c_func, d0, i1, f2, f3 )
	SV* c_func
	double d0
	int i1
	float f2
	float f3
PREINIT:
	double(*func)(double, int, float, float);
CODE:
	func   = INT2PTR(double(*)(double, int, float, float), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, f2, f3);
OUTPUT:
	RETVAL

double
nci_ddift( c_func, d0, i1, f2, t3 )
	SV* c_func
	double d0
	int i1
	float f2
	char * t3
PREINIT:
	double(*func)(double, int, float, char *);
CODE:
	func   = INT2PTR(double(*)(double, int, float, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, f2, t3);
OUTPUT:
	RETVAL

double
nci_ddifi( c_func, d0, i1, f2, i3 )
	SV* c_func
	double d0
	int i1
	float f2
	int i3
PREINIT:
	double(*func)(double, int, float, int);
CODE:
	func   = INT2PTR(double(*)(double, int, float, int), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, f2, i3);
OUTPUT:
	RETVAL

double
nci_dditp( c_func, d0, i1, t2, p3 )
	SV* c_func
	double d0
	int i1
	char * t2
	void * p3
PREINIT:
	double(*func)(double, int, char *, void *);
CODE:
	func   = INT2PTR(double(*)(double, int, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, t2, p3);
OUTPUT:
	RETVAL

double
nci_dditd( c_func, d0, i1, t2, d3 )
	SV* c_func
	double d0
	int i1
	char * t2
	double d3
PREINIT:
	double(*func)(double, int, char *, double);
CODE:
	func   = INT2PTR(double(*)(double, int, char *, double), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, t2, d3);
OUTPUT:
	RETVAL

double
nci_ddits( c_func, d0, i1, t2, s3 )
	SV* c_func
	double d0
	int i1
	char * t2
	short s3
PREINIT:
	double(*func)(double, int, char *, short);
CODE:
	func   = INT2PTR(double(*)(double, int, char *, short), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, t2, s3);
OUTPUT:
	RETVAL

double
nci_dditf( c_func, d0, i1, t2, f3 )
	SV* c_func
	double d0
	int i1
	char * t2
	float f3
PREINIT:
	double(*func)(double, int, char *, float);
CODE:
	func   = INT2PTR(double(*)(double, int, char *, float), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, t2, f3);
OUTPUT:
	RETVAL

double
nci_dditt( c_func, d0, i1, t2, t3 )
	SV* c_func
	double d0
	int i1
	char * t2
	char * t3
PREINIT:
	double(*func)(double, int, char *, char *);
CODE:
	func   = INT2PTR(double(*)(double, int, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, t2, t3);
OUTPUT:
	RETVAL

double
nci_dditi( c_func, d0, i1, t2, i3 )
	SV* c_func
	double d0
	int i1
	char * t2
	int i3
PREINIT:
	double(*func)(double, int, char *, int);
CODE:
	func   = INT2PTR(double(*)(double, int, char *, int), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, t2, i3);
OUTPUT:
	RETVAL

double
nci_ddiip( c_func, d0, i1, i2, p3 )
	SV* c_func
	double d0
	int i1
	int i2
	void * p3
PREINIT:
	double(*func)(double, int, int, void *);
CODE:
	func   = INT2PTR(double(*)(double, int, int, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, i2, p3);
OUTPUT:
	RETVAL

double
nci_ddiid( c_func, d0, i1, i2, d3 )
	SV* c_func
	double d0
	int i1
	int i2
	double d3
PREINIT:
	double(*func)(double, int, int, double);
CODE:
	func   = INT2PTR(double(*)(double, int, int, double), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, i2, d3);
OUTPUT:
	RETVAL

double
nci_ddiis( c_func, d0, i1, i2, s3 )
	SV* c_func
	double d0
	int i1
	int i2
	short s3
PREINIT:
	double(*func)(double, int, int, short);
CODE:
	func   = INT2PTR(double(*)(double, int, int, short), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, i2, s3);
OUTPUT:
	RETVAL

double
nci_ddiif( c_func, d0, i1, i2, f3 )
	SV* c_func
	double d0
	int i1
	int i2
	float f3
PREINIT:
	double(*func)(double, int, int, float);
CODE:
	func   = INT2PTR(double(*)(double, int, int, float), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, i2, f3);
OUTPUT:
	RETVAL

double
nci_ddiit( c_func, d0, i1, i2, t3 )
	SV* c_func
	double d0
	int i1
	int i2
	char * t3
PREINIT:
	double(*func)(double, int, int, char *);
CODE:
	func   = INT2PTR(double(*)(double, int, int, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, i2, t3);
OUTPUT:
	RETVAL

double
nci_ddiii( c_func, d0, i1, i2, i3 )
	SV* c_func
	double d0
	int i1
	int i2
	int i3
PREINIT:
	double(*func)(double, int, int, int);
CODE:
	func   = INT2PTR(double(*)(double, int, int, int), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, i2, i3);
OUTPUT:
	RETVAL

double
nci_dsppp( c_func, s0, p1, p2, p3 )
	SV* c_func
	short s0
	void * p1
	void * p2
	void * p3
PREINIT:
	double(*func)(short, void *, void *, void *);
CODE:
	func   = INT2PTR(double(*)(short, void *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, p2, p3);
OUTPUT:
	RETVAL

double
nci_dsppd( c_func, s0, p1, p2, d3 )
	SV* c_func
	short s0
	void * p1
	void * p2
	double d3
PREINIT:
	double(*func)(short, void *, void *, double);
CODE:
	func   = INT2PTR(double(*)(short, void *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, p2, d3);
OUTPUT:
	RETVAL

double
nci_dspps( c_func, s0, p1, p2, s3 )
	SV* c_func
	short s0
	void * p1
	void * p2
	short s3
PREINIT:
	double(*func)(short, void *, void *, short);
CODE:
	func   = INT2PTR(double(*)(short, void *, void *, short), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, p2, s3);
OUTPUT:
	RETVAL

double
nci_dsppf( c_func, s0, p1, p2, f3 )
	SV* c_func
	short s0
	void * p1
	void * p2
	float f3
PREINIT:
	double(*func)(short, void *, void *, float);
CODE:
	func   = INT2PTR(double(*)(short, void *, void *, float), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, p2, f3);
OUTPUT:
	RETVAL

double
nci_dsppt( c_func, s0, p1, p2, t3 )
	SV* c_func
	short s0
	void * p1
	void * p2
	char * t3
PREINIT:
	double(*func)(short, void *, void *, char *);
CODE:
	func   = INT2PTR(double(*)(short, void *, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, p2, t3);
OUTPUT:
	RETVAL

double
nci_dsppi( c_func, s0, p1, p2, i3 )
	SV* c_func
	short s0
	void * p1
	void * p2
	int i3
PREINIT:
	double(*func)(short, void *, void *, int);
CODE:
	func   = INT2PTR(double(*)(short, void *, void *, int), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, p2, i3);
OUTPUT:
	RETVAL

double
nci_dspdp( c_func, s0, p1, d2, p3 )
	SV* c_func
	short s0
	void * p1
	double d2
	void * p3
PREINIT:
	double(*func)(short, void *, double, void *);
CODE:
	func   = INT2PTR(double(*)(short, void *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, d2, p3);
OUTPUT:
	RETVAL

double
nci_dspdd( c_func, s0, p1, d2, d3 )
	SV* c_func
	short s0
	void * p1
	double d2
	double d3
PREINIT:
	double(*func)(short, void *, double, double);
CODE:
	func   = INT2PTR(double(*)(short, void *, double, double), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, d2, d3);
OUTPUT:
	RETVAL

double
nci_dspds( c_func, s0, p1, d2, s3 )
	SV* c_func
	short s0
	void * p1
	double d2
	short s3
PREINIT:
	double(*func)(short, void *, double, short);
CODE:
	func   = INT2PTR(double(*)(short, void *, double, short), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, d2, s3);
OUTPUT:
	RETVAL

double
nci_dspdf( c_func, s0, p1, d2, f3 )
	SV* c_func
	short s0
	void * p1
	double d2
	float f3
PREINIT:
	double(*func)(short, void *, double, float);
CODE:
	func   = INT2PTR(double(*)(short, void *, double, float), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, d2, f3);
OUTPUT:
	RETVAL

double
nci_dspdt( c_func, s0, p1, d2, t3 )
	SV* c_func
	short s0
	void * p1
	double d2
	char * t3
PREINIT:
	double(*func)(short, void *, double, char *);
CODE:
	func   = INT2PTR(double(*)(short, void *, double, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, d2, t3);
OUTPUT:
	RETVAL

double
nci_dspdi( c_func, s0, p1, d2, i3 )
	SV* c_func
	short s0
	void * p1
	double d2
	int i3
PREINIT:
	double(*func)(short, void *, double, int);
CODE:
	func   = INT2PTR(double(*)(short, void *, double, int), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, d2, i3);
OUTPUT:
	RETVAL

double
nci_dspsp( c_func, s0, p1, s2, p3 )
	SV* c_func
	short s0
	void * p1
	short s2
	void * p3
PREINIT:
	double(*func)(short, void *, short, void *);
CODE:
	func   = INT2PTR(double(*)(short, void *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, s2, p3);
OUTPUT:
	RETVAL

double
nci_dspsd( c_func, s0, p1, s2, d3 )
	SV* c_func
	short s0
	void * p1
	short s2
	double d3
PREINIT:
	double(*func)(short, void *, short, double);
CODE:
	func   = INT2PTR(double(*)(short, void *, short, double), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, s2, d3);
OUTPUT:
	RETVAL

double
nci_dspss( c_func, s0, p1, s2, s3 )
	SV* c_func
	short s0
	void * p1
	short s2
	short s3
PREINIT:
	double(*func)(short, void *, short, short);
CODE:
	func   = INT2PTR(double(*)(short, void *, short, short), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, s2, s3);
OUTPUT:
	RETVAL

double
nci_dspsf( c_func, s0, p1, s2, f3 )
	SV* c_func
	short s0
	void * p1
	short s2
	float f3
PREINIT:
	double(*func)(short, void *, short, float);
CODE:
	func   = INT2PTR(double(*)(short, void *, short, float), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, s2, f3);
OUTPUT:
	RETVAL

double
nci_dspst( c_func, s0, p1, s2, t3 )
	SV* c_func
	short s0
	void * p1
	short s2
	char * t3
PREINIT:
	double(*func)(short, void *, short, char *);
CODE:
	func   = INT2PTR(double(*)(short, void *, short, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, s2, t3);
OUTPUT:
	RETVAL

double
nci_dspsi( c_func, s0, p1, s2, i3 )
	SV* c_func
	short s0
	void * p1
	short s2
	int i3
PREINIT:
	double(*func)(short, void *, short, int);
CODE:
	func   = INT2PTR(double(*)(short, void *, short, int), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, s2, i3);
OUTPUT:
	RETVAL

double
nci_dspfp( c_func, s0, p1, f2, p3 )
	SV* c_func
	short s0
	void * p1
	float f2
	void * p3
PREINIT:
	double(*func)(short, void *, float, void *);
CODE:
	func   = INT2PTR(double(*)(short, void *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, f2, p3);
OUTPUT:
	RETVAL

double
nci_dspfd( c_func, s0, p1, f2, d3 )
	SV* c_func
	short s0
	void * p1
	float f2
	double d3
PREINIT:
	double(*func)(short, void *, float, double);
CODE:
	func   = INT2PTR(double(*)(short, void *, float, double), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, f2, d3);
OUTPUT:
	RETVAL

double
nci_dspfs( c_func, s0, p1, f2, s3 )
	SV* c_func
	short s0
	void * p1
	float f2
	short s3
PREINIT:
	double(*func)(short, void *, float, short);
CODE:
	func   = INT2PTR(double(*)(short, void *, float, short), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, f2, s3);
OUTPUT:
	RETVAL

double
nci_dspff( c_func, s0, p1, f2, f3 )
	SV* c_func
	short s0
	void * p1
	float f2
	float f3
PREINIT:
	double(*func)(short, void *, float, float);
CODE:
	func   = INT2PTR(double(*)(short, void *, float, float), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, f2, f3);
OUTPUT:
	RETVAL

double
nci_dspft( c_func, s0, p1, f2, t3 )
	SV* c_func
	short s0
	void * p1
	float f2
	char * t3
PREINIT:
	double(*func)(short, void *, float, char *);
CODE:
	func   = INT2PTR(double(*)(short, void *, float, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, f2, t3);
OUTPUT:
	RETVAL

double
nci_dspfi( c_func, s0, p1, f2, i3 )
	SV* c_func
	short s0
	void * p1
	float f2
	int i3
PREINIT:
	double(*func)(short, void *, float, int);
CODE:
	func   = INT2PTR(double(*)(short, void *, float, int), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, f2, i3);
OUTPUT:
	RETVAL

double
nci_dsptp( c_func, s0, p1, t2, p3 )
	SV* c_func
	short s0
	void * p1
	char * t2
	void * p3
PREINIT:
	double(*func)(short, void *, char *, void *);
CODE:
	func   = INT2PTR(double(*)(short, void *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, t2, p3);
OUTPUT:
	RETVAL

double
nci_dsptd( c_func, s0, p1, t2, d3 )
	SV* c_func
	short s0
	void * p1
	char * t2
	double d3
PREINIT:
	double(*func)(short, void *, char *, double);
CODE:
	func   = INT2PTR(double(*)(short, void *, char *, double), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, t2, d3);
OUTPUT:
	RETVAL

double
nci_dspts( c_func, s0, p1, t2, s3 )
	SV* c_func
	short s0
	void * p1
	char * t2
	short s3
PREINIT:
	double(*func)(short, void *, char *, short);
CODE:
	func   = INT2PTR(double(*)(short, void *, char *, short), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, t2, s3);
OUTPUT:
	RETVAL

double
nci_dsptf( c_func, s0, p1, t2, f3 )
	SV* c_func
	short s0
	void * p1
	char * t2
	float f3
PREINIT:
	double(*func)(short, void *, char *, float);
CODE:
	func   = INT2PTR(double(*)(short, void *, char *, float), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, t2, f3);
OUTPUT:
	RETVAL

double
nci_dsptt( c_func, s0, p1, t2, t3 )
	SV* c_func
	short s0
	void * p1
	char * t2
	char * t3
PREINIT:
	double(*func)(short, void *, char *, char *);
CODE:
	func   = INT2PTR(double(*)(short, void *, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, t2, t3);
OUTPUT:
	RETVAL

double
nci_dspti( c_func, s0, p1, t2, i3 )
	SV* c_func
	short s0
	void * p1
	char * t2
	int i3
PREINIT:
	double(*func)(short, void *, char *, int);
CODE:
	func   = INT2PTR(double(*)(short, void *, char *, int), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, t2, i3);
OUTPUT:
	RETVAL

double
nci_dspip( c_func, s0, p1, i2, p3 )
	SV* c_func
	short s0
	void * p1
	int i2
	void * p3
PREINIT:
	double(*func)(short, void *, int, void *);
CODE:
	func   = INT2PTR(double(*)(short, void *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, i2, p3);
OUTPUT:
	RETVAL

double
nci_dspid( c_func, s0, p1, i2, d3 )
	SV* c_func
	short s0
	void * p1
	int i2
	double d3
PREINIT:
	double(*func)(short, void *, int, double);
CODE:
	func   = INT2PTR(double(*)(short, void *, int, double), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, i2, d3);
OUTPUT:
	RETVAL

double
nci_dspis( c_func, s0, p1, i2, s3 )
	SV* c_func
	short s0
	void * p1
	int i2
	short s3
PREINIT:
	double(*func)(short, void *, int, short);
CODE:
	func   = INT2PTR(double(*)(short, void *, int, short), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, i2, s3);
OUTPUT:
	RETVAL

double
nci_dspif( c_func, s0, p1, i2, f3 )
	SV* c_func
	short s0
	void * p1
	int i2
	float f3
PREINIT:
	double(*func)(short, void *, int, float);
CODE:
	func   = INT2PTR(double(*)(short, void *, int, float), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, i2, f3);
OUTPUT:
	RETVAL

double
nci_dspit( c_func, s0, p1, i2, t3 )
	SV* c_func
	short s0
	void * p1
	int i2
	char * t3
PREINIT:
	double(*func)(short, void *, int, char *);
CODE:
	func   = INT2PTR(double(*)(short, void *, int, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, i2, t3);
OUTPUT:
	RETVAL

double
nci_dspii( c_func, s0, p1, i2, i3 )
	SV* c_func
	short s0
	void * p1
	int i2
	int i3
PREINIT:
	double(*func)(short, void *, int, int);
CODE:
	func   = INT2PTR(double(*)(short, void *, int, int), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, i2, i3);
OUTPUT:
	RETVAL

double
nci_dsdpp( c_func, s0, d1, p2, p3 )
	SV* c_func
	short s0
	double d1
	void * p2
	void * p3
PREINIT:
	double(*func)(short, double, void *, void *);
CODE:
	func   = INT2PTR(double(*)(short, double, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, p2, p3);
OUTPUT:
	RETVAL

double
nci_dsdpd( c_func, s0, d1, p2, d3 )
	SV* c_func
	short s0
	double d1
	void * p2
	double d3
PREINIT:
	double(*func)(short, double, void *, double);
CODE:
	func   = INT2PTR(double(*)(short, double, void *, double), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, p2, d3);
OUTPUT:
	RETVAL

double
nci_dsdps( c_func, s0, d1, p2, s3 )
	SV* c_func
	short s0
	double d1
	void * p2
	short s3
PREINIT:
	double(*func)(short, double, void *, short);
CODE:
	func   = INT2PTR(double(*)(short, double, void *, short), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, p2, s3);
OUTPUT:
	RETVAL

double
nci_dsdpf( c_func, s0, d1, p2, f3 )
	SV* c_func
	short s0
	double d1
	void * p2
	float f3
PREINIT:
	double(*func)(short, double, void *, float);
CODE:
	func   = INT2PTR(double(*)(short, double, void *, float), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, p2, f3);
OUTPUT:
	RETVAL

double
nci_dsdpt( c_func, s0, d1, p2, t3 )
	SV* c_func
	short s0
	double d1
	void * p2
	char * t3
PREINIT:
	double(*func)(short, double, void *, char *);
CODE:
	func   = INT2PTR(double(*)(short, double, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, p2, t3);
OUTPUT:
	RETVAL

double
nci_dsdpi( c_func, s0, d1, p2, i3 )
	SV* c_func
	short s0
	double d1
	void * p2
	int i3
PREINIT:
	double(*func)(short, double, void *, int);
CODE:
	func   = INT2PTR(double(*)(short, double, void *, int), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, p2, i3);
OUTPUT:
	RETVAL

double
nci_dsddp( c_func, s0, d1, d2, p3 )
	SV* c_func
	short s0
	double d1
	double d2
	void * p3
PREINIT:
	double(*func)(short, double, double, void *);
CODE:
	func   = INT2PTR(double(*)(short, double, double, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, d2, p3);
OUTPUT:
	RETVAL

double
nci_dsddd( c_func, s0, d1, d2, d3 )
	SV* c_func
	short s0
	double d1
	double d2
	double d3
PREINIT:
	double(*func)(short, double, double, double);
CODE:
	func   = INT2PTR(double(*)(short, double, double, double), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, d2, d3);
OUTPUT:
	RETVAL

double
nci_dsdds( c_func, s0, d1, d2, s3 )
	SV* c_func
	short s0
	double d1
	double d2
	short s3
PREINIT:
	double(*func)(short, double, double, short);
CODE:
	func   = INT2PTR(double(*)(short, double, double, short), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, d2, s3);
OUTPUT:
	RETVAL

double
nci_dsddf( c_func, s0, d1, d2, f3 )
	SV* c_func
	short s0
	double d1
	double d2
	float f3
PREINIT:
	double(*func)(short, double, double, float);
CODE:
	func   = INT2PTR(double(*)(short, double, double, float), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, d2, f3);
OUTPUT:
	RETVAL

double
nci_dsddt( c_func, s0, d1, d2, t3 )
	SV* c_func
	short s0
	double d1
	double d2
	char * t3
PREINIT:
	double(*func)(short, double, double, char *);
CODE:
	func   = INT2PTR(double(*)(short, double, double, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, d2, t3);
OUTPUT:
	RETVAL

double
nci_dsddi( c_func, s0, d1, d2, i3 )
	SV* c_func
	short s0
	double d1
	double d2
	int i3
PREINIT:
	double(*func)(short, double, double, int);
CODE:
	func   = INT2PTR(double(*)(short, double, double, int), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, d2, i3);
OUTPUT:
	RETVAL

double
nci_dsdsp( c_func, s0, d1, s2, p3 )
	SV* c_func
	short s0
	double d1
	short s2
	void * p3
PREINIT:
	double(*func)(short, double, short, void *);
CODE:
	func   = INT2PTR(double(*)(short, double, short, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, s2, p3);
OUTPUT:
	RETVAL

double
nci_dsdsd( c_func, s0, d1, s2, d3 )
	SV* c_func
	short s0
	double d1
	short s2
	double d3
PREINIT:
	double(*func)(short, double, short, double);
CODE:
	func   = INT2PTR(double(*)(short, double, short, double), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, s2, d3);
OUTPUT:
	RETVAL

double
nci_dsdss( c_func, s0, d1, s2, s3 )
	SV* c_func
	short s0
	double d1
	short s2
	short s3
PREINIT:
	double(*func)(short, double, short, short);
CODE:
	func   = INT2PTR(double(*)(short, double, short, short), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, s2, s3);
OUTPUT:
	RETVAL

double
nci_dsdsf( c_func, s0, d1, s2, f3 )
	SV* c_func
	short s0
	double d1
	short s2
	float f3
PREINIT:
	double(*func)(short, double, short, float);
CODE:
	func   = INT2PTR(double(*)(short, double, short, float), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, s2, f3);
OUTPUT:
	RETVAL

double
nci_dsdst( c_func, s0, d1, s2, t3 )
	SV* c_func
	short s0
	double d1
	short s2
	char * t3
PREINIT:
	double(*func)(short, double, short, char *);
CODE:
	func   = INT2PTR(double(*)(short, double, short, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, s2, t3);
OUTPUT:
	RETVAL

double
nci_dsdsi( c_func, s0, d1, s2, i3 )
	SV* c_func
	short s0
	double d1
	short s2
	int i3
PREINIT:
	double(*func)(short, double, short, int);
CODE:
	func   = INT2PTR(double(*)(short, double, short, int), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, s2, i3);
OUTPUT:
	RETVAL

double
nci_dsdfp( c_func, s0, d1, f2, p3 )
	SV* c_func
	short s0
	double d1
	float f2
	void * p3
PREINIT:
	double(*func)(short, double, float, void *);
CODE:
	func   = INT2PTR(double(*)(short, double, float, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, f2, p3);
OUTPUT:
	RETVAL

double
nci_dsdfd( c_func, s0, d1, f2, d3 )
	SV* c_func
	short s0
	double d1
	float f2
	double d3
PREINIT:
	double(*func)(short, double, float, double);
CODE:
	func   = INT2PTR(double(*)(short, double, float, double), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, f2, d3);
OUTPUT:
	RETVAL

double
nci_dsdfs( c_func, s0, d1, f2, s3 )
	SV* c_func
	short s0
	double d1
	float f2
	short s3
PREINIT:
	double(*func)(short, double, float, short);
CODE:
	func   = INT2PTR(double(*)(short, double, float, short), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, f2, s3);
OUTPUT:
	RETVAL

double
nci_dsdff( c_func, s0, d1, f2, f3 )
	SV* c_func
	short s0
	double d1
	float f2
	float f3
PREINIT:
	double(*func)(short, double, float, float);
CODE:
	func   = INT2PTR(double(*)(short, double, float, float), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, f2, f3);
OUTPUT:
	RETVAL

double
nci_dsdft( c_func, s0, d1, f2, t3 )
	SV* c_func
	short s0
	double d1
	float f2
	char * t3
PREINIT:
	double(*func)(short, double, float, char *);
CODE:
	func   = INT2PTR(double(*)(short, double, float, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, f2, t3);
OUTPUT:
	RETVAL

double
nci_dsdfi( c_func, s0, d1, f2, i3 )
	SV* c_func
	short s0
	double d1
	float f2
	int i3
PREINIT:
	double(*func)(short, double, float, int);
CODE:
	func   = INT2PTR(double(*)(short, double, float, int), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, f2, i3);
OUTPUT:
	RETVAL

double
nci_dsdtp( c_func, s0, d1, t2, p3 )
	SV* c_func
	short s0
	double d1
	char * t2
	void * p3
PREINIT:
	double(*func)(short, double, char *, void *);
CODE:
	func   = INT2PTR(double(*)(short, double, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, t2, p3);
OUTPUT:
	RETVAL

double
nci_dsdtd( c_func, s0, d1, t2, d3 )
	SV* c_func
	short s0
	double d1
	char * t2
	double d3
PREINIT:
	double(*func)(short, double, char *, double);
CODE:
	func   = INT2PTR(double(*)(short, double, char *, double), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, t2, d3);
OUTPUT:
	RETVAL

double
nci_dsdts( c_func, s0, d1, t2, s3 )
	SV* c_func
	short s0
	double d1
	char * t2
	short s3
PREINIT:
	double(*func)(short, double, char *, short);
CODE:
	func   = INT2PTR(double(*)(short, double, char *, short), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, t2, s3);
OUTPUT:
	RETVAL

double
nci_dsdtf( c_func, s0, d1, t2, f3 )
	SV* c_func
	short s0
	double d1
	char * t2
	float f3
PREINIT:
	double(*func)(short, double, char *, float);
CODE:
	func   = INT2PTR(double(*)(short, double, char *, float), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, t2, f3);
OUTPUT:
	RETVAL

double
nci_dsdtt( c_func, s0, d1, t2, t3 )
	SV* c_func
	short s0
	double d1
	char * t2
	char * t3
PREINIT:
	double(*func)(short, double, char *, char *);
CODE:
	func   = INT2PTR(double(*)(short, double, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, t2, t3);
OUTPUT:
	RETVAL

double
nci_dsdti( c_func, s0, d1, t2, i3 )
	SV* c_func
	short s0
	double d1
	char * t2
	int i3
PREINIT:
	double(*func)(short, double, char *, int);
CODE:
	func   = INT2PTR(double(*)(short, double, char *, int), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, t2, i3);
OUTPUT:
	RETVAL

double
nci_dsdip( c_func, s0, d1, i2, p3 )
	SV* c_func
	short s0
	double d1
	int i2
	void * p3
PREINIT:
	double(*func)(short, double, int, void *);
CODE:
	func   = INT2PTR(double(*)(short, double, int, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, i2, p3);
OUTPUT:
	RETVAL

double
nci_dsdid( c_func, s0, d1, i2, d3 )
	SV* c_func
	short s0
	double d1
	int i2
	double d3
PREINIT:
	double(*func)(short, double, int, double);
CODE:
	func   = INT2PTR(double(*)(short, double, int, double), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, i2, d3);
OUTPUT:
	RETVAL

double
nci_dsdis( c_func, s0, d1, i2, s3 )
	SV* c_func
	short s0
	double d1
	int i2
	short s3
PREINIT:
	double(*func)(short, double, int, short);
CODE:
	func   = INT2PTR(double(*)(short, double, int, short), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, i2, s3);
OUTPUT:
	RETVAL

double
nci_dsdif( c_func, s0, d1, i2, f3 )
	SV* c_func
	short s0
	double d1
	int i2
	float f3
PREINIT:
	double(*func)(short, double, int, float);
CODE:
	func   = INT2PTR(double(*)(short, double, int, float), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, i2, f3);
OUTPUT:
	RETVAL

double
nci_dsdit( c_func, s0, d1, i2, t3 )
	SV* c_func
	short s0
	double d1
	int i2
	char * t3
PREINIT:
	double(*func)(short, double, int, char *);
CODE:
	func   = INT2PTR(double(*)(short, double, int, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, i2, t3);
OUTPUT:
	RETVAL

double
nci_dsdii( c_func, s0, d1, i2, i3 )
	SV* c_func
	short s0
	double d1
	int i2
	int i3
PREINIT:
	double(*func)(short, double, int, int);
CODE:
	func   = INT2PTR(double(*)(short, double, int, int), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, i2, i3);
OUTPUT:
	RETVAL

double
nci_dsspp( c_func, s0, s1, p2, p3 )
	SV* c_func
	short s0
	short s1
	void * p2
	void * p3
PREINIT:
	double(*func)(short, short, void *, void *);
CODE:
	func   = INT2PTR(double(*)(short, short, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, p2, p3);
OUTPUT:
	RETVAL

double
nci_dsspd( c_func, s0, s1, p2, d3 )
	SV* c_func
	short s0
	short s1
	void * p2
	double d3
PREINIT:
	double(*func)(short, short, void *, double);
CODE:
	func   = INT2PTR(double(*)(short, short, void *, double), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, p2, d3);
OUTPUT:
	RETVAL

double
nci_dssps( c_func, s0, s1, p2, s3 )
	SV* c_func
	short s0
	short s1
	void * p2
	short s3
PREINIT:
	double(*func)(short, short, void *, short);
CODE:
	func   = INT2PTR(double(*)(short, short, void *, short), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, p2, s3);
OUTPUT:
	RETVAL

double
nci_dsspf( c_func, s0, s1, p2, f3 )
	SV* c_func
	short s0
	short s1
	void * p2
	float f3
PREINIT:
	double(*func)(short, short, void *, float);
CODE:
	func   = INT2PTR(double(*)(short, short, void *, float), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, p2, f3);
OUTPUT:
	RETVAL

double
nci_dsspt( c_func, s0, s1, p2, t3 )
	SV* c_func
	short s0
	short s1
	void * p2
	char * t3
PREINIT:
	double(*func)(short, short, void *, char *);
CODE:
	func   = INT2PTR(double(*)(short, short, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, p2, t3);
OUTPUT:
	RETVAL

double
nci_dsspi( c_func, s0, s1, p2, i3 )
	SV* c_func
	short s0
	short s1
	void * p2
	int i3
PREINIT:
	double(*func)(short, short, void *, int);
CODE:
	func   = INT2PTR(double(*)(short, short, void *, int), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, p2, i3);
OUTPUT:
	RETVAL

double
nci_dssdp( c_func, s0, s1, d2, p3 )
	SV* c_func
	short s0
	short s1
	double d2
	void * p3
PREINIT:
	double(*func)(short, short, double, void *);
CODE:
	func   = INT2PTR(double(*)(short, short, double, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, d2, p3);
OUTPUT:
	RETVAL

double
nci_dssdd( c_func, s0, s1, d2, d3 )
	SV* c_func
	short s0
	short s1
	double d2
	double d3
PREINIT:
	double(*func)(short, short, double, double);
CODE:
	func   = INT2PTR(double(*)(short, short, double, double), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, d2, d3);
OUTPUT:
	RETVAL

double
nci_dssds( c_func, s0, s1, d2, s3 )
	SV* c_func
	short s0
	short s1
	double d2
	short s3
PREINIT:
	double(*func)(short, short, double, short);
CODE:
	func   = INT2PTR(double(*)(short, short, double, short), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, d2, s3);
OUTPUT:
	RETVAL

double
nci_dssdf( c_func, s0, s1, d2, f3 )
	SV* c_func
	short s0
	short s1
	double d2
	float f3
PREINIT:
	double(*func)(short, short, double, float);
CODE:
	func   = INT2PTR(double(*)(short, short, double, float), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, d2, f3);
OUTPUT:
	RETVAL

double
nci_dssdt( c_func, s0, s1, d2, t3 )
	SV* c_func
	short s0
	short s1
	double d2
	char * t3
PREINIT:
	double(*func)(short, short, double, char *);
CODE:
	func   = INT2PTR(double(*)(short, short, double, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, d2, t3);
OUTPUT:
	RETVAL

double
nci_dssdi( c_func, s0, s1, d2, i3 )
	SV* c_func
	short s0
	short s1
	double d2
	int i3
PREINIT:
	double(*func)(short, short, double, int);
CODE:
	func   = INT2PTR(double(*)(short, short, double, int), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, d2, i3);
OUTPUT:
	RETVAL

double
nci_dsssp( c_func, s0, s1, s2, p3 )
	SV* c_func
	short s0
	short s1
	short s2
	void * p3
PREINIT:
	double(*func)(short, short, short, void *);
CODE:
	func   = INT2PTR(double(*)(short, short, short, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, s2, p3);
OUTPUT:
	RETVAL

double
nci_dsssd( c_func, s0, s1, s2, d3 )
	SV* c_func
	short s0
	short s1
	short s2
	double d3
PREINIT:
	double(*func)(short, short, short, double);
CODE:
	func   = INT2PTR(double(*)(short, short, short, double), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, s2, d3);
OUTPUT:
	RETVAL

double
nci_dssss( c_func, s0, s1, s2, s3 )
	SV* c_func
	short s0
	short s1
	short s2
	short s3
PREINIT:
	double(*func)(short, short, short, short);
CODE:
	func   = INT2PTR(double(*)(short, short, short, short), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, s2, s3);
OUTPUT:
	RETVAL

double
nci_dsssf( c_func, s0, s1, s2, f3 )
	SV* c_func
	short s0
	short s1
	short s2
	float f3
PREINIT:
	double(*func)(short, short, short, float);
CODE:
	func   = INT2PTR(double(*)(short, short, short, float), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, s2, f3);
OUTPUT:
	RETVAL

double
nci_dssst( c_func, s0, s1, s2, t3 )
	SV* c_func
	short s0
	short s1
	short s2
	char * t3
PREINIT:
	double(*func)(short, short, short, char *);
CODE:
	func   = INT2PTR(double(*)(short, short, short, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, s2, t3);
OUTPUT:
	RETVAL

double
nci_dsssi( c_func, s0, s1, s2, i3 )
	SV* c_func
	short s0
	short s1
	short s2
	int i3
PREINIT:
	double(*func)(short, short, short, int);
CODE:
	func   = INT2PTR(double(*)(short, short, short, int), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, s2, i3);
OUTPUT:
	RETVAL

double
nci_dssfp( c_func, s0, s1, f2, p3 )
	SV* c_func
	short s0
	short s1
	float f2
	void * p3
PREINIT:
	double(*func)(short, short, float, void *);
CODE:
	func   = INT2PTR(double(*)(short, short, float, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, f2, p3);
OUTPUT:
	RETVAL

double
nci_dssfd( c_func, s0, s1, f2, d3 )
	SV* c_func
	short s0
	short s1
	float f2
	double d3
PREINIT:
	double(*func)(short, short, float, double);
CODE:
	func   = INT2PTR(double(*)(short, short, float, double), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, f2, d3);
OUTPUT:
	RETVAL

double
nci_dssfs( c_func, s0, s1, f2, s3 )
	SV* c_func
	short s0
	short s1
	float f2
	short s3
PREINIT:
	double(*func)(short, short, float, short);
CODE:
	func   = INT2PTR(double(*)(short, short, float, short), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, f2, s3);
OUTPUT:
	RETVAL

double
nci_dssff( c_func, s0, s1, f2, f3 )
	SV* c_func
	short s0
	short s1
	float f2
	float f3
PREINIT:
	double(*func)(short, short, float, float);
CODE:
	func   = INT2PTR(double(*)(short, short, float, float), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, f2, f3);
OUTPUT:
	RETVAL

double
nci_dssft( c_func, s0, s1, f2, t3 )
	SV* c_func
	short s0
	short s1
	float f2
	char * t3
PREINIT:
	double(*func)(short, short, float, char *);
CODE:
	func   = INT2PTR(double(*)(short, short, float, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, f2, t3);
OUTPUT:
	RETVAL

double
nci_dssfi( c_func, s0, s1, f2, i3 )
	SV* c_func
	short s0
	short s1
	float f2
	int i3
PREINIT:
	double(*func)(short, short, float, int);
CODE:
	func   = INT2PTR(double(*)(short, short, float, int), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, f2, i3);
OUTPUT:
	RETVAL

double
nci_dsstp( c_func, s0, s1, t2, p3 )
	SV* c_func
	short s0
	short s1
	char * t2
	void * p3
PREINIT:
	double(*func)(short, short, char *, void *);
CODE:
	func   = INT2PTR(double(*)(short, short, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, t2, p3);
OUTPUT:
	RETVAL

double
nci_dsstd( c_func, s0, s1, t2, d3 )
	SV* c_func
	short s0
	short s1
	char * t2
	double d3
PREINIT:
	double(*func)(short, short, char *, double);
CODE:
	func   = INT2PTR(double(*)(short, short, char *, double), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, t2, d3);
OUTPUT:
	RETVAL

double
nci_dssts( c_func, s0, s1, t2, s3 )
	SV* c_func
	short s0
	short s1
	char * t2
	short s3
PREINIT:
	double(*func)(short, short, char *, short);
CODE:
	func   = INT2PTR(double(*)(short, short, char *, short), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, t2, s3);
OUTPUT:
	RETVAL

double
nci_dsstf( c_func, s0, s1, t2, f3 )
	SV* c_func
	short s0
	short s1
	char * t2
	float f3
PREINIT:
	double(*func)(short, short, char *, float);
CODE:
	func   = INT2PTR(double(*)(short, short, char *, float), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, t2, f3);
OUTPUT:
	RETVAL

double
nci_dsstt( c_func, s0, s1, t2, t3 )
	SV* c_func
	short s0
	short s1
	char * t2
	char * t3
PREINIT:
	double(*func)(short, short, char *, char *);
CODE:
	func   = INT2PTR(double(*)(short, short, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, t2, t3);
OUTPUT:
	RETVAL

double
nci_dssti( c_func, s0, s1, t2, i3 )
	SV* c_func
	short s0
	short s1
	char * t2
	int i3
PREINIT:
	double(*func)(short, short, char *, int);
CODE:
	func   = INT2PTR(double(*)(short, short, char *, int), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, t2, i3);
OUTPUT:
	RETVAL

double
nci_dssip( c_func, s0, s1, i2, p3 )
	SV* c_func
	short s0
	short s1
	int i2
	void * p3
PREINIT:
	double(*func)(short, short, int, void *);
CODE:
	func   = INT2PTR(double(*)(short, short, int, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, i2, p3);
OUTPUT:
	RETVAL

double
nci_dssid( c_func, s0, s1, i2, d3 )
	SV* c_func
	short s0
	short s1
	int i2
	double d3
PREINIT:
	double(*func)(short, short, int, double);
CODE:
	func   = INT2PTR(double(*)(short, short, int, double), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, i2, d3);
OUTPUT:
	RETVAL

double
nci_dssis( c_func, s0, s1, i2, s3 )
	SV* c_func
	short s0
	short s1
	int i2
	short s3
PREINIT:
	double(*func)(short, short, int, short);
CODE:
	func   = INT2PTR(double(*)(short, short, int, short), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, i2, s3);
OUTPUT:
	RETVAL

double
nci_dssif( c_func, s0, s1, i2, f3 )
	SV* c_func
	short s0
	short s1
	int i2
	float f3
PREINIT:
	double(*func)(short, short, int, float);
CODE:
	func   = INT2PTR(double(*)(short, short, int, float), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, i2, f3);
OUTPUT:
	RETVAL

double
nci_dssit( c_func, s0, s1, i2, t3 )
	SV* c_func
	short s0
	short s1
	int i2
	char * t3
PREINIT:
	double(*func)(short, short, int, char *);
CODE:
	func   = INT2PTR(double(*)(short, short, int, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, i2, t3);
OUTPUT:
	RETVAL

double
nci_dssii( c_func, s0, s1, i2, i3 )
	SV* c_func
	short s0
	short s1
	int i2
	int i3
PREINIT:
	double(*func)(short, short, int, int);
CODE:
	func   = INT2PTR(double(*)(short, short, int, int), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, i2, i3);
OUTPUT:
	RETVAL

double
nci_dsfpp( c_func, s0, f1, p2, p3 )
	SV* c_func
	short s0
	float f1
	void * p2
	void * p3
PREINIT:
	double(*func)(short, float, void *, void *);
CODE:
	func   = INT2PTR(double(*)(short, float, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, p2, p3);
OUTPUT:
	RETVAL

double
nci_dsfpd( c_func, s0, f1, p2, d3 )
	SV* c_func
	short s0
	float f1
	void * p2
	double d3
PREINIT:
	double(*func)(short, float, void *, double);
CODE:
	func   = INT2PTR(double(*)(short, float, void *, double), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, p2, d3);
OUTPUT:
	RETVAL

double
nci_dsfps( c_func, s0, f1, p2, s3 )
	SV* c_func
	short s0
	float f1
	void * p2
	short s3
PREINIT:
	double(*func)(short, float, void *, short);
CODE:
	func   = INT2PTR(double(*)(short, float, void *, short), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, p2, s3);
OUTPUT:
	RETVAL

double
nci_dsfpf( c_func, s0, f1, p2, f3 )
	SV* c_func
	short s0
	float f1
	void * p2
	float f3
PREINIT:
	double(*func)(short, float, void *, float);
CODE:
	func   = INT2PTR(double(*)(short, float, void *, float), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, p2, f3);
OUTPUT:
	RETVAL

double
nci_dsfpt( c_func, s0, f1, p2, t3 )
	SV* c_func
	short s0
	float f1
	void * p2
	char * t3
PREINIT:
	double(*func)(short, float, void *, char *);
CODE:
	func   = INT2PTR(double(*)(short, float, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, p2, t3);
OUTPUT:
	RETVAL

double
nci_dsfpi( c_func, s0, f1, p2, i3 )
	SV* c_func
	short s0
	float f1
	void * p2
	int i3
PREINIT:
	double(*func)(short, float, void *, int);
CODE:
	func   = INT2PTR(double(*)(short, float, void *, int), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, p2, i3);
OUTPUT:
	RETVAL

double
nci_dsfdp( c_func, s0, f1, d2, p3 )
	SV* c_func
	short s0
	float f1
	double d2
	void * p3
PREINIT:
	double(*func)(short, float, double, void *);
CODE:
	func   = INT2PTR(double(*)(short, float, double, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, d2, p3);
OUTPUT:
	RETVAL

double
nci_dsfdd( c_func, s0, f1, d2, d3 )
	SV* c_func
	short s0
	float f1
	double d2
	double d3
PREINIT:
	double(*func)(short, float, double, double);
CODE:
	func   = INT2PTR(double(*)(short, float, double, double), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, d2, d3);
OUTPUT:
	RETVAL

double
nci_dsfds( c_func, s0, f1, d2, s3 )
	SV* c_func
	short s0
	float f1
	double d2
	short s3
PREINIT:
	double(*func)(short, float, double, short);
CODE:
	func   = INT2PTR(double(*)(short, float, double, short), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, d2, s3);
OUTPUT:
	RETVAL

double
nci_dsfdf( c_func, s0, f1, d2, f3 )
	SV* c_func
	short s0
	float f1
	double d2
	float f3
PREINIT:
	double(*func)(short, float, double, float);
CODE:
	func   = INT2PTR(double(*)(short, float, double, float), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, d2, f3);
OUTPUT:
	RETVAL

double
nci_dsfdt( c_func, s0, f1, d2, t3 )
	SV* c_func
	short s0
	float f1
	double d2
	char * t3
PREINIT:
	double(*func)(short, float, double, char *);
CODE:
	func   = INT2PTR(double(*)(short, float, double, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, d2, t3);
OUTPUT:
	RETVAL

double
nci_dsfdi( c_func, s0, f1, d2, i3 )
	SV* c_func
	short s0
	float f1
	double d2
	int i3
PREINIT:
	double(*func)(short, float, double, int);
CODE:
	func   = INT2PTR(double(*)(short, float, double, int), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, d2, i3);
OUTPUT:
	RETVAL

double
nci_dsfsp( c_func, s0, f1, s2, p3 )
	SV* c_func
	short s0
	float f1
	short s2
	void * p3
PREINIT:
	double(*func)(short, float, short, void *);
CODE:
	func   = INT2PTR(double(*)(short, float, short, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, s2, p3);
OUTPUT:
	RETVAL

double
nci_dsfsd( c_func, s0, f1, s2, d3 )
	SV* c_func
	short s0
	float f1
	short s2
	double d3
PREINIT:
	double(*func)(short, float, short, double);
CODE:
	func   = INT2PTR(double(*)(short, float, short, double), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, s2, d3);
OUTPUT:
	RETVAL

double
nci_dsfss( c_func, s0, f1, s2, s3 )
	SV* c_func
	short s0
	float f1
	short s2
	short s3
PREINIT:
	double(*func)(short, float, short, short);
CODE:
	func   = INT2PTR(double(*)(short, float, short, short), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, s2, s3);
OUTPUT:
	RETVAL

double
nci_dsfsf( c_func, s0, f1, s2, f3 )
	SV* c_func
	short s0
	float f1
	short s2
	float f3
PREINIT:
	double(*func)(short, float, short, float);
CODE:
	func   = INT2PTR(double(*)(short, float, short, float), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, s2, f3);
OUTPUT:
	RETVAL

double
nci_dsfst( c_func, s0, f1, s2, t3 )
	SV* c_func
	short s0
	float f1
	short s2
	char * t3
PREINIT:
	double(*func)(short, float, short, char *);
CODE:
	func   = INT2PTR(double(*)(short, float, short, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, s2, t3);
OUTPUT:
	RETVAL

double
nci_dsfsi( c_func, s0, f1, s2, i3 )
	SV* c_func
	short s0
	float f1
	short s2
	int i3
PREINIT:
	double(*func)(short, float, short, int);
CODE:
	func   = INT2PTR(double(*)(short, float, short, int), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, s2, i3);
OUTPUT:
	RETVAL

double
nci_dsffp( c_func, s0, f1, f2, p3 )
	SV* c_func
	short s0
	float f1
	float f2
	void * p3
PREINIT:
	double(*func)(short, float, float, void *);
CODE:
	func   = INT2PTR(double(*)(short, float, float, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, f2, p3);
OUTPUT:
	RETVAL

double
nci_dsffd( c_func, s0, f1, f2, d3 )
	SV* c_func
	short s0
	float f1
	float f2
	double d3
PREINIT:
	double(*func)(short, float, float, double);
CODE:
	func   = INT2PTR(double(*)(short, float, float, double), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, f2, d3);
OUTPUT:
	RETVAL

double
nci_dsffs( c_func, s0, f1, f2, s3 )
	SV* c_func
	short s0
	float f1
	float f2
	short s3
PREINIT:
	double(*func)(short, float, float, short);
CODE:
	func   = INT2PTR(double(*)(short, float, float, short), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, f2, s3);
OUTPUT:
	RETVAL

double
nci_dsfff( c_func, s0, f1, f2, f3 )
	SV* c_func
	short s0
	float f1
	float f2
	float f3
PREINIT:
	double(*func)(short, float, float, float);
CODE:
	func   = INT2PTR(double(*)(short, float, float, float), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, f2, f3);
OUTPUT:
	RETVAL

double
nci_dsfft( c_func, s0, f1, f2, t3 )
	SV* c_func
	short s0
	float f1
	float f2
	char * t3
PREINIT:
	double(*func)(short, float, float, char *);
CODE:
	func   = INT2PTR(double(*)(short, float, float, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, f2, t3);
OUTPUT:
	RETVAL

double
nci_dsffi( c_func, s0, f1, f2, i3 )
	SV* c_func
	short s0
	float f1
	float f2
	int i3
PREINIT:
	double(*func)(short, float, float, int);
CODE:
	func   = INT2PTR(double(*)(short, float, float, int), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, f2, i3);
OUTPUT:
	RETVAL

double
nci_dsftp( c_func, s0, f1, t2, p3 )
	SV* c_func
	short s0
	float f1
	char * t2
	void * p3
PREINIT:
	double(*func)(short, float, char *, void *);
CODE:
	func   = INT2PTR(double(*)(short, float, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, t2, p3);
OUTPUT:
	RETVAL

double
nci_dsftd( c_func, s0, f1, t2, d3 )
	SV* c_func
	short s0
	float f1
	char * t2
	double d3
PREINIT:
	double(*func)(short, float, char *, double);
CODE:
	func   = INT2PTR(double(*)(short, float, char *, double), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, t2, d3);
OUTPUT:
	RETVAL

double
nci_dsfts( c_func, s0, f1, t2, s3 )
	SV* c_func
	short s0
	float f1
	char * t2
	short s3
PREINIT:
	double(*func)(short, float, char *, short);
CODE:
	func   = INT2PTR(double(*)(short, float, char *, short), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, t2, s3);
OUTPUT:
	RETVAL

double
nci_dsftf( c_func, s0, f1, t2, f3 )
	SV* c_func
	short s0
	float f1
	char * t2
	float f3
PREINIT:
	double(*func)(short, float, char *, float);
CODE:
	func   = INT2PTR(double(*)(short, float, char *, float), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, t2, f3);
OUTPUT:
	RETVAL

double
nci_dsftt( c_func, s0, f1, t2, t3 )
	SV* c_func
	short s0
	float f1
	char * t2
	char * t3
PREINIT:
	double(*func)(short, float, char *, char *);
CODE:
	func   = INT2PTR(double(*)(short, float, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, t2, t3);
OUTPUT:
	RETVAL

double
nci_dsfti( c_func, s0, f1, t2, i3 )
	SV* c_func
	short s0
	float f1
	char * t2
	int i3
PREINIT:
	double(*func)(short, float, char *, int);
CODE:
	func   = INT2PTR(double(*)(short, float, char *, int), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, t2, i3);
OUTPUT:
	RETVAL

double
nci_dsfip( c_func, s0, f1, i2, p3 )
	SV* c_func
	short s0
	float f1
	int i2
	void * p3
PREINIT:
	double(*func)(short, float, int, void *);
CODE:
	func   = INT2PTR(double(*)(short, float, int, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, i2, p3);
OUTPUT:
	RETVAL

double
nci_dsfid( c_func, s0, f1, i2, d3 )
	SV* c_func
	short s0
	float f1
	int i2
	double d3
PREINIT:
	double(*func)(short, float, int, double);
CODE:
	func   = INT2PTR(double(*)(short, float, int, double), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, i2, d3);
OUTPUT:
	RETVAL

double
nci_dsfis( c_func, s0, f1, i2, s3 )
	SV* c_func
	short s0
	float f1
	int i2
	short s3
PREINIT:
	double(*func)(short, float, int, short);
CODE:
	func   = INT2PTR(double(*)(short, float, int, short), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, i2, s3);
OUTPUT:
	RETVAL

double
nci_dsfif( c_func, s0, f1, i2, f3 )
	SV* c_func
	short s0
	float f1
	int i2
	float f3
PREINIT:
	double(*func)(short, float, int, float);
CODE:
	func   = INT2PTR(double(*)(short, float, int, float), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, i2, f3);
OUTPUT:
	RETVAL

double
nci_dsfit( c_func, s0, f1, i2, t3 )
	SV* c_func
	short s0
	float f1
	int i2
	char * t3
PREINIT:
	double(*func)(short, float, int, char *);
CODE:
	func   = INT2PTR(double(*)(short, float, int, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, i2, t3);
OUTPUT:
	RETVAL

double
nci_dsfii( c_func, s0, f1, i2, i3 )
	SV* c_func
	short s0
	float f1
	int i2
	int i3
PREINIT:
	double(*func)(short, float, int, int);
CODE:
	func   = INT2PTR(double(*)(short, float, int, int), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, i2, i3);
OUTPUT:
	RETVAL

double
nci_dstpp( c_func, s0, t1, p2, p3 )
	SV* c_func
	short s0
	char * t1
	void * p2
	void * p3
PREINIT:
	double(*func)(short, char *, void *, void *);
CODE:
	func   = INT2PTR(double(*)(short, char *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, p2, p3);
OUTPUT:
	RETVAL

double
nci_dstpd( c_func, s0, t1, p2, d3 )
	SV* c_func
	short s0
	char * t1
	void * p2
	double d3
PREINIT:
	double(*func)(short, char *, void *, double);
CODE:
	func   = INT2PTR(double(*)(short, char *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, p2, d3);
OUTPUT:
	RETVAL

double
nci_dstps( c_func, s0, t1, p2, s3 )
	SV* c_func
	short s0
	char * t1
	void * p2
	short s3
PREINIT:
	double(*func)(short, char *, void *, short);
CODE:
	func   = INT2PTR(double(*)(short, char *, void *, short), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, p2, s3);
OUTPUT:
	RETVAL

double
nci_dstpf( c_func, s0, t1, p2, f3 )
	SV* c_func
	short s0
	char * t1
	void * p2
	float f3
PREINIT:
	double(*func)(short, char *, void *, float);
CODE:
	func   = INT2PTR(double(*)(short, char *, void *, float), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, p2, f3);
OUTPUT:
	RETVAL

double
nci_dstpt( c_func, s0, t1, p2, t3 )
	SV* c_func
	short s0
	char * t1
	void * p2
	char * t3
PREINIT:
	double(*func)(short, char *, void *, char *);
CODE:
	func   = INT2PTR(double(*)(short, char *, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, p2, t3);
OUTPUT:
	RETVAL

double
nci_dstpi( c_func, s0, t1, p2, i3 )
	SV* c_func
	short s0
	char * t1
	void * p2
	int i3
PREINIT:
	double(*func)(short, char *, void *, int);
CODE:
	func   = INT2PTR(double(*)(short, char *, void *, int), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, p2, i3);
OUTPUT:
	RETVAL

double
nci_dstdp( c_func, s0, t1, d2, p3 )
	SV* c_func
	short s0
	char * t1
	double d2
	void * p3
PREINIT:
	double(*func)(short, char *, double, void *);
CODE:
	func   = INT2PTR(double(*)(short, char *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, d2, p3);
OUTPUT:
	RETVAL

double
nci_dstdd( c_func, s0, t1, d2, d3 )
	SV* c_func
	short s0
	char * t1
	double d2
	double d3
PREINIT:
	double(*func)(short, char *, double, double);
CODE:
	func   = INT2PTR(double(*)(short, char *, double, double), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, d2, d3);
OUTPUT:
	RETVAL

double
nci_dstds( c_func, s0, t1, d2, s3 )
	SV* c_func
	short s0
	char * t1
	double d2
	short s3
PREINIT:
	double(*func)(short, char *, double, short);
CODE:
	func   = INT2PTR(double(*)(short, char *, double, short), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, d2, s3);
OUTPUT:
	RETVAL

double
nci_dstdf( c_func, s0, t1, d2, f3 )
	SV* c_func
	short s0
	char * t1
	double d2
	float f3
PREINIT:
	double(*func)(short, char *, double, float);
CODE:
	func   = INT2PTR(double(*)(short, char *, double, float), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, d2, f3);
OUTPUT:
	RETVAL

double
nci_dstdt( c_func, s0, t1, d2, t3 )
	SV* c_func
	short s0
	char * t1
	double d2
	char * t3
PREINIT:
	double(*func)(short, char *, double, char *);
CODE:
	func   = INT2PTR(double(*)(short, char *, double, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, d2, t3);
OUTPUT:
	RETVAL

double
nci_dstdi( c_func, s0, t1, d2, i3 )
	SV* c_func
	short s0
	char * t1
	double d2
	int i3
PREINIT:
	double(*func)(short, char *, double, int);
CODE:
	func   = INT2PTR(double(*)(short, char *, double, int), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, d2, i3);
OUTPUT:
	RETVAL

double
nci_dstsp( c_func, s0, t1, s2, p3 )
	SV* c_func
	short s0
	char * t1
	short s2
	void * p3
PREINIT:
	double(*func)(short, char *, short, void *);
CODE:
	func   = INT2PTR(double(*)(short, char *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, s2, p3);
OUTPUT:
	RETVAL

double
nci_dstsd( c_func, s0, t1, s2, d3 )
	SV* c_func
	short s0
	char * t1
	short s2
	double d3
PREINIT:
	double(*func)(short, char *, short, double);
CODE:
	func   = INT2PTR(double(*)(short, char *, short, double), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, s2, d3);
OUTPUT:
	RETVAL

double
nci_dstss( c_func, s0, t1, s2, s3 )
	SV* c_func
	short s0
	char * t1
	short s2
	short s3
PREINIT:
	double(*func)(short, char *, short, short);
CODE:
	func   = INT2PTR(double(*)(short, char *, short, short), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, s2, s3);
OUTPUT:
	RETVAL

double
nci_dstsf( c_func, s0, t1, s2, f3 )
	SV* c_func
	short s0
	char * t1
	short s2
	float f3
PREINIT:
	double(*func)(short, char *, short, float);
CODE:
	func   = INT2PTR(double(*)(short, char *, short, float), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, s2, f3);
OUTPUT:
	RETVAL

double
nci_dstst( c_func, s0, t1, s2, t3 )
	SV* c_func
	short s0
	char * t1
	short s2
	char * t3
PREINIT:
	double(*func)(short, char *, short, char *);
CODE:
	func   = INT2PTR(double(*)(short, char *, short, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, s2, t3);
OUTPUT:
	RETVAL

double
nci_dstsi( c_func, s0, t1, s2, i3 )
	SV* c_func
	short s0
	char * t1
	short s2
	int i3
PREINIT:
	double(*func)(short, char *, short, int);
CODE:
	func   = INT2PTR(double(*)(short, char *, short, int), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, s2, i3);
OUTPUT:
	RETVAL

double
nci_dstfp( c_func, s0, t1, f2, p3 )
	SV* c_func
	short s0
	char * t1
	float f2
	void * p3
PREINIT:
	double(*func)(short, char *, float, void *);
CODE:
	func   = INT2PTR(double(*)(short, char *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, f2, p3);
OUTPUT:
	RETVAL

double
nci_dstfd( c_func, s0, t1, f2, d3 )
	SV* c_func
	short s0
	char * t1
	float f2
	double d3
PREINIT:
	double(*func)(short, char *, float, double);
CODE:
	func   = INT2PTR(double(*)(short, char *, float, double), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, f2, d3);
OUTPUT:
	RETVAL

double
nci_dstfs( c_func, s0, t1, f2, s3 )
	SV* c_func
	short s0
	char * t1
	float f2
	short s3
PREINIT:
	double(*func)(short, char *, float, short);
CODE:
	func   = INT2PTR(double(*)(short, char *, float, short), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, f2, s3);
OUTPUT:
	RETVAL

double
nci_dstff( c_func, s0, t1, f2, f3 )
	SV* c_func
	short s0
	char * t1
	float f2
	float f3
PREINIT:
	double(*func)(short, char *, float, float);
CODE:
	func   = INT2PTR(double(*)(short, char *, float, float), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, f2, f3);
OUTPUT:
	RETVAL

double
nci_dstft( c_func, s0, t1, f2, t3 )
	SV* c_func
	short s0
	char * t1
	float f2
	char * t3
PREINIT:
	double(*func)(short, char *, float, char *);
CODE:
	func   = INT2PTR(double(*)(short, char *, float, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, f2, t3);
OUTPUT:
	RETVAL

double
nci_dstfi( c_func, s0, t1, f2, i3 )
	SV* c_func
	short s0
	char * t1
	float f2
	int i3
PREINIT:
	double(*func)(short, char *, float, int);
CODE:
	func   = INT2PTR(double(*)(short, char *, float, int), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, f2, i3);
OUTPUT:
	RETVAL

double
nci_dsttp( c_func, s0, t1, t2, p3 )
	SV* c_func
	short s0
	char * t1
	char * t2
	void * p3
PREINIT:
	double(*func)(short, char *, char *, void *);
CODE:
	func   = INT2PTR(double(*)(short, char *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, t2, p3);
OUTPUT:
	RETVAL

double
nci_dsttd( c_func, s0, t1, t2, d3 )
	SV* c_func
	short s0
	char * t1
	char * t2
	double d3
PREINIT:
	double(*func)(short, char *, char *, double);
CODE:
	func   = INT2PTR(double(*)(short, char *, char *, double), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, t2, d3);
OUTPUT:
	RETVAL

double
nci_dstts( c_func, s0, t1, t2, s3 )
	SV* c_func
	short s0
	char * t1
	char * t2
	short s3
PREINIT:
	double(*func)(short, char *, char *, short);
CODE:
	func   = INT2PTR(double(*)(short, char *, char *, short), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, t2, s3);
OUTPUT:
	RETVAL

double
nci_dsttf( c_func, s0, t1, t2, f3 )
	SV* c_func
	short s0
	char * t1
	char * t2
	float f3
PREINIT:
	double(*func)(short, char *, char *, float);
CODE:
	func   = INT2PTR(double(*)(short, char *, char *, float), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, t2, f3);
OUTPUT:
	RETVAL

double
nci_dsttt( c_func, s0, t1, t2, t3 )
	SV* c_func
	short s0
	char * t1
	char * t2
	char * t3
PREINIT:
	double(*func)(short, char *, char *, char *);
CODE:
	func   = INT2PTR(double(*)(short, char *, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, t2, t3);
OUTPUT:
	RETVAL

double
nci_dstti( c_func, s0, t1, t2, i3 )
	SV* c_func
	short s0
	char * t1
	char * t2
	int i3
PREINIT:
	double(*func)(short, char *, char *, int);
CODE:
	func   = INT2PTR(double(*)(short, char *, char *, int), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, t2, i3);
OUTPUT:
	RETVAL

double
nci_dstip( c_func, s0, t1, i2, p3 )
	SV* c_func
	short s0
	char * t1
	int i2
	void * p3
PREINIT:
	double(*func)(short, char *, int, void *);
CODE:
	func   = INT2PTR(double(*)(short, char *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, i2, p3);
OUTPUT:
	RETVAL

double
nci_dstid( c_func, s0, t1, i2, d3 )
	SV* c_func
	short s0
	char * t1
	int i2
	double d3
PREINIT:
	double(*func)(short, char *, int, double);
CODE:
	func   = INT2PTR(double(*)(short, char *, int, double), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, i2, d3);
OUTPUT:
	RETVAL

double
nci_dstis( c_func, s0, t1, i2, s3 )
	SV* c_func
	short s0
	char * t1
	int i2
	short s3
PREINIT:
	double(*func)(short, char *, int, short);
CODE:
	func   = INT2PTR(double(*)(short, char *, int, short), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, i2, s3);
OUTPUT:
	RETVAL

double
nci_dstif( c_func, s0, t1, i2, f3 )
	SV* c_func
	short s0
	char * t1
	int i2
	float f3
PREINIT:
	double(*func)(short, char *, int, float);
CODE:
	func   = INT2PTR(double(*)(short, char *, int, float), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, i2, f3);
OUTPUT:
	RETVAL

double
nci_dstit( c_func, s0, t1, i2, t3 )
	SV* c_func
	short s0
	char * t1
	int i2
	char * t3
PREINIT:
	double(*func)(short, char *, int, char *);
CODE:
	func   = INT2PTR(double(*)(short, char *, int, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, i2, t3);
OUTPUT:
	RETVAL

double
nci_dstii( c_func, s0, t1, i2, i3 )
	SV* c_func
	short s0
	char * t1
	int i2
	int i3
PREINIT:
	double(*func)(short, char *, int, int);
CODE:
	func   = INT2PTR(double(*)(short, char *, int, int), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, i2, i3);
OUTPUT:
	RETVAL

double
nci_dsipp( c_func, s0, i1, p2, p3 )
	SV* c_func
	short s0
	int i1
	void * p2
	void * p3
PREINIT:
	double(*func)(short, int, void *, void *);
CODE:
	func   = INT2PTR(double(*)(short, int, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, p2, p3);
OUTPUT:
	RETVAL

double
nci_dsipd( c_func, s0, i1, p2, d3 )
	SV* c_func
	short s0
	int i1
	void * p2
	double d3
PREINIT:
	double(*func)(short, int, void *, double);
CODE:
	func   = INT2PTR(double(*)(short, int, void *, double), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, p2, d3);
OUTPUT:
	RETVAL

double
nci_dsips( c_func, s0, i1, p2, s3 )
	SV* c_func
	short s0
	int i1
	void * p2
	short s3
PREINIT:
	double(*func)(short, int, void *, short);
CODE:
	func   = INT2PTR(double(*)(short, int, void *, short), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, p2, s3);
OUTPUT:
	RETVAL

double
nci_dsipf( c_func, s0, i1, p2, f3 )
	SV* c_func
	short s0
	int i1
	void * p2
	float f3
PREINIT:
	double(*func)(short, int, void *, float);
CODE:
	func   = INT2PTR(double(*)(short, int, void *, float), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, p2, f3);
OUTPUT:
	RETVAL

double
nci_dsipt( c_func, s0, i1, p2, t3 )
	SV* c_func
	short s0
	int i1
	void * p2
	char * t3
PREINIT:
	double(*func)(short, int, void *, char *);
CODE:
	func   = INT2PTR(double(*)(short, int, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, p2, t3);
OUTPUT:
	RETVAL

double
nci_dsipi( c_func, s0, i1, p2, i3 )
	SV* c_func
	short s0
	int i1
	void * p2
	int i3
PREINIT:
	double(*func)(short, int, void *, int);
CODE:
	func   = INT2PTR(double(*)(short, int, void *, int), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, p2, i3);
OUTPUT:
	RETVAL

double
nci_dsidp( c_func, s0, i1, d2, p3 )
	SV* c_func
	short s0
	int i1
	double d2
	void * p3
PREINIT:
	double(*func)(short, int, double, void *);
CODE:
	func   = INT2PTR(double(*)(short, int, double, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, d2, p3);
OUTPUT:
	RETVAL

double
nci_dsidd( c_func, s0, i1, d2, d3 )
	SV* c_func
	short s0
	int i1
	double d2
	double d3
PREINIT:
	double(*func)(short, int, double, double);
CODE:
	func   = INT2PTR(double(*)(short, int, double, double), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, d2, d3);
OUTPUT:
	RETVAL

double
nci_dsids( c_func, s0, i1, d2, s3 )
	SV* c_func
	short s0
	int i1
	double d2
	short s3
PREINIT:
	double(*func)(short, int, double, short);
CODE:
	func   = INT2PTR(double(*)(short, int, double, short), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, d2, s3);
OUTPUT:
	RETVAL

double
nci_dsidf( c_func, s0, i1, d2, f3 )
	SV* c_func
	short s0
	int i1
	double d2
	float f3
PREINIT:
	double(*func)(short, int, double, float);
CODE:
	func   = INT2PTR(double(*)(short, int, double, float), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, d2, f3);
OUTPUT:
	RETVAL

double
nci_dsidt( c_func, s0, i1, d2, t3 )
	SV* c_func
	short s0
	int i1
	double d2
	char * t3
PREINIT:
	double(*func)(short, int, double, char *);
CODE:
	func   = INT2PTR(double(*)(short, int, double, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, d2, t3);
OUTPUT:
	RETVAL

double
nci_dsidi( c_func, s0, i1, d2, i3 )
	SV* c_func
	short s0
	int i1
	double d2
	int i3
PREINIT:
	double(*func)(short, int, double, int);
CODE:
	func   = INT2PTR(double(*)(short, int, double, int), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, d2, i3);
OUTPUT:
	RETVAL

double
nci_dsisp( c_func, s0, i1, s2, p3 )
	SV* c_func
	short s0
	int i1
	short s2
	void * p3
PREINIT:
	double(*func)(short, int, short, void *);
CODE:
	func   = INT2PTR(double(*)(short, int, short, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, s2, p3);
OUTPUT:
	RETVAL

double
nci_dsisd( c_func, s0, i1, s2, d3 )
	SV* c_func
	short s0
	int i1
	short s2
	double d3
PREINIT:
	double(*func)(short, int, short, double);
CODE:
	func   = INT2PTR(double(*)(short, int, short, double), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, s2, d3);
OUTPUT:
	RETVAL

double
nci_dsiss( c_func, s0, i1, s2, s3 )
	SV* c_func
	short s0
	int i1
	short s2
	short s3
PREINIT:
	double(*func)(short, int, short, short);
CODE:
	func   = INT2PTR(double(*)(short, int, short, short), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, s2, s3);
OUTPUT:
	RETVAL

double
nci_dsisf( c_func, s0, i1, s2, f3 )
	SV* c_func
	short s0
	int i1
	short s2
	float f3
PREINIT:
	double(*func)(short, int, short, float);
CODE:
	func   = INT2PTR(double(*)(short, int, short, float), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, s2, f3);
OUTPUT:
	RETVAL

double
nci_dsist( c_func, s0, i1, s2, t3 )
	SV* c_func
	short s0
	int i1
	short s2
	char * t3
PREINIT:
	double(*func)(short, int, short, char *);
CODE:
	func   = INT2PTR(double(*)(short, int, short, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, s2, t3);
OUTPUT:
	RETVAL

double
nci_dsisi( c_func, s0, i1, s2, i3 )
	SV* c_func
	short s0
	int i1
	short s2
	int i3
PREINIT:
	double(*func)(short, int, short, int);
CODE:
	func   = INT2PTR(double(*)(short, int, short, int), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, s2, i3);
OUTPUT:
	RETVAL

double
nci_dsifp( c_func, s0, i1, f2, p3 )
	SV* c_func
	short s0
	int i1
	float f2
	void * p3
PREINIT:
	double(*func)(short, int, float, void *);
CODE:
	func   = INT2PTR(double(*)(short, int, float, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, f2, p3);
OUTPUT:
	RETVAL

double
nci_dsifd( c_func, s0, i1, f2, d3 )
	SV* c_func
	short s0
	int i1
	float f2
	double d3
PREINIT:
	double(*func)(short, int, float, double);
CODE:
	func   = INT2PTR(double(*)(short, int, float, double), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, f2, d3);
OUTPUT:
	RETVAL

double
nci_dsifs( c_func, s0, i1, f2, s3 )
	SV* c_func
	short s0
	int i1
	float f2
	short s3
PREINIT:
	double(*func)(short, int, float, short);
CODE:
	func   = INT2PTR(double(*)(short, int, float, short), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, f2, s3);
OUTPUT:
	RETVAL

double
nci_dsiff( c_func, s0, i1, f2, f3 )
	SV* c_func
	short s0
	int i1
	float f2
	float f3
PREINIT:
	double(*func)(short, int, float, float);
CODE:
	func   = INT2PTR(double(*)(short, int, float, float), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, f2, f3);
OUTPUT:
	RETVAL

double
nci_dsift( c_func, s0, i1, f2, t3 )
	SV* c_func
	short s0
	int i1
	float f2
	char * t3
PREINIT:
	double(*func)(short, int, float, char *);
CODE:
	func   = INT2PTR(double(*)(short, int, float, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, f2, t3);
OUTPUT:
	RETVAL

double
nci_dsifi( c_func, s0, i1, f2, i3 )
	SV* c_func
	short s0
	int i1
	float f2
	int i3
PREINIT:
	double(*func)(short, int, float, int);
CODE:
	func   = INT2PTR(double(*)(short, int, float, int), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, f2, i3);
OUTPUT:
	RETVAL

double
nci_dsitp( c_func, s0, i1, t2, p3 )
	SV* c_func
	short s0
	int i1
	char * t2
	void * p3
PREINIT:
	double(*func)(short, int, char *, void *);
CODE:
	func   = INT2PTR(double(*)(short, int, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, t2, p3);
OUTPUT:
	RETVAL

double
nci_dsitd( c_func, s0, i1, t2, d3 )
	SV* c_func
	short s0
	int i1
	char * t2
	double d3
PREINIT:
	double(*func)(short, int, char *, double);
CODE:
	func   = INT2PTR(double(*)(short, int, char *, double), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, t2, d3);
OUTPUT:
	RETVAL

double
nci_dsits( c_func, s0, i1, t2, s3 )
	SV* c_func
	short s0
	int i1
	char * t2
	short s3
PREINIT:
	double(*func)(short, int, char *, short);
CODE:
	func   = INT2PTR(double(*)(short, int, char *, short), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, t2, s3);
OUTPUT:
	RETVAL

double
nci_dsitf( c_func, s0, i1, t2, f3 )
	SV* c_func
	short s0
	int i1
	char * t2
	float f3
PREINIT:
	double(*func)(short, int, char *, float);
CODE:
	func   = INT2PTR(double(*)(short, int, char *, float), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, t2, f3);
OUTPUT:
	RETVAL

double
nci_dsitt( c_func, s0, i1, t2, t3 )
	SV* c_func
	short s0
	int i1
	char * t2
	char * t3
PREINIT:
	double(*func)(short, int, char *, char *);
CODE:
	func   = INT2PTR(double(*)(short, int, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, t2, t3);
OUTPUT:
	RETVAL

double
nci_dsiti( c_func, s0, i1, t2, i3 )
	SV* c_func
	short s0
	int i1
	char * t2
	int i3
PREINIT:
	double(*func)(short, int, char *, int);
CODE:
	func   = INT2PTR(double(*)(short, int, char *, int), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, t2, i3);
OUTPUT:
	RETVAL

double
nci_dsiip( c_func, s0, i1, i2, p3 )
	SV* c_func
	short s0
	int i1
	int i2
	void * p3
PREINIT:
	double(*func)(short, int, int, void *);
CODE:
	func   = INT2PTR(double(*)(short, int, int, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, i2, p3);
OUTPUT:
	RETVAL

double
nci_dsiid( c_func, s0, i1, i2, d3 )
	SV* c_func
	short s0
	int i1
	int i2
	double d3
PREINIT:
	double(*func)(short, int, int, double);
CODE:
	func   = INT2PTR(double(*)(short, int, int, double), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, i2, d3);
OUTPUT:
	RETVAL

double
nci_dsiis( c_func, s0, i1, i2, s3 )
	SV* c_func
	short s0
	int i1
	int i2
	short s3
PREINIT:
	double(*func)(short, int, int, short);
CODE:
	func   = INT2PTR(double(*)(short, int, int, short), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, i2, s3);
OUTPUT:
	RETVAL

double
nci_dsiif( c_func, s0, i1, i2, f3 )
	SV* c_func
	short s0
	int i1
	int i2
	float f3
PREINIT:
	double(*func)(short, int, int, float);
CODE:
	func   = INT2PTR(double(*)(short, int, int, float), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, i2, f3);
OUTPUT:
	RETVAL

double
nci_dsiit( c_func, s0, i1, i2, t3 )
	SV* c_func
	short s0
	int i1
	int i2
	char * t3
PREINIT:
	double(*func)(short, int, int, char *);
CODE:
	func   = INT2PTR(double(*)(short, int, int, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, i2, t3);
OUTPUT:
	RETVAL

double
nci_dsiii( c_func, s0, i1, i2, i3 )
	SV* c_func
	short s0
	int i1
	int i2
	int i3
PREINIT:
	double(*func)(short, int, int, int);
CODE:
	func   = INT2PTR(double(*)(short, int, int, int), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, i2, i3);
OUTPUT:
	RETVAL

double
nci_dfppp( c_func, f0, p1, p2, p3 )
	SV* c_func
	float f0
	void * p1
	void * p2
	void * p3
PREINIT:
	double(*func)(float, void *, void *, void *);
CODE:
	func   = INT2PTR(double(*)(float, void *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, p2, p3);
OUTPUT:
	RETVAL

double
nci_dfppd( c_func, f0, p1, p2, d3 )
	SV* c_func
	float f0
	void * p1
	void * p2
	double d3
PREINIT:
	double(*func)(float, void *, void *, double);
CODE:
	func   = INT2PTR(double(*)(float, void *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, p2, d3);
OUTPUT:
	RETVAL

double
nci_dfpps( c_func, f0, p1, p2, s3 )
	SV* c_func
	float f0
	void * p1
	void * p2
	short s3
PREINIT:
	double(*func)(float, void *, void *, short);
CODE:
	func   = INT2PTR(double(*)(float, void *, void *, short), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, p2, s3);
OUTPUT:
	RETVAL

double
nci_dfppf( c_func, f0, p1, p2, f3 )
	SV* c_func
	float f0
	void * p1
	void * p2
	float f3
PREINIT:
	double(*func)(float, void *, void *, float);
CODE:
	func   = INT2PTR(double(*)(float, void *, void *, float), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, p2, f3);
OUTPUT:
	RETVAL

double
nci_dfppt( c_func, f0, p1, p2, t3 )
	SV* c_func
	float f0
	void * p1
	void * p2
	char * t3
PREINIT:
	double(*func)(float, void *, void *, char *);
CODE:
	func   = INT2PTR(double(*)(float, void *, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, p2, t3);
OUTPUT:
	RETVAL

double
nci_dfppi( c_func, f0, p1, p2, i3 )
	SV* c_func
	float f0
	void * p1
	void * p2
	int i3
PREINIT:
	double(*func)(float, void *, void *, int);
CODE:
	func   = INT2PTR(double(*)(float, void *, void *, int), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, p2, i3);
OUTPUT:
	RETVAL

double
nci_dfpdp( c_func, f0, p1, d2, p3 )
	SV* c_func
	float f0
	void * p1
	double d2
	void * p3
PREINIT:
	double(*func)(float, void *, double, void *);
CODE:
	func   = INT2PTR(double(*)(float, void *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, d2, p3);
OUTPUT:
	RETVAL

double
nci_dfpdd( c_func, f0, p1, d2, d3 )
	SV* c_func
	float f0
	void * p1
	double d2
	double d3
PREINIT:
	double(*func)(float, void *, double, double);
CODE:
	func   = INT2PTR(double(*)(float, void *, double, double), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, d2, d3);
OUTPUT:
	RETVAL

double
nci_dfpds( c_func, f0, p1, d2, s3 )
	SV* c_func
	float f0
	void * p1
	double d2
	short s3
PREINIT:
	double(*func)(float, void *, double, short);
CODE:
	func   = INT2PTR(double(*)(float, void *, double, short), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, d2, s3);
OUTPUT:
	RETVAL

double
nci_dfpdf( c_func, f0, p1, d2, f3 )
	SV* c_func
	float f0
	void * p1
	double d2
	float f3
PREINIT:
	double(*func)(float, void *, double, float);
CODE:
	func   = INT2PTR(double(*)(float, void *, double, float), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, d2, f3);
OUTPUT:
	RETVAL

double
nci_dfpdt( c_func, f0, p1, d2, t3 )
	SV* c_func
	float f0
	void * p1
	double d2
	char * t3
PREINIT:
	double(*func)(float, void *, double, char *);
CODE:
	func   = INT2PTR(double(*)(float, void *, double, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, d2, t3);
OUTPUT:
	RETVAL

double
nci_dfpdi( c_func, f0, p1, d2, i3 )
	SV* c_func
	float f0
	void * p1
	double d2
	int i3
PREINIT:
	double(*func)(float, void *, double, int);
CODE:
	func   = INT2PTR(double(*)(float, void *, double, int), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, d2, i3);
OUTPUT:
	RETVAL

double
nci_dfpsp( c_func, f0, p1, s2, p3 )
	SV* c_func
	float f0
	void * p1
	short s2
	void * p3
PREINIT:
	double(*func)(float, void *, short, void *);
CODE:
	func   = INT2PTR(double(*)(float, void *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, s2, p3);
OUTPUT:
	RETVAL

double
nci_dfpsd( c_func, f0, p1, s2, d3 )
	SV* c_func
	float f0
	void * p1
	short s2
	double d3
PREINIT:
	double(*func)(float, void *, short, double);
CODE:
	func   = INT2PTR(double(*)(float, void *, short, double), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, s2, d3);
OUTPUT:
	RETVAL

double
nci_dfpss( c_func, f0, p1, s2, s3 )
	SV* c_func
	float f0
	void * p1
	short s2
	short s3
PREINIT:
	double(*func)(float, void *, short, short);
CODE:
	func   = INT2PTR(double(*)(float, void *, short, short), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, s2, s3);
OUTPUT:
	RETVAL

double
nci_dfpsf( c_func, f0, p1, s2, f3 )
	SV* c_func
	float f0
	void * p1
	short s2
	float f3
PREINIT:
	double(*func)(float, void *, short, float);
CODE:
	func   = INT2PTR(double(*)(float, void *, short, float), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, s2, f3);
OUTPUT:
	RETVAL

double
nci_dfpst( c_func, f0, p1, s2, t3 )
	SV* c_func
	float f0
	void * p1
	short s2
	char * t3
PREINIT:
	double(*func)(float, void *, short, char *);
CODE:
	func   = INT2PTR(double(*)(float, void *, short, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, s2, t3);
OUTPUT:
	RETVAL

double
nci_dfpsi( c_func, f0, p1, s2, i3 )
	SV* c_func
	float f0
	void * p1
	short s2
	int i3
PREINIT:
	double(*func)(float, void *, short, int);
CODE:
	func   = INT2PTR(double(*)(float, void *, short, int), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, s2, i3);
OUTPUT:
	RETVAL

double
nci_dfpfp( c_func, f0, p1, f2, p3 )
	SV* c_func
	float f0
	void * p1
	float f2
	void * p3
PREINIT:
	double(*func)(float, void *, float, void *);
CODE:
	func   = INT2PTR(double(*)(float, void *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, f2, p3);
OUTPUT:
	RETVAL

double
nci_dfpfd( c_func, f0, p1, f2, d3 )
	SV* c_func
	float f0
	void * p1
	float f2
	double d3
PREINIT:
	double(*func)(float, void *, float, double);
CODE:
	func   = INT2PTR(double(*)(float, void *, float, double), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, f2, d3);
OUTPUT:
	RETVAL

double
nci_dfpfs( c_func, f0, p1, f2, s3 )
	SV* c_func
	float f0
	void * p1
	float f2
	short s3
PREINIT:
	double(*func)(float, void *, float, short);
CODE:
	func   = INT2PTR(double(*)(float, void *, float, short), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, f2, s3);
OUTPUT:
	RETVAL

double
nci_dfpff( c_func, f0, p1, f2, f3 )
	SV* c_func
	float f0
	void * p1
	float f2
	float f3
PREINIT:
	double(*func)(float, void *, float, float);
CODE:
	func   = INT2PTR(double(*)(float, void *, float, float), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, f2, f3);
OUTPUT:
	RETVAL

double
nci_dfpft( c_func, f0, p1, f2, t3 )
	SV* c_func
	float f0
	void * p1
	float f2
	char * t3
PREINIT:
	double(*func)(float, void *, float, char *);
CODE:
	func   = INT2PTR(double(*)(float, void *, float, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, f2, t3);
OUTPUT:
	RETVAL

double
nci_dfpfi( c_func, f0, p1, f2, i3 )
	SV* c_func
	float f0
	void * p1
	float f2
	int i3
PREINIT:
	double(*func)(float, void *, float, int);
CODE:
	func   = INT2PTR(double(*)(float, void *, float, int), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, f2, i3);
OUTPUT:
	RETVAL

double
nci_dfptp( c_func, f0, p1, t2, p3 )
	SV* c_func
	float f0
	void * p1
	char * t2
	void * p3
PREINIT:
	double(*func)(float, void *, char *, void *);
CODE:
	func   = INT2PTR(double(*)(float, void *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, t2, p3);
OUTPUT:
	RETVAL

double
nci_dfptd( c_func, f0, p1, t2, d3 )
	SV* c_func
	float f0
	void * p1
	char * t2
	double d3
PREINIT:
	double(*func)(float, void *, char *, double);
CODE:
	func   = INT2PTR(double(*)(float, void *, char *, double), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, t2, d3);
OUTPUT:
	RETVAL

double
nci_dfpts( c_func, f0, p1, t2, s3 )
	SV* c_func
	float f0
	void * p1
	char * t2
	short s3
PREINIT:
	double(*func)(float, void *, char *, short);
CODE:
	func   = INT2PTR(double(*)(float, void *, char *, short), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, t2, s3);
OUTPUT:
	RETVAL

double
nci_dfptf( c_func, f0, p1, t2, f3 )
	SV* c_func
	float f0
	void * p1
	char * t2
	float f3
PREINIT:
	double(*func)(float, void *, char *, float);
CODE:
	func   = INT2PTR(double(*)(float, void *, char *, float), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, t2, f3);
OUTPUT:
	RETVAL

double
nci_dfptt( c_func, f0, p1, t2, t3 )
	SV* c_func
	float f0
	void * p1
	char * t2
	char * t3
PREINIT:
	double(*func)(float, void *, char *, char *);
CODE:
	func   = INT2PTR(double(*)(float, void *, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, t2, t3);
OUTPUT:
	RETVAL

double
nci_dfpti( c_func, f0, p1, t2, i3 )
	SV* c_func
	float f0
	void * p1
	char * t2
	int i3
PREINIT:
	double(*func)(float, void *, char *, int);
CODE:
	func   = INT2PTR(double(*)(float, void *, char *, int), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, t2, i3);
OUTPUT:
	RETVAL

double
nci_dfpip( c_func, f0, p1, i2, p3 )
	SV* c_func
	float f0
	void * p1
	int i2
	void * p3
PREINIT:
	double(*func)(float, void *, int, void *);
CODE:
	func   = INT2PTR(double(*)(float, void *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, i2, p3);
OUTPUT:
	RETVAL

double
nci_dfpid( c_func, f0, p1, i2, d3 )
	SV* c_func
	float f0
	void * p1
	int i2
	double d3
PREINIT:
	double(*func)(float, void *, int, double);
CODE:
	func   = INT2PTR(double(*)(float, void *, int, double), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, i2, d3);
OUTPUT:
	RETVAL

double
nci_dfpis( c_func, f0, p1, i2, s3 )
	SV* c_func
	float f0
	void * p1
	int i2
	short s3
PREINIT:
	double(*func)(float, void *, int, short);
CODE:
	func   = INT2PTR(double(*)(float, void *, int, short), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, i2, s3);
OUTPUT:
	RETVAL

double
nci_dfpif( c_func, f0, p1, i2, f3 )
	SV* c_func
	float f0
	void * p1
	int i2
	float f3
PREINIT:
	double(*func)(float, void *, int, float);
CODE:
	func   = INT2PTR(double(*)(float, void *, int, float), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, i2, f3);
OUTPUT:
	RETVAL

double
nci_dfpit( c_func, f0, p1, i2, t3 )
	SV* c_func
	float f0
	void * p1
	int i2
	char * t3
PREINIT:
	double(*func)(float, void *, int, char *);
CODE:
	func   = INT2PTR(double(*)(float, void *, int, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, i2, t3);
OUTPUT:
	RETVAL

double
nci_dfpii( c_func, f0, p1, i2, i3 )
	SV* c_func
	float f0
	void * p1
	int i2
	int i3
PREINIT:
	double(*func)(float, void *, int, int);
CODE:
	func   = INT2PTR(double(*)(float, void *, int, int), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, i2, i3);
OUTPUT:
	RETVAL

double
nci_dfdpp( c_func, f0, d1, p2, p3 )
	SV* c_func
	float f0
	double d1
	void * p2
	void * p3
PREINIT:
	double(*func)(float, double, void *, void *);
CODE:
	func   = INT2PTR(double(*)(float, double, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, p2, p3);
OUTPUT:
	RETVAL

double
nci_dfdpd( c_func, f0, d1, p2, d3 )
	SV* c_func
	float f0
	double d1
	void * p2
	double d3
PREINIT:
	double(*func)(float, double, void *, double);
CODE:
	func   = INT2PTR(double(*)(float, double, void *, double), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, p2, d3);
OUTPUT:
	RETVAL

double
nci_dfdps( c_func, f0, d1, p2, s3 )
	SV* c_func
	float f0
	double d1
	void * p2
	short s3
PREINIT:
	double(*func)(float, double, void *, short);
CODE:
	func   = INT2PTR(double(*)(float, double, void *, short), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, p2, s3);
OUTPUT:
	RETVAL

double
nci_dfdpf( c_func, f0, d1, p2, f3 )
	SV* c_func
	float f0
	double d1
	void * p2
	float f3
PREINIT:
	double(*func)(float, double, void *, float);
CODE:
	func   = INT2PTR(double(*)(float, double, void *, float), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, p2, f3);
OUTPUT:
	RETVAL

double
nci_dfdpt( c_func, f0, d1, p2, t3 )
	SV* c_func
	float f0
	double d1
	void * p2
	char * t3
PREINIT:
	double(*func)(float, double, void *, char *);
CODE:
	func   = INT2PTR(double(*)(float, double, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, p2, t3);
OUTPUT:
	RETVAL

double
nci_dfdpi( c_func, f0, d1, p2, i3 )
	SV* c_func
	float f0
	double d1
	void * p2
	int i3
PREINIT:
	double(*func)(float, double, void *, int);
CODE:
	func   = INT2PTR(double(*)(float, double, void *, int), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, p2, i3);
OUTPUT:
	RETVAL

double
nci_dfddp( c_func, f0, d1, d2, p3 )
	SV* c_func
	float f0
	double d1
	double d2
	void * p3
PREINIT:
	double(*func)(float, double, double, void *);
CODE:
	func   = INT2PTR(double(*)(float, double, double, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, d2, p3);
OUTPUT:
	RETVAL

double
nci_dfddd( c_func, f0, d1, d2, d3 )
	SV* c_func
	float f0
	double d1
	double d2
	double d3
PREINIT:
	double(*func)(float, double, double, double);
CODE:
	func   = INT2PTR(double(*)(float, double, double, double), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, d2, d3);
OUTPUT:
	RETVAL

double
nci_dfdds( c_func, f0, d1, d2, s3 )
	SV* c_func
	float f0
	double d1
	double d2
	short s3
PREINIT:
	double(*func)(float, double, double, short);
CODE:
	func   = INT2PTR(double(*)(float, double, double, short), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, d2, s3);
OUTPUT:
	RETVAL

double
nci_dfddf( c_func, f0, d1, d2, f3 )
	SV* c_func
	float f0
	double d1
	double d2
	float f3
PREINIT:
	double(*func)(float, double, double, float);
CODE:
	func   = INT2PTR(double(*)(float, double, double, float), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, d2, f3);
OUTPUT:
	RETVAL

double
nci_dfddt( c_func, f0, d1, d2, t3 )
	SV* c_func
	float f0
	double d1
	double d2
	char * t3
PREINIT:
	double(*func)(float, double, double, char *);
CODE:
	func   = INT2PTR(double(*)(float, double, double, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, d2, t3);
OUTPUT:
	RETVAL

double
nci_dfddi( c_func, f0, d1, d2, i3 )
	SV* c_func
	float f0
	double d1
	double d2
	int i3
PREINIT:
	double(*func)(float, double, double, int);
CODE:
	func   = INT2PTR(double(*)(float, double, double, int), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, d2, i3);
OUTPUT:
	RETVAL

double
nci_dfdsp( c_func, f0, d1, s2, p3 )
	SV* c_func
	float f0
	double d1
	short s2
	void * p3
PREINIT:
	double(*func)(float, double, short, void *);
CODE:
	func   = INT2PTR(double(*)(float, double, short, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, s2, p3);
OUTPUT:
	RETVAL

double
nci_dfdsd( c_func, f0, d1, s2, d3 )
	SV* c_func
	float f0
	double d1
	short s2
	double d3
PREINIT:
	double(*func)(float, double, short, double);
CODE:
	func   = INT2PTR(double(*)(float, double, short, double), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, s2, d3);
OUTPUT:
	RETVAL

double
nci_dfdss( c_func, f0, d1, s2, s3 )
	SV* c_func
	float f0
	double d1
	short s2
	short s3
PREINIT:
	double(*func)(float, double, short, short);
CODE:
	func   = INT2PTR(double(*)(float, double, short, short), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, s2, s3);
OUTPUT:
	RETVAL

double
nci_dfdsf( c_func, f0, d1, s2, f3 )
	SV* c_func
	float f0
	double d1
	short s2
	float f3
PREINIT:
	double(*func)(float, double, short, float);
CODE:
	func   = INT2PTR(double(*)(float, double, short, float), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, s2, f3);
OUTPUT:
	RETVAL

double
nci_dfdst( c_func, f0, d1, s2, t3 )
	SV* c_func
	float f0
	double d1
	short s2
	char * t3
PREINIT:
	double(*func)(float, double, short, char *);
CODE:
	func   = INT2PTR(double(*)(float, double, short, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, s2, t3);
OUTPUT:
	RETVAL

double
nci_dfdsi( c_func, f0, d1, s2, i3 )
	SV* c_func
	float f0
	double d1
	short s2
	int i3
PREINIT:
	double(*func)(float, double, short, int);
CODE:
	func   = INT2PTR(double(*)(float, double, short, int), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, s2, i3);
OUTPUT:
	RETVAL

double
nci_dfdfp( c_func, f0, d1, f2, p3 )
	SV* c_func
	float f0
	double d1
	float f2
	void * p3
PREINIT:
	double(*func)(float, double, float, void *);
CODE:
	func   = INT2PTR(double(*)(float, double, float, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, f2, p3);
OUTPUT:
	RETVAL

double
nci_dfdfd( c_func, f0, d1, f2, d3 )
	SV* c_func
	float f0
	double d1
	float f2
	double d3
PREINIT:
	double(*func)(float, double, float, double);
CODE:
	func   = INT2PTR(double(*)(float, double, float, double), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, f2, d3);
OUTPUT:
	RETVAL

double
nci_dfdfs( c_func, f0, d1, f2, s3 )
	SV* c_func
	float f0
	double d1
	float f2
	short s3
PREINIT:
	double(*func)(float, double, float, short);
CODE:
	func   = INT2PTR(double(*)(float, double, float, short), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, f2, s3);
OUTPUT:
	RETVAL

double
nci_dfdff( c_func, f0, d1, f2, f3 )
	SV* c_func
	float f0
	double d1
	float f2
	float f3
PREINIT:
	double(*func)(float, double, float, float);
CODE:
	func   = INT2PTR(double(*)(float, double, float, float), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, f2, f3);
OUTPUT:
	RETVAL

double
nci_dfdft( c_func, f0, d1, f2, t3 )
	SV* c_func
	float f0
	double d1
	float f2
	char * t3
PREINIT:
	double(*func)(float, double, float, char *);
CODE:
	func   = INT2PTR(double(*)(float, double, float, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, f2, t3);
OUTPUT:
	RETVAL

double
nci_dfdfi( c_func, f0, d1, f2, i3 )
	SV* c_func
	float f0
	double d1
	float f2
	int i3
PREINIT:
	double(*func)(float, double, float, int);
CODE:
	func   = INT2PTR(double(*)(float, double, float, int), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, f2, i3);
OUTPUT:
	RETVAL

double
nci_dfdtp( c_func, f0, d1, t2, p3 )
	SV* c_func
	float f0
	double d1
	char * t2
	void * p3
PREINIT:
	double(*func)(float, double, char *, void *);
CODE:
	func   = INT2PTR(double(*)(float, double, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, t2, p3);
OUTPUT:
	RETVAL

double
nci_dfdtd( c_func, f0, d1, t2, d3 )
	SV* c_func
	float f0
	double d1
	char * t2
	double d3
PREINIT:
	double(*func)(float, double, char *, double);
CODE:
	func   = INT2PTR(double(*)(float, double, char *, double), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, t2, d3);
OUTPUT:
	RETVAL

double
nci_dfdts( c_func, f0, d1, t2, s3 )
	SV* c_func
	float f0
	double d1
	char * t2
	short s3
PREINIT:
	double(*func)(float, double, char *, short);
CODE:
	func   = INT2PTR(double(*)(float, double, char *, short), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, t2, s3);
OUTPUT:
	RETVAL

double
nci_dfdtf( c_func, f0, d1, t2, f3 )
	SV* c_func
	float f0
	double d1
	char * t2
	float f3
PREINIT:
	double(*func)(float, double, char *, float);
CODE:
	func   = INT2PTR(double(*)(float, double, char *, float), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, t2, f3);
OUTPUT:
	RETVAL

double
nci_dfdtt( c_func, f0, d1, t2, t3 )
	SV* c_func
	float f0
	double d1
	char * t2
	char * t3
PREINIT:
	double(*func)(float, double, char *, char *);
CODE:
	func   = INT2PTR(double(*)(float, double, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, t2, t3);
OUTPUT:
	RETVAL

double
nci_dfdti( c_func, f0, d1, t2, i3 )
	SV* c_func
	float f0
	double d1
	char * t2
	int i3
PREINIT:
	double(*func)(float, double, char *, int);
CODE:
	func   = INT2PTR(double(*)(float, double, char *, int), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, t2, i3);
OUTPUT:
	RETVAL

double
nci_dfdip( c_func, f0, d1, i2, p3 )
	SV* c_func
	float f0
	double d1
	int i2
	void * p3
PREINIT:
	double(*func)(float, double, int, void *);
CODE:
	func   = INT2PTR(double(*)(float, double, int, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, i2, p3);
OUTPUT:
	RETVAL

double
nci_dfdid( c_func, f0, d1, i2, d3 )
	SV* c_func
	float f0
	double d1
	int i2
	double d3
PREINIT:
	double(*func)(float, double, int, double);
CODE:
	func   = INT2PTR(double(*)(float, double, int, double), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, i2, d3);
OUTPUT:
	RETVAL

double
nci_dfdis( c_func, f0, d1, i2, s3 )
	SV* c_func
	float f0
	double d1
	int i2
	short s3
PREINIT:
	double(*func)(float, double, int, short);
CODE:
	func   = INT2PTR(double(*)(float, double, int, short), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, i2, s3);
OUTPUT:
	RETVAL

double
nci_dfdif( c_func, f0, d1, i2, f3 )
	SV* c_func
	float f0
	double d1
	int i2
	float f3
PREINIT:
	double(*func)(float, double, int, float);
CODE:
	func   = INT2PTR(double(*)(float, double, int, float), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, i2, f3);
OUTPUT:
	RETVAL

double
nci_dfdit( c_func, f0, d1, i2, t3 )
	SV* c_func
	float f0
	double d1
	int i2
	char * t3
PREINIT:
	double(*func)(float, double, int, char *);
CODE:
	func   = INT2PTR(double(*)(float, double, int, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, i2, t3);
OUTPUT:
	RETVAL

double
nci_dfdii( c_func, f0, d1, i2, i3 )
	SV* c_func
	float f0
	double d1
	int i2
	int i3
PREINIT:
	double(*func)(float, double, int, int);
CODE:
	func   = INT2PTR(double(*)(float, double, int, int), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, i2, i3);
OUTPUT:
	RETVAL

double
nci_dfspp( c_func, f0, s1, p2, p3 )
	SV* c_func
	float f0
	short s1
	void * p2
	void * p3
PREINIT:
	double(*func)(float, short, void *, void *);
CODE:
	func   = INT2PTR(double(*)(float, short, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, p2, p3);
OUTPUT:
	RETVAL

double
nci_dfspd( c_func, f0, s1, p2, d3 )
	SV* c_func
	float f0
	short s1
	void * p2
	double d3
PREINIT:
	double(*func)(float, short, void *, double);
CODE:
	func   = INT2PTR(double(*)(float, short, void *, double), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, p2, d3);
OUTPUT:
	RETVAL

double
nci_dfsps( c_func, f0, s1, p2, s3 )
	SV* c_func
	float f0
	short s1
	void * p2
	short s3
PREINIT:
	double(*func)(float, short, void *, short);
CODE:
	func   = INT2PTR(double(*)(float, short, void *, short), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, p2, s3);
OUTPUT:
	RETVAL

double
nci_dfspf( c_func, f0, s1, p2, f3 )
	SV* c_func
	float f0
	short s1
	void * p2
	float f3
PREINIT:
	double(*func)(float, short, void *, float);
CODE:
	func   = INT2PTR(double(*)(float, short, void *, float), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, p2, f3);
OUTPUT:
	RETVAL

double
nci_dfspt( c_func, f0, s1, p2, t3 )
	SV* c_func
	float f0
	short s1
	void * p2
	char * t3
PREINIT:
	double(*func)(float, short, void *, char *);
CODE:
	func   = INT2PTR(double(*)(float, short, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, p2, t3);
OUTPUT:
	RETVAL

double
nci_dfspi( c_func, f0, s1, p2, i3 )
	SV* c_func
	float f0
	short s1
	void * p2
	int i3
PREINIT:
	double(*func)(float, short, void *, int);
CODE:
	func   = INT2PTR(double(*)(float, short, void *, int), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, p2, i3);
OUTPUT:
	RETVAL

double
nci_dfsdp( c_func, f0, s1, d2, p3 )
	SV* c_func
	float f0
	short s1
	double d2
	void * p3
PREINIT:
	double(*func)(float, short, double, void *);
CODE:
	func   = INT2PTR(double(*)(float, short, double, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, d2, p3);
OUTPUT:
	RETVAL

double
nci_dfsdd( c_func, f0, s1, d2, d3 )
	SV* c_func
	float f0
	short s1
	double d2
	double d3
PREINIT:
	double(*func)(float, short, double, double);
CODE:
	func   = INT2PTR(double(*)(float, short, double, double), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, d2, d3);
OUTPUT:
	RETVAL

double
nci_dfsds( c_func, f0, s1, d2, s3 )
	SV* c_func
	float f0
	short s1
	double d2
	short s3
PREINIT:
	double(*func)(float, short, double, short);
CODE:
	func   = INT2PTR(double(*)(float, short, double, short), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, d2, s3);
OUTPUT:
	RETVAL

double
nci_dfsdf( c_func, f0, s1, d2, f3 )
	SV* c_func
	float f0
	short s1
	double d2
	float f3
PREINIT:
	double(*func)(float, short, double, float);
CODE:
	func   = INT2PTR(double(*)(float, short, double, float), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, d2, f3);
OUTPUT:
	RETVAL

double
nci_dfsdt( c_func, f0, s1, d2, t3 )
	SV* c_func
	float f0
	short s1
	double d2
	char * t3
PREINIT:
	double(*func)(float, short, double, char *);
CODE:
	func   = INT2PTR(double(*)(float, short, double, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, d2, t3);
OUTPUT:
	RETVAL

double
nci_dfsdi( c_func, f0, s1, d2, i3 )
	SV* c_func
	float f0
	short s1
	double d2
	int i3
PREINIT:
	double(*func)(float, short, double, int);
CODE:
	func   = INT2PTR(double(*)(float, short, double, int), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, d2, i3);
OUTPUT:
	RETVAL

double
nci_dfssp( c_func, f0, s1, s2, p3 )
	SV* c_func
	float f0
	short s1
	short s2
	void * p3
PREINIT:
	double(*func)(float, short, short, void *);
CODE:
	func   = INT2PTR(double(*)(float, short, short, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, s2, p3);
OUTPUT:
	RETVAL

double
nci_dfssd( c_func, f0, s1, s2, d3 )
	SV* c_func
	float f0
	short s1
	short s2
	double d3
PREINIT:
	double(*func)(float, short, short, double);
CODE:
	func   = INT2PTR(double(*)(float, short, short, double), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, s2, d3);
OUTPUT:
	RETVAL

double
nci_dfsss( c_func, f0, s1, s2, s3 )
	SV* c_func
	float f0
	short s1
	short s2
	short s3
PREINIT:
	double(*func)(float, short, short, short);
CODE:
	func   = INT2PTR(double(*)(float, short, short, short), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, s2, s3);
OUTPUT:
	RETVAL

double
nci_dfssf( c_func, f0, s1, s2, f3 )
	SV* c_func
	float f0
	short s1
	short s2
	float f3
PREINIT:
	double(*func)(float, short, short, float);
CODE:
	func   = INT2PTR(double(*)(float, short, short, float), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, s2, f3);
OUTPUT:
	RETVAL

double
nci_dfsst( c_func, f0, s1, s2, t3 )
	SV* c_func
	float f0
	short s1
	short s2
	char * t3
PREINIT:
	double(*func)(float, short, short, char *);
CODE:
	func   = INT2PTR(double(*)(float, short, short, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, s2, t3);
OUTPUT:
	RETVAL

double
nci_dfssi( c_func, f0, s1, s2, i3 )
	SV* c_func
	float f0
	short s1
	short s2
	int i3
PREINIT:
	double(*func)(float, short, short, int);
CODE:
	func   = INT2PTR(double(*)(float, short, short, int), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, s2, i3);
OUTPUT:
	RETVAL

double
nci_dfsfp( c_func, f0, s1, f2, p3 )
	SV* c_func
	float f0
	short s1
	float f2
	void * p3
PREINIT:
	double(*func)(float, short, float, void *);
CODE:
	func   = INT2PTR(double(*)(float, short, float, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, f2, p3);
OUTPUT:
	RETVAL

double
nci_dfsfd( c_func, f0, s1, f2, d3 )
	SV* c_func
	float f0
	short s1
	float f2
	double d3
PREINIT:
	double(*func)(float, short, float, double);
CODE:
	func   = INT2PTR(double(*)(float, short, float, double), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, f2, d3);
OUTPUT:
	RETVAL

double
nci_dfsfs( c_func, f0, s1, f2, s3 )
	SV* c_func
	float f0
	short s1
	float f2
	short s3
PREINIT:
	double(*func)(float, short, float, short);
CODE:
	func   = INT2PTR(double(*)(float, short, float, short), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, f2, s3);
OUTPUT:
	RETVAL

double
nci_dfsff( c_func, f0, s1, f2, f3 )
	SV* c_func
	float f0
	short s1
	float f2
	float f3
PREINIT:
	double(*func)(float, short, float, float);
CODE:
	func   = INT2PTR(double(*)(float, short, float, float), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, f2, f3);
OUTPUT:
	RETVAL

double
nci_dfsft( c_func, f0, s1, f2, t3 )
	SV* c_func
	float f0
	short s1
	float f2
	char * t3
PREINIT:
	double(*func)(float, short, float, char *);
CODE:
	func   = INT2PTR(double(*)(float, short, float, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, f2, t3);
OUTPUT:
	RETVAL

double
nci_dfsfi( c_func, f0, s1, f2, i3 )
	SV* c_func
	float f0
	short s1
	float f2
	int i3
PREINIT:
	double(*func)(float, short, float, int);
CODE:
	func   = INT2PTR(double(*)(float, short, float, int), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, f2, i3);
OUTPUT:
	RETVAL

double
nci_dfstp( c_func, f0, s1, t2, p3 )
	SV* c_func
	float f0
	short s1
	char * t2
	void * p3
PREINIT:
	double(*func)(float, short, char *, void *);
CODE:
	func   = INT2PTR(double(*)(float, short, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, t2, p3);
OUTPUT:
	RETVAL

double
nci_dfstd( c_func, f0, s1, t2, d3 )
	SV* c_func
	float f0
	short s1
	char * t2
	double d3
PREINIT:
	double(*func)(float, short, char *, double);
CODE:
	func   = INT2PTR(double(*)(float, short, char *, double), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, t2, d3);
OUTPUT:
	RETVAL

double
nci_dfsts( c_func, f0, s1, t2, s3 )
	SV* c_func
	float f0
	short s1
	char * t2
	short s3
PREINIT:
	double(*func)(float, short, char *, short);
CODE:
	func   = INT2PTR(double(*)(float, short, char *, short), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, t2, s3);
OUTPUT:
	RETVAL

double
nci_dfstf( c_func, f0, s1, t2, f3 )
	SV* c_func
	float f0
	short s1
	char * t2
	float f3
PREINIT:
	double(*func)(float, short, char *, float);
CODE:
	func   = INT2PTR(double(*)(float, short, char *, float), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, t2, f3);
OUTPUT:
	RETVAL

double
nci_dfstt( c_func, f0, s1, t2, t3 )
	SV* c_func
	float f0
	short s1
	char * t2
	char * t3
PREINIT:
	double(*func)(float, short, char *, char *);
CODE:
	func   = INT2PTR(double(*)(float, short, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, t2, t3);
OUTPUT:
	RETVAL

double
nci_dfsti( c_func, f0, s1, t2, i3 )
	SV* c_func
	float f0
	short s1
	char * t2
	int i3
PREINIT:
	double(*func)(float, short, char *, int);
CODE:
	func   = INT2PTR(double(*)(float, short, char *, int), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, t2, i3);
OUTPUT:
	RETVAL

double
nci_dfsip( c_func, f0, s1, i2, p3 )
	SV* c_func
	float f0
	short s1
	int i2
	void * p3
PREINIT:
	double(*func)(float, short, int, void *);
CODE:
	func   = INT2PTR(double(*)(float, short, int, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, i2, p3);
OUTPUT:
	RETVAL

double
nci_dfsid( c_func, f0, s1, i2, d3 )
	SV* c_func
	float f0
	short s1
	int i2
	double d3
PREINIT:
	double(*func)(float, short, int, double);
CODE:
	func   = INT2PTR(double(*)(float, short, int, double), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, i2, d3);
OUTPUT:
	RETVAL

double
nci_dfsis( c_func, f0, s1, i2, s3 )
	SV* c_func
	float f0
	short s1
	int i2
	short s3
PREINIT:
	double(*func)(float, short, int, short);
CODE:
	func   = INT2PTR(double(*)(float, short, int, short), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, i2, s3);
OUTPUT:
	RETVAL

double
nci_dfsif( c_func, f0, s1, i2, f3 )
	SV* c_func
	float f0
	short s1
	int i2
	float f3
PREINIT:
	double(*func)(float, short, int, float);
CODE:
	func   = INT2PTR(double(*)(float, short, int, float), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, i2, f3);
OUTPUT:
	RETVAL

double
nci_dfsit( c_func, f0, s1, i2, t3 )
	SV* c_func
	float f0
	short s1
	int i2
	char * t3
PREINIT:
	double(*func)(float, short, int, char *);
CODE:
	func   = INT2PTR(double(*)(float, short, int, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, i2, t3);
OUTPUT:
	RETVAL

double
nci_dfsii( c_func, f0, s1, i2, i3 )
	SV* c_func
	float f0
	short s1
	int i2
	int i3
PREINIT:
	double(*func)(float, short, int, int);
CODE:
	func   = INT2PTR(double(*)(float, short, int, int), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, i2, i3);
OUTPUT:
	RETVAL

double
nci_dffpp( c_func, f0, f1, p2, p3 )
	SV* c_func
	float f0
	float f1
	void * p2
	void * p3
PREINIT:
	double(*func)(float, float, void *, void *);
CODE:
	func   = INT2PTR(double(*)(float, float, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, p2, p3);
OUTPUT:
	RETVAL

double
nci_dffpd( c_func, f0, f1, p2, d3 )
	SV* c_func
	float f0
	float f1
	void * p2
	double d3
PREINIT:
	double(*func)(float, float, void *, double);
CODE:
	func   = INT2PTR(double(*)(float, float, void *, double), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, p2, d3);
OUTPUT:
	RETVAL

double
nci_dffps( c_func, f0, f1, p2, s3 )
	SV* c_func
	float f0
	float f1
	void * p2
	short s3
PREINIT:
	double(*func)(float, float, void *, short);
CODE:
	func   = INT2PTR(double(*)(float, float, void *, short), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, p2, s3);
OUTPUT:
	RETVAL

double
nci_dffpf( c_func, f0, f1, p2, f3 )
	SV* c_func
	float f0
	float f1
	void * p2
	float f3
PREINIT:
	double(*func)(float, float, void *, float);
CODE:
	func   = INT2PTR(double(*)(float, float, void *, float), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, p2, f3);
OUTPUT:
	RETVAL

double
nci_dffpt( c_func, f0, f1, p2, t3 )
	SV* c_func
	float f0
	float f1
	void * p2
	char * t3
PREINIT:
	double(*func)(float, float, void *, char *);
CODE:
	func   = INT2PTR(double(*)(float, float, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, p2, t3);
OUTPUT:
	RETVAL

double
nci_dffpi( c_func, f0, f1, p2, i3 )
	SV* c_func
	float f0
	float f1
	void * p2
	int i3
PREINIT:
	double(*func)(float, float, void *, int);
CODE:
	func   = INT2PTR(double(*)(float, float, void *, int), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, p2, i3);
OUTPUT:
	RETVAL

double
nci_dffdp( c_func, f0, f1, d2, p3 )
	SV* c_func
	float f0
	float f1
	double d2
	void * p3
PREINIT:
	double(*func)(float, float, double, void *);
CODE:
	func   = INT2PTR(double(*)(float, float, double, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, d2, p3);
OUTPUT:
	RETVAL

double
nci_dffdd( c_func, f0, f1, d2, d3 )
	SV* c_func
	float f0
	float f1
	double d2
	double d3
PREINIT:
	double(*func)(float, float, double, double);
CODE:
	func   = INT2PTR(double(*)(float, float, double, double), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, d2, d3);
OUTPUT:
	RETVAL

double
nci_dffds( c_func, f0, f1, d2, s3 )
	SV* c_func
	float f0
	float f1
	double d2
	short s3
PREINIT:
	double(*func)(float, float, double, short);
CODE:
	func   = INT2PTR(double(*)(float, float, double, short), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, d2, s3);
OUTPUT:
	RETVAL

double
nci_dffdf( c_func, f0, f1, d2, f3 )
	SV* c_func
	float f0
	float f1
	double d2
	float f3
PREINIT:
	double(*func)(float, float, double, float);
CODE:
	func   = INT2PTR(double(*)(float, float, double, float), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, d2, f3);
OUTPUT:
	RETVAL

double
nci_dffdt( c_func, f0, f1, d2, t3 )
	SV* c_func
	float f0
	float f1
	double d2
	char * t3
PREINIT:
	double(*func)(float, float, double, char *);
CODE:
	func   = INT2PTR(double(*)(float, float, double, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, d2, t3);
OUTPUT:
	RETVAL

double
nci_dffdi( c_func, f0, f1, d2, i3 )
	SV* c_func
	float f0
	float f1
	double d2
	int i3
PREINIT:
	double(*func)(float, float, double, int);
CODE:
	func   = INT2PTR(double(*)(float, float, double, int), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, d2, i3);
OUTPUT:
	RETVAL

double
nci_dffsp( c_func, f0, f1, s2, p3 )
	SV* c_func
	float f0
	float f1
	short s2
	void * p3
PREINIT:
	double(*func)(float, float, short, void *);
CODE:
	func   = INT2PTR(double(*)(float, float, short, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, s2, p3);
OUTPUT:
	RETVAL

double
nci_dffsd( c_func, f0, f1, s2, d3 )
	SV* c_func
	float f0
	float f1
	short s2
	double d3
PREINIT:
	double(*func)(float, float, short, double);
CODE:
	func   = INT2PTR(double(*)(float, float, short, double), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, s2, d3);
OUTPUT:
	RETVAL

double
nci_dffss( c_func, f0, f1, s2, s3 )
	SV* c_func
	float f0
	float f1
	short s2
	short s3
PREINIT:
	double(*func)(float, float, short, short);
CODE:
	func   = INT2PTR(double(*)(float, float, short, short), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, s2, s3);
OUTPUT:
	RETVAL

double
nci_dffsf( c_func, f0, f1, s2, f3 )
	SV* c_func
	float f0
	float f1
	short s2
	float f3
PREINIT:
	double(*func)(float, float, short, float);
CODE:
	func   = INT2PTR(double(*)(float, float, short, float), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, s2, f3);
OUTPUT:
	RETVAL

double
nci_dffst( c_func, f0, f1, s2, t3 )
	SV* c_func
	float f0
	float f1
	short s2
	char * t3
PREINIT:
	double(*func)(float, float, short, char *);
CODE:
	func   = INT2PTR(double(*)(float, float, short, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, s2, t3);
OUTPUT:
	RETVAL

double
nci_dffsi( c_func, f0, f1, s2, i3 )
	SV* c_func
	float f0
	float f1
	short s2
	int i3
PREINIT:
	double(*func)(float, float, short, int);
CODE:
	func   = INT2PTR(double(*)(float, float, short, int), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, s2, i3);
OUTPUT:
	RETVAL

double
nci_dfffp( c_func, f0, f1, f2, p3 )
	SV* c_func
	float f0
	float f1
	float f2
	void * p3
PREINIT:
	double(*func)(float, float, float, void *);
CODE:
	func   = INT2PTR(double(*)(float, float, float, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, f2, p3);
OUTPUT:
	RETVAL

double
nci_dfffd( c_func, f0, f1, f2, d3 )
	SV* c_func
	float f0
	float f1
	float f2
	double d3
PREINIT:
	double(*func)(float, float, float, double);
CODE:
	func   = INT2PTR(double(*)(float, float, float, double), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, f2, d3);
OUTPUT:
	RETVAL

double
nci_dfffs( c_func, f0, f1, f2, s3 )
	SV* c_func
	float f0
	float f1
	float f2
	short s3
PREINIT:
	double(*func)(float, float, float, short);
CODE:
	func   = INT2PTR(double(*)(float, float, float, short), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, f2, s3);
OUTPUT:
	RETVAL

double
nci_dffff( c_func, f0, f1, f2, f3 )
	SV* c_func
	float f0
	float f1
	float f2
	float f3
PREINIT:
	double(*func)(float, float, float, float);
CODE:
	func   = INT2PTR(double(*)(float, float, float, float), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, f2, f3);
OUTPUT:
	RETVAL

double
nci_dffft( c_func, f0, f1, f2, t3 )
	SV* c_func
	float f0
	float f1
	float f2
	char * t3
PREINIT:
	double(*func)(float, float, float, char *);
CODE:
	func   = INT2PTR(double(*)(float, float, float, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, f2, t3);
OUTPUT:
	RETVAL

double
nci_dfffi( c_func, f0, f1, f2, i3 )
	SV* c_func
	float f0
	float f1
	float f2
	int i3
PREINIT:
	double(*func)(float, float, float, int);
CODE:
	func   = INT2PTR(double(*)(float, float, float, int), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, f2, i3);
OUTPUT:
	RETVAL

double
nci_dfftp( c_func, f0, f1, t2, p3 )
	SV* c_func
	float f0
	float f1
	char * t2
	void * p3
PREINIT:
	double(*func)(float, float, char *, void *);
CODE:
	func   = INT2PTR(double(*)(float, float, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, t2, p3);
OUTPUT:
	RETVAL

double
nci_dfftd( c_func, f0, f1, t2, d3 )
	SV* c_func
	float f0
	float f1
	char * t2
	double d3
PREINIT:
	double(*func)(float, float, char *, double);
CODE:
	func   = INT2PTR(double(*)(float, float, char *, double), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, t2, d3);
OUTPUT:
	RETVAL

double
nci_dffts( c_func, f0, f1, t2, s3 )
	SV* c_func
	float f0
	float f1
	char * t2
	short s3
PREINIT:
	double(*func)(float, float, char *, short);
CODE:
	func   = INT2PTR(double(*)(float, float, char *, short), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, t2, s3);
OUTPUT:
	RETVAL

double
nci_dfftf( c_func, f0, f1, t2, f3 )
	SV* c_func
	float f0
	float f1
	char * t2
	float f3
PREINIT:
	double(*func)(float, float, char *, float);
CODE:
	func   = INT2PTR(double(*)(float, float, char *, float), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, t2, f3);
OUTPUT:
	RETVAL

double
nci_dfftt( c_func, f0, f1, t2, t3 )
	SV* c_func
	float f0
	float f1
	char * t2
	char * t3
PREINIT:
	double(*func)(float, float, char *, char *);
CODE:
	func   = INT2PTR(double(*)(float, float, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, t2, t3);
OUTPUT:
	RETVAL

double
nci_dffti( c_func, f0, f1, t2, i3 )
	SV* c_func
	float f0
	float f1
	char * t2
	int i3
PREINIT:
	double(*func)(float, float, char *, int);
CODE:
	func   = INT2PTR(double(*)(float, float, char *, int), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, t2, i3);
OUTPUT:
	RETVAL

double
nci_dffip( c_func, f0, f1, i2, p3 )
	SV* c_func
	float f0
	float f1
	int i2
	void * p3
PREINIT:
	double(*func)(float, float, int, void *);
CODE:
	func   = INT2PTR(double(*)(float, float, int, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, i2, p3);
OUTPUT:
	RETVAL

double
nci_dffid( c_func, f0, f1, i2, d3 )
	SV* c_func
	float f0
	float f1
	int i2
	double d3
PREINIT:
	double(*func)(float, float, int, double);
CODE:
	func   = INT2PTR(double(*)(float, float, int, double), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, i2, d3);
OUTPUT:
	RETVAL

double
nci_dffis( c_func, f0, f1, i2, s3 )
	SV* c_func
	float f0
	float f1
	int i2
	short s3
PREINIT:
	double(*func)(float, float, int, short);
CODE:
	func   = INT2PTR(double(*)(float, float, int, short), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, i2, s3);
OUTPUT:
	RETVAL

double
nci_dffif( c_func, f0, f1, i2, f3 )
	SV* c_func
	float f0
	float f1
	int i2
	float f3
PREINIT:
	double(*func)(float, float, int, float);
CODE:
	func   = INT2PTR(double(*)(float, float, int, float), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, i2, f3);
OUTPUT:
	RETVAL

double
nci_dffit( c_func, f0, f1, i2, t3 )
	SV* c_func
	float f0
	float f1
	int i2
	char * t3
PREINIT:
	double(*func)(float, float, int, char *);
CODE:
	func   = INT2PTR(double(*)(float, float, int, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, i2, t3);
OUTPUT:
	RETVAL

double
nci_dffii( c_func, f0, f1, i2, i3 )
	SV* c_func
	float f0
	float f1
	int i2
	int i3
PREINIT:
	double(*func)(float, float, int, int);
CODE:
	func   = INT2PTR(double(*)(float, float, int, int), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, i2, i3);
OUTPUT:
	RETVAL

double
nci_dftpp( c_func, f0, t1, p2, p3 )
	SV* c_func
	float f0
	char * t1
	void * p2
	void * p3
PREINIT:
	double(*func)(float, char *, void *, void *);
CODE:
	func   = INT2PTR(double(*)(float, char *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, p2, p3);
OUTPUT:
	RETVAL

double
nci_dftpd( c_func, f0, t1, p2, d3 )
	SV* c_func
	float f0
	char * t1
	void * p2
	double d3
PREINIT:
	double(*func)(float, char *, void *, double);
CODE:
	func   = INT2PTR(double(*)(float, char *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, p2, d3);
OUTPUT:
	RETVAL

double
nci_dftps( c_func, f0, t1, p2, s3 )
	SV* c_func
	float f0
	char * t1
	void * p2
	short s3
PREINIT:
	double(*func)(float, char *, void *, short);
CODE:
	func   = INT2PTR(double(*)(float, char *, void *, short), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, p2, s3);
OUTPUT:
	RETVAL

double
nci_dftpf( c_func, f0, t1, p2, f3 )
	SV* c_func
	float f0
	char * t1
	void * p2
	float f3
PREINIT:
	double(*func)(float, char *, void *, float);
CODE:
	func   = INT2PTR(double(*)(float, char *, void *, float), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, p2, f3);
OUTPUT:
	RETVAL

double
nci_dftpt( c_func, f0, t1, p2, t3 )
	SV* c_func
	float f0
	char * t1
	void * p2
	char * t3
PREINIT:
	double(*func)(float, char *, void *, char *);
CODE:
	func   = INT2PTR(double(*)(float, char *, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, p2, t3);
OUTPUT:
	RETVAL

double
nci_dftpi( c_func, f0, t1, p2, i3 )
	SV* c_func
	float f0
	char * t1
	void * p2
	int i3
PREINIT:
	double(*func)(float, char *, void *, int);
CODE:
	func   = INT2PTR(double(*)(float, char *, void *, int), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, p2, i3);
OUTPUT:
	RETVAL

double
nci_dftdp( c_func, f0, t1, d2, p3 )
	SV* c_func
	float f0
	char * t1
	double d2
	void * p3
PREINIT:
	double(*func)(float, char *, double, void *);
CODE:
	func   = INT2PTR(double(*)(float, char *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, d2, p3);
OUTPUT:
	RETVAL

double
nci_dftdd( c_func, f0, t1, d2, d3 )
	SV* c_func
	float f0
	char * t1
	double d2
	double d3
PREINIT:
	double(*func)(float, char *, double, double);
CODE:
	func   = INT2PTR(double(*)(float, char *, double, double), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, d2, d3);
OUTPUT:
	RETVAL

double
nci_dftds( c_func, f0, t1, d2, s3 )
	SV* c_func
	float f0
	char * t1
	double d2
	short s3
PREINIT:
	double(*func)(float, char *, double, short);
CODE:
	func   = INT2PTR(double(*)(float, char *, double, short), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, d2, s3);
OUTPUT:
	RETVAL

double
nci_dftdf( c_func, f0, t1, d2, f3 )
	SV* c_func
	float f0
	char * t1
	double d2
	float f3
PREINIT:
	double(*func)(float, char *, double, float);
CODE:
	func   = INT2PTR(double(*)(float, char *, double, float), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, d2, f3);
OUTPUT:
	RETVAL

double
nci_dftdt( c_func, f0, t1, d2, t3 )
	SV* c_func
	float f0
	char * t1
	double d2
	char * t3
PREINIT:
	double(*func)(float, char *, double, char *);
CODE:
	func   = INT2PTR(double(*)(float, char *, double, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, d2, t3);
OUTPUT:
	RETVAL

double
nci_dftdi( c_func, f0, t1, d2, i3 )
	SV* c_func
	float f0
	char * t1
	double d2
	int i3
PREINIT:
	double(*func)(float, char *, double, int);
CODE:
	func   = INT2PTR(double(*)(float, char *, double, int), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, d2, i3);
OUTPUT:
	RETVAL

double
nci_dftsp( c_func, f0, t1, s2, p3 )
	SV* c_func
	float f0
	char * t1
	short s2
	void * p3
PREINIT:
	double(*func)(float, char *, short, void *);
CODE:
	func   = INT2PTR(double(*)(float, char *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, s2, p3);
OUTPUT:
	RETVAL

double
nci_dftsd( c_func, f0, t1, s2, d3 )
	SV* c_func
	float f0
	char * t1
	short s2
	double d3
PREINIT:
	double(*func)(float, char *, short, double);
CODE:
	func   = INT2PTR(double(*)(float, char *, short, double), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, s2, d3);
OUTPUT:
	RETVAL

double
nci_dftss( c_func, f0, t1, s2, s3 )
	SV* c_func
	float f0
	char * t1
	short s2
	short s3
PREINIT:
	double(*func)(float, char *, short, short);
CODE:
	func   = INT2PTR(double(*)(float, char *, short, short), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, s2, s3);
OUTPUT:
	RETVAL

double
nci_dftsf( c_func, f0, t1, s2, f3 )
	SV* c_func
	float f0
	char * t1
	short s2
	float f3
PREINIT:
	double(*func)(float, char *, short, float);
CODE:
	func   = INT2PTR(double(*)(float, char *, short, float), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, s2, f3);
OUTPUT:
	RETVAL

double
nci_dftst( c_func, f0, t1, s2, t3 )
	SV* c_func
	float f0
	char * t1
	short s2
	char * t3
PREINIT:
	double(*func)(float, char *, short, char *);
CODE:
	func   = INT2PTR(double(*)(float, char *, short, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, s2, t3);
OUTPUT:
	RETVAL

double
nci_dftsi( c_func, f0, t1, s2, i3 )
	SV* c_func
	float f0
	char * t1
	short s2
	int i3
PREINIT:
	double(*func)(float, char *, short, int);
CODE:
	func   = INT2PTR(double(*)(float, char *, short, int), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, s2, i3);
OUTPUT:
	RETVAL

double
nci_dftfp( c_func, f0, t1, f2, p3 )
	SV* c_func
	float f0
	char * t1
	float f2
	void * p3
PREINIT:
	double(*func)(float, char *, float, void *);
CODE:
	func   = INT2PTR(double(*)(float, char *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, f2, p3);
OUTPUT:
	RETVAL

double
nci_dftfd( c_func, f0, t1, f2, d3 )
	SV* c_func
	float f0
	char * t1
	float f2
	double d3
PREINIT:
	double(*func)(float, char *, float, double);
CODE:
	func   = INT2PTR(double(*)(float, char *, float, double), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, f2, d3);
OUTPUT:
	RETVAL

double
nci_dftfs( c_func, f0, t1, f2, s3 )
	SV* c_func
	float f0
	char * t1
	float f2
	short s3
PREINIT:
	double(*func)(float, char *, float, short);
CODE:
	func   = INT2PTR(double(*)(float, char *, float, short), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, f2, s3);
OUTPUT:
	RETVAL

double
nci_dftff( c_func, f0, t1, f2, f3 )
	SV* c_func
	float f0
	char * t1
	float f2
	float f3
PREINIT:
	double(*func)(float, char *, float, float);
CODE:
	func   = INT2PTR(double(*)(float, char *, float, float), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, f2, f3);
OUTPUT:
	RETVAL

double
nci_dftft( c_func, f0, t1, f2, t3 )
	SV* c_func
	float f0
	char * t1
	float f2
	char * t3
PREINIT:
	double(*func)(float, char *, float, char *);
CODE:
	func   = INT2PTR(double(*)(float, char *, float, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, f2, t3);
OUTPUT:
	RETVAL

double
nci_dftfi( c_func, f0, t1, f2, i3 )
	SV* c_func
	float f0
	char * t1
	float f2
	int i3
PREINIT:
	double(*func)(float, char *, float, int);
CODE:
	func   = INT2PTR(double(*)(float, char *, float, int), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, f2, i3);
OUTPUT:
	RETVAL

double
nci_dfttp( c_func, f0, t1, t2, p3 )
	SV* c_func
	float f0
	char * t1
	char * t2
	void * p3
PREINIT:
	double(*func)(float, char *, char *, void *);
CODE:
	func   = INT2PTR(double(*)(float, char *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, t2, p3);
OUTPUT:
	RETVAL

double
nci_dfttd( c_func, f0, t1, t2, d3 )
	SV* c_func
	float f0
	char * t1
	char * t2
	double d3
PREINIT:
	double(*func)(float, char *, char *, double);
CODE:
	func   = INT2PTR(double(*)(float, char *, char *, double), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, t2, d3);
OUTPUT:
	RETVAL

double
nci_dftts( c_func, f0, t1, t2, s3 )
	SV* c_func
	float f0
	char * t1
	char * t2
	short s3
PREINIT:
	double(*func)(float, char *, char *, short);
CODE:
	func   = INT2PTR(double(*)(float, char *, char *, short), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, t2, s3);
OUTPUT:
	RETVAL

double
nci_dfttf( c_func, f0, t1, t2, f3 )
	SV* c_func
	float f0
	char * t1
	char * t2
	float f3
PREINIT:
	double(*func)(float, char *, char *, float);
CODE:
	func   = INT2PTR(double(*)(float, char *, char *, float), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, t2, f3);
OUTPUT:
	RETVAL

double
nci_dfttt( c_func, f0, t1, t2, t3 )
	SV* c_func
	float f0
	char * t1
	char * t2
	char * t3
PREINIT:
	double(*func)(float, char *, char *, char *);
CODE:
	func   = INT2PTR(double(*)(float, char *, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, t2, t3);
OUTPUT:
	RETVAL

double
nci_dftti( c_func, f0, t1, t2, i3 )
	SV* c_func
	float f0
	char * t1
	char * t2
	int i3
PREINIT:
	double(*func)(float, char *, char *, int);
CODE:
	func   = INT2PTR(double(*)(float, char *, char *, int), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, t2, i3);
OUTPUT:
	RETVAL

double
nci_dftip( c_func, f0, t1, i2, p3 )
	SV* c_func
	float f0
	char * t1
	int i2
	void * p3
PREINIT:
	double(*func)(float, char *, int, void *);
CODE:
	func   = INT2PTR(double(*)(float, char *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, i2, p3);
OUTPUT:
	RETVAL

double
nci_dftid( c_func, f0, t1, i2, d3 )
	SV* c_func
	float f0
	char * t1
	int i2
	double d3
PREINIT:
	double(*func)(float, char *, int, double);
CODE:
	func   = INT2PTR(double(*)(float, char *, int, double), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, i2, d3);
OUTPUT:
	RETVAL

double
nci_dftis( c_func, f0, t1, i2, s3 )
	SV* c_func
	float f0
	char * t1
	int i2
	short s3
PREINIT:
	double(*func)(float, char *, int, short);
CODE:
	func   = INT2PTR(double(*)(float, char *, int, short), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, i2, s3);
OUTPUT:
	RETVAL

double
nci_dftif( c_func, f0, t1, i2, f3 )
	SV* c_func
	float f0
	char * t1
	int i2
	float f3
PREINIT:
	double(*func)(float, char *, int, float);
CODE:
	func   = INT2PTR(double(*)(float, char *, int, float), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, i2, f3);
OUTPUT:
	RETVAL

double
nci_dftit( c_func, f0, t1, i2, t3 )
	SV* c_func
	float f0
	char * t1
	int i2
	char * t3
PREINIT:
	double(*func)(float, char *, int, char *);
CODE:
	func   = INT2PTR(double(*)(float, char *, int, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, i2, t3);
OUTPUT:
	RETVAL

double
nci_dftii( c_func, f0, t1, i2, i3 )
	SV* c_func
	float f0
	char * t1
	int i2
	int i3
PREINIT:
	double(*func)(float, char *, int, int);
CODE:
	func   = INT2PTR(double(*)(float, char *, int, int), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, i2, i3);
OUTPUT:
	RETVAL

double
nci_dfipp( c_func, f0, i1, p2, p3 )
	SV* c_func
	float f0
	int i1
	void * p2
	void * p3
PREINIT:
	double(*func)(float, int, void *, void *);
CODE:
	func   = INT2PTR(double(*)(float, int, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, p2, p3);
OUTPUT:
	RETVAL

double
nci_dfipd( c_func, f0, i1, p2, d3 )
	SV* c_func
	float f0
	int i1
	void * p2
	double d3
PREINIT:
	double(*func)(float, int, void *, double);
CODE:
	func   = INT2PTR(double(*)(float, int, void *, double), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, p2, d3);
OUTPUT:
	RETVAL

double
nci_dfips( c_func, f0, i1, p2, s3 )
	SV* c_func
	float f0
	int i1
	void * p2
	short s3
PREINIT:
	double(*func)(float, int, void *, short);
CODE:
	func   = INT2PTR(double(*)(float, int, void *, short), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, p2, s3);
OUTPUT:
	RETVAL

double
nci_dfipf( c_func, f0, i1, p2, f3 )
	SV* c_func
	float f0
	int i1
	void * p2
	float f3
PREINIT:
	double(*func)(float, int, void *, float);
CODE:
	func   = INT2PTR(double(*)(float, int, void *, float), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, p2, f3);
OUTPUT:
	RETVAL

double
nci_dfipt( c_func, f0, i1, p2, t3 )
	SV* c_func
	float f0
	int i1
	void * p2
	char * t3
PREINIT:
	double(*func)(float, int, void *, char *);
CODE:
	func   = INT2PTR(double(*)(float, int, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, p2, t3);
OUTPUT:
	RETVAL

double
nci_dfipi( c_func, f0, i1, p2, i3 )
	SV* c_func
	float f0
	int i1
	void * p2
	int i3
PREINIT:
	double(*func)(float, int, void *, int);
CODE:
	func   = INT2PTR(double(*)(float, int, void *, int), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, p2, i3);
OUTPUT:
	RETVAL

double
nci_dfidp( c_func, f0, i1, d2, p3 )
	SV* c_func
	float f0
	int i1
	double d2
	void * p3
PREINIT:
	double(*func)(float, int, double, void *);
CODE:
	func   = INT2PTR(double(*)(float, int, double, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, d2, p3);
OUTPUT:
	RETVAL

double
nci_dfidd( c_func, f0, i1, d2, d3 )
	SV* c_func
	float f0
	int i1
	double d2
	double d3
PREINIT:
	double(*func)(float, int, double, double);
CODE:
	func   = INT2PTR(double(*)(float, int, double, double), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, d2, d3);
OUTPUT:
	RETVAL

double
nci_dfids( c_func, f0, i1, d2, s3 )
	SV* c_func
	float f0
	int i1
	double d2
	short s3
PREINIT:
	double(*func)(float, int, double, short);
CODE:
	func   = INT2PTR(double(*)(float, int, double, short), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, d2, s3);
OUTPUT:
	RETVAL

double
nci_dfidf( c_func, f0, i1, d2, f3 )
	SV* c_func
	float f0
	int i1
	double d2
	float f3
PREINIT:
	double(*func)(float, int, double, float);
CODE:
	func   = INT2PTR(double(*)(float, int, double, float), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, d2, f3);
OUTPUT:
	RETVAL

double
nci_dfidt( c_func, f0, i1, d2, t3 )
	SV* c_func
	float f0
	int i1
	double d2
	char * t3
PREINIT:
	double(*func)(float, int, double, char *);
CODE:
	func   = INT2PTR(double(*)(float, int, double, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, d2, t3);
OUTPUT:
	RETVAL

double
nci_dfidi( c_func, f0, i1, d2, i3 )
	SV* c_func
	float f0
	int i1
	double d2
	int i3
PREINIT:
	double(*func)(float, int, double, int);
CODE:
	func   = INT2PTR(double(*)(float, int, double, int), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, d2, i3);
OUTPUT:
	RETVAL

double
nci_dfisp( c_func, f0, i1, s2, p3 )
	SV* c_func
	float f0
	int i1
	short s2
	void * p3
PREINIT:
	double(*func)(float, int, short, void *);
CODE:
	func   = INT2PTR(double(*)(float, int, short, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, s2, p3);
OUTPUT:
	RETVAL

double
nci_dfisd( c_func, f0, i1, s2, d3 )
	SV* c_func
	float f0
	int i1
	short s2
	double d3
PREINIT:
	double(*func)(float, int, short, double);
CODE:
	func   = INT2PTR(double(*)(float, int, short, double), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, s2, d3);
OUTPUT:
	RETVAL

double
nci_dfiss( c_func, f0, i1, s2, s3 )
	SV* c_func
	float f0
	int i1
	short s2
	short s3
PREINIT:
	double(*func)(float, int, short, short);
CODE:
	func   = INT2PTR(double(*)(float, int, short, short), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, s2, s3);
OUTPUT:
	RETVAL

double
nci_dfisf( c_func, f0, i1, s2, f3 )
	SV* c_func
	float f0
	int i1
	short s2
	float f3
PREINIT:
	double(*func)(float, int, short, float);
CODE:
	func   = INT2PTR(double(*)(float, int, short, float), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, s2, f3);
OUTPUT:
	RETVAL

double
nci_dfist( c_func, f0, i1, s2, t3 )
	SV* c_func
	float f0
	int i1
	short s2
	char * t3
PREINIT:
	double(*func)(float, int, short, char *);
CODE:
	func   = INT2PTR(double(*)(float, int, short, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, s2, t3);
OUTPUT:
	RETVAL

double
nci_dfisi( c_func, f0, i1, s2, i3 )
	SV* c_func
	float f0
	int i1
	short s2
	int i3
PREINIT:
	double(*func)(float, int, short, int);
CODE:
	func   = INT2PTR(double(*)(float, int, short, int), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, s2, i3);
OUTPUT:
	RETVAL

double
nci_dfifp( c_func, f0, i1, f2, p3 )
	SV* c_func
	float f0
	int i1
	float f2
	void * p3
PREINIT:
	double(*func)(float, int, float, void *);
CODE:
	func   = INT2PTR(double(*)(float, int, float, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, f2, p3);
OUTPUT:
	RETVAL

double
nci_dfifd( c_func, f0, i1, f2, d3 )
	SV* c_func
	float f0
	int i1
	float f2
	double d3
PREINIT:
	double(*func)(float, int, float, double);
CODE:
	func   = INT2PTR(double(*)(float, int, float, double), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, f2, d3);
OUTPUT:
	RETVAL

double
nci_dfifs( c_func, f0, i1, f2, s3 )
	SV* c_func
	float f0
	int i1
	float f2
	short s3
PREINIT:
	double(*func)(float, int, float, short);
CODE:
	func   = INT2PTR(double(*)(float, int, float, short), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, f2, s3);
OUTPUT:
	RETVAL

double
nci_dfiff( c_func, f0, i1, f2, f3 )
	SV* c_func
	float f0
	int i1
	float f2
	float f3
PREINIT:
	double(*func)(float, int, float, float);
CODE:
	func   = INT2PTR(double(*)(float, int, float, float), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, f2, f3);
OUTPUT:
	RETVAL

double
nci_dfift( c_func, f0, i1, f2, t3 )
	SV* c_func
	float f0
	int i1
	float f2
	char * t3
PREINIT:
	double(*func)(float, int, float, char *);
CODE:
	func   = INT2PTR(double(*)(float, int, float, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, f2, t3);
OUTPUT:
	RETVAL

double
nci_dfifi( c_func, f0, i1, f2, i3 )
	SV* c_func
	float f0
	int i1
	float f2
	int i3
PREINIT:
	double(*func)(float, int, float, int);
CODE:
	func   = INT2PTR(double(*)(float, int, float, int), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, f2, i3);
OUTPUT:
	RETVAL

double
nci_dfitp( c_func, f0, i1, t2, p3 )
	SV* c_func
	float f0
	int i1
	char * t2
	void * p3
PREINIT:
	double(*func)(float, int, char *, void *);
CODE:
	func   = INT2PTR(double(*)(float, int, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, t2, p3);
OUTPUT:
	RETVAL

double
nci_dfitd( c_func, f0, i1, t2, d3 )
	SV* c_func
	float f0
	int i1
	char * t2
	double d3
PREINIT:
	double(*func)(float, int, char *, double);
CODE:
	func   = INT2PTR(double(*)(float, int, char *, double), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, t2, d3);
OUTPUT:
	RETVAL

double
nci_dfits( c_func, f0, i1, t2, s3 )
	SV* c_func
	float f0
	int i1
	char * t2
	short s3
PREINIT:
	double(*func)(float, int, char *, short);
CODE:
	func   = INT2PTR(double(*)(float, int, char *, short), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, t2, s3);
OUTPUT:
	RETVAL

double
nci_dfitf( c_func, f0, i1, t2, f3 )
	SV* c_func
	float f0
	int i1
	char * t2
	float f3
PREINIT:
	double(*func)(float, int, char *, float);
CODE:
	func   = INT2PTR(double(*)(float, int, char *, float), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, t2, f3);
OUTPUT:
	RETVAL

double
nci_dfitt( c_func, f0, i1, t2, t3 )
	SV* c_func
	float f0
	int i1
	char * t2
	char * t3
PREINIT:
	double(*func)(float, int, char *, char *);
CODE:
	func   = INT2PTR(double(*)(float, int, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, t2, t3);
OUTPUT:
	RETVAL

double
nci_dfiti( c_func, f0, i1, t2, i3 )
	SV* c_func
	float f0
	int i1
	char * t2
	int i3
PREINIT:
	double(*func)(float, int, char *, int);
CODE:
	func   = INT2PTR(double(*)(float, int, char *, int), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, t2, i3);
OUTPUT:
	RETVAL

double
nci_dfiip( c_func, f0, i1, i2, p3 )
	SV* c_func
	float f0
	int i1
	int i2
	void * p3
PREINIT:
	double(*func)(float, int, int, void *);
CODE:
	func   = INT2PTR(double(*)(float, int, int, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, i2, p3);
OUTPUT:
	RETVAL

double
nci_dfiid( c_func, f0, i1, i2, d3 )
	SV* c_func
	float f0
	int i1
	int i2
	double d3
PREINIT:
	double(*func)(float, int, int, double);
CODE:
	func   = INT2PTR(double(*)(float, int, int, double), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, i2, d3);
OUTPUT:
	RETVAL

double
nci_dfiis( c_func, f0, i1, i2, s3 )
	SV* c_func
	float f0
	int i1
	int i2
	short s3
PREINIT:
	double(*func)(float, int, int, short);
CODE:
	func   = INT2PTR(double(*)(float, int, int, short), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, i2, s3);
OUTPUT:
	RETVAL

double
nci_dfiif( c_func, f0, i1, i2, f3 )
	SV* c_func
	float f0
	int i1
	int i2
	float f3
PREINIT:
	double(*func)(float, int, int, float);
CODE:
	func   = INT2PTR(double(*)(float, int, int, float), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, i2, f3);
OUTPUT:
	RETVAL

double
nci_dfiit( c_func, f0, i1, i2, t3 )
	SV* c_func
	float f0
	int i1
	int i2
	char * t3
PREINIT:
	double(*func)(float, int, int, char *);
CODE:
	func   = INT2PTR(double(*)(float, int, int, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, i2, t3);
OUTPUT:
	RETVAL

double
nci_dfiii( c_func, f0, i1, i2, i3 )
	SV* c_func
	float f0
	int i1
	int i2
	int i3
PREINIT:
	double(*func)(float, int, int, int);
CODE:
	func   = INT2PTR(double(*)(float, int, int, int), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, i2, i3);
OUTPUT:
	RETVAL

double
nci_dtppp( c_func, t0, p1, p2, p3 )
	SV* c_func
	char * t0
	void * p1
	void * p2
	void * p3
PREINIT:
	double(*func)(char *, void *, void *, void *);
CODE:
	func   = INT2PTR(double(*)(char *, void *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, p2, p3);
OUTPUT:
	RETVAL

double
nci_dtppd( c_func, t0, p1, p2, d3 )
	SV* c_func
	char * t0
	void * p1
	void * p2
	double d3
PREINIT:
	double(*func)(char *, void *, void *, double);
CODE:
	func   = INT2PTR(double(*)(char *, void *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, p2, d3);
OUTPUT:
	RETVAL

double
nci_dtpps( c_func, t0, p1, p2, s3 )
	SV* c_func
	char * t0
	void * p1
	void * p2
	short s3
PREINIT:
	double(*func)(char *, void *, void *, short);
CODE:
	func   = INT2PTR(double(*)(char *, void *, void *, short), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, p2, s3);
OUTPUT:
	RETVAL

double
nci_dtppf( c_func, t0, p1, p2, f3 )
	SV* c_func
	char * t0
	void * p1
	void * p2
	float f3
PREINIT:
	double(*func)(char *, void *, void *, float);
CODE:
	func   = INT2PTR(double(*)(char *, void *, void *, float), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, p2, f3);
OUTPUT:
	RETVAL

double
nci_dtppt( c_func, t0, p1, p2, t3 )
	SV* c_func
	char * t0
	void * p1
	void * p2
	char * t3
PREINIT:
	double(*func)(char *, void *, void *, char *);
CODE:
	func   = INT2PTR(double(*)(char *, void *, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, p2, t3);
OUTPUT:
	RETVAL

double
nci_dtppi( c_func, t0, p1, p2, i3 )
	SV* c_func
	char * t0
	void * p1
	void * p2
	int i3
PREINIT:
	double(*func)(char *, void *, void *, int);
CODE:
	func   = INT2PTR(double(*)(char *, void *, void *, int), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, p2, i3);
OUTPUT:
	RETVAL

double
nci_dtpdp( c_func, t0, p1, d2, p3 )
	SV* c_func
	char * t0
	void * p1
	double d2
	void * p3
PREINIT:
	double(*func)(char *, void *, double, void *);
CODE:
	func   = INT2PTR(double(*)(char *, void *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, d2, p3);
OUTPUT:
	RETVAL

double
nci_dtpdd( c_func, t0, p1, d2, d3 )
	SV* c_func
	char * t0
	void * p1
	double d2
	double d3
PREINIT:
	double(*func)(char *, void *, double, double);
CODE:
	func   = INT2PTR(double(*)(char *, void *, double, double), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, d2, d3);
OUTPUT:
	RETVAL

double
nci_dtpds( c_func, t0, p1, d2, s3 )
	SV* c_func
	char * t0
	void * p1
	double d2
	short s3
PREINIT:
	double(*func)(char *, void *, double, short);
CODE:
	func   = INT2PTR(double(*)(char *, void *, double, short), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, d2, s3);
OUTPUT:
	RETVAL

double
nci_dtpdf( c_func, t0, p1, d2, f3 )
	SV* c_func
	char * t0
	void * p1
	double d2
	float f3
PREINIT:
	double(*func)(char *, void *, double, float);
CODE:
	func   = INT2PTR(double(*)(char *, void *, double, float), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, d2, f3);
OUTPUT:
	RETVAL

double
nci_dtpdt( c_func, t0, p1, d2, t3 )
	SV* c_func
	char * t0
	void * p1
	double d2
	char * t3
PREINIT:
	double(*func)(char *, void *, double, char *);
CODE:
	func   = INT2PTR(double(*)(char *, void *, double, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, d2, t3);
OUTPUT:
	RETVAL

double
nci_dtpdi( c_func, t0, p1, d2, i3 )
	SV* c_func
	char * t0
	void * p1
	double d2
	int i3
PREINIT:
	double(*func)(char *, void *, double, int);
CODE:
	func   = INT2PTR(double(*)(char *, void *, double, int), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, d2, i3);
OUTPUT:
	RETVAL

double
nci_dtpsp( c_func, t0, p1, s2, p3 )
	SV* c_func
	char * t0
	void * p1
	short s2
	void * p3
PREINIT:
	double(*func)(char *, void *, short, void *);
CODE:
	func   = INT2PTR(double(*)(char *, void *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, s2, p3);
OUTPUT:
	RETVAL

double
nci_dtpsd( c_func, t0, p1, s2, d3 )
	SV* c_func
	char * t0
	void * p1
	short s2
	double d3
PREINIT:
	double(*func)(char *, void *, short, double);
CODE:
	func   = INT2PTR(double(*)(char *, void *, short, double), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, s2, d3);
OUTPUT:
	RETVAL

double
nci_dtpss( c_func, t0, p1, s2, s3 )
	SV* c_func
	char * t0
	void * p1
	short s2
	short s3
PREINIT:
	double(*func)(char *, void *, short, short);
CODE:
	func   = INT2PTR(double(*)(char *, void *, short, short), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, s2, s3);
OUTPUT:
	RETVAL

double
nci_dtpsf( c_func, t0, p1, s2, f3 )
	SV* c_func
	char * t0
	void * p1
	short s2
	float f3
PREINIT:
	double(*func)(char *, void *, short, float);
CODE:
	func   = INT2PTR(double(*)(char *, void *, short, float), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, s2, f3);
OUTPUT:
	RETVAL

double
nci_dtpst( c_func, t0, p1, s2, t3 )
	SV* c_func
	char * t0
	void * p1
	short s2
	char * t3
PREINIT:
	double(*func)(char *, void *, short, char *);
CODE:
	func   = INT2PTR(double(*)(char *, void *, short, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, s2, t3);
OUTPUT:
	RETVAL

double
nci_dtpsi( c_func, t0, p1, s2, i3 )
	SV* c_func
	char * t0
	void * p1
	short s2
	int i3
PREINIT:
	double(*func)(char *, void *, short, int);
CODE:
	func   = INT2PTR(double(*)(char *, void *, short, int), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, s2, i3);
OUTPUT:
	RETVAL

double
nci_dtpfp( c_func, t0, p1, f2, p3 )
	SV* c_func
	char * t0
	void * p1
	float f2
	void * p3
PREINIT:
	double(*func)(char *, void *, float, void *);
CODE:
	func   = INT2PTR(double(*)(char *, void *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, f2, p3);
OUTPUT:
	RETVAL

double
nci_dtpfd( c_func, t0, p1, f2, d3 )
	SV* c_func
	char * t0
	void * p1
	float f2
	double d3
PREINIT:
	double(*func)(char *, void *, float, double);
CODE:
	func   = INT2PTR(double(*)(char *, void *, float, double), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, f2, d3);
OUTPUT:
	RETVAL

double
nci_dtpfs( c_func, t0, p1, f2, s3 )
	SV* c_func
	char * t0
	void * p1
	float f2
	short s3
PREINIT:
	double(*func)(char *, void *, float, short);
CODE:
	func   = INT2PTR(double(*)(char *, void *, float, short), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, f2, s3);
OUTPUT:
	RETVAL

double
nci_dtpff( c_func, t0, p1, f2, f3 )
	SV* c_func
	char * t0
	void * p1
	float f2
	float f3
PREINIT:
	double(*func)(char *, void *, float, float);
CODE:
	func   = INT2PTR(double(*)(char *, void *, float, float), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, f2, f3);
OUTPUT:
	RETVAL

double
nci_dtpft( c_func, t0, p1, f2, t3 )
	SV* c_func
	char * t0
	void * p1
	float f2
	char * t3
PREINIT:
	double(*func)(char *, void *, float, char *);
CODE:
	func   = INT2PTR(double(*)(char *, void *, float, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, f2, t3);
OUTPUT:
	RETVAL

double
nci_dtpfi( c_func, t0, p1, f2, i3 )
	SV* c_func
	char * t0
	void * p1
	float f2
	int i3
PREINIT:
	double(*func)(char *, void *, float, int);
CODE:
	func   = INT2PTR(double(*)(char *, void *, float, int), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, f2, i3);
OUTPUT:
	RETVAL

double
nci_dtptp( c_func, t0, p1, t2, p3 )
	SV* c_func
	char * t0
	void * p1
	char * t2
	void * p3
PREINIT:
	double(*func)(char *, void *, char *, void *);
CODE:
	func   = INT2PTR(double(*)(char *, void *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, t2, p3);
OUTPUT:
	RETVAL

double
nci_dtptd( c_func, t0, p1, t2, d3 )
	SV* c_func
	char * t0
	void * p1
	char * t2
	double d3
PREINIT:
	double(*func)(char *, void *, char *, double);
CODE:
	func   = INT2PTR(double(*)(char *, void *, char *, double), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, t2, d3);
OUTPUT:
	RETVAL

double
nci_dtpts( c_func, t0, p1, t2, s3 )
	SV* c_func
	char * t0
	void * p1
	char * t2
	short s3
PREINIT:
	double(*func)(char *, void *, char *, short);
CODE:
	func   = INT2PTR(double(*)(char *, void *, char *, short), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, t2, s3);
OUTPUT:
	RETVAL

double
nci_dtptf( c_func, t0, p1, t2, f3 )
	SV* c_func
	char * t0
	void * p1
	char * t2
	float f3
PREINIT:
	double(*func)(char *, void *, char *, float);
CODE:
	func   = INT2PTR(double(*)(char *, void *, char *, float), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, t2, f3);
OUTPUT:
	RETVAL

double
nci_dtptt( c_func, t0, p1, t2, t3 )
	SV* c_func
	char * t0
	void * p1
	char * t2
	char * t3
PREINIT:
	double(*func)(char *, void *, char *, char *);
CODE:
	func   = INT2PTR(double(*)(char *, void *, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, t2, t3);
OUTPUT:
	RETVAL

double
nci_dtpti( c_func, t0, p1, t2, i3 )
	SV* c_func
	char * t0
	void * p1
	char * t2
	int i3
PREINIT:
	double(*func)(char *, void *, char *, int);
CODE:
	func   = INT2PTR(double(*)(char *, void *, char *, int), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, t2, i3);
OUTPUT:
	RETVAL

double
nci_dtpip( c_func, t0, p1, i2, p3 )
	SV* c_func
	char * t0
	void * p1
	int i2
	void * p3
PREINIT:
	double(*func)(char *, void *, int, void *);
CODE:
	func   = INT2PTR(double(*)(char *, void *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, i2, p3);
OUTPUT:
	RETVAL

double
nci_dtpid( c_func, t0, p1, i2, d3 )
	SV* c_func
	char * t0
	void * p1
	int i2
	double d3
PREINIT:
	double(*func)(char *, void *, int, double);
CODE:
	func   = INT2PTR(double(*)(char *, void *, int, double), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, i2, d3);
OUTPUT:
	RETVAL

double
nci_dtpis( c_func, t0, p1, i2, s3 )
	SV* c_func
	char * t0
	void * p1
	int i2
	short s3
PREINIT:
	double(*func)(char *, void *, int, short);
CODE:
	func   = INT2PTR(double(*)(char *, void *, int, short), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, i2, s3);
OUTPUT:
	RETVAL

double
nci_dtpif( c_func, t0, p1, i2, f3 )
	SV* c_func
	char * t0
	void * p1
	int i2
	float f3
PREINIT:
	double(*func)(char *, void *, int, float);
CODE:
	func   = INT2PTR(double(*)(char *, void *, int, float), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, i2, f3);
OUTPUT:
	RETVAL

double
nci_dtpit( c_func, t0, p1, i2, t3 )
	SV* c_func
	char * t0
	void * p1
	int i2
	char * t3
PREINIT:
	double(*func)(char *, void *, int, char *);
CODE:
	func   = INT2PTR(double(*)(char *, void *, int, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, i2, t3);
OUTPUT:
	RETVAL

double
nci_dtpii( c_func, t0, p1, i2, i3 )
	SV* c_func
	char * t0
	void * p1
	int i2
	int i3
PREINIT:
	double(*func)(char *, void *, int, int);
CODE:
	func   = INT2PTR(double(*)(char *, void *, int, int), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, i2, i3);
OUTPUT:
	RETVAL

double
nci_dtdpp( c_func, t0, d1, p2, p3 )
	SV* c_func
	char * t0
	double d1
	void * p2
	void * p3
PREINIT:
	double(*func)(char *, double, void *, void *);
CODE:
	func   = INT2PTR(double(*)(char *, double, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, p2, p3);
OUTPUT:
	RETVAL

double
nci_dtdpd( c_func, t0, d1, p2, d3 )
	SV* c_func
	char * t0
	double d1
	void * p2
	double d3
PREINIT:
	double(*func)(char *, double, void *, double);
CODE:
	func   = INT2PTR(double(*)(char *, double, void *, double), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, p2, d3);
OUTPUT:
	RETVAL

double
nci_dtdps( c_func, t0, d1, p2, s3 )
	SV* c_func
	char * t0
	double d1
	void * p2
	short s3
PREINIT:
	double(*func)(char *, double, void *, short);
CODE:
	func   = INT2PTR(double(*)(char *, double, void *, short), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, p2, s3);
OUTPUT:
	RETVAL

double
nci_dtdpf( c_func, t0, d1, p2, f3 )
	SV* c_func
	char * t0
	double d1
	void * p2
	float f3
PREINIT:
	double(*func)(char *, double, void *, float);
CODE:
	func   = INT2PTR(double(*)(char *, double, void *, float), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, p2, f3);
OUTPUT:
	RETVAL

double
nci_dtdpt( c_func, t0, d1, p2, t3 )
	SV* c_func
	char * t0
	double d1
	void * p2
	char * t3
PREINIT:
	double(*func)(char *, double, void *, char *);
CODE:
	func   = INT2PTR(double(*)(char *, double, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, p2, t3);
OUTPUT:
	RETVAL

double
nci_dtdpi( c_func, t0, d1, p2, i3 )
	SV* c_func
	char * t0
	double d1
	void * p2
	int i3
PREINIT:
	double(*func)(char *, double, void *, int);
CODE:
	func   = INT2PTR(double(*)(char *, double, void *, int), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, p2, i3);
OUTPUT:
	RETVAL

double
nci_dtddp( c_func, t0, d1, d2, p3 )
	SV* c_func
	char * t0
	double d1
	double d2
	void * p3
PREINIT:
	double(*func)(char *, double, double, void *);
CODE:
	func   = INT2PTR(double(*)(char *, double, double, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, d2, p3);
OUTPUT:
	RETVAL

double
nci_dtddd( c_func, t0, d1, d2, d3 )
	SV* c_func
	char * t0
	double d1
	double d2
	double d3
PREINIT:
	double(*func)(char *, double, double, double);
CODE:
	func   = INT2PTR(double(*)(char *, double, double, double), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, d2, d3);
OUTPUT:
	RETVAL

double
nci_dtdds( c_func, t0, d1, d2, s3 )
	SV* c_func
	char * t0
	double d1
	double d2
	short s3
PREINIT:
	double(*func)(char *, double, double, short);
CODE:
	func   = INT2PTR(double(*)(char *, double, double, short), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, d2, s3);
OUTPUT:
	RETVAL

double
nci_dtddf( c_func, t0, d1, d2, f3 )
	SV* c_func
	char * t0
	double d1
	double d2
	float f3
PREINIT:
	double(*func)(char *, double, double, float);
CODE:
	func   = INT2PTR(double(*)(char *, double, double, float), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, d2, f3);
OUTPUT:
	RETVAL

double
nci_dtddt( c_func, t0, d1, d2, t3 )
	SV* c_func
	char * t0
	double d1
	double d2
	char * t3
PREINIT:
	double(*func)(char *, double, double, char *);
CODE:
	func   = INT2PTR(double(*)(char *, double, double, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, d2, t3);
OUTPUT:
	RETVAL

double
nci_dtddi( c_func, t0, d1, d2, i3 )
	SV* c_func
	char * t0
	double d1
	double d2
	int i3
PREINIT:
	double(*func)(char *, double, double, int);
CODE:
	func   = INT2PTR(double(*)(char *, double, double, int), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, d2, i3);
OUTPUT:
	RETVAL

double
nci_dtdsp( c_func, t0, d1, s2, p3 )
	SV* c_func
	char * t0
	double d1
	short s2
	void * p3
PREINIT:
	double(*func)(char *, double, short, void *);
CODE:
	func   = INT2PTR(double(*)(char *, double, short, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, s2, p3);
OUTPUT:
	RETVAL

double
nci_dtdsd( c_func, t0, d1, s2, d3 )
	SV* c_func
	char * t0
	double d1
	short s2
	double d3
PREINIT:
	double(*func)(char *, double, short, double);
CODE:
	func   = INT2PTR(double(*)(char *, double, short, double), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, s2, d3);
OUTPUT:
	RETVAL

double
nci_dtdss( c_func, t0, d1, s2, s3 )
	SV* c_func
	char * t0
	double d1
	short s2
	short s3
PREINIT:
	double(*func)(char *, double, short, short);
CODE:
	func   = INT2PTR(double(*)(char *, double, short, short), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, s2, s3);
OUTPUT:
	RETVAL

double
nci_dtdsf( c_func, t0, d1, s2, f3 )
	SV* c_func
	char * t0
	double d1
	short s2
	float f3
PREINIT:
	double(*func)(char *, double, short, float);
CODE:
	func   = INT2PTR(double(*)(char *, double, short, float), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, s2, f3);
OUTPUT:
	RETVAL

double
nci_dtdst( c_func, t0, d1, s2, t3 )
	SV* c_func
	char * t0
	double d1
	short s2
	char * t3
PREINIT:
	double(*func)(char *, double, short, char *);
CODE:
	func   = INT2PTR(double(*)(char *, double, short, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, s2, t3);
OUTPUT:
	RETVAL

double
nci_dtdsi( c_func, t0, d1, s2, i3 )
	SV* c_func
	char * t0
	double d1
	short s2
	int i3
PREINIT:
	double(*func)(char *, double, short, int);
CODE:
	func   = INT2PTR(double(*)(char *, double, short, int), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, s2, i3);
OUTPUT:
	RETVAL

double
nci_dtdfp( c_func, t0, d1, f2, p3 )
	SV* c_func
	char * t0
	double d1
	float f2
	void * p3
PREINIT:
	double(*func)(char *, double, float, void *);
CODE:
	func   = INT2PTR(double(*)(char *, double, float, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, f2, p3);
OUTPUT:
	RETVAL

double
nci_dtdfd( c_func, t0, d1, f2, d3 )
	SV* c_func
	char * t0
	double d1
	float f2
	double d3
PREINIT:
	double(*func)(char *, double, float, double);
CODE:
	func   = INT2PTR(double(*)(char *, double, float, double), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, f2, d3);
OUTPUT:
	RETVAL

double
nci_dtdfs( c_func, t0, d1, f2, s3 )
	SV* c_func
	char * t0
	double d1
	float f2
	short s3
PREINIT:
	double(*func)(char *, double, float, short);
CODE:
	func   = INT2PTR(double(*)(char *, double, float, short), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, f2, s3);
OUTPUT:
	RETVAL

double
nci_dtdff( c_func, t0, d1, f2, f3 )
	SV* c_func
	char * t0
	double d1
	float f2
	float f3
PREINIT:
	double(*func)(char *, double, float, float);
CODE:
	func   = INT2PTR(double(*)(char *, double, float, float), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, f2, f3);
OUTPUT:
	RETVAL

double
nci_dtdft( c_func, t0, d1, f2, t3 )
	SV* c_func
	char * t0
	double d1
	float f2
	char * t3
PREINIT:
	double(*func)(char *, double, float, char *);
CODE:
	func   = INT2PTR(double(*)(char *, double, float, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, f2, t3);
OUTPUT:
	RETVAL

double
nci_dtdfi( c_func, t0, d1, f2, i3 )
	SV* c_func
	char * t0
	double d1
	float f2
	int i3
PREINIT:
	double(*func)(char *, double, float, int);
CODE:
	func   = INT2PTR(double(*)(char *, double, float, int), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, f2, i3);
OUTPUT:
	RETVAL

double
nci_dtdtp( c_func, t0, d1, t2, p3 )
	SV* c_func
	char * t0
	double d1
	char * t2
	void * p3
PREINIT:
	double(*func)(char *, double, char *, void *);
CODE:
	func   = INT2PTR(double(*)(char *, double, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, t2, p3);
OUTPUT:
	RETVAL

double
nci_dtdtd( c_func, t0, d1, t2, d3 )
	SV* c_func
	char * t0
	double d1
	char * t2
	double d3
PREINIT:
	double(*func)(char *, double, char *, double);
CODE:
	func   = INT2PTR(double(*)(char *, double, char *, double), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, t2, d3);
OUTPUT:
	RETVAL

double
nci_dtdts( c_func, t0, d1, t2, s3 )
	SV* c_func
	char * t0
	double d1
	char * t2
	short s3
PREINIT:
	double(*func)(char *, double, char *, short);
CODE:
	func   = INT2PTR(double(*)(char *, double, char *, short), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, t2, s3);
OUTPUT:
	RETVAL

double
nci_dtdtf( c_func, t0, d1, t2, f3 )
	SV* c_func
	char * t0
	double d1
	char * t2
	float f3
PREINIT:
	double(*func)(char *, double, char *, float);
CODE:
	func   = INT2PTR(double(*)(char *, double, char *, float), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, t2, f3);
OUTPUT:
	RETVAL

double
nci_dtdtt( c_func, t0, d1, t2, t3 )
	SV* c_func
	char * t0
	double d1
	char * t2
	char * t3
PREINIT:
	double(*func)(char *, double, char *, char *);
CODE:
	func   = INT2PTR(double(*)(char *, double, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, t2, t3);
OUTPUT:
	RETVAL

double
nci_dtdti( c_func, t0, d1, t2, i3 )
	SV* c_func
	char * t0
	double d1
	char * t2
	int i3
PREINIT:
	double(*func)(char *, double, char *, int);
CODE:
	func   = INT2PTR(double(*)(char *, double, char *, int), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, t2, i3);
OUTPUT:
	RETVAL

double
nci_dtdip( c_func, t0, d1, i2, p3 )
	SV* c_func
	char * t0
	double d1
	int i2
	void * p3
PREINIT:
	double(*func)(char *, double, int, void *);
CODE:
	func   = INT2PTR(double(*)(char *, double, int, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, i2, p3);
OUTPUT:
	RETVAL

double
nci_dtdid( c_func, t0, d1, i2, d3 )
	SV* c_func
	char * t0
	double d1
	int i2
	double d3
PREINIT:
	double(*func)(char *, double, int, double);
CODE:
	func   = INT2PTR(double(*)(char *, double, int, double), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, i2, d3);
OUTPUT:
	RETVAL

double
nci_dtdis( c_func, t0, d1, i2, s3 )
	SV* c_func
	char * t0
	double d1
	int i2
	short s3
PREINIT:
	double(*func)(char *, double, int, short);
CODE:
	func   = INT2PTR(double(*)(char *, double, int, short), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, i2, s3);
OUTPUT:
	RETVAL

double
nci_dtdif( c_func, t0, d1, i2, f3 )
	SV* c_func
	char * t0
	double d1
	int i2
	float f3
PREINIT:
	double(*func)(char *, double, int, float);
CODE:
	func   = INT2PTR(double(*)(char *, double, int, float), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, i2, f3);
OUTPUT:
	RETVAL

double
nci_dtdit( c_func, t0, d1, i2, t3 )
	SV* c_func
	char * t0
	double d1
	int i2
	char * t3
PREINIT:
	double(*func)(char *, double, int, char *);
CODE:
	func   = INT2PTR(double(*)(char *, double, int, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, i2, t3);
OUTPUT:
	RETVAL

double
nci_dtdii( c_func, t0, d1, i2, i3 )
	SV* c_func
	char * t0
	double d1
	int i2
	int i3
PREINIT:
	double(*func)(char *, double, int, int);
CODE:
	func   = INT2PTR(double(*)(char *, double, int, int), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, i2, i3);
OUTPUT:
	RETVAL

double
nci_dtspp( c_func, t0, s1, p2, p3 )
	SV* c_func
	char * t0
	short s1
	void * p2
	void * p3
PREINIT:
	double(*func)(char *, short, void *, void *);
CODE:
	func   = INT2PTR(double(*)(char *, short, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, p2, p3);
OUTPUT:
	RETVAL

double
nci_dtspd( c_func, t0, s1, p2, d3 )
	SV* c_func
	char * t0
	short s1
	void * p2
	double d3
PREINIT:
	double(*func)(char *, short, void *, double);
CODE:
	func   = INT2PTR(double(*)(char *, short, void *, double), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, p2, d3);
OUTPUT:
	RETVAL

double
nci_dtsps( c_func, t0, s1, p2, s3 )
	SV* c_func
	char * t0
	short s1
	void * p2
	short s3
PREINIT:
	double(*func)(char *, short, void *, short);
CODE:
	func   = INT2PTR(double(*)(char *, short, void *, short), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, p2, s3);
OUTPUT:
	RETVAL

double
nci_dtspf( c_func, t0, s1, p2, f3 )
	SV* c_func
	char * t0
	short s1
	void * p2
	float f3
PREINIT:
	double(*func)(char *, short, void *, float);
CODE:
	func   = INT2PTR(double(*)(char *, short, void *, float), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, p2, f3);
OUTPUT:
	RETVAL

double
nci_dtspt( c_func, t0, s1, p2, t3 )
	SV* c_func
	char * t0
	short s1
	void * p2
	char * t3
PREINIT:
	double(*func)(char *, short, void *, char *);
CODE:
	func   = INT2PTR(double(*)(char *, short, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, p2, t3);
OUTPUT:
	RETVAL

double
nci_dtspi( c_func, t0, s1, p2, i3 )
	SV* c_func
	char * t0
	short s1
	void * p2
	int i3
PREINIT:
	double(*func)(char *, short, void *, int);
CODE:
	func   = INT2PTR(double(*)(char *, short, void *, int), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, p2, i3);
OUTPUT:
	RETVAL

double
nci_dtsdp( c_func, t0, s1, d2, p3 )
	SV* c_func
	char * t0
	short s1
	double d2
	void * p3
PREINIT:
	double(*func)(char *, short, double, void *);
CODE:
	func   = INT2PTR(double(*)(char *, short, double, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, d2, p3);
OUTPUT:
	RETVAL

double
nci_dtsdd( c_func, t0, s1, d2, d3 )
	SV* c_func
	char * t0
	short s1
	double d2
	double d3
PREINIT:
	double(*func)(char *, short, double, double);
CODE:
	func   = INT2PTR(double(*)(char *, short, double, double), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, d2, d3);
OUTPUT:
	RETVAL

double
nci_dtsds( c_func, t0, s1, d2, s3 )
	SV* c_func
	char * t0
	short s1
	double d2
	short s3
PREINIT:
	double(*func)(char *, short, double, short);
CODE:
	func   = INT2PTR(double(*)(char *, short, double, short), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, d2, s3);
OUTPUT:
	RETVAL

double
nci_dtsdf( c_func, t0, s1, d2, f3 )
	SV* c_func
	char * t0
	short s1
	double d2
	float f3
PREINIT:
	double(*func)(char *, short, double, float);
CODE:
	func   = INT2PTR(double(*)(char *, short, double, float), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, d2, f3);
OUTPUT:
	RETVAL

double
nci_dtsdt( c_func, t0, s1, d2, t3 )
	SV* c_func
	char * t0
	short s1
	double d2
	char * t3
PREINIT:
	double(*func)(char *, short, double, char *);
CODE:
	func   = INT2PTR(double(*)(char *, short, double, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, d2, t3);
OUTPUT:
	RETVAL

double
nci_dtsdi( c_func, t0, s1, d2, i3 )
	SV* c_func
	char * t0
	short s1
	double d2
	int i3
PREINIT:
	double(*func)(char *, short, double, int);
CODE:
	func   = INT2PTR(double(*)(char *, short, double, int), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, d2, i3);
OUTPUT:
	RETVAL

double
nci_dtssp( c_func, t0, s1, s2, p3 )
	SV* c_func
	char * t0
	short s1
	short s2
	void * p3
PREINIT:
	double(*func)(char *, short, short, void *);
CODE:
	func   = INT2PTR(double(*)(char *, short, short, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, s2, p3);
OUTPUT:
	RETVAL

double
nci_dtssd( c_func, t0, s1, s2, d3 )
	SV* c_func
	char * t0
	short s1
	short s2
	double d3
PREINIT:
	double(*func)(char *, short, short, double);
CODE:
	func   = INT2PTR(double(*)(char *, short, short, double), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, s2, d3);
OUTPUT:
	RETVAL

double
nci_dtsss( c_func, t0, s1, s2, s3 )
	SV* c_func
	char * t0
	short s1
	short s2
	short s3
PREINIT:
	double(*func)(char *, short, short, short);
CODE:
	func   = INT2PTR(double(*)(char *, short, short, short), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, s2, s3);
OUTPUT:
	RETVAL

double
nci_dtssf( c_func, t0, s1, s2, f3 )
	SV* c_func
	char * t0
	short s1
	short s2
	float f3
PREINIT:
	double(*func)(char *, short, short, float);
CODE:
	func   = INT2PTR(double(*)(char *, short, short, float), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, s2, f3);
OUTPUT:
	RETVAL

double
nci_dtsst( c_func, t0, s1, s2, t3 )
	SV* c_func
	char * t0
	short s1
	short s2
	char * t3
PREINIT:
	double(*func)(char *, short, short, char *);
CODE:
	func   = INT2PTR(double(*)(char *, short, short, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, s2, t3);
OUTPUT:
	RETVAL

double
nci_dtssi( c_func, t0, s1, s2, i3 )
	SV* c_func
	char * t0
	short s1
	short s2
	int i3
PREINIT:
	double(*func)(char *, short, short, int);
CODE:
	func   = INT2PTR(double(*)(char *, short, short, int), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, s2, i3);
OUTPUT:
	RETVAL

double
nci_dtsfp( c_func, t0, s1, f2, p3 )
	SV* c_func
	char * t0
	short s1
	float f2
	void * p3
PREINIT:
	double(*func)(char *, short, float, void *);
CODE:
	func   = INT2PTR(double(*)(char *, short, float, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, f2, p3);
OUTPUT:
	RETVAL

double
nci_dtsfd( c_func, t0, s1, f2, d3 )
	SV* c_func
	char * t0
	short s1
	float f2
	double d3
PREINIT:
	double(*func)(char *, short, float, double);
CODE:
	func   = INT2PTR(double(*)(char *, short, float, double), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, f2, d3);
OUTPUT:
	RETVAL

double
nci_dtsfs( c_func, t0, s1, f2, s3 )
	SV* c_func
	char * t0
	short s1
	float f2
	short s3
PREINIT:
	double(*func)(char *, short, float, short);
CODE:
	func   = INT2PTR(double(*)(char *, short, float, short), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, f2, s3);
OUTPUT:
	RETVAL

double
nci_dtsff( c_func, t0, s1, f2, f3 )
	SV* c_func
	char * t0
	short s1
	float f2
	float f3
PREINIT:
	double(*func)(char *, short, float, float);
CODE:
	func   = INT2PTR(double(*)(char *, short, float, float), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, f2, f3);
OUTPUT:
	RETVAL

double
nci_dtsft( c_func, t0, s1, f2, t3 )
	SV* c_func
	char * t0
	short s1
	float f2
	char * t3
PREINIT:
	double(*func)(char *, short, float, char *);
CODE:
	func   = INT2PTR(double(*)(char *, short, float, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, f2, t3);
OUTPUT:
	RETVAL

double
nci_dtsfi( c_func, t0, s1, f2, i3 )
	SV* c_func
	char * t0
	short s1
	float f2
	int i3
PREINIT:
	double(*func)(char *, short, float, int);
CODE:
	func   = INT2PTR(double(*)(char *, short, float, int), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, f2, i3);
OUTPUT:
	RETVAL

double
nci_dtstp( c_func, t0, s1, t2, p3 )
	SV* c_func
	char * t0
	short s1
	char * t2
	void * p3
PREINIT:
	double(*func)(char *, short, char *, void *);
CODE:
	func   = INT2PTR(double(*)(char *, short, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, t2, p3);
OUTPUT:
	RETVAL

double
nci_dtstd( c_func, t0, s1, t2, d3 )
	SV* c_func
	char * t0
	short s1
	char * t2
	double d3
PREINIT:
	double(*func)(char *, short, char *, double);
CODE:
	func   = INT2PTR(double(*)(char *, short, char *, double), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, t2, d3);
OUTPUT:
	RETVAL

double
nci_dtsts( c_func, t0, s1, t2, s3 )
	SV* c_func
	char * t0
	short s1
	char * t2
	short s3
PREINIT:
	double(*func)(char *, short, char *, short);
CODE:
	func   = INT2PTR(double(*)(char *, short, char *, short), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, t2, s3);
OUTPUT:
	RETVAL

double
nci_dtstf( c_func, t0, s1, t2, f3 )
	SV* c_func
	char * t0
	short s1
	char * t2
	float f3
PREINIT:
	double(*func)(char *, short, char *, float);
CODE:
	func   = INT2PTR(double(*)(char *, short, char *, float), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, t2, f3);
OUTPUT:
	RETVAL

double
nci_dtstt( c_func, t0, s1, t2, t3 )
	SV* c_func
	char * t0
	short s1
	char * t2
	char * t3
PREINIT:
	double(*func)(char *, short, char *, char *);
CODE:
	func   = INT2PTR(double(*)(char *, short, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, t2, t3);
OUTPUT:
	RETVAL

double
nci_dtsti( c_func, t0, s1, t2, i3 )
	SV* c_func
	char * t0
	short s1
	char * t2
	int i3
PREINIT:
	double(*func)(char *, short, char *, int);
CODE:
	func   = INT2PTR(double(*)(char *, short, char *, int), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, t2, i3);
OUTPUT:
	RETVAL

double
nci_dtsip( c_func, t0, s1, i2, p3 )
	SV* c_func
	char * t0
	short s1
	int i2
	void * p3
PREINIT:
	double(*func)(char *, short, int, void *);
CODE:
	func   = INT2PTR(double(*)(char *, short, int, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, i2, p3);
OUTPUT:
	RETVAL

double
nci_dtsid( c_func, t0, s1, i2, d3 )
	SV* c_func
	char * t0
	short s1
	int i2
	double d3
PREINIT:
	double(*func)(char *, short, int, double);
CODE:
	func   = INT2PTR(double(*)(char *, short, int, double), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, i2, d3);
OUTPUT:
	RETVAL

double
nci_dtsis( c_func, t0, s1, i2, s3 )
	SV* c_func
	char * t0
	short s1
	int i2
	short s3
PREINIT:
	double(*func)(char *, short, int, short);
CODE:
	func   = INT2PTR(double(*)(char *, short, int, short), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, i2, s3);
OUTPUT:
	RETVAL

double
nci_dtsif( c_func, t0, s1, i2, f3 )
	SV* c_func
	char * t0
	short s1
	int i2
	float f3
PREINIT:
	double(*func)(char *, short, int, float);
CODE:
	func   = INT2PTR(double(*)(char *, short, int, float), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, i2, f3);
OUTPUT:
	RETVAL

double
nci_dtsit( c_func, t0, s1, i2, t3 )
	SV* c_func
	char * t0
	short s1
	int i2
	char * t3
PREINIT:
	double(*func)(char *, short, int, char *);
CODE:
	func   = INT2PTR(double(*)(char *, short, int, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, i2, t3);
OUTPUT:
	RETVAL

double
nci_dtsii( c_func, t0, s1, i2, i3 )
	SV* c_func
	char * t0
	short s1
	int i2
	int i3
PREINIT:
	double(*func)(char *, short, int, int);
CODE:
	func   = INT2PTR(double(*)(char *, short, int, int), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, i2, i3);
OUTPUT:
	RETVAL

double
nci_dtfpp( c_func, t0, f1, p2, p3 )
	SV* c_func
	char * t0
	float f1
	void * p2
	void * p3
PREINIT:
	double(*func)(char *, float, void *, void *);
CODE:
	func   = INT2PTR(double(*)(char *, float, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, p2, p3);
OUTPUT:
	RETVAL

double
nci_dtfpd( c_func, t0, f1, p2, d3 )
	SV* c_func
	char * t0
	float f1
	void * p2
	double d3
PREINIT:
	double(*func)(char *, float, void *, double);
CODE:
	func   = INT2PTR(double(*)(char *, float, void *, double), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, p2, d3);
OUTPUT:
	RETVAL

double
nci_dtfps( c_func, t0, f1, p2, s3 )
	SV* c_func
	char * t0
	float f1
	void * p2
	short s3
PREINIT:
	double(*func)(char *, float, void *, short);
CODE:
	func   = INT2PTR(double(*)(char *, float, void *, short), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, p2, s3);
OUTPUT:
	RETVAL

double
nci_dtfpf( c_func, t0, f1, p2, f3 )
	SV* c_func
	char * t0
	float f1
	void * p2
	float f3
PREINIT:
	double(*func)(char *, float, void *, float);
CODE:
	func   = INT2PTR(double(*)(char *, float, void *, float), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, p2, f3);
OUTPUT:
	RETVAL

double
nci_dtfpt( c_func, t0, f1, p2, t3 )
	SV* c_func
	char * t0
	float f1
	void * p2
	char * t3
PREINIT:
	double(*func)(char *, float, void *, char *);
CODE:
	func   = INT2PTR(double(*)(char *, float, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, p2, t3);
OUTPUT:
	RETVAL

double
nci_dtfpi( c_func, t0, f1, p2, i3 )
	SV* c_func
	char * t0
	float f1
	void * p2
	int i3
PREINIT:
	double(*func)(char *, float, void *, int);
CODE:
	func   = INT2PTR(double(*)(char *, float, void *, int), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, p2, i3);
OUTPUT:
	RETVAL

double
nci_dtfdp( c_func, t0, f1, d2, p3 )
	SV* c_func
	char * t0
	float f1
	double d2
	void * p3
PREINIT:
	double(*func)(char *, float, double, void *);
CODE:
	func   = INT2PTR(double(*)(char *, float, double, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, d2, p3);
OUTPUT:
	RETVAL

double
nci_dtfdd( c_func, t0, f1, d2, d3 )
	SV* c_func
	char * t0
	float f1
	double d2
	double d3
PREINIT:
	double(*func)(char *, float, double, double);
CODE:
	func   = INT2PTR(double(*)(char *, float, double, double), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, d2, d3);
OUTPUT:
	RETVAL

double
nci_dtfds( c_func, t0, f1, d2, s3 )
	SV* c_func
	char * t0
	float f1
	double d2
	short s3
PREINIT:
	double(*func)(char *, float, double, short);
CODE:
	func   = INT2PTR(double(*)(char *, float, double, short), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, d2, s3);
OUTPUT:
	RETVAL

double
nci_dtfdf( c_func, t0, f1, d2, f3 )
	SV* c_func
	char * t0
	float f1
	double d2
	float f3
PREINIT:
	double(*func)(char *, float, double, float);
CODE:
	func   = INT2PTR(double(*)(char *, float, double, float), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, d2, f3);
OUTPUT:
	RETVAL

double
nci_dtfdt( c_func, t0, f1, d2, t3 )
	SV* c_func
	char * t0
	float f1
	double d2
	char * t3
PREINIT:
	double(*func)(char *, float, double, char *);
CODE:
	func   = INT2PTR(double(*)(char *, float, double, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, d2, t3);
OUTPUT:
	RETVAL

double
nci_dtfdi( c_func, t0, f1, d2, i3 )
	SV* c_func
	char * t0
	float f1
	double d2
	int i3
PREINIT:
	double(*func)(char *, float, double, int);
CODE:
	func   = INT2PTR(double(*)(char *, float, double, int), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, d2, i3);
OUTPUT:
	RETVAL

double
nci_dtfsp( c_func, t0, f1, s2, p3 )
	SV* c_func
	char * t0
	float f1
	short s2
	void * p3
PREINIT:
	double(*func)(char *, float, short, void *);
CODE:
	func   = INT2PTR(double(*)(char *, float, short, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, s2, p3);
OUTPUT:
	RETVAL

double
nci_dtfsd( c_func, t0, f1, s2, d3 )
	SV* c_func
	char * t0
	float f1
	short s2
	double d3
PREINIT:
	double(*func)(char *, float, short, double);
CODE:
	func   = INT2PTR(double(*)(char *, float, short, double), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, s2, d3);
OUTPUT:
	RETVAL

double
nci_dtfss( c_func, t0, f1, s2, s3 )
	SV* c_func
	char * t0
	float f1
	short s2
	short s3
PREINIT:
	double(*func)(char *, float, short, short);
CODE:
	func   = INT2PTR(double(*)(char *, float, short, short), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, s2, s3);
OUTPUT:
	RETVAL

double
nci_dtfsf( c_func, t0, f1, s2, f3 )
	SV* c_func
	char * t0
	float f1
	short s2
	float f3
PREINIT:
	double(*func)(char *, float, short, float);
CODE:
	func   = INT2PTR(double(*)(char *, float, short, float), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, s2, f3);
OUTPUT:
	RETVAL

double
nci_dtfst( c_func, t0, f1, s2, t3 )
	SV* c_func
	char * t0
	float f1
	short s2
	char * t3
PREINIT:
	double(*func)(char *, float, short, char *);
CODE:
	func   = INT2PTR(double(*)(char *, float, short, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, s2, t3);
OUTPUT:
	RETVAL

double
nci_dtfsi( c_func, t0, f1, s2, i3 )
	SV* c_func
	char * t0
	float f1
	short s2
	int i3
PREINIT:
	double(*func)(char *, float, short, int);
CODE:
	func   = INT2PTR(double(*)(char *, float, short, int), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, s2, i3);
OUTPUT:
	RETVAL

double
nci_dtffp( c_func, t0, f1, f2, p3 )
	SV* c_func
	char * t0
	float f1
	float f2
	void * p3
PREINIT:
	double(*func)(char *, float, float, void *);
CODE:
	func   = INT2PTR(double(*)(char *, float, float, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, f2, p3);
OUTPUT:
	RETVAL

double
nci_dtffd( c_func, t0, f1, f2, d3 )
	SV* c_func
	char * t0
	float f1
	float f2
	double d3
PREINIT:
	double(*func)(char *, float, float, double);
CODE:
	func   = INT2PTR(double(*)(char *, float, float, double), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, f2, d3);
OUTPUT:
	RETVAL

double
nci_dtffs( c_func, t0, f1, f2, s3 )
	SV* c_func
	char * t0
	float f1
	float f2
	short s3
PREINIT:
	double(*func)(char *, float, float, short);
CODE:
	func   = INT2PTR(double(*)(char *, float, float, short), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, f2, s3);
OUTPUT:
	RETVAL

double
nci_dtfff( c_func, t0, f1, f2, f3 )
	SV* c_func
	char * t0
	float f1
	float f2
	float f3
PREINIT:
	double(*func)(char *, float, float, float);
CODE:
	func   = INT2PTR(double(*)(char *, float, float, float), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, f2, f3);
OUTPUT:
	RETVAL

double
nci_dtfft( c_func, t0, f1, f2, t3 )
	SV* c_func
	char * t0
	float f1
	float f2
	char * t3
PREINIT:
	double(*func)(char *, float, float, char *);
CODE:
	func   = INT2PTR(double(*)(char *, float, float, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, f2, t3);
OUTPUT:
	RETVAL

double
nci_dtffi( c_func, t0, f1, f2, i3 )
	SV* c_func
	char * t0
	float f1
	float f2
	int i3
PREINIT:
	double(*func)(char *, float, float, int);
CODE:
	func   = INT2PTR(double(*)(char *, float, float, int), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, f2, i3);
OUTPUT:
	RETVAL

double
nci_dtftp( c_func, t0, f1, t2, p3 )
	SV* c_func
	char * t0
	float f1
	char * t2
	void * p3
PREINIT:
	double(*func)(char *, float, char *, void *);
CODE:
	func   = INT2PTR(double(*)(char *, float, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, t2, p3);
OUTPUT:
	RETVAL

double
nci_dtftd( c_func, t0, f1, t2, d3 )
	SV* c_func
	char * t0
	float f1
	char * t2
	double d3
PREINIT:
	double(*func)(char *, float, char *, double);
CODE:
	func   = INT2PTR(double(*)(char *, float, char *, double), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, t2, d3);
OUTPUT:
	RETVAL

double
nci_dtfts( c_func, t0, f1, t2, s3 )
	SV* c_func
	char * t0
	float f1
	char * t2
	short s3
PREINIT:
	double(*func)(char *, float, char *, short);
CODE:
	func   = INT2PTR(double(*)(char *, float, char *, short), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, t2, s3);
OUTPUT:
	RETVAL

double
nci_dtftf( c_func, t0, f1, t2, f3 )
	SV* c_func
	char * t0
	float f1
	char * t2
	float f3
PREINIT:
	double(*func)(char *, float, char *, float);
CODE:
	func   = INT2PTR(double(*)(char *, float, char *, float), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, t2, f3);
OUTPUT:
	RETVAL

double
nci_dtftt( c_func, t0, f1, t2, t3 )
	SV* c_func
	char * t0
	float f1
	char * t2
	char * t3
PREINIT:
	double(*func)(char *, float, char *, char *);
CODE:
	func   = INT2PTR(double(*)(char *, float, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, t2, t3);
OUTPUT:
	RETVAL

double
nci_dtfti( c_func, t0, f1, t2, i3 )
	SV* c_func
	char * t0
	float f1
	char * t2
	int i3
PREINIT:
	double(*func)(char *, float, char *, int);
CODE:
	func   = INT2PTR(double(*)(char *, float, char *, int), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, t2, i3);
OUTPUT:
	RETVAL

double
nci_dtfip( c_func, t0, f1, i2, p3 )
	SV* c_func
	char * t0
	float f1
	int i2
	void * p3
PREINIT:
	double(*func)(char *, float, int, void *);
CODE:
	func   = INT2PTR(double(*)(char *, float, int, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, i2, p3);
OUTPUT:
	RETVAL

double
nci_dtfid( c_func, t0, f1, i2, d3 )
	SV* c_func
	char * t0
	float f1
	int i2
	double d3
PREINIT:
	double(*func)(char *, float, int, double);
CODE:
	func   = INT2PTR(double(*)(char *, float, int, double), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, i2, d3);
OUTPUT:
	RETVAL

double
nci_dtfis( c_func, t0, f1, i2, s3 )
	SV* c_func
	char * t0
	float f1
	int i2
	short s3
PREINIT:
	double(*func)(char *, float, int, short);
CODE:
	func   = INT2PTR(double(*)(char *, float, int, short), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, i2, s3);
OUTPUT:
	RETVAL

double
nci_dtfif( c_func, t0, f1, i2, f3 )
	SV* c_func
	char * t0
	float f1
	int i2
	float f3
PREINIT:
	double(*func)(char *, float, int, float);
CODE:
	func   = INT2PTR(double(*)(char *, float, int, float), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, i2, f3);
OUTPUT:
	RETVAL

double
nci_dtfit( c_func, t0, f1, i2, t3 )
	SV* c_func
	char * t0
	float f1
	int i2
	char * t3
PREINIT:
	double(*func)(char *, float, int, char *);
CODE:
	func   = INT2PTR(double(*)(char *, float, int, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, i2, t3);
OUTPUT:
	RETVAL

double
nci_dtfii( c_func, t0, f1, i2, i3 )
	SV* c_func
	char * t0
	float f1
	int i2
	int i3
PREINIT:
	double(*func)(char *, float, int, int);
CODE:
	func   = INT2PTR(double(*)(char *, float, int, int), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, i2, i3);
OUTPUT:
	RETVAL

double
nci_dttpp( c_func, t0, t1, p2, p3 )
	SV* c_func
	char * t0
	char * t1
	void * p2
	void * p3
PREINIT:
	double(*func)(char *, char *, void *, void *);
CODE:
	func   = INT2PTR(double(*)(char *, char *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, p2, p3);
OUTPUT:
	RETVAL

double
nci_dttpd( c_func, t0, t1, p2, d3 )
	SV* c_func
	char * t0
	char * t1
	void * p2
	double d3
PREINIT:
	double(*func)(char *, char *, void *, double);
CODE:
	func   = INT2PTR(double(*)(char *, char *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, p2, d3);
OUTPUT:
	RETVAL

double
nci_dttps( c_func, t0, t1, p2, s3 )
	SV* c_func
	char * t0
	char * t1
	void * p2
	short s3
PREINIT:
	double(*func)(char *, char *, void *, short);
CODE:
	func   = INT2PTR(double(*)(char *, char *, void *, short), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, p2, s3);
OUTPUT:
	RETVAL

double
nci_dttpf( c_func, t0, t1, p2, f3 )
	SV* c_func
	char * t0
	char * t1
	void * p2
	float f3
PREINIT:
	double(*func)(char *, char *, void *, float);
CODE:
	func   = INT2PTR(double(*)(char *, char *, void *, float), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, p2, f3);
OUTPUT:
	RETVAL

double
nci_dttpt( c_func, t0, t1, p2, t3 )
	SV* c_func
	char * t0
	char * t1
	void * p2
	char * t3
PREINIT:
	double(*func)(char *, char *, void *, char *);
CODE:
	func   = INT2PTR(double(*)(char *, char *, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, p2, t3);
OUTPUT:
	RETVAL

double
nci_dttpi( c_func, t0, t1, p2, i3 )
	SV* c_func
	char * t0
	char * t1
	void * p2
	int i3
PREINIT:
	double(*func)(char *, char *, void *, int);
CODE:
	func   = INT2PTR(double(*)(char *, char *, void *, int), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, p2, i3);
OUTPUT:
	RETVAL

double
nci_dttdp( c_func, t0, t1, d2, p3 )
	SV* c_func
	char * t0
	char * t1
	double d2
	void * p3
PREINIT:
	double(*func)(char *, char *, double, void *);
CODE:
	func   = INT2PTR(double(*)(char *, char *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, d2, p3);
OUTPUT:
	RETVAL

double
nci_dttdd( c_func, t0, t1, d2, d3 )
	SV* c_func
	char * t0
	char * t1
	double d2
	double d3
PREINIT:
	double(*func)(char *, char *, double, double);
CODE:
	func   = INT2PTR(double(*)(char *, char *, double, double), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, d2, d3);
OUTPUT:
	RETVAL

double
nci_dttds( c_func, t0, t1, d2, s3 )
	SV* c_func
	char * t0
	char * t1
	double d2
	short s3
PREINIT:
	double(*func)(char *, char *, double, short);
CODE:
	func   = INT2PTR(double(*)(char *, char *, double, short), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, d2, s3);
OUTPUT:
	RETVAL

double
nci_dttdf( c_func, t0, t1, d2, f3 )
	SV* c_func
	char * t0
	char * t1
	double d2
	float f3
PREINIT:
	double(*func)(char *, char *, double, float);
CODE:
	func   = INT2PTR(double(*)(char *, char *, double, float), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, d2, f3);
OUTPUT:
	RETVAL

double
nci_dttdt( c_func, t0, t1, d2, t3 )
	SV* c_func
	char * t0
	char * t1
	double d2
	char * t3
PREINIT:
	double(*func)(char *, char *, double, char *);
CODE:
	func   = INT2PTR(double(*)(char *, char *, double, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, d2, t3);
OUTPUT:
	RETVAL

double
nci_dttdi( c_func, t0, t1, d2, i3 )
	SV* c_func
	char * t0
	char * t1
	double d2
	int i3
PREINIT:
	double(*func)(char *, char *, double, int);
CODE:
	func   = INT2PTR(double(*)(char *, char *, double, int), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, d2, i3);
OUTPUT:
	RETVAL

double
nci_dttsp( c_func, t0, t1, s2, p3 )
	SV* c_func
	char * t0
	char * t1
	short s2
	void * p3
PREINIT:
	double(*func)(char *, char *, short, void *);
CODE:
	func   = INT2PTR(double(*)(char *, char *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, s2, p3);
OUTPUT:
	RETVAL

double
nci_dttsd( c_func, t0, t1, s2, d3 )
	SV* c_func
	char * t0
	char * t1
	short s2
	double d3
PREINIT:
	double(*func)(char *, char *, short, double);
CODE:
	func   = INT2PTR(double(*)(char *, char *, short, double), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, s2, d3);
OUTPUT:
	RETVAL

double
nci_dttss( c_func, t0, t1, s2, s3 )
	SV* c_func
	char * t0
	char * t1
	short s2
	short s3
PREINIT:
	double(*func)(char *, char *, short, short);
CODE:
	func   = INT2PTR(double(*)(char *, char *, short, short), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, s2, s3);
OUTPUT:
	RETVAL

double
nci_dttsf( c_func, t0, t1, s2, f3 )
	SV* c_func
	char * t0
	char * t1
	short s2
	float f3
PREINIT:
	double(*func)(char *, char *, short, float);
CODE:
	func   = INT2PTR(double(*)(char *, char *, short, float), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, s2, f3);
OUTPUT:
	RETVAL

double
nci_dttst( c_func, t0, t1, s2, t3 )
	SV* c_func
	char * t0
	char * t1
	short s2
	char * t3
PREINIT:
	double(*func)(char *, char *, short, char *);
CODE:
	func   = INT2PTR(double(*)(char *, char *, short, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, s2, t3);
OUTPUT:
	RETVAL

double
nci_dttsi( c_func, t0, t1, s2, i3 )
	SV* c_func
	char * t0
	char * t1
	short s2
	int i3
PREINIT:
	double(*func)(char *, char *, short, int);
CODE:
	func   = INT2PTR(double(*)(char *, char *, short, int), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, s2, i3);
OUTPUT:
	RETVAL

double
nci_dttfp( c_func, t0, t1, f2, p3 )
	SV* c_func
	char * t0
	char * t1
	float f2
	void * p3
PREINIT:
	double(*func)(char *, char *, float, void *);
CODE:
	func   = INT2PTR(double(*)(char *, char *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, f2, p3);
OUTPUT:
	RETVAL

double
nci_dttfd( c_func, t0, t1, f2, d3 )
	SV* c_func
	char * t0
	char * t1
	float f2
	double d3
PREINIT:
	double(*func)(char *, char *, float, double);
CODE:
	func   = INT2PTR(double(*)(char *, char *, float, double), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, f2, d3);
OUTPUT:
	RETVAL

double
nci_dttfs( c_func, t0, t1, f2, s3 )
	SV* c_func
	char * t0
	char * t1
	float f2
	short s3
PREINIT:
	double(*func)(char *, char *, float, short);
CODE:
	func   = INT2PTR(double(*)(char *, char *, float, short), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, f2, s3);
OUTPUT:
	RETVAL

double
nci_dttff( c_func, t0, t1, f2, f3 )
	SV* c_func
	char * t0
	char * t1
	float f2
	float f3
PREINIT:
	double(*func)(char *, char *, float, float);
CODE:
	func   = INT2PTR(double(*)(char *, char *, float, float), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, f2, f3);
OUTPUT:
	RETVAL

double
nci_dttft( c_func, t0, t1, f2, t3 )
	SV* c_func
	char * t0
	char * t1
	float f2
	char * t3
PREINIT:
	double(*func)(char *, char *, float, char *);
CODE:
	func   = INT2PTR(double(*)(char *, char *, float, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, f2, t3);
OUTPUT:
	RETVAL

double
nci_dttfi( c_func, t0, t1, f2, i3 )
	SV* c_func
	char * t0
	char * t1
	float f2
	int i3
PREINIT:
	double(*func)(char *, char *, float, int);
CODE:
	func   = INT2PTR(double(*)(char *, char *, float, int), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, f2, i3);
OUTPUT:
	RETVAL

double
nci_dtttp( c_func, t0, t1, t2, p3 )
	SV* c_func
	char * t0
	char * t1
	char * t2
	void * p3
PREINIT:
	double(*func)(char *, char *, char *, void *);
CODE:
	func   = INT2PTR(double(*)(char *, char *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, t2, p3);
OUTPUT:
	RETVAL

double
nci_dtttd( c_func, t0, t1, t2, d3 )
	SV* c_func
	char * t0
	char * t1
	char * t2
	double d3
PREINIT:
	double(*func)(char *, char *, char *, double);
CODE:
	func   = INT2PTR(double(*)(char *, char *, char *, double), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, t2, d3);
OUTPUT:
	RETVAL

double
nci_dttts( c_func, t0, t1, t2, s3 )
	SV* c_func
	char * t0
	char * t1
	char * t2
	short s3
PREINIT:
	double(*func)(char *, char *, char *, short);
CODE:
	func   = INT2PTR(double(*)(char *, char *, char *, short), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, t2, s3);
OUTPUT:
	RETVAL

double
nci_dtttf( c_func, t0, t1, t2, f3 )
	SV* c_func
	char * t0
	char * t1
	char * t2
	float f3
PREINIT:
	double(*func)(char *, char *, char *, float);
CODE:
	func   = INT2PTR(double(*)(char *, char *, char *, float), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, t2, f3);
OUTPUT:
	RETVAL

double
nci_dtttt( c_func, t0, t1, t2, t3 )
	SV* c_func
	char * t0
	char * t1
	char * t2
	char * t3
PREINIT:
	double(*func)(char *, char *, char *, char *);
CODE:
	func   = INT2PTR(double(*)(char *, char *, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, t2, t3);
OUTPUT:
	RETVAL

double
nci_dttti( c_func, t0, t1, t2, i3 )
	SV* c_func
	char * t0
	char * t1
	char * t2
	int i3
PREINIT:
	double(*func)(char *, char *, char *, int);
CODE:
	func   = INT2PTR(double(*)(char *, char *, char *, int), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, t2, i3);
OUTPUT:
	RETVAL

double
nci_dttip( c_func, t0, t1, i2, p3 )
	SV* c_func
	char * t0
	char * t1
	int i2
	void * p3
PREINIT:
	double(*func)(char *, char *, int, void *);
CODE:
	func   = INT2PTR(double(*)(char *, char *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, i2, p3);
OUTPUT:
	RETVAL

double
nci_dttid( c_func, t0, t1, i2, d3 )
	SV* c_func
	char * t0
	char * t1
	int i2
	double d3
PREINIT:
	double(*func)(char *, char *, int, double);
CODE:
	func   = INT2PTR(double(*)(char *, char *, int, double), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, i2, d3);
OUTPUT:
	RETVAL

double
nci_dttis( c_func, t0, t1, i2, s3 )
	SV* c_func
	char * t0
	char * t1
	int i2
	short s3
PREINIT:
	double(*func)(char *, char *, int, short);
CODE:
	func   = INT2PTR(double(*)(char *, char *, int, short), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, i2, s3);
OUTPUT:
	RETVAL

double
nci_dttif( c_func, t0, t1, i2, f3 )
	SV* c_func
	char * t0
	char * t1
	int i2
	float f3
PREINIT:
	double(*func)(char *, char *, int, float);
CODE:
	func   = INT2PTR(double(*)(char *, char *, int, float), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, i2, f3);
OUTPUT:
	RETVAL

double
nci_dttit( c_func, t0, t1, i2, t3 )
	SV* c_func
	char * t0
	char * t1
	int i2
	char * t3
PREINIT:
	double(*func)(char *, char *, int, char *);
CODE:
	func   = INT2PTR(double(*)(char *, char *, int, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, i2, t3);
OUTPUT:
	RETVAL

double
nci_dttii( c_func, t0, t1, i2, i3 )
	SV* c_func
	char * t0
	char * t1
	int i2
	int i3
PREINIT:
	double(*func)(char *, char *, int, int);
CODE:
	func   = INT2PTR(double(*)(char *, char *, int, int), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, i2, i3);
OUTPUT:
	RETVAL

double
nci_dtipp( c_func, t0, i1, p2, p3 )
	SV* c_func
	char * t0
	int i1
	void * p2
	void * p3
PREINIT:
	double(*func)(char *, int, void *, void *);
CODE:
	func   = INT2PTR(double(*)(char *, int, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, p2, p3);
OUTPUT:
	RETVAL

double
nci_dtipd( c_func, t0, i1, p2, d3 )
	SV* c_func
	char * t0
	int i1
	void * p2
	double d3
PREINIT:
	double(*func)(char *, int, void *, double);
CODE:
	func   = INT2PTR(double(*)(char *, int, void *, double), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, p2, d3);
OUTPUT:
	RETVAL

double
nci_dtips( c_func, t0, i1, p2, s3 )
	SV* c_func
	char * t0
	int i1
	void * p2
	short s3
PREINIT:
	double(*func)(char *, int, void *, short);
CODE:
	func   = INT2PTR(double(*)(char *, int, void *, short), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, p2, s3);
OUTPUT:
	RETVAL

double
nci_dtipf( c_func, t0, i1, p2, f3 )
	SV* c_func
	char * t0
	int i1
	void * p2
	float f3
PREINIT:
	double(*func)(char *, int, void *, float);
CODE:
	func   = INT2PTR(double(*)(char *, int, void *, float), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, p2, f3);
OUTPUT:
	RETVAL

double
nci_dtipt( c_func, t0, i1, p2, t3 )
	SV* c_func
	char * t0
	int i1
	void * p2
	char * t3
PREINIT:
	double(*func)(char *, int, void *, char *);
CODE:
	func   = INT2PTR(double(*)(char *, int, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, p2, t3);
OUTPUT:
	RETVAL

double
nci_dtipi( c_func, t0, i1, p2, i3 )
	SV* c_func
	char * t0
	int i1
	void * p2
	int i3
PREINIT:
	double(*func)(char *, int, void *, int);
CODE:
	func   = INT2PTR(double(*)(char *, int, void *, int), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, p2, i3);
OUTPUT:
	RETVAL

double
nci_dtidp( c_func, t0, i1, d2, p3 )
	SV* c_func
	char * t0
	int i1
	double d2
	void * p3
PREINIT:
	double(*func)(char *, int, double, void *);
CODE:
	func   = INT2PTR(double(*)(char *, int, double, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, d2, p3);
OUTPUT:
	RETVAL

double
nci_dtidd( c_func, t0, i1, d2, d3 )
	SV* c_func
	char * t0
	int i1
	double d2
	double d3
PREINIT:
	double(*func)(char *, int, double, double);
CODE:
	func   = INT2PTR(double(*)(char *, int, double, double), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, d2, d3);
OUTPUT:
	RETVAL

double
nci_dtids( c_func, t0, i1, d2, s3 )
	SV* c_func
	char * t0
	int i1
	double d2
	short s3
PREINIT:
	double(*func)(char *, int, double, short);
CODE:
	func   = INT2PTR(double(*)(char *, int, double, short), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, d2, s3);
OUTPUT:
	RETVAL

double
nci_dtidf( c_func, t0, i1, d2, f3 )
	SV* c_func
	char * t0
	int i1
	double d2
	float f3
PREINIT:
	double(*func)(char *, int, double, float);
CODE:
	func   = INT2PTR(double(*)(char *, int, double, float), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, d2, f3);
OUTPUT:
	RETVAL

double
nci_dtidt( c_func, t0, i1, d2, t3 )
	SV* c_func
	char * t0
	int i1
	double d2
	char * t3
PREINIT:
	double(*func)(char *, int, double, char *);
CODE:
	func   = INT2PTR(double(*)(char *, int, double, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, d2, t3);
OUTPUT:
	RETVAL

double
nci_dtidi( c_func, t0, i1, d2, i3 )
	SV* c_func
	char * t0
	int i1
	double d2
	int i3
PREINIT:
	double(*func)(char *, int, double, int);
CODE:
	func   = INT2PTR(double(*)(char *, int, double, int), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, d2, i3);
OUTPUT:
	RETVAL

double
nci_dtisp( c_func, t0, i1, s2, p3 )
	SV* c_func
	char * t0
	int i1
	short s2
	void * p3
PREINIT:
	double(*func)(char *, int, short, void *);
CODE:
	func   = INT2PTR(double(*)(char *, int, short, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, s2, p3);
OUTPUT:
	RETVAL

double
nci_dtisd( c_func, t0, i1, s2, d3 )
	SV* c_func
	char * t0
	int i1
	short s2
	double d3
PREINIT:
	double(*func)(char *, int, short, double);
CODE:
	func   = INT2PTR(double(*)(char *, int, short, double), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, s2, d3);
OUTPUT:
	RETVAL

double
nci_dtiss( c_func, t0, i1, s2, s3 )
	SV* c_func
	char * t0
	int i1
	short s2
	short s3
PREINIT:
	double(*func)(char *, int, short, short);
CODE:
	func   = INT2PTR(double(*)(char *, int, short, short), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, s2, s3);
OUTPUT:
	RETVAL

double
nci_dtisf( c_func, t0, i1, s2, f3 )
	SV* c_func
	char * t0
	int i1
	short s2
	float f3
PREINIT:
	double(*func)(char *, int, short, float);
CODE:
	func   = INT2PTR(double(*)(char *, int, short, float), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, s2, f3);
OUTPUT:
	RETVAL

double
nci_dtist( c_func, t0, i1, s2, t3 )
	SV* c_func
	char * t0
	int i1
	short s2
	char * t3
PREINIT:
	double(*func)(char *, int, short, char *);
CODE:
	func   = INT2PTR(double(*)(char *, int, short, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, s2, t3);
OUTPUT:
	RETVAL

double
nci_dtisi( c_func, t0, i1, s2, i3 )
	SV* c_func
	char * t0
	int i1
	short s2
	int i3
PREINIT:
	double(*func)(char *, int, short, int);
CODE:
	func   = INT2PTR(double(*)(char *, int, short, int), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, s2, i3);
OUTPUT:
	RETVAL

double
nci_dtifp( c_func, t0, i1, f2, p3 )
	SV* c_func
	char * t0
	int i1
	float f2
	void * p3
PREINIT:
	double(*func)(char *, int, float, void *);
CODE:
	func   = INT2PTR(double(*)(char *, int, float, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, f2, p3);
OUTPUT:
	RETVAL

double
nci_dtifd( c_func, t0, i1, f2, d3 )
	SV* c_func
	char * t0
	int i1
	float f2
	double d3
PREINIT:
	double(*func)(char *, int, float, double);
CODE:
	func   = INT2PTR(double(*)(char *, int, float, double), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, f2, d3);
OUTPUT:
	RETVAL

double
nci_dtifs( c_func, t0, i1, f2, s3 )
	SV* c_func
	char * t0
	int i1
	float f2
	short s3
PREINIT:
	double(*func)(char *, int, float, short);
CODE:
	func   = INT2PTR(double(*)(char *, int, float, short), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, f2, s3);
OUTPUT:
	RETVAL

double
nci_dtiff( c_func, t0, i1, f2, f3 )
	SV* c_func
	char * t0
	int i1
	float f2
	float f3
PREINIT:
	double(*func)(char *, int, float, float);
CODE:
	func   = INT2PTR(double(*)(char *, int, float, float), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, f2, f3);
OUTPUT:
	RETVAL

double
nci_dtift( c_func, t0, i1, f2, t3 )
	SV* c_func
	char * t0
	int i1
	float f2
	char * t3
PREINIT:
	double(*func)(char *, int, float, char *);
CODE:
	func   = INT2PTR(double(*)(char *, int, float, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, f2, t3);
OUTPUT:
	RETVAL

double
nci_dtifi( c_func, t0, i1, f2, i3 )
	SV* c_func
	char * t0
	int i1
	float f2
	int i3
PREINIT:
	double(*func)(char *, int, float, int);
CODE:
	func   = INT2PTR(double(*)(char *, int, float, int), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, f2, i3);
OUTPUT:
	RETVAL

double
nci_dtitp( c_func, t0, i1, t2, p3 )
	SV* c_func
	char * t0
	int i1
	char * t2
	void * p3
PREINIT:
	double(*func)(char *, int, char *, void *);
CODE:
	func   = INT2PTR(double(*)(char *, int, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, t2, p3);
OUTPUT:
	RETVAL

double
nci_dtitd( c_func, t0, i1, t2, d3 )
	SV* c_func
	char * t0
	int i1
	char * t2
	double d3
PREINIT:
	double(*func)(char *, int, char *, double);
CODE:
	func   = INT2PTR(double(*)(char *, int, char *, double), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, t2, d3);
OUTPUT:
	RETVAL

double
nci_dtits( c_func, t0, i1, t2, s3 )
	SV* c_func
	char * t0
	int i1
	char * t2
	short s3
PREINIT:
	double(*func)(char *, int, char *, short);
CODE:
	func   = INT2PTR(double(*)(char *, int, char *, short), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, t2, s3);
OUTPUT:
	RETVAL

double
nci_dtitf( c_func, t0, i1, t2, f3 )
	SV* c_func
	char * t0
	int i1
	char * t2
	float f3
PREINIT:
	double(*func)(char *, int, char *, float);
CODE:
	func   = INT2PTR(double(*)(char *, int, char *, float), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, t2, f3);
OUTPUT:
	RETVAL

double
nci_dtitt( c_func, t0, i1, t2, t3 )
	SV* c_func
	char * t0
	int i1
	char * t2
	char * t3
PREINIT:
	double(*func)(char *, int, char *, char *);
CODE:
	func   = INT2PTR(double(*)(char *, int, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, t2, t3);
OUTPUT:
	RETVAL

double
nci_dtiti( c_func, t0, i1, t2, i3 )
	SV* c_func
	char * t0
	int i1
	char * t2
	int i3
PREINIT:
	double(*func)(char *, int, char *, int);
CODE:
	func   = INT2PTR(double(*)(char *, int, char *, int), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, t2, i3);
OUTPUT:
	RETVAL

double
nci_dtiip( c_func, t0, i1, i2, p3 )
	SV* c_func
	char * t0
	int i1
	int i2
	void * p3
PREINIT:
	double(*func)(char *, int, int, void *);
CODE:
	func   = INT2PTR(double(*)(char *, int, int, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, i2, p3);
OUTPUT:
	RETVAL

double
nci_dtiid( c_func, t0, i1, i2, d3 )
	SV* c_func
	char * t0
	int i1
	int i2
	double d3
PREINIT:
	double(*func)(char *, int, int, double);
CODE:
	func   = INT2PTR(double(*)(char *, int, int, double), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, i2, d3);
OUTPUT:
	RETVAL

double
nci_dtiis( c_func, t0, i1, i2, s3 )
	SV* c_func
	char * t0
	int i1
	int i2
	short s3
PREINIT:
	double(*func)(char *, int, int, short);
CODE:
	func   = INT2PTR(double(*)(char *, int, int, short), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, i2, s3);
OUTPUT:
	RETVAL

double
nci_dtiif( c_func, t0, i1, i2, f3 )
	SV* c_func
	char * t0
	int i1
	int i2
	float f3
PREINIT:
	double(*func)(char *, int, int, float);
CODE:
	func   = INT2PTR(double(*)(char *, int, int, float), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, i2, f3);
OUTPUT:
	RETVAL

double
nci_dtiit( c_func, t0, i1, i2, t3 )
	SV* c_func
	char * t0
	int i1
	int i2
	char * t3
PREINIT:
	double(*func)(char *, int, int, char *);
CODE:
	func   = INT2PTR(double(*)(char *, int, int, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, i2, t3);
OUTPUT:
	RETVAL

double
nci_dtiii( c_func, t0, i1, i2, i3 )
	SV* c_func
	char * t0
	int i1
	int i2
	int i3
PREINIT:
	double(*func)(char *, int, int, int);
CODE:
	func   = INT2PTR(double(*)(char *, int, int, int), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, i2, i3);
OUTPUT:
	RETVAL

double
nci_dippp( c_func, i0, p1, p2, p3 )
	SV* c_func
	int i0
	void * p1
	void * p2
	void * p3
PREINIT:
	double(*func)(int, void *, void *, void *);
CODE:
	func   = INT2PTR(double(*)(int, void *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, p2, p3);
OUTPUT:
	RETVAL

double
nci_dippd( c_func, i0, p1, p2, d3 )
	SV* c_func
	int i0
	void * p1
	void * p2
	double d3
PREINIT:
	double(*func)(int, void *, void *, double);
CODE:
	func   = INT2PTR(double(*)(int, void *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, p2, d3);
OUTPUT:
	RETVAL

double
nci_dipps( c_func, i0, p1, p2, s3 )
	SV* c_func
	int i0
	void * p1
	void * p2
	short s3
PREINIT:
	double(*func)(int, void *, void *, short);
CODE:
	func   = INT2PTR(double(*)(int, void *, void *, short), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, p2, s3);
OUTPUT:
	RETVAL

double
nci_dippf( c_func, i0, p1, p2, f3 )
	SV* c_func
	int i0
	void * p1
	void * p2
	float f3
PREINIT:
	double(*func)(int, void *, void *, float);
CODE:
	func   = INT2PTR(double(*)(int, void *, void *, float), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, p2, f3);
OUTPUT:
	RETVAL

double
nci_dippt( c_func, i0, p1, p2, t3 )
	SV* c_func
	int i0
	void * p1
	void * p2
	char * t3
PREINIT:
	double(*func)(int, void *, void *, char *);
CODE:
	func   = INT2PTR(double(*)(int, void *, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, p2, t3);
OUTPUT:
	RETVAL

double
nci_dippi( c_func, i0, p1, p2, i3 )
	SV* c_func
	int i0
	void * p1
	void * p2
	int i3
PREINIT:
	double(*func)(int, void *, void *, int);
CODE:
	func   = INT2PTR(double(*)(int, void *, void *, int), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, p2, i3);
OUTPUT:
	RETVAL

double
nci_dipdp( c_func, i0, p1, d2, p3 )
	SV* c_func
	int i0
	void * p1
	double d2
	void * p3
PREINIT:
	double(*func)(int, void *, double, void *);
CODE:
	func   = INT2PTR(double(*)(int, void *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, d2, p3);
OUTPUT:
	RETVAL

double
nci_dipdd( c_func, i0, p1, d2, d3 )
	SV* c_func
	int i0
	void * p1
	double d2
	double d3
PREINIT:
	double(*func)(int, void *, double, double);
CODE:
	func   = INT2PTR(double(*)(int, void *, double, double), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, d2, d3);
OUTPUT:
	RETVAL

double
nci_dipds( c_func, i0, p1, d2, s3 )
	SV* c_func
	int i0
	void * p1
	double d2
	short s3
PREINIT:
	double(*func)(int, void *, double, short);
CODE:
	func   = INT2PTR(double(*)(int, void *, double, short), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, d2, s3);
OUTPUT:
	RETVAL

double
nci_dipdf( c_func, i0, p1, d2, f3 )
	SV* c_func
	int i0
	void * p1
	double d2
	float f3
PREINIT:
	double(*func)(int, void *, double, float);
CODE:
	func   = INT2PTR(double(*)(int, void *, double, float), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, d2, f3);
OUTPUT:
	RETVAL

double
nci_dipdt( c_func, i0, p1, d2, t3 )
	SV* c_func
	int i0
	void * p1
	double d2
	char * t3
PREINIT:
	double(*func)(int, void *, double, char *);
CODE:
	func   = INT2PTR(double(*)(int, void *, double, char *), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, d2, t3);
OUTPUT:
	RETVAL

double
nci_dipdi( c_func, i0, p1, d2, i3 )
	SV* c_func
	int i0
	void * p1
	double d2
	int i3
PREINIT:
	double(*func)(int, void *, double, int);
CODE:
	func   = INT2PTR(double(*)(int, void *, double, int), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, d2, i3);
OUTPUT:
	RETVAL

double
nci_dipsp( c_func, i0, p1, s2, p3 )
	SV* c_func
	int i0
	void * p1
	short s2
	void * p3
PREINIT:
	double(*func)(int, void *, short, void *);
CODE:
	func   = INT2PTR(double(*)(int, void *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, s2, p3);
OUTPUT:
	RETVAL

double
nci_dipsd( c_func, i0, p1, s2, d3 )
	SV* c_func
	int i0
	void * p1
	short s2
	double d3
PREINIT:
	double(*func)(int, void *, short, double);
CODE:
	func   = INT2PTR(double(*)(int, void *, short, double), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, s2, d3);
OUTPUT:
	RETVAL

double
nci_dipss( c_func, i0, p1, s2, s3 )
	SV* c_func
	int i0
	void * p1
	short s2
	short s3
PREINIT:
	double(*func)(int, void *, short, short);
CODE:
	func   = INT2PTR(double(*)(int, void *, short, short), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, s2, s3);
OUTPUT:
	RETVAL

double
nci_dipsf( c_func, i0, p1, s2, f3 )
	SV* c_func
	int i0
	void * p1
	short s2
	float f3
PREINIT:
	double(*func)(int, void *, short, float);
CODE:
	func   = INT2PTR(double(*)(int, void *, short, float), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, s2, f3);
OUTPUT:
	RETVAL

double
nci_dipst( c_func, i0, p1, s2, t3 )
	SV* c_func
	int i0
	void * p1
	short s2
	char * t3
PREINIT:
	double(*func)(int, void *, short, char *);
CODE:
	func   = INT2PTR(double(*)(int, void *, short, char *), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, s2, t3);
OUTPUT:
	RETVAL

double
nci_dipsi( c_func, i0, p1, s2, i3 )
	SV* c_func
	int i0
	void * p1
	short s2
	int i3
PREINIT:
	double(*func)(int, void *, short, int);
CODE:
	func   = INT2PTR(double(*)(int, void *, short, int), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, s2, i3);
OUTPUT:
	RETVAL

double
nci_dipfp( c_func, i0, p1, f2, p3 )
	SV* c_func
	int i0
	void * p1
	float f2
	void * p3
PREINIT:
	double(*func)(int, void *, float, void *);
CODE:
	func   = INT2PTR(double(*)(int, void *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, f2, p3);
OUTPUT:
	RETVAL

double
nci_dipfd( c_func, i0, p1, f2, d3 )
	SV* c_func
	int i0
	void * p1
	float f2
	double d3
PREINIT:
	double(*func)(int, void *, float, double);
CODE:
	func   = INT2PTR(double(*)(int, void *, float, double), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, f2, d3);
OUTPUT:
	RETVAL

double
nci_dipfs( c_func, i0, p1, f2, s3 )
	SV* c_func
	int i0
	void * p1
	float f2
	short s3
PREINIT:
	double(*func)(int, void *, float, short);
CODE:
	func   = INT2PTR(double(*)(int, void *, float, short), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, f2, s3);
OUTPUT:
	RETVAL

double
nci_dipff( c_func, i0, p1, f2, f3 )
	SV* c_func
	int i0
	void * p1
	float f2
	float f3
PREINIT:
	double(*func)(int, void *, float, float);
CODE:
	func   = INT2PTR(double(*)(int, void *, float, float), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, f2, f3);
OUTPUT:
	RETVAL

double
nci_dipft( c_func, i0, p1, f2, t3 )
	SV* c_func
	int i0
	void * p1
	float f2
	char * t3
PREINIT:
	double(*func)(int, void *, float, char *);
CODE:
	func   = INT2PTR(double(*)(int, void *, float, char *), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, f2, t3);
OUTPUT:
	RETVAL

double
nci_dipfi( c_func, i0, p1, f2, i3 )
	SV* c_func
	int i0
	void * p1
	float f2
	int i3
PREINIT:
	double(*func)(int, void *, float, int);
CODE:
	func   = INT2PTR(double(*)(int, void *, float, int), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, f2, i3);
OUTPUT:
	RETVAL

double
nci_diptp( c_func, i0, p1, t2, p3 )
	SV* c_func
	int i0
	void * p1
	char * t2
	void * p3
PREINIT:
	double(*func)(int, void *, char *, void *);
CODE:
	func   = INT2PTR(double(*)(int, void *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, t2, p3);
OUTPUT:
	RETVAL

double
nci_diptd( c_func, i0, p1, t2, d3 )
	SV* c_func
	int i0
	void * p1
	char * t2
	double d3
PREINIT:
	double(*func)(int, void *, char *, double);
CODE:
	func   = INT2PTR(double(*)(int, void *, char *, double), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, t