
use strict;
use warnings;

use 5.010;

use ExtUtils::MakeMaker 6.30;



my %WriteMakefileArgs = (
  "ABSTRACT" => "use the dogeapi.com API from Perl",
  "AUTHOR" => "chromatic <chromatic\@wgz.org>",
  "BUILD_REQUIRES" => {},
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker" => "6.30"
  },
  "DISTNAME" => "Finance-Dogecoin",
  "EXE_FILES" => [],
  "LICENSE" => "perl",
  "NAME" => "Finance::Dogecoin",
  "PREREQ_PM" => {
    "Carp" => 0,
    "HTTP::Headers" => 0,
    "JSON" => 0,
    "LWP::Protocol::https" => 0,
    "LWP::UserAgent" => 0,
    "Moo" => 0,
    "URI::QueryParam" => 0,
    "strict" => 0,
    "warnings" => 0
  },
  "TEST_REQUIRES" => {
    "File::Find" => 0,
    "Test::Mock::LWP" => 0,
    "Test::More" => 0,
    "Test::Most" => 0,
    "lib" => 0
  },
  "VERSION" => "1.20140127.2153",
  "test" => {
    "TESTS" => "t/*.t"
  }
);


my %FallbackPrereqs = (
  "Carp" => 0,
  "File::Find" => 0,
  "HTTP::Headers" => 0,
  "JSON" => 0,
  "LWP::Protocol::https" => 0,
  "LWP::UserAgent" => 0,
  "Moo" => 0,
  "Test::Mock::LWP" => 0,
  "Test::More" => 0,
  "Test::Most" => 0,
  "URI::QueryParam" => 0,
  "lib" => 0,
  "strict" => 0,
  "warnings" => 0
);


unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);



