package OpenGL::Modern;

use strict;
use warnings;
use Carp;

use Exporter 'import';
use AutoLoader;

our $VERSION = '0.01_04';
our $XS_VERSION = $VERSION;
$VERSION = eval $VERSION;  # see L<perlmodstyle>

# ATTENTION: This array is overwritten by utils/generate-XS.pl!
#            Manual changes will be lost.
our @glFunctions = qw(
    glGetString
    glShaderSource_p
    glAccum
    glActiveProgramEXT
    glActiveShaderProgram
    glActiveStencilFaceEXT
    glActiveTexture
    glActiveTextureARB
    glActiveVaryingNV_c
    glAddSwapHintRectWIN
    glAlphaFragmentOp1ATI
    glAlphaFragmentOp2ATI
    glAlphaFragmentOp3ATI
    glAlphaFunc
    glAlphaFuncx
    glApplyTextureEXT
    glAreProgramsResidentNV_c
    glAreTexturesResident_c
    glAreTexturesResidentEXT_c
    glArrayElement
    glArrayElementEXT
    glArrayObjectATI
    glAsyncMarkerSGIX
    glAttachObjectARB
    glAttachShader
    glBegin
    glBeginConditionalRender
    glBeginConditionalRenderNV
    glBeginConditionalRenderNVX
    glBeginFragmentShaderATI
    glBeginOcclusionQueryNV
    glBeginPerfMonitorAMD
    glBeginPerfQueryINTEL
    glBeginQuery
    glBeginQueryANGLE
    glBeginQueryARB
    glBeginQueryIndexed
    glBeginSceneEXT
    glBeginTransformFeedback
    glBeginTransformFeedbackEXT
    glBeginTransformFeedbackNV
    glBeginVertexShaderEXT
    glBeginVideoCaptureNV
    glBindAttribLocation_c
    glBindAttribLocationARB_c
    glBindBuffer
    glBindBufferARB
    glBindBufferBase
    glBindBufferBaseEXT
    glBindBufferBaseNV
    glBindBufferOffsetEXT
    glBindBufferOffsetNV
    glBindBufferRange
    glBindBufferRangeEXT
    glBindBufferRangeNV
    glBindBuffersBase_c
    glBindBuffersRange_c
    glBindFragDataLocation_c
    glBindFragDataLocationEXT_c
    glBindFragDataLocationIndexed_c
    glBindFragmentShaderATI
    glBindFramebuffer
    glBindFramebufferEXT
    glBindImageTexture
    glBindImageTextureEXT
    glBindImageTextures_c
    glBindLightParameterEXT
    glBindMaterialParameterEXT
    glBindMultiTextureEXT
    glBindParameterEXT
    glBindProgramARB
    glBindProgramNV
    glBindProgramPipeline
    glBindRenderbuffer
    glBindRenderbufferEXT
    glBindSampler
    glBindSamplers_c
    glBindTexGenParameterEXT
    glBindTexture
    glBindTextureEXT
    glBindTextures_c
    glBindTextureUnit
    glBindTextureUnitParameterEXT
    glBindTransformFeedback
    glBindTransformFeedbackNV
    glBindVertexArray
    glBindVertexArrayAPPLE
    glBindVertexBuffer
    glBindVertexBuffers_c
    glBindVertexShaderEXT
    glBindVideoCaptureStreamBufferNV
    glBindVideoCaptureStreamTextureNV
    glBinormalPointerEXT_c
    glBitmap_c
    glBlendBarrierKHR
    glBlendBarrierNV
    glBlendColor
    glBlendColorEXT
    glBlendEquation
    glBlendEquationEXT
    glBlendEquationi
    glBlendEquationiARB
    glBlendEquationIndexedAMD
    glBlendEquationSeparate
    glBlendEquationSeparateEXT
    glBlendEquationSeparatei
    glBlendEquationSeparateiARB
    glBlendEquationSeparateIndexedAMD
    glBlendFunc
    glBlendFunci
    glBlendFunciARB
    glBlendFuncIndexedAMD
    glBlendFuncSeparate
    glBlendFuncSeparateEXT
    glBlendFuncSeparatei
    glBlendFuncSeparateiARB
    glBlendFuncSeparateIndexedAMD
    glBlendParameteriNV
    glBlitFramebuffer
    glBlitFramebufferANGLE
    glBlitFramebufferEXT
    glBlitNamedFramebuffer
    glBufferAddressRangeNV
    glBufferData_c
    glBufferDataARB_c
    glBufferPageCommitmentARB
    glBufferParameteriAPPLE
    glBufferRegionEnabled
    glBufferStorage_c
    glBufferSubData_c
    glBufferSubDataARB_c
    glCallCommandListNV
    glCallList
    glCallLists_c
    glCheckFramebufferStatus
    glCheckFramebufferStatusEXT
    glCheckNamedFramebufferStatus
    glCheckNamedFramebufferStatusEXT
    glClampColor
    glClampColorARB
    glClear
    glClearAccum
    glClearBufferData_c
    glClearBufferfi
    glClearBufferfv_c
    glClearBufferiv_c
    glClearBufferSubData_c
    glClearBufferuiv_c
    glClearColor
    glClearColorIiEXT
    glClearColorIuiEXT
    glClearColorx
    glClearDepth
    glClearDepthdNV
    glClearDepthf
    glClearDepthfOES
    glClearDepthx
    glClearIndex
    glClearNamedBufferData_c
    glClearNamedBufferDataEXT_c
    glClearNamedBufferSubData_c
    glClearNamedBufferSubDataEXT_c
    glClearNamedFramebufferfi
    glClearNamedFramebufferfv_c
    glClearNamedFramebufferiv_c
    glClearNamedFramebufferuiv_c
    glClearStencil
    glClearTexImage_c
    glClearTexSubImage_c
    glClientActiveTexture
    glClientActiveTextureARB
    glClientActiveVertexStreamATI
    glClientAttribDefaultEXT
    glClientWaitSync
    glClipControl
    glClipPlane_c
    glClipPlanef_c
    glClipPlanefOES_c
    glClipPlanex_c
    glColor3b
    glColor3bv_c
    glColor3d
    glColor3dv_c
    glColor3f
    glColor3fv_c
    glColor3fVertex3fSUN
    glColor3fVertex3fvSUN_c
    glColor3hNV
    glColor3hvNV_c
    glColor3i
    glColor3iv_c
    glColor3s
    glColor3sv_c
    glColor3ub
    glColor3ubv_c
    glColor3ui
    glColor3uiv_c
    glColor3us
    glColor3usv_c
    glColor4b
    glColor4bv_c
    glColor4d
    glColor4dv_c
    glColor4f
    glColor4fNormal3fVertex3fSUN
    glColor4fNormal3fVertex3fvSUN_c
    glColor4fv_c
    glColor4hNV
    glColor4hvNV_c
    glColor4i
    glColor4iv_c
    glColor4s
    glColor4sv_c
    glColor4ub
    glColor4ubv_c
    glColor4ubVertex2fSUN
    glColor4ubVertex2fvSUN_c
    glColor4ubVertex3fSUN
    glColor4ubVertex3fvSUN_c
    glColor4ui
    glColor4uiv_c
    glColor4us
    glColor4usv_c
    glColor4x
    glColorFormatNV
    glColorFragmentOp1ATI
    glColorFragmentOp2ATI
    glColorFragmentOp3ATI
    glColorMask
    glColorMaski
    glColorMaskIndexedEXT
    glColorMaterial
    glColorP3ui
    glColorP3uiv_c
    glColorP4ui
    glColorP4uiv_c
    glColorPointer_c
    glColorPointerEXT_c
    glColorPointerListIBM_c
    glColorPointervINTEL_c
    glColorSubTable_c
    glColorSubTableEXT_c
    glColorTable_c
    glColorTableEXT_c
    glColorTableParameterfv_c
    glColorTableParameterfvSGI_c
    glColorTableParameteriv_c
    glColorTableParameterivSGI_c
    glColorTableSGI_c
    glCombinerInputNV
    glCombinerOutputNV
    glCombinerParameterfNV
    glCombinerParameterfvNV_c
    glCombinerParameteriNV
    glCombinerParameterivNV_c
    glCombinerStageParameterfvNV_c
    glCommandListSegmentsNV
    glCompileCommandListNV
    glCompileShader
    glCompileShaderARB
    glCompileShaderIncludeARB_c
    glCompressedMultiTexImage1DEXT_c
    glCompressedMultiTexImage2DEXT_c
    glCompressedMultiTexImage3DEXT_c
    glCompressedMultiTexSubImage1DEXT_c
    glCompressedMultiTexSubImage2DEXT_c
    glCompressedMultiTexSubImage3DEXT_c
    glCompressedTexImage1D_c
    glCompressedTexImage1DARB_c
    glCompressedTexImage2D_c
    glCompressedTexImage2DARB_c
    glCompressedTexImage3D_c
    glCompressedTexImage3DARB_c
    glCompressedTexSubImage1D_c
    glCompressedTexSubImage1DARB_c
    glCompressedTexSubImage2D_c
    glCompressedTexSubImage2DARB_c
    glCompressedTexSubImage3D_c
    glCompressedTexSubImage3DARB_c
    glCompressedTextureImage1DEXT_c
    glCompressedTextureImage2DEXT_c
    glCompressedTextureImage3DEXT_c
    glCompressedTextureSubImage1D_c
    glCompressedTextureSubImage1DEXT_c
    glCompressedTextureSubImage2D_c
    glCompressedTextureSubImage2DEXT_c
    glCompressedTextureSubImage3D_c
    glCompressedTextureSubImage3DEXT_c
    glConservativeRasterParameterfNV
    glConservativeRasterParameteriNV
    glConvolutionFilter1D_c
    glConvolutionFilter1DEXT_c
    glConvolutionFilter2D_c
    glConvolutionFilter2DEXT_c
    glConvolutionParameterf
    glConvolutionParameterfEXT
    glConvolutionParameterfv_c
    glConvolutionParameterfvEXT_c
    glConvolutionParameteri
    glConvolutionParameteriEXT
    glConvolutionParameteriv_c
    glConvolutionParameterivEXT_c
    glCopyBufferSubData
    glCopyColorSubTable
    glCopyColorSubTableEXT
    glCopyColorTable
    glCopyColorTableSGI
    glCopyConvolutionFilter1D
    glCopyConvolutionFilter1DEXT
    glCopyConvolutionFilter2D
    glCopyConvolutionFilter2DEXT
    glCopyImageSubData
    glCopyImageSubDataNV
    glCopyMultiTexImage1DEXT
    glCopyMultiTexImage2DEXT
    glCopyMultiTexSubImage1DEXT
    glCopyMultiTexSubImage2DEXT
    glCopyMultiTexSubImage3DEXT
    glCopyNamedBufferSubData
    glCopyPathNV
    glCopyPixels
    glCopyTexImage1D
    glCopyTexImage1DEXT
    glCopyTexImage2D
    glCopyTexImage2DEXT
    glCopyTexSubImage1D
    glCopyTexSubImage1DEXT
    glCopyTexSubImage2D
    glCopyTexSubImage2DEXT
    glCopyTexSubImage3D
    glCopyTexSubImage3DEXT
    glCopyTextureImage1DEXT
    glCopyTextureImage2DEXT
    glCopyTextureSubImage1D
    glCopyTextureSubImage1DEXT
    glCopyTextureSubImage2D
    glCopyTextureSubImage2DEXT
    glCopyTextureSubImage3D
    glCopyTextureSubImage3DEXT
    glCoverageModulationNV
    glCoverageModulationTableNV_c
    glCoverFillPathInstancedNV_c
    glCoverFillPathNV
    glCoverStrokePathInstancedNV_c
    glCoverStrokePathNV
    glCreateBuffers_c
    glCreateCommandListsNV_c
    glCreateFramebuffers_c
    glCreatePerfQueryINTEL_c
    glCreateProgram
    glCreateProgramObjectARB
    glCreateProgramPipelines_c
    glCreateQueries_c
    glCreateRenderbuffers_c
    glCreateSamplers_c
    glCreateShader
    glCreateShaderObjectARB
    glCreateShaderProgramEXT_c
    glCreateShaderProgramv_c
    glCreateStatesNV_c
    glCreateSyncFromCLeventARB
    glCreateTextures_c
    glCreateTransformFeedbacks_c
    glCreateVertexArrays_c
    glCullFace
    glCullParameterdvEXT_c
    glCullParameterfvEXT_c
    glCurrentPaletteMatrixARB
    glDebugMessageCallback_c
    glDebugMessageCallbackAMD_c
    glDebugMessageCallbackARB_c
    glDebugMessageControl_c
    glDebugMessageControlARB_c
    glDebugMessageEnableAMD_c
    glDebugMessageInsert_c
    glDebugMessageInsertAMD_c
    glDebugMessageInsertARB_c
    glDeleteAsyncMarkersSGIX
    glDeleteBufferRegion
    glDeleteBuffers_c
    glDeleteBuffersARB_c
    glDeleteCommandListsNV_c
    glDeleteFencesAPPLE_c
    glDeleteFencesNV_c
    glDeleteFragmentShaderATI
    glDeleteFramebuffers_c
    glDeleteFramebuffersEXT_c
    glDeleteLists
    glDeleteNamedStringARB_c
    glDeleteNamesAMD_c
    glDeleteObjectARB
    glDeleteOcclusionQueriesNV_c
    glDeletePathsNV
    glDeletePerfMonitorsAMD_c
    glDeletePerfQueryINTEL
    glDeleteProgram
    glDeleteProgramPipelines_c
    glDeleteProgramsARB_c
    glDeleteProgramsNV_c
    glDeleteQueries_c
    glDeleteQueriesANGLE_c
    glDeleteQueriesARB_c
    glDeleteRenderbuffers_c
    glDeleteRenderbuffersEXT_c
    glDeleteSamplers_c
    glDeleteShader
    glDeleteStatesNV_c
    glDeleteSync
    glDeleteTextures_c
    glDeleteTexturesEXT_c
    glDeleteTransformFeedbacks_c
    glDeleteTransformFeedbacksNV_c
    glDeleteVertexArrays_c
    glDeleteVertexArraysAPPLE_c
    glDeleteVertexShaderEXT
    glDepthBoundsdNV
    glDepthBoundsEXT
    glDepthFunc
    glDepthMask
    glDepthRange
    glDepthRangeArrayv_c
    glDepthRangedNV
    glDepthRangef
    glDepthRangefOES
    glDepthRangeIndexed
    glDepthRangex
    glDetachObjectARB
    glDetachShader
    glDetailTexFuncSGIS_c
    glDisable
    glDisableClientState
    glDisableClientStateiEXT
    glDisableClientStateIndexedEXT
    glDisablei
    glDisableIndexedEXT
    glDisableVariantClientStateEXT
    glDisableVertexArrayAttrib
    glDisableVertexArrayAttribEXT
    glDisableVertexArrayEXT
    glDisableVertexAttribAPPLE
    glDisableVertexAttribArray
    glDisableVertexAttribArrayARB
    glDispatchCompute
    glDispatchComputeGroupSizeARB
    glDispatchComputeIndirect
    glDrawArrays
    glDrawArraysEXT
    glDrawArraysIndirect_c
    glDrawArraysInstanced
    glDrawArraysInstancedANGLE
    glDrawArraysInstancedARB
    glDrawArraysInstancedBaseInstance
    glDrawArraysInstancedEXT
    glDrawBuffer
    glDrawBufferRegion
    glDrawBuffers_c
    glDrawBuffersARB_c
    glDrawBuffersATI_c
    glDrawCommandsAddressNV_c
    glDrawCommandsNV_c
    glDrawCommandsStatesAddressNV_c
    glDrawCommandsStatesNV_c
    glDrawElementArrayAPPLE
    glDrawElementArrayATI
    glDrawElements_c
    glDrawElementsBaseVertex_c
    glDrawElementsIndirect_c
    glDrawElementsInstanced_c
    glDrawElementsInstancedANGLE_c
    glDrawElementsInstancedARB_c
    glDrawElementsInstancedBaseInstance_c
    glDrawElementsInstancedBaseVertex_c
    glDrawElementsInstancedBaseVertexBaseInstance_c
    glDrawElementsInstancedEXT_c
    glDrawPixels_c
    glDrawRangeElementArrayAPPLE
    glDrawRangeElementArrayATI
    glDrawRangeElements_c
    glDrawRangeElementsBaseVertex_c
    glDrawRangeElementsEXT_c
    glDrawTextureNV
    glDrawTransformFeedback
    glDrawTransformFeedbackInstanced
    glDrawTransformFeedbackNV
    glDrawTransformFeedbackStream
    glDrawTransformFeedbackStreamInstanced
    glDrawVkImageNV
    glEdgeFlag
    glEdgeFlagFormatNV
    glEdgeFlagPointer_c
    glEdgeFlagPointerEXT_c
    glEdgeFlagPointerListIBM_c
    glEdgeFlagv_c
    glElementPointerAPPLE_c
    glElementPointerATI_c
    glEnable
    glEnableClientState
    glEnableClientStateiEXT
    glEnableClientStateIndexedEXT
    glEnablei
    glEnableIndexedEXT
    glEnableVariantClientStateEXT
    glEnableVertexArrayAttrib
    glEnableVertexArrayAttribEXT
    glEnableVertexArrayEXT
    glEnableVertexAttribAPPLE
    glEnableVertexAttribArray
    glEnableVertexAttribArrayARB
    glEnd
    glEndConditionalRender
    glEndConditionalRenderNV
    glEndConditionalRenderNVX
    glEndFragmentShaderATI
    glEndList
    glEndOcclusionQueryNV
    glEndPerfMonitorAMD
    glEndPerfQueryINTEL
    glEndQuery
    glEndQueryANGLE
    glEndQueryARB
    glEndQueryIndexed
    glEndSceneEXT
    glEndTransformFeedback
    glEndTransformFeedbackEXT
    glEndTransformFeedbackNV
    glEndVertexShaderEXT
    glEndVideoCaptureNV
    glEvalCoord1d
    glEvalCoord1dv_c
    glEvalCoord1f
    glEvalCoord1fv_c
    glEvalCoord2d
    glEvalCoord2dv_c
    glEvalCoord2f
    glEvalCoord2fv_c
    glEvalMapsNV
    glEvalMesh1
    glEvalMesh2
    glEvalPoint1
    glEvalPoint2
    glExecuteProgramNV_c
    glExtractComponentEXT
    glFeedbackBuffer_c
    glFenceSync
    glFinalCombinerInputNV
    glFinish
    glFinishAsyncSGIX_c
    glFinishFenceAPPLE
    glFinishFenceNV
    glFinishObjectAPPLE
    glFinishTextureSUNX
    glFlush
    glFlushMappedBufferRange
    glFlushMappedBufferRangeAPPLE
    glFlushMappedNamedBufferRange
    glFlushMappedNamedBufferRangeEXT
    glFlushPixelDataRangeNV
    glFlushRasterSGIX
    glFlushVertexArrayRangeAPPLE_c
    glFlushVertexArrayRangeNV
    glFogCoordd
    glFogCoorddEXT
    glFogCoorddv_c
    glFogCoorddvEXT_c
    glFogCoordf
    glFogCoordfEXT
    glFogCoordFormatNV
    glFogCoordfv_c
    glFogCoordfvEXT_c
    glFogCoordhNV
    glFogCoordhvNV_c
    glFogCoordPointer_c
    glFogCoordPointerEXT_c
    glFogCoordPointerListIBM_c
    glFogf
    glFogFuncSGIS_c
    glFogfv_c
    glFogi
    glFogiv_c
    glFogx
    glFogxv_c
    glFragmentColorMaterialEXT
    glFragmentColorMaterialSGIX
    glFragmentCoverageColorNV
    glFragmentLightfEXT
    glFragmentLightfSGIX
    glFragmentLightfvEXT_c
    glFragmentLightfvSGIX_c
    glFragmentLightiEXT
    glFragmentLightiSGIX
    glFragmentLightivEXT_c
    glFragmentLightivSGIX_c
    glFragmentLightModelfEXT
    glFragmentLightModelfSGIX
    glFragmentLightModelfvEXT_c
    glFragmentLightModelfvSGIX_c
    glFragmentLightModeliEXT
    glFragmentLightModeliSGIX
    glFragmentLightModelivEXT_c
    glFragmentLightModelivSGIX_c
    glFragmentMaterialfEXT
    glFragmentMaterialfSGIX
    glFragmentMaterialfvEXT_c
    glFragmentMaterialfvSGIX_c
    glFragmentMaterialiEXT
    glFragmentMaterialiSGIX
    glFragmentMaterialivEXT_c
    glFragmentMaterialivSGIX_c
    glFramebufferDrawBufferEXT
    glFramebufferDrawBuffersEXT_c
    glFramebufferParameteri
    glFramebufferReadBufferEXT
    glFramebufferRenderbuffer
    glFramebufferRenderbufferEXT
    glFramebufferSampleLocationsfvARB_c
    glFramebufferSampleLocationsfvNV_c
    glFramebufferTexture
    glFramebufferTexture1D
    glFramebufferTexture1DEXT
    glFramebufferTexture2D
    glFramebufferTexture2DEXT
    glFramebufferTexture3D
    glFramebufferTexture3DEXT
    glFramebufferTextureARB
    glFramebufferTextureEXT
    glFramebufferTextureFaceARB
    glFramebufferTextureFaceEXT
    glFramebufferTextureLayer
    glFramebufferTextureLayerARB
    glFramebufferTextureLayerEXT
    glFramebufferTextureMultiviewOVR
    glFrameTerminatorGREMEDY
    glFrameZoomSGIX
    glFreeObjectBufferATI
    glFrontFace
    glFrustum
    glFrustumf
    glFrustumfOES
    glFrustumx
    glGenAsyncMarkersSGIX
    glGenBuffers_c
    glGenBuffersARB_c
    glGenerateMipmap
    glGenerateMipmapEXT
    glGenerateMultiTexMipmapEXT
    glGenerateTextureMipmap
    glGenerateTextureMipmapEXT
    glGenFencesAPPLE_c
    glGenFencesNV_c
    glGenFragmentShadersATI
    glGenFramebuffers_c
    glGenFramebuffersEXT_c
    glGenLists
    glGenNamesAMD_c
    glGenOcclusionQueriesNV_c
    glGenPathsNV
    glGenPerfMonitorsAMD_c
    glGenProgramPipelines_c
    glGenProgramsARB_c
    glGenProgramsNV_c
    glGenQueries_c
    glGenQueriesANGLE_c
    glGenQueriesARB_c
    glGenRenderbuffers_c
    glGenRenderbuffersEXT_c
    glGenSamplers_c
    glGenSymbolsEXT
    glGenTextures_c
    glGenTexturesEXT_c
    glGenTransformFeedbacks_c
    glGenTransformFeedbacksNV_c
    glGenVertexArrays_c
    glGenVertexArraysAPPLE_c
    glGenVertexShadersEXT
    glGetActiveAtomicCounterBufferiv_c
    glGetActiveAttrib_c
    glGetActiveAttribARB_c
    glGetActiveSubroutineName_c
    glGetActiveSubroutineUniformiv_c
    glGetActiveSubroutineUniformName_c
    glGetActiveUniform_c
    glGetActiveUniformARB_c
    glGetActiveUniformBlockiv_c
    glGetActiveUniformBlockName_c
    glGetActiveUniformName_c
    glGetActiveUniformsiv_c
    glGetActiveVaryingNV_c
    glGetArrayObjectfvATI_c
    glGetArrayObjectivATI_c
    glGetAttachedObjectsARB_c
    glGetAttachedShaders_c
    glGetAttribLocation_c
    glGetAttribLocationARB_c
    glGetBooleanIndexedvEXT_c
    glGetBooleani_v_c
    glGetBooleanv_c
    glGetBufferParameteri64v_c
    glGetBufferParameteriv_c
    glGetBufferParameterivARB_c
    glGetBufferParameterui64vNV_c
    glGetBufferPointerv_c
    glGetBufferPointervARB_c
    glGetBufferSubData_c
    glGetBufferSubDataARB_c
    glGetClipPlane_c
    glGetClipPlanef_c
    glGetClipPlanefOES_c
    glGetClipPlanex_c
    glGetColorTable_c
    glGetColorTableEXT_c
    glGetColorTableParameterfv_c
    glGetColorTableParameterfvEXT_c
    glGetColorTableParameterfvSGI_c
    glGetColorTableParameteriv_c
    glGetColorTableParameterivEXT_c
    glGetColorTableParameterivSGI_c
    glGetColorTableSGI_c
    glGetCombinerInputParameterfvNV_c
    glGetCombinerInputParameterivNV_c
    glGetCombinerOutputParameterfvNV_c
    glGetCombinerOutputParameterivNV_c
    glGetCombinerStageParameterfvNV_c
    glGetCommandHeaderNV
    glGetCompressedMultiTexImageEXT_c
    glGetCompressedTexImage_c
    glGetCompressedTexImageARB_c
    glGetCompressedTextureImage_c
    glGetCompressedTextureImageEXT_c
    glGetCompressedTextureSubImage_c
    glGetConvolutionFilter_c
    glGetConvolutionFilterEXT_c
    glGetConvolutionParameterfv_c
    glGetConvolutionParameterfvEXT_c
    glGetConvolutionParameteriv_c
    glGetConvolutionParameterivEXT_c
    glGetCoverageModulationTableNV_c
    glGetDebugMessageLog_c
    glGetDebugMessageLogAMD_c
    glGetDebugMessageLogARB_c
    glGetDetailTexFuncSGIS_c
    glGetDoubleIndexedvEXT_c
    glGetDoublei_v_c
    glGetDoublei_vEXT_c
    glGetDoublev_c
    glGetError
    glGetExtensionREGAL_c
    glGetFenceivNV_c
    glGetFinalCombinerInputParameterfvNV_c
    glGetFinalCombinerInputParameterivNV_c
    glGetFirstPerfQueryIdINTEL_c
    glGetFixedv_c
    glGetFloatIndexedvEXT_c
    glGetFloati_v_c
    glGetFloati_vEXT_c
    glGetFloatv_c
    glGetFogFuncSGIS_c
    glGetFragDataIndex_c
    glGetFragDataLocation_c
    glGetFragDataLocationEXT_c
    glGetFragmentLightfvEXT_c
    glGetFragmentLightfvSGIX_c
    glGetFragmentLightivEXT_c
    glGetFragmentLightivSGIX_c
    glGetFragmentMaterialfvEXT_c
    glGetFragmentMaterialfvSGIX_c
    glGetFragmentMaterialivEXT_c
    glGetFragmentMaterialivSGIX_c
    glGetFramebufferAttachmentParameteriv_c
    glGetFramebufferAttachmentParameterivEXT_c
    glGetFramebufferParameteriv_c
    glGetFramebufferParameterivEXT_c
    glGetGraphicsResetStatus
    glGetGraphicsResetStatusARB
    glGetHandleARB
    glGetHistogram_c
    glGetHistogramEXT_c
    glGetHistogramParameterfv_c
    glGetHistogramParameterfvEXT_c
    glGetHistogramParameteriv_c
    glGetHistogramParameterivEXT_c
    glGetImageHandleARB
    glGetImageHandleNV
    glGetImageTransformParameterfvHP_c
    glGetImageTransformParameterivHP_c
    glGetInfoLogARB_c
    glGetInteger64i_v_c
    glGetInteger64v_c
    glGetIntegerIndexedvEXT_c
    glGetIntegeri_v_c
    glGetIntegerui64i_vNV_c
    glGetIntegerui64vNV_c
    glGetIntegerv_c
    glGetInternalformati64v_c
    glGetInternalformativ_c
    glGetInternalformatSampleivNV_c
    glGetInvariantBooleanvEXT_c
    glGetInvariantFloatvEXT_c
    glGetInvariantIntegervEXT_c
    glGetLightfv_c
    glGetLightiv_c
    glGetLightxv_c
    glGetLocalConstantBooleanvEXT_c
    glGetLocalConstantFloatvEXT_c
    glGetLocalConstantIntegervEXT_c
    glGetMapAttribParameterfvNV_c
    glGetMapAttribParameterivNV_c
    glGetMapControlPointsNV_c
    glGetMapdv_c
    glGetMapfv_c
    glGetMapiv_c
    glGetMapParameterfvNV_c
    glGetMapParameterivNV_c
    glGetMaterialfv_c
    glGetMaterialiv_c
    glGetMaterialxv_c
    glGetMinmax_c
    glGetMinmaxEXT_c
    glGetMinmaxParameterfv_c
    glGetMinmaxParameterfvEXT_c
    glGetMinmaxParameteriv_c
    glGetMinmaxParameterivEXT_c
    glGetMultisamplefv_c
    glGetMultisamplefvNV_c
    glGetMultiTexEnvfvEXT_c
    glGetMultiTexEnvivEXT_c
    glGetMultiTexGendvEXT_c
    glGetMultiTexGenfvEXT_c
    glGetMultiTexGenivEXT_c
    glGetMultiTexImageEXT_c
    glGetMultiTexLevelParameterfvEXT_c
    glGetMultiTexLevelParameterivEXT_c
    glGetMultiTexParameterfvEXT_c
    glGetMultiTexParameterIivEXT_c
    glGetMultiTexParameterIuivEXT_c
    glGetMultiTexParameterivEXT_c
    glGetNamedBufferParameteri64v_c
    glGetNamedBufferParameteriv_c
    glGetNamedBufferParameterivEXT_c
    glGetNamedBufferParameterui64vNV_c
    glGetNamedBufferPointerv_c
    glGetNamedBufferPointervEXT_c
    glGetNamedBufferSubData_c
    glGetNamedBufferSubDataEXT_c
    glGetNamedFramebufferAttachmentParameteriv_c
    glGetNamedFramebufferAttachmentParameterivEXT_c
    glGetNamedFramebufferParameteriv_c
    glGetNamedFramebufferParameterivEXT_c
    glGetNamedProgramivEXT_c
    glGetNamedProgramLocalParameterdvEXT_c
    glGetNamedProgramLocalParameterfvEXT_c
    glGetNamedProgramLocalParameterIivEXT_c
    glGetNamedProgramLocalParameterIuivEXT_c
    glGetNamedProgramStringEXT_c
    glGetNamedRenderbufferParameteriv_c
    glGetNamedRenderbufferParameterivEXT_c
    glGetNamedStringARB_c
    glGetNamedStringivARB_c
    glGetnColorTableARB_c
    glGetnCompressedTexImage_c
    glGetnCompressedTexImageARB_c
    glGetnConvolutionFilterARB_c
    glGetNextPerfQueryIdINTEL_c
    glGetnHistogramARB_c
    glGetnMapdvARB_c
    glGetnMapfvARB_c
    glGetnMapivARB_c
    glGetnMinmaxARB_c
    glGetnPixelMapfvARB_c
    glGetnPixelMapuivARB_c
    glGetnPixelMapusvARB_c
    glGetnPolygonStippleARB_c
    glGetnSeparableFilterARB_c
    glGetnTexImage_c
    glGetnTexImageARB_c
    glGetnUniformdv_c
    glGetnUniformdvARB_c
    glGetnUniformfv_c
    glGetnUniformfvARB_c
    glGetnUniformi64vARB_c
    glGetnUniformiv_c
    glGetnUniformivARB_c
    glGetnUniformui64vARB_c
    glGetnUniformuiv_c
    glGetnUniformuivARB_c
    glGetObjectBufferfvATI_c
    glGetObjectBufferivATI_c
    glGetObjectLabel_c
    glGetObjectLabelEXT_c
    glGetObjectParameterfvARB_c
    glGetObjectParameterivAPPLE_c
    glGetObjectParameterivARB_c
    glGetObjectPtrLabel_c
    glGetOcclusionQueryivNV_c
    glGetOcclusionQueryuivNV_c
    glGetPathColorGenfvNV_c
    glGetPathColorGenivNV_c
    glGetPathCommandsNV_c
    glGetPathCoordsNV_c
    glGetPathDashArrayNV_c
    glGetPathLengthNV
    glGetPathMetricRangeNV_c
    glGetPathMetricsNV_c
    glGetPathParameterfvNV_c
    glGetPathParameterivNV_c
    glGetPathSpacingNV_c
    glGetPathTexGenfvNV_c
    glGetPathTexGenivNV_c
    glGetPerfCounterInfoINTEL_c
    glGetPerfMonitorCounterDataAMD_c
    glGetPerfMonitorCounterInfoAMD_c
    glGetPerfMonitorCountersAMD_c
    glGetPerfMonitorCounterStringAMD_c
    glGetPerfMonitorGroupsAMD_c
    glGetPerfMonitorGroupStringAMD_c
    glGetPerfQueryDataINTEL_c
    glGetPerfQueryIdByNameINTEL_c
    glGetPerfQueryInfoINTEL_c
    glGetPixelMapfv_c
    glGetPixelMapuiv_c
    glGetPixelMapusv_c
    glGetPixelTransformParameterfvEXT_c
    glGetPixelTransformParameterivEXT_c
    glGetPointerIndexedvEXT_c
    glGetPointeri_vEXT_c
    glGetPointerv_c
    glGetPolygonStipple_c
    glGetProcAddressREGAL_c
    glGetProgramBinary_c
    glGetProgramEnvParameterdvARB_c
    glGetProgramEnvParameterfvARB_c
    glGetProgramInfoLog_c
    glGetProgramInterfaceiv_c
    glGetProgramiv_c
    glGetProgramivARB_c
    glGetProgramivNV_c
    glGetProgramLocalParameterdvARB_c
    glGetProgramLocalParameterfvARB_c
    glGetProgramNamedParameterdvNV_c
    glGetProgramNamedParameterfvNV_c
    glGetProgramParameterdvNV_c
    glGetProgramParameterfvNV_c
    glGetProgramPipelineInfoLog_c
    glGetProgramPipelineiv_c
    glGetProgramResourcefvNV_c
    glGetProgramResourceIndex_c
    glGetProgramResourceiv_c
    glGetProgramResourceLocation_c
    glGetProgramResourceLocationIndex_c
    glGetProgramResourceName_c
    glGetProgramStageiv_c
    glGetProgramStringARB_c
    glGetProgramStringNV_c
    glGetQueryBufferObjecti64v
    glGetQueryBufferObjectiv
    glGetQueryBufferObjectui64v
    glGetQueryBufferObjectuiv
    glGetQueryIndexediv_c
    glGetQueryiv_c
    glGetQueryivANGLE_c
    glGetQueryivARB_c
    glGetQueryObjecti64v_c
    glGetQueryObjecti64vANGLE_c
    glGetQueryObjecti64vEXT_c
    glGetQueryObjectiv_c
    glGetQueryObjectivANGLE_c
    glGetQueryObjectivARB_c
    glGetQueryObjectui64v_c
    glGetQueryObjectui64vANGLE_c
    glGetQueryObjectui64vEXT_c
    glGetQueryObjectuiv_c
    glGetQueryObjectuivANGLE_c
    glGetQueryObjectuivARB_c
    glGetRenderbufferParameteriv_c
    glGetRenderbufferParameterivEXT_c
    glGetSamplerParameterfv_c
    glGetSamplerParameterIiv_c
    glGetSamplerParameterIuiv_c
    glGetSamplerParameteriv_c
    glGetSeparableFilter_c
    glGetSeparableFilterEXT_c
    glGetShaderInfoLog_c
    glGetShaderiv_c
    glGetShaderPrecisionFormat_c
    glGetShaderSource_c
    glGetShaderSourceARB_c
    glGetSharpenTexFuncSGIS_c
    glGetStageIndexNV
    glGetSubroutineIndex_c
    glGetSubroutineUniformLocation_c
    glGetSynciv_c
    glGetTexBumpParameterfvATI_c
    glGetTexBumpParameterivATI_c
    glGetTexEnvfv_c
    glGetTexEnviv_c
    glGetTexEnvxv_c
    glGetTexFilterFuncSGIS_c
    glGetTexGendv_c
    glGetTexGenfv_c
    glGetTexGeniv_c
    glGetTexImage_c
    glGetTexLevelParameterfv_c
    glGetTexLevelParameteriv_c
    glGetTexParameterfv_c
    glGetTexParameterIiv_c
    glGetTexParameterIivEXT_c
    glGetTexParameterIuiv_c
    glGetTexParameterIuivEXT_c
    glGetTexParameteriv_c
    glGetTexParameterPointervAPPLE_c
    glGetTexParameterxv_c
    glGetTextureHandleARB
    glGetTextureHandleNV
    glGetTextureImage_c
    glGetTextureImageEXT_c
    glGetTextureLevelParameterfv_c
    glGetTextureLevelParameterfvEXT_c
    glGetTextureLevelParameteriv_c
    glGetTextureLevelParameterivEXT_c
    glGetTextureParameterfv_c
    glGetTextureParameterfvEXT_c
    glGetTextureParameterIiv_c
    glGetTextureParameterIivEXT_c
    glGetTextureParameterIuiv_c
    glGetTextureParameterIuivEXT_c
    glGetTextureParameteriv_c
    glGetTextureParameterivEXT_c
    glGetTextureSamplerHandleARB
    glGetTextureSamplerHandleNV
    glGetTextureSubImage_c
    glGetTrackMatrixivNV_c
    glGetTransformFeedbacki64_v_c
    glGetTransformFeedbackiv_c
    glGetTransformFeedbacki_v_c
    glGetTransformFeedbackVarying_c
    glGetTransformFeedbackVaryingEXT_c
    glGetTransformFeedbackVaryingNV_c
    glGetTranslatedShaderSourceANGLE_c
    glGetUniformBlockIndex_c
    glGetUniformBufferSizeEXT
    glGetUniformdv_c
    glGetUniformfv_c
    glGetUniformfvARB_c
    glGetUniformi64vARB_c
    glGetUniformi64vNV_c
    glGetUniformIndices_c
    glGetUniformiv_c
    glGetUniformivARB_c
    glGetUniformLocation_c
    glGetUniformLocationARB_c
    glGetUniformOffsetEXT
    glGetUniformSubroutineuiv_c
    glGetUniformui64vARB_c
    glGetUniformui64vNV_c
    glGetUniformuiv_c
    glGetUniformuivEXT_c
    glGetVariantArrayObjectfvATI_c
    glGetVariantArrayObjectivATI_c
    glGetVariantBooleanvEXT_c
    glGetVariantFloatvEXT_c
    glGetVariantIntegervEXT_c
    glGetVariantPointervEXT_c
    glGetVaryingLocationNV_c
    glGetVertexArrayIndexed64iv_c
    glGetVertexArrayIndexediv_c
    glGetVertexArrayIntegeri_vEXT_c
    glGetVertexArrayIntegervEXT_c
    glGetVertexArrayiv_c
    glGetVertexArrayPointeri_vEXT_c
    glGetVertexArrayPointervEXT_c
    glGetVertexAttribArrayObjectfvATI_c
    glGetVertexAttribArrayObjectivATI_c
    glGetVertexAttribdv_c
    glGetVertexAttribdvARB_c
    glGetVertexAttribdvNV_c
    glGetVertexAttribfv_c
    glGetVertexAttribfvARB_c
    glGetVertexAttribfvNV_c
    glGetVertexAttribIiv_c
    glGetVertexAttribIivEXT_c
    glGetVertexAttribIuiv_c
    glGetVertexAttribIuivEXT_c
    glGetVertexAttribiv_c
    glGetVertexAttribivARB_c
    glGetVertexAttribivNV_c
    glGetVertexAttribLdv_c
    glGetVertexAttribLdvEXT_c
    glGetVertexAttribLi64vNV_c
    glGetVertexAttribLui64vARB_c
    glGetVertexAttribLui64vNV_c
    glGetVertexAttribPointerv_c
    glGetVertexAttribPointervARB_c
    glGetVertexAttribPointervNV_c
    glGetVideoCaptureivNV_c
    glGetVideoCaptureStreamdvNV_c
    glGetVideoCaptureStreamfvNV_c
    glGetVideoCaptureStreamivNV_c
    glGetVideoi64vNV_c
    glGetVideoivNV_c
    glGetVideoui64vNV_c
    glGetVideouivNV_c
    glGetVkProcAddrNV_c
    glGlobalAlphaFactorbSUN
    glGlobalAlphaFactordSUN
    glGlobalAlphaFactorfSUN
    glGlobalAlphaFactoriSUN
    glGlobalAlphaFactorsSUN
    glGlobalAlphaFactorubSUN
    glGlobalAlphaFactoruiSUN
    glGlobalAlphaFactorusSUN
    glHint
    glHistogram
    glHistogramEXT
    glImageTransformParameterfHP
    glImageTransformParameterfvHP_c
    glImageTransformParameteriHP
    glImageTransformParameterivHP_c
    glImportSyncEXT
    glIndexd
    glIndexdv_c
    glIndexf
    glIndexFormatNV
    glIndexFuncEXT
    glIndexfv_c
    glIndexi
    glIndexiv_c
    glIndexMask
    glIndexMaterialEXT
    glIndexPointer_c
    glIndexPointerEXT_c
    glIndexPointerListIBM_c
    glIndexs
    glIndexsv_c
    glIndexub
    glIndexubv_c
    glInitNames
    glInsertComponentEXT
    glInsertEventMarkerEXT_c
    glInterleavedArrays_c
    glInterpolatePathsNV
    glInvalidateBufferData
    glInvalidateBufferSubData
    glInvalidateFramebuffer_c
    glInvalidateNamedFramebufferData_c
    glInvalidateNamedFramebufferSubData_c
    glInvalidateSubFramebuffer_c
    glInvalidateTexImage
    glInvalidateTexSubImage
    glIsAsyncMarkerSGIX
    glIsBuffer
    glIsBufferARB
    glIsBufferResidentNV
    glIsCommandListNV
    glIsEnabled
    glIsEnabledi
    glIsEnabledIndexedEXT
    glIsFenceAPPLE
    glIsFenceNV
    glIsFramebuffer
    glIsFramebufferEXT
    glIsImageHandleResidentARB
    glIsImageHandleResidentNV
    glIsList
    glIsNameAMD
    glIsNamedBufferResidentNV
    glIsNamedStringARB_c
    glIsObjectBufferATI
    glIsOcclusionQueryNV
    glIsPathNV
    glIsPointInFillPathNV
    glIsPointInStrokePathNV
    glIsProgram
    glIsProgramARB
    glIsProgramNV
    glIsProgramPipeline
    glIsQuery
    glIsQueryANGLE
    glIsQueryARB
    glIsRenderbuffer
    glIsRenderbufferEXT
    glIsSampler
    glIsShader
    glIsStateNV
    glIsSupportedREGAL_c
    glIsSync
    glIsTexture
    glIsTextureEXT
    glIsTextureHandleResidentARB
    glIsTextureHandleResidentNV
    glIsTransformFeedback
    glIsTransformFeedbackNV
    glIsVariantEnabledEXT
    glIsVertexArray
    glIsVertexArrayAPPLE
    glIsVertexAttribEnabledAPPLE
    glLabelObjectEXT_c
    glLGPUCopyImageSubDataNVX
    glLGPUInterlockNVX
    glLGPUNamedBufferSubDataNVX_c
    glLightEnviEXT
    glLightf
    glLightfv_c
    glLighti
    glLightiv_c
    glLightModelf
    glLightModelfv_c
    glLightModeli
    glLightModeliv_c
    glLightModelx
    glLightModelxv_c
    glLightx
    glLightxv_c
    glLineStipple
    glLineWidth
    glLineWidthx
    glLinkProgram
    glLinkProgramARB
    glListBase
    glListDrawCommandsStatesClientNV_c
    glLoadIdentity
    glLoadMatrixd_c
    glLoadMatrixf_c
    glLoadMatrixx_c
    glLoadName
    glLoadProgramNV_c
    glLoadTransposeMatrixd_c
    glLoadTransposeMatrixdARB_c
    glLoadTransposeMatrixf_c
    glLoadTransposeMatrixfARB_c
    glLockArraysEXT
    glLogicOp
    glLogMessageCallbackREGAL
    glMakeBufferNonResidentNV
    glMakeBufferResidentNV
    glMakeImageHandleNonResidentARB
    glMakeImageHandleNonResidentNV
    glMakeImageHandleResidentARB
    glMakeImageHandleResidentNV
    glMakeNamedBufferNonResidentNV
    glMakeNamedBufferResidentNV
    glMakeTextureHandleNonResidentARB
    glMakeTextureHandleNonResidentNV
    glMakeTextureHandleResidentARB
    glMakeTextureHandleResidentNV
    glMap1d_c
    glMap1f_c
    glMap2d_c
    glMap2f_c
    glMapBuffer_c
    glMapBufferARB_c
    glMapBufferRange_c
    glMapControlPointsNV_c
    glMapGrid1d
    glMapGrid1f
    glMapGrid2d
    glMapGrid2f
    glMapNamedBuffer_c
    glMapNamedBufferEXT_c
    glMapNamedBufferRange_c
    glMapNamedBufferRangeEXT_c
    glMapObjectBufferATI_c
    glMapParameterfvNV_c
    glMapParameterivNV_c
    glMapTexture2DINTEL_c
    glMapVertexAttrib1dAPPLE_c
    glMapVertexAttrib1fAPPLE_c
    glMapVertexAttrib2dAPPLE_c
    glMapVertexAttrib2fAPPLE_c
    glMaterialf
    glMaterialfv_c
    glMateriali
    glMaterialiv_c
    glMaterialx
    glMaterialxv_c
    glMatrixFrustumEXT
    glMatrixIndexPointerARB_c
    glMatrixIndexubvARB_c
    glMatrixIndexuivARB_c
    glMatrixIndexusvARB_c
    glMatrixLoad3x2fNV_c
    glMatrixLoad3x3fNV_c
    glMatrixLoaddEXT_c
    glMatrixLoadfEXT_c
    glMatrixLoadIdentityEXT
    glMatrixLoadTranspose3x3fNV_c
    glMatrixLoadTransposedEXT_c
    glMatrixLoadTransposefEXT_c
    glMatrixMode
    glMatrixMult3x2fNV_c
    glMatrixMult3x3fNV_c
    glMatrixMultdEXT_c
    glMatrixMultfEXT_c
    glMatrixMultTranspose3x3fNV_c
    glMatrixMultTransposedEXT_c
    glMatrixMultTransposefEXT_c
    glMatrixOrthoEXT
    glMatrixPopEXT
    glMatrixPushEXT
    glMatrixRotatedEXT
    glMatrixRotatefEXT
    glMatrixScaledEXT
    glMatrixScalefEXT
    glMatrixTranslatedEXT
    glMatrixTranslatefEXT
    glMaxShaderCompilerThreadsARB
    glMemoryBarrier
    glMemoryBarrierByRegion
    glMemoryBarrierEXT
    glMinmax
    glMinmaxEXT
    glMinSampleShading
    glMinSampleShadingARB
    glMulticastBarrierNV
    glMulticastBlitFramebufferNV
    glMulticastBufferSubDataNV_c
    glMulticastCopyBufferSubDataNV
    glMulticastCopyImageSubDataNV
    glMulticastFramebufferSampleLocationsfvNV_c
    glMulticastGetQueryObjecti64vNV_c
    glMulticastGetQueryObjectivNV_c
    glMulticastGetQueryObjectui64vNV_c
    glMulticastGetQueryObjectuivNV_c
    glMulticastWaitSyncNV
    glMultiDrawArrays_c
    glMultiDrawArraysEXT_c
    glMultiDrawArraysIndirect_c
    glMultiDrawArraysIndirectAMD_c
    glMultiDrawArraysIndirectBindlessCountNV_c
    glMultiDrawArraysIndirectBindlessNV_c
    glMultiDrawArraysIndirectCountARB_c
    glMultiDrawElementArrayAPPLE_c
    glMultiDrawElements_c
    glMultiDrawElementsBaseVertex_c
    glMultiDrawElementsEXT_c
    glMultiDrawElementsIndirect_c
    glMultiDrawElementsIndirectAMD_c
    glMultiDrawElementsIndirectBindlessCountNV_c
    glMultiDrawElementsIndirectBindlessNV_c
    glMultiDrawElementsIndirectCountARB_c
    glMultiDrawRangeElementArrayAPPLE_c
    glMultiModeDrawArraysIBM_c
    glMultiModeDrawElementsIBM_c
    glMultiTexBufferEXT
    glMultiTexCoord1d
    glMultiTexCoord1dARB
    glMultiTexCoord1dv_c
    glMultiTexCoord1dvARB_c
    glMultiTexCoord1f
    glMultiTexCoord1fARB
    glMultiTexCoord1fv_c
    glMultiTexCoord1fvARB_c
    glMultiTexCoord1hNV
    glMultiTexCoord1hvNV_c
    glMultiTexCoord1i
    glMultiTexCoord1iARB
    glMultiTexCoord1iv_c
    glMultiTexCoord1ivARB_c
    glMultiTexCoord1s
    glMultiTexCoord1sARB
    glMultiTexCoord1sv_c
    glMultiTexCoord1svARB_c
    glMultiTexCoord2d
    glMultiTexCoord2dARB
    glMultiTexCoord2dv_c
    glMultiTexCoord2dvARB_c
    glMultiTexCoord2f
    glMultiTexCoord2fARB
    glMultiTexCoord2fv_c
    glMultiTexCoord2fvARB_c
    glMultiTexCoord2hNV
    glMultiTexCoord2hvNV_c
    glMultiTexCoord2i
    glMultiTexCoord2iARB
    glMultiTexCoord2iv_c
    glMultiTexCoord2ivARB_c
    glMultiTexCoord2s
    glMultiTexCoord2sARB
    glMultiTexCoord2sv_c
    glMultiTexCoord2svARB_c
    glMultiTexCoord3d
    glMultiTexCoord3dARB
    glMultiTexCoord3dv_c
    glMultiTexCoord3dvARB_c
    glMultiTexCoord3f
    glMultiTexCoord3fARB
    glMultiTexCoord3fv_c
    glMultiTexCoord3fvARB_c
    glMultiTexCoord3hNV
    glMultiTexCoord3hvNV_c
    glMultiTexCoord3i
    glMultiTexCoord3iARB
    glMultiTexCoord3iv_c
    glMultiTexCoord3ivARB_c
    glMultiTexCoord3s
    glMultiTexCoord3sARB
    glMultiTexCoord3sv_c
    glMultiTexCoord3svARB_c
    glMultiTexCoord4d
    glMultiTexCoord4dARB
    glMultiTexCoord4dv_c
    glMultiTexCoord4dvARB_c
    glMultiTexCoord4f
    glMultiTexCoord4fARB
    glMultiTexCoord4fv_c
    glMultiTexCoord4fvARB_c
    glMultiTexCoord4hNV
    glMultiTexCoord4hvNV_c
    glMultiTexCoord4i
    glMultiTexCoord4iARB
    glMultiTexCoord4iv_c
    glMultiTexCoord4ivARB_c
    glMultiTexCoord4s
    glMultiTexCoord4sARB
    glMultiTexCoord4sv_c
    glMultiTexCoord4svARB_c
    glMultiTexCoord4x
    glMultiTexCoordP1ui
    glMultiTexCoordP1uiv_c
    glMultiTexCoordP2ui
    glMultiTexCoordP2uiv_c
    glMultiTexCoordP3ui
    glMultiTexCoordP3uiv_c
    glMultiTexCoordP4ui
    glMultiTexCoordP4uiv_c
    glMultiTexCoordPointerEXT_c
    glMultiTexEnvfEXT
    glMultiTexEnvfvEXT_c
    glMultiTexEnviEXT
    glMultiTexEnvivEXT_c
    glMultiTexGendEXT
    glMultiTexGendvEXT_c
    glMultiTexGenfEXT
    glMultiTexGenfvEXT_c
    glMultiTexGeniEXT
    glMultiTexGenivEXT_c
    glMultiTexImage1DEXT_c
    glMultiTexImage2DEXT_c
    glMultiTexImage3DEXT_c
    glMultiTexParameterfEXT
    glMultiTexParameterfvEXT_c
    glMultiTexParameteriEXT
    glMultiTexParameterIivEXT_c
    glMultiTexParameterIuivEXT_c
    glMultiTexParameterivEXT_c
    glMultiTexRenderbufferEXT
    glMultiTexSubImage1DEXT_c
    glMultiTexSubImage2DEXT_c
    glMultiTexSubImage3DEXT_c
    glMultMatrixd_c
    glMultMatrixf_c
    glMultMatrixx_c
    glMultTransposeMatrixd_c
    glMultTransposeMatrixdARB_c
    glMultTransposeMatrixf_c
    glMultTransposeMatrixfARB_c
    glNamedBufferData_c
    glNamedBufferDataEXT_c
    glNamedBufferStorage_c
    glNamedBufferStorageEXT_c
    glNamedBufferSubData_c
    glNamedBufferSubDataEXT_c
    glNamedCopyBufferSubDataEXT
    glNamedFramebufferDrawBuffer
    glNamedFramebufferDrawBuffers_c
    glNamedFramebufferParameteri
    glNamedFramebufferParameteriEXT
    glNamedFramebufferReadBuffer
    glNamedFramebufferRenderbuffer
    glNamedFramebufferRenderbufferEXT
    glNamedFramebufferSampleLocationsfvARB_c
    glNamedFramebufferSampleLocationsfvNV_c
    glNamedFramebufferTexture
    glNamedFramebufferTexture1DEXT
    glNamedFramebufferTexture2DEXT
    glNamedFramebufferTexture3DEXT
    glNamedFramebufferTextureEXT
    glNamedFramebufferTextureFaceEXT
    glNamedFramebufferTextureLayer
    glNamedFramebufferTextureLayerEXT
    glNamedProgramLocalParameter4dEXT
    glNamedProgramLocalParameter4dvEXT_c
    glNamedProgramLocalParameter4fEXT
    glNamedProgramLocalParameter4fvEXT_c
    glNamedProgramLocalParameterI4iEXT
    glNamedProgramLocalParameterI4ivEXT_c
    glNamedProgramLocalParameterI4uiEXT
    glNamedProgramLocalParameterI4uivEXT_c
    glNamedProgramLocalParameters4fvEXT_c
    glNamedProgramLocalParametersI4ivEXT_c
    glNamedProgramLocalParametersI4uivEXT_c
    glNamedProgramStringEXT_c
    glNamedRenderbufferStorage
    glNamedRenderbufferStorageEXT
    glNamedRenderbufferStorageMultisample
    glNamedRenderbufferStorageMultisampleCoverageEXT
    glNamedRenderbufferStorageMultisampleEXT
    glNamedStringARB_c
    glNewBufferRegion
    glNewList
    glNewObjectBufferATI_c
    glNormal3b
    glNormal3bv_c
    glNormal3d
    glNormal3dv_c
    glNormal3f
    glNormal3fv_c
    glNormal3fVertex3fSUN
    glNormal3fVertex3fvSUN_c
    glNormal3hNV
    glNormal3hvNV_c
    glNormal3i
    glNormal3iv_c
    glNormal3s
    glNormal3sv_c
    glNormal3x
    glNormalFormatNV
    glNormalP3ui
    glNormalP3uiv_c
    glNormalPointer_c
    glNormalPointerEXT_c
    glNormalPointerListIBM_c
    glNormalPointervINTEL_c
    glNormalStream3bATI
    glNormalStream3bvATI_c
    glNormalStream3dATI
    glNormalStream3dvATI_c
    glNormalStream3fATI
    glNormalStream3fvATI_c
    glNormalStream3iATI
    glNormalStream3ivATI_c
    glNormalStream3sATI
    glNormalStream3svATI_c
    glObjectLabel_c
    glObjectPtrLabel_c
    glObjectPurgeableAPPLE
    glObjectUnpurgeableAPPLE
    glOrtho
    glOrthof
    glOrthofOES
    glOrthox
    glPassTexCoordATI
    glPassThrough
    glPatchParameterfv_c
    glPatchParameteri
    glPathColorGenNV_c
    glPathCommandsNV_c
    glPathCoordsNV_c
    glPathCoverDepthFuncNV
    glPathDashArrayNV_c
    glPathFogGenNV
    glPathGlyphIndexArrayNV_c
    glPathGlyphIndexRangeNV_c
    glPathGlyphRangeNV_c
    glPathGlyphsNV_c
    glPathMemoryGlyphIndexArrayNV_c
    glPathParameterfNV
    glPathParameterfvNV_c
    glPathParameteriNV
    glPathParameterivNV_c
    glPathStencilDepthOffsetNV
    glPathStencilFuncNV
    glPathStringNV_c
    glPathSubCommandsNV_c
    glPathSubCoordsNV_c
    glPathTexGenNV_c
    glPauseTransformFeedback
    glPauseTransformFeedbackNV
    glPixelDataRangeNV_c
    glPixelMapfv_c
    glPixelMapuiv_c
    glPixelMapusv_c
    glPixelStoref
    glPixelStorei
    glPixelTexGenSGIX
    glPixelTransferf
    glPixelTransferi
    glPixelTransformParameterfEXT
    glPixelTransformParameterfvEXT_c
    glPixelTransformParameteriEXT
    glPixelTransformParameterivEXT_c
    glPixelZoom
    glPNTrianglesfATI
    glPNTrianglesiATI
    glPointAlongPathNV_c
    glPointParameterf
    glPointParameterfARB
    glPointParameterfEXT
    glPointParameterfv_c
    glPointParameterfvARB_c
    glPointParameterfvEXT_c
    glPointParameteri
    glPointParameteriNV
    glPointParameteriv_c
    glPointParameterivNV_c
    glPointParameterx
    glPointParameterxv_c
    glPointSize
    glPointSizePointerOES_c
    glPointSizex
    glPollAsyncSGIX_c
    glPolygonMode
    glPolygonOffset
    glPolygonOffsetClampEXT
    glPolygonOffsetEXT
    glPolygonOffsetx
    glPolygonStipple_c
    glPopAttrib
    glPopClientAttrib
    glPopDebugGroup
    glPopGroupMarkerEXT
    glPopMatrix
    glPopName
    glPresentFrameDualFillNV
    glPresentFrameKeyedNV
    glPrimitiveBoundingBoxARB
    glPrimitiveRestartIndex
    glPrimitiveRestartIndexNV
    glPrimitiveRestartNV
    glPrioritizeTextures_c
    glPrioritizeTexturesEXT_c
    glProgramBinary_c
    glProgramBufferParametersfvNV_c
    glProgramBufferParametersIivNV_c
    glProgramBufferParametersIuivNV_c
    glProgramEnvParameter4dARB
    glProgramEnvParameter4dvARB_c
    glProgramEnvParameter4fARB
    glProgramEnvParameter4fvARB_c
    glProgramEnvParameterI4iNV
    glProgramEnvParameterI4ivNV_c
    glProgramEnvParameterI4uiNV
    glProgramEnvParameterI4uivNV_c
    glProgramEnvParameters4fvEXT_c
    glProgramEnvParametersI4ivNV_c
    glProgramEnvParametersI4uivNV_c
    glProgramLocalParameter4dARB
    glProgramLocalParameter4dvARB_c
    glProgramLocalParameter4fARB
    glProgramLocalParameter4fvARB_c
    glProgramLocalParameterI4iNV
    glProgramLocalParameterI4ivNV_c
    glProgramLocalParameterI4uiNV
    glProgramLocalParameterI4uivNV_c
    glProgramLocalParameters4fvEXT_c
    glProgramLocalParametersI4ivNV_c
    glProgramLocalParametersI4uivNV_c
    glProgramNamedParameter4dNV_c
    glProgramNamedParameter4dvNV_c
    glProgramNamedParameter4fNV_c
    glProgramNamedParameter4fvNV_c
    glProgramParameter4dNV
    glProgramParameter4dvNV_c
    glProgramParameter4fNV
    glProgramParameter4fvNV_c
    glProgramParameteri
    glProgramParameteriARB
    glProgramParameteriEXT
    glProgramParameters4dvNV_c
    glProgramParameters4fvNV_c
    glProgramPathFragmentInputGenNV_c
    glProgramStringARB_c
    glProgramUniform1d
    glProgramUniform1dv_c
    glProgramUniform1f
    glProgramUniform1fEXT
    glProgramUniform1fv_c
    glProgramUniform1fvEXT_c
    glProgramUniform1i
    glProgramUniform1i64ARB
    glProgramUniform1i64NV
    glProgramUniform1i64vARB_c
    glProgramUniform1i64vNV_c
    glProgramUniform1iEXT
    glProgramUniform1iv_c
    glProgramUniform1ivEXT_c
    glProgramUniform1ui
    glProgramUniform1ui64ARB
    glProgramUniform1ui64NV
    glProgramUniform1ui64vARB_c
    glProgramUniform1ui64vNV_c
    glProgramUniform1uiEXT
    glProgramUniform1uiv_c
    glProgramUniform1uivEXT_c
    glProgramUniform2d
    glProgramUniform2dv_c
    glProgramUniform2f
    glProgramUniform2fEXT
    glProgramUniform2fv_c
    glProgramUniform2fvEXT_c
    glProgramUniform2i
    glProgramUniform2i64ARB
    glProgramUniform2i64NV
    glProgramUniform2i64vARB_c
    glProgramUniform2i64vNV_c
    glProgramUniform2iEXT
    glProgramUniform2iv_c
    glProgramUniform2ivEXT_c
    glProgramUniform2ui
    glProgramUniform2ui64ARB
    glProgramUniform2ui64NV
    glProgramUniform2ui64vARB_c
    glProgramUniform2ui64vNV_c
    glProgramUniform2uiEXT
    glProgramUniform2uiv_c
    glProgramUniform2uivEXT_c
    glProgramUniform3d
    glProgramUniform3dv_c
    glProgramUniform3f
    glProgramUniform3fEXT
    glProgramUniform3fv_c
    glProgramUniform3fvEXT_c
    glProgramUniform3i
    glProgramUniform3i64ARB
    glProgramUniform3i64NV
    glProgramUniform3i64vARB_c
    glProgramUniform3i64vNV_c
    glProgramUniform3iEXT
    glProgramUniform3iv_c
    glProgramUniform3ivEXT_c
    glProgramUniform3ui
    glProgramUniform3ui64ARB
    glProgramUniform3ui64NV
    glProgramUniform3ui64vARB_c
    glProgramUniform3ui64vNV_c
    glProgramUniform3uiEXT
    glProgramUniform3uiv_c
    glProgramUniform3uivEXT_c
    glProgramUniform4d
    glProgramUniform4dv_c
    glProgramUniform4f
    glProgramUniform4fEXT
    glProgramUniform4fv_c
    glProgramUniform4fvEXT_c
    glProgramUniform4i
    glProgramUniform4i64ARB
    glProgramUniform4i64NV
    glProgramUniform4i64vARB_c
    glProgramUniform4i64vNV_c
    glProgramUniform4iEXT
    glProgramUniform4iv_c
    glProgramUniform4ivEXT_c
    glProgramUniform4ui
    glProgramUniform4ui64ARB
    glProgramUniform4ui64NV
    glProgramUniform4ui64vARB_c
    glProgramUniform4ui64vNV_c
    glProgramUniform4uiEXT
    glProgramUniform4uiv_c
    glProgramUniform4uivEXT_c
    glProgramUniformHandleui64ARB
    glProgramUniformHandleui64NV
    glProgramUniformHandleui64vARB_c
    glProgramUniformHandleui64vNV_c
    glProgramUniformMatrix2dv_c
    glProgramUniformMatrix2fv_c
    glProgramUniformMatrix2fvEXT_c
    glProgramUniformMatrix2x3dv_c
    glProgramUniformMatrix2x3fv_c
    glProgramUniformMatrix2x3fvEXT_c
    glProgramUniformMatrix2x4dv_c
    glProgramUniformMatrix2x4fv_c
    glProgramUniformMatrix2x4fvEXT_c
    glProgramUniformMatrix3dv_c
    glProgramUniformMatrix3fv_c
    glProgramUniformMatrix3fvEXT_c
    glProgramUniformMatrix3x2dv_c
    glProgramUniformMatrix3x2fv_c
    glProgramUniformMatrix3x2fvEXT_c
    glProgramUniformMatrix3x4dv_c
    glProgramUniformMatrix3x4fv_c
    glProgramUniformMatrix3x4fvEXT_c
    glProgramUniformMatrix4dv_c
    glProgramUniformMatrix4fv_c
    glProgramUniformMatrix4fvEXT_c
    glProgramUniformMatrix4x2dv_c
    glProgramUniformMatrix4x2fv_c
    glProgramUniformMatrix4x2fvEXT_c
    glProgramUniformMatrix4x3dv_c
    glProgramUniformMatrix4x3fv_c
    glProgramUniformMatrix4x3fvEXT_c
    glProgramUniformui64NV
    glProgramUniformui64vNV_c
    glProgramVertexLimitNV
    glProvokingVertex
    glProvokingVertexEXT
    glPushAttrib
    glPushClientAttrib
    glPushClientAttribDefaultEXT
    glPushDebugGroup_c
    glPushGroupMarkerEXT_c
    glPushMatrix
    glPushName
    glQueryCounter
    glQueryCounterANGLE
    glQueryObjectParameteruiAMD
    glRasterPos2d
    glRasterPos2dv_c
    glRasterPos2f
    glRasterPos2fv_c
    glRasterPos2i
    glRasterPos2iv_c
    glRasterPos2s
    glRasterPos2sv_c
    glRasterPos3d
    glRasterPos3dv_c
    glRasterPos3f
    glRasterPos3fv_c
    glRasterPos3i
    glRasterPos3iv_c
    glRasterPos3s
    glRasterPos3sv_c
    glRasterPos4d
    glRasterPos4dv_c
    glRasterPos4f
    glRasterPos4fv_c
    glRasterPos4i
    glRasterPos4iv_c
    glRasterPos4s
    glRasterPos4sv_c
    glRasterSamplesEXT
    glReadBuffer
    glReadBufferRegion
    glReadnPixels_c
    glReadnPixelsARB_c
    glReadPixels_c
    glReadVideoPixelsSUN_c
    glRectd
    glRectdv_c
    glRectf
    glRectfv_c
    glRecti
    glRectiv_c
    glRects
    glRectsv_c
    glReferencePlaneSGIX_c
    glReleaseShaderCompiler
    glRenderbufferStorage
    glRenderbufferStorageEXT
    glRenderbufferStorageMultisample
    glRenderbufferStorageMultisampleANGLE
    glRenderbufferStorageMultisampleCoverageNV
    glRenderbufferStorageMultisampleEXT
    glRenderGpuMaskNV
    glRenderMode
    glReplacementCodePointerSUN_c
    glReplacementCodeubSUN
    glReplacementCodeubvSUN_c
    glReplacementCodeuiColor3fVertex3fSUN
    glReplacementCodeuiColor3fVertex3fvSUN_c
    glReplacementCodeuiColor4fNormal3fVertex3fSUN
    glReplacementCodeuiColor4fNormal3fVertex3fvSUN_c
    glReplacementCodeuiColor4ubVertex3fSUN
    glReplacementCodeuiColor4ubVertex3fvSUN_c
    glReplacementCodeuiNormal3fVertex3fSUN
    glReplacementCodeuiNormal3fVertex3fvSUN_c
    glReplacementCodeuiSUN
    glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fSUN
    glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN_c
    glReplacementCodeuiTexCoord2fNormal3fVertex3fSUN
    glReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN_c
    glReplacementCodeuiTexCoord2fVertex3fSUN
    glReplacementCodeuiTexCoord2fVertex3fvSUN_c
    glReplacementCodeuiVertex3fSUN
    glReplacementCodeuiVertex3fvSUN_c
    glReplacementCodeuivSUN_c
    glReplacementCodeusSUN
    glReplacementCodeusvSUN_c
    glRequestResidentProgramsNV_c
    glResetHistogram
    glResetHistogramEXT
    glResetMinmax
    glResetMinmaxEXT
    glResizeBuffersMESA
    glResumeTransformFeedback
    glResumeTransformFeedbackNV
    glRotated
    glRotatef
    glRotatex
    glSampleCoverage
    glSampleCoverageARB
    glSampleCoveragex
    glSampleMapATI
    glSampleMaskEXT
    glSampleMaski
    glSampleMaskIndexedNV
    glSampleMaskSGIS
    glSamplePatternEXT
    glSamplePatternSGIS
    glSamplerParameterf
    glSamplerParameterfv_c
    glSamplerParameteri
    glSamplerParameterIiv_c
    glSamplerParameterIuiv_c
    glSamplerParameteriv_c
    glScaled
    glScalef
    glScalex
    glScissor
    glScissorArrayv_c
    glScissorIndexed
    glScissorIndexedv_c
    glSecondaryColor3b
    glSecondaryColor3bEXT
    glSecondaryColor3bv_c
    glSecondaryColor3bvEXT_c
    glSecondaryColor3d
    glSecondaryColor3dEXT
    glSecondaryColor3dv_c
    glSecondaryColor3dvEXT_c
    glSecondaryColor3f
    glSecondaryColor3fEXT
    glSecondaryColor3fv_c
    glSecondaryColor3fvEXT_c
    glSecondaryColor3hNV
    glSecondaryColor3hvNV_c
    glSecondaryColor3i
    glSecondaryColor3iEXT
    glSecondaryColor3iv_c
    glSecondaryColor3ivEXT_c
    glSecondaryColor3s
    glSecondaryColor3sEXT
    glSecondaryColor3sv_c
    glSecondaryColor3svEXT_c
    glSecondaryColor3ub
    glSecondaryColor3ubEXT
    glSecondaryColor3ubv_c
    glSecondaryColor3ubvEXT_c
    glSecondaryColor3ui
    glSecondaryColor3uiEXT
    glSecondaryColor3uiv_c
    glSecondaryColor3uivEXT_c
    glSecondaryColor3us
    glSecondaryColor3usEXT
    glSecondaryColor3usv_c
    glSecondaryColor3usvEXT_c
    glSecondaryColorFormatNV
    glSecondaryColorP3ui
    glSecondaryColorP3uiv_c
    glSecondaryColorPointer_c
    glSecondaryColorPointerEXT_c
    glSecondaryColorPointerListIBM_c
    glSelectBuffer_c
    glSelectPerfMonitorCountersAMD_c
    glSeparableFilter2D_c
    glSeparableFilter2DEXT_c
    glSetFenceAPPLE
    glSetFenceNV
    glSetFragmentShaderConstantATI_c
    glSetInvariantEXT_c
    glSetLocalConstantEXT_c
    glSetMultisamplefvAMD_c
    glShadeModel
    glShaderBinary_c
    glShaderOp1EXT
    glShaderOp2EXT
    glShaderOp3EXT
    glShaderSource_c
    glShaderSourceARB_c
    glShaderStorageBlockBinding
    glSharpenTexFuncSGIS_c
    glSignalVkFenceNV
    glSignalVkSemaphoreNV
    glSpecializeShaderARB_c
    glSpriteParameterfSGIX
    glSpriteParameterfvSGIX_c
    glSpriteParameteriSGIX
    glSpriteParameterivSGIX_c
    glStateCaptureNV
    glStencilFillPathInstancedNV_c
    glStencilFillPathNV
    glStencilFunc
    glStencilFuncSeparate
    glStencilFuncSeparateATI
    glStencilMask
    glStencilMaskSeparate
    glStencilOp
    glStencilOpSeparate
    glStencilOpSeparateATI
    glStencilOpValueAMD
    glStencilStrokePathInstancedNV_c
    glStencilStrokePathNV
    glStencilThenCoverFillPathInstancedNV_c
    glStencilThenCoverFillPathNV
    glStencilThenCoverStrokePathInstancedNV_c
    glStencilThenCoverStrokePathNV
    glStringMarkerGREMEDY_c
    glSubpixelPrecisionBiasNV
    glSwizzleEXT
    glSyncTextureINTEL
    glTagSampleBufferSGIX
    glTangentPointerEXT_c
    glTbufferMask3DFX
    glTessellationFactorAMD
    glTessellationModeAMD
    glTestFenceAPPLE
    glTestFenceNV
    glTestObjectAPPLE
    glTexBuffer
    glTexBufferARB
    glTexBufferEXT
    glTexBufferRange
    glTexBumpParameterfvATI_c
    glTexBumpParameterivATI_c
    glTexCoord1d
    glTexCoord1dv_c
    glTexCoord1f
    glTexCoord1fv_c
    glTexCoord1hNV
    glTexCoord1hvNV_c
    glTexCoord1i
    glTexCoord1iv_c
    glTexCoord1s
    glTexCoord1sv_c
    glTexCoord2d
    glTexCoord2dv_c
    glTexCoord2f
    glTexCoord2fColor3fVertex3fSUN
    glTexCoord2fColor3fVertex3fvSUN_c
    glTexCoord2fColor4fNormal3fVertex3fSUN
    glTexCoord2fColor4fNormal3fVertex3fvSUN_c
    glTexCoord2fColor4ubVertex3fSUN
    glTexCoord2fColor4ubVertex3fvSUN_c
    glTexCoord2fNormal3fVertex3fSUN
    glTexCoord2fNormal3fVertex3fvSUN_c
    glTexCoord2fv_c
    glTexCoord2fVertex3fSUN
    glTexCoord2fVertex3fvSUN_c
    glTexCoord2hNV
    glTexCoord2hvNV_c
    glTexCoord2i
    glTexCoord2iv_c
    glTexCoord2s
    glTexCoord2sv_c
    glTexCoord3d
    glTexCoord3dv_c
    glTexCoord3f
    glTexCoord3fv_c
    glTexCoord3hNV
    glTexCoord3hvNV_c
    glTexCoord3i
    glTexCoord3iv_c
    glTexCoord3s
    glTexCoord3sv_c
    glTexCoord4d
    glTexCoord4dv_c
    glTexCoord4f
    glTexCoord4fColor4fNormal3fVertex4fSUN
    glTexCoord4fColor4fNormal3fVertex4fvSUN_c
    glTexCoord4fv_c
    glTexCoord4fVertex4fSUN
    glTexCoord4fVertex4fvSUN_c
    glTexCoord4hNV
    glTexCoord4hvNV_c
    glTexCoord4i
    glTexCoord4iv_c
    glTexCoord4s
    glTexCoord4sv_c
    glTexCoordFormatNV
    glTexCoordP1ui
    glTexCoordP1uiv_c
    glTexCoordP2ui
    glTexCoordP2uiv_c
    glTexCoordP3ui
    glTexCoordP3uiv_c
    glTexCoordP4ui
    glTexCoordP4uiv_c
    glTexCoordPointer_c
    glTexCoordPointerEXT_c
    glTexCoordPointerListIBM_c
    glTexCoordPointervINTEL_c
    glTexEnvf
    glTexEnvfv_c
    glTexEnvi
    glTexEnviv_c
    glTexEnvx
    glTexEnvxv_c
    glTexFilterFuncSGIS_c
    glTexGend
    glTexGendv_c
    glTexGenf
    glTexGenfv_c
    glTexGeni
    glTexGeniv_c
    glTexImage1D_c
    glTexImage2D_c
    glTexImage2DMultisample
    glTexImage2DMultisampleCoverageNV
    glTexImage3D_c
    glTexImage3DEXT_c
    glTexImage3DMultisample
    glTexImage3DMultisampleCoverageNV
    glTexImage4DSGIS_c
    glTexPageCommitmentARB
    glTexParameterf
    glTexParameterfv_c
    glTexParameteri
    glTexParameterIiv_c
    glTexParameterIivEXT_c
    glTexParameterIuiv_c
    glTexParameterIuivEXT_c
    glTexParameteriv_c
    glTexParameterx
    glTexParameterxv_c
    glTexRenderbufferNV
    glTexScissorFuncINTEL
    glTexScissorINTEL
    glTexStorage1D
    glTexStorage2D
    glTexStorage2DMultisample
    glTexStorage3D
    glTexStorage3DMultisample
    glTexStorageSparseAMD
    glTexSubImage1D_c
    glTexSubImage1DEXT_c
    glTexSubImage2D_c
    glTexSubImage2DEXT_c
    glTexSubImage3D_c
    glTexSubImage3DEXT_c
    glTexSubImage4DSGIS_c
    glTextureBarrier
    glTextureBarrierNV
    glTextureBuffer
    glTextureBufferEXT
    glTextureBufferRange
    glTextureBufferRangeEXT
    glTextureFogSGIX
    glTextureImage1DEXT_c
    glTextureImage2DEXT_c
    glTextureImage2DMultisampleCoverageNV
    glTextureImage2DMultisampleNV
    glTextureImage3DEXT_c
    glTextureImage3DMultisampleCoverageNV
    glTextureImage3DMultisampleNV
    glTextureLightEXT
    glTextureMaterialEXT
    glTextureNormalEXT
    glTexturePageCommitmentEXT
    glTextureParameterf
    glTextureParameterfEXT
    glTextureParameterfv_c
    glTextureParameterfvEXT_c
    glTextureParameteri
    glTextureParameteriEXT
    glTextureParameterIiv_c
    glTextureParameterIivEXT_c
    glTextureParameterIuiv_c
    glTextureParameterIuivEXT_c
    glTextureParameteriv_c
    glTextureParameterivEXT_c
    glTextureRangeAPPLE_c
    glTextureRenderbufferEXT
    glTextureStorage1D
    glTextureStorage1DEXT
    glTextureStorage2D
    glTextureStorage2DEXT
    glTextureStorage2DMultisample
    glTextureStorage2DMultisampleEXT
    glTextureStorage3D
    glTextureStorage3DEXT
    glTextureStorage3DMultisample
    glTextureStorage3DMultisampleEXT
    glTextureStorageSparseAMD
    glTextureSubImage1D_c
    glTextureSubImage1DEXT_c
    glTextureSubImage2D_c
    glTextureSubImage2DEXT_c
    glTextureSubImage3D_c
    glTextureSubImage3DEXT_c
    glTextureView
    glTrackMatrixNV
    glTransformFeedbackAttribsNV_c
    glTransformFeedbackBufferBase
    glTransformFeedbackBufferRange
    glTransformFeedbackVaryings_c
    glTransformFeedbackVaryingsEXT_c
    glTransformFeedbackVaryingsNV_c
    glTransformPathNV_c
    glTranslated
    glTranslatef
    glTranslatex
    glUniform1d
    glUniform1dv_c
    glUniform1f
    glUniform1fARB
    glUniform1fv_c
    glUniform1fvARB_c
    glUniform1i
    glUniform1i64ARB
    glUniform1i64NV
    glUniform1i64vARB_c
    glUniform1i64vNV_c
    glUniform1iARB
    glUniform1iv_c
    glUniform1ivARB_c
    glUniform1ui
    glUniform1ui64ARB
    glUniform1ui64NV
    glUniform1ui64vARB_c
    glUniform1ui64vNV_c
    glUniform1uiEXT
    glUniform1uiv_c
    glUniform1uivEXT_c
    glUniform2d
    glUniform2dv_c
    glUniform2f
    glUniform2fARB
    glUniform2fv_c
    glUniform2fvARB_c
    glUniform2i
    glUniform2i64ARB
    glUniform2i64NV
    glUniform2i64vARB_c
    glUniform2i64vNV_c
    glUniform2iARB
    glUniform2iv_c
    glUniform2ivARB_c
    glUniform2ui
    glUniform2ui64ARB
    glUniform2ui64NV
    glUniform2ui64vARB_c
    glUniform2ui64vNV_c
    glUniform2uiEXT
    glUniform2uiv_c
    glUniform2uivEXT_c
    glUniform3d
    glUniform3dv_c
    glUniform3f
    glUniform3fARB
    glUniform3fv_c
    glUniform3fvARB_c
    glUniform3i
    glUniform3i64ARB
    glUniform3i64NV
    glUniform3i64vARB_c
    glUniform3i64vNV_c
    glUniform3iARB
    glUniform3iv_c
    glUniform3ivARB_c
    glUniform3ui
    glUniform3ui64ARB
    glUniform3ui64NV
    glUniform3ui64vARB_c
    glUniform3ui64vNV_c
    glUniform3uiEXT
    glUniform3uiv_c
    glUniform3uivEXT_c
    glUniform4d
    glUniform4dv_c
    glUniform4f
    glUniform4fARB
    glUniform4fv_c
    glUniform4fvARB_c
    glUniform4i
    glUniform4i64ARB
    glUniform4i64NV
    glUniform4i64vARB_c
    glUniform4i64vNV_c
    glUniform4iARB
    glUniform4iv_c
    glUniform4ivARB_c
    glUniform4ui
    glUniform4ui64ARB
    glUniform4ui64NV
    glUniform4ui64vARB_c
    glUniform4ui64vNV_c
    glUniform4uiEXT
    glUniform4uiv_c
    glUniform4uivEXT_c
    glUniformBlockBinding
    glUniformBufferEXT
    glUniformHandleui64ARB
    glUniformHandleui64NV
    glUniformHandleui64vARB_c
    glUniformHandleui64vNV_c
    glUniformMatrix2dv_c
    glUniformMatrix2fv_c
    glUniformMatrix2fvARB_c
    glUniformMatrix2x3dv_c
    glUniformMatrix2x3fv_c
    glUniformMatrix2x4dv_c
    glUniformMatrix2x4fv_c
    glUniformMatrix3dv_c
    glUniformMatrix3fv_c
    glUniformMatrix3fvARB_c
    glUniformMatrix3x2dv_c
    glUniformMatrix3x2fv_c
    glUniformMatrix3x4dv_c
    glUniformMatrix3x4fv_c
    glUniformMatrix4dv_c
    glUniformMatrix4fv_c
    glUniformMatrix4fvARB_c
    glUniformMatrix4x2dv_c
    glUniformMatrix4x2fv_c
    glUniformMatrix4x3dv_c
    glUniformMatrix4x3fv_c
    glUniformSubroutinesuiv_c
    glUniformui64NV
    glUniformui64vNV_c
    glUnlockArraysEXT
    glUnmapBuffer
    glUnmapBufferARB
    glUnmapNamedBuffer
    glUnmapNamedBufferEXT
    glUnmapObjectBufferATI
    glUnmapTexture2DINTEL
    glUpdateObjectBufferATI_c
    glUseProgram
    glUseProgramObjectARB
    glUseProgramStages
    glUseShaderProgramEXT
    glValidateProgram
    glValidateProgramARB
    glValidateProgramPipeline
    glVariantArrayObjectATI
    glVariantbvEXT_c
    glVariantdvEXT_c
    glVariantfvEXT_c
    glVariantivEXT_c
    glVariantPointerEXT_c
    glVariantsvEXT_c
    glVariantubvEXT_c
    glVariantuivEXT_c
    glVariantusvEXT_c
    glVDPAUFiniNV
    glVDPAUGetSurfaceivNV_c
    glVDPAUInitNV_c
    glVDPAUIsSurfaceNV
    glVDPAUMapSurfacesNV_c
    glVDPAURegisterOutputSurfaceNV_c
    glVDPAURegisterVideoSurfaceNV_c
    glVDPAUSurfaceAccessNV
    glVDPAUUnmapSurfacesNV_c
    glVDPAUUnregisterSurfaceNV
    glVertex2d
    glVertex2dv_c
    glVertex2f
    glVertex2fv_c
    glVertex2hNV
    glVertex2hvNV_c
    glVertex2i
    glVertex2iv_c
    glVertex2s
    glVertex2sv_c
    glVertex3d
    glVertex3dv_c
    glVertex3f
    glVertex3fv_c
    glVertex3hNV
    glVertex3hvNV_c
    glVertex3i
    glVertex3iv_c
    glVertex3s
    glVertex3sv_c
    glVertex4d
    glVertex4dv_c
    glVertex4f
    glVertex4fv_c
    glVertex4hNV
    glVertex4hvNV_c
    glVertex4i
    glVertex4iv_c
    glVertex4s
    glVertex4sv_c
    glVertexArrayAttribBinding
    glVertexArrayAttribFormat
    glVertexArrayAttribIFormat
    glVertexArrayAttribLFormat
    glVertexArrayBindingDivisor
    glVertexArrayBindVertexBufferEXT
    glVertexArrayColorOffsetEXT
    glVertexArrayEdgeFlagOffsetEXT
    glVertexArrayElementBuffer
    glVertexArrayFogCoordOffsetEXT
    glVertexArrayIndexOffsetEXT
    glVertexArrayMultiTexCoordOffsetEXT
    glVertexArrayNormalOffsetEXT
    glVertexArrayParameteriAPPLE
    glVertexArrayRangeAPPLE_c
    glVertexArrayRangeNV_c
    glVertexArraySecondaryColorOffsetEXT
    glVertexArrayTexCoordOffsetEXT
    glVertexArrayVertexAttribBindingEXT
    glVertexArrayVertexAttribDivisorEXT
    glVertexArrayVertexAttribFormatEXT
    glVertexArrayVertexAttribIFormatEXT
    glVertexArrayVertexAttribIOffsetEXT
    glVertexArrayVertexAttribLFormatEXT
    glVertexArrayVertexAttribLOffsetEXT
    glVertexArrayVertexAttribOffsetEXT
    glVertexArrayVertexBindingDivisorEXT
    glVertexArrayVertexBuffer
    glVertexArrayVertexBuffers_c
    glVertexArrayVertexOffsetEXT
    glVertexAttrib1d
    glVertexAttrib1dARB
    glVertexAttrib1dNV
    glVertexAttrib1dv_c
    glVertexAttrib1dvARB_c
    glVertexAttrib1dvNV_c
    glVertexAttrib1f
    glVertexAttrib1fARB
    glVertexAttrib1fNV
    glVertexAttrib1fv_c
    glVertexAttrib1fvARB_c
    glVertexAttrib1fvNV_c
    glVertexAttrib1hNV
    glVertexAttrib1hvNV_c
    glVertexAttrib1s
    glVertexAttrib1sARB
    glVertexAttrib1sNV
    glVertexAttrib1sv_c
    glVertexAttrib1svARB_c
    glVertexAttrib1svNV_c
    glVertexAttrib2d
    glVertexAttrib2dARB
    glVertexAttrib2dNV
    glVertexAttrib2dv_c
    glVertexAttrib2dvARB_c
    glVertexAttrib2dvNV_c
    glVertexAttrib2f
    glVertexAttrib2fARB
    glVertexAttrib2fNV
    glVertexAttrib2fv_c
    glVertexAttrib2fvARB_c
    glVertexAttrib2fvNV_c
    glVertexAttrib2hNV
    glVertexAttrib2hvNV_c
    glVertexAttrib2s
    glVertexAttrib2sARB
    glVertexAttrib2sNV
    glVertexAttrib2sv_c
    glVertexAttrib2svARB_c
    glVertexAttrib2svNV_c
    glVertexAttrib3d
    glVertexAttrib3dARB
    glVertexAttrib3dNV
    glVertexAttrib3dv_c
    glVertexAttrib3dvARB_c
    glVertexAttrib3dvNV_c
    glVertexAttrib3f
    glVertexAttrib3fARB
    glVertexAttrib3fNV
    glVertexAttrib3fv_c
    glVertexAttrib3fvARB_c
    glVertexAttrib3fvNV_c
    glVertexAttrib3hNV
    glVertexAttrib3hvNV_c
    glVertexAttrib3s
    glVertexAttrib3sARB
    glVertexAttrib3sNV
    glVertexAttrib3sv_c
    glVertexAttrib3svARB_c
    glVertexAttrib3svNV_c
    glVertexAttrib4bv_c
    glVertexAttrib4bvARB_c
    glVertexAttrib4d
    glVertexAttrib4dARB
    glVertexAttrib4dNV
    glVertexAttrib4dv_c
    glVertexAttrib4dvARB_c
    glVertexAttrib4dvNV_c
    glVertexAttrib4f
    glVertexAttrib4fARB
    glVertexAttrib4fNV
    glVertexAttrib4fv_c
    glVertexAttrib4fvARB_c
    glVertexAttrib4fvNV_c
    glVertexAttrib4hNV
    glVertexAttrib4hvNV_c
    glVertexAttrib4iv_c
    glVertexAttrib4ivARB_c
    glVertexAttrib4Nbv_c
    glVertexAttrib4NbvARB_c
    glVertexAttrib4Niv_c
    glVertexAttrib4NivARB_c
    glVertexAttrib4Nsv_c
    glVertexAttrib4NsvARB_c
    glVertexAttrib4Nub
    glVertexAttrib4NubARB
    glVertexAttrib4Nubv_c
    glVertexAttrib4NubvARB_c
    glVertexAttrib4Nuiv_c
    glVertexAttrib4NuivARB_c
    glVertexAttrib4Nusv_c
    glVertexAttrib4NusvARB_c
    glVertexAttrib4s
    glVertexAttrib4sARB
    glVertexAttrib4sNV
    glVertexAttrib4sv_c
    glVertexAttrib4svARB_c
    glVertexAttrib4svNV_c
    glVertexAttrib4ubNV
    glVertexAttrib4ubv_c
    glVertexAttrib4ubvARB_c
    glVertexAttrib4ubvNV_c
    glVertexAttrib4uiv_c
    glVertexAttrib4uivARB_c
    glVertexAttrib4usv_c
    glVertexAttrib4usvARB_c
    glVertexAttribArrayObjectATI
    glVertexAttribBinding
    glVertexAttribDivisor
    glVertexAttribDivisorANGLE
    glVertexAttribDivisorARB
    glVertexAttribFormat
    glVertexAttribFormatNV
    glVertexAttribI1i
    glVertexAttribI1iEXT
    glVertexAttribI1iv_c
    glVertexAttribI1ivEXT_c
    glVertexAttribI1ui
    glVertexAttribI1uiEXT
    glVertexAttribI1uiv_c
    glVertexAttribI1uivEXT_c
    glVertexAttribI2i
    glVertexAttribI2iEXT
    glVertexAttribI2iv_c
    glVertexAttribI2ivEXT_c
    glVertexAttribI2ui
    glVertexAttribI2uiEXT
    glVertexAttribI2uiv_c
    glVertexAttribI2uivEXT_c
    glVertexAttribI3i
    glVertexAttribI3iEXT
    glVertexAttribI3iv_c
    glVertexAttribI3ivEXT_c
    glVertexAttribI3ui
    glVertexAttribI3uiEXT
    glVertexAttribI3uiv_c
    glVertexAttribI3uivEXT_c
    glVertexAttribI4bv_c
    glVertexAttribI4bvEXT_c
    glVertexAttribI4i
    glVertexAttribI4iEXT
    glVertexAttribI4iv_c
    glVertexAttribI4ivEXT_c
    glVertexAttribI4sv_c
    glVertexAttribI4svEXT_c
    glVertexAttribI4ubv_c
    glVertexAttribI4ubvEXT_c
    glVertexAttribI4ui
    glVertexAttribI4uiEXT
    glVertexAttribI4uiv_c
    glVertexAttribI4uivEXT_c
    glVertexAttribI4usv_c
    glVertexAttribI4usvEXT_c
    glVertexAttribIFormat
    glVertexAttribIFormatNV
    glVertexAttribIPointer_c
    glVertexAttribIPointerEXT_c
    glVertexAttribL1d
    glVertexAttribL1dEXT
    glVertexAttribL1dv_c
    glVertexAttribL1dvEXT_c
    glVertexAttribL1i64NV
    glVertexAttribL1i64vNV_c
    glVertexAttribL1ui64ARB
    glVertexAttribL1ui64NV
    glVertexAttribL1ui64vARB_c
    glVertexAttribL1ui64vNV_c
    glVertexAttribL2d
    glVertexAttribL2dEXT
    glVertexAttribL2dv_c
    glVertexAttribL2dvEXT_c
    glVertexAttribL2i64NV
    glVertexAttribL2i64vNV_c
    glVertexAttribL2ui64NV
    glVertexAttribL2ui64vNV_c
    glVertexAttribL3d
    glVertexAttribL3dEXT
    glVertexAttribL3dv_c
    glVertexAttribL3dvEXT_c
    glVertexAttribL3i64NV
    glVertexAttribL3i64vNV_c
    glVertexAttribL3ui64NV
    glVertexAttribL3ui64vNV_c
    glVertexAttribL4d
    glVertexAttribL4dEXT
    glVertexAttribL4dv_c
    glVertexAttribL4dvEXT_c
    glVertexAttribL4i64NV
    glVertexAttribL4i64vNV_c
    glVertexAttribL4ui64NV
    glVertexAttribL4ui64vNV_c
    glVertexAttribLFormat
    glVertexAttribLFormatNV
    glVertexAttribLPointer_c
    glVertexAttribLPointerEXT_c
    glVertexAttribP1ui
    glVertexAttribP1uiv_c
    glVertexAttribP2ui
    glVertexAttribP2uiv_c
    glVertexAttribP3ui
    glVertexAttribP3uiv_c
    glVertexAttribP4ui
    glVertexAttribP4uiv_c
    glVertexAttribParameteriAMD
    glVertexAttribPointer_c
    glVertexAttribPointerARB_c
    glVertexAttribPointerNV_c
    glVertexAttribs1dvNV_c
    glVertexAttribs1fvNV_c
    glVertexAttribs1hvNV_c
    glVertexAttribs1svNV_c
    glVertexAttribs2dvNV_c
    glVertexAttribs2fvNV_c
    glVertexAttribs2hvNV_c
    glVertexAttribs2svNV_c
    glVertexAttribs3dvNV_c
    glVertexAttribs3fvNV_c
    glVertexAttribs3hvNV_c
    glVertexAttribs3svNV_c
    glVertexAttribs4dvNV_c
    glVertexAttribs4fvNV_c
    glVertexAttribs4hvNV_c
    glVertexAttribs4svNV_c
    glVertexAttribs4ubvNV_c
    glVertexBindingDivisor
    glVertexBlendARB
    glVertexBlendEnvfATI
    glVertexBlendEnviATI
    glVertexFormatNV
    glVertexP2ui
    glVertexP2uiv_c
    glVertexP3ui
    glVertexP3uiv_c
    glVertexP4ui
    glVertexP4uiv_c
    glVertexPointer_c
    glVertexPointerEXT_c
    glVertexPointerListIBM_c
    glVertexPointervINTEL_c
    glVertexStream1dATI
    glVertexStream1dvATI_c
    glVertexStream1fATI
    glVertexStream1fvATI_c
    glVertexStream1iATI
    glVertexStream1ivATI_c
    glVertexStream1sATI
    glVertexStream1svATI_c
    glVertexStream2dATI
    glVertexStream2dvATI_c
    glVertexStream2fATI
    glVertexStream2fvATI_c
    glVertexStream2iATI
    glVertexStream2ivATI_c
    glVertexStream2sATI
    glVertexStream2svATI_c
    glVertexStream3dATI
    glVertexStream3dvATI_c
    glVertexStream3fATI
    glVertexStream3fvATI_c
    glVertexStream3iATI
    glVertexStream3ivATI_c
    glVertexStream3sATI
    glVertexStream3svATI_c
    glVertexStream4dATI
    glVertexStream4dvATI_c
    glVertexStream4fATI
    glVertexStream4fvATI_c
    glVertexStream4iATI
    glVertexStream4ivATI_c
    glVertexStream4sATI
    glVertexStream4svATI_c
    glVertexWeightfEXT
    glVertexWeightfvEXT_c
    glVertexWeighthNV
    glVertexWeighthvNV_c
    glVertexWeightPointerEXT_c
    glVideoCaptureNV_c
    glVideoCaptureStreamParameterdvNV_c
    glVideoCaptureStreamParameterfvNV_c
    glVideoCaptureStreamParameterivNV_c
    glViewport
    glViewportArrayv_c
    glViewportIndexedf
    glViewportIndexedfv_c
    glViewportPositionWScaleNV
    glViewportSwizzleNV
    glWaitSync
    glWaitVkSemaphoreNV
    glWeightbvARB_c
    glWeightdvARB_c
    glWeightfvARB_c
    glWeightivARB_c
    glWeightPathsNV_c
    glWeightPointerARB_c
    glWeightsvARB_c
    glWeightubvARB_c
    glWeightuivARB_c
    glWeightusvARB_c
    glWindowPos2d
    glWindowPos2dARB
    glWindowPos2dMESA
    glWindowPos2dv_c
    glWindowPos2dvARB_c
    glWindowPos2dvMESA_c
    glWindowPos2f
    glWindowPos2fARB
    glWindowPos2fMESA
    glWindowPos2fv_c
    glWindowPos2fvARB_c
    glWindowPos2fvMESA_c
    glWindowPos2i
    glWindowPos2iARB
    glWindowPos2iMESA
    glWindowPos2iv_c
    glWindowPos2ivARB_c
    glWindowPos2ivMESA_c
    glWindowPos2s
    glWindowPos2sARB
    glWindowPos2sMESA
    glWindowPos2sv_c
    glWindowPos2svARB_c
    glWindowPos2svMESA_c
    glWindowPos3d
    glWindowPos3dARB
    glWindowPos3dMESA
    glWindowPos3dv_c
    glWindowPos3dvARB_c
    glWindowPos3dvMESA_c
    glWindowPos3f
    glWindowPos3fARB
    glWindowPos3fMESA
    glWindowPos3fv_c
    glWindowPos3fvARB_c
    glWindowPos3fvMESA_c
    glWindowPos3i
    glWindowPos3iARB
    glWindowPos3iMESA
    glWindowPos3iv_c
    glWindowPos3ivARB_c
    glWindowPos3ivMESA_c
    glWindowPos3s
    glWindowPos3sARB
    glWindowPos3sMESA
    glWindowPos3sv_c
    glWindowPos3svARB_c
    glWindowPos3svMESA_c
    glWindowPos4dMESA
    glWindowPos4dvMESA_c
    glWindowPos4fMESA
    glWindowPos4fvMESA_c
    glWindowPos4iMESA
    glWindowPos4ivMESA_c
    glWindowPos4sMESA
    glWindowPos4svMESA_c
    glWindowRectanglesEXT_c
    glWriteMaskEXT
);

# Another automatically generated list for all the OpenGL tags.
# Manual changes will be lost:
our %EXPORT_TAGS_GL = (
          'GL_3DFX_tbuffer' => [
                                 'glTbufferMask3DFX'
                               ],
          'GL_AMD_debug_output' => [
                                     'glDebugMessageCallbackAMD',
                                     'glDebugMessageEnableAMD',
                                     'glDebugMessageInsertAMD',
                                     'glGetDebugMessageLogAMD'
                                   ],
          'GL_AMD_draw_buffers_blend' => [
                                           'glBlendEquationIndexedAMD',
                                           'glBlendEquationSeparateIndexedAMD',
                                           'glBlendFuncIndexedAMD',
                                           'glBlendFuncSeparateIndexedAMD'
                                         ],
          'GL_AMD_interleaved_elements' => [
                                             'glVertexAttribParameteriAMD'
                                           ],
          'GL_AMD_multi_draw_indirect' => [
                                            'glMultiDrawArraysIndirectAMD',
                                            'glMultiDrawElementsIndirectAMD'
                                          ],
          'GL_AMD_name_gen_delete' => [
                                        'glDeleteNamesAMD',
                                        'glGenNamesAMD',
                                        'glIsNameAMD'
                                      ],
          'GL_AMD_occlusion_query_event' => [
                                              'glQueryObjectParameteruiAMD'
                                            ],
          'GL_AMD_performance_monitor' => [
                                            'glBeginPerfMonitorAMD',
                                            'glDeletePerfMonitorsAMD',
                                            'glEndPerfMonitorAMD',
                                            'glGenPerfMonitorsAMD',
                                            'glGetPerfMonitorCounterDataAMD',
                                            'glGetPerfMonitorCounterInfoAMD',
                                            'glGetPerfMonitorCounterStringAMD',
                                            'glGetPerfMonitorCountersAMD',
                                            'glGetPerfMonitorGroupStringAMD',
                                            'glGetPerfMonitorGroupsAMD',
                                            'glSelectPerfMonitorCountersAMD'
                                          ],
          'GL_AMD_sample_positions' => [
                                         'glSetMultisamplefvAMD'
                                       ],
          'GL_AMD_sparse_texture' => [
                                       'glTexStorageSparseAMD',
                                       'glTextureStorageSparseAMD'
                                     ],
          'GL_AMD_stencil_operation_extended' => [
                                                   'glStencilOpValueAMD'
                                                 ],
          'GL_AMD_vertex_shader_tessellator' => [
                                                  'glTessellationFactorAMD',
                                                  'glTessellationModeAMD'
                                                ],
          'GL_ANGLE_framebuffer_blit' => [
                                           'glBlitFramebufferANGLE'
                                         ],
          'GL_ANGLE_framebuffer_multisample' => [
                                                  'glRenderbufferStorageMultisampleANGLE'
                                                ],
          'GL_ANGLE_instanced_arrays' => [
                                           'glDrawArraysInstancedANGLE',
                                           'glDrawElementsInstancedANGLE',
                                           'glVertexAttribDivisorANGLE'
                                         ],
          'GL_ANGLE_timer_query' => [
                                      'glBeginQueryANGLE',
                                      'glDeleteQueriesANGLE',
                                      'glEndQueryANGLE',
                                      'glGenQueriesANGLE',
                                      'glGetQueryObjecti64vANGLE',
                                      'glGetQueryObjectivANGLE',
                                      'glGetQueryObjectui64vANGLE',
                                      'glGetQueryObjectuivANGLE',
                                      'glGetQueryivANGLE',
                                      'glIsQueryANGLE',
                                      'glQueryCounterANGLE'
                                    ],
          'GL_ANGLE_translated_shader_source' => [
                                                   'glGetTranslatedShaderSourceANGLE'
                                                 ],
          'GL_APPLE_element_array' => [
                                        'glDrawElementArrayAPPLE',
                                        'glDrawRangeElementArrayAPPLE',
                                        'glElementPointerAPPLE',
                                        'glMultiDrawElementArrayAPPLE',
                                        'glMultiDrawRangeElementArrayAPPLE'
                                      ],
          'GL_APPLE_fence' => [
                                'glDeleteFencesAPPLE',
                                'glFinishFenceAPPLE',
                                'glFinishObjectAPPLE',
                                'glGenFencesAPPLE',
                                'glIsFenceAPPLE',
                                'glSetFenceAPPLE',
                                'glTestFenceAPPLE',
                                'glTestObjectAPPLE'
                              ],
          'GL_APPLE_flush_buffer_range' => [
                                             'glBufferParameteriAPPLE',
                                             'glFlushMappedBufferRangeAPPLE'
                                           ],
          'GL_APPLE_object_purgeable' => [
                                           'glGetObjectParameterivAPPLE',
                                           'glObjectPurgeableAPPLE',
                                           'glObjectUnpurgeableAPPLE'
                                         ],
          'GL_APPLE_texture_range' => [
                                        'glGetTexParameterPointervAPPLE',
                                        'glTextureRangeAPPLE'
                                      ],
          'GL_APPLE_vertex_array_object' => [
                                              'glBindVertexArrayAPPLE',
                                              'glDeleteVertexArraysAPPLE',
                                              'glGenVertexArraysAPPLE',
                                              'glIsVertexArrayAPPLE'
                                            ],
          'GL_APPLE_vertex_array_range' => [
                                             'glFlushVertexArrayRangeAPPLE',
                                             'glVertexArrayParameteriAPPLE',
                                             'glVertexArrayRangeAPPLE'
                                           ],
          'GL_APPLE_vertex_program_evaluators' => [
                                                    'glDisableVertexAttribAPPLE',
                                                    'glEnableVertexAttribAPPLE',
                                                    'glIsVertexAttribEnabledAPPLE',
                                                    'glMapVertexAttrib1dAPPLE',
                                                    'glMapVertexAttrib1fAPPLE',
                                                    'glMapVertexAttrib2dAPPLE',
                                                    'glMapVertexAttrib2fAPPLE'
                                                  ],
          'GL_ARB_ES2_compatibility' => [
                                          'glClearDepthf',
                                          'glDepthRangef',
                                          'glGetShaderPrecisionFormat',
                                          'glReleaseShaderCompiler',
                                          'glShaderBinary'
                                        ],
          'GL_ARB_ES3_1_compatibility' => [
                                            'glMemoryBarrierByRegion'
                                          ],
          'GL_ARB_ES3_2_compatibility' => [
                                            'glPrimitiveBoundingBoxARB'
                                          ],
          'GL_ARB_base_instance' => [
                                      'glDrawArraysInstancedBaseInstance',
                                      'glDrawElementsInstancedBaseInstance',
                                      'glDrawElementsInstancedBaseVertexBaseInstance'
                                    ],
          'GL_ARB_bindless_texture' => [
                                         'glGetImageHandleARB',
                                         'glGetTextureHandleARB',
                                         'glGetTextureSamplerHandleARB',
                                         'glGetVertexAttribLui64vARB',
                                         'glIsImageHandleResidentARB',
                                         'glIsTextureHandleResidentARB',
                                         'glMakeImageHandleNonResidentARB',
                                         'glMakeImageHandleResidentARB',
                                         'glMakeTextureHandleNonResidentARB',
                                         'glMakeTextureHandleResidentARB',
                                         'glProgramUniformHandleui64ARB',
                                         'glProgramUniformHandleui64vARB',
                                         'glUniformHandleui64ARB',
                                         'glUniformHandleui64vARB',
                                         'glVertexAttribL1ui64ARB',
                                         'glVertexAttribL1ui64vARB'
                                       ],
          'GL_ARB_blend_func_extended' => [
                                            'glBindFragDataLocationIndexed',
                                            'glGetFragDataIndex'
                                          ],
          'GL_ARB_buffer_storage' => [
                                       'glBufferStorage',
                                       'glNamedBufferStorageEXT'
                                     ],
          'GL_ARB_cl_event' => [
                                 'glCreateSyncFromCLeventARB'
                               ],
          'GL_ARB_clear_buffer_object' => [
                                            'glClearBufferData',
                                            'glClearBufferSubData',
                                            'glClearNamedBufferDataEXT',
                                            'glClearNamedBufferSubDataEXT'
                                          ],
          'GL_ARB_clear_texture' => [
                                      'glClearTexImage',
                                      'glClearTexSubImage'
                                    ],
          'GL_ARB_clip_control' => [
                                     'glClipControl'
                                   ],
          'GL_ARB_color_buffer_float' => [
                                           'glClampColorARB'
                                         ],
          'GL_ARB_compute_shader' => [
                                       'glDispatchCompute',
                                       'glDispatchComputeIndirect'
                                     ],
          'GL_ARB_compute_variable_group_size' => [
                                                    'glDispatchComputeGroupSizeARB'
                                                  ],
          'GL_ARB_copy_buffer' => [
                                    'glCopyBufferSubData'
                                  ],
          'GL_ARB_copy_image' => [
                                   'glCopyImageSubData'
                                 ],
          'GL_ARB_debug_output' => [
                                     'glDebugMessageCallbackARB',
                                     'glDebugMessageControlARB',
                                     'glDebugMessageInsertARB',
                                     'glGetDebugMessageLogARB'
                                   ],
          'GL_ARB_direct_state_access' => [
                                            'glBindTextureUnit',
                                            'glBlitNamedFramebuffer',
                                            'glCheckNamedFramebufferStatus',
                                            'glClearNamedBufferData',
                                            'glClearNamedBufferSubData',
                                            'glClearNamedFramebufferfi',
                                            'glClearNamedFramebufferfv',
                                            'glClearNamedFramebufferiv',
                                            'glClearNamedFramebufferuiv',
                                            'glCompressedTextureSubImage1D',
                                            'glCompressedTextureSubImage2D',
                                            'glCompressedTextureSubImage3D',
                                            'glCopyNamedBufferSubData',
                                            'glCopyTextureSubImage1D',
                                            'glCopyTextureSubImage2D',
                                            'glCopyTextureSubImage3D',
                                            'glCreateBuffers',
                                            'glCreateFramebuffers',
                                            'glCreateProgramPipelines',
                                            'glCreateQueries',
                                            'glCreateRenderbuffers',
                                            'glCreateSamplers',
                                            'glCreateTextures',
                                            'glCreateTransformFeedbacks',
                                            'glCreateVertexArrays',
                                            'glDisableVertexArrayAttrib',
                                            'glEnableVertexArrayAttrib',
                                            'glFlushMappedNamedBufferRange',
                                            'glGenerateTextureMipmap',
                                            'glGetCompressedTextureImage',
                                            'glGetNamedBufferParameteri64v',
                                            'glGetNamedBufferParameteriv',
                                            'glGetNamedBufferPointerv',
                                            'glGetNamedBufferSubData',
                                            'glGetNamedFramebufferAttachmentParameteriv',
                                            'glGetNamedFramebufferParameteriv',
                                            'glGetNamedRenderbufferParameteriv',
                                            'glGetQueryBufferObjecti64v',
                                            'glGetQueryBufferObjectiv',
                                            'glGetQueryBufferObjectui64v',
                                            'glGetQueryBufferObjectuiv',
                                            'glGetTextureImage',
                                            'glGetTextureLevelParameterfv',
                                            'glGetTextureLevelParameteriv',
                                            'glGetTextureParameterIiv',
                                            'glGetTextureParameterIuiv',
                                            'glGetTextureParameterfv',
                                            'glGetTextureParameteriv',
                                            'glGetTransformFeedbacki64_v',
                                            'glGetTransformFeedbacki_v',
                                            'glGetTransformFeedbackiv',
                                            'glGetVertexArrayIndexed64iv',
                                            'glGetVertexArrayIndexediv',
                                            'glGetVertexArrayiv',
                                            'glInvalidateNamedFramebufferData',
                                            'glInvalidateNamedFramebufferSubData',
                                            'glMapNamedBuffer',
                                            'glMapNamedBufferRange',
                                            'glNamedBufferData',
                                            'glNamedBufferStorage',
                                            'glNamedBufferSubData',
                                            'glNamedFramebufferDrawBuffer',
                                            'glNamedFramebufferDrawBuffers',
                                            'glNamedFramebufferParameteri',
                                            'glNamedFramebufferReadBuffer',
                                            'glNamedFramebufferRenderbuffer',
                                            'glNamedFramebufferTexture',
                                            'glNamedFramebufferTextureLayer',
                                            'glNamedRenderbufferStorage',
                                            'glNamedRenderbufferStorageMultisample',
                                            'glTextureBuffer',
                                            'glTextureBufferRange',
                                            'glTextureParameterIiv',
                                            'glTextureParameterIuiv',
                                            'glTextureParameterf',
                                            'glTextureParameterfv',
                                            'glTextureParameteri',
                                            'glTextureParameteriv',
                                            'glTextureStorage1D',
                                            'glTextureStorage2D',
                                            'glTextureStorage2DMultisample',
                                            'glTextureStorage3D',
                                            'glTextureStorage3DMultisample',
                                            'glTextureSubImage1D',
                                            'glTextureSubImage2D',
                                            'glTextureSubImage3D',
                                            'glTransformFeedbackBufferBase',
                                            'glTransformFeedbackBufferRange',
                                            'glUnmapNamedBuffer',
                                            'glVertexArrayAttribBinding',
                                            'glVertexArrayAttribFormat',
                                            'glVertexArrayAttribIFormat',
                                            'glVertexArrayAttribLFormat',
                                            'glVertexArrayBindingDivisor',
                                            'glVertexArrayElementBuffer',
                                            'glVertexArrayVertexBuffer',
                                            'glVertexArrayVertexBuffers'
                                          ],
          'GL_ARB_draw_buffers' => [
                                     'glDrawBuffersARB'
                                   ],
          'GL_ARB_draw_buffers_blend' => [
                                           'glBlendEquationSeparateiARB',
                                           'glBlendEquationiARB',
                                           'glBlendFuncSeparateiARB',
                                           'glBlendFunciARB'
                                         ],
          'GL_ARB_draw_elements_base_vertex' => [
                                                  'glDrawElementsBaseVertex',
                                                  'glDrawElementsInstancedBaseVertex',
                                                  'glDrawRangeElementsBaseVertex',
                                                  'glMultiDrawElementsBaseVertex'
                                                ],
          'GL_ARB_draw_indirect' => [
                                      'glDrawArraysIndirect',
                                      'glDrawElementsIndirect'
                                    ],
          'GL_ARB_framebuffer_no_attachments' => [
                                                   'glFramebufferParameteri',
                                                   'glGetFramebufferParameteriv',
                                                   'glGetNamedFramebufferParameterivEXT',
                                                   'glNamedFramebufferParameteriEXT'
                                                 ],
          'GL_ARB_framebuffer_object' => [
                                           'glBindFramebuffer',
                                           'glBindRenderbuffer',
                                           'glBlitFramebuffer',
                                           'glCheckFramebufferStatus',
                                           'glDeleteFramebuffers',
                                           'glDeleteRenderbuffers',
                                           'glFramebufferRenderbuffer',
                                           'glFramebufferTexture1D',
                                           'glFramebufferTexture2D',
                                           'glFramebufferTexture3D',
                                           'glFramebufferTextureLayer',
                                           'glGenFramebuffers',
                                           'glGenRenderbuffers',
                                           'glGenerateMipmap',
                                           'glGetFramebufferAttachmentParameteriv',
                                           'glGetRenderbufferParameteriv',
                                           'glIsFramebuffer',
                                           'glIsRenderbuffer',
                                           'glRenderbufferStorage',
                                           'glRenderbufferStorageMultisample'
                                         ],
          'GL_ARB_geometry_shader4' => [
                                         'glFramebufferTextureARB',
                                         'glFramebufferTextureFaceARB',
                                         'glFramebufferTextureLayerARB',
                                         'glProgramParameteriARB'
                                       ],
          'GL_ARB_get_program_binary' => [
                                           'glGetProgramBinary',
                                           'glProgramBinary',
                                           'glProgramParameteri'
                                         ],
          'GL_ARB_get_texture_sub_image' => [
                                              'glGetCompressedTextureSubImage',
                                              'glGetTextureSubImage'
                                            ],
          'GL_ARB_gl_spirv' => [
                                 'glSpecializeShaderARB'
                               ],
          'GL_ARB_gpu_shader_fp64' => [
                                        'glGetUniformdv',
                                        'glUniform1d',
                                        'glUniform1dv',
                                        'glUniform2d',
                                        'glUniform2dv',
                                        'glUniform3d',
                                        'glUniform3dv',
                                        'glUniform4d',
                                        'glUniform4dv',
                                        'glUniformMatrix2dv',
                                        'glUniformMatrix2x3dv',
                                        'glUniformMatrix2x4dv',
                                        'glUniformMatrix3dv',
                                        'glUniformMatrix3x2dv',
                                        'glUniformMatrix3x4dv',
                                        'glUniformMatrix4dv',
                                        'glUniformMatrix4x2dv',
                                        'glUniformMatrix4x3dv'
                                      ],
          'GL_ARB_gpu_shader_int64' => [
                                         'glGetUniformi64vARB',
                                         'glGetUniformui64vARB',
                                         'glGetnUniformi64vARB',
                                         'glGetnUniformui64vARB',
                                         'glProgramUniform1i64ARB',
                                         'glProgramUniform1i64vARB',
                                         'glProgramUniform1ui64ARB',
                                         'glProgramUniform1ui64vARB',
                                         'glProgramUniform2i64ARB',
                                         'glProgramUniform2i64vARB',
                                         'glProgramUniform2ui64ARB',
                                         'glProgramUniform2ui64vARB',
                                         'glProgramUniform3i64ARB',
                                         'glProgramUniform3i64vARB',
                                         'glProgramUniform3ui64ARB',
                                         'glProgramUniform3ui64vARB',
                                         'glProgramUniform4i64ARB',
                                         'glProgramUniform4i64vARB',
                                         'glProgramUniform4ui64ARB',
                                         'glProgramUniform4ui64vARB',
                                         'glUniform1i64ARB',
                                         'glUniform1i64vARB',
                                         'glUniform1ui64ARB',
                                         'glUniform1ui64vARB',
                                         'glUniform2i64ARB',
                                         'glUniform2i64vARB',
                                         'glUniform2ui64ARB',
                                         'glUniform2ui64vARB',
                                         'glUniform3i64ARB',
                                         'glUniform3i64vARB',
                                         'glUniform3ui64ARB',
                                         'glUniform3ui64vARB',
                                         'glUniform4i64ARB',
                                         'glUniform4i64vARB',
                                         'glUniform4ui64ARB',
                                         'glUniform4ui64vARB'
                                       ],
          'GL_ARB_imaging' => [
                                'glColorSubTable',
                                'glColorTable',
                                'glColorTableParameterfv',
                                'glColorTableParameteriv',
                                'glConvolutionFilter1D',
                                'glConvolutionFilter2D',
                                'glConvolutionParameterf',
                                'glConvolutionParameterfv',
                                'glConvolutionParameteri',
                                'glConvolutionParameteriv',
                                'glCopyColorSubTable',
                                'glCopyColorTable',
                                'glCopyConvolutionFilter1D',
                                'glCopyConvolutionFilter2D',
                                'glGetColorTable',
                                'glGetColorTableParameterfv',
                                'glGetColorTableParameteriv',
                                'glGetConvolutionFilter',
                                'glGetConvolutionParameterfv',
                                'glGetConvolutionParameteriv',
                                'glGetHistogram',
                                'glGetHistogramParameterfv',
                                'glGetHistogramParameteriv',
                                'glGetMinmax',
                                'glGetMinmaxParameterfv',
                                'glGetMinmaxParameteriv',
                                'glGetSeparableFilter',
                                'glHistogram',
                                'glMinmax',
                                'glResetHistogram',
                                'glResetMinmax',
                                'glSeparableFilter2D'
                              ],
          'GL_ARB_indirect_parameters' => [
                                            'glMultiDrawArraysIndirectCountARB',
                                            'glMultiDrawElementsIndirectCountARB'
                                          ],
          'GL_ARB_instanced_arrays' => [
                                         'glDrawArraysInstancedARB',
                                         'glDrawElementsInstancedARB',
                                         'glVertexAttribDivisorARB'
                                       ],
          'GL_ARB_internalformat_query' => [
                                             'glGetInternalformativ'
                                           ],
          'GL_ARB_internalformat_query2' => [
                                              'glGetInternalformati64v'
                                            ],
          'GL_ARB_invalidate_subdata' => [
                                           'glInvalidateBufferData',
                                           'glInvalidateBufferSubData',
                                           'glInvalidateFramebuffer',
                                           'glInvalidateSubFramebuffer',
                                           'glInvalidateTexImage',
                                           'glInvalidateTexSubImage'
                                         ],
          'GL_ARB_map_buffer_range' => [
                                         'glFlushMappedBufferRange',
                                         'glMapBufferRange'
                                       ],
          'GL_ARB_matrix_palette' => [
                                       'glCurrentPaletteMatrixARB',
                                       'glMatrixIndexPointerARB',
                                       'glMatrixIndexubvARB',
                                       'glMatrixIndexuivARB',
                                       'glMatrixIndexusvARB'
                                     ],
          'GL_ARB_multi_bind' => [
                                   'glBindBuffersBase',
                                   'glBindBuffersRange',
                                   'glBindImageTextures',
                                   'glBindSamplers',
                                   'glBindTextures',
                                   'glBindVertexBuffers'
                                 ],
          'GL_ARB_multi_draw_indirect' => [
                                            'glMultiDrawArraysIndirect',
                                            'glMultiDrawElementsIndirect'
                                          ],
          'GL_ARB_multisample' => [
                                    'glSampleCoverageARB'
                                  ],
          'GL_ARB_multitexture' => [
                                     'glActiveTextureARB',
                                     'glClientActiveTextureARB',
                                     'glMultiTexCoord1dARB',
                                     'glMultiTexCoord1dvARB',
                                     'glMultiTexCoord1fARB',
                                     'glMultiTexCoord1fvARB',
                                     'glMultiTexCoord1iARB',
                                     'glMultiTexCoord1ivARB',
                                     'glMultiTexCoord1sARB',
                                     'glMultiTexCoord1svARB',
                                     'glMultiTexCoord2dARB',
                                     'glMultiTexCoord2dvARB',
                                     'glMultiTexCoord2fARB',
                                     'glMultiTexCoord2fvARB',
                                     'glMultiTexCoord2iARB',
                                     'glMultiTexCoord2ivARB',
                                     'glMultiTexCoord2sARB',
                                     'glMultiTexCoord2svARB',
                                     'glMultiTexCoord3dARB',
                                     'glMultiTexCoord3dvARB',
                                     'glMultiTexCoord3fARB',
                                     'glMultiTexCoord3fvARB',
                                     'glMultiTexCoord3iARB',
                                     'glMultiTexCoord3ivARB',
                                     'glMultiTexCoord3sARB',
                                     'glMultiTexCoord3svARB',
                                     'glMultiTexCoord4dARB',
                                     'glMultiTexCoord4dvARB',
                                     'glMultiTexCoord4fARB',
                                     'glMultiTexCoord4fvARB',
                                     'glMultiTexCoord4iARB',
                                     'glMultiTexCoord4ivARB',
                                     'glMultiTexCoord4sARB',
                                     'glMultiTexCoord4svARB'
                                   ],
          'GL_ARB_occlusion_query' => [
                                        'glBeginQueryARB',
                                        'glDeleteQueriesARB',
                                        'glEndQueryARB',
                                        'glGenQueriesARB',
                                        'glGetQueryObjectivARB',
                                        'glGetQueryObjectuivARB',
                                        'glGetQueryivARB',
                                        'glIsQueryARB'
                                      ],
          'GL_ARB_parallel_shader_compile' => [
                                                'glMaxShaderCompilerThreadsARB'
                                              ],
          'GL_ARB_point_parameters' => [
                                         'glPointParameterfARB',
                                         'glPointParameterfvARB'
                                       ],
          'GL_ARB_program_interface_query' => [
                                                'glGetProgramInterfaceiv',
                                                'glGetProgramResourceIndex',
                                                'glGetProgramResourceLocation',
                                                'glGetProgramResourceLocationIndex',
                                                'glGetProgramResourceName',
                                                'glGetProgramResourceiv'
                                              ],
          'GL_ARB_provoking_vertex' => [
                                         'glProvokingVertex'
                                       ],
          'GL_ARB_robustness' => [
                                   'glGetGraphicsResetStatusARB',
                                   'glGetnColorTableARB',
                                   'glGetnCompressedTexImageARB',
                                   'glGetnConvolutionFilterARB',
                                   'glGetnHistogramARB',
                                   'glGetnMapdvARB',
                                   'glGetnMapfvARB',
                                   'glGetnMapivARB',
                                   'glGetnMinmaxARB',
                                   'glGetnPixelMapfvARB',
                                   'glGetnPixelMapuivARB',
                                   'glGetnPixelMapusvARB',
                                   'glGetnPolygonStippleARB',
                                   'glGetnSeparableFilterARB',
                                   'glGetnTexImageARB',
                                   'glGetnUniformdvARB',
                                   'glGetnUniformfvARB',
                                   'glGetnUniformivARB',
                                   'glGetnUniformuivARB',
                                   'glReadnPixelsARB'
                                 ],
          'GL_ARB_sample_locations' => [
                                         'glFramebufferSampleLocationsfvARB',
                                         'glNamedFramebufferSampleLocationsfvARB'
                                       ],
          'GL_ARB_sample_shading' => [
                                       'glMinSampleShadingARB'
                                     ],
          'GL_ARB_sampler_objects' => [
                                        'glBindSampler',
                                        'glDeleteSamplers',
                                        'glGenSamplers',
                                        'glGetSamplerParameterIiv',
                                        'glGetSamplerParameterIuiv',
                                        'glGetSamplerParameterfv',
                                        'glGetSamplerParameteriv',
                                        'glIsSampler',
                                        'glSamplerParameterIiv',
                                        'glSamplerParameterIuiv',
                                        'glSamplerParameterf',
                                        'glSamplerParameterfv',
                                        'glSamplerParameteri',
                                        'glSamplerParameteriv'
                                      ],
          'GL_ARB_separate_shader_objects' => [
                                                'glActiveShaderProgram',
                                                'glBindProgramPipeline',
                                                'glCreateShaderProgramv',
                                                'glDeleteProgramPipelines',
                                                'glGenProgramPipelines',
                                                'glGetProgramPipelineInfoLog',
                                                'glGetProgramPipelineiv',
                                                'glIsProgramPipeline',
                                                'glProgramUniform1d',
                                                'glProgramUniform1dv',
                                                'glProgramUniform1f',
                                                'glProgramUniform1fv',
                                                'glProgramUniform1i',
                                                'glProgramUniform1iv',
                                                'glProgramUniform1ui',
                                                'glProgramUniform1uiv',
                                                'glProgramUniform2d',
                                                'glProgramUniform2dv',
                                                'glProgramUniform2f',
                                                'glProgramUniform2fv',
                                                'glProgramUniform2i',
                                                'glProgramUniform2iv',
                                                'glProgramUniform2ui',
                                                'glProgramUniform2uiv',
                                                'glProgramUniform3d',
                                                'glProgramUniform3dv',
                                                'glProgramUniform3f',
                                                'glProgramUniform3fv',
                                                'glProgramUniform3i',
                                                'glProgramUniform3iv',
                                                'glProgramUniform3ui',
                                                'glProgramUniform3uiv',
                                                'glProgramUniform4d',
                                                'glProgramUniform4dv',
                                                'glProgramUniform4f',
                                                'glProgramUniform4fv',
                                                'glProgramUniform4i',
                                                'glProgramUniform4iv',
                                                'glProgramUniform4ui',
                                                'glProgramUniform4uiv',
                                                'glProgramUniformMatrix2dv',
                                                'glProgramUniformMatrix2fv',
                                                'glProgramUniformMatrix2x3dv',
                                                'glProgramUniformMatrix2x3fv',
                                                'glProgramUniformMatrix2x4dv',
                                                'glProgramUniformMatrix2x4fv',
                                                'glProgramUniformMatrix3dv',
                                                'glProgramUniformMatrix3fv',
                                                'glProgramUniformMatrix3x2dv',
                                                'glProgramUniformMatrix3x2fv',
                                                'glProgramUniformMatrix3x4dv',
                                                'glProgramUniformMatrix3x4fv',
                                                'glProgramUniformMatrix4dv',
                                                'glProgramUniformMatrix4fv',
                                                'glProgramUniformMatrix4x2dv',
                                                'glProgramUniformMatrix4x2fv',
                                                'glProgramUniformMatrix4x3dv',
                                                'glProgramUniformMatrix4x3fv',
                                                'glUseProgramStages',
                                                'glValidateProgramPipeline'
                                              ],
          'GL_ARB_shader_atomic_counters' => [
                                               'glGetActiveAtomicCounterBufferiv'
                                             ],
          'GL_ARB_shader_image_load_store' => [
                                                'glBindImageTexture',
                                                'glMemoryBarrier'
                                              ],
          'GL_ARB_shader_objects' => [
                                       'glAttachObjectARB',
                                       'glCompileShaderARB',
                                       'glCreateProgramObjectARB',
                                       'glCreateShaderObjectARB',
                                       'glDeleteObjectARB',
                                       'glDetachObjectARB',
                                       'glGetActiveUniformARB',
                                       'glGetAttachedObjectsARB',
                                       'glGetHandleARB',
                                       'glGetInfoLogARB',
                                       'glGetObjectParameterfvARB',
                                       'glGetObjectParameterivARB',
                                       'glGetShaderSourceARB',
                                       'glGetUniformLocationARB',
                                       'glGetUniformfvARB',
                                       'glGetUniformivARB',
                                       'glLinkProgramARB',
                                       'glShaderSourceARB',
                                       'glUniform1fARB',
                                       'glUniform1fvARB',
                                       'glUniform1iARB',
                                       'glUniform1ivARB',
                                       'glUniform2fARB',
                                       'glUniform2fvARB',
                                       'glUniform2iARB',
                                       'glUniform2ivARB',
                                       'glUniform3fARB',
                                       'glUniform3fvARB',
                                       'glUniform3iARB',
                                       'glUniform3ivARB',
                                       'glUniform4fARB',
                                       'glUniform4fvARB',
                                       'glUniform4iARB',
                                       'glUniform4ivARB',
                                       'glUniformMatrix2fvARB',
                                       'glUniformMatrix3fvARB',
                                       'glUniformMatrix4fvARB',
                                       'glUseProgramObjectARB',
                                       'glValidateProgramARB'
                                     ],
          'GL_ARB_shader_storage_buffer_object' => [
                                                     'glShaderStorageBlockBinding'
                                                   ],
          'GL_ARB_shader_subroutine' => [
                                          'glGetActiveSubroutineName',
                                          'glGetActiveSubroutineUniformName',
                                          'glGetActiveSubroutineUniformiv',
                                          'glGetProgramStageiv',
                                          'glGetSubroutineIndex',
                                          'glGetSubroutineUniformLocation',
                                          'glGetUniformSubroutineuiv',
                                          'glUniformSubroutinesuiv'
                                        ],
          'GL_ARB_shading_language_include' => [
                                                 'glCompileShaderIncludeARB',
                                                 'glDeleteNamedStringARB',
                                                 'glGetNamedStringARB',
                                                 'glGetNamedStringivARB',
                                                 'glIsNamedStringARB',
                                                 'glNamedStringARB'
                                               ],
          'GL_ARB_sparse_buffer' => [
                                      'glBufferPageCommitmentARB'
                                    ],
          'GL_ARB_sparse_texture' => [
                                       'glTexPageCommitmentARB',
                                       'glTexturePageCommitmentEXT'
                                     ],
          'GL_ARB_sync' => [
                             'glClientWaitSync',
                             'glDeleteSync',
                             'glFenceSync',
                             'glGetInteger64v',
                             'glGetSynciv',
                             'glIsSync',
                             'glWaitSync'
                           ],
          'GL_ARB_tessellation_shader' => [
                                            'glPatchParameterfv',
                                            'glPatchParameteri'
                                          ],
          'GL_ARB_texture_barrier' => [
                                        'glTextureBarrier'
                                      ],
          'GL_ARB_texture_buffer_object' => [
                                              'glTexBufferARB'
                                            ],
          'GL_ARB_texture_buffer_range' => [
                                             'glTexBufferRange',
                                             'glTextureBufferRangeEXT'
                                           ],
          'GL_ARB_texture_compression' => [
                                            'glCompressedTexImage1DARB',
                                            'glCompressedTexImage2DARB',
                                            'glCompressedTexImage3DARB',
                                            'glCompressedTexSubImage1DARB',
                                            'glCompressedTexSubImage2DARB',
                                            'glCompressedTexSubImage3DARB',
                                            'glGetCompressedTexImageARB'
                                          ],
          'GL_ARB_texture_multisample' => [
                                            'glGetMultisamplefv',
                                            'glSampleMaski',
                                            'glTexImage2DMultisample',
                                            'glTexImage3DMultisample'
                                          ],
          'GL_ARB_texture_storage' => [
                                        'glTexStorage1D',
                                        'glTexStorage2D',
                                        'glTexStorage3D',
                                        'glTextureStorage1DEXT',
                                        'glTextureStorage2DEXT',
                                        'glTextureStorage3DEXT'
                                      ],
          'GL_ARB_texture_storage_multisample' => [
                                                    'glTexStorage2DMultisample',
                                                    'glTexStorage3DMultisample',
                                                    'glTextureStorage2DMultisampleEXT',
                                                    'glTextureStorage3DMultisampleEXT'
                                                  ],
          'GL_ARB_texture_view' => [
                                     'glTextureView'
                                   ],
          'GL_ARB_timer_query' => [
                                    'glGetQueryObjecti64v',
                                    'glGetQueryObjectui64v',
                                    'glQueryCounter'
                                  ],
          'GL_ARB_transform_feedback2' => [
                                            'glBindTransformFeedback',
                                            'glDeleteTransformFeedbacks',
                                            'glDrawTransformFeedback',
                                            'glGenTransformFeedbacks',
                                            'glIsTransformFeedback',
                                            'glPauseTransformFeedback',
                                            'glResumeTransformFeedback'
                                          ],
          'GL_ARB_transform_feedback3' => [
                                            'glBeginQueryIndexed',
                                            'glDrawTransformFeedbackStream',
                                            'glEndQueryIndexed',
                                            'glGetQueryIndexediv'
                                          ],
          'GL_ARB_transform_feedback_instanced' => [
                                                     'glDrawTransformFeedbackInstanced',
                                                     'glDrawTransformFeedbackStreamInstanced'
                                                   ],
          'GL_ARB_transpose_matrix' => [
                                         'glLoadTransposeMatrixdARB',
                                         'glLoadTransposeMatrixfARB',
                                         'glMultTransposeMatrixdARB',
                                         'glMultTransposeMatrixfARB'
                                       ],
          'GL_ARB_uniform_buffer_object' => [
                                              'glBindBufferBase',
                                              'glBindBufferRange',
                                              'glGetActiveUniformBlockName',
                                              'glGetActiveUniformBlockiv',
                                              'glGetActiveUniformName',
                                              'glGetActiveUniformsiv',
                                              'glGetIntegeri_v',
                                              'glGetUniformBlockIndex',
                                              'glGetUniformIndices',
                                              'glUniformBlockBinding'
                                            ],
          'GL_ARB_vertex_array_object' => [
                                            'glBindVertexArray',
                                            'glDeleteVertexArrays',
                                            'glGenVertexArrays',
                                            'glIsVertexArray'
                                          ],
          'GL_ARB_vertex_attrib_64bit' => [
                                            'glGetVertexAttribLdv',
                                            'glVertexAttribL1d',
                                            'glVertexAttribL1dv',
                                            'glVertexAttribL2d',
                                            'glVertexAttribL2dv',
                                            'glVertexAttribL3d',
                                            'glVertexAttribL3dv',
                                            'glVertexAttribL4d',
                                            'glVertexAttribL4dv',
                                            'glVertexAttribLPointer'
                                          ],
          'GL_ARB_vertex_attrib_binding' => [
                                              'glBindVertexBuffer',
                                              'glVertexArrayBindVertexBufferEXT',
                                              'glVertexArrayVertexAttribBindingEXT',
                                              'glVertexArrayVertexAttribFormatEXT',
                                              'glVertexArrayVertexAttribIFormatEXT',
                                              'glVertexArrayVertexAttribLFormatEXT',
                                              'glVertexArrayVertexBindingDivisorEXT',
                                              'glVertexAttribBinding',
                                              'glVertexAttribFormat',
                                              'glVertexAttribIFormat',
                                              'glVertexAttribLFormat',
                                              'glVertexBindingDivisor'
                                            ],
          'GL_ARB_vertex_blend' => [
                                     'glVertexBlendARB',
                                     'glWeightPointerARB',
                                     'glWeightbvARB',
                                     'glWeightdvARB',
                                     'glWeightfvARB',
                                     'glWeightivARB',
                                     'glWeightsvARB',
                                     'glWeightubvARB',
                                     'glWeightuivARB',
                                     'glWeightusvARB'
                                   ],
          'GL_ARB_vertex_buffer_object' => [
                                             'glBindBufferARB',
                                             'glBufferDataARB',
                                             'glBufferSubDataARB',
                                             'glDeleteBuffersARB',
                                             'glGenBuffersARB',
                                             'glGetBufferParameterivARB',
                                             'glGetBufferPointervARB',
                                             'glGetBufferSubDataARB',
                                             'glIsBufferARB',
                                             'glMapBufferARB',
                                             'glUnmapBufferARB'
                                           ],
          'GL_ARB_vertex_program' => [
                                       'glBindProgramARB',
                                       'glDeleteProgramsARB',
                                       'glDisableVertexAttribArrayARB',
                                       'glEnableVertexAttribArrayARB',
                                       'glGenProgramsARB',
                                       'glGetProgramEnvParameterdvARB',
                                       'glGetProgramEnvParameterfvARB',
                                       'glGetProgramLocalParameterdvARB',
                                       'glGetProgramLocalParameterfvARB',
                                       'glGetProgramStringARB',
                                       'glGetProgramivARB',
                                       'glGetVertexAttribPointervARB',
                                       'glGetVertexAttribdvARB',
                                       'glGetVertexAttribfvARB',
                                       'glGetVertexAttribivARB',
                                       'glIsProgramARB',
                                       'glProgramEnvParameter4dARB',
                                       'glProgramEnvParameter4dvARB',
                                       'glProgramEnvParameter4fARB',
                                       'glProgramEnvParameter4fvARB',
                                       'glProgramLocalParameter4dARB',
                                       'glProgramLocalParameter4dvARB',
                                       'glProgramLocalParameter4fARB',
                                       'glProgramLocalParameter4fvARB',
                                       'glProgramStringARB',
                                       'glVertexAttrib1dARB',
                                       'glVertexAttrib1dvARB',
                                       'glVertexAttrib1fARB',
                                       'glVertexAttrib1fvARB',
                                       'glVertexAttrib1sARB',
                                       'glVertexAttrib1svARB',
                                       'glVertexAttrib2dARB',
                                       'glVertexAttrib2dvARB',
                                       'glVertexAttrib2fARB',
                                       'glVertexAttrib2fvARB',
                                       'glVertexAttrib2sARB',
                                       'glVertexAttrib2svARB',
                                       'glVertexAttrib3dARB',
                                       'glVertexAttrib3dvARB',
                                       'glVertexAttrib3fARB',
                                       'glVertexAttrib3fvARB',
                                       'glVertexAttrib3sARB',
                                       'glVertexAttrib3svARB',
                                       'glVertexAttrib4NbvARB',
                                       'glVertexAttrib4NivARB',
                                       'glVertexAttrib4NsvARB',
                                       'glVertexAttrib4NubARB',
                                       'glVertexAttrib4NubvARB',
                                       'glVertexAttrib4NuivARB',
                                       'glVertexAttrib4NusvARB',
                                       'glVertexAttrib4bvARB',
                                       'glVertexAttrib4dARB',
                                       'glVertexAttrib4dvARB',
                                       'glVertexAttrib4fARB',
                                       'glVertexAttrib4fvARB',
                                       'glVertexAttrib4ivARB',
                                       'glVertexAttrib4sARB',
                                       'glVertexAttrib4svARB',
                                       'glVertexAttrib4ubvARB',
                                       'glVertexAttrib4uivARB',
                                       'glVertexAttrib4usvARB',
                                       'glVertexAttribPointerARB'
                                     ],
          'GL_ARB_vertex_shader' => [
                                      'glBindAttribLocationARB',
                                      'glGetActiveAttribARB',
                                      'glGetAttribLocationARB'
                                    ],
          'GL_ARB_vertex_type_2_10_10_10_rev' => [
                                                   'glColorP3ui',
                                                   'glColorP3uiv',
                                                   'glColorP4ui',
                                                   'glColorP4uiv',
                                                   'glMultiTexCoordP1ui',
                                                   'glMultiTexCoordP1uiv',
                                                   'glMultiTexCoordP2ui',
                                                   'glMultiTexCoordP2uiv',
                                                   'glMultiTexCoordP3ui',
                                                   'glMultiTexCoordP3uiv',
                                                   'glMultiTexCoordP4ui',
                                                   'glMultiTexCoordP4uiv',
                                                   'glNormalP3ui',
                                                   'glNormalP3uiv',
                                                   'glSecondaryColorP3ui',
                                                   'glSecondaryColorP3uiv',
                                                   'glTexCoordP1ui',
                                                   'glTexCoordP1uiv',
                                                   'glTexCoordP2ui',
                                                   'glTexCoordP2uiv',
                                                   'glTexCoordP3ui',
                                                   'glTexCoordP3uiv',
                                                   'glTexCoordP4ui',
                                                   'glTexCoordP4uiv',
                                                   'glVertexAttribP1ui',
                                                   'glVertexAttribP1uiv',
                                                   'glVertexAttribP2ui',
                                                   'glVertexAttribP2uiv',
                                                   'glVertexAttribP3ui',
                                                   'glVertexAttribP3uiv',
                                                   'glVertexAttribP4ui',
                                                   'glVertexAttribP4uiv',
                                                   'glVertexP2ui',
                                                   'glVertexP2uiv',
                                                   'glVertexP3ui',
                                                   'glVertexP3uiv',
                                                   'glVertexP4ui',
                                                   'glVertexP4uiv'
                                                 ],
          'GL_ARB_viewport_array' => [
                                       'glDepthRangeArrayv',
                                       'glDepthRangeIndexed',
                                       'glGetDoublei_v',
                                       'glGetFloati_v',
                                       'glScissorArrayv',
                                       'glScissorIndexed',
                                       'glScissorIndexedv',
                                       'glViewportArrayv',
                                       'glViewportIndexedf',
                                       'glViewportIndexedfv'
                                     ],
          'GL_ARB_window_pos' => [
                                   'glWindowPos2dARB',
                                   'glWindowPos2dvARB',
                                   'glWindowPos2fARB',
                                   'glWindowPos2fvARB',
                                   'glWindowPos2iARB',
                                   'glWindowPos2ivARB',
                                   'glWindowPos2sARB',
                                   'glWindowPos2svARB',
                                   'glWindowPos3dARB',
                                   'glWindowPos3dvARB',
                                   'glWindowPos3fARB',
                                   'glWindowPos3fvARB',
                                   'glWindowPos3iARB',
                                   'glWindowPos3ivARB',
                                   'glWindowPos3sARB',
                                   'glWindowPos3svARB'
                                 ],
          'GL_ATI_draw_buffers' => [
                                     'glDrawBuffersATI'
                                   ],
          'GL_ATI_element_array' => [
                                      'glDrawElementArrayATI',
                                      'glDrawRangeElementArrayATI',
                                      'glElementPointerATI'
                                    ],
          'GL_ATI_envmap_bumpmap' => [
                                       'glGetTexBumpParameterfvATI',
                                       'glGetTexBumpParameterivATI',
                                       'glTexBumpParameterfvATI',
                                       'glTexBumpParameterivATI'
                                     ],
          'GL_ATI_fragment_shader' => [
                                        'glAlphaFragmentOp1ATI',
                                        'glAlphaFragmentOp2ATI',
                                        'glAlphaFragmentOp3ATI',
                                        'glBeginFragmentShaderATI',
                                        'glBindFragmentShaderATI',
                                        'glColorFragmentOp1ATI',
                                        'glColorFragmentOp2ATI',
                                        'glColorFragmentOp3ATI',
                                        'glDeleteFragmentShaderATI',
                                        'glEndFragmentShaderATI',
                                        'glGenFragmentShadersATI',
                                        'glPassTexCoordATI',
                                        'glSampleMapATI',
                                        'glSetFragmentShaderConstantATI'
                                      ],
          'GL_ATI_map_object_buffer' => [
                                          'glMapObjectBufferATI',
                                          'glUnmapObjectBufferATI'
                                        ],
          'GL_ATI_pn_triangles' => [
                                     'glPNTrianglesfATI',
                                     'glPNTrianglesiATI'
                                   ],
          'GL_ATI_separate_stencil' => [
                                         'glStencilFuncSeparateATI',
                                         'glStencilOpSeparateATI'
                                       ],
          'GL_ATI_vertex_array_object' => [
                                            'glArrayObjectATI',
                                            'glFreeObjectBufferATI',
                                            'glGetArrayObjectfvATI',
                                            'glGetArrayObjectivATI',
                                            'glGetObjectBufferfvATI',
                                            'glGetObjectBufferivATI',
                                            'glGetVariantArrayObjectfvATI',
                                            'glGetVariantArrayObjectivATI',
                                            'glIsObjectBufferATI',
                                            'glNewObjectBufferATI',
                                            'glUpdateObjectBufferATI',
                                            'glVariantArrayObjectATI'
                                          ],
          'GL_ATI_vertex_attrib_array_object' => [
                                                   'glGetVertexAttribArrayObjectfvATI',
                                                   'glGetVertexAttribArrayObjectivATI',
                                                   'glVertexAttribArrayObjectATI'
                                                 ],
          'GL_ATI_vertex_streams' => [
                                       'glClientActiveVertexStreamATI',
                                       'glNormalStream3bATI',
                                       'glNormalStream3bvATI',
                                       'glNormalStream3dATI',
                                       'glNormalStream3dvATI',
                                       'glNormalStream3fATI',
                                       'glNormalStream3fvATI',
                                       'glNormalStream3iATI',
                                       'glNormalStream3ivATI',
                                       'glNormalStream3sATI',
                                       'glNormalStream3svATI',
                                       'glVertexBlendEnvfATI',
                                       'glVertexBlendEnviATI',
                                       'glVertexStream1dATI',
                                       'glVertexStream1dvATI',
                                       'glVertexStream1fATI',
                                       'glVertexStream1fvATI',
                                       'glVertexStream1iATI',
                                       'glVertexStream1ivATI',
                                       'glVertexStream1sATI',
                                       'glVertexStream1svATI',
                                       'glVertexStream2dATI',
                                       'glVertexStream2dvATI',
                                       'glVertexStream2fATI',
                                       'glVertexStream2fvATI',
                                       'glVertexStream2iATI',
                                       'glVertexStream2ivATI',
                                       'glVertexStream2sATI',
                                       'glVertexStream2svATI',
                                       'glVertexStream3dATI',
                                       'glVertexStream3dvATI',
                                       'glVertexStream3fATI',
                                       'glVertexStream3fvATI',
                                       'glVertexStream3iATI',
                                       'glVertexStream3ivATI',
                                       'glVertexStream3sATI',
                                       'glVertexStream3svATI',
                                       'glVertexStream4dATI',
                                       'glVertexStream4dvATI',
                                       'glVertexStream4fATI',
                                       'glVertexStream4fvATI',
                                       'glVertexStream4iATI',
                                       'glVertexStream4ivATI',
                                       'glVertexStream4sATI',
                                       'glVertexStream4svATI'
                                     ],
          'GL_EXT_bindable_uniform' => [
                                         'glGetUniformBufferSizeEXT',
                                         'glGetUniformOffsetEXT',
                                         'glUniformBufferEXT'
                                       ],
          'GL_EXT_blend_color' => [
                                    'glBlendColorEXT'
                                  ],
          'GL_EXT_blend_equation_separate' => [
                                                'glBlendEquationSeparateEXT'
                                              ],
          'GL_EXT_blend_func_separate' => [
                                            'glBlendFuncSeparateEXT'
                                          ],
          'GL_EXT_blend_minmax' => [
                                     'glBlendEquationEXT'
                                   ],
          'GL_EXT_color_subtable' => [
                                       'glColorSubTableEXT',
                                       'glCopyColorSubTableEXT'
                                     ],
          'GL_EXT_compiled_vertex_array' => [
                                              'glLockArraysEXT',
                                              'glUnlockArraysEXT'
                                            ],
          'GL_EXT_convolution' => [
                                    'glConvolutionFilter1DEXT',
                                    'glConvolutionFilter2DEXT',
                                    'glConvolutionParameterfEXT',
                                    'glConvolutionParameterfvEXT',
                                    'glConvolutionParameteriEXT',
                                    'glConvolutionParameterivEXT',
                                    'glCopyConvolutionFilter1DEXT',
                                    'glCopyConvolutionFilter2DEXT',
                                    'glGetConvolutionFilterEXT',
                                    'glGetConvolutionParameterfvEXT',
                                    'glGetConvolutionParameterivEXT',
                                    'glGetSeparableFilterEXT',
                                    'glSeparableFilter2DEXT'
                                  ],
          'GL_EXT_coordinate_frame' => [
                                         'glBinormalPointerEXT',
                                         'glTangentPointerEXT'
                                       ],
          'GL_EXT_copy_texture' => [
                                     'glCopyTexImage1DEXT',
                                     'glCopyTexImage2DEXT',
                                     'glCopyTexSubImage1DEXT',
                                     'glCopyTexSubImage2DEXT',
                                     'glCopyTexSubImage3DEXT'
                                   ],
          'GL_EXT_cull_vertex' => [
                                    'glCullParameterdvEXT',
                                    'glCullParameterfvEXT'
                                  ],
          'GL_EXT_debug_label' => [
                                    'glGetObjectLabelEXT',
                                    'glLabelObjectEXT'
                                  ],
          'GL_EXT_debug_marker' => [
                                     'glInsertEventMarkerEXT',
                                     'glPopGroupMarkerEXT',
                                     'glPushGroupMarkerEXT'
                                   ],
          'GL_EXT_depth_bounds_test' => [
                                          'glDepthBoundsEXT'
                                        ],
          'GL_EXT_direct_state_access' => [
                                            'glBindMultiTextureEXT',
                                            'glCheckNamedFramebufferStatusEXT',
                                            'glClientAttribDefaultEXT',
                                            'glCompressedMultiTexImage1DEXT',
                                            'glCompressedMultiTexImage2DEXT',
                                            'glCompressedMultiTexImage3DEXT',
                                            'glCompressedMultiTexSubImage1DEXT',
                                            'glCompressedMultiTexSubImage2DEXT',
                                            'glCompressedMultiTexSubImage3DEXT',
                                            'glCompressedTextureImage1DEXT',
                                            'glCompressedTextureImage2DEXT',
                                            'glCompressedTextureImage3DEXT',
                                            'glCompressedTextureSubImage1DEXT',
                                            'glCompressedTextureSubImage2DEXT',
                                            'glCompressedTextureSubImage3DEXT',
                                            'glCopyMultiTexImage1DEXT',
                                            'glCopyMultiTexImage2DEXT',
                                            'glCopyMultiTexSubImage1DEXT',
                                            'glCopyMultiTexSubImage2DEXT',
                                            'glCopyMultiTexSubImage3DEXT',
                                            'glCopyTextureImage1DEXT',
                                            'glCopyTextureImage2DEXT',
                                            'glCopyTextureSubImage1DEXT',
                                            'glCopyTextureSubImage2DEXT',
                                            'glCopyTextureSubImage3DEXT',
                                            'glDisableClientStateIndexedEXT',
                                            'glDisableClientStateiEXT',
                                            'glDisableVertexArrayAttribEXT',
                                            'glDisableVertexArrayEXT',
                                            'glEnableClientStateIndexedEXT',
                                            'glEnableClientStateiEXT',
                                            'glEnableVertexArrayAttribEXT',
                                            'glEnableVertexArrayEXT',
                                            'glFlushMappedNamedBufferRangeEXT',
                                            'glFramebufferDrawBufferEXT',
                                            'glFramebufferDrawBuffersEXT',
                                            'glFramebufferReadBufferEXT',
                                            'glGenerateMultiTexMipmapEXT',
                                            'glGenerateTextureMipmapEXT',
                                            'glGetCompressedMultiTexImageEXT',
                                            'glGetCompressedTextureImageEXT',
                                            'glGetDoubleIndexedvEXT',
                                            'glGetDoublei_vEXT',
                                            'glGetFloatIndexedvEXT',
                                            'glGetFloati_vEXT',
                                            'glGetFramebufferParameterivEXT',
                                            'glGetMultiTexEnvfvEXT',
                                            'glGetMultiTexEnvivEXT',
                                            'glGetMultiTexGendvEXT',
                                            'glGetMultiTexGenfvEXT',
                                            'glGetMultiTexGenivEXT',
                                            'glGetMultiTexImageEXT',
                                            'glGetMultiTexLevelParameterfvEXT',
                                            'glGetMultiTexLevelParameterivEXT',
                                            'glGetMultiTexParameterIivEXT',
                                            'glGetMultiTexParameterIuivEXT',
                                            'glGetMultiTexParameterfvEXT',
                                            'glGetMultiTexParameterivEXT',
                                            'glGetNamedBufferParameterivEXT',
                                            'glGetNamedBufferPointervEXT',
                                            'glGetNamedBufferSubDataEXT',
                                            'glGetNamedFramebufferAttachmentParameterivEXT',
                                            'glGetNamedProgramLocalParameterIivEXT',
                                            'glGetNamedProgramLocalParameterIuivEXT',
                                            'glGetNamedProgramLocalParameterdvEXT',
                                            'glGetNamedProgramLocalParameterfvEXT',
                                            'glGetNamedProgramStringEXT',
                                            'glGetNamedProgramivEXT',
                                            'glGetNamedRenderbufferParameterivEXT',
                                            'glGetPointerIndexedvEXT',
                                            'glGetPointeri_vEXT',
                                            'glGetTextureImageEXT',
                                            'glGetTextureLevelParameterfvEXT',
                                            'glGetTextureLevelParameterivEXT',
                                            'glGetTextureParameterIivEXT',
                                            'glGetTextureParameterIuivEXT',
                                            'glGetTextureParameterfvEXT',
                                            'glGetTextureParameterivEXT',
                                            'glGetVertexArrayIntegeri_vEXT',
                                            'glGetVertexArrayIntegervEXT',
                                            'glGetVertexArrayPointeri_vEXT',
                                            'glGetVertexArrayPointervEXT',
                                            'glMapNamedBufferEXT',
                                            'glMapNamedBufferRangeEXT',
                                            'glMatrixFrustumEXT',
                                            'glMatrixLoadIdentityEXT',
                                            'glMatrixLoadTransposedEXT',
                                            'glMatrixLoadTransposefEXT',
                                            'glMatrixLoaddEXT',
                                            'glMatrixLoadfEXT',
                                            'glMatrixMultTransposedEXT',
                                            'glMatrixMultTransposefEXT',
                                            'glMatrixMultdEXT',
                                            'glMatrixMultfEXT',
                                            'glMatrixOrthoEXT',
                                            'glMatrixPopEXT',
                                            'glMatrixPushEXT',
                                            'glMatrixRotatedEXT',
                                            'glMatrixRotatefEXT',
                                            'glMatrixScaledEXT',
                                            'glMatrixScalefEXT',
                                            'glMatrixTranslatedEXT',
                                            'glMatrixTranslatefEXT',
                                            'glMultiTexBufferEXT',
                                            'glMultiTexCoordPointerEXT',
                                            'glMultiTexEnvfEXT',
                                            'glMultiTexEnvfvEXT',
                                            'glMultiTexEnviEXT',
                                            'glMultiTexEnvivEXT',
                                            'glMultiTexGendEXT',
                                            'glMultiTexGendvEXT',
                                            'glMultiTexGenfEXT',
                                            'glMultiTexGenfvEXT',
                                            'glMultiTexGeniEXT',
                                            'glMultiTexGenivEXT',
                                            'glMultiTexImage1DEXT',
                                            'glMultiTexImage2DEXT',
                                            'glMultiTexImage3DEXT',
                                            'glMultiTexParameterIivEXT',
                                            'glMultiTexParameterIuivEXT',
                                            'glMultiTexParameterfEXT',
                                            'glMultiTexParameterfvEXT',
                                            'glMultiTexParameteriEXT',
                                            'glMultiTexParameterivEXT',
                                            'glMultiTexRenderbufferEXT',
                                            'glMultiTexSubImage1DEXT',
                                            'glMultiTexSubImage2DEXT',
                                            'glMultiTexSubImage3DEXT',
                                            'glNamedBufferDataEXT',
                                            'glNamedBufferSubDataEXT',
                                            'glNamedCopyBufferSubDataEXT',
                                            'glNamedFramebufferRenderbufferEXT',
                                            'glNamedFramebufferTexture1DEXT',
                                            'glNamedFramebufferTexture2DEXT',
                                            'glNamedFramebufferTexture3DEXT',
                                            'glNamedFramebufferTextureEXT',
                                            'glNamedFramebufferTextureFaceEXT',
                                            'glNamedFramebufferTextureLayerEXT',
                                            'glNamedProgramLocalParameter4dEXT',
                                            'glNamedProgramLocalParameter4dvEXT',
                                            'glNamedProgramLocalParameter4fEXT',
                                            'glNamedProgramLocalParameter4fvEXT',
                                            'glNamedProgramLocalParameterI4iEXT',
                                            'glNamedProgramLocalParameterI4ivEXT',
                                            'glNamedProgramLocalParameterI4uiEXT',
                                            'glNamedProgramLocalParameterI4uivEXT',
                                            'glNamedProgramLocalParameters4fvEXT',
                                            'glNamedProgramLocalParametersI4ivEXT',
                                            'glNamedProgramLocalParametersI4uivEXT',
                                            'glNamedProgramStringEXT',
                                            'glNamedRenderbufferStorageEXT',
                                            'glNamedRenderbufferStorageMultisampleCoverageEXT',
                                            'glNamedRenderbufferStorageMultisampleEXT',
                                            'glProgramUniform1fEXT',
                                            'glProgramUniform1fvEXT',
                                            'glProgramUniform1iEXT',
                                            'glProgramUniform1ivEXT',
                                            'glProgramUniform1uiEXT',
                                            'glProgramUniform1uivEXT',
                                            'glProgramUniform2fEXT',
                                            'glProgramUniform2fvEXT',
                                            'glProgramUniform2iEXT',
                                            'glProgramUniform2ivEXT',
                                            'glProgramUniform2uiEXT',
                                            'glProgramUniform2uivEXT',
                                            'glProgramUniform3fEXT',
                                            'glProgramUniform3fvEXT',
                                            'glProgramUniform3iEXT',
                                            'glProgramUniform3ivEXT',
                                            'glProgramUniform3uiEXT',
                                            'glProgramUniform3uivEXT',
                                            'glProgramUniform4fEXT',
                                            'glProgramUniform4fvEXT',
                                            'glProgramUniform4iEXT',
                                            'glProgramUniform4ivEXT',
                                            'glProgramUniform4uiEXT',
                                            'glProgramUniform4uivEXT',
                                            'glProgramUniformMatrix2fvEXT',
                                            'glProgramUniformMatrix2x3fvEXT',
                                            'glProgramUniformMatrix2x4fvEXT',
                                            'glProgramUniformMatrix3fvEXT',
                                            'glProgramUniformMatrix3x2fvEXT',
                                            'glProgramUniformMatrix3x4fvEXT',
                                            'glProgramUniformMatrix4fvEXT',
                                            'glProgramUniformMatrix4x2fvEXT',
                                            'glProgramUniformMatrix4x3fvEXT',
                                            'glPushClientAttribDefaultEXT',
                                            'glTextureBufferEXT',
                                            'glTextureImage1DEXT',
                                            'glTextureImage2DEXT',
                                            'glTextureImage3DEXT',
                                            'glTextureParameterIivEXT',
                                            'glTextureParameterIuivEXT',
                                            'glTextureParameterfEXT',
                                            'glTextureParameterfvEXT',
                                            'glTextureParameteriEXT',
                                            'glTextureParameterivEXT',
                                            'glTextureRenderbufferEXT',
                                            'glTextureSubImage1DEXT',
                                            'glTextureSubImage2DEXT',
                                            'glTextureSubImage3DEXT',
                                            'glUnmapNamedBufferEXT',
                                            'glVertexArrayColorOffsetEXT',
                                            'glVertexArrayEdgeFlagOffsetEXT',
                                            'glVertexArrayFogCoordOffsetEXT',
                                            'glVertexArrayIndexOffsetEXT',
                                            'glVertexArrayMultiTexCoordOffsetEXT',
                                            'glVertexArrayNormalOffsetEXT',
                                            'glVertexArraySecondaryColorOffsetEXT',
                                            'glVertexArrayTexCoordOffsetEXT',
                                            'glVertexArrayVertexAttribDivisorEXT',
                                            'glVertexArrayVertexAttribIOffsetEXT',
                                            'glVertexArrayVertexAttribOffsetEXT',
                                            'glVertexArrayVertexOffsetEXT'
                                          ],
          'GL_EXT_draw_buffers2' => [
                                      'glColorMaskIndexedEXT',
                                      'glDisableIndexedEXT',
                                      'glEnableIndexedEXT',
                                      'glGetBooleanIndexedvEXT',
                                      'glGetIntegerIndexedvEXT',
                                      'glIsEnabledIndexedEXT'
                                    ],
          'GL_EXT_draw_instanced' => [
                                       'glDrawArraysInstancedEXT',
                                       'glDrawElementsInstancedEXT'
                                     ],
          'GL_EXT_draw_range_elements' => [
                                            'glDrawRangeElementsEXT'
                                          ],
          'GL_EXT_fog_coord' => [
                                  'glFogCoordPointerEXT',
                                  'glFogCoorddEXT',
                                  'glFogCoorddvEXT',
                                  'glFogCoordfEXT',
                                  'glFogCoordfvEXT'
                                ],
          'GL_EXT_fragment_lighting' => [
                                          'glFragmentColorMaterialEXT',
                                          'glFragmentLightModelfEXT',
                                          'glFragmentLightModelfvEXT',
                                          'glFragmentLightModeliEXT',
                                          'glFragmentLightModelivEXT',
                                          'glFragmentLightfEXT',
                                          'glFragmentLightfvEXT',
                                          'glFragmentLightiEXT',
                                          'glFragmentLightivEXT',
                                          'glFragmentMaterialfEXT',
                                          'glFragmentMaterialfvEXT',
                                          'glFragmentMaterialiEXT',
                                          'glFragmentMaterialivEXT',
                                          'glGetFragmentLightfvEXT',
                                          'glGetFragmentLightivEXT',
                                          'glGetFragmentMaterialfvEXT',
                                          'glGetFragmentMaterialivEXT',
                                          'glLightEnviEXT'
                                        ],
          'GL_EXT_framebuffer_blit' => [
                                         'glBlitFramebufferEXT'
                                       ],
          'GL_EXT_framebuffer_multisample' => [
                                                'glRenderbufferStorageMultisampleEXT'
                                              ],
          'GL_EXT_framebuffer_object' => [
                                           'glBindFramebufferEXT',
                                           'glBindRenderbufferEXT',
                                           'glCheckFramebufferStatusEXT',
                                           'glDeleteFramebuffersEXT',
                                           'glDeleteRenderbuffersEXT',
                                           'glFramebufferRenderbufferEXT',
                                           'glFramebufferTexture1DEXT',
                                           'glFramebufferTexture2DEXT',
                                           'glFramebufferTexture3DEXT',
                                           'glGenFramebuffersEXT',
                                           'glGenRenderbuffersEXT',
                                           'glGenerateMipmapEXT',
                                           'glGetFramebufferAttachmentParameterivEXT',
                                           'glGetRenderbufferParameterivEXT',
                                           'glIsFramebufferEXT',
                                           'glIsRenderbufferEXT',
                                           'glRenderbufferStorageEXT'
                                         ],
          'GL_EXT_geometry_shader4' => [
                                         'glFramebufferTextureEXT',
                                         'glFramebufferTextureFaceEXT',
                                         'glProgramParameteriEXT'
                                       ],
          'GL_EXT_gpu_program_parameters' => [
                                               'glProgramEnvParameters4fvEXT',
                                               'glProgramLocalParameters4fvEXT'
                                             ],
          'GL_EXT_gpu_shader4' => [
                                    'glBindFragDataLocationEXT',
                                    'glGetFragDataLocationEXT',
                                    'glGetUniformuivEXT',
                                    'glGetVertexAttribIivEXT',
                                    'glGetVertexAttribIuivEXT',
                                    'glUniform1uiEXT',
                                    'glUniform1uivEXT',
                                    'glUniform2uiEXT',
                                    'glUniform2uivEXT',
                                    'glUniform3uiEXT',
                                    'glUniform3uivEXT',
                                    'glUniform4uiEXT',
                                    'glUniform4uivEXT',
                                    'glVertexAttribI1iEXT',
                                    'glVertexAttribI1ivEXT',
                                    'glVertexAttribI1uiEXT',
                                    'glVertexAttribI1uivEXT',
                                    'glVertexAttribI2iEXT',
                                    'glVertexAttribI2ivEXT',
                                    'glVertexAttribI2uiEXT',
                                    'glVertexAttribI2uivEXT',
                                    'glVertexAttribI3iEXT',
                                    'glVertexAttribI3ivEXT',
                                    'glVertexAttribI3uiEXT',
                                    'glVertexAttribI3uivEXT',
                                    'glVertexAttribI4bvEXT',
                                    'glVertexAttribI4iEXT',
                                    'glVertexAttribI4ivEXT',
                                    'glVertexAttribI4svEXT',
                                    'glVertexAttribI4ubvEXT',
                                    'glVertexAttribI4uiEXT',
                                    'glVertexAttribI4uivEXT',
                                    'glVertexAttribI4usvEXT',
                                    'glVertexAttribIPointerEXT'
                                  ],
          'GL_EXT_histogram' => [
                                  'glGetHistogramEXT',
                                  'glGetHistogramParameterfvEXT',
                                  'glGetHistogramParameterivEXT',
                                  'glGetMinmaxEXT',
                                  'glGetMinmaxParameterfvEXT',
                                  'glGetMinmaxParameterivEXT',
                                  'glHistogramEXT',
                                  'glMinmaxEXT',
                                  'glResetHistogramEXT',
                                  'glResetMinmaxEXT'
                                ],
          'GL_EXT_index_func' => [
                                   'glIndexFuncEXT'
                                 ],
          'GL_EXT_index_material' => [
                                       'glIndexMaterialEXT'
                                     ],
          'GL_EXT_light_texture' => [
                                      'glApplyTextureEXT',
                                      'glTextureLightEXT',
                                      'glTextureMaterialEXT'
                                    ],
          'GL_EXT_multi_draw_arrays' => [
                                          'glMultiDrawArraysEXT',
                                          'glMultiDrawElementsEXT'
                                        ],
          'GL_EXT_multisample' => [
                                    'glSampleMaskEXT',
                                    'glSamplePatternEXT'
                                  ],
          'GL_EXT_paletted_texture' => [
                                         'glColorTableEXT',
                                         'glGetColorTableEXT',
                                         'glGetColorTableParameterfvEXT',
                                         'glGetColorTableParameterivEXT'
                                       ],
          'GL_EXT_pixel_transform' => [
                                        'glGetPixelTransformParameterfvEXT',
                                        'glGetPixelTransformParameterivEXT',
                                        'glPixelTransformParameterfEXT',
                                        'glPixelTransformParameterfvEXT',
                                        'glPixelTransformParameteriEXT',
                                        'glPixelTransformParameterivEXT'
                                      ],
          'GL_EXT_point_parameters' => [
                                         'glPointParameterfEXT',
                                         'glPointParameterfvEXT'
                                       ],
          'GL_EXT_polygon_offset' => [
                                       'glPolygonOffsetEXT'
                                     ],
          'GL_EXT_polygon_offset_clamp' => [
                                             'glPolygonOffsetClampEXT'
                                           ],
          'GL_EXT_provoking_vertex' => [
                                         'glProvokingVertexEXT'
                                       ],
          'GL_EXT_raster_multisample' => [
                                           'glCoverageModulationNV',
                                           'glCoverageModulationTableNV',
                                           'glGetCoverageModulationTableNV',
                                           'glRasterSamplesEXT'
                                         ],
          'GL_EXT_scene_marker' => [
                                     'glBeginSceneEXT',
                                     'glEndSceneEXT'
                                   ],
          'GL_EXT_secondary_color' => [
                                        'glSecondaryColor3bEXT',
                                        'glSecondaryColor3bvEXT',
                                        'glSecondaryColor3dEXT',
                                        'glSecondaryColor3dvEXT',
                                        'glSecondaryColor3fEXT',
                                        'glSecondaryColor3fvEXT',
                                        'glSecondaryColor3iEXT',
                                        'glSecondaryColor3ivEXT',
                                        'glSecondaryColor3sEXT',
                                        'glSecondaryColor3svEXT',
                                        'glSecondaryColor3ubEXT',
                                        'glSecondaryColor3ubvEXT',
                                        'glSecondaryColor3uiEXT',
                                        'glSecondaryColor3uivEXT',
                                        'glSecondaryColor3usEXT',
                                        'glSecondaryColor3usvEXT',
                                        'glSecondaryColorPointerEXT'
                                      ],
          'GL_EXT_separate_shader_objects' => [
                                                'glActiveProgramEXT',
                                                'glCreateShaderProgramEXT',
                                                'glUseShaderProgramEXT'
                                              ],
          'GL_EXT_shader_image_load_store' => [
                                                'glBindImageTextureEXT',
                                                'glMemoryBarrierEXT'
                                              ],
          'GL_EXT_stencil_two_side' => [
                                         'glActiveStencilFaceEXT'
                                       ],
          'GL_EXT_subtexture' => [
                                   'glTexSubImage1DEXT',
                                   'glTexSubImage2DEXT',
                                   'glTexSubImage3DEXT'
                                 ],
          'GL_EXT_texture3D' => [
                                  'glTexImage3DEXT'
                                ],
          'GL_EXT_texture_array' => [
                                      'glFramebufferTextureLayerEXT'
                                    ],
          'GL_EXT_texture_buffer_object' => [
                                              'glTexBufferEXT'
                                            ],
          'GL_EXT_texture_integer' => [
                                        'glClearColorIiEXT',
                                        'glClearColorIuiEXT',
                                        'glGetTexParameterIivEXT',
                                        'glGetTexParameterIuivEXT',
                                        'glTexParameterIivEXT',
                                        'glTexParameterIuivEXT'
                                      ],
          'GL_EXT_texture_object' => [
                                       'glAreTexturesResidentEXT',
                                       'glBindTextureEXT',
                                       'glDeleteTexturesEXT',
                                       'glGenTexturesEXT',
                                       'glIsTextureEXT',
                                       'glPrioritizeTexturesEXT'
                                     ],
          'GL_EXT_texture_perturb_normal' => [
                                               'glTextureNormalEXT'
                                             ],
          'GL_EXT_timer_query' => [
                                    'glGetQueryObjecti64vEXT',
                                    'glGetQueryObjectui64vEXT'
                                  ],
          'GL_EXT_transform_feedback' => [
                                           'glBeginTransformFeedbackEXT',
                                           'glBindBufferBaseEXT',
                                           'glBindBufferOffsetEXT',
                                           'glBindBufferRangeEXT',
                                           'glEndTransformFeedbackEXT',
                                           'glGetTransformFeedbackVaryingEXT',
                                           'glTransformFeedbackVaryingsEXT'
                                         ],
          'GL_EXT_vertex_array' => [
                                     'glArrayElementEXT',
                                     'glColorPointerEXT',
                                     'glDrawArraysEXT',
                                     'glEdgeFlagPointerEXT',
                                     'glIndexPointerEXT',
                                     'glNormalPointerEXT',
                                     'glTexCoordPointerEXT',
                                     'glVertexPointerEXT'
                                   ],
          'GL_EXT_vertex_attrib_64bit' => [
                                            'glGetVertexAttribLdvEXT',
                                            'glVertexArrayVertexAttribLOffsetEXT',
                                            'glVertexAttribL1dEXT',
                                            'glVertexAttribL1dvEXT',
                                            'glVertexAttribL2dEXT',
                                            'glVertexAttribL2dvEXT',
                                            'glVertexAttribL3dEXT',
                                            'glVertexAttribL3dvEXT',
                                            'glVertexAttribL4dEXT',
                                            'glVertexAttribL4dvEXT',
                                            'glVertexAttribLPointerEXT'
                                          ],
          'GL_EXT_vertex_shader' => [
                                      'glBeginVertexShaderEXT',
                                      'glBindLightParameterEXT',
                                      'glBindMaterialParameterEXT',
                                      'glBindParameterEXT',
                                      'glBindTexGenParameterEXT',
                                      'glBindTextureUnitParameterEXT',
                                      'glBindVertexShaderEXT',
                                      'glDeleteVertexShaderEXT',
                                      'glDisableVariantClientStateEXT',
                                      'glEnableVariantClientStateEXT',
                                      'glEndVertexShaderEXT',
                                      'glExtractComponentEXT',
                                      'glGenSymbolsEXT',
                                      'glGenVertexShadersEXT',
                                      'glGetInvariantBooleanvEXT',
                                      'glGetInvariantFloatvEXT',
                                      'glGetInvariantIntegervEXT',
                                      'glGetLocalConstantBooleanvEXT',
                                      'glGetLocalConstantFloatvEXT',
                                      'glGetLocalConstantIntegervEXT',
                                      'glGetVariantBooleanvEXT',
                                      'glGetVariantFloatvEXT',
                                      'glGetVariantIntegervEXT',
                                      'glGetVariantPointervEXT',
                                      'glInsertComponentEXT',
                                      'glIsVariantEnabledEXT',
                                      'glSetInvariantEXT',
                                      'glSetLocalConstantEXT',
                                      'glShaderOp1EXT',
                                      'glShaderOp2EXT',
                                      'glShaderOp3EXT',
                                      'glSwizzleEXT',
                                      'glVariantPointerEXT',
                                      'glVariantbvEXT',
                                      'glVariantdvEXT',
                                      'glVariantfvEXT',
                                      'glVariantivEXT',
                                      'glVariantsvEXT',
                                      'glVariantubvEXT',
                                      'glVariantuivEXT',
                                      'glVariantusvEXT',
                                      'glWriteMaskEXT'
                                    ],
          'GL_EXT_vertex_weighting' => [
                                         'glVertexWeightPointerEXT',
                                         'glVertexWeightfEXT',
                                         'glVertexWeightfvEXT'
                                       ],
          'GL_EXT_window_rectangles' => [
                                          'glWindowRectanglesEXT'
                                        ],
          'GL_EXT_x11_sync_object' => [
                                        'glImportSyncEXT'
                                      ],
          'GL_GREMEDY_frame_terminator' => [
                                             'glFrameTerminatorGREMEDY'
                                           ],
          'GL_GREMEDY_string_marker' => [
                                          'glStringMarkerGREMEDY'
                                        ],
          'GL_HP_image_transform' => [
                                       'glGetImageTransformParameterfvHP',
                                       'glGetImageTransformParameterivHP',
                                       'glImageTransformParameterfHP',
                                       'glImageTransformParameterfvHP',
                                       'glImageTransformParameteriHP',
                                       'glImageTransformParameterivHP'
                                     ],
          'GL_IBM_multimode_draw_arrays' => [
                                              'glMultiModeDrawArraysIBM',
                                              'glMultiModeDrawElementsIBM'
                                            ],
          'GL_IBM_vertex_array_lists' => [
                                           'glColorPointerListIBM',
                                           'glEdgeFlagPointerListIBM',
                                           'glFogCoordPointerListIBM',
                                           'glIndexPointerListIBM',
                                           'glNormalPointerListIBM',
                                           'glSecondaryColorPointerListIBM',
                                           'glTexCoordPointerListIBM',
                                           'glVertexPointerListIBM'
                                         ],
          'GL_INTEL_parallel_arrays' => [
                                          'glColorPointervINTEL',
                                          'glNormalPointervINTEL',
                                          'glTexCoordPointervINTEL',
                                          'glVertexPointervINTEL'
                                        ],
          'GL_INTEL_performance_query' => [
                                            'glBeginPerfQueryINTEL',
                                            'glCreatePerfQueryINTEL',
                                            'glDeletePerfQueryINTEL',
                                            'glEndPerfQueryINTEL',
                                            'glGetFirstPerfQueryIdINTEL',
                                            'glGetNextPerfQueryIdINTEL',
                                            'glGetPerfCounterInfoINTEL',
                                            'glGetPerfQueryDataINTEL',
                                            'glGetPerfQueryIdByNameINTEL',
                                            'glGetPerfQueryInfoINTEL'
                                          ],
          'GL_INTEL_texture_scissor' => [
                                          'glTexScissorFuncINTEL',
                                          'glTexScissorINTEL'
                                        ],
          'GL_KHR_blend_equation_advanced' => [
                                                'glBlendBarrierKHR'
                                              ],
          'GL_KHR_debug' => [
                              'glDebugMessageCallback',
                              'glDebugMessageControl',
                              'glDebugMessageInsert',
                              'glGetDebugMessageLog',
                              'glGetObjectLabel',
                              'glGetObjectPtrLabel',
                              'glObjectLabel',
                              'glObjectPtrLabel',
                              'glPopDebugGroup',
                              'glPushDebugGroup'
                            ],
          'GL_KHR_robustness' => [
                                   'glGetnUniformfv',
                                   'glGetnUniformiv',
                                   'glGetnUniformuiv',
                                   'glReadnPixels'
                                 ],
          'GL_KTX_buffer_region' => [
                                      'glBufferRegionEnabled',
                                      'glDeleteBufferRegion',
                                      'glDrawBufferRegion',
                                      'glNewBufferRegion',
                                      'glReadBufferRegion'
                                    ],
          'GL_LAYOUT_LINEAR_INTEL' => [
                                        'glMapTexture2DINTEL',
                                        'glSyncTextureINTEL',
                                        'glUnmapTexture2DINTEL'
                                      ],
          'GL_MESA_resize_buffers' => [
                                        'glResizeBuffersMESA'
                                      ],
          'GL_MESA_window_pos' => [
                                    'glWindowPos2dMESA',
                                    'glWindowPos2dvMESA',
                                    'glWindowPos2fMESA',
                                    'glWindowPos2fvMESA',
                                    'glWindowPos2iMESA',
                                    'glWindowPos2ivMESA',
                                    'glWindowPos2sMESA',
                                    'glWindowPos2svMESA',
                                    'glWindowPos3dMESA',
                                    'glWindowPos3dvMESA',
                                    'glWindowPos3fMESA',
                                    'glWindowPos3fvMESA',
                                    'glWindowPos3iMESA',
                                    'glWindowPos3ivMESA',
                                    'glWindowPos3sMESA',
                                    'glWindowPos3svMESA',
                                    'glWindowPos4dMESA',
                                    'glWindowPos4dvMESA',
                                    'glWindowPos4fMESA',
                                    'glWindowPos4fvMESA',
                                    'glWindowPos4iMESA',
                                    'glWindowPos4ivMESA',
                                    'glWindowPos4sMESA',
                                    'glWindowPos4svMESA'
                                  ],
          'GL_NVX_conditional_render' => [
                                           'glBeginConditionalRenderNVX',
                                           'glEndConditionalRenderNVX'
                                         ],
          'GL_NVX_linked_gpu_multicast' => [
                                             'glLGPUCopyImageSubDataNVX',
                                             'glLGPUInterlockNVX',
                                             'glLGPUNamedBufferSubDataNVX'
                                           ],
          'GL_NV_bindless_multi_draw_indirect' => [
                                                    'glMultiDrawArraysIndirectBindlessNV',
                                                    'glMultiDrawElementsIndirectBindlessNV'
                                                  ],
          'GL_NV_bindless_multi_draw_indirect_count' => [
                                                          'glMultiDrawArraysIndirectBindlessCountNV',
                                                          'glMultiDrawElementsIndirectBindlessCountNV'
                                                        ],
          'GL_NV_bindless_texture' => [
                                        'glGetImageHandleNV',
                                        'glGetTextureHandleNV',
                                        'glGetTextureSamplerHandleNV',
                                        'glIsImageHandleResidentNV',
                                        'glIsTextureHandleResidentNV',
                                        'glMakeImageHandleNonResidentNV',
                                        'glMakeImageHandleResidentNV',
                                        'glMakeTextureHandleNonResidentNV',
                                        'glMakeTextureHandleResidentNV',
                                        'glProgramUniformHandleui64NV',
                                        'glProgramUniformHandleui64vNV',
                                        'glUniformHandleui64NV',
                                        'glUniformHandleui64vNV'
                                      ],
          'GL_NV_blend_equation_advanced' => [
                                               'glBlendBarrierNV',
                                               'glBlendParameteriNV'
                                             ],
          'GL_NV_clip_space_w_scaling' => [
                                            'glViewportPositionWScaleNV'
                                          ],
          'GL_NV_command_list' => [
                                    'glCallCommandListNV',
                                    'glCommandListSegmentsNV',
                                    'glCompileCommandListNV',
                                    'glCreateCommandListsNV',
                                    'glCreateStatesNV',
                                    'glDeleteCommandListsNV',
                                    'glDeleteStatesNV',
                                    'glDrawCommandsAddressNV',
                                    'glDrawCommandsNV',
                                    'glDrawCommandsStatesAddressNV',
                                    'glDrawCommandsStatesNV',
                                    'glGetCommandHeaderNV',
                                    'glGetStageIndexNV',
                                    'glIsCommandListNV',
                                    'glIsStateNV',
                                    'glListDrawCommandsStatesClientNV',
                                    'glStateCaptureNV'
                                  ],
          'GL_NV_conditional_render' => [
                                          'glBeginConditionalRenderNV',
                                          'glEndConditionalRenderNV'
                                        ],
          'GL_NV_conservative_raster' => [
                                           'glSubpixelPrecisionBiasNV'
                                         ],
          'GL_NV_conservative_raster_dilate' => [
                                                  'glConservativeRasterParameterfNV'
                                                ],
          'GL_NV_conservative_raster_pre_snap_triangles' => [
                                                              'glConservativeRasterParameteriNV'
                                                            ],
          'GL_NV_copy_image' => [
                                  'glCopyImageSubDataNV'
                                ],
          'GL_NV_depth_buffer_float' => [
                                          'glClearDepthdNV',
                                          'glDepthBoundsdNV',
                                          'glDepthRangedNV'
                                        ],
          'GL_NV_draw_texture' => [
                                    'glDrawTextureNV'
                                  ],
          'GL_NV_draw_vulkan_image' => [
                                         'glDrawVkImageNV',
                                         'glGetVkProcAddrNV',
                                         'glSignalVkFenceNV',
                                         'glSignalVkSemaphoreNV',
                                         'glWaitVkSemaphoreNV'
                                       ],
          'GL_NV_evaluators' => [
                                  'glEvalMapsNV',
                                  'glGetMapAttribParameterfvNV',
                                  'glGetMapAttribParameterivNV',
                                  'glGetMapControlPointsNV',
                                  'glGetMapParameterfvNV',
                                  'glGetMapParameterivNV',
                                  'glMapControlPointsNV',
                                  'glMapParameterfvNV',
                                  'glMapParameterivNV'
                                ],
          'GL_NV_explicit_multisample' => [
                                            'glGetMultisamplefvNV',
                                            'glSampleMaskIndexedNV',
                                            'glTexRenderbufferNV'
                                          ],
          'GL_NV_fence' => [
                             'glDeleteFencesNV',
                             'glFinishFenceNV',
                             'glGenFencesNV',
                             'glGetFenceivNV',
                             'glIsFenceNV',
                             'glSetFenceNV',
                             'glTestFenceNV'
                           ],
          'GL_NV_fragment_coverage_to_color' => [
                                                  'glFragmentCoverageColorNV'
                                                ],
          'GL_NV_fragment_program' => [
                                        'glGetProgramNamedParameterdvNV',
                                        'glGetProgramNamedParameterfvNV',
                                        'glProgramNamedParameter4dNV',
                                        'glProgramNamedParameter4dvNV',
                                        'glProgramNamedParameter4fNV',
                                        'glProgramNamedParameter4fvNV'
                                      ],
          'GL_NV_framebuffer_multisample_coverage' => [
                                                        'glRenderbufferStorageMultisampleCoverageNV'
                                                      ],
          'GL_NV_geometry_program4' => [
                                         'glProgramVertexLimitNV'
                                       ],
          'GL_NV_gpu_multicast' => [
                                     'glMulticastBarrierNV',
                                     'glMulticastBlitFramebufferNV',
                                     'glMulticastBufferSubDataNV',
                                     'glMulticastCopyBufferSubDataNV',
                                     'glMulticastCopyImageSubDataNV',
                                     'glMulticastFramebufferSampleLocationsfvNV',
                                     'glMulticastGetQueryObjecti64vNV',
                                     'glMulticastGetQueryObjectivNV',
                                     'glMulticastGetQueryObjectui64vNV',
                                     'glMulticastGetQueryObjectuivNV',
                                     'glMulticastWaitSyncNV',
                                     'glRenderGpuMaskNV'
                                   ],
          'GL_NV_gpu_program4' => [
                                    'glProgramEnvParameterI4iNV',
                                    'glProgramEnvParameterI4ivNV',
                                    'glProgramEnvParameterI4uiNV',
                                    'glProgramEnvParameterI4uivNV',
                                    'glProgramEnvParametersI4ivNV',
                                    'glProgramEnvParametersI4uivNV',
                                    'glProgramLocalParameterI4iNV',
                                    'glProgramLocalParameterI4ivNV',
                                    'glProgramLocalParameterI4uiNV',
                                    'glProgramLocalParameterI4uivNV',
                                    'glProgramLocalParametersI4ivNV',
                                    'glProgramLocalParametersI4uivNV'
                                  ],
          'GL_NV_gpu_shader5' => [
                                   'glGetUniformi64vNV',
                                   'glGetUniformui64vNV',
                                   'glProgramUniform1i64NV',
                                   'glProgramUniform1i64vNV',
                                   'glProgramUniform1ui64NV',
                                   'glProgramUniform1ui64vNV',
                                   'glProgramUniform2i64NV',
                                   'glProgramUniform2i64vNV',
                                   'glProgramUniform2ui64NV',
                                   'glProgramUniform2ui64vNV',
                                   'glProgramUniform3i64NV',
                                   'glProgramUniform3i64vNV',
                                   'glProgramUniform3ui64NV',
                                   'glProgramUniform3ui64vNV',
                                   'glProgramUniform4i64NV',
                                   'glProgramUniform4i64vNV',
                                   'glProgramUniform4ui64NV',
                                   'glProgramUniform4ui64vNV',
                                   'glUniform1i64NV',
                                   'glUniform1i64vNV',
                                   'glUniform1ui64NV',
                                   'glUniform1ui64vNV',
                                   'glUniform2i64NV',
                                   'glUniform2i64vNV',
                                   'glUniform2ui64NV',
                                   'glUniform2ui64vNV',
                                   'glUniform3i64NV',
                                   'glUniform3i64vNV',
                                   'glUniform3ui64NV',
                                   'glUniform3ui64vNV',
                                   'glUniform4i64NV',
                                   'glUniform4i64vNV',
                                   'glUniform4ui64NV',
                                   'glUniform4ui64vNV'
                                 ],
          'GL_NV_half_float' => [
                                  'glColor3hNV',
                                  'glColor3hvNV',
                                  'glColor4hNV',
                                  'glColor4hvNV',
                                  'glFogCoordhNV',
                                  'glFogCoordhvNV',
                                  'glMultiTexCoord1hNV',
                                  'glMultiTexCoord1hvNV',
                                  'glMultiTexCoord2hNV',
                                  'glMultiTexCoord2hvNV',
                                  'glMultiTexCoord3hNV',
                                  'glMultiTexCoord3hvNV',
                                  'glMultiTexCoord4hNV',
                                  'glMultiTexCoord4hvNV',
                                  'glNormal3hNV',
                                  'glNormal3hvNV',
                                  'glSecondaryColor3hNV',
                                  'glSecondaryColor3hvNV',
                                  'glTexCoord1hNV',
                                  'glTexCoord1hvNV',
                                  'glTexCoord2hNV',
                                  'glTexCoord2hvNV',
                                  'glTexCoord3hNV',
                                  'glTexCoord3hvNV',
                                  'glTexCoord4hNV',
                                  'glTexCoord4hvNV',
                                  'glVertex2hNV',
                                  'glVertex2hvNV',
                                  'glVertex3hNV',
                                  'glVertex3hvNV',
                                  'glVertex4hNV',
                                  'glVertex4hvNV',
                                  'glVertexAttrib1hNV',
                                  'glVertexAttrib1hvNV',
                                  'glVertexAttrib2hNV',
                                  'glVertexAttrib2hvNV',
                                  'glVertexAttrib3hNV',
                                  'glVertexAttrib3hvNV',
                                  'glVertexAttrib4hNV',
                                  'glVertexAttrib4hvNV',
                                  'glVertexAttribs1hvNV',
                                  'glVertexAttribs2hvNV',
                                  'glVertexAttribs3hvNV',
                                  'glVertexAttribs4hvNV',
                                  'glVertexWeighthNV',
                                  'glVertexWeighthvNV'
                                ],
          'GL_NV_internalformat_sample_query' => [
                                                   'glGetInternalformatSampleivNV'
                                                 ],
          'GL_NV_occlusion_query' => [
                                       'glBeginOcclusionQueryNV',
                                       'glDeleteOcclusionQueriesNV',
                                       'glEndOcclusionQueryNV',
                                       'glGenOcclusionQueriesNV',
                                       'glGetOcclusionQueryivNV',
                                       'glGetOcclusionQueryuivNV',
                                       'glIsOcclusionQueryNV'
                                     ],
          'GL_NV_parameter_buffer_object' => [
                                               'glProgramBufferParametersIivNV',
                                               'glProgramBufferParametersIuivNV',
                                               'glProgramBufferParametersfvNV'
                                             ],
          'GL_NV_path_rendering' => [
                                      'glCopyPathNV',
                                      'glCoverFillPathInstancedNV',
                                      'glCoverFillPathNV',
                                      'glCoverStrokePathInstancedNV',
                                      'glCoverStrokePathNV',
                                      'glDeletePathsNV',
                                      'glGenPathsNV',
                                      'glGetPathColorGenfvNV',
                                      'glGetPathColorGenivNV',
                                      'glGetPathCommandsNV',
                                      'glGetPathCoordsNV',
                                      'glGetPathDashArrayNV',
                                      'glGetPathLengthNV',
                                      'glGetPathMetricRangeNV',
                                      'glGetPathMetricsNV',
                                      'glGetPathParameterfvNV',
                                      'glGetPathParameterivNV',
                                      'glGetPathSpacingNV',
                                      'glGetPathTexGenfvNV',
                                      'glGetPathTexGenivNV',
                                      'glGetProgramResourcefvNV',
                                      'glInterpolatePathsNV',
                                      'glIsPathNV',
                                      'glIsPointInFillPathNV',
                                      'glIsPointInStrokePathNV',
                                      'glMatrixLoad3x2fNV',
                                      'glMatrixLoad3x3fNV',
                                      'glMatrixLoadTranspose3x3fNV',
                                      'glMatrixMult3x2fNV',
                                      'glMatrixMult3x3fNV',
                                      'glMatrixMultTranspose3x3fNV',
                                      'glPathColorGenNV',
                                      'glPathCommandsNV',
                                      'glPathCoordsNV',
                                      'glPathCoverDepthFuncNV',
                                      'glPathDashArrayNV',
                                      'glPathFogGenNV',
                                      'glPathGlyphIndexArrayNV',
                                      'glPathGlyphIndexRangeNV',
                                      'glPathGlyphRangeNV',
                                      'glPathGlyphsNV',
                                      'glPathMemoryGlyphIndexArrayNV',
                                      'glPathParameterfNV',
                                      'glPathParameterfvNV',
                                      'glPathParameteriNV',
                                      'glPathParameterivNV',
                                      'glPathStencilDepthOffsetNV',
                                      'glPathStencilFuncNV',
                                      'glPathStringNV',
                                      'glPathSubCommandsNV',
                                      'glPathSubCoordsNV',
                                      'glPathTexGenNV',
                                      'glPointAlongPathNV',
                                      'glProgramPathFragmentInputGenNV',
                                      'glStencilFillPathInstancedNV',
                                      'glStencilFillPathNV',
                                      'glStencilStrokePathInstancedNV',
                                      'glStencilStrokePathNV',
                                      'glStencilThenCoverFillPathInstancedNV',
                                      'glStencilThenCoverFillPathNV',
                                      'glStencilThenCoverStrokePathInstancedNV',
                                      'glStencilThenCoverStrokePathNV',
                                      'glTransformPathNV',
                                      'glWeightPathsNV'
                                    ],
          'GL_NV_pixel_data_range' => [
                                        'glFlushPixelDataRangeNV',
                                        'glPixelDataRangeNV'
                                      ],
          'GL_NV_point_sprite' => [
                                    'glPointParameteriNV',
                                    'glPointParameterivNV'
                                  ],
          'GL_NV_present_video' => [
                                     'glGetVideoi64vNV',
                                     'glGetVideoivNV',
                                     'glGetVideoui64vNV',
                                     'glGetVideouivNV',
                                     'glPresentFrameDualFillNV',
                                     'glPresentFrameKeyedNV'
                                   ],
          'GL_NV_primitive_restart' => [
                                         'glPrimitiveRestartIndexNV',
                                         'glPrimitiveRestartNV'
                                       ],
          'GL_NV_register_combiners' => [
                                          'glCombinerInputNV',
                                          'glCombinerOutputNV',
                                          'glCombinerParameterfNV',
                                          'glCombinerParameterfvNV',
                                          'glCombinerParameteriNV',
                                          'glCombinerParameterivNV',
                                          'glFinalCombinerInputNV',
                                          'glGetCombinerInputParameterfvNV',
                                          'glGetCombinerInputParameterivNV',
                                          'glGetCombinerOutputParameterfvNV',
                                          'glGetCombinerOutputParameterivNV',
                                          'glGetFinalCombinerInputParameterfvNV',
                                          'glGetFinalCombinerInputParameterivNV'
                                        ],
          'GL_NV_register_combiners2' => [
                                           'glCombinerStageParameterfvNV',
                                           'glGetCombinerStageParameterfvNV'
                                         ],
          'GL_NV_sample_locations' => [
                                        'glFramebufferSampleLocationsfvNV',
                                        'glNamedFramebufferSampleLocationsfvNV'
                                      ],
          'GL_NV_shader_buffer_load' => [
                                          'glGetBufferParameterui64vNV',
                                          'glGetIntegerui64vNV',
                                          'glGetNamedBufferParameterui64vNV',
                                          'glIsBufferResidentNV',
                                          'glIsNamedBufferResidentNV',
                                          'glMakeBufferNonResidentNV',
                                          'glMakeBufferResidentNV',
                                          'glMakeNamedBufferNonResidentNV',
                                          'glMakeNamedBufferResidentNV',
                                          'glProgramUniformui64NV',
                                          'glProgramUniformui64vNV',
                                          'glUniformui64NV',
                                          'glUniformui64vNV'
                                        ],
          'GL_NV_texture_barrier' => [
                                       'glTextureBarrierNV'
                                     ],
          'GL_NV_texture_multisample' => [
                                           'glTexImage2DMultisampleCoverageNV',
                                           'glTexImage3DMultisampleCoverageNV',
                                           'glTextureImage2DMultisampleCoverageNV',
                                           'glTextureImage2DMultisampleNV',
                                           'glTextureImage3DMultisampleCoverageNV',
                                           'glTextureImage3DMultisampleNV'
                                         ],
          'GL_NV_transform_feedback' => [
                                          'glActiveVaryingNV',
                                          'glBeginTransformFeedbackNV',
                                          'glBindBufferBaseNV',
                                          'glBindBufferOffsetNV',
                                          'glBindBufferRangeNV',
                                          'glEndTransformFeedbackNV',
                                          'glGetActiveVaryingNV',
                                          'glGetTransformFeedbackVaryingNV',
                                          'glGetVaryingLocationNV',
                                          'glTransformFeedbackAttribsNV',
                                          'glTransformFeedbackVaryingsNV'
                                        ],
          'GL_NV_transform_feedback2' => [
                                           'glBindTransformFeedbackNV',
                                           'glDeleteTransformFeedbacksNV',
                                           'glDrawTransformFeedbackNV',
                                           'glGenTransformFeedbacksNV',
                                           'glIsTransformFeedbackNV',
                                           'glPauseTransformFeedbackNV',
                                           'glResumeTransformFeedbackNV'
                                         ],
          'GL_NV_vdpau_interop' => [
                                     'glVDPAUFiniNV',
                                     'glVDPAUGetSurfaceivNV',
                                     'glVDPAUInitNV',
                                     'glVDPAUIsSurfaceNV',
                                     'glVDPAUMapSurfacesNV',
                                     'glVDPAURegisterOutputSurfaceNV',
                                     'glVDPAURegisterVideoSurfaceNV',
                                     'glVDPAUSurfaceAccessNV',
                                     'glVDPAUUnmapSurfacesNV',
                                     'glVDPAUUnregisterSurfaceNV'
                                   ],
          'GL_NV_vertex_array_range' => [
                                          'glFlushVertexArrayRangeNV',
                                          'glVertexArrayRangeNV'
                                        ],
          'GL_NV_vertex_attrib_integer_64bit' => [
                                                   'glGetVertexAttribLi64vNV',
                                                   'glGetVertexAttribLui64vNV',
                                                   'glVertexAttribL1i64NV',
                                                   'glVertexAttribL1i64vNV',
                                                   'glVertexAttribL1ui64NV',
                                                   'glVertexAttribL1ui64vNV',
                                                   'glVertexAttribL2i64NV',
                                                   'glVertexAttribL2i64vNV',
                                                   'glVertexAttribL2ui64NV',
                                                   'glVertexAttribL2ui64vNV',
                                                   'glVertexAttribL3i64NV',
                                                   'glVertexAttribL3i64vNV',
                                                   'glVertexAttribL3ui64NV',
                                                   'glVertexAttribL3ui64vNV',
                                                   'glVertexAttribL4i64NV',
                                                   'glVertexAttribL4i64vNV',
                                                   'glVertexAttribL4ui64NV',
                                                   'glVertexAttribL4ui64vNV',
                                                   'glVertexAttribLFormatNV'
                                                 ],
          'GL_NV_vertex_buffer_unified_memory' => [
                                                    'glBufferAddressRangeNV',
                                                    'glColorFormatNV',
                                                    'glEdgeFlagFormatNV',
                                                    'glFogCoordFormatNV',
                                                    'glGetIntegerui64i_vNV',
                                                    'glIndexFormatNV',
                                                    'glNormalFormatNV',
                                                    'glSecondaryColorFormatNV',
                                                    'glTexCoordFormatNV',
                                                    'glVertexAttribFormatNV',
                                                    'glVertexAttribIFormatNV',
                                                    'glVertexFormatNV'
                                                  ],
          'GL_NV_vertex_program' => [
                                      'glAreProgramsResidentNV',
                                      'glBindProgramNV',
                                      'glDeleteProgramsNV',
                                      'glExecuteProgramNV',
                                      'glGenProgramsNV',
                                      'glGetProgramParameterdvNV',
                                      'glGetProgramParameterfvNV',
                                      'glGetProgramStringNV',
                                      'glGetProgramivNV',
                                      'glGetTrackMatrixivNV',
                                      'glGetVertexAttribPointervNV',
                                      'glGetVertexAttribdvNV',
                                      'glGetVertexAttribfvNV',
                                      'glGetVertexAttribivNV',
                                      'glIsProgramNV',
                                      'glLoadProgramNV',
                                      'glProgramParameter4dNV',
                                      'glProgramParameter4dvNV',
                                      'glProgramParameter4fNV',
                                      'glProgramParameter4fvNV',
                                      'glProgramParameters4dvNV',
                                      'glProgramParameters4fvNV',
                                      'glRequestResidentProgramsNV',
                                      'glTrackMatrixNV',
                                      'glVertexAttrib1dNV',
                                      'glVertexAttrib1dvNV',
                                      'glVertexAttrib1fNV',
                                      'glVertexAttrib1fvNV',
                                      'glVertexAttrib1sNV',
                                      'glVertexAttrib1svNV',
                                      'glVertexAttrib2dNV',
                                      'glVertexAttrib2dvNV',
                                      'glVertexAttrib2fNV',
                                      'glVertexAttrib2fvNV',
                                      'glVertexAttrib2sNV',
                                      'glVertexAttrib2svNV',
                                      'glVertexAttrib3dNV',
                                      'glVertexAttrib3dvNV',
                                      'glVertexAttrib3fNV',
                                      'glVertexAttrib3fvNV',
                                      'glVertexAttrib3sNV',
                                      'glVertexAttrib3svNV',
                                      'glVertexAttrib4dNV',
                                      'glVertexAttrib4dvNV',
                                      'glVertexAttrib4fNV',
                                      'glVertexAttrib4fvNV',
                                      'glVertexAttrib4sNV',
                                      'glVertexAttrib4svNV',
                                      'glVertexAttrib4ubNV',
                                      'glVertexAttrib4ubvNV',
                                      'glVertexAttribPointerNV',
                                      'glVertexAttribs1dvNV',
                                      'glVertexAttribs1fvNV',
                                      'glVertexAttribs1svNV',
                                      'glVertexAttribs2dvNV',
                                      'glVertexAttribs2fvNV',
                                      'glVertexAttribs2svNV',
                                      'glVertexAttribs3dvNV',
                                      'glVertexAttribs3fvNV',
                                      'glVertexAttribs3svNV',
                                      'glVertexAttribs4dvNV',
                                      'glVertexAttribs4fvNV',
                                      'glVertexAttribs4svNV',
                                      'glVertexAttribs4ubvNV'
                                    ],
          'GL_NV_video_capture' => [
                                     'glBeginVideoCaptureNV',
                                     'glBindVideoCaptureStreamBufferNV',
                                     'glBindVideoCaptureStreamTextureNV',
                                     'glEndVideoCaptureNV',
                                     'glGetVideoCaptureStreamdvNV',
                                     'glGetVideoCaptureStreamfvNV',
                                     'glGetVideoCaptureStreamivNV',
                                     'glGetVideoCaptureivNV',
                                     'glVideoCaptureNV',
                                     'glVideoCaptureStreamParameterdvNV',
                                     'glVideoCaptureStreamParameterfvNV',
                                     'glVideoCaptureStreamParameterivNV'
                                   ],
          'GL_NV_viewport_swizzle' => [
                                        'glViewportSwizzleNV'
                                      ],
          'GL_OES_single_precision' => [
                                         'glClearDepthfOES',
                                         'glClipPlanefOES',
                                         'glDepthRangefOES',
                                         'glFrustumfOES',
                                         'glGetClipPlanefOES',
                                         'glOrthofOES'
                                       ],
          'GL_OVR_multiview' => [
                                  'glFramebufferTextureMultiviewOVR'
                                ],
          'GL_REGAL_ES1_0_compatibility' => [
                                              'glAlphaFuncx',
                                              'glClearColorx',
                                              'glClearDepthx',
                                              'glColor4x',
                                              'glDepthRangex',
                                              'glFogx',
                                              'glFogxv',
                                              'glFrustumf',
                                              'glFrustumx',
                                              'glLightModelx',
                                              'glLightModelxv',
                                              'glLightx',
                                              'glLightxv',
                                              'glLineWidthx',
                                              'glLoadMatrixx',
                                              'glMaterialx',
                                              'glMaterialxv',
                                              'glMultMatrixx',
                                              'glMultiTexCoord4x',
                                              'glNormal3x',
                                              'glOrthof',
                                              'glOrthox',
                                              'glPointSizex',
                                              'glPolygonOffsetx',
                                              'glRotatex',
                                              'glSampleCoveragex',
                                              'glScalex',
                                              'glTexEnvx',
                                              'glTexEnvxv',
                                              'glTexParameterx',
                                              'glTranslatex'
                                            ],
          'GL_REGAL_ES1_1_compatibility' => [
                                              'glClipPlanef',
                                              'glClipPlanex',
                                              'glGetClipPlanef',
                                              'glGetClipPlanex',
                                              'glGetFixedv',
                                              'glGetLightxv',
                                              'glGetMaterialxv',
                                              'glGetTexEnvxv',
                                              'glGetTexParameterxv',
                                              'glPointParameterx',
                                              'glPointParameterxv',
                                              'glPointSizePointerOES',
                                              'glTexParameterxv'
                                            ],
          'GL_REGAL_extension_query' => [
                                          'glGetExtensionREGAL',
                                          'glIsSupportedREGAL'
                                        ],
          'GL_REGAL_log' => [
                              'glLogMessageCallbackREGAL'
                            ],
          'GL_REGAL_proc_address' => [
                                       'glGetProcAddressREGAL'
                                     ],
          'GL_SGIS_detail_texture' => [
                                        'glDetailTexFuncSGIS',
                                        'glGetDetailTexFuncSGIS'
                                      ],
          'GL_SGIS_fog_function' => [
                                      'glFogFuncSGIS',
                                      'glGetFogFuncSGIS'
                                    ],
          'GL_SGIS_multisample' => [
                                     'glSampleMaskSGIS',
                                     'glSamplePatternSGIS'
                                   ],
          'GL_SGIS_sharpen_texture' => [
                                         'glGetSharpenTexFuncSGIS',
                                         'glSharpenTexFuncSGIS'
                                       ],
          'GL_SGIS_texture4D' => [
                                   'glTexImage4DSGIS',
                                   'glTexSubImage4DSGIS'
                                 ],
          'GL_SGIS_texture_filter4' => [
                                         'glGetTexFilterFuncSGIS',
                                         'glTexFilterFuncSGIS'
                                       ],
          'GL_SGIX_async' => [
                               'glAsyncMarkerSGIX',
                               'glDeleteAsyncMarkersSGIX',
                               'glFinishAsyncSGIX',
                               'glGenAsyncMarkersSGIX',
                               'glIsAsyncMarkerSGIX',
                               'glPollAsyncSGIX'
                             ],
          'GL_SGIX_flush_raster' => [
                                      'glFlushRasterSGIX'
                                    ],
          'GL_SGIX_fog_texture' => [
                                     'glTextureFogSGIX'
                                   ],
          'GL_SGIX_fragment_specular_lighting' => [
                                                    'glFragmentColorMaterialSGIX',
                                                    'glFragmentLightModelfSGIX',
                                                    'glFragmentLightModelfvSGIX',
                                                    'glFragmentLightModeliSGIX',
                                                    'glFragmentLightModelivSGIX',
                                                    'glFragmentLightfSGIX',
                                                    'glFragmentLightfvSGIX',
                                                    'glFragmentLightiSGIX',
                                                    'glFragmentLightivSGIX',
                                                    'glFragmentMaterialfSGIX',
                                                    'glFragmentMaterialfvSGIX',
                                                    'glFragmentMaterialiSGIX',
                                                    'glFragmentMaterialivSGIX',
                                                    'glGetFragmentLightfvSGIX',
                                                    'glGetFragmentLightivSGIX',
                                                    'glGetFragmentMaterialfvSGIX',
                                                    'glGetFragmentMaterialivSGIX'
                                                  ],
          'GL_SGIX_framezoom' => [
                                   'glFrameZoomSGIX'
                                 ],
          'GL_SGIX_pixel_texture' => [
                                       'glPixelTexGenSGIX'
                                     ],
          'GL_SGIX_reference_plane' => [
                                         'glReferencePlaneSGIX'
                                       ],
          'GL_SGIX_sprite' => [
                                'glSpriteParameterfSGIX',
                                'glSpriteParameterfvSGIX',
                                'glSpriteParameteriSGIX',
                                'glSpriteParameterivSGIX'
                              ],
          'GL_SGIX_tag_sample_buffer' => [
                                           'glTagSampleBufferSGIX'
                                         ],
          'GL_SGI_color_table' => [
                                    'glColorTableParameterfvSGI',
                                    'glColorTableParameterivSGI',
                                    'glColorTableSGI',
                                    'glCopyColorTableSGI',
                                    'glGetColorTableParameterfvSGI',
                                    'glGetColorTableParameterivSGI',
                                    'glGetColorTableSGI'
                                  ],
          'GL_SUNX_constant_data' => [
                                       'glFinishTextureSUNX'
                                     ],
          'GL_SUN_global_alpha' => [
                                     'glGlobalAlphaFactorbSUN',
                                     'glGlobalAlphaFactordSUN',
                                     'glGlobalAlphaFactorfSUN',
                                     'glGlobalAlphaFactoriSUN',
                                     'glGlobalAlphaFactorsSUN',
                                     'glGlobalAlphaFactorubSUN',
                                     'glGlobalAlphaFactoruiSUN',
                                     'glGlobalAlphaFactorusSUN'
                                   ],
          'GL_SUN_read_video_pixels' => [
                                          'glReadVideoPixelsSUN'
                                        ],
          'GL_SUN_triangle_list' => [
                                      'glReplacementCodePointerSUN',
                                      'glReplacementCodeubSUN',
                                      'glReplacementCodeubvSUN',
                                      'glReplacementCodeuiSUN',
                                      'glReplacementCodeuivSUN',
                                      'glReplacementCodeusSUN',
                                      'glReplacementCodeusvSUN'
                                    ],
          'GL_SUN_vertex' => [
                               'glColor3fVertex3fSUN',
                               'glColor3fVertex3fvSUN',
                               'glColor4fNormal3fVertex3fSUN',
                               'glColor4fNormal3fVertex3fvSUN',
                               'glColor4ubVertex2fSUN',
                               'glColor4ubVertex2fvSUN',
                               'glColor4ubVertex3fSUN',
                               'glColor4ubVertex3fvSUN',
                               'glNormal3fVertex3fSUN',
                               'glNormal3fVertex3fvSUN',
                               'glReplacementCodeuiColor3fVertex3fSUN',
                               'glReplacementCodeuiColor3fVertex3fvSUN',
                               'glReplacementCodeuiColor4fNormal3fVertex3fSUN',
                               'glReplacementCodeuiColor4fNormal3fVertex3fvSUN',
                               'glReplacementCodeuiColor4ubVertex3fSUN',
                               'glReplacementCodeuiColor4ubVertex3fvSUN',
                               'glReplacementCodeuiNormal3fVertex3fSUN',
                               'glReplacementCodeuiNormal3fVertex3fvSUN',
                               'glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fSUN',
                               'glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN',
                               'glReplacementCodeuiTexCoord2fNormal3fVertex3fSUN',
                               'glReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN',
                               'glReplacementCodeuiTexCoord2fVertex3fSUN',
                               'glReplacementCodeuiTexCoord2fVertex3fvSUN',
                               'glReplacementCodeuiVertex3fSUN',
                               'glReplacementCodeuiVertex3fvSUN',
                               'glTexCoord2fColor3fVertex3fSUN',
                               'glTexCoord2fColor3fVertex3fvSUN',
                               'glTexCoord2fColor4fNormal3fVertex3fSUN',
                               'glTexCoord2fColor4fNormal3fVertex3fvSUN',
                               'glTexCoord2fColor4ubVertex3fSUN',
                               'glTexCoord2fColor4ubVertex3fvSUN',
                               'glTexCoord2fNormal3fVertex3fSUN',
                               'glTexCoord2fNormal3fVertex3fvSUN',
                               'glTexCoord2fVertex3fSUN',
                               'glTexCoord2fVertex3fvSUN',
                               'glTexCoord4fColor4fNormal3fVertex4fSUN',
                               'glTexCoord4fColor4fNormal3fVertex4fvSUN',
                               'glTexCoord4fVertex4fSUN',
                               'glTexCoord4fVertex4fvSUN'
                             ],
          'GL_VERSION_1_1' => [
                                'glAccum',
                                'glAlphaFunc',
                                'glAreTexturesResident',
                                'glArrayElement',
                                'glBegin',
                                'glBindTexture',
                                'glBitmap',
                                'glBlendFunc',
                                'glCallList',
                                'glCallLists',
                                'glClear',
                                'glClearAccum',
                                'glClearColor',
                                'glClearDepth',
                                'glClearIndex',
                                'glClearStencil',
                                'glClipPlane',
                                'glColor3b',
                                'glColor3bv',
                                'glColor3d',
                                'glColor3dv',
                                'glColor3f',
                                'glColor3fv',
                                'glColor3i',
                                'glColor3iv',
                                'glColor3s',
                                'glColor3sv',
                                'glColor3ub',
                                'glColor3ubv',
                                'glColor3ui',
                                'glColor3uiv',
                                'glColor3us',
                                'glColor3usv',
                                'glColor4b',
                                'glColor4bv',
                                'glColor4d',
                                'glColor4dv',
                                'glColor4f',
                                'glColor4fv',
                                'glColor4i',
                                'glColor4iv',
                                'glColor4s',
                                'glColor4sv',
                                'glColor4ub',
                                'glColor4ubv',
                                'glColor4ui',
                                'glColor4uiv',
                                'glColor4us',
                                'glColor4usv',
                                'glColorMask',
                                'glColorMaterial',
                                'glColorPointer',
                                'glCopyPixels',
                                'glCopyTexImage1D',
                                'glCopyTexImage2D',
                                'glCopyTexSubImage1D',
                                'glCopyTexSubImage2D',
                                'glCullFace',
                                'glDeleteLists',
                                'glDeleteTextures',
                                'glDepthFunc',
                                'glDepthMask',
                                'glDepthRange',
                                'glDisable',
                                'glDisableClientState',
                                'glDrawArrays',
                                'glDrawBuffer',
                                'glDrawElements',
                                'glDrawPixels',
                                'glEdgeFlag',
                                'glEdgeFlagPointer',
                                'glEdgeFlagv',
                                'glEnable',
                                'glEnableClientState',
                                'glEnd',
                                'glEndList',
                                'glEvalCoord1d',
                                'glEvalCoord1dv',
                                'glEvalCoord1f',
                                'glEvalCoord1fv',
                                'glEvalCoord2d',
                                'glEvalCoord2dv',
                                'glEvalCoord2f',
                                'glEvalCoord2fv',
                                'glEvalMesh1',
                                'glEvalMesh2',
                                'glEvalPoint1',
                                'glEvalPoint2',
                                'glFeedbackBuffer',
                                'glFinish',
                                'glFlush',
                                'glFogf',
                                'glFogfv',
                                'glFogi',
                                'glFogiv',
                                'glFrontFace',
                                'glFrustum',
                                'glGenLists',
                                'glGenTextures',
                                'glGetBooleanv',
                                'glGetClipPlane',
                                'glGetDoublev',
                                'glGetError',
                                'glGetFloatv',
                                'glGetIntegerv',
                                'glGetLightfv',
                                'glGetLightiv',
                                'glGetMapdv',
                                'glGetMapfv',
                                'glGetMapiv',
                                'glGetMaterialfv',
                                'glGetMaterialiv',
                                'glGetPixelMapfv',
                                'glGetPixelMapuiv',
                                'glGetPixelMapusv',
                                'glGetPointerv',
                                'glGetPolygonStipple',
                                'glGetString',
                                'glGetTexEnvfv',
                                'glGetTexEnviv',
                                'glGetTexGendv',
                                'glGetTexGenfv',
                                'glGetTexGeniv',
                                'glGetTexImage',
                                'glGetTexLevelParameterfv',
                                'glGetTexLevelParameteriv',
                                'glGetTexParameterfv',
                                'glGetTexParameteriv',
                                'glHint',
                                'glIndexMask',
                                'glIndexPointer',
                                'glIndexd',
                                'glIndexdv',
                                'glIndexf',
                                'glIndexfv',
                                'glIndexi',
                                'glIndexiv',
                                'glIndexs',
                                'glIndexsv',
                                'glIndexub',
                                'glIndexubv',
                                'glInitNames',
                                'glInterleavedArrays',
                                'glIsEnabled',
                                'glIsList',
                                'glIsTexture',
                                'glLightModelf',
                                'glLightModelfv',
                                'glLightModeli',
                                'glLightModeliv',
                                'glLightf',
                                'glLightfv',
                                'glLighti',
                                'glLightiv',
                                'glLineStipple',
                                'glLineWidth',
                                'glListBase',
                                'glLoadIdentity',
                                'glLoadMatrixd',
                                'glLoadMatrixf',
                                'glLoadName',
                                'glLogicOp',
                                'glMap1d',
                                'glMap1f',
                                'glMap2d',
                                'glMap2f',
                                'glMapGrid1d',
                                'glMapGrid1f',
                                'glMapGrid2d',
                                'glMapGrid2f',
                                'glMaterialf',
                                'glMaterialfv',
                                'glMateriali',
                                'glMaterialiv',
                                'glMatrixMode',
                                'glMultMatrixd',
                                'glMultMatrixf',
                                'glNewList',
                                'glNormal3b',
                                'glNormal3bv',
                                'glNormal3d',
                                'glNormal3dv',
                                'glNormal3f',
                                'glNormal3fv',
                                'glNormal3i',
                                'glNormal3iv',
                                'glNormal3s',
                                'glNormal3sv',
                                'glNormalPointer',
                                'glOrtho',
                                'glPassThrough',
                                'glPixelMapfv',
                                'glPixelMapuiv',
                                'glPixelMapusv',
                                'glPixelStoref',
                                'glPixelStorei',
                                'glPixelTransferf',
                                'glPixelTransferi',
                                'glPixelZoom',
                                'glPointSize',
                                'glPolygonMode',
                                'glPolygonOffset',
                                'glPolygonStipple',
                                'glPopAttrib',
                                'glPopClientAttrib',
                                'glPopMatrix',
                                'glPopName',
                                'glPrioritizeTextures',
                                'glPushAttrib',
                                'glPushClientAttrib',
                                'glPushMatrix',
                                'glPushName',
                                'glRasterPos2d',
                                'glRasterPos2dv',
                                'glRasterPos2f',
                                'glRasterPos2fv',
                                'glRasterPos2i',
                                'glRasterPos2iv',
                                'glRasterPos2s',
                                'glRasterPos2sv',
                                'glRasterPos3d',
                                'glRasterPos3dv',
                                'glRasterPos3f',
                                'glRasterPos3fv',
                                'glRasterPos3i',
                                'glRasterPos3iv',
                                'glRasterPos3s',
                                'glRasterPos3sv',
                                'glRasterPos4d',
                                'glRasterPos4dv',
                                'glRasterPos4f',
                                'glRasterPos4fv',
                                'glRasterPos4i',
                                'glRasterPos4iv',
                                'glRasterPos4s',
                                'glRasterPos4sv',
                                'glReadBuffer',
                                'glReadPixels',
                                'glRectd',
                                'glRectdv',
                                'glRectf',
                                'glRectfv',
                                'glRecti',
                                'glRectiv',
                                'glRects',
                                'glRectsv',
                                'glRenderMode',
                                'glRotated',
                                'glRotatef',
                                'glScaled',
                                'glScalef',
                                'glScissor',
                                'glSelectBuffer',
                                'glShadeModel',
                                'glStencilFunc',
                                'glStencilMask',
                                'glStencilOp',
                                'glTexCoord1d',
                                'glTexCoord1dv',
                                'glTexCoord1f',
                                'glTexCoord1fv',
                                'glTexCoord1i',
                                'glTexCoord1iv',
                                'glTexCoord1s',
                                'glTexCoord1sv',
                                'glTexCoord2d',
                                'glTexCoord2dv',
                                'glTexCoord2f',
                                'glTexCoord2fv',
                                'glTexCoord2i',
                                'glTexCoord2iv',
                                'glTexCoord2s',
                                'glTexCoord2sv',
                                'glTexCoord3d',
                                'glTexCoord3dv',
                                'glTexCoord3f',
                                'glTexCoord3fv',
                                'glTexCoord3i',
                                'glTexCoord3iv',
                                'glTexCoord3s',
                                'glTexCoord3sv',
                                'glTexCoord4d',
                                'glTexCoord4dv',
                                'glTexCoord4f',
                                'glTexCoord4fv',
                                'glTexCoord4i',
                                'glTexCoord4iv',
                                'glTexCoord4s',
                                'glTexCoord4sv',
                                'glTexCoordPointer',
                                'glTexEnvf',
                                'glTexEnvfv',
                                'glTexEnvi',
                                'glTexEnviv',
                                'glTexGend',
                                'glTexGendv',
                                'glTexGenf',
                                'glTexGenfv',
                                'glTexGeni',
                                'glTexGeniv',
                                'glTexImage1D',
                                'glTexImage2D',
                                'glTexParameterf',
                                'glTexParameterfv',
                                'glTexParameteri',
                                'glTexParameteriv',
                                'glTexSubImage1D',
                                'glTexSubImage2D',
                                'glTranslated',
                                'glTranslatef',
                                'glVertex2d',
                                'glVertex2dv',
                                'glVertex2f',
                                'glVertex2fv',
                                'glVertex2i',
                                'glVertex2iv',
                                'glVertex2s',
                                'glVertex2sv',
                                'glVertex3d',
                                'glVertex3dv',
                                'glVertex3f',
                                'glVertex3fv',
                                'glVertex3i',
                                'glVertex3iv',
                                'glVertex3s',
                                'glVertex3sv',
                                'glVertex4d',
                                'glVertex4dv',
                                'glVertex4f',
                                'glVertex4fv',
                                'glVertex4i',
                                'glVertex4iv',
                                'glVertex4s',
                                'glVertex4sv',
                                'glVertexPointer',
                                'glViewport'
                              ],
          'GL_VERSION_1_2' => [
                                'glCopyTexSubImage3D',
                                'glDrawRangeElements',
                                'glTexImage3D',
                                'glTexSubImage3D'
                              ],
          'GL_VERSION_1_3' => [
                                'glActiveTexture',
                                'glClientActiveTexture',
                                'glCompressedTexImage1D',
                                'glCompressedTexImage2D',
                                'glCompressedTexImage3D',
                                'glCompressedTexSubImage1D',
                                'glCompressedTexSubImage2D',
                                'glCompressedTexSubImage3D',
                                'glGetCompressedTexImage',
                                'glLoadTransposeMatrixd',
                                'glLoadTransposeMatrixf',
                                'glMultTransposeMatrixd',
                                'glMultTransposeMatrixf',
                                'glMultiTexCoord1d',
                                'glMultiTexCoord1dv',
                                'glMultiTexCoord1f',
                                'glMultiTexCoord1fv',
                                'glMultiTexCoord1i',
                                'glMultiTexCoord1iv',
                                'glMultiTexCoord1s',
                                'glMultiTexCoord1sv',
                                'glMultiTexCoord2d',
                                'glMultiTexCoord2dv',
                                'glMultiTexCoord2f',
                                'glMultiTexCoord2fv',
                                'glMultiTexCoord2i',
                                'glMultiTexCoord2iv',
                                'glMultiTexCoord2s',
                                'glMultiTexCoord2sv',
                                'glMultiTexCoord3d',
                                'glMultiTexCoord3dv',
                                'glMultiTexCoord3f',
                                'glMultiTexCoord3fv',
                                'glMultiTexCoord3i',
                                'glMultiTexCoord3iv',
                                'glMultiTexCoord3s',
                                'glMultiTexCoord3sv',
                                'glMultiTexCoord4d',
                                'glMultiTexCoord4dv',
                                'glMultiTexCoord4f',
                                'glMultiTexCoord4fv',
                                'glMultiTexCoord4i',
                                'glMultiTexCoord4iv',
                                'glMultiTexCoord4s',
                                'glMultiTexCoord4sv',
                                'glSampleCoverage'
                              ],
          'GL_VERSION_1_4' => [
                                'glBlendColor',
                                'glBlendEquation',
                                'glBlendFuncSeparate',
                                'glFogCoordPointer',
                                'glFogCoordd',
                                'glFogCoorddv',
                                'glFogCoordf',
                                'glFogCoordfv',
                                'glMultiDrawArrays',
                                'glMultiDrawElements',
                                'glPointParameterf',
                                'glPointParameterfv',
                                'glPointParameteri',
                                'glPointParameteriv',
                                'glSecondaryColor3b',
                                'glSecondaryColor3bv',
                                'glSecondaryColor3d',
                                'glSecondaryColor3dv',
                                'glSecondaryColor3f',
                                'glSecondaryColor3fv',
                                'glSecondaryColor3i',
                                'glSecondaryColor3iv',
                                'glSecondaryColor3s',
                                'glSecondaryColor3sv',
                                'glSecondaryColor3ub',
                                'glSecondaryColor3ubv',
                                'glSecondaryColor3ui',
                                'glSecondaryColor3uiv',
                                'glSecondaryColor3us',
                                'glSecondaryColor3usv',
                                'glSecondaryColorPointer',
                                'glWindowPos2d',
                                'glWindowPos2dv',
                                'glWindowPos2f',
                                'glWindowPos2fv',
                                'glWindowPos2i',
                                'glWindowPos2iv',
                                'glWindowPos2s',
                                'glWindowPos2sv',
                                'glWindowPos3d',
                                'glWindowPos3dv',
                                'glWindowPos3f',
                                'glWindowPos3fv',
                                'glWindowPos3i',
                                'glWindowPos3iv',
                                'glWindowPos3s',
                                'glWindowPos3sv'
                              ],
          'GL_VERSION_1_5' => [
                                'glBeginQuery',
                                'glBindBuffer',
                                'glBufferData',
                                'glBufferSubData',
                                'glDeleteBuffers',
                                'glDeleteQueries',
                                'glEndQuery',
                                'glGenBuffers',
                                'glGenQueries',
                                'glGetBufferParameteriv',
                                'glGetBufferPointerv',
                                'glGetBufferSubData',
                                'glGetQueryObjectiv',
                                'glGetQueryObjectuiv',
                                'glGetQueryiv',
                                'glIsBuffer',
                                'glIsQuery',
                                'glMapBuffer',
                                'glUnmapBuffer'
                              ],
          'GL_VERSION_2_0' => [
                                'glAttachShader',
                                'glBindAttribLocation',
                                'glBlendEquationSeparate',
                                'glCompileShader',
                                'glCreateProgram',
                                'glCreateShader',
                                'glDeleteProgram',
                                'glDeleteShader',
                                'glDetachShader',
                                'glDisableVertexAttribArray',
                                'glDrawBuffers',
                                'glEnableVertexAttribArray',
                                'glGetActiveAttrib',
                                'glGetActiveUniform',
                                'glGetAttachedShaders',
                                'glGetAttribLocation',
                                'glGetProgramInfoLog',
                                'glGetProgramiv',
                                'glGetShaderInfoLog',
                                'glGetShaderSource',
                                'glGetShaderiv',
                                'glGetUniformLocation',
                                'glGetUniformfv',
                                'glGetUniformiv',
                                'glGetVertexAttribPointerv',
                                'glGetVertexAttribdv',
                                'glGetVertexAttribfv',
                                'glGetVertexAttribiv',
                                'glIsProgram',
                                'glIsShader',
                                'glLinkProgram',
                                'glShaderSource',
                                'glStencilFuncSeparate',
                                'glStencilMaskSeparate',
                                'glStencilOpSeparate',
                                'glUniform1f',
                                'glUniform1fv',
                                'glUniform1i',
                                'glUniform1iv',
                                'glUniform2f',
                                'glUniform2fv',
                                'glUniform2i',
                                'glUniform2iv',
                                'glUniform3f',
                                'glUniform3fv',
                                'glUniform3i',
                                'glUniform3iv',
                                'glUniform4f',
                                'glUniform4fv',
                                'glUniform4i',
                                'glUniform4iv',
                                'glUniformMatrix2fv',
                                'glUniformMatrix3fv',
                                'glUniformMatrix4fv',
                                'glUseProgram',
                                'glValidateProgram',
                                'glVertexAttrib1d',
                                'glVertexAttrib1dv',
                                'glVertexAttrib1f',
                                'glVertexAttrib1fv',
                                'glVertexAttrib1s',
                                'glVertexAttrib1sv',
                                'glVertexAttrib2d',
                                'glVertexAttrib2dv',
                                'glVertexAttrib2f',
                                'glVertexAttrib2fv',
                                'glVertexAttrib2s',
                                'glVertexAttrib2sv',
                                'glVertexAttrib3d',
                                'glVertexAttrib3dv',
                                'glVertexAttrib3f',
                                'glVertexAttrib3fv',
                                'glVertexAttrib3s',
                                'glVertexAttrib3sv',
                                'glVertexAttrib4Nbv',
                                'glVertexAttrib4Niv',
                                'glVertexAttrib4Nsv',
                                'glVertexAttrib4Nub',
                                'glVertexAttrib4Nubv',
                                'glVertexAttrib4Nuiv',
                                'glVertexAttrib4Nusv',
                                'glVertexAttrib4bv',
                                'glVertexAttrib4d',
                                'glVertexAttrib4dv',
                                'glVertexAttrib4f',
                                'glVertexAttrib4fv',
                                'glVertexAttrib4iv',
                                'glVertexAttrib4s',
                                'glVertexAttrib4sv',
                                'glVertexAttrib4ubv',
                                'glVertexAttrib4uiv',
                                'glVertexAttrib4usv',
                                'glVertexAttribPointer'
                              ],
          'GL_VERSION_2_1' => [
                                'glUniformMatrix2x3fv',
                                'glUniformMatrix2x4fv',
                                'glUniformMatrix3x2fv',
                                'glUniformMatrix3x4fv',
                                'glUniformMatrix4x2fv',
                                'glUniformMatrix4x3fv'
                              ],
          'GL_VERSION_3_0' => [
                                'glBeginConditionalRender',
                                'glBeginTransformFeedback',
                                'glBindFragDataLocation',
                                'glClampColor',
                                'glClearBufferfi',
                                'glClearBufferfv',
                                'glClearBufferiv',
                                'glClearBufferuiv',
                                'glColorMaski',
                                'glDisablei',
                                'glEnablei',
                                'glEndConditionalRender',
                                'glEndTransformFeedback',
                                'glGetBooleani_v',
                                'glGetFragDataLocation',
                                'glGetTexParameterIiv',
                                'glGetTexParameterIuiv',
                                'glGetTransformFeedbackVarying',
                                'glGetUniformuiv',
                                'glGetVertexAttribIiv',
                                'glGetVertexAttribIuiv',
                                'glIsEnabledi',
                                'glTexParameterIiv',
                                'glTexParameterIuiv',
                                'glTransformFeedbackVaryings',
                                'glUniform1ui',
                                'glUniform1uiv',
                                'glUniform2ui',
                                'glUniform2uiv',
                                'glUniform3ui',
                                'glUniform3uiv',
                                'glUniform4ui',
                                'glUniform4uiv',
                                'glVertexAttribI1i',
                                'glVertexAttribI1iv',
                                'glVertexAttribI1ui',
                                'glVertexAttribI1uiv',
                                'glVertexAttribI2i',
                                'glVertexAttribI2iv',
                                'glVertexAttribI2ui',
                                'glVertexAttribI2uiv',
                                'glVertexAttribI3i',
                                'glVertexAttribI3iv',
                                'glVertexAttribI3ui',
                                'glVertexAttribI3uiv',
                                'glVertexAttribI4bv',
                                'glVertexAttribI4i',
                                'glVertexAttribI4iv',
                                'glVertexAttribI4sv',
                                'glVertexAttribI4ubv',
                                'glVertexAttribI4ui',
                                'glVertexAttribI4uiv',
                                'glVertexAttribI4usv',
                                'glVertexAttribIPointer'
                              ],
          'GL_VERSION_3_1' => [
                                'glDrawArraysInstanced',
                                'glDrawElementsInstanced',
                                'glPrimitiveRestartIndex',
                                'glTexBuffer'
                              ],
          'GL_VERSION_3_2' => [
                                'glFramebufferTexture',
                                'glGetBufferParameteri64v',
                                'glGetInteger64i_v'
                              ],
          'GL_VERSION_3_3' => [
                                'glVertexAttribDivisor'
                              ],
          'GL_VERSION_4_0' => [
                                'glBlendEquationSeparatei',
                                'glBlendEquationi',
                                'glBlendFuncSeparatei',
                                'glBlendFunci',
                                'glMinSampleShading'
                              ],
          'GL_VERSION_4_5' => [
                                'glGetGraphicsResetStatus',
                                'glGetnCompressedTexImage',
                                'glGetnTexImage',
                                'glGetnUniformdv'
                              ],
          'GL_WIN_swap_hint' => [
                                  'glAddSwapHintRectWIN'
                                ]
);
# end of EXPORT_TAGS_GL

# Items to export into callers namespace by default. Note: do not export
# names by default without a very good reason. Use EXPORT_OK instead.
# Do not simply export all your public functions/methods/constants.

# This allows declaration	use OpenGL::Modern ':all';
# If you do not need this, moving things directly into @EXPORT or @EXPORT_OK
# will save memory.
our %EXPORT_TAGS = (
   %EXPORT_TAGS_GL,
   'all' => [
      @glFunctions,
      qw(

      glewCreateContext
      glGetError
      glewGetErrorString
      glewIsSupported
      glGetString
      glewInit

      glClear
      glClearColor
      glDrawArrays
      glFlush
      glObjectLabel

      GLEW_3DFX_multisample
      GLEW_3DFX_tbuffer
      GLEW_3DFX_texture_compression_FXT1
      GLEW_AMD_blend_minmax_factor
      GLEW_AMD_conservative_depth
      GLEW_AMD_debug_output
      GLEW_AMD_depth_clamp_separate
      GLEW_AMD_draw_buffers_blend
      GLEW_AMD_gcn_shader
      GLEW_AMD_gpu_shader_int64
      GLEW_AMD_interleaved_elements
      GLEW_AMD_multi_draw_indirect
      GLEW_AMD_name_gen_delete
      GLEW_AMD_occlusion_query_event
      GLEW_AMD_performance_monitor
      GLEW_AMD_pinned_memory
      GLEW_AMD_query_buffer_object
      GLEW_AMD_sample_positions
      GLEW_AMD_seamless_cubemap_per_texture
      GLEW_AMD_shader_atomic_counter_ops
      GLEW_AMD_shader_explicit_vertex_parameter
      GLEW_AMD_shader_stencil_export
      GLEW_AMD_shader_stencil_value_export
      GLEW_AMD_shader_trinary_minmax
      GLEW_AMD_sparse_texture
      GLEW_AMD_stencil_operation_extended
      GLEW_AMD_texture_texture4
      GLEW_AMD_transform_feedback3_lines_triangles
      GLEW_AMD_transform_feedback4
      GLEW_AMD_vertex_shader_layer
      GLEW_AMD_vertex_shader_tessellator
      GLEW_AMD_vertex_shader_viewport_index
      GLEW_ANGLE_depth_texture
      GLEW_ANGLE_framebuffer_blit
      GLEW_ANGLE_framebuffer_multisample
      GLEW_ANGLE_instanced_arrays
      GLEW_ANGLE_pack_reverse_row_order
      GLEW_ANGLE_program_binary
      GLEW_ANGLE_texture_compression_dxt1
      GLEW_ANGLE_texture_compression_dxt3
      GLEW_ANGLE_texture_compression_dxt5
      GLEW_ANGLE_texture_usage
      GLEW_ANGLE_timer_query
      GLEW_ANGLE_translated_shader_source
      GLEW_APPLE_aux_depth_stencil
      GLEW_APPLE_client_storage
      GLEW_APPLE_element_array
      GLEW_APPLE_fence
      GLEW_APPLE_float_pixels
      GLEW_APPLE_flush_buffer_range
      GLEW_APPLE_object_purgeable
      GLEW_APPLE_pixel_buffer
      GLEW_APPLE_rgb_422
      GLEW_APPLE_row_bytes
      GLEW_APPLE_specular_vector
      GLEW_APPLE_texture_range
      GLEW_APPLE_transform_hint
      GLEW_APPLE_vertex_array_object
      GLEW_APPLE_vertex_array_range
      GLEW_APPLE_vertex_program_evaluators
      GLEW_APPLE_ycbcr_422
      GLEW_ARB_ES2_compatibility
      GLEW_ARB_ES3_1_compatibility
      GLEW_ARB_ES3_2_compatibility
      GLEW_ARB_ES3_compatibility
      GLEW_ARB_arrays_of_arrays
      GLEW_ARB_base_instance
      GLEW_ARB_bindless_texture
      GLEW_ARB_blend_func_extended
      GLEW_ARB_buffer_storage
      GLEW_ARB_cl_event
      GLEW_ARB_clear_buffer_object
      GLEW_ARB_clear_texture
      GLEW_ARB_clip_control
      GLEW_ARB_color_buffer_float
      GLEW_ARB_compatibility
      GLEW_ARB_compressed_texture_pixel_storage
      GLEW_ARB_compute_shader
      GLEW_ARB_compute_variable_group_size
      GLEW_ARB_conditional_render_inverted
      GLEW_ARB_conservative_depth
      GLEW_ARB_copy_buffer
      GLEW_ARB_copy_image
      GLEW_ARB_cull_distance
      GLEW_ARB_debug_output
      GLEW_ARB_depth_buffer_float
      GLEW_ARB_depth_clamp
      GLEW_ARB_depth_texture
      GLEW_ARB_derivative_control
      GLEW_ARB_direct_state_access
      GLEW_ARB_draw_buffers
      GLEW_ARB_draw_buffers_blend
      GLEW_ARB_draw_elements_base_vertex
      GLEW_ARB_draw_indirect
      GLEW_ARB_draw_instanced
      GLEW_ARB_enhanced_layouts
      GLEW_ARB_explicit_attrib_location
      GLEW_ARB_explicit_uniform_location
      GLEW_ARB_fragment_coord_conventions
      GLEW_ARB_fragment_layer_viewport
      GLEW_ARB_fragment_program
      GLEW_ARB_fragment_program_shadow
      GLEW_ARB_fragment_shader
      GLEW_ARB_fragment_shader_interlock
      GLEW_ARB_framebuffer_no_attachments
      GLEW_ARB_framebuffer_object
      GLEW_ARB_framebuffer_sRGB
      GLEW_ARB_geometry_shader4
      GLEW_ARB_get_program_binary
      GLEW_ARB_get_texture_sub_image
      GLEW_ARB_gl_spirv
      GLEW_ARB_gpu_shader5
      GLEW_ARB_gpu_shader_fp64
      GLEW_ARB_gpu_shader_int64
      GLEW_ARB_half_float_pixel
      GLEW_ARB_half_float_vertex
      GLEW_ARB_imaging
      GLEW_ARB_indirect_parameters
      GLEW_ARB_instanced_arrays
      GLEW_ARB_internalformat_query
      GLEW_ARB_internalformat_query2
      GLEW_ARB_invalidate_subdata
      GLEW_ARB_map_buffer_alignment
      GLEW_ARB_map_buffer_range
      GLEW_ARB_matrix_palette
      GLEW_ARB_multi_bind
      GLEW_ARB_multi_draw_indirect
      GLEW_ARB_multisample
      GLEW_ARB_multitexture
      GLEW_ARB_occlusion_query
      GLEW_ARB_occlusion_query2
      GLEW_ARB_parallel_shader_compile
      GLEW_ARB_pipeline_statistics_query
      GLEW_ARB_pixel_buffer_object
      GLEW_ARB_point_parameters
      GLEW_ARB_point_sprite
      GLEW_ARB_post_depth_coverage
      GLEW_ARB_program_interface_query
      GLEW_ARB_provoking_vertex
      GLEW_ARB_query_buffer_object
      GLEW_ARB_robust_buffer_access_behavior
      GLEW_ARB_robustness
      GLEW_ARB_robustness_application_isolation
      GLEW_ARB_robustness_share_group_isolation
      GLEW_ARB_sample_locations
      GLEW_ARB_sample_shading
      GLEW_ARB_sampler_objects
      GLEW_ARB_seamless_cube_map
      GLEW_ARB_seamless_cubemap_per_texture
      GLEW_ARB_separate_shader_objects
      GLEW_ARB_shader_atomic_counter_ops
      GLEW_ARB_shader_atomic_counters
      GLEW_ARB_shader_ballot
      GLEW_ARB_shader_bit_encoding
      GLEW_ARB_shader_clock
      GLEW_ARB_shader_draw_parameters
      GLEW_ARB_shader_group_vote
      GLEW_ARB_shader_image_load_store
      GLEW_ARB_shader_image_size
      GLEW_ARB_shader_objects
      GLEW_ARB_shader_precision
      GLEW_ARB_shader_stencil_export
      GLEW_ARB_shader_storage_buffer_object
      GLEW_ARB_shader_subroutine
      GLEW_ARB_shader_texture_image_samples
      GLEW_ARB_shader_texture_lod
      GLEW_ARB_shader_viewport_layer_array
      GLEW_ARB_shading_language_100
      GLEW_ARB_shading_language_420pack
      GLEW_ARB_shading_language_include
      GLEW_ARB_shading_language_packing
      GLEW_ARB_shadow
      GLEW_ARB_shadow_ambient
      GLEW_ARB_sparse_buffer
      GLEW_ARB_sparse_texture
      GLEW_ARB_sparse_texture2
      GLEW_ARB_sparse_texture_clamp
      GLEW_ARB_stencil_texturing
      GLEW_ARB_sync
      GLEW_ARB_tessellation_shader
      GLEW_ARB_texture_barrier
      GLEW_ARB_texture_border_clamp
      GLEW_ARB_texture_buffer_object
      GLEW_ARB_texture_buffer_object_rgb32
      GLEW_ARB_texture_buffer_range
      GLEW_ARB_texture_compression
      GLEW_ARB_texture_compression_bptc
      GLEW_ARB_texture_compression_rgtc
      GLEW_ARB_texture_cube_map
      GLEW_ARB_texture_cube_map_array
      GLEW_ARB_texture_env_add
      GLEW_ARB_texture_env_combine
      GLEW_ARB_texture_env_crossbar
      GLEW_ARB_texture_env_dot3
      GLEW_ARB_texture_filter_minmax
      GLEW_ARB_texture_float
      GLEW_ARB_texture_gather
      GLEW_ARB_texture_mirror_clamp_to_edge
      GLEW_ARB_texture_mirrored_repeat
      GLEW_ARB_texture_multisample
      GLEW_ARB_texture_non_power_of_two
      GLEW_ARB_texture_query_levels
      GLEW_ARB_texture_query_lod
      GLEW_ARB_texture_rectangle
      GLEW_ARB_texture_rg
      GLEW_ARB_texture_rgb10_a2ui
      GLEW_ARB_texture_stencil8
      GLEW_ARB_texture_storage
      GLEW_ARB_texture_storage_multisample
      GLEW_ARB_texture_swizzle
      GLEW_ARB_texture_view
      GLEW_ARB_timer_query
      GLEW_ARB_transform_feedback2
      GLEW_ARB_transform_feedback3
      GLEW_ARB_transform_feedback_instanced
      GLEW_ARB_transform_feedback_overflow_query
      GLEW_ARB_transpose_matrix
      GLEW_ARB_uniform_buffer_object
      GLEW_ARB_vertex_array_bgra
      GLEW_ARB_vertex_array_object
      GLEW_ARB_vertex_attrib_64bit
      GLEW_ARB_vertex_attrib_binding
      GLEW_ARB_vertex_blend
      GLEW_ARB_vertex_buffer_object
      GLEW_ARB_vertex_program
      GLEW_ARB_vertex_shader
      GLEW_ARB_vertex_type_10f_11f_11f_rev
      GLEW_ARB_vertex_type_2_10_10_10_rev
      GLEW_ARB_viewport_array
      GLEW_ARB_window_pos
      GLEW_ATIX_point_sprites
      GLEW_ATIX_texture_env_combine3
      GLEW_ATIX_texture_env_route
      GLEW_ATIX_vertex_shader_output_point_size
      GLEW_ATI_draw_buffers
      GLEW_ATI_element_array
      GLEW_ATI_envmap_bumpmap
      GLEW_ATI_fragment_shader
      GLEW_ATI_map_object_buffer
      GLEW_ATI_meminfo
      GLEW_ATI_pn_triangles
      GLEW_ATI_separate_stencil
      GLEW_ATI_shader_texture_lod
      GLEW_ATI_text_fragment_shader
      GLEW_ATI_texture_compression_3dc
      GLEW_ATI_texture_env_combine3
      GLEW_ATI_texture_float
      GLEW_ATI_texture_mirror_once
      GLEW_ATI_vertex_array_object
      GLEW_ATI_vertex_attrib_array_object
      GLEW_ATI_vertex_streams
      GLEW_EGL_NV_robustness_video_memory_purge
      GLEW_ERROR_GLX_VERSION_11_ONLY
      GLEW_ERROR_GL_VERSION_10_ONLY
      GLEW_ERROR_NO_GL_VERSION
      GLEW_EXT_422_pixels
      GLEW_EXT_Cg_shader
      GLEW_EXT_abgr
      GLEW_EXT_bgra
      GLEW_EXT_bindable_uniform
      GLEW_EXT_blend_color
      GLEW_EXT_blend_equation_separate
      GLEW_EXT_blend_func_separate
      GLEW_EXT_blend_logic_op
      GLEW_EXT_blend_minmax
      GLEW_EXT_blend_subtract
      GLEW_EXT_clip_volume_hint
      GLEW_EXT_cmyka
      GLEW_EXT_color_subtable
      GLEW_EXT_compiled_vertex_array
      GLEW_EXT_convolution
      GLEW_EXT_coordinate_frame
      GLEW_EXT_copy_texture
      GLEW_EXT_cull_vertex
      GLEW_EXT_debug_label
      GLEW_EXT_debug_marker
      GLEW_EXT_depth_bounds_test
      GLEW_EXT_direct_state_access
      GLEW_EXT_draw_buffers2
      GLEW_EXT_draw_instanced
      GLEW_EXT_draw_range_elements
      GLEW_EXT_fog_coord
      GLEW_EXT_fragment_lighting
      GLEW_EXT_framebuffer_blit
      GLEW_EXT_framebuffer_multisample
      GLEW_EXT_framebuffer_multisample_blit_scaled
      GLEW_EXT_framebuffer_object
      GLEW_EXT_framebuffer_sRGB
      GLEW_EXT_geometry_shader4
      GLEW_EXT_gpu_program_parameters
      GLEW_EXT_gpu_shader4
      GLEW_EXT_histogram
      GLEW_EXT_index_array_formats
      GLEW_EXT_index_func
      GLEW_EXT_index_material
      GLEW_EXT_index_texture
      GLEW_EXT_light_texture
      GLEW_EXT_misc_attribute
      GLEW_EXT_multi_draw_arrays
      GLEW_EXT_multisample
      GLEW_EXT_packed_depth_stencil
      GLEW_EXT_packed_float
      GLEW_EXT_packed_pixels
      GLEW_EXT_paletted_texture
      GLEW_EXT_pixel_buffer_object
      GLEW_EXT_pixel_transform
      GLEW_EXT_pixel_transform_color_table
      GLEW_EXT_point_parameters
      GLEW_EXT_polygon_offset
      GLEW_EXT_polygon_offset_clamp
      GLEW_EXT_post_depth_coverage
      GLEW_EXT_provoking_vertex
      GLEW_EXT_raster_multisample
      GLEW_EXT_rescale_normal
      GLEW_EXT_scene_marker
      GLEW_EXT_secondary_color
      GLEW_EXT_separate_shader_objects
      GLEW_EXT_separate_specular_color
      GLEW_EXT_shader_image_load_formatted
      GLEW_EXT_shader_image_load_store
      GLEW_EXT_shader_integer_mix
      GLEW_EXT_shadow_funcs
      GLEW_EXT_shared_texture_palette
      GLEW_EXT_sparse_texture2
      GLEW_EXT_stencil_clear_tag
      GLEW_EXT_stencil_two_side
      GLEW_EXT_stencil_wrap
      GLEW_EXT_subtexture
      GLEW_EXT_texture
      GLEW_EXT_texture3D
      GLEW_EXT_texture_array
      GLEW_EXT_texture_buffer_object
      GLEW_EXT_texture_compression_dxt1
      GLEW_EXT_texture_compression_latc
      GLEW_EXT_texture_compression_rgtc
      GLEW_EXT_texture_compression_s3tc
      GLEW_EXT_texture_cube_map
      GLEW_EXT_texture_edge_clamp
      GLEW_EXT_texture_env
      GLEW_EXT_texture_env_add
      GLEW_EXT_texture_env_combine
      GLEW_EXT_texture_env_dot3
      GLEW_EXT_texture_filter_anisotropic
      GLEW_EXT_texture_filter_minmax
      GLEW_EXT_texture_integer
      GLEW_EXT_texture_lod_bias
      GLEW_EXT_texture_mirror_clamp
      GLEW_EXT_texture_object
      GLEW_EXT_texture_perturb_normal
      GLEW_EXT_texture_rectangle
      GLEW_EXT_texture_sRGB
      GLEW_EXT_texture_sRGB_decode
      GLEW_EXT_texture_shared_exponent
      GLEW_EXT_texture_snorm
      GLEW_EXT_texture_swizzle
      GLEW_EXT_timer_query
      GLEW_EXT_transform_feedback
      GLEW_EXT_vertex_array
      GLEW_EXT_vertex_array_bgra
      GLEW_EXT_vertex_attrib_64bit
      GLEW_EXT_vertex_shader
      GLEW_EXT_vertex_weighting
      GLEW_EXT_window_rectangles
      GLEW_EXT_x11_sync_object
      GLEW_FUN_EXPORT
      GLEW_GREMEDY_frame_terminator
      GLEW_GREMEDY_string_marker
      GLEW_HP_convolution_border_modes
      GLEW_HP_image_transform
      GLEW_HP_occlusion_test
      GLEW_HP_texture_lighting
      GLEW_IBM_cull_vertex
      GLEW_IBM_multimode_draw_arrays
      GLEW_IBM_rasterpos_clip
      GLEW_IBM_static_data
      GLEW_IBM_texture_mirrored_repeat
      GLEW_IBM_vertex_array_lists
      GLEW_INGR_color_clamp
      GLEW_INGR_interlace_read
      GLEW_INTEL_conservative_rasterization
      GLEW_INTEL_fragment_shader_ordering
      GLEW_INTEL_framebuffer_CMAA
      GLEW_INTEL_map_texture
      GLEW_INTEL_parallel_arrays
      GLEW_INTEL_performance_query
      GLEW_INTEL_texture_scissor
      GLEW_KHR_blend_equation_advanced
      GLEW_KHR_blend_equation_advanced_coherent
      GLEW_KHR_context_flush_control
      GLEW_KHR_debug
      GLEW_KHR_no_error
      GLEW_KHR_robust_buffer_access_behavior
      GLEW_KHR_robustness
      GLEW_KHR_texture_compression_astc_hdr
      GLEW_KHR_texture_compression_astc_ldr
      GLEW_KHR_texture_compression_astc_sliced_3d
      GLEW_KTX_buffer_region
      GLEW_MESAX_texture_stack
      GLEW_MESA_pack_invert
      GLEW_MESA_resize_buffers
      GLEW_MESA_shader_integer_functions
      GLEW_MESA_window_pos
      GLEW_MESA_ycbcr_texture
      GLEW_NO_ERROR
      GLEW_NVX_blend_equation_advanced_multi_draw_buffers
      GLEW_NVX_conditional_render
      GLEW_NVX_gpu_memory_info
      GLEW_NVX_linked_gpu_multicast
      GLEW_NV_bindless_multi_draw_indirect
      GLEW_NV_bindless_multi_draw_indirect_count
      GLEW_NV_bindless_texture
      GLEW_NV_blend_equation_advanced
      GLEW_NV_blend_equation_advanced_coherent
      GLEW_NV_blend_square
      GLEW_NV_clip_space_w_scaling
      GLEW_NV_command_list
      GLEW_NV_compute_program5
      GLEW_NV_conditional_render
      GLEW_NV_conservative_raster
      GLEW_NV_conservative_raster_dilate
      GLEW_NV_conservative_raster_pre_snap_triangles
      GLEW_NV_copy_depth_to_color
      GLEW_NV_copy_image
      GLEW_NV_deep_texture3D
      GLEW_NV_depth_buffer_float
      GLEW_NV_depth_clamp
      GLEW_NV_depth_range_unclamped
      GLEW_NV_draw_texture
      GLEW_NV_draw_vulkan_image
      GLEW_NV_evaluators
      GLEW_NV_explicit_multisample
      GLEW_NV_fence
      GLEW_NV_fill_rectangle
      GLEW_NV_float_buffer
      GLEW_NV_fog_distance
      GLEW_NV_fragment_coverage_to_color
      GLEW_NV_fragment_program
      GLEW_NV_fragment_program2
      GLEW_NV_fragment_program4
      GLEW_NV_fragment_program_option
      GLEW_NV_fragment_shader_interlock
      GLEW_NV_framebuffer_mixed_samples
      GLEW_NV_framebuffer_multisample_coverage
      GLEW_NV_geometry_program4
      GLEW_NV_geometry_shader4
      GLEW_NV_geometry_shader_passthrough
      GLEW_NV_gpu_multicast
      GLEW_NV_gpu_program4
      GLEW_NV_gpu_program5
      GLEW_NV_gpu_program5_mem_extended
      GLEW_NV_gpu_program_fp64
      GLEW_NV_gpu_shader5
      GLEW_NV_half_float
      GLEW_NV_internalformat_sample_query
      GLEW_NV_light_max_exponent
      GLEW_NV_multisample_coverage
      GLEW_NV_multisample_filter_hint
      GLEW_NV_occlusion_query
      GLEW_NV_packed_depth_stencil
      GLEW_NV_parameter_buffer_object
      GLEW_NV_parameter_buffer_object2
      GLEW_NV_path_rendering
      GLEW_NV_path_rendering_shared_edge
      GLEW_NV_pixel_data_range
      GLEW_NV_point_sprite
      GLEW_NV_present_video
      GLEW_NV_primitive_restart
      GLEW_NV_register_combiners
      GLEW_NV_register_combiners2
      GLEW_NV_robustness_video_memory_purge
      GLEW_NV_sample_locations
      GLEW_NV_sample_mask_override_coverage
      GLEW_NV_shader_atomic_counters
      GLEW_NV_shader_atomic_float
      GLEW_NV_shader_atomic_float64
      GLEW_NV_shader_atomic_fp16_vector
      GLEW_NV_shader_atomic_int64
      GLEW_NV_shader_buffer_load
      GLEW_NV_shader_storage_buffer_object
      GLEW_NV_shader_thread_group
      GLEW_NV_shader_thread_shuffle
      GLEW_NV_stereo_view_rendering
      GLEW_NV_tessellation_program5
      GLEW_NV_texgen_emboss
      GLEW_NV_texgen_reflection
      GLEW_NV_texture_barrier
      GLEW_NV_texture_compression_vtc
      GLEW_NV_texture_env_combine4
      GLEW_NV_texture_expand_normal
      GLEW_NV_texture_multisample
      GLEW_NV_texture_rectangle
      GLEW_NV_texture_shader
      GLEW_NV_texture_shader2
      GLEW_NV_texture_shader3
      GLEW_NV_transform_feedback
      GLEW_NV_transform_feedback2
      GLEW_NV_uniform_buffer_unified_memory
      GLEW_NV_vdpau_interop
      GLEW_NV_vertex_array_range
      GLEW_NV_vertex_array_range2
      GLEW_NV_vertex_attrib_integer_64bit
      GLEW_NV_vertex_buffer_unified_memory
      GLEW_NV_vertex_program
      GLEW_NV_vertex_program1_1
      GLEW_NV_vertex_program2
      GLEW_NV_vertex_program2_option
      GLEW_NV_vertex_program3
      GLEW_NV_vertex_program4
      GLEW_NV_video_capture
      GLEW_NV_viewport_array2
      GLEW_NV_viewport_swizzle
      GLEW_OES_byte_coordinates
      GLEW_OES_compressed_paletted_texture
      GLEW_OES_read_format
      GLEW_OES_single_precision
      GLEW_OK
      GLEW_OML_interlace
      GLEW_OML_resample
      GLEW_OML_subsample
      GLEW_OVR_multiview
      GLEW_OVR_multiview2
      GLEW_PGI_misc_hints
      GLEW_PGI_vertex_hints
      GLEW_REGAL_ES1_0_compatibility
      GLEW_REGAL_ES1_1_compatibility
      GLEW_REGAL_enable
      GLEW_REGAL_error_string
      GLEW_REGAL_extension_query
      GLEW_REGAL_log
      GLEW_REGAL_proc_address
      GLEW_REND_screen_coordinates
      GLEW_S3_s3tc
      GLEW_SGIS_color_range
      GLEW_SGIS_detail_texture
      GLEW_SGIS_fog_function
      GLEW_SGIS_generate_mipmap
      GLEW_SGIS_multisample
      GLEW_SGIS_pixel_texture
      GLEW_SGIS_point_line_texgen
      GLEW_SGIS_sharpen_texture
      GLEW_SGIS_texture4D
      GLEW_SGIS_texture_border_clamp
      GLEW_SGIS_texture_edge_clamp
      GLEW_SGIS_texture_filter4
      GLEW_SGIS_texture_lod
      GLEW_SGIS_texture_select
      GLEW_SGIX_async
      GLEW_SGIX_async_histogram
      GLEW_SGIX_async_pixel
      GLEW_SGIX_blend_alpha_minmax
      GLEW_SGIX_clipmap
      GLEW_SGIX_convolution_accuracy
      GLEW_SGIX_depth_texture
      GLEW_SGIX_flush_raster
      GLEW_SGIX_fog_offset
      GLEW_SGIX_fog_texture
      GLEW_SGIX_fragment_specular_lighting
      GLEW_SGIX_framezoom
      GLEW_SGIX_interlace
      GLEW_SGIX_ir_instrument1
      GLEW_SGIX_list_priority
      GLEW_SGIX_pixel_texture
      GLEW_SGIX_pixel_texture_bits
      GLEW_SGIX_reference_plane
      GLEW_SGIX_resample
      GLEW_SGIX_shadow
      GLEW_SGIX_shadow_ambient
      GLEW_SGIX_sprite
      GLEW_SGIX_tag_sample_buffer
      GLEW_SGIX_texture_add_env
      GLEW_SGIX_texture_coordinate_clamp
      GLEW_SGIX_texture_lod_bias
      GLEW_SGIX_texture_multi_buffer
      GLEW_SGIX_texture_range
      GLEW_SGIX_texture_scale_bias
      GLEW_SGIX_vertex_preclip
      GLEW_SGIX_vertex_preclip_hint
      GLEW_SGIX_ycrcb
      GLEW_SGI_color_matrix
      GLEW_SGI_color_table
      GLEW_SGI_texture_color_table
      GLEW_SUNX_constant_data
      GLEW_SUN_convolution_border_modes
      GLEW_SUN_global_alpha
      GLEW_SUN_mesh_array
      GLEW_SUN_read_video_pixels
      GLEW_SUN_slice_accum
      GLEW_SUN_triangle_list
      GLEW_SUN_vertex
      GLEW_VAR_EXPORT
      GLEW_VERSION
      GLEW_VERSION_1_1
      GLEW_VERSION_1_2
      GLEW_VERSION_1_2_1
      GLEW_VERSION_1_3
      GLEW_VERSION_1_4
      GLEW_VERSION_1_5
      GLEW_VERSION_2_0
      GLEW_VERSION_2_1
      GLEW_VERSION_3_0
      GLEW_VERSION_3_1
      GLEW_VERSION_3_2
      GLEW_VERSION_3_3
      GLEW_VERSION_4_0
      GLEW_VERSION_4_1
      GLEW_VERSION_4_2
      GLEW_VERSION_4_3
      GLEW_VERSION_4_4
      GLEW_VERSION_4_5
      GLEW_VERSION_MAJOR
      GLEW_VERSION_MICRO
      GLEW_VERSION_MINOR
      GLEW_WIN_phong_shading
      GLEW_WIN_specular_fog
      GLEW_WIN_swap_hint
      GL_1PASS_EXT
      GL_1PASS_SGIS
      GL_2D
      GL_2PASS_0_EXT
      GL_2PASS_0_SGIS
      GL_2PASS_1_EXT
      GL_2PASS_1_SGIS
      GL_2X_BIT_ATI
      GL_2_BYTES
      GL_3D
      GL_3DFX_multisample
      GL_3DFX_tbuffer
      GL_3DFX_texture_compression_FXT1
      GL_3D_COLOR
      GL_3D_COLOR_TEXTURE
      GL_3_BYTES
      GL_422_AVERAGE_EXT
      GL_422_EXT
      GL_422_REV_AVERAGE_EXT
      GL_422_REV_EXT
      GL_4D_COLOR_TEXTURE
      GL_4PASS_0_EXT
      GL_4PASS_0_SGIS
      GL_4PASS_1_EXT
      GL_4PASS_1_SGIS
      GL_4PASS_2_EXT
      GL_4PASS_2_SGIS
      GL_4PASS_3_EXT
      GL_4PASS_3_SGIS
      GL_4X_BIT_ATI
      GL_4_BYTES
      GL_8X_BIT_ATI
      GL_ABGR_EXT
      GL_ACCUM
      GL_ACCUM_ADJACENT_PAIRS_NV
      GL_ACCUM_ALPHA_BITS
      GL_ACCUM_BLUE_BITS
      GL_ACCUM_BUFFER_BIT
      GL_ACCUM_CLEAR_VALUE
      GL_ACCUM_GREEN_BITS
      GL_ACCUM_RED_BITS
      GL_ACTIVE_ATOMIC_COUNTER_BUFFERS
      GL_ACTIVE_ATTRIBUTES
      GL_ACTIVE_ATTRIBUTE_MAX_LENGTH
      GL_ACTIVE_PROGRAM
      GL_ACTIVE_PROGRAM_EXT
      GL_ACTIVE_RESOURCES
      GL_ACTIVE_STENCIL_FACE_EXT
      GL_ACTIVE_SUBROUTINES
      GL_ACTIVE_SUBROUTINE_MAX_LENGTH
      GL_ACTIVE_SUBROUTINE_UNIFORMS
      GL_ACTIVE_SUBROUTINE_UNIFORM_LOCATIONS
      GL_ACTIVE_SUBROUTINE_UNIFORM_MAX_LENGTH
      GL_ACTIVE_TEXTURE
      GL_ACTIVE_TEXTURE_ARB
      GL_ACTIVE_UNIFORMS
      GL_ACTIVE_UNIFORM_BLOCKS
      GL_ACTIVE_UNIFORM_BLOCK_MAX_NAME_LENGTH
      GL_ACTIVE_UNIFORM_MAX_LENGTH
      GL_ACTIVE_VARIABLES
      GL_ACTIVE_VARYINGS_NV
      GL_ACTIVE_VARYING_MAX_LENGTH_NV
      GL_ACTIVE_VERTEX_UNITS_ARB
      GL_ADD
      GL_ADD_ATI
      GL_ADD_SIGNED
      GL_ADD_SIGNED_ARB
      GL_ADD_SIGNED_EXT
      GL_ADJACENT_PAIRS_NV
      GL_AFFINE_2D_NV
      GL_AFFINE_3D_NV
      GL_ALIASED_LINE_WIDTH_RANGE
      GL_ALIASED_POINT_SIZE_RANGE
      GL_ALLOW_DRAW_FRG_HINT_PGI
      GL_ALLOW_DRAW_MEM_HINT_PGI
      GL_ALLOW_DRAW_OBJ_HINT_PGI
      GL_ALLOW_DRAW_WIN_HINT_PGI
      GL_ALL_ATTRIB_BITS
      GL_ALL_BARRIER_BITS
      GL_ALL_BARRIER_BITS_EXT
      GL_ALL_COMPLETED_NV
      GL_ALL_SHADER_BITS
      GL_ALL_STATIC_DATA_IBM
      GL_ALPHA
      GL_ALPHA12
      GL_ALPHA12_EXT
      GL_ALPHA16
      GL_ALPHA16F_ARB
      GL_ALPHA16I_EXT
      GL_ALPHA16UI_EXT
      GL_ALPHA16_EXT
      GL_ALPHA16_EXTENDED_RANGE_SGIX
      GL_ALPHA16_SIGNED_SGIX
      GL_ALPHA16_SNORM
      GL_ALPHA32F_ARB
      GL_ALPHA32I_EXT
      GL_ALPHA32UI_EXT
      GL_ALPHA4
      GL_ALPHA4_EXT
      GL_ALPHA8
      GL_ALPHA8I_EXT
      GL_ALPHA8UI_EXT
      GL_ALPHA8_EXT
      GL_ALPHA8_SNORM
      GL_ALPHA_BIAS
      GL_ALPHA_BITS
      GL_ALPHA_EXTENDED_RANGE_SGIX
      GL_ALPHA_FLOAT16_APPLE
      GL_ALPHA_FLOAT16_ATI
      GL_ALPHA_FLOAT32_APPLE
      GL_ALPHA_FLOAT32_ATI
      GL_ALPHA_INTEGER
      GL_ALPHA_INTEGER_EXT
      GL_ALPHA_MAX_CLAMP_INGR
      GL_ALPHA_MAX_SGIX
      GL_ALPHA_MIN_CLAMP_INGR
      GL_ALPHA_MIN_SGIX
      GL_ALPHA_REF_COMMAND_NV
      GL_ALPHA_SCALE
      GL_ALPHA_SIGNED_SGIX
      GL_ALPHA_SNORM
      GL_ALPHA_TEST
      GL_ALPHA_TEST_FUNC
      GL_ALPHA_TEST_REF
      GL_ALREADY_SIGNALED
      GL_ALWAYS
      GL_ALWAYS_FAST_HINT_PGI
      GL_ALWAYS_SOFT_HINT_PGI
      GL_AMBIENT
      GL_AMBIENT_AND_DIFFUSE
      GL_AMD_blend_minmax_factor
      GL_AMD_conservative_depth
      GL_AMD_debug_output
      GL_AMD_depth_clamp_separate
      GL_AMD_draw_buffers_blend
      GL_AMD_gcn_shader
      GL_AMD_gpu_shader_int64
      GL_AMD_interleaved_elements
      GL_AMD_multi_draw_indirect
      GL_AMD_name_gen_delete
      GL_AMD_occlusion_query_event
      GL_AMD_performance_monitor
      GL_AMD_pinned_memory
      GL_AMD_query_buffer_object
      GL_AMD_sample_positions
      GL_AMD_seamless_cubemap_per_texture
      GL_AMD_shader_atomic_counter_ops
      GL_AMD_shader_explicit_vertex_parameter
      GL_AMD_shader_stencil_export
      GL_AMD_shader_stencil_value_export
      GL_AMD_shader_trinary_minmax
      GL_AMD_sparse_texture
      GL_AMD_stencil_operation_extended
      GL_AMD_texture_texture4
      GL_AMD_transform_feedback3_lines_triangles
      GL_AMD_transform_feedback4
      GL_AMD_vertex_shader_layer
      GL_AMD_vertex_shader_tessellator
      GL_AMD_vertex_shader_viewport_index
      GL_AND
      GL_AND_INVERTED
      GL_AND_REVERSE
      GL_ANGLE_depth_texture
      GL_ANGLE_framebuffer_blit
      GL_ANGLE_framebuffer_multisample
      GL_ANGLE_instanced_arrays
      GL_ANGLE_pack_reverse_row_order
      GL_ANGLE_program_binary
      GL_ANGLE_texture_compression_dxt1
      GL_ANGLE_texture_compression_dxt3
      GL_ANGLE_texture_compression_dxt5
      GL_ANGLE_texture_usage
      GL_ANGLE_timer_query
      GL_ANGLE_translated_shader_source
      GL_ANY_SAMPLES_PASSED
      GL_ANY_SAMPLES_PASSED_CONSERVATIVE
      GL_APPLE_aux_depth_stencil
      GL_APPLE_client_storage
      GL_APPLE_element_array
      GL_APPLE_fence
      GL_APPLE_float_pixels
      GL_APPLE_flush_buffer_range
      GL_APPLE_object_purgeable
      GL_APPLE_pixel_buffer
      GL_APPLE_rgb_422
      GL_APPLE_row_bytes
      GL_APPLE_specular_vector
      GL_APPLE_texture_range
      GL_APPLE_transform_hint
      GL_APPLE_vertex_array_object
      GL_APPLE_vertex_array_range
      GL_APPLE_vertex_program_evaluators
      GL_APPLE_ycbcr_422
      GL_ARB_ES2_compatibility
      GL_ARB_ES3_1_compatibility
      GL_ARB_ES3_2_compatibility
      GL_ARB_ES3_compatibility
      GL_ARB_arrays_of_arrays
      GL_ARB_base_instance
      GL_ARB_bindless_texture
      GL_ARB_blend_func_extended
      GL_ARB_buffer_storage
      GL_ARB_cl_event
      GL_ARB_clear_buffer_object
      GL_ARB_clear_texture
      GL_ARB_clip_control
      GL_ARB_color_buffer_float
      GL_ARB_compatibility
      GL_ARB_compressed_texture_pixel_storage
      GL_ARB_compute_shader
      GL_ARB_compute_variable_group_size
      GL_ARB_conditional_render_inverted
      GL_ARB_conservative_depth
      GL_ARB_copy_buffer
      GL_ARB_copy_image
      GL_ARB_cull_distance
      GL_ARB_debug_output
      GL_ARB_depth_buffer_float
      GL_ARB_depth_clamp
      GL_ARB_depth_texture
      GL_ARB_derivative_control
      GL_ARB_direct_state_access
      GL_ARB_draw_buffers
      GL_ARB_draw_buffers_blend
      GL_ARB_draw_elements_base_vertex
      GL_ARB_draw_indirect
      GL_ARB_draw_instanced
      GL_ARB_enhanced_layouts
      GL_ARB_explicit_attrib_location
      GL_ARB_explicit_uniform_location
      GL_ARB_fragment_coord_conventions
      GL_ARB_fragment_layer_viewport
      GL_ARB_fragment_program
      GL_ARB_fragment_program_shadow
      GL_ARB_fragment_shader
      GL_ARB_fragment_shader_interlock
      GL_ARB_framebuffer_no_attachments
      GL_ARB_framebuffer_object
      GL_ARB_framebuffer_sRGB
      GL_ARB_geometry_shader4
      GL_ARB_get_program_binary
      GL_ARB_get_texture_sub_image
      GL_ARB_gl_spirv
      GL_ARB_gpu_shader5
      GL_ARB_gpu_shader_fp64
      GL_ARB_gpu_shader_int64
      GL_ARB_half_float_pixel
      GL_ARB_half_float_vertex
      GL_ARB_imaging
      GL_ARB_indirect_parameters
      GL_ARB_instanced_arrays
      GL_ARB_internalformat_query
      GL_ARB_internalformat_query2
      GL_ARB_invalidate_subdata
      GL_ARB_map_buffer_alignment
      GL_ARB_map_buffer_range
      GL_ARB_matrix_palette
      GL_ARB_multi_bind
      GL_ARB_multi_draw_indirect
      GL_ARB_multisample
      GL_ARB_multitexture
      GL_ARB_occlusion_query
      GL_ARB_occlusion_query2
      GL_ARB_parallel_shader_compile
      GL_ARB_pipeline_statistics_query
      GL_ARB_pixel_buffer_object
      GL_ARB_point_parameters
      GL_ARB_point_sprite
      GL_ARB_post_depth_coverage
      GL_ARB_program_interface_query
      GL_ARB_provoking_vertex
      GL_ARB_query_buffer_object
      GL_ARB_robust_buffer_access_behavior
      GL_ARB_robustness
      GL_ARB_robustness_application_isolation
      GL_ARB_robustness_share_group_isolation
      GL_ARB_sample_locations
      GL_ARB_sample_shading
      GL_ARB_sampler_objects
      GL_ARB_seamless_cube_map
      GL_ARB_seamless_cubemap_per_texture
      GL_ARB_separate_shader_objects
      GL_ARB_shader_atomic_counter_ops
      GL_ARB_shader_atomic_counters
      GL_ARB_shader_ballot
      GL_ARB_shader_bit_encoding
      GL_ARB_shader_clock
      GL_ARB_shader_draw_parameters
      GL_ARB_shader_group_vote
      GL_ARB_shader_image_load_store
      GL_ARB_shader_image_size
      GL_ARB_shader_objects
      GL_ARB_shader_precision
      GL_ARB_shader_stencil_export
      GL_ARB_shader_storage_buffer_object
      GL_ARB_shader_subroutine
      GL_ARB_shader_texture_image_samples
      GL_ARB_shader_texture_lod
      GL_ARB_shader_viewport_layer_array
      GL_ARB_shading_language_100
      GL_ARB_shading_language_420pack
      GL_ARB_shading_language_include
      GL_ARB_shading_language_packing
      GL_ARB_shadow
      GL_ARB_shadow_ambient
      GL_ARB_sparse_buffer
      GL_ARB_sparse_texture
      GL_ARB_sparse_texture2
      GL_ARB_sparse_texture_clamp
      GL_ARB_stencil_texturing
      GL_ARB_sync
      GL_ARB_tessellation_shader
      GL_ARB_texture_barrier
      GL_ARB_texture_border_clamp
      GL_ARB_texture_buffer_object
      GL_ARB_texture_buffer_object_rgb32
      GL_ARB_texture_buffer_range
      GL_ARB_texture_compression
      GL_ARB_texture_compression_bptc
      GL_ARB_texture_compression_rgtc
      GL_ARB_texture_cube_map
      GL_ARB_texture_cube_map_array
      GL_ARB_texture_env_add
      GL_ARB_texture_env_combine
      GL_ARB_texture_env_crossbar
      GL_ARB_texture_env_dot3
      GL_ARB_texture_filter_minmax
      GL_ARB_texture_float
      GL_ARB_texture_gather
      GL_ARB_texture_mirror_clamp_to_edge
      GL_ARB_texture_mirrored_repeat
      GL_ARB_texture_multisample
      GL_ARB_texture_non_power_of_two
      GL_ARB_texture_query_levels
      GL_ARB_texture_query_lod
      GL_ARB_texture_rectangle
      GL_ARB_texture_rg
      GL_ARB_texture_rgb10_a2ui
      GL_ARB_texture_stencil8
      GL_ARB_texture_storage
      GL_ARB_texture_storage_multisample
      GL_ARB_texture_swizzle
      GL_ARB_texture_view
      GL_ARB_timer_query
      GL_ARB_transform_feedback2
      GL_ARB_transform_feedback3
      GL_ARB_transform_feedback_instanced
      GL_ARB_transform_feedback_overflow_query
      GL_ARB_transpose_matrix
      GL_ARB_uniform_buffer_object
      GL_ARB_vertex_array_bgra
      GL_ARB_vertex_array_object
      GL_ARB_vertex_attrib_64bit
      GL_ARB_vertex_attrib_binding
      GL_ARB_vertex_blend
      GL_ARB_vertex_buffer_object
      GL_ARB_vertex_program
      GL_ARB_vertex_shader
      GL_ARB_vertex_type_10f_11f_11f_rev
      GL_ARB_vertex_type_2_10_10_10_rev
      GL_ARB_viewport_array
      GL_ARB_window_pos
      GL_ARC_TO_NV
      GL_ARRAY_BUFFER
      GL_ARRAY_BUFFER_ARB
      GL_ARRAY_BUFFER_BINDING
      GL_ARRAY_BUFFER_BINDING_ARB
      GL_ARRAY_ELEMENT_LOCK_COUNT_EXT
      GL_ARRAY_ELEMENT_LOCK_FIRST_EXT
      GL_ARRAY_OBJECT_BUFFER_ATI
      GL_ARRAY_OBJECT_OFFSET_ATI
      GL_ARRAY_SIZE
      GL_ARRAY_STRIDE
      GL_ASYNC_DRAW_PIXELS_SGIX
      GL_ASYNC_HISTOGRAM_SGIX
      GL_ASYNC_MARKER_SGIX
      GL_ASYNC_READ_PIXELS_SGIX
      GL_ASYNC_TEX_IMAGE_SGIX
      GL_ATIX_point_sprites
      GL_ATIX_texture_env_combine3
      GL_ATIX_texture_env_route
      GL_ATIX_vertex_shader_output_point_size
      GL_ATI_draw_buffers
      GL_ATI_element_array
      GL_ATI_envmap_bumpmap
      GL_ATI_fragment_shader
      GL_ATI_map_object_buffer
      GL_ATI_meminfo
      GL_ATI_pn_triangles
      GL_ATI_separate_stencil
      GL_ATI_shader_texture_lod
      GL_ATI_text_fragment_shader
      GL_ATI_texture_compression_3dc
      GL_ATI_texture_env_combine3
      GL_ATI_texture_float
      GL_ATI_texture_mirror_once
      GL_ATI_vertex_array_object
      GL_ATI_vertex_attrib_array_object
      GL_ATI_vertex_streams
      GL_ATOMIC_COUNTER_BARRIER_BIT
      GL_ATOMIC_COUNTER_BARRIER_BIT_EXT
      GL_ATOMIC_COUNTER_BUFFER
      GL_ATOMIC_COUNTER_BUFFER_ACTIVE_ATOMIC_COUNTERS
      GL_ATOMIC_COUNTER_BUFFER_ACTIVE_ATOMIC_COUNTER_INDICES
      GL_ATOMIC_COUNTER_BUFFER_BINDING
      GL_ATOMIC_COUNTER_BUFFER_DATA_SIZE
      GL_ATOMIC_COUNTER_BUFFER_INDEX
      GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_COMPUTE_SHADER
      GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_FRAGMENT_SHADER
      GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_GEOMETRY_SHADER
      GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_TESS_CONTROL_SHADER
      GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_TESS_EVALUATION_SHADER
      GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_VERTEX_SHADER
      GL_ATOMIC_COUNTER_BUFFER_SIZE
      GL_ATOMIC_COUNTER_BUFFER_START
      GL_ATTACHED_SHADERS
      GL_ATTENUATION_EXT
      GL_ATTRIBUTE_ADDRESS_COMMAND_NV
      GL_ATTRIB_ARRAY_POINTER_NV
      GL_ATTRIB_ARRAY_SIZE_NV
      GL_ATTRIB_ARRAY_STRIDE_NV
      GL_ATTRIB_ARRAY_TYPE_NV
      GL_ATTRIB_STACK_DEPTH
      GL_AUTO_GENERATE_MIPMAP
      GL_AUTO_NORMAL
      GL_AUX0
      GL_AUX1
      GL_AUX2
      GL_AUX3
      GL_AUX_BUFFERS
      GL_AUX_DEPTH_STENCIL_APPLE
      GL_AVERAGE_EXT
      GL_BACK
      GL_BACK_LEFT
      GL_BACK_NORMALS_HINT_PGI
      GL_BACK_PRIMARY_COLOR_NV
      GL_BACK_RIGHT
      GL_BACK_SECONDARY_COLOR_NV
      GL_BEVEL_NV
      GL_BGR
      GL_BGRA
      GL_BGRA_EXT
      GL_BGRA_INTEGER
      GL_BGRA_INTEGER_EXT
      GL_BGR_EXT
      GL_BGR_INTEGER
      GL_BGR_INTEGER_EXT
      GL_BIAS_BIT_ATI
      GL_BIAS_BY_NEGATIVE_ONE_HALF_NV
      GL_BINORMAL_ARRAY_EXT
      GL_BINORMAL_ARRAY_POINTER_EXT
      GL_BINORMAL_ARRAY_STRIDE_EXT
      GL_BINORMAL_ARRAY_TYPE_EXT
      GL_BITMAP
      GL_BITMAP_TOKEN
      GL_BLEND
      GL_BLEND_ADVANCED_COHERENT_KHR
      GL_BLEND_ADVANCED_COHERENT_NV
      GL_BLEND_COLOR
      GL_BLEND_COLOR_COMMAND_NV
      GL_BLEND_COLOR_EXT
      GL_BLEND_DST
      GL_BLEND_DST_ALPHA
      GL_BLEND_DST_ALPHA_EXT
      GL_BLEND_DST_RGB
      GL_BLEND_DST_RGB_EXT
      GL_BLEND_EQUATION
      GL_BLEND_EQUATION_ALPHA
      GL_BLEND_EQUATION_ALPHA_EXT
      GL_BLEND_EQUATION_EXT
      GL_BLEND_EQUATION_RGB
      GL_BLEND_EQUATION_RGB_EXT
      GL_BLEND_OVERLAP_NV
      GL_BLEND_PREMULTIPLIED_SRC_NV
      GL_BLEND_SRC
      GL_BLEND_SRC_ALPHA
      GL_BLEND_SRC_ALPHA_EXT
      GL_BLEND_SRC_RGB
      GL_BLEND_SRC_RGB_EXT
      GL_BLOCK_INDEX
      GL_BLUE
      GL_BLUE_BIAS
      GL_BLUE_BITS
      GL_BLUE_BIT_ATI
      GL_BLUE_INTEGER
      GL_BLUE_INTEGER_EXT
      GL_BLUE_MAX_CLAMP_INGR
      GL_BLUE_MIN_CLAMP_INGR
      GL_BLUE_NV
      GL_BLUE_SCALE
      GL_BOLD_BIT_NV
      GL_BOOL
      GL_BOOL_ARB
      GL_BOOL_VEC2
      GL_BOOL_VEC2_ARB
      GL_BOOL_VEC3
      GL_BOOL_VEC3_ARB
      GL_BOOL_VEC4
      GL_BOOL_VEC4_ARB
      GL_BOUNDING_BOX_NV
      GL_BOUNDING_BOX_OF_BOUNDING_BOXES_NV
      GL_BUFFER
      GL_BUFFER_ACCESS
      GL_BUFFER_ACCESS_ARB
      GL_BUFFER_ACCESS_FLAGS
      GL_BUFFER_BINDING
      GL_BUFFER_DATA_SIZE
      GL_BUFFER_FLUSHING_UNMAP_APPLE
      GL_BUFFER_GPU_ADDRESS_NV
      GL_BUFFER_IMMUTABLE_STORAGE
      GL_BUFFER_MAPPED
      GL_BUFFER_MAPPED_ARB
      GL_BUFFER_MAP_LENGTH
      GL_BUFFER_MAP_OFFSET
      GL_BUFFER_MAP_POINTER
      GL_BUFFER_MAP_POINTER_ARB
      GL_BUFFER_OBJECT_APPLE
      GL_BUFFER_OBJECT_EXT
      GL_BUFFER_SERIALIZED_MODIFY_APPLE
      GL_BUFFER_SIZE
      GL_BUFFER_SIZE_ARB
      GL_BUFFER_STORAGE_FLAGS
      GL_BUFFER_UPDATE_BARRIER_BIT
      GL_BUFFER_UPDATE_BARRIER_BIT_EXT
      GL_BUFFER_USAGE
      GL_BUFFER_USAGE_ARB
      GL_BUFFER_VARIABLE
      GL_BUMP_ENVMAP_ATI
      GL_BUMP_NUM_TEX_UNITS_ATI
      GL_BUMP_ROT_MATRIX_ATI
      GL_BUMP_ROT_MATRIX_SIZE_ATI
      GL_BUMP_TARGET_ATI
      GL_BUMP_TEX_UNITS_ATI
      GL_BYTE
      GL_C3F_V3F
      GL_C4F_N3F_V3F
      GL_C4UB_V2F
      GL_C4UB_V3F
      GL_CACHE_REGAL
      GL_CAVEAT_SUPPORT
      GL_CCW
      GL_CG_FRAGMENT_SHADER_EXT
      GL_CG_VERTEX_SHADER_EXT
      GL_CIRCULAR_CCW_ARC_TO_NV
      GL_CIRCULAR_CW_ARC_TO_NV
      GL_CIRCULAR_TANGENT_ARC_TO_NV
      GL_CLAMP
      GL_CLAMP_FRAGMENT_COLOR
      GL_CLAMP_FRAGMENT_COLOR_ARB
      GL_CLAMP_READ_COLOR
      GL_CLAMP_READ_COLOR_ARB
      GL_CLAMP_TO_BORDER
      GL_CLAMP_TO_BORDER_ARB
      GL_CLAMP_TO_BORDER_SGIS
      GL_CLAMP_TO_EDGE
      GL_CLAMP_TO_EDGE_EXT
      GL_CLAMP_TO_EDGE_SGIS
      GL_CLAMP_VERTEX_COLOR
      GL_CLAMP_VERTEX_COLOR_ARB
      GL_CLEAR
      GL_CLEAR_BUFFER
      GL_CLEAR_TEXTURE
      GL_CLIENT_ACTIVE_TEXTURE
      GL_CLIENT_ACTIVE_TEXTURE_ARB
      GL_CLIENT_ALL_ATTRIB_BITS
      GL_CLIENT_ATTRIB_STACK_DEPTH
      GL_CLIENT_MAPPED_BUFFER_BARRIER_BIT
      GL_CLIENT_PIXEL_STORE_BIT
      GL_CLIENT_STORAGE_BIT
      GL_CLIENT_VERTEX_ARRAY_BIT
      GL_CLIPPING_INPUT_PRIMITIVES_ARB
      GL_CLIPPING_OUTPUT_PRIMITIVES_ARB
      GL_CLIP_DEPTH_MODE
      GL_CLIP_DISTANCE0
      GL_CLIP_DISTANCE1
      GL_CLIP_DISTANCE2
      GL_CLIP_DISTANCE3
      GL_CLIP_DISTANCE4
      GL_CLIP_DISTANCE5
      GL_CLIP_DISTANCE_NV
      GL_CLIP_FAR_HINT_PGI
      GL_CLIP_NEAR_HINT_PGI
      GL_CLIP_ORIGIN
      GL_CLIP_PLANE0
      GL_CLIP_PLANE1
      GL_CLIP_PLANE2
      GL_CLIP_PLANE3
      GL_CLIP_PLANE4
      GL_CLIP_PLANE5
      GL_CLIP_VOLUME_CLIPPING_HINT_EXT
      GL_CLOSE_PATH_NV
      GL_CMYKA_EXT
      GL_CMYK_EXT
      GL_CND0_ATI
      GL_CND_ATI
      GL_CODE_REGAL
      GL_COEFF
      GL_COLOR
      GL_COLOR3_BIT_PGI
      GL_COLOR4_BIT_PGI
      GL_COLORBURN_KHR
      GL_COLORBURN_NV
      GL_COLORDODGE_KHR
      GL_COLORDODGE_NV
      GL_COLOR_ALPHA_PAIRING_ATI
      GL_COLOR_ARRAY
      GL_COLOR_ARRAY_ADDRESS_NV
      GL_COLOR_ARRAY_BUFFER_BINDING
      GL_COLOR_ARRAY_BUFFER_BINDING_ARB
      GL_COLOR_ARRAY_COUNT_EXT
      GL_COLOR_ARRAY_EXT
      GL_COLOR_ARRAY_LENGTH_NV
      GL_COLOR_ARRAY_LIST_IBM
      GL_COLOR_ARRAY_LIST_STRIDE_IBM
      GL_COLOR_ARRAY_PARALLEL_POINTERS_INTEL
      GL_COLOR_ARRAY_POINTER
      GL_COLOR_ARRAY_POINTER_EXT
      GL_COLOR_ARRAY_SIZE
      GL_COLOR_ARRAY_SIZE_EXT
      GL_COLOR_ARRAY_STRIDE
      GL_COLOR_ARRAY_STRIDE_EXT
      GL_COLOR_ARRAY_TYPE
      GL_COLOR_ARRAY_TYPE_EXT
      GL_COLOR_ATTACHMENT0
      GL_COLOR_ATTACHMENT0_EXT
      GL_COLOR_ATTACHMENT1
      GL_COLOR_ATTACHMENT10
      GL_COLOR_ATTACHMENT10_EXT
      GL_COLOR_ATTACHMENT11
      GL_COLOR_ATTACHMENT11_EXT
      GL_COLOR_ATTACHMENT12
      GL_COLOR_ATTACHMENT12_EXT
      GL_COLOR_ATTACHMENT13
      GL_COLOR_ATTACHMENT13_EXT
      GL_COLOR_ATTACHMENT14
      GL_COLOR_ATTACHMENT14_EXT
      GL_COLOR_ATTACHMENT15
      GL_COLOR_ATTACHMENT15_EXT
      GL_COLOR_ATTACHMENT1_EXT
      GL_COLOR_ATTACHMENT2
      GL_COLOR_ATTACHMENT2_EXT
      GL_COLOR_ATTACHMENT3
      GL_COLOR_ATTACHMENT3_EXT
      GL_COLOR_ATTACHMENT4
      GL_COLOR_ATTACHMENT4_EXT
      GL_COLOR_ATTACHMENT5
      GL_COLOR_ATTACHMENT5_EXT
      GL_COLOR_ATTACHMENT6
      GL_COLOR_ATTACHMENT6_EXT
      GL_COLOR_ATTACHMENT7
      GL_COLOR_ATTACHMENT7_EXT
      GL_COLOR_ATTACHMENT8
      GL_COLOR_ATTACHMENT8_EXT
      GL_COLOR_ATTACHMENT9
      GL_COLOR_ATTACHMENT9_EXT
      GL_COLOR_BUFFER_BIT
      GL_COLOR_CLEAR_VALUE
      GL_COLOR_COMPONENTS
      GL_COLOR_ENCODING
      GL_COLOR_FLOAT_APPLE
      GL_COLOR_INDEX
      GL_COLOR_INDEX12_EXT
      GL_COLOR_INDEX16_EXT
      GL_COLOR_INDEX1_EXT
      GL_COLOR_INDEX2_EXT
      GL_COLOR_INDEX4_EXT
      GL_COLOR_INDEX8_EXT
      GL_COLOR_INDEXES
      GL_COLOR_LOGIC_OP
      GL_COLOR_MATERIAL
      GL_COLOR_MATERIAL_FACE
      GL_COLOR_MATERIAL_PARAMETER
      GL_COLOR_MATRIX
      GL_COLOR_MATRIX_SGI
      GL_COLOR_MATRIX_STACK_DEPTH
      GL_COLOR_MATRIX_STACK_DEPTH_SGI
      GL_COLOR_RENDERABLE
      GL_COLOR_SAMPLES_NV
      GL_COLOR_SUM
      GL_COLOR_SUM_ARB
      GL_COLOR_SUM_CLAMP_NV
      GL_COLOR_SUM_EXT
      GL_COLOR_TABLE
      GL_COLOR_TABLE_ALPHA_SIZE
      GL_COLOR_TABLE_ALPHA_SIZE_EXT
      GL_COLOR_TABLE_ALPHA_SIZE_SGI
      GL_COLOR_TABLE_BIAS
      GL_COLOR_TABLE_BIAS_SGI
      GL_COLOR_TABLE_BLUE_SIZE
      GL_COLOR_TABLE_BLUE_SIZE_EXT
      GL_COLOR_TABLE_BLUE_SIZE_SGI
      GL_COLOR_TABLE_FORMAT
      GL_COLOR_TABLE_FORMAT_EXT
      GL_COLOR_TABLE_FORMAT_SGI
      GL_COLOR_TABLE_GREEN_SIZE
      GL_COLOR_TABLE_GREEN_SIZE_EXT
      GL_COLOR_TABLE_GREEN_SIZE_SGI
      GL_COLOR_TABLE_INTENSITY_SIZE
      GL_COLOR_TABLE_INTENSITY_SIZE_EXT
      GL_COLOR_TABLE_INTENSITY_SIZE_SGI
      GL_COLOR_TABLE_LUMINANCE_SIZE
      GL_COLOR_TABLE_LUMINANCE_SIZE_EXT
      GL_COLOR_TABLE_LUMINANCE_SIZE_SGI
      GL_COLOR_TABLE_RED_SIZE
      GL_COLOR_TABLE_RED_SIZE_EXT
      GL_COLOR_TABLE_RED_SIZE_SGI
      GL_COLOR_TABLE_SCALE
      GL_COLOR_TABLE_SCALE_SGI
      GL_COLOR_TABLE_SGI
      GL_COLOR_TABLE_WIDTH
      GL_COLOR_TABLE_WIDTH_EXT
      GL_COLOR_TABLE_WIDTH_SGI
      GL_COLOR_WRITEMASK
      GL_COMBINE
      GL_COMBINE4_NV
      GL_COMBINER0_NV
      GL_COMBINER1_NV
      GL_COMBINER2_NV
      GL_COMBINER3_NV
      GL_COMBINER4_NV
      GL_COMBINER5_NV
      GL_COMBINER6_NV
      GL_COMBINER7_NV
      GL_COMBINER_AB_DOT_PRODUCT_NV
      GL_COMBINER_AB_OUTPUT_NV
      GL_COMBINER_BIAS_NV
      GL_COMBINER_CD_DOT_PRODUCT_NV
      GL_COMBINER_CD_OUTPUT_NV
      GL_COMBINER_COMPONENT_USAGE_NV
      GL_COMBINER_INPUT_NV
      GL_COMBINER_MAPPING_NV
      GL_COMBINER_MUX_SUM_NV
      GL_COMBINER_SCALE_NV
      GL_COMBINER_SUM_OUTPUT_NV
      GL_COMBINE_ALPHA
      GL_COMBINE_ALPHA_ARB
      GL_COMBINE_ALPHA_EXT
      GL_COMBINE_ARB
      GL_COMBINE_EXT
      GL_COMBINE_RGB
      GL_COMBINE_RGB_ARB
      GL_COMBINE_RGB_EXT
      GL_COMMAND_BARRIER_BIT
      GL_COMMAND_BARRIER_BIT_EXT
      GL_COMPARE_REF_DEPTH_TO_TEXTURE_EXT
      GL_COMPARE_REF_TO_TEXTURE
      GL_COMPARE_R_TO_TEXTURE
      GL_COMPARE_R_TO_TEXTURE_ARB
      GL_COMPATIBLE_SUBROUTINES
      GL_COMPILE
      GL_COMPILE_AND_EXECUTE
      GL_COMPILE_STATUS
      GL_COMPLETION_STATUS_ARB
      GL_COMPRESSED_ALPHA
      GL_COMPRESSED_ALPHA_ARB
      GL_COMPRESSED_INTENSITY
      GL_COMPRESSED_INTENSITY_ARB
      GL_COMPRESSED_LUMINANCE
      GL_COMPRESSED_LUMINANCE_ALPHA
      GL_COMPRESSED_LUMINANCE_ALPHA_3DC_ATI
      GL_COMPRESSED_LUMINANCE_ALPHA_ARB
      GL_COMPRESSED_LUMINANCE_ALPHA_LATC2_EXT
      GL_COMPRESSED_LUMINANCE_ARB
      GL_COMPRESSED_LUMINANCE_LATC1_EXT
      GL_COMPRESSED_R11_EAC
      GL_COMPRESSED_RED
      GL_COMPRESSED_RED_GREEN_RGTC2_EXT
      GL_COMPRESSED_RED_RGTC1
      GL_COMPRESSED_RED_RGTC1_EXT
      GL_COMPRESSED_RG
      GL_COMPRESSED_RG11_EAC
      GL_COMPRESSED_RGB
      GL_COMPRESSED_RGB8_ETC2
      GL_COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2
      GL_COMPRESSED_RGBA
      GL_COMPRESSED_RGBA8_ETC2_EAC
      GL_COMPRESSED_RGBA_ARB
      GL_COMPRESSED_RGBA_ASTC_10x10_KHR
      GL_COMPRESSED_RGBA_ASTC_10x5_KHR
      GL_COMPRESSED_RGBA_ASTC_10x6_KHR
      GL_COMPRESSED_RGBA_ASTC_10x8_KHR
      GL_COMPRESSED_RGBA_ASTC_12x10_KHR
      GL_COMPRESSED_RGBA_ASTC_12x12_KHR
      GL_COMPRESSED_RGBA_ASTC_4x4_KHR
      GL_COMPRESSED_RGBA_ASTC_5x4_KHR
      GL_COMPRESSED_RGBA_ASTC_5x5_KHR
      GL_COMPRESSED_RGBA_ASTC_6x5_KHR
      GL_COMPRESSED_RGBA_ASTC_6x6_KHR
      GL_COMPRESSED_RGBA_ASTC_8x5_KHR
      GL_COMPRESSED_RGBA_ASTC_8x6_KHR
      GL_COMPRESSED_RGBA_ASTC_8x8_KHR
      GL_COMPRESSED_RGBA_BPTC_UNORM
      GL_COMPRESSED_RGBA_BPTC_UNORM_ARB
      GL_COMPRESSED_RGBA_FXT1_3DFX
      GL_COMPRESSED_RGBA_S3TC_DXT1_ANGLE
      GL_COMPRESSED_RGBA_S3TC_DXT1_EXT
      GL_COMPRESSED_RGBA_S3TC_DXT3_ANGLE
      GL_COMPRESSED_RGBA_S3TC_DXT3_EXT
      GL_COMPRESSED_RGBA_S3TC_DXT5_ANGLE
      GL_COMPRESSED_RGBA_S3TC_DXT5_EXT
      GL_COMPRESSED_RGB_ARB
      GL_COMPRESSED_RGB_BPTC_SIGNED_FLOAT
      GL_COMPRESSED_RGB_BPTC_SIGNED_FLOAT_ARB
      GL_COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT
      GL_COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT_ARB
      GL_COMPRESSED_RGB_FXT1_3DFX
      GL_COMPRESSED_RGB_S3TC_DXT1_ANGLE
      GL_COMPRESSED_RGB_S3TC_DXT1_EXT
      GL_COMPRESSED_RG_RGTC2
      GL_COMPRESSED_SIGNED_LUMINANCE_ALPHA_LATC2_EXT
      GL_COMPRESSED_SIGNED_LUMINANCE_LATC1_EXT
      GL_COMPRESSED_SIGNED_R11_EAC
      GL_COMPRESSED_SIGNED_RED_GREEN_RGTC2_EXT
      GL_COMPRESSED_SIGNED_RED_RGTC1
      GL_COMPRESSED_SIGNED_RED_RGTC1_EXT
      GL_COMPRESSED_SIGNED_RG11_EAC
      GL_COMPRESSED_SIGNED_RG_RGTC2
      GL_COMPRESSED_SLUMINANCE
      GL_COMPRESSED_SLUMINANCE_ALPHA
      GL_COMPRESSED_SLUMINANCE_ALPHA_EXT
      GL_COMPRESSED_SLUMINANCE_EXT
      GL_COMPRESSED_SRGB
      GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x10_KHR
      GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x5_KHR
      GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x6_KHR
      GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x8_KHR
      GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x10_KHR
      GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x12_KHR
      GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4_KHR
      GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x4_KHR
      GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5_KHR
      GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x5_KHR
      GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6_KHR
      GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x5_KHR
      GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x6_KHR
      GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x8_KHR
      GL_COMPRESSED_SRGB8_ALPHA8_ETC2_EAC
      GL_COMPRESSED_SRGB8_ETC2
      GL_COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2
      GL_COMPRESSED_SRGB_ALPHA
      GL_COMPRESSED_SRGB_ALPHA_BPTC_UNORM
      GL_COMPRESSED_SRGB_ALPHA_BPTC_UNORM_ARB
      GL_COMPRESSED_SRGB_ALPHA_EXT
      GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT1_EXT
      GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT3_EXT
      GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT5_EXT
      GL_COMPRESSED_SRGB_EXT
      GL_COMPRESSED_SRGB_S3TC_DXT1_EXT
      GL_COMPRESSED_TEXTURE_FORMATS
      GL_COMPRESSED_TEXTURE_FORMATS_ARB
      GL_COMPUTE_PROGRAM_NV
      GL_COMPUTE_PROGRAM_PARAMETER_BUFFER_NV
      GL_COMPUTE_SHADER
      GL_COMPUTE_SHADER_BIT
      GL_COMPUTE_SHADER_INVOCATIONS_ARB
      GL_COMPUTE_SUBROUTINE
      GL_COMPUTE_SUBROUTINE_UNIFORM
      GL_COMPUTE_TEXTURE
      GL_COMPUTE_WORK_GROUP_SIZE
      GL_COMP_BIT_ATI
      GL_CONDITION_SATISFIED
      GL_CONFORMANT_NV
      GL_CONIC_CURVE_TO_NV
      GL_CONJOINT_NV
      GL_CONSERVATIVE_RASTERIZATION_INTEL
      GL_CONSERVATIVE_RASTERIZATION_NV
      GL_CONSERVATIVE_RASTER_DILATE_GRANULARITY_NV
      GL_CONSERVATIVE_RASTER_DILATE_NV
      GL_CONSERVATIVE_RASTER_DILATE_RANGE_NV
      GL_CONSERVATIVE_RASTER_MODE_NV
      GL_CONSERVATIVE_RASTER_MODE_POST_SNAP_NV
      GL_CONSERVATIVE_RASTER_MODE_PRE_SNAP_TRIANGLES_NV
      GL_CONSERVE_MEMORY_HINT_PGI
      GL_CONSTANT
      GL_CONSTANT_ALPHA
      GL_CONSTANT_ALPHA_EXT
      GL_CONSTANT_ARB
      GL_CONSTANT_ATTENUATION
      GL_CONSTANT_BORDER
      GL_CONSTANT_COLOR
      GL_CONSTANT_COLOR0_NV
      GL_CONSTANT_COLOR1_NV
      GL_CONSTANT_COLOR_EXT
      GL_CONSTANT_EXT
      GL_CONST_EYE_NV
      GL_CONTEXT_COMPATIBILITY_PROFILE_BIT
      GL_CONTEXT_CORE_PROFILE_BIT
      GL_CONTEXT_FLAGS
      GL_CONTEXT_FLAG_DEBUG_BIT
      GL_CONTEXT_FLAG_FORWARD_COMPATIBLE_BIT
      GL_CONTEXT_FLAG_NO_ERROR_BIT_KHR
      GL_CONTEXT_FLAG_ROBUST_ACCESS_BIT
      GL_CONTEXT_FLAG_ROBUST_ACCESS_BIT_ARB
      GL_CONTEXT_LOST
      GL_CONTEXT_PROFILE_MASK
      GL_CONTEXT_RELEASE_BEHAVIOR
      GL_CONTEXT_RELEASE_BEHAVIOR_FLUSH
      GL_CONTEXT_ROBUST_ACCESS
      GL_CONTINUOUS_AMD
      GL_CONTRAST_NV
      GL_CONVEX_HULL_NV
      GL_CONVOLUTION_1D
      GL_CONVOLUTION_1D_EXT
      GL_CONVOLUTION_2D
      GL_CONVOLUTION_2D_EXT
      GL_CONVOLUTION_BORDER_COLOR
      GL_CONVOLUTION_BORDER_MODE
      GL_CONVOLUTION_BORDER_MODE_EXT
      GL_CONVOLUTION_FILTER_BIAS
      GL_CONVOLUTION_FILTER_BIAS_EXT
      GL_CONVOLUTION_FILTER_SCALE
      GL_CONVOLUTION_FILTER_SCALE_EXT
      GL_CONVOLUTION_FORMAT
      GL_CONVOLUTION_FORMAT_EXT
      GL_CONVOLUTION_HEIGHT
      GL_CONVOLUTION_HEIGHT_EXT
      GL_CONVOLUTION_HINT_SGIX
      GL_CONVOLUTION_WIDTH
      GL_CONVOLUTION_WIDTH_EXT
      GL_CON_0_ATI
      GL_CON_1_ATI
      GL_CON_2_ATI
      GL_CON_3_ATI
      GL_CON_4_ATI
      GL_CON_5_ATI
      GL_CON_6_ATI
      GL_CON_7_ATI
      GL_COORD_REPLACE
      GL_COORD_REPLACE_ARB
      GL_COORD_REPLACE_NV
      GL_COPY
      GL_COPY_INVERTED
      GL_COPY_PIXEL_TOKEN
      GL_COPY_READ_BUFFER
      GL_COPY_READ_BUFFER_BINDING
      GL_COPY_WRITE_BUFFER
      GL_COPY_WRITE_BUFFER_BINDING
      GL_COUNTER_RANGE_AMD
      GL_COUNTER_TYPE_AMD
      GL_COUNT_DOWN_NV
      GL_COUNT_UP_NV
      GL_COVERAGE_MODULATION_NV
      GL_COVERAGE_MODULATION_TABLE_NV
      GL_COVERAGE_MODULATION_TABLE_SIZE_NV
      GL_CUBIC_CURVE_TO_NV
      GL_CUBIC_EXT
      GL_CULL_FACE
      GL_CULL_FACE_MODE
      GL_CULL_FRAGMENT_NV
      GL_CULL_MODES_NV
      GL_CULL_VERTEX_EXT
      GL_CULL_VERTEX_EYE_POSITION_EXT
      GL_CULL_VERTEX_IBM
      GL_CULL_VERTEX_OBJECT_POSITION_EXT
      GL_CURRENT_ATTRIB_NV
      GL_CURRENT_BINORMAL_EXT
      GL_CURRENT_BIT
      GL_CURRENT_COLOR
      GL_CURRENT_FOG_COORD
      GL_CURRENT_FOG_COORDINATE
      GL_CURRENT_FOG_COORDINATE_EXT
      GL_CURRENT_INDEX
      GL_CURRENT_MATRIX_ARB
      GL_CURRENT_MATRIX_INDEX_ARB
      GL_CURRENT_MATRIX_NV
      GL_CURRENT_MATRIX_STACK_DEPTH_ARB
      GL_CURRENT_MATRIX_STACK_DEPTH_NV
      GL_CURRENT_NORMAL
      GL_CURRENT_OCCLUSION_QUERY_ID_NV
      GL_CURRENT_PALETTE_MATRIX_ARB
      GL_CURRENT_PROGRAM
      GL_CURRENT_QUERY
      GL_CURRENT_QUERY_ANGLE
      GL_CURRENT_QUERY_ARB
      GL_CURRENT_RASTER_COLOR
      GL_CURRENT_RASTER_DISTANCE
      GL_CURRENT_RASTER_INDEX
      GL_CURRENT_RASTER_NORMAL_EXT
      GL_CURRENT_RASTER_POSITION
      GL_CURRENT_RASTER_POSITION_VALID
      GL_CURRENT_RASTER_SECONDARY_COLOR
      GL_CURRENT_RASTER_TEXTURE_COORDS
      GL_CURRENT_SAMPLE_COUNT_QUERY_NV
      GL_CURRENT_SECONDARY_COLOR
      GL_CURRENT_SECONDARY_COLOR_EXT
      GL_CURRENT_TANGENT_EXT
      GL_CURRENT_TEXTURE_COORDS
      GL_CURRENT_TIME_NV
      GL_CURRENT_VERTEX_ATTRIB
      GL_CURRENT_VERTEX_ATTRIB_ARB
      GL_CURRENT_VERTEX_EXT
      GL_CURRENT_VERTEX_WEIGHT_EXT
      GL_CURRENT_WEIGHT_ARB
      GL_CW
      GL_DARKEN_KHR
      GL_DARKEN_NV
      GL_DATA_BUFFER_AMD
      GL_DEBUG_CALLBACK_FUNCTION
      GL_DEBUG_CALLBACK_FUNCTION_ARB
      GL_DEBUG_CALLBACK_USER_PARAM
      GL_DEBUG_CALLBACK_USER_PARAM_ARB
      GL_DEBUG_CATEGORY_API_ERROR_AMD
      GL_DEBUG_CATEGORY_APPLICATION_AMD
      GL_DEBUG_CATEGORY_DEPRECATION_AMD
      GL_DEBUG_CATEGORY_OTHER_AMD
      GL_DEBUG_CATEGORY_PERFORMANCE_AMD
      GL_DEBUG_CATEGORY_SHADER_COMPILER_AMD
      GL_DEBUG_CATEGORY_UNDEFINED_BEHAVIOR_AMD
      GL_DEBUG_CATEGORY_WINDOW_SYSTEM_AMD
      GL_DEBUG_GROUP_STACK_DEPTH
      GL_DEBUG_LOGGED_MESSAGES
      GL_DEBUG_LOGGED_MESSAGES_AMD
      GL_DEBUG_LOGGED_MESSAGES_ARB
      GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH
      GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH_ARB
      GL_DEBUG_OUTPUT
      GL_DEBUG_OUTPUT_SYNCHRONOUS
      GL_DEBUG_OUTPUT_SYNCHRONOUS_ARB
      GL_DEBUG_REGAL
      GL_DEBUG_SEVERITY_HIGH
      GL_DEBUG_SEVERITY_HIGH_AMD
      GL_DEBUG_SEVERITY_HIGH_ARB
      GL_DEBUG_SEVERITY_LOW
      GL_DEBUG_SEVERITY_LOW_AMD
      GL_DEBUG_SEVERITY_LOW_ARB
      GL_DEBUG_SEVERITY_MEDIUM
      GL_DEBUG_SEVERITY_MEDIUM_AMD
      GL_DEBUG_SEVERITY_MEDIUM_ARB
      GL_DEBUG_SEVERITY_NOTIFICATION
      GL_DEBUG_SOURCE_API
      GL_DEBUG_SOURCE_API_ARB
      GL_DEBUG_SOURCE_APPLICATION
      GL_DEBUG_SOURCE_APPLICATION_ARB
      GL_DEBUG_SOURCE_OTHER
      GL_DEBUG_SOURCE_OTHER_ARB
      GL_DEBUG_SOURCE_SHADER_COMPILER
      GL_DEBUG_SOURCE_SHADER_COMPILER_ARB
      GL_DEBUG_SOURCE_THIRD_PARTY
      GL_DEBUG_SOURCE_THIRD_PARTY_ARB
      GL_DEBUG_SOURCE_WINDOW_SYSTEM
      GL_DEBUG_SOURCE_WINDOW_SYSTEM_ARB
      GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR
      GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR_ARB
      GL_DEBUG_TYPE_ERROR
      GL_DEBUG_TYPE_ERROR_ARB
      GL_DEBUG_TYPE_MARKER
      GL_DEBUG_TYPE_OTHER
      GL_DEBUG_TYPE_OTHER_ARB
      GL_DEBUG_TYPE_PERFORMANCE
      GL_DEBUG_TYPE_PERFORMANCE_ARB
      GL_DEBUG_TYPE_POP_GROUP
      GL_DEBUG_TYPE_PORTABILITY
      GL_DEBUG_TYPE_PORTABILITY_ARB
      GL_DEBUG_TYPE_PUSH_GROUP
      GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR
      GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR_ARB
      GL_DECAL
      GL_DECODE_EXT
      GL_DECR
      GL_DECR_WRAP
      GL_DECR_WRAP_EXT
      GL_DELETE_STATUS
      GL_DEPENDENT_AR_TEXTURE_2D_NV
      GL_DEPENDENT_GB_TEXTURE_2D_NV
      GL_DEPENDENT_HILO_TEXTURE_2D_NV
      GL_DEPENDENT_RGB_TEXTURE_3D_NV
      GL_DEPENDENT_RGB_TEXTURE_CUBE_MAP_NV
      GL_DEPTH
      GL_DEPTH24_STENCIL8
      GL_DEPTH24_STENCIL8_EXT
      GL_DEPTH32F_STENCIL8
      GL_DEPTH32F_STENCIL8_NV
      GL_DEPTH_ATTACHMENT
      GL_DEPTH_ATTACHMENT_EXT
      GL_DEPTH_BIAS
      GL_DEPTH_BITS
      GL_DEPTH_BOUNDS_EXT
      GL_DEPTH_BOUNDS_TEST_EXT
      GL_DEPTH_BUFFER
      GL_DEPTH_BUFFER_BIT
      GL_DEPTH_BUFFER_FLOAT_MODE_NV
      GL_DEPTH_CLAMP
      GL_DEPTH_CLAMP_FAR_AMD
      GL_DEPTH_CLAMP_NEAR_AMD
      GL_DEPTH_CLAMP_NV
      GL_DEPTH_CLEAR_VALUE
      GL_DEPTH_COMPONENT
      GL_DEPTH_COMPONENT16
      GL_DEPTH_COMPONENT16_ARB
      GL_DEPTH_COMPONENT16_SGIX
      GL_DEPTH_COMPONENT24
      GL_DEPTH_COMPONENT24_ARB
      GL_DEPTH_COMPONENT24_SGIX
      GL_DEPTH_COMPONENT32
      GL_DEPTH_COMPONENT32F
      GL_DEPTH_COMPONENT32F_NV
      GL_DEPTH_COMPONENT32_ARB
      GL_DEPTH_COMPONENT32_SGIX
      GL_DEPTH_COMPONENTS
      GL_DEPTH_FUNC
      GL_DEPTH_RANGE
      GL_DEPTH_RENDERABLE
      GL_DEPTH_SAMPLES_NV
      GL_DEPTH_SCALE
      GL_DEPTH_STENCIL
      GL_DEPTH_STENCIL_ATTACHMENT
      GL_DEPTH_STENCIL_EXT
      GL_DEPTH_STENCIL_NV
      GL_DEPTH_STENCIL_TEXTURE_MODE
      GL_DEPTH_STENCIL_TO_BGRA_NV
      GL_DEPTH_STENCIL_TO_RGBA_NV
      GL_DEPTH_TEST
      GL_DEPTH_TEXTURE_MODE
      GL_DEPTH_TEXTURE_MODE_ARB
      GL_DEPTH_WRITEMASK
      GL_DIFFERENCE_KHR
      GL_DIFFERENCE_NV
      GL_DIFFUSE
      GL_DISCARD_ATI
      GL_DISCARD_NV
      GL_DISCRETE_AMD
      GL_DISJOINT_NV
      GL_DISPATCH_INDIRECT_BUFFER
      GL_DISPATCH_INDIRECT_BUFFER_BINDING
      GL_DISPLAY_LIST
      GL_DISTANCE_ATTENUATION_EXT
      GL_DITHER
      GL_DOMAIN
      GL_DONT_CARE
      GL_DOT2_ADD_ATI
      GL_DOT3_ATI
      GL_DOT3_RGB
      GL_DOT3_RGBA
      GL_DOT3_RGBA_ARB
      GL_DOT3_RGBA_EXT
      GL_DOT3_RGB_ARB
      GL_DOT3_RGB_EXT
      GL_DOT4_ATI
      GL_DOT_PRODUCT_AFFINE_DEPTH_REPLACE_NV
      GL_DOT_PRODUCT_CONST_EYE_REFLECT_CUBE_MAP_NV
      GL_DOT_PRODUCT_DEPTH_REPLACE_NV
      GL_DOT_PRODUCT_DIFFUSE_CUBE_MAP_NV
      GL_DOT_PRODUCT_NV
      GL_DOT_PRODUCT_PASS_THROUGH_NV
      GL_DOT_PRODUCT_REFLECT_CUBE_MAP_NV
      GL_DOT_PRODUCT_TEXTURE_1D_NV
      GL_DOT_PRODUCT_TEXTURE_2D_NV
      GL_DOT_PRODUCT_TEXTURE_3D_NV
      GL_DOT_PRODUCT_TEXTURE_CUBE_MAP_NV
      GL_DOT_PRODUCT_TEXTURE_RECTANGLE_NV
      GL_DOUBLE
      GL_DOUBLEBUFFER
      GL_DOUBLE_EXT
      GL_DOUBLE_MAT2
      GL_DOUBLE_MAT2_EXT
      GL_DOUBLE_MAT2x3
      GL_DOUBLE_MAT2x3_EXT
      GL_DOUBLE_MAT2x4
      GL_DOUBLE_MAT2x4_EXT
      GL_DOUBLE_MAT3
      GL_DOUBLE_MAT3_EXT
      GL_DOUBLE_MAT3x2
      GL_DOUBLE_MAT3x2_EXT
      GL_DOUBLE_MAT3x4
      GL_DOUBLE_MAT3x4_EXT
      GL_DOUBLE_MAT4
      GL_DOUBLE_MAT4_EXT
      GL_DOUBLE_MAT4x2
      GL_DOUBLE_MAT4x2_EXT
      GL_DOUBLE_MAT4x3
      GL_DOUBLE_MAT4x3_EXT
      GL_DOUBLE_VEC2
      GL_DOUBLE_VEC2_EXT
      GL_DOUBLE_VEC3
      GL_DOUBLE_VEC3_EXT
      GL_DOUBLE_VEC4
      GL_DOUBLE_VEC4_EXT
      GL_DRAW_ARRAYS_COMMAND_NV
      GL_DRAW_ARRAYS_INSTANCED_COMMAND_NV
      GL_DRAW_ARRAYS_STRIP_COMMAND_NV
      GL_DRAW_BUFFER
      GL_DRAW_BUFFER0
      GL_DRAW_BUFFER0_ARB
      GL_DRAW_BUFFER0_ATI
      GL_DRAW_BUFFER1
      GL_DRAW_BUFFER10
      GL_DRAW_BUFFER10_ARB
      GL_DRAW_BUFFER10_ATI
      GL_DRAW_BUFFER11
      GL_DRAW_BUFFER11_ARB
      GL_DRAW_BUFFER11_ATI
      GL_DRAW_BUFFER12
      GL_DRAW_BUFFER12_ARB
      GL_DRAW_BUFFER12_ATI
      GL_DRAW_BUFFER13
      GL_DRAW_BUFFER13_ARB
      GL_DRAW_BUFFER13_ATI
      GL_DRAW_BUFFER14
      GL_DRAW_BUFFER14_ARB
      GL_DRAW_BUFFER14_ATI
      GL_DRAW_BUFFER15
      GL_DRAW_BUFFER15_ARB
      GL_DRAW_BUFFER15_ATI
      GL_DRAW_BUFFER1_ARB
      GL_DRAW_BUFFER1_ATI
      GL_DRAW_BUFFER2
      GL_DRAW_BUFFER2_ARB
      GL_DRAW_BUFFER2_ATI
      GL_DRAW_BUFFER3
      GL_DRAW_BUFFER3_ARB
      GL_DRAW_BUFFER3_ATI
      GL_DRAW_BUFFER4
      GL_DRAW_BUFFER4_ARB
      GL_DRAW_BUFFER4_ATI
      GL_DRAW_BUFFER5
      GL_DRAW_BUFFER5_ARB
      GL_DRAW_BUFFER5_ATI
      GL_DRAW_BUFFER6
      GL_DRAW_BUFFER6_ARB
      GL_DRAW_BUFFER6_ATI
      GL_DRAW_BUFFER7
      GL_DRAW_BUFFER7_ARB
      GL_DRAW_BUFFER7_ATI
      GL_DRAW_BUFFER8
      GL_DRAW_BUFFER8_ARB
      GL_DRAW_BUFFER8_ATI
      GL_DRAW_BUFFER9
      GL_DRAW_BUFFER9_ARB
      GL_DRAW_BUFFER9_ATI
      GL_DRAW_ELEMENTS_COMMAND_NV
      GL_DRAW_ELEMENTS_INSTANCED_COMMAND_NV
      GL_DRAW_ELEMENTS_STRIP_COMMAND_NV
      GL_DRAW_FRAMEBUFFER
      GL_DRAW_FRAMEBUFFER_ANGLE
      GL_DRAW_FRAMEBUFFER_BINDING
      GL_DRAW_FRAMEBUFFER_BINDING_ANGLE
      GL_DRAW_FRAMEBUFFER_BINDING_EXT
      GL_DRAW_FRAMEBUFFER_EXT
      GL_DRAW_INDIRECT_ADDRESS_NV
      GL_DRAW_INDIRECT_BUFFER
      GL_DRAW_INDIRECT_BUFFER_BINDING
      GL_DRAW_INDIRECT_LENGTH_NV
      GL_DRAW_INDIRECT_UNIFIED_NV
      GL_DRAW_PIXELS_APPLE
      GL_DRAW_PIXEL_TOKEN
      GL_DRIVER_REGAL
      GL_DSDT8_MAG8_INTENSITY8_NV
      GL_DSDT8_MAG8_NV
      GL_DSDT8_NV
      GL_DSDT_MAG_INTENSITY_NV
      GL_DSDT_MAG_NV
      GL_DSDT_MAG_VIB_NV
      GL_DSDT_NV
      GL_DST_ALPHA
      GL_DST_ATOP_NV
      GL_DST_COLOR
      GL_DST_IN_NV
      GL_DST_NV
      GL_DST_OUT_NV
      GL_DST_OVER_NV
      GL_DS_BIAS_NV
      GL_DS_SCALE_NV
      GL_DT_BIAS_NV
      GL_DT_SCALE_NV
      GL_DU8DV8_ATI
      GL_DUDV_ATI
      GL_DUP_FIRST_CUBIC_CURVE_TO_NV
      GL_DUP_LAST_CUBIC_CURVE_TO_NV
      GL_DYNAMIC_ATI
      GL_DYNAMIC_COPY
      GL_DYNAMIC_COPY_ARB
      GL_DYNAMIC_DRAW
      GL_DYNAMIC_DRAW_ARB
      GL_DYNAMIC_READ
      GL_DYNAMIC_READ_ARB
      GL_DYNAMIC_STORAGE_BIT
      GL_EDGEFLAG_BIT_PGI
      GL_EDGE_FLAG
      GL_EDGE_FLAG_ARRAY
      GL_EDGE_FLAG_ARRAY_ADDRESS_NV
      GL_EDGE_FLAG_ARRAY_BUFFER_BINDING
      GL_EDGE_FLAG_ARRAY_BUFFER_BINDING_ARB
      GL_EDGE_FLAG_ARRAY_COUNT_EXT
      GL_EDGE_FLAG_ARRAY_EXT
      GL_EDGE_FLAG_ARRAY_LENGTH_NV
      GL_EDGE_FLAG_ARRAY_LIST_IBM
      GL_EDGE_FLAG_ARRAY_LIST_STRIDE_IBM
      GL_EDGE_FLAG_ARRAY_POINTER
      GL_EDGE_FLAG_ARRAY_POINTER_EXT
      GL_EDGE_FLAG_ARRAY_STRIDE
      GL_EDGE_FLAG_ARRAY_STRIDE_EXT
      GL_EFFECTIVE_RASTER_SAMPLES_EXT
      GL_EGL_GENERATE_RESET_ON_VIDEO_MEMORY_PURGE_NV
      GL_EGL_NV_robustness_video_memory_purge
      GL_EIGHTH_BIT_ATI
      GL_ELEMENT_ADDRESS_COMMAND_NV
      GL_ELEMENT_ARRAY_ADDRESS_NV
      GL_ELEMENT_ARRAY_APPLE
      GL_ELEMENT_ARRAY_ATI
      GL_ELEMENT_ARRAY_BARRIER_BIT
      GL_ELEMENT_ARRAY_BARRIER_BIT_EXT
      GL_ELEMENT_ARRAY_BUFFER
      GL_ELEMENT_ARRAY_BUFFER_ARB
      GL_ELEMENT_ARRAY_BUFFER_BINDING
      GL_ELEMENT_ARRAY_BUFFER_BINDING_ARB
      GL_ELEMENT_ARRAY_LENGTH_NV
      GL_ELEMENT_ARRAY_POINTER_APPLE
      GL_ELEMENT_ARRAY_POINTER_ATI
      GL_ELEMENT_ARRAY_TYPE_APPLE
      GL_ELEMENT_ARRAY_TYPE_ATI
      GL_ELEMENT_ARRAY_UNIFIED_NV
      GL_EMBOSS_CONSTANT_NV
      GL_EMBOSS_LIGHT_NV
      GL_EMBOSS_MAP_NV
      GL_EMISSION
      GL_EMULATION_REGAL
      GL_ENABLE_BIT
      GL_EQUAL
      GL_EQUIV
      GL_ERROR_REGAL
      GL_EVAL_2D_NV
      GL_EVAL_BIT
      GL_EVAL_FRACTIONAL_TESSELLATION_NV
      GL_EVAL_TRIANGULAR_2D_NV
      GL_EVAL_VERTEX_ATTRIB0_NV
      GL_EVAL_VERTEX_ATTRIB10_NV
      GL_EVAL_VERTEX_ATTRIB11_NV
      GL_EVAL_VERTEX_ATTRIB12_NV
      GL_EVAL_VERTEX_ATTRIB13_NV
      GL_EVAL_VERTEX_ATTRIB14_NV
      GL_EVAL_VERTEX_ATTRIB15_NV
      GL_EVAL_VERTEX_ATTRIB1_NV
      GL_EVAL_VERTEX_ATTRIB2_NV
      GL_EVAL_VERTEX_ATTRIB3_NV
      GL_EVAL_VERTEX_ATTRIB4_NV
      GL_EVAL_VERTEX_ATTRIB5_NV
      GL_EVAL_VERTEX_ATTRIB6_NV
      GL_EVAL_VERTEX_ATTRIB7_NV
      GL_EVAL_VERTEX_ATTRIB8_NV
      GL_EVAL_VERTEX_ATTRIB9_NV
      GL_EXCLUSION_KHR
      GL_EXCLUSION_NV
      GL_EXCLUSIVE_EXT
      GL_EXP
      GL_EXP2
      GL_EXPAND_NEGATE_NV
      GL_EXPAND_NORMAL_NV
      GL_EXTENDED_RANGE_SGIS
      GL_EXTENSIONS
      GL_EXTERNAL_VIRTUAL_MEMORY_BUFFER_AMD
      GL_EXT_422_pixels
      GL_EXT_Cg_shader
      GL_EXT_abgr
      GL_EXT_bgra
      GL_EXT_bindable_uniform
      GL_EXT_blend_color
      GL_EXT_blend_equation_separate
      GL_EXT_blend_func_separate
      GL_EXT_blend_logic_op
      GL_EXT_blend_minmax
      GL_EXT_blend_subtract
      GL_EXT_clip_volume_hint
      GL_EXT_cmyka
      GL_EXT_color_subtable
      GL_EXT_compiled_vertex_array
      GL_EXT_convolution
      GL_EXT_coordinate_frame
      GL_EXT_copy_texture
      GL_EXT_cull_vertex
      GL_EXT_debug_label
      GL_EXT_debug_marker
      GL_EXT_depth_bounds_test
      GL_EXT_direct_state_access
      GL_EXT_draw_buffers2
      GL_EXT_draw_instanced
      GL_EXT_draw_range_elements
      GL_EXT_fog_coord
      GL_EXT_fragment_lighting
      GL_EXT_framebuffer_blit
      GL_EXT_framebuffer_multisample
      GL_EXT_framebuffer_multisample_blit_scaled
      GL_EXT_framebuffer_object
      GL_EXT_framebuffer_sRGB
      GL_EXT_geometry_shader4
      GL_EXT_gpu_program_parameters
      GL_EXT_gpu_shader4
      GL_EXT_histogram
      GL_EXT_index_array_formats
      GL_EXT_index_func
      GL_EXT_index_material
      GL_EXT_index_texture
      GL_EXT_light_texture
      GL_EXT_misc_attribute
      GL_EXT_multi_draw_arrays
      GL_EXT_multisample
      GL_EXT_packed_depth_stencil
      GL_EXT_packed_float
      GL_EXT_packed_pixels
      GL_EXT_paletted_texture
      GL_EXT_pixel_buffer_object
      GL_EXT_pixel_transform
      GL_EXT_pixel_transform_color_table
      GL_EXT_point_parameters
      GL_EXT_polygon_offset
      GL_EXT_polygon_offset_clamp
      GL_EXT_post_depth_coverage
      GL_EXT_provoking_vertex
      GL_EXT_raster_multisample
      GL_EXT_rescale_normal
      GL_EXT_scene_marker
      GL_EXT_secondary_color
      GL_EXT_separate_shader_objects
      GL_EXT_separate_specular_color
      GL_EXT_shader_image_load_formatted
      GL_EXT_shader_image_load_store
      GL_EXT_shader_integer_mix
      GL_EXT_shadow_funcs
      GL_EXT_shared_texture_palette
      GL_EXT_sparse_texture2
      GL_EXT_stencil_clear_tag
      GL_EXT_stencil_two_side
      GL_EXT_stencil_wrap
      GL_EXT_subtexture
      GL_EXT_texture
      GL_EXT_texture3D
      GL_EXT_texture_array
      GL_EXT_texture_buffer_object
      GL_EXT_texture_compression_dxt1
      GL_EXT_texture_compression_latc
      GL_EXT_texture_compression_rgtc
      GL_EXT_texture_compression_s3tc
      GL_EXT_texture_cube_map
      GL_EXT_texture_edge_clamp
      GL_EXT_texture_env
      GL_EXT_texture_env_add
      GL_EXT_texture_env_combine
      GL_EXT_texture_env_dot3
      GL_EXT_texture_filter_anisotropic
      GL_EXT_texture_filter_minmax
      GL_EXT_texture_integer
      GL_EXT_texture_lod_bias
      GL_EXT_texture_mirror_clamp
      GL_EXT_texture_object
      GL_EXT_texture_perturb_normal
      GL_EXT_texture_rectangle
      GL_EXT_texture_sRGB
      GL_EXT_texture_sRGB_decode
      GL_EXT_texture_shared_exponent
      GL_EXT_texture_snorm
      GL_EXT_texture_swizzle
      GL_EXT_timer_query
      GL_EXT_transform_feedback
      GL_EXT_vertex_array
      GL_EXT_vertex_array_bgra
      GL_EXT_vertex_attrib_64bit
      GL_EXT_vertex_shader
      GL_EXT_vertex_weighting
      GL_EXT_window_rectangles
      GL_EXT_x11_sync_object
      GL_EYE_DISTANCE_TO_LINE_SGIS
      GL_EYE_DISTANCE_TO_POINT_SGIS
      GL_EYE_LINEAR
      GL_EYE_LINE_SGIS
      GL_EYE_PLANE
      GL_EYE_PLANE_ABSOLUTE_NV
      GL_EYE_POINT_SGIS
      GL_EYE_RADIAL_NV
      GL_E_TIMES_F_NV
      GL_FACTOR_MAX_AMD
      GL_FACTOR_MIN_AMD
      GL_FAILURE_NV
      GL_FALSE
      GL_FASTEST
      GL_FEEDBACK
      GL_FEEDBACK_BUFFER_POINTER
      GL_FEEDBACK_BUFFER_SIZE
      GL_FEEDBACK_BUFFER_TYPE
      GL_FENCE_APPLE
      GL_FENCE_CONDITION_NV
      GL_FENCE_STATUS_NV
      GL_FIELDS_NV
      GL_FIELD_LOWER_NV
      GL_FIELD_UPPER_NV
      GL_FILE_NAME_NV
      GL_FILL
      GL_FILL_RECTANGLE_NV
      GL_FILTER
      GL_FIRST_TO_REST_NV
      GL_FIRST_VERTEX_CONVENTION
      GL_FIRST_VERTEX_CONVENTION_EXT
      GL_FIXED
      GL_FIXED_ONLY
      GL_FIXED_ONLY_ARB
      GL_FLAT
      GL_FLOAT
      GL_FLOAT16_NV
      GL_FLOAT16_VEC2_NV
      GL_FLOAT16_VEC3_NV
      GL_FLOAT16_VEC4_NV
      GL_FLOAT_32_UNSIGNED_INT_24_8_REV
      GL_FLOAT_32_UNSIGNED_INT_24_8_REV_NV
      GL_FLOAT_CLEAR_COLOR_VALUE_NV
      GL_FLOAT_MAT2
      GL_FLOAT_MAT2_ARB
      GL_FLOAT_MAT2x3
      GL_FLOAT_MAT2x4
      GL_FLOAT_MAT3
      GL_FLOAT_MAT3_ARB
      GL_FLOAT_MAT3x2
      GL_FLOAT_MAT3x4
      GL_FLOAT_MAT4
      GL_FLOAT_MAT4_ARB
      GL_FLOAT_MAT4x2
      GL_FLOAT_MAT4x3
      GL_FLOAT_R16_NV
      GL_FLOAT_R32_NV
      GL_FLOAT_RG16_NV
      GL_FLOAT_RG32_NV
      GL_FLOAT_RGB16_NV
      GL_FLOAT_RGB32_NV
      GL_FLOAT_RGBA16_NV
      GL_FLOAT_RGBA32_NV
      GL_FLOAT_RGBA_MODE_NV
      GL_FLOAT_RGBA_NV
      GL_FLOAT_RGB_NV
      GL_FLOAT_RG_NV
      GL_FLOAT_R_NV
      GL_FLOAT_VEC2
      GL_FLOAT_VEC2_ARB
      GL_FLOAT_VEC3
      GL_FLOAT_VEC3_ARB
      GL_FLOAT_VEC4
      GL_FLOAT_VEC4_ARB
      GL_FOG
      GL_FOG_BIT
      GL_FOG_COLOR
      GL_FOG_COORD
      GL_FOG_COORDINATE
      GL_FOG_COORDINATE_ARRAY
      GL_FOG_COORDINATE_ARRAY_BUFFER_BINDING
      GL_FOG_COORDINATE_ARRAY_BUFFER_BINDING_ARB
      GL_FOG_COORDINATE_ARRAY_EXT
      GL_FOG_COORDINATE_ARRAY_LIST_IBM
      GL_FOG_COORDINATE_ARRAY_LIST_STRIDE_IBM
      GL_FOG_COORDINATE_ARRAY_POINTER
      GL_FOG_COORDINATE_ARRAY_POINTER_EXT
      GL_FOG_COORDINATE_ARRAY_STRIDE
      GL_FOG_COORDINATE_ARRAY_STRIDE_EXT
      GL_FOG_COORDINATE_ARRAY_TYPE
      GL_FOG_COORDINATE_ARRAY_TYPE_EXT
      GL_FOG_COORDINATE_EXT
      GL_FOG_COORDINATE_SOURCE
      GL_FOG_COORDINATE_SOURCE_EXT
      GL_FOG_COORD_ARRAY
      GL_FOG_COORD_ARRAY_ADDRESS_NV
      GL_FOG_COORD_ARRAY_BUFFER_BINDING
      GL_FOG_COORD_ARRAY_LENGTH_NV
      GL_FOG_COORD_ARRAY_POINTER
      GL_FOG_COORD_ARRAY_STRIDE
      GL_FOG_COORD_ARRAY_TYPE
      GL_FOG_COORD_SRC
      GL_FOG_DENSITY
      GL_FOG_DISTANCE_MODE_NV
      GL_FOG_END
      GL_FOG_HINT
      GL_FOG_INDEX
      GL_FOG_MODE
      GL_FOG_OFFSET_SGIX
      GL_FOG_OFFSET_VALUE_SGIX
      GL_FOG_SPECULAR_TEXTURE_WIN
      GL_FOG_START
      GL_FONT_ASCENDER_BIT_NV
      GL_FONT_DESCENDER_BIT_NV
      GL_FONT_GLYPHS_AVAILABLE_NV
      GL_FONT_HAS_KERNING_BIT_NV
      GL_FONT_HEIGHT_BIT_NV
      GL_FONT_MAX_ADVANCE_HEIGHT_BIT_NV
      GL_FONT_MAX_ADVANCE_WIDTH_BIT_NV
      GL_FONT_NUM_GLYPH_INDICES_BIT_NV
      GL_FONT_TARGET_UNAVAILABLE_NV
      GL_FONT_UNAVAILABLE_NV
      GL_FONT_UNDERLINE_POSITION_BIT_NV
      GL_FONT_UNDERLINE_THICKNESS_BIT_NV
      GL_FONT_UNINTELLIGIBLE_NV
      GL_FONT_UNITS_PER_EM_BIT_NV
      GL_FONT_X_MAX_BOUNDS_BIT_NV
      GL_FONT_X_MIN_BOUNDS_BIT_NV
      GL_FONT_Y_MAX_BOUNDS_BIT_NV
      GL_FONT_Y_MIN_BOUNDS_BIT_NV
      GL_FORCE_BLUE_TO_ONE_NV
      GL_FORMAT_SUBSAMPLE_244_244_OML
      GL_FORMAT_SUBSAMPLE_24_24_OML
      GL_FRACTIONAL_EVEN
      GL_FRACTIONAL_ODD
      GL_FRAGMENT_COLOR_EXT
      GL_FRAGMENT_COLOR_MATERIAL_EXT
      GL_FRAGMENT_COLOR_MATERIAL_FACE_EXT
      GL_FRAGMENT_COLOR_MATERIAL_PARAMETER_EXT
      GL_FRAGMENT_COVERAGE_COLOR_NV
      GL_FRAGMENT_COVERAGE_TO_COLOR_NV
      GL_FRAGMENT_DEPTH
      GL_FRAGMENT_DEPTH_EXT
      GL_FRAGMENT_INPUT_NV
      GL_FRAGMENT_INTERPOLATION_OFFSET_BITS
      GL_FRAGMENT_LIGHT0_EXT
      GL_FRAGMENT_LIGHT7_EXT
      GL_FRAGMENT_LIGHTING_EXT
      GL_FRAGMENT_LIGHT_MODEL_AMBIENT_EXT
      GL_FRAGMENT_LIGHT_MODEL_LOCAL_VIEWER_EXT
      GL_FRAGMENT_LIGHT_MODEL_NORMAL_INTERPOLATION_EXT
      GL_FRAGMENT_LIGHT_MODEL_TWO_SIDE_EXT
      GL_FRAGMENT_MATERIAL_EXT
      GL_FRAGMENT_NORMAL_EXT
      GL_FRAGMENT_PROGRAM_ARB
      GL_FRAGMENT_PROGRAM_BINDING_NV
      GL_FRAGMENT_PROGRAM_INTERPOLATION_OFFSET_BITS_NV
      GL_FRAGMENT_PROGRAM_NV
      GL_FRAGMENT_PROGRAM_PARAMETER_BUFFER_NV
      GL_FRAGMENT_SHADER
      GL_FRAGMENT_SHADER_ARB
      GL_FRAGMENT_SHADER_ATI
      GL_FRAGMENT_SHADER_BIT
      GL_FRAGMENT_SHADER_DERIVATIVE_HINT
      GL_FRAGMENT_SHADER_DERIVATIVE_HINT_ARB
      GL_FRAGMENT_SHADER_INVOCATIONS_ARB
      GL_FRAGMENT_SUBROUTINE
      GL_FRAGMENT_SUBROUTINE_UNIFORM
      GL_FRAGMENT_TEXTURE
      GL_FRAMEBUFFER
      GL_FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE
      GL_FRAMEBUFFER_ATTACHMENT_ANGLE
      GL_FRAMEBUFFER_ATTACHMENT_BLUE_SIZE
      GL_FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING
      GL_FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE
      GL_FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE
      GL_FRAMEBUFFER_ATTACHMENT_GREEN_SIZE
      GL_FRAMEBUFFER_ATTACHMENT_LAYERED
      GL_FRAMEBUFFER_ATTACHMENT_LAYERED_ARB
      GL_FRAMEBUFFER_ATTACHMENT_LAYERED_EXT
      GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME
      GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME_EXT
      GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE
      GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE_EXT
      GL_FRAMEBUFFER_ATTACHMENT_RED_SIZE
      GL_FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE
      GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_3D_ZOFFSET_EXT
      GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_BASE_VIEW_INDEX_OVR
      GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE
      GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE_EXT
      GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER
      GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER_EXT
      GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL
      GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL_EXT
      GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_NUM_VIEWS_OVR
      GL_FRAMEBUFFER_BARRIER_BIT
      GL_FRAMEBUFFER_BARRIER_BIT_EXT
      GL_FRAMEBUFFER_BINDING
      GL_FRAMEBUFFER_BINDING_EXT
      GL_FRAMEBUFFER_BLEND
      GL_FRAMEBUFFER_COMPLETE
      GL_FRAMEBUFFER_COMPLETE_EXT
      GL_FRAMEBUFFER_DEFAULT
      GL_FRAMEBUFFER_DEFAULT_FIXED_SAMPLE_LOCATIONS
      GL_FRAMEBUFFER_DEFAULT_HEIGHT
      GL_FRAMEBUFFER_DEFAULT_LAYERS
      GL_FRAMEBUFFER_DEFAULT_SAMPLES
      GL_FRAMEBUFFER_DEFAULT_WIDTH
      GL_FRAMEBUFFER_EXT
      GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT
      GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT_EXT
      GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS_EXT
      GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER
      GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER_EXT
      GL_FRAMEBUFFER_INCOMPLETE_FORMATS_EXT
      GL_FRAMEBUFFER_INCOMPLETE_LAYER_COUNT_ARB
      GL_FRAMEBUFFER_INCOMPLETE_LAYER_COUNT_EXT
      GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS
      GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS_ARB
      GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS_EXT
      GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT
      GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT_EXT
      GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE
      GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE_ANGLE
      GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE_EXT
      GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER
      GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER_EXT
      GL_FRAMEBUFFER_INCOMPLETE_VIEW_TARGETS_OVR
      GL_FRAMEBUFFER_PROGRAMMABLE_SAMPLE_LOCATIONS_ARB
      GL_FRAMEBUFFER_PROGRAMMABLE_SAMPLE_LOCATIONS_NV
      GL_FRAMEBUFFER_RENDERABLE
      GL_FRAMEBUFFER_RENDERABLE_LAYERED
      GL_FRAMEBUFFER_SAMPLE_LOCATION_PIXEL_GRID_ARB
      GL_FRAMEBUFFER_SAMPLE_LOCATION_PIXEL_GRID_NV
      GL_FRAMEBUFFER_SRGB
      GL_FRAMEBUFFER_SRGB_CAPABLE_EXT
      GL_FRAMEBUFFER_SRGB_EXT
      GL_FRAMEBUFFER_UNDEFINED
      GL_FRAMEBUFFER_UNSUPPORTED
      GL_FRAMEBUFFER_UNSUPPORTED_EXT
      GL_FRAME_NV
      GL_FRONT
      GL_FRONT_AND_BACK
      GL_FRONT_FACE
      GL_FRONT_FACE_COMMAND_NV
      GL_FRONT_LEFT
      GL_FRONT_RIGHT
      GL_FULL_RANGE_EXT
      GL_FULL_STIPPLE_HINT_PGI
      GL_FULL_SUPPORT
      GL_FUNC_ADD
      GL_FUNC_ADD_EXT
      GL_FUNC_REVERSE_SUBTRACT
      GL_FUNC_REVERSE_SUBTRACT_EXT
      GL_FUNC_SUBTRACT
      GL_FUNC_SUBTRACT_EXT
      GL_GENERATE_MIPMAP
      GL_GENERATE_MIPMAP_HINT
      GL_GENERATE_MIPMAP_HINT_SGIS
      GL_GENERATE_MIPMAP_SGIS
      GL_GENERIC_ATTRIB_NV
      GL_GEOMETRY_INPUT_TYPE
      GL_GEOMETRY_INPUT_TYPE_ARB
      GL_GEOMETRY_INPUT_TYPE_EXT
      GL_GEOMETRY_OUTPUT_TYPE
      GL_GEOMETRY_OUTPUT_TYPE_ARB
      GL_GEOMETRY_OUTPUT_TYPE_EXT
      GL_GEOMETRY_PROGRAM_NV
      GL_GEOMETRY_PROGRAM_PARAMETER_BUFFER_NV
      GL_GEOMETRY_SHADER
      GL_GEOMETRY_SHADER_ARB
      GL_GEOMETRY_SHADER_BIT
      GL_GEOMETRY_SHADER_EXT
      GL_GEOMETRY_SHADER_INVOCATIONS
      GL_GEOMETRY_SHADER_PRIMITIVES_EMITTED_ARB
      GL_GEOMETRY_SUBROUTINE
      GL_GEOMETRY_SUBROUTINE_UNIFORM
      GL_GEOMETRY_TEXTURE
      GL_GEOMETRY_VERTICES_OUT
      GL_GEOMETRY_VERTICES_OUT_ARB
      GL_GEOMETRY_VERTICES_OUT_EXT
      GL_GEQUAL
      GL_GET_TEXTURE_IMAGE_FORMAT
      GL_GET_TEXTURE_IMAGE_TYPE
      GL_GLOBAL_ALPHA_FACTOR_SUN
      GL_GLOBAL_ALPHA_SUN
      GL_GLYPH_HAS_KERNING_BIT_NV
      GL_GLYPH_HEIGHT_BIT_NV
      GL_GLYPH_HORIZONTAL_BEARING_ADVANCE_BIT_NV
      GL_GLYPH_HORIZONTAL_BEARING_X_BIT_NV
      GL_GLYPH_HORIZONTAL_BEARING_Y_BIT_NV
      GL_GLYPH_VERTICAL_BEARING_ADVANCE_BIT_NV
      GL_GLYPH_VERTICAL_BEARING_X_BIT_NV
      GL_GLYPH_VERTICAL_BEARING_Y_BIT_NV
      GL_GLYPH_WIDTH_BIT_NV
      GL_GPU_ADDRESS_NV
      GL_GPU_MEMORY_INFO_CURRENT_AVAILABLE_VIDMEM_NVX
      GL_GPU_MEMORY_INFO_DEDICATED_VIDMEM_NVX
      GL_GPU_MEMORY_INFO_EVICTED_MEMORY_NVX
      GL_GPU_MEMORY_INFO_EVICTION_COUNT_NVX
      GL_GPU_MEMORY_INFO_TOTAL_AVAILABLE_MEMORY_NVX
      GL_GREATER
      GL_GREEN
      GL_GREEN_BIAS
      GL_GREEN_BITS
      GL_GREEN_BIT_ATI
      GL_GREEN_INTEGER
      GL_GREEN_INTEGER_EXT
      GL_GREEN_MAX_CLAMP_INGR
      GL_GREEN_MIN_CLAMP_INGR
      GL_GREEN_NV
      GL_GREEN_SCALE
      GL_GREMEDY_frame_terminator
      GL_GREMEDY_string_marker
      GL_GUILTY_CONTEXT_RESET
      GL_GUILTY_CONTEXT_RESET_ARB
      GL_HALF_APPLE
      GL_HALF_BIAS_NEGATE_NV
      GL_HALF_BIAS_NORMAL_NV
      GL_HALF_BIT_ATI
      GL_HALF_FLOAT
      GL_HALF_FLOAT_ARB
      GL_HALF_FLOAT_NV
      GL_HARDLIGHT_KHR
      GL_HARDLIGHT_NV
      GL_HARDMIX_NV
      GL_HIGH_FLOAT
      GL_HIGH_INT
      GL_HILO16_NV
      GL_HILO8_NV
      GL_HILO_NV
      GL_HINT_BIT
      GL_HISTOGRAM
      GL_HISTOGRAM_ALPHA_SIZE
      GL_HISTOGRAM_ALPHA_SIZE_EXT
      GL_HISTOGRAM_BLUE_SIZE
      GL_HISTOGRAM_BLUE_SIZE_EXT
      GL_HISTOGRAM_EXT
      GL_HISTOGRAM_FORMAT
      GL_HISTOGRAM_FORMAT_EXT
      GL_HISTOGRAM_GREEN_SIZE
      GL_HISTOGRAM_GREEN_SIZE_EXT
      GL_HISTOGRAM_LUMINANCE_SIZE
      GL_HISTOGRAM_LUMINANCE_SIZE_EXT
      GL_HISTOGRAM_RED_SIZE
      GL_HISTOGRAM_RED_SIZE_EXT
      GL_HISTOGRAM_SINK
      GL_HISTOGRAM_SINK_EXT
      GL_HISTOGRAM_WIDTH
      GL_HISTOGRAM_WIDTH_EXT
      GL_HI_BIAS_NV
      GL_HI_SCALE_NV
      GL_HORIZONTAL_LINE_TO_NV
      GL_HP_convolution_border_modes
      GL_HP_image_transform
      GL_HP_occlusion_test
      GL_HP_texture_lighting
      GL_HSL_COLOR_KHR
      GL_HSL_COLOR_NV
      GL_HSL_HUE_KHR
      GL_HSL_HUE_NV
      GL_HSL_LUMINOSITY_KHR
      GL_HSL_LUMINOSITY_NV
      GL_HSL_SATURATION_KHR
      GL_HSL_SATURATION_NV
      GL_IBM_cull_vertex
      GL_IBM_multimode_draw_arrays
      GL_IBM_rasterpos_clip
      GL_IBM_static_data
      GL_IBM_texture_mirrored_repeat
      GL_IBM_vertex_array_lists
      GL_IDENTITY_NV
      GL_IGNORE_BORDER
      GL_IMAGE_1D
      GL_IMAGE_1D_ARRAY
      GL_IMAGE_1D_ARRAY_EXT
      GL_IMAGE_1D_EXT
      GL_IMAGE_2D
      GL_IMAGE_2D_ARRAY
      GL_IMAGE_2D_ARRAY_EXT
      GL_IMAGE_2D_EXT
      GL_IMAGE_2D_MULTISAMPLE
      GL_IMAGE_2D_MULTISAMPLE_ARRAY
      GL_IMAGE_2D_MULTISAMPLE_ARRAY_EXT
      GL_IMAGE_2D_MULTISAMPLE_EXT
      GL_IMAGE_2D_RECT
      GL_IMAGE_2D_RECT_EXT
      GL_IMAGE_3D
      GL_IMAGE_3D_EXT
      GL_IMAGE_BINDING_ACCESS
      GL_IMAGE_BINDING_ACCESS_EXT
      GL_IMAGE_BINDING_FORMAT
      GL_IMAGE_BINDING_FORMAT_EXT
      GL_IMAGE_BINDING_LAYER
      GL_IMAGE_BINDING_LAYERED
      GL_IMAGE_BINDING_LAYERED_EXT
      GL_IMAGE_BINDING_LAYER_EXT
      GL_IMAGE_BINDING_LEVEL
      GL_IMAGE_BINDING_LEVEL_EXT
      GL_IMAGE_BINDING_NAME
      GL_IMAGE_BINDING_NAME_EXT
      GL_IMAGE_BUFFER
      GL_IMAGE_BUFFER_EXT
      GL_IMAGE_CLASS_10_10_10_2
      GL_IMAGE_CLASS_11_11_10
      GL_IMAGE_CLASS_1_X_16
      GL_IMAGE_CLASS_1_X_32
      GL_IMAGE_CLASS_1_X_8
      GL_IMAGE_CLASS_2_X_16
      GL_IMAGE_CLASS_2_X_32
      GL_IMAGE_CLASS_2_X_8
      GL_IMAGE_CLASS_4_X_16
      GL_IMAGE_CLASS_4_X_32
      GL_IMAGE_CLASS_4_X_8
      GL_IMAGE_COMPATIBILITY_CLASS
      GL_IMAGE_CUBE
      GL_IMAGE_CUBE_EXT
      GL_IMAGE_CUBE_MAP_ARRAY
      GL_IMAGE_CUBE_MAP_ARRAY_EXT
      GL_IMAGE_FORMAT_COMPATIBILITY_BY_CLASS
      GL_IMAGE_FORMAT_COMPATIBILITY_BY_SIZE
      GL_IMAGE_FORMAT_COMPATIBILITY_TYPE
      GL_IMAGE_PIXEL_FORMAT
      GL_IMAGE_PIXEL_TYPE
      GL_IMAGE_TEXEL_SIZE
      GL_IMPLEMENTATION_COLOR_READ_FORMAT
      GL_IMPLEMENTATION_COLOR_READ_FORMAT_OES
      GL_IMPLEMENTATION_COLOR_READ_TYPE
      GL_IMPLEMENTATION_COLOR_READ_TYPE_OES
      GL_INCLUSIVE_EXT
      GL_INCR
      GL_INCR_WRAP
      GL_INCR_WRAP_EXT
      GL_INDEX
      GL_INDEX_ARRAY
      GL_INDEX_ARRAY_ADDRESS_NV
      GL_INDEX_ARRAY_BUFFER_BINDING
      GL_INDEX_ARRAY_BUFFER_BINDING_ARB
      GL_INDEX_ARRAY_COUNT_EXT
      GL_INDEX_ARRAY_EXT
      GL_INDEX_ARRAY_LENGTH_NV
      GL_INDEX_ARRAY_LIST_IBM
      GL_INDEX_ARRAY_LIST_STRIDE_IBM
      GL_INDEX_ARRAY_POINTER
      GL_INDEX_ARRAY_POINTER_EXT
      GL_INDEX_ARRAY_STRIDE
      GL_INDEX_ARRAY_STRIDE_EXT
      GL_INDEX_ARRAY_TYPE
      GL_INDEX_ARRAY_TYPE_EXT
      GL_INDEX_BITS
      GL_INDEX_BIT_PGI
      GL_INDEX_CLEAR_VALUE
      GL_INDEX_LOGIC_OP
      GL_INDEX_MODE
      GL_INDEX_OFFSET
      GL_INDEX_SHIFT
      GL_INDEX_WRITEMASK
      GL_INFO_LOG_LENGTH
      GL_INGR_color_clamp
      GL_INGR_interlace_read
      GL_INNOCENT_CONTEXT_RESET
      GL_INNOCENT_CONTEXT_RESET_ARB
      GL_INT
      GL_INT16_NV
      GL_INT16_VEC2_NV
      GL_INT16_VEC3_NV
      GL_INT16_VEC4_NV
      GL_INT64_ARB
      GL_INT64_NV
      GL_INT64_VEC2_ARB
      GL_INT64_VEC2_NV
      GL_INT64_VEC3_ARB
      GL_INT64_VEC3_NV
      GL_INT64_VEC4_ARB
      GL_INT64_VEC4_NV
      GL_INT8_NV
      GL_INT8_VEC2_NV
      GL_INT8_VEC3_NV
      GL_INT8_VEC4_NV
      GL_INTEL_conservative_rasterization
      GL_INTEL_fragment_shader_ordering
      GL_INTEL_framebuffer_CMAA
      GL_INTEL_map_texture
      GL_INTEL_parallel_arrays
      GL_INTEL_performance_query
      GL_INTEL_texture_scissor
      GL_INTENSITY
      GL_INTENSITY12
      GL_INTENSITY12_EXT
      GL_INTENSITY16
      GL_INTENSITY16F_ARB
      GL_INTENSITY16I_EXT
      GL_INTENSITY16UI_EXT
      GL_INTENSITY16_EXT
      GL_INTENSITY16_EXTENDED_RANGE_SGIX
      GL_INTENSITY16_SIGNED_SGIX
      GL_INTENSITY16_SNORM
      GL_INTENSITY32F_ARB
      GL_INTENSITY32I_EXT
      GL_INTENSITY32UI_EXT
      GL_INTENSITY4
      GL_INTENSITY4_EXT
      GL_INTENSITY8
      GL_INTENSITY8I_EXT
      GL_INTENSITY8UI_EXT
      GL_INTENSITY8_EXT
      GL_INTENSITY8_SNORM
      GL_INTENSITY_EXT
      GL_INTENSITY_EXTENDED_RANGE_SGIX
      GL_INTENSITY_FLOAT16_APPLE
      GL_INTENSITY_FLOAT16_ATI
      GL_INTENSITY_FLOAT32_APPLE
      GL_INTENSITY_FLOAT32_ATI
      GL_INTENSITY_SIGNED_SGIX
      GL_INTENSITY_SNORM
      GL_INTERLACE_OML
      GL_INTERLACE_READ_INGR
      GL_INTERLACE_READ_OML
      GL_INTERLACE_SGIX
      GL_INTERLEAVED_ATTRIBS
      GL_INTERLEAVED_ATTRIBS_EXT
      GL_INTERLEAVED_ATTRIBS_NV
      GL_INTERNALFORMAT_ALPHA_SIZE
      GL_INTERNALFORMAT_ALPHA_TYPE
      GL_INTERNALFORMAT_BLUE_SIZE
      GL_INTERNALFORMAT_BLUE_TYPE
      GL_INTERNALFORMAT_DEPTH_SIZE
      GL_INTERNALFORMAT_DEPTH_TYPE
      GL_INTERNALFORMAT_GREEN_SIZE
      GL_INTERNALFORMAT_GREEN_TYPE
      GL_INTERNALFORMAT_PREFERRED
      GL_INTERNALFORMAT_RED_SIZE
      GL_INTERNALFORMAT_RED_TYPE
      GL_INTERNALFORMAT_SHARED_SIZE
      GL_INTERNALFORMAT_STENCIL_SIZE
      GL_INTERNALFORMAT_STENCIL_TYPE
      GL_INTERNALFORMAT_SUPPORTED
      GL_INTERPOLATE
      GL_INTERPOLATE_ARB
      GL_INTERPOLATE_EXT
      GL_INT_2_10_10_10_REV
      GL_INT_IMAGE_1D
      GL_INT_IMAGE_1D_ARRAY
      GL_INT_IMAGE_1D_ARRAY_EXT
      GL_INT_IMAGE_1D_EXT
      GL_INT_IMAGE_2D
      GL_INT_IMAGE_2D_ARRAY
      GL_INT_IMAGE_2D_ARRAY_EXT
      GL_INT_IMAGE_2D_EXT
      GL_INT_IMAGE_2D_MULTISAMPLE
      GL_INT_IMAGE_2D_MULTISAMPLE_ARRAY
      GL_INT_IMAGE_2D_MULTISAMPLE_ARRAY_EXT
      GL_INT_IMAGE_2D_MULTISAMPLE_EXT
      GL_INT_IMAGE_2D_RECT
      GL_INT_IMAGE_2D_RECT_EXT
      GL_INT_IMAGE_3D
      GL_INT_IMAGE_3D_EXT
      GL_INT_IMAGE_BUFFER
      GL_INT_IMAGE_BUFFER_EXT
      GL_INT_IMAGE_CUBE
      GL_INT_IMAGE_CUBE_EXT
      GL_INT_IMAGE_CUBE_MAP_ARRAY
      GL_INT_IMAGE_CUBE_MAP_ARRAY_EXT
      GL_INT_SAMPLER_1D
      GL_INT_SAMPLER_1D_ARRAY
      GL_INT_SAMPLER_1D_ARRAY_EXT
      GL_INT_SAMPLER_1D_EXT
      GL_INT_SAMPLER_2D
      GL_INT_SAMPLER_2D_ARRAY
      GL_INT_SAMPLER_2D_ARRAY_EXT
      GL_INT_SAMPLER_2D_EXT
      GL_INT_SAMPLER_2D_MULTISAMPLE
      GL_INT_SAMPLER_2D_MULTISAMPLE_ARRAY
      GL_INT_SAMPLER_2D_RECT
      GL_INT_SAMPLER_2D_RECT_EXT
      GL_INT_SAMPLER_3D
      GL_INT_SAMPLER_3D_EXT
      GL_INT_SAMPLER_BUFFER
      GL_INT_SAMPLER_BUFFER_AMD
      GL_INT_SAMPLER_BUFFER_EXT
      GL_INT_SAMPLER_CUBE
      GL_INT_SAMPLER_CUBE_EXT
      GL_INT_SAMPLER_CUBE_MAP_ARRAY
      GL_INT_SAMPLER_CUBE_MAP_ARRAY_ARB
      GL_INT_SAMPLER_RENDERBUFFER_NV
      GL_INT_VEC2
      GL_INT_VEC2_ARB
      GL_INT_VEC3
      GL_INT_VEC3_ARB
      GL_INT_VEC4
      GL_INT_VEC4_ARB
      GL_INVALID_ENUM
      GL_INVALID_FRAMEBUFFER_OPERATION
      GL_INVALID_FRAMEBUFFER_OPERATION_EXT
      GL_INVALID_INDEX
      GL_INVALID_OPERATION
      GL_INVALID_VALUE
      GL_INVARIANT_DATATYPE_EXT
      GL_INVARIANT_EXT
      GL_INVARIANT_VALUE_EXT
      GL_INVERSE_NV
      GL_INVERSE_TRANSPOSE_NV
      GL_INVERT
      GL_INVERTED_SCREEN_W_REND
      GL_INVERT_OVG_NV
      GL_INVERT_RGB_NV
      GL_ISOLINES
      GL_IS_PER_PATCH
      GL_IS_ROW_MAJOR
      GL_ITALIC_BIT_NV
      GL_KEEP
      GL_KHR_blend_equation_advanced
      GL_KHR_blend_equation_advanced_coherent
      GL_KHR_context_flush_control
      GL_KHR_debug
      GL_KHR_no_error
      GL_KHR_robust_buffer_access_behavior
      GL_KHR_robustness
      GL_KHR_texture_compression_astc_hdr
      GL_KHR_texture_compression_astc_ldr
      GL_KHR_texture_compression_astc_sliced_3d
      GL_KTX_BACK_REGION
      GL_KTX_FRONT_REGION
      GL_KTX_STENCIL_REGION
      GL_KTX_Z_REGION
      GL_KTX_buffer_region
      GL_LARGE_CCW_ARC_TO_NV
      GL_LARGE_CW_ARC_TO_NV
      GL_LAST_VERTEX_CONVENTION
      GL_LAST_VERTEX_CONVENTION_EXT
      GL_LAST_VIDEO_CAPTURE_STATUS_NV
      GL_LAYER_PROVOKING_VERTEX
      GL_LAYOUT_DEFAULT_INTEL
      GL_LAYOUT_LINEAR_CPU_CACHED_INTEL
      GL_LAYOUT_LINEAR_INTEL
      GL_LEFT
      GL_LEQUAL
      GL_LERP_ATI
      GL_LESS
      GL_LGPU_SEPARATE_STORAGE_BIT_NVX
      GL_LIGHT0
      GL_LIGHT1
      GL_LIGHT2
      GL_LIGHT3
      GL_LIGHT4
      GL_LIGHT5
      GL_LIGHT6
      GL_LIGHT7
      GL_LIGHTEN_KHR
      GL_LIGHTEN_NV
      GL_LIGHTING
      GL_LIGHTING_BIT
      GL_LIGHT_ENV_MODE_EXT
      GL_LIGHT_MODEL_AMBIENT
      GL_LIGHT_MODEL_COLOR_CONTROL
      GL_LIGHT_MODEL_COLOR_CONTROL_EXT
      GL_LIGHT_MODEL_LOCAL_VIEWER
      GL_LIGHT_MODEL_SPECULAR_VECTOR_APPLE
      GL_LIGHT_MODEL_TWO_SIDE
      GL_LINE
      GL_LINEAR
      GL_LINEARBURN_NV
      GL_LINEARDODGE_NV
      GL_LINEARLIGHT_NV
      GL_LINEAR_ATTENUATION
      GL_LINEAR_MIPMAP_LINEAR
      GL_LINEAR_MIPMAP_NEAREST
      GL_LINES
      GL_LINES_ADJACENCY
      GL_LINES_ADJACENCY_ARB
      GL_LINES_ADJACENCY_EXT
      GL_LINE_BIT
      GL_LINE_LOOP
      GL_LINE_RESET_TOKEN
      GL_LINE_SMOOTH
      GL_LINE_SMOOTH_HINT
      GL_LINE_STIPPLE
      GL_LINE_STIPPLE_PATTERN
      GL_LINE_STIPPLE_REPEAT
      GL_LINE_STRIP
      GL_LINE_STRIP_ADJACENCY
      GL_LINE_STRIP_ADJACENCY_ARB
      GL_LINE_STRIP_ADJACENCY_EXT
      GL_LINE_TOKEN
      GL_LINE_TO_NV
      GL_LINE_WIDTH
      GL_LINE_WIDTH_COMMAND_NV
      GL_LINE_WIDTH_GRANULARITY
      GL_LINE_WIDTH_RANGE
      GL_LINK_STATUS
      GL_LIST_BASE
      GL_LIST_BIT
      GL_LIST_INDEX
      GL_LIST_MODE
      GL_LOAD
      GL_LOCAL_CONSTANT_DATATYPE_EXT
      GL_LOCAL_CONSTANT_EXT
      GL_LOCAL_CONSTANT_VALUE_EXT
      GL_LOCAL_EXT
      GL_LOCATION
      GL_LOCATION_COMPONENT
      GL_LOCATION_INDEX
      GL_LOGIC_OP
      GL_LOGIC_OP_MODE
      GL_LOG_APP_REGAL
      GL_LOG_DEBUG_REGAL
      GL_LOG_DRIVER_REGAL
      GL_LOG_ERROR_REGAL
      GL_LOG_HTTP_REGAL
      GL_LOG_INFO_REGAL
      GL_LOG_INTERNAL_REGAL
      GL_LOG_REGAL
      GL_LOG_STATUS_REGAL
      GL_LOG_WARNING_REGAL
      GL_LOSE_CONTEXT_ON_RESET
      GL_LOSE_CONTEXT_ON_RESET_ARB
      GL_LOWER_LEFT
      GL_LOW_FLOAT
      GL_LOW_INT
      GL_LO_BIAS_NV
      GL_LO_SCALE_NV
      GL_LUMINANCE
      GL_LUMINANCE12
      GL_LUMINANCE12_ALPHA12
      GL_LUMINANCE12_ALPHA12_EXT
      GL_LUMINANCE12_ALPHA4
      GL_LUMINANCE12_ALPHA4_EXT
      GL_LUMINANCE12_EXT
      GL_LUMINANCE16
      GL_LUMINANCE16F_ARB
      GL_LUMINANCE16I_EXT
      GL_LUMINANCE16UI_EXT
      GL_LUMINANCE16_ALPHA16
      GL_LUMINANCE16_ALPHA16_EXT
      GL_LUMINANCE16_ALPHA16_EXTENDED_RANGE_SGIX
      GL_LUMINANCE16_ALPHA16_SIGNED_SGIX
      GL_LUMINANCE16_ALPHA16_SNORM
      GL_LUMINANCE16_EXT
      GL_LUMINANCE16_EXTENDED_RANGE_SGIX
      GL_LUMINANCE16_SIGNED_SGIX
      GL_LUMINANCE16_SNORM
      GL_LUMINANCE32F_ARB
      GL_LUMINANCE32I_EXT
      GL_LUMINANCE32UI_EXT
      GL_LUMINANCE4
      GL_LUMINANCE4_ALPHA4
      GL_LUMINANCE4_ALPHA4_EXT
      GL_LUMINANCE4_EXT
      GL_LUMINANCE6_ALPHA2
      GL_LUMINANCE6_ALPHA2_EXT
      GL_LUMINANCE8
      GL_LUMINANCE8I_EXT
      GL_LUMINANCE8UI_EXT
      GL_LUMINANCE8_ALPHA8
      GL_LUMINANCE8_ALPHA8_EXT
      GL_LUMINANCE8_ALPHA8_SNORM
      GL_LUMINANCE8_EXT
      GL_LUMINANCE8_SNORM
      GL_LUMINANCE_ALPHA
      GL_LUMINANCE_ALPHA16F_ARB
      GL_LUMINANCE_ALPHA16I_EXT
      GL_LUMINANCE_ALPHA16UI_EXT
      GL_LUMINANCE_ALPHA32F_ARB
      GL_LUMINANCE_ALPHA32I_EXT
      GL_LUMINANCE_ALPHA32UI_EXT
      GL_LUMINANCE_ALPHA8I_EXT
      GL_LUMINANCE_ALPHA8UI_EXT
      GL_LUMINANCE_ALPHA_EXTENDED_RANGE_SGIX
      GL_LUMINANCE_ALPHA_FLOAT16_APPLE
      GL_LUMINANCE_ALPHA_FLOAT16_ATI
      GL_LUMINANCE_ALPHA_FLOAT32_APPLE
      GL_LUMINANCE_ALPHA_FLOAT32_ATI
      GL_LUMINANCE_ALPHA_INTEGER_EXT
      GL_LUMINANCE_ALPHA_SIGNED_SGIX
      GL_LUMINANCE_ALPHA_SNORM
      GL_LUMINANCE_EXTENDED_RANGE_SGIX
      GL_LUMINANCE_FLOAT16_APPLE
      GL_LUMINANCE_FLOAT16_ATI
      GL_LUMINANCE_FLOAT32_APPLE
      GL_LUMINANCE_FLOAT32_ATI
      GL_LUMINANCE_INTEGER_EXT
      GL_LUMINANCE_SIGNED_SGIX
      GL_LUMINANCE_SNORM
      GL_MAD_ATI
      GL_MAGNITUDE_BIAS_NV
      GL_MAGNITUDE_SCALE_NV
      GL_MAJOR_VERSION
      GL_MANUAL_GENERATE_MIPMAP
      GL_MAP1_BINORMAL_EXT
      GL_MAP1_COLOR_4
      GL_MAP1_GRID_DOMAIN
      GL_MAP1_GRID_SEGMENTS
      GL_MAP1_INDEX
      GL_MAP1_NORMAL
      GL_MAP1_TANGENT_EXT
      GL_MAP1_TEXTURE_COORD_1
      GL_MAP1_TEXTURE_COORD_2
      GL_MAP1_TEXTURE_COORD_3
      GL_MAP1_TEXTURE_COORD_4
      GL_MAP1_VERTEX_3
      GL_MAP1_VERTEX_4
      GL_MAP1_VERTEX_ATTRIB0_4_NV
      GL_MAP1_VERTEX_ATTRIB10_4_NV
      GL_MAP1_VERTEX_ATTRIB11_4_NV
      GL_MAP1_VERTEX_ATTRIB12_4_NV
      GL_MAP1_VERTEX_ATTRIB13_4_NV
      GL_MAP1_VERTEX_ATTRIB14_4_NV
      GL_MAP1_VERTEX_ATTRIB15_4_NV
      GL_MAP1_VERTEX_ATTRIB1_4_NV
      GL_MAP1_VERTEX_ATTRIB2_4_NV
      GL_MAP1_VERTEX_ATTRIB3_4_NV
      GL_MAP1_VERTEX_ATTRIB4_4_NV
      GL_MAP1_VERTEX_ATTRIB5_4_NV
      GL_MAP1_VERTEX_ATTRIB6_4_NV
      GL_MAP1_VERTEX_ATTRIB7_4_NV
      GL_MAP1_VERTEX_ATTRIB8_4_NV
      GL_MAP1_VERTEX_ATTRIB9_4_NV
      GL_MAP2_BINORMAL_EXT
      GL_MAP2_COLOR_4
      GL_MAP2_GRID_DOMAIN
      GL_MAP2_GRID_SEGMENTS
      GL_MAP2_INDEX
      GL_MAP2_NORMAL
      GL_MAP2_TANGENT_EXT
      GL_MAP2_TEXTURE_COORD_1
      GL_MAP2_TEXTURE_COORD_2
      GL_MAP2_TEXTURE_COORD_3
      GL_MAP2_TEXTURE_COORD_4
      GL_MAP2_VERTEX_3
      GL_MAP2_VERTEX_4
      GL_MAP2_VERTEX_ATTRIB0_4_NV
      GL_MAP2_VERTEX_ATTRIB10_4_NV
      GL_MAP2_VERTEX_ATTRIB11_4_NV
      GL_MAP2_VERTEX_ATTRIB12_4_NV
      GL_MAP2_VERTEX_ATTRIB13_4_NV
      GL_MAP2_VERTEX_ATTRIB14_4_NV
      GL_MAP2_VERTEX_ATTRIB15_4_NV
      GL_MAP2_VERTEX_ATTRIB1_4_NV
      GL_MAP2_VERTEX_ATTRIB2_4_NV
      GL_MAP2_VERTEX_ATTRIB3_4_NV
      GL_MAP2_VERTEX_ATTRIB4_4_NV
      GL_MAP2_VERTEX_ATTRIB5_4_NV
      GL_MAP2_VERTEX_ATTRIB6_4_NV
      GL_MAP2_VERTEX_ATTRIB7_4_NV
      GL_MAP2_VERTEX_ATTRIB8_4_NV
      GL_MAP2_VERTEX_ATTRIB9_4_NV
      GL_MAP_ATTRIB_U_ORDER_NV
      GL_MAP_ATTRIB_V_ORDER_NV
      GL_MAP_COHERENT_BIT
      GL_MAP_COLOR
      GL_MAP_FLUSH_EXPLICIT_BIT
      GL_MAP_INVALIDATE_BUFFER_BIT
      GL_MAP_INVALIDATE_RANGE_BIT
      GL_MAP_PERSISTENT_BIT
      GL_MAP_READ_BIT
      GL_MAP_STENCIL
      GL_MAP_TESSELLATION_NV
      GL_MAP_UNSYNCHRONIZED_BIT
      GL_MAP_WRITE_BIT
      GL_MATERIAL_SIDE_HINT_PGI
      GL_MATRIX0_ARB
      GL_MATRIX0_NV
      GL_MATRIX10_ARB
      GL_MATRIX11_ARB
      GL_MATRIX12_ARB
      GL_MATRIX13_ARB
      GL_MATRIX14_ARB
      GL_MATRIX15_ARB
      GL_MATRIX16_ARB
      GL_MATRIX17_ARB
      GL_MATRIX18_ARB
      GL_MATRIX19_ARB
      GL_MATRIX1_ARB
      GL_MATRIX1_NV
      GL_MATRIX20_ARB
      GL_MATRIX21_ARB
      GL_MATRIX22_ARB
      GL_MATRIX23_ARB
      GL_MATRIX24_ARB
      GL_MATRIX25_ARB
      GL_MATRIX26_ARB
      GL_MATRIX27_ARB
      GL_MATRIX28_ARB
      GL_MATRIX29_ARB
      GL_MATRIX2_ARB
      GL_MATRIX2_NV
      GL_MATRIX30_ARB
      GL_MATRIX31_ARB
      GL_MATRIX3_ARB
      GL_MATRIX3_NV
      GL_MATRIX4_ARB
      GL_MATRIX4_NV
      GL_MATRIX5_ARB
      GL_MATRIX5_NV
      GL_MATRIX6_ARB
      GL_MATRIX6_NV
      GL_MATRIX7_ARB
      GL_MATRIX7_NV
      GL_MATRIX8_ARB
      GL_MATRIX9_ARB
      GL_MATRIX_EXT
      GL_MATRIX_INDEX_ARRAY_ARB
      GL_MATRIX_INDEX_ARRAY_POINTER_ARB
      GL_MATRIX_INDEX_ARRAY_SIZE_ARB
      GL_MATRIX_INDEX_ARRAY_STRIDE_ARB
      GL_MATRIX_INDEX_ARRAY_TYPE_ARB
      GL_MATRIX_MODE
      GL_MATRIX_PALETTE_ARB
      GL_MATRIX_STRIDE
      GL_MAT_AMBIENT_AND_DIFFUSE_BIT_PGI
      GL_MAT_AMBIENT_BIT_PGI
      GL_MAT_COLOR_INDEXES_BIT_PGI
      GL_MAT_DIFFUSE_BIT_PGI
      GL_MAT_EMISSION_BIT_PGI
      GL_MAT_SHININESS_BIT_PGI
      GL_MAT_SPECULAR_BIT_PGI
      GL_MAX
      GL_MAX_3D_TEXTURE_SIZE
      GL_MAX_3D_TEXTURE_SIZE_EXT
      GL_MAX_ACTIVE_LIGHTS_EXT
      GL_MAX_ALPHA_SGIS
      GL_MAX_ARRAY_TEXTURE_LAYERS
      GL_MAX_ARRAY_TEXTURE_LAYERS_EXT
      GL_MAX_ASYNC_DRAW_PIXELS_SGIX
      GL_MAX_ASYNC_HISTOGRAM_SGIX
      GL_MAX_ASYNC_READ_PIXELS_SGIX
      GL_MAX_ASYNC_TEX_IMAGE_SGIX
      GL_MAX_ATOMIC_COUNTER_BUFFER_BINDINGS
      GL_MAX_ATOMIC_COUNTER_BUFFER_SIZE
      GL_MAX_ATTRIB_STACK_DEPTH
      GL_MAX_BINDABLE_UNIFORM_SIZE_EXT
      GL_MAX_BLUE_SGIS
      GL_MAX_CLIENT_ATTRIB_STACK_DEPTH
      GL_MAX_CLIP_DISTANCES
      GL_MAX_CLIP_PLANES
      GL_MAX_COLOR_ATTACHMENTS
      GL_MAX_COLOR_ATTACHMENTS_EXT
      GL_MAX_COLOR_MATRIX_STACK_DEPTH
      GL_MAX_COLOR_MATRIX_STACK_DEPTH_SGI
      GL_MAX_COLOR_TEXTURE_SAMPLES
      GL_MAX_COMBINED_ATOMIC_COUNTERS
      GL_MAX_COMBINED_ATOMIC_COUNTER_BUFFERS
      GL_MAX_COMBINED_CLIP_AND_CULL_DISTANCES
      GL_MAX_COMBINED_COMPUTE_UNIFORM_COMPONENTS
      GL_MAX_COMBINED_DIMENSIONS
      GL_MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS
      GL_MAX_COMBINED_GEOMETRY_UNIFORM_COMPONENTS
      GL_MAX_COMBINED_IMAGE_UNIFORMS
      GL_MAX_COMBINED_IMAGE_UNITS_AND_FRAGMENT_OUTPUTS
      GL_MAX_COMBINED_IMAGE_UNITS_AND_FRAGMENT_OUTPUTS_EXT
      GL_MAX_COMBINED_SHADER_OUTPUT_RESOURCES
      GL_MAX_COMBINED_SHADER_STORAGE_BLOCKS
      GL_MAX_COMBINED_TESS_CONTROL_UNIFORM_COMPONENTS
      GL_MAX_COMBINED_TESS_EVALUATION_UNIFORM_COMPONENTS
      GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS
      GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS_ARB
      GL_MAX_COMBINED_UNIFORM_BLOCKS
      GL_MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS
      GL_MAX_COMPUTE_ATOMIC_COUNTERS
      GL_MAX_COMPUTE_ATOMIC_COUNTER_BUFFERS
      GL_MAX_COMPUTE_FIXED_GROUP_INVOCATIONS_ARB
      GL_MAX_COMPUTE_FIXED_GROUP_SIZE_ARB
      GL_MAX_COMPUTE_IMAGE_UNIFORMS
      GL_MAX_COMPUTE_SHADER_STORAGE_BLOCKS
      GL_MAX_COMPUTE_SHARED_MEMORY_SIZE
      GL_MAX_COMPUTE_TEXTURE_IMAGE_UNITS
      GL_MAX_COMPUTE_UNIFORM_BLOCKS
      GL_MAX_COMPUTE_UNIFORM_COMPONENTS
      GL_MAX_COMPUTE_VARIABLE_GROUP_INVOCATIONS_ARB
      GL_MAX_COMPUTE_VARIABLE_GROUP_SIZE_ARB
      GL_MAX_COMPUTE_WORK_GROUP_COUNT
      GL_MAX_COMPUTE_WORK_GROUP_INVOCATIONS
      GL_MAX_COMPUTE_WORK_GROUP_SIZE
      GL_MAX_CONVOLUTION_HEIGHT
      GL_MAX_CONVOLUTION_HEIGHT_EXT
      GL_MAX_CONVOLUTION_WIDTH
      GL_MAX_CONVOLUTION_WIDTH_EXT
      GL_MAX_CUBE_MAP_TEXTURE_SIZE
      GL_MAX_CUBE_MAP_TEXTURE_SIZE_ARB
      GL_MAX_CUBE_MAP_TEXTURE_SIZE_EXT
      GL_MAX_CULL_DISTANCES
      GL_MAX_DEBUG_GROUP_STACK_DEPTH
      GL_MAX_DEBUG_LOGGED_MESSAGES
      GL_MAX_DEBUG_LOGGED_MESSAGES_AMD
      GL_MAX_DEBUG_LOGGED_MESSAGES_ARB
      GL_MAX_DEBUG_MESSAGE_LENGTH
      GL_MAX_DEBUG_MESSAGE_LENGTH_AMD
      GL_MAX_DEBUG_MESSAGE_LENGTH_ARB
      GL_MAX_DEEP_3D_TEXTURE_DEPTH_NV
      GL_MAX_DEEP_3D_TEXTURE_WIDTH_HEIGHT_NV
      GL_MAX_DEPTH
      GL_MAX_DEPTH_TEXTURE_SAMPLES
      GL_MAX_DRAW_BUFFERS
      GL_MAX_DRAW_BUFFERS_ARB
      GL_MAX_DRAW_BUFFERS_ATI
      GL_MAX_DUAL_SOURCE_DRAW_BUFFERS
      GL_MAX_ELEMENTS_INDICES
      GL_MAX_ELEMENTS_INDICES_EXT
      GL_MAX_ELEMENTS_VERTICES
      GL_MAX_ELEMENTS_VERTICES_EXT
      GL_MAX_ELEMENT_INDEX
      GL_MAX_EVAL_ORDER
      GL_MAX_EXT
      GL_MAX_FRAGMENT_ATOMIC_COUNTERS
      GL_MAX_FRAGMENT_ATOMIC_COUNTER_BUFFERS
      GL_MAX_FRAGMENT_BINDABLE_UNIFORMS_EXT
      GL_MAX_FRAGMENT_IMAGE_UNIFORMS
      GL_MAX_FRAGMENT_INPUT_COMPONENTS
      GL_MAX_FRAGMENT_INTERPOLATION_OFFSET
      GL_MAX_FRAGMENT_INTERPOLATION_OFFSET_NV
      GL_MAX_FRAGMENT_LIGHTS_EXT
      GL_MAX_FRAGMENT_PROGRAM_LOCAL_PARAMETERS_NV
      GL_MAX_FRAGMENT_SHADER_STORAGE_BLOCKS
      GL_MAX_FRAGMENT_UNIFORM_BLOCKS
      GL_MAX_FRAGMENT_UNIFORM_COMPONENTS
      GL_MAX_FRAGMENT_UNIFORM_COMPONENTS_ARB
      GL_MAX_FRAGMENT_UNIFORM_VECTORS
      GL_MAX_FRAMEBUFFER_HEIGHT
      GL_MAX_FRAMEBUFFER_LAYERS
      GL_MAX_FRAMEBUFFER_SAMPLES
      GL_MAX_FRAMEBUFFER_WIDTH
      GL_MAX_GENERAL_COMBINERS_NV
      GL_MAX_GEOMETRY_ATOMIC_COUNTERS
      GL_MAX_GEOMETRY_ATOMIC_COUNTER_BUFFERS
      GL_MAX_GEOMETRY_BINDABLE_UNIFORMS_EXT
      GL_MAX_GEOMETRY_IMAGE_UNIFORMS
      GL_MAX_GEOMETRY_INPUT_COMPONENTS
      GL_MAX_GEOMETRY_OUTPUT_COMPONENTS
      GL_MAX_GEOMETRY_OUTPUT_VERTICES
      GL_MAX_GEOMETRY_OUTPUT_VERTICES_ARB
      GL_MAX_GEOMETRY_OUTPUT_VERTICES_EXT
      GL_MAX_GEOMETRY_PROGRAM_INVOCATIONS_NV
      GL_MAX_GEOMETRY_SHADER_INVOCATIONS
      GL_MAX_GEOMETRY_SHADER_STORAGE_BLOCKS
      GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS
      GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS_ARB
      GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS_EXT
      GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS
      GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS_ARB
      GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS_EXT
      GL_MAX_GEOMETRY_UNIFORM_BLOCKS
      GL_MAX_GEOMETRY_UNIFORM_COMPONENTS
      GL_MAX_GEOMETRY_UNIFORM_COMPONENTS_ARB
      GL_MAX_GEOMETRY_UNIFORM_COMPONENTS_EXT
      GL_MAX_GEOMETRY_VARYING_COMPONENTS_ARB
      GL_MAX_GEOMETRY_VARYING_COMPONENTS_EXT
      GL_MAX_GREEN_SGIS
      GL_MAX_HEIGHT
      GL_MAX_IMAGE_SAMPLES
      GL_MAX_IMAGE_SAMPLES_EXT
      GL_MAX_IMAGE_UNITS
      GL_MAX_IMAGE_UNITS_EXT
      GL_MAX_INTEGER_SAMPLES
      GL_MAX_INTENSITY_SGIS
      GL_MAX_LABEL_LENGTH
      GL_MAX_LAYERS
      GL_MAX_LGPU_GPUS_NVX
      GL_MAX_LIGHTS
      GL_MAX_LIST_NESTING
      GL_MAX_LUMINANCE_SGIS
      GL_MAX_MAP_TESSELLATION_NV
      GL_MAX_MATRIX_PALETTE_STACK_DEPTH_ARB
      GL_MAX_MODELVIEW_STACK_DEPTH
      GL_MAX_MULTISAMPLE_COVERAGE_MODES_NV
      GL_MAX_NAME_LENGTH
      GL_MAX_NAME_STACK_DEPTH
      GL_MAX_NUM_ACTIVE_VARIABLES
      GL_MAX_NUM_COMPATIBLE_SUBROUTINES
      GL_MAX_OPTIMIZED_VERTEX_SHADER_INSTRUCTIONS_EXT
      GL_MAX_OPTIMIZED_VERTEX_SHADER_INVARIANTS_EXT
      GL_MAX_OPTIMIZED_VERTEX_SHADER_LOCALS_EXT
      GL_MAX_OPTIMIZED_VERTEX_SHADER_LOCAL_CONSTANTS_EXT
      GL_MAX_OPTIMIZED_VERTEX_SHADER_VARIANTS_EXT
      GL_MAX_PALETTE_MATRICES_ARB
      GL_MAX_PATCH_VERTICES
      GL_MAX_PIXEL_MAP_TABLE
      GL_MAX_PIXEL_TRANSFORM_2D_STACK_DEPTH_EXT
      GL_MAX_PN_TRIANGLES_TESSELATION_LEVEL_ATI
      GL_MAX_PROGRAM_ADDRESS_REGISTERS_ARB
      GL_MAX_PROGRAM_ALU_INSTRUCTIONS_ARB
      GL_MAX_PROGRAM_ATTRIBS_ARB
      GL_MAX_PROGRAM_ATTRIB_COMPONENTS_NV
      GL_MAX_PROGRAM_CALL_DEPTH_NV
      GL_MAX_PROGRAM_ENV_PARAMETERS_ARB
      GL_MAX_PROGRAM_EXEC_INSTRUCTIONS_NV
      GL_MAX_PROGRAM_GENERIC_ATTRIBS_NV
      GL_MAX_PROGRAM_GENERIC_RESULTS_NV
      GL_MAX_PROGRAM_IF_DEPTH_NV
      GL_MAX_PROGRAM_INSTRUCTIONS_ARB
      GL_MAX_PROGRAM_LOCAL_PARAMETERS_ARB
      GL_MAX_PROGRAM_LOOP_COUNT_NV
      GL_MAX_PROGRAM_LOOP_DEPTH_NV
      GL_MAX_PROGRAM_MATRICES_ARB
      GL_MAX_PROGRAM_MATRIX_STACK_DEPTH_ARB
      GL_MAX_PROGRAM_NATIVE_ADDRESS_REGISTERS_ARB
      GL_MAX_PROGRAM_NATIVE_ALU_INSTRUCTIONS_ARB
      GL_MAX_PROGRAM_NATIVE_ATTRIBS_ARB
      GL_MAX_PROGRAM_NATIVE_INSTRUCTIONS_ARB
      GL_MAX_PROGRAM_NATIVE_PARAMETERS_ARB
      GL_MAX_PROGRAM_NATIVE_TEMPORARIES_ARB
      GL_MAX_PROGRAM_NATIVE_TEX_INDIRECTIONS_ARB
      GL_MAX_PROGRAM_NATIVE_TEX_INSTRUCTIONS_ARB
      GL_MAX_PROGRAM_OUTPUT_VERTICES_NV
      GL_MAX_PROGRAM_PARAMETERS_ARB
      GL_MAX_PROGRAM_PARAMETER_BUFFER_BINDINGS_NV
      GL_MAX_PROGRAM_PARAMETER_BUFFER_SIZE_NV
      GL_MAX_PROGRAM_PATCH_ATTRIBS_NV
      GL_MAX_PROGRAM_RESULT_COMPONENTS_NV
      GL_MAX_PROGRAM_TEMPORARIES_ARB
      GL_MAX_PROGRAM_TEXEL_OFFSET
      GL_MAX_PROGRAM_TEXEL_OFFSET_NV
      GL_MAX_PROGRAM_TEXTURE_GATHER_COMPONENTS
      GL_MAX_PROGRAM_TEXTURE_GATHER_COMPONENTS_ARB
      GL_MAX_PROGRAM_TEXTURE_GATHER_OFFSET
      GL_MAX_PROGRAM_TEXTURE_GATHER_OFFSET_ARB
      GL_MAX_PROGRAM_TEXTURE_GATHER_OFFSET_NV
      GL_MAX_PROGRAM_TEX_INDIRECTIONS_ARB
      GL_MAX_PROGRAM_TEX_INSTRUCTIONS_ARB
      GL_MAX_PROGRAM_TOTAL_OUTPUT_COMPONENTS_NV
      GL_MAX_PROJECTION_STACK_DEPTH
      GL_MAX_RASTER_SAMPLES_EXT
      GL_MAX_RATIONAL_EVAL_ORDER_NV
      GL_MAX_RECTANGLE_TEXTURE_SIZE
      GL_MAX_RECTANGLE_TEXTURE_SIZE_ARB
      GL_MAX_RECTANGLE_TEXTURE_SIZE_EXT
      GL_MAX_RECTANGLE_TEXTURE_SIZE_NV
      GL_MAX_RED_SGIS
      GL_MAX_RENDERBUFFER_SIZE
      GL_MAX_RENDERBUFFER_SIZE_EXT
      GL_MAX_SAMPLES
      GL_MAX_SAMPLES_ANGLE
      GL_MAX_SAMPLES_EXT
      GL_MAX_SAMPLE_MASK_WORDS
      GL_MAX_SAMPLE_MASK_WORDS_NV
      GL_MAX_SERVER_WAIT_TIMEOUT
      GL_MAX_SHADER_BUFFER_ADDRESS_NV
      GL_MAX_SHADER_COMPILER_THREADS_ARB
      GL_MAX_SHADER_STORAGE_BLOCK_SIZE
      GL_MAX_SHADER_STORAGE_BUFFER_BINDINGS
      GL_MAX_SHININESS_NV
      GL_MAX_SPARSE_3D_TEXTURE_SIZE_AMD
      GL_MAX_SPARSE_3D_TEXTURE_SIZE_ARB
      GL_MAX_SPARSE_ARRAY_TEXTURE_LAYERS
      GL_MAX_SPARSE_ARRAY_TEXTURE_LAYERS_ARB
      GL_MAX_SPARSE_TEXTURE_SIZE_AMD
      GL_MAX_SPARSE_TEXTURE_SIZE_ARB
      GL_MAX_SPOT_EXPONENT_NV
      GL_MAX_SUBPIXEL_PRECISION_BIAS_BITS_NV
      GL_MAX_SUBROUTINES
      GL_MAX_SUBROUTINE_UNIFORM_LOCATIONS
      GL_MAX_TESS_CONTROL_ATOMIC_COUNTERS
      GL_MAX_TESS_CONTROL_ATOMIC_COUNTER_BUFFERS
      GL_MAX_TESS_CONTROL_IMAGE_UNIFORMS
      GL_MAX_TESS_CONTROL_INPUT_COMPONENTS
      GL_MAX_TESS_CONTROL_OUTPUT_COMPONENTS
      GL_MAX_TESS_CONTROL_SHADER_STORAGE_BLOCKS
      GL_MAX_TESS_CONTROL_TEXTURE_IMAGE_UNITS
      GL_MAX_TESS_CONTROL_TOTAL_OUTPUT_COMPONENTS
      GL_MAX_TESS_CONTROL_UNIFORM_BLOCKS
      GL_MAX_TESS_CONTROL_UNIFORM_COMPONENTS
      GL_MAX_TESS_EVALUATION_ATOMIC_COUNTERS
      GL_MAX_TESS_EVALUATION_ATOMIC_COUNTER_BUFFERS
      GL_MAX_TESS_EVALUATION_IMAGE_UNIFORMS
      GL_MAX_TESS_EVALUATION_INPUT_COMPONENTS
      GL_MAX_TESS_EVALUATION_OUTPUT_COMPONENTS
      GL_MAX_TESS_EVALUATION_SHADER_STORAGE_BLOCKS
      GL_MAX_TESS_EVALUATION_TEXTURE_IMAGE_UNITS
      GL_MAX_TESS_EVALUATION_UNIFORM_BLOCKS
      GL_MAX_TESS_EVALUATION_UNIFORM_COMPONENTS
      GL_MAX_TESS_GEN_LEVEL
      GL_MAX_TESS_PATCH_COMPONENTS
      GL_MAX_TEXTURE_BUFFER_SIZE
      GL_MAX_TEXTURE_BUFFER_SIZE_ARB
      GL_MAX_TEXTURE_BUFFER_SIZE_EXT
      GL_MAX_TEXTURE_COORDS
      GL_MAX_TEXTURE_COORDS_ARB
      GL_MAX_TEXTURE_COORDS_NV
      GL_MAX_TEXTURE_IMAGE_UNITS
      GL_MAX_TEXTURE_IMAGE_UNITS_ARB
      GL_MAX_TEXTURE_IMAGE_UNITS_NV
      GL_MAX_TEXTURE_LOD_BIAS
      GL_MAX_TEXTURE_LOD_BIAS_EXT
      GL_MAX_TEXTURE_MAX_ANISOTROPY_EXT
      GL_MAX_TEXTURE_SIZE
      GL_MAX_TEXTURE_STACK_DEPTH
      GL_MAX_TEXTURE_UNITS
      GL_MAX_TEXTURE_UNITS_ARB
      GL_MAX_TRACK_MATRICES_NV
      GL_MAX_TRACK_MATRIX_STACK_DEPTH_NV
      GL_MAX_TRANSFORM_FEEDBACK_BUFFERS
      GL_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS
      GL_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS_EXT
      GL_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS_NV
      GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS
      GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS_EXT
      GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS_NV
      GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS
      GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS_EXT
      GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS_NV
      GL_MAX_UNIFORM_BLOCK_SIZE
      GL_MAX_UNIFORM_BUFFER_BINDINGS
      GL_MAX_UNIFORM_LOCATIONS
      GL_MAX_VARYING_COMPONENTS
      GL_MAX_VARYING_COMPONENTS_EXT
      GL_MAX_VARYING_FLOATS
      GL_MAX_VARYING_FLOATS_ARB
      GL_MAX_VARYING_VECTORS
      GL_MAX_VERTEX_ARRAY_RANGE_ELEMENT_APPLE
      GL_MAX_VERTEX_ARRAY_RANGE_ELEMENT_NV
      GL_MAX_VERTEX_ATOMIC_COUNTERS
      GL_MAX_VERTEX_ATOMIC_COUNTER_BUFFERS
      GL_MAX_VERTEX_ATTRIBS
      GL_MAX_VERTEX_ATTRIBS_ARB
      GL_MAX_VERTEX_ATTRIB_BINDINGS
      GL_MAX_VERTEX_ATTRIB_RELATIVE_OFFSET
      GL_MAX_VERTEX_ATTRIB_STRIDE
      GL_MAX_VERTEX_BINDABLE_UNIFORMS_EXT
      GL_MAX_VERTEX_HINT_PGI
      GL_MAX_VERTEX_IMAGE_UNIFORMS
      GL_MAX_VERTEX_OUTPUT_COMPONENTS
      GL_MAX_VERTEX_SHADER_INSTRUCTIONS_EXT
      GL_MAX_VERTEX_SHADER_INVARIANTS_EXT
      GL_MAX_VERTEX_SHADER_LOCALS_EXT
      GL_MAX_VERTEX_SHADER_LOCAL_CONSTANTS_EXT
      GL_MAX_VERTEX_SHADER_STORAGE_BLOCKS
      GL_MAX_VERTEX_SHADER_VARIANTS_EXT
      GL_MAX_VERTEX_STREAMS
      GL_MAX_VERTEX_STREAMS_ATI
      GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS
      GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS_ARB
      GL_MAX_VERTEX_UNIFORM_BLOCKS
      GL_MAX_VERTEX_UNIFORM_COMPONENTS
      GL_MAX_VERTEX_UNIFORM_COMPONENTS_ARB
      GL_MAX_VERTEX_UNIFORM_VECTORS
      GL_MAX_VERTEX_UNITS_ARB
      GL_MAX_VERTEX_VARYING_COMPONENTS_ARB
      GL_MAX_VERTEX_VARYING_COMPONENTS_EXT
      GL_MAX_VIEWPORTS
      GL_MAX_VIEWPORT_DIMS
      GL_MAX_VIEWS_OVR
      GL_MAX_WIDTH
      GL_MAX_WINDOW_RECTANGLES_EXT
      GL_MEDIUM_FLOAT
      GL_MEDIUM_INT
      GL_MESAX_texture_stack
      GL_MESA_pack_invert
      GL_MESA_resize_buffers
      GL_MESA_shader_integer_functions
      GL_MESA_window_pos
      GL_MESA_ycbcr_texture
      GL_MIN
      GL_MINMAX
      GL_MINMAX_EXT
      GL_MINMAX_FORMAT
      GL_MINMAX_FORMAT_EXT
      GL_MINMAX_SINK
      GL_MINMAX_SINK_EXT
      GL_MINOR_VERSION
      GL_MINUS_CLAMPED_NV
      GL_MINUS_NV
      GL_MIN_ALPHA_SGIS
      GL_MIN_BLUE_SGIS
      GL_MIN_EXT
      GL_MIN_FRAGMENT_INTERPOLATION_OFFSET
      GL_MIN_FRAGMENT_INTERPOLATION_OFFSET_NV
      GL_MIN_GREEN_SGIS
      GL_MIN_INTENSITY_SGIS
      GL_MIN_LOD_WARNING_AMD
      GL_MIN_LUMINANCE_SGIS
      GL_MIN_MAP_BUFFER_ALIGNMENT
      GL_MIN_PBUFFER_VIEWPORT_DIMS_APPLE
      GL_MIN_PROGRAM_TEXEL_OFFSET
      GL_MIN_PROGRAM_TEXEL_OFFSET_NV
      GL_MIN_PROGRAM_TEXTURE_GATHER_OFFSET
      GL_MIN_PROGRAM_TEXTURE_GATHER_OFFSET_ARB
      GL_MIN_PROGRAM_TEXTURE_GATHER_OFFSET_NV
      GL_MIN_RED_SGIS
      GL_MIN_SAMPLE_SHADING_VALUE
      GL_MIN_SAMPLE_SHADING_VALUE_ARB
      GL_MIN_SPARSE_LEVEL_AMD
      GL_MIPMAP
      GL_MIRRORED_REPEAT
      GL_MIRRORED_REPEAT_ARB
      GL_MIRRORED_REPEAT_IBM
      GL_MIRROR_CLAMP_ATI
      GL_MIRROR_CLAMP_EXT
      GL_MIRROR_CLAMP_TO_BORDER_EXT
      GL_MIRROR_CLAMP_TO_EDGE
      GL_MIRROR_CLAMP_TO_EDGE_ATI
      GL_MIRROR_CLAMP_TO_EDGE_EXT
      GL_MISSING_REGAL
      GL_MITER_REVERT_NV
      GL_MITER_TRUNCATE_NV
      GL_MIXED_DEPTH_SAMPLES_SUPPORTED_NV
      GL_MIXED_STENCIL_SAMPLES_SUPPORTED_NV
      GL_MODELVIEW
      GL_MODELVIEW0_ARB
      GL_MODELVIEW0_EXT
      GL_MODELVIEW0_MATRIX_EXT
      GL_MODELVIEW0_STACK_DEPTH_EXT
      GL_MODELVIEW10_ARB
      GL_MODELVIEW11_ARB
      GL_MODELVIEW12_ARB
      GL_MODELVIEW13_ARB
      GL_MODELVIEW14_ARB
      GL_MODELVIEW15_ARB
      GL_MODELVIEW16_ARB
      GL_MODELVIEW17_ARB
      GL_MODELVIEW18_ARB
      GL_MODELVIEW19_ARB
      GL_MODELVIEW1_ARB
      GL_MODELVIEW1_EXT
      GL_MODELVIEW1_MATRIX_EXT
      GL_MODELVIEW1_STACK_DEPTH_EXT
      GL_MODELVIEW20_ARB
      GL_MODELVIEW21_ARB
      GL_MODELVIEW22_ARB
      GL_MODELVIEW23_ARB
      GL_MODELVIEW24_ARB
      GL_MODELVIEW25_ARB
      GL_MODELVIEW26_ARB
      GL_MODELVIEW27_ARB
      GL_MODELVIEW28_ARB
      GL_MODELVIEW29_ARB
      GL_MODELVIEW2_ARB
      GL_MODELVIEW30_ARB
      GL_MODELVIEW31_ARB
      GL_MODELVIEW3_ARB
      GL_MODELVIEW4_ARB
      GL_MODELVIEW5_ARB
      GL_MODELVIEW6_ARB
      GL_MODELVIEW7_ARB
      GL_MODELVIEW8_ARB
      GL_MODELVIEW9_ARB
      GL_MODELVIEW_MATRIX
      GL_MODELVIEW_PROJECTION_NV
      GL_MODELVIEW_STACK_DEPTH
      GL_MODULATE
      GL_MODULATE_ADD_ATI
      GL_MODULATE_ADD_ATIX
      GL_MODULATE_SIGNED_ADD_ATI
      GL_MODULATE_SIGNED_ADD_ATIX
      GL_MODULATE_SUBTRACT_ATI
      GL_MODULATE_SUBTRACT_ATIX
      GL_MOVE_TO_CONTINUES_NV
      GL_MOVE_TO_NV
      GL_MOVE_TO_RESETS_NV
      GL_MOV_ATI
      GL_MULT
      GL_MULTICAST_GPUS_NV
      GL_MULTICAST_PROGRAMMABLE_SAMPLE_LOCATION_NV
      GL_MULTIPLY_KHR
      GL_MULTIPLY_NV
      GL_MULTISAMPLE
      GL_MULTISAMPLES_NV
      GL_MULTISAMPLE_3DFX
      GL_MULTISAMPLE_ARB
      GL_MULTISAMPLE_BIT
      GL_MULTISAMPLE_BIT_3DFX
      GL_MULTISAMPLE_BIT_ARB
      GL_MULTISAMPLE_BIT_EXT
      GL_MULTISAMPLE_COVERAGE_MODES_NV
      GL_MULTISAMPLE_EXT
      GL_MULTISAMPLE_FILTER_HINT_NV
      GL_MULTISAMPLE_LINE_WIDTH_GRANULARITY_ARB
      GL_MULTISAMPLE_LINE_WIDTH_RANGE_ARB
      GL_MULTISAMPLE_RASTERIZATION_ALLOWED_EXT
      GL_MULTISAMPLE_SGIS
      GL_MUL_ATI
      GL_MVP_MATRIX_EXT
      GL_N3F_V3F
      GL_NAMED_STRING_LENGTH_ARB
      GL_NAMED_STRING_TYPE_ARB
      GL_NAME_LENGTH
      GL_NAME_STACK_DEPTH
      GL_NAND
      GL_NATIVE_GRAPHICS_BEGIN_HINT_PGI
      GL_NATIVE_GRAPHICS_END_HINT_PGI
      GL_NATIVE_GRAPHICS_HANDLE_PGI
      GL_NEAREST
      GL_NEAREST_MIPMAP_LINEAR
      GL_NEAREST_MIPMAP_NEAREST
      GL_NEGATE_BIT_ATI
      GL_NEGATIVE_ONE_EXT
      GL_NEGATIVE_ONE_TO_ONE
      GL_NEGATIVE_W_EXT
      GL_NEGATIVE_X_EXT
      GL_NEGATIVE_Y_EXT
      GL_NEGATIVE_Z_EXT
      GL_NEVER
      GL_NEXT_VIDEO_CAPTURE_BUFFER_STATUS_NV
      GL_NICEST
      GL_NONE
      GL_NOOP
      GL_NOP_COMMAND_NV
      GL_NOR
      GL_NORMALIZE
      GL_NORMALIZED_RANGE_EXT
      GL_NORMAL_ARRAY
      GL_NORMAL_ARRAY_ADDRESS_NV
      GL_NORMAL_ARRAY_BUFFER_BINDING
      GL_NORMAL_ARRAY_BUFFER_BINDING_ARB
      GL_NORMAL_ARRAY_COUNT_EXT
      GL_NORMAL_ARRAY_EXT
      GL_NORMAL_ARRAY_LENGTH_NV
      GL_NORMAL_ARRAY_LIST_IBM
      GL_NORMAL_ARRAY_LIST_STRIDE_IBM
      GL_NORMAL_ARRAY_PARALLEL_POINTERS_INTEL
      GL_NORMAL_ARRAY_POINTER
      GL_NORMAL_ARRAY_POINTER_EXT
      GL_NORMAL_ARRAY_STRIDE
      GL_NORMAL_ARRAY_STRIDE_EXT
      GL_NORMAL_ARRAY_TYPE
      GL_NORMAL_ARRAY_TYPE_EXT
      GL_NORMAL_BIT_PGI
      GL_NORMAL_MAP
      GL_NORMAL_MAP_ARB
      GL_NORMAL_MAP_EXT
      GL_NORMAL_MAP_NV
      GL_NOTEQUAL
      GL_NO_ERROR
      GL_NO_RESET_NOTIFICATION
      GL_NO_RESET_NOTIFICATION_ARB
      GL_NUM_ACTIVE_VARIABLES
      GL_NUM_COMPATIBLE_SUBROUTINES
      GL_NUM_COMPRESSED_TEXTURE_FORMATS
      GL_NUM_COMPRESSED_TEXTURE_FORMATS_ARB
      GL_NUM_EXTENSIONS
      GL_NUM_FILL_STREAMS_NV
      GL_NUM_FRAGMENT_CONSTANTS_ATI
      GL_NUM_FRAGMENT_REGISTERS_ATI
      GL_NUM_GENERAL_COMBINERS_NV
      GL_NUM_INPUT_INTERPOLATOR_COMPONENTS_ATI
      GL_NUM_INSTRUCTIONS_PER_PASS_ATI
      GL_NUM_INSTRUCTIONS_TOTAL_ATI
      GL_NUM_LOOPBACK_COMPONENTS_ATI
      GL_NUM_PASSES_ATI
      GL_NUM_PROGRAM_BINARY_FORMATS
      GL_NUM_SAMPLE_COUNTS
      GL_NUM_SHADER_BINARY_FORMATS
      GL_NUM_SHADING_LANGUAGE_VERSIONS
      GL_NUM_SPARSE_LEVELS_ARB
      GL_NUM_VIDEO_CAPTURE_STREAMS_NV
      GL_NUM_VIRTUAL_PAGE_SIZES_ARB
      GL_NUM_WINDOW_RECTANGLES_EXT
      GL_NVX_blend_equation_advanced_multi_draw_buffers
      GL_NVX_conditional_render
      GL_NVX_gpu_memory_info
      GL_NVX_linked_gpu_multicast
      GL_NV_bindless_multi_draw_indirect
      GL_NV_bindless_multi_draw_indirect_count
      GL_NV_bindless_texture
      GL_NV_blend_equation_advanced
      GL_NV_blend_equation_advanced_coherent
      GL_NV_blend_square
      GL_NV_clip_space_w_scaling
      GL_NV_command_list
      GL_NV_compute_program5
      GL_NV_conditional_render
      GL_NV_conservative_raster
      GL_NV_conservative_raster_dilate
      GL_NV_conservative_raster_pre_snap_triangles
      GL_NV_copy_depth_to_color
      GL_NV_copy_image
      GL_NV_deep_texture3D
      GL_NV_depth_buffer_float
      GL_NV_depth_clamp
      GL_NV_depth_range_unclamped
      GL_NV_draw_texture
      GL_NV_draw_vulkan_image
      GL_NV_evaluators
      GL_NV_explicit_multisample
      GL_NV_fence
      GL_NV_fill_rectangle
      GL_NV_float_buffer
      GL_NV_fog_distance
      GL_NV_fragment_coverage_to_color
      GL_NV_fragment_program
      GL_NV_fragment_program2
      GL_NV_fragment_program4
      GL_NV_fragment_program_option
      GL_NV_fragment_shader_interlock
      GL_NV_framebuffer_mixed_samples
      GL_NV_framebuffer_multisample_coverage
      GL_NV_geometry_program4
      GL_NV_geometry_shader4
      GL_NV_geometry_shader_passthrough
      GL_NV_gpu_multicast
      GL_NV_gpu_program4
      GL_NV_gpu_program5
      GL_NV_gpu_program5_mem_extended
      GL_NV_gpu_program_fp64
      GL_NV_gpu_shader5
      GL_NV_half_float
      GL_NV_internalformat_sample_query
      GL_NV_light_max_exponent
      GL_NV_multisample_coverage
      GL_NV_multisample_filter_hint
      GL_NV_occlusion_query
      GL_NV_packed_depth_stencil
      GL_NV_parameter_buffer_object
      GL_NV_parameter_buffer_object2
      GL_NV_path_rendering
      GL_NV_path_rendering_shared_edge
      GL_NV_pixel_data_range
      GL_NV_point_sprite
      GL_NV_present_video
      GL_NV_primitive_restart
      GL_NV_register_combiners
      GL_NV_register_combiners2
      GL_NV_robustness_video_memory_purge
      GL_NV_sample_locations
      GL_NV_sample_mask_override_coverage
      GL_NV_shader_atomic_counters
      GL_NV_shader_atomic_float
      GL_NV_shader_atomic_float64
      GL_NV_shader_atomic_fp16_vector
      GL_NV_shader_atomic_int64
      GL_NV_shader_buffer_load
      GL_NV_shader_storage_buffer_object
      GL_NV_shader_thread_group
      GL_NV_shader_thread_shuffle
      GL_NV_stereo_view_rendering
      GL_NV_tessellation_program5
      GL_NV_texgen_emboss
      GL_NV_texgen_reflection
      GL_NV_texture_barrier
      GL_NV_texture_compression_vtc
      GL_NV_texture_env_combine4
      GL_NV_texture_expand_normal
      GL_NV_texture_multisample
      GL_NV_texture_rectangle
      GL_NV_texture_shader
      GL_NV_texture_shader2
      GL_NV_texture_shader3
      GL_NV_transform_feedback
      GL_NV_transform_feedback2
      GL_NV_uniform_buffer_unified_memory
      GL_NV_vdpau_interop
      GL_NV_vertex_array_range
      GL_NV_vertex_array_range2
      GL_NV_vertex_attrib_integer_64bit
      GL_NV_vertex_buffer_unified_memory
      GL_NV_vertex_program
      GL_NV_vertex_program1_1
      GL_NV_vertex_program2
      GL_NV_vertex_program2_option
      GL_NV_vertex_program3
      GL_NV_vertex_program4
      GL_NV_video_capture
      GL_NV_viewport_array2
      GL_NV_viewport_swizzle
      GL_OBJECT_ACTIVE_ATTRIBUTES_ARB
      GL_OBJECT_ACTIVE_ATTRIBUTE_MAX_LENGTH_ARB
      GL_OBJECT_ACTIVE_UNIFORMS_ARB
      GL_OBJECT_ACTIVE_UNIFORM_MAX_LENGTH_ARB
      GL_OBJECT_ATTACHED_OBJECTS_ARB
      GL_OBJECT_BUFFER_SIZE_ATI
      GL_OBJECT_BUFFER_USAGE_ATI
      GL_OBJECT_COMPILE_STATUS_ARB
      GL_OBJECT_DELETE_STATUS_ARB
      GL_OBJECT_DISTANCE_TO_LINE_SGIS
      GL_OBJECT_DISTANCE_TO_POINT_SGIS
      GL_OBJECT_INFO_LOG_LENGTH_ARB
      GL_OBJECT_LINEAR
      GL_OBJECT_LINE_SGIS
      GL_OBJECT_LINK_STATUS_ARB
      GL_OBJECT_PLANE
      GL_OBJECT_POINT_SGIS
      GL_OBJECT_SHADER_SOURCE_LENGTH_ARB
      GL_OBJECT_SUBTYPE_ARB
      GL_OBJECT_TYPE
      GL_OBJECT_TYPE_ARB
      GL_OBJECT_VALIDATE_STATUS_ARB
      GL_OCCLUSION_QUERY_EVENT_MASK_AMD
      GL_OES_byte_coordinates
      GL_OES_compressed_paletted_texture
      GL_OES_read_format
      GL_OES_single_precision
      GL_OFFSET
      GL_OFFSET_HILO_PROJECTIVE_TEXTURE_2D_NV
      GL_OFFSET_HILO_PROJECTIVE_TEXTURE_RECTANGLE_NV
      GL_OFFSET_HILO_TEXTURE_2D_NV
      GL_OFFSET_HILO_TEXTURE_RECTANGLE_NV
      GL_OFFSET_PROJECTIVE_TEXTURE_2D_NV
      GL_OFFSET_PROJECTIVE_TEXTURE_2D_SCALE_NV
      GL_OFFSET_PROJECTIVE_TEXTURE_RECTANGLE_NV
      GL_OFFSET_PROJECTIVE_TEXTURE_RECTANGLE_SCALE_NV
      GL_OFFSET_TEXTURE_2D_BIAS_NV
      GL_OFFSET_TEXTURE_2D_MATRIX_NV
      GL_OFFSET_TEXTURE_2D_NV
      GL_OFFSET_TEXTURE_2D_SCALE_NV
      GL_OFFSET_TEXTURE_BIAS_NV
      GL_OFFSET_TEXTURE_MATRIX_NV
      GL_OFFSET_TEXTURE_RECTANGLE_NV
      GL_OFFSET_TEXTURE_RECTANGLE_SCALE_NV
      GL_OFFSET_TEXTURE_SCALE_NV
      GL_OML_interlace
      GL_OML_resample
      GL_OML_subsample
      GL_ONE
      GL_ONE_EXT
      GL_ONE_MINUS_CONSTANT_ALPHA
      GL_ONE_MINUS_CONSTANT_ALPHA_EXT
      GL_ONE_MINUS_CONSTANT_COLOR
      GL_ONE_MINUS_CONSTANT_COLOR_EXT
      GL_ONE_MINUS_DST_ALPHA
      GL_ONE_MINUS_DST_COLOR
      GL_ONE_MINUS_SRC1_ALPHA
      GL_ONE_MINUS_SRC1_COLOR
      GL_ONE_MINUS_SRC_ALPHA
      GL_ONE_MINUS_SRC_COLOR
      GL_OPERAND0_ALPHA
      GL_OPERAND0_ALPHA_ARB
      GL_OPERAND0_ALPHA_EXT
      GL_OPERAND0_RGB
      GL_OPERAND0_RGB_ARB
      GL_OPERAND0_RGB_EXT
      GL_OPERAND1_ALPHA
      GL_OPERAND1_ALPHA_ARB
      GL_OPERAND1_ALPHA_EXT
      GL_OPERAND1_RGB
      GL_OPERAND1_RGB_ARB
      GL_OPERAND1_RGB_EXT
      GL_OPERAND2_ALPHA
      GL_OPERAND2_ALPHA_ARB
      GL_OPERAND2_ALPHA_EXT
      GL_OPERAND2_RGB
      GL_OPERAND2_RGB_ARB
      GL_OPERAND2_RGB_EXT
      GL_OPERAND3_ALPHA_NV
      GL_OPERAND3_RGB_NV
      GL_OP_ADD_EXT
      GL_OP_CLAMP_EXT
      GL_OP_CROSS_PRODUCT_EXT
      GL_OP_DOT3_EXT
      GL_OP_DOT4_EXT
      GL_OP_EXP_BASE_2_EXT
      GL_OP_FLOOR_EXT
      GL_OP_FRAC_EXT
      GL_OP_INDEX_EXT
      GL_OP_LOG_BASE_2_EXT
      GL_OP_MADD_EXT
      GL_OP_MAX_EXT
      GL_OP_MIN_EXT
      GL_OP_MOV_EXT
      GL_OP_MULTIPLY_MATRIX_EXT
      GL_OP_MUL_EXT
      GL_OP_NEGATE_EXT
      GL_OP_POWER_EXT
      GL_OP_RECIP_EXT
      GL_OP_RECIP_SQRT_EXT
      GL_OP_ROUND_EXT
      GL_OP_SET_GE_EXT
      GL_OP_SET_LT_EXT
      GL_OP_SUB_EXT
      GL_OR
      GL_ORDER
      GL_OR_INVERTED
      GL_OR_REVERSE
      GL_OUTPUT_COLOR0_EXT
      GL_OUTPUT_COLOR1_EXT
      GL_OUTPUT_FOG_EXT
      GL_OUTPUT_POINT_SIZE_ATIX
      GL_OUTPUT_TEXTURE_COORD0_EXT
      GL_OUTPUT_TEXTURE_COORD10_EXT
      GL_OUTPUT_TEXTURE_COORD11_EXT
      GL_OUTPUT_TEXTURE_COORD12_EXT
      GL_OUTPUT_TEXTURE_COORD13_EXT
      GL_OUTPUT_TEXTURE_COORD14_EXT
      GL_OUTPUT_TEXTURE_COORD15_EXT
      GL_OUTPUT_TEXTURE_COORD16_EXT
      GL_OUTPUT_TEXTURE_COORD17_EXT
      GL_OUTPUT_TEXTURE_COORD18_EXT
      GL_OUTPUT_TEXTURE_COORD19_EXT
      GL_OUTPUT_TEXTURE_COORD1_EXT
      GL_OUTPUT_TEXTURE_COORD20_EXT
      GL_OUTPUT_TEXTURE_COORD21_EXT
      GL_OUTPUT_TEXTURE_COORD22_EXT
      GL_OUTPUT_TEXTURE_COORD23_EXT
      GL_OUTPUT_TEXTURE_COORD24_EXT
      GL_OUTPUT_TEXTURE_COORD25_EXT
      GL_OUTPUT_TEXTURE_COORD26_EXT
      GL_OUTPUT_TEXTURE_COORD27_EXT
      GL_OUTPUT_TEXTURE_COORD28_EXT
      GL_OUTPUT_TEXTURE_COORD29_EXT
      GL_OUTPUT_TEXTURE_COORD2_EXT
      GL_OUTPUT_TEXTURE_COORD30_EXT
      GL_OUTPUT_TEXTURE_COORD31_EXT
      GL_OUTPUT_TEXTURE_COORD3_EXT
      GL_OUTPUT_TEXTURE_COORD4_EXT
      GL_OUTPUT_TEXTURE_COORD5_EXT
      GL_OUTPUT_TEXTURE_COORD6_EXT
      GL_OUTPUT_TEXTURE_COORD7_EXT
      GL_OUTPUT_TEXTURE_COORD8_EXT
      GL_OUTPUT_TEXTURE_COORD9_EXT
      GL_OUTPUT_VERTEX_EXT
      GL_OUT_OF_MEMORY
      GL_OVERLAY_KHR
      GL_OVERLAY_NV
      GL_OVR_multiview
      GL_OVR_multiview2
      GL_PACK_ALIGNMENT
      GL_PACK_CMYK_HINT_EXT
      GL_PACK_COMPRESSED_BLOCK_DEPTH
      GL_PACK_COMPRESSED_BLOCK_HEIGHT
      GL_PACK_COMPRESSED_BLOCK_SIZE
      GL_PACK_COMPRESSED_BLOCK_WIDTH
      GL_PACK_IMAGE_HEIGHT
      GL_PACK_IMAGE_HEIGHT_EXT
      GL_PACK_INVERT_MESA
      GL_PACK_LSB_FIRST
      GL_PACK_RESAMPLE_OML
      GL_PACK_RESAMPLE_SGIX
      GL_PACK_REVERSE_ROW_ORDER_ANGLE
      GL_PACK_ROW_BYTES_APPLE
      GL_PACK_ROW_LENGTH
      GL_PACK_SKIP_IMAGES
      GL_PACK_SKIP_IMAGES_EXT
      GL_PACK_SKIP_PIXELS
      GL_PACK_SKIP_ROWS
      GL_PACK_SWAP_BYTES
      GL_PALETTE4_R5_G6_B5_OES
      GL_PALETTE4_RGB5_A1_OES
      GL_PALETTE4_RGB8_OES
      GL_PALETTE4_RGBA4_OES
      GL_PALETTE4_RGBA8_OES
      GL_PALETTE8_R5_G6_B5_OES
      GL_PALETTE8_RGB5_A1_OES
      GL_PALETTE8_RGB8_OES
      GL_PALETTE8_RGBA4_OES
      GL_PALETTE8_RGBA8_OES
      GL_PARALLEL_ARRAYS_INTEL
      GL_PARAMETER_BUFFER_ARB
      GL_PARAMETER_BUFFER_BINDING_ARB
      GL_PARTIAL_SUCCESS_NV
      GL_PASS_THROUGH_NV
      GL_PASS_THROUGH_TOKEN
      GL_PATCHES
      GL_PATCH_DEFAULT_INNER_LEVEL
      GL_PATCH_DEFAULT_OUTER_LEVEL
      GL_PATCH_VERTICES
      GL_PATH_CLIENT_LENGTH_NV
      GL_PATH_COMMAND_COUNT_NV
      GL_PATH_COMPUTED_LENGTH_NV
      GL_PATH_COORD_COUNT_NV
      GL_PATH_COVER_DEPTH_FUNC_NV
      GL_PATH_DASH_ARRAY_COUNT_NV
      GL_PATH_DASH_CAPS_NV
      GL_PATH_DASH_OFFSET_NV
      GL_PATH_DASH_OFFSET_RESET_NV
      GL_PATH_END_CAPS_NV
      GL_PATH_ERROR_POSITION_NV
      GL_PATH_FILL_BOUNDING_BOX_NV
      GL_PATH_FILL_COVER_MODE_NV
      GL_PATH_FILL_MASK_NV
      GL_PATH_FILL_MODE_NV
      GL_PATH_FOG_GEN_MODE_NV
      GL_PATH_FORMAT_PS_NV
      GL_PATH_FORMAT_SVG_NV
      GL_PATH_GEN_COEFF_NV
      GL_PATH_GEN_COLOR_FORMAT_NV
      GL_PATH_GEN_COMPONENTS_NV
      GL_PATH_GEN_MODE_NV
      GL_PATH_INITIAL_DASH_CAP_NV
      GL_PATH_INITIAL_END_CAP_NV
      GL_PATH_JOIN_STYLE_NV
      GL_PATH_MITER_LIMIT_NV
      GL_PATH_OBJECT_BOUNDING_BOX_NV
      GL_PATH_STENCIL_DEPTH_OFFSET_FACTOR_NV
      GL_PATH_STENCIL_DEPTH_OFFSET_UNITS_NV
      GL_PATH_STENCIL_FUNC_NV
      GL_PATH_STENCIL_REF_NV
      GL_PATH_STENCIL_VALUE_MASK_NV
      GL_PATH_STROKE_BOUNDING_BOX_NV
      GL_PATH_STROKE_BOUND_NV
      GL_PATH_STROKE_COVER_MODE_NV
      GL_PATH_STROKE_MASK_NV
      GL_PATH_STROKE_WIDTH_NV
      GL_PATH_TERMINAL_DASH_CAP_NV
      GL_PATH_TERMINAL_END_CAP_NV
      GL_PERCENTAGE_AMD
      GL_PERFMON_RESULT_AMD
      GL_PERFMON_RESULT_AVAILABLE_AMD
      GL_PERFMON_RESULT_SIZE_AMD
      GL_PERFORMANCE_MONITOR_AMD
      GL_PERFQUERY_COUNTER_DATA_BOOL32_INTEL
      GL_PERFQUERY_COUNTER_DATA_DOUBLE_INTEL
      GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL
      GL_PERFQUERY_COUNTER_DATA_UINT32_INTEL
      GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL
      GL_PERFQUERY_COUNTER_DESC_LENGTH_MAX_INTEL
      GL_PERFQUERY_COUNTER_DURATION_NORM_INTEL
      GL_PERFQUERY_COUNTER_DURATION_RAW_INTEL
      GL_PERFQUERY_COUNTER_EVENT_INTEL
      GL_PERFQUERY_COUNTER_NAME_LENGTH_MAX_INTEL
      GL_PERFQUERY_COUNTER_RAW_INTEL
      GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL
      GL_PERFQUERY_COUNTER_TIMESTAMP_INTEL
      GL_PERFQUERY_DONOT_FLUSH_INTEL
      GL_PERFQUERY_FLUSH_INTEL
      GL_PERFQUERY_GLOBAL_CONTEXT_INTEL
      GL_PERFQUERY_GPA_EXTENDED_COUNTERS_INTEL
      GL_PERFQUERY_QUERY_NAME_LENGTH_MAX_INTEL
      GL_PERFQUERY_SINGLE_CONTEXT_INTEL
      GL_PERFQUERY_WAIT_INTEL
      GL_PERSPECTIVE_CORRECTION_HINT
      GL_PERTURB_EXT
      GL_PER_GPU_STORAGE_BIT_NV
      GL_PER_GPU_STORAGE_NV
      GL_PER_STAGE_CONSTANTS_NV
      GL_PGI_misc_hints
      GL_PGI_vertex_hints
      GL_PHONG_HINT_WIN
      GL_PHONG_WIN
      GL_PINLIGHT_NV
      GL_PIXEL_BUFFER_BARRIER_BIT
      GL_PIXEL_BUFFER_BARRIER_BIT_EXT
      GL_PIXEL_COUNTER_BITS_NV
      GL_PIXEL_COUNT_AVAILABLE_NV
      GL_PIXEL_COUNT_NV
      GL_PIXEL_CUBIC_WEIGHT_EXT
      GL_PIXEL_MAG_FILTER_EXT
      GL_PIXEL_MAP_A_TO_A
      GL_PIXEL_MAP_A_TO_A_SIZE
      GL_PIXEL_MAP_B_TO_B
      GL_PIXEL_MAP_B_TO_B_SIZE
      GL_PIXEL_MAP_G_TO_G
      GL_PIXEL_MAP_G_TO_G_SIZE
      GL_PIXEL_MAP_I_TO_A
      GL_PIXEL_MAP_I_TO_A_SIZE
      GL_PIXEL_MAP_I_TO_B
      GL_PIXEL_MAP_I_TO_B_SIZE
      GL_PIXEL_MAP_I_TO_G
      GL_PIXEL_MAP_I_TO_G_SIZE
      GL_PIXEL_MAP_I_TO_I
      GL_PIXEL_MAP_I_TO_I_SIZE
      GL_PIXEL_MAP_I_TO_R
      GL_PIXEL_MAP_I_TO_R_SIZE
      GL_PIXEL_MAP_R_TO_R
      GL_PIXEL_MAP_R_TO_R_SIZE
      GL_PIXEL_MAP_S_TO_S
      GL_PIXEL_MAP_S_TO_S_SIZE
      GL_PIXEL_MIN_FILTER_EXT
      GL_PIXEL_MODE_BIT
      GL_PIXEL_PACK_BUFFER
      GL_PIXEL_PACK_BUFFER_ARB
      GL_PIXEL_PACK_BUFFER_BINDING
      GL_PIXEL_PACK_BUFFER_BINDING_ARB
      GL_PIXEL_PACK_BUFFER_BINDING_EXT
      GL_PIXEL_PACK_BUFFER_EXT
      GL_PIXEL_TRANSFORM_2D_EXT
      GL_PIXEL_TRANSFORM_2D_MATRIX_EXT
      GL_PIXEL_TRANSFORM_2D_STACK_DEPTH_EXT
      GL_PIXEL_UNPACK_BUFFER
      GL_PIXEL_UNPACK_BUFFER_ARB
      GL_PIXEL_UNPACK_BUFFER_BINDING
      GL_PIXEL_UNPACK_BUFFER_BINDING_ARB
      GL_PIXEL_UNPACK_BUFFER_BINDING_EXT
      GL_PIXEL_UNPACK_BUFFER_EXT
      GL_PLUS_CLAMPED_ALPHA_NV
      GL_PLUS_CLAMPED_NV
      GL_PLUS_DARKER_NV
      GL_PLUS_NV
      GL_PN_TRIANGLES_ATI
      GL_PN_TRIANGLES_NORMAL_MODE_ATI
      GL_PN_TRIANGLES_NORMAL_MODE_LINEAR_ATI
      GL_PN_TRIANGLES_NORMAL_MODE_QUADRATIC_ATI
      GL_PN_TRIANGLES_POINT_MODE_ATI
      GL_PN_TRIANGLES_POINT_MODE_CUBIC_ATI
      GL_PN_TRIANGLES_POINT_MODE_LINEAR_ATI
      GL_PN_TRIANGLES_TESSELATION_LEVEL_ATI
      GL_POINT
      GL_POINTS
      GL_POINT_BIT
      GL_POINT_DISTANCE_ATTENUATION
      GL_POINT_DISTANCE_ATTENUATION_ARB
      GL_POINT_FADE_THRESHOLD_SIZE
      GL_POINT_FADE_THRESHOLD_SIZE_ARB
      GL_POINT_FADE_THRESHOLD_SIZE_EXT
      GL_POINT_SIZE
      GL_POINT_SIZE_GRANULARITY
      GL_POINT_SIZE_MAX
      GL_POINT_SIZE_MAX_ARB
      GL_POINT_SIZE_MAX_EXT
      GL_POINT_SIZE_MIN
      GL_POINT_SIZE_MIN_ARB
      GL_POINT_SIZE_MIN_EXT
      GL_POINT_SIZE_RANGE
      GL_POINT_SMOOTH
      GL_POINT_SMOOTH_HINT
      GL_POINT_SPRITE
      GL_POINT_SPRITE_ARB
      GL_POINT_SPRITE_COORD_ORIGIN
      GL_POINT_SPRITE_CULL_CENTER_ATIX
      GL_POINT_SPRITE_CULL_CLIP_ATIX
      GL_POINT_SPRITE_CULL_MODE_ATIX
      GL_POINT_SPRITE_NV
      GL_POINT_SPRITE_R_MODE_NV
      GL_POINT_TOKEN
      GL_POLYGON
      GL_POLYGON_BIT
      GL_POLYGON_MODE
      GL_POLYGON_OFFSET_BIAS_EXT
      GL_POLYGON_OFFSET_CLAMP_EXT
      GL_POLYGON_OFFSET_COMMAND_NV
      GL_POLYGON_OFFSET_EXT
      GL_POLYGON_OFFSET_FACTOR
      GL_POLYGON_OFFSET_FACTOR_EXT
      GL_POLYGON_OFFSET_FILL
      GL_POLYGON_OFFSET_LINE
      GL_POLYGON_OFFSET_POINT
      GL_POLYGON_OFFSET_UNITS
      GL_POLYGON_SMOOTH
      GL_POLYGON_SMOOTH_HINT
      GL_POLYGON_STIPPLE
      GL_POLYGON_STIPPLE_BIT
      GL_POLYGON_TOKEN
      GL_POSITION
      GL_POST_COLOR_MATRIX_ALPHA_BIAS
      GL_POST_COLOR_MATRIX_ALPHA_BIAS_SGI
      GL_POST_COLOR_MATRIX_ALPHA_SCALE
      GL_POST_COLOR_MATRIX_ALPHA_SCALE_SGI
      GL_POST_COLOR_MATRIX_BLUE_BIAS
      GL_POST_COLOR_MATRIX_BLUE_BIAS_SGI
      GL_POST_COLOR_MATRIX_BLUE_SCALE
      GL_POST_COLOR_MATRIX_BLUE_SCALE_SGI
      GL_POST_COLOR_MATRIX_COLOR_TABLE
      GL_POST_COLOR_MATRIX_COLOR_TABLE_SGI
      GL_POST_COLOR_MATRIX_GREEN_BIAS
      GL_POST_COLOR_MATRIX_GREEN_BIAS_SGI
      GL_POST_COLOR_MATRIX_GREEN_SCALE
      GL_POST_COLOR_MATRIX_GREEN_SCALE_SGI
      GL_POST_COLOR_MATRIX_RED_BIAS
      GL_POST_COLOR_MATRIX_RED_BIAS_SGI
      GL_POST_COLOR_MATRIX_RED_SCALE
      GL_POST_COLOR_MATRIX_RED_SCALE_SGI
      GL_POST_CONVOLUTION_ALPHA_BIAS
      GL_POST_CONVOLUTION_ALPHA_BIAS_EXT
      GL_POST_CONVOLUTION_ALPHA_SCALE
      GL_POST_CONVOLUTION_ALPHA_SCALE_EXT
      GL_POST_CONVOLUTION_BLUE_BIAS
      GL_POST_CONVOLUTION_BLUE_BIAS_EXT
      GL_POST_CONVOLUTION_BLUE_SCALE
      GL_POST_CONVOLUTION_BLUE_SCALE_EXT
      GL_POST_CONVOLUTION_COLOR_TABLE
      GL_POST_CONVOLUTION_COLOR_TABLE_SGI
      GL_POST_CONVOLUTION_GREEN_BIAS
      GL_POST_CONVOLUTION_GREEN_BIAS_EXT
      GL_POST_CONVOLUTION_GREEN_SCALE
      GL_POST_CONVOLUTION_GREEN_SCALE_EXT
      GL_POST_CONVOLUTION_RED_BIAS
      GL_POST_CONVOLUTION_RED_BIAS_EXT
      GL_POST_CONVOLUTION_RED_SCALE
      GL_POST_CONVOLUTION_RED_SCALE_EXT
      GL_POST_TEXTURE_FILTER_BIAS_RANGE_SGIX
      GL_POST_TEXTURE_FILTER_BIAS_SGIX
      GL_POST_TEXTURE_FILTER_SCALE_RANGE_SGIX
      GL_POST_TEXTURE_FILTER_SCALE_SGIX
      GL_PREFER_DOUBLEBUFFER_HINT_PGI
      GL_PRESENT_DURATION_NV
      GL_PRESENT_TIME_NV
      GL_PRESERVE_ATI
      GL_PREVIOUS
      GL_PREVIOUS_ARB
      GL_PREVIOUS_EXT
      GL_PREVIOUS_TEXTURE_INPUT_NV
      GL_PRIMARY_COLOR
      GL_PRIMARY_COLOR_ARB
      GL_PRIMARY_COLOR_EXT
      GL_PRIMARY_COLOR_NV
      GL_PRIMITIVES_GENERATED
      GL_PRIMITIVES_GENERATED_EXT
      GL_PRIMITIVES_GENERATED_NV
      GL_PRIMITIVES_SUBMITTED_ARB
      GL_PRIMITIVE_BOUNDING_BOX_ARB
      GL_PRIMITIVE_ID_NV
      GL_PRIMITIVE_RESTART
      GL_PRIMITIVE_RESTART_FIXED_INDEX
      GL_PRIMITIVE_RESTART_FOR_PATCHES_SUPPORTED
      GL_PRIMITIVE_RESTART_INDEX
      GL_PRIMITIVE_RESTART_INDEX_NV
      GL_PRIMITIVE_RESTART_NV
      GL_PROGRAM
      GL_PROGRAMMABLE_SAMPLE_LOCATION_ARB
      GL_PROGRAMMABLE_SAMPLE_LOCATION_NV
      GL_PROGRAMMABLE_SAMPLE_LOCATION_TABLE_SIZE_ARB
      GL_PROGRAMMABLE_SAMPLE_LOCATION_TABLE_SIZE_NV
      GL_PROGRAM_ADDRESS_REGISTERS_ARB
      GL_PROGRAM_ALU_INSTRUCTIONS_ARB
      GL_PROGRAM_ATTRIBS_ARB
      GL_PROGRAM_ATTRIB_COMPONENTS_NV
      GL_PROGRAM_BINARY_ANGLE
      GL_PROGRAM_BINARY_FORMATS
      GL_PROGRAM_BINARY_LENGTH
      GL_PROGRAM_BINARY_RETRIEVABLE_HINT
      GL_PROGRAM_BINDING_ARB
      GL_PROGRAM_ERROR_POSITION_ARB
      GL_PROGRAM_ERROR_POSITION_NV
      GL_PROGRAM_ERROR_STRING_ARB
      GL_PROGRAM_ERROR_STRING_NV
      GL_PROGRAM_FORMAT_ARB
      GL_PROGRAM_FORMAT_ASCII_ARB
      GL_PROGRAM_INPUT
      GL_PROGRAM_INSTRUCTIONS_ARB
      GL_PROGRAM_LENGTH_ARB
      GL_PROGRAM_LENGTH_NV
      GL_PROGRAM_MATRIX_EXT
      GL_PROGRAM_MATRIX_STACK_DEPTH_EXT
      GL_PROGRAM_NATIVE_ADDRESS_REGISTERS_ARB
      GL_PROGRAM_NATIVE_ALU_INSTRUCTIONS_ARB
      GL_PROGRAM_NATIVE_ATTRIBS_ARB
      GL_PROGRAM_NATIVE_INSTRUCTIONS_ARB
      GL_PROGRAM_NATIVE_PARAMETERS_ARB
      GL_PROGRAM_NATIVE_TEMPORARIES_ARB
      GL_PROGRAM_NATIVE_TEX_INDIRECTIONS_ARB
      GL_PROGRAM_NATIVE_TEX_INSTRUCTIONS_ARB
      GL_PROGRAM_OBJECT_ARB
      GL_PROGRAM_OBJECT_EXT
      GL_PROGRAM_OUTPUT
      GL_PROGRAM_PARAMETERS_ARB
      GL_PROGRAM_PARAMETER_NV
      GL_PROGRAM_PIPELINE
      GL_PROGRAM_PIPELINE_BINDING
      GL_PROGRAM_PIPELINE_OBJECT_EXT
      GL_PROGRAM_POINT_SIZE
      GL_PROGRAM_POINT_SIZE_ARB
      GL_PROGRAM_POINT_SIZE_EXT
      GL_PROGRAM_RESIDENT_NV
      GL_PROGRAM_RESULT_COMPONENTS_NV
      GL_PROGRAM_SEPARABLE
      GL_PROGRAM_STRING_ARB
      GL_PROGRAM_STRING_NV
      GL_PROGRAM_TARGET_NV
      GL_PROGRAM_TEMPORARIES_ARB
      GL_PROGRAM_TEX_INDIRECTIONS_ARB
      GL_PROGRAM_TEX_INSTRUCTIONS_ARB
      GL_PROGRAM_UNDER_NATIVE_LIMITS_ARB
      GL_PROJECTION
      GL_PROJECTION_MATRIX
      GL_PROJECTION_STACK_DEPTH
      GL_PROVOKING_VERTEX
      GL_PROVOKING_VERTEX_EXT
      GL_PROXY_COLOR_TABLE
      GL_PROXY_COLOR_TABLE_SGI
      GL_PROXY_HISTOGRAM
      GL_PROXY_HISTOGRAM_EXT
      GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE
      GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE_SGI
      GL_PROXY_POST_CONVOLUTION_COLOR_TABLE
      GL_PROXY_POST_CONVOLUTION_COLOR_TABLE_SGI
      GL_PROXY_TEXTURE_1D
      GL_PROXY_TEXTURE_1D_ARRAY
      GL_PROXY_TEXTURE_1D_ARRAY_EXT
      GL_PROXY_TEXTURE_1D_EXT
      GL_PROXY_TEXTURE_1D_STACK_MESAX
      GL_PROXY_TEXTURE_2D
      GL_PROXY_TEXTURE_2D_ARRAY
      GL_PROXY_TEXTURE_2D_ARRAY_EXT
      GL_PROXY_TEXTURE_2D_EXT
      GL_PROXY_TEXTURE_2D_MULTISAMPLE
      GL_PROXY_TEXTURE_2D_MULTISAMPLE_ARRAY
      GL_PROXY_TEXTURE_2D_STACK_MESAX
      GL_PROXY_TEXTURE_3D
      GL_PROXY_TEXTURE_3D_EXT
      GL_PROXY_TEXTURE_COLOR_TABLE_SGI
      GL_PROXY_TEXTURE_CUBE_MAP
      GL_PROXY_TEXTURE_CUBE_MAP_ARB
      GL_PROXY_TEXTURE_CUBE_MAP_ARRAY
      GL_PROXY_TEXTURE_CUBE_MAP_ARRAY_ARB
      GL_PROXY_TEXTURE_CUBE_MAP_EXT
      GL_PROXY_TEXTURE_RECTANGLE
      GL_PROXY_TEXTURE_RECTANGLE_ARB
      GL_PROXY_TEXTURE_RECTANGLE_EXT
      GL_PROXY_TEXTURE_RECTANGLE_NV
      GL_PURGEABLE_APPLE
      GL_PURGED_CONTEXT_RESET_NV
      GL_Q
      GL_QUADRATIC_ATTENUATION
      GL_QUADRATIC_CURVE_TO_NV
      GL_QUADS
      GL_QUADS_FOLLOW_PROVOKING_VERTEX_CONVENTION
      GL_QUADS_FOLLOW_PROVOKING_VERTEX_CONVENTION_EXT
      GL_QUAD_MESH_SUN
      GL_QUAD_STRIP
      GL_QUARTER_BIT_ATI
      GL_QUERY
      GL_QUERY_ALL_EVENT_BITS_AMD
      GL_QUERY_BUFFER
      GL_QUERY_BUFFER_AMD
      GL_QUERY_BUFFER_BARRIER_BIT
      GL_QUERY_BUFFER_BINDING
      GL_QUERY_BUFFER_BINDING_AMD
      GL_QUERY_BY_REGION_NO_WAIT
      GL_QUERY_BY_REGION_NO_WAIT_INVERTED
      GL_QUERY_BY_REGION_NO_WAIT_NV
      GL_QUERY_BY_REGION_WAIT
      GL_QUERY_BY_REGION_WAIT_INVERTED
      GL_QUERY_BY_REGION_WAIT_NV
      GL_QUERY_COUNTER_BITS
      GL_QUERY_COUNTER_BITS_ANGLE
      GL_QUERY_COUNTER_BITS_ARB
      GL_QUERY_DEPTH_BOUNDS_FAIL_EVENT_BIT_AMD
      GL_QUERY_DEPTH_FAIL_EVENT_BIT_AMD
      GL_QUERY_DEPTH_PASS_EVENT_BIT_AMD
      GL_QUERY_NO_WAIT
      GL_QUERY_NO_WAIT_INVERTED
      GL_QUERY_NO_WAIT_NV
      GL_QUERY_OBJECT_AMD
      GL_QUERY_OBJECT_EXT
      GL_QUERY_RESULT
      GL_QUERY_RESULT_ANGLE
      GL_QUERY_RESULT_ARB
      GL_QUERY_RESULT_AVAILABLE
      GL_QUERY_RESULT_AVAILABLE_ANGLE
      GL_QUERY_RESULT_AVAILABLE_ARB
      GL_QUERY_RESULT_AVAILABLE_NV
      GL_QUERY_RESULT_NO_WAIT
      GL_QUERY_RESULT_NO_WAIT_AMD
      GL_QUERY_RESULT_NV
      GL_QUERY_STENCIL_FAIL_EVENT_BIT_AMD
      GL_QUERY_TARGET
      GL_QUERY_WAIT
      GL_QUERY_WAIT_INVERTED
      GL_QUERY_WAIT_NV
      GL_R
      GL_R11F_G11F_B10F
      GL_R11F_G11F_B10F_EXT
      GL_R16
      GL_R16F
      GL_R16I
      GL_R16UI
      GL_R16_SNORM
      GL_R1UI_C3F_V3F_SUN
      GL_R1UI_C4F_N3F_V3F_SUN
      GL_R1UI_C4UB_V3F_SUN
      GL_R1UI_N3F_V3F_SUN
      GL_R1UI_T2F_C4F_N3F_V3F_SUN
      GL_R1UI_T2F_N3F_V3F_SUN
      GL_R1UI_T2F_V3F_SUN
      GL_R1UI_V3F_SUN
      GL_R32F
      GL_R32I
      GL_R32UI
      GL_R3_G3_B2
      GL_R8
      GL_R8I
      GL_R8UI
      GL_R8_SNORM
      GL_RASTERIZER_DISCARD
      GL_RASTERIZER_DISCARD_EXT
      GL_RASTERIZER_DISCARD_NV
      GL_RASTER_FIXED_SAMPLE_LOCATIONS_EXT
      GL_RASTER_MULTISAMPLE_EXT
      GL_RASTER_POSITION_UNCLIPPED_IBM
      GL_RASTER_SAMPLES_EXT
      GL_READ_BUFFER
      GL_READ_FRAMEBUFFER
      GL_READ_FRAMEBUFFER_ANGLE
      GL_READ_FRAMEBUFFER_BINDING
      GL_READ_FRAMEBUFFER_BINDING_ANGLE
      GL_READ_FRAMEBUFFER_BINDING_EXT
      GL_READ_FRAMEBUFFER_EXT
      GL_READ_ONLY
      GL_READ_ONLY_ARB
      GL_READ_PIXELS
      GL_READ_PIXELS_FORMAT
      GL_READ_PIXELS_TYPE
      GL_READ_PIXEL_DATA_RANGE_LENGTH_NV
      GL_READ_PIXEL_DATA_RANGE_NV
      GL_READ_PIXEL_DATA_RANGE_POINTER_NV
      GL_READ_WRITE
      GL_READ_WRITE_ARB
      GL_RECLAIM_MEMORY_HINT_PGI
      GL_RECT_NV
      GL_RED
      GL_REDUCE
      GL_REDUCE_EXT
      GL_RED_BIAS
      GL_RED_BITS
      GL_RED_BIT_ATI
      GL_RED_INTEGER
      GL_RED_INTEGER_EXT
      GL_RED_MAX_CLAMP_INGR
      GL_RED_MIN_CLAMP_INGR
      GL_RED_NV
      GL_RED_SCALE
      GL_RED_SNORM
      GL_REFERENCED_BY_COMPUTE_SHADER
      GL_REFERENCED_BY_FRAGMENT_SHADER
      GL_REFERENCED_BY_GEOMETRY_SHADER
      GL_REFERENCED_BY_TESS_CONTROL_SHADER
      GL_REFERENCED_BY_TESS_EVALUATION_SHADER
      GL_REFERENCED_BY_VERTEX_SHADER
      GL_REFLECTION_MAP
      GL_REFLECTION_MAP_ARB
      GL_REFLECTION_MAP_EXT
      GL_REFLECTION_MAP_NV
      GL_REGAL_ES1_0_compatibility
      GL_REGAL_ES1_1_compatibility
      GL_REGAL_enable
      GL_REGAL_error_string
      GL_REGAL_extension_query
      GL_REGAL_log
      GL_REGAL_proc_address
      GL_REGISTER_COMBINERS_NV
      GL_REG_0_ATI
      GL_REG_1_ATI
      GL_REG_2_ATI
      GL_REG_3_ATI
      GL_REG_4_ATI
      GL_REG_5_ATI
      GL_RELATIVE_ARC_TO_NV
      GL_RELATIVE_CONIC_CURVE_TO_NV
      GL_RELATIVE_CUBIC_CURVE_TO_NV
      GL_RELATIVE_HORIZONTAL_LINE_TO_NV
      GL_RELATIVE_LARGE_CCW_ARC_TO_NV
      GL_RELATIVE_LARGE_CW_ARC_TO_NV
      GL_RELATIVE_LINE_TO_NV
      GL_RELATIVE_MOVE_TO_NV
      GL_RELATIVE_QUADRATIC_CURVE_TO_NV
      GL_RELATIVE_RECT_NV
      GL_RELATIVE_ROUNDED_RECT2_NV
      GL_RELATIVE_ROUNDED_RECT4_NV
      GL_RELATIVE_ROUNDED_RECT8_NV
      GL_RELATIVE_ROUNDED_RECT_NV
      GL_RELATIVE_SMALL_CCW_ARC_TO_NV
      GL_RELATIVE_SMALL_CW_ARC_TO_NV
      GL_RELATIVE_SMOOTH_CUBIC_CURVE_TO_NV
      GL_RELATIVE_SMOOTH_QUADRATIC_CURVE_TO_NV
      GL_RELATIVE_VERTICAL_LINE_TO_NV
      GL_RELEASED_APPLE
      GL_RENDER
      GL_RENDERBUFFER
      GL_RENDERBUFFER_ALPHA_SIZE
      GL_RENDERBUFFER_ALPHA_SIZE_EXT
      GL_RENDERBUFFER_BINDING
      GL_RENDERBUFFER_BINDING_EXT
      GL_RENDERBUFFER_BLUE_SIZE
      GL_RENDERBUFFER_BLUE_SIZE_EXT
      GL_RENDERBUFFER_COLOR_SAMPLES_NV
      GL_RENDERBUFFER_COVERAGE_SAMPLES_NV
      GL_RENDERBUFFER_DEPTH_SIZE
      GL_RENDERBUFFER_DEPTH_SIZE_EXT
      GL_RENDERBUFFER_EXT
      GL_RENDERBUFFER_FREE_MEMORY_ATI
      GL_RENDERBUFFER_GREEN_SIZE
      GL_RENDERBUFFER_GREEN_SIZE_EXT
      GL_RENDERBUFFER_HEIGHT
      GL_RENDERBUFFER_HEIGHT_EXT
      GL_RENDERBUFFER_INTERNAL_FORMAT
      GL_RENDERBUFFER_INTERNAL_FORMAT_EXT
      GL_RENDERBUFFER_RED_SIZE
      GL_RENDERBUFFER_RED_SIZE_EXT
      GL_RENDERBUFFER_SAMPLES
      GL_RENDERBUFFER_SAMPLES_ANGLE
      GL_RENDERBUFFER_SAMPLES_EXT
      GL_RENDERBUFFER_STENCIL_SIZE
      GL_RENDERBUFFER_STENCIL_SIZE_EXT
      GL_RENDERBUFFER_WIDTH
      GL_RENDERBUFFER_WIDTH_EXT
      GL_RENDERER
      GL_RENDER_GPU_MASK_NV
      GL_RENDER_MODE
      GL_REND_screen_coordinates
      GL_REPEAT
      GL_REPLACE
      GL_REPLACEMENT_CODE_ARRAY_POINTER_SUN
      GL_REPLACEMENT_CODE_ARRAY_STRIDE_SUN
      GL_REPLACEMENT_CODE_ARRAY_SUN
      GL_REPLACEMENT_CODE_ARRAY_TYPE_SUN
      GL_REPLACEMENT_CODE_SUN
      GL_REPLACE_EXT
      GL_REPLACE_MIDDLE_SUN
      GL_REPLACE_OLDEST_SUN
      GL_REPLACE_VALUE_AMD
      GL_REPLICATE_BORDER
      GL_RESAMPLE_AVERAGE_OML
      GL_RESAMPLE_DECIMATE_OML
      GL_RESAMPLE_DECIMATE_SGIX
      GL_RESAMPLE_REPLICATE_OML
      GL_RESAMPLE_REPLICATE_SGIX
      GL_RESAMPLE_ZERO_FILL_OML
      GL_RESAMPLE_ZERO_FILL_SGIX
      GL_RESCALE_NORMAL
      GL_RESCALE_NORMAL_EXT
      GL_RESET_NOTIFICATION_STRATEGY
      GL_RESET_NOTIFICATION_STRATEGY_ARB
      GL_RESTART_PATH_NV
      GL_RESTART_SUN
      GL_RETAINED_APPLE
      GL_RETURN
      GL_RG
      GL_RG16
      GL_RG16F
      GL_RG16I
      GL_RG16UI
      GL_RG16_SNORM
      GL_RG32F
      GL_RG32I
      GL_RG32UI
      GL_RG8
      GL_RG8I
      GL_RG8UI
      GL_RG8_SNORM
      GL_RGB
      GL_RGB10
      GL_RGB10_A2
      GL_RGB10_A2UI
      GL_RGB10_A2_EXT
      GL_RGB10_EXT
      GL_RGB12
      GL_RGB12_EXT
      GL_RGB16
      GL_RGB16F
      GL_RGB16F_ARB
      GL_RGB16I
      GL_RGB16I_EXT
      GL_RGB16UI
      GL_RGB16UI_EXT
      GL_RGB16_EXT
      GL_RGB16_EXTENDED_RANGE_SGIX
      GL_RGB16_SIGNED_SGIX
      GL_RGB16_SNORM
      GL_RGB2_EXT
      GL_RGB32F
      GL_RGB32F_ARB
      GL_RGB32I
      GL_RGB32I_EXT
      GL_RGB32UI
      GL_RGB32UI_EXT
      GL_RGB4
      GL_RGB4_EXT
      GL_RGB4_S3TC
      GL_RGB5
      GL_RGB565
      GL_RGB5_A1
      GL_RGB5_A1_EXT
      GL_RGB5_EXT
      GL_RGB8
      GL_RGB8I
      GL_RGB8I_EXT
      GL_RGB8UI
      GL_RGB8UI_EXT
      GL_RGB8_EXT
      GL_RGB8_SNORM
      GL_RGB9_E5
      GL_RGB9_E5_EXT
      GL_RGBA
      GL_RGBA12
      GL_RGBA12_EXT
      GL_RGBA16
      GL_RGBA16F
      GL_RGBA16F_ARB
      GL_RGBA16I
      GL_RGBA16I_EXT
      GL_RGBA16UI
      GL_RGBA16UI_EXT
      GL_RGBA16_EXT
      GL_RGBA16_EXTENDED_RANGE_SGIX
      GL_RGBA16_SIGNED_SGIX
      GL_RGBA16_SNORM
      GL_RGBA2
      GL_RGBA2_EXT
      GL_RGBA32F
      GL_RGBA32F_ARB
      GL_RGBA32I
      GL_RGBA32I_EXT
      GL_RGBA32UI
      GL_RGBA32UI_EXT
      GL_RGBA4
      GL_RGBA4_DXT5_S3TC
      GL_RGBA4_EXT
      GL_RGBA4_S3TC
      GL_RGBA8
      GL_RGBA8I
      GL_RGBA8I_EXT
      GL_RGBA8UI
      GL_RGBA8UI_EXT
      GL_RGBA8_EXT
      GL_RGBA8_SNORM
      GL_RGBA_DXT5_S3TC
      GL_RGBA_EXTENDED_RANGE_SGIX
      GL_RGBA_FLOAT16_APPLE
      GL_RGBA_FLOAT16_ATI
      GL_RGBA_FLOAT32_APPLE
      GL_RGBA_FLOAT32_ATI
      GL_RGBA_FLOAT_MODE_ARB
      GL_RGBA_INTEGER
      GL_RGBA_INTEGER_EXT
      GL_RGBA_INTEGER_MODE_EXT
      GL_RGBA_MODE
      GL_RGBA_S3TC
      GL_RGBA_SIGNED_COMPONENTS_EXT
      GL_RGBA_SIGNED_SGIX
      GL_RGBA_SNORM
      GL_RGBA_UNSIGNED_DOT_PRODUCT_MAPPING_NV
      GL_RGB_422_APPLE
      GL_RGB_EXTENDED_RANGE_SGIX
      GL_RGB_FLOAT16_APPLE
      GL_RGB_FLOAT16_ATI
      GL_RGB_FLOAT32_APPLE
      GL_RGB_FLOAT32_ATI
      GL_RGB_INTEGER
      GL_RGB_INTEGER_EXT
      GL_RGB_RAW_422_APPLE
      GL_RGB_S3TC
      GL_RGB_SCALE
      GL_RGB_SCALE_ARB
      GL_RGB_SCALE_EXT
      GL_RGB_SIGNED_SGIX
      GL_RGB_SNORM
      GL_RG_INTEGER
      GL_RG_SNORM
      GL_RIGHT
      GL_ROUNDED_RECT2_NV
      GL_ROUNDED_RECT4_NV
      GL_ROUNDED_RECT8_NV
      GL_ROUNDED_RECT_NV
      GL_ROUND_NV
      GL_S
      GL_S3_s3tc
      GL_SAMPLER
      GL_SAMPLER_1D
      GL_SAMPLER_1D_ARB
      GL_SAMPLER_1D_ARRAY
      GL_SAMPLER_1D_ARRAY_EXT
      GL_SAMPLER_1D_ARRAY_SHADOW
      GL_SAMPLER_1D_ARRAY_SHADOW_EXT
      GL_SAMPLER_1D_SHADOW
      GL_SAMPLER_1D_SHADOW_ARB
      GL_SAMPLER_2D
      GL_SAMPLER_2D_ARB
      GL_SAMPLER_2D_ARRAY
      GL_SAMPLER_2D_ARRAY_EXT
      GL_SAMPLER_2D_ARRAY_SHADOW
      GL_SAMPLER_2D_ARRAY_SHADOW_EXT
      GL_SAMPLER_2D_MULTISAMPLE
      GL_SAMPLER_2D_MULTISAMPLE_ARRAY
      GL_SAMPLER_2D_RECT
      GL_SAMPLER_2D_RECT_ARB
      GL_SAMPLER_2D_RECT_SHADOW
      GL_SAMPLER_2D_RECT_SHADOW_ARB
      GL_SAMPLER_2D_SHADOW
      GL_SAMPLER_2D_SHADOW_ARB
      GL_SAMPLER_3D
      GL_SAMPLER_3D_ARB
      GL_SAMPLER_BINDING
      GL_SAMPLER_BUFFER
      GL_SAMPLER_BUFFER_AMD
      GL_SAMPLER_BUFFER_EXT
      GL_SAMPLER_CUBE
      GL_SAMPLER_CUBE_ARB
      GL_SAMPLER_CUBE_MAP_ARRAY
      GL_SAMPLER_CUBE_MAP_ARRAY_ARB
      GL_SAMPLER_CUBE_MAP_ARRAY_SHADOW
      GL_SAMPLER_CUBE_MAP_ARRAY_SHADOW_ARB
      GL_SAMPLER_CUBE_SHADOW
      GL_SAMPLER_CUBE_SHADOW_EXT
      GL_SAMPLER_OBJECT_AMD
      GL_SAMPLER_RENDERBUFFER_NV
      GL_SAMPLES
      GL_SAMPLES_3DFX
      GL_SAMPLES_ARB
      GL_SAMPLES_EXT
      GL_SAMPLES_PASSED
      GL_SAMPLES_PASSED_ARB
      GL_SAMPLES_SGIS
      GL_SAMPLE_ALPHA_TO_COVERAGE
      GL_SAMPLE_ALPHA_TO_COVERAGE_ARB
      GL_SAMPLE_ALPHA_TO_MASK_EXT
      GL_SAMPLE_ALPHA_TO_MASK_SGIS
      GL_SAMPLE_ALPHA_TO_ONE
      GL_SAMPLE_ALPHA_TO_ONE_ARB
      GL_SAMPLE_ALPHA_TO_ONE_EXT
      GL_SAMPLE_ALPHA_TO_ONE_SGIS
      GL_SAMPLE_BUFFERS
      GL_SAMPLE_BUFFERS_3DFX
      GL_SAMPLE_BUFFERS_ARB
      GL_SAMPLE_BUFFERS_EXT
      GL_SAMPLE_BUFFERS_SGIS
      GL_SAMPLE_COUNT_BITS_NV
      GL_SAMPLE_COUNT_NV
      GL_SAMPLE_COVERAGE
      GL_SAMPLE_COVERAGE_ARB
      GL_SAMPLE_COVERAGE_INVERT
      GL_SAMPLE_COVERAGE_INVERT_ARB
      GL_SAMPLE_COVERAGE_VALUE
      GL_SAMPLE_COVERAGE_VALUE_ARB
      GL_SAMPLE_LOCATION_ARB
      GL_SAMPLE_LOCATION_NV
      GL_SAMPLE_LOCATION_PIXEL_GRID_HEIGHT_ARB
      GL_SAMPLE_LOCATION_PIXEL_GRID_HEIGHT_NV
      GL_SAMPLE_LOCATION_PIXEL_GRID_WIDTH_ARB
      GL_SAMPLE_LOCATION_PIXEL_GRID_WIDTH_NV
      GL_SAMPLE_LOCATION_SUBPIXEL_BITS_ARB
      GL_SAMPLE_LOCATION_SUBPIXEL_BITS_NV
      GL_SAMPLE_MASK
      GL_SAMPLE_MASK_EXT
      GL_SAMPLE_MASK_INVERT_EXT
      GL_SAMPLE_MASK_INVERT_SGIS
      GL_SAMPLE_MASK_NV
      GL_SAMPLE_MASK_SGIS
      GL_SAMPLE_MASK_VALUE
      GL_SAMPLE_MASK_VALUE_EXT
      GL_SAMPLE_MASK_VALUE_NV
      GL_SAMPLE_MASK_VALUE_SGIS
      GL_SAMPLE_PATTERN_EXT
      GL_SAMPLE_PATTERN_SGIS
      GL_SAMPLE_POSITION
      GL_SAMPLE_POSITION_NV
      GL_SAMPLE_SHADING
      GL_SAMPLE_SHADING_ARB
      GL_SATURATE_BIT_ATI
      GL_SCALAR_EXT
      GL_SCALED_RESOLVE_FASTEST_EXT
      GL_SCALED_RESOLVE_NICEST_EXT
      GL_SCALE_BY_FOUR_NV
      GL_SCALE_BY_ONE_HALF_NV
      GL_SCALE_BY_TWO_NV
      GL_SCISSOR_BIT
      GL_SCISSOR_BOX
      GL_SCISSOR_COMMAND_NV
      GL_SCISSOR_TEST
      GL_SCREEN_COORDINATES_REND
      GL_SCREEN_KHR
      GL_SCREEN_NV
      GL_SECONDARY_COLOR_ARRAY
      GL_SECONDARY_COLOR_ARRAY_ADDRESS_NV
      GL_SECONDARY_COLOR_ARRAY_BUFFER_BINDING
      GL_SECONDARY_COLOR_ARRAY_BUFFER_BINDING_ARB
      GL_SECONDARY_COLOR_ARRAY_EXT
      GL_SECONDARY_COLOR_ARRAY_LENGTH_NV
      GL_SECONDARY_COLOR_ARRAY_LIST_IBM
      GL_SECONDARY_COLOR_ARRAY_LIST_STRIDE_IBM
      GL_SECONDARY_COLOR_ARRAY_POINTER
      GL_SECONDARY_COLOR_ARRAY_POINTER_EXT
      GL_SECONDARY_COLOR_ARRAY_SIZE
      GL_SECONDARY_COLOR_ARRAY_SIZE_EXT
      GL_SECONDARY_COLOR_ARRAY_STRIDE
      GL_SECONDARY_COLOR_ARRAY_STRIDE_EXT
      GL_SECONDARY_COLOR_ARRAY_TYPE
      GL_SECONDARY_COLOR_ARRAY_TYPE_EXT
      GL_SECONDARY_COLOR_ATIX
      GL_SECONDARY_COLOR_NV
      GL_SECONDARY_INTERPOLATOR_ATI
      GL_SELECT
      GL_SELECTION_BUFFER_POINTER
      GL_SELECTION_BUFFER_SIZE
      GL_SEPARABLE_2D
      GL_SEPARABLE_2D_EXT
      GL_SEPARATE_ATTRIBS
      GL_SEPARATE_ATTRIBS_EXT
      GL_SEPARATE_ATTRIBS_NV
      GL_SEPARATE_SPECULAR_COLOR
      GL_SEPARATE_SPECULAR_COLOR_EXT
      GL_SET
      GL_SET_AMD
      GL_SGIS_color_range
      GL_SGIS_detail_texture
      GL_SGIS_fog_function
      GL_SGIS_generate_mipmap
      GL_SGIS_multisample
      GL_SGIS_pixel_texture
      GL_SGIS_point_line_texgen
      GL_SGIS_sharpen_texture
      GL_SGIS_texture4D
      GL_SGIS_texture_border_clamp
      GL_SGIS_texture_edge_clamp
      GL_SGIS_texture_filter4
      GL_SGIS_texture_lod
      GL_SGIS_texture_select
      GL_SGIX_async
      GL_SGIX_async_histogram
      GL_SGIX_async_pixel
      GL_SGIX_blend_alpha_minmax
      GL_SGIX_clipmap
      GL_SGIX_convolution_accuracy
      GL_SGIX_depth_texture
      GL_SGIX_flush_raster
      GL_SGIX_fog_offset
      GL_SGIX_fog_texture
      GL_SGIX_fragment_specular_lighting
      GL_SGIX_framezoom
      GL_SGIX_interlace
      GL_SGIX_ir_instrument1
      GL_SGIX_list_priority
      GL_SGIX_pixel_texture
      GL_SGIX_pixel_texture_bits
      GL_SGIX_reference_plane
      GL_SGIX_resample
      GL_SGIX_shadow
      GL_SGIX_shadow_ambient
      GL_SGIX_sprite
      GL_SGIX_tag_sample_buffer
      GL_SGIX_texture_add_env
      GL_SGIX_texture_coordinate_clamp
      GL_SGIX_texture_lod_bias
      GL_SGIX_texture_multi_buffer
      GL_SGIX_texture_range
      GL_SGIX_texture_scale_bias
      GL_SGIX_vertex_preclip
      GL_SGIX_vertex_preclip_hint
      GL_SGIX_ycrcb
      GL_SGI_color_matrix
      GL_SGI_color_table
      GL_SGI_texture_color_table
      GL_SHADER
      GL_SHADER_BINARY_FORMATS
      GL_SHADER_BINARY_FORMAT_SPIR_V_ARB
      GL_SHADER_COMPILER
      GL_SHADER_CONSISTENT_NV
      GL_SHADER_IMAGE_ACCESS_BARRIER_BIT
      GL_SHADER_IMAGE_ACCESS_BARRIER_BIT_EXT
      GL_SHADER_IMAGE_ATOMIC
      GL_SHADER_IMAGE_LOAD
      GL_SHADER_IMAGE_STORE
      GL_SHADER_INCLUDE_ARB
      GL_SHADER_OBJECT_ARB
      GL_SHADER_OBJECT_EXT
      GL_SHADER_OPERATION_NV
      GL_SHADER_SOURCE_LENGTH
      GL_SHADER_STORAGE_BARRIER_BIT
      GL_SHADER_STORAGE_BLOCK
      GL_SHADER_STORAGE_BUFFER
      GL_SHADER_STORAGE_BUFFER_BINDING
      GL_SHADER_STORAGE_BUFFER_OFFSET_ALIGNMENT
      GL_SHADER_STORAGE_BUFFER_SIZE
      GL_SHADER_STORAGE_BUFFER_START
      GL_SHADER_TYPE
      GL_SHADE_MODEL
      GL_SHADING_LANGUAGE_VERSION
      GL_SHADING_LANGUAGE_VERSION_ARB
      GL_SHADOW_AMBIENT_SGIX
      GL_SHADOW_ATTENUATION_EXT
      GL_SHARED_EDGE_NV
      GL_SHARED_TEXTURE_PALETTE_EXT
      GL_SHININESS
      GL_SHORT
      GL_SIGNALED
      GL_SIGNED_ALPHA8_NV
      GL_SIGNED_ALPHA_NV
      GL_SIGNED_HILO16_NV
      GL_SIGNED_HILO8_NV
      GL_SIGNED_HILO_NV
      GL_SIGNED_IDENTITY_NV
      GL_SIGNED_INTENSITY8_NV
      GL_SIGNED_INTENSITY_NV
      GL_SIGNED_LUMINANCE8_ALPHA8_NV
      GL_SIGNED_LUMINANCE8_NV
      GL_SIGNED_LUMINANCE_ALPHA_NV
      GL_SIGNED_LUMINANCE_NV
      GL_SIGNED_NEGATE_NV
      GL_SIGNED_NORMALIZED
      GL_SIGNED_RGB8_NV
      GL_SIGNED_RGB8_UNSIGNED_ALPHA8_NV
      GL_SIGNED_RGBA8_NV
      GL_SIGNED_RGBA_NV
      GL_SIGNED_RGB_NV
      GL_SIGNED_RGB_UNSIGNED_ALPHA_NV
      GL_SIMULTANEOUS_TEXTURE_AND_DEPTH_TEST
      GL_SIMULTANEOUS_TEXTURE_AND_DEPTH_WRITE
      GL_SIMULTANEOUS_TEXTURE_AND_STENCIL_TEST
      GL_SIMULTANEOUS_TEXTURE_AND_STENCIL_WRITE
      GL_SINGLE_COLOR
      GL_SINGLE_COLOR_EXT
      GL_SKIP_DECODE_EXT
      GL_SKIP_MISSING_GLYPH_NV
      GL_SLICE_ACCUM_SUN
      GL_SLUMINANCE
      GL_SLUMINANCE8
      GL_SLUMINANCE8_ALPHA8
      GL_SLUMINANCE8_ALPHA8_EXT
      GL_SLUMINANCE8_EXT
      GL_SLUMINANCE_ALPHA
      GL_SLUMINANCE_ALPHA_EXT
      GL_SLUMINANCE_EXT
      GL_SMALL_CCW_ARC_TO_NV
      GL_SMALL_CW_ARC_TO_NV
      GL_SMOOTH
      GL_SMOOTH_CUBIC_CURVE_TO_NV
      GL_SMOOTH_LINE_WIDTH_GRANULARITY
      GL_SMOOTH_LINE_WIDTH_RANGE
      GL_SMOOTH_POINT_SIZE_GRANULARITY
      GL_SMOOTH_POINT_SIZE_RANGE
      GL_SMOOTH_QUADRATIC_CURVE_TO_NV
      GL_SM_COUNT_NV
      GL_SOFTLIGHT_KHR
      GL_SOFTLIGHT_NV
      GL_SOURCE0_ALPHA
      GL_SOURCE0_ALPHA_ARB
      GL_SOURCE0_ALPHA_EXT
      GL_SOURCE0_RGB
      GL_SOURCE0_RGB_ARB
      GL_SOURCE0_RGB_EXT
      GL_SOURCE1_ALPHA
      GL_SOURCE1_ALPHA_ARB
      GL_SOURCE1_ALPHA_EXT
      GL_SOURCE1_RGB
      GL_SOURCE1_RGB_ARB
      GL_SOURCE1_RGB_EXT
      GL_SOURCE2_ALPHA
      GL_SOURCE2_ALPHA_ARB
      GL_SOURCE2_ALPHA_EXT
      GL_SOURCE2_RGB
      GL_SOURCE2_RGB_ARB
      GL_SOURCE2_RGB_EXT
      GL_SOURCE3_ALPHA_NV
      GL_SOURCE3_RGB_NV
      GL_SPARE0_NV
      GL_SPARE0_PLUS_SECONDARY_COLOR_NV
      GL_SPARE1_NV
      GL_SPARSE_BUFFER_PAGE_SIZE_ARB
      GL_SPARSE_STORAGE_BIT_ARB
      GL_SPARSE_TEXTURE_FULL_ARRAY_CUBE_MIPMAPS_ARB
      GL_SPECULAR
      GL_SPHERE_MAP
      GL_SPIR_V_BINARY_ARB
      GL_SPOT_CUTOFF
      GL_SPOT_DIRECTION
      GL_SPOT_EXPONENT
      GL_SQUARE_NV
      GL_SRC0_ALPHA
      GL_SRC0_RGB
      GL_SRC1_ALPHA
      GL_SRC1_COLOR
      GL_SRC1_RGB
      GL_SRC2_ALPHA
      GL_SRC2_RGB
      GL_SRC_ALPHA
      GL_SRC_ALPHA_SATURATE
      GL_SRC_ATOP_NV
      GL_SRC_COLOR
      GL_SRC_IN_NV
      GL_SRC_NV
      GL_SRC_OUT_NV
      GL_SRC_OVER_NV
      GL_SRGB
      GL_SRGB8
      GL_SRGB8_ALPHA8
      GL_SRGB8_ALPHA8_EXT
      GL_SRGB8_EXT
      GL_SRGB_ALPHA
      GL_SRGB_ALPHA_EXT
      GL_SRGB_DECODE_ARB
      GL_SRGB_EXT
      GL_SRGB_READ
      GL_SRGB_WRITE
      GL_STACK_OVERFLOW
      GL_STACK_UNDERFLOW
      GL_STANDARD_FONT_FORMAT_NV
      GL_STANDARD_FONT_NAME_NV
      GL_STATIC_ATI
      GL_STATIC_COPY
      GL_STATIC_COPY_ARB
      GL_STATIC_DRAW
      GL_STATIC_DRAW_ARB
      GL_STATIC_READ
      GL_STATIC_READ_ARB
      GL_STATIC_VERTEX_ARRAY_IBM
      GL_STATISTICS_REGAL
      GL_STENCIL
      GL_STENCIL_ATTACHMENT
      GL_STENCIL_ATTACHMENT_EXT
      GL_STENCIL_BACK_FAIL
      GL_STENCIL_BACK_FAIL_ATI
      GL_STENCIL_BACK_FUNC
      GL_STENCIL_BACK_FUNC_ATI
      GL_STENCIL_BACK_OP_VALUE_AMD
      GL_STENCIL_BACK_PASS_DEPTH_FAIL
      GL_STENCIL_BACK_PASS_DEPTH_FAIL_ATI
      GL_STENCIL_BACK_PASS_DEPTH_PASS
      GL_STENCIL_BACK_PASS_DEPTH_PASS_ATI
      GL_STENCIL_BACK_REF
      GL_STENCIL_BACK_VALUE_MASK
      GL_STENCIL_BACK_WRITEMASK
      GL_STENCIL_BITS
      GL_STENCIL_BUFFER
      GL_STENCIL_BUFFER_BIT
      GL_STENCIL_CLEAR_TAG_VALUE_EXT
      GL_STENCIL_CLEAR_VALUE
      GL_STENCIL_COMPONENTS
      GL_STENCIL_FAIL
      GL_STENCIL_FUNC
      GL_STENCIL_INDEX
      GL_STENCIL_INDEX1
      GL_STENCIL_INDEX16
      GL_STENCIL_INDEX16_EXT
      GL_STENCIL_INDEX1_EXT
      GL_STENCIL_INDEX4
      GL_STENCIL_INDEX4_EXT
      GL_STENCIL_INDEX8
      GL_STENCIL_INDEX8_EXT
      GL_STENCIL_OP_VALUE_AMD
      GL_STENCIL_PASS_DEPTH_FAIL
      GL_STENCIL_PASS_DEPTH_PASS
      GL_STENCIL_REF
      GL_STENCIL_REF_COMMAND_NV
      GL_STENCIL_RENDERABLE
      GL_STENCIL_SAMPLES_NV
      GL_STENCIL_TAG_BITS_EXT
      GL_STENCIL_TEST
      GL_STENCIL_TEST_TWO_SIDE_EXT
      GL_STENCIL_VALUE_MASK
      GL_STENCIL_WRITEMASK
      GL_STEREO
      GL_STORAGE_CACHED_APPLE
      GL_STORAGE_CLIENT_APPLE
      GL_STORAGE_PRIVATE_APPLE
      GL_STORAGE_SHARED_APPLE
      GL_STREAM_COPY
      GL_STREAM_COPY_ARB
      GL_STREAM_DRAW
      GL_STREAM_DRAW_ARB
      GL_STREAM_RASTERIZATION_AMD
      GL_STREAM_READ
      GL_STREAM_READ_ARB
      GL_STRICT_DEPTHFUNC_HINT_PGI
      GL_STRICT_LIGHTING_HINT_PGI
      GL_STRICT_SCISSOR_HINT_PGI
      GL_SUBPIXEL_BITS
      GL_SUBPIXEL_PRECISION_BIAS_X_BITS_NV
      GL_SUBPIXEL_PRECISION_BIAS_Y_BITS_NV
      GL_SUBSAMPLE_DISTANCE_AMD
      GL_SUBTRACT
      GL_SUBTRACT_ARB
      GL_SUB_ATI
      GL_SUCCESS_NV
      GL_SUNX_constant_data
      GL_SUN_convolution_border_modes
      GL_SUN_global_alpha
      GL_SUN_mesh_array
      GL_SUN_read_video_pixels
      GL_SUN_slice_accum
      GL_SUN_triangle_list
      GL_SUN_vertex
      GL_SUPERSAMPLE_SCALE_X_NV
      GL_SUPERSAMPLE_SCALE_Y_NV
      GL_SURFACE_MAPPED_NV
      GL_SURFACE_REGISTERED_NV
      GL_SURFACE_STATE_NV
      GL_SWIZZLE_STQ_ATI
      GL_SWIZZLE_STQ_DQ_ATI
      GL_SWIZZLE_STRQ_ATI
      GL_SWIZZLE_STRQ_DQ_ATI
      GL_SWIZZLE_STR_ATI
      GL_SWIZZLE_STR_DR_ATI
      GL_SYNC_CL_EVENT_ARB
      GL_SYNC_CL_EVENT_COMPLETE_ARB
      GL_SYNC_CONDITION
      GL_SYNC_FENCE
      GL_SYNC_FLAGS
      GL_SYNC_FLUSH_COMMANDS_BIT
      GL_SYNC_GPU_COMMANDS_COMPLETE
      GL_SYNC_STATUS
      GL_SYNC_X11_FENCE_EXT
      GL_SYSTEM_FONT_NAME_NV
      GL_T
      GL_T2F_C3F_V3F
      GL_T2F_C4F_N3F_V3F
      GL_T2F_C4UB_V3F
      GL_T2F_N3F_V3F
      GL_T2F_V3F
      GL_T4F_C4F_N3F_V4F
      GL_T4F_V4F
      GL_TABLE_TOO_LARGE
      GL_TANGENT_ARRAY_EXT
      GL_TANGENT_ARRAY_POINTER_EXT
      GL_TANGENT_ARRAY_STRIDE_EXT
      GL_TANGENT_ARRAY_TYPE_EXT
      GL_TERMINATE_SEQUENCE_COMMAND_NV
      GL_TESSELLATION_FACTOR_AMD
      GL_TESSELLATION_MODE_AMD
      GL_TESS_CONTROL_OUTPUT_VERTICES
      GL_TESS_CONTROL_PROGRAM_NV
      GL_TESS_CONTROL_PROGRAM_PARAMETER_BUFFER_NV
      GL_TESS_CONTROL_SHADER
      GL_TESS_CONTROL_SHADER_BIT
      GL_TESS_CONTROL_SHADER_PATCHES_ARB
      GL_TESS_CONTROL_SUBROUTINE
      GL_TESS_CONTROL_SUBROUTINE_UNIFORM
      GL_TESS_CONTROL_TEXTURE
      GL_TESS_EVALUATION_PROGRAM_NV
      GL_TESS_EVALUATION_PROGRAM_PARAMETER_BUFFER_NV
      GL_TESS_EVALUATION_SHADER
      GL_TESS_EVALUATION_SHADER_BIT
      GL_TESS_EVALUATION_SHADER_INVOCATIONS_ARB
      GL_TESS_EVALUATION_SUBROUTINE
      GL_TESS_EVALUATION_SUBROUTINE_UNIFORM
      GL_TESS_EVALUATION_TEXTURE
      GL_TESS_GEN_MODE
      GL_TESS_GEN_POINT_MODE
      GL_TESS_GEN_SPACING
      GL_TESS_GEN_VERTEX_ORDER
      GL_TEXCOORD1_BIT_PGI
      GL_TEXCOORD2_BIT_PGI
      GL_TEXCOORD3_BIT_PGI
      GL_TEXCOORD4_BIT_PGI
      GL_TEXTURE
      GL_TEXTURE0
      GL_TEXTURE0_ARB
      GL_TEXTURE1
      GL_TEXTURE10
      GL_TEXTURE10_ARB
      GL_TEXTURE11
      GL_TEXTURE11_ARB
      GL_TEXTURE12
      GL_TEXTURE12_ARB
      GL_TEXTURE13
      GL_TEXTURE13_ARB
      GL_TEXTURE14
      GL_TEXTURE14_ARB
      GL_TEXTURE15
      GL_TEXTURE15_ARB
      GL_TEXTURE16
      GL_TEXTURE16_ARB
      GL_TEXTURE17
      GL_TEXTURE17_ARB
      GL_TEXTURE18
      GL_TEXTURE18_ARB
      GL_TEXTURE19
      GL_TEXTURE19_ARB
      GL_TEXTURE1_ARB
      GL_TEXTURE2
      GL_TEXTURE20
      GL_TEXTURE20_ARB
      GL_TEXTURE21
      GL_TEXTURE21_ARB
      GL_TEXTURE22
      GL_TEXTURE22_ARB
      GL_TEXTURE23
      GL_TEXTURE23_ARB
      GL_TEXTURE24
      GL_TEXTURE24_ARB
      GL_TEXTURE25
      GL_TEXTURE25_ARB
      GL_TEXTURE26
      GL_TEXTURE26_ARB
      GL_TEXTURE27
      GL_TEXTURE27_ARB
      GL_TEXTURE28
      GL_TEXTURE28_ARB
      GL_TEXTURE29
      GL_TEXTURE29_ARB
      GL_TEXTURE2_ARB
      GL_TEXTURE3
      GL_TEXTURE30
      GL_TEXTURE30_ARB
      GL_TEXTURE31
      GL_TEXTURE31_ARB
      GL_TEXTURE3_ARB
      GL_TEXTURE4
      GL_TEXTURE4_ARB
      GL_TEXTURE5
      GL_TEXTURE5_ARB
      GL_TEXTURE6
      GL_TEXTURE6_ARB
      GL_TEXTURE7
      GL_TEXTURE7_ARB
      GL_TEXTURE8
      GL_TEXTURE8_ARB
      GL_TEXTURE9
      GL_TEXTURE9_ARB
      GL_TEXTURE_1D
      GL_TEXTURE_1D_ARRAY
      GL_TEXTURE_1D_ARRAY_EXT
      GL_TEXTURE_1D_BINDING_EXT
      GL_TEXTURE_1D_STACK_BINDING_MESAX
      GL_TEXTURE_1D_STACK_MESAX
      GL_TEXTURE_2D
      GL_TEXTURE_2D_ARRAY
      GL_TEXTURE_2D_ARRAY_EXT
      GL_TEXTURE_2D_BINDING_EXT
      GL_TEXTURE_2D_MULTISAMPLE
      GL_TEXTURE_2D_MULTISAMPLE_ARRAY
      GL_TEXTURE_2D_STACK_BINDING_MESAX
      GL_TEXTURE_2D_STACK_MESAX
      GL_TEXTURE_3D
      GL_TEXTURE_3D_BINDING_EXT
      GL_TEXTURE_3D_EXT
      GL_TEXTURE_ALPHA_SIZE
      GL_TEXTURE_ALPHA_SIZE_EXT
      GL_TEXTURE_ALPHA_TYPE
      GL_TEXTURE_ALPHA_TYPE_ARB
      GL_TEXTURE_APPLICATION_MODE_EXT
      GL_TEXTURE_BASE_LEVEL
      GL_TEXTURE_BASE_LEVEL_SGIS
      GL_TEXTURE_BINDING_1D
      GL_TEXTURE_BINDING_1D_ARRAY
      GL_TEXTURE_BINDING_1D_ARRAY_EXT
      GL_TEXTURE_BINDING_2D
      GL_TEXTURE_BINDING_2D_ARRAY
      GL_TEXTURE_BINDING_2D_ARRAY_EXT
      GL_TEXTURE_BINDING_2D_MULTISAMPLE
      GL_TEXTURE_BINDING_2D_MULTISAMPLE_ARRAY
      GL_TEXTURE_BINDING_3D
      GL_TEXTURE_BINDING_BUFFER
      GL_TEXTURE_BINDING_BUFFER_ARB
      GL_TEXTURE_BINDING_BUFFER_EXT
      GL_TEXTURE_BINDING_CUBE_MAP
      GL_TEXTURE_BINDING_CUBE_MAP_ARB
      GL_TEXTURE_BINDING_CUBE_MAP_ARRAY
      GL_TEXTURE_BINDING_CUBE_MAP_ARRAY_ARB
      GL_TEXTURE_BINDING_CUBE_MAP_EXT
      GL_TEXTURE_BINDING_RECTANGLE
      GL_TEXTURE_BINDING_RECTANGLE_ARB
      GL_TEXTURE_BINDING_RECTANGLE_EXT
      GL_TEXTURE_BINDING_RECTANGLE_NV
      GL_TEXTURE_BINDING_RENDERBUFFER_NV
      GL_TEXTURE_BIT
      GL_TEXTURE_BLUE_SIZE
      GL_TEXTURE_BLUE_SIZE_EXT
      GL_TEXTURE_BLUE_TYPE
      GL_TEXTURE_BLUE_TYPE_ARB
      GL_TEXTURE_BORDER
      GL_TEXTURE_BORDER_COLOR
      GL_TEXTURE_BORDER_VALUES_NV
      GL_TEXTURE_BUFFER
      GL_TEXTURE_BUFFER_ARB
      GL_TEXTURE_BUFFER_BINDING
      GL_TEXTURE_BUFFER_DATA_STORE_BINDING
      GL_TEXTURE_BUFFER_DATA_STORE_BINDING_ARB
      GL_TEXTURE_BUFFER_DATA_STORE_BINDING_EXT
      GL_TEXTURE_BUFFER_EXT
      GL_TEXTURE_BUFFER_FORMAT
      GL_TEXTURE_BUFFER_FORMAT_ARB
      GL_TEXTURE_BUFFER_FORMAT_EXT
      GL_TEXTURE_BUFFER_OFFSET
      GL_TEXTURE_BUFFER_OFFSET_ALIGNMENT
      GL_TEXTURE_BUFFER_SIZE
      GL_TEXTURE_COLOR_SAMPLES_NV
      GL_TEXTURE_COLOR_TABLE_SGI
      GL_TEXTURE_COMPARE_FAIL_VALUE_ARB
      GL_TEXTURE_COMPARE_FUNC
      GL_TEXTURE_COMPARE_FUNC_ARB
      GL_TEXTURE_COMPARE_MODE
      GL_TEXTURE_COMPARE_MODE_ARB
      GL_TEXTURE_COMPARE_OPERATOR_SGIX
      GL_TEXTURE_COMPARE_SGIX
      GL_TEXTURE_COMPONENTS
      GL_TEXTURE_COMPRESSED
      GL_TEXTURE_COMPRESSED_ARB
      GL_TEXTURE_COMPRESSED_BLOCK_HEIGHT
      GL_TEXTURE_COMPRESSED_BLOCK_SIZE
      GL_TEXTURE_COMPRESSED_BLOCK_WIDTH
      GL_TEXTURE_COMPRESSED_IMAGE_SIZE
      GL_TEXTURE_COMPRESSED_IMAGE_SIZE_ARB
      GL_TEXTURE_COMPRESSION_HINT
      GL_TEXTURE_COMPRESSION_HINT_ARB
      GL_TEXTURE_CONSTANT_DATA_SUNX
      GL_TEXTURE_COORD_ARRAY
      GL_TEXTURE_COORD_ARRAY_ADDRESS_NV
      GL_TEXTURE_COORD_ARRAY_BUFFER_BINDING
      GL_TEXTURE_COORD_ARRAY_BUFFER_BINDING_ARB
      GL_TEXTURE_COORD_ARRAY_COUNT_EXT
      GL_TEXTURE_COORD_ARRAY_EXT
      GL_TEXTURE_COORD_ARRAY_LENGTH_NV
      GL_TEXTURE_COORD_ARRAY_LIST_IBM
      GL_TEXTURE_COORD_ARRAY_LIST_STRIDE_IBM
      GL_TEXTURE_COORD_ARRAY_PARALLEL_POINTERS_INTEL
      GL_TEXTURE_COORD_ARRAY_POINTER
      GL_TEXTURE_COORD_ARRAY_POINTER_EXT
      GL_TEXTURE_COORD_ARRAY_SIZE
      GL_TEXTURE_COORD_ARRAY_SIZE_EXT
      GL_TEXTURE_COORD_ARRAY_STRIDE
      GL_TEXTURE_COORD_ARRAY_STRIDE_EXT
      GL_TEXTURE_COORD_ARRAY_TYPE
      GL_TEXTURE_COORD_ARRAY_TYPE_EXT
      GL_TEXTURE_COORD_NV
      GL_TEXTURE_COVERAGE_SAMPLES_NV
      GL_TEXTURE_CUBE_MAP
      GL_TEXTURE_CUBE_MAP_ARB
      GL_TEXTURE_CUBE_MAP_ARRAY
      GL_TEXTURE_CUBE_MAP_ARRAY_ARB
      GL_TEXTURE_CUBE_MAP_EXT
      GL_TEXTURE_CUBE_MAP_NEGATIVE_X
      GL_TEXTURE_CUBE_MAP_NEGATIVE_X_ARB
      GL_TEXTURE_CUBE_MAP_NEGATIVE_X_EXT
      GL_TEXTURE_CUBE_MAP_NEGATIVE_Y
      GL_TEXTURE_CUBE_MAP_NEGATIVE_Y_ARB
      GL_TEXTURE_CUBE_MAP_NEGATIVE_Y_EXT
      GL_TEXTURE_CUBE_MAP_NEGATIVE_Z
      GL_TEXTURE_CUBE_MAP_NEGATIVE_Z_ARB
      GL_TEXTURE_CUBE_MAP_NEGATIVE_Z_EXT
      GL_TEXTURE_CUBE_MAP_POSITIVE_X
      GL_TEXTURE_CUBE_MAP_POSITIVE_X_ARB
      GL_TEXTURE_CUBE_MAP_POSITIVE_X_EXT
      GL_TEXTURE_CUBE_MAP_POSITIVE_Y
      GL_TEXTURE_CUBE_MAP_POSITIVE_Y_ARB
      GL_TEXTURE_CUBE_MAP_POSITIVE_Y_EXT
      GL_TEXTURE_CUBE_MAP_POSITIVE_Z
      GL_TEXTURE_CUBE_MAP_POSITIVE_Z_ARB
      GL_TEXTURE_CUBE_MAP_POSITIVE_Z_EXT
      GL_TEXTURE_CUBE_MAP_SEAMLESS
      GL_TEXTURE_CUBE_MAP_SEAMLESS_ARB
      GL_TEXTURE_DEPTH
      GL_TEXTURE_DEPTH_EXT
      GL_TEXTURE_DEPTH_SIZE
      GL_TEXTURE_DEPTH_SIZE_ARB
      GL_TEXTURE_DEPTH_TYPE
      GL_TEXTURE_DEPTH_TYPE_ARB
      GL_TEXTURE_DS_SIZE_NV
      GL_TEXTURE_DT_SIZE_NV
      GL_TEXTURE_ENV
      GL_TEXTURE_ENV_COLOR
      GL_TEXTURE_ENV_MODE
      GL_TEXTURE_FETCH_BARRIER_BIT
      GL_TEXTURE_FETCH_BARRIER_BIT_EXT
      GL_TEXTURE_FILTER_CONTROL
      GL_TEXTURE_FILTER_CONTROL_EXT
      GL_TEXTURE_FIXED_SAMPLE_LOCATIONS
      GL_TEXTURE_FLOAT_COMPONENTS_NV
      GL_TEXTURE_FREE_MEMORY_ATI
      GL_TEXTURE_GATHER
      GL_TEXTURE_GATHER_SHADOW
      GL_TEXTURE_GEN_MODE
      GL_TEXTURE_GEN_Q
      GL_TEXTURE_GEN_R
      GL_TEXTURE_GEN_S
      GL_TEXTURE_GEN_T
      GL_TEXTURE_GEQUAL_R_SGIX
      GL_TEXTURE_GREEN_SIZE
      GL_TEXTURE_GREEN_SIZE_EXT
      GL_TEXTURE_GREEN_TYPE
      GL_TEXTURE_GREEN_TYPE_ARB
      GL_TEXTURE_HEIGHT
      GL_TEXTURE_HI_SIZE_NV
      GL_TEXTURE_IMAGE_FORMAT
      GL_TEXTURE_IMAGE_TYPE
      GL_TEXTURE_IMMUTABLE_FORMAT
      GL_TEXTURE_IMMUTABLE_LEVELS
      GL_TEXTURE_INDEX_SIZE_EXT
      GL_TEXTURE_INTENSITY_SIZE
      GL_TEXTURE_INTENSITY_SIZE_EXT
      GL_TEXTURE_INTENSITY_TYPE
      GL_TEXTURE_INTENSITY_TYPE_ARB
      GL_TEXTURE_INTERNAL_FORMAT
      GL_TEXTURE_LEQUAL_R_SGIX
      GL_TEXTURE_LIGHT_EXT
      GL_TEXTURE_LOD_BIAS
      GL_TEXTURE_LOD_BIAS_EXT
      GL_TEXTURE_LO_SIZE_NV
      GL_TEXTURE_LUMINANCE_SIZE
      GL_TEXTURE_LUMINANCE_SIZE_EXT
      GL_TEXTURE_LUMINANCE_TYPE
      GL_TEXTURE_LUMINANCE_TYPE_ARB
      GL_TEXTURE_MAG_FILTER
      GL_TEXTURE_MAG_SIZE_NV
      GL_TEXTURE_MATERIAL_FACE_EXT
      GL_TEXTURE_MATERIAL_PARAMETER_EXT
      GL_TEXTURE_MATRIX
      GL_TEXTURE_MAX_ANISOTROPY_EXT
      GL_TEXTURE_MAX_CLAMP_R_SGIX
      GL_TEXTURE_MAX_CLAMP_S_SGIX
      GL_TEXTURE_MAX_CLAMP_T_SGIX
      GL_TEXTURE_MAX_LEVEL
      GL_TEXTURE_MAX_LEVEL_SGIS
      GL_TEXTURE_MAX_LOD
      GL_TEXTURE_MAX_LOD_SGIS
      GL_TEXTURE_MEMORY_LAYOUT_INTEL
      GL_TEXTURE_MIN_FILTER
      GL_TEXTURE_MIN_LOD
      GL_TEXTURE_MIN_LOD_SGIS
      GL_TEXTURE_MULTI_BUFFER_HINT_SGIX
      GL_TEXTURE_NORMAL_EXT
      GL_TEXTURE_OUTPUT_ALPHA_ATIX
      GL_TEXTURE_OUTPUT_RGB_ATIX
      GL_TEXTURE_POINT_MODE_ATIX
      GL_TEXTURE_POINT_ONE_COORD_ATIX
      GL_TEXTURE_POINT_SPRITE_ATIX
      GL_TEXTURE_PRIORITY
      GL_TEXTURE_PRIORITY_EXT
      GL_TEXTURE_RANGE_LENGTH_APPLE
      GL_TEXTURE_RANGE_POINTER_APPLE
      GL_TEXTURE_RECTANGLE
      GL_TEXTURE_RECTANGLE_ARB
      GL_TEXTURE_RECTANGLE_EXT
      GL_TEXTURE_RECTANGLE_NV
      GL_TEXTURE_REDUCTION_MODE_ARB
      GL_TEXTURE_REDUCTION_MODE_EXT
      GL_TEXTURE_RED_SIZE
      GL_TEXTURE_RED_SIZE_EXT
      GL_TEXTURE_RED_TYPE
      GL_TEXTURE_RED_TYPE_ARB
      GL_TEXTURE_RENDERBUFFER_DATA_STORE_BINDING_NV
      GL_TEXTURE_RENDERBUFFER_NV
      GL_TEXTURE_RESIDENT
      GL_TEXTURE_RESIDENT_EXT
      GL_TEXTURE_SAMPLES
      GL_TEXTURE_SHADER_NV
      GL_TEXTURE_SHADOW
      GL_TEXTURE_SHARED_SIZE
      GL_TEXTURE_SHARED_SIZE_EXT
      GL_TEXTURE_SPARSE_ARB
      GL_TEXTURE_SRGB_DECODE_EXT
      GL_TEXTURE_STACK_DEPTH
      GL_TEXTURE_STENCIL_SIZE
      GL_TEXTURE_STENCIL_SIZE_EXT
      GL_TEXTURE_STORAGE_HINT_APPLE
      GL_TEXTURE_STORAGE_SPARSE_BIT_AMD
      GL_TEXTURE_SWIZZLE_A
      GL_TEXTURE_SWIZZLE_A_EXT
      GL_TEXTURE_SWIZZLE_B
      GL_TEXTURE_SWIZZLE_B_EXT
      GL_TEXTURE_SWIZZLE_G
      GL_TEXTURE_SWIZZLE_G_EXT
      GL_TEXTURE_SWIZZLE_R
      GL_TEXTURE_SWIZZLE_RGBA
      GL_TEXTURE_SWIZZLE_RGBA_EXT
      GL_TEXTURE_SWIZZLE_R_EXT
      GL_TEXTURE_TARGET
      GL_TEXTURE_UNSIGNED_REMAP_MODE_NV
      GL_TEXTURE_UPDATE_BARRIER_BIT
      GL_TEXTURE_UPDATE_BARRIER_BIT_EXT
      GL_TEXTURE_USAGE_ANGLE
      GL_TEXTURE_VIEW
      GL_TEXTURE_VIEW_MIN_LAYER
      GL_TEXTURE_VIEW_MIN_LEVEL
      GL_TEXTURE_VIEW_NUM_LAYERS
      GL_TEXTURE_VIEW_NUM_LEVELS
      GL_TEXTURE_WIDTH
      GL_TEXTURE_WRAP_R
      GL_TEXTURE_WRAP_R_EXT
      GL_TEXTURE_WRAP_S
      GL_TEXTURE_WRAP_T
      GL_TEXT_FRAGMENT_SHADER_ATI
      GL_TIMEOUT_EXPIRED
      GL_TIMEOUT_IGNORED
      GL_TIMESTAMP
      GL_TIMESTAMP_ANGLE
      GL_TIME_ELAPSED
      GL_TIME_ELAPSED_ANGLE
      GL_TIME_ELAPSED_EXT
      GL_TOP_LEVEL_ARRAY_SIZE
      GL_TOP_LEVEL_ARRAY_STRIDE
      GL_TRACE_REGAL
      GL_TRACK_MATRIX_NV
      GL_TRACK_MATRIX_TRANSFORM_NV
      GL_TRANSFORM_BIT
      GL_TRANSFORM_FEEDBACK
      GL_TRANSFORM_FEEDBACK_ACTIVE
      GL_TRANSFORM_FEEDBACK_ATTRIBS_NV
      GL_TRANSFORM_FEEDBACK_BARRIER_BIT
      GL_TRANSFORM_FEEDBACK_BARRIER_BIT_EXT
      GL_TRANSFORM_FEEDBACK_BINDING
      GL_TRANSFORM_FEEDBACK_BINDING_NV
      GL_TRANSFORM_FEEDBACK_BUFFER
      GL_TRANSFORM_FEEDBACK_BUFFER_ACTIVE
      GL_TRANSFORM_FEEDBACK_BUFFER_ACTIVE_NV
      GL_TRANSFORM_FEEDBACK_BUFFER_BINDING
      GL_TRANSFORM_FEEDBACK_BUFFER_BINDING_EXT
      GL_TRANSFORM_FEEDBACK_BUFFER_BINDING_NV
      GL_TRANSFORM_FEEDBACK_BUFFER_EXT
      GL_TRANSFORM_FEEDBACK_BUFFER_INDEX
      GL_TRANSFORM_FEEDBACK_BUFFER_MODE
      GL_TRANSFORM_FEEDBACK_BUFFER_MODE_EXT
      GL_TRANSFORM_FEEDBACK_BUFFER_MODE_NV
      GL_TRANSFORM_FEEDBACK_BUFFER_NV
      GL_TRANSFORM_FEEDBACK_BUFFER_PAUSED
      GL_TRANSFORM_FEEDBACK_BUFFER_PAUSED_NV
      GL_TRANSFORM_FEEDBACK_BUFFER_SIZE
      GL_TRANSFORM_FEEDBACK_BUFFER_SIZE_EXT
      GL_TRANSFORM_FEEDBACK_BUFFER_SIZE_NV
      GL_TRANSFORM_FEEDBACK_BUFFER_START
      GL_TRANSFORM_FEEDBACK_BUFFER_START_EXT
      GL_TRANSFORM_FEEDBACK_BUFFER_START_NV
      GL_TRANSFORM_FEEDBACK_BUFFER_STRIDE
      GL_TRANSFORM_FEEDBACK_NV
      GL_TRANSFORM_FEEDBACK_OVERFLOW_ARB
      GL_TRANSFORM_FEEDBACK_PAUSED
      GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN
      GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN_EXT
      GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN_NV
      GL_TRANSFORM_FEEDBACK_RECORD_NV
      GL_TRANSFORM_FEEDBACK_STREAM_OVERFLOW_ARB
      GL_TRANSFORM_FEEDBACK_VARYING
      GL_TRANSFORM_FEEDBACK_VARYINGS
      GL_TRANSFORM_FEEDBACK_VARYINGS_EXT
      GL_TRANSFORM_FEEDBACK_VARYINGS_NV
      GL_TRANSFORM_FEEDBACK_VARYING_MAX_LENGTH
      GL_TRANSFORM_FEEDBACK_VARYING_MAX_LENGTH_EXT
      GL_TRANSFORM_HINT_APPLE
      GL_TRANSLATED_SHADER_SOURCE_LENGTH_ANGLE
      GL_TRANSLATE_2D_NV
      GL_TRANSLATE_3D_NV
      GL_TRANSLATE_X_NV
      GL_TRANSLATE_Y_NV
      GL_TRANSPOSE_AFFINE_2D_NV
      GL_TRANSPOSE_AFFINE_3D_NV
      GL_TRANSPOSE_COLOR_MATRIX
      GL_TRANSPOSE_COLOR_MATRIX_ARB
      GL_TRANSPOSE_CURRENT_MATRIX_ARB
      GL_TRANSPOSE_MODELVIEW_MATRIX
      GL_TRANSPOSE_MODELVIEW_MATRIX_ARB
      GL_TRANSPOSE_NV
      GL_TRANSPOSE_PROGRAM_MATRIX_EXT
      GL_TRANSPOSE_PROJECTION_MATRIX
      GL_TRANSPOSE_PROJECTION_MATRIX_ARB
      GL_TRANSPOSE_TEXTURE_MATRIX
      GL_TRANSPOSE_TEXTURE_MATRIX_ARB
      GL_TRIANGLES
      GL_TRIANGLES_ADJACENCY
      GL_TRIANGLES_ADJACENCY_ARB
      GL_TRIANGLES_ADJACENCY_EXT
      GL_TRIANGLE_FAN
      GL_TRIANGLE_LIST_SUN
      GL_TRIANGLE_MESH_SUN
      GL_TRIANGLE_STRIP
      GL_TRIANGLE_STRIP_ADJACENCY
      GL_TRIANGLE_STRIP_ADJACENCY_ARB
      GL_TRIANGLE_STRIP_ADJACENCY_EXT
      GL_TRIANGULAR_NV
      GL_TRUE
      GL_TYPE
      GL_UNCORRELATED_NV
      GL_UNDEFINED_APPLE
      GL_UNDEFINED_VERTEX
      GL_UNIFORM
      GL_UNIFORM_ADDRESS_COMMAND_NV
      GL_UNIFORM_ARRAY_STRIDE
      GL_UNIFORM_ATOMIC_COUNTER_BUFFER_INDEX
      GL_UNIFORM_BARRIER_BIT
      GL_UNIFORM_BARRIER_BIT_EXT
      GL_UNIFORM_BLOCK
      GL_UNIFORM_BLOCK_ACTIVE_UNIFORMS
      GL_UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES
      GL_UNIFORM_BLOCK_BINDING
      GL_UNIFORM_BLOCK_DATA_SIZE
      GL_UNIFORM_BLOCK_INDEX
      GL_UNIFORM_BLOCK_NAME_LENGTH
      GL_UNIFORM_BLOCK_REFERENCED_BY_COMPUTE_SHADER
      GL_UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER
      GL_UNIFORM_BLOCK_REFERENCED_BY_GEOMETRY_SHADER
      GL_UNIFORM_BLOCK_REFERENCED_BY_TESS_CONTROL_SHADER
      GL_UNIFORM_BLOCK_REFERENCED_BY_TESS_EVALUATION_SHADER
      GL_UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER
      GL_UNIFORM_BUFFER
      GL_UNIFORM_BUFFER_ADDRESS_NV
      GL_UNIFORM_BUFFER_BINDING
      GL_UNIFORM_BUFFER_BINDING_EXT
      GL_UNIFORM_BUFFER_EXT
      GL_UNIFORM_BUFFER_LENGTH_NV
      GL_UNIFORM_BUFFER_OFFSET_ALIGNMENT
      GL_UNIFORM_BUFFER_SIZE
      GL_UNIFORM_BUFFER_START
      GL_UNIFORM_BUFFER_UNIFIED_NV
      GL_UNIFORM_IS_ROW_MAJOR
      GL_UNIFORM_MATRIX_STRIDE
      GL_UNIFORM_NAME_LENGTH
      GL_UNIFORM_OFFSET
      GL_UNIFORM_SIZE
      GL_UNIFORM_TYPE
      GL_UNKNOWN_CONTEXT_RESET
      GL_UNKNOWN_CONTEXT_RESET_ARB
      GL_UNPACK_ALIGNMENT
      GL_UNPACK_CLIENT_STORAGE_APPLE
      GL_UNPACK_CMYK_HINT_EXT
      GL_UNPACK_COMPRESSED_BLOCK_DEPTH
      GL_UNPACK_COMPRESSED_BLOCK_HEIGHT
      GL_UNPACK_COMPRESSED_BLOCK_SIZE
      GL_UNPACK_COMPRESSED_BLOCK_WIDTH
      GL_UNPACK_CONSTANT_DATA_SUNX
      GL_UNPACK_IMAGE_HEIGHT
      GL_UNPACK_IMAGE_HEIGHT_EXT
      GL_UNPACK_LSB_FIRST
      GL_UNPACK_RESAMPLE_OML
      GL_UNPACK_RESAMPLE_SGIX
      GL_UNPACK_ROW_BYTES_APPLE
      GL_UNPACK_ROW_LENGTH
      GL_UNPACK_SKIP_IMAGES
      GL_UNPACK_SKIP_IMAGES_EXT
      GL_UNPACK_SKIP_PIXELS
      GL_UNPACK_SKIP_ROWS
      GL_UNPACK_SWAP_BYTES
      GL_UNSIGNALED
      GL_UNSIGNED_BYTE
      GL_UNSIGNED_BYTE_2_3_3_REV
      GL_UNSIGNED_BYTE_3_3_2
      GL_UNSIGNED_BYTE_3_3_2_EXT
      GL_UNSIGNED_IDENTITY_NV
      GL_UNSIGNED_INT
      GL_UNSIGNED_INT16_NV
      GL_UNSIGNED_INT16_VEC2_NV
      GL_UNSIGNED_INT16_VEC3_NV
      GL_UNSIGNED_INT16_VEC4_NV
      GL_UNSIGNED_INT64_AMD
      GL_UNSIGNED_INT64_ARB
      GL_UNSIGNED_INT64_NV
      GL_UNSIGNED_INT64_VEC2_ARB
      GL_UNSIGNED_INT64_VEC2_NV
      GL_UNSIGNED_INT64_VEC3_ARB
      GL_UNSIGNED_INT64_VEC3_NV
      GL_UNSIGNED_INT64_VEC4_ARB
      GL_UNSIGNED_INT64_VEC4_NV
      GL_UNSIGNED_INT8_NV
      GL_UNSIGNED_INT8_VEC2_NV
      GL_UNSIGNED_INT8_VEC3_NV
      GL_UNSIGNED_INT8_VEC4_NV
      GL_UNSIGNED_INT_10F_11F_11F_REV
      GL_UNSIGNED_INT_10F_11F_11F_REV_EXT
      GL_UNSIGNED_INT_10_10_10_2
      GL_UNSIGNED_INT_10_10_10_2_EXT
      GL_UNSIGNED_INT_24_8
      GL_UNSIGNED_INT_24_8_EXT
      GL_UNSIGNED_INT_24_8_NV
      GL_UNSIGNED_INT_2_10_10_10_REV
      GL_UNSIGNED_INT_5_9_9_9_REV
      GL_UNSIGNED_INT_5_9_9_9_REV_EXT
      GL_UNSIGNED_INT_8_8_8_8
      GL_UNSIGNED_INT_8_8_8_8_EXT
      GL_UNSIGNED_INT_8_8_8_8_REV
      GL_UNSIGNED_INT_8_8_S8_S8_REV_NV
      GL_UNSIGNED_INT_ATOMIC_COUNTER
      GL_UNSIGNED_INT_IMAGE_1D
      GL_UNSIGNED_INT_IMAGE_1D_ARRAY
      GL_UNSIGNED_INT_IMAGE_1D_ARRAY_EXT
      GL_UNSIGNED_INT_IMAGE_1D_EXT
      GL_UNSIGNED_INT_IMAGE_2D
      GL_UNSIGNED_INT_IMAGE_2D_ARRAY
      GL_UNSIGNED_INT_IMAGE_2D_ARRAY_EXT
      GL_UNSIGNED_INT_IMAGE_2D_EXT
      GL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE
      GL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE_ARRAY
      GL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE_ARRAY_EXT
      GL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE_EXT
      GL_UNSIGNED_INT_IMAGE_2D_RECT
      GL_UNSIGNED_INT_IMAGE_2D_RECT_EXT
      GL_UNSIGNED_INT_IMAGE_3D
      GL_UNSIGNED_INT_IMAGE_3D_EXT
      GL_UNSIGNED_INT_IMAGE_BUFFER
      GL_UNSIGNED_INT_IMAGE_BUFFER_EXT
      GL_UNSIGNED_INT_IMAGE_CUBE
      GL_UNSIGNED_INT_IMAGE_CUBE_EXT
      GL_UNSIGNED_INT_IMAGE_CUBE_MAP_ARRAY
      GL_UNSIGNED_INT_IMAGE_CUBE_MAP_ARRAY_EXT
      GL_UNSIGNED_INT_S8_S8_8_8_NV
      GL_UNSIGNED_INT_SAMPLER_1D
      GL_UNSIGNED_INT_SAMPLER_1D_ARRAY
      GL_UNSIGNED_INT_SAMPLER_1D_ARRAY_EXT
      GL_UNSIGNED_INT_SAMPLER_1D_EXT
      GL_UNSIGNED_INT_SAMPLER_2D
      GL_UNSIGNED_INT_SAMPLER_2D_ARRAY
      GL_UNSIGNED_INT_SAMPLER_2D_ARRAY_EXT
      GL_UNSIGNED_INT_SAMPLER_2D_EXT
      GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE
      GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE_ARRAY
      GL_UNSIGNED_INT_SAMPLER_2D_RECT
      GL_UNSIGNED_INT_SAMPLER_2D_RECT_EXT
      GL_UNSIGNED_INT_SAMPLER_3D
      GL_UNSIGNED_INT_SAMPLER_3D_EXT
      GL_UNSIGNED_INT_SAMPLER_BUFFER
      GL_UNSIGNED_INT_SAMPLER_BUFFER_AMD
      GL_UNSIGNED_INT_SAMPLER_BUFFER_EXT
      GL_UNSIGNED_INT_SAMPLER_CUBE
      GL_UNSIGNED_INT_SAMPLER_CUBE_EXT
      GL_UNSIGNED_INT_SAMPLER_CUBE_MAP_ARRAY
      GL_UNSIGNED_INT_SAMPLER_CUBE_MAP_ARRAY_ARB
      GL_UNSIGNED_INT_SAMPLER_RENDERBUFFER_NV
      GL_UNSIGNED_INT_VEC2
      GL_UNSIGNED_INT_VEC2_EXT
      GL_UNSIGNED_INT_VEC3
      GL_UNSIGNED_INT_VEC3_EXT
      GL_UNSIGNED_INT_VEC4
      GL_UNSIGNED_INT_VEC4_EXT
      GL_UNSIGNED_INVERT_NV
      GL_UNSIGNED_NORMALIZED
      GL_UNSIGNED_NORMALIZED_ARB
      GL_UNSIGNED_SHORT
      GL_UNSIGNED_SHORT_1_5_5_5_REV
      GL_UNSIGNED_SHORT_4_4_4_4
      GL_UNSIGNED_SHORT_4_4_4_4_EXT
      GL_UNSIGNED_SHORT_4_4_4_4_REV
      GL_UNSIGNED_SHORT_5_5_5_1
      GL_UNSIGNED_SHORT_5_5_5_1_EXT
      GL_UNSIGNED_SHORT_5_6_5
      GL_UNSIGNED_SHORT_5_6_5_REV
      GL_UNSIGNED_SHORT_8_8_APPLE
      GL_UNSIGNED_SHORT_8_8_MESA
      GL_UNSIGNED_SHORT_8_8_REV_APPLE
      GL_UNSIGNED_SHORT_8_8_REV_MESA
      GL_UPPER_LEFT
      GL_USE_MISSING_GLYPH_NV
      GL_UTF16_NV
      GL_UTF8_NV
      GL_V2F
      GL_V3F
      GL_VALIDATE_STATUS
      GL_VARIABLE_A_NV
      GL_VARIABLE_B_NV
      GL_VARIABLE_C_NV
      GL_VARIABLE_D_NV
      GL_VARIABLE_E_NV
      GL_VARIABLE_F_NV
      GL_VARIABLE_G_NV
      GL_VARIANT_ARRAY_EXT
      GL_VARIANT_ARRAY_POINTER_EXT
      GL_VARIANT_ARRAY_STRIDE_EXT
      GL_VARIANT_ARRAY_TYPE_EXT
      GL_VARIANT_DATATYPE_EXT
      GL_VARIANT_EXT
      GL_VARIANT_VALUE_EXT
      GL_VBO_FREE_MEMORY_ATI
      GL_VECTOR_EXT
      GL_VENDOR
      GL_VERSION
      GL_VERSION_1_1
      GL_VERSION_1_2
      GL_VERSION_1_2_1
      GL_VERSION_1_3
      GL_VERSION_1_4
      GL_VERSION_1_5
      GL_VERSION_2_0
      GL_VERSION_2_1
      GL_VERSION_3_0
      GL_VERSION_3_1
      GL_VERSION_3_2
      GL_VERSION_3_3
      GL_VERSION_4_0
      GL_VERSION_4_1
      GL_VERSION_4_2
      GL_VERSION_4_3
      GL_VERSION_4_4
      GL_VERSION_4_5
      GL_VERTEX23_BIT_PGI
      GL_VERTEX4_BIT_PGI
      GL_VERTEX_ARRAY
      GL_VERTEX_ARRAY_ADDRESS_NV
      GL_VERTEX_ARRAY_BINDING
      GL_VERTEX_ARRAY_BINDING_APPLE
      GL_VERTEX_ARRAY_BUFFER_BINDING
      GL_VERTEX_ARRAY_BUFFER_BINDING_ARB
      GL_VERTEX_ARRAY_COUNT_EXT
      GL_VERTEX_ARRAY_EXT
      GL_VERTEX_ARRAY_LENGTH_NV
      GL_VERTEX_ARRAY_LIST_IBM
      GL_VERTEX_ARRAY_LIST_STRIDE_IBM
      GL_VERTEX_ARRAY_OBJECT_AMD
      GL_VERTEX_ARRAY_OBJECT_EXT
      GL_VERTEX_ARRAY_PARALLEL_POINTERS_INTEL
      GL_VERTEX_ARRAY_POINTER
      GL_VERTEX_ARRAY_POINTER_EXT
      GL_VERTEX_ARRAY_RANGE_APPLE
      GL_VERTEX_ARRAY_RANGE_LENGTH_APPLE
      GL_VERTEX_ARRAY_RANGE_LENGTH_NV
      GL_VERTEX_ARRAY_RANGE_NV
      GL_VERTEX_ARRAY_RANGE_POINTER_APPLE
      GL_VERTEX_ARRAY_RANGE_POINTER_NV
      GL_VERTEX_ARRAY_RANGE_VALID_NV
      GL_VERTEX_ARRAY_RANGE_WITHOUT_FLUSH_NV
      GL_VERTEX_ARRAY_SIZE
      GL_VERTEX_ARRAY_SIZE_EXT
      GL_VERTEX_ARRAY_STORAGE_HINT_APPLE
      GL_VERTEX_ARRAY_STRIDE
      GL_VERTEX_ARRAY_STRIDE_EXT
      GL_VERTEX_ARRAY_TYPE
      GL_VERTEX_ARRAY_TYPE_EXT
      GL_VERTEX_ATTRIB_ARRAY0_NV
      GL_VERTEX_ATTRIB_ARRAY10_NV
      GL_VERTEX_ATTRIB_ARRAY11_NV
      GL_VERTEX_ATTRIB_ARRAY12_NV
      GL_VERTEX_ATTRIB_ARRAY13_NV
      GL_VERTEX_ATTRIB_ARRAY14_NV
      GL_VERTEX_ATTRIB_ARRAY15_NV
      GL_VERTEX_ATTRIB_ARRAY1_NV
      GL_VERTEX_ATTRIB_ARRAY2_NV
      GL_VERTEX_ATTRIB_ARRAY3_NV
      GL_VERTEX_ATTRIB_ARRAY4_NV
      GL_VERTEX_ATTRIB_ARRAY5_NV
      GL_VERTEX_ATTRIB_ARRAY6_NV
      GL_VERTEX_ATTRIB_ARRAY7_NV
      GL_VERTEX_ATTRIB_ARRAY8_NV
      GL_VERTEX_ATTRIB_ARRAY9_NV
      GL_VERTEX_ATTRIB_ARRAY_ADDRESS_NV
      GL_VERTEX_ATTRIB_ARRAY_BARRIER_BIT
      GL_VERTEX_ATTRIB_ARRAY_BARRIER_BIT_EXT
      GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING
      GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING_ARB
      GL_VERTEX_ATTRIB_ARRAY_DIVISOR
      GL_VERTEX_ATTRIB_ARRAY_DIVISOR_ANGLE
      GL_VERTEX_ATTRIB_ARRAY_DIVISOR_ARB
      GL_VERTEX_ATTRIB_ARRAY_ENABLED
      GL_VERTEX_ATTRIB_ARRAY_ENABLED_ARB
      GL_VERTEX_ATTRIB_ARRAY_INTEGER
      GL_VERTEX_ATTRIB_ARRAY_INTEGER_EXT
      GL_VERTEX_ATTRIB_ARRAY_INTEGER_NV
      GL_VERTEX_ATTRIB_ARRAY_LENGTH_NV
      GL_VERTEX_ATTRIB_ARRAY_LONG
      GL_VERTEX_ATTRIB_ARRAY_NORMALIZED
      GL_VERTEX_ATTRIB_ARRAY_NORMALIZED_ARB
      GL_VERTEX_ATTRIB_ARRAY_POINTER
      GL_VERTEX_ATTRIB_ARRAY_POINTER_ARB
      GL_VERTEX_ATTRIB_ARRAY_SIZE
      GL_VERTEX_ATTRIB_ARRAY_SIZE_ARB
      GL_VERTEX_ATTRIB_ARRAY_STRIDE
      GL_VERTEX_ATTRIB_ARRAY_STRIDE_ARB
      GL_VERTEX_ATTRIB_ARRAY_TYPE
      GL_VERTEX_ATTRIB_ARRAY_TYPE_ARB
      GL_VERTEX_ATTRIB_ARRAY_UNIFIED_NV
      GL_VERTEX_ATTRIB_BINDING
      GL_VERTEX_ATTRIB_MAP1_APPLE
      GL_VERTEX_ATTRIB_MAP1_COEFF_APPLE
      GL_VERTEX_ATTRIB_MAP1_DOMAIN_APPLE
      GL_VERTEX_ATTRIB_MAP1_ORDER_APPLE
      GL_VERTEX_ATTRIB_MAP1_SIZE_APPLE
      GL_VERTEX_ATTRIB_MAP2_APPLE
      GL_VERTEX_ATTRIB_MAP2_COEFF_APPLE
      GL_VERTEX_ATTRIB_MAP2_DOMAIN_APPLE
      GL_VERTEX_ATTRIB_MAP2_ORDER_APPLE
      GL_VERTEX_ATTRIB_MAP2_SIZE_APPLE
      GL_VERTEX_ATTRIB_RELATIVE_OFFSET
      GL_VERTEX_BINDING_BUFFER
      GL_VERTEX_BINDING_DIVISOR
      GL_VERTEX_BINDING_OFFSET
      GL_VERTEX_BINDING_STRIDE
      GL_VERTEX_BLEND_ARB
      GL_VERTEX_CONSISTENT_HINT_PGI
      GL_VERTEX_DATA_HINT_PGI
      GL_VERTEX_ELEMENT_SWIZZLE_AMD
      GL_VERTEX_ID_NV
      GL_VERTEX_ID_SWIZZLE_AMD
      GL_VERTEX_PRECLIP_HINT_SGIX
      GL_VERTEX_PRECLIP_SGIX
      GL_VERTEX_PROGRAM_ARB
      GL_VERTEX_PROGRAM_BINDING_NV
      GL_VERTEX_PROGRAM_NV
      GL_VERTEX_PROGRAM_PARAMETER_BUFFER_NV
      GL_VERTEX_PROGRAM_POINT_SIZE
      GL_VERTEX_PROGRAM_POINT_SIZE_ARB
      GL_VERTEX_PROGRAM_POINT_SIZE_NV
      GL_VERTEX_PROGRAM_TWO_SIDE
      GL_VERTEX_PROGRAM_TWO_SIDE_ARB
      GL_VERTEX_PROGRAM_TWO_SIDE_NV
      GL_VERTEX_SHADER
      GL_VERTEX_SHADER_ARB
      GL_VERTEX_SHADER_BINDING_EXT
      GL_VERTEX_SHADER_BIT
      GL_VERTEX_SHADER_EXT
      GL_VERTEX_SHADER_INSTRUCTIONS_EXT
      GL_VERTEX_SHADER_INVARIANTS_EXT
      GL_VERTEX_SHADER_INVOCATIONS_ARB
      GL_VERTEX_SHADER_LOCALS_EXT
      GL_VERTEX_SHADER_LOCAL_CONSTANTS_EXT
      GL_VERTEX_SHADER_OPTIMIZED_EXT
      GL_VERTEX_SHADER_VARIANTS_EXT
      GL_VERTEX_SOURCE_ATI
      GL_VERTEX_STATE_PROGRAM_NV
      GL_VERTEX_STREAM0_ATI
      GL_VERTEX_STREAM1_ATI
      GL_VERTEX_STREAM2_ATI
      GL_VERTEX_STREAM3_ATI
      GL_VERTEX_STREAM4_ATI
      GL_VERTEX_STREAM5_ATI
      GL_VERTEX_STREAM6_ATI
      GL_VERTEX_STREAM7_ATI
      GL_VERTEX_SUBROUTINE
      GL_VERTEX_SUBROUTINE_UNIFORM
      GL_VERTEX_TEXTURE
      GL_VERTEX_WEIGHTING_EXT
      GL_VERTEX_WEIGHT_ARRAY_EXT
      GL_VERTEX_WEIGHT_ARRAY_POINTER_EXT
      GL_VERTEX_WEIGHT_ARRAY_SIZE_EXT
      GL_VERTEX_WEIGHT_ARRAY_STRIDE_EXT
      GL_VERTEX_WEIGHT_ARRAY_TYPE_EXT
      GL_VERTICAL_LINE_TO_NV
      GL_VERTICES_SUBMITTED_ARB
      GL_VIBRANCE_BIAS_NV
      GL_VIBRANCE_SCALE_NV
      GL_VIDEO_BUFFER_BINDING_NV
      GL_VIDEO_BUFFER_INTERNAL_FORMAT_NV
      GL_VIDEO_BUFFER_NV
      GL_VIDEO_BUFFER_PITCH_NV
      GL_VIDEO_CAPTURE_FIELD_LOWER_HEIGHT_NV
      GL_VIDEO_CAPTURE_FIELD_UPPER_HEIGHT_NV
      GL_VIDEO_CAPTURE_FRAME_HEIGHT_NV
      GL_VIDEO_CAPTURE_FRAME_WIDTH_NV
      GL_VIDEO_CAPTURE_SURFACE_ORIGIN_NV
      GL_VIDEO_CAPTURE_TO_422_SUPPORTED_NV
      GL_VIDEO_COLOR_CONVERSION_MATRIX_NV
      GL_VIDEO_COLOR_CONVERSION_MAX_NV
      GL_VIDEO_COLOR_CONVERSION_MIN_NV
      GL_VIDEO_COLOR_CONVERSION_OFFSET_NV
      GL_VIEWPORT
      GL_VIEWPORT_BIT
      GL_VIEWPORT_BOUNDS_RANGE
      GL_VIEWPORT_COMMAND_NV
      GL_VIEWPORT_INDEX_PROVOKING_VERTEX
      GL_VIEWPORT_POSITION_W_SCALE_NV
      GL_VIEWPORT_POSITION_W_SCALE_X_COEFF_NV
      GL_VIEWPORT_POSITION_W_SCALE_Y_COEFF_NV
      GL_VIEWPORT_SUBPIXEL_BITS
      GL_VIEWPORT_SWIZZLE_NEGATIVE_W_NV
      GL_VIEWPORT_SWIZZLE_NEGATIVE_X_NV
      GL_VIEWPORT_SWIZZLE_NEGATIVE_Y_NV
      GL_VIEWPORT_SWIZZLE_NEGATIVE_Z_NV
      GL_VIEWPORT_SWIZZLE_POSITIVE_W_NV
      GL_VIEWPORT_SWIZZLE_POSITIVE_X_NV
      GL_VIEWPORT_SWIZZLE_POSITIVE_Y_NV
      GL_VIEWPORT_SWIZZLE_POSITIVE_Z_NV
      GL_VIEWPORT_SWIZZLE_W_NV
      GL_VIEWPORT_SWIZZLE_X_NV
      GL_VIEWPORT_SWIZZLE_Y_NV
      GL_VIEWPORT_SWIZZLE_Z_NV
      GL_VIEW_CLASS_128_BITS
      GL_VIEW_CLASS_16_BITS
      GL_VIEW_CLASS_24_BITS
      GL_VIEW_CLASS_32_BITS
      GL_VIEW_CLASS_48_BITS
      GL_VIEW_CLASS_64_BITS
      GL_VIEW_CLASS_8_BITS
      GL_VIEW_CLASS_96_BITS
      GL_VIEW_CLASS_BPTC_FLOAT
      GL_VIEW_CLASS_BPTC_UNORM
      GL_VIEW_CLASS_RGTC1_RED
      GL_VIEW_CLASS_RGTC2_RG
      GL_VIEW_CLASS_S3TC_DXT1_RGB
      GL_VIEW_CLASS_S3TC_DXT1_RGBA
      GL_VIEW_CLASS_S3TC_DXT3_RGBA
      GL_VIEW_CLASS_S3TC_DXT5_RGBA
      GL_VIEW_COMPATIBILITY_CLASS
      GL_VIRTUAL_PAGE_SIZE_INDEX_ARB
      GL_VIRTUAL_PAGE_SIZE_X_AMD
      GL_VIRTUAL_PAGE_SIZE_X_ARB
      GL_VIRTUAL_PAGE_SIZE_Y_AMD
      GL_VIRTUAL_PAGE_SIZE_Y_ARB
      GL_VIRTUAL_PAGE_SIZE_Z_AMD
      GL_VIRTUAL_PAGE_SIZE_Z_ARB
      GL_VIVIDLIGHT_NV
      GL_VOLATILE_APPLE
      GL_WAIT_FAILED
      GL_WARPS_PER_SM_NV
      GL_WARP_SIZE_NV
      GL_WEIGHTED_AVERAGE_ARB
      GL_WEIGHTED_AVERAGE_EXT
      GL_WEIGHT_ARRAY_ARB
      GL_WEIGHT_ARRAY_BUFFER_BINDING
      GL_WEIGHT_ARRAY_BUFFER_BINDING_ARB
      GL_WEIGHT_ARRAY_POINTER_ARB
      GL_WEIGHT_ARRAY_SIZE_ARB
      GL_WEIGHT_ARRAY_STRIDE_ARB
      GL_WEIGHT_ARRAY_TYPE_ARB
      GL_WEIGHT_SUM_UNITY_ARB
      GL_WIDE_LINE_HINT_PGI
      GL_WINDOW_RECTANGLE_EXT
      GL_WINDOW_RECTANGLE_MODE_EXT
      GL_WIN_phong_shading
      GL_WIN_specular_fog
      GL_WIN_swap_hint
      GL_WRAP_BORDER
      GL_WRAP_BORDER_SUN
      GL_WRITE_DISCARD_NV
      GL_WRITE_ONLY
      GL_WRITE_ONLY_ARB
      GL_WRITE_PIXEL_DATA_RANGE_LENGTH_NV
      GL_WRITE_PIXEL_DATA_RANGE_NV
      GL_WRITE_PIXEL_DATA_RANGE_POINTER_NV
      GL_W_EXT
      GL_XOR
      GL_XOR_NV
      GL_X_EXT
      GL_YCBAYCR8A_4224_NV
      GL_YCBCR_422_APPLE
      GL_YCBCR_MESA
      GL_YCBYCR8_422_NV
      GL_Y_EXT
      GL_Z4Y12Z4CB12Z4A12Z4Y12Z4CR12Z4A12_4224_NV
      GL_Z4Y12Z4CB12Z4CR12_444_NV
      GL_Z4Y12Z4CB12Z4Y12Z4CR12_422_NV
      GL_Z6Y10Z6CB10Z6A10Z6Y10Z6CR10Z6A10_4224_NV
      GL_Z6Y10Z6CB10Z6Y10Z6CR10_422_NV
      GL_ZERO
      GL_ZERO_EXT
      GL_ZERO_TO_ONE
      GL_ZOOM_X
      GL_ZOOM_Y
      GL_Z_EXT
      MAX_VERTEX_TEXTURE_IMAGE_UNITS_ARB
      glActiveProgramEXT
      glActiveShaderProgram
      glActiveStencilFaceEXT
      glActiveTexture
      glActiveTextureARB
      glActiveVaryingNV
      glAddSwapHintRectWIN
      glAlphaFragmentOp1ATI
      glAlphaFragmentOp2ATI
      glAlphaFragmentOp3ATI
      glAlphaFuncx
      glApplyTextureEXT
      glAreProgramsResidentNV
      glAreTexturesResidentEXT
      glArrayElementEXT
      glArrayObjectATI
      glAsyncMarkerSGIX
      glAttachObjectARB
      glAttachShader
      glBeginConditionalRender
      glBeginConditionalRenderNV
      glBeginConditionalRenderNVX
      glBeginFragmentShaderATI
      glBeginOcclusionQueryNV
      glBeginPerfMonitorAMD
      glBeginPerfQueryINTEL
      glBeginQuery
      glBeginQueryANGLE
      glBeginQueryARB
      glBeginQueryIndexed
      glBeginSceneEXT
      glBeginTransformFeedback
      glBeginTransformFeedbackEXT
      glBeginTransformFeedbackNV
      glBeginVertexShaderEXT
      glBeginVideoCaptureNV
      glBindAttribLocation
      glBindAttribLocationARB
      glBindBuffer
      glBindBufferARB
      glBindBufferBase
      glBindBufferBaseEXT
      glBindBufferBaseNV
      glBindBufferOffsetEXT
      glBindBufferOffsetNV
      glBindBufferRange
      glBindBufferRangeEXT
      glBindBufferRangeNV
      glBindBuffersBase
      glBindBuffersRange
      glBindFragDataLocation
      glBindFragDataLocationEXT
      glBindFragDataLocationIndexed
      glBindFragmentShaderATI
      glBindFramebuffer
      glBindFramebufferEXT
      glBindImageTexture
      glBindImageTextureEXT
      glBindImageTextures
      glBindLightParameterEXT
      glBindMaterialParameterEXT
      glBindMultiTextureEXT
      glBindParameterEXT
      glBindProgramARB
      glBindProgramNV
      glBindProgramPipeline
      glBindRenderbuffer
      glBindRenderbufferEXT
      glBindSampler
      glBindSamplers
      glBindTexGenParameterEXT
      glBindTextureEXT
      glBindTextureUnit
      glBindTextureUnitParameterEXT
      glBindTextures
      glBindTransformFeedback
      glBindTransformFeedbackNV
      glBindVertexArray
      glBindVertexArrayAPPLE
      glBindVertexBuffer
      glBindVertexBuffers
      glBindVertexShaderEXT
      glBindVideoCaptureStreamBufferNV
      glBindVideoCaptureStreamTextureNV
      glBinormalPointerEXT
      glBlendBarrierKHR
      glBlendBarrierNV
      glBlendColor
      glBlendColorEXT
      glBlendEquation
      glBlendEquationEXT
      glBlendEquationIndexedAMD
      glBlendEquationSeparate
      glBlendEquationSeparateEXT
      glBlendEquationSeparateIndexedAMD
      glBlendEquationSeparatei
      glBlendEquationSeparateiARB
      glBlendEquationi
      glBlendEquationiARB
      glBlendFuncIndexedAMD
      glBlendFuncSeparate
      glBlendFuncSeparateEXT
      glBlendFuncSeparateIndexedAMD
      glBlendFuncSeparatei
      glBlendFuncSeparateiARB
      glBlendFunci
      glBlendFunciARB
      glBlendParameteriNV
      glBlitFramebuffer
      glBlitFramebufferANGLE
      glBlitFramebufferEXT
      glBlitNamedFramebuffer
      glBufferAddressRangeNV
      glBufferData
      glBufferDataARB
      glBufferPageCommitmentARB
      glBufferParameteriAPPLE
      glBufferRegionEnabled
      glBufferStorage
      glBufferSubData
      glBufferSubDataARB
      glCallCommandListNV
      glCheckFramebufferStatus
      glCheckFramebufferStatusEXT
      glCheckNamedFramebufferStatus
      glCheckNamedFramebufferStatusEXT
      glClampColor
      glClampColorARB
      glClearBufferData
      glClearBufferSubData
      glClearBufferfi
      glClearBufferfv
      glClearBufferiv
      glClearBufferuiv
      glClearColorIiEXT
      glClearColorIuiEXT
      glClearColorx
      glClearDepthdNV
      glClearDepthf
      glClearDepthfOES
      glClearDepthx
      glClearNamedBufferData
      glClearNamedBufferDataEXT
      glClearNamedBufferSubData
      glClearNamedBufferSubDataEXT
      glClearNamedFramebufferfi
      glClearNamedFramebufferfv
      glClearNamedFramebufferiv
      glClearNamedFramebufferuiv
      glClearTexImage
      glClearTexSubImage
      glClientActiveTexture
      glClientActiveTextureARB
      glClientActiveVertexStreamATI
      glClientAttribDefaultEXT
      glClientWaitSync
      glClipControl
      glClipPlanef
      glClipPlanefOES
      glClipPlanex
      glColor3fVertex3fSUN
      glColor3fVertex3fvSUN
      glColor3hNV
      glColor3hvNV
      glColor4fNormal3fVertex3fSUN
      glColor4fNormal3fVertex3fvSUN
      glColor4hNV
      glColor4hvNV
      glColor4ubVertex2fSUN
      glColor4ubVertex2fvSUN
      glColor4ubVertex3fSUN
      glColor4ubVertex3fvSUN
      glColor4x
      glColorFormatNV
      glColorFragmentOp1ATI
      glColorFragmentOp2ATI
      glColorFragmentOp3ATI
      glColorMaskIndexedEXT
      glColorMaski
      glColorP3ui
      glColorP3uiv
      glColorP4ui
      glColorP4uiv
      glColorPointerEXT
      glColorPointerListIBM
      glColorPointervINTEL
      glColorSubTable
      glColorSubTableEXT
      glColorTable
      glColorTableEXT
      glColorTableParameterfv
      glColorTableParameterfvSGI
      glColorTableParameteriv
      glColorTableParameterivSGI
      glColorTableSGI
      glCombinerInputNV
      glCombinerOutputNV
      glCombinerParameterfNV
      glCombinerParameterfvNV
      glCombinerParameteriNV
      glCombinerParameterivNV
      glCombinerStageParameterfvNV
      glCommandListSegmentsNV
      glCompileCommandListNV
      glCompileShader
      glCompileShaderARB
      glCompileShaderIncludeARB
      glCompressedMultiTexImage1DEXT
      glCompressedMultiTexImage2DEXT
      glCompressedMultiTexImage3DEXT
      glCompressedMultiTexSubImage1DEXT
      glCompressedMultiTexSubImage2DEXT
      glCompressedMultiTexSubImage3DEXT
      glCompressedTexImage1D
      glCompressedTexImage1DARB
      glCompressedTexImage2D
      glCompressedTexImage2DARB
      glCompressedTexImage3D
      glCompressedTexImage3DARB
      glCompressedTexSubImage1D
      glCompressedTexSubImage1DARB
      glCompressedTexSubImage2D
      glCompressedTexSubImage2DARB
      glCompressedTexSubImage3D
      glCompressedTexSubImage3DARB
      glCompressedTextureImage1DEXT
      glCompressedTextureImage2DEXT
      glCompressedTextureImage3DEXT
      glCompressedTextureSubImage1D
      glCompressedTextureSubImage1DEXT
      glCompressedTextureSubImage2D
      glCompressedTextureSubImage2DEXT
      glCompressedTextureSubImage3D
      glCompressedTextureSubImage3DEXT
      glConservativeRasterParameterfNV
      glConservativeRasterParameteriNV
      glConvolutionFilter1D
      glConvolutionFilter1DEXT
      glConvolutionFilter2D
      glConvolutionFilter2DEXT
      glConvolutionParameterf
      glConvolutionParameterfEXT
      glConvolutionParameterfv
      glConvolutionParameterfvEXT
      glConvolutionParameteri
      glConvolutionParameteriEXT
      glConvolutionParameteriv
      glConvolutionParameterivEXT
      glCopyBufferSubData
      glCopyColorSubTable
      glCopyColorSubTableEXT
      glCopyColorTable
      glCopyColorTableSGI
      glCopyConvolutionFilter1D
      glCopyConvolutionFilter1DEXT
      glCopyConvolutionFilter2D
      glCopyConvolutionFilter2DEXT
      glCopyImageSubData
      glCopyImageSubDataNV
      glCopyMultiTexImage1DEXT
      glCopyMultiTexImage2DEXT
      glCopyMultiTexSubImage1DEXT
      glCopyMultiTexSubImage2DEXT
      glCopyMultiTexSubImage3DEXT
      glCopyNamedBufferSubData
      glCopyPathNV
      glCopyTexImage1DEXT
      glCopyTexImage2DEXT
      glCopyTexSubImage1DEXT
      glCopyTexSubImage2DEXT
      glCopyTexSubImage3D
      glCopyTexSubImage3DEXT
      glCopyTextureImage1DEXT
      glCopyTextureImage2DEXT
      glCopyTextureSubImage1D
      glCopyTextureSubImage1DEXT
      glCopyTextureSubImage2D
      glCopyTextureSubImage2DEXT
      glCopyTextureSubImage3D
      glCopyTextureSubImage3DEXT
      glCoverFillPathInstancedNV
      glCoverFillPathNV
      glCoverStrokePathInstancedNV
      glCoverStrokePathNV
      glCoverageModulationNV
      glCoverageModulationTableNV
      glCreateBuffers
      glCreateCommandListsNV
      glCreateFramebuffers
      glCreatePerfQueryINTEL
      glCreateProgram
      glCreateProgramObjectARB
      glCreateProgramPipelines
      glCreateQueries
      glCreateRenderbuffers
      glCreateSamplers
      glCreateShader
      glCreateShaderObjectARB
      glCreateShaderProgramEXT
      glCreateShaderProgramv
      glCreateStatesNV
      glCreateSyncFromCLeventARB
      glCreateTextures
      glCreateTransformFeedbacks
      glCreateVertexArrays
      glCullParameterdvEXT
      glCullParameterfvEXT
      glCurrentPaletteMatrixARB
      glDebugMessageCallback
      glDebugMessageCallbackAMD
      glDebugMessageCallbackARB
      glDebugMessageControl
      glDebugMessageControlARB
      glDebugMessageEnableAMD
      glDebugMessageInsert
      glDebugMessageInsertAMD
      glDebugMessageInsertARB
      glDeleteAsyncMarkersSGIX
      glDeleteBufferRegion
      glDeleteBuffers
      glDeleteBuffersARB
      glDeleteCommandListsNV
      glDeleteFencesAPPLE
      glDeleteFencesNV
      glDeleteFragmentShaderATI
      glDeleteFramebuffers
      glDeleteFramebuffersEXT
      glDeleteNamedStringARB
      glDeleteNamesAMD
      glDeleteObjectARB
      glDeleteOcclusionQueriesNV
      glDeletePathsNV
      glDeletePerfMonitorsAMD
      glDeletePerfQueryINTEL
      glDeleteProgram
      glDeleteProgramPipelines
      glDeleteProgramsARB
      glDeleteProgramsNV
      glDeleteQueries
      glDeleteQueriesANGLE
      glDeleteQueriesARB
      glDeleteRenderbuffers
      glDeleteRenderbuffersEXT
      glDeleteSamplers
      glDeleteShader
      glDeleteStatesNV
      glDeleteSync
      glDeleteTexturesEXT
      glDeleteTransformFeedbacks
      glDeleteTransformFeedbacksNV
      glDeleteVertexArrays
      glDeleteVertexArraysAPPLE
      glDeleteVertexShaderEXT
      glDepthBoundsEXT
      glDepthBoundsdNV
      glDepthRangeArrayv
      glDepthRangeIndexed
      glDepthRangedNV
      glDepthRangef
      glDepthRangefOES
      glDepthRangex
      glDetachObjectARB
      glDetachShader
      glDetailTexFuncSGIS
      glDisableClientStateIndexedEXT
      glDisableClientStateiEXT
      glDisableIndexedEXT
      glDisableVariantClientStateEXT
      glDisableVertexArrayAttrib
      glDisableVertexArrayAttribEXT
      glDisableVertexArrayEXT
      glDisableVertexAttribAPPLE
      glDisableVertexAttribArray
      glDisableVertexAttribArrayARB
      glDisablei
      glDispatchCompute
      glDispatchComputeGroupSizeARB
      glDispatchComputeIndirect
      glDrawArraysEXT
      glDrawArraysIndirect
      glDrawArraysInstanced
      glDrawArraysInstancedANGLE
      glDrawArraysInstancedARB
      glDrawArraysInstancedBaseInstance
      glDrawArraysInstancedEXT
      glDrawBufferRegion
      glDrawBuffers
      glDrawBuffersARB
      glDrawBuffersATI
      glDrawCommandsAddressNV
      glDrawCommandsNV
      glDrawCommandsStatesAddressNV
      glDrawCommandsStatesNV
      glDrawElementArrayAPPLE
      glDrawElementArrayATI
      glDrawElementsBaseVertex
      glDrawElementsIndirect
      glDrawElementsInstanced
      glDrawElementsInstancedANGLE
      glDrawElementsInstancedARB
      glDrawElementsInstancedBaseInstance
      glDrawElementsInstancedBaseVertex
      glDrawElementsInstancedBaseVertexBaseInstance
      glDrawElementsInstancedEXT
      glDrawRangeElementArrayAPPLE
      glDrawRangeElementArrayATI
      glDrawRangeElements
      glDrawRangeElementsBaseVertex
      glDrawRangeElementsEXT
      glDrawTextureNV
      glDrawTransformFeedback
      glDrawTransformFeedbackInstanced
      glDrawTransformFeedbackNV
      glDrawTransformFeedbackStream
      glDrawTransformFeedbackStreamInstanced
      glDrawVkImageNV
      glEdgeFlagFormatNV
      glEdgeFlagPointerEXT
      glEdgeFlagPointerListIBM
      glElementPointerAPPLE
      glElementPointerATI
      glEnableClientStateIndexedEXT
      glEnableClientStateiEXT
      glEnableIndexedEXT
      glEnableVariantClientStateEXT
      glEnableVertexArrayAttrib
      glEnableVertexArrayAttribEXT
      glEnableVertexArrayEXT
      glEnableVertexAttribAPPLE
      glEnableVertexAttribArray
      glEnableVertexAttribArrayARB
      glEnablei
      glEndConditionalRender
      glEndConditionalRenderNV
      glEndConditionalRenderNVX
      glEndFragmentShaderATI
      glEndOcclusionQueryNV
      glEndPerfMonitorAMD
      glEndPerfQueryINTEL
      glEndQuery
      glEndQueryANGLE
      glEndQueryARB
      glEndQueryIndexed
      glEndSceneEXT
      glEndTransformFeedback
      glEndTransformFeedbackEXT
      glEndTransformFeedbackNV
      glEndVertexShaderEXT
      glEndVideoCaptureNV
      glErrorStringREGAL
      glEvalMapsNV
      glExecuteProgramNV
      glExtractComponentEXT
      glFenceSync
      glFinalCombinerInputNV
      glFinishAsyncSGIX
      glFinishFenceAPPLE
      glFinishFenceNV
      glFinishObjectAPPLE
      glFinishTextureSUNX
      glFlushMappedBufferRange
      glFlushMappedBufferRangeAPPLE
      glFlushMappedNamedBufferRange
      glFlushMappedNamedBufferRangeEXT
      glFlushPixelDataRangeNV
      glFlushRasterSGIX
      glFlushVertexArrayRangeAPPLE
      glFlushVertexArrayRangeNV
      glFogCoordFormatNV
      glFogCoordPointer
      glFogCoordPointerEXT
      glFogCoordPointerListIBM
      glFogCoordd
      glFogCoorddEXT
      glFogCoorddv
      glFogCoorddvEXT
      glFogCoordf
      glFogCoordfEXT
      glFogCoordfv
      glFogCoordfvEXT
      glFogCoordhNV
      glFogCoordhvNV
      glFogFuncSGIS
      glFogx
      glFogxv
      glFragmentColorMaterialEXT
      glFragmentColorMaterialSGIX
      glFragmentCoverageColorNV
      glFragmentLightModelfEXT
      glFragmentLightModelfSGIX
      glFragmentLightModelfvEXT
      glFragmentLightModelfvSGIX
      glFragmentLightModeliEXT
      glFragmentLightModeliSGIX
      glFragmentLightModelivEXT
      glFragmentLightModelivSGIX
      glFragmentLightfEXT
      glFragmentLightfSGIX
      glFragmentLightfvEXT
      glFragmentLightfvSGIX
      glFragmentLightiEXT
      glFragmentLightiSGIX
      glFragmentLightivEXT
      glFragmentLightivSGIX
      glFragmentMaterialfEXT
      glFragmentMaterialfSGIX
      glFragmentMaterialfvEXT
      glFragmentMaterialfvSGIX
      glFragmentMaterialiEXT
      glFragmentMaterialiSGIX
      glFragmentMaterialivEXT
      glFragmentMaterialivSGIX
      glFrameTerminatorGREMEDY
      glFrameZoomSGIX
      glFramebufferDrawBufferEXT
      glFramebufferDrawBuffersEXT
      glFramebufferParameteri
      glFramebufferReadBufferEXT
      glFramebufferRenderbuffer
      glFramebufferRenderbufferEXT
      glFramebufferSampleLocationsfvARB
      glFramebufferSampleLocationsfvNV
      glFramebufferTexture
      glFramebufferTexture1D
      glFramebufferTexture1DEXT
      glFramebufferTexture2D
      glFramebufferTexture2DEXT
      glFramebufferTexture3D
      glFramebufferTexture3DEXT
      glFramebufferTextureARB
      glFramebufferTextureEXT
      glFramebufferTextureFaceARB
      glFramebufferTextureFaceEXT
      glFramebufferTextureLayer
      glFramebufferTextureLayerARB
      glFramebufferTextureLayerEXT
      glFramebufferTextureMultiviewOVR
      glFreeObjectBufferATI
      glFrustumf
      glFrustumfOES
      glFrustumx
      glGenAsyncMarkersSGIX
      glGenBuffers
      glGenBuffersARB
      glGenFencesAPPLE
      glGenFencesNV
      glGenFragmentShadersATI
      glGenFramebuffers
      glGenFramebuffersEXT
      glGenNamesAMD
      glGenOcclusionQueriesNV
      glGenPathsNV
      glGenPerfMonitorsAMD
      glGenProgramPipelines
      glGenProgramsARB
      glGenProgramsNV
      glGenQueries
      glGenQueriesANGLE
      glGenQueriesARB
      glGenRenderbuffers
      glGenRenderbuffersEXT
      glGenSamplers
      glGenSymbolsEXT
      glGenTexturesEXT
      glGenTransformFeedbacks
      glGenTransformFeedbacksNV
      glGenVertexArrays
      glGenVertexArraysAPPLE
      glGenVertexShadersEXT
      glGenerateMipmap
      glGenerateMipmapEXT
      glGenerateMultiTexMipmapEXT
      glGenerateTextureMipmap
      glGenerateTextureMipmapEXT
      glGetActiveAtomicCounterBufferiv
      glGetActiveAttrib
      glGetActiveAttribARB
      glGetActiveSubroutineName
      glGetActiveSubroutineUniformName
      glGetActiveSubroutineUniformiv
      glGetActiveUniform
      glGetActiveUniformARB
      glGetActiveUniformBlockName
      glGetActiveUniformBlockiv
      glGetActiveUniformName
      glGetActiveUniformsiv
      glGetActiveVaryingNV
      glGetArrayObjectfvATI
      glGetArrayObjectivATI
      glGetAttachedObjectsARB
      glGetAttachedShaders
      glGetAttribLocation
      glGetAttribLocationARB
      glGetBooleanIndexedvEXT
      glGetBooleani_v
      glGetBufferParameteri64v
      glGetBufferParameteriv
      glGetBufferParameterivARB
      glGetBufferParameterui64vNV
      glGetBufferPointerv
      glGetBufferPointervARB
      glGetBufferSubData
      glGetBufferSubDataARB
      glGetClipPlanef
      glGetClipPlanefOES
      glGetClipPlanex
      glGetColorTable
      glGetColorTableEXT
      glGetColorTableParameterfv
      glGetColorTableParameterfvEXT
      glGetColorTableParameterfvSGI
      glGetColorTableParameteriv
      glGetColorTableParameterivEXT
      glGetColorTableParameterivSGI
      glGetColorTableSGI
      glGetCombinerInputParameterfvNV
      glGetCombinerInputParameterivNV
      glGetCombinerOutputParameterfvNV
      glGetCombinerOutputParameterivNV
      glGetCombinerStageParameterfvNV
      glGetCommandHeaderNV
      glGetCompressedMultiTexImageEXT
      glGetCompressedTexImage
      glGetCompressedTexImageARB
      glGetCompressedTextureImage
      glGetCompressedTextureImageEXT
      glGetCompressedTextureSubImage
      glGetConvolutionFilter
      glGetConvolutionFilterEXT
      glGetConvolutionParameterfv
      glGetConvolutionParameterfvEXT
      glGetConvolutionParameteriv
      glGetConvolutionParameterivEXT
      glGetCoverageModulationTableNV
      glGetDebugMessageLog
      glGetDebugMessageLogAMD
      glGetDebugMessageLogARB
      glGetDetailTexFuncSGIS
      glGetDoubleIndexedvEXT
      glGetDoublei_v
      glGetDoublei_vEXT
      glGetExtensionREGAL
      glGetFenceivNV
      glGetFinalCombinerInputParameterfvNV
      glGetFinalCombinerInputParameterivNV
      glGetFirstPerfQueryIdINTEL
      glGetFixedv
      glGetFloatIndexedvEXT
      glGetFloati_v
      glGetFloati_vEXT
      glGetFogFuncSGIS
      glGetFragDataIndex
      glGetFragDataLocation
      glGetFragDataLocationEXT
      glGetFragmentLightfvEXT
      glGetFragmentLightfvSGIX
      glGetFragmentLightivEXT
      glGetFragmentLightivSGIX
      glGetFragmentMaterialfvEXT
      glGetFragmentMaterialfvSGIX
      glGetFragmentMaterialivEXT
      glGetFragmentMaterialivSGIX
      glGetFramebufferAttachmentParameteriv
      glGetFramebufferAttachmentParameterivEXT
      glGetFramebufferParameteriv
      glGetFramebufferParameterivEXT
      glGetGraphicsResetStatus
      glGetGraphicsResetStatusARB
      glGetHandleARB
      glGetHistogram
      glGetHistogramEXT
      glGetHistogramParameterfv
      glGetHistogramParameterfvEXT
      glGetHistogramParameteriv
      glGetHistogramParameterivEXT
      glGetImageHandleARB
      glGetImageHandleNV
      glGetImageTransformParameterfvHP
      glGetImageTransformParameterivHP
      glGetInfoLogARB
      glGetInteger64i_v
      glGetInteger64v
      glGetIntegerIndexedvEXT
      glGetIntegeri_v
      glGetIntegerui64i_vNV
      glGetIntegerui64vNV
      glGetInternalformatSampleivNV
      glGetInternalformati64v
      glGetInternalformativ
      glGetInvariantBooleanvEXT
      glGetInvariantFloatvEXT
      glGetInvariantIntegervEXT
      glGetLightxv
      glGetLocalConstantBooleanvEXT
      glGetLocalConstantFloatvEXT
      glGetLocalConstantIntegervEXT
      glGetMapAttribParameterfvNV
      glGetMapAttribParameterivNV
      glGetMapControlPointsNV
      glGetMapParameterfvNV
      glGetMapParameterivNV
      glGetMaterialxv
      glGetMinmax
      glGetMinmaxEXT
      glGetMinmaxParameterfv
      glGetMinmaxParameterfvEXT
      glGetMinmaxParameteriv
      glGetMinmaxParameterivEXT
      glGetMultiTexEnvfvEXT
      glGetMultiTexEnvivEXT
      glGetMultiTexGendvEXT
      glGetMultiTexGenfvEXT
      glGetMultiTexGenivEXT
      glGetMultiTexImageEXT
      glGetMultiTexLevelParameterfvEXT
      glGetMultiTexLevelParameterivEXT
      glGetMultiTexParameterIivEXT
      glGetMultiTexParameterIuivEXT
      glGetMultiTexParameterfvEXT
      glGetMultiTexParameterivEXT
      glGetMultisamplefv
      glGetMultisamplefvNV
      glGetNamedBufferParameteri64v
      glGetNamedBufferParameteriv
      glGetNamedBufferParameterivEXT
      glGetNamedBufferParameterui64vNV
      glGetNamedBufferPointerv
      glGetNamedBufferPointervEXT
      glGetNamedBufferSubData
      glGetNamedBufferSubDataEXT
      glGetNamedFramebufferAttachmentParameteriv
      glGetNamedFramebufferAttachmentParameterivEXT
      glGetNamedFramebufferParameteriv
      glGetNamedFramebufferParameterivEXT
      glGetNamedProgramLocalParameterIivEXT
      glGetNamedProgramLocalParameterIuivEXT
      glGetNamedProgramLocalParameterdvEXT
      glGetNamedProgramLocalParameterfvEXT
      glGetNamedProgramStringEXT
      glGetNamedProgramivEXT
      glGetNamedRenderbufferParameteriv
      glGetNamedRenderbufferParameterivEXT
      glGetNamedStringARB
      glGetNamedStringivARB
      glGetNextPerfQueryIdINTEL
      glGetObjectBufferfvATI
      glGetObjectBufferivATI
      glGetObjectLabel
      glGetObjectLabelEXT
      glGetObjectParameterfvARB
      glGetObjectParameterivAPPLE
      glGetObjectParameterivARB
      glGetObjectPtrLabel
      glGetOcclusionQueryivNV
      glGetOcclusionQueryuivNV
      glGetPathColorGenfvNV
      glGetPathColorGenivNV
      glGetPathCommandsNV
      glGetPathCoordsNV
      glGetPathDashArrayNV
      glGetPathLengthNV
      glGetPathMetricRangeNV
      glGetPathMetricsNV
      glGetPathParameterfvNV
      glGetPathParameterivNV
      glGetPathSpacingNV
      glGetPathTexGenfvNV
      glGetPathTexGenivNV
      glGetPerfCounterInfoINTEL
      glGetPerfMonitorCounterDataAMD
      glGetPerfMonitorCounterInfoAMD
      glGetPerfMonitorCounterStringAMD
      glGetPerfMonitorCountersAMD
      glGetPerfMonitorGroupStringAMD
      glGetPerfMonitorGroupsAMD
      glGetPerfQueryDataINTEL
      glGetPerfQueryIdByNameINTEL
      glGetPerfQueryInfoINTEL
      glGetPixelTransformParameterfvEXT
      glGetPixelTransformParameterivEXT
      glGetPointerIndexedvEXT
      glGetPointeri_vEXT
      glGetProcAddressREGAL
      glGetProgramBinary
      glGetProgramEnvParameterdvARB
      glGetProgramEnvParameterfvARB
      glGetProgramInfoLog
      glGetProgramInterfaceiv
      glGetProgramLocalParameterdvARB
      glGetProgramLocalParameterfvARB
      glGetProgramNamedParameterdvNV
      glGetProgramNamedParameterfvNV
      glGetProgramParameterdvNV
      glGetProgramParameterfvNV
      glGetProgramPipelineInfoLog
      glGetProgramPipelineiv
      glGetProgramResourceIndex
      glGetProgramResourceLocation
      glGetProgramResourceLocationIndex
      glGetProgramResourceName
      glGetProgramResourcefvNV
      glGetProgramResourceiv
      glGetProgramStageiv
      glGetProgramStringARB
      glGetProgramStringNV
      glGetProgramiv
      glGetProgramivARB
      glGetProgramivNV
      glGetQueryBufferObjecti64v
      glGetQueryBufferObjectiv
      glGetQueryBufferObjectui64v
      glGetQueryBufferObjectuiv
      glGetQueryIndexediv
      glGetQueryObjecti64v
      glGetQueryObjecti64vANGLE
      glGetQueryObjecti64vEXT
      glGetQueryObjectiv
      glGetQueryObjectivANGLE
      glGetQueryObjectivARB
      glGetQueryObjectui64v
      glGetQueryObjectui64vANGLE
      glGetQueryObjectui64vEXT
      glGetQueryObjectuiv
      glGetQueryObjectuivANGLE
      glGetQueryObjectuivARB
      glGetQueryiv
      glGetQueryivANGLE
      glGetQueryivARB
      glGetRenderbufferParameteriv
      glGetRenderbufferParameterivEXT
      glGetSamplerParameterIiv
      glGetSamplerParameterIuiv
      glGetSamplerParameterfv
      glGetSamplerParameteriv
      glGetSeparableFilter
      glGetSeparableFilterEXT
      glGetShaderInfoLog
      glGetShaderPrecisionFormat
      glGetShaderSource
      glGetShaderSourceARB
      glGetShaderiv
      glGetSharpenTexFuncSGIS
      glGetStageIndexNV
      glGetStringi
      glGetSubroutineIndex
      glGetSubroutineUniformLocation
      glGetSynciv
      glGetTexBumpParameterfvATI
      glGetTexBumpParameterivATI
      glGetTexEnvxv
      glGetTexFilterFuncSGIS
      glGetTexParameterIiv
      glGetTexParameterIivEXT
      glGetTexParameterIuiv
      glGetTexParameterIuivEXT
      glGetTexParameterPointervAPPLE
      glGetTexParameterxv
      glGetTextureHandleARB
      glGetTextureHandleNV
      glGetTextureImage
      glGetTextureImageEXT
      glGetTextureLevelParameterfv
      glGetTextureLevelParameterfvEXT
      glGetTextureLevelParameteriv
      glGetTextureLevelParameterivEXT
      glGetTextureParameterIiv
      glGetTextureParameterIivEXT
      glGetTextureParameterIuiv
      glGetTextureParameterIuivEXT
      glGetTextureParameterfv
      glGetTextureParameterfvEXT
      glGetTextureParameteriv
      glGetTextureParameterivEXT
      glGetTextureSamplerHandleARB
      glGetTextureSamplerHandleNV
      glGetTextureSubImage
      glGetTrackMatrixivNV
      glGetTransformFeedbackVarying
      glGetTransformFeedbackVaryingEXT
      glGetTransformFeedbackVaryingNV
      glGetTransformFeedbacki64_v
      glGetTransformFeedbacki_v
      glGetTransformFeedbackiv
      glGetTranslatedShaderSourceANGLE
      glGetUniformBlockIndex
      glGetUniformBufferSizeEXT
      glGetUniformIndices
      glGetUniformLocation
      glGetUniformLocationARB
      glGetUniformOffsetEXT
      glGetUniformSubroutineuiv
      glGetUniformdv
      glGetUniformfv
      glGetUniformfvARB
      glGetUniformi64vARB
      glGetUniformi64vNV
      glGetUniformiv
      glGetUniformivARB
      glGetUniformui64vARB
      glGetUniformui64vNV
      glGetUniformuiv
      glGetUniformuivEXT
      glGetVariantArrayObjectfvATI
      glGetVariantArrayObjectivATI
      glGetVariantBooleanvEXT
      glGetVariantFloatvEXT
      glGetVariantIntegervEXT
      glGetVariantPointervEXT
      glGetVaryingLocationNV
      glGetVertexArrayIndexed64iv
      glGetVertexArrayIndexediv
      glGetVertexArrayIntegeri_vEXT
      glGetVertexArrayIntegervEXT
      glGetVertexArrayPointeri_vEXT
      glGetVertexArrayPointervEXT
      glGetVertexArrayiv
      glGetVertexAttribArrayObjectfvATI
      glGetVertexAttribArrayObjectivATI
      glGetVertexAttribIiv
      glGetVertexAttribIivEXT
      glGetVertexAttribIuiv
      glGetVertexAttribIuivEXT
      glGetVertexAttribLdv
      glGetVertexAttribLdvEXT
      glGetVertexAttribLi64vNV
      glGetVertexAttribLui64vARB
      glGetVertexAttribLui64vNV
      glGetVertexAttribPointerv
      glGetVertexAttribPointervARB
      glGetVertexAttribPointervNV
      glGetVertexAttribdv
      glGetVertexAttribdvARB
      glGetVertexAttribdvNV
      glGetVertexAttribfv
      glGetVertexAttribfvARB
      glGetVertexAttribfvNV
      glGetVertexAttribiv
      glGetVertexAttribivARB
      glGetVertexAttribivNV
      glGetVideoCaptureStreamdvNV
      glGetVideoCaptureStreamfvNV
      glGetVideoCaptureStreamivNV
      glGetVideoCaptureivNV
      glGetVideoi64vNV
      glGetVideoivNV
      glGetVideoui64vNV
      glGetVideouivNV
      glGetVkProcAddrNV
      glGetnColorTableARB
      glGetnCompressedTexImage
      glGetnCompressedTexImageARB
      glGetnConvolutionFilterARB
      glGetnHistogramARB
      glGetnMapdvARB
      glGetnMapfvARB
      glGetnMapivARB
      glGetnMinmaxARB
      glGetnPixelMapfvARB
      glGetnPixelMapuivARB
      glGetnPixelMapusvARB
      glGetnPolygonStippleARB
      glGetnSeparableFilterARB
      glGetnTexImage
      glGetnTexImageARB
      glGetnUniformdv
      glGetnUniformdvARB
      glGetnUniformfv
      glGetnUniformfvARB
      glGetnUniformi64vARB
      glGetnUniformiv
      glGetnUniformivARB
      glGetnUniformui64vARB
      glGetnUniformuiv
      glGetnUniformuivARB
      glGlobalAlphaFactorbSUN
      glGlobalAlphaFactordSUN
      glGlobalAlphaFactorfSUN
      glGlobalAlphaFactoriSUN
      glGlobalAlphaFactorsSUN
      glGlobalAlphaFactorubSUN
      glGlobalAlphaFactoruiSUN
      glGlobalAlphaFactorusSUN
      glHistogram
      glHistogramEXT
      glImageTransformParameterfHP
      glImageTransformParameterfvHP
      glImageTransformParameteriHP
      glImageTransformParameterivHP
      glImportSyncEXT
      glIndexFormatNV
      glIndexFuncEXT
      glIndexMaterialEXT
      glIndexPointerEXT
      glIndexPointerListIBM
      glInsertComponentEXT
      glInsertEventMarkerEXT
      glInterpolatePathsNV
      glInvalidateBufferData
      glInvalidateBufferSubData
      glInvalidateFramebuffer
      glInvalidateNamedFramebufferData
      glInvalidateNamedFramebufferSubData
      glInvalidateSubFramebuffer
      glInvalidateTexImage
      glInvalidateTexSubImage
      glIsAsyncMarkerSGIX
      glIsBuffer
      glIsBufferARB
      glIsBufferResidentNV
      glIsCommandListNV
      glIsEnabledIndexedEXT
      glIsEnabledi
      glIsFenceAPPLE
      glIsFenceNV
      glIsFramebuffer
      glIsFramebufferEXT
      glIsImageHandleResidentARB
      glIsImageHandleResidentNV
      glIsNameAMD
      glIsNamedBufferResidentNV
      glIsNamedStringARB
      glIsObjectBufferATI
      glIsOcclusionQueryNV
      glIsPathNV
      glIsPointInFillPathNV
      glIsPointInStrokePathNV
      glIsProgram
      glIsProgramARB
      glIsProgramNV
      glIsProgramPipeline
      glIsQuery
      glIsQueryANGLE
      glIsQueryARB
      glIsRenderbuffer
      glIsRenderbufferEXT
      glIsSampler
      glIsShader
      glIsStateNV
      glIsSupportedREGAL
      glIsSync
      glIsTextureEXT
      glIsTextureHandleResidentARB
      glIsTextureHandleResidentNV
      glIsTransformFeedback
      glIsTransformFeedbackNV
      glIsVariantEnabledEXT
      glIsVertexArray
      glIsVertexArrayAPPLE
      glIsVertexAttribEnabledAPPLE
      glLGPUCopyImageSubDataNVX
      glLGPUInterlockNVX
      glLGPUNamedBufferSubDataNVX
      glLabelObjectEXT
      glLightEnviEXT
      glLightModelx
      glLightModelxv
      glLightx
      glLightxv
      glLineWidthx
      glLinkProgram
      glLinkProgramARB
      glListDrawCommandsStatesClientNV
      glLoadMatrixx
      glLoadProgramNV
      glLoadTransposeMatrixd
      glLoadTransposeMatrixdARB
      glLoadTransposeMatrixf
      glLoadTransposeMatrixfARB
      glLockArraysEXT
      glLogMessageCallbackREGAL
      glMakeBufferNonResidentNV
      glMakeBufferResidentNV
      glMakeImageHandleNonResidentARB
      glMakeImageHandleNonResidentNV
      glMakeImageHandleResidentARB
      glMakeImageHandleResidentNV
      glMakeNamedBufferNonResidentNV
      glMakeNamedBufferResidentNV
      glMakeTextureHandleNonResidentARB
      glMakeTextureHandleNonResidentNV
      glMakeTextureHandleResidentARB
      glMakeTextureHandleResidentNV
      glMapBuffer
      glMapBufferARB
      glMapBufferRange
      glMapControlPointsNV
      glMapNamedBuffer
      glMapNamedBufferEXT
      glMapNamedBufferRange
      glMapNamedBufferRangeEXT
      glMapObjectBufferATI
      glMapParameterfvNV
      glMapParameterivNV
      glMapTexture2DINTEL
      glMapVertexAttrib1dAPPLE
      glMapVertexAttrib1fAPPLE
      glMapVertexAttrib2dAPPLE
      glMapVertexAttrib2fAPPLE
      glMaterialx
      glMaterialxv
      glMatrixFrustumEXT
      glMatrixIndexPointerARB
      glMatrixIndexubvARB
      glMatrixIndexuivARB
      glMatrixIndexusvARB
      glMatrixLoad3x2fNV
      glMatrixLoad3x3fNV
      glMatrixLoadIdentityEXT
      glMatrixLoadTranspose3x3fNV
      glMatrixLoadTransposedEXT
      glMatrixLoadTransposefEXT
      glMatrixLoaddEXT
      glMatrixLoadfEXT
      glMatrixMult3x2fNV
      glMatrixMult3x3fNV
      glMatrixMultTranspose3x3fNV
      glMatrixMultTransposedEXT
      glMatrixMultTransposefEXT
      glMatrixMultdEXT
      glMatrixMultfEXT
      glMatrixOrthoEXT
      glMatrixPopEXT
      glMatrixPushEXT
      glMatrixRotatedEXT
      glMatrixRotatefEXT
      glMatrixScaledEXT
      glMatrixScalefEXT
      glMatrixTranslatedEXT
      glMatrixTranslatefEXT
      glMaxShaderCompilerThreadsARB
      glMemoryBarrier
      glMemoryBarrierByRegion
      glMemoryBarrierEXT
      glMinSampleShading
      glMinSampleShadingARB
      glMinmax
      glMinmaxEXT
      glMultMatrixx
      glMultTransposeMatrixd
      glMultTransposeMatrixdARB
      glMultTransposeMatrixf
      glMultTransposeMatrixfARB
      glMultiDrawArrays
      glMultiDrawArraysEXT
      glMultiDrawArraysIndirect
      glMultiDrawArraysIndirectAMD
      glMultiDrawArraysIndirectBindlessCountNV
      glMultiDrawArraysIndirectBindlessNV
      glMultiDrawArraysIndirectCountARB
      glMultiDrawElementArrayAPPLE
      glMultiDrawElements
      glMultiDrawElementsBaseVertex
      glMultiDrawElementsEXT
      glMultiDrawElementsIndirect
      glMultiDrawElementsIndirectAMD
      glMultiDrawElementsIndirectBindlessCountNV
      glMultiDrawElementsIndirectBindlessNV
      glMultiDrawElementsIndirectCountARB
      glMultiDrawRangeElementArrayAPPLE
      glMultiModeDrawArraysIBM
      glMultiModeDrawElementsIBM
      glMultiTexBufferEXT
      glMultiTexCoord1d
      glMultiTexCoord1dARB
      glMultiTexCoord1dv
      glMultiTexCoord1dvARB
      glMultiTexCoord1f
      glMultiTexCoord1fARB
      glMultiTexCoord1fv
      glMultiTexCoord1fvARB
      glMultiTexCoord1hNV
      glMultiTexCoord1hvNV
      glMultiTexCoord1i
      glMultiTexCoord1iARB
      glMultiTexCoord1iv
      glMultiTexCoord1ivARB
      glMultiTexCoord1s
      glMultiTexCoord1sARB
      glMultiTexCoord1sv
      glMultiTexCoord1svARB
      glMultiTexCoord2d
      glMultiTexCoord2dARB
      glMultiTexCoord2dv
      glMultiTexCoord2dvARB
      glMultiTexCoord2f
      glMultiTexCoord2fARB
      glMultiTexCoord2fv
      glMultiTexCoord2fvARB
      glMultiTexCoord2hNV
      glMultiTexCoord2hvNV
      glMultiTexCoord2i
      glMultiTexCoord2iARB
      glMultiTexCoord2iv
      glMultiTexCoord2ivARB
      glMultiTexCoord2s
      glMultiTexCoord2sARB
      glMultiTexCoord2sv
      glMultiTexCoord2svARB
      glMultiTexCoord3d
      glMultiTexCoord3dARB
      glMultiTexCoord3dv
      glMultiTexCoord3dvARB
      glMultiTexCoord3f
      glMultiTexCoord3fARB
      glMultiTexCoord3fv
      glMultiTexCoord3fvARB
      glMultiTexCoord3hNV
      glMultiTexCoord3hvNV
      glMultiTexCoord3i
      glMultiTexCoord3iARB
      glMultiTexCoord3iv
      glMultiTexCoord3ivARB
      glMultiTexCoord3s
      glMultiTexCoord3sARB
      glMultiTexCoord3sv
      glMultiTexCoord3svARB
      glMultiTexCoord4d
      glMultiTexCoord4dARB
      glMultiTexCoord4dv
      glMultiTexCoord4dvARB
      glMultiTexCoord4f
      glMultiTexCoord4fARB
      glMultiTexCoord4fv
      glMultiTexCoord4fvARB
      glMultiTexCoord4hNV
      glMultiTexCoord4hvNV
      glMultiTexCoord4i
      glMultiTexCoord4iARB
      glMultiTexCoord4iv
      glMultiTexCoord4ivARB
      glMultiTexCoord4s
      glMultiTexCoord4sARB
      glMultiTexCoord4sv
      glMultiTexCoord4svARB
      glMultiTexCoord4x
      glMultiTexCoordP1ui
      glMultiTexCoordP1uiv
      glMultiTexCoordP2ui
      glMultiTexCoordP2uiv
      glMultiTexCoordP3ui
      glMultiTexCoordP3uiv
      glMultiTexCoordP4ui
      glMultiTexCoordP4uiv
      glMultiTexCoordPointerEXT
      glMultiTexEnvfEXT
      glMultiTexEnvfvEXT
      glMultiTexEnviEXT
      glMultiTexEnvivEXT
      glMultiTexGendEXT
      glMultiTexGendvEXT
      glMultiTexGenfEXT
      glMultiTexGenfvEXT
      glMultiTexGeniEXT
      glMultiTexGenivEXT
      glMultiTexImage1DEXT
      glMultiTexImage2DEXT
      glMultiTexImage3DEXT
      glMultiTexParameterIivEXT
      glMultiTexParameterIuivEXT
      glMultiTexParameterfEXT
      glMultiTexParameterfvEXT
      glMultiTexParameteriEXT
      glMultiTexParameterivEXT
      glMultiTexRenderbufferEXT
      glMultiTexSubImage1DEXT
      glMultiTexSubImage2DEXT
      glMultiTexSubImage3DEXT
      glMulticastBarrierNV
      glMulticastBlitFramebufferNV
      glMulticastBufferSubDataNV
      glMulticastCopyBufferSubDataNV
      glMulticastCopyImageSubDataNV
      glMulticastFramebufferSampleLocationsfvNV
      glMulticastGetQueryObjecti64vNV
      glMulticastGetQueryObjectivNV
      glMulticastGetQueryObjectui64vNV
      glMulticastGetQueryObjectuivNV
      glMulticastWaitSyncNV
      glNamedBufferData
      glNamedBufferDataEXT
      glNamedBufferStorage
      glNamedBufferStorageEXT
      glNamedBufferSubData
      glNamedBufferSubDataEXT
      glNamedCopyBufferSubDataEXT
      glNamedFramebufferDrawBuffer
      glNamedFramebufferDrawBuffers
      glNamedFramebufferParameteri
      glNamedFramebufferParameteriEXT
      glNamedFramebufferReadBuffer
      glNamedFramebufferRenderbuffer
      glNamedFramebufferRenderbufferEXT
      glNamedFramebufferSampleLocationsfvARB
      glNamedFramebufferSampleLocationsfvNV
      glNamedFramebufferTexture
      glNamedFramebufferTexture1DEXT
      glNamedFramebufferTexture2DEXT
      glNamedFramebufferTexture3DEXT
      glNamedFramebufferTextureEXT
      glNamedFramebufferTextureFaceEXT
      glNamedFramebufferTextureLayer
      glNamedFramebufferTextureLayerEXT
      glNamedProgramLocalParameter4dEXT
      glNamedProgramLocalParameter4dvEXT
      glNamedProgramLocalParameter4fEXT
      glNamedProgramLocalParameter4fvEXT
      glNamedProgramLocalParameterI4iEXT
      glNamedProgramLocalParameterI4ivEXT
      glNamedProgramLocalParameterI4uiEXT
      glNamedProgramLocalParameterI4uivEXT
      glNamedProgramLocalParameters4fvEXT
      glNamedProgramLocalParametersI4ivEXT
      glNamedProgramLocalParametersI4uivEXT
      glNamedProgramStringEXT
      glNamedRenderbufferStorage
      glNamedRenderbufferStorageEXT
      glNamedRenderbufferStorageMultisample
      glNamedRenderbufferStorageMultisampleCoverageEXT
      glNamedRenderbufferStorageMultisampleEXT
      glNamedStringARB
      glNewBufferRegion
      glNewObjectBufferATI
      glNormal3fVertex3fSUN
      glNormal3fVertex3fvSUN
      glNormal3hNV
      glNormal3hvNV
      glNormal3x
      glNormalFormatNV
      glNormalP3ui
      glNormalP3uiv
      glNormalPointerEXT
      glNormalPointerListIBM
      glNormalPointervINTEL
      glNormalStream3bATI
      glNormalStream3bvATI
      glNormalStream3dATI
      glNormalStream3dvATI
      glNormalStream3fATI
      glNormalStream3fvATI
      glNormalStream3iATI
      glNormalStream3ivATI
      glNormalStream3sATI
      glNormalStream3svATI
      glObjectLabel
      glObjectPtrLabel
      glObjectPurgeableAPPLE
      glObjectUnpurgeableAPPLE
      glOrthof
      glOrthofOES
      glOrthox
      glPNTrianglesfATI
      glPNTrianglesiATI
      glPassTexCoordATI
      glPatchParameterfv
      glPatchParameteri
      glPathColorGenNV
      glPathCommandsNV
      glPathCoordsNV
      glPathCoverDepthFuncNV
      glPathDashArrayNV
      glPathFogGenNV
      glPathGlyphIndexArrayNV
      glPathGlyphIndexRangeNV
      glPathGlyphRangeNV
      glPathGlyphsNV
      glPathMemoryGlyphIndexArrayNV
      glPathParameterfNV
      glPathParameterfvNV
      glPathParameteriNV
      glPathParameterivNV
      glPathStencilDepthOffsetNV
      glPathStencilFuncNV
      glPathStringNV
      glPathSubCommandsNV
      glPathSubCoordsNV
      glPathTexGenNV
      glPauseTransformFeedback
      glPauseTransformFeedbackNV
      glPixelDataRangeNV
      glPixelTexGenSGIX
      glPixelTransformParameterfEXT
      glPixelTransformParameterfvEXT
      glPixelTransformParameteriEXT
      glPixelTransformParameterivEXT
      glPointAlongPathNV
      glPointParameterf
      glPointParameterfARB
      glPointParameterfEXT
      glPointParameterfv
      glPointParameterfvARB
      glPointParameterfvEXT
      glPointParameteri
      glPointParameteriNV
      glPointParameteriv
      glPointParameterivNV
      glPointParameterx
      glPointParameterxv
      glPointSizePointerOES
      glPointSizex
      glPollAsyncSGIX
      glPolygonOffsetClampEXT
      glPolygonOffsetEXT
      glPolygonOffsetx
      glPopDebugGroup
      glPopGroupMarkerEXT
      glPresentFrameDualFillNV
      glPresentFrameKeyedNV
      glPrimitiveBoundingBoxARB
      glPrimitiveRestartIndex
      glPrimitiveRestartIndexNV
      glPrimitiveRestartNV
      glPrioritizeTexturesEXT
      glProgramBinary
      glProgramBufferParametersIivNV
      glProgramBufferParametersIuivNV
      glProgramBufferParametersfvNV
      glProgramEnvParameter4dARB
      glProgramEnvParameter4dvARB
      glProgramEnvParameter4fARB
      glProgramEnvParameter4fvARB
      glProgramEnvParameterI4iNV
      glProgramEnvParameterI4ivNV
      glProgramEnvParameterI4uiNV
      glProgramEnvParameterI4uivNV
      glProgramEnvParameters4fvEXT
      glProgramEnvParametersI4ivNV
      glProgramEnvParametersI4uivNV
      glProgramLocalParameter4dARB
      glProgramLocalParameter4dvARB
      glProgramLocalParameter4fARB
      glProgramLocalParameter4fvARB
      glProgramLocalParameterI4iNV
      glProgramLocalParameterI4ivNV
      glProgramLocalParameterI4uiNV
      glProgramLocalParameterI4uivNV
      glProgramLocalParameters4fvEXT
      glProgramLocalParametersI4ivNV
      glProgramLocalParametersI4uivNV
      glProgramNamedParameter4dNV
      glProgramNamedParameter4dvNV
      glProgramNamedParameter4fNV
      glProgramNamedParameter4fvNV
      glProgramParameter4dNV
      glProgramParameter4dvNV
      glProgramParameter4fNV
      glProgramParameter4fvNV
      glProgramParameteri
      glProgramParameteriARB
      glProgramParameteriEXT
      glProgramParameters4dvNV
      glProgramParameters4fvNV
      glProgramPathFragmentInputGenNV
      glProgramStringARB
      glProgramUniform1d
      glProgramUniform1dv
      glProgramUniform1f
      glProgramUniform1fEXT
      glProgramUniform1fv
      glProgramUniform1fvEXT
      glProgramUniform1i
      glProgramUniform1i64ARB
      glProgramUniform1i64NV
      glProgramUniform1i64vARB
      glProgramUniform1i64vNV
      glProgramUniform1iEXT
      glProgramUniform1iv
      glProgramUniform1ivEXT
      glProgramUniform1ui
      glProgramUniform1ui64ARB
      glProgramUniform1ui64NV
      glProgramUniform1ui64vARB
      glProgramUniform1ui64vNV
      glProgramUniform1uiEXT
      glProgramUniform1uiv
      glProgramUniform1uivEXT
      glProgramUniform2d
      glProgramUniform2dv
      glProgramUniform2f
      glProgramUniform2fEXT
      glProgramUniform2fv
      glProgramUniform2fvEXT
      glProgramUniform2i
      glProgramUniform2i64ARB
      glProgramUniform2i64NV
      glProgramUniform2i64vARB
      glProgramUniform2i64vNV
      glProgramUniform2iEXT
      glProgramUniform2iv
      glProgramUniform2ivEXT
      glProgramUniform2ui
      glProgramUniform2ui64ARB
      glProgramUniform2ui64NV
      glProgramUniform2ui64vARB
      glProgramUniform2ui64vNV
      glProgramUniform2uiEXT
      glProgramUniform2uiv
      glProgramUniform2uivEXT
      glProgramUniform3d
      glProgramUniform3dv
      glProgramUniform3f
      glProgramUniform3fEXT
      glProgramUniform3fv
      glProgramUniform3fvEXT
      glProgramUniform3i
      glProgramUniform3i64ARB
      glProgramUniform3i64NV
      glProgramUniform3i64vARB
      glProgramUniform3i64vNV
      glProgramUniform3iEXT
      glProgramUniform3iv
      glProgramUniform3ivEXT
      glProgramUniform3ui
      glProgramUniform3ui64ARB
      glProgramUniform3ui64NV
      glProgramUniform3ui64vARB
      glProgramUniform3ui64vNV
      glProgramUniform3uiEXT
      glProgramUniform3uiv
      glProgramUniform3uivEXT
      glProgramUniform4d
      glProgramUniform4dv
      glProgramUniform4f
      glProgramUniform4fEXT
      glProgramUniform4fv
      glProgramUniform4fvEXT
      glProgramUniform4i
      glProgramUniform4i64ARB
      glProgramUniform4i64NV
      glProgramUniform4i64vARB
      glProgramUniform4i64vNV
      glProgramUniform4iEXT
      glProgramUniform4iv
      glProgramUniform4ivEXT
      glProgramUniform4ui
      glProgramUniform4ui64ARB
      glProgramUniform4ui64NV
      glProgramUniform4ui64vARB
      glProgramUniform4ui64vNV
      glProgramUniform4uiEXT
      glProgramUniform4uiv
      glProgramUniform4uivEXT
      glProgramUniformHandleui64ARB
      glProgramUniformHandleui64NV
      glProgramUniformHandleui64vARB
      glProgramUniformHandleui64vNV
      glProgramUniformMatrix2dv
      glProgramUniformMatrix2fv
      glProgramUniformMatrix2fvEXT
      glProgramUniformMatrix2x3dv
      glProgramUniformMatrix2x3fv
      glProgramUniformMatrix2x3fvEXT
      glProgramUniformMatrix2x4dv
      glProgramUniformMatrix2x4fv
      glProgramUniformMatrix2x4fvEXT
      glProgramUniformMatrix3dv
      glProgramUniformMatrix3fv
      glProgramUniformMatrix3fvEXT
      glProgramUniformMatrix3x2dv
      glProgramUniformMatrix3x2fv
      glProgramUniformMatrix3x2fvEXT
      glProgramUniformMatrix3x4dv
      glProgramUniformMatrix3x4fv
      glProgramUniformMatrix3x4fvEXT
      glProgramUniformMatrix4dv
      glProgramUniformMatrix4fv
      glProgramUniformMatrix4fvEXT
      glProgramUniformMatrix4x2dv
      glProgramUniformMatrix4x2fv
      glProgramUniformMatrix4x2fvEXT
      glProgramUniformMatrix4x3dv
      glProgramUniformMatrix4x3fv
      glProgramUniformMatrix4x3fvEXT
      glProgramUniformui64NV
      glProgramUniformui64vNV
      glProgramVertexLimitNV
      glProvokingVertex
      glProvokingVertexEXT
      glPushClientAttribDefaultEXT
      glPushDebugGroup
      glPushGroupMarkerEXT
      glQueryCounter
      glQueryCounterANGLE
      glQueryObjectParameteruiAMD
      glRasterSamplesEXT
      glReadBufferRegion
      glReadVideoPixelsSUN
      glReadnPixels
      glReadnPixelsARB
      glReferencePlaneSGIX
      glReleaseShaderCompiler
      glRenderGpuMaskNV
      glRenderbufferStorage
      glRenderbufferStorageEXT
      glRenderbufferStorageMultisample
      glRenderbufferStorageMultisampleANGLE
      glRenderbufferStorageMultisampleCoverageNV
      glRenderbufferStorageMultisampleEXT
      glReplacementCodePointerSUN
      glReplacementCodeubSUN
      glReplacementCodeubvSUN
      glReplacementCodeuiColor3fVertex3fSUN
      glReplacementCodeuiColor3fVertex3fvSUN
      glReplacementCodeuiColor4fNormal3fVertex3fSUN
      glReplacementCodeuiColor4fNormal3fVertex3fvSUN
      glReplacementCodeuiColor4ubVertex3fSUN
      glReplacementCodeuiColor4ubVertex3fvSUN
      glReplacementCodeuiNormal3fVertex3fSUN
      glReplacementCodeuiNormal3fVertex3fvSUN
      glReplacementCodeuiSUN
      glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fSUN
      glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN
      glReplacementCodeuiTexCoord2fNormal3fVertex3fSUN
      glReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN
      glReplacementCodeuiTexCoord2fVertex3fSUN
      glReplacementCodeuiTexCoord2fVertex3fvSUN
      glReplacementCodeuiVertex3fSUN
      glReplacementCodeuiVertex3fvSUN
      glReplacementCodeuivSUN
      glReplacementCodeusSUN
      glReplacementCodeusvSUN
      glRequestResidentProgramsNV
      glResetHistogram
      glResetHistogramEXT
      glResetMinmax
      glResetMinmaxEXT
      glResizeBuffersMESA
      glResumeTransformFeedback
      glResumeTransformFeedbackNV
      glRotatex
      glSampleCoverage
      glSampleCoverageARB
      glSampleCoveragex
      glSampleMapATI
      glSampleMaskEXT
      glSampleMaskIndexedNV
      glSampleMaskSGIS
      glSampleMaski
      glSamplePatternEXT
      glSamplePatternSGIS
      glSamplerParameterIiv
      glSamplerParameterIuiv
      glSamplerParameterf
      glSamplerParameterfv
      glSamplerParameteri
      glSamplerParameteriv
      glScalex
      glScissorArrayv
      glScissorIndexed
      glScissorIndexedv
      glSecondaryColor3b
      glSecondaryColor3bEXT
      glSecondaryColor3bv
      glSecondaryColor3bvEXT
      glSecondaryColor3d
      glSecondaryColor3dEXT
      glSecondaryColor3dv
      glSecondaryColor3dvEXT
      glSecondaryColor3f
      glSecondaryColor3fEXT
      glSecondaryColor3fv
      glSecondaryColor3fvEXT
      glSecondaryColor3hNV
      glSecondaryColor3hvNV
      glSecondaryColor3i
      glSecondaryColor3iEXT
      glSecondaryColor3iv
      glSecondaryColor3ivEXT
      glSecondaryColor3s
      glSecondaryColor3sEXT
      glSecondaryColor3sv
      glSecondaryColor3svEXT
      glSecondaryColor3ub
      glSecondaryColor3ubEXT
      glSecondaryColor3ubv
      glSecondaryColor3ubvEXT
      glSecondaryColor3ui
      glSecondaryColor3uiEXT
      glSecondaryColor3uiv
      glSecondaryColor3uivEXT
      glSecondaryColor3us
      glSecondaryColor3usEXT
      glSecondaryColor3usv
      glSecondaryColor3usvEXT
      glSecondaryColorFormatNV
      glSecondaryColorP3ui
      glSecondaryColorP3uiv
      glSecondaryColorPointer
      glSecondaryColorPointerEXT
      glSecondaryColorPointerListIBM
      glSelectPerfMonitorCountersAMD
      glSeparableFilter2D
      glSeparableFilter2DEXT
      glSetFenceAPPLE
      glSetFenceNV
      glSetFragmentShaderConstantATI
      glSetInvariantEXT
      glSetLocalConstantEXT
      glSetMultisamplefvAMD
      glShaderBinary
      glShaderOp1EXT
      glShaderOp2EXT
      glShaderOp3EXT
      glShaderSource
      glShaderSourceARB
      glShaderStorageBlockBinding
      glSharpenTexFuncSGIS
      glSignalVkFenceNV
      glSignalVkSemaphoreNV
      glSpecializeShaderARB
      glSpriteParameterfSGIX
      glSpriteParameterfvSGIX
      glSpriteParameteriSGIX
      glSpriteParameterivSGIX
      glStateCaptureNV
      glStencilFillPathInstancedNV
      glStencilFillPathNV
      glStencilFuncSeparate
      glStencilFuncSeparateATI
      glStencilMaskSeparate
      glStencilOpSeparate
      glStencilOpSeparateATI
      glStencilOpValueAMD
      glStencilStrokePathInstancedNV
      glStencilStrokePathNV
      glStencilThenCoverFillPathInstancedNV
      glStencilThenCoverFillPathNV
      glStencilThenCoverStrokePathInstancedNV
      glStencilThenCoverStrokePathNV
      glStringMarkerGREMEDY
      glSubpixelPrecisionBiasNV
      glSwizzleEXT
      glSyncTextureINTEL
      glTagSampleBufferSGIX
      glTangentPointerEXT
      glTbufferMask3DFX
      glTessellationFactorAMD
      glTessellationModeAMD
      glTestFenceAPPLE
      glTestFenceNV
      glTestObjectAPPLE
      glTexBuffer
      glTexBufferARB
      glTexBufferEXT
      glTexBufferRange
      glTexBumpParameterfvATI
      glTexBumpParameterivATI
      glTexCoord1hNV
      glTexCoord1hvNV
      glTexCoord2fColor3fVertex3fSUN
      glTexCoord2fColor3fVertex3fvSUN
      glTexCoord2fColor4fNormal3fVertex3fSUN
      glTexCoord2fColor4fNormal3fVertex3fvSUN
      glTexCoord2fColor4ubVertex3fSUN
      glTexCoord2fColor4ubVertex3fvSUN
      glTexCoord2fNormal3fVertex3fSUN
      glTexCoord2fNormal3fVertex3fvSUN
      glTexCoord2fVertex3fSUN
      glTexCoord2fVertex3fvSUN
      glTexCoord2hNV
      glTexCoord2hvNV
      glTexCoord3hNV
      glTexCoord3hvNV
      glTexCoord4fColor4fNormal3fVertex4fSUN
      glTexCoord4fColor4fNormal3fVertex4fvSUN
      glTexCoord4fVertex4fSUN
      glTexCoord4fVertex4fvSUN
      glTexCoord4hNV
      glTexCoord4hvNV
      glTexCoordFormatNV
      glTexCoordP1ui
      glTexCoordP1uiv
      glTexCoordP2ui
      glTexCoordP2uiv
      glTexCoordP3ui
      glTexCoordP3uiv
      glTexCoordP4ui
      glTexCoordP4uiv
      glTexCoordPointerEXT
      glTexCoordPointerListIBM
      glTexCoordPointervINTEL
      glTexEnvx
      glTexEnvxv
      glTexFilterFuncSGIS
      glTexImage2DMultisample
      glTexImage2DMultisampleCoverageNV
      glTexImage3D
      glTexImage3DEXT
      glTexImage3DMultisample
      glTexImage3DMultisampleCoverageNV
      glTexImage4DSGIS
      glTexPageCommitmentARB
      glTexParameterIiv
      glTexParameterIivEXT
      glTexParameterIuiv
      glTexParameterIuivEXT
      glTexParameterx
      glTexParameterxv
      glTexRenderbufferNV
      glTexScissorFuncINTEL
      glTexScissorINTEL
      glTexStorage1D
      glTexStorage2D
      glTexStorage2DMultisample
      glTexStorage3D
      glTexStorage3DMultisample
      glTexStorageSparseAMD
      glTexSubImage1DEXT
      glTexSubImage2DEXT
      glTexSubImage3D
      glTexSubImage3DEXT
      glTexSubImage4DSGIS
      glTextureBarrier
      glTextureBarrierNV
      glTextureBuffer
      glTextureBufferEXT
      glTextureBufferRange
      glTextureBufferRangeEXT
      glTextureFogSGIX
      glTextureImage1DEXT
      glTextureImage2DEXT
      glTextureImage2DMultisampleCoverageNV
      glTextureImage2DMultisampleNV
      glTextureImage3DEXT
      glTextureImage3DMultisampleCoverageNV
      glTextureImage3DMultisampleNV
      glTextureLightEXT
      glTextureMaterialEXT
      glTextureNormalEXT
      glTexturePageCommitmentEXT
      glTextureParameterIiv
      glTextureParameterIivEXT
      glTextureParameterIuiv
      glTextureParameterIuivEXT
      glTextureParameterf
      glTextureParameterfEXT
      glTextureParameterfv
      glTextureParameterfvEXT
      glTextureParameteri
      glTextureParameteriEXT
      glTextureParameteriv
      glTextureParameterivEXT
      glTextureRangeAPPLE
      glTextureRenderbufferEXT
      glTextureStorage1D
      glTextureStorage1DEXT
      glTextureStorage2D
      glTextureStorage2DEXT
      glTextureStorage2DMultisample
      glTextureStorage2DMultisampleEXT
      glTextureStorage3D
      glTextureStorage3DEXT
      glTextureStorage3DMultisample
      glTextureStorage3DMultisampleEXT
      glTextureStorageSparseAMD
      glTextureSubImage1D
      glTextureSubImage1DEXT
      glTextureSubImage2D
      glTextureSubImage2DEXT
      glTextureSubImage3D
      glTextureSubImage3DEXT
      glTextureView
      glTrackMatrixNV
      glTransformFeedbackAttribsNV
      glTransformFeedbackBufferBase
      glTransformFeedbackBufferRange
      glTransformFeedbackVaryings
      glTransformFeedbackVaryingsEXT
      glTransformFeedbackVaryingsNV
      glTransformPathNV
      glTranslatex
      glUniform1d
      glUniform1dv
      glUniform1f
      glUniform1fARB
      glUniform1fv
      glUniform1fvARB
      glUniform1i
      glUniform1i64ARB
      glUniform1i64NV
      glUniform1i64vARB
      glUniform1i64vNV
      glUniform1iARB
      glUniform1iv
      glUniform1ivARB
      glUniform1ui
      glUniform1ui64ARB
      glUniform1ui64NV
      glUniform1ui64vARB
      glUniform1ui64vNV
      glUniform1uiEXT
      glUniform1uiv
      glUniform1uivEXT
      glUniform2d
      glUniform2dv
      glUniform2f
      glUniform2fARB
      glUniform2fv
      glUniform2fvARB
      glUniform2i
      glUniform2i64ARB
      glUniform2i64NV
      glUniform2i64vARB
      glUniform2i64vNV
      glUniform2iARB
      glUniform2iv
      glUniform2ivARB
      glUniform2ui
      glUniform2ui64ARB
      glUniform2ui64NV
      glUniform2ui64vARB
      glUniform2ui64vNV
      glUniform2uiEXT
      glUniform2uiv
      glUniform2uivEXT
      glUniform3d
      glUniform3dv
      glUniform3f
      glUniform3fARB
      glUniform3fv
      glUniform3fvARB
      glUniform3i
      glUniform3i64ARB
      glUniform3i64NV
      glUniform3i64vARB
      glUniform3i64vNV
      glUniform3iARB
      glUniform3iv
      glUniform3ivARB
      glUniform3ui
      glUniform3ui64ARB
      glUniform3ui64NV
      glUniform3ui64vARB
      glUniform3ui64vNV
      glUniform3uiEXT
      glUniform3uiv
      glUniform3uivEXT
      glUniform4d
      glUniform4dv
      glUniform4f
      glUniform4fARB
      glUniform4fv
      glUniform4fvARB
      glUniform4i
      glUniform4i64ARB
      glUniform4i64NV
      glUniform4i64vARB
      glUniform4i64vNV
      glUniform4iARB
      glUniform4iv
      glUniform4ivARB
      glUniform4ui
      glUniform4ui64ARB
      glUniform4ui64NV
      glUniform4ui64vARB
      glUniform4ui64vNV
      glUniform4uiEXT
      glUniform4uiv
      glUniform4uivEXT
      glUniformBlockBinding
      glUniformBufferEXT
      glUniformHandleui64ARB
      glUniformHandleui64NV
      glUniformHandleui64vARB
      glUniformHandleui64vNV
      glUniformMatrix2dv
      glUniformMatrix2fv
      glUniformMatrix2fvARB
      glUniformMatrix2x3dv
      glUniformMatrix2x3fv
      glUniformMatrix2x4dv
      glUniformMatrix2x4fv
      glUniformMatrix3dv
      glUniformMatrix3fv
      glUniformMatrix3fvARB
      glUniformMatrix3x2dv
      glUniformMatrix3x2fv
      glUniformMatrix3x4dv
      glUniformMatrix3x4fv
      glUniformMatrix4dv
      glUniformMatrix4fv
      glUniformMatrix4fvARB
      glUniformMatrix4x2dv
      glUniformMatrix4x2fv
      glUniformMatrix4x3dv
      glUniformMatrix4x3fv
      glUniformSubroutinesuiv
      glUniformui64NV
      glUniformui64vNV
      glUnlockArraysEXT
      glUnmapBuffer
      glUnmapBufferARB
      glUnmapNamedBuffer
      glUnmapNamedBufferEXT
      glUnmapObjectBufferATI
      glUnmapTexture2DINTEL
      glUpdateObjectBufferATI
      glUseProgram
      glUseProgramObjectARB
      glUseProgramStages
      glUseShaderProgramEXT
      glVDPAUFiniNV
      glVDPAUGetSurfaceivNV
      glVDPAUInitNV
      glVDPAUIsSurfaceNV
      glVDPAUMapSurfacesNV
      glVDPAURegisterOutputSurfaceNV
      glVDPAURegisterVideoSurfaceNV
      glVDPAUSurfaceAccessNV
      glVDPAUUnmapSurfacesNV
      glVDPAUUnregisterSurfaceNV
      glValidateProgram
      glValidateProgramARB
      glValidateProgramPipeline
      glVariantArrayObjectATI
      glVariantPointerEXT
      glVariantbvEXT
      glVariantdvEXT
      glVariantfvEXT
      glVariantivEXT
      glVariantsvEXT
      glVariantubvEXT
      glVariantuivEXT
      glVariantusvEXT
      glVertex2hNV
      glVertex2hvNV
      glVertex3hNV
      glVertex3hvNV
      glVertex4hNV
      glVertex4hvNV
      glVertexArrayAttribBinding
      glVertexArrayAttribFormat
      glVertexArrayAttribIFormat
      glVertexArrayAttribLFormat
      glVertexArrayBindVertexBufferEXT
      glVertexArrayBindingDivisor
      glVertexArrayColorOffsetEXT
      glVertexArrayEdgeFlagOffsetEXT
      glVertexArrayElementBuffer
      glVertexArrayFogCoordOffsetEXT
      glVertexArrayIndexOffsetEXT
      glVertexArrayMultiTexCoordOffsetEXT
      glVertexArrayNormalOffsetEXT
      glVertexArrayParameteriAPPLE
      glVertexArrayRangeAPPLE
      glVertexArrayRangeNV
      glVertexArraySecondaryColorOffsetEXT
      glVertexArrayTexCoordOffsetEXT
      glVertexArrayVertexAttribBindingEXT
      glVertexArrayVertexAttribDivisorEXT
      glVertexArrayVertexAttribFormatEXT
      glVertexArrayVertexAttribIFormatEXT
      glVertexArrayVertexAttribIOffsetEXT
      glVertexArrayVertexAttribLFormatEXT
      glVertexArrayVertexAttribLOffsetEXT
      glVertexArrayVertexAttribOffsetEXT
      glVertexArrayVertexBindingDivisorEXT
      glVertexArrayVertexBuffer
      glVertexArrayVertexBuffers
      glVertexArrayVertexOffsetEXT
      glVertexAttrib1d
      glVertexAttrib1dARB
      glVertexAttrib1dNV
      glVertexAttrib1dv
      glVertexAttrib1dvARB
      glVertexAttrib1dvNV
      glVertexAttrib1f
      glVertexAttrib1fARB
      glVertexAttrib1fNV
      glVertexAttrib1fv
      glVertexAttrib1fvARB
      glVertexAttrib1fvNV
      glVertexAttrib1hNV
      glVertexAttrib1hvNV
      glVertexAttrib1s
      glVertexAttrib1sARB
      glVertexAttrib1sNV
      glVertexAttrib1sv
      glVertexAttrib1svARB
      glVertexAttrib1svNV
      glVertexAttrib2d
      glVertexAttrib2dARB
      glVertexAttrib2dNV
      glVertexAttrib2dv
      glVertexAttrib2dvARB
      glVertexAttrib2dvNV
      glVertexAttrib2f
      glVertexAttrib2fARB
      glVertexAttrib2fNV
      glVertexAttrib2fv
      glVertexAttrib2fvARB
      glVertexAttrib2fvNV
      glVertexAttrib2hNV
      glVertexAttrib2hvNV
      glVertexAttrib2s
      glVertexAttrib2sARB
      glVertexAttrib2sNV
      glVertexAttrib2sv
      glVertexAttrib2svARB
      glVertexAttrib2svNV
      glVertexAttrib3d
      glVertexAttrib3dARB
      glVertexAttrib3dNV
      glVertexAttrib3dv
      glVertexAttrib3dvARB
      glVertexAttrib3dvNV
      glVertexAttrib3f
      glVertexAttrib3fARB
      glVertexAttrib3fNV
      glVertexAttrib3fv
      glVertexAttrib3fvARB
      glVertexAttrib3fvNV
      glVertexAttrib3hNV
      glVertexAttrib3hvNV
      glVertexAttrib3s
      glVertexAttrib3sARB
      glVertexAttrib3sNV
      glVertexAttrib3sv
      glVertexAttrib3svARB
      glVertexAttrib3svNV
      glVertexAttrib4Nbv
      glVertexAttrib4NbvARB
      glVertexAttrib4Niv
      glVertexAttrib4NivARB
      glVertexAttrib4Nsv
      glVertexAttrib4NsvARB
      glVertexAttrib4Nub
      glVertexAttrib4NubARB
      glVertexAttrib4Nubv
      glVertexAttrib4NubvARB
      glVertexAttrib4Nuiv
      glVertexAttrib4NuivARB
      glVertexAttrib4Nusv
      glVertexAttrib4NusvARB
      glVertexAttrib4bv
      glVertexAttrib4bvARB
      glVertexAttrib4d
      glVertexAttrib4dARB
      glVertexAttrib4dNV
      glVertexAttrib4dv
      glVertexAttrib4dvARB
      glVertexAttrib4dvNV
      glVertexAttrib4f
      glVertexAttrib4fARB
      glVertexAttrib4fNV
      glVertexAttrib4fv
      glVertexAttrib4fvARB
      glVertexAttrib4fvNV
      glVertexAttrib4hNV
      glVertexAttrib4hvNV
      glVertexAttrib4iv
      glVertexAttrib4ivARB
      glVertexAttrib4s
      glVertexAttrib4sARB
      glVertexAttrib4sNV
      glVertexAttrib4sv
      glVertexAttrib4svARB
      glVertexAttrib4svNV
      glVertexAttrib4ubNV
      glVertexAttrib4ubv
      glVertexAttrib4ubvARB
      glVertexAttrib4ubvNV
      glVertexAttrib4uiv
      glVertexAttrib4uivARB
      glVertexAttrib4usv
      glVertexAttrib4usvARB
      glVertexAttribArrayObjectATI
      glVertexAttribBinding
      glVertexAttribDivisor
      glVertexAttribDivisorANGLE
      glVertexAttribDivisorARB
      glVertexAttribFormat
      glVertexAttribFormatNV
      glVertexAttribI1i
      glVertexAttribI1iEXT
      glVertexAttribI1iv
      glVertexAttribI1ivEXT
      glVertexAttribI1ui
      glVertexAttribI1uiEXT
      glVertexAttribI1uiv
      glVertexAttribI1uivEXT
      glVertexAttribI2i
      glVertexAttribI2iEXT
      glVertexAttribI2iv
      glVertexAttribI2ivEXT
      glVertexAttribI2ui
      glVertexAttribI2uiEXT
      glVertexAttribI2uiv
      glVertexAttribI2uivEXT
      glVertexAttribI3i
      glVertexAttribI3iEXT
      glVertexAttribI3iv
      glVertexAttribI3ivEXT
      glVertexAttribI3ui
      glVertexAttribI3uiEXT
      glVertexAttribI3uiv
      glVertexAttribI3uivEXT
      glVertexAttribI4bv
      glVertexAttribI4bvEXT
      glVertexAttribI4i
      glVertexAttribI4iEXT
      glVertexAttribI4iv
      glVertexAttribI4ivEXT
      glVertexAttribI4sv
      glVertexAttribI4svEXT
      glVertexAttribI4ubv
      glVertexAttribI4ubvEXT
      glVertexAttribI4ui
      glVertexAttribI4uiEXT
      glVertexAttribI4uiv
      glVertexAttribI4uivEXT
      glVertexAttribI4usv
      glVertexAttribI4usvEXT
      glVertexAttribIFormat
      glVertexAttribIFormatNV
      glVertexAttribIPointer
      glVertexAttribIPointerEXT
      glVertexAttribL1d
      glVertexAttribL1dEXT
      glVertexAttribL1dv
      glVertexAttribL1dvEXT
      glVertexAttribL1i64NV
      glVertexAttribL1i64vNV
      glVertexAttribL1ui64ARB
      glVertexAttribL1ui64NV
      glVertexAttribL1ui64vARB
      glVertexAttribL1ui64vNV
      glVertexAttribL2d
      glVertexAttribL2dEXT
      glVertexAttribL2dv
      glVertexAttribL2dvEXT
      glVertexAttribL2i64NV
      glVertexAttribL2i64vNV
      glVertexAttribL2ui64NV
      glVertexAttribL2ui64vNV
      glVertexAttribL3d
      glVertexAttribL3dEXT
      glVertexAttribL3dv
      glVertexAttribL3dvEXT
      glVertexAttribL3i64NV
      glVertexAttribL3i64vNV
      glVertexAttribL3ui64NV
      glVertexAttribL3ui64vNV
      glVertexAttribL4d
      glVertexAttribL4dEXT
      glVertexAttribL4dv
      glVertexAttribL4dvEXT
      glVertexAttribL4i64NV
      glVertexAttribL4i64vNV
      glVertexAttribL4ui64NV
      glVertexAttribL4ui64vNV
      glVertexAttribLFormat
      glVertexAttribLFormatNV
      glVertexAttribLPointer
      glVertexAttribLPointerEXT
      glVertexAttribP1ui
      glVertexAttribP1uiv
      glVertexAttribP2ui
      glVertexAttribP2uiv
      glVertexAttribP3ui
      glVertexAttribP3uiv
      glVertexAttribP4ui
      glVertexAttribP4uiv
      glVertexAttribParameteriAMD
      glVertexAttribPointer
      glVertexAttribPointerARB
      glVertexAttribPointerNV
      glVertexAttribs1dvNV
      glVertexAttribs1fvNV
      glVertexAttribs1hvNV
      glVertexAttribs1svNV
      glVertexAttribs2dvNV
      glVertexAttribs2fvNV
      glVertexAttribs2hvNV
      glVertexAttribs2svNV
      glVertexAttribs3dvNV
      glVertexAttribs3fvNV
      glVertexAttribs3hvNV
      glVertexAttribs3svNV
      glVertexAttribs4dvNV
      glVertexAttribs4fvNV
      glVertexAttribs4hvNV
      glVertexAttribs4svNV
      glVertexAttribs4ubvNV
      glVertexBindingDivisor
      glVertexBlendARB
      glVertexBlendEnvfATI
      glVertexBlendEnviATI
      glVertexFormatNV
      glVertexP2ui
      glVertexP2uiv
      glVertexP3ui
      glVertexP3uiv
      glVertexP4ui
      glVertexP4uiv
      glVertexPointerEXT
      glVertexPointerListIBM
      glVertexPointervINTEL
      glVertexStream1dATI
      glVertexStream1dvATI
      glVertexStream1fATI
      glVertexStream1fvATI
      glVertexStream1iATI
      glVertexStream1ivATI
      glVertexStream1sATI
      glVertexStream1svATI
      glVertexStream2dATI
      glVertexStream2dvATI
      glVertexStream2fATI
      glVertexStream2fvATI
      glVertexStream2iATI
      glVertexStream2ivATI
      glVertexStream2sATI
      glVertexStream2svATI
      glVertexStream3dATI
      glVertexStream3dvATI
      glVertexStream3fATI
      glVertexStream3fvATI
      glVertexStream3iATI
      glVertexStream3ivATI
      glVertexStream3sATI
      glVertexStream3svATI
      glVertexStream4dATI
      glVertexStream4dvATI
      glVertexStream4fATI
      glVertexStream4fvATI
      glVertexStream4iATI
      glVertexStream4ivATI
      glVertexStream4sATI
      glVertexStream4svATI
      glVertexWeightPointerEXT
      glVertexWeightfEXT
      glVertexWeightfvEXT
      glVertexWeighthNV
      glVertexWeighthvNV
      glVideoCaptureNV
      glVideoCaptureStreamParameterdvNV
      glVideoCaptureStreamParameterfvNV
      glVideoCaptureStreamParameterivNV
      glViewportArrayv
      glViewportIndexedf
      glViewportIndexedfv
      glViewportPositionWScaleNV
      glViewportSwizzleNV
      glWaitSync
      glWaitVkSemaphoreNV
      glWeightPathsNV
      glWeightPointerARB
      glWeightbvARB
      glWeightdvARB
      glWeightfvARB
      glWeightivARB
      glWeightsvARB
      glWeightubvARB
      glWeightuivARB
      glWeightusvARB
      glWindowPos2d
      glWindowPos2dARB
      glWindowPos2dMESA
      glWindowPos2dv
      glWindowPos2dvARB
      glWindowPos2dvMESA
      glWindowPos2f
      glWindowPos2fARB
      glWindowPos2fMESA
      glWindowPos2fv
      glWindowPos2fvARB
      glWindowPos2fvMESA
      glWindowPos2i
      glWindowPos2iARB
      glWindowPos2iMESA
      glWindowPos2iv
      glWindowPos2ivARB
      glWindowPos2ivMESA
      glWindowPos2s
      glWindowPos2sARB
      glWindowPos2sMESA
      glWindowPos2sv
      glWindowPos2svARB
      glWindowPos2svMESA
      glWindowPos3d
      glWindowPos3dARB
      glWindowPos3dMESA
      glWindowPos3dv
      glWindowPos3dvARB
      glWindowPos3dvMESA
      glWindowPos3f
      glWindowPos3fARB
      glWindowPos3fMESA
      glWindowPos3fv
      glWindowPos3fvARB
      glWindowPos3fvMESA
      glWindowPos3i
      glWindowPos3iARB
      glWindowPos3iMESA
      glWindowPos3iv
      glWindowPos3ivARB
      glWindowPos3ivMESA
      glWindowPos3s
      glWindowPos3sARB
      glWindowPos3sMESA
      glWindowPos3sv
      glWindowPos3svARB
      glWindowPos3svMESA
      glWindowPos4dMESA
      glWindowPos4dvMESA
      glWindowPos4fMESA
      glWindowPos4fvMESA
      glWindowPos4iMESA
      glWindowPos4ivMESA
      glWindowPos4sMESA
      glWindowPos4svMESA
      glWindowRectanglesEXT
      glWriteMaskEXT
      )
   ]
);
	
our @EXPORT_OK = ( @{ $EXPORT_TAGS{'all'} } );

our @EXPORT = qw(
	
);

sub AUTOLOAD {
    # This AUTOLOAD is used to 'autoload' constants from the constant()
    # XS function.

    my $constname;
    our $AUTOLOAD;
    ($constname = $AUTOLOAD) =~ s/.*:://;
    croak "&OpenGL::Modern not defined" if $constname eq 'constant';
    my ($error, $val) = constant($constname);
    if ($error) { croak $error; }
    {
    no strict 'refs';
        *$AUTOLOAD = sub { $val };
    }
    goto &$AUTOLOAD;
}

require XSLoader;
XSLoader::load('OpenGL::Modern', $XS_VERSION);

# Preloaded methods go here.

1;
__END__
# Below is stub documentation for your module. You'd better edit it!

=head1 NAME

OpenGL::Modern - Perl extension Modern OpenGL API 3.1 and greater

=head1 SYNOPSIS

  use OpenGL::Modern qw(:all);

=head1 DESCRIPTION

C<OpenGL::Modern> provides perl bindings to the OpenGL
graphics APIs using the OpenGL Extension Wrangler (GLEW)
library.  This file was mostly generated by parsing C<glew.h>.

This module updates the original Perl OpenGL bindings L<OpenGL>
(abbreviated as POGL) to support modern OpenGL.  For
this purpose, modern OpenGL APIs
are those starting with version 3.1 and higher.  OpenGL 3.1 was
the first version where the legacy OpenGL functionality from
versions 1.x-3.0 was fully deprecated.  Much of the functionality
that used to be accessed via the extension mechanism in C<OpenGL>
now is standardized and in the Core.

=head2 EXPORT

None by default.



=head1 SEE ALSO

OpenGL 4.x documentation at L<https://www.opengl.org/sdk/docs/man4/>

Perl OpenGL (POGL) and Perl OpenGL::Modern (POGL2) development
share common resources.  At some point C<OpenGL::Modern> will
replace the legacy C<OpenGL> implementation.  Together they are
referred to as POGL.

Perl OpenGL developer and users lists are at
L<https://sourceforge.net/p/pogl/mailman/?source=navbar>

Perl OpenGL IRC is at #pogl on irc.perl.org

POGL2 development will take place on github and the repository
is being set up there.  The sf.net repository will be the official
release repository and is mirrored from github.

=head1 AUTHOR

Max Maischein , E<lt>corion@cpan.orgE<gt>
Chris Marshall, E<lt>devel.chm.01@gmail.comE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2016 by Max Maischein
Copyright (C) 2016 by Chris Marshall

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.22.0 or,
at your option, any later version of Perl 5 you may have available.


=cut
