# $Id: Makefile.PL 79 2008-09-13 10:17:12Z cfaerber $

use 5.006;

use utf8;
use ExtUtils::MakeMaker;

# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile that is written.
WriteMakefile(
    'NAME'		=> 'Net::IDN::Encode',
    'VERSION_FROM'	=> 'lib/Net/IDN/Encode.pm', # finds $VERSION
    'PREREQ_PM'		=> {
		'Unicode::Stringprep' => 1.00,
	},
    ($] >= 5.005 ? (	## Add these new keywords supported since 5.005
       ABSTRACT => 'modules for handling of Internationalised Domain Names in Applications (IDNA)',
       AUTHOR   => 'Claus Faerber <CFAERBER@cpan.org>',
       LICENSE  => 'perl',
      ) : ()),
);

sub MY::postamble {
return <<EOF
release: release-sf release-cpan

release-cpan:
	cpan-upload \$(DISTVNAME).tar\$(SUFFIX)

release-sf:
	sf-upload -groupid 112466 -packageid 121685 -r \$(VERSION) -cf Changes -nf README -f \$(DISTVNAME).tar\$(SUFFIX)
EOF
}
