
use strict;
use warnings;

use Module::Build 0.3601;


my %module_build_args = (
  "build_requires" => {
    "Module::Build" => "0.3601"
  },
  "configure_requires" => {
    "Module::Build" => "0.3601"
  },
  "dist_abstract" => "Web App Framework",
  "dist_author" => [
    "celogeek <me\@celogeek.com>"
  ],
  "dist_name" => "Jedi",
  "dist_version" => "1.003",
  "license" => "perl",
  "module_name" => "Jedi",
  "recommends" => {},
  "recursive_test_files" => 1,
  "requires" => {
    "B::Hooks::EndOfScope" => 0,
    "CGI::Cookie::XS" => 0,
    "CGI::Deurl::XS" => 0,
    "CHI" => 0,
    "Carp" => 0,
    "Config::Any" => 0,
    "HTTP::Body" => 0,
    "Import::Into" => 0,
    "Module::Runtime" => 0,
    "Moo" => "1.003001",
    "Moo::Role" => 0,
    "MooX::Options" => "4.006",
    "Plack::Runner" => 0,
    "YAML::XS" => 0,
    "autobox" => 0,
    "feature" => 0,
    "lib" => 0,
    "perl" => "5.010",
    "strict" => 0,
    "warnings" => 0
  },
  "script_files" => [
    "bin/perl-jedi"
  ],
  "test_requires" => {
    "File::Spec" => 0,
    "FindBin" => 0,
    "HTTP::Request::Common" => 0,
    "IO::Handle" => 0,
    "IPC::Open3" => 0,
    "JSON" => 0,
    "Path::Class" => 0,
    "Plack::Test" => 0,
    "Scalar::Util" => 0,
    "Slurp" => 0,
    "Test::More" => "0.94",
    "Test::Most" => 0,
    "perl" => "5.010"
  }
);


my %fallback_build_requires = (
  "File::Spec" => 0,
  "FindBin" => 0,
  "HTTP::Request::Common" => 0,
  "IO::Handle" => 0,
  "IPC::Open3" => 0,
  "JSON" => 0,
  "Module::Build" => "0.3601",
  "Path::Class" => 0,
  "Plack::Test" => 0,
  "Scalar::Util" => 0,
  "Slurp" => 0,
  "Test::More" => "0.94",
  "Test::Most" => 0,
  "perl" => "5.010"
);


unless ( eval { Module::Build->VERSION(0.4004) } ) {
  delete $module_build_args{test_requires};
  $module_build_args{build_requires} = \%fallback_build_requires;
}

my $build = Module::Build->new(%module_build_args);

$build->create_build_script;
