package Firewall::Config::Element::Role;

#------------------------------------------------------------------------------
# 加载扩展模块
#------------------------------------------------------------------------------
use Moose::Role;
use namespace::autoclean;

# no warnings 'uninitialized';

#------------------------------------------------------------------------------
# 定义 Firewall::Config::Element::Role 方法属性
#------------------------------------------------------------------------------
has fwId => (is => 'ro', isa => 'Int|Undef', required => 0,);

#------------------------------------------------------------------------------
# sign 属性签名算法 | 懒加载，确实需要时加载
#------------------------------------------------------------------------------
has sign => (is => 'ro', isa => 'Str', lazy => 1, builder => '_buildSign',);

#------------------------------------------------------------------------------
# config 属性的具体配置
#------------------------------------------------------------------------------
has config => (
  is       => 'ro',
  isa      => 'ArrayRef',
  required => 0,
  traits   => ['Array'],
  handles  => {addConfig => 'push', insertConfig => 'unshift'}
);

#------------------------------------------------------------------------------
# 继续 Firewall::Config::Element::Role 必须实现 _buildSign 方法
#------------------------------------------------------------------------------
requires '_buildSign';

#------------------------------------------------------------------------------
# 生成sign的辅助函数，用来统一记录连接符，这样修改的时候会很简单
#------------------------------------------------------------------------------
sub createSign {
  my $self = shift;

  # 边界条件判断
  # confess "ERROR: 用于生成 sign 的参数成员不能是 undefined" if grep { not defined } @_;
  return (join('<|>', @_));
}

1;
