/*
 * Decompiled with CFR 0.152.
 */
package org.ttt.salt.dom.tbx;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.xerces.dom.DocumentImpl;
import org.ttt.salt.TBXException;
import org.ttt.salt.dom.tbx.TBXElement;
import org.ttt.salt.dom.tbx.TBXElementDocument;
import org.ttt.salt.dom.tbx.TBXParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Locator;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TBXDocument
extends DocumentImpl
implements Document {
    public static final String RCSID = "$Id: TBXDocument.java 1 2008-05-23 03:51:58Z lanhel $";
    private static final Logger LOGGER = Logger.getLogger("org.ttt.salt.tbx");
    public static final String PREFIX = "org.ttt.salt.dom.tbx.Element_";
    private final Date created = new Date();
    private final boolean hardRef;
    private TBXElementDocument tbxDocElem;
    private SortedSet<TBXException> exceptions = new TreeSet<TBXException>();

    public TBXDocument(boolean hardref) {
        this.hardRef = hardref;
    }

    @Override
    public Element getDocumentElement() {
        return this.hardRef ? super.getDocumentElement() : this.tbxDocElem;
    }

    public SortedSet<TBXException> getParseExceptions() {
        return this.exceptions;
    }

    public void addParseException(TBXException err) {
        this.exceptions.add(err);
    }

    public TBXElement createTBXElement(String tagName, Locator loc) throws SAXParseException {
        if (this.errorChecking && !TBXDocument.isXMLName(tagName, true)) {
            super.createElement(tagName);
        }
        TBXElement ret = null;
        try {
            try {
                Class<?> clazz = Class.forName(PREFIX + tagName, true, this.getClass().getClassLoader());
                Constructor<?> cstrct = clazz.getConstructor(TBXDocument.class, String.class, Locator.class);
                ret = (TBXElement)cstrct.newInstance(this, tagName, loc);
            }
            catch (ClassNotFoundException err) {
                if (!TBXParser.KNOWN_MISSING.contains(tagName)) {
                    Logger.getLogger("org.ttt.salt.dom.tbx").log(Level.INFO, "Unknown TBX Element: {0}", tagName);
                }
                ret = new TBXElement(this, tagName, loc);
            }
            if (tagName.equals("martif")) {
                this.docElement = ret;
                if (!this.hardRef) {
                    this.tbxDocElem = new TBXElementDocument(this, tagName, loc, this.docElement);
                }
            }
        }
        catch (NoSuchMethodException err) {
            Logger.getLogger("org.ttt.salt.dom.tbx").log(Level.SEVERE, "Invalid TBX Class: {0}", tagName);
            throw new SAXParseException("Invalid TBX Class", loc, err);
        }
        catch (InstantiationException err) {
            Logger.getLogger("org.ttt.salt.dom.tbx").log(Level.SEVERE, "TBX class not concrete: {0}", tagName);
            throw new SAXParseException("TBX class not concrete", loc, err);
        }
        catch (IllegalAccessException err) {
            Logger.getLogger("org.ttt.salt.dom.tbx").log(Level.SEVERE, "TBX constructor not accessible on {0}", tagName);
            throw new SAXParseException("TBX constructor not accessible", loc, err);
        }
        catch (InvocationTargetException err) {
            Logger.getLogger("org.ttt.salt.dom.tbx").log(Level.SEVERE, "TBX element {0} creation error", tagName);
            throw new SAXParseException("TBX element creation error", loc, err);
        }
        return ret;
    }

    @Override
    public Element createElement(String tagName) {
        try {
            return this.createTBXElement(tagName, null);
        }
        catch (SAXParseException err) {
            throw new IllegalStateException(String.format("Error creating TBXElement: %s", tagName), err);
        }
    }
}

