package Acme::MetaSyntactic::pooh;
use strict;
use Acme::MetaSyntactic::List;
our @ISA = qw( Acme::MetaSyntactic::List );
our $VERSION = '1.000';
__PACKAGE__->init();
1;

=head1 NAME

Acme::MetaSyntactic::pooh - The characters from I<Winnie-the-Pooh> theme

=head1 DESCRIPTION

Characters from the classics I<Winnie-the-Pooh> (1926)
and I<The House at Pooh Corner> (1928), by A. A. Milne.

=head1 BUGS

Disney shouldn't have touched Pooh.

=head1 NOT A BUG

I<Winnie-the-Pooh> is the correct spelling, no matter what Disney says.

=head1 CONTRIBUTORS

Original contributor: Abigail (late October 2005)

Proposed independently a week later (early November 2005) by Leon Brocard,
with a few additions.

Introduced in Acme-MetaSyntactic version 0.61, published on February 13, 2006.

Updated in version 0.64, published on March 6, 2006.

Received its own version number for Acme-MetaSyntactic-Themes version 1.000,
published on May 7, 2012.

=head1 SEE ALSO

L<Acme::MetaSyntactic>, L<Acme::MetaSyntactic::List>.

=cut

__DATA__
# names
Winnie_the_Pooh Christopher_Robin Piglet
Eeyore Owl Rabbit Kanga Roo Tigger
Small Heffalump Woozle
Wizzle Alexander_Beetle Hunny_Bee Jagular
Backson Henry_Pootel Henry_Rush Smallest_of_all Uncle_Robert
